!
! nunfunc is called instead of numfuncrec, in this version,
! only in the multiprecision routines.
!
 module dimensions 
  implicit none                    
  integer, public :: dmns,dmns_d,dmns_c,dmns_b,dmns_a
  contains
! 
  subroutine load_dimensions
  use maxnumden
  implicit none
  dmns  = maxden
  dmns_a=        2**(maxden-1)
  dmns_b= dmns_a+2**(maxden-2)
  dmns_c= dmns_b+2**(maxden-3)
  dmns_d= dmns_c+2**(maxden-4)
  end subroutine
 end module dimensions 
!
 module scale
  include 'cts_mprec.h'
  implicit none                    
  include 'cts_dpr.h'
, public :: roots,limit,musq,muscale
  integer, public :: n_mp= 0, n_disc= 0, scaloop
  logical, public :: mpflag
  logical, public :: stablen=.true.
  include 'cts_dpr.h'
   , public :: llimit= 0.3d0
  include 'cts_dpc.h' 
   :: aus
 end module scale
!
 module qt2value
  include 'cts_mprec.h'
  include 'cts_dpc.h'
   , public :: qt2
  include 'cts_mpc.h'
   , public :: mpqt2
  logical, public :: rational=.false. 
 end module qt2value
!
 module denominators
  include 'cts_mprec.h'
  use def_propagator                                       
  use def_mp_propagator                                       
  use qt2value
  use combinatorics
  implicit none
  type(propagator), dimension(:), public, allocatable :: den
  type(mp_propagator), dimension(:), public, allocatable :: mp_den
  integer ierr
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: vden
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_vden
  save den,vden
!
  interface load_denominators
    module procedure load_dp_denominators
    module procedure load_mp_denominators
  end interface!load_denominators
!
  interface initden
    module procedure dp_initden
    module procedure mp_initden
  end interface!initden
!
  interface value
    module procedure dp_value
    module procedure mp_value
  end interface!value
!
  interface load_vden
    module procedure dp_load_vden
    module procedure mp_load_vden
  end interface!load_vden
!
  contains
!
  subroutine load_dp_denominators(denvec,nden)
   integer :: nden
   type(propagator), intent(in) :: denvec(0:nden-1)
   include 'cts_dpr.h' 
    :: p
   integer :: k
   integer(kind=8) :: twotok
   if (nden.gt.dimension_den) stop 'too many denominators in input!'
   call initden(p)
   do k=0,nden-1
! comment1
      twotok= 2**k
      den(twotok)=denvec(k)
      den(twotok)%i=twotok
   enddo
  end subroutine load_dp_denominators
!
  subroutine load_mp_denominators(denvec,nden)
   integer :: nden
   type(mp_propagator), intent(in) :: denvec(0:nden-1)
   include 'cts_mpr.h' 
    :: p
   integer(kind=8) :: twotok
   integer :: k
   if (nden.gt.dimension_den) stop 'too many denominators in input!'
   call initden(p)
   do k=0,nden-1
! comment1
      twotok= 2**k
      mp_den(twotok)=denvec(k)
      mp_den(twotok)%i=twotok
   enddo
  end subroutine load_mp_denominators
!
  subroutine dp_initden(p)
  use dimensions
  include 'cts_dpr.h' 
   :: p
  integer :: j,kk,k
  do j= 1,dmns
   kk= string(j)
   den(kk)%i = -1
   den(kk)%m2= 0.d0
   do k= 0,3
    den(kk)%p(k) = 0.d0
   enddo
  enddo
  end subroutine dp_initden
!
  subroutine mp_initden(p)
  use dimensions
  include 'cts_mpr.h' 
   :: p
  integer :: j,kk,k
  do j= 1,dmns
   kk= string(j)
   mp_den(kk)%i = -1
   mp_den(kk)%m2= 0.d0
   do k= 0,3
    mp_den(kk)%p(k) = 0.d0
   enddo
  enddo
  end subroutine mp_initden
!
  function dp_value(den,q)
   use tensor_operations  
   include 'cts_dpc.h' 
    :: dp_value
   type(propagator), intent (in) :: den
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_dpc.h'
    , dimension(0:3) :: qp
   include 'cts_dpc.h' 
    :: qp2
   integer :: k
   do k= 0,3
    qp(k)= q(k)+den%p(k)
   enddo
   call contr(qp,qp,qp2)
   dp_value = qp2-den%m2+qt2
  end function dp_value
!
  function mp_value(den,q)
   use tensor_operations  
   include 'cts_mpc.h' 
    :: mp_value
   type(mp_propagator), intent (in) :: den
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_mpc.h'
    , dimension(0:3) :: qp
   include 'cts_mpc.h' 
    :: qp2
   integer :: k
   do k= 0,3
    qp(k)= q(k)+den%p(k)
   enddo
   call contr(qp,qp,qp2)
   mp_value = qp2-den%m2+mpqt2
  end function mp_value
!
  subroutine dp_allocate_den
   use dimensions
   allocate (vden(1:dmns_a, max_solutions), stat=ierr)
   allocate (den(1:dmns_a), stat=ierr)
  end subroutine dp_allocate_den
!
  subroutine mp_allocate_den
   use dimensions
   allocate (mp_vden(1:dmns_a, max_solutions), stat=ierr)
   allocate (mp_den(1:dmns_a), stat=ierr)
  end subroutine mp_allocate_den
!
  subroutine dp_load_vden(q,i,j)
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: i,j
   if (den(i)%i.gt.0) vden(i,j) = value(den(i),q)
  end subroutine dp_load_vden
!
  subroutine mp_load_vden(q,i,j)
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: i,j
   if (mp_den(i)%i.gt.0) mp_vden(i,j) = value(mp_den(i),q)
  end subroutine mp_load_vden
 end module denominators
!
 module cuttings
  use tensor_operations  
  use def_solcut
  use def_mp_solcut
  use denominators
  use constants
  implicit none
  integer, private :: i,j,kk
  interface cut
   module procedure dp_cutting4
   module procedure dp_cutting3
   module procedure dp_cutting2
   module procedure dp_cutting1_newbase
   module procedure mp_cutting4
   module procedure mp_cutting3
   module procedure mp_cutting2
   module procedure mp_cutting1_newbase
  end interface!cut
!
  interface build_l
   module procedure dp_build_l
   module procedure mp_build_l
  end interface!build_l
  contains
!
  subroutine dp_build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,ga)  
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpr.h'
    , intent(in), dimension(0:3) :: k1,k2
   include 'cts_dpc.h'
    , intent(out), dimension(0:3) :: l1,l2,l3,l4
   include 'cts_dpc.h'
    , intent(out) :: al1,al2,bet,ga 
   include 'cts_dpr.h'
    :: k1k1,k1k2,k2k2
   include 'cts_dpc.h' 
    :: del12,b1p,b1m,b2p,b2m,c1p,c1m,c2p,c2m,ausp,ausm
   integer :: k
   call contr(k1,k1,k1k1)
   call contr(k1,k2,k1k2)
   call contr(k2,k2,k2k2)
   del12= (k1k2*k1k2-k1k1*k2k2)*c1(p)
   if (k1k2.gt.0.d0) then
    ga= k1k2+sqrt(del12)
   else
    ga= k1k2-sqrt(del12)
   endif
   al1= k1k1/ga
   al2= k2k2/ga
   bet= c1(p)/(c1(p)-al1*al2)
   do k= 0,3
    l1(k)= bet*(k1(k)-al1*k2(k))
    l2(k)= bet*(k2(k)-al2*k1(k))
   enddo
   ausm= l1(0)-l1(3)
   ausp= l1(0)+l1(3)
   if (abs(ausm).gt.abs(ausp)) then 
    c1p= sqrt(ausm)
    c1m= c1p
    b1p= (l1(1)-ci(p)*l1(2))/c1p
    b1m= (l1(1)+ci(p)*l1(2))/c1p
   else
    b1p= sqrt(ausp)
    b1m= b1p
    c1p= (l1(1)+ci(p)*l1(2))/b1p
    c1m= (l1(1)-ci(p)*l1(2))/b1p
   endif
   ausm= l2(0)-l2(3)
   ausp= l2(0)+l2(3)
   if (abs(ausm).gt.abs(ausp)) then 
    c2p= sqrt(ausm)
    c2m= c2p
    b2p= (l2(1)-ci(p)*l2(2))/c2p
    b2m= (l2(1)+ci(p)*l2(2))/c2p
   else
    b2p= sqrt(ausp)
    b2m= b2p
    c2m= (l2(1)-ci(p)*l2(2))/b2p
    c2p= (l2(1)+ci(p)*l2(2))/b2p
   endif
   l3(0)=     b1m*b2p  + c1m*c2p
   l3(1)=     b1m*c2p + c1m*b2p
   l3(2)= ci(p)*(c1m*b2p - b1m*c2p)
   l3(3)=     b1m*b2p  - c1m*c2p  
   l4(0)=     b2m*b1p  + c2m*c1p
   l4(1)=     b2m*c1p + c2m*b1p
   l4(2)= ci(p)*(c2m*b1p - b2m*c1p)
   l4(3)=     b2m*b1p  - c2m*c1p
  end subroutine dp_build_l
!
  subroutine mp_build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,ga)  
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpr.h'
    , intent(in), dimension(0:3) :: k1,k2
   include 'cts_mpc.h'
    , intent(out), dimension(0:3) :: l1,l2,l3,l4
   include 'cts_mpc.h'
    , intent(out) :: al1,al2,bet,ga 
   include 'cts_mpr.h'
    :: k1k1,k1k2,k2k2
   include 'cts_mpc.h' 
    :: del12,b1p,b1m,b2p,b2m,c1p,c1m,c2p,c2m,ausp,ausm
   integer :: k
   call contr(k1,k1,k1k1)
   call contr(k1,k2,k1k2)
   call contr(k2,k2,k2k2)
   del12= (k1k2*k1k2-k1k1*k2k2)*c1(p)
   if (k1k2.gt.0.d0) then
    ga= k1k2+sqrt(del12)
   else
    ga= k1k2-sqrt(del12)
   endif
   al1= k1k1/ga
   al2= k2k2/ga
   bet= c1(p)/(c1(p)-al1*al2)
   do k= 0,3
    l1(k)= bet*(k1(k)-al1*k2(k))
    l2(k)= bet*(k2(k)-al2*k1(k))
   enddo
   ausm= l1(0)-l1(3)
   ausp= l1(0)+l1(3)
   if (abs(ausm).gt.abs(ausp)) then 
    c1p= sqrt(ausm)
    c1m= c1p
    b1p= (l1(1)-ci(p)*l1(2))/c1p
    b1m= (l1(1)+ci(p)*l1(2))/c1p
   else
    b1p= sqrt(ausp)
    b1m= b1p
    c1p= (l1(1)+ci(p)*l1(2))/b1p
    c1m= (l1(1)-ci(p)*l1(2))/b1p
   endif
   ausm= l2(0)-l2(3)
   ausp= l2(0)+l2(3)
   if (abs(ausm).gt.abs(ausp)) then 
    c2p= sqrt(ausm)
    c2m= c2p
    b2p= (l2(1)-ci(p)*l2(2))/c2p
    b2m= (l2(1)+ci(p)*l2(2))/c2p
   else
    b2p= sqrt(ausp)
    b2m= b2p
    c2m= (l2(1)-ci(p)*l2(2))/b2p
    c2p= (l2(1)+ci(p)*l2(2))/b2p
   endif
   l3(0)=     b1m*b2p  + c1m*c2p
   l3(1)=     b1m*c2p + c1m*b2p
   l3(2)= ci(p)*(c1m*b2p - b1m*c2p)
   l3(3)=     b1m*b2p  - c1m*c2p  
   l4(0)=     b2m*b1p  + c2m*c1p
   l4(1)=     b2m*c1p + c2m*b1p
   l4(2)= ci(p)*(c2m*b1p - b2m*c1p)
   l4(3)=     b2m*b1p  - c2m*c1p
  end subroutine mp_build_l
!
  subroutine dp_cutting4(den0,den1,den2,den3,cut4)
   use dimensions
   include 'cts_dpr.h' 
    :: p
   type(propagator), intent(in) :: den0,den1,den2,den3
   type(solcut4) ,intent(out) :: cut4
   include 'cts_dpr.h'
    , dimension(0:3) :: p0,p1,p2,p3,k1,k2,k3
   include 'cts_dpr.h'
    :: k1k1,k2k2,k3k3
   include 'cts_dpc.h'
    :: m02,m12,m22,m32
   include 'cts_dpc.h'
    :: dd0,dd1,dd2,dd3
   include 'cts_dpc.h'
    :: l1k3,l2k3,l3k3,l4k3,x10,x20,x3p,x4p,x3m,x4m
   include 'cts_dpc.h'
    :: cc,ca3,cb3,root,cb3p,cb3m,al1,al2,bet,gm,z
   include 'cts_dpc.h'
    , dimension(0:3) :: l1,l2,l3,l4
   include 'cts_dpc.h' 
    :: ps(0:3),psq(0:3),pspsq,res 
   integer :: k
!
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
   p3= den3%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
   m32= den3%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
    k3(k)= p3(k)-p0(k)
   enddo
! 
   call contr(k1,k1,k1k1)
   call contr(k2,k2,k2k2)
   call contr(k3,k3,k3k3)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
!
   call contr(l1,k3,l1k3)
   call contr(l2,k3,l2k3)
   call contr(l3,k3,l3k3)
   call contr(l4,k3,l4k3)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   dd3= m32-k3k3
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   ca3= -l3k3/l4k3
   cb3= (dd3-dd0-2.d0*x10*l1k3-2.d0*x20*l2k3)/2.d0/l4k3
   root= sqrt(cb3**2+4.d0*cc*ca3)
   cb3p= cb3+root
   cb3m= cb3-root
   if (abs(cb3m).ge.abs(cb3p)) then 
     x3p= (-cb3m)/2.d0/ca3
     x3m= -cc/ca3/x3p
     x4m= (cb3m)/2.d0
     x4p= -cc*ca3/x4m
! 
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   else
     x3m= (-cb3p)/2.d0/ca3
     x3p= -cc/ca3/x3m
     x4p= (cb3p)/2.d0
     x4m= -cc*ca3/x4p
!      
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   endif   
!
!  the 2 solutions, the basis and the vector t
! 
!   q(1)= q^+
!   q(2)= q^-
!
   do i= 0,3
    cut4%q(i,1)= -p0(i)+x10*l1(i)+x20*l2(i)+x3p*l3(i)+x4p*l4(i)
    cut4%q(i,2)= -p0(i)+x10*l1(i)+x20*l2(i)+x3m*l3(i)+x4m*l4(i)
    cut4%l1(i)= l1(i)
    cut4%l2(i)= l2(i)
    cut4%l3(i)= l3(i)
    cut4%l4(i)= l4(i)
    cut4%t(i) = l3(i)*l4k3-l4(i)*l3k3
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,2
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i.or. &
         kk.eq.den3%i) then
      vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut4%q(:,i),kk,i)
      do k= 0,3
       ps(k)  = den(kk)%p(k)-p0(k)
       psq(k) = ps(k)+2.d0*(cut4%q(k,i)+p0(k))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-den(kk)%m2
      res= res+pspsq
      vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine dp_cutting4  
!
  subroutine dp_cutting3(den0,den1,den2,cut3,dmr)
   use dimensions
   include 'cts_dpr.h' 
    :: p
   type(propagator), intent(in) :: den0,den1,den2
   type(solcut3), intent(out) :: cut3
   integer, intent(in) ::  dmr
   include 'cts_dpr.h'
    , dimension(0:3) :: p0,p1,p2,k1,k2
   include 'cts_dpr.h'
    :: k1k1,k2k2,phi
   include 'cts_dpc.h'
    :: m02,m12,m22
   include 'cts_dpc.h'
    :: dd0,dd1,dd2
   include 'cts_dpc.h'
    :: x10,x20,x3,x4,q3caus
   include 'cts_dpc.h'
    :: cc,tau,ca3,al1,al2,bet,gm,z,cc4 
   include 'cts_dpc.h'
    :: ps(0:3),psq(0:3),pspsq,res 
   include 'cts_dpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   integer :: k,nsol
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
   enddo
!
   call contr(k1,k1,k1k1)
   call contr(k2,k2,k2k2)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   cut3%gm= gm
   cut3%cc= cc
   do i= 0,3
    cut3%l1(i)= l1(i)
    cut3%l2(i)= l2(i)
    cut3%l3(i)= l3(i)
    cut3%l4(i)= l4(i)
   enddo
   cc4= cc**4
   if  (abs(cc4).gt.tiny(p)) then
    phi= atan2(dimag(cc4),dreal(cc4))
   else
    phi= 0.d0
   endif
   tau= exp(ci(p)/8.d0*(pi(p)-phi))
   cut3%tau= tau
   if (dmr.eq.0) then
    if (rational) then
     nsol= 3
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,3) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    else
     nsol= 7
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**2
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,3) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**6
      x3= cc/x4
      cut3%q(i,4) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,5) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**2
      x4= cc/x3
      cut3%q(i,6) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**4
      x4= cc/x3
      cut3%q(i,7) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    endif
   elseif (dmr.eq.1) then
    if (rational) then
     nsol= 2
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
     enddo
    else
     nsol= 5
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**6
      x3= cc/x4
      cut3%q(i,3) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,4) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**4
      x4= cc/x3
      cut3%q(i,5) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    endif
   elseif (dmr.eq.2) then
    nsol= 3
    do i= 0,3
     q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
     x4= c1(p)
     x3= cc/x4
     cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
     x4= (cexp4(p))**4
     x3= cc/x4
     cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
     x3= c1(p)
     x4= cc/x3
     cut3%q(i,3) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
    enddo
   else
    nsol= 1
    do i= 0,3
     q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
     x4= c1(p)
     x3= cc/x4
     cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i) then
      vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut3%q(:,i),kk,i)
      do k= 0,3
       ps(k)  = den(kk)%p(k)-p0(k)
       psq(k) = ps(k)+2.d0*(cut3%q(k,i)+p0(k))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-den(kk)%m2
      res= res+pspsq
      vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
   end subroutine dp_cutting3  
!
  subroutine dp_cutting2(den0,den1,cut2,dmr)
   use dimensions
   include 'cts_dpr.h' 
    :: p,a,b,c
   type(propagator), intent(in) :: den0,den1
   type(solcut2), intent(out) :: cut2
   integer, intent(in) ::  dmr
   include 'cts_dpr.h'
    , dimension(0:3) :: p0,p1,k1,v
   include 'cts_dpr.h'
    :: k1k1,factor,phi
   include 'cts_dpc.h'
    :: m02,m12,ak,a0,a1
   include 'cts_dpc.h'
    :: dd0,dd1
   integer :: k,nsol
   include 'cts_dpc.h' 
    :: yv0,yvsigma,yvlambda,y3,y4
   include 'cts_dpc.h' 
    :: tau,taul,cc3,al,al2,bet,gm,cf0,cflambda,cfsigma,q2caus
   include 'cts_dpc.h' 
    :: ps(0:3),psq(0:3),pspsq,res 
   include 'cts_dpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4

   p0= den0%p 
   p1= den1%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
   enddo
!
   call contr(k1,k1,k1k1)
!
!  define the arbitrary massless 4-vector v
!
!-comment
    a= 1.d0   
    v(0)= sign(a,k1(0))         
    v(1)=-sign(a/root3(p),k1(1))
    v(2)=-sign(a/root3(p),k1(2))
    v(3)=-sign(a/root3(p),k1(3))
!-comment
   call build_l(k1,v,l1,l2,l3,l4,al,al2,bet,gm)
   cut2%gm= gm
   cut2%rat1= (den0%m2+den1%m2-k1k1/3.d0) 
   dd0= m02
   dd1= m12-k1k1
   do i= 0,3
    cut2%l3(i)= l3(i)
    cut2%l4(i)= l4(i)
    cut2%k1(i)= k1(i)
    cut2%v(i) = v(i)
   enddo
   cf0     = -0.25d0/gm*(m02*c1(p))
   cut2%cf0= cf0 
   yv0     =  (dd1-dd0)*c1(p)/gm
   if (dmr.eq.0) then
    a0= (sigma(p)+c1(p))
    ak= sigma(p)*a0
    a1= -sigma(p)
    cfsigma= a0*m02+a1*m12+ak*k1k1
    cfsigma= -0.25d0/gm*cfsigma
    cut2%cfsigma = cfsigma
    a0= -c1(p)
    a1=  c1(p)
    ak=-(c1(p)+2.d0*sigma(p))
    yvsigma= a0*m02+a1*m12+ak*k1k1
    yvsigma= yvsigma/gm
   endif
   if (dmr.le.1) then
    a0= (lambda(p)+c1(p))
    ak= lambda(p)*a0
    a1= -lambda(p)
    cflambda= a0*m02+a1*m12+ak*k1k1
    cflambda= -0.25d0/gm*cflambda
    cut2%cflambda= cflambda
    a0= -c1(p)
    a1=  c1(p)
    ak=-(c1(p)+2.d0*lambda(p))
    yvlambda= a0*m02+a1*m12+ak*k1k1
    yvlambda= yvlambda/gm
   endif
   if (dmr.eq.0) then
    cc3= cf0**3
    if  (abs(cc3).gt.tiny(p)) then
     phi= atan2(dimag(cc3),dreal(cc3))
    else
     phi= 0.d0
    endif
    tau= exp(ci(p)/6.d0*(pi(p)-phi))
    cut2%tau= tau
    if (rational) then
     nsol= 1
     do i= 0,3
      q2caus= -p0(i)*c1(p)+yv0*v(i)
      y4= c1(p)
      y3= cf0/y4 
      cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
     enddo
    else
     nsol= 9
     cc3= cflambda**2
     if  (abs(cc3).gt.tiny(p)) then
      phi= atan2(dimag(cc3),dreal(cc3))
     else
      phi= 0.d0
     endif
     taul= exp(ci(p)/4.d0*(pi(p)-phi))
     cut2%taul= taul
     do i= 0,3
      q2caus= -p0(i)*c1(p)+yv0*v(i)
      y4= c1(p)
      y3= cf0/y4 
      cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y4= cexp3(p)**2
      y3= cf0/y4 
      cut2%q(i,2) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y4= cexp3(p)**4
      y3= cf0/y4 
      cut2%q(i,3) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y3= c1(p)
      y4= cf0/y3 
      cut2%q(i,4) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
      y3= cexp3(p)**2
      y4= cf0/y3 
      cut2%q(i,5) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
      q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
      y4= c1(p)
      y3= cflambda/y4 
      cut2%q(i,6) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
!
      cut2%q(i,7) = q2caus-y3*taul*l3(i)-y4/taul*l4(i)   
!
      y3= c1(p)
      y4= cflambda/y3 
      cut2%q(i,8) = q2caus+y3*l3(i)/taul+y4*taul*l4(i)   
!
      q2caus= -p0(i)*c1(p)+sigma(p)*c1(p)*k1(i)+yvsigma*v(i)
      y4= c1(p)
      y3= cfsigma/y4 
      cut2%q(i,9) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
     enddo
    endif
   elseif (dmr.eq.1) then
    nsol= 4
    cc3= cf0**2
    if  (abs(cc3).gt.tiny(p)) then
     phi= atan2(dimag(cc3),dreal(cc3))
    else
     phi= 0.d0
    endif
    tau= exp(ci(p)/4.d0*(pi(p)-phi))
    cut2%tau= tau
    taul= c1(p)
    cut2%taul= taul
    do i= 0,3
     q2caus= -p0(i)*c1(p)+yv0*v(i)
     y4= c1(p)
     y3= cf0/y4 
     cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
     y4= cexp1(p)
     y3= cf0/y4 
     cut2%q(i,2) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
     y3= c1(p)
     y4= cf0/y3 
     cut2%q(i,3) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
     q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
     y4= c1(p)
     y3= cflambda/y4 
     cut2%q(i,4) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
    enddo
   elseif (dmr.eq.2) then
    nsol= 1
    tau = c1(p)
    cut2%tau= tau
    do i= 0,3
     q2caus= -p0(i)*c1(p)+yv0*v(i)
     y4= c1(p)
     y3= cf0/y4 
     cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i) then
      vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut2%q(:,i),kk,i)
      do k= 0,3
       ps(k)  = den(kk)%p(k)-p0(k)
       psq(k) = ps(k)+2.d0*(cut2%q(k,i)+p0(k))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-den(kk)%m2
      res= res+pspsq
      vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine dp_cutting2  
!
  subroutine dp_cutting1_oldbase(den0,cut1,dmr)
   use dimensions
   include 'cts_dpr.h' 
    :: p,a,b,c
   type(propagator), intent(in) :: den0
   type(solcut1), intent(out) :: cut1
   include 'cts_dpr.h'
    , dimension(0:3) :: p0,v,k
   include 'cts_dpc.h' 
    :: m02
   include 'cts_dpc.h' 
    :: al1,al2,bet,gm
   include 'cts_dpc.h' 
    :: cf0
   integer :: nsol,ky
   integer, intent(in) :: dmr
   include 'cts_dpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   include 'cts_dpc.h' 
    :: ps(0:3),psq(0:3),pspsq,res 
   logical :: computing=.true.
   save computing,v,k
   if (computing) then
     computing=.false.
!    define the arbitrary massless 4-vectors v and k
!-comment
     v(0)= 1.d0
     v(1)= v(0)/root3(p)
     v(2)= v(0)/root3(p)
     v(3)= v(0)/root3(p)
!
     k(0)= 1.d0
     k(1)=-k(0)/root3(p)
     k(2)=-k(0)/root3(p)
     k(3)=-k(0)/root3(p)
!-comment
   endif
   p0 = den0%p 
   m02= den0%m2-qt2 
   call build_l(v,k,l1,l2,l3,l4,al1,al2,bet,gm)
   cut1%gm= gm
! 
   cf0      = -0.25d0/gm*(m02*c1(p))
   cut1%cf0 = cf0
   if (dmr.eq.0) then
    nsol= 5
    do i= 0,3
     cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
     cut1%q(i,2) = -p0(i)-cf0*tau11(p)*l3(i)-l4(i)/tau11(p)
     cut1%q(i,3) =  cut1%q(i,1)+v(i)
     cut1%q(i,4) =  cut1%q(i,1)+k(i)
     cut1%q(i,5) = -p0(i)+cexpk1(p)*tau12(p)*tau11(p)*l3(i) &
                    +cf0/cexpk1(p)*l4(i)/tau11(p)/tau12(p)
     cut1%v(i)   = v(i)
     cut1%k(i)   = k(i)
     cut1%l3(i)  = l3(i)
     cut1%l4(i)  = l4(i)
    enddo
   elseif (dmr.eq.1) then
    nsol= 1
    do i= 0,3
     cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i) then
      vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut1%q(:,i),kk,i)
      do ky= 0,3
       ps(ky)  = den(kk)%p(ky)-p0(ky)
       psq(ky) = ps(ky)+2.d0*(cut1%q(ky,i)+p0(ky))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-den(kk)%m2
      res= res+pspsq
      vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine dp_cutting1_oldbase
!
  subroutine dp_cutting1_newbase(den0,cut1,dmr)
   use dimensions
   include 'cts_dpr.h' 
    :: p,a,b,c
   type(propagator), intent(in) :: den0
   type(solcut1), intent(out) :: cut1
   integer, intent(in) ::  dmr
   include 'cts_dpr.h'
    , dimension(0:3) :: p0,v,k
   include 'cts_dpc.h' 
    :: m02,apar,root 
   include 'cts_dpc.h' 
    :: al1,al2,bet,gm
   include 'cts_dpc.h' 
    :: cf0
   include 'cts_dpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   include 'cts_dpc.h' 
    :: ps(0:3),psq(0:3),pspsq,res 
   integer :: ky,nsol
   logical :: computing=.true.
   save computing,v,k,l3,l4 
   if (computing) then
!    define the arbitrary massless 4-vectors v and k
     computing=.false.
!-comment
     k(0) = 1.d0
     k(1) = 0.d0 
     k(2) = 0.d0
     k(3) = 0.d0

     v(0) = 0.d0
     v(1) = 1.d0 
     v(2) = 0.d0
     v(3) = 0.d0

     l3(0)= 0.d0
     l3(1)= 0.d0 
     l3(2)= 1.d0
     l3(3)= 0.d0

     l4(0)= 0.d0
     l4(1)= 0.d0 
     l4(2)= 0.d0
     l4(3)= 1.d0
!-comment
   endif
   do i= 0,3
    cut1%v(i)   = v(i)
    cut1%k(i)   = k(i)
    cut1%l3(i)  = l3(i)
    cut1%l4(i)  = l4(i)
   enddo
   p0 = den0%p 
   m02= den0%m2-qt2 
   ky= 0
 1 ky= ky+1
   apar= sqrt(c1(p)*ky+qt2)
   root= sqrt((apar**2+m02)/3.d0)
   if (abs(root).le.abs(c1(p)/10)) goto 1
   cut1%apar= apar
   cut1%root= root
   if (dmr.eq.0) then
    nsol= 5
!
    cut1%q(0,1) = -p0(0)+ci(p)*apar
    cut1%q(1,1) = -p0(1)+ci(p)*root
    cut1%q(2,1) = -p0(2)+ci(p)*root
    cut1%q(3,1) = -p0(3)+ci(p)*root
!
    cut1%q(0,2) = -p0(0)-ci(p)*apar
    cut1%q(1,2) = -p0(1)-ci(p)*root
    cut1%q(2,2) = -p0(2)-ci(p)*root
    cut1%q(3,2) = -p0(3)-ci(p)*root
!
    cut1%q(0,3) = -p0(0)+ci(p)*apar
    cut1%q(1,3) = -p0(1)-ci(p)*root
    cut1%q(2,3) = -p0(2)+ci(p)*root
    cut1%q(3,3) = -p0(3)+ci(p)*root
!
    cut1%q(0,4) = -p0(0)+ci(p)*apar
    cut1%q(1,4) = -p0(1)+ci(p)*root
    cut1%q(2,4) = -p0(2)-ci(p)*root
    cut1%q(3,4) = -p0(3)+ci(p)*root
!
    cut1%q(0,5) = -p0(0)+ci(p)*apar
    cut1%q(1,5) = -p0(1)+ci(p)*root
    cut1%q(2,5) = -p0(2)+ci(p)*root
    cut1%q(3,5) = -p0(3)-ci(p)*root
   elseif (dmr.eq.1) then
    nsol= 1
!
    cut1%q(0,1) = -p0(0)+ci(p)*apar
    cut1%q(1,1) = -p0(1)+ci(p)*root
    cut1%q(2,1) = -p0(2)+ci(p)*root
    cut1%q(3,1) = -p0(3)+ci(p)*root
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i) then
      vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut1%q(:,i),kk,i)
      do ky= 0,3
       ps(ky)  = den(kk)%p(ky)-p0(ky)
       psq(ky) = ps(ky)+2.d0*(cut1%q(ky,i)+p0(ky))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-den(kk)%m2
      res= res+pspsq
      vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine dp_cutting1_newbase 
!
  subroutine mp_cutting4(den0,den1,den2,den3,cut4)
   use dimensions
   include 'cts_mpr.h' 
    :: p
   type(mp_propagator), intent(in) :: den0,den1,den2,den3
   type(mp_solcut4) ,intent(out) :: cut4
   include 'cts_mpr.h'
    , dimension(0:3) :: p0,p1,p2,p3,k1,k2,k3
   include 'cts_mpr.h'
    :: k1k1,k2k2,k3k3
   include 'cts_mpc.h'
    :: m02,m12,m22,m32
   include 'cts_mpc.h'
    :: dd0,dd1,dd2,dd3
   include 'cts_mpc.h'
    :: l1k3,l2k3,l3k3,l4k3,x10,x20,x3p,x4p,x3m,x4m
   include 'cts_mpc.h'
    :: cc,ca3,cb3,root,cb3p,cb3m,al1,al2,bet,gm,z
   include 'cts_mpc.h'
    , dimension(0:3) :: l1,l2,l3,l4
   integer :: k
!
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
   p3= den3%p 
!
   m02= den0%m2-mpqt2 
   m12= den1%m2-mpqt2 
   m22= den2%m2-mpqt2 
   m32= den3%m2-mpqt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
    k3(k)= p3(k)-p0(k)
   enddo
!
   call contr(k1,k1,k1k1)
   call contr(k2,k2,k2k2)
   call contr(k3,k3,k3k3)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
!
   call contr(l1,k3,l1k3)
   call contr(l2,k3,l2k3)
   call contr(l3,k3,l3k3)
   call contr(l4,k3,l4k3)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   dd3= m32-k3k3
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   ca3= -l3k3/l4k3
   cb3= (dd3-dd0-2.d0*x10*l1k3-2.d0*x20*l2k3)/2.d0/l4k3
   root= sqrt(cb3**2+4.d0*cc*ca3)
   cb3p= cb3+root
   cb3m= cb3-root
   if (abs(cb3m).ge.abs(cb3p)) then 
     x3p= (-cb3m)/2.d0/ca3
     x3m= -cc/ca3/x3p
     x4m= (cb3m)/2.d0
     x4p= -cc*ca3/x4m
! 
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   else
     x3m= (-cb3p)/2.d0/ca3
     x3p= -cc/ca3/x3m
     x4p= (cb3p)/2.d0
     x4m= -cc*ca3/x4p
!      
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   endif   
!
!  the 2 solutions, the basis and the vector t
! 
!   q(1)= q^+
!   q(2)= q^-
!
   do i= 0,3
    cut4%q(i,1)= -p0(i)+x10*l1(i)+x20*l2(i)+x3p*l3(i)+x4p*l4(i)
    cut4%q(i,2)= -p0(i)+x10*l1(i)+x20*l2(i)+x3m*l3(i)+x4m*l4(i)
    cut4%l1(i)= l1(i)
    cut4%l2(i)= l2(i)
    cut4%l3(i)= l3(i)
    cut4%l4(i)= l4(i)
    cut4%t(i) = l3(i)*l4k3-l4(i)*l3k3
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,2
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i.or. &
         kk.eq.den3%i) then
      mp_vden(kk,i)= c0(p)
     else
      call load_vden(cut4%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine mp_cutting4  
!
  subroutine mp_cutting3(den0,den1,den2,cut3,dmr)
   use dimensions
   include 'cts_mpr.h'
    :: p
   type(mp_propagator), intent(in) :: den0,den1,den2
   type(mp_solcut3), intent(out) :: cut3
   integer, intent(in) ::  dmr
   include 'cts_mpr.h'
    , dimension(0:3) :: p0,p1,p2,k1,k2
   include 'cts_mpr.h'
    :: k1k1,k2k2,phi,rpart,ipart
   include 'cts_mpc.h'
    :: m02,m12,m22
   include 'cts_mpc.h'
    :: dd0,dd1,dd2
   include 'cts_mpc.h'
    :: x10,x20,x3,x4,q3caus
   include 'cts_mpc.h'
    :: cc,tau,ca3,al1,al2,bet,gm,z,cc4 
   include 'cts_mpc.h'
    :: ps(0:3),psq(0:3),pspsq,res 
   include 'cts_mpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   integer :: k,nsol
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
!
   m02= den0%m2-mpqt2 
   m12= den1%m2-mpqt2 
   m22= den2%m2-mpqt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
   enddo
!
   call contr(k1,k1,k1k1)
   call contr(k2,k2,k2k2)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   cut3%gm= gm
   cut3%cc= cc
   do i= 0,3
    cut3%l1(i)= l1(i)
    cut3%l2(i)= l2(i)
    cut3%l3(i)= l3(i)
    cut3%l4(i)= l4(i)
   enddo
   cc4= cc**4
   if  (abs(cc4).gt.mp_tiny(p)) then
    rpart= (cc4+conjg(cc4))/2.d0  
    ipart= (cc4-conjg(cc4))/(2.d0*ci(p))  
    phi= atan2(ipart,rpart) 
   else
    phi= 0.d0
   endif
   tau= exp(ci(p)/8.d0*(pi(p)-phi))
   cut3%tau= tau
   if (dmr.eq.0) then
    if (rational) then
     nsol= 3
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,3) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    else
     nsol= 7
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**2
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,3) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**6
      x3= cc/x4
      cut3%q(i,4) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,5) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**2
      x4= cc/x3
      cut3%q(i,6) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**4
      x4= cc/x3
      cut3%q(i,7) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    endif
   elseif (dmr.eq.1) then
    if (rational) then
     nsol= 2
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
     enddo
    else
     nsol= 5
     do i= 0,3
      q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
      x4= c1(p)
      x3= cc/x4
      cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**4
      x3= cc/x4
      cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x4= (cexp4(p))**6
      x3= cc/x4
      cut3%q(i,3) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
      x3= c1(p)
      x4= cc/x3
      cut3%q(i,4) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
!
      x3= (cexp4(p))**4
      x4= cc/x3
      cut3%q(i,5) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
     enddo
    endif
   elseif (dmr.eq.2) then
    nsol= 3
    do i= 0,3
     q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
     x4= c1(p)
     x3= cc/x4
     cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
     x4= (cexp4(p))**4
     x3= cc/x4
     cut3%q(i,2) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
!
     x3= c1(p)
     x4= cc/x3
     cut3%q(i,3) = q3caus+x3/tau*l3(i)+x4*tau*l4(i)   
    enddo
   else
    nsol= 1
    do i= 0,3
     q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
     x4= c1(p)
     x3= cc/x4
     cut3%q(i,1) = q3caus+x3*tau*l3(i)+x4/tau*l4(i)   
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol  
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i) then
      mp_vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut3%q(:,i),kk,i)
      do k= 0,3
       ps(k)  = mp_den(kk)%p(k)-p0(k)
       psq(k) = ps(k)+2.d0*(cut3%q(k,i)+p0(k))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-mp_den(kk)%m2
      res= res+pspsq
      mp_vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
   end subroutine mp_cutting3  
!
  subroutine mp_cutting2(den0,den1,cut2,dmr)
   use dimensions
   include 'cts_mpr.h'
    :: p,a,b,c
   type(mp_propagator), intent(in) :: den0,den1
   type(mp_solcut2), intent(out) :: cut2
   integer, intent(in) ::  dmr
   include 'cts_mpr.h'
    , dimension(0:3) :: p0,p1,k1,v
   include 'cts_mpr.h'
    :: k1k1,factor,phi,rpart,ipart
   include 'cts_mpc.h'
    :: m02,m12,ak,a0,a1
   include 'cts_mpc.h'
    :: dd0,dd1
   integer :: k,nsol
   include 'cts_mpc.h'
    :: yv0,yvsigma,yvlambda,y3,y4
   include 'cts_mpc.h'
    :: tau,taul,cc3,al,al2,bet,gm,cf0,cflambda,cfsigma,q2caus
   include 'cts_mpc.h'
    :: ps(0:3),psq(0:3),pspsq,res 
   include 'cts_mpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4

   p0= den0%p 
   p1= den1%p 
!
   m02= den0%m2-mpqt2 
   m12= den1%m2-mpqt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
   enddo
!
   call contr(k1,k1,k1k1)
!
!  define the arbitrary massless 4-vector v
!
!-comment
    a= 1.d0   
    v(0)= sign(a,k1(0))         
    v(1)=-sign(a/root3(p),k1(1))
    v(2)=-sign(a/root3(p),k1(2))
    v(3)=-sign(a/root3(p),k1(3))
!-comment
   call build_l(k1,v,l1,l2,l3,l4,al,al2,bet,gm)
   cut2%gm= gm
   cut2%rat1= (den0%m2+den1%m2-k1k1/3.d0) 
   dd0= m02
   dd1= m12-k1k1
   do i= 0,3
    cut2%l3(i)= l3(i)
    cut2%l4(i)= l4(i)
    cut2%k1(i)= k1(i)
    cut2%v(i) = v(i)
   enddo
!
   cf0     = -0.25d0/gm*(m02*c1(p))
   cut2%cf0= cf0 
   yv0     =  (dd1-dd0)*c1(p)/gm
   if (dmr.eq.0) then
    a0= (sigma(p)+c1(p))
    ak= sigma(p)*a0
    a1= -sigma(p)
    cfsigma= a0*m02+a1*m12+ak*k1k1
    cfsigma= -0.25d0/gm*cfsigma
    cut2%cfsigma = cfsigma
    a0= -c1(p)
    a1=  c1(p)
    ak=-(c1(p)+2.d0*sigma(p))
    yvsigma= a0*m02+a1*m12+ak*k1k1
    yvsigma= yvsigma/gm
   endif
   if (dmr.le.1) then
    a0= (lambda(p)+c1(p))
    ak= lambda(p)*a0
    a1= -lambda(p)
    cflambda= a0*m02+a1*m12+ak*k1k1
    cflambda= -0.25d0/gm*cflambda
    cut2%cflambda= cflambda
    a0= -c1(p)
    a1=  c1(p)
    ak=-(c1(p)+2.d0*lambda(p))
    yvlambda= a0*m02+a1*m12+ak*k1k1
    yvlambda= yvlambda/gm
   endif
   if (dmr.eq.0) then
    cc3= cf0**3
    if  (abs(cc3).gt.mp_tiny(p)) then
     rpart= (cc3+conjg(cc3))/2.d0  
     ipart= (cc3-conjg(cc3))/(2.d0*ci(p))  
     phi= atan2(ipart,rpart)
    else
     phi= 0.d0
    endif
    tau= exp(ci(p)/6.d0*(pi(p)-phi))
    cut2%tau= tau
    if (rational) then
     nsol= 1
     do i= 0,3
      q2caus= -p0(i)*c1(p)+yv0*v(i)
      y4= c1(p)
      y3= cf0/y4 
      cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
     enddo
    else
     nsol= 9
     cc3= cflambda**2
     if  (abs(cc3).gt.mp_tiny(p)) then
      rpart= (cc3+conjg(cc3))/2.d0  
      ipart= (cc3-conjg(cc3))/(2.d0*ci(p))  
      phi= atan2(ipart,rpart)
     else
      phi= 0.d0
     endif
     taul= exp(ci(p)/4.d0*(pi(p)-phi))
     cut2%taul= taul
     do i= 0,3
      q2caus= -p0(i)*c1(p)+yv0*v(i)
      y4= c1(p)
      y3= cf0/y4 
      cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y4= cexp3(p)**2
      y3= cf0/y4 
      cut2%q(i,2) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y4= cexp3(p)**4
      y3= cf0/y4 
      cut2%q(i,3) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
      y3= c1(p)
      y4= cf0/y3 
      cut2%q(i,4) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
      y3= cexp3(p)**2
      y4= cf0/y3 
      cut2%q(i,5) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
      q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
      y4= c1(p)
      y3= cflambda/y4 
      cut2%q(i,6) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
!
      cut2%q(i,7) = q2caus-y3*taul*l3(i)-y4/taul*l4(i)   
!
      y3= c1(p)
      y4= cflambda/y3 
      cut2%q(i,8) = q2caus+y3*l3(i)/taul+y4*taul*l4(i)   
!
      q2caus= -p0(i)*c1(p)+sigma(p)*c1(p)*k1(i)+yvsigma*v(i)
      y4= c1(p)
      y3= cfsigma/y4 
      cut2%q(i,9) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
     enddo
    endif
   elseif (dmr.eq.1) then
    nsol= 4
    cc3= cf0**2
    if  (abs(cc3).gt.mp_tiny(p)) then
     rpart= (cc3+conjg(cc3))/2.d0  
     ipart= (cc3-conjg(cc3))/(2.d0*ci(p))  
     phi= atan2(ipart,rpart)
    else
     phi= 0.d0
    endif
    tau= exp(ci(p)/4.d0*(pi(p)-phi))
    cut2%tau= tau
    taul= c1(p)
    cut2%taul= taul
    do i= 0,3
     q2caus= -p0(i)*c1(p)+yv0*v(i)
     y4= c1(p)
     y3= cf0/y4 
     cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
     y4= cexp1(p)
     y3= cf0/y4 
     cut2%q(i,2) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
!
     y3= c1(p)
     y4= cf0/y3 
     cut2%q(i,3) = q2caus+y3*l3(i)/tau+y4*tau*l4(i)   
!
     q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
     y4= c1(p)
     y3= cflambda/y4 
     cut2%q(i,4) = q2caus+y3*taul*l3(i)+y4/taul*l4(i)   
    enddo
   elseif (dmr.eq.2) then
    nsol= 1
    tau = c1(p)
    cut2%tau= tau
    do i= 0,3
     q2caus= -p0(i)*c1(p)+yv0*v(i)
     y4= c1(p)
     y3= cf0/y4 
     cut2%q(i,1) = q2caus+y3*tau*l3(i)+y4/tau*l4(i)   
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i) then
      mp_vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut2%q(:,i),kk,i)
      do k= 0,3
       ps(k)  = mp_den(kk)%p(k)-p0(k)
       psq(k) = ps(k)+2.d0*(cut2%q(k,i)+p0(k))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-mp_den(kk)%m2
      res= res+pspsq
      mp_vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine mp_cutting2  
!
  subroutine mp_cutting1_oldbase(den0,cut1,dmr)
   use dimensions
   include 'cts_mpr.h'
    :: p,a,b,c
   type(mp_propagator), intent(in) :: den0
   type(mp_solcut1), intent(out) :: cut1
   include 'cts_mpr.h'
    , dimension(0:3) :: p0,v,k
   include 'cts_mpc.h'
    :: m02
   include 'cts_mpc.h'
    :: al1,al2,bet,gm
   include 'cts_mpc.h'
    :: cf0
   integer :: nsol,ky
   integer, intent(in) :: dmr
   include 'cts_mpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   include 'cts_mpc.h'
    :: ps(0:3),psq(0:3),pspsq,res 
   logical :: computing=.true.
   save computing,v,k
   if (computing) then
     computing=.false.
!    define the arbitrary massless 4-vectors v and k
!-comment
     v(0)= 1.d0
     v(1)= v(0)/root3(p)
     v(2)= v(0)/root3(p)
     v(3)= v(0)/root3(p)
!
     k(0)= 1.d0
     k(1)=-k(0)/root3(p)
     k(2)=-k(0)/root3(p)
     k(3)=-k(0)/root3(p)
!-comment
   endif
   p0 = den0%p 
   m02= den0%m2-mpqt2 
   call build_l(v,k,l1,l2,l3,l4,al1,al2,bet,gm)
   cut1%gm= gm
! 
   cf0      = -0.25d0/gm*(m02*c1(p))
   cut1%cf0 = cf0
   if (dmr.eq.0) then
    nsol= 5
    do i= 0,3
     cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
     cut1%q(i,2) = -p0(i)-cf0*tau11(p)*l3(i)-l4(i)/tau11(p)
     cut1%q(i,3) =  cut1%q(i,1)+v(i)
     cut1%q(i,4) =  cut1%q(i,1)+k(i)
     cut1%q(i,5) = -p0(i)+cexpk1(p)*tau12(p)*tau11(p)*l3(i) &
                    +cf0/cexpk1(p)*l4(i)/tau11(p)/tau12(p)
     cut1%v(i)   = v(i)
     cut1%k(i)   = k(i)
     cut1%l3(i)  = l3(i)
     cut1%l4(i)  = l4(i)
    enddo
   elseif (dmr.eq.1) then
    nsol= 1
    do i= 0,3
     cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
    enddo
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i) then
      mp_vden(kk,i)= c0(p)
     else
      do ky= 0,3
       ps(ky)  = mp_den(kk)%p(ky)-p0(ky)
       psq(ky) = ps(ky)+2.d0*(cut1%q(ky,i)+p0(ky))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-mp_den(kk)%m2
      res= res+pspsq
      mp_vden(kk,i)= res
     endif 
    enddo
   enddo
  end subroutine mp_cutting1_oldbase
!
  subroutine mp_cutting1_newbase(den0,cut1,dmr)
   use dimensions
   include 'cts_mpr.h' 
    :: p,a,b,c
   type(mp_propagator), intent(in) :: den0
   type(mp_solcut1), intent(out) :: cut1
   integer, intent(in) ::  dmr
   include 'cts_mpr.h'
    , dimension(0:3) :: p0,v,k
   include 'cts_mpc.h' 
    :: m02,apar,root 
   include 'cts_mpc.h' 
    :: al1,al2,bet,gm
   include 'cts_mpc.h' 
    :: cf0
   include 'cts_mpc.h'
    , dimension(0:3)  :: l1,l2,l3,l4
   include 'cts_mpc.h' 
    :: ps(0:3),psq(0:3),pspsq,res 
   integer :: ky,nsol
   logical :: computing=.true.
   save computing,v,k,l3,l4 
   if (computing) then
!    define the arbitrary massless 4-vectors v and k
     computing=.false.
!-comment
     k(0) = 1.d0
     k(1) = 0.d0 
     k(2) = 0.d0
     k(3) = 0.d0

     v(0) = 0.d0
     v(1) = 1.d0 
     v(2) = 0.d0
     v(3) = 0.d0

     l3(0)= 0.d0
     l3(1)= 0.d0 
     l3(2)= 1.d0
     l3(3)= 0.d0

     l4(0)= 0.d0
     l4(1)= 0.d0 
     l4(2)= 0.d0
     l4(3)= 1.d0
!-comment
   endif
   do i= 0,3
    cut1%v(i)   = v(i)
    cut1%k(i)   = k(i)
    cut1%l3(i)  = l3(i)
    cut1%l4(i)  = l4(i)
   enddo
   p0 = den0%p 
   m02= den0%m2-mpqt2 
   ky= 0
 1 ky= ky+1
   apar= sqrt(c1(p)*ky+mpqt2)
   root= sqrt((apar**2+m02)/3.d0)
   if (abs(root).le.abs(c1(p)/10)) goto 1
   cut1%apar= apar
   cut1%root= root
   if (dmr.eq.0) then
    nsol= 5
!
    cut1%q(0,1) = -p0(0)+ci(p)*apar
    cut1%q(1,1) = -p0(1)+ci(p)*root
    cut1%q(2,1) = -p0(2)+ci(p)*root
    cut1%q(3,1) = -p0(3)+ci(p)*root
!
    cut1%q(0,2) = -p0(0)-ci(p)*apar
    cut1%q(1,2) = -p0(1)-ci(p)*root
    cut1%q(2,2) = -p0(2)-ci(p)*root
    cut1%q(3,2) = -p0(3)-ci(p)*root
!
    cut1%q(0,3) = -p0(0)+ci(p)*apar
    cut1%q(1,3) = -p0(1)-ci(p)*root
    cut1%q(2,3) = -p0(2)+ci(p)*root
    cut1%q(3,3) = -p0(3)+ci(p)*root
!
    cut1%q(0,4) = -p0(0)+ci(p)*apar
    cut1%q(1,4) = -p0(1)+ci(p)*root
    cut1%q(2,4) = -p0(2)-ci(p)*root
    cut1%q(3,4) = -p0(3)+ci(p)*root
!
    cut1%q(0,5) = -p0(0)+ci(p)*apar
    cut1%q(1,5) = -p0(1)+ci(p)*root
    cut1%q(2,5) = -p0(2)+ci(p)*root
    cut1%q(3,5) = -p0(3)-ci(p)*root
   elseif (dmr.eq.1) then
    nsol= 1
!
    cut1%q(0,1) = -p0(0)+ci(p)*apar
    cut1%q(1,1) = -p0(1)+ci(p)*root
    cut1%q(2,1) = -p0(2)+ci(p)*root
    cut1%q(3,1) = -p0(3)+ci(p)*root
   endif
!
!  computing all denominators at the solutions
! 
   do i= 1,nsol
    do j= 1,dmns
     kk= string(j)
     if (kk.eq.den0%i) then
      mp_vden(kk,i)= c0(p)
     else
! comment
!      call load_vden(cut1%q(:,i),kk,i)
      do ky= 0,3
       ps(ky)  = mp_den(kk)%p(ky)-p0(ky)
       psq(ky) = ps(ky)+2.d0*(cut1%q(ky,i)+p0(ky))
      enddo
      call contr(ps,psq,pspsq)
      res= den0%m2-mp_den(kk)%m2
      res= res+pspsq
      mp_vden(kk,i)= res
! comment
     endif 
    enddo
   enddo
  end subroutine mp_cutting1_newbase
!
 end module cuttings
!
 module coefficients
  use cuttings
  use dimensions
  implicit none
!
! variables for the rational terms
!
  logical, private :: inf=.false.
  include 'cts_dpc.h'
   , public :: rat1,save_rat1 
  include 'cts_mpc.h'
   , public :: mp_rat1,save_mp_rat1
!
! variables for the 4-point sector:
!
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: dcoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: save_dcoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: tvec,p0vec
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_dcoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: save_mp_dcoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_tvec,mp_p0vec
!
! variables for the 3-point sector:
!
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: ccoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: ccoeff_2
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: save_ccoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: l3vec,l4vec    
! also for the 2,1-point sectors
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_ccoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_ccoeff_2
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: save_mp_ccoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_l3vec,mp_l4vec 
!
! variables for the 2-point sector:
!
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: bcoeff
  include 'cts_dpc.h'
   , dimension(:)  , public, allocatable :: bcoeff_2
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: save_bcoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: vveca,vvecb
  include 'cts_dpc.h'
   , dimension(:), public, allocatable :: vveck1,b_rat1
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_bcoeff
  include 'cts_mpc.h'
   , dimension(:), public, allocatable :: mp_bcoeff_2
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: save_mp_bcoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_vveca, mp_vvecb  
  include 'cts_mpc.h'
   , dimension(:), public, allocatable :: mp_vveck1,mp_b_rat1
!
! variables for the 1-point sector:
!
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: acoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: save_acoeff
  include 'cts_dpc.h'
   , dimension(:,:), public, allocatable :: kvec
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_acoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: save_mp_acoeff
  include 'cts_mpc.h'
   , dimension(:,:), public, allocatable :: mp_kvec
!
  save dcoeff,tvec,p0vec
  save ccoeff,ccoeff_2,l3vec,l4vec
  save bcoeff,bcoeff_2,vveca,vvecb,vveck1,b_rat1
  save acoeff,kvec
  save mp_dcoeff,mp_tvec,mp_p0vec
  save mp_ccoeff,mp_ccoeff_2,mp_l3vec,mp_l4vec
  save mp_bcoeff,mp_bcoeff_2,mp_vveca,mp_vvecb,mp_vveck1,mp_b_rat1
  save mp_acoeff,mp_kvec
  save save_dcoeff,save_ccoeff,save_bcoeff,save_acoeff
  save save_mp_dcoeff,save_mp_ccoeff,save_mp_bcoeff,save_mp_acoeff
  save rat1,save_rat1,mp_rat1,save_mp_rat1 
!
  interface get_coefficients
    module procedure dp_get_coefficients
    module procedure mp_get_coefficients
  end interface!get_coefficients
!
  interface getd
    module procedure dp_getd
    module procedure mp_getd
  end interface!getd
!
  interface getc
    module procedure dp_getc
    module procedure mp_getc
  end interface!getc
!
  interface getb
    module procedure dp_getb
    module procedure mp_getb
  end interface!getb
!
  interface geta
    module procedure dp_geta_newbase
    module procedure mp_geta_newbase
  end interface!geta
!
  interface numd
    module procedure dp_numd
    module procedure mp_numd
  end interface!numd
!
  interface numc
    module procedure dp_numc
    module procedure mp_numc
  end interface!numc
!
  interface numb
    module procedure dp_numb
    module procedure mp_numb
  end interface!numb
!
  interface numa
    module procedure dp_numa
    module procedure mp_numa
  end interface!numa
!
  interface numfuncrec
    module procedure dp_numfuncrec
    module procedure mp_numfuncrec
  end interface!numfuncrec
!
  interface test
    module procedure dp_test
    module procedure mp_test
  end interface!test
!
  interface put_dcoeff
    module procedure dp_put_dcoeff
    module procedure mp_put_dcoeff
  end interface!put_dcoeff
!
  interface get_dcoeff
    module procedure dp_get_dcoeff
    module procedure mp_get_dcoeff
  end interface!get_dcoeff
!
  interface put_ccoeff
    module procedure dp_put_ccoeff
    module procedure mp_put_ccoeff
  end interface!put_ccoeff
!
  interface get_ccoeff
    module procedure dp_get_ccoeff
    module procedure mp_get_ccoeff
  end interface!get_ccoeff
!
  interface put_bcoeff
    module procedure dp_put_bcoeff
    module procedure mp_put_bcoeff
  end interface!put_bcoeff
!
  interface get_bcoeff
    module procedure dp_get_bcoeff
    module procedure mp_get_bcoeff
  end interface!get_bcoeff
!
  interface put_acoeff
    module procedure dp_put_acoeff
    module procedure mp_put_acoeff
  end interface!put_acoeff
!
  interface get_acoeff
    module procedure dp_get_acoeff
    module procedure mp_get_acoeff
  end interface!get_acoeff
!
  contains
!
  subroutine dp_allocate_arrays(np)
  integer, intent(in) :: np
  call dp_allocate_genvec
  if (np.ge.4) call dp_allocate_vectorsd
  if (np.ge.3) call dp_allocate_vectorsc
  if (np.ge.2) call dp_allocate_vectorsb
  if (np.ge.1) call dp_allocate_vectorsa
  end subroutine dp_allocate_arrays
!
  subroutine dp_allocate_genvec
   allocate (p0vec(0:3,dmns_d), stat=ierr)
   allocate (l3vec(0:3,dmns_c), stat=ierr)  
   allocate (l4vec(0:3,dmns_c), stat=ierr)  
  end subroutine dp_allocate_genvec
!
  subroutine dp_allocate_vectorsd
   allocate      (dcoeff(0:1,dmns_d), stat=ierr)
   allocate (save_dcoeff(0:1,dmns_d), stat=ierr)
   allocate        (tvec(0:3,dmns_d), stat=ierr)
  end subroutine dp_allocate_vectorsd
!
  subroutine dp_allocate_vectorsc
   allocate      (ccoeff(0:6,dmns_c), stat=ierr)
   allocate    (ccoeff_2(0:2,dmns_c), stat=ierr)
   allocate (save_ccoeff(0:6,dmns_c), stat=ierr)
  end subroutine dp_allocate_vectorsc
!
  subroutine dp_allocate_vectorsb
   allocate      (bcoeff(0:8,dmns_b), stat=ierr)
   allocate        (bcoeff_2(dmns_b), stat=ierr)
   allocate (save_bcoeff(0:8,dmns_b), stat=ierr)
   allocate       (vvecb(0:3,dmns_b), stat=ierr)
   allocate          (vveck1(dmns_b), stat=ierr)
   allocate          (b_rat1(dmns_b), stat=ierr)
  end subroutine dp_allocate_vectorsb
!
  subroutine dp_allocate_vectorsa
   allocate  (vveca(0:3,dmns_a),      stat=ierr)
   allocate (acoeff(0:4,dmns_a),      stat=ierr)
   allocate (save_acoeff(0:4,dmns_a), stat=ierr)
   allocate   (kvec(0:3,dmns_a),      stat=ierr) 
  end subroutine dp_allocate_vectorsa
!
  subroutine mp_allocate_arrays(np)
  integer, intent(in) :: np
  call mp_allocate_genvec
  if (np.ge.4) call mp_allocate_vectorsd
  if (np.ge.3) call mp_allocate_vectorsc
  if (np.ge.2) call mp_allocate_vectorsb
  if (np.ge.1) call mp_allocate_vectorsa
  end subroutine mp_allocate_arrays
!
  subroutine mp_allocate_genvec
   allocate (mp_p0vec(0:3,dmns_d), stat=ierr)
   allocate (mp_l3vec(0:3,dmns_c), stat=ierr)  
   allocate (mp_l4vec(0:3,dmns_c), stat=ierr)  
  end subroutine mp_allocate_genvec
!
  subroutine mp_allocate_vectorsd
   allocate (mp_dcoeff(0:1,dmns_d), stat=ierr)
   allocate (save_mp_dcoeff(0:1,dmns_d), stat=ierr)
   allocate (mp_tvec(0:3,dmns_d), stat=ierr)
  end subroutine mp_allocate_vectorsd
!
  subroutine mp_allocate_vectorsc
   allocate      (mp_ccoeff(0:6,dmns_c), stat=ierr)
   allocate    (mp_ccoeff_2(0:2,dmns_c), stat=ierr)
   allocate (save_mp_ccoeff(0:6,dmns_c), stat=ierr)
  end subroutine mp_allocate_vectorsc
!
  subroutine mp_allocate_vectorsb
   allocate      (mp_bcoeff(0:8,dmns_b), stat=ierr)
   allocate        (mp_bcoeff_2(dmns_b), stat=ierr)
   allocate (save_mp_bcoeff(0:8,dmns_b), stat=ierr)
   allocate       (mp_vvecb(0:3,dmns_b), stat=ierr)
   allocate          (mp_vveck1(dmns_b), stat=ierr)
   allocate          (mp_b_rat1(dmns_b), stat=ierr)
  end subroutine mp_allocate_vectorsb
!
  subroutine mp_allocate_vectorsa
   allocate  (mp_vveca(0:3,dmns_a)     , stat=ierr)
   allocate (save_mp_acoeff(0:4,dmns_a), stat=ierr)
   allocate (mp_acoeff(0:4,dmns_a),      stat=ierr)
   allocate   (mp_kvec(0:3,dmns_a),      stat=ierr) 
  end subroutine mp_allocate_vectorsa
! 
  subroutine dp_get_coefficients(p,numdummy,number_propagators,dmr,ql)
   use scale
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   include 'cts_dpc.h'
    , dimension(0:3) :: q
   include 'cts_dpr.h'
    , intent(in) :: ql
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   include 'cts_dpc.h'
    , dimension(0:3) :: qvalue
   include 'cts_dpc.h' 
    :: dummy1,dummy2
   include 'cts_dpr.h' 
    :: prec
   include 'cts_dpc.h' 
    :: rat1_d,rat1_c,rat1_b
   include 'cts_dpc.h' 
    :: qt2_0,qt2_1,qt2_inf
   integer :: k,ib,iteration,dmr1
   logical :: computing=.true.
   include 'cts_dpc.h' 
    :: aset(dmns_a,1:3)
   include 'cts_dpc.h' 
    :: bset(dmns_b,1:3)
   include 'cts_dpc.h' 
    :: cset(dmns_c,1:3)
   include 'cts_dpc.h' 
    :: rset(1:2)
   save computing,qt2_0,qt2_1,qt2_inf
   stablen=.true.
   if (computing) then
    computing=.false.
    qt2_0=  0.d0
!
!   value of q used for computing R_1
!
    q    =  0.d0
   endif
   qt2_1=  ql*ql*0.001d0   
   qt2_inf =  ql*ql*1.d14
   qt2= qt2_0
   rational=.false.              
   if (number_propagators.ge.4) call getd(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.3) call getc(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.2) call getb(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.1) call geta(p,numdummy,number_propagators,dmr)
   call load_set(1)
   if (number_propagators.ge.4) call put_dcoeff(p)
   if (number_propagators.ge.3) call put_ccoeff(p)
   if (number_propagators.ge.2) call put_bcoeff(p)
   if (number_propagators.ge.1) call put_acoeff(p)
!-comment
   qvalue(0)= ql/2.d0
   qvalue(1)=-ql/3.d0
   qvalue(2)= ql/4.d0
   qvalue(3)=-ql/5.d0
   call test(p,numdummy,number_propagators,qvalue,dummy1,dummy2,prec)
!   print *,'           '
!   print *,'dummy1=',dummy1,'to be compared with'
!   print *,'dummy2=',dummy2
!   print *,'prec  in dp_get_coefficients:',prec
   if (prec.gt.llimit) stablen=.false.
!-comment
   rational=.true.          
   do iteration= 1,2
!
!    iteration= 2 is to get the main coefficients in a different way 
!    in order to test the numerical accuracy of the final result
!
     if (iteration.eq.1) then
      qt2= qt2_1
      dmr1= dmr
     else
      qt2=-qt2_1
      dmr1= 0
     endif
     if (number_propagators.ge.4) call getd(p,numdummy,number_propagators,dmr1)
     if (number_propagators.ge.3) call getc(p,numdummy,number_propagators,dmr1)
     if (number_propagators.ge.2) call getb(p,numdummy,number_propagators,dmr1)
     if (iteration.eq.2) then
      if (number_propagators.ge.1)call geta(p,numdummy,number_propagators,dmr1)
     endif
     call load_set(iteration+1)
     rat1_d= 0.d0 
     rat1_c= 0.d0 
     rat1_b= 0.d0 
     if     (dmr1.ge.2) then
     elseif (dmr1.eq.1) then
      if (number_propagators.ge.3) call getc_2(rat1_c)
     elseif (dmr1.eq.0) then
      if (number_propagators.ge.2) call getb_2(rat1_b)
      if (number_propagators.ge.3) call getc_2(rat1_c)
      if (number_propagators.ge.4) then
        if (inf) then
         call getd_last3(q,rat1_d) 
        else
         call getd_last1(q,rat1_d) ! reconstructed from the other coefficients
!        call getd_last2(q,rat1_d) ! computed by re-fitting the D sector
        endif 
      endif 
     endif
     rat1= rat1_d+rat1_c+rat1_b
     call load_rat(iteration)
   enddo
   call finalize_sets
   qt2= qt2_0
   contains
!   
   subroutine compare
    print*,'   '
    print*,'   '
    do k= 1,nbn1(number_propagators)
     ib= mbn1(number_propagators,k)
     print*,'     acoeff(0,ib)=',     acoeff(0,ib)
     print*,'save_acoeff(0,ib)=',save_acoeff(0,ib)
    enddo
    print*,'   '
    print*,'   '
    do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     print*,'     bcoeff(0,ib)=',     bcoeff(0,ib)
     print*,'save_bcoeff(0,ib)=',save_bcoeff(0,ib)
    enddo
    print*,'   '
    print*,'   '
    do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     print*,'     ccoeff(0,ib)=',     ccoeff(0,ib)
     print*,'save_ccoeff(0,ib)=',save_ccoeff(0,ib)
    enddo
    print*,'   '
    print*,'   '
    print*,'save_rat1=',save_rat1
    print*,'     rat1=',rat1
    print*,' rat1_d  =',rat1_d
    print*,' rat1_c  =',rat1_c
    print*,' rat1_b  =',rat1_b
    print*,'   '
    print*,'   '
   end subroutine compare
!
   subroutine getb_2(rat1_b)
   include 'cts_dpc.h'
    , intent(out) :: rat1_b
   rat1_b= 0.d0
   do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     bcoeff_2(ib)= (bcoeff(0,ib)-save_bcoeff(0,ib))/qt2  
     rat1_b= rat1_b+bcoeff_2(ib)*b_rat1(ib)
   enddo
   rat1_b= -0.5d0*rat1_b 
   end subroutine getb_2 
!
   subroutine getc_2(rat1_c)
   include 'cts_dpc.h'
    , intent(out) :: rat1_c
   rat1_c= 0.d0
   do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     ccoeff_2(0,ib)= (ccoeff(0,ib)-save_ccoeff(0,ib))/qt2  
     ccoeff_2(1,ib)= (ccoeff(1,ib)-save_ccoeff(1,ib))/qt2  
     ccoeff_2(2,ib)= (ccoeff(2,ib)-save_ccoeff(2,ib))/qt2  
     rat1_c= rat1_c+ccoeff_2(0,ib)
   enddo
   rat1_c= -0.5d0*rat1_c
   end subroutine getc_2 
!
   subroutine getd_last1(q,rat1_d)
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_dpc.h'
    , intent(out) :: rat1_d
   integer :: i,np
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   include 'cts_dpc.h' 
    :: l3qp0,l4qp0,vqp0,kqp0
   include 'cts_dpc.h' 
    :: start,sumdena,sumdenb,num0,num2,num3
   np= number_propagators
   start= 0.d0 
!
!  contribution from the a sector:
!
   if (iteration.eq.1) then
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,l3qp0)
     call contr(l4vec(:,ib),qp0,l4qp0)
     call contr(vveca(:,ib),qp0,vqp0)
     call contr(kvec(:,ib),qp0,kqp0)
     sumdena= 0.d0 
     do k= 2,np
      sumdena= sumdena+(value(den(bn1(np,k,i)),q)-qt2)
     enddo
     start= start+(                    &
              save_acoeff(0,ib)        & 
             +save_acoeff(1,ib)*kqp0   &
             +save_acoeff(2,ib)*vqp0   &
             +save_acoeff(3,ib)*l3qp0  &
             +save_acoeff(4,ib)*l4qp0)*sumdena 
    enddo  
   else
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,l3qp0)
     call contr(l4vec(:,ib),qp0,l4qp0)
     call contr(vveca(:,ib),qp0,vqp0)
     call contr(kvec(:,ib),qp0,kqp0)
     sumdena= 0.d0 
     do k= 2,np
      sumdena= sumdena+(value(den(bn1(np,k,i)),q)-qt2)
     enddo
     start= start+(               &
              acoeff(0,ib)        & 
             +acoeff(1,ib)*kqp0   &
             +acoeff(2,ib)*vqp0   &
             +acoeff(3,ib)*l3qp0  &
             +acoeff(4,ib)*l4qp0)*sumdena 
    enddo  
   endif
!
!  contribution from the b sector:
!
   do i= 1,nbn2(np)
    ib= mbn2(np,i)
    do k= 0,3
     qp0(k)= q(k)+p0vec(k,ib) 
    enddo
    call contr(l3vec(:,ib),qp0,l3qp0)
    call contr(l4vec(:,ib),qp0,l4qp0)
    call contr(vvecb(:,ib),qp0,vqp0)
    sumdenb= 0.d0 
    do k= 3,np
     sumdenb= sumdenb+(value(den(bn2(np,k,i)),q)-qt2)
    enddo
    if (iteration.eq.1) start= start+save_bcoeff(0,ib)
    if (iteration.eq.2) start= start+(bset(ib,2)+bset(ib,3))/2.d0
    start=  start+(                            & 
             save_bcoeff(1,ib)*l3qp0           &
            +save_bcoeff(2,ib)*l4qp0           &
            +save_bcoeff(3,ib)*vqp0            &
            +save_bcoeff(4,ib)*(l3qp0)**2      &
            +save_bcoeff(5,ib)*(l4qp0)**2      &
            +save_bcoeff(6,ib)*vqp0**2         &
            +save_bcoeff(7,ib)*vqp0*l3qp0      &
            +save_bcoeff(8,ib)*vqp0*l4qp0)     &    
            +bcoeff_2(ib)*sumdenb
   enddo  
!
!  contribution from the c sector:
!
   do i= 1,nbn3(np)
    ib= mbn3(np,i)
    do k= 0,3 
     qp0(k)= q(k)+p0vec(k,ib) 
    enddo
    call contr(l3vec(:,ib),qp0,l3qp0)
    call contr(l4vec(:,ib),qp0,l4qp0)
    start= start+(ccoeff_2(0,ib)               &
                 +ccoeff_2(1,ib)*l3qp0         &
                 +ccoeff_2(2,ib)*l4qp0)        
   enddo
   rat1_d= -start
   rat1_d=-rat1_d/6.d0 ! multiplying by the R_2 integral
   end subroutine getd_last1
!
   subroutine getd_last2(q,rat1_d)
    include 'cts_dpc.h'
     , intent(in), dimension(0:3) :: q
    include 'cts_dpc.h'
     , intent(out) :: rat1_d
    include 'cts_dpc.h'
     , dimension(1:(number_propagators-2)) :: x
    include 'cts_dpc.h'
     , dimension(0:(number_propagators-2)) :: dres
    include 'cts_dpc.h' 
     :: qt2_save 
    integer :: n,ntot,kmax 
    qt2_save= qt2        ! store the current value of qt2
    dres(0)= numd(number_propagators,q,0) ! compute sumd at x(0)= qt2
    kmax= number_propagators-2
    ntot= kmax+1
    do n= 1,ntot-1
     x(n)= qt2*exp(-2.d0*ci(p)*pi(p)*n/ntot)
    enddo
    do n= 1,ntot-1
     qt2= x(n)
     call getd(p,numdummy,number_propagators,dmr1)  
     dres(n)= numd(number_propagators,q,0) ! compute sumd at x(n)
    enddo
    rat1_d= 0.d0
    do n= 0,ntot-1
     rat1_d= rat1_d+dres(n)*exp(2.d0*ci(p)*pi(p)*n*kmax/ntot)
    enddo
    qt2= qt2_save         ! reload the initial value of qt2
    rat1_d= rat1_d/ntot/qt2**kmax
    rat1_d=-rat1_d/6.d0   ! multiplying by the R_2 integral
   end subroutine getd_last2
!
   subroutine getd_last3(q,rat1_d)
    include 'cts_dpc.h'
     , intent(in), dimension(0:3) :: q
    include 'cts_dpc.h'
     , intent(out) :: rat1_d
    include 'cts_dpc.h' 
     :: qt2_save 
    qt2_save= qt2        ! store the current value of qt2
    qt2= qt2_inf 
    call getd(p,numdummy,number_propagators,dmr1)  
    rat1_d= numd(number_propagators,q,0) ! compute sumd at qt2_inf
    rat1_d= rat1_d/qt2**(number_propagators-2)
    rat1_d=-rat1_d/6.d0   ! multiplying by the R_2 integral
    qt2= qt2_save         ! reload the initial value of qt2
   end subroutine getd_last3
!
   subroutine load_set(n)
   integer, intent(in) :: n
   do k= 1,nbn1(number_propagators)
    ib= mbn1(number_propagators,k)
    aset(ib,n)= acoeff(0,ib)
   enddo
   do k= 1,nbn2(number_propagators)
    ib= mbn2(number_propagators,k)
    bset(ib,n)= bcoeff(0,ib)
   enddo
   do k= 1,nbn3(number_propagators)
    ib= mbn3(number_propagators,k)
    cset(ib,n)= ccoeff(0,ib)
   enddo
   end subroutine load_set
!
   subroutine load_rat(n)
   integer, intent(in) :: n
   rset(n)= rat1 
   end subroutine load_rat
!
   subroutine finalize_sets
   do k= 1,nbn1(number_propagators)
    ib= mbn1(number_propagators,k)
    acoeff(0,ib) = aset(ib,3)
   enddo
   do k= 1,nbn2(number_propagators)
    ib= mbn2(number_propagators,k)
    bcoeff(0,ib)= (bset(ib,2)+bset(ib,3))/2.d0 
   enddo
   do k= 1,nbn3(number_propagators)
    ib= mbn3(number_propagators,k)
    ccoeff(0,ib)= (cset(ib,2)+cset(ib,3))/2.d0
    ccoeff(1,ib)= save_ccoeff(1,ib) ! to put it to the true value  
    ccoeff(2,ib)= save_ccoeff(2,ib) ! to put it to the true value
   enddo
   save_rat1= rset(1) 
   rat1     = rset(2) 
   end subroutine finalize_sets
!
  end subroutine dp_get_coefficients
! 
  subroutine mp_get_coefficients(p,numdummy,number_propagators,dmr,ql)
   use scale
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   include 'cts_dpc.h'
    , dimension(0:3) :: q
   include 'cts_dpr.h'
    , intent(in) :: ql
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   include 'cts_dpc.h'
    , dimension(0:3) :: qvalue
   include 'cts_mpc.h' 
    :: dummy1,dummy2
   include 'cts_dpr.h' 
    :: prec
   include 'cts_mpc.h' 
    :: rat1_d,rat1_c,rat1_b
   include 'cts_mpc.h' 
    :: qt2_0,qt2_1,qt2_inf
   integer :: k,ib,iteration,dmr1
   logical :: computing=.true.
   include 'cts_mpc.h' 
    :: aset(dmns_a,1:3)
   include 'cts_mpc.h' 
    :: bset(dmns_b,1:3)
   include 'cts_mpc.h' 
    :: cset(dmns_c,1:3)
   include 'cts_mpc.h' 
    :: rset(1:2)
   save computing,qt2_0,qt2_1,qt2_inf
   stablen=.true.
   if (computing) then
    computing=.false.
    qt2_0=  0.d0
    q    =  0.d0
   endif
   qt2_1=  ql*ql*0.001d0    
   qt2_inf =  ql*ql*1.d14
   mpqt2= qt2_0
   rational=.false.              
   if (number_propagators.ge.4) call getd(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.3) call getc(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.2) call getb(p,numdummy,number_propagators,dmr)
   if (number_propagators.ge.1) call geta(p,numdummy,number_propagators,dmr)
   call load_set(1)
   if (number_propagators.ge.4) call put_dcoeff(p)
   if (number_propagators.ge.3) call put_ccoeff(p)
   if (number_propagators.ge.2) call put_bcoeff(p)
   if (number_propagators.ge.1) call put_acoeff(p)
!-comment
   qvalue(0)= ql/2.d0
   qvalue(1)=-ql/3.d0
   qvalue(2)= ql/4.d0
   qvalue(3)=-ql/5.d0
   call test(p,numdummy,number_propagators,qvalue,dummy1,dummy2,prec)
!   print *,'           '
!   aus= dummy1
!   print *,'dummy1=',aus,'to be compared with'
!   aus= dummy2
!   print *,'dummy2=',aus
!   print *,'prec  in mp_get_coefficients:',prec
   if (prec.gt.llimit) stablen=.false.
!-comment
   rational=.true.          
   do iteration= 1,2
!
!    iteration= 2 is to get the main coefficients in a different way 
!    in order to test the numerical accuracy of the final result
!
     if (iteration.eq.1) then
      mpqt2= qt2_1
      dmr1= dmr
     else
      mpqt2=-qt2_1
      dmr1= 0
     endif
     if (number_propagators.ge.4) call getd(p,numdummy,number_propagators,dmr1)
     if (number_propagators.ge.3) call getc(p,numdummy,number_propagators,dmr1)
     if (number_propagators.ge.2) call getb(p,numdummy,number_propagators,dmr1)
     if (iteration.eq.2) then
      if (number_propagators.ge.1)call geta(p,numdummy,number_propagators,dmr1)
     endif
     call load_set(iteration+1)
     rat1_d= 0.d0 
     rat1_c= 0.d0 
     rat1_b= 0.d0 
     if     (dmr1.ge.2) then
     elseif (dmr1.eq.1) then
      if (number_propagators.ge.3) call getc_2(rat1_c)
     elseif (dmr1.eq.0) then
      if (number_propagators.ge.2) call getb_2(rat1_b)
      if (number_propagators.ge.3) call getc_2(rat1_c)
      if (number_propagators.ge.4) then
        if (inf) then
         call getd_last3(q,rat1_d) 
        else
         call getd_last1(q,rat1_d) ! reconstructed from the other coefficients
!        call getd_last2(q,rat1_d) ! computed by re-fitting the D sector
        endif 
      endif 
     endif
     mp_rat1= rat1_d+rat1_c+rat1_b
     call load_rat(iteration)
   enddo
   call finalize_sets
   mpqt2= qt2_0
   contains
!   
   subroutine compare
    print*,'   '
    print*,'   '
    do k= 1,nbn1(number_propagators)
     ib= mbn1(number_propagators,k)
     aus= mp_acoeff(0,ib)
     print*,'     mp_acoeff(0,ib)=',aus     
     aus= save_mp_acoeff(0,ib)
     print*,'save_mp_acoeff(0,ib)=',aus
    enddo
    print*,'   '
    print*,'   '
    do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     aus= mp_bcoeff(0,ib)
     print*,'     mp_bcoeff(0,ib)=',aus     
     aus= save_mp_bcoeff(0,ib)
     print*,'save_mp_bcoeff(0,ib)=',aus
    enddo
    print*,'   '
    print*,'   '
    do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     aus= mp_ccoeff(0,ib)
     print*,'     mp_ccoeff(0,ib)=',aus     
     aus= save_mp_ccoeff(0,ib)
     print*,'save_mp_ccoeff(0,ib)=',aus
    enddo
    print*,'   '
    print*,'   '
    aus= save_mp_rat1
    print*,'save_mp_rat1=',aus
    aus= mp_rat1
    print*,'     mp_rat1=',aus
    aus= rat1_d
    print*,' rat1_d  =',aus
    aus= rat1_c
    print*,' rat1_c  =',aus
    aus= rat1_b
    print*,' rat1_b  =',aus
    print*,'   '
    print*,'   '
   end subroutine compare
!
   subroutine getb_2(rat1_b)
   include 'cts_mpc.h'
    , intent(out) :: rat1_b
   rat1_b= 0.d0
   do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     mp_bcoeff_2(ib)= (mp_bcoeff(0,ib)-save_mp_bcoeff(0,ib))/mpqt2
     rat1_b= rat1_b+mp_bcoeff_2(ib)*mp_b_rat1(ib)
   enddo
   rat1_b= -0.5d0*rat1_b 
   end subroutine getb_2 
!
   subroutine getc_2(rat1_c)
   include 'cts_mpc.h'
    , intent(out) :: rat1_c
   rat1_c= 0.d0
   do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     mp_ccoeff_2(0,ib)= (mp_ccoeff(0,ib)-save_mp_ccoeff(0,ib))/mpqt2  
     mp_ccoeff_2(1,ib)= (mp_ccoeff(1,ib)-save_mp_ccoeff(1,ib))/mpqt2  
     mp_ccoeff_2(2,ib)= (mp_ccoeff(2,ib)-save_mp_ccoeff(2,ib))/mpqt2  
     rat1_c= rat1_c+mp_ccoeff_2(0,ib)
   enddo
   rat1_c= -0.5d0*rat1_c
   end subroutine getc_2 
!
   subroutine getd_last1(q,rat1_d)
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_mpc.h'
    , dimension(0:3) :: mpq
   include 'cts_mpc.h'
    , intent(out) :: rat1_d
   integer :: i,np
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   include 'cts_mpc.h' 
    :: l3qp0,l4qp0,vqp0,kqp0
   include 'cts_mpc.h' 
    :: start,sumdena,sumdenb,num0,num2,num3
   np= number_propagators
   start= 0.d0 
   do k= 0,3; mpq(k)= q(k)*c1(p); enddo
!
!  contribution from the a sector:
!
   if (iteration.eq.1) then
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= mpq(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,l4qp0)
     call contr(mp_vveca(:,ib),qp0,vqp0)
     call contr(mp_kvec(:,ib),qp0,kqp0)
     sumdena= 0.d0 
     do k= 2,np
      sumdena= sumdena+(value(mp_den(bn1(np,k,i)),mpq)-mpqt2)
     enddo
     start= start+(                    &
              save_mp_acoeff(0,ib)        & 
             +save_mp_acoeff(1,ib)*kqp0   &
             +save_mp_acoeff(2,ib)*vqp0   &
             +save_mp_acoeff(3,ib)*l3qp0  &
             +save_mp_acoeff(4,ib)*l4qp0)*sumdena 
    enddo  
   else
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= mpq(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,l4qp0)
     call contr(mp_vveca(:,ib),qp0,vqp0)
     call contr(mp_kvec(:,ib),qp0,kqp0)
     sumdena= 0.d0 
     do k= 2,np
      sumdena= sumdena+(value(mp_den(bn1(np,k,i)),mpq)-mpqt2)
     enddo
     start= start+(                  &
              mp_acoeff(0,ib)        & 
             +mp_acoeff(1,ib)*kqp0   &
             +mp_acoeff(2,ib)*vqp0   &
             +mp_acoeff(3,ib)*l3qp0  &
             +mp_acoeff(4,ib)*l4qp0)*sumdena 
    enddo  
   endif
!
!  contribution from the b sector:
!
   do i= 1,nbn2(np)
    ib= mbn2(np,i)
    do k= 0,3
     qp0(k)= mpq(k)+mp_p0vec(k,ib) 
    enddo
    call contr(mp_l3vec(:,ib),qp0,l3qp0)
    call contr(mp_l4vec(:,ib),qp0,l4qp0)
    call contr(mp_vvecb(:,ib),qp0,vqp0)
    sumdenb= 0.d0 
    do k= 3,np
     sumdenb= sumdenb+(value(mp_den(bn2(np,k,i)),mpq)-mpqt2)
    enddo
    if (iteration.eq.1) start= start+save_mp_bcoeff(0,ib)
    if (iteration.eq.2) start= start+(bset(ib,2)+bset(ib,3))/2.d0
    start=  start+(                            & 
             save_mp_bcoeff(1,ib)*l3qp0           &
            +save_mp_bcoeff(2,ib)*l4qp0           &
            +save_mp_bcoeff(3,ib)*vqp0            &
            +save_mp_bcoeff(4,ib)*(l3qp0)**2      &
            +save_mp_bcoeff(5,ib)*(l4qp0)**2      &
            +save_mp_bcoeff(6,ib)*vqp0**2         &
            +save_mp_bcoeff(7,ib)*vqp0*l3qp0      &
            +save_mp_bcoeff(8,ib)*vqp0*l4qp0)     &    
            +mp_bcoeff_2(ib)*sumdenb
   enddo  
!
!  contribution from the c sector:
!
   do i= 1,nbn3(np)
    ib= mbn3(np,i)
    do k= 0,3 
     qp0(k)= mpq(k)+mp_p0vec(k,ib) 
    enddo
    call contr(mp_l3vec(:,ib),qp0,l3qp0)
    call contr(mp_l4vec(:,ib),qp0,l4qp0)
    start= start+(mp_ccoeff_2(0,ib)               &
                 +mp_ccoeff_2(1,ib)*l3qp0         &
                 +mp_ccoeff_2(2,ib)*l4qp0)        
   enddo
   rat1_d= -start
   rat1_d=-rat1_d/6.d0 ! multiplying by the R_2 integral
   end subroutine getd_last1
!
   subroutine getd_last2(q,rat1_d)
    include 'cts_dpc.h'
     , intent(in), dimension(0:3) :: q
    include 'cts_mpc.h'
     , dimension(0:3) :: mpq
    include 'cts_mpc.h'
     , intent(out) :: rat1_d
    include 'cts_mpc.h'
     , dimension(1:(number_propagators-2)) :: x
    include 'cts_mpc.h'
     , dimension(0:(number_propagators-2)) :: dres
    include 'cts_mpc.h' 
     :: mpqt2_save 
    integer :: n,ntot,kmax 
    do k= 0,3; mpq(k)= q(k)*c1(p); enddo
    mpqt2_save= mpqt2        ! store the current value of qt2
    dres(0)= numd(number_propagators,mpq,0) ! compute sumd at x(0)= qt2
    kmax= number_propagators-2
    ntot= kmax+1
    do n= 1,ntot-1
     x(n)= mpqt2*exp(-2.d0*ci(p)*pi(p)*n/ntot)
    enddo
    do n= 1,ntot-1
     mpqt2= x(n)
     call getd(p,numdummy,number_propagators,dmr1)  
     dres(n)= numd(number_propagators,mpq,0) ! compute sumd at x(n)
    enddo
    rat1_d= 0.d0
    do n= 0,ntot-1
     rat1_d= rat1_d+dres(n)*exp(2.d0*ci(p)*pi(p)*n*kmax/ntot)
    enddo
    mpqt2= mpqt2_save         ! reload the initial value of qt2
    rat1_d= rat1_d/ntot/mpqt2**kmax
    rat1_d=-rat1_d/6.d0   ! multiplying by the R_2 integral
   end subroutine getd_last2
!
   subroutine getd_last3(q,rat1_d)
    include 'cts_dpc.h'
     , intent(in), dimension(0:3) :: q
    include 'cts_mpc.h'
     , dimension(0:3) :: mpq
    include 'cts_mpc.h'
     , intent(out) :: rat1_d
    include 'cts_mpc.h' 
     :: mpqt2_save 
    do k= 0,3; mpq(k)= q(k)*c1(p); enddo
    mpqt2_save= mpqt2        ! store the current value of qt2
    mpqt2= qt2_inf 
    call getd(p,numdummy,number_propagators,dmr1)  
    rat1_d= numd(number_propagators,mpq,0) ! compute sumd at qt2_inf
    rat1_d= rat1_d/mpqt2**(number_propagators-2)
    rat1_d=-rat1_d/6.d0   ! multiplying by the R_2 integral
    mpqt2= mpqt2_save         ! reload the initial value of qt2
   end subroutine getd_last3
!
   subroutine load_set(n)
   integer, intent(in) :: n
   do k= 1,nbn1(number_propagators)
    ib= mbn1(number_propagators,k)
    aset(ib,n)= mp_acoeff(0,ib)
   enddo
   do k= 1,nbn2(number_propagators)
    ib= mbn2(number_propagators,k)
    bset(ib,n)= mp_bcoeff(0,ib)
   enddo
   do k= 1,nbn3(number_propagators)
    ib= mbn3(number_propagators,k)
    cset(ib,n)= mp_ccoeff(0,ib)
   enddo
   end subroutine load_set
!
   subroutine load_rat(n)
   integer, intent(in) :: n
   rset(n)= mp_rat1 
   end subroutine load_rat
!
   subroutine finalize_sets
   do k= 1,nbn1(number_propagators)
    ib= mbn1(number_propagators,k)
    mp_acoeff(0,ib) = aset(ib,3)
   enddo
   do k= 1,nbn2(number_propagators)
    ib= mbn2(number_propagators,k)
    mp_bcoeff(0,ib)= (bset(ib,2)+bset(ib,3))/2.d0 
   enddo
   do k= 1,nbn3(number_propagators)
    ib= mbn3(number_propagators,k)
    mp_ccoeff(0,ib)= (cset(ib,2)+cset(ib,3))/2.d0
    mp_ccoeff(1,ib)= save_mp_ccoeff(1,ib) ! to put it to the true value  
    mp_ccoeff(2,ib)= save_mp_ccoeff(2,ib) ! to put it to the true value
   enddo
   save_mp_rat1= rset(1) 
   mp_rat1     = rset(2) 
   end subroutine finalize_sets
!
  end subroutine mp_get_coefficients
!
  subroutine dp_put_dcoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dmns_d
    save_dcoeff(i,j)= dcoeff(i,j)
   enddo; enddo
  end subroutine dp_put_dcoeff
!
  subroutine dp_get_dcoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dmns_d
    dcoeff(i,j)= save_dcoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_dcoeff
!
  subroutine dp_put_ccoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dmns_c
    save_ccoeff(i,j)= ccoeff(i,j)
   enddo; enddo
  end subroutine dp_put_ccoeff
!
  subroutine dp_get_ccoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dmns_c
    ccoeff(i,j)= save_ccoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_ccoeff
!
  subroutine dp_put_bcoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dmns_b
    save_bcoeff(i,j)= bcoeff(i,j)
   enddo; enddo
  end subroutine dp_put_bcoeff
!
  subroutine dp_get_bcoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dmns_b
    bcoeff(i,j)= save_bcoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_bcoeff
!
  subroutine dp_put_acoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,4; do j= 1,dmns_a
    save_acoeff(i,j)= acoeff(i,j)
   enddo; enddo
  end subroutine dp_put_acoeff
!
  subroutine dp_get_acoeff(p)
   include 'cts_dpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,4; do j= 1,dmns_a
    acoeff(i,j)= save_acoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_acoeff
!
  subroutine mp_put_dcoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dmns_d
    save_mp_dcoeff(i,j)= mp_dcoeff(i,j)
   enddo; enddo
  end subroutine mp_put_dcoeff
!
  subroutine mp_get_dcoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dmns_d
    mp_dcoeff(i,j)= save_mp_dcoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_dcoeff
!
  subroutine mp_put_ccoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dmns_c
    save_mp_ccoeff(i,j)= mp_ccoeff(i,j)
   enddo; enddo
  end subroutine mp_put_ccoeff
!
  subroutine mp_get_ccoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dmns_c
    mp_ccoeff(i,j)= save_mp_ccoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_ccoeff
!
  subroutine mp_put_bcoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dmns_b
    save_mp_bcoeff(i,j)= mp_bcoeff(i,j)
   enddo; enddo
  end subroutine mp_put_bcoeff
!
  subroutine mp_get_bcoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dmns_b
    mp_bcoeff(i,j)= save_mp_bcoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_bcoeff
!
  subroutine mp_put_acoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,4; do j= 1,dmns_a
    save_mp_acoeff(i,j)= mp_acoeff(i,j)
   enddo; enddo
  end subroutine mp_put_acoeff
!
  subroutine mp_get_acoeff(p)
   include 'cts_mpr.h'
    , intent(in) :: p
   integer :: i,j
   do i= 0,4; do j= 1,dmns_a
    mp_acoeff(i,j)= save_mp_acoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_acoeff
!
  subroutine dp_getd(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: dmr
   integer, intent(in) :: number_propagators
   type(solcut4) :: cut4 
   integer :: i,ib,k
   integer :: np
   include 'cts_dpc.h'
    , dimension(0:3) :: qpp0
   include 'cts_dpc.h' 
    :: tqpp0
   include 'cts_dpc.h' 
    :: f1,f2
   dcoeff= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   else
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     call cut(den(bn4(np,1,i)),den(bn4(np,2,i)),den(bn4(np,3,i)), &
              den(bn4(np,4,i)),cut4) 
     do k= 0,3
      tvec(k,ib) =  cut4%t(k)
      p0vec(k,ib)=  den(bn4(np,1,i))%p(k)
      qpp0(k)= cut4%q(k,1)+p0vec(k,ib)
     enddo
     call contr(tvec(:,ib),qpp0,tqpp0)
     f1= fnum(1) 
     f2= fnum(2) 
     dcoeff(0,ib)= 0.5d0*(f1+f2)
     dcoeff(1,ib)= 0.5d0*(f1-f2)/tqpp0
    enddo
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 5,np
    allden= allden*vden(den(bn4(np,k,i))%i,j)
   enddo
   mprec=.false.
   dpq  = cut4%q(:,j)
! comment
   if (rational.and.(.not.inf)) then 
    call numfuncrec(np,cut4%q(:,j),j,dpres) 
   else
    call numfunc(numdummy)
   endif
! comment
   fnum= dpres/allden
   end function fnum
  end subroutine dp_getd 
!
  subroutine dp_getc(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(solcut3) :: cut3 
   integer :: i,ib,k,m 
   integer :: np
   include 'cts_dpc.h' 
    :: gm,cc,tau,cph,f1,f2,f3,f4,&
      f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16
   include 'cts_dpc.h' 
    :: sum,fv(0:3),gv(0:3),r(0:7),ccpar(-3:3)
   include 'cts_dpc.h' 
    :: cdelta,rp(0:7)= 0.d0,fvp(0:3),cden1,cden2,c34
   include 'cts_dpc.h' 
    :: ca1,ca2,ca3,ca4,ca5
   if (.not.rational) ccoeff= c0(p)
   if (rational)     call get_ccoeff(p)
   np= number_propagators
   if (dmr.ge.4) return
   if     (np.lt.3) then
   else   
    if     (dmr.eq.3) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3,dmr) 
      ccoeff(0,ib)= fnum(1)
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.2) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3,dmr) 
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      r(0) = fnum(1)
      r(4) = fnum(2)
      rp(0)= fnum(3) 
      ca1= 0.5d0*(r(0)-r(4))
      ca2= 0.5d0*(r(0)+r(4))
      ca3= rp(0)-ca2      
      ccoeff(0,ib)= ca2
      ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
      ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3,dmr) 
      if (rational) then
       r(0) = fnum(1)-fnuminv(1,1)
       r(4) = fnum(2)-fnuminv(2,1)
       ccoeff(0,ib)= 0.5d0*(r(0)+r(4))    
       cycle
      else
       do k= 0,3
        l3vec(k,ib) =  cut3%l3(k)
        l4vec(k,ib) =  cut3%l4(k)
        p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
       enddo
      endif 
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      r(0) = fnum(1)
      r(4) = fnum(2)
      r(6) = fnum(3)
      rp(0)= fnum(4) 
      rp(4)= fnum(5) 
      ca1= 0.5d0*(r(0)-r(4))
      ca2= 0.5d0*(r(0)+r(4))
      ca3= 0.5d0*(rp(0)-rp(4)) 
      ca4= 0.5d0*(rp(0)+rp(4)) 
      ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
      ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
      ca5= r(6)+ci(p)*c34*(ccoeff(1,ib)/tau-ccoeff(2,ib)*cden1)
      ccoeff(0,ib)= 0.5d0*(ca2+ca5)
      ca1= ca2-ccoeff(0,ib)
      ca2= ca4-ccoeff(0,ib)
      ccoeff(3,ib)= c34**2/cdelta*(ca1/tau**2-cden1**2*ca2)
      ccoeff(4,ib)= c34**2/cdelta*(ca2/tau**2-cden1**2*ca1)
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3,dmr) 
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      if (rational) then
       r(0) = fnum(1)-fnuminv(1,2)
       r(4) = fnum(2)-fnuminv(2,2)
       rp(0)= fnum(3)-fnuminv(3,2)
       ca1= 0.5d0*(r(0)-r(4))
       ca2= 0.5d0*(r(0)+r(4))
       ca3= rp(0)-ca2      
       ccoeff(0,ib)= ca2
       ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
       ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
       cycle
      else
       do k= 0,3
        l3vec(k,ib) =  cut3%l3(k)
        l4vec(k,ib) =  cut3%l4(k)
        p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
       enddo
      endif
      r(0) = fnum(1)
      r(2) = fnum(2)
      r(4) = fnum(3)
      r(6) = fnum(4)
      rp(0)= fnum(5) 
      rp(2)= fnum(6) 
      rp(4)= fnum(7) 
      do k= 0,3
       sum= 0.d0
       do m= 0,3
         sum= sum+r(2*m)*(cexp2(p))**(-m*k) 
       enddo
       fv(k)= sum/4.d0 
      enddo
      rp(6)= 4.d0*fv(0)-rp(0)-rp(2)-rp(4) 
      do k= 0,3
       sum= 0.d0
       do m= 0,3
         sum= sum+rp(2*m)*(cexp2(p))**(-m*k) 
       enddo
       fvp(k)= sum/4.d0 
      enddo
      ccoeff(0,ib)= fv(0)
      ccoeff(3,ib)= (fv(2)/tau**2-fvp(2)*cden1**2)*c34**2/cdelta
      ccoeff(4,ib)= (fvp(2)/tau**2-fv(2)*cden1**2)*c34**2/cdelta
      ccoeff(1,ib)= (fv(1)/tau**3-fvp(3)*cden1**3)*c34**3/cdelta
      ccoeff(6,ib)= (fvp(3)/tau**1-fv(1)*cden1**1)*c34**1/cdelta
      ccoeff(5,ib)= (fv(3)/tau**1-fvp(1)*cden1**1)*c34**1/cdelta
      ccoeff(2,ib)= (fvp(1)/tau**3-fv(3)*cden1**3)*c34**3/cdelta
     enddo
    else
     print*,'In subroutine getc '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 4,np
    allden= allden*vden(den(bn3(np,k,i))%i,j)
   enddo
   mprec=.false.
   dpq  = cut3%q(:,j)
! comment
   if (rational) then
    call numfuncrec(np,cut3%q(:,j),j,dpres) 
   else
    call numfunc(numdummy)
   endif
! comment
   fnum=  (dpres-numd(np,cut3%q(:,j),j))/allden
   end function fnum
! 
   function fnuminv(j,level)
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: sum,fnuminv,l3qp0,l4qp0
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   integer, intent(in) :: j,level
   integer :: k
   do k= 0,3
    qp0(k)= cut3%q(k,j)+p0vec(k,ib)
   enddo
   call contr(qp0,l3vec(:,ib),l3qp0)
   call contr(qp0,l4vec(:,ib),l4qp0)
   sum= c0(p)
   if (level.le.1) sum= sum+ccoeff(1,ib)*l3qp0   +ccoeff(2,ib)*l4qp0        
   if (level.le.2) sum= sum+ccoeff(3,ib)*l3qp0**2+ccoeff(4,ib)*l4qp0**2     
   if (level.le.3) sum= sum+ccoeff(5,ib)*l3qp0**3+ccoeff(6,ib)*l4qp0**3     
   fnuminv= sum
   end function fnuminv
!
  end subroutine dp_getc 
!
  subroutine dp_getb(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(solcut2) :: cut2 
   integer :: i,ib,k
   integer :: np
   include 'cts_dpc.h' 
    :: gm,ulambda,usigma,zlambda,zsigma
   include 'cts_dpc.h' 
    :: rden,caus1,caus2,caus3,cflambda,cfsigma
   include 'cts_dpc.h' 
    :: f1,f2,f3,f4,f5,f6,f7,f8,f9,f10
   include 'cts_dpc.h' 
    :: f11,f12,f13,f14,f15,f16,f17,f18
   include 'cts_dpc.h' 
    :: r(0:4)= 0,rp(0:2)= 0,fv(0:2)= 0,fvp(0:2)= 0
   include 'cts_dpc.h' 
    :: rr0,rr2,tau,taul,cf0,cdelta,sf6,sf9
   if (.not.rational) bcoeff= c0(p)
   if (rational)     call get_bcoeff(p)
   np= number_propagators  
   if (dmr.ge.3) return
   if     (np.lt.2) then
   else
    if     (dmr.eq.2) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2,dmr) 
      do k= 0,3 
       p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
       l3vec(k,ib)=  cut2%l3(k)
       l4vec(k,ib)=  cut2%l4(k)
       vvecb(k,ib)=  cut2%v(k)
      enddo
      gm= cut2%gm
      bcoeff(0,ib)=  fnum(1)
      vveck1(ib) =  gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2,dmr) 
      do k= 0,3 
       p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
       l3vec(k,ib)=  cut2%l3(k)
       l4vec(k,ib)=  cut2%l4(k)
       vvecb(k,ib)=  cut2%v(k)
      enddo 
      tau= cut2%tau 
      taul= cut2%taul
      gm = cut2%gm
      cf0= cut2%cf0 
      cdelta= c1(p)-tau**4*cf0**2
      r(0) = fnum(1)
      r(3) = fnum(2)
      rp(0)= fnum(3)
      bcoeff(0,ib)= 0.5d0*(r(0)+r(3))
      fv(0) = 0.5d0*(r(0)-r(3))
      fvp(0)= rp(0)-bcoeff(0,ib)
      bcoeff(1,ib)= -0.5d0*tau/gm/cdelta*(fv(0)-tau**2*cf0*fvp(0))
      bcoeff(2,ib)= -0.5d0*tau/gm/cdelta*(fvp(0)-tau**2*cf0*fv(0))
      bcoeff(4,ib)= 0.d0
      bcoeff(5,ib)= 0.d0
      bcoeff(3,ib)= 2.d0/gm/lambda(p)*sfun(4)
      vveck1(ib) =  gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2,dmr) 
      if (rational) then
       bcoeff(0,ib)= 0.d0
       bcoeff(0,ib)= sfun(1)
       cycle
      else
       do k= 0,3 
        p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
        l3vec(k,ib)=  cut2%l3(k)
        l4vec(k,ib)=  cut2%l4(k)
        vvecb(k,ib)=  cut2%v(k)
       enddo
      endif 
      tau= cut2%tau
      taul= cut2%taul
      gm = cut2%gm
      cf0= cut2%cf0 
      cdelta= c1(p)-tau**6*cf0**3
      r(0) = fnum(1)
      r(2) = fnum(2)
      r(4) = fnum(3)
      rp(0)= fnum(4)
      rp(2)= fnum(5)
      fv(0)= (r(0)+r(2)+r(4))/3.d0
      fv(1)= (r(0)+r(2)/cexp3(p)**2+r(4)/cexp3(p)**4)/3.d0
      fv(2)= (r(0)+r(2)/cexp3(p)**4+r(4)/cexp3(p)**8)/3.d0
      rr0= rp(0)-fv(0)
      rr2= rp(2)-fv(0)
      fvp(2)= (rr2-rr0*cexp3(p)**2)/(cexp3(p)**4-cexp3(p)**2)
      fvp(1)= rr0-fvp(2)
      bcoeff(0,ib)= fv(0) 
      bcoeff(1,ib)=   -tau/2.d0/gm*(fv(1)-tau**4*cf0**2*fvp(2))/cdelta
      bcoeff(2,ib)=   -tau/2.d0/gm*(fvp(1)-tau**4*cf0**2*fv(2))/cdelta
      bcoeff(4,ib)= tau**2/4.d0/gm/gm*(fv(2)-tau**2*cf0*fvp(1))/cdelta
      bcoeff(5,ib)= tau**2/4.d0/gm/gm*(fvp(2)-tau**2*cf0*fv(1))/cdelta
      cflambda= cut2%cflambda
      cfsigma = cut2%cfsigma
      r(0) = sfun(6)
      r(2) = sfun(7)
      fv(0)= (r(0)+r(2))/2.d0
      fv(1)= (r(0)-r(2))/2.d0
      rp(0)= sfun(8)-fv(0)
      fvp(1)= rp(0)
      cdelta= c1(p)-taul**4*cflambda**2
      bcoeff(8,ib)=-taul/gm/gm/lambda(p)*(fvp(1)-fv(1)*cflambda*taul**2)/cdelta
      bcoeff(7,ib)=-taul/gm/gm/lambda(p)*(fv(1)-fvp(1)*cflambda*taul**2)/cdelta
      sf6= r(0)
      sf9= sfun(9)
      ulambda= ufun(6,sf6)
      usigma = ufun(9,sf9)
      cdelta= lambda(p)*sigma(p)*(sigma(p)-lambda(p))
      bcoeff(3,ib)= 2.d0/gm/cdelta*(ulambda*sigma(p)**2-usigma*lambda(p)**2)
      bcoeff(6,ib)= 4.d0/gm/gm/cdelta*(usigma*lambda(p)-ulambda*sigma(p))
      vveck1(ib) = gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    else
     print*,'In subroutine getb '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 3,np
    allden= allden*vden(den(bn2(np,k,i))%i,j)
   enddo
   mprec=.false.
   dpq  = cut2%q(:,j)
! comment
   if (rational) then
    call numfuncrec(np,cut2%q(:,j),j,dpres) 
   else
    call numfunc(numdummy)
   endif
! comment
   fnum =  (dpres                                  &
           -numd(number_propagators,cut2%q(:,j),j) &
           -numc(number_propagators,cut2%q(:,j),j))/allden
   end function fnum
!
   function sfun(j) ! function added
   integer, intent(in) :: j
   include 'cts_dpc.h' 
    :: sfun,l3qp0,l4qp0
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   integer :: k
   do k= 0,3
    qp0(k)= cut2%q(k,j)+p0vec(k,ib)
   enddo
   call contr(qp0,l3vec(:,ib),l3qp0)
   call contr(qp0,l4vec(:,ib),l4qp0)
   sfun= fnum(j)-bcoeff(0,ib)          &
                -bcoeff(1,ib)*l3qp0    &
                -bcoeff(2,ib)*l4qp0    &
                -bcoeff(4,ib)*l3qp0**2 &
                -bcoeff(5,ib)*l4qp0**2
   end function sfun
!
   function ufun(j,sf) ! function added
   integer, intent(in) :: j
   include 'cts_dpc.h'
    , intent(in) :: sf
   include 'cts_dpc.h' 
    :: ufun,l3qp0,l4qp0,vqp0
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   integer :: k
   do k= 0,3
    qp0(k)= cut2%q(k,j)+p0vec(k,ib)
   enddo
   call contr(qp0,l3vec(:,ib),l3qp0)
   call contr(qp0,l4vec(:,ib),l4qp0)
   call contr(qp0,vvecb(:,ib),vqp0)
   ufun= sf-bcoeff(7,ib)*vqp0*l3qp0 &
           -bcoeff(8,ib)*vqp0*l4qp0
   end function ufun
  end subroutine dp_getb 
!
  subroutine dp_geta_oldbase(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: dmr
   integer, intent(in) :: number_propagators
   type(solcut1) :: cut1 
   integer :: i,ib,k
   integer :: np
   include 'cts_dpc.h' 
    :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else 
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1,dmr) 
      acoeff(0,ib)= fnum(1)
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vveca(k,ib)= cut1%v(k)
       kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1,dmr) 
      f1= fnum(1)
      f2= fnum(2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      gm = cut1%gm
      cf0= cut1%cf0 
      acoeff(0,ib)=   0.5d0*(f1+f2)
      acoeff(1,ib)= 2.d0/gm*(f3-f1)
      acoeff(2,ib)= 2.d0/gm*(f4-f1)
      r1= -0.5d0*(f1-acoeff(0,ib))/gm
      r2= -0.5d0*(f5-acoeff(0,ib))/gm
      rden= cexpk1(p)*tau12(p)-cf0**2/cexpk1(p)/tau12(p)
      acoeff(3,ib)= (r1*cexpk1(p)*tau12(p)-cf0*r2)/rden*tau11(p)
      acoeff(4,ib)= (r2-cf0*r1/cexpk1(p)/tau12(p))/rden/tau11(p)
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vveca(k,ib)= cut1%v(k)
       kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*vden(den(bn1(np,k,i))%i,j)
   enddo
   mprec=.false.
   dpq= cut1%q(:,j)
! comment
   if (rational) then
    call numfuncrec(np,cut1%q(:,j),j,dpres) 
   else
    call numfunc(numdummy)
   endif
! comment
   fnum =  (dpres                                  &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine dp_geta_oldbase 
!
  subroutine dp_geta_newbase(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(solcut1) :: cut1 
   integer :: i,ib,k
   integer :: np
   include 'cts_dpc.h' 
    :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else   
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1,dmr) 
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vveca(k,ib)= cut1%v(k)
       kvec(k,ib) = cut1%k(k)
      enddo
      acoeff(0,ib)= fnum(1)
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1,dmr) 
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vveca(k,ib)= cut1%v(k)
       kvec(k,ib) = cut1%k(k)
      enddo
      f1= fnum(1)
      f2= fnum(2)
      acoeff(0,ib)= 0.5d0*(f1+f2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      acoeff(1,ib)= 0.5d0*(f5+f4+f3-f2-2.d0*f1)/ci(p)/cut1%apar !0
      acoeff(2,ib)= 0.5d0*(f3-f1)/ci(p)/cut1%root               !x
      acoeff(3,ib)= 0.5d0*(f4-f1)/ci(p)/cut1%root               !y
      acoeff(4,ib)= 0.5d0*(f5-f1)/ci(p)/cut1%root               !z
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_dpr.h' 
    :: p
   include 'cts_dpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*vden(den(bn1(np,k,i))%i,j)
   enddo
   mprec=.false.
   dpq= cut1%q(:,j)
! comment
   if (rational) then
    call numfuncrec(np,cut1%q(:,j),j,dpres) 
   else
    call numfunc(numdummy)
   endif
! comment
   fnum =  (dpres                                  &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine dp_geta_newbase 
!
  function dp_numd(number_propagators,q,j)
   include 'cts_dpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   include 'cts_dpc.h' 
    :: dp_numd,start,tqp0  
   include 'cts_dpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   else   
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 5,np
       allden= allden*value(den(bn4(np,k,i)),q) 
      enddo
     elseif (j.lt.0) then
      do k= 5,np
       allden= allden*(vden(den(bn4(np,k,i))%i,jj)-qt2) 
      enddo
     else
      do k= 5,np
       allden= allden*vden(den(bn4(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(tvec(:,ib),qp0,tqp0)
     if (j.lt.0) then
      start= start+(save_dcoeff(0,ib)+save_dcoeff(1,ib)*tqp0)&
            *allden
     else
      start= start+(dcoeff(0,ib)+dcoeff(1,ib)*tqp0)&
            *allden
     endif
    enddo  
   endif
   dp_numd= start
  end function dp_numd
!
  function dp_numc(number_propagators,q,j)
   include 'cts_dpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   include 'cts_dpc.h' 
    :: l3qp0,l4qp0
   include 'cts_dpc.h' 
    :: dp_numc,start
   include 'cts_dpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.3) then
   else
    do i= 1,nbn3(np)
     ib= mbn3(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 4,np
       allden= allden*value(den(bn3(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 4,np
       allden= allden*(vden(den(bn3(np,k,i))%i,jj)-qt2)
      enddo
     else
      do k= 4,np
       allden= allden*vden(den(bn3(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3 
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,l3qp0)
     call contr(l4vec(:,ib),qp0,l4qp0)
     if (j.lt.0) then
      start= start+(save_ccoeff(0,ib)               &
                   +save_ccoeff(1,ib)*l3qp0         &
                   +save_ccoeff(2,ib)*l4qp0         &
                   +save_ccoeff(3,ib)*l3qp0**2      &
                   +save_ccoeff(4,ib)*l4qp0**2      &
                   +save_ccoeff(5,ib)*l3qp0**3      &
                   +save_ccoeff(6,ib)*l4qp0**3)     &
                   *allden 
     else
      start= start+(ccoeff(0,ib)               &
                   +ccoeff(1,ib)*l3qp0         &
                   +ccoeff(2,ib)*l4qp0         &
                   +ccoeff(3,ib)*l3qp0**2      &
                   +ccoeff(4,ib)*l4qp0**2      &
                   +ccoeff(5,ib)*l3qp0**3      &
                   +ccoeff(6,ib)*l4qp0**3)     &
                   *allden 
     endif
    enddo  
   endif
   dp_numc= start
  end function dp_numc
!
  function dp_numb(number_propagators,q,j)
   include 'cts_dpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   include 'cts_dpc.h' 
    :: l3qp0,l4qp0,vqp0
   include 'cts_dpc.h' 
    :: dp_numb,start
   include 'cts_dpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.2) then
   else    
    do i= 1,nbn2(np)
     ib= mbn2(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 3,np
       allden= allden*value(den(bn2(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 3,np
       allden= allden*(vden(den(bn2(np,k,i))%i,jj)-qt2)
      enddo
     else
      do k= 3,np
       allden= allden*vden(den(bn2(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,l3qp0)
     call contr(l4vec(:,ib),qp0,l4qp0)
     call contr(vvecb(:,ib),qp0,vqp0)
     if (j.lt.0) then
      start= start+(                             &
               save_bcoeff(0,ib)                 &
              +save_bcoeff(1,ib)*l3qp0           &
              +save_bcoeff(2,ib)*l4qp0           &
              +save_bcoeff(3,ib)*vqp0            &
              +save_bcoeff(4,ib)*(l3qp0)**2      &
              +save_bcoeff(5,ib)*(l4qp0)**2      &
              +save_bcoeff(6,ib)*vqp0**2         &
              +save_bcoeff(7,ib)*vqp0*l3qp0      &
              +save_bcoeff(8,ib)*vqp0*l4qp0)     &
              *allden
     else
      start= start+(                        &
               bcoeff(0,ib)                 &
              +bcoeff(1,ib)*l3qp0           &
              +bcoeff(2,ib)*l4qp0           &
              +bcoeff(3,ib)*vqp0            &
              +bcoeff(4,ib)*(l3qp0)**2      &
              +bcoeff(5,ib)*(l4qp0)**2      &
              +bcoeff(6,ib)*vqp0**2         &
              +bcoeff(7,ib)*vqp0*l3qp0      &
              +bcoeff(8,ib)*vqp0*l4qp0)     &
              *allden
     endif 
    enddo  
   endif
   dp_numb= start
  end function dp_numb
!
  function dp_numa(number_propagators,q,j)
   include 'cts_dpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_dpc.h'
    , dimension(0:3) :: qp0
   include 'cts_dpc.h' 
    :: l3qp0,l4qp0,vqp0,kqp0
   include 'cts_dpc.h' 
    :: dp_numa,start
   include 'cts_dpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.1) then
    print*,'In function numa '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else 
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 2,np
       allden= allden*value(den(bn1(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 2,np
       allden= allden*(vden(den(bn1(np,k,i))%i,jj)-qt2)
      enddo
     else
      do k= 2,np
       allden= allden*vden(den(bn1(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif  
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,l3qp0)
     call contr(l4vec(:,ib),qp0,l4qp0)
     call contr(vveca(:,ib),qp0,vqp0)
     call contr(kvec(:,ib),qp0,kqp0)
     if (j.lt.0) then 
      start= start+(                    &
               save_acoeff(0,ib)        & 
              +save_acoeff(1,ib)*kqp0   &
              +save_acoeff(2,ib)*vqp0   &
              +save_acoeff(3,ib)*l3qp0  &
              +save_acoeff(4,ib)*l4qp0) &
              *allden
     else
      start= start+(               &
               acoeff(0,ib)        & 
              +acoeff(1,ib)*kqp0   &
              +acoeff(2,ib)*vqp0   &
              +acoeff(3,ib)*l3qp0  &
              +acoeff(4,ib)*l4qp0) &
              *allden
     endif
    enddo  
   endif
   dp_numa= start
  end function dp_numa
!
  subroutine dp_numfuncrec(number_propagators,q,j,dpres) 
   integer, intent(in) :: number_propagators,j
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_dpc.h'
    , intent(out) :: dpres
   include 'cts_dpc.h' 
    :: num_d, num_c, num_b, num_a
   num_d= numd(number_propagators,q,-j)
   num_c= numc(number_propagators,q,-j)
   num_b= numb(number_propagators,q,-j)
   num_a= numa(number_propagators,q,-j)
   dpres= num_d+num_c+num_b+num_a
  end subroutine dp_numfuncrec
!
  subroutine mp_getd(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   integer, intent(in) :: dmr
   integer, intent(in) :: number_propagators
   type(mp_solcut4) :: cut4 
   integer :: i,ib,k
   integer :: np
   include 'cts_mpc.h'
    , dimension(0:3) :: qpp0
   include 'cts_mpc.h' 
    :: tqpp0
   include 'cts_mpc.h' 
    :: f1,f2
   mp_dcoeff= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   else   
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     call cut(mp_den(bn4(np,1,i)),mp_den(bn4(np,2,i)),mp_den(bn4(np,3,i)), &
              mp_den(bn4(np,4,i)),cut4) 
     do k= 0,3
      mp_tvec(k,ib) =  cut4%t(k)
      mp_p0vec(k,ib)=  mp_den(bn4(np,1,i))%p(k)
      qpp0(k)= cut4%q(k,1)+mp_p0vec(k,ib)
     enddo
     call contr(mp_tvec(:,ib),qpp0,tqpp0)
     f1= fnum(1) 
     f2= fnum(2) 
     mp_dcoeff(0,ib)= 0.5d0*(f1+f2)
     mp_dcoeff(1,ib)= 0.5d0*(f1-f2)/tqpp0
    enddo
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 5,np
    allden= allden*mp_vden(mp_den(bn4(np,k,i))%i,j)
   enddo
   mprec=.true.
   mpq= cut4%q(:,j)
! comment
!!   if (rational.and.(.not.inf)) then 
!!    call numfuncrec(np,cut4%q(:,j),j,mpres) 
!!   else
    call numfunc(numdummy)
!!   endif
! comment
   fnum= mpres/allden
   end function fnum
  end subroutine mp_getd 
!
  subroutine mp_getc(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(mp_solcut3) :: cut3 
   integer :: i,ib,k,m 
   integer :: np
   include 'cts_mpc.h' 
    :: gm,cc,tau,cph,f1,f2,f3,f4,&
      f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16
   include 'cts_mpc.h' 
    :: sum,fv(0:3),gv(0:3),r(0:7),ccpar(-3:3)
   include 'cts_mpc.h' 
    :: cdelta,rp(0:7),fvp(0:3),cden1,cden2,c34
   include 'cts_mpc.h' 
    :: ca1,ca2,ca3,ca4,ca5
   if (.not.rational) mp_ccoeff= c0(p)
   if (rational)     call get_ccoeff(p)
   np= number_propagators
   if (dmr.ge.4) return
   if     (np.lt.3) then
   else   
    if     (dmr.eq.3) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3,dmr) 
      mp_ccoeff(0,ib)= fnum(1)
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.2) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3,dmr) 
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      r(0) = fnum(1)
      r(4) = fnum(2)
      rp(0)= fnum(3) 
      ca1= 0.5d0*(r(0)-r(4))
      ca2= 0.5d0*(r(0)+r(4))
      ca3= rp(0)-ca2      
      mp_ccoeff(0,ib)= ca2
      mp_ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
      mp_ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3,dmr) 
      if (rational) then
       r(0) = fnum(1)-fnuminv(1,1)
       r(4) = fnum(2)-fnuminv(2,1)
       mp_ccoeff(0,ib)= 0.5d0*(r(0)+r(4))    
       cycle
      else
       do k= 0,3
        mp_l3vec(k,ib) =  cut3%l3(k)
        mp_l4vec(k,ib) =  cut3%l4(k)
        mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
       enddo
      endif 
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      r(0) = fnum(1)
      r(4) = fnum(2)
      r(6) = fnum(3)
      rp(0)= fnum(4) 
      rp(4)= fnum(5) 
      ca1= 0.5d0*(r(0)-r(4))
      ca2= 0.5d0*(r(0)+r(4))
      ca3= 0.5d0*(rp(0)-rp(4)) 
      ca4= 0.5d0*(rp(0)+rp(4)) 
      mp_ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
      mp_ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
      ca5= r(6)+ci(p)*c34*(mp_ccoeff(1,ib)/tau-mp_ccoeff(2,ib)*cden1)
      mp_ccoeff(0,ib)= 0.5d0*(ca2+ca5)
      ca1= ca2-mp_ccoeff(0,ib)
      ca2= ca4-mp_ccoeff(0,ib)
      mp_ccoeff(3,ib)= c34**2/cdelta*(ca1/tau**2-cden1**2*ca2)
      mp_ccoeff(4,ib)= c34**2/cdelta*(ca2/tau**2-cden1**2*ca1)
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3,dmr) 
      cc = cut3%cc
      tau= cut3%tau
      c34= -2.d0*cut3%gm
      cden1= cc*tau
      cden2= c1(p)/tau**4-cc**4*tau**4
      cdelta= cden2*c34**4
      if (rational) then
       r(0) = fnum(1)-fnuminv(1,2)
       r(4) = fnum(2)-fnuminv(2,2)
       rp(0)= fnum(3)-fnuminv(3,2)
       ca1= 0.5d0*(r(0)-r(4))
       ca2= 0.5d0*(r(0)+r(4))
       ca3= rp(0)-ca2      
       mp_ccoeff(0,ib)= ca2
       mp_ccoeff(1,ib)= c34**3*(ca1/tau-cden1*ca3)*(c1(p)/tau**2+cden1**2)/cdelta
       mp_ccoeff(2,ib)= c34**3*(ca3/tau-cden1*ca1)*(c1(p)/tau**2+cden1**2)/cdelta
       cycle
      else
       do k= 0,3
        mp_l3vec(k,ib) =  cut3%l3(k)
        mp_l4vec(k,ib) =  cut3%l4(k)
        mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
       enddo
      endif
      r(0) = fnum(1)
      r(2) = fnum(2)
      r(4) = fnum(3)
      r(6) = fnum(4)
      rp(0)= fnum(5) 
      rp(2)= fnum(6) 
      rp(4)= fnum(7) 
      do k= 0,3
       sum= 0.d0
       do m= 0,3
         sum= sum+r(2*m)*(cexp2(p))**(-m*k) 
       enddo
       fv(k)= sum/4.d0 
      enddo
      rp(6)= 4.d0*fv(0)-rp(0)-rp(2)-rp(4) 
      do k= 0,3
       sum= 0.d0
       do m= 0,3
         sum= sum+rp(2*m)*(cexp2(p))**(-m*k) 
       enddo
       fvp(k)= sum/4.d0 
      enddo
      mp_ccoeff(0,ib)= fv(0)
      mp_ccoeff(3,ib)= (fv(2)/tau**2-fvp(2)*cden1**2)*c34**2/cdelta
      mp_ccoeff(4,ib)= (fvp(2)/tau**2-fv(2)*cden1**2)*c34**2/cdelta
      mp_ccoeff(1,ib)= (fv(1)/tau**3-fvp(3)*cden1**3)*c34**3/cdelta
      mp_ccoeff(6,ib)= (fvp(3)/tau**1-fv(1)*cden1**1)*c34**1/cdelta
      mp_ccoeff(5,ib)= (fv(3)/tau**1-fvp(1)*cden1**1)*c34**1/cdelta
      mp_ccoeff(2,ib)= (fvp(1)/tau**3-fv(3)*cden1**3)*c34**3/cdelta
     enddo
    else
     print*,'In subroutine getc '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 4,np
    allden= allden*mp_vden(mp_den(bn3(np,k,i))%i,j)
   enddo
   mprec=.true.
   mpq= cut3%q(:,j)
! comment
!!   if (rational) then
!!    call numfuncrec(np,cut3%q(:,j),j,mpres) 
!!   else
    call numfunc(numdummy)
!!   endif
! comment
   fnum=  (mpres-numd(np,cut3%q(:,j),j))/allden
   end function fnum
! 
   function fnuminv(j,level) 
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: sum,fnuminv,l3qp0,l4qp0
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   integer, intent(in) :: j,level
   integer :: k
   do k= 0,3
    qp0(k)= cut3%q(k,j)+mp_p0vec(k,ib) 
   enddo
   call contr(qp0,mp_l3vec(:,ib),l3qp0)
   call contr(qp0,mp_l4vec(:,ib),l4qp0)
   sum= c0(p)
   if (level.le.1) sum= sum+mp_ccoeff(1,ib)*l3qp0   +mp_ccoeff(2,ib)*l4qp0    
   if (level.le.2) sum= sum+mp_ccoeff(3,ib)*l3qp0**2+mp_ccoeff(4,ib)*l4qp0**2 
   if (level.le.3) sum= sum+mp_ccoeff(5,ib)*l3qp0**3+mp_ccoeff(6,ib)*l4qp0**3 
   fnuminv= sum
   end function fnuminv
  end subroutine mp_getc 
!
  subroutine mp_getb(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(mp_solcut2) :: cut2 
   integer :: i,ib,k
   integer :: np
   include 'cts_mpc.h' 
    :: gm,ulambda,usigma,zlambda,zsigma
   include 'cts_mpc.h' 
    :: rden,caus1,caus2,caus3,cflambda,cfsigma
   include 'cts_mpc.h' 
    :: f1,f2,f3,f4,f5,f6,f7,f8,f9,f10
   include 'cts_mpc.h' 
    :: f11,f12,f13,f14,f15,f16,f17,f18
   include 'cts_mpc.h' 
    :: r(0:4),rp(0:2),fv(0:2),fvp(0:2)
   include 'cts_mpc.h' 
    :: rr0,rr2,tau,taul,cf0,cdelta,sf6,sf9
   if (.not.rational) mp_bcoeff= c0(p)
   if (rational)     call get_bcoeff(p)
   np= number_propagators  
   if (dmr.ge.3) return
   if     (np.lt.2) then
   else
    if     (dmr.eq.2) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2,dmr) 
      do k= 0,3 
       mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
       mp_l3vec(k,ib)=  cut2%l3(k)
       mp_l4vec(k,ib)=  cut2%l4(k)
       mp_vvecb(k,ib)=  cut2%v(k)
      enddo
      gm= cut2%gm
      mp_bcoeff(0,ib)=  fnum(1)
      mp_vveck1(ib) =  gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2,dmr) 
      do k= 0,3 
       mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
       mp_l3vec(k,ib)=  cut2%l3(k)
       mp_l4vec(k,ib)=  cut2%l4(k)
       mp_vvecb(k,ib)=  cut2%v(k)
      enddo 
      tau= cut2%tau 
      taul= cut2%taul
      gm = cut2%gm
      cf0= cut2%cf0 
      cdelta= c1(p)-tau**4*cf0**2
      r(0) = fnum(1)
      r(3) = fnum(2)
      rp(0)= fnum(3)
      mp_bcoeff(0,ib)= 0.5d0*(r(0)+r(3))
      fv(0) = 0.5d0*(r(0)-r(3))
      fvp(0)= rp(0)-mp_bcoeff(0,ib)
      mp_bcoeff(1,ib)= -0.5d0*tau/gm/cdelta*(fv(0)-tau**2*cf0*fvp(0))
      mp_bcoeff(2,ib)= -0.5d0*tau/gm/cdelta*(fvp(0)-tau**2*cf0*fv(0))
      mp_bcoeff(4,ib)= 0.d0
      mp_bcoeff(5,ib)= 0.d0
      mp_bcoeff(3,ib)= 2.d0/gm/lambda(p)*sfun(4)
      mp_vveck1(ib) =  gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2,dmr) 
      if (rational) then
       mp_bcoeff(0,ib)= 0.d0
       mp_bcoeff(0,ib)= sfun(1)
       cycle
      else
       do k= 0,3 
        mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
        mp_l3vec(k,ib)=  cut2%l3(k)
        mp_l4vec(k,ib)=  cut2%l4(k)
        mp_vvecb(k,ib)=  cut2%v(k)
       enddo
      endif 
      tau= cut2%tau
      taul= cut2%taul
      gm = cut2%gm
      cf0= cut2%cf0 
      cdelta= c1(p)-tau**6*cf0**3
      r(0) = fnum(1)
      r(2) = fnum(2)
      r(4) = fnum(3)
      rp(0)= fnum(4)
      rp(2)= fnum(5)
      fv(0)= (r(0)+r(2)+r(4))/3.d0
      fv(1)= (r(0)+r(2)/cexp3(p)**2+r(4)/cexp3(p)**4)/3.d0
      fv(2)= (r(0)+r(2)/cexp3(p)**4+r(4)/cexp3(p)**8)/3.d0
      rr0= rp(0)-fv(0)
      rr2= rp(2)-fv(0)
      fvp(2)= (rr2-rr0*cexp3(p)**2)/(cexp3(p)**4-cexp3(p)**2)
      fvp(1)= rr0-fvp(2)
      mp_bcoeff(0,ib)= fv(0) 
      mp_bcoeff(1,ib)=   -tau/2.d0/gm*(fv(1)-tau**4*cf0**2*fvp(2))/cdelta
      mp_bcoeff(2,ib)=   -tau/2.d0/gm*(fvp(1)-tau**4*cf0**2*fv(2))/cdelta
      mp_bcoeff(4,ib)= tau**2/4.d0/gm/gm*(fv(2)-tau**2*cf0*fvp(1))/cdelta
      mp_bcoeff(5,ib)= tau**2/4.d0/gm/gm*(fvp(2)-tau**2*cf0*fv(1))/cdelta
      cflambda= cut2%cflambda
      cfsigma = cut2%cfsigma
      r(0) = sfun(6)
      r(2) = sfun(7)
      fv(0)= (r(0)+r(2))/2.d0
      fv(1)= (r(0)-r(2))/2.d0
      rp(0)= sfun(8)-fv(0)
      fvp(1)= rp(0)
      cdelta= c1(p)-taul**4*cflambda**2
      mp_bcoeff(8,ib)=-taul/gm/gm/lambda(p)*(fvp(1)-fv(1)*cflambda*taul**2)/cdelta
      mp_bcoeff(7,ib)=-taul/gm/gm/lambda(p)*(fv(1)-fvp(1)*cflambda*taul**2)/cdelta
      sf6= r(0)
      sf9= sfun(9)
      ulambda= ufun(6,sf6)
      usigma = ufun(9,sf9)
      cdelta= lambda(p)*sigma(p)*(sigma(p)-lambda(p))
      mp_bcoeff(3,ib)= 2.d0/gm/cdelta*(ulambda*sigma(p)**2-usigma*lambda(p)**2)
      mp_bcoeff(6,ib)= 4.d0/gm/gm/cdelta*(usigma*lambda(p)-ulambda*sigma(p))
      mp_vveck1(ib) = gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    else
     print*,'In subroutine getb '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 3,np
    allden= allden*mp_vden(mp_den(bn2(np,k,i))%i,j)
   enddo
   mprec=.true.
   mpq= cut2%q(:,j)
! comment
!!   if (rational) then
!!    call numfuncrec(np,cut2%q(:,j),j,mpres) 
!!   else
    call numfunc(numdummy)
!!   endif
! comment
   fnum =  (mpres                                  &
           -numd(number_propagators,cut2%q(:,j),j) &
           -numc(number_propagators,cut2%q(:,j),j))/allden
   end function fnum
!
   function sfun(j) ! function added
   integer, intent(in) :: j
   include 'cts_mpc.h' 
    :: sfun,l3qp0,l4qp0
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   integer :: k
   do k= 0,3
    qp0(k)= cut2%q(k,j)+mp_p0vec(k,ib)
   enddo
   call contr(qp0,mp_l3vec(:,ib),l3qp0)
   call contr(qp0,mp_l4vec(:,ib),l4qp0)
   sfun= fnum(j)-mp_bcoeff(0,ib)          &
                -mp_bcoeff(1,ib)*l3qp0    &
                -mp_bcoeff(2,ib)*l4qp0    &
                -mp_bcoeff(4,ib)*l3qp0**2 &
                -mp_bcoeff(5,ib)*l4qp0**2
   end function sfun
!
   function ufun(j,sf) ! function added
   integer, intent(in) :: j
   include 'cts_mpc.h'
    , intent(in) :: sf
   include 'cts_mpc.h' 
    :: ufun,l3qp0,l4qp0,vqp0
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   integer :: k
   do k= 0,3
    qp0(k)= cut2%q(k,j)+mp_p0vec(k,ib)
   enddo
   call contr(qp0,mp_l3vec(:,ib),l3qp0)
   call contr(qp0,mp_l4vec(:,ib),l4qp0)
   call contr(qp0,mp_vvecb(:,ib),vqp0)
   ufun= sf-mp_bcoeff(7,ib)*vqp0*l3qp0 &
           -mp_bcoeff(8,ib)*vqp0*l4qp0
   end function ufun
  end subroutine mp_getb 
!
  subroutine mp_geta_oldbase(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   integer, intent(in) :: dmr
   integer, intent(in) :: number_propagators
   type(mp_solcut1) :: cut1 
   integer :: i,ib,k
   integer :: np
   include 'cts_mpc.h' 
    :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   mp_acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else 
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1,dmr) 
      mp_acoeff(0,ib)= fnum(1)
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vveca(k,ib)= cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1,dmr) 
      f1= fnum(1)
      f2= fnum(2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      gm = cut1%gm
      cf0= cut1%cf0 
      mp_acoeff(0,ib)=   0.5d0*(f1+f2)
      mp_acoeff(1,ib)= 2.d0/gm*(f3-f1)
      mp_acoeff(2,ib)= 2.d0/gm*(f4-f1)
      r1= -0.5d0*(f1-mp_acoeff(0,ib))/gm
      r2= -0.5d0*(f5-mp_acoeff(0,ib))/gm
      rden= cexpk1(p)*tau12(p)-cf0**2/cexpk1(p)/tau12(p)
      mp_acoeff(3,ib)= (r1*cexpk1(p)*tau12(p)-cf0*r2)/rden*tau11(p)
      mp_acoeff(4,ib)= (r2-cf0*r1/cexpk1(p)/tau12(p))/rden/tau11(p)
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vveca(k,ib)= cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*mp_vden(mp_den(bn1(np,k,i))%i,j)
   enddo
   mprec=.true.
   mpq= cut1%q(:,j)
! comment
!!   if (rational) then
!!    call numfuncrec(np,cut1%q(:,j),j,mpres) 
!!   else
    call numfunc(numdummy)
!!   endif
! comment
   fnum =  (mpres                                  &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine mp_geta_oldbase 
!
  subroutine mp_geta_newbase(p,numdummy,number_propagators,dmr)
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
   integer, intent(in) :: dmr
   type(mp_solcut1) :: cut1 
   integer :: i,ib,k
   integer :: np
   include 'cts_mpc.h' 
    :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   mp_acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else   
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1,dmr) 
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vveca(k,ib)= cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
      mp_acoeff(0,ib)= fnum(1)
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1,dmr) 
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vveca(k,ib)= cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
      f1= fnum(1)
      f2= fnum(2)
      mp_acoeff(0,ib)= 0.5d0*(f1+f2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      mp_acoeff(0,ib)= 0.5d0*(f1+f2)
      mp_acoeff(1,ib)= 0.5d0*(f5+f4+f3-f2-2.d0*f1)/ci(p)/cut1%apar !0
      mp_acoeff(2,ib)= 0.5d0*(f3-f1)/ci(p)/cut1%root               !x
      mp_acoeff(3,ib)= 0.5d0*(f4-f1)/ci(p)/cut1%root               !y
      mp_acoeff(4,ib)= 0.5d0*(f5-f1)/ci(p)/cut1%root               !z
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   endif
   contains
!
   function fnum(j)
   use inout
   include 'cts_mpr.h' 
    :: p
   include 'cts_mpc.h' 
    :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*mp_vden(mp_den(bn1(np,k,i))%i,j)
   enddo
   mprec=.true.
   mpq= cut1%q(:,j)
! comment
!!   if (rational) then
!!    call numfuncrec(np,cut1%q(:,j),j,mpres) 
!!   else
    call numfunc(numdummy)
!!   endif
! comment
   fnum =  (mpres                                  &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine mp_geta_newbase 
!
  function mp_numd(number_propagators,q,j)
   include 'cts_mpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   include 'cts_mpc.h' 
    :: mp_numd,start,tqp0  
   include 'cts_mpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   else   
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 5,np
       allden= allden*value(mp_den(bn4(np,k,i)),q) 
      enddo
     elseif (j.lt.0) then
      do k= 5,np
       allden= allden*(mp_vden(mp_den(bn4(np,k,i))%i,jj)-mpqt2) 
      enddo
     else
      do k= 5,np
       allden= allden*mp_vden(mp_den(bn4(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_tvec(:,ib),qp0,tqp0)
     if (j.lt.0) then
      start= start+(save_mp_dcoeff(0,ib)+save_mp_dcoeff(1,ib)*tqp0)&
            *allden
     else
      start= start+(mp_dcoeff(0,ib)+mp_dcoeff(1,ib)*tqp0)&
            *allden
     endif
    enddo  
   endif
   mp_numd= start
  end function mp_numd
!
  function mp_numc(number_propagators,q,j)
   include 'cts_mpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   include 'cts_mpc.h' 
    :: l3qp0,l4qp0
   include 'cts_mpc.h' 
    :: mp_numc,start
   include 'cts_mpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.3) then
   else   
    do i= 1,nbn3(np)
     ib= mbn3(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 4,np
       allden= allden*value(mp_den(bn3(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 4,np
       allden= allden*(mp_vden(mp_den(bn3(np,k,i))%i,jj)-mpqt2)
      enddo
     else
      do k= 4,np
       allden= allden*mp_vden(mp_den(bn3(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3 
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,l4qp0)
     if (j.lt.0) then
      start= start+(save_mp_ccoeff(0,ib)               &
                   +save_mp_ccoeff(1,ib)*l3qp0         &
                   +save_mp_ccoeff(2,ib)*l4qp0         &
                   +save_mp_ccoeff(3,ib)*l3qp0**2      &
                   +save_mp_ccoeff(4,ib)*l4qp0**2      &
                   +save_mp_ccoeff(5,ib)*l3qp0**3      &
                   +save_mp_ccoeff(6,ib)*l4qp0**3)     &
                   *allden 
     else
      start= start+(mp_ccoeff(0,ib)               &
                   +mp_ccoeff(1,ib)*l3qp0         &
                   +mp_ccoeff(2,ib)*l4qp0         &
                   +mp_ccoeff(3,ib)*l3qp0**2      &
                   +mp_ccoeff(4,ib)*l4qp0**2      &
                   +mp_ccoeff(5,ib)*l3qp0**3      &
                   +mp_ccoeff(6,ib)*l4qp0**3)     &
                   *allden 
     endif
    enddo  
   endif
   mp_numc= start
  end function mp_numc
!
  function mp_numb(number_propagators,q,j)
   include 'cts_mpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   include 'cts_mpc.h' 
    :: l3qp0,l4qp0,vqp0
   include 'cts_mpc.h' 
    :: mp_numb,start
   include 'cts_mpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.2) then
   else   
    do i= 1,nbn2(np)
     ib= mbn2(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 3,np
       allden= allden*value(mp_den(bn2(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 3,np
       allden= allden*(mp_vden(mp_den(bn2(np,k,i))%i,jj)-mpqt2)
      enddo
     else
      do k= 3,np
       allden= allden*mp_vden(mp_den(bn2(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,l4qp0)
     call contr(mp_vvecb(:,ib),qp0,vqp0)
     if (j.lt.0) then
      start= start+(                             &
               save_mp_bcoeff(0,ib)                 &
              +save_mp_bcoeff(1,ib)*l3qp0           &
              +save_mp_bcoeff(2,ib)*l4qp0           &
              +save_mp_bcoeff(3,ib)*vqp0            &
              +save_mp_bcoeff(4,ib)*(l3qp0)**2      &
              +save_mp_bcoeff(5,ib)*(l4qp0)**2      &
              +save_mp_bcoeff(6,ib)*vqp0**2         &
              +save_mp_bcoeff(7,ib)*vqp0*l3qp0      &
              +save_mp_bcoeff(8,ib)*vqp0*l4qp0)     &
              *allden
     else
      start= start+(                        &
               mp_bcoeff(0,ib)                 &
              +mp_bcoeff(1,ib)*l3qp0           &
              +mp_bcoeff(2,ib)*l4qp0           &
              +mp_bcoeff(3,ib)*vqp0            &
              +mp_bcoeff(4,ib)*(l3qp0)**2      &
              +mp_bcoeff(5,ib)*(l4qp0)**2      &
              +mp_bcoeff(6,ib)*vqp0**2         &
              +mp_bcoeff(7,ib)*vqp0*l3qp0      &
              +mp_bcoeff(8,ib)*vqp0*l4qp0)     &
              *allden
     endif 
    enddo  
   endif
   mp_numb= start
  end function mp_numb
!
  function mp_numa(number_propagators,q,j)
   include 'cts_mpr.h' 
    :: p
   integer, intent(in) :: number_propagators
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: jj,i,ib,k,np
   include 'cts_mpc.h'
    , dimension(0:3) :: qp0
   include 'cts_mpc.h' 
    :: l3qp0,l4qp0,vqp0,kqp0
   include 'cts_mpc.h' 
    :: mp_numa,start
   include 'cts_mpc.h' 
    :: allden
   jj= abs(j)
   start= c0(p)
   np= number_propagators
   if     (np.lt.1) then
    print*,'In function numa '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   else 
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     allden= c1(p)
     if     (j.eq.0) then
      do k= 2,np
       allden= allden*value(mp_den(bn1(np,k,i)),q)
      enddo
     elseif (j.lt.0) then
      do k= 2,np
       allden= allden*(mp_vden(mp_den(bn1(np,k,i))%i,jj)-mpqt2)
      enddo
     else
      do k= 2,np
       allden= allden*mp_vden(mp_den(bn1(np,k,i))%i,j)
       if (allden.eq.c0(p)) cycle
      enddo
     endif  
     if (allden.eq.c0(p)) cycle
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,l4qp0)
     call contr(mp_vveca(:,ib),qp0,vqp0)
     call contr(mp_kvec(:,ib),qp0,kqp0)
     if (j.lt.0) then 
      start= start+(                    &
               save_mp_acoeff(0,ib)        & 
              +save_mp_acoeff(1,ib)*kqp0   &
              +save_mp_acoeff(2,ib)*vqp0   &
              +save_mp_acoeff(3,ib)*l3qp0  &
              +save_mp_acoeff(4,ib)*l4qp0) &
              *allden
     else
      start= start+(               &
               mp_acoeff(0,ib)        & 
              +mp_acoeff(1,ib)*kqp0   &
              +mp_acoeff(2,ib)*vqp0   &
              +mp_acoeff(3,ib)*l3qp0  &
              +mp_acoeff(4,ib)*l4qp0) &
              *allden
     endif
    enddo  
   endif
   mp_numa= start 
!
  end function mp_numa
!
  subroutine mp_numfuncrec(number_propagators,q,j,mpres) 
   integer, intent(in) :: number_propagators,j
   include 'cts_mpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_mpc.h'
    , intent(out) :: mpres
   include 'cts_mpc.h' 
    :: num_d, num_c, num_b, num_a
   num_d= numd(number_propagators,q,-j)
   num_c= numc(number_propagators,q,-j)
   num_b= numb(number_propagators,q,-j)
   num_a= numa(number_propagators,q,-j)
   mpres= num_d+num_c+num_b+num_a
  end subroutine mp_numfuncrec
!
  subroutine dp_test(p,numdummy,number_propagators,q,numerator,numrec,prec)
   use inout
   external numdummy
   include 'cts_dpr.h'
    , intent(in) :: p
   integer, intent(in) :: number_propagators
!
!  Routine to perform the test N(q) = N(q)
!
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_dpc.h' 
    :: numerator, num_d, num_c, num_b, num_a, numrec
   include 'cts_dpr.h' 
    :: prec,precr,preci,abnum
   intent(out) :: numerator,numrec,prec
   mprec=.false.
   dpq= q
   call numfunc(numdummy)
   numerator= dpres
   num_d= numd(number_propagators,dpq,0)
   num_c= numc(number_propagators,dpq,0)
   num_b= numb(number_propagators,dpq,0)
   num_a= numa(number_propagators,dpq,0)
   numrec= (num_d+num_c+num_b+num_a)
   abnum= max(tiny(p),abs(numerator)) 
   precr = dabs(dreal(numerator)-dreal(numrec))/abnum
   preci = dabs(dimag(numerator)-dimag(numrec))/abnum
   prec= max(precr,preci)
  end subroutine dp_test
!
  subroutine mp_test(p,numdummy,number_propagators,q,numerator,numrec,prec)
   use inout
   external numdummy
   include 'cts_mpr.h'
    , intent(in) :: p 
   integer, intent(in) :: number_propagators
!
!  Routine to perform the test N(q) = N(q)
!
   include 'cts_dpc.h'
    , intent(in), dimension(0:3) :: q
   include 'cts_mpc.h' 
    :: numerator, num_d, num_c, num_b, num_a, numrec
   include 'cts_mpc.h' 
    :: diff,partreal,imagpart,partreal1,imagpart1
   include 'cts_mpr.h' 
    :: abnum
   include 'cts_dpr.h' 
    :: prec,precr,preci
   integer :: k
   intent(out) :: numerator,numrec,prec
   mprec=.true.
   do k= 0,3; mpq(k)= q(k); enddo
   call numfunc(numdummy)
   numerator= mpres
   num_d= numd(number_propagators,mpq,0)
   num_c= numc(number_propagators,mpq,0)
   num_b= numb(number_propagators,mpq,0)
   num_a= numa(number_propagators,mpq,0)
   numrec= (num_d+num_c+num_b+num_a)
   diff= numerator
   partreal= (diff+conjg(diff))/2.d0  
   imagpart= (diff-conjg(diff))/(2.d0*ci(p))  
   diff= numrec
   partreal1= (diff+conjg(diff))/2.d0  
   imagpart1= (diff-conjg(diff))/(2.d0*ci(p))  
   abnum= max(abs(numerator),mp_tiny(p)) 
   precr = abs(partreal-partreal1)/abnum
   preci = abs(imagpart-imagpart1)/abnum
   prec= max(precr,preci)
  end subroutine mp_test
 end module coefficients
 






 
