! comment1
!
! build up the necessary combinatorics
!
 module maxnumden
   implicit none
!                                     ! 
!                                     !
!  the maximum number of denominators !
!  (it can be changed by the user)    ! 
!                                     !
!                                     ! 
   integer, public, parameter :: maxden= 6 
 end module maxnumden
!
 module combinations
! comment1
  use maxnumden
  implicit none
!  integer, public, parameter :: maxden= 6
  integer, dimension(1:maxden), public, parameter :: &
           string= (/1,2,4,8,16,32/)
  integer, public, parameter :: dimension_den= 32
  integer, public, parameter :: dimension_d  = 60
  integer, public, parameter :: dimension_c  = 56
  integer, public, parameter :: dimension_b  = 48
  integer, public, parameter :: dimension_a  = 32
  integer, public, parameter :: max_solutions= 18
! 1 denominator  among 1
  integer, public, parameter :: nbin11= 1
  integer, dimension(nbin11*1), public, & 
           parameter :: bin11= 1
  integer, public, parameter :: mbin11= 1
! 1 denominator among 2
  integer, public, parameter :: nbin12= 2
  integer, dimension(1:2,nbin12), public, &
           parameter :: bin12= reshape(&
           (/1 ,2, &  
             2 ,1 /)& 
           ,(/2,nbin12/))
  integer, dimension(nbin12), public, &
           parameter :: mbin12= (/1,2/)
! 1 denominator among 3
  integer, public, parameter :: nbin13= 3
  integer, dimension(1:3,nbin13), public, &
           parameter :: bin13= reshape(&
           (/1 ,2 ,4 , &   
             2 ,1 ,4 , & 
             4 ,1 ,2   /)&
           ,(/3,nbin13/))
  integer, dimension(nbin13), public, &
           parameter :: mbin13= (/1, 2, 4/)
! 1 denominator among 4
  integer, public, parameter :: nbin14= 4
  integer, dimension(1:4,nbin14), public, &
           parameter :: bin14= reshape(&
           (/1 ,2 ,4 ,8 , &
             2 ,1 ,4 ,8 , &
             4 ,1 ,2 ,8 , &
             8 ,1 ,2 ,4  /)&
           ,(/4,nbin14/))
  integer, dimension(nbin14), public, &
           parameter :: mbin14= (/1, 2, 4, 8/)
! 1 denominator among 5
  integer, public, parameter :: nbin15= 5
  integer, dimension(1:5,nbin15), public, &
           parameter :: bin15= reshape(&
           (/1 ,2 ,4 ,8 ,16, & 
             2 ,1 ,4 ,8 ,16, & 
             4 ,1 ,2 ,8 ,16, & 
             8 ,1 ,2 ,4 ,16, & 
             16,1 ,2 ,4 ,8   /)&
           ,(/5,nbin15/))
  integer, dimension(nbin15), public, &
           parameter :: mbin15= (/1, 2, 4, 8, 16/)
! 1 denominator among 6
  integer, public, parameter :: nbin16= 6
  integer, dimension(1:6,nbin16), public, &
           parameter :: bin16= reshape(&
           (/1 ,2 ,4 ,8 ,16,32, & 
             2 ,1 ,4 ,8 ,16,32, & 
             4 ,1 ,2 ,8 ,16,32, & 
             8 ,1 ,2 ,4 ,16,32, & 
             16,1 ,2 ,4 ,8 ,32, & 
             32,1 ,2 ,4 ,8 ,16  /)&
           ,(/6,nbin16/))
  integer, dimension(nbin16), public, &
           parameter :: mbin16= (/1, 2, 4, 8, 16, 32/)
! 2 denominators among 2
  integer, public, parameter :: nbin22= 1
  integer, dimension(nbin22*2), public, &
           parameter :: bin22= (/1 ,2 /)
  integer, public, parameter :: mbin22= 3
! 2 denominators among 3
  integer, public, parameter :: nbin23= 3
  integer, dimension(1:3,nbin23), public, &
           parameter :: bin23= reshape(&
           (/1 ,2 ,4 , &
             1 ,4 ,2 , &
             2 ,4 ,1  /)&
           ,(/3,nbin23/))
  integer, dimension(nbin23), public, &
           parameter :: mbin23= (/3, 5, 6/)
! 2 denominators among 4
  integer, public, parameter :: nbin24= 6
  integer, dimension(1:4,nbin24), public, &
           parameter :: bin24= reshape(&
           (/1 ,2 ,4 ,8 , & 
             1 ,4 ,2 ,8 , & 
             1 ,8 ,2 ,4 , & 
             2 ,4 ,1 ,8 , & 
             2 ,8 ,1 ,4 , & 
             4 ,8 ,1 ,2   /)&
           ,(/4,nbin24/))
  integer, dimension(nbin24), public, &
           parameter :: mbin24= (/3, 5, 9, 6, 10, 12/)
! 2 denominators among 5
  integer, public, parameter :: nbin25= 10
  integer, dimension(1:5,nbin25), public, &
           parameter :: bin25= reshape(&
           (/1 ,2 ,4 ,8 ,16, &
             1 ,4 ,2 ,8 ,16, &
             1 ,8 ,2 ,4 ,16, &
             1 ,16,2 ,4 ,8 , &
             2 ,4 ,1 ,8 ,16, &
             2 ,8 ,1 ,4 ,16, &
             2 ,16,1 ,4 ,8 , &
             4 ,8 ,1 ,2 ,16, &
             4 ,16,1 ,2 ,8 , &
             8 ,16,1 ,2 ,4  /)&
           ,(/5,nbin25/))
  integer, dimension(nbin25), public, &
           parameter :: mbin25= (/3, 5, 9, 17, 6 ,10, 18, 12, 20, 24/)
! 2 denominators among 6
  integer, public, parameter :: nbin26= 15
  integer, dimension(1:6,nbin26), public, &
           parameter :: bin26= reshape(&
           (/1 ,2 ,4 ,8 ,16,32, & 
             1 ,4 ,2 ,8 ,16,32, & 
             1 ,8 ,2 ,4 ,16,32, & 
             1 ,16,2 ,4 ,8 ,32, & 
             1 ,32,2 ,4 ,8 ,16, & 
             2 ,4 ,1 ,8 ,16,32, & 
             2 ,8 ,1 ,4 ,16,32, & 
             2 ,16,1 ,4 ,8 ,32, & 
             2 ,32,1 ,4 ,8 ,16, & 
             4 ,8 ,1 ,2 ,16,32, & 
             4 ,16,1 ,2 ,8 ,32, & 
             4 ,32,1 ,2 ,8 ,16, & 
             8 ,16,1 ,2 ,4 ,32, & 
             8 ,32,1 ,2 ,4 ,16, & 
             16,32,1 ,2 ,4 ,8   /)&
           ,(/6,nbin26/))
  integer, dimension(nbin26), public, &
           parameter :: mbin26= (/3, 5, 9, 17, 33 ,6, 10, 18, 34, 12, &
                                 20,36,24, 40, 48/)
! 3 denominators among 3
  integer, public, parameter :: nbin33= 1
  integer, dimension(nbin33*3), public, &
           parameter :: bin33= (/1 ,2 ,4/)
  integer, public, parameter :: mbin33= 7
! 3 denominators among 4
  integer, public, parameter :: nbin34= 4
  integer, dimension(1:4,nbin34), public, &
           parameter :: bin34= reshape(&
           (/1 ,2 ,4 ,8 , &  
             1 ,2 ,8 ,4 , & 
             1 ,4 ,8 ,2 , & 
             2 ,4 ,8 ,1   /)&
           ,(/4,nbin34/))
  integer, dimension(nbin34), public, &
           parameter :: mbin34= (/7, 11, 13, 14/)
! 3 denominators among 5
  integer, public, parameter :: nbin35= 10
  integer, dimension(1:5,nbin35), public, &
           parameter :: bin35= reshape(&
           (/                & 
             1 ,2 ,4 ,8 ,16, & 
             1 ,2 ,8 ,4 ,16, & 
             1 ,4 ,8 ,2 ,16, & 
             2 ,4 ,8 ,1 ,16, & 
             1 ,2 ,16,4 ,8 , & 
             1 ,4 ,16,2 ,8 , & 
             2 ,4 ,16,1 ,8 , & 
             1 ,8 ,16,2 ,4 , & 
             2 ,8 ,16,1 ,4 , & 
             4 ,8 ,16,1 ,2   /)&
           ,(/5,nbin35/))
  integer, dimension(nbin35), public, &
           parameter :: mbin35= (/7, 11, 13, 14, 19, 21, 22, 25, 26, 28/)
! 3 denominators among 6
  integer, public, parameter :: nbin36= 20
  integer, dimension(1:6,nbin36), public, &
           parameter :: bin36= reshape(&
           (/                   &
             1 ,2 ,4 ,8 ,16,32, &
             1 ,2 ,8 ,4 ,16,32, &
             1 ,2 ,16,4 ,8 ,32, &
             1 ,2 ,32,4 ,8 ,16, &
             1 ,4 ,8 ,2 ,16,32, &
             1 ,4 ,16,2 ,8 ,32, &
             1 ,4 ,32,2 ,8 ,16, &
             1 ,8 ,16,2 ,4 ,32, &
             1 ,8 ,32,2 ,4 ,16, &
             1 ,16,32,2 ,4 ,8 , &
             2 ,4 ,8 ,1 ,16,32, &
             2 ,4 ,16,1 ,8 ,32, &
             2 ,4 ,32,1 ,8 ,16, &
             2 ,8 ,16,1 ,4 ,32, &
             2 ,8 ,32,1 ,4 ,16, &
             2 ,16,32,1 ,4 ,8 , &
             4 ,8 ,16,1 ,2 ,32, &
             4 ,8 ,32,1 ,2 ,16, &
             4 ,16,32,1 ,2 ,8 , &
             8 ,16,32,1 ,2 ,4  /)&
           ,(/6,nbin36/))
  integer, dimension(nbin36), public, &
           parameter :: mbin36= (/7, 11, 19, 35, 13, 21, 37, 25, 41, 49, &
                                 14, 22, 38, 26, 42, 50, 28, 44, 52, 56 /)
! 4 denominators among 4
  integer, public, parameter :: nbin44= 1
  integer, dimension(nbin44*4), public, &
           parameter :: bin44= (/1 ,2 ,4 ,8/)
  integer, public, parameter :: mbin44= 15
! 4 denominators among 5
  integer, public, parameter :: nbin45= 5
  integer, dimension(1:5,nbin45), public, &
           parameter :: bin45= reshape(&
           (/1 ,2 ,4 ,8 ,16, & 
             1 ,2 ,4 ,16,8 , & 
             1 ,2 ,8 ,16,4 , & 
             1 ,4 ,8 ,16,2 , & 
             2 ,4 ,8 ,16,1   /)&
           ,(/5,nbin45/))
  integer, dimension(nbin45), public, &
           parameter :: mbin45= (/15 ,23 ,27 ,29 ,30/)
! 4 denominators among 6
  integer, public, parameter :: nbin46= 15
  integer, dimension(1:6,nbin46), public, &
           parameter :: bin46= reshape(&
           (/1 ,2 ,4 , 8,16,32, & 
             1 ,2 ,4 ,16,8 ,32, & 
             1 ,2 ,8 ,16,4 ,32, & 
             1 ,4 ,8 ,16,2 ,32, & 
             2 ,4 ,8 ,16,1 ,32, & 
             1 ,2 ,4 ,32,8 ,16, & 
             1 ,2 ,8 ,32,4 ,16, & 
             1 ,4 ,8 ,32,2 ,16, & 
             2 ,4 ,8 ,32,1 ,16, & 
             1 ,2 ,16,32,4 ,8 , & 
             1 ,4 ,16,32,2 ,8 , & 
             2 ,4 ,16,32,1 ,8 , & 
             1 ,8 ,16,32,2 ,4 , & 
             2 ,8 ,16,32,1 ,4 , & 
             4 ,8 ,16,32,1 ,2   /)&
           ,(/6,nbin46/))
  integer, dimension(nbin46), public, &
           parameter :: mbin46= (/15, 23, 27, 29, 30, 39, &
                      43, 45, 46, 51, 53, 54, 57, 58, 60/)
 end module combinations
!
 module combinatorics
  use combinations
! 4-point sector
!   dim4= max(nbin44,nbin45,nbin46)
  integer, private, parameter :: dim4= nbin46 
  integer, public, dimension(4:maxden,maxden,dim4) :: bn4= -1
  integer, public, dimension(4:maxden) :: nbn4= -1
  integer, public, dimension(4:maxden,dim4) :: mbn4= -1
! 3-point sector
!   dim3= max(nbin33,nbin34,nbin35,nbin36)
  integer, private, parameter :: dim3= nbin36 
  integer, public, dimension(3:maxden,maxden,dim3) :: bn3= -1
  integer, public, dimension(3:maxden) :: nbn3= -1
  integer, public, dimension(3:maxden,dim3) :: mbn3= -1
! 2-point sector
!   dim2= max(nbin22,nbin23,nbin24,nbin25,nbin26)
  integer, private, parameter :: dim2= nbin26 
  integer, public, dimension(2:maxden,maxden,dim2) :: bn2= -1
  integer, public, dimension(2:maxden) :: nbn2= -1
  integer, public, dimension(2:maxden,dim2) :: mbn2= -1
! 1-point secto
!   dim1= max(nbin11,nbin12,nbin13,nbin14,nbin15,nbin16)
  integer, private, parameter :: dim1= nbin16 
  integer, public, dimension(1:maxden,maxden,dim1) :: bn1= -1
  integer, public, dimension(1:maxden) :: nbn1= -1
  integer, public, dimension(1:maxden,dim1) :: mbn1= -1
  contains
!
  subroutine load_combinatorics
  integer i,j
! 4-point sector
  nbn4(4)= nbin44; nbn4(5)= nbin45; nbn4(6)= nbin46
  do j= 1,nbn4(4)
   mbn4(4,j) = mbin44
   do i= 1,4
    bn4(4,i,j)= bin44(i)
   enddo
  enddo
  do j= 1,nbn4(5)
   mbn4(5,j) = mbin45(j)
   do i= 1,5  
    bn4(5,i,j)= bin45(i,j)
   enddo
  enddo
  do j= 1,nbn4(6)
   mbn4(6,j) = mbin46(j)
   do i= 1,6  
    bn4(6,i,j)= bin46(i,j)
   enddo
  enddo
! 3-point sector
  nbn3(3)= nbin33; nbn3(4)= nbin34
  nbn3(5)= nbin35; nbn3(6)= nbin36
  do j= 1,nbn3(3)
   mbn3(3,j) = mbin33
   do i= 1,3  
    bn3(3,i,j)= bin33(i)
   enddo
  enddo
  do j= 1,nbn3(4)
   mbn3(4,j) = mbin34(j)
   do i= 1,4 
    bn3(4,i,j)= bin34(i,j)
   enddo
  enddo
  do j= 1,nbn3(5)
   do i= 1,5  
    bn3(5,i,j)= bin35(i,j)
    mbn3(5,j) = mbin35(j)
   enddo
  enddo
  do j= 1,nbn3(6)
   mbn3(6,j) = mbin36(j)
   do i= 1,6 
    bn3(6,i,j)= bin36(i,j)
   enddo
  enddo
! 2-point sector
  nbn2(2)= nbin22; nbn2(3)= nbin23
  nbn2(4)= nbin24; nbn2(5)= nbin25
  nbn2(6)= nbin26
  do j= 1,nbn2(2)
   mbn2(2,j) = mbin22
   do i= 1,2 
    bn2(2,i,j)= bin22(i)
   enddo
  enddo
  do j= 1,nbn2(3)
   mbn2(3,j) = mbin23(j)
   do i= 1,3  
    bn2(3,i,j)= bin23(i,j)
   enddo
  enddo
  do j= 1,nbn2(4)
   mbn2(4,j) = mbin24(j)
   do i= 1,4 
    bn2(4,i,j)= bin24(i,j)
   enddo
  enddo
  do j= 1,nbn2(5)
   mbn2(5,j) = mbin25(j)
   do i= 1,5  
    bn2(5,i,j)= bin25(i,j)
   enddo
  enddo
  do j= 1,nbn2(6)
   mbn2(6,j) = mbin26(j)
   do i= 1,6  
    bn2(6,i,j)= bin26(i,j)
   enddo
  enddo
! 1-point sector
  nbn1(1)= nbin11; nbn1(2)= nbin12 
  nbn1(3)= nbin13; nbn1(4)= nbin14
  nbn1(5)= nbin15; nbn1(6)= nbin16
  do j= 1,nbn1(1)
   mbn1(1,j) = mbin11
   do i= 1,1  
    bn1(1,i,j)= bin11(i)
   enddo
  enddo
  do j= 1,nbn1(2)
   mbn1(2,j) = mbin12(j)
   do i= 1,2 
    bn1(2,i,j)= bin12(i,j)
   enddo
  enddo
  do j= 1,nbn1(3)
   mbn1(3,j) = mbin13(j)
   do i= 1,3 
    bn1(3,i,j)= bin13(i,j)
   enddo
  enddo
  do j= 1,nbn1(4)
   mbn1(4,j) = mbin14(j)
   do i= 1,4 
    bn1(4,i,j)= bin14(i,j)
   enddo
  enddo
  do j= 1,nbn1(5)
   mbn1(5,j) = mbin15(j)
   do i= 1,5 
    bn1(5,i,j)= bin15(i,j)
   enddo
  enddo
  do j= 1,nbn1(6)
   mbn1(6,j) = mbin16(j)
   do i= 1,6  
    bn1(6,i,j)= bin16(i,j)
   enddo
  enddo
  end subroutine load_combinatorics
 end module combinatorics
