 module tensor_operations                                                 
  use mpmodule
  implicit none
  interface contr 
!
!  Real Tensor by Real Tensor
!
   module procedure  contract11_1rr 
!
!  Complex Tensor by Complex Tensor
!
   module procedure  contract11_1cc 
!
!  Real Tensor by Complex Tensor
!
   module procedure  contract11_1rc 
!
!  Complex Tensor by Real Tensor
!
   module procedure  contract11_1cr 

!
!  mp_ Real Tensor by mp_Real Tensor
!
   module procedure  mp_contract11_1rr 
!
!  mp_Complex Tensor by mp_Complex Tensor
!
   module procedure  mp_contract11_1cc 
!
!  mp_Real Tensor by mp_Complex Tensor
!
   module procedure  mp_contract11_1rc 
!
!  mp_Complex Tensor by mp_Real Tensor
!
   module procedure  mp_contract11_1cr 
  end interface!contr
  contains                                                                 
!
!  Real by Real:
!
  subroutine contract11_1rr(a,b,a1,b1,aus1) 
   real(kind(1.d0)), intent(out) :: aus1
   real(kind(1.d0)), intent(in), dimension(0:3) :: a                          
   real(kind(1.d0)), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine contract11_1rr                                               
!
!  Complex by Complex:
!
  subroutine contract11_1cc(a,b,a1,b1,aus1) 
   complex(kind(1.d0)), intent(out)  :: aus1
   complex(kind(1.d0)), intent(in), dimension(0:3) :: a
   complex(kind(1.d0)), intent(in), dimension(0:3) :: b
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine contract11_1cc                                               
!
!  Real by Complex:
!
  subroutine contract11_1rc(a,b,a1,b1,aus1) 
   complex(kind(1.d0)), intent(out)  :: aus1
   real(kind(1.d0)), intent(in), dimension(0:3) :: a                          
   complex(kind(1.d0)), intent(in), dimension(0:3) :: b   
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine contract11_1rc                                               
!
!  Complex by Real:
!
  subroutine contract11_1cr(a,b,a1,b1,aus1) 
   complex(kind(1.d0)), intent(out)  :: aus1
   complex(kind(1.d0)), intent(in), dimension(0:3) :: a 
   real(kind(1.d0)), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine contract11_1cr                                               
!
!  mp_Real by mp_Real:
!
  subroutine mp_contract11_1rr(a,b,a1,b1,aus1) 
   type(mp_real), intent(out) :: aus1
   type(mp_real), intent(in), dimension(0:3) :: a                          
   type(mp_real), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine mp_contract11_1rr                                               
!
!  mp_Complex by mp_Complex:
!
  subroutine mp_contract11_1cc(a,b,a1,b1,aus1) 
   type(mp_complex), intent(out)  :: aus1
   type(mp_complex), intent(in), dimension(0:3) :: a                          
   type(mp_complex), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine mp_contract11_1cc                                               
!
!  mp_Real by mp_Complex:
!
  subroutine mp_contract11_1rc(a,b,a1,b1,aus1) 
   type(mp_complex), intent(out)  :: aus1
   type(mp_real), intent(in), dimension(0:3) :: a                          
   type(mp_complex), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine mp_contract11_1rc                                               
!
!  mp_Complex by mp_Real:
!
  subroutine mp_contract11_1cr(a,b,a1,b1,aus1) 
   type(mp_complex), intent(out)  :: aus1
   type(mp_complex), intent(in), dimension(0:3) :: a                          
   type(mp_real), intent(in), dimension(0:3) :: b                          
   integer, intent(in) :: a1,b1 
   aus1= a(0)*b(0)-a(1)*b(1)-a(2)*b(2)-a(3)*b(3)
  end subroutine mp_contract11_1cr                                               
 end module tensor_operations                                             



