      SUBROUTINE RAMBO(LFLAG,N,ET,XM,P,DJ)
c------------------------------------------------------
c
c                       RAMBO
c
c    RA(NDOM)  M(OMENTA)  B(EAUTIFULLY)  O(RGANIZED)
c
c    A DEMOCRATIC MULTI-PARTICLE PHASE SPACE GENERATOR
c    AUTHORS:  S.D. ELLIS,  R. KLEISS,  W.J. STIRLING
c    THIS IS VERSION 1.0 -  WRITTEN BY R. KLEISS
c    (MODIFIED BY R. PITTAU)
c
c                INPUT                 OUTPUT
c
c    LFLAG= 0:   N, ET, XM             P, DJ
c    LFLAG= 1:   N, ET, XM, P          DJ
c
c    N  = NUMBER OF PARTICLES (>1, IN THIS VERSION <101)
c    ET = TOTAL CENTRE-OF-MASS ENERGY
c    XM = PARTICLE MASSES ( DIM=100 )
c    P  = PARTICLE MOMENTA ( DIM=(4,100) )
c    DJ = 1/(WEIGHT OF THE EVENT)
c
c------------------------------------------------------
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XM(100),P(4,100),Q(4,100),Z(100),R(4),
     .   B(3),P2(100),XM2(100),E(100),V(100),IWARN(5)
      SAVE ACC,ITMAX,IBEGIN,IWARN,Z,TWOPI,PO2LOG
      DATA ACC/1.D-14/,ITMAX/10/,IBEGIN/0/,IWARN/5*0/
C
C INITIALIZATION STEP: FACTORIALS FOR THE PHASE SPACE WEIGHT
      IF(IBEGIN.NE.0) GOTO 103
      IBEGIN=1
      TWOPI=8.*DATAN(1.D0)
      PO2LOG=LOG(TWOPI/4.)
      Z(2)=PO2LOG
      DO 101 K=3,100
  101 Z(K)=Z(K-1)+PO2LOG-2.*LOG(DFLOAT(K-2))
      DO 102 K=3,100
  102 Z(K)=(Z(K)-LOG(DFLOAT(K-1)))
C
C CHECK ON THE NUMBER OF PARTICLES
  103 IF(N.GT.1.AND.N.LT.101) GOTO 104
      PRINT 1001,N
      STOP
C
C CHECK WHETHER TOTAL ENERGY IS SUFFICIENT; COUNT NONZERO MASSES
  104 XMT=0.
      NM=0
      DO 105 I=1,N
      IF(XM(I).NE.0.D0) NM=NM+1
  105 XMT=XMT+ABS(XM(I))
      IF(XMT.LE.ET) GOTO 201
      PRINT 1002,XMT,ET
      STOP

  201 CONTINUE 
      if (lflag.eq.1) then
        w0= exp((2.*N-4.)*LOG(ET)+Z(N))
        do j= 1,N
          v(j)= sqrt(p(1,j)**2+p(2,j)**2+p(3,j)**2)
        enddo

        a1= 0.d0
        a3= 0.d0
        a2= 1.d0
        do j= 1,N
          a1= a1+v(j)/ET
          a2= a2*v(j)/p(4,j)
          a3= a3+v(j)*v(j)/p(4,j)/ET
        enddo
        wm= a1**(2*N-3)*a2/a3
        dj= 1.d0/w0/wm
        return
      endif
C
C THE PARAMETER VALUES ARE NOW ACCEPTED
C
C GENERATE N MASSLESS MOMENTA IN INFINITE PHASE SPACE

      DO 202 I=1,N
c pippo
      call rans(RAN1)
      call rans(RAN2)
      call rans(RAN3)
      call rans(RAN4)
c      RAN1= rangen(1) 
c      RAN2= rangen(1) 
c      RAN3= rangen(1) 
c      RAN4= rangen(1) 
c pippo
      C=2.*RAN1-1.
      S=SQRT(1.-C*C)
      F=TWOPI*RAN2
      Q(4,I)=-LOG(RAN3*RAN4)
      Q(3,I)=Q(4,I)*C
      Q(2,I)=Q(4,I)*S*COS(F)
  202 Q(1,I)=Q(4,I)*S*SIN(F)
C
C CALCULATE THE PARAMETERS OF THE CONFORMAL TRANSFORMATION
      DO 203 I=1,4
  203 R(I)=0.
      DO 204 I=1,N
      DO 204 K=1,4
  204 R(K)=R(K)+Q(K,I)
      RMAS=SQRT(R(4)**2-R(3)**2-R(2)**2-R(1)**2)
      DO 205 K=1,3
  205 B(K)=-R(K)/RMAS
      G=R(4)/RMAS
      A=1./(1.+G)
      X=ET/RMAS
C
C TRANSFORM THE Q'S CONFORMALLY INTO THE P'S
      DO 207 I=1,N
      BQ=B(1)*Q(1,I)+B(2)*Q(2,I)+B(3)*Q(3,I)
      DO 206 K=1,3
  206 P(K,I)=X*(Q(K,I)+B(K)*(Q(4,I)+A*BQ))
  207 P(4,I)=X*(G*Q(4,I)+BQ)
C
C CALCULATE WEIGHT AND POSSIBLE WARNINGS
      WT=PO2LOG
      IF(N.NE.2) WT=(2.*N-4.)*LOG(ET)+Z(N)
      IF(WT.GE.-180.D0) GOTO 208
      IF(IWARN(1).LE.5) PRINT 1004,WT
      IWARN(1)=IWARN(1)+1
  208 IF(WT.LE. 174.D0) GOTO 209
      IF(IWARN(2).LE.5) PRINT 1005,WT
      IWARN(2)=IWARN(2)+1
C
C RETURN FOR WEIGHTED MASSLESS MOMENTA
  209 IF(NM.NE.0) GOTO 210
      WT=EXP(WT)
      DJ= 1.d0/WT
      RETURN
C
C MASSIVE PARTICLES: RESCALE THE MOMENTA BY A FACTOR X
  210 XMAX=SQRT(1.-(XMT/ET)**2)
      DO 301 I=1,N
      XM2(I)=XM(I)**2
  301 P2(I)=P(4,I)**2
      ITER=0
      X=XMAX
      ACCU=ET*ACC
  302 F0=-ET
      G0=0.
      X2=X*X
      DO 303 I=1,N
      E(I)=SQRT(XM2(I)+X2*P2(I))
      F0=F0+E(I)
  303 G0=G0+P2(I)/E(I)
      IF(ABS(F0).LE.ACCU) GOTO 305
      ITER=ITER+1
      IF(ITER.LE.ITMAX) GOTO 304
      PRINT 1006,ITMAX
      GOTO 305
  304 X=X-F0/(X*G0)
      GOTO 302
  305 DO 307 I=1,N
      V(I)=X*P(4,I)
      DO 306 K=1,3
  306 P(K,I)=X*P(K,I)
  307 P(4,I)=E(I)
C
C CALCULATE THE MASS-EFFECT WEIGHT FACTOR
      WT2=1.
      WT3=0.
      DO 308 I=1,N
      WT2=WT2*V(I)/E(I)
  308 WT3=WT3+V(I)**2/E(I)
      WTM=(2.*N-3.)*LOG(X)+LOG(WT2/WT3*ET)
C
C RETURN FOR  WEIGHTED MASSIVE MOMENTA
      WT=WT+WTM
      IF(WT.GE.-180.D0) GOTO 309
      IF(IWARN(3).LE.5) PRINT 1004,WT
      IWARN(3)=IWARN(3)+1
  309 IF(WT.LE. 174.D0) GOTO 310
      IF(IWARN(4).LE.5) PRINT 1005,WT
      IWARN(4)=IWARN(4)+1
  310 WT=EXP(WT)
      DJ= 1.d0/WT
      RETURN
C
 1001 FORMAT(' RAMBO FAILS: # OF PARTICLES =',I5,' IS NOT ALLOWED')
 1002 FORMAT(' RAMBO FAILS: TOTAL MASS =',D15.6,' IS NOT',
     . ' SMALLER THAN TOTAL ENERGY =',D15.6)
 1004 FORMAT(' RAMBO WARNS: WEIGHT = EXP(',F20.9,') MAY UNDERFLOW')
 1005 FORMAT(' RAMBO WARNS: WEIGHT = EXP(',F20.9,') MAY  OVERFLOW')
 1006 FORMAT(' RAMBO WARNS:',I3,' ITERATIONS DID NOT GIVE THE',
     . ' DESIRED ACCURACY =',D15.6)
      END

      subroutine rans(ran)
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c                                                                c
c     Random number generator                                    c
c                                                                c
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      implicit none
      real*8 ran,rangen
      ran= rangen(1)
      end

*-- Author :    F. James, modified by Mike Seymour
C-----------------------------------------------------------------------
      FUNCTION RANGEN(I)
C-----------------------------------------------------------------------
C     MAIN RANDOM NUMBER GENERATOR
C     USES METHOD OF l'Ecuyer, (VIA F.JAMES, COMP PHYS COMM 60(1990)329)
C-----------------------------------------------------------------------
      IMPLICIT NONE
      DOUBLE PRECISION RANGEN,RANSET,RANGET
      INTEGER I,ISEED(2),K,IZ,JSEED(2)
      SAVE ISEED
      DATA ISEED/12345,67890/
      K=ISEED(1)/53668
      ISEED(1)=40014*(ISEED(1)-K*53668)-K*12211
      IF (ISEED(1).LT.0) ISEED(1)=ISEED(1)+2147483563
      K=ISEED(2)/52774
      ISEED(2)=40692*(ISEED(2)-K*52774)-K*3791
      IF (ISEED(2).LT.0) ISEED(2)=ISEED(2)+2147483399
      IZ=ISEED(1)-ISEED(2)
      IF (IZ.LT.1) IZ=IZ+2147483562
      RANGEN=DBLE(IZ)*4.656613001013252D-10
C--->                (4.656613001013252D-10 = 1.D0/2147483589)
      RETURN
C-----------------------------------------------------------------------
      ENTRY RANSET(JSEED)
C-----------------------------------------------------------------------
      IF (JSEED(1).EQ.0.OR.JSEED(2).EQ.0) then
         write(6,*) 'Jseeds=0, wrong settings for RANSET'
         stop
      endif
      ISEED(1)=JSEED(1)
      ISEED(2)=JSEED(2)
 999  RETURN
C-----------------------------------------------------------------------
      ENTRY RANGET(JSEED)
C-----------------------------------------------------------------------
      JSEED(1)=ISEED(1)
      JSEED(2)=ISEED(2)
      RETURN
      END

*----------------------------------------------------------------
      subroutine histo1(ih,ib,x0,x1,x,w)
*     ----------------------------------
* histogramming routine: input
      implicit real*8(a-h,o-z)
      save
      parameter(jh=70,jb=46)
      common / hisco1 /h(jh,jb),nb(jh),xl(jh),xu(jh),xm(jh),
     .                 ii(jh),iu(jh),io(jh)
      nb(ih)=ib
      xl(ih)=x0
      xu(ih)=x1
      if(x.lt.x0) then
        iu(ih)=iu(ih)+1
      elseif(x.gt.x1) then
        io(ih)=io(ih)+1
      else
        ii(ih)=ii(ih)+1
        k=int((x-x0)/(x1-x0)*ib)+1
        if(k.eq.ib+1) k=ib
        h(ih,k)=h(ih,k)+w
        if(h(ih,k).gt.xm(ih)) xm(ih)=h(ih,k)
      endif
      end
 
*----------------------------------------------------------------
      subroutine histo2(ih,m)
*     -----------------------
* histogramming routine: output
      implicit real*8(a-h,o-z)
      save
      parameter(jh=70,jb=46,jr=30)
      character*3 scm(2)
      character*1 regel(jr),star,blank
      character*10 piece
      common/printout/nout
      common / hisco1 /h(jh,jb),nb(jh),xl(jh),xu(jh),xm(jh),
     .                 ii(jh),iu(jh),io(jh)
      data scm/'lin','log'/,regel/30*' '/,star/'*'/,blank/' '/
      data piece/'----+----i'/
      if(ii(ih).ne.0) then
        write (nout,9001) ih,scm(m+1),iu(ih),ii(ih),io(ih)
        write (nout,9002) (piece,k=1,3)
        xmx=xm(ih)*1.00001
        bsz=(xu(ih)-xl(ih))/float(nb(ih))
        do 1 k=1,nb(ih)
          bup=xl(ih)+bsz*k
          if(m.eq.0) then
            j=int(h(ih,k)/xmx*jr)+1
          else
            if(h(ih,k).le.0.) then
              j=0
            else
              j=int(dlog(h(ih,k))/dlog(xmx)*jr)+1
            endif
          endif
          if(j.gt.0) then
            do 33 kj=1,j
              regel(kj)=star
   33       continue
          endif
          write (nout,9003) bup,h(ih,k),(regel(jj),jj=1,jr)
          if(j.gt.0) then
            do 34 kj=1,j
              regel(kj)=blank
   34       continue
          endif
    1   continue
        write (nout,9002) (piece,k=1,3)
      else
        write (nout,9004) ih,iu(ih),io(ih)
      endif
      write (nout,*) ' '
 9001 format(' ',i3,', ',a3,
     .  ' scale;  entries under,inside,over :',3i8)
 9002 format(30x,'i',3a10)
 9003 format(' ',2e12.4,5x,'i',30a1,'i')
 9004 format(' '/,' histogram no.',i2,' is empty: ',
     . ' underflow ',i10,',     overflow',i10)
      end
 
*----------------------------------------------------------------
      subroutine histo3(ih)
*     ---------------------
* histogramming routine: initialization
      implicit real*8(a-h,o-z)
      save
      parameter(jh=70,jb=46)
      common / hisco1 /h(jh,jb),nb(jh),xl(jh),xu(jh),xm(jh),
     .                 ii(jh),iu(jh),io(jh)
      if(ih.eq.0) then
        ih1=1
        ih2=jh
      else
        ih1=ih
        ih2=ih
      endif
      do 2 j=ih1,ih2
        do 1 k=1,jb
          h(j,k)=0.
          xm(j)=0.
          ii(j)=0
          iu(j)=0
          io(j)=0
    1   continue
    2 continue
      end
 
*----------------------------------------------------------------
      subroutine inbook(n,weight,init)
*     -------------------------
* bookkeeping of weights for up to nx variables
      implicit real*8(a-h,o-z)
      parameter(nbuf=1000,nx=20)
      dimension init(nx)
      common / bokcom / wbuf(nbuf,nx),
     .  s0(nx),s1(nx),s2(nx),s3(nx),s4(nx),
     .  wmax(nx),wmxbuf(nx),kount(nx),nwnul(nx),nwneg(nx)
      if(init(n).eq.0) then
        init(n)=1
        call histo3(49+n)
        s0(n)=0d0
        s1(n)=0d0
        s2(n)=0d0
        s3(n)=0d0
        s4(n)=0d0
        wmax(n)=weight
        kount(n)=0
        nwnul(n)=0
        nwneg(n)=0
        wmxbuf(n)=0d0
      endif
      kount(n)=kount(n)+1
      if(kount(n).lt.nbuf) then
        wbuf(kount(n),n)=weight
        if(weight.gt.wmxbuf(n)) wmxbuf(n)=weight
      elseif(kount(n).eq.nbuf) then
        wbuf(kount(n),n)=weight
        if(weight.gt.wmxbuf(n)) wmxbuf(n)=weight
        do 1 k=1,nbuf
          if(wbuf(k,n).ne.0d0) then
            call histo1(49+n,10,0d0,wmxbuf(n),wbuf(k,n),1d0)
          endif
    1   continue
      else
        if(weight.ne.0d0) then
          call histo1(49+n,10,0d0,wmxbuf(n),weight,1d0)
        endif
      endif
      s0(n)=s0(n)+1d0
      s1(n)=s1(n)+weight
      s2(n)=s2(n)+weight**2
      s3(n)=s3(n)+weight**3
      s4(n)=s4(n)+weight**4
      if(weight.gt.wmax(n)) wmax(n)=weight
      if(weight.eq.0d0)  nwnul(n)=nwnul(n)+1
      if(weight.lt.0d0)  then
        nwneg(n)=nwneg(n)+1
      endif
      end
 
*----------------------------------------------------------------
      subroutine outbok(resest,errest)
*     --------------------------------
      implicit real*8(a-h,o-z)
      parameter(nbuf=1000,nx=20)
      dimension resest(nx),errest(nx)
      common/printout/nout
      common / bokcom / wbuf(nbuf,nx),
     .  s0(nx),s1(nx),s2(nx),s3(nx),s4(nx),
     .  wmax(nx),wmxbuf(nx),kount(nx),nwnul(nx),nwneg(nx)
      write (nout,*)
      write (nout,*) '  ********** weights analysis **********'
      do 9999 n=1,nx
        if(kount(n).eq.0) goto 9999
        write (nout,*)
        write (nout,*) '  *** variable number ',n,' ************'
        if(wmax(n).le.0d0) then
          write (nout,1) wmax(n)
    1     format('  analysis maybe wrong: max. weight was ',d15.6)
        endif
        write (nout,2) s0(n),s1(n),s2(n),s3(n),s4(n),
     .             wmax(n),wmxbuf(n),nwnul(n),nwneg(n)
    2   format(
     .   '  sum(w**0)   ',d15.6,',  sum(w**1)     ',d15.6/,
     .   '  sum(w**2)   ',d15.6,',  sum(w**3)     ',d15.6/,
     .   '  sum(w**4)   ',d15.6/,
     .   '  maximum     ',d15.6,',  max.in buffer ',d15.6/,
     .   '  no.weights=0',i15,  ',  no.weights<0  ',i15)
        rn1=s0(n)
        rn2=rn1*(s0(n)-1d0)
        rn3=rn2*(s0(n)-2d0)
        rn4=rn3*(s0(n)-3d0)
        v1=s1(n)
        v2=s2(n)
        v3=s1(n)**2-v2
        v4=s3(n)
        v5=s2(n)*s1(n)-v4
        v6=s1(n)**3-v4-3*v5
        v7=s4(n)
        v8=s3(n)*s1(n)-v7
        v9=s2(n)**2-v7
        v10=s2(n)*s1(n)**2-v7-2*v8-v9
        v11=s1(n)**4-v7-4*v8-3*v9-6*v10
        xest=v1/rn1
        write (nout,3) xest
    3   format('  estimator x: ',d15.6)
        if(rn2.gt.0d0) then
          yest=(v2/rn1-v3/rn2)/rn1
          write (nout,4) yest
    4     format('  estimator y: ',d15.6)
          if(yest.lt.0d0) then
            write (nout,5) yest
    5       format('  warning: variance estimator =',d15.6/,
     .             '  sign flipped in order to survive')
            yest=dabs(yest)
          endif
        else
          write (nout,6) rn1
    6     format('  variance estimate not possible, n=',f4.1/,
     .           '  estimator put to zero in order to survive')
 
          yest=0d0
        endif
        if(rn4.gt.0d0) then
          zest=(    (rn2+    rn3)*v7/ rn1
     .         -4d0*(rn2+    rn3)*v8/ rn2
     .             +(rn2-    rn3)*v9/ rn2
     .         +4d0*(rn2+2d0*rn3)*v10/rn3
     .         -2d0*(rn2+2d0*rn3)*v11/rn4
     .         )/(rn1**2*rn2**2)
          write (nout,7) zest
    7     format('  estimator z: ',d15.6)
          if(zest.lt.0d0) then
            write (nout,8) zest
    8       format('  warning: variance-variance estimator =',d15.6/,
     .             '  sign flipped in order to survive')
            zest=dabs(zest)
          endif
        else
          write (nout,9) rn1
    9     format('  variance-variance estimate not possible, n=',f4.1/,
     .           '  estimator put to zero in order to survive')
          zest=0d0
        endif
        write (nout,10) xest,dsqrt(yest),yest,dsqrt(zest)
   10   format(
     .    '  average estimate :',d15.6/,16x,'+\- ',d15.6/,
     .    '  variance estimate:',d15.6/,16x,'+\- ',d15.6)
        if(dsqrt(zest).ge.0.5d0*yest.and.yest.gt.0d0) write (nout,11)
   11   format('  be aware that the error estimate may be bad*')
        if(idint(s0(n)).ne.nwnul(n).and.kount(n).lt.nbuf) then
           do 12 k=1,kount(n)
             if(wbuf(k,n).ne.0d0)
     .         call histo1(49+n,10,0d0,wmxbuf(n),wbuf(k,n),1d0)
   12     continue
        endif
        if(wmax(n).le.0d0) then
          write (nout,21) wmax(n)
   21     format('  efficiency estimate not possible, wmax=',d15.6)
          effica=0d0
        else
          effica=xest/wmax(n)
        endif
        if(idint(s0(n)).eq.nwnul(n)) then
          write (nout,22)
   22     format('  efficency estimate warning: all weigths are 0')
          efficn=0d0
        else
          efficn=effica*s0(n)/(s0(n)-1d0*nwnul(n))
        endif
        if(wmxbuf(n).le.0d0) then
          write (nout,23) wmxbuf(n)
   23     format('  overshoot estimate not possible -'/,
     .           '  maximum weight in buffer was',d15.6)
          oversh=0d0
        else
          oversh=wmax(n)/wmxbuf(n)
        endif
        write (nout,13) effica*100d0,efficn*100d0,oversh

   13   format('  efficiency for all weights     : ',f10.3,' %'/,
     .         '  efficiency for nonzero weights : ',f10.3,' %'/,
     .         '  overshoot factor of histogram  : ',f10.3)
        resest(n)=xest
        errest(n)=dsqrt(yest)
        if(idint(s0(n)).ne.nwnul(n)) then
          write (nout,*) '  the distribution of the nonzero weights:'
          call histo2(49+n,1)
        endif
 9999 continue
      end

      subroutine bookin(n,w,init)
      implicit real*8(a-h,o-z)
      parameter(nx=150)
      common/values/v1(nx),v2(nx),v3(nx),ni(nx)
      dimension init(nx)
      if (init(n).eq.0) then
        ni(n)=0
        v1(n)= 0
        v2(n)= 0
        v3(n)= 0
        init(n)= init(n)+1
      endif
      ni(n)= ni(n)+1
      v1(n)= v1(n)+w
      v2(n)= v2(n)+w*w
      v3(n)= v1(n)*v1(n)-v2(n)
      return
      end     

      subroutine bookout(nct,wm,err)
      implicit real*8(a-h,o-z)
      parameter(nx=150)
      common/values/v1(nx),v2(nx),v3(nx),ni(nx)
      dimension wm(nx),err(nx)
      do i= 1,nct
        wm(i)= v1(i)/ni(i)
        err(i)= sqrt((v2(i)/ni(i)
     *          -v3(i)/ni(i)/(ni(i)-1.d0))/ni(i))
      enddo
      return
      end     
