 module num_routines
 use mpmodule
 implicit none
 complex(kind(1.d0)), public, dimension(0:3) :: cp1,cp2,cp3,cp4,cp5
!
 interface nfunc
  module procedure dp_nfunc
  module procedure mp_nfunc
 end interface!nfunc
!
 contains
!
 function dp_nfunc(q,qt2,idiag)
  use tensor_operations
!   MASSLESS ONLY
    complex*16, intent(in), dimension(0:3) :: q
    complex*16, intent(in) :: qt2
    integer, intent(in) :: idiag
    complex*16 :: dp_nfunc,nfunc2,ctmp1,ctmp2,ctmp3,ctmp4,ctmp5
    real*8, dimension(0:3) :: n1,n2,n3,n4,n5,n6,pp1,pp2
    complex*16 :: ct1,ct2,ct3,ct4,ct5,ct6
    complex(kind(1.d0)) :: aux
    complex*16 :: p1p1,p2p2,p3p3,p4p4,p5p5,qq
    complex*16 :: qp1,qp2,qp3,qp4,qp5 
    complex*16, dimension(0:3) :: p1,p2,p3,p4,p5,dp1,dp2,dp3,dp4 
    integer :: i,j,k
    p1= cp1
    p2= cp2
    p3= cp3
    p4= cp4
    p5= cp5
!
    dp1=p1
    dp2=p1+p5
    dp3=p1+p4+p5
    dp4=p1+p3+p4+p5
!
    call contr(dp1,dp1,1,1,p1p1)
    call contr(dp2,dp2,1,1,p2p2)
    call contr(dp3,dp3,1,1,p3p3)
    call contr(dp4,dp4,1,1,p4p4)
    call contr(q,q,1,1,qq)
    call contr(q,dp1,1,1,qp1)
    call contr(q,dp2,1,1,qp2)
    call contr(q,dp3,1,1,qp3)
    call contr(q,dp4,1,1,qp4)


    if (idiag.eq.1) then
       dp_nfunc= qp1*qp2*qp2*qp4
    elseif (idiag.eq.2) then
       dp_nfunc= qp3*qp4*qp4*qp4
    else
       print*, 'error in Nfunc - check idiag'
       stop
    endif
   
 end function dp_nfunc
!
  function mp_nfunc(q,qt2,idiag)
  use tensor_operations
!   MASSLESS ONLY
    type(mp_complex), intent(in), dimension(0:3) :: q
    complex*16, intent(in) :: qt2
    integer, intent(in) :: idiag
    type(mp_complex) :: mp_nfunc,nfunc2,ctmp1,ctmp2,ctmp3,ctmp4,ctmp5
    type(mp_real), dimension(0:3) :: n1,n2,n3,n4,n5,n6,pp1,pp2
    type(mp_complex) :: ct1,ct2,ct3,ct4,ct5,ct6
    complex(kind(1.d0)) :: aux
    type(mp_complex) :: p1p1,p2p2,p3p3,p4p4,p5p5,qq
    type(mp_complex) :: qp1,qp2,qp3,qp4,qp5 
    type(mp_complex) :: denom1,denom2,denom3,denom4,denom0
    type(mp_complex), dimension(0:3) :: p1,p2,p3,p4,p5,dp1,dp2,dp3,dp4 
    integer :: i,j,k
    do k= 0,3
     p1(k)= cp1(k)
     p2(k)= cp2(k)
     p3(k)= cp3(k)
     p4(k)= cp4(k)
     p5(k)= cp5(k)
!
     dp1(k)=p1(k)
     dp2(k)=p1(k)+p5(k)
     dp3(k)=p1(k)+p4(k)+p5(k)
     dp4(k)=p1(k)+p3(k)+p4(k)+p5(k)
    enddo
!
    call contr(dp1,dp1,1,1,p1p1)
    call contr(dp2,dp2,1,1,p2p2)
    call contr(dp3,dp3,1,1,p3p3)
    call contr(dp4,dp4,1,1,p4p4)
    call contr(q,q,1,1,qq)
    call contr(q,dp1,1,1,qp1)
    call contr(q,dp2,1,1,qp2)
    call contr(q,dp3,1,1,qp3)
    call contr(q,dp4,1,1,qp4)

    if (idiag.eq.1) then
       mp_nfunc= qp1*qp2*qp2*qp4
    elseif (idiag.eq.2) then
       mp_nfunc= qp3*qp4*qp4*qp4
    else
       print*, 'error in Nfunc - check idiag'
       stop
    endif

 end function mp_nfunc
 end  module num_routines


