 module constants  
  use mpmodule
  implicit none
!
  interface one
    module procedure dp_one
    module procedure mp_one
  end interface!one
!
  interface root3
    module procedure dp_root3
    module procedure mp_root3
  end interface!root3
!
  interface pi
    module procedure dp_pi
    module procedure mp_pi
  end interface!pi
!
  interface eps
    module procedure dp_eps
    module procedure mp_eps
  end interface!eps
!
  interface lambda
    module procedure dp_lambda
    module procedure mp_lambda
  end interface!lambda
!
  interface sigma
    module procedure dp_sigma
    module procedure mp_sigma
  end interface!sigma
!
  interface kappa
    module procedure dp_kappa
    module procedure mp_kappa
  end interface!kappa
!
  interface kappa1
    module procedure dp_kappa1
    module procedure mp_kappa1
  end interface!kappa1
!
  interface c0
    module procedure dp_c0
    module procedure mp_c0
  end interface!c0
!
  interface c1
    module procedure dp_c1
    module procedure mp_c1
  end interface!c1
!
  interface ci
    module procedure dp_ci
    module procedure mp_ci
  end interface!ci
!
  interface cexp1
    module procedure dp_cexp1
    module procedure mp_cexp1
  end interface!cexp1
!
  interface cexp2
    module procedure dp_cexp2
    module procedure mp_cexp2
  end interface!cexp2
!
  interface cexp3
    module procedure dp_cexp3
    module procedure mp_cexp3
  end interface!cexp3
!
  interface cexp6
    module procedure dp_cexp6
    module procedure mp_cexp6
  end interface!cexp6
!
  interface cexpk
    module procedure dp_cexpk
    module procedure mp_cexpk
  end interface!cexpk
!
  interface cexpk1
    module procedure dp_cexpk1
    module procedure mp_cexpk1
  end interface!cexpk1
!
  interface tau11
    module procedure dp_tau11
    module procedure mp_tau11
  end interface!tau11
!
  interface tau12
    module procedure dp_tau12
    module procedure mp_tau12
  end interface!tau12
!
  interface tau13r
    module procedure dp_tau13r
    module procedure mp_tau13r
  end interface!tau13r
!
  interface tau14r
    module procedure dp_tau14r
    module procedure mp_tau14r
  end interface!tau14r
!
  interface tau21
    module procedure dp_tau21    
    module procedure mp_tau21
  end interface!tau21
!
  interface tau22
    module procedure dp_tau22
    module procedure mp_tau22
  end interface!tau22
!
  interface tau23r
    module procedure dp_tau23r
    module procedure mp_tau23r
  end interface!tau23r
!
  interface tau31
    module procedure dp_tau31
    module procedure mp_tau31
  end interface!tau31
!
  interface tau32
    module procedure dp_tau32
    module procedure mp_tau32
  end interface!tau32
  contains
!
  function dp_one(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_one
   dp_one   = 1.d0
  end function dp_one
!
  function dp_root3(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_root3,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus= sqrt(3.d0*one(p))
   endif
   dp_root3 = aus
  end function dp_root3
!
  function dp_pi(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_pi,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus    = 4.d0*atan(one(p))
   endif
   dp_pi = aus
  end function dp_pi
!
  function dp_eps(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_eps
   dp_eps   = 1.d-15
  end function dp_eps
!
  function dp_lambda(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_lambda
   dp_lambda= 1.d0
  end function dp_lambda
!
  function dp_sigma(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_sigma
   dp_sigma = 2.d0
  end function dp_sigma
!
  function dp_kappa(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_kappa
   dp_kappa = 3.d0
  end function dp_kappa
!
  function dp_kappa1(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_kappa1
   dp_kappa1= 3.d0
  end function dp_kappa1
!
  function dp_c0(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_c0
   dp_c0    = dcmplx(0.d0,0.d0)
  end function dp_c0
!
  function dp_c1(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_c1
   dp_c1    = dcmplx(1.d0,0.d0)
  end function dp_c1
!
  function dp_ci(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_ci
   dp_ci    = dcmplx(0.d0,1.d0)
  end function dp_ci
!
  function dp_cexp1(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexp1,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/1.d0)
   endif
   dp_cexp1 = aus
  end function dp_cexp1
!
  function dp_cexp2(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexp2,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/2.d0)
   endif
   dp_cexp2 = aus
  end function dp_cexp2
!
  function dp_cexp3(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexp3,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/3.d0)
   endif
   dp_cexp3 = aus
  end function dp_cexp3
!
  function dp_cexp6(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexp6,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/6.d0)
   endif
   dp_cexp6 = aus
  end function dp_cexp6
!
  function dp_cexpk(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexpk,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/kappa(p))
   endif
   dp_cexpk = aus
  end function dp_cexpk
!
  function dp_cexpk1(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_cexpk1,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/kappa1(p))
   endif
   dp_cexpk1= aus
  end function dp_cexpk1
!
  function dp_tau11(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau11
   dp_tau11  = 1.d0
  end function dp_tau11
!
  function dp_tau12(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau12
   dp_tau12  = 1.d0
  end function dp_tau12
!
  function dp_tau13r(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_tau13r
   dp_tau13r = 1.d0
  end function dp_tau13r
!
  function dp_tau14r(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_tau14r
   dp_tau14r = 1.d0
  end function dp_tau14r
!
  function dp_tau21(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau21
   dp_tau21  = 1.d0
  end function dp_tau21
!
  function dp_tau22(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau22
   dp_tau22  = 1.d0
  end function dp_tau22
!
  function dp_tau23r(p)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)) :: dp_tau23r
   dp_tau23r = 1.d0
  end function dp_tau23r
!
  function dp_tau31(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau31
   dp_tau31  = 1.d0
  end function dp_tau31
!
  function dp_tau32(p)
   real(kind(1.d0)), intent(in) :: p
   complex(kind(1.d0)) :: dp_tau32
   dp_tau32  = 1.d0
  end function dp_tau32
!
  function mp_one(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_one
   mp_one   = 1.d0
  end function mp_one
!
  function mp_root3(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_root3,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus= sqrt(3.d0*one(p))
   endif
   mp_root3 = aus
  end function mp_root3
!
  function mp_pi(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_pi,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus    = 4.d0*atan(one(p))
   endif
   mp_pi = aus
  end function mp_pi
!
  function mp_eps(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_eps
   mp_eps   = 1.d-15
  end function mp_eps
!
  function mp_lambda(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_lambda
   mp_lambda= 1.d0
  end function mp_lambda
!
  function mp_sigma(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_sigma
   mp_sigma = 2.d0
  end function mp_sigma
!
  function mp_kappa(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_kappa
   mp_kappa = 3.d0
  end function mp_kappa
!
  function mp_kappa1(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_kappa1
   mp_kappa1= 3.d0
  end function mp_kappa1
!
  function mp_c0(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_c0
   mp_c0    = dcmplx(0.d0,0.d0)
  end function mp_c0
!
  function mp_c1(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_c1
   mp_c1    = dcmplx(1.d0,0.d0)
  end function mp_c1
!
  function mp_ci(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_ci
   mp_ci    = dcmplx(0.d0,1.d0)
  end function mp_ci
!
  function mp_cexp1(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexp1,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/1.d0)
   endif
   mp_cexp1 = aus
  end function mp_cexp1
!
  function mp_cexp2(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexp2,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/2.d0)
   endif
   mp_cexp2 = aus
  end function mp_cexp2
!
  function mp_cexp3(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexp3,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/3.d0)
   endif
   mp_cexp3 = aus
  end function mp_cexp3
!
  function mp_cexp6(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexp6,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/6.d0)
   endif
   mp_cexp6 = aus
  end function mp_cexp6
!
  function mp_cexpk(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexpk,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/kappa(p))
   endif
   mp_cexpk = aus
  end function mp_cexpk
!
  function mp_cexpk1(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_cexpk1,aus  
   logical :: computing=.true.
   save aus,computing
   if (computing) then
    computing=.false.
    aus = exp(ci(p)*pi(p)/kappa1(p))
   endif
   mp_cexpk1= aus
  end function mp_cexpk1
!
  function mp_tau11(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau11
   mp_tau11  = 1.d0
  end function mp_tau11
!
  function mp_tau12(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau12
   mp_tau12  = 1.d0
  end function mp_tau12
!
  function mp_tau13r(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_tau13r
   mp_tau13r = 1.d0
  end function mp_tau13r
!
  function mp_tau14r(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_tau14r
   mp_tau14r = 1.d0
  end function mp_tau14r
!
  function mp_tau21(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau21
   mp_tau21  = 1.d0
  end function mp_tau21
!
  function mp_tau22(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau22
   mp_tau22  = 1.d0
  end function mp_tau22
!
  function mp_tau23r(p)
   type(mp_real), intent(in) :: p
   type(mp_real) :: mp_tau23r
   mp_tau23r = 1.d0
  end function mp_tau23r
!
  function mp_tau31(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau31
   mp_tau31  = 1.d0
  end function mp_tau31
!
  function mp_tau32(p)
   type(mp_real), intent(in) :: p
   type(mp_complex) :: mp_tau32
   mp_tau32  = 1.d0
  end function mp_tau32
 end module constants
!
 module qt2value
  complex(kind(1.d0)), public :: qt2
 end module qt2value
!
 module combinations
  implicit none
  integer, public, parameter :: maxden= 6
  integer, dimension(1:maxden), public, parameter :: &
           string= (/1,2,4,8,16,32/)
  integer, public, parameter :: dimension_den= 32
  integer, public, parameter :: dimension_d  = 60
  integer, public, parameter :: dimension_c  = 56
  integer, public, parameter :: dimension_b  = 48
  integer, public, parameter :: dimension_a  = 32
  integer, public, parameter :: max_solutions= 18
! 1 denominator  among 1
  integer, public, parameter :: nbin11= 1
  integer, dimension(nbin11*1), public, & 
           parameter :: bin11= 1
  integer, public, parameter :: mbin11= 1
! 1 denominator among 2
  integer, public, parameter :: nbin12= 2
  integer, dimension(1:2,nbin12), public, &
           parameter :: bin12= reshape(&
           (/1 ,2, &  
             2 ,1 /)& 
           ,(/2,nbin12/))
  integer, dimension(nbin12), public, &
           parameter :: mbin12= (/1,2/)
! 1 denominator among 3
  integer, public, parameter :: nbin13= 3
  integer, dimension(1:3,nbin13), public, &
           parameter :: bin13= reshape(&
           (/1 ,2 ,4 , &   
             2 ,1 ,4 , & 
             4 ,1 ,2   /)&
           ,(/3,nbin13/))
  integer, dimension(nbin13), public, &
           parameter :: mbin13= (/1, 2, 4/)
! 1 denominator among 4
  integer, public, parameter :: nbin14= 4
  integer, dimension(1:4,nbin14), public, &
           parameter :: bin14= reshape(&
           (/1 ,2 ,4 ,8 , &
             2 ,1 ,4 ,8 , &
             4 ,1 ,2 ,8 , &
             8 ,1 ,2 ,4  /)&
           ,(/4,nbin14/))
  integer, dimension(nbin14), public, &
           parameter :: mbin14= (/1, 2, 4, 8/)
! 1 denominator among 5
  integer, public, parameter :: nbin15= 5
  integer, dimension(1:5,nbin15), public, &
           parameter :: bin15= reshape(&
           (/1 ,2 ,4 ,8 ,16, & 
             2 ,1 ,4 ,8 ,16, & 
             4 ,1 ,2 ,8 ,16, & 
             8 ,1 ,2 ,4 ,16, & 
             16,1 ,2 ,4 ,8   /)&
           ,(/5,nbin15/))
  integer, dimension(nbin15), public, &
           parameter :: mbin15= (/1, 2, 4, 8, 16/)
! 1 denominator among 6
  integer, public, parameter :: nbin16= 6
  integer, dimension(1:6,nbin16), public, &
           parameter :: bin16= reshape(&
           (/1 ,2 ,4 ,8 ,16,32, & 
             2 ,1 ,4 ,8 ,16,32, & 
             4 ,1 ,2 ,8 ,16,32, & 
             8 ,1 ,2 ,4 ,16,32, & 
             16,1 ,2 ,4 ,8 ,32, & 
             32,1 ,2 ,4 ,8 ,16  /)&
           ,(/6,nbin16/))
  integer, dimension(nbin16), public, &
           parameter :: mbin16= (/1, 2, 4, 8, 16, 32/)
! 2 denominators among 2
  integer, public, parameter :: nbin22= 1
  integer, dimension(nbin22*2), public, &
           parameter :: bin22= (/1 ,2 /)
  integer, public, parameter :: mbin22= 3
! 2 denominators among 3
  integer, public, parameter :: nbin23= 3
  integer, dimension(1:3,nbin23), public, &
           parameter :: bin23= reshape(&
           (/1 ,2 ,4 , &
             1 ,4 ,2 , &
             2 ,4 ,1  /)&
           ,(/3,nbin23/))
  integer, dimension(nbin23), public, &
           parameter :: mbin23= (/3, 5, 6/)
! 2 denominators among 4
  integer, public, parameter :: nbin24= 6
  integer, dimension(1:4,nbin24), public, &
           parameter :: bin24= reshape(&
           (/1 ,2 ,4 ,8 , & 
             1 ,4 ,2 ,8 , & 
             1 ,8 ,2 ,4 , & 
             2 ,4 ,1 ,8 , & 
             2 ,8 ,1 ,4 , & 
             4 ,8 ,1 ,2   /)&
           ,(/4,nbin24/))
  integer, dimension(nbin24), public, &
           parameter :: mbin24= (/3, 5, 9, 6, 10, 12/)
! 2 denominators among 5
  integer, public, parameter :: nbin25= 10
  integer, dimension(1:5,nbin25), public, &
           parameter :: bin25= reshape(&
           (/1 ,2 ,4 ,8 ,16, &
             1 ,4 ,2 ,8 ,16, &
             1 ,8 ,2 ,4 ,16, &
             1 ,16,2 ,4 ,8 , &
             2 ,4 ,1 ,8 ,16, &
             2 ,8 ,1 ,4 ,16, &
             2 ,16,1 ,4 ,8 , &
             4 ,8 ,1 ,2 ,16, &
             4 ,16,1 ,2 ,8 , &
             8 ,16,1 ,2 ,4  /)&
           ,(/5,nbin25/))
  integer, dimension(nbin25), public, &
           parameter :: mbin25= (/3, 5, 9, 17, 6 ,10, 18, 12, 20, 24/)
! 2 denominators among 6
  integer, public, parameter :: nbin26= 15
  integer, dimension(1:6,nbin26), public, &
           parameter :: bin26= reshape(&
           (/1 ,2 ,4 ,8 ,16,32, & 
             1 ,4 ,2 ,8 ,16,32, & 
             1 ,8 ,2 ,4 ,16,32, & 
             1 ,16,2 ,4 ,8 ,32, & 
             1 ,32,2 ,4 ,8 ,16, & 
             2 ,4 ,1 ,8 ,16,32, & 
             2 ,8 ,1 ,4 ,16,32, & 
             2 ,16,1 ,4 ,8 ,32, & 
             2 ,32,1 ,4 ,8 ,16, & 
             4 ,8 ,1 ,2 ,16,32, & 
             4 ,16,1 ,2 ,8 ,32, & 
             4 ,32,1 ,2 ,8 ,16, & 
             8 ,16,1 ,2 ,4 ,32, & 
             8 ,32,1 ,2 ,4 ,16, & 
             16,32,1 ,2 ,4 ,8   /)&
           ,(/6,nbin26/))
  integer, dimension(nbin26), public, &
           parameter :: mbin26= (/3, 5, 9, 17, 33 ,6, 10, 18, 34, 12, &
                                 20,36,24, 40, 48/)
! 3 denominators among 3
  integer, public, parameter :: nbin33= 1
  integer, dimension(nbin33*3), public, &
           parameter :: bin33= (/1 ,2 ,4/)
  integer, public, parameter :: mbin33= 7
! 3 denominators among 4
  integer, public, parameter :: nbin34= 4
  integer, dimension(1:4,nbin34), public, &
           parameter :: bin34= reshape(&
           (/1 ,2 ,4 ,8 , &  
             1 ,2 ,8 ,4 , & 
             1 ,4 ,8 ,2 , & 
             2 ,4 ,8 ,1   /)&
           ,(/4,nbin34/))
  integer, dimension(nbin34), public, &
           parameter :: mbin34= (/7, 11, 13, 14/)
! 3 denominators among 5
  integer, public, parameter :: nbin35= 10
  integer, dimension(1:5,nbin35), public, &
           parameter :: bin35= reshape(&
           (/                & 
             1 ,2 ,4 ,8 ,16, & 
             1 ,2 ,8 ,4 ,16, & 
             1 ,4 ,8 ,2 ,16, & 
             2 ,4 ,8 ,1 ,16, & 
             1 ,2 ,16,4 ,8 , & 
             1 ,4 ,16,2 ,8 , & 
             2 ,4 ,16,1 ,8 , & 
             1 ,8 ,16,2 ,4 , & 
             2 ,8 ,16,1 ,4 , & 
             4 ,8 ,16,1 ,2   /)&
           ,(/5,nbin35/))
  integer, dimension(nbin35), public, &
           parameter :: mbin35= (/7, 11, 13, 14, 19, 21, 22, 25, 26, 28/)
! 3 denominators among 6
  integer, public, parameter :: nbin36= 20
  integer, dimension(1:6,nbin36), public, &
           parameter :: bin36= reshape(&
           (/                   &
             1 ,2 ,4 ,8 ,16,32, &
             1 ,2 ,8 ,4 ,16,32, &
             1 ,2 ,16,4 ,8 ,32, &
             1 ,2 ,32,4 ,8 ,16, &
             1 ,4 ,8 ,2 ,16,32, &
             1 ,4 ,16,2 ,8 ,32, &
             1 ,4 ,32,2 ,8 ,16, &
             1 ,8 ,16,2 ,4 ,32, &
             1 ,8 ,32,2 ,4 ,16, &
             1 ,16,32,2 ,4 ,8 , &
             2 ,4 ,8 ,1 ,16,32, &
             2 ,4 ,16,1 ,8 ,32, &
             2 ,4 ,32,1 ,8 ,16, &
             2 ,8 ,16,1 ,4 ,32, &
             2 ,8 ,32,1 ,4 ,16, &
             2 ,16,32,1 ,4 ,8 , &
             4 ,8 ,16,1 ,2 ,32, &
             4 ,8 ,32,1 ,2 ,16, &
             4 ,16,32,1 ,2 ,8 , &
             8 ,16,32,1 ,2 ,4  /)&
           ,(/6,nbin36/))
  integer, dimension(nbin36), public, &
           parameter :: mbin36= (/7, 11, 19, 35, 13, 21, 37, 25, 41, 49, &
                                 14, 22, 38, 26, 42, 50, 28, 44, 52, 56 /)
! 4 denominators among 4
  integer, public, parameter :: nbin44= 1
  integer, dimension(nbin44*4), public, &
           parameter :: bin44= (/1 ,2 ,4 ,8/)
  integer, public, parameter :: mbin44= 15
! 4 denominators among 5
  integer, public, parameter :: nbin45= 5
  integer, dimension(1:5,nbin45), public, &
           parameter :: bin45= reshape(&
           (/1 ,2 ,4 ,8 ,16, & 
             1 ,2 ,4 ,16,8 , & 
             1 ,2 ,8 ,16,4 , & 
             1 ,4 ,8 ,16,2 , & 
             2 ,4 ,8 ,16,1   /)&
           ,(/5,nbin45/))
  integer, dimension(nbin45), public, &
           parameter :: mbin45= (/15 ,23 ,27 ,29 ,30/)
! 4 denominators among 6
  integer, public, parameter :: nbin46= 15
  integer, dimension(1:6,nbin46), public, &
           parameter :: bin46= reshape(&
           (/1 ,2 ,4 , 8,16,32, & 
             1 ,2 ,4 ,16,8 ,32, & 
             1 ,2 ,8 ,16,4 ,32, & 
             1 ,4 ,8 ,16,2 ,32, & 
             2 ,4 ,8 ,16,1 ,32, & 
             1 ,2 ,4 ,32,8 ,16, & 
             1 ,2 ,8 ,32,4 ,16, & 
             1 ,4 ,8 ,32,2 ,16, & 
             2 ,4 ,8 ,32,1 ,16, & 
             1 ,2 ,16,32,4 ,8 , & 
             1 ,4 ,16,32,2 ,8 , & 
             2 ,4 ,16,32,1 ,8 , & 
             1 ,8 ,16,32,2 ,4 , & 
             2 ,8 ,16,32,1 ,4 , & 
             4 ,8 ,16,32,1 ,2   /)&
           ,(/6,nbin46/))
  integer, dimension(nbin46), public, &
           parameter :: mbin46= (/15, 23, 27, 29, 30, 39, &
                      43, 45, 46, 51, 53, 54, 57, 58, 60/)
 end module combinations
!
 module combinatorics
  use combinations
! 4-point sector
!   dim4= max(nbin44,nbin45,nbin46)
  integer, private, parameter :: dim4= nbin46 
  integer, public, dimension(4:maxden,maxden,dim4) :: bn4= -1
  integer, public, dimension(4:maxden) :: nbn4= -1
  integer, public, dimension(4:maxden,dim4) :: mbn4= -1
! 3-point sector
!   dim3= max(nbin33,nbin34,nbin35,nbin36)
  integer, private, parameter :: dim3= nbin36 
  integer, public, dimension(3:maxden,maxden,dim3) :: bn3= -1
  integer, public, dimension(3:maxden) :: nbn3= -1
  integer, public, dimension(3:maxden,dim3) :: mbn3= -1
! 2-point sector
!   dim2= max(nbin22,nbin23,nbin24,nbin25,nbin26)
  integer, private, parameter :: dim2= nbin26 
  integer, public, dimension(2:maxden,maxden,dim2) :: bn2= -1
  integer, public, dimension(2:maxden) :: nbn2= -1
  integer, public, dimension(2:maxden,dim2) :: mbn2= -1
! 1-point secto
!   dim1= max(nbin11,nbin12,nbin13,nbin14,nbin15,nbin16)
  integer, private, parameter :: dim1= nbin16 
  integer, public, dimension(1:maxden,maxden,dim1) :: bn1= -1
  integer, public, dimension(1:maxden) :: nbn1= -1
  integer, public, dimension(1:maxden,dim1) :: mbn1= -1
  contains
!
  subroutine load_combinatorics
  integer i,j
! 4-point sector
  nbn4(4)= nbin44; nbn4(5)= nbin45; nbn4(6)= nbin46
  do j= 1,nbn4(4)
   mbn4(4,j) = mbin44
   do i= 1,4
    bn4(4,i,j)= bin44(i)
   enddo
  enddo
  do j= 1,nbn4(5)
   mbn4(5,j) = mbin45(j)
   do i= 1,5  
    bn4(5,i,j)= bin45(i,j)
   enddo
  enddo
  do j= 1,nbn4(6)
   mbn4(6,j) = mbin46(j)
   do i= 1,6  
    bn4(6,i,j)= bin46(i,j)
   enddo
  enddo
! 3-point sector
  nbn3(3)= nbin33; nbn3(4)= nbin34
  nbn3(5)= nbin35; nbn3(6)= nbin36
  do j= 1,nbn3(3)
   mbn3(3,j) = mbin33
   do i= 1,3  
    bn3(3,i,j)= bin33(i)
   enddo
  enddo
  do j= 1,nbn3(4)
   mbn3(4,j) = mbin34(j)
   do i= 1,4 
    bn3(4,i,j)= bin34(i,j)
   enddo
  enddo
  do j= 1,nbn3(5)
   do i= 1,5  
    bn3(5,i,j)= bin35(i,j)
    mbn3(5,j) = mbin35(j)
   enddo
  enddo
  do j= 1,nbn3(6)
   mbn3(6,j) = mbin36(j)
   do i= 1,6 
    bn3(6,i,j)= bin36(i,j)
   enddo
  enddo
! 2-point sector
  nbn2(2)= nbin22; nbn2(3)= nbin23
  nbn2(4)= nbin24; nbn2(5)= nbin25
  nbn2(6)= nbin26
  do j= 1,nbn2(2)
   mbn2(2,j) = mbin22
   do i= 1,2 
    bn2(2,i,j)= bin22(i)
   enddo
  enddo
  do j= 1,nbn2(3)
   mbn2(3,j) = mbin23(j)
   do i= 1,3  
    bn2(3,i,j)= bin23(i,j)
   enddo
  enddo
  do j= 1,nbn2(4)
   mbn2(4,j) = mbin24(j)
   do i= 1,4 
    bn2(4,i,j)= bin24(i,j)
   enddo
  enddo
  do j= 1,nbn2(5)
   mbn2(5,j) = mbin25(j)
   do i= 1,5  
    bn2(5,i,j)= bin25(i,j)
   enddo
  enddo
  do j= 1,nbn2(6)
   mbn2(6,j) = mbin26(j)
   do i= 1,6  
    bn2(6,i,j)= bin26(i,j)
   enddo
  enddo
! 1-point sector
  nbn1(1)= nbin11; nbn1(2)= nbin12 
  nbn1(3)= nbin13; nbn1(4)= nbin14
  nbn1(5)= nbin15; nbn1(6)= nbin16
  do j= 1,nbn1(1)
   mbn1(1,j) = mbin11
   do i= 1,1  
    bn1(1,i,j)= bin11(i)
   enddo
  enddo
  do j= 1,nbn1(2)
   mbn1(2,j) = mbin12(j)
   do i= 1,2 
    bn1(2,i,j)= bin12(i,j)
   enddo
  enddo
  do j= 1,nbn1(3)
   mbn1(3,j) = mbin13(j)
   do i= 1,3 
    bn1(3,i,j)= bin13(i,j)
   enddo
  enddo
  do j= 1,nbn1(4)
   mbn1(4,j) = mbin14(j)
   do i= 1,4 
    bn1(4,i,j)= bin14(i,j)
   enddo
  enddo
  do j= 1,nbn1(5)
   mbn1(5,j) = mbin15(j)
   do i= 1,5 
    bn1(5,i,j)= bin15(i,j)
   enddo
  enddo
  do j= 1,nbn1(6)
   mbn1(6,j) = mbin16(j)
   do i= 1,6  
    bn1(6,i,j)= bin16(i,j)
   enddo
  enddo
  end subroutine load_combinatorics
 end module combinatorics
!
 module denominators
  use mpmodule
  use def_propagator                                       
  use def_mp_propagator                                       
  use qt2value
  use combinatorics
  implicit none
  type(propagator), dimension(1:dimension_den), public :: den
  type(mp_propagator), dimension(1:dimension_den), public :: mp_den
  complex(kind(1.d0)), dimension(1:dimension_den,max_solutions), public :: vden
  type(mp_complex), dimension(1:dimension_den,max_solutions), public :: mp_vden
  save den,vden
!
  interface load_denominators
    module procedure load_dp_denominators_6
    module procedure load_dp_denominators_5
    module procedure load_dp_denominators_4
    module procedure load_dp_denominators_3
    module procedure load_dp_denominators_2
    module procedure load_dp_denominators_1
    module procedure load_mp_denominators_6
    module procedure load_mp_denominators_5
    module procedure load_mp_denominators_4
    module procedure load_mp_denominators_3
    module procedure load_mp_denominators_2
    module procedure load_mp_denominators_1
  end interface!load_denominators
!
  interface initden
    module procedure dp_initden
    module procedure mp_initden
  end interface!initden
!
  interface value
    module procedure dp_value
    module procedure mp_value
  end interface!value
!
  interface load_vden
    module procedure dp_load_vden
    module procedure mp_load_vden
  end interface!load_vden
  contains
!
  subroutine load_dp_denominators_6(den0,den1,den2,den3,den4,den5)
   type(propagator), intent(in) :: den0,den1,den2,den3,den4,den5
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0; den(2) = den1; den(4) = den2; den(8) = den3 
   den(16)= den4; den(32)= den5
   do k= 0,5
    den(2**k)%i = 2**k
   enddo
  end subroutine load_dp_denominators_6
!
  subroutine load_dp_denominators_5(den0,den1,den2,den3,den4)
   type(propagator), intent(in) :: den0,den1,den2,den3,den4
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0; den(2) = den1; den(4) = den2; den(8) = den3 
   den(16)= den4 
   do k= 0,4
    den(2**k)%i = 2**k
   enddo
   den(32)%i= -1
  end subroutine load_dp_denominators_5
!
  subroutine load_dp_denominators_4(den0,den1,den2,den3)
   type(propagator), intent(in) :: den0,den1,den2,den3
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0; den(2) = den1; den(4) = den2; den(8) = den3 
   do k= 0,3
    den(2**k)%i = 2**k
   enddo
   den(32)%i= -1; den(16)%i= -1
  end subroutine load_dp_denominators_4
!
  subroutine load_dp_denominators_3(den0,den1,den2)
   type(propagator), intent(in) :: den0,den1,den2
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0; den(2) = den1; den(4) = den2
   do k= 0,2
    den(2**k)%i = 2**k
   enddo
   den(32)%i= -1; den(16)%i= -1; den(8)%i= -1
  end subroutine load_dp_denominators_3
!
  subroutine load_dp_denominators_2(den0,den1)
   type(propagator), intent(in) :: den0,den1
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0; den(2) = den1
   do k= 0,1
    den(2**k)%i = 2**k
   enddo
   den(32)%i= -1; den(16)%i= -1; den(8)%i= -1; den(4)%i= -1 
  end subroutine load_dp_denominators_2
!
  subroutine load_dp_denominators_1(den0)
   type(propagator), intent(in) :: den0
   real(kind(1.d0)) :: p
   integer :: k
   call initden(p)
   den(1) = den0
   do k= 0,0
    den(2**k)%i = 2**k
   enddo
   den(32)%i= -1; den(16)%i= -1; den(8)%i= -1; den(4)%i= -1; den(2)%i= -1 
  end subroutine load_dp_denominators_1
!
  subroutine load_mp_denominators_6(den0,den1,den2,den3,den4,den5)
   type(mp_propagator), intent(in) :: den0,den1,den2,den3,den4,den5
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0; mp_den(2) = den1; mp_den(4) = den2; mp_den(8) = den3 
   mp_den(16)= den4; mp_den(32)= den5
   do k= 0,5
    mp_den(2**k)%i = 2**k
   enddo
  end subroutine load_mp_denominators_6
!
  subroutine load_mp_denominators_5(den0,den1,den2,den3,den4)
   type(mp_propagator), intent(in) :: den0,den1,den2,den3,den4
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0; mp_den(2) = den1; mp_den(4) = den2; mp_den(8) = den3 
   mp_den(16)= den4 
   do k= 0,4
    mp_den(2**k)%i = 2**k
   enddo
   mp_den(32)%i= -1
  end subroutine load_mp_denominators_5
!
  subroutine load_mp_denominators_4(den0,den1,den2,den3)
   type(mp_propagator), intent(in) :: den0,den1,den2,den3
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0; mp_den(2) = den1; mp_den(4) = den2; mp_den(8) = den3 
   do k= 0,3
    mp_den(2**k)%i = 2**k
   enddo
   mp_den(32)%i= -1; mp_den(16)%i= -1
  end subroutine load_mp_denominators_4
!
  subroutine load_mp_denominators_3(den0,den1,den2)
   type(mp_propagator), intent(in) :: den0,den1,den2
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0; mp_den(2) = den1; mp_den(4) = den2
   do k= 0,2
    mp_den(2**k)%i = 2**k
   enddo
   mp_den(32)%i= -1; mp_den(16)%i= -1; mp_den(8)%i= -1
  end subroutine load_mp_denominators_3
!
  subroutine load_mp_denominators_2(den0,den1)
   type(mp_propagator), intent(in) :: den0,den1
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0; mp_den(2) = den1
   do k= 0,1
    mp_den(2**k)%i = 2**k
   enddo
   mp_den(32)%i= -1; mp_den(16)%i= -1; mp_den(8)%i= -1; mp_den(4)%i= -1 
  end subroutine load_mp_denominators_2
!
  subroutine load_mp_denominators_1(den0)
   type(mp_propagator), intent(in) :: den0
   type(mp_real) :: p
   integer :: k
   call initden(p)
   mp_den(1) = den0
   mp_den(32)%i= -1; mp_den(16)%i= -1; mp_den(8)%i= -1; mp_den(4)%i= -1
   do k= 0,0
    mp_den(2**k)%i = 2**k
   enddo
   mp_den(2)%i= -1 
  end subroutine load_mp_denominators_1
!
  subroutine dp_initden(p)
  real(kind(1.d0)) :: p
  integer :: j,kk,k
  do j= 1,maxden
   kk= string(j)
   den(kk)%i = -1
   den(kk)%m2= 0.d0
   do k= 0,3
    den(kk)%p(k) = 0.d0
   enddo
  enddo
  end subroutine dp_initden
!
  subroutine mp_initden(p)
  type(mp_real) :: p
  integer :: j,kk,k
  do j= 1,maxden
   kk= string(j)
   mp_den(kk)%i = -1
   mp_den(kk)%m2= 0.d0
   do k= 0,3
    mp_den(kk)%p(k) = 0.d0
   enddo
  enddo
  end subroutine mp_initden
!
  function dp_value(den,q)
   use tensor_operations  
   complex(kind(1.d0)) :: dp_value
   type(propagator), intent (in) :: den
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   complex(kind(1.d0)), dimension(0:3) :: qp
   complex(kind(1.d0)) :: qp2
   integer :: k
   do k= 0,3
    qp(k)= q(k)+den%p(k)
   enddo
   call contr(qp,qp,1,1,qp2)
   dp_value = qp2-den%m2+qt2
  end function dp_value
!
  function mp_value(den,q)
   use tensor_operations  
   type(mp_complex) :: mp_value
   type(mp_propagator), intent (in) :: den
   type(mp_complex), intent(in), dimension(0:3) :: q
   type(mp_complex), dimension(0:3) :: qp
   type(mp_complex) :: qp2
   integer :: k
   do k= 0,3
    qp(k)= q(k)+den%p(k)
   enddo
   call contr(qp,qp,1,1,qp2)
   mp_value = qp2-den%m2+qt2
  end function mp_value
!
  subroutine dp_load_vden(q,i,j)
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   integer, intent(in) :: i,j
   if (den(i)%i.gt.0) vden(i,j) = value(den(i),q)
  end subroutine dp_load_vden
!
  subroutine mp_load_vden(q,i,j)
   type(mp_complex), intent(in), dimension(0:3) :: q
   integer, intent(in) :: i,j
   if (mp_den(i)%i.gt.0) mp_vden(i,j) = value(mp_den(i),q)
  end subroutine mp_load_vden
 end module denominators
!
 module cuttings
  use tensor_operations  
  use def_propagator                                       
  use def_mp_propagator                                       
  use def_solcut
  use def_mp_solcut
  use qt2value
  use denominators
  use constants
  implicit none
  integer, private :: i,j,kk
  interface cut
   module procedure dp_cutting4
   module procedure dp_cutting3
   module procedure dp_cutting2
   module procedure dp_cutting1
   module procedure mp_cutting4
   module procedure mp_cutting3
   module procedure mp_cutting2
   module procedure mp_cutting1
  end interface!cut
!
  interface build_l
   module procedure dp_build_l
   module procedure mp_build_l
  end interface!build_l
  contains
!
  subroutine dp_build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,ga)  
   real(kind(1.d0)) :: p
   real(kind(1.d0)), intent(in), dimension(0:3) :: k1,k2
   complex(kind(1.d0)), intent(out), dimension(0:3) :: l1,l2,l3,l4
   complex(kind(1.d0)), intent(out) :: al1,al2,bet,ga 
   real(kind(1.d0)):: k1k1,k1k2,k2k2
   complex(kind(1.d0)) :: del12,b1,b2,c1p,c1m,c2p,c2m
   integer :: k
   call contr(k1,k1,1,1,k1k1)
   call contr(k1,k2,1,1,k1k2)
   call contr(k2,k2,1,1,k2k2)
   del12= (k1k2*k1k2-k1k1*k2k2)*c1(p)
   if (k1k2.gt.0.d0) then
    ga= k1k2+sqrt(del12)
   else
    ga= k1k2-sqrt(del12)
   endif
   al1= k1k1/ga
   al2= k2k2/ga
   bet= c1(p)/(c1(p)-al1*al2)
   do k= 0,3
    l1(k)= bet*(k1(k)-al1*k2(k))
    l2(k)= bet*(k2(k)-al2*k1(k))
   enddo
   b1= sqrt(l1(0)+l1(3))
   c1m= l1(1)-ci(p)*l1(2)
   if (abs(c1m/l1(0)).gt.eps(p)) then
    c1m= c1m/b1
    c1p= (l1(1)+ci(p)*l1(2))/b1
   else
    c1m= sqrt(0.5d0*(l1(0)-l1(3)))*(1.d0-ci(p))
    c1p= sqrt(0.5d0*(l1(0)-l1(3)))*(1.d0+ci(p))
   endif
   b2= sqrt(l2(0)+l2(3))
   c2m= l2(1)-ci(p)*l2(2)
   if (abs(c2m/l2(0)).gt.eps(p)) then
    c2m= c2m/b2
    c2p= (l2(1)+ci(p)*l2(2))/b2
   else
    c2m= sqrt(0.5d0*(l2(0)-l2(3)))*(1.d0-ci(p))
    c2p= sqrt(0.5d0*(l2(0)-l2(3)))*(1.d0+ci(p))
   endif
   l3(0)=     b1*b2  + c1m*c2p
   l3(1)=     b1*c2p + c1m*b2
   l3(2)= ci(p)*(c1m*b2 - b1*c2p)
   l3(3)=     b1*b2  - c1m*c2p  
   l4(0)=     b2*b1  + c2m*c1p
   l4(1)=     b2*c1p + c2m*b1
   l4(2)= ci(p)*(c2m*b1 - b2*c1p)
   l4(3)=     b2*b1  - c2m*c1p
  end subroutine dp_build_l
!
  subroutine mp_build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,ga)  
   type(mp_real) :: p
   type(mp_real), intent(in), dimension(0:3) :: k1,k2
   type(mp_complex), intent(out), dimension(0:3) :: l1,l2,l3,l4
   type(mp_complex), intent(out) :: al1,al2,bet,ga 
   type(mp_real):: k1k1,k1k2,k2k2
   type(mp_complex) :: del12,b1,b2,c1p,c1m,c2p,c2m
   integer :: k
   call contr(k1,k1,1,1,k1k1)
   call contr(k1,k2,1,1,k1k2)
   call contr(k2,k2,1,1,k2k2)
   del12= (k1k2*k1k2-k1k1*k2k2)*c1(p)
   if (k1k2.gt.0.d0) then
    ga= k1k2+sqrt(del12)
   else
    ga= k1k2-sqrt(del12)
   endif
   al1= k1k1/ga
   al2= k2k2/ga
   bet= c1(p)/(c1(p)-al1*al2)
   do k= 0,3
    l1(k)= bet*(k1(k)-al1*k2(k))
    l2(k)= bet*(k2(k)-al2*k1(k))
   enddo
   b1= sqrt(l1(0)+l1(3))
   c1m= l1(1)-ci(p)*l1(2)
   if (abs(c1m/l1(0)).gt.eps(p)) then
    c1m= c1m/b1
    c1p= (l1(1)+ci(p)*l1(2))/b1
   else
    c1m= sqrt(0.5d0*(l1(0)-l1(3)))*(1.d0-ci(p))
    c1p= sqrt(0.5d0*(l1(0)-l1(3)))*(1.d0+ci(p))
   endif
   b2= sqrt(l2(0)+l2(3))
   c2m= l2(1)-ci(p)*l2(2)
   if (abs(c2m/l2(0)).gt.eps(p)) then
    c2m= c2m/b2
    c2p= (l2(1)+ci(p)*l2(2))/b2
   else
    c2m= sqrt(0.5d0*(l2(0)-l2(3)))*(1.d0-ci(p))
    c2p= sqrt(0.5d0*(l2(0)-l2(3)))*(1.d0+ci(p))
   endif
   l3(0)=     b1*b2  + c1m*c2p
   l3(1)=     b1*c2p + c1m*b2
   l3(2)= ci(p)*(c1m*b2 - b1*c2p)
   l3(3)=     b1*b2  - c1m*c2p  
   l4(0)=     b2*b1  + c2m*c1p
   l4(1)=     b2*c1p + c2m*b1
   l4(2)= ci(p)*(c2m*b1 - b2*c1p)
   l4(3)=     b2*b1  - c2m*c1p
  end subroutine mp_build_l
!
  subroutine dp_cutting4(den0,den1,den2,den3,cut4)
   real(kind(1.d0)) :: p
   type(propagator), intent(in) :: den0,den1,den2,den3
   type(solcut4) ,intent(out) :: cut4
   real(kind(1.d0)), dimension(0:3) :: p0,p1,p2,p3,k1,k2,k3
   real(kind(1.d0)):: k1k1,k2k2,k3k3
   real(kind(1.d0)):: m02,m12,m22,m32
   real(kind(1.d0)):: dd0,dd1,dd2,dd3
   complex(kind(1.d0)) :: l1k3,l2k3,l3k3,l4k3,x10,x20,x3p,x4p,x3m,x4m
   complex(kind(1.d0)) :: cc,ca3,cb3,root,al1,al2,bet,gm,z
   complex(kind(1.d0)), dimension(0:3) :: l1,l2,l3,l4
   integer :: k
!
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
   p3= den3%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
   m32= den3%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
    k3(k)= p3(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
   call contr(k2,k2,1,1,k2k2)
   call contr(k3,k3,1,1,k3k3)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
!
   call contr(l1,k3,1,1,l1k3)
   call contr(l2,k3,1,1,l2k3)
   call contr(l3,k3,1,1,l3k3)
   call contr(l4,k3,1,1,l4k3)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   dd3= m32-k3k3
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   ca3= -l3k3/l4k3
   cb3= (dd3-dd0-2.d0*x10*l1k3-2.d0*x20*l2k3)/2.d0/l4k3
   root= sqrt(cb3**2+4.d0*cc*ca3)
   if (real(cb3).le.0.d0) then
     x3p= (-cb3+root)/2.d0/ca3
     x3m= -cc/ca3/x3p
     x4m= (cb3-root)/2.d0
     x4p= -cc*ca3/x4m
! 
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   else
     x3m= (-cb3-root)/2.d0/ca3
     x3p= -cc/ca3/x3m
     x4p= (cb3+root)/2.d0
     x4m= -cc*ca3/x4p
!      
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   endif   
!
!  the 2 solutions, the basis and the vector t
! 
!   q(1)= q^+
!   q(2)= q^-
!
   do i= 0,3
    cut4%q(i,1)= -p0(i)+x10*l1(i)+x20*l2(i)+x3p*l3(i)+x4p*l4(i)
    cut4%q(i,2)= -p0(i)+x10*l1(i)+x20*l2(i)+x3m*l3(i)+x4m*l4(i)
    cut4%l1(i)= l1(i)
    cut4%l2(i)= l2(i)
    cut4%l3(i)= l3(i)
    cut4%l4(i)= l4(i)
    cut4%t(i) = l3(i)*l4k3-l4(i)*l3k3
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,2
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i.or. &
         kk.eq.den3%i) then
      vden(kk,i)= c0(p)
     else
      call load_vden(cut4%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine dp_cutting4  
!
  subroutine dp_cutting3(den0,den1,den2,cut3)
   real(kind(1.d0)) :: p
   type(propagator), intent(in) :: den0,den1,den2
   type(solcut3), intent(out) :: cut3
   real(kind(1.d0)), dimension(0:3) :: p0,p1,p2,k1,k2
   real(kind(1.d0)):: k1k1,k2k2
   real(kind(1.d0)):: m02,m12,m22
   real(kind(1.d0)):: dd0,dd1,dd2
   complex(kind(1.d0)) :: x10,x20,x3,x4,q3caus
   complex(kind(1.d0)) :: cc,ca3,al1,al2,bet,gm,z
   complex(kind(1.d0)), dimension(0:3)  :: l1,l2,l3,l4
   integer :: k
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
   call contr(k2,k2,1,1,k2k2)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
   l3= l3 
   l4= l4 
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   cut3%gm= gm
!
!  the 16 solutions and the basis:
! 
!   q( 1)= q_1^+
!   q( 2)= q_1^-
!   q( 3)= q_2^+
!   q( 4)= q_2^-
!   q( 5)= q_3^+
!   q( 6)= q_3^-
!   q( 7)= q_6^+
!   q( 8)= q_6^-
!   q( 9)= q'_1^+
!   q(10)= q'_1^-
!   q(11)= q'_2^+
!   q(12)= q'_2^-
!   q(13)= q'_3^+
!   q(14)= q'_3^-
!   q(15)= q'_6^+
!   q(16)= q'_6^-
!
   do i= 0,3
    q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
    x4= cexp1(p)
    x3= cc/x4
    cut3%q(i,1) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,2) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,9) = q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,10)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp2(p)			 		
    x3= cc/x4			 		
    cut3%q(i,3) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,4) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,11)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,12)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp3(p)			 		
    x3= cc/x4			 		
    cut3%q(i,5) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,6) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,13)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,14)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp6(p)			 		
    x3= cc/x4			 		
    cut3%q(i,7) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,8) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,15)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,16)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!
    cut3%l1(i)= l1(i)
    cut3%l2(i)= l2(i)
    cut3%l3(i)= l3(i)
    cut3%l4(i)= l4(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,16
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i) then
      vden(kk,i)= c0(p)
     else
      call load_vden(cut3%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine dp_cutting3  
!
  subroutine dp_cutting2(den0,den1,cut2)
   real(kind(1.d0)) :: p
   type(propagator), intent(in) :: den0,den1
   type(solcut2), intent(out) :: cut2
   real(kind(1.d0)), dimension(0:3) :: p0,p1,k1,v
   real(kind(1.d0)):: k1k1,factor
   real(kind(1.d0)):: m02,m12
   real(kind(1.d0)):: dd0,dd1
   integer :: k
   complex(kind(1.d0)) :: yv0,yvsigma,yvlambda,y3,y4
   complex(kind(1.d0)) :: al,al2,bet,gm,cf0,cflambda,cfsigma,q2caus
   complex(kind(1.d0)), dimension(0:3)  :: l1,l2,l3,l4
   p0= den0%p 
   p1= den1%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
!
!  define the arbitrary massless 4-vector v
!
   factor= tau23r(p)
   v(0)= sign(factor         ,k1(0)+eps(p))
   v(1)=-sign(factor/root3(p),k1(1)+eps(p))
   v(2)=-sign(factor/root3(p),k1(2)+eps(p))
   v(3)=-sign(factor/root3(p),k1(3)+eps(p))
   call build_l(k1,v,l1,l2,l3,l4,al,al2,bet,gm)
   cut2%gm= gm
   cut2%rat1= (den0%m2+den1%m2-k1k1/3.d0) 
   dd0= m02
   dd1= m12-k1k1
!
   cf0     = -0.25d0/gm*(m02*c1(p))
   cflambda= -0.25d0/gm*(m02*c1(p)-lambda(p)*(dd1-dd0)*c1(p)+lambda(p)**2*k1k1)
   cut2%cflambda= cflambda
   cfsigma = -0.25d0/gm*(m02*c1(p)-sigma(p) *(dd1-dd0)*c1(p)+sigma(p)**2 *k1k1)
   cut2%cfsigma = cfsigma
!
   yv0     =  (dd1-dd0)*c1(p)/gm
   yvlambda= ((dd1-dd0)*c1(p)-2.d0*lambda(p)*k1k1*c1(p))/gm
   yvsigma = ((dd1-dd0)*c1(p)-2.d0*sigma(p) *k1k1*c1(p))/gm
!
!  the 18 solutions and the basis
! 
!   q( 1)= q_01^+
!   q( 2)= q_01^-
!   q( 3)= q_02^+
!   q( 4)= q_02^-
!   q( 5)= q_03^+
!   q( 6)= q_03^-
!   q( 7)= q'_01^+
!   q( 8)= q'_01^-
!   q( 9)= q'_02^+
!   q(10)= q'_02^-
!   q(11)= q'_03^+
!   q(12)= q'_03^-
!   q(13)= q_lambda_1^+
!   q(14)= q_lambda_1^-
!   q(15)= q_sigma_1^+
!   q(16)= q_sigma_1^-
!   q(17)= q_lambda_kappa^+
!   q(18)= q'_sigma_kappa^+
!
   do i= 0,3
    q2caus= -p0(i)*c1(p)+yv0*v(i)
    y3= cexp1(p)
    y4= cf0/y3
    cut2%q(i,1) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,2) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,7) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,8) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
 !
    y3= cexp2(p)
    y4= cf0/y3
    cut2%q(i,3)  = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,4)  = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,9)  = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,10) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
! 
    y3= cexp3(p)
    y4= cf0/y3
    cut2%q(i,5)  = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,6)  = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,11) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,12) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
!
    q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
    y3= cexp1(p)
    y4= cflambda/y3
    cut2%q(i,13) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,14) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    y3= cexpk(p)
    y4= cflambda/y3
    cut2%q(i,17) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
!
    q2caus= -p0(i)*c1(p)+sigma(p) *c1(p)*k1(i)+ yvsigma*v(i)
    y3= cexp1(p)
    y4= cfsigma /y3
    cut2%q(i,15) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,16) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    y3= cexpk(p)
    y4= cfsigma /y3
    cut2%q(i,18) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%l3(i)= l3(i)
    cut2%l4(i)= l4(i)
    cut2%k1(i)= k1(i)
    cut2%v(i) = v(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,18
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i) then
      vden(kk,i)= c0(p)
     else
      call load_vden(cut2%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine dp_cutting2  
!
  subroutine dp_cutting1(den0,cut1)
   real(kind(1.d0)) :: p
   type(propagator), intent(in) :: den0
   type(solcut1), intent(out) :: cut1
   real(kind(1.d0)), dimension(0:3) :: p0,v,k
   real(kind(1.d0)):: m02
   complex(kind(1.d0)) :: al1,al2,bet,gm
   complex(kind(1.d0)) :: cf0
   complex(kind(1.d0)), dimension(0:3)  :: l1,l2,l3,l4
   logical :: computing=.true.
   save computing,v,k
   if (computing) then
!    define the arbitrary massless 4-vectors v and k
     computing=.false.
     v(0)= tau13r(p)
     v(1)= v(0)/root3(p)
     v(2)= v(0)/root3(p)
     v(3)= v(0)/root3(p)
!
     k(0)= tau14r(p)
     k(1)=-k(0)/root3(p)
     k(2)=-k(0)/root3(p)
     k(3)=-k(0)/root3(p)
   endif
!
   p0 = den0%p 
   m02= den0%m2-qt2 
   call build_l(v,k,l1,l2,l3,l4,al1,al2,bet,gm)
   cut1%gm= gm
! 
   cf0      = -0.25d0/gm*(m02*c1(p))
   cut1%cf0 = cf0
!
!  the 5 solutions and the basis
! 
!   q( 1)= q_0^+
!   q( 2)= q_0^-
!   q( 3)= q_1
!   q( 4)= q_2
!   q( 5)= q_3 
!
   do i= 0,3
    cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
    cut1%q(i,2) = -p0(i)-cf0*tau11(p)*l3(i)-l4(i)/tau11(p)
    cut1%q(i,3) =  cut1%q(i,1)+v(i)
    cut1%q(i,4) =  cut1%q(i,1)+k(i)
    cut1%q(i,5) = -p0(i)+cexpk1(p)*tau12(p)*tau11(p)*l3(i) &
                   +cf0/cexpk1(p)*l4(i)/tau11(p)/tau12(p)
    cut1%v(i)   = v(i)
    cut1%k(i)   = k(i)
    cut1%l3(i)  = l3(i)
    cut1%l4(i)  = l4(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,5
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i) then
      vden(kk,i)= c0(p)
     else
      call load_vden(cut1%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine dp_cutting1
! 
  subroutine mp_cutting4(den0,den1,den2,den3,cut4)
   type(mp_real) :: p
   type(mp_propagator), intent(in) :: den0,den1,den2,den3
   type(mp_solcut4) ,intent(out) :: cut4
   type(mp_real), dimension(0:3) :: p0,p1,p2,p3,k1,k2,k3
   type(mp_real):: k1k1,k2k2,k3k3
   type(mp_real):: m02,m12,m22,m32
   type(mp_real):: dd0,dd1,dd2,dd3
   type(mp_complex) :: l1k3,l2k3,l3k3,l4k3,x10,x20,x3p,x4p,x3m,x4m
   type(mp_complex) :: cc,ca3,cb3,root,al1,al2,bet,gm,z
   type(mp_complex), dimension(0:3) :: l1,l2,l3,l4
   integer :: k
!
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
   p3= den3%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
   m32= den3%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
    k3(k)= p3(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
   call contr(k2,k2,1,1,k2k2)
   call contr(k3,k3,1,1,k3k3)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
!
   call contr(l1,k3,1,1,l1k3)
   call contr(l2,k3,1,1,l2k3)
   call contr(l3,k3,1,1,l3k3)
   call contr(l4,k3,1,1,l4k3)
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   dd3= m32-k3k3
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   ca3= -l3k3/l4k3
   cb3= (dd3-dd0-2.d0*x10*l1k3-2.d0*x20*l2k3)/2.d0/l4k3
   root= sqrt(cb3**2+4.d0*cc*ca3)
   if (mpreal(cb3).le.0.d0) then
     x3p= (-cb3+root)/2.d0/ca3
     x3m= -cc/ca3/x3p
     x4m= (cb3-root)/2.d0
     x4p= -cc*ca3/x4m
! 
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   else
     x3m= (-cb3-root)/2.d0/ca3
     x3p= -cc/ca3/x3m
     x4p= (cb3+root)/2.d0
     x4m= -cc*ca3/x4p
!      
!     x4p= cc/x3p
!     x4m= cc/x3m
!
   endif   
!
!  the 2 solutions, the basis and the vector t
! 
!   q(1)= q^+
!   q(2)= q^-
!
   do i= 0,3
    cut4%q(i,1)= -p0(i)+x10*l1(i)+x20*l2(i)+x3p*l3(i)+x4p*l4(i)
    cut4%q(i,2)= -p0(i)+x10*l1(i)+x20*l2(i)+x3m*l3(i)+x4m*l4(i)
    cut4%l1(i)= l1(i)
    cut4%l2(i)= l2(i)
    cut4%l3(i)= l3(i)
    cut4%l4(i)= l4(i)
    cut4%t(i) = l3(i)*l4k3-l4(i)*l3k3
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,2
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i.or. &
         kk.eq.den3%i) then
      mp_vden(kk,i)= c0(p)
     else
      call load_vden(cut4%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine mp_cutting4  
!
  subroutine mp_cutting3(den0,den1,den2,cut3)
   type(mp_real) :: p
   type(mp_propagator), intent(in) :: den0,den1,den2
   type(mp_solcut3), intent(out) :: cut3
   type(mp_real), dimension(0:3) :: p0,p1,p2,k1,k2
   type(mp_real):: k1k1,k2k2
   type(mp_real):: m02,m12,m22
   type(mp_real):: dd0,dd1,dd2
   type(mp_complex) :: x10,x20,x3,x4,q3caus
   type(mp_complex) :: cc,ca3,al1,al2,bet,gm,z
   type(mp_complex), dimension(0:3)  :: l1,l2,l3,l4
   integer :: k
   p0= den0%p 
   p1= den1%p 
   p2= den2%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
   m22= den2%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
    k2(k)= p2(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
   call contr(k2,k2,1,1,k2k2)
   call build_l(k1,k2,l1,l2,l3,l4,al1,al2,bet,gm)
   l3= l3 
   l4= l4 
   z= bet/gm
   dd0= m02
   dd1= m12-k1k1
   dd2= m22-k2k2
   x10= z*(dd2-al2*dd1-dd0*(1.d0-al2))
   x20= z*(dd1-al1*dd2-dd0*(1.d0-al1))
   cc = 0.25d0*(x10*x20-dd0/gm)
   cut3%gm= gm
!
!  the 16 solutions and the basis:
! 
!   q( 1)= q_1^+
!   q( 2)= q_1^-
!   q( 3)= q_2^+
!   q( 4)= q_2^-
!   q( 5)= q_3^+
!   q( 6)= q_3^-
!   q( 7)= q_6^+
!   q( 8)= q_6^-
!   q( 9)= q'_1^+
!   q(10)= q'_1^-
!   q(11)= q'_2^+
!   q(12)= q'_2^-
!   q(13)= q'_3^+
!   q(14)= q'_3^-
!   q(15)= q'_6^+
!   q(16)= q'_6^-
!
   do i= 0,3
    q3caus= -p0(i)+x10*l1(i)+x20*l2(i)
    x4= cexp1(p)
    x3= cc/x4
    cut3%q(i,1) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,2) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,9) = q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,10)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp2(p)			 		
    x3= cc/x4			 		
    cut3%q(i,3) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,4) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,11)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,12)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp3(p)			 		
    x3= cc/x4			 		
    cut3%q(i,5) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,6) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,13)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,14)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!				 		
    x4= cexp6(p)			 		
    x3= cc/x4			 		
    cut3%q(i,7) = q3caus+x3*tau31(p)*l3(i)+x4/tau31(p)*l4(i)   
    cut3%q(i,8) = q3caus-x3*tau31(p)*l3(i)-x4/tau31(p)*l4(i)   
    cut3%q(i,15)= q3caus+x4/tau32(p)*l3(i)+x3*tau32(p)*l4(i)   
    cut3%q(i,16)= q3caus-x4/tau32(p)*l3(i)-x3*tau32(p)*l4(i)   
!
    cut3%l1(i)= l1(i)
    cut3%l2(i)= l2(i)
    cut3%l3(i)= l3(i)
    cut3%l4(i)= l4(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,16
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i.or. &
         kk.eq.den2%i) then
      mp_vden(kk,i)= c0(p)
     else
      call load_vden(cut3%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine mp_cutting3  
!
  subroutine mp_cutting2(den0,den1,cut2)
   type(mp_real) :: p
   type(mp_propagator), intent(in) :: den0,den1
   type(mp_solcut2), intent(out) :: cut2
   type(mp_real), dimension(0:3) :: p0,p1,k1,v
   type(mp_real):: k1k1,factor
   type(mp_real):: m02,m12
   type(mp_real):: dd0,dd1
   integer :: k
   type(mp_complex) :: yv0,yvsigma,yvlambda,y3,y4
   type(mp_complex) :: al,al2,bet,gm,cf0,cflambda,cfsigma,q2caus
   type(mp_complex), dimension(0:3)  :: l1,l2,l3,l4
   p0= den0%p 
   p1= den1%p 
!
   m02= den0%m2-qt2 
   m12= den1%m2-qt2 
!
   do k= 0,3
    k1(k)= p1(k)-p0(k)
   enddo
!
   call contr(k1,k1,1,1,k1k1)
!
!  define the arbitrary massless 4-vector v
!
   factor= tau23r(p)
   v(0)= sign(factor         ,k1(0)+eps(p))
   v(1)=-sign(factor/root3(p),k1(1)+eps(p))
   v(2)=-sign(factor/root3(p),k1(2)+eps(p))
   v(3)=-sign(factor/root3(p),k1(3)+eps(p))
   call build_l(k1,v,l1,l2,l3,l4,al,al2,bet,gm)
   cut2%gm= gm
   cut2%rat1= (den0%m2+den1%m2-k1k1/3.d0) 
   dd0= m02
   dd1= m12-k1k1
!
   cf0     = -0.25d0/gm*(m02*c1(p))
   cflambda= -0.25d0/gm*(m02*c1(p)-lambda(p)*(dd1-dd0)*c1(p)+lambda(p)**2*k1k1)
   cut2%cflambda= cflambda
   cfsigma = -0.25d0/gm*(m02*c1(p)-sigma(p) *(dd1-dd0)*c1(p)+sigma(p)**2 *k1k1)
   cut2%cfsigma = cfsigma
!
   yv0     =  (dd1-dd0)*c1(p)/gm
   yvlambda= ((dd1-dd0)*c1(p)-2.d0*lambda(p)*k1k1*c1(p))/gm
   yvsigma = ((dd1-dd0)*c1(p)-2.d0*sigma(p) *k1k1*c1(p))/gm
!
!  the 18 solutions and the basis
! 
!   q( 1)= q_01^+
!   q( 2)= q_01^-
!   q( 3)= q_02^+
!   q( 4)= q_02^-
!   q( 5)= q_03^+
!   q( 6)= q_03^-
!   q( 7)= q'_01^+
!   q( 8)= q'_01^-
!   q( 9)= q'_02^+
!   q(10)= q'_02^-
!   q(11)= q'_03^+
!   q(12)= q'_03^-
!   q(13)= q_lambda_1^+
!   q(14)= q_lambda_1^-
!   q(15)= q_sigma_1^+
!   q(16)= q_sigma_1^-
!   q(17)= q_lambda_kappa^+
!   q(18)= q'_sigma_kappa^+
!
   do i= 0,3
    q2caus= -p0(i)*c1(p)+yv0*v(i)
    y3= cexp1(p)
    y4= cf0/y3
    cut2%q(i,1) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,2) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,7) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,8) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
 !
    y3= cexp2(p)
    y4= cf0/y3
    cut2%q(i,3)  = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,4)  = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,9)  = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,10) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
! 
    y3= cexp3(p)
    y4= cf0/y3
    cut2%q(i,5)  = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,6)  = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    cut2%q(i,11) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%q(i,12) = q2caus-y4*tau22(p)*l3(i)-y3/tau22(p)*l4(i)   
!
    q2caus= -p0(i)*c1(p)+lambda(p)*c1(p)*k1(i)+yvlambda*v(i)
    y3= cexp1(p)
    y4= cflambda/y3
    cut2%q(i,13) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,14) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    y3= cexpk(p)
    y4= cflambda/y3
    cut2%q(i,17) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
!
    q2caus= -p0(i)*c1(p)+sigma(p) *c1(p)*k1(i)+ yvsigma*v(i)
    y3= cexp1(p)
    y4= cfsigma /y3
    cut2%q(i,15) = q2caus+y3/tau21(p)*l3(i)+y4*tau21(p)*l4(i)   
    cut2%q(i,16) = q2caus-y3/tau21(p)*l3(i)-y4*tau21(p)*l4(i)   
    y3= cexpk(p)
    y4= cfsigma /y3
    cut2%q(i,18) = q2caus+y4*tau22(p)*l3(i)+y3/tau22(p)*l4(i)   
    cut2%l3(i)= l3(i)
    cut2%l4(i)= l4(i)
    cut2%k1(i)= k1(i)
    cut2%v(i) = v(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,18
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i.or. &
         kk.eq.den1%i) then
      mp_vden(kk,i)= c0(p)
     else
      call load_vden(cut2%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine mp_cutting2  
!
  subroutine mp_cutting1(den0,cut1)
   type(mp_real) :: p
   type(mp_propagator), intent(in) :: den0
   type(mp_solcut1), intent(out) :: cut1
   type(mp_real), dimension(0:3) :: p0,v,k
   type(mp_real):: m02
   type(mp_complex) :: al1,al2,bet,gm
   type(mp_complex) :: cf0
   type(mp_complex), dimension(0:3)  :: l1,l2,l3,l4
   logical :: computing=.true.
   save computing,v,k
   if (computing) then
     computing=.false.
!    define the arbitrary massless 4-vectors v and k
     v(0)= tau13r(p)
     v(1)= v(0)/root3(p)
     v(2)= v(0)/root3(p)
     v(3)= v(0)/root3(p)
!
     k(0)= tau14r(p)
     k(1)=-k(0)/root3(p)
     k(2)=-k(0)/root3(p)
     k(3)=-k(0)/root3(p)
   endif
!
   p0 = den0%p 
   m02= den0%m2-qt2 
   call build_l(v,k,l1,l2,l3,l4,al1,al2,bet,gm)
   cut1%gm= gm
! 
   cf0      = -0.25d0/gm*(m02*c1(p))
   cut1%cf0 = cf0
!
!  the 5 solutions and the basis
! 
!   q( 1)= q_0^+
!   q( 2)= q_0^-
!   q( 3)= q_1
!   q( 4)= q_2
!   q( 5)= q_3 
!
   do i= 0,3
    cut1%q(i,1) = -p0(i)+cf0*tau11(p)*l3(i)+l4(i)/tau11(p)
    cut1%q(i,2) = -p0(i)-cf0*tau11(p)*l3(i)-l4(i)/tau11(p)
    cut1%q(i,3) =  cut1%q(i,1)+v(i)
    cut1%q(i,4) =  cut1%q(i,1)+k(i)
    cut1%q(i,5) = -p0(i)+cexpk1(p)*tau12(p)*tau11(p)*l3(i) &
                   +cf0/cexpk1(p)*l4(i)/tau11(p)/tau12(p)
    cut1%v(i)   = v(i)
    cut1%k(i)   = k(i)
    cut1%l3(i)  = l3(i)
    cut1%l4(i)  = l4(i)
   enddo
!
!  computing all denominators at the solutions
! 
   do i= 1,5
    do j= 1,maxden
     kk= string(j)
     if (kk.eq.den0%i) then
      mp_vden(kk,i)= c0(p)
     else
      call load_vden(cut1%q(:,i),kk,i)
     endif 
    enddo
   enddo
  end subroutine mp_cutting1
 end module cuttings
!
 module coefficients
  use def_propagator                                       
  use def_mp_propagator                                       
  use def_solcut
  use def_mp_solcut
  use qt2value
  use combinatorics
  use numerators 
  use denominators
  use cuttings
  implicit none
!
! variables for the rational terms
!
  complex(kind(1.d0)), public :: rat1
  type(mp_complex), public :: mp_rat1
!
! variables for the 4-point sector
!
  complex(kind(1.d0)), dimension(0:1,dimension_d), public :: dcoeff
  complex(kind(1.d0)), dimension(0:1,dimension_d), private :: save_dcoeff
  complex(kind(1.d0)), dimension(0:3,dimension_d), public :: tvec,p0vec
  type(mp_complex), dimension(0:1,dimension_d), public :: mp_dcoeff
  type(mp_complex), dimension(0:1,dimension_d), private :: save_mp_dcoeff
  type(mp_complex), dimension(0:3,dimension_d), public :: mp_tvec,mp_p0vec
!
! variables for the 3-point sector
!
  complex(kind(1.d0)), dimension(0:6,dimension_c), public :: ccoeff
  complex(kind(1.d0)), dimension(0:6,dimension_c), private :: save_ccoeff
  complex(kind(1.d0)), dimension(0:3,dimension_c), public :: l3vec,l4vec    ! also for the 2,1-point sectors
  type(mp_complex), dimension(0:6,dimension_c), public :: mp_ccoeff
  type(mp_complex), dimension(0:6,dimension_c), private:: save_mp_ccoeff
  type(mp_complex), dimension(0:3,dimension_c), public :: mp_l3vec,mp_l4vec ! also for the 2,1-point sectors
!
! variables for the 2-point sector
!
  complex(kind(1.d0)), dimension(0:8,dimension_b), public :: bcoeff
  complex(kind(1.d0)), dimension(0:8,dimension_b), private :: save_bcoeff
  complex(kind(1.d0)), dimension(0:3,dimension_b), public :: vvec        ! also for the 1-point sector
  complex(kind(1.d0)), dimension(dimension_b), public :: vveck1,b_rat1
  type(mp_complex), dimension(0:8,dimension_b), public :: mp_bcoeff
  type(mp_complex), dimension(0:8,dimension_b), private :: save_mp_bcoeff
  type(mp_complex), dimension(0:3,dimension_b), public :: mp_vvec        ! also for the 1-point sector
  type(mp_complex), dimension(dimension_b), public :: mp_vveck1,mp_b_rat1
!
! variables for the 1-point sector
!
  complex(kind(1.d0)), dimension(0:4,dimension_a), public :: acoeff
  complex(kind(1.d0)), dimension(0:3,dimension_a), public :: kvec
  type(mp_complex), dimension(0:4,dimension_a), public :: mp_acoeff
  type(mp_complex), dimension(0:3,dimension_a), public :: mp_kvec
  save dcoeff,tvec,p0vec
  save ccoeff,l3vec,l4vec
  save bcoeff,vvec,vveck1,b_rat1
  save acoeff,kvec
  save mp_dcoeff,mp_tvec,mp_p0vec
  save mp_ccoeff,mp_l3vec,mp_l4vec
  save mp_bcoeff,mp_vvec,mp_vveck1,mp_b_rat1
  save mp_acoeff,mp_kvec
  save save_dcoeff,save_ccoeff,save_bcoeff
  save save_mp_dcoeff,save_mp_ccoeff,save_mp_bcoeff
!
  interface get_coefficients
    module procedure dp_get_coefficients
    module procedure mp_get_coefficients
  end interface!get_coefficients
!
  interface getd
    module procedure dp_getd
    module procedure mp_getd
  end interface!getd
!
  interface getc
    module procedure dp_getc
    module procedure mp_getc
  end interface!getc
!
  interface getb
    module procedure dp_getb
    module procedure mp_getb
  end interface!getb
!
  interface geta
    module procedure dp_geta
    module procedure mp_geta
  end interface!geta
!
  interface numd
    module procedure dp_numd
    module procedure mp_numd
  end interface!numd
!
  interface numc
    module procedure dp_numc
    module procedure mp_numc
  end interface!numc
!
  interface numb
    module procedure dp_numb
    module procedure mp_numb
  end interface!numb
!
  interface numa
    module procedure dp_numa
    module procedure mp_numa
  end interface!numa
!
  interface test
    module procedure dp_test
    module procedure mp_test
  end interface!test
!
  interface put_dcoeff
    module procedure dp_put_dcoeff
    module procedure mp_put_dcoeff
  end interface!put_dcoeff
!
  interface get_dcoeff
    module procedure dp_get_dcoeff
    module procedure mp_get_dcoeff
  end interface!get_dcoeff
!
  interface put_ccoeff
    module procedure dp_put_ccoeff
    module procedure mp_put_ccoeff
  end interface!put_ccoeff
!
  interface get_ccoeff
    module procedure dp_get_ccoeff
    module procedure mp_get_ccoeff
  end interface!get_ccoeff
!
  interface put_bcoeff
    module procedure dp_put_bcoeff
    module procedure mp_put_bcoeff
  end interface!put_bcoeff
!
  interface get_bcoeff
    module procedure dp_get_bcoeff
    module procedure mp_get_bcoeff
  end interface!get_bcoeff
  contains
!
  subroutine dp_get_coefficients(p,number_propagators,dmr,limit,q,ql,iflag)
   real(kind(1.d0)), intent(in) :: p
   real(kind(1.d0)), intent(in) :: limit
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   real(kind(1.d0)), intent(in) :: ql
   integer, intent(in) :: number_propagators,dmr
   integer, intent(out) :: iflag
   complex(kind(1.d0)), dimension(0:3) :: qdummy
   complex(kind(1.d0)) :: dummy1,dummy2
   real(kind(1.d0)) :: prec
   complex(kind(1.d0)) :: dsum0,dsum1,dsum2,dsum3,dsum4
   complex(kind(1.d0)) :: dsuminf,rec,qt2_inf,qt2_test
   complex(kind(1.d0)) :: csum0,csum1 
   complex(kind(1.d0)) :: bsum0,bsum1
   complex(kind(1.d0)) :: b_0,b_2,c_0,c_2,d_0,d_2,d_4,d_6,d_8,r1,r2,r3,r4
   complex(kind(1.d0)) :: aux,qt2_0,qt2_1,qt2_2,qt2_3,qt2_4
   real(kind(1.d0)), dimension(4:maxden) :: irat
   integer :: k,ib
   logical :: computing=.true.,inf=.false.
   save computing,inf,qt2_0,qt2_1,qt2_2,qt2_3,qt2_4,qt2_test,qt2_inf
   save qdummy,irat
   if (computing) then
    computing=.false.
    qt2_0=  0.d0
    qt2_1=  ql*ql
    qt2_2= -qt2_1
    qt2_3=  qt2_1*1.d2
    qt2_4= -qt2_3
    qt2_test=  qt2_1/3.14159265d0
    qt2_inf =  ql*ql*1.d9
    do k= 0,3; qdummy(k)= (0.d0,0.d0); enddo
    do k= 4,maxden
      irat(k)= -c1(p)/6.d0
    enddo
   endif
   iflag= 0
   qt2= qt2_0
   call getd(p,number_propagators,dmr)
   call getc(p,number_propagators,dmr)
   call getb(p,number_propagators,dmr)
   call geta(p,number_propagators,dmr)
   call test(p,number_propagators,q,dummy1,dummy2,prec)
   if (prec.gt.limit) then
    iflag= 1
    return
   endif
   b_0 = 0.d0; b_2 = 0.d0 
   c_0 = 0.d0; c_2 = 0.d0 
   d_0 = 0.d0; d_2 = 0.d0; d_4 = 0.d0; d_6 = 0.d0; d_8 = 0.d0 
   rat1= 0.d0
   if     (dmr.ge.2) then
    return
   endif  
   call put_dcoeff(p)
   call put_ccoeff(p)
   call put_bcoeff(p)
   if (dmr.eq.1) then
    if (number_propagators.ge.3) then
     call sumc(csum0,aux) 
     c_0= aux
     qt2= qt2_1
     if (number_propagators.ge.4) call getd(p,number_propagators,dmr)
     call getc(p,number_propagators,dmr)
     call sumc(csum1,aux) 
     c_2 =                (aux-c_0)/qt2
     rat1= rat1-0.5d0*(csum1-csum0)/qt2
    endif 
   elseif (dmr.eq.0) then
    if (number_propagators.ge.2) then
     call sumb(bsum0,aux) 
     b_0= aux
    endif
    if (number_propagators.ge.3) then
     call sumc(csum0,aux) 
     c_0= aux
    endif
    if (number_propagators.ge.4.and.(.not.inf)) call sumd(qdummy,dsum0) 
    qt2= qt2_1
    if (number_propagators.ge.4) call getd(p,number_propagators,dmr)
    if (number_propagators.ge.3) call getc(p,number_propagators,dmr)
    if (number_propagators.ge.2) call getb(p,number_propagators,dmr)
    if (number_propagators.ge.2) then
     call sumb(bsum1,aux) 
     b_2 =                (aux-b_0)/qt2
     rat1= rat1-0.5d0*(bsum1-bsum0)/qt2
    endif 
    if (number_propagators.ge.3) then
     call sumc(csum1,aux) 
     c_2 =                (aux-c_0)/qt2
     rat1= rat1-0.5d0*(csum1-csum0)/qt2
    endif
    if     (number_propagators.lt.4) then
    elseif (number_propagators.eq.4) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_4= dsuminf/qt2**2  
     else
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      d_0=  dsum0
      d_4= (dsum1+dsum2-2.d0*dsum0)/2.d0/qt2_1**2
      d_2= (dsum1-dsum2)/2.d0/qt2_1 
     endif
     rat1= rat1+d_4*irat(number_propagators)
    elseif (number_propagators.eq.5) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_6= dsuminf/qt2**3  
     else
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      qt2= qt2_3
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum3)
      d_0= dsum0
      d_4= (dsum2+dsum1-2.d0*dsum0)/2.d0/qt2_1**2
      r1 = (dsum1-dsum2)/2.d0/qt2_1
      r2 = (dsum3-dsum0-qt2_3**2*d_4)/qt2_3
      d_6= (r2-r1)/(qt2_3**2-qt2_1**2)
      d_2= r2-d_6*qt2_3**2 
     endif
     rat1= rat1+d_6*irat(number_propagators)
    elseif (number_propagators.eq.6) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_8= dsuminf/qt2**4  
     else 
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      qt2= qt2_3
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum3)
      qt2= qt2_4
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum4)
      d_0= dsum0
      r1= dsum1-dsum0
      r2= dsum2-dsum0
      r3= dsum3-dsum0
      r4= dsum4-dsum0
      aux= r1
      r1= (aux+r2)/2.d0/qt2_1**2
      r2= (aux-r2)/2.d0/qt2_1
      aux= r3
      r3= (aux+r4)/2.d0/qt2_3**2
      r4= (aux-r4)/2.d0/qt2_3
      aux= qt2_3**2-qt2_1**2
      d_8=  (r3-r1)/aux
      d_4= -(r3*qt2_1**2-r1*qt2_3**2)/aux 
      d_6=  (r4-r2)/aux
      d_2= -(r4*qt2_1**2-r2*qt2_3**2)/aux 
     endif
     rat1= rat1+d_8*irat(number_propagators)
    else 
      print*,'Rational terms for dmr= ',dmr, &
            ' and rank= ',rank,' Not implemented yet'
      stop
    endif
   else 
    print*,'Rational terms for dmr= ',dmr,' not implemented yet'
    stop
   endif
!
!  call test_rat to check the reconstructed qt2 dependence
!
!   call test_rat
   call get_dcoeff(p)
   call get_ccoeff(p)
   call get_bcoeff(p)
   qt2= qt2_0
   contains
!
   subroutine sumb(bsum,aux)
   complex(kind(1.d0)), intent(out) :: bsum,aux
   bsum= 0.d0 
   aux = 0.d0
   do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     bsum= bsum+bcoeff(0,ib)*b_rat1(ib)  
     aux = aux +bcoeff(0,ib)
   enddo
   end subroutine sumb 
!
   subroutine sumc(csum,aux)
   complex(kind(1.d0)), intent(out) :: csum,aux
   csum= 0.d0
   do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     csum= csum+ccoeff(0,ib)  
   enddo
   aux= csum
   end subroutine sumc 
!
   subroutine sumd(q,dsum)
   complex(kind(1.d0)), intent(out) :: dsum
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   dsum= numd(number_propagators,q,0)
   end subroutine sumd 
!
   subroutine test_rat 
   print*,'           '
   print*,' --- begin test on the reconstructed qt2 dependence ---'
   print*,'          '
   qt2= qt2_test
   call getd(p,number_propagators,dmr)
   call getc(p,number_propagators,dmr)
   call getb(p,number_propagators,dmr)
   call sumb(bsum0,aux)
   rec= b_0+qt2*b_2   
   print*,'aux_b=',aux
   print*,'rec_b=',rec
   print*,'      '
   call sumc(csum0,aux)
   rec= c_0+qt2*c_2   
   print*,'aux_c=',aux
   print*,'rec_c=',rec
   if (.not.inf) then
    print*,'      '
    call sumd(qdummy,aux)
    rec= d_0+d_2*(qt2)+d_4*(qt2)**2+d_6*(qt2)**3+d_8*(qt2)**4   
    print*,'aux_d=',aux
    print*,'rec_d=',rec
   endif
   print*,'           '
   print*,' d_4 =',d_4
   print*,' d_6 =',d_6
   print*,' d_8 =',d_8
   print*,'           '
   print*,' --- end   test on the reconstructed qt2 dependence ---'
   print*,'          '
   end subroutine test_rat
  end subroutine dp_get_coefficients
!
  subroutine mp_get_coefficients(p,number_propagators,dmr,limit,q,ql,iflag)
   type(mp_real), intent(in) :: p
   real(kind(1.d0)), intent(in) :: limit
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   real(kind(1.d0)), intent(in) :: ql
   integer, intent(in) :: number_propagators,dmr
   integer, intent(out) :: iflag
   type(mp_complex), dimension(0:3) :: qdummy
   type(mp_complex) :: dummy1,dummy2
   real(kind(1.d0)) :: prec
   type(mp_complex) :: dsum0,dsum1,dsum2,dsum3,dsum4
   type(mp_complex) :: dsuminf,rec,qt2_inf,qt2_test
   type(mp_complex) :: csum0,csum1 
   type(mp_complex) :: bsum0,bsum1
   type(mp_complex) :: b_0,b_2,c_0,c_2,d_0,d_2,d_4,d_6,d_8,r1,r2,r3,r4
   type(mp_complex) :: aux,qt2_0,qt2_1,qt2_2,qt2_3,qt2_4
   type(mp_real), dimension(4:maxden) :: irat
   integer :: k,ib
   logical :: computing=.true.,inf=.false.
   save computing,inf,qt2_0,qt2_1,qt2_2,qt2_3,qt2_4,qt2_test,qt2_inf
   save qdummy,irat
   if (computing) then
    computing=.false.
    qt2_0=  0.d0
    qt2_1=  ql*ql
    qt2_2= -qt2_1
    qt2_3=  qt2_1*1.d2
    qt2_4= -qt2_3
    qt2_test=  qt2_1/3.14159265d0
    qt2_inf =  ql*ql*1.d9
    do k= 0,3; qdummy(k)= (0.d0,0.d0); enddo
    do k= 4,maxden
      irat(k)= -c1(p)/6.d0
    enddo
   endif
   iflag= 0
   qt2= qt2_0
   call getd(p,number_propagators,dmr)
   call getc(p,number_propagators,dmr)
   call getb(p,number_propagators,dmr)
   call geta(p,number_propagators,dmr)
   call test(p,number_propagators,q,dummy1,dummy2,prec)
   if (prec.gt.limit) then
    iflag= 1
    return
   endif
   b_0 = 0.d0; b_2 = 0.d0 
   c_0 = 0.d0; c_2 = 0.d0 
   d_0 = 0.d0; d_2 = 0.d0; d_4 = 0.d0; d_6 = 0.d0; d_8 = 0.d0 
   mp_rat1= 0.d0
   if     (dmr.ge.2) then
    return
   endif  
   call put_dcoeff(p)
   call put_ccoeff(p)
   call put_bcoeff(p)
   if (dmr.eq.1) then
    if (number_propagators.ge.3) then
     call sumc(csum0,aux) 
     c_0= aux
     qt2= qt2_1
     if (number_propagators.ge.4) call getd(p,number_propagators,dmr)
     call getc(p,number_propagators,dmr)
     call sumc(csum1,aux) 
     c_2 =                (aux-c_0)/qt2
     mp_rat1= mp_rat1-0.5d0*(csum1-csum0)/qt2
    endif 
   elseif (dmr.eq.0) then
    if (number_propagators.ge.2) then
     call sumb(bsum0,aux) 
     b_0= aux
    endif
    if (number_propagators.ge.3) then
     call sumc(csum0,aux) 
     c_0= aux
    endif
    if (number_propagators.ge.4.and.(.not.inf)) call sumd(qdummy,dsum0) 
    qt2= qt2_1
    if (number_propagators.ge.4) call getd(p,number_propagators,dmr)
    if (number_propagators.ge.3) call getc(p,number_propagators,dmr)
    if (number_propagators.ge.2) call getb(p,number_propagators,dmr)
    if (number_propagators.ge.2) then
     call sumb(bsum1,aux) 
     b_2 =                (aux-b_0)/qt2
     mp_rat1= mp_rat1-0.5d0*(bsum1-bsum0)/qt2
    endif 
    if (number_propagators.ge.3) then
     call sumc(csum1,aux) 
     c_2 =                (aux-c_0)/qt2
     mp_rat1= mp_rat1-0.5d0*(csum1-csum0)/qt2
    endif
    if     (number_propagators.lt.4) then
    elseif (number_propagators.eq.4) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_4= dsuminf/qt2**2  
     else
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      d_0=  dsum0
      d_4= (dsum1+dsum2-2.d0*dsum0)/2.d0/qt2_1**2
      d_2= (dsum1-dsum2)/2.d0/qt2_1 
     endif
     mp_rat1= mp_rat1+d_4*irat(number_propagators)
    elseif (number_propagators.eq.5) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_6= dsuminf/qt2**3  
     else
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      qt2= qt2_3
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum3)
      d_0= dsum0
      d_4= (dsum2+dsum1-2.d0*dsum0)/2.d0/qt2_1**2
      r1 = (dsum1-dsum2)/2.d0/qt2_1
      r2 = (dsum3-dsum0-qt2_3**2*d_4)/qt2_3
      d_6= (r2-r1)/(qt2_3**2-qt2_1**2)
      d_2= r2-d_6*qt2_3**2 
     endif
     mp_rat1= mp_rat1+d_6*irat(number_propagators)
    elseif (number_propagators.eq.6) then
     if (inf) then   
      qt2= qt2_inf
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsuminf)
      d_8= dsuminf/qt2**4  
     else 
      call sumd(qdummy,dsum1) 
      qt2= qt2_2
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum2)
      qt2= qt2_3
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum3)
      qt2= qt2_4
      call getd(p,number_propagators,dmr)
      call sumd(qdummy,dsum4)
      d_0= dsum0
      r1= dsum1-dsum0
      r2= dsum2-dsum0
      r3= dsum3-dsum0
      r4= dsum4-dsum0
      aux= r1
      r1= (aux+r2)/2.d0/qt2_1**2
      r2= (aux-r2)/2.d0/qt2_1
      aux= r3
      r3= (aux+r4)/2.d0/qt2_3**2
      r4= (aux-r4)/2.d0/qt2_3
      aux= qt2_3**2-qt2_1**2
      d_8=  (r3-r1)/aux
      d_4= -(r3*qt2_1**2-r1*qt2_3**2)/aux 
      d_6=  (r4-r2)/aux
      d_2= -(r4*qt2_1**2-r2*qt2_3**2)/aux 
     endif
     mp_rat1= mp_rat1+d_8*irat(number_propagators)
    else 
      print*,'Rational terms for dmr= ',dmr, &
            ' and rank= ',rank,' Not implemented yet'
      stop
    endif
   else 
    print*,'Rational terms for dmr= ',dmr,' not implemented yet'
    stop
   endif
!
!  call test_rat to check the reconstructed qt2 dependence
!
!   call test_rat
   call get_dcoeff(p)
   call get_ccoeff(p)
   call get_bcoeff(p)
   qt2= qt2_0
   contains
!
   subroutine sumb(bsum,aux)
   type(mp_complex), intent(out) :: bsum,aux
   bsum= 0.d0 
   aux = 0.d0
   do k= 1,nbn2(number_propagators)
     ib= mbn2(number_propagators,k)
     bsum= bsum+mp_bcoeff(0,ib)*mp_b_rat1(ib)  
     aux = aux +mp_bcoeff(0,ib)
   enddo
   end subroutine sumb 
!
   subroutine sumc(csum,aux)
   type(mp_complex), intent(out) :: csum,aux
   csum= 0.d0
   do k= 1,nbn3(number_propagators)
     ib= mbn3(number_propagators,k)
     csum= csum+mp_ccoeff(0,ib)  
   enddo
   aux= csum
   end subroutine sumc 
!
   subroutine sumd(q,dsum)
   type(mp_complex), intent(out) :: dsum
   type(mp_complex), intent(in), dimension(0:3) :: q
   dsum= numd(number_propagators,q,0)
   end subroutine sumd 
!
   subroutine test_rat 
   complex(kind(1.d0)) :: aus1,aus2
   print*,'           '
   print*,' --- begin test on the reconstructed qt2 dependence ---'
   print*,'          '
   qt2= qt2_test
   call getd(p,number_propagators,dmr)
   call getc(p,number_propagators,dmr)
   call getb(p,number_propagators,dmr)
   call sumb(bsum0,aux)
   rec= b_0+qt2*b_2   
   aus1= aux
   aus2= rec
   print*,'aux_b=',aus1
   print*,'rec_b=',aus2
   print*,'      '
   call sumc(csum0,aux)
   rec= c_0+qt2*c_2   
   aus1= aux
   aus2= rec
   print*,'aux_c=',aus1
   print*,'rec_c=',aus2
   if (.not.inf) then
    print*,'      '
    call sumd(qdummy,aux)
    rec= d_0+d_2*(qt2)+d_4*(qt2)**2+d_6*(qt2)**3+d_8*(qt2)**4   
    aus1= aux
    aus2= rec
    print*,'aux_d=',aus1
    print*,'rec_d=',aus2
   endif
   print*,'           '
   aus1= d_4
   print*,' d_4 =',aus1
   aus1= d_6
   print*,' d_6 =',aus2
   aus1= d_8
   print*,' d_8 =',aus1
   print*,'           '
   print*,' --- end   test on the reconstructed qt2 dependence ---'
   print*,'          '
   end subroutine test_rat
  end subroutine mp_get_coefficients
!
  subroutine dp_put_dcoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dimension_d
    save_dcoeff(i,j)= dcoeff(i,j)
   enddo; enddo
  end subroutine dp_put_dcoeff
!
  subroutine dp_get_dcoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dimension_d
    dcoeff(i,j)= save_dcoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_dcoeff
!
  subroutine dp_put_ccoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dimension_c
    save_ccoeff(i,j)= ccoeff(i,j)
   enddo; enddo
  end subroutine dp_put_ccoeff
!
  subroutine dp_get_ccoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dimension_c
    ccoeff(i,j)= save_ccoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_ccoeff
!
  subroutine dp_put_bcoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dimension_b
    save_bcoeff(i,j)= bcoeff(i,j)
   enddo; enddo
  end subroutine dp_put_bcoeff
!
  subroutine dp_get_bcoeff(p)
   real(kind(1.d0)), intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dimension_b
    bcoeff(i,j)= save_bcoeff(i,j) 
   enddo; enddo
  end subroutine dp_get_bcoeff
!
  subroutine mp_put_dcoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dimension_d
    save_mp_dcoeff(i,j)= mp_dcoeff(i,j)
   enddo; enddo
  end subroutine mp_put_dcoeff
!
  subroutine mp_get_dcoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,1; do j= 1,dimension_d
    mp_dcoeff(i,j)= save_mp_dcoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_dcoeff
!
  subroutine mp_put_ccoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dimension_c
    save_mp_ccoeff(i,j)= mp_ccoeff(i,j)
   enddo; enddo
  end subroutine mp_put_ccoeff
!
  subroutine mp_get_ccoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,6; do j= 1,dimension_c
    mp_ccoeff(i,j)= save_mp_ccoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_ccoeff
!
  subroutine mp_put_bcoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dimension_b
    save_mp_bcoeff(i,j)= mp_bcoeff(i,j)
   enddo; enddo
  end subroutine mp_put_bcoeff
!
  subroutine mp_get_bcoeff(p)
   type(mp_real), intent(in) :: p
   integer :: i,j
   do i= 0,8; do j= 1,dimension_b
    mp_bcoeff(i,j)= save_mp_bcoeff(i,j) 
   enddo; enddo
  end subroutine mp_get_bcoeff
!
  subroutine dp_getd(p,number_propagators,dmr)
   real(kind(1.d0)), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(solcut4) :: cut4 
   integer :: i,ib,np,k
   complex(kind(1.d0)), dimension(0:3) :: qpp0
   complex(kind(1.d0)) :: tqpp0
   dcoeff= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   elseif (np.le.6) then
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     call cut(den(bn4(np,1,i)),den(bn4(np,2,i)),den(bn4(np,3,i)), &
              den(bn4(np,4,i)),cut4) 
     do k= 0,3
      tvec(k,ib) =  cut4%t(k)
      p0vec(k,ib)=  den(bn4(np,1,i))%p(k)
      qpp0(k)= cut4%q(k,1)+p0vec(k,ib)
     enddo
     call contr(tvec(:,ib),qpp0,1,1,tqpp0)
     dcoeff(0,ib)= 0.5d0*(fnum(1)+fnum(2))
     dcoeff(1,ib)= 0.5d0*(fnum(1)-fnum(2))/tqpp0
    enddo
   else
    print*,'In subroutine getd  '
    print*,'number_propagators =', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   real(kind(1.d0)) :: p
   complex(kind(1.d0)) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 5,np
    allden= allden*vden(den(bn4(np,k,i))%i,j)
   enddo
   fnum= num(cut4%q(:,j),qt2)/allden
   end function fnum
  end subroutine dp_getd 
!
  subroutine dp_getc(p,number_propagators,dmr)
   real(kind(1.d0)), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(solcut3) :: cut3 
   integer :: i,ib,np,k
   complex(kind(1.d0)) :: gm,cph,f1,f2,f3,f4, &
      f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16
   ccoeff= c0(p)
   np= number_propagators
   if (dmr.ge.4) return
   if     (np.lt.3) then
   elseif (np.le.6) then
    if     (dmr.eq.3) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3) 
      ccoeff(0,ib)= fnum(1)
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.2) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      ccoeff(0,ib)= 0.5d0*(f1+f2)
      gm= cut3%gm
      ccoeff(1,ib)= (f1-f2 +ci(p)*(f3 -f4 ))/(8.d0*gm)*tau31(p)
      ccoeff(2,ib)= (f9-f10+ci(p)*(f11-f12))/(8.d0*gm)*tau32(p)
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      ccoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm= cut3%gm
      ccoeff(1,ib)= (f1-f2 +ci(p)*(f3 -f4 ))/(8.d0*gm)*tau31(p)
      ccoeff(2,ib)= (f9-f10+ci(p)*(f11-f12))/(8.d0*gm)*tau32(p)
      cph= cexp3(p)**2
      ccoeff(3,ib)= (((f1+f2)-(f3+f4))*0.25d0     &
        -cph*((f5+f6)*0.5d0-ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
         /4.d0/gm/gm*tau31(p)**2
      ccoeff(4,ib)= (((f9+f10)-(f11+f12))*0.25d0  &
        -cph*((f13+f14)*0.5d0-ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
         /4.d0/gm/gm*tau32(p)**2
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(den(bn3(np,1,i)),den(bn3(np,2,i)),den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)      
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      f15= fnum(15)
      f16= fnum(16)
      ccoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm = cut3%gm
      cph= cexp3(p)**2
      ccoeff(1,ib)= ((f5-f6-f1+f2)*(c1(p)+cexp3(p))    &
                -ci(p)*(f7-f8+f3-f4)*(c1(p)+c1(p)/cexp3(p))) &
                /6.d0/(-2.d0*gm)*tau31(p)
      ccoeff(3,ib)= (((f1+f2)-(f3+f4))*0.25d0       &
        -cph*((f5+f6)*0.5d0-ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
        /4.d0/gm/gm*tau31(p)**2
      ccoeff(5,ib)=-(((f5-f6-f1+f2)*(c1(p)+c1(p)/cexp3(p)) &
        +ci(p)*(f7-f8+f3-f4)*(c1(p)+cexp3(p)))/6.d0  &
        +0.25d0*(f1-f2-ci(p)*(f3-f4)))/(-2.d0*gm)**3*tau31(p)**3
      ccoeff(2,ib)= ((f13-f14-f9+f10)*(c1(p)+cexp3(p)) &
                -ci(p)*(f15-f16+f11-f12)*(c1(p)+c1(p)/cexp3(p))) &
                /6.d0/(-2.d0*gm)*tau32(p)
      ccoeff(4,ib)= (((f9+f10)-(f11+f12))*0.25d0  &
        -cph*((f13+f14)*0.5d0-ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
        /4.d0/gm/gm*tau32(p)**2
      ccoeff(6,ib)=-(((f13-f14-f9+f10)*(c1(p)+c1(p)/cexp3(p)) &
                +ci(p)*(f15-f16+f11-f12)*(c1(p)+cexp3(p)))/6.d0  &
        +0.25d0*(f9-f10-ci(p)*(f11-f12)))/(-2.d0*gm)**3*tau32(p)**3
      do k= 0,3
       l3vec(k,ib) =  cut3%l3(k)
       l4vec(k,ib) =  cut3%l4(k)
       p0vec(k,ib) =  den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    else
     print*,'In subroutine getc '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine getc '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   real(kind(1.d0)) :: p
   complex(kind(1.d0)) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 4,np
    allden= allden*vden(den(bn3(np,k,i))%i,j)
   enddo
   fnum=  (num(cut3%q(:,j),qt2)                     &
          -numd(np,cut3%q(:,j),j))/allden
   end function fnum
  end subroutine dp_getc 
!
  subroutine dp_getb(p,number_propagators,dmr)
   real(kind(1.d0)), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(solcut2) :: cut2 
   integer :: i,ib,np,k
   complex(kind(1.d0)) :: gm,ulambda,usigma,zlambda,zsigma
   complex(kind(1.d0)) :: rden,caus1,caus2,caus3,cflambda,cfsigma
   complex(kind(1.d0)) :: f1,f2,f3,f4,f5,f6,f7,f8,f9,f10
   complex(kind(1.d0)) :: f11,f12,f13,f14,f15,f16,f17,f18
   bcoeff=  c0(p)
   np= number_propagators  
   if (dmr.ge.3) return
   if     (np.lt.2) then
   elseif (np.le.6) then
    if     (dmr.eq.2) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2) 
      bcoeff(0,ib)=  fnum(1)
      do k= 0,3 
       p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
       l3vec(k,ib)=  cut2%l3(k)
       l4vec(k,ib)=  cut2%l4(k)
       vvec(k,ib) =  cut2%v(k)
      enddo
      gm= cut2%gm
      vveck1(ib) =  gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)
      f4 = fnum(4)
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f13= fnum(13)
      bcoeff(0,ib)= 0.5d0*(f1+f2)
      gm= cut2%gm
      bcoeff(1,ib)= (f7-f8+ci(p)*(f9-f10))/(8.d0*gm)*tau22(p)
      bcoeff(2,ib)= (f1-f2+ci(p)*(f3-f4))/(8.d0*gm)*tau21(p)
      bcoeff(3,ib)= (f13-bcoeff(0,ib)-2.d0*gm*bcoeff(2,ib)/tau21(p)  &
                     -2.d0*gm*bcoeff(1,ib)*tau21(p)*cut2%cflambda)   &
                     *2.d0/gm/lambda(p)
      do k= 0,3 
       p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
       l3vec(k,ib)=  cut2%l3(k)
       l4vec(k,ib)=  cut2%l4(k)
       vvec(k,ib) =  cut2%v(k)
      enddo
      vveck1(ib) =  gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(den(bn2(np,1,i)),den(bn2(np,2,i)),cut2) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      f15= fnum(15)
      f16= fnum(16)
      f17= fnum(17)
      f18= fnum(18)
      bcoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm= cut2%gm
      cflambda= cut2%cflambda
      cfsigma = cut2%cfsigma
      bcoeff(1,ib)= (f7-f8+ci(p)*(f9-f10))/(8.d0*gm)*tau22(p)
      bcoeff(2,ib)= (f1-f2+ci(p)*(f3-f4))/(8.d0*gm)*tau21(p)
      bcoeff(4,ib)= (0.25d0*(f7+f8-f9-f10)                     &  
                     -cexpk(p)**2*((f11+f12)/2.d0-bcoeff(0,ib)))/ &
                     (c1(p)-c1(p)/cexpk(p)**2)/4.d0/gm**2*tau22(p)**2 
      bcoeff(5,ib)= (0.25d0*(f1+f2-f3-f4)                    &  
                     -cexpk(p)**2*((f5+f6)/2.d0-bcoeff(0,ib)))/ &
                     (c1(p)-c1(p)/cexpk(p)**2)/4.d0/gm**2*tau21(p)**2
      ulambda= 0.5d0*(f13+f14)                    &
              -bcoeff(0,ib)                       &
              -bcoeff(4,ib)*(2.d0*gm*cflambda*tau21(p))**2 &
              -bcoeff(5,ib)*(2.d0*gm/tau21(p))**2
      usigma = 0.5d0*(f15+f16)                    &
              -bcoeff(0,ib)                       &
              -bcoeff(4,ib)*(2.d0*gm*cfsigma*tau21(p))**2  &
              -bcoeff(5,ib)*(2.d0*gm/tau21(p))**2
      rden= lambda(p)*sigma(p)*(sigma(p)-lambda(p))
      bcoeff(3,ib) =    2.d0/gm*(ulambda*sigma(p)**2-usigma*lambda(p)**2)/rden
      bcoeff(6,ib) = 4.d0/gm**2*(usigma*lambda(p)-ulambda*sigma(p))      /rden
      caus1= -2.d0*gm*cflambda/cexpk(p)*tau21(p) 
      caus2= -2.d0*gm*cexpk(p)/tau21(p)
      caus3= 0.5d0*gm*lambda(p)
      zlambda= f17-bcoeff(0,ib)                             &
                  -bcoeff(1,ib)*caus1-bcoeff(4,ib)*caus1**2 &
                  -bcoeff(2,ib)*caus2-bcoeff(5,ib)*caus2**2 &
                  -bcoeff(3,ib)*caus3-bcoeff(6,ib)*caus3**2 
      caus1= -2.d0*gm*cexpk(p)/tau22(p)
      caus2= -2.d0*gm*cfsigma/cexpk(p)*tau22(p)
      caus3= 0.5d0*gm*sigma(p)
      zsigma=  f18-bcoeff(0,ib)                             &
                  -bcoeff(1,ib)*caus1-bcoeff(4,ib)*caus1**2 &
                  -bcoeff(2,ib)*caus2-bcoeff(5,ib)*caus2**2 &
                  -bcoeff(3,ib)*caus3-bcoeff(6,ib)*caus3**2 
      rden=-lambda(p)*sigma(p)*(cflambda*cfsigma*tau21(p)*tau22(p)    &
                         -cexpk(p)**4/tau21(p)/tau22(p))/(cexpk(p)/gm)**2
      bcoeff(7,ib)= (sigma(p) *zlambda*cfsigma*tau22(p)/cexpk(p)   &
                    -lambda(p)*zsigma *cexpk(p)/tau21(p))/rden
      bcoeff(8,ib)= (lambda(p)*zsigma *cflambda*tau21(p)/cexpk(p)  &
                     -sigma(p) *zlambda*cexpk(p)/tau22(p))/rden
      do k= 0,3 
       p0vec(k,ib)=  den(bn2(np,1,i))%p(k) 
       l3vec(k,ib)=  cut2%l3(k)
       l4vec(k,ib)=  cut2%l4(k)
       vvec(k,ib) =  cut2%v(k)
      enddo 
      vveck1(ib) =  gm/2.d0
      b_rat1(ib) = cut2%rat1
     enddo
    else
     print*,'In subroutine getb '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine getb '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   real(kind(1.d0)) :: p
   complex(kind(1.d0)) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 3,np
    allden= allden*vden(den(bn2(np,k,i))%i,j)
   enddo
   fnum =  (num(cut2%q(:,j),qt2)                       &
           -numd(number_propagators,cut2%q(:,j),j) &
           -numc(number_propagators,cut2%q(:,j),j))/allden
   end function fnum
  end subroutine dp_getb 
!
  subroutine dp_geta(p,number_propagators,dmr)
   real(kind(1.d0)), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(solcut1) :: cut1 
   integer :: i,ib,np,k
   complex(kind(1.d0)) :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   elseif (np.le.6) then
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1) 
      acoeff(0,ib)= fnum(1)
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vvec(k,ib) = cut1%v(k)
       kvec(k,ib)  = cut1%k(k)
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(den(bn1(np,1,i)),cut1) 
      f1= fnum(1)
      f2= fnum(2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      gm = cut1%gm
      cf0= cut1%cf0 
      acoeff(0,ib)=   0.5d0*(f1+f2)
      acoeff(1,ib)= 2.d0/gm*(f3-f1)
      acoeff(2,ib)= 2.d0/gm*(f4-f1)
      r1= -0.5d0*(f1-acoeff(0,ib))/gm
      r2= -0.5d0*(f5-acoeff(0,ib))/gm
      rden= cexpk1(p)*tau12(p)-cf0**2/cexpk1(p)/tau12(p)
      acoeff(3,ib)= (r1*cexpk1(p)*tau12(p)-cf0*r2)/rden*tau11(p)
      acoeff(4,ib)= (r2-cf0*r1/cexpk1(p)/tau12(p))/rden/tau11(p)
      do k= 0,3 
       p0vec(k,ib)= den(bn1(np,1,i))%p(k)
       l3vec(k,ib)= cut1%l3(k)
       l4vec(k,ib)= cut1%l4(k)
       vvec(k,ib) = cut1%v(k)
       kvec(k,ib)  = cut1%k(k)
      enddo
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   real(kind(1.d0)) :: p
   complex(kind(1.d0)) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*vden(den(bn1(np,k,i))%i,j)
   enddo
   fnum =  (num(cut1%q(:,j),qt2)                       &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine dp_geta 
!
  function dp_numd(number_propagators,q,j)
   real(kind(1.d0)) :: p
   integer, intent(in) :: number_propagators
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   complex(kind(1.d0)), dimension(0:3) :: qp0
   complex(kind(1.d0)) :: dp_numd,start,tqp0  
   complex(kind(1.d0)) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   elseif (np.le.6) then
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(tvec(:,ib),qp0,1,1,tqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 5,np
       allden= allden*value(den(bn4(np,k,i)),q) 
      enddo
     else
      do k= 5,np
       allden= allden*vden(den(bn4(np,k,i))%i,j)
      enddo
     endif
     start= start+(dcoeff(0,ib)+dcoeff(1,ib)*tqp0)&
           *allden
    enddo  
   else
    print*,'In function numd   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   dp_numd= start
  end function dp_numd
!
  function dp_numc(number_propagators,q,j)
   real(kind(1.d0)) :: p
   integer, intent(in) :: number_propagators
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   complex(kind(1.d0)), dimension(0:3) :: qp0
   complex(kind(1.d0)) :: l3qp0,l4qp0
   complex(kind(1.d0)) :: dp_numc,start
   complex(kind(1.d0)) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.3) then
   elseif (np.le.6) then
    do i= 1,nbn3(np)
     ib= mbn3(np,i)
     do k= 0,3 
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(l4vec(:,ib),qp0,1,1,l4qp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 4,np
       allden= allden*value(den(bn3(np,k,i)),q)
      enddo
     else
      do k= 4,np
       allden= allden*vden(den(bn3(np,k,i))%i,j)
      enddo
     endif
     start= start+(ccoeff(0,ib)               &
                  +ccoeff(1,ib)*l3qp0         &
                  +ccoeff(2,ib)*l4qp0         &
                  +ccoeff(3,ib)*l3qp0**2      &
                  +ccoeff(4,ib)*l4qp0**2      &
                  +ccoeff(5,ib)*l3qp0**3      &
                  +ccoeff(6,ib)*l4qp0**3)     &
                  *allden 
    enddo  
   else
    print*,'In function numc   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   dp_numc= start
  end function dp_numc
!
  function dp_numb(number_propagators,q,j)
   real(kind(1.d0)) :: p
   integer, intent(in) :: number_propagators
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   complex(kind(1.d0)), dimension(0:3) :: qp0
   complex(kind(1.d0)) :: l3qp0,l4qp0,vqp0
   complex(kind(1.d0)) :: dp_numb,start
   complex(kind(1.d0)) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.2) then
   elseif (np.le.6) then
    do i= 1,nbn2(np)
     ib= mbn2(np,i)
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(l4vec(:,ib),qp0,1,1,l4qp0)
     call contr(vvec(:,ib),qp0,1,1,vqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 3,np
       allden= allden*value(den(bn2(np,k,i)),q)
      enddo
     else
      do k= 3,np
       allden= allden*vden(den(bn2(np,k,i))%i,j)
      enddo
     endif
     start= start+(                        &
              bcoeff(0,ib)                 &
             +bcoeff(1,ib)*l3qp0           &
             +bcoeff(2,ib)*l4qp0           &
             +bcoeff(3,ib)*vqp0            &
             +bcoeff(4,ib)*(l3qp0)**2      &
             +bcoeff(5,ib)*(l4qp0)**2      &
             +bcoeff(6,ib)*vqp0**2         &
             +bcoeff(7,ib)*vqp0*l3qp0      &
             +bcoeff(8,ib)*vqp0*l4qp0)     &
             *allden
    enddo  
   else
    print*,'In function numb   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   dp_numb= start
  end function dp_numb
!
  function dp_numa(number_propagators,q,j)
   real(kind(1.d0)) :: p
   integer, intent(in) :: number_propagators
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   complex(kind(1.d0)), dimension(0:3) :: qp0
   complex(kind(1.d0)) :: l3qp0,l4qp0,vqp0,kqp0
   complex(kind(1.d0)) :: dp_numa,start
   complex(kind(1.d0)) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.1) then
    print*,'In function numa '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   elseif (np.le.6) then
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= q(k)+p0vec(k,ib) 
     enddo
     call contr(l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(l4vec(:,ib),qp0,1,1,l4qp0)
     call contr(vvec(:,ib),qp0,1,1,vqp0)
     call contr(kvec(:,ib),qp0,1,1,kqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 2,np
       allden= allden*value(den(bn1(np,k,i)),q)
      enddo
     else
      do k= 2,np
       allden= allden*vden(den(bn1(np,k,i))%i,j)
      enddo
     endif  
     start= start+(               &
              acoeff(0,ib)        & 
             +acoeff(1,ib)*kqp0   &
             +acoeff(2,ib)*vqp0   &
             +acoeff(3,ib)*l3qp0  &
             +acoeff(4,ib)*l4qp0) &
             *allden
    enddo  
   else
     print*,'In function numa   '
     print*,'number_propagators=', number_propagators,' not implemented'
     stop
   endif
   dp_numa= start
  end function dp_numa
!
  subroutine mp_getd(p,number_propagators,dmr)
   type(mp_real), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(mp_solcut4) :: cut4 
   integer :: i,ib,np,k
   type(mp_complex), dimension(0:3) :: qpp0
   type(mp_complex) :: tqpp0
   mp_dcoeff= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   elseif (np.le.6) then
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     call cut(mp_den(bn4(np,1,i)),mp_den(bn4(np,2,i)),mp_den(bn4(np,3,i)), &
              mp_den(bn4(np,4,i)),cut4) 
     do k= 0,3
      mp_tvec(k,ib) =  cut4%t(k)
      mp_p0vec(k,ib)=  mp_den(bn4(np,1,i))%p(k)
      qpp0(k)= cut4%q(k,1)+mp_p0vec(k,ib)
     enddo
     call contr(mp_tvec(:,ib),qpp0,1,1,tqpp0)
     mp_dcoeff(0,ib)= 0.5d0*(fnum(1)+fnum(2))
     mp_dcoeff(1,ib)= 0.5d0*(fnum(1)-fnum(2))/tqpp0
    enddo
   else
    print*,'In subroutine getd  '
    print*,'number_propagators =', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   type(mp_real) :: p
   type(mp_complex) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 5,np
    allden= allden*mp_vden(mp_den(bn4(np,k,i))%i,j)
   enddo
   fnum= num(cut4%q(:,j),qt2)/allden
   end function fnum
  end subroutine mp_getd 
!
  subroutine mp_getc(p,number_propagators,dmr)
   type(mp_real), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(mp_solcut3) :: cut3 
   integer :: i,ib,np,k
   type(mp_complex) :: gm,cph,f1,f2,f3,f4, &
      f5,f6,f7,f8,f9,f10,f11,f12,f13,f14,f15,f16
   mp_ccoeff= c0(p)
   np= number_propagators
   if (dmr.ge.4) return
   if     (np.lt.3) then
   elseif (np.le.6) then
    if     (dmr.eq.3) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3) 
      mp_ccoeff(0,ib)= fnum(1)
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.2) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      mp_ccoeff(0,ib)= 0.5d0*(f1+f2)
      gm= cut3%gm
      mp_ccoeff(1,ib)= (f1-f2 +ci(p)*(f3 -f4 ))/(8.d0*gm)*tau31(p)
      mp_ccoeff(2,ib)= (f9-f10+ci(p)*(f11-f12))/(8.d0*gm)*tau32(p)
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      mp_ccoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm= cut3%gm
      mp_ccoeff(1,ib)= (f1-f2 +ci(p)*(f3 -f4 ))/(8.d0*gm)*tau31(p)
      mp_ccoeff(2,ib)= (f9-f10+ci(p)*(f11-f12))/(8.d0*gm)*tau32(p)
      cph= cexp3(p)**2
      mp_ccoeff(3,ib)= (((f1+f2)-(f3+f4))*0.25d0     &
        -cph*((f5+f6)*0.5d0-mp_ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
         /4.d0/gm/gm*tau31(p)**2
      mp_ccoeff(4,ib)= (((f9+f10)-(f11+f12))*0.25d0  &
        -cph*((f13+f14)*0.5d0-mp_ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
         /4.d0/gm/gm*tau32(p)**2
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn3(np)
      ib= mbn3(np,i)
      call cut(mp_den(bn3(np,1,i)),mp_den(bn3(np,2,i)),mp_den(bn3(np,3,i)),cut3) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)      
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)      
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      f15= fnum(15)
      f16= fnum(16)
      mp_ccoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm = cut3%gm
      cph= cexp3(p)**2
      mp_ccoeff(1,ib)= ((f5-f6-f1+f2)*(c1(p)+cexp3(p))    &
                -ci(p)*(f7-f8+f3-f4)*(c1(p)+c1(p)/cexp3(p))) &
                /6.d0/(-2.d0*gm)*tau31(p)
      mp_ccoeff(3,ib)= (((f1+f2)-(f3+f4))*0.25d0       &
        -cph*((f5+f6)*0.5d0-mp_ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
        /4.d0/gm/gm*tau31(p)**2
      mp_ccoeff(5,ib)=-(((f5-f6-f1+f2)*(c1(p)+c1(p)/cexp3(p)) &
        +ci(p)*(f7-f8+f3-f4)*(c1(p)+cexp3(p)))/6.d0  &
        +0.25d0*(f1-f2-ci(p)*(f3-f4)))/(-2.d0*gm)**3*tau31(p)**3
      mp_ccoeff(2,ib)= ((f13-f14-f9+f10)*(c1(p)+cexp3(p)) &
                -ci(p)*(f15-f16+f11-f12)*(c1(p)+c1(p)/cexp3(p))) &
                /6.d0/(-2.d0*gm)*tau32(p)
      mp_ccoeff(4,ib)= (((f9+f10)-(f11+f12))*0.25d0  &
        -cph*((f13+f14)*0.5d0-mp_ccoeff(0,ib)))/(c1(p)-c1(p)/cph) &
        /4.d0/gm/gm*tau32(p)**2
      mp_ccoeff(6,ib)=-(((f13-f14-f9+f10)*(c1(p)+c1(p)/cexp3(p)) &
                +ci(p)*(f15-f16+f11-f12)*(c1(p)+cexp3(p)))/6.d0  &
        +0.25d0*(f9-f10-ci(p)*(f11-f12)))/(-2.d0*gm)**3*tau32(p)**3
      do k= 0,3
       mp_l3vec(k,ib) =  cut3%l3(k)
       mp_l4vec(k,ib) =  cut3%l4(k)
       mp_p0vec(k,ib) =  mp_den(bn3(np,1,i))%p(k) 
      enddo
     enddo
    else
     print*,'In subroutine getc '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine getc '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   type(mp_real) :: p
   type(mp_complex) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 4,np
    allden= allden*mp_vden(mp_den(bn3(np,k,i))%i,j)
   enddo
   fnum=  (num(cut3%q(:,j),qt2)                     &
          -numd(np,cut3%q(:,j),j))/allden
   end function fnum
  end subroutine mp_getc 
!
  subroutine mp_getb(p,number_propagators,dmr)
   type(mp_real), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(mp_solcut2) :: cut2 
   integer :: i,ib,np,k
   type(mp_complex) :: gm,ulambda,usigma,zlambda,zsigma
   type(mp_complex) :: rden,caus1,caus2,caus3,cflambda,cfsigma
   type(mp_complex) :: f1,f2,f3,f4,f5,f6,f7,f8,f9,f10
   type(mp_complex) :: f11,f12,f13,f14,f15,f16,f17,f18
   mp_bcoeff=  c0(p)
   np= number_propagators  
   if (dmr.ge.3) return
   if     (np.lt.2) then
   elseif (np.le.6) then
    if     (dmr.eq.2) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2) 
      mp_bcoeff(0,ib)=  fnum(1)
      do k= 0,3 
       mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
       mp_l3vec(k,ib)=  cut2%l3(k)
       mp_l4vec(k,ib)=  cut2%l4(k)
       mp_vvec(k,ib) =  cut2%v(k)
      enddo
      gm= cut2%gm
      mp_vveck1(ib) =  gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.1) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)
      f4 = fnum(4)
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f13= fnum(13)
      mp_bcoeff(0,ib)= 0.5d0*(f1+f2)
      gm= cut2%gm
      mp_bcoeff(1,ib)= (f7-f8+ci(p)*(f9-f10))/(8.d0*gm)*tau22(p)
      mp_bcoeff(2,ib)= (f1-f2+ci(p)*(f3-f4))/(8.d0*gm)*tau21(p)
      mp_bcoeff(3,ib)= (f13-mp_bcoeff(0,ib)-2.d0*gm*mp_bcoeff(2,ib)/tau21(p)  &
                     -2.d0*gm*mp_bcoeff(1,ib)*tau21(p)*cut2%cflambda)   &
                     *2.d0/gm/lambda(p)
      do k= 0,3 
       mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
       mp_l3vec(k,ib)=  cut2%l3(k)
       mp_l4vec(k,ib)=  cut2%l4(k)
       mp_vvec(k,ib) =  cut2%v(k)
      enddo
      mp_vveck1(ib) =  gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn2(np)
      ib= mbn2(np,i)
      call cut(mp_den(bn2(np,1,i)),mp_den(bn2(np,2,i)),cut2) 
      f1 = fnum(1)
      f2 = fnum(2)
      f3 = fnum(3)
      f4 = fnum(4)
      f5 = fnum(5)
      f6 = fnum(6)
      f7 = fnum(7)
      f8 = fnum(8)
      f9 = fnum(9)
      f10= fnum(10)
      f11= fnum(11)
      f12= fnum(12)
      f13= fnum(13)
      f14= fnum(14)
      f15= fnum(15)
      f16= fnum(16)
      f17= fnum(17)
      f18= fnum(18)
      mp_bcoeff(0,ib)= 0.25d0*(f1+f2+f3+f4)
      gm= cut2%gm
      cflambda= cut2%cflambda
      cfsigma = cut2%cfsigma
      mp_bcoeff(1,ib)= (f7-f8+ci(p)*(f9-f10))/(8.d0*gm)*tau22(p)
      mp_bcoeff(2,ib)= (f1-f2+ci(p)*(f3-f4))/(8.d0*gm)*tau21(p)
      mp_bcoeff(4,ib)= (0.25d0*(f7+f8-f9-f10)                     &  
                     -cexpk(p)**2*((f11+f12)/2.d0-mp_bcoeff(0,ib)))/ &
                     (c1(p)-c1(p)/cexpk(p)**2)/4.d0/gm**2*tau22(p)**2 
      mp_bcoeff(5,ib)= (0.25d0*(f1+f2-f3-f4)                    &  
                     -cexpk(p)**2*((f5+f6)/2.d0-mp_bcoeff(0,ib)))/ &
                     (c1(p)-c1(p)/cexpk(p)**2)/4.d0/gm**2*tau21(p)**2
      ulambda= 0.5d0*(f13+f14)                    &
              -mp_bcoeff(0,ib)                       &
              -mp_bcoeff(4,ib)*(2.d0*gm*cflambda*tau21(p))**2 &
              -mp_bcoeff(5,ib)*(2.d0*gm/tau21(p))**2
      usigma = 0.5d0*(f15+f16)                    &
              -mp_bcoeff(0,ib)                       &
              -mp_bcoeff(4,ib)*(2.d0*gm*cfsigma*tau21(p))**2  &
              -mp_bcoeff(5,ib)*(2.d0*gm/tau21(p))**2
      rden= lambda(p)*sigma(p)*(sigma(p)-lambda(p))
      mp_bcoeff(3,ib) =    2.d0/gm*(ulambda*sigma(p)**2-usigma*lambda(p)**2)/rden
      mp_bcoeff(6,ib) = 4.d0/gm**2*(usigma*lambda(p)-ulambda*sigma(p))      /rden
      caus1= -2.d0*gm*cflambda/cexpk(p)*tau21(p) 
      caus2= -2.d0*gm*cexpk(p)/tau21(p)
      caus3= 0.5d0*gm*lambda(p)
      zlambda= f17-mp_bcoeff(0,ib)                             &
                  -mp_bcoeff(1,ib)*caus1-mp_bcoeff(4,ib)*caus1**2 &
                  -mp_bcoeff(2,ib)*caus2-mp_bcoeff(5,ib)*caus2**2 &
                  -mp_bcoeff(3,ib)*caus3-mp_bcoeff(6,ib)*caus3**2 
      caus1= -2.d0*gm*cexpk(p)/tau22(p)
      caus2= -2.d0*gm*cfsigma/cexpk(p)*tau22(p)
      caus3= 0.5d0*gm*sigma(p)
      zsigma=  f18-mp_bcoeff(0,ib)                             &
                  -mp_bcoeff(1,ib)*caus1-mp_bcoeff(4,ib)*caus1**2 &
                  -mp_bcoeff(2,ib)*caus2-mp_bcoeff(5,ib)*caus2**2 &
                  -mp_bcoeff(3,ib)*caus3-mp_bcoeff(6,ib)*caus3**2 
      rden=-lambda(p)*sigma(p)*(cflambda*cfsigma*tau21(p)*tau22(p)    &
                         -cexpk(p)**4/tau21(p)/tau22(p))/(cexpk(p)/gm)**2
      mp_bcoeff(7,ib)= (sigma(p) *zlambda*cfsigma*tau22(p)/cexpk(p)   &
                    -lambda(p)*zsigma *cexpk(p)/tau21(p))/rden
      mp_bcoeff(8,ib)= (lambda(p)*zsigma *cflambda*tau21(p)/cexpk(p)  &
                     -sigma(p) *zlambda*cexpk(p)/tau22(p))/rden
      do k= 0,3 
       mp_p0vec(k,ib)=  mp_den(bn2(np,1,i))%p(k) 
       mp_l3vec(k,ib)=  cut2%l3(k)
       mp_l4vec(k,ib)=  cut2%l4(k)
       mp_vvec(k,ib) =  cut2%v(k)
      enddo 
      mp_vveck1(ib) =  gm/2.d0
      mp_b_rat1(ib) = cut2%rat1
     enddo
    else
     print*,'In subroutine getb '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine getb '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   type(mp_real) :: p
   type(mp_complex) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 3,np
    allden= allden*mp_vden(mp_den(bn2(np,k,i))%i,j)
   enddo
   fnum =  (num(cut2%q(:,j),qt2)                       &
           -numd(number_propagators,cut2%q(:,j),j) &
           -numc(number_propagators,cut2%q(:,j),j))/allden
   end function fnum
  end subroutine mp_getb 
!
  subroutine mp_geta(p,number_propagators,dmr)
   type(mp_real), intent(in) :: p
   integer, intent(in) :: number_propagators,dmr
   type(mp_solcut1) :: cut1 
   integer :: i,ib,np,k
   type(mp_complex) :: gm,cf0,r1,r2,rden,f1,f2,f3,f4,f5
   mp_acoeff= c0(p)
   np= number_propagators
   if (dmr.ge.2) return
   if     (np.lt.1) then
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   elseif (np.le.6) then
    if     (dmr.eq.1) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1) 
      mp_acoeff(0,ib)= fnum(1)
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vvec(k,ib) = cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    elseif (dmr.eq.0) then
     do i= 1,nbn1(np)
      ib= mbn1(np,i)
      call cut(mp_den(bn1(np,1,i)),cut1) 
      f1= fnum(1)
      f2= fnum(2)
      f3= fnum(3)
      f4= fnum(4)
      f5= fnum(5)
      gm = cut1%gm
      cf0= cut1%cf0 
      mp_acoeff(0,ib)=   0.5d0*(f1+f2)
      mp_acoeff(1,ib)= 2.d0/gm*(f3-f1)
      mp_acoeff(2,ib)= 2.d0/gm*(f4-f1)
      r1= -0.5d0*(f1-mp_acoeff(0,ib))/gm
      r2= -0.5d0*(f5-mp_acoeff(0,ib))/gm
      rden= cexpk1(p)*tau12(p)-cf0**2/cexpk1(p)/tau12(p)
      mp_acoeff(3,ib)= (r1*cexpk1(p)*tau12(p)-cf0*r2)/rden*tau11(p)
      mp_acoeff(4,ib)= (r2-cf0*r1/cexpk1(p)/tau12(p))/rden/tau11(p)
      do k= 0,3 
       mp_p0vec(k,ib)= mp_den(bn1(np,1,i))%p(k)
       mp_l3vec(k,ib)= cut1%l3(k)
       mp_l4vec(k,ib)= cut1%l4(k)
       mp_vvec(k,ib) = cut1%v(k)
       mp_kvec(k,ib) = cut1%k(k)
      enddo
     enddo
    else
     print*,'In subroutine geta '
     print*,'dmr=',dmr,' not allowed'
     stop
    endif
   else
    print*,'In subroutine geta '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   contains
!
   function fnum(j)
   type(mp_real) :: p
   type(mp_complex) :: fnum,allden
   integer, intent(in) :: j
   integer :: k
   allden= c1(p) 
   do k= 2,np
    allden= allden*mp_vden(mp_den(bn1(np,k,i))%i,j)
   enddo
   fnum =  (num(cut1%q(:,j),qt2)                       &
           -numd(number_propagators,cut1%q(:,j),j) &
           -numc(number_propagators,cut1%q(:,j),j) &
           -numb(number_propagators,cut1%q(:,j),j))/allden
   end function fnum
  end subroutine mp_geta 
!
  function mp_numd(number_propagators,q,j)
   type(mp_real) :: p
   integer, intent(in) :: number_propagators
   type(mp_complex), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   type(mp_complex), dimension(0:3) :: qp0
   type(mp_complex) :: mp_numd,start,tqp0  
   type(mp_complex) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.4) then
   elseif (np.le.6) then
    do i= 1,nbn4(np)
     ib= mbn4(np,i)
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_tvec(:,ib),qp0,1,1,tqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 5,np
       allden= allden*value(mp_den(bn4(np,k,i)),q) 
      enddo
     else
      do k= 5,np
       allden= allden*mp_vden(mp_den(bn4(np,k,i))%i,j)
      enddo
     endif
     start= start+(mp_dcoeff(0,ib)+mp_dcoeff(1,ib)*tqp0)&
           *allden
    enddo  
   else
    print*,'In function numd   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   mp_numd= start
  end function mp_numd
!
  function mp_numc(number_propagators,q,j)
   type(mp_real) :: p
   integer, intent(in) :: number_propagators
   type(mp_complex), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   type(mp_complex), dimension(0:3) :: qp0
   type(mp_complex) :: l3qp0,l4qp0
   type(mp_complex) :: mp_numc,start
   type(mp_complex) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.3) then
   elseif (np.le.6) then
    do i= 1,nbn3(np)
     ib= mbn3(np,i)
     do k= 0,3 
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,1,1,l4qp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 4,np
       allden= allden*value(mp_den(bn3(np,k,i)),q)
      enddo
     else
      do k= 4,np
       allden= allden*mp_vden(mp_den(bn3(np,k,i))%i,j)
      enddo
     endif
     start= start+(mp_ccoeff(0,ib)               &
                  +mp_ccoeff(1,ib)*l3qp0         &
                  +mp_ccoeff(2,ib)*l4qp0         &
                  +mp_ccoeff(3,ib)*l3qp0**2      &
                  +mp_ccoeff(4,ib)*l4qp0**2      &
                  +mp_ccoeff(5,ib)*l3qp0**3      &
                  +mp_ccoeff(6,ib)*l4qp0**3)     &
                  *allden 
    enddo  
   else
    print*,'In function numc   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   mp_numc= start
  end function mp_numc
!
  function mp_numb(number_propagators,q,j)
   type(mp_real) :: p
   integer, intent(in) :: number_propagators
   type(mp_complex), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   type(mp_complex), dimension(0:3) :: qp0
   type(mp_complex) :: l3qp0,l4qp0,vqp0
   type(mp_complex) :: mp_numb,start
   type(mp_complex) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.2) then
   elseif (np.le.6) then
    do i= 1,nbn2(np)
     ib= mbn2(np,i)
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,1,1,l4qp0)
     call contr(mp_vvec(:,ib),qp0,1,1,vqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 3,np
       allden= allden*value(mp_den(bn2(np,k,i)),q)
      enddo
     else
      do k= 3,np
       allden= allden*mp_vden(mp_den(bn2(np,k,i))%i,j)
      enddo
     endif
     start= start+(                           &
              mp_bcoeff(0,ib)                 &
             +mp_bcoeff(1,ib)*l3qp0           &
             +mp_bcoeff(2,ib)*l4qp0           &
             +mp_bcoeff(3,ib)*vqp0            &
             +mp_bcoeff(4,ib)*(l3qp0)**2      &
             +mp_bcoeff(5,ib)*(l4qp0)**2      &
             +mp_bcoeff(6,ib)*vqp0**2         &
             +mp_bcoeff(7,ib)*vqp0*l3qp0      &
             +mp_bcoeff(8,ib)*vqp0*l4qp0)     &
             *allden
    enddo  
   else
    print*,'In function numb   '
    print*,'number_propagators=', number_propagators,' not implemented'
    stop
   endif
   mp_numb= start
  end function mp_numb
!
  function mp_numa(number_propagators,q,j)
   type(mp_real) :: p
   integer, intent(in) :: number_propagators
   type(mp_complex), intent(in), dimension(0:3) :: q
   integer, intent(in) :: j
   integer :: i,ib,k,np
   type(mp_complex), dimension(0:3) :: qp0
   type(mp_complex) :: l3qp0,l4qp0,vqp0,kqp0
   type(mp_complex) :: mp_numa,start
   type(mp_complex) :: allden
   start= c0(p)
   np= number_propagators
   if     (np.lt.1) then
    print*,'In function numa '
    print*,'number_propagators=', number_propagators,' not allowed'
    stop
   elseif (np.le.6) then
    do i= 1,nbn1(np)
     ib= mbn1(np,i)
     do k= 0,3
      qp0(k)= q(k)+mp_p0vec(k,ib) 
     enddo
     call contr(mp_l3vec(:,ib),qp0,1,1,l3qp0)
     call contr(mp_l4vec(:,ib),qp0,1,1,l4qp0)
     call contr(mp_vvec(:,ib),qp0,1,1,vqp0)
     call contr(mp_kvec(:,ib),qp0,1,1,kqp0)
     allden= c1(p)
     if (j.eq.0) then
      do k= 2,np
       allden= allden*value(mp_den(bn1(np,k,i)),q)
      enddo
     else
      do k= 2,np
       allden= allden*mp_vden(mp_den(bn1(np,k,i))%i,j)
      enddo
     endif  
     start= start+(               &
              mp_acoeff(0,ib)        & 
             +mp_acoeff(1,ib)*kqp0   &
             +mp_acoeff(2,ib)*vqp0   &
             +mp_acoeff(3,ib)*l3qp0  &
             +mp_acoeff(4,ib)*l4qp0) &
             *allden
    enddo  
   else
     print*,'In function numa   '
     print*,'number_propagators=', number_propagators,' not implemented'
     stop
   endif
   mp_numa= start
  end function mp_numa
!
  subroutine qvalue(qmax,q)
!
!  A generic value of q to perform the test N(q) = N(q)
!
   real(kind(1.d0)), intent(in) :: qmax
   complex(kind(1.d0)), intent(out), dimension(0:3) :: q
   real(kind(1.d0)) :: p,ran0r,ran0i,ran1r,ran1i,ran2r,ran2i,ran3r,ran3i
   real(kind(1.d0)) :: q0r,q0i,q1r,q1i,q2r,q2i,q3r,q3i
   call rans(ran0r)
   call rans(ran0i)
   call rans(ran1r)
   call rans(ran1i)
   call rans(ran2r)
   call rans(ran2i)
   call rans(ran3r)
   call rans(ran3i)
   q0r= (2.d0*ran0r-1.d0)*qmax
   q0i= (2.d0*ran0i-1.d0)*qmax
   q1r= (2.d0*ran1r-1.d0)*qmax
   q1i= (2.d0*ran1i-1.d0)*qmax
   q2r= (2.d0*ran2r-1.d0)*qmax
   q2i= (2.d0*ran2i-1.d0)*qmax
   q3r= (2.d0*ran3r-1.d0)*qmax
   q3i= (2.d0*ran3i-1.d0)*qmax
   q(0)= q0r*c1(p)+q0i*ci(p)
   q(1)= q1r*c1(p)+q1i*ci(p)
   q(2)= q2r*c1(p)+q2i*ci(p)
   q(3)= q3r*c1(p)+q3i*ci(p)
  end subroutine qvalue
!
  subroutine dp_test(p,number_propagators,q,numerator,numrec,prec)
   real(kind(1.d0)), intent(in) :: p
   integer, intent(in) :: number_propagators
!
!  Routine to perform the test N(q) = N(q)
!
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   complex(kind(1.d0)) :: numerator, num_d, num_c, num_b, num_a, numrec
   real(kind(1.d0)) :: prec,precr,preci
   intent(out) :: numerator,numrec,prec
   numerator= num(q,qt2)
   num_d= numd(number_propagators,q,0)
   num_c= numc(number_propagators,q,0)
   num_b= numb(number_propagators,q,0)
   num_a= numa(number_propagators,q,0)
   numrec= num_d+num_c+num_b+num_a
   precr = dabs(dreal(numerator-numrec))/abs(numerator)
   preci = dabs(dimag(numerator-numrec))/abs(numerator)
   prec= max(precr,preci)
  end subroutine dp_test
!
  subroutine mp_test(p,number_propagators,q,numerator,numrec,prec)
   type(mp_real), intent(in) :: p 
   integer, intent(in) :: number_propagators
!
!  Routine to perform the test N(q) = N(q)
!
   complex(kind(1.d0)), intent(in), dimension(0:3) :: q
   type(mp_complex), dimension(0:3) :: mp_q
   type(mp_complex) :: numerator, num_d, num_c, num_b, num_a, numrec
   type(mp_complex) :: diff,realpart,imagpart
   real(kind(1.d0)) :: prec,precr,preci
   integer :: k
   intent(out) :: numerator,numrec,prec
   do k= 0,3;  mp_q(k) = q(k); enddo
   numerator= num(mp_q,qt2)
   num_d= numd(number_propagators,mp_q,0)
   num_c= numc(number_propagators,mp_q,0)
   num_b= numb(number_propagators,mp_q,0)
   num_a= numa(number_propagators,mp_q,0)
   numrec= num_d+num_c+num_b+num_a
   diff= numerator-numrec
   realpart= (diff+conjg(diff))/2.d0  
   imagpart= (diff-conjg(diff))/(2.d0*ci(p))  
   precr = abs(realpart)/abs(numerator)
   preci = abs(imagpart)/abs(numerator)
   prec= max(precr,preci)
  end subroutine mp_test
 end module coefficients
 






 
