 program main 
  use mpmodule
  use def_propagator
  use def_mp_propagator
  use coefficients
  use numerators
!
  implicit none                             
!
!  Variables for the bookeeping and histogrammimg routines
!
  integer, parameter :: nx= 25
  integer, dimension(nx) :: iinit= 0
  real(kind(1.d0)) :: ss1(nx),ss2(nx)
  integer :: nout
  common/printout/nout
!
  complex(kind(1.d0)), dimension(0:2) :: corr,cutpart
  type(mp_complex) , dimension(0:2) :: mp_cutpart
  complex(kind(1.d0)), dimension(0:2) :: w0r,w1r,w2r,w0i,w1i,w2i
  real(kind(1.d0)), dimension(0:3) :: k1,k2,k3,k4,k5,k6
  real(kind(1.d0)) :: roots,zm,qmax
  complex(kind(1.d0)), dimension(0:3) :: q
!
  real(kind(1.d0)) :: dbl_prec,per_mp,per_disc,limit
  type (mp_real)   :: mlt_prec
  complex(kind(1.d0)) :: aux
  integer :: number_propagators,dmr,np,niter,nitermax,nev,iflag
  real(kind(1.d0)) :: dj,ran0,prec
  real(kind(1.d0)), dimension(0:3,3:5) :: kk
  real(kind(1.d0)), dimension(0:3) :: p0,p1,p2,p3,p4,p5
  real(kind(1.d0)), dimension(0:3) :: pp1,pp2,pp3,pp4,pp5
  complex(kind(1.d0)) :: numerator, numrec
  type (mp_complex) :: mp_numerator, mp_numrec
  real(kind(1.d0)) :: m02,m12,m22,m32,m42,m52
  integer :: k,l1,n_mp,n_disc,idig,idig1,j
  type(propagator)    :: den0,den1,den2,den3,den4,den5
  type(mp_propagator) :: mp_den0,mp_den1,mp_den2,mp_den3,mp_den4,mp_den5 
!
! Initializations: 
!
  nout= 6 
  idig= 64              ! max n. of digits for the mp routines 
  call mpinit(idig)     ! set the max    n. of digits for the mp routines
  call mpsetprec (idig) ! set the actual n. of digits for the mp routines
  call mpsetoutputprec(idig) ! set the max n. of digits mp output (if called)
!
! Initialization of the scalar integrals:
!
  call avh_olo_mu_set(1.d0)
  call load_combinatorics    ! initialize the combinatorics
  number_propagators= 5 
  rank              = 4
  dmr               =  number_propagators-rank
  n_mp  = 0 ! counter of the mp        points
  n_disc= 0 ! counter of the discarded points (if any...)
  limit = 1.d-5 ! limit of precision below which the mp routines activate
!
! Center of mass energy and phase-space paramenters
!
  roots= 1000.d0
  zm   = 91.1875d0
!
  print*,'enter nitermax' ! maximum number of iterations
  read*,nitermax
  nev= 0
  do niter= 1,nitermax
!
   call momenta(roots,zm) ! generate a phase-space point   
!
!  Check on the PS point
!
!   pint*,'m3=',sqrt(k3(0)**2-k3(1)**2-k3(2)**2-k3(3)**2)
!   print*,'m4=',sqrt(k4(0)**2-k4(1)**2-k4(2)**2-k4(3)**2)
!   print*,'m5=',sqrt(k5(0)**2-k5(1)**2-k5(2)**2-k5(3)**2)
!   print*,'O0=',k1(0)+k2(0)-k3(0)-k4(0)-k5(0)
!   print*,'O1=',k1(1)+k2(1)-k3(1)-k4(1)-k5(1)
!   print*,'O2=',k1(2)+k2(2)-k3(2)-k4(2)-k5(2)
!   print*,'O3=',k1(3)+k2(3)-k3(3)-k4(3)-k5(3)
!
   corr(0)   = 0.d0
   corr(1)   = 0.d0
   corr(2)   = 0.d0
   nev= nev+1
!
   pp1= k1
   pp2= k2
   pp3= -k3
   pp4= -k4
   pp5= -k5
!
   cp1= pp1*c1(dbl_prec)
   cp2= pp2*c1(dbl_prec)
   cp3= pp3*c1(dbl_prec)
   cp4= pp4*c1(dbl_prec)
   cp5= pp5*c1(dbl_prec)
!
   p0= 0.d0 
   p1= pp1
   p2= pp1+pp5
   p3= pp1+pp5+pp4
   p4= -pp2
!
   m02= 0.d0 
   m12= 0.d0
   m22= 0.d0
   m32= 0.d0
   m42= 0.d0
!
   qmax= roots
   call qvalue(qmax,q) ! a random value of q for the N=N test
!
!!!!!!!!!!!!!!!!!!!!!!!!
!                      !
!   Double Precision   !
!                      !
!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Define the propagators
!
   den0%p= p0; den0%m2= m02
   den1%p= p1; den1%m2= m12
   den2%p= p2; den2%m2= m22
   den3%p= p3; den3%m2= m32
   den4%p= p4; den4%m2= m42
!
!   Load the propagators
!
   call load_denominators(den0,den1,den2,den3,den4)
!
!   Get the coefficients
!
   call get_coefficients(dbl_prec,number_propagators,dmr,limit,q,qmax,iflag)
   if     (iflag.eq.0) then
      call dp_result(dbl_prec,cutpart)
      corr(0)= corr(0)+cutpart(0)+rat1 
!!!!                             rat2 should be added by hand !!!!
      corr(1)= corr(1)+cutpart(1)
      corr(2)= corr(2)+cutpart(2)
      goto 5
   elseif (iflag.eq.1) then
      n_mp= n_mp+1
   else
      print*,'error'
      stop
   endif
! 
!!!!!!!!!!!!!!!!!!!!!!!!
!                      !
!  Multiple precision  !
!                      !
!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Define the propagators
!
    do k= 0,3; mp_den0%p(k)= p0(k); enddo; mp_den0%m2= m02
    do k= 0,3; mp_den1%p(k)= p1(k); enddo; mp_den1%m2= m12
    do k= 0,3; mp_den2%p(k)= p2(k); enddo; mp_den2%m2= m22
    do k= 0,3; mp_den3%p(k)= p3(k); enddo; mp_den3%m2= m32
    do k= 0,3; mp_den4%p(k)= p4(k); enddo; mp_den4%m2= m42    
!
!   Load the propagators
!
    call load_denominators(mp_den0,mp_den1,mp_den2,mp_den3,mp_den4)
!
!   Get the coefficients
!
    call get_coefficients(mlt_prec,number_propagators,dmr,limit,q,qmax,iflag)
    if     (iflag.eq.0) then
       call mp_result(mlt_prec,mp_cutpart)
       corr(0)= corr(0)+mp_cutpart(0)+mp_rat1
!!!!                               rat2 should be added by hand  !!!!
       corr(1)= corr(1)+mp_cutpart(1)
       corr(2)= corr(2)+mp_cutpart(2)
       goto 5
    elseif (iflag.eq.1) then
       n_disc= n_disc+1
       goto 6
    else
       print*,'error'
       stop
    endif
5   continue
    w0r= dreal(corr(0))
    w0i= dimag(corr(0))
    w1r= dreal(corr(1))
    w1i= dimag(corr(1))
    w2r= dreal(corr(2))
    w2i= dimag(corr(2))
    call inbook(1,w0r,iinit)
    call inbook(2,w0i,iinit)
    call inbook(3,w1r,iinit)
    call inbook(4,w1i,iinit)
    call inbook(5,w2r,iinit)
    call inbook(6,w2i,iinit)
6   enddo

!
! call the results
! 
  call outbok(ss1,ss2)
  print*,'        '
  print*,'  Result of the integration: '
  print*,'        '
  print*,'real_sigma(0)=',ss1(1),' +- ',ss2(1)
  print*,'imag_sigma(0)=',ss1(2),' +- ',ss2(2)
  print*,'    '
  print*,'real_sigma(1)=',ss1(3),' +- ',ss2(3)
  print*,'imag_sigma(1)=',ss1(4),' +- ',ss2(4)
  print*,'    '
  print*,'real_sigma(2)=',ss1(5),' +- ',ss2(5)
  print*,'imag_sigma(2)=',ss1(6),' +- ',ss2(6)
  per_mp  = n_mp
  per_disc= n_disc
  per_mp  = per_mp/nev 
  per_disc= per_disc/nitermax 
  print*,'        '
  print*,'  Statistics on the mp routines:'
  print*,'        '
  print*,'percentage of mp        points=',per_mp
  print*,'percentage of discarded points=',per_disc
  call mpgetprec (idig1)
  print*,'       '
  print*,'digits used in mp routines (if called) =',idig1
  stop
  contains
!
  subroutine momenta(roots,mazz)
  real(kind(1.d0)), intent(in) :: roots,mazz 
  real(kind(1.d0)), dimension(3) :: xm
  real(kind(1.d0)), dimension(1:4,3) :: prambo
  integer :: k
!
!  Momenta:
!
!!$  k1(3)=  0.000000000000000d0     
!!$  k1(1)=  0.000000000000000d0
!!$  k1(2)=  512.0872557516079d0
!!$  k1(0)=  512.0872557516079d0
!!$!
!!$  k2(3)= 0.000000000000000d0  
!!$  k2(1)= 0.000000000000000d0
!!$  k2(2)=-512.0872557516079d0
!!$  k2(0)= 512.0872557516079d0
!!$!
!!$  k3(3)=  440.4851117383275d0 
!!$  k3(1)= -144.3896919351951d0 
!!$  k3(2)=  -78.66966522476675d0 
!!$  k3(0)=  478.9358967368120d0
!!$!       
!!$  k4(3)= -361.5459770190293d0 
!!$  k4(1)=  178.8661949956274d0 
!!$  k4(2)=   49.97789160641172d0 
!!$  k4(0)=  416.5591902917646d0
!!$!       
!!$  k5(3)=  -78.93913471929818d0 
!!$  k5(1)=  -34.47650306043226d0 
!!$  k5(2)=   28.69177361835482d0 
!!$  k5(0)=  128.6794244746394d0
!!$!
  k1(3)=  0.d0     
  k1(1)=  0.d0
  k1(2)=  roots/2.d0
  k1(0)=  roots/2.d0
!       
  k2(3)= 0.d0  
  k2(1)= 0.d0
  k2(2)=-roots/2.d0
  k2(0)= roots/2.d0
!
  xm(1)= mazz
  xm(2)= mazz
  xm(3)= mazz
  call rambo(0,3,roots,xm,prambo,dj)
  do k= 1,4
   l1= mod(k,4)
   k3(l1)= prambo(k,1)
   k4(l1)= prambo(k,2)
   k5(l1)= prambo(k,3)
   k6(l1)= 0.d0
  enddo
  end subroutine momenta 
!
 subroutine dp_result(p,cutpart)
  real(kind(1.d0)) :: p 
  real(kind(1.d0)) :: p20,p30,p40,p31,p41,p42,p21,p32,p43,mazz2
  real(kind(1.d0)), dimension(0:3) :: p3mp1,p4mp2,p4mp1
  real(kind(1.d0)), dimension(0:3) :: p2mp1,p3mp2,p4mp3
  complex(kind(1.d0)), dimension(0:2,1:60) :: floop= 0.d0
  complex(kind(1.d0)), dimension(0:2) :: cutpart
  integer :: l1
  mazz2= zm**2
  call contr(p2,p2,1,1,p20)
  call contr(p3,p3,1,1,p30)
  call contr(p4,p4,1,1,p40)
  p2mp1= p2-p1
  p3mp1= p3-p1 
  p3mp2= p3-p2
  p4mp1= p4-p1 
  p4mp2= p4-p2 
  p4mp3= p4-p3  
  call contr(p3mp1,p3mp1,1,1,p31)
  call contr(p4mp1,p4mp1,1,1,p41)
  call contr(p4mp2,p4mp2,1,1,p42)
!
  call avh_olo_d0(floop(0,15),0.d0,mazz2,mazz2,p30,p20,p31)           
  call avh_olo_d0(floop(0,23),0.d0,mazz2,p42,0.d0,p20,p41)            
  call avh_olo_d0(floop(0,27),0.d0,p31,mazz2,0.d0,p30,p41)            
  call avh_olo_d0(floop(0,29),p20,mazz2,mazz2,0.d0,p30,p42)           
  call avh_olo_d0(floop(0,30),mazz2,mazz2,mazz2,p41,p31,p42)          
!                                                                      
  call avh_olo_c0(floop(0, 7),0.d0 ,mazz2,p20)                        
  call avh_olo_c0(floop(0,11),0.d0 ,p31  ,p30)                        
  call avh_olo_c0(floop(0,13),p20  ,mazz2,p30)                        
  call avh_olo_c0(floop(0,14),mazz2,mazz2,p31)                        
  call avh_olo_c0(floop(0,19),0.d0 ,p41  ,0.d0)                       
  call avh_olo_c0(floop(0,21),p20  ,p42  ,0.d0)                       
  call avh_olo_c0(floop(0,22),mazz2,p42  ,p41)                        
  call avh_olo_c0(floop(0,25),p30  ,mazz2,0.d0)                       
  call avh_olo_c0(floop(0,26),p31  ,mazz2,p41)                        
  call avh_olo_c0(floop(0,28),mazz2,mazz2,p42)                        
  call avh_olo_b0(floop(0,3),0.d0)                                    
  call avh_olo_b0(floop(0,5),p20)                                     
  call avh_olo_b0(floop(0,9),p30)                                     
  call avh_olo_b0(floop(0,17),0.d0)                                   
  call avh_olo_b0(floop(0,6),mazz2)                                   
  call avh_olo_b0(floop(0,10),p31)                                    
  call avh_olo_b0(floop(0,18),p41)                                    
  call avh_olo_b0(floop(0,12),mazz2)                                  
  call avh_olo_b0(floop(0,20),p42)                                    
  call avh_olo_b0(floop(0,24),mazz2)                                  
  do l1= 0,2                                                          
   cutpart(l1)=      +dcoeff(0,30)*floop(l1,30)&                      
                     +dcoeff(0,29)*floop(l1,29)&                      
                     +dcoeff(0,27)*floop(l1,27)&                      
                     +dcoeff(0,23)*floop(l1,23)&                      
                     +dcoeff(0,15)*floop(l1,15)&                      
                     +ccoeff(0,28)*floop(l1,28)&                      
                     +ccoeff(0,26)*floop(l1,26)&                      
                     +ccoeff(0,25)*floop(l1,25)&                      
                     +ccoeff(0,22)*floop(l1,22)&                      
                     +ccoeff(0,21)*floop(l1,21)&                      
                     +ccoeff(0,19)*floop(l1,19)&                      
                     +ccoeff(0,14)*floop(l1,14)&                      
                     +ccoeff(0,13)*floop(l1,13)&                      
                     +ccoeff(0,11)*floop(l1,11)&                      
                     +ccoeff(0,7) *floop(l1,7 )&                      
                     +bcoeff(0,3) *floop(l1,3 )&                      
                     +bcoeff(0,5) *floop(l1,5 )&                      
                     +bcoeff(0,9) *floop(l1,9 )&                      
                     +bcoeff(0,17)*floop(l1,17)&                      
                     +bcoeff(0,6) *floop(l1,6 )&                      
                     +bcoeff(0,10)*floop(l1,10)&                      
                     +bcoeff(0,18)*floop(l1,18)&                      
                     +bcoeff(0,12)*floop(l1,12)&                      
                     +bcoeff(0,20)*floop(l1,20)&                      
                     +bcoeff(0,24)*floop(l1,24)&                      
                     -0.5d0*bcoeff(3,3) *floop(l1,3 )*vveck1(3)  &    
                     -0.5d0*bcoeff(3,5) *floop(l1,5 )*vveck1(5)  &    
                     -0.5d0*bcoeff(3,9) *floop(l1,9 )*vveck1(9)  &    
                     -0.5d0*bcoeff(3,17)*floop(l1,17)*vveck1(17) &    
                     -0.5d0*bcoeff(3,6) *floop(l1,6 )*vveck1(6)  &    
                     -0.5d0*bcoeff(3,10)*floop(l1,10)*vveck1(10) &    
                     -0.5d0*bcoeff(3,18)*floop(l1,18)*vveck1(18) &    
                     -0.5d0*bcoeff(3,12)*floop(l1,12)*vveck1(12) &    
                     -0.5d0*bcoeff(3,20)*floop(l1,20)*vveck1(20) &    
                     -0.5d0*bcoeff(3,24)*floop(l1,24)*vveck1(24)      
  enddo                                                               
  end subroutine dp_result
!
 subroutine mp_result(p,cutpart)
!
! WARNING: Loop functions in double precision 
!
  type(mp_real) :: p 
  real(kind(1.d0)) :: p20,p30,p40,p31,p41,p42,p21,p32,p43,mazz2
  real(kind(1.d0)), dimension(0:3) :: p3mp1,p4mp2,p4mp1
  real(kind(1.d0)), dimension(0:3) :: p2mp1,p3mp2,p4mp3
  complex(kind(1.d0)), dimension(0:2,1:60) :: floop= 0.d0
  type(mp_complex), dimension(0:2) :: cutpart
  integer :: l1
  mazz2= zm**2
  call contr(p2,p2,1,1,p20)
  call contr(p3,p3,1,1,p30)
  call contr(p4,p4,1,1,p40)
  p2mp1= p2-p1
  p3mp1= p3-p1 
  p3mp2= p3-p2
  p4mp1= p4-p1 
  p4mp2= p4-p2 
  p4mp3= p4-p3  
  call contr(p3mp1,p3mp1,1,1,p31)
  call contr(p4mp1,p4mp1,1,1,p41)
  call contr(p4mp2,p4mp2,1,1,p42)
!
  call avh_olo_d0(floop(0,15),0.d0,mazz2,mazz2,p30,p20,p31)           
  call avh_olo_d0(floop(0,23),0.d0,mazz2,p42,0.d0,p20,p41)            
  call avh_olo_d0(floop(0,27),0.d0,p31,mazz2,0.d0,p30,p41)            
  call avh_olo_d0(floop(0,29),p20,mazz2,mazz2,0.d0,p30,p42)           
  call avh_olo_d0(floop(0,30),mazz2,mazz2,mazz2,p41,p31,p42)          
!                                                                      
  call avh_olo_c0(floop(0, 7),0.d0 ,mazz2,p20)                        
  call avh_olo_c0(floop(0,11),0.d0 ,p31  ,p30)                        
  call avh_olo_c0(floop(0,13),p20  ,mazz2,p30)                        
  call avh_olo_c0(floop(0,14),mazz2,mazz2,p31)                        
  call avh_olo_c0(floop(0,19),0.d0 ,p41  ,0.d0)                       
  call avh_olo_c0(floop(0,21),p20  ,p42  ,0.d0)                       
  call avh_olo_c0(floop(0,22),mazz2,p42  ,p41)                        
  call avh_olo_c0(floop(0,25),p30  ,mazz2,0.d0)                       
  call avh_olo_c0(floop(0,26),p31  ,mazz2,p41)                        
  call avh_olo_c0(floop(0,28),mazz2,mazz2,p42)                        
  call avh_olo_b0(floop(0,3),0.d0)                                    
  call avh_olo_b0(floop(0,5),p20)                                     
  call avh_olo_b0(floop(0,9),p30)                                     
  call avh_olo_b0(floop(0,17),0.d0)                                   
  call avh_olo_b0(floop(0,6),mazz2)                                   
  call avh_olo_b0(floop(0,10),p31)                                    
  call avh_olo_b0(floop(0,18),p41)                                    
  call avh_olo_b0(floop(0,12),mazz2)                                  
  call avh_olo_b0(floop(0,20),p42)                                    
  call avh_olo_b0(floop(0,24),mazz2)                                  
  do l1= 0,2                                                          
   cutpart(l1)=       mp_dcoeff(0,30)*floop(l1,30)&                      
                     +mp_dcoeff(0,29)*floop(l1,29)&                      
                     +mp_dcoeff(0,27)*floop(l1,27)&                      
                     +mp_dcoeff(0,23)*floop(l1,23)&                      
                     +mp_dcoeff(0,15)*floop(l1,15)&                      
                     +mp_ccoeff(0,28)*floop(l1,28)&                      
                     +mp_ccoeff(0,26)*floop(l1,26)&                      
                     +mp_ccoeff(0,25)*floop(l1,25)&                      
                     +mp_ccoeff(0,22)*floop(l1,22)&                      
                     +mp_ccoeff(0,21)*floop(l1,21)&                      
                     +mp_ccoeff(0,19)*floop(l1,19)&                      
                     +mp_ccoeff(0,14)*floop(l1,14)&                      
                     +mp_ccoeff(0,13)*floop(l1,13)&                      
                     +mp_ccoeff(0,11)*floop(l1,11)&                      
                     +mp_ccoeff(0,7) *floop(l1,7 )&                      
                     +mp_bcoeff(0,3) *floop(l1,3 )&                      
                     +mp_bcoeff(0,5) *floop(l1,5 )&                      
                     +mp_bcoeff(0,9) *floop(l1,9 )&                      
                     +mp_bcoeff(0,17)*floop(l1,17)&                      
                     +mp_bcoeff(0,6) *floop(l1,6 )&                      
                     +mp_bcoeff(0,10)*floop(l1,10)&                      
                     +mp_bcoeff(0,18)*floop(l1,18)&                      
                     +mp_bcoeff(0,12)*floop(l1,12)&                      
                     +mp_bcoeff(0,20)*floop(l1,20)&                      
                     +mp_bcoeff(0,24)*floop(l1,24)&                      
                     -0.5d0*mp_bcoeff(3,3) *floop(l1,3 )*mp_vveck1(3)  &    
                     -0.5d0*mp_bcoeff(3,5) *floop(l1,5 )*mp_vveck1(5)  &    
                     -0.5d0*mp_bcoeff(3,9) *floop(l1,9 )*mp_vveck1(9)  &    
                     -0.5d0*mp_bcoeff(3,17)*floop(l1,17)*mp_vveck1(17) &    
                     -0.5d0*mp_bcoeff(3,6) *floop(l1,6 )*mp_vveck1(6)  &    
                     -0.5d0*mp_bcoeff(3,10)*floop(l1,10)*mp_vveck1(10) &    
                     -0.5d0*mp_bcoeff(3,18)*floop(l1,18)*mp_vveck1(18) &    
                     -0.5d0*mp_bcoeff(3,12)*floop(l1,12)*mp_vveck1(12) &    
                     -0.5d0*mp_bcoeff(3,20)*floop(l1,20)*mp_vveck1(20) &    
                     -0.5d0*mp_bcoeff(3,24)*floop(l1,24)*mp_vveck1(24)      
  enddo                                                               
  end subroutine mp_result
 end program main 
  



