!   MPFUN90 Array Modules
!
!   This set of modules (which are combined into one module, "mpmodulev", at
!   the end of the file) extend the mpfun90 facilities to include Fortran-90
!   array operations.  Thus one can write, for example, A = B + C * D, where
!   A, B, C, and D are similarly dimensioned arrays.  These modules currently
!   support 1- and 2-D arrays only.

!   To use these modules in an application program, include the line
!   " use mpmodulev" in each subprogram where array constructs involving 
!   multiprecision data are used.  Arrays may be declared using the standard
!   MPFUN90 Fortran-90 type definitions.

!   If you have questions, please contact the author directly:

!   Benjamin E Barrowes
!   Los Alamos National Lab
!   barrowes@alum.mit.edu

!   Version date:   2004-09-28

module mpintmodv

 !  This Fortran-90 module defines operator extensions involving the
 !  MP_INTEGER datatype.  For operations involving two MP data types,
 !  those whose first argument is MP_INTEGER are included here.
 !  Others are handled in other modules.

 !  The subroutines and functions defined in this module are private
 !  and not intended to be called directly by the user.

 use mpfunmod
 use mpdefmod
 private kdb, mp4, mp24, mp41
 parameter (kdb = kind (0.d0), mp4 = mpwds + 4, mp24 = 2 * mp4, mp41 = mp4 + 1)
private mp_gttjd_10, mp_gttjd_01, mp_gttjd_20, mp_gttjd_02, mp_gttjd_11, mp_gttjd_22
private mp_gttdj_10, mp_gttdj_01, mp_gttdj_20, mp_gttdj_02, mp_gttdj_11, mp_gttdj_22
private mp_gttji_10, mp_gttji_01, mp_gttji_20, mp_gttji_02, mp_gttji_11, mp_gttji_22
private mp_gttij_10, mp_gttij_01, mp_gttij_20, mp_gttij_02, mp_gttij_11, mp_gttij_22
private mp_gttjq_10, mp_gttjq_01, mp_gttjq_20, mp_gttjq_02, mp_gttjq_11, mp_gttjq_22
private mp_gttjj_10, mp_gttjj_01, mp_gttjj_20, mp_gttjj_02, mp_gttjj_11, mp_gttjj_22
private mp_lttjd_10, mp_lttjd_01, mp_lttjd_20, mp_lttjd_02, mp_lttjd_11, mp_lttjd_22
private mp_lttdj_10, mp_lttdj_01, mp_lttdj_20, mp_lttdj_02, mp_lttdj_11, mp_lttdj_22
private mp_lttji_10, mp_lttji_01, mp_lttji_20, mp_lttji_02, mp_lttji_11, mp_lttji_22
private mp_lttij_10, mp_lttij_01, mp_lttij_20, mp_lttij_02, mp_lttij_11, mp_lttij_22
private mp_lttjq_10, mp_lttjq_01, mp_lttjq_20, mp_lttjq_02, mp_lttjq_11, mp_lttjq_22
private mp_lttjj_10, mp_lttjj_01, mp_lttjj_20, mp_lttjj_02, mp_lttjj_11, mp_lttjj_22
private mp_getjd_10, mp_getjd_01, mp_getjd_20, mp_getjd_02, mp_getjd_11, mp_getjd_22
private mp_getdj_10, mp_getdj_01, mp_getdj_20, mp_getdj_02, mp_getdj_11, mp_getdj_22
private mp_getji_10, mp_getji_01, mp_getji_20, mp_getji_02, mp_getji_11, mp_getji_22
private mp_getij_10, mp_getij_01, mp_getij_20, mp_getij_02, mp_getij_11, mp_getij_22
private mp_getjq_10, mp_getjq_01, mp_getjq_20, mp_getjq_02, mp_getjq_11, mp_getjq_22
private mp_getjj_10, mp_getjj_01, mp_getjj_20, mp_getjj_02, mp_getjj_11, mp_getjj_22
private mp_letjd_10, mp_letjd_01, mp_letjd_20, mp_letjd_02, mp_letjd_11, mp_letjd_22
private mp_letdj_10, mp_letdj_01, mp_letdj_20, mp_letdj_02, mp_letdj_11, mp_letdj_22
private mp_letji_10, mp_letji_01, mp_letji_20, mp_letji_02, mp_letji_11, mp_letji_22
private mp_letij_10, mp_letij_01, mp_letij_20, mp_letij_02, mp_letij_11, mp_letij_22
private mp_letjq_10, mp_letjq_01, mp_letjq_20, mp_letjq_02, mp_letjq_11, mp_letjq_22
private mp_letjj_10, mp_letjj_01, mp_letjj_20, mp_letjj_02, mp_letjj_11, mp_letjj_22
private mp_netjx_10, mp_netjx_01, mp_netjx_20, mp_netjx_02, mp_netjx_11, mp_netjx_22
private mp_netxj_10, mp_netxj_01, mp_netxj_20, mp_netxj_02, mp_netxj_11, mp_netxj_22
private mp_netjd_10, mp_netjd_01, mp_netjd_20, mp_netjd_02, mp_netjd_11, mp_netjd_22
private mp_netdj_10, mp_netdj_01, mp_netdj_20, mp_netdj_02, mp_netdj_11, mp_netdj_22
private mp_netji_10, mp_netji_01, mp_netji_20, mp_netji_02, mp_netji_11, mp_netji_22
private mp_netij_10, mp_netij_01, mp_netij_20, mp_netij_02, mp_netij_11, mp_netij_22
private mp_netjz_10, mp_netjz_01, mp_netjz_20, mp_netjz_02, mp_netjz_11, mp_netjz_22
private mp_netjq_10, mp_netjq_01, mp_netjq_20, mp_netjq_02, mp_netjq_11, mp_netjq_22
private mp_netjj_10, mp_netjj_01, mp_netjj_20, mp_netjj_02, mp_netjj_11, mp_netjj_22
private mp_eqtjx_10, mp_eqtjx_01, mp_eqtjx_20, mp_eqtjx_02, mp_eqtjx_11, mp_eqtjx_22
private mp_eqtxj_10, mp_eqtxj_01, mp_eqtxj_20, mp_eqtxj_02, mp_eqtxj_11, mp_eqtxj_22
private mp_eqtjd_10, mp_eqtjd_01, mp_eqtjd_20, mp_eqtjd_02, mp_eqtjd_11, mp_eqtjd_22
private mp_eqtdj_10, mp_eqtdj_01, mp_eqtdj_20, mp_eqtdj_02, mp_eqtdj_11, mp_eqtdj_22
private mp_eqtji_10, mp_eqtji_01, mp_eqtji_20, mp_eqtji_02, mp_eqtji_11, mp_eqtji_22
private mp_eqtij_10, mp_eqtij_01, mp_eqtij_20, mp_eqtij_02, mp_eqtij_11, mp_eqtij_22
private mp_eqtjz_10, mp_eqtjz_01, mp_eqtjz_20, mp_eqtjz_02, mp_eqtjz_11, mp_eqtjz_22
private mp_eqtjq_10, mp_eqtjq_01, mp_eqtjq_20, mp_eqtjq_02, mp_eqtjq_11, mp_eqtjq_22
private mp_eqtjj_10, mp_eqtjj_01, mp_eqtjj_20, mp_eqtjj_02, mp_eqtjj_11, mp_eqtjj_22
private mp_expjd_10, mp_expjd_01, mp_expjd_20, mp_expjd_02, mp_expjd_11, mp_expjd_22
private mp_expdj_10, mp_expdj_01, mp_expdj_20, mp_expdj_02, mp_expdj_11, mp_expdj_22
private mp_expji_10, mp_expji_01, mp_expji_20, mp_expji_02, mp_expji_11, mp_expji_22
private mp_expij_10, mp_expij_01, mp_expij_20, mp_expij_02, mp_expij_11, mp_expij_22
private mp_expjq_10, mp_expjq_01, mp_expjq_20, mp_expjq_02, mp_expjq_11, mp_expjq_22
private mp_expjj_10, mp_expjj_01, mp_expjj_20, mp_expjj_02, mp_expjj_11, mp_expjj_22
private mp_divjx_10, mp_divjx_01, mp_divjx_20, mp_divjx_02, mp_divjx_11, mp_divjx_22
private mp_divxj_10, mp_divxj_01, mp_divxj_20, mp_divxj_02, mp_divxj_11, mp_divxj_22
private mp_divjd_10, mp_divjd_01, mp_divjd_20, mp_divjd_02, mp_divjd_11, mp_divjd_22
private mp_divdj_10, mp_divdj_01, mp_divdj_20, mp_divdj_02, mp_divdj_11, mp_divdj_22
private mp_divji_10, mp_divji_01, mp_divji_20, mp_divji_02, mp_divji_11, mp_divji_22
private mp_divij_10, mp_divij_01, mp_divij_20, mp_divij_02, mp_divij_11, mp_divij_22
private mp_divjz_10, mp_divjz_01, mp_divjz_20, mp_divjz_02, mp_divjz_11, mp_divjz_22
private mp_divjq_10, mp_divjq_01, mp_divjq_20, mp_divjq_02, mp_divjq_11, mp_divjq_22
private mp_divjj_10, mp_divjj_01, mp_divjj_20, mp_divjj_02, mp_divjj_11, mp_divjj_22
private mp_muljx_10, mp_muljx_01, mp_muljx_20, mp_muljx_02, mp_muljx_11, mp_muljx_22
private mp_mulxj_10, mp_mulxj_01, mp_mulxj_20, mp_mulxj_02, mp_mulxj_11, mp_mulxj_22
private mp_muljd_10, mp_muljd_01, mp_muljd_20, mp_muljd_02, mp_muljd_11, mp_muljd_22
private mp_muldj_10, mp_muldj_01, mp_muldj_20, mp_muldj_02, mp_muldj_11, mp_muldj_22
private mp_mulji_10, mp_mulji_01, mp_mulji_20, mp_mulji_02, mp_mulji_11, mp_mulji_22
private mp_mulij_10, mp_mulij_01, mp_mulij_20, mp_mulij_02, mp_mulij_11, mp_mulij_22
private mp_muljz_10, mp_muljz_01, mp_muljz_20, mp_muljz_02, mp_muljz_11, mp_muljz_22
private mp_muljq_10, mp_muljq_01, mp_muljq_20, mp_muljq_02, mp_muljq_11, mp_muljq_22
private mp_muljj_10, mp_muljj_01, mp_muljj_20, mp_muljj_02, mp_muljj_11, mp_muljj_22
private mp_negj_1, mp_negj_2
private mp_subjx_10, mp_subjx_01, mp_subjx_20, mp_subjx_02, mp_subjx_11, mp_subjx_22
private mp_subxj_10, mp_subxj_01, mp_subxj_20, mp_subxj_02, mp_subxj_11, mp_subxj_22
private mp_subjd_10, mp_subjd_01, mp_subjd_20, mp_subjd_02, mp_subjd_11, mp_subjd_22
private mp_subdj_10, mp_subdj_01, mp_subdj_20, mp_subdj_02, mp_subdj_11, mp_subdj_22
private mp_subji_10, mp_subji_01, mp_subji_20, mp_subji_02, mp_subji_11, mp_subji_22
private mp_subij_10, mp_subij_01, mp_subij_20, mp_subij_02, mp_subij_11, mp_subij_22
private mp_subjz_10, mp_subjz_01, mp_subjz_20, mp_subjz_02, mp_subjz_11, mp_subjz_22
private mp_subjq_10, mp_subjq_01, mp_subjq_20, mp_subjq_02, mp_subjq_11, mp_subjq_22
private mp_subjj_10, mp_subjj_01, mp_subjj_20, mp_subjj_02, mp_subjj_11, mp_subjj_22
private mp_addjx_10, mp_addjx_01, mp_addjx_20, mp_addjx_02, mp_addjx_11, mp_addjx_22
private mp_addxj_10, mp_addxj_01, mp_addxj_20, mp_addxj_02, mp_addxj_11, mp_addxj_22
private mp_addjd_10, mp_addjd_01, mp_addjd_20, mp_addjd_02, mp_addjd_11, mp_addjd_22
private mp_adddj_10, mp_adddj_01, mp_adddj_20, mp_adddj_02, mp_adddj_11, mp_adddj_22
private mp_addji_10, mp_addji_01, mp_addji_20, mp_addji_02, mp_addji_11, mp_addji_22
private mp_addij_10, mp_addij_01, mp_addij_20, mp_addij_02, mp_addij_11, mp_addij_22
private mp_addjz_10, mp_addjz_01, mp_addjz_20, mp_addjz_02, mp_addjz_11, mp_addjz_22
private mp_addjq_10, mp_addjq_01, mp_addjq_20, mp_addjq_02, mp_addjq_11, mp_addjq_22
private mp_addjj_10, mp_addjj_01, mp_addjj_20, mp_addjj_02, mp_addjj_11, mp_addjj_22
private mp_eqja_10, mp_eqja_11, mp_eqja_20, mp_eqja_22
private mp_eqjx_10, mp_eqjx_11, mp_eqjx_20, mp_eqjx_22
private mp_eqxj_10, mp_eqxj_11, mp_eqxj_20, mp_eqxj_22
private mp_eqjd_10, mp_eqjd_11, mp_eqjd_20, mp_eqjd_22
private mp_eqdj_10, mp_eqdj_11, mp_eqdj_20, mp_eqdj_22
private mp_eqji_10, mp_eqji_11, mp_eqji_20, mp_eqji_22
private mp_eqij_10, mp_eqij_11, mp_eqij_20, mp_eqij_22
private mp_eqjz_10, mp_eqjz_11, mp_eqjz_20, mp_eqjz_22
private mp_eqjq_10, mp_eqjq_11, mp_eqjq_20, mp_eqjq_22
private mp_eqjj_10, mp_eqjj_11, mp_eqjj_20, mp_eqjj_22

 !  MPI operator extension interface blocks.

 interface assignment (=)
module procedure mp_eqjj_10
module procedure mp_eqjj_11
module procedure mp_eqjj_20
module procedure mp_eqjj_22
module procedure mp_eqjq_10
module procedure mp_eqjq_11
module procedure mp_eqjq_20
module procedure mp_eqjq_22
module procedure mp_eqjz_10
module procedure mp_eqjz_11
module procedure mp_eqjz_20
module procedure mp_eqjz_22
module procedure mp_eqij_10
module procedure mp_eqij_11
module procedure mp_eqij_20
module procedure mp_eqij_22
module procedure mp_eqji_10
module procedure mp_eqji_11
module procedure mp_eqji_20
module procedure mp_eqji_22
module procedure mp_eqdj_10
module procedure mp_eqdj_11
module procedure mp_eqdj_20
module procedure mp_eqdj_22
module procedure mp_eqjd_10
module procedure mp_eqjd_11
module procedure mp_eqjd_20
module procedure mp_eqjd_22
module procedure mp_eqxj_10
module procedure mp_eqxj_11
module procedure mp_eqxj_20
module procedure mp_eqxj_22
module procedure mp_eqjx_10
module procedure mp_eqjx_11
module procedure mp_eqjx_20
module procedure mp_eqjx_22
module procedure mp_eqja_10
module procedure mp_eqja_11
module procedure mp_eqja_20
module procedure mp_eqja_22
 end interface

 interface operator (+)
module procedure mp_addjj_10
module procedure mp_addjj_01
module procedure mp_addjj_20
module procedure mp_addjj_02
module procedure mp_addjj_11
module procedure mp_addjj_22
module procedure mp_addjq_10
module procedure mp_addjq_01
module procedure mp_addjq_20
module procedure mp_addjq_02
module procedure mp_addjq_11
module procedure mp_addjq_22
module procedure mp_addjz_10
module procedure mp_addjz_01
module procedure mp_addjz_20
module procedure mp_addjz_02
module procedure mp_addjz_11
module procedure mp_addjz_22
module procedure mp_addij_10
module procedure mp_addij_01
module procedure mp_addij_20
module procedure mp_addij_02
module procedure mp_addij_11
module procedure mp_addij_22
module procedure mp_addji_10
module procedure mp_addji_01
module procedure mp_addji_20
module procedure mp_addji_02
module procedure mp_addji_11
module procedure mp_addji_22
module procedure mp_adddj_10
module procedure mp_adddj_01
module procedure mp_adddj_20
module procedure mp_adddj_02
module procedure mp_adddj_11
module procedure mp_adddj_22
module procedure mp_addjd_10
module procedure mp_addjd_01
module procedure mp_addjd_20
module procedure mp_addjd_02
module procedure mp_addjd_11
module procedure mp_addjd_22
module procedure mp_addxj_10
module procedure mp_addxj_01
module procedure mp_addxj_20
module procedure mp_addxj_02
module procedure mp_addxj_11
module procedure mp_addxj_22
module procedure mp_addjx_10
module procedure mp_addjx_01
module procedure mp_addjx_20
module procedure mp_addjx_02
module procedure mp_addjx_11
module procedure mp_addjx_22
 end interface

 interface operator (-)
module procedure mp_subjj_10
module procedure mp_subjj_01
module procedure mp_subjj_20
module procedure mp_subjj_02
module procedure mp_subjj_11
module procedure mp_subjj_22
module procedure mp_subjq_10
module procedure mp_subjq_01
module procedure mp_subjq_20
module procedure mp_subjq_02
module procedure mp_subjq_11
module procedure mp_subjq_22
module procedure mp_subjz_10
module procedure mp_subjz_01
module procedure mp_subjz_20
module procedure mp_subjz_02
module procedure mp_subjz_11
module procedure mp_subjz_22
module procedure mp_subij_10
module procedure mp_subij_01
module procedure mp_subij_20
module procedure mp_subij_02
module procedure mp_subij_11
module procedure mp_subij_22
module procedure mp_subji_10
module procedure mp_subji_01
module procedure mp_subji_20
module procedure mp_subji_02
module procedure mp_subji_11
module procedure mp_subji_22
module procedure mp_subdj_10
module procedure mp_subdj_01
module procedure mp_subdj_20
module procedure mp_subdj_02
module procedure mp_subdj_11
module procedure mp_subdj_22
module procedure mp_subjd_10
module procedure mp_subjd_01
module procedure mp_subjd_20
module procedure mp_subjd_02
module procedure mp_subjd_11
module procedure mp_subjd_22
module procedure mp_subxj_10
module procedure mp_subxj_01
module procedure mp_subxj_20
module procedure mp_subxj_02
module procedure mp_subxj_11
module procedure mp_subxj_22
module procedure mp_subjx_10
module procedure mp_subjx_01
module procedure mp_subjx_20
module procedure mp_subjx_02
module procedure mp_subjx_11
module procedure mp_subjx_22
module procedure mp_negj_1
module procedure mp_negj_2
 end interface

 interface operator (*)
module procedure mp_muljj_10
module procedure mp_muljj_01
module procedure mp_muljj_20
module procedure mp_muljj_02
module procedure mp_muljj_11
module procedure mp_muljj_22
module procedure mp_muljq_10
module procedure mp_muljq_01
module procedure mp_muljq_20
module procedure mp_muljq_02
module procedure mp_muljq_11
module procedure mp_muljq_22
module procedure mp_muljz_10
module procedure mp_muljz_01
module procedure mp_muljz_20
module procedure mp_muljz_02
module procedure mp_muljz_11
module procedure mp_muljz_22
module procedure mp_mulij_10
module procedure mp_mulij_01
module procedure mp_mulij_20
module procedure mp_mulij_02
module procedure mp_mulij_11
module procedure mp_mulij_22
module procedure mp_mulji_10
module procedure mp_mulji_01
module procedure mp_mulji_20
module procedure mp_mulji_02
module procedure mp_mulji_11
module procedure mp_mulji_22
module procedure mp_muldj_10
module procedure mp_muldj_01
module procedure mp_muldj_20
module procedure mp_muldj_02
module procedure mp_muldj_11
module procedure mp_muldj_22
module procedure mp_muljd_10
module procedure mp_muljd_01
module procedure mp_muljd_20
module procedure mp_muljd_02
module procedure mp_muljd_11
module procedure mp_muljd_22
module procedure mp_mulxj_10
module procedure mp_mulxj_01
module procedure mp_mulxj_20
module procedure mp_mulxj_02
module procedure mp_mulxj_11
module procedure mp_mulxj_22
module procedure mp_muljx_10
module procedure mp_muljx_01
module procedure mp_muljx_20
module procedure mp_muljx_02
module procedure mp_muljx_11
module procedure mp_muljx_22
 end interface

 interface operator (/)
module procedure mp_divjj_10
module procedure mp_divjj_01
module procedure mp_divjj_20
module procedure mp_divjj_02
module procedure mp_divjj_11
module procedure mp_divjj_22
module procedure mp_divjq_10
module procedure mp_divjq_01
module procedure mp_divjq_20
module procedure mp_divjq_02
module procedure mp_divjq_11
module procedure mp_divjq_22
module procedure mp_divjz_10
module procedure mp_divjz_01
module procedure mp_divjz_20
module procedure mp_divjz_02
module procedure mp_divjz_11
module procedure mp_divjz_22
module procedure mp_divij_10
module procedure mp_divij_01
module procedure mp_divij_20
module procedure mp_divij_02
module procedure mp_divij_11
module procedure mp_divij_22
module procedure mp_divji_10
module procedure mp_divji_01
module procedure mp_divji_20
module procedure mp_divji_02
module procedure mp_divji_11
module procedure mp_divji_22
module procedure mp_divdj_10
module procedure mp_divdj_01
module procedure mp_divdj_20
module procedure mp_divdj_02
module procedure mp_divdj_11
module procedure mp_divdj_22
module procedure mp_divjd_10
module procedure mp_divjd_01
module procedure mp_divjd_20
module procedure mp_divjd_02
module procedure mp_divjd_11
module procedure mp_divjd_22
module procedure mp_divxj_10
module procedure mp_divxj_01
module procedure mp_divxj_20
module procedure mp_divxj_02
module procedure mp_divxj_11
module procedure mp_divxj_22
module procedure mp_divjx_10
module procedure mp_divjx_01
module procedure mp_divjx_20
module procedure mp_divjx_02
module procedure mp_divjx_11
module procedure mp_divjx_22
 end interface

 interface operator (**)
module procedure mp_expjj_10
module procedure mp_expjj_01
module procedure mp_expjj_20
module procedure mp_expjj_02
module procedure mp_expjj_11
module procedure mp_expjj_22
module procedure mp_expjq_10
module procedure mp_expjq_01
module procedure mp_expjq_20
module procedure mp_expjq_02
module procedure mp_expjq_11
module procedure mp_expjq_22
module procedure mp_expij_10
module procedure mp_expij_01
module procedure mp_expij_20
module procedure mp_expij_02
module procedure mp_expij_11
module procedure mp_expij_22
module procedure mp_expji_10
module procedure mp_expji_01
module procedure mp_expji_20
module procedure mp_expji_02
module procedure mp_expji_11
module procedure mp_expji_22
module procedure mp_expdj_10
module procedure mp_expdj_01
module procedure mp_expdj_20
module procedure mp_expdj_02
module procedure mp_expdj_11
module procedure mp_expdj_22
module procedure mp_expjd_10
module procedure mp_expjd_01
module procedure mp_expjd_20
module procedure mp_expjd_02
module procedure mp_expjd_11
module procedure mp_expjd_22
 end interface

 interface operator (.eq.)
module procedure mp_eqtjj_10
module procedure mp_eqtjj_01
module procedure mp_eqtjj_20
module procedure mp_eqtjj_02
module procedure mp_eqtjj_11
module procedure mp_eqtjj_22
module procedure mp_eqtjq_10
module procedure mp_eqtjq_01
module procedure mp_eqtjq_20
module procedure mp_eqtjq_02
module procedure mp_eqtjq_11
module procedure mp_eqtjq_22
module procedure mp_eqtjz_10
module procedure mp_eqtjz_01
module procedure mp_eqtjz_20
module procedure mp_eqtjz_02
module procedure mp_eqtjz_11
module procedure mp_eqtjz_22
module procedure mp_eqtij_10
module procedure mp_eqtij_01
module procedure mp_eqtij_20
module procedure mp_eqtij_02
module procedure mp_eqtij_11
module procedure mp_eqtij_22
module procedure mp_eqtji_10
module procedure mp_eqtji_01
module procedure mp_eqtji_20
module procedure mp_eqtji_02
module procedure mp_eqtji_11
module procedure mp_eqtji_22
module procedure mp_eqtdj_10
module procedure mp_eqtdj_01
module procedure mp_eqtdj_20
module procedure mp_eqtdj_02
module procedure mp_eqtdj_11
module procedure mp_eqtdj_22
module procedure mp_eqtjd_10
module procedure mp_eqtjd_01
module procedure mp_eqtjd_20
module procedure mp_eqtjd_02
module procedure mp_eqtjd_11
module procedure mp_eqtjd_22
module procedure mp_eqtxj_10
module procedure mp_eqtxj_01
module procedure mp_eqtxj_20
module procedure mp_eqtxj_02
module procedure mp_eqtxj_11
module procedure mp_eqtxj_22
module procedure mp_eqtjx_10
module procedure mp_eqtjx_01
module procedure mp_eqtjx_20
module procedure mp_eqtjx_02
module procedure mp_eqtjx_11
module procedure mp_eqtjx_22
 end interface

 interface operator (.ne.)
module procedure mp_netjj_10
module procedure mp_netjj_01
module procedure mp_netjj_20
module procedure mp_netjj_02
module procedure mp_netjj_11
module procedure mp_netjj_22
module procedure mp_netjq_10
module procedure mp_netjq_01
module procedure mp_netjq_20
module procedure mp_netjq_02
module procedure mp_netjq_11
module procedure mp_netjq_22
module procedure mp_netjz_10
module procedure mp_netjz_01
module procedure mp_netjz_20
module procedure mp_netjz_02
module procedure mp_netjz_11
module procedure mp_netjz_22
module procedure mp_netij_10
module procedure mp_netij_01
module procedure mp_netij_20
module procedure mp_netij_02
module procedure mp_netij_11
module procedure mp_netij_22
module procedure mp_netji_10
module procedure mp_netji_01
module procedure mp_netji_20
module procedure mp_netji_02
module procedure mp_netji_11
module procedure mp_netji_22
module procedure mp_netdj_10
module procedure mp_netdj_01
module procedure mp_netdj_20
module procedure mp_netdj_02
module procedure mp_netdj_11
module procedure mp_netdj_22
module procedure mp_netjd_10
module procedure mp_netjd_01
module procedure mp_netjd_20
module procedure mp_netjd_02
module procedure mp_netjd_11
module procedure mp_netjd_22
module procedure mp_netxj_10
module procedure mp_netxj_01
module procedure mp_netxj_20
module procedure mp_netxj_02
module procedure mp_netxj_11
module procedure mp_netxj_22
module procedure mp_netjx_10
module procedure mp_netjx_01
module procedure mp_netjx_20
module procedure mp_netjx_02
module procedure mp_netjx_11
module procedure mp_netjx_22
 end interface

 interface operator (.le.)
module procedure mp_letjj_10
module procedure mp_letjj_01
module procedure mp_letjj_20
module procedure mp_letjj_02
module procedure mp_letjj_11
module procedure mp_letjj_22
module procedure mp_letjq_10
module procedure mp_letjq_01
module procedure mp_letjq_20
module procedure mp_letjq_02
module procedure mp_letjq_11
module procedure mp_letjq_22
module procedure mp_letij_10
module procedure mp_letij_01
module procedure mp_letij_20
module procedure mp_letij_02
module procedure mp_letij_11
module procedure mp_letij_22
module procedure mp_letji_10
module procedure mp_letji_01
module procedure mp_letji_20
module procedure mp_letji_02
module procedure mp_letji_11
module procedure mp_letji_22
module procedure mp_letdj_10
module procedure mp_letdj_01
module procedure mp_letdj_20
module procedure mp_letdj_02
module procedure mp_letdj_11
module procedure mp_letdj_22
module procedure mp_letjd_10
module procedure mp_letjd_01
module procedure mp_letjd_20
module procedure mp_letjd_02
module procedure mp_letjd_11
module procedure mp_letjd_22
 end interface

 interface operator (.ge.)
module procedure mp_getjj_10
module procedure mp_getjj_01
module procedure mp_getjj_20
module procedure mp_getjj_02
module procedure mp_getjj_11
module procedure mp_getjj_22
module procedure mp_getjq_10
module procedure mp_getjq_01
module procedure mp_getjq_20
module procedure mp_getjq_02
module procedure mp_getjq_11
module procedure mp_getjq_22
module procedure mp_getij_10
module procedure mp_getij_01
module procedure mp_getij_20
module procedure mp_getij_02
module procedure mp_getij_11
module procedure mp_getij_22
module procedure mp_getji_10
module procedure mp_getji_01
module procedure mp_getji_20
module procedure mp_getji_02
module procedure mp_getji_11
module procedure mp_getji_22
module procedure mp_getdj_10
module procedure mp_getdj_01
module procedure mp_getdj_20
module procedure mp_getdj_02
module procedure mp_getdj_11
module procedure mp_getdj_22
module procedure mp_getjd_10
module procedure mp_getjd_01
module procedure mp_getjd_20
module procedure mp_getjd_02
module procedure mp_getjd_11
module procedure mp_getjd_22
 end interface

 interface operator (.lt.)
module procedure mp_lttjj_10
module procedure mp_lttjj_01
module procedure mp_lttjj_20
module procedure mp_lttjj_02
module procedure mp_lttjj_11
module procedure mp_lttjj_22
module procedure mp_lttjq_10
module procedure mp_lttjq_01
module procedure mp_lttjq_20
module procedure mp_lttjq_02
module procedure mp_lttjq_11
module procedure mp_lttjq_22
module procedure mp_lttij_10
module procedure mp_lttij_01
module procedure mp_lttij_20
module procedure mp_lttij_02
module procedure mp_lttij_11
module procedure mp_lttij_22
module procedure mp_lttji_10
module procedure mp_lttji_01
module procedure mp_lttji_20
module procedure mp_lttji_02
module procedure mp_lttji_11
module procedure mp_lttji_22
module procedure mp_lttdj_10
module procedure mp_lttdj_01
module procedure mp_lttdj_20
module procedure mp_lttdj_02
module procedure mp_lttdj_11
module procedure mp_lttdj_22
module procedure mp_lttjd_10
module procedure mp_lttjd_01
module procedure mp_lttjd_20
module procedure mp_lttjd_02
module procedure mp_lttjd_11
module procedure mp_lttjd_22
 end interface

 interface operator (.gt.)
module procedure mp_gttjj_10
module procedure mp_gttjj_01
module procedure mp_gttjj_20
module procedure mp_gttjj_02
module procedure mp_gttjj_11
module procedure mp_gttjj_22
module procedure mp_gttjq_10
module procedure mp_gttjq_01
module procedure mp_gttjq_20
module procedure mp_gttjq_02
module procedure mp_gttjq_11
module procedure mp_gttjq_22
module procedure mp_gttij_10
module procedure mp_gttij_01
module procedure mp_gttij_20
module procedure mp_gttij_02
module procedure mp_gttij_11
module procedure mp_gttij_22
module procedure mp_gttji_10
module procedure mp_gttji_01
module procedure mp_gttji_20
module procedure mp_gttji_02
module procedure mp_gttji_11
module procedure mp_gttji_22
module procedure mp_gttdj_10
module procedure mp_gttdj_01
module procedure mp_gttdj_20
module procedure mp_gttdj_02
module procedure mp_gttdj_11
module procedure mp_gttdj_22
module procedure mp_gttjd_10
module procedure mp_gttjd_01
module procedure mp_gttjd_20
module procedure mp_gttjd_02
module procedure mp_gttjd_11
module procedure mp_gttjd_22
 end interface

contains

 !  MPI assignment routines.

 subroutine mp_eqjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: jb
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (jb%mpi, ja(ii1)%mpi, mpnw) 
end do 
  return
 end subroutine mp_eqjj_10

 subroutine mp_eqjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: jb
  integer mpnw
dimension ja(:)
dimension jb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (jb(ii1)%mpi, ja(ii1)%mpi, mpnw) 
end do 
  return
 end subroutine mp_eqjj_11

 subroutine mp_eqjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: jb
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (jb%mpi, ja(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjj_20

 subroutine mp_eqjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (jb(ii1,ii2)%mpi, ja(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjj_22

 subroutine mp_eqjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (qb%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjq_10

 subroutine mp_eqjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjq_11

 subroutine mp_eqjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (qb%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjq_20

 subroutine mp_eqjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjq_22

 subroutine mp_eqjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: zb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (zb%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjz_10

 subroutine mp_eqjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: zb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (zb(ii1)%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjz_11

 subroutine mp_eqjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: zb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (zb%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjz_20

 subroutine mp_eqjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: zb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (zb(ii1,ii2)%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjz_22

 subroutine mp_eqij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: jb
  integer mpnw
dimension ia(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (jb%mpi, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqij_10

 subroutine mp_eqij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: jb
  integer mpnw
dimension ia(:)
dimension jb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (jb(ii1)%mpi, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqij_11

 subroutine mp_eqij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: jb
  integer mpnw
dimension ia(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (jb%mpi, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqij_20

 subroutine mp_eqij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: jb
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqij_22

 subroutine mp_eqji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: ib
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, ja(ii1)%mpi)
end do 
  return
 end subroutine mp_eqji_10

 subroutine mp_eqji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: ib
  integer mpnw
dimension ja(:)
dimension ib(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, ja(ii1)%mpi)
end do 
  return
 end subroutine mp_eqji_11

 subroutine mp_eqji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: ib
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, ja(ii1,ii2)%mpi)
end do 
end do 
  return
 end subroutine mp_eqji_20

 subroutine mp_eqji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: ib
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, ja(ii1,ii2)%mpi)
end do 
end do 
  return
 end subroutine mp_eqji_22

 subroutine mp_eqdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: jb
  integer mpnw
dimension da(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (jb%mpi, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdj_10

 subroutine mp_eqdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: jb
  integer mpnw
dimension da(:)
dimension jb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (jb(ii1)%mpi, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdj_11

 subroutine mp_eqdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: jb
  integer mpnw
dimension da(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (jb%mpi, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdj_20

 subroutine mp_eqdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: jb
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdj_22

 subroutine mp_eqjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjd_10

 subroutine mp_eqjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension db(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjd_11

 subroutine mp_eqjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjd_20

 subroutine mp_eqjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjd_22

 subroutine mp_eqxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: jb
  integer mpnw
dimension xa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (jb%mpi, db, ib)
  xa(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqxj_10

 subroutine mp_eqxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: jb
  integer mpnw
dimension xa(:)
dimension jb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (jb(ii1)%mpi, db, ib)
  xa(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqxj_11

 subroutine mp_eqxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: jb
  integer mpnw
dimension xa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (jb%mpi, db, ib)
  xa(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqxj_20

 subroutine mp_eqxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: jb
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  xa(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqxj_22

 subroutine mp_eqjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: xb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = xb
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjx_10

 subroutine mp_eqjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: xb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension xb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = xb(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqjx_11

 subroutine mp_eqjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: xb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = xb
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjx_20

 subroutine mp_eqjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ja
  intent (in):: xb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = xb(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqjx_22

 subroutine mp_eqja_10 (ja, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: ja
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  l = len (ab)
  do i = 1, l
   az(i) = ab(i:i)
  enddo
  call mpdexc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqja_10

 subroutine mp_eqja_11 (ja, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: ja
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension ab(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  l = len (ab(ii1))
  do i = 1, l
   az(i) = ab(ii1)(i:i)
  enddo
  call mpdexc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqja_11

 subroutine mp_eqja_20 (ja, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: ja
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  l = len (ab)
  do i = 1, l
   az(i) = ab(i:i)
  enddo
  call mpdexc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqja_20

 subroutine mp_eqja_22 (ja, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: ja
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension ab(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  l = len (ab(ii1,ii2))
  do i = 1, l
   az(i) = ab(ii1,ii2)(i:i)
  enddo
  call mpdexc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, ja(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqja_22

 !  MPI add routines.

 function mp_addjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_addjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpadd (ja(ii1)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_addjj_10

 function mp_addjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_addjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpadd (ja%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_addjj_01

 function mp_addjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_addjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpadd (ja(ii1,ii2)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjj_20

 function mp_addjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_addjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpadd (ja%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjj_02

 function mp_addjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_addjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpadd (ja(ii1)%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_addjj_11

 function mp_addjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addjj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_addjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpadd (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_addjj_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjj_22

 function mp_addjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_addjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpadd (ja(ii1)%mpi, qb%mpr, mp_addjq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjq_10

 function mp_addjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_addjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpadd (ja%mpi, qb(ii1)%mpr, mp_addjq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjq_01

 function mp_addjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_addjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpadd (ja(ii1,ii2)%mpi, qb%mpr, mp_addjq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjq_20

 function mp_addjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_addjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpadd (ja%mpi, qb(ii1,ii2)%mpr, mp_addjq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjq_02

 function mp_addjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_addjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpadd (ja(ii1)%mpi, qb(ii1)%mpr, mp_addjq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjq_11

 function mp_addjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_addjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpadd (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, mp_addjq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjq_22

 function mp_addjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_addjz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addjz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjz_10

 function mp_addjz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_addjz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addjz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjz_01

 function mp_addjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_addjz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addjz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjz_20

 function mp_addjz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_addjz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addjz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjz_02

 function mp_addjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_addjz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addjz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjz_11

 function mp_addjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_addjz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addjz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjz_22

 function mp_addij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_10
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension mp_addij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_10(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addij_10

 function mp_addij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_01
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_addij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_01(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addij_01

 function mp_addij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_20
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension mp_addij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_20(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addij_20

 function mp_addij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_02
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_addij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_02(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addij_02

 function mp_addij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_11
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_addij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_11(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addij_11

 function mp_addij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addij_22
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_addij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addij_22(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addij_22

 function mp_addji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_10
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension mp_addji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_10(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addji_10

 function mp_addji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_01
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ib(:)
dimension mp_addji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_01(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addji_01

 function mp_addji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_20
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension mp_addji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1,ii2)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_20(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addji_20

 function mp_addji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_02
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ib(:,:)
dimension mp_addji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_02(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addji_02

 function mp_addji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_11
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_addji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_11(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_addji_11

 function mp_addji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_addji_22
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_addji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1,ii2)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_addji_22(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addji_22

 function mp_adddj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_adddj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpadd (q1%mpr, jb%mpi, mp_adddj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddj_10

 function mp_adddj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_adddj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1)%mpi, mp_adddj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddj_01

 function mp_adddj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_adddj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpadd (q1%mpr, jb%mpi, mp_adddj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddj_20

 function mp_adddj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_adddj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1,ii2)%mpi, mp_adddj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddj_02

 function mp_adddj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_adddj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1)%mpi, mp_adddj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddj_11

 function mp_adddj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_adddj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpadd (q1%mpr, jb(ii1,ii2)%mpi, mp_adddj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddj_22

 function mp_addjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_addjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1)%mpi, q1%mpr, mp_addjd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjd_10

 function mp_addjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_addjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpadd (ja%mpi, q1%mpr, mp_addjd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjd_01

 function mp_addjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_addjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (ja(ii1,ii2)%mpi, q1%mpr, mp_addjd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjd_20

 function mp_addjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_addjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpadd (ja%mpi, q1%mpr, mp_addjd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjd_02

 function mp_addjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_addjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpadd (ja(ii1)%mpi, q1%mpr, mp_addjd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addjd_11

 function mp_addjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_addjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpadd (ja(ii1,ii2)%mpi, q1%mpr, mp_addjd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addjd_22

 function mp_addxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_addxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxj_10

 function mp_addxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_addxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxj_01

 function mp_addxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_addxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxj_20

 function mp_addxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_addxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxj_02

 function mp_addxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_addxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxj_11

 function mp_addxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_addxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxj_22

 function mp_addjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_addjx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjx_10

 function mp_addjx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_addjx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjx_01

 function mp_addjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_addjx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjx_20

 function mp_addjx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_addjx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjx_02

 function mp_addjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_addjx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addjx_11

 function mp_addjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addjx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_addjx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addjx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addjx_22

 !  MPI subtract routines.

 function mp_subjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_subjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpsub (ja(ii1)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_subjj_10

 function mp_subjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_subjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpsub (ja%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_subjj_01

 function mp_subjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_subjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpsub (ja(ii1,ii2)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjj_20

 function mp_subjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_subjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpsub (ja%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjj_02

 function mp_subjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_subjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpsub (ja(ii1)%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_subjj_11

 function mp_subjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subjj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_subjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpsub (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_subjj_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjj_22

 function mp_subjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_subjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpsub (ja(ii1)%mpi, qb%mpr, mp_subjq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjq_10

 function mp_subjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_subjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpsub (ja%mpi, qb(ii1)%mpr, mp_subjq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjq_01

 function mp_subjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_subjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpsub (ja(ii1,ii2)%mpi, qb%mpr, mp_subjq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjq_20

 function mp_subjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_subjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpsub (ja%mpi, qb(ii1,ii2)%mpr, mp_subjq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjq_02

 function mp_subjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_subjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpsub (ja(ii1)%mpi, qb(ii1)%mpr, mp_subjq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjq_11

 function mp_subjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_subjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpsub (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, mp_subjq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjq_22

 function mp_subjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_subjz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subjz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjz_10

 function mp_subjz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_subjz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subjz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjz_01

 function mp_subjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_subjz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subjz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjz_20

 function mp_subjz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_subjz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subjz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjz_02

 function mp_subjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_subjz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subjz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjz_11

 function mp_subjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_subjz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subjz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjz_22

 function mp_subij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_10
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension mp_subij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_10(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subij_10

 function mp_subij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_01
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_subij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_01(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subij_01

 function mp_subij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_20
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension mp_subij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_20(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subij_20

 function mp_subij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_02
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_subij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_02(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subij_02

 function mp_subij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_11
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_subij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_11(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subij_11

 function mp_subij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subij_22
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_subij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subij_22(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subij_22

 function mp_subji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_10
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension mp_subji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_10(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subji_10

 function mp_subji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_01
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ib(:)
dimension mp_subji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_01(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subji_01

 function mp_subji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_20
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension mp_subji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_20(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subji_20

 function mp_subji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_02
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ib(:,:)
dimension mp_subji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_02(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subji_02

 function mp_subji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_11
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_subji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_11(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_subji_11

 function mp_subji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_subji_22
  intent (in):: ja, ib
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_subji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_subji_22(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subji_22

 function mp_subdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_subdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpsub (q1%mpr, jb%mpi, mp_subdj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdj_10

 function mp_subdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_subdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1)%mpi, mp_subdj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdj_01

 function mp_subdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_subdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpsub (q1%mpr, jb%mpi, mp_subdj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdj_20

 function mp_subdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_subdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1,ii2)%mpi, mp_subdj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdj_02

 function mp_subdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_subdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1)%mpi, mp_subdj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdj_11

 function mp_subdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_subdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpsub (q1%mpr, jb(ii1,ii2)%mpi, mp_subdj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdj_22

 function mp_subjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_subjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1)%mpi, q1%mpr, mp_subjd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjd_10

 function mp_subjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_subjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpsub (ja%mpi, q1%mpr, mp_subjd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjd_01

 function mp_subjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_subjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, mp_subjd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjd_20

 function mp_subjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_subjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpsub (ja%mpi, q1%mpr, mp_subjd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjd_02

 function mp_subjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_subjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpsub (ja(ii1)%mpi, q1%mpr, mp_subjd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subjd_11

 function mp_subjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_subjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, mp_subjd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subjd_22

 function mp_subxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_subxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxj_10

 function mp_subxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_subxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxj_01

 function mp_subxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_subxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxj_20

 function mp_subxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_subxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxj_02

 function mp_subxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_subxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxj_11

 function mp_subxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_subxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxj_22

 function mp_subjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_subjx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjx_10

 function mp_subjx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_subjx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjx_01

 function mp_subjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_subjx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjx_20

 function mp_subjx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_subjx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjx_02

 function mp_subjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_subjx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subjx_11

 function mp_subjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subjx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_subjx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subjx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subjx_22

 !  MPI negation routine.

 function mp_negj_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_negj_1
  intent (in):: ja
  integer mpnw
dimension ja(:)
dimension mp_negj_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (ja(ii1)%mpi, mp_negj_1(ii1)%mpi, mpnw) 
  mp_negj_1(ii1)%mpi(1) = - ja(ii1)%mpi(1)
end do 
  return
 end function mp_negj_1

 function mp_negj_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_negj_2
  intent (in):: ja
  integer mpnw
dimension ja(:,:)
dimension mp_negj_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (ja(ii1,ii2)%mpi, mp_negj_2(ii1,ii2)%mpi, mpnw) 
  mp_negj_2(ii1,ii2)%mpi(1) = - ja(ii1,ii2)%mpi(1)
end do 
end do 
  return
 end function mp_negj_2

 !  MPI multiply routines.

 function mp_muljj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_muljj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmul (ja(ii1)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_muljj_10

 function mp_muljj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_muljj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmul (ja%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_muljj_01

 function mp_muljj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_muljj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmul (ja(ii1,ii2)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljj_20

 function mp_muljj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_muljj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmul (ja%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljj_02

 function mp_muljj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_muljj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmul (ja(ii1)%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_muljj_11

 function mp_muljj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_muljj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_muljj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmul (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_muljj_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljj_22

 function mp_muljq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_muljq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmul (ja(ii1)%mpi, qb%mpr, mp_muljq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljq_10

 function mp_muljq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_muljq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmul (ja%mpi, qb(ii1)%mpr, mp_muljq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljq_01

 function mp_muljq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_muljq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmul (ja(ii1,ii2)%mpi, qb%mpr, mp_muljq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljq_20

 function mp_muljq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_muljq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmul (ja%mpi, qb(ii1,ii2)%mpr, mp_muljq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljq_02

 function mp_muljq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_muljq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmul (ja(ii1)%mpi, qb(ii1)%mpr, mp_muljq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljq_11

 function mp_muljq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_muljq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmul (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, mp_muljq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljq_22

 function mp_muljz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_muljz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muljz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljz_10

 function mp_muljz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_muljz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muljz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljz_01

 function mp_muljz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_muljz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muljz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljz_20

 function mp_muljz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_muljz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muljz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljz_02

 function mp_muljz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_muljz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muljz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljz_11

 function mp_muljz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_muljz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muljz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljz_22

 function mp_mulij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_10
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ia(:)
dimension mp_mulij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpmuld (jb%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulij_10

 function mp_mulij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_01
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_mulij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpmuld (jb(ii1)%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulij_01

 function mp_mulij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_20
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ia(:,:)
dimension mp_mulij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpmuld (jb%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulij_20

 function mp_mulij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_02
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_mulij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpmuld (jb(ii1,ii2)%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulij_02

 function mp_mulij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_11
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_mulij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpmuld (jb(ii1)%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulij_11

 function mp_mulij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulij_22
  intent (in):: ia, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_mulij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpmuld (jb(ii1,ii2)%mpi, da, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulij_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulij_22

 function mp_mulji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_10
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_mulji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpmuld (ja(ii1)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulji_10

 function mp_mulji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_01
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ib(:)
dimension mp_mulji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpmuld (ja%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulji_01

 function mp_mulji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_20
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_mulji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpmuld (ja(ii1,ii2)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulji_20

 function mp_mulji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_02
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ib(:,:)
dimension mp_mulji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpmuld (ja%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulji_02

 function mp_mulji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_11
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_mulji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpmuld (ja(ii1)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_mulji_11

 function mp_mulji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_mulji_22
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_mulji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpmuld (ja(ii1,ii2)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_mulji_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulji_22

 function mp_muldj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_10
  intent (in):: da, jb
  integer mpnw
dimension da(:)
dimension mp_muldj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmuld (jb%mpi, da(ii1), 0, mp_muldj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldj_10

 function mp_muldj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_01
  intent (in):: da, jb
  integer mpnw
dimension jb(:)
dimension mp_muldj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmuld (jb(ii1)%mpi, da, 0, mp_muldj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldj_01

 function mp_muldj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_20
  intent (in):: da, jb
  integer mpnw
dimension da(:,:)
dimension mp_muldj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmuld (jb%mpi, da(ii1,ii2), 0, mp_muldj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldj_20

 function mp_muldj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_02
  intent (in):: da, jb
  integer mpnw
dimension jb(:,:)
dimension mp_muldj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmuld (jb(ii1,ii2)%mpi, da, 0, mp_muldj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldj_02

 function mp_muldj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_11
  intent (in):: da, jb
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_muldj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmuld (jb(ii1)%mpi, da(ii1), 0, mp_muldj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldj_11

 function mp_muldj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldj_22
  intent (in):: da, jb
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_muldj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmuld (jb(ii1,ii2)%mpi, da(ii1,ii2), 0, mp_muldj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldj_22

 function mp_muljd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_10
  intent (in):: ja, db
  integer mpnw
dimension ja(:)
dimension mp_muljd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmuld (ja(ii1)%mpi, db, 0, mp_muljd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljd_10

 function mp_muljd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_01
  intent (in):: ja, db
  integer mpnw
dimension db(:)
dimension mp_muljd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpmuld (ja%mpi, db(ii1), 0, mp_muljd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljd_01

 function mp_muljd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_20
  intent (in):: ja, db
  integer mpnw
dimension ja(:,:)
dimension mp_muljd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmuld (ja(ii1,ii2)%mpi, db, 0, mp_muljd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljd_20

 function mp_muljd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_02
  intent (in):: ja, db
  integer mpnw
dimension db(:,:)
dimension mp_muljd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpmuld (ja%mpi, db(ii1,ii2), 0, mp_muljd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljd_02

 function mp_muljd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_11
  intent (in):: ja, db
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_muljd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmuld (ja(ii1)%mpi, db(ii1), 0, mp_muljd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muljd_11

 function mp_muljd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muljd_22
  intent (in):: ja, db
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_muljd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmuld (ja(ii1,ii2)%mpi, db(ii1,ii2), 0, mp_muljd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muljd_22

 function mp_mulxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_mulxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxj_10

 function mp_mulxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_mulxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxj_01

 function mp_mulxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_mulxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxj_20

 function mp_mulxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_mulxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxj_02

 function mp_mulxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_mulxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxj_11

 function mp_mulxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_mulxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxj_22

 function mp_muljx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_muljx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljx_10

 function mp_muljx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_muljx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljx_01

 function mp_muljx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_muljx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljx_20

 function mp_muljx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_muljx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljx_02

 function mp_muljx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_muljx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muljx_11

 function mp_muljx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muljx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_muljx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_muljx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muljx_22

 !  MPI divide routines.

 function mp_divjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_divjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divjj_10

 function mp_divjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_divjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdiv (ja%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divjj_01

 function mp_divjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_divjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjj_20

 function mp_divjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_divjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdiv (ja%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjj_02

 function mp_divjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_divjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divjj_11

 function mp_divjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divjj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_divjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divjj_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjj_22

 function mp_divjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_divjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, qb%mpr, mp_divjq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjq_10

 function mp_divjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_divjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdiv (ja%mpi, qb(ii1)%mpr, mp_divjq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjq_01

 function mp_divjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_divjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, qb%mpr, mp_divjq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjq_20

 function mp_divjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_divjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdiv (ja%mpi, qb(ii1,ii2)%mpr, mp_divjq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjq_02

 function mp_divjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_divjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, qb(ii1)%mpr, mp_divjq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjq_11

 function mp_divjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_divjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, mp_divjq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjq_22

 function mp_divjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_divjz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divjz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjz_10

 function mp_divjz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_divjz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divjz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjz_01

 function mp_divjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_divjz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divjz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjz_20

 function mp_divjz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_divjz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divjz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjz_02

 function mp_divjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_divjz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divjz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjz_11

 function mp_divjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_divjz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divjz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjz_22

 function mp_divij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_10
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension mp_divij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_10(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_divij_10

 function mp_divij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_01
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_divij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_01(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_divij_01

 function mp_divij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_20
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension mp_divij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_20(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divij_20

 function mp_divij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_02
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_divij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_02(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divij_02

 function mp_divij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_11
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_divij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_11(ii1)%mpi, q3%mpr, mpnw) 
end do 
  return
 end function mp_divij_11

 function mp_divij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divij_22
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_divij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpinfr (q2%mpr, mp_divij_22(ii1,ii2)%mpi, q3%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divij_22

 function mp_divji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_10
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_divji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdivd (ja(ii1)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_10(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divji_10

 function mp_divji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_01
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ib(:)
dimension mp_divji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdivd (ja%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_01(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divji_01

 function mp_divji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_20
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_divji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdivd (ja(ii1,ii2)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_20(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divji_20

 function mp_divji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_02
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ib(:,:)
dimension mp_divji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdivd (ja%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_02(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divji_02

 function mp_divji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_11
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_divji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdivd (ja(ii1)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_11(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_divji_11

 function mp_divji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_divji_22
  intent (in):: ja, ib
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_divji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdivd (ja(ii1,ii2)%mpi, db, 0, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_divji_22(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divji_22

 function mp_divdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_divdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpdiv (q1%mpr, jb%mpi, mp_divdj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdj_10

 function mp_divdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_divdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1)%mpi, mp_divdj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdj_01

 function mp_divdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_divdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpdiv (q1%mpr, jb%mpi, mp_divdj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdj_20

 function mp_divdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_divdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1,ii2)%mpi, mp_divdj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdj_02

 function mp_divdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_divdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1)%mpi, mp_divdj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdj_11

 function mp_divdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_divdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpdiv (q1%mpr, jb(ii1,ii2)%mpi, mp_divdj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdj_22

 function mp_divjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_10
  intent (in):: ja, db
  integer mpnw
dimension ja(:)
dimension mp_divjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdivd (ja(ii1)%mpi, db, 0, mp_divjd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjd_10

 function mp_divjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_01
  intent (in):: ja, db
  integer mpnw
dimension db(:)
dimension mp_divjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdivd (ja%mpi, db(ii1), 0, mp_divjd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjd_01

 function mp_divjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_20
  intent (in):: ja, db
  integer mpnw
dimension ja(:,:)
dimension mp_divjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdivd (ja(ii1,ii2)%mpi, db, 0, mp_divjd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjd_20

 function mp_divjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_02
  intent (in):: ja, db
  integer mpnw
dimension db(:,:)
dimension mp_divjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdivd (ja%mpi, db(ii1,ii2), 0, mp_divjd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjd_02

 function mp_divjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_11
  intent (in):: ja, db
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_divjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdivd (ja(ii1)%mpi, db(ii1), 0, mp_divjd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divjd_11

 function mp_divjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divjd_22
  intent (in):: ja, db
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_divjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdivd (ja(ii1,ii2)%mpi, db(ii1,ii2), 0, mp_divjd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divjd_22

 function mp_divxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_divxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxj_10

 function mp_divxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_divxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxj_01

 function mp_divxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_divxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxj_20

 function mp_divxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_divxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxj_02

 function mp_divxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_divxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxj_11

 function mp_divxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_divxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxj_22

 function mp_divjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_divjx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjx_10

 function mp_divjx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_divjx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjx_01

 function mp_divjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_divjx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjx_20

 function mp_divjx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_divjx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjx_02

 function mp_divjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_divjx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divjx_11

 function mp_divjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divjx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_divjx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divjx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divjx_22

 !  MPI exponentiation routines.

 function mp_expjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_expjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_10(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expjj_10

 function mp_expjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_expjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_01(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expjj_01

 function mp_expjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_expjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_20(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expjj_20

 function mp_expjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_expjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_02(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expjj_02

 function mp_expjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_expjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_11(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expjj_11

 function mp_expjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expjj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_expjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expjj_22(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expjj_22

 function mp_expjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_10
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_expjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjq_10

 function mp_expjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_01
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qb(:)
dimension mp_expjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjq_01

 function mp_expjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_20
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_expjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjq_20

 function mp_expjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_02
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qb(:,:)
dimension mp_expjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjq_02

 function mp_expjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_11
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_expjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjq_11

 function mp_expjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjq_22
  intent (in):: ja, qb
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_expjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjq_22

 function mp_expij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_10
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension mp_expij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_10(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expij_10

 function mp_expij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_01
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_expij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_01(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expij_01

 function mp_expij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_20
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension mp_expij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_20(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expij_20

 function mp_expij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_02
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_expij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1,ii2)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_02(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expij_02

 function mp_expij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_11
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_expij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_11(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expij_11

 function mp_expij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expij_22
  intent (in):: ia, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_expij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1,ii2)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expij_22(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expij_22

 function mp_expji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_expji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpnpwr (ja(ii1)%mpi, ib, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_10(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expji_10

 function mp_expji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_expji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  call mpnpwr (ja%mpi, ib(ii1), q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_01(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expji_01

 function mp_expji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_expji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpnpwr (ja(ii1,ii2)%mpi, ib, q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_20(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expji_20

 function mp_expji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_expji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  call mpnpwr (ja%mpi, ib(ii1,ii2), q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_02(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expji_02

 function mp_expji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_expji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpnpwr (ja(ii1)%mpi, ib(ii1), q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_11(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_expji_11

 function mp_expji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_expji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_expji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpnpwr (ja(ii1,ii2)%mpi, ib(ii1,ii2), q1%mpr, mpnw) 
  call mpnint (q1%mpr, mp_expji_22(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_expji_22

 function mp_expdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_10
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:)
dimension mp_expdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdj_10

 function mp_expdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_01
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_expdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdj_01

 function mp_expdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_20
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:,:)
dimension mp_expdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdj_20

 function mp_expdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_02
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_expdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1,ii2)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdj_02

 function mp_expdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_11
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_expdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdj_11

 function mp_expdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdj_22
  intent (in):: da, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_expdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, jb(ii1,ii2)%mpi, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdj_22

 function mp_expjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_10
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension mp_expjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db, 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjd_10

 function mp_expjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_01
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension db(:)
dimension mp_expjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjd_01

 function mp_expjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_20
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension mp_expjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db, 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjd_20

 function mp_expjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_02
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension db(:,:)
dimension mp_expjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mplog (ja%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1,ii2), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjd_02

 function mp_expjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_11
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_expjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mplog (ja(ii1)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expjd_11

 function mp_expjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expjd_22
  intent (in):: ja, db
  type (mp_real) q1, q2
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_expjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mplog (ja(ii1,ii2)%mpi, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1,ii2), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expjd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expjd_22

 !  MPI .EQ. routines.

 function mp_eqtjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_eqtjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_10(ii1) = .true.
  else
   mp_eqtjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjj_10

 function mp_eqtjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_eqtjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_01(ii1) = .true.
  else
   mp_eqtjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjj_01

 function mp_eqtjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_eqtjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_20(ii1,ii2) = .true.
  else
   mp_eqtjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjj_20

 function mp_eqtjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_eqtjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_02(ii1,ii2) = .true.
  else
   mp_eqtjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjj_02

 function mp_eqtjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_eqtjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_11(ii1) = .true.
  else
   mp_eqtjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjj_11

 function mp_eqtjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_eqtjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjj_22(ii1,ii2) = .true.
  else
   mp_eqtjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjj_22

 function mp_eqtjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_eqtjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_10(ii1) = .true.
  else
   mp_eqtjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjq_10

 function mp_eqtjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_eqtjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_01(ii1) = .true.
  else
   mp_eqtjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjq_01

 function mp_eqtjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_eqtjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_20(ii1,ii2) = .true.
  else
   mp_eqtjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjq_20

 function mp_eqtjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_eqtjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_02(ii1,ii2) = .true.
  else
   mp_eqtjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjq_02

 function mp_eqtjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_eqtjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_11(ii1) = .true.
  else
   mp_eqtjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjq_11

 function mp_eqtjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_eqtjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjq_22(ii1,ii2) = .true.
  else
   mp_eqtjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjq_22

 function mp_eqtjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_eqtjz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_10(ii1) = .true.
  else
   mp_eqtjz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjz_10

 function mp_eqtjz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_eqtjz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_01(ii1) = .true.
  else
   mp_eqtjz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjz_01

 function mp_eqtjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_eqtjz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_20(ii1,ii2) = .true.
  else
   mp_eqtjz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjz_20

 function mp_eqtjz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_eqtjz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_02(ii1,ii2) = .true.
  else
   mp_eqtjz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjz_02

 function mp_eqtjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_eqtjz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_11(ii1) = .true.
  else
   mp_eqtjz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjz_11

 function mp_eqtjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_eqtjz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjz_22(ii1,ii2) = .true.
  else
   mp_eqtjz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjz_22

 function mp_eqtij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_eqtij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_10(ii1) = .true.
  else
   mp_eqtij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtij_10

 function mp_eqtij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_eqtij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_01(ii1) = .true.
  else
   mp_eqtij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtij_01

 function mp_eqtij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_eqtij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_20(ii1,ii2) = .true.
  else
   mp_eqtij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtij_20

 function mp_eqtij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_eqtij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_02(ii1,ii2) = .true.
  else
   mp_eqtij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtij_02

 function mp_eqtij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_eqtij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_11(ii1) = .true.
  else
   mp_eqtij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtij_11

 function mp_eqtij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_eqtij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtij_22(ii1,ii2) = .true.
  else
   mp_eqtij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtij_22

 function mp_eqtji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_eqtji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_10(ii1) = .true.
  else
   mp_eqtji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtji_10

 function mp_eqtji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_eqtji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_01(ii1) = .true.
  else
   mp_eqtji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtji_01

 function mp_eqtji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_eqtji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_20(ii1,ii2) = .true.
  else
   mp_eqtji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtji_20

 function mp_eqtji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_eqtji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_02(ii1,ii2) = .true.
  else
   mp_eqtji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtji_02

 function mp_eqtji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_eqtji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_11(ii1) = .true.
  else
   mp_eqtji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtji_11

 function mp_eqtji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_eqtji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtji_22(ii1,ii2) = .true.
  else
   mp_eqtji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtji_22

 function mp_eqtdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_eqtdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_10(ii1) = .true.
  else
   mp_eqtdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdj_10

 function mp_eqtdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_eqtdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_01(ii1) = .true.
  else
   mp_eqtdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdj_01

 function mp_eqtdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_eqtdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_20(ii1,ii2) = .true.
  else
   mp_eqtdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdj_20

 function mp_eqtdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_eqtdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_02(ii1,ii2) = .true.
  else
   mp_eqtdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdj_02

 function mp_eqtdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_eqtdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_11(ii1) = .true.
  else
   mp_eqtdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdj_11

 function mp_eqtdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_eqtdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdj_22(ii1,ii2) = .true.
  else
   mp_eqtdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdj_22

 function mp_eqtjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_eqtjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_10(ii1) = .true.
  else
   mp_eqtjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjd_10

 function mp_eqtjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_eqtjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_01(ii1) = .true.
  else
   mp_eqtjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjd_01

 function mp_eqtjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_eqtjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_20(ii1,ii2) = .true.
  else
   mp_eqtjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjd_20

 function mp_eqtjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_eqtjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_02(ii1,ii2) = .true.
  else
   mp_eqtjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjd_02

 function mp_eqtjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_eqtjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_11(ii1) = .true.
  else
   mp_eqtjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjd_11

 function mp_eqtjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_eqtjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtjd_22(ii1,ii2) = .true.
  else
   mp_eqtjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjd_22

 function mp_eqtxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_eqtxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_10(ii1) = .true.
  else
   mp_eqtxj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxj_10

 function mp_eqtxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_eqtxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_01(ii1) = .true.
  else
   mp_eqtxj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxj_01

 function mp_eqtxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_eqtxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_20(ii1,ii2) = .true.
  else
   mp_eqtxj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxj_20

 function mp_eqtxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_eqtxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_02(ii1,ii2) = .true.
  else
   mp_eqtxj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxj_02

 function mp_eqtxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_eqtxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_11(ii1) = .true.
  else
   mp_eqtxj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxj_11

 function mp_eqtxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_eqtxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxj_22(ii1,ii2) = .true.
  else
   mp_eqtxj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxj_22

 function mp_eqtjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_eqtjx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_10(ii1) = .true.
  else
   mp_eqtjx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjx_10

 function mp_eqtjx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_eqtjx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_01(ii1) = .true.
  else
   mp_eqtjx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjx_01

 function mp_eqtjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_eqtjx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_20(ii1,ii2) = .true.
  else
   mp_eqtjx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjx_20

 function mp_eqtjx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_eqtjx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_02(ii1,ii2) = .true.
  else
   mp_eqtjx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjx_02

 function mp_eqtjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_eqtjx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_11(ii1) = .true.
  else
   mp_eqtjx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtjx_11

 function mp_eqtjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtjx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_eqtjx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtjx_22(ii1,ii2) = .true.
  else
   mp_eqtjx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtjx_22

 !  MPI .NE. routines.

 function mp_netjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_netjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_10(ii1) = .true.
  else
   mp_netjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netjj_10

 function mp_netjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_netjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_01(ii1) = .true.
  else
   mp_netjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netjj_01

 function mp_netjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_netjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_20(ii1,ii2) = .true.
  else
   mp_netjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjj_20

 function mp_netjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_netjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_02(ii1,ii2) = .true.
  else
   mp_netjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjj_02

 function mp_netjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_netjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_11(ii1) = .true.
  else
   mp_netjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netjj_11

 function mp_netjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_netjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjj_22(ii1,ii2) = .true.
  else
   mp_netjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjj_22

 function mp_netjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_netjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_10(ii1) = .true.
  else
   mp_netjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netjq_10

 function mp_netjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_netjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_01(ii1) = .true.
  else
   mp_netjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netjq_01

 function mp_netjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_netjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_20(ii1,ii2) = .true.
  else
   mp_netjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjq_20

 function mp_netjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_netjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_02(ii1,ii2) = .true.
  else
   mp_netjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjq_02

 function mp_netjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_netjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_11(ii1) = .true.
  else
   mp_netjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netjq_11

 function mp_netjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_netjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjq_22(ii1,ii2) = .true.
  else
   mp_netjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjq_22

 function mp_netjz_10 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_10
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension mp_netjz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_10(ii1) = .true.
  else
   mp_netjz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netjz_10

 function mp_netjz_01 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_01
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_netjz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_01(ii1) = .true.
  else
   mp_netjz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netjz_01

 function mp_netjz_20 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_20
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension mp_netjz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_20(ii1,ii2) = .true.
  else
   mp_netjz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjz_20

 function mp_netjz_02 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_02
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_netjz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_02(ii1,ii2) = .true.
  else
   mp_netjz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjz_02

 function mp_netjz_11 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_11
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:)
dimension zb(:)
dimension mp_netjz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_11(ii1) = .true.
  else
   mp_netjz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netjz_11

 function mp_netjz_22 (ja, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjz_22
  intent (in):: ja, zb
  type (mp_complex) z1
  integer mpnw
dimension ja(:,:)
dimension zb(:,:)
dimension mp_netjz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjz_22(ii1,ii2) = .true.
  else
   mp_netjz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjz_22

 function mp_netij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_netij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_10(ii1) = .true.
  else
   mp_netij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netij_10

 function mp_netij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_netij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_01(ii1) = .true.
  else
   mp_netij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netij_01

 function mp_netij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_netij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_20(ii1,ii2) = .true.
  else
   mp_netij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netij_20

 function mp_netij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_netij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_02(ii1,ii2) = .true.
  else
   mp_netij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netij_02

 function mp_netij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_netij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_11(ii1) = .true.
  else
   mp_netij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netij_11

 function mp_netij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_netij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netij_22(ii1,ii2) = .true.
  else
   mp_netij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netij_22

 function mp_netji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_netji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_10(ii1) = .true.
  else
   mp_netji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netji_10

 function mp_netji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_netji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_01(ii1) = .true.
  else
   mp_netji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netji_01

 function mp_netji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_netji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_20(ii1,ii2) = .true.
  else
   mp_netji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netji_20

 function mp_netji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_netji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_02(ii1,ii2) = .true.
  else
   mp_netji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netji_02

 function mp_netji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_netji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_11(ii1) = .true.
  else
   mp_netji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netji_11

 function mp_netji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_netji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netji_22(ii1,ii2) = .true.
  else
   mp_netji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netji_22

 function mp_netdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_netdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_10(ii1) = .true.
  else
   mp_netdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netdj_10

 function mp_netdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_netdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_01(ii1) = .true.
  else
   mp_netdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netdj_01

 function mp_netdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_netdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_20(ii1,ii2) = .true.
  else
   mp_netdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdj_20

 function mp_netdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_netdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_02(ii1,ii2) = .true.
  else
   mp_netdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdj_02

 function mp_netdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_netdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_11(ii1) = .true.
  else
   mp_netdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netdj_11

 function mp_netdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_netdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdj_22(ii1,ii2) = .true.
  else
   mp_netdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdj_22

 function mp_netjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_netjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_10(ii1) = .true.
  else
   mp_netjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netjd_10

 function mp_netjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_netjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_01(ii1) = .true.
  else
   mp_netjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netjd_01

 function mp_netjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_netjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_20(ii1,ii2) = .true.
  else
   mp_netjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjd_20

 function mp_netjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_netjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_02(ii1,ii2) = .true.
  else
   mp_netjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjd_02

 function mp_netjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_netjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_11(ii1) = .true.
  else
   mp_netjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netjd_11

 function mp_netjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_netjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netjd_22(ii1,ii2) = .true.
  else
   mp_netjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjd_22

 function mp_netxj_10 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_10
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_netxj_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_10(ii1) = .true.
  else
   mp_netxj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netxj_10

 function mp_netxj_01 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_01
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:)
dimension mp_netxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_01(ii1) = .true.
  else
   mp_netxj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netxj_01

 function mp_netxj_20 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_20
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_netxj_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_20(ii1,ii2) = .true.
  else
   mp_netxj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxj_20

 function mp_netxj_02 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_02
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension jb(:,:)
dimension mp_netxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_02(ii1,ii2) = .true.
  else
   mp_netxj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxj_02

 function mp_netxj_11 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_11
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension jb(:)
dimension mp_netxj_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (jb(ii1)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_11(ii1) = .true.
  else
   mp_netxj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netxj_11

 function mp_netxj_22 (xa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxj_22
  intent (in):: xa, jb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension jb(:,:)
dimension mp_netxj_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (jb(ii1,ii2)%mpi, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxj_22(ii1,ii2) = .true.
  else
   mp_netxj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxj_22

 function mp_netjx_10 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_10
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension mp_netjx_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_10(ii1) = .true.
  else
   mp_netjx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netjx_10

 function mp_netjx_01 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_01
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_netjx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_01(ii1) = .true.
  else
   mp_netjx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netjx_01

 function mp_netjx_20 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_20
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension mp_netjx_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_20(ii1,ii2) = .true.
  else
   mp_netjx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjx_20

 function mp_netjx_02 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_02
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_netjx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (ja%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_02(ii1,ii2) = .true.
  else
   mp_netjx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjx_02

 function mp_netjx_11 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_11
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:)
dimension xb(:)
dimension mp_netjx_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_11(ii1) = .true.
  else
   mp_netjx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netjx_11

 function mp_netjx_22 (ja, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netjx_22
  intent (in):: ja, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension ja(:,:)
dimension xb(:,:)
dimension mp_netjx_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netjx_22(ii1,ii2) = .true.
  else
   mp_netjx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netjx_22

 !  MPI .LE. routines.

 function mp_letjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_letjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_10(ii1) = .true.
  else
   mp_letjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letjj_10

 function mp_letjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_letjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_01(ii1) = .true.
  else
   mp_letjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letjj_01

 function mp_letjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_letjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_20(ii1,ii2) = .true.
  else
   mp_letjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjj_20

 function mp_letjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_letjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_02(ii1,ii2) = .true.
  else
   mp_letjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjj_02

 function mp_letjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_letjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_11(ii1) = .true.
  else
   mp_letjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letjj_11

 function mp_letjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_letjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjj_22(ii1,ii2) = .true.
  else
   mp_letjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjj_22

 function mp_letjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_letjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_10(ii1) = .true.
  else
   mp_letjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letjq_10

 function mp_letjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_letjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_01(ii1) = .true.
  else
   mp_letjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letjq_01

 function mp_letjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_letjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_20(ii1,ii2) = .true.
  else
   mp_letjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjq_20

 function mp_letjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_letjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_02(ii1,ii2) = .true.
  else
   mp_letjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjq_02

 function mp_letjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_letjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_11(ii1) = .true.
  else
   mp_letjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letjq_11

 function mp_letjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_letjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjq_22(ii1,ii2) = .true.
  else
   mp_letjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjq_22

 function mp_letij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_letij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_10(ii1) = .true.
  else
   mp_letij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letij_10

 function mp_letij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_letij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_01(ii1) = .true.
  else
   mp_letij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letij_01

 function mp_letij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_letij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_20(ii1,ii2) = .true.
  else
   mp_letij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letij_20

 function mp_letij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_letij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_02(ii1,ii2) = .true.
  else
   mp_letij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letij_02

 function mp_letij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_letij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_11(ii1) = .true.
  else
   mp_letij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letij_11

 function mp_letij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_letij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letij_22(ii1,ii2) = .true.
  else
   mp_letij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letij_22

 function mp_letji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_letji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_10(ii1) = .true.
  else
   mp_letji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letji_10

 function mp_letji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_letji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_01(ii1) = .true.
  else
   mp_letji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letji_01

 function mp_letji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_letji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_20(ii1,ii2) = .true.
  else
   mp_letji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letji_20

 function mp_letji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_letji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_02(ii1,ii2) = .true.
  else
   mp_letji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letji_02

 function mp_letji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_letji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_11(ii1) = .true.
  else
   mp_letji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letji_11

 function mp_letji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_letji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letji_22(ii1,ii2) = .true.
  else
   mp_letji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letji_22

 function mp_letdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_letdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_10(ii1) = .true.
  else
   mp_letdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letdj_10

 function mp_letdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_letdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_01(ii1) = .true.
  else
   mp_letdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letdj_01

 function mp_letdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_letdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_20(ii1,ii2) = .true.
  else
   mp_letdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdj_20

 function mp_letdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_letdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_02(ii1,ii2) = .true.
  else
   mp_letdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdj_02

 function mp_letdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_letdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_11(ii1) = .true.
  else
   mp_letdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letdj_11

 function mp_letdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_letdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdj_22(ii1,ii2) = .true.
  else
   mp_letdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdj_22

 function mp_letjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_letjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_10(ii1) = .true.
  else
   mp_letjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letjd_10

 function mp_letjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_letjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_01(ii1) = .true.
  else
   mp_letjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letjd_01

 function mp_letjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_letjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_20(ii1,ii2) = .true.
  else
   mp_letjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjd_20

 function mp_letjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_letjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_02(ii1,ii2) = .true.
  else
   mp_letjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjd_02

 function mp_letjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_letjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_11(ii1) = .true.
  else
   mp_letjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letjd_11

 function mp_letjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_letjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letjd_22(ii1,ii2) = .true.
  else
   mp_letjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letjd_22

 !  MPI .GE. routines.

 function mp_getjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_getjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_10(ii1) = .true.
  else
   mp_getjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getjj_10

 function mp_getjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_getjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_01(ii1) = .true.
  else
   mp_getjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getjj_01

 function mp_getjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_getjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_20(ii1,ii2) = .true.
  else
   mp_getjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjj_20

 function mp_getjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_getjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_02(ii1,ii2) = .true.
  else
   mp_getjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjj_02

 function mp_getjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_getjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_11(ii1) = .true.
  else
   mp_getjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getjj_11

 function mp_getjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_getjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjj_22(ii1,ii2) = .true.
  else
   mp_getjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjj_22

 function mp_getjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_getjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_10(ii1) = .true.
  else
   mp_getjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getjq_10

 function mp_getjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_getjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_01(ii1) = .true.
  else
   mp_getjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getjq_01

 function mp_getjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_getjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_20(ii1,ii2) = .true.
  else
   mp_getjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjq_20

 function mp_getjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_getjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_02(ii1,ii2) = .true.
  else
   mp_getjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjq_02

 function mp_getjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_getjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_11(ii1) = .true.
  else
   mp_getjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getjq_11

 function mp_getjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_getjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjq_22(ii1,ii2) = .true.
  else
   mp_getjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjq_22

 function mp_getij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_getij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_10(ii1) = .true.
  else
   mp_getij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getij_10

 function mp_getij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_getij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_01(ii1) = .true.
  else
   mp_getij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getij_01

 function mp_getij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_getij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_20(ii1,ii2) = .true.
  else
   mp_getij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getij_20

 function mp_getij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_getij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_02(ii1,ii2) = .true.
  else
   mp_getij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getij_02

 function mp_getij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_getij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_11(ii1) = .true.
  else
   mp_getij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getij_11

 function mp_getij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_getij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getij_22(ii1,ii2) = .true.
  else
   mp_getij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getij_22

 function mp_getji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_getji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_10(ii1) = .true.
  else
   mp_getji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getji_10

 function mp_getji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_getji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_01(ii1) = .true.
  else
   mp_getji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getji_01

 function mp_getji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_getji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_20(ii1,ii2) = .true.
  else
   mp_getji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getji_20

 function mp_getji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_getji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_02(ii1,ii2) = .true.
  else
   mp_getji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getji_02

 function mp_getji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_getji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_11(ii1) = .true.
  else
   mp_getji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getji_11

 function mp_getji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_getji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getji_22(ii1,ii2) = .true.
  else
   mp_getji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getji_22

 function mp_getdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_getdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_10(ii1) = .true.
  else
   mp_getdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getdj_10

 function mp_getdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_getdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_01(ii1) = .true.
  else
   mp_getdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getdj_01

 function mp_getdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_getdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_20(ii1,ii2) = .true.
  else
   mp_getdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdj_20

 function mp_getdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_getdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_02(ii1,ii2) = .true.
  else
   mp_getdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdj_02

 function mp_getdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_getdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_11(ii1) = .true.
  else
   mp_getdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getdj_11

 function mp_getdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_getdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdj_22(ii1,ii2) = .true.
  else
   mp_getdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdj_22

 function mp_getjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_getjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_10(ii1) = .true.
  else
   mp_getjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getjd_10

 function mp_getjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_getjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_01(ii1) = .true.
  else
   mp_getjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getjd_01

 function mp_getjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_getjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_20(ii1,ii2) = .true.
  else
   mp_getjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjd_20

 function mp_getjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_getjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_02(ii1,ii2) = .true.
  else
   mp_getjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjd_02

 function mp_getjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_getjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_11(ii1) = .true.
  else
   mp_getjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getjd_11

 function mp_getjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_getjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getjd_22(ii1,ii2) = .true.
  else
   mp_getjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getjd_22

 !  MPI .LT. routines.

 function mp_lttjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_lttjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_10(ii1) = .true.
  else
   mp_lttjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjj_10

 function mp_lttjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_lttjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_01(ii1) = .true.
  else
   mp_lttjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjj_01

 function mp_lttjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_lttjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_20(ii1,ii2) = .true.
  else
   mp_lttjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjj_20

 function mp_lttjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_lttjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_02(ii1,ii2) = .true.
  else
   mp_lttjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjj_02

 function mp_lttjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_lttjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_11(ii1) = .true.
  else
   mp_lttjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjj_11

 function mp_lttjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_lttjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjj_22(ii1,ii2) = .true.
  else
   mp_lttjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjj_22

 function mp_lttjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_lttjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_10(ii1) = .true.
  else
   mp_lttjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjq_10

 function mp_lttjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_lttjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_01(ii1) = .true.
  else
   mp_lttjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjq_01

 function mp_lttjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_lttjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_20(ii1,ii2) = .true.
  else
   mp_lttjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjq_20

 function mp_lttjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_lttjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_02(ii1,ii2) = .true.
  else
   mp_lttjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjq_02

 function mp_lttjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_lttjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_11(ii1) = .true.
  else
   mp_lttjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjq_11

 function mp_lttjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_lttjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjq_22(ii1,ii2) = .true.
  else
   mp_lttjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjq_22

 function mp_lttij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_lttij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_10(ii1) = .true.
  else
   mp_lttij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttij_10

 function mp_lttij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_lttij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_01(ii1) = .true.
  else
   mp_lttij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttij_01

 function mp_lttij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_lttij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_20(ii1,ii2) = .true.
  else
   mp_lttij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttij_20

 function mp_lttij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_lttij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_02(ii1,ii2) = .true.
  else
   mp_lttij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttij_02

 function mp_lttij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_lttij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_11(ii1) = .true.
  else
   mp_lttij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttij_11

 function mp_lttij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_lttij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttij_22(ii1,ii2) = .true.
  else
   mp_lttij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttij_22

 function mp_lttji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_lttji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_10(ii1) = .true.
  else
   mp_lttji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttji_10

 function mp_lttji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_lttji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_01(ii1) = .true.
  else
   mp_lttji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttji_01

 function mp_lttji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_lttji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_20(ii1,ii2) = .true.
  else
   mp_lttji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttji_20

 function mp_lttji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_lttji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_02(ii1,ii2) = .true.
  else
   mp_lttji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttji_02

 function mp_lttji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_lttji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_11(ii1) = .true.
  else
   mp_lttji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttji_11

 function mp_lttji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_lttji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttji_22(ii1,ii2) = .true.
  else
   mp_lttji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttji_22

 function mp_lttdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_lttdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_10(ii1) = .true.
  else
   mp_lttdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdj_10

 function mp_lttdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_lttdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_01(ii1) = .true.
  else
   mp_lttdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdj_01

 function mp_lttdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_lttdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_20(ii1,ii2) = .true.
  else
   mp_lttdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdj_20

 function mp_lttdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_lttdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_02(ii1,ii2) = .true.
  else
   mp_lttdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdj_02

 function mp_lttdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_lttdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_11(ii1) = .true.
  else
   mp_lttdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdj_11

 function mp_lttdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_lttdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdj_22(ii1,ii2) = .true.
  else
   mp_lttdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdj_22

 function mp_lttjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_lttjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_10(ii1) = .true.
  else
   mp_lttjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjd_10

 function mp_lttjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_lttjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_01(ii1) = .true.
  else
   mp_lttjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjd_01

 function mp_lttjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_lttjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_20(ii1,ii2) = .true.
  else
   mp_lttjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjd_20

 function mp_lttjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_lttjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_02(ii1,ii2) = .true.
  else
   mp_lttjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjd_02

 function mp_lttjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_lttjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_11(ii1) = .true.
  else
   mp_lttjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttjd_11

 function mp_lttjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_lttjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttjd_22(ii1,ii2) = .true.
  else
   mp_lttjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttjd_22

 !  MPI .GT. routines.

 function mp_gttjj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_gttjj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_10(ii1) = .true.
  else
   mp_gttjj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjj_10

 function mp_gttjj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_gttjj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_01(ii1) = .true.
  else
   mp_gttjj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjj_01

 function mp_gttjj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_gttjj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_20(ii1,ii2) = .true.
  else
   mp_gttjj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjj_20

 function mp_gttjj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_gttjj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_02(ii1,ii2) = .true.
  else
   mp_gttjj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjj_02

 function mp_gttjj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_gttjj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_11(ii1) = .true.
  else
   mp_gttjj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjj_11

 function mp_gttjj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_gttjj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjj_22(ii1,ii2) = .true.
  else
   mp_gttjj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjj_22

 function mp_gttjq_10 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_10
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension mp_gttjq_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_10(ii1) = .true.
  else
   mp_gttjq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjq_10

 function mp_gttjq_01 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_01
  intent (in):: ja, qb
  integer mpnw
dimension qb(:)
dimension mp_gttjq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (ja%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_01(ii1) = .true.
  else
   mp_gttjq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjq_01

 function mp_gttjq_20 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_20
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension mp_gttjq_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_20(ii1,ii2) = .true.
  else
   mp_gttjq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjq_20

 function mp_gttjq_02 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_02
  intent (in):: ja, qb
  integer mpnw
dimension qb(:,:)
dimension mp_gttjq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (ja%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_02(ii1,ii2) = .true.
  else
   mp_gttjq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjq_02

 function mp_gttjq_11 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_11
  intent (in):: ja, qb
  integer mpnw
dimension ja(:)
dimension qb(:)
dimension mp_gttjq_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_11(ii1) = .true.
  else
   mp_gttjq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjq_11

 function mp_gttjq_22 (ja, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjq_22
  intent (in):: ja, qb
  integer mpnw
dimension ja(:,:)
dimension qb(:,:)
dimension mp_gttjq_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjq_22(ii1,ii2) = .true.
  else
   mp_gttjq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjq_22

 function mp_gttij_10 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_10
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_gttij_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_10(ii1) = .true.
  else
   mp_gttij_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttij_10

 function mp_gttij_01 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_01
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_gttij_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_01(ii1) = .true.
  else
   mp_gttij_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttij_01

 function mp_gttij_20 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_20
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_gttij_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_20(ii1,ii2) = .true.
  else
   mp_gttij_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttij_20

 function mp_gttij_02 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_02
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_gttij_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_02(ii1,ii2) = .true.
  else
   mp_gttij_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttij_02

 function mp_gttij_11 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_11
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension jb(:)
dimension mp_gttij_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_11(ii1) = .true.
  else
   mp_gttij_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttij_11

 function mp_gttij_22 (ia, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttij_22
  intent (in):: ia, jb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension jb(:,:)
dimension mp_gttij_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttij_22(ii1,ii2) = .true.
  else
   mp_gttij_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttij_22

 function mp_gttji_10 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_10
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_gttji_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_10(ii1) = .true.
  else
   mp_gttji_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttji_10

 function mp_gttji_01 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_01
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_gttji_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_01(ii1) = .true.
  else
   mp_gttji_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttji_01

 function mp_gttji_20 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_20
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_gttji_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_20(ii1,ii2) = .true.
  else
   mp_gttji_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttji_20

 function mp_gttji_02 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_02
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_gttji_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_02(ii1,ii2) = .true.
  else
   mp_gttji_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttji_02

 function mp_gttji_11 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_11
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension ib(:)
dimension mp_gttji_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_11(ii1) = .true.
  else
   mp_gttji_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttji_11

 function mp_gttji_22 (ja, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttji_22
  intent (in):: ja, ib
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension ib(:,:)
dimension mp_gttji_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttji_22(ii1,ii2) = .true.
  else
   mp_gttji_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttji_22

 function mp_gttdj_10 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_10
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_gttdj_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_10(ii1) = .true.
  else
   mp_gttdj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdj_10

 function mp_gttdj_01 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_01
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:)
dimension mp_gttdj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_01(ii1) = .true.
  else
   mp_gttdj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdj_01

 function mp_gttdj_20 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_20
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_gttdj_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_20(ii1,ii2) = .true.
  else
   mp_gttdj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdj_20

 function mp_gttdj_02 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_02
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension jb(:,:)
dimension mp_gttdj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_02(ii1,ii2) = .true.
  else
   mp_gttdj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdj_02

 function mp_gttdj_11 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_11
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension jb(:)
dimension mp_gttdj_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_11(ii1) = .true.
  else
   mp_gttdj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdj_11

 function mp_gttdj_22 (da, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdj_22
  intent (in):: da, jb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension jb(:,:)
dimension mp_gttdj_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdj_22(ii1,ii2) = .true.
  else
   mp_gttdj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdj_22

 function mp_gttjd_10 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_10
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension mp_gttjd_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_10(ii1) = .true.
  else
   mp_gttjd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjd_10

 function mp_gttjd_01 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_01
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_gttjd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_01(ii1) = .true.
  else
   mp_gttjd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjd_01

 function mp_gttjd_20 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_20
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension mp_gttjd_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_20(ii1,ii2) = .true.
  else
   mp_gttjd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjd_20

 function mp_gttjd_02 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_02
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_gttjd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_02(ii1,ii2) = .true.
  else
   mp_gttjd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjd_02

 function mp_gttjd_11 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_11
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:)
dimension db(:)
dimension mp_gttjd_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (ja(ii1)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_11(ii1) = .true.
  else
   mp_gttjd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttjd_11

 function mp_gttjd_22 (ja, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttjd_22
  intent (in):: ja, db
  type (mp_real) q1
  integer mpnw
dimension ja(:,:)
dimension db(:,:)
dimension mp_gttjd_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (ja(ii1,ii2)%mpi, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttjd_22(ii1,ii2) = .true.
  else
   mp_gttjd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttjd_22

end module mpintmodv


module mprealmodv

 !  This Fortran-90 module defines operator extensions involving the
 !  MP_REAL datatype.  For operations involving two MP data types,
 !  those whose first argument is MP_REAL are included here.
 !  Others are handled in other modules.

 !  The subroutines and functions defined in this module are private
 !  and not intended to be called directly by the user.

 use mpfunmod
 use mpdefmod
 private kdb, mp4, mp24, mp41
 parameter (kdb = kind (0.d0), mp4 = mpwds + 4, mp24 = 2 * mp4, mp41 = mp4 + 1)
private mp_gttqd_10, mp_gttqd_01, mp_gttqd_20, mp_gttqd_02, mp_gttqd_11, mp_gttqd_22
private mp_gttdq_10, mp_gttdq_01, mp_gttdq_20, mp_gttdq_02, mp_gttdq_11, mp_gttdq_22
private mp_gttqi_10, mp_gttqi_01, mp_gttqi_20, mp_gttqi_02, mp_gttqi_11, mp_gttqi_22
private mp_gttiq_10, mp_gttiq_01, mp_gttiq_20, mp_gttiq_02, mp_gttiq_11, mp_gttiq_22
private mp_gttqq_10, mp_gttqq_01, mp_gttqq_20, mp_gttqq_02, mp_gttqq_11, mp_gttqq_22
private mp_gttqj_10, mp_gttqj_01, mp_gttqj_20, mp_gttqj_02, mp_gttqj_11, mp_gttqj_22
private mp_lttqd_10, mp_lttqd_01, mp_lttqd_20, mp_lttqd_02, mp_lttqd_11, mp_lttqd_22
private mp_lttdq_10, mp_lttdq_01, mp_lttdq_20, mp_lttdq_02, mp_lttdq_11, mp_lttdq_22
private mp_lttqi_10, mp_lttqi_01, mp_lttqi_20, mp_lttqi_02, mp_lttqi_11, mp_lttqi_22
private mp_lttiq_10, mp_lttiq_01, mp_lttiq_20, mp_lttiq_02, mp_lttiq_11, mp_lttiq_22
private mp_lttqq_10, mp_lttqq_01, mp_lttqq_20, mp_lttqq_02, mp_lttqq_11, mp_lttqq_22
private mp_lttqj_10, mp_lttqj_01, mp_lttqj_20, mp_lttqj_02, mp_lttqj_11, mp_lttqj_22
private mp_getqd_10, mp_getqd_01, mp_getqd_20, mp_getqd_02, mp_getqd_11, mp_getqd_22
private mp_getdq_10, mp_getdq_01, mp_getdq_20, mp_getdq_02, mp_getdq_11, mp_getdq_22
private mp_getqi_10, mp_getqi_01, mp_getqi_20, mp_getqi_02, mp_getqi_11, mp_getqi_22
private mp_getiq_10, mp_getiq_01, mp_getiq_20, mp_getiq_02, mp_getiq_11, mp_getiq_22
private mp_getqq_10, mp_getqq_01, mp_getqq_20, mp_getqq_02, mp_getqq_11, mp_getqq_22
private mp_getqj_10, mp_getqj_01, mp_getqj_20, mp_getqj_02, mp_getqj_11, mp_getqj_22
private mp_letqd_10, mp_letqd_01, mp_letqd_20, mp_letqd_02, mp_letqd_11, mp_letqd_22
private mp_letdq_10, mp_letdq_01, mp_letdq_20, mp_letdq_02, mp_letdq_11, mp_letdq_22
private mp_letqi_10, mp_letqi_01, mp_letqi_20, mp_letqi_02, mp_letqi_11, mp_letqi_22
private mp_letiq_10, mp_letiq_01, mp_letiq_20, mp_letiq_02, mp_letiq_11, mp_letiq_22
private mp_letqq_10, mp_letqq_01, mp_letqq_20, mp_letqq_02, mp_letqq_11, mp_letqq_22
private mp_letqj_10, mp_letqj_01, mp_letqj_20, mp_letqj_02, mp_letqj_11, mp_letqj_22
private mp_netqx_10, mp_netqx_01, mp_netqx_20, mp_netqx_02, mp_netqx_11, mp_netqx_22
private mp_netxq_10, mp_netxq_01, mp_netxq_20, mp_netxq_02, mp_netxq_11, mp_netxq_22
private mp_netqd_10, mp_netqd_01, mp_netqd_20, mp_netqd_02, mp_netqd_11, mp_netqd_22
private mp_netdq_10, mp_netdq_01, mp_netdq_20, mp_netdq_02, mp_netdq_11, mp_netdq_22
private mp_netqi_10, mp_netqi_01, mp_netqi_20, mp_netqi_02, mp_netqi_11, mp_netqi_22
private mp_netiq_10, mp_netiq_01, mp_netiq_20, mp_netiq_02, mp_netiq_11, mp_netiq_22
private mp_netqz_10, mp_netqz_01, mp_netqz_20, mp_netqz_02, mp_netqz_11, mp_netqz_22
private mp_netqq_10, mp_netqq_01, mp_netqq_20, mp_netqq_02, mp_netqq_11, mp_netqq_22
private mp_netqj_10, mp_netqj_01, mp_netqj_20, mp_netqj_02, mp_netqj_11, mp_netqj_22
private mp_eqtqx_10, mp_eqtqx_01, mp_eqtqx_20, mp_eqtqx_02, mp_eqtqx_11, mp_eqtqx_22
private mp_eqtxq_10, mp_eqtxq_01, mp_eqtxq_20, mp_eqtxq_02, mp_eqtxq_11, mp_eqtxq_22
private mp_eqtqd_10, mp_eqtqd_01, mp_eqtqd_20, mp_eqtqd_02, mp_eqtqd_11, mp_eqtqd_22
private mp_eqtdq_10, mp_eqtdq_01, mp_eqtdq_20, mp_eqtdq_02, mp_eqtdq_11, mp_eqtdq_22
private mp_eqtqi_10, mp_eqtqi_01, mp_eqtqi_20, mp_eqtqi_02, mp_eqtqi_11, mp_eqtqi_22
private mp_eqtiq_10, mp_eqtiq_01, mp_eqtiq_20, mp_eqtiq_02, mp_eqtiq_11, mp_eqtiq_22
private mp_eqtqz_10, mp_eqtqz_01, mp_eqtqz_20, mp_eqtqz_02, mp_eqtqz_11, mp_eqtqz_22
private mp_eqtqq_10, mp_eqtqq_01, mp_eqtqq_20, mp_eqtqq_02, mp_eqtqq_11, mp_eqtqq_22
private mp_eqtqj_10, mp_eqtqj_01, mp_eqtqj_20, mp_eqtqj_02, mp_eqtqj_11, mp_eqtqj_22
private mp_expqd_10, mp_expqd_01, mp_expqd_20, mp_expqd_02, mp_expqd_11, mp_expqd_22
private mp_expdq_10, mp_expdq_01, mp_expdq_20, mp_expdq_02, mp_expdq_11, mp_expdq_22
private mp_expqi_10, mp_expqi_01, mp_expqi_20, mp_expqi_02, mp_expqi_11, mp_expqi_22
private mp_expiq_10, mp_expiq_01, mp_expiq_20, mp_expiq_02, mp_expiq_11, mp_expiq_22
private mp_expqq_10, mp_expqq_01, mp_expqq_20, mp_expqq_02, mp_expqq_11, mp_expqq_22
private mp_expqj_10, mp_expqj_01, mp_expqj_20, mp_expqj_02, mp_expqj_11, mp_expqj_22
private mp_divqx_10, mp_divqx_01, mp_divqx_20, mp_divqx_02, mp_divqx_11, mp_divqx_22
private mp_divxq_10, mp_divxq_01, mp_divxq_20, mp_divxq_02, mp_divxq_11, mp_divxq_22
private mp_divqd_10, mp_divqd_01, mp_divqd_20, mp_divqd_02, mp_divqd_11, mp_divqd_22
private mp_divdq_10, mp_divdq_01, mp_divdq_20, mp_divdq_02, mp_divdq_11, mp_divdq_22
private mp_divqi_10, mp_divqi_01, mp_divqi_20, mp_divqi_02, mp_divqi_11, mp_divqi_22
private mp_diviq_10, mp_diviq_01, mp_diviq_20, mp_diviq_02, mp_diviq_11, mp_diviq_22
private mp_divqz_10, mp_divqz_01, mp_divqz_20, mp_divqz_02, mp_divqz_11, mp_divqz_22
private mp_divqq_10, mp_divqq_01, mp_divqq_20, mp_divqq_02, mp_divqq_11, mp_divqq_22
private mp_divqj_10, mp_divqj_01, mp_divqj_20, mp_divqj_02, mp_divqj_11, mp_divqj_22
private mp_mulqx_10, mp_mulqx_01, mp_mulqx_20, mp_mulqx_02, mp_mulqx_11, mp_mulqx_22
private mp_mulxq_10, mp_mulxq_01, mp_mulxq_20, mp_mulxq_02, mp_mulxq_11, mp_mulxq_22
private mp_mulqd_10, mp_mulqd_01, mp_mulqd_20, mp_mulqd_02, mp_mulqd_11, mp_mulqd_22
private mp_muldq_10, mp_muldq_01, mp_muldq_20, mp_muldq_02, mp_muldq_11, mp_muldq_22
private mp_mulqi_10, mp_mulqi_01, mp_mulqi_20, mp_mulqi_02, mp_mulqi_11, mp_mulqi_22
private mp_muliq_10, mp_muliq_01, mp_muliq_20, mp_muliq_02, mp_muliq_11, mp_muliq_22
private mp_mulqz_10, mp_mulqz_01, mp_mulqz_20, mp_mulqz_02, mp_mulqz_11, mp_mulqz_22
private mp_mulqq_10, mp_mulqq_01, mp_mulqq_20, mp_mulqq_02, mp_mulqq_11, mp_mulqq_22
private mp_mulqj_10, mp_mulqj_01, mp_mulqj_20, mp_mulqj_02, mp_mulqj_11, mp_mulqj_22
private mp_negq_1, mp_negq_2
private mp_subqx_10, mp_subqx_01, mp_subqx_20, mp_subqx_02, mp_subqx_11, mp_subqx_22
private mp_subxq_10, mp_subxq_01, mp_subxq_20, mp_subxq_02, mp_subxq_11, mp_subxq_22
private mp_subqd_10, mp_subqd_01, mp_subqd_20, mp_subqd_02, mp_subqd_11, mp_subqd_22
private mp_subdq_10, mp_subdq_01, mp_subdq_20, mp_subdq_02, mp_subdq_11, mp_subdq_22
private mp_subqi_10, mp_subqi_01, mp_subqi_20, mp_subqi_02, mp_subqi_11, mp_subqi_22
private mp_subiq_10, mp_subiq_01, mp_subiq_20, mp_subiq_02, mp_subiq_11, mp_subiq_22
private mp_subqz_10, mp_subqz_01, mp_subqz_20, mp_subqz_02, mp_subqz_11, mp_subqz_22
private mp_subqq_10, mp_subqq_01, mp_subqq_20, mp_subqq_02, mp_subqq_11, mp_subqq_22
private mp_subqj_10, mp_subqj_01, mp_subqj_20, mp_subqj_02, mp_subqj_11, mp_subqj_22
private mp_addqx_10, mp_addqx_01, mp_addqx_20, mp_addqx_02, mp_addqx_11, mp_addqx_22
private mp_addxq_10, mp_addxq_01, mp_addxq_20, mp_addxq_02, mp_addxq_11, mp_addxq_22
private mp_addqd_10, mp_addqd_01, mp_addqd_20, mp_addqd_02, mp_addqd_11, mp_addqd_22
private mp_adddq_10, mp_adddq_01, mp_adddq_20, mp_adddq_02, mp_adddq_11, mp_adddq_22
private mp_addqi_10, mp_addqi_01, mp_addqi_20, mp_addqi_02, mp_addqi_11, mp_addqi_22
private mp_addiq_10, mp_addiq_01, mp_addiq_20, mp_addiq_02, mp_addiq_11, mp_addiq_22
private mp_addqz_10, mp_addqz_01, mp_addqz_20, mp_addqz_02, mp_addqz_11, mp_addqz_22
private mp_addqq_10, mp_addqq_01, mp_addqq_20, mp_addqq_02, mp_addqq_11, mp_addqq_22
private mp_addqj_10, mp_addqj_01, mp_addqj_20, mp_addqj_02, mp_addqj_11, mp_addqj_22
private mp_eqqa_10, mp_eqqa_11, mp_eqqa_20, mp_eqqa_22
private mp_eqqx_10, mp_eqqx_11, mp_eqqx_20, mp_eqqx_22
private mp_eqxq_10, mp_eqxq_11, mp_eqxq_20, mp_eqxq_22
private mp_eqqd_10, mp_eqqd_11, mp_eqqd_20, mp_eqqd_22
private mp_eqdq_10, mp_eqdq_11, mp_eqdq_20, mp_eqdq_22
private mp_eqqi_10, mp_eqqi_11, mp_eqqi_20, mp_eqqi_22
private mp_eqiq_10, mp_eqiq_11, mp_eqiq_20, mp_eqiq_22
private mp_eqqz_10, mp_eqqz_11, mp_eqqz_20, mp_eqqz_22
private mp_eqqq_10, mp_eqqq_11, mp_eqqq_20, mp_eqqq_22
private mp_eqqj_10, mp_eqqj_11, mp_eqqj_20, mp_eqqj_22

 !  MPR operator extension interface blocks.

 interface assignment (=)
module procedure mp_eqqj_10
module procedure mp_eqqj_11
module procedure mp_eqqj_20
module procedure mp_eqqj_22
module procedure mp_eqqq_10
module procedure mp_eqqq_11
module procedure mp_eqqq_20
module procedure mp_eqqq_22
module procedure mp_eqqz_10
module procedure mp_eqqz_11
module procedure mp_eqqz_20
module procedure mp_eqqz_22
module procedure mp_eqiq_10
module procedure mp_eqiq_11
module procedure mp_eqiq_20
module procedure mp_eqiq_22
module procedure mp_eqqi_10
module procedure mp_eqqi_11
module procedure mp_eqqi_20
module procedure mp_eqqi_22
module procedure mp_eqdq_10
module procedure mp_eqdq_11
module procedure mp_eqdq_20
module procedure mp_eqdq_22
module procedure mp_eqqd_10
module procedure mp_eqqd_11
module procedure mp_eqqd_20
module procedure mp_eqqd_22
module procedure mp_eqxq_10
module procedure mp_eqxq_11
module procedure mp_eqxq_20
module procedure mp_eqxq_22
module procedure mp_eqqx_10
module procedure mp_eqqx_11
module procedure mp_eqqx_20
module procedure mp_eqqx_22
module procedure mp_eqqa_10
module procedure mp_eqqa_11
module procedure mp_eqqa_20
module procedure mp_eqqa_22
 end interface

 interface operator (+)
module procedure mp_addqj_10
module procedure mp_addqj_01
module procedure mp_addqj_20
module procedure mp_addqj_02
module procedure mp_addqj_11
module procedure mp_addqj_22
module procedure mp_addqq_10
module procedure mp_addqq_01
module procedure mp_addqq_20
module procedure mp_addqq_02
module procedure mp_addqq_11
module procedure mp_addqq_22
module procedure mp_addqz_10
module procedure mp_addqz_01
module procedure mp_addqz_20
module procedure mp_addqz_02
module procedure mp_addqz_11
module procedure mp_addqz_22
module procedure mp_addiq_10
module procedure mp_addiq_01
module procedure mp_addiq_20
module procedure mp_addiq_02
module procedure mp_addiq_11
module procedure mp_addiq_22
module procedure mp_addqi_10
module procedure mp_addqi_01
module procedure mp_addqi_20
module procedure mp_addqi_02
module procedure mp_addqi_11
module procedure mp_addqi_22
module procedure mp_adddq_10
module procedure mp_adddq_01
module procedure mp_adddq_20
module procedure mp_adddq_02
module procedure mp_adddq_11
module procedure mp_adddq_22
module procedure mp_addqd_10
module procedure mp_addqd_01
module procedure mp_addqd_20
module procedure mp_addqd_02
module procedure mp_addqd_11
module procedure mp_addqd_22
module procedure mp_addxq_10
module procedure mp_addxq_01
module procedure mp_addxq_20
module procedure mp_addxq_02
module procedure mp_addxq_11
module procedure mp_addxq_22
module procedure mp_addqx_10
module procedure mp_addqx_01
module procedure mp_addqx_20
module procedure mp_addqx_02
module procedure mp_addqx_11
module procedure mp_addqx_22
 end interface

 interface operator (-)
module procedure mp_subqj_10
module procedure mp_subqj_01
module procedure mp_subqj_20
module procedure mp_subqj_02
module procedure mp_subqj_11
module procedure mp_subqj_22
module procedure mp_subqq_10
module procedure mp_subqq_01
module procedure mp_subqq_20
module procedure mp_subqq_02
module procedure mp_subqq_11
module procedure mp_subqq_22
module procedure mp_subqz_10
module procedure mp_subqz_01
module procedure mp_subqz_20
module procedure mp_subqz_02
module procedure mp_subqz_11
module procedure mp_subqz_22
module procedure mp_subiq_10
module procedure mp_subiq_01
module procedure mp_subiq_20
module procedure mp_subiq_02
module procedure mp_subiq_11
module procedure mp_subiq_22
module procedure mp_subqi_10
module procedure mp_subqi_01
module procedure mp_subqi_20
module procedure mp_subqi_02
module procedure mp_subqi_11
module procedure mp_subqi_22
module procedure mp_subdq_10
module procedure mp_subdq_01
module procedure mp_subdq_20
module procedure mp_subdq_02
module procedure mp_subdq_11
module procedure mp_subdq_22
module procedure mp_subqd_10
module procedure mp_subqd_01
module procedure mp_subqd_20
module procedure mp_subqd_02
module procedure mp_subqd_11
module procedure mp_subqd_22
module procedure mp_subxq_10
module procedure mp_subxq_01
module procedure mp_subxq_20
module procedure mp_subxq_02
module procedure mp_subxq_11
module procedure mp_subxq_22
module procedure mp_subqx_10
module procedure mp_subqx_01
module procedure mp_subqx_20
module procedure mp_subqx_02
module procedure mp_subqx_11
module procedure mp_subqx_22
module procedure mp_negq_1
module procedure mp_negq_2
 end interface

 interface operator (*)
module procedure mp_mulqj_10
module procedure mp_mulqj_01
module procedure mp_mulqj_20
module procedure mp_mulqj_02
module procedure mp_mulqj_11
module procedure mp_mulqj_22
module procedure mp_mulqq_10
module procedure mp_mulqq_01
module procedure mp_mulqq_20
module procedure mp_mulqq_02
module procedure mp_mulqq_11
module procedure mp_mulqq_22
module procedure mp_mulqz_10
module procedure mp_mulqz_01
module procedure mp_mulqz_20
module procedure mp_mulqz_02
module procedure mp_mulqz_11
module procedure mp_mulqz_22
module procedure mp_muliq_10
module procedure mp_muliq_01
module procedure mp_muliq_20
module procedure mp_muliq_02
module procedure mp_muliq_11
module procedure mp_muliq_22
module procedure mp_mulqi_10
module procedure mp_mulqi_01
module procedure mp_mulqi_20
module procedure mp_mulqi_02
module procedure mp_mulqi_11
module procedure mp_mulqi_22
module procedure mp_muldq_10
module procedure mp_muldq_01
module procedure mp_muldq_20
module procedure mp_muldq_02
module procedure mp_muldq_11
module procedure mp_muldq_22
module procedure mp_mulqd_10
module procedure mp_mulqd_01
module procedure mp_mulqd_20
module procedure mp_mulqd_02
module procedure mp_mulqd_11
module procedure mp_mulqd_22
module procedure mp_mulxq_10
module procedure mp_mulxq_01
module procedure mp_mulxq_20
module procedure mp_mulxq_02
module procedure mp_mulxq_11
module procedure mp_mulxq_22
module procedure mp_mulqx_10
module procedure mp_mulqx_01
module procedure mp_mulqx_20
module procedure mp_mulqx_02
module procedure mp_mulqx_11
module procedure mp_mulqx_22
 end interface

 interface operator (/)
module procedure mp_divqj_10
module procedure mp_divqj_01
module procedure mp_divqj_20
module procedure mp_divqj_02
module procedure mp_divqj_11
module procedure mp_divqj_22
module procedure mp_divqq_10
module procedure mp_divqq_01
module procedure mp_divqq_20
module procedure mp_divqq_02
module procedure mp_divqq_11
module procedure mp_divqq_22
module procedure mp_divqz_10
module procedure mp_divqz_01
module procedure mp_divqz_20
module procedure mp_divqz_02
module procedure mp_divqz_11
module procedure mp_divqz_22
module procedure mp_diviq_10
module procedure mp_diviq_01
module procedure mp_diviq_20
module procedure mp_diviq_02
module procedure mp_diviq_11
module procedure mp_diviq_22
module procedure mp_divqi_10
module procedure mp_divqi_01
module procedure mp_divqi_20
module procedure mp_divqi_02
module procedure mp_divqi_11
module procedure mp_divqi_22
module procedure mp_divdq_10
module procedure mp_divdq_01
module procedure mp_divdq_20
module procedure mp_divdq_02
module procedure mp_divdq_11
module procedure mp_divdq_22
module procedure mp_divqd_10
module procedure mp_divqd_01
module procedure mp_divqd_20
module procedure mp_divqd_02
module procedure mp_divqd_11
module procedure mp_divqd_22
module procedure mp_divxq_10
module procedure mp_divxq_01
module procedure mp_divxq_20
module procedure mp_divxq_02
module procedure mp_divxq_11
module procedure mp_divxq_22
module procedure mp_divqx_10
module procedure mp_divqx_01
module procedure mp_divqx_20
module procedure mp_divqx_02
module procedure mp_divqx_11
module procedure mp_divqx_22
 end interface

 interface operator (**)
module procedure mp_expqj_10
module procedure mp_expqj_01
module procedure mp_expqj_20
module procedure mp_expqj_02
module procedure mp_expqj_11
module procedure mp_expqj_22
module procedure mp_expqq_10
module procedure mp_expqq_01
module procedure mp_expqq_20
module procedure mp_expqq_02
module procedure mp_expqq_11
module procedure mp_expqq_22
module procedure mp_expiq_10
module procedure mp_expiq_01
module procedure mp_expiq_20
module procedure mp_expiq_02
module procedure mp_expiq_11
module procedure mp_expiq_22
module procedure mp_expqi_10
module procedure mp_expqi_01
module procedure mp_expqi_20
module procedure mp_expqi_02
module procedure mp_expqi_11
module procedure mp_expqi_22
module procedure mp_expdq_10
module procedure mp_expdq_01
module procedure mp_expdq_20
module procedure mp_expdq_02
module procedure mp_expdq_11
module procedure mp_expdq_22
module procedure mp_expqd_10
module procedure mp_expqd_01
module procedure mp_expqd_20
module procedure mp_expqd_02
module procedure mp_expqd_11
module procedure mp_expqd_22
 end interface

 interface operator (.eq.)
module procedure mp_eqtqj_10
module procedure mp_eqtqj_01
module procedure mp_eqtqj_20
module procedure mp_eqtqj_02
module procedure mp_eqtqj_11
module procedure mp_eqtqj_22
module procedure mp_eqtqq_10
module procedure mp_eqtqq_01
module procedure mp_eqtqq_20
module procedure mp_eqtqq_02
module procedure mp_eqtqq_11
module procedure mp_eqtqq_22
module procedure mp_eqtqz_10
module procedure mp_eqtqz_01
module procedure mp_eqtqz_20
module procedure mp_eqtqz_02
module procedure mp_eqtqz_11
module procedure mp_eqtqz_22
module procedure mp_eqtiq_10
module procedure mp_eqtiq_01
module procedure mp_eqtiq_20
module procedure mp_eqtiq_02
module procedure mp_eqtiq_11
module procedure mp_eqtiq_22
module procedure mp_eqtqi_10
module procedure mp_eqtqi_01
module procedure mp_eqtqi_20
module procedure mp_eqtqi_02
module procedure mp_eqtqi_11
module procedure mp_eqtqi_22
module procedure mp_eqtdq_10
module procedure mp_eqtdq_01
module procedure mp_eqtdq_20
module procedure mp_eqtdq_02
module procedure mp_eqtdq_11
module procedure mp_eqtdq_22
module procedure mp_eqtqd_10
module procedure mp_eqtqd_01
module procedure mp_eqtqd_20
module procedure mp_eqtqd_02
module procedure mp_eqtqd_11
module procedure mp_eqtqd_22
module procedure mp_eqtxq_10
module procedure mp_eqtxq_01
module procedure mp_eqtxq_20
module procedure mp_eqtxq_02
module procedure mp_eqtxq_11
module procedure mp_eqtxq_22
module procedure mp_eqtqx_10
module procedure mp_eqtqx_01
module procedure mp_eqtqx_20
module procedure mp_eqtqx_02
module procedure mp_eqtqx_11
module procedure mp_eqtqx_22
 end interface

 interface operator (.ne.)
module procedure mp_netqj_10
module procedure mp_netqj_01
module procedure mp_netqj_20
module procedure mp_netqj_02
module procedure mp_netqj_11
module procedure mp_netqj_22
module procedure mp_netqq_10
module procedure mp_netqq_01
module procedure mp_netqq_20
module procedure mp_netqq_02
module procedure mp_netqq_11
module procedure mp_netqq_22
module procedure mp_netqz_10
module procedure mp_netqz_01
module procedure mp_netqz_20
module procedure mp_netqz_02
module procedure mp_netqz_11
module procedure mp_netqz_22
module procedure mp_netiq_10
module procedure mp_netiq_01
module procedure mp_netiq_20
module procedure mp_netiq_02
module procedure mp_netiq_11
module procedure mp_netiq_22
module procedure mp_netqi_10
module procedure mp_netqi_01
module procedure mp_netqi_20
module procedure mp_netqi_02
module procedure mp_netqi_11
module procedure mp_netqi_22
module procedure mp_netdq_10
module procedure mp_netdq_01
module procedure mp_netdq_20
module procedure mp_netdq_02
module procedure mp_netdq_11
module procedure mp_netdq_22
module procedure mp_netqd_10
module procedure mp_netqd_01
module procedure mp_netqd_20
module procedure mp_netqd_02
module procedure mp_netqd_11
module procedure mp_netqd_22
module procedure mp_netxq_10
module procedure mp_netxq_01
module procedure mp_netxq_20
module procedure mp_netxq_02
module procedure mp_netxq_11
module procedure mp_netxq_22
module procedure mp_netqx_10
module procedure mp_netqx_01
module procedure mp_netqx_20
module procedure mp_netqx_02
module procedure mp_netqx_11
module procedure mp_netqx_22
 end interface

 interface operator (.le.)
module procedure mp_letqj_10
module procedure mp_letqj_01
module procedure mp_letqj_20
module procedure mp_letqj_02
module procedure mp_letqj_11
module procedure mp_letqj_22
module procedure mp_letqq_10
module procedure mp_letqq_01
module procedure mp_letqq_20
module procedure mp_letqq_02
module procedure mp_letqq_11
module procedure mp_letqq_22
module procedure mp_letiq_10
module procedure mp_letiq_01
module procedure mp_letiq_20
module procedure mp_letiq_02
module procedure mp_letiq_11
module procedure mp_letiq_22
module procedure mp_letqi_10
module procedure mp_letqi_01
module procedure mp_letqi_20
module procedure mp_letqi_02
module procedure mp_letqi_11
module procedure mp_letqi_22
module procedure mp_letdq_10
module procedure mp_letdq_01
module procedure mp_letdq_20
module procedure mp_letdq_02
module procedure mp_letdq_11
module procedure mp_letdq_22
module procedure mp_letqd_10
module procedure mp_letqd_01
module procedure mp_letqd_20
module procedure mp_letqd_02
module procedure mp_letqd_11
module procedure mp_letqd_22
 end interface

 interface operator (.ge.)
module procedure mp_getqj_10
module procedure mp_getqj_01
module procedure mp_getqj_20
module procedure mp_getqj_02
module procedure mp_getqj_11
module procedure mp_getqj_22
module procedure mp_getqq_10
module procedure mp_getqq_01
module procedure mp_getqq_20
module procedure mp_getqq_02
module procedure mp_getqq_11
module procedure mp_getqq_22
module procedure mp_getiq_10
module procedure mp_getiq_01
module procedure mp_getiq_20
module procedure mp_getiq_02
module procedure mp_getiq_11
module procedure mp_getiq_22
module procedure mp_getqi_10
module procedure mp_getqi_01
module procedure mp_getqi_20
module procedure mp_getqi_02
module procedure mp_getqi_11
module procedure mp_getqi_22
module procedure mp_getdq_10
module procedure mp_getdq_01
module procedure mp_getdq_20
module procedure mp_getdq_02
module procedure mp_getdq_11
module procedure mp_getdq_22
module procedure mp_getqd_10
module procedure mp_getqd_01
module procedure mp_getqd_20
module procedure mp_getqd_02
module procedure mp_getqd_11
module procedure mp_getqd_22
 end interface

 interface operator (.lt.)
module procedure mp_lttqj_10
module procedure mp_lttqj_01
module procedure mp_lttqj_20
module procedure mp_lttqj_02
module procedure mp_lttqj_11
module procedure mp_lttqj_22
module procedure mp_lttqq_10
module procedure mp_lttqq_01
module procedure mp_lttqq_20
module procedure mp_lttqq_02
module procedure mp_lttqq_11
module procedure mp_lttqq_22
module procedure mp_lttiq_10
module procedure mp_lttiq_01
module procedure mp_lttiq_20
module procedure mp_lttiq_02
module procedure mp_lttiq_11
module procedure mp_lttiq_22
module procedure mp_lttqi_10
module procedure mp_lttqi_01
module procedure mp_lttqi_20
module procedure mp_lttqi_02
module procedure mp_lttqi_11
module procedure mp_lttqi_22
module procedure mp_lttdq_10
module procedure mp_lttdq_01
module procedure mp_lttdq_20
module procedure mp_lttdq_02
module procedure mp_lttdq_11
module procedure mp_lttdq_22
module procedure mp_lttqd_10
module procedure mp_lttqd_01
module procedure mp_lttqd_20
module procedure mp_lttqd_02
module procedure mp_lttqd_11
module procedure mp_lttqd_22
 end interface

 interface operator (.gt.)
module procedure mp_gttqj_10
module procedure mp_gttqj_01
module procedure mp_gttqj_20
module procedure mp_gttqj_02
module procedure mp_gttqj_11
module procedure mp_gttqj_22
module procedure mp_gttqq_10
module procedure mp_gttqq_01
module procedure mp_gttqq_20
module procedure mp_gttqq_02
module procedure mp_gttqq_11
module procedure mp_gttqq_22
module procedure mp_gttiq_10
module procedure mp_gttiq_01
module procedure mp_gttiq_20
module procedure mp_gttiq_02
module procedure mp_gttiq_11
module procedure mp_gttiq_22
module procedure mp_gttqi_10
module procedure mp_gttqi_01
module procedure mp_gttqi_20
module procedure mp_gttqi_02
module procedure mp_gttqi_11
module procedure mp_gttqi_22
module procedure mp_gttdq_10
module procedure mp_gttdq_01
module procedure mp_gttdq_20
module procedure mp_gttdq_02
module procedure mp_gttdq_11
module procedure mp_gttdq_22
module procedure mp_gttqd_10
module procedure mp_gttqd_01
module procedure mp_gttqd_20
module procedure mp_gttqd_02
module procedure mp_gttqd_11
module procedure mp_gttqd_22
 end interface

contains

 !  MPR assignment routines.

 subroutine mp_eqqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: jb
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (jb%mpi, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqj_10

 subroutine mp_eqqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: jb
  integer mpnw
dimension qa(:)
dimension jb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (jb(ii1)%mpi, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqj_11

 subroutine mp_eqqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: jb
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (jb%mpi, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqj_20

 subroutine mp_eqqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (jb(ii1,ii2)%mpi, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqj_22

 subroutine mp_eqqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: qb
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (qb%mpr, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqq_10

 subroutine mp_eqqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: qb
  integer mpnw
dimension qa(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (qb(ii1)%mpr, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqq_11

 subroutine mp_eqqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: qb
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (qb%mpr, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqq_20

 subroutine mp_eqqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (qb(ii1,ii2)%mpr, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqq_22

 subroutine mp_eqqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: zb
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (zb%mpc, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqz_10

 subroutine mp_eqqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: zb
  integer mpnw
dimension qa(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (zb(ii1)%mpc, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqz_11

 subroutine mp_eqqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: zb
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (zb%mpc, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqz_20

 subroutine mp_eqqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: zb
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (zb(ii1,ii2)%mpc, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqz_22

 subroutine mp_eqiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: qb
  integer mpnw
dimension ia(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (qb%mpr, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqiq_10

 subroutine mp_eqiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: qb
  integer mpnw
dimension ia(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (qb(ii1)%mpr, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqiq_11

 subroutine mp_eqiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: qb
  integer mpnw
dimension ia(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (qb%mpr, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqiq_20

 subroutine mp_eqiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: qb
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqiq_22

 subroutine mp_eqqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: ib
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqi_10

 subroutine mp_eqqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: ib
  integer mpnw
dimension qa(:)
dimension ib(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqi_11

 subroutine mp_eqqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: ib
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqi_20

 subroutine mp_eqqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: ib
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqi_22

 subroutine mp_eqdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: qb
  integer mpnw
dimension da(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (qb%mpr, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdq_10

 subroutine mp_eqdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: qb
  integer mpnw
dimension da(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (qb(ii1)%mpr, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdq_11

 subroutine mp_eqdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: qb
  integer mpnw
dimension da(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (qb%mpr, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdq_20

 subroutine mp_eqdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: qb
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdq_22

 subroutine mp_eqqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: db
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqd_10

 subroutine mp_eqqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: db
  integer mpnw
dimension qa(:)
dimension db(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqd_11

 subroutine mp_eqqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: db
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqd_20

 subroutine mp_eqqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: db
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqd_22

 subroutine mp_eqxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: qb
  integer mpnw
dimension xa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (qb%mpr, db, ib)
  xa(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqxq_10

 subroutine mp_eqxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: qb
  integer mpnw
dimension xa(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (qb(ii1)%mpr, db, ib)
  xa(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqxq_11

 subroutine mp_eqxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: qb
  integer mpnw
dimension xa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (qb%mpr, db, ib)
  xa(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqxq_20

 subroutine mp_eqxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: qb
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  xa(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqxq_22

 subroutine mp_eqqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: xb
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = xb
  call mpdmc (db, 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqx_10

 subroutine mp_eqqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: xb
  integer mpnw
dimension qa(:)
dimension xb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = xb(ii1)
  call mpdmc (db, 0, qa(ii1)%mpr)
end do 
  return
 end subroutine mp_eqqx_11

 subroutine mp_eqqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: xb
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = xb
  call mpdmc (db, 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqx_20

 subroutine mp_eqqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: qa
  intent (in):: xb
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = xb(ii1,ii2)
  call mpdmc (db, 0, qa(ii1,ii2)%mpr)
end do 
end do 
  return
 end subroutine mp_eqqx_22

 subroutine mp_eqqa_10 (qa, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: qa
  character*1 az(mpipl+100)
  integer mpnw
dimension qa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  l = len (ab)
  do i = 1, l
   az(i) = ab(i:i)
  enddo
  call mpdexc (az, l, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqa_10

 subroutine mp_eqqa_11 (qa, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: qa
  character*1 az(mpipl+100)
  integer mpnw
dimension qa(:)
dimension ab(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  l = len (ab(ii1))
  do i = 1, l
   az(i) = ab(ii1)(i:i)
  enddo
  call mpdexc (az, l, qa(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_eqqa_11

 subroutine mp_eqqa_20 (qa, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: qa
  character*1 az(mpipl+100)
  integer mpnw
dimension qa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  l = len (ab)
  do i = 1, l
   az(i) = ab(i:i)
  enddo
  call mpdexc (az, l, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqa_20

 subroutine mp_eqqa_22 (qa, ab)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: ab
  intent (out):: qa
  character*1 az(mpipl+100)
  integer mpnw
dimension qa(:,:)
dimension ab(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  l = len (ab(ii1,ii2))
  do i = 1, l
   az(i) = ab(ii1,ii2)(i:i)
  enddo
  call mpdexc (az, l, qa(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqqa_22

 !  MPR add routines.

 function mp_addqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_addqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpadd (qa(ii1)%mpr, jb%mpi, mp_addqj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqj_10

 function mp_addqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_addqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpadd (qa%mpr, jb(ii1)%mpi, mp_addqj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqj_01

 function mp_addqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_addqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpadd (qa(ii1,ii2)%mpr, jb%mpi, mp_addqj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqj_20

 function mp_addqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_addqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpadd (qa%mpr, jb(ii1,ii2)%mpi, mp_addqj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqj_02

 function mp_addqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_addqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpadd (qa(ii1)%mpr, jb(ii1)%mpi, mp_addqj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqj_11

 function mp_addqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_addqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpadd (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, mp_addqj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqj_22

 function mp_addqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_addqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpadd (qa(ii1)%mpr, qb%mpr, mp_addqq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqq_10

 function mp_addqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_addqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpadd (qa%mpr, qb(ii1)%mpr, mp_addqq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqq_01

 function mp_addqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_addqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpadd (qa(ii1,ii2)%mpr, qb%mpr, mp_addqq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqq_20

 function mp_addqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_addqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpadd (qa%mpr, qb(ii1,ii2)%mpr, mp_addqq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqq_02

 function mp_addqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_addqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpadd (qa(ii1)%mpr, qb(ii1)%mpr, mp_addqq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqq_11

 function mp_addqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_addqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpadd (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, mp_addqq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqq_22

 function mp_addqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_addqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addqz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqz_10

 function mp_addqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_addqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addqz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqz_01

 function mp_addqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_addqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addqz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqz_20

 function mp_addqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_addqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addqz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqz_02

 function mp_addqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_addqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addqz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqz_11

 function mp_addqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_addqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addqz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqz_22

 function mp_addiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_addiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb%mpr, mp_addiq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addiq_10

 function mp_addiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_addiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1)%mpr, mp_addiq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addiq_01

 function mp_addiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_addiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb%mpr, mp_addiq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addiq_20

 function mp_addiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_addiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1,ii2)%mpr, mp_addiq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addiq_02

 function mp_addiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_addiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1)%mpr, mp_addiq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addiq_11

 function mp_addiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_addiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1,ii2)%mpr, mp_addiq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addiq_22

 function mp_addqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_addqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1)%mpr, q1%mpr, mp_addqi_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqi_10

 function mp_addqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_addqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa%mpr, q1%mpr, mp_addqi_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqi_01

 function mp_addqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_addqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1,ii2)%mpr, q1%mpr, mp_addqi_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqi_20

 function mp_addqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_addqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa%mpr, q1%mpr, mp_addqi_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqi_02

 function mp_addqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_addqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1)%mpr, q1%mpr, mp_addqi_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqi_11

 function mp_addqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_addqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1,ii2)%mpr, q1%mpr, mp_addqi_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqi_22

 function mp_adddq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_adddq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpadd (q1%mpr, qb%mpr, mp_adddq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddq_10

 function mp_adddq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_adddq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1)%mpr, mp_adddq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddq_01

 function mp_adddq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_adddq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpadd (q1%mpr, qb%mpr, mp_adddq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddq_20

 function mp_adddq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_adddq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1,ii2)%mpr, mp_adddq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddq_02

 function mp_adddq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_adddq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1)%mpr, mp_adddq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_adddq_11

 function mp_adddq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_adddq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_adddq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpadd (q1%mpr, qb(ii1,ii2)%mpr, mp_adddq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_adddq_22

 function mp_addqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_addqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1)%mpr, q1%mpr, mp_addqd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqd_10

 function mp_addqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_addqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpadd (qa%mpr, q1%mpr, mp_addqd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqd_01

 function mp_addqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_addqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpadd (qa(ii1,ii2)%mpr, q1%mpr, mp_addqd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqd_20

 function mp_addqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_addqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpadd (qa%mpr, q1%mpr, mp_addqd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqd_02

 function mp_addqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_addqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpadd (qa(ii1)%mpr, q1%mpr, mp_addqd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_addqd_11

 function mp_addqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_addqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_addqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpadd (qa(ii1,ii2)%mpr, q1%mpr, mp_addqd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_addqd_22

 function mp_addxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_addxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxq_10

 function mp_addxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_addxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxq_01

 function mp_addxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_addxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxq_20

 function mp_addxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_addxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxq_02

 function mp_addxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_addxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxq_11

 function mp_addxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_addxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addxq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxq_22

 function mp_addqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_addqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqx_10

 function mp_addqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_addqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqx_01

 function mp_addqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_addqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqx_20

 function mp_addqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_addqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqx_02

 function mp_addqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_addqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addqx_11

 function mp_addqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_addqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcadd (mp4, z1%mpc, z2%mpc, mp_addqx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addqx_22

 !  MPR subtract routines.

 function mp_subqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_subqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpsub (qa(ii1)%mpr, jb%mpi, mp_subqj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqj_10

 function mp_subqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_subqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpsub (qa%mpr, jb(ii1)%mpi, mp_subqj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqj_01

 function mp_subqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_subqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpsub (qa(ii1,ii2)%mpr, jb%mpi, mp_subqj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqj_20

 function mp_subqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_subqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpsub (qa%mpr, jb(ii1,ii2)%mpi, mp_subqj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqj_02

 function mp_subqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_subqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpsub (qa(ii1)%mpr, jb(ii1)%mpi, mp_subqj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqj_11

 function mp_subqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_subqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpsub (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, mp_subqj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqj_22

 function mp_subqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_subqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpsub (qa(ii1)%mpr, qb%mpr, mp_subqq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqq_10

 function mp_subqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_subqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpsub (qa%mpr, qb(ii1)%mpr, mp_subqq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqq_01

 function mp_subqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_subqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpsub (qa(ii1,ii2)%mpr, qb%mpr, mp_subqq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqq_20

 function mp_subqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_subqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpsub (qa%mpr, qb(ii1,ii2)%mpr, mp_subqq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqq_02

 function mp_subqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_subqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpsub (qa(ii1)%mpr, qb(ii1)%mpr, mp_subqq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqq_11

 function mp_subqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_subqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpsub (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, mp_subqq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqq_22

 function mp_subqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_subqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subqz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqz_10

 function mp_subqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_subqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subqz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqz_01

 function mp_subqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_subqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subqz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqz_20

 function mp_subqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_subqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subqz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqz_02

 function mp_subqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_subqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subqz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqz_11

 function mp_subqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_subqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subqz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqz_22

 function mp_subiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_subiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb%mpr, mp_subiq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subiq_10

 function mp_subiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_subiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1)%mpr, mp_subiq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subiq_01

 function mp_subiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_subiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb%mpr, mp_subiq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subiq_20

 function mp_subiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_subiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1,ii2)%mpr, mp_subiq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subiq_02

 function mp_subiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_subiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1)%mpr, mp_subiq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subiq_11

 function mp_subiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_subiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1,ii2)%mpr, mp_subiq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subiq_22

 function mp_subqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_subqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_subqi_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqi_10

 function mp_subqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_subqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa%mpr, q1%mpr, mp_subqi_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqi_01

 function mp_subqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_subqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_subqi_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqi_20

 function mp_subqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_subqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa%mpr, q1%mpr, mp_subqi_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqi_02

 function mp_subqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_subqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_subqi_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqi_11

 function mp_subqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_subqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_subqi_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqi_22

 function mp_subdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_subdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpsub (q1%mpr, qb%mpr, mp_subdq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdq_10

 function mp_subdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_subdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1)%mpr, mp_subdq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdq_01

 function mp_subdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_subdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpsub (q1%mpr, qb%mpr, mp_subdq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdq_20

 function mp_subdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_subdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1,ii2)%mpr, mp_subdq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdq_02

 function mp_subdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_subdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1)%mpr, mp_subdq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subdq_11

 function mp_subdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_subdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpsub (q1%mpr, qb(ii1,ii2)%mpr, mp_subdq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subdq_22

 function mp_subqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_subqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_subqd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqd_10

 function mp_subqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_subqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpsub (qa%mpr, q1%mpr, mp_subqd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqd_01

 function mp_subqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_subqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_subqd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqd_20

 function mp_subqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_subqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpsub (qa%mpr, q1%mpr, mp_subqd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqd_02

 function mp_subqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_subqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_subqd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_subqd_11

 function mp_subqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_subqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_subqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_subqd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_subqd_22

 function mp_subxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_subxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxq_10

 function mp_subxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_subxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxq_01

 function mp_subxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_subxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxq_20

 function mp_subxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_subxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxq_02

 function mp_subxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_subxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxq_11

 function mp_subxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_subxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subxq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxq_22

 function mp_subqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_subqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqx_10

 function mp_subqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_subqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqx_01

 function mp_subqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_subqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqx_20

 function mp_subqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_subqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqx_02

 function mp_subqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_subqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subqx_11

 function mp_subqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_subqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcsub (mp4, z1%mpc, z2%mpc, mp_subqx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subqx_22

 !  MPR negation routine.

 function mp_negq_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_negq_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_negq_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (qa(ii1)%mpr, mp_negq_1(ii1)%mpr, mpnw) 
  mp_negq_1(ii1)%mpr(1) = - qa(ii1)%mpr(1)
end do 
  return
 end function mp_negq_1

 function mp_negq_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_negq_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_negq_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (qa(ii1,ii2)%mpr, mp_negq_2(ii1,ii2)%mpr, mpnw) 
  mp_negq_2(ii1,ii2)%mpr(1) = - qa(ii1,ii2)%mpr(1)
end do 
end do 
  return
 end function mp_negq_2

 !  MPR multiply routines.

 function mp_mulqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_mulqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmul (qa(ii1)%mpr, jb%mpi, mp_mulqj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqj_10

 function mp_mulqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_mulqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmul (qa%mpr, jb(ii1)%mpi, mp_mulqj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqj_01

 function mp_mulqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_mulqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmul (qa(ii1,ii2)%mpr, jb%mpi, mp_mulqj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqj_20

 function mp_mulqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_mulqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmul (qa%mpr, jb(ii1,ii2)%mpi, mp_mulqj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqj_02

 function mp_mulqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_mulqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmul (qa(ii1)%mpr, jb(ii1)%mpi, mp_mulqj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqj_11

 function mp_mulqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_mulqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmul (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, mp_mulqj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqj_22

 function mp_mulqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_mulqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmul (qa(ii1)%mpr, qb%mpr, mp_mulqq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqq_10

 function mp_mulqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_mulqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmul (qa%mpr, qb(ii1)%mpr, mp_mulqq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqq_01

 function mp_mulqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_mulqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmul (qa(ii1,ii2)%mpr, qb%mpr, mp_mulqq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqq_20

 function mp_mulqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_mulqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmul (qa%mpr, qb(ii1,ii2)%mpr, mp_mulqq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqq_02

 function mp_mulqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_mulqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmul (qa(ii1)%mpr, qb(ii1)%mpr, mp_mulqq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqq_11

 function mp_mulqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_mulqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmul (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, mp_mulqq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqq_22

 function mp_mulqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_mulqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_mulqz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqz_10

 function mp_mulqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_mulqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_mulqz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqz_01

 function mp_mulqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_mulqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_mulqz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqz_20

 function mp_mulqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_mulqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_mulqz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqz_02

 function mp_mulqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_mulqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_mulqz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqz_11

 function mp_mulqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_mulqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_mulqz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqz_22

 function mp_muliq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_10
  intent (in):: ia, qb
  integer mpnw
dimension ia(:)
dimension mp_muliq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpmuld (qb%mpr, da, 0, mp_muliq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muliq_10

 function mp_muliq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_01
  intent (in):: ia, qb
  integer mpnw
dimension qb(:)
dimension mp_muliq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpmuld (qb(ii1)%mpr, da, 0, mp_muliq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muliq_01

 function mp_muliq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_20
  intent (in):: ia, qb
  integer mpnw
dimension ia(:,:)
dimension mp_muliq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpmuld (qb%mpr, da, 0, mp_muliq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muliq_20

 function mp_muliq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_02
  intent (in):: ia, qb
  integer mpnw
dimension qb(:,:)
dimension mp_muliq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpmuld (qb(ii1,ii2)%mpr, da, 0, mp_muliq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muliq_02

 function mp_muliq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_11
  intent (in):: ia, qb
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_muliq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpmuld (qb(ii1)%mpr, da, 0, mp_muliq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muliq_11

 function mp_muliq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muliq_22
  intent (in):: ia, qb
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_muliq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpmuld (qb(ii1,ii2)%mpr, da, 0, mp_muliq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muliq_22

 function mp_mulqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_10
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension mp_mulqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpmuld (qa(ii1)%mpr, db, 0, mp_mulqi_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqi_10

 function mp_mulqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_01
  intent (in):: qa, ib
  integer mpnw
dimension ib(:)
dimension mp_mulqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpmuld (qa%mpr, db, 0, mp_mulqi_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqi_01

 function mp_mulqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_20
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension mp_mulqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpmuld (qa(ii1,ii2)%mpr, db, 0, mp_mulqi_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqi_20

 function mp_mulqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_02
  intent (in):: qa, ib
  integer mpnw
dimension ib(:,:)
dimension mp_mulqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpmuld (qa%mpr, db, 0, mp_mulqi_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqi_02

 function mp_mulqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_11
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_mulqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpmuld (qa(ii1)%mpr, db, 0, mp_mulqi_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqi_11

 function mp_mulqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqi_22
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_mulqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpmuld (qa(ii1,ii2)%mpr, db, 0, mp_mulqi_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqi_22

 function mp_muldq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_10
  intent (in):: da, qb
  integer mpnw
dimension da(:)
dimension mp_muldq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmuld (qb%mpr, da(ii1), 0, mp_muldq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldq_10

 function mp_muldq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_01
  intent (in):: da, qb
  integer mpnw
dimension qb(:)
dimension mp_muldq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmuld (qb(ii1)%mpr, da, 0, mp_muldq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldq_01

 function mp_muldq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_20
  intent (in):: da, qb
  integer mpnw
dimension da(:,:)
dimension mp_muldq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmuld (qb%mpr, da(ii1,ii2), 0, mp_muldq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldq_20

 function mp_muldq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_02
  intent (in):: da, qb
  integer mpnw
dimension qb(:,:)
dimension mp_muldq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmuld (qb(ii1,ii2)%mpr, da, 0, mp_muldq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldq_02

 function mp_muldq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_11
  intent (in):: da, qb
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_muldq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmuld (qb(ii1)%mpr, da(ii1), 0, mp_muldq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_muldq_11

 function mp_muldq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_muldq_22
  intent (in):: da, qb
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_muldq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmuld (qb(ii1,ii2)%mpr, da(ii1,ii2), 0, mp_muldq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_muldq_22

 function mp_mulqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_10
  intent (in):: qa, db
  integer mpnw
dimension qa(:)
dimension mp_mulqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmuld (qa(ii1)%mpr, db, 0, mp_mulqd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqd_10

 function mp_mulqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_01
  intent (in):: qa, db
  integer mpnw
dimension db(:)
dimension mp_mulqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpmuld (qa%mpr, db(ii1), 0, mp_mulqd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqd_01

 function mp_mulqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_20
  intent (in):: qa, db
  integer mpnw
dimension qa(:,:)
dimension mp_mulqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmuld (qa(ii1,ii2)%mpr, db, 0, mp_mulqd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqd_20

 function mp_mulqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_02
  intent (in):: qa, db
  integer mpnw
dimension db(:,:)
dimension mp_mulqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpmuld (qa%mpr, db(ii1,ii2), 0, mp_mulqd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqd_02

 function mp_mulqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_11
  intent (in):: qa, db
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_mulqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmuld (qa(ii1)%mpr, db(ii1), 0, mp_mulqd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_mulqd_11

 function mp_mulqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_mulqd_22
  intent (in):: qa, db
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_mulqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmuld (qa(ii1,ii2)%mpr, db(ii1,ii2), 0, mp_mulqd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_mulqd_22

 function mp_mulxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_mulxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxq_10

 function mp_mulxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_mulxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxq_01

 function mp_mulxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_mulxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxq_20

 function mp_mulxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_mulxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxq_02

 function mp_mulxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_mulxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxq_11

 function mp_mulxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_mulxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulxq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxq_22

 function mp_mulqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_mulqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqx_10

 function mp_mulqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_mulqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqx_01

 function mp_mulqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_mulqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqx_20

 function mp_mulqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_mulqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqx_02

 function mp_mulqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_mulqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulqx_11

 function mp_mulqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_mulqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcmul (mp4, z1%mpc, z2%mpc, mp_mulqx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulqx_22

 !  MPR divide routines.

 function mp_divqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_divqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, jb%mpi, mp_divqj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqj_10

 function mp_divqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_divqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdiv (qa%mpr, jb(ii1)%mpi, mp_divqj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqj_01

 function mp_divqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_divqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, jb%mpi, mp_divqj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqj_20

 function mp_divqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_divqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdiv (qa%mpr, jb(ii1,ii2)%mpi, mp_divqj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqj_02

 function mp_divqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_divqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, jb(ii1)%mpi, mp_divqj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqj_11

 function mp_divqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_divqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, mp_divqj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqj_22

 function mp_divqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_divqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, qb%mpr, mp_divqq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqq_10

 function mp_divqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_divqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdiv (qa%mpr, qb(ii1)%mpr, mp_divqq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqq_01

 function mp_divqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_divqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, qb%mpr, mp_divqq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqq_20

 function mp_divqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_divqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdiv (qa%mpr, qb(ii1,ii2)%mpr, mp_divqq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqq_02

 function mp_divqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_divqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, qb(ii1)%mpr, mp_divqq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqq_11

 function mp_divqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_divqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, mp_divqq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqq_22

 function mp_divqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_divqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divqz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqz_10

 function mp_divqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_divqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divqz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqz_01

 function mp_divqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_divqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divqz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqz_20

 function mp_divqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_divqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divqz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqz_02

 function mp_divqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_divqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divqz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqz_11

 function mp_divqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_divqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divqz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqz_22

 function mp_diviq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_diviq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb%mpr, mp_diviq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_diviq_10

 function mp_diviq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_diviq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1)%mpr, mp_diviq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_diviq_01

 function mp_diviq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_diviq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb%mpr, mp_diviq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_diviq_20

 function mp_diviq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_diviq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1,ii2)%mpr, mp_diviq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_diviq_02

 function mp_diviq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_diviq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1)%mpr, mp_diviq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_diviq_11

 function mp_diviq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_diviq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_diviq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1,ii2)%mpr, mp_diviq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_diviq_22

 function mp_divqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_10
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension mp_divqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdivd (qa(ii1)%mpr, db, 0, mp_divqi_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqi_10

 function mp_divqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_01
  intent (in):: qa, ib
  integer mpnw
dimension ib(:)
dimension mp_divqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdivd (qa%mpr, db, 0, mp_divqi_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqi_01

 function mp_divqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_20
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension mp_divqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdivd (qa(ii1,ii2)%mpr, db, 0, mp_divqi_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqi_20

 function mp_divqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_02
  intent (in):: qa, ib
  integer mpnw
dimension ib(:,:)
dimension mp_divqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdivd (qa%mpr, db, 0, mp_divqi_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqi_02

 function mp_divqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_11
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_divqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdivd (qa(ii1)%mpr, db, 0, mp_divqi_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqi_11

 function mp_divqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqi_22
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_divqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdivd (qa(ii1,ii2)%mpr, db, 0, mp_divqi_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqi_22

 function mp_divdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_divdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpdiv (q1%mpr, qb%mpr, mp_divdq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdq_10

 function mp_divdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_divdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1)%mpr, mp_divdq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdq_01

 function mp_divdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_divdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpdiv (q1%mpr, qb%mpr, mp_divdq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdq_20

 function mp_divdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_divdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1,ii2)%mpr, mp_divdq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdq_02

 function mp_divdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_divdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1)%mpr, mp_divdq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divdq_11

 function mp_divdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_divdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpdiv (q1%mpr, qb(ii1,ii2)%mpr, mp_divdq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divdq_22

 function mp_divqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_10
  intent (in):: qa, db
  integer mpnw
dimension qa(:)
dimension mp_divqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdivd (qa(ii1)%mpr, db, 0, mp_divqd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqd_10

 function mp_divqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_01
  intent (in):: qa, db
  integer mpnw
dimension db(:)
dimension mp_divqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdivd (qa%mpr, db(ii1), 0, mp_divqd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqd_01

 function mp_divqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_20
  intent (in):: qa, db
  integer mpnw
dimension qa(:,:)
dimension mp_divqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdivd (qa(ii1,ii2)%mpr, db, 0, mp_divqd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqd_20

 function mp_divqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_02
  intent (in):: qa, db
  integer mpnw
dimension db(:,:)
dimension mp_divqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdivd (qa%mpr, db(ii1,ii2), 0, mp_divqd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqd_02

 function mp_divqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_11
  intent (in):: qa, db
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_divqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdivd (qa(ii1)%mpr, db(ii1), 0, mp_divqd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_divqd_11

 function mp_divqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_divqd_22
  intent (in):: qa, db
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_divqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdivd (qa(ii1,ii2)%mpr, db(ii1,ii2), 0, mp_divqd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_divqd_22

 function mp_divxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_divxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxq_10

 function mp_divxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_divxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxq_01

 function mp_divxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_divxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxq_20

 function mp_divxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_divxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxq_02

 function mp_divxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_divxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxq_11

 function mp_divxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_divxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divxq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxq_22

 function mp_divqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_divqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqx_10

 function mp_divqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_divqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqx_01

 function mp_divqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_divqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqx_20

 function mp_divqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_divqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqx_02

 function mp_divqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_divqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divqx_11

 function mp_divqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_divqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcdiv (mp4, z1%mpc, z2%mpc, mp_divqx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divqx_22

 !  MPR exponentiation routines.

 function mp_expqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_10
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension mp_expqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqj_10

 function mp_expqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_01
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:)
dimension mp_expqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqj_01

 function mp_expqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_20
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension mp_expqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqj_20

 function mp_expqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_02
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension jb(:,:)
dimension mp_expqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqj_02

 function mp_expqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_11
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_expqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqj_11

 function mp_expqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqj_22
  intent (in):: qa, jb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_expqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, jb(ii1,ii2)%mpi, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqj_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqj_22

 function mp_expqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_10
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension mp_expqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqq_10

 function mp_expqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_01
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qb(:)
dimension mp_expqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqq_01

 function mp_expqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_20
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension mp_expqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqq_20

 function mp_expqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_02
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qb(:,:)
dimension mp_expqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqq_02

 function mp_expqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_11
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_expqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqq_11

 function mp_expqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqq_22
  intent (in):: qa, qb
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_expqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmul (q1%mpr, qb(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqq_22

 function mp_expiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_10
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension mp_expiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expiq_10

 function mp_expiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_01
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:)
dimension mp_expiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expiq_01

 function mp_expiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_20
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension mp_expiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expiq_20

 function mp_expiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_02
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:,:)
dimension mp_expiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1,ii2)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expiq_02

 function mp_expiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_11
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_expiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expiq_11

 function mp_expiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expiq_22
  intent (in):: ia, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_expiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1,ii2)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expiq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expiq_22

 function mp_expqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_10
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension mp_expqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpnpwr (qa(ii1)%mpr, ib, mp_expqi_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqi_10

 function mp_expqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_01
  intent (in):: qa, ib
  integer mpnw
dimension ib(:)
dimension mp_expqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  call mpnpwr (qa%mpr, ib(ii1), mp_expqi_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqi_01

 function mp_expqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_20
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension mp_expqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpnpwr (qa(ii1,ii2)%mpr, ib, mp_expqi_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqi_20

 function mp_expqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_02
  intent (in):: qa, ib
  integer mpnw
dimension ib(:,:)
dimension mp_expqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  call mpnpwr (qa%mpr, ib(ii1,ii2), mp_expqi_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqi_02

 function mp_expqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_11
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_expqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpnpwr (qa(ii1)%mpr, ib(ii1), mp_expqi_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqi_11

 function mp_expqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqi_22
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_expqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpnpwr (qa(ii1,ii2)%mpr, ib(ii1,ii2), mp_expqi_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqi_22

 function mp_expdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_10
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:)
dimension mp_expdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdq_10

 function mp_expdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_01
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:)
dimension mp_expdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdq_01

 function mp_expdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_20
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:,:)
dimension mp_expdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdq_20

 function mp_expdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_02
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:,:)
dimension mp_expdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1,ii2)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdq_02

 function mp_expdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_11
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_expdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expdq_11

 function mp_expdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expdq_22
  intent (in):: da, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_expdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mplog (q1%mpr, mpl02%mpr, q2%mpr, mpnw) 
  call mpmul (q2%mpr, qb(ii1,ii2)%mpr, q3%mpr, mpnw) 
  call mpexp (q3%mpr, mpl02%mpr, mp_expdq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expdq_22

 function mp_expqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_10
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension mp_expqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db, 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqd_10

 function mp_expqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_01
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension db(:)
dimension mp_expqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqd_01

 function mp_expqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_20
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension mp_expqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db, 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqd_20

 function mp_expqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_02
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension db(:,:)
dimension mp_expqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mplog (qa%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1,ii2), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqd_02

 function mp_expqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_11
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_expqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_expqd_11

 function mp_expqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_expqd_22
  intent (in):: qa, db
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_expqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpmuld (q1%mpr, db(ii1,ii2), 0, q2%mpr, mpnw) 
  call mpexp (q2%mpr, mpl02%mpr, mp_expqd_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_expqd_22

 !  MPR .EQ. routines.

 function mp_eqtqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_eqtqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_10(ii1) = .true.
  else
   mp_eqtqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqj_10

 function mp_eqtqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_eqtqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_01(ii1) = .true.
  else
   mp_eqtqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqj_01

 function mp_eqtqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_20(ii1,ii2) = .true.
  else
   mp_eqtqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqj_20

 function mp_eqtqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_eqtqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_02(ii1,ii2) = .true.
  else
   mp_eqtqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqj_02

 function mp_eqtqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_eqtqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_11(ii1) = .true.
  else
   mp_eqtqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqj_11

 function mp_eqtqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_eqtqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqj_22(ii1,ii2) = .true.
  else
   mp_eqtqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqj_22

 function mp_eqtqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_eqtqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_10(ii1) = .true.
  else
   mp_eqtqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqq_10

 function mp_eqtqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_eqtqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_01(ii1) = .true.
  else
   mp_eqtqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqq_01

 function mp_eqtqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_20(ii1,ii2) = .true.
  else
   mp_eqtqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqq_20

 function mp_eqtqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_eqtqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_02(ii1,ii2) = .true.
  else
   mp_eqtqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqq_02

 function mp_eqtqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_eqtqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_11(ii1) = .true.
  else
   mp_eqtqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqq_11

 function mp_eqtqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_eqtqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqq_22(ii1,ii2) = .true.
  else
   mp_eqtqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqq_22

 function mp_eqtqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_eqtqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_10(ii1) = .true.
  else
   mp_eqtqz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqz_10

 function mp_eqtqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_eqtqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_01(ii1) = .true.
  else
   mp_eqtqz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqz_01

 function mp_eqtqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_20(ii1,ii2) = .true.
  else
   mp_eqtqz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqz_20

 function mp_eqtqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_eqtqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_02(ii1,ii2) = .true.
  else
   mp_eqtqz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqz_02

 function mp_eqtqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_eqtqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_11(ii1) = .true.
  else
   mp_eqtqz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqz_11

 function mp_eqtqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_eqtqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqz_22(ii1,ii2) = .true.
  else
   mp_eqtqz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqz_22

 function mp_eqtiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_eqtiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_10(ii1) = .true.
  else
   mp_eqtiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiq_10

 function mp_eqtiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_eqtiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_01(ii1) = .true.
  else
   mp_eqtiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiq_01

 function mp_eqtiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_eqtiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_20(ii1,ii2) = .true.
  else
   mp_eqtiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiq_20

 function mp_eqtiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_eqtiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_02(ii1,ii2) = .true.
  else
   mp_eqtiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiq_02

 function mp_eqtiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_eqtiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_11(ii1) = .true.
  else
   mp_eqtiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiq_11

 function mp_eqtiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_eqtiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtiq_22(ii1,ii2) = .true.
  else
   mp_eqtiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiq_22

 function mp_eqtqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_eqtqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_10(ii1) = .true.
  else
   mp_eqtqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqi_10

 function mp_eqtqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_eqtqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_01(ii1) = .true.
  else
   mp_eqtqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqi_01

 function mp_eqtqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_20(ii1,ii2) = .true.
  else
   mp_eqtqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqi_20

 function mp_eqtqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_eqtqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_02(ii1,ii2) = .true.
  else
   mp_eqtqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqi_02

 function mp_eqtqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_eqtqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_11(ii1) = .true.
  else
   mp_eqtqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqi_11

 function mp_eqtqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_eqtqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqi_22(ii1,ii2) = .true.
  else
   mp_eqtqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqi_22

 function mp_eqtdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_eqtdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_10(ii1) = .true.
  else
   mp_eqtdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdq_10

 function mp_eqtdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_eqtdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_01(ii1) = .true.
  else
   mp_eqtdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdq_01

 function mp_eqtdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_eqtdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_20(ii1,ii2) = .true.
  else
   mp_eqtdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdq_20

 function mp_eqtdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_eqtdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_02(ii1,ii2) = .true.
  else
   mp_eqtdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdq_02

 function mp_eqtdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_eqtdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_11(ii1) = .true.
  else
   mp_eqtdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdq_11

 function mp_eqtdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_eqtdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtdq_22(ii1,ii2) = .true.
  else
   mp_eqtdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdq_22

 function mp_eqtqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_eqtqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_10(ii1) = .true.
  else
   mp_eqtqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqd_10

 function mp_eqtqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_eqtqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_01(ii1) = .true.
  else
   mp_eqtqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqd_01

 function mp_eqtqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_20(ii1,ii2) = .true.
  else
   mp_eqtqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqd_20

 function mp_eqtqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_eqtqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_02(ii1,ii2) = .true.
  else
   mp_eqtqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqd_02

 function mp_eqtqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_eqtqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_11(ii1) = .true.
  else
   mp_eqtqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqd_11

 function mp_eqtqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_eqtqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .eq. 0) then
   mp_eqtqd_22(ii1,ii2) = .true.
  else
   mp_eqtqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqd_22

 function mp_eqtxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_eqtxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_10(ii1) = .true.
  else
   mp_eqtxq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxq_10

 function mp_eqtxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_eqtxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_01(ii1) = .true.
  else
   mp_eqtxq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxq_01

 function mp_eqtxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_eqtxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_20(ii1,ii2) = .true.
  else
   mp_eqtxq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxq_20

 function mp_eqtxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_eqtxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_02(ii1,ii2) = .true.
  else
   mp_eqtxq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxq_02

 function mp_eqtxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_eqtxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_11(ii1) = .true.
  else
   mp_eqtxq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxq_11

 function mp_eqtxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_eqtxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxq_22(ii1,ii2) = .true.
  else
   mp_eqtxq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxq_22

 function mp_eqtqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_eqtqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_10(ii1) = .true.
  else
   mp_eqtqx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqx_10

 function mp_eqtqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_eqtqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_01(ii1) = .true.
  else
   mp_eqtqx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqx_01

 function mp_eqtqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_eqtqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_20(ii1,ii2) = .true.
  else
   mp_eqtqx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqx_20

 function mp_eqtqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_eqtqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_02(ii1,ii2) = .true.
  else
   mp_eqtqx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqx_02

 function mp_eqtqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_eqtqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_11(ii1) = .true.
  else
   mp_eqtqx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtqx_11

 function mp_eqtqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_eqtqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtqx_22(ii1,ii2) = .true.
  else
   mp_eqtqx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtqx_22

 !  MPR .NE. routines.

 function mp_netqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_netqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_10(ii1) = .true.
  else
   mp_netqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqj_10

 function mp_netqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_netqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_01(ii1) = .true.
  else
   mp_netqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqj_01

 function mp_netqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_netqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_20(ii1,ii2) = .true.
  else
   mp_netqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqj_20

 function mp_netqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_netqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_02(ii1,ii2) = .true.
  else
   mp_netqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqj_02

 function mp_netqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_netqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_11(ii1) = .true.
  else
   mp_netqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqj_11

 function mp_netqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_netqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqj_22(ii1,ii2) = .true.
  else
   mp_netqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqj_22

 function mp_netqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_netqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_10(ii1) = .true.
  else
   mp_netqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqq_10

 function mp_netqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_netqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_01(ii1) = .true.
  else
   mp_netqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqq_01

 function mp_netqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_netqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_20(ii1,ii2) = .true.
  else
   mp_netqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqq_20

 function mp_netqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_netqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_02(ii1,ii2) = .true.
  else
   mp_netqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqq_02

 function mp_netqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_netqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_11(ii1) = .true.
  else
   mp_netqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqq_11

 function mp_netqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_netqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqq_22(ii1,ii2) = .true.
  else
   mp_netqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqq_22

 function mp_netqz_10 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_10
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension mp_netqz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_10(ii1) = .true.
  else
   mp_netqz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqz_10

 function mp_netqz_01 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_01
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_netqz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_01(ii1) = .true.
  else
   mp_netqz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqz_01

 function mp_netqz_20 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_20
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension mp_netqz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_20(ii1,ii2) = .true.
  else
   mp_netqz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqz_20

 function mp_netqz_02 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_02
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_netqz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_02(ii1,ii2) = .true.
  else
   mp_netqz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqz_02

 function mp_netqz_11 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_11
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:)
dimension zb(:)
dimension mp_netqz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_11(ii1) = .true.
  else
   mp_netqz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqz_11

 function mp_netqz_22 (qa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqz_22
  intent (in):: qa, zb
  type (mp_complex) z1
  integer mpnw
dimension qa(:,:)
dimension zb(:,:)
dimension mp_netqz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqz_22(ii1,ii2) = .true.
  else
   mp_netqz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqz_22

 function mp_netiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_netiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_10(ii1) = .true.
  else
   mp_netiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netiq_10

 function mp_netiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_netiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_01(ii1) = .true.
  else
   mp_netiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netiq_01

 function mp_netiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_netiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_20(ii1,ii2) = .true.
  else
   mp_netiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiq_20

 function mp_netiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_netiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_02(ii1,ii2) = .true.
  else
   mp_netiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiq_02

 function mp_netiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_netiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_11(ii1) = .true.
  else
   mp_netiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netiq_11

 function mp_netiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_netiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netiq_22(ii1,ii2) = .true.
  else
   mp_netiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiq_22

 function mp_netqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_netqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_10(ii1) = .true.
  else
   mp_netqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqi_10

 function mp_netqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_netqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_01(ii1) = .true.
  else
   mp_netqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqi_01

 function mp_netqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_netqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_20(ii1,ii2) = .true.
  else
   mp_netqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqi_20

 function mp_netqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_netqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_02(ii1,ii2) = .true.
  else
   mp_netqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqi_02

 function mp_netqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_netqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_11(ii1) = .true.
  else
   mp_netqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqi_11

 function mp_netqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_netqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqi_22(ii1,ii2) = .true.
  else
   mp_netqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqi_22

 function mp_netdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_netdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_10(ii1) = .true.
  else
   mp_netdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netdq_10

 function mp_netdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_netdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_01(ii1) = .true.
  else
   mp_netdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netdq_01

 function mp_netdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_netdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_20(ii1,ii2) = .true.
  else
   mp_netdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdq_20

 function mp_netdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_netdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_02(ii1,ii2) = .true.
  else
   mp_netdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdq_02

 function mp_netdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_netdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_11(ii1) = .true.
  else
   mp_netdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netdq_11

 function mp_netdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_netdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netdq_22(ii1,ii2) = .true.
  else
   mp_netdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdq_22

 function mp_netqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_netqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_10(ii1) = .true.
  else
   mp_netqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqd_10

 function mp_netqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_netqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_01(ii1) = .true.
  else
   mp_netqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqd_01

 function mp_netqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_netqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_20(ii1,ii2) = .true.
  else
   mp_netqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqd_20

 function mp_netqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_netqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_02(ii1,ii2) = .true.
  else
   mp_netqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqd_02

 function mp_netqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_netqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_11(ii1) = .true.
  else
   mp_netqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqd_11

 function mp_netqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_netqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ne. 0) then
   mp_netqd_22(ii1,ii2) = .true.
  else
   mp_netqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqd_22

 function mp_netxq_10 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_10
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension mp_netxq_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_10(ii1) = .true.
  else
   mp_netxq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netxq_10

 function mp_netxq_01 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_01
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:)
dimension mp_netxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_01(ii1) = .true.
  else
   mp_netxq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netxq_01

 function mp_netxq_20 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_20
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension mp_netxq_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_20(ii1,ii2) = .true.
  else
   mp_netxq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxq_20

 function mp_netxq_02 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_02
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension qb(:,:)
dimension mp_netxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpxzc (xa, z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_02(ii1,ii2) = .true.
  else
   mp_netxq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxq_02

 function mp_netxq_11 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_11
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:)
dimension qb(:)
dimension mp_netxq_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpmzc (qb(ii1)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_11(ii1) = .true.
  else
   mp_netxq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netxq_11

 function mp_netxq_22 (xa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxq_22
  intent (in):: xa, qb
  type (mp_complex) z1, z2
  integer mpnw
dimension xa(:,:)
dimension qb(:,:)
dimension mp_netxq_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpmzc (qb(ii1,ii2)%mpr, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxq_22(ii1,ii2) = .true.
  else
   mp_netxq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxq_22

 function mp_netqx_10 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_10
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension mp_netqx_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_10(ii1) = .true.
  else
   mp_netqx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netqx_10

 function mp_netqx_01 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_01
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:)
dimension mp_netqx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_01(ii1) = .true.
  else
   mp_netqx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netqx_01

 function mp_netqx_20 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_20
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension mp_netqx_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb, z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_20(ii1,ii2) = .true.
  else
   mp_netqx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqx_20

 function mp_netqx_02 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_02
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension xb(:,:)
dimension mp_netqx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpmzc (qa%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_02(ii1,ii2) = .true.
  else
   mp_netqx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqx_02

 function mp_netqx_11 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_11
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:)
dimension xb(:)
dimension mp_netqx_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, z1%mpc)
  call mpxzc (xb(ii1), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_11(ii1) = .true.
  else
   mp_netqx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netqx_11

 function mp_netqx_22 (qa, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netqx_22
  intent (in):: qa, xb
  type (mp_complex) z1, z2
  integer mpnw
dimension qa(:,:)
dimension xb(:,:)
dimension mp_netqx_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, z1%mpc)
  call mpxzc (xb(ii1,ii2), z2%mpc)
  call mpcpr (z1%mpc, z2%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netqx_22(ii1,ii2) = .true.
  else
   mp_netqx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netqx_22

 !  MPR .LE. routines.

 function mp_letqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_letqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_10(ii1) = .true.
  else
   mp_letqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letqj_10

 function mp_letqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_letqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_01(ii1) = .true.
  else
   mp_letqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letqj_01

 function mp_letqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_letqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_20(ii1,ii2) = .true.
  else
   mp_letqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqj_20

 function mp_letqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_letqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_02(ii1,ii2) = .true.
  else
   mp_letqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqj_02

 function mp_letqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_letqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_11(ii1) = .true.
  else
   mp_letqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letqj_11

 function mp_letqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_letqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqj_22(ii1,ii2) = .true.
  else
   mp_letqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqj_22

 function mp_letqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_letqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_10(ii1) = .true.
  else
   mp_letqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letqq_10

 function mp_letqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_letqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_01(ii1) = .true.
  else
   mp_letqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letqq_01

 function mp_letqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_letqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_20(ii1,ii2) = .true.
  else
   mp_letqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqq_20

 function mp_letqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_letqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_02(ii1,ii2) = .true.
  else
   mp_letqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqq_02

 function mp_letqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_letqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_11(ii1) = .true.
  else
   mp_letqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letqq_11

 function mp_letqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_letqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqq_22(ii1,ii2) = .true.
  else
   mp_letqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqq_22

 function mp_letiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_letiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_10(ii1) = .true.
  else
   mp_letiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letiq_10

 function mp_letiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_letiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_01(ii1) = .true.
  else
   mp_letiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letiq_01

 function mp_letiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_letiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_20(ii1,ii2) = .true.
  else
   mp_letiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letiq_20

 function mp_letiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_letiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_02(ii1,ii2) = .true.
  else
   mp_letiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letiq_02

 function mp_letiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_letiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_11(ii1) = .true.
  else
   mp_letiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letiq_11

 function mp_letiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_letiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letiq_22(ii1,ii2) = .true.
  else
   mp_letiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letiq_22

 function mp_letqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_letqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_10(ii1) = .true.
  else
   mp_letqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letqi_10

 function mp_letqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_letqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_01(ii1) = .true.
  else
   mp_letqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letqi_01

 function mp_letqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_letqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_20(ii1,ii2) = .true.
  else
   mp_letqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqi_20

 function mp_letqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_letqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_02(ii1,ii2) = .true.
  else
   mp_letqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqi_02

 function mp_letqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_letqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_11(ii1) = .true.
  else
   mp_letqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letqi_11

 function mp_letqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_letqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqi_22(ii1,ii2) = .true.
  else
   mp_letqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqi_22

 function mp_letdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_letdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_10(ii1) = .true.
  else
   mp_letdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letdq_10

 function mp_letdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_letdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_01(ii1) = .true.
  else
   mp_letdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letdq_01

 function mp_letdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_letdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_20(ii1,ii2) = .true.
  else
   mp_letdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdq_20

 function mp_letdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_letdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_02(ii1,ii2) = .true.
  else
   mp_letdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdq_02

 function mp_letdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_letdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_11(ii1) = .true.
  else
   mp_letdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letdq_11

 function mp_letdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_letdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letdq_22(ii1,ii2) = .true.
  else
   mp_letdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letdq_22

 function mp_letqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_letqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_10(ii1) = .true.
  else
   mp_letqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_letqd_10

 function mp_letqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_letqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_01(ii1) = .true.
  else
   mp_letqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_letqd_01

 function mp_letqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_letqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_20(ii1,ii2) = .true.
  else
   mp_letqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqd_20

 function mp_letqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_letqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_02(ii1,ii2) = .true.
  else
   mp_letqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqd_02

 function mp_letqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_letqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_11(ii1) = .true.
  else
   mp_letqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_letqd_11

 function mp_letqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_letqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_letqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .le. 0) then
   mp_letqd_22(ii1,ii2) = .true.
  else
   mp_letqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_letqd_22

 !  MPR .GE. routines.

 function mp_getqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_getqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_10(ii1) = .true.
  else
   mp_getqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getqj_10

 function mp_getqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_getqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_01(ii1) = .true.
  else
   mp_getqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getqj_01

 function mp_getqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_getqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_20(ii1,ii2) = .true.
  else
   mp_getqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqj_20

 function mp_getqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_getqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_02(ii1,ii2) = .true.
  else
   mp_getqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqj_02

 function mp_getqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_getqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_11(ii1) = .true.
  else
   mp_getqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getqj_11

 function mp_getqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_getqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqj_22(ii1,ii2) = .true.
  else
   mp_getqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqj_22

 function mp_getqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_getqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_10(ii1) = .true.
  else
   mp_getqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getqq_10

 function mp_getqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_getqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_01(ii1) = .true.
  else
   mp_getqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getqq_01

 function mp_getqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_getqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_20(ii1,ii2) = .true.
  else
   mp_getqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqq_20

 function mp_getqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_getqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_02(ii1,ii2) = .true.
  else
   mp_getqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqq_02

 function mp_getqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_getqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_11(ii1) = .true.
  else
   mp_getqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getqq_11

 function mp_getqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_getqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqq_22(ii1,ii2) = .true.
  else
   mp_getqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqq_22

 function mp_getiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_getiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_10(ii1) = .true.
  else
   mp_getiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getiq_10

 function mp_getiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_getiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_01(ii1) = .true.
  else
   mp_getiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getiq_01

 function mp_getiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_getiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_20(ii1,ii2) = .true.
  else
   mp_getiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getiq_20

 function mp_getiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_getiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_02(ii1,ii2) = .true.
  else
   mp_getiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getiq_02

 function mp_getiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_getiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_11(ii1) = .true.
  else
   mp_getiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getiq_11

 function mp_getiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_getiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getiq_22(ii1,ii2) = .true.
  else
   mp_getiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getiq_22

 function mp_getqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_getqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_10(ii1) = .true.
  else
   mp_getqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getqi_10

 function mp_getqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_getqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_01(ii1) = .true.
  else
   mp_getqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getqi_01

 function mp_getqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_getqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_20(ii1,ii2) = .true.
  else
   mp_getqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqi_20

 function mp_getqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_getqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_02(ii1,ii2) = .true.
  else
   mp_getqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqi_02

 function mp_getqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_getqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_11(ii1) = .true.
  else
   mp_getqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getqi_11

 function mp_getqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_getqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqi_22(ii1,ii2) = .true.
  else
   mp_getqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqi_22

 function mp_getdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_getdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_10(ii1) = .true.
  else
   mp_getdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getdq_10

 function mp_getdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_getdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_01(ii1) = .true.
  else
   mp_getdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getdq_01

 function mp_getdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_getdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_20(ii1,ii2) = .true.
  else
   mp_getdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdq_20

 function mp_getdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_getdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_02(ii1,ii2) = .true.
  else
   mp_getdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdq_02

 function mp_getdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_getdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_11(ii1) = .true.
  else
   mp_getdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getdq_11

 function mp_getdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_getdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getdq_22(ii1,ii2) = .true.
  else
   mp_getdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getdq_22

 function mp_getqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_getqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_10(ii1) = .true.
  else
   mp_getqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_getqd_10

 function mp_getqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_getqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_01(ii1) = .true.
  else
   mp_getqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_getqd_01

 function mp_getqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_getqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_20(ii1,ii2) = .true.
  else
   mp_getqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqd_20

 function mp_getqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_getqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_02(ii1,ii2) = .true.
  else
   mp_getqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqd_02

 function mp_getqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_getqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_11(ii1) = .true.
  else
   mp_getqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_getqd_11

 function mp_getqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_getqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_getqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   mp_getqd_22(ii1,ii2) = .true.
  else
   mp_getqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_getqd_22

 !  MPR .LT. routines.

 function mp_lttqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_lttqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_10(ii1) = .true.
  else
   mp_lttqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqj_10

 function mp_lttqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_lttqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_01(ii1) = .true.
  else
   mp_lttqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqj_01

 function mp_lttqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_lttqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_20(ii1,ii2) = .true.
  else
   mp_lttqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqj_20

 function mp_lttqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_lttqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_02(ii1,ii2) = .true.
  else
   mp_lttqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqj_02

 function mp_lttqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_lttqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_11(ii1) = .true.
  else
   mp_lttqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqj_11

 function mp_lttqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_lttqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqj_22(ii1,ii2) = .true.
  else
   mp_lttqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqj_22

 function mp_lttqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_lttqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_10(ii1) = .true.
  else
   mp_lttqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqq_10

 function mp_lttqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_lttqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_01(ii1) = .true.
  else
   mp_lttqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqq_01

 function mp_lttqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_lttqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_20(ii1,ii2) = .true.
  else
   mp_lttqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqq_20

 function mp_lttqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_lttqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_02(ii1,ii2) = .true.
  else
   mp_lttqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqq_02

 function mp_lttqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_lttqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_11(ii1) = .true.
  else
   mp_lttqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqq_11

 function mp_lttqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_lttqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqq_22(ii1,ii2) = .true.
  else
   mp_lttqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqq_22

 function mp_lttiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_lttiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_10(ii1) = .true.
  else
   mp_lttiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttiq_10

 function mp_lttiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_lttiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_01(ii1) = .true.
  else
   mp_lttiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttiq_01

 function mp_lttiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_lttiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_20(ii1,ii2) = .true.
  else
   mp_lttiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttiq_20

 function mp_lttiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_lttiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_02(ii1,ii2) = .true.
  else
   mp_lttiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttiq_02

 function mp_lttiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_lttiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_11(ii1) = .true.
  else
   mp_lttiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttiq_11

 function mp_lttiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_lttiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttiq_22(ii1,ii2) = .true.
  else
   mp_lttiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttiq_22

 function mp_lttqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_lttqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_10(ii1) = .true.
  else
   mp_lttqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqi_10

 function mp_lttqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_lttqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_01(ii1) = .true.
  else
   mp_lttqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqi_01

 function mp_lttqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_lttqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_20(ii1,ii2) = .true.
  else
   mp_lttqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqi_20

 function mp_lttqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_lttqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_02(ii1,ii2) = .true.
  else
   mp_lttqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqi_02

 function mp_lttqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_lttqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_11(ii1) = .true.
  else
   mp_lttqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqi_11

 function mp_lttqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_lttqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqi_22(ii1,ii2) = .true.
  else
   mp_lttqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqi_22

 function mp_lttdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_lttdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_10(ii1) = .true.
  else
   mp_lttdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdq_10

 function mp_lttdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_lttdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_01(ii1) = .true.
  else
   mp_lttdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdq_01

 function mp_lttdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_lttdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_20(ii1,ii2) = .true.
  else
   mp_lttdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdq_20

 function mp_lttdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_lttdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_02(ii1,ii2) = .true.
  else
   mp_lttdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdq_02

 function mp_lttdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_lttdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_11(ii1) = .true.
  else
   mp_lttdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttdq_11

 function mp_lttdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_lttdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttdq_22(ii1,ii2) = .true.
  else
   mp_lttdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttdq_22

 function mp_lttqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_lttqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_10(ii1) = .true.
  else
   mp_lttqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqd_10

 function mp_lttqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_lttqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_01(ii1) = .true.
  else
   mp_lttqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqd_01

 function mp_lttqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_lttqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_20(ii1,ii2) = .true.
  else
   mp_lttqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqd_20

 function mp_lttqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_lttqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_02(ii1,ii2) = .true.
  else
   mp_lttqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqd_02

 function mp_lttqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_lttqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_11(ii1) = .true.
  else
   mp_lttqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_lttqd_11

 function mp_lttqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_lttqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_lttqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   mp_lttqd_22(ii1,ii2) = .true.
  else
   mp_lttqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_lttqd_22

 !  MPR .GT. routines.

 function mp_gttqj_10 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_10
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension mp_gttqj_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_10(ii1) = .true.
  else
   mp_gttqj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqj_10

 function mp_gttqj_01 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_01
  intent (in):: qa, jb
  integer mpnw
dimension jb(:)
dimension mp_gttqj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (qa%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_01(ii1) = .true.
  else
   mp_gttqj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqj_01

 function mp_gttqj_20 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_20
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension mp_gttqj_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_20(ii1,ii2) = .true.
  else
   mp_gttqj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqj_20

 function mp_gttqj_02 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_02
  intent (in):: qa, jb
  integer mpnw
dimension jb(:,:)
dimension mp_gttqj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (qa%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_02(ii1,ii2) = .true.
  else
   mp_gttqj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqj_02

 function mp_gttqj_11 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_11
  intent (in):: qa, jb
  integer mpnw
dimension qa(:)
dimension jb(:)
dimension mp_gttqj_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, jb(ii1)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_11(ii1) = .true.
  else
   mp_gttqj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqj_11

 function mp_gttqj_22 (qa, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqj_22
  intent (in):: qa, jb
  integer mpnw
dimension qa(:,:)
dimension jb(:,:)
dimension mp_gttqj_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqj_22(ii1,ii2) = .true.
  else
   mp_gttqj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqj_22

 function mp_gttqq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_gttqq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_10(ii1) = .true.
  else
   mp_gttqq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqq_10

 function mp_gttqq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_gttqq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_01(ii1) = .true.
  else
   mp_gttqq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqq_01

 function mp_gttqq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_gttqq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_20(ii1,ii2) = .true.
  else
   mp_gttqq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqq_20

 function mp_gttqq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_gttqq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_02(ii1,ii2) = .true.
  else
   mp_gttqq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqq_02

 function mp_gttqq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_gttqq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_11(ii1) = .true.
  else
   mp_gttqq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqq_11

 function mp_gttqq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_gttqq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqq_22(ii1,ii2) = .true.
  else
   mp_gttqq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqq_22

 function mp_gttiq_10 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_10
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension mp_gttiq_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_10(ii1) = .true.
  else
   mp_gttiq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttiq_10

 function mp_gttiq_01 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_01
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_gttiq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_01(ii1) = .true.
  else
   mp_gttiq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttiq_01

 function mp_gttiq_20 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_20
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension mp_gttiq_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_20(ii1,ii2) = .true.
  else
   mp_gttiq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttiq_20

 function mp_gttiq_02 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_02
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_gttiq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  da = ia
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_02(ii1,ii2) = .true.
  else
   mp_gttiq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttiq_02

 function mp_gttiq_11 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_11
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:)
dimension qb(:)
dimension mp_gttiq_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_11(ii1) = .true.
  else
   mp_gttiq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttiq_11

 function mp_gttiq_22 (ia, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttiq_22
  intent (in):: ia, qb
  type (mp_real) q1
  integer mpnw
dimension ia(:,:)
dimension qb(:,:)
dimension mp_gttiq_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttiq_22(ii1,ii2) = .true.
  else
   mp_gttiq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttiq_22

 function mp_gttqi_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_10
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_gttqi_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_10(ii1) = .true.
  else
   mp_gttqi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqi_10

 function mp_gttqi_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_01
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:)
dimension mp_gttqi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_01(ii1) = .true.
  else
   mp_gttqi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqi_01

 function mp_gttqi_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_20
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_gttqi_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_20(ii1,ii2) = .true.
  else
   mp_gttqi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqi_20

 function mp_gttqi_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_02
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension ib(:,:)
dimension mp_gttqi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_02(ii1,ii2) = .true.
  else
   mp_gttqi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqi_02

 function mp_gttqi_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_11
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_gttqi_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  db = ib(ii1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_11(ii1) = .true.
  else
   mp_gttqi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqi_11

 function mp_gttqi_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqi_22
  intent (in):: qa, ib
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_gttqi_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqi_22(ii1,ii2) = .true.
  else
   mp_gttqi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqi_22

 function mp_gttdq_10 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_10
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension mp_gttdq_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_10(ii1) = .true.
  else
   mp_gttdq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdq_10

 function mp_gttdq_01 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_01
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_gttdq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_01(ii1) = .true.
  else
   mp_gttdq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdq_01

 function mp_gttdq_20 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_20
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension mp_gttdq_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_20(ii1,ii2) = .true.
  else
   mp_gttdq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdq_20

 function mp_gttdq_02 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_02
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_gttdq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdmc (da, 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_02(ii1,ii2) = .true.
  else
   mp_gttdq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdq_02

 function mp_gttdq_11 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_11
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:)
dimension qb(:)
dimension mp_gttdq_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_11(ii1) = .true.
  else
   mp_gttdq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttdq_11

 function mp_gttdq_22 (da, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttdq_22
  intent (in):: da, qb
  type (mp_real) q1
  integer mpnw
dimension da(:,:)
dimension qb(:,:)
dimension mp_gttdq_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpcpr (q1%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttdq_22(ii1,ii2) = .true.
  else
   mp_gttdq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttdq_22

 function mp_gttqd_10 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_10
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_gttqd_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_10(ii1) = .true.
  else
   mp_gttqd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqd_10

 function mp_gttqd_01 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_01
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:)
dimension mp_gttqd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_01(ii1) = .true.
  else
   mp_gttqd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqd_01

 function mp_gttqd_20 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_20
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_gttqd_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db, 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_20(ii1,ii2) = .true.
  else
   mp_gttqd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqd_20

 function mp_gttqd_02 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_02
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension db(:,:)
dimension mp_gttqd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_02(ii1,ii2) = .true.
  else
   mp_gttqd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqd_02

 function mp_gttqd_11 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_11
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension db(:)
dimension mp_gttqd_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (db(ii1), 0, q1%mpr)
  call mpcpr (qa(ii1)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_11(ii1) = .true.
  else
   mp_gttqd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_gttqd_11

 function mp_gttqd_22 (qa, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_gttqd_22
  intent (in):: qa, db
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension db(:,:)
dimension mp_gttqd_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (db(ii1,ii2), 0, q1%mpr)
  call mpcpr (qa(ii1,ii2)%mpr, q1%mpr, ic, mpnw) 
  if (ic .gt. 0) then
   mp_gttqd_22(ii1,ii2) = .true.
  else
   mp_gttqd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_gttqd_22

end module mprealmodv


module mpcmpmodv

 !  This Fortran-90 module defines operator extensions involving the
 !  MP_COMPLEX datatype.  For operations involving two MP data types,
 !  those whose first argument is MP_COMPLEX are included here.
 !  Others are handled in other modules.

 !  The subroutines and functions defined in this module are private
 !  and not intended to be called directly by the user.

 use mpfunmod
 use mpdefmod
 private kdb, mp4, mp24, mp41
 parameter (kdb = kind (0.d0), mp4 = mpwds + 4, mp24 = 2 * mp4, mp41 = mp4 + 1)
private mp_netzx_10, mp_netzx_01, mp_netzx_20, mp_netzx_02, mp_netzx_11, mp_netzx_22
private mp_netxz_10, mp_netxz_01, mp_netxz_20, mp_netxz_02, mp_netxz_11, mp_netxz_22
private mp_netzd_10, mp_netzd_01, mp_netzd_20, mp_netzd_02, mp_netzd_11, mp_netzd_22
private mp_netdz_10, mp_netdz_01, mp_netdz_20, mp_netdz_02, mp_netdz_11, mp_netdz_22
private mp_netzi_10, mp_netzi_01, mp_netzi_20, mp_netzi_02, mp_netzi_11, mp_netzi_22
private mp_netiz_10, mp_netiz_01, mp_netiz_20, mp_netiz_02, mp_netiz_11, mp_netiz_22
private mp_netzz_10, mp_netzz_01, mp_netzz_20, mp_netzz_02, mp_netzz_11, mp_netzz_22
private mp_netzq_10, mp_netzq_01, mp_netzq_20, mp_netzq_02, mp_netzq_11, mp_netzq_22
private mp_netzj_10, mp_netzj_01, mp_netzj_20, mp_netzj_02, mp_netzj_11, mp_netzj_22
private mp_eqtzx_10, mp_eqtzx_01, mp_eqtzx_20, mp_eqtzx_02, mp_eqtzx_11, mp_eqtzx_22
private mp_eqtxz_10, mp_eqtxz_01, mp_eqtxz_20, mp_eqtxz_02, mp_eqtxz_11, mp_eqtxz_22
private mp_eqtzd_10, mp_eqtzd_01, mp_eqtzd_20, mp_eqtzd_02, mp_eqtzd_11, mp_eqtzd_22
private mp_eqtdz_10, mp_eqtdz_01, mp_eqtdz_20, mp_eqtdz_02, mp_eqtdz_11, mp_eqtdz_22
private mp_eqtzi_10, mp_eqtzi_01, mp_eqtzi_20, mp_eqtzi_02, mp_eqtzi_11, mp_eqtzi_22
private mp_eqtiz_10, mp_eqtiz_01, mp_eqtiz_20, mp_eqtiz_02, mp_eqtiz_11, mp_eqtiz_22
private mp_eqtzz_10, mp_eqtzz_01, mp_eqtzz_20, mp_eqtzz_02, mp_eqtzz_11, mp_eqtzz_22
private mp_eqtzq_10, mp_eqtzq_01, mp_eqtzq_20, mp_eqtzq_02, mp_eqtzq_11, mp_eqtzq_22
private mp_eqtzj_10, mp_eqtzj_01, mp_eqtzj_20, mp_eqtzj_02, mp_eqtzj_11, mp_eqtzj_22
private mp_expzi_10, mp_expzi_01, mp_expzi_20, mp_expzi_02, mp_expzi_11, mp_expzi_22
private mp_divzx_10, mp_divzx_01, mp_divzx_20, mp_divzx_02, mp_divzx_11, mp_divzx_22
private mp_divxz_10, mp_divxz_01, mp_divxz_20, mp_divxz_02, mp_divxz_11, mp_divxz_22
private mp_divzd_10, mp_divzd_01, mp_divzd_20, mp_divzd_02, mp_divzd_11, mp_divzd_22
private mp_divdz_10, mp_divdz_01, mp_divdz_20, mp_divdz_02, mp_divdz_11, mp_divdz_22
private mp_divzi_10, mp_divzi_01, mp_divzi_20, mp_divzi_02, mp_divzi_11, mp_divzi_22
private mp_diviz_10, mp_diviz_01, mp_diviz_20, mp_diviz_02, mp_diviz_11, mp_diviz_22
private mp_divzz_10, mp_divzz_01, mp_divzz_20, mp_divzz_02, mp_divzz_11, mp_divzz_22
private mp_divzq_10, mp_divzq_01, mp_divzq_20, mp_divzq_02, mp_divzq_11, mp_divzq_22
private mp_divzj_10, mp_divzj_01, mp_divzj_20, mp_divzj_02, mp_divzj_11, mp_divzj_22
private mp_mulzx_10, mp_mulzx_01, mp_mulzx_20, mp_mulzx_02, mp_mulzx_11, mp_mulzx_22
private mp_mulxz_10, mp_mulxz_01, mp_mulxz_20, mp_mulxz_02, mp_mulxz_11, mp_mulxz_22
private mp_mulzd_10, mp_mulzd_01, mp_mulzd_20, mp_mulzd_02, mp_mulzd_11, mp_mulzd_22
private mp_muldz_10, mp_muldz_01, mp_muldz_20, mp_muldz_02, mp_muldz_11, mp_muldz_22
private mp_mulzi_10, mp_mulzi_01, mp_mulzi_20, mp_mulzi_02, mp_mulzi_11, mp_mulzi_22
private mp_muliz_10, mp_muliz_01, mp_muliz_20, mp_muliz_02, mp_muliz_11, mp_muliz_22
private mp_mulzz_10, mp_mulzz_01, mp_mulzz_20, mp_mulzz_02, mp_mulzz_11, mp_mulzz_22
private mp_mulzq_10, mp_mulzq_01, mp_mulzq_20, mp_mulzq_02, mp_mulzq_11, mp_mulzq_22
private mp_mulzj_10, mp_mulzj_01, mp_mulzj_20, mp_mulzj_02, mp_mulzj_11, mp_mulzj_22
private mp_negz_1, mp_negz_2
private mp_subzx_10, mp_subzx_01, mp_subzx_20, mp_subzx_02, mp_subzx_11, mp_subzx_22
private mp_subxz_10, mp_subxz_01, mp_subxz_20, mp_subxz_02, mp_subxz_11, mp_subxz_22
private mp_subzd_10, mp_subzd_01, mp_subzd_20, mp_subzd_02, mp_subzd_11, mp_subzd_22
private mp_subdz_10, mp_subdz_01, mp_subdz_20, mp_subdz_02, mp_subdz_11, mp_subdz_22
private mp_subzi_10, mp_subzi_01, mp_subzi_20, mp_subzi_02, mp_subzi_11, mp_subzi_22
private mp_subiz_10, mp_subiz_01, mp_subiz_20, mp_subiz_02, mp_subiz_11, mp_subiz_22
private mp_subzz_10, mp_subzz_01, mp_subzz_20, mp_subzz_02, mp_subzz_11, mp_subzz_22
private mp_subzq_10, mp_subzq_01, mp_subzq_20, mp_subzq_02, mp_subzq_11, mp_subzq_22
private mp_subzj_10, mp_subzj_01, mp_subzj_20, mp_subzj_02, mp_subzj_11, mp_subzj_22
private mp_addzx_10, mp_addzx_01, mp_addzx_20, mp_addzx_02, mp_addzx_11, mp_addzx_22
private mp_addxz_10, mp_addxz_01, mp_addxz_20, mp_addxz_02, mp_addxz_11, mp_addxz_22
private mp_addzd_10, mp_addzd_01, mp_addzd_20, mp_addzd_02, mp_addzd_11, mp_addzd_22
private mp_adddz_10, mp_adddz_01, mp_adddz_20, mp_adddz_02, mp_adddz_11, mp_adddz_22
private mp_addzi_10, mp_addzi_01, mp_addzi_20, mp_addzi_02, mp_addzi_11, mp_addzi_22
private mp_addiz_10, mp_addiz_01, mp_addiz_20, mp_addiz_02, mp_addiz_11, mp_addiz_22
private mp_addzz_10, mp_addzz_01, mp_addzz_20, mp_addzz_02, mp_addzz_11, mp_addzz_22
private mp_addzq_10, mp_addzq_01, mp_addzq_20, mp_addzq_02, mp_addzq_11, mp_addzq_22
private mp_addzj_10, mp_addzj_01, mp_addzj_20, mp_addzj_02, mp_addzj_11, mp_addzj_22
private mp_eqzx_10, mp_eqzx_11, mp_eqzx_20, mp_eqzx_22
private mp_eqxz_10, mp_eqxz_11, mp_eqxz_20, mp_eqxz_22
private mp_eqzd_10, mp_eqzd_11, mp_eqzd_20, mp_eqzd_22
private mp_eqdz_10, mp_eqdz_11, mp_eqdz_20, mp_eqdz_22
private mp_eqzi_10, mp_eqzi_11, mp_eqzi_20, mp_eqzi_22
private mp_eqiz_10, mp_eqiz_11, mp_eqiz_20, mp_eqiz_22
private mp_eqzz_10, mp_eqzz_11, mp_eqzz_20, mp_eqzz_22
private mp_eqzq_10, mp_eqzq_11, mp_eqzq_20, mp_eqzq_22
private mp_eqzj_10, mp_eqzj_11, mp_eqzj_20, mp_eqzj_22

 !  MPR operator extension interface blocks.

 interface assignment (=)
module procedure mp_eqzj_10
module procedure mp_eqzj_11
module procedure mp_eqzj_20
module procedure mp_eqzj_22
module procedure mp_eqzq_10
module procedure mp_eqzq_11
module procedure mp_eqzq_20
module procedure mp_eqzq_22
module procedure mp_eqzz_10
module procedure mp_eqzz_11
module procedure mp_eqzz_20
module procedure mp_eqzz_22
module procedure mp_eqiz_10
module procedure mp_eqiz_11
module procedure mp_eqiz_20
module procedure mp_eqiz_22
module procedure mp_eqzi_10
module procedure mp_eqzi_11
module procedure mp_eqzi_20
module procedure mp_eqzi_22
module procedure mp_eqdz_10
module procedure mp_eqdz_11
module procedure mp_eqdz_20
module procedure mp_eqdz_22
module procedure mp_eqzd_10
module procedure mp_eqzd_11
module procedure mp_eqzd_20
module procedure mp_eqzd_22
module procedure mp_eqxz_10
module procedure mp_eqxz_11
module procedure mp_eqxz_20
module procedure mp_eqxz_22
module procedure mp_eqzx_10
module procedure mp_eqzx_11
module procedure mp_eqzx_20
module procedure mp_eqzx_22
 end interface

 interface operator (+)
module procedure mp_addzj_10
module procedure mp_addzj_01
module procedure mp_addzj_20
module procedure mp_addzj_02
module procedure mp_addzj_11
module procedure mp_addzj_22
module procedure mp_addzq_10
module procedure mp_addzq_01
module procedure mp_addzq_20
module procedure mp_addzq_02
module procedure mp_addzq_11
module procedure mp_addzq_22
module procedure mp_addzz_10
module procedure mp_addzz_01
module procedure mp_addzz_20
module procedure mp_addzz_02
module procedure mp_addzz_11
module procedure mp_addzz_22
module procedure mp_addiz_10
module procedure mp_addiz_01
module procedure mp_addiz_20
module procedure mp_addiz_02
module procedure mp_addiz_11
module procedure mp_addiz_22
module procedure mp_addzi_10
module procedure mp_addzi_01
module procedure mp_addzi_20
module procedure mp_addzi_02
module procedure mp_addzi_11
module procedure mp_addzi_22
module procedure mp_adddz_10
module procedure mp_adddz_01
module procedure mp_adddz_20
module procedure mp_adddz_02
module procedure mp_adddz_11
module procedure mp_adddz_22
module procedure mp_addzd_10
module procedure mp_addzd_01
module procedure mp_addzd_20
module procedure mp_addzd_02
module procedure mp_addzd_11
module procedure mp_addzd_22
module procedure mp_addxz_10
module procedure mp_addxz_01
module procedure mp_addxz_20
module procedure mp_addxz_02
module procedure mp_addxz_11
module procedure mp_addxz_22
module procedure mp_addzx_10
module procedure mp_addzx_01
module procedure mp_addzx_20
module procedure mp_addzx_02
module procedure mp_addzx_11
module procedure mp_addzx_22
 end interface

 interface operator (-)
module procedure mp_subzj_10
module procedure mp_subzj_01
module procedure mp_subzj_20
module procedure mp_subzj_02
module procedure mp_subzj_11
module procedure mp_subzj_22
module procedure mp_subzq_10
module procedure mp_subzq_01
module procedure mp_subzq_20
module procedure mp_subzq_02
module procedure mp_subzq_11
module procedure mp_subzq_22
module procedure mp_subzz_10
module procedure mp_subzz_01
module procedure mp_subzz_20
module procedure mp_subzz_02
module procedure mp_subzz_11
module procedure mp_subzz_22
module procedure mp_subiz_10
module procedure mp_subiz_01
module procedure mp_subiz_20
module procedure mp_subiz_02
module procedure mp_subiz_11
module procedure mp_subiz_22
module procedure mp_subzi_10
module procedure mp_subzi_01
module procedure mp_subzi_20
module procedure mp_subzi_02
module procedure mp_subzi_11
module procedure mp_subzi_22
module procedure mp_subdz_10
module procedure mp_subdz_01
module procedure mp_subdz_20
module procedure mp_subdz_02
module procedure mp_subdz_11
module procedure mp_subdz_22
module procedure mp_subzd_10
module procedure mp_subzd_01
module procedure mp_subzd_20
module procedure mp_subzd_02
module procedure mp_subzd_11
module procedure mp_subzd_22
module procedure mp_subxz_10
module procedure mp_subxz_01
module procedure mp_subxz_20
module procedure mp_subxz_02
module procedure mp_subxz_11
module procedure mp_subxz_22
module procedure mp_subzx_10
module procedure mp_subzx_01
module procedure mp_subzx_20
module procedure mp_subzx_02
module procedure mp_subzx_11
module procedure mp_subzx_22
module procedure mp_negz_1
module procedure mp_negz_2
 end interface

 interface operator (*)
module procedure mp_mulzj_10
module procedure mp_mulzj_01
module procedure mp_mulzj_20
module procedure mp_mulzj_02
module procedure mp_mulzj_11
module procedure mp_mulzj_22
module procedure mp_mulzq_10
module procedure mp_mulzq_01
module procedure mp_mulzq_20
module procedure mp_mulzq_02
module procedure mp_mulzq_11
module procedure mp_mulzq_22
module procedure mp_mulzz_10
module procedure mp_mulzz_01
module procedure mp_mulzz_20
module procedure mp_mulzz_02
module procedure mp_mulzz_11
module procedure mp_mulzz_22
module procedure mp_muliz_10
module procedure mp_muliz_01
module procedure mp_muliz_20
module procedure mp_muliz_02
module procedure mp_muliz_11
module procedure mp_muliz_22
module procedure mp_mulzi_10
module procedure mp_mulzi_01
module procedure mp_mulzi_20
module procedure mp_mulzi_02
module procedure mp_mulzi_11
module procedure mp_mulzi_22
module procedure mp_muldz_10
module procedure mp_muldz_01
module procedure mp_muldz_20
module procedure mp_muldz_02
module procedure mp_muldz_11
module procedure mp_muldz_22
module procedure mp_mulzd_10
module procedure mp_mulzd_01
module procedure mp_mulzd_20
module procedure mp_mulzd_02
module procedure mp_mulzd_11
module procedure mp_mulzd_22
module procedure mp_mulxz_10
module procedure mp_mulxz_01
module procedure mp_mulxz_20
module procedure mp_mulxz_02
module procedure mp_mulxz_11
module procedure mp_mulxz_22
module procedure mp_mulzx_10
module procedure mp_mulzx_01
module procedure mp_mulzx_20
module procedure mp_mulzx_02
module procedure mp_mulzx_11
module procedure mp_mulzx_22
 end interface

 interface operator (/)
module procedure mp_divzj_10
module procedure mp_divzj_01
module procedure mp_divzj_20
module procedure mp_divzj_02
module procedure mp_divzj_11
module procedure mp_divzj_22
module procedure mp_divzq_10
module procedure mp_divzq_01
module procedure mp_divzq_20
module procedure mp_divzq_02
module procedure mp_divzq_11
module procedure mp_divzq_22
module procedure mp_divzz_10
module procedure mp_divzz_01
module procedure mp_divzz_20
module procedure mp_divzz_02
module procedure mp_divzz_11
module procedure mp_divzz_22
module procedure mp_diviz_10
module procedure mp_diviz_01
module procedure mp_diviz_20
module procedure mp_diviz_02
module procedure mp_diviz_11
module procedure mp_diviz_22
module procedure mp_divzi_10
module procedure mp_divzi_01
module procedure mp_divzi_20
module procedure mp_divzi_02
module procedure mp_divzi_11
module procedure mp_divzi_22
module procedure mp_divdz_10
module procedure mp_divdz_01
module procedure mp_divdz_20
module procedure mp_divdz_02
module procedure mp_divdz_11
module procedure mp_divdz_22
module procedure mp_divzd_10
module procedure mp_divzd_01
module procedure mp_divzd_20
module procedure mp_divzd_02
module procedure mp_divzd_11
module procedure mp_divzd_22
module procedure mp_divxz_10
module procedure mp_divxz_01
module procedure mp_divxz_20
module procedure mp_divxz_02
module procedure mp_divxz_11
module procedure mp_divxz_22
module procedure mp_divzx_10
module procedure mp_divzx_01
module procedure mp_divzx_20
module procedure mp_divzx_02
module procedure mp_divzx_11
module procedure mp_divzx_22
 end interface

 interface operator (**)
module procedure mp_expzi_10
module procedure mp_expzi_01
module procedure mp_expzi_20
module procedure mp_expzi_02
module procedure mp_expzi_11
module procedure mp_expzi_22
 end interface

 interface operator (.eq.)
module procedure mp_eqtzj_10
module procedure mp_eqtzj_01
module procedure mp_eqtzj_20
module procedure mp_eqtzj_02
module procedure mp_eqtzj_11
module procedure mp_eqtzj_22
module procedure mp_eqtzq_10
module procedure mp_eqtzq_01
module procedure mp_eqtzq_20
module procedure mp_eqtzq_02
module procedure mp_eqtzq_11
module procedure mp_eqtzq_22
module procedure mp_eqtzz_10
module procedure mp_eqtzz_01
module procedure mp_eqtzz_20
module procedure mp_eqtzz_02
module procedure mp_eqtzz_11
module procedure mp_eqtzz_22
module procedure mp_eqtiz_10
module procedure mp_eqtiz_01
module procedure mp_eqtiz_20
module procedure mp_eqtiz_02
module procedure mp_eqtiz_11
module procedure mp_eqtiz_22
module procedure mp_eqtzi_10
module procedure mp_eqtzi_01
module procedure mp_eqtzi_20
module procedure mp_eqtzi_02
module procedure mp_eqtzi_11
module procedure mp_eqtzi_22
module procedure mp_eqtdz_10
module procedure mp_eqtdz_01
module procedure mp_eqtdz_20
module procedure mp_eqtdz_02
module procedure mp_eqtdz_11
module procedure mp_eqtdz_22
module procedure mp_eqtzd_10
module procedure mp_eqtzd_01
module procedure mp_eqtzd_20
module procedure mp_eqtzd_02
module procedure mp_eqtzd_11
module procedure mp_eqtzd_22
module procedure mp_eqtxz_10
module procedure mp_eqtxz_01
module procedure mp_eqtxz_20
module procedure mp_eqtxz_02
module procedure mp_eqtxz_11
module procedure mp_eqtxz_22
module procedure mp_eqtzx_10
module procedure mp_eqtzx_01
module procedure mp_eqtzx_20
module procedure mp_eqtzx_02
module procedure mp_eqtzx_11
module procedure mp_eqtzx_22
 end interface

 interface operator (.ne.)
module procedure mp_netzj_10
module procedure mp_netzj_01
module procedure mp_netzj_20
module procedure mp_netzj_02
module procedure mp_netzj_11
module procedure mp_netzj_22
module procedure mp_netzq_10
module procedure mp_netzq_01
module procedure mp_netzq_20
module procedure mp_netzq_02
module procedure mp_netzq_11
module procedure mp_netzq_22
module procedure mp_netzz_10
module procedure mp_netzz_01
module procedure mp_netzz_20
module procedure mp_netzz_02
module procedure mp_netzz_11
module procedure mp_netzz_22
module procedure mp_netiz_10
module procedure mp_netiz_01
module procedure mp_netiz_20
module procedure mp_netiz_02
module procedure mp_netiz_11
module procedure mp_netiz_22
module procedure mp_netzi_10
module procedure mp_netzi_01
module procedure mp_netzi_20
module procedure mp_netzi_02
module procedure mp_netzi_11
module procedure mp_netzi_22
module procedure mp_netdz_10
module procedure mp_netdz_01
module procedure mp_netdz_20
module procedure mp_netdz_02
module procedure mp_netdz_11
module procedure mp_netdz_22
module procedure mp_netzd_10
module procedure mp_netzd_01
module procedure mp_netzd_20
module procedure mp_netzd_02
module procedure mp_netzd_11
module procedure mp_netzd_22
module procedure mp_netxz_10
module procedure mp_netxz_01
module procedure mp_netxz_20
module procedure mp_netxz_02
module procedure mp_netxz_11
module procedure mp_netxz_22
module procedure mp_netzx_10
module procedure mp_netzx_01
module procedure mp_netzx_20
module procedure mp_netzx_02
module procedure mp_netzx_11
module procedure mp_netzx_22
 end interface

contains

 !  MPC assignment routines.

 subroutine mp_eqzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: jb
dimension za(:)
integer ii1
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzj_10

 subroutine mp_eqzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: jb
dimension za(:)
dimension jb(:)
integer ii1
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzj_11

 subroutine mp_eqzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: jb
dimension za(:,:)
integer ii1,ii2
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzj_20

 subroutine mp_eqzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: jb
dimension za(:,:)
dimension jb(:,:)
integer ii1,ii2
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzj_22

 subroutine mp_eqzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: qb
  integer mpnw
dimension za(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzq_10

 subroutine mp_eqzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: qb
  integer mpnw
dimension za(:)
dimension qb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzq_11

 subroutine mp_eqzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: qb
  integer mpnw
dimension za(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzq_20

 subroutine mp_eqzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: qb
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzq_22

 subroutine mp_eqzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: zb
  integer mpnw
dimension za(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpceq (mp4, zb%mpc, za(ii1)%mpc, mpnw) 
end do 
  return
 end subroutine mp_eqzz_10

 subroutine mp_eqzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: zb
  integer mpnw
dimension za(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpceq (mp4, zb(ii1)%mpc, za(ii1)%mpc, mpnw) 
end do 
  return
 end subroutine mp_eqzz_11

 subroutine mp_eqzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: zb
  integer mpnw
dimension za(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpceq (mp4, zb%mpc, za(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqzz_20

 subroutine mp_eqzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpceq (mp4, zb(ii1,ii2)%mpc, za(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end subroutine mp_eqzz_22

 subroutine mp_eqiz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: zb
  integer mpnw
dimension ia(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (zb%mpc, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqiz_10

 subroutine mp_eqiz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: zb
  integer mpnw
dimension ia(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  call mpmdc (zb(ii1)%mpc, db, ib)
  ia(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqiz_11

 subroutine mp_eqiz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: zb
  integer mpnw
dimension ia(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (zb%mpc, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqiz_20

 subroutine mp_eqiz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: ia
  intent (in):: zb
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  call mpmdc (zb(ii1,ii2)%mpc, db, ib)
  ia(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqiz_22

 subroutine mp_eqzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: ib
  integer mpnw
dimension za(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib
  call mpxzc (xb, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzi_10

 subroutine mp_eqzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: ib
  integer mpnw
dimension za(:)
dimension ib(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib(ii1)
  call mpxzc (xb, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzi_11

 subroutine mp_eqzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: ib
  integer mpnw
dimension za(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib
  call mpxzc (xb, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzi_20

 subroutine mp_eqzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: ib
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzi_22

 subroutine mp_eqdz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: zb
  integer mpnw
dimension da(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (zb%mpc, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdz_10

 subroutine mp_eqdz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: zb
  integer mpnw
dimension da(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpmdc (zb(ii1)%mpc, db, ib)
  da(ii1) = db * 2.d0 ** ib
end do 
  return
 end subroutine mp_eqdz_11

 subroutine mp_eqdz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: zb
  integer mpnw
dimension da(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (zb%mpc, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdz_20

 subroutine mp_eqdz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: da
  intent (in):: zb
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpmdc (zb(ii1,ii2)%mpc, db, ib)
  da(ii1,ii2) = db * 2.d0 ** ib
end do 
end do 
  return
 end subroutine mp_eqdz_22

 subroutine mp_eqzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: db
  integer mpnw
dimension za(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db
  call mpxzc (xb, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzd_10

 subroutine mp_eqzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: db
  integer mpnw
dimension za(:)
dimension db(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db(ii1)
  call mpxzc (xb, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzd_11

 subroutine mp_eqzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: db
  integer mpnw
dimension za(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db
  call mpxzc (xb, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzd_20

 subroutine mp_eqzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: db
  integer mpnw
dimension za(:,:)
dimension db(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzd_22

 subroutine mp_eqxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: zb
  integer mpnw
dimension xa(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (zb%mpc, db, ib)
  call mpmdc (zb%mpc(mp41), dc, ic)
  xa(ii1) = cmplx (db * 2.d0 ** ib, dc * 2.d0 ** ic, kdb)
end do 
  return
 end subroutine mp_eqxz_10

 subroutine mp_eqxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: zb
  integer mpnw
dimension xa(:)
dimension zb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpmdc (zb(ii1)%mpc, db, ib)
  call mpmdc (zb(ii1)%mpc(mp41), dc, ic)
  xa(ii1) = cmplx (db * 2.d0 ** ib, dc * 2.d0 ** ic, kdb)
end do 
  return
 end subroutine mp_eqxz_11

 subroutine mp_eqxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: zb
  integer mpnw
dimension xa(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (zb%mpc, db, ib)
  call mpmdc (zb%mpc(mp41), dc, ic)
  xa(ii1,ii2) = cmplx (db * 2.d0 ** ib, dc * 2.d0 ** ic, kdb)
end do 
end do 
  return
 end subroutine mp_eqxz_20

 subroutine mp_eqxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: xa
  intent (in):: zb
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpmdc (zb(ii1,ii2)%mpc, db, ib)
  call mpmdc (zb(ii1,ii2)%mpc(mp41), dc, ic)
  xa(ii1,ii2) = cmplx (db * 2.d0 ** ib, dc * 2.d0 ** ic, kdb)
end do 
end do 
  return
 end subroutine mp_eqxz_22

 subroutine mp_eqzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: xb
  integer mpnw
dimension za(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzx_10

 subroutine mp_eqzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: xb
  integer mpnw
dimension za(:)
dimension xb(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), za(ii1)%mpc)
end do 
  return
 end subroutine mp_eqzx_11

 subroutine mp_eqzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: xb
  integer mpnw
dimension za(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzx_20

 subroutine mp_eqzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: za
  intent (in):: xb
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), za(ii1,ii2)%mpc)
end do 
end do 
  return
 end subroutine mp_eqzx_22

 !  MPC add routines.

 function mp_addzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_addzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzj_10

 function mp_addzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_addzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzj_01

 function mp_addzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_addzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzj_20

 function mp_addzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_addzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzj_02

 function mp_addzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_addzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzj_11

 function mp_addzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_addzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzj_22

 function mp_addzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_10
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_addzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzq_10

 function mp_addzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_01
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:)
dimension mp_addzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzq_01

 function mp_addzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_20
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_addzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzq_20

 function mp_addzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_02
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:,:)
dimension mp_addzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzq_02

 function mp_addzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_11
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_addzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzq_11

 function mp_addzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzq_22
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_addzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzq_22

 function mp_addzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_addzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcadd (mp4, za(ii1)%mpc, zb%mpc, mp_addzz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzz_10

 function mp_addzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_addzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcadd (mp4, za%mpc, zb(ii1)%mpc, mp_addzz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzz_01

 function mp_addzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_addzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcadd (mp4, za(ii1,ii2)%mpc, zb%mpc, mp_addzz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzz_20

 function mp_addzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_addzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcadd (mp4, za%mpc, zb(ii1,ii2)%mpc, mp_addzz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzz_02

 function mp_addzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_addzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcadd (mp4, za(ii1)%mpc, zb(ii1)%mpc, mp_addzz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzz_11

 function mp_addzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_addzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcadd (mp4, za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, mp_addzz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzz_22

 function mp_addiz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_addiz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addiz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addiz_10

 function mp_addiz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_addiz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addiz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addiz_01

 function mp_addiz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_addiz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addiz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addiz_20

 function mp_addiz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_addiz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addiz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addiz_02

 function mp_addiz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_addiz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addiz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addiz_11

 function mp_addiz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addiz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_addiz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addiz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addiz_22

 function mp_addzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_addzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzi_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzi_10

 function mp_addzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_addzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzi_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzi_01

 function mp_addzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_addzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzi_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzi_20

 function mp_addzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_addzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzi_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzi_02

 function mp_addzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_addzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzi_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzi_11

 function mp_addzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_addzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzi_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzi_22

 function mp_adddz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_adddz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_adddz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_adddz_10

 function mp_adddz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_adddz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_adddz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_adddz_01

 function mp_adddz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_adddz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_adddz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_adddz_20

 function mp_adddz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_adddz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_adddz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_adddz_02

 function mp_adddz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_adddz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_adddz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_adddz_11

 function mp_adddz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_adddz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_adddz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_adddz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_adddz_22

 function mp_addzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_addzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzd_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzd_10

 function mp_addzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_addzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzd_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzd_01

 function mp_addzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_addzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzd_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzd_20

 function mp_addzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_addzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za%mpc, z1%mpc, mp_addzd_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzd_02

 function mp_addzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_addzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, z1%mpc, mp_addzd_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzd_11

 function mp_addzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_addzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_addzd_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzd_22

 function mp_addxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_addxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addxz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxz_10

 function mp_addxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_addxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addxz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxz_01

 function mp_addxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_addxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcadd (mp4, z1%mpc, zb%mpc, mp_addxz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxz_20

 function mp_addxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_addxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addxz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxz_02

 function mp_addxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_addxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1)%mpc, mp_addxz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addxz_11

 function mp_addxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_addxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcadd (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_addxz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addxz_22

 function mp_addzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_10
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension za(:)
dimension mp_addzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, q1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, q1%mpc, mp_addzx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzx_10

 function mp_addzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_01
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension xb(:)
dimension mp_addzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), q1%mpc)
  call mpcadd (mp4, za%mpc, q1%mpc, mp_addzx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzx_01

 function mp_addzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_20
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension za(:,:)
dimension mp_addzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, q1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, q1%mpc, mp_addzx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzx_20

 function mp_addzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_02
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension xb(:,:)
dimension mp_addzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), q1%mpc)
  call mpcadd (mp4, za%mpc, q1%mpc, mp_addzx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzx_02

 function mp_addzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_11
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_addzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), q1%mpc)
  call mpcadd (mp4, za(ii1)%mpc, q1%mpc, mp_addzx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_addzx_11

 function mp_addzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_addzx_22
  intent (in):: za, xb
  type (mp_complex) q1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_addzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), q1%mpc)
  call mpcadd (mp4, za(ii1,ii2)%mpc, q1%mpc, mp_addzx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_addzx_22

 !  MPC subtract routines.

 function mp_subzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_subzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzj_10

 function mp_subzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_subzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzj_01

 function mp_subzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_subzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzj_20

 function mp_subzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_subzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzj_02

 function mp_subzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_subzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzj_11

 function mp_subzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_subzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzj_22

 function mp_subzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_10
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension za(:)
dimension mp_subzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzq_10

 function mp_subzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_01
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension qb(:)
dimension mp_subzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzq_01

 function mp_subzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_20
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension za(:,:)
dimension mp_subzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzq_20

 function mp_subzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_02
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension qb(:,:)
dimension mp_subzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzq_02

 function mp_subzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_11
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_subzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzq_11

 function mp_subzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzq_22
  type (mp_complex) z1
  intent (in):: za, qb
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_subzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzq_22

 function mp_subzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_subzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcsub (mp4, za(ii1)%mpc, zb%mpc, mp_subzz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzz_10

 function mp_subzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_subzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcsub (mp4, za%mpc, zb(ii1)%mpc, mp_subzz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzz_01

 function mp_subzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_subzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcsub (mp4, za(ii1,ii2)%mpc, zb%mpc, mp_subzz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzz_20

 function mp_subzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_subzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcsub (mp4, za%mpc, zb(ii1,ii2)%mpc, mp_subzz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzz_02

 function mp_subzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_subzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcsub (mp4, za(ii1)%mpc, zb(ii1)%mpc, mp_subzz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzz_11

 function mp_subzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_subzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcsub (mp4, za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, mp_subzz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzz_22

 function mp_subiz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_subiz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subiz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subiz_10

 function mp_subiz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_subiz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subiz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subiz_01

 function mp_subiz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_subiz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subiz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subiz_20

 function mp_subiz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_subiz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subiz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subiz_02

 function mp_subiz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_subiz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subiz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subiz_11

 function mp_subiz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subiz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_subiz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subiz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subiz_22

 function mp_subzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_subzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzi_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzi_10

 function mp_subzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_subzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzi_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzi_01

 function mp_subzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_subzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzi_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzi_20

 function mp_subzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_subzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzi_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzi_02

 function mp_subzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_subzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzi_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzi_11

 function mp_subzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_subzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzi_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzi_22

 function mp_subdz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_subdz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subdz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subdz_10

 function mp_subdz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_subdz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subdz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subdz_01

 function mp_subdz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_subdz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subdz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subdz_20

 function mp_subdz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_subdz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subdz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subdz_02

 function mp_subdz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_subdz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subdz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subdz_11

 function mp_subdz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subdz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_subdz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subdz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subdz_22

 function mp_subzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_subzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzd_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzd_10

 function mp_subzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_subzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzd_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzd_01

 function mp_subzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_subzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzd_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzd_20

 function mp_subzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_subzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzd_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzd_02

 function mp_subzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_subzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzd_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzd_11

 function mp_subzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_subzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzd_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzd_22

 function mp_subxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_subxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subxz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxz_10

 function mp_subxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_subxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subxz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxz_01

 function mp_subxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_subxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcsub (mp4, z1%mpc, zb%mpc, mp_subxz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxz_20

 function mp_subxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_subxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subxz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxz_02

 function mp_subxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_subxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1)%mpc, mp_subxz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subxz_11

 function mp_subxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_subxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcsub (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_subxz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subxz_22

 function mp_subzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_10
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_subzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzx_10

 function mp_subzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_01
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:)
dimension mp_subzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzx_01

 function mp_subzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_20
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_subzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzx_20

 function mp_subzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_02
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:,:)
dimension mp_subzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcsub (mp4, za%mpc, z1%mpc, mp_subzx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzx_02

 function mp_subzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_11
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_subzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcsub (mp4, za(ii1)%mpc, z1%mpc, mp_subzx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_subzx_11

 function mp_subzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_subzx_22
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_subzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcsub (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_subzx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_subzx_22

 !  MPC negation routine.

 function mp_negz_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_negz_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_negz_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpceq (mp4, za(ii1)%mpc, mp_negz_1(ii1)%mpc, mpnw) 
  mp_negz_1(ii1)%mpc(1) = - za(ii1)%mpc(1)
  mp_negz_1(ii1)%mpc(mp41) = - za(ii1)%mpc(mp41)
end do 
  return
 end function mp_negz_1

 function mp_negz_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_negz_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_negz_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpceq (mp4, za(ii1,ii2)%mpc, mp_negz_2(ii1,ii2)%mpc, mpnw) 
  mp_negz_2(ii1,ii2)%mpc(1) = - za(ii1,ii2)%mpc(1)
  mp_negz_2(ii1,ii2)%mpc(mp41) = - za(ii1,ii2)%mpc(mp41)
end do 
end do 
  return
 end function mp_negz_2

 !  MPC multiply routines.

 function mp_mulzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_mulzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzj_10

 function mp_mulzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_mulzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzj_01

 function mp_mulzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_mulzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzj_20

 function mp_mulzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_mulzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzj_02

 function mp_mulzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_mulzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzj_11

 function mp_mulzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_mulzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzj_22

 function mp_mulzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_10
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_mulzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzq_10

 function mp_mulzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_01
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:)
dimension mp_mulzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzq_01

 function mp_mulzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_20
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_mulzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzq_20

 function mp_mulzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_02
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:,:)
dimension mp_mulzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzq_02

 function mp_mulzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_11
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_mulzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzq_11

 function mp_mulzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzq_22
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_mulzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzq_22

 function mp_mulzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_mulzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcmul (mp4, za(ii1)%mpc, zb%mpc, mp_mulzz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzz_10

 function mp_mulzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_mulzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcmul (mp4, za%mpc, zb(ii1)%mpc, mp_mulzz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzz_01

 function mp_mulzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_mulzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcmul (mp4, za(ii1,ii2)%mpc, zb%mpc, mp_mulzz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzz_20

 function mp_mulzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_mulzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcmul (mp4, za%mpc, zb(ii1,ii2)%mpc, mp_mulzz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzz_02

 function mp_mulzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_mulzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcmul (mp4, za(ii1)%mpc, zb(ii1)%mpc, mp_mulzz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzz_11

 function mp_mulzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_mulzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcmul (mp4, za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, mp_mulzz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzz_22

 function mp_muliz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_muliz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muliz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muliz_10

 function mp_muliz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_muliz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muliz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muliz_01

 function mp_muliz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_muliz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muliz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muliz_20

 function mp_muliz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_muliz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muliz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muliz_02

 function mp_muliz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_muliz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muliz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muliz_11

 function mp_muliz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muliz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_muliz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muliz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muliz_22

 function mp_mulzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_mulzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzi_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzi_10

 function mp_mulzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_mulzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzi_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzi_01

 function mp_mulzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_mulzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzi_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzi_20

 function mp_mulzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_mulzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzi_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzi_02

 function mp_mulzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_mulzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzi_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzi_11

 function mp_mulzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_mulzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzi_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzi_22

 function mp_muldz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_muldz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muldz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muldz_10

 function mp_muldz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_muldz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muldz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muldz_01

 function mp_muldz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_muldz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_muldz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muldz_20

 function mp_muldz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_muldz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muldz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muldz_02

 function mp_muldz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_muldz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_muldz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_muldz_11

 function mp_muldz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_muldz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_muldz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_muldz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_muldz_22

 function mp_mulzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_mulzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzd_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzd_10

 function mp_mulzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_mulzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzd_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzd_01

 function mp_mulzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_mulzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzd_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzd_20

 function mp_mulzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_mulzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzd_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzd_02

 function mp_mulzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_mulzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzd_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzd_11

 function mp_mulzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_mulzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzd_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzd_22

 function mp_mulxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_mulxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_mulxz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxz_10

 function mp_mulxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_mulxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_mulxz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxz_01

 function mp_mulxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_mulxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcmul (mp4, z1%mpc, zb%mpc, mp_mulxz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxz_20

 function mp_mulxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_mulxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_mulxz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxz_02

 function mp_mulxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_mulxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1)%mpc, mp_mulxz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulxz_11

 function mp_mulxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_mulxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcmul (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_mulxz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulxz_22

 function mp_mulzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_10
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_mulzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzx_10

 function mp_mulzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_01
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:)
dimension mp_mulzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzx_01

 function mp_mulzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_20
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_mulzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzx_20

 function mp_mulzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_02
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:,:)
dimension mp_mulzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcmul (mp4, za%mpc, z1%mpc, mp_mulzx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzx_02

 function mp_mulzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_11
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_mulzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcmul (mp4, za(ii1)%mpc, z1%mpc, mp_mulzx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_mulzx_11

 function mp_mulzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_mulzx_22
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_mulzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcmul (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_mulzx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_mulzx_22

 !  MPC divide routines.

 function mp_divzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_divzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzj_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzj_10

 function mp_divzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_divzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzj_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzj_01

 function mp_divzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_divzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzj_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzj_20

 function mp_divzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_divzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzj_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzj_02

 function mp_divzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_divzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzj_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzj_11

 function mp_divzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_divzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzj_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzj_22

 function mp_divzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_10
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_divzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzq_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzq_10

 function mp_divzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_01
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:)
dimension mp_divzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzq_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzq_01

 function mp_divzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_20
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_divzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzq_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzq_20

 function mp_divzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_02
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:,:)
dimension mp_divzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzq_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzq_02

 function mp_divzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_11
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_divzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzq_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzq_11

 function mp_divzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzq_22
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_divzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzq_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzq_22

 function mp_divzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_divzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcdiv (mp4, za(ii1)%mpc, zb%mpc, mp_divzz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzz_10

 function mp_divzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_divzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcdiv (mp4, za%mpc, zb(ii1)%mpc, mp_divzz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzz_01

 function mp_divzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_divzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, zb%mpc, mp_divzz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzz_20

 function mp_divzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_divzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcdiv (mp4, za%mpc, zb(ii1,ii2)%mpc, mp_divzz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzz_02

 function mp_divzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_divzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcdiv (mp4, za(ii1)%mpc, zb(ii1)%mpc, mp_divzz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzz_11

 function mp_divzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_divzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, mp_divzz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzz_22

 function mp_diviz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_diviz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_diviz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_diviz_10

 function mp_diviz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_diviz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_diviz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_diviz_01

 function mp_diviz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_diviz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_diviz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_diviz_20

 function mp_diviz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_diviz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = ia
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_diviz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_diviz_02

 function mp_diviz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_diviz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_diviz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_diviz_11

 function mp_diviz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_diviz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_diviz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_diviz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_diviz_22

 function mp_divzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_divzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzi_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzi_10

 function mp_divzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_divzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzi_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzi_01

 function mp_divzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_divzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzi_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzi_20

 function mp_divzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_divzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzi_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzi_02

 function mp_divzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_divzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = ib(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzi_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzi_11

 function mp_divzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_divzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = ib(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzi_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzi_22

 function mp_divdz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_divdz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divdz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divdz_10

 function mp_divdz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_divdz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divdz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divdz_01

 function mp_divdz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_divdz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divdz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divdz_20

 function mp_divdz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_divdz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  xa = da
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divdz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divdz_02

 function mp_divdz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_divdz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divdz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divdz_11

 function mp_divdz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divdz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_divdz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divdz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divdz_22

 function mp_divzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_divzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzd_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzd_10

 function mp_divzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_divzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzd_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzd_01

 function mp_divzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_divzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzd_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzd_20

 function mp_divzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_divzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzd_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzd_02

 function mp_divzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_divzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  xb = db(ii1)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzd_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzd_11

 function mp_divzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_divzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  xb = db(ii1,ii2)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzd_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzd_22

 function mp_divxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_divxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divxz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxz_10

 function mp_divxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_divxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divxz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxz_01

 function mp_divxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_divxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb%mpc, mp_divxz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxz_20

 function mp_divxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_divxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divxz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxz_02

 function mp_divxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_divxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1)%mpc, mp_divxz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divxz_11

 function mp_divxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_divxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcdiv (mp4, z1%mpc, zb(ii1,ii2)%mpc, mp_divxz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divxz_22

 function mp_divzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_10
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_divzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzx_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzx_10

 function mp_divzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_01
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:)
dimension mp_divzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzx_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzx_01

 function mp_divzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_20
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_divzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzx_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzx_20

 function mp_divzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_02
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:,:)
dimension mp_divzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcdiv (mp4, za%mpc, z1%mpc, mp_divzx_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzx_02

 function mp_divzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_11
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_divzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcdiv (mp4, za(ii1)%mpc, z1%mpc, mp_divzx_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_divzx_11

 function mp_divzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_divzx_22
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_divzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcdiv (mp4, za(ii1,ii2)%mpc, z1%mpc, mp_divzx_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_divzx_22

 !  MPC exponentiation routines.

 function mp_expzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_10
  intent (in):: za, ib
  integer mpnw
dimension za(:)
dimension mp_expzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpwr (mp4, za(ii1)%mpc, ib, mp_expzi_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_expzi_10

 function mp_expzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_01
  intent (in):: za, ib
  integer mpnw
dimension ib(:)
dimension mp_expzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  call mpcpwr (mp4, za%mpc, ib(ii1), mp_expzi_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_expzi_01

 function mp_expzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_20
  intent (in):: za, ib
  integer mpnw
dimension za(:,:)
dimension mp_expzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpwr (mp4, za(ii1,ii2)%mpc, ib, mp_expzi_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_expzi_20

 function mp_expzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_02
  intent (in):: za, ib
  integer mpnw
dimension ib(:,:)
dimension mp_expzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  call mpcpwr (mp4, za%mpc, ib(ii1,ii2), mp_expzi_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_expzi_02

 function mp_expzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_11
  intent (in):: za, ib
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_expzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpwr (mp4, za(ii1)%mpc, ib(ii1), mp_expzi_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_expzi_11

 function mp_expzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expzi_22
  intent (in):: za, ib
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_expzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpwr (mp4, za(ii1,ii2)%mpc, ib(ii1,ii2), mp_expzi_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_expzi_22

 !  MPC .EQ. routines.

 function mp_eqtzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_eqtzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_10(ii1) = .true.
  else
   mp_eqtzj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzj_10

 function mp_eqtzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_eqtzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_01(ii1) = .true.
  else
   mp_eqtzj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzj_01

 function mp_eqtzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_eqtzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_20(ii1,ii2) = .true.
  else
   mp_eqtzj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzj_20

 function mp_eqtzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_eqtzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_02(ii1,ii2) = .true.
  else
   mp_eqtzj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzj_02

 function mp_eqtzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_eqtzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_11(ii1) = .true.
  else
   mp_eqtzj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzj_11

 function mp_eqtzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_eqtzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzj_22(ii1,ii2) = .true.
  else
   mp_eqtzj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzj_22

 function mp_eqtzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_10
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_eqtzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_10(ii1) = .true.
  else
   mp_eqtzq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzq_10

 function mp_eqtzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_01
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:)
dimension mp_eqtzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_01(ii1) = .true.
  else
   mp_eqtzq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzq_01

 function mp_eqtzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_20
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_eqtzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_20(ii1,ii2) = .true.
  else
   mp_eqtzq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzq_20

 function mp_eqtzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_02
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:,:)
dimension mp_eqtzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_02(ii1,ii2) = .true.
  else
   mp_eqtzq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzq_02

 function mp_eqtzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_11
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_eqtzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_11(ii1) = .true.
  else
   mp_eqtzq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzq_11

 function mp_eqtzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzq_22
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_eqtzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzq_22(ii1,ii2) = .true.
  else
   mp_eqtzq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzq_22

 function mp_eqtzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_eqtzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpr (za(ii1)%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_10(ii1) = .true.
  else
   mp_eqtzz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzz_10

 function mp_eqtzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_eqtzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcpr (za%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_01(ii1) = .true.
  else
   mp_eqtzz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzz_01

 function mp_eqtzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_eqtzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpr (za(ii1,ii2)%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_20(ii1,ii2) = .true.
  else
   mp_eqtzz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzz_20

 function mp_eqtzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_eqtzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcpr (za%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_02(ii1,ii2) = .true.
  else
   mp_eqtzz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzz_02

 function mp_eqtzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_eqtzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpr (za(ii1)%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_11(ii1) = .true.
  else
   mp_eqtzz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzz_11

 function mp_eqtzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_eqtzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpr (za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzz_22(ii1,ii2) = .true.
  else
   mp_eqtzz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzz_22

 function mp_eqtiz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_eqtiz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_10(ii1) = .true.
  else
   mp_eqtiz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiz_10

 function mp_eqtiz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_eqtiz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  da = ia
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_01(ii1) = .true.
  else
   mp_eqtiz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiz_01

 function mp_eqtiz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_eqtiz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_20(ii1,ii2) = .true.
  else
   mp_eqtiz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiz_20

 function mp_eqtiz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_eqtiz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  da = ia
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_02(ii1,ii2) = .true.
  else
   mp_eqtiz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiz_02

 function mp_eqtiz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_eqtiz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_11(ii1) = .true.
  else
   mp_eqtiz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtiz_11

 function mp_eqtiz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtiz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_eqtiz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtiz_22(ii1,ii2) = .true.
  else
   mp_eqtiz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtiz_22

 function mp_eqtzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_eqtzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  db = ib
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_10(ii1) = .true.
  else
   mp_eqtzi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzi_10

 function mp_eqtzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_eqtzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_01(ii1) = .true.
  else
   mp_eqtzi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzi_01

 function mp_eqtzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_eqtzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  db = ib
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_20(ii1,ii2) = .true.
  else
   mp_eqtzi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzi_20

 function mp_eqtzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_eqtzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_02(ii1,ii2) = .true.
  else
   mp_eqtzi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzi_02

 function mp_eqtzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_eqtzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  db = ib(ii1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_11(ii1) = .true.
  else
   mp_eqtzi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzi_11

 function mp_eqtzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_eqtzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzi_22(ii1,ii2) = .true.
  else
   mp_eqtzi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzi_22

 function mp_eqtdz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_eqtdz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_10(ii1) = .true.
  else
   mp_eqtdz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdz_10

 function mp_eqtdz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_eqtdz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_01(ii1) = .true.
  else
   mp_eqtdz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdz_01

 function mp_eqtdz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_eqtdz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_20(ii1,ii2) = .true.
  else
   mp_eqtdz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdz_20

 function mp_eqtdz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_eqtdz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_02(ii1,ii2) = .true.
  else
   mp_eqtdz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdz_02

 function mp_eqtdz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_eqtdz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_11(ii1) = .true.
  else
   mp_eqtdz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtdz_11

 function mp_eqtdz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtdz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_eqtdz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtdz_22(ii1,ii2) = .true.
  else
   mp_eqtdz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtdz_22

 function mp_eqtzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_eqtzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_10(ii1) = .true.
  else
   mp_eqtzd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzd_10

 function mp_eqtzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_eqtzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_01(ii1) = .true.
  else
   mp_eqtzd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzd_01

 function mp_eqtzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_eqtzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_20(ii1,ii2) = .true.
  else
   mp_eqtzd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzd_20

 function mp_eqtzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_eqtzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_02(ii1,ii2) = .true.
  else
   mp_eqtzd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzd_02

 function mp_eqtzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_eqtzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpdmc (db(ii1), 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_11(ii1) = .true.
  else
   mp_eqtzd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzd_11

 function mp_eqtzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_eqtzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpdmc (db(ii1,ii2), 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzd_22(ii1,ii2) = .true.
  else
   mp_eqtzd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzd_22

 function mp_eqtxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_eqtxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_10(ii1) = .true.
  else
   mp_eqtxz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxz_10

 function mp_eqtxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_eqtxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_01(ii1) = .true.
  else
   mp_eqtxz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxz_01

 function mp_eqtxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_eqtxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_20(ii1,ii2) = .true.
  else
   mp_eqtxz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxz_20

 function mp_eqtxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_eqtxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_02(ii1,ii2) = .true.
  else
   mp_eqtxz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxz_02

 function mp_eqtxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_eqtxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_11(ii1) = .true.
  else
   mp_eqtxz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtxz_11

 function mp_eqtxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_eqtxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtxz_22(ii1,ii2) = .true.
  else
   mp_eqtxz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtxz_22

 function mp_eqtzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_10
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_eqtzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_10(ii1) = .true.
  else
   mp_eqtzx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzx_10

 function mp_eqtzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_01
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:)
dimension mp_eqtzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_01(ii1) = .true.
  else
   mp_eqtzx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzx_01

 function mp_eqtzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_20
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_eqtzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_20(ii1,ii2) = .true.
  else
   mp_eqtzx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzx_20

 function mp_eqtzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_02
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:,:)
dimension mp_eqtzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_02(ii1,ii2) = .true.
  else
   mp_eqtzx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzx_02

 function mp_eqtzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_11
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_eqtzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_11(ii1) = .true.
  else
   mp_eqtzx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_eqtzx_11

 function mp_eqtzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_eqtzx_22
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_eqtzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .eq. 0 .and. ic2 .eq. 0) then
   mp_eqtzx_22(ii1,ii2) = .true.
  else
   mp_eqtzx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_eqtzx_22

 !  MPC .NE. routines.

 function mp_netzj_10 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_10
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_netzj_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_10(ii1) = .true.
  else
   mp_netzj_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzj_10

 function mp_netzj_01 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_01
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:)
dimension mp_netzj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_01(ii1) = .true.
  else
   mp_netzj_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzj_01

 function mp_netzj_20 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_20
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_netzj_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb%mpi, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_20(ii1,ii2) = .true.
  else
   mp_netzj_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzj_20

 function mp_netzj_02 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_02
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension jb(:,:)
dimension mp_netzj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_02(ii1,ii2) = .true.
  else
   mp_netzj_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzj_02

 function mp_netzj_11 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_11
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension jb(:)
dimension mp_netzj_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (jb(ii1)%mpi, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_11(ii1) = .true.
  else
   mp_netzj_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzj_11

 function mp_netzj_22 (za, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzj_22
  intent (in):: za, jb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension jb(:,:)
dimension mp_netzj_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (jb(ii1,ii2)%mpi, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzj_22(ii1,ii2) = .true.
  else
   mp_netzj_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzj_22

 function mp_netzq_10 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_10
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_netzq_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_10(ii1) = .true.
  else
   mp_netzq_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzq_10

 function mp_netzq_01 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_01
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:)
dimension mp_netzq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_01(ii1) = .true.
  else
   mp_netzq_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzq_01

 function mp_netzq_20 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_20
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_netzq_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb%mpr, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_20(ii1,ii2) = .true.
  else
   mp_netzq_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzq_20

 function mp_netzq_02 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_02
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension qb(:,:)
dimension mp_netzq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_02(ii1,ii2) = .true.
  else
   mp_netzq_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzq_02

 function mp_netzq_11 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_11
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension qb(:)
dimension mp_netzq_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmzc (qb(ii1)%mpr, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_11(ii1) = .true.
  else
   mp_netzq_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzq_11

 function mp_netzq_22 (za, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzq_22
  intent (in):: za, qb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension qb(:,:)
dimension mp_netzq_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmzc (qb(ii1,ii2)%mpr, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzq_22(ii1,ii2) = .true.
  else
   mp_netzq_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzq_22

 function mp_netzz_10 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_10
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension mp_netzz_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpr (za(ii1)%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_10(ii1) = .true.
  else
   mp_netzz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzz_10

 function mp_netzz_01 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_01
  intent (in):: za, zb
  integer mpnw
dimension zb(:)
dimension mp_netzz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpcpr (za%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_01(ii1) = .true.
  else
   mp_netzz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzz_01

 function mp_netzz_20 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_20
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension mp_netzz_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpr (za(ii1,ii2)%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_20(ii1,ii2) = .true.
  else
   mp_netzz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzz_20

 function mp_netzz_02 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_02
  intent (in):: za, zb
  integer mpnw
dimension zb(:,:)
dimension mp_netzz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpcpr (za%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_02(ii1,ii2) = .true.
  else
   mp_netzz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzz_02

 function mp_netzz_11 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_11
  intent (in):: za, zb
  integer mpnw
dimension za(:)
dimension zb(:)
dimension mp_netzz_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpcpr (za(ii1)%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_11(ii1) = .true.
  else
   mp_netzz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzz_11

 function mp_netzz_22 (za, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzz_22
  intent (in):: za, zb
  integer mpnw
dimension za(:,:)
dimension zb(:,:)
dimension mp_netzz_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpcpr (za(ii1,ii2)%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzz_22(ii1,ii2) = .true.
  else
   mp_netzz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzz_22

 function mp_netiz_10 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_10
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension mp_netiz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_10(ii1) = .true.
  else
   mp_netiz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netiz_10

 function mp_netiz_01 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_01
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_netiz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  da = ia
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_01(ii1) = .true.
  else
   mp_netiz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netiz_01

 function mp_netiz_20 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_20
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension mp_netiz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_20(ii1,ii2) = .true.
  else
   mp_netiz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiz_20

 function mp_netiz_02 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_02
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_netiz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  da = ia
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_02(ii1,ii2) = .true.
  else
   mp_netiz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiz_02

 function mp_netiz_11 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_11
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:)
dimension zb(:)
dimension mp_netiz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_11(ii1) = .true.
  else
   mp_netiz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netiz_11

 function mp_netiz_22 (ia, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netiz_22
  intent (in):: ia, zb
  type (mp_complex) z1
  integer mpnw
dimension ia(:,:)
dimension zb(:,:)
dimension mp_netiz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netiz_22(ii1,ii2) = .true.
  else
   mp_netiz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netiz_22

 function mp_netzi_10 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_10
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_netzi_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  db = ib
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_10(ii1) = .true.
  else
   mp_netzi_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzi_10

 function mp_netzi_01 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_01
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:)
dimension mp_netzi_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  db = ib(ii1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_01(ii1) = .true.
  else
   mp_netzi_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzi_01

 function mp_netzi_20 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_20
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_netzi_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  db = ib
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_20(ii1,ii2) = .true.
  else
   mp_netzi_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzi_20

 function mp_netzi_02 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_02
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension ib(:,:)
dimension mp_netzi_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_02(ii1,ii2) = .true.
  else
   mp_netzi_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzi_02

 function mp_netzi_11 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_11
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension ib(:)
dimension mp_netzi_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  db = ib(ii1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_11(ii1) = .true.
  else
   mp_netzi_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzi_11

 function mp_netzi_22 (za, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzi_22
  intent (in):: za, ib
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension ib(:,:)
dimension mp_netzi_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  db = ib(ii1,ii2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzi_22(ii1,ii2) = .true.
  else
   mp_netzi_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzi_22

 function mp_netdz_10 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_10
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension mp_netdz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_10(ii1) = .true.
  else
   mp_netdz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netdz_10

 function mp_netdz_01 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_01
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_netdz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_01(ii1) = .true.
  else
   mp_netdz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netdz_01

 function mp_netdz_20 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_20
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension mp_netdz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_20(ii1,ii2) = .true.
  else
   mp_netdz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdz_20

 function mp_netdz_02 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_02
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_netdz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpdmc (da, 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_02(ii1,ii2) = .true.
  else
   mp_netdz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdz_02

 function mp_netdz_11 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_11
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:)
dimension zb(:)
dimension mp_netdz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_11(ii1) = .true.
  else
   mp_netdz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netdz_11

 function mp_netdz_22 (da, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netdz_22
  intent (in):: da, zb
  type (mp_complex) z1
  integer mpnw
dimension da(:,:)
dimension zb(:,:)
dimension mp_netdz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netdz_22(ii1,ii2) = .true.
  else
   mp_netdz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netdz_22

 function mp_netzd_10 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_10
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_netzd_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_10(ii1) = .true.
  else
   mp_netzd_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzd_10

 function mp_netzd_01 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_01
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:)
dimension mp_netzd_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  call mpdmc (db(ii1), 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_01(ii1) = .true.
  else
   mp_netzd_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzd_01

 function mp_netzd_20 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_20
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_netzd_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpdmc (db, 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_20(ii1,ii2) = .true.
  else
   mp_netzd_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzd_20

 function mp_netzd_02 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_02
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension db(:,:)
dimension mp_netzd_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  call mpdmc (db(ii1,ii2), 0, z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_02(ii1,ii2) = .true.
  else
   mp_netzd_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzd_02

 function mp_netzd_11 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_11
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension db(:)
dimension mp_netzd_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpdmc (db(ii1), 0, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_11(ii1) = .true.
  else
   mp_netzd_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzd_11

 function mp_netzd_22 (za, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzd_22
  intent (in):: za, db
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension db(:,:)
dimension mp_netzd_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpdmc (db(ii1,ii2), 0, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z1%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzd_22(ii1,ii2) = .true.
  else
   mp_netzd_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzd_22

 function mp_netxz_10 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_10
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension mp_netxz_10(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_10(ii1) = .true.
  else
   mp_netxz_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netxz_10

 function mp_netxz_01 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_01
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:)
dimension mp_netxz_01(size(zb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(zb,1)
  call mpxzc (xa, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_01(ii1) = .true.
  else
   mp_netxz_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netxz_01

 function mp_netxz_20 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_20
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension mp_netxz_20(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcpr (z1%mpc, zb%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_20(ii1,ii2) = .true.
  else
   mp_netxz_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxz_20

 function mp_netxz_02 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_02
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension zb(:,:)
dimension mp_netxz_02(size(zb,1),size(zb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(zb,1)
do ii2=1,size(zb,2)
  call mpxzc (xa, z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_02(ii1,ii2) = .true.
  else
   mp_netxz_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxz_02

 function mp_netxz_11 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_11
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:)
dimension zb(:)
dimension mp_netxz_11(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), z1%mpc)
  call mpcpr (z1%mpc, zb(ii1)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_11(ii1) = .true.
  else
   mp_netxz_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netxz_11

 function mp_netxz_22 (xa, zb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netxz_22
  intent (in):: xa, zb
  type (mp_complex) z1
  integer mpnw
dimension xa(:,:)
dimension zb(:,:)
dimension mp_netxz_22(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), z1%mpc)
  call mpcpr (z1%mpc, zb(ii1,ii2)%mpc, ic1, mpnw) 
  call mpcpr (z1%mpc(mp41), zb(ii1,ii2)%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netxz_22(ii1,ii2) = .true.
  else
   mp_netxz_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netxz_22

 function mp_netzx_10 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_10
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension mp_netzx_10(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb, z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_10(ii1) = .true.
  else
   mp_netzx_10(ii1) = .false.
  endif
end do 
  return
 end function mp_netzx_10

 function mp_netzx_01 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_01
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:)
dimension mp_netzx_01(size(xb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xb,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_01(ii1) = .true.
  else
   mp_netzx_01(ii1) = .false.
  endif
end do 
  return
 end function mp_netzx_01

 function mp_netzx_20 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_20
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension mp_netzx_20(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb, z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_20(ii1,ii2) = .true.
  else
   mp_netzx_20(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzx_20

 function mp_netzx_02 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_02
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension xb(:,:)
dimension mp_netzx_02(size(xb,1),size(xb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xb,1)
do ii2=1,size(xb,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcpr (za%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_02(ii1,ii2) = .true.
  else
   mp_netzx_02(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzx_02

 function mp_netzx_11 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_11
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:)
dimension xb(:)
dimension mp_netzx_11(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpxzc (xb(ii1), z1%mpc)
  call mpcpr (za(ii1)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1)%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_11(ii1) = .true.
  else
   mp_netzx_11(ii1) = .false.
  endif
end do 
  return
 end function mp_netzx_11

 function mp_netzx_22 (za, xb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  logical mp_netzx_22
  intent (in):: za, xb
  type (mp_complex) z1
  integer mpnw
dimension za(:,:)
dimension xb(:,:)
dimension mp_netzx_22(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpxzc (xb(ii1,ii2), z1%mpc)
  call mpcpr (za(ii1,ii2)%mpc, z1%mpc, ic1, mpnw) 
  call mpcpr (za(ii1,ii2)%mpc(mp41), z2%mpc(mp41), ic2, mpnw) 
  if (ic1 .ne. 0 .or. ic2 .ne. 0) then
   mp_netzx_22(ii1,ii2) = .true.
  else
   mp_netzx_22(ii1,ii2) = .false.
  endif
end do 
end do 
  return
 end function mp_netzx_22

end module mpcmpmodv


module mpgenmodv

 !  This Fortran-90 module defines generic functions involving all
 !  MP datatypes.

 !  The subroutines and functions defined in this module are private
 !  and not intended to be called directly by the user.  The generic
 !  names (i.e. interface block names) are publicly accessible, though.

 use mpfunmod
 use mpdefmod
 private kdb, mp4, mp24, mp41
 parameter (kdb = kind (0.d0), mp4 = mpwds + 4, mp24 = 2 * mp4, mp41 = mp4 + 1)
private mp_tanh_1, mp_tanh_2
private mp_tan_1, mp_tan_2
private mp_sqrtz_1, mp_sqrtz_2
private mp_sqrtq_1, mp_sqrtq_2
private mp_sinh_1, mp_sinh_2
private mp_sinz_1, mp_sinz_2
private mp_sin_1, mp_sin_2
private mp_signq_10, mp_signq_01, mp_signq_20, mp_signq_02, mp_signq_11, mp_signq_22
private mp_signj_10, mp_signj_01, mp_signj_20, mp_signj_02, mp_signj_11, mp_signj_22
private mp_nint_1, mp_nint_2
private mp_outz_01, mp_outz_02
private mp_outq_01, mp_outq_02
private mp_outj_01, mp_outj_02
private mp_atoq_1, mp_atoq_2
private mp_xtoq_1, mp_xtoq_2
private mp_dtoq_1, mp_dtoq_2
private mp_itoq_1, mp_itoq_2
private mp_ztoq_1, mp_ztoq_2
private mp_jtoq_1, mp_jtoq_2
private mp_inpz_01, mp_inpz_02
private mp_inpq_01, mp_inpq_02
private mp_inpj_01, mp_inpj_02
private mp_nrt_10, mp_nrt_01, mp_nrt_20, mp_nrt_02, mp_nrt_11, mp_nrt_22
private mp_atoj_1, mp_atoj_2
private mp_xtoj_1, mp_xtoj_2
private mp_dtoj_1, mp_dtoj_2
private mp_itoj_1, mp_itoj_2
private mp_ztoj_1, mp_ztoj_2
private mp_qtoj_1, mp_qtoj_2
private mp_cssn_111, mp_cssn_222
private mp_cssh_111, mp_cssh_222
private mp_ddtoz_10, mp_ddtoz_01, mp_ddtoz_20, mp_ddtoz_02, mp_ddtoz_11, mp_ddtoz_22
private mp_iitoz_10, mp_iitoz_01, mp_iitoz_20, mp_iitoz_02, mp_iitoz_11, mp_iitoz_22
private mp_qqtoz_10, mp_qqtoz_01, mp_qqtoz_20, mp_qqtoz_02, mp_qqtoz_11, mp_qqtoz_22
private mp_jjtoz_10, mp_jjtoz_01, mp_jjtoz_20, mp_jjtoz_02, mp_jjtoz_11, mp_jjtoz_22
private mp_atoz_1, mp_atoz_2
private mp_xtoz_1, mp_xtoz_2
private mp_dtoz_1, mp_dtoz_2
private mp_itoz_1, mp_itoz_2
private mp_qtoz_1, mp_qtoz_2
private mp_jtoz_1, mp_jtoz_2
private mp_modq_10, mp_modq_01, mp_modq_20, mp_modq_02, mp_modq_11, mp_modq_22
private mp_modj_10, mp_modj_01, mp_modj_20, mp_modj_02, mp_modj_11, mp_modj_22
private mp_minq3_100, mp_minq3_010, mp_minq3_200, mp_minq3_020, mp_minq3_110, mp_minq3_220, mp_minq3_001, mp_minq3_011, mp_minq3_10&
      &1, mp_minq3_111, mp_minq3_002, mp_minq3_022, mp_minq3_202, mp_minq3_222
private mp_minq_10, mp_minq_01, mp_minq_20, mp_minq_02, mp_minq_11, mp_minq_22
private mp_minj_10, mp_minj_01, mp_minj_20, mp_minj_02, mp_minj_11, mp_minj_22
private mp_maxq3_100, mp_maxq3_010, mp_maxq3_200, mp_maxq3_020, mp_maxq3_110, mp_maxq3_220, mp_maxq3_001, mp_maxq3_011, mp_maxq3_10&
      &1, mp_maxq3_111, mp_maxq3_002, mp_maxq3_022, mp_maxq3_202, mp_maxq3_222
private mp_maxq_10, mp_maxq_01, mp_maxq_20, mp_maxq_02, mp_maxq_11, mp_maxq_22
private mp_maxj_10, mp_maxj_01, mp_maxj_20, mp_maxj_02, mp_maxj_11, mp_maxj_22
private mp_log10_1, mp_log10_2
private mp_logz_1, mp_logz_2
private mp_log_1, mp_log_2
private mp_ztoi_1, mp_ztoi_2
private mp_qtoi_1, mp_qtoi_2
private mp_jtoi_1, mp_jtoi_2
private mp_expz_1, mp_expz_2
private mp_exp_1, mp_exp_2
private mp_ztox_1, mp_ztox_2
private mp_qtox_10, mp_qtox_01, mp_qtox_20, mp_qtox_02, mp_qtox_11, mp_qtox_22
private mp_jtox_10, mp_jtox_01, mp_jtox_20, mp_jtox_02, mp_jtox_11, mp_jtox_22
private mp_ztod_1, mp_ztod_2
private mp_qtod_1, mp_qtod_2
private mp_jtod_1, mp_jtod_2
private mp_cosh_1, mp_cosh_2
private mp_cosz_1, mp_cosz_2
private mp_cos_1, mp_cos_2
private mp_conjg_1, mp_conjg_2
private mp_ztoc_1, mp_ztoc_2
private mp_qtoc_10, mp_qtoc_01, mp_qtoc_20, mp_qtoc_02, mp_qtoc_11, mp_qtoc_22
private mp_jtoc_10, mp_jtoc_01, mp_jtoc_20, mp_jtoc_02, mp_jtoc_11, mp_jtoc_22
private mp_atan2_10, mp_atan2_01, mp_atan2_20, mp_atan2_02, mp_atan2_11, mp_atan2_22
private mp_atan_1, mp_atan_2
private mp_asin_1, mp_asin_2
private mp_anint_1, mp_anint_2
private mp_aint_1, mp_aint_2
private mp_imag_1, mp_imag_2
private mp_acos_1, mp_acos_2
private mp_absz_1, mp_absz_2
private mp_absq_1, mp_absq_2
private mp_absj_1, mp_absj_2

 !  MP generic interface blocks.

 interface abs
module procedure mp_absj_1
module procedure mp_absj_2
module procedure mp_absq_1
module procedure mp_absq_2
module procedure mp_absz_1
module procedure mp_absz_2
 end interface

 interface acos
module procedure mp_acos_1
module procedure mp_acos_2
 end interface

 interface aimag
module procedure mp_imag_1
module procedure mp_imag_2
 end interface

 interface aint
module procedure mp_aint_1
module procedure mp_aint_2
 end interface

 interface anint
module procedure mp_anint_1
module procedure mp_anint_2
 end interface

 interface asin
module procedure mp_asin_1
module procedure mp_asin_2
 end interface

 interface atan
module procedure mp_atan_1
module procedure mp_atan_2
 end interface

 interface atan2
module procedure mp_atan2_10
module procedure mp_atan2_01
module procedure mp_atan2_20
module procedure mp_atan2_02
module procedure mp_atan2_11
module procedure mp_atan2_22
 end interface

 interface cmplx
module procedure mp_jtoc_10
module procedure mp_jtoc_01
module procedure mp_jtoc_20
module procedure mp_jtoc_02
module procedure mp_jtoc_11
module procedure mp_jtoc_22
module procedure mp_qtoc_10
module procedure mp_qtoc_01
module procedure mp_qtoc_20
module procedure mp_qtoc_02
module procedure mp_qtoc_11
module procedure mp_qtoc_22
module procedure mp_ztoc_1
module procedure mp_ztoc_2
 end interface

 interface conjg
module procedure mp_conjg_1
module procedure mp_conjg_2
 end interface

 interface cos
module procedure mp_cos_1
module procedure mp_cos_2
module procedure mp_cosz_1
module procedure mp_cosz_2
 end interface

 interface cosh
module procedure mp_cosh_1
module procedure mp_cosh_2
 end interface

 interface dble
module procedure mp_jtod_1
module procedure mp_jtod_2
module procedure mp_qtod_1
module procedure mp_qtod_2
module procedure mp_ztod_1
module procedure mp_ztod_2
 end interface

 interface dcmplx
module procedure mp_jtox_10
module procedure mp_jtox_01
module procedure mp_jtox_20
module procedure mp_jtox_02
module procedure mp_jtox_11
module procedure mp_jtox_22
module procedure mp_qtox_10
module procedure mp_qtox_01
module procedure mp_qtox_20
module procedure mp_qtox_02
module procedure mp_qtox_11
module procedure mp_qtox_22
module procedure mp_ztox_1
module procedure mp_ztox_2
 end interface

 interface exp
module procedure mp_exp_1
module procedure mp_exp_2
module procedure mp_expz_1
module procedure mp_expz_2
 end interface

 interface int
module procedure mp_jtoi_1
module procedure mp_jtoi_2
module procedure mp_qtoi_1
module procedure mp_qtoi_2
module procedure mp_ztoi_1
module procedure mp_ztoi_2
 end interface

 interface log
module procedure mp_log_1
module procedure mp_log_2
module procedure mp_logz_1
module procedure mp_logz_2
 end interface

 interface log10
module procedure mp_log10_1
module procedure mp_log10_2
 end interface

 interface max
module procedure mp_maxj_10
module procedure mp_maxj_01
module procedure mp_maxj_20
module procedure mp_maxj_02
module procedure mp_maxj_11
module procedure mp_maxj_22
module procedure mp_maxq_10
module procedure mp_maxq_01
module procedure mp_maxq_20
module procedure mp_maxq_02
module procedure mp_maxq_11
module procedure mp_maxq_22
module procedure mp_maxq3_100
module procedure mp_maxq3_010
module procedure mp_maxq3_200
module procedure mp_maxq3_020
module procedure mp_maxq3_110
module procedure mp_maxq3_220
module procedure mp_maxq3_001
module procedure mp_maxq3_011
module procedure mp_maxq3_101
module procedure mp_maxq3_111
module procedure mp_maxq3_002
module procedure mp_maxq3_022
module procedure mp_maxq3_202
module procedure mp_maxq3_222
 end interface

 interface min
module procedure mp_minj_10
module procedure mp_minj_01
module procedure mp_minj_20
module procedure mp_minj_02
module procedure mp_minj_11
module procedure mp_minj_22
module procedure mp_minq_10
module procedure mp_minq_01
module procedure mp_minq_20
module procedure mp_minq_02
module procedure mp_minq_11
module procedure mp_minq_22
module procedure mp_minq3_100
module procedure mp_minq3_010
module procedure mp_minq3_200
module procedure mp_minq3_020
module procedure mp_minq3_110
module procedure mp_minq3_220
module procedure mp_minq3_001
module procedure mp_minq3_011
module procedure mp_minq3_101
module procedure mp_minq3_111
module procedure mp_minq3_002
module procedure mp_minq3_022
module procedure mp_minq3_202
module procedure mp_minq3_222
 end interface

 interface mod
module procedure mp_modj_10
module procedure mp_modj_01
module procedure mp_modj_20
module procedure mp_modj_02
module procedure mp_modj_11
module procedure mp_modj_22
module procedure mp_modq_10
module procedure mp_modq_01
module procedure mp_modq_20
module procedure mp_modq_02
module procedure mp_modq_11
module procedure mp_modq_22
 end interface

 interface mpcmpl
module procedure mp_jtoz_1
module procedure mp_jtoz_2
module procedure mp_qtoz_1
module procedure mp_qtoz_2
module procedure mp_itoz_1
module procedure mp_itoz_2
module procedure mp_dtoz_1
module procedure mp_dtoz_2
module procedure mp_xtoz_1
module procedure mp_xtoz_2
module procedure mp_atoz_1
module procedure mp_atoz_2
module procedure mp_jjtoz_10
module procedure mp_jjtoz_01
module procedure mp_jjtoz_20
module procedure mp_jjtoz_02
module procedure mp_jjtoz_11
module procedure mp_jjtoz_22
module procedure mp_qqtoz_10
module procedure mp_qqtoz_01
module procedure mp_qqtoz_20
module procedure mp_qqtoz_02
module procedure mp_qqtoz_11
module procedure mp_qqtoz_22
module procedure mp_iitoz_10
module procedure mp_iitoz_01
module procedure mp_iitoz_20
module procedure mp_iitoz_02
module procedure mp_iitoz_11
module procedure mp_iitoz_22
module procedure mp_ddtoz_10
module procedure mp_ddtoz_01
module procedure mp_ddtoz_20
module procedure mp_ddtoz_02
module procedure mp_ddtoz_11
module procedure mp_ddtoz_22
 end interface

 interface mpcsshf
module procedure mp_cssh_111
module procedure mp_cssh_222
 end interface

 interface mpcssnf
module procedure mp_cssn_111
module procedure mp_cssn_222
 end interface

 interface mpint
module procedure mp_qtoj_1
module procedure mp_qtoj_2
module procedure mp_ztoj_1
module procedure mp_ztoj_2
module procedure mp_itoj_1
module procedure mp_itoj_2
module procedure mp_dtoj_1
module procedure mp_dtoj_2
module procedure mp_xtoj_1
module procedure mp_xtoj_2
module procedure mp_atoj_1
module procedure mp_atoj_2
 end interface

 interface mpnrtf
module procedure mp_nrt_10
module procedure mp_nrt_01
module procedure mp_nrt_20
module procedure mp_nrt_02
module procedure mp_nrt_11
module procedure mp_nrt_22
 end interface

 interface mpranf
 end interface

 interface mpread
module procedure mp_inpj_01
module procedure mp_inpj_02
module procedure mp_inpq_01
module procedure mp_inpq_02
module procedure mp_inpz_01
module procedure mp_inpz_02
 end interface

 interface mpreal
module procedure mp_jtoq_1
module procedure mp_jtoq_2
module procedure mp_ztoq_1
module procedure mp_ztoq_2
module procedure mp_itoq_1
module procedure mp_itoq_2
module procedure mp_dtoq_1
module procedure mp_dtoq_2
module procedure mp_xtoq_1
module procedure mp_xtoq_2
module procedure mp_atoq_1
module procedure mp_atoq_2
 end interface

 interface mpwrite
module procedure mp_outj_01
module procedure mp_outj_02
module procedure mp_outq_01
module procedure mp_outq_02
module procedure mp_outz_01
module procedure mp_outz_02
 end interface

 interface nint
module procedure mp_nint_1
module procedure mp_nint_2
 end interface

 interface sign
module procedure mp_signj_10
module procedure mp_signj_01
module procedure mp_signj_20
module procedure mp_signj_02
module procedure mp_signj_11
module procedure mp_signj_22
module procedure mp_signq_10
module procedure mp_signq_01
module procedure mp_signq_20
module procedure mp_signq_02
module procedure mp_signq_11
module procedure mp_signq_22
 end interface

 interface sin
module procedure mp_sin_1
module procedure mp_sin_2
module procedure mp_sinz_1
module procedure mp_sinz_2
 end interface

 interface sinh
module procedure mp_sinh_1
module procedure mp_sinh_2
 end interface

 interface sqrt
module procedure mp_sqrtq_1
module procedure mp_sqrtq_2
module procedure mp_sqrtz_1
module procedure mp_sqrtz_2
 end interface

 interface tan
module procedure mp_tan_1
module procedure mp_tan_2
 end interface

 interface tanh
module procedure mp_tanh_1
module procedure mp_tanh_2
 end interface

contains

 function mp_absj_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_absj_1
  intent (in):: ja
  integer mpnw
dimension ja(:)
dimension mp_absj_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (ja(ii1)%mpi, mp_absj_1(ii1)%mpi, mpnw) 
  mp_absj_1(ii1)%mpi(1) = abs (ja(ii1)%mpi(1))
end do 
  return
 end function mp_absj_1

 function mp_absj_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_absj_2
  intent (in):: ja
  integer mpnw
dimension ja(:,:)
dimension mp_absj_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (ja(ii1,ii2)%mpi, mp_absj_2(ii1,ii2)%mpi, mpnw) 
  mp_absj_2(ii1,ii2)%mpi(1) = abs (ja(ii1,ii2)%mpi(1))
end do 
end do 
  return
 end function mp_absj_2

 function mp_absq_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_absq_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_absq_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (qa(ii1)%mpr, mp_absq_1(ii1)%mpr, mpnw) 
  mp_absq_1(ii1)%mpr(1) = abs (qa(ii1)%mpr(1))
end do 
  return
 end function mp_absq_1

 function mp_absq_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_absq_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_absq_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (qa(ii1,ii2)%mpr, mp_absq_2(ii1,ii2)%mpr, mpnw) 
  mp_absq_2(ii1,ii2)%mpr(1) = abs (qa(ii1,ii2)%mpr(1))
end do 
end do 
  return
 end function mp_absq_2

 function mp_absz_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_absz_1
  intent (in):: za
  type (mp_real) q1, q2, q3
  integer mpnw
dimension za(:)
dimension mp_absz_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmul (za(ii1)%mpc, za(ii1)%mpc, q1%mpr, mpnw) 
  call mpmul (za(ii1)%mpc(mp41), za(ii1)%mpc(mp41), q2%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, mp_absz_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_absz_1

 function mp_absz_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_absz_2
  intent (in):: za
  type (mp_real) q1, q2, q3
  integer mpnw
dimension za(:,:)
dimension mp_absz_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmul (za(ii1,ii2)%mpc, za(ii1,ii2)%mpc, q1%mpr, mpnw) 
  call mpmul (za(ii1,ii2)%mpc(mp41), za(ii1,ii2)%mpc(mp41), q2%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, mp_absz_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_absz_2

 function mp_acos_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_acos_1
  intent (in):: qa
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:)
dimension mp_acos_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpmul (qa(ii1)%mpr, qa(ii1)%mpr, q2%mpr, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, q1%mpr, mpnw) 
  call mpang (qa(ii1)%mpr, q1%mpr, mppic%mpr, mp_acos_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_acos_1

 function mp_acos_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_acos_2
  intent (in):: qa
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:,:)
dimension mp_acos_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpmul (qa(ii1,ii2)%mpr, qa(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, q1%mpr, mpnw) 
  call mpang (qa(ii1,ii2)%mpr, q1%mpr, mppic%mpr, mp_acos_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_acos_2

 function mp_aint_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_aint_1
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_aint_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpinfr (qa(ii1)%mpr, mp_aint_1(ii1)%mpr, q1%mpr, mpnw) 
end do 
  return
 end function mp_aint_1

 function mp_aint_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_aint_2
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_aint_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpinfr (qa(ii1,ii2)%mpr, mp_aint_2(ii1,ii2)%mpr, q1%mpr, mpnw) 
end do 
end do 
  return
 end function mp_aint_2

 function mp_anint_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_anint_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_anint_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpnint (qa(ii1)%mpr, mp_anint_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_anint_1

 function mp_anint_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_anint_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_anint_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpnint (qa(ii1,ii2)%mpr, mp_anint_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_anint_2

 function mp_asin_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_asin_1
  intent (in):: qa
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:)
dimension mp_asin_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpmul (qa(ii1)%mpr, qa(ii1)%mpr, q2%mpr, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, q1%mpr, mpnw) 
  call mpang (q1%mpr, qa(ii1)%mpr, mppic%mpr, mp_asin_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_asin_1

 function mp_asin_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_asin_2
  intent (in):: qa
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:,:)
dimension mp_asin_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpmul (qa(ii1,ii2)%mpr, qa(ii1,ii2)%mpr, q2%mpr, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpsqrt (q3%mpr, q1%mpr, mpnw) 
  call mpang (q1%mpr, qa(ii1,ii2)%mpr, mppic%mpr, mp_asin_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_asin_2

 function mp_atan_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan_1
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_atan_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpang (q1%mpr, qa(ii1)%mpr, mppic%mpr, mp_atan_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_atan_1

 function mp_atan_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan_2
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_atan_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdmc (1.d0, 0, q1%mpr)
  call mpang (q1%mpr, qa(ii1,ii2)%mpr, mppic%mpr, mp_atan_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atan_2

 function mp_atan2_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_atan2_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpang (qb%mpr, qa(ii1)%mpr, mppic%mpr, mp_atan2_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_atan2_10

 function mp_atan2_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_atan2_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpang (qb(ii1)%mpr, qa%mpr, mppic%mpr, mp_atan2_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_atan2_01

 function mp_atan2_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_atan2_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpang (qb%mpr, qa(ii1,ii2)%mpr, mppic%mpr, mp_atan2_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atan2_20

 function mp_atan2_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_atan2_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpang (qb(ii1,ii2)%mpr, qa%mpr, mppic%mpr, mp_atan2_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atan2_02

 function mp_atan2_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_atan2_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpang (qb(ii1)%mpr, qa(ii1)%mpr, mppic%mpr, mp_atan2_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_atan2_11

 function mp_atan2_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_atan2_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_atan2_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpang (qb(ii1,ii2)%mpr, qa(ii1,ii2)%mpr, mppic%mpr, mp_atan2_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atan2_22

 function mp_jtoc_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_jtoc_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  call mpmdc (jb%mpi, db, ib)
  mp_jtoc_10(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_jtoc_10

 function mp_jtoc_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_jtoc_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmdc (ja%mpi, da, ia)
  call mpmdc (jb(ii1)%mpi, db, ib)
  mp_jtoc_01(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_jtoc_01

 function mp_jtoc_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_jtoc_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  call mpmdc (jb%mpi, db, ib)
  mp_jtoc_20(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_jtoc_20

 function mp_jtoc_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_jtoc_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmdc (ja%mpi, da, ia)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  mp_jtoc_02(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_jtoc_02

 function mp_jtoc_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_jtoc_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  call mpmdc (jb(ii1)%mpi, db, ib)
  mp_jtoc_11(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_jtoc_11

 function mp_jtoc_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_jtoc_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_jtoc_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  mp_jtoc_22(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_jtoc_22

 function mp_qtoc_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_qtoc_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  call mpmdc (qb%mpr, db, ib)
  mp_qtoc_10(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_qtoc_10

 function mp_qtoc_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_qtoc_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmdc (qa%mpr, da, ia)
  call mpmdc (qb(ii1)%mpr, db, ib)
  mp_qtoc_01(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_qtoc_01

 function mp_qtoc_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_qtoc_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  call mpmdc (qb%mpr, db, ib)
  mp_qtoc_20(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_qtoc_20

 function mp_qtoc_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_qtoc_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmdc (qa%mpr, da, ia)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  mp_qtoc_02(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_qtoc_02

 function mp_qtoc_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_qtoc_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  call mpmdc (qb(ii1)%mpr, db, ib)
  mp_qtoc_11(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_qtoc_11

 function mp_qtoc_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_qtoc_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_qtoc_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  mp_qtoc_22(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_qtoc_22

 function mp_ztoc_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_ztoc_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_ztoc_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmdc (za(ii1)%mpc, da, ia)
  call mpmdc (za(ii1)%mpc(mp41), db, ib)
  mp_ztoc_1(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
  return
 end function mp_ztoc_1

 function mp_ztoc_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex:: mp_ztoc_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_ztoc_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmdc (za(ii1,ii2)%mpc, da, ia)
  call mpmdc (za(ii1,ii2)%mpc(mp41), db, ib)
  mp_ztoc_2(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib)
end do 
end do 
  return
 end function mp_ztoc_2

 function mp_conjg_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_conjg_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_conjg_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpceq (mp4, za(ii1)%mpc, mp_conjg_1(ii1)%mpc, mpnw) 
  mp_conjg_1(ii1)%mpc(mp41) = - za(ii1)%mpc(mp41)
end do 
  return
 end function mp_conjg_1

 function mp_conjg_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_conjg_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_conjg_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpceq (mp4, za(ii1,ii2)%mpc, mp_conjg_2(ii1,ii2)%mpc, mpnw) 
  mp_conjg_2(ii1,ii2)%mpc(mp41) = - za(ii1,ii2)%mpc(mp41)
end do 
end do 
  return
 end function mp_conjg_2

 function mp_cos_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_cos_1
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_cos_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcssn (qa(ii1)%mpr, mppic%mpr, mp_cos_1(ii1)%mpr, q1%mpr, mpnw) 
end do 
  return
 end function mp_cos_1

 function mp_cos_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_cos_2
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_cos_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcssn (qa(ii1,ii2)%mpr, mppic%mpr, mp_cos_2(ii1,ii2)%mpr, q1%mpr, mpnw) 
end do 
end do 
  return
 end function mp_cos_2

 function mp_cosz_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_cosz_1
  intent (in):: za
  type (mp_real) q1, q2, q3, q4, q5, q6
  integer mpnw
dimension za(:)
dimension mp_cosz_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpeq (za(ii1)%mpc(mp41), q2%mpr, mpnw) 
  q2%mpr(1) = - q2%mpr(1)
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpdmc (1.d0, 0, q3%mpr)
  call mpdiv (q3%mpr, q1%mpr, q2%mpr, mpnw) 
  call mpcssn (za(ii1)%mpc, mppic%mpr, q3%mpr, q4%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q5%mpr, mpnw) 
  call mpmuld (q5%mpr, 0.5d0, 0, q6%mpr, mpnw) 
  call mpmul (q6%mpr, q3%mpr, mp_cosz_1(ii1)%mpc, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q5%mpr, mpnw) 
  call mpmuld (q5%mpr, 0.5d0, 0, q6%mpr, mpnw) 
  call mpmul (q6%mpr, q4%mpr, mp_cosz_1(ii1)%mpc(mp41), mpnw) 
end do 
  return
 end function mp_cosz_1

 function mp_cosz_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_cosz_2
  intent (in):: za
  type (mp_real) q1, q2, q3, q4, q5, q6
  integer mpnw
dimension za(:,:)
dimension mp_cosz_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpeq (za(ii1,ii2)%mpc(mp41), q2%mpr, mpnw) 
  q2%mpr(1) = - q2%mpr(1)
  call mpexp (q2%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpdmc (1.d0, 0, q3%mpr)
  call mpdiv (q3%mpr, q1%mpr, q2%mpr, mpnw) 
  call mpcssn (za(ii1,ii2)%mpc, mppic%mpr, q3%mpr, q4%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q5%mpr, mpnw) 
  call mpmuld (q5%mpr, 0.5d0, 0, q6%mpr, mpnw) 
  call mpmul (q6%mpr, q3%mpr, mp_cosz_2(ii1,ii2)%mpc, mpnw) 
  call mpsub (q1%mpr, q2%mpr, q5%mpr, mpnw) 
  call mpmuld (q5%mpr, 0.5d0, 0, q6%mpr, mpnw) 
  call mpmul (q6%mpr, q4%mpr, mp_cosz_2(ii1,ii2)%mpc(mp41), mpnw) 
end do 
end do 
  return
 end function mp_cosz_2

 function mp_cosh_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_cosh_1
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_cosh_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcssh (qa(ii1)%mpr, mpl02%mpr, mp_cosh_1(ii1)%mpr, q1%mpr, mpnw) 
end do 
  return
 end function mp_cosh_1

 function mp_cosh_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_cosh_2
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_cosh_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcssh (qa(ii1,ii2)%mpr, mpl02%mpr, mp_cosh_2(ii1,ii2)%mpr, q1%mpr, mpnw) 
end do 
end do 
  return
 end function mp_cosh_2

 function mp_jtod_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: ja
  double precision mp_jtod_1
  integer mpnw
dimension ja(:)
dimension mp_jtod_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  mp_jtod_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_jtod_1

 function mp_jtod_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: ja
  double precision mp_jtod_2
  integer mpnw
dimension ja(:,:)
dimension mp_jtod_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  mp_jtod_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_jtod_2

 function mp_qtod_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  double precision:: mp_qtod_1, da
  integer mpnw
dimension qa(:)
dimension mp_qtod_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  mp_qtod_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_qtod_1

 function mp_qtod_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  double precision:: mp_qtod_2, da
  integer mpnw
dimension qa(:,:)
dimension mp_qtod_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  mp_qtod_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_qtod_2

 function mp_ztod_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: za
  double precision:: mp_ztod_1, da
  integer mpnw
dimension za(:)
dimension mp_ztod_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmdc (za(ii1)%mpc, da, ia)
  mp_ztod_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_ztod_1

 function mp_ztod_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: za
  double precision:: mp_ztod_2, da
  integer mpnw
dimension za(:,:)
dimension mp_ztod_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmdc (za(ii1,ii2)%mpc, da, ia)
  mp_ztod_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_ztod_2

 function mp_jtox_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_jtox_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  call mpmdc (jb%mpi, db, ib)
  mp_jtox_10(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_jtox_10

 function mp_jtox_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_jtox_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmdc (ja%mpi, da, ia)
  call mpmdc (jb(ii1)%mpi, db, ib)
  mp_jtox_01(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_jtox_01

 function mp_jtox_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_jtox_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  call mpmdc (jb%mpi, db, ib)
  mp_jtox_20(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_jtox_20

 function mp_jtox_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_jtox_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmdc (ja%mpi, da, ia)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  mp_jtox_02(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_jtox_02

 function mp_jtox_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_jtox_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  call mpmdc (jb(ii1)%mpi, db, ib)
  mp_jtox_11(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_jtox_11

 function mp_jtox_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_jtox_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_jtox_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  call mpmdc (jb(ii1,ii2)%mpi, db, ib)
  mp_jtox_22(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_jtox_22

 function mp_qtox_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_qtox_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  call mpmdc (qb%mpr, db, ib)
  mp_qtox_10(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_qtox_10

 function mp_qtox_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_qtox_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmdc (qa%mpr, da, ia)
  call mpmdc (qb(ii1)%mpr, db, ib)
  mp_qtox_01(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_qtox_01

 function mp_qtox_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_qtox_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  call mpmdc (qb%mpr, db, ib)
  mp_qtox_20(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_qtox_20

 function mp_qtox_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_qtox_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmdc (qa%mpr, da, ia)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  mp_qtox_02(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_qtox_02

 function mp_qtox_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_qtox_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  call mpmdc (qb(ii1)%mpr, db, ib)
  mp_qtox_11(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_qtox_11

 function mp_qtox_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_qtox_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_qtox_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  call mpmdc (qb(ii1,ii2)%mpr, db, ib)
  mp_qtox_22(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_qtox_22

 function mp_ztox_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_ztox_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_ztox_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmdc (za(ii1)%mpc, da, ia)
  call mpmdc (za(ii1)%mpc(mp41), db, ib)
  mp_ztox_1(ii1) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
  return
 end function mp_ztox_1

 function mp_ztox_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  complex (kdb):: mp_ztox_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_ztox_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmdc (za(ii1,ii2)%mpc, da, ia)
  call mpmdc (za(ii1,ii2)%mpc(mp41), db, ib)
  mp_ztox_2(ii1,ii2) = cmplx (da * 2.d0 ** ia, db * 2.d0 ** ib, kdb)
end do 
end do 
  return
 end function mp_ztox_2

 function mp_exp_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_exp_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_exp_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpexp (qa(ii1)%mpr, mpl02%mpr, mp_exp_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_exp_1

 function mp_exp_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_exp_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_exp_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpexp (qa(ii1,ii2)%mpr, mpl02%mpr, mp_exp_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_exp_2

 function mp_expz_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expz_1
  intent (in):: za
  type (mp_real) q1, q2, q3
  integer mpnw
dimension za(:)
dimension mp_expz_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpexp (za(ii1)%mpc, mpl02%mpr, q1%mpr, mpnw) 
  call mpcssn (za(ii1)%mpc(mp41), mppic%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (q1%mpr, q2%mpr, mp_expz_1(ii1)%mpc, mpnw) 
  call mpmul (q1%mpr, q3%mpr, mp_expz_1(ii1)%mpc(mp41), mpnw) 
end do 
  return
 end function mp_expz_1

 function mp_expz_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_expz_2
  intent (in):: za
  type (mp_real) q1, q2, q3
  integer mpnw
dimension za(:,:)
dimension mp_expz_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpexp (za(ii1,ii2)%mpc, mpl02%mpr, q1%mpr, mpnw) 
  call mpcssn (za(ii1,ii2)%mpc(mp41), mppic%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (q1%mpr, q2%mpr, mp_expz_2(ii1,ii2)%mpc, mpnw) 
  call mpmul (q1%mpr, q3%mpr, mp_expz_2(ii1,ii2)%mpc(mp41), mpnw) 
end do 
end do 
  return
 end function mp_expz_2

 function mp_imag_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_imag_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_imag_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpeq (za(ii1)%mpc(mp41), mp_imag_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_imag_1

 function mp_imag_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_imag_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_imag_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpeq (za(ii1,ii2)%mpc(mp41), mp_imag_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_imag_2

 function mp_jtoi_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_jtoi_1
  intent (in):: ja
  integer mpnw
dimension ja(:)
dimension mp_jtoi_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmdc (ja(ii1)%mpi, da, ia)
  mp_jtoi_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_jtoi_1

 function mp_jtoi_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_jtoi_2
  intent (in):: ja
  integer mpnw
dimension ja(:,:)
dimension mp_jtoi_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmdc (ja(ii1,ii2)%mpi, da, ia)
  mp_jtoi_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_jtoi_2

 function mp_qtoi_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_qtoi_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_qtoi_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmdc (qa(ii1)%mpr, da, ia)
  mp_qtoi_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_qtoi_1

 function mp_qtoi_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_qtoi_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_qtoi_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmdc (qa(ii1,ii2)%mpr, da, ia)
  mp_qtoi_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_qtoi_2

 function mp_ztoi_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_ztoi_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_ztoi_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmdc (za(ii1)%mpc, da, ia)
  mp_ztoi_1(ii1) = da * 2.d0 ** ia
end do 
  return
 end function mp_ztoi_1

 function mp_ztoi_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  integer:: mp_ztoi_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_ztoi_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmdc (za(ii1,ii2)%mpc, da, ia)
  mp_ztoi_2(ii1,ii2) = da * 2.d0 ** ia
end do 
end do 
  return
 end function mp_ztoi_2

 function mp_log_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_log_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_log_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, mp_log_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_log_1

 function mp_log_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_log_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_log_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, mp_log_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_log_2

 function mp_logz_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_logz_1
  intent (in):: za
  type (mp_real) q1, q2, q3, q4
  integer mpnw
dimension za(:)
dimension mp_logz_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpmul (za(ii1)%mpc, za(ii1)%mpc, q1%mpr, mpnw) 
  call mpmul (za(ii1)%mpc(mp41), za(ii1)%mpc(mp41), q2%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mplog (q3%mpr, mpl02%mpr, q4%mpr, mpnw) 
  call mpmuld (q4%mpr, 0.5d0, 0, mp_logz_1(ii1)%mpc, mpnw) 
  call mpang (za(ii1)%mpc, za(ii1)%mpc(mp41), mppic%mpr, mp_logz_1(ii1)%mpc(mp41), mpnw) 
end do 
  return
 end function mp_logz_1

 function mp_logz_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_logz_2
  intent (in):: za
  type (mp_real) q1, q2, q3, q4
  integer mpnw
dimension za(:,:)
dimension mp_logz_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpmul (za(ii1,ii2)%mpc, za(ii1,ii2)%mpc, q1%mpr, mpnw) 
  call mpmul (za(ii1,ii2)%mpc(mp41), za(ii1,ii2)%mpc(mp41), q2%mpr, mpnw) 
  call mpadd (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mplog (q3%mpr, mpl02%mpr, q4%mpr, mpnw) 
  call mpmuld (q4%mpr, 0.5d0, 0, mp_logz_2(ii1,ii2)%mpc, mpnw) 
  call mpang (za(ii1,ii2)%mpc, za(ii1,ii2)%mpc(mp41), mppic%mpr, mp_logz_2(ii1,ii2)%mpc(mp41), mpnw) 
end do 
end do 
  return
 end function mp_logz_2

 function mp_log10_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_log10_1
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_log10_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mplog (qa(ii1)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpdiv (q1%mpr, mpl10%mpr, mp_log10_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_log10_1

 function mp_log10_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_log10_2
  intent (in):: qa
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_log10_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mplog (qa(ii1,ii2)%mpr, mpl02%mpr, q1%mpr, mpnw) 
  call mpdiv (q1%mpr, mpl10%mpr, mp_log10_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_log10_2

 function mp_maxj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_maxj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja(ii1)%mpi, mp_maxj_10(ii1)%mpi, mpnw) 
  else
   call mpeq (jb%mpi, mp_maxj_10(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_maxj_10

 function mp_maxj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_maxj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja%mpi, mp_maxj_01(ii1)%mpi, mpnw) 
  else
   call mpeq (jb(ii1)%mpi, mp_maxj_01(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_maxj_01

 function mp_maxj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_maxj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja(ii1,ii2)%mpi, mp_maxj_20(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb%mpi, mp_maxj_20(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxj_20

 function mp_maxj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_maxj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja%mpi, mp_maxj_02(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb(ii1,ii2)%mpi, mp_maxj_02(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxj_02

 function mp_maxj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_maxj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja(ii1)%mpi, mp_maxj_11(ii1)%mpi, mpnw) 
  else
   call mpeq (jb(ii1)%mpi, mp_maxj_11(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_maxj_11

 function mp_maxj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_maxj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_maxj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (ja(ii1,ii2)%mpi, mp_maxj_22(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb(ii1,ii2)%mpi, mp_maxj_22(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxj_22

 function mp_maxq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_maxq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, mp_maxq_10(ii1)%mpr, mpnw) 
  else
   call mpeq (qb%mpr, mp_maxq_10(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq_10

 function mp_maxq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_maxq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, mp_maxq_01(ii1)%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, mp_maxq_01(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq_01

 function mp_maxq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_maxq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, mp_maxq_20(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb%mpr, mp_maxq_20(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq_20

 function mp_maxq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_maxq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, mp_maxq_02(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, mp_maxq_02(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq_02

 function mp_maxq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_maxq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, mp_maxq_11(ii1)%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, mp_maxq_11(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq_11

 function mp_maxq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_maxq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, mp_maxq_22(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, mp_maxq_22(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq_22

 function mp_maxq3_100 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_100
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_maxq3_100(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_100(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_100(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_100

 function mp_maxq3_010 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_010
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_maxq3_010(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_010(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_010(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_010

 function mp_maxq3_200 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_200
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_maxq3_200(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_200(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_200(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_200

 function mp_maxq3_020 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_020
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_maxq3_020(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_020(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_020(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_020

 function mp_maxq3_110 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_110
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_maxq3_110(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_110(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_110(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_110

 function mp_maxq3_220 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_220
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_maxq3_220(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_220(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_maxq3_220(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_220

 function mp_maxq3_001 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_001
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qc(:)
dimension mp_maxq3_001(size(qc,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qc,1)
  call mpcpr (qa%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_001(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_maxq3_001(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_001

 function mp_maxq3_011 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_011
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension qc(:)
dimension mp_maxq3_011(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_011(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_maxq3_011(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_011

 function mp_maxq3_101 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_101
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qc(:)
dimension mp_maxq3_101(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_101(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_maxq3_101(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_101

 function mp_maxq3_111 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_111
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension qc(:)
dimension mp_maxq3_111(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_111(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_maxq3_111(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_maxq3_111

 function mp_maxq3_002 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_002
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qc(:,:)
dimension mp_maxq3_002(size(qc,1),size(qc,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qc,1)
do ii2=1,size(qc,2)
  call mpcpr (qa%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_002(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_maxq3_002(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_002

 function mp_maxq3_022 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_022
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension qc(:,:)
dimension mp_maxq3_022(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_022(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_maxq3_022(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_022

 function mp_maxq3_202 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_202
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qc(:,:)
dimension mp_maxq3_202(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_202(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_maxq3_202(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_202

 function mp_maxq3_222 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_maxq3_222
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension qc(:,:)
dimension mp_maxq3_222(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .ge. 0) then
   call mpeq (q1%mpr, mp_maxq3_222(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_maxq3_222(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_maxq3_222

 function mp_minj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_minj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja(ii1)%mpi, mp_minj_10(ii1)%mpi, mpnw) 
  else
   call mpeq (jb%mpi, mp_minj_10(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_minj_10

 function mp_minj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_minj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpcpr (ja%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja%mpi, mp_minj_01(ii1)%mpi, mpnw) 
  else
   call mpeq (jb(ii1)%mpi, mp_minj_01(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_minj_01

 function mp_minj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_minj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja(ii1,ii2)%mpi, mp_minj_20(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb%mpi, mp_minj_20(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minj_20

 function mp_minj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_minj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpcpr (ja%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja%mpi, mp_minj_02(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb(ii1,ii2)%mpi, mp_minj_02(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minj_02

 function mp_minj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_minj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpcpr (ja(ii1)%mpi, jb(ii1)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja(ii1)%mpi, mp_minj_11(ii1)%mpi, mpnw) 
  else
   call mpeq (jb(ii1)%mpi, mp_minj_11(ii1)%mpi, mpnw) 
  endif
end do 
  return
 end function mp_minj_11

 function mp_minj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_minj_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_minj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpcpr (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (ja(ii1,ii2)%mpi, mp_minj_22(ii1,ii2)%mpi, mpnw) 
  else
   call mpeq (jb(ii1,ii2)%mpi, mp_minj_22(ii1,ii2)%mpi, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minj_22

 function mp_minq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_minq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, mp_minq_10(ii1)%mpr, mpnw) 
  else
   call mpeq (qb%mpr, mp_minq_10(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq_10

 function mp_minq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_minq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, mp_minq_01(ii1)%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, mp_minq_01(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq_01

 function mp_minq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_minq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, mp_minq_20(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb%mpr, mp_minq_20(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq_20

 function mp_minq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_minq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, mp_minq_02(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, mp_minq_02(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq_02

 function mp_minq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_minq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, mp_minq_11(ii1)%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, mp_minq_11(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq_11

 function mp_minq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_minq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, mp_minq_22(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, mp_minq_22(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq_22

 function mp_minq3_100 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_100
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension mp_minq3_100(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_100(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_100(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_100

 function mp_minq3_010 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_010
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension mp_minq3_010(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_010(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_010(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_010

 function mp_minq3_200 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_200
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension mp_minq3_200(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_200(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_200(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_200

 function mp_minq3_020 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_020
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension mp_minq3_020(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_020(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_020(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_020

 function mp_minq3_110 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_110
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_minq3_110(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_110(ii1)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_110(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_110

 function mp_minq3_220 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_220
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_minq3_220(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_220(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc%mpr, mp_minq3_220(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_220

 function mp_minq3_001 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_001
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qc(:)
dimension mp_minq3_001(size(qc,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qc,1)
  call mpcpr (qa%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_001(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_minq3_001(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_001

 function mp_minq3_011 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_011
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:)
dimension qc(:)
dimension mp_minq3_011(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpcpr (qa%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_011(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_minq3_011(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_011

 function mp_minq3_101 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_101
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qc(:)
dimension mp_minq3_101(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_101(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_minq3_101(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_101

 function mp_minq3_111 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_111
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension qc(:)
dimension mp_minq3_111(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcpr (qa(ii1)%mpr, qb(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_111(ii1)%mpr, mpnw) 
  else
   call mpeq (qc(ii1)%mpr, mp_minq3_111(ii1)%mpr, mpnw) 
  endif
end do 
  return
 end function mp_minq3_111

 function mp_minq3_002 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_002
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qc(:,:)
dimension mp_minq3_002(size(qc,1),size(qc,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qc,1)
do ii2=1,size(qc,2)
  call mpcpr (qa%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_002(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_minq3_002(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_002

 function mp_minq3_022 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_022
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qb(:,:)
dimension qc(:,:)
dimension mp_minq3_022(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpcpr (qa%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_022(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_minq3_022(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_022

 function mp_minq3_202 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_202
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qc(:,:)
dimension mp_minq3_202(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_202(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_minq3_202(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_202

 function mp_minq3_222 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_minq3_222
  intent (in):: qa, qb, qc
  type (mp_real) q1
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension qc(:,:)
dimension mp_minq3_222(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcpr (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  else
   call mpeq (qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  endif
  call mpcpr (q1%mpr, qc(ii1,ii2)%mpr, ic, mpnw) 
  if (ic .lt. 0) then
   call mpeq (q1%mpr, mp_minq3_222(ii1,ii2)%mpr, mpnw) 
  else
   call mpeq (qc(ii1,ii2)%mpr, mp_minq3_222(ii1,ii2)%mpr, mpnw) 
  endif
end do 
end do 
  return
 end function mp_minq3_222

 function mp_modj_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_10
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension mp_modj_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja(ii1)%mpi, q1%mpr, mp_modj_10(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_modj_10

 function mp_modj_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_01
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:)
dimension mp_modj_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpdiv (ja%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb(ii1)%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja%mpi, q1%mpr, mp_modj_01(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_modj_01

 function mp_modj_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_20
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension mp_modj_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, jb%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, mp_modj_20(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_modj_20

 function mp_modj_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_02
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension jb(:,:)
dimension mp_modj_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpdiv (ja%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb(ii1,ii2)%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja%mpi, q1%mpr, mp_modj_02(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_modj_02

 function mp_modj_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_11
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_modj_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpdiv (ja(ii1)%mpi, jb(ii1)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb(ii1)%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja(ii1)%mpi, q1%mpr, mp_modj_11(ii1)%mpi, mpnw) 
end do 
  return
 end function mp_modj_11

 function mp_modj_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_modj_22
  intent (in):: ja, jb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_modj_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpdiv (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (jb(ii1,ii2)%mpi, q2%mpr, q1%mpr, mpnw) 
  call mpsub (ja(ii1,ii2)%mpi, q1%mpr, mp_modj_22(ii1,ii2)%mpi, mpnw) 
end do 
end do 
  return
 end function mp_modj_22

 function mp_modq_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_10
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:)
dimension mp_modq_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, qb%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_modq_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_modq_10

 function mp_modq_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_01
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:)
dimension mp_modq_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpdiv (qa%mpr, qb(ii1)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb(ii1)%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa%mpr, q1%mpr, mp_modq_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_modq_01

 function mp_modq_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_20
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:,:)
dimension mp_modq_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, qb%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_modq_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_modq_20

 function mp_modq_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_02
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qb(:,:)
dimension mp_modq_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpdiv (qa%mpr, qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb(ii1,ii2)%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa%mpr, q1%mpr, mp_modq_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_modq_02

 function mp_modq_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_11
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_modq_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpdiv (qa(ii1)%mpr, qb(ii1)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb(ii1)%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa(ii1)%mpr, q1%mpr, mp_modq_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_modq_11

 function mp_modq_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_modq_22
  intent (in):: qa, qb
  type (mp_real) q1, q2, q3
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_modq_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpdiv (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, q2%mpr, q3%mpr, mpnw) 
  call mpmul (qb(ii1,ii2)%mpr, q2%mpr, q1%mpr, mpnw) 
  call mpsub (qa(ii1,ii2)%mpr, q1%mpr, mp_modq_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_modq_22

 function mp_jtoz_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jtoz_1
  intent (in):: ja
  integer mpnw
dimension ja(:)
dimension mp_jtoz_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmzc (ja(ii1)%mpi, mp_jtoz_1(ii1)%mpc)
end do 
  return
 end function mp_jtoz_1

 function mp_jtoz_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jtoz_2
  intent (in):: ja
  integer mpnw
dimension ja(:,:)
dimension mp_jtoz_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmzc (ja(ii1,ii2)%mpi, mp_jtoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_jtoz_2

 function mp_qtoz_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qtoz_1
  intent (in):: qa
  integer mpnw
dimension qa(:)
dimension mp_qtoz_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmzc (qa(ii1)%mpr, mp_qtoz_1(ii1)%mpc)
end do 
  return
 end function mp_qtoz_1

 function mp_qtoz_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qtoz_2
  intent (in):: qa
  integer mpnw
dimension qa(:,:)
dimension mp_qtoz_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmzc (qa(ii1,ii2)%mpr, mp_qtoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_qtoz_2

 function mp_itoz_1 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_itoz_1
  intent (in):: ia
  integer mpnw
dimension ia(:)
dimension mp_itoz_1(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = ia(ii1)
  call mpxzc (xa, mp_itoz_1(ii1)%mpc)
end do 
  return
 end function mp_itoz_1

 function mp_itoz_2 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_itoz_2
  intent (in):: ia
  integer mpnw
dimension ia(:,:)
dimension mp_itoz_2(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = ia(ii1,ii2)
  call mpxzc (xa, mp_itoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_itoz_2

 function mp_rtoz (ra)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_rtoz
  intent (in):: ra
  integer mpnw
  mpnw = mpnwx
  xa = ra
  call mpxzc (xa, mp_rtoz%mpc)
  return
 end function mp_rtoz

 function mp_ctoz (ca)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ctoz
  intent (in):: ca
  integer mpnw
  mpnw = mpnwx
  xa = ca
  call mpxzc (xa, mp_ctoz%mpc)
  return
 end function mp_ctoz

 function mp_dtoz_1 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_dtoz_1
  intent (in):: da
  integer mpnw
dimension da(:)
dimension mp_dtoz_1(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = da(ii1)
  call mpxzc (xa, mp_dtoz_1(ii1)%mpc)
end do 
  return
 end function mp_dtoz_1

 function mp_dtoz_2 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_dtoz_2
  intent (in):: da
  integer mpnw
dimension da(:,:)
dimension mp_dtoz_2(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = da(ii1,ii2)
  call mpxzc (xa, mp_dtoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_dtoz_2

 function mp_xtoz_1 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_xtoz_1
  intent (in):: xa
  integer mpnw
dimension xa(:)
dimension mp_xtoz_1(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  call mpxzc (xa(ii1), mp_xtoz_1(ii1)%mpc)
end do 
  return
 end function mp_xtoz_1

 function mp_xtoz_2 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_xtoz_2
  intent (in):: xa
  integer mpnw
dimension xa(:,:)
dimension mp_xtoz_2(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  call mpxzc (xa(ii1,ii2), mp_xtoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_xtoz_2

 function mp_atoz_1 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_complex):: mp_atoz_1
  character*1 az(mpipl+100)
  type (mp_real) q1
  integer mpnw
dimension aa(:)
dimension mp_atoz_1(size(aa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(aa,1)
  l = len (aa(ii1))
  do i = 1, l
   az(i) = aa(ii1)(i:i)
  enddo
  call mpinpc (az, l, q1%mpr, mpnw) 
  call mpmzc (q1%mpr, mp_atoz_1(ii1)%mpc)
end do 
  return
 end function mp_atoz_1

 function mp_atoz_2 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_complex):: mp_atoz_2
  character*1 az(mpipl+100)
  type (mp_real) q1
  integer mpnw
dimension aa(:,:)
dimension mp_atoz_2(size(aa,1),size(aa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(aa,1)
do ii2=1,size(aa,2)
  l = len (aa(ii1,ii2))
  do i = 1, l
   az(i) = aa(ii1,ii2)(i:i)
  enddo
  call mpinpc (az, l, q1%mpr, mpnw) 
  call mpmzc (q1%mpr, mp_atoz_2(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_atoz_2

 function mp_jjtoz_10 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_10
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension mp_jjtoz_10(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmmpc (ja(ii1)%mpi, jb%mpi, mp4, mp_jjtoz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_jjtoz_10

 function mp_jjtoz_01 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_01
  intent (in):: ja, jb
  integer mpnw
dimension jb(:)
dimension mp_jjtoz_01(size(jb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(jb,1)
  call mpmmpc (ja%mpi, jb(ii1)%mpi, mp4, mp_jjtoz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_jjtoz_01

 function mp_jjtoz_20 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_20
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension mp_jjtoz_20(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmmpc (ja(ii1,ii2)%mpi, jb%mpi, mp4, mp_jjtoz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_jjtoz_20

 function mp_jjtoz_02 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_02
  intent (in):: ja, jb
  integer mpnw
dimension jb(:,:)
dimension mp_jjtoz_02(size(jb,1),size(jb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(jb,1)
do ii2=1,size(jb,2)
  call mpmmpc (ja%mpi, jb(ii1,ii2)%mpi, mp4, mp_jjtoz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_jjtoz_02

 function mp_jjtoz_11 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_11
  intent (in):: ja, jb
  integer mpnw
dimension ja(:)
dimension jb(:)
dimension mp_jjtoz_11(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpmmpc (ja(ii1)%mpi, jb(ii1)%mpi, mp4, mp_jjtoz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_jjtoz_11

 function mp_jjtoz_22 (ja, jb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_jjtoz_22
  intent (in):: ja, jb
  integer mpnw
dimension ja(:,:)
dimension jb(:,:)
dimension mp_jjtoz_22(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpmmpc (ja(ii1,ii2)%mpi, jb(ii1,ii2)%mpi, mp4, mp_jjtoz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_jjtoz_22

 function mp_qqtoz_10 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_10
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension mp_qqtoz_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmmpc (qa(ii1)%mpr, qb%mpr, mp4, mp_qqtoz_10(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_qqtoz_10

 function mp_qqtoz_01 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_01
  intent (in):: qa, qb
  integer mpnw
dimension qb(:)
dimension mp_qqtoz_01(size(qb,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qb,1)
  call mpmmpc (qa%mpr, qb(ii1)%mpr, mp4, mp_qqtoz_01(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_qqtoz_01

 function mp_qqtoz_20 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_20
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension mp_qqtoz_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmmpc (qa(ii1,ii2)%mpr, qb%mpr, mp4, mp_qqtoz_20(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_qqtoz_20

 function mp_qqtoz_02 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_02
  intent (in):: qa, qb
  integer mpnw
dimension qb(:,:)
dimension mp_qqtoz_02(size(qb,1),size(qb,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qb,1)
do ii2=1,size(qb,2)
  call mpmmpc (qa%mpr, qb(ii1,ii2)%mpr, mp4, mp_qqtoz_02(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_qqtoz_02

 function mp_qqtoz_11 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_11
  intent (in):: qa, qb
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension mp_qqtoz_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpmmpc (qa(ii1)%mpr, qb(ii1)%mpr, mp4, mp_qqtoz_11(ii1)%mpc, mpnw) 
end do 
  return
 end function mp_qqtoz_11

 function mp_qqtoz_22 (qa, qb)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_qqtoz_22
  intent (in):: qa, qb
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension mp_qqtoz_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpmmpc (qa(ii1,ii2)%mpr, qb(ii1,ii2)%mpr, mp4, mp_qqtoz_22(ii1,ii2)%mpc, mpnw) 
end do 
end do 
  return
 end function mp_qqtoz_22

 function mp_iitoz_10 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_10
  intent (in):: ia, ib
  integer mpnw
dimension ia(:)
dimension mp_iitoz_10(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = cmplx (ia(ii1), ib, kdb)
  call mpxzc (xa, mp_iitoz_10(ii1)%mpc)
end do 
  return
 end function mp_iitoz_10

 function mp_iitoz_01 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_01
  intent (in):: ia, ib
  integer mpnw
dimension ib(:)
dimension mp_iitoz_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  xa = cmplx (ia, ib(ii1), kdb)
  call mpxzc (xa, mp_iitoz_01(ii1)%mpc)
end do 
  return
 end function mp_iitoz_01

 function mp_iitoz_20 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_20
  intent (in):: ia, ib
  integer mpnw
dimension ia(:,:)
dimension mp_iitoz_20(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = cmplx (ia(ii1,ii2), ib, kdb)
  call mpxzc (xa, mp_iitoz_20(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_iitoz_20

 function mp_iitoz_02 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_02
  intent (in):: ia, ib
  integer mpnw
dimension ib(:,:)
dimension mp_iitoz_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  xa = cmplx (ia, ib(ii1,ii2), kdb)
  call mpxzc (xa, mp_iitoz_02(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_iitoz_02

 function mp_iitoz_11 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_11
  intent (in):: ia, ib
  integer mpnw
dimension ia(:)
dimension ib(:)
dimension mp_iitoz_11(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  xa = cmplx (ia(ii1), ib(ii1), kdb)
  call mpxzc (xa, mp_iitoz_11(ii1)%mpc)
end do 
  return
 end function mp_iitoz_11

 function mp_iitoz_22 (ia, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_iitoz_22
  intent (in):: ia, ib
  integer mpnw
dimension ia(:,:)
dimension ib(:,:)
dimension mp_iitoz_22(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  xa = cmplx (ia(ii1,ii2), ib(ii1,ii2), kdb)
  call mpxzc (xa, mp_iitoz_22(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_iitoz_22

 function mp_ddtoz_10 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_10
  intent (in):: da, db
  integer mpnw
dimension da(:)
dimension mp_ddtoz_10(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = cmplx (da(ii1), db, kdb)
  call mpxzc (xa, mp_ddtoz_10(ii1)%mpc)
end do 
  return
 end function mp_ddtoz_10

 function mp_ddtoz_01 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_01
  intent (in):: da, db
  integer mpnw
dimension db(:)
dimension mp_ddtoz_01(size(db,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(db,1)
  xa = cmplx (da, db(ii1), kdb)
  call mpxzc (xa, mp_ddtoz_01(ii1)%mpc)
end do 
  return
 end function mp_ddtoz_01

 function mp_ddtoz_20 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_20
  intent (in):: da, db
  integer mpnw
dimension da(:,:)
dimension mp_ddtoz_20(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = cmplx (da(ii1,ii2), db, kdb)
  call mpxzc (xa, mp_ddtoz_20(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_ddtoz_20

 function mp_ddtoz_02 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_02
  intent (in):: da, db
  integer mpnw
dimension db(:,:)
dimension mp_ddtoz_02(size(db,1),size(db,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(db,1)
do ii2=1,size(db,2)
  xa = cmplx (da, db(ii1,ii2), kdb)
  call mpxzc (xa, mp_ddtoz_02(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_ddtoz_02

 function mp_ddtoz_11 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_11
  intent (in):: da, db
  integer mpnw
dimension da(:)
dimension db(:)
dimension mp_ddtoz_11(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  xa = cmplx (da(ii1), db(ii1), kdb)
  call mpxzc (xa, mp_ddtoz_11(ii1)%mpc)
end do 
  return
 end function mp_ddtoz_11

 function mp_ddtoz_22 (da, db)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_complex):: mp_ddtoz_22
  intent (in):: da, db
  integer mpnw
dimension da(:,:)
dimension db(:,:)
dimension mp_ddtoz_22(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  xa = cmplx (da(ii1,ii2), db(ii1,ii2), kdb)
  call mpxzc (xa, mp_ddtoz_22(ii1,ii2)%mpc)
end do 
end do 
  return
 end function mp_ddtoz_22

 subroutine mp_cssh_111 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  intent (out):: qb, qc
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension qc(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcssh (qa(ii1)%mpr, mpl02%mpr, qb(ii1)%mpr, qc(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_cssh_111

 subroutine mp_cssh_222 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  intent (out):: qb, qc
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension qc(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcssh (qa(ii1,ii2)%mpr, mpl02%mpr, qb(ii1,ii2)%mpr, qc(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_cssh_222

 subroutine mp_cssn_111 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  intent (out):: qb, qc
  integer mpnw
dimension qa(:)
dimension qb(:)
dimension qc(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpcssn (qa(ii1)%mpr, mppic%mpr, qb(ii1)%mpr, qc(ii1)%mpr, mpnw) 
end do 
  return
 end subroutine mp_cssn_111

 subroutine mp_cssn_222 (qa, qb, qc)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: qa
  intent (out):: qb, qc
  integer mpnw
dimension qa(:,:)
dimension qb(:,:)
dimension qc(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpcssn (qa(ii1,ii2)%mpr, mppic%mpr, qb(ii1,ii2)%mpr, qc(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end subroutine mp_cssn_222

 function mp_qtoj_1 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_qtoj_1
  intent (in):: qa
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:)
dimension mp_qtoj_1(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpeq (qa(ii1)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_qtoj_1(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_qtoj_1

 function mp_qtoj_2 (qa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_qtoj_2
  intent (in):: qa
  type (mp_real) q1, q2
  integer mpnw
dimension qa(:,:)
dimension mp_qtoj_2(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpeq (qa(ii1,ii2)%mpr, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_qtoj_2(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_qtoj_2

 function mp_ztoj_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_ztoj_1
  intent (in):: za
  type (mp_real) q1, q2
  integer mpnw
dimension za(:)
dimension mp_ztoj_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpeq (za(ii1)%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_ztoj_1(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_ztoj_1

 function mp_ztoj_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_ztoj_2
  intent (in):: za
  type (mp_real) q1, q2
  integer mpnw
dimension za(:,:)
dimension mp_ztoj_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpeq (za(ii1,ii2)%mpc, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_ztoj_2(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_ztoj_2

 function mp_itoj_1 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_itoj_1
  intent (in):: ia
  integer mpnw
dimension ia(:)
dimension mp_itoj_1(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, mp_itoj_1(ii1)%mpi)
end do 
  return
 end function mp_itoj_1

 function mp_itoj_2 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_itoj_2
  intent (in):: ia
  integer mpnw
dimension ia(:,:)
dimension mp_itoj_2(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, mp_itoj_2(ii1,ii2)%mpi)
end do 
end do 
  return
 end function mp_itoj_2

 function mp_dtoj_1 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_dtoj_1
  intent (in):: da
  type (mp_real) q1, q2
  integer mpnw
dimension da(:)
dimension mp_dtoj_1(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, q1%mpr)
  call mpinfr (q1%mpr, mp_dtoj_1(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_dtoj_1

 function mp_dtoj_2 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_dtoj_2
  intent (in):: da
  type (mp_real) q1, q2
  integer mpnw
dimension da(:,:)
dimension mp_dtoj_2(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, q1%mpr)
  call mpinfr (q1%mpr, mp_dtoj_2(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_dtoj_2

 function mp_xtoj_1 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_xtoj_1
  intent (in):: xa
  type (mp_real) q1, q2
  integer mpnw
dimension xa(:)
dimension mp_xtoj_1(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  da = xa(ii1)
  call mpdmc (da, 0, q1%mpr)
  call mpinfr (q1%mpr, mp_xtoj_1(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_xtoj_1

 function mp_xtoj_2 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_integer):: mp_xtoj_2
  intent (in):: xa
  type (mp_real) q1, q2
  integer mpnw
dimension xa(:,:)
dimension mp_xtoj_2(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  da = xa(ii1,ii2)
  call mpdmc (da, 0, q1%mpr)
  call mpinfr (q1%mpr, mp_xtoj_2(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_xtoj_2

 function mp_atoj_1 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_integer):: mp_atoj_1
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension aa(:)
dimension mp_atoj_1(size(aa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(aa,1)
  l = len (aa(ii1))
  do i = 1, l
   az(i) = aa(ii1)(i:i)
  enddo
  call mpinpc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_atoj_1(ii1)%mpi, q2%mpr, mpnw) 
end do 
  return
 end function mp_atoj_1

 function mp_atoj_2 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_integer):: mp_atoj_2
  character*1 az(mpipl+100)
  type (mp_real) q1, q2
  integer mpnw
dimension aa(:,:)
dimension mp_atoj_2(size(aa,1),size(aa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(aa,1)
do ii2=1,size(aa,2)
  l = len (aa(ii1,ii2))
  do i = 1, l
   az(i) = aa(ii1,ii2)(i:i)
  enddo
  call mpinpc (az, l, q1%mpr, mpnw) 
  call mpinfr (q1%mpr, mp_atoj_2(ii1,ii2)%mpi, q2%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atoj_2

 function mp_nrt_10 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_10
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension mp_nrt_10(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpnrt (qa(ii1)%mpr, ib, mp_nrt_10(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_nrt_10

 function mp_nrt_01 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_01
  intent (in):: qa, ib
  integer mpnw
dimension ib(:)
dimension mp_nrt_01(size(ib,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ib,1)
  call mpnrt (qa%mpr, ib(ii1), mp_nrt_01(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_nrt_01

 function mp_nrt_20 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_20
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension mp_nrt_20(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpnrt (qa(ii1,ii2)%mpr, ib, mp_nrt_20(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_nrt_20

 function mp_nrt_02 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_02
  intent (in):: qa, ib
  integer mpnw
dimension ib(:,:)
dimension mp_nrt_02(size(ib,1),size(ib,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ib,1)
do ii2=1,size(ib,2)
  call mpnrt (qa%mpr, ib(ii1,ii2), mp_nrt_02(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_nrt_02

 function mp_nrt_11 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_11
  intent (in):: qa, ib
  integer mpnw
dimension qa(:)
dimension ib(:)
dimension mp_nrt_11(size(qa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(qa,1)
  call mpnrt (qa(ii1)%mpr, ib(ii1), mp_nrt_11(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_nrt_11

 function mp_nrt_22 (qa, ib)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_nrt_22
  intent (in):: qa, ib
  integer mpnw
dimension qa(:,:)
dimension ib(:,:)
dimension mp_nrt_22(size(qa,1),size(qa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(qa,1)
do ii2=1,size(qa,2)
  call mpnrt (qa(ii1,ii2)%mpr, ib(ii1,ii2), mp_nrt_22(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_nrt_22

 subroutine mp_inpj_01 (iu, j1, j2, j3, j4, j5, j6, j7, j8, j9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: j1, j2, j3, j4, j5, j6, j7, j8, j9
  optional:: j2, j3, j4, j5, j6, j7, j8, j9
  character*1 az(mpipl+100)
  integer mpnw
dimension j1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(j1,1)
  call mpinp (iu, j1(ii1)%mpi, az, mpnw) 
  if (present (j2)) call mpinp (iu, j2%mpi, az, mpnw) 
  if (present (j3)) call mpinp (iu, j3%mpi, az, mpnw) 
  if (present (j4)) call mpinp (iu, j4%mpi, az, mpnw) 
  if (present (j5)) call mpinp (iu, j5%mpi, az, mpnw) 
  if (present (j6)) call mpinp (iu, j6%mpi, az, mpnw) 
  if (present (j7)) call mpinp (iu, j7%mpi, az, mpnw) 
  if (present (j8)) call mpinp (iu, j8%mpi, az, mpnw) 
  if (present (j9)) call mpinp (iu, j9%mpi, az, mpnw) 
end do 
  return
 end subroutine mp_inpj_01

 subroutine mp_inpj_02 (iu, j1, j2, j3, j4, j5, j6, j7, j8, j9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: j1, j2, j3, j4, j5, j6, j7, j8, j9
  optional:: j2, j3, j4, j5, j6, j7, j8, j9
  character*1 az(mpipl+100)
  integer mpnw
dimension j1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(j1,1)
do ii2=1,size(j1,2)
  call mpinp (iu, j1(ii1,ii2)%mpi, az, mpnw) 
  if (present (j2)) call mpinp (iu, j2%mpi, az, mpnw) 
  if (present (j3)) call mpinp (iu, j3%mpi, az, mpnw) 
  if (present (j4)) call mpinp (iu, j4%mpi, az, mpnw) 
  if (present (j5)) call mpinp (iu, j5%mpi, az, mpnw) 
  if (present (j6)) call mpinp (iu, j6%mpi, az, mpnw) 
  if (present (j7)) call mpinp (iu, j7%mpi, az, mpnw) 
  if (present (j8)) call mpinp (iu, j8%mpi, az, mpnw) 
  if (present (j9)) call mpinp (iu, j9%mpi, az, mpnw) 
end do 
end do 
  return
 end subroutine mp_inpj_02

 subroutine mp_inpq_01 (iu, q1, q2, q3, q4, q5, q6, q7, q8, q9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: q1, q2, q3, q4, q5, q6, q7, q8, q9
  optional:: q2, q3, q4, q5, q6, q7, q8, q9
  character*1 az(mpipl+100)
  integer mpnw
dimension q1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(q1,1)
  call mpinp (iu, q1(ii1)%mpr, az, mpnw) 
  if (present (q2)) call mpinp (iu, q2%mpr, az, mpnw) 
  if (present (q3)) call mpinp (iu, q3%mpr, az, mpnw) 
  if (present (q4)) call mpinp (iu, q4%mpr, az, mpnw) 
  if (present (q5)) call mpinp (iu, q5%mpr, az, mpnw) 
  if (present (q6)) call mpinp (iu, q6%mpr, az, mpnw) 
  if (present (q7)) call mpinp (iu, q7%mpr, az, mpnw) 
  if (present (q8)) call mpinp (iu, q8%mpr, az, mpnw) 
  if (present (q9)) call mpinp (iu, q9%mpr, az, mpnw) 
end do 
  return
 end subroutine mp_inpq_01

 subroutine mp_inpq_02 (iu, q1, q2, q3, q4, q5, q6, q7, q8, q9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: q1, q2, q3, q4, q5, q6, q7, q8, q9
  optional:: q2, q3, q4, q5, q6, q7, q8, q9
  character*1 az(mpipl+100)
  integer mpnw
dimension q1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(q1,1)
do ii2=1,size(q1,2)
  call mpinp (iu, q1(ii1,ii2)%mpr, az, mpnw) 
  if (present (q2)) call mpinp (iu, q2%mpr, az, mpnw) 
  if (present (q3)) call mpinp (iu, q3%mpr, az, mpnw) 
  if (present (q4)) call mpinp (iu, q4%mpr, az, mpnw) 
  if (present (q5)) call mpinp (iu, q5%mpr, az, mpnw) 
  if (present (q6)) call mpinp (iu, q6%mpr, az, mpnw) 
  if (present (q7)) call mpinp (iu, q7%mpr, az, mpnw) 
  if (present (q8)) call mpinp (iu, q8%mpr, az, mpnw) 
  if (present (q9)) call mpinp (iu, q9%mpr, az, mpnw) 
end do 
end do 
  return
 end subroutine mp_inpq_02

 subroutine mp_inpz_01 (iu, z1, z2, z3, z4, z5, z6, z7, z8, z9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: z1, z2, z3, z4, z5, z6, z7, z8, z9
  optional:: z2, z3, z4, z5, z6, z7, z8, z9
  character*1 az(mpipl+100)
  integer mpnw
dimension z1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(z1,1)
  call mpinp (iu, z1(ii1)%mpc, az, mpnw) 
  call mpinp (iu, z1(ii1)%mpc(mp41), az, mpnw) 
  if (present (z2)) call mpinp (iu, z2%mpc, az, mpnw) 
  if (present (z2)) call mpinp (iu, z2%mpc(mp41), az, mpnw) 
  if (present (z3)) call mpinp (iu, z3%mpc, az, mpnw) 
  if (present (z3)) call mpinp (iu, z3%mpc(mp41), az, mpnw) 
  if (present (z4)) call mpinp (iu, z4%mpc, az, mpnw) 
  if (present (z4)) call mpinp (iu, z4%mpc(mp41), az, mpnw) 
  if (present (z5)) call mpinp (iu, z5%mpc, az, mpnw) 
  if (present (z5)) call mpinp (iu, z5%mpc(mp41), az, mpnw) 
  if (present (z6)) call mpinp (iu, z6%mpc, az, mpnw) 
  if (present (z6)) call mpinp (iu, z6%mpc(mp41), az, mpnw) 
  if (present (z7)) call mpinp (iu, z7%mpc, az, mpnw) 
  if (present (z7)) call mpinp (iu, z7%mpc(mp41), az, mpnw) 
  if (present (z8)) call mpinp (iu, z8%mpc, az, mpnw) 
  if (present (z8)) call mpinp (iu, z8%mpc(mp41), az, mpnw) 
  if (present (z9)) call mpinp (iu, z9%mpc, az, mpnw) 
  if (present (z9)) call mpinp (iu, z9%mpc(mp41), az, mpnw) 
end do 
  return
 end subroutine mp_inpz_01

 subroutine mp_inpz_02 (iu, z1, z2, z3, z4, z5, z6, z7, z8, z9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (out):: z1, z2, z3, z4, z5, z6, z7, z8, z9
  optional:: z2, z3, z4, z5, z6, z7, z8, z9
  character*1 az(mpipl+100)
  integer mpnw
dimension z1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(z1,1)
do ii2=1,size(z1,2)
  call mpinp (iu, z1(ii1,ii2)%mpc, az, mpnw) 
  call mpinp (iu, z1(ii1,ii2)%mpc(mp41), az, mpnw) 
  if (present (z2)) call mpinp (iu, z2%mpc, az, mpnw) 
  if (present (z2)) call mpinp (iu, z2%mpc(mp41), az, mpnw) 
  if (present (z3)) call mpinp (iu, z3%mpc, az, mpnw) 
  if (present (z3)) call mpinp (iu, z3%mpc(mp41), az, mpnw) 
  if (present (z4)) call mpinp (iu, z4%mpc, az, mpnw) 
  if (present (z4)) call mpinp (iu, z4%mpc(mp41), az, mpnw) 
  if (present (z5)) call mpinp (iu, z5%mpc, az, mpnw) 
  if (present (z5)) call mpinp (iu, z5%mpc(mp41), az, mpnw) 
  if (present (z6)) call mpinp (iu, z6%mpc, az, mpnw) 
  if (present (z6)) call mpinp (iu, z6%mpc(mp41), az, mpnw) 
  if (present (z7)) call mpinp (iu, z7%mpc, az, mpnw) 
  if (present (z7)) call mpinp (iu, z7%mpc(mp41), az, mpnw) 
  if (present (z8)) call mpinp (iu, z8%mpc, az, mpnw) 
  if (present (z8)) call mpinp (iu, z8%mpc(mp41), az, mpnw) 
  if (present (z9)) call mpinp (iu, z9%mpc, az, mpnw) 
  if (present (z9)) call mpinp (iu, z9%mpc(mp41), az, mpnw) 
end do 
end do 
  return
 end subroutine mp_inpz_02

 function mp_jtoq_1 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_jtoq_1
  intent (in):: ja
  integer mpnw
dimension ja(:)
dimension mp_jtoq_1(size(ja,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ja,1)
  call mpeq (ja(ii1)%mpi, mp_jtoq_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_jtoq_1

 function mp_jtoq_2 (ja)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_jtoq_2
  intent (in):: ja
  integer mpnw
dimension ja(:,:)
dimension mp_jtoq_2(size(ja,1),size(ja,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ja,1)
do ii2=1,size(ja,2)
  call mpeq (ja(ii1,ii2)%mpi, mp_jtoq_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_jtoq_2

 function mp_ztoq_1 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_ztoq_1
  intent (in):: za
  integer mpnw
dimension za(:)
dimension mp_ztoq_1(size(za,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(za,1)
  call mpeq (za(ii1)%mpc, mp_ztoq_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_ztoq_1

 function mp_ztoq_2 (za)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_ztoq_2
  intent (in):: za
  integer mpnw
dimension za(:,:)
dimension mp_ztoq_2(size(za,1),size(za,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(za,1)
do ii2=1,size(za,2)
  call mpeq (za(ii1,ii2)%mpc, mp_ztoq_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_ztoq_2

 function mp_itoq_1 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_itoq_1
  intent (in):: ia
  integer mpnw
dimension ia(:)
dimension mp_itoq_1(size(ia,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(ia,1)
  da = ia(ii1)
  call mpdmc (da, 0, mp_itoq_1(ii1)%mpr)
end do 
  return
 end function mp_itoq_1

 function mp_itoq_2 (ia)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_itoq_2
  intent (in):: ia
  integer mpnw
dimension ia(:,:)
dimension mp_itoq_2(size(ia,1),size(ia,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(ia,1)
do ii2=1,size(ia,2)
  da = ia(ii1,ii2)
  call mpdmc (da, 0, mp_itoq_2(ii1,ii2)%mpr)
end do 
end do 
  return
 end function mp_itoq_2

 function mp_dtoq_1 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_dtoq_1
  intent (in):: da
  integer mpnw
dimension da(:)
dimension mp_dtoq_1(size(da,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(da,1)
  call mpdmc (da(ii1), 0, mp_dtoq_1(ii1)%mpr)
end do 
  return
 end function mp_dtoq_1

 function mp_dtoq_2 (da)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_dtoq_2
  intent (in):: da
  integer mpnw
dimension da(:,:)
dimension mp_dtoq_2(size(da,1),size(da,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(da,1)
do ii2=1,size(da,2)
  call mpdmc (da(ii1,ii2), 0, mp_dtoq_2(ii1,ii2)%mpr)
end do 
end do 
  return
 end function mp_dtoq_2

 function mp_xtoq_1 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_xtoq_1
  intent (in):: xa
  integer mpnw
dimension xa(:)
dimension mp_xtoq_1(size(xa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(xa,1)
  da = xa(ii1)
  call mpdmc (da, 0, mp_xtoq_1(ii1)%mpr)
end do 
  return
 end function mp_xtoq_1

 function mp_xtoq_2 (xa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  type (mp_real):: mp_xtoq_2
  intent (in):: xa
  integer mpnw
dimension xa(:,:)
dimension mp_xtoq_2(size(xa,1),size(xa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(xa,1)
do ii2=1,size(xa,2)
  da = xa(ii1,ii2)
  call mpdmc (da, 0, mp_xtoq_2(ii1,ii2)%mpr)
end do 
end do 
  return
 end function mp_xtoq_2

 function mp_atoq_1 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_real):: mp_atoq_1
  character*1 az(mpipl+100)
  integer mpnw
dimension aa(:)
dimension mp_atoq_1(size(aa,1))
integer ii1
  mpnw = mpnwx
do ii1=1,size(aa,1)
  l = len (aa(ii1))
  do i = 1, l
   az(i) = aa(ii1)(i:i)
  enddo
  call mpdexc (az, l, mp_atoq_1(ii1)%mpr, mpnw) 
end do 
  return
 end function mp_atoq_1

 function mp_atoq_2 (aa)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  character*(*), intent (in):: aa
  type (mp_real):: mp_atoq_2
  character*1 az(mpipl+100)
  integer mpnw
dimension aa(:,:)
dimension mp_atoq_2(size(aa,1),size(aa,2))
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(aa,1)
do ii2=1,size(aa,2)
  l = len (aa(ii1,ii2))
  do i = 1, l
   az(i) = aa(ii1,ii2)(i:i)
  enddo
  call mpdexc (az, l, mp_atoq_2(ii1,ii2)%mpr, mpnw) 
end do 
end do 
  return
 end function mp_atoq_2

 subroutine mp_outj_01 (iu, j1, j2, j3, j4, j5, j6, j7, j8, j9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: j1, j2, j3, j4, j5, j6, j7, j8, j9
  optional:: j2, j3, j4, j5, j6, j7, j8, j9
  character*1 az(mpipl+100)
  integer mpnw
dimension j1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(j1,1)
  call mpout (iu, j1(ii1)%mpi, mpoud, az, mpnw) 
  if (present (j2)) call mpout (iu, j2%mpi, mpoud, az, mpnw) 
  if (present (j3)) call mpout (iu, j3%mpi, mpoud, az, mpnw) 
  if (present (j4)) call mpout (iu, j4%mpi, mpoud, az, mpnw) 
  if (present (j5)) call mpout (iu, j5%mpi, mpoud, az, mpnw) 
  if (present (j6)) call mpout (iu, j6%mpi, mpoud, az, mpnw) 
  if (present (j7)) call mpout (iu, j7%mpi, mpoud, az, mpnw) 
  if (present (j8)) call mpout (iu, j8%mpi, mpoud, az, mpnw) 
  if (present (j9)) call mpout (iu, j9%mpi, mpoud, az, mpnw) 
end do 
  return
 end subroutine mp_outj_01

 subroutine mp_outj_02 (iu, j1, j2, j3, j4, j5, j6, j7, j8, j9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: j1, j2, j3, j4, j5, j6, j7, j8, j9
  optional:: j2, j3, j4, j5, j6, j7, j8, j9
  character*1 az(mpipl+100)
  integer mpnw
dimension j1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(j1,1)
do ii2=1,size(j1,2)
  call mpout (iu, j1(ii1,ii2)%mpi, mpoud, az, mpnw) 
  if (present (j2)) call mpout (iu, j2%mpi, mpoud, az, mpnw) 
  if (present (j3)) call mpout (iu, j3%mpi, mpoud, az, mpnw) 
  if (present (j4)) call mpout (iu, j4%mpi, mpoud, az, mpnw) 
  if (present (j5)) call mpout (iu, j5%mpi, mpoud, az, mpnw) 
  if (present (j6)) call mpout (iu, j6%mpi, mpoud, az, mpnw) 
  if (present (j7)) call mpout (iu, j7%mpi, mpoud, az, mpnw) 
  if (present (j8)) call mpout (iu, j8%mpi, mpoud, az, mpnw) 
  if (present (j9)) call mpout (iu, j9%mpi, mpoud, az, mpnw) 
end do 
end do 
  return
 end subroutine mp_outj_02

 subroutine mp_outq_01 (iu, q1, q2, q3, q4, q5, q6, q7, q8, q9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: q1, q2, q3, q4, q5, q6, q7, q8, q9
  optional:: q2, q3, q4, q5, q6, q7, q8, q9
  character*1 az(mpipl+100)
  integer mpnw
dimension q1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(q1,1)
  call mpout (iu, q1(ii1)%mpr, mpoud, az, mpnw) 
  if (present (q2)) call mpout (iu, q2%mpr, mpoud, az, mpnw) 
  if (present (q3)) call mpout (iu, q3%mpr, mpoud, az, mpnw) 
  if (present (q4)) call mpout (iu, q4%mpr, mpoud, az, mpnw) 
  if (present (q5)) call mpout (iu, q5%mpr, mpoud, az, mpnw) 
  if (present (q6)) call mpout (iu, q6%mpr, mpoud, az, mpnw) 
  if (present (q7)) call mpout (iu, q7%mpr, mpoud, az, mpnw) 
  if (present (q8)) call mpout (iu, q8%mpr, mpoud, az, mpnw) 
  if (present (q9)) call mpout (iu, q9%mpr, mpoud, az, mpnw) 
end do 
  return
 end subroutine mp_outq_01

 subroutine mp_outq_02 (iu, q1, q2, q3, q4, q5, q6, q7, q8, q9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: q1, q2, q3, q4, q5, q6, q7, q8, q9
  optional:: q2, q3, q4, q5, q6, q7, q8, q9
  character*1 az(mpipl+100)
  integer mpnw
dimension q1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(q1,1)
do ii2=1,size(q1,2)
  call mpout (iu, q1(ii1,ii2)%mpr, mpoud, az, mpnw) 
  if (present (q2)) call mpout (iu, q2%mpr, mpoud, az, mpnw) 
  if (present (q3)) call mpout (iu, q3%mpr, mpoud, az, mpnw) 
  if (present (q4)) call mpout (iu, q4%mpr, mpoud, az, mpnw) 
  if (present (q5)) call mpout (iu, q5%mpr, mpoud, az, mpnw) 
  if (present (q6)) call mpout (iu, q6%mpr, mpoud, az, mpnw) 
  if (present (q7)) call mpout (iu, q7%mpr, mpoud, az, mpnw) 
  if (present (q8)) call mpout (iu, q8%mpr, mpoud, az, mpnw) 
  if (present (q9)) call mpout (iu, q9%mpr, mpoud, az, mpnw) 
end do 
end do 
  return
 end subroutine mp_outq_02

 subroutine mp_outz_01 (iu, z1, z2, z3, z4, z5, z6, z7, z8, z9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: z1, z2, z3, z4, z5, z6, z7, z8, z9
  optional:: z2, z3, z4, z5, z6, z7, z8, z9
  character*1 az(mpipl+100)
  integer mpnw
dimension z1(:)
integer ii1
  mpnw = mpnwx
do ii1=1,size(z1,1)
  call mpout (iu, z1(ii1)%mpc, mpoud, az, mpnw) 
  call mpout (iu, z1(ii1)%mpc(mp41), mpoud, az, mpnw) 
  if (present (z2)) call mpout (iu, z2%mpc, mpoud, az, mpnw) 
  if (present (z2)) call mpout (iu, z2%mpc(mp41), mpoud, az, mpnw) 
  if (present (z3)) call mpout (iu, z3%mpc, mpoud, az, mpnw) 
  if (present (z3)) call mpout (iu, z3%mpc(mp41), mpoud, az, mpnw) 
  if (present (z4)) call mpout (iu, z4%mpc, mpoud, az, mpnw) 
  if (present (z4)) call mpout (iu, z4%mpc(mp41), mpoud, az, mpnw) 
  if (present (z5)) call mpout (iu, z5%mpc, mpoud, az, mpnw) 
  if (present (z5)) call mpout (iu, z5%mpc(mp41), mpoud, az, mpnw) 
  if (present (z6)) call mpout (iu, z6%mpc, mpoud, az, mpnw) 
  if (present (z6)) call mpout (iu, z6%mpc(mp41), mpoud, az, mpnw) 
  if (present (z7)) call mpout (iu, z7%mpc, mpoud, az, mpnw) 
  if (present (z7)) call mpout (iu, z7%mpc(mp41), mpoud, az, mpnw) 
  if (present (z8)) call mpout (iu, z8%mpc, mpoud, az, mpnw) 
  if (present (z8)) call mpout (iu, z8%mpc(mp41), mpoud, az, mpnw) 
  if (present (z9)) call mpout (iu, z9%mpc, mpoud, az, mpnw) 
  if (present (z9)) call mpout (iu, z9%mpc(mp41), mpoud, az, mpnw) 
end do 
  return
 end subroutine mp_outz_01

 subroutine mp_outz_02 (iu, z1, z2, z3, z4, z5, z6, z7, z8, z9)
  implicit real*8 (d), type (mp_integer) (j), &
       type (mp_real) (q), complex (kdb) (x), type (mp_complex) (z)
  intent (in):: z1, z2, z3, z4, z5, z6, z7, z8, z9
  optional:: z2, z3, z4, z5, z6, z7, z8, z9
  character*1 az(mpipl+100)
  integer mpnw
dimension z1(:,:)
integer ii1,ii2
  mpnw = mpnwx
do ii1=1,size(z1,1)
do ii2=1,size(z1,2)
  call mpout (iu, z1(ii1,ii2)%mpc, mpoud, az, mpnw) 
  call mpout (iu, z1(ii1,ii2)%mpc(mp41), mpoud, az, mpnw) 
  if (present (z2)) call mpout (iu, z2%mpc, mpoud, az, mpnw) 
  if (present (z2)) call mpout (iu, z2%mpc(mp41), mpoud, az, mpnw) 
  if (present (z3)) call mpout (iu, z3%mpc, mpoud, az, mpnw) 
  if (present (z3)) call mpout (iu, z3%mpc(mp41), mpoud, az, mpnw) 
  if (present (z4)) call mpout (iu, z4%mpc, mpoud, az, mpnw) 
  if (present (z4)) call mpout (iu, z4%mpc(mp41), mpoud, az, mpnw) 
  if (present (z5)) call mpout (iu, z5%mpc, mpoud, az, mpnw) 
  if (present (z5)) call mpout (iu, z5%mpc(mp41), mpoud, az, mpnw) 
  if (present (z6)) call mpout (iu, z6%mpc, mpoud, az, mpnw) 
  if (present (z6)) call mpout (iu, z6%mpc(mp41), mpoud, az, mpnw) 
  if (present (z7)) call mpout (iu, z7%mpc, mpoud, az, mpnw) 
  if (present (z7)) call mpout (iu, z7%mpc(mp41), mpoud, az, mpnw) 
  if (present (z8)) call mpout (iu, z8%mpc, mpoud, az, mpnw) 
  if (present (z8)) call mpout (iu, z8%mpc(mp41), mpoud, az, mpnw) 
  if (present (z9)) call mpout (iu, z9%mpc, mpoud, az, mpnw) 
  if (present (z9)) call mpout (iu, z9%mpc(mp41), mpoud, az, mpnw) 
end do 
end do 
  return
 end subroutine mp_outz_02

 function mp_nint_1 (qa)