@echo off
rem set d=1
rem BMDP.BAT May 11, 1990
rem This command file requires sufficient environment space for its
rem local variables.  Typically a CONFIG.SYS line like the following
rem is sufficient (depending upon other environment needs you may have):
rem
rem     SHELL=C:\COMMAND.COM /E:500 /P 
rem
rem IMPORTANT:  All of the "set compsec" lines are present to avoid
rem a bug in some DOS 3.x versions, which are unable to detect corruption
rem of the transient portion of COMMAND.COM without this line.
rem
if not "%d%"=="1" goto start
echo param 1 = %1
echo param 2 = %2
echo param 3 = %3
echo param 4 = %4
echo param 5 = %5
echo param 6 = %6
echo param 7 = %7
echo param 8 = %8
echo param 9 = %9

:start
set m=0
set d=
set f=1
if "P%1"=="P" goto domenu

Rem BMDPARSE reads/verifies command line and returns error level indicating
Rem which "program group" to execute.  
Rem   ERRORLEVEL       Meaning
Rem       0          Only BMDP typed, do full Main Menu
Rem       1          User Ctrl/C typed
Rem       2          Cmd Line ok, Program is not Loaded.
Rem       4          Some sort of fatal error or user abort
Rem      10+x        Execute BMDP Group "x".
Rem                  (BMDPINIT.INI contains expanded command line)
Rem
Rem Note the BMDPARSE displays the sign-on logo and usage
Rem message if command line is in error.

set comspec=%comspec%
bmdparse %1 %2 %3 %4 %5 %6 %7 %8 %9
if errorlevel 10 goto pgmselect
if errorlevel  4 goto abort
if errorlevel  2 goto loadpgm
set f=2
goto domenu

Rem Come here when BMDPARSE could not find requested program or
Rem no programs found.

:loadpgm
set f=3
goto domenu

Rem Argument to BMDPC90 says what's needed:
Rem      1  -  no arguments on BMDP command line
Rem      2  -  BMDPARSE found command line error
Rem      3  -  LOAD required (see BMDPARSE)
Rem      4  -  Re-entry after normal program termination

:domenu
set m=1
set comspec=%comspec%
bmdpc90 %f%
if errorlevel 10 goto pgmselect
if errorlevel  4 goto abort
goto done

:pgmselect
set f=1
if errorlevel 41 goto abort
if errorlevel 40 goto quick
if errorlevel 35 goto imexp
if errorlevel 31 goto debugplot
if errorlevel 30 goto plot
if errorlevel 21 goto debugde
if errorlevel 20 goto de
set f=4
if errorlevel 18 goto g18
if errorlevel 17 goto g17
if errorlevel 16 goto g16
if errorlevel 15 goto g15
if errorlevel 14 goto g14
if errorlevel 13 goto g13
if errorlevel 12 goto g12
if errorlevel 11 goto g11
echo BMDP.BAT BUG -- PGMSELECT with ERROR .LE. 10
goto abort

:quick
set comspec=%comspec%
rem bmdpqs
cd d:\BMDP
rem cd d:\statis\bmdp
mentor
rem if errorlevel  4 goto abort
rem if exist BMDPINIT.INI goto g11
if "%m%"=="1" goto domenu
goto pgmdone


:imexp
set comspec=%comspec%
imex
if errorlevel  4 goto abort
if exist BMDPINIT.INI goto g11
if "%m%"=="1" goto domenu
goto pgmdone

:debugplot
set d=/D
:plot
set comspec=%comspec%
bmdplt90 %d%
if errorlevel  4 goto abort
if "%m%"=="1" goto domenu
goto pgmdone

:debugde
set d=/D
:de
set comspec=%comspec%
bmdpde %d%
if errorlevel  4 goto abort
if "%m%"=="1" goto domenu
goto pgmdone

:g18
set comspec=%comspec%
bmdpgrp8
goto pgmdone

:g17
set comspec=%comspec%
bmdpgrp7
goto pgmdone

:g16
set comspec=%comspec%
bmdpgrp6
goto pgmdone

:g15
set comspec=%comspec%
bmdpgrp5
goto pgmdone

:g14
set comspec=%comspec%
bmdpgrp4
goto pgmdone

:g13
set comspec=%comspec%
bmdpgrp3
goto pgmdone

:g12
set comspec=%comspec%
bmdpgrp2
goto pgmdone

:g11
set comspec=%comspec%
bmdpgrp1
goto pgmdone

rem  exit code from program...
rem  >10 - run group "exitcode-10"
rem    4 - some sort of abort/fatal error
rem    2 - need to load or run another program (info in INITFILE)
rem    1 - CTRL/C abort
rem    0 - Quit from editor or normal termination in STOPIT

:pgmdone
rem if errorlevel 15 goto abort
if errorlevel 19 goto abort
if errorlevel 11 goto pgmselect
if errorlevel  4 goto abort
if errorlevel  2 goto loadpgm
if "%m%"=="1" goto domenu

:done
set comspec=%comspec%
cls
echo BMDP All Done!

:abort
set m=
set d=
set f=

