% @=============================================================================
% Copyright (c)2025 University of Granada - SPAIN
% This software is distributed under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPLv3
% license can be found at http://www.gnu.org/copyleft/gpl.html
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF GRANADA DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED, INCLUDING 
% BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
% PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE USE 
% OF THIS SOFTWARE.
% =============================================================================@
%
% Author: Juan Ruiz de Miras, 2025

function [X, Y] = prepareDataCNN(patchesColorVeronese, patchesGrayscaleVeronese, patchesEdgesVeronese, ...
                                 patchesColorNonVeronese, patchesGrayscaleNonVeronese, patchesEdgesNonVeronese, ...
                                 patchSize)
    numPatchesVeronese = numel(patchesColorVeronese);
    numPatchesNonVeronese = numel(patchesColorNonVeronese);
    totalPatches = numPatchesVeronese + numPatchesNonVeronese;

    % generate array of size [patchSize, patchSize, 5 channels, totalPatches]
    X = zeros(patchSize(1), patchSize(2), 5, totalPatches, 'single');
    Y = categorical([ones(1, numPatchesVeronese), zeros(1, numPatchesNonVeronese)]);  % 1 = Veronese, 0 = non-Veronese

    % process channels for Veronese paintings
    for i = 1:numPatchesVeronese
        color = im2single(patchesColorVeronese{i});
        grayscale = im2single(patchesGrayscaleVeronese{i});
        edges = im2single(patchesEdgesVeronese{i});

        if size(color, 3) == 3
            X(:, :, 1:3, i) = color;
        end
        X(:, :, 4, i) = grayscale;
        X(:, :, 5, i) = edges;
    end

    % process channels for non-Veronese paintings
    for i = 1:numPatchesNonVeronese
        idx = numPatchesVeronese + i;
        color = im2single(patchesColorNonVeronese{i});
        grayscale = im2single(patchesGrayscaleNonVeronese{i});
        edges = im2single(patchesEdgesNonVeronese{i});

        if size(color, 3) == 3
            X(:, :, 1:3, idx) = color;
        end
        X(:, :, 4, idx) = grayscale;
        X(:, :, 5, idx) = edges;
    end
end
