% @=============================================================================
% Copyright (c)2025 University of Granada - SPAIN
% This software is distributed under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPLv3
% license can be found at http://www.gnu.org/copyleft/gpl.html
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF GRANADA DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED, INCLUDING 
% BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
% PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE USE 
% OF THIS SOFTWARE.
% =============================================================================@
%
% Author: Juan Ruiz de Miras, 2025

function [patchesColor, patchesGray, patchesEdges] = extractPatches(patchSize, overlap, class, paintings)
    basePath = ['./dataset/' class '/'];
    representations = {'color', 'grayscale', 'edges'};
    stride = round(patchSize .* (1 - overlap));

    patchesColor = {};
    patchesGray = {};
    patchesEdges = {};

    numPaintings = length(paintings);
    for i = 1:numPaintings
        baseName = [paintings{i} '_' lower(class) '_'];
        for rep = 1:length(representations)
            representation = representations{rep};
            fileName = fullfile(basePath, [baseName representation '.bmp']);
            img = imread(fileName);

            % Extract patches for representation rep
            [h, w, ~] = size(img);
            patchList = {};
            idx = 1;
            for r = 1:stride(1):(h - patchSize(1) + 1)
                for c = 1:stride(2):(w - patchSize(2) + 1)
                    patch = img(r:r+patchSize(1)-1, c:c+patchSize(2)-1, :);
                    patchList{idx} = patch;
                    idx = idx + 1;
                end
            end

            % store patches for representation rep
            switch representation
                case 'color'
                    patchesColor = [patchesColor, patchList];
                case 'grayscale'
                    patchesGray = [patchesGray, patchList];
                case 'edges'
                    patchesEdges = [patchesEdges, patchList];
            end
        end
    end
end
