/***************************************************************
 **
 ** Fichero: LSIX.H
 ** Funcion: Libreria basica de gestion de ventanas 
 **          para implemntar clientes X
 **          (fichero de declaraciones de funciones)
 **
 ***************************************************************/


#ifndef LSIX_H
#define LSIX_H

#ifdef HPUX
typedef char *caddr_t ;  /** tipo usado en Xutil.h en HP/UX **/
#include "stdlib.h"      /** version "ANSI" en HPUX del stdlib.h **/
#else
#include <stdlib.h>
#endif

#include <stdio.h>
#include <string.h> 
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>

#ifndef boolean
typedef unsigned char boolean ;
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

/**  Para el teclado 
**/

#define ERRT   0
#define BORRAR 1
#define ENTER  2
#define ESCAPE 3
#define TAB    4
#define UP     5
#define DOWN   6
#define RIGHT  7
#define LEFT   8
#define SHIFT  9

/**  Cursores 
**/

#define FLECHA  0
#define CRUZ    1
#define RELOJ   2
#define EID     3
#define ESI     4

/**  Tipos de sincronizacion para LSIX_AbrirDisplay
**/

#define SINCRONIZADO    TRUE
#define NO_SINCRONIZADO FALSE

/**  Tipos de visibilidad de ventanas   
**/

#define VISIBLE    TRUE
#define NO_VISIBLE FALSE

/**  Accciones posibles de los botones del raton 
**/

#define  PULSAR    0
#define  LEVANTAR  1
#define  MOVER     3
 
/**  tipos de visuales para abrir ventanas 
**/

#define VISUAL_8_PLANOS          0
#define VISUAL_15_PLANOS         1
#define VISUAL_16_PLANOS_RGB565  2
#define VISUAL_24_PLANOS         3


#define RESERVA(res,n,tipo,mensaje)                              \
       if (((res)=(tipo *)malloc(n*sizeof(tipo)))==NULL)         \
       {   printf("\7\nERROR: falta memoria %s\n",mensaje) ;     \
          exit(1) ;                                              \
       }

 
#ifndef BYTE
typedef unsigned char byte ;
#define BYTE
#endif


/**********************************************************************/

#define MAXRESX 1024


struct xventana  
{
  int                  resx, resy ;
  int                  visible    ;                
  unsigned             fontheight, pad,bw; 
  Drawable             win;
  GC                   gc;
  XFontStruct          *fontstruct;
  XEvent               event;
  XSizeHints           xsh;
  XWindowAttributes    xwa;
  XSetWindowAttributes xswa;
  XColor               xcolor[256];
  Colormap             map,def_map;
  Visual               visual;
  int                  tipo_visual ; /** indica el tipo de visual (8/24 bits/pixel) **/
} ;

typedef struct xventana * LSIX_ventana ;

typedef unsigned long LSIX_Color ;

/***********************************************************************/

void          chkf                        ( FILE *f, char *nombre ) ;
void          chk_dpy                     ( void ) ;
void          chk2                        ( void ) ;
void          LSIX_VentanaDeTrabajo       ( LSIX_ventana w ) ;


void          LSIX_Sincroniza             ( void ) ;

int           LSIX_Ancho                  ( void ) ;
int           LSIX_Alto                   ( void ) ;
LSIX_Color    LSIX_LeerPixel              ( int x, int y  ) ;

/***  Control del display y ventanas
***/

void          LSIX_AbrirDisplay           ( char * nombre_disp, int modo_sinc ) ;
LSIX_ventana  LSIX_AbrirVentana           ( int iresx, int iresy, const char *titulo, int visible, int tipo_visual ) ;
void          LSIX_CerrarVentana          ( void ) ;

/***  Control del tipo de visual
***/

boolean       LSIX_SoportaVisual          ( unsigned tipo_visual ) ;
unsigned      LSIX_LeeMejorVisual         ( void ) ;

/***  Creacion de colores, actualizacion de paletas, etc....
***/

void          LSIX_CambiarPaleta          ( byte entrada, byte r, byte g, byte b ) ;
LSIX_Color    LSIX_CreaColorRGB           ( byte r, byte g, byte b ) ;
void          LSIX_LeeComponentesRGB      ( LSIX_Color c, byte *r, byte *g, byte *b ) ;


/***  Lectura de eventos
***/

void          LSIX_EsperaAccionRaton      ( unsigned *accion, unsigned *x, unsigned *y ) ;
boolean       LSIX_EsperaEventoExposicion ( void ) ;
void          LSIX_EsperaTeclaPulsada     ( int *, unsigned int * );

/***  Copiar ventanas hacia/desde memoria y entre ellas.   
***/

void          LSIX_GrabarVentana          ( int,int,int,int,void *) ;
void          LSIX_RestauraVentana        ( int,int,void *,int ) ;
void          LSIX_CargaImagen            ( boolean visible, unsigned  char *img[256],int x,int y) ;
void          LSIX_CopiarVentana          ( LSIX_ventana org, int desx, int desy ) ;

/***   Primitivas de salida.
***/

void          LSIX_FijarPixel             ( int x, int y, LSIX_Color c  ) ;               
void          LSIX_Linea                  ( int x0, int y0, int x1, int y1, LSIX_Color c ) ;
void          LSIX_RellenaRectangulo      ( int x0, int y0, int x1, int y1, LSIX_Color c ) ;
void          LSIX_RellenaPoligono        ( int n, int x0, int y0, int *puntos, LSIX_Color c ) ; 
void          LSIX_DibujaRectangulo       ( int x0, int y0, int x1, int y1, LSIX_Color c ) ;
void          LSIX_PintaCadena            ( char *, int, int ); 
void          LSIX_ClearArea              ( int,int,int,int );
void          LSIX_ClearWindow            ( void ) ;

/***   Control de atributos para primitivas de salidas
***/

void          LSIX_FijarRectanguloRecorte ( int x0, int y0, int x1, int y1 ) ;
void          LSIX_FijarColorActual       ( LSIX_Color c );
int           LSIX_StringSizeFont         ( char *, int );
void          LSIX_CambiaPunteroRaton     ( int );
void          LSIX_SetFont                ( int );



#endif
