//***************************************************************
//***
//***   File:     Vector.H
//***   Function: Declarations of 'Vector' and derived classes
//***
//***************************************************************

#ifndef  VECTORH_HPP
#define  VECTORH_HPP

#include <math.h>
#include <ostream.h>

//*************************************************************


typedef unsigned char Axis ;
typedef double Scalar ;

#define X 0
#define Y 1
#define Z 2

class Vector 
{

  protected :

  Scalar c[3] ;

  public :

  //**************************************************

  Vector
  (
  )
  {
     c[X]= c[Y]= c[Z]= 0.0 ;
  }

  //***************************************************
       
  Vector
  ( 
     Scalar cx , 
     Scalar cy , 
     Scalar cz 
  ) 
  {
     c[X]= cx ; 
     c[Y]= cy ;
     c[Z]= cz ; 
  }

  //***************************************************
        
  friend ostream & operator << 
  ( 
     ostream &       os , 
     const Vector &  v 
  ) 
  {
     return os << "(" << v.c[X] << "," << v.c[Y] << "," << v.c[Z] << ")" ;
  }

  //***************************************************       
         
  Scalar operator[]
  ( 
     const Axis axis 
  ) 
     const 
  {
     return c[axis] ;
  }
  
  //***************************************************
         
  void operator += 
  ( 
      const Vector & v 
  ) 
  {
     c[X] += v.c[X] ;
     c[Y] += v.c[Y] ;
     c[Z] += v.c[Z] ;
  }

  //***************************************************
    
  Vector operator + 
  ( 
     const Vector & v 
  ) 
     const 
  {
     return Vector( c[X]+v.c[X], c[Y]+v.c[Y], c[Z]+v.c[Z] ) ;
  }
    
  //***************************************************
         
  void operator -= 
  ( 
     const Vector &v 
  ) 
  {
     c[X] -= v.c[X] ;
     c[Y] -= v.c[Y] ;
     c[Z] -= v.c[Z] ;
  }

  //***************************************************
  

  Vector operator - 
  ( 
     const Vector & v 
  ) 
     const 
  {
     return Vector( c[X]-v.c[X], c[Y]-v.c[Y], c[Z]-v.c[Z] ) ;
  }

  //***************************************************
  

  Scalar operator | 
  ( 
     const Vector & v 
  ) 
     const 
  {
     return c[X]*v.c[X] + c[Y]*v.c[Y] + c[Z]*v.c[Z] ;
  }

  //***************************************************
  
  void operator *= 
  ( 
     Scalar t 
  ) 
  {
     c[X] *= t ;
     c[Y] *= t ;
     c[Z] *= t ;
  }

  //***************************************************
        
  Vector operator * 
  ( 
     Scalar t 
  ) 
     const  
  {
     return Vector( t*c[X], t*c[Y], t*c[Z] ) ;
  }
  
  //***************************************************  

  friend Vector operator * 
  ( 
     Scalar          t , 
     const Vector &  v 
  ) 
  {
     return Vector( t*v.c[X], t*v.c[Y], t*v.c[Z] ) ;
  }

  //***************************************************
  
  friend Vector operator * 
  ( 
      const Vector & v1 , 
      const Vector & v2 
  ) 
  {
     return Vector( v1.c[Y]*v2.c[Z] - v1.c[Z]*v2.c[Y],
                    v1.c[Z]*v2.c[X] - v1.c[X]*v2.c[Z],
                    v1.c[X]*v2.c[Y] - v1.c[Y]*v2.c[X] ) ;
  }

  //***************************************************
  
  Scalar Length
  ( 
  ) 
     const 
  {
     return sqrt( c[X]*c[X] + c[Y]*c[Y] + c[Z]*c[Z] ) ;
  }

  //***************************************************

  Scalar SquaredLength 
  ( 
  ) 
     const
  {
     return  c[X]*c[X] + c[Y]*c[Y] + c[Z]*c[Z] ;
  }

  //***************************************************

  void Normalize
  (
  )
  {
     Scalar l= Length() ;

     if ( l == 0.0 )
        throw "Zero length vector in 'Vector::Normalize'" ;

     (Vector::operator*=)( 1.0/l ) ;
  }

  //***************************************************
    
  Vector Normalized 
  ( 
  ) 
     const 
  {
     Scalar l= Length() ;

     if ( l == 0.0 )
        throw "Zero length vector in 'Vector::Normalized'" ;

     return (*this) * (1.0/l ) ;
  }

  //***************************************************
    
  Vector Norm2
  ( 
  ) 
     const 
  {
     Scalar l= SquaredLength() ;

     if ( l == 0.0 )
        throw "Zero length vector in 'Vector::Norm2'" ;

     return (*this) * (1.0/l ) ;
  }

} ;


//*******************************************************


 inline Scalar CrossProdZ
 (
    const Vector &  v1 ,
    const Vector &  v2 
 ) 
 {
    return v1[X]*v2[Y] - v1[Y]*v2[X]  ;
 }

#endif  // VECTORH_HPP


