#ifndef PTRIANGLE_H_INCLUDED
#define PTRIANGLE_H_INCLUDED

#include <stdlib.h>
#include <math.h>

#include "Aux.H"
#include "Vector.H"
#include "SphTri.H"
#include "ETriangle.H"

//**********************************************

class SamplingProc
{

   protected :

   Vector   vertex[3] ; // triangle vertexs
   Vector   normal    ; // triangle normal vector (no normalized)
   Scalar   k         ; // inner product of 'vertex[0]' and 'normal' 

   LocalRefSys   lrs ;  // local frame at sample point

   void SphereToPlane
   (  
      unsigned nSamples ,
      Sample   sampleSet[] 
   )  const ;

   public :

   SamplingProc
   (  
      const LocalRefSys &  iLrs     ,
      const Vector &       iVertex0 ,
      const Vector &       iVertex1 ,
      const Vector &       iVertex2
   )  ;

   virtual void GetSamples
   (
      unsigned  nSamples ,
      Sample    sampleSet[]
   )  const = 0 ;

} ;

//***************************************************************


class PsaSamplingProc : public SamplingProc
{
   protected :

   ETriangle et ;
   Scalar    epsilon ;

   public :

   PsaSamplingProc
   (    
      const LocalRefSys &  iLrs     ,
      const Vector &       iVertex0 ,
      const Vector &       iVertex1 ,
      const Vector &       iVertex2 ,
      Scalar               iEpsilon
   )  ;

   virtual void GetSamples
   (
      unsigned  nSamples ,
      Sample    sampleSet[]
   )  const ;

} ;
  
#endif PTRIANGLE_H_INCLUDED
