

#include <stdlib.h>
#include <math.h>

#include "SamplingProc.H"

//*******************************************************

SamplingProc::SamplingProc
(  
   const LocalRefSys &  iLrs     ,
   const Vector &       iVertex0 ,
   const Vector &       iVertex1 ,
   const Vector &       iVertex2
)  
:  lrs( iLrs ) 
{
   vertex[0]= iVertex0 ;
   vertex[1]= iVertex1 ;
   vertex[2]= iVertex2 ;

   normal = ( vertex[1] - vertex[0] ) * ( vertex[2] - vertex[0] ) ;

   for( unsigned i= 0 ; i < 3 ; i++ )
   {
      Vector local = lrs.WorldToLocal( vertex[i] ) ;

      if ( local[Z] < 0.0 )
      {
         cout << endl << "** local[Z] == " << local[Z] << endl << flush ;
         throw "found triangle vertex with local Z < 0" ;
      }
   }

   normal = ( vertex[1] - vertex[0] ) * ( vertex[2] - vertex[0] ) ;

   if ( normal[Z] < 0.0 )
      normal *= -1.0 ;

   k = ( vertex[0] - lrs.GetOrigin() ) | normal ;
}

//********************************************************

void SamplingProc::SphereToPlane
(  
   unsigned nSamples ,
   Sample   sampleSet[] 
)  const 
{
 
   Vector org = lrs.GetOrigin() ;

   for( unsigned i= 0 ; i < nSamples ; i++ )
   {

      Vector v = lrs.LocalToWorld( sampleSet[i].position ) - org ;
      
      Scalar d = v | normal ;

      if ( d == 0 )
         throw "invalid sample direction (parallel to triangle plane)" ;
      
      Scalar t = k / d ;
    
      sampleSet[i].position = org + (t * v) ;
      
   }   
}

//*******************************************************


PsaSamplingProc::PsaSamplingProc
(    
    const LocalRefSys &  iLrs     ,
    const Vector &       iVertex0 ,
    const Vector &       iVertex1 ,
    const Vector &       iVertex2 ,
    Scalar               iEpsilon
)  
:   SamplingProc( iLrs, iVertex0, iVertex1, iVertex2 ) ,
    epsilon( iEpsilon )
{

    Vector vertexSph[3] ;    

    vertexSph[0]= iLrs.WorldToLocal( iVertex0 ).Normalized() ;
    vertexSph[1]= iLrs.WorldToLocal( iVertex1 ).Normalized() ;
    vertexSph[2]= iLrs.WorldToLocal( iVertex2 ).Normalized() ;

    et = ETriangle( vertexSph[0], vertexSph[1], vertexSph[2], epsilon ) ;
}

//************************************************************

void PsaSamplingProc::GetSamples
(
   unsigned  nSamples ,
   Sample    sampleSet[]
)  const
{
   et.GetSamples( nSamples, sampleSet ) ;
   SphereToPlane( nSamples, sampleSet ) ;
}

//*************************************************************


