
#ifndef PLANAROBJ_H_INCLUDED
#define PLANAROBJ_H_INCLUDED

#include <math.h>

#include "Aux.H"
#include "Vector.H"

//*******************************************

class PlanarObject
{
   protected:
   
   Vector vertex[3]  ;  // these define the plane
   Vector normal     ,  // normal vector (normalized)
          tangentU   ,
          tangentV   ;  // two coplanar orthonormal vectors   

   Vector dualBaseU   ,
          dualBaseV   ; // dual basis set for the plane
   
   Scalar k          ;  // == - (normal | vertex[0] ) 

   public :

   PlanarObject
   (
      const Vector &  iVector0 ,
      const Vector &  iVector1 ,
      const Vector &  iVector2
   )  ;
   
   virtual void IntersectionTest
   ( 
      const Ray &  ray      ,
      Boolean &    hitFound ,
      Scalar &     hitDistance ,
      Vector &     hitPoint
   )  const ;

   Boolean OccludesSegment
   (  const Vector & p1 ,
      const Vector & p2
   )  const ;

   Vector GetVertex
   (
      unsigned i
   )  const ; 

   Vector GetNormal
   (
   )  const ;

   LocalRefSys GetLRS
   (
      const Vector & origin
   )  const ;  

} ;

//*******************************************

class Triangle : public PlanarObject
{
   
   public:

   Triangle
   (
      const Vector &  iVector0 ,
      const Vector &  iVector1 ,
      const Vector &  iVector2
   )  ;

   virtual void IntersectionTest
   ( 
      const Ray &  ray      ,
      Boolean &    hitFound ,
      Scalar &     hitDistance ,
      Vector &     hitPoint
   )  const ;
 
   Vector GetVertex
   (
      unsigned i
   )  const ; 

   Scalar GetFormFactor
   (
      const LocalRefSys & lrs
   )  const ;

   

} ;

//******************************************

class Parallelogram : public PlanarObject
{

   public:

   Parallelogram
   (
      const Vector &  iVector0 ,
      const Vector &  iVector1 ,
      const Vector &  iVector2
   )  ;

   virtual void IntersectionTest
   ( 
      const Ray &  ray      ,
      Boolean &    hitFound ,
      Scalar &     hitDistance ,
      Vector &     hitPoint
   )  const ;

   Vector GetVertex
   (
      unsigned i
   )  const ; 

   Scalar GetFormFactor
   (
      const LocalRefSys & lrs
   )  const ;


} ;

//*****************************************

class RectangleSet : public PlanarObject
{

   unsigned nu ,
            nv ;
   
   public:

   RectangleSet
   (
      const Vector &  iVector0 ,
      const Vector &  iVector1 ,
      const Vector &  iVector2 ,
      unsigned        inu      ,
      unsigned        inv  
   )  ;

   virtual void IntersectionTest
   ( 
      const Ray &  ray      ,
      Boolean &    hitFound ,
      Scalar &     hitDistance ,
      Vector &     hitPoint
   )  const ;


} ;

#endif PLANAROBJ_H_INCLUDED
