

#ifndef ETRIANGLE_H_INCLUDED
#define ETRIANGLE_H_INCLUDED


#include "Vector.H"
#include "Aux.H"


//*****************************************************


class ETriangle
{

   public:

   ETriangle
   () ;
   
   ETriangle
   ( 
      const Vector & cVertex0 ,
      const Vector & cVertex1 ,
      const Vector & cVertex2 ,
      Scalar         iEpsilon
   )  ;

   inline Scalar GetFormFactor()  const
   {
       return formFactor ;
   }   

   inline Scalar GetSolidAngle() const
   {
       return solidAngle ;
   }

   void GetSamples
   (
      unsigned int n ,
      Sample samples[]
   )  const ;


   Vector GetMax() const ;

   ETriangle * GetSubTriangles
   () const ;

   const Vector & operator []
   (  
      int i
   )  const ; 
   
   protected: 
     
       void UpdateFromParent
       (  
          const ETriangle *  parent  ,
          const ETriangle *  intern  ,
          int                i
       )  ;

       Scalar formFactor ;
       Scalar solidAngle ;

       Vector vertex[3] ;
       Vector normal[3] ;

       Scalar sideArcLen[3] ;
       Scalar inteArcLen[3] ;

       Scalar epsilon ;

       void UpdateNormals
       () ;

       void UpdateArcsLengths
       () ;

       void UpdateFormFactor
       () ;

       void UpdateSolidAngle
       () ;

       void ETriangle::GetSamplesSA
       (  
          unsigned int n  ,
          Sample       samples[]
       )  const ;

       void ETriangle::GetSamplesAdap
       (  
          unsigned int n  ,
          Sample       samples[]
       )  const ;

       Vector GetMaxArc
       (  int i0 
       )  const ;

       Vector GetMaxBoundary
       () const ;


       friend ostream & operator << 
       ( 
          ostream &         os ,  
          const ETriangle & et 
       ) ;       
       

} ; // end class ETriangle



void GetNSamples
(
   unsigned  nSamples  ,
   unsigned  nEntries  ,
   double    prob[]    ,
   unsigned  ns[]
)  ;


#endif ETRIANGLE_H_INCLUDED




