#include <stdlib.h>
#include <math.h>
#include "lsix.h"

#include "ETriangle.H"
#include "Vector.H"


class Window
{
   protected :

   unsigned int  resX , 
                 resY ;

   LSIX_ventana  w ;

   LSIX_Color    white ;


   unsigned int World2WinX( Scalar x )
   {
      return (unsigned int)(0.5*(x+1.0)*(float)(resX)) ;
   }


   unsigned int World2WinY( Scalar y )
   {
      return resy - (unsigned int)(0.5*(y+1.0)*(float)(resY)) ;
   }

   Scalar Win2WorldX( unsigned int x )
   {
      return  2.0 * ((Scalar)x/(Scalar)resX - 0.5 );
   }

   Scalar Win2WorldY( unsigned int y )
   {
      return  -2.0 * ((Scalar)y/(Scalar)resY - 0.5 );
   }


   Scalar Screen2WorldY( Scalar y )
   {
       return resy - (unsigned int)(0.5*(y+1.0)*(float)(resY)) ;
   }


   void Init( const char * title )
   {  
       char * displayName = getenv("DISPLAY") ;
   
       LSIX_AbrirDisplay(displayName,FALSE) ; 

       w= LSIX_AbrirVentana(resX,resY,title,TRUE,LSIX_LeeMejorVisual()) ;
   
       LSIX_VentanaDeTrabajo(w) ;

       white= LSIX_CreaColorRGB( 0xFF, 0xFF, 0xFF ) ;
   }


  void GetPoint( Scalar & x , Scalar & y )
  {  

      unsigned  mouseAction , 
                xMouse      , 
                yMouse      ;

      do 
         LSIX_EsperaAccionRaton( &mouseAction, &xMouse, &yMouse ) ;
      while ( mouseAction != PULSAR ) ;

      LSIX_Linea( xMouse-5, yMouse,   xMouse+5, yMouse,   white ) ;
      LSIX_Linea( xMouse,   yMouse-5, xMouse,   yMouse+5, white ) ;

      x =  WinToWorldX( xMouse ) ;
      y =  WinToWorldY( yMouse ) ;
  }

  void CloseWin()
  {
      LSIX_VentanaDeTrabajo(w) ;
      LSIX_CerrarVentana() ;
  }


  public:

  void Window
  ( 
      const char * winTitle    , 
      unsigned int iResX = 600 ,
      unsigned int iResY = 600
  )
  :   resX( iResX ) ,
      resY( iResY )
  {
      Init( winTitle ) ;       
  }

  ~Window()
  {
     CloseWin() ;
  }


  void DrawSamples
  (   
      unsigned n ,
      Sample sampleSet[]
  )
  {
      for( int j = 0 ; j < n ; j++ )
      {
         LSIX_FijarPixel( WorldToWinX( sampleSet[j].position[X] ), 
                          WorldToWinY( sampleSet[j].position[Y] ),
                          white
                        ) ;
      }

      LSIX_Sincroniza() ;
  }


  void DisplaySampleSet
  ( 
      const ETriangle &   et ,
      unsigned int        nSamples = 1000
  )
  {

      Sample * sampleSet = new Sample[nSamples] ;

      et.Draw() ;

      et.DrawCircle(1.0, 100) ;

      Vector max = et.GetMax() ;

      cout << et ;

      et.GetSamples( nSamples, sampleSet ) ;

      int maxx = w2sx( max[X] ) ;
      int maxy = w2sy( max[Y] ) ;


      const int W = 30 ;

      LSIX_Linea( maxx-W, maxy, maxx+W, maxy, blanco ) ;
      LSIX_Linea( maxx, maxy-W, maxx, maxy+W, blanco ) ;

      //et.DrawCircle( sqrt(max[X]*max[X]+max[Y]*max[Y]), 1000 ) ;

      DrawSamples( nSamples, sampleSet ) ;   
  }


  ETriangle GetETriangle()
  {
      Vector    vertex[3] ;
      ETriangle ci ;

      LSIX_RellenaRectangulo( 0,0,resx,resy,0 ) ;

      ci.DrawCircle( 1.0, 1000 ) ;
  
      for( int i= 0 ; i < 3 ; i++ )
      {
          Scalar x , y ;
 
          cout << "\xD click in vertex position or outside circle for exit " << flush ;

          WaitClick( x , y ) ;

          Scalar z = 1.0 - x*x - y*y ;

          if ( z < 0 )
          {
             cout << endl ;
             CloseWin() ;
             exit(0) ;
          }       
          else
             vertex[i]= Vector( x, y, sqrt(z) ) ;

      }
   
      return ETriangle( vertex[0], vertex[1], vertex[2] ) ;
  }


  void ViewSubTriangles
  ( 
      const ETriangle & et 
  )
  {  
    
      Scalar x , y ;

      ETriangle * ets = et.GetSubTriangles() ;

      Scalar sumSA= 0.0 ,
             sumFF= 0.0 ;

      for( int i= 0 ; i < 4 ; i++ )
      {
          ets[i].Draw() ;
          cout << endl << "***** sub.tri. number " << i << endl << ets[i] ;

          sumSA += ets[i].GetSolidAngle() ;
          sumFF += ets[i].GetFormFactor() ;
      }
    
      cout << endl << "sum SA = " << sumSA
           << endl << "sum FF = " << sumFF
           << endl << flush ;

      cout << "parent tri == " << et << endl << flush ;
   }


}
