#include <stdlib.h>
#include <math.h>
#include "lsix.h"

//*************************************************************

unsigned int resx = 600 , 
             resy = 600 ;

LSIX_ventana w ;

LSIX_Color  blanco = 255 ;

//*************************************************************

unsigned int w2sx( Scalar x )
{
   return (unsigned int)(0.5*(x+1.0)*(float)(resx)) ;
}

//*************************************************************

unsigned int w2sy( Scalar y )
{
  return resy - (unsigned int)(0.5*(y+1.0)*(float)(resy)) ;
}

//*************************************************************

void init()
{  
   char * displayName = getenv("DISPLAY") ;
   
   LSIX_AbrirDisplay(displayName,FALSE) ; 

   w= LSIX_AbrirVentana(resx,resy,"** ellipsoidal triangles **",TRUE,LSIX_LeeMejorVisual()) ;
   
   LSIX_VentanaDeTrabajo(w) ;

   blanco= LSIX_CreaColorRGB( 0xFF, 0xFF, 0xFF ) ;
   
}

//*************************************************************

void WaitClick( Scalar & x , Scalar & y )
{

   int  mouseAction , 
        xMouse      , 
        yMouse      ;

   do LSIX_EsperaAccionRaton( &mouseAction, &xMouse, &yMouse ) ;
   while ( mouseAction != PULSAR ) ;

   LSIX_Linea( xMouse-5, yMouse,   xMouse+5, yMouse,   blanco ) ;
   LSIX_Linea( xMouse,   yMouse-5, xMouse,   yMouse+5, blanco ) ;

   x=  2.0 * ((Scalar)xMouse/(Scalar)resx - 0.5 );
   y= -2.0 * ((Scalar)yMouse/(Scalar)resy - 0.5 );

}

//**************************************************************

void DrawSamples
(   
   unsigned n ,
   Sample samples[]
)
{
   for( int j = 0 ; j < n ; j++ )
   {
      LSIX_FijarPixel( w2sx( samples[j].position[X] ), 
                       w2sy( samples[j].position[Y] ),
                       blanco
                     ) ;
   }

   LSIX_Sincroniza() ;
   
  

   
}

//***************************************************************

void close_win()
{
  LSIX_VentanaDeTrabajo(w) ;
  LSIX_CerrarVentana() ;

}

//*************************************************************

void view_triangle( const ETriangle & et )
{
#define N 1000

     Sample samples[N] ;

     et.Draw() ;

     et.DrawCircle(1.0, 100) ;

     Vector max = et.GetMax() ;

     cout << et ;

     et.GetSamples(N,samples) ;

     int maxx = w2sx( max[X] ) ;
     int maxy = w2sy( max[Y] ) ;

#define W 30

     LSIX_Linea( maxx-W, maxy, maxx+W, maxy, blanco ) ;
     LSIX_Linea( maxx, maxy-W, maxx, maxy+W, blanco ) ;

     //et.DrawCircle( sqrt(max[X]*max[X]+max[Y]*max[Y]), 1000 ) ;

     DrawSamples(N,samples) ;   


}

//************************************************************

ETriangle get_triangle()
{
   Vector    vertex[3] ;
   ETriangle ci ;

   LSIX_RellenaRectangulo( 0,0,resx,resy,0 ) ;

   ci.DrawCircle( 1.0, 1000 ) ;
  

     for( int i= 0 ; i < 3 ; i++ )
     {
       Scalar x,y ;
 
       cout << "\xD click in vertex position or outside circle for exit " << flush ;
       WaitClick( x,y ) ;

       Scalar z = 1.0 - x*x - y*y ;

       if ( z < 0 )
       {
           cout << endl ;
           close_win() ;
           exit(0) ;
       }       
       else
          vertex[i]= Vector( x,y, sqrt(z) ) ;

     }
   
     return ETriangle( vertex[0], vertex[1], vertex[2] ) ;


}


//*************************************************************

void view_sub_tri( const ETriangle & et )
{
    
     Scalar x , y ;

     ETriangle * ets = et.GetSubTriangles() ;

     Scalar sumSA= 0.0 ,
            sumFF= 0.0 ;

     for( int i= 0 ; i < 4 ; i++ )
     {
        ets[i].Draw() ;
        cout << endl << "***** sub.tri. number " << i << endl << ets[i] ;

        sumSA += ets[i].GetSolidAngle() ;
        sumFF += ets[i].GetFormFactor() ;
     }
    
     cout << endl << "sum SA = " << sumSA
          << endl << "sum FF = " << sumFF
          << endl << flush ;

     cout << "parent tri == " << et << endl << flush ;

 
}


//****************************************

int main( int argc, char *argv[] )
{
  Scalar dummy ;

  init() ;

  try
  {

     ETriangle et4
     ( 
        Vector(0,0,1), 
        Vector(0,1,0), 
        Vector(1,0,0) 
     ) ;

     view_triangle( et4 ) ;
     WaitClick( dummy, dummy ) ;
   
     while(1)
     {
         ETriangle ett = get_triangle() ;
  
         view_triangle( ett ) ;
     //    view_sub_tri( ett ) ;  
         WaitClick( dummy, dummy ) ;      
     }
     
  }
  catch( char * msg )
  {
     cout << endl << "*** exception raised" 
          << endl << "*** msg follows: " << msg 
          << endl << "\0x7" << flush ;
  }

  

  
  
    
}
