#include <stdlib.h>
#include <math.h>
#include <stream.h>

#include "lsix.h"
#include "Vector.H"
#include "DWindow.H"
#include "Demo4.H"

//*****************************************************************

Demo4::Demo4
(
)
{
}

//****************************************************************

void Demo4::Run
(
) const
{
  Scalar dummy ;

#define WW 400

  DWindow win( "epsilon == 0.1 - 0.001", WW, WW, 3 ) ;
         

  Vector v1 = Vector(0.1,1.1,0.3).Normalized() , 
         v2 = Vector(0.9,0.1,0.35).Normalized() , 
         v3 = Vector(-0.5,-0.5,1.0).Normalized() ;

#define NS (30*30)

  try
  {
         ETriangle et( v1,v2,v3, 000.100 ) ;

         win.SetDespX(WW*0) ;
         win.DrawCircle(1.0,200);

         DrawPartition( win, et , 0.3 ) ;

         win.SetDespX(WW*1) ;
         win.DrawCircle(1.0,200) ;

         DrawPartition( win, et, 0.15 ) ;

         win.SetDespX(WW*2) ;
         win.DrawCircle(1.0,200) ;

         DrawPartition( win, et, 0.075 ) ;

         double xx,yy ;
         win.GetPoint( xx, yy ) ;
  }
  catch( char * msg )
  {
     cout << endl << "*** exception raised" 
          << endl << "*** msg follows: " << msg 
          << endl << "\0x7" << flush ;
  }
}

//*********************************************************

void Demo4::DrawPartition
( 
    DWindow &          win,
    const ETriangle &  et, 
    double             K 
)
    const
{
  
    Vector max = et.GetMax() ;

    Scalar k = ((et.GetSolidAngle() * max[Z]) / et.GetFormFactor()) - 1.0 ;

    if ( k < K )
         win.DrawETriangle(et) ;
    else
    {
        
        ETriangle * subt = et.GetSubTriangles() ;

        DrawPartition( win, subt[0], K ) ;
        DrawPartition( win, subt[1], K ) ;
        DrawPartition( win, subt[2], K ) ;
        DrawPartition( win, subt[3], K ) ;

        delete[]  subt ; 
    }
    

}

//*************************************************************
