#include <stdlib.h>
#include <math.h>
#include <stream.h>

#include "lsix.h"
#include "Vector.H"
#include "DWindow.H"
#include "Demo3.H"

//*****************************************************************

Demo3::Demo3
(
)
{
}

//****************************************************************

void Demo3::Run
(
) const
{
  Scalar dummy ;

#define WW 300

  DWindow win( "epsilon = 100 - 0.1 - 0.001", WW, WW, 3 ) ;
         

  Vector v1 = Vector(0.1,1.1,0.2).Normalized() , 
         v2 = Vector(0.9,0.1,0.15).Normalized() , 
         v3 = Vector(-0.5,-0.5,1.0).Normalized() ;

#define NS (30*30)

  try
  {
         ETriangle et1( v1,v2,v3, 100.0000 ) ;
         ETriangle et2( v1,v2,v3, 000.1000 ) ;
         ETriangle et3( v1,v2,v3, 000.001 ) ;

         win.SetDespX(WW*0) ;
         win.GetAndDrawSampleSet( et1 , NS ) ;

         win.SetDespX(WW*1) ;
         win.GetAndDrawSampleSet( et2 , NS ) ;

         win.SetDespX(WW*2) ;
         win.GetAndDrawSampleSet( et3 , NS ) ; 
         
         double xx,yy ;
         win.GetPoint( xx, yy ) ;
  }
  catch( char * msg )
  {
     cout << endl << "*** exception raised" 
          << endl << "*** msg follows: " << msg 
          << endl << "\0x7" << flush ;
  }
}

//*************************************************************
