

#ifndef DEMO2_H_INCLUDED
#define DEMO2_H_INCLUDED

#include "DWindow.H"
#include "PlanarObj.H"


#define iSource     0
#define iOccluder   1
#define iReceiver   2


class Demo2
{

   protected:

      PlanarObject  *  objs[3]   ;
      Triangle *       source    ; // == objs[iSource]
      RectangleSet *   occluder  ; // == objs[iOccluder]

      Boolean  mcGather ;   // true -> MC Gather, false -> full vis. exact gather
      unsigned nSamples ;   // number of samples when 'mcGather == true'
      Scalar   epsilon  ;   // idem,  sent to 'PsaSamplingProc'.

      Vector  camU, camV, camN, camO, camF ;

      Ray GenRay
      ( 
         Scalar  u,
         Scalar  v
      )  const ;

      Scalar GetIntensityAt
      (
         Scalar  u ,
         Scalar  v
      )  const ;

      Scalar Gather
      (
         const Vector & target ,
         unsigned       iObj 
      )  const ;

      Scalar ExactGather
      (
         const Vector & target ,
         unsigned       iObj 
      )  const ;

      Scalar GetIrradiance
      (  
         const Vector & sample ,
         const Vector & sampleNor ,
         const Vector & target 
      )  const ;

      
      void DisplayPerspectiveView
      (  
         unsigned resX ,
         unsigned resY
      )  const ;

      void DisplayTopView
      (  
         unsigned resX ,
         unsigned resY
      )  const ;

 
      Scalar EvalSourceRadiance
      (
         const Vector & sourcePoint
      )  const ;

      Scalar Correct
      (
         Scalar b 
      )  const ;

   public:

      Demo2
      (
         Boolean   iMcGather ,
         unsigned  iNSamples ,
         Scalar    iEpsilon  
      )  ;

      void Run
      (
         unsigned topView 
      ) ;


} ;

#endif DEMO2_H_INCLUDED
