#include <stdlib.h>
#include <math.h>
#include <stream.h>

#include "lsix.h"
#include "Vector.H"
#include "DWindow.H"
#include "Demo1.H"

//*****************************************************************

Demo1::Demo1
(
   Scalar iEpsilon
)
:  epsilon( iEpsilon )
{

}

//****************************************************************

void Demo1::Run
(
) const
{
  Scalar dummy ;

  DWindow win( "Ellipsoidal Triangles Demo", 600, 600 ) ;

  try
  {

     while(1)
     {
         ETriangle ett = win.GetETriangle(epsilon) ;
  
         win.GetAndDrawSampleSet( ett , 2000 ) ;

         // win.DrawSubTriangles( ett ) ;  

         win.GetPoint( dummy, dummy ) ;      
     }
     
  }
  catch( char * msg )
  {
     cout << endl << "*** exception raised" 
          << endl << "*** msg follows: " << msg 
          << endl << "\0x7" << flush ;
  }
}

//*************************************************************
