

#ifndef DWINDOW_H_INCLUDED
#define DWINDOW_H_INCLUDED


#include <stdlib.h>
#include <math.h>
#include "lsix.h"

#include "Vector.H"
#include "ETriangle.H"


class DWindow
{

 protected :  

   unsigned int  resX  , 
                 resY  ,
                 despX,
                 n ;

   LSIX_ventana  w ;

   LSIX_Color    white ;

   unsigned int WorldToWinX
   (   Scalar x 
   )   const ;

   unsigned int WorldToWinY
   (   Scalar y 
   )   const ;

   Scalar WinToWorldX
   (   unsigned int x 
   )   const ;

   Scalar WinToWorldY 
   (   unsigned int y 
   )   const ;

   void Init
   (   const char * title 
   )   ;

   void CloseWin
   ()  const ;


 public:

   DWindow
   (   const char *  winTitle    , 
       unsigned int  iResX = 600 ,
       unsigned int  iResY = 600 ,
       unsigned int  iN    = 1
   )  ;

   ~DWindow
   () ;

   void SetPixelAt
   (    
       unsigned  row ,
       unsigned  col ,
       Scalar    intensity   // between 0 and 1
   )   const ;

   void GetPoint
   (   
       Scalar &  x , 
       Scalar &  y 
   )   const ;


   void DrawSampleSet
   (   
       unsigned  n ,
       Sample    sampleSet[]
   )   ;

   void GetAndDrawSampleSet
   (   
       const ETriangle &  et ,
       unsigned int       nSamples = 1000 
   )   ;

   void SetDespX
   (
       unsigned newDespX
   )   
   {
       despX= newDespX ;
   }

   ETriangle GetETriangle
   (
       Scalar epsilon
   )  ;

   void DrawSubTriangles
   (   
       const ETriangle & et 
   )   ;


   void DrawCircle
   (  
      Scalar   rad,
      unsigned n_segments
   )  const ;


   void DrawEllipseSegment
   (  
      const Vector &  v0           , 
      const Vector &  v1           , 
      unsigned        n_segments  
   )  const ;


   void DrawETriangle
   (  
      const ETriangle & et
   )  const ;

} ;


#endif DWINDOW_H_INCLUDED
