#include <stdlib.h>
#include <math.h>
#include <stream.h>
#include "lsix.h"

#include "Vector.H"
#include "ETriangle.H"
#include "DWindow.H"


//**********************************************************

#define W 0.95

unsigned int DWindow::WorldToWinX
(   Scalar  x 
)   const
{
    return despX + (unsigned int)(0.5*(x*W+1.0)*(float)(resX)) ;
}

//*********************************************************

unsigned int DWindow::WorldToWinY
(   Scalar y 
)   const 
{
    return resY - (unsigned int)(0.5*(y*W+1.0)*(float)(resY)) ;
}

//*********************************************************

Scalar DWindow::WinToWorldX
(   unsigned int x 
)   const 
{
    return  2.0 / W * ((Scalar)x/(Scalar)resX - 0.5 );
}

//********************************************************

Scalar DWindow::WinToWorldY
(   unsigned int y 
)   const 
{
    return  -2.0 / W * ((Scalar)y/(Scalar)resY - 0.5 );
}

//********************************************************

void DWindow::Init
(   const char * title 
)   
{  
    char * displayName = getenv("DISPLAY") ;
   
    LSIX_AbrirDisplay(displayName,FALSE) ; 

    w= LSIX_AbrirVentana(resX*n,resY,title,TRUE,LSIX_LeeMejorVisual()) ;
   
    LSIX_VentanaDeTrabajo(w) ;

    white= LSIX_CreaColorRGB( 0xFF, 0xFF, 0xFF ) ;
}

//******************************************************

void DWindow::SetPixelAt
(    
    unsigned  row ,
    unsigned  col ,
    Scalar    intensity   // between 0 and 1
)   const 
{

    LSIX_VentanaDeTrabajo(w) ;

    Scalar co1 = intensity * ((Scalar)0xFF) ;

    unsigned co = (int) (rint(co1)) ;

    LSIX_Color rgb = LSIX_CreaColorRGB( co, co, co ) ;

    LSIX_FijarPixel( row, col, rgb ) ;
}

//********************************************************

void DWindow::GetPoint
(   Scalar & x , 
    Scalar & y 
)   const
{  

    unsigned  mouseAction , 
              xMouse      , 
              yMouse      ;

    LSIX_VentanaDeTrabajo(w) ;

    do
    { 
       LSIX_EsperaAccionRaton( &mouseAction, &xMouse, &yMouse ) ;
       cout << xMouse << yMouse << endl ;
    }
    while ( mouseAction != PULSAR ) ;

    LSIX_Linea( xMouse-5, yMouse,   xMouse+5, yMouse,   white ) ;
    LSIX_Linea( xMouse,   yMouse-5, xMouse,   yMouse+5, white ) ;

    x =  WinToWorldX( xMouse ) ;
    y =  WinToWorldY( yMouse ) ;
}

//********************************************************

void DWindow::CloseWin
() const
{
    LSIX_VentanaDeTrabajo(w) ;
    LSIX_CerrarVentana() ;
}

//********************************************************

DWindow::DWindow
(   const char *  winTitle       , 
    unsigned int  iResX    = 600 ,
    unsigned int  iResY    = 600 ,
    unsigned int  iN       = 1  
)
:   resX( iResX ) ,
    resY( iResY ) ,
    n(iN) ,
    despX( 0 ) 
{
    Init( winTitle ) ;       
}

//********************************************************

DWindow::~DWindow
()
{
    CloseWin() ;
}

//********************************************************

void DWindow::DrawSampleSet
(   unsigned  n ,
    Sample    sampleSet[]
)
{
    int dx, dy, xp, yp ;

    LSIX_VentanaDeTrabajo(w) ;
 
    for( int j = 0 ; j < n ; j++ )
    {
       xp = WorldToWinX( sampleSet[j].position[X] ) ;
       yp = WorldToWinY( sampleSet[j].position[Y] ) ;

       for( dx = -1 ; dx <= 0 ; dx++ )
       for( dy = -1 ; dy <= 0 ; dy++ )
         LSIX_FijarPixel( xp+dx, yp+dy, white ) ;
    }

    LSIX_Sincroniza() ;
    LSIX_Sincroniza() ;
}

//********************************************************

void DWindow::GetAndDrawSampleSet
(   const ETriangle &   et ,
    unsigned int        nSamples = 1000
)
{

    Sample * sampleSet = new Sample[nSamples] ;

    LSIX_VentanaDeTrabajo(w) ;

    DrawETriangle( et ) ;

    DrawCircle(1.0, 100) ;

    Vector max = et.GetMax() ;

    //cout << et ;

    et.GetSamples( nSamples, sampleSet ) ;

    unsigned maxx = WorldToWinX( max[X] ) ;
    unsigned maxy = WorldToWinY( max[Y] ) ;

    const int WW = 30 ;

    // LSIX_Linea( maxx-WW, maxy, maxx+WW, maxy, white ) ;
    // LSIX_Linea( maxx, maxy-WW, maxx, maxy+WW, white ) ;
    // DrawCircle( sqrt(max[X]*max[X]+max[Y]*max[Y]), 1000 ) ;

    DrawSampleSet( nSamples, sampleSet ) ;   
}

//********************************************************

ETriangle DWindow::GetETriangle
(
   Scalar epsilon 
)
{
     Vector    vertex[3] ;

     LSIX_VentanaDeTrabajo(w) ;

     LSIX_RellenaRectangulo( 0,0,resX,resY, 0 ) ;

     DrawCircle( 1.0, 1000 ) ;
  
     for( int i= 0 ; i < 3 ; i++ )
     {
          Scalar x , y ;
 
          cout << "\xD click in vertex position or outside circle for exit " << flush ;

          GetPoint( x , y ) ;

          Scalar z = 1.0 - x*x - y*y ;

          if ( z < 0 )
          {
             cout << endl ;
             CloseWin() ;
             exit(0) ;
          }       
          else
             vertex[i]= Vector( x, y, sqrt(z) ) ;

     }
   
     return ETriangle( vertex[0], vertex[1], vertex[2], epsilon ) ;
}

//********************************************************

void DWindow::DrawCircle
( 
   Scalar   rad,
   unsigned n_segments
)  const 
{
   Scalar t = 0.0,
          inc_t = (2.0*M_PI)/n_segments ;
   
   Vector vi ;

   unsigned curr_x, curr_y , 
            prev_x, prev_y ,
            i ;

   LSIX_VentanaDeTrabajo(w) ;

   for( i= 0, t= 0.0 ; i < n_segments ; i++ , t += inc_t )
   {
      curr_x = WorldToWinX( rad * cos(t) ) ;
      curr_y = WorldToWinY( rad * sin(t) ) ;         

      if ( i > 0 )
          LSIX_Linea( prev_x, prev_y, curr_x, curr_y, white ) ;

      prev_x= curr_x ;
      prev_y= curr_y ;
   }

   LSIX_Sincroniza() ;

}

//**************************************************

void DWindow::DrawEllipseSegment
( 
   const Vector &  v0 , 
   const Vector &  v1 , 
   unsigned        n_segments 
)  const 
{
   Scalar t = 0.0,
          inc_t = 1.0/n_segments ;
   
   Vector vi ;

   unsigned curr_x, curr_y , 
            prev_x, prev_y ,
            i ;

   for( i= 0, t= 0.0 ; i < n_segments ; i++ , t += inc_t )
   {

      Vector vi = ( (1.0-t) * v0 + t * v1 ).Normalized() ;

      curr_x = WorldToWinX(vi[X]) ;
      curr_y = WorldToWinY(vi[Y]) ;                

      if ( i > 0 )
          LSIX_Linea( prev_x, prev_y, curr_x, curr_y, white ) ;
    
      prev_x= curr_x ;
      prev_y= curr_y ;
   }          

}

//***********************************************************

void DWindow::DrawETriangle
(  const ETriangle & et
)  const 
{
 
  LSIX_VentanaDeTrabajo(w) ;

  DrawEllipseSegment( et[0], et[1], 100 ) ;
  DrawEllipseSegment( et[1], et[2], 100 ) ;
  DrawEllipseSegment( et[2], et[0], 100 ) ;

  LSIX_Sincroniza() ;
}

//********************************************************

void DWindow::DrawSubTriangles
(    const ETriangle & et 
)
{  
    
     Scalar x , y ;

     ETriangle * ets = et.GetSubTriangles() ;

     Scalar sumSA= 0.0 ,
            sumFF= 0.0 ;

     for( int i= 0 ; i < 4 ; i++ )
     {
          DrawETriangle( ets[i] ) ;

          cout << endl << "***** sub.tri. number " << i << endl << ets[i] ;

          sumSA += ets[i].GetSolidAngle() ;
          sumFF += ets[i].GetFormFactor() ;
     }
    
     cout << endl << "sum SA = " << sumSA
          << endl << "sum FF = " << sumFF
          << endl << flush ;

     cout << "parent tri == " << et << endl << flush ;
  
}
