

#ifndef AUX_H_INCLUDED
#define AUX_H_INCLUDED

#include "Vector.H"


typedef unsigned char Boolean ;

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

//*****************************************

class Sample
{
   public:
     Scalar probability ;
     Vector position    ; 
} ;

//***************************************

class LocalRefSys
{
   protected:

    Vector origin   ,
           normal   ,
           tangentU ,
           tangentV ;

   public:
 
     LocalRefSys
     (  
        const Vector & iOrigin ,
        const Vector & iNormal ,
        const Vector & iTangentU ,
        const Vector & iTangentV 
     )  ;    

     Vector WorldToLocal
     (  
        const Vector & vWorld 
     )  const ;

     Vector LocalToWorld
     (  
        const Vector & vLocal 
     )  const ;

     Vector GetOrigin
     (
     )  const 
     {
        return origin ;
     }
} ;

//*****************************************

class Ray
{
   public:

    Vector origin    , 
           direction ;

    Ray
    (
       const Vector & iOrigin ,
       const Vector & iDirection
    )
    :  origin( iOrigin ) ,
       direction( iDirection )  
    {
    }  ;

} ;


#endif AUX_H_INCLUDED
