

#include "Aux.H"

//**********************************************

LocalRefSys::LocalRefSys
(  
   const Vector & iOrigin ,
   const Vector & iNormal ,
   const Vector & iTangentU ,
   const Vector & iTangentV 
)  
:  origin( iOrigin ) ,
   normal( iNormal ) ,
   tangentU( iTangentU ) ,
   tangentV( iTangentV )
{
   
}

//*********************************************

Vector LocalRefSys::WorldToLocal
(  
   const Vector & vWorld 
)  const  
{
   Vector v = vWorld - origin ;
   return 
     Vector( v | tangentU , v | tangentV, v | normal ) ;
}

//**********************************************

Vector LocalRefSys::LocalToWorld
(  
   const Vector & vLocal 
)  const 
{
   return  
     origin + vLocal[X]*tangentU 
            + vLocal[Y]*tangentV
            + vLocal[Z]*normal ;
}

//********************************************




