% Para evitar que el script sea tomado como funcion
1;

clf
clc
clear

spr=5;

% Funcion de la edo
function y = fun(t,x)
  y = (x^2-2*t*x-t^2)/(x^2+2*t*x-t^2);
endfunction

a=0;
b=(1+sqrt(2))/2;

n=1000;
h=(b-a)/n;
taprox(1)=a;
xini=1;

pause(spr)

% Dominios

plot([-1,1],[(-sqrt(2)-1)*(-1),(-sqrt(2)-1)*1],'g')
axis equal
axis([-3 3 -3 3])
hold on
plot([-2,2],[(sqrt(2)-1)*(-2),(sqrt(2)-1)*2],'g')

pause(spr)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%          EULER          %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xaprox1(1)=xini;
for i=1:n
  taprox(i+1)=taprox(i)+h;
  xaprox1(i+1)=xaprox1(i)+h*fun(taprox(i),xaprox1(i));
endfor
xaprox1;

plot(taprox,xaprox1,'r')

pause(spr);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%   HEUN(EULER MEJORADO)  %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xaprox2(1)=xini;
xaux2(1)=1;
for i=1:n
  taprox(i+1)=taprox(i)+h;
  xaux2(i+1)=xaprox2(i)+h*fun(taprox(i),xaprox2(i));
  xaprox2(i+1)=xaprox2(i)+(h/2)*(fun(taprox(i),xaprox2(i))+...
               fun(taprox(i+1),xaux2(i+1)));
endfor
xaprox2;

plot(taprox,xaprox2,'m')

pause(spr);

dif_aprox1_aprox2=sum(abs(xaprox1-xaprox2))/n

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%     EULER MODIFICADO    %%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

xaprox3(1)=xini;
xaux3(1)=1;
for i=1:n
  taprox(i+1)=taprox(i)+h;
  xaux3(i+1)=xaprox3(i)+(h/2)*fun(taprox(i),xaprox3(i));
  xaprox3(i+1)=xaprox3(i)+h*fun(taprox(i)+h/2,xaux3(i+1));
endfor
xaprox3;

plot(taprox,xaprox3,'c')

pause(spr);

dif_aprox1_aprox3=sum(abs(xaprox1-xaprox3))/n
dif_aprox2_aprox3=sum(abs(xaprox2-xaprox3))/n
