%% Vamos a estudiar la conica dada por la expresion
%   3x^2-2xy+3y^2+2x-4y+1=0.

% clf     % Limpiamos la ventana con la salida grafica.
clc     % Limpiamos la pantalla en Ventana de comandos.
clear   % Borramos valores antiguos de las variables.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       PRIMERA PARTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Diagonalizamos A.

A=[3,-1;-1,3];  % Matriz de los terminos cuadraticos.
L=[2,-4];       % Coeficientes de la parte lineal.
TI=1;           % Termino independiente.

% Primero diagonalizamos A para "poner derecha" la conica.

[vector_propio_A, valor_propio_A]=eig(A)
    % eig(A) proporciona dos matrices;
    % las columnas de la primera son vectores propios de A;
    % la segunda es diagonal y formada por los valores propios de A.

u1=vector_propio_A(:,1)   % Primer vector propio.
u2=vector_propio_A(:,2)   % Segundo valor propio.
% u1.'*u2   % Con el producto escalar comprobamos la ortogonalidad.
% u1'.*u2   % Que hace esto?
% u1.*u2'   % Que hace esto?

P=vector_propio_A % Matriz de cambio de B1 a canonicas. 
% OJO! No es un giro.

if abs(det(P)-1)<=10^-15
% Por los errores de redondeo, det(P)=1 no funciona.
  P=P 
  else
  % Cambio de signo en la primera columna para que sea giro.
  P=P*[-1,0;0,1]
  % O intercambiamos las columnas para que sea un giro.
%  P(:,[1 2])=P(:,[2 1])  
endif

P.'*P       % Comprobamos que P es ortogonal.
A1=P.'*A*P  % Nueva matriz de terminos cuadraticos.
L1=L*P      % Nuevos coeficientes de terminos lineales.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       SEGUNDA PARTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pause(2)

% Ahora efectuamos la traslacion para centrar la conica en el origen.
% Asi obtenemos la forma reducida de la conica.

A2=A1;
TI2=TI-(L1(1,1)^2)/(4*A1(1,1))-(L1(1,2)^2)/(4*A1(2,2));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       TERCERA PARTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pause(2)

% Detectamos los elementos notables de la conica "reducida".
% Ya sabemos que la conica es una elipse,
% Lo siguiente es valido para la opcion P=P*[-1,0;0,1]

h1=sqrt(-TI2/A2(1,1));
h2=sqrt(-TI2/A2(2,2));
h3=sqrt(h1^2-h2^2);
Cntr2=[0,0];
Vrtc2xp=[h1,0];
Vrtc2xm=[-h1,0];
Vrtc2yp=[0,h2];
Vrtc2ym=[0,-h2];
Fc2p=[h3,0];
Fc2m=[-h3,0];

% Si hubieramos usado la opcion P(:,[1 2])=P(:,[2 1]), 
% los elementos notables de la elipse serian los siguientes.
%
% h1=sqrt(-TI2/A2(1,1));
% h2=sqrt(-TI2/A2(2,2));
% h3=sqrt(h2^2-h1^2);
% Cntr2=[0,0];
% Vrtc2xp=[h1,0];
% Vrtc2xm=[-h1,0];
% Vrtc2yp=[0,h2];
% Vrtc2ym=[0,-h2];
% Fc2p=[0,h3];
% Fc2m=[0,-h3];

% Pasamos a recuperar los elementos notables en la elipse intermedia.

Paso21x=L1(1,1)/(2*A1(1,1));
Paso21y=L1(1,2)/(2*A1(2,2));
Paso21=[Paso21x,Paso21y];
Cntr1=Cntr2-Paso21;
Vrtc1xp=Vrtc2xp-Paso21;
Vrtc1xm=Vrtc2xm-Paso21;
Vrtc1yp=Vrtc2yp-Paso21;
Vrtc1ym=Vrtc2ym-Paso21;
Fc1p=Fc2p-Paso21;
Fc1m=Fc2m-Paso21;

% Terminamos con los elementos notables de la elipse original.
% Como hemos usado vectores fila tenemos que usar la transposicion.
% Ya que todos los numeros son reales, basta con ' en lugar de .'

Cntr=(P*Cntr1')';
Vrtcxp=(P*Vrtc1xp')';
Vrtcxm=(P*Vrtc1xm')';
Vrtcyp=(P*Vrtc1yp')';
Vrtcym=(P*Vrtc1ym')';
Fcp=(P*Fc1p')';
Fcm=(P*Fc1m')';