%% Vamos a estudiar la conica dada por la expresion
%   3x^2-2xy+3y^2+2x-4y+1=0.

% clf     % Limpiamos la ventana con la salida grafica.
clc     % Limpiamos la pantalla en Ventana de comandos.
clear   % Borramos valores antiguos de las variables.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       PRIMERA PARTE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Diagonalizamos A.

A=[3,-1;-1,3];  % Matriz de los terminos cuadraticos.
L=[2,-4];       % Coeficientes de la parte lineal.
TI=1;           % Termino independiente.

% Primero diagonalizamos A para "poner derecha" la conica.

[vector_propio_A, valor_propio_A]=eig(A)
    % eig(A) proporciona dos matrices;
    % las columnas de la primera son vectores propios de A;
    % la segunda es diagonal y formada por los valores propios de A.

u1=vector_propio_A(:,1)   % Primer vector propio.
u2=vector_propio_A(:,2)   % Segundo valor propio.
% u1.'*u2   % Con el producto escalar comprobamos la ortogonalidad.
% u1'.*u2   % Que hace esto?
% u1.*u2'   % Que hace esto?

P=vector_propio_A % Matriz de cambio de B1 a canonicas. 
% OJO! No es un giro.

if abs(det(P)-1)<=10^-15
% Por los errores de redondeo, det(P)=1 no funciona.
  P=P 
  else
  % Cambio de signo en la primera columna para que sea giro.
  P=P*[-1,0;0,1]
  % O intercambiamos las columnas para que sea un giro.
%  P(:,[1 2])=P(:,[2 1])  
endif

P.'*P       % Comprobamos que P es ortogonal.
A1=P.'*A*P  % Nueva matriz de terminos cuadraticos.
L1=L*P      % Nuevos coeficientes de terminos lineales.