% Pintemos la circunferencia (x-3)^2+(y-5)^2=4 usando una 
% parametrización: (x-3)/2=cos(theta); (y-5)/2=sin(theta)
% Y "jugaremos" a moverla.

esp=2;  % Valor para las pausas.

clf;    % Limpia la pantalla para empazar a pintar graficas.

pause(esp);

z=linspace(-3,2,100);   % Puntos donde se evalua f(x) para pintarla.
hold on     % Para superponer todas las partes en una grafica unica.
xy=[3+2*cos(z);y=5+2*sin(z)];
plot(xy(1,:),xy(2,:))
axis("equal")
axis([-8,12,-8,8])
pause(esp);

% La giramos en torno al origen.

alfa=pi/2;    % Angulo de giro.
P=[cos(alfa), -sin(alfa); sin(alfa), cos(alfa)];
xxyy=P*xy;
plot(xxyy(1,:),xxyy(2,:))
pause(esp);

% La trasladamos.

v=[6;-10];    % vector de traslacion.
xxxyyy=xy+v;
plot(xxxyyy(1,:),xxxyyy(2,:))

hold off    % Si se pinta otra vez, no se conserva lo hecho hasta aqui.