% Pintemos la circunferencia (x-3)^2+(y-5)^2=4 "a mano".

esp=2;  % Valor para las pausas.

clf;    % Limpia la pantalla para empazar a pintar graficas.

function y=f1(x)
  y=5+sqrt(4-(x-3).^2);   % Es esencial "." antes de "^".
endfunction

% Necesitaremos hacer cálculos previos 
% para poder definir el dominio de f(x).

% Parte de arriba.
z=linspace(1,5,100);   % Puntos donde se evalua f(x) para pintarla.
plot(z,f1(z))
axis("equal")
pause(esp);
axis([-2,8,-1,12])

% Parte de abajo.

function y=f2(x)
  y=5-sqrt(4-(x-3).^2);
endfunction

hold on     % Para superponer todas las partes en una grafica unica.
pause(esp);
plot(z,f2(z))
axis([-8,8,-8,8])
pause(2*esp);
hold off    % Si se pinta otra vez, no se conserva lo hecho hasta aqui..

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Pintemos la circunferencia (x-3)^2+(y-5)^2=4 usando una 
% parametrización: (x-3)/2=cos(theta); (y-5)/2=sin(theta)

clf;    % Limpia la pantalla para empazar a pintar graficas.

pause(esp);

z=linspace(-3,2,100);   % Puntos donde se evalua f(x) para pintarla.
x=3+2*cos(z);   % Parametrizacion de x.
y=5+2*sin(z);   % Parametrizacion de y.
plot(x,y)
pause(esp);
axis("equal")
pause(esp);
axis([-8,8,-8,8])