% Pintemos la circunferencia x^2+y^2=1 "a mano".
% Empezamos con la parte de arriba

esp=2;  % Valor para las pausas

clf;    % Limpia la pantalla para empazar a pintar graficas.

function y=f(x)
  y=sqrt(1-x.^2);       % Es esencial "." antes de "^".
endfunction
z=linspace(-1,1,100);   % Puntos donde se evalua f(x) para pintarla.
plot(z,f(z))
pause(esp);

% Añadimos la parte de abajo.

hold on     % Para superponer todas las partes en una grafica unica.
pause(esp);
plot(z,-f(z))
pause(esp);
axis("equal")   % Para que los ejes tengan la misma escala.
pause(esp);
axis([-1.5,1.5,-1.5,1.5])   % Para especificar los ejes.
hold off    % Si se pinta otra vez, no se conserva lo hecho hasta aqui.