% Pintemos algunas graficas

esp=2;  % Valor para las pausas

clf;    % Limpia la pantalla para empazar a pintar graficas.
pause(esp);   % Vamos a esperar "esp" segundos (mas o menos).

fplot('sin(x)',[0,pi]);   % Pinta el seno entre 0 y pi.

disp("espera por favor ...");   % Indica que esperemos.
pause(esp);
clf;    % Limpia la pantalla para pintar otra grafica.
pause(esp); % Esperamos "esp" segundos antes de pintar otra vez.               

fplot('cos(x)',[0,pi]);   % Pinta el coseno entre 0 y pi.
pause(esp);
clf;

% Pintemos otra grafica, pero "a mano".

function y=f(x)
  y=1./(1+25*x.^2);
endfunction
z=linspace(-1,1,100);   % Puntos donde se evalua f(x) para pintarla.
plot(z,f(z))
pause(esp);
clf;

% Veamos como representar la grafica de una funcion a trozos sin
% emplear argumentos vectoriales.

function y=f(x)   % Funcion a representar.
  if x>2
    y=x.^2+2;
  else
    y=x.^3-2;
  endif
endfunction
function y=g(x)   % Funcion auxiliar para pintar el eje de abscisas.
  y=0;
endfunction
z=linspace(-2,4,100);
for i=1:length(z)
  fz(i)=f(z(i));
  gz(i)=g(z(i));
endfor
plot(z,fz)
hold on   % Para superponer todas las partes en una grafica unica.
pause(esp);
plot(z,gz)
hold off  % Si se pinta otra vez, no se conserva lo hecho hasta aqui.