% En este script vamos a ver como funciona la funcion gaussseidel
% Para que este script funcione necesitamos que gaussseidel.m este en la misma
% carpeta

clc     % limpiamos la pantalla en Ventana de comandos
clear   % borramos valores antiguos de las variables

M=[4,-1,1;1,3,-1;1,1,-7];   % matriz de coeficientes del sistema
c=[5;6;-9+i];   % vector de terminos independientes por columnas
d=[5,6,-9+i];   % vector de terminos independientes por filas
aprox=[0;0;0];  % aproximacion inicial

% Ensayo 0
gauss_seidel(M,c,aprox)
                % como c esta dado por columnas, funciona todo bien
                % solo vemos la solucion aproximada

% Ensayo 1
[sol1,num_iterac1]=gauss_seidel(M,c,aprox)    
                % como c esta dado por columnas, funciona todo bien
                % vemos las solucion aproximada y el numero de iteraciones

% Ensayo 2
[sol2,num_iterac2]=gauss_seidel(M,d',aprox)   
                % como d esta dado por filas hay que trasponerlo
                % pero d' traspone y conjuga (o sea, cambia de signo
                % la parte imaginaria en los numeros complejos);
                % si las componentes de d fueran todas reales,
                % entonces no hay problemas al usar d'
                          
% Ensayo 3
[sol3,num_iterac3]=gauss_seidel(M,d.',aprox) 
                % d.' traspone pero no conjuga, todo funciona bien

% como c y d tienen una componente compleja, comprobamos que en el primer y
% tercer ensayos la solucion es la misma (pues d.' solo es trasponer);
% sin embargo, en el segundo ensayo, todos los signos de las parte complejas
% estan cambiados pues d' (sin el punto) implica trasponer y conjugar.