% En este script vamos a ortogonalizar un conjunto de vectores mediante el
% metodo de Gram-Schmidt

clc     % limpiamos la pantalla en Ventana de comandos
clear   % borramos valores antiguos de las variables

v=[1,2,3; 2,1,0; 1,0,1];  % conjunto de vectores, por filas, 
                          % que queremos ortogonalizar
               
n=length(v);  % length devuelve el valor mayor entre numero de filas
              % y  de columnas;
              % cuando v es cuadrada basta con n para que todo funcione 
              
[f,c]=size(v);  % size devuelve el numero de filas y columnas de una matriz
                % cuando no sepamos seguro si v es cuadrada, mejor trabajar con
                % los valores f, c
                
u=zeros(f,c);   % matriz inicial, con f filas y c columnas, formada por ceros;
                % en las filas de la matriz u iremos guardando los vectores 
                % ortogonales conforme se vayan calculando

for i=1:f
  u(i,:) = v(i,:);
  for j=1:i-1
    u(i,:)=u(i,:)-((v(i,:)*u(j,:)')/(u(j,:)*u(j,:)'))*u(j,:);   
                % calculo de los vectores ortogonales a partir de la 
                % formula vista en teoria
  endfor
endfor

for i=1:f
  u(i,:)        % para ver el conjunto de vectores ortogonales se muestran
                % todas y cada una de las filas de matriz u
endfor