% Partiendo de la implementación del método de Gauss-Seidel, vamos a realizar la
% implementación del método de Jacobi.
% Puede resultar curioso, pero es más simple programar Gauss-Seidel que Jacobi.
% (Al menos, esa es mi impresión)

% Todos los comentarios que se vieron en Archivo3_2_Gauss_Seidel_v2.m siguen
% siendo válidos en este script.

clc         
clear   

A=[4,-1,1;1,3,-1;1,1,-7];   % matriz de coeficientes
v=[5;6;-9];   % vector de términos independientes

x=0;    % Estas son las variables principales y las que tomamos como
y=0;    % aproximaciones de las soluciones exactas.
z=0;

xx=1;   % En estas variables auxiliares tomamos valores bastante diferentes de
yy=1;   % los valores de las variables principales
zz=1;

k=0;  % para contar iteraciones

while (abs(xx-x)+abs(yy-y)+abs(zz-z)>10^-15) && (k<1000) % abs = valor absoluto
  k=k+1;
  xx=x;
  yy=y;
  zz=z;
  x=(5+yy-zz)/4;
  y=(6-xx+zz)/3;
  z=(9+xx+yy)/7;
endwhile

format long   % para que veamos mechos decimales

printf('iteracion k = %i \n', k);
[x;y;z]   % vector aproximación de la solución buscada

% Como se puede comprobar, con Jacobi la solución aproximada se obtiene haciendo
% más iteraciones que con Gauss-Seidel.