% Sabemos que estamos implementando el método de Gauss-Seidel.
% Parece que no es muy adecuado hacer muchas iteraciones y ver que va saliendo.
% Por ello vamos a ver si es posible parar cuando dos iteraciones sucesivas dan
% resultados muy parecidos. En tal caso, es de esperar que dichos valores
% correspondan a una buena aproximacion de la solución buscada.

% Para poder comparar dos iteraciones sucesivas necesitamos definir variables
% auxiliares (que llamaremos xx, yy, zz).

% Muy importante: por si cometemos algun error en la implementación, vamos a
% imponer un número máximo de iteraciones.

clc   % Para que se limpie la "Ventana de comandos" cada vez que ejecutemos este
      % script y saber exactamente cuál es la salida obtenida.
      
clear   % Para que se limpien las variables cada vez que ejecutemos este scrpit,
        % por si quedan valores residuales.
        
A=[4,-1,1;1,3,-1;1,1,-7];   % matriz de coeficientes
v=[5;6;-9];   % vector de términos independientes

x=0;    % Estas son las variables principales y las que tomamos como
y=0;    % aproximaciones de las soluciones exactas.
z=0;

xx=1;   % En estas variables auxiliares tomamos valores bastante diferentes de
yy=1;   % los valores de las variables principales
zz=1;

k=0;  % para contar iteraciones

% Vamos a usar un bucle tipo "while" con dos condiciones.
% Como primera condición exigimos que la suma (de los valores absolutos de la 
% diferencia entre dos iteraciones sucesivas de cada incognita) no sea "grande".
% Como segunda condición, el número de iteraciones no debe ser superior a 1000.
% Ambas condiciones deben cumplirse para que se realize una nueva iteración, por
% lo que se introduce el operador &&.

while (abs(xx-x)+abs(yy-y)+abs(zz-z)>10^-15) && (k<1000) % abs = valor absoluto
  k=k+1;  % También se puede usar k++
  xx=x;
  yy=y;
  zz=z;
  x=(5+y-z)/4;
  y=(6-x+z)/3;
  z=(9+x+y)/7;
endwhile

format long   % para que veamos muchos decimales

printf('iteracion k = %i \n', k);
[x;y;z]   % vector aproximación de la solución buscada

% ¿Qué habría que retocar para tener el método de Jacobi?
% Pista: en los cálculos de cada iteración hay que conservar el valor antiguo de
% "x" para las cuentas de "y" y "z", y también conservar el valor antiguo de "y"
% para la cuenta de "z". ¿Habrá que usar nuevas variables auxiliares?