% Ahora vamos con métodos iterativos para resolver sistemas.

A=[4,-1,1;1,3,-1;1,1,-7];   % matriz de coeficientes
v=[5;6;-9];   % vector de términos independientes

x=0;
y=0;
z=0;

for i=1:5
  x=(5+y-z)/4;
  y=(6-x+z)/3;
  z=(9+x+y)/7;  
endfor

format long   % para que veamos muchos decimales

[x;y;z]   % vector aproximación de la solucion buscada

% ¿Qué método se ha usado: Jacobi o Gauss-Seidel?
% Viendo los valores de la primera iteración, comprobamos que es Gauss-Seidel:
% en cada iteración, una vez calculado "x" ya se usa para "y" y "z"; y una vez
% calculado "y" ya se usa para "z".

% Curiosamente, es más fácil programar Gauss-Seidel que Jacobi.