% Vamos a resolver el sistema Ax=b, siendo A regular, 
% mediante Gauss con pivote parcial.

clc   % Para que se limpie la "Ventana de comandos" cada vez que ejecutemos este
      % script y saber exactamente cuál es la salida obtenida.
      
clear   % Para que se limpien las variables cada vez que ejecutemos este scrpit,
        % por si quedan valores residuales.

A = [1 -2 1; 1 1 2; 2 1 2];
b = [0; 4 ; 5];
  
[fil,col] = size(b);  % fil es el núemro de filas de b;
                      % col es el número de columnas de b; 
Ab = [A b];

for j = 1:fil-1
  % Pivoteo parcial dentro de la columna j
  [piv,pos] = max(abs(Ab(j:fil,j)));
  Ab([j,j+pos-1],:) = Ab([j+pos-1,j],:);
  % Anulación de los elementos bajo el pivote
  for i = j+1:fil
    Ab(i,j:fil+col) = Ab(i,j:fil+col) - Ab(i,j)*Ab(j,j:fil+col)/Ab(j,j);
  endfor
endfor
  
% Resolvemos por sustitución regresiva
x = sustregr(Ab(1:fil,1:fil),Ab(1:fil,fil+1:fil+col));

% Damos la solución
x

