package es.ugr.ligaduras;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Style;
import android.graphics.Path;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;

public class Ligaduras extends Activity implements OnClickListener{
	
	boolean continuar=true;
	float velocidad=0.1f;
	float aceleracion=0.001f;
	float energia;
	int dt=1;
	int tiempo=0;
	Thread hilo=null;
	DinamicaView dinamica;
	Trayectoria trayectoria=new Trayectoria(100,100);
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
        dinamica=new DinamicaView(this);                
        setContentView(dinamica);
        dinamica.setOnClickListener(this);
        
        hilo = new Thread(dinamica);
        hilo.start();        
    }
    
    // detenemos el hilo si pausa
    @Override
    public void onPause(){
    	super.onPause();
    	continuar=false;
    }

    // reiniciamos el hilo si resume
    @Override
    public void onResume(){
    	super.onResume();
    	continuar=true;
    	if(hilo==null){
    		hilo=new Thread(dinamica);
    		hilo.start();
    	}
    }

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		continuar=!continuar;
    	if(continuar| hilo==null){
    		hilo=new Thread(dinamica);
    		hilo.start();
    	}
	}      

	class DinamicaView extends View implements Runnable{

    	int x,y,xmin,ymin,ymax;  // coordenadas
    	float tangenteX,tangenteY;
    	float tx,ty;
    	Paint paintFondo,paintParticula,paint,paintCurva,paintVector;
    	Path path;
    	String control;
    	boolean cambio=true;
    	
    	public DinamicaView(Context context) {
			super(context);
			// Colores para el dibujo y tamaño del texto
			paintFondo=new Paint();
			paintParticula=new Paint();
			paint=new Paint();
			paintFondo.setColor(Color.WHITE);
			paintParticula.setColor(Color.RED);
			paint.setColor(Color.BLACK);
			paint.setTextSize(18);
			paintCurva=new Paint();
			paintCurva.setStyle(Style.STROKE);
			paintVector=new Paint();
			paintVector.setStrokeWidth(8);
			paintVector.setColor(Color.BLACK);			
    	}

		// obtiene geometria del canvas
		@Override
		protected void onSizeChanged(int w, int h, int oldw,int oldh){
			x=w/2;
			xmin=0;
			y=0;
			ymax=h-xmin;

			float anchura=w;
			float altura=h;
			trayectoria=new Trayectoria(anchura,altura);
			ymin=(int) trayectoria.getY(xmin);
			energia=0.5f * velocidad * velocidad - aceleracion * ymin;
			control="anchura:"+anchura+" altura:"+altura;
			// construye el path de la trayectoria
			path=new Path();
			path.moveTo(xmin,ymin);
			for (int i=xmin; i<anchura-xmin;i++){
				float xi=i;
				float yi=trayectoria.getY(xi);
				path.lineTo(xi,yi);
			}
		}
    	
		@Override
		public void run() {

			while(continuar){				
				cambiaPosicion3();
				postInvalidate();
				try { Thread.sleep( dt ); } 
				catch ( InterruptedException e ){ ; }	
			}    	
		}
 	
		public void cambiaPosicion3() {

				float[] tangente={0,0};
				tiempo=tiempo+dt;
				tangente=trayectoria.getTangente(x);
				float tangenteX=tangente[0];
				float tangenteY=tangente[1];
				tx=tangenteX*velocidad;
				ty=tangenteY*velocidad;
				float aT=aceleracion*tangenteY;
				velocidad=velocidad+aT*dt;
				float cinetica=velocidad*velocidad/2;
				float yfloat=((cinetica-energia)/aceleracion);
				y=(int) yfloat;
				if(y>=ymax) {
					x=(int) (x+Math.signum(velocidad)*dt);
					y=(int) trayectoria.getY(x);                
					cambio=!cambio;
				} 

				if (cambio) x=(int) trayectoria.getX2(y);
				else x=(int) trayectoria.getX1(y);
				// si llega arriba invertimos velocidad
				if(y<ymin)velocidad=-velocidad;					
		}    	
		
		@Override
		public void onDraw(Canvas canvas ){			
			canvas.drawPaint(paintFondo);
			canvas.drawCircle(x, y, 30, paintParticula);
			canvas.drawText("x="+x+" y="+y, 50, 50, paint);
			canvas.drawText("t="+tiempo, 50, 90, paint);
			canvas.drawText("v="+velocidad, 50, 130, paint);
			canvas.restore();
			canvas.drawPath(path,paintCurva);
			canvas.drawText("Componentes de la velocidad",50,170,paint);
			float e=100; // escala para vector
     		canvas.drawLine(x,y, x+e*tx,y+e*ty,paintVector);
     		canvas.drawText("V",x+e*tx+20,y+e*ty-20,paint);
     		canvas.drawText("VX="+tx, 50,200, paint);
     		canvas.drawText("VY="+ty, 50,230, paint);	
		}	
    }   // fin dinamica


//  clase parara la trayectoria de una particula
	class Trayectoria{

		float yMax,x0;
		Trayectoria(float anchura, float altura){
			yMax=altura;
			x0=anchura/2;
		}

		float getY(float x){
			float xx0=(x-x0)/x0;
			float y=yMax*(1-xx0*xx0);
			return y;
		}

		// raiz positiva de la funcion inversa
		float getX1(float y){
			double raiz,radicando;
			radicando=Math.max(0f,1-y/yMax);
			raiz=Math.sqrt(radicando);
			float x1=(float) (x0+x0*raiz);
			return x1;
		}
		// raiz negativa de la funcion inversa
		float getX2(float y){
			double raiz,radicando;
			radicando=Math.max(0f,1-y/yMax);
			raiz=Math.sqrt(radicando);
			float x2=(float) (x0-x0*raiz);
			return x2;
		}
		
		// componente y del vector unitario tangente a la curva
		float[] getTangente(float x){
			float[] tangente=new float[2];
			float xx0=(x-x0)/x0;
			float derivada=-yMax*2*xx0/x0;			
			double denominador=Math.sqrt(1+derivada*derivada);
			tangente[0]=(float) (1/denominador);
			tangente[1]=(float) (derivada/denominador);
			return tangente;		
			
		}		
	}
    
}
