package es.ugr.amaro.notificaciones;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

public class Notificaciones extends Activity {

	
	boolean continuar=true;
	int retraso=100;
	int contador=0;
	// variables para la notificacion
	NotificationManager manager;
	Notification notificacion;
	CharSequence notificacionTitle = "Hilo funcionando";
	CharSequence notificacionText = "";
	Context context;
	Intent notificacionIntent;
	PendingIntent pendingIntent;
	
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        // referencia al manager de notificaciones
    	String servicio=Context.NOTIFICATION_SERVICE;
    	manager= (NotificationManager) getSystemService(servicio);

    	// crea la notificacion
    	int icon=R.drawable.icon;
    	String texto="ejecutando";
    	long cuando=System.currentTimeMillis();
    	notificacion=new Notification(icon,texto,cuando);

    	// define el intent de la notificacion expandida
    	context = getApplicationContext();
    	notificacionIntent = new Intent(this, Notificaciones.class);
    	pendingIntent = PendingIntent.getActivity(this, 0, notificacionIntent, 0);
    	    	
    	// inicia un nuevo hilo
        Contar contar=new Contar();                
        Thread hilo = new Thread(contar);
        hilo.start();        
    }
    
    // clase para ejecutar un hilo que manda una notificación
    class Contar implements Runnable{

		public void run() {

			while(continuar){
				try { Thread.sleep( retraso ); } 
				catch ( InterruptedException e ){ ; }					
				contador++;
				//texto de la notificacion expandida
				notificacionText="contador="+contador;
				//actualiza la notificacion
				notificacion.setLatestEventInfo(
		    			context, notificacionTitle, notificacionText, pendingIntent);
				// comunica la notificacion al manager
				int ref=1;
		    	manager.notify(ref,notificacion);    	
		    	manager.notify(2,notificacion);    	
			}
		}    	

    } 
  
}