package es.ugr.amaro.handroica;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class PhaseShift extends Activity {
	
		public static final String spinExtra="spin";

		SharedPreferences misDatos;
		final int ndeltas=2; // number of deltas
		final int nparametros=2*ndeltas;
		int spin;
		double[] energy=new double[400];
		double[][] dat=new double[400][5];
		double[] energyExp ={1,3,5,10,20,30,40,50,70,100,150,200,250,300,350};
		int nDatos,nDatosExp;
		double[] expdat=new double[20];
		double[] expdatError= new double[20];
		double[] deltaDeg=new double[20];
		Plot plot;
		String texto,texto1;
		String texto2="Step";
		String texto3="COMPUTING...";
		double lambda[][]=new double[2][ndeltas];
		double Rdelta[][]=new double[2][ndeltas]; 
		double Emax;
		boolean continuar=true;
		Thread hilo;
		
		double[] xvar = new double[2*ndeltas];//variables to minimize
		double tolerancia,resolucion;
		
	@Override
	public void onCreate(Bundle savedInstanceState){
		super.onCreate(savedInstanceState);

		// spin passed  as extra parameter
		spin=getIntent().getIntExtra(spinExtra, 0);
		leerPreferencias();
		leerDatos();
		plot=new Plot(this);
		setContentView(plot);
		hilo=new Thread(plot);
		hilo.start();
	}
	
	class Plot extends View implements Runnable{

		int width,height;
		Paint paint1,paint2,pain3,paint,paintRun;
		Path path1;
		int topMargin=30;
		int margin=30;
		int x0,x1,y0,y1,x,y;
		double e0,e1,d0,d1;
		
		public Plot(Context context) {
			super(context);
			// TODO Auto-generated constructor stub
			paint=new Paint();
			paint.setColor(Color.BLACK);
			paint.setTextSize(16);
			paintRun=new Paint();
			paintRun.setColor(Color.RED);
			paintRun.setTextSize(20);
			paint1=new Paint();
			paint1.setColor(Color.BLACK);
			paint1.setStyle(Paint.Style.STROKE);
			paint1.setStrokeWidth(1);
			paint2=new Paint();
			paint2.setColor(Color.RED);
			paint2.setStyle(Paint.Style.STROKE);			
			paint2.setStrokeWidth(3);
			path1=new Path(); 

			e0=0;
			e1=350;
			d0=-20;
			d1=180;
		}
		
		@Override
		protected void onSizeChanged(int w, int h, int oldw, int oldh){
			width=w;
			height=h;
			x0=margin;
			x1=width-margin;
			y0=height/2;
			y1=topMargin;
		}
		@Override
		protected void onDraw (Canvas canvas){
			canvas.drawColor(Color.WHITE);
			texto="Neutron-Proton Phaseshift. SPIN="+spin;
			canvas.drawText(texto,20,20,paint);
			canvas.drawRect(x0,y0,x1,y1,paint1);

			canvas.drawText(texto1,width/2-30,topMargin+20,paint);
			canvas.drawText(texto2,width/2-30,topMargin+40,paint);
			canvas.drawText(texto3,width/2-30,topMargin+65, paintRun);
			
			x=coX(energy[0]);
			y=coY(dat[0][0]);
			path1.moveTo(x,y);
			for(int ie=1;ie<nDatos;ie++){
				x=coX(energy[ie]);
				y=coY(dat[ie][0]);
				path1.lineTo(x,y);
			}
			canvas.drawPath(path1,paint2);

			// draw experimental points
			for (int i=0;i< nDatosExp;i++){
				x=coX(energyExp[i]);
				y=coY(expdat[i]);
				int y1=coY(expdat[i]-expdatError[i]);
				int y2=coY(expdat[i]+expdatError[i]);
			canvas.drawCircle(x, y, 5 , paint);
			canvas.drawLine(x,y1,x,y2, paint);
			// draw fitted points
			y=coY(deltaDeg[i]);
			canvas.drawCircle(x,y,5,paint2);
			}
			
			// x axis ticks
			for (int i=0; i<7;i++){
				canvas.drawLine(coX(50*i),coY(d0),coX(50*i),coY(d0+5),paint1);
				canvas.drawText(""+50*i,coX(50*i),coY(d0)+20, paint);
			}
			//  y axis ticks
			for (int i=0;i<18;i++){
				canvas.drawLine(coX(0),coY(10*i),coX(0+5),coY(10*i), paint1);
				canvas.drawText(""+10*i,0,coY(10*i), paint);
			}
			// draw x=0 line
			canvas.drawLine(coX(0),coY(0),coX(350),coY(0),paint1);

			// write down parameters of potential
			texto="R"+spin+"0 ="+xvar[2];		
			canvas.drawText(texto, 20, y0+40, paint);
			texto="La"+spin+"0 ="+xvar[0];		
			canvas.drawText(texto, 20, y0+60, paint);
			texto="R"+spin+"1 ="+xvar[3];		
			canvas.drawText(texto, 20, y0+80, paint);
			texto="La"+spin+"1 ="+xvar[1];		
			canvas.drawText(texto, 20, y0+100, paint);

			canvas.drawText("Emax="+Emax, 20, y0+120, paint);

			int ii=2;
			// write on screen experimental points
			texto="ndatosExp="+nDatosExp;
			canvas.drawText(texto,width/2+10,y0+20*ii,paint);
			for (int i=0;i<nDatosExp;i++){
				ii++;
				texto="/"+energyExp[i]+"/"+expdat[i]+"/"+expdatError[i];
				canvas.drawText(texto,width/2+10,y0+20*ii,paint);
			}			
		}

		int coX(double e){
			double xdouble=x0+(x1-x0)*(e-e0)/(e1-e0);			
			return (int) xdouble;
		}
		int coY(double d){
			double ddouble=y0+(y1-y0)*(d-d0)/(d1-d0);			
			return (int) ddouble;
		}

		@Override
		public void run() {
			// Start searching minimum with initial step paso
			// Comienza buscando el minimo con paso inicial
			double paso=0.5;
			int dt=200;

			while(continuar){
				texto2="Step="+paso;
				minimiza(paso);
				paso=paso/2.0;
				postInvalidate();
				try{ Thread.sleep(dt);}
				catch(InterruptedException e){;}
				if(paso/2.<resolucion)continuar=false;								
			}
			texto3="MINIMUM FOUND!";
			postInvalidate();
		}		
	}
	
	void leerDatos(){

		int numeroFichero=R.raw.phase1s0;
		if(spin==1) numeroFichero=R.raw.phase3s1;
		InputStream input1=getResources().openRawResource(numeroFichero);
		InputStreamReader stream1=new InputStreamReader(input1);
		BufferedReader buffer1=new BufferedReader(stream1,8192);

		int iLinea=0;
		int iDato=0;
		try{
			String linea;
			while(true){
				linea=buffer1.readLine();
				if(linea==null)break;
				iLinea++;
				if(iLinea>4){
					StringTokenizer tokens = new StringTokenizer(linea);
					energy[iDato]=Double.parseDouble(tokens.nextToken());
					//read file columns with several phaseshift calculations
					// lee cinco columnas con varios calculos de desfasajes 
					for (int j=0; j<5; j++){
					dat[iDato][j]=Double.parseDouble(tokens.nextToken());
					}
					iDato++;
				}
			}
			input1.close();
			stream1.close();
			buffer1.close();
		}catch(Exception e){
			texto="\n"+e;
		}
		nDatos=iDato;
		texto=texto+"Datos: "+nDatos;

		// construct experimental points
		nDatosExp=0;
		for (int i=0;energyExp[i]<=Emax;i++){

			for (int j=0; j<nDatos; j++){
				double diff=energyExp[i]-energy[j];
				if (Math.abs(diff)<0.01){
					double datMin=dat[j][0];
					double datMax=datMin;
					for(int k=1;k<5;k++){
						double dato=dat[j][k];
						if (datMax < dato)datMax=dato;
						if(datMin > dato)datMin=dato;
					}
					expdat[i]=(datMax+datMin)/2.0;
					expdatError[i]=(datMax-datMin)/2.0;
					// tolerance
					if(expdatError[i]<tolerancia)expdatError[i]=tolerancia;
					nDatosExp++;
				}
			}			
		}		
	}

	
	void leerPreferencias(){
        // Reads lambad00 in the file of preferences
        misDatos=getSharedPreferences("preferencias",0);
        lambda[0][0]=misDatos.getFloat("lambda00",0);
        lambda[0][1]=misDatos.getFloat("lambda01",0);
        lambda[1][0]=misDatos.getFloat("lambda10",0);
        lambda[1][1]=misDatos.getFloat("lambda11",0);

        Rdelta[0][0]=misDatos.getFloat("R00",0);
        Rdelta[0][1]=misDatos.getFloat("R01",0);
        Rdelta[1][0]=misDatos.getFloat("R10",0);
        Rdelta[1][1]=misDatos.getFloat("R11",0);

        Emax=misDatos.getFloat("Emax",0);
        tolerancia=misDatos.getFloat("tolerancia",0);
        resolucion=misDatos.getFloat("resolucion",0);

        // initial variables iniciales to minimize
    	xvar[0]=lambda[spin][0];
    	xvar[1]=lambda[spin][1];
        xvar[2]=Rdelta[spin][0];
        xvar[3]=Rdelta[spin][1];        	
	}
	
	double minimiza(double paso){
		
		int dimension= nparametros;
		double[] xmas=new double[dimension];
		double[] xmenos=new double[dimension];
		double[] x=new double[dimension];
		                      
		for (int i=0;i<dimension;i++)x[i]=xvar[i];                      
		double minimo=chiCuadro(x);
		double oldmin=minimo;		
		boolean esMinimo=false;
		
		while (!esMinimo){
			
		for (int i=0;i<dimension;i++){
			// points shifted in the  +-i direction
			for(int j=0;j<dimension;j++){
				double kroneker=0;
				if (i==j)kroneker=1;
				xmas[j]=x[j]+paso*kroneker;
				xmenos[j]=x[j]-paso*kroneker;
			}	
			// if R1 < R0 we don't move on
			if(i==2 & xmas[3]<xmas[2]) xmas[2]=x[2];
			if(i==3 & xmenos[3]<xmenos[2])xmenos[3]=x[3];
			// check R0 > 0, R1 > 0
			if(i==2 & xmenos[2]<0.0) xmenos[2]=x[2];
			if(i==3 & xmenos[3]<0.0) xmenos[3]=x[3];
			
			double valuemas=chiCuadro(xmas);
			if(valuemas<minimo){
				minimo=valuemas;
				for (int j=0;j<dimension;j++)xvar[j]=xmas[j];
			}

			double valuemenos=chiCuadro(xmenos);
			if(valuemenos<minimo){
				minimo=valuemenos;
				for (int j=0;j<dimension;j++)xvar[j]=xmenos[j];
			}
			texto1="Minimum="+minimo;	
		}
		// if the point doesn't changes IS THE MINIMUM
		if(minimo==oldmin) esMinimo=true;
		else {
			oldmin=minimo;
			for(int i=0;i<dimension;i++){x[i]=xvar[i];}
		}
		}
		return minimo;
		}
		
	
	double chiCuadro(double[] parametros){
		double valor=0;

		for (int i=0;i<nDatosExp;i++){
			double Elab=energyExp[i];	
			deltaDeg[i]= desfasaje(Elab,parametros);
			double sumando= (deltaDeg[i]-expdat[i] )/expdatError[i];
			valor=valor + sumando*sumando;		
		}	
		return valor/nDatosExp;
	}

	// Compute phaseshift in S-wave. Delta-shell potential
	double desfasaje(double Elab, double[] parametros){

		double delta=0;
		double Erel=Elab/2;
		double muc2=939.0/2.0;
		double hbarc=197.32;
		double hbarc2=hbarc*hbarc;
		double twoMuH2=2.0*muc2/hbarc2;
		double epsilon=twoMuH2*Erel;
		double k=Math.sqrt(epsilon);

		for (int i=0;i<ndeltas;i++){

			double kr=k*parametros[i+ndeltas];
			// lamda is divided by 2mu 
			double alfak=parametros[i]/k;
			double ctan=1.0/Math.tan(kr+delta);
			double denominator=ctan+alfak;
			double unotan=1.0/denominator;
			delta=Math.atan(unotan)-kr;	

		}	
			// check delta is between -pi,pi for J=0
			if(spin==0){
			if (delta<=-Math.PI/2){
				while(delta<-Math.PI/2)delta=delta+Math.PI;
			}
			if(delta>Math.PI/2){
				while(delta>Math.PI/2)delta=delta-Math.PI*2;
			}
			}

			// check delta is between 0,pi for J=1
			if(spin==1){
			if (delta<0){
				while(delta<0)delta=delta+Math.PI;
			}
			if(delta>Math.PI){
				while(delta>Math.PI)delta=delta-Math.PI*2;
			}
			}
			
		double deltaDeg=delta*180/Math.PI;		
		return deltaDeg;
	}


    @Override
    protected void onPause(){
    	super.onPause();
    	// stop the thread
    	continuar=false;
    	if(hilo.isAlive()) hilo.stop();
    	
    	// store data
    	SharedPreferences.Editor miEditor=misDatos.edit();
    	lambda[spin][0]=xvar[0];
    	lambda[spin][1]=xvar[1];
    	Rdelta[spin][0]=xvar[2];
    	Rdelta[spin][1]=xvar[3];
    	
    	miEditor.putFloat("lambda00",(float) format(lambda[0][0],6));
    	miEditor.putFloat("lambda01",(float) format(lambda[0][1],6));
    	miEditor.putFloat("lambda10",(float) format(lambda[1][0],6));
    	miEditor.putFloat("lambda11",(float) format(lambda[1][1],6));	
    	miEditor.putFloat("R00",(float) format(Rdelta[0][0],6));
    	miEditor.putFloat("R01",(float) format(Rdelta[0][1],6));
    	miEditor.putFloat("R10",(float) format(Rdelta[1][0],6));
    	miEditor.putFloat("R11",(float) format(Rdelta[1][1],6));
    	
    	miEditor.commit();
    	Toast.makeText(this,"Data stored",1).show();
    }
    
    // format a number with several digits
    float format(double x, int cifras){
		String cadena=""+x;
		if (cadena.length()<=cifras)return Float.parseFloat(cadena);
		if(x<0) cifras=cifras+1;
		float y=Float.parseFloat(cadena.substring(0,cifras));
		return y;
	}
}