package es.ugr.amaro.handroica;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Bundle;
import android.view.View;

public class He4 extends Activity{
	
	double lambda[][]=new double[2][2];// potencial strength parameters
	double Rdelta[][]=new double[2][2]; // centers of delta functions
	Thread hilo;
	double bmin,emin;
	double cinetica,potencial;

	@Override
	public void onCreate(Bundle savedInstanceState){
		super.onCreate(savedInstanceState);
		leerPreferencias();
		Grafico grafico=new Grafico(this);
		setContentView(grafico);
		hilo=new Thread(grafico);
		hilo.start();
	}
	
    @Override
    protected void onPause(){
    	super.onPause();
    	// stop the thread  hilo
    	if(hilo.isAlive()) hilo.stop();
    }
	
	class Grafico extends View implements Runnable{

		int width,height;
		Paint paint1,paint2,paint3,paint4,paint,paintRun;
		Path path1,path2,path3;
		int topMargin=40;
		int margin=40;
		int x0,x1,y0,y1,x,y;
		double b0,b1,e0,e1;
		String texto;
		String texto1="texto1";
		String texto2="texto2";
		String texto3="texto3";

		// matrix to plot the energy
		int intervalos=200;
		double [] bMatriz=new double[intervalos];
		double [] eMatriz=new double[intervalos];	
		double [] potMatriz=new double[intervalos];	
		double [] cinMatriz=new double[intervalos];		
		
		public Grafico(Context context) {
			super(context);
			paint=new Paint();
			paint.setColor(Color.BLACK);
			paint.setTextSize(16);
			paintRun=new Paint();
			paintRun.setColor(Color.RED);
			paintRun.setTextSize(20);
			paint1=new Paint();
			paint1.setColor(Color.BLACK);
			paint1.setStyle(Paint.Style.STROKE);
			paint1.setStrokeWidth(1);
			paint2=new Paint();
			paint2.setColor(Color.RED);
			paint2.setStyle(Paint.Style.STROKE);			
			paint2.setStrokeWidth(3);
			paint3=new Paint();
			paint3.setColor(Color.BLUE);
			paint3.setStyle(Paint.Style.STROKE);			
			paint3.setStrokeWidth(3);
			paint4=new Paint();
			paint4.setColor(Color.GREEN);
			paint4.setStyle(Paint.Style.STROKE);			
			paint4.setStrokeWidth(3);
			path1=new Path(); 
			path2=new Path();
			path3=new Path();
			
			b0=0;
			b1=5;
			e0=-150;
			e1=50;

			// fill a matrix to plot the energy
			double paso=(b1-b0)/intervalos;
			for(int i=1;i<intervalos;i++){
				bMatriz[i]=b0+paso*i;
				eMatriz[i]=energia(bMatriz[i]);
				potMatriz[i]=potencial;
				cinMatriz[i]=cinetica;
			}		
		}
		
		@Override
		protected void onSizeChanged(int w, int h, int oldw, int oldh){
			width=w;
			height=h;
			x0=margin;
			x1=width-margin;
			y0=height-margin;
			y1=topMargin;
		}
		@Override
		protected void onDraw (Canvas canvas){
			canvas.drawColor(Color.WHITE);
			texto="Energy of  Helium-4";
			canvas.drawText(texto,x1/2,20,paint);
			canvas.drawRect(x0,y0,x1,y1,paint1);

			texto1="bmin="+format(bmin,6);
			texto2="Emin="+format(emin,6);
			canvas.drawText(texto1,width/2,85,paint);
			canvas.drawText(texto2,width/2,105,paint);
			canvas.drawText(texto3,width/2,65, paintRun);

			// plot energy function
			x=coX(bMatriz[1]);
			y=coY(eMatriz[1]);
			path1.moveTo(x,y);
			for(int i=2;i<intervalos;i++){
				x=coX(bMatriz[i]);
				y=coY(eMatriz[i]);
				path1.lineTo(x,y);
			}
			canvas.drawPath(path1,paint2);

			// plot kinetic energy
			x=coX(bMatriz[1]);
			y=coY(cinMatriz[1]);
			path2.moveTo(x,y);
			for(int i=2;i<intervalos;i++){
				x=coX(bMatriz[i]);
				y=coY(cinMatriz[i]);
				path2.lineTo(x,y);
			}
			canvas.drawPath(path2,paint3);

			// plot potential energy
			x=coX(bMatriz[1]);
			y=coY(potMatriz[1]);
			path3.moveTo(x,y);
			for(int i=2;i<intervalos;i++){
				x=coX(bMatriz[i]);
				y=coY(potMatriz[i]);
				path3.lineTo(x,y);
			}
			canvas.drawPath(path3,paint4);		
			// draw minimum energy point
			canvas.drawCircle(coX(bmin), coY(emin), 5, paint);
			
			// ticks  x axis			
			for (int i=1; i<6;i++){
				canvas.drawLine(coX(i),coY(e0),coX(i),coY(e0)-5,paint1);
				canvas.drawText(""+i, coX(i),y0+20, paint);
			}
			// ticks y axis
			for (int i=-15;i<5;i++){
				canvas.drawLine(coX(b0),coY(10*i),coX(b0)+5,coY(10*i), paint1);
				canvas.drawText(""+10*i,0,coY(10*i), paint);
			}
			// draw zero-line
			canvas.drawLine(coX(b0),coY(0),coX(b1),coY(0),paint1);

			// write contents of sharedpreferences
			int ii=0;
			for (int i=0;i<2;i++){
				for (int j=0;j<2;j++){
					texto="R"+i+"="+Rdelta[i][j];		
					canvas.drawText(texto,x1/2, y0/2+20*(ii+1), paint);
					ii++;	
					texto="La"+i+j+"="+lambda[i][j];		
					canvas.drawText(texto,x1/2, y0/2+20*(ii+1), paint);
					ii++;			
				}
			}			
		}

		int coX(double b){
			double xdouble=x0+(x1-x0)*(b-b0)/(b1-b0);			
			return (int) xdouble;
		}		
		int coY(double e){
			double ddouble=y0+(y1-y0)*(e-e0)/(e1-e0);			
			return (int) ddouble;
		}

		@Override
		public void run() {
			// Start searching the minimum with step=1
			double paso=1;
			int dt=50;
			bmin=1;
			emin=energia(bmin);
			double resolucion=0.01;
			
			while(paso>resolucion){
				minimiza(paso);
				paso=paso/2.0;
				texto2="Step="+paso;
				postInvalidate();
				try{ Thread.sleep(dt);}
				catch(InterruptedException e){;}								
			}
			texto3="MINIMUM FOUND!";
			postInvalidate();
		}	
	}
	
	void minimiza(double paso){

		boolean found=false;
		while(!found){
		double bmas=bmin+paso;
		double bmenos=bmin-paso;
		double emenos=energia(bmenos);
		double emas=energia(bmas);
		if(emenos<emin){
			bmin=bmenos;
			emin=emenos;			
		}else if(emas<emin){
			bmin=bmas;
			emin=emas;
		}else 
			found=true;
		}
	}

	double energia(double b){
		final double hbarc=197.3;
		final double mc2=939;		

		double sq2pi=Math.sqrt(2./Math.PI);
		double hbc2mc2=hbarc*hbarc/mc2;
		double alfa=1/b;
		double alfa2=alfa*alfa;
		double alfa3=alfa2*alfa;
		double factor=sq2pi*6.*hbc2mc2*alfa3;

		cinetica =9.0/4.*hbc2mc2*alfa2;
		potencial=0.;
		double r,r2,exponente,exponencial,lambdaMedio;

		for (int i=0;i<2;i++){
		for (int j=0;j<2;j++){
			r=Rdelta[i][j];
			r2=r*r;
			exponente=-alfa2*r2/2.0;
			exponencial=Math.exp(exponente);
			lambdaMedio=lambda[i][j]/2.;
			 potencial= potencial+factor*lambdaMedio*r2*exponencial;
		}}
		double energy=cinetica+potencial;
		return energy;
	}
	
	void leerPreferencias(){
        SharedPreferences misDatos=getSharedPreferences("preferencias",0);
        lambda[0][0]=misDatos.getFloat("lambda00",0);
        lambda[0][1]=misDatos.getFloat("lambda01",0);
        lambda[1][0]=misDatos.getFloat("lambda10",0);
        lambda[1][1]=misDatos.getFloat("lambda11",0);
        Rdelta[0][0]=misDatos.getFloat("R00",0);
        Rdelta[0][1]=misDatos.getFloat("R01",0);
        Rdelta[1][0]=misDatos.getFloat("R10",0);
        Rdelta[1][1]=misDatos.getFloat("R11",0);
	}	
	

    // format a number with several digits
    String format(double x, int cifras){
		String cadena=""+x;
		if (cadena.length()<=cifras)return cadena;
		if(x<0) cifras=cifras+1;
		return cadena.substring(0,cifras);
	}
}
