package es.ugr.amaro.handroica;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.EditText;
import android.widget.Toast;

public class Handroica extends Activity implements OnClickListener{

	SharedPreferences misDatos;
	EditText editL00,editL01;
	EditText editL10,editL11;
	EditText editR00,editR01;
	EditText editR10,editR11;
	EditText editEmax,editTolerancia,editResolucion;
		
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }
    
    @Override
	protected    void onStart(){
    	super.onStart();
        
        View button1=findViewById(R.id.button1);
        View button2=findViewById(R.id.button2);
        View button3=findViewById(R.id.button3);
        View button4=findViewById(R.id.button4);
        View button5=findViewById(R.id.button5);
        View button6=findViewById(R.id.button6);
        button1.setOnClickListener(this);
        button2.setOnClickListener(this);
        button3.setOnClickListener(this);
        button4.setOnClickListener(this);
        button5.setOnClickListener(this);
        button6.setOnClickListener(this);

        // Read lambad00 in the file of preferences
        misDatos=getSharedPreferences("preferencias",0);

        editEmax=(EditText) findViewById(R.id.Emax);
        editEmax.setText(""+misDatos.getFloat("Emax",100));
        editTolerancia=(EditText) findViewById(R.id.tolerancia);
        editTolerancia.setText(""+misDatos.getFloat("tolerancia",0.5f));
        editResolucion=(EditText) findViewById(R.id.resolucion);
        editResolucion.setText(""+misDatos.getFloat("resolucion",(float) 1e-5));

        editR00=(EditText) findViewById(R.id.R00);
        editR01=(EditText) findViewById(R.id.R01);
        editR00.setText(""+misDatos.getFloat("R00", 0.75f));
        editR01.setText(""+misDatos.getFloat("R01", 1.25f));
        editR10=(EditText) findViewById(R.id.R10);
        editR11=(EditText) findViewById(R.id.R11);
        editR10.setText(""+misDatos.getFloat("R10", 0.75f));
        editR11.setText(""+misDatos.getFloat("R11", 1.25f));
        
        editL00=(EditText) findViewById(R.id.lambda00);
        editL01=(EditText) findViewById(R.id.lambda01);
        editL10=(EditText) findViewById(R.id.lambda10);
        editL11=(EditText) findViewById(R.id.lambda11);
        editL00.setText(""+misDatos.getFloat("lambda00", 0.73f));
        editL01.setText(""+misDatos.getFloat("lambda01",-0.7f));
        editL10.setText(""+misDatos.getFloat("lambda10", 0.73f));
        editL11.setText(""+misDatos.getFloat("lambda11",-0.7f));        
    }

    @Override
    protected void onPause(){
    	super.onPause();
    	SharedPreferences.Editor miEditor=misDatos.edit();

    	float dato;
    	dato=Float.parseFloat(editR00.getText().toString());
    	miEditor.putFloat("R00",dato);
    	dato=Float.parseFloat(editR01.getText().toString());
    	miEditor.putFloat("R01",dato);
    	dato=Float.parseFloat(editR10.getText().toString());
    	miEditor.putFloat("R10",dato);
    	dato=Float.parseFloat(editR11.getText().toString());
    	miEditor.putFloat("R11",dato);
    	
    	dato=Float.parseFloat(editL00.getText().toString());
    	miEditor.putFloat("lambda00",dato);
    	dato=Float.parseFloat(editL01.getText().toString());
    	miEditor.putFloat("lambda01",dato);
    	dato=Float.parseFloat(editL10.getText().toString());
    	miEditor.putFloat("lambda10",dato);
    	dato=Float.parseFloat(editL11.getText().toString());
    	miEditor.putFloat("lambda11",dato);

    	dato=Float.parseFloat(editEmax.getText().toString());
    	miEditor.putFloat("Emax",dato);
    	dato=Float.parseFloat(editTolerancia.getText().toString());
    	miEditor.putFloat("tolerancia",dato);
    	dato=Float.parseFloat(editResolucion.getText().toString());
    	miEditor.putFloat("resolucion",dato);
    	
    	miEditor.commit();
    	Toast.makeText(this,"Storing Data",1).show();
    }
    
	@Override
	public void onClick(View v) {
		int i=v.getId();
		Intent intencion; 
		if(i==R.id.button1){
			// Computes binding energy of He4
			intencion=new Intent(this,He4.class);
			startActivity(intencion);
		}
		else if(i==R.id.button2){
			// Computes phaseshift for spin=0
			intencion=new Intent(this,PhaseShift.class);
			intencion.putExtra(PhaseShift.spinExtra, 0);
			startActivity(intencion);
		}
		else if(i==R.id.button3){
			// Computes phaseshift for spin=1
			intencion=new Intent(this,PhaseShift.class);
			intencion.putExtra(PhaseShift.spinExtra, 1);
			startActivity(intencion);			
		}
		else if(i==R.id.button4){
			// Computes binding energy of He4
			intencion=new Intent(this,NuclearMatter.class);
			startActivity(intencion);
		}
		else if(i==R.id.button5){
			// Computes binding energy of He4
			intencion=new Intent(this,Help.class);
			startActivity(intencion);
		}
		else if(i==R.id.button6){
			// Computes binding energy of He4
			intencion=new Intent(this,Credits.class);
			startActivity(intencion);
		}
		
	}    
}
