(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1821346,      70758]*)
(*NotebookOutlinePosition[   1823404,      70822]*)
(*  CellTagsIndexPosition[   1823265,      70814]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Teoremas de Stokes y de Gauss
Funciones arm\[OAcute]nicas\
\>", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[ParametricPlot::ppcom]\), "\n", 
    \(Off[General::spell]\), "\[IndentingNewLine]", 
    \(Off[General::spell1]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[{
    \(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \), "\n", 
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]];\)\  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \), "\n\
", 
    \(vector2D[x_: {0, 0}, y_] := 
      Arrow[x, x + y]\ \), "\[IndentingNewLine]", 
    \(normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\), "\n", 
    \( (*\ un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    StyleBox[\(gramschmidt = 
          Fold[Append[#1, \((#1\/\@\(#1 . #1\) &)\)[
                    Fold[#1 - #1 . #2\ #2\  &, #2, #1]]] &, {}, #1] &;\),
      FontFamily->"Courier New"]], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(semiesferasuperior := 
      Module[{fig1, fig2, normales, tangentes, normalesinteriores, 
          f, \[Gamma], n}, 
        f[s_, t_] = 
          4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}; \[IndentingNewLine]fig1 = 
          ParametricPlot3D[
            4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}, {t, 0, 2  \[Pi]}, {s, 
              0, \[Pi]/2}, AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, 
            ViewPoint -> {1.536, \ \(-2.836\), \ \(-1.025\)}, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
          ParametricPlot3D[{3.9  Cos[t], 3.9  Sin[t], 
              0, {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
            Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[s_, t_] = 
          Simplify[
            Cross[D[f[s, t], s], D[f[s, t], t]]\/\@\(Cross[D[f[s, t], s], \
D[f[s, t], t]] . Cross[D[f[s, t], s], D[f[s, t], t]]\), 
            Sin[s] > 0]; \[IndentingNewLine]normales = 
          Graphics3D[
            Table[vector3D[f[s, t], n[s, t], Green], {t, 0. , 2  \[Pi], 
                  N[\[Pi]]/6}, {s, 0. , \[Pi]/2, N[\[Pi]/2]/3}] // 
              Chop]; \n\[Gamma][t_] = {4  Cos[t], 4  Sin[t], 0}; \n
        tangentes = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], tgtunit[\[Gamma], t], Blue], {t, 0. , 
                  2  \[Pi], N[\[Pi]]/6}] // Chop]; \n
        normalesinteriores = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], 
                  Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]], Red], {t, 
                  0. , 2  \[Pi], N[\[Pi]]/6}] // 
              Chop]; \[IndentingNewLine]Show[{fig1, fig2, normales, 
            tangentes, normalesinteriores}, 
          DisplayFunction \[Rule] $DisplayFunction]; \[IndentingNewLine] (*\ 
          Table[Det[{tgtunit[\[Gamma], t], 
                  Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]], 
                  n[\[Pi]/2. , t]}], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
            Chop\ *) ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(semiesferainferior := 
      Module[{fig1, fig2, normales, tangentes, normalesinteriores, 
          f, \[Gamma], n}, 
        f[s_, t_] = 
          4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}; \[IndentingNewLine]fig1 = 
          ParametricPlot3D[
            4 {Cos[t]*Sin[s], Sin[t]*Sin[s], Cos[s]}, {t, 0, 
              2  \[Pi]}, {s, \[Pi]/2, \[Pi]}, AspectRatio \[Rule] Automatic, 
            Axes \[Rule] False, Boxed \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
          ParametricPlot3D[{3.9  Cos[t], 3.9  Sin[t], 
              0, {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
            Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
            DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[s_, t_] = 
          Simplify[
            Cross[D[f[s, t], s], 
                D[f[s, t], 
                  t]]/\((\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], D[f[s, t], t]])\))\), 
            Sin[s] > 0]; \[IndentingNewLine]normales = 
          Graphics3D[
            Table[vector3D[f[s, t], n[s, t], Green], {t, 0. , 2  \[Pi], 
                  N[\[Pi]]/6}, {s, N[\[Pi]/2], N[\[Pi]], N[\[Pi]/2]/4}] // 
              Chop]; \n\[Gamma][t_] = {4  Cos[t], 4  Sin[t], 0}; \n
        tangentes = 
          Graphics3D[
            Table[vector3D[\[Gamma][t], \(-tgtunit[\[Gamma], t]\), Blue], {t, 
                  0. , 2  \[Pi], N[\[Pi]]/6}] // Chop]; \n
        normalesinteriores = 
          Graphics3D[
            Table[vector3D[\[Gamma][
                    t], \(-Cross[n[\[Pi]/2. , t], tgtunit[\[Gamma], t]]\), 
                  Red], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
              Chop]; \[IndentingNewLine]Show[{fig1, fig2, normales, 
            tangentes, normalesinteriores}, 
          DisplayFunction \[Rule] $DisplayFunction]; \[IndentingNewLine] (*\ 
          Table[Det[{\(-tgtunit[\[Gamma], t]\), 
                  Cross[n[\[Pi]/2. , t], \(-tgtunit[\[Gamma], t]\)], 
                  n[\[Pi]/2. , t]}], {t, 0. , 2  \[Pi], N[\[Pi]]/6}] // 
            Chop\ *) ]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cilindro := 
        Module[{fig1, fig2, fig3, normales, tangentes1, normalinterior1, 
            tangentes2, normalinterior2, f, \[Gamma]1, \[Gamma]2, n}, 
          f[s_, t_] = {t, Cos[s], Sin[s]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{t, Cos[s], Sin[s]}, {s, 0, 2  \[Pi]}, {t, 1, 
                4}, AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
              Boxed \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{1, Cos[t], 
                Sin[t], {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig3 = 
            ParametricPlot3D[{4, Cos[t], 
                Sin[t], {Yellow, Thickness[0.007]}}, {t, 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Ticks \[Rule] None, Axes \[Rule] False, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]n[t_, 
              s_] = Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normales = 
            Graphics3D[
              Table[vector3D[f[\[Pi], t], n[t, \[Pi]], Green], {t, 1. , 4. , 
                    1.5}] // Chop]; \n\[Gamma]1[t_] = {1, Cos[t], Sin[t]}; \n
          tangentes1 = 
            Graphics3D[
              vector3D[\[Gamma]1[\[Pi]], tgtunit[\[Gamma]1, \[Pi]], Blue]]; \n
          normalinterior1 = 
            Graphics3D[
              vector3D[\[Gamma]1[\[Pi]], \(-Cross[n[\[Pi], 1. ], 
                    tgtunit[\[Gamma]1, \[Pi]]]\), 
                Red]]; \[IndentingNewLine]\[Gamma]2[t_] = {4, Cos[t], 
              Sin[t]}; \n
          tangentes2 = 
            Graphics3D[
              vector3D[\[Gamma]2[\[Pi]], \(-tgtunit[\[Gamma]2, \[Pi]]\), 
                Blue]]; \n
          normalinterior2 = 
            Graphics3D[
              vector3D[\[Gamma]2[\[Pi]], 
                Cross[n[4. , \[Pi]], \(-tgtunit[\[Gamma]2, \[Pi]]\)], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, fig3, normales, 
              tangentes1, normalinterior1, tangentes2, normalinterior2}, 
            DisplayFunction \[Rule] $DisplayFunction]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(casquete := 
        Module[{fig1, fig2, normal, normal2, tangente, normalinterior, 
            f, \[Gamma]}, 
          f[\[Theta]_, \[Phi]_] = {Cos[\[Phi]] Sin[\[Theta]], 
              Sin[\[Phi]] Sin[\[Theta]], 
              1 + Cos[\[Theta]]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
                Sin[\[Phi]] Sin[\[Theta]], 1 + Cos[\[Theta]]}, {\[Phi], 0, 
                2  \[Pi]}, {\[Theta], 0, ArcCos[3. /5]}, Boxed \[Rule] False, 
              Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 
                8/5, {Yellow, Thickness[0.007]}}, {\[Phi], 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] 
                Identity]; \[IndentingNewLine]\[Gamma][\[Phi]_] = \
{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 8/5}; \[IndentingNewLine]n[s_, t_] = 
            Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normal = 
            Graphics3D[
              vector3D[f[ArcCos[3. /5], 3  \[Pi]/2], 
                n[ArcCos[3. /5], 3  \[Pi]/2], 
                Green]]; \[IndentingNewLine]normal2 = 
            Graphics3D[vector3D[{0, 0, 2},  .5 {0, 0, 1}, Green]]; \n
          tangente = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   tgtunit[\[Gamma], 3  \[Pi]/2], Blue]]; \n
          normalinterior = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   Cross[n[ArcCos[3. /5], 3  \[Pi]/2], 
                    tgtunit[\[Gamma], 3  \[Pi]/2]], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, normal, normal2, 
              tangente, normalinterior}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            PlotRange \[Rule] All]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(cono := 
        Module[{fig1, fig2, normal, normal2, tangente, normalinterior, 
            f, \[Gamma]}, 
          f[\[Rho]_, \[Phi]_] = {\[Rho]*Cos[\[Phi]], \[Rho]*Sin[\[Phi]], 
              2  \[Rho]}; \[IndentingNewLine]fig1 = 
            ParametricPlot3D[{\[Rho]*Cos[\[Phi]], \[Rho]*Sin[\[Phi]], 
                2  \[Rho]}, {\[Phi], 0, 2  \[Pi]}, {\[Rho], 0, 4/5}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]fig2 = 
            ParametricPlot3D[{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 
                8/5, {Yellow, Thickness[0.007]}}, {\[Phi], 0, 2  \[Pi]}, 
              Boxed \[Rule] False, Axes \[Rule] False, AspectRatio \[Rule] 1, 
              DisplayFunction \[Rule] 
                Identity]; \[IndentingNewLine]\[Gamma][\[Phi]_] = \
{Cos[\[Phi]] 4/5, Sin[\[Phi]] 4/5, 8/5}; \[IndentingNewLine]n[s_, t_] = 
            Simplify[
              Cross[D[f[s, t], s], 
                  D[f[s, t], 
                    t]]/\[Sqrt]\((Cross[D[f[s, t], s], D[f[s, t], t]] . 
                      Cross[D[f[s, t], s], 
                        D[f[s, t], t]])\)]; \[IndentingNewLine]normal = 
            Graphics3D[
              vector3D[f[4/5, 3  \[Pi]/2], \(- .5\) n[4/5, 3  \[Pi]/2], 
                Green]]; \[IndentingNewLine]normal2 = 
            Graphics3D[
              vector3D[
                f[3/5. , \(-\[Pi]\)/3. ], \(- .5\) n[3/5. , \(-\[Pi]\)/3. ], 
                Green]]; \n
          tangente = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2], \(- .5\) 
                  tgtunit[\[Gamma], 3  \[Pi]/2], Blue]]; \n
          normalinterior = 
            Graphics3D[
              vector3D[\[Gamma][3  \[Pi]/2],  .5 
                   Cross[n[ArcCos[3. /5], 3  \[Pi]/2], 
                    tgtunit[\[Gamma], 3  \[Pi]/2]], 
                Red]]; \[IndentingNewLine]Show[{fig1, fig2, normal, normal2, 
              tangente, normalinterior}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            PlotRange \[Rule] All]];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(helado := Show[casquete, cono]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{"molinillo", ":=", 
      RowBox[{"Module", "[", 
        RowBox[{\({fig1, fig2, fig3, texto}\), ",", 
          
          RowBox[{\(fig1 = 
              Graphics[{Thickness[ .007], Circle[{0, 0}, 1], 
                  Line[{{\(-1\), 0}, {1, 0}}], PointSize[ .07], 
                  Point[{0, 0}], PointSize[ .03], Red, Point[{1, 0}], 
                  Point[{\(-1\), 0}]}]\), ";", 
            "\[IndentingNewLine]", \(fig2 = 
              Graphics[{vector2D[{1, 0}, {1.2, 1.2}], 
                  vector2D[{\(-1\), 0}, { .8,  .6}]}]\), ";", 
            "\[IndentingNewLine]", 
            RowBox[{"texto", "=", 
              RowBox[{"Graphics", "[", 
                RowBox[{"{", 
                  
                  RowBox[{\(Text[\*"\"\<\!\(p\_1\)\>\"", {1.2, 0}]\), 
                    ",", \(Text[\*"\"\<\!\(p\_2\)\>\"", {\(-1.2\), 0}]\), ",",
                     
                    RowBox[{"Text", "[", 
                      RowBox[{"\"\<\!\(\(\*
StyleBox[\"v\",\nFontSlant->\"Italic\"]\)\_1\)\>\"", ",", \({1, 1.35}\)}], 
                      "]"}], ",", 
                    RowBox[{"Text", "[", 
                      RowBox[{"\"\<\!\(\(\*
StyleBox[\"v\",\nFontSlant->\"Italic\"]\)\_2\)\>\"", 
                        ",", \({\(-1\), 0.73}\)}], "]"}], 
                    ",", \(Text[\*"\"\<V(\!\(p\_1\))\>\"", {2.1,  .75}]\), 
                    ",", \(Text[\*"\"\<V(\!\(p\_2\))\>\"", {\(- .2\), 
                        0.35}]\)}], "}"}], "]"}]}], ";", 
            "\[IndentingNewLine]", \(fig3 = 
              Graphics[{vector2D[{1, 0}, {0, 1.2}], 
                  vector2D[{\(-1\), 0}, {0,  .6}]}]\), ";", 
            "\[IndentingNewLine]", \(Show[{fig1, fig2, fig3, texto}, 
              Ticks \[Rule] None, Axes \[Rule] False, 
              AspectRatio \[Rule] Automatic, PlotRange \[Rule] All, 
              TextStyle \[Rule] {FontFamily -> "\<Times\>", 
                  FontSize -> "\<12\>", FontWeight -> "\<Bold\>"}]\)}]}], 
        "]"}]}]], "Input",
  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],

Cell["<<Calculus`VectorAnalysis`", "Input",
  InitializationCell->True,
  CellTags->"S5.16.1"],

Cell[BoxData[
    \(On[General::spell]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Teorema de Stokes", "Section"],

Cell[TextData[{
  "El teorema de Stokes es una generalizaci\[OAcute]n del teorema de Green \
para superficies en el espacio: el teorema de Green establece una igualdad \
entre integrales dobles e integrales de l\[IAcute]nea y el teorema de Stokes \
establece una igualdad entre integrales de superficie e integrales de l\
\[IAcute]nea. Veremos que en el caso particular de que la superficie sea una \
superficie plana situada en el plano XY con normal unitaria igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox["k",
          FontWeight->"Bold"], TraditionalForm]]],
  " el teorema de Stokes se convierte en el teorema de Green."
}], "Text"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{"S", Cell[""]}], TraditionalForm]]],
  "una superficie que suponemos orientada por un campo continuo de vectores \
que a cada punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] S\)]],
  " hace corresponder un vector unitario normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " que notaremos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  ". Suponemos que la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es una superficie abierta y representamos por ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " su \"borde\". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " puede ser una curva cerrada o puede estar formado por varias curvas \
cerradas disjuntas (por ejemplo, la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " puede ser un trozo de cilindro circular recto sin tapaderas en cuyo caso \
su borde son dos circunferencias).  "
}], "Text"],

Cell[TextData[{
  " La orientaci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " definida por el campo de vectores normales ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["n",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox[\(x, y, z\),
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " induce una orientaci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " que se llama ",
  StyleBox["orientaci\[OAcute]n inducida",
    FontWeight->"Bold"],
  ".",
  " En t\[EAcute]rminos familiares, la orientaci\[OAcute]n inducida en ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " es aquella en la que al recorrer caminando ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en el sentido que indica el vector tangente en cada punto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " y con la cabeza apuntando en el sentido que indica el vector normal ",
  Cell[BoxData[
      FormBox[
        StyleBox["n",
          FontWeight->"Bold"], TraditionalForm]]],
  ", la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " queda a nuestra izquierda."
}], "Text"],

Cell[TextData[{
  " Una definici\[OAcute]n matem\[AAcute]tica m\[AAcute]s precisa de lo que \
se entiende por \"orientaci\[OAcute]n inducida\" es la siguiente. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`P \[Element] \[PartialD]S\)]],
  " un punto en el borde de la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". La \"curva\" ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " tiene en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " dos vectores normales unitarios que son tangentes a la superficie ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  "; estos vectores son opuestos entre s\[IAcute]. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " uno de dichos vectores. Representemos por ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "el plano tangente a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`B(P, \[Epsilon])\)]],
  " una bola centrada en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(P\)\(\ \)\)\)]],
  "de radio ",
  Cell[BoxData[
      \(TraditionalForm\`\[Epsilon] > 0\)]],
  " suficientemente peque\[NTilde]o. Definamos ",
  Cell[BoxData[
      \(TraditionalForm\`G = B(P, \[Epsilon]) \[Intersection] \ S\)]],
  " y sea ",
  Cell[BoxData[
      \(TraditionalForm\`D = \(\[CapitalPi]\_H\)(G)\)]],
  " la proyecci\[OAcute]n ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi]\_H\)]],
  " deja invariante a ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " porque ambos est\[AAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". Adem\[AAcute]s, como ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalPi]\_H\)]],
  " conserva la ortogonalidad, el vector ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es normal en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " a la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[PartialD]S)\)\_H = \(\[CapitalPi]\_H\)(\
\[PartialD]S \[Intersection] B(P, \[Epsilon]))\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es un dominio plano y que ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[PartialD]S)\)\_H\)]],
  " es parte de ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  ". Pues bien, si el vector ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es la normal interior a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]D\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " (en el sentido que definimos al estudiar el teorema de Green) se dice que \
",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es el vector unitario normal a ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " que ",
  StyleBox["apunta hacia dentro",
    FontWeight->"Bold"],
  " de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ".  ",
  StyleBox["La orientaci\[OAcute]n inducida en ",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  StyleBox[" por la orientaci\[OAcute]n dada de la superficie",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es aquella en la que, notando por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " el vector unitario normal que apunta hacia dentro de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " y por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox[\(x, y, z\),
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " el vector tangente unitario a ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]S\)]],
  " en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] \[PartialD]S\)]],
  ", se verifica que la base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], ",", 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], ",", 
            RowBox[{
              StyleBox["n",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], "}"}], 
        TraditionalForm]]],
  " ",
  StyleBox["tiene determinante positivo (",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{"de", " ", "hecho", " ", "igual", " ", 
          StyleBox["a",
            FontSlant->"Plain"], " ", "1"}], TraditionalForm]]],
  StyleBox[") para todo ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Element] \[PartialD]S\)]],
  ". Observa que, cualquiera sea el vector tangente unitario ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], TraditionalForm]]],
  " se tiene que ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            RowBox[{
              RowBox[{
                StyleBox["n",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "\[Times]", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}]}]}], 
        TraditionalForm]]],
  " o ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{
                  StyleBox["n",
                    FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}], 
              "\[Times]", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", \(x, y, z\), ")"}]}]}]}], 
        TraditionalForm]]],
  ". "
}], "Text"],

Cell[TextData[{
  "Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " es una superficie suave y orientable a trozos se conviene en que la \
orientaci\[OAcute]n de cada parte suave y orientable de ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " se haga de forma que en cada curva \[Gamma] que sea frontera \
com\[UAcute]n de dos partes suaves orientables las respectivas orientaciones \
inducidas en \[Gamma] sean opuestas. Las siguientes gr\[AAcute]ficas ",
  "te ayudar\[AAcute]n a entender estas ideas."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(semiesferasuperior;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .65983 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.20617e-017 1.05807 -0.25463 1.05807 [
[ 0 0 0 0 ]
[ 1 .65983 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .65983 L
0 .65983 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 .803 0 r
.52039 .19007 m .52292 .18978 L .52181 .19561 L closepath p F P
0 g
s
0 .917 0 r
.51883 .19201 m .52039 .19007 L .52181 .19561 L closepath p F P
0 g
s
0 .727 0 r
.51915 .19446 m .51883 .19201 L .52181 .19561 L closepath p F P
0 g
s
0 .015 0 r
.52116 .19599 m .51915 .19446 L .52181 .19561 L closepath p F P
0 g
s
0 0 0 r
.52368 .19569 m .52116 .19599 L .52181 .19561 L closepath p F P
0 g
s
0 0 0 r
.52524 .19375 m .52368 .19569 L .52181 .19561 L closepath p F P
0 g
s
0 .103 0 r
.52493 .1913 m .52524 .19375 L .52181 .19561 L closepath p F P
0 g
s
0 .542 0 r
.52292 .18978 m .52493 .1913 L .52181 .19561 L closepath p F P
0 g
s
0 .871 0 r
.51857 .03642 m .52093 .03545 L .52067 .03639 L closepath p F P
0 g
s
0 .958 0 r
.5176 .03874 m .51857 .03642 L .52067 .03639 L closepath p F P
0 g
s
0 .689 0 r
.51858 .04105 m .5176 .03874 L .52067 .03639 L closepath p F P
0 g
s
0 .391 0 r
.52094 .042 m .51858 .04105 L .52067 .03639 L closepath p F P
0 g
s
0 .18 0 r
.52329 .04103 m .52094 .042 L .52067 .03639 L closepath p F P
0 g
s
0 .074 0 r
.52427 .0387 m .52329 .04103 L .52067 .03639 L closepath p F P
0 g
s
0 .153 0 r
.52329 .03639 m .52427 .0387 L .52067 .03639 L closepath p F P
0 g
s
0 .489 0 r
.52093 .03545 m .52329 .03639 L .52067 .03639 L closepath p F P
0 g
s
0 1 0 r
.007 w
.52067 .03639 m
.52217 .0496 L
s
.5 Mabswid
0 .751 0 r
.65135 .19878 m .65373 .19815 L .65706 .20441 L closepath p F P
0 g
s
0 .775 0 r
.64992 .20092 m .65135 .19878 L .65706 .20441 L closepath p F P
0 g
s
0 .661 0 r
.65026 .20332 m .64992 .20092 L .65706 .20441 L closepath p F P
0 g
s
0 .166 0 r
.65218 .20458 m .65026 .20332 L .65706 .20441 L closepath p F P
0 g
s
0 .838 0 r
.65455 .20395 m .65218 .20458 L .65706 .20441 L closepath p F P
0 g
s
0 .445 0 r
.65373 .19815 m .65565 .1994 L .65706 .20441 L closepath p F P
0 g
s
0 .988 0 r
.65599 .2018 m .65455 .20395 L .65706 .20441 L closepath p F P
0 g
s
0 .585 0 r
.65565 .1994 m .65599 .2018 L .65706 .20441 L closepath p F P
0 g
s
0 .783 0 r
.3914 .20015 m .39377 .20057 L .38793 .20643 L closepath p F P
0 g
s
0 1 0 r
.38966 .20158 m .3914 .20015 L .38793 .20643 L closepath p F P
0 g
s
0 0 0 r
.38957 .20403 m .38966 .20158 L .38793 .20643 L closepath p F P
0 g
s
0 0 0 r
.39528 .20504 m .39354 .20648 L .38793 .20643 L closepath p F P
0 g
s
0 .31 0 r
.39537 .2026 m .39528 .20504 L .38793 .20643 L closepath p F P
0 g
s
0 .554 0 r
.39377 .20057 m .39537 .2026 L .38793 .20643 L closepath p F P
0 g
s
0 .334 0 r
.39117 .20606 m .38957 .20403 L .38793 .20643 L closepath p F P
0 g
s
0 .626 0 r
.39354 .20648 m .39117 .20606 L .38793 .20643 L closepath p F P
0 g
s
0 .891 0 r
.67069 .04378 m .67288 .04305 L .67761 .04426 L closepath p F P
0 g
s
0 .855 0 r
.66975 .04603 m .67069 .04378 L .67761 .04426 L closepath p F P
0 g
s
0 .669 0 r
.67061 .04847 m .66975 .04603 L .67761 .04426 L closepath p F P
0 g
s
0 .412 0 r
.67276 .04969 m .67061 .04847 L .67761 .04426 L closepath p F P
0 g
s
0 0 0 r
.67494 .04896 m .67276 .04969 L .67761 .04426 L closepath p F P
0 g
s
0 .858 0 r
.67588 .04672 m .67494 .04896 L .67761 .04426 L closepath p F P
0 g
s
0 .652 0 r
.67503 .04427 m .67588 .04672 L .67761 .04426 L closepath p F P
0 g
s
0 0 0 r
.67288 .04305 m .67503 .04427 L .67761 .04426 L closepath p F P
0 g
s
.466 0 0 r
.52383 .09926 m .52546 .09973 L .52223 .11093 L closepath p F P
0 g
s
.765 0 0 r
.52546 .09973 m .52519 .10034 L .52223 .11093 L closepath p F P
0 g
s
.688 0 0 r
.52126 .0992 m .52383 .09926 L .52223 .11093 L closepath p F P
0 g
s
.835 0 0 r
.51925 .09958 m .52126 .0992 L .52223 .11093 L closepath p F P
0 g
s
.957 0 0 r
.51897 .10018 m .51925 .09958 L .52223 .11093 L closepath p F P
0 g
s
.397 0 0 r
.5206 .10066 m .51897 .10018 L .52223 .11093 L closepath p F P
0 g
s
.675 0 0 r
.52317 .10072 m .5206 .10066 L .52223 .11093 L closepath p F P
0 g
s
.841 0 0 r
.52519 .10034 m .52317 .10072 L .52223 .11093 L closepath p F P
0 g
s
0 .521 0 r
.37258 .04551 m .37351 .04775 L .36521 .04607 L closepath p F P
0 g
s
0 .724 0 r
.37044 .0448 m .37258 .04551 L .36521 .04607 L closepath p F P
0 g
s
0 0 0 r
.36834 .04604 m .37044 .0448 L .36521 .04607 L closepath p F P
0 g
s
0 .24 0 r
.37057 .05146 m .36843 .05075 L .36521 .04607 L closepath p F P
0 g
s
0 .323 0 r
.37268 .05021 m .37057 .05146 L .36521 .04607 L closepath p F P
0 g
s
0 .401 0 r
.37351 .04775 m .37268 .05021 L .36521 .04607 L closepath p F P
0 g
s
0 0 0 r
.3675 .04851 m .36834 .04604 L .36521 .04607 L closepath p F P
0 g
s
0 0 0 r
.36843 .05075 m .3675 .04851 L .36521 .04607 L closepath p F P
0 g
s
.744 .609 .707 r
.45355 .12027 m .50503 .11766 L .50543 .13125 L p F P
0 g
s
.744 .609 .707 r
.50543 .13125 m .45481 .13388 L .45355 .12027 L p F P
0 g
s
.705 .578 .709 r
.55685 .13136 m .50543 .13125 L .50503 .11766 L p F P
0 g
s
.744 .6 .697 r
.45481 .13388 m .50543 .13125 L .50589 .14479 L p F P
0 g
s
.705 .569 .699 r
.50543 .13125 m .55685 .13136 L .55631 .1449 L p F P
0 g
s
.705 .569 .699 r
.55631 .1449 m .50589 .14479 L .50543 .13125 L p F P
0 g
s
.745 .618 .717 r
.45249 .10663 m .50469 .10404 L .50503 .11766 L p F P
0 g
s
.745 .618 .717 r
.50503 .11766 m .45355 .12027 L .45249 .10663 L p F P
0 g
s
.705 .586 .719 r
.55732 .11777 m .50503 .11766 L .50469 .10404 L p F P
0 g
s
.705 .578 .709 r
.50503 .11766 m .55732 .11777 L .55685 .13136 L p F P
0 g
s
.664 .543 .707 r
.60733 .13421 m .55685 .13136 L .55732 .11777 L p F P
0 g
s
.665 .535 .696 r
.55685 .13136 m .60733 .13421 L .60579 .14776 L p F P
0 g
s
.665 .535 .696 r
.60579 .14776 m .55631 .1449 L .55685 .13136 L p F P
0 g
s
.744 .6 .697 r
.50589 .14479 m .45626 .14742 L .45481 .13388 L p F P
0 g
s
.743 .59 .686 r
.45626 .14742 m .50589 .14479 L .50641 .15824 L p F P
0 g
s
.705 .561 .688 r
.50589 .14479 m .55631 .1449 L .55569 .15836 L p F P
0 g
s
.705 .561 .688 r
.55569 .15836 m .50641 .15824 L .50589 .14479 L p F P
0 g
s
.705 .586 .719 r
.50469 .10404 m .55771 .10415 L .55732 .11777 L p F P
0 g
s
.663 .551 .717 r
.60865 .12061 m .55732 .11777 L .55771 .10415 L p F P
0 g
s
.664 .543 .707 r
.55732 .11777 m .60865 .12061 L .60733 .13421 L p F P
0 g
s
.665 .526 .685 r
.55631 .1449 m .60579 .14776 L .60406 .16121 L p F P
0 g
s
.665 .526 .685 r
.60406 .16121 m .55569 .15836 L .55631 .1449 L p F P
0 g
s
.745 .626 .728 r
.45164 .09298 m .50442 .09042 L .50469 .10404 L p F P
0 g
s
.745 .626 .728 r
.50469 .10404 m .45249 .10663 L .45164 .09298 L p F P
0 g
s
.705 .594 .729 r
.55771 .10415 m .50469 .10404 L .50442 .09042 L p F P
0 g
s
.705 .594 .729 r
.50442 .09042 m .55803 .09053 L .55771 .10415 L p F P
0 g
s
.663 .559 .727 r
.60977 .10696 m .55771 .10415 L .55803 .09053 L p F P
0 g
s
.663 .551 .717 r
.55771 .10415 m .60977 .10696 L .60865 .12061 L p F P
0 g
s
.743 .59 .686 r
.50641 .15824 m .4579 .16087 L .45626 .14742 L p F P
0 g
s
.742 .581 .675 r
.4579 .16087 m .50641 .15824 L .50699 .17159 L p F P
0 g
s
.705 .552 .677 r
.50641 .15824 m .55569 .15836 L .55501 .1717 L p F P
0 g
s
.705 .552 .677 r
.55501 .1717 m .50699 .17159 L .50641 .15824 L p F P
0 g
s
.665 .518 .674 r
.55569 .15836 m .60406 .16121 L .60212 .17454 L p F P
0 g
s
.665 .518 .674 r
.60212 .17454 m .55501 .1717 L .55569 .15836 L p F P
0 g
s
.745 .635 .738 r
.45099 .07935 m .50422 .07683 L .50442 .09042 L p F P
0 g
s
.745 .635 .738 r
.50442 .09042 m .45164 .09298 L .45099 .07935 L p F P
0 g
s
.705 .602 .739 r
.55803 .09053 m .50442 .09042 L .50422 .07683 L p F P
0 g
s
.705 .602 .739 r
.50422 .07683 m .55827 .07694 L .55803 .09053 L p F P
0 g
s
.662 .567 .737 r
.61067 .09331 m .55803 .09053 L .55827 .07694 L p F P
0 g
s
.663 .559 .727 r
.55803 .09053 m .61067 .09331 L .60977 .10696 L p F P
0 g
s
.742 .581 .675 r
.50699 .17159 m .45974 .1742 L .4579 .16087 L p F P
0 g
s
.741 .571 .663 r
.45974 .1742 m .50699 .17159 L .50763 .1848 L p F P
0 g
s
.704 .542 .666 r
.50699 .17159 m .55501 .1717 L .55425 .18491 L p F P
0 g
s
.704 .542 .666 r
.55425 .18491 m .50763 .1848 L .50699 .17159 L p F P
0 g
s
0 1 0 r
.007 w
.52181 .19561 m
.52271 .18484 L
s
.5 Mabswid
.666 .509 .663 r
.55501 .1717 m .60212 .17454 L .59999 .18772 L p F P
0 g
s
.666 .509 .663 r
.59999 .18772 m .55425 .18491 L .55501 .1717 L p F P
0 g
s
.745 .643 .748 r
.45054 .06577 m .50408 .06329 L .50422 .07683 L p F P
0 g
s
.745 .643 .748 r
.50422 .07683 m .45099 .07935 L .45054 .06577 L p F P
0 g
s
.704 .61 .749 r
.55827 .07694 m .50422 .07683 L .50408 .06329 L p F P
0 g
s
.704 .61 .749 r
.50408 .06329 m .55844 .0634 L .55827 .07694 L p F P
0 g
s
.661 .574 .747 r
.61136 .07968 m .55827 .07694 L .55844 .0634 L p F P
0 g
s
.662 .567 .737 r
.55827 .07694 m .61136 .07968 L .61067 .09331 L p F P
0 g
s
.741 .571 .663 r
.50763 .1848 m .46176 .18739 L .45974 .1742 L p F P
0 g
s
.74 .561 .651 r
.46176 .18739 m .50763 .1848 L .50833 .19785 L p F P
0 g
s
.704 .533 .654 r
.50763 .1848 m .55425 .18491 L .55343 .19795 L p F P
0 g
s
.704 .533 .654 r
.55343 .19795 m .50833 .19785 L .50763 .1848 L p F P
0 g
s
.666 .5 .651 r
.55425 .18491 m .59999 .18772 L .59766 .20072 L p F P
0 g
s
.666 .5 .651 r
.59766 .20072 m .55343 .19795 L .55425 .18491 L p F P
0 g
s
0 0 .688 r
.47048 .04917 m .4705 .05174 L .45914 .04997 L closepath p F P
0 g
s
0 0 .42 r
.4705 .05174 m .47052 .05324 L .45914 .04997 L closepath p F P
0 g
s
0 0 .954 r
.47052 .05324 m .47052 .05278 L .45914 .04997 L closepath p F P
0 g
s
0 0 .836 r
.47052 .05278 m .47051 .05063 L .45914 .04997 L closepath p F P
0 g
s
.745 .652 .757 r
.4503 .05227 m .504 .04984 L .50408 .06329 L p F P
0 g
s
.745 .652 .757 r
.50408 .06329 m .45054 .06577 L .4503 .05227 L p F P
0 g
s
.703 .618 .759 r
.55844 .0634 m .50408 .06329 L .504 .04984 L p F P
0 g
s
.703 .618 .759 r
.504 .04984 m .55853 .04995 L .55844 .0634 L p F P
0 g
s
1 0 0 r
.007 w
.52217 .0496 m
.52217 .04988 L
s
.5 Mabswid
.659 .582 .757 r
.61183 .06609 m .55844 .0634 L .55853 .04995 L p F P
0 g
s
.661 .574 .747 r
.55844 .0634 m .61183 .06609 L .61136 .07968 L p F P
0 g
s
0 0 .834 r
.47047 .04702 m .47048 .04917 L .45914 .04997 L closepath p F P
0 g
s
.783 .637 .7 r
.40465 .12556 m .45355 .12027 L .45481 .13388 L p F P
0 g
s
.783 .637 .7 r
.45481 .13388 m .40673 .13919 L .40465 .12556 L p F P
0 g
s
.782 .627 .689 r
.40673 .13919 m .45481 .13388 L .45626 .14742 L p F P
0 g
s
.74 .561 .651 r
.50833 .19785 m .46396 .20039 L .46176 .18739 L p F P
0 g
s
.738 .55 .639 r
.46396 .20039 m .50833 .19785 L .50908 .2107 L p F P
0 g
s
.703 .523 .642 r
.50833 .19785 m .55343 .19795 L .55254 .21081 L p F P
0 g
s
.703 .523 .642 r
.55254 .21081 m .50908 .2107 L .50833 .19785 L p F P
0 g
s
.784 .647 .71 r
.40289 .11187 m .45249 .10663 L .45355 .12027 L p F P
0 g
s
.784 .647 .71 r
.45355 .12027 m .40465 .12556 L .40289 .11187 L p F P
0 g
s
.782 .627 .689 r
.45626 .14742 m .40915 .15274 L .40673 .13919 L p F P
0 g
s
.781 .617 .677 r
.40915 .15274 m .45626 .14742 L .4579 .16087 L p F P
0 g
s
0 0 .952 r
.47047 .04656 m .47047 .04702 L .45914 .04997 L closepath p F P
0 g
s
.665 .49 .638 r
.55343 .19795 m .59766 .20072 L .59515 .21352 L p F P
0 g
s
.665 .49 .638 r
.59515 .21352 m .55254 .21081 L .55343 .19795 L p F P
0 g
s
0 0 1 r
.007 w
.50759 .04968 m
.52217 .0496 L
s
.4858 .04981 m
.50759 .04968 L
s
.5 Mabswid
0 0 .835 r
.60491 .04801 m .60533 .05018 L .59367 .04966 L closepath p F P
0 g
s
0 0 .998 r
.60383 .04748 m .60491 .04801 L .59367 .04966 L closepath p F P
0 g
s
0 0 .276 r
.60273 .04892 m .60383 .04748 L .59367 .04966 L closepath p F P
0 g
s
0 0 .691 r
.60533 .05018 m .60486 .05273 L .59367 .04966 L closepath p F P
0 g
s
0 0 .648 r
.60226 .05147 m .60273 .04892 L .59367 .04966 L closepath p F P
0 g
s
0 0 .469 r
.60486 .05273 m .60377 .05417 L .59367 .04966 L closepath p F P
0 g
s
0 0 .825 r
.60269 .05365 m .60226 .05147 L .59367 .04966 L closepath p F P
0 g
s
0 0 .677 r
.60377 .05417 m .60269 .05365 L .59367 .04966 L closepath p F P
0 g
s
.617 .501 .699 r
.65511 .13974 m .60733 .13421 L .60865 .12061 L p F P
0 g
s
.619 .493 .688 r
.60733 .13421 m .65511 .13974 L .65262 .15329 L p F P
0 g
s
.619 .493 .688 r
.65262 .15329 m .60579 .14776 L .60733 .13421 L p F P
0 g
s
.785 .657 .721 r
.40147 .09816 m .45164 .09298 L .45249 .10663 L p F P
0 g
s
.785 .657 .721 r
.45249 .10663 m .40289 .11187 L .40147 .09816 L p F P
0 g
s
.781 .617 .677 r
.4579 .16087 m .41188 .16618 L .40915 .15274 L p F P
0 g
s
.779 .606 .666 r
.41188 .16618 m .4579 .16087 L .45974 .1742 L p F P
0 g
s
.616 .509 .709 r
.65726 .12611 m .60865 .12061 L .60977 .10696 L p F P
0 g
s
.617 .501 .699 r
.60865 .12061 m .65726 .12611 L .65511 .13974 L p F P
0 g
s
.62 .485 .676 r
.60579 .14776 m .65262 .15329 L .6498 .16673 L p F P
0 g
s
.62 .485 .676 r
.6498 .16673 m .60406 .16121 L .60579 .14776 L p F P
0 g
s
.659 .582 .757 r
.55853 .04995 m .61208 .05258 L .61183 .06609 L p F P
0 g
s
0 0 .421 r
.47049 .04805 m .47047 .04656 L .45914 .04997 L closepath p F P
0 g
s
0 0 .689 r
.47051 .05063 m .47049 .04805 L .45914 .04997 L closepath p F P
0 g
s
0 0 1 r
.007 w
.4705 .0499 m
.4858 .04981 L
s
.5 Mabswid
0 0 0 r
.65295 .10688 m .65281 .1075 L .64955 .1182 L closepath p F P
0 g
s
.478 0 0 r
.65121 .1064 m .65295 .10688 L .64955 .1182 L closepath p F P
0 g
s
.688 0 0 r
.64859 .10633 m .65121 .1064 L .64955 .1182 L closepath p F P
0 g
s
.841 0 0 r
.64664 .10672 m .64859 .10633 L .64955 .1182 L closepath p F P
0 g
s
.91 0 0 r
.64649 .10734 m .64664 .10672 L .64955 .1182 L closepath p F P
0 g
s
.415 0 0 r
.64823 .10782 m .64649 .10734 L .64955 .1182 L closepath p F P
0 g
s
.675 0 0 r
.65085 .10789 m .64823 .10782 L .64955 .1182 L closepath p F P
0 g
s
.846 0 0 r
.65281 .1075 m .65085 .10789 L .64955 .1182 L closepath p F P
0 g
s
.615 .517 .72 r
.65907 .11242 m .60977 .10696 L .61067 .09331 L p F P
0 g
s
.616 .509 .709 r
.60977 .10696 m .65907 .11242 L .65726 .12611 L p F P
0 g
s
.621 .477 .665 r
.60406 .16121 m .6498 .16673 L .64666 .18002 L p F P
0 g
s
.621 .477 .665 r
.64666 .18002 m .60212 .17454 L .60406 .16121 L p F P
0 g
s
.786 .666 .731 r
.40039 .08446 m .45099 .07935 L .45164 .09298 L p F P
0 g
s
.786 .666 .731 r
.45164 .09298 m .40147 .09816 L .40039 .08446 L p F P
0 g
s
.779 .606 .666 r
.45974 .1742 m .41492 .17948 L .41188 .16618 L p F P
0 g
s
.777 .596 .654 r
.41492 .17948 m .45974 .1742 L .46176 .18739 L p F P
0 g
s
.738 .55 .639 r
.50908 .2107 m .46635 .2132 L .46396 .20039 L p F P
0 g
s
.736 .539 .626 r
.46635 .2132 m .50908 .2107 L .5099 .22333 L p F P
0 g
s
.702 .512 .629 r
.50908 .2107 m .55254 .21081 L .55158 .22344 L p F P
0 g
s
.702 .512 .629 r
.55158 .22344 m .5099 .22333 L .50908 .2107 L p F P
0 g
s
.613 .525 .731 r
.66054 .0987 m .61067 .09331 L .61136 .07968 L p F P
0 g
s
.615 .517 .72 r
.61067 .09331 m .66054 .0987 L .65907 .11242 L p F P
0 g
s
.622 .468 .653 r
.60212 .17454 m .64666 .18002 L .6432 .19315 L p F P
0 g
s
.622 .468 .653 r
.6432 .19315 m .59999 .18772 L .60212 .17454 L p F P
0 g
s
0 1 0 r
.007 w
.64157 .19294 m
.65518 .20301 L
s
.5 Mabswid
.665 .48 .625 r
.55254 .21081 m .59515 .21352 L .59245 .22608 L p F P
0 g
s
.665 .48 .625 r
.59245 .22608 m .55158 .22344 L .55254 .21081 L p F P
0 g
s
.786 .675 .742 r
.39965 .07079 m .45054 .06577 L .45099 .07935 L p F P
0 g
s
.786 .675 .742 r
.45099 .07935 m .40039 .08446 L .39965 .07079 L p F P
0 g
s
.777 .596 .654 r
.46176 .18739 m .41828 .1926 L .41492 .17948 L p F P
0 g
s
.775 .584 .641 r
.41828 .1926 m .46176 .18739 L .46396 .20039 L p F P
0 g
s
1 1 0 r
.007 w
.53627 .05096 m
.51536 .05101 L
s
.55714 .05128 m
.53627 .05096 L
s
.5 Mabswid
.611 .532 .741 r
.66166 .08499 m .61136 .07968 L .61183 .06609 L p F P
0 g
s
.613 .525 .731 r
.61136 .07968 m .66166 .08499 L .66054 .0987 L p F P
0 g
s
1 1 0 r
.007 w
.49452 .05146 m
.51536 .05101 L
s
.5 Mabswid
.623 .459 .64 r
.59999 .18772 m .6432 .19315 L .63943 .20607 L p F P
0 g
s
.623 .459 .64 r
.63943 .20607 m .59766 .20072 L .59999 .18772 L p F P
0 g
s
0 .66 0 r
.52372 .32851 m .52633 .32863 L .52473 .33842 L closepath p F P
0 g
s
0 .781 0 r
.52178 .32983 m .52372 .32851 L .52473 .33842 L closepath p F P
0 g
s
0 .747 0 r
.52165 .3318 m .52178 .32983 L .52473 .33842 L closepath p F P
0 g
s
0 .349 0 r
.52341 .33328 m .52165 .3318 L .52473 .33842 L closepath p F P
0 g
s
0 .45 0 r
.52633 .32863 m .5281 .33011 L .52473 .33842 L closepath p F P
0 g
s
0 .771 0 r
.52603 .3334 m .52341 .33328 L .52473 .33842 L closepath p F P
0 g
s
0 0 0 r
.5281 .33011 m .52797 .33208 L .52473 .33842 L closepath p F P
0 g
s
0 .986 0 r
.52797 .33208 m .52603 .3334 L .52473 .33842 L closepath p F P
0 g
s
1 1 0 r
.007 w
.55714 .05128 m
.57787 .05198 L
s
.5 Mabswid
.786 .685 .752 r
.39925 .05718 m .4503 .05227 L .45054 .06577 L p F P
0 g
s
.786 .685 .752 r
.45054 .06577 m .39965 .07079 L .39925 .05718 L p F P
0 g
s
1 1 0 r
.007 w
.47386 .05228 m
.49452 .05146 L
s
.5 Mabswid
.775 .584 .641 r
.46396 .20039 m .42193 .20554 L .41828 .1926 L p F P
0 g
s
.772 .572 .628 r
.42193 .20554 m .46396 .20039 L .46635 .2132 L p F P
0 g
s
.736 .539 .626 r
.5099 .22333 m .46891 .22577 L .46635 .2132 L p F P
0 g
s
.734 .527 .612 r
.46891 .22577 m .5099 .22333 L .51076 .23572 L p F P
0 g
s
.7 .501 .615 r
.5099 .22333 m .55158 .22344 L .55056 .23582 L p F P
0 g
s
.7 .501 .615 r
.55056 .23582 m .51076 .23572 L .5099 .22333 L p F P
0 g
s
.665 .47 .611 r
.55158 .22344 m .59245 .22608 L .58957 .23839 L p F P
0 g
s
.665 .47 .611 r
.58957 .23839 m .55056 .23582 L .55158 .22344 L p F P
0 g
s
.609 .54 .752 r
.66242 .07131 m .61183 .06609 L .61208 .05258 L p F P
0 g
s
.611 .532 .741 r
.61183 .06609 m .66242 .07131 L .66166 .08499 L p F P
0 g
s
.623 .45 .627 r
.59766 .20072 m .63943 .20607 L .63535 .21876 L p F P
0 g
s
.623 .45 .627 r
.63535 .21876 m .59515 .21352 L .59766 .20072 L p F P
0 g
s
1 1 0 r
.007 w
.57787 .05198 m
.59835 .05307 L
s
.47386 .05228 m
.45348 .05348 L
s
.5 Mabswid
.772 .572 .628 r
.46635 .2132 m .42589 .21824 L .42193 .20554 L p F P
0 g
s
.769 .56 .615 r
.42589 .21824 m .46635 .2132 L .46891 .22577 L p F P
0 g
s
.609 .54 .752 r
.61208 .05258 m .66283 .05769 L .66242 .07131 L p F P
0 g
s
1 0 0 r
.007 w
.6505 .05645 m
.65051 .05619 L
s
0 1 0 r
.65051 .05619 m
.67537 .04525 L
s
0 0 1 r
.62434 .05319 m
.65051 .05619 L
s
.60241 .05067 m
.62434 .05319 L
s
.5 Mabswid
.624 .441 .614 r
.59515 .21352 m .63535 .21876 L .63098 .2312 L p F P
0 g
s
.624 .441 .614 r
.63098 .2312 m .59245 .22608 L .59515 .21352 L p F P
0 g
s
.734 .527 .612 r
.51076 .23572 m .47164 .23809 L .46891 .22577 L p F P
0 g
s
.731 .514 .597 r
.47164 .23809 m .51076 .23572 L .51168 .24783 L p F P
0 g
s
.699 .489 .601 r
.51076 .23572 m .55056 .23582 L .54948 .24792 L p F P
0 g
s
.699 .489 .601 r
.54948 .24792 m .51168 .24783 L .51076 .23572 L p F P
0 g
s
.664 .459 .597 r
.55056 .23582 m .58957 .23839 L .58651 .2504 L p F P
0 g
s
.664 .459 .597 r
.58651 .2504 m .54948 .24792 L .55056 .23582 L p F P
0 g
s
1 1 0 r
.007 w
.59835 .05307 m
.61847 .05453 L
s
.5 Mabswid
.447 0 0 r
.39783 .10803 m .39938 .10852 L .39623 .11987 L closepath p F P
0 g
s
.856 0 0 r
.39938 .10852 m .39897 .10914 L .39623 .11987 L closepath p F P
0 g
s
.687 0 0 r
.39524 .10797 m .39783 .10803 L .39623 .11987 L closepath p F P
0 g
s
.833 0 0 r
.39311 .10836 m .39524 .10797 L .39623 .11987 L closepath p F P
0 g
s
.979 0 0 r
.3927 .10898 m .39311 .10836 L .39623 .11987 L closepath p F P
0 g
s
.367 0 0 r
.39425 .10947 m .3927 .10898 L .39623 .11987 L closepath p F P
0 g
s
.674 0 0 r
.39685 .10953 m .39425 .10947 L .39623 .11987 L closepath p F P
0 g
s
.838 0 0 r
.39897 .10914 m .39685 .10953 L .39623 .11987 L closepath p F P
0 g
s
.769 .56 .615 r
.46891 .22577 m .43013 .23069 L .42589 .21824 L p F P
0 g
s
.766 .547 .601 r
.43013 .23069 m .46891 .22577 L .47164 .23809 L p F P
0 g
s
1 1 0 r
.007 w
.4335 .05505 m
.45348 .05348 L
s
.5 Mabswid
.624 .43 .599 r
.59245 .22608 m .63098 .2312 L .62632 .24336 L p F P
0 g
s
.624 .43 .599 r
.62632 .24336 m .58957 .23839 L .59245 .22608 L p F P
0 g
s
.822 .653 .673 r
.36298 .14707 m .40673 .13919 L .40915 .15274 L p F P
0 g
s
.822 .653 .673 r
.40915 .15274 m .36629 .16063 L .36298 .14707 L p F P
0 g
s
.82 .641 .661 r
.36629 .16063 m .40915 .15274 L .41188 .16618 L p F P
0 g
s
.824 .664 .685 r
.36011 .1334 m .40465 .12556 L .40673 .13919 L p F P
0 g
s
.824 .664 .685 r
.40673 .13919 m .36298 .14707 L .36011 .1334 L p F P
0 g
s
.82 .641 .661 r
.41188 .16618 m .37004 .17404 L .36629 .16063 L p F P
0 g
s
.817 .629 .648 r
.37004 .17404 m .41188 .16618 L .41492 .17948 L p F P
0 g
s
.826 .676 .696 r
.3577 .11965 m .40289 .11187 L .40465 .12556 L p F P
0 g
s
.826 .676 .696 r
.40465 .12556 m .36011 .1334 L .3577 .11965 L p F P
0 g
s
.731 .514 .597 r
.51168 .24783 m .47453 .25011 L .47164 .23809 L p F P
0 g
s
.728 .501 .582 r
.47453 .25011 m .51168 .24783 L .51265 .25963 L p F P
0 g
s
.697 .477 .585 r
.51168 .24783 m .54948 .24792 L .54833 .25973 L p F P
0 g
s
.697 .477 .585 r
.54833 .25973 m .51265 .25963 L .51168 .24783 L p F P
0 g
s
.663 .447 .581 r
.54948 .24792 m .58651 .2504 L .58329 .2621 L p F P
0 g
s
.663 .447 .581 r
.58329 .2621 m .54833 .25973 L .54948 .24792 L p F P
0 g
s
.817 .629 .648 r
.41492 .17948 m .37423 .18728 L .37004 .17404 L p F P
0 g
s
.814 .617 .636 r
.37423 .18728 m .41492 .17948 L .41828 .1926 L p F P
0 g
s
0 1 0 r
.007 w
.39022 .20485 m
.40961 .19156 L
s
.5 Mabswid
.827 .687 .708 r
.35574 .10586 m .40147 .09816 L .40289 .11187 L p F P
0 g
s
.827 .687 .708 r
.40289 .11187 m .3577 .11965 L .35574 .10586 L p F P
0 g
s
1 1 0 r
.007 w
.61847 .05453 m
.63812 .05636 L
s
.5 Mabswid
.563 .441 .671 r
.69505 .16138 m .65262 .15329 L .65511 .13974 L p F P
0 g
s
.566 .433 .659 r
.65262 .15329 m .69505 .16138 L .69122 .17479 L p F P
0 g
s
.566 .433 .659 r
.69122 .17479 m .6498 .16673 L .65262 .15329 L p F P
0 g
s
.561 .449 .683 r
.69843 .14782 m .65511 .13974 L .65726 .12611 L p F P
0 g
s
.563 .441 .671 r
.65511 .13974 m .69843 .14782 L .69505 .16138 L p F P
0 g
s
.766 .547 .601 r
.47164 .23809 m .43465 .24286 L .43013 .23069 L p F P
0 g
s
.763 .533 .586 r
.43465 .24286 m .47164 .23809 L .47453 .25011 L p F P
0 g
s
.568 .425 .647 r
.6498 .16673 m .69122 .17479 L .68695 .18803 L p F P
0 g
s
.568 .425 .647 r
.68695 .18803 m .64666 .18002 L .6498 .16673 L p F P
0 g
s
.558 .457 .695 r
.70136 .13415 m .65726 .12611 L .65907 .11242 L p F P
0 g
s
.561 .449 .683 r
.65726 .12611 m .70136 .13415 L .69843 .14782 L p F P
0 g
s
.625 .42 .584 r
.58957 .23839 m .62632 .24336 L .62138 .2552 L p F P
0 g
s
.625 .42 .584 r
.62138 .2552 m .58651 .2504 L .58957 .23839 L p F P
0 g
s
.814 .617 .636 r
.41828 .1926 m .37883 .20033 L .37423 .18728 L p F P
0 g
s
.811 .604 .622 r
.37883 .20033 m .41828 .1926 L .42193 .20554 L p F P
0 g
s
.57 .416 .634 r
.64666 .18002 m .68695 .18803 L .68225 .20107 L p F P
0 g
s
.57 .416 .634 r
.68225 .20107 m .6432 .19315 L .64666 .18002 L p F P
0 g
s
.829 .697 .719 r
.35425 .09204 m .40039 .08446 L .40147 .09816 L p F P
0 g
s
1 0 0 r
.007 w
.39585 .09744 m
.39588 .09911 L
s
.5 Mabswid
.829 .697 .719 r
.40147 .09816 m .35574 .10586 L .35425 .09204 L p F P
0 g
s
.556 .464 .706 r
.70383 .1204 m .65907 .11242 L .66054 .0987 L p F P
0 g
s
.558 .457 .695 r
.65907 .11242 m .70383 .1204 L .70136 .13415 L p F P
0 g
s
1 1 0 r
.007 w
.41401 .05699 m
.4335 .05505 L
s
.5 Mabswid
.572 .408 .62 r
.6432 .19315 m .68225 .20107 L .67713 .21387 L p F P
0 g
s
.572 .408 .62 r
.67713 .21387 m .63943 .20607 L .6432 .19315 L p F P
0 g
s
0 .642 0 r
.60114 .33483 m .60371 .33449 L .60485 .34471 L closepath p F P
0 g
s
0 .719 0 r
.59927 .33644 m .60114 .33483 L .60485 .34471 L closepath p F P
0 g
s
0 .67 0 r
.59921 .33835 m .59927 .33644 L .60485 .34471 L closepath p F P
0 g
s
0 .36 0 r
.60099 .33947 m .59921 .33835 L .60485 .34471 L closepath p F P
0 g
s
0 .782 0 r
.60357 .33912 m .60099 .33947 L .60485 .34471 L closepath p F P
0 g
s
0 0 0 r
.60549 .33559 m .60543 .33751 L .60485 .34471 L closepath p F P
0 g
s
0 .431 0 r
.60371 .33449 m .60549 .33559 L .60485 .34471 L closepath p F P
0 g
s
0 .921 0 r
.60543 .33751 m .60357 .33912 L .60485 .34471 L closepath p F P
0 g
s
.553 .472 .718 r
.70582 .10659 m .66054 .0987 L .66166 .08499 L p F P
0 g
s
.556 .464 .706 r
.66054 .0987 m .70582 .10659 L .70383 .1204 L p F P
0 g
s
.811 .604 .622 r
.42193 .20554 m .38384 .21314 L .37883 .20033 L p F P
0 g
s
.807 .591 .609 r
.38384 .21314 m .42193 .20554 L .42589 .21824 L p F P
0 g
s
.83 .708 .731 r
.35323 .07823 m .39965 .07079 L .40039 .08446 L p F P
0 g
s
.83 .708 .731 r
.40039 .08446 m .35425 .09204 L .35323 .07823 L p F P
0 g
s
.728 .501 .582 r
.51265 .25963 m .47759 .26182 L .47453 .25011 L p F P
0 g
s
.725 .486 .565 r
.47759 .26182 m .51265 .25963 L .51367 .27111 L p F P
0 g
s
.694 .463 .569 r
.51265 .25963 m .54833 .25973 L .54713 .2712 L p F P
0 g
s
.694 .463 .569 r
.54713 .2712 m .51367 .27111 L .51265 .25963 L p F P
0 g
s
.661 .434 .564 r
.54833 .25973 m .58329 .2621 L .5799 .27346 L p F P
0 g
s
.661 .434 .564 r
.5799 .27346 m .54713 .2712 L .54833 .25973 L p F P
0 g
s
.763 .533 .586 r
.47453 .25011 m .43944 .25472 L .43465 .24286 L p F P
0 g
s
.758 .518 .57 r
.43944 .25472 m .47453 .25011 L .47759 .26182 L p F P
0 g
s
.574 .399 .607 r
.63943 .20607 m .67713 .21387 L .6716 .22641 L p F P
0 g
s
.574 .399 .607 r
.6716 .22641 m .63535 .21876 L .63943 .20607 L p F P
0 g
s
.55 .48 .729 r
.70735 .09277 m .66166 .08499 L .66242 .07131 L p F P
0 g
s
.553 .472 .718 r
.66166 .08499 m .70735 .09277 L .70582 .10659 L p F P
0 g
s
.625 .408 .568 r
.58651 .2504 m .62138 .2552 L .61616 .2667 L p F P
0 g
s
.625 .408 .568 r
.61616 .2667 m .58329 .2621 L .58651 .2504 L p F P
0 g
s
.807 .591 .609 r
.42589 .21824 m .38925 .22569 L .38384 .21314 L p F P
0 g
s
.803 .577 .595 r
.38925 .22569 m .42589 .21824 L .43013 .23069 L p F P
0 g
s
.83 .719 .742 r
.35268 .06447 m .39925 .05718 L .39965 .07079 L p F P
0 g
s
1 0 0 r
.007 w
.39517 .0577 m
.39517 .05782 L
s
0 1 0 r
.36796 .04714 m
.39517 .0577 L
s
.5 Mabswid
.83 .719 .742 r
.39965 .07079 m .35323 .07823 L .35268 .06447 L p F P
0 g
s
0 .65 0 r
.44744 .33581 m .44999 .33649 L .44558 .34614 L closepath p F P
0 g
s
0 .812 0 r
.44541 .33662 m .44744 .33581 L .44558 .34614 L closepath p F P
0 g
s
0 .781 0 r
.44509 .33845 m .44541 .33662 L .44558 .34614 L closepath p F P
0 g
s
0 .352 0 r
.44666 .34021 m .44509 .33845 L .44558 .34614 L closepath p F P
0 g
s
0 .442 0 r
.44999 .33649 m .45156 .33825 L .44558 .34614 L closepath p F P
0 g
s
0 .715 0 r
.44921 .34089 m .44666 .34021 L .44558 .34614 L closepath p F P
0 g
s
0 0 0 r
.45156 .33825 m .45124 .34007 L .44558 .34614 L closepath p F P
0 g
s
0 .978 0 r
.45124 .34007 m .44921 .34089 L .44558 .34614 L closepath p F P
0 g
s
1 1 0 r
.007 w
.63812 .05636 m
.65719 .05855 L
s
.5 Mabswid
.575 .389 .592 r
.63535 .21876 m .6716 .22641 L .66568 .23866 L p F P
0 g
s
.575 .389 .592 r
.66568 .23866 m .63098 .2312 L .63535 .21876 L p F P
0 g
s
.547 .488 .741 r
.70839 .07895 m .66242 .07131 L .66283 .05769 L p F P
0 g
s
.55 .48 .729 r
.66242 .07131 m .70839 .07895 L .70735 .09277 L p F P
0 g
s
1 1 0 r
.007 w
.39514 .0593 m
.41401 .05699 L
s
.5 Mabswid
.803 .577 .595 r
.43013 .23069 m .39506 .23796 L .38925 .22569 L p F P
0 g
s
.799 .562 .58 r
.39506 .23796 m .43013 .23069 L .43465 .24286 L p F P
0 g
s
.758 .518 .57 r
.47759 .26182 m .44449 .26624 L .43944 .25472 L p F P
0 g
s
.754 .503 .553 r
.44449 .26624 m .47759 .26182 L .4808 .27319 L p F P
0 g
s
.725 .486 .565 r
.51367 .27111 m .4808 .27319 L .47759 .26182 L p F P
0 g
s
.577 .38 .577 r
.63098 .2312 m .66568 .23866 L .65937 .25058 L p F P
0 g
s
.577 .38 .577 r
.65937 .25058 m .62632 .24336 L .63098 .2312 L p F P
0 g
s
.721 .471 .547 r
.4808 .27319 m .51367 .27111 L .51474 .28222 L p F P
0 g
s
.692 .449 .551 r
.51367 .27111 m .54713 .2712 L .54587 .28231 L p F P
0 g
s
.692 .449 .551 r
.54587 .28231 m .51474 .28222 L .51367 .27111 L p F P
0 g
s
.66 .42 .546 r
.54713 .2712 m .5799 .27346 L .57635 .28444 L p F P
0 g
s
.66 .42 .546 r
.57635 .28444 m .54587 .28231 L .54713 .2712 L p F P
0 g
s
.625 .396 .551 r
.58329 .2621 m .61616 .2667 L .61069 .27783 L p F P
0 g
s
.625 .396 .551 r
.61069 .27783 m .5799 .27346 L .58329 .2621 L p F P
0 g
s
.547 .488 .741 r
.66283 .05769 m .70895 .06517 L .70839 .07895 L p F P
0 g
s
.799 .562 .58 r
.43465 .24286 m .40124 .24991 L .39506 .23796 L p F P
0 g
s
.793 .546 .564 r
.40124 .24991 m .43465 .24286 L .43944 .25472 L p F P
0 g
s
.579 .37 .562 r
.62632 .24336 m .65937 .25058 L .65269 .26216 L p F P
0 g
s
.579 .37 .562 r
.65269 .26216 m .62138 .2552 L .62632 .24336 L p F P
0 g
s
1 1 0 r
.007 w
.65719 .05855 m
.67557 .0611 L
s
.5 Mabswid
.754 .503 .553 r
.4808 .27319 m .4498 .27739 L .44449 .26624 L p F P
0 g
s
.748 .486 .534 r
.4498 .27739 m .4808 .27319 L .48417 .28419 L p F P
0 g
s
.721 .471 .547 r
.51474 .28222 m .48417 .28419 L .4808 .27319 L p F P
0 g
s
.624 .384 .533 r
.5799 .27346 m .61069 .27783 L .60496 .28856 L p F P
0 g
s
.624 .384 .533 r
.60496 .28856 m .57635 .28444 L .5799 .27346 L p F P
0 g
s
1 1 0 r
.007 w
.37699 .06196 m
.39514 .0593 L
s
.5 Mabswid
.793 .546 .564 r
.43944 .25472 m .40778 .26151 L .40124 .24991 L p F P
0 g
s
.788 .53 .547 r
.40778 .26151 m .43944 .25472 L .44449 .26624 L p F P
0 g
s
.716 .454 .528 r
.48417 .28419 m .51474 .28222 L .51586 .29295 L p F P
0 g
s
.688 .433 .532 r
.51474 .28222 m .54587 .28231 L .54456 .29303 L p F P
0 g
s
.688 .433 .532 r
.54456 .29303 m .51586 .29295 L .51474 .28222 L p F P
0 g
s
.658 .406 .527 r
.54587 .28231 m .57635 .28444 L .57265 .29502 L p F P
0 g
s
.658 .406 .527 r
.57265 .29502 m .54456 .29303 L .54587 .28231 L p F P
0 g
s
.58 .359 .545 r
.62138 .2552 m .65269 .26216 L .64565 .27337 L p F P
0 g
s
.58 .359 .545 r
.64565 .27337 m .61616 .2667 L .62138 .2552 L p F P
0 g
s
.788 .53 .547 r
.44449 .26624 m .41468 .27275 L .40778 .26151 L p F P
0 g
s
.781 .513 .53 r
.41468 .27275 m .44449 .26624 L .4498 .27739 L p F P
0 g
s
.862 .663 .632 r
.32944 .17087 m .36629 .16063 L .37004 .17404 L p F P
0 g
s
.862 .663 .632 r
.37004 .17404 m .33412 .18425 L .32944 .17087 L p F P
0 g
s
.858 .649 .618 r
.33412 .18425 m .37004 .17404 L .37423 .18728 L p F P
0 g
s
.866 .677 .645 r
.32532 .15732 m .36298 .14707 L .36629 .16063 L p F P
0 g
s
.866 .677 .645 r
.36629 .16063 m .32944 .17087 L .32532 .15732 L p F P
0 g
s
.748 .486 .534 r
.48417 .28419 m .45535 .28815 L .4498 .27739 L p F P
0 g
s
.742 .467 .515 r
.45535 .28815 m .48417 .28419 L .48767 .29479 L p F P
0 g
s
.716 .454 .528 r
.51586 .29295 m .48767 .29479 L .48417 .28419 L p F P
0 g
s
.858 .649 .618 r
.37423 .18728 m .33932 .19742 L .33412 .18425 L p F P
0 g
s
.854 .634 .604 r
.33932 .19742 m .37423 .18728 L .37883 .20033 L p F P
0 g
s
.869 .691 .658 r
.32174 .14361 m .36011 .1334 L .36298 .14707 L p F P
0 g
s
.869 .691 .658 r
.36298 .14707 m .32532 .15732 L .32174 .14361 L p F P
0 g
s
.581 .348 .527 r
.61616 .2667 m .64565 .27337 L .63826 .28417 L p F P
0 g
s
.581 .348 .527 r
.63826 .28417 m .61069 .27783 L .61616 .2667 L p F P
0 g
s
.623 .37 .513 r
.57635 .28444 m .60496 .28856 L .599 .29887 L p F P
0 g
s
.623 .37 .513 r
.599 .29887 m .57265 .29502 L .57635 .28444 L p F P
0 g
s
1 1 0 r
.007 w
.67557 .0611 m
.69316 .06401 L
s
.5 Mabswid
.854 .634 .604 r
.37883 .20033 m .34504 .21034 L .33932 .19742 L p F P
0 g
s
.849 .619 .59 r
.34504 .21034 m .37883 .20033 L .38384 .21314 L p F P
0 g
s
.872 .704 .671 r
.31873 .12978 m .3577 .11965 L .36011 .1334 L p F P
0 g
s
.872 .704 .671 r
.36011 .1334 m .32174 .14361 L .31873 .12978 L p F P
0 g
s
.495 .362 .629 r
.72659 .18519 m .69122 .17479 L .69505 .16138 L p F P
0 g
s
.499 .354 .615 r
.69122 .17479 m .72659 .18519 L .72131 .19835 L p F P
0 g
s
.499 .354 .615 r
.72131 .19835 m .68695 .18803 L .69122 .17479 L p F P
0 g
s
.491 .37 .642 r
.73133 .17181 m .69505 .16138 L .69843 .14782 L p F P
0 g
s
.495 .362 .629 r
.69505 .16138 m .73133 .17181 L .72659 .18519 L p F P
0 g
s
.71 .435 .506 r
.48767 .29479 m .51586 .29295 L .51701 .30326 L p F P
0 g
s
.684 .416 .51 r
.51586 .29295 m .54456 .29303 L .5432 .30333 L p F P
0 g
s
.684 .416 .51 r
.5432 .30333 m .51701 .30326 L .51586 .29295 L p F P
0 g
s
0 1 0 r
.007 w
.52483 .33334 m
.52539 .30328 L
s
.5 Mabswid
.503 .346 .601 r
.68695 .18803 m .72131 .19835 L .7155 .21126 L p F P
0 g
s
.503 .346 .601 r
.7155 .21126 m .68225 .20107 L .68695 .18803 L p F P
0 g
s
.655 .389 .506 r
.54456 .29303 m .57265 .29502 L .56881 .30518 L p F P
0 g
s
.655 .389 .506 r
.56881 .30518 m .5432 .30333 L .54456 .29303 L p F P
0 g
s
.849 .619 .59 r
.38384 .21314 m .35126 .223 L .34504 .21034 L p F P
0 g
s
.844 .604 .575 r
.35126 .223 m .38384 .21314 L .38925 .22569 L p F P
0 g
s
.487 .377 .655 r
.73552 .15825 m .69843 .14782 L .70136 .13415 L p F P
0 g
s
.491 .37 .642 r
.69843 .14782 m .73552 .15825 L .73133 .17181 L p F P
0 g
s
.874 .717 .684 r
.31629 .11587 m .35574 .10586 L .3577 .11965 L p F P
0 g
s
.874 .717 .684 r
.3577 .11965 m .31873 .12978 L .31629 .11587 L p F P
0 g
s
.506 .338 .587 r
.68225 .20107 m .7155 .21126 L .70918 .2239 L p F P
0 g
s
.506 .338 .587 r
.70918 .2239 m .67713 .21387 L .68225 .20107 L p F P
0 g
s
.482 .385 .668 r
.73914 .14454 m .70136 .13415 L .70383 .1204 L p F P
0 g
s
.487 .377 .655 r
.70136 .13415 m .73914 .14454 L .73552 .15825 L p F P
0 g
s
1 1 0 r
.007 w
.35967 .06497 m
.37699 .06196 L
s
.5 Mabswid
.844 .604 .575 r
.38925 .22569 m .35798 .23535 L .35126 .223 L p F P
0 g
s
.838 .587 .56 r
.35798 .23535 m .38925 .22569 L .39506 .23796 L p F P
0 g
s
.781 .513 .53 r
.4498 .27739 m .42192 .28358 L .41468 .27275 L p F P
0 g
s
.774 .494 .511 r
.42192 .28358 m .4498 .27739 L .45535 .28815 L p F P
0 g
s
.51 .33 .572 r
.67713 .21387 m .70918 .2239 L .70237 .23623 L p F P
0 g
s
.51 .33 .572 r
.70237 .23623 m .6716 .22641 L .67713 .21387 L p F P
0 g
s
.876 .73 .697 r
.31443 .10191 m .35425 .09204 L .35574 .10586 L p F P
0 g
s
.876 .73 .697 r
.35574 .10586 m .31629 .11587 L .31443 .10191 L p F P
0 g
s
.478 .393 .681 r
.7422 .13071 m .70383 .1204 L .70582 .10659 L p F P
0 g
s
.482 .385 .668 r
.70383 .1204 m .7422 .13071 L .73914 .14454 L p F P
0 g
s
.582 .336 .508 r
.61069 .27783 m .63826 .28417 L .63054 .29453 L p F P
0 g
s
.582 .336 .508 r
.63054 .29453 m .60496 .28856 L .61069 .27783 L p F P
0 g
s
.514 .321 .557 r
.6716 .22641 m .70237 .23623 L .69507 .24822 L p F P
0 g
s
.514 .321 .557 r
.69507 .24822 m .66568 .23866 L .6716 .22641 L p F P
0 g
s
0 .674 0 r
.75798 .22545 m .75995 .22445 L .76702 .23179 L closepath p F P
0 g
s
0 .664 0 r
.75667 .22778 m .75798 .22545 L .76702 .23179 L closepath p F P
0 g
s
0 .564 0 r
.75678 .23008 m .75667 .22778 L .76702 .23179 L closepath p F P
0 g
s
0 .048 0 r
.75824 .23099 m .75678 .23008 L .76702 .23179 L closepath p F P
0 g
s
0 .879 0 r
.76021 .22999 m .75824 .23099 L .76702 .23179 L closepath p F P
0 g
s
0 .827 0 r
.76153 .22766 m .76021 .22999 L .76702 .23179 L closepath p F P
0 g
s
0 .296 0 r
.75995 .22445 m .76142 .22536 L .76702 .23179 L closepath p F P
0 g
s
0 .693 0 r
.76142 .22536 m .76153 .22766 L .76702 .23179 L closepath p F P
0 g
s
.838 .587 .56 r
.39506 .23796 m .36517 .24736 L .35798 .23535 L p F P
0 g
s
.831 .57 .544 r
.36517 .24736 m .39506 .23796 L .40124 .24991 L p F P
0 g
s
.742 .467 .515 r
.48767 .29479 m .46114 .29849 L .45535 .28815 L p F P
0 g
s
.735 .447 .493 r
.46114 .29849 m .48767 .29479 L .49132 .30496 L p F P
0 g
s
.71 .435 .506 r
.51701 .30326 m .49132 .30496 L .48767 .29479 L p F P
0 g
s
.878 .743 .709 r
.31316 .08793 m .35323 .07823 L .35425 .09204 L p F P
0 g
s
.878 .743 .709 r
.35425 .09204 m .31443 .10191 L .31316 .08793 L p F P
0 g
s
.474 .401 .694 r
.74468 .11679 m .70582 .10659 L .70735 .09277 L p F P
0 g
s
.478 .393 .681 r
.70582 .10659 m .74468 .11679 L .7422 .13071 L p F P
0 g
s
.622 .355 .492 r
.57265 .29502 m .599 .29887 L .59281 .30873 L p F P
0 g
s
0 1 0 r
.007 w
.5931 .30827 m
.60307 .33919 L
s
.5 Mabswid
.622 .355 .492 r
.59281 .30873 m .56881 .30518 L .57265 .29502 L p F P
0 g
s
0 0 .641 r
.34694 .06309 m .34747 .0657 L .33819 .06509 L closepath p F P
0 g
s
0 0 .82 r
.34736 .06087 m .34694 .06309 L .33819 .06509 L closepath p F P
0 g
s
0 0 .266 r
.34747 .0657 m .34863 .06716 L .33819 .06509 L closepath p F P
0 g
s
.518 .312 .541 r
.66568 .23866 m .69507 .24822 L .68731 .25985 L p F P
0 g
s
.518 .312 .541 r
.68731 .25985 m .65937 .25058 L .66568 .23866 L p F P
0 g
s
.831 .57 .544 r
.40124 .24991 m .37282 .25902 L .36517 .24736 L p F P
0 g
s
.824 .553 .528 r
.37282 .25902 m .40124 .24991 L .40778 .26151 L p F P
0 g
s
.469 .408 .707 r
.74657 .10282 m .70735 .09277 L .70839 .07895 L p F P
0 g
s
.474 .401 .694 r
.70735 .09277 m .74657 .10282 L .74468 .11679 L p F P
0 g
s
0 0 .659 r
.34848 .06033 m .34736 .06087 L .33819 .06509 L closepath p F P
0 g
s
0 0 .998 r
.34863 .06716 m .34976 .06663 L .33819 .06509 L closepath p F P
0 g
s
0 0 .837 r
.34976 .06663 m .35017 .0644 L .33819 .06509 L closepath p F P
0 g
s
.879 .756 .722 r
.31247 .07397 m .35268 .06447 L .35323 .07823 L p F P
0 g
s
0 0 1 r
.007 w
.36452 .06168 m
.39517 .0577 L
s
.5 Mabswid
.879 .756 .722 r
.35323 .07823 m .31316 .08793 L .31247 .07397 L p F P
0 g
s
.704 .415 .483 r
.49132 .30496 m .51701 .30326 L .51821 .31313 L p F P
0 g
s
.679 .397 .487 r
.51701 .30326 m .5432 .30333 L .54178 .31319 L p F P
0 g
s
.679 .397 .487 r
.54178 .31319 m .51821 .31313 L .51701 .30326 L p F P
0 g
s
.774 .494 .511 r
.45535 .28815 m .42948 .29398 L .42192 .28358 L p F P
0 g
s
.766 .474 .491 r
.42948 .29398 m .45535 .28815 L .46114 .29849 L p F P
0 g
s
.651 .371 .482 r
.5432 .30333 m .56881 .30518 L .56483 .31487 L p F P
0 g
s
.651 .371 .482 r
.56483 .31487 m .54178 .31319 L .5432 .30333 L p F P
0 g
s
.583 .323 .488 r
.60496 .28856 m .63054 .29453 L .62251 .30444 L p F P
0 g
s
.583 .323 .488 r
.62251 .30444 m .599 .29887 L .60496 .28856 L p F P
0 g
s
.521 .303 .524 r
.65937 .25058 m .68731 .25985 L .6791 .27108 L p F P
0 g
s
.521 .303 .524 r
.6791 .27108 m .65269 .26216 L .65937 .25058 L p F P
0 g
s
0 0 .465 r
.34964 .06179 m .34848 .06033 L .33819 .06509 L closepath p F P
0 g
s
0 0 .827 r
.72458 .06371 m .72536 .06602 L .71566 .06423 L closepath p F P
0 g
s
0 0 .987 r
.7226 .06299 m .72458 .06371 L .71566 .06423 L closepath p F P
0 g
s
0 0 0 r
.72055 .06428 m .7226 .06299 L .71566 .06423 L closepath p F P
0 g
s
0 0 .453 r
.72446 .06856 m .72243 .06985 L .71566 .06423 L closepath p F P
0 g
s
0 0 .657 r
.72536 .06602 m .72446 .06856 L .71566 .06423 L closepath p F P
0 g
s
0 0 .465 r
.71966 .06683 m .72055 .06428 L .71566 .06423 L closepath p F P
0 g
s
0 0 0 r
.72243 .06985 m .72044 .06914 L .71566 .06423 L closepath p F P
0 g
s
0 0 .677 r
.72044 .06914 m .71966 .06683 L .71566 .06423 L closepath p F P
0 g
s
.464 .416 .72 r
.74786 .08882 m .70839 .07895 L .70895 .06517 L p F P
0 g
s
.469 .408 .707 r
.70839 .07895 m .74786 .08882 L .74657 .10282 L p F P
0 g
s
.824 .553 .528 r
.40778 .26151 m .38092 .27028 L .37282 .25902 L p F P
0 g
s
.816 .534 .51 r
.38092 .27028 m .40778 .26151 L .41468 .27275 L p F P
0 g
s
0 0 .689 r
.35017 .0644 m .34964 .06179 L .33819 .06509 L closepath p F P
0 g
s
0 0 1 r
.007 w
.35 .06356 m
.36452 .06168 L
s
.5 Mabswid
.735 .447 .493 r
.49132 .30496 m .46714 .30838 L .46114 .29849 L p F P
0 g
s
.726 .426 .469 r
.46714 .30838 m .49132 .30496 L .49509 .31468 L p F P
0 g
s
.704 .415 .483 r
.51821 .31313 m .49509 .31468 L .49132 .30496 L p F P
0 g
s
.525 .294 .507 r
.65269 .26216 m .6791 .27108 L .67046 .2819 L p F P
0 g
s
.525 .294 .507 r
.67046 .2819 m .64565 .27337 L .65269 .26216 L p F P
0 g
s
1 1 0 r
.007 w
.34329 .06831 m
.35746 .06542 L
s
.35746 .06542 m
.35967 .06497 L
s
.5 Mabswid
.62 .338 .468 r
.56881 .30518 m .59281 .30873 L .5864 .31811 L p F P
0 g
s
.62 .338 .468 r
.5864 .31811 m .56483 .31487 L .56881 .30518 L p F P
0 g
s
.464 .416 .72 r
.70895 .06517 m .74855 .07484 L .74786 .08882 L p F P
0 g
s
1 1 0 r
.007 w
.69316 .06401 m
.70984 .06724 L
s
.5 Mabswid
.766 .474 .491 r
.46114 .29849 m .43735 .30393 L .42948 .29398 L p F P
0 g
s
.757 .452 .469 r
.43735 .30393 m .46114 .29849 L .46714 .30838 L p F P
0 g
s
0 1 0 r
.007 w
.44758 .34046 m
.45931 .30721 L
s
.5 Mabswid
.816 .534 .51 r
.41468 .27275 m .38944 .28113 L .38092 .27028 L p F P
0 g
s
.808 .514 .492 r
.38944 .28113 m .41468 .27275 L .42192 .28358 L p F P
0 g
s
0 .646 0 r
.29072 .22851 m .29239 .23048 L .28217 .23558 L closepath p F P
0 g
s
0 .875 0 r
.28888 .22821 m .29072 .22851 L .28217 .23558 L closepath p F P
0 g
s
0 0 0 r
.28794 .22975 m .28888 .22821 L .28217 .23558 L closepath p F P
0 g
s
0 .312 0 r
.28847 .23224 m .28794 .22975 L .28217 .23558 L closepath p F P
0 g
s
0 .129 0 r
.29292 .23296 m .29199 .23451 L .28217 .23558 L closepath p F P
0 g
s
0 .466 0 r
.29239 .23048 m .29292 .23296 L .28217 .23558 L closepath p F P
0 g
s
0 .587 0 r
.29014 .23422 m .28847 .23224 L .28217 .23558 L closepath p F P
0 g
s
0 .788 0 r
.29199 .23451 m .29014 .23422 L .28217 .23558 L closepath p F P
0 g
s
.584 .31 .466 r
.599 .29887 m .62251 .30444 L .61419 .31387 L p F P
0 g
s
.584 .31 .466 r
.61419 .31387 m .59281 .30873 L .599 .29887 L p F P
0 g
s
.528 .284 .488 r
.64565 .27337 m .67046 .2819 L .66141 .29226 L p F P
0 g
s
.528 .284 .488 r
.66141 .29226 m .63826 .28417 L .64565 .27337 L p F P
0 g
s
.696 .392 .457 r
.49509 .31468 m .51821 .31313 L .51945 .32252 L p F P
0 g
s
.673 .376 .461 r
.51821 .31313 m .54178 .31319 L .54032 .32258 L p F P
0 g
s
.673 .376 .461 r
.54032 .32258 m .51945 .32252 L .51821 .31313 L p F P
0 g
s
.647 .352 .456 r
.54178 .31319 m .56483 .31487 L .56072 .32408 L p F P
0 g
s
.647 .352 .456 r
.56072 .32408 m .54032 .32258 L .54178 .31319 L p F P
0 g
s
.808 .514 .492 r
.42192 .28358 m .39836 .29154 L .38944 .28113 L p F P
0 g
s
.798 .493 .473 r
.39836 .29154 m .42192 .28358 L .42948 .29398 L p F P
0 g
s
.532 .273 .469 r
.63826 .28417 m .66141 .29226 L .65197 .30215 L p F P
0 g
s
.532 .273 .469 r
.65197 .30215 m .63054 .29453 L .63826 .28417 L p F P
0 g
s
.726 .426 .469 r
.49509 .31468 m .47336 .31779 L .46714 .30838 L p F P
0 g
s
.717 .401 .443 r
.47336 .31779 m .49509 .31468 L .49899 .32391 L p F P
0 g
s
.696 .392 .457 r
.51945 .32252 m .49899 .32391 L .49509 .31468 L p F P
0 g
s
.618 .32 .442 r
.56483 .31487 m .5864 .31811 L .57979 .32698 L p F P
0 g
s
.618 .32 .442 r
.57979 .32698 m .56072 .32408 L .56483 .31487 L p F P
0 g
s
.757 .452 .469 r
.46714 .30838 m .44551 .31339 L .43735 .30393 L p F P
0 g
s
.746 .428 .445 r
.44551 .31339 m .46714 .30838 L .47336 .31779 L p F P
0 g
s
1 1 0 r
.007 w
.70984 .06724 m
.72551 .07081 L
s
.5 Mabswid
.584 .295 .443 r
.59281 .30873 m .61419 .31387 L .60558 .32278 L p F P
0 g
s
.584 .295 .443 r
.60558 .32278 m .5864 .31811 L .59281 .30873 L p F P
0 g
s
.798 .493 .473 r
.42948 .29398 m .40767 .30147 L .39836 .29154 L p F P
0 g
s
.788 .471 .453 r
.40767 .30147 m .42948 .29398 L .43735 .30393 L p F P
0 g
s
0 .604 0 r
.662 .35366 m .66447 .3529 L .66776 .36385 L closepath p F P
0 g
s
0 .654 0 r
.66017 .35539 m .662 .35366 L .66776 .36385 L closepath p F P
0 g
s
0 .585 0 r
.66004 .35707 m .66017 .35539 L .66776 .36385 L closepath p F P
0 g
s
0 .448 0 r
.66171 .35772 m .66004 .35707 L .66776 .36385 L closepath p F P
0 g
s
0 .747 0 r
.66419 .35696 m .66171 .35772 L .66776 .36385 L closepath p F P
0 g
s
0 .403 0 r
.66447 .3529 m .66614 .35354 L .66776 .36385 L closepath p F P
0 g
s
0 .823 0 r
.66603 .35522 m .66419 .35696 L .66776 .36385 L closepath p F P
0 g
s
0 .711 0 r
.66614 .35354 m .66603 .35522 L .66776 .36385 L closepath p F P
0 g
s
.535 .262 .449 r
.63054 .29453 m .65197 .30215 L .64216 .31154 L p F P
0 g
s
.535 .262 .449 r
.64216 .31154 m .62251 .30444 L .63054 .29453 L p F P
0 g
s
1 1 0 r
.007 w
.32796 .07197 m
.34329 .06831 L
s
.5 Mabswid
.687 .367 .428 r
.49899 .32391 m .51945 .32252 L .52073 .33141 L p F P
0 g
s
.666 .352 .432 r
.51945 .32252 m .54032 .32258 L .53881 .33147 L p F P
0 g
s
.666 .352 .432 r
.53881 .33147 m .52073 .33141 L .51945 .32252 L p F P
0 g
s
.642 .33 .427 r
.54032 .32258 m .56072 .32408 L .55648 .33278 L p F P
0 g
s
.642 .33 .427 r
.55648 .33278 m .53881 .33147 L .54032 .32258 L p F P
0 g
s
0 .8 0 r
.79616 .06741 m .79772 .06687 L .80696 .06895 L closepath p F P
0 g
s
0 .738 0 r
.79544 .06965 m .79616 .06741 L .80696 .06895 L closepath p F P
0 g
s
0 .603 0 r
.79599 .07229 m .79544 .06965 L .80696 .06895 L closepath p F P
0 g
s
0 .372 0 r
.79748 .07378 m .79599 .07229 L .80696 .06895 L closepath p F P
0 g
s
0 0 0 r
.79905 .07324 m .79748 .07378 L .80696 .06895 L closepath p F P
0 g
s
0 .899 0 r
.79977 .07099 m .79905 .07324 L .80696 .06895 L closepath p F P
0 g
s
0 .683 0 r
.79922 .06835 m .79977 .07099 L .80696 .06895 L closepath p F P
0 g
s
0 .304 0 r
.79772 .06687 m .79922 .06835 L .80696 .06895 L closepath p F P
0 g
s
.903 .663 .566 r
.30577 .19652 m .33412 .18425 L .33932 .19742 L p F P
0 g
s
.903 .663 .566 r
.33932 .19742 m .31184 .20959 L .30577 .19652 L p F P
0 g
s
.896 .645 .55 r
.31184 .20959 m .33932 .19742 L .34504 .21034 L p F P
0 g
s
.896 .645 .55 r
.34504 .21034 m .3185 .22236 L .31184 .20959 L p F P
0 g
s
0 1 0 r
.007 w
.28854 .23233 m
.31631 .21816 L
s
.5 Mabswid
.889 .626 .535 r
.3185 .22236 m .34504 .21034 L .35126 .223 L p F P
0 g
s
.746 .428 .445 r
.47336 .31779 m .45395 .32235 L .44551 .31339 L p F P
0 g
s
.734 .403 .419 r
.45395 .32235 m .47336 .31779 L .47978 .32669 L p F P
0 g
s
.717 .401 .443 r
.49899 .32391 m .47978 .32669 L .47336 .31779 L p F P
0 g
s
.788 .471 .453 r
.43735 .30393 m .41735 .31091 L .40767 .30147 L p F P
0 g
s
.776 .447 .431 r
.41735 .31091 m .43735 .30393 L .44551 .31339 L p F P
0 g
s
.909 .68 .581 r
.30033 .1832 m .32944 .17087 L .33412 .18425 L p F P
0 g
s
.909 .68 .581 r
.33412 .18425 m .30577 .19652 L .30033 .1832 L p F P
0 g
s
.889 .626 .535 r
.35126 .223 m .32574 .2348 L .3185 .22236 L p F P
0 g
s
.881 .607 .519 r
.32574 .2348 m .35126 .223 L .35798 .23535 L p F P
0 g
s
.705 .374 .415 r
.47978 .32669 m .49899 .32391 L .503 .33263 L p F P
0 g
s
.687 .367 .428 r
.52073 .33141 m .503 .33263 L .49899 .32391 L p F P
0 g
s
.584 .279 .417 r
.5864 .31811 m .60558 .32278 L .59671 .33115 L p F P
0 g
s
.584 .279 .417 r
.59671 .33115 m .57979 .32698 L .5864 .31811 L p F P
0 g
s
.914 .697 .595 r
.29551 .16964 m .32532 .15732 L .32944 .17087 L p F P
0 g
s
.914 .697 .595 r
.32944 .17087 m .30033 .1832 L .29551 .16964 L p F P
0 g
s
.615 .3 .413 r
.56072 .32408 m .57979 .32698 L .57298 .33532 L p F P
0 g
s
.615 .3 .413 r
.57298 .33532 m .55648 .33278 L .56072 .32408 L p F P
0 g
s
.881 .607 .519 r
.35798 .23535 m .33354 .24689 L .32574 .2348 L p F P
0 g
s
.873 .588 .503 r
.33354 .24689 m .35798 .23535 L .36517 .24736 L p F P
0 g
s
.538 .251 .427 r
.62251 .30444 m .64216 .31154 L .632 .3204 L p F P
0 g
s
.538 .251 .427 r
.632 .3204 m .61419 .31387 L .62251 .30444 L p F P
0 g
s
0 .615 0 r
.38973 .35554 m .39214 .35675 L .38545 .36645 L closepath p F P
0 g
s
0 .793 0 r
.38765 .35564 m .38973 .35554 L .38545 .36645 L closepath p F P
0 g
s
0 .835 0 r
.38711 .35701 m .38765 .35564 L .38545 .36645 L closepath p F P
0 g
s
0 .327 0 r
.38843 .35884 m .38711 .35701 L .38545 .36645 L closepath p F P
0 g
s
0 .401 0 r
.39214 .35675 m .39347 .35858 L .38545 .36645 L closepath p F P
0 g
s
0 .647 0 r
.39085 .36006 m .38843 .35884 L .38545 .36645 L closepath p F P
0 g
s
0 0 0 r
.39347 .35858 m .39293 .35995 L .38545 .36645 L closepath p F P
0 g
s
0 .907 0 r
.39293 .35995 m .39085 .36006 L .38545 .36645 L closepath p F P
0 g
s
.919 .714 .61 r
.29133 .15589 m .32174 .14361 L .32532 .15732 L p F P
0 g
s
.919 .714 .61 r
.32532 .15732 m .29551 .16964 L .29133 .15589 L p F P
0 g
s
.873 .588 .503 r
.36517 .24736 m .34188 .2586 L .33354 .24689 L p F P
0 g
s
.863 .568 .486 r
.34188 .2586 m .36517 .24736 L .37282 .25902 L p F P
0 g
s
.408 .244 .544 r
.74138 .22342 m .7155 .21126 L .72131 .19835 L p F P
0 g
s
0 1 0 r
.007 w
.73487 .21528 m
.76096 .22867 L
s
.5 Mabswid
.416 .237 .529 r
.7155 .21126 m .74138 .22342 L .73407 .23585 L p F P
0 g
s
.416 .237 .529 r
.73407 .23585 m .70918 .2239 L .7155 .21126 L p F P
0 g
s
.401 .251 .56 r
.74811 .21066 m .72131 .19835 L .72659 .18519 L p F P
0 g
s
.408 .244 .544 r
.72131 .19835 m .74811 .21066 L .74138 .22342 L p F P
0 g
s
.423 .23 .513 r
.70918 .2239 m .73407 .23585 L .72619 .24791 L p F P
0 g
s
.423 .23 .513 r
.72619 .24791 m .70237 .23623 L .70918 .2239 L p F P
0 g
s
.394 .258 .575 r
.75423 .19761 m .72659 .18519 L .73133 .17181 L p F P
0 g
s
.401 .251 .56 r
.72659 .18519 m .75423 .19761 L .74811 .21066 L p F P
0 g
s
.43 .224 .497 r
.70237 .23623 m .72619 .24791 L .71776 .25959 L p F P
0 g
s
.43 .224 .497 r
.71776 .25959 m .69507 .24822 L .70237 .23623 L p F P
0 g
s
.422 0 0 r
.29889 .13159 m .30042 .13211 L .29726 .14387 L closepath p F P
0 g
s
.9 0 0 r
.30042 .13211 m .29989 .13278 L .29726 .14387 L closepath p F P
0 g
s
.686 0 0 r
.29621 .13152 m .29889 .13159 L .29726 .14387 L closepath p F P
0 g
s
.834 0 0 r
.29394 .13194 m .29621 .13152 L .29726 .14387 L closepath p F P
0 g
s
.985 0 0 r
.2934 .13261 m .29394 .13194 L .29726 .14387 L closepath p F P
0 g
s
.327 0 0 r
.29493 .13314 m .2934 .13261 L .29726 .14387 L closepath p F P
0 g
s
.672 0 0 r
.29762 .13321 m .29493 .13314 L .29726 .14387 L closepath p F P
0 g
s
.839 0 0 r
.29989 .13278 m .29762 .13321 L .29726 .14387 L closepath p F P
0 g
s
.923 .731 .625 r
.28781 .14198 m .31873 .12978 L .32174 .14361 L p F P
0 g
s
.923 .731 .625 r
.32174 .14361 m .29133 .15589 L .28781 .14198 L p F P
0 g
s
.386 .264 .59 r
.75974 .18429 m .73133 .17181 L .73552 .15825 L p F P
0 g
s
.394 .258 .575 r
.73133 .17181 m .75974 .18429 L .75423 .19761 L p F P
0 g
s
.863 .568 .486 r
.37282 .25902 m .35075 .26989 L .34188 .2586 L p F P
0 g
s
.854 .547 .469 r
.35075 .26989 m .37282 .25902 L .38092 .27028 L p F P
0 g
s
.437 .217 .48 r
.69507 .24822 m .71776 .25959 L .70881 .27085 L p F P
0 g
s
.437 .217 .48 r
.70881 .27085 m .68731 .25985 L .69507 .24822 L p F P
0 g
s
.379 .271 .604 r
.76461 .17074 m .73552 .15825 L .73914 .14454 L p F P
0 g
s
.386 .264 .59 r
.73552 .15825 m .76461 .17074 L .75974 .18429 L p F P
0 g
s
.776 .447 .431 r
.44551 .31339 m .42737 .31982 L .41735 .31091 L p F P
0 g
s
.763 .422 .407 r
.42737 .31982 m .44551 .31339 L .45395 .32235 L p F P
0 g
s
.927 .747 .639 r
.28496 .12794 m .31629 .11587 L .31873 .12978 L p F P
0 g
s
.927 .747 .639 r
.31873 .12978 m .28781 .14198 L .28496 .12794 L p F P
0 g
s
1 1 0 r
.007 w
.72551 .07081 m
.74005 .07468 L
s
.5 Mabswid
.854 .547 .469 r
.38092 .27028 m .36011 .28074 L .35075 .26989 L p F P
0 g
s
.843 .525 .451 r
.36011 .28074 m .38092 .27028 L .38944 .28113 L p F P
0 g
s
.444 .21 .463 r
.68731 .25985 m .70881 .27085 L .69936 .28166 L p F P
0 g
s
.444 .21 .463 r
.69936 .28166 m .6791 .27108 L .68731 .25985 L p F P
0 g
s
.676 .338 .395 r
.503 .33263 m .52073 .33141 L .52205 .33978 L p F P
0 g
s
.657 .325 .399 r
.52073 .33141 m .53881 .33147 L .53727 .33982 L p F P
0 g
s
.657 .325 .399 r
.53727 .33982 m .52205 .33978 L .52073 .33141 L p F P
0 g
s
.371 .278 .619 r
.76883 .15698 m .73914 .14454 L .7422 .13071 L p F P
0 g
s
.379 .271 .604 r
.73914 .14454 m .76883 .15698 L .76461 .17074 L p F P
0 g
s
.635 .305 .394 r
.53881 .33147 m .55648 .33278 L .55214 .34094 L p F P
0 g
s
.635 .305 .394 r
.55214 .34094 m .53727 .33982 L .53881 .33147 L p F P
0 g
s
.541 .239 .404 r
.61419 .31387 m .632 .3204 L .62152 .32871 L p F P
0 g
s
.541 .239 .404 r
.62152 .32871 m .60558 .32278 L .61419 .31387 L p F P
0 g
s
.734 .403 .419 r
.47978 .32669 m .46264 .33077 L .45395 .32235 L p F P
0 g
s
.72 .374 .391 r
.46264 .33077 m .47978 .32669 L .48638 .33507 L p F P
0 g
s
.705 .374 .415 r
.503 .33263 m .48638 .33507 L .47978 .32669 L p F P
0 g
s
.93 .763 .653 r
.28278 .11381 m .31443 .10191 L .31629 .11587 L p F P
0 g
s
.93 .763 .653 r
.31629 .11587 m .28496 .12794 L .28278 .11381 L p F P
0 g
s
.452 .203 .445 r
.6791 .27108 m .69936 .28166 L .68943 .292 L p F P
0 g
s
.452 .203 .445 r
.68943 .292 m .67046 .2819 L .6791 .27108 L p F P
0 g
s
.583 .261 .389 r
.57979 .32698 m .59671 .33115 L .5876 .33897 L p F P
0 g
s
.583 .261 .389 r
.5876 .33897 m .57298 .33532 L .57979 .32698 L p F P
0 g
s
.843 .525 .451 r
.38944 .28113 m .36995 .29112 L .36011 .28074 L p F P
0 g
s
.831 .503 .433 r
.36995 .29112 m .38944 .28113 L .39836 .29154 L p F P
0 g
s
0 0 0 r
.75619 .12905 m .75615 .12971 L .75255 .14076 L closepath p F P
0 g
s
.48 0 0 r
.75429 .12853 m .75619 .12905 L .75255 .14076 L closepath p F P
0 g
s
.687 0 0 r
.75157 .12846 m .75429 .12853 L .75255 .14076 L closepath p F P
0 g
s
.849 0 0 r
.74961 .12888 m .75157 .12846 L .75255 .14076 L closepath p F P
0 g
s
.849 0 0 r
.74957 .12955 m .74961 .12888 L .75255 .14076 L closepath p F P
0 g
s
.419 0 0 r
.75146 .13007 m .74957 .12955 L .75255 .14076 L closepath p F P
0 g
s
.673 0 0 r
.75419 .13014 m .75146 .13007 L .75255 .14076 L closepath p F P
0 g
s
.854 0 0 r
.75615 .12971 m .75419 .13014 L .75255 .14076 L closepath p F P
0 g
s
.363 .285 .634 r
.77238 .14306 m .7422 .13071 L .74468 .11679 L p F P
0 g
s
.371 .278 .619 r
.7422 .13071 m .77238 .14306 L .76883 .15698 L p F P
0 g
s
.692 .344 .382 r
.48638 .33507 m .503 .33263 L .50712 .34081 L p F P
0 g
s
.676 .338 .395 r
.52205 .33978 m .50712 .34081 L .503 .33263 L p F P
0 g
s
.611 .277 .381 r
.55648 .33278 m .57298 .33532 L .56601 .3431 L p F P
0 g
s
.611 .277 .381 r
.56601 .3431 m .55214 .34094 L .55648 .33278 L p F P
0 g
s
1 1 0 r
.007 w
.31379 .07594 m
.32796 .07197 L
s
.5 Mabswid
.459 .196 .427 r
.67046 .2819 m .68943 .292 L .67904 .30183 L p F P
0 g
s
.459 .196 .427 r
.67904 .30183 m .66141 .29226 L .67046 .2819 L p F P
0 g
s
.933 .78 .668 r
.28129 .09963 m .31316 .08793 L .31443 .10191 L p F P
0 g
s
.933 .78 .668 r
.31443 .10191 m .28278 .11381 L .28129 .09963 L p F P
0 g
s
.355 .293 .648 r
.77527 .12901 m .74468 .11679 L .74657 .10282 L p F P
0 g
s
.363 .285 .634 r
.74468 .11679 m .77527 .12901 L .77238 .14306 L p F P
0 g
s
.831 .503 .433 r
.39836 .29154 m .38024 .301 L .36995 .29112 L p F P
0 g
s
.819 .479 .414 r
.38024 .301 m .39836 .29154 L .40767 .30147 L p F P
0 g
s
.763 .422 .407 r
.45395 .32235 m .43771 .32819 L .42737 .31982 L p F P
0 g
s
.748 .394 .382 r
.43771 .32819 m .45395 .32235 L .46264 .33077 L p F P
0 g
s
0 .72 0 r
.25106 .07024 m .25215 .07189 L .24049 .07239 L closepath p F P
0 g
s
0 0 0 r
.2495 .07058 m .25106 .07024 L .24049 .07239 L closepath p F P
0 g
s
0 .576 0 r
.25215 .07189 m .25214 .07458 L .24049 .07239 L closepath p F P
0 g
s
0 .212 0 r
.24839 .07273 m .2495 .07058 L .24049 .07239 L closepath p F P
0 g
s
0 .461 0 r
.25214 .07458 m .25102 .07673 L .24049 .07239 L closepath p F P
0 g
s
0 .418 0 r
.24837 .07542 m .24839 .07273 L .24049 .07239 L closepath p F P
0 g
s
0 .189 0 r
.25102 .07673 m .24947 .07708 L .24049 .07239 L closepath p F P
0 g
s
0 .495 0 r
.24947 .07708 m .24837 .07542 L .24049 .07239 L closepath p F P
0 g
s
.544 .226 .379 r
.60558 .32278 m .62152 .32871 L .61074 .33645 L p F P
0 g
s
.544 .226 .379 r
.61074 .33645 m .59671 .33115 L .60558 .32278 L p F P
0 g
s
.466 .189 .408 r
.66141 .29226 m .67904 .30183 L .66822 .31114 L p F P
0 g
s
.466 .189 .408 r
.66822 .31114 m .65197 .30215 L .66141 .29226 L p F P
0 g
s
.347 .3 .663 r
.77747 .11487 m .74657 .10282 L .74786 .08882 L p F P
0 g
s
.355 .293 .648 r
.74657 .10282 m .77747 .11487 L .77527 .12901 L p F P
0 g
s
.935 .795 .682 r
.28049 .08542 m .31247 .07397 L .31316 .08793 L p F P
0 g
s
0 1 0 r
.007 w
.24838 .07341 m
.29534 .07947 L
s
.5 Mabswid
.935 .795 .682 r
.31316 .08793 m .28129 .09963 L .28049 .08542 L p F P
0 g
s
.819 .479 .414 r
.40767 .30147 m .39096 .31036 L .38024 .301 L p F P
0 g
s
.805 .455 .394 r
.39096 .31036 m .40767 .30147 L .41735 .31091 L p F P
0 g
s
.72 .374 .391 r
.48638 .33507 m .47158 .33863 L .46264 .33077 L p F P
0 g
s
.704 .342 .36 r
.47158 .33863 m .48638 .33507 L .49315 .34288 L p F P
0 g
s
.692 .344 .382 r
.50712 .34081 m .49315 .34288 L .48638 .33507 L p F P
0 g
s
.473 .181 .388 r
.65197 .30215 m .66822 .31114 L .657 .3199 L p F P
0 g
s
.473 .181 .388 r
.657 .3199 m .64216 .31154 L .65197 .30215 L p F P
0 g
s
.582 .241 .357 r
.57298 .33532 m .5876 .33897 L .57827 .34619 L p F P
0 g
s
.582 .241 .357 r
.57827 .34619 m .56601 .3431 L .57298 .33532 L p F P
0 g
s
.663 .306 .358 r
.50712 .34081 m .52205 .33978 L .52339 .34759 L p F P
0 g
s
.646 .295 .362 r
.52205 .33978 m .53727 .33982 L .53568 .34763 L p F P
0 g
s
.646 .295 .362 r
.53568 .34763 m .52339 .34759 L .52205 .33978 L p F P
0 g
s
.627 .277 .357 r
.53727 .33982 m .55214 .34094 L .54768 .34854 L p F P
0 g
s
.627 .277 .357 r
.54768 .34854 m .53568 .34763 L .53727 .33982 L p F P
0 g
s
.338 .307 .677 r
.77897 .10067 m .74786 .08882 L .74855 .07484 L p F P
0 g
s
0 0 1 r
.007 w
.72008 .06564 m
.74728 .07437 L
s
.5 Mabswid
.347 .3 .663 r
.74786 .08882 m .77897 .10067 L .77747 .11487 L p F P
0 g
s
.748 .394 .382 r
.46264 .33077 m .44835 .33598 L .43771 .32819 L p F P
0 g
s
.731 .364 .355 r
.44835 .33598 m .46264 .33077 L .47158 .33863 L p F P
0 g
s
.805 .455 .394 r
.41735 .31091 m .40208 .31918 L .39096 .31036 L p F P
0 g
s
.79 .429 .373 r
.40208 .31918 m .41735 .31091 L .42737 .31982 L p F P
0 g
s
.547 .211 .352 r
.59671 .33115 m .61074 .33645 L .59968 .34359 L p F P
0 g
s
.547 .211 .352 r
.59968 .34359 m .5876 .33897 L .59671 .33115 L p F P
0 g
s
.676 .31 .346 r
.49315 .34288 m .50712 .34081 L .51134 .34843 L p F P
0 g
s
.663 .306 .358 r
.52339 .34759 m .51134 .34843 L .50712 .34081 L p F P
0 g
s
.605 .252 .344 r
.55214 .34094 m .56601 .3431 L .55887 .35029 L p F P
0 g
s
.605 .252 .344 r
.55887 .35029 m .54768 .34854 L .55214 .34094 L p F P
0 g
s
.481 .174 .368 r
.64216 .31154 m .657 .3199 L .6454 .32809 L p F P
0 g
s
0 1 0 r
.007 w
.64745 .32664 m
.66402 .35701 L
s
.5 Mabswid
.481 .174 .368 r
.6454 .32809 m .632 .3204 L .64216 .31154 L p F P
0 g
s
1 0 0 r
.007 w
.29534 .07947 m
.29536 .0801 L
s
.5 Mabswid
.338 .307 .677 r
.74855 .07484 m .77978 .08644 L .77897 .10067 L p F P
0 g
s
1 1 0 r
.007 w
.74005 .07468 m
.75334 .07885 L
s
0 0 1 r
.7494 .07505 m
.75439 .07665 L
s
.74728 .07437 m
.7494 .07505 L
s
0 1 0 r
.75439 .07665 m
.79957 .07004 L
s
1 0 0 r
.75438 .077 m
.75439 .07665 L
s
.5 Mabswid
.79 .429 .373 r
.42737 .31982 m .41358 .32743 L .40208 .31918 L p F P
0 g
s
0 1 0 r
.007 w
.38942 .35934 m
.40908 .32419 L
s
.5 Mabswid
.773 .402 .352 r
.41358 .32743 m .42737 .31982 L .43771 .32819 L p F P
0 g
s
.488 .166 .346 r
.632 .3204 m .6454 .32809 L .63346 .33568 L p F P
0 g
s
.488 .166 .346 r
.63346 .33568 m .62152 .32871 L .632 .3204 L p F P
0 g
s
.704 .342 .36 r
.49315 .34288 m .48073 .34591 L .47158 .33863 L p F P
0 g
s
.686 .307 .324 r
.48073 .34591 m .49315 .34288 L .50007 .35012 L p F P
0 g
s
.676 .31 .346 r
.51134 .34843 m .50007 .35012 L .49315 .34288 L p F P
0 g
s
1 1 0 r
.007 w
.3009 .08019 m
.31379 .07594 L
s
.5 Mabswid
.731 .364 .355 r
.47158 .33863 m .45927 .34318 L .44835 .33598 L p F P
0 g
s
.712 .331 .326 r
.45927 .34318 m .47158 .33863 L .48073 .34591 L p F P
0 g
s
.58 .22 .322 r
.56601 .3431 m .57827 .34619 L .56874 .35281 L p F P
0 g
s
.58 .22 .322 r
.56874 .35281 m .55887 .35029 L .56601 .3431 L p F P
0 g
s
.549 .196 .322 r
.5876 .33897 m .59968 .34359 L .58837 .35011 L p F P
0 g
s
.549 .196 .322 r
.58837 .35011 m .57827 .34619 L .5876 .33897 L p F P
0 g
s
.773 .402 .352 r
.43771 .32819 m .42542 .33508 L .41358 .32743 L p F P
0 g
s
.756 .373 .329 r
.42542 .33508 m .43771 .32819 L .44835 .33598 L p F P
0 g
s
.646 .269 .315 r
.51134 .34843 m .52339 .34759 L .52476 .35481 L p F P
0 g
s
.633 .26 .318 r
.52339 .34759 m .53568 .34763 L .53406 .35484 L p F P
0 g
s
.633 .26 .318 r
.53406 .35484 m .52476 .35481 L .52339 .34759 L p F P
0 g
s
.616 .244 .314 r
.53568 .34763 m .54768 .34854 L .54314 .35554 L p F P
0 g
s
.616 .244 .314 r
.54314 .35554 m .53406 .35484 L .53568 .34763 L p F P
0 g
s
.496 .158 .323 r
.62152 .32871 m .63346 .33568 L .62119 .34266 L p F P
0 g
s
.496 .158 .323 r
.62119 .34266 m .61074 .33645 L .62152 .32871 L p F P
0 g
s
.657 .272 .304 r
.50007 .35012 m .51134 .34843 L .51566 .35546 L p F P
0 g
s
.646 .269 .315 r
.52476 .35481 m .51566 .35546 L .51134 .34843 L p F P
0 g
s
.598 .223 .303 r
.54768 .34854 m .55887 .35029 L .55159 .35687 L p F P
0 g
s
.598 .223 .303 r
.55159 .35687 m .54314 .35554 L .54768 .34854 L p F P
0 g
s
.756 .373 .329 r
.44835 .33598 m .43759 .34212 L .42542 .33508 L p F P
0 g
s
.736 .342 .304 r
.43759 .34212 m .44835 .33598 L .45927 .34318 L p F P
0 g
s
.712 .331 .326 r
.48073 .34591 m .47043 .34976 L .45927 .34318 L p F P
0 g
s
.691 .296 .293 r
.47043 .34976 m .48073 .34591 L .49008 .35258 L p F P
0 g
s
.686 .307 .324 r
.50007 .35012 m .49008 .35258 L .48073 .34591 L p F P
0 g
s
.503 .149 .299 r
.61074 .33645 m .62119 .34266 L .60864 .349 L p F P
0 g
s
.503 .149 .299 r
.60864 .349 m .59968 .34359 L .61074 .33645 L p F P
0 g
s
.551 .18 .29 r
.57827 .34619 m .58837 .35011 L .57684 .35599 L p F P
0 g
s
.551 .18 .29 r
.57684 .35599 m .56874 .35281 L .57827 .34619 L p F P
0 g
s
.664 .268 .285 r
.49008 .35258 m .50007 .35012 L .50714 .35674 L p F P
0 g
s
.657 .272 .304 r
.51566 .35546 m .50714 .35674 L .50007 .35012 L p F P
0 g
s
.902 .568 .404 r
.31729 .25994 m .33354 .24689 L .34188 .2586 L p F P
0 g
s
.902 .568 .404 r
.34188 .2586 m .32648 .27127 L .31729 .25994 L p F P
0 g
s
.889 .545 .388 r
.32648 .27127 m .34188 .2586 L .35075 .26989 L p F P
0 g
s
.576 .195 .283 r
.55887 .35029 m .56874 .35281 L .55902 .35879 L p F P
0 g
s
.576 .195 .283 r
.55902 .35879 m .55159 .35687 L .55887 .35029 L p F P
0 g
s
.914 .592 .42 r
.30868 .24816 m .32574 .2348 L .33354 .24689 L p F P
0 g
s
.914 .592 .42 r
.33354 .24689 m .31729 .25994 L .30868 .24816 L p F P
0 g
s
.889 .545 .388 r
.35075 .26989 m .33622 .28214 L .32648 .27127 L p F P
0 g
s
.876 .52 .372 r
.33622 .28214 m .35075 .26989 L .36011 .28074 L p F P
0 g
s
.925 .615 .436 r
.30069 .23596 m .3185 .22236 L .32574 .2348 L p F P
0 g
s
.925 .615 .436 r
.32574 .2348 m .30868 .24816 L .30069 .23596 L p F P
0 g
s
.876 .52 .372 r
.36011 .28074 m .3465 .29249 L .33622 .28214 L p F P
0 g
s
.861 .496 .356 r
.3465 .29249 m .36011 .28074 L .36995 .29112 L p F P
0 g
s
.936 .637 .451 r
.29332 .22338 m .31184 .20959 L .3185 .22236 L p F P
0 g
s
.936 .637 .451 r
.3185 .22236 m .30069 .23596 L .29332 .22338 L p F P
0 g
s
.861 .496 .356 r
.36995 .29112 m .35729 .30233 L .3465 .29249 L p F P
0 g
s
.846 .47 .339 r
.35729 .30233 m .36995 .29112 L .38024 .301 L p F P
0 g
s
1 1 0 r
.007 w
.75334 .07885 m
.76529 .08329 L
s
.5 Mabswid
.945 .66 .467 r
.28661 .21045 m .30577 .19652 L .31184 .20959 L p F P
0 g
s
.945 .66 .467 r
.31184 .20959 m .29332 .22338 L .28661 .21045 L p F P
0 g
s
.736 .342 .304 r
.45927 .34318 m .45004 .34853 L .43759 .34212 L p F P
0 g
s
.715 .309 .279 r
.45004 .34853 m .45927 .34318 L .47043 .34976 L p F P
0 g
s
.846 .47 .339 r
.38024 .301 m .36855 .31161 L .35729 .30233 L p F P
0 g
s
.83 .445 .322 r
.36855 .31161 m .38024 .301 L .39096 .31036 L p F P
0 g
s
.305 .077 .393 r
.73247 .27236 m .71776 .25959 L .72619 .24791 L p F P
0 g
s
.32 .075 .377 r
.71776 .25959 m .73247 .27236 L .72267 .28319 L p F P
0 g
s
.32 .075 .377 r
.72267 .28319 m .70881 .27085 L .71776 .25959 L p F P
0 g
s
.334 .074 .361 r
.70881 .27085 m .72267 .28319 L .71233 .2935 L p F P
0 g
s
.334 .074 .361 r
.71233 .2935 m .69936 .28166 L .70881 .27085 L p F P
0 g
s
.291 .078 .409 r
.74171 .26106 m .72619 .24791 L .73407 .23585 L p F P
0 g
s
.305 .077 .393 r
.72619 .24791 m .74171 .26106 L .73247 .27236 L p F P
0 g
s
.349 .072 .345 r
.69936 .28166 m .71233 .2935 L .70149 .30329 L p F P
0 g
s
.349 .072 .345 r
.70149 .30329 m .68943 .292 L .69936 .28166 L p F P
0 g
s
.51 .14 .274 r
.59968 .34359 m .60864 .349 L .59583 .35468 L p F P
0 g
s
.51 .14 .274 r
.59583 .35468 m .58837 .35011 L .59968 .34359 L p F P
0 g
s
.276 .081 .424 r
.75037 .24931 m .73407 .23585 L .74138 .22342 L p F P
0 g
s
.291 .078 .409 r
.73407 .23585 m .75037 .24931 L .74171 .26106 L p F P
0 g
s
.954 .682 .483 r
.28058 .1972 m .30033 .1832 L .30577 .19652 L p F P
0 g
s
.954 .682 .483 r
.30577 .19652 m .28661 .21045 L .28058 .1972 L p F P
0 g
s
.363 .071 .329 r
.68943 .292 m .70149 .30329 L .69017 .31251 L p F P
0 g
s
.363 .071 .329 r
.69017 .31251 m .67904 .30183 L .68943 .292 L p F P
0 g
s
.83 .445 .322 r
.39096 .31036 m .38025 .32031 L .36855 .31161 L p F P
0 g
s
.812 .418 .306 r
.38025 .32031 m .39096 .31036 L .40208 .31918 L p F P
0 g
s
.626 .226 .266 r
.51566 .35546 m .52476 .35481 L .52617 .36143 L p F P
0 g
s
.615 .219 .268 r
.52476 .35481 m .53406 .35484 L .53241 .36145 L p F P
0 g
s
.615 .219 .268 r
.53241 .36145 m .52617 .36143 L .52476 .35481 L p F P
0 g
s
.603 .207 .265 r
.53406 .35484 m .54314 .35554 L .53851 .36192 L p F P
0 g
s
.603 .207 .265 r
.53851 .36192 m .53241 .36145 L .53406 .35484 L p F P
0 g
s
.262 .083 .44 r
.75841 .23713 m .74138 .22342 L .74811 .21066 L p F P
0 g
s
.276 .081 .424 r
.74138 .22342 m .75841 .23713 L .75037 .24931 L p F P
0 g
s
.377 .071 .313 r
.67904 .30183 m .69017 .31251 L .67841 .32116 L p F P
0 g
s
.377 .071 .313 r
.67841 .32116 m .66822 .31114 L .67904 .30183 L p F P
0 g
s
.962 .704 .498 r
.27523 .18366 m .29551 .16964 L .30033 .1832 L p F P
0 g
s
.962 .704 .498 r
.30033 .1832 m .28058 .1972 L .27523 .18366 L p F P
0 g
s
.247 .086 .456 r
.76582 .22457 m .74811 .21066 L .75423 .19761 L p F P
0 g
s
.262 .083 .44 r
.74811 .21066 m .76582 .22457 L .75841 .23713 L p F P
0 g
s
.691 .296 .293 r
.49008 .35258 m .48182 .35571 L .47043 .34976 L p F P
0 g
s
.667 .257 .258 r
.48182 .35571 m .49008 .35258 L .49961 .35861 L p F P
0 g
s
.664 .268 .285 r
.50714 .35674 m .49961 .35861 L .49008 .35258 L p F P
0 g
s
.812 .418 .306 r
.40208 .31918 m .39237 .32841 L .38025 .32031 L p F P
0 g
s
.794 .391 .288 r
.39237 .32841 m .40208 .31918 L .41358 .32743 L p F P
0 g
s
.633 .227 .256 r
.50714 .35674 m .51566 .35546 L .52005 .36186 L p F P
0 g
s
.626 .226 .266 r
.52617 .36143 m .52005 .36186 L .51566 .35546 L p F P
0 g
s
.588 .19 .255 r
.54314 .35554 m .55159 .35687 L .54417 .36282 L p F P
0 g
s
.588 .19 .255 r
.54417 .36282 m .53851 .36192 L .54314 .35554 L p F P
0 g
s
.392 .07 .296 r
.66822 .31114 m .67841 .32116 L .66623 .3292 L p F P
0 g
s
.392 .07 .296 r
.66623 .3292 m .657 .3199 L .66822 .31114 L p F P
0 g
s
.552 .162 .255 r
.56874 .35281 m .57684 .35599 L .56511 .36121 L p F P
0 g
s
.552 .162 .255 r
.56511 .36121 m .55902 .35879 L .56874 .35281 L p F P
0 g
s
1 1 0 r
.007 w
.28938 .08471 m
.3009 .08019 L
s
.5 Mabswid
.232 .089 .471 r
.77257 .21165 m .75423 .19761 L .75974 .18429 L p F P
0 g
s
.247 .086 .456 r
.75423 .19761 m .77257 .21165 L .76582 .22457 L p F P
0 g
s
.969 .725 .514 r
.27059 .16987 m .29133 .15589 L .29551 .16964 L p F P
0 g
s
.969 .725 .514 r
.29551 .16964 m .27523 .18366 L .27059 .16987 L p F P
0 g
s
.406 .07 .28 r
.657 .3199 m .66623 .3292 L .65366 .33662 L p F P
0 g
s
.406 .07 .28 r
.65366 .33662 m .6454 .32809 L .657 .3199 L p F P
0 g
s
.715 .309 .279 r
.47043 .34976 m .46274 .35429 L .45004 .34853 L p F P
0 g
s
.691 .274 .251 r
.46274 .35429 m .47043 .34976 L .48182 .35571 L p F P
0 g
s
.794 .391 .288 r
.41358 .32743 m .40487 .3359 L .39237 .32841 L p F P
0 g
s
.774 .363 .271 r
.40487 .3359 m .41358 .32743 L .42542 .33508 L p F P
0 g
s
.518 .131 .247 r
.58837 .35011 m .59583 .35468 L .58279 .3597 L p F P
0 g
s
.518 .131 .247 r
.58279 .3597 m .57684 .35599 L .58837 .35011 L p F P
0 g
s
.217 .092 .487 r
.77865 .1984 m .75974 .18429 L .76461 .17074 L p F P
0 g
s
.232 .089 .471 r
.75974 .18429 m .77865 .1984 L .77257 .21165 L p F P
0 g
s
.638 .223 .241 r
.49961 .35861 m .50714 .35674 L .51434 .36273 L p F P
0 g
s
.633 .227 .256 r
.52005 .36186 m .51434 .36273 L .50714 .35674 L p F P
0 g
s
.571 .168 .239 r
.55159 .35687 m .55902 .35879 L .54915 .36412 L p F P
0 g
s
.571 .168 .239 r
.54915 .36412 m .54417 .36282 L .55159 .35687 L p F P
0 g
s
.421 .07 .263 r
.6454 .32809 m .65366 .33662 L .64075 .3434 L p F P
0 g
s
.421 .07 .263 r
.64075 .3434 m .63346 .33568 L .6454 .32809 L p F P
0 g
s
.975 .746 .53 r
.26668 .15587 m .28781 .14198 L .29133 .15589 L p F P
0 g
s
.975 .746 .53 r
.29133 .15589 m .27059 .16987 L .26668 .15587 L p F P
0 g
s
.774 .363 .271 r
.42542 .33508 m .41773 .34275 L .40487 .3359 L p F P
0 g
s
.754 .334 .253 r
.41773 .34275 m .42542 .33508 L .43759 .34212 L p F P
0 g
s
.202 .096 .502 r
.78403 .18487 m .76461 .17074 L .76883 .15698 L p F P
0 g
s
.217 .092 .487 r
.76461 .17074 m .78403 .18487 L .77865 .1984 L p F P
0 g
s
.436 .071 .245 r
.63346 .33568 m .64075 .3434 L .62752 .34952 L p F P
0 g
s
.436 .071 .245 r
.62752 .34952 m .62119 .34266 L .63346 .33568 L p F P
0 g
s
.98 .767 .545 r
.26351 .14169 m .28496 .12794 L .28781 .14198 L p F P
0 g
s
.98 .767 .545 r
.28781 .14198 m .26668 .15587 L .26351 .14169 L p F P
0 g
s
.754 .334 .253 r
.43759 .34212 m .4309 .34894 L .41773 .34275 L p F P
0 g
s
.732 .304 .234 r
.4309 .34894 m .43759 .34212 L .45004 .34853 L p F P
0 g
s
.186 .1 .518 r
.7887 .17108 m .76883 .15698 L .77238 .14306 L p F P
0 g
s
.202 .096 .502 r
.76883 .15698 m .7887 .17108 L .78403 .18487 L p F P
0 g
s
.691 .274 .251 r
.48182 .35571 m .47568 .35938 L .46274 .35429 L p F P
0 g
s
.665 .237 .222 r
.47568 .35938 m .48182 .35571 L .4934 .36099 L p F P
0 g
s
.667 .257 .258 r
.49961 .35861 m .4934 .36099 L .48182 .35571 L p F P
0 g
s
.639 .213 .219 r
.4934 .36099 m .49961 .35861 L .50929 .364 L p F P
0 g
s
.638 .223 .241 r
.51434 .36273 m .50929 .364 L .49961 .35861 L p F P
0 g
s
.553 .142 .217 r
.55902 .35879 m .56511 .36121 L .55321 .36575 L p F P
0 g
s
.553 .142 .217 r
.55321 .36575 m .54915 .36412 L .55902 .35879 L p F P
0 g
s
.525 .122 .218 r
.57684 .35599 m .58279 .3597 L .56956 .36402 L p F P
0 g
s
.525 .122 .218 r
.56956 .36402 m .56511 .36121 L .57684 .35599 L p F P
0 g
s
.45 .071 .228 r
.62119 .34266 m .62752 .34952 L .61401 .35496 L p F P
0 g
s
.45 .071 .228 r
.61401 .35496 m .60864 .349 L .62119 .34266 L p F P
0 g
s
.984 .788 .561 r
.26109 .12738 m .28278 .11381 L .28496 .12794 L p F P
0 g
s
.984 .788 .561 r
.28496 .12794 m .26351 .14169 L .26109 .12738 L p F P
0 g
s
.6 .175 .208 r
.52005 .36186 m .52617 .36143 L .52759 .36741 L p F P
0 g
s
.594 .171 .21 r
.52617 .36143 m .53241 .36145 L .53074 .36742 L p F P
0 g
s
.594 .171 .21 r
.53074 .36742 m .52759 .36741 L .52617 .36143 L p F P
0 g
s
.585 .163 .208 r
.53241 .36145 m .53851 .36192 L .5338 .36765 L p F P
0 g
s
.585 .163 .208 r
.5338 .36765 m .53074 .36742 L .53241 .36145 L p F P
0 g
s
.732 .304 .234 r
.45004 .34853 m .44435 .35446 L .4309 .34894 L p F P
0 g
s
.708 .274 .216 r
.44435 .35446 m .45004 .34853 L .46274 .35429 L p F P
0 g
s
.171 .104 .534 r
.79263 .15707 m .77238 .14306 L .77527 .12901 L p F P
0 g
s
.186 .1 .518 r
.77238 .14306 m .79263 .15707 L .7887 .17108 L p F P
0 g
s
.604 .176 .201 r
.51434 .36273 m .52005 .36186 L .52451 .36763 L p F P
0 g
s
.6 .175 .208 r
.52759 .36741 m .52451 .36763 L .52005 .36186 L p F P
0 g
s
.575 .152 .201 r
.53851 .36192 m .54417 .36282 L .53665 .36811 L p F P
0 g
s
.575 .152 .201 r
.53665 .36811 m .5338 .36765 L .53851 .36192 L p F P
0 g
s
.465 .072 .21 r
.60864 .349 m .61401 .35496 L .60026 .35972 L p F P
0 g
s
.465 .072 .21 r
.60026 .35972 m .59583 .35468 L .60864 .349 L p F P
0 g
s
1 1 0 r
.007 w
.76529 .08329 m
.77579 .08799 L
s
.5 Mabswid
.987 .808 .577 r
.25943 .11296 m .28129 .09963 L .28278 .11381 L p F P
0 g
s
.987 .808 .577 r
.28278 .11381 m .26109 .12738 L .25943 .11296 L p F P
0 g
s
.607 .173 .191 r
.50929 .364 m .51434 .36273 L .52164 .36807 L p F P
0 g
s
.604 .176 .201 r
.52451 .36763 m .52164 .36807 L .51434 .36273 L p F P
0 g
s
.155 .108 .549 r
.79583 .14288 m .77527 .12901 L .77747 .11487 L p F P
0 g
s
.171 .104 .534 r
.77527 .12901 m .79583 .14288 L .79263 .15707 L p F P
0 g
s
.564 .137 .19 r
.54417 .36282 m .54915 .36412 L .53915 .36877 L p F P
0 g
s
.564 .137 .19 r
.53915 .36877 m .53665 .36811 L .54417 .36282 L p F P
0 g
s
.708 .274 .216 r
.46274 .35429 m .45805 .35929 L .44435 .35446 L p F P
0 g
s
.683 .242 .196 r
.45805 .35929 m .46274 .35429 L .47568 .35938 L p F P
0 g
s
.665 .237 .222 r
.4934 .36099 m .48881 .36378 L .47568 .35938 L p F P
0 g
s
.636 .197 .191 r
.48881 .36378 m .4934 .36099 L .50515 .3656 L p F P
0 g
s
.639 .213 .219 r
.50929 .364 m .50515 .3656 L .4934 .36099 L p F P
0 g
s
.532 .111 .188 r
.56511 .36121 m .56956 .36402 L .55616 .36764 L p F P
0 g
s
.532 .111 .188 r
.55616 .36764 m .55321 .36575 L .56511 .36121 L p F P
0 g
s
.48 .074 .191 r
.59583 .35468 m .60026 .35972 L .58629 .36376 L p F P
0 g
s
.48 .074 .191 r
.58629 .36376 m .58279 .3597 L .59583 .35468 L p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .682 0 r
.52585 .42385 m .528 .42322 L .52903 .43575 L closepath p F P
0 g
s
0 .679 0 r
.52556 .42485 m .52585 .42385 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .566 0 r
.528 .42322 m .53076 .42333 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 0 0 r
.53251 .42411 m .53222 .4251 L .52903 .43575 L closepath p F P
0 g
s
0 .353 0 r
.53076 .42333 m .53251 .42411 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
0 .412 0 r
.52731 .42563 m .52556 .42485 L .52903 .43575 L closepath p F P
0 g
s
0 .658 0 r
.53007 .42574 m .52731 .42563 L .52903 .43575 L closepath p F P
0 g
s
0 .825 0 r
.53222 .4251 m .53007 .42574 L .52903 .43575 L closepath p F P
0 g
s
.606 .165 .176 r
.50515 .3656 m .50929 .364 L .51911 .36871 L p F P
0 g
s
.607 .173 .191 r
.52164 .36807 m .51911 .36871 L .50929 .364 L p F P
0 g
s
.989 .828 .592 r
.25854 .09848 m .28049 .08542 L .28129 .09963 L p F P
0 g
s
0 0 1 r
.007 w
.28319 .08382 m
.29534 .07947 L
s
.5 Mabswid
.989 .828 .592 r
.28129 .09963 m .25943 .11296 L .25854 .09848 L p F P
0 g
s
.138 .113 .565 r
.79826 .12855 m .77747 .11487 L .77897 .10067 L p F P
0 g
s
.155 .108 .549 r
.77747 .11487 m .79826 .12855 L .79583 .14288 L p F P
0 g
s
.552 .12 .174 r
.54915 .36412 m .55321 .36575 L .54118 .36959 L p F P
0 g
s
.552 .12 .174 r
.54118 .36959 m .53915 .36877 L .54915 .36412 L p F P
0 g
s
.683 .242 .196 r
.47568 .35938 m .47197 .36342 L .45805 .35929 L p F P
0 g
s
.656 .209 .176 r
.47197 .36342 m .47568 .35938 L .48881 .36378 L p F P
0 g
s
1 1 0 r
.007 w
.27935 .08948 m
.28938 .08471 L
s
.5 Mabswid
.495 .075 .172 r
.58279 .3597 m .58629 .36376 L .57214 .3671 L p F P
0 g
s
.495 .075 .172 r
.57214 .3671 m .56956 .36402 L .58279 .3597 L p F P
0 g
s
.121 .119 .58 r
.79993 .11411 m .77897 .10067 L .77978 .08644 L p F P
0 g
s
.138 .113 .565 r
.77897 .10067 m .79993 .11411 L .79826 .12855 L p F P
0 g
s
.636 .197 .191 r
.50515 .3656 m .5021 .36748 L .48881 .36378 L p F P
0 g
s
.604 .154 .157 r
.5021 .36748 m .50515 .3656 L .51704 .36952 L p F P
0 g
s
.606 .165 .176 r
.51911 .36871 m .51704 .36952 L .50515 .3656 L p F P
0 g
s
.539 .101 .155 r
.55321 .36575 m .55616 .36764 L .54264 .37054 L p F P
0 g
s
.539 .101 .155 r
.54264 .37054 m .54118 .36959 L .55321 .36575 L p F P
0 g
s
.656 .209 .176 r
.48881 .36378 m .48606 .36684 L .47197 .36342 L p F P
0 g
s
.628 .175 .156 r
.48606 .36684 m .48881 .36378 L .5021 .36748 L p F P
0 g
s
.51 .077 .153 r
.56956 .36402 m .57214 .3671 L .55786 .36971 L p F P
0 g
s
.51 .077 .153 r
.55786 .36971 m .55616 .36764 L .56956 .36402 L p F P
0 g
s
.568 .116 .14 r
.52903 .37272 m .52451 .36763 L .52759 .36741 L closepath p F P
0 g
s
.565 .115 .141 r
.52903 .37272 m .52759 .36741 L .53074 .36742 L closepath p F P
0 g
s
.562 .112 .14 r
.52903 .37272 m .53074 .36742 L .5338 .36765 L closepath p F P
0 g
s
.569 .116 .138 r
.52903 .37272 m .52164 .36807 L .52451 .36763 L closepath p F P
0 g
s
.559 .108 .137 r
.52903 .37272 m .5338 .36765 L .53665 .36811 L closepath p F P
0 g
s
.57 .115 .133 r
.52903 .37272 m .51911 .36871 L .52164 .36807 L closepath p F P
0 g
s
.554 .102 .133 r
.52903 .37272 m .53665 .36811 L .53915 .36877 L closepath p F P
0 g
s
.121 .119 .58 r
.77978 .08644 m .80083 .09961 L .79993 .11411 L p F P
0 g
s
0 .555 0 r
.69032 .38136 m .69276 .38024 L .6971 .39204 L closepath p F P
0 g
s
0 .594 0 r
.68844 .383 m .69032 .38136 L .6971 .39204 L closepath p F P
0 g
s
0 .487 0 r
.68822 .3842 m .68844 .383 L .6971 .39204 L closepath p F P
0 g
s
0 .534 0 r
.68978 .38426 m .68822 .3842 L .6971 .39204 L closepath p F P
0 g
s
0 .689 0 r
.69222 .38314 m .68978 .38426 L .6971 .39204 L closepath p F P
0 g
s
0 .38 0 r
.69276 .38024 m .69432 .3803 L .6971 .39204 L closepath p F P
0 g
s
0 .746 0 r
.6941 .3815 m .69222 .38314 L .6971 .39204 L closepath p F P
0 g
s
0 .691 0 r
.69432 .3803 m .6941 .3815 L .6971 .39204 L closepath p F P
0 g
s
.778 .322 .163 r
.38884 .33823 m .39237 .32841 L .40487 .3359 L p F P
0 g
s
.778 .322 .163 r
.40487 .3359 m .4018 .34489 L .38884 .33823 L p F P
0 g
s
.757 .297 .155 r
.4018 .34489 m .40487 .3359 L .41773 .34275 L p F P
0 g
s
.799 .347 .171 r
.37624 .3309 m .38025 .32031 L .39237 .32841 L p F P
0 g
s
.799 .347 .171 r
.39237 .32841 m .38884 .33823 L .37624 .3309 L p F P
0 g
s
.757 .297 .155 r
.41773 .34275 m .4151 .35086 L .4018 .34489 L p F P
0 g
s
.735 .271 .148 r
.4151 .35086 m .41773 .34275 L .4309 .34894 L p F P
0 g
s
.818 .373 .179 r
.36405 .32292 m .36855 .31161 L .38025 .32031 L p F P
0 g
s
.818 .373 .179 r
.38025 .32031 m .37624 .3309 L .36405 .32292 L p F P
0 g
s
.735 .271 .148 r
.4309 .34894 m .4287 .35614 L .4151 .35086 L p F P
0 g
s
.713 .246 .141 r
.4287 .35614 m .4309 .34894 L .44435 .35446 L p F P
0 g
s
.569 .112 .128 r
.52903 .37272 m .51704 .36952 L .51911 .36871 L closepath p F P
0 g
s
.628 .175 .156 r
.5021 .36748 m .5003 .36953 L .48606 .36684 L p F P
0 g
s
.598 .139 .135 r
.5003 .36953 m .5021 .36748 L .51552 .37046 L p F P
0 g
s
.604 .154 .157 r
.51704 .36952 m .51552 .37046 L .5021 .36748 L p F P
0 g
s
.55 .096 .127 r
.52903 .37272 m .53915 .36877 L .54118 .36959 L closepath p F P
0 g
s
.837 .399 .188 r
.35231 .31431 m .35729 .30233 L .36855 .31161 L p F P
0 g
s
.837 .399 .188 r
.36855 .31161 m .36405 .32292 L .35231 .31431 L p F P
0 g
s
.713 .246 .141 r
.44435 .35446 m .44255 .3607 L .4287 .35614 L p F P
0 g
s
.689 .221 .134 r
.44255 .3607 m .44435 .35446 L .45805 .35929 L p F P
0 g
s
.526 .079 .133 r
.55616 .36764 m .55786 .36971 L .54348 .37158 L p F P
0 g
s
.526 .079 .133 r
.54348 .37158 m .54264 .37054 L .55616 .36764 L p F P
0 g
s
.333 0 .144 r
.64295 .35154 m .64075 .3434 L .65366 .33662 L p F P
0 g
s
.36 0 .138 r
.64075 .3434 m .64295 .35154 L .62935 .35674 L p F P
0 g
s
.36 0 .138 r
.62935 .35674 m .62752 .34952 L .64075 .3434 L p F P
0 g
s
.855 .424 .197 r
.34103 .30508 m .3465 .29249 L .35729 .30233 L p F P
0 g
s
.855 .424 .197 r
.35729 .30233 m .35231 .31431 L .34103 .30508 L p F P
0 g
s
.306 0 .151 r
.65626 .34564 m .65366 .33662 L .66623 .3292 L p F P
0 g
s
.333 0 .144 r
.65366 .33662 m .65626 .34564 L .64295 .35154 L p F P
0 g
s
.386 0 .132 r
.62752 .34952 m .62935 .35674 L .61548 .36122 L p F P
0 g
s
.386 0 .132 r
.61548 .36122 m .61401 .35496 L .62752 .34952 L p F P
0 g
s
.689 .221 .134 r
.45805 .35929 m .45663 .36455 L .44255 .3607 L p F P
0 g
s
.665 .196 .128 r
.45663 .36455 m .45805 .35929 L .47197 .36342 L p F P
0 g
s
.279 0 .157 r
.66923 .33905 m .66623 .3292 L .67841 .32116 L p F P
0 g
s
.306 0 .151 r
.66623 .3292 m .66923 .33905 L .65626 .34564 L p F P
0 g
s
0 1 0 r
.007 w
.66641 .34048 m
.69189 .38329 L
s
.5 Mabswid
.412 0 .127 r
.61401 .35496 m .61548 .36122 L .6014 .36498 L p F P
0 g
s
.412 0 .127 r
.6014 .36498 m .60026 .35972 L .61401 .35496 L p F P
0 g
s
.251 0 .164 r
.68184 .33178 m .67841 .32116 L .69017 .31251 L p F P
0 g
s
.279 0 .157 r
.67841 .32116 m .68184 .33178 L .66923 .33905 L p F P
0 g
s
.568 .108 .121 r
.52903 .37272 m .51552 .37046 L .51704 .36952 L closepath p F P
0 g
s
.872 .45 .206 r
.33027 .29527 m .33622 .28214 L .3465 .29249 L p F P
0 g
s
.872 .45 .206 r
.3465 .29249 m .34103 .30508 L .33027 .29527 L p F P
0 g
s
.545 .089 .12 r
.52903 .37272 m .54118 .36959 L .54264 .37054 L closepath p F P
0 g
s
.438 .007 .121 r
.60026 .35972 m .6014 .36498 L .58714 .36801 L p F P
0 g
s
.438 .007 .121 r
.58714 .36801 m .58629 .36376 L .60026 .35972 L p F P
0 g
s
.665 .196 .128 r
.47197 .36342 m .4709 .36766 L .45663 .36455 L p F P
0 g
s
.641 .171 .121 r
.4709 .36766 m .47197 .36342 L .48606 .36684 L p F P
0 g
s
.223 0 .172 r
.69404 .32387 m .69017 .31251 L .70149 .30329 L p F P
0 g
s
.251 0 .164 r
.69017 .31251 m .69404 .32387 L .68184 .33178 L p F P
0 g
s
.463 .023 .117 r
.58629 .36376 m .58714 .36801 L .57273 .37031 L p F P
0 g
s
.463 .023 .117 r
.57273 .37031 m .57214 .3671 L .58629 .36376 L p F P
0 g
s
.888 .476 .215 r
.32004 .28489 m .32648 .27127 L .33622 .28214 L p F P
0 g
s
.888 .476 .215 r
.33622 .28214 m .33027 .29527 L .32004 .28489 L p F P
0 g
s
.194 0 .18 r
.70581 .31531 m .70149 .30329 L .71233 .2935 L p F P
0 g
s
.223 0 .172 r
.70149 .30329 m .70581 .31531 L .69404 .32387 L p F P
0 g
s
.641 .171 .121 r
.48606 .36684 m .48531 .37004 L .4709 .36766 L p F P
0 g
s
.615 .146 .115 r
.48531 .37004 m .48606 .36684 L .5003 .36953 L p F P
0 g
s
.488 .04 .112 r
.57214 .3671 m .57273 .37031 L .55822 .37186 L p F P
0 g
s
.488 .04 .112 r
.55822 .37186 m .55786 .36971 L .57214 .3671 L p F P
0 g
s
.598 .139 .135 r
.51552 .37046 m .51463 .3715 L .5003 .36953 L p F P
0 g
s
.565 .102 .113 r
.52903 .37272 m .51463 .3715 L .51552 .37046 L closepath p F P
0 g
s
.541 .082 .112 r
.52903 .37272 m .54264 .37054 L .54348 .37158 L closepath p F P
0 g
s
1 1 0 r
.007 w
.77579 .08799 m
.78474 .09292 L
s
.5 Mabswid
.165 0 .188 r
.7171 .30614 m .71233 .2935 L .72267 .28319 L p F P
0 g
s
.194 0 .18 r
.71233 .2935 m .7171 .30614 L .70581 .31531 L p F P
0 g
s
.904 .501 .225 r
.31039 .27398 m .31729 .25994 L .32648 .27127 L p F P
0 g
s
.904 .501 .225 r
.32648 .27127 m .32004 .28489 L .31039 .27398 L p F P
0 g
s
.615 .146 .115 r
.5003 .36953 m .49983 .37168 L .48531 .37004 L p F P
0 g
s
.589 .121 .11 r
.49983 .37168 m .5003 .36953 L .51463 .3715 L p F P
0 g
s
.512 .057 .108 r
.55786 .36971 m .55822 .37186 L .54364 .37266 L p F P
0 g
s
.512 .057 .108 r
.54364 .37266 m .54348 .37158 L .55786 .36971 L p F P
0 g
s
.135 0 .196 r
.72788 .29637 m .72267 .28319 L .73247 .27236 L p F P
0 g
s
.165 0 .188 r
.72267 .28319 m .72788 .29637 L .7171 .30614 L p F P
0 g
s
.918 .527 .235 r
.30133 .26255 m .30868 .24816 L .31729 .25994 L p F P
0 g
s
.918 .527 .235 r
.31729 .25994 m .31039 .27398 L .30133 .26255 L p F P
0 g
s
0 .573 0 r
.36574 .38374 m .36812 .38519 L .36037 .39525 L closepath p F P
0 g
s
0 .749 0 r
.36365 .38321 m .36574 .38374 L .36037 .39525 L closepath p F P
0 g
s
0 .328 0 r
.36812 .38519 m .3694 .38671 L .36037 .39525 L closepath p F P
0 g
s
0 .891 0 r
.36307 .38391 m .36365 .38321 L .36037 .39525 L closepath p F P
0 g
s
0 .292 0 r
.36435 .38543 m .36307 .38391 L .36037 .39525 L closepath p F P
0 g
s
0 .599 0 r
.36673 .38688 m .36435 .38543 L .36037 .39525 L closepath p F P
0 g
s
0 0 0 r
.3694 .38671 m .36883 .38741 L .36037 .39525 L closepath p F P
0 g
s
0 .82 0 r
.36883 .38741 m .36673 .38688 L .36037 .39525 L closepath p F P
0 g
s
0 1 0 r
.007 w
.36569 .38624 m
.39283 .34028 L
s
.5 Mabswid
.589 .121 .11 r
.51463 .3715 m .51441 .37257 L .49983 .37168 L p F P
0 g
s
.562 .096 .104 r
.52903 .37272 m .51441 .37257 L .51463 .3715 L closepath p F P
0 g
s
.536 .074 .104 r
.52903 .37272 m .54348 .37158 L .54364 .37266 L closepath p F P
0 g
s
.105 0 .205 r
.73813 .28604 m .73247 .27236 L .74171 .26106 L p F P
0 g
s
.135 0 .196 r
.73247 .27236 m .73813 .28604 L .72788 .29637 L p F P
0 g
s
.931 .553 .246 r
.2929 .25064 m .30069 .23596 L .30868 .24816 L p F P
0 g
s
.931 .553 .246 r
.30868 .24816 m .30133 .26255 L .2929 .25064 L p F P
0 g
s
.527 .055 .078 r
.52903 .37272 m .54193 .37473 L .54014 .37562 L closepath p F P
0 g
s
.525 .051 .071 r
.52903 .37272 m .54014 .37562 L .53782 .37637 L closepath p F P
0 g
s
.525 .048 .065 r
.52903 .37272 m .53782 .37637 L .53509 .37692 L closepath p F P
0 g
s
.526 .047 .061 r
.52903 .37272 m .53509 .37692 L .53207 .37726 L closepath p F P
0 g
s
.528 .047 .059 r
.52903 .37272 m .53207 .37726 L .5289 .37737 L closepath p F P
0 g
s
0 1 0 r
.007 w
.52903 .37736 m
.52903 .4257 L
s
.5 Mabswid
.53 .05 .06 r
.52903 .37272 m .5289 .37737 L .52574 .37724 L closepath p F P
0 g
s
.534 .054 .062 r
.52903 .37272 m .52574 .37724 L .52274 .37688 L closepath p F P
0 g
s
.539 .059 .066 r
.52903 .37272 m .52274 .37688 L .52004 .37631 L closepath p F P
0 g
s
.544 .066 .072 r
.52903 .37272 m .52004 .37631 L .51776 .37556 L closepath p F P
0 g
s
.549 .073 .079 r
.52903 .37272 m .51776 .37556 L .51601 .37465 L closepath p F P
0 g
s
.554 .081 .087 r
.52903 .37272 m .51601 .37465 L .51488 .37364 L closepath p F P
0 g
s
.558 .088 .096 r
.52903 .37272 m .51488 .37364 L .51441 .37257 L closepath p F P
0 g
s
.532 .067 .095 r
.52903 .37272 m .54364 .37266 L .54312 .37373 L closepath p F P
0 g
s
.529 .061 .086 r
.52903 .37272 m .54312 .37373 L .54193 .37473 L closepath p F P
0 g
s
.578 .099 .083 r
.50072 .37381 m .49983 .37168 L .51441 .37257 L p F P
0 g
s
.578 .099 .083 r
.51441 .37257 m .51488 .37364 L .50072 .37381 L p F P
0 g
s
.074 0 .214 r
.7478 .27516 m .74171 .26106 L .75037 .24931 L p F P
0 g
s
.105 0 .205 r
.74171 .26106 m .7478 .27516 L .73813 .28604 L p F P
0 g
s
.499 .035 .081 r
.54312 .37373 m .54364 .37266 L .55822 .37186 L p F P
0 g
s
1 1 0 r
.007 w
.2709 .09447 m
.27935 .08948 L
s
.5 Mabswid
.597 .111 .071 r
.4866 .37324 m .48531 .37004 L .49983 .37168 L p F P
0 g
s
.597 .111 .071 r
.49983 .37168 m .50072 .37381 L .4866 .37324 L p F P
0 g
s
.943 .579 .256 r
.28513 .23829 m .29332 .22338 L .30069 .23596 L p F P
0 g
s
.943 .579 .256 r
.30069 .23596 m .2929 .25064 L .28513 .23829 L p F P
0 g
s
.465 .001 .067 r
.55721 .37399 m .55822 .37186 L .57273 .37031 L p F P
0 g
s
.499 .035 .081 r
.55822 .37186 m .55721 .37399 L .54312 .37373 L p F P
0 g
s
.616 .123 .058 r
.47255 .37191 m .4709 .36766 L .48531 .37004 L p F P
0 g
s
.616 .123 .058 r
.48531 .37004 m .4866 .37324 L .47255 .37191 L p F P
0 g
s
.043 0 .224 r
.75688 .26376 m .75037 .24931 L .75841 .23713 L p F P
0 g
s
.074 0 .214 r
.75037 .24931 m .75688 .26376 L .7478 .27516 L p F P
0 g
s
0 0 0 r
.26236 .09277 m .26454 .0941 L .25748 .09301 L closepath p F P
0 g
s
0 0 .433 r
.26139 .09013 m .26236 .09277 L .25748 .09301 L closepath p F P
0 g
s
.429 0 .053 r
.57127 .37349 m .57273 .37031 L .58714 .36801 L p F P
0 g
s
.465 .001 .067 r
.57273 .37031 m .57127 .37349 L .55721 .37399 L p F P
0 g
s
.564 .076 .056 r
.50296 .37584 m .50072 .37381 L .51488 .37364 L p F P
0 g
s
.564 .076 .056 r
.51488 .37364 m .51601 .37465 L .50296 .37584 L p F P
0 g
s
0 0 .639 r
.26219 .08772 m .26139 .09013 L .25748 .09301 L closepath p F P
0 g
s
.488 .013 .054 r
.54193 .37473 m .54312 .37373 L .55721 .37399 L p F P
0 g
s
.635 .135 .046 r
.4586 .36982 m .45663 .36455 L .4709 .36766 L p F P
0 g
s
.635 .135 .046 r
.4709 .36766 m .47255 .37191 L .4586 .36982 L p F P
0 g
s
0 0 .978 r
.26454 .0941 m .26665 .09334 L .25748 .09301 L closepath p F P
0 g
s
.953 .604 .267 r
.27804 .22551 m .28661 .21045 L .29332 .22338 L p F P
0 g
s
.953 .604 .267 r
.29332 .22338 m .28513 .23829 L .27804 .22551 L p F P
0 g
s
0 0 0 r
.2643 .08696 m .26219 .08772 L .25748 .09301 L closepath p F P
0 g
s
.391 0 .038 r
.58527 .37225 m .58714 .36801 L .6014 .36498 L p F P
0 g
s
.429 0 .053 r
.58714 .36801 m .58527 .37225 L .57127 .37349 L p F P
0 g
s
.012 0 .233 r
.76533 .25188 m .75841 .23713 L .76582 .22457 L p F P
0 g
s
.043 0 .224 r
.75841 .23713 m .76533 .25188 L .75688 .26376 L p F P
0 g
s
0 0 .825 r
.26665 .09334 m .26746 .09093 L .25748 .09301 L closepath p F P
0 g
s
.654 .149 .033 r
.44481 .36698 m .44255 .3607 L .45663 .36455 L p F P
0 g
s
.654 .149 .033 r
.45663 .36455 m .4586 .36982 L .44481 .36698 L p F P
0 g
s
.548 .052 .029 r
.50643 .37766 m .50296 .37584 L .51601 .37465 L p F P
0 g
s
.548 .052 .029 r
.51601 .37465 m .51776 .37556 L .50643 .37766 L p F P
0 g
s
0 0 .442 r
.26648 .08829 m .2643 .08696 L .25748 .09301 L closepath p F P
0 g
s
.479 0 .027 r
.54014 .37562 m .54193 .37473 L .55487 .376 L p F P
0 g
s
.488 .013 .054 r
.55721 .37399 m .55487 .376 L .54193 .37473 L p F P
0 g
s
0 0 .648 r
.26746 .09093 m .26648 .08829 L .25748 .09301 L closepath p F P
0 g
s
0 0 1 r
.007 w
.26697 .08962 m
.28319 .08382 L
s
.5 Mabswid
.351 0 .024 r
.59915 .37024 m .6014 .36498 L .61548 .36122 L p F P
0 g
s
.391 0 .038 r
.6014 .36498 m .59915 .37024 L .58527 .37225 L p F P
0 g
s
.962 .629 .278 r
.27165 .21236 m .28058 .1972 L .28661 .21045 L p F P
0 g
s
.962 .629 .278 r
.28661 .21045 m .27804 .22551 L .27165 .21236 L p F P
0 g
s
.573 .071 .023 r
.4899 .37627 m .4866 .37324 L .50072 .37381 L p F P
0 g
s
.573 .071 .023 r
.50072 .37381 m .50296 .37584 L .4899 .37627 L p F P
0 g
s
.672 .162 .021 r
.4312 .36339 m .4287 .35614 L .44255 .3607 L p F P
0 g
s
.672 .162 .021 r
.44255 .3607 m .44481 .36698 L .4312 .36339 L p F P
0 g
s
.443 0 .019 r
.55487 .376 m .55721 .37399 L .57127 .37349 L p F P
0 g
s
0 0 .243 r
.77312 .23954 m .76582 .22457 L .77257 .21165 L p F P
0 g
s
.012 0 .233 r
.76582 .22457 m .77312 .23954 L .76533 .25188 L p F P
0 g
s
.531 .028 .005 r
.51098 .37918 m .50643 .37766 L .51776 .37556 L p F P
0 g
s
.531 .028 .005 r
.51776 .37556 m .52004 .37631 L .51098 .37918 L p F P
0 g
s
.479 0 .027 r
.55487 .376 m .5513 .37779 L .54014 .37562 L p F P
0 g
s
.473 0 .004 r
.53782 .37637 m .54014 .37562 L .5513 .37779 L p F P
0 g
s
.309 0 .01 r
.6129 .36749 m .61548 .36122 L .62935 .35674 L p F P
0 g
s
.351 0 .024 r
.61548 .36122 m .6129 .36749 L .59915 .37024 L p F P
0 g
s
.69 .177 .008 r
.41781 .35905 m .4151 .35086 L .4287 .35614 L p F P
0 g
s
.69 .177 .008 r
.4287 .35614 m .4312 .36339 L .41781 .35905 L p F P
0 g
s
0 0 .663 r
.79761 .09203 m .80024 .09096 L .79849 .09171 L closepath p F P
0 g
s
0 0 .423 r
.79645 .09457 m .79761 .09203 L .79849 .09171 L closepath p F P
0 g
s
0 0 .282 r
.79743 .0971 m .79645 .09457 L .79849 .09171 L closepath p F P
0 g
s
0 0 .276 r
.79999 .09814 m .79743 .0971 L .79849 .09171 L closepath p F P
0 g
s
0 0 .361 r
.80262 .09707 m .79999 .09814 L .79849 .09171 L closepath p F P
0 g
s
0 0 .511 r
.80379 .09453 m .80262 .09707 L .79849 .09171 L closepath p F P
0 g
s
0 0 .727 r
.8028 .09199 m .80379 .09453 L .79849 .09171 L closepath p F P
0 g
s
0 0 .858 r
.80024 .09096 m .8028 .09199 L .79849 .09171 L closepath p F P
0 g
s
.97 .654 .29 r
.26599 .19885 m .27523 .18366 L .28058 .1972 L p F P
0 g
s
.97 .654 .29 r
.28058 .1972 m .27165 .21236 L .26599 .19885 L p F P
0 g
s
.515 .006 0 r
.5164 .38032 m .51098 .37918 L .52004 .37631 L p F P
0 g
s
.515 .006 0 r
.52004 .37631 m .52274 .37688 L .5164 .38032 L p F P
0 g
s
.473 0 .004 r
.5513 .37779 m .54667 .37928 L .53782 .37637 L p F P
0 g
s
.47 0 0 r
.53509 .37692 m .53782 .37637 L .54667 .37928 L p F P
0 g
s
0 0 .254 r
.78023 .22678 m .77257 .21165 L .77865 .1984 L p F P
0 g
s
0 0 .243 r
.77257 .21165 m .78023 .22678 L .77312 .23954 L p F P
0 g
s
.265 0 0 r
.62646 .36397 m .62935 .35674 L .64295 .35154 L p F P
0 g
s
.309 0 .01 r
.62935 .35674 m .62646 .36397 L .6129 .36749 L p F P
0 g
s
.583 .066 0 r
.47688 .37595 m .47255 .37191 L .4866 .37324 L p F P
0 g
s
.583 .066 0 r
.4866 .37324 m .4899 .37627 L .47688 .37595 L p F P
0 g
s
.707 .192 0 r
.40469 .35398 m .4018 .34489 L .4151 .35086 L p F P
0 g
s
.707 .192 0 r
.4151 .35086 m .41781 .35905 L .40469 .35398 L p F P
0 g
s
.395 0 0 r
.56781 .37651 m .57127 .37349 L .58527 .37225 L p F P
0 g
s
.443 0 .019 r
.57127 .37349 m .56781 .37651 L .55487 .376 L p F P
0 g
s
.499 0 0 r
.52242 .38105 m .5164 .38032 L .52274 .37688 L p F P
0 g
s
.499 0 0 r
.52274 .37688 m .52574 .37724 L .52242 .38105 L p F P
0 g
s
.47 0 0 r
.54667 .37928 m .54119 .3804 L .53509 .37692 L p F P
0 g
s
.471 0 0 r
.53207 .37726 m .53509 .37692 L .54119 .3804 L p F P
0 g
s
.545 .029 0 r
.49508 .379 m .4899 .37627 L .50296 .37584 L p F P
0 g
s
.545 .029 0 r
.50296 .37584 m .50643 .37766 L .49508 .379 L p F P
0 g
s
.487 0 0 r
.52877 .3813 m .52242 .38105 L .52574 .37724 L p F P
0 g
s
.487 0 0 r
.52574 .37724 m .5289 .37737 L .52877 .3813 L p F P
0 g
s
.425 0 0 r
.5513 .37779 m .55487 .376 L .56781 .37651 L p F P
0 g
s
.471 0 0 r
.54119 .3804 m .53513 .38108 L .53207 .37726 L p F P
0 g
s
.477 0 0 r
.5289 .37737 m .53207 .37726 L .53513 .38108 L p F P
0 g
s
.477 0 0 r
.53513 .38108 m .52877 .3813 L .5289 .37737 L p F P
0 g
s
.975 .679 .302 r
.26108 .18503 m .27059 .16987 L .27523 .18366 L p F P
0 g
s
.975 .679 .302 r
.27523 .18366 m .26599 .19885 L .26108 .18503 L p F P
0 g
s
.22 0 0 r
.6398 .35972 m .64295 .35154 L .65626 .34564 L p F P
0 g
s
.265 0 0 r
.64295 .35154 m .6398 .35972 L .62646 .36397 L p F P
0 g
s
0 0 .264 r
.78663 .21363 m .77865 .1984 L .78403 .18487 L p F P
0 g
s
0 0 .254 r
.77865 .1984 m .78663 .21363 L .78023 .22678 L p F P
0 g
s
.724 .207 0 r
.39187 .34818 m .38884 .33823 L .4018 .34489 L p F P
0 g
s
.724 .207 0 r
.4018 .34489 m .40469 .35398 L .39187 .34818 L p F P
0 g
s
1 1 0 r
.007 w
.78474 .09292 m
.79203 .09804 L
s
.5 Mabswid
.591 .061 0 r
.46393 .37485 m .4586 .36982 L .47255 .37191 L p F P
0 g
s
.591 .061 0 r
.47255 .37191 m .47688 .37595 L .46393 .37485 L p F P
0 g
s
.172 0 0 r
.65287 .35472 m .65626 .34564 L .66923 .33905 L p F P
0 g
s
.22 0 0 r
.65626 .34564 m .65287 .35472 L .6398 .35972 L p F P
0 g
s
.341 0 0 r
.58072 .37626 m .58527 .37225 L .59915 .37024 L p F P
0 g
s
.395 0 0 r
.58527 .37225 m .58072 .37626 L .56781 .37651 L p F P
0 g
s
.979 .703 .313 r
.25693 .17094 m .26668 .15587 L .27059 .16987 L p F P
0 g
s
.979 .703 .313 r
.27059 .16987 m .26108 .18503 L .25693 .17094 L p F P
0 g
s
.74 .223 0 r
.37939 .34166 m .37624 .3309 L .38884 .33823 L p F P
0 g
s
.74 .223 0 r
.38884 .33823 m .39187 .34818 L .37939 .34166 L p F P
0 g
s
.515 0 0 r
.50189 .38129 m .49508 .379 L .50643 .37766 L p F P
0 g
s
.515 0 0 r
.50643 .37766 m .51098 .37918 L .50189 .38129 L p F P
0 g
s
0 0 .275 r
.79231 .20013 m .78403 .18487 L .7887 .17108 L p F P
0 g
s
0 0 .264 r
.78403 .18487 m .79231 .20013 L .78663 .21363 L p F P
0 g
s
.425 0 0 r
.56781 .37651 m .56249 .37921 L .5513 .37779 L p F P
0 g
s
.411 0 0 r
.54667 .37928 m .5513 .37779 L .56249 .37921 L p F P
0 g
s
.122 0 0 r
.66566 .34899 m .66923 .33905 L .68184 .33178 L p F P
0 g
s
.172 0 0 r
.66923 .33905 m .66566 .34899 L .65287 .35472 L p F P
0 g
s
.54 .003 0 r
.48373 .37959 m .47688 .37595 L .4899 .37627 L p F P
0 g
s
.54 .003 0 r
.4899 .37627 m .49508 .379 L .48373 .37959 L p F P
0 g
s
.754 .24 0 r
.36728 .33444 m .36405 .32292 L .37624 .3309 L p F P
0 g
s
.754 .24 0 r
.37624 .3309 m .37939 .34166 L .36728 .33444 L p F P
0 g
s
.598 .056 0 r
.45109 .37298 m .44481 .36698 L .4586 .36982 L p F P
0 g
s
.598 .056 0 r
.4586 .36982 m .46393 .37485 L .45109 .37298 L p F P
0 g
s
.363 0 0 r
.56249 .37921 m .56781 .37651 L .58072 .37626 L p F P
0 g
s
.981 .726 .325 r
.25356 .15662 m .26351 .14169 L .26668 .15587 L p F P
0 g
s
.981 .726 .325 r
.26668 .15587 m .25693 .17094 L .25356 .15662 L p F P
0 g
s
1 1 0 r
.007 w
.26414 .09966 m
.2709 .09447 L
s
.5 Mabswid
0 .576 0 r
.81352 .26663 m .81502 .26492 L .82426 .27372 L closepath p F P
0 g
s
0 .551 0 r
.81222 .26912 m .81352 .26663 L .82426 .27372 L closepath p F P
0 g
s
0 0 .286 r
.79723 .18631 m .7887 .17108 L .79263 .15707 L p F P
0 g
s
0 0 .275 r
.7887 .17108 m .79723 .18631 L .79231 .20013 L p F P
0 g
s
0 .423 0 r
.81191 .27093 m .81222 .26912 L .82426 .27372 L closepath p F P
0 g
s
.283 0 0 r
.59355 .37524 m .59915 .37024 L .6129 .36749 L p F P
0 g
s
.341 0 0 r
.59915 .37024 m .59355 .37524 L .58072 .37626 L p F P
0 g
s
.483 0 0 r
.51002 .38302 m .50189 .38129 L .51098 .37918 L p F P
0 g
s
.483 0 0 r
.51098 .37918 m .5164 .38032 L .51002 .38302 L p F P
0 g
s
.411 0 0 r
.56249 .37921 m .55556 .38146 L .54667 .37928 L p F P
0 g
s
.403 0 0 r
.54119 .3804 m .54667 .37928 L .55556 .38146 L p F P
0 g
s
0 .515 0 r
.81275 .271 m .81191 .27093 L .82426 .27372 L closepath p F P
0 g
s
0 .739 0 r
.81426 .26928 m .81275 .271 L .82426 .27372 L closepath p F P
0 g
s
0 .681 0 r
.81555 .26679 m .81426 .26928 L .82426 .27372 L closepath p F P
0 g
s
0 .337 0 r
.81502 .26492 m .81587 .26498 L .82426 .27372 L closepath p F P
0 g
s
0 .586 0 r
.81587 .26498 m .81555 .26679 L .82426 .27372 L closepath p F P
0 g
s
0 1 0 r
.007 w
.77043 .2438 m
.81471 .26841 L
s
.5 Mabswid
.071 0 0 r
.6781 .34254 m .68184 .33178 L .69404 .32387 L p F P
0 g
s
.122 0 0 r
.68184 .33178 m .6781 .34254 L .66566 .34899 L p F P
0 g
s
.767 .257 0 r
.35559 .32653 m .35231 .31431 L .36405 .32292 L p F P
0 g
s
.767 .257 0 r
.36405 .32292 m .36728 .33444 L .35559 .32653 L p F P
0 g
s
.98 .748 .338 r
.25099 .14211 m .26109 .12738 L .26351 .14169 L p F P
0 g
s
.98 .748 .338 r
.26351 .14169 m .25356 .15662 L .25099 .14211 L p F P
0 g
s
.603 .051 0 r
.4384 .37034 m .4312 .36339 L .44481 .36698 L p F P
0 g
s
.603 .051 0 r
.44481 .36698 m .45109 .37298 L .4384 .37034 L p F P
0 g
s
.454 0 0 r
.51909 .38411 m .51002 .38302 L .5164 .38032 L p F P
0 g
s
.454 0 0 r
.5164 .38032 m .52242 .38105 L .51909 .38411 L p F P
0 g
s
0 0 .298 r
.80139 .17221 m .79263 .15707 L .79583 .14288 L p F P
0 g
s
0 0 .286 r
.79263 .15707 m .80139 .17221 L .79723 .18631 L p F P
0 g
s
.403 0 0 r
.55556 .38146 m .54733 .38314 L .54119 .3804 L p F P
0 g
s
.403 0 0 r
.53513 .38108 m .54119 .3804 L .54733 .38314 L p F P
0 g
s
.017 0 0 r
.69017 .33538 m .69404 .32387 L .70581 .31531 L p F P
0 g
s
.071 0 0 r
.69404 .32387 m .69017 .33538 L .6781 .34254 L p F P
0 g
s
.221 0 0 r
.60629 .37345 m .6129 .36749 L .62646 .36397 L p F P
0 g
s
.283 0 0 r
.6129 .36749 m .60629 .37345 L .59355 .37524 L p F P
0 g
s
.779 .274 0 r
.34435 .31795 m .34103 .30508 L .35231 .31431 L p F P
0 g
s
.779 .274 0 r
.35231 .31431 m .35559 .32653 L .34435 .31795 L p F P
0 g
s
.532 0 0 r
.47242 .37939 m .46393 .37485 L .47688 .37595 L p F P
0 g
s
.532 0 0 r
.47688 .37595 m .48373 .37959 L .47242 .37939 L p F P
0 g
s
.429 0 0 r
.52864 .3845 m .51909 .38411 L .52242 .38105 L p F P
0 g
s
.429 0 0 r
.52242 .38105 m .52877 .3813 L .52864 .3845 L p F P
0 g
s
.403 0 0 r
.54733 .38314 m .53821 .38417 L .53513 .38108 L p F P
0 g
s
.412 0 0 r
.52877 .3813 m .53513 .38108 L .53821 .38417 L p F P
0 g
s
.492 0 0 r
.49279 .38264 m .48373 .37959 L .49508 .379 L p F P
0 g
s
.492 0 0 r
.49508 .379 m .50189 .38129 L .49279 .38264 L p F P
0 g
s
.293 0 0 r
.57367 .37986 m .58072 .37626 L .59355 .37524 L p F P
0 g
s
.363 0 0 r
.58072 .37626 m .57367 .37986 L .56249 .37921 L p F P
0 g
s
.412 0 0 r
.53821 .38417 m .52864 .3845 L .52877 .3813 L p F P
0 g
s
.337 0 0 r
.55556 .38146 m .56249 .37921 L .57367 .37986 L p F P
0 g
s
.977 .769 .35 r
.24923 .12744 m .25943 .11296 L .26109 .12738 L p F P
0 g
s
.977 .769 .35 r
.26109 .12738 m .25099 .14211 L .24923 .12744 L p F P
0 g
s
0 0 .309 r
.80477 .15788 m .79583 .14288 L .79826 .12855 L p F P
0 g
s
.858 0 0 r
.80229 .16263 m .80432 .16216 L .80534 .17512 L closepath p F P
0 g
s
.812 0 0 r
.8023 .16337 m .80229 .16263 L .80534 .17512 L closepath p F P
0 g
s
.408 0 0 r
.80435 .16394 m .8023 .16337 L .80534 .17512 L closepath p F P
0 g
s
0 0 .298 r
.79583 .14288 m .80477 .15788 L .80139 .17221 L p F P
0 g
s
0 0 0 r
.70183 .32753 m .70581 .31531 L .7171 .30614 L p F P
0 g
s
.017 0 0 r
.70581 .31531 m .70183 .32753 L .69017 .33538 L p F P
0 g
s
.789 .291 0 r
.33359 .30872 m .33027 .29527 L .34103 .30508 L p F P
0 g
s
.789 .291 0 r
.34103 .30508 m .34435 .31795 L .33359 .30872 L p F P
0 g
s
.606 .046 0 r
.42588 .36693 m .41781 .35905 L .4312 .36339 L p F P
0 g
s
.606 .046 0 r
.4312 .36339 m .4384 .37034 L .42588 .36693 L p F P
0 g
s
.153 0 0 r
.61888 .37089 m .62646 .36397 L .6398 .35972 L p F P
0 g
s
.221 0 0 r
.62646 .36397 m .61888 .37089 L .60629 .37345 L p F P
0 g
s
.971 .789 .362 r
.24829 .11267 m .25854 .09848 L .25943 .11296 L p F P
0 g
s
.971 .789 .362 r
.25943 .11296 m .24923 .12744 L .24829 .11267 L p F P
0 g
s
0 0 0 r
.71305 .319 m .7171 .30614 L .72788 .29637 L p F P
0 g
s
0 0 0 r
.7171 .30614 m .71305 .319 L .70183 .32753 L p F P
0 g
s
0 0 .32 r
.80735 .14335 m .79826 .12855 L .79993 .11411 L p F P
0 g
s
0 0 .309 r
.79826 .12855 m .80735 .14335 L .80477 .15788 L p F P
0 g
s
.441 0 0 r
.50363 .38496 m .49279 .38264 L .50189 .38129 L p F P
0 g
s
.441 0 0 r
.50189 .38129 m .51002 .38302 L .50363 .38496 L p F P
0 g
s
.797 .309 0 r
.32336 .29886 m .32004 .28489 L .33027 .29527 L p F P
0 g
s
.797 .309 0 r
.33027 .29527 m .33359 .30872 L .32336 .29886 L p F P
0 g
s
.337 0 0 r
.57367 .37986 m .56445 .38286 L .55556 .38146 L p F P
0 g
s
.321 0 0 r
.54733 .38314 m .55556 .38146 L .56445 .38286 L p F P
0 g
s
.519 0 0 r
.46119 .37841 m .45109 .37298 L .46393 .37485 L p F P
0 g
s
.519 0 0 r
.46393 .37485 m .47242 .37939 L .46119 .37841 L p F P
0 g
s
.607 .041 0 r
.41359 .36274 m .40469 .35398 L .41781 .35905 L p F P
0 g
s
.607 .041 0 r
.41781 .35905 m .42588 .36693 L .41359 .36274 L p F P
0 g
s
.215 0 0 r
.58482 .37974 m .59355 .37524 L .60629 .37345 L p F P
0 g
s
.293 0 0 r
.59355 .37524 m .58482 .37974 L .57367 .37986 L p F P
0 g
s
1 1 0 r
.007 w
.79203 .09804 m
.79757 .10335 L
s
.5 Mabswid
0 .544 0 r
.2429 .27175 m .24414 .27421 L .23193 .27862 L closepath p F P
0 g
s
0 .722 0 r
.24139 .2698 m .2429 .27175 L .23193 .27862 L closepath p F P
0 g
s
0 .242 0 r
.24414 .27421 m .24439 .27576 L .23193 .27862 L closepath p F P
0 g
s
0 0 0 r
.72378 .30982 m .72788 .29637 L .73813 .28604 L p F P
0 g
s
0 0 0 r
.72788 .29637 m .72378 .30982 L .71305 .319 L p F P
0 g
s
.462 0 0 r
.4837 .38322 m .47242 .37939 L .48373 .37959 L p F P
0 g
s
.462 0 0 r
.48373 .37959 m .49279 .38264 L .4837 .38322 L p F P
0 g
s
.08 0 0 r
.63129 .36755 m .6398 .35972 L .65287 .35472 L p F P
0 g
s
.153 0 0 r
.6398 .35972 m .63129 .36755 L .61888 .37089 L p F P
0 g
s
.802 .327 0 r
.31368 .2884 m .31039 .27398 L .32004 .28489 L p F P
0 g
s
.802 .327 0 r
.32004 .28489 m .32336 .29886 L .31368 .2884 L p F P
0 g
s
0 .986 0 r
.24049 .26952 m .24139 .2698 L .23193 .27862 L closepath p F P
0 g
s
0 0 .332 r
.80911 .12866 m .79993 .11411 L .80083 .09961 L p F P
0 g
s
0 0 .32 r
.79993 .11411 m .80911 .12866 L .80735 .14335 L p F P
0 g
s
.252 0 0 r
.56445 .38286 m .57367 .37986 L .58482 .37974 L p F P
0 g
s
0 .077 0 r
.24074 .27107 m .24049 .26952 L .23193 .27862 L closepath p F P
0 g
s
0 .494 0 r
.24198 .27354 m .24074 .27107 L .23193 .27862 L closepath p F P
0 g
s
0 .692 0 r
.24349 .27549 m .24198 .27354 L .23193 .27862 L closepath p F P
0 g
s
0 .881 0 r
.24439 .27576 m .24349 .27549 L .23193 .27862 L closepath p F P
0 g
s
0 1 0 r
.007 w
.24173 .27305 m
.2898 .24571 L
s
.5 Mabswid
.394 0 0 r
.51574 .38642 m .50363 .38496 L .51002 .38302 L p F P
0 g
s
.394 0 0 r
.51002 .38302 m .51909 .38411 L .51574 .38642 L p F P
0 g
s
.321 0 0 r
.56445 .38286 m .55348 .38512 L .54733 .38314 L p F P
0 g
s
.318 0 0 r
.53821 .38417 m .54733 .38314 L .55348 .38512 L p F P
0 g
s
.606 .035 0 r
.40155 .35779 m .39187 .34818 L .40469 .35398 L p F P
0 g
s
.606 .035 0 r
.40469 .35398 m .41359 .36274 L .40155 .35779 L p F P
0 g
s
0 0 0 r
.73399 .3 m .73813 .28604 L .7478 .27516 L p F P
0 g
s
0 0 0 r
.73813 .28604 m .73399 .3 L .72378 .30982 L p F P
0 g
s
.805 .344 0 r
.30459 .27736 m .30133 .26255 L .31039 .27398 L p F P
0 g
s
.805 .344 0 r
.31039 .27398 m .31368 .2884 L .30459 .27736 L p F P
0 g
s
.356 0 0 r
.52851 .38694 m .51574 .38642 L .51909 .38411 L p F P
0 g
s
.356 0 0 r
.51909 .38411 m .52864 .3845 L .52851 .38694 L p F P
0 g
s
.318 0 0 r
.55348 .38512 m .5413 .3865 L .53821 .38417 L p F P
0 g
s
.33 0 0 r
.52864 .3845 m .53821 .38417 L .5413 .3865 L p F P
0 g
s
.502 0 0 r
.45006 .37665 m .4384 .37034 L .45109 .37298 L p F P
0 g
s
.502 0 0 r
.45109 .37298 m .46119 .37841 L .45006 .37665 L p F P
0 g
s
0 0 .332 r
.80083 .09961 m .81006 .11386 L .80911 .12866 L p F P
0 g
s
0 0 1 r
.007 w
.80425 .10175 m
.80774 .10783 L
s
.80378 .10094 m
.80425 .10175 L
s
.79849 .09171 m
.80378 .10094 L
s
1 1 0 r
.25916 .10501 m
.26414 .09966 L
s
.5 Mabswid
.33 0 0 r
.5413 .3865 m .52851 .38694 L .52864 .3845 L p F P
0 g
s
.004 0 0 r
.64349 .36343 m .65287 .35472 L .66566 .34899 L p F P
0 g
s
.08 0 0 r
.65287 .35472 m .64349 .36343 L .63129 .36755 L p F P
0 g
s
.128 0 0 r
.59589 .37883 m .60629 .37345 L .61888 .37089 L p F P
0 g
s
.215 0 0 r
.60629 .37345 m .59589 .37883 L .58482 .37974 L p F P
0 g
s
0 0 0 r
.74365 .28958 m .7478 .27516 L .75688 .26376 L p F P
0 g
s
0 0 0 r
.7478 .27516 m .74365 .28958 L .73399 .3 L p F P
0 g
s
.805 .361 0 r
.29611 .26577 m .2929 .25064 L .30133 .26255 L p F P
0 g
s
.805 .361 0 r
.30133 .26255 m .30459 .27736 L .29611 .26577 L p F P
0 g
s
.388 0 0 r
.49724 .38612 m .4837 .38322 L .49279 .38264 L p F P
0 g
s
.388 0 0 r
.49279 .38264 m .50363 .38496 L .49724 .38612 L p F P
0 g
s
.601 .03 0 r
.3898 .35207 m .37939 .34166 L .39187 .34818 L p F P
0 g
s
.601 .03 0 r
.39187 .34818 m .40155 .35779 L .3898 .35207 L p F P
0 g
s
.252 0 0 r
.58482 .37974 m .57333 .38349 L .56445 .38286 L p F P
0 g
s
.224 0 0 r
.55348 .38512 m .56445 .38286 L .57333 .38349 L p F P
0 g
s
.423 0 0 r
.47466 .383 m .46119 .37841 L .47242 .37939 L p F P
0 g
s
.423 0 0 r
.47242 .37939 m .4837 .38322 L .47466 .383 L p F P
0 g
s
.154 0 0 r
.57333 .38349 m .58482 .37974 L .59589 .37883 L p F P
0 g
s
0 0 0 r
.65543 .35854 m .66566 .34899 L .6781 .34254 L p F P
0 g
s
.004 0 0 r
.66566 .34899 m .65543 .35854 L .64349 .36343 L p F P
0 g
s
0 0 0 r
.75273 .27857 m .75688 .26376 L .76533 .25188 L p F P
0 g
s
0 0 0 r
.75688 .26376 m .75273 .27857 L .74365 .28958 L p F P
0 g
s
.803 .378 0 r
.28828 .25367 m .28513 .23829 L .2929 .25064 L p F P
0 g
s
.803 .378 0 r
.2929 .25064 m .29611 .26577 L .28828 .25367 L p F P
0 g
s
.479 0 0 r
.43906 .37408 m .42588 .36693 L .4384 .37034 L p F P
0 g
s
.479 0 0 r
.4384 .37034 m .45006 .37665 L .43906 .37408 L p F P
0 g
s
.033 0 0 r
.60687 .37712 m .61888 .37089 L .63129 .36755 L p F P
0 g
s
.128 0 0 r
.61888 .37089 m .60687 .37712 L .59589 .37883 L p F P
0 g
s
.592 .025 0 r
.37839 .34561 m .36728 .33444 L .37939 .34166 L p F P
0 g
s
.592 .025 0 r
.37939 .34166 m .3898 .35207 L .37839 .34561 L p F P
0 g
s
.319 0 0 r
.51239 .38795 m .49724 .38612 L .50363 .38496 L p F P
0 g
s
.319 0 0 r
.50363 .38496 m .51574 .38642 L .51239 .38795 L p F P
0 g
s
.224 0 0 r
.57333 .38349 m .55963 .38631 L .55348 .38512 L p F P
0 g
s
.215 0 0 r
.5413 .3865 m .55348 .38512 L .55963 .38631 L p F P
0 g
s
0 0 0 r
.76119 .26701 m .76533 .25188 L .77312 .23954 L p F P
0 g
s
0 0 0 r
.76533 .25188 m .76119 .26701 L .75273 .27857 L p F P
0 g
s
.797 .394 0 r
.28113 .24107 m .27804 .22551 L .28513 .23829 L p F P
0 g
s
.797 .394 0 r
.28513 .23829 m .28828 .25367 L .28113 .24107 L p F P
0 g
s
0 0 0 r
.66709 .35289 m .6781 .34254 L .69017 .33538 L p F P
0 g
s
0 0 0 r
.6781 .34254 m .66709 .35289 L .65543 .35854 L p F P
0 g
s
0 0 0 r
.80924 .16281 m .80925 .16355 L .80534 .17512 L closepath p F P
0 g
s
.473 0 0 r
.80719 .16224 m .80924 .16281 L .80534 .17512 L closepath p F P
0 g
s
.686 0 0 r
.80432 .16216 m .80719 .16224 L .80534 .17512 L closepath p F P
0 g
s
.671 0 0 r
.80723 .16402 m .80435 .16394 L .80534 .17512 L closepath p F P
0 g
s
.862 0 0 r
.80925 .16355 m .80723 .16402 L .80534 .17512 L closepath p F P
0 g
s
1 0 0 r
.007 w
.80574 .16398 m
.80626 .1495 L
s
.80766 .11015 m
.80774 .10783 L
s
.5 Mabswid
.264 0 0 r
.52837 .3886 m .51239 .38795 L .51574 .38642 L p F P
0 g
s
.264 0 0 r
.51574 .38642 m .52851 .38694 L .52837 .3886 L p F P
0 g
s
.215 0 0 r
.55963 .38631 m .54439 .38805 L .5413 .3865 L p F P
0 g
s
.228 0 0 r
.52851 .38694 m .5413 .3865 L .54439 .38805 L p F P
0 g
s
.376 0 0 r
.46568 .38197 m .45006 .37665 L .46119 .37841 L p F P
0 g
s
.376 0 0 r
.46119 .37841 m .47466 .383 L .46568 .38197 L p F P
0 g
s
.579 .02 0 r
.36735 .3384 m .35559 .32653 L .36728 .33444 L p F P
0 g
s
.579 .02 0 r
.36728 .33444 m .37839 .34561 L .36735 .3384 L p F P
0 g
s
.228 0 0 r
.54439 .38805 m .52837 .3886 L .52851 .38694 L p F P
0 g
s
1 1 0 r
.007 w
.79757 .10335 m
.80128 .10879 L
s
.5 Mabswid
.449 0 0 r
.42824 .37072 m .41359 .36274 L .42588 .36693 L p F P
0 g
s
.449 0 0 r
.42588 .36693 m .43906 .37408 L .42824 .37072 L p F P
0 g
s
.322 0 0 r
.49088 .38648 m .47466 .383 L .4837 .38322 L p F P
0 g
s
.322 0 0 r
.4837 .38322 m .49724 .38612 L .49088 .38648 L p F P
0 g
s
0 0 0 r
.769 .25493 m .77312 .23954 L .78023 .22678 L p F P
0 g
s
0 0 0 r
.77312 .23954 m .769 .25493 L .76119 .26701 L p F P
0 g
s
.788 .409 0 r
.27469 .22803 m .27165 .21236 L .27804 .22551 L p F P
0 g
s
.788 .409 0 r
.27804 .22551 m .28113 .24107 L .27469 .22803 L p F P
0 g
s
.045 0 0 r
.58217 .38333 m .59589 .37883 L .60687 .37712 L p F P
0 g
s
.154 0 0 r
.59589 .37883 m .58217 .38333 L .57333 .38349 L p F P
0 g
s
.112 0 0 r
.55963 .38631 m .57333 .38349 L .58217 .38333 L p F P
0 g
s
0 0 0 r
.61771 .37462 m .63129 .36755 L .64349 .36343 L p F P
0 g
s
.033 0 0 r
.63129 .36755 m .61771 .37462 L .60687 .37712 L p F P
0 g
s
0 0 0 r
.67842 .34649 m .69017 .33538 L .70183 .32753 L p F P
0 g
s
0 0 0 r
.69017 .33538 m .67842 .34649 L .66709 .35289 L p F P
0 g
s
0 0 0 r
.77614 .24235 m .78023 .22678 L .78663 .21363 L p F P
0 g
s
0 0 0 r
.78023 .22678 m .77614 .24235 L .769 .25493 L p F P
0 g
s
.775 .422 0 r
.26897 .21457 m .26599 .19885 L .27165 .21236 L p F P
0 g
s
.775 .422 0 r
.27165 .21236 m .27469 .22803 L .26897 .21457 L p F P
0 g
s
.562 .016 0 r
.35671 .33047 m .34435 .31795 L .35559 .32653 L p F P
0 g
s
.562 .016 0 r
.35559 .32653 m .36735 .3384 L .35671 .33047 L p F P
0 g
s
1 1 0 r
.007 w
.25602 .11049 m
.25916 .10501 L
s
.5 Mabswid
.414 0 0 r
.41762 .36655 m .40155 .35779 L .41359 .36274 L p F P
0 g
s
.414 0 0 r
.41359 .36274 m .42824 .37072 L .41762 .36655 L p F P
0 g
s
.229 0 0 r
.50904 .38868 m .49088 .38648 L .49724 .38612 L p F P
0 g
s
.229 0 0 r
.49724 .38612 m .51239 .38795 L .50904 .38868 L p F P
0 g
s
0 0 0 r
.68938 .33934 m .70183 .32753 L .71305 .319 L p F P
0 g
s
0 0 0 r
.70183 .32753 m .68938 .33934 L .67842 .34649 L p F P
0 g
s
.112 0 0 r
.58217 .38333 m .56576 .38671 L .55963 .38631 L p F P
0 g
s
.096 0 0 r
.54439 .38805 m .55963 .38631 L .56576 .38671 L p F P
0 g
s
0 0 0 r
.78258 .22932 m .78663 .21363 L .79231 .20013 L p F P
0 g
s
0 0 0 r
.78663 .21363 m .78258 .22932 L .77614 .24235 L p F P
0 g
s
.759 .435 0 r
.264 .20074 m .26108 .18503 L .26599 .19885 L p F P
0 g
s
.759 .435 0 r
.26599 .19885 m .26897 .21457 L .264 .20074 L p F P
0 g
s
0 .506 0 r
.67548 .4114 m .67806 .41021 L .68194 .4226 L closepath p F P
0 g
s
0 .549 0 r
.67348 .41259 m .67548 .4114 L .68194 .4226 L closepath p F P
0 g
s
0 .506 0 r
.67548 .4114 m .67806 .41021 L .68194 .4226 L closepath p F P
0 g
s
0 .549 0 r
.67348 .41259 m .67548 .4114 L .68194 .4226 L closepath p F P
0 g
s
.319 0 0 r
.4568 .38014 m .43906 .37408 L .45006 .37665 L p F P
0 g
s
.319 0 0 r
.45006 .37665 m .46568 .38197 L .4568 .38014 L p F P
0 g
s
0 0 0 r
.62839 .37132 m .64349 .36343 L .65543 .35854 L p F P
0 g
s
0 0 0 r
.64349 .36343 m .62839 .37132 L .61771 .37462 L p F P
0 g
s
0 .347 0 r
.67806 .41021 m .6797 .4097 L .68194 .4226 L closepath p F P
0 g
s
0 .347 0 r
.67806 .41021 m .6797 .4097 L .68194 .4226 L closepath p F P
0 g
s
0 0 0 r
.59095 .38236 m .60687 .37712 L .61771 .37462 L p F P
0 g
s
.045 0 0 r
.60687 .37712 m .59095 .38236 L .58217 .38333 L p F P
0 g
s
.541 .012 0 r
.34651 .32183 m .33359 .30872 L .34435 .31795 L p F P
0 g
s
.541 .012 0 r
.34435 .31795 m .35671 .33047 L .34651 .32183 L p F P
0 g
s
0 .342 0 r
.67322 .41307 m .67348 .41259 L .68194 .4226 L closepath p F P
0 g
s
0 .342 0 r
.67322 .41307 m .67348 .41259 L .68194 .4226 L closepath p F P
0 g
s
.399 0 0 r
.2528 .16616 m .25437 .16674 L .25109 .17911 L closepath p F P
0 g
s
.908 0 0 r
.25437 .16674 m .25376 .16749 L .25109 .17911 L closepath p F P
0 g
s
.685 0 0 r
.24997 .16608 m .2528 .16616 L .25109 .17911 L closepath p F P
0 g
s
.838 0 0 r
.24754 .16655 m .24997 .16608 L .25109 .17911 L closepath p F P
0 g
s
.986 0 0 r
.24693 .1673 m .24754 .16655 L .25109 .17911 L closepath p F P
0 g
s
.288 0 0 r
.2485 .16788 m .24693 .1673 L .25109 .17911 L closepath p F P
0 g
s
.669 0 0 r
.25133 .16796 m .2485 .16788 L .25109 .17911 L closepath p F P
0 g
s
.843 0 0 r
.25376 .16749 m .25133 .16796 L .25109 .17911 L closepath p F P
0 g
s
1 0 0 r
.007 w
.24866 .11145 m
.24868 .11212 L
s
.24923 .12747 m
.25069 .16794 L
s
.5 Mabswid
.244 0 0 r
.48455 .38603 m .46568 .38197 L .47466 .383 L p F P
0 g
s
.244 0 0 r
.47466 .383 m .49088 .38648 L .48455 .38603 L p F P
0 g
s
0 .646 0 r
.6797 .4097 m .67945 .41018 L .68194 .4226 L closepath p F P
0 g
s
0 .646 0 r
.6797 .4097 m .67945 .41018 L .68194 .4226 L closepath p F P
0 g
s
0 .527 0 r
.67486 .41256 m .67322 .41307 L .68194 .4226 L closepath p F P
0 g
s
0 .634 0 r
.67744 .41136 m .67486 .41256 L .68194 .4226 L closepath p F P
0 g
s
0 .706 0 r
.67945 .41018 m .67744 .41136 L .68194 .4226 L closepath p F P
0 g
s
0 .527 0 r
.67486 .41256 m .67322 .41307 L .68194 .4226 L closepath p F P
0 g
s
0 .634 0 r
.67744 .41136 m .67486 .41256 L .68194 .4226 L closepath p F P
0 g
s
0 1 0 r
.007 w
.65154 .36038 m
.67664 .41174 L
s
.5 Mabswid
0 .706 0 r
.67945 .41018 m .67744 .41136 L .68194 .4226 L closepath p F P
0 g
s
0 .639 0 r
.86408 .10657 m .86436 .10424 L .87716 .10738 L closepath p F P
0 g
s
0 .52 0 r
.86414 .10941 m .86408 .10657 L .87716 .10738 L closepath p F P
0 g
s
.156 0 0 r
.52824 .38946 m .50904 .38868 L .51239 .38795 L p F P
0 g
s
.156 0 0 r
.51239 .38795 m .52837 .3886 L .52824 .38946 L p F P
0 g
s
0 .278 0 r
.86452 .11112 m .86414 .10941 L .87716 .10738 L closepath p F P
0 g
s
0 0 0 r
.56576 .38671 m .58217 .38333 L .59095 .38236 L p F P
0 g
s
.096 0 0 r
.56576 .38671 m .54748 .3888 L .54439 .38805 L p F P
0 g
s
.11 0 0 r
.52837 .3886 m .54439 .38805 L .54748 .3888 L p F P
0 g
s
0 0 0 r
.78829 .21586 m .79231 .20013 L .79723 .18631 L p F P
0 g
s
0 0 0 r
.79231 .20013 m .78829 .21586 L .78258 .22932 L p F P
0 g
s
.74 .447 0 r
.2598 .18657 m .25693 .17094 L .26108 .18503 L p F P
0 g
s
.74 .447 0 r
.26108 .18503 m .264 .20074 L .2598 .18657 L p F P
0 g
s
0 0 0 r
.69995 .33146 m .71305 .319 L .72378 .30982 L p F P
0 g
s
0 0 0 r
.71305 .319 m .69995 .33146 L .68938 .33934 L p F P
0 g
s
0 .655 0 r
.86436 .10424 m .86483 .10379 L .87716 .10738 L closepath p F P
0 g
s
.11 0 0 r
.54748 .3888 m .52824 .38946 L .52837 .3886 L p F P
0 g
s
0 .862 0 r
.86498 .11068 m .86452 .11112 L .87716 .10738 L closepath p F P
0 g
s
.373 0 0 r
.40724 .36159 m .3898 .35207 L .40155 .35779 L p F P
0 g
s
.373 0 0 r
.40155 .35779 m .41762 .36655 L .40724 .36159 L p F P
0 g
s
0 .764 0 r
.86527 .10835 m .86498 .11068 L .87716 .10738 L closepath p F P
0 g
s
0 .614 0 r
.86521 .1055 m .86527 .10835 L .87716 .10738 L closepath p F P
0 g
s
0 .386 0 r
.86483 .10379 m .86521 .1055 L .87716 .10738 L closepath p F P
0 g
s
0 1 0 r
.007 w
.80774 .10783 m
.86525 .10745 L
s
.5 Mabswid
.517 .008 0 r
.33679 .3125 m .32336 .29886 L .33359 .30872 L p F P
0 g
s
.517 .008 0 r
.33359 .30872 m .34651 .32183 L .33679 .3125 L p F P
0 g
s
0 .533 0 r
.38495 .41349 m .38752 .41473 L .38038 .42556 L closepath p F P
0 g
s
0 .709 0 r
.38282 .41267 m .38495 .41349 L .38038 .42556 L closepath p F P
0 g
s
0 .248 0 r
.38752 .41473 m .38905 .41567 L .38038 .42556 L closepath p F P
0 g
s
0 0 0 r
.63886 .36722 m .65543 .35854 L .66709 .35289 L p F P
0 g
s
0 0 0 r
.65543 .35854 m .63886 .36722 L .62839 .37132 L p F P
0 g
s
0 0 0 r
.79325 .20203 m .79723 .18631 L .80139 .17221 L p F P
0 g
s
0 0 0 r
.79723 .18631 m .79325 .20203 L .78829 .21586 L p F P
0 g
s
.718 .457 0 r
.25639 .17211 m .25356 .15662 L .25693 .17094 L p F P
0 g
s
.718 .457 0 r
.25693 .17094 m .2598 .18657 L .25639 .17211 L p F P
0 g
s
0 .849 0 r
.3824 .41275 m .38282 .41267 L .38038 .42556 L closepath p F P
0 g
s
0 .946 0 r
.38905 .41567 m .38863 .41575 L .38038 .42556 L closepath p F P
0 g
s
.255 0 0 r
.44805 .37748 m .42824 .37072 L .43906 .37408 L p F P
0 g
s
.255 0 0 r
.43906 .37408 m .4568 .38014 L .44805 .37748 L p F P
0 g
s
0 0 0 r
.72378 .30982 m .71008 .32287 L .69995 .33146 L p F P
0 g
s
.494 .82 .514 r
.71008 .32287 m .72378 .30982 L .73399 .3 L p F P
0 g
s
0 .292 0 r
.38392 .41369 m .3824 .41275 L .38038 .42556 L closepath p F P
0 g
s
0 .578 0 r
.38651 .41494 m .38392 .41369 L .38038 .42556 L closepath p F P
0 g
s
0 .774 0 r
.38863 .41575 m .38651 .41494 L .38038 .42556 L closepath p F P
0 g
s
0 1 0 r
.007 w
.38559 .4145 m
.40989 .36286 L
s
.5 Mabswid
0 0 0 r
.59963 .38057 m .61771 .37462 L .62839 .37132 L p F P
0 g
s
0 0 0 r
.61771 .37462 m .59963 .38057 L .59095 .38236 L p F P
0 g
s
1 1 0 r
.007 w
.80128 .10879 m
.80308 .11433 L
s
.5 Mabswid
.126 0 0 r
.50572 .38859 m .48455 .38603 L .49088 .38648 L p F P
0 g
s
.126 0 0 r
.49088 .38648 m .50904 .38868 L .50572 .38859 L p F P
0 g
s
0 0 0 r
.59095 .38236 m .57186 .3863 L .56576 .38671 L p F P
0 g
s
0 0 0 r
.54748 .3888 m .56576 .38671 L .57186 .3863 L p F P
0 g
s
0 0 .51 r
.32758 .30251 m .31368 .2884 L .32336 .29886 L p F P
0 g
s
0 0 .51 r
.32336 .29886 m .33679 .3125 L .32758 .30251 L p F P
0 g
s
0 0 0 r
.80139 .17221 m .79745 .18785 L .79325 .20203 L p F P
0 g
s
.698 .703 .173 r
.79745 .18785 m .80139 .17221 L .80477 .15788 L p F P
0 g
s
0 0 .127 r
.25378 .15739 m .25099 .14211 L .25356 .15662 L p F P
0 g
s
0 0 .127 r
.25356 .15662 m .25639 .17211 L .25378 .15739 L p F P
0 g
s
0 .237 .635 r
.39714 .35584 m .37839 .34561 L .3898 .35207 L p F P
0 g
s
0 .237 .635 r
.3898 .35207 m .40724 .36159 L .39714 .35584 L p F P
0 g
s
.157 0 0 r
.47828 .38476 m .4568 .38014 L .46568 .38197 L p F P
0 g
s
.157 0 0 r
.46568 .38197 m .48455 .38603 L .47828 .38476 L p F P
0 g
s
0 0 0 r
.57186 .3863 m .59095 .38236 L .59963 .38057 L p F P
0 g
s
0 0 0 r
.66709 .35289 m .6491 .36232 L .63886 .36722 L p F P
0 g
s
.379 .814 .656 r
.6491 .36232 m .66709 .35289 L .67842 .34649 L p F P
0 g
s
.569 .86 .542 r
.71973 .31359 m .73399 .3 L .74365 .28958 L p F P
0 g
s
.494 .82 .514 r
.73399 .3 m .71973 .31359 L .71008 .32287 L p F P
0 g
s
.036 0 0 r
.52811 .38951 m .50572 .38859 L .50904 .38868 L p F P
0 g
s
.036 0 0 r
.50904 .38868 m .52824 .38946 L .52811 .38951 L p F P
0 g
s
0 0 .123 r
.252 .14247 m .24923 .12744 L .25099 .14211 L p F P
0 g
s
0 0 .123 r
.25099 .14211 m .25378 .15739 L .252 .14247 L p F P
0 g
s
.737 .706 .17 r
.80085 .17338 m .80477 .15788 L .80735 .14335 L p F P
0 g
s
.698 .703 .173 r
.80477 .15788 m .80085 .17338 L .79745 .18785 L p F P
0 g
s
0 0 0 r
.57186 .3863 m .55054 .38873 L .54748 .3888 L p F P
0 g
s
0 0 0 r
.52824 .38946 m .54748 .3888 L .55054 .38873 L p F P
0 g
s
1 1 0 r
.007 w
.25482 .11606 m
.25602 .11049 L
s
.5 Mabswid
0 0 .533 r
.31891 .29187 m .30459 .27736 L .31368 .2884 L p F P
0 g
s
0 0 .533 r
.31368 .2884 m .32758 .30251 L .31891 .29187 L p F P
0 g
s
0 0 0 r
.55054 .38873 m .52811 .38951 L .52824 .38946 L p F P
0 g
s
0 .389 .719 r
.43944 .374 m .41762 .36655 L .42824 .37072 L p F P
0 g
s
0 .389 .719 r
.42824 .37072 m .44805 .37748 L .43944 .374 L p F P
0 g
s
0 .611 0 r
.19137 .11092 m .19137 .11379 L .1783 .11191 L closepath p F P
0 g
s
0 .749 0 r
.19114 .10858 m .19137 .11092 L .1783 .11191 L closepath p F P
0 g
s
0 .413 0 r
.19137 .11379 m .19113 .11551 L .1783 .11191 L closepath p F P
0 g
s
0 0 0 r
.62839 .37132 m .60819 .37797 L .59963 .38057 L p F P
0 g
s
.309 .793 .733 r
.60819 .37797 m .62839 .37132 L .63886 .36722 L p F P
0 g
s
0 .26 .687 r
.38734 .3493 m .36735 .3384 L .37839 .34561 L p F P
0 g
s
0 .26 .687 r
.37839 .34561 m .39714 .35584 L .38734 .3493 L p F P
0 g
s
0 .909 0 r
.19081 .10814 m .19114 .10858 L .1783 .11191 L closepath p F P
0 g
s
.639 .893 .564 r
.72888 .30363 m .74365 .28958 L .75273 .27857 L p F P
0 g
s
.569 .86 .542 r
.74365 .28958 m .72888 .30363 L .71973 .31359 L p F P
0 g
s
0 0 .118 r
.25104 .1274 m .24829 .11267 L .24923 .12744 L p F P
0 g
s
0 0 1 r
.007 w
.2482 .11279 m
.24827 .11258 L
s
.24827 .11258 m
.24866 .11145 L
s
.5 Mabswid
0 0 .118 r
.24923 .12744 m .252 .14247 L .25104 .1274 L p F P
0 g
s
.772 .705 .166 r
.80345 .15865 m .80735 .14335 L .80911 .12866 L p F P
0 g
s
.737 .706 .17 r
.80735 .14335 m .80345 .15865 L .80085 .17338 L p F P
0 g
s
0 .589 0 r
.19113 .11551 m .1908 .11508 L .1783 .11191 L closepath p F P
0 g
s
0 .236 0 r
.19058 .10986 m .19081 .10814 L .1783 .11191 L closepath p F P
0 g
s
0 .515 0 r
.19057 .11274 m .19058 .10986 L .1783 .11191 L closepath p F P
0 g
s
0 1 0 r
.007 w
.19058 .11183 m
.24866 .11145 L
s
.5 Mabswid
0 .643 0 r
.1908 .11508 m .19057 .11274 L .1783 .11191 L closepath p F P
0 g
s
.475 .875 .708 r
.65907 .35662 m .67842 .34649 L .68938 .33934 L p F P
0 g
s
.379 .814 .656 r
.67842 .34649 m .65907 .35662 L .6491 .36232 L p F P
0 g
s
0 0 .551 r
.31082 .28061 m .29611 .26577 L .30459 .27736 L p F P
0 g
s
0 0 .551 r
.30459 .27736 m .31891 .29187 L .31082 .28061 L p F P
0 g
s
0 .555 .771 r
.50242 .38767 m .47828 .38476 L .48455 .38603 L p F P
0 g
s
0 .555 .771 r
.48455 .38603 m .50572 .38859 L .50242 .38767 L p F P
0 g
s
0 0 0 r
.59963 .38057 m .57789 .38506 L .57186 .3863 L p F P
0 g
s
.166 .705 .776 r
.55054 .38873 m .57186 .3863 L .57789 .38506 L p F P
0 g
s
0 .502 .779 r
.47209 .38265 m .44805 .37748 L .4568 .38014 L p F P
0 g
s
0 .502 .779 r
.4568 .38014 m .47828 .38476 L .47209 .38265 L p F P
0 g
s
.803 .7 .161 r
.80524 .14371 m .80911 .12866 L .81006 .11386 L p F P
0 g
s
.772 .705 .166 r
.80911 .12866 m .80524 .14371 L .80345 .15865 L p F P
0 g
s
.267 .774 .788 r
.57789 .38506 m .59963 .38057 L .60819 .37797 L p F P
0 g
s
.702 .919 .581 r
.73749 .29302 m .75273 .27857 L .76119 .26701 L p F P
0 g
s
.639 .893 .564 r
.75273 .27857 m .73749 .29302 L .72888 .30363 L p F P
0 g
s
0 .279 .73 r
.37789 .34198 m .35671 .33047 L .36735 .3384 L p F P
0 g
s
0 .279 .73 r
.36735 .3384 m .38734 .3493 L .37789 .34198 L p F P
0 g
s
0 .43 .788 r
.43102 .36969 m .40724 .36159 L .41762 .36655 L p F P
0 g
s
0 .43 .788 r
.41762 .36655 m .43944 .374 L .43102 .36969 L p F P
0 g
s
0 .001 .564 r
.30334 .26877 m .28828 .25367 L .29611 .26577 L p F P
0 g
s
0 .001 .564 r
.29611 .26577 m .31082 .28061 L .30334 .26877 L p F P
0 g
s
.803 .7 .161 r
.81006 .11386 m .80619 .12861 L .80524 .14371 L p F P
0 g
s
.417 .862 .801 r
.61661 .37454 m .63886 .36722 L .6491 .36232 L p F P
0 g
s
.309 .793 .733 r
.63886 .36722 m .61661 .37454 L .60819 .37797 L p F P
0 g
s
.084 .638 .814 r
.52797 .38872 m .50242 .38767 L .50572 .38859 L p F P
0 g
s
.084 .638 .814 r
.50572 .38859 m .52811 .38951 L .52797 .38872 L p F P
0 g
s
.562 .922 .749 r
.66874 .35013 m .68938 .33934 L .69995 .33146 L p F P
0 g
s
.475 .875 .708 r
.68938 .33934 m .66874 .35013 L .65907 .35662 L p F P
0 g
s
.166 .705 .776 r
.57789 .38506 m .55358 .38783 L .55054 .38873 L p F P
0 g
s
.146 .688 .815 r
.52811 .38951 m .55054 .38873 L .55358 .38783 L p F P
0 g
s
1 1 0 r
.007 w
.80291 .11995 m
.80308 .11433 L
s
.5 Mabswid
.758 .937 .594 r
.74552 .28179 m .76119 .26701 L .769 .25493 L p F P
0 g
s
.702 .919 .581 r
.76119 .26701 m .74552 .28179 L .73749 .29302 L p F P
0 g
s
.146 .688 .815 r
.55358 .38783 m .52797 .38872 L .52811 .38951 L p F P
0 g
s
0 .001 .573 r
.2965 .25638 m .28113 .24107 L .28828 .25367 L p F P
0 g
s
0 .001 .573 r
.28828 .25367 m .30334 .26877 L .2965 .25638 L p F P
0 g
s
0 .294 .762 r
.36881 .33391 m .34651 .32183 L .35671 .33047 L p F P
0 g
s
0 .294 .762 r
.35671 .33047 m .37789 .34198 L .36881 .33391 L p F P
0 g
s
.023 .553 .855 r
.466 .37969 m .43944 .374 L .44805 .37748 L p F P
0 g
s
.023 .553 .855 r
.44805 .37748 m .47209 .38265 L .466 .37969 L p F P
0 g
s
.087 .622 .862 r
.49916 .38591 m .47209 .38265 L .47828 .38476 L p F P
0 g
s
.087 .622 .862 r
.47828 .38476 m .50242 .38767 L .49916 .38591 L p F P
0 g
s
.267 .774 .788 r
.60819 .37797 m .58385 .38299 L .57789 .38506 L p F P
0 g
s
.289 .785 .867 r
.55358 .38783 m .57789 .38506 L .58385 .38299 L p F P
0 g
s
.381 .844 .863 r
.58385 .38299 m .60819 .37797 L .61661 .37454 L p F P
0 g
s
.807 .948 .601 r
.75296 .26998 m .769 .25493 L .77614 .24235 L p F P
0 g
s
.758 .937 .594 r
.769 .25493 m .75296 .26998 L .74552 .28179 L p F P
0 g
s
1 1 0 r
.007 w
.25482 .11606 m
.25562 .12169 L
s
.5 Mabswid
0 .461 .839 r
.4228 .36456 m .39714 .35584 L .40724 .36159 L p F P
0 g
s
0 .461 .839 r
.40724 .36159 m .43102 .36969 L .4228 .36456 L p F P
0 g
s
.638 .957 .78 r
.67807 .34286 m .69995 .33146 L .71008 .32287 L p F P
0 g
s
.562 .922 .749 r
.69995 .33146 m .67807 .34286 L .66874 .35013 L p F P
0 g
s
0 .001 .577 r
.29033 .24346 m .27469 .22803 L .28113 .24107 L p F P
0 g
s
0 .001 .577 r
.28113 .24107 m .2965 .25638 L .29033 .24346 L p F P
0 g
s
.512 .914 .851 r
.62485 .37028 m .6491 .36232 L .65907 .35662 L p F P
0 g
s
.417 .862 .801 r
.6491 .36232 m .62485 .37028 L .61661 .37454 L p F P
0 g
s
0 .305 .784 r
.36014 .32509 m .33679 .3125 L .34651 .32183 L p F P
0 g
s
0 .305 .784 r
.34651 .32183 m .36881 .33391 L .36014 .32509 L p F P
0 g
s
.849 .953 .604 r
.75976 .2576 m .77614 .24235 L .78258 .22932 L p F P
0 g
s
.807 .948 .601 r
.77614 .24235 m .75976 .2576 L .75296 .26998 L p F P
0 g
s
.197 .705 .899 r
.52785 .38709 m .49916 .38591 L .50242 .38767 L p F P
0 g
s
.197 .705 .899 r
.50242 .38767 m .52797 .38872 L .52785 .38709 L p F P
0 g
s
.289 .785 .867 r
.58385 .38299 m .55659 .38609 L .55358 .38783 L p F P
0 g
s
.263 .76 .9 r
.52797 .38872 m .55358 .38783 L .55659 .38609 L p F P
0 g
s
0 0 .578 r
.28484 .23007 m .26897 .21457 L .27469 .22803 L p F P
0 g
s
0 0 .578 r
.27469 .22803 m .29033 .24346 L .28484 .23007 L p F P
0 g
s
.703 .981 .8 r
.68703 .33483 m .71008 .32287 L .71973 .31359 L p F P
0 g
s
.638 .957 .78 r
.71008 .32287 m .68703 .33483 L .67807 .34286 L p F P
0 g
s
.263 .76 .9 r
.55659 .38609 m .52785 .38709 L .52797 .38872 L p F P
0 g
s
.019 .483 .875 r
.41482 .3586 m .38734 .3493 L .39714 .35584 L p F P
0 g
s
.019 .483 .875 r
.39714 .35584 m .4228 .36456 L .41482 .3586 L p F P
0 g
s
.105 .59 .908 r
.46003 .3759 m .43102 .36969 L .43944 .374 L p F P
0 g
s
.105 .59 .908 r
.43944 .374 m .466 .37969 L .46003 .3759 L p F P
0 g
s
.885 .952 .603 r
.76589 .24469 m .78258 .22932 L .78829 .21586 L p F P
0 g
s
.849 .953 .604 r
.78258 .22932 m .76589 .24469 L .75976 .2576 L p F P
0 g
s
.478 .893 .914 r
.58972 .38007 m .61661 .37454 L .62485 .37028 L p F P
0 g
s
.381 .844 .863 r
.61661 .37454 m .58972 .38007 L .58385 .38299 L p F P
0 g
s
.182 .669 .925 r
.49596 .3833 m .466 .37969 L .47209 .38265 L p F P
0 g
s
.182 .669 .925 r
.47209 .38265 m .49916 .38591 L .49596 .3833 L p F P
0 g
s
.593 .949 .885 r
.63289 .36519 m .65907 .35662 L .66874 .35013 L p F P
0 g
s
.512 .914 .851 r
.65907 .35662 m .63289 .36519 L .62485 .37028 L p F P
0 g
s
0 0 .575 r
.28007 .21623 m .264 .20074 L .26897 .21457 L p F P
0 g
s
0 0 .575 r
.26897 .21457 m .28484 .23007 L .28007 .21623 L p F P
0 g
s
0 .312 .798 r
.35192 .31554 m .32758 .30251 L .33679 .3125 L p F P
0 g
s
0 .312 .798 r
.33679 .3125 m .36014 .32509 L .35192 .31554 L p F P
0 g
s
.394 .841 .929 r
.55659 .38609 m .58385 .38299 L .58972 .38007 L p F P
0 g
s
1 1 0 r
.007 w
.80071 .12559 m
.80291 .11995 L
s
.5 Mabswid
.758 .994 .813 r
.69559 .32605 m .71973 .31359 L .72888 .30363 L p F P
0 g
s
.703 .981 .8 r
.71973 .31359 m .69559 .32605 L .68703 .33483 L p F P
0 g
s
.914 .947 .599 r
.77135 .2313 m .78829 .21586 L .79325 .20203 L p F P
0 g
s
.885 .952 .603 r
.78829 .21586 m .77135 .2313 L .76589 .24469 L p F P
0 g
s
0 0 .569 r
.27604 .20199 m .2598 .18657 L .264 .20074 L p F P
0 g
s
0 0 .569 r
.264 .20074 m .28007 .21623 L .27604 .20199 L p F P
0 g
s
0 .472 0 r
.61781 .43502 m .62064 .43423 L .62244 .44681 L closepath p F P
0 g
s
0 .547 0 r
.61568 .43546 m .61781 .43502 L .62244 .44681 L closepath p F P
0 g
s
0 .291 0 r
.62064 .43423 m .62252 .43355 L .62244 .44681 L closepath p F P
0 g
s
.077 .497 .898 r
.40711 .35183 m .37789 .34198 L .38734 .3493 L p F P
0 g
s
.077 .497 .898 r
.38734 .3493 m .41482 .3586 L .40711 .35183 L p F P
0 g
s
0 .316 .805 r
.34417 .30529 m .31891 .29187 L .32758 .30251 L p F P
0 g
s
0 .316 .805 r
.32758 .30251 m .35192 .31554 L .34417 .30529 L p F P
0 g
s
0 .24 0 r
.61549 .43529 m .61568 .43546 L .62244 .44681 L closepath p F P
0 g
s
.293 .749 .954 r
.52772 .3846 m .49596 .3833 L .49916 .38591 L p F P
0 g
s
.293 .749 .954 r
.49916 .38591 m .52785 .38709 L .52772 .3846 L p F P
0 g
s
0 .673 0 r
.62252 .43355 m .62235 .43338 L .62244 .44681 L closepath p F P
0 g
s
1 1 0 r
.007 w
.25562 .12169 m
.25845 .12733 L
s
.5 Mabswid
.394 .841 .929 r
.58972 .38007 m .55955 .3835 L .55659 .38609 L p F P
0 g
s
.363 .806 .955 r
.52785 .38709 m .55659 .38609 L .55955 .3835 L p F P
0 g
s
.176 .612 .94 r
.4542 .37125 m .4228 .36456 L .43102 .36969 L p F P
0 g
s
.176 .612 .94 r
.43102 .36969 m .46003 .3759 L .4542 .37125 L p F P
0 g
s
.938 .938 .592 r
.77609 .21747 m .79325 .20203 L .79745 .18785 L p F P
0 g
s
.914 .947 .599 r
.79325 .20203 m .77609 .21747 L .77135 .2313 L p F P
0 g
s
.66 .969 .906 r
.64069 .35927 m .66874 .35013 L .67807 .34286 L p F P
0 g
s
.593 .949 .885 r
.66874 .35013 m .64069 .35927 L .63289 .36519 L p F P
0 g
s
0 0 .561 r
.27276 .1874 m .25639 .17211 L .2598 .18657 L p F P
0 g
s
0 0 .561 r
.2598 .18657 m .27604 .20199 L .27276 .1874 L p F P
0 g
s
0 .496 0 r
.44586 .43617 m .44872 .43686 L .44388 .44861 L closepath p F P
0 g
s
0 .663 0 r
.44368 .43546 m .44586 .43617 L .44388 .44861 L closepath p F P
0 g
s
0 .208 0 r
.44872 .43686 m .45058 .43712 L .44388 .44861 L closepath p F P
0 g
s
0 .473 0 r
.61737 .43462 m .61549 .43529 L .62244 .44681 L closepath p F P
0 g
s
.558 .922 .946 r
.59547 .37631 m .62485 .37028 L .63289 .36519 L p F P
0 g
s
.478 .893 .914 r
.62485 .37028 m .59547 .37631 L .58972 .38007 L p F P
0 g
s
.803 1 .818 r
.70371 .31654 m .72888 .30363 L .73749 .29302 L p F P
0 g
s
.758 .994 .813 r
.72888 .30363 m .70371 .31654 L .69559 .32605 L p F P
0 g
s
.363 .806 .955 r
.55955 .3835 m .52772 .3846 L .52785 .38709 L p F P
0 g
s
0 .708 0 r
.62235 .43338 m .62021 .43382 L .62244 .44681 L closepath p F P
0 g
s
0 .597 0 r
.62021 .43382 m .61737 .43462 L .62244 .44681 L closepath p F P
0 g
s
0 1 0 r
.007 w
.60344 .37824 m
.61894 .43418 L
s
.5 Mabswid
0 .678 0 r
.44345 .43515 m .44368 .43546 L .44388 .44861 L closepath p F P
0 g
s
.263 .697 .964 r
.49281 .37983 m .46003 .3759 L .466 .37969 L p F P
0 g
s
0 1 0 r
.007 w
.46104 .3803 m
.46122 .37957 L
s
.5 Mabswid
.263 .697 .964 r
.466 .37969 m .49596 .3833 L .49281 .37983 L p F P
0 g
s
0 .939 0 r
.45058 .43712 m .45035 .43681 L .44388 .44861 L closepath p F P
0 g
s
.481 .873 .966 r
.55955 .3835 m .58972 .38007 L .59547 .37631 L p F P
0 g
s
.958 .926 .583 r
.7801 .20322 m .79745 .18785 L .80085 .17338 L p F P
0 g
s
.938 .938 .592 r
.79745 .18785 m .7801 .20322 L .77609 .21747 L p F P
0 g
s
0 .337 0 r
.44531 .43541 m .44345 .43515 L .44388 .44861 L closepath p F P
0 g
s
.001 .318 .807 r
.33693 .29437 m .31082 .28061 L .31891 .29187 L p F P
0 g
s
.001 .318 .807 r
.31891 .29187 m .34417 .30529 L .33693 .29437 L p F P
0 g
s
0 0 .551 r
.27026 .1725 m .25378 .15739 L .25639 .17211 L p F P
0 g
s
0 0 .551 r
.25639 .17211 m .27276 .1874 L .27026 .1725 L p F P
0 g
s
0 .753 0 r
.45035 .43681 m .44817 .4361 L .44388 .44861 L closepath p F P
0 g
s
0 .574 0 r
.44817 .4361 m .44531 .43541 L .44388 .44861 L closepath p F P
0 g
s
0 1 0 r
.007 w
.44709 .43584 m
.46104 .3803 L
s
.5 Mabswid
.129 .504 .909 r
.3997 .34425 m .36881 .33391 L .37789 .34198 L p F P
0 g
s
.129 .504 .909 r
.37789 .34198 m .40711 .35183 L .3997 .34425 L p F P
0 g
s
.84 .999 .818 r
.71136 .30632 m .73749 .29302 L .74552 .28179 L p F P
0 g
s
.803 1 .818 r
.73749 .29302 m .71136 .30632 L .70371 .31654 L p F P
0 g
s
.713 .978 .915 r
.64824 .35254 m .67807 .34286 L .68703 .33483 L p F P
0 g
s
.66 .969 .906 r
.67807 .34286 m .64824 .35254 L .64069 .35927 L p F P
0 g
s
.973 .911 .572 r
.78335 .18862 m .80085 .17338 L .80345 .15865 L p F P
0 g
s
.958 .926 .583 r
.80085 .17338 m .78335 .18862 L .7801 .20322 L p F P
0 g
s
0 0 .539 r
.26854 .15733 m .252 .14247 L .25378 .15739 L p F P
0 g
s
0 0 .539 r
.25378 .15739 m .27026 .1725 L .26854 .15733 L p F P
0 g
s
.237 .625 .957 r
.44854 .36575 m .41482 .3586 L .4228 .36456 L p F P
0 g
s
.237 .625 .957 r
.4228 .36456 m .4542 .37125 L .44854 .36575 L p F P
0 g
s
0 0 .677 r
.24115 .12819 m .24394 .12927 L .2427 .12868 L closepath p F P
0 g
s
0 0 .803 r
.24394 .12927 m .24664 .12815 L .2427 .12868 L closepath p F P
0 g
s
0 0 .681 r
.24664 .12815 m .24768 .12548 L .2427 .12868 L closepath p F P
0 g
s
0 0 .498 r
.23991 .12553 m .24115 .12819 L .2427 .12868 L closepath p F P
0 g
s
.372 .773 .985 r
.52759 .38124 m .49281 .37983 L .49596 .3833 L p F P
0 g
s
.372 .773 .985 r
.49596 .3833 m .52772 .3846 L .52759 .38124 L p F P
0 g
s
.037 .317 .803 r
.33023 .28279 m .30334 .26877 L .31082 .28061 L p F P
0 g
s
.037 .317 .803 r
.31082 .28061 m .33693 .29437 L .33023 .28279 L p F P
0 g
s
0 0 .468 r
.24768 .12548 m .24645 .12283 L .2427 .12868 L closepath p F P
0 g
s
.622 .936 .961 r
.60108 .37169 m .63289 .36519 L .64069 .35927 L p F P
0 g
s
.558 .922 .946 r
.63289 .36519 m .60108 .37169 L .59547 .37631 L p F P
0 g
s
.481 .873 .966 r
.59547 .37631 m .56245 .38004 L .55955 .3835 L p F P
0 g
s
.443 .831 .986 r
.52772 .3846 m .55955 .3835 L .56245 .38004 L p F P
0 g
s
0 0 .337 r
.24095 .12287 m .23991 .12553 L .2427 .12868 L closepath p F P
0 g
s
0 0 .334 r
.24645 .12283 m .24366 .12174 L .2427 .12868 L closepath p F P
0 g
s
0 0 1 r
.007 w
.24493 .12224 m
.2482 .11279 L
s
.5 Mabswid
0 0 .283 r
.24366 .12174 m .24095 .12287 L .2427 .12868 L closepath p F P
0 g
s
.984 .894 .56 r
.78584 .1737 m .80345 .15865 L .80524 .14371 L p F P
0 g
s
.973 .911 .572 r
.80345 .15865 m .78584 .1737 L .78335 .18862 L p F P
0 g
s
0 0 .525 r
.26762 .14196 m .25104 .1274 L .252 .14247 L p F P
0 g
s
0 0 .525 r
.252 .14247 m .26854 .15733 L .26762 .14196 L p F P
0 g
s
.443 .831 .986 r
.56245 .38004 m .52759 .38124 L .52772 .3846 L p F P
0 g
s
.33 .712 .982 r
.48974 .37549 m .4542 .37125 L .46003 .3759 L p F P
0 g
s
.33 .712 .982 r
.46003 .3759 m .49281 .37983 L .48974 .37549 L p F P
0 g
s
.87 .993 .813 r
.71851 .29542 m .74552 .28179 L .75296 .26998 L p F P
0 g
s
.84 .999 .818 r
.74552 .28179 m .71851 .29542 L .71136 .30632 L p F P
0 g
s
.174 .507 .911 r
.39261 .33588 m .36014 .32509 L .36881 .33391 L p F P
0 g
s
.174 .507 .911 r
.36881 .33391 m .3997 .34425 L .39261 .33588 L p F P
0 g
s
.549 .889 .984 r
.56245 .38004 m .59547 .37631 L .60108 .37169 L p F P
0 g
s
.756 .978 .917 r
.65549 .345 m .68703 .33483 L .69559 .32605 L p F P
0 g
s
.713 .978 .915 r
.68703 .33483 m .65549 .345 L .64824 .35254 L p F P
0 g
s
0 0 .839 r
.80775 .12956 m .80891 .12702 L .81629 .12722 L closepath p F P
0 g
s
0 0 .625 r
.80872 .13237 m .80775 .12956 L .81629 .12722 L closepath p F P
0 g
s
0 0 .409 r
.81125 .13381 m .80872 .13237 L .81629 .12722 L closepath p F P
0 g
s
0 0 .114 r
.81386 .13302 m .81125 .13381 L .81629 .12722 L closepath p F P
0 g
s
0 0 0 r
.81503 .13048 m .81386 .13302 L .81629 .12722 L closepath p F P
0 g
s
0 0 .839 r
.80775 .12956 m .80891 .12702 L .81629 .12722 L closepath p F P
0 g
s
0 0 .625 r
.80872 .13237 m .80775 .12956 L .81629 .12722 L closepath p F P
0 g
s
0 0 .409 r
.81125 .13381 m .80872 .13237 L .81629 .12722 L closepath p F P
0 g
s
0 0 .114 r
.81386 .13302 m .81125 .13381 L .81629 .12722 L closepath p F P
0 g
s
0 0 0 r
.81503 .13048 m .81386 .13302 L .81629 .12722 L closepath p F P
0 g
s
0 0 .156 r
.81406 .12766 m .81503 .13048 L .81629 .12722 L closepath p F P
0 g
s
0 0 .939 r
.80891 .12702 m .81153 .12623 L .81629 .12722 L closepath p F P
0 g
s
0 0 .939 r
.80891 .12702 m .81153 .12623 L .81629 .12722 L closepath p F P
0 g
s
0 0 0 r
.81153 .12623 m .81406 .12766 L .81629 .12722 L closepath p F P
0 g
s
0 0 .156 r
.81406 .12766 m .81503 .13048 L .81629 .12722 L closepath p F P
0 g
s
0 0 0 r
.81153 .12623 m .81406 .12766 L .81629 .12722 L closepath p F P
0 g
s
0 .47 0 r
.53244 .44434 m .53541 .44428 L .53394 .45666 L closepath p F P
0 g
s
0 .6 0 r
.53024 .44408 m .53244 .44434 L .53394 .45666 L closepath p F P
0 g
s
1 1 0 r
.007 w
.25845 .12733 m
.26336 .13294 L
s
.5 Mabswid
.07 .314 .796 r
.32409 .27059 m .2965 .25638 L .30334 .26877 L p F P
0 g
s
.07 .314 .796 r
.30334 .26877 m .33023 .28279 L .32409 .27059 L p F P
0 g
s
0 .231 0 r
.53541 .44428 m .53742 .44393 L .53394 .45666 L closepath p F P
0 g
s
.992 .875 .546 r
.78755 .15852 m .80524 .14371 L .80619 .12861 L p F P
0 g
s
.984 .894 .56 r
.80524 .14371 m .78755 .15852 L .78584 .1737 L p F P
0 g
s
0 .397 0 r
.5301 .44364 m .53024 .44408 L .53394 .45666 L closepath p F P
0 g
s
0 .82 0 r
.53742 .44393 m .53728 .4435 L .53394 .45666 L closepath p F P
0 g
s
.288 .629 .962 r
.44305 .3594 m .40711 .35183 L .41482 .3586 L p F P
0 g
s
.288 .629 .962 r
.41482 .3586 m .44854 .36575 L .44305 .3594 L p F P
0 g
s
.893 .983 .806 r
.72513 .28386 m .75296 .26998 L .75976 .2576 L p F P
0 g
s
0 1 0 r
.007 w
.74807 .27792 m
.74844 .2782 L
s
.5 Mabswid
.87 .993 .813 r
.75296 .26998 m .72513 .28386 L .71851 .29542 L p F P
0 g
s
0 .404 0 r
.53211 .44329 m .5301 .44364 L .53394 .45666 L closepath p F P
0 g
s
.992 .875 .546 r
.80619 .12861 m .78847 .14312 L .78755 .15852 L p F P
0 g
s
1 1 0 r
.007 w
.79644 .13122 m
.80071 .12559 L
s
0 0 1 r
.80484 .13376 m
.80586 .13318 L
s
.80586 .13318 m
.8143 .12836 L
s
.5 Mabswid
0 .732 0 r
.53728 .4435 m .53509 .44323 L .53394 .45666 L closepath p F P
0 g
s
.671 .939 .965 r
.60654 .36622 m .64069 .35927 L .64824 .35254 L p F P
0 g
s
.622 .936 .961 r
.64069 .35927 m .60654 .36622 L .60108 .37169 L p F P
0 g
s
0 .58 0 r
.53509 .44323 m .53211 .44329 L .53394 .45666 L closepath p F P
0 g
s
0 1 0 r
.007 w
.53294 .38551 m
.53375 .44326 L
s
.5 Mabswid
.212 .506 .908 r
.38588 .32674 m .35192 .31554 L .36014 .32509 L p F P
0 g
s
.212 .506 .908 r
.36014 .32509 m .39261 .33588 L .38588 .32674 L p F P
0 g
s
.435 .783 .997 r
.52747 .37701 m .48974 .37549 L .49281 .37983 L p F P
0 g
s
.435 .783 .997 r
.49281 .37983 m .52759 .38124 L .52747 .37701 L p F P
0 g
s
.099 .311 .787 r
.31854 .25781 m .29033 .24346 L .2965 .25638 L p F P
0 g
s
.099 .311 .787 r
.2965 .25638 m .32409 .27059 L .31854 .25781 L p F P
0 g
s
.549 .889 .984 r
.60108 .37169 m .56529 .37572 L .56245 .38004 L p F P
0 g
s
.506 .841 .998 r
.52759 .38124 m .56245 .38004 L .56529 .37572 L p F P
0 g
s
0 .44 0 r
.79423 .3149 m .79603 .31252 L .8048 .3215 L closepath p F P
0 g
s
0 .37 0 r
.7926 .31652 m .79423 .3149 L .8048 .3215 L closepath p F P
0 g
s
0 .44 0 r
.79423 .3149 m .79603 .31252 L .8048 .3215 L closepath p F P
0 g
s
0 .37 0 r
.7926 .31652 m .79423 .3149 L .8048 .3215 L closepath p F P
0 g
s
.789 .973 .913 r
.66243 .33667 m .69559 .32605 L .70371 .31654 L p F P
0 g
s
.756 .978 .917 r
.69559 .32605 m .66243 .33667 L .65549 .345 L p F P
0 g
s
0 .402 0 r
.79603 .31252 m .79695 .31078 L .8048 .3215 L closepath p F P
0 g
s
0 .402 0 r
.79603 .31252 m .79695 .31078 L .8048 .3215 L closepath p F P
0 g
s
.384 .716 .988 r
.48674 .37029 m .44854 .36575 L .4542 .37125 L p F P
0 g
s
.384 .716 .988 r
.4542 .37125 m .48974 .37549 L .48674 .37029 L p F P
0 g
s
.506 .841 .998 r
.56529 .37572 m .52747 .37701 L .52759 .38124 L p F P
0 g
s
.602 .893 .989 r
.56529 .37572 m .60108 .37169 L .60654 .36622 L p F P
0 g
s
0 0 0 r
.7921 .31645 m .7926 .31652 L .8048 .3215 L closepath p F P
0 g
s
0 0 0 r
.7921 .31645 m .7926 .31652 L .8048 .3215 L closepath p F P
0 g
s
.911 .971 .795 r
.7312 .27168 m .75976 .2576 L .76589 .24469 L p F P
0 g
s
.893 .983 .806 r
.75976 .2576 m .7312 .27168 L .72513 .28386 L p F P
0 g
s
0 .293 0 r
.79695 .31078 m .79646 .3107 L .8048 .3215 L closepath p F P
0 g
s
0 .293 0 r
.79695 .31078 m .79646 .3107 L .8048 .3215 L closepath p F P
0 g
s
0 .617 0 r
.79302 .31471 m .7921 .31645 L .8048 .3215 L closepath p F P
0 g
s
0 .617 0 r
.79302 .31471 m .7921 .31645 L .8048 .3215 L closepath p F P
0 g
s
.126 .306 .775 r
.3136 .24449 m .28484 .23007 L .29033 .24346 L p F P
0 g
s
.126 .306 .775 r
.29033 .24346 m .31854 .25781 L .3136 .24449 L p F P
0 g
s
0 .563 0 r
.79646 .3107 m .79483 .31233 L .8048 .3215 L closepath p F P
0 g
s
0 .563 0 r
.79646 .3107 m .79483 .31233 L .8048 .3215 L closepath p F P
0 g
s
1 1 0 r
.007 w
.79008 .13678 m
.79644 .13122 L
s
.5 Mabswid
.33 .628 .96 r
.43778 .35222 m .3997 .34425 L .40711 .35183 L p F P
0 g
s
.33 .628 .96 r
.40711 .35183 m .44305 .3594 L .43778 .35222 L p F P
0 g
s
0 .588 0 r
.79483 .31233 m .79302 .31471 L .8048 .3215 L closepath p F P
0 g
s
0 1 0 r
.007 w
.74844 .2782 m
.7941 .31328 L
s
.5 Mabswid
0 .588 0 r
.79483 .31233 m .79302 .31471 L .8048 .3215 L closepath p F P
0 g
s
.246 .502 .901 r
.37953 .31684 m .34417 .30529 L .35192 .31554 L p F P
0 g
s
.246 .502 .901 r
.35192 .31554 m .38588 .32674 L .37953 .31684 L p F P
0 g
s
.709 .935 .962 r
.61182 .35991 m .64824 .35254 L .65549 .345 L p F P
0 g
s
.671 .939 .965 r
.64824 .35254 m .61182 .35991 L .60654 .36622 L p F P
0 g
s
.926 .956 .783 r
.73668 .25892 m .76589 .24469 L .77135 .2313 L p F P
0 g
s
.911 .971 .795 r
.76589 .24469 m .73668 .25892 L .7312 .27168 L p F P
0 g
s
.815 .964 .904 r
.66902 .32755 m .70371 .31654 L .71136 .30632 L p F P
0 g
s
.789 .973 .913 r
.70371 .31654 m .66902 .32755 L .66243 .33667 L p F P
0 g
s
.15 .3 .762 r
.30931 .23066 m .28007 .21623 L .28484 .23007 L p F P
0 g
s
.15 .3 .762 r
.28484 .23007 m .3136 .24449 L .30931 .23066 L p F P
0 g
s
1 1 0 r
.007 w
.26336 .13294 m
.27036 .13848 L
s
.5 Mabswid
.484 .784 .998 r
.52735 .37192 m .48674 .37029 L .48974 .37549 L p F P
0 g
s
.484 .784 .998 r
.48974 .37549 m .52747 .37701 L .52735 .37192 L p F P
0 g
s
.602 .893 .989 r
.60654 .36622 m .56805 .37053 L .56529 .37572 L p F P
0 g
s
.555 .841 .998 r
.52747 .37701 m .56529 .37572 L .56805 .37053 L p F P
0 g
s
0 .482 0 r
.26973 .31863 m .27165 .32065 L .26025 .32628 L closepath p F P
0 g
s
0 .7 0 r
.26814 .31634 m .26973 .31863 L .26025 .32628 L closepath p F P
0 g
s
.427 .714 .984 r
.48385 .36422 m .44305 .3594 L .44854 .36575 L p F P
0 g
s
.427 .714 .984 r
.44854 .36575 m .48674 .37029 L .48385 .36422 L p F P
0 g
s
0 0 0 r
.27165 .32065 m .2728 .32122 L .26025 .32628 L closepath p F P
0 g
s
0 .963 0 r
.26783 .31512 m .26814 .31634 L .26025 .32628 L closepath p F P
0 g
s
.642 .888 .985 r
.56805 .37053 m .60654 .36622 L .61182 .35991 L p F P
0 g
s
.937 .94 .77 r
.74155 .2456 m .77135 .2313 L .77609 .21747 L p F P
0 g
s
.926 .956 .783 r
.77135 .2313 m .74155 .2456 L .73668 .25892 L p F P
0 g
s
.274 .497 .89 r
.37359 .30621 m .33693 .29437 L .34417 .30529 L p F P
0 g
s
.274 .497 .89 r
.34417 .30529 m .37953 .31684 L .37359 .30621 L p F P
0 g
s
.555 .841 .998 r
.56805 .37053 m .52735 .37192 L .52747 .37701 L p F P
0 g
s
0 .925 0 r
.2728 .32122 m .27249 .32 L .26025 .32628 L closepath p F P
0 g
s
.364 .623 .952 r
.43273 .34421 m .39261 .33588 L .3997 .34425 L p F P
0 g
s
.364 .623 .952 r
.3997 .34425 m .43778 .35222 L .43273 .34421 L p F P
0 g
s
0 .031 0 r
.26898 .31568 m .26783 .31512 L .26025 .32628 L closepath p F P
0 g
s
.172 .294 .748 r
.30568 .21637 m .27604 .20199 L .28007 .21623 L p F P
0 g
s
.172 .294 .748 r
.28007 .21623 m .30931 .23066 L .30568 .21637 L p F P
0 g
s
.835 .951 .893 r
.67523 .31768 m .71136 .30632 L .71851 .29542 L p F P
0 g
s
.815 .964 .904 r
.71136 .30632 m .67523 .31768 L .66902 .32755 L p F P
0 g
s
.738 .926 .953 r
.6169 .35275 m .65549 .345 L .66243 .33667 L p F P
0 g
s
.709 .935 .962 r
.65549 .345 m .6169 .35275 L .61182 .35991 L p F P
0 g
s
0 .686 0 r
.27249 .32 m .27091 .31771 L .26025 .32628 L closepath p F P
0 g
s
0 .488 0 r
.27091 .31771 m .26898 .31568 L .26025 .32628 L closepath p F P
0 g
s
0 1 0 r
.007 w
.2709 .3177 m
.3158 .28151 L
s
.5 Mabswid
.945 .924 .756 r
.74579 .23177 m .77609 .21747 L .7801 .20322 L p F P
0 g
s
.937 .94 .77 r
.77609 .21747 m .74579 .23177 L .74155 .2456 L p F P
0 g
s
.191 .287 .733 r
.30273 .20166 m .27276 .1874 L .27604 .20199 L p F P
0 g
s
.191 .287 .733 r
.27604 .20199 m .30568 .21637 L .30273 .20166 L p F P
0 g
s
.299 .49 .878 r
.36808 .29487 m .33023 .28279 L .33693 .29437 L p F P
0 g
s
.299 .49 .878 r
.33693 .29437 m .37359 .30621 L .36808 .29487 L p F P
0 g
s
.522 .778 .99 r
.52723 .36595 m .48385 .36422 L .48674 .37029 L p F P
0 g
s
.522 .778 .99 r
.48674 .37029 m .52735 .37192 L .52723 .36595 L p F P
0 g
s
1 1 0 r
.007 w
.78163 .14224 m
.79008 .13678 L
s
.5 Mabswid
.461 .708 .975 r
.48106 .35729 m .43778 .35222 L .44305 .3594 L p F P
0 g
s
.461 .708 .975 r
.44305 .3594 m .48385 .36422 L .48106 .35729 L p F P
0 g
s
.642 .888 .985 r
.61182 .35991 m .57072 .36448 L .56805 .37053 L p F P
0 g
s
.592 .834 .991 r
.52735 .37192 m .56805 .37053 L .57072 .36448 L p F P
0 g
s
.673 .879 .975 r
.57072 .36448 m .61182 .35991 L .6169 .35275 L p F P
0 g
s
.851 .938 .881 r
.68105 .30707 m .71851 .29542 L .72513 .28386 L p F P
0 g
s
.835 .951 .893 r
.71851 .29542 m .68105 .30707 L .67523 .31768 L p F P
0 g
s
.951 .906 .741 r
.74938 .21748 m .7801 .20322 L .78335 .18862 L p F P
0 g
s
.945 .924 .756 r
.7801 .20322 m .74938 .21748 L .74579 .23177 L p F P
0 g
s
0 0 0 r
.7902 .201 m .7902 .20183 L .78611 .21397 L closepath p F P
0 g
s
.457 0 0 r
.78806 .20036 m .7902 .201 L .78611 .21397 L closepath p F P
0 g
s
.685 0 0 r
.78502 .20028 m .78806 .20036 L .78611 .21397 L closepath p F P
0 g
s
.864 0 0 r
.78286 .2008 m .78502 .20028 L .78611 .21397 L closepath p F P
0 g
s
.826 0 0 r
.78285 .20162 m .78286 .2008 L .78611 .21397 L closepath p F P
0 g
s
.864 0 0 r
.78286 .2008 m .78502 .20028 L .78611 .21397 L closepath p F P
0 g
s
.826 0 0 r
.78285 .20162 m .78286 .2008 L .78611 .21397 L closepath p F P
0 g
s
.384 0 0 r
.78499 .20227 m .78285 .20162 L .78611 .21397 L closepath p F P
0 g
s
.457 0 0 r
.78806 .20036 m .7902 .201 L .78611 .21397 L closepath p F P
0 g
s
.685 0 0 r
.78502 .20028 m .78806 .20036 L .78611 .21397 L closepath p F P
0 g
s
.667 0 0 r
.78804 .20235 m .78499 .20227 L .78611 .21397 L closepath p F P
0 g
s
0 0 0 r
.7902 .201 m .7902 .20183 L .78611 .21397 L closepath p F P
0 g
s
.867 0 0 r
.7902 .20183 m .78804 .20235 L .78611 .21397 L closepath p F P
0 g
s
1 0 0 r
.007 w
.78758 .16966 m
.78785 .16169 L
s
.5 Mabswid
.384 0 0 r
.78499 .20227 m .78285 .20162 L .78611 .21397 L closepath p F P
0 g
s
.667 0 0 r
.78804 .20235 m .78499 .20227 L .78611 .21397 L closepath p F P
0 g
s
.867 0 0 r
.7902 .20183 m .78804 .20235 L .78611 .21397 L closepath p F P
0 g
s
.393 .616 .94 r
.42792 .33538 m .38588 .32674 L .39261 .33588 L p F P
0 g
s
.393 .616 .94 r
.39261 .33588 m .43273 .34421 L .42792 .33538 L p F P
0 g
s
.209 .28 .718 r
.30047 .18659 m .27026 .1725 L .27276 .1874 L p F P
0 g
s
.209 .28 .718 r
.27276 .1874 m .30273 .20166 L .30047 .18659 L p F P
0 g
s
.761 .914 .941 r
.62177 .34476 m .66243 .33667 L .66902 .32755 L p F P
0 g
s
.738 .926 .953 r
.66243 .33667 m .62177 .34476 L .6169 .35275 L p F P
0 g
s
.592 .834 .991 r
.57072 .36448 m .52723 .36595 L .52735 .37192 L p F P
0 g
s
.321 .483 .864 r
.36303 .28286 m .32409 .27059 L .33023 .28279 L p F P
0 g
s
.321 .483 .864 r
.33023 .28279 m .36808 .29487 L .36303 .28286 L p F P
0 g
s
.955 .888 .725 r
.7523 .20276 m .78335 .18862 L .78584 .1737 L p F P
0 g
s
.951 .906 .741 r
.78335 .18862 m .7523 .20276 L .74938 .21748 L p F P
0 g
s
.225 .273 .702 r
.29892 .1712 m .26854 .15733 L .27026 .1725 L p F P
0 g
s
.225 .273 .702 r
.27026 .1725 m .30047 .18659 L .29892 .1712 L p F P
0 g
s
.863 .923 .867 r
.68645 .29575 m .72513 .28386 L .7312 .27168 L p F P
0 g
s
.851 .938 .881 r
.72513 .28386 m .68645 .29575 L .68105 .30707 L p F P
0 g
s
.417 .608 .927 r
.42339 .32576 m .37953 .31684 L .38588 .32674 L p F P
0 g
s
.417 .608 .927 r
.38588 .32674 m .42792 .33538 L .42339 .32576 L p F P
0 g
s
.488 .699 .962 r
.47839 .34951 m .43273 .34421 L .43778 .35222 L p F P
0 g
s
.488 .699 .962 r
.43778 .35222 m .48106 .35729 L .47839 .34951 L p F P
0 g
s
.957 .87 .709 r
.75453 .18767 m .78584 .1737 L .78755 .15852 L p F P
0 g
s
1 0 0 r
.007 w
.78649 .20231 m
.78758 .16966 L
s
.5 Mabswid
.955 .888 .725 r
.78584 .1737 m .75453 .18767 L .7523 .20276 L p F P
0 g
s
.552 .769 .979 r
.52712 .35911 m .48106 .35729 L .48385 .36422 L p F P
0 g
s
.552 .769 .979 r
.48385 .36422 m .52723 .36595 L .52712 .35911 L p F P
0 g
s
.673 .879 .975 r
.6169 .35275 m .5733 .35756 L .57072 .36448 L p F P
0 g
s
.62 .825 .979 r
.52723 .36595 m .57072 .36448 L .5733 .35756 L p F P
0 g
s
.24 .265 .686 r
.29809 .15555 m .26762 .14196 L .26854 .15733 L p F P
0 g
s
1 1 0 r
.007 w
.27036 .13848 m
.27945 .14389 L
s
.5 Mabswid
.24 .265 .686 r
.26854 .15733 m .29892 .1712 L .29809 .15555 L p F P
0 g
s
.697 .868 .963 r
.5733 .35756 m .6169 .35275 L .62177 .34476 L p F P
0 g
s
.387 0 0 r
.28039 .20416 m .28207 .20481 L .27857 .21784 L closepath p F P
0 g
s
.884 0 0 r
.28207 .20481 m .28146 .20564 L .27857 .21784 L closepath p F P
0 g
s
.684 0 0 r
.2774 .20407 m .28039 .20416 L .27857 .21784 L closepath p F P
0 g
s
.845 0 0 r
.27485 .2046 m .2774 .20407 L .27857 .21784 L closepath p F P
0 g
s
.983 0 0 r
.27423 .20543 m .27485 .2046 L .27857 .21784 L closepath p F P
0 g
s
.268 0 0 r
.27591 .20608 m .27423 .20543 L .27857 .21784 L closepath p F P
0 g
s
.666 0 0 r
.27891 .20617 m .27591 .20608 L .27857 .21784 L closepath p F P
0 g
s
.85 0 0 r
.28146 .20564 m .27891 .20617 L .27857 .21784 L closepath p F P
0 g
s
1 0 0 r
.007 w
.27718 .17524 m
.27819 .20615 L
s
.2765 .15428 m
.27718 .17524 L
s
.27625 .14664 m
.2765 .15428 L
s
.5 Mabswid
.778 .901 .928 r
.6264 .33596 m .66902 .32755 L .67523 .31768 L p F P
0 g
s
.761 .914 .941 r
.66902 .32755 m .6264 .33596 L .62177 .34476 L p F P
0 g
s
.339 .475 .85 r
.35846 .27021 m .31854 .25781 L .32409 .27059 L p F P
0 g
s
.339 .475 .85 r
.32409 .27059 m .36303 .28286 L .35846 .27021 L p F P
0 g
s
.62 .825 .979 r
.5733 .35756 m .52712 .35911 L .52723 .36595 L p F P
0 g
s
.958 .851 .693 r
.75606 .17227 m .78755 .15852 L .78847 .14312 L p F P
0 g
s
1 0 0 r
.007 w
.78785 .16169 m
.78812 .15344 L
s
.5 Mabswid
.957 .87 .709 r
.78755 .15852 m .75606 .17227 L .75453 .18767 L p F P
0 g
s
.872 .907 .852 r
.69139 .28375 m .7312 .27168 L .73668 .25892 L p F P
0 g
s
.863 .923 .867 r
.7312 .27168 m .69139 .28375 L .68645 .29575 L p F P
0 g
s
.437 .599 .913 r
.41914 .31537 m .37359 .30621 L .37953 .31684 L p F P
0 g
s
.437 .599 .913 r
.37953 .31684 m .42339 .32576 L .41914 .31537 L p F P
0 g
s
.958 .851 .693 r
.78847 .14312 m .75688 .15659 L .75606 .17227 L p F P
0 g
s
1 1 0 r
.007 w
.77111 .14754 m
.78163 .14224 L
s
0 0 1 r
.78847 .14312 m
.80484 .13376 L
s
1 0 0 r
.78812 .15344 m
.78847 .14312 L
s
.5 Mabswid
.356 .466 .835 r
.35439 .25696 m .3136 .24449 L .31854 .25781 L p F P
0 g
s
.356 .466 .835 r
.31854 .25781 m .35846 .27021 L .35439 .25696 L p F P
0 g
s
.51 .689 .948 r
.47584 .34089 m .42792 .33538 L .43273 .34421 L p F P
0 g
s
.51 .689 .948 r
.43273 .34421 m .47839 .34951 L .47584 .34089 L p F P
0 g
s
.792 .887 .914 r
.63077 .32636 m .67523 .31768 L .68105 .30707 L p F P
0 g
s
.778 .901 .928 r
.67523 .31768 m .63077 .32636 L .6264 .33596 L p F P
0 g
s
1 1 0 r
.007 w
.27945 .14389 m
.29061 .14913 L
s
.5 Mabswid
.715 .855 .949 r
.57576 .3498 m .62177 .34476 L .6264 .33596 L p F P
0 g
s
.697 .868 .963 r
.62177 .34476 m .57576 .3498 L .5733 .35756 L p F P
0 g
s
.575 .758 .965 r
.52702 .35142 m .47839 .34951 L .48106 .35729 L p F P
0 g
s
.575 .758 .965 r
.48106 .35729 m .52712 .35911 L .52702 .35142 L p F P
0 g
s
.879 .892 .837 r
.69586 .27111 m .73668 .25892 L .74155 .2456 L p F P
0 g
s
.872 .907 .852 r
.73668 .25892 m .69586 .27111 L .69139 .28375 L p F P
0 g
s
.642 .813 .965 r
.52712 .35911 m .5733 .35756 L .57576 .3498 L p F P
0 g
s
.37 .458 .82 r
.35085 .24314 m .30931 .23066 L .3136 .24449 L p F P
0 g
s
.37 .458 .82 r
.3136 .24449 m .35439 .25696 L .35085 .24314 L p F P
0 g
s
.642 .813 .965 r
.57576 .3498 m .52702 .35142 L .52712 .35911 L p F P
0 g
s
.454 .589 .898 r
.4152 .30423 m .36808 .29487 L .37359 .30621 L p F P
0 g
s
.454 .589 .898 r
.37359 .30621 m .41914 .31537 L .4152 .30423 L p F P
0 g
s
.884 .876 .822 r
.69984 .25787 m .74155 .2456 L .74579 .23177 L p F P
0 g
s
.879 .892 .837 r
.74155 .2456 m .69984 .25787 L .69586 .27111 L p F P
0 g
s
.802 .872 .899 r
.63486 .31598 m .68105 .30707 L .68645 .29575 L p F P
0 g
s
.792 .887 .914 r
.68105 .30707 m .63486 .31598 L .63077 .32636 L p F P
0 g
s
.528 .678 .933 r
.47344 .33145 m .42339 .32576 L .42792 .33538 L p F P
0 g
s
.528 .678 .933 r
.42792 .33538 m .47584 .34089 L .47344 .33145 L p F P
0 g
s
.383 .449 .805 r
.34786 .22881 m .30568 .21637 L .30931 .23066 L p F P
0 g
s
.383 .449 .805 r
.30931 .23066 m .35085 .24314 L .34786 .22881 L p F P
0 g
s
.729 .841 .933 r
.57811 .34119 m .6264 .33596 L .63077 .32636 L p F P
0 g
s
.715 .855 .949 r
.6264 .33596 m .57811 .34119 L .57576 .3498 L p F P
0 g
s
1 1 0 r
.007 w
.75854 .15263 m
.77111 .14754 L
s
.5 Mabswid
.594 .747 .95 r
.52691 .34287 m .47584 .34089 L .47839 .34951 L p F P
0 g
s
.594 .747 .95 r
.47839 .34951 m .52702 .35142 L .52691 .34287 L p F P
0 g
s
.66 .8 .95 r
.52702 .35142 m .57576 .3498 L .57811 .34119 L p F P
0 g
s
.888 .86 .807 r
.70331 .24405 m .74579 .23177 L .74938 .21748 L p F P
0 g
s
.884 .876 .822 r
.74579 .23177 m .70331 .24405 L .69984 .25787 L p F P
0 g
s
.468 .579 .883 r
.41158 .29237 m .36303 .28286 L .36808 .29487 L p F P
0 g
s
.468 .579 .883 r
.36808 .29487 m .4152 .30423 L .41158 .29237 L p F P
0 g
s
.66 .8 .95 r
.57811 .34119 m .52691 .34287 L .52702 .35142 L p F P
0 g
s
1 1 0 r
.007 w
.29061 .14913 m
.3038 .15415 L
s
.5 Mabswid
.394 .44 .79 r
.34542 .21401 m .30273 .20166 L .30568 .21637 L p F P
0 g
s
.394 .44 .79 r
.30568 .21637 m .34786 .22881 L .34542 .21401 L p F P
0 g
s
.811 .857 .884 r
.63866 .30485 m .68645 .29575 L .69139 .28375 L p F P
0 g
s
.802 .872 .899 r
.68645 .29575 m .63866 .30485 L .63486 .31598 L p F P
0 g
s
0 .423 0 r
.85785 .15208 m .84641 .15168 L .84651 .15061 L p F P
0 g
s
0 .379 0 r
.85785 .15208 m .84615 .15256 L .84651 .15061 L p F P
0 g
s
0 .379 0 r
.84651 .15061 m .8467 .14955 L .85785 .15208 L p F P
0 g
s
0 .423 0 r
.84651 .15061 m .84669 .14863 L .85785 .15208 L p F P
0 g
s
0 .225 0 r
.85785 .15208 m .84543 .15401 L .84577 .15319 L p F P
0 g
s
0 .09 0 r
.85785 .15208 m .84506 .15434 L .84524 .15405 L p F P
0 g
s
0 0 0 r
.84471 .15417 m .84524 .15405 L p .85785 .15208 L F P
0 g
s
0 0 0 r
.84524 .15405 m .84543 .15401 L .85785 .15208 L p F P
0 g
s
0 .09 0 r
.84524 .15405 m .84577 .15319 L p .85785 .15208 L F P
0 g
s
0 .09 0 r
.84577 .15319 m .84615 .15256 L .85785 .15208 L p F P
0 g
s
0 .225 0 r
.84577 .15319 m .84641 .15168 L .85785 .15208 L p F P
0 g
s
0 .523 0 r
.85785 .15208 m .84669 .14863 L .84649 .14793 L p F P
0 g
s
0 .499 0 r
.85785 .15208 m .8467 .14955 L .84649 .14793 L p F P
0 g
s
0 .499 0 r
.84649 .14793 m .84638 .14705 L .85785 .15208 L p F P
0 g
s
0 .322 0 r
.85785 .15208 m .84638 .14705 L .84621 .14697 L p F P
0 g
s
0 .523 0 r
.84621 .14697 m .84612 .14664 L .85785 .15208 L p F P
0 g
s
0 .014 0 r
.85785 .15208 m .84612 .14664 L .84573 .14672 L p F P
0 g
s
0 .322 0 r
.84621 .14697 m .84573 .14672 L p .85785 .15208 L F P
0 g
s
0 .523 0 r
.84649 .14793 m .84621 .14697 L p .85785 .15208 L F P
0 g
s
0 .014 0 r
.84573 .14672 m .8452 .14684 L p .85785 .15208 L F P
0 g
s
0 .322 0 r
.84573 .14672 m .84538 .14654 L .85785 .15208 L p F P
0 g
s
0 .37 0 r
.85785 .15208 m .84538 .14654 L .8452 .14684 L p F P
0 g
s
0 .37 0 r
.8452 .14684 m .84467 .14769 L p .85785 .15208 L F P
0 g
s
0 .433 0 r
.85785 .15208 m .84502 .14688 L .84467 .14769 L p F P
0 g
s
0 .433 0 r
.84467 .14769 m .8442 .14882 L p .85785 .15208 L F P
0 g
s
0 .527 0 r
.85785 .15208 m .84429 .14832 L .8442 .14882 L p F P
0 g
s
0 .527 0 r
.8442 .14882 m .84393 .15028 L p .85785 .15208 L F P
0 g
s
0 .433 0 r
.8442 .14882 m .84403 .14921 L .85785 .15208 L p F P
0 g
s
0 .37 0 r
.84467 .14769 m .84429 .14832 L .85785 .15208 L p F P
0 g
s
0 .014 0 r
.8452 .14684 m .84502 .14688 L .85785 .15208 L p F P
0 g
s
0 .564 0 r
.84393 .15028 m .84379 .15176 L p .85785 .15208 L F P
0 g
s
0 .527 0 r
.84393 .15028 m .84374 .15135 L .85785 .15208 L p F P
0 g
s
0 .564 0 r
.85785 .15208 m .84403 .14921 L .84393 .15028 L p F P
0 g
s
0 .656 0 r
.84379 .15176 m .84395 .15297 L p .85785 .15208 L F P
0 g
s
0 .564 0 r
.84379 .15176 m .84375 .15227 L .85785 .15208 L p F P
0 g
s
0 .656 0 r
.85785 .15208 m .84374 .15135 L .84379 .15176 L p F P
0 g
s
0 .711 0 r
.84395 .15297 m .84423 .15393 L p .85785 .15208 L F P
0 g
s
0 .656 0 r
.84395 .15297 m .84406 .15384 L .85785 .15208 L p F P
0 g
s
0 .711 0 r
.85785 .15208 m .84375 .15227 L .84395 .15297 L p F P
0 g
s
0 .825 0 r
.84423 .15393 m .84471 .15417 L p .85785 .15208 L F P
0 g
s
0 .825 0 r
.84471 .15417 m .84506 .15434 L .85785 .15208 L p F P
0 g
s
0 0 0 r
.85785 .15208 m .84432 .15426 L .84471 .15417 L p F P
0 g
s
0 .711 0 r
.84423 .15393 m .84432 .15426 L .85785 .15208 L p F P
0 g
s
0 .825 0 r
.85785 .15208 m .84406 .15384 L .84423 .15393 L p F P
0 g
s
0 1 0 r
.007 w
.78847 .14312 m
.84393 .15028 L
s
.5 Mabswid
.543 .667 .918 r
.47119 .32121 m .41914 .31537 L .42339 .32576 L p F P
0 g
s
.543 .667 .918 r
.42339 .32576 m .47344 .33145 L .47119 .32121 L p F P
0 g
s
.891 .844 .792 r
.70624 .22972 m .74938 .21748 L .7523 .20276 L p F P
0 g
s
.888 .86 .807 r
.74938 .21748 m .70624 .22972 L .70331 .24405 L p F P
0 g
s
.74 .827 .918 r
.58033 .33176 m .63077 .32636 L .63486 .31598 L p F P
0 g
s
.729 .841 .933 r
.63077 .32636 m .58033 .33176 L .57811 .34119 L p F P
0 g
s
.405 .431 .774 r
.34355 .1988 m .30047 .18659 L .30273 .20166 L p F P
0 g
s
.405 .431 .774 r
.30273 .20166 m .34542 .21401 L .34355 .1988 L p F P
0 g
s
.609 .735 .934 r
.52682 .3335 m .47344 .33145 L .47584 .34089 L p F P
0 g
s
.609 .735 .934 r
.47584 .34089 m .52691 .34287 L .52682 .3335 L p F P
0 g
s
.481 .57 .868 r
.40831 .27982 m .35846 .27021 L .36303 .28286 L p F P
0 g
s
.481 .57 .868 r
.36303 .28286 m .41158 .29237 L .40831 .27982 L p F P
0 g
s
.673 .787 .934 r
.52691 .34287 m .57811 .34119 L .58033 .33176 L p F P
0 g
s
.817 .843 .869 r
.64215 .293 m .69139 .28375 L .69586 .27111 L p F P
0 g
s
.811 .857 .884 r
.69139 .28375 m .64215 .293 L .63866 .30485 L p F P
0 g
s
.893 .829 .777 r
.70863 .21492 m .7523 .20276 L .75453 .18767 L p F P
0 g
s
.891 .844 .792 r
.7523 .20276 m .70863 .21492 L .70624 .22972 L p F P
0 g
s
.414 .422 .759 r
.34227 .18322 m .29892 .1712 L .30047 .18659 L p F P
0 g
s
.414 .422 .759 r
.30047 .18659 m .34355 .1988 L .34227 .18322 L p F P
0 g
s
.673 .787 .934 r
.58033 .33176 m .52682 .3335 L .52691 .34287 L p F P
0 g
s
.556 .656 .903 r
.4691 .3102 m .4152 .30423 L .41914 .31537 L p F P
0 g
s
.556 .656 .903 r
.41914 .31537 m .47119 .32121 L .4691 .3102 L p F P
0 g
s
.893 .813 .762 r
.71046 .19969 m .75453 .18767 L .75606 .17227 L p F P
0 g
s
.893 .829 .777 r
.75453 .18767 m .71046 .19969 L .70863 .21492 L p F P
0 g
s
.491 .56 .853 r
.4054 .26663 m .35439 .25696 L .35846 .27021 L p F P
0 g
s
.491 .56 .853 r
.35846 .27021 m .40831 .27982 L .4054 .26663 L p F P
0 g
s
.749 .813 .903 r
.58241 .32153 m .63486 .31598 L .63866 .30485 L p F P
0 g
s
.74 .827 .918 r
.63486 .31598 m .58241 .32153 L .58033 .33176 L p F P
0 g
s
0 .675 0 r
.21888 .1539 m .21949 .15693 L .20818 .1566 L closepath p F P
0 g
s
0 .871 0 r
.21927 .15139 m .21888 .1539 L .20818 .1566 L closepath p F P
0 g
s
0 .354 0 r
.21949 .15693 m .22074 .15871 L .20818 .1566 L closepath p F P
0 g
s
.422 .413 .744 r
.34159 .16733 m .29809 .15555 L .29892 .1712 L p F P
0 g
s
1 1 0 r
.007 w
.3038 .15415 m
.31893 .15889 L
s
0 0 1 r
.27625 .14664 m
.28989 .15333 L
s
.5 Mabswid
.422 .413 .744 r
.29892 .1712 m .34227 .18322 L .34159 .16733 L p F P
0 g
s
0 0 0 r
.22043 .15086 m .21927 .15139 L .20818 .1566 L closepath p F P
0 g
s
0 .781 0 r
.22074 .15871 m .2219 .15819 L .20818 .1566 L closepath p F P
0 g
s
.822 .829 .854 r
.6453 .28046 m .69586 .27111 L .69984 .25787 L p F P
0 g
s
.817 .843 .869 r
.69586 .27111 m .6453 .28046 L .64215 .293 L p F P
0 g
s
.621 .723 .919 r
.52673 .32332 m .47119 .32121 L .47344 .33145 L p F P
0 g
s
.621 .723 .919 r
.47344 .33145 m .52682 .3335 L .52673 .32332 L p F P
0 g
s
.684 .774 .919 r
.52682 .3335 m .58033 .33176 L .58241 .32153 L p F P
0 g
s
0 .346 0 r
.22168 .15263 m .22043 .15086 L .20818 .1566 L closepath p F P
0 g
s
0 .751 0 r
.2219 .15819 m .22229 .15567 L .20818 .1566 L closepath p F P
0 g
s
.894 .798 .747 r
.71171 .18409 m .75606 .17227 L .75688 .15659 L p F P
0 g
s
.893 .813 .762 r
.75606 .17227 m .71171 .18409 L .71046 .19969 L p F P
0 g
s
0 .605 0 r
.22229 .15567 m .22168 .15263 L .20818 .1566 L closepath p F P
0 g
s
0 1 0 r
.007 w
.22207 .15457 m
.27625 .14664 L
s
.5 Mabswid
.501 .55 .839 r
.40286 .25284 m .35085 .24314 L .35439 .25696 L p F P
0 g
s
.501 .55 .839 r
.35439 .25696 m .4054 .26663 L .40286 .25284 L p F P
0 g
s
.684 .774 .919 r
.58241 .32153 m .52673 .32332 L .52682 .3335 L p F P
0 g
s
.566 .646 .888 r
.46718 .29844 m .41158 .29237 L .4152 .30423 L p F P
0 g
s
.566 .646 .888 r
.4152 .30423 m .4691 .3102 L .46718 .29844 L p F P
0 g
s
.894 .798 .747 r
.75688 .15659 m .71238 .16819 L .71171 .18409 L p F P
0 g
s
1 1 0 r
.007 w
.744 .15746 m
.75854 .15263 L
s
.5 Mabswid
.756 .8 .888 r
.58434 .31052 m .63866 .30485 L .64215 .293 L p F P
0 g
s
.749 .813 .903 r
.63866 .30485 m .58434 .31052 L .58241 .32153 L p F P
0 g
s
.826 .815 .839 r
.64811 .26728 m .69984 .25787 L .70331 .24405 L p F P
0 g
s
.822 .829 .854 r
.69984 .25787 m .64811 .26728 L .6453 .28046 L p F P
0 g
s
.631 .711 .904 r
.52665 .31235 m .4691 .3102 L .47119 .32121 L p F P
0 g
s
.631 .711 .904 r
.47119 .32121 m .52673 .32332 L .52665 .31235 L p F P
0 g
s
.693 .761 .904 r
.52673 .32332 m .58241 .32153 L .58434 .31052 L p F P
0 g
s
.509 .54 .824 r
.40071 .23848 m .34786 .22881 L .35085 .24314 L p F P
0 g
s
.509 .54 .824 r
.35085 .24314 m .40286 .25284 L .40071 .23848 L p F P
0 g
s
1 1 0 r
.007 w
.31893 .15889 m
.33592 .16332 L
s
.5 Mabswid
0 .29 0 r
.69293 .35421 m .69566 .35303 L .70112 .36122 L closepath p F P
0 g
s
0 .232 0 r
.69566 .35303 m .69766 .3509 L .70112 .36122 L closepath p F P
0 g
s
.575 .635 .873 r
.46545 .28597 m .40831 .27982 L .41158 .29237 L p F P
0 g
s
.575 .635 .873 r
.41158 .29237 m .46718 .29844 L .46545 .28597 L p F P
0 g
s
.829 .801 .825 r
.65056 .25348 m .70331 .24405 L .70624 .22972 L p F P
0 g
s
.826 .815 .839 r
.70331 .24405 m .65056 .25348 L .64811 .26728 L p F P
0 g
s
0 .128 0 r
.69107 .35375 m .69293 .35421 L .70112 .36122 L closepath p F P
0 g
s
0 0 0 r
.69766 .3509 m .69777 .34906 L .70112 .36122 L closepath p F P
0 g
s
0 0 .275 r
.30618 .16241 m .30717 .15946 L .30964 .16302 L closepath p F P
0 g
s
0 0 0 r
.30362 .16396 m .30618 .16241 L .30964 .16302 L closepath p F P
0 g
s
0 0 .413 r
.30717 .15946 m .30602 .15682 L .30964 .16302 L closepath p F P
0 g
s
.693 .761 .904 r
.58434 .31052 m .52665 .31235 L .52673 .32332 L p F P
0 g
s
.762 .787 .873 r
.58611 .29877 m .64215 .293 L .6453 .28046 L p F P
0 g
s
.756 .8 .888 r
.64215 .293 m .58611 .29877 L .58434 .31052 L p F P
0 g
s
0 0 .937 r
.30099 .1632 m .30362 .16396 L .30964 .16302 L closepath p F P
0 g
s
0 0 .049 r
.30602 .15682 m .30339 .15605 L .30964 .16302 L closepath p F P
0 g
s
0 .405 0 r
.69117 .35192 m .69107 .35375 L .70112 .36122 L closepath p F P
0 g
s
0 .576 0 r
.69777 .34906 m .69591 .3486 L .70112 .36122 L closepath p F P
0 g
s
0 0 .847 r
.29983 .16056 m .30099 .1632 L .30964 .16302 L closepath p F P
0 g
s
0 0 .408 r
.30339 .15605 m .30082 .1576 L .30964 .16302 L closepath p F P
0 g
s
.516 .531 .81 r
.39896 .22362 m .34542 .21401 L .34786 .22881 L p F P
0 g
s
.516 .531 .81 r
.34786 .22881 m .40071 .23848 L .39896 .22362 L p F P
0 g
s
0 0 .634 r
.30082 .1576 m .29983 .16056 L .30964 .16302 L closepath p F P
0 g
s
0 0 1 r
.007 w
.28989 .15333 m
.30051 .15854 L
s
.5 Mabswid
0 .469 0 r
.69317 .34979 m .69117 .35192 L .70112 .36122 L closepath p F P
0 g
s
0 .51 0 r
.69591 .3486 m .69317 .34979 L .70112 .36122 L closepath p F P
0 g
s
0 1 0 r
.007 w
.66437 .30749 m
.69328 .34974 L
s
.5 Mabswid
.639 .699 .889 r
.52657 .30063 m .46718 .29844 L .4691 .3102 L p F P
0 g
s
.639 .699 .889 r
.4691 .3102 m .52665 .31235 L .52657 .30063 L p F P
0 g
s
.831 .787 .811 r
.65263 .23913 m .70624 .22972 L .70863 .21492 L p F P
0 g
s
.829 .801 .825 r
.70624 .22972 m .65263 .23913 L .65056 .25348 L p F P
0 g
s
0 .397 0 r
.37639 .35576 m .37919 .35703 L .37189 .36424 L closepath p F P
0 g
s
0 .663 0 r
.37455 .35363 m .37639 .35576 L .37189 .36424 L closepath p F P
0 g
s
.7 .749 .889 r
.52665 .31235 m .58434 .31052 L .58611 .29877 L p F P
0 g
s
0 0 0 r
.37919 .35703 m .38132 .35669 L .37189 .36424 L closepath p F P
0 g
s
0 .766 0 r
.37476 .35188 m .37455 .35363 L .37189 .36424 L closepath p F P
0 g
s
0 0 .979 r
.73994 .16023 m .7417 .1597 L .75264 .16182 L closepath p F P
0 g
s
1 1 0 r
.007 w
.72757 .162 m
.72981 .16138 L
s
.72981 .16138 m
.744 .15746 L
s
.5 Mabswid
0 0 .864 r
.73915 .16277 m .73994 .16023 L .75264 .16182 L closepath p F P
0 g
s
0 0 .685 r
.73979 .16585 m .73915 .16277 L .75264 .16182 L closepath p F P
0 g
s
0 0 .437 r
.74148 .16765 m .73979 .16585 L .75264 .16182 L closepath p F P
0 g
s
0 0 0 r
.74324 .16714 m .74148 .16765 L .75264 .16182 L closepath p F P
0 g
s
0 0 .829 r
.74404 .16459 m .74324 .16714 L .75264 .16182 L closepath p F P
0 g
s
0 0 .606 r
.7434 .16151 m .74404 .16459 L .75264 .16182 L closepath p F P
0 g
s
0 0 .151 r
.7417 .1597 m .7434 .16151 L .75264 .16182 L closepath p F P
0 g
s
.583 .624 .859 r
.4639 .27282 m .4054 .26663 L .40831 .27982 L p F P
0 g
s
.583 .624 .859 r
.40831 .27982 m .46545 .28597 L .4639 .27282 L p F P
0 g
s
1 1 0 r
.007 w
.70935 .16617 m
.72757 .162 L
s
.5 Mabswid
0 .974 0 r
.38132 .35669 m .38153 .35494 L .37189 .36424 L closepath p F P
0 g
s
0 .182 0 r
.37689 .35153 m .37476 .35188 L .37189 .36424 L closepath p F P
0 g
s
.522 .521 .796 r
.39762 .20829 m .34355 .1988 L .34542 .21401 L p F P
0 g
s
.522 .521 .796 r
.34542 .21401 m .39896 .22362 L .39762 .20829 L p F P
0 g
s
.766 .774 .859 r
.58771 .2863 m .6453 .28046 L .64811 .26728 L p F P
0 g
s
.762 .787 .873 r
.6453 .28046 m .58771 .2863 L .58611 .29877 L p F P
0 g
s
0 .705 0 r
.38153 .35494 m .3797 .3528 L .37189 .36424 L closepath p F P
0 g
s
.7 .749 .889 r
.58611 .29877 m .52657 .30063 L .52665 .31235 L p F P
0 g
s
0 .498 0 r
.3797 .3528 m .37689 .35153 L .37189 .36424 L closepath p F P
0 g
s
0 1 0 r
.007 w
.37912 .35254 m
.40554 .30972 L
s
.5 Mabswid
.832 .774 .797 r
.65432 .22426 m .70863 .21492 L .71046 .19969 L p F P
0 g
s
.831 .787 .811 r
.70863 .21492 m .65432 .22426 L .65263 .23913 L p F P
0 g
s
.646 .688 .875 r
.5265 .28818 m .46545 .28597 L .46718 .29844 L p F P
0 g
s
.646 .688 .875 r
.46718 .29844 m .52657 .30063 L .5265 .28818 L p F P
0 g
s
.528 .512 .782 r
.3967 .19256 m .34227 .18322 L .34355 .1988 L p F P
0 g
s
.528 .512 .782 r
.34355 .1988 m .39762 .20829 L .3967 .19256 L p F P
0 g
s
.706 .737 .875 r
.52657 .30063 m .58611 .29877 L .58771 .2863 L p F P
0 g
s
.589 .614 .845 r
.46255 .25904 m .40286 .25284 L .4054 .26663 L p F P
0 g
s
.589 .614 .845 r
.4054 .26663 m .4639 .27282 L .46255 .25904 L p F P
0 g
s
.77 .761 .845 r
.58914 .27316 m .64811 .26728 L .65056 .25348 L p F P
0 g
s
.766 .774 .859 r
.64811 .26728 m .58914 .27316 L .58771 .2863 L p F P
0 g
s
.833 .761 .783 r
.65561 .20893 m .71046 .19969 L .71171 .18409 L p F P
0 g
s
.832 .774 .797 r
.71046 .19969 m .65561 .20893 L .65432 .22426 L p F P
0 g
s
.533 .503 .768 r
.39621 .17649 m .34159 .16733 L .34227 .18322 L p F P
0 g
s
1 1 0 r
.007 w
.33592 .16332 m
.35466 .16738 L
s
.5 Mabswid
.533 .503 .768 r
.34227 .18322 m .3967 .19256 L .39621 .17649 L p F P
0 g
s
0 0 0 r
.69309 .23252 m .69297 .23342 L .68893 .24603 L closepath p F P
0 g
s
.435 0 0 r
.69095 .23182 m .69309 .23252 L .68893 .24603 L closepath p F P
0 g
s
.683 0 0 r
.68778 .23172 m .69095 .23182 L .68893 .24603 L closepath p F P
0 g
s
.865 0 0 r
.68546 .23229 m .68778 .23172 L .68893 .24603 L closepath p F P
0 g
s
.879 0 0 r
.68532 .23319 m .68546 .23229 L .68893 .24603 L closepath p F P
0 g
s
.347 0 0 r
.68747 .2339 m .68532 .23319 L .68893 .24603 L closepath p F P
0 g
s
.664 0 0 r
.69064 .23399 m .68747 .2339 L .68893 .24603 L closepath p F P
0 g
s
.868 0 0 r
.69297 .23342 m .69064 .23399 L .68893 .24603 L closepath p F P
0 g
s
1 0 0 r
.007 w
.68919 .23395 m
.68967 .21084 L
s
.5 Mabswid
.706 .737 .875 r
.58771 .2863 m .5265 .28818 L .52657 .30063 L p F P
0 g
s
.833 .748 .77 r
.65649 .19319 m .71171 .18409 L .71238 .16819 L p F P
0 g
s
.833 .761 .783 r
.71171 .18409 m .65649 .19319 L .65561 .20893 L p F P
0 g
s
1 0 0 r
.007 w
.68967 .21084 m
.68987 .20132 L
s
.5 Mabswid
.595 .604 .831 r
.46141 .24467 m .40071 .23848 L .40286 .25284 L p F P
0 g
s
.595 .604 .831 r
.40286 .25284 m .46255 .25904 L .46141 .24467 L p F P
0 g
s
.652 .677 .861 r
.52644 .27505 m .4639 .27282 L .46545 .28597 L p F P
0 g
s
.652 .677 .861 r
.46545 .28597 m .5265 .28818 L .52644 .27505 L p F P
0 g
s
.711 .725 .861 r
.5265 .28818 m .58771 .2863 L .58914 .27316 L p F P
0 g
s
1 1 0 r
.007 w
.35466 .16738 m
.375 .17103 L
s
.5 Mabswid
.773 .749 .832 r
.59038 .25938 m .65056 .25348 L .65263 .23913 L p F P
0 g
s
.77 .761 .845 r
.65056 .25348 m .59038 .25938 L .58914 .27316 L p F P
0 g
s
.391 0 0 r
.38499 .23421 m .38685 .23491 L .38306 .24846 L closepath p F P
0 g
s
.817 0 0 r
.38685 .23491 m .38634 .23582 L .38306 .24846 L closepath p F P
0 g
s
.683 0 0 r
.38186 .23411 m .38499 .23421 L .38306 .24846 L closepath p F P
0 g
s
.854 0 0 r
.37928 .23468 m .38186 .23411 L .38306 .24846 L closepath p F P
0 g
s
.971 0 0 r
.37877 .23559 m .37928 .23468 L .38306 .24846 L closepath p F P
0 g
s
.275 0 0 r
.38062 .2363 m .37877 .23559 L .38306 .24846 L closepath p F P
0 g
s
.663 0 0 r
.38376 .2364 m .38062 .2363 L .38306 .24846 L closepath p F P
0 g
s
.858 0 0 r
.38634 .23582 m .38376 .2364 L .38306 .24846 L closepath p F P
0 g
s
1 0 0 r
.007 w
.38224 .20519 m
.38283 .23637 L
s
.38184 .18422 m
.38224 .20519 L
s
.38165 .17448 m
.38184 .18422 L
s
.5 Mabswid
.833 .748 .77 r
.71238 .16819 m .65697 .1771 L .65649 .19319 L p F P
0 g
s
1 0 0 r
.007 w
.68987 .20132 m
.69033 .17912 L
s
0 0 1 r
.71176 .16869 m
.74377 .16331 L
s
.69047 .17227 m
.71176 .16869 L
s
1 0 0 r
.69033 .17912 m
.69047 .17227 L
s
1 1 0 r
.68949 .16996 m
.70935 .16617 L
s
.5 Mabswid
.711 .725 .861 r
.58914 .27316 m .52644 .27505 L .5265 .28818 L p F P
0 g
s
.6 .594 .818 r
.46048 .22976 m .39896 .22362 L .40071 .23848 L p F P
0 g
s
.6 .594 .818 r
.40071 .23848 m .46141 .24467 L .46048 .22976 L p F P
0 g
s
.775 .737 .818 r
.59144 .24501 m .65263 .23913 L .65432 .22426 L p F P
0 g
s
.773 .749 .832 r
.65263 .23913 m .59144 .24501 L .59038 .25938 L p F P
0 g
s
.657 .666 .847 r
.52638 .26128 m .46255 .25904 L .4639 .27282 L p F P
0 g
s
.657 .666 .847 r
.4639 .27282 m .52644 .27505 L .52638 .26128 L p F P
0 g
s
1 1 0 r
.007 w
.66814 .1733 m
.68949 .16996 L
s
.5 Mabswid
.715 .713 .847 r
.52644 .27505 m .58914 .27316 L .59038 .25938 L p F P
0 g
s
1 1 0 r
.007 w
.375 .17103 m
.39678 .17423 L
s
.5 Mabswid
.604 .585 .805 r
.45977 .21437 m .39762 .20829 L .39896 .22362 L p F P
0 g
s
.604 .585 .805 r
.39896 .22362 m .46048 .22976 L .45977 .21437 L p F P
0 g
s
0 .291 0 r
.53573 .36959 m .53888 .36979 L .53816 .37787 L closepath p F P
0 g
s
0 0 0 r
.53888 .36979 m .5414 .36849 L .53816 .37787 L closepath p F P
0 g
s
0 .435 0 r
.53378 .36801 m .53573 .36959 L .53816 .37787 L closepath p F P
0 g
s
.715 .713 .847 r
.59038 .25938 m .52638 .26128 L .52644 .27505 L p F P
0 g
s
0 .801 0 r
.5414 .36849 m .54181 .36644 L .53816 .37787 L closepath p F P
0 g
s
.777 .726 .805 r
.5923 .2301 m .65432 .22426 L .65561 .20893 L p F P
0 g
s
.775 .737 .818 r
.65432 .22426 m .5923 .2301 L .59144 .24501 L p F P
0 g
s
0 .012 0 r
.53418 .36596 m .53378 .36801 L .53816 .37787 L closepath p F P
0 g
s
.661 .656 .834 r
.52634 .2469 m .46141 .24467 L .46255 .25904 L p F P
0 g
s
.661 .656 .834 r
.46255 .25904 m .52638 .26128 L .52634 .2469 L p F P
0 g
s
0 .689 0 r
.54181 .36644 m .53987 .36485 L .53816 .37787 L closepath p F P
0 g
s
0 .34 0 r
.5367 .36465 m .53418 .36596 L .53816 .37787 L closepath p F P
0 g
s
.718 .702 .834 r
.52638 .26128 m .59038 .25938 L .59144 .24501 L p F P
0 g
s
0 .501 0 r
.53987 .36485 m .5367 .36465 L .53816 .37787 L closepath p F P
0 g
s
0 1 0 r
.007 w
.53618 .31972 m
.53771 .36471 L
s
.5 Mabswid
.607 .575 .792 r
.45928 .19855 m .3967 .19256 L .39762 .20829 L p F P
0 g
s
.607 .575 .792 r
.39762 .20829 m .45977 .21437 L .45928 .19855 L p F P
0 g
s
1 1 0 r
.007 w
.64547 .17616 m
.66814 .1733 L
s
.5 Mabswid
.778 .714 .792 r
.59295 .2147 m .65561 .20893 L .65649 .19319 L p F P
0 g
s
.777 .726 .805 r
.65561 .20893 m .59295 .2147 L .5923 .2301 L p F P
0 g
s
.718 .702 .834 r
.59144 .24501 m .52634 .2469 L .52638 .26128 L p F P
0 g
s
0 0 1 r
.007 w
.38165 .17448 m
.38883 .17554 L
s
.5 Mabswid
.665 .645 .821 r
.5263 .23198 m .46048 .22976 L .46141 .24467 L p F P
0 g
s
.665 .645 .821 r
.46141 .24467 m .52634 .2469 L .5263 .23198 L p F P
0 g
s
.611 .566 .779 r
.45901 .18236 m .39621 .17649 L .3967 .19256 L p F P
0 g
s
0 0 1 r
.007 w
.3936 .17624 m
.40316 .17765 L
s
.38883 .17554 m
.3936 .17624 L
s
1 1 0 r
.39678 .17423 m
.4198 .17694 L
s
.5 Mabswid
.611 .566 .779 r
.3967 .19256 m .45928 .19855 L .45901 .18236 L p F P
0 g
s
.721 .691 .821 r
.52634 .2469 m .59144 .24501 L .5923 .2301 L p F P
0 g
s
.779 .703 .78 r
.59341 .19887 m .65649 .19319 L .65697 .1771 L p F P
0 g
s
.778 .714 .792 r
.65649 .19319 m .59341 .19887 L .59295 .2147 L p F P
0 g
s
.721 .691 .821 r
.5923 .2301 m .5263 .23198 L .52634 .2469 L p F P
0 g
s
1 1 0 r
.007 w
.4198 .17694 m
.44387 .17913 L
s
.5 Mabswid
.668 .635 .808 r
.52627 .21656 m .45977 .21437 L .46048 .22976 L p F P
0 g
s
.668 .635 .808 r
.46048 .22976 m .5263 .23198 L .52627 .21656 L p F P
0 g
s
.779 .703 .78 r
.65697 .1771 m .59365 .18267 L .59341 .19887 L p F P
0 g
s
1 1 0 r
.007 w
.6217 .17852 m
.64547 .17616 L
s
.5 Mabswid
.723 .681 .808 r
.5263 .23198 m .5923 .2301 L .59295 .2147 L p F P
0 g
s
.41 0 0 r
.5395 .24495 m .54154 .24568 L .5375 .25942 L closepath p F P
0 g
s
.704 0 0 r
.54154 .24568 m .54122 .24661 L .5375 .25942 L closepath p F P
0 g
s
.683 0 0 r
.5363 .24486 m .5395 .24495 L .5375 .25942 L closepath p F P
0 g
s
.861 0 0 r
.53381 .24545 m .5363 .24486 L .5375 .25942 L closepath p F P
0 g
s
.937 0 0 r
.53348 .24638 m .53381 .24545 L .5375 .25942 L closepath p F P
0 g
s
.306 0 0 r
.53552 .24711 m .53348 .24638 L .5375 .25942 L closepath p F P
0 g
s
.663 0 0 r
.53873 .24721 m .53552 .24711 L .5375 .25942 L closepath p F P
0 g
s
.865 0 0 r
.54122 .24661 m .53873 .24721 L .5375 .25942 L closepath p F P
0 g
s
1 1 0 r
.007 w
.59704 .18033 m
.6217 .17852 L
s
.5 Mabswid
.67 .626 .796 r
.52625 .20071 m .45928 .19855 L .45977 .21437 L p F P
0 g
s
.67 .626 .796 r
.45977 .21437 m .52627 .21656 L .52625 .20071 L p F P
0 g
s
.723 .681 .808 r
.59295 .2147 m .52627 .21656 L .5263 .23198 L p F P
0 g
s
1 1 0 r
.007 w
.44387 .17913 m
.46877 .18078 L
s
.5 Mabswid
.725 .67 .796 r
.52627 .21656 m .59295 .2147 L .59341 .19887 L p F P
0 g
s
1 1 0 r
.007 w
.57171 .18158 m
.59704 .18033 L
s
.46877 .18078 m
.49425 .18185 L
s
.5 Mabswid
.672 .616 .783 r
.52624 .18447 m .45901 .18236 L .45928 .19855 L p F P
0 g
s
.672 .616 .783 r
.45928 .19855 m .52625 .20071 L .52624 .18447 L p F P
0 g
s
.725 .67 .796 r
.59341 .19887 m .52625 .20071 L .52627 .21656 L p F P
0 g
s
1 0 0 r
.007 w
.53751 .24717 m
.53756 .20741 L
s
.5 Mabswid
.727 .66 .784 r
.52625 .20071 m .59341 .19887 L .59365 .18267 L p F P
0 g
s
0 0 .624 r
.43789 .18472 m .43849 .18155 L .44852 .18434 L closepath p F P
0 g
s
0 0 .839 r
.43849 .18155 m .43782 .17896 L .44852 .18434 L closepath p F P
0 g
s
1 1 0 r
.007 w
.54597 .18226 m
.57171 .18158 L
s
.5 Mabswid
0 0 .203 r
.43639 .18662 m .43789 .18472 L .44852 .18434 L closepath p F P
0 g
s
1 1 0 r
.007 w
.49425 .18185 m
.52007 .18235 L
s
.5 Mabswid
0 0 0 r
.43782 .17896 m .43629 .17847 L .44852 .18434 L closepath p F P
0 g
s
0 0 .968 r
.43485 .18613 m .43639 .18662 L .44852 .18434 L closepath p F P
0 g
s
1 1 0 r
.007 w
.52007 .18235 m
.54597 .18226 L
s
.5 Mabswid
.727 .66 .784 r
.59365 .18267 m .52624 .18447 L .52625 .20071 L p F P
0 g
s
1 0 0 r
.007 w
.53756 .20741 m
.53758 .18445 L
s
.5 Mabswid
0 0 .864 r
.60165 .18285 m .60175 .18029 L .61599 .18388 L closepath p F P
0 g
s
0 0 .685 r
.60169 .18606 m .60165 .18285 L .61599 .18388 L closepath p F P
0 g
s
0 0 .428 r
.43629 .17847 m .43478 .18036 L .44852 .18434 L closepath p F P
0 g
s
0 0 .384 r
.60185 .18806 m .60169 .18606 L .61599 .18388 L closepath p F P
0 g
s
0 0 .867 r
.43419 .18354 m .43485 .18613 L .44852 .18434 L closepath p F P
0 g
s
0 0 .896 r
.60175 .18029 m .60193 .17989 L .61599 .18388 L closepath p F P
0 g
s
0 0 .687 r
.43478 .18036 m .43419 .18354 L .44852 .18434 L closepath p F P
0 g
s
0 0 1 r
.007 w
.40316 .17765 m
.43443 .18226 L
s
.5 Mabswid
0 0 .853 r
.60203 .18767 m .60185 .18806 L .61599 .18388 L closepath p F P
0 g
s
0 0 .866 r
.60212 .18511 m .60203 .18767 L .61599 .18388 L closepath p F P
0 g
s
0 0 .682 r
.60208 .18189 m .60212 .18511 L .61599 .18388 L closepath p F P
0 g
s
0 0 .363 r
.60193 .17989 m .60208 .18189 L .61599 .18388 L closepath p F P
0 g
s
0 0 1 r
.007 w
.53758 .18445 m
.60211 .18398 L
s
.5 Mabswid
0 .004 0 r
.73012 .18921 m .73121 .18614 L .73616 .19 L closepath p F P
0 g
s
0 0 0 r
.72766 .19083 m .73012 .18921 L .73616 .19 L closepath p F P
0 g
s
0 .065 0 r
.73121 .18614 m .73028 .18341 L .73616 .19 L closepath p F P
0 g
s
0 .683 0 r
.72525 .19006 m .72766 .19083 L .73616 .19 L closepath p F P
0 g
s
0 .149 0 r
.73028 .18341 m .72787 .18263 L .73616 .19 L closepath p F P
0 g
s
0 .508 0 r
.72431 .18733 m .72525 .19006 L .73616 .19 L closepath p F P
0 g
s
0 .289 0 r
.72787 .18263 m .72539 .18426 L .73616 .19 L closepath p F P
0 g
s
0 .381 0 r
.72539 .18426 m .72431 .18733 L .73616 .19 L closepath p F P
0 g
s
0 1 0 r
.007 w
.69047 .17227 m
.72491 .18563 L
s
.5 Mabswid
0 .111 0 r
.34499 .19204 m .34757 .19364 L .33976 .19291 L closepath p F P
0 g
s
0 .676 0 r
.34386 .18897 m .34499 .19204 L .33976 .19291 L closepath p F P
0 g
s
0 .932 0 r
.34485 .18622 m .34386 .18897 L .33976 .19291 L closepath p F P
0 g
s
0 .866 0 r
.34757 .19364 m .35009 .19282 L .33976 .19291 L closepath p F P
0 g
s
0 0 0 r
.34737 .1854 m .34485 .18622 L .33976 .19291 L closepath p F P
0 g
s
0 .881 0 r
.35009 .19282 m .35109 .19007 L .33976 .19291 L closepath p F P
0 g
s
0 .388 0 r
.34996 .187 m .34737 .1854 L .33976 .19291 L closepath p F P
0 g
s
0 .676 0 r
.35109 .19007 m .34996 .187 L .33976 .19291 L closepath p F P
0 g
s
0 1 0 r
.007 w
.35041 .18823 m
.38165 .17448 L
s
.5 Mabswid
0 .366 0 r
.53652 .2051 m .53959 .2063 L .54006 .20612 L closepath p F P
0 g
s
0 0 0 r
.53959 .2063 m .54267 .20505 L .54006 .20612 L closepath p F P
0 g
s
0 .921 0 r
.54267 .20505 m .54395 .20208 L .54006 .20612 L closepath p F P
0 g
s
0 .04 0 r
.53525 .20215 m .53652 .2051 L .54006 .20612 L closepath p F P
0 g
s
0 .678 0 r
.54395 .20208 m .54268 .19913 L .54006 .20612 L closepath p F P
0 g
s
0 0 0 r
.53653 .19918 m .53525 .20215 L .54006 .20612 L closepath p F P
0 g
s
0 .354 0 r
.54268 .19913 m .53961 .19793 L .54006 .20612 L closepath p F P
0 g
s
0 .117 0 r
.53961 .19793 m .53653 .19918 L .54006 .20612 L closepath p F P
0 g
s
0 1 0 r
.007 w
.53758 .18445 m
.53914 .19812 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 190},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00017B000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00g`3oool3
003o0<h0oooo003O0?ooo`<00?l0cP3oool00=l0oooo0`00o`3>0?ooo`00g`3oool3003o0<h0oooo
003O0?ooo`<00?l0?P3oool0100000000?l0003o0000o`2<0?ooo`00W@3oool4003o03l0oooo0`00
o`0l0?ooo`D00?l0S03oool009d0oooo1`00o`0T0?ooo`03000000000?l0003o00l0003o4P3oo`0F
0?ooo`H0003o5@3oool7003o08`0oooo002M0?ooo`T00?l07`3oool3000003h0ool02P000?l;0?oo
o`L00?l000<000000?ooo`3oool0R`3oool009l0oooo00<00000003o0000o`001`00o`0=0?oooeP0
ool020000?l30?ooo`L00?l0T03oool00:<0oooo1000o`050000o`80oooo;03oo`0B0;>N`R/0ool0
0`000?l4003o0980oooo002Q0?ooo`/0003o703oo`0A0;jV`@030000002cW/80/ik201@0/ik200<0
00000:RD`@2XU<404`2XU<4I0?oo00030000003oool0oooo08h0oooo002F0?ooo`060000003oool0
oooo0?ooo`000?l0ool040000?l:0?oo00`0bJo000<000000;jV`@2nY/40502nY/400`000000/ik2
0;>N`P0D0;>N`P030000002XU<40Z9C101@0Z9C100<0000009^:`02KR/00102KR/0I0?oo08T0oooo
002D0?ooo`03000000000?l0003o00<0003o0`3oo`0:0000o`L0ool05039[l000`000000_ZK10;jV
`@0D0;jV`@030000002cW/80/ik201@0/ik200<000000:RD`@2XU<40502XU<400`000000Vh[009^:
`00=09^:`1L0ool0PP3oool00980oooo0`0000020000o`H0ool010000?l50?oo00H0e;Rm00<00000
0<V_`039[l004`39[l000`000000_ZK10;jV`@090;jV`Bh000002`2XU<400`000000Vh[009^:`00C
09^:`0030000002<O;d0ool001@0ool000D000000000o`000?l0003o0000001g0?ooo`00T@3oool>
0?oo00d0e;Rm00<000000<V_`039[l003P39[l0A000000/0_ZBo00<000000;BL_`2dW;l0502dW;l0
0`000000ZI:o0:VB_`090:VB_a400000402KR/000`000000S7bm08al_@0708al_@h0ool01P000?lL
0?ooo`800000E`3oool008/0oooo4@3oo`0@0=Bh_@0300000039[l00bJo000<0bJo02`0000050<V/
_@030000002nY;l0_ZBo01@0_ZBo00<000000;BL_`2dW;l0502dW;l00`000000ZI:o0:VB_`0D0:VB
_`030000002LR;d0W8Rm00<0W8Rm2`00000509^:`0030000002<O;d0S7bm00h0S7bm1`3oo`090000
oaH0oooo1P00o`02000005@0oooo001Z0?ooo`D00?l06P3oool>0?oo00030>71^0000000e;Rm00l0
e;Rm2@00000@0<V/_@030000002nY;l0_ZBo01@0_ZBo00<000000;BL_`2dW;l0502dW;l00`000000
ZI:o0:VB_`0D0:VB_`030000002LR;d0W8Rm00h0W8Rm2@00000@08al_@030000001fJ[P0ool000<0
ool02P000?l80?oooa400?l000<000000?ooo`3oool0D`3oool006L0oooo0`00000;003o0100oooo
303oo`070>71^0030000003D^;d0e;Rm00P0e;Rm1P0000030=Be^`0300000039[;d0bJbm01<0bJbm
00<000000;jT_`2nY;l0502nY;l00`000000]9bo0;BL_`0D0;BL_`030000002YT[l0ZI:o01@0ZI:o
00<0000009b8_@2LR;d04`2LR;d010000000S7Zj08aj^P2<N[X6000000X0S7bm00<0000007IZ^01f
J[P00P1fJ[P40?oo00<0003o0`3oo`030000o`<0o`005000o`1F0?ooo`00J03oool2000001800?l0
1`3oool90?oo00`0hL6h00@000000=Bh_@3D^;d0e;Rm1`0000090=Be^`0300000039[;d0bJbm01<0
bJbm00<000000;jT_`2nY;l0502nY;l00`000000]9bo0;BL_`0D0;BL_`030000002YT[l0ZI:o01@0
ZI:o00<0000009b8_@2LR;d04`2LR;d00`000000S7Zj08aj^P0708aj^PL000000`2<O;d00`000000
MVZh07IZ^00607IZ^0H0ool00`000?l30?oo00h00?l0G03oool006X0oooo0`0000020?ooo`h00?l0
00@0o`000000o`000?l0003o2@3oo`0<0>71^0H00000403D]K/00`000000bJbm0<V/_@0C0<V/_@03
0000002nY;l0_ZBo00T0_ZBo;P00000;0:VB_`030000002LR;d0W8Rm01<0W8Rm00<0000008aj^P2<
N[X03P2<N[X5000000T0MVZh103oo`030000o`H0ool0I`3oool007D0oooo1P00o`060000o`D0ool0
00<000000>71^03Q`KP02@3Q`KP400000080h;je00<000000=Be^`3D]K/04@3D]K/00`000000bJbm
0<V/_@0>0<V/_A4000002`2nX[`00`000000]9Zm0;BJ_@0D0;BJ_@030000002YTK`0ZI6l00T0ZI6l
4@00000@09b8_@030000002<N[X0S7Zj0140S7Zj00<0000007QX]00000000`00000:07IZ^0X0ool0
I@3oool007P0oooo10000?l20?oo00<0003o0`3oo`030>o;[P030000003Q`KP0hL6h00@0hL6h1000
00060>2n]@030000003D]K/0e;Fk0140e;Fk00<000000<V/_@39[;d00`39[;d;000000D0bJZk00<0
00000;jR_02nX[`0502nX[`00`000000]9Zm0;BJ_@0D0;BJ_@030000002YTK`0ZI6l01@0ZI6l00<0
000009b6^`2LQ[/00`2LQ[/;000000D0W8Rm00<0000008aj^P2<N[X04@2<N[X00`000000N6Rd07QX
]00307QX]0<00000201fJ[P00`000000ETj]05I>[@090?oo0680oooo001e0?ooo`L0003o0P3oo`00
0`000?l0ool00?oo00060>o;[P030000003Q`KP0hL6h00@000002P3P_[D00`000000e;Fk0=Be^`0>
0=Be^`T000004039Z[/00`000000_Z:l0;jR_00D0;jR_0030000002dV[d0]9Zm01@0]9Zm00<00000
0:VA_02YTK`0502YTK`00`000000W8Jk09b6^`0>09b6^`T000003`2<N[X00`000000N6Rd07QX]007
07QX]0<000001@1fJ[P00`000000ETj]05I>[@0305I>[@P0ool0H03oool00740oooo00<000000000
o`000?l020000?l20?oo00P0kl^^1000000>0>2n]@030000003D]K/0e;Fk00P0e;Fk1P0000030=Bb
^00300000039Z[/0bJZk01<0bJZk00<000000;jR_02nX[`0502nX[`00`000000]9Zm0;BJ_@0D0;BJ
_@030000002YTK`0ZI6l01@0ZI6l00<0000009b6^`2LQ[/04`2LQ[/010000000SGRg08eh]`2=N;L6
000000T0S7Zj00<0000007QX]01hJ;@02P1hJ;@40000000307IZ^0000000ETj]00H0ETj]203oo`05
0?ooo`030000o`3oool0oooo05H0oooo001`0?ooo`8000001`000?l30?oo00L0kl^^0`0000000`3^
aj/000000>2n]@0?0>2n]@040000003D]K/0e;Fk0=Be^`L000002@3D/[P00`000000bJZk0<VZ^`0C
0<VZ^`030000002nX[`0_Z:l00l0_Z:l8P00000A0:VA_0030000002LQ[/0W8Jk01<0W8Jk00<00000
08eh]`2=N;L01`2=N;L6000000<0S7Zj00<0000007QX]01hJ;@03P1hJ;@3000000T0ETj]1`3oo`02
0?ooo`<0003oE`3oool006l0oooo0`0000000`000?l0ool00?oo00050?oo00L0kl^^0P0000040>k7
Z`030000003P_[D0h;je00`0h;je1P00000@0=Bb^00300000039Z[/0bJZk01<0bJZk00<000000;jR
_02nX[`00`2nX[`<000000D0_Z2j00<000000;BH^P2dV;X0502dV;X00`000000ZHnj0:V?^P030:V?
^P`000001@2YTK`00`000000W8Jk09b6^`0B09b6^`030000002=N;L0SGRg00h0SGRg1@00000@07QX
]0040000001HC:T00000000000T0ETj]1@3oo`020?ooo`<0003o00<000000?ooo`3oool0E03oool0
06l0oooo0`0000060?oo00030?gCU`000000kl^^00<0kl^^0`0000060>k7Z`030000003P_[D0h;je
00P0h;je100000020>2j/P030000003D/[P0e;:h00h0e;:h0`3o00000`3D/[P000000<VZ^`0>0<VZ
^`/000004@2nX;X00`000000]9Rj0;BH^P0D0;BH^P030000002YSkX0ZHnj00l0ZHnj2`00000?09b6
^`030000002=N;L0SGRg0140SGRg00<0000007UV/@0000000`00000<07QX]0040000001HC:T0F4bY
05Q<Z@<000001P1FCZd00`0000007QjD0?oo00030?oo00030000003oool0003o0080003o00<00000
0?ooo`3oool0D`3oool00700oooo1P3oo`030?gCU`030000003_bjh00000008000002@3^aj/00`00
0000h;je0>2n]@040>2n]@@000001P3P^[800`000000e;:h0=Bb^00>0=Bb^0<0o`0000<0e;:h0000
0039Z[/01039Z[/:000000D0b:Rh00<000000;jP^P2nX;X0502nX;X00`000000]9Rj0;BH^P0D0;BH
^P030000002YSkX0ZHnj01@0ZHnj00<0000009f4^02MQ;P00`2MQ;P:000000D0W8Jk00<0000008eh
]`2=N;L04@2=N;L00`000000NFJa07UV/@0307UV/@<00000201hJ;@00`000000F4bY05Q<Z@0505Q<
Z@<000000`1FCZd00`0000007QjD01hNU0040?oo0003000000000?l0003o0080003oE@3oool006l0
oooo00<000000?oo003oo`000P3oo`050?gCU`800000303^aj/00`000000h;je0>2n]@04000000X0
h;Zb00<000000=Bb^03D/[P03`3D/[P9000000l0b:Rh00<000000;jP^P2nX;X0502nX;X00`000000
]9Rj0;BH^P0D0;BH^P030000002YSkX0ZHnj01@0ZHnj00<0000009f4^02MQ;P03@2MQ;P900000100
SGRg00<0000007UV/@1iI[401P1iI[43000000D0N6Rd00<0000005Q<Z@1HC:T0201HC:T200000003
05I>[@0000007QjD00807QjD103oo`000`0N7Y@0003o0000o`020000oe@0oooo001^0?ooo`030000
003oo`00ool00080ool0103mdiL3000000`0k/N[1000000?0>2j/P030000003D/[P0e;:h00P0e;:h
1P0000020?l000030=>_]@000000b:Rh01@0b:Rh00<000000;jP^P2nX;X04`2nX;X00`000000]9Rj
0;BH^P0D0;BH^P030000002YSkX0ZHnj01<0ZHnj00<0000009f4^02MQ;P04`2MQ;P010000000SWJd
08if]02>M[@6000000X0SGRg00<0000007UV/@1iI[402@1iI[440000000307QX]0000000F4bY00/0
F4bY0P00000401hNU0@0ool010000?mD0?ooo`00KP3oool40?oo00<0oM>G0P0000020?c>T`030000
003^aj/0k/N[00P0k/N[0P0000000`3^`jL000000>2j/P0@0>2j/P040000003D/[P0e;:h0=Bb^0L0
00002@3C[kD00`000000b:Rh0<RX^00C0<RX^0030000002nX;X0_Z2j00T0_Z2j9`00000@0:V?^P03
0000002MQ;P0WHBh01<0WHBh00<0000008if]02>M[@01`2>M[@7000000<0SGRg00<0000007UV/@1i
I[403@1iI[43000000`0F4bY0`00000301hNU0@0ool00`000?lH0?ooo`800000>P3oool006d0oooo
00@000000?oo003oo`00ool00`3mdiL00`000000o<jC0?c>T`020?c>T`030000003^aj/0k/N[00D0
k/N[0`0000030>k3Y`030000003P^[80h;Zb00d0h;Zb1P00000@0=>_]@0300000038Z;P0b:Rh0100
b:Rh3`00000:0;jN]`030000002dU[P0]9Jh01@0]9Jh00<000000:V=]`2YSKL00`2YSKL;000000D0
ZHnj00<0000009f4^02MQ;P04P2MQ;P00`000000SWJd08if]00?08if]0D000003`1iI[4010000000
FT^U00000000000:05Q<Z@040000000S79008ab@000000<07QjD1@3oo`0K003o00800000>03oool0
0540oooo0P00000<0?ooo`h00?l0103oo`000`3mdiL00000000000060?c>T`040000003^aj/0k/N[
0>k7Z`<000001P3^`jL00`000000h;Zb0>2j/P090>2j/P@000000P3O]jl00`000000djne0=>_]@0A
0=>_]@0300000038Z;P0b:Rh00T0b:Rh1`0000030<RU]@030000002nW[L0_Yjg01<0_Yjg00<00000
0;BF^02dU[P0502dU[P00`000000ZHfg0:V=]`0>0:V=]`/000003`2MQ;P00`000000SWJd08if]00B
08if]0030000001jI:h0000000800000301iI[4010000000FT^U05Y;Y@1JBjD3000000H0F4bY00<0
000002<LT00S79000P0S7902000000807QjD103oo`0K003o00@00000=P3oool004l0oooo0P00000I
003o00<0003o0`3oo`02000000P0o<jC00@000000>k7Z`00000000002P3^`jL00`000000h;Zb0>2j
/P040>2j/P@000001P3O]jl00`000000djne0=>_]@0A0=>_]@0400000038Z;P0b:Rh0<RX^0P00000
2P38YKD00`000000_Yjg0;jN]`0C0;jN]`030000002dU[P0]9Jh01@0]9Jh00<000000:V=]`2YSKL0
4`2YSKL00`000000WH:e09f2]@0309f2]@X000001@2MQ;P00`000000SWJd08if]00B08if]0030000
001jI:h0NVB^0080NVB^0`00000807UV/@030000001JBjD0FT^U00D0FT^U0`00000305Q<Z@030000
000S79008ab@00@08ab@00<0000001hNU00N7Y@00`3oo`0K003o00030000003oool0oooo03L0oooo
001=0?ooo`H000005`00o`030000o`<0ool02P3lcY<2000000`0k/>W00<000000>2j/P3P^[801000
000:0=ng[`030000003C[kD0djne00h0djne1`00000B0<RU]@030000002nW[L0_Yjg01<0_Yjg00<0
00000;BF^02dU[P0502dU[P00`000000ZHfg0:V=]`0C0:V=]`030000002MP[D0WH:e00d0WH:e2@00
000@08if]0030000001jI:h0NVB^00H0NVB^1000000407UV/@030000001JBjD0FT^U00P0FT^U0P00
00000`1HC:T0000002<LT00602<LT08000000`3oo`020?l005<0oooo001@0?ooo`<000003000o`0:
0?ooo`@0003o0P3oo`000`000000o<jC0?c>T`060?c>T`<00000303^`jL4000000l0gkN_00<00000
0=>_]@3C[kD01`3C[kD6000000<0djfb00<000000<RU]@38YKD04`38YKD00`000000_Yjg0;jN]`0C
0;jN]`030000002dU[P0]9Jh01@0]9Jh00<000000:V=]`2YSKL04`2YSKL00`000000WH:e09f2]@0B
09f2]@040000002>M;40SWBa08id/@H000002P2>M[@00`000000NVB^07YT[P0:07YT[P<0000000<0
NFJa0000001JBjD02`1JBjD2000000T08ab@0`3oo`000`0005@000000?ooo`1B0?ooo`00J@3oool3
0000o`<0ool000<000000?c>T`3lcY<0103lcY<200000080nlV?00<000000>k3Y`3^`jL0203^`jL2
000000030>foX`000000gkN_0100gkN_00@000000=>_]@3C[kD0djne1P0000090=>]/P0300000038
YKD0b:Fe01<0b:Fe00<000000;jN]`2nW[L02@2nW[L/000000/0ZHfg00<0000009f2]@2MP[D04P2M
P[D00`000000SWBa08id/@0708id/@L000000`2>M[@00`000000NVB^07YT[P0=07YT[P<00000301J
BjD3000000L08ab@0`3oo`000`0005@000000?ooo`1B0?ooo`00J03oool40000o`@0ool01@3lcY<0
0`000000nlV?0?_9S`020?_9S`030000003^`jL0k/>W00H0k/>W0P0000030>foX`030000003O]jl0
gkN_00d0gkN_1P00000?0=>]/P0300000038YKD0b:Fe0100b:Fe3`00000:0;jK]0030000002dTkD0
]9>e01@0]9>e00<000000:V;]02YRk@0202YRk@?00000140WH:e00<0000008id/@2>M;403P2>M;45
000000l0NVB^00@0000005a8XP00000000002P1JBjD0100000009a^<02LKS000000602<LT0<0ool0
00<0001D0000003oool0DP3oool006P0oooo0P0000000`000?l00000000000030?oo00030000003l
cY<0o<jC008000001@3kbHl00`000000k/>W0>k3Y`030>k3Y`<000001@3]_j<00`000000gkN_0=ng
[`090=ng[`@000000P3O]:/00`000000djfb0=>]/P0A0=>]/P0300000038YKD0b:Fe00P0b:Fe1`00
00030<RS/`030000002nVk@0_Y^d01<0_Y^d00<000000;BC]@2dTkD0502dTkD00`000000ZH^d0:V;
]00C0:V;]0040000002MP;80WH2b09f0/PL000002P2MP[D00`000000SWBa08id/@0A08id/@030000
001kHZ/0000000800000301jI:h010000000G4RR05a8XP1LB:83000000H0FT^U00<0000002LKS00W
6h`00P0W6h`2000000<08ab@103oo`02000005<0oooo001W0?ooo`<0000000<0003o000000000000
103oo`02000000L0nlV?00@000000>k3Y`3^`jL0k/>W0P0000090>foX`030000003O]jl0gkN_00@0
gkN_100000060=ndZ`030000003C[K80djfb0140djfb00@000000<RU]@38YKD0b:Fe1`00000:0<RS
/`030000002nVk@0_Y^d01<0_Y^d00<000000;BC]@2dTkD04`2dTkD00`000000ZH^d0:V;]00D0:V;
]0030000002MP;80WH2b00P0WH2b1`00000309f2]@030000002>M;40SWBa0140SWBa00<0000007]R
Z`1kHZ/00P1kHZ/3000000P0NVB^00<0000005a8XP1LB:801@1LB:83000000<0FT^U00<0000002LK
S00W6h`0100W6h`00`0000008ab@02<LT0030?oo00030000D@000000000005<0oooo001W0?ooo`H0
000000@0n/AI0?oo003oo`00ool02@3kbHl010000000k/>W00000000000;0>foX`030000003O]jl0
gkN_00@000002P3O]:/00`000000djfb0=>]/P0>0=>]/PL000004@38Xk<00`000000_Y^d0;jK]00C
0;jK]0030000002dTkD0]9>e01<0]9>e00<000000:V;]02YRk@04`2YRk@00`000000WH2b09f0/P0@
09f0/PL000003`2>M;400`000000Nf:[07]RZ`0607]RZ`@00000101jI:h00`000000G4RR05a8XP08
05a8XP80000000<0FT^U0000000W6h`01P0W6h`2000000<0ool000<0001A0000000000000`000?m@
0?ooo`00J03oool6000000@0ool0203kbHl2000000`0kKnS1000000?0=ndZ`030000003C[K80djfb
00L0djfb1P0000030=:Y[`0300000038Xk<0b:>c01<0b:>c00<000000;jK]02nVk@04P2nVk@00`00
0000]9>e0;BC]@0C0;BC]@030000002YRk@0ZH^d01<0ZH^d00<0000009f0/P2MP;804`2MP;801000
0000Sg:^08mb[P2?LZh6000000T0SWBa00<0000007]RZ`1kHZ/02P1kHZ/30000000307YT[P000000
G4RR00/0G4RR0P00000802LKS0@0ool000<0001A000000000?l00`000?m@0?ooo`00JP3oool01@3o
000000000000000008H0000000@0ool01@3kbHl3000000/0kKnS0P0000000`3/^il000000=ndZ`0@
0=ndZ`040000003C[K80djfb0=>]/PH000002@3BZJl00`000000b:>c0<RS/`0C0<RS/`030000002n
Vk@0_Y^d00P0_Y^d:`00000;0:V;]0030000002MP;80WH2b01<0WH2b00<0000008mb[P2?LZh01`2?
LZh6000000<0SWBa00<0000007]RZ`1kHZ/03@1kHZ/3000000`0G4RR0`00000502LKS0@0ool01`00
0?m@0?ooo`00JP3oool00`3o00000000000000020000QP030000003oo`00ool00080ool00P3kbHl2
000000<0n/B;00<000000>foX`3]_j<01P3]_j<2000000<0k;^O00<000000=ndZ`3O]:/03@3O]:/6
00000100dZV_00<000000<RS/`38Xk<03@38Xk<@000000X0_YVb00<000000;BA/P2dTK804`2dTK80
0`000000ZXRb0:Z8/P080:Z8/Pl000004@2MP;800`000000Sg:^08mb[P0>08mb[PD000003`1kHZ/0
10000000GTNN00000000000:05a8XP040000000[6XP0:aZ8000000809a^<103oo`070000o`030000
003oool0oooo04l0oooo001Z0?ooo`80o`0000@000000000QP0008H000261P3oo`050?[4R`030000
003]_j<0kKnS00@0kKnS0P0000050>bkW`030000003O]:/0gkB[00T0gkB[100000020=j`Z0030000
003BZJl0dZV_0140dZV_00<000000<RS/`38Xk<00`38Xk<:000000D0b:2`00<000000;jI/P2nVK80
4P2nVK800`000000]96b0;BA/P0C0;BA/P030000002ZR;80ZXRb01<0ZXRb00@0000009in/02NO[00
WWj`1`00000:09f0/P030000002?LZh0Sg:^0140Sg:^00<0000007aPY`0000000P00000<07]RZ`04
0000001NAih0GTNN05i7WP<000001P1LB:800`000000:aZ802/JR00202/JR0030000003oo`00ool0
0080ool01`000?mC0?ooo`00JP3oool20?l000030000000008H000260080002600<000000?oo003o
o`00103oo`030?[4R`030000003]_j<0kKnS0080kKnS0P0000080>bkW`030000003O]:/0gkB[00@0
gkB[100000060=j`Z0030000003BZJl0dZV_00l0dZV_2000000?0<RP/0030000002nVK80_YVb0180
_YVb00<000000;BA/P2dTK804`2dTK800`000000ZXRb0:Z8/P0C0:Z8/P030000002NO[00WWj`00P0
WWj`1`00000309f0/P030000002?LZh0Sg:^0100Sg:^00<0000007aPY`1lH:L00`1lH:L3000000P0
Nf:[00<0000005i7WP1NAih01@1NAih3000000<0G4RR00<0000002/JR00[6XP00P0[6XP30?oo00H0
003o0P00001D0?ooo`00JP3oool20?l000030000000008H0002600<0002600<000000?oo003oo`00
1@3oo`020?[4R`040000003]_j<00000000000X0k;^O00<000000=ndZ`3O]:/01000000:0=j`Z003
0000003BZJl0dZV_00X0dZV_1@0000020=:W[00300000038X;00b:2`0180b:2`00<000000;jI/P2n
VK804`2nVK800`000000]96b0;BA/P0B0;BA/P030000002ZR;80ZXRb01<0ZXRb00<0000009in/02N
O[003`2NO[0600000100Sg:^00<0000007aPY`1lH:L01P1lH:L4000000@0Nf:[00<0000005i7WP1N
Aih0201NAih20000000405a8XP000000:aZ802/JR0<0ool01@00o`001@000?l0oMn;0?gOR`000000
aK@Z05@0oooo001Z0?ooo`80o`0000<000000000QP0008H0100008H2000000H0ool000<0n/B;0000
000000002`3/^il4000000l0g[2X00<000000=:Y[`3BZJl01@3BZJl4000000L0dZN/00<000000<RP
/038X;004P38X;000`000000_YVb0;jI/P0C0;jI/P030000002dTK80]96b0180]96b00<000000:Z8
/P2ZR;804`2ZR;800`000000WWj`09in/00B09in/0030000002@L:/0T72[00H000002P2?LZh00`00
0000O62W07aPY`0:07aPY`<0000000<0Nf:[0000001NAih02`1NAih2000000D0ool03@00o`1A0?oo
o`00JP3oool20?l0008000001@0008H6003o00040000o`3oo`00ool00?oo00X0k;^O0P0000000`3[
]Y`000000=j`Z00@0=j`Z0030000003BZJl0dZV_00D000002`3BYj`00`000000b:2`0<RP/00B0<RP
/0030000002nVK80_YVb00T0_YVb:P00000;0:Z8/P030000002NO[00WWj`0180WWj`00<00000091`
Z`2@L:/01P2@L:/6000000<0Sg:^00<0000007aPY`1lH:L03P1lH:L3000000X0GTNN203oo`0E003o
04T0oooo001Z0?ooo`030?l00000o`000?l000`00?l00`000?l40?oo00D0k;^O0P0000040>^fW003
0000003N/:P0g[2X00d0g[2X1000000A0=:W[00300000038X;00b:2`00d0b:2`4000000:0;jG[`03
0000002dSk00]8n`0180]8n`00<000000:Z6[`2ZQZl0202ZQZl@000000l0WWj`00<00000091`Z`2@
L:/03@2@L:/500000100O62W00@000000655VP00000000001P1NAih80?oo0080mMVa0`3o00020?gO
RaH00?l000<000000?ooo`3oool0@03oool005l0oooo00@000000?ooo`3oool0oooo5P00o`060000
o`<0ool000<0k;^O0000000000001P3[]Y`00`000000g[2X0=j`Z0090=j`Z0@0000000<0gJfU0000
003BYj`04P3BYj`00`000000b:2`0<RP/0030<RP/0X000001037WJd00`000000_YN_0;jG[`0C0;jG
[`030000002dSk00]8n`0180]8n`00<000000:Z6[`2ZQZl04`2ZQZl00`000000WWb]09il[@0209il
[@X000001@2NO[000`000000T72[091`Z`0@091`Z`030000001mGZ@0000000800000301lH:L00`00
0000HDFJ0655VP020655VP8000002P3oo`040?GI/@<0o`000P3mgh/00`000000nnB?0?_TS`020000
00030?l0003oool0oooo00h00?l00`0000100?ooo`00G@3oool00`0000000?l0003o000C003o0003
0000000m@jl0?D>_00<0o`001`000?l60?oo00D0jkJL00<000000=j`Z03N/:P01@3N/:P4000000D0
gJfU00<000000=:W[03BYj`03`3BYj`8000000h0aif]00<000000;jG[`2nUjl04`2nUjl00`000000
]8n`0;B?/00B0;B?/0030000002ZQZl0ZXJ_01<0ZXJ_00<0000009il[@2NO:d0302NO:d800000100
T72[00<0000007eNY01mGZ@00P1mGZ@3000000T0O62W00<000000655VP1QAIX00P1QAIX90?oo0003
0000003efK40mMVa00@0mMVa0`3o00000`3mgh/000000?_TS`020?_TS`030000003o0000o`0000X0
oooo1P00o`05000003h0oooo001K0?ooo`<000003@00o`020?l000030000000008T0002900800029
0P00000203e3[`<0o`000P0m@jl60000o`030000003oo`00ool000@0ool0103[]Y`00`000000g[2X
0=j`Z004000000T0gJfU00<000000=:W[03BYj`02P3BYj`500000080dJBY00<000000<NM[@37WJd0
4@37WJd00`000000_YN_0;jG[`0C0;jG[`030000002dSk00]8n`0180]8n`00<000000:Z6[`2ZQZl0
4P2ZQZl00`000000WWb]09il[@0B09il[@030000002@KZP0T6jX00@000002`2@L:/00`000000OEjT
07eNY00607eNY0@000001@1lH:L00`000000ool00?oo00090?oo00030000003efK40mMVa00H0mMVa
0`3o00000`000000nnB?0?_TS`020?_TS`030000003o0000o`0000h0oooo100000110?ooo`00F@3o
ool5000000D00?l0203oool20?l000030000000008T0002900<000290P000000100m@jl0o`000?l0
003o000503e3[`D0003o0P0000070?oo00<000003P3M[JD00`000000dZN/0=:W[0050=:W[0@00000
1`3AY:T00`000000aif]0<NM[@0B0<NM[@030000002nUjl0_YN_0180_YN_00<000000;B?/02dSk00
4P2dSk000`000000ZXJ_0:Z6[`0B0:Z6[`030000002NO:d0WWb]0140WWb]00<00000091^Z02@KZP0
1@2@KZP5000000H0T72[00<0000007eNY01mGZ@02P1mGZ@30000000307aPY`3oo`00ool000L0ool0
0`00000:0?GI/@<0o`001@3ki8l00`000000o`000?l0001C0?ooo`00G03oool4000000/0oooo0P3o
0002000000@0002900<0000003U5/`0000000`3o000603e3[`@0003o0P00000:0?oo00h0gJfU00<0
00000=:W[03BYj`01@00000;0=6TZ@0300000037WJd0aif]0180aif]00<000000;jG[`2nUjl0202n
UjlZ000000X0ZXJ_00<0000009il[@2NO:d04@2NO:d00`000000T6jX091^Z00:091^Z0@000000P2@
L:/00`000000OEjT07eNY00907eNY0L0ool0100000001@3oo`0000000000003Tc;l0000000/0mMVa
0P0000000`3o0000nnB?0?_TS`030?_TS`030000003o0000o`0005<0oooo001[0?ooo`80o`0000<0
00000000S@0000000`0008T00`000000>DFc03U5/`030?l000L0?D>_0`000?l30000000306aY_P3o
o`00ool000X0ool02@3M[JD400000140dJBY00<000000<NM[@37WJd03@37WJd?000000X0_IB/00<0
00000;B=[@2dSJd04P2dSJd00`000000ZXB/0:Z4[0080:Z4[0l000003`2NO:d00`000000T6jX091^
Z00>091^Z0@000001`1mGZ@90?oo00D0003o0`0000000`3Tc;l000000?GI/@080?GI/@8000000`3o
00040?_TS`8000000P3o001C0?ooo`00J`3oool20?l000040000000008d0002=00000080002900<0
000003U5/`0iAK<00`3o0002000000D0?D>_1P00000506aY_P/0ool00P3M[JD4000000030=bYX@00
0000dJBY0180dJBY00<000000<NM[@37WJd00`37WJd:000000@0ai^Z00<000000;fD[02mU:`04P2m
U:`00`000000]8f]0;B=[@0B0;B=[@030000002ZQ:`0ZXB/0180ZXB/00<0000009ijZP2NNZX00P2N
NZX:000000@0WWb]00<00000091^Z02@KZP04@2@KZP010000000OUbQ0000000000070?oo00`0003o
0P0000020>C<_`030000003efK40mMVa00D0mMVa0P0000020?CN]@<0o`000P3ki8l400000080o`00
D`3oool006X0oooo00D000000?l0003o0000o`00000000020000S@050000000008T000290000000i
AK<00`3o000203U5/`8000000`0m@jl00`000000K6Vn06aY_P0;06aY_Pl0ool000<0g:VQ0000003A
Y:T03`3AY:T8000000h0ai^Z00<000000;fD[02mU:`04P2mU:`00`000000]8f]0;B=[@0B0;B=[@03
0000002ZQ:`0ZXB/0180ZXB/00<0000009ijZP2NNZX0302NNZX700000100T6jX00<0000007iLX@3o
o`001P3oo`0?0000o`<0i<bo00<000000?GI/@3efK400`3efK43000000@0m=je00D000000?l0003o
0000nnB?000000020?WYTP040000003o0000o`000?l005<0oooo001Z0?ooo`050000003o0000o`00
0?l0000000000`0008d01000000000290000000iAK<30?l000@0>DFc0P0000000`0m@jl0000006aY
_P0@06aY_P030000003oo`00ool00140ool00`3AY:T600000080dJ6U00<000000<NKZP37VjX04P37
VjX00`000000_IB/0;fD[00A0;fD[0030000002dSJd0]8f]0180]8f]00<000000:Z4[02ZQ:`04@2Z
Q:`00`000000WWZZ09ijZP0A09ijZP030000002AK:D0TFbU00@000001P2@KZP?0?oo00X0003o0P3T
c;l00`000000i<bo0>C<_`030>C<_`040000003efK40mMVa0?GI/@8000001`3dg[D30?l000040000
003ijI80nNVB0?WYTP<00000E03oool006X0oooo00D000000?l0003o0000o`00000000040000S@80
000000@0>DFc0?l0003o0000o`001P0iAK<300000140K6Vn00<0000008R0a028P<@0603oo`030=6Q
Y@0300000037VjX0ai^Z0180ai^Z00<000000;fD[02mU:`0202mU:`S000000l0ZXB/00<0000009ij
ZP2NNZX04@2NNZX010000000TFbU095/Y@2AK:D=0?oo00@00?l00`3oo`070000o`l0i<bo00@00000
0?GI/@00000000002@3dg[D30?l000<0nNVB1000001D0?ooo`00J`3oool4000000D0002=0P000003
0?l000L0>DFc00<0000006U/`P0000000`00000=06aY_P0300000028P<@0R83400L0R8341P3oo`03
003o00@0003o203oo`0A0<NKZPh000002@2mTZT00`000000]8ZZ0;B:ZP0B0;B:ZP030000002ZPZT0
ZX:Y0080ZX:Y2P0000050:Z4[0030000002NNZX0WWZZ00/0WWZZ5`3oo`07003o00040000o`3E_lD0
eKo500000140i<bo0`00000:0?CN]@8000000P3o00030?WYTP<00000E@3oool006/0oooo0P000000
0`3oool00000000000040000S@030000000eAkL0o`000080o`001`0iAK<00`000000JFc206U/`P03
06U/`P@000002@1/JKh00`000000R83408R0a00;08R0a0D00?l010000?l20?oo00D0003o2@3oo`03
0<NKZPH000000`36V:L00`000000_I:Y0;fBZ@0A0;fBZ@030000002dRZX0]8ZZ0180]8ZZ00<00000
0:Z2Z@2ZPZT0302ZPZT8000001h0ool0103E_lD9003o00030=Foa@000000i<bo00`0i<bo10000000
0`3Td<<000000?CN]@080?CN]@80000000@0m>>i0?l0003o0000o`000P3ijI84000005D0oooo001/
0?ooo`030000003oool0oooo008000000`0008d00`000000=DNg0?l000020?l000030000000iAK<0
>DFc00@0>DFc00<0000006U/`P1YK<801`1YK<84000000D0K6Vn00<0000008R0a028P<@02@28P<@7
003o0180003o103oo`000`000000ool00?oo000A0?oo00X0_I:Y00<000000;B:ZP2dRZX04@2dRZX0
0`000000ZX:Y0:Z2Z@0;0:Z2ZA`0ool01P00000:0=Foa@<0o`002@00o`080>C<_`@000001@3Td<<0
0`000000m=je0?CN]@050?CN]@8000000`3dhkT30?l000040?WYTP000000mNfE000005L0oooo001/
0?ooo`050000003oool0oooo0000000008l00P0000000`0008d0000003E7]`030?l0000303E7]`00
0000000000D0>DFc00<0000006U/`P1YK<802P1YK<840000000306aY_P000000R83400L0R8342000
o`020?l000@0R83400<000000000o`000?l040000?l2000004@0ool00P00000<0?oo00@000001P37
/lL00`000000eKo50=Foa@0:0=Foa@<0o`000`3E_lD9003o00030>C<_`0000000000008000002@3T
d<<00`000000m=je0?CN]@030?CN]@8000001@3dhkT30?l000040000003ekID00000000005L0oooo
001_0?ooo`070000000008l0002?0000S`000000002=000000030?l000<0=DNg0P00000303U5/`03
0000001YK<80JFc200h0JFc21000000408R0a0P00?l000@0R8340?l0003o0000o`001028P<@00`00
0000W93709b@a`0409b@a``0003o100000040?oo00l000004P3oo`03003o01`0003o0`00000C0<Nc
a`030000003E_lD0eKo500X0eKo50`3o00050=Foa@X00?l000<000000>C@``3Td<<0203Td<<01000
0000m=je0?CN]@3dg[D2000000H0m>>i00@000000?l0003o0000o`000P3ekID2000005L0oooo001`
0?ooo`040000000008l0002?0000S`8000000`3o000503E7]`80000000<0>DFc0000001YK<80401Y
K<800`000000Qh?800000002000000P00?l00`28P<@30?l000D0R83400<0000009b@a`2LT<L02P2L
T<L50000o`030000g@0000000000008000000`2LT<L00`000000[9g80:bMb00<0:bMb0h0ool01000
0003003o01`0003o1@00000A0<Nca`030000003E_lD0eKo500X0eKo50`3o00050=Foa@<000001`00
o`02000000T0i=3300@000000?CN]@0000000000203dhkT010000000o`000?l0003o00020?G]U@03
0000003oool0oooo05H0oooo001`0?ooo`030000000008l0002?0080002?00@000000?l0003o0000
o`001`0eAkL300000100JFc20P0000000`00H`000?l0003o0005003o00D0000000@0R8340?l0003o
0000o`001@28P<@00`000000W93709b@a`0=09b@a`@000001P2LT<L00`000000[9g80:bMb00J0:bM
b0040000002jZ<P0^ZS80;ZXb0<00?l070000?l2000001<0ak?700<000000=Foa@3E_lD02`3E_lD3
0?l000D000000P3E`/P010000000i=330>C@``3Td<<4003o00<000001`3Td<<3000000X0m>>i0`3o
00030?G]U@030000003oool0oooo05H0oooo001`0?ooo`8000000`0008l010000000o`000?l0003o
000803E7]`030000001WK/H0000000<00000301YK<800`00000006<000000005003o00L0Qh?800@0
00000?l0003o0000o`000P00000308R0a0030000002LT<L0W93701L0W93700<000000:bMb02/WLP0
6P2/WLP010000000^ZS80;ZXb02jZ<P3003o01H0^ZS800<000000<Nca`37/lL06037/lL00`000000
eKo50=Foa@070=Foa@@000000`3o00070=G2b0030000003Td<<0i=3300<0i=331P0000020>C@``@0
000000<0i=C60000003dhkT02@3dhkT010000000o`000?l0003o00020?G]U@800000F03oool00700
oooo00<000000000T@0000000`0008l01@000000o`000?l0003o0000000000H0=DNg00<0000006M^
aP1WK/H00`1WK/H4000000P0JFc20`000003003o00X0Qh?80`3o000208N3b0P000005@2LT<L00`00
0000[9g80:bMb00J0:bMb0040000002jZ<P0^ZS80;ZXb0<00?l05P2jZ<P00`000000ak?70<Nca`0H
0<Nca`040000003E_lD0eKo50=Foa@H00000103E`/P30?l000L0eL;800<000000>C@``3Td<<0103T
d<<7000000D0i=C600<000000?CS^@3dhkT01P3dhkT2000000050??W_@3o0000o`000?l0003ekID0
0P00001I0?ooo`00L03oool00`000000002A0000T@02000000030000S`000000o`000080o`0000<0
<4Vk000000000000100eAkL00`000000Ifk606M^aP0706M^aP@000000`1YK<84000000d0Qh?80`3o
000508N3b0030000002KTlX0Vi?:0080Vi?:2000000=09b@a`030000002/WLP0[9g801X0[9g800D0
00000;ZXb02jZ<P0^ZS80?l00003003o01D0^ZS800<000000<Nca`37/lL04P37/lL:000000X0eL;8
0`3o00070=G2b0030000003Td<<0i=3300<0i=33100000090>CDaP030000003dhkT0m>>i00@0m>>i
0P0000030??W_@<0o`0000<000000?3`U`000000F@3oool00740oooo00@000000000T@000940002A
0P0000030?l000<0<4Vk0P00000303E7]`030000001WK/H0Ifk600X0Ifk6100000000`1YK<800000
08N3b00=08N3b0<0o`001@27PlP00`000000Vi?:09^CbP0:09^CbPT00000102LT<L00`000000[9g8
0:bMb00J0:bMb0050000002jZ<P0^ZS80;ZXb03o00000`00o`0E0;ZXb00300000037/lL0ak?700@0
ak?73P0000060<NfbP030000003E`/P0eL;800/0eL;80`3o00070=G2b0030000003Td<<0000000<0
0000303Te<H00`000000m>>i0?CS^@030?CS^@800000103cikd010000000o`000?l0003o00020?3`
U`030000003oool0oooo05L0oooo001a0?ooo`03000000000940002A0080002A00@000000?l0003o
0000o`001@0`BK/20000000303E7]`000000Ifk600l0Ifk61000000<08N3b0<0o`001@27PlP00`00
0000Vi?:09^CbP0C09^CbQ<000003P2/WLP01@000000^ZS80;ZXb02jZ<P0o`0000<00?l01`2jZ<PE
000001@0akK:00<000000=G2b03E`/P02`3E`/P30?l000D0eL;81000000@0>CDaP040000003dhkT0
m>>i0?CS^@8000001P3cikd01P000000o`000?l0003o0000l?2G000005X0oooo001a0?ooo`030000
00000940002A00<0002A0`3o00070319^`<00000401WK/H00`000000QHG;08F5b`06000000H0Qh?8
0`3o000508N3b0030000002KTlX0Vi?:01L0Vi?:00<000000:^Pb`2[X</0302[X</C000000<00?l0
1`00000>0;V[b`0300000037]/X0akK:01P0akK:00<000000=G2b03E`/P02`3E`/P30?l000D00000
0P3Da/`00`000000i=C60>CDaP0?0>CDaP040000003dhkT00000000000P0lnNm00@000000?l0003o
0000o`000P00001J0?ooo`00L@3oool2000000@0002A0`3o00080319^`030000001TL<X000000080
00003@1WK/H00`000000QHG;08F5b`0608F5b`H000000`3o000508N3b0030000002KTlX0Vi?:01L0
Vi?:00<000000:^Pb`2[X</06P2[X</010000000^J_;0;V[b`2iZl/4000001D0^J_;00<000000<Nf
bP37]/X06037]/X00`000000eL;80=G2b0070=G2b0@000000`3o00070=C6c0030000003Te<H0i=C6
00h0i=C60`0000090??W_@8000000`3o0002000005X0oooo001b0?ooo`8000000P00094010000000
o`000?l0003o0002000000H0<4Vk00<0000006A`bP1TL<X00P1TL<X3000000X0Ifk600<0000008F5
b`25QL/03025QL/30?l000<000000P27PlP00`000000Vi?:09^CbP0G09^CbP030000002[X</0Zj3;
01X0Zj3;00D000000;V[b`2iZl/0^J_;0?l00003000001D0^J_;00<000000<NfbP37]/X06037]/X0
10000000eL;80=G2b03E`/P6000000@0e<K<0`3o00070=C6c0030000003Te<H0i=C600X0i=C61000
00000`3Tf<X000000??W_@070??W_@80000000<0lNc10000003o00000P3o00000`000000oooo0?oo
o`1I0?ooo`00LP3oool01@000000002C000000000940000000<0o`000P0/Bkl00`000000<4Vk0319
^`030319^`030000001TL<X0I73:00D0I73:0`00000706M^aP0300000025QL/0QHG;00`0QHG;0`3o
000308F5b`L000005P2KTlX00`000000Zj3;0:^Pb`0I0:^Pb`040000002iZl/0^J_;0;V[b`<0o`00
5P2iZl/00`000000akK:0<NfbP0D0<NfbPP000002P3Da/`30?l000H0e<K<00<000000>CDaP3Te<H0
1`3Te<H4000000@0i=S:00<000000??W_@3cikd01@3cikd200000080lNc100<000000?3`U`000000
0`00001K0?ooo`00L`3oool010000000002C000000000943000000<0;4^o0P0000040319^`030000
001TL<X0I73:00L0I73:0`00000406M^aP0300000025QL/0QHG;00`0QHG;0`3o000508F5b`030000
002JULh0VYG>0080VYG>2@00000=09^CbP030000002[X</0Zj3;01T0Zj3;00@000000;V[b`2iZl/0
^J_;0`3o000F0;V[b`0300000037]/X0akK:00/0akK:2@0000040<JicP030000003Da/`0e<K<00/0
e<K<0`3o00060=C6c0030000003Te<H0i=C600<0i=C6100000080>CHbP030000003cikd0lnNm0080
lnNm0`0000040?7/`@030000003`l9L0000000<00000F`3oool007<0oooo00<000000000T`0009<0
0`00000602a;_`8000000P0`BK/00`000000I73:06A`bP0:06A`bP<0000000<0Ifk600000025QL/0
3@25QL/30?l000D0QHG;00<0000009ZEcP2JULh02`2JULh9000000@0Vi?:00<000000:^Pb`2[X</0
6@2[X</010000000^J_;0;V[b`2iZl/30?l001H0^J_;00<000000<NfbP37]/X00P37]/X9000000d0
a[W>00<000000=C6c03Da/`02`3Da/`30?l000H0e<K<00<000000>CDaP0000000`00000<0>CHbP03
0000003cikd0lnNm008000001`3ak<42000000030>WbV@000000000005`0oooo001d0?ooo`030000
000009<0002C00800000200/Bkl3000000l0I73:1000000<08F5b`<0o`001@25QL/00`000000VYG>
09ZEcP0D09ZEcQ8000003P2[X</010000000^J_;0;V[b`2iZl/30?l000P0^J_;4`00000F0<JicP03
0000003Da/`0e<K<00/0e<K<0`3o00040=C6c0@000003`3Tf<X010000000lnNm0000000000080?7/
`@8000000P3YlYT2000005`0oooo001d0?ooo`8000000P0009<2000000T0;4^o0P00000?06A`bP03
00000024Qll0Q8O?00H000001P25QL/30?l000H0QHG;00<0000009ZEcP2JULh05`2JULh00`000000
Zj;>0:^RcP0;0:^RcQ8000000`3o0008000000h0^Jk>00<000000<JicP36^Lh05`36^Lh00`000000
e<K<0=C6c00<0=C6c0<0o`00100000020=C9c`030000003Tf<X0i=S:00d0i=S:0`0000090?7/`@80
00000`3YlYT2000005`0oooo001e0?ooo`80000000<0002C0000000VC<<00P00000702a;_`030000
001RL/h0000000<00000301TL<X00`000000Q8O?08B7c`0508B7c`H000000`3o000608F5b`030000
002JULh0VYG>01L0VYG>00<000000:^RcP2[X/h06@2[X/h010000000^Jk>0;V^cP2i[/h30?l001H0
^Jk>00<000000<JicP36^Lh05`36^Lh00`000000e<K<0=C6c0070=C6c0D000000`3o00060=C9c`03
0000003Tf<X0i=S:00T0i=S:100000000`3Sg<h000000?7/`@070?7/`@80000000@0ko350000003Y
lYT0jO:I0P00001M0?ooo`00M@3oool01@000000002C0000000009<0000000809Tc30P00000602a;
_`030000001RL/h0HW;>0080HW;>1000000806A`bP0300000024Qll0Q8O?00/0Q8O?00@000000?l0
003o0000o`000P00000308F5b`030000002JULh0VYG>01L0VYG>00<000000:^RcP2[X/h06@2[X/h0
10000000^Jk>0;V^cP2i[/h30?l001H0^Jk>00<000000<JicP36^Lh05`36^Lh010000000e<K<0=C6
c03Da/`6000000@0e<W?0`3o00060=C9c`030000003Tf<X0i=S:00L0i=S:0`0000050>?LcP030000
003ak<40lNc100@0lNc10P0000020>o`a@060000003YlYT0jO:I0000003RliX00000G@3oool007D0
oooo00D000000000T`000000002C0000000402I<``800000100/Bkl00`000000HW;>069bcP06069b
cP@00000101TL<X00`000000Q8O?08B7c`0<08B7c`<0o`000P24Qll:000001<0VYG>00<000000:^R
cP2[X/h06@2[X/h010000000^Jk>0;V^cP2i[/h30?l001H0^Jk>00<000000<JicP36^Lh04`36^Lh8
000000X0e<W?0`3o00060=C9c`030000003Tf<X0i=S:00<0i=S:100000070>?LcP030000003ak<40
lNc100<0lNc10P0000040>o`a@030000003YlYT000000080h_>J00<000000?ooo`3oool0F`3oool0
07H0oooo00@000000000T`00000000001P0VC<<200000080;4^o00<00000069bcP1RL/h02P1RL/h4
0000000306A`bP000000Q8O?00`0Q8O?0`3o000508B7c`030000002IV=40VISA00@0VISA3@000006
09ZEcP030000002[X/h0Zj;>01T0Zj;>00@000000;V^cP2i[/h0^Jk>0`3o000F0;V^cP0300000036
^Lh0a[W>00/0a[W>200000040<Jld@030000003DbLl0e<W?00/0e<W?0`3o00060=C9c`030000003T
f<X0000000<000002`3Sg<h010000000lNc10?7/`@3ak<42000000H0ko350P0000020>;cVP030000
003oool0oooo05`0oooo001f0?ooo`030000000009<0002C008000001`0VC<<20000000302a;_`00
0000HW;>00h0HW;>1000000;08B7c`<0o`001@24Qll00`000000VISA09VHd@0A09VHdA@000003P2[
X/h010000000^Jk>0;V^cP2i[/h30?l001H0^Jk>00<000000<JicP36^Lh00P36^Lh9000000`0a[cA
00<000000=C9c`3DbLl02`3DbLl30?l000@0e<W?1000000?0>?LcP040000003ak<400000000000L0
ko350P0000030>;cVP030000003oool0oooo05`0oooo001g0?ooo`030000000009<0002C00800000
200VC<<3000000l0HW;>00<0000008::dP22R]801P00000508B7c`<0o`001@24Qll00`000000VISA
09VHd@0G09VHd@030000002ZYM80ZZGB00/0ZZGB4P0000030?l001/000005@36_=400`000000e<W?
0=C9c`0;0=C9c`<0o`00100000020=C=d`030000003Sg<h0hmc>00d0hmc>0`0000080>o`a@800000
0`3RliX00`000000oooo0?ooo`1M0?ooo`00M`3oool200000080002C0`00000702I<``030000001N
MM40000000<000002`1RL/h00`000000PX[B08::dP0608::dPD000000`3o000508B7c`030000002I
V=40VISA01L0VISA00<000000:ZUdP2ZYM806@2ZYM8010000000^;3B0;R`dP2h/=830?l001H0^;3B
00<000000<Jld@36_=405`36_=400`000000e<W?0=C9c`060=C9c`D000000`3o00000`000000e<gC
0=C=d`030=C=d`030000003Sg<h0hmc>00X0hmc>0`0000000`3Rh=8000000>o`a@060>o`a@<00000
0`3RliX2000005l0oooo001h0?ooo`@000000P0PC/H2000000H09Tc300<0000005ied@1NMM400P1N
MM43000000P0HW;>00<0000008::dP22R]802P22R]8010000000o`000?l0003o000300000080Q8O?
00<0000009VHd@2IV=405`2IV=400`000000ZZGB0:ZUdP0I0:ZUdP040000002h/=80^;3B0;R`dP<0
o`005P2h/=800`000000a[cA0<Jld@0G0<Jld@030000003DbLl0e<W?00H000001@3DcM<30?l00003
0000003DcM<0e<gC00<0e<gC00<000000>?LcP3Sg<h01`3Sg<h3000000<0h^3B00<000000>o`a@3_
l<D0103_l<D200000080kOC800<000000>;cVP3RliX00P00001P0?ooo`00N03oool00`000000002C
0000T`02000000<084k60P00000402I<``030000001NMM40GWGA00D0GWGA10000005069bcP030000
0022R]80PX[B00T0PX[B00@000000?l0003o0000o`000`22R]87000001D0VISA00<000000:ZUdP2Z
YM806@2ZYM8010000000^;3B0;R`dP2h/=830?l001D0^;3B00<000000<Jld@36_=405036_=470000
00/0e<gC0`0000050=C=d`030000003Sg<h0hmc>00D0hmc>0`0000060>;PdP030000003_l<D0ko35
0080ko350P0000030>gdb0060000003RliX000000000003IliX00000H03oool007T0oooo00@00000
0000T`0009<000001@0PC/H2000000809Tc300<0000005ied@1NMM402@1NMM4400000003069bcP00
0000PX[B00/0PX[B0`00000508::dP030000002HV]@0V9[D0080V9[D2000000=09VHd@030000002Z
YM80ZZGB01T0ZZGB00@000000;R`dP2h/=80^;3B0`3o000E0;R`dP0300000036_=40a[cA00/0a[cA
2@0000040<Foe0030000003DcM<0e<gC00`0e<gC0P0000050=C=d`030000003Sg<h0hmc>0080hmc>
0`0000090>;PdP030000003_l<D0ko35008000001@3]m<P200000080fO>J00<000000?ooo`3oool0
G`3oool007T0oooo0P0000020000T`030000000PC/H084k600@084k60P0000000`0VC<<0000005ie
d@0=05ied@@000002P22R]82000000H0PX[B00<0000009RJe02HV]@02P2HV]@9000000@0VISA00<0
00000:ZUdP2ZYM806@2ZYM8010000000^;3B0;R`dP2h/=830?l001D0^;3B00<000000<Jld@36_=40
0P36_=49000000d0aKoD00<000000=C=d`3DcM<0303DcM<00`000000e<gC0=C=d`040=C=d`030000
003Sg<h00000008000002`3Rh=8010000000ko350000000000060>gdb08000000`3IliX00`000000
oooo0?ooo`1O0?ooo`00NP3oool2000000040000T`0000000000000000H084k60`00000>05ied@03
00000020S=H0P8cF00H000001@22R]800`000000PX[B08::dP0408::dP030000002HV]@0V9[D01<0
V9[D4P00000>0:ZUdP040000002h/=80^;3B0;R`dP<0o`0000<000000;R`dP2h/=801@2h/=8B0000
01H0aKoD00<000000=C=d`3DcM<0303DcM<00`000000e<gC0=C=d`020=C=d`@000003@3Rh=830000
00P0kOC800D000000=WcVP3IliX0fO>J00000002003o0600oooo001i0?ooo`07003o00000000002B
0000000009<0000001U?b@02000000D084k600<0000005]ge@0000000`00000:05ied@0300000020
S=H0P8cF00H0P8cF1P00000708::dP030000002HV]@0V9[D01H0V9[D00<000000:VWe@2YYmD02`2Y
YmDB000000<0o`002000000=0;Nce@0300000035_m@0aKoD01L0aKoD00<000000=C=d`3DcM<0303D
cM<600000080dm3F00<000000>;PdP3Rh=80203Rh=84000000030>7TeP000000kOC800H0kOC80`00
00020=WcVP8000001000o`1N0?ooo`00M`3oool4003o0080000000<0002C0000000IClT00P0IClT2
000000@084k600<0000005]ge@1KMmD00P1KMmD3000000L0GWGA00<00000082<eP20S=H02`20S=H6
00000080PX[B00<0000009RJe02HV]@05P2HV]@00`000000ZJOE0:VWe@0I0:VWe@040000002g/mD0
]k?E000000<0o`0000<000000;Nce@2g/mD04P2g/mD00`000000aKoD0<Foe00G0<Foe0030000003D
cM<0e<gC00H0e<gC1P0000070=?@eP030000003Rh=80h^3B00H0h^3B0`0000040>7TeP030000003]
m<P0kOC800@0kOC80P0000000`3Yn</000000=WcVP03000000030?ooo`00o`000?l000@00?l0G03o
ool007D0oooo1P00o`0010000000002B00000000000501U?b@8000000P0PC/H00`000000FgOE05]g
e@0505]ge@<000001@1NMM400`000000P8cF082<eP0@082<ePL00000502HV]@00`000000ZJOE0:VW
e@0I0:VWe@070000002g/mD0]k?E0;Nce@000000Z@000000000E0;Nce@0300000035_m@0aKoD01L0
aKoD00<000000=C=d`3DcM<01P00000=0=?@eP030000003Rh=80h^3B0080h^3B100000070>7TeP03
0000003]m<P0kOC80080kOC80P0000030>Whb`8000000P3>lYT00`000000oooo0?ooo`06003o05/0
oooo001c0?ooo`L00?l00P3oool010000000002B00000000000601U?b@80000000<084k60000001K
MmD0201KMmD40000000305ied@000000P8cF01<0P8cF00<0000009JMf02FWMP00P2FWMP8000000d0
V9[D00<000000:VWe@2YYmD0602YYmD010000000]k?E0;Nce@2g/mD3000001D0]k?E00<000000<Fo
e035_m@04@35_m@900000180dm3F00<000000>;PdP0000000`00000;0>7TeP030000003]m<P0kOC8
00800000103Yn</200000080c_:I00<000000?ooo`3oool00`3oool6003o05T0oooo001b0?ooo`H0
0?l01@3oool00`000000002B0000000801U?b@<00000301KMmD400000180P8cF00<0000009JMf02F
WMP02P2FWMP9000000@0V9[D00<000000:VWe@2YYmD0602YYmD00`000000]k?E0;Nce@020;Nce@03
0000002g/mD0]k?E01@0]k?E00<000000<Foe035_m@01035_m@=000000H0aL;H00<000000=?@eP3C
d=H0403Cd=H4000000h0hNCF00@000000>gdb000000000001P3Yn</010000000c_:I0<kbV@000008
0?ooo`H00?l0E`3oool00700oooo1P00o`070?ooo`80000000<0002B0000000000001`0IClT00`00
0000EWWI00000002000000X0FgOE00<0000007f?fP1mSmX01P00000<082<eP030000002FWMP0UYgH
01<0UYgH4P00000=0:VWe@030000002g/mD0]k?E0080]k?E00<000000;Nce@2g/mD01`2g/mDD0000
01<0aL;H00<000000=?@eP3Cd=H0303Cd=H400000080d]CJ00<000000>7TeP3Qi=H0303Qi=H30000
00H0jOS;0P0000020<kbV@030000003oool0oooo00P0oooo1`00o`1E0?ooo`00KP3oool6003o00X0
oooo0`0000000`0AD</000000000000601U?b@040000001FNMT0EWWI05Iif@<00000201KMmD00`00
0000OHoJ07f?fP0507f?fPD000002020S=H00`000000UYgH09JMf00F09JMf0030000002XZ]P0Z:[H
00/0Z:[H7000000=0;Nff00300000035`]P0aL;H01H0aL;H00<000000=?@eP3Cd=H02@3Cd=H40000
00D0d]CJ00<000000>7TeP3Qi=H02@3Qi=H4000000030=oXfP000000jOS;00@0jOS;0P0000000`3T
nlh000000<kbV@02000000`0oooo1P00o`1D0?ooo`00K03oool7003o00/0oooo00@000000000T000
000000000P0AD</2000000@06Do900<0000005Iif@1FNMT0101FNMT2000000H0FgOE00<0000007f?
fP1mSmX02P1mSmX600000080P8cF00<0000009JMf02FWMP05P2FWMP00`000000Z:[H0:RZf00H0:RZ
f0030000002g]]P0]kKH01T0]kKH00<000000<G2f035`]P05P35`]P00`000000dm3F0=?@eP040=?@
ePD000002@3Be=X00`000000hNCF0>7TeP060>7TeP<00000103Oj=X00`000000jOS;0>Whb`020>Wh
b`8000000P3Tnlh010000000c_:I00000000000?0?ooo`H00?l0DP3oool006/0oooo1P00o`0>0?oo
o`03000000000900000000@04E3;0P00000201U?b@030000001FNMT0EWWI00H0EWWI0`00000305]g
e@030000001mSmX0OHoJ0100OHoJ1`00000D09JMf0030000002XZ]P0Z:[H01P0Z:[H00<000000;Nf
f02g]]P0602g]]P00`000000aL;H0<G2f00G0<G2f0030000003Cd=H0dm3F00@000003P3Be=X00`00
0000hNCF0>7TeP020>7TeP@000001`3Oj=X00`000000jOS;0>Whb`02000000@0i?_>0`00000B0?oo
o`H00?l0D03oool006T0oooo1P00o`0A0?ooo`03000000000900000000D04E3;0P0000000`0IClT0
000005Iif@0905Iif@<0000000<0FgOE0000001mSmX04P1mSmX00`000000UIoK09FOf`0209FOf`P0
0000302FWMP00`000000Z:[H0:RZf00H0:RZf0030000002g]]P0]kKH01P0]kKH00<000000<G2f035
`]P04@35`]P900000140d]CJ00<000000>7TeP0000000`00000:0=oXfP040000003Yn</000000000
00D0i?_>0`00000D0?ooo`D00?l000<000000?ooo`3oool0C@3oool006L0oooo1P00o`0D0?ooo`04
0000000009000000000000D04E3;0`00000<05Iif@@000004P1mSmX00`000000UIoK09FOf`0909FO
f`P00000102FWMP00`000000Z:[H0:RZf00H0:RZf0030000002g]]P0]kKH01P0]kKH00<000000<G2
f035`]P01035`]P=000000H0a<KK00<000000=;DfP3Be=X03`3Be=X4000000d0gnSJ0`0000070>Ck
cP0300000032kiP0000001H0oooo0`00o`03000004d0oooo001V0?ooo`0300000000o`000?l000<0
0?l05@3oool6000000D04E3;1@00000905Iif@030000001kTMh0Ni7N00H00000301mSmX00`000000
UIoK09FOf`0A09FOfa8000003@2XZ]P00`000000]kKH0;Nff00;0;Nff1@000004`34a]/00`000000
d]CJ0=;DfP0:0=;DfPD000000P3Aemh00`000000gnSJ0=oXfP090=oXfP@000001`3Tnlh200000003
0<;_V0000000oooo01T0oooo1000001<0?ooo`00I@3oool2000000<00?l0603oool00`000000002=
0000000200UAc@8000000`0AD</00`000000DW_M059kg@02059kg@<000001`1FNMT00`000000Ni7N
07^AgP0507^AgPD000001`1mSmX00`000000UIoK09FOf`0E09FOf`030000002V[M`0YZgL00/0YZgL
6`00000=0;Jig00300000034a]/0a<KK01H0a<KK00<000000=;DfP3Be=X01@3Be=X6000000H0dMON
00<000000=oXfP3Oj=X01`3Oj=X3000000<0g>cM00<000000>CkcP3Tnlh00`3Tnlh0100000000?l0
003o0000o`02000006X0oooo001T0?ooo`<00000703oool00`000000002=0000000300UAc@800000
0P0AD</00`000000DW_M059kg@04059kg@<00000101FNMT00`000000Ni7N07^AgP0:07^AgPH00000
0P1mSmX00`000000UIoK09FOf`0D09FOf`030000002V[M`0YZgL01P0YZgL00<000000;Jig02f^M`0
602f^M`00`000000a<KK0<C6f`0F0<C6f`030000003Be=X0d]CJ00D00000303Aemh00`000000gnSJ
0=oXfP040=oXfP<000001@3Lk=d00`000000i?_>0>CkcP020>CkcP8000001@00o`1[0?ooo`00Q03o
ool00`000000002=00000003003o000400UAc@0000000000000000T0DW_M100000000`1FNMT00000
07^AgP0@07^AgPH000004`2EWm/00`000000YZgL0:J]g00H0:J]g0030000002f^M`0][WL01P0][WL
00<000000<C6f`34a]/04P34a]/700000140dMON00@000000=oXfP3Oj=X0gnSJ0`0000080=c/g@03
0000003Tnlh0i?_>008000000P3No]06003o06X0oooo00250?ooo`0300000000o`000?l000800?l0
0`09DLd3000000/0DW_M1000000A07^AgP040000002CX]l0Tj;O09>Rg`P00000302EWm/00`000000
YZgL0:J]g00G0:J]g0030000002f^M`0][WL01P0][WL00<000000<C6f`34a]/02P34a]/8000000@0
`lWO00<000000=7GgP3Aemh0403Aemh00`000000gnSJ00000002000000X0g>cM00@000000>CkcP00
000000001@3No]02000000D00?l0J03oool008D0oooo1@00o`000`0000002E7=00UAc@0200UAc@@0
00002@1BNmd00`000000MiCR07NDhP05000000`0Ni7N00<0000009>Rg`2CX]l02@2CX]l8000000@0
UIoK00<000000:J]g02V[M`05`2V[M`00`000000][WL0;Jig00H0;Jig00300000034a]/0a<KK0080
a<KK2000000;0<?9g`030000003Aemh0dMON00l0dMON1000000<0=c/g@<000001@3No]0400000003
0?ooo`00o`000?l000<00?l0I`3oool008<0oooo1@00o`000`000000057>001AcP02000000802E7=
00@0000004amh01<ON00C7gP0`000007059kg@030000001gU>80MiCR00@0MiCR1P00000707^AgP03
0000002CX]l0Tj;O0100Tj;O4@00000=0:J]g0030000002f^M`0][WL00/0][WL4P00000C0<?9g`03
0000003Aemh0dMON00X0dMON1@0000020<oKhP030000003Lk=d0g>cM00L0g>cM1@0000050=knd0D0
00000`3oool5003o06H0oooo00220?ooo`D00?l00P000004001AcP80000000<02E7=0000001<ON00
101<ON04000000<0DW_M00<0000007NDhP1gU>802P1gU>8500000080Ni7N00<0000009>Rg`2CX]l0
502CX]l00`000000YK3O0:F`g`0:0:F`ga/000003@2d_=l00`000000`lWO0<?9g`0E0<?9g`030000
003Aemh0dMON00@0dMON1P0000060<oKhP030000003Lk=d0g>cM00D0g>cM0`0000040=W`h@040000
003No]00g_k@0=knd08000000P3Gom42000000H0oooo1@00o`1T0?ooo`00P@3oool5003o0080oooo
0P000005001AcP8000002@1<ON0300000003059kg@000000MiCR00l0MiCR1P00000C09>Rg`030000
002U/=l0YK3O01L0YK3O00<000000;Blg`2d_=l0602d_=l00`000000`lWO0<?9g`0D0<?9g`030000
003Aemh0dMON00D00000303?fn800`000000g>cM0=c/g@020=c/g@<000001P3Il>400`000000g_k@
0=knd002000000<0eooA0P0000080?ooo`D00?l0H`3oool007l0oooo1@00o`050?ooo`<000001@00
DLh2000000X0C7gP1000000@07NDhP040000002@YN<0T:GS092Uh`P00000302CX]l00`000000YK3O
0:F`g`0F0:F`g`030000002d_=l0];cO01L0];cO00<000000<?9g`33bMl04033bMl800000100cm_R
00<000000=c/g@0000000`0000090=W`h@<000000`3Gom43000000X0oooo1@00o`1R0?ooo`00OP3o
ool5003o00L0oooo10000004001AcP@000002@1<ON000`000000M9KU00000004000000`0MiCR00<0
0000092Uh`2@YN<0202@YN<8000000@0Tj;O00<000000:F`g`2U/=l05P2U/=l00`000000];cO0;Bl
g`0G0;Blg`0300000033bMl0`lWO00@0`lWO300000050<7<h`030000003?fn80cm_R00h0cm_R1000
000;0=W`h@<000000`3Gom45000000`0oooo1@00o`1P0?ooo`00O@3oool5003o00T0oooo00<00000
001@cP00D<h00P000002001AcP0400000016On<0AWoS04Ioh`<000001P1<ON000`000000M9KU07BF
i@0407BFi@H000001P1gU>800`000000T:GS092Uh`0@092Uha400000302U/=l00`000000];cO0;Bl
g`0;0;Blga<000004@31c><00`000000cm_R0<oKhP090<oKhPD000000P3=gnH00`000000fO3Q0=W`
h@070=W`h@@000000`3Gom42000000040<god@0000000000000000h0oooo1@00o`1O0?ooo`00N`3o
ool5003o00`0oooo00@00000001@cP00D<h0053>0P0000000`00DLh0000004Ioh`0404Ioh`@00000
0`1<ON000`000000M9KU07BFi@0907BFi@D000000P1gU>800`000000T:GS092Uh`0C092Uh`030000
002S/^<0Xk;S00X0Xk;S6P00000<0;>oh`0300000031c><0`LcS01@0`LcS00<000000<oKhP3?fn80
1@3?fn85000000H0cMoV00<000000=W`h@3Il>401@3Il>4300000080eO?T00<000000=Ood@3Gom40
0P0000030<god@800000403oool5003o05h0oooo001j0?ooo`D00?l03P3oool00`000000053>001@
cP02001@cP8000002@16On<400000100M9KU1P00000B092Uh`030000002S/^<0Xk;S01H0Xk;S00<0
00000;>oh`2c_n<05`2c_n<00`000000`LcS0<7<h`0D0<7<h`030000003?fn80cm_R00D000002`3=
gnH010000000fO3Q0=W`h@3Il>44000000D0eO?T0`0000040<god@8000004`3oool5003o05`0oooo
001i0?ooo`D00?l0403oool2000000@0053>0P00000:04Ioh`@000003`1dU^D010000000SZOW08jW
i`2>YnL8000000/0T:GS00<000000:>bh`2S/^<05@2S/^<00`000000/koS0;>oh`0F0;>oh`030000
0031c><0`LcS0100`LcS200000070<gOiP<00?l01@3=gnH00`000000fO3Q00000002000000L0eO?T
0`0000040<god@<000005@3oool5003o05/0oooo001g0?ooo`D00?l04`3oool3000000<0053>1000
000804Ioh`030000001_VNT0KiWY00D00000101dU^D3003o00<0M9KU00<0000008jWi`2>YnL02@2>
YnL8000000<0T:GS00<000000:>bh`2S/^<05@2S/^<00`000000/koS0;>oh`0F0;>oh`0300000031
c><0`LcS00@0`LcS300000050;o@i`030000003=gnH0cMoV00L0cMoV0`00o`030<gOiP@000001`3E
ln@4000000@0cOoA1000000G0?ooo`D00?l0FP3oool007H0oooo1@00o`0E0?ooo`0600000000Cl`0
000000000000D<h000000`0nP>H3000000H0AWoS00<0000006nIj@1_VNT0101_VNT4000000<00?l0
101dU^D00`000000SZOW08jWi`0@08jWi`l00000302S/^<00`000000/koS0;>oh`0:0;>oha<00000
402od>L00`000000cMoV0<gOiP080<gOiP@00?l00P0000000`3:hnT000000=Gci0050=Gci0<00000
0`3@m^L00`000000cOoA0<god@02000000030<;nd0000000oooo01X0oooo1@00o`1H0?ooo`00M@3o
ool5003o01L0oooo00<00000001?c000Cl`00`00000503j0iP<000000`16On<00`000000KiWY06nI
j@0706nIj@@00?l00P00000207BFi@030000002>YnL0SZOW01<0SZOW00<000000:6fi`2Q]^L02@2Q
]^LI000000`0/L;W00<000000;o@i`2od>L0502od>L00`000000cMoV0<gOiP040<gOiPD000001000
o`000`3:hnT000000=Gci0020=Gci0@000001@3@m^L010000000cOoA0000000000020<;nd0030000
003oool0oooo01/0oooo0P00o`000`0000000?l00000001G0?ooo`00L`3oool5003o01X0oooo0P00
0002001?c0<000001P0nP>H30000000304Ioh`000000KiWY00L0KiWY0`00o`0306nIj@H000004P2>
YnL00`000000XKKW0:6fi`0E0:6fi`030000002a`^L0/L;W01H0/L;W00<000000;o@i`2od>L04`2o
d>L00`000000cMoV0<gOiP05000000H0b^?Y0`00o`000`3:hnT000000=Gci002000000T0d?KW0P00
00020<;nd08000007`3oool01000000009H000000000001G0?ooo`00LP3oool00`0000000?l0003o
0002003o01`0oooo0`000002001?c0@000001P0nP>H4000000D0KiWY1000o`0506nIj@040000002;
Z^/0Rj[[08^Zj`P000002`2>YnL00`000000XKKW0:6fi`0D0:6fi`040000002a`^L0/L;W0;72i`<0
0?l04@2a`^L00`000000_m3W0;o@i`0?0;o@i`P000002`3:hnT4003o00030000003@m^L0d?KW00P0
d?KW0P0000020<;nd0<00000803oool5000005H0oooo001b0?ooo`0400000000o`000?l0003o01h0
oooo00H00000001>b00000000000001?c000000203J1j0<000001@0nP>H00`000000JY_]00000003
000000@00?l01`1_VNT00`000000Rj[[08^Zj`0808^Zj`P000000`2>YnL00`000000XKKW0:6fi`0E
0:6fi`030000002a`^L0/L;W00<00?l04@2a`^L00`000000_m3W0;o@i`030;o@i``00000102mdn/0
0`000000b^?Y0<[Sj@080<[Sj@D000001000o`060=3fi`D0000000<0`_k@0000000000000P00000S
0?ooo`<00000EP3oool00740oooo1@00000O0?ooo`0300000000C/P004k800<00000100fPNP30000
0080?X3V00<0000006ZKk@1ZVnd00`1ZVnd3003o008000001P1_VNT00`000000Rj[[08^Zj`0@08^Z
j`l00000302Q]^L00`000000/L;W0;72i`03003o00H0/L;W4@00000@0;gCj`030000003:hnT0b^?Y
00@0b^?Y100000060<OVk@<00?l00P3@m^L4000000<0bOWY0`0000000`2cnl`000000000000V0?oo
o`800000E@3oool00740oooo0`00000R0?ooo`8000000P00C/P3000000D0=X7X1000000306ZKk@@0
0?l00P1ZVnd500000080KiWY00<0000008^Zj`2;Z^/04P2;Z^/00`000000W[W[09jij`0909jij`l0
00000`00o`06000000/0[lK[00<000000;gCj`2mdn/04P2mdn/00`000000b^?Y0<[Sj@05000000T0
anK]00<00000003o0000o`000P00o`000`000000bOWY0<Wij@040<Wij@80000000@0/o_<00000000
00000000OP3oool00700oooo0P00000U0?ooo`<000000P00C/P4000000D0=X7X0`000004003o00P0
JY_]2000000?08^Zj`030000002N^N/0W[W[01D0W[W[00<000000:o6j`2_a^/00`00o`0A0:o6j`03
0000002mdn/0_M?[00d0_M?[2000000<0<OVk@@000001000o`040<Wij@8000000P2cnl`3000007l0
oooo002H0?ooo`0600000000Bl<0000000000000C/P000000P0/PNT2000000D0=X7X00@00000003o
0000o`000?l00P00000906ZKk@0300000027[Nh0Qjg^00<0Qjg^2`00000508^Zj`030000002N^N/0
W[W[01@0W[W[00<000000:o6j`2_a^/00`00o`0A0:o6j`030000002mdn/0_M?[00<0_M?[2P000004
0;[GkP0300000037i^d0anK]00P0anK]1@0000000`32jO0000000<Wij@020<Wij@<00?l01@000002
0;?kc0800000P@3oool009T0oooo00<00000001;``00Bl<00`00000302b1j@<000000P0fPNP4003o
0080I9g`1@00000506ZKk@0300000027[Nh0Qjg^00d0Qjg^4@00000;09jij`030000002_a^/0[lK[
00<00?l01P2_a^/A000000h0^]O^00<000000<OVk@37i^d01037i^d4000000D0`^W`00<000000<Wi
j@39nNT00P39nNT4003o0080`O[Z00D000000;?kc0000000XoC7000000220?ooo`00VP3oool20000
008004_30`00000402b1j@8000000`00o`0806BMl0@0000000<0JY_]00000027[Nh04`27[Nh00`00
0000Vkc_09^lk`0909^lk`h000000`00o`06000000/0[<W_00<000000;[GkP2jenh0402jenh00`00
0000anK]0<OVk@05000000T0`^W`00<000000<Wij@0000000P0000000`31n^X00?l0003o0002003o
00030<7jjP000000000000800000P`3oool009`0oooo0P000002001;``<000000`0/PNT4003o0080
00002P1TWO08000000h0Qjg^00<0000009^lk`2K_>l0502K_>l00`000000[<W_0:c9k`03003o0100
[<W_00<000000;[GkP2jenh03@2jenh7000000/0`^W`100000060<7jjP<00?l0100000240?ooo`00
WP3oool3000000808H7X0P000004003o000302b1j@000000GIoc00@00000201TWO000`000000P[3b
08:`lP0308:`lPX000001@27[Nh00`000000Vkc_09^lk`0C09^lk`030000002/bNl0[<W_00<00?l0
402/bNl00`000000^]O^0;[GkP030;[GkPX000000`2gf_800`000000`^W`0<;Yl0080<;Yl0@00000
00<0_>gc00000031n^X01@31n^X2000000@00?l000<0Snbo0000003oool0Q03oool009l0oooo0`00
00030261j0<00?l000<0000002b1j@0000001@1MWo<4000000D0I9g`00<0000008:`lP22/?803022
/?8@000000/0Vkc_00<000000:c9k`2/bNl00`00o`060:c9ka0000003@2gf_800`000000`^W`0<;Y
l0030<;Yl0D00000102lkO<00`000000`O[Z0<7jjP020<7jjP<000000P2fn^X00`0000000?l0003o
0002003o08H0oooo002Q0?ooo`<000001000o`00100QPNP0000000000000000805fOl`@0000000<0
I9g`00000022/?804P22/?800`000000V;oc09Rol`0809Rol`h000000`00o`06000000X0Z<cc00<0
00000;OJlP2gf_803`2gf_800`000000`^W`0<;Yl004000000T0_>gc00<000000<7jjP0000000P00
00030;KjjP80000000<0Snbo00000000o`000P00o`260?ooo`00X`3oool4003o00@08H7X10000009
05fOl`L000003P22/?800`000000V;oc09Rol`0C09Rol`030000002Xc?<0Z<cc00<00?l03`2Xc?<0
0`000000]m[b0;OJlP0<0;OJlPL000002P2lkO<4000000@0]_[Z1`000004003o08D0oooo002S0?oo
o`<00?l01@0000020261j0030000001DX?D0000000@000001`1MWo<010000000O;;f07bbmP1l/_H:
000000D0P[3b00<0000009Rol`2H_o<04P2H_o<00`000000Z<cc0:S<l`03003o00l0Z<cc00<00000
0;OJlP2gf_800P2gf_8:000000<0/]kf00<000000;c]l`2lkO<01@2lkO<6000000040;G_mP000000
]_[Z0;KjjP@0000000<0Z?SW0000000000000P0000030?ooo`@00?l0Q03oool00:80oooo1000o`03
000000804goU1000000505BPm@H0000000<0GIoc0000001l/_H0301l/_H@000000X0V;oc00<00000
0:S<l`2Xc?<00`00o`050:S<l`l000003@2bg_H00`000000_>gc00000005000000H0]Nof00@00000
0;KjjP00000000000`2Xn>L400000003003o003oool0oooo00<0oooo0`00o`000`000000oooo0?oo
o`210?ooo`00X@3oool00`0000000?l0003o0003003o00D000000P0COnD4000000P0E:3e1`00000=
07bbmP030000002C`_L0Tl;g00P0Tl;g3@000003003o00D000002P2Td?L00`000000/]kf0;;NmP0:
0;;NmPL000002@2ekoH4000000<0Z?SW1@000003003o00D0oooo0`00o`000`000000oooo0?ooo`21
0?ooo`00X@3oool00`0000000?l0003o0005003o0080000000<017_O0000000000000P0COnD00`00
0000BJ7f00000004000000H0E:3e00@0000007Jen@1f]OT0M[Gi2P00000407bbmP030000002C`_L0
Tl;g0140Tl;g00<000000:C@m`2Td?L00`00o`0>0:C@m`030000002bg_H0/]kf0080/]kf2@000003
0:cQn@030000002ekoH0]Nof00D0]Nof1@000000102[l?L000000:Shi`2Xn>L600000003003o003o
ool00?l000<00?l0103oool200000003001h0000000000000880oooo002Q0?ooo`@000001@00o`00
103oool0000000000004Nml4000000D0BJ7f1@0000000`1DX?D0000007Jen@0<07Jen@h000002P2C
`_L00`000000Y=3g0:C@m`03003o00D0Y=3g3P00000<0:cQn@030000002ekoH0]Nof00D000001@2[
l?L01@000000Z?SW000000000000Uo;R00<000000`00o`020?ooo`@00?l0103oool400000880oooo
002P0?ooo`@000001@00o`000`000000oooo0?ooo`09000000L0BJ7f1`00000<07Jen@030000002=
a?X0SLCj00L0SLCj3@000003003o00D00000202NdoX00`000000[>7i0:cQn@0:0:cQn@L00000202[
l?L40000000309ObhP0000000000008000000P3oool3003o00<0oooo0`00o`060?ooo`<00000P@3o
ool00:00oooo0`000006003o00D0oooo3000000504VQmP040000001]]_/0KKKk06ffn`T00000101f
]OT00`000000SLCj08g4nP0@08g4nP030000002NdoX0W]?j00<00?l03@2NdoX010000000[>7i0:cQ
n@2/hOT9000000<0Y>?l00<000000:_`m`2[l?L0102[l?L50000000309o_mP000000Uo;R00D00000
103oool2000000<0oooo1000o`070?ooo`030000003oool0oooo07l0oooo002P0?ooo`030000003o
ool00?l000800?l000<0oooo0000000000001`3oool2003o008000000P00M]H40000000303bOm000
0000000000<0000000<0BJ7f0000001]]_/02P1]]_/>000000T0SLCj00<0000009kCnP2NdoX00`00
o`0409kCnPd00000302Tho`00`000000Zo3g00000004000000@0Wnof1`000003003o00@0oooo00<0
00000?ooo`3oool00P3oool3003o08T0oooo002Q0?ooo`@00?l000<0oooo0000003oool01P3oool4
003o00070?ooo`000000000000000000M]H0000002fLl00400000080?9od1P00000;06ffn`030000
0025aod0QLOm00L0QLOm30000003003o00@00000202GeOd00`000000Y>?l0:CSo0090:CSo0L00000
1@2OkoH900000080oooo0`00o`090?ooo`@00?l0R03oool00:40oooo0`00o`0:0?ooo`<00?l0103o
ool4000000@0;Ic`10000000100lWo@0000006:go01R]o`8000000@0KKKk00<0000008G7o@25aod0
3`25aod00`000000UmGm09OEo@04000000X0UmGm00<000000:CSo02Tho`00P2Tho`8000000<0V^Cm
00<0000009o_mP2OkoH01P0000001@2>k?800000000000000000J]c=00800000103oool4003o00T0
oooo1000o`270?ooo`00X03oool4003o00T0oooo1000o`060?ooo`H00000100]W?06000000H0H[Ol
3@00000908G7o@030000002GeOd0UmGm00<000000`2GeOd=000000L0V^Cm1`00000308k/lPP00000
1`3oool3003o00X0oooo0`00o`270?ooo`00W`3oool4003o00X0oooo0`00o`0:0?ooo`T0000000@0
;Ic`000000000000E;Kk2000000306:go0030000001kb?l0NlSo00D0NlSo4P00000708kGo`030000
002Ji?d0V^Cm0080V^Cm20000000102<ho/000000000002>k?860000000307[Tj@00000000000080
00002P3oool4003o00T0oooo1000o`260?ooo`00W`3oool3003o00X0oooo1000o`0<0?ooo`h00000
1@1D]_/<000000P0NlSo00D0000008kGo`2>eol0S]Oo0000000408kGo``000001@2<ho/6000000<0
0?l000<0N^CY0000000000000`00000>0?ooo`<00?l02P3oool4003o08D0oooo002N0?ooo`@00?l0
2P3oool3003o0100oooo1@000004003o0080@k;f1`00000205Bfn`030000001_b?l0KlSo00D0KlSo
4@000006087Go`030000002<ho/0S>?k0080S>?k1P00000207_Om`040000001ji>T0N^CY000000<0
0?l00`00000A0?ooo`@00?l02P3oool3003o08D0oooo002N0?ooo`<00?l02`3oool3003o01@0oooo
00<00000003o0000o`000P00o`0700000080@k;f2`00000706o8o`0300000021eol0PMOo00D0PMOo
2`00000507_Om`P000000`00o`0E0?ooo`<00?l02P3oool4003o08@0oooo002L0?ooo`0300000000
o`000?l000800?l02P3oool4003o01D0oooo1000o`060000000302j[k0000000000001X000001P1a
e?`010000000Nmog07_Om`1kgoL<00000080oooo1000o`0D0?ooo`@00?l02@3oool0100000000?l0
003o0000o`240?ooo`00W03oool4003o00/0oooo0`00o`0F0?ooo`@00?l00P3oool:00000080;Z_/
00<0000004^om01;_o@00`1;_o@8000000<00?l05P0000070?ooo`<00?l05@3oool3003o00T0oooo
00@00000003o0000o`000?l0Q03oool009`0oooo0`00o`000`000000oooo0?ooo`080?ooo`@00?l0
5P3oool3003o00L0oooo5P000003003o018000002`3oool3003o01D0oooo1000o`090?ooo`@00000
P`3oool009/0oooo00@00000003o0000o`000?l02`3oool3003o01L0oooo0`00o`0>0?ooo`l00000
0`00o`0;00000180oooo0`00o`0F0?ooo`<00?l02P3oool3000008<0oooo002K0?ooo`<000002`3o
ool4003o01L0oooo0`00o`0K0?ooo`D00?l07@3oool4003o01D0oooo1000o`0;0?ooo`030000003o
ool0oooo0840oooo002K0?ooo`800000303oool3003o01L0oooo1000o`0K0?ooo`D00?l07P3oool3
003o01H0oooo0`00o`2?0?ooo`00V`3oool00`000000oooo0?ooo`0:0?ooo`@00?l05`3oool3003o
01`0oooo1@00o`0N0?ooo`<00?l05P3oool4003o08h0oooo002X0?ooo`<00?l0603oool3003o01`0
oooo1@00o`0N0?ooo`<00?l05`3oool3003o08h0oooo002W0?ooo`@00?l0603oool3003o01`0oooo
1@00o`0N0?ooo`@00?l05P3oool4003o08d0oooo002W0?ooo`<00?l0603oool4003o01`0oooo1@00
o`0O0?ooo`<00?l05`3oool3003o08d0oooo002W0?ooo`<00?l0603oool3003o01d0oooo1@00o`0O
0?ooo`<00?l05`3oool4003o08`0oooo002V0?ooo`@00?l0603oool3003o01d0oooo1@00o`0O0?oo
o`<00?l0603oool3003o08`0oooo002V0?ooo`<00?l06@3oool3003o01d0oooo1@00o`0O0?ooo`@0
0?l05`3oool3003o00030000003oool0oooo08T0oooo002T0?ooo`0300000000o`000?l000800?l0
603oool4003o01d0oooo1@00o`0P0?ooo`<00?l0603oool00`00o`0000000000002;0?ooo`00Y03o
ool0100000000?l0003o0000o`0I0?ooo`<00?l07P3oool6003o01l0oooo0`00o`0H0?ooo`03003o
00000000000008/0oooo002T0?ooo`0400000000o`000?l0003o01T0oooo0`00o`0N0?ooo`H00?l0
7`3oool3003o01T0oooo0`00002:0?ooo`00Y03oool3000001X0oooo0`00o`0N0?ooo`H00?l07`3o
ool4003o01T0oooo0P00002:0?ooo`00Y03oool2000001X0oooo1000o`0N0?ooo`H00?l0803oool3
003o01X0oooo00<000000?ooo`3oool0R03oool00:@0oooo0P00000J0?ooo`<00?l07`3oool6003o
0200oooo0`00o`2U0?ooo`00Y03oool00`000000oooo0?ooo`0I0?ooo`<00?l07`3oool6003o0200
oooo0`00o`2U0?ooo`00`03oool3003o01l0oooo1P00o`0P0?ooo`@00?l0Y03oool00;l0oooo1000
o`0P0?ooo`8000000`00o`0Q0?ooo`<00?l0Y03oool00;l0oooo0`00o`0Q0?ooo`030000003oool0
0?l000800?l08@3oool3003o00030000003oool0oooo0:40oooo002o0?ooo`<00?l08@3oool00`00
0000oooo003o0002003o0240oooo0`00o`000`000000oooo0?ooo`2Q0?ooo`00_`3oool3003o0003
0000003oool0oooo0200oooo0`00o`0R0?ooo`<00000X`3oool00;l0oooo0`00000S0?ooo`<00?l0
8P3oool300000:<0oooo002o0?ooo`<000008P3oool0100000000?l0003o0000o`0S0?ooo`800000
X`3oool00;l0oooo0P00000S0?ooo`0400000000o`000?l0003o02<0oooo0P00002S0?ooo`00_`3o
ool2000002<0oooo1000000T0?ooo`030000003oool0oooo0:40oooo002o0?ooo`030000003oool0
oooo02<0oooo0`0000380?ooo`00i@3oool200000<T0oooo003V0?ooo`030000003oool0oooo0<L0
oooo003V0?ooo`030000003oool0oooo0<L0oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oo
ok40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {284, 0}} -> {-0.000648227, 0.240652, \
0.00329378, 0.00329378}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(semiesferainferior;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86216 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.49566e-016 1.05025 -0.0434212 1.05025 [
[ 0 0 0 0 ]
[ 1 .86216 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .86216 L
0 .86216 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 .983 0 r
.51642 .55758 m .51826 .55586 L .51927 .55686 L closepath p F P
0 g
s
0 .842 0 r
.51636 .56007 m .51642 .55758 L .51927 .55686 L closepath p F P
0 g
s
0 .508 0 r
.51811 .56187 m .51636 .56007 L .51927 .55686 L closepath p F P
0 g
s
0 .231 0 r
.52064 .56192 m .51811 .56187 L .51927 .55686 L closepath p F P
0 g
s
0 .061 0 r
.52248 .5602 m .52064 .56192 L .51927 .55686 L closepath p F P
0 g
s
0 .046 0 r
.52254 .55771 m .52248 .5602 L .51927 .55686 L closepath p F P
0 g
s
0 .291 0 r
.52079 .55591 m .52254 .55771 L .51927 .55686 L closepath p F P
0 g
s
0 .716 0 r
.51826 .55586 m .52079 .55591 L .51927 .55686 L closepath p F P
0 g
s
0 .923 0 r
.51492 .67264 m .51702 .67123 L .51745 .67619 L closepath p F P
0 g
s
0 .861 0 r
.51445 .67511 m .51492 .67264 L .51745 .67619 L closepath p F P
0 g
s
0 .405 0 r
.51588 .67719 m .51445 .67511 L .51745 .67619 L closepath p F P
0 g
s
0 0 0 r
.51837 .67766 m .51588 .67719 L .51745 .67619 L closepath p F P
0 g
s
0 0 0 r
.52047 .67625 m .51837 .67766 L .51745 .67619 L closepath p F P
0 g
s
0 0 0 r
.52094 .67378 m .52047 .67625 L .51745 .67619 L closepath p F P
0 g
s
0 .364 0 r
.51951 .6717 m .52094 .67378 L .51745 .67619 L closepath p F P
0 g
s
0 .725 0 r
.51702 .67123 m .51951 .6717 L .51745 .67619 L closepath p F P
0 g
s
0 .972 0 r
.62258 .543 m .62436 .54144 L .62878 .54205 L closepath p F P
0 g
s
0 .798 0 r
.62249 .54547 m .62258 .543 L .62878 .54205 L closepath p F P
0 g
s
0 .551 0 r
.62415 .54742 m .62249 .54547 L .62878 .54205 L closepath p F P
0 g
s
0 .243 0 r
.62659 .54769 m .62415 .54742 L .62878 .54205 L closepath p F P
0 g
s
0 0 0 r
.62838 .54614 m .62659 .54769 L .62878 .54205 L closepath p F P
0 g
s
0 .644 0 r
.62847 .54366 m .62838 .54614 L .62878 .54205 L closepath p F P
0 g
s
0 .527 0 r
.62436 .54144 m .6268 .54172 L .62878 .54205 L closepath p F P
0 g
s
0 .273 0 r
.6268 .54172 m .62847 .54366 L .62878 .54205 L closepath p F P
0 g
s
0 .367 0 r
.41372 .54448 m .41185 .54306 L .411 .53867 L closepath p F P
0 g
s
0 .289 0 r
.41613 .54403 m .41372 .54448 L .411 .53867 L closepath p F P
0 g
s
0 .297 0 r
.41767 .54198 m .41613 .54403 L .411 .53867 L closepath p F P
0 g
s
0 .373 0 r
.41744 .53954 m .41767 .54198 L .411 .53867 L closepath p F P
0 g
s
0 .553 0 r
.41558 .53812 m .41744 .53954 L .411 .53867 L closepath p F P
0 g
s
0 0 0 r
.41162 .54062 m .41316 .53857 L .411 .53867 L closepath p F P
0 g
s
0 0 0 r
.41185 .54306 m .41162 .54062 L .411 .53867 L closepath p F P
0 g
s
0 0 0 r
.41316 .53857 m .41558 .53812 L .411 .53867 L closepath p F P
0 g
s
0 .821 0 r
.65426 .65526 m .6562 .65371 L .66122 .65813 L closepath p F P
0 g
s
0 .737 0 r
.65385 .65779 m .65426 .65526 L .66122 .65813 L closepath p F P
0 g
s
0 .505 0 r
.6552 .65983 m .65385 .65779 L .66122 .65813 L closepath p F P
0 g
s
0 0 0 r
.65753 .66018 m .6552 .65983 L .66122 .65813 L closepath p F P
0 g
s
0 .913 0 r
.65947 .65863 m .65753 .66018 L .66122 .65813 L closepath p F P
0 g
s
0 .684 0 r
.6562 .65371 m .65853 .65406 L .66122 .65813 L closepath p F P
0 g
s
0 .85 0 r
.65989 .65609 m .65947 .65863 L .66122 .65813 L closepath p F P
0 g
s
0 0 0 r
.65853 .65406 m .65989 .65609 L .66122 .65813 L closepath p F P
0 g
s
0 .888 0 r
.37725 .65138 m .37898 .64973 L .37519 .65399 L closepath p F P
0 g
s
0 .348 0 r
.38286 .65194 m .38275 .6545 L .37519 .65399 L closepath p F P
0 g
s
0 .562 0 r
.3813 .64997 m .38286 .65194 L .37519 .65399 L closepath p F P
0 g
s
0 .836 0 r
.37898 .64973 m .3813 .64997 L .37519 .65399 L closepath p F P
0 g
s
0 0 0 r
.37713 .65394 m .37725 .65138 L .37519 .65399 L closepath p F P
0 g
s
0 0 0 r
.38102 .65614 m .3787 .65591 L .37519 .65399 L closepath p F P
0 g
s
0 .12 0 r
.38275 .6545 m .38102 .65614 L .37519 .65399 L closepath p F P
0 g
s
0 .189 0 r
.3787 .65591 m .37713 .65394 L .37519 .65399 L closepath p F P
0 g
s
0 .847 0 r
.519 .4514 m .51881 .44919 L .5219 .44441 L closepath p F P
0 g
s
0 0 0 r
.51881 .44919 m .52049 .4475 L .5219 .44441 L closepath p F P
0 g
s
0 .578 0 r
.52095 .45284 m .519 .4514 L .5219 .44441 L closepath p F P
0 g
s
0 .399 0 r
.52351 .45266 m .52095 .45284 L .5219 .44441 L closepath p F P
0 g
s
0 .238 0 r
.5252 .45098 m .52351 .45266 L .5219 .44441 L closepath p F P
0 g
s
0 0 0 r
.52501 .44877 m .5252 .45098 L .5219 .44441 L closepath p F P
0 g
s
0 .183 0 r
.52306 .44732 m .52501 .44877 L .5219 .44441 L closepath p F P
0 g
s
0 0 0 r
.52049 .4475 m .52306 .44732 L .5219 .44441 L closepath p F P
0 g
s
0 .857 0 r
.57714 .44269 m .57699 .4405 L .58197 .43574 L closepath p F P
0 g
s
0 0 0 r
.57699 .4405 m .57868 .43903 L .58197 .43574 L closepath p F P
0 g
s
0 .595 0 r
.57904 .44431 m .57714 .44269 L .58197 .43574 L closepath p F P
0 g
s
0 .396 0 r
.58159 .44441 m .57904 .44431 L .58197 .43574 L closepath p F P
0 g
s
0 .146 0 r
.58329 .44293 m .58159 .44441 L .58197 .43574 L closepath p F P
0 g
s
0 0 0 r
.58314 .44074 m .58329 .44293 L .58197 .43574 L closepath p F P
0 g
s
0 .391 0 r
.58123 .43912 m .58314 .44074 L .58197 .43574 L closepath p F P
0 g
s
0 .03 0 r
.57868 .43903 m .58123 .43912 L .58197 .43574 L closepath p F P
0 g
s
0 .753 0 r
.46171 .44149 m .46141 .43937 L .4626 .43377 L closepath p F P
0 g
s
0 .56 0 r
.46371 .44263 m .46171 .44149 L .4626 .43377 L closepath p F P
0 g
s
0 0 0 r
.46141 .43937 m .46299 .43751 L .4626 .43377 L closepath p F P
0 g
s
0 .424 0 r
.46624 .44213 m .46371 .44263 L .4626 .43377 L closepath p F P
0 g
s
0 .333 0 r
.46782 .44027 m .46624 .44213 L .4626 .43377 L closepath p F P
0 g
s
0 .219 0 r
.46752 .43814 m .46782 .44027 L .4626 .43377 L closepath p F P
0 g
s
0 .044 0 r
.46552 .437 m .46752 .43814 L .4626 .43377 L closepath p F P
0 g
s
0 .03 0 r
.46299 .43751 m .46552 .437 L .4626 .43377 L closepath p F P
0 g
s
0 .774 0 r
.51453 .78323 m .51692 .78238 L .51664 .79086 L closepath p F P
0 g
s
0 .844 0 r
.51353 .78532 m .51453 .78323 L .51664 .79086 L closepath p F P
0 g
s
0 .341 0 r
.51451 .78745 m .51353 .78532 L .51664 .79086 L closepath p F P
0 g
s
0 .601 0 r
.51692 .78238 m .51931 .78329 L .51664 .79086 L closepath p F P
0 g
s
0 .593 0 r
.51691 .78836 m .51451 .78745 L .51664 .79086 L closepath p F P
0 g
s
0 0 0 r
.5203 .78541 m .5193 .78751 L .51664 .79086 L closepath p F P
0 g
s
0 .26 0 r
.51931 .78329 m .5203 .78541 L .51664 .79086 L closepath p F P
0 g
s
0 .949 0 r
.5193 .78751 m .51691 .78836 L .51664 .79086 L closepath p F P
0 g
s
0 1 0 r
.007 w
.51677 .7883 m
.51819 .75983 L
s
.5 Mabswid
.738 .611 .717 r
.46568 .58326 m .5062 .58799 L .50536 .60147 L p F P
0 g
s
.738 .611 .717 r
.50536 .60147 m .46304 .59657 L .46568 .58326 L p F P
0 g
s
.706 .583 .715 r
.54843 .60126 m .50536 .60147 L .5062 .58799 L p F P
0 g
s
.739 .603 .706 r
.46304 .59657 m .50536 .60147 L .50458 .61501 L p F P
0 g
s
.706 .574 .705 r
.50536 .60147 m .54843 .60126 L .54936 .61479 L p F P
0 g
s
.706 .574 .705 r
.54936 .61479 m .50458 .61501 L .50536 .60147 L p F P
0 g
s
.739 .603 .706 r
.50458 .61501 m .46056 .60995 L .46304 .59657 L p F P
0 g
s
.741 .596 .695 r
.46056 .60995 m .50458 .61501 L .50385 .62856 L p F P
0 g
s
.706 .566 .694 r
.50458 .61501 m .54936 .61479 L .55022 .62834 L p F P
0 g
s
.706 .566 .694 r
.55022 .62834 m .50385 .62856 L .50458 .61501 L p F P
0 g
s
.706 .583 .715 r
.5062 .58799 m .54744 .58778 L .54843 .60126 L p F P
0 g
s
.672 .557 .717 r
.59062 .59594 m .54843 .60126 L .54744 .58778 L p F P
0 g
s
.67 .547 .706 r
.54843 .60126 m .59062 .59594 L .59324 .6093 L p F P
0 g
s
.67 .547 .706 r
.59324 .6093 m .54936 .61479 L .54843 .60126 L p F P
0 g
s
.669 .537 .695 r
.54936 .61479 m .59324 .6093 L .59567 .6227 L p F P
0 g
s
.669 .537 .695 r
.59567 .6227 m .55022 .62834 L .54936 .61479 L p F P
0 g
s
.737 .619 .727 r
.46848 .57003 m .50709 .57458 L .5062 .58799 L p F P
0 g
s
.737 .619 .727 r
.5062 .58799 m .46568 .58326 L .46848 .57003 L p F P
0 g
s
.706 .591 .726 r
.54744 .58778 m .5062 .58799 L .50709 .57458 L p F P
0 g
s
.706 .591 .726 r
.50709 .57458 m .54639 .57438 L .54744 .58778 L p F P
0 g
s
.673 .567 .727 r
.58784 .58265 m .54744 .58778 L .54639 .57438 L p F P
0 g
s
.672 .557 .717 r
.54744 .58778 m .58784 .58265 L .59062 .59594 L p F P
0 g
s
.741 .596 .695 r
.50385 .62856 m .45825 .62337 L .46056 .60995 L p F P
0 g
s
.741 .588 .684 r
.45825 .62337 m .50385 .62856 L .50317 .64211 L p F P
0 g
s
.705 .557 .683 r
.50385 .62856 m .55022 .62834 L .55102 .64188 L p F P
0 g
s
.705 .557 .683 r
.55102 .64188 m .50317 .64211 L .50385 .62856 L p F P
0 g
s
.667 .527 .685 r
.55022 .62834 m .59567 .6227 L .59792 .63612 L p F P
0 g
s
.667 .527 .685 r
.59792 .63612 m .55102 .64188 L .55022 .62834 L p F P
0 g
s
.735 .626 .738 r
.47143 .55693 m .50803 .56128 L .50709 .57458 L p F P
0 g
s
.735 .626 .738 r
.50709 .57458 m .46848 .57003 L .47143 .55693 L p F P
0 g
s
.705 .6 .736 r
.54639 .57438 m .50709 .57458 L .50803 .56128 L p F P
0 g
s
0 1 0 r
.007 w
.51927 .55686 m
.52004 .56538 L
s
.5 Mabswid
.705 .6 .736 r
.50803 .56128 m .54529 .56109 L .54639 .57438 L p F P
0 g
s
.674 .576 .738 r
.58489 .56945 m .54639 .57438 L .54529 .56109 L p F P
0 g
s
.673 .567 .727 r
.54639 .57438 m .58489 .56945 L .58784 .58265 L p F P
0 g
s
.741 .588 .684 r
.50317 .64211 m .45612 .6368 L .45825 .62337 L p F P
0 g
s
.742 .58 .673 r
.45612 .6368 m .50317 .64211 L .50255 .65563 L p F P
0 g
s
.705 .548 .672 r
.50317 .64211 m .55102 .64188 L .55175 .6554 L p F P
0 g
s
.705 .548 .672 r
.55175 .6554 m .50255 .65563 L .50317 .64211 L p F P
0 g
s
.665 .517 .673 r
.55102 .64188 m .59792 .63612 L .59999 .64952 L p F P
0 g
s
.665 .517 .673 r
.59999 .64952 m .55175 .6554 L .55102 .64188 L p F P
0 g
s
.733 .634 .748 r
.47452 .54397 m .50901 .5481 L .50803 .56128 L p F P
0 g
s
.733 .634 .748 r
.50803 .56128 m .47143 .55693 L .47452 .54397 L p F P
0 g
s
.705 .609 .747 r
.54529 .56109 m .50803 .56128 L .50901 .5481 L p F P
0 g
s
.705 .609 .747 r
.50901 .5481 m .54413 .54792 L .54529 .56109 L p F P
0 g
s
.675 .586 .748 r
.58177 .55637 m .54529 .56109 L .54413 .54792 L p F P
0 g
s
.674 .576 .738 r
.54529 .56109 m .58177 .55637 L .58489 .56945 L p F P
0 g
s
.742 .58 .673 r
.50255 .65563 m .45416 .65021 L .45612 .6368 L p F P
0 g
s
.743 .571 .662 r
.45416 .65021 m .50255 .65563 L .50199 .66909 L p F P
0 g
s
.704 .538 .661 r
.50255 .65563 m .55175 .6554 L .55241 .66885 L p F P
0 g
s
.704 .538 .661 r
.55241 .66885 m .50199 .66909 L .50255 .65563 L p F P
0 g
s
0 1 0 r
.007 w
.51745 .67619 m
.51845 .66901 L
s
.5 Mabswid
.663 .507 .662 r
.55175 .6554 m .59999 .64952 L .60186 .66288 L p F P
0 g
s
.663 .507 .662 r
.60186 .66288 m .55241 .66885 L .55175 .6554 L p F P
0 g
s
.731 .641 .759 r
.47776 .53119 m .51004 .53508 L .50901 .5481 L p F P
0 g
s
.731 .641 .759 r
.50901 .5481 m .47452 .54397 L .47776 .53119 L p F P
0 g
s
.704 .617 .757 r
.54413 .54792 m .50901 .5481 L .51004 .53508 L p F P
0 g
s
.704 .617 .757 r
.51004 .53508 m .54292 .53492 L .54413 .54792 L p F P
0 g
s
.675 .596 .759 r
.5785 .54344 m .54413 .54792 L .54292 .53492 L p F P
0 g
s
.675 .586 .748 r
.54413 .54792 m .5785 .54344 L .58177 .55637 L p F P
0 g
s
.77 .643 .721 r
.42742 .57372 m .46568 .58326 L .46304 .59657 L p F P
0 g
s
.77 .643 .721 r
.46304 .59657 m .42306 .58669 L .42742 .57372 L p F P
0 g
s
.772 .636 .71 r
.42306 .58669 m .46304 .59657 L .46056 .60995 L p F P
0 g
s
.767 .649 .732 r
.43205 .56088 m .46848 .57003 L .46568 .58326 L p F P
0 g
s
.767 .649 .732 r
.46568 .58326 m .42742 .57372 L .43205 .56088 L p F P
0 g
s
.772 .636 .71 r
.46056 .60995 m .41896 .59976 L .42306 .58669 L p F P
0 g
s
.775 .629 .699 r
.41896 .59976 m .46056 .60995 L .45825 .62337 L p F P
0 g
s
.743 .571 .662 r
.50199 .66909 m .45239 .66358 L .45416 .65021 L p F P
0 g
s
.743 .563 .65 r
.45239 .66358 m .50199 .66909 L .50148 .68246 L p F P
0 g
s
.703 .529 .65 r
.50199 .66909 m .55241 .66885 L .55301 .68222 L p F P
0 g
s
.703 .529 .65 r
.55301 .68222 m .50148 .68246 L .50199 .66909 L p F P
0 g
s
.634 .533 .721 r
.63034 .58566 m .59062 .59594 L .58784 .58265 L p F P
0 g
s
.632 .521 .71 r
.59062 .59594 m .63034 .58566 L .63456 .5987 L p F P
0 g
s
.632 .521 .71 r
.63456 .5987 m .59324 .6093 L .59062 .59594 L p F P
0 g
s
.637 .544 .732 r
.62583 .57273 m .58784 .58265 L .58489 .56945 L p F P
0 g
s
.634 .533 .721 r
.58784 .58265 m .62583 .57273 L .63034 .58566 L p F P
0 g
s
.764 .656 .742 r
.43692 .54818 m .47143 .55693 L .46848 .57003 L p F P
0 g
s
.764 .656 .742 r
.46848 .57003 m .43205 .56088 L .43692 .54818 L p F P
0 g
s
.661 .496 .65 r
.55241 .66885 m .60186 .66288 L .60353 .67616 L p F P
0 g
s
.661 .496 .65 r
.60353 .67616 m .55301 .68222 L .55241 .66885 L p F P
0 g
s
.629 .51 .699 r
.59324 .6093 m .63456 .5987 L .6385 .61181 L p F P
0 g
s
.629 .51 .699 r
.6385 .61181 m .59567 .6227 L .59324 .6093 L p F P
0 g
s
.775 .629 .699 r
.45825 .62337 m .41514 .6129 L .41896 .59976 L p F P
0 g
s
.777 .622 .688 r
.41514 .6129 m .45825 .62337 L .45612 .6368 L p F P
0 g
s
.64 .555 .743 r
.62107 .55992 m .58489 .56945 L .58177 .55637 L p F P
0 g
s
.637 .544 .732 r
.58489 .56945 m .62107 .55992 L .62583 .57273 L p F P
0 g
s
.625 .499 .688 r
.59567 .6227 m .6385 .61181 L .64215 .62497 L p F P
0 g
s
.625 .499 .688 r
.64215 .62497 m .59792 .63612 L .59567 .6227 L p F P
0 g
s
.761 .662 .753 r
.44203 .53567 m .47452 .54397 L .47143 .55693 L p F P
0 g
s
.761 .662 .753 r
.47143 .55693 m .43692 .54818 L .44203 .53567 L p F P
0 g
s
.729 .649 .769 r
.48113 .51861 m .51111 .52225 L .51004 .53508 L p F P
0 g
s
.729 .649 .769 r
.51004 .53508 m .47776 .53119 L .48113 .51861 L p F P
0 g
s
.703 .626 .768 r
.54292 .53492 m .51004 .53508 L .51111 .52225 L p F P
0 g
s
.703 .626 .768 r
.51111 .52225 m .54165 .5221 L .54292 .53492 L p F P
0 g
s
.676 .606 .77 r
.57509 .53069 m .54292 .53492 L .54165 .5221 L p F P
0 g
s
.675 .596 .759 r
.54292 .53492 m .57509 .53069 L .5785 .54344 L p F P
0 g
s
.777 .622 .688 r
.45612 .6368 m .41161 .62608 L .41514 .6129 L p F P
0 g
s
.779 .615 .676 r
.41161 .62608 m .45612 .6368 L .45416 .65021 L p F P
0 g
s
.683 0 0 r
.5199 .71613 m .51732 .71626 L .5183 .70482 L closepath p F P
0 g
s
.461 0 0 r
.52154 .71509 m .5199 .71613 L .5183 .70482 L closepath p F P
0 g
s
0 0 0 r
.52127 .71376 m .52154 .71509 L .5183 .70482 L closepath p F P
0 g
s
.846 0 0 r
.51924 .71292 m .52127 .71376 L .5183 .70482 L closepath p F P
0 g
s
.837 0 0 r
.51732 .71626 m .51529 .71542 L .5183 .70482 L closepath p F P
0 g
s
.647 0 0 r
.51665 .71306 m .51924 .71292 L .5183 .70482 L closepath p F P
0 g
s
.989 0 0 r
.51529 .71542 m .51501 .7141 L .5183 .70482 L closepath p F P
0 g
s
.268 0 0 r
.51501 .7141 m .51665 .71306 L .5183 .70482 L closepath p F P
0 g
s
.642 .566 .753 r
.61604 .54727 m .58177 .55637 L .5785 .54344 L p F P
0 g
s
.64 .555 .743 r
.58177 .55637 m .61604 .54727 L .62107 .55992 L p F P
0 g
s
0 1 0 r
.007 w
.61741 .55072 m
.62776 .54283 L
s
.5 Mabswid
.622 .487 .677 r
.59792 .63612 m .64215 .62497 L .64549 .63815 L p F P
0 g
s
.622 .487 .677 r
.64549 .63815 m .59999 .64952 L .59792 .63612 L p F P
0 g
s
.743 .563 .65 r
.50148 .68246 m .4508 .67688 L .45239 .66358 L p F P
0 g
s
.743 .554 .638 r
.4508 .67688 m .50148 .68246 L .50104 .69571 L p F P
0 g
s
.702 .519 .638 r
.50148 .68246 m .55301 .68222 L .55353 .69547 L p F P
0 g
s
.702 .519 .638 r
.55353 .69547 m .50104 .69571 L .50148 .68246 L p F P
0 g
s
.659 .485 .638 r
.55301 .68222 m .60353 .67616 L .60501 .68935 L p F P
0 g
s
.659 .485 .638 r
.60501 .68935 m .55353 .69547 L .55301 .68222 L p F P
0 g
s
.757 .668 .763 r
.44737 .52336 m .47776 .53119 L .47452 .54397 L p F P
0 g
s
.757 .668 .763 r
.47452 .54397 m .44203 .53567 L .44737 .52336 L p F P
0 g
s
.779 .615 .676 r
.45416 .65021 m .40837 .63928 L .41161 .62608 L p F P
0 g
s
.781 .607 .664 r
.40837 .63928 m .45416 .65021 L .45239 .66358 L p F P
0 g
s
.645 .577 .764 r
.61077 .53481 m .5785 .54344 L .57509 .53069 L p F P
0 g
s
.642 .566 .753 r
.5785 .54344 m .61077 .53481 L .61604 .54727 L p F P
0 g
s
.619 .475 .665 r
.59999 .64952 m .64549 .63815 L .64852 .65132 L p F P
0 g
s
.619 .475 .665 r
.64852 .65132 m .60186 .66288 L .59999 .64952 L p F P
0 g
s
0 1 0 r
.007 w
.64207 .65291 m
.65963 .6577 L
s
.5 Mabswid
.726 .656 .78 r
.48463 .50626 m .51222 .50963 L .51111 .52225 L p F P
0 g
s
.726 .656 .78 r
.51111 .52225 m .48113 .51861 L .48463 .50626 L p F P
0 g
s
.702 .635 .779 r
.54165 .5221 m .51111 .52225 L .51222 .50963 L p F P
0 g
s
.702 .635 .779 r
.51222 .50963 m .54034 .50949 L .54165 .5221 L p F P
0 g
s
.677 .616 .78 r
.57153 .51814 m .54165 .5221 L .54034 .50949 L p F P
0 g
s
.676 .606 .77 r
.54165 .5221 m .57153 .51814 L .57509 .53069 L p F P
0 g
s
.753 .674 .774 r
.45293 .51129 m .48113 .51861 L .47776 .53119 L p F P
0 g
s
.753 .674 .774 r
.47776 .53119 m .44737 .52336 L .45293 .51129 L p F P
0 g
s
.647 .588 .775 r
.60526 .52255 m .57509 .53069 L .57153 .51814 L p F P
0 g
s
.645 .577 .764 r
.57509 .53069 m .60526 .52255 L .61077 .53481 L p F P
0 g
s
.743 .554 .638 r
.50104 .69571 m .44941 .69008 L .4508 .67688 L p F P
0 g
s
.743 .545 .626 r
.44941 .69008 m .50104 .69571 L .50066 .70882 L p F P
0 g
s
.701 .509 .625 r
.50104 .69571 m .55353 .69547 L .55398 .70858 L p F P
0 g
s
.701 .509 .625 r
.55398 .70858 m .50066 .70882 L .50104 .69571 L p F P
0 g
s
.781 .607 .664 r
.45239 .66358 m .40543 .65247 L .40837 .63928 L p F P
0 g
s
.782 .599 .652 r
.40543 .65247 m .45239 .66358 L .4508 .67688 L p F P
0 g
s
.657 .474 .626 r
.55353 .69547 m .60501 .68935 L .60627 .70242 L p F P
0 g
s
.657 .474 .626 r
.60627 .70242 m .55398 .70858 L .55353 .69547 L p F P
0 g
s
.615 .463 .653 r
.60186 .66288 m .64852 .65132 L .65123 .66445 L p F P
0 g
s
.615 .463 .653 r
.65123 .66445 m .60353 .67616 L .60186 .66288 L p F P
0 g
s
.723 .664 .791 r
.48826 .49416 m .51338 .49726 L .51222 .50963 L p F P
0 g
s
.723 .664 .791 r
.51222 .50963 m .48463 .50626 L .48826 .49416 L p F P
0 g
s
.701 .644 .79 r
.54034 .50949 m .51222 .50963 L .51338 .49726 L p F P
0 g
s
.749 .681 .785 r
.4587 .49947 m .48463 .50626 L .48113 .51861 L p F P
0 g
s
.749 .681 .785 r
.48113 .51861 m .45293 .51129 L .4587 .49947 L p F P
0 g
s
.701 .644 .79 r
.51338 .49726 m .53898 .49712 L .54034 .50949 L p F P
0 g
s
.677 .626 .791 r
.56784 .50582 m .54034 .50949 L .53898 .49712 L p F P
0 g
s
.677 .616 .78 r
.54034 .50949 m .56784 .50582 L .57153 .51814 L p F P
0 g
s
.649 .6 .785 r
.59953 .51053 m .57153 .51814 L .56784 .50582 L p F P
0 g
s
.647 .588 .775 r
.57153 .51814 m .59953 .51053 L .60526 .52255 L p F P
0 g
s
.782 .599 .652 r
.4508 .67688 m .4028 .66562 L .40543 .65247 L p F P
0 g
s
.784 .591 .64 r
.4028 .66562 m .4508 .67688 L .44941 .69008 L p F P
0 g
s
.797 .684 .739 r
.39927 .5474 m .43205 .56088 L .42742 .57372 L p F P
0 g
s
.797 .684 .739 r
.42742 .57372 m .39297 .55967 L .39927 .5474 L p F P
0 g
s
.801 .678 .728 r
.39297 .55967 m .42742 .57372 L .42306 .58669 L p F P
0 g
s
.743 .545 .626 r
.50066 .70882 m .44821 .70315 L .44941 .69008 L p F P
0 g
s
.743 .535 .613 r
.44821 .70315 m .50066 .70882 L .50035 .72176 L p F P
0 g
s
.7 .499 .613 r
.50066 .70882 m .55398 .70858 L .55435 .72151 L p F P
0 g
s
.7 .499 .613 r
.55435 .72151 m .50035 .72176 L .50066 .70882 L p F P
0 g
s
.792 .689 .75 r
.40591 .53532 m .43692 .54818 L .43205 .56088 L p F P
0 g
s
.792 .689 .75 r
.43205 .56088 m .39927 .5474 L .40591 .53532 L p F P
0 g
s
.611 .451 .64 r
.60353 .67616 m .65123 .66445 L .65362 .67752 L p F P
0 g
s
.611 .451 .64 r
.65362 .67752 m .60501 .68935 L .60353 .67616 L p F P
0 g
s
.801 .678 .728 r
.42306 .58669 m .38701 .57213 L .39297 .55967 L p F P
0 g
s
.806 .673 .717 r
.38701 .57213 m .42306 .58669 L .41896 .59976 L p F P
0 g
s
.654 .463 .613 r
.55398 .70858 m .60627 .70242 L .60733 .71533 L p F P
0 g
s
.654 .463 .613 r
.60733 .71533 m .55435 .72151 L .55398 .70858 L p F P
0 g
s
.787 .694 .761 r
.41287 .52346 m .44203 .53567 L .43692 .54818 L p F P
0 g
s
.787 .694 .761 r
.43692 .54818 m .40591 .53532 L .41287 .52346 L p F P
0 g
s
.806 .673 .717 r
.41896 .59976 m .38142 .58473 L .38701 .57213 L p F P
0 g
s
.809 .667 .706 r
.38142 .58473 m .41896 .59976 L .41514 .6129 L p F P
0 g
s
.598 .522 .74 r
.65991 .55833 m .62583 .57273 L .62107 .55992 L p F P
0 g
s
.593 .509 .729 r
.62583 .57273 m .65991 .55833 L .66599 .57073 L p F P
0 g
s
.593 .509 .729 r
.66599 .57073 m .63034 .58566 L .62583 .57273 L p F P
0 g
s
.602 .535 .751 r
.65347 .5461 m .62107 .55992 L .61604 .54727 L p F P
0 g
s
.598 .522 .74 r
.62107 .55992 m .65347 .5461 L .65991 .55833 L p F P
0 g
s
.588 .496 .718 r
.63034 .58566 m .66599 .57073 L .6717 .58328 L p F P
0 g
s
.588 .496 .718 r
.6717 .58328 m .63456 .5987 L .63034 .58566 L p F P
0 g
s
.607 .548 .762 r
.6467 .53408 m .61604 .54727 L .61077 .53481 L p F P
0 g
s
.602 .535 .751 r
.61604 .54727 m .6467 .53408 L .65347 .5461 L p F P
0 g
s
.744 .687 .796 r
.46467 .48794 m .48826 .49416 L .48463 .50626 L p F P
0 g
s
.744 .687 .796 r
.48463 .50626 m .4587 .49947 L .46467 .48794 L p F P
0 g
s
.583 .483 .706 r
.63456 .5987 m .6717 .58328 L .67703 .59596 L p F P
0 g
s
.583 .483 .706 r
.67703 .59596 m .6385 .61181 L .63456 .5987 L p F P
0 g
s
.782 .699 .772 r
.42014 .51186 m .44737 .52336 L .44203 .53567 L p F P
0 g
s
.782 .699 .772 r
.44203 .53567 m .41287 .52346 L .42014 .51186 L p F P
0 g
s
.809 .667 .706 r
.41514 .6129 m .3762 .59745 L .38142 .58473 L p F P
0 g
s
.813 .661 .694 r
.3762 .59745 m .41514 .6129 L .41161 .62608 L p F P
0 g
s
.677 .626 .791 r
.53898 .49712 m .56401 .49376 L .56784 .50582 L p F P
0 g
s
.652 .612 .796 r
.59358 .49876 m .56784 .50582 L .56401 .49376 L p F P
0 g
s
.649 .6 .785 r
.56784 .50582 m .59358 .49876 L .59953 .51053 L p F P
0 g
s
.72 .672 .802 r
.492 .48234 m .51457 .48515 L .51338 .49726 L p F P
0 g
s
.72 .672 .802 r
.51338 .49726 m .48826 .49416 L .492 .48234 L p F P
0 g
s
.699 .653 .801 r
.53898 .49712 m .51338 .49726 L .51457 .48515 L p F P
0 g
s
.699 .653 .801 r
.51457 .48515 m .53758 .48502 L .53898 .49712 L p F P
0 g
s
.677 .637 .802 r
.56401 .49376 m .53898 .49712 L .53758 .48502 L p F P
0 g
s
.784 .591 .64 r
.44941 .69008 m .40049 .67871 L .4028 .66562 L p F P
0 g
s
.785 .582 .627 r
.40049 .67871 m .44941 .69008 L .44821 .70315 L p F P
0 g
s
0 .954 0 r
.70665 .49889 m .70815 .49757 L .71557 .49666 L closepath p F P
0 g
s
0 .757 0 r
.70673 .50128 m .70665 .49889 L .71557 .49666 L closepath p F P
0 g
s
0 .558 0 r
.70834 .50334 m .70673 .50128 L .71557 .49666 L closepath p F P
0 g
s
0 .286 0 r
.71054 .50388 m .70834 .50334 L .71557 .49666 L closepath p F P
0 g
s
0 0 0 r
.71204 .50256 m .71054 .50388 L .71557 .49666 L closepath p F P
0 g
s
0 .854 0 r
.71197 .50017 m .71204 .50256 L .71557 .49666 L closepath p F P
0 g
s
0 .525 0 r
.71035 .4981 m .71197 .50017 L .71557 .49666 L closepath p F P
0 g
s
0 0 0 r
.70815 .49757 m .71035 .4981 L .71557 .49666 L closepath p F P
0 g
s
.611 .56 .773 r
.6396 .5223 m .61077 .53481 L .60526 .52255 L p F P
0 g
s
.607 .548 .762 r
.61077 .53481 m .6396 .5223 L .6467 .53408 L p F P
0 g
s
.578 .47 .694 r
.6385 .61181 m .67703 .59596 L .68196 .60874 L p F P
0 g
s
.578 .47 .694 r
.68196 .60874 m .64215 .62497 L .6385 .61181 L p F P
0 g
s
.473 0 0 r
.64965 .69941 m .64791 .70047 L .64605 .68907 L closepath p F P
0 g
s
0 0 0 r
.64949 .69806 m .64965 .69941 L .64605 .68907 L closepath p F P
0 g
s
.849 0 0 r
.64751 .6972 m .64949 .69806 L .64605 .68907 L closepath p F P
0 g
s
.843 0 0 r
.64528 .70061 m .64331 .69975 L .64605 .68907 L closepath p F P
0 g
s
.683 0 0 r
.64791 .70047 m .64528 .70061 L .64605 .68907 L closepath p F P
0 g
s
.646 0 0 r
.64488 .69734 m .64751 .6972 L .64605 .68907 L closepath p F P
0 g
s
.97 0 0 r
.64331 .69975 m .64314 .6984 L .64605 .68907 L closepath p F P
0 g
s
.3 0 0 r
.64314 .6984 m .64488 .69734 L .64605 .68907 L closepath p F P
0 g
s
.607 .438 .627 r
.60501 .68935 m .65362 .67752 L .65567 .6905 L p F P
0 g
s
.607 .438 .627 r
.65567 .6905 m .60627 .70242 L .60501 .68935 L p F P
0 g
s
.777 .703 .782 r
.42769 .50054 m .45293 .51129 L .44737 .52336 L p F P
0 g
s
.777 .703 .782 r
.44737 .52336 m .42014 .51186 L .42769 .50054 L p F P
0 g
s
.813 .661 .694 r
.41161 .62608 m .37137 .61026 L .3762 .59745 L p F P
0 g
s
.816 .654 .682 r
.37137 .61026 m .41161 .62608 L .40837 .63928 L p F P
0 g
s
.743 .535 .613 r
.50035 .72176 m .44721 .71606 L .44821 .70315 L p F P
0 g
s
.742 .525 .599 r
.44721 .71606 m .50035 .72176 L .50009 .7345 L p F P
0 g
s
.698 .488 .599 r
.50035 .72176 m .55435 .72151 L .55465 .73425 L p F P
0 g
s
.698 .488 .599 r
.55465 .73425 m .50009 .7345 L .50035 .72176 L p F P
0 g
s
0 .703 0 r
.6686 .76584 m .67075 .76439 L .67581 .77234 L closepath p F P
0 g
s
0 .682 0 r
.66778 .7682 m .6686 .76584 L .67581 .77234 L closepath p F P
0 g
s
0 .452 0 r
.66878 .77009 m .66778 .7682 L .67581 .77234 L closepath p F P
0 g
s
0 .608 0 r
.671 .7704 m .66878 .77009 L .67581 .77234 L closepath p F P
0 g
s
0 .924 0 r
.67316 .76895 m .671 .7704 L .67581 .77234 L closepath p F P
0 g
s
0 0 0 r
.67298 .7647 m .67397 .76659 L .67581 .77234 L closepath p F P
0 g
s
0 .594 0 r
.67075 .76439 m .67298 .7647 L .67581 .77234 L closepath p F P
0 g
s
0 .884 0 r
.67397 .76659 m .67316 .76895 L .67581 .77234 L closepath p F P
0 g
s
.616 .573 .783 r
.63218 .51076 m .60526 .52255 L .59953 .51053 L p F P
0 g
s
.611 .56 .773 r
.60526 .52255 m .63218 .51076 L .6396 .5223 L p F P
0 g
s
.651 .45 .599 r
.55435 .72151 m .60733 .71533 L .60817 .72806 L p F P
0 g
s
.651 .45 .599 r
.60817 .72806 m .55465 .73425 L .55435 .72151 L p F P
0 g
s
0 .857 0 r
.62201 .41712 m .62183 .41507 L .62831 .40959 L closepath p F P
0 g
s
0 0 0 r
.62183 .41507 m .62347 .41385 L .62831 .40959 L closepath p F P
0 g
s
0 .612 0 r
.62391 .41882 m .62201 .41712 L .62831 .40959 L closepath p F P
0 g
s
0 .415 0 r
.62641 .41916 m .62391 .41882 L .62831 .40959 L closepath p F P
0 g
s
0 .097 0 r
.62805 .41795 m .62641 .41916 L .62831 .40959 L closepath p F P
0 g
s
0 .676 0 r
.62787 .4159 m .62805 .41795 L .62831 .40959 L closepath p F P
0 g
s
0 .516 0 r
.62597 .4142 m .62787 .4159 L .62831 .40959 L closepath p F P
0 g
s
0 .174 0 r
.62347 .41385 m .62597 .4142 L .62831 .40959 L closepath p F P
0 g
s
.573 .456 .682 r
.64215 .62497 m .68196 .60874 L .68649 .62159 L p F P
0 g
s
.573 .456 .682 r
.68649 .62159 m .64549 .63815 L .64215 .62497 L p F P
0 g
s
.739 .693 .807 r
.47082 .47672 m .492 .48234 L .48826 .49416 L p F P
0 g
s
.739 .693 .807 r
.48826 .49416 m .46467 .48794 L .47082 .47672 L p F P
0 g
s
.677 .637 .802 r
.53758 .48502 m .56007 .48198 L .56401 .49376 L p F P
0 g
s
.654 .624 .807 r
.58743 .48729 m .56401 .49376 L .56007 .48198 L p F P
0 g
s
.652 .612 .796 r
.56401 .49376 m .58743 .48729 L .59358 .49876 L p F P
0 g
s
.771 .708 .793 r
.43552 .48952 m .4587 .49947 L .45293 .51129 L p F P
0 g
s
.771 .708 .793 r
.45293 .51129 m .42769 .50054 L .43552 .48952 L p F P
0 g
s
.816 .654 .682 r
.40837 .63928 m .36693 .62314 L .37137 .61026 L p F P
0 g
s
.82 .647 .669 r
.36693 .62314 m .40837 .63928 L .40543 .65247 L p F P
0 g
s
0 1 0 r
.007 w
.37715 .65356 m
.40021 .6485 L
s
.5 Mabswid
.785 .582 .627 r
.44821 .70315 m .3985 .69169 L .40049 .67871 L p F P
0 g
s
.786 .573 .613 r
.3985 .69169 m .44821 .70315 L .44721 .71606 L p F P
0 g
s
.62 .586 .794 r
.62448 .49951 m .59953 .51053 L .59358 .49876 L p F P
0 g
s
.616 .573 .783 r
.59953 .51053 m .62448 .49951 L .63218 .51076 L p F P
0 g
s
.716 .679 .814 r
.49584 .47083 m .51579 .47333 L .51457 .48515 L p F P
0 g
s
.716 .679 .814 r
.51457 .48515 m .492 .48234 L .49584 .47083 L p F P
0 g
s
.697 .662 .812 r
.53758 .48502 m .51457 .48515 L .51579 .47333 L p F P
0 g
s
.697 .662 .812 r
.51579 .47333 m .53613 .47322 L .53758 .48502 L p F P
0 g
s
0 1 0 r
.007 w
.52195 .4474 m
.52243 .47329 L
s
.5 Mabswid
.677 .648 .814 r
.56007 .48198 m .53758 .48502 L .53613 .47322 L p F P
0 g
s
.567 .442 .669 r
.64549 .63815 m .68649 .62159 L .6906 .63448 L p F P
0 g
s
.567 .442 .669 r
.6906 .63448 m .64852 .65132 L .64549 .63815 L p F P
0 g
s
.603 .424 .613 r
.60627 .70242 m .65567 .6905 L .65738 .70335 L p F P
0 g
s
.603 .424 .613 r
.65738 .70335 m .60733 .71533 L .60627 .70242 L p F P
0 g
s
0 .625 0 r
.41917 .41509 m .41875 .4132 L .41844 .40608 L closepath p F P
0 g
s
0 .564 0 r
.42121 .41582 m .41917 .41509 L .41844 .40608 L closepath p F P
0 g
s
0 .469 0 r
.42368 .41498 m .42121 .41582 L .41844 .40608 L closepath p F P
0 g
s
0 .004 0 r
.41875 .4132 m .4202 .41127 L .41844 .40608 L closepath p F P
0 g
s
0 .409 0 r
.42513 .41305 m .42368 .41498 L .41844 .40608 L closepath p F P
0 g
s
0 .312 0 r
.42471 .41116 m .42513 .41305 L .41844 .40608 L closepath p F P
0 g
s
0 .121 0 r
.42267 .41042 m .42471 .41116 L .41844 .40608 L closepath p F P
0 g
s
0 .18 0 r
.4202 .41127 m .42267 .41042 L .41844 .40608 L closepath p F P
0 g
s
.764 .712 .804 r
.44361 .47882 m .46467 .48794 L .4587 .49947 L p F P
0 g
s
.764 .712 .804 r
.4587 .49947 m .43552 .48952 L .44361 .47882 L p F P
0 g
s
.82 .647 .669 r
.40543 .65247 m .36291 .63605 L .36693 .62314 L p F P
0 g
s
.823 .64 .656 r
.36291 .63605 m .40543 .65247 L .4028 .66562 L p F P
0 g
s
0 .382 0 r
.33413 .49788 m .3322 .4974 L .32791 .49047 L closepath p F P
0 g
s
0 .422 0 r
.33621 .49653 m .33413 .49788 L .32791 .49047 L closepath p F P
0 g
s
0 .461 0 r
.33721 .49414 m .33621 .49653 L .32791 .49047 L closepath p F P
0 g
s
0 .148 0 r
.33154 .49538 m .33254 .49298 L .32791 .49047 L closepath p F P
0 g
s
0 0 0 r
.3322 .4974 m .33154 .49538 L .32791 .49047 L closepath p F P
0 g
s
0 .538 0 r
.33655 .49211 m .33721 .49414 L .32791 .49047 L closepath p F P
0 g
s
0 .504 0 r
.33462 .49163 m .33655 .49211 L .32791 .49047 L closepath p F P
0 g
s
0 .037 0 r
.33254 .49298 m .33462 .49163 L .32791 .49047 L closepath p F P
0 g
s
.742 .525 .599 r
.50009 .7345 m .44641 .72879 L .44721 .71606 L p F P
0 g
s
.742 .514 .585 r
.44641 .72879 m .50009 .7345 L .49991 .747 L p F P
0 g
s
.696 .476 .585 r
.50009 .7345 m .55465 .73425 L .55487 .74676 L p F P
0 g
s
.696 .476 .585 r
.55487 .74676 m .49991 .747 L .50009 .7345 L p F P
0 g
s
.624 .599 .805 r
.61649 .48857 m .59358 .49876 L .58743 .48729 L p F P
0 g
s
.62 .586 .794 r
.59358 .49876 m .61649 .48857 L .62448 .49951 L p F P
0 g
s
.648 .437 .585 r
.55465 .73425 m .60817 .72806 L .60879 .74057 L p F P
0 g
s
.648 .437 .585 r
.60879 .74057 m .55487 .74676 L .55465 .73425 L p F P
0 g
s
0 .86 0 r
.36248 .76051 m .36466 .76026 L .35907 .7681 L closepath p F P
0 g
s
0 .839 0 r
.36149 .76238 m .36248 .76051 L .35907 .7681 L closepath p F P
0 g
s
0 .628 0 r
.36466 .76026 m .36676 .76177 L .35907 .7681 L closepath p F P
0 g
s
0 .168 0 r
.36228 .76477 m .36149 .76238 L .35907 .7681 L closepath p F P
0 g
s
0 .015 0 r
.36755 .76416 m .36657 .76603 L .35907 .7681 L closepath p F P
0 g
s
0 .408 0 r
.36676 .76177 m .36755 .76416 L .35907 .7681 L closepath p F P
0 g
s
0 .588 0 r
.36438 .76629 m .36228 .76477 L .35907 .7681 L closepath p F P
0 g
s
0 .809 0 r
.36657 .76603 m .36438 .76629 L .35907 .7681 L closepath p F P
0 g
s
.733 .699 .818 r
.47714 .46583 m .49584 .47083 L .492 .48234 L p F P
0 g
s
.733 .699 .818 r
.492 .48234 m .47082 .47672 L .47714 .46583 L p F P
0 g
s
.561 .428 .656 r
.64852 .65132 m .6906 .63448 L .69427 .64738 L p F P
0 g
s
.561 .428 .656 r
.69427 .64738 m .65123 .66445 L .64852 .65132 L p F P
0 g
s
.677 .648 .814 r
.53613 .47322 m .55601 .47051 L .56007 .48198 L p F P
0 g
s
.656 .636 .818 r
.58109 .47613 m .56007 .48198 L .55601 .47051 L p F P
0 g
s
.654 .624 .807 r
.56007 .48198 m .58109 .47613 L .58743 .48729 L p F P
0 g
s
.786 .573 .613 r
.44721 .71606 m .39684 .70455 L .3985 .69169 L p F P
0 g
s
.787 .564 .599 r
.39684 .70455 m .44721 .71606 L .44641 .72879 L p F P
0 g
s
.757 .717 .814 r
.45194 .46848 m .47082 .47672 L .46467 .48794 L p F P
0 g
s
.757 .717 .814 r
.46467 .48794 m .44361 .47882 L .45194 .46848 L p F P
0 g
s
.598 .41 .598 r
.60733 .71533 m .65738 .70335 L .65875 .71606 L p F P
0 g
s
.598 .41 .598 r
.65875 .71606 m .60817 .72806 L .60733 .71533 L p F P
0 g
s
.823 .64 .656 r
.4028 .66562 m .35931 .64898 L .36291 .63605 L p F P
0 g
s
.825 .633 .642 r
.35931 .64898 m .4028 .66562 L .40049 .67871 L p F P
0 g
s
.712 .687 .825 r
.49979 .45966 m .51705 .46184 L .51579 .47333 L p F P
0 g
s
.712 .687 .825 r
.51579 .47333 m .49584 .47083 L .49979 .45966 L p F P
0 g
s
.695 .672 .824 r
.53613 .47322 m .51579 .47333 L .51705 .46184 L p F P
0 g
s
.695 .672 .824 r
.51705 .46184 m .53465 .46174 L .53613 .47322 L p F P
0 g
s
.676 .659 .825 r
.55601 .47051 m .53613 .47322 L .53465 .46174 L p F P
0 g
s
.629 .613 .815 r
.60824 .47795 m .58743 .48729 L .58109 .47613 L p F P
0 g
s
.624 .599 .805 r
.58743 .48729 m .60824 .47795 L .61649 .48857 L p F P
0 g
s
.555 .413 .642 r
.65123 .66445 m .69427 .64738 L .69751 .66027 L p F P
0 g
s
.555 .413 .642 r
.69751 .66027 m .65362 .67752 L .65123 .66445 L p F P
0 g
s
.813 .731 .773 r
.38831 .50777 m .41287 .52346 L .40591 .53532 L p F P
0 g
s
.813 .731 .773 r
.40591 .53532 m .37975 .51876 L .38831 .50777 L p F P
0 g
s
.82 .727 .762 r
.37975 .51876 m .40591 .53532 L .39927 .5474 L p F P
0 g
s
.82 .727 .762 r
.39927 .5474 m .37157 .53003 L .37975 .51876 L p F P
0 g
s
.827 .724 .751 r
.37157 .53003 m .39927 .5474 L .39297 .55967 L p F P
0 g
s
.682 0 0 r
.39334 .69689 m .39073 .69703 L .39194 .68547 L closepath p F P
0 g
s
.441 0 0 r
.39491 .69582 m .39334 .69689 L .39194 .68547 L closepath p F P
0 g
s
0 0 0 r
.39452 .69446 m .39491 .69582 L .39194 .68547 L closepath p F P
0 g
s
.844 0 0 r
.39239 .6936 m .39452 .69446 L .39194 .68547 L closepath p F P
0 g
s
.834 0 0 r
.39073 .69703 m .38861 .69617 L .39194 .68547 L closepath p F P
0 g
s
.644 0 0 r
.38978 .69374 m .39239 .6936 L .39194 .68547 L closepath p F P
0 g
s
.993 0 0 r
.38861 .69617 m .38821 .69481 L .39194 .68547 L closepath p F P
0 g
s
.212 0 0 r
.38821 .69481 m .38978 .69374 L .39194 .68547 L closepath p F P
0 g
s
.742 .514 .585 r
.49991 .747 m .44582 .7413 L .44641 .72879 L p F P
0 g
s
.741 .503 .57 r
.44582 .7413 m .49991 .747 L .49979 .75925 L p F P
0 g
s
.694 .464 .57 r
.49991 .747 m .55487 .74676 L .55501 .75901 L p F P
0 g
s
.694 .464 .57 r
.55501 .75901 m .49979 .75925 L .49991 .747 L p F P
0 g
s
1 0 0 r
.007 w
.51819 .75983 m
.51819 .75917 L
s
.5 Mabswid
.727 .705 .829 r
.48362 .45531 m .49979 .45966 L .49584 .47083 L p F P
0 g
s
.727 .705 .829 r
.49584 .47083 m .47714 .46583 L .48362 .45531 L p F P
0 g
s
.806 .734 .784 r
.39724 .4971 m .42014 .51186 L .41287 .52346 L p F P
0 g
s
.806 .734 .784 r
.41287 .52346 m .38831 .50777 L .39724 .4971 L p F P
0 g
s
.827 .724 .751 r
.39297 .55967 m .36379 .54156 L .37157 .53003 L p F P
0 g
s
.833 .72 .739 r
.36379 .54156 m .39297 .55967 L .38701 .57213 L p F P
0 g
s
.644 .424 .57 r
.55487 .74676 m .60879 .74057 L .60919 .75284 L p F P
0 g
s
0 0 .918 r
.57044 .75753 m .57056 .7572 L .58195 .76069 L closepath p F P
0 g
s
0 0 .818 r
.57035 .75962 m .57044 .75753 L .58195 .76069 L closepath p F P
0 g
s
0 0 .394 r
.57056 .7572 m .57063 .75883 L .58195 .76069 L closepath p F P
0 g
s
.644 .424 .57 r
.60919 .75284 m .55501 .75901 L .55487 .74676 L p F P
0 g
s
.676 .659 .825 r
.53465 .46174 m .55185 .45939 L .55601 .47051 L p F P
0 g
s
.657 .648 .83 r
.57458 .46531 m .55601 .47051 L .55185 .45939 L p F P
0 g
s
0 1 0 r
.007 w
.57302 .46491 m
.58094 .43911 L
s
.5 Mabswid
.656 .636 .818 r
.55601 .47051 m .57458 .46531 L .58109 .47613 L p F P
0 g
s
.567 .531 .774 r
.67241 .51725 m .6467 .53408 L .6396 .5223 L p F P
0 g
s
.56 .516 .763 r
.6467 .53408 m .67241 .51725 L .6807 .52844 L p F P
0 g
s
.56 .516 .763 r
.6807 .52844 m .65347 .5461 L .6467 .53408 L p F P
0 g
s
.749 .721 .825 r
.4605 .45851 m .47714 .46583 L .47082 .47672 L p F P
0 g
s
0 1 0 r
.007 w
.46379 .43735 m
.47264 .46385 L
s
.5 Mabswid
.749 .721 .825 r
.47082 .47672 m .45194 .46848 L .4605 .45851 L p F P
0 g
s
.552 .501 .752 r
.65347 .5461 m .6807 .52844 L .68859 .53991 L p F P
0 g
s
.552 .501 .752 r
.68859 .53991 m .65991 .55833 L .65347 .5461 L p F P
0 g
s
.798 .736 .795 r
.40652 .48675 m .42769 .50054 L .42014 .51186 L p F P
0 g
s
.798 .736 .795 r
.42014 .51186 m .39724 .4971 L .40652 .48675 L p F P
0 g
s
.833 .72 .739 r
.38701 .57213 m .35644 .55333 L .36379 .54156 L p F P
0 g
s
.839 .715 .728 r
.35644 .55333 m .38701 .57213 L .38142 .58473 L p F P
0 g
s
.825 .633 .642 r
.40049 .67871 m .35614 .66189 L .35931 .64898 L p F P
0 g
s
.828 .625 .628 r
.35614 .66189 m .40049 .67871 L .3985 .69169 L p F P
0 g
s
.574 .546 .785 r
.66372 .50634 m .6396 .5223 L .63218 .51076 L p F P
0 g
s
.567 .531 .774 r
.6396 .5223 m .66372 .50634 L .67241 .51725 L p F P
0 g
s
.787 .564 .599 r
.44641 .72879 m .39552 .71726 L .39684 .70455 L p F P
0 g
s
.787 .554 .583 r
.39552 .71726 m .44641 .72879 L .44582 .7413 L p F P
0 g
s
.545 .486 .741 r
.65991 .55833 m .68859 .53991 L .69605 .55161 L p F P
0 g
s
.545 .486 .741 r
.69605 .55161 m .66599 .57073 L .65991 .55833 L p F P
0 g
s
.633 .626 .826 r
.59974 .46769 m .58109 .47613 L .57458 .46531 L p F P
0 g
s
.629 .613 .815 r
.58109 .47613 m .59974 .46769 L .60824 .47795 L p F P
0 g
s
0 0 .656 r
.57033 .76225 m .57035 .75962 L .58195 .76069 L closepath p F P
0 g
s
.581 .56 .796 r
.65467 .49575 m .63218 .51076 L .62448 .49951 L p F P
0 g
s
.574 .546 .785 r
.63218 .51076 m .65467 .49575 L .66372 .50634 L p F P
0 g
s
0 0 .405 r
.5704 .76388 m .57033 .76225 L .58195 .76069 L closepath p F P
0 g
s
.593 .395 .583 r
.60817 .72806 m .65875 .71606 L .65976 .72858 L p F P
0 g
s
.593 .395 .583 r
.65976 .72858 m .60879 .74057 L .60817 .72806 L p F P
0 g
s
.79 .739 .805 r
.41612 .47677 m .43552 .48952 L .42769 .50054 L p F P
0 g
s
.79 .739 .805 r
.42769 .50054 m .40652 .48675 L .41612 .47677 L p F P
0 g
s
.548 .397 .628 r
.65362 .67752 m .69751 .66027 L .70029 .67312 L p F P
0 g
s
.548 .397 .628 r
.70029 .67312 m .65567 .6905 L .65362 .67752 L p F P
0 g
s
.839 .715 .728 r
.38142 .58473 m .34952 .56531 L .35644 .55333 L p F P
0 g
s
.845 .711 .715 r
.34952 .56531 m .38142 .58473 L .3762 .59745 L p F P
0 g
s
.537 .47 .729 r
.66599 .57073 m .69605 .55161 L .70306 .56353 L p F P
0 g
s
.537 .47 .729 r
.70306 .56353 m .6717 .58328 L .66599 .57073 L p F P
0 g
s
.707 .696 .837 r
.50383 .44886 m .51833 .4507 L .51705 .46184 L p F P
0 g
s
.707 .696 .837 r
.51705 .46184 m .49979 .45966 L .50383 .44886 L p F P
0 g
s
.692 .682 .836 r
.53465 .46174 m .51705 .46184 L .51833 .4507 L p F P
0 g
s
.692 .682 .836 r
.51833 .4507 m .53314 .45062 L .53465 .46174 L p F P
0 g
s
.676 .671 .837 r
.55185 .45939 m .53465 .46174 L .53314 .45062 L p F P
0 g
s
.588 .575 .806 r
.64527 .4855 m .62448 .49951 L .61649 .48857 L p F P
0 g
s
.581 .56 .796 r
.62448 .49951 m .64527 .4855 L .65467 .49575 L p F P
0 g
s
0 0 .892 r
.57052 .76356 m .5704 .76388 L .58195 .76069 L closepath p F P
0 g
s
.529 .455 .716 r
.6717 .58328 m .70306 .56353 L .70961 .57564 L p F P
0 g
s
.529 .455 .716 r
.70961 .57564 m .67703 .59596 L .6717 .58328 L p F P
0 g
s
0 0 .822 r
.57061 .76147 m .57052 .76356 L .58195 .76069 L closepath p F P
0 g
s
0 0 .656 r
.57063 .75883 m .57061 .76147 L .58195 .76069 L closepath p F P
0 g
s
0 0 1 r
.007 w
.51819 .75983 m
.57062 .76054 L
s
.5 Mabswid
.782 .741 .815 r
.42603 .46716 m .44361 .47882 L .43552 .48952 L p F P
0 g
s
.782 .741 .815 r
.43552 .48952 m .41612 .47677 L .42603 .46716 L p F P
0 g
s
.845 .711 .715 r
.3762 .59745 m .34307 .57747 L .34952 .56531 L p F P
0 g
s
.85 .706 .702 r
.34307 .57747 m .3762 .59745 L .37137 .61026 L p F P
0 g
s
.741 .725 .836 r
.46926 .44895 m .48362 .45531 L .47714 .46583 L p F P
0 g
s
.741 .725 .836 r
.47714 .46583 m .4605 .45851 L .46926 .44895 L p F P
0 g
s
.595 .59 .817 r
.63554 .4756 m .61649 .48857 L .60824 .47795 L p F P
0 g
s
.588 .575 .806 r
.61649 .48857 m .63554 .4756 L .64527 .4855 L p F P
0 g
s
.828 .625 .628 r
.3985 .69169 m .35342 .67475 L .35614 .66189 L p F P
0 g
s
.83 .616 .613 r
.35342 .67475 m .3985 .69169 L .39684 .70455 L p F P
0 g
s
.72 .711 .841 r
.49025 .44518 m .50383 .44886 L .49979 .45966 L p F P
0 g
s
.72 .711 .841 r
.49979 .45966 m .48362 .45531 L .49025 .44518 L p F P
0 g
s
.657 .648 .83 r
.55185 .45939 m .56789 .45486 L .57458 .46531 L p F P
0 g
s
.637 .64 .837 r
.59101 .45781 m .57458 .46531 L .56789 .45486 L p F P
0 g
s
.633 .626 .826 r
.57458 .46531 m .59101 .45781 L .59974 .46769 L p F P
0 g
s
.676 .671 .837 r
.53314 .45062 m .54759 .44862 L .55185 .45939 L p F P
0 g
s
.659 .662 .841 r
.56789 .45486 m .55185 .45939 L .54759 .44862 L p F P
0 g
s
.741 .503 .57 r
.49979 .75925 m .44544 .75357 L .44582 .7413 L p F P
0 g
s
.521 .439 .703 r
.67703 .59596 m .70961 .57564 L .71568 .58791 L p F P
0 g
s
.521 .439 .703 r
.71568 .58791 m .68196 .60874 L .67703 .59596 L p F P
0 g
s
.773 .743 .826 r
.43621 .45795 m .45194 .46848 L .44361 .47882 L p F P
0 g
s
.773 .743 .826 r
.44361 .47882 m .42603 .46716 L .43621 .45795 L p F P
0 g
s
.85 .706 .702 r
.37137 .61026 m .33708 .58979 L .34307 .57747 L p F P
0 g
s
.855 .7 .689 r
.33708 .58979 m .37137 .61026 L .36693 .62314 L p F P
0 g
s
.542 .381 .613 r
.65567 .6905 m .70029 .67312 L .70261 .68589 L p F P
0 g
s
.542 .381 .613 r
.70261 .68589 m .65738 .70335 L .65567 .6905 L p F P
0 g
s
.787 .554 .583 r
.44582 .7413 m .39454 .72979 L .39552 .71726 L p F P
0 g
s
.787 .543 .567 r
.39454 .72979 m .44582 .7413 L .44544 .75357 L p F P
0 g
s
.602 .605 .827 r
.6255 .4661 m .60824 .47795 L .59974 .46769 L p F P
0 g
s
.595 .59 .817 r
.60824 .47795 m .6255 .4661 L .63554 .4756 L p F P
0 g
s
.587 .38 .567 r
.60879 .74057 m .65976 .72858 L .66041 .7409 L p F P
0 g
s
.587 .38 .567 r
.66041 .7409 m .60919 .75284 L .60879 .74057 L p F P
0 g
s
1 0 0 r
.007 w
.64797 .7438 m
.64799 .74441 L
s
0 1 0 r
.64799 .74441 m
.67272 .76924 L
s
.5 Mabswid
0 0 .805 r
.43465 .75362 m .43589 .75169 L .4458 .75772 L closepath p F P
0 g
s
0 0 .656 r
.43409 .75618 m .43465 .75362 L .4458 .75772 L closepath p F P
0 g
s
0 0 .406 r
.43454 .75789 m .43409 .75618 L .4458 .75772 L closepath p F P
0 g
s
0 0 .814 r
.43573 .75774 m .43454 .75789 L .4458 .75772 L closepath p F P
0 g
s
0 0 .859 r
.43698 .75582 m .43573 .75774 L .4458 .75772 L closepath p F P
0 g
s
0 0 .666 r
.43753 .75324 m .43698 .75582 L .4458 .75772 L closepath p F P
0 g
s
0 0 .946 r
.43589 .75169 m .43708 .75154 L .4458 .75772 L closepath p F P
0 g
s
0 0 .294 r
.43708 .75154 m .43753 .75324 L .4458 .75772 L closepath p F P
0 g
s
.512 .422 .69 r
.68196 .60874 m .71568 .58791 L .72125 .60032 L p F P
0 g
s
.512 .422 .69 r
.72125 .60032 m .68649 .62159 L .68196 .60874 L p F P
0 g
s
1 1 0 r
.007 w
.53247 .75665 m
.51129 .75651 L
s
.5536 .75589 m
.53247 .75665 L
s
.4902 .75548 m
.51129 .75651 L
s
.5 Mabswid
.763 .745 .836 r
.44666 .44917 m .4605 .45851 L .45194 .46848 L p F P
0 g
s
.763 .745 .836 r
.45194 .46848 m .43621 .45795 L .44666 .44917 L p F P
0 g
s
.701 .704 .85 r
.50795 .43844 m .51965 .43993 L .51833 .4507 L p F P
0 g
s
.701 .704 .85 r
.51833 .4507 m .50383 .44886 L .50795 .43844 L p F P
0 g
s
.688 .692 .849 r
.53314 .45062 m .51833 .4507 L .51965 .43993 L p F P
0 g
s
.855 .7 .689 r
.36693 .62314 m .33159 .60224 L .33708 .58979 L p F P
0 g
s
.86 .695 .675 r
.33159 .60224 m .36693 .62314 L .36291 .63605 L p F P
0 g
s
.688 .692 .849 r
.51965 .43993 m .53159 .43987 L .53314 .45062 L p F P
0 g
s
.675 .683 .85 r
.54759 .44862 m .53314 .45062 L .53159 .43987 L p F P
0 g
s
.732 .728 .847 r
.47821 .4398 m .49025 .44518 L .48362 .45531 L p F P
0 g
s
.732 .728 .847 r
.48362 .45531 m .46926 .44895 L .47821 .4398 L p F P
0 g
s
1 1 0 r
.007 w
.5536 .75589 m
.57458 .75424 L
s
.5 Mabswid
.83 .616 .613 r
.39684 .70455 m .35114 .68753 L .35342 .67475 L p F P
0 g
s
.832 .607 .597 r
.35114 .68753 m .39684 .70455 L .39552 .71726 L p F P
0 g
s
.609 .62 .837 r
.61517 .45699 m .59974 .46769 L .59101 .45781 L p F P
0 g
s
.602 .605 .827 r
.59974 .46769 m .61517 .45699 L .6255 .4661 L p F P
0 g
s
.659 .662 .841 r
.54759 .44862 m .56106 .44479 L .56789 .45486 L p F P
0 g
s
.641 .655 .848 r
.58208 .44834 m .56789 .45486 L .56106 .44479 L p F P
0 g
s
.637 .64 .837 r
.56789 .45486 m .58208 .44834 L .59101 .45781 L p F P
0 g
s
1 1 0 r
.007 w
.46929 .75356 m
.4902 .75548 L
s
.5 Mabswid
.504 .405 .676 r
.68649 .62159 m .72125 .60032 L .72631 .61284 L p F P
0 g
s
.504 .405 .676 r
.72631 .61284 m .6906 .63448 L .68649 .62159 L p F P
0 g
s
.712 .717 .853 r
.49702 .43546 m .50795 .43844 L .50383 .44886 L p F P
0 g
s
.712 .717 .853 r
.50383 .44886 m .49025 .44518 L .49702 .43546 L p F P
0 g
s
.534 .364 .597 r
.65738 .70335 m .70261 .68589 L .70446 .69856 L p F P
0 g
s
.534 .364 .597 r
.70446 .69856 m .65875 .71606 L .65738 .70335 L p F P
0 g
s
.675 .683 .85 r
.53159 .43987 m .54324 .43825 L .54759 .44862 L p F P
0 g
s
.66 .675 .853 r
.56106 .44479 m .54759 .44862 L .54324 .43825 L p F P
0 g
s
1 1 0 r
.007 w
.57458 .75424 m
.59529 .75171 L
s
.5 Mabswid
0 .784 0 r
.76678 .60109 m .76816 .59945 L .77731 .60217 L closepath p F P
0 g
s
0 .659 0 r
.76667 .60372 m .76678 .60109 L .77731 .60217 L closepath p F P
0 g
s
0 .48 0 r
.7679 .60581 m .76667 .60372 L .77731 .60217 L closepath p F P
0 g
s
0 0 0 r
.76975 .60614 m .7679 .60581 L .77731 .60217 L closepath p F P
0 g
s
0 .996 0 r
.77114 .6045 m .76975 .60614 L .77731 .60217 L closepath p F P
0 g
s
0 .785 0 r
.77125 .60187 m .77114 .6045 L .77731 .60217 L closepath p F P
0 g
s
0 .54 0 r
.76816 .59945 m .77001 .59977 L .77731 .60217 L closepath p F P
0 g
s
0 .489 0 r
.77001 .59977 m .77125 .60187 L .77731 .60217 L closepath p F P
0 g
s
.753 .746 .846 r
.45735 .44083 m .46926 .44895 L .4605 .45851 L p F P
0 g
s
.753 .746 .846 r
.4605 .45851 m .44666 .44917 L .45735 .44083 L p F P
0 g
s
.86 .695 .675 r
.36291 .63605 m .3266 .61479 L .33159 .60224 L p F P
0 g
s
.865 .688 .661 r
.3266 .61479 m .36291 .63605 L .35931 .64898 L p F P
0 g
s
.787 .543 .567 r
.44544 .75357 m .39391 .7421 L .39454 .72979 L p F P
0 g
s
0 0 1 r
.007 w
.42485 .75142 m
.43713 .75511 L
s
.39884 .7436 m
.42485 .75142 L
s
1 1 0 r
.46929 .75356 m
.44868 .75075 L
s
.5 Mabswid
.616 .635 .847 r
.60459 .44832 m .59101 .45781 L .58208 .44834 L p F P
0 g
s
.609 .62 .837 r
.59101 .45781 m .60459 .44832 L .61517 .45699 L p F P
0 g
s
.494 .387 .661 r
.6906 .63448 m .72631 .61284 L .73084 .62544 L p F P
0 g
s
.494 .387 .661 r
.73084 .62544 m .69427 .64738 L .6906 .63448 L p F P
0 g
s
.722 .732 .858 r
.48733 .4311 m .49702 .43546 L .49025 .44518 L p F P
0 g
s
.722 .732 .858 r
.49025 .44518 m .47821 .4398 L .48733 .4311 L p F P
0 g
s
1 1 0 r
.007 w
.59529 .75171 m
.61562 .74829 L
s
.5 Mabswid
.832 .607 .597 r
.39552 .71726 m .34933 .7002 L .35114 .68753 L p F P
0 g
s
.834 .597 .58 r
.34933 .7002 m .39552 .71726 L .39454 .72979 L p F P
0 g
s
.66 .675 .853 r
.54324 .43825 m .55409 .43515 L .56106 .44479 L p F P
0 g
s
.645 .67 .859 r
.57295 .43929 m .56106 .44479 L .55409 .43515 L p F P
0 g
s
.641 .655 .848 r
.56106 .44479 m .57295 .43929 L .58208 .44834 L p F P
0 g
s
.694 .713 .862 r
.51215 .42845 m .52099 .42958 L .51965 .43993 L p F P
0 g
s
.694 .713 .862 r
.51965 .43993 m .50795 .43844 L .51215 .42845 L p F P
0 g
s
.684 .703 .862 r
.53159 .43987 m .51965 .43993 L .52099 .42958 L p F P
0 g
s
.684 .703 .862 r
.52099 .42958 m .53001 .42953 L .53159 .43987 L p F P
0 g
s
.673 .695 .863 r
.54324 .43825 m .53159 .43987 L .53001 .42953 L p F P
0 g
s
1 1 0 r
.007 w
.42849 .74707 m
.44868 .75075 L
s
.5 Mabswid
.742 .747 .856 r
.46825 .43296 m .47821 .4398 L .46926 .44895 L p F P
0 g
s
.742 .747 .856 r
.46926 .44895 m .45735 .44083 L .46825 .43296 L p F P
0 g
s
.865 .688 .661 r
.35931 .64898 m .32214 .62742 L .3266 .61479 L p F P
0 g
s
.87 .681 .645 r
.32214 .62742 m .35931 .64898 L .35614 .66189 L p F P
0 g
s
.818 .774 .811 r
.39042 .47045 m .40652 .48675 L .39724 .4971 L p F P
0 g
s
.818 .774 .811 r
.39724 .4971 m .37978 .4796 L .39042 .47045 L p F P
0 g
s
.828 .774 .801 r
.37978 .4796 m .39724 .4971 L .38831 .50777 L p F P
0 g
s
.828 .774 .801 r
.38831 .50777 m .36952 .48916 L .37978 .4796 L p F P
0 g
s
.837 .773 .79 r
.36952 .48916 m .38831 .50777 L .37975 .51876 L p F P
0 g
s
.526 .346 .58 r
.65875 .71606 m .70446 .69856 L .70584 .7111 L p F P
0 g
s
.526 .346 .58 r
.70584 .7111 m .65976 .72858 L .65875 .71606 L p F P
0 g
s
.808 .774 .821 r
.40142 .4617 m .41612 .47677 L .40652 .48675 L p F P
0 g
s
.808 .774 .821 r
.40652 .48675 m .39042 .47045 L .40142 .4617 L p F P
0 g
s
.623 .651 .857 r
.59376 .44009 m .58208 .44834 L .57295 .43929 L p F P
0 g
s
.616 .635 .847 r
.58208 .44834 m .59376 .44009 L .60459 .44832 L p F P
0 g
s
.837 .773 .79 r
.37975 .51876 m .35966 .4991 L .36952 .48916 L p F P
0 g
s
.847 .772 .779 r
.35966 .4991 m .37975 .51876 L .37157 .53003 L p F P
0 g
s
.797 .773 .831 r
.41275 .4534 m .42603 .46716 L .41612 .47677 L p F P
0 g
s
.797 .773 .831 r
.41612 .47677 m .40142 .4617 L .41275 .4534 L p F P
0 g
s
.704 .723 .865 r
.5039 .42618 m .51215 .42845 L .50795 .43844 L p F P
0 g
s
.704 .723 .865 r
.50795 .43844 m .49702 .43546 L .5039 .42618 L p F P
0 g
s
.673 .695 .863 r
.53001 .42953 m .53881 .4283 L .54324 .43825 L p F P
0 g
s
.661 .689 .865 r
.55409 .43515 m .54324 .43825 L .53881 .4283 L p F P
0 g
s
.542 .55 .813 r
.67165 .47806 m .65467 .49575 L .64527 .4855 L p F P
0 g
s
.531 .533 .802 r
.65467 .49575 m .67165 .47806 L .682 .48752 L p F P
0 g
s
.531 .533 .802 r
.682 .48752 m .66372 .50634 L .65467 .49575 L p F P
0 g
s
.552 .567 .823 r
.66091 .46901 m .64527 .4855 L .63554 .4756 L p F P
0 g
s
.542 .55 .813 r
.64527 .4855 m .66091 .46901 L .67165 .47806 L p F P
0 g
s
.52 .516 .792 r
.66372 .50634 m .682 .48752 L .69194 .49736 L p F P
0 g
s
.52 .516 .792 r
.69194 .49736 m .67241 .51725 L .66372 .50634 L p F P
0 g
s
.847 .772 .779 r
.37157 .53003 m .35024 .50939 L .35966 .4991 L p F P
0 g
s
0 1 0 r
.007 w
.33236 .49342 m
.35259 .50682 L
s
.5 Mabswid
.856 .77 .767 r
.35024 .50939 m .37157 .53003 L .36379 .54156 L p F P
0 g
s
.485 .368 .646 r
.69427 .64738 m .73084 .62544 L .73484 .63808 L p F P
0 g
s
.485 .368 .646 r
.73484 .63808 m .69751 .66027 L .69427 .64738 L p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 .879 0 r
.52207 .3607 m .52179 .35903 L .52513 .35067 L closepath p F P
0 g
s
0 .641 0 r
.52414 .36176 m .52207 .3607 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .493 0 r
.52678 .36159 m .52414 .36176 L .52513 .35067 L closepath p F P
0 g
s
0 .331 0 r
.52846 .36028 m .52678 .36159 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52819 .35861 m .52846 .36028 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
0 0 0 r
.52179 .35903 m .52347 .35772 L .52513 .35067 L closepath p F P
0 g
s
0 .474 0 r
.52612 .35754 m .52819 .35861 L .52513 .35067 L closepath p F P
0 g
s
0 .303 0 r
.52347 .35772 m .52612 .35754 L .52513 .35067 L closepath p F P
0 g
s
.786 .772 .841 r
.42438 .44555 m .43621 .45795 L .42603 .46716 L p F P
0 g
s
.786 .772 .841 r
.42603 .46716 m .41275 .4534 L .42438 .44555 L p F P
0 g
s
.563 .584 .833 r
.64981 .46038 m .63554 .4756 L .6255 .4661 L p F P
0 g
s
.552 .567 .823 r
.63554 .4756 m .64981 .46038 L .66091 .46901 L p F P
0 g
s
.509 .498 .78 r
.67241 .51725 m .69194 .49736 L .70145 .50756 L p F P
0 g
s
0 1 0 r
.007 w
.70048 .50652 m
.71137 .4994 L
s
.5 Mabswid
.509 .498 .78 r
.70145 .50756 m .6807 .52844 L .67241 .51725 L p F P
0 g
s
1 1 0 r
.007 w
.61562 .74829 m
.63545 .74402 L
s
.5 Mabswid
.856 .77 .767 r
.36379 .54156 m .34127 .52001 L .35024 .50939 L p F P
0 g
s
.864 .768 .755 r
.34127 .52001 m .36379 .54156 L .35644 .55333 L p F P
0 g
s
.573 .6 .842 r
.63839 .45219 m .6255 .4661 L .61517 .45699 L p F P
0 g
s
.563 .584 .833 r
.6255 .4661 m .63839 .45219 L .64981 .46038 L p F P
0 g
s
.498 .48 .768 r
.6807 .52844 m .70145 .50756 L .7105 .5181 L p F P
0 g
s
.498 .48 .768 r
.7105 .5181 m .68859 .53991 L .6807 .52844 L p F P
0 g
s
.774 .771 .85 r
.43629 .43818 m .44666 .44917 L .43621 .45795 L p F P
0 g
s
.774 .771 .85 r
.43621 .45795 m .42438 .44555 L .43629 .43818 L p F P
0 g
s
0 1 0 r
.007 w
.4209 .41103 m
.43483 .43909 L
s
.5 Mabswid
.73 .748 .866 r
.47934 .42557 m .48733 .4311 L .47821 .4398 L p F P
0 g
s
.73 .748 .866 r
.47821 .4398 m .46825 .43296 L .47934 .42557 L p F P
0 g
s
.87 .681 .645 r
.35614 .66189 m .3182 .64008 L .32214 .62742 L p F P
0 g
s
.874 .674 .629 r
.3182 .64008 m .35614 .66189 L .35342 .67475 L p F P
0 g
s
.711 .735 .87 r
.4966 .42288 m .5039 .42618 L .49702 .43546 L p F P
0 g
s
.711 .735 .87 r
.49702 .43546 m .48733 .4311 L .4966 .42288 L p F P
0 g
s
0 .351 0 r
.27429 .59704 m .27279 .5987 L .26367 .59447 L closepath p F P
0 g
s
0 .49 0 r
.27466 .5944 m .27429 .59704 L .26367 .59447 L closepath p F P
0 g
s
0 .631 0 r
.27369 .59231 m .27466 .5944 L .26367 .59447 L closepath p F P
0 g
s
0 .278 0 r
.27007 .5963 m .27044 .59366 L .26367 .59447 L closepath p F P
0 g
s
0 0 0 r
.27279 .5987 m .27105 .59839 L .26367 .59447 L closepath p F P
0 g
s
0 .421 0 r
.27105 .59839 m .27007 .5963 L .26367 .59447 L closepath p F P
0 g
s
0 .852 0 r
.27194 .592 m .27369 .59231 L .26367 .59447 L closepath p F P
0 g
s
0 0 0 r
.27044 .59366 m .27194 .592 L .26367 .59447 L closepath p F P
0 g
s
1 1 0 r
.007 w
.40883 .74253 m
.42849 .74707 L
s
.5 Mabswid
.834 .597 .58 r
.39454 .72979 m .34799 .71274 L .34933 .7002 L p F P
0 g
s
.835 .586 .562 r
.34799 .71274 m .39454 .72979 L .39391 .7421 L p F P
0 g
s
0 0 1 r
.007 w
.3943 .74224 m
.39884 .7436 L
s
.5 Mabswid
.661 .689 .865 r
.53881 .4283 m .547 .42594 L .55409 .43515 L p F P
0 g
s
.649 .685 .87 r
.56365 .43069 m .55409 .43515 L .547 .42594 L p F P
0 g
s
.645 .67 .859 r
.55409 .43515 m .56365 .43069 L .57295 .43929 L p F P
0 g
s
.63 .667 .867 r
.58272 .43234 m .57295 .43929 L .56365 .43069 L p F P
0 g
s
.623 .651 .857 r
.57295 .43929 m .58272 .43234 L .59376 .44009 L p F P
0 g
s
.583 .617 .851 r
.62666 .44446 m .61517 .45699 L .60459 .44832 L p F P
0 g
s
.573 .6 .842 r
.61517 .45699 m .62666 .44446 L .63839 .45219 L p F P
0 g
s
.486 .462 .756 r
.68859 .53991 m .7105 .5181 L .71908 .52895 L p F P
0 g
s
.486 .462 .756 r
.71908 .52895 m .69605 .55161 L .68859 .53991 L p F P
0 g
s
.864 .768 .755 r
.35644 .55333 m .33278 .53094 L .34127 .52001 L p F P
0 g
s
.873 .766 .742 r
.33278 .53094 m .35644 .55333 L .34952 .56531 L p F P
0 g
s
.762 .769 .859 r
.44846 .4313 m .45735 .44083 L .44666 .44917 L p F P
0 g
s
.762 .769 .859 r
.44666 .44917 m .43629 .43818 L .44846 .4313 L p F P
0 g
s
.518 .327 .562 r
.65976 .72858 m .70584 .7111 L .70672 .72347 L p F P
0 g
s
.518 .327 .562 r
.70672 .72347 m .66041 .7409 L .65976 .72858 L p F P
0 g
s
.474 .349 .629 r
.69751 .66027 m .73484 .63808 L .73827 .65075 L p F P
0 g
s
.474 .349 .629 r
.73827 .65075 m .70029 .67312 L .69751 .66027 L p F P
0 g
s
.594 .633 .86 r
.61464 .43722 m .60459 .44832 L .59376 .44009 L p F P
0 g
s
.583 .617 .851 r
.60459 .44832 m .61464 .43722 L .62666 .44446 L p F P
0 g
s
0 1 0 r
.007 w
.61479 .43731 m
.62604 .41426 L
s
.5 Mabswid
.474 .443 .743 r
.69605 .55161 m .71908 .52895 L .72715 .5401 L p F P
0 g
s
.474 .443 .743 r
.72715 .5401 m .70306 .56353 L .69605 .55161 L p F P
0 g
s
.687 .721 .876 r
.51642 .4189 m .52235 .41966 L .52099 .42958 L p F P
0 g
s
.687 .721 .876 r
.52099 .42958 m .51215 .42845 L .51642 .4189 L p F P
0 g
s
.679 .714 .875 r
.53001 .42953 m .52099 .42958 L .52235 .41966 L p F P
0 g
s
.679 .714 .875 r
.52235 .41966 m .5284 .41963 L .53001 .42953 L p F P
0 g
s
.671 .708 .876 r
.53881 .4283 m .53001 .42953 L .5284 .41963 L p F P
0 g
s
.873 .766 .742 r
.34952 .56531 m .32478 .54215 L .33278 .53094 L p F P
0 g
s
.881 .763 .728 r
.32478 .54215 m .34952 .56531 L .34307 .57747 L p F P
0 g
s
0 0 1 r
.007 w
.64799 .74441 m
.65849 .74162 L
s
.65849 .74162 m
.66688 .73939 L
s
.5 Mabswid
.694 .729 .878 r
.51089 .41737 m .51642 .4189 L .51215 .42845 L p F P
0 g
s
.694 .729 .878 r
.51215 .42845 m .5039 .42618 L .51089 .41737 L p F P
0 g
s
1 1 0 r
.007 w
.63545 .74402 m
.65467 .73889 L
s
.5 Mabswid
.671 .708 .876 r
.5284 .41963 m .53431 .4188 L .53881 .4283 L p F P
0 g
s
.662 .704 .878 r
.547 .42594 m .53881 .4283 L .53431 .4188 L p F P
0 g
s
.749 .767 .867 r
.46084 .42493 m .46825 .43296 L .45735 .44083 L p F P
0 g
s
.749 .767 .867 r
.45735 .44083 m .44846 .4313 L .46084 .42493 L p F P
0 g
s
.717 .748 .876 r
.4906 .41868 m .4966 .42288 L .48733 .4311 L p F P
0 g
s
.717 .748 .876 r
.48733 .4311 m .47934 .42557 L .4906 .41868 L p F P
0 g
s
.874 .674 .629 r
.35342 .67475 m .31482 .65277 L .3182 .64008 L p F P
0 g
s
.878 .666 .612 r
.31482 .65277 m .35342 .67475 L .35114 .68753 L p F P
0 g
s
.604 .65 .868 r
.60238 .43047 m .59376 .44009 L .58272 .43234 L p F P
0 g
s
.594 .633 .86 r
.59376 .44009 m .60238 .43047 L .61464 .43722 L p F P
0 g
s
.649 .685 .87 r
.547 .42594 m .5542 .42256 L .56365 .43069 L p F P
0 g
s
.637 .683 .877 r
.57148 .42507 m .56365 .43069 L .5542 .42256 L p F P
0 g
s
.63 .667 .867 r
.56365 .43069 m .57148 .42507 L .58272 .43234 L p F P
0 g
s
.461 .423 .73 r
.70306 .56353 m .72715 .5401 L .73469 .55151 L p F P
0 g
s
.461 .423 .73 r
.73469 .55151 m .70961 .57564 L .70306 .56353 L p F P
0 g
s
.881 .763 .728 r
.34307 .57747 m .31731 .55363 L .32478 .54215 L p F P
0 g
s
.888 .76 .714 r
.31731 .55363 m .34307 .57747 L .33708 .58979 L p F P
0 g
s
.699 .738 .881 r
.50601 .41514 m .51089 .41737 L .5039 .42618 L p F P
0 g
s
.699 .738 .881 r
.5039 .42618 m .4966 .42288 L .50601 .41514 L p F P
0 g
s
.835 .586 .562 r
.39391 .7421 m .34712 .7251 L .34799 .71274 L p F P
0 g
s
1 1 0 r
.007 w
.38982 .73715 m
.40883 .74253 L
s
0 1 0 r
.36258 .76499 m
.3898 .74088 L
s
0 0 1 r
.3898 .74088 m
.3936 .74203 L
s
.3936 .74203 m
.3943 .74224 L
s
1 0 0 r
.3898 .74088 m
.38981 .74061 L
s
.5 Mabswid
.662 .704 .878 r
.53431 .4188 m .53979 .41721 L .547 .42594 L p F P
0 g
s
.653 .701 .882 r
.5542 .42256 m .547 .42594 L .53979 .41721 L p F P
0 g
s
.464 .329 .612 r
.70029 .67312 m .73827 .65075 L .74114 .66341 L p F P
0 g
s
.464 .329 .612 r
.74114 .66341 m .70261 .68589 L .70029 .67312 L p F P
0 g
s
0 .884 0 r
.64168 .38038 m .64144 .37859 L .64869 .37184 L closepath p F P
0 g
s
0 0 0 r
.64144 .37859 m .64304 .37772 L .64869 .37184 L closepath p F P
0 g
s
0 .637 0 r
.6436 .38204 m .64168 .38038 L .64869 .37184 L closepath p F P
0 g
s
0 .452 0 r
.6461 .3826 m .6436 .38204 L .64869 .37184 L closepath p F P
0 g
s
0 .132 0 r
.6477 .38172 m .6461 .3826 L .64869 .37184 L closepath p F P
0 g
s
0 .771 0 r
.64747 .37993 m .6477 .38172 L .64869 .37184 L closepath p F P
0 g
s
0 .577 0 r
.64553 .37827 m .64747 .37993 L .64869 .37184 L closepath p F P
0 g
s
0 .303 0 r
.64304 .37772 m .64553 .37827 L .64869 .37184 L closepath p F P
0 g
s
.735 .764 .876 r
.47342 .41909 m .47934 .42557 L .46825 .43296 L p F P
0 g
s
.735 .764 .876 r
.46825 .43296 m .46084 .42493 L .47342 .41909 L p F P
0 g
s
.614 .666 .877 r
.58989 .42423 m .58272 .43234 L .57148 .42507 L p F P
0 g
s
.604 .65 .868 r
.58272 .43234 m .58989 .42423 L .60238 .43047 L p F P
0 g
s
.448 .403 .715 r
.70961 .57564 m .73469 .55151 L .74169 .56317 L p F P
0 g
s
.448 .403 .715 r
.74169 .56317 m .71568 .58791 L .70961 .57564 L p F P
0 g
s
.888 .76 .714 r
.33708 .58979 m .31038 .56533 L .31731 .55363 L p F P
0 g
s
.896 .756 .699 r
.31038 .56533 m .33708 .58979 L .33159 .60224 L p F P
0 g
s
.703 .747 .886 r
.502 .41232 m .50601 .41514 L .4966 .42288 L p F P
0 g
s
.703 .747 .886 r
.4966 .42288 m .4906 .41868 L .502 .41232 L p F P
0 g
s
.878 .666 .612 r
.35114 .68753 m .31199 .66544 L .31482 .65277 L p F P
0 g
s
.881 .656 .593 r
.31199 .66544 m .35114 .68753 L .34933 .7002 L p F P
0 g
s
.653 .701 .882 r
.53979 .41721 m .54461 .41493 L .5542 .42256 L p F P
0 g
s
.644 .7 .887 r
.56008 .4183 m .5542 .42256 L .54461 .41493 L p F P
0 g
s
.637 .683 .877 r
.5542 .42256 m .56008 .4183 L .57148 .42507 L p F P
0 g
s
.721 .761 .884 r
.48617 .41378 m .4906 .41868 L .47934 .42557 L p F P
0 g
s
.721 .761 .884 r
.47934 .42557 m .47342 .41909 L .48617 .41378 L p F P
0 g
s
1 1 0 r
.007 w
.65467 .73889 m
.67317 .73294 L
s
.5 Mabswid
.678 .73 .889 r
.52075 .40982 m .52373 .4102 L .52235 .41966 L p F P
0 g
s
.678 .73 .889 r
.52235 .41966 m .51642 .4189 L .52075 .40982 L p F P
0 g
s
.673 .726 .889 r
.5284 .41963 m .52235 .41966 L .52373 .4102 L p F P
0 g
s
.673 .726 .889 r
.52373 .4102 m .52677 .41019 L .5284 .41963 L p F P
0 g
s
.668 .722 .889 r
.53431 .4188 m .5284 .41963 L .52677 .41019 L p F P
0 g
s
.625 .683 .885 r
.57721 .41852 m .57148 .42507 L .56008 .4183 L p F P
0 g
s
.614 .666 .877 r
.57148 .42507 m .57721 .41852 L .58989 .42423 L p F P
0 g
s
0 .608 0 r
.40266 .37809 m .40221 .37656 L .40128 .36761 L closepath p F P
0 g
s
0 .598 0 r
.40473 .37845 m .40266 .37809 L .40128 .36761 L closepath p F P
0 g
s
0 .516 0 r
.4072 .37742 m .40473 .37845 L .40128 .36761 L closepath p F P
0 g
s
0 .144 0 r
.40221 .37656 m .40364 .37475 L .40128 .36761 L closepath p F P
0 g
s
0 .456 0 r
.40863 .37562 m .4072 .37742 L .40128 .36761 L closepath p F P
0 g
s
0 .282 0 r
.40818 .37408 m .40863 .37562 L .40128 .36761 L closepath p F P
0 g
s
0 .299 0 r
.40611 .37372 m .40818 .37408 L .40128 .36761 L closepath p F P
0 g
s
0 .308 0 r
.40364 .37475 m .40611 .37372 L .40128 .36761 L closepath p F P
0 g
s
.435 .382 .7 r
.71568 .58791 m .74169 .56317 L .74812 .57503 L p F P
0 g
s
.435 .382 .7 r
.74812 .57503 m .72125 .60032 L .71568 .58791 L p F P
0 g
s
.682 .735 .891 r
.51797 .40905 m .52075 .40982 L .51642 .4189 L p F P
0 g
s
.682 .735 .891 r
.51642 .4189 m .51089 .41737 L .51797 .40905 L p F P
0 g
s
.668 .722 .889 r
.52677 .41019 m .52974 .40977 L .53431 .4188 L p F P
0 g
s
.662 .719 .891 r
.53979 .41721 m .53431 .4188 L .52974 .40977 L p F P
0 g
s
.452 .307 .593 r
.70261 .68589 m .74114 .66341 L .74342 .67603 L p F P
0 g
s
.452 .307 .593 r
.74342 .67603 m .70446 .69856 L .70261 .68589 L p F P
0 g
s
.795 .804 .859 r
.41705 .4318 m .42438 .44555 L .41275 .4534 L p F P
0 g
s
.795 .804 .859 r
.41275 .4534 m .40446 .43811 L .41705 .4318 L p F P
0 g
s
.808 .808 .851 r
.40446 .43811 m .41275 .4534 L .40142 .4617 L p F P
0 g
s
.781 .799 .867 r
.42992 .42602 m .43629 .43818 L .42438 .44555 L p F P
0 g
s
.781 .799 .867 r
.42438 .44555 m .41705 .4318 L .42992 .42602 L p F P
0 g
s
.896 .756 .699 r
.33159 .60224 m .30401 .57725 L .31038 .56533 L p F P
0 g
s
.903 .751 .683 r
.30401 .57725 m .33159 .60224 L .3266 .61479 L p F P
0 g
s
1 1 0 r
.007 w
.37157 .73095 m
.38982 .73715 L
s
.5 Mabswid
.808 .808 .851 r
.40142 .4617 m .39218 .44494 L .40446 .43811 L p F P
0 g
s
.821 .812 .842 r
.39218 .44494 m .40142 .4617 L .39042 .47045 L p F P
0 g
s
.685 .741 .893 r
.51552 .40792 m .51797 .40905 L .51089 .41737 L p F P
0 g
s
.685 .741 .893 r
.51089 .41737 m .50601 .41514 L .51552 .40792 L p F P
0 g
s
.767 .793 .874 r
.44303 .42077 m .44846 .4313 L .43629 .43818 L p F P
0 g
s
.767 .793 .874 r
.43629 .43818 m .42992 .42602 L .44303 .42077 L p F P
0 g
s
.662 .719 .891 r
.52974 .40977 m .5325 .40897 L .53979 .41721 L p F P
0 g
s
.657 .717 .893 r
.54461 .41493 m .53979 .41721 L .5325 .40897 L p F P
0 g
s
.821 .812 .842 r
.39042 .47045 m .38024 .45227 L .39218 .44494 L p F P
0 g
s
.834 .816 .832 r
.38024 .45227 m .39042 .47045 L .37978 .4796 L p F P
0 g
s
.556 .617 .868 r
.63359 .43063 m .62666 .44446 L .61464 .43722 L p F P
0 g
s
.542 .599 .861 r
.62666 .44446 m .63359 .43063 L .64623 .43681 L p F P
0 g
s
.542 .599 .861 r
.64623 .43681 m .63839 .45219 L .62666 .44446 L p F P
0 g
s
.527 .581 .852 r
.63839 .45219 m .64623 .43681 L .65857 .4435 L p F P
0 g
s
.527 .581 .852 r
.65857 .4435 m .64981 .46038 L .63839 .45219 L p F P
0 g
s
.753 .787 .881 r
.45636 .41608 m .46084 .42493 L .44846 .4313 L p F P
0 g
s
.753 .787 .881 r
.44846 .4313 m .44303 .42077 L .45636 .41608 L p F P
0 g
s
.705 .757 .892 r
.49906 .40903 m .502 .41232 L .4906 .41868 L p F P
0 g
s
.705 .757 .892 r
.4906 .41868 m .48617 .41378 L .49906 .40903 L p F P
0 g
s
.571 .635 .876 r
.62067 .42498 m .61464 .43722 L .60238 .43047 L p F P
0 g
s
.556 .617 .868 r
.61464 .43722 m .62067 .42498 L .63359 .43063 L p F P
0 g
s
.512 .562 .844 r
.64981 .46038 m .65857 .4435 L .67056 .45071 L p F P
0 g
s
.512 .562 .844 r
.67056 .45071 m .66091 .46901 L .64981 .46038 L p F P
0 g
s
.644 .7 .887 r
.54461 .41493 m .54854 .41207 L .56008 .4183 L p F P
0 g
s
.635 .7 .893 r
.56437 .41335 m .56008 .4183 L .54854 .41207 L p F P
0 g
s
.625 .683 .885 r
.56008 .4183 m .56437 .41335 L .57721 .41852 L p F P
0 g
s
.834 .816 .832 r
.37978 .4796 m .36867 .46008 L .38024 .45227 L p F P
0 g
s
.846 .819 .822 r
.36867 .46008 m .37978 .4796 L .36952 .48916 L p F P
0 g
s
.421 .36 .684 r
.72125 .60032 m .74812 .57503 L .75397 .58709 L p F P
0 g
s
.421 .36 .684 r
.75397 .58709 m .72631 .61284 L .72125 .60032 L p F P
0 g
s
.585 .652 .882 r
.6075 .41988 m .60238 .43047 L .58989 .42423 L p F P
0 g
s
.571 .635 .876 r
.60238 .43047 m .6075 .41988 L .62067 .42498 L p F P
0 g
s
.496 .543 .834 r
.66091 .46901 m .67056 .45071 L .68219 .4584 L p F P
0 g
s
.496 .543 .834 r
.68219 .4584 m .67165 .47806 L .66091 .46901 L p F P
0 g
s
.688 .746 .896 r
.51352 .4065 m .51552 .40792 L .50601 .41514 L p F P
0 g
s
.688 .746 .896 r
.50601 .41514 m .502 .41232 L .51352 .4065 L p F P
0 g
s
.738 .781 .887 r
.46987 .41195 m .47342 .41909 L .46084 .42493 L p F P
0 g
s
.738 .781 .887 r
.46084 .42493 m .45636 .41608 L .46987 .41195 L p F P
0 g
s
.881 .656 .593 r
.34933 .7002 m .30974 .67806 L .31199 .66544 L p F P
0 g
s
.884 .646 .573 r
.30974 .67806 m .34933 .7002 L .34799 .71274 L p F P
0 g
s
.657 .717 .893 r
.5325 .40897 m .53491 .40782 L .54461 .41493 L p F P
0 g
s
.651 .717 .896 r
.54854 .41207 m .54461 .41493 L .53491 .40782 L p F P
0 g
s
.846 .819 .822 r
.36952 .48916 m .35749 .46835 L .36867 .46008 L p F P
0 g
s
.858 .821 .811 r
.35749 .46835 m .36952 .48916 L .35966 .4991 L p F P
0 g
s
.599 .669 .888 r
.59412 .41533 m .58989 .42423 L .57721 .41852 L p F P
0 g
s
.585 .652 .882 r
.58989 .42423 m .59412 .41533 L .6075 .41988 L p F P
0 g
s
.48 .523 .824 r
.67165 .47806 m .68219 .4584 L .69342 .46656 L p F P
0 g
s
.48 .523 .824 r
.69342 .46656 m .682 .48752 L .67165 .47806 L p F P
0 g
s
.903 .751 .683 r
.3266 .61479 m .29822 .58935 L .30401 .57725 L p F P
0 g
s
.91 .746 .666 r
.29822 .58935 m .3266 .61479 L .32214 .62742 L p F P
0 g
s
0 0 .852 r
.69689 .73061 m .69579 .72861 L .70658 .72883 L closepath p F P
0 g
s
0 0 .666 r
.69744 .73322 m .69689 .73061 L .70658 .72883 L closepath p F P
0 g
s
.722 .774 .893 r
.48354 .4084 m .48617 .41378 L .47342 .41909 L p F P
0 g
s
.722 .774 .893 r
.47342 .41909 m .46987 .41195 L .48354 .4084 L p F P
0 g
s
.44 .284 .573 r
.70446 .69856 m .74342 .67603 L .74512 .68858 L p F P
0 g
s
.44 .284 .573 r
.74512 .68858 m .70584 .7111 L .70446 .69856 L p F P
0 g
s
0 0 .325 r
.69711 .73492 m .69744 .73322 L .70658 .72883 L closepath p F P
0 g
s
.613 .686 .894 r
.58056 .41135 m .57721 .41852 L .56437 .41335 L p F P
0 g
s
.599 .669 .888 r
.57721 .41852 m .58056 .41135 L .59412 .41533 L p F P
0 g
s
.464 .503 .813 r
.682 .48752 m .69342 .46656 L .70423 .47519 L p F P
0 g
s
.464 .503 .813 r
.70423 .47519 m .69194 .49736 L .682 .48752 L p F P
0 g
s
.858 .821 .811 r
.35966 .4991 m .34674 .47708 L .35749 .46835 L p F P
0 g
s
.87 .824 .8 r
.34674 .47708 m .35966 .4991 L .35024 .50939 L p F P
0 g
s
0 0 .845 r
.69579 .72861 m .69478 .7284 L .70658 .72883 L closepath p F P
0 g
s
1 1 0 r
.007 w
.67317 .73294 m
.69083 .72618 L
s
.5 Mabswid
.689 .752 .9 r
.51205 .40485 m .51352 .4065 L .502 .41232 L p F P
0 g
s
.689 .752 .9 r
.502 .41232 m .49906 .40903 L .51205 .40485 L p F P
0 g
s
.651 .717 .896 r
.53491 .40782 m .53688 .40637 L .54854 .41207 L p F P
0 g
s
.646 .717 .9 r
.55138 .40874 m .54854 .41207 L .53688 .40637 L p F P
0 g
s
.635 .7 .893 r
.54854 .41207 m .55138 .40874 L .56437 .41335 L p F P
0 g
s
.406 .336 .666 r
.72631 .61284 m .75397 .58709 L .75921 .5993 L p F P
0 g
s
0 1 0 r
.007 w
.74666 .60446 m
.77121 .60262 L
s
.5 Mabswid
.406 .336 .666 r
.75921 .5993 m .73084 .62544 L .72631 .61284 L p F P
0 g
s
.668 .739 .904 r
.52373 .4102 m .52075 .40982 L .52513 .40124 L closepath p F P
0 g
s
.666 .738 .903 r
.52677 .41019 m .52373 .4102 L .52513 .40124 L closepath p F P
0 g
s
.664 .736 .904 r
.52974 .40977 m .52677 .41019 L .52513 .40124 L closepath p F P
0 g
s
.706 .766 .899 r
.49732 .40542 m .49906 .40903 L .48617 .41378 L p F P
0 g
s
.706 .766 .899 r
.48617 .41378 m .48354 .4084 L .49732 .40542 L p F P
0 g
s
.669 .741 .904 r
.52075 .40982 m .51797 .40905 L .52513 .40124 L closepath p F P
0 g
s
0 0 .946 r
.69609 .73471 m .69711 .73492 L .70658 .72883 L closepath p F P
0 g
s
.662 .735 .904 r
.5325 .40897 m .52974 .40977 L .52513 .40124 L closepath p F P
0 g
s
.627 .702 .9 r
.56685 .40794 m .56437 .41335 L .55138 .40874 L p F P
0 g
s
.613 .686 .894 r
.56437 .41335 m .56685 .40794 L .58056 .41135 L p F P
0 g
s
.447 .481 .802 r
.69194 .49736 m .70423 .47519 L .71458 .48424 L p F P
0 g
s
.447 .481 .802 r
.71458 .48424 m .70145 .50756 L .69194 .49736 L p F P
0 g
s
0 0 .401 r
.69478 .7284 m .69445 .73009 L .70658 .72883 L closepath p F P
0 g
s
.87 .824 .8 r
.35024 .50939 m .33645 .48624 L .34674 .47708 L p F P
0 g
s
.882 .825 .788 r
.33645 .48624 m .35024 .50939 L .34127 .52001 L p F P
0 g
s
.67 .743 .905 r
.51797 .40905 m .51552 .40792 L .52513 .40124 L closepath p F P
0 g
s
.66 .735 .905 r
.53491 .40782 m .5325 .40897 L .52513 .40124 L closepath p F P
0 g
s
1 1 0 r
.007 w
.35419 .72395 m
.37157 .73095 L
s
.5 Mabswid
.91 .746 .666 r
.32214 .62742 m .29303 .60159 L .29822 .58935 L p F P
0 g
s
0 1 0 r
.007 w
.27023 .59513 m
.29471 .59762 L
s
.5 Mabswid
.917 .74 .648 r
.29303 .60159 m .32214 .62742 L .3182 .64008 L p F P
0 g
s
0 0 .807 r
.69499 .73271 m .69609 .73471 L .70658 .72883 L closepath p F P
0 g
s
.671 .745 .906 r
.51552 .40792 m .51352 .4065 L .52513 .40124 L closepath p F P
0 g
s
.884 .646 .573 r
.34799 .71274 m .30807 .69061 L .30974 .67806 L p F P
0 g
s
.887 .635 .552 r
.30807 .69061 m .34799 .71274 L .34712 .7251 L p F P
0 g
s
.658 .735 .906 r
.53688 .40637 m .53491 .40782 L .52513 .40124 L closepath p F P
0 g
s
0 0 .655 r
.69445 .73009 m .69499 .73271 L .70658 .72883 L closepath p F P
0 g
s
0 0 1 r
.007 w
.66688 .73939 m
.69483 .73195 L
s
.5 Mabswid
.689 .757 .904 r
.5112 .40303 m .51205 .40485 L .49906 .40903 L p F P
0 g
s
.689 .757 .904 r
.49906 .40903 m .49732 .40542 L .5112 .40303 L p F P
0 g
s
.646 .717 .9 r
.53688 .40637 m .53829 .4047 L .55138 .40874 L p F P
0 g
s
.641 .719 .904 r
.55302 .40511 m .55138 .40874 L .53829 .4047 L p F P
0 g
s
.627 .702 .9 r
.55138 .40874 m .55302 .40511 L .56685 .40794 L p F P
0 g
s
.429 .459 .789 r
.70145 .50756 m .71458 .48424 L .72444 .49372 L p F P
0 g
s
.429 .459 .789 r
.72444 .49372 m .7105 .5181 L .70145 .50756 L p F P
0 g
s
.882 .825 .788 r
.34127 .52001 m .32663 .49581 L .33645 .48624 L p F P
0 g
s
.893 .826 .774 r
.32663 .49581 m .34127 .52001 L .33278 .53094 L p F P
0 g
s
.671 .747 .907 r
.51352 .4065 m .51205 .40485 L .52513 .40124 L closepath p F P
0 g
s
.656 .735 .907 r
.53829 .4047 m .53688 .40637 L .52513 .40124 L closepath p F P
0 g
s
.39 .312 .648 r
.73084 .62544 m .75921 .5993 L .76382 .61164 L p F P
0 g
s
.39 .312 .648 r
.76382 .61164 m .73484 .63808 L .73084 .62544 L p F P
0 g
s
.426 .26 .551 r
.70584 .7111 m .74512 .68858 L .74621 .70102 L p F P
0 g
s
.426 .26 .551 r
.74621 .70102 m .70672 .72347 L .70584 .7111 L p F P
0 g
s
.72 .786 .904 r
.48283 .40277 m .48354 .4084 L .46987 .41195 L p F P
0 g
s
.72 .786 .904 r
.46987 .41195 m .46888 .40448 L .48283 .40277 L p F P
0 g
s
.736 .797 .901 r
.46888 .40448 m .46987 .41195 L .45636 .41608 L p F P
0 g
s
.671 .748 .909 r
.51205 .40485 m .5112 .40303 L .52513 .40124 L closepath p F P
0 g
s
.736 .797 .901 r
.45636 .41608 m .45505 .4068 L .46888 .40448 L p F P
0 g
s
.752 .807 .897 r
.45505 .4068 m .45636 .41608 L .44303 .42077 L p F P
0 g
s
.655 .735 .909 r
.5391 .40288 m .53829 .4047 L .52513 .40124 L closepath p F P
0 g
s
.641 .719 .904 r
.53829 .4047 m .5391 .40288 L .55302 .40511 L p F P
0 g
s
.704 .774 .907 r
.49688 .40166 m .49732 .40542 L .48354 .4084 L p F P
0 g
s
.704 .774 .907 r
.48354 .4084 m .48283 .40277 L .49688 .40166 L p F P
0 g
s
.41 .436 .776 r
.7105 .5181 m .72444 .49372 L .7338 .50359 L p F P
0 g
s
.41 .436 .776 r
.7338 .50359 m .71908 .52895 L .7105 .5181 L p F P
0 g
s
.752 .807 .897 r
.44303 .42077 m .44138 .40971 L .45505 .4068 L p F P
0 g
s
.767 .817 .892 r
.44138 .40971 m .44303 .42077 L .42992 .42602 L p F P
0 g
s
.603 .691 .905 r
.58134 .40386 m .58056 .41135 L .56685 .40794 L p F P
0 g
s
.585 .675 .902 r
.58056 .41135 m .58134 .40386 L .59516 .40603 L p F P
0 g
s
.585 .675 .902 r
.59516 .40603 m .59412 .41533 L .58056 .41135 L p F P
0 g
s
.62 .707 .907 r
.56739 .4023 m .56685 .40794 L .55302 .40511 L p F P
0 g
s
.603 .691 .905 r
.56685 .40794 m .56739 .4023 L .58134 .40386 L p F P
0 g
s
.567 .658 .898 r
.59412 .41533 m .59516 .40603 L .60883 .40879 L p F P
0 g
s
.567 .658 .898 r
.60883 .40879 m .6075 .41988 L .59412 .41533 L p F P
0 g
s
.687 .762 .909 r
.51099 .40115 m .5112 .40303 L .49732 .40542 L p F P
0 g
s
.687 .762 .909 r
.49732 .40542 m .49688 .40166 L .51099 .40115 L p F P
0 g
s
.637 .722 .909 r
.55335 .40134 m .55302 .40511 L .5391 .40288 L p F P
0 g
s
.62 .707 .907 r
.55302 .40511 m .55335 .40134 L .56739 .4023 L p F P
0 g
s
.893 .826 .774 r
.33278 .53094 m .31733 .50576 L .32663 .49581 L p F P
0 g
s
.904 .827 .76 r
.31733 .50576 m .33278 .53094 L .32478 .54215 L p F P
0 g
s
.917 .74 .648 r
.3182 .64008 m .28846 .61396 L .29303 .60159 L p F P
0 g
s
.923 .733 .628 r
.28846 .61396 m .3182 .64008 L .31482 .65277 L p F P
0 g
s
.767 .817 .892 r
.42992 .42602 m .42791 .41321 L .44138 .40971 L p F P
0 g
s
.782 .827 .887 r
.42791 .41321 m .42992 .42602 L .41705 .4318 L p F P
0 g
s
.548 .64 .894 r
.6075 .41988 m .60883 .40879 L .6223 .41214 L p F P
0 g
s
.548 .64 .894 r
.6223 .41214 m .62067 .42498 L .6075 .41988 L p F P
0 g
s
.67 .75 .91 r
.5112 .40303 m .51099 .40115 L .52513 .40124 L closepath p F P
0 g
s
1 1 0 r
.007 w
.69083 .72618 m
.70754 .71865 L
s
.5 Mabswid
.654 .736 .91 r
.53925 .40099 m .5391 .40288 L .52513 .40124 L closepath p F P
0 g
s
.637 .722 .909 r
.5391 .40288 m .53925 .40099 L .55335 .40134 L p F P
0 g
s
.528 .622 .889 r
.62067 .42498 m .6223 .41214 L .63555 .41609 L p F P
0 g
s
0 1 0 r
.007 w
.62789 .4138 m
.64551 .37827 L
s
.5 Mabswid
.528 .622 .889 r
.63555 .41609 m .63359 .43063 L .62067 .42498 L p F P
0 g
s
.782 .827 .887 r
.41705 .4318 m .41467 .4173 L .42791 .41321 L p F P
0 g
s
0 1 0 r
.007 w
.40458 .37436 m
.42413 .41438 L
s
.5 Mabswid
.798 .836 .881 r
.41467 .4173 m .41705 .4318 L .40446 .43811 L p F P
0 g
s
.653 .738 .912 r
.53874 .39912 m .53925 .40099 L .52513 .40124 L closepath p F P
0 g
s
.669 .751 .912 r
.51099 .40115 m .51144 .39928 L .52513 .40124 L closepath p F P
0 g
s
.652 .739 .913 r
.5376 .39737 m .53874 .39912 L .52513 .40124 L closepath p F P
0 g
s
.668 .752 .913 r
.51144 .39928 m .51254 .39751 L .52513 .40124 L closepath p F P
0 g
s
.652 .741 .915 r
.53586 .3958 m .5376 .39737 L .52513 .40124 L closepath p F P
0 g
s
.653 .743 .916 r
.53362 .39451 m .53586 .3958 L .52513 .40124 L closepath p F P
0 g
s
.666 .753 .915 r
.51254 .39751 m .51423 .39592 L .52513 .40124 L closepath p F P
0 g
s
.653 .745 .917 r
.53098 .39354 m .53362 .39451 L .52513 .40124 L closepath p F P
0 g
s
.664 .753 .916 r
.51423 .39592 m .51643 .3946 L .52513 .40124 L closepath p F P
0 g
s
.655 .747 .918 r
.52806 .39294 m .53098 .39354 L .52513 .40124 L closepath p F P
0 g
s
.662 .752 .917 r
.51643 .3946 m .51905 .3936 L .52513 .40124 L closepath p F P
0 g
s
.656 .749 .918 r
.525 .39275 m .52806 .39294 L .52513 .40124 L closepath p F P
0 g
s
0 1 0 r
.007 w
.52513 .35761 m
.52513 .39276 L
s
.5 Mabswid
.66 .752 .918 r
.51905 .3936 m .52195 .39298 L .52513 .40124 L closepath p F P
0 g
s
.658 .75 .918 r
.52195 .39298 m .525 .39275 L .52513 .40124 L closepath p F P
0 g
s
.887 .635 .552 r
.34712 .7251 m .30699 .70305 L .30807 .69061 L p F P
0 g
s
.391 .412 .762 r
.71908 .52895 m .7338 .50359 L .74262 .51384 L p F P
0 g
s
.391 .412 .762 r
.74262 .51384 m .72715 .5401 L .71908 .52895 L p F P
0 g
s
.373 .286 .627 r
.73484 .63808 m .76382 .61164 L .7678 .62408 L p F P
0 g
s
.476 0 0 r
.75228 .65106 m .75041 .65219 L .74831 .64052 L closepath p F P
0 g
s
0 0 0 r
.75221 .64962 m .75228 .65106 L .74831 .64052 L closepath p F P
0 g
s
.853 0 0 r
.75023 .64871 m .75221 .64962 L .74831 .64052 L closepath p F P
0 g
s
.851 0 0 r
.7477 .65234 m .74572 .65142 L .74831 .64052 L closepath p F P
0 g
s
.682 0 0 r
.75041 .65219 m .7477 .65234 L .74831 .64052 L closepath p F P
0 g
s
.642 0 0 r
.74751 .64886 m .75023 .64871 L .74831 .64052 L closepath p F P
0 g
s
.938 0 0 r
.74572 .65142 m .74564 .64998 L .74831 .64052 L closepath p F P
0 g
s
.306 0 0 r
.74564 .64998 m .74751 .64886 L .74831 .64052 L closepath p F P
0 g
s
.373 .286 .627 r
.7678 .62408 m .73827 .65075 L .73484 .63808 L p F P
0 g
s
.508 .603 .883 r
.63359 .43063 m .63555 .41609 L .64854 .42061 L p F P
0 g
s
.508 .603 .883 r
.64854 .42061 m .64623 .43681 L .63359 .43063 L p F P
0 g
s
.685 .766 .913 r
.51144 .39928 m .51099 .40115 L .49688 .40166 L p F P
0 g
s
.634 .726 .914 r
.53925 .40099 m .53874 .39912 L .55236 .39761 L p F P
0 g
s
.634 .726 .914 r
.55236 .39761 m .55335 .40134 L .53925 .40099 L p F P
0 g
s
.798 .836 .881 r
.40446 .43811 m .40169 .42196 L .41467 .4173 L p F P
0 g
s
.812 .845 .874 r
.40169 .42196 m .40446 .43811 L .39218 .44494 L p F P
0 g
s
.904 .827 .76 r
.32478 .54215 m .30856 .51609 L .31733 .50576 L p F P
0 g
s
.915 .826 .745 r
.30856 .51609 m .32478 .54215 L .31731 .55363 L p F P
0 g
s
.685 .766 .913 r
.49688 .40166 m .49776 .39791 L .51144 .39928 L p F P
0 g
s
.7 .782 .915 r
.49776 .39791 m .49688 .40166 L .48283 .40277 L p F P
0 g
s
1 1 0 r
.007 w
.33779 .71619 m
.35419 .72395 L
s
.5 Mabswid
.614 .713 .915 r
.55335 .40134 m .55236 .39761 L .56595 .39671 L p F P
0 g
s
.614 .713 .915 r
.56595 .39671 m .56739 .4023 L .55335 .40134 L p F P
0 g
s
.487 .583 .876 r
.64623 .43681 m .64854 .42061 L .66123 .42571 L p F P
0 g
s
.487 .583 .876 r
.66123 .42571 m .65857 .4435 L .64623 .43681 L p F P
0 g
s
.681 .77 .918 r
.51254 .39751 m .51144 .39928 L .49776 .39791 L p F P
0 g
s
.632 .73 .919 r
.53874 .39912 m .5376 .39737 L .55009 .39409 L p F P
0 g
s
.632 .73 .919 r
.55009 .39409 m .55236 .39761 L .53874 .39912 L p F P
0 g
s
.812 .845 .874 r
.39218 .44494 m .389 .42719 L .40169 .42196 L p F P
0 g
s
.827 .854 .867 r
.389 .42719 m .39218 .44494 L .38024 .45227 L p F P
0 g
s
.7 .782 .915 r
.48283 .40277 m .48411 .39716 L .49776 .39791 L p F P
0 g
s
.715 .796 .915 r
.48411 .39716 m .48283 .40277 L .46888 .40448 L p F P
0 g
s
.594 .699 .916 r
.56739 .4023 m .56595 .39671 L .57948 .39642 L p F P
0 g
s
.594 .699 .916 r
.57948 .39642 m .58134 .40386 L .56739 .4023 L p F P
0 g
s
.681 0 0 r
.29512 .64557 m .29243 .64572 L .29386 .63387 L closepath p F P
0 g
s
.416 0 0 r
.29667 .64444 m .29512 .64557 L .29386 .63387 L closepath p F P
0 g
s
.844 0 0 r
.29393 .64206 m .29618 .64299 L .29386 .63387 L closepath p F P
0 g
s
.835 0 0 r
.29243 .64572 m .29018 .6448 L .29386 .63387 L closepath p F P
0 g
s
.638 0 0 r
.29124 .64221 m .29393 .64206 L .29386 .63387 L closepath p F P
0 g
s
.992 0 0 r
.29018 .6448 m .28969 .64335 L .29386 .63387 L closepath p F P
0 g
s
.138 0 0 r
.28969 .64335 m .29124 .64221 L .29386 .63387 L closepath p F P
0 g
s
.756 0 0 r
.29618 .64299 m .29667 .64444 L .29386 .63387 L closepath p F P
0 g
s
.923 .733 .628 r
.31482 .65277 m .28453 .62642 L .28846 .61396 L p F P
0 g
s
.929 .725 .607 r
.28453 .62642 m .31482 .65277 L .31199 .66544 L p F P
0 g
s
.371 .386 .746 r
.72715 .5401 m .74262 .51384 L .75087 .52444 L p F P
0 g
s
.371 .386 .746 r
.75087 .52444 m .73469 .55151 L .72715 .5401 L p F P
0 g
s
.675 .771 .923 r
.51423 .39592 m .51254 .39751 L .49993 .39437 L p F P
0 g
s
.681 .77 .918 r
.49776 .39791 m .49993 .39437 L .51254 .39751 L p F P
0 g
s
.466 .562 .869 r
.65857 .4435 m .66123 .42571 L .6736 .43137 L p F P
0 g
s
.466 .562 .869 r
.6736 .43137 m .67056 .45071 L .65857 .4435 L p F P
0 g
s
.715 .796 .915 r
.46888 .40448 m .47052 .39703 L .48411 .39716 L p F P
0 g
s
.73 .811 .915 r
.47052 .39703 m .46888 .40448 L .45505 .4068 L p F P
0 g
s
.631 .736 .923 r
.5376 .39737 m .53586 .3958 L .54664 .39095 L p F P
0 g
s
.631 .736 .923 r
.54664 .39095 m .55009 .39409 L .5376 .39737 L p F P
0 g
s
.827 .854 .867 r
.38024 .45227 m .37664 .43299 L .389 .42719 L p F P
0 g
s
.842 .861 .858 r
.37664 .43299 m .38024 .45227 L .36867 .46008 L p F P
0 g
s
.572 .684 .916 r
.58134 .40386 m .57948 .39642 L .59292 .39676 L p F P
0 g
s
.572 .684 .916 r
.59292 .39676 m .59516 .40603 L .58134 .40386 L p F P
0 g
s
.915 .826 .745 r
.31731 .55363 m .30035 .52676 L .30856 .51609 L p F P
0 g
s
.925 .825 .728 r
.30035 .52676 m .31731 .55363 L .31038 .56533 L p F P
0 g
s
.693 .787 .923 r
.49993 .39437 m .49776 .39791 L .48411 .39716 L p F P
0 g
s
.61 .72 .923 r
.55236 .39761 m .55009 .39409 L .56259 .39142 L p F P
0 g
s
.61 .72 .923 r
.56259 .39142 m .56595 .39671 L .55236 .39761 L p F P
0 g
s
.355 .259 .606 r
.73827 .65075 m .7678 .62408 L .77112 .63659 L p F P
0 g
s
.355 .259 .606 r
.77112 .63659 m .74114 .66341 L .73827 .65075 L p F P
0 g
s
.669 .772 .927 r
.51643 .3946 m .51423 .39592 L .50329 .39119 L p F P
0 g
s
.675 .771 .923 r
.49993 .39437 m .50329 .39119 L .51423 .39592 L p F P
0 g
s
.632 .742 .927 r
.53586 .3958 m .53362 .39451 L .54216 .38834 L p F P
0 g
s
.632 .742 .927 r
.54216 .38834 m .54664 .39095 L .53586 .3958 L p F P
0 g
s
0 0 .897 r
.31967 .71192 m .32174 .71221 L .32583 .7203 L closepath p F P
0 g
s
0 0 0 r
.32174 .71221 m .32249 .71413 L .32583 .7203 L closepath p F P
0 g
s
0 0 .812 r
.31749 .71344 m .31967 .71192 L .32583 .7203 L closepath p F P
0 g
s
0 0 .666 r
.31648 .71586 m .31749 .71344 L .32583 .7203 L closepath p F P
0 g
s
0 0 .327 r
.31723 .71778 m .31648 .71586 L .32583 .7203 L closepath p F P
0 g
s
0 0 .862 r
.31931 .71807 m .31723 .71778 L .32583 .7203 L closepath p F P
0 g
s
0 0 .915 r
.32149 .71655 m .31931 .71807 L .32583 .7203 L closepath p F P
0 g
s
0 0 .674 r
.32249 .71413 m .32149 .71655 L .32583 .7203 L closepath p F P
0 g
s
0 0 1 r
.007 w
.30774 .70516 m
.32141 .7166 L
s
.5 Mabswid
.73 .811 .915 r
.45505 .4068 m .45702 .39751 L .47052 .39703 L p F P
0 g
s
.745 .826 .914 r
.45702 .39751 m .45505 .4068 L .44138 .40971 L p F P
0 g
s
.443 .539 .86 r
.67056 .45071 m .6736 .43137 L .68561 .43759 L p F P
0 g
s
.443 .539 .86 r
.68561 .43759 m .68219 .4584 L .67056 .45071 L p F P
0 g
s
.549 .668 .915 r
.59516 .40603 m .59292 .39676 L .60623 .39772 L p F P
0 g
s
.549 .668 .915 r
.60623 .39772 m .60883 .40879 L .59516 .40603 L p F P
0 g
s
.663 .771 .93 r
.51905 .3936 m .51643 .3946 L .50769 .38853 L p F P
0 g
s
.669 .772 .927 r
.50329 .39119 m .50769 .38853 L .51643 .3946 L p F P
0 g
s
.635 .748 .93 r
.53362 .39451 m .53098 .39354 L .53687 .38639 L p F P
0 g
s
.635 .748 .93 r
.53687 .38639 m .54216 .38834 L .53362 .39451 L p F P
0 g
s
.35 .359 .729 r
.73469 .55151 m .75087 .52444 L .75853 .53537 L p F P
0 g
s
.35 .359 .729 r
.75853 .53537 m .74169 .56317 L .73469 .55151 L p F P
0 g
s
.842 .861 .858 r
.36867 .46008 m .36464 .43933 L .37664 .43299 L p F P
0 g
s
.856 .869 .848 r
.36464 .43933 m .36867 .46008 L .35749 .46835 L p F P
0 g
s
1 1 0 r
.007 w
.70754 .71865 m
.72318 .71037 L
s
.5 Mabswid
.656 .768 .932 r
.52195 .39298 m .51905 .3936 L .51292 .38652 L p F P
0 g
s
.663 .771 .93 r
.50769 .38853 m .51292 .38652 L .51905 .3936 L p F P
0 g
s
.638 .754 .932 r
.53098 .39354 m .52806 .39294 L .53101 .3852 L p F P
0 g
s
.638 .754 .932 r
.53101 .3852 m .53687 .38639 L .53098 .39354 L p F P
0 g
s
.693 .787 .923 r
.48411 .39716 m .48732 .39184 L .49993 .39437 L p F P
0 g
s
.706 .805 .926 r
.48732 .39184 m .48411 .39716 L .47052 .39703 L p F P
0 g
s
.745 .826 .914 r
.44138 .40971 m .44366 .39862 L .45702 .39751 L p F P
0 g
s
.76 .84 .912 r
.44366 .39862 m .44138 .40971 L .42791 .41321 L p F P
0 g
s
.929 .725 .607 r
.31199 .66544 m .28124 .63895 L .28453 .62642 L p F P
0 g
s
.934 .716 .583 r
.28124 .63895 m .31199 .66544 L .30974 .67806 L p F P
0 g
s
.649 .765 .933 r
.525 .39275 m .52195 .39298 L .51874 .38526 L p F P
0 g
s
.656 .768 .932 r
.51292 .38652 m .51874 .38526 L .52195 .39298 L p F P
0 g
s
.643 .76 .933 r
.52806 .39294 m .525 .39275 L .52487 .38481 L p F P
0 g
s
.643 .76 .933 r
.52487 .38481 m .53101 .3852 L .52806 .39294 L p F P
0 g
s
.685 .791 .93 r
.50329 .39119 m .49993 .39437 L .48732 .39184 L p F P
0 g
s
.587 .709 .927 r
.56595 .39671 m .56259 .39142 L .57505 .38938 L p F P
0 g
s
.587 .709 .927 r
.57505 .38938 m .57948 .39642 L .56595 .39671 L p F P
0 g
s
.925 .825 .728 r
.31038 .56533 m .29273 .53775 L .30035 .52676 L p F P
0 g
s
.936 .824 .71 r
.29273 .53775 m .31038 .56533 L .30401 .57725 L p F P
0 g
s
.649 .765 .933 r
.51874 .38526 m .52487 .38481 L .525 .39275 L p F P
0 g
s
.609 .729 .931 r
.55009 .39409 m .54664 .39095 L .55743 .3867 L p F P
0 g
s
.609 .729 .931 r
.55743 .3867 m .56259 .39142 L .55009 .39409 L p F P
0 g
s
.419 .516 .851 r
.68219 .4584 m .68561 .43759 L .69723 .44436 L p F P
0 g
s
.419 .516 .851 r
.69723 .44436 m .69342 .46656 L .68219 .4584 L p F P
0 g
s
.525 .65 .914 r
.60883 .40879 m .60623 .39772 L .61937 .3993 L p F P
0 g
s
.525 .65 .914 r
.61937 .3993 m .6223 .41214 L .60883 .40879 L p F P
0 g
s
0 .876 0 r
.74679 .43341 m .748 .43269 L .75726 .42914 L closepath p F P
0 g
s
0 .788 0 r
.74711 .43543 m .74679 .43341 L .75726 .42914 L closepath p F P
0 g
s
0 .589 0 r
.74876 .43759 m .74711 .43543 L .75726 .42914 L closepath p F P
0 g
s
0 .367 0 r
.75078 .43861 m .74876 .43759 L .75726 .42914 L closepath p F P
0 g
s
0 0 0 r
.75198 .4379 m .75078 .43861 L .75726 .42914 L closepath p F P
0 g
s
0 .865 0 r
.75167 .43587 m .75198 .4379 L .75726 .42914 L closepath p F P
0 g
s
0 .591 0 r
.75002 .43371 m .75167 .43587 L .75726 .42914 L closepath p F P
0 g
s
0 .264 0 r
.748 .43269 m .75002 .43371 L .75726 .42914 L closepath p F P
0 g
s
.856 .869 .848 r
.35749 .46835 m .35303 .44621 L .36464 .43933 L p F P
0 g
s
.871 .876 .837 r
.35303 .44621 m .35749 .46835 L .34674 .47708 L p F P
0 g
s
1 1 0 r
.007 w
.3225 .70769 m
.32708 .71024 L
s
.32708 .71024 m
.33779 .71619 L
s
.5 Mabswid
.336 .229 .582 r
.74114 .66341 m .77112 .63659 L .77377 .64914 L p F P
0 g
s
.336 .229 .582 r
.77377 .64914 m .74342 .67603 L .74114 .66341 L p F P
0 g
s
.76 .84 .912 r
.42791 .41321 m .43047 .40034 L .44366 .39862 L p F P
0 g
s
.776 .854 .909 r
.43047 .40034 m .42791 .41321 L .41467 .4173 L p F P
0 g
s
.327 .33 .71 r
.74169 .56317 m .75853 .53537 L .76559 .5466 L p F P
0 g
s
.327 .33 .71 r
.76559 .5466 m .74812 .57503 L .74169 .56317 L p F P
0 g
s
.706 .805 .926 r
.47052 .39703 m .47475 .38994 L .48732 .39184 L p F P
0 g
s
.719 .823 .929 r
.47475 .38994 m .47052 .39703 L .45702 .39751 L p F P
0 g
s
.674 .792 .937 r
.50769 .38853 m .50329 .39119 L .49233 .38706 L p F P
0 g
s
.685 .791 .93 r
.48732 .39184 m .49233 .38706 L .50329 .39119 L p F P
0 g
s
.609 .739 .937 r
.54664 .39095 m .54216 .38834 L .55072 .38277 L p F P
0 g
s
.609 .739 .937 r
.55072 .38277 m .55743 .3867 L .54664 .39095 L p F P
0 g
s
.394 .491 .84 r
.69342 .46656 m .69723 .44436 L .70843 .45165 L p F P
0 g
s
.394 .491 .84 r
.70843 .45165 m .70423 .47519 L .69342 .46656 L p F P
0 g
s
.5 .632 .911 r
.6223 .41214 m .61937 .3993 L .63232 .40151 L p F P
0 g
s
.5 .632 .911 r
.63232 .40151 m .63555 .41609 L .6223 .41214 L p F P
0 g
s
.562 .696 .931 r
.57948 .39642 m .57505 .38938 L .58745 .38796 L p F P
0 g
s
.562 .696 .931 r
.58745 .38796 m .59292 .39676 L .57948 .39642 L p F P
0 g
s
0 .651 0 r
.7942 .71042 m .79565 .70842 L .80541 .71468 L closepath p F P
0 g
s
0 .575 0 r
.79375 .71305 m .7942 .71042 L .80541 .71468 L closepath p F P
0 g
s
0 .366 0 r
.79454 .71477 m .79375 .71305 L .80541 .71468 L closepath p F P
0 g
s
0 .702 0 r
.79612 .71457 m .79454 .71477 L .80541 .71468 L closepath p F P
0 g
s
0 .829 0 r
.79757 .71257 m .79612 .71457 L .80541 .71468 L closepath p F P
0 g
s
0 .612 0 r
.79565 .70842 m .79723 .70822 L .80541 .71468 L closepath p F P
0 g
s
0 .706 0 r
.79803 .70994 m .79757 .71257 L .80541 .71468 L closepath p F P
0 g
s
0 .411 0 r
.79723 .70822 m .79803 .70994 L .80541 .71468 L closepath p F P
0 g
s
.936 .824 .71 r
.30401 .57725 m .28572 .54904 L .29273 .53775 L p F P
0 g
s
.945 .821 .69 r
.28572 .54904 m .30401 .57725 L .29822 .58935 L p F P
0 g
s
.871 .876 .837 r
.34674 .47708 m .34185 .45362 L .35303 .44621 L p F P
0 g
s
.885 .882 .825 r
.34185 .45362 m .34674 .47708 L .33645 .48624 L p F P
0 g
s
.694 .81 .937 r
.49233 .38706 m .48732 .39184 L .47475 .38994 L p F P
0 g
s
.583 .721 .938 r
.56259 .39142 m .55743 .3867 L .56821 .38307 L p F P
0 g
s
.583 .721 .938 r
.56821 .38307 m .57505 .38938 L .56259 .39142 L p F P
0 g
s
.776 .854 .909 r
.41467 .4173 m .41747 .4027 L .43047 .40034 L p F P
0 g
s
.791 .868 .906 r
.41747 .4027 m .41467 .4173 L .40169 .42196 L p F P
0 g
s
.934 .716 .583 r
.30974 .67806 m .27862 .6515 L .28124 .63895 L p F P
0 g
s
.939 .705 .558 r
.27862 .6515 m .30974 .67806 L .30807 .69061 L p F P
0 g
s
.662 .79 .942 r
.51292 .38652 m .50769 .38853 L .49892 .38306 L p F P
0 g
s
.674 .792 .937 r
.49233 .38706 m .49892 .38306 L .50769 .38853 L p F P
0 g
s
.613 .75 .943 r
.54216 .38834 m .53687 .38639 L .54278 .37983 L p F P
0 g
s
.613 .75 .943 r
.54278 .37983 m .55072 .38277 L .54216 .38834 L p F P
0 g
s
.473 .612 .908 r
.63555 .41609 m .63232 .40151 L .64505 .40435 L p F P
0 g
s
.473 .612 .908 r
.64505 .40435 m .64854 .42061 L .63555 .41609 L p F P
0 g
s
.367 .464 .828 r
.70423 .47519 m .70843 .45165 L .71918 .45946 L p F P
0 g
s
.367 .464 .828 r
.71918 .45946 m .71458 .48424 L .70423 .47519 L p F P
0 g
s
.719 .823 .929 r
.45702 .39751 m .46224 .38866 L .47475 .38994 L p F P
0 g
s
.732 .841 .932 r
.46224 .38866 m .45702 .39751 L .44366 .39862 L p F P
0 g
s
.303 .3 .69 r
.74812 .57503 m .76559 .5466 L .772 .55811 L p F P
0 g
s
.303 .3 .69 r
.772 .55811 m .75397 .58709 L .74812 .57503 L p F P
0 g
s
.534 .682 .933 r
.59292 .39676 m .58745 .38796 L .59975 .38719 L p F P
0 g
s
.534 .682 .933 r
.59975 .38719 m .60623 .39772 L .59292 .39676 L p F P
0 g
s
.65 .786 .946 r
.51874 .38526 m .51292 .38652 L .50678 .38003 L p F P
0 g
s
.662 .79 .942 r
.49892 .38306 m .50678 .38003 L .51292 .38652 L p F P
0 g
s
.619 .761 .947 r
.53687 .38639 m .53101 .3852 L .53398 .37803 L p F P
0 g
s
.619 .761 .947 r
.53398 .37803 m .54278 .37983 L .53687 .38639 L p F P
0 g
s
.315 .198 .556 r
.74342 .67603 m .77377 .64914 L .77573 .6617 L p F P
0 g
s
.315 .198 .556 r
.77573 .6617 m .74512 .68858 L .74342 .67603 L p F P
0 g
s
.885 .882 .825 r
.33645 .48624 m .33112 .46153 L .34185 .45362 L p F P
0 g
s
.899 .888 .812 r
.33112 .46153 m .33645 .48624 L .32663 .49581 L p F P
0 g
s
.791 .868 .906 r
.40169 .42196 m .4047 .40567 L .41747 .4027 L p F P
0 g
s
.806 .882 .901 r
.4047 .40567 m .40169 .42196 L .389 .42719 L p F P
0 g
s
0 .19 0 r
.29798 .43112 m .29726 .42996 L .292 .42142 L closepath p F P
0 g
s
0 .525 0 r
.29984 .43058 m .29798 .43112 L .292 .42142 L closepath p F P
0 g
s
0 .538 0 r
.30176 .42867 m .29984 .43058 L .292 .42142 L closepath p F P
0 g
s
0 .33 0 r
.29726 .42996 m .29811 .42778 L .292 .42142 L closepath p F P
0 g
s
0 .559 0 r
.30261 .42649 m .30176 .42867 L .292 .42142 L closepath p F P
0 g
s
0 .553 0 r
.30189 .42533 m .30261 .42649 L .292 .42142 L closepath p F P
0 g
s
0 .191 0 r
.30003 .42586 m .30189 .42533 L .292 .42142 L closepath p F P
0 g
s
0 .35 0 r
.29811 .42778 m .30003 .42586 L .292 .42142 L closepath p F P
0 g
s
0 1 0 r
.007 w
.29871 .42718 m
.33526 .45847 L
s
.5 Mabswid
.638 .779 .948 r
.52487 .38481 m .51874 .38526 L .51553 .37813 L p F P
0 g
s
.65 .786 .946 r
.50678 .38003 m .51553 .37813 L .51874 .38526 L p F P
0 g
s
.945 .821 .69 r
.29822 .58935 m .27934 .5606 L .28572 .54904 L p F P
0 g
s
.955 .817 .668 r
.27934 .5606 m .29822 .58935 L .29303 .60159 L p F P
0 g
s
.628 .771 .949 r
.53101 .3852 m .52487 .38481 L .52474 .37745 L p F P
0 g
s
.628 .771 .949 r
.52474 .37745 m .53398 .37803 L .53101 .3852 L p F P
0 g
s
1 1 0 r
.007 w
.72318 .71037 m
.73765 .70139 L
s
.5 Mabswid
.638 .779 .948 r
.51553 .37813 m .52474 .37745 L .52487 .38481 L p F P
0 g
s
.678 .812 .947 r
.49892 .38306 m .49233 .38706 L .48139 .38356 L p F P
0 g
s
.694 .81 .937 r
.47475 .38994 m .48139 .38356 L .49233 .38706 L p F P
0 g
s
0 .938 0 r
.62938 .3417 m .62914 .3403 L .63616 .3319 L closepath p F P
0 g
s
0 .673 0 r
.63138 .34313 m .62938 .3417 L .63616 .3319 L closepath p F P
0 g
s
0 .938 0 r
.62938 .3417 m .62914 .3403 L .63616 .3319 L closepath p F P
0 g
s
0 .673 0 r
.63138 .34313 m .62938 .3417 L .63616 .3319 L closepath p F P
0 g
s
0 0 0 r
.62914 .3403 m .63079 .33974 L .63616 .3319 L closepath p F P
0 g
s
0 .499 0 r
.63396 .34375 m .63138 .34313 L .63616 .3319 L closepath p F P
0 g
s
0 .227 0 r
.63561 .3432 m .63396 .34375 L .63616 .3319 L closepath p F P
0 g
s
0 .227 0 r
.63561 .3432 m .63396 .34375 L .63616 .3319 L closepath p F P
0 g
s
0 .743 0 r
.63537 .3418 m .63561 .3432 L .63616 .3319 L closepath p F P
0 g
s
0 .499 0 r
.63396 .34375 m .63138 .34313 L .63616 .3319 L closepath p F P
0 g
s
0 .612 0 r
.63337 .34037 m .63537 .3418 L .63616 .3319 L closepath p F P
0 g
s
0 .392 0 r
.63079 .33974 m .63337 .34037 L .63616 .3319 L closepath p F P
0 g
s
0 0 0 r
.62914 .3403 m .63079 .33974 L .63616 .3319 L closepath p F P
0 g
s
0 .743 0 r
.63537 .3418 m .63561 .3432 L .63616 .3319 L closepath p F P
0 g
s
0 .612 0 r
.63337 .34037 m .63537 .3418 L .63616 .3319 L closepath p F P
0 g
s
0 .392 0 r
.63079 .33974 m .63337 .34037 L .63616 .3319 L closepath p F P
0 g
s
.444 .59 .903 r
.64854 .42061 m .64505 .40435 L .6575 .40781 L p F P
0 g
s
.444 .59 .903 r
.6575 .40781 m .66123 .42571 L .64854 .42061 L p F P
0 g
s
.583 .735 .948 r
.55743 .3867 m .55072 .38277 L .55929 .37782 L p F P
0 g
s
.583 .735 .948 r
.55929 .37782 m .56821 .38307 L .55743 .3867 L p F P
0 g
s
.703 .83 .943 r
.48139 .38356 m .47475 .38994 L .46224 .38866 L p F P
0 g
s
.339 .435 .814 r
.71458 .48424 m .71918 .45946 L .72943 .46776 L p F P
0 g
s
0 1 0 r
.007 w
.71989 .46004 m
.75068 .43458 L
s
.5 Mabswid
.339 .435 .814 r
.72943 .46776 m .72444 .49372 L .71458 .48424 L p F P
0 g
s
.555 .712 .945 r
.57505 .38938 m .56821 .38307 L .57896 .38008 L p F P
0 g
s
.555 .712 .945 r
.57896 .38008 m .58745 .38796 L .57505 .38938 L p F P
0 g
s
.732 .841 .932 r
.44366 .39862 m .44983 .38803 L .46224 .38866 L p F P
0 g
s
.745 .859 .933 r
.44983 .38803 m .44366 .39862 L .43047 .40034 L p F P
0 g
s
.939 .705 .558 r
.30807 .69061 m .27667 .66406 L .27862 .6515 L p F P
0 g
s
.943 .693 .531 r
.27667 .66406 m .30807 .69061 L .30699 .70305 L p F P
0 g
s
.278 .267 .668 r
.75397 .58709 m .772 .55811 L .77776 .56987 L p F P
0 g
s
.278 .267 .668 r
.77776 .56987 m .75921 .5993 L .75397 .58709 L p F P
0 g
s
.505 .665 .934 r
.60623 .39772 m .59975 .38719 L .61193 .38707 L p F P
0 g
s
.505 .665 .934 r
.61193 .38707 m .61937 .3993 L .60623 .39772 L p F P
0 g
s
.806 .882 .901 r
.389 .42719 m .3922 .40927 L .4047 .40567 L p F P
0 g
s
.821 .895 .894 r
.3922 .40927 m .389 .42719 L .37664 .43299 L p F P
0 g
s
.899 .888 .812 r
.32663 .49581 m .32088 .46994 L .33112 .46153 L p F P
0 g
s
.913 .893 .796 r
.32088 .46994 m .32663 .49581 L .31733 .50576 L p F P
0 g
s
1 1 0 r
.007 w
.30842 .6985 m
.3225 .70769 L
s
.5 Mabswid
0 .683 0 r
.41806 .33977 m .41769 .3386 L .41731 .32807 L closepath p F P
0 g
s
0 .647 0 r
.42015 .33996 m .41806 .33977 L .41731 .32807 L closepath p F P
0 g
s
0 .202 0 r
.41769 .3386 m .41925 .33711 L .41731 .32807 L closepath p F P
0 g
s
0 .554 0 r
.42273 .33904 m .42015 .33996 L .41731 .32807 L closepath p F P
0 g
s
0 .469 0 r
.42429 .33756 m .42273 .33904 L .41731 .32807 L closepath p F P
0 g
s
0 .113 0 r
.42392 .33638 m .42429 .33756 L .41731 .32807 L closepath p F P
0 g
s
0 .438 0 r
.42183 .3362 m .42392 .33638 L .41731 .32807 L closepath p F P
0 g
s
0 .39 0 r
.41925 .33711 m .42183 .3362 L .41731 .32807 L closepath p F P
0 g
s
0 .759 0 r
.24391 .70035 m .24543 .70175 L .23438 .70671 L closepath p F P
0 g
s
0 .912 0 r
.24263 .70095 m .24391 .70035 L .23438 .70671 L closepath p F P
0 g
s
0 .567 0 r
.24543 .70175 m .24629 .70435 L .23438 .70671 L closepath p F P
0 g
s
0 .163 0 r
.24233 .70322 m .24263 .70095 L .23438 .70671 L closepath p F P
0 g
s
0 .38 0 r
.24629 .70435 m .24599 .70661 L .23438 .70671 L closepath p F P
0 g
s
0 .471 0 r
.24319 .70582 m .24233 .70322 L .23438 .70671 L closepath p F P
0 g
s
0 0 0 r
.24599 .70661 m .24471 .70722 L .23438 .70671 L closepath p F P
0 g
s
0 .685 0 r
.24471 .70722 m .24319 .70582 L .23438 .70671 L closepath p F P
0 g
s
.413 .566 .897 r
.66123 .42571 m .6575 .40781 L .66967 .41189 L p F P
0 g
s
.413 .566 .897 r
.66967 .41189 m .6736 .43137 L .66123 .42571 L p F P
0 g
s
.661 .81 .955 r
.50678 .38003 m .49892 .38306 L .49015 .3782 L p F P
0 g
s
.678 .812 .947 r
.48139 .38356 m .49015 .3782 L .49892 .38306 L p F P
0 g
s
.587 .751 .955 r
.55072 .38277 m .54278 .37983 L .5487 .37388 L p F P
0 g
s
.587 .751 .955 r
.5487 .37388 m .55929 .37782 L .55072 .38277 L p F P
0 g
s
.293 .164 .528 r
.74512 .68858 m .77573 .6617 L .777 .67422 L p F P
0 g
s
.293 .164 .528 r
.777 .67422 m .74621 .70102 L .74512 .68858 L p F P
0 g
s
1 0 0 r
.007 w
.75194 .69603 m
.752 .69684 L
s
0 1 0 r
.752 .69684 m
.79765 .71209 L
s
.5 Mabswid
.955 .817 .668 r
.29303 .60159 m .27362 .57239 L .27934 .5606 L p F P
0 g
s
.963 .811 .644 r
.27362 .57239 m .29303 .60159 L .28846 .61396 L p F P
0 g
s
.309 .405 .798 r
.72444 .49372 m .72943 .46776 L .73917 .47655 L p F P
0 g
s
.309 .405 .798 r
.73917 .47655 m .7338 .50359 L .72444 .49372 L p F P
0 g
s
.745 .859 .933 r
.43047 .40034 m .43755 .38804 L .44983 .38803 L p F P
0 g
s
.758 .877 .933 r
.43755 .38804 m .43047 .40034 L .41747 .4027 L p F P
0 g
s
.703 .83 .943 r
.46224 .38866 m .47049 .38069 L .48139 .38356 L p F P
0 g
s
.712 .851 .949 r
.47049 .38069 m .46224 .38866 L .44983 .38803 L p F P
0 g
s
.821 .895 .894 r
.37664 .43299 m .37999 .41348 L .3922 .40927 L p F P
0 g
s
.837 .908 .886 r
.37999 .41348 m .37664 .43299 L .36464 .43933 L p F P
0 g
s
.913 .893 .796 r
.31733 .50576 m .31115 .47882 L .32088 .46994 L p F P
0 g
s
.926 .897 .779 r
.31115 .47882 m .31733 .50576 L .30856 .51609 L p F P
0 g
s
.524 .7 .95 r
.58745 .38796 m .57896 .38008 L .58965 .37774 L p F P
0 g
s
.524 .7 .95 r
.58965 .37774 m .59975 .38719 L .58745 .38796 L p F P
0 g
s
.472 .647 .935 r
.61937 .3993 m .61193 .38707 L .62394 .3876 L p F P
0 g
s
.472 .647 .935 r
.62394 .3876 m .63232 .40151 L .61937 .3993 L p F P
0 g
s
.682 .833 .956 r
.49015 .3782 m .48139 .38356 L .47049 .38069 L p F P
0 g
s
.642 .803 .96 r
.51553 .37813 m .50678 .38003 L .50063 .37415 L p F P
0 g
s
.661 .81 .955 r
.49015 .3782 m .50063 .37415 L .50678 .38003 L p F P
0 g
s
.25 .233 .643 r
.75921 .5993 m .77776 .56987 L .78283 .58185 L p F P
0 g
s
.25 .233 .643 r
.78283 .58185 m .76382 .61164 L .75921 .5993 L p F P
0 g
s
.596 .766 .961 r
.54278 .37983 m .53398 .37803 L .53695 .37146 L p F P
0 g
s
.596 .766 .961 r
.53695 .37146 m .5487 .37388 L .54278 .37983 L p F P
0 g
s
.553 .73 .957 r
.56821 .38307 m .55929 .37782 L .56785 .3735 L p F P
0 g
s
.553 .73 .957 r
.56785 .3735 m .57896 .38008 L .56821 .38307 L p F P
0 g
s
.379 .54 .889 r
.6736 .43137 m .66967 .41189 L .6815 .41659 L p F P
0 g
s
.379 .54 .889 r
.6815 .41659 m .68561 .43759 L .6736 .43137 L p F P
0 g
s
.943 .693 .531 r
.30699 .70305 m .27542 .67658 L .27667 .66406 L p F P
0 g
s
0 1 0 r
.007 w
.24268 .70426 m
.29002 .69032 L
s
0 0 1 r
.30185 .70022 m
.30774 .70516 L
s
.29002 .69032 m
.30185 .70022 L
s
1 0 0 r
.29002 .69032 m
.29012 .6889 L
s
.5 Mabswid
.624 .794 .963 r
.52474 .37745 m .51553 .37813 L .5123 .3716 L p F P
0 g
s
.642 .803 .96 r
.50063 .37415 m .5123 .3716 L .51553 .37813 L p F P
0 g
s
.277 .372 .781 r
.7338 .50359 m .73917 .47655 L .74836 .48581 L p F P
0 g
s
.277 .372 .781 r
.74836 .48581 m .74262 .51384 L .7338 .50359 L p F P
0 g
s
.608 .781 .963 r
.53398 .37803 m .52474 .37745 L .52461 .37069 L p F P
0 g
s
.608 .781 .963 r
.52461 .37069 m .53695 .37146 L .53398 .37803 L p F P
0 g
s
.624 .794 .963 r
.5123 .3716 m .52461 .37069 L .52474 .37745 L p F P
0 g
s
.963 .811 .644 r
.28846 .61396 m .26858 .5844 L .27362 .57239 L p F P
0 g
s
.971 .804 .618 r
.26858 .5844 m .28846 .61396 L .28453 .62642 L p F P
0 g
s
1 1 0 r
.007 w
.73765 .70139 m
.75083 .69174 L
s
.5 Mabswid
.758 .877 .933 r
.41747 .4027 m .42543 .38871 L .43755 .38804 L p F P
0 g
s
.771 .896 .931 r
.42543 .38871 m .41747 .4027 L .4047 .40567 L p F P
0 g
s
.837 .908 .886 r
.36464 .43933 m .36813 .4183 L .37999 .41348 L p F P
0 g
s
.851 .921 .877 r
.36813 .4183 m .36464 .43933 L .35303 .44621 L p F P
0 g
s
.926 .897 .779 r
.30856 .51609 m .30197 .48816 L .31115 .47882 L p F P
0 g
s
.939 .9 .76 r
.30197 .48816 m .30856 .51609 L .30035 .52676 L p F P
0 g
s
.436 .626 .933 r
.63232 .40151 m .62394 .3876 L .63577 .3888 L p F P
0 g
s
.436 .626 .933 r
.63577 .3888 m .64505 .40435 L .63232 .40151 L p F P
0 g
s
.712 .851 .949 r
.44983 .38803 m .45965 .37847 L .47049 .38069 L p F P
0 g
s
.72 .872 .953 r
.45965 .37847 m .44983 .38803 L .43755 .38804 L p F P
0 g
s
.657 .83 .966 r
.50063 .37415 m .49015 .3782 L .4814 .37398 L p F P
0 g
s
.682 .833 .956 r
.47049 .38069 m .4814 .37398 L .49015 .3782 L p F P
0 g
s
.343 .511 .879 r
.68561 .43759 m .6815 .41659 L .69296 .42189 L p F P
0 g
s
.343 .511 .879 r
.69296 .42189 m .69723 .44436 L .68561 .43759 L p F P
0 g
s
.221 .195 .616 r
.76382 .61164 m .78283 .58185 L .7872 .59401 L p F P
0 g
s
.221 .195 .616 r
.7872 .59401 m .7678 .62408 L .76382 .61164 L p F P
0 g
s
.557 .749 .967 r
.55929 .37782 m .5487 .37388 L .55462 .36856 L p F P
0 g
s
.557 .749 .967 r
.55462 .36856 m .56785 .3735 L .55929 .37782 L p F P
0 g
s
.488 .685 .954 r
.59975 .38719 m .58965 .37774 L .60024 .37606 L p F P
0 g
s
.488 .685 .954 r
.60024 .37606 m .61193 .38707 L .59975 .38719 L p F P
0 g
s
.243 .337 .761 r
.74262 .51384 m .74836 .48581 L .75698 .49551 L p F P
0 g
s
.243 .337 .761 r
.75698 .49551 m .75087 .52444 L .74262 .51384 L p F P
0 g
s
1 1 0 r
.007 w
.29565 .68866 m
.30842 .6985 L
s
.5 Mabswid
.684 .855 .964 r
.4814 .37398 m .47049 .38069 L .45965 .37847 L p F P
0 g
s
.518 .721 .965 r
.57896 .38008 m .56785 .3735 L .57636 .36983 L p F P
0 g
s
.518 .721 .965 r
.57636 .36983 m .58965 .37774 L .57896 .38008 L p F P
0 g
s
.851 .921 .877 r
.35303 .44621 m .35663 .42373 L .36813 .4183 L p F P
0 g
s
.866 .932 .865 r
.35663 .42373 m .35303 .44621 L .34185 .45362 L p F P
0 g
s
.971 .804 .618 r
.28453 .62642 m .26423 .5966 L .26858 .5844 L p F P
0 g
s
.978 .796 .589 r
.26423 .5966 m .28453 .62642 L .28124 .63895 L p F P
0 g
s
.771 .896 .931 r
.4047 .40567 m .4135 .39004 L .42543 .38871 L p F P
0 g
s
.784 .914 .928 r
.4135 .39004 m .4047 .40567 L .3922 .40927 L p F P
0 g
s
.939 .9 .76 r
.30035 .52676 m .29337 .49793 L .30197 .48816 L p F P
0 g
s
.951 .901 .738 r
.29337 .49793 m .30035 .52676 L .29273 .53775 L p F P
0 g
s
0 0 1 r
.007 w
.752 .69684 m
.76415 .68772 L
s
.5 Mabswid
.631 .821 .974 r
.5123 .3716 m .50063 .37415 L .49448 .3689 L p F P
0 g
s
.657 .83 .966 r
.4814 .37398 m .49448 .3689 L .50063 .37415 L p F P
0 g
s
.567 .77 .974 r
.5487 .37388 m .53695 .37146 L .53992 .36553 L p F P
0 g
s
.567 .77 .974 r
.53992 .36553 m .55462 .36856 L .5487 .37388 L p F P
0 g
s
.397 .602 .93 r
.64505 .40435 m .63577 .3888 L .64738 .39066 L p F P
0 g
s
.397 .602 .93 r
.64738 .39066 m .6575 .40781 L .64505 .40435 L p F P
0 g
s
.304 .479 .867 r
.69723 .44436 m .69296 .42189 L .70403 .4278 L p F P
0 g
s
.304 .479 .867 r
.70403 .4278 m .70843 .45165 L .69723 .44436 L p F P
0 g
s
.19 .155 .586 r
.7678 .62408 m .7872 .59401 L .79086 .60634 L p F P
0 g
s
.19 .155 .586 r
.79086 .60634 m .77112 .63659 L .7678 .62408 L p F P
0 g
s
.72 .872 .953 r
.43755 .38804 m .4489 .37691 L .45965 .37847 L p F P
0 g
s
.728 .893 .955 r
.4489 .37691 m .43755 .38804 L .42543 .38871 L p F P
0 g
s
0 1 0 r
.007 w
.42047 .33668 m
.43741 .38269 L
s
.5 Mabswid
.206 .298 .738 r
.75087 .52444 m .75698 .49551 L .76499 .50563 L p F P
0 g
s
.206 .298 .738 r
.76499 .50563 m .75853 .53537 L .75087 .52444 L p F P
0 g
s
.606 .808 .977 r
.52461 .37069 m .5123 .3716 L .50908 .3657 L p F P
0 g
s
.631 .821 .974 r
.49448 .3689 m .50908 .3657 L .5123 .3716 L p F P
0 g
s
.584 .79 .977 r
.53695 .37146 m .52461 .37069 L .52449 .36455 L p F P
0 g
s
.584 .79 .977 r
.52449 .36455 m .53992 .36553 L .53695 .37146 L p F P
0 g
s
.448 .668 .957 r
.61193 .38707 m .60024 .37606 L .61071 .37507 L p F P
0 g
s
.448 .668 .957 r
.61071 .37507 m .62394 .3876 L .61193 .38707 L p F P
0 g
s
0 1 0 r
.007 w
.61722 .38123 m
.63295 .34026 L
s
.5 Mabswid
.866 .932 .865 r
.34185 .45362 m .34553 .42975 L .35663 .42373 L p F P
0 g
s
.88 .943 .851 r
.34553 .42975 m .34185 .45362 L .33112 .46153 L p F P
0 g
s
.606 .808 .977 r
.50908 .3657 m .52449 .36455 L .52461 .37069 L p F P
0 g
s
.652 .851 .976 r
.49448 .3689 m .4814 .37398 L .47269 .37042 L p F P
0 g
s
.684 .855 .964 r
.45965 .37847 m .47269 .37042 L .4814 .37398 L p F P
0 g
s
.784 .914 .928 r
.3922 .40927 m .4018 .39203 L .4135 .39004 L p F P
0 g
s
.796 .931 .922 r
.4018 .39203 m .3922 .40927 L .37999 .41348 L p F P
0 g
s
.951 .901 .738 r
.29273 .53775 m .28538 .50812 L .29337 .49793 L p F P
0 g
s
.963 .901 .714 r
.28538 .50812 m .29273 .53775 L .28572 .54904 L p F P
0 g
s
.978 .796 .589 r
.28124 .63895 m .2606 .60894 L .26423 .5966 L p F P
0 g
s
.984 .785 .556 r
.2606 .60894 m .28124 .63895 L .27862 .6515 L p F P
0 g
s
.521 .746 .977 r
.56785 .3735 m .55462 .36856 L .56051 .3639 L p F P
0 g
s
.521 .746 .977 r
.56051 .3639 m .57636 .36983 L .56785 .3735 L p F P
0 g
s
.685 .877 .97 r
.47269 .37042 m .45965 .37847 L .4489 .37691 L p F P
0 g
s
.262 .445 .853 r
.70843 .45165 m .70403 .4278 L .71466 .4343 L p F P
0 g
s
.262 .445 .853 r
.71466 .4343 m .71918 .45946 L .70843 .45165 L p F P
0 g
s
1 1 0 r
.007 w
.75083 .69174 m
.76262 .68148 L
s
.5 Mabswid
.478 .71 .971 r
.58965 .37774 m .57636 .36983 L .58481 .36685 L p F P
0 g
s
.478 .71 .971 r
.58481 .36685 m .60024 .37606 L .58965 .37774 L p F P
0 g
s
.353 .575 .924 r
.6575 .40781 m .64738 .39066 L .65872 .39319 L p F P
0 g
s
.353 .575 .924 r
.65872 .39319 m .66967 .41189 L .6575 .40781 L p F P
0 g
s
.166 .257 .713 r
.75853 .53537 m .76499 .50563 L .77237 .51615 L p F P
0 g
s
.166 .257 .713 r
.77237 .51615 m .76559 .5466 L .75853 .53537 L p F P
0 g
s
.156 .112 .553 r
.77112 .63659 m .79086 .60634 L .79377 .6188 L p F P
0 g
s
.156 .112 .553 r
.79377 .6188 m .77377 .64914 L .77112 .63659 L p F P
0 g
s
.728 .893 .955 r
.42543 .38871 m .43828 .37603 L .4489 .37691 L p F P
0 g
s
.735 .914 .955 r
.43828 .37603 m .42543 .38871 L .4135 .39004 L p F P
0 g
s
.88 .943 .851 r
.33112 .46153 m .33487 .43636 L .34553 .42975 L p F P
0 g
s
.894 .953 .834 r
.33487 .43636 m .33112 .46153 L .32088 .46994 L p F P
0 g
s
.402 .647 .956 r
.62394 .3876 m .61071 .37507 L .62103 .37476 L p F P
0 g
s
.402 .647 .956 r
.62103 .37476 m .63577 .3888 L .62394 .3876 L p F P
0 g
s
1 1 0 r
.007 w
.28431 .67822 m
.29565 .68866 L
s
.5 Mabswid
.616 .839 .985 r
.50908 .3657 m .49448 .3689 L .48835 .36431 L p F P
0 g
s
.652 .851 .976 r
.47269 .37042 m .48835 .36431 L .49448 .3689 L p F P
0 g
s
.963 .901 .714 r
.28572 .54904 m .27801 .5187 L .28538 .50812 L p F P
0 g
s
.973 .899 .686 r
.27801 .5187 m .28572 .54904 L .27934 .5606 L p F P
0 g
s
.533 .772 .985 r
.55462 .36856 m .53992 .36553 L .54289 .36025 L p F P
0 g
s
.533 .772 .985 r
.54289 .36025 m .56051 .3639 L .55462 .36856 L p F P
0 g
s
.796 .931 .922 r
.37999 .41348 m .39037 .39468 L .4018 .39203 L p F P
0 g
s
.808 .948 .914 r
.39037 .39468 m .37999 .41348 L .36813 .4183 L p F P
0 g
s
.216 .406 .835 r
.71918 .45946 m .71466 .4343 L .72483 .44139 L p F P
0 g
s
.216 .406 .835 r
.72483 .44139 m .72943 .46776 L .71918 .45946 L p F P
0 g
s
.984 .785 .556 r
.27862 .6515 m .2577 .62141 L .2606 .60894 L p F P
0 g
s
.988 .772 .521 r
.2577 .62141 m .27862 .6515 L .27667 .66406 L p F P
0 g
s
.305 .544 .916 r
.66967 .41189 m .65872 .39319 L .66978 .3964 L p F P
0 g
s
.305 .544 .916 r
.66978 .3964 m .6815 .41659 L .66967 .41189 L p F P
0 g
s
.124 .212 .684 r
.76559 .5466 m .77237 .51615 L .77909 .52704 L p F P
0 g
s
.124 .212 .684 r
.77909 .52704 m .772 .55811 L .76559 .5466 L p F P
0 g
s
.582 .82 .989 r
.52449 .36455 m .50908 .3657 L .50587 .36046 L p F P
0 g
s
.616 .839 .985 r
.48835 .36431 m .50587 .36046 L .50908 .3657 L p F P
0 g
s
.553 .797 .989 r
.53992 .36553 m .52449 .36455 L .52436 .35908 L p F P
0 g
s
.553 .797 .989 r
.52436 .35908 m .54289 .36025 L .53992 .36553 L p F P
0 g
s
.685 .877 .97 r
.4489 .37691 m .46404 .36753 L .47269 .37042 L p F P
0 g
s
.684 .898 .974 r
.46404 .36753 m .4489 .37691 L .43828 .37603 L p F P
0 g
s
.642 .871 .984 r
.48835 .36431 m .47269 .37042 L .46404 .36753 L p F P
0 g
s
.894 .953 .834 r
.32088 .46994 m .32467 .44355 L .33487 .43636 L p F P
0 g
s
.906 .961 .813 r
.32467 .44355 m .32088 .46994 L .31115 .47882 L p F P
0 g
s
.119 .065 .516 r
.77377 .64914 m .79377 .6188 L .79594 .63136 L p F P
0 g
s
.119 .065 .516 r
.79594 .63136 m .77573 .6617 L .77377 .64914 L p F P
0 g
s
0 .958 0 r
.5868 .31204 m .58658 .311 L .59229 .30094 L closepath p F P
0 g
s
0 .707 0 r
.58886 .31307 m .5868 .31204 L .59229 .30094 L closepath p F P
0 g
s
0 .078 0 r
.58658 .311 m .58835 .31055 L .59229 .30094 L closepath p F P
0 g
s
0 .543 0 r
.59158 .31348 m .58886 .31307 L .59229 .30094 L closepath p F P
0 g
s
0 .324 0 r
.59335 .31304 m .59158 .31348 L .59229 .30094 L closepath p F P
0 g
s
0 .592 0 r
.59315 .312 m .59335 .31304 L .59229 .30094 L closepath p F P
0 g
s
0 .622 0 r
.59108 .31097 m .59315 .312 L .59229 .30094 L closepath p F P
0 g
s
0 .442 0 r
.58835 .31055 m .59108 .31097 L .59229 .30094 L closepath p F P
0 g
s
.431 .694 .975 r
.60024 .37606 m .58481 .36685 L .59318 .36455 L p F P
0 g
s
.431 .694 .975 r
.59318 .36455 m .61071 .37507 L .60024 .37606 L p F P
0 g
s
.582 .82 .989 r
.50587 .36046 m .52436 .35908 L .52449 .36455 L p F P
0 g
s
.478 .738 .985 r
.57636 .36983 m .56051 .3639 L .56637 .35992 L p F P
0 g
s
.478 .738 .985 r
.56637 .35992 m .58481 .36685 L .57636 .36983 L p F P
0 g
s
.735 .914 .955 r
.4135 .39004 m .42781 .37584 L .43828 .37603 L p F P
0 g
s
.74 .934 .951 r
.42781 .37584 m .4135 .39004 L .4018 .39203 L p F P
0 g
s
.973 .899 .686 r
.27934 .5606 m .27131 .52965 L .27801 .5187 L p F P
0 g
s
.982 .895 .654 r
.27131 .52965 m .27934 .5606 L .27362 .57239 L p F P
0 g
s
.808 .948 .914 r
.36813 .4183 m .37922 .39801 L .39037 .39468 L p F P
0 g
s
.818 .964 .902 r
.37922 .39801 m .36813 .4183 L .35663 .42373 L p F P
0 g
s
.166 .364 .814 r
.72943 .46776 m .72483 .44139 L .7345 .44904 L p F P
0 g
s
.166 .364 .814 r
.7345 .44904 m .73917 .47655 L .72943 .46776 L p F P
0 g
s
0 .787 0 r
.46289 .31096 m .46263 .31002 L .46393 .29866 L closepath p F P
0 g
s
0 .692 0 r
.465 .31123 m .46289 .31096 L .46393 .29866 L closepath p F P
0 g
s
0 .21 0 r
.46263 .31002 m .46437 .30898 L .46393 .29866 L closepath p F P
0 g
s
0 .573 0 r
.46772 .31069 m .465 .31123 L .46393 .29866 L closepath p F P
0 g
s
0 .448 0 r
.46947 .30964 m .46772 .31069 L .46393 .29866 L closepath p F P
0 g
s
0 0 0 r
.46921 .30871 m .46947 .30964 L .46393 .29866 L closepath p F P
0 g
s
0 .534 0 r
.4671 .30843 m .46921 .30871 L .46393 .29866 L closepath p F P
0 g
s
0 .438 0 r
.46437 .30898 m .4671 .30843 L .46393 .29866 L closepath p F P
0 g
s
.35 .621 .953 r
.63577 .3888 m .62103 .37476 L .63117 .37515 L p F P
0 g
s
.35 .621 .953 r
.63117 .37515 m .64738 .39066 L .63577 .3888 L p F P
0 g
s
.988 .772 .521 r
.27667 .66406 m .25555 .63396 L .2577 .62141 L p F P
0 g
s
.991 .755 .48 r
.25555 .63396 m .27667 .66406 L .27542 .67658 L p F P
0 g
s
.251 .508 .903 r
.6815 .41659 m .66978 .3964 L .68051 .40027 L p F P
0 g
s
.251 .508 .903 r
.68051 .40027 m .69296 .42189 L .6815 .41659 L p F P
0 g
s
.078 .163 .651 r
.772 .55811 m .77909 .52704 L .78512 .53829 L p F P
0 g
s
.078 .163 .651 r
.78512 .53829 m .77776 .56987 L .772 .55811 L p F P
0 g
s
1 1 0 r
.007 w
.76262 .68148 m
.77291 .67066 L
s
.5 Mabswid
.906 .961 .813 r
.31115 .47882 m .31498 .45129 L .32467 .44355 L p F P
0 g
s
.918 .967 .789 r
.31498 .45129 m .31115 .47882 L .30197 .48816 L p F P
0 g
s
.596 .855 .993 r
.50587 .36046 m .48835 .36431 L .48227 .36039 L p F P
0 g
s
.642 .871 .984 r
.46404 .36753 m .48227 .36039 L .48835 .36431 L p F P
0 g
s
.489 .769 .993 r
.56051 .3639 m .54289 .36025 L .54583 .35565 L p F P
0 g
s
.489 .769 .993 r
.54583 .35565 m .56637 .35992 L .56051 .3639 L p F P
0 g
s
.079 .014 .474 r
.77573 .6617 m .79594 .63136 L .79733 .64397 L p F P
0 g
s
.079 .014 .474 r
.79733 .64397 m .777 .67422 L .77573 .6617 L p F P
0 g
s
0 0 1 r
.007 w
.76415 .68772 m
.77177 .68202 L
s
.5 Mabswid
.684 .898 .974 r
.43828 .37603 m .45548 .36533 L .46404 .36753 L p F P
0 g
s
.68 .918 .973 r
.45548 .36533 m .43828 .37603 L .42781 .37584 L p F P
0 g
s
.982 .895 .654 r
.27362 .57239 m .26529 .54094 L .27131 .52965 L p F P
0 g
s
.989 .888 .618 r
.26529 .54094 m .27362 .57239 L .26858 .5844 L p F P
0 g
s
.112 .316 .789 r
.73917 .47655 m .7345 .44904 L .74364 .45724 L p F P
0 g
s
.112 .316 .789 r
.74364 .45724 m .74836 .48581 L .73917 .47655 L p F P
0 g
s
.818 .964 .902 r
.35663 .42373 m .36841 .40199 L .37922 .39801 L p F P
0 g
s
.827 .978 .886 r
.36841 .40199 m .35663 .42373 L .34553 .42975 L p F P
0 g
s
.74 .934 .951 r
.4018 .39203 m .41753 .37635 L .42781 .37584 L p F P
0 g
s
.743 .953 .944 r
.41753 .37635 m .4018 .39203 L .39037 .39468 L p F P
0 g
s
.375 .674 .975 r
.61071 .37507 m .59318 .36455 L .60144 .36297 L p F P
0 g
s
.375 .674 .975 r
.60144 .36297 m .62103 .37476 L .61071 .37507 L p F P
0 g
s
.629 .889 .987 r
.48227 .36039 m .46404 .36753 L .45548 .36533 L p F P
0 g
s
0 .654 0 r
.82433 .52098 m .82393 .51846 L .83646 .51714 L closepath p F P
0 g
s
0 .485 0 r
.82549 .52337 m .82433 .52098 L .83646 .51714 L closepath p F P
0 g
s
.425 .726 .988 r
.58481 .36685 m .56637 .35992 L .57218 .35664 L p F P
0 g
s
.425 .726 .988 r
.57218 .35664 m .59318 .36455 L .58481 .36685 L p F P
0 g
s
0 1 0 r
.007 w
.57999 .35958 m
.59022 .31084 L
s
.5 Mabswid
.551 .83 .997 r
.52436 .35908 m .50587 .36046 L .50267 .35589 L p F P
0 g
s
.596 .855 .993 r
.48227 .36039 m .50267 .35589 L .50587 .36046 L p F P
0 g
s
.291 .59 .945 r
.64738 .39066 m .63117 .37515 L .64111 .37625 L p F P
0 g
s
.291 .59 .945 r
.64111 .37625 m .65872 .39319 L .64738 .39066 L p F P
0 g
s
.515 .801 .998 r
.54289 .36025 m .52436 .35908 L .52423 .35428 L p F P
0 g
s
.515 .801 .998 r
.52423 .35428 m .54583 .35565 L .54289 .36025 L p F P
0 g
s
0 .839 0 r
.82393 .51846 m .82452 .51728 L .83646 .51714 L closepath p F P
0 g
s
0 .128 0 r
.82674 .52423 m .82549 .52337 L .83646 .51714 L closepath p F P
0 g
s
0 .997 0 r
.82733 .52305 m .82674 .52423 L .83646 .51714 L closepath p F P
0 g
s
0 .739 0 r
.82693 .52053 m .82733 .52305 L .83646 .51714 L closepath p F P
0 g
s
0 .527 0 r
.82576 .51814 m .82693 .52053 L .83646 .51714 L closepath p F P
0 g
s
0 .042 0 r
.82452 .51728 m .82576 .51814 L .83646 .51714 L closepath p F P
0 g
s
0 1 0 r
.007 w
.7833 .53489 m
.82684 .52035 L
s
.5 Mabswid
.192 .467 .886 r
.69296 .42189 m .68051 .40027 L .69089 .40481 L p F P
0 g
s
.192 .467 .886 r
.69089 .40481 m .70403 .4278 L .69296 .42189 L p F P
0 g
s
.028 .109 .614 r
.77776 .56987 m .78512 .53829 L .79045 .54985 L p F P
0 g
s
.028 .109 .614 r
.79045 .54985 m .78283 .58185 L .77776 .56987 L p F P
0 g
s
.991 .755 .48 r
.27542 .67658 m .25416 .64657 L .25555 .63396 L p F P
0 g
s
1 1 0 r
.007 w
.2745 .66723 m
.28431 .67822 L
s
.5 Mabswid
.551 .83 .997 r
.50267 .35589 m .52423 .35428 L .52436 .35908 L p F P
0 g
s
.918 .967 .789 r
.30197 .48816 m .30581 .45959 L .31498 .45129 L p F P
0 g
s
.927 .97 .76 r
.30581 .45959 m .30197 .48816 L .29337 .49793 L p F P
0 g
s
0 .716 0 r
.52736 .30116 m .52525 .30057 L .52864 .28851 L closepath p F P
0 g
s
0 .57 0 r
.53014 .30112 m .52736 .30116 L .52864 .28851 L closepath p F P
0 g
s
0 .399 0 r
.53197 .30048 m .53014 .30112 L .52864 .28851 L closepath p F P
0 g
s
0 .892 0 r
.52525 .30057 m .52505 .2997 L .52864 .28851 L closepath p F P
0 g
s
0 .176 0 r
.52505 .2997 m .52688 .29906 L .52864 .28851 L closepath p F P
0 g
s
0 0 0 r
.53178 .29961 m .53197 .30048 L .52864 .28851 L closepath p F P
0 g
s
0 .596 0 r
.52967 .29902 m .53178 .29961 L .52864 .28851 L closepath p F P
0 g
s
0 .455 0 r
.52688 .29906 m .52967 .29902 L .52864 .28851 L closepath p F P
0 g
s
0 0 .907 r
.78657 .67086 m .78442 .66924 L .79196 .66687 L closepath p F P
0 g
s
0 0 .679 r
.78759 .67336 m .78657 .67086 L .79196 .66687 L closepath p F P
0 g
s
.989 .888 .618 r
.26858 .5844 m .25998 .55254 L .26529 .54094 L p F P
0 g
s
.993 .877 .578 r
.25998 .55254 m .26858 .5844 L .26423 .5966 L p F P
0 g
s
.053 .264 .758 r
.74836 .48581 m .74364 .45724 L .75222 .46599 L p F P
0 g
s
.053 .264 .758 r
.75222 .46599 m .75698 .49551 L .74836 .48581 L p F P
0 g
s
0 0 .875 r
.78442 .66924 m .78241 .66944 L .79196 .66687 L closepath p F P
0 g
s
0 0 0 r
.7869 .67527 m .78759 .67336 L .79196 .66687 L closepath p F P
0 g
s
.827 .978 .886 r
.34553 .42975 m .35795 .40664 L .36841 .40199 L p F P
0 g
s
.833 .989 .864 r
.35795 .40664 m .34553 .42975 L .33487 .43636 L p F P
0 g
s
0 0 .33 r
.78241 .66944 m .78171 .67135 L .79196 .66687 L closepath p F P
0 g
s
.743 .953 .944 r
.39037 .39468 m .40746 .37756 L .41753 .37635 L p F P
0 g
s
.743 .97 .931 r
.40746 .37756 m .39037 .39468 L .37922 .39801 L p F P
0 g
s
.68 .918 .973 r
.42781 .37584 m .44704 .36384 L .45548 .36533 L p F P
0 g
s
.671 .936 .967 r
.44704 .36384 m .42781 .37584 L .41753 .37635 L p F P
0 g
s
0 0 .906 r
.78489 .67547 m .7869 .67527 L .79196 .66687 L closepath p F P
0 g
s
.568 .867 .995 r
.50267 .35589 m .48227 .36039 L .47623 .35718 L p F P
0 g
s
.629 .889 .987 r
.45548 .36533 m .47623 .35718 L .48227 .36039 L p F P
0 g
s
0 1 0 r
.007 w
.46583 .30869 m
.47512 .35762 L
s
.5 Mabswid
0 .051 .571 r
.78283 .58185 m .79045 .54985 L .79504 .56171 L p F P
0 g
s
0 .051 .571 r
.79504 .56171 m .7872 .59401 L .78283 .58185 L p F P
0 g
s
.436 .761 .996 r
.56637 .35992 m .54583 .35565 L .54876 .35176 L p F P
0 g
s
.436 .761 .996 r
.54876 .35176 m .57218 .35664 L .56637 .35992 L p F P
0 g
s
.125 .419 .864 r
.70403 .4278 m .69089 .40481 L .70088 .41001 L p F P
0 g
s
.125 .419 .864 r
.70088 .41001 m .71466 .4343 L .70403 .4278 L p F P
0 g
s
0 0 .663 r
.78171 .67135 m .78274 .67385 L .79196 .66687 L closepath p F P
0 g
s
0 0 1 r
.007 w
.77177 .68202 m
.78272 .6738 L
s
.5 Mabswid
.31 .646 .968 r
.62103 .37476 m .60144 .36297 L .60957 .36211 L p F P
0 g
s
.31 .646 .968 r
.60957 .36211 m .63117 .37515 L .62103 .37476 L p F P
0 g
s
.223 .552 .932 r
.65872 .39319 m .64111 .37625 L .6508 .37807 L p F P
0 g
s
.223 .552 .932 r
.6508 .37807 m .66978 .3964 L .65872 .39319 L p F P
0 g
s
.927 .97 .76 r
.29337 .49793 m .29722 .46841 L .30581 .45959 L p F P
0 g
s
.933 .969 .726 r
.29722 .46841 m .29337 .49793 L .28538 .50812 L p F P
0 g
s
0 0 .812 r
.78274 .67385 m .78489 .67547 L .79196 .66687 L closepath p F P
0 g
s
1 1 0 r
.007 w
.77291 .67066 m
.78161 .65933 L
s
.5 Mabswid
.609 .904 .985 r
.47623 .35718 m .45548 .36533 L .44704 .36384 L p F P
0 g
s
.362 .706 .985 r
.59318 .36455 m .57218 .35664 L .57792 .35408 L p F P
0 g
s
.362 .706 .985 r
.57792 .35408 m .60144 .36297 L .59318 .36455 L p F P
0 g
s
.993 .877 .578 r
.26423 .5966 m .2554 .56443 L .25998 .55254 L p F P
0 g
s
.995 .862 .531 r
.2554 .56443 m .26423 .5966 L .2606 .60894 L p F P
0 g
s
0 .206 .722 r
.75698 .49551 m .75222 .46599 L .76021 .47525 L p F P
0 g
s
0 .206 .722 r
.76021 .47525 m .76499 .50563 L .75698 .49551 L p F P
0 g
s
0 .59 0 r
.22449 .51016 m .22355 .5128 L .212 .50728 L closepath p F P
0 g
s
0 .687 0 r
.22452 .50816 m .22449 .51016 L .212 .50728 L closepath p F P
0 g
s
0 .499 0 r
.22355 .5128 m .22227 .51455 L .212 .50728 L closepath p F P
0 g
s
.511 .836 .999 r
.52423 .35428 m .50267 .35589 L .4995 .35204 L p F P
0 g
s
.568 .867 .995 r
.47623 .35718 m .4995 .35204 L .50267 .35589 L p F P
0 g
s
0 .094 0 r
.22227 .51455 m .22138 .51437 L .212 .50728 L closepath p F P
0 g
s
0 .499 0 r
.22138 .51437 m .22141 .51237 L .212 .50728 L closepath p F P
0 g
s
0 .611 0 r
.22364 .50798 m .22452 .50816 L .212 .50728 L closepath p F P
0 g
s
0 .284 0 r
.22235 .50972 m .22364 .50798 L .212 .50728 L closepath p F P
0 g
s
0 .449 0 r
.22141 .51237 m .22235 .50972 L .212 .50728 L closepath p F P
0 g
s
.465 .799 .999 r
.54583 .35565 m .52423 .35428 L .5241 .3502 L p F P
0 g
s
.465 .799 .999 r
.5241 .3502 m .54876 .35176 L .54583 .35565 L p F P
0 g
s
0 1 0 r
.007 w
.52798 .35044 m
.52853 .29904 L
s
.5 Mabswid
.833 .989 .864 r
.33487 .43636 m .34789 .41195 L .35795 .40664 L p F P
0 g
s
.836 .997 .837 r
.34789 .41195 m .33487 .43636 L .32467 .44355 L p F P
0 g
s
1 1 0 r
.007 w
.26631 .65576 m
.2745 .66723 L
s
.5 Mabswid
.511 .836 .999 r
.4995 .35204 m .5241 .3502 L .52423 .35428 L p F P
0 g
s
.859 0 0 r
.79846 .57971 m .79642 .57872 L .79901 .56749 L closepath p F P
0 g
s
.68 0 0 r
.80131 .57955 m .79846 .57971 L .79901 .56749 L closepath p F P
0 g
s
.469 0 0 r
.8033 .57832 m .80131 .57955 L .79901 .56749 L closepath p F P
0 g
s
.634 0 0 r
.79838 .5759 m .80124 .57574 L .79901 .56749 L closepath p F P
0 g
s
.916 0 0 r
.79642 .57872 m .79639 .57714 L .79901 .56749 L closepath p F P
0 g
s
.287 0 0 r
.79639 .57714 m .79838 .5759 L .79901 .56749 L closepath p F P
0 g
s
0 0 .523 r
.7872 .59401 m .79504 .56171 L .79888 .57383 L p F P
0 g
s
0 0 .523 r
.79888 .57383 m .79086 .60634 L .7872 .59401 L p F P
0 g
s
.743 .97 .931 r
.37922 .39801 m .39763 .37949 L .40746 .37756 L p F P
0 g
s
.738 .982 .911 r
.39763 .37949 m .37922 .39801 L .36841 .40199 L p F P
0 g
s
.052 .365 .835 r
.71466 .4343 m .70088 .41001 L .71044 .41588 L p F P
0 g
s
.052 .365 .835 r
.71044 .41588 m .72483 .44139 L .71466 .4343 L p F P
0 g
s
.933 .969 .726 r
.28538 .50812 m .28921 .47774 L .29722 .46841 L p F P
0 g
s
.936 .965 .685 r
.28921 .47774 m .28538 .50812 L .27801 .5187 L p F P
0 g
s
.671 .936 .967 r
.41753 .37635 m .43872 .36307 L .44704 .36384 L p F P
0 g
s
.656 .949 .953 r
.43872 .36307 m .41753 .37635 L .40746 .37756 L p F P
0 g
s
.146 .505 .91 r
.66978 .3964 m .6508 .37807 L .66023 .38061 L p F P
0 g
s
.146 .505 .91 r
.66023 .38061 m .68051 .40027 L .66978 .3964 L p F P
0 g
s
.233 .609 .953 r
.63117 .37515 m .60957 .36211 L .61754 .36199 L p F P
0 g
s
.233 .609 .953 r
.61754 .36199 m .64111 .37625 L .63117 .37515 L p F P
0 g
s
0 .142 .679 r
.76499 .50563 m .76021 .47525 L .76757 .48501 L p F P
0 g
s
0 .142 .679 r
.76757 .48501 m .77237 .51615 L .76499 .50563 L p F P
0 g
s
.995 .862 .531 r
.2606 .60894 m .25157 .57656 L .2554 .56443 L p F P
0 g
s
.992 .842 .479 r
.25157 .57656 m .2606 .60894 L .2577 .62141 L p F P
0 g
s
.531 .874 .989 r
.4995 .35204 m .47623 .35718 L .47027 .35469 L p F P
0 g
s
.609 .904 .985 r
.44704 .36384 m .47027 .35469 L .47623 .35718 L p F P
0 g
s
.369 .745 .989 r
.57218 .35664 m .54876 .35176 L .55165 .3486 L p F P
0 g
s
.369 .745 .989 r
.55165 .3486 m .57792 .35408 L .57218 .35664 L p F P
0 g
s
.58 .914 .973 r
.47027 .35469 m .44704 .36384 L .43872 .36307 L p F P
0 g
s
.836 .997 .837 r
.32467 .44355 m .33826 .41792 L .34789 .41195 L p F P
0 g
s
.835 .999 .801 r
.33826 .41792 m .32467 .44355 L .31498 .45129 L p F P
0 g
s
.286 .677 .973 r
.60144 .36297 m .57792 .35408 L .58357 .35226 L p F P
0 g
s
.286 .677 .973 r
.58357 .35226 m .60957 .36211 L .60144 .36297 L p F P
0 g
s
0 0 .468 r
.79086 .60634 m .79888 .57383 L .80194 .58617 L p F P
0 g
s
0 0 .468 r
.80194 .58617 m .79377 .6188 L .79086 .60634 L p F P
0 g
s
.936 .965 .685 r
.27801 .5187 m .28184 .48757 L .28921 .47774 L p F P
0 g
s
.935 .954 .637 r
.28184 .48757 m .27801 .5187 L .27131 .52965 L p F P
0 g
s
0 1 0 r
.007 w
.22194 .51089 m
.2715 .5289 L
s
.5 Mabswid
0 .303 .798 r
.72483 .44139 m .71044 .41588 L .71955 .42239 L p F P
0 g
s
0 .303 .798 r
.71955 .42239 m .7345 .44904 L .72483 .44139 L p F P
0 g
s
.738 .982 .911 r
.36841 .40199 m .38807 .38213 L .39763 .37949 L p F P
0 g
s
.728 .988 .881 r
.38807 .38213 m .36841 .40199 L .35795 .40664 L p F P
0 g
s
1 1 0 r
.007 w
.78161 .65933 m
.78861 .64756 L
s
.5 Mabswid
.458 .833 .99 r
.5241 .3502 m .4995 .35204 L .49637 .34891 L p F P
0 g
s
.531 .874 .989 r
.47027 .35469 m .49637 .34891 L .4995 .35204 L p F P
0 g
s
.402 .788 .99 r
.54876 .35176 m .5241 .3502 L .52398 .34684 L p F P
0 g
s
.402 .788 .99 r
.52398 .34684 m .55165 .3486 L .54876 .35176 L p F P
0 g
s
0 .072 .629 r
.77237 .51615 m .76757 .48501 L .77428 .49525 L p F P
0 g
s
0 .072 .629 r
.77428 .49525 m .77909 .52704 L .77237 .51615 L p F P
0 g
s
.059 .449 .879 r
.68051 .40027 m .66023 .38061 L .66935 .38388 L p F P
0 g
s
.059 .449 .879 r
.66935 .38388 m .69089 .40481 L .68051 .40027 L p F P
0 g
s
.992 .842 .479 r
.2577 .62141 m .24851 .58892 L .25157 .57656 L p F P
0 g
s
.984 .817 .42 r
.24851 .58892 m .2577 .62141 L .25555 .63396 L p F P
0 g
s
.656 .949 .953 r
.40746 .37756 m .43057 .36304 L .43872 .36307 L p F P
0 g
s
.634 .955 .929 r
.43057 .36304 m .40746 .37756 L .39763 .37949 L p F P
0 g
s
.458 .833 .99 r
.49637 .34891 m .52398 .34684 L .5241 .3502 L p F P
0 g
s
.144 .562 .927 r
.64111 .37625 m .61754 .36199 L .62533 .36262 L p F P
0 g
s
.144 .562 .927 r
.62533 .36262 m .6508 .37807 L .64111 .37625 L p F P
0 g
s
.835 .999 .801 r
.31498 .45129 m .32908 .42452 L .33826 .41792 L p F P
0 g
s
.827 .995 .757 r
.32908 .42452 m .31498 .45129 L .30581 .45959 L p F P
0 g
s
0 .677 0 r
.72955 .36497 m .72773 .36316 L .73774 .35502 L closepath p F P
0 g
s
0 .486 0 r
.73177 .36645 m .72955 .36497 L .73774 .35502 L closepath p F P
0 g
s
0 .677 0 r
.72955 .36497 m .72773 .36316 L .73774 .35502 L closepath p F P
0 g
s
0 .486 0 r
.73177 .36645 m .72955 .36497 L .73774 .35502 L closepath p F P
0 g
s
1 1 0 r
.007 w
.25984 .64387 m
.26631 .65576 L
s
.5 Mabswid
0 0 .407 r
.79377 .6188 m .80194 .58617 L .80422 .59872 L p F P
0 g
s
0 0 .407 r
.80422 .59872 m .79594 .63136 L .79377 .6188 L p F P
0 g
s
0 .109 0 r
.73311 .36673 m .73177 .36645 L .73774 .35502 L closepath p F P
0 g
s
0 .109 0 r
.73311 .36673 m .73177 .36645 L .73774 .35502 L closepath p F P
0 g
s
0 .944 0 r
.72773 .36316 m .72738 .36207 L .73774 .35502 L closepath p F P
0 g
s
0 .944 0 r
.72773 .36316 m .72738 .36207 L .73774 .35502 L closepath p F P
0 g
s
.935 .954 .637 r
.27131 .52965 m .27511 .49786 L .28184 .48757 L p F P
0 g
s
.928 .938 .582 r
.27511 .49786 m .27131 .52965 L .26529 .54094 L p F P
0 g
s
0 0 0 r
.72738 .36207 m .72871 .36235 L .73774 .35502 L closepath p F P
0 g
s
0 .935 0 r
.73276 .36565 m .73311 .36673 L .73774 .35502 L closepath p F P
0 g
s
0 .669 0 r
.73094 .36383 m .73276 .36565 L .73774 .35502 L closepath p F P
0 g
s
0 .45 0 r
.72871 .36235 m .73094 .36383 L .73774 .35502 L closepath p F P
0 g
s
0 0 0 r
.72738 .36207 m .72871 .36235 L .73774 .35502 L closepath p F P
0 g
s
0 .935 0 r
.73276 .36565 m .73311 .36673 L .73774 .35502 L closepath p F P
0 g
s
0 .669 0 r
.73094 .36383 m .73276 .36565 L .73774 .35502 L closepath p F P
0 g
s
0 .45 0 r
.72871 .36235 m .73094 .36383 L .73774 .35502 L closepath p F P
0 g
s
.481 .871 .97 r
.49637 .34891 m .47027 .35469 L .4644 .35294 L p F P
0 g
s
.58 .914 .973 r
.43872 .36307 m .4644 .35294 L .47027 .35469 L p F P
0 g
s
0 .233 .751 r
.7345 .44904 m .71955 .42239 L .72817 .42954 L p F P
0 g
s
0 .233 .751 r
.72817 .42954 m .74364 .45724 L .7345 .44904 L p F P
0 g
s
0 0 .839 r
.24644 .64537 m .24914 .64448 L .2497 .65421 L closepath p F P
0 g
s
0 0 .679 r
.24517 .64757 m .24644 .64537 L .2497 .65421 L closepath p F P
0 g
s
0 0 0 r
.24607 .64981 m .24517 .64757 L .2497 .65421 L closepath p F P
0 g
s
0 0 .943 r
.24863 .65078 m .24607 .64981 L .2497 .65421 L closepath p F P
0 g
s
0 0 .617 r
.25169 .64544 m .2526 .64768 L .2497 .65421 L closepath p F P
0 g
s
0 0 .847 r
.24914 .64448 m .25169 .64544 L .2497 .65421 L closepath p F P
0 g
s
0 0 .962 r
.25133 .64989 m .24863 .65078 L .2497 .65421 L closepath p F P
0 g
s
0 0 .446 r
.2526 .64768 m .25133 .64989 L .2497 .65421 L closepath p F P
0 g
s
.288 .716 .969 r
.57792 .35408 m .55165 .3486 L .5545 .34619 L p F P
0 g
s
.288 .716 .969 r
.5545 .34619 m .58357 .35226 L .57792 .35408 L p F P
0 g
s
.541 .914 .947 r
.4644 .35294 m .43872 .36307 L .43057 .36304 L p F P
0 g
s
.728 .988 .881 r
.35795 .40664 m .37882 .3855 L .38807 .38213 L p F P
0 g
s
.71 .986 .841 r
.37882 .3855 m .35795 .40664 L .34789 .41195 L p F P
0 g
s
.195 .635 .946 r
.60957 .36211 m .58357 .35226 L .58912 .35121 L p F P
0 g
s
.195 .635 .946 r
.58912 .35121 m .61754 .36199 L .60957 .36211 L p F P
0 g
s
0 0 .571 r
.77909 .52704 m .77428 .49525 L .78031 .50593 L p F P
0 g
s
0 0 .571 r
.78031 .50593 m .78512 .53829 L .77909 .52704 L p F P
0 g
s
0 0 0 r
.80328 .57674 m .8033 .57832 L .79901 .56749 L closepath p F P
0 g
s
.854 0 0 r
.80124 .57574 m .80328 .57674 L .79901 .56749 L closepath p F P
0 g
s
1 0 0 r
.007 w
.79969 .57583 m
.79985 .57775 L
s
.5 Mabswid
.984 .817 .42 r
.25555 .63396 m .24624 .60146 L .24851 .58892 L p F P
0 g
s
.97 .784 .354 r
.24624 .60146 m .25555 .63396 L .25416 .64657 L p F P
0 g
s
0 .383 .836 r
.69089 .40481 m .66935 .38388 L .67815 .38787 L p F P
0 g
s
0 .383 .836 r
.67815 .38787 m .70088 .41001 L .69089 .40481 L p F P
0 g
s
0 1 0 r
.007 w
.69689 .40613 m
.73078 .36373 L
s
.5 Mabswid
.827 .995 .757 r
.30581 .45959 m .3204 .43176 L .32908 .42452 L p F P
0 g
s
.813 .982 .703 r
.3204 .43176 m .30581 .45959 L .29722 .46841 L p F P
0 g
s
.634 .955 .929 r
.39763 .37949 m .42261 .36376 L .43057 .36304 L p F P
0 g
s
.601 .951 .89 r
.42261 .36376 m .39763 .37949 L .38807 .38213 L p F P
0 g
s
0 .614 0 r
.32723 .35713 m .32497 .35884 L .31829 .34778 L closepath p F P
0 g
s
0 .584 0 r
.32854 .3556 m .32723 .35713 L .31829 .34778 L closepath p F P
0 g
s
0 .642 0 r
.32497 .35884 m .32308 .35974 L .31829 .34778 L closepath p F P
0 g
s
0 0 .338 r
.79594 .63136 m .80422 .59872 L .80569 .61142 L p F P
0 g
s
0 0 .338 r
.80569 .61142 m .79733 .64397 L .79594 .63136 L p F P
0 g
s
1 0 0 r
.007 w
.80336 .62049 m
.80375 .62518 L
s
.5 Mabswid
.928 .938 .582 r
.26529 .54094 m .26907 .50859 L .27511 .49786 L p F P
0 g
s
.914 .913 .518 r
.26907 .50859 m .26529 .54094 L .25998 .55254 L p F P
0 g
s
.39 .817 .965 r
.52398 .34684 m .49637 .34891 L .49328 .34653 L p F P
0 g
s
.481 .871 .97 r
.4644 .35294 m .49328 .34653 L .49637 .34891 L p F P
0 g
s
.322 .763 .965 r
.55165 .3486 m .52398 .34684 L .52385 .34424 L p F P
0 g
s
.322 .763 .965 r
.52385 .34424 m .5545 .34619 L .55165 .3486 L p F P
0 g
s
.043 .502 .887 r
.6508 .37807 m .62533 .36262 L .63291 .36401 L p F P
0 g
s
.043 .502 .887 r
.63291 .36401 m .66023 .38061 L .6508 .37807 L p F P
0 g
s
0 .452 0 r
.32308 .35974 m .32267 .3593 L .31829 .34778 L closepath p F P
0 g
s
0 .372 0 r
.32267 .3593 m .32398 .35777 L .31829 .34778 L closepath p F P
0 g
s
0 .181 0 r
.32814 .35516 m .32854 .3556 L .31829 .34778 L closepath p F P
0 g
s
0 .448 0 r
.32625 .35606 m .32814 .35516 L .31829 .34778 L closepath p F P
0 g
s
0 .469 0 r
.32398 .35777 m .32625 .35606 L .31829 .34778 L closepath p F P
0 g
s
0 .155 .693 r
.74364 .45724 m .72817 .42954 L .73627 .43732 L p F P
0 g
s
0 .155 .693 r
.73627 .43732 m .75222 .46599 L .74364 .45724 L p F P
0 g
s
.39 .817 .965 r
.49328 .34653 m .52385 .34424 L .52398 .34684 L p F P
0 g
s
1 1 0 r
.007 w
.78861 .64756 m
.79385 .63542 L
s
.5 Mabswid
0 0 .504 r
.78512 .53829 m .78031 .50593 L .78564 .51705 L p F P
0 g
s
0 0 .504 r
.78564 .51705 m .79045 .54985 L .78512 .53829 L p F P
0 g
s
.97 .784 .354 r
.25416 .64657 m .24477 .61416 L .24624 .60146 L p F P
0 g
s
0 0 1 r
.007 w
.24654 .62874 m
.24925 .65057 L
s
.24531 .61884 m
.24654 .62874 L
s
.24507 .61692 m
.24531 .61884 L
s
.5 Mabswid
.71 .986 .841 r
.34789 .41195 m .36991 .38958 L .37882 .3855 L p F P
0 g
s
.682 .973 .787 r
.36991 .38958 m .34789 .41195 L .33826 .41792 L p F P
0 g
s
0 1 0 r
.007 w
.32517 .35687 m
.358 .40025 L
s
.5 Mabswid
.541 .914 .947 r
.43057 .36304 m .45864 .35195 L .4644 .35294 L p F P
0 g
s
.488 .9 .904 r
.45864 .35195 m .43057 .36304 L .42261 .36376 L p F P
0 g
s
.415 .853 .931 r
.49328 .34653 m .4644 .35294 L .45864 .35195 L p F P
0 g
s
0 .306 .779 r
.70088 .41001 m .67815 .38787 L .68658 .39259 L p F P
0 g
s
0 .306 .779 r
.68658 .39259 m .71044 .41588 L .70088 .41001 L p F P
0 g
s
.189 .671 .93 r
.58357 .35226 m .5545 .34619 L .55729 .34455 L p F P
0 g
s
.189 .671 .93 r
.55729 .34455 m .58912 .35121 L .58357 .35226 L p F P
0 g
s
.088 .578 .901 r
.61754 .36199 m .58912 .35121 L .59455 .35093 L p F P
0 g
s
.088 .578 .901 r
.59455 .35093 m .62533 .36262 L .61754 .36199 L p F P
0 g
s
.679 0 0 r
.25109 .57118 m .24828 .57135 L .24986 .55908 L closepath p F P
0 g
s
.392 0 0 r
.25268 .56994 m .25109 .57118 L .24986 .55908 L closepath p F P
0 g
s
.847 0 0 r
.24974 .56734 m .25212 .56835 L .24986 .55908 L closepath p F P
0 g
s
.84 0 0 r
.24828 .57135 m .2459 .57034 L .24986 .55908 L closepath p F P
0 g
s
.629 0 0 r
.24692 .5675 m .24974 .56734 L .24986 .55908 L closepath p F P
0 g
s
.991 0 0 r
.2459 .57034 m .24533 .56875 L .24986 .55908 L closepath p F P
0 g
s
.067 0 0 r
.24533 .56875 m .24692 .5675 L .24986 .55908 L closepath p F P
0 g
s
.771 0 0 r
.25212 .56835 m .25268 .56994 L .24986 .55908 L closepath p F P
0 g
s
1 0 0 r
.007 w
.24507 .61692 m
.24518 .61557 L
s
.5 Mabswid
.813 .982 .703 r
.29722 .46841 m .31225 .43962 L .3204 .43176 L p F P
0 g
s
.79 .959 .637 r
.31225 .43962 m .29722 .46841 L .28921 .47774 L p F P
0 g
s
.914 .913 .518 r
.25998 .55254 m .26373 .51975 L .26907 .50859 L p F P
0 g
s
.892 .879 .446 r
.26373 .51975 m .25998 .55254 L .2554 .56443 L p F P
0 g
s
1 1 0 r
.007 w
.25517 .63163 m
.25984 .64387 L
s
.5 Mabswid
.601 .951 .89 r
.38807 .38213 m .41485 .36524 L .42261 .36376 L p F P
0 g
s
.556 .933 .834 r
.41485 .36524 m .38807 .38213 L .37882 .3855 L p F P
0 g
s
0 .069 .624 r
.75222 .46599 m .73627 .43732 L .74382 .44571 L p F P
0 g
s
0 .069 .624 r
.74382 .44571 m .76021 .47525 L .75222 .46599 L p F P
0 g
s
0 0 .428 r
.79045 .54985 m .78564 .51705 L .79024 .52856 L p F P
0 g
s
0 0 .428 r
.79024 .52856 m .79504 .56171 L .79045 .54985 L p F P
0 g
s
0 .427 .828 r
.66023 .38061 m .63291 .36401 L .64026 .36618 L p F P
0 g
s
0 .427 .828 r
.64026 .36618 m .66935 .38388 L .66023 .38061 L p F P
0 g
s
.304 .783 .918 r
.52385 .34424 m .49328 .34653 L .49025 .34493 L p F P
0 g
s
.415 .853 .931 r
.45864 .35195 m .49025 .34493 L .49328 .34653 L p F P
0 g
s
.682 .973 .787 r
.33826 .41792 m .36136 .39439 L .36991 .38958 L p F P
0 g
s
.644 .946 .718 r
.36136 .39439 m .33826 .41792 L .32908 .42452 L p F P
0 g
s
.225 .72 .917 r
.5545 .34619 m .52385 .34424 L .52373 .34241 L p F P
0 g
s
.225 .72 .917 r
.52373 .34241 m .55729 .34455 L .5545 .34619 L p F P
0 g
s
.79 .959 .637 r
.28921 .47774 m .30464 .44808 L .31225 .43962 L p F P
0 g
s
.757 .923 .561 r
.30464 .44808 m .28921 .47774 L .28184 .48757 L p F P
0 g
s
.892 .879 .446 r
.2554 .56443 m .25912 .53129 L .26373 .51975 L p F P
0 g
s
.86 .835 .365 r
.25912 .53129 m .2554 .56443 L .25157 .57656 L p F P
0 g
s
.304 .783 .918 r
.49025 .34493 m .52373 .34241 L .52385 .34424 L p F P
0 g
s
0 .219 .707 r
.71044 .41588 m .68658 .39259 L .69463 .39803 L p F P
0 g
s
0 .219 .707 r
.69463 .39803 m .71955 .42239 L .71044 .41588 L p F P
0 g
s
.488 .9 .904 r
.42261 .36376 m .453 .35173 L .45864 .35195 L p F P
0 g
s
.42 .867 .838 r
.453 .35173 m .42261 .36376 L .41485 .36524 L p F P
0 g
s
.333 .815 .868 r
.49025 .34493 m .45864 .35195 L .453 .35173 L p F P
0 g
s
0 0 .544 r
.76021 .47525 m .74382 .44571 L .75079 .4547 L p F P
0 g
s
0 0 .544 r
.75079 .4547 m .76757 .48501 L .76021 .47525 L p F P
0 g
s
0 .502 .833 r
.62533 .36262 m .59455 .35093 L .59984 .35144 L p F P
0 g
s
0 .502 .833 r
.59984 .35144 m .63291 .36401 L .62533 .36262 L p F P
0 g
s
0 0 .344 r
.79504 .56171 m .79024 .52856 L .79409 .54045 L p F P
0 g
s
0 0 .344 r
.79409 .54045 m .79888 .57383 L .79504 .56171 L p F P
0 g
s
1 1 0 r
.007 w
.79385 .63542 m
.79723 .62299 L
s
.5 Mabswid
.074 .605 .865 r
.58912 .35121 m .55729 .34455 L .56003 .3437 L p F P
0 g
s
.074 .605 .865 r
.56003 .3437 m .59455 .35093 L .58912 .35121 L p F P
0 g
s
.556 .933 .834 r
.37882 .3855 m .40734 .36749 L .41485 .36524 L p F P
0 g
s
.498 .896 .759 r
.40734 .36749 m .37882 .3855 L .36991 .38958 L p F P
0 g
s
0 .339 .749 r
.66935 .38388 m .64026 .36618 L .64735 .36912 L p F P
0 g
s
0 .339 .749 r
.64735 .36912 m .67815 .38787 L .66935 .38388 L p F P
0 g
s
.644 .946 .718 r
.32908 .42452 m .35321 .39991 L .36136 .39439 L p F P
0 g
s
.594 .903 .634 r
.35321 .39991 m .32908 .42452 L .3204 .43176 L p F P
0 g
s
.86 .835 .365 r
.25157 .57656 m .25527 .54319 L .25912 .53129 L p F P
0 g
s
.819 .781 .277 r
.25527 .54319 m .25157 .57656 L .24851 .58892 L p F P
0 g
s
.757 .923 .561 r
.28184 .48757 m .29763 .45713 L .30464 .44808 L p F P
0 g
s
.713 .875 .474 r
.29763 .45713 m .28184 .48757 L .27511 .49786 L p F P
0 g
s
1 1 0 r
.007 w
.25237 .61913 m
.25517 .63163 L
s
.5 Mabswid
0 .123 .619 r
.71955 .42239 m .69463 .39803 L .70225 .40418 L p F P
0 g
s
0 .123 .619 r
.70225 .40418 m .72817 .42954 L .71955 .42239 L p F P
0 g
s
.201 .726 .842 r
.52373 .34241 m .49025 .34493 L .48728 .34411 L p F P
0 g
s
.333 .815 .868 r
.453 .35173 m .48728 .34411 L .49025 .34493 L p F P
0 g
s
.112 .654 .841 r
.55729 .34455 m .52373 .34241 L .52361 .34138 L p F P
0 g
s
.112 .654 .841 r
.52361 .34138 m .56003 .3437 L .55729 .34455 L p F P
0 g
s
0 0 .454 r
.76757 .48501 m .75079 .4547 L .75715 .46427 L p F P
0 g
s
0 0 .454 r
.75715 .46427 m .77428 .49525 L .76757 .48501 L p F P
0 g
s
0 0 .254 r
.79888 .57383 m .79409 .54045 L .79716 .55267 L p F P
0 g
s
0 0 .254 r
.79716 .55267 m .80194 .58617 L .79888 .57383 L p F P
0 g
s
0 .615 0 r
.86009 .62522 m .86037 .62286 L .87318 .62621 L closepath p F P
0 g
s
0 .49 0 r
.86016 .62806 m .86009 .62522 L .87318 .62621 L closepath p F P
0 g
s
.42 .867 .838 r
.41485 .36524 m .44751 .3523 L .453 .35173 L p F P
0 g
s
.338 .812 .749 r
.44751 .3523 m .41485 .36524 L .40734 .36749 L p F P
0 g
s
0 .234 0 r
.86053 .6297 m .86016 .62806 L .87318 .62621 L closepath p F P
0 g
s
.201 .726 .842 r
.48728 .34411 m .52361 .34138 L .52373 .34241 L p F P
0 g
s
0 .655 0 r
.86037 .62286 m .86084 .62234 L .87318 .62621 L closepath p F P
0 g
s
0 .41 .741 r
.63291 .36401 m .59984 .35144 L .60497 .35275 L p F P
0 g
s
0 .41 .741 r
.60497 .35275 m .64026 .36618 L .63291 .36401 L p F P
0 g
s
.498 .896 .759 r
.36991 .38958 m .40009 .37051 L .40734 .36749 L p F P
0 g
s
.427 .84 .664 r
.40009 .37051 m .36991 .38958 L .36136 .39439 L p F P
0 g
s
.236 .753 .778 r
.48728 .34411 m .453 .35173 L .44751 .3523 L p F P
0 g
s
0 .879 0 r
.861 .62919 m .86053 .6297 L .87318 .62621 L closepath p F P
0 g
s
.819 .781 .277 r
.24851 .58892 m .25219 .55542 L .25527 .54319 L p F P
0 g
s
.769 .717 .183 r
.25219 .55542 m .24851 .58892 L .24624 .60146 L p F P
0 g
s
1 0 0 r
.007 w
.24663 .59803 m
.24917 .56737 L
s
.24655 .59907 m
.24663 .59803 L
s
.5 Mabswid
0 .742 0 r
.86128 .62682 m .861 .62919 L .87318 .62621 L closepath p F P
0 g
s
0 .586 0 r
.86122 .62398 m .86128 .62682 L .87318 .62621 L closepath p F P
0 g
s
0 .345 0 r
.86084 .62234 m .86122 .62398 L .87318 .62621 L closepath p F P
0 g
s
0 1 0 r
.007 w
.80375 .62518 m
.86126 .62603 L
s
.5 Mabswid
0 .519 .773 r
.59455 .35093 m .56003 .3437 L .5627 .34366 L p F P
0 g
s
0 .519 .773 r
.5627 .34366 m .59984 .35144 L .59455 .35093 L p F P
0 g
s
.713 .875 .474 r
.27511 .49786 m .29123 .46675 L .29763 .45713 L p F P
0 g
s
.66 .815 .378 r
.29123 .46675 m .27511 .49786 L .26907 .50859 L p F P
0 g
s
.594 .903 .634 r
.3204 .43176 m .34549 .40615 L .35321 .39991 L p F P
0 g
s
.532 .844 .537 r
.34549 .40615 m .3204 .43176 L .31225 .43962 L p F P
0 g
s
0 .239 .652 r
.67815 .38787 m .64735 .36912 L .65416 .37284 L p F P
0 g
s
0 .239 .652 r
.65416 .37284 m .68658 .39259 L .67815 .38787 L p F P
0 g
s
0 .022 .519 r
.72817 .42954 m .70225 .40418 L .70942 .41105 L p F P
0 g
s
0 .022 .519 r
.70942 .41105 m .73627 .43732 L .72817 .42954 L p F P
0 g
s
0 0 .158 r
.80194 .58617 m .79716 .55267 L .79944 .56519 L p F P
0 g
s
0 0 .158 r
.79944 .56519 m .80422 .59872 L .80194 .58617 L p F P
0 g
s
0 0 .355 r
.77428 .49525 m .75715 .46427 L .76287 .47439 L p F P
0 g
s
0 0 .355 r
.76287 .47439 m .78031 .50593 L .77428 .49525 L p F P
0 g
s
1 1 0 r
.007 w
.79723 .62299 m
.79869 .61035 L
s
.5 Mabswid
.769 .717 .183 r
.24624 .60146 m .24991 .56795 L .25219 .55542 L p F P
0 g
s
.709 .644 .086 r
.24991 .56795 m .24624 .60146 L .24477 .61416 L p F P
0 g
s
.086 .645 .738 r
.52361 .34138 m .48728 .34411 L .48438 .34411 L p F P
0 g
s
.236 .753 .778 r
.44751 .3523 m .48438 .34411 L .48728 .34411 L p F P
0 g
s
0 .565 .736 r
.56003 .3437 m .52361 .34138 L .5235 .34116 L p F P
0 g
s
0 .565 .736 r
.5235 .34116 m .5627 .34366 L .56003 .3437 L p F P
0 g
s
.66 .815 .378 r
.26907 .50859 m .28547 .47692 L .29123 .46675 L p F P
0 g
s
0 0 0 r
.28547 .47692 m .26907 .50859 L .26373 .51975 L p F P
0 g
s
.338 .812 .749 r
.40734 .36749 m .44218 .35368 L .44751 .3523 L p F P
0 g
s
0 0 0 r
.44218 .35368 m .40734 .36749 L .40009 .37051 L p F P
0 g
s
1 1 0 r
.007 w
.25151 .60644 m
.25237 .61913 L
s
.5 Mabswid
.427 .84 .664 r
.36136 .39439 m .39312 .3743 L .40009 .37051 L p F P
0 g
s
0 0 0 r
.39312 .3743 m .36136 .39439 L .35321 .39991 L p F P
0 g
s
0 .586 0 r
.18794 .61528 m .18781 .61813 L .17483 .61588 L closepath p F P
0 g
s
0 .729 0 r
.1878 .61289 m .18794 .61528 L .17483 .61588 L closepath p F P
0 g
s
.532 .844 .537 r
.31225 .43962 m .33823 .41309 L .34549 .40615 L p F P
0 g
s
0 0 0 r
.33823 .41309 m .31225 .43962 L .30464 .44808 L p F P
0 g
s
.286 0 0 r
.64026 .36618 m .60497 .35275 L .60993 .35489 L p F P
0 g
s
.286 0 0 r
.60993 .35489 m .64735 .36912 L .64026 .36618 L p F P
0 g
s
0 .378 0 r
.18781 .61813 m .18749 .61978 L .17483 .61588 L closepath p F P
0 g
s
.086 .645 .738 r
.48438 .34411 m .5235 .34116 L .52361 .34138 L p F P
0 g
s
0 .912 0 r
.18747 .61236 m .1878 .61289 L .17483 .61588 L closepath p F P
0 g
s
.729 .524 0 r
.80422 .59872 m .79944 .56519 L .80091 .57797 L p F P
0 g
s
.729 .524 0 r
.80091 .57797 m .80569 .61142 L .80422 .59872 L p F P
0 g
s
0 0 1 r
.007 w
.80613 .61454 m
.80903 .60161 L
s
.80375 .62518 m
.80613 .61454 L
s
.5 Mabswid
.433 0 0 r
.68658 .39259 m .65416 .37284 L .66066 .37735 L p F P
0 g
s
.433 0 0 r
.66066 .37735 m .69463 .39803 L .68658 .39259 L p F P
0 g
s
0 0 0 r
.48438 .34411 m .44751 .3523 L .44218 .35368 L p F P
0 g
s
.694 .307 0 r
.78031 .50593 m .76287 .47439 L .76792 .48505 L p F P
0 g
s
.694 .307 0 r
.76792 .48505 m .78564 .51705 L .78031 .50593 L p F P
0 g
s
0 .598 0 r
.18749 .61978 m .18716 .61925 L .17483 .61588 L closepath p F P
0 g
s
.584 .08 0 r
.73627 .43732 m .70942 .41105 L .71611 .41862 L p F P
0 g
s
.584 .08 0 r
.71611 .41862 m .74382 .44571 L .73627 .43732 L p F P
0 g
s
.182 0 0 r
.59984 .35144 m .5627 .34366 L .5653 .34445 L p F P
0 g
s
.182 0 0 r
.5653 .34445 m .60497 .35275 L .59984 .35144 L p F P
0 g
s
0 .184 0 r
.18715 .614 m .18747 .61236 L .17483 .61588 L closepath p F P
0 g
s
0 .482 0 r
.18702 .61686 m .18715 .614 L .17483 .61588 L closepath p F P
0 g
s
0 1 0 r
.007 w
.18706 .61606 m
.24507 .61692 L
s
.5 Mabswid
0 .618 0 r
.18716 .61925 m .18702 .61686 L .17483 .61588 L closepath p F P
0 g
s
.709 .644 .086 r
.24477 .61416 m .24843 .58073 L .24991 .56795 L p F P
0 g
s
0 0 0 r
.26373 .51975 m .28038 .48761 L .28547 .47692 L p F P
0 g
s
0 0 0 r
.28038 .48761 m .26373 .51975 L .25912 .53129 L p F P
0 g
s
0 0 0 r
.30464 .44808 m .33145 .42072 L .33823 .41309 L p F P
0 g
s
0 0 0 r
.33145 .42072 m .30464 .44808 L .29763 .45713 L p F P
0 g
s
0 0 0 r
.35321 .39991 m .38648 .37888 L .39312 .3743 L p F P
0 g
s
0 0 0 r
.38648 .37888 m .35321 .39991 L .34549 .40615 L p F P
0 g
s
1 1 0 r
.007 w
.79818 .59759 m
.79869 .61035 L
s
.5 Mabswid
.771 .394 0 r
.78564 .51705 m .76792 .48505 L .77229 .4962 L p F P
0 g
s
.771 .394 0 r
.77229 .4962 m .79024 .52856 L .78564 .51705 L p F P
0 g
s
0 0 0 r
.40009 .37051 m .43703 .35587 L .44218 .35368 L p F P
0 g
s
0 0 0 r
.43703 .35587 m .40009 .37051 L .39312 .3743 L p F P
0 g
s
.034 0 0 r
.5235 .34116 m .48438 .34411 L .48157 .34492 L p F P
0 g
s
0 0 0 r
.44218 .35368 m .48157 .34492 L .48438 .34411 L p F P
0 g
s
.138 0 0 r
.5627 .34366 m .5235 .34116 L .52338 .34178 L p F P
0 g
s
.138 0 0 r
.52338 .34178 m .5653 .34445 L .5627 .34366 L p F P
0 g
s
.54 0 0 r
.69463 .39803 m .66066 .37735 L .66683 .38264 L p F P
0 g
s
.54 0 0 r
.66683 .38264 m .70225 .40418 L .69463 .39803 L p F P
0 g
s
.676 .178 0 r
.74382 .44571 m .71611 .41862 L .72229 .42687 L p F P
0 g
s
.676 .178 0 r
.72229 .42687 m .75079 .4547 L .74382 .44571 L p F P
0 g
s
.405 0 0 r
.64735 .36912 m .60993 .35489 L .61469 .35784 L p F P
0 g
s
.405 0 0 r
.61469 .35784 m .65416 .37284 L .64735 .36912 L p F P
0 g
s
0 .794 0 r
.64968 .30697 m .64772 .30615 L .65569 .29557 L closepath p F P
0 g
s
0 .595 0 r
.65239 .30805 m .64968 .30697 L .65569 .29557 L closepath p F P
0 g
s
0 .35 0 r
.65425 .30875 m .65239 .30805 L .65569 .29557 L closepath p F P
0 g
s
.034 0 0 r
.48157 .34492 m .52338 .34178 L .5235 .34116 L p F P
0 g
s
0 0 0 r
.48157 .34492 m .44218 .35368 L .43703 .35587 L p F P
0 g
s
0 .877 0 r
.64772 .30615 m .64764 .30606 L .65569 .29557 L closepath p F P
0 g
s
.304 0 0 r
.60497 .35275 m .5653 .34445 L .5678 .34607 L p F P
0 g
s
.304 0 0 r
.5678 .34607 m .60993 .35489 L .60497 .35275 L p F P
0 g
s
1 1 0 r
.007 w
.25151 .60644 m
.25264 .59366 L
s
.5 Mabswid
0 0 0 r
.25912 .53129 m .27598 .4988 L .28038 .48761 L p F P
0 g
s
0 0 0 r
.27598 .4988 m .25912 .53129 L .25527 .54319 L p F P
0 g
s
0 .686 0 r
.65418 .30866 m .65425 .30875 L .65569 .29557 L closepath p F P
0 g
s
0 .27 0 r
.64764 .30606 m .6495 .30676 L .65569 .29557 L closepath p F P
0 g
s
0 .728 0 r
.65222 .30784 m .65418 .30866 L .65569 .29557 L closepath p F P
0 g
s
0 .542 0 r
.6495 .30676 m .65222 .30784 L .65569 .29557 L closepath p F P
0 g
s
0 1 0 r
.007 w
.62937 .3612 m
.65097 .30734 L
s
.5 Mabswid
0 .748 0 r
.40907 .30362 m .40708 .30433 L .40603 .29113 L closepath p F P
0 g
s
0 .655 0 r
.41182 .30264 m .40907 .30362 L .40603 .29113 L closepath p F P
0 g
s
0 .545 0 r
.41372 .30195 m .41182 .30264 L .40603 .29113 L closepath p F P
0 g
s
0 0 0 r
.29763 .45713 m .32519 .42903 L .33145 .42072 L p F P
0 g
s
0 0 0 r
.32519 .42903 m .29763 .45713 L .29123 .46675 L p F P
0 g
s
.835 .474 0 r
.79024 .52856 m .77229 .4962 L .77595 .50784 L p F P
0 g
s
.835 .474 0 r
.77595 .50784 m .79409 .54045 L .79024 .52856 L p F P
0 g
s
0 .576 0 r
.40708 .30433 m .40701 .30435 L .40603 .29113 L closepath p F P
0 g
s
0 .176 0 r
.41365 .30196 m .41372 .30195 L .40603 .29113 L closepath p F P
0 g
s
0 0 0 r
.34549 .40615 m .38018 .38424 L .38648 .37888 L p F P
0 g
s
0 0 0 r
.38018 .38424 m .34549 .40615 L .33823 .41309 L p F P
0 g
s
.752 .268 0 r
.75079 .4547 m .72229 .42687 L .72793 .4358 L p F P
0 g
s
.752 .268 0 r
.72793 .4358 m .75715 .46427 L .75079 .4547 L p F P
0 g
s
0 0 0 r
.39312 .3743 m .43209 .35887 L .43703 .35587 L p F P
0 g
s
0 0 0 r
.43209 .35887 m .39312 .3743 L .38648 .37888 L p F P
0 g
s
0 .373 0 r
.40701 .30435 m .40891 .30366 L .40603 .29113 L closepath p F P
0 g
s
0 .585 0 r
.41166 .30267 m .41365 .30196 L .40603 .29113 L closepath p F P
0 g
s
0 .532 0 r
.40891 .30366 m .41166 .30267 L .40603 .29113 L closepath p F P
0 g
s
0 1 0 r
.007 w
.41036 .30314 m
.43008 .35777 L
s
.5 Mabswid
.632 .076 0 r
.70225 .40418 m .66683 .38264 L .67264 .38871 L p F P
0 g
s
.632 .076 0 r
.67264 .38871 m .70942 .41105 L .70225 .40418 L p F P
0 g
s
.508 0 0 r
.65416 .37284 m .61469 .35784 L .61924 .36162 L p F P
0 g
s
.508 0 0 r
.61924 .36162 m .66066 .37735 L .65416 .37284 L p F P
0 g
s
0 0 0 r
.25527 .54319 m .2723 .51045 L .27598 .4988 L p F P
0 g
s
0 0 .029 r
.2723 .51045 m .25527 .54319 L .25219 .55542 L p F P
0 g
s
.148 0 0 r
.52338 .34178 m .48157 .34492 L .47885 .34657 L p F P
0 g
s
0 0 0 r
.43703 .35587 m .47885 .34657 L .48157 .34492 L p F P
0 g
s
.255 0 0 r
.5653 .34445 m .52338 .34178 L .52328 .34324 L p F P
0 g
s
.255 0 0 r
.52328 .34324 m .5678 .34607 L .5653 .34445 L p F P
0 g
s
.085 0 0 r
.47885 .34657 m .43703 .35587 L .43209 .35887 L p F P
0 g
s
1 1 0 r
.007 w
.79564 .5848 m
.79818 .59759 L
s
.5 Mabswid
.887 .544 .052 r
.79409 .54045 m .77595 .50784 L .77887 .51991 L p F P
0 g
s
.887 .544 .052 r
.77887 .51991 m .79716 .55267 L .79409 .54045 L p F P
0 g
s
.148 0 0 r
.47885 .34657 m .52328 .34324 L .52338 .34178 L p F P
0 g
s
0 0 0 r
.29123 .46675 m .31947 .43801 L .32519 .42903 L p F P
0 g
s
0 0 0 r
.31947 .43801 m .29123 .46675 L .28547 .47692 L p F P
0 g
s
.411 0 0 r
.60993 .35489 m .5678 .34607 L .57021 .34854 L p F P
0 g
s
.411 0 0 r
.57021 .34854 m .61469 .35784 L .60993 .35489 L p F P
0 g
s
0 0 .946 r
.81056 .59039 m .80793 .59128 L .81242 .58648 L closepath p F P
0 g
s
0 0 .96 r
.81334 .59137 m .81056 .59039 L .81242 .58648 L closepath p F P
0 g
s
0 0 .529 r
.81465 .59364 m .81334 .59137 L .81242 .58648 L closepath p F P
0 g
s
0 0 0 r
.80793 .59128 m .807 .59353 L .81242 .58648 L closepath p F P
0 g
s
0 0 0 r
.33823 .41309 m .37424 .39037 L .38018 .38424 L p F P
0 g
s
0 0 0 r
.37424 .39037 m .33823 .41309 L .33145 .42072 L p F P
0 g
s
.814 .349 0 r
.75715 .46427 m .72793 .4358 L .73302 .44537 L p F P
0 g
s
0 1 0 r
.007 w
.75562 .46183 m
.75572 .46175 L
s
.5 Mabswid
.814 .349 0 r
.73302 .44537 m .76287 .47439 L .75715 .46427 L p F P
0 g
s
0 .656 0 r
.80368 .42834 m .80214 .42619 L .81435 .42125 L closepath p F P
0 g
s
0 .452 0 r
.80525 .43063 m .80368 .42834 L .81435 .42125 L closepath p F P
0 g
s
0 .656 0 r
.80368 .42834 m .80214 .42619 L .81435 .42125 L closepath p F P
0 g
s
0 .452 0 r
.80525 .43063 m .80368 .42834 L .81435 .42125 L closepath p F P
0 g
s
1 1 0 r
.007 w
.25264 .59366 m
.2558 .58088 L
s
.5 Mabswid
0 0 .593 r
.81373 .59589 m .81465 .59364 L .81242 .58648 L closepath p F P
0 g
s
0 0 .676 r
.807 .59353 m .80831 .59581 L .81242 .58648 L closepath p F P
0 g
s
0 0 .029 r
.25219 .55542 m .26936 .52254 L .2723 .51045 L p F P
0 g
s
0 0 .122 r
.26936 .52254 m .25219 .55542 L .24991 .56795 L p F P
0 g
s
0 .01 0 r
.80595 .43172 m .80525 .43063 L .81435 .42125 L closepath p F P
0 g
s
0 .01 0 r
.80595 .43172 m .80525 .43063 L .81435 .42125 L closepath p F P
0 g
s
0 .91 0 r
.80214 .42619 m .80154 .42543 L .81435 .42125 L closepath p F P
0 g
s
0 .91 0 r
.80214 .42619 m .80154 .42543 L .81435 .42125 L closepath p F P
0 g
s
.706 .169 0 r
.70942 .41105 m .67264 .38871 L .67806 .39555 L p F P
0 g
s
.706 .169 0 r
.67806 .39555 m .71611 .41862 L .70942 .41105 L p F P
0 g
s
0 0 .854 r
.8111 .59679 m .81373 .59589 L .81242 .58648 L closepath p F P
0 g
s
0 0 .837 r
.80831 .59581 m .8111 .59679 L .81242 .58648 L closepath p F P
0 g
s
0 0 1 r
.007 w
.80903 .60161 m
.81018 .59647 L
s
.5 Mabswid
0 0 0 r
.38648 .37888 m .42736 .36271 L .43209 .35887 L p F P
0 g
s
.04 0 0 r
.42736 .36271 m .38648 .37888 L .38018 .38424 L p F P
0 g
s
0 .974 0 r
.80535 .43097 m .80595 .43172 L .81435 .42125 L closepath p F P
0 g
s
0 .974 0 r
.80535 .43097 m .80595 .43172 L .81435 .42125 L closepath p F P
0 g
s
0 .065 0 r
.80154 .42543 m .80223 .42652 L .81435 .42125 L closepath p F P
0 g
s
0 .065 0 r
.80154 .42543 m .80223 .42652 L .81435 .42125 L closepath p F P
0 g
s
.593 .02 0 r
.66066 .37735 m .61924 .36162 L .62356 .36624 L p F P
0 g
s
.593 .02 0 r
.62356 .36624 m .66683 .38264 L .66066 .37735 L p F P
0 g
s
.927 .604 .143 r
.79716 .55267 m .77887 .51991 L .78104 .5324 L p F P
0 g
s
.927 .604 .143 r
.78104 .5324 m .79944 .56519 L .79716 .55267 L p F P
0 g
s
0 .687 0 r
.80381 .42881 m .80535 .43097 L .81435 .42125 L closepath p F P
0 g
s
0 .482 0 r
.80223 .42652 m .80381 .42881 L .81435 .42125 L closepath p F P
0 g
s
0 1 0 r
.007 w
.75572 .46175 m
.80368 .42862 L
s
.5 Mabswid
0 .687 0 r
.80381 .42881 m .80535 .43097 L .81435 .42125 L closepath p F P
0 g
s
0 .482 0 r
.80223 .42652 m .80381 .42881 L .81435 .42125 L closepath p F P
0 g
s
0 0 0 r
.28547 .47692 m .31433 .44763 L .31947 .43801 L p F P
0 g
s
0 0 .002 r
.31433 .44763 m .28547 .47692 L .28038 .48761 L p F P
0 g
s
.249 0 0 r
.52328 .34324 m .47885 .34657 L .47624 .34907 L p F P
0 g
s
.085 0 0 r
.43209 .35887 m .47624 .34907 L .47885 .34657 L p F P
0 g
s
.356 0 0 r
.5678 .34607 m .52328 .34324 L .52317 .34555 L p F P
0 g
s
.356 0 0 r
.52317 .34555 m .57021 .34854 L .5678 .34607 L p F P
0 g
s
0 .654 0 r
.53311 .28384 m .53017 .28379 L .53199 .2712 L closepath p F P
0 g
s
0 .467 0 r
.53526 .28403 m .53311 .28384 L .53199 .2712 L closepath p F P
0 g
s
0 .82 0 r
.53017 .28379 m .52814 .2839 L .53199 .2712 L closepath p F P
0 g
s
.177 0 0 r
.47624 .34907 m .43209 .35887 L .42736 .36271 L p F P
0 g
s
.861 .419 .021 r
.76287 .47439 m .73302 .44537 L .73751 .45558 L p F P
0 g
s
.861 .419 .021 r
.73751 .45558 m .76792 .48505 L .76287 .47439 L p F P
0 g
s
0 0 .122 r
.24991 .56795 m .26718 .53503 L .26936 .52254 L p F P
0 g
s
0 0 .207 r
.26718 .53503 m .24991 .56795 L .24843 .58073 L p F P
0 g
s
.5 0 0 r
.61469 .35784 m .57021 .34854 L .57251 .35187 L p F P
0 g
s
.5 0 0 r
.57251 .35187 m .61924 .36162 L .61469 .35784 L p F P
0 g
s
0 0 0 r
.53534 .28423 m .53526 .28403 L .53199 .2712 L closepath p F P
0 g
s
0 0 0 r
.52814 .2839 m .52822 .28411 L .53199 .2712 L closepath p F P
0 g
s
.249 0 0 r
.47624 .34907 m .52317 .34555 L .52328 .34324 L p F P
0 g
s
0 0 0 r
.33145 .42072 m .3687 .39726 L .37424 .39037 L p F P
0 g
s
0 0 0 r
.3687 .39726 m .33145 .42072 L .32519 .42903 L p F P
0 g
s
0 .654 0 r
.25315 .41988 m .25173 .42192 L .24336 .41173 L closepath p F P
0 g
s
0 .69 0 r
.25491 .41759 m .25315 .41988 L .24336 .41173 L closepath p F P
0 g
s
0 .715 0 r
.256 .41638 m .25491 .41759 L .24336 .41173 L closepath p F P
0 g
s
0 .688 0 r
.53331 .28435 m .53534 .28423 L .53199 .2712 L closepath p F P
0 g
s
0 .352 0 r
.52822 .28411 m .53036 .28429 L .53199 .2712 L closepath p F P
0 g
s
.763 .25 0 r
.71611 .41862 m .67806 .39555 L .68308 .40316 L p F P
0 g
s
.763 .25 0 r
.68308 .40316 m .72229 .42687 L .71611 .41862 L p F P
0 g
s
0 .561 0 r
.53036 .28429 m .53331 .28435 L .53199 .2712 L closepath p F P
0 g
s
0 1 0 r
.007 w
.53059 .34244 m
.53173 .28432 L
s
.5 Mabswid
.956 .655 .225 r
.79944 .56519 m .78104 .5324 L .78244 .54526 L p F P
0 g
s
.956 .655 .225 r
.78244 .54526 m .80091 .57797 L .79944 .56519 L p F P
0 g
s
1 1 0 r
.007 w
.79106 .57207 m
.79564 .5848 L
s
.5 Mabswid
0 .404 0 r
.25173 .42192 m .2515 .42251 L .24336 .41173 L closepath p F P
0 g
s
0 .078 0 r
.25577 .41697 m .256 .41638 L .24336 .41173 L closepath p F P
0 g
s
.04 0 0 r
.38018 .38424 m .42288 .36737 L .42736 .36271 L p F P
0 g
s
.12 0 0 r
.42288 .36737 m .38018 .38424 L .37424 .39037 L p F P
0 g
s
0 0 .002 r
.28038 .48761 m .30977 .45787 L .31433 .44763 L p F P
0 g
s
0 0 .093 r
.30977 .45787 m .28038 .48761 L .27598 .4988 L p F P
0 g
s
0 .497 0 r
.2515 .42251 m .25258 .42131 L .24336 .41173 L closepath p F P
0 g
s
.659 .111 0 r
.66683 .38264 m .62356 .36624 L .62763 .37169 L p F P
0 g
s
.659 .111 0 r
.62763 .37169 m .67264 .38871 L .66683 .38264 L p F P
0 g
s
0 .499 0 r
.25435 .41901 m .25577 .41697 L .24336 .41173 L closepath p F P
0 g
s
0 .553 0 r
.25258 .42131 m .25435 .41901 L .24336 .41173 L closepath p F P
0 g
s
0 1 0 r
.007 w
.25392 .41957 m
.30082 .45442 L
s
.5 Mabswid
0 0 .207 r
.24843 .58073 m .26577 .54789 L .26718 .53503 L p F P
0 g
s
1 1 0 r
.007 w
.2558 .58088 m
.26102 .5682 L
s
.5 Mabswid
.897 .479 .11 r
.76792 .48505 m .73751 .45558 L .7414 .46639 L p F P
0 g
s
.897 .479 .11 r
.7414 .46639 m .77229 .4962 L .76792 .48505 L p F P
0 g
s
.333 0 0 r
.52317 .34555 m .47624 .34907 L .47375 .35243 L p F P
0 g
s
.177 0 0 r
.42736 .36271 m .47375 .35243 L .47624 .34907 L p F P
0 g
s
.438 0 0 r
.57021 .34854 m .52317 .34555 L .52307 .34873 L p F P
0 g
s
.438 0 0 r
.52307 .34873 m .57251 .35187 L .57021 .34854 L p F P
0 g
s
0 0 0 r
.32519 .42903 m .36358 .40492 L .3687 .39726 L p F P
0 g
s
.056 0 .015 r
.36358 .40492 m .32519 .42903 L .31947 .43801 L p F P
0 g
s
.255 0 0 r
.47375 .35243 m .42736 .36271 L .42288 .36737 L p F P
0 g
s
.569 .016 0 r
.61924 .36162 m .57251 .35187 L .5747 .35606 L p F P
0 g
s
.569 .016 0 r
.5747 .35606 m .62356 .36624 L .61924 .36162 L p F P
0 g
s
.806 .32 .029 r
.72229 .42687 m .68308 .40316 L .68766 .41151 L p F P
0 g
s
.806 .32 .029 r
.68766 .41151 m .72793 .4358 L .72229 .42687 L p F P
0 g
s
.333 0 0 r
.47375 .35243 m .52307 .34873 L .52317 .34555 L p F P
0 g
s
0 0 .093 r
.27598 .4988 m .30584 .46871 L .30977 .45787 L p F P
0 g
s
0 0 .175 r
.30584 .46871 m .27598 .4988 L .2723 .51045 L p F P
0 g
s
.452 0 0 r
.7823 .4973 m .78022 .49865 L .77785 .48617 L closepath p F P
0 g
s
0 0 0 r
.78225 .49556 m .7823 .4973 L .77785 .48617 L closepath p F P
0 g
s
.452 0 0 r
.7823 .4973 m .78022 .49865 L .77785 .48617 L closepath p F P
0 g
s
0 0 0 r
.78225 .49556 m .7823 .4973 L .77785 .48617 L closepath p F P
0 g
s
.854 0 0 r
.7801 .49446 m .78225 .49556 L .77785 .48617 L closepath p F P
0 g
s
.865 0 0 r
.77724 .49883 m .77509 .49774 L .77785 .48617 L closepath p F P
0 g
s
.678 0 0 r
.78022 .49865 m .77724 .49883 L .77785 .48617 L closepath p F P
0 g
s
.865 0 0 r
.77724 .49883 m .77509 .49774 L .77785 .48617 L closepath p F P
0 g
s
.678 0 0 r
.78022 .49865 m .77724 .49883 L .77785 .48617 L closepath p F P
0 g
s
.624 0 0 r
.7771 .49464 m .7801 .49446 L .77785 .48617 L closepath p F P
0 g
s
.924 0 0 r
.77509 .49774 m .77503 .496 L .77785 .48617 L closepath p F P
0 g
s
.924 0 0 r
.77509 .49774 m .77503 .496 L .77785 .48617 L closepath p F P
0 g
s
.243 0 0 r
.77503 .496 m .7771 .49464 L .77785 .48617 L closepath p F P
0 g
s
.854 0 0 r
.7801 .49446 m .78225 .49556 L .77785 .48617 L closepath p F P
0 g
s
.624 0 0 r
.7771 .49464 m .7801 .49446 L .77785 .48617 L closepath p F P
0 g
s
.243 0 0 r
.77503 .496 m .7771 .49464 L .77785 .48617 L closepath p F P
0 g
s
.12 0 0 r
.37424 .39037 m .41865 .37286 L .42288 .36737 L p F P
0 g
s
.188 0 0 r
.41865 .37286 m .37424 .39037 L .3687 .39726 L p F P
0 g
s
.922 .53 .19 r
.77229 .4962 m .7414 .46639 L .74465 .47778 L p F P
0 g
s
.922 .53 .19 r
.74465 .47778 m .77595 .50784 L .77229 .4962 L p F P
0 g
s
.709 .19 0 r
.67264 .38871 m .62763 .37169 L .63144 .37796 L p F P
0 g
s
.709 .19 0 r
.63144 .37796 m .67806 .39555 L .67264 .38871 L p F P
0 g
s
0 0 .889 r
.24558 .56317 m .24814 .56304 L .24213 .57248 L closepath p F P
0 g
s
0 0 .534 r
.24436 .56512 m .24558 .56317 L .24213 .57248 L closepath p F P
0 g
s
0 0 .82 r
.24814 .56304 m .25055 .5648 L .24213 .57248 L closepath p F P
0 g
s
0 0 .591 r
.2452 .56774 m .24436 .56512 L .24213 .57248 L closepath p F P
0 g
s
0 0 .118 r
.25139 .56742 m .25017 .56936 L .24213 .57248 L closepath p F P
0 g
s
0 0 .646 r
.25055 .5648 m .25139 .56742 L .24213 .57248 L closepath p F P
0 g
s
0 0 .922 r
.24761 .5695 m .2452 .56774 L .24213 .57248 L closepath p F P
0 g
s
0 0 .95 r
.25017 .56936 m .24761 .5695 L .24213 .57248 L closepath p F P
0 g
s
0 0 1 r
.007 w
.24598 .56831 m
.25407 .55957 L
s
.25407 .55957 m
.26482 .54795 L
s
1 1 0 r
.78441 .55952 m
.79106 .57207 L
s
.5 Mabswid
.056 0 .015 r
.31947 .43801 m .35889 .41332 L .36358 .40492 L p F P
0 g
s
.116 0 .103 r
.35889 .41332 m .31947 .43801 L .31433 .44763 L p F P
0 g
s
.401 0 0 r
.52307 .34873 m .47375 .35243 L .47138 .35664 L p F P
0 g
s
.255 0 0 r
.42288 .36737 m .47138 .35664 L .47375 .35243 L p F P
0 g
s
.503 0 0 r
.57251 .35187 m .52307 .34873 L .52298 .35278 L p F P
0 g
s
.503 0 0 r
.52298 .35278 m .5747 .35606 L .57251 .35187 L p F P
0 g
s
0 0 .175 r
.2723 .51045 m .30254 .48012 L .30584 .46871 L p F P
0 g
s
.032 0 .248 r
.30254 .48012 m .2723 .51045 L .26936 .52254 L p F P
0 g
s
.838 .379 .115 r
.72793 .4358 m .68766 .41151 L .69179 .4206 L p F P
0 g
s
.838 .379 .115 r
.69179 .4206 m .73302 .44537 L .72793 .4358 L p F P
0 g
s
1 1 0 r
.007 w
.26102 .5682 m
.26829 .55572 L
s
.5 Mabswid
.319 0 0 r
.47138 .35664 m .42288 .36737 L .41865 .37286 L p F P
0 g
s
.677 0 0 r
.28044 .49068 m .27749 .49087 L .27908 .47816 L closepath p F P
0 g
s
.379 0 0 r
.28213 .48932 m .28044 .49068 L .27908 .47816 L closepath p F P
0 g
s
.851 0 0 r
.27909 .48645 m .28157 .48756 L .27908 .47816 L closepath p F P
0 g
s
.847 0 0 r
.27749 .49087 m .27501 .48976 L .27908 .47816 L closepath p F P
0 g
s
.619 0 0 r
.27613 .48663 m .27909 .48645 L .27908 .47816 L closepath p F P
0 g
s
.993 0 0 r
.27501 .48976 m .27444 .48801 L .27908 .47816 L closepath p F P
0 g
s
.028 0 0 r
.27444 .48801 m .27613 .48663 L .27908 .47816 L closepath p F P
0 g
s
.726 0 0 r
.28157 .48756 m .28213 .48932 L .27908 .47816 L closepath p F P
0 g
s
.622 .099 0 r
.62356 .36624 m .5747 .35606 L .57676 .36111 L p F P
0 g
s
.622 .099 0 r
.57676 .36111 m .62763 .37169 L .62356 .36624 L p F P
0 g
s
.94 .572 .26 r
.77595 .50784 m .74465 .47778 L .74726 .48971 L p F P
0 g
s
.94 .572 .26 r
.74726 .48971 m .77887 .51991 L .77595 .50784 L p F P
0 g
s
1 0 0 r
.007 w
.7785 .49456 m
.7802 .51641 L
s
.5 Mabswid
.401 0 0 r
.47138 .35664 m .52298 .35278 L .52307 .34873 L p F P
0 g
s
.188 0 0 r
.3687 .39726 m .4147 .37917 L .41865 .37286 L p F P
0 g
s
.246 0 .064 r
.4147 .37917 m .3687 .39726 L .36358 .40492 L p F P
0 g
s
.747 .257 .072 r
.67806 .39555 m .63144 .37796 L .63496 .38506 L p F P
0 g
s
.747 .257 .072 r
.63496 .38506 m .68308 .40316 L .67806 .39555 L p F P
0 g
s
.116 0 .103 r
.31433 .44763 m .35467 .42245 L .35889 .41332 L p F P
0 g
s
.168 0 .179 r
.35467 .42245 m .31433 .44763 L .30977 .45787 L p F P
0 g
s
.032 0 .248 r
.26936 .52254 m .29991 .49206 L .30254 .48012 L p F P
0 g
s
.082 0 .312 r
.29991 .49206 m .26936 .52254 L .26718 .53503 L p F P
0 g
s
.86 .429 .19 r
.73302 .44537 m .69179 .4206 L .69545 .43041 L p F P
0 g
s
.86 .429 .19 r
.69545 .43041 m .73751 .45558 L .73302 .44537 L p F P
0 g
s
1 1 0 r
.007 w
.77571 .54725 m
.78441 .55952 L
s
.5 Mabswid
.951 .608 .322 r
.77887 .51991 m .74726 .48971 L .74919 .50216 L p F P
0 g
s
.951 .608 .322 r
.74919 .50216 m .78104 .5324 L .77887 .51991 L p F P
0 g
s
1 0 0 r
.007 w
.7802 .51641 m
.78123 .52967 L
s
.5 Mabswid
.456 0 .018 r
.52298 .35278 m .47138 .35664 L .46914 .36172 L p F P
0 g
s
.319 0 0 r
.41865 .37286 m .46914 .36172 L .47138 .35664 L p F P
0 g
s
.372 0 .063 r
.46914 .36172 m .41865 .37286 L .4147 .37917 L p F P
0 g
s
.553 .052 .02 r
.5747 .35606 m .52298 .35278 L .52289 .35771 L p F P
0 g
s
.553 .052 .02 r
.52289 .35771 m .57676 .36111 L .5747 .35606 L p F P
0 g
s
.662 .169 .068 r
.62763 .37169 m .57676 .36111 L .57869 .36703 L p F P
0 g
s
.662 .169 .068 r
.57869 .36703 m .63144 .37796 L .62763 .37169 L p F P
0 g
s
.246 0 .064 r
.36358 .40492 m .41105 .38631 L .4147 .37917 L p F P
0 g
s
.294 0 .144 r
.41105 .38631 m .36358 .40492 L .35889 .41332 L p F P
0 g
s
.456 0 .018 r
.46914 .36172 m .52289 .35771 L .52298 .35278 L p F P
0 g
s
.774 .313 .151 r
.68308 .40316 m .63496 .38506 L .63818 .39297 L p F P
0 g
s
.774 .313 .151 r
.63818 .39297 m .68766 .41151 L .68308 .40316 L p F P
0 g
s
.082 0 .312 r
.26718 .53503 m .29795 .50451 L .29991 .49206 L p F P
0 g
s
.127 0 .369 r
.29795 .50451 m .26718 .53503 L .26577 .54789 L p F P
0 g
s
1 0 0 r
.007 w
.27641 .51346 m
.27845 .48649 L
s
.5 Mabswid
.168 0 .179 r
.30977 .45787 m .35094 .43228 L .35467 .42245 L p F P
0 g
s
.213 0 .247 r
.35094 .43228 m .30977 .45787 L .30584 .46871 L p F P
0 g
s
.876 .471 .255 r
.73751 .45558 m .69545 .43041 L .69861 .44091 L p F P
0 g
s
.876 .471 .255 r
.69861 .44091 m .7414 .46639 L .73751 .45558 L p F P
0 g
s
.957 .638 .377 r
.78104 .5324 m .74919 .50216 L .75044 .51508 L p F P
0 g
s
.957 .638 .377 r
.75044 .51508 m .78244 .54526 L .78104 .5324 L p F P
0 g
s
1 0 0 r
.007 w
.78177 .53659 m
.78244 .54526 L
s
.78123 .52967 m
.78177 .53659 L
s
.5 Mabswid
.372 0 .063 r
.4147 .37917 m .46705 .36766 L .46914 .36172 L p F P
0 g
s
.414 .001 .143 r
.46705 .36766 m .4147 .37917 L .41105 .38631 L p F P
0 g
s
.498 .044 .104 r
.52289 .35771 m .46914 .36172 L .46705 .36766 L p F P
0 g
s
.127 0 .369 r
.26577 .54789 m .29668 .51743 L .29795 .50451 L p F P
0 g
s
0 0 1 r
.007 w
.26482 .54795 m
.26696 .54564 L
s
.26696 .54564 m
.27459 .53738 L
s
1 1 0 r
.26829 .55572 m
.27762 .54355 L
s
1 0 0 r
.27459 .53738 m
.27508 .53097 L
s
.27508 .53097 m
.27641 .51346 L
s
.5 Mabswid
.591 .121 .106 r
.57676 .36111 m .52289 .35771 L .5228 .36351 L p F P
0 g
s
.591 .121 .106 r
.5228 .36351 m .57869 .36703 L .57676 .36111 L p F P
0 g
s
.692 .229 .147 r
.63144 .37796 m .57869 .36703 L .58047 .37381 L p F P
0 g
s
.692 .229 .147 r
.58047 .37381 m .63496 .38506 L .63144 .37796 L p F P
0 g
s
.294 0 .144 r
.35889 .41332 m .4077 .39425 L .41105 .38631 L p F P
0 g
s
.335 0 .213 r
.4077 .39425 m .35889 .41332 L .35467 .42245 L p F P
0 g
s
1 1 0 r
.007 w
.76499 .53535 m
.77571 .54725 L
s
.5 Mabswid
.213 0 .247 r
.30584 .46871 m .34771 .44281 L .35094 .43228 L p F P
0 g
s
.252 0 .305 r
.34771 .44281 m .30584 .46871 L .30254 .48012 L p F P
0 g
s
.794 .361 .219 r
.68766 .41151 m .63818 .39297 L .64108 .40168 L p F P
0 g
s
.794 .361 .219 r
.64108 .40168 m .69179 .4206 L .68766 .41151 L p F P
0 g
s
0 0 1 r
.007 w
.76295 .52084 m
.77927 .54129 L
s
.77927 .54129 m
.78244 .54526 L
s
.5 Mabswid
.498 .044 .104 r
.46705 .36766 m .5228 .36351 L .52289 .35771 L p F P
0 g
s
.887 .507 .312 r
.7414 .46639 m .69861 .44091 L .70126 .45208 L p F P
0 g
s
.887 .507 .312 r
.70126 .45208 m .74465 .47778 L .7414 .46639 L p F P
0 g
s
1 1 0 r
.007 w
.27762 .54355 m
.28896 .5318 L
s
.5 Mabswid
.414 .001 .143 r
.41105 .38631 m .46512 .37446 L .46705 .36766 L p F P
0 g
s
.449 .061 .211 r
.46512 .37446 m .41105 .38631 L .4077 .39425 L p F P
0 g
s
.252 0 .305 r
.30254 .48012 m .345 .45399 L .34771 .44281 L p F P
0 g
s
.286 .041 .357 r
.345 .45399 m .30254 .48012 L .29991 .49206 L p F P
0 g
s
.335 0 .213 r
.35467 .42245 m .40469 .40299 L .4077 .39425 L p F P
0 g
s
.369 .041 .272 r
.40469 .40299 m .35467 .42245 L .35094 .43228 L p F P
0 g
s
.532 .106 .177 r
.5228 .36351 m .46705 .36766 L .46512 .37446 L p F P
0 g
s
.715 .279 .214 r
.63496 .38506 m .58047 .37381 L .58211 .38144 L p F P
0 g
s
.715 .279 .214 r
.58211 .38144 m .63818 .39297 L .63496 .38506 L p F P
0 g
s
.621 .179 .178 r
.57869 .36703 m .5228 .36351 L .52272 .37019 L p F P
0 g
s
.621 .179 .178 r
.52272 .37019 m .58047 .37381 L .57869 .36703 L p F P
0 g
s
0 1 0 r
.007 w
.27364 .53707 m
.27459 .53738 L
s
.5 Mabswid
.808 .401 .278 r
.69179 .4206 m .64108 .40168 L .64365 .41118 L p F P
0 g
s
.808 .401 .278 r
.64365 .41118 m .69545 .43041 L .69179 .4206 L p F P
0 g
s
.893 .537 .362 r
.74465 .47778 m .70126 .45208 L .70338 .46388 L p F P
0 g
s
.893 .537 .362 r
.70338 .46388 m .74726 .48971 L .74465 .47778 L p F P
0 g
s
1 1 0 r
.007 w
.75228 .52395 m
.76499 .53535 L
s
.5 Mabswid
.532 .106 .177 r
.46512 .37446 m .52272 .37019 L .5228 .36351 L p F P
0 g
s
1 1 0 r
.007 w
.28896 .5318 m
.30226 .52056 L
s
.5 Mabswid
.286 .041 .357 r
.29991 .49206 m .34284 .4658 L .345 .45399 L p F P
0 g
s
.316 .089 .402 r
.34284 .4658 m .29991 .49206 L .29795 .50451 L p F P
0 g
s
0 .661 0 r
.85062 .52518 m .83874 .52707 L .83833 .52641 L p F P
0 g
s
0 .596 0 r
.83833 .52641 m .83791 .52557 L .85062 .52518 L p F P
0 g
s
0 .736 0 r
.85062 .52518 m .83791 .52557 L .83775 .52549 L p F P
0 g
s
0 .661 0 r
.83775 .52549 m .83755 .52518 L .85062 .52518 L p F P
0 g
s
0 0 0 r
.85062 .52518 m .83755 .52518 L .83727 .52526 L p F P
0 g
s
0 .736 0 r
.83775 .52549 m .83727 .52526 L p .85062 .52518 L F P
0 g
s
0 0 0 r
.83727 .52526 m .83689 .52538 L p .85062 .52518 L F P
0 g
s
0 .736 0 r
.83727 .52526 m .83692 .5251 L .85062 .52518 L p F P
0 g
s
0 .206 0 r
.85062 .52518 m .83692 .5251 L .83689 .52538 L p F P
0 g
s
0 .661 0 r
.83833 .52641 m .83775 .52549 L p .85062 .52518 L F P
0 g
s
0 .596 0 r
.85062 .52518 m .83908 .52795 L .83889 .52756 L p F P
0 g
s
0 .463 0 r
.83889 .52756 m .83874 .52707 L .85062 .52518 L p F P
0 g
s
0 .596 0 r
.83889 .52756 m .83833 .52641 L p .85062 .52518 L F P
0 g
s
0 .463 0 r
.85062 .52518 m .83963 .53 L .83932 .52897 L p F P
0 g
s
0 .396 0 r
.85062 .52518 m .83975 .53085 L .83932 .52897 L p F P
0 g
s
0 .396 0 r
.83932 .52897 m .83908 .52795 L .85062 .52518 L p F P
0 g
s
0 .463 0 r
.83932 .52897 m .83889 .52756 L p .85062 .52518 L F P
0 g
s
0 .206 0 r
.83689 .52538 m .83678 .52621 L p .85062 .52518 L F P
0 g
s
0 .33 0 r
.85062 .52518 m .83675 .52542 L .83678 .52621 L p F P
0 g
s
0 .33 0 r
.83678 .52621 m .83681 .52729 L p .85062 .52518 L F P
0 g
s
0 .492 0 r
.85062 .52518 m .83669 .52681 L .83681 .52729 L p F P
0 g
s
0 .492 0 r
.83681 .52729 m .83713 .5287 L p .85062 .52518 L F P
0 g
s
0 .549 0 r
.85062 .52518 m .83682 .52767 L .83713 .5287 L p F P
0 g
s
0 .549 0 r
.83713 .5287 m .83756 .53011 L p .85062 .52518 L F P
0 g
s
0 .678 0 r
.85062 .52518 m .83736 .52972 L .83756 .53011 L p F P
0 g
s
0 .17 0 r
.85062 .52518 m .83969 .53224 L .83967 .53145 L p F P
0 g
s
0 0 0 r
.83967 .53145 m .83975 .53085 L .85062 .52518 L p F P
0 g
s
0 .17 0 r
.83967 .53145 m .83963 .53 L .85062 .52518 L p F P
0 g
s
0 0 0 r
.83956 .53228 m .83967 .53145 L p .85062 .52518 L F P
0 g
s
0 .678 0 r
.83756 .53011 m .83812 .53126 L p .85062 .52518 L F P
0 g
s
0 .75 0 r
.83812 .53126 m .8387 .53218 L p .85062 .52518 L F P
0 g
s
0 .678 0 r
.83812 .53126 m .83853 .5321 L .85062 .52518 L p F P
0 g
s
0 .75 0 r
.85062 .52518 m .8377 .5306 L .83812 .53126 L p F P
0 g
s
0 .957 0 r
.8387 .53218 m .83918 .5324 L p .85062 .52518 L F P
0 g
s
0 .75 0 r
.8387 .53218 m .8389 .53249 L .85062 .52518 L p F P
0 g
s
0 .957 0 r
.85062 .52518 m .83853 .5321 L .8387 .53218 L p F P
0 g
s
0 .895 0 r
.83918 .5324 m .83956 .53228 L p .85062 .52518 L F P
0 g
s
0 .895 0 r
.83956 .53228 m .83969 .53224 L .85062 .52518 L p F P
0 g
s
0 0 0 r
.85062 .52518 m .83952 .53257 L .83956 .53228 L p F P
0 g
s
0 .957 0 r
.83918 .5324 m .83952 .53257 L .85062 .52518 L p F P
0 g
s
0 .895 0 r
.85062 .52518 m .8389 .53249 L .83918 .5324 L p F P
0 g
s
0 .549 0 r
.83756 .53011 m .8377 .5306 L .85062 .52518 L p F P
0 g
s
0 .492 0 r
.83713 .5287 m .83736 .52972 L .85062 .52518 L p F P
0 g
s
0 .33 0 r
.83681 .52729 m .83682 .52767 L .85062 .52518 L p F P
0 g
s
0 .206 0 r
.83678 .52621 m .83669 .52681 L .85062 .52518 L p F P
0 g
s
0 0 0 r
.83689 .52538 m .83675 .52542 L .85062 .52518 L p F P
0 g
s
0 1 0 r
.007 w
.78244 .54526 m
.83723 .52913 L
s
.5 Mabswid
.369 .041 .272 r
.35094 .43228 m .40202 .4125 L .40469 .40299 L p F P
0 g
s
.398 .091 .324 r
.40202 .4125 m .35094 .43228 L .34771 .44281 L p F P
0 g
s
.449 .061 .211 r
.4077 .39425 m .46335 .3821 L .46512 .37446 L p F P
0 g
s
.477 .113 .269 r
.46335 .3821 m .4077 .39425 L .40469 .40299 L p F P
0 g
s
.897 .563 .407 r
.74726 .48971 m .70338 .46388 L .70495 .47629 L p F P
0 g
s
.897 .563 .407 r
.70495 .47629 m .74919 .50216 L .74726 .48971 L p F P
0 g
s
.732 .322 .272 r
.63818 .39297 m .58211 .38144 L .58358 .38991 L p F P
0 g
s
.732 .322 .272 r
.58358 .38991 m .64108 .40168 L .63818 .39297 L p F P
0 g
s
.818 .435 .329 r
.69545 .43041 m .64365 .41118 L .64588 .42143 L p F P
0 g
s
.818 .435 .329 r
.64588 .42143 m .69861 .44091 L .69545 .43041 L p F P
0 g
s
.558 .158 .239 r
.52272 .37019 m .46512 .37446 L .46335 .3821 L p F P
0 g
s
.644 .228 .241 r
.58047 .37381 m .52272 .37019 L .52265 .37773 L p F P
0 g
s
.644 .228 .241 r
.52265 .37773 m .58211 .38144 L .58047 .37381 L p F P
0 g
s
0 .689 0 r
.69888 .35203 m .69626 .35074 L .7048 .34234 L closepath p F P
0 g
s
0 .438 0 r
.70095 .35389 m .69888 .35203 L .7048 .34234 L closepath p F P
0 g
s
0 .966 0 r
.69626 .35074 m .69462 .35076 L .7048 .34234 L closepath p F P
0 g
s
.558 .158 .239 r
.46335 .3821 m .52265 .37773 L .52272 .37019 L p F P
0 g
s
.316 .089 .402 r
.29795 .50451 m .34123 .47821 L .34284 .4658 L p F P
0 g
s
.342 .131 .442 r
.34123 .47821 m .29795 .50451 L .29668 .51743 L p F P
0 g
s
0 0 0 r
.70125 .35523 m .70095 .35389 L .7048 .34234 L closepath p F P
0 g
s
0 0 0 r
.69462 .35076 m .69491 .35209 L .7048 .34234 L closepath p F P
0 g
s
0 .886 0 r
.6996 .35526 m .70125 .35523 L .7048 .34234 L closepath p F P
0 g
s
.899 .586 .446 r
.74919 .50216 m .70495 .47629 L .70597 .48926 L p F P
0 g
s
.899 .586 .446 r
.70597 .48926 m .75044 .51508 L .74919 .50216 L p F P
0 g
s
1 1 0 r
.007 w
.73766 .51314 m
.75228 .52395 L
s
.5 Mabswid
.398 .091 .324 r
.34771 .44281 m .39971 .42278 L .40202 .4125 L p F P
0 g
s
.422 .135 .37 r
.39971 .42278 m .34771 .44281 L .345 .45399 L p F P
0 g
s
0 .696 0 r
.21895 .51822 m .21823 .52111 L .20782 .51508 L closepath p F P
0 g
s
0 .806 0 r
.22027 .51587 m .21895 .51822 L .20782 .51508 L closepath p F P
0 g
s
0 .457 0 r
.21823 .52111 m .21852 .52285 L .20782 .51508 L closepath p F P
0 g
s
0 .446 0 r
.69491 .35209 m .69698 .35396 L .7048 .34234 L closepath p F P
0 g
s
0 .785 0 r
.22142 .51543 m .22027 .51587 L .20782 .51508 L closepath p F P
0 g
s
.477 .113 .269 r
.40469 .40299 m .46175 .39059 L .46335 .3821 L p F P
0 g
s
.501 .159 .319 r
.46175 .39059 m .40469 .40299 L .40202 .4125 L p F P
0 g
s
0 .657 0 r
.69698 .35396 m .6996 .35526 L .7048 .34234 L closepath p F P
0 g
s
0 1 0 r
.007 w
.66705 .4009 m
.69723 .35408 L
s
.5 Mabswid
.825 .465 .373 r
.69861 .44091 m .64588 .42143 L .64774 .43242 L p F P
0 g
s
.825 .465 .373 r
.64774 .43242 m .70126 .45208 L .69861 .44091 L p F P
0 g
s
0 .81 0 r
.36563 .34672 m .36395 .3485 L .36109 .33637 L closepath p F P
0 g
s
0 .756 0 r
.36833 .34528 m .36563 .34672 L .36109 .33637 L closepath p F P
0 g
s
0 .641 0 r
.37048 .345 m .36833 .34528 L .36109 .33637 L closepath p F P
0 g
s
0 .591 0 r
.21852 .52285 m .21967 .52242 L .20782 .51508 L closepath p F P
0 g
s
.744 .359 .322 r
.64108 .40168 m .58358 .38991 L .58488 .3992 L p F P
0 g
s
.744 .359 .322 r
.58488 .3992 m .64365 .41118 L .64108 .40168 L p F P
0 g
s
0 .332 0 r
.22172 .51716 m .22142 .51543 L .20782 .51508 L closepath p F P
0 g
s
.58 .203 .293 r
.52265 .37773 m .46335 .3821 L .46175 .39059 L p F P
0 g
s
0 0 0 r
.36395 .3485 m .36428 .34956 L .36109 .33637 L closepath p F P
0 g
s
0 .298 0 r
.37081 .34606 m .37048 .345 L .36109 .33637 L closepath p F P
0 g
s
.661 .27 .294 r
.58211 .38144 m .52265 .37773 L .52259 .38612 L p F P
0 g
s
.661 .27 .294 r
.52259 .38612 m .58358 .38991 L .58211 .38144 L p F P
0 g
s
0 .657 0 r
.21967 .52242 m .22099 .52006 L .20782 .51508 L closepath p F P
0 g
s
.342 .131 .442 r
.29668 .51743 m .34019 .49118 L .34123 .47821 L p F P
0 g
s
1 1 0 r
.007 w
.30226 .52056 m
.31745 .50996 L
s
.5 Mabswid
0 .575 0 r
.22099 .52006 m .22172 .51716 L .20782 .51508 L closepath p F P
0 g
s
0 1 0 r
.007 w
.22113 .51953 m
.27364 .53707 L
s
.5 Mabswid
0 0 .582 r
.75526 .51315 m .75435 .51579 L .75256 .50781 L closepath p F P
0 g
s
0 0 .926 r
.7578 .5114 m .75526 .51315 L .75256 .50781 L closepath p F P
0 g
s
0 0 .582 r
.75526 .51315 m .75435 .51579 L .75256 .50781 L closepath p F P
0 g
s
0 0 .926 r
.7578 .5114 m .75526 .51315 L .75256 .50781 L closepath p F P
0 g
s
0 .487 0 r
.36428 .34956 m .36643 .34929 L .36109 .33637 L closepath p F P
0 g
s
0 0 .963 r
.76048 .51157 m .7578 .5114 L .75256 .50781 L closepath p F P
0 g
s
0 0 .963 r
.76048 .51157 m .7578 .5114 L .75256 .50781 L closepath p F P
0 g
s
0 .636 0 r
.36914 .34784 m .37081 .34606 L .36109 .33637 L closepath p F P
0 g
s
0 0 .554 r
.75435 .51579 m .75559 .51778 L .75256 .50781 L closepath p F P
0 g
s
0 0 .554 r
.75435 .51579 m .75559 .51778 L .75256 .50781 L closepath p F P
0 g
s
0 0 .055 r
.76172 .51356 m .76048 .51157 L .75256 .50781 L closepath p F P
0 g
s
0 0 .055 r
.76172 .51356 m .76048 .51157 L .75256 .50781 L closepath p F P
0 g
s
0 .617 0 r
.36643 .34929 m .36914 .34784 L .36109 .33637 L closepath p F P
0 g
s
0 1 0 r
.007 w
.36804 .34843 m
.39564 .39633 L
s
.5 Mabswid
.58 .203 .293 r
.46175 .39059 m .52259 .38612 L .52265 .37773 L p F P
0 g
s
0 0 .885 r
.75559 .51778 m .75827 .51796 L .75256 .50781 L closepath p F P
0 g
s
0 0 .885 r
.75559 .51778 m .75827 .51796 L .75256 .50781 L closepath p F P
0 g
s
.422 .135 .37 r
.345 .45399 m .39778 .43378 L .39971 .42278 L p F P
0 g
s
.443 .174 .409 r
.39778 .43378 m .345 .45399 L .34284 .4658 L p F P
0 g
s
0 0 .644 r
.76081 .51621 m .76172 .51356 L .75256 .50781 L closepath p F P
0 g
s
0 0 .644 r
.76081 .51621 m .76172 .51356 L .75256 .50781 L closepath p F P
0 g
s
1 1 0 r
.007 w
.72121 .50303 m
.73766 .51314 L
s
.5 Mabswid
0 0 .823 r
.75827 .51796 m .76081 .51621 L .75256 .50781 L closepath p F P
0 g
s
0 0 1 r
.007 w
.75981 .5169 m
.76295 .52084 L
s
.5 Mabswid
0 0 .823 r
.75827 .51796 m .76081 .51621 L .75256 .50781 L closepath p F P
0 g
s
.429 0 0 r
.6856 .43143 m .68352 .43288 L .68126 .42007 L closepath p F P
0 g
s
0 0 0 r
.68544 .42955 m .6856 .43143 L .68126 .42007 L closepath p F P
0 g
s
.853 0 0 r
.68314 .42837 m .68544 .42955 L .68126 .42007 L closepath p F P
0 g
s
.867 0 0 r
.68043 .43308 m .67813 .4319 L .68126 .42007 L closepath p F P
0 g
s
.676 0 0 r
.68352 .43288 m .68043 .43308 L .68126 .42007 L closepath p F P
0 g
s
.614 0 0 r
.68005 .42856 m .68314 .42837 L .68126 .42007 L closepath p F P
0 g
s
.955 0 0 r
.67813 .4319 m .67797 .43002 L .68126 .42007 L closepath p F P
0 g
s
.177 0 0 r
.67797 .43002 m .68005 .42856 L .68126 .42007 L closepath p F P
0 g
s
.83 .491 .412 r
.70126 .45208 m .64774 .43242 L .64923 .44412 L p F P
0 g
s
.83 .491 .412 r
.64923 .44412 m .70338 .46388 L .70126 .45208 L p F P
0 g
s
.501 .159 .319 r
.40202 .4125 m .46034 .39989 L .46175 .39059 L p F P
0 g
s
.52 .199 .363 r
.46034 .39989 m .40202 .4125 L .39971 .42278 L p F P
0 g
s
.754 .39 .365 r
.64365 .41118 m .58488 .3992 L .58601 .4093 L p F P
0 g
s
.754 .39 .365 r
.58601 .4093 m .64588 .42143 L .64365 .41118 L p F P
0 g
s
1 1 0 r
.007 w
.31745 .50996 m
.33443 .50009 L
s
.5 Mabswid
.597 .243 .339 r
.52259 .38612 m .46175 .39059 L .46034 .39989 L p F P
0 g
s
.675 .307 .34 r
.58358 .38991 m .52259 .38612 L .52253 .39535 L p F P
0 g
s
.675 .307 .34 r
.52253 .39535 m .58488 .3992 L .58358 .38991 L p F P
0 g
s
.676 0 0 r
.38426 .42793 m .3812 .42813 L .38264 .41509 L closepath p F P
0 g
s
.383 0 0 r
.3861 .42647 m .38426 .42793 L .38264 .41509 L closepath p F P
0 g
s
0 0 0 r
.38563 .42459 m .3861 .42647 L .38264 .41509 L closepath p F P
0 g
s
.854 0 0 r
.38313 .42339 m .38563 .42459 L .38264 .41509 L closepath p F P
0 g
s
.855 0 0 r
.3812 .42813 m .3787 .42694 L .38264 .41509 L closepath p F P
0 g
s
.61 0 0 r
.38006 .42359 m .38313 .42339 L .38264 .41509 L closepath p F P
0 g
s
.993 0 0 r
.3787 .42694 m .37822 .42506 L .38264 .41509 L closepath p F P
0 g
s
.041 0 0 r
.37822 .42506 m .38006 .42359 L .38264 .41509 L closepath p F P
0 g
s
.443 .174 .409 r
.34284 .4658 m .39623 .44548 L .39778 .43378 L p F P
0 g
s
.461 .209 .445 r
.39623 .44548 m .34284 .4658 L .34123 .47821 L p F P
0 g
s
.597 .243 .339 r
.46034 .39989 m .52253 .39535 L .52259 .38612 L p F P
0 g
s
.833 .513 .447 r
.70338 .46388 m .64923 .44412 L .65034 .45649 L p F P
0 g
s
1 0 0 r
.007 w
.68167 .42846 m
.68266 .44862 L
s
.5 Mabswid
.833 .513 .447 r
.65034 .45649 m .70495 .47629 L .70338 .46388 L p F P
0 g
s
1 1 0 r
.007 w
.70306 .49373 m
.72121 .50303 L
s
.5 Mabswid
.52 .199 .363 r
.39971 .42278 m .45911 .41 L .46034 .39989 L p F P
0 g
s
.536 .234 .401 r
.45911 .41 m .39971 .42278 L .39778 .43378 L p F P
0 g
s
.761 .418 .403 r
.64588 .42143 m .58601 .4093 L .58696 .42017 L p F P
0 g
s
.761 .418 .403 r
.58696 .42017 m .64774 .43242 L .64588 .42143 L p F P
0 g
s
.611 .277 .38 r
.52253 .39535 m .46034 .39989 L .45911 .41 L p F P
0 g
s
.686 .338 .38 r
.58488 .3992 m .52253 .39535 L .52248 .40539 L p F P
0 g
s
.686 .338 .38 r
.52248 .40539 m .58601 .4093 L .58488 .3992 L p F P
0 g
s
.461 .209 .445 r
.34123 .47821 m .39508 .45786 L .39623 .44548 L p F P
0 g
s
1 0 0 r
.007 w
.38107 .45018 m
.38227 .42345 L
s
.5 Mabswid
.477 .241 .477 r
.39508 .45786 m .34123 .47821 L .34019 .49118 L p F P
0 g
s
0 0 .643 r
.32868 .49194 m .32917 .49488 L .31552 .49657 L closepath p F P
0 g
s
0 0 .814 r
.3272 .48949 m .32868 .49194 L .31552 .49657 L closepath p F P
0 g
s
0 0 .948 r
.3256 .48896 m .3272 .48949 L .31552 .49657 L closepath p F P
0 g
s
0 0 .051 r
.32481 .49067 m .3256 .48896 L .31552 .49657 L closepath p F P
0 g
s
0 0 .644 r
.32531 .49363 m .32481 .49067 L .31552 .49657 L closepath p F P
0 g
s
0 0 .277 r
.32917 .49488 m .3284 .4966 L .31552 .49657 L closepath p F P
0 g
s
0 0 .867 r
.3268 .49608 m .32531 .49363 L .31552 .49657 L closepath p F P
0 g
s
0 0 .937 r
.3284 .4966 m .3268 .49608 L .31552 .49657 L closepath p F P
0 g
s
.835 .533 .478 r
.70495 .47629 m .65034 .45649 L .65106 .4695 L p F P
0 g
s
1 0 0 r
.007 w
.68266 .44862 m
.68345 .46477 L
s
.5 Mabswid
.835 .533 .478 r
.65106 .4695 m .70597 .48926 L .70495 .47629 L p F P
0 g
s
1 0 0 r
.007 w
.68345 .46477 m
.68421 .4802 L
s
.5 Mabswid
0 .772 0 r
.53507 .31974 m .53202 .31994 L .53462 .30945 L closepath p F P
0 g
s
0 .546 0 r
.53765 .32061 m .53507 .31974 L .53462 .30945 L closepath p F P
0 g
s
0 .965 0 r
.53202 .31994 m .53026 .32109 L .53462 .30945 L closepath p F P
0 g
s
0 0 0 r
.53824 .32204 m .53765 .32061 L .53462 .30945 L closepath p F P
0 g
s
.611 .277 .38 r
.45911 .41 m .52248 .40539 L .52253 .39535 L p F P
0 g
s
0 0 0 r
.53026 .32109 m .53085 .32251 L .53462 .30945 L closepath p F P
0 g
s
.536 .234 .401 r
.39778 .43378 m .45809 .42088 L .45911 .41 L p F P
0 g
s
.55 .265 .436 r
.45809 .42088 m .39778 .43378 L .39623 .44548 L p F P
0 g
s
1 1 0 r
.007 w
.68332 .48533 m
.70306 .49373 L
s
.5 Mabswid
0 .784 0 r
.53649 .32319 m .53824 .32204 L .53462 .30945 L closepath p F P
0 g
s
.766 .442 .437 r
.64774 .43242 m .58696 .42017 L .58772 .4318 L p F P
0 g
s
.766 .442 .437 r
.58772 .4318 m .64923 .44412 L .64774 .43242 L p F P
0 g
s
0 .482 0 r
.53085 .32251 m .53342 .32338 L .53462 .30945 L closepath p F P
0 g
s
0 .663 0 r
.53342 .32338 m .53649 .32319 L .53462 .30945 L closepath p F P
0 g
s
0 1 0 r
.007 w
.5326 .37582 m
.5342 .32333 L
s
.5 Mabswid
.477 .241 .477 r
.34019 .49118 m .39434 .47086 L .39508 .45786 L p F P
0 g
s
0 0 1 r
.007 w
.35028 .48509 m
.37994 .4753 L
s
.32526 .49335 m
.35028 .48509 L
s
1 1 0 r
.33443 .50009 m
.35309 .49105 L
s
1 0 0 r
.3803 .46731 m
.38107 .45018 L
s
.37994 .4753 m
.3803 .46731 L
s
1 1 0 r
.35309 .49105 m
.37328 .48295 L
s
.5 Mabswid
.623 .307 .415 r
.52248 .40539 m .45911 .41 L .45809 .42088 L p F P
0 g
s
.695 .366 .416 r
.58601 .4093 m .52248 .40539 L .52244 .41623 L p F P
0 g
s
.695 .366 .416 r
.52244 .41623 m .58696 .42017 L .58601 .4093 L p F P
0 g
s
.676 0 0 r
.53533 .40568 m .53221 .40588 L .53336 .39273 L closepath p F P
0 g
s
.403 0 0 r
.53731 .40418 m .53533 .40568 L .53336 .39273 L closepath p F P
0 g
s
0 0 0 r
.537 .40225 m .53731 .40418 L .53336 .39273 L closepath p F P
0 g
s
.854 0 0 r
.53457 .40102 m .537 .40225 L .53336 .39273 L closepath p F P
0 g
s
.863 0 0 r
.53221 .40588 m .52977 .40466 L .53336 .39273 L closepath p F P
0 g
s
.608 0 0 r
.53144 .40123 m .53457 .40102 L .53336 .39273 L closepath p F P
0 g
s
.982 0 0 r
.52977 .40466 m .52945 .40273 L .53336 .39273 L closepath p F P
0 g
s
.1 0 0 r
.52945 .40273 m .53144 .40123 L .53336 .39273 L closepath p F P
0 g
s
.623 .307 .415 r
.45809 .42088 m .52244 .41623 L .52248 .40539 L p F P
0 g
s
.55 .265 .436 r
.39623 .44548 m .45727 .43251 L .45809 .42088 L p F P
0 g
s
.562 .293 .466 r
.45727 .43251 m .39623 .44548 L .39508 .45786 L p F P
0 g
s
1 1 0 r
.007 w
.66217 .47792 m
.68332 .48533 L
s
.5 Mabswid
.77 .463 .467 r
.64923 .44412 m .58772 .4318 L .58828 .44415 L p F P
0 g
s
.77 .463 .467 r
.58828 .44415 m .65034 .45649 L .64923 .44412 L p F P
0 g
s
1 1 0 r
.007 w
.37328 .48295 m
.39483 .47585 L
s
.5 Mabswid
.632 .334 .447 r
.52244 .41623 m .45809 .42088 L .45727 .43251 L p F P
0 g
s
.702 .391 .447 r
.58696 .42017 m .52244 .41623 L .52241 .42783 L p F P
0 g
s
.702 .391 .447 r
.52241 .42783 m .58772 .4318 L .58696 .42017 L p F P
0 g
s
1 0 0 r
.007 w
.53338 .4011 m
.53344 .42688 L
s
0 0 1 r
.65769 .47024 m
.68421 .4802 L
s
.5 Mabswid
.562 .293 .466 r
.39508 .45786 m .45666 .44486 L .45727 .43251 L p F P
0 g
s
.573 .319 .493 r
.45666 .44486 m .39508 .45786 L .39434 .47086 L p F P
0 g
s
1 1 0 r
.007 w
.63977 .47157 m
.66217 .47792 L
s
.5 Mabswid
.632 .334 .447 r
.45727 .43251 m .52241 .42783 L .52244 .41623 L p F P
0 g
s
.773 .483 .494 r
.65034 .45649 m .58828 .44415 L .58864 .45718 L p F P
0 g
s
.773 .483 .494 r
.58864 .45718 m .65106 .4695 L .65034 .45649 L p F P
0 g
s
.641 .358 .475 r
.52241 .42783 m .45727 .43251 L .45666 .44486 L p F P
0 g
s
.708 .413 .475 r
.58772 .4318 m .52241 .42783 L .52238 .44017 L p F P
0 g
s
.708 .413 .475 r
.52238 .44017 m .58828 .44415 L .58772 .4318 L p F P
0 g
s
1 1 0 r
.007 w
.61631 .46636 m
.63977 .47157 L
s
.5 Mabswid
.573 .319 .493 r
.39434 .47086 m .45626 .45788 L .45666 .44486 L p F P
0 g
s
1 1 0 r
.007 w
.39483 .47585 m
.41758 .46985 L
s
.41758 .46985 m
.44132 .465 L
s
.5 Mabswid
.641 .358 .475 r
.45666 .44486 m .52238 .44017 L .52241 .42783 L p F P
0 g
s
1 1 0 r
.007 w
.59201 .46236 m
.61631 .46636 L
s
.5 Mabswid
.647 .38 .501 r
.52238 .44017 m .45666 .44486 L .45626 .45788 L p F P
0 g
s
1 1 0 r
.007 w
.44132 .465 m
.46583 .46137 L
s
.5 Mabswid
.712 .433 .501 r
.58828 .44415 m .52238 .44017 L .52237 .45321 L p F P
0 g
s
1 0 0 r
.007 w
.53344 .42688 m
.53349 .44316 L
s
.5 Mabswid
.712 .433 .501 r
.52237 .45321 m .58864 .45718 L .58828 .44415 L p F P
0 g
s
1 0 0 r
.007 w
.53349 .44316 m
.53351 .45327 L
s
.5 Mabswid
0 0 .646 r
.63059 .45984 m .63 .46281 L .62074 .45635 L closepath p F P
0 g
s
0 0 .87 r
.63218 .45737 m .63059 .45984 L .62074 .45635 L closepath p F P
0 g
s
0 0 .036 r
.63 .46281 m .63075 .46454 L .62074 .45635 L closepath p F P
0 g
s
0 0 .949 r
.63384 .45685 m .63218 .45737 L .62074 .45635 L closepath p F P
0 g
s
1 1 0 r
.007 w
.56709 .45959 m
.59201 .46236 L
s
.46583 .46137 m
.4909 .459 L
s
.5 Mabswid
0 0 .944 r
.63075 .46454 m .63241 .46402 L .62074 .45635 L closepath p F P
0 g
s
.647 .38 .501 r
.45626 .45788 m .52237 .45321 L .52238 .44017 L p F P
0 g
s
0 0 .257 r
.6346 .45858 m .63384 .45685 L .62074 .45635 L closepath p F P
0 g
s
1 1 0 r
.007 w
.54177 .4581 m
.56709 .45959 L
s
.4909 .459 m
.51629 .4579 L
s
.5 Mabswid
0 0 .816 r
.63241 .46402 m .634 .46155 L .62074 .45635 L closepath p F P
0 g
s
0 0 .642 r
.634 .46155 m .6346 .45858 L .62074 .45635 L closepath p F P
0 g
s
0 0 1 r
.007 w
.63404 .46135 m
.65769 .47024 L
s
1 1 0 r
.51629 .4579 m
.54177 .4581 L
s
.5 Mabswid
0 0 .644 r
.47024 .45165 m .47019 .45473 L .45633 .45201 L closepath p F P
0 g
s
0 0 .83 r
.47029 .4489 m .47024 .45165 L .45633 .45201 L closepath p F P
0 g
s
0 0 .262 r
.47019 .45473 m .47016 .45636 L .45633 .45201 L closepath p F P
0 g
s
0 0 .968 r
.47029 .4481 m .47029 .4489 L .45633 .45201 L closepath p F P
0 g
s
0 0 1 r
.007 w
.51959 .45304 m
.52376 .45311 L
s
.52376 .45311 m
.53351 .45327 L
s
.5 Mabswid
0 0 .963 r
.47016 .45636 m .47017 .45557 L .45633 .45201 L closepath p F P
0 g
s
0 0 .256 r
.47027 .44972 m .47029 .4481 L .45633 .45201 L closepath p F P
0 g
s
0 0 .642 r
.47021 .45282 m .47027 .44972 L .45633 .45201 L closepath p F P
0 g
s
0 0 1 r
.007 w
.47022 .45223 m
.51959 .45304 L
s
.5 Mabswid
0 0 .83 r
.47017 .45557 m .47021 .45282 L .45633 .45201 L closepath p F P
0 g
s
0 .598 0 r
.7226 .44679 m .72013 .44488 L .72844 .44103 L closepath p F P
0 g
s
0 .234 0 r
.72375 .44953 m .7226 .44679 L .72844 .44103 L closepath p F P
0 g
s
0 .867 0 r
.72013 .44488 m .71778 .44492 L .72844 .44103 L closepath p F P
0 g
s
0 0 0 r
.72289 .45151 m .72375 .44953 L .72844 .44103 L closepath p F P
0 g
s
0 0 0 r
.71778 .44492 m .71692 .4469 L .72844 .44103 L closepath p F P
0 g
s
0 .888 0 r
.72054 .45155 m .72289 .45151 L .72844 .44103 L closepath p F P
0 g
s
0 .39 0 r
.71692 .4469 m .71806 .44964 L .72844 .44103 L closepath p F P
0 g
s
0 .631 0 r
.71806 .44964 m .72054 .45155 L .72844 .44103 L closepath p F P
0 g
s
0 1 0 r
.007 w
.68421 .4802 m
.71841 .44992 L
s
.5 Mabswid
0 .866 0 r
.34447 .44058 m .3433 .44329 L .33943 .43463 L closepath p F P
0 g
s
0 .894 0 r
.34705 .43875 m .34447 .44058 L .33943 .43463 L closepath p F P
0 g
s
0 .68 0 r
.34951 .43887 m .34705 .43875 L .33943 .43463 L closepath p F P
0 g
s
0 0 0 r
.3433 .44329 m .34421 .4453 L .33943 .43463 L closepath p F P
0 g
s
0 .41 0 r
.35043 .44088 m .34951 .43887 L .33943 .43463 L closepath p F P
0 g
s
0 .589 0 r
.34421 .4453 m .34668 .44543 L .33943 .43463 L closepath p F P
0 g
s
0 .69 0 r
.34926 .4436 m .35043 .44088 L .33943 .43463 L closepath p F P
0 g
s
0 .715 0 r
.34668 .44543 m .34926 .4436 L .33943 .43463 L closepath p F P
0 g
s
0 1 0 r
.007 w
.34873 .44397 m
.37994 .4753 L
s
.5 Mabswid
0 .942 0 r
.53544 .41108 m .53244 .41201 L .53589 .40569 L closepath p F P
0 g
s
0 .626 0 r
.53845 .41211 m .53544 .41108 L .53589 .40569 L closepath p F P
0 g
s
0 0 0 r
.53971 .41451 m .53845 .41211 L .53589 .40569 L closepath p F P
0 g
s
0 0 0 r
.53244 .41201 m .5312 .41437 L .53589 .40569 L closepath p F P
0 g
s
0 .864 0 r
.53847 .41687 m .53971 .41451 L .53589 .40569 L closepath p F P
0 g
s
0 .203 0 r
.5312 .41437 m .53245 .41677 L .53589 .40569 L closepath p F P
0 g
s
0 .792 0 r
.53547 .41781 m .53847 .41687 L .53589 .40569 L closepath p F P
0 g
s
0 .601 0 r
.53245 .41677 m .53547 .41781 L .53589 .40569 L closepath p F P
0 g
s
0 1 0 r
.007 w
.53351 .45327 m
.53529 .41775 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 248.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001M2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00i@3oool00`000000oooo0?ooo`380?ooo`00i@3oool00`000000oooo
0?ooo`380?ooo`00i03oool200000<X0oooo003T0?ooo`<00000b@3oool00><0oooo100000390?oo
o`00h`3oool0100000000?l0003o0000o`390?ooo`00h`3oool0100000000?l0003o0000o`390?oo
o`00h`3oool0100000000?l0003o0000o`390?ooo`00h`3oool0100000000?l0003o0000o`390?oo
o`00[`3oool00`000000oooo0?ooo`0a0?ooo`0400000000o`000?l0003o0<T0oooo002_0?ooo`80
0000<@3oool2000000<00?l0<`3oool00`000000oooo0?ooo`2C0?ooo`00[`3oool200000340oooo
1@00o`0b0?ooo`800000U@3oool00:l0oooo0`00000E0?ooo`030000003oool0oooo01P0oooo1@00
o`0b0?ooo`800000U@3oool00:l0oooo0`00o`000`000000oooo0?ooo`0B0?ooo`8000006@3oool5
003o01P0oooo00<000000?ooo`3oool05P3oool2000009H0oooo002_0?ooo`<00?l05@3oool20000
01T0oooo1@00o`0G0?ooo`800000603oool2000009H0oooo002_0?ooo`@00?l0503oool3003o01P0
oooo1@00o`0F0?ooo`<000005`3oool3003o09H0oooo002`0?ooo`<00?l0503oool3003o00030000
003oool0oooo01D0oooo1000o`000`000000oooo0?ooo`0D0?ooo`<00?l05`3oool3003o09H0oooo
002`0?ooo`<00?l0503oool3003o00030000003oool0oooo01D0oooo1000o`000`000000oooo0?oo
o`0C0?ooo`0400000000o`000?l0003o01H0oooo1000o`2F0?ooo`00/03oool4003o01<0oooo0`00
o`0H0?ooo`<00?l00P00000E0?ooo`0400000000o`000?l0003o01H0oooo0`00o`2G0?ooo`00/@3o
ool3003o01@0oooo0`00o`0G0?ooo`<00?l00`00000D0?ooo`@00?l05P3oool3003o09L0oooo002a
0?ooo`@00?l04`3oool3003o01L0oooo0P00o`0200000003002Y00000000oooo01<0oooo0`00o`0F
0?ooo`@00?l0U`3oool00;80oooo0`00o`0C0?ooo`<00?l05`3oool2003o000400000000o`000?l0
003o01@0oooo0`00o`0F0?ooo`<00?l0V03oool00;80oooo0`00o`0C0?ooo`<00?l05`3oool2003o
000400000000o`000?l0003o01@0oooo0`00o`0E0?ooo`@00?l0V03oool00;80oooo1000o`0B0?oo
o`<00?l05`3oool6003o01<0oooo1000o`0E0?ooo`<00?l0V@3oool00;<0oooo0`00o`0C0?ooo`<0
0?l05P3oool6003o01<0oooo0`00o`0F0?ooo`<00?l0V@3oool00;<0oooo0`00o`0C0?ooo`<00?l0
5P3oool6003o01<0oooo0`00o`0E0?ooo`@00?l0V@3oool00;<0oooo1000o`0B0?ooo`<00?l05P3o
ool6003o01<0oooo0`00o`0D0?ooo`0400000000o`000?l0003o09X0oooo002d0?ooo`<00?l04P3o
ool3003o01H0oooo1P00o`0B0?ooo`@00?l04`3oool00`0000000?l0003o0002003o09X0oooo002K
0?ooo`030000003oool0oooo01H0oooo1000o`0A0?ooo`<00?l05P3oool6003o0180oooo0`00o`0C
0?ooo`8000000`00o`2K0?ooo`00V`3oool2000001L0oooo1000o`0A0?ooo`<00?l05P3oool6003o
0180oooo0`00o`0B0?ooo`H00?l0V`3oool009/0oooo0`00000G0?ooo`<00?l04P3oool3003o00`0
oooo2P000005003o00800000403oool3003o0180oooo1P00o`2K0?ooo`00W03oool3000001H0oooo
1000o`0A0?ooo`<00?l00P3ooolD000000D00?l03P0000040?ooo`<00?l04@3oool6003o01/0oooo
00<000000?ooo`3oool0OP3oool009`0oooo00@00000003o0000o`000?l05@3oool4003o0140oooo
00<00?l00000000000002P0000000`0o000000000000000;000000<00?l04P000003003o0140oooo
1P00o`0J0?ooo`800000P03oool008T0oooo00<000000?ooo`3oool0403oool0100000000?l0003o
0000o`0F0?ooo`@00?l03@3oool40000000301D000000000000000X00000101E0009000000<00?l0
0`1`000C00000100oooo1P00o`0H0?ooo`@00000P03oool008T0oooo0P00000B0?ooo`@00?l05@3o
ool4003o00L0oooo2@00000202d000030000001E0000E@0000<0E@002P00000506H0000300000020
0000P00000<00?l02P000004070000030000001o0000O`0000X000002`3oool6003o01P0oooo1000
00210?ooo`00RP3oool200000003003o003oool0oooo00l0oooo0`00o`0E0?ooo`@00?l00`3oool6
0000000301D000000000000000@0;@002000000:06H000P000000`00o`05000000D0P00020000004
07l000T000001`3oool6003o01P0oooo0`00o`000`000000oooo0?ooo`1o0?ooo`00RP3oool01000
00000?l0003o0000000@0?ooo`@00?l05@3oool4003o00@0000000@05@0000000000000000000P0]
000400000080@@0000<0000006H0001V00000`1V000;000000D0M00400<0000008d=1@2=3@D00`00
o`0508d=1A8000000`1o0007000000@0oooo1P00o`0I0?ooo`<00?l000<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`1`0?ooo`00R`3oool3003o0140oooo1000o`0D0?ooo`@00?l010000000
0`0]0000000000000003000000@0@@002000000;07@010P000000`00o`0@08d=1@030000002O6@00
WaT000T000001@1o0003000000030?ooo`00o`000?l000@00?l0603oool4003o00h0oooo0P00001b
0?ooo`00R`3oool4003o0140oooo0`00o`0C0?ooo`8000000P00o`06000000@0@@00100000020540
00030000001d00@0M00400<0M0042`00000607l;6P030000002G7Q/0UahK00<00?l03000000508d=
1@030000002O6@00WaT000<0WaT010000002094400@0000000<0O`000000000000000P000005003o
01L0oooo1000o`0=0?ooo`03003o00000000000007<0oooo002<0?ooo`@00?l0403oool4003o00l0
oooo20000003044000H00000101A000800000140O`/J00<0000009LN6`2G7Q/00`00o`0<09LN6`P0
00001`2O6@04000000@0T@@01@000002003o01P0oooo0`00o`0=0?ooo`0400000000o`000?l00000
07<0oooo002=0?ooo`<00?l04@3oool3003o00d0oooo1@0000000`0:0000000004400005000000H0
D@000`00000205l040030000001o2aX0O`/J00X0O`/J3P000003003o00H000002`2G7Q/00`000000
ZB/A0:T[4@06000000D0WaT0100000001@2A10000000000000000000PP0000<000005P3oool4003o
00d0oooo0`00o`1d0?ooo`00SP3oool3003o0100oooo1000o`070?ooo`030000003oool0oooo00D0
000000<02P000000000000000P000007054000@000000`1O010?000000/0R1/]00<0000009h];@2N
;Bd00`00o`0609h];@l000001@2Y:a45000000H0WaT01`0000000`1W000000000?ooo`0A0?ooo`@0
0?l03@3oool4003o07@0oooo002>0?ooo`@00?l0403oool3003o00L0oooo1P000000100:00000000
01h000000005054000D000000`1O010400000080J@0T00<0000008PK;@286bd05@286bd00`000000
WRd]09h];@03003o0180WRd]00<000000;4j9@2a>RD0100000060:T[4@H0000000<0WaT000000000
00002000000@0?ooo`<00?l03@3oool4003o07D0oooo002?0?ooo`@00?l03`3oool4003o00D0oooo
1@0000000`0:0000000001h0000201h000030000001A0000000000<000000`1O0105000000D0J@0T
00<0000008PK;@286bd02P286bd?000000<00?l01`00000<09h];@030000002a>RD0/CXU00<0/CXU
1@0000090:T[4@80000000<0Z1`00000000000001P00000=0?ooo`@00?l0303oool4003o07H0oooo
002@0?ooo`<00?l0403oool4003o0080oooo100000000`0:000000000000000301h000@000000P1O
0105000000T0J@0T3P00000<08hX?@030000002T>Sd0Y3Xm00<00?l01`2T>Sd?000000P0/CXU1@00
00050:T[4@<0000000<0Z1`00000000000001P00000:0?ooo`@00?l03@3oool3003o07L0oooo002A
0?ooo`<00?l0403oool3003o00<000000P0:0002000000807P000P0000000`0`0000000005l04004
000000X0J@0T0`000002078?=P030000002>:3d0SRPm01H0SRPm00<000000:@j?@2T>Sd00`00o`0C
0:@j?@030000002gAcH0]dLf00@000002@2a>RD4000000040:T[4@000000]C000;D`008000000P2X
7007000000P0oooo0`00o`0=0?ooo`<00?l0N03oool00940oooo1000o`0?0?ooo`@00?l000@02P00
00000000000000000P0N0002000000030300000000000000008000002P1Y02@4000000@0LPlf00<0
000008hX?@2>:3d04@2>:3d9000000<00?l01`00000<0:@j?@030000002gAcH0]dLf00@0]dLf1@00
000:0;4j9@8000000P2e<00300000080Z1`00P0000000`2G1@000000000000060?ooo`@00?l0303o
ool4003o07P0oooo002B0?ooo`@00?l03P3oool01@0000000?l0003o0000o`00000000807P000`00
00001@0`000000000000000n0100000000P0J@0T10000008078?=P030000002>:3d0SRPm00@0SRPm
3@00000609@cB`030000002YAD/0ZDE;00X0ZDE;3`0000090;M7=PD000001@2a>RD010000000_d4B
0000000000030;D`008000000`2X7004000000@0oooo0`00o`0<0?ooo`@00?l0N@3oool009<0oooo
0`00o`0=0?ooo`8000001000o`0200000004030000000000000000000080?P0@00<0000006T0901Y
02@00`1Y02@4000000X0LPlf2@00000C09@cB`030000002YAD/0ZDE;01H0ZDE;00<000000;]BA@2k
DTD01@0000090;M7=P@000000P2a>RD00`000000_d4B0;m14P0300000080]C000`0000030:PL00<0
000000<0oooo003o0000o`000P00o`0;0?ooo`@00?l0NP3oool009@0oooo0`00o`0:0?ooo`@00000
00D07P00003o0000o`000?l003000002000000D0?P0@00<0000006T0900000000`000009078?=PD0
00000P1j74@00`000000U3=;09@cB`0A09@cB`d000004P2YAD/00`000000^e950;]BA@050;]BA@D0
00002P2gAcH2000000@0_d4B0P0000030;D`008000000P2X7002000000@00?l0303oool3003o07/0
oooo002D0?ooo`@00?l01`3oool7000000@00?l01P0n0103000000T0LPlf1000000707XLA0030000
002D<d/0U3=;00@0U3=;3@00000609PnEP030000002/CUL0[4iG00@0[4iG3@0000060:U5B`030000
002kDTD0^e9500T0^e951@0000060;M7=P<00000102o@A8300000080]C000`000000102Q4`000?l0
003o0000o`0<0?ooo`<00?l0O03oool009D0oooo1000o`050?ooo`D000000P0`0002000000@00?l0
0`0n01000`000000B`0T00000006078?=PD000002@1j74@9000001<0V3iF00<000000:a>E`2/CUL0
4@2/CUL9000000h0^e951@000000102gAcH000000<I@9P36D2H3000000@0_d4B0P0000030;D`00@0
0?l00P0000090?ooo`@00?l0O03oool009H0oooo0`00o`030?ooo`D0000000@0<000000000000000
00000`0n0103003o008000000`1;02@00`000000LPlf00000004000000X0NQa410000002080XD@03
0000002H?UH0V3iF01L0V3iF00D000000:a>E`2/CUL0[4iG0000000E0:a>E`030000002nFe80_U]B
00D00000402kDTD2000000<0aU0V0`0000030;m14P8000001000o`00102Q4`000000000000000007
0?ooo`@00?l0O@3oool009L0oooo0`00o`000`3oool0000000000005000000H0?P0@1000o`0204/0
90@000002`1j74@4000000D0P2QA00<0000009PnEP2H?UH04P2H?UH=000001<0[4iG00<000000;iK
DP2nFe801@2nFe85000000/0^e9500@000000<]L>000000000001036D2H2000000<0_d4B0`00o`03
000000030:4C00000000000000H0oooo0`00o`1n0?ooo`00U`3oool2003o00L000001P0n01020000
000404/09000o`000?l0003o0080000000<0E@0f0000001j74@0201j74@4000000T0P2QA00<00000
09PnEP2H?UH0102H?UH>000000H0W4IQ00@000000:mFH@2_EV40[eIQ0P0000000`2_EV4000000000
000<000000H0[4iG00<000000;iKDP2nFe802@2nFe85000000H0^e9500@000000<]L>03;G3P0be`h
0`0000030<I@9P8000001000o`000`2o@A8000000;@[0002000000030:4C00000000000000<0oooo
0`00o`1o0?ooo`00V03oool6000000D0?P0@0`00000304/090<00?l00P1E03H00`000000NQa407XL
A00407XLA0@000002`20:549000001@0W4IQ00<000000:mFH@2_EV400`3o000?0:mFH@T000003P2n
Fe8500000080^e9500<000000<]L>03;G3P00`3;G3P3000000030<I@9P00o`000?l000800?l000<0
00000;m14P2o@A800P0000000`2d:`0000000:4C0002000000030?ooo`00o`000?l000800?l0O`3o
ool009L0oooo1`00000203h040<000000`1;02@3000000D0E@0f00<0000007XLA01j74@01000000;
080XD@@000000P25<U`00`000000W4IQ09a6H@0H09a6H@030000002_EV40[eIQ00<0o`0000<00000
0:mFH@2_EV404P2_EV400`000000`F=M0<5SG@0500000100_U]B0P0000070<]L>00400000000o`00
0?l0003o0080aU0V0`0000000`33?`00000000000002000000030:4C00000000000000800?l0P03o
ool009D0oooo200000000`0n010000000000000404/0908000001`1E03H4000000/0P2QA10000006
08DbG0030000002LAV40W4IQ01P0W4IQ00<000000:mFH@2_EV400`3o00000`000000[eIQ0:mFH@0B
0:mFH@0300000031Hed0`F=M00D0`F=M1@00000;0;iKDP030000003>ITL00000008000001@3;G3P3
003o000300000036D2H0aU0V0080aU0V00<000000<<o0033?`00100000000`2Q4`0000000?ooo`20
0?ooo`00U03oool:000000<0B`0T0`00000605D0=P<0000000<0GPY500000020:5402020:5440000
00T0QC9L00<0000009a6H@2LAV404`2LAV4900000080o`002@00000=0:mFH@0300000031Hed0`F=M
00X0`F=M1@0000060;iKDP030000003>ITL0cVI70080cVI70P0000070<]L>0<000000P36D2H20000
0080`cl000<000000;@[000000000P0000200?ooo`00T`3oool900000080B`0T0`00000705D0=P80
00000`1N2TD00`000000P2QA080XD@04080XD@@000003@25<U`00`000000W4IQ09a6H@0509a6H@h0
00001P2OCVX010000000/EeZ0;5MJP3o0003000000L0/EeZ4000000?0<5SG@D000000P2nFe800`00
0000cVI70<iVA`030<iVA`<000001`3;G3P3000000040<iA1`00000000000<<o0080000000<0]2/0
000000000000O`3oool006P0oooo0P00000X0?ooo`P0000000@03P0300000000000000001`1E03H3
000000D0GPY500<00000080XD@20:5401000000?08DbG0X00000502OCVX010000000/EeZ0;5MJP3o
0003000001@0/EeZ00<000000<9[I`32JfL01000000B0<5SG@8000001`3>ITL3000000L0be`h00@0
00000<iA1`3>D@L000000P33?`02000000030;@[00000000oooo07d0oooo001Y0?ooo`@00000903o
ool7000000803P030P00000605D0=P<000001`1N2TD4000000h0QC9L1@00000208TkIP030000002O
CVX0WdiZ01T0WdiZ00<000000;5MJP2aGFX01@00000C0;5MJP0300000032JfL0`V]W00@0`V]W1000
000>0<5SG@040000003AKe@00000000000P0cVI70`0000040<]L>0<0000000<0cU47000000000000
0P33?`03000007d0oooo001Z0?ooo`D000008@3oool70000000300h00`000000000000D0E@0f0`00
000205h:A@030000001N2TD0GPY50080GPY50`0000000`1U5e80000008DbG00:08DbG0D000001`29
>fH00`000000WdiZ09m>JP0C09m>JPX000000`00o`000`000000/EeZ0;5MJP0A0;5MJP0300000032
JfL0`V]W00P0`V]W1@0000090<5SG@040000003AKe@0dFmD0=5_E0<00000203>ITL2000000<0be`h
00<000000=IQ7@0000000P3>D@L200000080`cl00P00001l0?ooo`00JP3oool00`00000008d0003o
0002003o0200oooo1P00000200h00`030000000M01X0000000<0E@0f0P00000505h:A@030000001N
2TD0GPY5008000000`1U5e800`000000QC9L08DbG00508DbG0D000003029>fH00`000000WdiZ09m>
JP0509m>JPh000001P2QEG8010000000/fAb0;=TLP3o0003003o00h000001P2aGFX00`000000`V]W
0<9[I`0=0<9[I`@000001P31Hed00`000000dFmD0=5_E0030=5_E0800000203>ITL400000080eV4M
0P0000020<iA1`8000000P33?`000`000000oooo0?ooo`1i0?ooo`00J`3oool00`0000000?l0003o
0002003o01h0oooo1P0000001P0>00<000000000000M01X0000005D0=P<000001P1N2TD4000000D0
IAMB00<0000008DbG025<U`01@00000?08TkIPX00000502QEG8010000000/fAb0;=TLP3o0003003o
00h0/fAb2@00000A0<9[I`@000000P31Hed00`000000dFmD0=5_E0050=5_E08000001@3>ITL00`00
0000cVI70<iVA`020<iVA`050000003FHAd0eV4M0=IQ7@0000000`3>D@L010000000`cl00<<o0000
001j0?ooo`00K03oool5003o00`0oooo0`00000=0?ooo`D000000P0>00<0100000007@0J01d06P0M
01X2000000L0GPY50P0000030?l000D0IAMB1000000@08TkIP@000000P2<@fl00`000000XEEb0:5E
LP0I0:5ELP040000002cI780/fAb0?l000<00?l0502cI7800`000000a75_0<AaK`0600000140`V]W
0P0000080=5_E0<000000P3>ITL00`000000cVI70<iVA`020<iVA`<000000P3FHAd200000080cU47
1000000U0?ooo`<00000D@3oool006h0oooo1@00o`0;0?ooo`0500000000o`000?l0003o00000000
2@3oool50000000300h00`000000000000807@0J00<0000002/0;@0000001@1N2TD300000080IAMB
0`3o00000`000000IAMB06DGDP020000000306`RGP000000RC]V00d0RC]V1000000608a3K`030000
002QEG80XEEb01T0XEEb00@000000;=TLP2cI780o`000`00o`0D0;=TLP0300000034LFl0a75_00H0
a75_1@00000<0<9[I`030000003CMel0000000800000203AKe@4000000<0cVI700@000000=a]<03L
KC0000000`3FHAd200000080cU471000000P0?ooo`D00000DP3oool006l0oooo1@00o`0:0?ooo`D0
0?l0203oool40000000300h00`000000000000<07@0J00<0000002/0;@000000101N2TD2000000D0
IAMB0`3o0003000000<0K29N00<0000008TkIP29>fH01`29>fH5000000X0S4=_00<000000:5ELP2Q
EG804`2QEG89000000040?l00000o`000?l0003o01D0/fAb00<000000<AaK`34LFl02P34LFl50000
00L0`V]W00<000000==gG`3CMel00P3CMel3000000H0dFmD0`3o00001@000000cVI70<iVA`3>ITL0
00000080g6d`0P0000030=IQ7@040000003>D@L0cU470<iA1`<000007`3oool4000005<0oooo001`
0?ooo`D00?l02P3oool00`0000000?l0003o0002003o00H0oooo0`00000200h00`040000000M01X0
7@0J01d06P8000000P0[02d00`000000GPY500000002000000L0IAMB0`3o000506`RGP0300000029
>fH0RC]V00@0RC]V1000000?08a3K`030000002QEG80XEEb00D0XEEb3P0000060:AKN@040000002e
JGT0]FUi0?l000<00?l03P0000070;=TLP0300000034LFl0a75_00l0a75_1P0000020<9[I`030000
003CMel0dgMO00@0dgMO0`0000030=5_E0<0o`000`0000000`3>ITL000000=a]<0030=a]<0040000
003FHAd0eV4M0=IQ7@80000000<0cU470000000000000P00000:0?ooo`8000004@3oool2003o0003
00000000[`00000005<0oooo001b0?ooo`D00?l02@3oool00`0000000?l0003o0002003o00@0oooo
0`0000000`0>00<000000000000301d06P030000000[02d0:`0]0080:`0]0P00000806DGDP800000
0`3o000506`RGP0300000029>fH0RC]V00@000004@2<@fl:000001@0Y5]i00@000000;EYN@2eJGT0
o`000`00o`0>0;EYN@X000005@34LFl4000000P0dgMO0P0000001@3AKe@0o`000?l0003o00000000
00<0dFmD00<000000=a]<03LKC000`3LKC02000000<0eV4M00<000000<iA1`0000000`0000060?oo
o`<00?l000<000000?ooo`3oool03P3oool5003o00030000003oool0oooo0580oooo001c0?ooo`D0
0?l02P3oool4003o0080oooo0`0000000`0>00<0000001d06P0201d06P<000000P0[02d00`000000
=P0o0000000606DGDP<000000P1/8Uh30?l000@0K29N1000000A08a3K`@000000P2?BgL00`000000
Y5]i0:AKN@0I0:AKN@040000002eJGT0]FUi0?l000<00?l05@2eJGT00`000000aGIg0<EfM`050000
0180a75_00@000000=AmJ@0000000000203CMel010000000o`000?l0003o00040=5_E0<000001@3L
KC0200000080eV4M0P0000001030A00000000000000000040?ooo`D00?l03`3oool5003o05H0oooo
001d0?ooo`D00?l02P3oool4003o00D000000P0M01X200000080:`0]0`0000000`0f03l0000006DG
DP0406DGDP8000001@1/8Uh30?l00080K29N0P0000000`1a;6P0000008a3K`0=08a3K`D000001P2?
BgL00`000000Y5]i0:AKN@0I0:AKN@030000002eJGT0]FUi00<00?l05P2eJGT00`000000aGIg0<Ef
M`050<EfM`D000003@34LFl010000000e7eY0=AmJ@3DOFT3000000H0dgMO0`3o0002000000<0dFmD
00@000000>1h@@00000000001@3LKC001P000000eV4M0=IQ7@3FHAd000000<1400<000000P3oool4
003o00030000003oool0oooo00`0oooo1P00o`1G0?ooo`00MP3oool5003o00T0oooo0P00o`040000
00<07@0J00<0000002/0;@0[02d00P0[02d400000003003o001U5e80IAMB00<000001`1/8Uh30?l0
008000000`1a;6P00`000000S4=_08a3K`0808a3K`@000002P2?BgL00`000000Y5]i0:AKN@0J0:AK
N@030000002eJGT0]FUi00<00?l05P2eJGT00`000000aGIg0<EfM`0:0<EfM`H000001`34LFl00`00
0000e7eY0=AmJ@040=AmJ@800000103CMel30?l00080dgMO100000030>1h@@800000103LKC020000
00040=IQ7@00000000000<1400<000001000o`02000000d0oooo1@00o`1I0?ooo`00M`3oool5003o
00T0oooo1000000201d06P8000000`0[02d20000000303H0?`000000000000<00?l000<0000006`R
GP1/8Uh0201/8Uh30?l000@0LBaX00<0000008a3K`2<@fl0102<@fl5000000h0Sd]g00<000000:AK
N@2TFgT04`2TFgT:000000<00?l02000000>0;EYN@0300000035MWL0aGIg0100aGIg1@0000020<Aa
K`030000003DOFT0e7eY00H0e7eY0`0000020==gG`<0o`001@3CMel00`000000h7Q10>1h@@020>1h
@@800000103LKC04000000030<1400000000000000<00?l03P3oool6003o05X0oooo001h0?ooo`D0
0?l01`3oool50000000301d06P000000:`0]00<0:`0]00<0000003H0?`0f03l00P0f03l010000000
0?l0003o0000o`0806`RGP<000000`3o0004074/J0030000002<@fl0S4=_00@000004`2?BgL00`00
0000Y5]i0:AKN@050:AKN@h000001`2UHH000`000000]Vj00;I^P003003o00P0]Vj04@00000E0<Ef
M`@000002P3DOFT2000000<0o`001@3CMel3000000@0h7Q100<000000=a]<03LKC00100000000`3@
F@0000000<14000200000003003o003oool0oooo00`0oooo1@00o`1L0?ooo`00NP3oool5003o00D0
oooo1P00000302/0;@800000100f03l3000000<00?l0101/8Uh3000000<0LBaX0`3o0003074/J0@0
00005@2?BgL:000001D0YF6000<000000;I^P02fKX000`00o`0F0;I^P00300000035Ngh0aG]n00@0
00004`35MWL010000000eH=b00000000000:0=AmJ@<0o`001@3CMel00`000000hh5?0>>1C`020000
00<0h7Q1100000020=a]<0040000003@F@0000000<1400800000303oool6003o05d0oooo001k0?oo
o`D00?l00`3oool5000000<0:`0]0P00000403H0?`8000000P1004h00`0000000?l0003o0002003o
000306`RGP000000000000H0LBaX0`3o00001@1a;6P000000000001f=G4000000180Sd]g1@000002
099AOP030000002UHH00YF600080YF600P00000F0:EQP0030000002fKX00]Vj000<00?l05P2fKX00
0`000000aG]n0<EkOP040<EkOPD000003P35MWL010000000eH=b0=F3LP3EPg83000000L0e7eY0`3o
0003000000<0dgMO00H000000>>1C`3SPDl0hh5?0000003PN443003o008000000P3LKC0200000003
0=1I00000000`4@0008000002P3oool5003o05l0oooo001l0?ooo`D00?l000<0oooo000000000000
0`00000302/0;@030000000f03l0=P0o00<0=P0o00D000000400CP1004h0@01>0000000206`RGP@0
0?l0201a;6P30?l000050000001f=G40MSEa07HeL@0000003@2?BgL5000000L0TU5n00<000000:EQ
P00000000P00000K0000o`<00?l05P2fKX000`000000aG]n0<EkOP090<EkOP@000002P35MWL00`00
0000eH=b0=F3LP040=F3LP<00000103DOFT30?l000<0e7eY0P0000000`3CMel000000>>1C`030>>1
C`D00?l000@0h7Q1000000000000g6d`0P000000103@F@0000000000000000080?ooo`H00?l0H03o
ool007h0oooo1@00o`040000000302/0;@000000000000@0=P0o0P0000040400CP040000001/8Uh0
0000000000@00?l01P1a;6P010000000o`000?l0003o000407HeL@030000002?BgL0Sd]g00D0Sd]g
1P00000<099AOPL000006@000?l3003o00030000002fKX00]Vj001<0]Vj000<000000<EkOP35Ngh0
3@35Ngh5000000H0aGIg00<000000=F3LP3EPg801P3EPg8200000080e7eY0`3o00060=AmJ@040000
003SPDl0hh5?0>>1C`@00?l00P0000030>1h@@80000000@0g6/50000003@F@00d5T00P0000060?oo
o`D00?l0HP3oool007l0oooo1000o`05000000D0=P0o00<000000400CP1004h0101004h2000000<0
LBaX1000o`02074/J0<0000000@0MSEa0?l0003o0000o`00101f=G400`000000Sd]g08m;M`050000
0180TU5n00<000000:EQP00000001000000I0000o`<00?l0203oo`07000000L0]Vj000<000000<Ek
OP35Ngh04P35Ngh400000080aGIg00<000000=F3LP3EPg80203EPg82000000<0o`001P3DOFT30000
00@00?l000<0hh5?0000000000001@3PN4400`000000g6/5000000020=1I008000000`3oool6003o
06<0oooo00200?ooo`<00?l00`00000503H0?`8000001@1004h00`000000B@YK00000005074/J0@0
0?l000<0000007HeL@1f=G400P1f=G430?l000<0MSEa1000000E099AOPX000000P2m^MH/0?oo00H0
00002`35Ngh7000000@0aG]n1000000;0=F3LP<0o`0000<000000=AmJ@3DOFT00`3DOFT00`000000
i8UL003o0003003o00@0hh5?0P0000030>1h@@80000000@0g6/50000003@F@00d5T00P0000000`3o
ool00?l0003o0003003o06D0oooo001o0?ooo`L000000`0f03l2000000D0@01>0P00000204T:F`03
0000001a;6P0LBaX00<0LBaX00<00000003o0000o`000P00o`0307HeL@<0o`000P1f=G4200000003
07XmNP000000TU5n0180TU5n100000000`33_]H0ool00?oo000m0?oo00@000001P35Ngh4000000<0
003o1@35Ngh00`000000eHQj00000002000000P0eH=b0`3o00000`3EPg800000000000040=AmJ@@0
0?l000<000000>>1C`3SPDl0103SPDl010000000h7Q10>1h@@3PN442000000040=a[1@0000000000
0=1I00H00?l0IP3oool007h0oooo1`00000303H0?`030000001004h0@01>00@0@01>00D0000004T:
F`192U/0B@YK00000003074/J0<000000P1f=G44003o0080MSEa0`3o0002000000<0NSej00<00000
099AOP2BDGh0302BDGh4000001`0ool00P2f[m<?000000<0[JSC00<000000:RUe03oo`005`3oo`04
00000080aG]n0`0000060000o`80aG]n00<000000=F8NP3ER7X00P3ER7X3000000D0eH=b0`3o0003
0=F3LP<000001000o`020>B9G08000001@3SPDl2000000040>1h@@000000iGXL00000080g6/500<0
0000003o0000o`000P00o`1X0?ooo`00OP3oool50000000300005`000000=P0o008000001@1004h2
000000@0B@YK00@00000074/J000000000001P1f=G44003o000407HeL@3o0000o`000?l000@0NSej
00<00000099AOP2BDGh02@2BDGh4000001D0ool000<000000;Zde02j]=@01@2j]=@00`000000]ZoC
0;J_d`050;J_d`030000002a[=80/JcB00D0/JcB00<000000:fXd`2]Z=<01@2]Z=<00`000000Z:GD
0:RUe0050:RUe0040000002SXmH0000000000180ool0100000080000o`030000003ER7X0eHQj00D0
eHQj0`0000020=F3LP<0o`00103EPg85003o00D0i8UL00<000000>>1C`3SPDl0103SPDl300000005
0>Ej70000000g6/50=a[1@0000000P00o`1Y0?ooo`00O@3oool50000000400005`00000000000000
00H0@01>00<0000004T:F`192U/010192U/2000000T0MSEa1000o`030?l000@0NSej00<00000099A
OP2BDGh0102BDGh5000000h0ool000<000000;nhd`2o^=<0102o^=<2003o00<000001`2j]=@00`00
0000]ZoC0;J_d`050;J_d`030000002a[=80/JcB00D0/JcB00<000000:fXd`2]Z=<01@2]Z=<00`00
0000Z:GD0:RUe0040:RUe003003o00000000000000T0XZ3C00<000000?oo003oo`003@3oo`000`00
0000003o0000o`070000o`P0eHQj0P0000030?l000<0eH=b1@00o`02000000D0i8UL0P0000060>>1
C`040000003UNQ`0iGXL00000080g6/50`00001X0?ooo`00O03oool500000080000G00<000000400
CP1004h0101004h2000000D0B@YK00<00000050FIP000000201f=G43000000@00?l00P3o000407Xm
NP030000002BDGh0TU5n00D00000303oo`050<Fnd`800000202o^=<00`000000^k;A0;^bd@040000
0080^[CD00<000000;J_d`2f[m<01P2f[m<00`000000/JcB0;6/dP060;6/dP030000002]Z=<0[JSC
00D0[JSC00<000000:RUe02XYM@0100000020:NRd@030000002RX=<0XZ3C00H0XZ3C0P00000409ZJ
d`h0ool020000?l80=F8NP<0o`000P3EPg84003o00040=F3LP000000iI1X0>F@J08000001@3TRE`2
000000@0hh5?0P0000020>Ej70030000003LJ`D0g6/500800000J03oool007`0oooo100000020000
5`800000101004h2000000D0B@YK0P000002050FIP030000001f=G40MSEa00@0MSEa0P00000407Xm
NP@00?l000@0o`0007XmNP1j?GX0NSej100000000`3>a]80ool00?oo000:0?oo00030<Rmd0000000
aKkC00D0aKkC00<000000<6gd031]m000P0000050;nhd`030000002k/]40^k;A00D0^k;A1`000004
0;J_d`030000002a[=80/JcB00H0/JcB00<000000:fXd`2]Z=<00P2]Z=<6000000H0Yj;A00<00000
0::Pd`2RX=<0102RX=<200000080XIc@00<0000009ZJd`2JV]<0102JV]<00`000000V9OA0?oo000:
0?oo00T0003o1@3ER7X30?l0000300000000o`000?l000800?l00P3EPg800`000000iI1X0>F@J002
0>F@J08000001@3TRE`01`000000hh5?0>>1C`3SPDl000000>b7<00000000P3UNQ`00`000000g6/5
0=a[1@02000006L0oooo001k0?ooo`@000000P0001L00`000000000/000000030400CP0300000019
2U/0B@YK00@0B@YK00<00000050FIP1@5VH00P1@5VH010000000MSEa07HeL@1f=G43000000L0NSej
0`00o`00103o0000NSej00000000000=0?oo00H0b;g@0P0000030<Fnd`0300000031]m00`KO@00<0
`KO@0`0000020;nhd`030000002k/]40^k;A00L0^k;A00<000000;N]d02g[M000P2g[M0B000000<0
[JG@00<000000:NRd@2WX]401`2WX]400`000000XZ3C0::Pd`03000000D0XIc@00<0000009ZJd`2J
V]<00P2JV]<00`000000V9OA09RGd@0409RGd@030000003oo`00ool000L0ool02@000?l20=F8NP<0
o`001000o`02000000030=F3LP000000iI1X00D0iI1X00<000000>B9G03TRE`00`3TRE`200000080
hh5?00<000000>b7<00000000P3UNQ`010000000g6/50=a[1@00001W0?ooo`00N`3oool300000080
000G00<000000000;00000000P1004h2000000D0B@YK0P000005050FIP040000001f=G4000000000
00L0NSej10000?l3003o00`0ool00P3>a]800`000000b;g@0<Rmd0070<Rmd080000000<0aKkC0000
0031]m001`31]m03000000T0^k;A00<000000;N]d02g[M001P2g[M000`000000/ZW?003o0002003o
00@0/ZW?00<000000:fUd02]YM001P2]YM000`000000Yj;A0:NRd@060:NRd@<000002@2QW=001000
0000VY[C00000000000809RGd@040000002=TM80SI7B08fAdPX0ool01`000?l00`3o00000?l0003o
0002003o00@0eHQj00<000000>F@J03UT6P01@3UT6P2000000D0i8UL0`0000020>b7<0050000003U
NQ`0iGXL0000003LJ`D00P00001V0?ooo`00N03oool00`000000oooo0000000200000080000G00<0
00000000;00002`00`00000604T:F`030000001@5VH0D1IV00D0D1IV0P00000707XmNPH0003o0`00
o`080?oo00D0c/KB00<000000<ZmcP0000002P38_M02000000T0`KO@00<000000;facP0000000P00
00050;^bd@030000002g[M00]jg@00L0]jg@00<000000;:Yc`2bZLl01P2bZLl00`000000[JG@0:fU
d0060:fUd0030000002WX]40Yj;A00<0Yj;A0`0000020:NOcP030000002QW=00XIc@00L0XIc@0P00
000909RGd@030000002FTlh0000000D0SI7B1`3oo`070000o`@00?l01@3ER7X3000000L0iI1X0P00
00050>B9G0050000003/Qc00k8L`0>b7<00000000P3UNQ`00`000000g6/50000001V0?ooo`00M`3o
ool2000000030?ooo`00000000000080000G00D000000000;00002`0000/0000000604T:F`800000
1P1@5VH00`000000Eb5a0000000507XmNPH0003o103oo`000`00o`00ool00?oo00030?oo00<0dLK?
00<000000<k6dP3>a]800P3>a]8010000000b[g>0<ZmcP3:_Lh2000000L0b;g@00<000000<>fc@33
]/d00P0000060<6gd0030000002m/Lh0_K7>00<0_K7>100000000`2k/]4000000;N]d0070;N]d003
0000002bZLl0/ZW?00L0/ZW?00<000000:fUd02]YM001`2]YM000`000000Yj;A00000002000000D0
Yio>00<000000:6Ld02QW=001@2QW=0200000080WiW>00<0000009RGd@2HUm40102HUm42000000<0
UY?>0P00000308fAdP030000002:S=00RXc@00L0ool00P000?l5003o00H0eHQj00<000000>JFLP3V
UW800P0000070>F@J0030000003TRE`0i8UL0080i8UL0P0000030>b7<0030000003UNQ`0iGXL00<0
0000I@3oool007L0oooo1000000200005`040000000002`0000/0000;080000010192U/2000000H0
D1IV0P00000205LQL@030000001j?GX0NSej00L0003o2@3oo`070=76c`050000003>a]80c/KB0<k6
dP0000001@3:_Lh00`000000b;g@0<Rmd0030<Rmd00300000033]/d0`kK=00<0`kK=0P0000040<6g
d0030000002m/Lh0_K7>00L0_K7>1P0000040;N]d0030000002bZLl0/ZW?00L0/ZW?00<000000:fU
d02]YM000`2]YM06000000T0Yio>00<000000:6Ld02QW=000P2QW=02000000@0WiW>00<0000009RG
d@2HUm400`2HUm400`000000UY?>09JCcP0509JCcP030000002=TM80000000L0RXc@1P3oo`03003o
008000001@3ER7X00`000000iYIb0>JFLP020>JFLP8000001P3UT6P2000000<0i8UL0P0000030>b7
<0030000003UNQ`0iGXL00800000I@3oool007H0oooo00@000000?l0003o0000o`000`0001L01P00
0000000/0000;0000000200o000000<0B@YK00<00000050FIP1@5VH0101@5VH2000000<0Eb5a00<0
00000000o`000?l01P000?l80?oo0080dlK=00<000000=76c`3Aa/l01P3Aa/l00`000000c/KB0000
00070<ZmcP0300000038_M00b;g@0080b;g@00<000000<>fc@33]/d01@33]/d2000000030<6gd000
0000_K7>00X0_K7>00<000000;R/c@2h[<d00P2h[<dD000000@0[J?=00<000000:NOcP2WWlh0202W
Wlh00`000000XIc@0:6Ld002000000L0WiW>00D0000009RGd@2HUm40V9OA0000000909JCcP030000
002:S=00RXc@00D0RXc@00<0000008N8c@27R<d02@3oo`02000000@0eHQj00<000000>JFLP3VUW80
0`3VUW800`000000iI1X0>F@J0050>F@J080000000@0i8UL0000003`TT8000000`3/Qc000`000000
iGXL0>Ej7002000006@0oooo001f0?ooo`040000003o0000o`000?l00080000G00H000000000;000
02`0000000P0?`00000204T:F`8000001P1@5VH010000000Eb5a05LQL@1G8G490000o`L0ool000<0
00000=?6c@3Ca/d00`3Ca/d00`000000dLK?0=76c`060=76c`030000003:_Lh0b[g>00L0b[g>0P00
00000`38_M0000000<>fc@090<>fc@<000002@2m/Lh00`000000^:c=0;R/c@070;R/c@030000002b
Yld0/ZO=00L0/ZO=00<000000:fSc@2]Xld0202]Xld00`000000Yio>0:NOcP070:NOcP<000002@2O
VLh010000000V9OA00000000000809JCcP80000000<0U8o;0000002:S=00102:S=000`000000QhS=
08N8c@0408N8c@P0ool00`0000000`3ER7X000000>JFLP050>JFLP8000001`3UT6P3000000030?2B
@P000000k8L`0080k8L`00@000000>Ej7000000000000`3oool00`000000oooo0?ooo`1N0?ooo`00
MP3oool01P000000o`000?l0003o0000000G00000080000/00<0000000P0?`0803l00`000006050F
IP<000002P000?l70?oo00030=_Bc`000000dlK=00H0dlK=0P0000050=76c`040000003<_</00000
000000T0b[g>0P00000:0<>fc@030000002n[l/0_Zo;00<000001P2m/Lh00`000000^:c=0;R/c@07
0;R/c@030000002bYld0/ZO=00L0/ZO=00<000000:fSc@2]Xld0202]Xld00`000000Yio>0:NOcP04
0:NOcP<0000000<0YYc;0000002OVLh02@2OVLh2000000T0UY?>00<0000009B?b`2DSl/00P2DSl/0
0`000000RXc@08Z<d00208Z<d00300000027R<d0QhS=00@0QhS=00<0000008F4bP0000001`3oo`00
0`1bNld00000000000080>JFLP8000001`3UT6P010000000l9920?2B@P0000030>b7<0050000003U
NQ`000000000003oool00P00001P0?ooo`00M`3oool30?l000040000000002`0000/000000<0200o
00<00000050FIP1@5VH0101@5VH20000000305LQL@000?l0003o00L0003o00<0g];<0?oo003oo`00
1@3oo`020=_Bc`030000003FaLX0000000P0dlK=00D000000=76c`3Aa/l0dLK?000000040<blb`03
0000003:_Lh0b[g>00D0b[g>00<000000<Feb`35]L/00P0000080<>fc@030000002n[l/0_Zo;00<0
_Zo;100000000`2m/Lh000000;R/c@090;R/c@030000002bYld0/ZO=00P0/ZO=00<000000:fSc@2]
Xld0202]Xld00`000000Yio>00000003000000D0YYc;00<0000009nIcP2OVLh01@2OVLh200000080
WYK;00<0000009JCcP2FTlh0102FTlh2000000D0U8o;00D0000008Z<d02:S=00RXc@0000000608N8
c@0400000025Q<X0QHC:08F4bP8000001`3oo`000`1bNld00000000000080>JFLP030000003UT6P0
iI1X00@0iI1X0P0000020?2B@P040000003/Qc00k8L`0>b7<0@000000`3o001O0?ooo`00MP3oool0
10000000o`000?l0003o00020000;0040000000803l0200o00P0?`8000001@1@5VH010000000Eb5a
0000000000060000o`8000001`3oo`0010000000fm;?0=_Bc`0000030=K5bP030000003Ca/d0dlK=
00H0dlK=00<000000=76c`0000001P3<_</2000000D0b[g>00<000000<Feb`35]L/00P35]L/30000
00@0`kK=00<000000;j_b`2n[l/0202n[l/7000000D0^:c=00<000000;:Wc@2bYld0202bYld00`00
0000[J?=0:fSc@030:fSc@L000002@2VW</00`000000WiW>09nIcP0209nIcP<000001@2NU//00`00
0000UY?>09JCcP0209JCcP030000002DSl/0U8o;00H0U8o;00<0000008Z<d00000001P27R<d00`00
0000QHC:08F4bP0408F4bP030000001fP=00ool000H0ool000<0KGG90000000000001`3VUW820000
00@0iI1X00<000000?>KDP0000000P3`TT8200000080k8L`0`0000030?l005l0oooo001f0?ooo`06
0000003o0000o`000?l0000002`000000`0803l00`000000501?00000003050FIP80000000@0Eb5a
00000000000000000`000?l2000000030>7Cb@3oo`00ool000D0ool00P3Nd/`00`000000fm;?0000
00050=K5bP030000003Ca/d0dlK=00H0dlK=00<000000<blb`3<_</01`3<_</01@000000b[g>0<Zm
cP3:_Lh0000000P0aKG;0P0000020<>fc@030000002n[l/0_Zo;00T0_Zo;00<000000;VYbP2iZLX0
0`2iZLXF000000D0[J3:00<000000:JLb`2VW</02@2VW</010000000WiW>00000000000909jFb`04
0000002FTlh00000000000X0U8o;00<0000008N8c@27R<d01027R<d00`000000QHC:08F4bP0608F4
bP030000001bNld0LW_=00L0ool000<0KGG90000000000001`3VUW8200000080iI1X00@000000?>K
DP3cVe8000000`3`TT800`000000k8L`0>b7<002000000<0o`0000<000000?ooo`3oool0G03oool0
07D0oooo0P0000030?l000070000000803l0200o00P0?`000000501?00000002050FIP8000001`1G
8G42000000030>7Cb@3oo`00ool000D0ool01@3Nd/`00`000000e/G:0=K5bP050=K5bP030000003C
a/d0dlK=00@0dlK=00@000000<jkb00000000000203<_</2000000030<ZmcP000000aKG;00T0aKG;
0`00000:0;j_b`030000002iZLX0^JW:00T0^JW:00<000000;>TbP2cY<X0202cY<X00`000000[J3:
0:fPbP080:fPbP030000002VW</0YYc;00P0YYc;0`00000<09jFb`030000002DSl/0U8o;00P0U8o;
0P0000000`2BRlP0000008N8c@0408N8c@0300000025Q<X0QHC:00D0QHC:00<00000089oa`000000
0`1bNld70?oo000306eeb@000000iYIb00L0iYIb0`0000030?>KDP060000003`TT80l9920?2B@P00
0000k8L`0P0000030?l005l0oooo001e0?ooo`050000003o0000o`000?l0000000000`0803l00`00
0000501?01@0C`03000000P0Eb5a00<000000>CCaP3oo`001P3oo`000`000000g];<0=kBc0030=kB
c0030000003HaLL0000000L0e/G:00<000000=?6c@3Ca/d00P3Ca/d00`000000c[_80<jkb0020<jk
b0030000003<_</0c;c;00L0c;c;0P00000;0<Feb`030000002o[/P0000000<000001P2n[l/00`00
0000^JW:0;VYbP090;VYbP030000002cY<X0/jC:00P0/jC:00<000000:fPbP2]X<X02@2]X<X00`00
0000YYc;0:JLb`030:JLb`@000000P2VVLP00`000000WYK;09jFb`0709jFb`8000000P2MT/P00`00
0000U8o;09B?b`0509B?b`800000102BRlP01@000000QhS=08N8c@27R<d0000000L0QHC:00D00000
089oa`22OlL0PWo700000002079kc@030000001]MLT0ool000H0ool00P0000080>JFLP030000003c
Ve80li]B0080li]B00L000000?2B@P3`TT80l9920000003/Qc00000000<0o`00G`3oool007@0oooo
0P0000030?l000<0200o00D0000001@0C`0D04l0501?0000000805LQL@8000001`3oo`020>7Cb@03
0000003Nd/`0g];<0080g];<00D000000=S5a`3HaLL0f<G7000000070=K5bP050000003Ca/d0dlK=
0=?6c@0000001@3>^lP00`000000c;c;0<blb`050<blb`0300000036/lP0a[?800<000001`35]L/0
0`000000_jk80;n^b0040;n^b0@0000000<0_Zo;0000002iZLX02P2iZLX00`000000/jC:0;>TbP09
0;>TbP030000002]X<X0[J3:00T0[J3:00<000000:JLb`0000000`0000060:JIb0030000002NU//0
WYK;00D0WYK;0P00000409fBb0030000002DSl/0U8o;00@0U8o;00<0000009:;b02BRlP01@2BRlP0
0`000000QhS=0000000708F4bP0300000022OlL0PWo70080PWo700@00000079kc@1bNld000000`1]
MLT70?oo008000001P3VUW82000000@0li]B00@000000?2B@P3`TT80l9920P0000030?l005l0oooo
001d0?ooo`8000000`3o000200P0?`040000000D04l0501?01@0C`8000001P1G8G42000000L0ool0
1@3QdlT01@000000g];<0=kBc00000000?l000@0f<G700<000000=K5bP3FaLX01@3FaLX00`000000
dlK=000000070<jkb08000001@3<_</00`000000a[?80<Jcb0030<Jcb08000001@35]L/00`000000
_jk80;n^b0080;n^b0@000002@2iZLX00`000000/jC:0;>TbP090;>TbP030000002]X<X0[J3:00L0
[J3:1000000;0:JIb0030000002NU//0WYK;0080WYK;0P00000709fBb0040000002DSl/0U8o;09B?
b`8000002@2BRlP00`000000QHC:08F4bP0508F4bP0300000022OlL0PWo700<0PWo700<00?l00000
000000001P1]MLT60?oo008000001@3VUW800`000000m:=P000000040?>KDP050000003`TT80l992
0?2B@P0000000`3o001O0?ooo`00F`3oool3000000<00?l04P3oool3000000<0o`0000<0200o0000
000D04l00P0D04l00`000000801N0000000505LQL@030000003oo`00ool000D0ool000<0i=?60000
003QdlT0103QdlT00`000000g];<00000002003o00D0f<G700<000000=K5bP3FaLX01@3FaLX00`00
0000c[_80<jkb0080<jkb0050000003<_</0c;c;0<blb`0000002036/lP3000000030<Feb`000000
_jk800/0_jk800<000000;VWa`2iYlL01P0000030;VYbP030000002cY<X0/jC:00T0/jC:00@00000
0:fPbP2]X<X0[J3:1P0000020:fMa`030000002VVLP0YYW800X0YYW800<0000009jFb`2NU//00P00
000909fBb0040000002DSl/00000000000T0TX_80P0000000`2AQlH0000008F4bP0408F4bP030000
0022OlL0PWo700@0PWo70P00o`000`000000KGG906eeb@0306eeb@030000001XKlH0J6o600H0ool0
0P0000030>JFLP040000003dXf000000000000@0li]B00D000000?2B@P3`TT80l992000000030?l0
05h0oooo001L0?ooo`8000001P00o`0?0?ooo`<000000`3o00001`000000501?01@0C`0D04l00000
0200GP000000101G8G42000000H0ool0103TdlH00`000000hM?90>7Cb@030>7Cb@030000003HaLL0
f<G700H0f<G700<000000=K5bP3FaLX0103FaLX010000000d;_50000000000090<jkb080000000<0
c;c;00000036/lP02P36/lP3000000/0_jk800<000000;VWa`2iYlL01P2iYlLC000000T0[Ig700<0
00000:JIb02VVLP02@2VVLP3000000`0WI;800<0000009:;b02BRlP0202BRlP01@000000THO60967
aP2AQlH0000000@0QHC:00<00000089oa`22OlL01P22OlL00`000000Og[40000000406eeb@030000
001XKlH0J6o60080J6o61P3oo`0200000080iYIb1@0000030?>KDP040000003`TT80l992000000<0
o`00GP3oool005d0oooo00<00000003o0000o`001`00o`0;0?ooo`@000000`3o000301@0C`040000
000P05h0801N00000080Eb5a0P0000060?oo00030000003TdlH0i=?600@0i=?600L000000>7Cb@3Q
dlT0hM?90000003KaL@0000000P0f<G700<000000=K5bP3FaLX00P3FaLX00`000000d;_50=2ka@02
0=2ka@030000003>^lP0c[_800P0c[_80P00000;0<Jcb00300000030[<H0`:c600<000001`2o[/P0
0`000000^JO70;VWa`0:0;VWa`030000002cX/L0/j;700T0/j;700<000000:fMa`2]WLL02P2]WLL0
0`000000YYW80:JIb0050:JIb0@0000000<0YIK60000002MT/P02@2MT/P200000080W8o500<00000
09:;b02BRlP01@2BRlP2000000D0THO600@0000008F4bP25Q<X000002022OlL01@000000Og[407mj
a01oN/@000000080KGG900<0000006Q_aP1XKlH00`1XKlH00`000000ool00?oo00040?oo00T00000
0`3cVe800`000000l992000000030?l005h0oooo001I0?ooo`L000002P00o`080?ooo`@000000`3o
000201@0C`040000000P05h0801N0200GP<0000000<0l>K20?oo003oo`000`3oo`030>OC`P030000
003TdlH0i=?600@0i=?600<000000>7Cb@0000000`3KaL@2000000L0f<G700D000000=K5bP3FaLX0
e/G:000000050=2ka@030000003>^lP0c[_800H0c[_800<000000<Rba@38//D00P0000090<Jcb003
00000030[<H0`:c600<0`:c60`0000040;n^b0030000002iYlL0^JO700X0^JO700<000000;>Ra`2c
X/L02@2cX/L00`000000[Ig70:fMa`0;0:fMa`030000002VVLP0YYW800@000001P2UU/H00`000000
WI;809fBb00509fBb0800000102LSlD00`000000TX_809:;b00309:;b08000001`2AQlH00`000000
QHC:00000008089oa`030000001oN/@0Og[400<0Og[400<0000006eeb@0000001@1XKlH00`000000
I6W306AY``050?oo00080000000nE/8000000?BSH0000000003B000000000?l40?>KDP030000003`
TT80o`000080o`0000<000000?ooo`3oool0F`3oool005X0oooo10000004003o00030?ooo`00o`00
0?l000L00?l01@3oool40000000600P0?`3o0000o`000?l0000D04l00000100P05h2000000H0ool0
103Wdl800`000000i=?60>CCaP040>CCaP030000003QdlT0000000D0flG400<000000=S5a`3HaLL0
1@3HaLL00`000000e/G:000000070=2ka@8000001@3>^lP00`000000b;;50<Rba@030<Rba@800000
1P36/lP00`000000`:c60<2/aP070<2/aP<0000000<0_jk80000002iYlL02`2iYlL00`000000/j;7
0;>Ra`0:0;>Ra`030000002]WLL0[Ig700L0[Ig71P00000:0:FFaP030000002MT/P0WI;80080WI;8
0`00000709b?a@050000002BRlP0TX_809:;b00000002P2AQlH00`000000PWo7089oa`06089oa`03
0000001oN/@0Og[400D0Og[400<0000006Q_aP1XKlH00`1XKlH00`000000I6W306AY``0306AY``D0
ool000@0?UK2000000000?l000000P000?l2000000<0li]B00D000000?l0003o0000o`000000000@
0?ooo`<00?l00`0000170?ooo`00G03oool2000000L00?l000<0oooo003o0000o`001`00o`020?oo
o`D000000`3o00000`000000801N0200GP020200GP030000003ci[`0ool000@0ool000<0j]>n0000
003Wdl80103Wdl800`000000i=?60>CCaP040>CCaP030000003KaL@0flG400D0flG400<000000=S5
a`3HaLL01@3HaLL00`000000d;_50=2ka@080=2ka@030000003>^lP0c[_80080c[_800<000000<Rb
a@38//D01@38//D2000000@0a[?800<000000<2/aP30[<H02P30[<H8000000H0^JO700<000000;>R
a`2cX/L02P2cX/L010000000[Ig70:fMa`2]WLL6000000<0[I_500<000000:FFaP2UU/H02`2UU/H0
10000000WI;800000000000:09b?a@040000002BRlP00000000000T0THO60P0000000`2?Q<<00000
089oa`05089oa`030000001oN/@0Og[400D0Og[400<0000007af`@000000101XKlH00`000000I6W3
06AY``0306AY``030000003oo`00ool000<0ool000<0=4bl000000000?l00`000?l00`3dXf000000
0?>KDP020?>KDP<0o`0000<000000?ooo`3oool02`3oool6003o00800000B03oool005h0oooo2P00
o`000`3oool00?l0003o0006003o0080000000<000070000003o00000P3o00000`0D04l000000200
GP020200GP030000003ci[`0ool000@0ool00`3Zdkh00`000000im?20>OC`P020>OC`P030000003T
dlH0i=?600<0i=?600<000000=g4`@0000001`3KaL@00`000000f<G70=S5a`030=S5a`040000003A
^/<00000000000T0d;_50P0000000`3>^lP000000<Rba@090<Rba@80000000<0a[?800000030[<H0
3@30[<H00`000000^ZK40;ZVa0040;ZVa1L000002@2]VlD00`000000YIK60:FFaP0:0:FFaP<00000
3@2LSlD00`000000THO60967aP080967aP030000002?Q<<0ShC30080ShC300<00000089oa`22OlL0
0P22OlL00`000000Og[407mja00507mja0040000001lM/40O7K1000000<0J6o600<0000006AY``1T
JL<0101TJL<00`000000GV:n0?oo00050?oo0003000000000?l0003o0080003o00@0m:=P0000003c
Ve80li]B0`3o0002000000T0oooo2@00o`000`000000oooo0?ooo`170?ooo`00H@3oool?003o00D0
00000`3o000010000000801N0200GP0P05h2000000@0ool000<000000>[C_P3Zdkh00P3Zdkh00`00
0000im?20>OC`P030>OC`P050000003TdlH0i=?60>CCaP0000000`3Ma<400`000000flG40=_5a005
0=_5a08000000P3HaLL00`000000dK[30=6j``020=6j``030000003@^lD0d;_500P0d;_50P00000<
0<Rba@@000002`30[<H00`000000^ZK40;ZVa00;0;ZVa0030000002cX<@0/j3400X0/j3400<00000
0:fKa@2]VlD02P2]VlD00`000000YIK60:FFaP070:FFaP<000000P2UTl<00`000000W8o509b?a@08
09b?a@8000000P2KS<<00`000000THO60967aP050967aP8000001@2?Q<<01@000000PWo7089oa`22
OlL0000000L0Og[400<0000007af`@1lM/400P1lM/400`000000J6o60000000606AY``030000001N
H[h0GV:n0080GV:n103oo`000`0dC;`000000000o`030000o`030?BSH0000000li]B00<0o`000P00
00060?ooo`X00?l000@000000?ooo`3oool0oooo1`0000110?ooo`00I03oool<003o0080000000<0
00070000000000000`3o00030200GP030000003oo`00ool000<0ool000<000000>[C_P3Zdkh0103Z
dkh00`000000im?20>OC`P030>OC`P040000003TdlH0i=?6000000@0gLC100<000000=_5a03KaL@0
1P3KaL@00`000000f<G7000000050=6j``8000001`3@^lD00`000000bK720<Va`P02000000/0b;;5
00<000000<6[``31Zl<0100000070<2/aP030000002jY/@0^ZK400/0^ZK400<000000;>Pa02cX<@0
2P2cX<@00`000000[I_50:fKa@0;0:fKa@030000002UU/H0YIK60080YIK6100000050:FC``030000
002LSlD0W8o500H0W8o50P00000409^<``030000002AQlH0THO600<0THO60P00000808n4``030000
0022OlL0000000L0Og[400<0000007af`@1lM/400`1lM/400`000000J6o60000000506AY``030000
001NH[h0GV:n00<0GV:n00<000000?oo003oo`000P3oo`02000000@0003o00<0m:=P0000003o0000
0P3o00000`3SR`d00000000000030?ooo`T00?l01@3oool4003o00@00000@P3oool006L0oooo2P00
o`030000000401@0C`3o0000o`000?l00080801N00<000000?oo003oo`000`3oo`000`000000k=>j
000000050>[C_P030000003Wdl80im?200<0im?200<000000>CCaP0000001P3Ma<400`000000flG4
0=_5a0060=_5a0030000003A^/<0dK[300H0dK[30P0000050=2ka@0300000039/L80bK720080bK72
0`0000070<Rba@0300000031Zl<0`J_300D0`J_3100000020<2/aP030000002jY/@0^ZK400/0^ZK4
00<000000;>Pa02cX<@02`2cX<@00`000000[I_50:fKa@0;0:fKa@030000002UU/H0000000800000
2P2UTl<00`000000W8o509b?a@0209b?a@<000001`2KS<<01@000000THO60967aP2AQlH0000000/0
ShC300<0000007mja01oN/@01@1oN/@00`000000O7K107af`@0507af`@030000001TJL<0I6W300@0
I6W300<0000005iR_P1NH[h00`1NH[h00`000000FE^j0?oo00030?oo000302Y1]P000000003o0080
003o0P3dXf030?l000030>>;3@000000000000T00?l01@3oool7003o00<00000@`3oool006X0oooo
2P00o`001P0D04l0o`000?l0003o0000801N000000D0ool000@0lnJl0000003/dkX000001P3Zdkh0
0`000000im?20>OC`P030>OC`P030000003Ma<40gLC100H0gLC100<000000=_5a03KaL@0103KaL@0
10000000dkW00000000000080=6j``050000003@^lD0d;_50=2ka@0000002039/L83000000@0b;;5
00<000000<6[``31Zl<02@31Zl<6000000X0^ZK400<000000;>Pa02cX<@02`2cX<@00`000000[I_5
0:fKa@080:fKa@D000003@2UTl<00`000000W8o509b?a@02000000X0Vhc300@000000967aP000000
00002P2?Q<<20000000308f0`0000000Og[400@0Og[400<0000007af`@1lM/401@1lM/400`000000
NG6n0000000406AY``030000001NH[h0GV:n00<0GV:n00@0000005UK^P1IFkX0FE^j103oo`000`0Z
@KH000000000o`020000o`070?BSH03o0000o`000?l000000000hh/=00000006003o00D0oooo2P00
o`000`000000oooo0?ooo`130?ooo`00K@3oool:003o00030?l000000000ool000<0ool000<0m^Jf
0000000000000`3/dkX00`000000j]>n0>[C_P040>[C_P070000003Wdl80im?20>OC`P000000glBm
000000080=g4`@030000003KaL@0flG40080flG400<000000=>i`03C^L000P3C^L000`000000dK[3
0=6j``060=6j``80000000<0d;_500000039/L802P39/L82000000030<Rba@000000`J_300d0`J_3
00@000000;^T`P2kY<80^jC21`0000030;ZVa0030000002cX<@0/j3400/0/j3400@000000:fKa@2]
VlD0[I_51`0000030:bH`P030000002UTl<0YI?300`0YI?30`00000=09^<``030000002?Q<<0ShC3
00P0ShC30P00000308f0`0030000001oN/@0Og[40080Og[400<0000007af`@1lM/401@1lM/401@00
0000NG6n07Ua_P1iLKh0000000<0I6W300<0000005iR_P1NH[h00`1NH[h01@000000FE^j05UK^P1I
FkX0000000@0ool000<000000000o`000?l00P000?l30?l000040000003SR`d00000000000<00?l0
0`3oool;003o0080oooo00<000000?ooo`3oool0A03oool006l0oooo00<00000003o0000o`001@00
o`000`3o0000ool00?oo00020?oo0080m^Jf0P0000030>cC^P030000003Zdkh0j]>n00@0j]>n00D0
00000>OC`P3Wdl80im?2000000020=o4_@030000003Ma<40gLC100H0gLC100D000000=_5a03KaL@0
flG4000000050=>i`0800000203A^/<2000000d0bK721000000<0<6[``030000002kY<80^jC200P0
^jC25@00000;0:bH`P030000002UTl<0YI?300L0YI?3100000000`2TT<00000009^<``0:09^<``80
00000P2JR<000`000000ShC308n4``0608n4``030000002=P<00SH3000@0SH3000@0000007mja01o
N/@000001`1lM/400`000000NG6n07Ua_P0207Ua_P040000001TJL<0I6W3000000D0GV:n00<00000
05UK^P1IFkX00`1IFkX00`000000ool00?oo00020?oo000301lf[`000?l0003o0080003o0P3o0000
103]VR@000000>>;3@0000030?ooo`/00?l0C03oool006h0oooo0`0000000`0001l00000003o0004
003o00<0ool00`3fi[H00`000000k=>j0>cC^P030>cC^P030000003Zdkh0j]>n00@0j]>n00<00000
0>OC`P000000103Oa;d00`000000gLC10=g4`@060=g4`@030000003KaL@0000000P0dkW000<00000
0=6j``3A^/<01@3A^/<00`000000b[2o00000002000000/0bK7200<000000<:Y`032ZL0010000007
0<6[``030000002kY<80^jC200`0^jC200<000000;BM`@2dWL402`2dWL400`000000[9S20:bH`P0<
0:bH`P030000002UTl<0YI?300@0YI?30`0000060:B@`0030000002KS<<0Vhc300H0Vhc30P000004
09Z8`0030000002?Q<<0ShC300@0ShC30P00000708f0`0030000001oN/@0000000L0O7K100<00000
07Ua_P1iLKh0101iLKh00`000000I6W30000000405iR_P030000001IFkX0FE^j00<0FE^j00<00000
05=D]@000000103oo`000`0O=Zl0003o0000o`020000o`050?l000000000kIXT0000003SR`d02`00
o`1?0?ooo`00KP3oool200000080000O00<000000000o`000?l00`00o`020?oo00060000003fi[H0
m^Jf0000003_d[D00000103/dkX00`000000j]>n0>[C_P040>[C_P030000003Wdl80000000D0glBm
00<000000=g4`@3Ma<401P3Ma<400`000000dkW00=>i`0080=>i`0800000103A^/<00`000000b[2o
0<Z`_`030<Z`_`8000002039/L800`000000`ZW00<:Y`0050<:Y`0D000000P31Zl<00`000000^jC2
0;^T`P0<0;^T`P030000002dWL40]9g100/0]9g100<000000:bH`P2/V<803@2/V<800`000000YI?3
00000003000000T0Y93000<0000009^<``2KS<<0102KS<<2000000L0VXS000@0000008n4``2?Q<<0
ShC30P00000:08f0`0030000001lM/40O7K100D0O7K100<0000007Ua_P1iLKh01P1iLKh00`000000
GV:n05iR_P0305iR_P030000001IFkX0FE^j00<0FE^j00@0000005=D]@000000:T6f103oo`040000
o`80o`002P00o`1C0?ooo`00KP3oool20000000300007`000000003o0080003o00H0ool0003o003o
o`00ool00?WV[`0000020?KV]P030000003_d[D0000000D0k=>j00<000000>[C_P3Zdkh0103Zdkh0
0`000000glBm0=o4_@050=o4_@8000001@3Ma<4010000000eKRm00000000000:0=>i`0050000003A
^/<0dK[30=6j``0000001`3:/;l3000000D0bK7200<000000<:Y`032ZL002P32ZL06000000/0^jC2
00<000000;BM`@2dWL40302dWL400`000000[9S20:bH`P090:bH`PD000003@2TT<000`000000Vhc3
09^<``0209^<``8000002@2JR<0010000000ShC300000000000:08f0`080000000<0Rgbm0000001l
M/40101lM/400`000000NG6n07Ua_P0607Ua_P030000001fK;X0000000<0GV:n00<0000005UK^P1I
FkX00`1IFkX010000000DeBe05=D]@1CE;D2000000@0ool00P000?l:003o05H0oooo001^0?ooo`03
0000000001l0000O00@0003o0`3oo`020?WV[`030000003fi[H0000000<0km:e00<000000>cC^P3/
dkX00`3/dkX00`000000j]>n0>[C_P020>[C_P030000003Q`kX0000000P0glBm00<000000=g4`@3M
a<400P3Ma<4010000000eKRm0=Fh_@3E^;d2000000T0dkW00`00000;0<Z`_`<0000000<0bK720000
0032ZL003P32ZL0010000000^j:o0;^R_`2kX[l8000000<0^jC200<000000;BM`@2dWL40302dWL40
10000000[9S20:bH`P2/V<88000000<0[9Jo00<000000:B@`02TT<003@2TT<0010000000Vhc30000
0000000<09Z8`0030000002=P<00SH3000T0SH3000D0000008]l_@2;O;d0Rgbm0000000407af`@03
0000001iLKh0NG6n00H0NG6n00@0000007I/^P1fK;X000000`1NH[h00`000000FE^j05UK^P0305UK
^P040000001CE;D0DeBe05=D]@80000000<07cJ_0?oo003oo`000P3oo`000`000?l00?l0003o0005
003o05T0oooo001]0?ooo`80000000<0000O0000o`000?l00P000?l40?oo00<0nNJ_0P0000030>oB
]@030000003/dkX0k=>j00<0k=>j00D000000>[C_P3Zdkh0j]>n000000030>73^P030000003Oa;d0
glBm00H0glBm00@000000=g4`@3Ma<4000001P3E^;d00`000000dkW00=>i`0080=>i`08000003@3:
/;l3000000h0`ZW000<000000;^R_`2kX[l02@2kX[lF000000/0[9Jo00<000000:B@`02TT<00302T
T<03000000/0VXS00P0000000`2IQKd0000008f0`00808f0`08000001@2;O;d010000000O7K107af
`@00000807Ua_P030000001fK;X0MVbj0080MVbj00<0000005iR_P0000001@1IFkX00`000000DeBe
05=D]@0305=D]@030000000O=Zl07cJ_00@0ool01000o`0010000000kIXT00000000001H0?ooo`00
K@3oool00`000000000O0000o`030000o`@0ool000D000000?WV[`3iiZl0nNJ_000000050>oB]@03
0000003/dkX0k=>j00<0k=>j00@000000>[C_P3Zdkh00000103Q`kX00`000000glBm0=o4_@060=o4
_@030000003Ma<40000000L0eKRm0P0000070=>i`0030000003<[kd0c:nm00800000303:/;l00`00
0000`jNm00000003000000T0`ZW000<000000;^R_`2kX[l03@2kX[l00`000000]9^o0;BK_`0<0;BK
_`030000002/U[l0[9Jo00`0[9Jo00<000000:B@`02TT<00202TT<04000000030:>>_P000000VXS0
00T0VXS00P00000409V5_@030000002=P<00SH3000D0SH3000<0000008]l_@2;O;d01@2;O;d00`00
0000O7K10000000807Ua_P030000001fK;X0MVbj00<0MVbj00<0000005iR_P000000101IFkX00`00
0000DeBe05=D]@0305=D]@030000001=C;00000000807cJ_103oo`0010000?l000000?BW>@000002
0>fJ90030000003oool0oooo05H0oooo001/0?ooo`80000010000?l40?oo00070?_UY`000000nNJ_
0?WV[`000000lM:`000000040>oB]@030000003/dkX0k=>j00<0k=>j00<000000>[C_P0000001P3Q
`kX00`000000glBm0=o4_@060=o4_@030000003E^;d0eKRm00P0eKRm00<000000=>i`03C^L00103C
^L000`000000c:nm0<b__@020<b__@8000002@3:/;l00`000000`jNm0<>W_@040<>W_@@000001@32
ZL000`000000^j:o0;^R_`0=0;^R_`030000002dVkl0]9^o00`0]9^o00<000000:bF_`2/U[l03@2/
U[l00`000000Y9300:B@`0030:B@`0@000001@2SS[h00`00o`00000009Z8`00509Z8`0<000001P2I
QKd00`000000SH3008f0`00308f0`08000002@2;O;d00`000000NG6n07Ua_P0507Ua_P8000001`1f
K;X00`000000FE^j05UK^P0305UK^P030000001CE;D0DeBe00<0DeBe00<0000004e</00000000P0O
=Zl00`000000ool00?oo00020?oo000600LKW@000000m:Li0000003]VR@00000F03oool006`0oooo
00<000000000o`000?l00P000?l0103mhih0ool00?oo003oo`020?_UY`060000003iiZl0nNJ_0000
003ad[0000001@3_d[D00`000000k=>j0>cC^P030>cC^P030000003Q`kX0hL>j00H0hL>j00<00000
0=o4_@3Oa;d0103Oa;d010000000e[Nj0000000000090=Fh_@8000000`3C^L000`000000c:nm0<b_
_@050<b__@<000001P3:/;l00`000000`jNm0<>W_@080<>W_@@0000000<0`ZW00000002kX[l03@2k
X[l00`000000]9^o0;BK_`0=0;BK_`030000002/U[l0[9Jo00d0[9Jo00<000000:B@`00000000`00
000:0:>>_P030000002JR<00VXS00080VXS00P00000:09V5_@050000002=P<00SH3008f0`0000000
2@2;O;d20000000308Uh^P000000NG6n00@0NG6n00<0000007I/^P1fK;X01P1fK;X00`000000LVNg
0000000305UK^P030000001CE;D0DeBe00<0DeBe00@0000004e</01=C;00CDb`0P00000201<YYP@0
ool000D000000?BW>@000000kIXT0000001H0?ooo`00K03oool40000o`030000003oo`00ool00080
ool00P3kiJL00`000000nNJ_000000030?7B/0030000003_d[D0km:e00<0km:e00L000000>cC^P3/
dkX0k=>j0000003S`[H0000000P0hL>j00<000000=o4_@3Oa;d00`3Oa;d01@000000e[Nj0=Jg^P3F
]kX0000000X0eKRm0P0000000`3C^L0000000<b__@090<b__@800000103:/;l00`000000`jNm0<>W
_@0<0<>W_@D000002`2kX[l00`000000]9^o0;BK_`0>0;BK_`030000002/U[l0[9Jo00T0[9Jo1@00
000?0:>>_P040000002JR<000000000000`0VHFm00@0000008f0`000000000002@2;O;d01@000000
RGRj08Uh^P29N;X0000000@0NG6n00<0000007I/^P1fK;X01P1fK;X010000000LVNg079W]`000003
05UK^P030000001CE;D0DeBe00<0DeBe00@0000004e</01=C;00CDb`0P00000301<YYP@0ool000@0
00000?BW>@0000000000F03oool006/0oooo10000?l00`000000o^2C0?oo00020?oo00040000003k
iJL0nnFW0?_UY`800000103ad[000`000000km:e0>oB]@020>oB]@050000003/dkX0k=>j0>cC^P00
00000P3S`[H00`000000hL>j0>73^P060>73^P050000003Oa;d0glBm0=o4_@0000001@3F]kX20000
00X0eKRm0P00000<0<b__@80000000<0b[2o00000033Ykd03`33Ykd010000000_:2l0;bP_02lX;`8
000000<0^j:o00<000000;BK_`2dVkl03P2dVkl010000000[9Jo0:bF_`2/U[l8000000<0[9>l00<0
00000:>>_P2SS[h03@2SS[h3000000l0VHFm00<0000008]l_@2;O;d01`2;O;d2000000D0RGRj00@0
000007Ua_P1iLKh00000201fK;X00`000000LVNg079W]`02079W]`030000001IFkX0000000D0DeBe
00<0000004e</01=C;000`1=C;001@0000004bVV01<YYP0C:JH0000000<0ool000@000000?BW>@00
00000000F03oool006X0oooo00H000000000o`000?l0003o0000=00000040?oo00050000003kiJL0
nnFW0?_UY`0000001@3ad[000`000000km:e0>oB]@030>oB]@030000003/dkX0000000@0hl:f00<0
00000>73^P3Q`kX01P3Q`kX010000000glBm0=o4_@0000070=Jg^P030000003E^;d0eKRm00H0eKRm
00<000000<f]^P3=[KX00P00000<0<b__@<000003P33Ykd00`000000_:2l0;bP_00:0;bP_1P00000
302/Tk`00`000000Xhjn0:>>_P080:>>_P@0000000<0Xh^k0000002IQKd0302IQKd200000080Uh:j
00<0000008]l_@2;O;d01@2;O;d00`000000RGRj08Uh^P0508Uh^P030000001iLKh0000000P0MVbj
00<00000079W]`1bIkL00`1bIkL00`000000FE^j0000000405=D]@030000001=C;00CDb`00<0CDb`
00<0000004M4Z`0000000P0C:JH01`000000ool00?oo003oo`0000fB0000003dYcT00P00001G0?oo
o`00J@3oool00`000000003o0000o`020000o`030000003nh9<0ool00080ool000L0oN>N0000003k
iJL0nnFW0000003ddJ/0000000D0lM:`00<000000>oB]@3_d[D00P3_d[D00`000000k=>j00000005
0>?2]P030000003Q`kX0hL>j00H0hL>j0P0000090=Jg^P030000003E^;d0eKRm00D0eKRm00<00000
0<f]^P3=[KX00P3=[KX3000000X0c:nm00<000000<BV^`0000000`00000:0<>W_@030000002lX;`0
_:2l00d0_:2l00<000000;BI_02dVK`03P2dVK`00`000000[9>l0:bC_00=0:bC_0030000002SS[h0
Xhjn00@0Xhjn100000060:>;^`030000002IQKd0VHFm00L0VHFm0`00000409N2^P030000002;O;d0
Rgbm00<0Rgbm0P00000908Uh^P030000001fK;X0MVbj00D0MVbj0P000007079W]`030000001CE;D0
DeBe00<0DeBe00<0000004e</01=C;000`1=C;000`000000AdB[0000000201<YYP030000003oo`00
ool00080ool000@000fB0000003dYcT00000E`3oool006T0oooo00H000000000o`000?l0003o0000
=00000040?oo00070?gSWP000000nnFW0?_UY`000000m=6[000000060?7B/0030000003_d[D0km:e
0080km:e00<000000>?2]P3S`[H01@3S`[H2000000L0hL>j00<000000=Jg^P3F]kX0203F]kX20000
00@0eKRm00<000000<f]^P3=[KX01P3=[KX2000000L0c:nm00<000000<BV^`34Y[/01034Y[/40000
00H0`jNm00<000000;bP_02lX;`03@2lX;`00`000000]9Vl0;BI_0020;BI_003003o002dVK`0]9Vl
00T0]9Vl00<000000:bC_02/Tk`03P2/Tk`00`000000Xhjn00000003000000X0Xh^k00<0000009V5
_@2IQKd01@2IQKd2000000P0Uh:j00D0000008]l_@2;O;d0Rgbm0000000908Uh^P80000000<0QgBg
0000001fK;X0101fK;X00`000000LVNg079W]`06079W]`030000001_HK<0000000<0DeBe00<00000
04e</01=C;000`1=C;0010000000AdB[04M4Z`17A:/2000000801a^M0`3oo`0010003I8000000?BW
>@00001G0?ooo`00J03oool010000000003o0000o`000?l2000000040?kLQ`3oo`00ool00?oo00<0
oN>N0P0000030?CAZ`030000003ad[00lM:`00<0lM:`00<000000>oB]@3_d[D00P3_d[D2000000P0
hl:f00<000000>73^P3Q`kX00`3Q`kX010000000f;Jg00000000000:0=Jg^P050000003E^;d0eKRm
0=Fh_@0000002P3=[KX3000000@0c:nm00<000000<BV^`34Y[/02034Y[/4000000030<>W_@000000
_:2l00l0_:2l00<000000;BI_02dVK`00P2dVK`3003o00T0]9Vl00<000000:bC_02/Tk`0302/Tk`4
000000h0Xh^k00<0000009V5_@2IQKd00P2IQKd3000000X0Uh:j00@0000008]l_@00000000002029
N;X2000000<0QgBg00<0000007I/^P1fK;X00P1fK;X00`000000LVNg079W]`06079W]`040000001_
HK<0Kf6c000000<0DeBe00<0000004e</01=C;000P1=C;000`000000AdB[04M4Z`0204M4Z`800000
0P076id40?oo00030000Q@000000000005L0oooo001X0?ooo`06000000000?l0003o0000o`0003@0
0000103oo`000`000000oN>N0?gSWP02000000@0m=6[00<000000?7B/03ad[000`3ad[0010000000
km:e0>oB]@0000020>G1/P030000003S`[H0hl:f00H0hl:f00<000000>73^P3Q`kX00P3Q`kX01000
0000f;Jg0=Rf]`3H][L2000000T0e[Nj0`00000>0<f]^P80000000<0c:nm00000034Y[/03P34Y[/6
000000`0_:2l00<000000;BI_02dVK`03P2dVK`00`000000[9>l0:bC_0060:bC_0H000000P2/TKX0
0`000000Xh^k0:>;^`0>0:>;^`040000002IQKd00000000000d0Uh:j0P00000908Uh^P0300000027
M;L0QgBg00@0QgBg00@0000007I/^P1fK;X00000201bIkL00`000000Kf6c06mQ/`0206mQ/`030000
001CE;D0000000D0CDb`00<0000004M4Z`17A:/00`17A:/0100000001a^M00LKW@0000030?oo0003
0000Q@000000000005L0oooo001X0?ooo`80000000@0003o000000000000o]b70`3oo`001@3nh9<0
00000?gSWP3mhih0000000D0m=6[00<000000?7B/03ad[00103ad[000`000000km:e000000030>G1
/P8000001`3S`[H010000000hL>j0>73^P0000060=Rf]`8000002@3F]kX2000000l0cJfj0`00000?
0<BV^`030000002lW[X0_9jj0080_9jj200000040;bP_0030000002dVK`0]9Vl00h0]9Vl00<00000
0:bC_02/Tk`01P0000080:bA^P030000002SRk/0Xh^k00d0Xh^k0P00000>09N2^P80000000<0UWjg
00000029N;X01P29N;X2000000L0QgBg00<0000007I/^P000000201bIkL00`000000Kf6c06mQ/`03
06mQ/`030000001CE;D0000000@0CDb`00<0000004M4Z`17A:/00`17A:/2000000801a^M00H00000
0?oo003oo`00ool00000Q@3o0002000005H0oooo001Z0?ooo`040?l00000000000000?kLQ`<0ool0
00@0o^2C0000003mhih0oN>N0P0000050?CAZ`030000003ad[00lM:`00<0lM:`0P0000060>G1/P03
0000003S`[H0hl:f00D0hl:f00<000000>73^P000000203H][L00`000000e[Nj0=Jg^P060=Jg^P04
0000003>[;L00000000000h0cJfj00<000000<FT^00000000`00000;0<BV^`030000002lW[X0_9jj
00X0_9jj6000000>0:bA^P030000002SRk/0Xh^k00T0Xh^k100000000`2RR;P0000009N2^P0:09N2
^P<00000102FO[L00`000000RGRj08Uh^P0308Uh^P0300000027M;L0QgBg00P0QgBg00<00000079W
]`1bIkL01@1bIkL2000000L0Kf6c00<0000004e</01=C;000P1=C;000`000000AdB[04M4Z`0404M4
Z`050000000o>j@0000000LKW@000000103oo`000`3o000000000000001F0?ooo`00JP3oool00`3o
000000000?l000040?oo00060?kPT`000000oN>N0000003fcj@000001P3ddJ/00`000000lM:`0?7B
/0030?7B/0030000003U`K80iL6b00D0iL6b00<000000>?2]P3S`[H01@3S`[H00`000000f;Jg0=Rf
]`080=Rf]`8000001@3F]kX00`000000cZbg0<j/]`020<j/]`<000002P3=[KX00`000000aJBh0<FT
^0040<FT^0@000001P34Y[/00`000000_9jj0;bN^P0?0;bN^P030000002dUkT0]9Ni00h0]9Ni00<0
00000:bA^P2/TKX03`2/TKX00`000000Xh^k0:>;^`040:>;^`@000001P2RR;P00`000000Uh:j09N2
^P0509N2^P<000001`2FO[L010000000RGRj08Uh^P29N;X2000000T0QgBg0P0000000`25L;<00000
079W]`04079W]`030000001_HK<0Kf6c00H0Kf6c0P00000404e</00300000017A:/0AdB[00<0AdB[
00<0000003lkY00o>j@00P000002000=TP<0ool000@0o`000000000000000000E@3oool006X0oooo
00<0o`000000003o00000`3oo`030?kPT`8000000P3fcj@00`000000m=6[0?CAZ`030?CAZ`030000
003ad[00lM:`0080lM:`00<000000>O0[P0000001`3U`K800`000000hl:f0>?2]P040>?2]P<00000
2P3H][L2000000<0e[Nj00<000000<j/]`3>[;L01@3>[;L3000000L0cJfj00<000000<FT^035Y;P0
2035Y;P400000080a:Jk00<000000;bN^P2lW[X03`2lW[X00`000000]9Ni0;BG^@0>0;BG^@030000
002/TKX0[96j00l0[96j00<000000:>;^`2SRk/01000000:0::8^0030000002GP[X0Uh:j00<0Uh:j
0P00000;09In]`<000002P27M;L01@000000QG2c08E`/`25L;<0000000@0LVNg00<0000006mQ/`1_
HK<01P1_HK<010000000Jeb_06]L[`00000204e</00300000017A:/0AdB[00<0AdB[00<0000003lk
Y00o>j@00P0o>j@00`00000000fB000=TP030?oo00030?l000000000000005H0oooo001Z0?ooo`03
0?l000000000o`0000<0ool000@000000?kPT`3nh9<00000103fcj@00`000000m=6[0?CAZ`030?CA
Z`050000003ad[00lM:`0?7B/00000000P3W`:h00`000000iL6b0>G1/P050>G1/P030000003S`[H0
hl:f0080hl:f00@000000=Vd/`3I];<0fKBc0P00000:0=Rf]`<000002`3>[;L2000000D0cJfj00<0
00000<FT^035Y;P03035Y;P7000000d0_9jj00<000000;BG^@2dUkT03P2dUkT00`000000[96j0:bA
^P0;0:bA^PL000003`2RR;P00`000000Uh:j00000002000000`0UWjg0P00000:08Md]`8000001@25
L;<010000000LVNg079W]`00000806mQ/`070000001[G:l0Jeb_06]L[`000000CDb`0000000604M4
Z`030000000o>j@0?c^T0080?c^T00<00000000=TP003I80103oo`000`0007L000000?ooo`1E0?oo
o`00J@3oool00`3o00000000000000040?oo00040000003nh9<0o^2C000000D0m/nT00<000000?CA
Z`3ddJ/00`3ddJ/00`000000lM:`000000040>O0[P030000003U`K80iL6b00D0iL6b0P0000020>?2
]P030000003I];<0fKBc00<0fKBc0P00000:0=Rf]`800000303>[;L3000000030<f]^P000000aJBh
0100aJBh00<000000;bL]`2lW;L00P2lW;L9000000@0_9jj00<000000;BG^@2dUkT03P2dUkT00`00
0000[96j0:bA^P020:bA^PT00000102/S[L00`000000XXRh0::8^00>0::8^08000003P2FO[L20000
000309Ek]0000000QgBg00P0QgBg00<0000008E`/`25L;<01@25L;<00`000000LVNg0000000806mQ
/`030000001[G:l0Jeb_00<0Jeb_0P00000504M4Z`030000000o>j@0?c^T0080?c^T0P000002000=
TP060000003oo`00ool00?oo000007L00000EP3oool006T0oooo00<0o`000000000000000`3oo`00
103ng8L000000?kPT`3nh9<2000000@0m/nT00<000000?CAZ`3ddJ/00`3ddJ/00`000000lM:`0000
00050>O0[P030000003U`K80iL6b00H0iL6b0P0000080=Vd/`800000203H][L010000000cjZd0000
0000000=0<j/]`@000003`35Y;P00`000000_9bg0;bL]`0;0;bL]aX000003@2/S[L00`000000XXRh
0::8^00:0::8^0@0000000<0XHFe0000002FO[L02`2FO[L2000000@0UG^d00<0000008Md]`27M;L0
1027M;L2000000T0QG2c00<0000006mQ/`1_HK<01P1_HK<00`000000Jeb_06]L[`0406]L[`030000
0017A:/0AdB[00<0AdB[00<0000003lkY00o>j@00`0o>j@01@000000>36M000000003I80000000<0
ool000<0001g0000000000000`3oool00`000000oooo0?ooo`1?0?ooo`00J@3oool00`3o00000000
0?oo00030?oo00060?kLQ`000000o^2C0000003hcIh000001@3fcj@00`000000m=6[0?CAZ`030?CA
Z`030000003W`:h0il2^00D0il2^00<000000>G1/P3U`K801P3U`K800`000000fKBc0=Vd/`080=Vd
/`8000001@3H][L00`000000cjZd0<nZ]0020<nZ]0<000002`3>[;L00`000000aJ:e0<FR]@040000
00X0aJBh00<000000;bL]`2lW;L0402lW;L00`000000]9Fg0;BE]`0>0;BE]`030000002/S[L0[8jg
00l0[8jg00<000000::8^02RR;P01`2RR;P3000000H0XHFe00<0000009In]`2FO[L01`2FO[L20000
00H0UG^d00<0000008Md]`27M;L00P27M;L2000000T0QG2c0`00000606mQ/`8000001P1[G:l00`00
0000IeJZ0000000404M4Z`030000000o>j@0?c^T0080?c^T00<0000003PaW@0h<Id00P0000001@00
08D0ool00?oo003oo`00001g008000000P3oool200000540oooo001Y0?ooo`030?l000000000ool0
0080ool000<000000?kLQ`3ng8L00P0000020?S=WP030000003fcj@0m/nT00<0m/nT00<000000?CA
Z`3ddJ/00P3ddJ/2000000L0il2^00<000000>G1/P3U`K80103U`K8010000000f[>`00000000000:
0=Vd/`8000000`3H][L00`000000cjZd0<nZ]0050<nZ]0<000001`3>[;L00`000000aJ:e0<FR]@05
0<FR]@@000001P35Y;P00`000000_9bg0;bL]`0@0;bL]`030000002dUKL0]9Fg00h0]9Fg00<00000
0:b>]`2/S[L0402/S[L00`000000XXRh0::8^0030::8^0<000002@2QQKD00`000000UWjg09In]`04
09In]`<00000202ENk@01@000000QgBg08Md]`27M;L0000000T0QG2c0P00000308=//0030000001_
HK<0Kf6c0080Kf6c00<0000006]L[`1[G:l01@1[G:l010000000IeJZ06MFZP00000304M4Z`030000
000o>j@0?c^T00<0?c^T00H0000003PaW@0h<Id0>36M0000000008D30?oo00040000M`0000000000
0?ooo`@00000D03oool006T0oooo00<0o`000000003oo`000P3oo`0010000000o]b70?kLQ`000004
0?S=WP030000003fcj@0m/nT00<0m/nT00@000000?CAZ`3ddJ/000000P3X_ZX00`000000il2^0>O0
[P050>O0[P030000003U`K80iL6b00<0iL6b00@000000=Zc/03J/k00f[>`0P00000:0=Vd/`<00000
2`3?Z[@2000000D0cZbg00<000000<FR]@35X[D02@35X[D400000080aJBh00<000000;bL]`2lW;L0
3`2lW;L00`000000]9Fg0;BE]`0?0;BE]`030000002/S[L0[8jg0100[8jg00<000000::8^0000000
0`00000<0:65]@030000002FO[L0UWjg0080UWjg0P00000<09Ek]0<000002@25L;<00`000000Pfb`
08=//00308=//0050000001_HK<0Kf6c06mQ/`0000001`1[G:l00`000000IeJZ06MFZP0206MFZP03
00000017A:/0000000D0?c^T00<0000003PaW@0h<Id00P0h<Id00`0000000025000000030?oo0003
0000J0000000000000<0003o00<000000?ooo`3oool0CP3oool006P0oooo0P3o000020000000ool0
0?oo003oo`00oMMj0000003ng8L00000103hcIh00`000000m/nT0?K?Y0030?K?Y0050000003ddJ/0
m=6[00000000o`000P3X_ZX00`000000il2^0>O0[P050>O0[P050000003U`K80iL6b0>G1/P000000
1P3J/k000`000000fKBc0=Vd/`090=Vd/`800000303?Z[@3000000030<j/]`000000aJ:e00l0aJ:e
1`00000=0;bL]`030000002dUKL0]9Fg0100]9Fg00<000000:b>]`2/S[L02`2/S[L600000140XHFe
00@0000009In]`00000000003@2ENk@2000000T0QG2c0P00000608=//0040000001_HK<0Kf6c0000
00L0Jeb_00<0000006MFZP1WEZX00`1WEZX00`000000AdB[0000000403lkY0030000000h<Id0>36M
0080>36M0P0000000`0008D000000?oo00020?oo00030000J0000000oooo00<0003oD@3oool006P0
oooo0P3o00001`000000ool00?oo003oo`00oMMj0000003ng8L00P0000040?S=WP030000003fcj@0
m/nT00<0m/nT0P000002003o00<0j;jZ00<000000>O0[P3W`:h01@3W`:h010000000iL6b0>G1/P00
00070=Zc/08000002@3I];<010000000d:Va00000000000=0<nZ]0<000004@35X[D00`000000_IZd
0;fJ]0020;fJ]0T00000102lW;L00`000000]9Fg0;BE]`0@0;BE]`030000002/S[L0[8jg0080[8jg
2@0000040:^<]0030000002QQKD0XHFe00l0XHFe0P00000>09Ek]080000000<0TgRa00000025L;<0
1P25L;<2000000T0Pfb`0P00000706]L[`030000001WEZX0IeJZ00D0IeJZ00<0000003lkY00o>j@0
0`0o>j@00`000000>36M03PaW@0203PaW@80000000<000250000003oo`000P3oo`000`0006P00000
0000o`030000oe40oooo001X0?ooo`80o`0000L000000?oo003oo`00ool00?gGNP000000o]b70080
00001@3hcIh00`000000m/nT0?K?Y0030?K?Y00300000000o`000?l000@0j;jZ00<000000>O0[P3W
`:h01@3W`:h2000000X0f[>`0P0000060=Vd/`030000003@ZK40d:Va0080d:Va0P00000<0<nZ]003
00000036XK80000000<000003@35X[D00`000000_IZd0;fJ]00;0;fJ]1`000003@2[S;@00`000000
XHFe0:65]@0;0:65]@@0000000<0XH:b0000002ENk@02`2ENk@2000000@0TgRa00<0000008E`/`25
L;<00`25L;<00`000000Pfb`08=//00908=//0030000001[G:l0Jeb_00@0Jeb_0P0000000`1WEZX0
0?l0003o0003003o000306MFZP000000000000@0?c^T00<0000003PaW@0h<Id00P0h<Id00`000000
<2NF030WUP02000000<0ool000<0001X000000000?l00P000?mB0?ooo`00JP3oool01@000000ool0
0?oo003oo`00oMMj008000000P3jbiH00`000000n<fN0?S=WP030?S=WP030000003fcj@0m/nT0080
m/nT0P0000060>RnZP8000001P3W`:h00`000000f[>`0=Zc/00:0=Zc/0030000003I];<0fKBc00<0
fKBc00<000000=2Y/@3@ZK40103@ZK42000000T0cjZd00<000000<JQ/P36XK801036XK83000000T0
aJ:e00<000000;fJ]02mV[@0402mV[@00`000000]9:d0;BB]00@0;BB]0030000002[S;@0Zhbd00l0
Zhbd00<000000:65]@2QQKD0202QQKD3000000H0XH:b00<0000009Ek]02ENk@01`2ENk@2000000H0
TgRa00@0000008E`/`25L;<0QG2c0P00000:08=//0<000001@1[G:l010000000IeJZ06MFZP1WEZX2
003o00<0IeJZ00@0000006=?Y@1SCjD000000P0o>j@00`000000>36M03PaW@0203PaW@060000000`
9iH0<2NF030WUP000000001g0`3oo`02000000<0003oDP3oool006X0oooo00@000000?oo003oo`00
ool00P3megX01@000000n/^F0?[;UP3jbiH0000000@0n<fN00D000000?K?Y03fcj@0m/nT00000002
0>ZmY@030000003X_ZX0j;jZ00D0j;jZ00<000000>O0[P3W`:h00`3W`:h3000000/0f[>`0P000003
0=Vd/`030000003@ZK40d:Va00H0d:Va0`0000060<nZ]00300000036XK80aZ6b00L0aZ6b10000005
0<FR]@030000002mV[@0_IZd0100_IZd00<000000;BB]02dT[@0402dT[@00`000000Zhbd0:^<]00@
0:^<]0030000002QQKD0XHFe00<0XHFe100000090:62/P030000002ENk@0UG^d00@0UG^d0`000009
09=h/@<000002P23K;02000000<0PFN]00D0000006]L[`1[G:l0Jeb_0000000806MFZP050000001S
CjD0HdnU06=?Y@0000000P0o>j@00`000000>36M03PaW@0203PaW@050000000`9iH0<2NF030WUP00
00000P0007L30?oo00040000EP000?l0003o0000oe80oooo001Y0?ooo`030000003hb5X0ool00080
ool00P3megX01@000000n/^F0?[;UP3jbiH0000000D0n<fN00@000000?K?Y03fcj@000000`3Z_JD0
0`000000j;jZ0>RnZP050>RnZP050000003W`:h0il2^0>O0[P0000000`3L/J`2000000/0f[>`0`00
000<0=2Y/@800000103?Z[@00`000000aZ6b0<JQ/P0;0<JQ/P@0000000<0aJ:e0000002mV[@04@2m
V[@00`000000]9:d0;BB]00@0;BB]0030000002[S;@0Zhbd0100Zhbd00<000000:65]@0000000`00
000=0:62/P030000002ENk@0UG^d0080UG^d0P00000;09=h/@8000002`23K;000`000000PFN]085W
[@03085W[@040000001[G:l0Jeb_000000P0IeJZ00<0000006=?Y@1SCjD00P1SCjD00`000000?c^T
0000000403PaW@040000000`9iH0<2NF030WUP8000000P0007L30?oo00<0003oD`3oool006T0oooo
00<000000?S8FP3oo`000P3oo`0010000000oMMj0000000000030?[;UP030000003hcIh0n<fN00<0
n<fN00<000000?K?Y0000000103Z_JD00`000000j;jZ0>RnZP050>RnZP040000003W`:h0il2^0000
00D0g;6/0P00000;0=Zc/08000003@3@ZK42000000030<nZ]0000000aZ6b0140aZ6b1P00000>0;fJ
]0030000002dT[@0]9:d0100]9:d00<000000:^<]02[S;@0302[S;@600000180XH:b00@0000009Ek
]000000000002`2CN;4200000003099d[P000000Pfb`00P0Pfb`0P000007085W[@800000201WEZX0
0`000000HdnU06=?Y@0406=?Y@8000000`0h<Id00`000000<2NF030WUP02030WUP040000000W78d0
00000000M`<0ool00`000?mC0?ooo`00CP3oool00`0000000?l0003o000<003o00/0oooo00<0o`00
0000003o00000`3oo`0010000000oMMj0000000000040?[;UP030000003hcIh0n<fN0080n<fN0P00
00060>ZmY@030000003X_ZX0j;jZ00D0j;jZ0P0000080=ba[0030000003J/k00f[>`00P0f[>`00@0
00000=2W[P00000000003@3@ZK4300000180aZ6b00<000000;fH/@2mV;400P2mV;4:000000@0_IZd
00<000000;BB]02dT[@0402dT[@00`000000Zhbd0:^<]0020:^<]0X00000102[RK400`000000XH:b
0:62/P0?0:62/P<000002`2CN;43000000@0TWB^00<0000008=//023K;001023K;02000000T0PFN]
00<0000006MFZP1WEZX01@1WEZX2000000L0HdnU00D0000003PaW@0h<Id0>36M00000004030WUP05
0000000W78d09ab=0000000007L00`3oo`030000oe<0oooo001;0?ooo`@000006P00o`000`000000
0?l00?oo00020?oo008000000P3kb8h00`000000n/^F0?[;UP020?[;UP030000003hcIh0n<fN0080
n<fN00<000000>ZmY@3Z_JD01@3Z_JD2000000H0j;jZ00<000000=ba[03L/J`01`3L/J`2000000L0
f[>`00<000000=2W[P3@Yjh00P3@Yjh3000000/0d:Va00<000000<JO/00000000`00000>0<JQ/P03
0000002mV;40_IRa00`0_IRa7000000>0:^9/@030000002QP[80XH:b00X0XH:b1@00000209mo/003
0000002CN;40TgRa00L0TgRa0P000007099d[P0300000023K;00Pfb`00<0Pfb`00<00000085W[@21
Ijd01`21Ijd3000000H0IeJZ00<0000006=?Y@1SCjD01P1SCjD2000000<0>36M00<00000030WUP0`
9iH00P0`9iH00`0000009ab=02LLS@02000000<0ool00`000?mC0?ooo`00C@3oool4000001X00?l0
0`3oo`02000000<0nlR>00D000000?[;UP3jbiH0n/^F000000040?S=WP800000203Z_JD00`000000
j;jZ0>RnZP030>RnZP<000002@3L/J`2000000D0f[>`00<000000=2W[P3@Yjh01@3@Yjh2000000T0
d:Va00<000000<JO/036Wk000`36Wk04000000T0aZ6b00<000000;fH/@2mV;404@2mV;400`000000
]92a0;B@/@0@0;B@/@030000002[RK40ZhVa0140ZhVa00<000000:62/P2QP[801@2QP[84000000L0
Wgn`00<0000009=h/@2CN;401@2CN;42000000T0TWB^00@0000008=//023K;00Pfb`0P000008085W
[@8000000`1nHjT00`000000IeJZ06MFZP0206MFZP030000001SCjD0HdnU00H0HdnU00<0000005m9
X00000000P0h<Id00`000000<2NF030WUP02030WUP030000000W78d09ab=00809ab=0`3oo`00103o
0000003o0000o`000?mC0?ooo`00C`3oool2000000`0oooo3P00o`030?oo00030?_AJ`000000nlR>
0080nlR>00<000000?[;UP3jbiH00P3jbiH010000000n<fN0?S=WP0000020>bkX0030000003Z_JD0
j[fU00H0j[fU00D000000>RnZP3X_ZX0j;jZ000000030=f`Z@8000002@3L/J`2000000<0f[>`00<0
00000=2W[P3@Yjh01`3@Yjh2000000H0d:Va00<000000<JO/036Wk002036Wk04000000D0aZ6b00<0
00000;fH/@2mV;404@2mV;400`000000]92a0;B@/@0@0;B@/@030000002[RK40ZhVa0140ZhVa00<0
00000:62/P2QP[801@00000<09mo/0040000002CN;40TgRa09=h/@<00000302BM:h3000000T0PFN]
00<0000007iSZ@1nHjT00`1nHjT01@000000IeJZ06MFZP1WEZX0000000L0HdnU0P00000305m9X080
0000100`9iH00`0000009ab=02LLS@0302LLS@<0ool010000?mC0?ooo`00J03oool30000o`@0ool0
00<000000?_8SP3kb8h00P3kb8h00`000000n/^F0?[;UP020?[;UP030000003hcIh0000000<0k;^P
0P0000070>ZmY@040000003X_ZX0j;jZ000000D0gK2Y0P0000090=ba[0<00000303@Yjh3000000<0
d:Va00<000000<JO/036Wk003036Wk04000000030<JQ/P000000_IRa0180_IRa00<000000;B@/@2d
T;40402dT;400`000000ZhVa0:^9/@0>0:^9/@H000004@2OOk0010000000TgRa00000000000>099d
[P8000002@21Ijd2000000H0OV>Y00@0000006MFZP1WEZX000001`1SCjD00`000000GdVP05m9X003
05m9X0800000100`9iH00`0000009ab=02LLS@0202LLS@040000003oo`00ool00?oo00<0003o2`00
o`0;0?ooo`800000?03oool006P0oooo10000?l30?oo00800000103kb8h010000000n/^F0?[;UP3j
biH2000000H0k;^P00<000000>ZmY@3Z_JD01@3Z_JD2000000P0gK2Y00<000000=ba[03L/J`0203L
/J`2000000h0d:N^0P0000000`3@ZK4000000<JO/00A0<JO/0H000003`2mV;400`000000]92a0;B@
/@0A0;B@/@030000002[RK40ZhVa00L0ZhVa1P0000030:Z6[`030000002OOk00Wgn`0100Wgn`0P00
000?099d[P80000000<0TG6[00000021Ijd01P21Ijd2000000T0OV>Y0P00000706=?Y@030000001O
BJ00GdVP00@0GdVP00<00000030WUP0`9iH00P0`9iH00`0000009ab=02LLS@0302LLS@040000003o
o`00ool00?oo00<0003o6@00o`02000003T0oooo001Y0?ooo`<0003o0`3oo`02000000D0nlR>00D0
00000?[;UP3jbiH0n/^F000000070>bkX0030000003Z_JD0j[fU00D0j[fU00<000000=f`Z@3M/:T0
1`3M/:T2000000P0g;6/00<000000=6UZ`0000000P00000=0=2W[P@000004@36Wk000`000000_IJ_
0;fF[`020;fF[`X000001@2mV;400`000000]92a0;B@/@0A0;B@/@040000002[RK40ZhVa0:^9/@H0
00002@2ZQZl00`000000Wgn`09mo/00<09mo/0@0000000<0Wgb]0000002BM:h02`2BM:h3000000@0
TG6[00<00000085W[@21Ijd00`21Ijd00`000000OV>Y07iSZ@0907iSZ@030000001SCjD0HdnU00D0
HdnU00<0000005m9X01OBJ00101OBJ02000000<0<2NF00<0000002LLS@0W78d00`0W78d00`000000
7Q240?oo00020?oo00<0003o6@00o`04000003L0oooo001Y0?ooo`<0003o103oo`000`3laHD00000
0?_8SP030?_8SP040000003jbiH0n/^F0?[;UP8000001`3/^j000`000000j[fU0>ZmY@040>ZmY@<0
00002@3M/:T2000000D0g;6/00<000000=6UZ`3AYJ/00`3AYJ/3000000/0d:N^00<000000<NM[@37
WJd01@00000<0<JO/0030000002mUZl0_IJ_00`0_IJ_7@00000?0:Z6[`030000002OOk00Wgn`00P0
Wgn`1000000609ml[@030000002BM:h0TWB^00L0TWB^0P000007095aZ`0400000021Ijd0PFN]085W
[@8000002P1nHjT3000000H0HdnU00<0000005m9X01OBJ00101OBJ0010000000FT:K05Y2V`000002
030WUP030000000W78d09ab=00809ab=00<0000001h@Q03oo`000P3oo`000`0005H000000?ooo`0<
0?ooo`h00?l000<000000?ooo`3oool0>03oool006T0oooo0`000?l0103hb5X0ool00?oo003oo`02
0?c5Q@030000003kb8h0nlR>0080nlR>00H000000?[;UP3jbiH000000>fiV`0000070>bkX0030000
003Z_JD0j[fU00<0j[fU00@000000=j^Y@3N[ZD000002P3M/:T2000000<0g;6/00<000000=6UZ`3A
YJ/01P3AYJ/3000000P0d:N^00<000000<NM[@37WJd01@37WJd4000000L0aYn`00<000000;fF[`2m
UZl04P2mUZl00`000000]8j^0;B>[P0A0;B>[P030000002ZQZl0ZXJ_0140ZXJ_00<0000009mo/02O
Ok000`2OOk04000000X0Wgb]00<00000099d[P2BM:h01@2BM:h2000000X0TG6[0`00000:07iSZ@80
00000`1lGZD010000000HdnU06=?Y@1SCjD2000000H0GdVP00L0000005Y2V`1J@Y/0FT:K0000000`
9iH0000000D09ab=00<0000001h@Q03oo`000P3oo`000`0005H000000?ooo`1E0?ooo`00J@3oool3
0000o`030?S8FP3oo`00ool00080ool000<0o<F50000003kb8h0103kb8h2000000<0kKVK0P000006
0>bkX08000000P3Z_JD00`000000gZjU0=j^Y@020=j^Y@8000002P3M/:T3000000`0dJF[0`000004
0=2W[P0300000037WJd0aif]00X0aif]1@0000020<JO/0030000002mUZl0_IJ_0180_IJ_00<00000
0;B>[P2dSZh04@2dSZh00`000000ZXJ_0:Z6[`0A0:Z6[`030000002OOk00000000<000003P2OO:d0
0`000000TWB^099d[P02099d[P<000002`2ALJ/2000000/0OV>Y00<0000007aNY@1lGZD00`1lGZD0
10000000HdnU06=?Y@00000705m9X0030000001J@Y/0FT:K00<0FT:K0P00000402LLS@030000000N
48@07Q2400<0ool000<000000?ooo`3oool0E@3oool006T0oooo0`000?l00`000000n<QJ0?oo0002
0?oo0080o<F500<000000?_8SP3kb8h00P3kb8h2000000D0kKVK00<000000>bkX03/^j001@3/^j00
0`000000j[fU000000060=j^Y@8000002P3M/:T2000000h0dJF[0`0000000`3@Yjh000000<NM[@0@
0<NM[@H00000402mUZl00`000000]8j^0;B>[P0B0;B>[P030000002ZQZl0ZXJ_00h0ZXJ_1@00000C
09ml[@040000002BM:h00000000000`0TG6[0P0000000`2?KJL0000007iSZ@0807iSZ@8000001`1l
GZD2000000L0GdVP00<0000005Y2V`1J@Y/0101J@Y/00`0000009ab=02LLS@0202LLS@040000000N
48@07Q2401h@Q0<0ool000<000000?ooo`3oool0E@3oool006T0oooo0`000?l00`000000n<QJ0?oo
00020?oo00<0o<F500<000000?_8SP3kb8h00P3kb8h00`000000kKVK0>fiV`040>fiV`030000003/
^j00k;^P00D0k;^P0P0000080=j^Y@030000003M/:T0gK2Y00L0gK2Y00@000000=:SY`0000000000
3`3AYJ/300000180aif]00@000000;fD[02mU:`0_IB/1P00000:0;fF[`030000002dSZh0]8j^0180
]8j^00<000000:Z6[`2ZQZl0202ZQZl6000000<0ZXB/00<0000009ml[@2OO:d04@2OO:d2000000d0
TG6[0P00000408m]Y`030000001nHjT0OV>Y00@0OV>Y0P00000907aNY@030000001OBJ00GdVP00@0
GdVP0P00000605Y2V`8000000`0W78d0100000007Q2401h@Q00N48@40?oo00030000003oool0oooo
05D0oooo001Z0?ooo`<0003o00<000000?oo003oo`000P3oo`030?c5Q@040000003kb8h0nlR>0?_8
SP8000001P3]^I/00`000000k;^P0>bkX0050>bkX0030000003N[ZD0gZjU00L0gZjU0P0000060=f`
Z@030000003BXjL0dZ>W0080dZ>W0`00000=0=6UZ`0300000037VjT0000000<000003P37WJd00`00
0000_IB/0;fD[0070;fD[0L000000`2mUZl00`000000]8j^0;B>[P0B0;B>[P040000002ZQZl0ZXJ_
0:Z6[`L000002@2ZQ:`00`000000Wgb]09ml[@0=09ml[@@0000000<0WWVZ0000002ALJ/02P2ALJ/2
000000H0SffW00<0000007iSZ@1nHjT00`1nHjT00`000000O5jU07aNY@0707aNY@<000001@1OBJ00
0`000000FT:K05Y2V`0505Y2V`030000001F>Y@0000000<09ab=00<0000001h@Q00N48@0103oo`02
000005L0oooo001Z0?ooo`<0003o00<000000?g1NP3oo`000P3oo`030?c5Q@070000003kb8h0nlR>
0?_8SP000000kkNE000000060>fiV`030000003/^j00k;^P00@0k;^P0`0000090=j^Y@030000003M
/:T0gK2Y00<0gK2Y00<000000=:SY`3BXjL01@3BXjL2000000X0dJF[00<000000<NKZ@37VjT01037
VjT4000000T0aif]00<000000;fD[02mU:`03`2mU:`L00000100ZXB/00<0000009ml[@2OO:d02@2O
O:d4000000D0WWVZ00<00000095aZ`2ALJ/01P2ALJ/3000000P0SffW00@0000007iSZ@1nHjT0OV>Y
0P00000907aNY@050000001iFJ40NEVQ07UIX@0000000`1OBJ000`000000FT:K05Y2V`0505Y2V`04
0000001F>Y@0ESZD000000809ab=00@0000001h@Q00N48@07Q240`3oo`000`0D0gT000000?ooo`1G
0?ooo`00JP3oool30000o`030000003m`GX0ool00080ool0103laHD00`000000nlR>000000030>ng
U@030000003]^I/0kKVK00@0kKVK0P0000030>bkX0040000003O[:40gjbQ0=n/X@800000203N[ZD2
000000<0gK2Y00<000000=:SY`3BXjL01`3BXjL300000080dJF[1000o`000`3AYJ/000000<NKZ@09
0<NKZ@@000001@37WJd00`000000_IB/0;fD[00B0;fD[0030000002dS:`0]8b/0180]8b/00<00000
0:Z4[02ZQ:`04P2ZQ:`00`000000Wgb]09ml[@0409ml[@@000002@2NNJX00`000000TG6[095aZ`04
095aZ`800000302?KJL3000000T0O5jU0P00000407UIX@040000001OBJ00GdVP000000L0FT:K00<0
000005HjU01F>Y@00P1F>Y@2000000<07Q24103oo`000`0D0gT000000?ooo`1G0?ooo`00J@3oool0
1P000000003o0000o`000?l000000?g1NP@0ool0103laHD2000000@0kkNE00<000000>fiV`3]^I/0
1@3]^I/010000000k;^P0>bkX00000050=n/X@800000203N[ZD3000000d0dZ>W0`0000001@3AYJ/0
0?l0003o003AYJ/0000000h0ai^Y100000000`37WJd000000;fD[00C0;fD[0030000002dS:`0]8b/
0180]8b/00<000000:Z4[02ZQ:`04P2ZQ:`00`000000Wgb]09ml[@04000000h0WWVZ00@00000095a
Z`2ALJ/0TG6[0P00000=08m]Y`8000002@1lGZD2000000L0NEVQ0P00000705Y2V`030000001F>Y@0
ESZD00<0ESZD0P00000301h@Q0<0ool000<050=i0000003oool0F03oool006X0oooo0`000?l00`3o
ool000000?g1NP030?oo00040000003laHD0o<F50?c5Q@8000001@3_]iD00`000000kKVK0>fiV`05
0>fiV`800000203O[:400`000000gZjU0=j^Y@070=j^Y@8000003`3BXjL200000003003o00000000
ai^Y0180ai^Y1@00000A0;fD[0030000002dS:`0]8b/0180]8b/00<000000:Z4[02ZQ:`03@2ZQ:`8
000000h0WWVZ1000o`0010000000TG6[00000000000<08m]Y`<0000000<0SVVT0000001lGZD01`1l
GZD00`000000NEVQ07UIX@0707UIX@030000001J@Y/0FT:K00@0FT:K0P00000605HjU0040000000N
48@07Q2401h@Q0@0ool000<050=i0000003oool0F03oool006X0oooo0`000?l00`3oool000000?g1
NP040?oo00050000003laHD0o<F50?c5Q@0000001P3_]iD2000000H0kKVK00<000000=n/X@3O[:40
1`3O[:42000000L0gZjU00<000000=>RY00000000P00000>0=:SY`<000004`37VjT010000000_Y:Y
0;jBZ@2nTZT7000000X0_IB/00<000000;B<[02dS:`04P2dS:`00`000000ZXB/0:Z4[0030:Z4[0X0
00001@2YPJT00`000000WWVZ09iiZP0>09iiZP<00?l00P00000=08m]Y`800000102>JJ@00`000000
O5jU07aNY@0407aNY@800000201iFJ43000000D0FT:K00<0000005HjU01F>Y@01@1F>Y@200000080
7Q24103oo`000`0D0gT000000?ooo`1I0?ooo`00J`3oool01P000000oooo0?ooo`3oool000000?g1
NP<0ool000@000000?c5Q@3laHD0o<F50P0000070>ngU@030000003]^I/0kKVK00<0kKVK00<00000
0>2ZW00000002@3O[:42000000D0gZjU00<000000=>RY03CXZ@00P3CXZ@2000000d0dZ>W00<00000
0<RIYP0000000`00000?0<NKZ@030000002nTZT0_Y:Y00P0_Y:Y1`0000030;fD[0030000002dS:`0
]8b/00P0]8b/4000000?0:V1Z@030000002NNJX0WWVZ00d0WWVZ100000000`2MMZL0000008m]Y`09
08m]Y`<000001P2>JJ@00`000000O5jU07aNY@0307aNY@030000001iFJ40NEVQ00H0NEVQ0P000002
07IDW0030000001J@Y/0FT:K0080FT:K00<0000005HjU01F>Y@01@1F>Y@00`000000D3:>00000002
01h@Q0<0ool000<050=i0000003oool0FP3oool00700oooo00H000000?oo003oo`00ool00?g1NP00
00020?c5Q@030000003`]8h0000000L0kkNE00<000000>fiV`3]^I/00P3]^I/00`000000h:ZL0>2Z
W002000000T0gjbQ0P0000020=j^Y@030000003CXZ@0dj:T00D0dj:T0`00000:0=:SY`0300000038
VJH0b9VV00<0b9VV1000000:0<NKZ@030000002nTZT0_Y:Y0100_Y:Y3P00000:0;B9Z@030000002Y
PJT0ZH6Y0180ZH6Y00<0000009iiZP2NNJX02@2NNJX4000000D0WGJW00<0000008m]Y`2?KJL01@2?
KJL3000000X0SVVT00<0000007aNY@1lGZD00P00000807UIX@030000001fE9`0MUBL0080MUBL00D0
000005Y2V`1J@Y/0FT:K0000000605HjU08000000`1@<Xh00`000000ool00?oo00020?oo000301@3
N@000000oooo05X0oooo001`0?ooo`030000003oo`00ool00080ool000<0oL5j0000000000000`3`
]8h2000000H0kkNE00@000000>fiV`3]^I/000001@3PZY`00`000000gjbQ0=n/X@080=n/X@<00000
2P3CXZ@3000000H0dZ>W00<000000<RIYP38VJH02038VJH4000000H0ai^Y00<000000;jBZ@2nTZT0
4`2nTZT00`000000]8VY0;B9Z@0B0;B9Z@030000002YPJT0ZH6Y01<0ZH6Y00<0000009iiZP2NNJX0
102NNJX4000000X0WGJW00<0000008m]Y`2?KJL00P2?KJL2000000d0SVVT0`00000807UIX@800000
1P1fE9`00`000000FT:K0000000605HjU0030000001@<Xh0D3:>00<0D3:>00H000000?oo003oo`00
ool001@3N@00001L0?ooo`00L@3oool00`000000ool00?oo00020?oo008000001@3`]8h00`000000
kkNE0>ngU@040>ngU@030000003]^I/0000000H0h:ZL0P00000:0=n/X@800000303CXZ@2000000@0
dZ>W00<000000<RIYP38VJH03038VJH400000080ai^Y00<000000;jBZ@2nTZT04`2nTZT00`000000
]8VY0;B9Z@0B0;B9Z@030000002YPJT0ZH6Y01<0ZH6Y00<0000009iiZP2NNJX01000000>09efY`03
0000002?KJL00000008000003P2>JJ@2000000P0NEVQ0P00000807IDW08000001P1F>Y@00`000000
D3:>050bSP04050bSP@0ool000<000000?ooo`3oool0F`3oool00780oooo00<000000?oo003oo`00
0P3oo`000`000000l;B>0?2dSP040?2dSP030000003_]iD0kkNE00@0kkNE0P0000080>2ZW0800000
203O[:400`000000dinP00000002000000/0dj:T0`0000000`3BXjL000000<RIYP0A0<RIYPP00000
402nTZT00`000000]8VY0;B9Z@0C0;B9Z@030000002YPJT0ZH6Y00d0ZH6Y2000000A09efY`800000
3`2>JJ@30000000308aUX0000000NEVQ00D0NEVQ0P00000:07IDW0030000001F>Y@0ESZD00@0ESZD
00<00000050bSP1@<Xh0101@<Xh40?oo00030000003oool0oooo05`0oooo001c0?ooo`040000003o
o`00ool00?oo008000001P3`]8h00`000000kkNE0>ngU@040>ngU@030000003PZY`0h:ZL00P0h:ZL
0P0000060=n/X@030000003CWj00dinP0080dinP0P00000<0=>RY0@000004P38VJH00`000000_Y2V
0;j@YP030;j@YP/000001@2nTZT00`000000]8VY0;B9Z@030;B9Z@<00?l03@2dRJT00`000000ZH6Y
0:V1Z@030:V1Z@X000001@2YOZH00`000000WGJW09efY`0=09efY`@0000000<0W7>S0000002>JJ@0
302>JJ@2000000@0S6FP00<0000007UIX@1iFJ400`1iFJ400`000000MUBL07IDW00807IDW0<00000
1@1F>Y@00`000000D3:>050bSP04050bSP060000003oo`00ool00?oo000D0gT000000P3oool20000
05X0oooo001c0?ooo`030000003oo`00ool00080ool000<0lK670000003`]8h01@3`]8h00`000000
kkNE0>ngU@030>ngU@030000003QYiL0000000X0h:ZL00<000000=n/X@3O[:400P3O[:400`000000
dinP0=>OX0050=>OX0<000002P3CXZ@00`000000b9NS0<RGX`04000000h0b9VV00<000000;j@YP2n
T:H03P2nT:HQ000000l0ZGjV00<0000009efY`2MMZL02@2MMZL4000000D0W7>S00<0000008iYY02>
JJ@0202>JJ@3000000L0S6FP00<0000007UIX@1iFJ400P00000907IDW08000000P1cCYL010000000
ESZD05HjU01F>Y@2000000H0D3:>00<000000?oo003oo`000P3oo`05000005/0oooo001d0?ooo`03
0000003oo`00ool00080ool000<0lK670000003`]8h01@3`]8h2000000<0kkNE00<000000>6WU`3Q
YiL00P0000090>2ZW08000000P3O[:400`000000dinP0=>OX0080=>OX0<000001`3CXZ@00`000000
b9NS0<RGX`040<RGX`@000002P38VJH00`000000_Y2V0;j@YP0C0;j@YP030000002cQjH0/hNV01<0
/hNV00<000000:UnYP2YOZH04`2YOZH00`000000WGJW09efY`0409efY`@000002@2LLj<00`000000
SVVT08iYY00508iYY0<000002P2<IJ03000000X0MUBL00<0000007=>U`1cCYL00`1cCYL00`000000
ESZD00000007050bSP030000003oo`00ool00080ool00P00000010000?l0000000000000001K0?oo
o`00M@3oool00`000000ool00?oo00020?oo00030?6aQ`000000l;B>00H0l;B>00<000000>ngU@00
00001@3QYiL2000000T0h:ZL0`00000=0=>OX0800000103CXZ@00`000000b9NS0<RGX`090<RGX`@0
00001P38VJH00`000000_Y2V0;j@YP0C0;j@YP030000002cQjH0/hNV01<0/hNV00<000000:UnYP2Y
OZH04`2YOZH00`000000WGJW09efY`04000000h0W7>S00<0000008iYY02>JJ@00P2>JJ@2000000`0
S6FP0P00000:07IDW08000001P1cCYL2000000L0D3:>00<000000?oo003oo`000`3oo`020000o`03
000000000<l0000005`0oooo001e0?ooo`800000103oo`000`3a/HL000000?2dSP060?2dSP800000
1`3QYiL2000000T0h:ZL0P00000>0=>OX0<0000000<0dj:T00000038Uj<03P38Uj<400000080b9VV
00<000000;j@YP2nT:H04`2nT:H00`000000/hNV0;>7YP0C0;>7YP030000002YOZH0ZGjV0100ZGjV
1P00000B09acX`030000002>JJ@0000000800000302<IJ020000000308YQW0000000MUBL00L0MUBL
0P00000807=>U`030000001@<Xh0D3:>00@0D3:>0P0000040?oo000304/YQ`000?l0003o0080003o
0P00001L0?ooo`00MP3oool00`000000lK670?oo00030?oo00030?6aQ`000000000000H0l;B>00<0
00000>6WU`3QYiL01`3QYiL2000000L0h:ZL00<000000=BMW00000000P00000>0=>OX0@000004@38
Uj<800000100_Y2V00<000000;>7YP2cQjH04`2cQjH00`000000ZGjV0:UnYP090:UnYPL000000`2X
O:<00`000000W7>S09acX`0@09acX`<000003P2<IJ02000000<0RV6L00<0000007IDW01fE9`0101f
E9`2000000P0LdjG0`000005050bSP030000001;:HL0ool000<0ool000<0BbV70000o`000?l00P00
0?mO0?ooo`00M`3oool00`000000lK670?oo00030?oo0080lK6700<000000?2dSP3`]8h00`3`]8h0
0`000000hZFB000000090>6WU`8000001@3PZY`00`000000e9fL0=BMW0020=BMW08000003@3CWj00
0`000000b9BP0<RDX004000000l0b9NS00<000000;j=X`2nSJ<00`2nSJ<;000000D0_Y2V00<00000
0;>7YP2cQjH04`2cQjH010000000ZGjV0:UnYP2YOZH8000000X0Z7bS00<0000009acX`2LLj<0302L
Lj<400000080Vg2P00<0000008aUX02<IJ002@2<IJ03000000D0RV6L00<0000007IDW01fE9`00`1f
E9`00`000000LdjG07=>U`0607=>U`8000000P1`B9800`000000D3:>050bSP02050bSP030000001;
:HL0ool000<0ool01@000?mP0?ooo`00N03oool2000000@0ool00P3a/HL00`000000l;B>0?2dSP02
0?2dSP030000003RYI80hZFB008000002@3QYiL200000080h:ZL00<000000=BMW03DWI`01@3DWI`3
000000X0dinP00<000000<RDX038U:001038U:04000000/0b9NS00<000000;j=X`2nSJ<03P2nSJ<O
00000180Z7bS00<0000009acX`2LLj<0202LLj<4000000H0Vg2P00<0000008aUX02<IJ001`2<IJ02
000000T0RV6L00<0000007IDW01fE9`00P00000807=>U`030000001`B980L4RB0080L4RB00H00000
050bSP1@<Xh0D3:>0000001;:HL40?oo00D0003oH@3oool007X0oooo00<000000?oo003oo`000P3o
o`020?6aQ`040000003`]8h0l;B>000000D0hZFB00<000000>6WU`3QYiL0203QYiL3000000X0e9fL
0`0000060=>OX00300000038U:00b9BP00T0b9BP100000060<RGX`030000002nSJ<0_XfS01@0_XfS
00<000000;>4X`2cQ:<04`2cQ:<00`000000Z7bS0:QlX`0C0:QlX`030000002LLj<0W7>S00@0W7>S
1000000:09]`X0030000002<IJ00S6FP00@0S6FP0`00000;08YQW0<00000201cCYL2000000H0L4RB
00@00000050bSP000000BbV70`3oo`060000of80oooo001k0?ooo`030?l0003oo`00ool00080ool0
0P3a/HL00`000000l;B>000000060>:UTP8000002P3QYiL2000000`0e9fL0P0000040=>OX0030000
0038U:00b9BP00d0b9BP100000020<RGX`030000002nSJ<0_XfS01@0_XfS00<000000;>4X`2cQ:<0
4`2cQ:<00`000000Z7bS0:QlX`0C0:QlX`030000002LLj<0W7>S00@000003`2KL:0010000000S6FP
08aUX02<IJ02000000d0RV6L0P00000807=>U`800000201`B9820000000304/YQ`3oo`00ool00080
ool010000?mT0?ooo`00N03oool3003o0080o`001@3oo`000`3a/HL00000000000080>:UTP800000
203QYiL010000000e9^H00000000000<0=BMW0<0000000<0dinP00000038U:004P38U:0600000180
_XfS00<000000;>4X`2cQ:<0502cQ:<00`000000Z7bS0:QlX`0@0:QlX`H000004`2KL:0010000000
S6FP00000000000<08YQW0<0000000<0R5fH0000001cCYL01@1cCYL2000000X0L4RB00<000000?oo
003oo`000`3oo`040000ofD0oooo001d0?ooo`L00?l00`3o00050?oo00030?6aQ`000000hZFB00T0
hZFB0P0000060>6WU`040000003DViP0e9^H0=BKV0<00000303DWI`4000001<0b9BP00@000000;j;
X02nRj00_X^P1`00000;0;j=X`030000002cQ:<0/hBS01@0/hBS00<000000:QlX`2XO:<02@2XO:<7
000000<0Z7VP00<0000009]`X02KL:004@2KL:03000000d0RV6L0P00000408QMV0030000001cCYL0
LdjG00<0LdjG00<000000718TP1`B980201`B982000000D0ool00`000?mW0?ooo`00L@3oool;003o
00030?ooo`000?l0003o00D0ool000<000000>>RS@0000002P3RYI800`000000hJNG0>6WU`020>6W
U`030000003DViP0e9^H00D0e9^H0P00000;0=BMW00300000039TY`0bI:L00@000003`38U:000`00
0000_X^P0;j;X0080;j;X0P000000`2nSJ<00`000000/hBS0;>4X`0D0;>4X`040000002XO:<0Z7bS
0:QlX`P000002P2XNJ000`000000Vg2P09]`X00=09]`X0@000000P2JK9`00`000000RV6L08YQW008
08YQW0<000001`28GIP00`000000LdjG07=>U`02000000T0L4RB0P0000050?oo00@0003oJ03oool0
06d0oooo3000o`050?ooo`<0003o1@3oo`000`3SXXd00000000000090>:UTP8000000P3QYiL00`00
0000e9^H0=BKV0070=BKV0<00000203DWI`00`000000bI:L0<VBW0040<VBW0@000002`38U:000`00
0000_X^P0;j;X00@0;j;X1h000004P2XNJ000`000000Vg2P09]`X00909]`X0@000001P2JK9`00`00
0000RV6L08YQW00508YQW0<000002P28GIP3000000T0L4RB0P0000000`1]@Xd0ool00?oo00020?oo
00D0003o0P00o`1W0?ooo`00JP3oool;003o00X0oooo0`000?l60?oo00030>>RS@000000000000T0
hZFB0`00000<0=BKV08000001P3DWI`00`000000bI:L0<VBW0080<VBW0D000001P38U:000`000000
_X^P0;j;X00C0;j;X0030000002cPYl0/h:O01@0/h:O00<000000:QiX02XNJ00502XNJ000`000000
Vg2P09]`X00409]`X0@000002`2JK9`00`000000RV6L08YQW00208YQW08000003028GIP2000000T0
L4RB0P0000000`1]@Xd0ool00?oo00040?oo00030?l000000?l0003o00L00?l0I03oool006L0oooo
2`00o`0>0?ooo`@0003o1@3oo`020>>RS@8000002@3RYI82000000d0e9^H0`0000030=BMW0030000
0039TY`0bI:L00d0bI:L100000020<RDX0030000002nRj00_X^P01<0_X^P00<000000;>2W`2cPYl0
502cPYl00`000000Z7VP0:QiX00D0:QiX0030000002KL:00Vg2P00@000003`2JK9`00`000000RV6L
00000002000000`0R5fH0P0000000`26F9@000000718TP060718TP8000000P1]@Xd50?oo000306e2
S@000000oooo0080oooo2@00o`1R0?ooo`00I`3oool7003o01<0oooo10000?l60?oo0080hj:=0P00
00070>:UTP030000003EV9@00000008000003@3DViP2000000030=BMW0000000bI:L0180bI:L2000
000@0;j;X0030000002cPYl0/h:O01@0/h:O00<000000:QiX02XNJ003`2XNJ0800000140VVbL0`00
000=08QMV0<000000`26F9@00`000000L4RB0718TP030718TP8000000P1]@Xd60?oo008000001`3o
ool9003o05l0oooo001V0?ooo`0300000000o`000?l000800?l05`3oool50000o`H0ool00P3SXXd2
000000D0hZFB00<000000=FHU03EV9@00P3EV9@3000000`0e9^H1000000C0<VBW0030000002nR9`0
_XRL00<0_XRL2`0000050;j;X0030000002cPYl0/h:O01@0/h:O00<000000:QiX02XNJ000`2XNJ0<
000000D0YgJL00<0000009Y/W02JK9`03@2JK9`400000080VFRI00<0000008QMV028GIP02@28GIP2
000000L0QURD00<000000718TP1`B9800P00000306e2S@D0ool00P00000<0?ooo`T00?l0G03oool0
06D0oooo1@00000I0?ooo`D0003o1`3oo`020>>RS@8000000`3RYI800`000000eIRD0=FHU0050=FH
U08000002`3DViP00`000000bI2I0<V@V@04000000l0bI:L00<000000;j8W02nR9`03P2nR9`R0000
0140YgJL00<0000009Y/W02JK9`02@2JK9`4000000H0VFRI00<0000008QMV028GIP01P28GIP30000
00T0QURD0`00000306e2S@H0ool000<000000?ooo`3oool03P3oool:003o00030000003oool0oooo
05H0oooo00240?ooo`D0003o00<000000?oo003oo`00103oo`030>>RS@80000000<0hZFB0000003E
V9@0203EV9@3000000P0e9^H00<000000<V@V@39T9T01039T9T4000000X0bI:L00<000000;j8W02n
R9`0502nR9`00`000000/gnL0;=oW00D0;=oW0030000002WMY`0YgJL01@0YgJL00<0000009Y/W02J
K9`0102JK9`5000000X0VFRI00<0000008QMV028GIP01028GIP2000000/0QURD0P00000306e2S@H0
ool00P00000D0?ooo`T00?l0E`3oool008H0oooo10000?l2000000D0ool0103SXXd3000000/0eIRD
0`0000040=BKV00300000039T9T0bI2I00T0bI2I100000060<VBW0030000002nR9`0_XRL01@0_XRL
00<000000;=oW02cOi`0502cOi`00`000000YgJL0:MfW00D0:MfW0030000002JK9`0VVbL00@00000
3`2IJ9T010000000R5fH08QMV028GIP3000000/0QURD0P0000001024Dhl0000006e2S@1]@Xd60?oo
00030000003oool0oooo01L0oooo1P00o`02000005D0oooo00270?ooo`@0003o00<000000?ooo`00
00001@3oo`030>>RS@030000003EUXl00000008000002`3EV9@3000000030=BKV0000000bI2I00h0
bI2I100000020<VBW0030000002nR9`0_XRL01@0_XRL00<000000;=oW02cOi`0502cOi`00`000000
YgJL0:MfW00A0:MfW0H000004`2IJ9T010000000R5fH00000000000;08IHU0<000000`24Dhl00`00
0000ool00?oo00040?oo00030000003oool0oooo01`0oooo0`00o`03000005@0oooo00280?ooo`D0
003o0P3oool60?oo00030>>RS@000000eIJ?00<0eIJ?0`00000;0=FHU0@000004@39T9T800000140
_XRL00<000000;=oW02cOi`0502cOi`00`000000YgJL0:MfW0090:MfW0P000000`2VLiT00`000000
VFRI09UXV@0A09UXV@<000003026F9@2000000D0Q5>?1P3oo`000`000000oooo0?ooo`1h0?ooo`00
R@3oool30000o`040000003oool0oooo0?ooo`P0ool01P3EUXl2000000X0eIRD00<000000<V=U@39
SID01000000?0<V@V@030000002mQYT0_HJI00<0_HJI300000050;j8W0030000002cOi`0/gnL01@0
/gnL00@000000:MfW02WMY`0YgJL2000000;0:IcV@030000002IJ9T0VFRI00d0VFRI1000000209MU
U@0300000026F9@0QURD00L0QURD0`00000408ACS`P0ool000<000000?ooo`3oool0N@3oool00980
oooo203oo`060=FFS`<000001`3EV9@00`000000bHfE0<V=U@040<V=U@@000002`39T9T00`000000
_HJI0;f6V@0?0;f6VB0000004`2VLiT00`000000VFRI09UXV@0909UXV@@000001P2GIID00`000000
QURD08IHU00508IHU08000001@24Dhl80?oo00030000003oool0oooo07/0oooo002D0?ooo`T0ool0
1P3EUXl3000000@0eIRD00<000000<V=U@39SID02039SID5000000H0bI2I00<000000;f6V@2mQYT0
502mQYT00`000000/WbI0;9lV@0D0;9lV@030000002VLiT0YW>I01D0YW>I00<0000009UXV@2IJ9T0
102IJ9T4000000/0UfFE00@0000008IHU026F9@0QURD0`00000508ACS`P0ool000<000000?ooo`3o
ool0O@3oool009L0oooo2@3oo`060=FFS`<0000000<0eIRD00000039SID03P39SID400000080bI2I
00<000000;f6V@2mQYT0502mQYT00`000000/WbI0;9lV@0D0;9lV@030000002VLiT0YW>I01D0YW>I
00<0000009UXV@2IJ9T01000000?09MUU@0400000026F9@00000000000D0Q5>?203oo`0200000840
oooo002I0?ooo`T0ool01`3EUXl400000140bHfE1P00000C0;f6V@030000002bO9T0/WbI01D0/WbI
00<000000:IcV@2VLiT03`2VLiT800000140UfFE0`00000608ACS`P0ool00P000?l4000007l0oooo
002L0?ooo`T0ool01@3EUXl00`000000bH^A0<V;T@04000000l0bHfE00@000000;f3U@2mPiD0_H>E
2000000;0;f6V@030000002bO9T0/WbI01D0/WbI00<000000:IcV@2VLiT00`2VLiT<000000D0YFnE
00<0000009MUU@2GIID03@2GIID400000080UV6A00@0000008ACS`24Dhl0Q5>?1P3oo`070000o`<0
0000P03oool009h0oooo00<000000?oo003oo`001`3oo`020=FFS`0300000039Ri40bH^A00@0bH^A
1000000;0<V=U@030000002mPiD0_H>E00T0_H>E200000030;f6V@030000002bO9T0/WbI00X0/WbI
4@00000A0:E_U@030000002GIID0UfFE00T0UfFE1000000609IQT@030000003oo`00ool000D0ool0
2@000?l200000840oooo002Q0?ooo`X0ool02P39Ri45000000H0bHfE00<000000;f3U@2mPiD04@2m
PiD@000000/0/WVE00<000000:E_U@2UKiD0502UKiD00`000000UfFE09MUU@0409MUU@D000001P2F
HI490?oo00T0003o00<0oooo000000000000P`3oool00:<0oooo00<000000?oo003oo`00203oo`0<
0<V;T@@000000P39SID00`000000_H>E0;f3U@0D0;f3U@030000002bNID0/WVE01D0/WVE00<00000
0:E_U@2UKiD0502UKiD00`000000UfFE09MUU@04000000P0UV6A2@3oo`090000ohT0oooo002V0?oo
o`050?l0003oo`00ool00?oo00000?l0203oo`0;0<V;T@H000004`2mPiD00`000000/WVE0;9iU@0E
0;9iU@030000002UKiD0YFnE0140YFnE1P00000:09IQT@X0ool020000?n;0?ooo`00Y@3oool00`00
o`00o`000?l000020?l000030000o`3oo`00ool000T0ool02P39Ri4010000000_H2A0;f0T@2mP948
000000/0_H>E00<000000;9iU@2bNID05@2bNID00`000000YFnE0:E_U@090:E_U@P000000`2TK940
0`000000UV6A09IQT@0409IQT@`0ool02@000?n>0?ooo`00Y03oool3003o00L0003o3@3oo`050<V;
T@030000002mP940_H2A00T0_H2A200000030;f3U@030000002bNID0/WVE01D0/WVE00@000000:E_
U@2UKiD0YFnE2000000;0:A/T@030000003oo`00ool000d0ool01`000?nC0?ooo`00X`3oool4003o
0080oooo00@0003o0?ooo`3oool0oooo1P000?l<0?oo00030<V;T@000000_H2A0180_H2A7`00000@
0:A/TA40ool000<0oooo0?l000000?l00P000?l00`00o`00oooo0?ooo`2D0?ooo`00XP3oool4003o
00X0oooo1P000?l@0?oo0140_H2A00<000000;5fT@2aMY405@2aMY400`000000Y6bA0:A/T@0:0:A/
TA40ool02P3oool4003o09D0oooo002Q0?ooo`@00?l03@3oool90000oa@0ool0202mP9400`000000
/GJA0;5fT@0E0;5fT@040000002TK940Y6bA0:A/TA@0ool00P00000?0?ooo`@00?l0U03oool00:00
oooo1000o`0A0?ooo`T0003o00<000000?oo003oo`00@P3oo`0F0?ooo`@00?l0T`3oool009l0oooo
1000o`0G0?ooo`@0003o0P0000060?ooocH0ool07P3oool4003o0980oooo002N0?ooo`@00?l06@3o
ool6000000h0oooo903oo`040000o`8000008P3oool4003o0940oooo002L0?ooo`0300000000o`00
0?l000800?l0?03oool00`3o0000003o0000o`0G0000o`@000008@3oool4003o0900oooo002K0?oo
o`D00?l0?P3oool3003o00T0oooo3@000?l00`000000oooo0?ooo`0S0?ooo`@00?l000<000000?oo
o`3oool0S03oool009X0oooo1@00o`0o0?ooo`<00?l0?@3oool4003o00030000003oool0oooo08/0
oooo002J0?ooo`0300000000o`000?l00440oooo0`00o`0n0?ooo`@00?l0S@3oool00=h0oooo0`00
o`0o0?ooo`<00?l000<000000?ooo`3oool0RP3oool00=h0oooo0`00o`100?ooo`03003o00000000
000008`0oooo003M0?ooo`<00?l0d03oool00=d0oooo0`00o`3@0?ooo`00g@3oool3003o0=00oooo
003M0?ooo`<00?l0d03oool00=d0oooo0`00o`000`000000oooo0?ooo`3=0?ooo`00g@3oool3003o
0=00oooo003M0?ooo`<00?l0d03oool00=d0oooo0`00o`3@0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {371.375, 0}} -> {-0.000281609, 0.0413396, \
0.00331572, 0.00331572}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(cilindro;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .92541 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-9.16151e-018 1.04704 -0.0137433 1.04704 [
[ 0 0 0 0 ]
[ 1 .92541 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .92541 L
0 .92541 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.621 .502 .697 r
.42006 .65561 m .41048 .61687 L .39404 .62192 L p F P
0 g
s
.621 .502 .697 r
.39404 .62192 m .40356 .66055 L .42006 .65561 L p F P
0 g
s
.634 .547 .738 r
.38083 .58436 m .39404 .62192 L .41048 .61687 L p F P
0 g
s
1 1 0 r
.007 w
.39363 .62075 m
.39442 .62345 L
s
.5 Mabswid
.634 .547 .738 r
.41048 .61687 m .39724 .5792 L .38083 .58436 L p F P
0 g
s
.645 .59 .778 r
.3644 .54927 m .38083 .58436 L .39724 .5792 L p F P
0 g
s
1 1 0 r
.007 w
.3803 .58321 m
.3811 .58514 L
s
.5 Mabswid
.605 .454 .65 r
.42561 .69397 m .42006 .65561 L .40356 .66055 L p F P
0 g
s
.605 .454 .65 r
.40356 .66055 m .409 .69882 L .42561 .69397 L p F P
0 g
s
1 1 0 r
.007 w
.40336 .65974 m
.40362 .66096 L
s
.5 Mabswid
.621 .502 .697 r
.43667 .65064 m .42702 .6118 L .41048 .61687 L p F P
0 g
s
.621 .502 .697 r
.41048 .61687 m .42006 .65561 L .43667 .65064 L p F P
0 g
s
.634 .547 .738 r
.39724 .5792 m .41048 .61687 L .42702 .6118 L p F P
0 g
s
.634 .547 .738 r
.42702 .6118 m .41376 .574 L .39724 .5792 L p F P
0 g
s
.645 .59 .778 r
.38084 .54397 m .39724 .5792 L .41376 .574 L p F P
0 g
s
.645 .59 .778 r
.39724 .5792 m .38084 .54397 L .3644 .54927 L p F P
0 g
s
.656 .637 .819 r
.34533 .51798 m .3644 .54927 L .38084 .54397 L p F P
0 g
s
1 1 0 r
.007 w
.36396 .54854 m
.36499 .55051 L
s
.5 Mabswid
.605 .454 .65 r
.44233 .6891 m .43667 .65064 L .42006 .65561 L p F P
0 g
s
.605 .454 .65 r
.42006 .65561 m .42561 .69397 L .44233 .6891 L p F P
0 g
s
.621 .502 .697 r
.45338 .64564 m .44366 .60669 L .42702 .6118 L p F P
0 g
s
.621 .502 .697 r
.42702 .6118 m .43667 .65064 L .45338 .64564 L p F P
0 g
s
.634 .547 .738 r
.41376 .574 m .42702 .6118 L .44366 .60669 L p F P
0 g
s
.634 .547 .738 r
.44366 .60669 m .43038 .56877 L .41376 .574 L p F P
0 g
s
.645 .59 .778 r
.39737 .53864 m .41376 .574 L .43038 .56877 L p F P
0 g
s
.645 .59 .778 r
.41376 .574 m .39737 .53864 L .38084 .54397 L p F P
0 g
s
.585 .398 .595 r
.42685 .73051 m .42561 .69397 L .409 .69882 L p F P
0 g
s
.585 .398 .595 r
.409 .69882 m .41009 .73528 L .42685 .73051 L p F P
0 g
s
1 1 0 r
.007 w
.4088 .69741 m
.40904 .70025 L
s
.5 Mabswid
.656 .637 .819 r
.36183 .51255 m .38084 .54397 L .39737 .53864 L p F P
0 g
s
.656 .637 .819 r
.38084 .54397 m .36183 .51255 L .34533 .51798 L p F P
0 g
s
.605 .454 .65 r
.45916 .68419 m .45338 .64564 L .43667 .65064 L p F P
0 g
s
.605 .454 .65 r
.43667 .65064 m .44233 .6891 L .45916 .68419 L p F P
0 g
s
.621 .502 .697 r
.4702 .64062 m .46041 .60155 L .44366 .60669 L p F P
0 g
s
.621 .502 .697 r
.44366 .60669 m .45338 .64564 L .4702 .64062 L p F P
0 g
s
.634 .547 .738 r
.43038 .56877 m .44366 .60669 L .46041 .60155 L p F P
0 g
s
.634 .547 .738 r
.46041 .60155 m .4471 .56351 L .43038 .56877 L p F P
0 g
s
.645 .59 .778 r
.41401 .53328 m .43038 .56877 L .4471 .56351 L p F P
0 g
s
.645 .59 .778 r
.43038 .56877 m .41401 .53328 L .39737 .53864 L p F P
0 g
s
.585 .398 .595 r
.44373 .72571 m .44233 .6891 L .42561 .69397 L p F P
0 g
s
.585 .398 .595 r
.42561 .69397 m .42685 .73051 L .44373 .72571 L p F P
0 g
s
.656 .637 .819 r
.37843 .50708 m .39737 .53864 L .41401 .53328 L p F P
0 g
s
.656 .637 .819 r
.39737 .53864 m .37843 .50708 L .36183 .51255 L p F P
0 g
s
.605 .454 .65 r
.47609 .67926 m .4702 .64062 L .45338 .64564 L p F P
0 g
s
.605 .454 .65 r
.45338 .64564 m .45916 .68419 L .47609 .67926 L p F P
0 g
s
.621 .502 .697 r
.48712 .63555 m .47726 .59638 L .46041 .60155 L p F P
0 g
s
.621 .502 .697 r
.46041 .60155 m .4702 .64062 L .48712 .63555 L p F P
0 g
s
.634 .547 .738 r
.4471 .56351 m .46041 .60155 L .47726 .59638 L p F P
0 g
s
.664 .69 .864 r
.32429 .4918 m .34533 .51798 L .36183 .51255 L p F P
0 g
s
1 1 0 r
.007 w
.34453 .51698 m
.34589 .51889 L
s
.5 Mabswid
.634 .547 .738 r
.47726 .59638 m .46392 .55821 L .4471 .56351 L p F P
0 g
s
.645 .59 .778 r
.43075 .52788 m .4471 .56351 L .46392 .55821 L p F P
0 g
s
.645 .59 .778 r
.4471 .56351 m .43075 .52788 L .41401 .53328 L p F P
0 g
s
.585 .398 .595 r
.4607 .72087 m .45916 .68419 L .44233 .6891 L p F P
0 g
s
.585 .398 .595 r
.44233 .6891 m .44373 .72571 L .4607 .72087 L p F P
0 g
s
.656 .637 .819 r
.39513 .50158 m .41401 .53328 L .43075 .52788 L p F P
0 g
s
.656 .637 .819 r
.41401 .53328 m .39513 .50158 L .37843 .50708 L p F P
0 g
s
.605 .454 .65 r
.49313 .67429 m .48712 .63555 L .4702 .64062 L p F P
0 g
s
.605 .454 .65 r
.4702 .64062 m .47609 .67926 L .49313 .67429 L p F P
0 g
s
.621 .502 .697 r
.50415 .63046 m .49421 .59118 L .47726 .59638 L p F P
0 g
s
.621 .502 .697 r
.47726 .59638 m .48712 .63555 L .50415 .63046 L p F P
0 g
s
.634 .547 .738 r
.46392 .55821 m .47726 .59638 L .49421 .59118 L p F P
0 g
s
.664 .69 .864 r
.34089 .48623 m .36183 .51255 L .37843 .50708 L p F P
0 g
s
.664 .69 .864 r
.36183 .51255 m .34089 .48623 L .32429 .4918 L p F P
0 g
s
.634 .547 .738 r
.49421 .59118 m .48086 .55288 L .46392 .55821 L p F P
0 g
s
.645 .59 .778 r
.4476 .52245 m .46392 .55821 L .48086 .55288 L p F P
0 g
s
.645 .59 .778 r
.46392 .55821 m .4476 .52245 L .43075 .52788 L p F P
0 g
s
.556 .327 .523 r
.42362 .76375 m .42685 .73051 L .41009 .73528 L p F P
0 g
s
.556 .327 .523 r
.41009 .73528 m .40668 .76847 L .42362 .76375 L p F P
0 g
s
.585 .398 .595 r
.47779 .71601 m .47609 .67926 L .45916 .68419 L p F P
0 g
s
.585 .398 .595 r
.45916 .68419 m .4607 .72087 L .47779 .71601 L p F P
0 g
s
.656 .637 .819 r
.41194 .49604 m .43075 .52788 L .4476 .52245 L p F P
0 g
s
.656 .637 .819 r
.43075 .52788 m .41194 .49604 L .39513 .50158 L p F P
0 g
s
.605 .454 .65 r
.51027 .66929 m .50415 .63046 L .48712 .63555 L p F P
0 g
s
.605 .454 .65 r
.48712 .63555 m .49313 .67429 L .51027 .66929 L p F P
0 g
s
.621 .502 .697 r
.52129 .62534 m .51128 .58594 L .49421 .59118 L p F P
0 g
s
.621 .502 .697 r
.49421 .59118 m .50415 .63046 L .52129 .62534 L p F P
0 g
s
.634 .547 .738 r
.48086 .55288 m .49421 .59118 L .51128 .58594 L p F P
0 g
s
.664 .69 .864 r
.3576 .48062 m .37843 .50708 L .39513 .50158 L p F P
0 g
s
.664 .69 .864 r
.37843 .50708 m .3576 .48062 L .34089 .48623 L p F P
0 g
s
.634 .547 .738 r
.51128 .58594 m .49789 .54752 L .48086 .55288 L p F P
0 g
s
.645 .59 .778 r
.46455 .51699 m .48086 .55288 L .49789 .54752 L p F P
0 g
s
.645 .59 .778 r
.48086 .55288 m .46455 .51699 L .4476 .52245 L p F P
0 g
s
.556 .327 .523 r
.44068 .75899 m .44373 .72571 L .42685 .73051 L p F P
0 g
s
.556 .327 .523 r
.42685 .73051 m .42362 .76375 L .44068 .75899 L p F P
0 g
s
.585 .398 .595 r
.49498 .71111 m .49313 .67429 L .47609 .67926 L p F P
0 g
s
.585 .398 .595 r
.47609 .67926 m .47779 .71601 L .49498 .71111 L p F P
0 g
s
.656 .637 .819 r
.42886 .49047 m .4476 .52245 L .46455 .51699 L p F P
0 g
s
.656 .637 .819 r
.4476 .52245 m .42886 .49047 L .41194 .49604 L p F P
0 g
s
.605 .454 .65 r
.52753 .66426 m .52129 .62534 L .50415 .63046 L p F P
0 g
s
.605 .454 .65 r
.50415 .63046 m .51027 .66929 L .52753 .66426 L p F P
0 g
s
.621 .502 .697 r
.53853 .62018 m .52845 .58067 L .51128 .58594 L p F P
0 g
s
.621 .502 .697 r
.51128 .58594 m .52129 .62534 L .53853 .62018 L p F P
0 g
s
.634 .547 .738 r
.49789 .54752 m .51128 .58594 L .52845 .58067 L p F P
0 g
s
.664 .69 .864 r
.37441 .47497 m .39513 .50158 L .41194 .49604 L p F P
0 g
s
.664 .69 .864 r
.39513 .50158 m .37441 .47497 L .3576 .48062 L p F P
0 g
s
.634 .547 .738 r
.52845 .58067 m .51504 .54213 L .49789 .54752 L p F P
0 g
s
.645 .59 .778 r
.48162 .51149 m .49789 .54752 L .51504 .54213 L p F P
0 g
s
.645 .59 .778 r
.49789 .54752 m .48162 .51149 L .46455 .51699 L p F P
0 g
s
.556 .327 .523 r
.45784 .75421 m .4607 .72087 L .44373 .72571 L p F P
0 g
s
.556 .327 .523 r
.44373 .72571 m .44068 .75899 L .45784 .75421 L p F P
0 g
s
.668 .753 .914 r
.30206 .47191 m .32429 .4918 L .34089 .48623 L p F P
0 g
s
1 1 0 r
.007 w
.32398 .49152 m
.32484 .49248 L
s
.5 Mabswid
.585 .398 .595 r
.51228 .70619 m .51027 .66929 L .49313 .67429 L p F P
0 g
s
.585 .398 .595 r
.49313 .67429 m .49498 .71111 L .51228 .70619 L p F P
0 g
s
.656 .637 .819 r
.44588 .48486 m .46455 .51699 L .48162 .51149 L p F P
0 g
s
.656 .637 .819 r
.46455 .51699 m .44588 .48486 L .42886 .49047 L p F P
0 g
s
.605 .454 .65 r
.54489 .65919 m .53853 .62018 L .52129 .62534 L p F P
0 g
s
.605 .454 .65 r
.52129 .62534 m .52753 .66426 L .54489 .65919 L p F P
0 g
s
.621 .502 .697 r
.55589 .61499 m .54573 .57537 L .52845 .58067 L p F P
0 g
s
.621 .502 .697 r
.52845 .58067 m .53853 .62018 L .55589 .61499 L p F P
0 g
s
.634 .547 .738 r
.51504 .54213 m .52845 .58067 L .54573 .57537 L p F P
0 g
s
.664 .69 .864 r
.39133 .46929 m .41194 .49604 L .42886 .49047 L p F P
0 g
s
.664 .69 .864 r
.41194 .49604 m .39133 .46929 L .37441 .47497 L p F P
0 g
s
.634 .547 .738 r
.54573 .57537 m .53229 .5367 L .51504 .54213 L p F P
0 g
s
.645 .59 .778 r
.49879 .50595 m .51504 .54213 L .53229 .5367 L p F P
0 g
s
.645 .59 .778 r
.51504 .54213 m .49879 .50595 L .48162 .51149 L p F P
0 g
s
.556 .327 .523 r
.47512 .7494 m .47779 .71601 L .4607 .72087 L p F P
0 g
s
.556 .327 .523 r
.4607 .72087 m .45784 .75421 L .47512 .7494 L p F P
0 g
s
.668 .753 .914 r
.3188 .4662 m .34089 .48623 L .3576 .48062 L p F P
0 g
s
.668 .753 .914 r
.34089 .48623 m .3188 .4662 L .30206 .47191 L p F P
0 g
s
.585 .398 .595 r
.5297 .70123 m .52753 .66426 L .51027 .66929 L p F P
0 g
s
.585 .398 .595 r
.51027 .66929 m .51228 .70619 L .5297 .70123 L p F P
0 g
s
.656 .637 .819 r
.46302 .47922 m .48162 .51149 L .49879 .50595 L p F P
0 g
s
.656 .637 .819 r
.48162 .51149 m .46302 .47922 L .44588 .48486 L p F P
0 g
s
.605 .454 .65 r
.56237 .6541 m .55589 .61499 L .53853 .62018 L p F P
0 g
s
.605 .454 .65 r
.53853 .62018 m .54489 .65919 L .56237 .6541 L p F P
0 g
s
.511 .226 .418 r
.4159 .79223 m .42362 .76375 L .40668 .76847 L p F P
0 g
s
.511 .226 .418 r
.40668 .76847 m .39874 .79692 L .4159 .79223 L p F P
0 g
s
1 1 0 r
.007 w
.40639 .7695 m
.40681 .76713 L
s
.5 Mabswid
.621 .502 .697 r
.57335 .60977 m .56312 .57004 L .54573 .57537 L p F P
0 g
s
.621 .502 .697 r
.54573 .57537 m .55589 .61499 L .57335 .60977 L p F P
0 g
s
.634 .547 .738 r
.53229 .5367 m .54573 .57537 L .56312 .57004 L p F P
0 g
s
.664 .69 .864 r
.40836 .46357 m .42886 .49047 L .44588 .48486 L p F P
0 g
s
.664 .69 .864 r
.42886 .49047 m .40836 .46357 L .39133 .46929 L p F P
0 g
s
.634 .547 .738 r
.56312 .57004 m .54966 .53123 L .53229 .5367 L p F P
0 g
s
.645 .59 .778 r
.51607 .50038 m .53229 .5367 L .54966 .53123 L p F P
0 g
s
.645 .59 .778 r
.53229 .5367 m .51607 .50038 L .49879 .50595 L p F P
0 g
s
.556 .327 .523 r
.4925 .74455 m .49498 .71111 L .47779 .71601 L p F P
0 g
s
.556 .327 .523 r
.47779 .71601 m .47512 .7494 L .4925 .74455 L p F P
0 g
s
.668 .753 .914 r
.33566 .46046 m .3576 .48062 L .37441 .47497 L p F P
0 g
s
.668 .753 .914 r
.3576 .48062 m .33566 .46046 L .3188 .4662 L p F P
0 g
s
.585 .398 .595 r
.54722 .69624 m .54489 .65919 L .52753 .66426 L p F P
0 g
s
.585 .398 .595 r
.52753 .66426 m .5297 .70123 L .54722 .69624 L p F P
0 g
s
.656 .637 .819 r
.48026 .47354 m .49879 .50595 L .51607 .50038 L p F P
0 g
s
.656 .637 .819 r
.49879 .50595 m .48026 .47354 L .46302 .47922 L p F P
0 g
s
.605 .454 .65 r
.57995 .64897 m .57335 .60977 L .55589 .61499 L p F P
0 g
s
.605 .454 .65 r
.55589 .61499 m .56237 .6541 L .57995 .64897 L p F P
0 g
s
.511 .226 .418 r
.43316 .7875 m .44068 .75899 L .42362 .76375 L p F P
0 g
s
.511 .226 .418 r
.42362 .76375 m .4159 .79223 L .43316 .7875 L p F P
0 g
s
.621 .502 .697 r
.59093 .60451 m .58062 .56466 L .56312 .57004 L p F P
0 g
s
.621 .502 .697 r
.56312 .57004 m .57335 .60977 L .59093 .60451 L p F P
0 g
s
.634 .547 .738 r
.54966 .53123 m .56312 .57004 L .58062 .56466 L p F P
0 g
s
.664 .69 .864 r
.4255 .45782 m .44588 .48486 L .46302 .47922 L p F P
0 g
s
.664 .69 .864 r
.44588 .48486 m .4255 .45782 L .40836 .46357 L p F P
0 g
s
.634 .547 .738 r
.58062 .56466 m .56714 .52573 L .54966 .53123 L p F P
0 g
s
.645 .59 .778 r
.53346 .49478 m .54966 .53123 L .56714 .52573 L p F P
0 g
s
.645 .59 .778 r
.54966 .53123 m .53346 .49478 L .51607 .50038 L p F P
0 g
s
.556 .327 .523 r
.51 .73968 m .51228 .70619 L .49498 .71111 L p F P
0 g
s
.556 .327 .523 r
.49498 .71111 m .4925 .74455 L .51 .73968 L p F P
0 g
s
.668 .753 .914 r
.35262 .45467 m .37441 .47497 L .39133 .46929 L p F P
0 g
s
.668 .753 .914 r
.37441 .47497 m .35262 .45467 L .33566 .46046 L p F P
0 g
s
.585 .398 .595 r
.56486 .69122 m .56237 .6541 L .54489 .65919 L p F P
0 g
s
.585 .398 .595 r
.54489 .65919 m .54722 .69624 L .56486 .69122 L p F P
0 g
s
.656 .637 .819 r
.49761 .46782 m .51607 .50038 L .53346 .49478 L p F P
0 g
s
.656 .637 .819 r
.51607 .50038 m .49761 .46782 L .48026 .47354 L p F P
0 g
s
.605 .454 .65 r
.59765 .64381 m .59093 .60451 L .57335 .60977 L p F P
0 g
s
.605 .454 .65 r
.57335 .60977 m .57995 .64897 L .59765 .64381 L p F P
0 g
s
.511 .226 .418 r
.45054 .78275 m .45784 .75421 L .44068 .75899 L p F P
0 g
s
.511 .226 .418 r
.44068 .75899 m .43316 .7875 L .45054 .78275 L p F P
0 g
s
.621 .502 .697 r
.60862 .59922 m .59823 .55926 L .58062 .56466 L p F P
0 g
s
.621 .502 .697 r
.58062 .56466 m .59093 .60451 L .60862 .59922 L p F P
0 g
s
.634 .547 .738 r
.56714 .52573 m .58062 .56466 L .59823 .55926 L p F P
0 g
s
.664 .69 .864 r
.44275 .45203 m .46302 .47922 L .48026 .47354 L p F P
0 g
s
.664 .69 .864 r
.46302 .47922 m .44275 .45203 L .4255 .45782 L p F P
0 g
s
.634 .547 .738 r
.59823 .55926 m .58472 .5202 L .56714 .52573 L p F P
0 g
s
.645 .59 .778 r
.55096 .48914 m .56714 .52573 L .58472 .5202 L p F P
0 g
s
.645 .59 .778 r
.56714 .52573 m .55096 .48914 L .53346 .49478 L p F P
0 g
s
.556 .327 .523 r
.52761 .73477 m .5297 .70123 L .51228 .70619 L p F P
0 g
s
.556 .327 .523 r
.51228 .70619 m .51 .73968 L .52761 .73477 L p F P
0 g
s
.668 .753 .914 r
.36969 .44885 m .39133 .46929 L .40836 .46357 L p F P
0 g
s
.668 .753 .914 r
.39133 .46929 m .36969 .44885 L .35262 .45467 L p F P
0 g
s
.657 .83 .966 r
.27951 .45939 m .30206 .47191 L .3188 .4662 L p F P
0 g
s
1 1 0 r
.007 w
.30117 .47142 m
.30285 .47262 L
s
.5 Mabswid
.585 .398 .595 r
.58262 .68617 m .57995 .64897 L .56237 .6541 L p F P
0 g
s
.585 .398 .595 r
.56237 .6541 m .56486 .69122 L .58262 .68617 L p F P
0 g
s
.656 .637 .819 r
.51508 .46207 m .53346 .49478 L .55096 .48914 L p F P
0 g
s
.656 .637 .819 r
.53346 .49478 m .51508 .46207 L .49761 .46782 L p F P
0 g
s
.605 .454 .65 r
.61547 .63862 m .60862 .59922 L .59093 .60451 L p F P
0 g
s
.605 .454 .65 r
.59093 .60451 m .59765 .64381 L .61547 .63862 L p F P
0 g
s
.511 .226 .418 r
.46803 .77796 m .47512 .7494 L .45784 .75421 L p F P
0 g
s
.511 .226 .418 r
.45784 .75421 m .45054 .78275 L .46803 .77796 L p F P
0 g
s
.621 .502 .697 r
.62642 .5939 m .61596 .55382 L .59823 .55926 L p F P
0 g
s
.621 .502 .697 r
.59823 .55926 m .60862 .59922 L .62642 .5939 L p F P
0 g
s
.634 .547 .738 r
.58472 .5202 m .59823 .55926 L .61596 .55382 L p F P
0 g
s
.664 .69 .864 r
.46011 .4462 m .48026 .47354 L .49761 .46782 L p F P
0 g
s
.664 .69 .864 r
.48026 .47354 m .46011 .4462 L .44275 .45203 L p F P
0 g
s
.634 .547 .738 r
.61596 .55382 m .60242 .51463 L .58472 .5202 L p F P
0 g
s
.645 .59 .778 r
.56857 .48346 m .58472 .5202 L .60242 .51463 L p F P
0 g
s
.645 .59 .778 r
.58472 .5202 m .56857 .48346 L .55096 .48914 L p F P
0 g
s
.556 .327 .523 r
.54534 .72983 m .54722 .69624 L .5297 .70123 L p F P
0 g
s
.556 .327 .523 r
.5297 .70123 m .52761 .73477 L .54534 .72983 L p F P
0 g
s
.668 .753 .914 r
.38687 .44299 m .40836 .46357 L .4255 .45782 L p F P
0 g
s
.668 .753 .914 r
.40836 .46357 m .38687 .44299 L .36969 .44885 L p F P
0 g
s
.657 .83 .966 r
.29643 .45355 m .3188 .4662 L .33566 .46046 L p F P
0 g
s
.657 .83 .966 r
.3188 .4662 m .29643 .45355 L .27951 .45939 L p F P
0 g
s
.585 .398 .595 r
.60049 .68108 m .59765 .64381 L .57995 .64897 L p F P
0 g
s
.585 .398 .595 r
.57995 .64897 m .58262 .68617 L .60049 .68108 L p F P
0 g
s
.656 .637 .819 r
.53265 .45628 m .55096 .48914 L .56857 .48346 L p F P
0 g
s
.656 .637 .819 r
.55096 .48914 m .53265 .45628 L .51508 .46207 L p F P
0 g
s
.605 .454 .65 r
.6334 .63339 m .62642 .5939 L .60862 .59922 L p F P
0 g
s
.605 .454 .65 r
.60862 .59922 m .61547 .63862 L .6334 .63339 L p F P
0 g
s
.511 .226 .418 r
.48564 .77314 m .4925 .74455 L .47512 .7494 L p F P
0 g
s
.511 .226 .418 r
.47512 .7494 m .46803 .77796 L .48564 .77314 L p F P
0 g
s
.621 .502 .697 r
.64434 .58854 m .6338 .54835 L .61596 .55382 L p F P
0 g
s
.621 .502 .697 r
.61596 .55382 m .62642 .5939 L .64434 .58854 L p F P
0 g
s
.634 .547 .738 r
.60242 .51463 m .61596 .55382 L .6338 .54835 L p F P
0 g
s
.664 .69 .864 r
.47758 .44033 m .49761 .46782 L .51508 .46207 L p F P
0 g
s
.664 .69 .864 r
.49761 .46782 m .47758 .44033 L .46011 .4462 L p F P
0 g
s
.427 .064 .243 r
.40382 .81455 m .4159 .79223 L .39874 .79692 L p F P
0 g
s
.427 .064 .243 r
.39874 .79692 m .38644 .81925 L .40382 .81455 L p F P
0 g
s
1 1 0 r
.007 w
.39849 .79738 m
.39883 .79661 L
s
.5 Mabswid
.634 .547 .738 r
.6338 .54835 m .62024 .50902 L .60242 .51463 L p F P
0 g
s
.645 .59 .778 r
.5863 .47775 m .60242 .51463 L .62024 .50902 L p F P
0 g
s
.645 .59 .778 r
.60242 .51463 m .5863 .47775 L .56857 .48346 L p F P
0 g
s
.556 .327 .523 r
.56318 .72486 m .56486 .69122 L .54722 .69624 L p F P
0 g
s
.556 .327 .523 r
.54722 .69624 m .54534 .72983 L .56318 .72486 L p F P
0 g
s
.668 .753 .914 r
.40416 .4371 m .4255 .45782 L .44275 .45203 L p F P
0 g
s
.668 .753 .914 r
.4255 .45782 m .40416 .4371 L .38687 .44299 L p F P
0 g
s
.657 .83 .966 r
.31346 .44768 m .33566 .46046 L .35262 .45467 L p F P
0 g
s
.657 .83 .966 r
.33566 .46046 m .31346 .44768 L .29643 .45355 L p F P
0 g
s
.585 .398 .595 r
.61847 .67596 m .61547 .63862 L .59765 .64381 L p F P
0 g
s
.585 .398 .595 r
.59765 .64381 m .60049 .68108 L .61847 .67596 L p F P
0 g
s
.656 .637 .819 r
.55034 .45045 m .56857 .48346 L .5863 .47775 L p F P
0 g
s
.656 .637 .819 r
.56857 .48346 m .55034 .45045 L .53265 .45628 L p F P
0 g
s
.605 .454 .65 r
.65144 .62813 m .64434 .58854 L .62642 .5939 L p F P
0 g
s
.605 .454 .65 r
.62642 .5939 m .6334 .63339 L .65144 .62813 L p F P
0 g
s
.511 .226 .418 r
.50336 .76829 m .51 .73968 L .4925 .74455 L p F P
0 g
s
.511 .226 .418 r
.4925 .74455 m .48564 .77314 L .50336 .76829 L p F P
0 g
s
.621 .502 .697 r
.66237 .58314 m .65175 .54284 L .6338 .54835 L p F P
0 g
s
.621 .502 .697 r
.6338 .54835 m .64434 .58854 L .66237 .58314 L p F P
0 g
s
.634 .547 .738 r
.62024 .50902 m .6338 .54835 L .65175 .54284 L p F P
0 g
s
.664 .69 .864 r
.49517 .43443 m .51508 .46207 L .53265 .45628 L p F P
0 g
s
.664 .69 .864 r
.51508 .46207 m .49517 .43443 L .47758 .44033 L p F P
0 g
s
.427 .064 .243 r
.42131 .80983 m .43316 .7875 L .4159 .79223 L p F P
0 g
s
.427 .064 .243 r
.4159 .79223 m .40382 .81455 L .42131 .80983 L p F P
0 g
s
.634 .547 .738 r
.65175 .54284 m .63817 .50338 L .62024 .50902 L p F P
0 g
s
.645 .59 .778 r
.60414 .472 m .62024 .50902 L .63817 .50338 L p F P
0 g
s
.645 .59 .778 r
.62024 .50902 m .60414 .472 L .5863 .47775 L p F P
0 g
s
.556 .327 .523 r
.58113 .71986 m .58262 .68617 L .56486 .69122 L p F P
0 g
s
.556 .327 .523 r
.56486 .69122 m .56318 .72486 L .58113 .71986 L p F P
0 g
s
.668 .753 .914 r
.42157 .43116 m .44275 .45203 L .46011 .4462 L p F P
0 g
s
.668 .753 .914 r
.44275 .45203 m .42157 .43116 L .40416 .4371 L p F P
0 g
s
.657 .83 .966 r
.3306 .44177 m .35262 .45467 L .36969 .44885 L p F P
0 g
s
.657 .83 .966 r
.35262 .45467 m .3306 .44177 L .31346 .44768 L p F P
0 g
s
.585 .398 .595 r
.63657 .67081 m .6334 .63339 L .61547 .63862 L p F P
0 g
s
.585 .398 .595 r
.61547 .63862 m .61847 .67596 L .63657 .67081 L p F P
0 g
s
.656 .637 .819 r
.56815 .44458 m .5863 .47775 L .60414 .472 L p F P
0 g
s
.656 .637 .819 r
.5863 .47775 m .56815 .44458 L .55034 .45045 L p F P
0 g
s
.605 .454 .65 r
.66961 .62283 m .66237 .58314 L .64434 .58854 L p F P
0 g
s
.605 .454 .65 r
.64434 .58854 m .65144 .62813 L .66961 .62283 L p F P
0 g
s
.511 .226 .418 r
.52119 .76341 m .52761 .73477 L .51 .73968 L p F P
0 g
s
.511 .226 .418 r
.51 .73968 m .50336 .76829 L .52119 .76341 L p F P
0 g
s
.621 .502 .697 r
.68052 .57772 m .66983 .53729 L .65175 .54284 L p F P
0 g
s
.621 .502 .697 r
.65175 .54284 m .66237 .58314 L .68052 .57772 L p F P
0 g
s
.634 .547 .738 r
.63817 .50338 m .65175 .54284 L .66983 .53729 L p F P
0 g
s
.664 .69 .864 r
.51287 .42849 m .53265 .45628 L .55034 .45045 L p F P
0 g
s
.664 .69 .864 r
.53265 .45628 m .51287 .42849 L .49517 .43443 L p F P
0 g
s
.427 .064 .243 r
.43892 .80507 m .45054 .78275 L .43316 .7875 L p F P
0 g
s
.427 .064 .243 r
.43316 .7875 m .42131 .80983 L .43892 .80507 L p F P
0 g
s
.634 .547 .738 r
.66983 .53729 m .65622 .4977 L .63817 .50338 L p F P
0 g
s
.645 .59 .778 r
.6221 .46621 m .63817 .50338 L .65622 .4977 L p F P
0 g
s
.645 .59 .778 r
.63817 .50338 m .6221 .46621 L .60414 .472 L p F P
0 g
s
.556 .327 .523 r
.59921 .71482 m .60049 .68108 L .58262 .68617 L p F P
0 g
s
.556 .327 .523 r
.58262 .68617 m .58113 .71986 L .59921 .71482 L p F P
0 g
s
.668 .753 .914 r
.43909 .42519 m .46011 .4462 L .47758 .44033 L p F P
0 g
s
.668 .753 .914 r
.46011 .4462 m .43909 .42519 L .42157 .43116 L p F P
0 g
s
.657 .83 .966 r
.34786 .43582 m .36969 .44885 L .38687 .44299 L p F P
0 g
s
.657 .83 .966 r
.36969 .44885 m .34786 .43582 L .3306 .44177 L p F P
0 g
s
.585 .398 .595 r
.6548 .66562 m .65144 .62813 L .6334 .63339 L p F P
0 g
s
.585 .398 .595 r
.6334 .63339 m .63657 .67081 L .6548 .66562 L p F P
0 g
s
.656 .637 .819 r
.58607 .43868 m .60414 .472 L .6221 .46621 L p F P
0 g
s
.656 .637 .819 r
.60414 .472 m .58607 .43868 L .56815 .44458 L p F P
0 g
s
.605 .454 .65 r
.68789 .6175 m .68052 .57772 L .66237 .58314 L p F P
0 g
s
.605 .454 .65 r
.66237 .58314 m .66961 .62283 L .68789 .6175 L p F P
0 g
s
.511 .226 .418 r
.53915 .75849 m .54534 .72983 L .52761 .73477 L p F P
0 g
s
.511 .226 .418 r
.52761 .73477 m .52119 .76341 L .53915 .75849 L p F P
0 g
s
.591 .902 .985 r
.25761 .4551 m .27951 .45939 L .29643 .45355 L p F P
0 g
s
1 1 0 r
.007 w
.27943 .45937 m
.2797 .45949 L
s
.5 Mabswid
.621 .502 .697 r
.69879 .57225 m .68802 .53171 L .66983 .53729 L p F P
0 g
s
.621 .502 .697 r
.66983 .53729 m .68052 .57772 L .69879 .57225 L p F P
0 g
s
.634 .547 .738 r
.65622 .4977 m .66983 .53729 L .68802 .53171 L p F P
0 g
s
.664 .69 .864 r
.53069 .42251 m .55034 .45045 L .56815 .44458 L p F P
0 g
s
.664 .69 .864 r
.55034 .45045 m .53069 .42251 L .51287 .42849 L p F P
0 g
s
.427 .064 .243 r
.45665 .80028 m .46803 .77796 L .45054 .78275 L p F P
0 g
s
.427 .064 .243 r
.45054 .78275 m .43892 .80507 L .45665 .80028 L p F P
0 g
s
.634 .547 .738 r
.68802 .53171 m .67438 .49198 L .65622 .4977 L p F P
0 g
s
.645 .59 .778 r
.64018 .46038 m .65622 .4977 L .67438 .49198 L p F P
0 g
s
.645 .59 .778 r
.65622 .4977 m .64018 .46038 L .6221 .46621 L p F P
0 g
s
.556 .327 .523 r
.61741 .70975 m .61847 .67596 L .60049 .68108 L p F P
0 g
s
.556 .327 .523 r
.60049 .68108 m .59921 .71482 L .61741 .70975 L p F P
0 g
s
.668 .753 .914 r
.45672 .41918 m .47758 .44033 L .49517 .43443 L p F P
0 g
s
.668 .753 .914 r
.47758 .44033 m .45672 .41918 L .43909 .42519 L p F P
0 g
s
.657 .83 .966 r
.36523 .42983 m .38687 .44299 L .40416 .4371 L p F P
0 g
s
.657 .83 .966 r
.38687 .44299 m .36523 .42983 L .34786 .43582 L p F P
0 g
s
.585 .398 .595 r
.67314 .6604 m .66961 .62283 L .65144 .62813 L p F P
0 g
s
.585 .398 .595 r
.65144 .62813 m .6548 .66562 L .67314 .6604 L p F P
0 g
s
.656 .637 .819 r
.60412 .43274 m .6221 .46621 L .64018 .46038 L p F P
0 g
s
.656 .637 .819 r
.6221 .46621 m .60412 .43274 L .58607 .43868 L p F P
0 g
s
.605 .454 .65 r
.70629 .61213 m .69879 .57225 L .68052 .57772 L p F P
0 g
s
.605 .454 .65 r
.68052 .57772 m .68789 .6175 L .70629 .61213 L p F P
0 g
s
.511 .226 .418 r
.55722 .75355 m .56318 .72486 L .54534 .72983 L p F P
0 g
s
.511 .226 .418 r
.54534 .72983 m .53915 .75849 L .55722 .75355 L p F P
0 g
s
.591 .902 .985 r
.27473 .44916 m .29643 .45355 L .31346 .44768 L p F P
0 g
s
.591 .902 .985 r
.29643 .45355 m .27473 .44916 L .25761 .4551 L p F P
0 g
s
.621 .502 .697 r
.71718 .56675 m .70632 .52609 L .68802 .53171 L p F P
0 g
s
.621 .502 .697 r
.68802 .53171 m .69879 .57225 L .71718 .56675 L p F P
0 g
s
.634 .547 .738 r
.67438 .49198 m .68802 .53171 L .70632 .52609 L p F P
0 g
s
.664 .69 .864 r
.54862 .41648 m .56815 .44458 L .58607 .43868 L p F P
0 g
s
.664 .69 .864 r
.56815 .44458 m .54862 .41648 L .53069 .42251 L p F P
0 g
s
.427 .064 .243 r
.4745 .79546 m .48564 .77314 L .46803 .77796 L p F P
0 g
s
.427 .064 .243 r
.46803 .77796 m .45665 .80028 L .4745 .79546 L p F P
0 g
s
.634 .547 .738 r
.70632 .52609 m .69266 .48623 L .67438 .49198 L p F P
0 g
s
.645 .59 .778 r
.65837 .45452 m .67438 .49198 L .69266 .48623 L p F P
0 g
s
.645 .59 .778 r
.67438 .49198 m .65837 .45452 L .64018 .46038 L p F P
0 g
s
.556 .327 .523 r
.63572 .70465 m .63657 .67081 L .61847 .67596 L p F P
0 g
s
.556 .327 .523 r
.61847 .67596 m .61741 .70975 L .63572 .70465 L p F P
0 g
s
.668 .753 .914 r
.47447 .41312 m .49517 .43443 L .51287 .42849 L p F P
0 g
s
.668 .753 .914 r
.49517 .43443 m .47447 .41312 L .45672 .41918 L p F P
0 g
s
.657 .83 .966 r
.38271 .4238 m .40416 .4371 L .42157 .43116 L p F P
0 g
s
.657 .83 .966 r
.40416 .4371 m .38271 .4238 L .36523 .42983 L p F P
0 g
s
.585 .398 .595 r
.6916 .65514 m .68789 .6175 L .66961 .62283 L p F P
0 g
s
.585 .398 .595 r
.66961 .62283 m .67314 .6604 L .6916 .65514 L p F P
0 g
s
.656 .637 .819 r
.62227 .42675 m .64018 .46038 L .65837 .45452 L p F P
0 g
s
.656 .637 .819 r
.64018 .46038 m .62227 .42675 L .60412 .43274 L p F P
0 g
s
.605 .454 .65 r
.72482 .60673 m .71718 .56675 L .69879 .57225 L p F P
0 g
s
.605 .454 .65 r
.69879 .57225 m .70629 .61213 L .72482 .60673 L p F P
0 g
s
.511 .226 .418 r
.57542 .74857 m .58113 .71986 L .56318 .72486 L p F P
0 g
s
.511 .226 .418 r
.56318 .72486 m .55722 .75355 L .57542 .74857 L p F P
0 g
s
.591 .902 .985 r
.29197 .44318 m .31346 .44768 L .3306 .44177 L p F P
0 g
s
.591 .902 .985 r
.31346 .44768 m .29197 .44318 L .27473 .44916 L p F P
0 g
s
.621 .502 .697 r
.73569 .56122 m .72475 .52044 L .70632 .52609 L p F P
0 g
s
.621 .502 .697 r
.70632 .52609 m .71718 .56675 L .73569 .56122 L p F P
0 g
s
.634 .547 .738 r
.69266 .48623 m .70632 .52609 L .72475 .52044 L p F P
0 g
s
.244 0 0 r
.38772 .82945 m .40382 .81455 L .38644 .81925 L p F P
0 g
s
.244 0 0 r
.38644 .81925 m .3701 .83417 L .38772 .82945 L p F P
0 g
s
1 1 0 r
.007 w
.38594 .8197 m
.38693 .81835 L
s
.5 Mabswid
.664 .69 .864 r
.56667 .41042 m .58607 .43868 L .60412 .43274 L p F P
0 g
s
.664 .69 .864 r
.58607 .43868 m .56667 .41042 L .54862 .41648 L p F P
0 g
s
.427 .064 .243 r
.49246 .79061 m .50336 .76829 L .48564 .77314 L p F P
0 g
s
.427 .064 .243 r
.48564 .77314 m .4745 .79546 L .49246 .79061 L p F P
0 g
s
.634 .547 .738 r
.72475 .52044 m .71107 .48044 L .69266 .48623 L p F P
0 g
s
.645 .59 .778 r
.67669 .44861 m .69266 .48623 L .71107 .48044 L p F P
0 g
s
.645 .59 .778 r
.69266 .48623 m .67669 .44861 L .65837 .45452 L p F P
0 g
s
.556 .327 .523 r
.65416 .69951 m .6548 .66562 L .63657 .67081 L p F P
0 g
s
.556 .327 .523 r
.63657 .67081 m .63572 .70465 L .65416 .69951 L p F P
0 g
s
.668 .753 .914 r
.49234 .40703 m .51287 .42849 L .53069 .42251 L p F P
0 g
s
.668 .753 .914 r
.51287 .42849 m .49234 .40703 L .47447 .41312 L p F P
0 g
s
.657 .83 .966 r
.40031 .41773 m .42157 .43116 L .43909 .42519 L p F P
0 g
s
.657 .83 .966 r
.42157 .43116 m .40031 .41773 L .38271 .4238 L p F P
0 g
s
.585 .398 .595 r
.71018 .64985 m .70629 .61213 L .68789 .6175 L p F P
0 g
s
.585 .398 .595 r
.68789 .6175 m .6916 .65514 L .71018 .64985 L p F P
0 g
s
.656 .637 .819 r
.64055 .42073 m .65837 .45452 L .67669 .44861 L p F P
0 g
s
.656 .637 .819 r
.65837 .45452 m .64055 .42073 L .62227 .42675 L p F P
0 g
s
.605 .454 .65 r
.74346 .6013 m .73569 .56122 L .71718 .56675 L p F P
0 g
s
.605 .454 .65 r
.71718 .56675 m .72482 .60673 L .74346 .6013 L p F P
0 g
s
.511 .226 .418 r
.59373 .74355 m .59921 .71482 L .58113 .71986 L p F P
0 g
s
.511 .226 .418 r
.58113 .71986 m .57542 .74857 L .59373 .74355 L p F P
0 g
s
.591 .902 .985 r
.30932 .43715 m .3306 .44177 L .34786 .43582 L p F P
0 g
s
.591 .902 .985 r
.3306 .44177 m .30932 .43715 L .29197 .44318 L p F P
0 g
s
.621 .502 .697 r
.75432 .55565 m .7433 .51474 L .72475 .52044 L p F P
0 g
s
.621 .502 .697 r
.72475 .52044 m .73569 .56122 L .75432 .55565 L p F P
0 g
s
.634 .547 .738 r
.71107 .48044 m .72475 .52044 L .7433 .51474 L p F P
0 g
s
.244 0 0 r
.40545 .82469 m .42131 .80983 L .40382 .81455 L p F P
0 g
s
.244 0 0 r
.40382 .81455 m .38772 .82945 L .40545 .82469 L p F P
0 g
s
.664 .69 .864 r
.58485 .40432 m .60412 .43274 L .62227 .42675 L p F P
0 g
s
.664 .69 .864 r
.60412 .43274 m .58485 .40432 L .56667 .41042 L p F P
0 g
s
.427 .064 .243 r
.51054 .78572 m .52119 .76341 L .50336 .76829 L p F P
0 g
s
.427 .064 .243 r
.50336 .76829 m .49246 .79061 L .51054 .78572 L p F P
0 g
s
.634 .547 .738 r
.7433 .51474 m .72959 .47461 L .71107 .48044 L p F P
0 g
s
.645 .59 .778 r
.69512 .44267 m .71107 .48044 L .72959 .47461 L p F P
0 g
s
.645 .59 .778 r
.71107 .48044 m .69512 .44267 L .67669 .44861 L p F P
0 g
s
.556 .327 .523 r
.67272 .69434 m .67314 .6604 L .6548 .66562 L p F P
0 g
s
.556 .327 .523 r
.6548 .66562 m .65416 .69951 L .67272 .69434 L p F P
0 g
s
.668 .753 .914 r
.51033 .4009 m .53069 .42251 L .54862 .41648 L p F P
0 g
s
.668 .753 .914 r
.53069 .42251 m .51033 .4009 L .49234 .40703 L p F P
0 g
s
.657 .83 .966 r
.41802 .41162 m .43909 .42519 L .45672 .41918 L p F P
0 g
s
.657 .83 .966 r
.43909 .42519 m .41802 .41162 L .40031 .41773 L p F P
0 g
s
.585 .398 .595 r
.72889 .64452 m .72482 .60673 L .70629 .61213 L p F P
0 g
s
.585 .398 .595 r
.70629 .61213 m .71018 .64985 L .72889 .64452 L p F P
0 g
s
.656 .637 .819 r
.65895 .41467 m .67669 .44861 L .69512 .44267 L p F P
0 g
s
.656 .637 .819 r
.67669 .44861 m .65895 .41467 L .64055 .42073 L p F P
0 g
s
.605 .454 .65 r
.76223 .59582 m .75432 .55565 L .73569 .56122 L p F P
0 g
s
.605 .454 .65 r
.73569 .56122 m .74346 .6013 L .76223 .59582 L p F P
0 g
s
.511 .226 .418 r
.61217 .73851 m .61741 .70975 L .59921 .71482 L p F P
0 g
s
.511 .226 .418 r
.59921 .71482 m .59373 .74355 L .61217 .73851 L p F P
0 g
s
.591 .902 .985 r
.32679 .43109 m .34786 .43582 L .36523 .42983 L p F P
0 g
s
.591 .902 .985 r
.34786 .43582 m .32679 .43109 L .30932 .43715 L p F P
0 g
s
.621 .502 .697 r
.77308 .55004 m .76197 .50901 L .7433 .51474 L p F P
0 g
s
.621 .502 .697 r
.7433 .51474 m .75432 .55565 L .77308 .55004 L p F P
0 g
s
.634 .547 .738 r
.72959 .47461 m .7433 .51474 L .76197 .50901 L p F P
0 g
s
.244 0 0 r
.4233 .8199 m .43892 .80507 L .42131 .80983 L p F P
0 g
s
.244 0 0 r
.42131 .80983 m .40545 .82469 L .4233 .8199 L p F P
0 g
s
.664 .69 .864 r
.60314 .39818 m .62227 .42675 L .64055 .42073 L p F P
0 g
s
.664 .69 .864 r
.62227 .42675 m .60314 .39818 L .58485 .40432 L p F P
0 g
s
.427 .064 .243 r
.52875 .78081 m .53915 .75849 L .52119 .76341 L p F P
0 g
s
.427 .064 .243 r
.52119 .76341 m .51054 .78572 L .52875 .78081 L p F P
0 g
s
.634 .547 .738 r
.76197 .50901 m .74823 .46874 L .72959 .47461 L p F P
0 g
s
.645 .59 .778 r
.71368 .43669 m .72959 .47461 L .74823 .46874 L p F P
0 g
s
.645 .59 .778 r
.72959 .47461 m .71368 .43669 L .69512 .44267 L p F P
0 g
s
.556 .327 .523 r
.6914 .68913 m .6916 .65514 L .67314 .6604 L p F P
0 g
s
.556 .327 .523 r
.67314 .6604 m .67272 .69434 L .6914 .68913 L p F P
0 g
s
.668 .753 .914 r
.52844 .39472 m .54862 .41648 L .56667 .41042 L p F P
0 g
s
.668 .753 .914 r
.54862 .41648 m .52844 .39472 L .51033 .4009 L p F P
0 g
s
.657 .83 .966 r
.43586 .40547 m .45672 .41918 L .47447 .41312 L p F P
0 g
s
.657 .83 .966 r
.45672 .41918 m .43586 .40547 L .41802 .41162 L p F P
0 g
s
.585 .398 .595 r
.74772 .63916 m .74346 .6013 L .72482 .60673 L p F P
0 g
s
.585 .398 .595 r
.72482 .60673 m .72889 .64452 L .74772 .63916 L p F P
0 g
s
.656 .637 .819 r
.67747 .40857 m .69512 .44267 L .71368 .43669 L p F P
0 g
s
.656 .637 .819 r
.69512 .44267 m .67747 .40857 L .65895 .41467 L p F P
0 g
s
.605 .454 .65 r
.78113 .59031 m .77308 .55004 L .75432 .55565 L p F P
0 g
s
.605 .454 .65 r
.75432 .55565 m .76223 .59582 L .78113 .59031 L p F P
0 g
s
.337 .816 .785 r
.23739 .45965 m .25761 .4551 L .27473 .44916 L p F P
0 g
s
1 1 0 r
.007 w
.25686 .45527 m
.25848 .45527 L
s
.5 Mabswid
.511 .226 .418 r
.63073 .73343 m .63572 .70465 L .61741 .70975 L p F P
0 g
s
.511 .226 .418 r
.61741 .70975 m .61217 .73851 L .63073 .73343 L p F P
0 g
s
.591 .902 .985 r
.34437 .42498 m .36523 .42983 L .38271 .4238 L p F P
0 g
s
.591 .902 .985 r
.36523 .42983 m .34437 .42498 L .32679 .43109 L p F P
0 g
s
.621 .502 .697 r
.79196 .54439 m .78077 .50325 L .76197 .50901 L p F P
0 g
s
.621 .502 .697 r
.76197 .50901 m .77308 .55004 L .79196 .54439 L p F P
0 g
s
.634 .547 .738 r
.74823 .46874 m .76197 .50901 L .78077 .50325 L p F P
0 g
s
.244 0 0 r
.44127 .81509 m .45665 .80028 L .43892 .80507 L p F P
0 g
s
.244 0 0 r
.43892 .80507 m .4233 .8199 L .44127 .81509 L p F P
0 g
s
.664 .69 .864 r
.62156 .392 m .64055 .42073 L .65895 .41467 L p F P
0 g
s
.664 .69 .864 r
.64055 .42073 m .62156 .392 L .60314 .39818 L p F P
0 g
s
.427 .064 .243 r
.54707 .77586 m .55722 .75355 L .53915 .75849 L p F P
0 g
s
.427 .064 .243 r
.53915 .75849 m .52875 .78081 L .54707 .77586 L p F P
0 g
s
.634 .547 .738 r
.78077 .50325 m .767 .46283 L .74823 .46874 L p F P
0 g
s
.645 .59 .778 r
.73235 .43067 m .74823 .46874 L .767 .46283 L p F P
0 g
s
.645 .59 .778 r
.74823 .46874 m .73235 .43067 L .71368 .43669 L p F P
0 g
s
.556 .327 .523 r
.71021 .68389 m .71018 .64985 L .6916 .65514 L p F P
0 g
s
.556 .327 .523 r
.6916 .65514 m .6914 .68913 L .71021 .68389 L p F P
0 g
s
.668 .753 .914 r
.54667 .38851 m .56667 .41042 L .58485 .40432 L p F P
0 g
s
.668 .753 .914 r
.56667 .41042 m .54667 .38851 L .52844 .39472 L p F P
0 g
s
.657 .83 .966 r
.45381 .39928 m .47447 .41312 L .49234 .40703 L p F P
0 g
s
.657 .83 .966 r
.47447 .41312 m .45381 .39928 L .43586 .40547 L p F P
0 g
s
.585 .398 .595 r
.76668 .63377 m .76223 .59582 L .74346 .6013 L p F P
0 g
s
.585 .398 .595 r
.74346 .6013 m .74772 .63916 L .76668 .63377 L p F P
0 g
s
.656 .637 .819 r
.69612 .40243 m .71368 .43669 L .73235 .43067 L p F P
0 g
s
.656 .637 .819 r
.71368 .43669 m .69612 .40243 L .67747 .40857 L p F P
0 g
s
.605 .454 .65 r
.80015 .58477 m .79196 .54439 L .77308 .55004 L p F P
0 g
s
.605 .454 .65 r
.77308 .55004 m .78113 .59031 L .80015 .58477 L p F P
0 g
s
.337 .816 .785 r
.25474 .45362 m .27473 .44916 L .29197 .44318 L p F P
0 g
s
.337 .816 .785 r
.27473 .44916 m .25474 .45362 L .23739 .45965 L p F P
0 g
s
1 1 0 r
.007 w
.24559 .45665 m
.24647 .4565 L
s
.5 Mabswid
.511 .226 .418 r
.64941 .72831 m .65416 .69951 L .63572 .70465 L p F P
0 g
s
.511 .226 .418 r
.63572 .70465 m .63073 .73343 L .64941 .72831 L p F P
0 g
s
.591 .902 .985 r
.36207 .41884 m .38271 .4238 L .40031 .41773 L p F P
0 g
s
.591 .902 .985 r
.38271 .4238 m .36207 .41884 L .34437 .42498 L p F P
0 g
s
.621 .502 .697 r
.81096 .53871 m .79969 .49744 L .78077 .50325 L p F P
0 g
s
.621 .502 .697 r
.78077 .50325 m .79196 .54439 L .81096 .53871 L p F P
0 g
s
.634 .547 .738 r
.767 .46283 m .78077 .50325 L .79969 .49744 L p F P
0 g
s
.244 0 0 r
.45937 .81023 m .4745 .79546 L .45665 .80028 L p F P
0 g
s
.244 0 0 r
.45665 .80028 m .44127 .81509 L .45937 .81023 L p F P
0 g
s
.664 .69 .864 r
.64009 .38577 m .65895 .41467 L .67747 .40857 L p F P
0 g
s
.664 .69 .864 r
.65895 .41467 m .64009 .38577 L .62156 .392 L p F P
0 g
s
.427 .064 .243 r
.56552 .77087 m .57542 .74857 L .55722 .75355 L p F P
0 g
s
.427 .064 .243 r
.55722 .75355 m .54707 .77586 L .56552 .77087 L p F P
0 g
s
.634 .547 .738 r
.79969 .49744 m .7859 .45689 L .767 .46283 L p F P
0 g
s
.645 .59 .778 r
.75116 .42461 m .767 .46283 L .7859 .45689 L p F P
0 g
s
.645 .59 .778 r
.767 .46283 m .75116 .42461 L .73235 .43067 L p F P
0 g
s
.556 .327 .523 r
.72914 .67862 m .72889 .64452 L .71018 .64985 L p F P
0 g
s
.556 .327 .523 r
.71018 .64985 m .71021 .68389 L .72914 .67862 L p F P
0 g
s
.668 .753 .914 r
.56502 .38225 m .58485 .40432 L .60314 .39818 L p F P
0 g
s
.668 .753 .914 r
.58485 .40432 m .56502 .38225 L .54667 .38851 L p F P
0 g
s
.657 .83 .966 r
.47189 .39305 m .49234 .40703 L .51033 .4009 L p F P
0 g
s
.657 .83 .966 r
.49234 .40703 m .47189 .39305 L .45381 .39928 L p F P
0 g
s
.585 .398 .595 r
.78577 .62833 m .78113 .59031 L .76223 .59582 L p F P
0 g
s
.585 .398 .595 r
.76223 .59582 m .76668 .63377 L .78577 .62833 L p F P
0 g
s
.656 .637 .819 r
.71489 .39624 m .73235 .43067 L .75116 .42461 L p F P
0 g
s
.656 .637 .819 r
.73235 .43067 m .71489 .39624 L .69612 .40243 L p F P
0 g
s
.605 .454 .65 r
.8193 .57918 m .81096 .53871 L .79196 .54439 L p F P
0 g
s
.605 .454 .65 r
.79196 .54439 m .80015 .58477 L .8193 .57918 L p F P
0 g
s
.337 .816 .785 r
.2722 .44755 m .29197 .44318 L .30932 .43715 L p F P
0 g
s
.337 .816 .785 r
.29197 .44318 m .2722 .44755 L .25474 .45362 L p F P
0 g
s
.511 .226 .418 r
.66823 .72316 m .67272 .69434 L .65416 .69951 L p F P
0 g
s
.511 .226 .418 r
.65416 .69951 m .64941 .72831 L .66823 .72316 L p F P
0 g
s
0 0 0 r
.36815 .83584 m .38772 .82945 L .3701 .83417 L p F P
0 g
s
0 0 0 r
.3701 .83417 m .3503 .84062 L .36815 .83584 L p F P
0 g
s
1 1 0 r
.007 w
.36429 .83712 m
.36524 .83662 L
s
.36946 .83438 m
.37045 .83386 L
s
.5 Mabswid
.591 .902 .985 r
.37989 .41265 m .40031 .41773 L .41802 .41162 L p F P
0 g
s
.591 .902 .985 r
.40031 .41773 m .37989 .41265 L .36207 .41884 L p F P
0 g
s
.621 .502 .697 r
.83009 .53299 m .81873 .4916 L .79969 .49744 L p F P
0 g
s
.621 .502 .697 r
.79969 .49744 m .81096 .53871 L .83009 .53299 L p F P
0 g
s
.634 .547 .738 r
.7859 .45689 m .79969 .49744 L .81873 .4916 L p F P
0 g
s
.244 0 0 r
.47758 .80535 m .49246 .79061 L .4745 .79546 L p F P
0 g
s
.244 0 0 r
.4745 .79546 m .45937 .81023 L .47758 .80535 L p F P
0 g
s
.664 .69 .864 r
.65876 .37951 m .67747 .40857 L .69612 .40243 L p F P
0 g
s
.664 .69 .864 r
.67747 .40857 m .65876 .37951 L .64009 .38577 L p F P
0 g
s
.427 .064 .243 r
.5841 .76585 m .59373 .74355 L .57542 .74857 L p F P
0 g
s
.427 .064 .243 r
.57542 .74857 m .56552 .77087 L .5841 .76585 L p F P
0 g
s
.634 .547 .738 r
.81873 .4916 m .80492 .4509 L .7859 .45689 L p F P
0 g
s
.645 .59 .778 r
.77009 .41851 m .7859 .45689 L .80492 .4509 L p F P
0 g
s
.645 .59 .778 r
.7859 .45689 m .77009 .41851 L .75116 .42461 L p F P
0 g
s
.556 .327 .523 r
.74821 .67331 m .74772 .63916 L .72889 .64452 L p F P
0 g
s
.556 .327 .523 r
.72889 .64452 m .72914 .67862 L .74821 .67331 L p F P
0 g
s
.668 .753 .914 r
.58349 .37595 m .60314 .39818 L .62156 .392 L p F P
0 g
s
.668 .753 .914 r
.60314 .39818 m .58349 .37595 L .56502 .38225 L p F P
0 g
s
.657 .83 .966 r
.49008 .38677 m .51033 .4009 L .52844 .39472 L p F P
0 g
s
.657 .83 .966 r
.51033 .4009 m .49008 .38677 L .47189 .39305 L p F P
0 g
s
.585 .398 .595 r
.80498 .62286 m .80015 .58477 L .78113 .59031 L p F P
0 g
s
.585 .398 .595 r
.78113 .59031 m .78577 .62833 L .80498 .62286 L p F P
0 g
s
.656 .637 .819 r
.73378 .39002 m .75116 .42461 L .77009 .41851 L p F P
0 g
s
.656 .637 .819 r
.75116 .42461 m .73378 .39002 L .71489 .39624 L p F P
0 g
s
.605 .454 .65 r
.83857 .57356 m .83009 .53299 L .81096 .53871 L p F P
0 g
s
.605 .454 .65 r
.81096 .53871 m .8193 .57918 L .83857 .57356 L p F P
0 g
s
1 1 0 r
.007 w
.23791 .45941 m
.24559 .45665 L
s
.5 Mabswid
.337 .816 .785 r
.28978 .44144 m .30932 .43715 L .32679 .43109 L p F P
0 g
s
.337 .816 .785 r
.30932 .43715 m .28978 .44144 L .2722 .44755 L p F P
0 g
s
.511 .226 .418 r
.68716 .71798 m .6914 .68913 L .67272 .69434 L p F P
0 g
s
.511 .226 .418 r
.67272 .69434 m .66823 .72316 L .68716 .71798 L p F P
0 g
s
0 0 0 r
.38611 .83103 m .40545 .82469 L .38772 .82945 L p F P
0 g
s
0 0 0 r
.38772 .82945 m .36815 .83584 L .38611 .83103 L p F P
0 g
s
.591 .902 .985 r
.39783 .40643 m .41802 .41162 L .43586 .40547 L p F P
0 g
s
.591 .902 .985 r
.41802 .41162 m .39783 .40643 L .37989 .41265 L p F P
0 g
s
.621 .502 .697 r
.84935 .52723 m .8379 .48571 L .81873 .4916 L p F P
0 g
s
.621 .502 .697 r
.81873 .4916 m .83009 .53299 L .84935 .52723 L p F P
0 g
s
.634 .547 .738 r
.80492 .4509 m .81873 .4916 L .8379 .48571 L p F P
0 g
s
.244 0 0 r
.49592 .80043 m .51054 .78572 L .49246 .79061 L p F P
0 g
s
.244 0 0 r
.49246 .79061 m .47758 .80535 L .49592 .80043 L p F P
0 g
s
.664 .69 .864 r
.67755 .3732 m .69612 .40243 L .71489 .39624 L p F P
0 g
s
.664 .69 .864 r
.69612 .40243 m .67755 .3732 L .65876 .37951 L p F P
0 g
s
.427 .064 .243 r
.6028 .7608 m .61217 .73851 L .59373 .74355 L p F P
0 g
s
.427 .064 .243 r
.59373 .74355 m .5841 .76585 L .6028 .7608 L p F P
0 g
s
.634 .547 .738 r
.8379 .48571 m .82406 .44487 L .80492 .4509 L p F P
0 g
s
.645 .59 .778 r
.78914 .41237 m .80492 .4509 L .82406 .44487 L p F P
0 g
s
.645 .59 .778 r
.80492 .4509 m .78914 .41237 L .77009 .41851 L p F P
0 g
s
.556 .327 .523 r
.7674 .66796 m .76668 .63377 L .74772 .63916 L p F P
0 g
s
.556 .327 .523 r
.74772 .63916 m .74821 .67331 L .7674 .66796 L p F P
0 g
s
.668 .753 .914 r
.60209 .36961 m .62156 .392 L .64009 .38577 L p F P
0 g
s
.668 .753 .914 r
.62156 .392 m .60209 .36961 L .58349 .37595 L p F P
0 g
s
.657 .83 .966 r
.5084 .38045 m .52844 .39472 L .54667 .38851 L p F P
0 g
s
.657 .83 .966 r
.52844 .39472 m .5084 .38045 L .49008 .38677 L p F P
0 g
s
1 1 0 r
.007 w
.35651 .83964 m
.36429 .83712 L
s
.5 Mabswid
.585 .398 .595 r
.82432 .61736 m .8193 .57918 L .80015 .58477 L p F P
0 g
s
.585 .398 .595 r
.80015 .58477 m .80498 .62286 L .82432 .61736 L p F P
0 g
s
.656 .637 .819 r
.75281 .38375 m .77009 .41851 L .78914 .41237 L p F P
0 g
s
.656 .637 .819 r
.77009 .41851 m .75281 .38375 L .73378 .39002 L p F P
0 g
s
.605 .454 .65 r
.85798 .56791 m .84935 .52723 L .83009 .53299 L p F P
0 g
s
.605 .454 .65 r
.83009 .53299 m .83857 .57356 L .85798 .56791 L p F P
0 g
s
.337 .816 .785 r
.30747 .43529 m .32679 .43109 L .34437 .42498 L p F P
0 g
s
.337 .816 .785 r
.32679 .43109 m .30747 .43529 L .28978 .44144 L p F P
0 g
s
.511 .226 .418 r
.70623 .71276 m .71021 .68389 L .6914 .68913 L p F P
0 g
s
.511 .226 .418 r
.6914 .68913 m .68716 .71798 L .70623 .71276 L p F P
0 g
s
0 0 0 r
.4042 .82618 m .4233 .8199 L .40545 .82469 L p F P
0 g
s
0 0 0 r
.40545 .82469 m .38611 .83103 L .4042 .82618 L p F P
0 g
s
.591 .902 .985 r
.4159 .40015 m .43586 .40547 L .45381 .39928 L p F P
0 g
s
.591 .902 .985 r
.43586 .40547 m .4159 .40015 L .39783 .40643 L p F P
0 g
s
.621 .502 .697 r
.86874 .52143 m .85721 .47979 L .8379 .48571 L p F P
0 g
s
.621 .502 .697 r
.8379 .48571 m .84935 .52723 L .86874 .52143 L p F P
0 g
s
.634 .547 .738 r
.82406 .44487 m .8379 .48571 L .85721 .47979 L p F P
0 g
s
.244 0 0 r
.51438 .79548 m .52875 .78081 L .51054 .78572 L p F P
0 g
s
.244 0 0 r
.51054 .78572 m .49592 .80043 L .51438 .79548 L p F P
0 g
s
.664 .69 .864 r
.69646 .36685 m .71489 .39624 L .73378 .39002 L p F P
0 g
s
.664 .69 .864 r
.71489 .39624 m .69646 .36685 L .67755 .3732 L p F P
0 g
s
.427 .064 .243 r
.62163 .75572 m .63073 .73343 L .61217 .73851 L p F P
0 g
s
.427 .064 .243 r
.61217 .73851 m .6028 .7608 L .62163 .75572 L p F P
0 g
s
.634 .547 .738 r
.85721 .47979 m .84334 .43881 L .82406 .44487 L p F P
0 g
s
.645 .59 .778 r
.80832 .40618 m .82406 .44487 L .84334 .43881 L p F P
0 g
s
.645 .59 .778 r
.82406 .44487 m .80832 .40618 L .78914 .41237 L p F P
0 g
s
.556 .327 .523 r
.78672 .66257 m .78577 .62833 L .76668 .63377 L p F P
0 g
s
.556 .327 .523 r
.76668 .63377 m .7674 .66796 L .78672 .66257 L p F P
0 g
s
.668 .753 .914 r
.62082 .36322 m .64009 .38577 L .65876 .37951 L p F P
0 g
s
.668 .753 .914 r
.64009 .38577 m .62082 .36322 L .60209 .36961 L p F P
0 g
s
.657 .83 .966 r
.52685 .37409 m .54667 .38851 L .56502 .38225 L p F P
0 g
s
.657 .83 .966 r
.54667 .38851 m .52685 .37409 L .5084 .38045 L p F P
0 g
s
.585 .398 .595 r
.8438 .61181 m .83857 .57356 L .8193 .57918 L p F P
0 g
s
.585 .398 .595 r
.8193 .57918 m .82432 .61736 L .8438 .61181 L p F P
0 g
s
.656 .637 .819 r
.77196 .37744 m .78914 .41237 L .80832 .40618 L p F P
0 g
s
.656 .637 .819 r
.78914 .41237 m .77196 .37744 L .75281 .38375 L p F P
0 g
s
.605 .454 .65 r
.87752 .56221 m .86874 .52143 L .84935 .52723 L p F P
0 g
s
.605 .454 .65 r
.84935 .52723 m .85798 .56791 L .87752 .56221 L p F P
0 g
s
1 1 0 r
.007 w
.23763 .45957 m
.23791 .45941 L
s
.5 Mabswid
.337 .816 .785 r
.32529 .4291 m .34437 .42498 L .36207 .41884 L p F P
0 g
s
.337 .816 .785 r
.34437 .42498 m .32529 .4291 L .30747 .43529 L p F P
0 g
s
.088 0 0 r
.21991 .47326 m .23739 .45965 L .25474 .45362 L p F P
0 g
s
.511 .226 .418 r
.72543 .70751 m .72914 .67862 L .71021 .68389 L p F P
0 g
s
.511 .226 .418 r
.71021 .68389 m .70623 .71276 L .72543 .70751 L p F P
0 g
s
0 0 0 r
.42242 .8213 m .44127 .81509 L .4233 .8199 L p F P
0 g
s
0 0 0 r
.4233 .8199 m .4042 .82618 L .42242 .8213 L p F P
0 g
s
.591 .902 .985 r
.43409 .39384 m .45381 .39928 L .47189 .39305 L p F P
0 g
s
.591 .902 .985 r
.45381 .39928 m .43409 .39384 L .4159 .40015 L p F P
0 g
s
.621 .502 .697 r
.88826 .51559 m .87664 .47383 L .85721 .47979 L p F P
0 g
s
.621 .502 .697 r
.85721 .47979 m .86874 .52143 L .88826 .51559 L p F P
0 g
s
.634 .547 .738 r
.84334 .43881 m .85721 .47979 L .87664 .47383 L p F P
0 g
s
.244 0 0 r
.53298 .7905 m .54707 .77586 L .52875 .78081 L p F P
0 g
s
.244 0 0 r
.52875 .78081 m .51438 .79548 L .53298 .7905 L p F P
0 g
s
.664 .69 .864 r
.7155 .36046 m .73378 .39002 L .75281 .38375 L p F P
0 g
s
.664 .69 .864 r
.73378 .39002 m .7155 .36046 L .69646 .36685 L p F P
0 g
s
0 0 .627 r
.21435 .41469 m .20614 .41523 L .21096 .38046 L closepath p F P
0 g
s
0 0 .611 r
.21894 .41064 m .21435 .41469 L .21096 .38046 L closepath p F P
0 g
s
0 0 .398 r
.21013 .40212 m .21721 .40543 L .21096 .38046 L closepath p F P
0 g
s
0 0 .641 r
.19909 .41195 m .1973 .40675 L .21096 .38046 L closepath p F P
0 g
s
0 0 .639 r
.20614 .41523 m .19909 .41195 L .21096 .38046 L closepath p F P
0 g
s
0 0 .406 r
.20187 .40266 m .21013 .40212 L .21096 .38046 L closepath p F P
0 g
s
0 0 .095 r
.1973 .40675 m .20187 .40266 L .21096 .38046 L closepath p F P
0 g
s
0 0 0 r
.21721 .40543 m .21894 .41064 L .21096 .38046 L closepath p F P
0 g
s
.427 .064 .243 r
.64059 .75059 m .64941 .72831 L .63073 .73343 L p F P
0 g
s
.427 .064 .243 r
.63073 .73343 m .62163 .75572 L .64059 .75059 L p F P
0 g
s
.634 .547 .738 r
.87664 .47383 m .86274 .4327 L .84334 .43881 L p F P
0 g
s
.645 .59 .778 r
.82764 .39996 m .84334 .43881 L .86274 .4327 L p F P
0 g
s
.645 .59 .778 r
.84334 .43881 m .82764 .39996 L .80832 .40618 L p F P
0 g
s
.556 .327 .523 r
.80618 .65715 m .80498 .62286 L .78577 .62833 L p F P
0 g
s
.556 .327 .523 r
.78577 .62833 m .78672 .66257 L .80618 .65715 L p F P
0 g
s
.668 .753 .914 r
.63967 .3568 m .65876 .37951 L .67755 .3732 L p F P
0 g
s
.668 .753 .914 r
.65876 .37951 m .63967 .3568 L .62082 .36322 L p F P
0 g
s
.657 .83 .966 r
.54542 .36769 m .56502 .38225 L .58349 .37595 L p F P
0 g
s
.657 .83 .966 r
.56502 .38225 m .54542 .36769 L .52685 .37409 L p F P
0 g
s
1 1 0 r
.007 w
.35133 .84035 m
.35651 .83964 L
s
.5 Mabswid
.585 .398 .595 r
.86341 .60623 m .85798 .56791 L .83857 .57356 L p F P
0 g
s
.585 .398 .595 r
.83857 .57356 m .8438 .61181 L .86341 .60623 L p F P
0 g
s
.656 .637 .819 r
.79124 .37109 m .80832 .40618 L .82764 .39996 L p F P
0 g
s
.656 .637 .819 r
.80832 .40618 m .79124 .37109 L .77196 .37744 L p F P
0 g
s
.605 .454 .65 r
.89719 .55647 m .88826 .51559 L .86874 .52143 L p F P
0 g
s
.605 .454 .65 r
.86874 .52143 m .87752 .56221 L .89719 .55647 L p F P
0 g
s
.337 .816 .785 r
.34323 .42286 m .36207 .41884 L .37989 .41265 L p F P
0 g
s
.337 .816 .785 r
.36207 .41884 m .34323 .42286 L .32529 .4291 L p F P
0 g
s
.088 0 0 r
.23749 .46718 m .25474 .45362 L .2722 .44755 L p F P
0 g
s
.088 0 0 r
.25474 .45362 m .23749 .46718 L .21991 .47326 L p F P
0 g
s
1 1 0 r
.007 w
.23064 .46357 m
.23714 .45985 L
s
.5 Mabswid
.511 .226 .418 r
.74476 .70222 m .74821 .67331 L .72914 .67862 L p F P
0 g
s
.511 .226 .418 r
.72914 .67862 m .72543 .70751 L .74476 .70222 L p F P
0 g
s
0 0 0 r
.44076 .81639 m .45937 .81023 L .44127 .81509 L p F P
0 g
s
0 0 0 r
.44127 .81509 m .42242 .8213 L .44076 .81639 L p F P
0 g
s
.591 .902 .985 r
.4524 .38748 m .47189 .39305 L .49008 .38677 L p F P
0 g
s
.591 .902 .985 r
.47189 .39305 m .4524 .38748 L .43409 .39384 L p F P
0 g
s
.621 .502 .697 r
.90792 .50971 m .8962 .46783 L .87664 .47383 L p F P
0 g
s
.621 .502 .697 r
.87664 .47383 m .88826 .51559 L .90792 .50971 L p F P
0 g
s
.634 .547 .738 r
.86274 .4327 m .87664 .47383 L .8962 .46783 L p F P
0 g
s
.244 0 0 r
.55169 .78548 m .56552 .77087 L .54707 .77586 L p F P
0 g
s
.244 0 0 r
.54707 .77586 m .53298 .7905 L .55169 .78548 L p F P
0 g
s
.664 .69 .864 r
.73468 .35402 m .75281 .38375 L .77196 .37744 L p F P
0 g
s
.664 .69 .864 r
.75281 .38375 m .73468 .35402 L .7155 .36046 L p F P
0 g
s
.427 .064 .243 r
.65967 .74544 m .66823 .72316 L .64941 .72831 L p F P
0 g
s
.427 .064 .243 r
.64941 .72831 m .64059 .75059 L .65967 .74544 L p F P
0 g
s
.634 .547 .738 r
.8962 .46783 m .88228 .42655 L .86274 .4327 L p F P
0 g
s
.645 .59 .778 r
.84708 .39369 m .86274 .4327 L .88228 .42655 L p F P
0 g
s
.645 .59 .778 r
.86274 .4327 m .84708 .39369 L .82764 .39996 L p F P
0 g
s
.556 .327 .523 r
.82576 .6517 m .82432 .61736 L .80498 .62286 L p F P
0 g
s
.556 .327 .523 r
.80498 .62286 m .80618 .65715 L .82576 .6517 L p F P
0 g
s
.668 .753 .914 r
.65865 .35032 m .67755 .3732 L .69646 .36685 L p F P
0 g
s
.668 .753 .914 r
.67755 .3732 m .65865 .35032 L .63967 .3568 L p F P
0 g
s
.657 .83 .966 r
.56411 .36124 m .58349 .37595 L .60209 .36961 L p F P
0 g
s
.657 .83 .966 r
.58349 .37595 m .56411 .36124 L .54542 .36769 L p F P
0 g
s
.585 .398 .595 r
.88315 .60061 m .87752 .56221 L .85798 .56791 L p F P
0 g
s
.585 .398 .595 r
.85798 .56791 m .86341 .60623 L .88315 .60061 L p F P
0 g
s
.656 .637 .819 r
.81065 .3647 m .82764 .39996 L .84708 .39369 L p F P
0 g
s
.656 .637 .819 r
.82764 .39996 m .81065 .3647 L .79124 .37109 L p F P
0 g
s
1 1 0 r
.007 w
.22386 .46912 m
.23064 .46357 L
s
.5 Mabswid
.605 .454 .65 r
.91699 .5507 m .90792 .50971 L .88826 .51559 L p F P
0 g
s
.605 .454 .65 r
.88826 .51559 m .89719 .55647 L .91699 .5507 L p F P
0 g
s
.337 .816 .785 r
.3613 .41658 m .37989 .41265 L .39783 .40643 L p F P
0 g
s
.337 .816 .785 r
.37989 .41265 m .3613 .41658 L .34323 .42286 L p F P
0 g
s
.088 0 0 r
.25518 .46105 m .2722 .44755 L .28978 .44144 L p F P
0 g
s
.088 0 0 r
.2722 .44755 m .25518 .46105 L .23749 .46718 L p F P
0 g
s
.511 .226 .418 r
.76422 .69689 m .7674 .66796 L .74821 .67331 L p F P
0 g
s
.511 .226 .418 r
.74821 .67331 m .74476 .70222 L .76422 .69689 L p F P
0 g
s
.489 .878 .966 r
.34589 .83299 m .36815 .83584 L .3503 .84062 L p F P
0 g
s
.489 .878 .966 r
.3503 .84062 m .32783 .83786 L .34589 .83299 L p F P
0 g
s
1 1 0 r
.007 w
.34828 .84076 m
.34978 .84056 L
s
.5 Mabswid
0 0 0 r
.45922 .81144 m .47758 .80535 L .45937 .81023 L p F P
0 g
s
0 0 0 r
.45937 .81023 m .44076 .81639 L .45922 .81144 L p F P
0 g
s
.591 .902 .985 r
.47083 .38108 m .49008 .38677 L .5084 .38045 L p F P
0 g
s
.591 .902 .985 r
.49008 .38677 m .47083 .38108 L .4524 .38748 L p F P
0 g
s
.621 .502 .697 r
.9277 .5038 m .91589 .46178 L .8962 .46783 L p F P
0 g
s
.621 .502 .697 r
.8962 .46783 m .90792 .50971 L .9277 .5038 L p F P
0 g
s
.634 .547 .738 r
.88228 .42655 m .8962 .46783 L .91589 .46178 L p F P
0 g
s
.244 0 0 r
.57054 .78042 m .5841 .76585 L .56552 .77087 L p F P
0 g
s
.244 0 0 r
.56552 .77087 m .55169 .78548 L .57054 .78042 L p F P
0 g
s
.664 .69 .864 r
.75398 .34754 m .77196 .37744 L .79124 .37109 L p F P
0 g
s
.664 .69 .864 r
.77196 .37744 m .75398 .34754 L .73468 .35402 L p F P
0 g
s
.427 .064 .243 r
.67889 .74025 m .68716 .71798 L .66823 .72316 L p F P
0 g
s
.427 .064 .243 r
.66823 .72316 m .65967 .74544 L .67889 .74025 L p F P
0 g
s
.634 .547 .738 r
.91589 .46178 m .90195 .42036 L .88228 .42655 L p F P
0 g
s
.645 .59 .778 r
.86666 .38738 m .88228 .42655 L .90195 .42036 L p F P
0 g
s
.645 .59 .778 r
.88228 .42655 m .86666 .38738 L .84708 .39369 L p F P
0 g
s
.556 .327 .523 r
.84548 .6462 m .8438 .61181 L .82432 .61736 L p F P
0 g
s
.556 .327 .523 r
.82432 .61736 m .82576 .6517 L .84548 .6462 L p F P
0 g
s
.668 .753 .914 r
.67776 .34381 m .69646 .36685 L .7155 .36046 L p F P
0 g
s
.668 .753 .914 r
.69646 .36685 m .67776 .34381 L .65865 .35032 L p F P
0 g
s
.657 .83 .966 r
.58294 .35475 m .60209 .36961 L .62082 .36322 L p F P
0 g
s
.657 .83 .966 r
.60209 .36961 m .58294 .35475 L .56411 .36124 L p F P
0 g
s
1 1 0 r
.007 w
.33964 .84046 m
.34828 .84076 L
s
.5 Mabswid
.585 .398 .595 r
.90302 .59495 m .89719 .55647 L .87752 .56221 L p F P
0 g
s
.585 .398 .595 r
.87752 .56221 m .88315 .60061 L .90302 .59495 L p F P
0 g
s
.656 .637 .819 r
.83019 .35826 m .84708 .39369 L .86666 .38738 L p F P
0 g
s
.656 .637 .819 r
.84708 .39369 m .83019 .35826 L .81065 .3647 L p F P
0 g
s
.605 .454 .65 r
.93693 .54489 m .9277 .5038 L .90792 .50971 L p F P
0 g
s
.605 .454 .65 r
.90792 .50971 m .91699 .5507 L .93693 .54489 L p F P
0 g
s
.337 .816 .785 r
.37948 .41026 m .39783 .40643 L .4159 .40015 L p F P
0 g
s
.337 .816 .785 r
.39783 .40643 m .37948 .41026 L .3613 .41658 L p F P
0 g
s
.088 0 0 r
.273 .45489 m .28978 .44144 L .30747 .43529 L p F P
0 g
s
.088 0 0 r
.28978 .44144 m .273 .45489 L .25518 .46105 L p F P
0 g
s
.511 .226 .418 r
.78382 .69153 m .78672 .66257 L .7674 .66796 L p F P
0 g
s
.511 .226 .418 r
.7674 .66796 m .76422 .69689 L .78382 .69153 L p F P
0 g
s
1 1 0 r
.007 w
.91546 .4605 m
.91636 .46344 L
s
.91412 .45612 m
.91546 .4605 L
s
.91636 .46344 m
.91915 .47257 L
s
.90878 .43978 m
.91412 .45612 L
s
.5 Mabswid
.489 .878 .966 r
.36408 .82809 m .38611 .83103 L .36815 .83584 L p F P
0 g
s
.489 .878 .966 r
.36815 .83584 m .34589 .83299 L .36408 .82809 L p F P
0 g
s
0 0 0 r
.47781 .80646 m .49592 .80043 L .47758 .80535 L p F P
0 g
s
0 0 0 r
.47758 .80535 m .45922 .81144 L .47781 .80646 L p F P
0 g
s
.591 .902 .985 r
.4894 .37464 m .5084 .38045 L .52685 .37409 L p F P
0 g
s
.591 .902 .985 r
.5084 .38045 m .4894 .37464 L .47083 .38108 L p F P
0 g
s
.244 0 0 r
.58952 .77533 m .6028 .7608 L .5841 .76585 L p F P
0 g
s
.244 0 0 r
.5841 .76585 m .57054 .78042 L .58952 .77533 L p F P
0 g
s
1 1 0 r
.007 w
.90315 .42366 m
.90878 .43978 L
s
.91915 .47257 m
.92382 .48906 L
s
.5 Mabswid
.664 .69 .864 r
.77342 .34101 m .79124 .37109 L .81065 .3647 L p F P
0 g
s
.664 .69 .864 r
.79124 .37109 m .77342 .34101 L .75398 .34754 L p F P
0 g
s
1 1 0 r
.007 w
.90224 .42122 m
.90315 .42366 L
s
.5 Mabswid
.427 .064 .243 r
.69824 .73502 m .70623 .71276 L .68716 .71798 L p F P
0 g
s
.427 .064 .243 r
.68716 .71798 m .67889 .74025 L .69824 .73502 L p F P
0 g
s
.645 .59 .778 r
.90195 .42036 m .88636 .38103 L .86666 .38738 L p F P
0 g
s
1 1 0 r
.007 w
.89726 .40785 m
.90144 .41908 L
s
.90144 .41908 m
.90224 .42122 L
s
.5 Mabswid
.556 .327 .523 r
.86534 .64067 m .86341 .60623 L .8438 .61181 L p F P
0 g
s
.556 .327 .523 r
.8438 .61181 m .84548 .6462 L .86534 .64067 L p F P
0 g
s
1 1 0 r
.007 w
.92746 .50292 m
.9278 .50424 L
s
.9278 .50424 m
.92813 .50549 L
s
.92382 .48906 m
.92746 .50292 L
s
.5 Mabswid
.668 .753 .914 r
.697 .33725 m .7155 .36046 L .73468 .35402 L p F P
0 g
s
.668 .753 .914 r
.7155 .36046 m .697 .33725 L .67776 .34381 L p F P
0 g
s
.657 .83 .966 r
.60189 .34821 m .62082 .36322 L .63967 .3568 L p F P
0 g
s
.657 .83 .966 r
.62082 .36322 m .60189 .34821 L .58294 .35475 L p F P
0 g
s
.585 .398 .595 r
.92304 .58926 m .91699 .5507 L .89719 .55647 L p F P
0 g
s
.585 .398 .595 r
.89719 .55647 m .90302 .59495 L .92304 .58926 L p F P
0 g
s
1 1 0 r
.007 w
.89114 .39242 m
.89726 .40785 L
s
.22063 .47271 m
.22386 .46912 L
s
.5 Mabswid
.656 .637 .819 r
.84987 .35178 m .86666 .38738 L .88636 .38103 L p F P
0 g
s
.656 .637 .819 r
.86666 .38738 m .84987 .35178 L .83019 .35826 L p F P
0 g
s
1 1 0 r
.007 w
.92813 .50549 m
.93203 .52177 L
s
.5 Mabswid
.337 .816 .785 r
.3978 .40389 m .4159 .40015 L .43409 .39384 L p F P
0 g
s
.337 .816 .785 r
.4159 .40015 m .3978 .40389 L .37948 .41026 L p F P
0 g
s
.088 0 0 r
.29094 .44868 m .30747 .43529 L .32529 .4291 L p F P
0 g
s
.088 0 0 r
.30747 .43529 m .29094 .44868 L .273 .45489 L p F P
0 g
s
.511 .226 .418 r
.80355 .68613 m .80618 .65715 L .78672 .66257 L p F P
0 g
s
.511 .226 .418 r
.78672 .66257 m .78382 .69153 L .80355 .68613 L p F P
0 g
s
.489 .878 .966 r
.38239 .82315 m .4042 .82618 L .38611 .83103 L p F P
0 g
s
.489 .878 .966 r
.38611 .83103 m .36408 .82809 L .38239 .82315 L p F P
0 g
s
0 0 0 r
.49653 .80144 m .51438 .79548 L .49592 .80043 L p F P
0 g
s
0 0 0 r
.49592 .80043 m .47781 .80646 L .49653 .80144 L p F P
0 g
s
.591 .902 .985 r
.50809 .36815 m .52685 .37409 L .54542 .36769 L p F P
0 g
s
.591 .902 .985 r
.52685 .37409 m .50809 .36815 L .4894 .37464 L p F P
0 g
s
.244 0 0 r
.60862 .77021 m .62163 .75572 L .6028 .7608 L p F P
0 g
s
.244 0 0 r
.6028 .7608 m .58952 .77533 L .60862 .77021 L p F P
0 g
s
.664 .69 .864 r
.79299 .33444 m .81065 .3647 L .83019 .35826 L p F P
0 g
s
.664 .69 .864 r
.81065 .3647 m .79299 .33444 L .77342 .34101 L p F P
0 g
s
1 1 0 r
.007 w
.88692 .38243 m
.89114 .39242 L
s
.5 Mabswid
.427 .064 .243 r
.71773 .72976 m .72543 .70751 L .70623 .71276 L p F P
0 g
s
.427 .064 .243 r
.70623 .71276 m .69824 .73502 L .71773 .72976 L p F P
0 g
s
1 1 0 r
.007 w
.33067 .8387 m
.33964 .84046 L
s
.5 Mabswid
.556 .327 .523 r
.88533 .6351 m .88315 .60061 L .86341 .60623 L p F P
0 g
s
.556 .327 .523 r
.86341 .60623 m .86534 .64067 L .88533 .6351 L p F P
0 g
s
.668 .753 .914 r
.71638 .33064 m .73468 .35402 L .75398 .34754 L p F P
0 g
s
.668 .753 .914 r
.73468 .35402 m .71638 .33064 L .697 .33725 L p F P
0 g
s
.657 .83 .966 r
.62098 .34163 m .63967 .3568 L .65865 .35032 L p F P
0 g
s
.657 .83 .966 r
.63967 .3568 m .62098 .34163 L .60189 .34821 L p F P
0 g
s
1 1 0 r
.007 w
.93203 .52177 m
.93551 .5378 L
s
.5 Mabswid
.585 .398 .595 r
.94319 .58352 m .93693 .54489 L .91699 .5507 L p F P
0 g
s
.585 .398 .595 r
.91699 .5507 m .92304 .58926 L .94319 .58352 L p F P
0 g
s
.656 .637 .819 r
.88636 .38103 m .86968 .34525 L .84987 .35178 L p F P
0 g
s
1 1 0 r
.007 w
.88482 .37747 m
.88597 .3802 L
s
.88597 .3802 m
.88692 .38243 L
s
.5 Mabswid
.352 0 .172 r
.20619 .4957 m .21991 .47326 L .23749 .46718 L p F P
0 g
s
1 1 0 r
.007 w
.21761 .47605 m
.21947 .474 L
s
.87835 .36309 m
.88482 .37747 L
s
.5 Mabswid
.337 .816 .785 r
.41624 .39748 m .43409 .39384 L .4524 .38748 L p F P
0 g
s
.337 .816 .785 r
.43409 .39384 m .41624 .39748 L .3978 .40389 L p F P
0 g
s
.088 0 0 r
.309 .44242 m .32529 .4291 L .34323 .42286 L p F P
0 g
s
.088 0 0 r
.32529 .4291 m .309 .44242 L .29094 .44868 L p F P
0 g
s
.511 .226 .418 r
.82342 .68069 m .82576 .6517 L .80618 .65715 L p F P
0 g
s
.511 .226 .418 r
.80618 .65715 m .80355 .68613 L .82342 .68069 L p F P
0 g
s
.489 .878 .966 r
.40083 .81818 m .42242 .8213 L .4042 .82618 L p F P
0 g
s
.489 .878 .966 r
.4042 .82618 m .38239 .82315 L .40083 .81818 L p F P
0 g
s
0 0 0 r
.51539 .79639 m .53298 .7905 L .51438 .79548 L p F P
0 g
s
0 0 0 r
.51438 .79548 m .49653 .80144 L .51539 .79639 L p F P
0 g
s
.591 .902 .985 r
.52691 .36162 m .54542 .36769 L .56411 .36124 L p F P
0 g
s
.591 .902 .985 r
.54542 .36769 m .52691 .36162 L .50809 .36815 L p F P
0 g
s
.244 0 0 r
.62787 .76505 m .64059 .75059 L .62163 .75572 L p F P
0 g
s
.244 0 0 r
.62163 .75572 m .60862 .77021 L .62787 .76505 L p F P
0 g
s
.664 .69 .864 r
.81269 .32783 m .83019 .35826 L .84987 .35178 L p F P
0 g
s
.664 .69 .864 r
.83019 .35826 m .81269 .32783 L .79299 .33444 L p F P
0 g
s
1 1 0 r
.007 w
.93659 .54337 m
.93717 .54641 L
s
.93717 .54641 m
.93855 .5535 L
s
.93551 .5378 m
.93659 .54337 L
s
.5 Mabswid
.427 .064 .243 r
.73735 .72446 m .74476 .70222 L .72543 .70751 L p F P
0 g
s
.427 .064 .243 r
.72543 .70751 m .71773 .72976 L .73735 .72446 L p F P
0 g
s
.556 .327 .523 r
.90547 .62949 m .90302 .59495 L .88315 .60061 L p F P
0 g
s
.556 .327 .523 r
.88315 .60061 m .88533 .6351 L .90547 .62949 L p F P
0 g
s
.668 .753 .914 r
.73589 .32399 m .75398 .34754 L .77342 .34101 L p F P
0 g
s
.668 .753 .914 r
.75398 .34754 m .73589 .32399 L .71638 .33064 L p F P
0 g
s
.657 .83 .966 r
.6402 .335 m .65865 .35032 L .67776 .34381 L p F P
0 g
s
.657 .83 .966 r
.65865 .35032 m .6402 .335 L .62098 .34163 L p F P
0 g
s
1 1 0 r
.007 w
.87175 .34936 m
.87835 .36309 L
s
.5 Mabswid
.352 0 .172 r
.22399 .4896 m .23749 .46718 L .25518 .46105 L p F P
0 g
s
.352 0 .172 r
.23749 .46718 m .22399 .4896 L .20619 .4957 L p F P
0 g
s
1 1 0 r
.007 w
.21197 .48433 m
.21761 .47605 L
s
.5 Mabswid
.337 .816 .785 r
.43481 .39103 m .4524 .38748 L .47083 .38108 L p F P
0 g
s
.337 .816 .785 r
.4524 .38748 m .43481 .39103 L .41624 .39748 L p F P
0 g
s
.088 0 0 r
.32719 .43613 m .34323 .42286 L .3613 .41658 L p F P
0 g
s
.088 0 0 r
.34323 .42286 m .32719 .43613 L .309 .44242 L p F P
0 g
s
.511 .226 .418 r
.84343 .67521 m .84548 .6462 L .82576 .6517 L p F P
0 g
s
.511 .226 .418 r
.82576 .6517 m .82342 .68069 L .84343 .67521 L p F P
0 g
s
.489 .878 .966 r
.4194 .81317 m .44076 .81639 L .42242 .8213 L p F P
0 g
s
.489 .878 .966 r
.42242 .8213 m .40083 .81818 L .4194 .81317 L p F P
0 g
s
0 0 0 r
.53437 .79131 m .55169 .78548 L .53298 .7905 L p F P
0 g
s
0 0 0 r
.53298 .7905 m .51539 .79639 L .53437 .79131 L p F P
0 g
s
.591 .902 .985 r
.54586 .35504 m .56411 .36124 L .58294 .35475 L p F P
0 g
s
.591 .902 .985 r
.56411 .36124 m .54586 .35504 L .52691 .36162 L p F P
0 g
s
.244 0 0 r
.64724 .75986 m .65967 .74544 L .64059 .75059 L p F P
0 g
s
.244 0 0 r
.64059 .75059 m .62787 .76505 L .64724 .75986 L p F P
0 g
s
.664 .69 .864 r
.83253 .32116 m .84987 .35178 L .86968 .34525 L p F P
0 g
s
.664 .69 .864 r
.84987 .35178 m .83253 .32116 L .81269 .32783 L p F P
0 g
s
1 1 0 r
.007 w
.93855 .5535 m
.94111 .56877 L
s
.32848 .83794 m
.33067 .8387 L
s
.5 Mabswid
.427 .064 .243 r
.75711 .71912 m .76422 .69689 L .74476 .70222 L p F P
0 g
s
.427 .064 .243 r
.74476 .70222 m .73735 .72446 L .75711 .71912 L p F P
0 g
s
.556 .327 .523 r
.92574 .62384 m .92304 .58926 L .90302 .59495 L p F P
0 g
s
.556 .327 .523 r
.90302 .59495 m .90547 .62949 L .92574 .62384 L p F P
0 g
s
.668 .753 .914 r
.75553 .31729 m .77342 .34101 L .79299 .33444 L p F P
0 g
s
.668 .753 .914 r
.77342 .34101 m .75553 .31729 L .73589 .32399 L p F P
0 g
s
.657 .83 .966 r
.65955 .32833 m .67776 .34381 L .697 .33725 L p F P
0 g
s
.657 .83 .966 r
.67776 .34381 m .65955 .32833 L .6402 .335 L p F P
0 g
s
1 1 0 r
.007 w
.87017 .34629 m
.87175 .34936 L
s
.5 Mabswid
.614 .832 .984 r
.32195 .82059 m .34589 .83299 L .32783 .83786 L p F P
0 g
s
.614 .832 .984 r
.32783 .83786 m .3037 .82558 L .32195 .82059 L p F P
0 g
s
1 1 0 r
.007 w
.32142 .83548 m
.32691 .83739 L
s
.5 Mabswid
.352 0 .172 r
.24192 .48346 m .25518 .46105 L .273 .45489 L p F P
0 g
s
.352 0 .172 r
.25518 .46105 m .24192 .48346 L .22399 .4896 L p F P
0 g
s
.337 .816 .785 r
.45351 .38453 m .47083 .38108 L .4894 .37464 L p F P
0 g
s
.337 .816 .785 r
.47083 .38108 m .45351 .38453 L .43481 .39103 L p F P
0 g
s
.088 0 0 r
.34551 .42979 m .3613 .41658 L .37948 .41026 L p F P
0 g
s
.088 0 0 r
.3613 .41658 m .34551 .42979 L .32719 .43613 L p F P
0 g
s
.511 .226 .418 r
.86357 .6697 m .86534 .64067 L .84548 .6462 L p F P
0 g
s
.511 .226 .418 r
.84548 .6462 m .84343 .67521 L .86357 .6697 L p F P
0 g
s
.489 .878 .966 r
.43809 .80813 m .45922 .81144 L .44076 .81639 L p F P
0 g
s
.489 .878 .966 r
.44076 .81639 m .4194 .81317 L .43809 .80813 L p F P
0 g
s
0 0 0 r
.55348 .78618 m .57054 .78042 L .55169 .78548 L p F P
0 g
s
0 0 0 r
.55169 .78548 m .53437 .79131 L .55348 .78618 L p F P
0 g
s
.591 .902 .985 r
.56494 .34841 m .58294 .35475 L .60189 .34821 L p F P
0 g
s
.591 .902 .985 r
.58294 .35475 m .56494 .34841 L .54586 .35504 L p F P
0 g
s
.244 0 0 r
.66675 .75462 m .67889 .74025 L .65967 .74544 L p F P
0 g
s
.244 0 0 r
.65967 .74544 m .64724 .75986 L .66675 .75462 L p F P
0 g
s
.664 .69 .864 r
.86968 .34525 m .85251 .31446 L .83253 .32116 L p F P
0 g
s
1 1 0 r
.007 w
.86507 .33638 m
.86903 .34407 L
s
.86903 .34407 m
.87017 .34629 L
s
.5 Mabswid
.427 .064 .243 r
.77701 .71374 m .78382 .69153 L .76422 .69689 L p F P
0 g
s
.427 .064 .243 r
.76422 .69689 m .75711 .71912 L .77701 .71374 L p F P
0 g
s
1 1 0 r
.007 w
.20698 .49392 m
.21197 .48433 L
s
.5 Mabswid
.556 .327 .523 r
.94615 .61815 m .94319 .58352 L .92304 .58926 L p F P
0 g
s
1 1 0 r
.007 w
.94111 .56877 m
.94319 .58352 L
s
.5 Mabswid
.556 .327 .523 r
.92304 .58926 m .92574 .62384 L .94615 .61815 L p F P
0 g
s
.668 .753 .914 r
.77532 .31054 m .79299 .33444 L .81269 .32783 L p F P
0 g
s
.668 .753 .914 r
.79299 .33444 m .77532 .31054 L .75553 .31729 L p F P
0 g
s
.657 .83 .966 r
.67904 .32161 m .697 .33725 L .71638 .33064 L p F P
0 g
s
.657 .83 .966 r
.697 .33725 m .67904 .32161 L .65955 .32833 L p F P
0 g
s
.614 .832 .984 r
.34033 .81557 m .36408 .82809 L .34589 .83299 L p F P
0 g
s
.614 .832 .984 r
.34589 .83299 m .32195 .82059 L .34033 .81557 L p F P
0 g
s
.352 0 .172 r
.25997 .47727 m .273 .45489 L .29094 .44868 L p F P
0 g
s
.352 0 .172 r
.273 .45489 m .25997 .47727 L .24192 .48346 L p F P
0 g
s
1 1 0 r
.007 w
.85833 .32422 m
.86507 .33638 L
s
.5 Mabswid
.337 .816 .785 r
.47234 .37798 m .4894 .37464 L .50809 .36815 L p F P
0 g
s
.337 .816 .785 r
.4894 .37464 m .47234 .37798 L .45351 .38453 L p F P
0 g
s
.088 0 0 r
.36395 .4234 m .37948 .41026 L .3978 .40389 L p F P
0 g
s
.088 0 0 r
.37948 .41026 m .36395 .4234 L .34551 .42979 L p F P
0 g
s
.511 .226 .418 r
.88386 .66414 m .88533 .6351 L .86534 .64067 L p F P
0 g
s
.511 .226 .418 r
.86534 .64067 m .86357 .6697 L .88386 .66414 L p F P
0 g
s
1 1 0 r
.007 w
.31197 .83079 m
.32142 .83548 L
s
.5 Mabswid
.489 .878 .966 r
.45692 .80306 m .47781 .80646 L .45922 .81144 L p F P
0 g
s
.489 .878 .966 r
.45922 .81144 m .43809 .80813 L .45692 .80306 L p F P
0 g
s
0 0 0 r
.57273 .78103 m .58952 .77533 L .57054 .78042 L p F P
0 g
s
0 0 0 r
.57054 .78042 m .55348 .78618 L .57273 .78103 L p F P
0 g
s
.591 .902 .985 r
.58416 .34174 m .60189 .34821 L .62098 .34163 L p F P
0 g
s
.591 .902 .985 r
.60189 .34821 m .58416 .34174 L .56494 .34841 L p F P
0 g
s
.244 0 0 r
.6864 .74936 m .69824 .73502 L .67889 .74025 L p F P
0 g
s
.244 0 0 r
.67889 .74025 m .66675 .75462 L .6864 .74936 L p F P
0 g
s
.427 .064 .243 r
.79704 .70833 m .80355 .68613 L .78382 .69153 L p F P
0 g
s
.427 .064 .243 r
.78382 .69153 m .77701 .71374 L .79704 .70833 L p F P
0 g
s
1 1 0 r
.007 w
.94319 .58352 m
.94476 .59765 L
s
.5 Mabswid
.668 .753 .914 r
.79524 .30375 m .81269 .32783 L .83253 .32116 L p F P
0 g
s
.668 .753 .914 r
.81269 .32783 m .79524 .30375 L .77532 .31054 L p F P
0 g
s
.657 .83 .966 r
.69866 .31484 m .71638 .33064 L .73589 .32399 L p F P
0 g
s
.657 .83 .966 r
.71638 .33064 m .69866 .31484 L .67904 .32161 L p F P
0 g
s
.614 .832 .984 r
.35884 .81051 m .38239 .82315 L .36408 .82809 L p F P
0 g
s
.614 .832 .984 r
.36408 .82809 m .34033 .81557 L .35884 .81051 L p F P
0 g
s
.352 0 .172 r
.27815 .47104 m .29094 .44868 L .309 .44242 L p F P
0 g
s
.352 0 .172 r
.29094 .44868 m .27815 .47104 L .25997 .47727 L p F P
0 g
s
.337 .816 .785 r
.4913 .37139 m .50809 .36815 L .52691 .36162 L p F P
0 g
s
.337 .816 .785 r
.50809 .36815 m .4913 .37139 L .47234 .37798 L p F P
0 g
s
.088 0 0 r
.38253 .41697 m .3978 .40389 L .41624 .39748 L p F P
0 g
s
.088 0 0 r
.3978 .40389 m .38253 .41697 L .36395 .4234 L p F P
0 g
s
.511 .226 .418 r
.90429 .65855 m .90547 .62949 L .88533 .6351 L p F P
0 g
s
.511 .226 .418 r
.88533 .6351 m .88386 .66414 L .90429 .65855 L p F P
0 g
s
.489 .878 .966 r
.47589 .79794 m .49653 .80144 L .47781 .80646 L p F P
0 g
s
.489 .878 .966 r
.47781 .80646 m .45692 .80306 L .47589 .79794 L p F P
0 g
s
0 0 0 r
.59212 .77583 m .60862 .77021 L .58952 .77533 L p F P
0 g
s
0 0 0 r
.58952 .77533 m .57273 .78103 L .59212 .77583 L p F P
0 g
s
.591 .902 .985 r
.60352 .33503 m .62098 .34163 L .6402 .335 L p F P
0 g
s
.591 .902 .985 r
.62098 .34163 m .60352 .33503 L .58416 .34174 L p F P
0 g
s
.244 0 0 r
.70619 .74405 m .71773 .72976 L .69824 .73502 L p F P
0 g
s
.244 0 0 r
.69824 .73502 m .6864 .74936 L .70619 .74405 L p F P
0 g
s
1 1 0 r
.007 w
.20644 .4953 m
.20698 .49392 L
s
.85295 .31525 m
.85833 .32422 L
s
.5 Mabswid
.427 .064 .243 r
.81722 .70288 m .82342 .68069 L .80355 .68613 L p F P
0 g
s
.427 .064 .243 r
.80355 .68613 m .79704 .70833 L .81722 .70288 L p F P
0 g
s
.471 .182 .392 r
.19712 .52621 m .20619 .4957 L .22399 .4896 L p F P
0 g
s
.668 .753 .914 r
.8153 .29691 m .83253 .32116 L .85251 .31446 L p F P
0 g
s
.668 .753 .914 r
.83253 .32116 m .8153 .29691 L .79524 .30375 L p F P
0 g
s
.657 .83 .966 r
.71842 .30803 m .73589 .32399 L .75553 .31729 L p F P
0 g
s
.657 .83 .966 r
.73589 .32399 m .71842 .30803 L .69866 .31484 L p F P
0 g
s
1 1 0 r
.007 w
.94476 .59765 m
.94581 .61108 L
s
.30433 .82589 m
.31197 .83079 L
s
.5 Mabswid
.614 .832 .984 r
.37748 .80542 m .40083 .81818 L .38239 .82315 L p F P
0 g
s
.614 .832 .984 r
.38239 .82315 m .35884 .81051 L .37748 .80542 L p F P
0 g
s
.352 0 .172 r
.29646 .46477 m .309 .44242 L .32719 .43613 L p F P
0 g
s
.352 0 .172 r
.309 .44242 m .29646 .46477 L .27815 .47104 L p F P
0 g
s
.337 .816 .785 r
.51039 .36475 m .52691 .36162 L .54586 .35504 L p F P
0 g
s
.337 .816 .785 r
.52691 .36162 m .51039 .36475 L .4913 .37139 L p F P
0 g
s
.088 0 0 r
.40123 .4105 m .41624 .39748 L .43481 .39103 L p F P
0 g
s
.088 0 0 r
.41624 .39748 m .40123 .4105 L .38253 .41697 L p F P
0 g
s
.511 .226 .418 r
.92487 .65292 m .92574 .62384 L .90547 .62949 L p F P
0 g
s
.511 .226 .418 r
.90547 .62949 m .90429 .65855 L .92487 .65292 L p F P
0 g
s
.489 .878 .966 r
.49498 .79279 m .51539 .79639 L .49653 .80144 L p F P
0 g
s
.489 .878 .966 r
.49653 .80144 m .47589 .79794 L .49498 .79279 L p F P
0 g
s
0 0 0 r
.61164 .7706 m .62787 .76505 L .60862 .77021 L p F P
0 g
s
0 0 0 r
.60862 .77021 m .59212 .77583 L .61164 .7706 L p F P
0 g
s
.591 .902 .985 r
.62301 .32826 m .6402 .335 L .65955 .32833 L p F P
0 g
s
.591 .902 .985 r
.6402 .335 m .62301 .32826 L .60352 .33503 L p F P
0 g
s
.244 0 0 r
.72612 .73871 m .73735 .72446 L .71773 .72976 L p F P
0 g
s
.244 0 0 r
.71773 .72976 m .70619 .74405 L .72612 .73871 L p F P
0 g
s
.427 .064 .243 r
.83754 .69739 m .84343 .67521 L .82342 .68069 L p F P
0 g
s
.427 .064 .243 r
.82342 .68069 m .81722 .70288 L .83754 .69739 L p F P
0 g
s
.471 .182 .392 r
.21514 .52013 m .22399 .4896 L .24192 .48346 L p F P
0 g
s
.471 .182 .392 r
.22399 .4896 m .21514 .52013 L .19712 .52621 L p F P
0 g
s
0 0 1 r
.007 w
.19808 .50896 m
.20878 .40221 L
s
1 1 0 r
.2027 .50477 m
.20593 .49659 L
s
.5 Mabswid
.668 .753 .914 r
.85251 .31446 m .8355 .29002 L .8153 .29691 L p F P
0 g
s
1 1 0 r
.007 w
.85158 .31296 m
.85227 .31411 L
s
.85227 .31411 m
.85295 .31525 L
s
.5 Mabswid
.657 .83 .966 r
.73832 .30116 m .75553 .31729 L .77532 .31054 L p F P
0 g
s
.657 .83 .966 r
.75553 .31729 m .73832 .30116 L .71842 .30803 L p F P
0 g
s
1 1 0 r
.007 w
.84486 .3027 m
.85158 .31296 L
s
.19918 .5168 m
.2027 .50477 L
s
.5 Mabswid
.614 .832 .984 r
.39625 .80029 m .4194 .81317 L .40083 .81818 L p F P
0 g
s
.614 .832 .984 r
.40083 .81818 m .37748 .80542 L .39625 .80029 L p F P
0 g
s
.352 0 .172 r
.3149 .45845 m .32719 .43613 L .34551 .42979 L p F P
0 g
s
.352 0 .172 r
.32719 .43613 m .3149 .45845 L .29646 .46477 L p F P
0 g
s
.337 .816 .785 r
.52962 .35807 m .54586 .35504 L .56494 .34841 L p F P
0 g
s
.337 .816 .785 r
.54586 .35504 m .52962 .35807 L .51039 .36475 L p F P
0 g
s
.088 0 0 r
.42007 .40398 m .43481 .39103 L .45351 .38453 L p F P
0 g
s
.088 0 0 r
.43481 .39103 m .42007 .40398 L .40123 .4105 L p F P
0 g
s
.511 .226 .418 r
.94559 .64725 m .94615 .61815 L .92574 .62384 L p F P
0 g
s
.511 .226 .418 r
.92574 .62384 m .92487 .65292 L .94559 .64725 L p F P
0 g
s
.489 .878 .966 r
.51422 .78761 m .53437 .79131 L .51539 .79639 L p F P
0 g
s
.489 .878 .966 r
.51539 .79639 m .49498 .79279 L .51422 .78761 L p F P
0 g
s
0 0 0 r
.63131 .76533 m .64724 .75986 L .62787 .76505 L p F P
0 g
s
0 0 0 r
.62787 .76505 m .61164 .7706 L .63131 .76533 L p F P
0 g
s
.591 .902 .985 r
.64263 .32145 m .65955 .32833 L .67904 .32161 L p F P
0 g
s
.591 .902 .985 r
.65955 .32833 m .64263 .32145 L .62301 .32826 L p F P
0 g
s
.244 0 0 r
.74618 .73332 m .75711 .71912 L .73735 .72446 L p F P
0 g
s
.244 0 0 r
.73735 .72446 m .72612 .73871 L .74618 .73332 L p F P
0 g
s
.642 .75 .927 r
.29755 .79887 m .32195 .82059 L .3037 .82558 L p F P
0 g
s
.642 .75 .927 r
.3037 .82558 m .27915 .80399 L .29755 .79887 L p F P
0 g
s
1 1 0 r
.007 w
.30238 .82464 m
.30336 .82527 L
s
.94604 .61676 m
.94613 .6192 L
s
.94613 .6192 m
.94632 .62371 L
s
.94581 .61108 m
.94604 .61676 L
s
.5 Mabswid
.427 .064 .243 r
.85801 .69186 m .86357 .6697 L .84343 .67521 L p F P
0 g
s
.427 .064 .243 r
.84343 .67521 m .83754 .69739 L .85801 .69186 L p F P
0 g
s
.471 .182 .392 r
.23329 .514 m .24192 .48346 L .25997 .47727 L p F P
0 g
s
.471 .182 .392 r
.24192 .48346 m .23329 .514 L .21514 .52013 L p F P
0 g
s
.657 .83 .966 r
.75836 .29425 m .77532 .31054 L .79524 .30375 L p F P
0 g
s
.657 .83 .966 r
.77532 .31054 m .75836 .29425 L .73832 .30116 L p F P
0 g
s
.614 .832 .984 r
.41515 .79513 m .43809 .80813 L .4194 .81317 L p F P
0 g
s
.614 .832 .984 r
.4194 .81317 m .39625 .80029 L .41515 .79513 L p F P
0 g
s
.352 0 .172 r
.33346 .45209 m .34551 .42979 L .36395 .4234 L p F P
0 g
s
.352 0 .172 r
.34551 .42979 m .33346 .45209 L .3149 .45845 L p F P
0 g
s
.337 .816 .785 r
.54899 .35133 m .56494 .34841 L .58416 .34174 L p F P
0 g
s
.337 .816 .785 r
.56494 .34841 m .54899 .35133 L .52962 .35807 L p F P
0 g
s
.088 0 0 r
.43904 .39741 m .45351 .38453 L .47234 .37798 L p F P
0 g
s
.088 0 0 r
.45351 .38453 m .43904 .39741 L .42007 .40398 L p F P
0 g
s
.489 .878 .966 r
.53359 .78239 m .55348 .78618 L .53437 .79131 L p F P
0 g
s
.489 .878 .966 r
.53437 .79131 m .51422 .78761 L .53359 .78239 L p F P
0 g
s
0 0 0 r
.65111 .76003 m .66675 .75462 L .64724 .75986 L p F P
0 g
s
0 0 0 r
.64724 .75986 m .63131 .76533 L .65111 .76003 L p F P
0 g
s
.591 .902 .985 r
.6624 .31458 m .67904 .32161 L .69866 .31484 L p F P
0 g
s
.591 .902 .985 r
.67904 .32161 m .6624 .31458 L .64263 .32145 L p F P
0 g
s
.244 0 0 r
.7664 .7279 m .77701 .71374 L .75711 .71912 L p F P
0 g
s
.244 0 0 r
.75711 .71912 m .74618 .73332 L .7664 .7279 L p F P
0 g
s
.642 .75 .927 r
.31608 .7937 m .34033 .81557 L .32195 .82059 L p F P
0 g
s
.642 .75 .927 r
.32195 .82059 m .29755 .79887 L .31608 .7937 L p F P
0 g
s
1 1 0 r
.007 w
.29273 .81706 m
.30238 .82464 L
s
.83822 .2935 m
.84486 .3027 L
s
.5 Mabswid
.427 .064 .243 r
.87862 .68629 m .88386 .66414 L .86357 .6697 L p F P
0 g
s
.427 .064 .243 r
.86357 .6697 m .85801 .69186 L .87862 .68629 L p F P
0 g
s
1 1 0 r
.007 w
.19747 .52505 m
.19918 .5168 L
s
.5 Mabswid
.471 .182 .392 r
.25157 .50784 m .25997 .47727 L .27815 .47104 L p F P
0 g
s
.471 .182 .392 r
.25997 .47727 m .25157 .50784 L .23329 .514 L p F P
0 g
s
.657 .83 .966 r
.77855 .28729 m .79524 .30375 L .8153 .29691 L p F P
0 g
s
.657 .83 .966 r
.79524 .30375 m .77855 .28729 L .75836 .29425 L p F P
0 g
s
1 1 0 r
.007 w
.94632 .62371 m
.94628 .63544 L
s
.5 Mabswid
.614 .832 .984 r
.43419 .78993 m .45692 .80306 L .43809 .80813 L p F P
0 g
s
.614 .832 .984 r
.43809 .80813 m .41515 .79513 L .43419 .78993 L p F P
0 g
s
1 1 0 r
.007 w
.28311 .8081 m
.29273 .81706 L
s
.5 Mabswid
.352 0 .172 r
.35216 .44568 m .36395 .4234 L .38253 .41697 L p F P
0 g
s
.352 0 .172 r
.36395 .4234 m .35216 .44568 L .33346 .45209 L p F P
0 g
s
.337 .816 .785 r
.56849 .34455 m .58416 .34174 L .60352 .33503 L p F P
0 g
s
.337 .816 .785 r
.58416 .34174 m .56849 .34455 L .54899 .35133 L p F P
0 g
s
.088 0 0 r
.45814 .3908 m .47234 .37798 L .4913 .37139 L p F P
0 g
s
.088 0 0 r
.47234 .37798 m .45814 .3908 L .43904 .39741 L p F P
0 g
s
.489 .878 .966 r
.55309 .77713 m .57273 .78103 L .55348 .78618 L p F P
0 g
s
.489 .878 .966 r
.55348 .78618 m .53359 .78239 L .55309 .77713 L p F P
0 g
s
0 0 0 r
.67105 .75468 m .6864 .74936 L .66675 .75462 L p F P
0 g
s
0 0 0 r
.66675 .75462 m .65111 .76003 L .67105 .75468 L p F P
0 g
s
.591 .902 .985 r
.68231 .30767 m .69866 .31484 L .71842 .30803 L p F P
0 g
s
.591 .902 .985 r
.69866 .31484 m .68231 .30767 L .6624 .31458 L p F P
0 g
s
.244 0 0 r
.78675 .72245 m .79704 .70833 L .77701 .71374 L p F P
0 g
s
.244 0 0 r
.77701 .71374 m .7664 .7279 L .78675 .72245 L p F P
0 g
s
.642 .75 .927 r
.33475 .7885 m .35884 .81051 L .34033 .81557 L p F P
0 g
s
.642 .75 .927 r
.34033 .81557 m .31608 .7937 L .33475 .7885 L p F P
0 g
s
.427 .064 .243 r
.89938 .68069 m .90429 .65855 L .88386 .66414 L p F P
0 g
s
.427 .064 .243 r
.88386 .66414 m .87862 .68629 L .89938 .68069 L p F P
0 g
s
.532 .307 .519 r
.1934 .56344 m .19712 .52621 L .21514 .52013 L p F P
0 g
s
1 1 0 r
.007 w
.19645 .52994 m
.19703 .52717 L
s
0 0 1 r
.19596 .53011 m
.19808 .50896 L
s
.5 Mabswid
.471 .182 .392 r
.26997 .50163 m .27815 .47104 L .29646 .46477 L p F P
0 g
s
.471 .182 .392 r
.27815 .47104 m .26997 .50163 L .25157 .50784 L p F P
0 g
s
.657 .83 .966 r
.79887 .28028 m .8153 .29691 L .8355 .29002 L p F P
0 g
s
.657 .83 .966 r
.8153 .29691 m .79887 .28028 L .77855 .28729 L p F P
0 g
s
1 1 0 r
.007 w
.8361 .29089 m
.83822 .2935 L
s
.5 Mabswid
.614 .832 .984 r
.45337 .78469 m .47589 .79794 L .45692 .80306 L p F P
0 g
s
.614 .832 .984 r
.45692 .80306 m .43419 .78993 L .45337 .78469 L p F P
0 g
s
.352 0 .172 r
.371 .43922 m .38253 .41697 L .40123 .4105 L p F P
0 g
s
.352 0 .172 r
.38253 .41697 m .371 .43922 L .35216 .44568 L p F P
0 g
s
.337 .816 .785 r
.58814 .33773 m .60352 .33503 L .62301 .32826 L p F P
0 g
s
.337 .816 .785 r
.60352 .33503 m .58814 .33773 L .56849 .34455 L p F P
0 g
s
.088 0 0 r
.47739 .38414 m .4913 .37139 L .51039 .36475 L p F P
0 g
s
.088 0 0 r
.4913 .37139 m .47739 .38414 L .45814 .3908 L p F P
0 g
s
.489 .878 .966 r
.57274 .77183 m .59212 .77583 L .57273 .78103 L p F P
0 g
s
.489 .878 .966 r
.57273 .78103 m .55309 .77713 L .57274 .77183 L p F P
0 g
s
0 0 0 r
.69114 .7493 m .70619 .74405 L .6864 .74936 L p F P
0 g
s
0 0 0 r
.6864 .74936 m .67105 .75468 L .69114 .7493 L p F P
0 g
s
.591 .902 .985 r
.70236 .30071 m .71842 .30803 L .73832 .30116 L p F P
0 g
s
.591 .902 .985 r
.71842 .30803 m .70236 .30071 L .68231 .30767 L p F P
0 g
s
.244 0 0 r
.80726 .71695 m .81722 .70288 L .79704 .70833 L p F P
0 g
s
.244 0 0 r
.79704 .70833 m .78675 .72245 L .80726 .71695 L p F P
0 g
s
.642 .75 .927 r
.35354 .78327 m .37748 .80542 L .35884 .81051 L p F P
0 g
s
.642 .75 .927 r
.35884 .81051 m .33475 .7885 L .35354 .78327 L p F P
0 g
s
1 1 0 r
.007 w
.28002 .80476 m
.28311 .8081 L
s
.5 Mabswid
.427 .064 .243 r
.92029 .67504 m .92487 .65292 L .90429 .65855 L p F P
0 g
s
.427 .064 .243 r
.90429 .65855 m .89938 .68069 L .92029 .67504 L p F P
0 g
s
1 1 0 r
.007 w
.94568 .6462 m
.94628 .63544 L
s
.5 Mabswid
.532 .307 .519 r
.21161 .55742 m .21514 .52013 L .23329 .514 L p F P
0 g
s
.532 .307 .519 r
.21514 .52013 m .21161 .55742 L .1934 .56344 L p F P
0 g
s
1 1 0 r
.007 w
.19456 .54409 m
.19645 .52994 L
s
0 0 1 r
.19456 .54409 m
.19596 .53011 L
s
.5 Mabswid
.471 .182 .392 r
.28851 .49538 m .29646 .46477 L .3149 .45845 L p F P
0 g
s
.471 .182 .392 r
.29646 .46477 m .28851 .49538 L .26997 .50163 L p F P
0 g
s
.657 .83 .966 r
.8355 .29002 m .81935 .27322 L .79887 .28028 L p F P
0 g
s
1 1 0 r
.007 w
.83168 .28545 m
.83486 .28936 L
s
.83486 .28936 m
.8361 .29089 L
s
.5 Mabswid
.614 .832 .984 r
.47268 .77941 m .49498 .79279 L .47589 .79794 L p F P
0 g
s
.614 .832 .984 r
.47589 .79794 m .45337 .78469 L .47268 .77941 L p F P
0 g
s
.643 .679 .869 r
.27401 .76867 m .29755 .79887 L .27915 .80399 L p F P
0 g
s
.643 .679 .869 r
.27915 .80399 m .2555 .77395 L .27401 .76867 L p F P
0 g
s
1 1 0 r
.007 w
.27359 .7978 m
.27821 .8028 L
s
.5 Mabswid
.352 0 .172 r
.38996 .43272 m .40123 .4105 L .42007 .40398 L p F P
0 g
s
.352 0 .172 r
.40123 .4105 m .38996 .43272 L .371 .43922 L p F P
0 g
s
.337 .816 .785 r
.60793 .33085 m .62301 .32826 L .64263 .32145 L p F P
0 g
s
.337 .816 .785 r
.62301 .32826 m .60793 .33085 L .58814 .33773 L p F P
0 g
s
.088 0 0 r
.49677 .37743 m .51039 .36475 L .52962 .35807 L p F P
0 g
s
.088 0 0 r
.51039 .36475 m .49677 .37743 L .47739 .38414 L p F P
0 g
s
.489 .878 .966 r
.59253 .7665 m .61164 .7706 L .59212 .77583 L p F P
0 g
s
.489 .878 .966 r
.59212 .77583 m .57274 .77183 L .59253 .7665 L p F P
0 g
s
0 0 0 r
.71137 .74388 m .72612 .73871 L .70619 .74405 L p F P
0 g
s
0 0 0 r
.70619 .74405 m .69114 .7493 L .71137 .74388 L p F P
0 g
s
.591 .902 .985 r
.72255 .2937 m .73832 .30116 L .75836 .29425 L p F P
0 g
s
.591 .902 .985 r
.73832 .30116 m .72255 .2937 L .70236 .30071 L p F P
0 g
s
.244 0 0 r
.82791 .71141 m .83754 .69739 L .81722 .70288 L p F P
0 g
s
.244 0 0 r
.81722 .70288 m .80726 .71695 L .82791 .71141 L p F P
0 g
s
1 1 0 r
.007 w
.19353 .55914 m
.19456 .54409 L
s
.5 Mabswid
.642 .75 .927 r
.37248 .77799 m .39625 .80029 L .37748 .80542 L p F P
0 g
s
.642 .75 .927 r
.37748 .80542 m .35354 .78327 L .37248 .77799 L p F P
0 g
s
.427 .064 .243 r
.94135 .66935 m .94559 .64725 L .92487 .65292 L p F P
0 g
s
.427 .064 .243 r
.92487 .65292 m .92029 .67504 L .94135 .66935 L p F P
0 g
s
.532 .307 .519 r
.22996 .55136 m .23329 .514 L .25157 .50784 L p F P
0 g
s
.532 .307 .519 r
.23329 .514 m .22996 .55136 L .21161 .55742 L p F P
0 g
s
.471 .182 .392 r
.30718 .48908 m .3149 .45845 L .33346 .45209 L p F P
0 g
s
.471 .182 .392 r
.3149 .45845 m .30718 .48908 L .28851 .49538 L p F P
0 g
s
1 1 0 r
.007 w
.82531 .27861 m
.83168 .28545 L
s
.26426 .78624 m
.27359 .7978 L
s
.5 Mabswid
.614 .832 .984 r
.49213 .7741 m .51422 .78761 L .49498 .79279 L p F P
0 g
s
.614 .832 .984 r
.49498 .79279 m .47268 .77941 L .49213 .7741 L p F P
0 g
s
.643 .679 .869 r
.29265 .76334 m .31608 .7937 L .29755 .79887 L p F P
0 g
s
.643 .679 .869 r
.29755 .79887 m .27401 .76867 L .29265 .76334 L p F P
0 g
s
.352 0 .172 r
.40907 .42618 m .42007 .40398 L .43904 .39741 L p F P
0 g
s
.352 0 .172 r
.42007 .40398 m .40907 .42618 L .38996 .43272 L p F P
0 g
s
.337 .816 .785 r
.62785 .32392 m .64263 .32145 L .6624 .31458 L p F P
0 g
s
.337 .816 .785 r
.64263 .32145 m .62785 .32392 L .60793 .33085 L p F P
0 g
s
.088 0 0 r
.51629 .37067 m .52962 .35807 L .54899 .35133 L p F P
0 g
s
.088 0 0 r
.52962 .35807 m .51629 .37067 L .49677 .37743 L p F P
0 g
s
.489 .878 .966 r
.61246 .76112 m .63131 .76533 L .61164 .7706 L p F P
0 g
s
.489 .878 .966 r
.61164 .7706 m .59253 .7665 L .61246 .76112 L p F P
0 g
s
0 0 0 r
.73175 .73842 m .74618 .73332 L .72612 .73871 L p F P
0 g
s
0 0 0 r
.72612 .73871 m .71137 .74388 L .73175 .73842 L p F P
0 g
s
.591 .902 .985 r
.74289 .28664 m .75836 .29425 L .77855 .28729 L p F P
0 g
s
.591 .902 .985 r
.75836 .29425 m .74289 .28664 L .72255 .2937 L p F P
0 g
s
.244 0 0 r
.84871 .70583 m .85801 .69186 L .83754 .69739 L p F P
0 g
s
.244 0 0 r
.83754 .69739 m .82791 .71141 L .84871 .70583 L p F P
0 g
s
1 1 0 r
.007 w
.9455 .6477 m
.94559 .64693 L
s
.94452 .65588 m
.9455 .6477 L
s
.94559 .64693 m
.94568 .6462 L
s
.5 Mabswid
.642 .75 .927 r
.39154 .77268 m .41515 .79513 L .39625 .80029 L p F P
0 g
s
.642 .75 .927 r
.39625 .80029 m .37248 .77799 L .39154 .77268 L p F P
0 g
s
1 1 0 r
.007 w
.1935 .56245 m
.19353 .55914 L
s
.5 Mabswid
.532 .307 .519 r
.24843 .54526 m .25157 .50784 L .26997 .50163 L p F P
0 g
s
.532 .307 .519 r
.25157 .50784 m .24843 .54526 L .22996 .55136 L p F P
0 g
s
.471 .182 .392 r
.32598 .48273 m .33346 .45209 L .35216 .44568 L p F P
0 g
s
.471 .182 .392 r
.33346 .45209 m .32598 .48273 L .30718 .48908 L p F P
0 g
s
.568 .392 .603 r
.19541 .60554 m .1934 .56344 L .21161 .55742 L p F P
0 g
s
1 1 0 r
.007 w
.19338 .57498 m
.19348 .565 L
s
.2557 .7742 m
.26426 .78624 L
s
.5 Mabswid
.614 .832 .984 r
.51172 .76874 m .53359 .78239 L .51422 .78761 L p F P
0 g
s
.614 .832 .984 r
.51422 .78761 m .49213 .7741 L .51172 .76874 L p F P
0 g
s
.643 .679 .869 r
.31142 .75798 m .33475 .7885 L .31608 .7937 L p F P
0 g
s
.643 .679 .869 r
.31608 .7937 m .29265 .76334 L .31142 .75798 L p F P
0 g
s
.352 0 .172 r
.42831 .41958 m .43904 .39741 L .45814 .3908 L p F P
0 g
s
.352 0 .172 r
.43904 .39741 m .42831 .41958 L .40907 .42618 L p F P
0 g
s
.337 .816 .785 r
.64793 .31694 m .6624 .31458 L .68231 .30767 L p F P
0 g
s
.337 .816 .785 r
.6624 .31458 m .64793 .31694 L .62785 .32392 L p F P
0 g
s
.088 0 0 r
.53595 .36387 m .54899 .35133 L .56849 .34455 L p F P
0 g
s
.088 0 0 r
.54899 .35133 m .53595 .36387 L .51629 .37067 L p F P
0 g
s
.489 .878 .966 r
.63254 .75571 m .65111 .76003 L .63131 .76533 L p F P
0 g
s
.489 .878 .966 r
.63131 .76533 m .61246 .76112 L .63254 .75571 L p F P
0 g
s
0 0 0 r
.75228 .73292 m .7664 .7279 L .74618 .73332 L p F P
0 g
s
0 0 0 r
.74618 .73332 m .73175 .73842 L .75228 .73292 L p F P
0 g
s
.591 .902 .985 r
.76338 .27953 m .77855 .28729 L .79887 .28028 L p F P
0 g
s
.591 .902 .985 r
.77855 .28729 m .76338 .27953 L .74289 .28664 L p F P
0 g
s
.244 0 0 r
.86966 .70022 m .87862 .68629 L .85801 .69186 L p F P
0 g
s
.244 0 0 r
.85801 .69186 m .84871 .70583 L .86966 .70022 L p F P
0 g
s
.642 .75 .927 r
.41075 .76733 m .43419 .78993 L .41515 .79513 L p F P
0 g
s
.642 .75 .927 r
.41515 .79513 m .39154 .77268 L .41075 .76733 L p F P
0 g
s
1 1 0 r
.007 w
.81948 .27336 m
.82531 .27861 L
s
.19338 .57498 m
.19412 .59148 L
s
.5 Mabswid
.532 .307 .519 r
.26997 .50163 m .28851 .49538 L p .27955 .51362 L F P
0 g
s
.532 .307 .519 r
.269 .51412 m .26997 .50163 L p .27955 .51362 L F P
0 g
s
.532 .307 .519 r
.28851 .49538 m .30718 .48908 L p .29396 .51618 L F P
0 g
s
.486 0 0 r
.28779 .51383 m .27652 .52109 L p .2864 .5133 L F P
0 g
s
.099 0 0 r
.27524 .52373 m .27652 .52109 L .28779 .51383 L p F P
0 g
s
.532 .307 .519 r
.28578 .53292 m .2871 .51482 L p .29396 .51618 L F P
0 g
s
.532 .307 .519 r
.2871 .51482 m .28712 .51448 L p .2875 .51458 L F P
0 g
s
.532 .307 .519 r
.2871 .51482 m .2875 .51458 L .29396 .51618 L F
.28712 .51448 m .28779 .51383 L .29396 .51618 L F
.28719 .5136 m .28851 .49538 L p .29396 .51618 L F P
0 g
s
.099 0 0 r
.28625 .51534 m .27524 .52373 L p .28779 .51383 L F P
0 g
s
.761 0 0 r
.27342 .52315 m .27524 .52373 L .28625 .51534 L p F P
0 g
s
.486 0 0 r
.27652 .52109 m .27579 .51657 L .2864 .5133 L p F P
0 g
s
.545 0 0 r
.2864 .5133 m .27579 .51657 L .27413 .51388 L p F P
0 g
s
.532 .307 .519 r
.28851 .49538 m .28578 .53292 L .26704 .53912 L p F P
0 g
s
.099 0 0 r
.28779 .51383 m .29064 .51199 L .28625 .51534 L p F P
0 g
s
.532 .307 .519 r
.28712 .51448 m .28719 .5136 L p .28779 .51383 L F P
0 g
s
.486 0 0 r
.2864 .5133 m .29064 .51199 L .28779 .51383 L p F P
0 g
s
.532 .307 .519 r
.26704 .53912 m .269 .51412 L p .27955 .51362 L F P
0 g
s
.761 0 0 r
.29064 .51199 m .27269 .52293 L .27342 .52315 L p F P
0 g
s
.761 0 0 r
.28625 .51534 m .29064 .51199 L p .27342 .52315 L F P
0 g
s
.545 0 0 r
.27347 .51281 m .29064 .51199 L .2864 .5133 L p F P
0 g
s
.545 0 0 r
.27413 .51388 m .27347 .51281 L p .2864 .5133 L F P
0 g
s
.532 .307 .519 r
.26997 .50163 m .26704 .53912 L .24843 .54526 L p F P
0 g
s
.471 .182 .392 r
.34493 .47634 m .35216 .44568 L .371 .43922 L p F P
0 g
s
.471 .182 .392 r
.35216 .44568 m .34493 .47634 L .32598 .48273 L p F P
0 g
s
.568 .392 .603 r
.21378 .59962 m .21161 .55742 L .22996 .55136 L p F P
0 g
s
.568 .392 .603 r
.21161 .55742 m .21378 .59962 L .19541 .60554 L p F P
0 g
s
.636 .619 .816 r
.2527 .73145 m .27401 .76867 L .2555 .77395 L p F P
0 g
s
.636 .619 .816 r
.2555 .77395 m .23414 .7369 L .2527 .73145 L p F P
0 g
s
1 1 0 r
.007 w
.2552 .7735 m
.25542 .77381 L
s
.24649 .75968 m
.2552 .7735 L
s
.5 Mabswid
.614 .832 .984 r
.53146 .76335 m .55309 .77713 L .53359 .78239 L p F P
0 g
s
.614 .832 .984 r
.53359 .78239 m .51172 .76874 L .53146 .76335 L p F P
0 g
s
.643 .679 .869 r
.33033 .75258 m .35354 .78327 L .33475 .7885 L p F P
0 g
s
.643 .679 .869 r
.33475 .7885 m .31142 .75798 L .33033 .75258 L p F P
0 g
s
.352 0 .172 r
.44769 .41294 m .45814 .3908 L .47739 .38414 L p F P
0 g
s
.352 0 .172 r
.45814 .3908 m .44769 .41294 L .42831 .41958 L p F P
0 g
s
1 1 0 r
.007 w
.94279 .66442 m
.94452 .65588 L
s
.5 Mabswid
.337 .816 .785 r
.66814 .30991 m .68231 .30767 L .70236 .30071 L p F P
0 g
s
.337 .816 .785 r
.68231 .30767 m .66814 .30991 L .64793 .31694 L p F P
0 g
s
.088 0 0 r
.55575 .35701 m .56849 .34455 L .58814 .33773 L p F P
0 g
s
.088 0 0 r
.56849 .34455 m .55575 .35701 L .53595 .36387 L p F P
0 g
s
.489 .878 .966 r
.65276 .75026 m .67105 .75468 L .65111 .76003 L p F P
0 g
s
.489 .878 .966 r
.65111 .76003 m .63254 .75571 L .65276 .75026 L p F P
0 g
s
0 0 0 r
.77295 .72738 m .78675 .72245 L .7664 .7279 L p F P
0 g
s
0 0 0 r
.7664 .7279 m .75228 .73292 L .77295 .72738 L p F P
0 g
s
.591 .902 .985 r
.78401 .27237 m .79887 .28028 L .81935 .27322 L p F P
0 g
s
.591 .902 .985 r
.79887 .28028 m .78401 .27237 L .76338 .27953 L p F P
0 g
s
.244 0 0 r
.89076 .69456 m .89938 .68069 L .87862 .68629 L p F P
0 g
s
.244 0 0 r
.87862 .68629 m .86966 .70022 L .89076 .69456 L p F P
0 g
s
.642 .75 .927 r
.4301 .76193 m .45337 .78469 L .43419 .78993 L p F P
0 g
s
.642 .75 .927 r
.43419 .78993 m .41075 .76733 L .4301 .76193 L p F P
0 g
s
1 1 0 r
.007 w
.19412 .59148 m
.19535 .60428 L
s
.5 Mabswid
.471 .182 .392 r
.364 .46991 m .371 .43922 L .38996 .43272 L p F P
0 g
s
.471 .182 .392 r
.371 .43922 m .364 .46991 L .34493 .47634 L p F P
0 g
s
1 1 0 r
.007 w
.23822 .74489 m
.24649 .75968 L
s
.5 Mabswid
.568 .392 .603 r
.23229 .59366 m .22996 .55136 L .24843 .54526 L p F P
0 g
s
.568 .392 .603 r
.22996 .55136 m .23229 .59366 L .21378 .59962 L p F P
0 g
s
.636 .619 .816 r
.27139 .72595 m .29265 .76334 L .27401 .76867 L p F P
0 g
s
.636 .619 .816 r
.27401 .76867 m .2527 .73145 L .27139 .72595 L p F P
0 g
s
.614 .832 .984 r
.55134 .75792 m .57274 .77183 L .55309 .77713 L p F P
0 g
s
.614 .832 .984 r
.55309 .77713 m .53146 .76335 L .55134 .75792 L p F P
0 g
s
.643 .679 .869 r
.34937 .74713 m .37248 .77799 L .35354 .78327 L p F P
0 g
s
.643 .679 .869 r
.35354 .78327 m .33033 .75258 L .34937 .74713 L p F P
0 g
s
.352 0 .172 r
.46721 .40625 m .47739 .38414 L .49677 .37743 L p F P
0 g
s
.352 0 .172 r
.47739 .38414 m .46721 .40625 L .44769 .41294 L p F P
0 g
s
.593 .457 .666 r
.20319 .65019 m .19541 .60554 L .21378 .59962 L p F P
0 g
s
1 1 0 r
.007 w
.19555 .60631 m
.19576 .6085 L
s
.5 Mabswid
.295 0 0 r
.27347 .51281 m .27092 .51199 L .29064 .51199 L closepath p F P
0 g
s
.337 .816 .785 r
.68851 .30284 m .70236 .30071 L .72255 .2937 L p F P
0 g
s
.337 .816 .785 r
.70236 .30071 m .68851 .30284 L .66814 .30991 L p F P
0 g
s
.088 0 0 r
.5757 .35011 m .58814 .33773 L .60793 .33085 L p F P
0 g
s
.088 0 0 r
.58814 .33773 m .5757 .35011 L .55575 .35701 L p F P
0 g
s
.489 .878 .966 r
.67313 .74477 m .69114 .7493 L .67105 .75468 L p F P
0 g
s
.489 .878 .966 r
.67105 .75468 m .65276 .75026 L .67313 .74477 L p F P
0 g
s
1 1 0 r
.007 w
.19576 .6085 m
.19828 .62589 L
s
.5 Mabswid
0 0 0 r
.79378 .7218 m .80726 .71695 L .78675 .72245 L p F P
0 g
s
0 0 0 r
.78675 .72245 m .77295 .72738 L .79378 .7218 L p F P
0 g
s
.591 .902 .985 r
.81935 .27322 m .8048 .26515 L .78401 .27237 L p F P
0 g
s
1 1 0 r
.007 w
.81914 .27305 m
.81929 .27319 L
s
.81929 .27319 m
.81948 .27336 L
s
.5 Mabswid
.244 0 0 r
.91202 .68886 m .92029 .67504 L .89938 .68069 L p F P
0 g
s
.244 0 0 r
.89938 .68069 m .89076 .69456 L .91202 .68886 L p F P
0 g
s
1 1 0 r
.007 w
.81321 .26884 m
.81914 .27305 L
s
.5 Mabswid
.642 .75 .927 r
.44958 .7565 m .47268 .77941 L .45337 .78469 L p F P
0 g
s
.642 .75 .927 r
.45337 .78469 m .4301 .76193 L .44958 .7565 L p F P
0 g
s
1 1 0 r
.007 w
.23498 .73836 m
.23822 .74489 L
s
.5 Mabswid
.532 .307 .519 r
.30466 .52669 m .30718 .48908 L .32598 .48273 L p F P
0 g
s
.532 .307 .519 r
.30718 .48908 m .30466 .52669 L .28578 .53292 L p F P
0 g
s
.471 .182 .392 r
.38322 .46343 m .38996 .43272 L .40907 .42618 L p F P
0 g
s
.471 .182 .392 r
.38996 .43272 m .38322 .46343 L .364 .46991 L p F P
0 g
s
.56 0 0 r
.27092 .51199 m .26963 .51462 L .29064 .51199 L closepath p F P
0 g
s
.625 .565 .768 r
.2349 .68922 m .2527 .73145 L .23414 .7369 L p F P
0 g
s
.625 .565 .768 r
.23414 .7369 m .21635 .69485 L .2349 .68922 L p F P
0 g
s
1 1 0 r
.007 w
.23047 .72926 m
.23347 .73531 L
s
.5 Mabswid
.568 .392 .603 r
.25093 .58766 m .24843 .54526 L .26704 .53912 L p F P
0 g
s
.568 .392 .603 r
.24843 .54526 m .25093 .58766 L .23229 .59366 L p F P
0 g
s
1 1 0 r
.007 w
.19828 .62589 m
.20168 .64349 L
s
.5 Mabswid
.636 .619 .816 r
.29021 .72042 m .31142 .75798 L .29265 .76334 L p F P
0 g
s
.636 .619 .816 r
.29265 .76334 m .27139 .72595 L .29021 .72042 L p F P
0 g
s
1 1 0 r
.007 w
.94152 .66846 m
.94279 .66442 L
s
.5 Mabswid
.614 .832 .984 r
.57136 .75245 m .59253 .7665 L .57274 .77183 L p F P
0 g
s
.614 .832 .984 r
.57274 .77183 m .55134 .75792 L .57136 .75245 L p F P
0 g
s
.713 0 0 r
.27036 .51915 m .27269 .52293 L .29064 .51199 L closepath p F P
0 g
s
.643 .679 .869 r
.36855 .74165 m .39154 .77268 L .37248 .77799 L p F P
0 g
s
.643 .679 .869 r
.37248 .77799 m .34937 .74713 L .36855 .74165 L p F P
0 g
s
1 1 0 r
.007 w
.22329 .71293 m
.23047 .72926 L
s
.5 Mabswid
.352 0 .172 r
.48688 .39951 m .49677 .37743 L .51629 .37067 L p F P
0 g
s
.352 0 .172 r
.49677 .37743 m .48688 .39951 L .46721 .40625 L p F P
0 g
s
.662 0 0 r
.26963 .51462 m .27036 .51915 L .29064 .51199 L closepath p F P
0 g
s
1 0 0 r
.007 w
.19456 .54409 m
.2703 .51879 L
s
.5 Mabswid
.593 .457 .666 r
.22167 .64441 m .21378 .59962 L .23229 .59366 L p F P
0 g
s
.593 .457 .666 r
.21378 .59962 m .22167 .64441 L .20319 .65019 L p F P
0 g
s
.337 .816 .785 r
.70902 .2957 m .72255 .2937 L .74289 .28664 L p F P
0 g
s
.337 .816 .785 r
.72255 .2937 m .70902 .2957 L .68851 .30284 L p F P
0 g
s
.088 0 0 r
.5958 .34315 m .60793 .33085 L .62785 .32392 L p F P
0 g
s
.088 0 0 r
.60793 .33085 m .5958 .34315 L .5757 .35011 L p F P
0 g
s
.489 .878 .966 r
.69365 .73923 m .71137 .74388 L .69114 .7493 L p F P
0 g
s
.489 .878 .966 r
.69114 .7493 m .67313 .74477 L .69365 .73923 L p F P
0 g
s
0 0 0 r
.81476 .71618 m .82791 .71141 L .80726 .71695 L p F P
0 g
s
0 0 0 r
.80726 .71695 m .79378 .7218 L .81476 .71618 L p F P
0 g
s
.244 0 0 r
.93343 .68311 m .94135 .66935 L .92029 .67504 L p F P
0 g
s
1 1 0 r
.007 w
.9411 .66977 m
.94152 .66846 L
s
.94049 .67172 m
.9411 .66977 L
s
.5 Mabswid
.244 0 0 r
.92029 .67504 m .91202 .68886 L .93343 .68311 L p F P
0 g
s
1 1 0 r
.007 w
.20168 .64349 m
.20293 .64871 L
s
.5 Mabswid
.642 .75 .927 r
.46921 .75104 m .49213 .7741 L .47268 .77941 L p F P
0 g
s
.642 .75 .927 r
.47268 .77941 m .44958 .7565 L .46921 .75104 L p F P
0 g
s
1 1 0 r
.007 w
.21677 .69603 m
.22329 .71293 L
s
.5 Mabswid
.611 .513 .719 r
.21635 .69485 m .20319 .65019 L .22167 .64441 L p F P
0 g
s
1 1 0 r
.007 w
.20371 .65198 m
.20591 .66116 L
s
.20591 .66116 m
.21096 .67872 L
s
.5 Mabswid
.532 .307 .519 r
.32367 .52041 m .32598 .48273 L .34493 .47634 L p F P
0 g
s
.532 .307 .519 r
.32598 .48273 m .32367 .52041 L .30466 .52669 L p F P
0 g
s
.471 .182 .392 r
.40257 .4569 m .40907 .42618 L .42831 .41958 L p F P
0 g
s
.471 .182 .392 r
.40907 .42618 m .40257 .4569 L .38322 .46343 L p F P
0 g
s
1 1 0 r
.007 w
.21648 .69516 m
.21677 .69603 L
s
.21096 .67872 m
.21615 .69418 L
s
.21635 .69479 m
.21637 .69484 L
s
.5 Mabswid
.611 .513 .719 r
.22167 .64441 m .2349 .68922 L .21635 .69485 L p F P
0 g
s
.625 .565 .768 r
.25358 .68356 m .27139 .72595 L .2527 .73145 L p F P
0 g
s
.625 .565 .768 r
.2527 .73145 m .2349 .68922 L .25358 .68356 L p F P
0 g
s
.568 .392 .603 r
.2697 .58162 m .26704 .53912 L .28578 .53292 L p F P
0 g
s
.568 .392 .603 r
.26704 .53912 m .2697 .58162 L .25093 .58766 L p F P
0 g
s
.636 .619 .816 r
.30917 .71484 m .33033 .75258 L .31142 .75798 L p F P
0 g
s
.636 .619 .816 r
.31142 .75798 m .29021 .72042 L .30917 .71484 L p F P
0 g
s
.614 .832 .984 r
.59153 .74694 m .61246 .76112 L .59253 .7665 L p F P
0 g
s
.614 .832 .984 r
.59253 .7665 m .57136 .75245 L .59153 .74694 L p F P
0 g
s
.643 .679 .869 r
.38788 .73613 m .41075 .76733 L .39154 .77268 L p F P
0 g
s
.643 .679 .869 r
.39154 .77268 m .36855 .74165 L .38788 .73613 L p F P
0 g
s
.352 0 .172 r
.50669 .39272 m .51629 .37067 L .53595 .36387 L p F P
0 g
s
.352 0 .172 r
.51629 .37067 m .50669 .39272 L .48688 .39951 L p F P
0 g
s
.593 .457 .666 r
.24029 .63859 m .23229 .59366 L .25093 .58766 L p F P
0 g
s
.593 .457 .666 r
.23229 .59366 m .24029 .63859 L .22167 .64441 L p F P
0 g
s
.337 .816 .785 r
.72969 .28852 m .74289 .28664 L .76338 .27953 L p F P
0 g
s
.337 .816 .785 r
.74289 .28664 m .72969 .28852 L .70902 .2957 L p F P
0 g
s
.088 0 0 r
.61604 .33614 m .62785 .32392 L .64793 .31694 L p F P
0 g
s
.088 0 0 r
.62785 .32392 m .61604 .33614 L .5958 .34315 L p F P
0 g
s
1 1 0 r
.007 w
.80758 .26604 m
.81321 .26884 L
s
.5 Mabswid
.489 .878 .966 r
.71432 .73366 m .73175 .73842 L .71137 .74388 L p F P
0 g
s
.489 .878 .966 r
.71137 .74388 m .69365 .73923 L .71432 .73366 L p F P
0 g
s
0 0 0 r
.83589 .71052 m .84871 .70583 L .82791 .71141 L p F P
0 g
s
0 0 0 r
.82791 .71141 m .81476 .71618 L .83589 .71052 L p F P
0 g
s
.642 .75 .927 r
.48899 .74553 m .51172 .76874 L .49213 .7741 L p F P
0 g
s
.642 .75 .927 r
.49213 .7741 m .46921 .75104 L .48899 .74553 L p F P
0 g
s
.611 .513 .719 r
.2349 .68922 m .22167 .64441 L .24029 .63859 L p F P
0 g
s
.532 .307 .519 r
.34283 .51408 m .34493 .47634 L .364 .46991 L p F P
0 g
s
.532 .307 .519 r
.34493 .47634 m .34283 .51408 L .32367 .52041 L p F P
0 g
s
.471 .182 .392 r
.42207 .45032 m .42831 .41958 L .44769 .41294 L p F P
0 g
s
.471 .182 .392 r
.42831 .41958 m .42207 .45032 L .40257 .4569 L p F P
0 g
s
.611 .513 .719 r
.24029 .63859 m .25358 .68356 L .2349 .68922 L p F P
0 g
s
.625 .565 .768 r
.2724 .67785 m .29021 .72042 L .27139 .72595 L p F P
0 g
s
.625 .565 .768 r
.27139 .72595 m .25358 .68356 L .2724 .67785 L p F P
0 g
s
.568 .392 .603 r
.28861 .57553 m .28578 .53292 L .30466 .52669 L p F P
0 g
s
.568 .392 .603 r
.28578 .53292 m .28861 .57553 L .2697 .58162 L p F P
0 g
s
.636 .619 .816 r
.32827 .70922 m .34937 .74713 L .33033 .75258 L p F P
0 g
s
.636 .619 .816 r
.33033 .75258 m .30917 .71484 L .32827 .70922 L p F P
0 g
s
1 1 0 r
.007 w
.93763 .67772 m
.94049 .67172 L
s
.5 Mabswid
.614 .832 .984 r
.61185 .74139 m .63254 .75571 L .61246 .76112 L p F P
0 g
s
.614 .832 .984 r
.61246 .76112 m .59153 .74694 L .61185 .74139 L p F P
0 g
s
.643 .679 .869 r
.40734 .73057 m .4301 .76193 L .41075 .76733 L p F P
0 g
s
.643 .679 .869 r
.41075 .76733 m .38788 .73613 L .40734 .73057 L p F P
0 g
s
.352 0 .172 r
.52664 .38588 m .53595 .36387 L .55575 .35701 L p F P
0 g
s
.352 0 .172 r
.53595 .36387 m .52664 .38588 L .50669 .39272 L p F P
0 g
s
.593 .457 .666 r
.25905 .63272 m .25093 .58766 L .2697 .58162 L p F P
0 g
s
.593 .457 .666 r
.25093 .58766 m .25905 .63272 L .24029 .63859 L p F P
0 g
s
.337 .816 .785 r
.75051 .28128 m .76338 .27953 L .78401 .27237 L p F P
0 g
s
.337 .816 .785 r
.76338 .27953 m .75051 .28128 L .72969 .28852 L p F P
0 g
s
.088 0 0 r
.63643 .32908 m .64793 .31694 L .66814 .30991 L p F P
0 g
s
.088 0 0 r
.64793 .31694 m .63643 .32908 L .61604 .33614 L p F P
0 g
s
.489 .878 .966 r
.73515 .72805 m .75228 .73292 L .73175 .73842 L p F P
0 g
s
.489 .878 .966 r
.73175 .73842 m .71432 .73366 L .73515 .72805 L p F P
0 g
s
0 0 0 r
.85718 .70481 m .86966 .70022 L .84871 .70583 L p F P
0 g
s
0 0 0 r
.84871 .70583 m .83589 .71052 L .85718 .70481 L p F P
0 g
s
.642 .75 .927 r
.5089 .73998 m .53146 .76335 L .51172 .76874 L p F P
0 g
s
.642 .75 .927 r
.51172 .76874 m .48899 .74553 L .5089 .73998 L p F P
0 g
s
.611 .513 .719 r
.25358 .68356 m .24029 .63859 L .25905 .63272 L p F P
0 g
s
.532 .307 .519 r
.36212 .50771 m .364 .46991 L .38322 .46343 L p F P
0 g
s
.532 .307 .519 r
.364 .46991 m .36212 .50771 L .34283 .51408 L p F P
0 g
s
.471 .182 .392 r
.44171 .44369 m .44769 .41294 L .46721 .40625 L p F P
0 g
s
.471 .182 .392 r
.44769 .41294 m .44171 .44369 L .42207 .45032 L p F P
0 g
s
.611 .513 .719 r
.25905 .63272 m .2724 .67785 L .25358 .68356 L p F P
0 g
s
.625 .565 .768 r
.29135 .6721 m .30917 .71484 L .29021 .72042 L p F P
0 g
s
.625 .565 .768 r
.29021 .72042 m .2724 .67785 L .29135 .6721 L p F P
0 g
s
.568 .392 .603 r
.30766 .5694 m .30466 .52669 L .32367 .52041 L p F P
0 g
s
.568 .392 .603 r
.30466 .52669 m .30766 .5694 L .28861 .57553 L p F P
0 g
s
.636 .619 .816 r
.34751 .70357 m .36855 .74165 L .34937 .74713 L p F P
0 g
s
.636 .619 .816 r
.34937 .74713 m .32827 .70922 L .34751 .70357 L p F P
0 g
s
.614 .832 .984 r
.63232 .7358 m .65276 .75026 L .63254 .75571 L p F P
0 g
s
.614 .832 .984 r
.63254 .75571 m .61185 .74139 L .63232 .7358 L p F P
0 g
s
.643 .679 .869 r
.42695 .72497 m .44958 .7565 L .4301 .76193 L p F P
0 g
s
.643 .679 .869 r
.4301 .76193 m .40734 .73057 L .42695 .72497 L p F P
0 g
s
.352 0 .172 r
.54674 .37899 m .55575 .35701 L .5757 .35011 L p F P
0 g
s
.352 0 .172 r
.55575 .35701 m .54674 .37899 L .52664 .38588 L p F P
0 g
s
.593 .457 .666 r
.27794 .62681 m .2697 .58162 L .28861 .57553 L p F P
0 g
s
.593 .457 .666 r
.2697 .58162 m .27794 .62681 L .25905 .63272 L p F P
0 g
s
1 1 0 r
.007 w
.80538 .26547 m
.80758 .26604 L
s
.5 Mabswid
.337 .816 .785 r
.77148 .27399 m .78401 .27237 L .8048 .26515 L p F P
0 g
s
.337 .816 .785 r
.78401 .27237 m .77148 .27399 L .75051 .28128 L p F P
0 g
s
.088 0 0 r
.65697 .32197 m .66814 .30991 L .68851 .30284 L p F P
0 g
s
.088 0 0 r
.66814 .30991 m .65697 .32197 L .63643 .32908 L p F P
0 g
s
.489 .878 .966 r
.75613 .72239 m .77295 .72738 L .75228 .73292 L p F P
0 g
s
.489 .878 .966 r
.75228 .73292 m .73515 .72805 L .75613 .72239 L p F P
0 g
s
0 0 0 r
.87863 .69907 m .89076 .69456 L .86966 .70022 L p F P
0 g
s
0 0 0 r
.86966 .70022 m .85718 .70481 L .87863 .69907 L p F P
0 g
s
.642 .75 .927 r
.52897 .73438 m .55134 .75792 L .53146 .76335 L p F P
0 g
s
.642 .75 .927 r
.53146 .76335 m .5089 .73998 L .52897 .73438 L p F P
0 g
s
.611 .513 .719 r
.2724 .67785 m .25905 .63272 L .27794 .62681 L p F P
0 g
s
.532 .307 .519 r
.38156 .50129 m .38322 .46343 L .40257 .4569 L p F P
0 g
s
.532 .307 .519 r
.38322 .46343 m .38156 .50129 L .36212 .50771 L p F P
0 g
s
.471 .182 .392 r
.4615 .43702 m .46721 .40625 L .48688 .39951 L p F P
0 g
s
.471 .182 .392 r
.46721 .40625 m .4615 .43702 L .44171 .44369 L p F P
0 g
s
.611 .513 .719 r
.27794 .62681 m .29135 .6721 L .2724 .67785 L p F P
0 g
s
.625 .565 .768 r
.31045 .66631 m .32827 .70922 L .30917 .71484 L p F P
0 g
s
.625 .565 .768 r
.30917 .71484 m .29135 .6721 L .31045 .66631 L p F P
0 g
s
.568 .392 .603 r
.32684 .56322 m .32367 .52041 L .34283 .51408 L p F P
0 g
s
.568 .392 .603 r
.32367 .52041 m .32684 .56322 L .30766 .5694 L p F P
0 g
s
1 1 0 r
.007 w
.93421 .68234 m
.93763 .67772 L
s
.5 Mabswid
.636 .619 .816 r
.36689 .69787 m .38788 .73613 L .36855 .74165 L p F P
0 g
s
.636 .619 .816 r
.36855 .74165 m .34751 .70357 L .36689 .69787 L p F P
0 g
s
.614 .832 .984 r
.65295 .73016 m .67313 .74477 L .65276 .75026 L p F P
0 g
s
.614 .832 .984 r
.65276 .75026 m .63232 .7358 L .65295 .73016 L p F P
0 g
s
.643 .679 .869 r
.4467 .71933 m .46921 .75104 L .44958 .7565 L p F P
0 g
s
.643 .679 .869 r
.44958 .7565 m .42695 .72497 L .4467 .71933 L p F P
0 g
s
.352 0 .172 r
.56699 .37205 m .5757 .35011 L .5958 .34315 L p F P
0 g
s
.352 0 .172 r
.5757 .35011 m .56699 .37205 L .54674 .37899 L p F P
0 g
s
.593 .457 .666 r
.29697 .62086 m .28861 .57553 L .30766 .5694 L p F P
0 g
s
.593 .457 .666 r
.28861 .57553 m .29697 .62086 L .27794 .62681 L p F P
0 g
s
.337 .816 .785 r
.8048 .26515 m .7926 .26665 L .77148 .27399 L p F P
0 g
s
1 1 0 r
.007 w
.80229 .26468 m
.80434 .26521 L
s
.80434 .26521 m
.80538 .26547 L
s
.5 Mabswid
.088 0 0 r
.67767 .31481 m .68851 .30284 L .70902 .2957 L p F P
0 g
s
.088 0 0 r
.68851 .30284 m .67767 .31481 L .65697 .32197 L p F P
0 g
s
.489 .878 .966 r
.77726 .71669 m .79378 .7218 L .77295 .72738 L p F P
0 g
s
.489 .878 .966 r
.77295 .72738 m .75613 .72239 L .77726 .71669 L p F P
0 g
s
0 0 0 r
.90024 .69328 m .91202 .68886 L .89076 .69456 L p F P
0 g
s
0 0 0 r
.89076 .69456 m .87863 .69907 L .90024 .69328 L p F P
0 g
s
.642 .75 .927 r
.54918 .72875 m .57136 .75245 L .55134 .75792 L p F P
0 g
s
.642 .75 .927 r
.55134 .75792 m .52897 .73438 L .54918 .72875 L p F P
0 g
s
.611 .513 .719 r
.29135 .6721 m .27794 .62681 L .29697 .62086 L p F P
0 g
s
.532 .307 .519 r
.40114 .49482 m .40257 .4569 L .42207 .45032 L p F P
0 g
s
.532 .307 .519 r
.40257 .4569 m .40114 .49482 L .38156 .50129 L p F P
0 g
s
.471 .182 .392 r
.48143 .43029 m .48688 .39951 L .50669 .39272 L p F P
0 g
s
.471 .182 .392 r
.48688 .39951 m .48143 .43029 L .4615 .43702 L p F P
0 g
s
.611 .513 .719 r
.29697 .62086 m .31045 .66631 L .29135 .6721 L p F P
0 g
s
.625 .565 .768 r
.32968 .66048 m .34751 .70357 L .32827 .70922 L p F P
0 g
s
.625 .565 .768 r
.32827 .70922 m .31045 .66631 L .32968 .66048 L p F P
0 g
s
.568 .392 .603 r
.34617 .557 m .34283 .51408 L .36212 .50771 L p F P
0 g
s
.568 .392 .603 r
.34283 .51408 m .34617 .557 L .32684 .56322 L p F P
0 g
s
.636 .619 .816 r
.38642 .69212 m .40734 .73057 L .38788 .73613 L p F P
0 g
s
.636 .619 .816 r
.38788 .73613 m .36689 .69787 L .38642 .69212 L p F P
0 g
s
.614 .832 .984 r
.67372 .72449 m .69365 .73923 L .67313 .74477 L p F P
0 g
s
.614 .832 .984 r
.67313 .74477 m .65295 .73016 L .67372 .72449 L p F P
0 g
s
.643 .679 .869 r
.4666 .71364 m .48899 .74553 L .46921 .75104 L p F P
0 g
s
.643 .679 .869 r
.46921 .75104 m .4467 .71933 L .4666 .71364 L p F P
0 g
s
.352 0 .172 r
.58739 .36506 m .5958 .34315 L .61604 .33614 L p F P
0 g
s
.352 0 .172 r
.5958 .34315 m .58739 .36506 L .56699 .37205 L p F P
0 g
s
1 1 0 r
.007 w
.79738 .26482 m
.80229 .26468 L
s
.5 Mabswid
.593 .457 .666 r
.31614 .61487 m .30766 .5694 L .32684 .56322 L p F P
0 g
s
.593 .457 .666 r
.30766 .5694 m .31614 .61487 L .29697 .62086 L p F P
0 g
s
.088 0 0 r
.69851 .30759 m .70902 .2957 L .72969 .28852 L p F P
0 g
s
.088 0 0 r
.70902 .2957 m .69851 .30759 L .67767 .31481 L p F P
0 g
s
.489 .878 .966 r
.79855 .71095 m .81476 .71618 L .79378 .7218 L p F P
0 g
s
.489 .878 .966 r
.79378 .7218 m .77726 .71669 L .79855 .71095 L p F P
0 g
s
0 0 0 r
.92201 .68744 m .93343 .68311 L .91202 .68886 L p F P
0 g
s
0 0 0 r
.91202 .68886 m .90024 .69328 L .92201 .68744 L p F P
0 g
s
.642 .75 .927 r
.56955 .72308 m .59153 .74694 L .57136 .75245 L p F P
0 g
s
.642 .75 .927 r
.57136 .75245 m .54918 .72875 L .56955 .72308 L p F P
0 g
s
.611 .513 .719 r
.31045 .66631 m .29697 .62086 L .31614 .61487 L p F P
0 g
s
.532 .307 .519 r
.42086 .4883 m .42207 .45032 L .44171 .44369 L p F P
0 g
s
.532 .307 .519 r
.42207 .45032 m .42086 .4883 L .40114 .49482 L p F P
0 g
s
.471 .182 .392 r
.50151 .42352 m .50669 .39272 L .52664 .38588 L p F P
0 g
s
.471 .182 .392 r
.50669 .39272 m .50151 .42352 L .48143 .43029 L p F P
0 g
s
.611 .513 .719 r
.31614 .61487 m .32968 .66048 L .31045 .66631 L p F P
0 g
s
.625 .565 .768 r
.34906 .6546 m .36689 .69787 L .34751 .70357 L p F P
0 g
s
.625 .565 .768 r
.34751 .70357 m .32968 .66048 L .34906 .6546 L p F P
0 g
s
.568 .392 .603 r
.36564 .55073 m .36212 .50771 L .38156 .50129 L p F P
0 g
s
.568 .392 .603 r
.36212 .50771 m .36564 .55073 L .34617 .557 L p F P
0 g
s
1 1 0 r
.007 w
.93306 .68325 m
.9336 .68283 L
s
.93024 .68551 m
.93306 .68325 L
s
.9336 .68283 m
.93421 .68234 L
s
.5 Mabswid
.636 .619 .816 r
.40608 .68634 m .42695 .72497 L .40734 .73057 L p F P
0 g
s
.636 .619 .816 r
.40734 .73057 m .38642 .69212 L .40608 .68634 L p F P
0 g
s
.614 .832 .984 r
.69465 .71877 m .71432 .73366 L .69365 .73923 L p F P
0 g
s
.614 .832 .984 r
.69365 .73923 m .67372 .72449 L .69465 .71877 L p F P
0 g
s
.643 .679 .869 r
.48665 .70791 m .5089 .73998 L .48899 .74553 L p F P
0 g
s
.643 .679 .869 r
.48899 .74553 m .4666 .71364 L .48665 .70791 L p F P
0 g
s
.352 0 .172 r
.60795 .35802 m .61604 .33614 L .63643 .32908 L p F P
0 g
s
.352 0 .172 r
.61604 .33614 m .60795 .35802 L .58739 .36506 L p F P
0 g
s
.593 .457 .666 r
.33545 .60883 m .32684 .56322 L .34617 .557 L p F P
0 g
s
.593 .457 .666 r
.32684 .56322 m .33545 .60883 L .31614 .61487 L p F P
0 g
s
.088 0 0 r
.71952 .30032 m .72969 .28852 L .75051 .28128 L p F P
0 g
s
.088 0 0 r
.72969 .28852 m .71952 .30032 L .69851 .30759 L p F P
0 g
s
.489 .878 .966 r
.82001 .70517 m .83589 .71052 L .81476 .71618 L p F P
0 g
s
.489 .878 .966 r
.81476 .71618 m .79855 .71095 L .82001 .70517 L p F P
0 g
s
.642 .75 .927 r
.59007 .71736 m .61185 .74139 L .59153 .74694 L p F P
0 g
s
.642 .75 .927 r
.59153 .74694 m .56955 .72308 L .59007 .71736 L p F P
0 g
s
.611 .513 .719 r
.32968 .66048 m .31614 .61487 L .33545 .60883 L p F P
0 g
s
.532 .307 .519 r
.44074 .48174 m .44171 .44369 L .4615 .43702 L p F P
0 g
s
.532 .307 .519 r
.44171 .44369 m .44074 .48174 L .42086 .4883 L p F P
0 g
s
.471 .182 .392 r
.52174 .41669 m .52664 .38588 L .54674 .37899 L p F P
0 g
s
.471 .182 .392 r
.52664 .38588 m .52174 .41669 L .50151 .42352 L p F P
0 g
s
.611 .513 .719 r
.33545 .60883 m .34906 .6546 L .32968 .66048 L p F P
0 g
s
.625 .565 .768 r
.36858 .64868 m .38642 .69212 L .36689 .69787 L p F P
0 g
s
.625 .565 .768 r
.36689 .69787 m .34906 .6546 L .36858 .64868 L p F P
0 g
s
.568 .392 .603 r
.38526 .54441 m .38156 .50129 L .40114 .49482 L p F P
0 g
s
.568 .392 .603 r
.38156 .50129 m .38526 .54441 L .36564 .55073 L p F P
0 g
s
.636 .619 .816 r
.4259 .68051 m .4467 .71933 L .42695 .72497 L p F P
0 g
s
.636 .619 .816 r
.42695 .72497 m .40608 .68634 L .4259 .68051 L p F P
0 g
s
.614 .832 .984 r
.71574 .71301 m .73515 .72805 L .71432 .73366 L p F P
0 g
s
.614 .832 .984 r
.71432 .73366 m .69465 .71877 L .71574 .71301 L p F P
0 g
s
.643 .679 .869 r
.50684 .70214 m .52897 .73438 L .5089 .73998 L p F P
0 g
s
.643 .679 .869 r
.5089 .73998 m .48665 .70791 L .50684 .70214 L p F P
0 g
s
.352 0 .172 r
.62865 .35092 m .63643 .32908 L .65697 .32197 L p F P
0 g
s
.352 0 .172 r
.63643 .32908 m .62865 .35092 L .60795 .35802 L p F P
0 g
s
1 1 0 r
.007 w
.7929 .26648 m
.79738 .26482 L
s
.5 Mabswid
.593 .457 .666 r
.3549 .60274 m .34617 .557 L .36564 .55073 L p F P
0 g
s
.593 .457 .666 r
.34617 .557 m .3549 .60274 L .33545 .60883 L p F P
0 g
s
.088 0 0 r
.74068 .293 m .75051 .28128 L .77148 .27399 L p F P
0 g
s
.088 0 0 r
.75051 .28128 m .74068 .293 L .71952 .30032 L p F P
0 g
s
.489 .878 .966 r
.84162 .69934 m .85718 .70481 L .83589 .71052 L p F P
0 g
s
.489 .878 .966 r
.83589 .71052 m .82001 .70517 L .84162 .69934 L p F P
0 g
s
.642 .75 .927 r
.61074 .7116 m .63232 .7358 L .61185 .74139 L p F P
0 g
s
.642 .75 .927 r
.61185 .74139 m .59007 .71736 L .61074 .7116 L p F P
0 g
s
.611 .513 .719 r
.34906 .6546 m .33545 .60883 L .3549 .60274 L p F P
0 g
s
.532 .307 .519 r
.46076 .47513 m .4615 .43702 L .48143 .43029 L p F P
0 g
s
.532 .307 .519 r
.4615 .43702 m .46076 .47513 L .44074 .48174 L p F P
0 g
s
.471 .182 .392 r
.54213 .40982 m .54674 .37899 L .56699 .37205 L p F P
0 g
s
.471 .182 .392 r
.54674 .37899 m .54213 .40982 L .52174 .41669 L p F P
0 g
s
.611 .513 .719 r
.3549 .60274 m .36858 .64868 L .34906 .6546 L p F P
0 g
s
.625 .565 .768 r
.38824 .64272 m .40608 .68634 L .38642 .69212 L p F P
0 g
s
.625 .565 .768 r
.38642 .69212 m .36858 .64868 L .38824 .64272 L p F P
0 g
s
1 1 0 r
.007 w
.92575 .68719 m
.93024 .68551 L
s
.5 Mabswid
.568 .392 .603 r
.40502 .53805 m .40114 .49482 L .42086 .4883 L p F P
0 g
s
.568 .392 .603 r
.40114 .49482 m .40502 .53805 L .38526 .54441 L p F P
0 g
s
.636 .619 .816 r
.44586 .67464 m .4666 .71364 L .4467 .71933 L p F P
0 g
s
.636 .619 .816 r
.4467 .71933 m .4259 .68051 L .44586 .67464 L p F P
0 g
s
.614 .832 .984 r
.73699 .7072 m .75613 .72239 L .73515 .72805 L p F P
0 g
s
.614 .832 .984 r
.73515 .72805 m .71574 .71301 L .73699 .7072 L p F P
0 g
s
.643 .679 .869 r
.52719 .69633 m .54918 .72875 L .52897 .73438 L p F P
0 g
s
.643 .679 .869 r
.52897 .73438 m .50684 .70214 L .52719 .69633 L p F P
0 g
s
.352 0 .172 r
.64952 .34377 m .65697 .32197 L .67767 .31481 L p F P
0 g
s
.352 0 .172 r
.65697 .32197 m .64952 .34377 L .62865 .35092 L p F P
0 g
s
.593 .457 .666 r
.3745 .59661 m .36564 .55073 L .38526 .54441 L p F P
0 g
s
.593 .457 .666 r
.36564 .55073 m .3745 .59661 L .3549 .60274 L p F P
0 g
s
.088 0 0 r
.762 .28562 m .77148 .27399 L .7926 .26665 L p F P
0 g
s
.088 0 0 r
.77148 .27399 m .762 .28562 L .74068 .293 L p F P
0 g
s
.489 .878 .966 r
.8634 .69347 m .87863 .69907 L .85718 .70481 L p F P
0 g
s
.489 .878 .966 r
.85718 .70481 m .84162 .69934 L .8634 .69347 L p F P
0 g
s
.642 .75 .927 r
.63156 .7058 m .65295 .73016 L .63232 .7358 L p F P
0 g
s
.642 .75 .927 r
.63232 .7358 m .61074 .7116 L .63156 .7058 L p F P
0 g
s
.611 .513 .719 r
.36858 .64868 m .3549 .60274 L .3745 .59661 L p F P
0 g
s
.532 .307 .519 r
.48093 .46846 m .48143 .43029 L .50151 .42352 L p F P
0 g
s
.532 .307 .519 r
.48143 .43029 m .48093 .46846 L .46076 .47513 L p F P
0 g
s
.471 .182 .392 r
.56266 .40289 m .56699 .37205 L .58739 .36506 L p F P
0 g
s
.471 .182 .392 r
.56699 .37205 m .56266 .40289 L .54213 .40982 L p F P
0 g
s
.611 .513 .719 r
.3745 .59661 m .38824 .64272 L .36858 .64868 L p F P
0 g
s
.625 .565 .768 r
.40805 .63671 m .4259 .68051 L .40608 .68634 L p F P
0 g
s
.625 .565 .768 r
.40608 .68634 m .38824 .64272 L .40805 .63671 L p F P
0 g
s
.568 .392 .603 r
.42493 .53164 m .42086 .4883 L .44074 .48174 L p F P
0 g
s
.568 .392 .603 r
.42086 .4883 m .42493 .53164 L .40502 .53805 L p F P
0 g
s
.636 .619 .816 r
.46597 .66873 m .48665 .70791 L .4666 .71364 L p F P
0 g
s
.636 .619 .816 r
.4666 .71364 m .44586 .67464 L .46597 .66873 L p F P
0 g
s
0 .826 0 r
.0837 .44677 m .07993 .45451 L .06507 .42922 L closepath p F P
0 g
s
0 .855 0 r
.09094 .44152 m .0837 .44677 L .06507 .42922 L closepath p F P
0 g
s
.614 .832 .984 r
.7584 .70135 m .77726 .71669 L .75613 .72239 L p F P
0 g
s
.614 .832 .984 r
.75613 .72239 m .73699 .7072 L .7584 .70135 L p F P
0 g
s
.643 .679 .869 r
.54769 .69047 m .56955 .72308 L .54918 .72875 L p F P
0 g
s
.643 .679 .869 r
.54918 .72875 m .52719 .69633 L .54769 .69047 L p F P
0 g
s
1 1 0 r
.007 w
.7927 .26664 m
.7929 .26648 L
s
.5 Mabswid
.352 0 .172 r
.67054 .33657 m .67767 .31481 L .69851 .30759 L p F P
0 g
s
.352 0 .172 r
.67767 .31481 m .67054 .33657 L .64952 .34377 L p F P
0 g
s
.593 .457 .666 r
.39424 .59044 m .38526 .54441 L .40502 .53805 L p F P
0 g
s
.593 .457 .666 r
.38526 .54441 m .39424 .59044 L .3745 .59661 L p F P
0 g
s
0 .687 0 r
.09744 .44181 m .09094 .44152 L .06507 .42922 L closepath p F P
0 g
s
.088 0 0 r
.7926 .26665 m .78348 .27818 L .762 .28562 L p F P
0 g
s
1 1 0 r
.007 w
.79247 .26682 m
.7927 .26664 L
s
.78888 .26968 m
.79247 .26682 L
s
.5 Mabswid
.489 .878 .966 r
.88534 .68755 m .90024 .69328 L .87863 .69907 L p F P
0 g
s
.489 .878 .966 r
.87863 .69907 m .8634 .69347 L .88534 .68755 L p F P
0 g
s
.642 .75 .927 r
.65255 .69995 m .67372 .72449 L .65295 .73016 L p F P
0 g
s
.642 .75 .927 r
.65295 .73016 m .63156 .7058 L .65255 .69995 L p F P
0 g
s
0 .448 0 r
.07993 .45451 m .08184 .46024 L .06507 .42922 L closepath p F P
0 g
s
.611 .513 .719 r
.38824 .64272 m .3745 .59661 L .39424 .59044 L p F P
0 g
s
.532 .307 .519 r
.50125 .46175 m .50151 .42352 L .52174 .41669 L p F P
0 g
s
.532 .307 .519 r
.50151 .42352 m .50125 .46175 L .48093 .46846 L p F P
0 g
s
.471 .182 .392 r
.58335 .39591 m .58739 .36506 L .60795 .35802 L p F P
0 g
s
.471 .182 .392 r
.58739 .36506 m .58335 .39591 L .56266 .40289 L p F P
0 g
s
.611 .513 .719 r
.39424 .59044 m .40805 .63671 L .38824 .64272 L p F P
0 g
s
0 .461 0 r
.0994 .44751 m .09744 .44181 L .06507 .42922 L closepath p F P
0 g
s
1 1 0 r
.007 w
.92242 .68729 m
.92575 .68719 L
s
.5 Mabswid
.625 .565 .768 r
.42801 .63066 m .44586 .67464 L .4259 .68051 L p F P
0 g
s
.625 .565 .768 r
.4259 .68051 m .40805 .63671 L .42801 .63066 L p F P
0 g
s
.568 .392 .603 r
.44499 .52518 m .44074 .48174 L .46076 .47513 L p F P
0 g
s
.568 .392 .603 r
.44074 .48174 m .44499 .52518 L .42493 .53164 L p F P
0 g
s
.636 .619 .816 r
.48624 .66277 m .50684 .70214 L .48665 .70791 L p F P
0 g
s
.636 .619 .816 r
.48665 .70791 m .46597 .66873 L .48624 .66277 L p F P
0 g
s
.614 .832 .984 r
.77997 .69546 m .79855 .71095 L .77726 .71669 L p F P
0 g
s
.614 .832 .984 r
.77726 .71669 m .7584 .70135 L .77997 .69546 L p F P
0 g
s
.643 .679 .869 r
.56835 .68457 m .59007 .71736 L .56955 .72308 L p F P
0 g
s
.643 .679 .869 r
.56955 .72308 m .54769 .69047 L .56835 .68457 L p F P
0 g
s
.352 0 .172 r
.69172 .32931 m .69851 .30759 L .71952 .30032 L p F P
0 g
s
.352 0 .172 r
.69851 .30759 m .69172 .32931 L .67054 .33657 L p F P
0 g
s
.593 .457 .666 r
.41413 .58422 m .40502 .53805 L .42493 .53164 L p F P
0 g
s
.593 .457 .666 r
.40502 .53805 m .41413 .58422 L .39424 .59044 L p F P
0 g
s
0 .59 0 r
.08184 .46024 m .08835 .46058 L .06507 .42922 L closepath p F P
0 g
s
.489 .878 .966 r
.90745 .68159 m .92201 .68744 L .90024 .69328 L p F P
0 g
s
1 1 0 r
.007 w
.92076 .68733 m
.92167 .68731 L
s
.92167 .68731 m
.92242 .68729 L
s
.5 Mabswid
.489 .878 .966 r
.90024 .69328 m .88534 .68755 L .90745 .68159 L p F P
0 g
s
.642 .75 .927 r
.67369 .69406 m .69465 .71877 L .67372 .72449 L p F P
0 g
s
.642 .75 .927 r
.67372 .72449 m .65255 .69995 L .67369 .69406 L p F P
0 g
s
.611 .513 .719 r
.40805 .63671 m .39424 .59044 L .41413 .58422 L p F P
0 g
s
0 .674 0 r
.09564 .4553 m .0994 .44751 L .06507 .42922 L closepath p F P
0 g
s
.532 .307 .519 r
.52172 .45499 m .52174 .41669 L .54213 .40982 L p F P
0 g
s
.532 .307 .519 r
.52174 .41669 m .52172 .45499 L .50125 .46175 L p F P
0 g
s
.471 .182 .392 r
.6042 .38888 m .60795 .35802 L .62865 .35092 L p F P
0 g
s
.471 .182 .392 r
.60795 .35802 m .6042 .38888 L .58335 .39591 L p F P
0 g
s
.611 .513 .719 r
.41413 .58422 m .42801 .63066 L .40805 .63671 L p F P
0 g
s
0 .699 0 r
.08835 .46058 m .09564 .4553 L .06507 .42922 L closepath p F P
0 g
s
0 1 0 r
.007 w
.095 .45576 m
.19456 .54409 L
s
.5 Mabswid
.625 .565 .768 r
.44812 .62456 m .46597 .66873 L .44586 .67464 L p F P
0 g
s
.625 .565 .768 r
.44586 .67464 m .42801 .63066 L .44812 .62456 L p F P
0 g
s
.568 .392 .603 r
.4652 .51867 m .46076 .47513 L .48093 .46846 L p F P
0 g
s
.568 .392 .603 r
.46076 .47513 m .4652 .51867 L .44499 .52518 L p F P
0 g
s
.636 .619 .816 r
.50665 .65677 m .52719 .69633 L .50684 .70214 L p F P
0 g
s
.636 .619 .816 r
.50684 .70214 m .48624 .66277 L .50665 .65677 L p F P
0 g
s
1 1 0 r
.007 w
.78538 .27445 m
.78888 .26968 L
s
.5 Mabswid
.614 .832 .984 r
.8017 .68952 m .82001 .70517 L .79855 .71095 L p F P
0 g
s
.614 .832 .984 r
.79855 .71095 m .77997 .69546 L .8017 .68952 L p F P
0 g
s
.643 .679 .869 r
.58916 .67862 m .61074 .7116 L .59007 .71736 L p F P
0 g
s
.643 .679 .869 r
.59007 .71736 m .56835 .68457 L .58916 .67862 L p F P
0 g
s
.352 0 .172 r
.71306 .322 m .71952 .30032 L .74068 .293 L p F P
0 g
s
.352 0 .172 r
.71952 .30032 m .71306 .322 L .69172 .32931 L p F P
0 g
s
.593 .457 .666 r
.43417 .57795 m .42493 .53164 L .44499 .52518 L p F P
0 g
s
.593 .457 .666 r
.42493 .53164 m .43417 .57795 L .41413 .58422 L p F P
0 g
s
.642 .75 .927 r
.69499 .68812 m .71574 .71301 L .69465 .71877 L p F P
0 g
s
.642 .75 .927 r
.69465 .71877 m .67369 .69406 L .69499 .68812 L p F P
0 g
s
.611 .513 .719 r
.42801 .63066 m .41413 .58422 L .43417 .57795 L p F P
0 g
s
.532 .307 .519 r
.54235 .44817 m .54213 .40982 L .56266 .40289 L p F P
0 g
s
.532 .307 .519 r
.54213 .40982 m .54235 .44817 L .52172 .45499 L p F P
0 g
s
.471 .182 .392 r
.6252 .38179 m .62865 .35092 L .64952 .34377 L p F P
0 g
s
.471 .182 .392 r
.62865 .35092 m .6252 .38179 L .6042 .38888 L p F P
0 g
s
.611 .513 .719 r
.43417 .57795 m .44812 .62456 L .42801 .63066 L p F P
0 g
s
1 1 0 r
.007 w
.91529 .6859 m
.92076 .68733 L
s
.5 Mabswid
.625 .565 .768 r
.46839 .61841 m .48624 .66277 L .46597 .66873 L p F P
0 g
s
.625 .565 .768 r
.46597 .66873 m .44812 .62456 L .46839 .61841 L p F P
0 g
s
.568 .392 .603 r
.48556 .51212 m .48093 .46846 L .50125 .46175 L p F P
0 g
s
.568 .392 .603 r
.48093 .46846 m .48556 .51212 L .4652 .51867 L p F P
0 g
s
.636 .619 .816 r
.52722 .65072 m .54769 .69047 L .52719 .69633 L p F P
0 g
s
.636 .619 .816 r
.52719 .69633 m .50665 .65677 L .52722 .65072 L p F P
0 g
s
.614 .832 .984 r
.8236 .68354 m .84162 .69934 L .82001 .70517 L p F P
0 g
s
.614 .832 .984 r
.82001 .70517 m .8017 .68952 L .8236 .68354 L p F P
0 g
s
.643 .679 .869 r
.61013 .67263 m .63156 .7058 L .61074 .7116 L p F P
0 g
s
.643 .679 .869 r
.61074 .7116 m .58916 .67862 L .61013 .67263 L p F P
0 g
s
.352 0 .172 r
.73456 .31463 m .74068 .293 L .762 .28562 L p F P
0 g
s
.352 0 .172 r
.74068 .293 m .73456 .31463 L .71306 .322 L p F P
0 g
s
.593 .457 .666 r
.45437 .57163 m .44499 .52518 L .4652 .51867 L p F P
0 g
s
.593 .457 .666 r
.44499 .52518 m .45437 .57163 L .43417 .57795 L p F P
0 g
s
.642 .75 .927 r
.71646 .68214 m .73699 .7072 L .71574 .71301 L p F P
0 g
s
.642 .75 .927 r
.71574 .71301 m .69499 .68812 L .71646 .68214 L p F P
0 g
s
.611 .513 .719 r
.44812 .62456 m .43417 .57795 L .45437 .57163 L p F P
0 g
s
.66 0 0 r
.60937 .40478 m .61118 .41354 L .57375 .41836 L p F P
0 g
s
.532 .307 .519 r
.56266 .40289 m .58335 .39591 L p .57359 .41784 L F P
0 g
s
.532 .307 .519 r
.57306 .41902 m .57264 .41841 L .57307 .41815 L F
.5734 .41825 m .57307 .41815 L .57359 .41784 L F
.57306 .41902 m .57307 .41815 L .5734 .41825 L F
.546 0 0 r
.61118 .41354 m .60975 .41838 L .5754 .41886 L p F P
0 g
s
.532 .307 .519 r
.57303 .41902 m .57264 .41841 L .57306 .41902 L F
.56299 .42895 m .56266 .40289 L p .57305 .41905 L F P
0 g
s
.546 0 0 r
.57375 .41836 m .61118 .41354 L p .5754 .41886 L F P
0 g
s
.352 0 0 r
.5754 .41886 m .60975 .41838 L .60648 .41673 L p F P
0 g
s
.713 0 0 r
.606 .39835 m .60937 .40478 L .57536 .41677 L p F P
0 g
s
.66 0 0 r
.57536 .41677 m .60937 .40478 L p .57375 .41836 L F P
0 g
s
.532 .307 .519 r
.58335 .39591 m .58409 .43439 L .56314 .44131 L p F P
0 g
s
.546 0 0 r
.5754 .41886 m .56921 .41894 L .57375 .41836 L p F P
0 g
s
.532 .307 .519 r
.58409 .43439 m .58335 .39591 L .6042 .38888 L p F P
0 g
s
.532 .307 .519 r
.60519 .42742 m .6042 .38888 L .6252 .38179 L p F P
0 g
s
.532 .307 .519 r
.6042 .38888 m .60519 .42742 L .58409 .43439 L p F P
0 g
s
.352 0 0 r
.60588 .41643 m .56921 .41894 L .5754 .41886 L p F P
0 g
s
.352 0 0 r
.60648 .41673 m .60588 .41643 L p .5754 .41886 L F P
0 g
s
.532 .307 .519 r
.57305 .41905 m .57303 .41902 L .57306 .41902 L F
.57264 .41841 m .56266 .40289 L .57359 .41784 L F
.713 0 0 r
.56921 .41894 m .60538 .39718 L .606 .39835 L p F P
0 g
s
.713 0 0 r
.57536 .41677 m .56921 .41894 L p .606 .39835 L F P
0 g
s
.66 0 0 r
.57375 .41836 m .56921 .41894 L .57536 .41677 L p F P
0 g
s
.532 .307 .519 r
.56314 .44131 m .56299 .42895 L p .57305 .41905 L F P
0 g
s
.532 .307 .519 r
.56266 .40289 m .56314 .44131 L .54235 .44817 L p F P
0 g
s
.471 .182 .392 r
.64637 .37465 m .64952 .34377 L .67054 .33657 L p F P
0 g
s
.471 .182 .392 r
.64952 .34377 m .64637 .37465 L .6252 .38179 L p F P
0 g
s
.611 .513 .719 r
.45437 .57163 m .46839 .61841 L .44812 .62456 L p F P
0 g
s
.625 .565 .768 r
.4888 .61222 m .50665 .65677 L .48624 .66277 L p F P
0 g
s
.625 .565 .768 r
.48624 .66277 m .46839 .61841 L .4888 .61222 L p F P
0 g
s
.568 .392 .603 r
.50608 .50551 m .50125 .46175 L .52172 .45499 L p F P
0 g
s
.568 .392 .603 r
.50125 .46175 m .50608 .50551 L .48556 .51212 L p F P
0 g
s
.636 .619 .816 r
.54795 .64462 m .56835 .68457 L .54769 .69047 L p F P
0 g
s
.636 .619 .816 r
.54769 .69047 m .52722 .65072 L .54795 .64462 L p F P
0 g
s
1 1 0 r
.007 w
.78385 .27771 m
.78538 .27445 L
s
.5 Mabswid
.614 .832 .984 r
.84567 .67751 m .8634 .69347 L .84162 .69934 L p F P
0 g
s
.614 .832 .984 r
.84162 .69934 m .8236 .68354 L .84567 .67751 L p F P
0 g
s
.643 .679 .869 r
.63126 .66659 m .65255 .69995 L .63156 .7058 L p F P
0 g
s
.643 .679 .869 r
.63156 .7058 m .61013 .67263 L .63126 .66659 L p F P
0 g
s
.352 0 .172 r
.75623 .3072 m .762 .28562 L .78348 .27818 L p F P
0 g
s
.352 0 .172 r
.762 .28562 m .75623 .3072 L .73456 .31463 L p F P
0 g
s
.593 .457 .666 r
.47471 .56527 m .4652 .51867 L .48556 .51212 L p F P
0 g
s
.593 .457 .666 r
.4652 .51867 m .47471 .56527 L .45437 .57163 L p F P
0 g
s
.642 .75 .927 r
.73809 .67612 m .7584 .70135 L .73699 .7072 L p F P
0 g
s
.642 .75 .927 r
.73699 .7072 m .71646 .68214 L .73809 .67612 L p F P
0 g
s
.611 .513 .719 r
.46839 .61841 m .45437 .57163 L .47471 .56527 L p F P
0 g
s
1 1 0 r
.007 w
.90937 .68286 m
.91529 .6859 L
s
.5 Mabswid
.471 .182 .392 r
.6677 .36746 m .67054 .33657 L .69172 .32931 L p F P
0 g
s
.471 .182 .392 r
.67054 .33657 m .6677 .36746 L .64637 .37465 L p F P
0 g
s
.611 .513 .719 r
.47471 .56527 m .4888 .61222 L .46839 .61841 L p F P
0 g
s
.625 .565 .768 r
.50937 .60598 m .52722 .65072 L .50665 .65677 L p F P
0 g
s
.625 .565 .768 r
.50665 .65677 m .4888 .61222 L .50937 .60598 L p F P
0 g
s
.568 .392 .603 r
.52675 .49885 m .52172 .45499 L .54235 .44817 L p F P
0 g
s
.568 .392 .603 r
.52172 .45499 m .52675 .49885 L .50608 .50551 L p F P
0 g
s
.636 .619 .816 r
.56884 .63848 m .58916 .67862 L .56835 .68457 L p F P
0 g
s
.636 .619 .816 r
.56835 .68457 m .54795 .64462 L .56884 .63848 L p F P
0 g
s
.614 .832 .984 r
.86791 .67143 m .88534 .68755 L .8634 .69347 L p F P
0 g
s
.614 .832 .984 r
.8634 .69347 m .84567 .67751 L .86791 .67143 L p F P
0 g
s
.643 .679 .869 r
.65256 .66051 m .67369 .69406 L .65255 .69995 L p F P
0 g
s
.643 .679 .869 r
.65255 .69995 m .63126 .66659 L .65256 .66051 L p F P
0 g
s
.352 0 .172 r
.78348 .27818 m .77806 .29972 L .75623 .3072 L p F P
0 g
s
1 1 0 r
.007 w
.7833 .27888 m
.78385 .27771 L
s
.78243 .28076 m
.7833 .27888 L
s
.5 Mabswid
.593 .457 .666 r
.49521 .55886 m .48556 .51212 L .50608 .50551 L p F P
0 g
s
.593 .457 .666 r
.48556 .51212 m .49521 .55886 L .47471 .56527 L p F P
0 g
s
.642 .75 .927 r
.75989 .67004 m .77997 .69546 L .7584 .70135 L p F P
0 g
s
.642 .75 .927 r
.7584 .70135 m .73809 .67612 L .75989 .67004 L p F P
0 g
s
.611 .513 .719 r
.4888 .61222 m .47471 .56527 L .49521 .55886 L p F P
0 g
s
.471 .182 .392 r
.68919 .36021 m .69172 .32931 L .71306 .322 L p F P
0 g
s
.471 .182 .392 r
.69172 .32931 m .68919 .36021 L .6677 .36746 L p F P
0 g
s
.754 0 0 r
.60152 .39517 m .60538 .39718 L .56921 .41894 L closepath p F P
0 g
s
.156 0 0 r
.60004 .39997 m .60152 .39517 L .56921 .41894 L closepath p F P
0 g
s
.497 0 0 r
.60185 .4088 m .60004 .39997 L .56921 .41894 L closepath p F P
0 g
s
.554 0 0 r
.60588 .41643 m .60185 .4088 L .56921 .41894 L closepath p F P
0 g
s
.611 .513 .719 r
.49521 .55886 m .50937 .60598 L .4888 .61222 L p F P
0 g
s
.625 .565 .768 r
.5301 .5997 m .54795 .64462 L .52722 .65072 L p F P
0 g
s
.625 .565 .768 r
.52722 .65072 m .50937 .60598 L .5301 .5997 L p F P
0 g
s
1 1 0 r
.007 w
.78006 .28861 m
.78243 .28076 L
s
.5 Mabswid
.568 .392 .603 r
.54759 .49215 m .54235 .44817 L .56314 .44131 L p F P
0 g
s
.568 .392 .603 r
.54235 .44817 m .54759 .49215 L .52675 .49885 L p F P
0 g
s
.636 .619 .816 r
.58988 .63229 m .61013 .67263 L .58916 .67862 L p F P
0 g
s
.636 .619 .816 r
.58916 .67862 m .56884 .63848 L .58988 .63229 L p F P
0 g
s
.614 .832 .984 r
.89033 .66531 m .90745 .68159 L .88534 .68755 L p F P
0 g
s
.614 .832 .984 r
.88534 .68755 m .86791 .67143 L .89033 .66531 L p F P
0 g
s
.643 .679 .869 r
.67401 .65438 m .69499 .68812 L .67369 .69406 L p F P
0 g
s
.643 .679 .869 r
.67369 .69406 m .65256 .66051 L .67401 .65438 L p F P
0 g
s
.593 .457 .666 r
.51587 .5524 m .50608 .50551 L .52675 .49885 L p F P
0 g
s
.593 .457 .666 r
.50608 .50551 m .51587 .5524 L .49521 .55886 L p F P
0 g
s
.642 .75 .927 r
.78186 .66392 m .8017 .68952 L .77997 .69546 L p F P
0 g
s
.642 .75 .927 r
.77997 .69546 m .75989 .67004 L .78186 .66392 L p F P
0 g
s
.611 .513 .719 r
.50937 .60598 m .49521 .55886 L .51587 .5524 L p F P
0 g
s
1 1 0 r
.007 w
.90787 .68176 m
.90937 .68286 L
s
.90304 .67822 m
.90679 .68097 L
s
.90679 .68097 m
.90787 .68176 L
s
.5 Mabswid
.532 .307 .519 r
.62646 .42039 m .6252 .38179 L .64637 .37465 L p F P
0 g
s
.532 .307 .519 r
.6252 .38179 m .62646 .42039 L .60519 .42742 L p F P
0 g
s
.471 .182 .392 r
.71084 .3529 m .71306 .322 L .73456 .31463 L p F P
0 g
s
.471 .182 .392 r
.71306 .322 m .71084 .3529 L .68919 .36021 L p F P
0 g
s
.611 .513 .719 r
.51587 .5524 m .5301 .5997 L .50937 .60598 L p F P
0 g
s
.625 .565 .768 r
.55099 .59336 m .56884 .63848 L .54795 .64462 L p F P
0 g
s
.625 .565 .768 r
.54795 .64462 m .5301 .5997 L .55099 .59336 L p F P
0 g
s
.568 .392 .603 r
.56858 .48539 m .56314 .44131 L .58409 .43439 L p F P
0 g
s
.568 .392 .603 r
.56314 .44131 m .56858 .48539 L .54759 .49215 L p F P
0 g
s
.636 .619 .816 r
.61109 .62605 m .63126 .66659 L .61013 .67263 L p F P
0 g
s
.636 .619 .816 r
.61013 .67263 m .58988 .63229 L .61109 .62605 L p F P
0 g
s
.643 .679 .869 r
.69564 .6482 m .71646 .68214 L .69499 .68812 L p F P
0 g
s
.643 .679 .869 r
.69499 .68812 m .67401 .65438 L .69564 .6482 L p F P
0 g
s
.593 .457 .666 r
.53668 .54589 m .52675 .49885 L .54759 .49215 L p F P
0 g
s
.593 .457 .666 r
.52675 .49885 m .53668 .54589 L .51587 .5524 L p F P
0 g
s
.642 .75 .927 r
.80399 .65775 m .8236 .68354 L .8017 .68952 L p F P
0 g
s
.642 .75 .927 r
.8017 .68952 m .78186 .66392 L .80399 .65775 L p F P
0 g
s
.611 .513 .719 r
.5301 .5997 m .51587 .5524 L .53668 .54589 L p F P
0 g
s
.532 .307 .519 r
.64789 .41331 m .64637 .37465 L .6677 .36746 L p F P
0 g
s
.532 .307 .519 r
.64637 .37465 m .64789 .41331 L .62646 .42039 L p F P
0 g
s
1 1 0 r
.007 w
.7783 .29796 m
.78006 .28861 L
s
.5 Mabswid
.471 .182 .392 r
.73267 .34554 m .73456 .31463 L .75623 .3072 L p F P
0 g
s
.471 .182 .392 r
.73456 .31463 m .73267 .34554 L .71084 .3529 L p F P
0 g
s
.611 .513 .719 r
.53668 .54589 m .55099 .59336 L .5301 .5997 L p F P
0 g
s
.625 .565 .768 r
.57203 .58698 m .58988 .63229 L .56884 .63848 L p F P
0 g
s
.625 .565 .768 r
.56884 .63848 m .55099 .59336 L .57203 .58698 L p F P
0 g
s
.568 .392 .603 r
.58973 .47858 m .58409 .43439 L .60519 .42742 L p F P
0 g
s
.568 .392 .603 r
.58409 .43439 m .58973 .47858 L .56858 .48539 L p F P
0 g
s
.636 .619 .816 r
.63246 .61977 m .65256 .66051 L .63126 .66659 L p F P
0 g
s
.636 .619 .816 r
.63126 .66659 m .61109 .62605 L .63246 .61977 L p F P
0 g
s
.643 .679 .869 r
.71743 .64198 m .73809 .67612 L .71646 .68214 L p F P
0 g
s
.643 .679 .869 r
.71646 .68214 m .69564 .6482 L .71743 .64198 L p F P
0 g
s
.593 .457 .666 r
.55765 .53933 m .54759 .49215 L .56858 .48539 L p F P
0 g
s
.593 .457 .666 r
.54759 .49215 m .55765 .53933 L .53668 .54589 L p F P
0 g
s
1 1 0 r
.007 w
.89635 .67197 m
.90304 .67822 L
s
.5 Mabswid
.642 .75 .927 r
.8263 .65154 m .84567 .67751 L .8236 .68354 L p F P
0 g
s
.642 .75 .927 r
.8236 .68354 m .80399 .65775 L .8263 .65154 L p F P
0 g
s
.611 .513 .719 r
.55099 .59336 m .53668 .54589 L .55765 .53933 L p F P
0 g
s
.532 .307 .519 r
.66949 .40618 m .6677 .36746 L .68919 .36021 L p F P
0 g
s
.532 .307 .519 r
.6677 .36746 m .66949 .40618 L .64789 .41331 L p F P
0 g
s
.471 .182 .392 r
.75466 .33812 m .75623 .3072 L .77806 .29972 L p F P
0 g
s
.471 .182 .392 r
.75623 .3072 m .75466 .33812 L .73267 .34554 L p F P
0 g
s
.611 .513 .719 r
.55765 .53933 m .57203 .58698 L .55099 .59336 L p F P
0 g
s
.625 .565 .768 r
.59324 .58055 m .61109 .62605 L .58988 .63229 L p F P
0 g
s
.625 .565 .768 r
.58988 .63229 m .57203 .58698 L .59324 .58055 L p F P
0 g
s
.568 .392 .603 r
.61105 .47171 m .60519 .42742 L .62646 .42039 L p F P
0 g
s
.568 .392 .603 r
.60519 .42742 m .61105 .47171 L .58973 .47858 L p F P
0 g
s
.636 .619 .816 r
.654 .61343 m .67401 .65438 L .65256 .66051 L p F P
0 g
s
.636 .619 .816 r
.65256 .66051 m .63246 .61977 L .654 .61343 L p F P
0 g
s
.643 .679 .869 r
.73939 .6357 m .75989 .67004 L .73809 .67612 L p F P
0 g
s
.643 .679 .869 r
.73809 .67612 m .71743 .64198 L .73939 .6357 L p F P
0 g
s
.593 .457 .666 r
.57879 .53272 m .56858 .48539 L .58973 .47858 L p F P
0 g
s
.593 .457 .666 r
.56858 .48539 m .57879 .53272 L .55765 .53933 L p F P
0 g
s
1 1 0 r
.007 w
.77816 .29934 m
.7783 .29796 L
s
.5 Mabswid
.642 .75 .927 r
.84879 .64527 m .86791 .67143 L .84567 .67751 L p F P
0 g
s
.642 .75 .927 r
.84567 .67751 m .8263 .65154 L .84879 .64527 L p F P
0 g
s
.611 .513 .719 r
.57203 .58698 m .55765 .53933 L .57879 .53272 L p F P
0 g
s
.532 .307 .519 r
.69126 .39899 m .68919 .36021 L .71084 .3529 L p F P
0 g
s
.532 .307 .519 r
.68919 .36021 m .69126 .39899 L .66949 .40618 L p F P
0 g
s
.471 .182 .392 r
.77806 .29972 m .77683 .33064 L .75466 .33812 L p F P
0 g
s
1 1 0 r
.007 w
.77803 .30062 m
.77816 .29934 L
s
.77719 .30877 m
.77803 .30062 L
s
.5 Mabswid
.611 .513 .719 r
.57879 .53272 m .59324 .58055 L .57203 .58698 L p F P
0 g
s
.625 .565 .768 r
.61462 .57406 m .63246 .61977 L .61109 .62605 L p F P
0 g
s
.625 .565 .768 r
.61109 .62605 m .59324 .58055 L .61462 .57406 L p F P
0 g
s
.568 .392 .603 r
.63253 .4648 m .62646 .42039 L .64789 .41331 L p F P
0 g
s
.568 .392 .603 r
.62646 .42039 m .63253 .4648 L .61105 .47171 L p F P
0 g
s
.636 .619 .816 r
.67571 .60705 m .69564 .6482 L .67401 .65438 L p F P
0 g
s
.636 .619 .816 r
.67401 .65438 m .654 .61343 L .67571 .60705 L p F P
0 g
s
1 1 0 r
.007 w
.89077 .66573 m
.89635 .67197 L
s
.5 Mabswid
.643 .679 .869 r
.76152 .62938 m .78186 .66392 L .75989 .67004 L p F P
0 g
s
.643 .679 .869 r
.75989 .67004 m .73939 .6357 L .76152 .62938 L p F P
0 g
s
.593 .457 .666 r
.60009 .52605 m .58973 .47858 L .61105 .47171 L p F P
0 g
s
.593 .457 .666 r
.58973 .47858 m .60009 .52605 L .57879 .53272 L p F P
0 g
s
.642 .75 .927 r
.87145 .63896 m .89033 .66531 L .86791 .67143 L p F P
0 g
s
1 1 0 r
.007 w
.88934 .66414 m
.89006 .66494 L
s
.89006 .66494 m
.89077 .66573 L
s
.5 Mabswid
.642 .75 .927 r
.86791 .67143 m .84879 .64527 L .87145 .63896 L p F P
0 g
s
.611 .513 .719 r
.59324 .58055 m .57879 .53272 L .60009 .52605 L p F P
0 g
s
.532 .307 .519 r
.7132 .39174 m .71084 .3529 L .73267 .34554 L p F P
0 g
s
.532 .307 .519 r
.71084 .3529 m .7132 .39174 L .69126 .39899 L p F P
0 g
s
.611 .513 .719 r
.60009 .52605 m .61462 .57406 L .59324 .58055 L p F P
0 g
s
.625 .565 .768 r
.63616 .56753 m .654 .61343 L .63246 .61977 L p F P
0 g
s
.625 .565 .768 r
.63246 .61977 m .61462 .57406 L .63616 .56753 L p F P
0 g
s
.568 .392 .603 r
.65418 .45783 m .64789 .41331 L .66949 .40618 L p F P
0 g
s
.568 .392 .603 r
.64789 .41331 m .65418 .45783 L .63253 .4648 L p F P
0 g
s
.636 .619 .816 r
.69758 .60062 m .71743 .64198 L .69564 .6482 L p F P
0 g
s
.636 .619 .816 r
.69564 .6482 m .67571 .60705 L .69758 .60062 L p F P
0 g
s
1 1 0 r
.007 w
.77673 .32097 m
.77719 .30877 L
s
.5 Mabswid
.643 .679 .869 r
.78382 .62301 m .80399 .65775 L .78186 .66392 L p F P
0 g
s
.643 .679 .869 r
.78186 .66392 m .76152 .62938 L .78382 .62301 L p F P
0 g
s
.593 .457 .666 r
.62155 .51934 m .61105 .47171 L .63253 .4648 L p F P
0 g
s
.593 .457 .666 r
.61105 .47171 m .62155 .51934 L .60009 .52605 L p F P
0 g
s
.611 .513 .719 r
.61462 .57406 m .60009 .52605 L .62155 .51934 L p F P
0 g
s
1 1 0 r
.007 w
.88207 .65476 m
.88934 .66414 L
s
.5 Mabswid
.532 .307 .519 r
.73531 .38444 m .73267 .34554 L .75466 .33812 L p F P
0 g
s
.532 .307 .519 r
.73267 .34554 m .73531 .38444 L .7132 .39174 L p F P
0 g
s
.611 .513 .719 r
.62155 .51934 m .63616 .56753 L .61462 .57406 L p F P
0 g
s
.625 .565 .768 r
.65786 .56095 m .67571 .60705 L .654 .61343 L p F P
0 g
s
.625 .565 .768 r
.654 .61343 m .63616 .56753 L .65786 .56095 L p F P
0 g
s
.568 .392 .603 r
.676 .4508 m .66949 .40618 L .69126 .39899 L p F P
0 g
s
.568 .392 .603 r
.66949 .40618 m .676 .4508 L .65418 .45783 L p F P
0 g
s
.636 .619 .816 r
.71963 .59413 m .73939 .6357 L .71743 .64198 L p F P
0 g
s
.636 .619 .816 r
.71743 .64198 m .69758 .60062 L .71963 .59413 L p F P
0 g
s
.643 .679 .869 r
.80631 .61658 m .8263 .65154 L .80399 .65775 L p F P
0 g
s
.643 .679 .869 r
.80399 .65775 m .78382 .62301 L .80631 .61658 L p F P
0 g
s
.593 .457 .666 r
.64319 .51258 m .63253 .4648 L .65418 .45783 L p F P
0 g
s
.593 .457 .666 r
.63253 .4648 m .64319 .51258 L .62155 .51934 L p F P
0 g
s
.611 .513 .719 r
.63616 .56753 m .62155 .51934 L .64319 .51258 L p F P
0 g
s
1 1 0 r
.007 w
.77673 .32097 m
.77688 .32947 L
s
.5 Mabswid
.532 .307 .519 r
.75759 .37707 m .75466 .33812 L .77683 .33064 L p F P
0 g
s
.532 .307 .519 r
.75466 .33812 m .75759 .37707 L .73531 .38444 L p F P
0 g
s
.611 .513 .719 r
.64319 .51258 m .65786 .56095 L .63616 .56753 L p F P
0 g
s
.625 .565 .768 r
.67974 .55431 m .69758 .60062 L .67571 .60705 L p F P
0 g
s
.625 .565 .768 r
.67571 .60705 m .65786 .56095 L .67974 .55431 L p F P
0 g
s
.568 .392 .603 r
.69799 .44372 m .69126 .39899 L .7132 .39174 L p F P
0 g
s
.568 .392 .603 r
.69126 .39899 m .69799 .44372 L .676 .4508 L p F P
0 g
s
.636 .619 .816 r
.74185 .5876 m .76152 .62938 L .73939 .6357 L p F P
0 g
s
.636 .619 .816 r
.73939 .6357 m .71963 .59413 L .74185 .5876 L p F P
0 g
s
.643 .679 .869 r
.82896 .61011 m .84879 .64527 L .8263 .65154 L p F P
0 g
s
.643 .679 .869 r
.8263 .65154 m .80631 .61658 L .82896 .61011 L p F P
0 g
s
1 1 0 r
.007 w
.87459 .64388 m
.88207 .65476 L
s
.5 Mabswid
.593 .457 .666 r
.66499 .50576 m .65418 .45783 L .676 .4508 L p F P
0 g
s
.593 .457 .666 r
.65418 .45783 m .66499 .50576 L .64319 .51258 L p F P
0 g
s
.611 .513 .719 r
.65786 .56095 m .64319 .51258 L .66499 .50576 L p F P
0 g
s
.532 .307 .519 r
.77683 .33064 m .78005 .36966 L .75759 .37707 L p F P
0 g
s
1 1 0 r
.007 w
.77691 .33165 m
.77696 .3345 L
s
.77688 .32947 m
.77691 .33165 L
s
.5 Mabswid
.611 .513 .719 r
.66499 .50576 m .67974 .55431 L .65786 .56095 L p F P
0 g
s
.625 .565 .768 r
.70179 .54762 m .71963 .59413 L .69758 .60062 L p F P
0 g
s
.625 .565 .768 r
.69758 .60062 m .67974 .55431 L .70179 .54762 L p F P
0 g
s
.568 .392 .603 r
.72015 .43659 m .7132 .39174 L .73531 .38444 L p F P
0 g
s
.568 .392 .603 r
.7132 .39174 m .72015 .43659 L .69799 .44372 L p F P
0 g
s
.636 .619 .816 r
.76424 .58101 m .78382 .62301 L .76152 .62938 L p F P
0 g
s
.636 .619 .816 r
.76152 .62938 m .74185 .5876 L .76424 .58101 L p F P
0 g
s
1 1 0 r
.007 w
.77696 .3345 m
.77788 .34924 L
s
.5 Mabswid
.643 .679 .869 r
.8518 .60358 m .87145 .63896 L .84879 .64527 L p F P
0 g
s
.643 .679 .869 r
.84879 .64527 m .82896 .61011 L .8518 .60358 L p F P
0 g
s
.593 .457 .666 r
.68696 .49888 m .676 .4508 L .69799 .44372 L p F P
0 g
s
.593 .457 .666 r
.676 .4508 m .68696 .49888 L .66499 .50576 L p F P
0 g
s
.611 .513 .719 r
.67974 .55431 m .66499 .50576 L .68696 .49888 L p F P
0 g
s
1 1 0 r
.007 w
.87212 .63989 m
.87459 .64388 L
s
.86696 .63158 m
.87067 .63755 L
s
.87067 .63755 m
.87212 .63989 L
s
.5 Mabswid
0 .86 0 r
.36815 .34413 m .36463 .35214 L .35314 .32386 L closepath p F P
0 g
s
0 .872 0 r
.37595 .33852 m .36815 .34413 L .35314 .32386 L closepath p F P
0 g
s
0 .712 0 r
.3835 .33859 m .37595 .33852 L .35314 .32386 L closepath p F P
0 g
s
.611 .513 .719 r
.68696 .49888 m .70179 .54762 L .67974 .55431 L p F P
0 g
s
.625 .565 .768 r
.72402 .54088 m .74185 .5876 L .71963 .59413 L p F P
0 g
s
.625 .565 .768 r
.71963 .59413 m .70179 .54762 L .72402 .54088 L p F P
0 g
s
.568 .392 .603 r
.74249 .42939 m .73531 .38444 L .75759 .37707 L p F P
0 g
s
.568 .392 .603 r
.73531 .38444 m .74249 .42939 L .72015 .43659 L p F P
0 g
s
1 0 0 r
.007 w
.60171 .40809 m
.77788 .34924 L
s
.5 Mabswid
.636 .619 .816 r
.78682 .57438 m .80631 .61658 L .78382 .62301 L p F P
0 g
s
.636 .619 .816 r
.78382 .62301 m .76424 .58101 L .78682 .57438 L p F P
0 g
s
0 0 0 r
.36463 .35214 m .36745 .3579 L .35314 .32386 L closepath p F P
0 g
s
.593 .457 .666 r
.70911 .49196 m .69799 .44372 L .72015 .43659 L p F P
0 g
s
.593 .457 .666 r
.69799 .44372 m .70911 .49196 L .68696 .49888 L p F P
0 g
s
0 .392 0 r
.38638 .34432 m .3835 .33859 L .35314 .32386 L closepath p F P
0 g
s
1 1 0 r
.007 w
.77788 .34924 m
.77949 .3651 L
s
.5 Mabswid
.611 .513 .719 r
.70179 .54762 m .68696 .49888 L .70911 .49196 L p F P
0 g
s
0 .594 0 r
.36745 .3579 m .37501 .35802 L .35314 .32386 L closepath p F P
0 g
s
.611 .513 .719 r
.70911 .49196 m .72402 .54088 L .70179 .54762 L p F P
0 g
s
1 1 0 r
.007 w
.85926 .61793 m
.86696 .63158 L
s
.5 Mabswid
.625 .565 .768 r
.74642 .53409 m .76424 .58101 L .74185 .5876 L p F P
0 g
s
.625 .565 .768 r
.74185 .5876 m .72402 .54088 L .74642 .53409 L p F P
0 g
s
.568 .392 .603 r
.76501 .42214 m .75759 .37707 L .78005 .36966 L p F P
0 g
s
0 0 1 r
.007 w
.77788 .34924 m
.7791 .36402 L
s
.5 Mabswid
.568 .392 .603 r
.75759 .37707 m .76501 .42214 L .74249 .42939 L p F P
0 g
s
.636 .619 .816 r
.80957 .56768 m .82896 .61011 L .80631 .61658 L p F P
0 g
s
.636 .619 .816 r
.80631 .61658 m .78682 .57438 L .80957 .56768 L p F P
0 g
s
0 .687 0 r
.38287 .35238 m .38638 .34432 L .35314 .32386 L closepath p F P
0 g
s
.593 .457 .666 r
.73143 .48498 m .72015 .43659 L .74249 .42939 L p F P
0 g
s
.593 .457 .666 r
.72015 .43659 m .73143 .48498 L .70911 .49196 L p F P
0 g
s
0 .705 0 r
.37501 .35802 m .38287 .35238 L .35314 .32386 L closepath p F P
0 g
s
0 1 0 r
.007 w
.3807 .35394 m
.47049 .45192 L
s
.5 Mabswid
.611 .513 .719 r
.72402 .54088 m .70911 .49196 L .73143 .48498 L p F P
0 g
s
1 1 0 r
.007 w
.77949 .3651 m
.77997 .36862 L
s
.5 Mabswid
.611 .513 .719 r
.73143 .48498 m .74642 .53409 L .72402 .54088 L p F P
0 g
s
.625 .565 .768 r
.769 .52724 m .78682 .57438 L .76424 .58101 L p F P
0 g
s
.625 .565 .768 r
.76424 .58101 m .74642 .53409 L .769 .52724 L p F P
0 g
s
.568 .392 .603 r
.78005 .36966 m .78771 .41484 L .76501 .42214 L p F P
0 g
s
1 1 0 r
.007 w
.77997 .36862 m
.78034 .37133 L
s
.78034 .37133 m
.78178 .38195 L
s
.5 Mabswid
.636 .619 .816 r
.8325 .56094 m .8518 .60358 L .82896 .61011 L p F P
0 g
s
.636 .619 .816 r
.82896 .61011 m .80957 .56768 L .8325 .56094 L p F P
0 g
s
1 1 0 r
.007 w
.85196 .60387 m
.85926 .61793 L
s
.85154 .60305 m
.85173 .60343 L
s
.85173 .60343 m
.85196 .60387 L
s
.5 Mabswid
.593 .457 .666 r
.75393 .47794 m .74249 .42939 L .76501 .42214 L p F P
0 g
s
.593 .457 .666 r
.74249 .42939 m .75393 .47794 L .73143 .48498 L p F P
0 g
s
.611 .513 .719 r
.74642 .53409 m .73143 .48498 L .75393 .47794 L p F P
0 g
s
1 1 0 r
.007 w
.78178 .38195 m
.78475 .39965 L
s
.5 Mabswid
.611 .513 .719 r
.75393 .47794 m .769 .52724 L .74642 .53409 L p F P
0 g
s
.625 .565 .768 r
.79176 .52034 m .80957 .56768 L .78682 .57438 L p F P
0 g
s
.625 .565 .768 r
.78682 .57438 m .769 .52724 L .79176 .52034 L p F P
0 g
s
1 1 0 r
.007 w
.84387 .58705 m
.85154 .60305 L
s
.5 Mabswid
.593 .457 .666 r
.77661 .47085 m .76501 .42214 L .78771 .41484 L p F P
0 g
s
0 0 1 r
.007 w
.7791 .36402 m
.78098 .3869 L
s
.5 Mabswid
.593 .457 .666 r
.76501 .42214 m .77661 .47085 L .75393 .47794 L p F P
0 g
s
.611 .513 .719 r
.769 .52724 m .75393 .47794 L .77661 .47085 L p F P
0 g
s
1 1 0 r
.007 w
.78475 .39965 m
.78748 .41349 L
s
.5 Mabswid
.611 .513 .719 r
.77661 .47085 m .79176 .52034 L .769 .52724 L p F P
0 g
s
1 1 0 r
.007 w
.83633 .57007 m
.84387 .58705 L
s
.5 Mabswid
.625 .565 .768 r
.8147 .51338 m .8325 .56094 L .80957 .56768 L p F P
0 g
s
.625 .565 .768 r
.80957 .56768 m .79176 .52034 L .8147 .51338 L p F P
0 g
s
.593 .457 .666 r
.78771 .41484 m .79947 .46369 L .77661 .47085 L p F P
0 g
s
1 1 0 r
.007 w
.78748 .41349 m
.78791 .41569 L
s
.78791 .41569 m
.78838 .41805 L
s
0 0 1 r
.78098 .3869 m
.78483 .43358 L
s
1 1 0 r
.78838 .41805 m
.79263 .43699 L
s
.5 Mabswid
.611 .513 .719 r
.79176 .52034 m .77661 .47085 L .79947 .46369 L p F P
0 g
s
1 1 0 r
.007 w
.83326 .56262 m
.83633 .57007 L
s
.82899 .55224 m
.83183 .55914 L
s
.83183 .55914 m
.83326 .56262 L
s
.5 Mabswid
.611 .513 .719 r
.79947 .46369 m .8147 .51338 L .79176 .52034 L p F P
0 g
s
1 1 0 r
.007 w
.79263 .43699 m
.79748 .45631 L
s
.82191 .53373 m
.82899 .55224 L
s
.79748 .45631 m
.79908 .46207 L
s
.80008 .46568 m
.80289 .47582 L
s
.79908 .46207 m
.80008 .46568 L
s
.81515 .51471 m
.82191 .53373 L
s
.80289 .47582 m
.80879 .49534 L
s
.81483 .51374 m
.81515 .51471 L
s
.80879 .49534 m
.81447 .51264 L
s
.81447 .51264 m
.81483 .51374 L
s
.5 Mabswid
0 0 .377 r
.78574 .51221 m .79596 .51159 L .79367 .5409 L closepath p F P
0 g
s
0 0 .23 r
.7784 .50842 m .78574 .51221 L .79367 .5409 L closepath p F P
0 g
s
0 0 .302 r
.79596 .51159 m .80312 .50691 L .79367 .5409 L closepath p F P
0 g
s
0 0 .505 r
.77822 .50241 m .7784 .50842 L .79367 .5409 L closepath p F P
0 g
s
0 0 .359 r
.80312 .50691 m .80302 .50089 L .79367 .5409 L closepath p F P
0 g
s
0 0 .622 r
.78537 .49768 m .77822 .50241 L .79367 .5409 L closepath p F P
0 g
s
0 0 .598 r
.80302 .50089 m .79567 .49705 L .79367 .5409 L closepath p F P
0 g
s
0 0 .612 r
.79567 .49705 m .78537 .49768 L .79367 .5409 L closepath p F P
0 g
s
0 0 1 r
.007 w
.78483 .43358 m
.79009 .49739 L
s
.5 Mabswid
0 .888 0 r
.68686 .22912 m .68367 .23742 L .67652 .20559 L closepath p F P
0 g
s
0 .89 0 r
.6953 .22311 m .68686 .22912 L .67652 .20559 L closepath p F P
0 g
s
0 .725 0 r
.70411 .22289 m .6953 .22311 L .67652 .20559 L closepath p F P
0 g
s
0 .004 0 r
.68367 .23742 m .68763 .24318 L .67652 .20559 L closepath p F P
0 g
s
0 .264 0 r
.70814 .22862 m .70411 .22289 L .67652 .20559 L closepath p F P
0 g
s
0 .596 0 r
.68763 .24318 m .69646 .24301 L .67652 .20559 L closepath p F P
0 g
s
0 .702 0 r
.70497 .23697 m .70814 .22862 L .67652 .20559 L closepath p F P
0 g
s
0 .712 0 r
.69646 .24301 m .70497 .23697 L .67652 .20559 L closepath p F P
0 g
s
0 1 0 r
.007 w
.70076 .23995 m
.77788 .34924 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 266.5},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001Sb000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooolT0?ooo`030000003oool0oooo08X0oooo
003o0?ooob@0oooo0`00002:0?ooo`00o`3ooolT0?ooo`@00000R@3oool00?l0oooo9@3oool50000
08L0oooo003o0?ooobD0oooo0`0000000`00/`000000000000260?ooo`00o`3ooolU0?ooo`040000
0000V0000000000000800;<00P0000240?ooo`00o`3ooolU0?ooo`<0000000@00;H000000000/`00
0;<00P0000230?ooo`00o`3ooolU0?ooo`80000000@009P000000000]P0000000`00/`0200000840
oooo003o0?ooobH0oooo00<00000002H000000000P00]P00100000000;<0002c0000/`0200000800
oooo003o0?ooobH0oooo0P0000001@00V0000000002f0000]P00000000<00;<00P00001o0?ooo`00
o`3ooolV0?ooo`8000000P00V000100000000;H0002f00000004002c00030000003oool0oooo07`0
oooo003o0?ooobH0oooo0P000002002H000400000000]P000;H0000000<00;<000<000000?ooo`3o
ool0O@3oool00?l0oooo9`3oool20000008009P000@00000002f0000]P0000000P00/`000`000000
oooo0?ooo`1m0?ooo`00o`3ooolW0?ooo`8000000P00V000100000000;H0002f0000]P0200000800
oooo003o0?ooobL0oooo0P000003002H000300000000]P000?l000800?l0P03oool00?l0oooo:03o
ool01P00000009P0002H0000V0000000002f00<00?l0P03oool00?l0oooo:03oool20000008009P0
0P000004003o07l0oooo003o0?ooobT0oooo0`0000030?ooo`@00?l0OP3oool00?l0oooo<03oool3
003o07h0oooo003o0?oooc00oooo1000o`1m0?ooo`00o`3ooola0?ooo`@00?l0O03oool00?l0oooo
<P3oool4003o07/0oooo003o0?oooc<0oooo0`00o`1k0?ooo`00o`3ooolc0?ooo`@00?l0NP3oool0
0?l0oooo=03oool4003o07T0oooo003o0?ooocD0oooo0`00o`0O0?ooo`P0ool0DP3oool00?l0oooo
=@3oool4003o01/0oooo2`3oo`1B0?ooo`00o`3ooolf0?ooo`@00?l06@3oool>0?oo0500oooo003o
0?ooocL0oooo0`00o`0H0?ooo`030000003oo`00ool000<0ool01@2Gi_`70?oo04d0oooo003o0?oo
ocL0oooo1000o`0D0?ooo`<00000103oo`0809OVo0H0ool0C@3oool00?l0oooo>03oool4003o0100
oooo0`00000201H000@0ool02P2Gi_`50?oo04d0oooo003o0?ooocT0oooo1000o`0<0?ooo`@00000
0`0F00050?oo008000001P2Gi_`200000080Z=Cg103oo`1<0?ooo`00o`3ooolj0?ooo`<00?l02@3o
ool3000000805P0000<0000001H0000F00000`0F00030?oo00<0UnKl0P00000209OVo08000001@2X
e?L40?oo04/0oooo003o0?ooocX0oooo1000o`050?ooo`<000001@0F00000`0000005P0001H00003
000000<0ool0102Gi_`3000000P0Z=Cg103oo`1:0?ooo`00o`3ooolk0?ooo`@00?l000<0oooo0000
000000000P00000601H000@000000P1J02`40?oo000409OVo0000000000000000080Z=Cg00<00000
0:SDm`2Xe?L01`2Xe?L40?oo04T0oooo003o0?oooc`0oooo0`00o`00100000005P0001H000000005
01H000<000001@1J02`30?oo008000001P2Xe?L00`000000Z=Cg0:SDm`070:SDm`@0ool0B03oool0
0?l0oooo>P3oool2000000@00?l00P0F00000`0000005P0001H000030000000305X0;0000000FP0/
00D0FP0/0`3oo`090:SDm`030000002Xe?L0Z=Cg00L0Z=Cg1@3oo`160?ooo`00o`3ooolg0?ooo`@0
00000P0F0004003o00@000000`1J02`00`000000FP0/05X0;00505X0;0<0ool02P2Xe?L00`000000
Z=Cg0:SDm`070:SDm`D0ool0A@3oool00?l0oooo=03oool3000000805P0000<0000001H0000F0000
0P0F0003003o00030000001J02`0FP0/00@0FP0/00<0000005X0;01J02`0101J02`40?oo00/0Z=Cg
00<000000:SDm`2Xe?L0102Xe?L3000000@0ool0A@3oool00?l0oooo<@3oool3000000D05P0000<0
000001H0000F00000P000004003o00H0FP0/00<0000005X0;01J02`0101J02`30?oo00030:SDm`00
0000Z=Cg00X0Z=Cg00<000000:SDm`2Xe?L00`0000040:_0j@@0ool0A03oool00?l0oooo;P3oool4
000000H05P001000000305X0;0@00?l0101J02`00`000000FP0/05X0;00405X0;0@0ool00P2Xe?L0
0`000000Z=Cg0:SDm`080:SDm`<00000202[`>T40?oo04<0oooo003o0?ooob/0oooo0`00000201H0
00030000000F00005P0000<05P000`00000605X0;00300000000o`000?l000800?l00`1J02`00`00
0000FP0/05X0;00405X0;0@0ool00`2Xe?L00`000000Z=Cg0:SDm`040:SDm`<000000P2[`>T00`00
0000Zl3Y0:_0j@070:_0j@@0ool0@P3oool00?l0oooo:03oool3000000D05P0000<0000001H0000F
00000`0000000`1J02`0000005X0;00605X0;0030000001J02`00?l000800?l00`1J02`00`000000
FP0/05X0;00205X0;0800000103oo`040:SDm`030000002Xe?L0Z=Cg00<000001@2[`>T00`000000
Zl3Y0:_0j@080:_0j@<0ool0@P3oool00?l0oooo9@3oool4000000H05P001000000305X0;0030000
001J02`0FP0/00D0FP0/00<0000005X0;01J02`01000o`000`1J02`0000005X0;00400000080N2iT
103oo`040:SDm`<000002@2[`>T00`000000Zl3Y0:_0j@070:_0j@@0ool0@@3oool00?l0oooo8P3o
ool3000000805P0000<0000001H0000F00000`0F0003000000H0FP0/00<0000005X0;01J02`01@1J
02`010000000FP0/05X0;01J02`4003o008000001P1h;V@30?oo00<0Z=Cg0P0000020:_0j@030000
002[`>T0Zl3Y00P0Zl3Y00<000000:_0j@2[`>T01`2[`>T30?oo0440oooo003o0?oooal0oooo0`00
000501H000030000000F00005P0000<0000000<0FP0/0000001J02`01P1J02`00`000000FP0/05X0
;00505X0;0050000001J02`0FP0/05X0;00000000`00o`000`000000N2iT07P^I00507P^I0<0ool0
0`0000050:_0j@030000002[`>T0Zl3Y00L0Zl3Y00<000000:_0j@2[`>T01`2[`>T30?oo0440oooo
003o0?oooad0oooo0`00000601H000@000000`1J02`00`000000FP0/05X0;00505X0;0030000001J
02`0FP0/00D0FP0/00<0000005X0;00000000P0000000`1h;V@00?l0003o0002003o00L0N2iT0`3o
o`080:_0j@030000002[`>T0Zl3Y00P0Zl3Y00<000000:_0j@2[`>T01P2[`>T50?oo03l0oooo003o
0?oooaX0oooo0`0000000`0F0000000001H0000401H000<000001P1J02`00`000000FP0/05X0;005
05X0;0030000001J02`0FP0/00@0FP0/0`00000507P^I0@00?l01P1h;V@30?oo00T0Zl3Y00<00000
0:_0j@2[`>T0202[`>T00`000000Zl3Y0:_0j@060:_0j@@0ool0?`3oool00?l0oooo5`3oool30000
00@05P0000<0000001H0000F00000`0000000`1J02`0000005X0;00605X0;0030000001J02`0FP0/
00D0FP0/00@0000005X0;01J02`0FP0/0`0000000`1h;V@0000007P^I00607P^I0@00?l01@1h;V@3
0?oo00X0Zl3Y00<000000:_0j@2[`>T0202[`>T00`000000Zl3Y0:_0j@030:_0j@800000103oo`0o
0?ooo`00o`3ooolD0?ooo`@000001@0F0004000000<0FP0/00<0000005X0;01J02`01@1J02`00`00
0000FP0/05X0;00505X0;0030000001J02`0000000800000101h;V@00`000000N2iT07P^I00607P^
I0<00?l01@1h;V@30?oo00030000002[`>T0Zl3Y00P0Zl3Y00<000000:_0j@2[`>T01`2[`>T00`00
0000Zl3Y0:_0j@03000000<0ZK3M103oo`0n0?ooo`00o`3ooolA0?ooo`<000000P0F00000`000000
5P0001H0000201H000<000001P1J02`00`000000FP0/05X0;00505X0;0030000001J02`0FP0/00@0
FP0/0`00000707P^I0030000001h;V@0N2iT00H0N2iT1000o`0407P^I0<0ool000<0Zl3Y0000002[
`>T02@2[`>T00`000000Zl3Y0:_0j@060:_0j@<000001`2Y/=d40?oo03d0oooo002H0?ooo`030000
003oool0oooo0780oooo0`00000401H000040000000F00005P0001H00080000000<0FP0/0000001J
02`01@1J02`00`000000FP0/05X0;00605X0;0030000001J02`0FP0/0080FP0/0P0000000`1h;V@0
000007P^I00707P^I0030000001h;V@0N2iT00H0N2iT00<00000003o0000o`000P00o`0307P^I0<0
ool000<0Zl3Y0000002[`>T02@2[`>T00`000000Zl3Y0:_0j@040:_0j@8000000P2Y/=d00`000000
ZK3M0:V`g@060:V`g@<0ool0?@3oool009P0oooo0`00001`0?ooo`<000001P0F0000100000005P00
00000000000205X0;0030000001J02`0FP0/00D0FP0/00<0000005X0;01J02`01P1J02`00`000000
FP0/05X0;002000000<0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00607P^I003
0000001h;V@00?l000800?l00`1h;V@30?oo0080Zl3Y00<000000:_0j@2[`>T0202[`>T00`000000
Zl3Y0:_0j@03000000@0ZK3M00<000000:V`g@2Y/=d01P2Y/=d40?oo03`0oooo002I0?ooo`@00000
J`3oool30000000301H0000000005P0000D05P000`00000405X0;0030000001J02`0FP0/00D0FP0/
00<0000005X0;01J02`01@1J02`010000000FP0/00000000000507P^I0030000001h;V@0N2iT00H0
N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT003o0003003o0080N2iT0`3oo`030:_0j@03
0000002[`>T0Zl3Y00L0Zl3Y0`0000080:V`g@030000002Y/=d0ZK3M00H0ZK3M0`3oo`0l0?ooo`00
V@3oool6000006H0oooo0`00000301H000030000000F00005P0000<05P000`00000505X0;0030000
001J02`0FP0/00D0FP0/00<0000005X0;01J02`01@1J02`3000000L0N2iT00<0000007P^I01h;V@0
1@1h;V@00`000000N2iT07P^I00707P^I0030000001h;V@0N2iT00@00?l000@0N2iT0?oo003oo`00
ool0102[`>T00`000000Zl3Y0:_0j@030:_0j@<000000P2Y/=d00`000000ZK3M0:V`g@060:V`g@03
0000002Y/=d0ZK3M00H0ZK3M103oo`0k0?ooo`00VP3oool0100000000;@000000000[`0300000640
oooo1000000501H000030000000F00005P0000<0000000<0FP0/0000001J02`01@1J02`00`000000
FP0/05X0;00505X0;0030000001J02`0FP0/0080FP0/0`0000000`1h;V@0000007P^I00707P^I003
0000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01`1h;V@010000000N2iT07P^I01h;V@3003o
00040000003oo`00ool00?oo00@0Zl3Y00<000000:_0j@2[`>T00`0000050:V`g@030000002Y/=d0
ZK3M00L0ZK3M00<000000:V`g@2Y/=d01P2Y/=d30?oo03/0oooo002J0?ooo`80000000<00;@00000
0000[`001000001L0?ooo`<000000P0F00000`0000005P0001H0000301H000@000000`1J02`00`00
0000FP0/05X0;00505X0;0030000001J02`0FP0/00@0FP0/00<0000005X0;00000000`00000407P^
I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00707P^
I0040000001h;V@00000000000@00?l00`3oo`040:_0j@<000002@2Y/=d00`000000ZK3M0:V`g@07
0:V`g@030000002Y/=d0ZK3M00D0ZK3M103oo`0j0?ooo`00VP3oool01@00000009P000000000]000
000000800:l01000001G0?ooo`<00000100F00000`0000005P0001H0000201H000<000001P1J02`0
0`000000FP0/05X0;00405X0;0030000001J02`0FP0/00@0FP0/0`00000807P^I0030000001h;V@0
N2iT00D0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00607P^I0<000000`28CX@4
003o0080ool00P2[`>T200000080ZK3M00<000000:V`g@2Y/=d01`2Y/=d00`000000ZK3M0:V`g@07
0:V`g@030000002Y/=d0ZK3M00H0ZK3M0`3oo`0j0?ooo`00V`3oool2000000800;@000L00000002_
0000[`000:l000000000I000000005@0oooo0`00000501H000030000000F00005P0000<0000000<0
FP0/0000001J02`01@1J02`00`000000FP0/05X0;00505X0;0040000001J02`0FP0/05X0;0<00000
00<0N2iT0000001h;V@0201h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT
00<0000007P^I01h;V@0101h;V@20000000308Q>Q0000000R4j400@0R4j41000o`000`3oo`000000
000000040:V`g@030000002Y/=d0ZK3M00P0ZK3M00<000000:V`g@2Y/=d01`2Y/=d00`000000ZK3M
0:V`g@050:V`g@@0ool0>@3oool009/0oooo00<00000002H000000000P00]000100000000:l0002_
0000[`0200000540oooo0`0000000`0F0000000001H0000401H000@000000`1J02`00`000000FP0/
05X0;00505X0;0030000001J02`0FP0/00@0FP0/00<0000005X0;00000000P00000407P^I0030000
001h;V@0N2iT00L0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00607P^I0040000
001h;V@0N2iT07P^I0<000000`28CX@00`000000R4j408Q>Q00408Q>Q0<00?l000<0ool00:V`g@2Y
/=d01@2Y/=d00`000000ZK3M0:V`g@070:V`g@030000002Y/=d0ZK3M00P0ZK3M00<000000:V`g@2Y
/=d01@2Y/=d40?oo03P0oooo002L0?ooo`8000000`00]0000`0000000:l0002_0002002_00030000
003oool0oooo04/0oooo0`00000301H000030000000F00005P0000805P000`00000605X0;0030000
001J02`0FP0/00@0FP0/00<0000005X0;01J02`0101J02`3000000L0N2iT00<0000007P^I01h;V@0
1`1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT00@0000007P^I0000000
00001P28CX@00`000000R4j408Q>Q00408Q>Q0@00?l000<0ool00:V`g@2Y/=d0102Y/=d00`000000
ZK3M0:V`g@080:V`g@030000002Y/=d0ZK3M00L0ZK3M00<000000:V`g@2Y/=d01@2Y/=d50?oo03L0
oooo002L0?ooo`0300000000V000000000<00;@000D00000002_0000[`000:l00000001:0?ooo`@0
00001@0F00000`0000005P0001H000020000000305X0;0000000FP0/00H0FP0/00<0000005X0;01J
02`0101J02`010000000FP0/05X0;01J02`30000000307P^I0000000N2iT00L0N2iT00<0000007P^
I01h;V@01P1h;V@00`000000N2iT07P^I00607P^I0030000001h;V@0N2iT00D0N2iT0`00000808Q>
Q00300000028CX@0R4j400D0R4j41000o`070:V`g@030000002Y/=d0ZK3M00L0ZK3M00<000000:V`
g@2Y/=d0202Y/=d00`000000ZK3M0:V`g@050:V`g@@0ool0=`3oool009`0oooo00@00000002H0000
V00000000`00]0000`0000000?l0000000180?ooo`<000000P0F00000`0000005P0001H0000301H0
00@000000P1J02`00`000000FP0/05X0;00505X0;0030000001J02`0FP0/00@0FP0/00<0000005X0
;00000000P00000407P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@01P1h;V@00`00
0000N2iT07P^I00607P^I0030000001h;V@0N2iT0080N2iT0`0000000`28CX@0000008Q>Q00808Q>
Q00300000028CX@0R4j400<0R4j40`3o0003003o00P0ZK3M00<000000:V`g@2Y/=d01`2Y/=d00`00
0000ZK3M0:V`g@070:V`g@040000002Y/=d0ZK3M0:V`g@@0000000@0Yj?A0?oo003oo`00ool0=`3o
ool009d0oooo00<00000002H000000000`00]003003o04D0oooo0`00000401H000030000000F0000
5P0000805P000`00000505X0;0030000001J02`0FP0/00D0FP0/00<0000005X0;01J02`00`1J02`3
000000L0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00607P^I0030000001h;V@0
N2iT00H0N2iT00<0000007P^I00000000P00000408Q>Q00300000028CX@0R4j400L0R4j400<00000
08Q>Q028CX@01P3o0003003o00P0ZK3M00<000000:V`g@2Y/=d01`2Y/=d00`000000ZK3M0:V`g@07
0:V`g@@000001@2WXm440?oo03H0oooo002M0?ooo`0400000000V00009P0000000800;@00`00o`13
0?ooo`<000001@0F00000`0000005P0001H000030000000305X0;0000000FP0/00D0FP0/00<00000
05X0;01J02`01@1J02`010000000FP0/05X0;01J02`20000000307P^I0000000N2iT00L0N2iT00<0
000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00707P^I0030000001h;V@0N2iT00D0N2iT0`00
000708Q>Q00300000028CX@0R4j400L0R4j42@3o00030000o`T0ZK3M00<000000:V`g@2Y/=d01`2Y
/=d00`000000ZK3M0:V`g@030:V`g@<0000000<0Yj?A0000002WXm401`2WXm430?oo03H0oooo002N
0?ooo`0300000000V000000000800;@000@00000003o0000o`000?l0?`3oool30000000301H00000
00005P0000@05P001000000305X0;0030000001J02`0FP0/00@0FP0/00<0000005X0;01J02`01@1J
02`00`000000FP0/00000002000000<0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^
I00507P^I0030000001h;V@0N2iT00L0N2iT00<0000007P^I01h;V@00P1h;V@30000000308Q>Q000
0000R4j400L0R4j400<0000008Q>Q028CX@01028CX@:0?l00080R4j40`000?l:0:V`g@030000002Y
/=d0ZK3M00H0ZK3M00<000000:V`g@2Y/=d00`0000050:NSd@030000002WXm40Yj?A00D0Yj?A103o
o`0e0?ooo`00WP3oool5000000030?ooo`00o`000?l000800?l0>`3oool3000000<05P0000<00000
01H0000F00000P0F0003000000H0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0;004
05X0;0<000001P1h;V@00`000000N2iT07P^I00607P^I0030000001h;V@0N2iT00D0N2iT00<00000
07P^I01h;V@01`1h;V@00`000000N2iT00000002000000@0R4j400<0000008Q>Q028CX@01P28CX@0
10000000R4j408Q>Q028CX@:0?l000D0R4j40`000?l00`000000ZK3M0:V`g@070:V`g@030000002Y
/=d0ZK3M00H0ZK3M0`0000080:NSd@030000002WXm40Yj?A00H0Yj?A0`3oo`0e0?ooo`00Y@3oool4
003o03L0oooo1000000401H000030000000F00005P0000<0000000<0FP0/0000001J02`01@1J02`0
0`000000FP0/05X0;00505X0;0040000001J02`0FP0/05X0;0<0000000<0N2iT0000001h;V@01P1h
;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@01P1h
;V@3000000L0R4j400<0000008Q>Q028CX@01P28CX@00`000000o`000?l000080?l0000300000028
CX@0R4j400D0R4j40`000?l00`000000ZK3M0:V`g@080:V`g@030000002Y/=d0ZK3M00<0ZK3M0P00
00020:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401@2WXm440?oo03@0oooo002V
0?ooo`@00?l0<`3oool3000000805P0000<0000001H0000F00000P0F0004000000<0FP0/00<00000
05X0;01J02`01@1J02`00`000000FP0/05X0;00405X0;0030000001J02`0000000800000101h;V@0
0`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01P1h;V@0
0`000000N2iT07P^I00307P^I0<0000000<0R4j400000028CX@01`28CX@00`000000R4j408Q>Q004
08Q>Q0X0o`000`28CX@00`000000R4j408Q>Q00508Q>Q0<0003o00<0ZK3M0000002Y/=d0202Y/=d0
0`000000ZK3M0:V`g@03000000@0Yj?A00<000000:NSd@2WXm401`2WXm400`000000Yj?A0:NSd@06
0:NSd@<0ool0=03oool00:L0oooo1000o`0_0?ooo`<000000`0F0002000000<05P000`00000605X0
;0030000001J02`0FP0/00@0FP0/00<0000005X0;01J02`0101J02`3000000L0N2iT00<0000007P^
I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^
I00000000`00000408Q>Q00300000028CX@0R4j400H0R4j400@0000008Q>Q028CX@0R4j42P3o0006
08Q>Q00300000028CX@0R4j400D0R4j40`000?l00`2Y/=d000000:V`g@080:V`g@<00000202WXm40
0`000000Yj?A0:NSd@070:NSd@030000002WXm40Yj?A00D0Yj?A103oo`0c0?ooo`00Z03oool4003o
02`0oooo0`00000401H000030000000F0000000000<0000000<0FP0/0000001J02`01@1J02`00`00
0000FP0/05X0;00505X0;0040000001J02`0FP0/05X0;0<0000000<0N2iT0000001h;V@01P1h;V@0
0`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@01@1h;V@3
000000P0R4j400<0000008Q>Q028CX@01P28CX@00`000000o`000?l000080?l000T0R4j400<00000
08Q>Q028CX@01@28CX@30000o`030?oo002Y/=d0000000D0ZK3M0`0000000`2WXm4000000:NSd@08
0:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401P2WXm430?oo03<0oooo002Y0?oo
o`@00?l0:03oool30000000301H0000000005P0000805P001000000405X0;0030000001J02`0FP0/
00D0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/00000002000000@0N2iT00<0000007P^
I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^
I01h;V@00P1h;V@30000000308Q>Q0000000R4j400P0R4j400<0000008Q>Q028CX@01028CX@:0?l0
0080R4j400<0000008Q>Q028CX@01`28CX@00`000000R4j408Q>Q00508Q>Q0<0003o00<0ool00:V`
g@0000000P2Y/=d3000000D0Yj?A00<000000:NSd@2WXm401`2WXm400`000000Yj?A0:NSd@060:NS
d@030000002WXm40Yj?A00H0Yj?A103oo`0b0?ooo`00ZP3oool4003o02@0oooo0`00000301H00003
0000000F00005P000080000000<0FP0/0000001J02`01@1J02`00`000000FP0/05X0;00405X0;003
0000001J02`0FP0/00@0FP0/0`00000707P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h
;V@01@1h;V@00`000000N2iT07P^I00607P^I0030000001h;V@00000008000001028CX@00`000000
R4j408Q>Q00708Q>Q00400000028CX@0R4j408Q>Q0X0o`001@28CX@00`000000R4j408Q>Q00708Q>
Q00300000028CX@0R4j400<0R4j40P0000030000o`030?oo002Y/=d0000000800000202WXm400`00
0000Yj?A0:NSd@070:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401P2WXm430?oo
0380oooo002[0?ooo`@00?l08@3oool3000000@05P001000000205X0;0030000001J02`0FP0/00@0
FP0/00<0000005X0;01J02`01@1J02`010000000FP0/05X0;01J02`30000000307P^I0000000N2iT
00H0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT
00D0N2iT0`00000708Q>Q00300000028CX@0R4j400L0R4j400<000000?l0003o0000203o000808Q>
Q00300000028CX@0R4j400L0R4j400<0000008Q>Q00000000`000002095TVP<0003o00D0ool00000
002WXm40Yj?A000000090:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401P2WXm40
0`000000Yj?A0:NSd@060:NSd@@0ool0<@3oool00:`0oooo0`00o`0N0?ooo`<0000000<05P000000
000F00000P0F0003000000D0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0;00405X0
;0030000001J02`0000000800000101h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT
00H0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00207P^I0<0000000<0R4j40000
0028CX@01`28CX@00`000000R4j408Q>Q00608Q>Q0T0o`000P28CX@00`000000R4j408Q>Q00608Q>
Q00300000028CX@0R4j400H0R4j40`000007095TVP<0003o0`2WXm400`000000Yj?A0:NSd@070:NS
d@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401`2WXm400`000000Yj?A0:NSd@060:NS
d@<0ool0<@3oool00:d0oooo0`00o`0J0?ooo`<000000P0F00020000000301H00000000000000080
00001P1J02`00`000000FP0/05X0;00405X0;0030000001J02`0FP0/00@0FP0/0`00000707P^I003
0000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00507P^I003
0000001h;V@00000008000001028CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400<0
R4j42@3o000508Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@00`28CX@300000003
095TVP000000TFBJ00L0TFBJ0`000?l40:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2W
Xm401`2WXm400`000000Yj?A0:NSd@060:NSd@030000002WXm40Yj?A00H0Yj?A0`3oo`0a0?ooo`00
FP3oool00`000000oooo0?ooo`1@0?ooo`@00?l05@3oool5000000<05P001000000305X0;0030000
001J02`0FP0/00@0FP0/00<0000005X0;01J02`0101J02`010000000FP0/05X0;01J02`300000003
07P^I0000000N2iT00H0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00507P^I003
0000001h;V@0N2iT00D0N2iT0`00000708Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028
CX@02@3o000808Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q00000000`000004095TVP03
0000002AI9X0TFBJ00H0TFBJ0`000?l40:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2W
Xm401`2WXm400`000000Yj?A0:NSd@070:NSd@030000002WXm40Yj?A00@0Yj?A1@3oo`0`0?ooo`00
FP3oool00`000000oooo0?ooo`1A0?ooo`@00?l0403oool4000000<05P0000<0000001H0000F0000
0`00000505X0;0030000001J02`0FP0/00D0FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/
00000002000000@0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00607P^I0030000
001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@00P1h;V@30000000308Q>Q0000000R4j400L0R4j4
00<0000008Q>Q028CX@01P28CX@:0?l0000300000028CX@0R4j400L0R4j400<0000008Q>Q028CX@0
1@28CX@3000000P0TFBJ00<00000095TVP2AI9X01P2AI9X30000o`D0Yj?A00<000000:NSd@2WXm40
1`2WXm400`000000Yj?A0:NSd@070:NSd@030000002WXm40Yj?A00H0Yj?A00<000000:NSd@2WXm40
0`2WXm42000000@0ool0<03oool005T0oooo0`00001C0?ooo`@00?l03@3oool3000000@05P000P00
00001@0F000000000000001J02`0000000H0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/
05X0;00305X0;0<000001`1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00H0N2iT
00<0000007P^I01h;V@01@1h;V@00`000000N2iT00000002000000@0R4j400<0000008Q>Q028CX@0
1P28CX@00`000000R4j408Q>Q00308Q>Q0X0o`000`28CX@00`000000R4j408Q>Q00708Q>Q0030000
0028CX@0R4j400<0R4j40P0000000`2AI9X00000095TVP09095TVP030000002AI9X0TFBJ00D0TFBJ
0`000?l00`3oo`00Yj?A0:NSd@020:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm40
1`2WXm400`000000Yj?A0:NSd@070:NSd@030000002WXm400000008000000`2UUlL40?oo02l0oooo
001I0?ooo`<00000E03oool4003o00T0oooo0`0000000`0F0000000001H0000301H000@000000P1J
02`00`000000FP0/05X0;00405X0;0030000001J02`0FP0/00D0FP0/00@0000005X0;01J02`0FP0/
0P0000000`1h;V@0000007P^I00607P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@0
1@1h;V@00`000000N2iT07P^I00507P^I0<000001`28CX@00`000000R4j408Q>Q00608Q>Q0030000
0028CX@0R4j400X0o`001P28CX@00`000000R4j408Q>Q00708Q>Q00400000028CX@0R4j408Q>Q080
00000`2AI9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ00D0TFBJ0`000?l00`3oo`00
Yj?A0:NSd@030:NSd@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401`2WXm400`000000
Yj?A0:NSd@050:NSd@<000001`2UUlL30?oo02l0oooo001H0?ooo`@00000E@3oool4003o00D0oooo
0`00000301H000040000000F00005P0001H000<000001@1J02`00`000000FP0/05X0;00405X0;003
0000001J02`0FP0/00@0FP0/00<0000005X0;00000000P00000307P^I0030000001h;V@0N2iT00D0
N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT0080
N2iT0`0000000`28CX@0000008Q>Q00708Q>Q00300000028CX@0R4j400H0R4j42P3o00000`000000
R4j408Q>Q00608Q>Q00300000028CX@0R4j400L0R4j400@0000008Q>Q000000000001@2AI9X00`00
0000TFBJ095TVP08095TVP030000002AI9X0TFBJ00D0TFBJ0`000?l00`3oo`00Yj?A0:NSd@030:NS
d@030000002WXm40Yj?A00L0Yj?A00<000000:NSd@2WXm401`2WXm4010000000Yj?A0:NSd@2WXm44
000000030:FGa`000000YIO700L0YIO7103oo`0^0?ooo`00F03oool00`000000001W000000020000
05D0oooo1000o`020?ooo`<00000100F00000`0000005P0001H00003000000H0FP0/00<0000005X0
;01J02`0101J02`00`000000FP0/05X0;00405X0;0<000001P1h;V@00`000000N2iT07P^I00507P^
I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT000000020000
00@0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00308Q>Q0X0o`000`28CX@00`00
0000R4j408Q>Q00608Q>Q00300000028CX@0R4j400H0R4j40`000008095TVP030000002AI9X0TFBJ
00L0TFBJ00<00000095TVP2AI9X01@2AI9X30000o`030?oo002WXm40Yj?A00@0Yj?A00<000000:NS
d@2WXm401`2WXm400`000000Yj?A0:NSd@060:NSd@@000001P2UUlL00`000000YIO70:FGa`060:FG
a`<0ool0;P3oool005L0oooo0P000000100006L000000000I@00001F0?ooo`@00?l000<0000001H0
00000000100F000400000080FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0;00405X0
;0040000001J02`0FP0/05X0;0<0000000<0N2iT0000001h;V@01@1h;V@00`000000N2iT07P^I006
07P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@3000000H0R4j40P000008
08Q>Q00300000028CX@0R4j400X0o`001P28CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0
R4j400<0R4j40`0000000`2AI9X00000095TVP08095TVP030000002AI9X0TFBJ00L0TFBJ00<00000
095TVP2AI9X01@2AI9X30000o`80ool01@2WXm400`000000Yj?A0:NSd@070:NSd@030000002WXm40
Yj?A00<0Yj?A0`0000000`2UUlL000000:FGa`070:FGa`030000002UUlL0YIO700H0YIO70`3oo`0^
0?ooo`00E`3oool2000000040000I`000000001U000005D0oooo0P000004003o00040000000F0000
5P0001H000<00000101J02`00`000000FP0/05X0;00505X0;0030000001J02`0FP0/00<0FP0/00<0
000005X0;00000000P00000407P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@01P1h
;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT0080N2iT0`0000000`28CX@0000008Q>
Q00408Q>Q080000000<0`@000000000000001`28CX@:0?l0000300000028CX@0R4j400H0R4j400<0
000008Q>Q028CX@01P28CX@00`000000R4j400000003000000@0TFBJ00<00000095TVP2AI9X01`2A
I9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00D0TFBJ0`000?l20?oo00H0Yj?A00<0
00000:NSd@2WXm401`2WXm400`000000Yj?A00000002000000D0YIO700<000000:FGa`2UUlL01P2U
UlL00`000000YIO70:FGa`050:FGa`@0ool0;@3oool005H0oooo0P0000001@0006L0003o0000o`00
0?l0000005<0oooo0`00000201H000<00?l00P0F0003000000H0FP0/00<0000005X0;01J02`0101J
02`00`000000FP0/05X0;00305X0;0<000001`1h;V@00`000000N2iT07P^I00407P^I0030000001h
;V@0N2iT00H0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT00000002000000@0R4j400<0
000008Q>Q028CX@00P28CX@00`0000009`0000000002000000D0R4j42P3o000308Q>Q00300000028
CX@0R4j400H0R4j400<0000008Q>Q028CX@01@28CX@3000000P0TFBJ00<00000095TVP2AI9X01`2A
I9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ0`000?l00`3oo`00Yj?A0:NS
d@040:NSd@030000002WXm40Yj?A00H0Yj?A0`0000080:FGa`030000002UUlL0YIO700H0YIO700<0
00000:FGa`2UUlL01P2UUlL30?oo02d0oooo001F0?ooo`<000000`000?l00`0006D000000?ooo`1>
0?ooo`<0000000<05P000000000F00000`0F0003003o00040000001J02`0FP0/000000D0FP0/00<0
000005X0;01J02`01@1J02`010000000FP0/05X0;01J02`20000000307P^I0000000N2iT00H0N2iT
00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00D0N2iT
0`00000708Q>Q00400000028CX@0R4j408Q>Q0@0000000@0R4j400000028CX@0R4j42P3o000608Q>
Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@00P28CX@300000003095TVP000000TFBJ
00T0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ
00D0TFBJ0`000?l00`3oo`00Yj?A0:NSd@050:NSd@030000002WXm40Yj?A00<0Yj?A0P0000000`2U
UlL000000:FGa`080:FGa`030000002UUlL0YIO700H0YIO700<000000:FGa`2UUlL01P2UUlL40?oo
02`0oooo001E0?ooo`8000000P000:<30000o`800000C03oool3000000805P000P00000301H00080
00001000o`000`1J02`0000005X0;00505X0;0030000001J02`0FP0/00@0FP0/00<0000005X0;000
00000P00000307P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000
N2iT07P^I00507P^I0030000001h;V@0N2iT0080N2iT0`0000000`28CX@0000008Q>Q00708Q>Q003
00000028CX@00000008000000P1o00000`000000R4j40?l000090?l000T0R4j400<0000008Q>Q028
CX@01P28CX@00`000000R4j400000002000000@0TFBJ00<00000095TVP2AI9X0202AI9X00`000000
TFBJ095TVP06095TVP030000002AI9X0TFBJ00P0TFBJ00<00000095TVP2AI9X01@2AI9X30000o`03
0?oo002WXm40Yj?A00D0Yj?A00<000000:NSd@2WXm400`0000040:FGa`030000002UUlL0YIO700L0
YIO700<000000:FGa`2UUlL01P2UUlL00`000000YIO70:FGa`060:FGa`<0ool0;03oool005D0oooo
0P0000020000X`<0003o0P00001:0?ooo`<000000`0F00000`0000005P0001H0000400000080FP0/
1000o`000`000000FP0/05X0;00305X0;0030000001J02`0FP0/00@0FP0/0`00000607P^I0030000
001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000
001h;V@00000008000001028CX@00`000000R4j408Q>Q00608Q>Q0<00000101o00090?l00080R4j4
00<0000008Q>Q028CX@01`28CX@00`000000R4j408Q>Q00508Q>Q0<000001`2AI9X00`000000TFBJ
095TVP08095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X0202AI9X00`000000TFBJ
095TVP05095TVP<0003o00<0ool00:NSd@2WXm401@2WXm43000000L0YIO700<000000:FGa`2UUlL0
1`2UUlL00`000000YIO70:FGa`060:FGa`030000002UUlL0YIO700H0YIO70`3oo`0/0?ooo`00E@3o
ool010000000002S0000X`0000030000o`030000000009`0000004H0oooo1000000401H000@00000
0`1J02`010000000FP0/05X0;01J02`4003o00D0FP0/00@0000005X0;01J02`0FP0/0`0000000`1h
;V@0000007P^I00507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@0101h;V@00`00
0000N2iT07P^I00507P^I0<000001`28CX@00`000000R4j408Q>Q00508Q>Q0<000001@1o00060?l0
00D0R4j400<0000008Q>Q028CX@01`28CX@00`000000R4j408Q>Q00208Q>Q0<0000000<0TFBJ0000
002AI9X0202AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095T
VP2AI9X01`2AI9X00`000000TFBJ095TVP05095TVP<0003o0P3oo`020:NSd@@0000000<0YIO70000
002UUlL0202UUlL00`000000YIO70:FGa`060:FGa`030000002UUlL0YIO700L0YIO700<000000:FG
a`2UUlL01@2UUlL40?oo02/0oooo001E0?ooo`04000000000:<0002S000000<0003o00<000000000
W0000000@`3oool3000000805P0000@0000001H0000F00005P000`00000505X0;0030000001J02`0
FP0/00<0FP0/1000o`0305X0;0030000001J02`0000000800000101h;V@00`000000N2iT07P^I004
07P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I002
07P^I0<0000000<0R4j400000028CX@01`28CX@00`000000R4j408Q>Q00408Q>Q08000000`1o0004
000000<0o`002028CX@00`000000R4j408Q>Q00708Q>Q00300000028CX@0000000800000102AI9X0
0`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01`2AI9X0
0`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00D0TFBJ0`000?l20?oo008000001P2UUlL0
0`000000YIO70:FGa`060:FGa`030000002UUlL0YIO700L0YIO700<000000:FGa`2UUlL01P2UUlL0
0`000000YIO70:FGa`060:FGa`<0ool0:`3oool005H0oooo0P0000030000o`<00000@03oool50000
00805P0000<0000001H0000000000`0000000`1J02`0000005X0;00505X0;0030000001J02`0FP0/
00<0FP0/00<00000003o0000o`000P00o`00101J02`0000000000000000607P^I0030000001h;V@0
N2iT00D0N2iT00<0000007P^I01h;V@01P1h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0
0000008000001028CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400<0R4j40P000000
101o0000000000000000000608d0000300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01P28
CX@3000000L0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP07095TVP030000002A
I9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP05095TVP<0003o0P3o
o`080:FGa`030000002UUlL0YIO700H0YIO700<000000:FGa`2UUlL01`2UUlL00`000000YIO70:FG
a`070:FGa`030000002UUlL0YIO700D0YIO70`3oo`0[0?ooo`00F03oool30000ocl0oooo10000002
01H000030000000F00005P0000@00000101J02`00`000000FP0/05X0;00405X0;0030000001J02`0
FP0/00@0FP0/00<0000005X0;000o`000`00o`000`1h;V@0000007P^I00607P^I0030000001h;V@0
N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00407P^I0<000001`28CX@0
0`000000R4j408Q>Q00608Q>Q00400000028CX@0R4j408Q>Q0D000000`2=0008000000L0R4j400<0
000008Q>Q028CX@00`28CX@300000003095TVP000000TFBJ00P0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X0202A
I9X00`000000TFBJ095TVP04095TVP80003o0`3oo`000`000000YIO70:FGa`060:FGa`030000002U
UlL0YIO700H0YIO700<000000:FGa`2UUlL01`2UUlL00`000000YIO70:FGa`060:FGa`030000002U
UlL0YIO700D0YIO7103oo`0Z0?ooo`00F03oool30000ocd0oooo0`00000401H000030000000F0000
0000008000001`1J02`00`000000FP0/05X0;00405X0;0030000001J02`0FP0/00<0FP0/00@00000
05X0;000000000001000o`000`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00D0N2iT00<0
000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00207P^I080000000<0R4j400000028CX@01`28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400T000001P28CX@00`000000R4j408Q>
Q00608Q>Q00300000028CX@0000000<00000102AI9X00`000000TFBJ095TVP07095TVP030000002A
I9X0TFBJ00H0TFBJ00<00000095TVP2AI9X0202AI9X00`000000TFBJ095TVP06095TVP030000002A
I9X0TFBJ00P0TFBJ00@00000095TVP2AI9X0TFBJ0`0000020000o`<0ool000<000000:FGa`2UUlL0
1P2UUlL00`000000YIO70:FGa`060:FGa`030000002UUlL0YIO700L0YIO700<000000:FGa`2UUlL0
1P2UUlL00`000000YIO70:FGa`060:FGa`<0ool0:P3oool005P0oooo0`000?lj0?ooo`<0000000<0
5P000000000F00000P0F000400000080FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0
;00405X0;0030000001J02`0FP0/00<0FP0/0`00000307P^I0@00?l01`1h;V@00`000000N2iT07P^
I00507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I00000000P00000308Q>Q00300000028
CX@0R4j400H0R4j400<0000008Q>Q028CX@01P28CX@01@000000R4j408Q>Q028CX@0ZK3M00@0R4j4
00<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q0<00000202AI9X00`000000TFBJ
095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X0202AI9X00`000000TFBJ
095TVP06095TVP030000002AI9X0TFBJ00P0TFBJ00@00000095TVP00000000000`2GM:X20000o`<0
ool000<000000:FGa`2UUlL01`2UUlL00`000000YIO70:FGa`060:FGa`030000002UUlL0YIO700H0
YIO700<000000:FGa`2UUlL01`2UUlL00`000000YIO70:FGa`040:FGa`D0ool0:@3oool005P0oooo
0`000?lg0?ooo`<000000P0F0002000000805P000`00000405X0;0030000001J02`0FP0/00D0FP0/
00<0000005X0;01J02`0101J02`00`000000FP0/000000030000000307P^I0000000N2iT00@0N2iT
1000o`0507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@3000000H0R4j4
00<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400H0R4j4
00<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00208Q>Q0<0000000<0TFBJ0000002AI9X0
202AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X0
1`2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ0`00000609MdZP030000
o`3oo`00ool00080ool000<000000:FGa`2UUlL01P2UUlL00`000000YIO70:FGa`060:FGa`030000
002UUlL0YIO700L0YIO700<000000:FGa`2UUlL01P2UUlL00`000000YIO70:FGa`030:FGa`800000
103oo`0Y0?ooo`00F03oool30000ocD0oooo0`00000301H000030000000F00005P0000<000001P1J
02`00`000000FP0/05X0;00405X0;0030000001J02`0FP0/00<0FP0/1000000507P^I0030000001h
;V@0N2iT00@0N2iT0`00o`0507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@00P1h
;V@30000000308Q>Q0000000R4j400H0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>
Q00608Q>Q00400000028CX@0R4j40:V`g@D0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j4
00000002000000@0TFBJ00<00000095TVP2AI9X0202AI9X00`000000TFBJ095TVP06095TVP030000
002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP07095TVP030000
002AI9X0TFBJ00<0TFBJ0`0000000`2GM:X0000009MdZP0609MdZP80003o0`3oo`000`000000YIO7
0:FGa`060:FGa`030000002UUlL0YIO700L0YIO700<000000:FGa`2UUlL01P2UUlL00`000000YIO7
0:FGa`070:FGa`030000002UUlL00000008000000`2RS;`30?oo02T0oooo001H0?ooo`<0003o<`3o
ool20000000301H0000000005P0000805P001000000205X0;0030000001J02`0FP0/00<0FP0/00<0
000005X0;01J02`01@1J02`010000000FP0/05X0;01J02`20000000307P^I0000000N2iT00D0N2iT
00<0000007P^I01h;V@01@1h;V@0100000000?l0003o0000o`0407P^I0030000001h;V@0N2iT00D0
N2iT00<0000007P^I00000000P00000408Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028
CX@01P28CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028
CX@01@28CX@3000000L0TFBJ00<00000095TVP2AI9X0202AI9X00`000000TFBJ095TVP06095TVP03
0000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP07095TVP03
0000002AI9X0000000<00000102GM:X00`000000UgBZ09MdZP0509MdZP80003o0`3oo`000`000000
YIO70:FGa`070:FGa`030000002UUlL0YIO700H0YIO700<000000:FGa`2UUlL01P2UUlL00`000000
YIO70:FGa`050:FGa`@000001P2RS;`40?oo02P0oooo000L0?ooo`800000>P3oool30000oc00oooo
0`00000201H000030000000F00005P0000<00000101J02`00`000000FP0/05X0;00405X0;0030000
001J02`0FP0/00@0FP0/00<0000005X0;00000000P00000307P^I0030000001h;V@0N2iT00@0N2iT
00<0000007P^I01h;V@01@1h;V@00`0000000?l0003o0002003o00<0N2iT00<0000007P^I01h;V@0
101h;V@3000000L0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00608Q>Q0030000
0028CX@0R4j400H0R4j400<0000008Q>Q02Y/=d01P28CX@00`000000R4j408Q>Q00208Q>Q0<00000
00<0TFBJ0000002AI9X0202AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ
00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ00D0TFBJ
0`00000909MdZP030000002GM:X0UgBZ00@0UgBZ0P000?l30?oo00030:FGa`000000YIO700L0YIO7
00<000000:FGa`2UUlL01P2UUlL00`000000YIO70:FGa`070:FGa`030000002UUlL0YIO700@00000
0P2RS;`00`000000XXbl0::<_0060::<_0<0ool0:03oool001d0oooo1000000g0?ooo`<0003o;03o
ool5000000<05P0000<0000001H0000000000P00000605X0;0030000001J02`0FP0/00<0FP0/00<0
000005X0;01J02`0101J02`3000000D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^
I00507P^I0030000001h;V@00?l000<00?l000<0N2iT0000001h;V@00`1h;V@30000000308Q>Q000
0000R4j400L0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00608Q>Q00300000028
CX@0R4j400H0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j400000002000000@0TFBJ00<0
0000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ0080TFBJ0`00
00000`2GM:X0000009MdZP0909MdZP030000002GM:X0UgBZ00@0UgBZ0`000?l30?oo00030000002U
UlL0YIO700L0YIO700<000000:FGa`2UUlL01P2UUlL00`000000YIO70:FGa`050:FGa`@000001`2R
S;`00`000000XXbl0::<_0050::<_0<0ool0:03oool001d0oooo1P00000d0?ooo`<0003o:@3oool4
000000805P0000<0000001H0000F00000P0F000300000080FP0/00<0000005X0;01J02`00`1J02`0
0`000000FP0/05X0;00405X0;0040000001J02`0FP0/05X0;0<0000000<0N2iT0000001h;V@01@1h
;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@01000
o`000`000000N2iT00000002000000@0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>
Q00508Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>
Q00508Q>Q0<000001`2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00P0TFBJ00<0
0000095TVP0000000P00000409MdZP030000002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X0102G
M:X30000o`<0ool000<0YIO70000002UUlL01`2UUlL00`000000YIO70:FGa`060:FGa`030000002U
UlL0YIO700<0YIO70P0000000`2RS;`000000::<_0080::<_0030000002RS;`0XXbl00D0XXbl103o
o`0W0?ooo`007P3oool800000340oooo0`000?lW0?ooo`<00000100F0000100000005P0001H0000F
0003000000<0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0;00305X0;0030000001J
02`0000000800000101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT00@0N2iT00<0
000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00207P^I0@00?l000<0000008Q>Q028CX@01@28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j40080R4j40`0000000`2AI9X00000095T
VP08095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095T
VP07095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X3000000P0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0409MdZP<0003o0`3oo`000`2UUlL000000:FG
a`080:FGa`030000002UUlL0YIO700H0YIO700<000000:FGa`0000000P0000040::<_0030000002R
S;`0XXbl00H0XXbl00<000000::<_02RS;`01P2RS;`30?oo02L0oooo000N0?ooo`80000000@00;80
00000000[00000000P00MP03000002h0oooo0`000?lT0?ooo`<0000000<05P000000000F00000P0F
00000`0000005P0000000004000000D0FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/05X0
;00305X0;0<000001P1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00@0N2iT00<0
000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00207P^I00300000000o`000?l000800?l01`28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0000000800000102AI9X00`000000TFBJ095T
VP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095T
VP07095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X00`2AI9X30000000309MdZP00
0000UgBZ00P0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0309MdZP<0003o0`3o
o`000`2UUlL000000:FGa`080:FGa`030000002UUlL0YIO700D0YIO70`0000070::<_0030000002R
S;`0XXbl00L0XXbl00<000000::<_02RS;`01@2RS;`30?oo02L0oooo000O0?ooo`80000000<00;80
00000000[0000P000003001f00800000;03oool30000ob40oooo0`00000201H0008000000P0F0004
000000@0FP0/00<0000005X0;01J02`00P1J02`00`000000FP0/05X0;00405X0;0040000001J02`0
FP0/05X0;080000000<0N2iT0000001h;V@01P1h;V@00`000000N2iT07P^I00407P^I0030000001h
;V@0N2iT00D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT0000000200000080R4j41000
o`0608Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>
Q00608Q>Q00300000028CX@0R4j400D0R4j40`000007095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01`2AI9X00`000000TFBJ00000003000000@0UgBZ00<0000009MdZP2GM:X01`2G
M:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00<0UgBZ0`000?l40?oo00030:FGa`00
0000YIO700P0YIO700<000000:FGa`2UUlL0100000000`2RS;`000000::<_0070::<_0030000002R
S;`0XXbl00L0XXbl00<000000::<_02RS;`01@2RS;`30?oo02L0oooo000O0?ooo`0500000000U`00
0000002b000000000P00[0020000008007H000<000000?ooo`3oool0:P3oool30000oal0oooo0`00
000301H000030000000F00005P0000<000001P1J02`00`000000FP0/05X0;00305X0;0030000001J
02`0FP0/00<0FP0/00<0000005X0;00000000P00000307P^I0030000001h;V@0N2iT00D0N2iT00<0
000007P^I01h;V@0101h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00@0N2iT0`00
000608Q>Q0@00?l01@28CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0
000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00208Q>Q0<0000000<0TFBJ0000002AI9X0202A
I9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ00D0TFBJ0`00000909MdZP030000002G
M:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0309MdZP<0003o00H0
UgBZ0?oo003oo`00ool00:FGa`0000080:FGa`@000001P2RS;`00`000000XXbl0::<_0060::<_003
0000002RS;`0XXbl00H0XXbl00<000000::<_02RS;`01@2RS;`40?oo02H0oooo000P0?ooo`800000
0P00/P00100000000:`0002/0000[003000002`0oooo0`000?lM0?ooo`80000000<05P000000000F
00000P0F000400000080FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/05X0;00305X0;003
0000001J02`0FP0/00<0FP0/0`00000507P^I0030000001h;V@0N2iT00H0N2iT00<0000007P^I01h
;V@0101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT0080N2iT0`0000000`28CX@0
000008Q>Q00608Q>Q00300000000o`000?l000800?l01028CX@00`000000R4j408Q>Q00608Q>Q003
00000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j400000002000000@0
TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00L0
TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP08095TVP030000002AI9X0TFBJ0080
TFBJ0`0000000`2GM:X0000009MdZP0909MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2G
M:X01`2GM:X00`000000UgBZ09MdZP0309MdZP<0003o00H0UgBZ0?oo003oo`00ool00:FGa`000005
0:FGa`<0000000<0XXbl0000002RS;`01`2RS;`00`000000XXbl0::<_0060::<_0030000002RS;`0
XXbl00L0XXbl00<000000::<_02RS;`01@2RS;`30?oo02H0oooo000P0?ooo`0300000000U`000000
00800;800P000003002/00030000003oool0oooo02X0oooo0`000?lJ0?ooo`<0000000<05P000000
000000000P0F0003000000@0FP0/00<0000005X0;01J02`0101J02`00`000000FP0/05X0;00305X0
;0040000001J02`0FP0/05X0;080000000<0N2iT0000001h;V@01@1h;V@00`000000N2iT07P^I005
07P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT00000002
000000@0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j4003o0002003o00@0R4j400<00000
08Q>Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0R4j40`000007
095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07
095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ00000002
000000@0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0
UgBZ00P0UgBZ00<0000009MdZP2GM:X00P2GM:X30000o`0409MdZP3oo`00ool00?oo0080YIO700<0
00000:FGa`0000000P0000050::<_0030000002RS;`0XXbl00D0XXbl00<000000::<_02RS;`01P2R
S;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00D0XXbl0`3oo`0V0?ooo`008@3oool0
0`00000009L000000003002b000400000000[0000:`0000002`0oooo0`000?l@0?ooo`030?oo003o
ool0oooo00<0oooo1@00000201H000030000000F00005P0000<000001P1J02`00`000000FP0/05X0
;00305X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;00000000P00000307P^I0030000001h
;V@0N2iT00@0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000001h
;V@0N2iT00<0N2iT0`00000708Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@00`00
o`0308Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>
Q00208Q>Q0<0000000<0TFBJ0000002AI9X0202AI9X00`000000TFBJ095TVP06095TVP030000002A
I9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002A
I9X0TFBJ00H0TFBJ0`00000809MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2G
M:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00<0UgBZ0`000?l40?oo00<00000202R
S;`00`000000XXbl0::<_0060::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02RS;`01`2R
S;`00`000000XXbl0::<_0040::<_0@0ool09@3oool00240oooo00@00000002G0000U`0000000P00
/P03003o02d0oooo0`000?l?0?ooo`<0ool01000000201H000040000000F00005P0001H000@00000
0P1J02`00`000000FP0/05X0;00305X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;01J02`0
0`1J02`3000000D0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000
001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@00P1h;V@20000000308Q>Q0000000R4j400L0R4j4
00<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q003003o00<0R4j400<0000008Q>Q028CX@0
1P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0000000800000102AI9X00`000000TFBJ
095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ
095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X00`2AI9X30000000309Md
ZP000000UgBZ00P0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X00`2GM:X30000o`0609MdZP3oo`00ool00?oo002R
S;`000002@2RS;`00`000000XXbl0::<_0060::<_0030000002RS;`0XXbl00H0XXbl00<000000::<
_02RS;`01`2RS;`00`000000XXbl0::<_0050::<_0<0ool09@3oool00280oooo00@00000002G0000
00000;801@00o`0[0?ooo`<0003o3P3oool30?oo00<00000100F00000`0000005P0001H000030000
00@0FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/05X0;00405X0;0030000001J02`00000
00<0000000<0N2iT0000001h;V@01@1h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT
00H0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT00000002000000<0R4j400<0000008Q>
Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q00500000028CX@0R4j408Q>Q000o`001028CX@0
0`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400@0R4j40`000007095TVP030000002AI9X0
TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0
TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ00000003000000@0UgBZ00<00000
09MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00L0UgBZ00<00000
09MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0309MdZP<0003o00@0UgBZ0?oo003oo`00ool00P2R
S;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00D0XXbl00<000000::<_02RS;`01P2R
S;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00D0XXbl0`3oo`0U0?ooo`008P3oool0
1P00000009L0002G000000000;80000000@00?l0:P3oool30000o`X0oooo1@3oo`020000000301H0
000000005P0000805P001P00000605X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;01J02`0
0P1J02`4000000D0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I00407P^I0030000
001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@3000000H0R4j400<0000008Q>Q028CX@0
1P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@0
1P28CX@00`000000R4j408Q>Q00208Q>Q080000000<0TFBJ0000002AI9X0202AI9X00`000000TFBJ
095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ
095TVP07095TVP030000002AI9X0TFBJ00D0TFBJ0`00000909MdZP030000002GM:X0UgBZ00H0UgBZ
00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00P0UgBZ
00<0000009MdZP2GM:X00P2GM:X30000o`0409MdZP3oo`00ool00?oo0080XXbl00<000000::<_02R
S;`01`2RS;`00`000000XXbl0::<_0060::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02R
S;`01`2RS;`00`000000XXbl0::<_0040::<_0@0ool0903oool002<0oooo100000020?ooo`@00?l0
:@3oool30000o`T0oooo1P3oo`000`0F000000000000000201H000<00000101J02`00`000000FP0/
05X0;00305X0;0030000001J02`0FP0/00<0FP0/00@0000005X0;01J02`0FP0/0P0000000`1h;V@0
000007P^I00507P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@00`000000
N2iT07P^I00507P^I0030000001h;V@0N2iT00@0000000<0R4j400000028CX@01P28CX@00`000000
R4j408Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28CX@00`000000
R4j408Q>Q00608Q>Q00300000028CX@00000008000000`2AI9X00`000000TFBJ095TVP07095TVP03
0000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP03
0000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X00P2AI9X30000000309MdZP000000UgBZ00T0
UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00L0
UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0209MdZP<0003o00<0UgBZ0?oo003o
o`000P3oo`000`2RS;`000000::<_0080::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02R
S;`01P2RS;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00D0XXbl0`3oo`0T0?ooo`00
:P3oool4003o02P0oooo0`000?l80?ooo`L0ool000<0000001H0000F00000`00000505X0;0030000
001J02`0FP0/00<0FP0/00<0000005X0;01J02`0101J02`4000000<0N2iT00<0000007P^I01h;V@0
101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0
101h;V@4000000D0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q0030000
0028CX@0R4j400H0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q0<00000
1P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X0
1`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP000000
0P00000409MdZP030000002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ
09MdZP0809MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ
09MdZP0209MdZP<0003o0P2GM:X30?oo0080XXbl00<000000::<_02RS;`01`2RS;`00`000000XXbl
0::<_0060::<_0030000002RS;`0XXbl00D0XXbl00<000000::<_02RS;`01`2RS;`00`000000XXbl
0::<_0050::<_0<0ool0903oool002/0oooo1000o`0W0?ooo`<0003o1`3oool50?oo00805P001000
000205X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/05X0
;00205X0;0<000001@1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00@0N2iT00<0
000007P^I01h;V@0101h;V@00`000000N2iT07P^I00207P^I0<0000000<0R4j400000028CX@01P28
CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j40080R4j40`0000000`2AI9X00000095T
VP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095T
VP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01@2AI9X3000000P0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00P0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ0080UgBZ0`00
0?l209MdZP<0ool00P2RS;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00H0XXbl00<0
00000::<_02RS;`01P2RS;`00`000000XXbl0::<_0070::<_0030000002RS;`0XXbl00@00000103o
o`0S0?ooo`00;03oool4003o02H0oooo0`000?l60?ooo`@0ool00P0F0003000000@0FP0/00<00000
05X0;01J02`00`1J02`00`000000FP0/05X0;00305X0;0040000001J02`0FP0/05X0;080000000<0
N2iT0000001h;V@01@1h;V@00`000000N2iT07P^I00507P^I0030000001h;V@0N2iT00@0N2iT00<0
000007P^I01h;V@0101h;V@00`000000N2iT00000002000000@0R4j400<0000008Q>Q028CX@01@28
CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28
CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0000000800000102AI9X00`000000TFBJ095T
VP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095T
VP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X00P2AI9X30000000309MdZP00
0000UgBZ00P0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP040000002G
M:X0UgBZ09MdZP<0003o0P0000040?oo00030::<_0000000XXbl00P0XXbl00<000000::<_02RS;`0
1P2RS;`00`000000XXbl0::<_0060::<_0030000002RS;`0XXbl00H0XXbl1000000509j0/P<0ool0
8`3oool002d0oooo1000o`0U0?ooo`<0003o1@3oool40?oo000401H0000000000000000000H0FP0/
00<0000005X0;01J02`00`1J02`00`000000FP0/05X0;00305X0;0@000000`1h;V@00`000000N2iT
07P^I00407P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@01@1h;V@00`000000N2iT
07P^I00307P^I0<000001`28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0R4j4
00<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400@0R4j4
10000007095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ
095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ
00000002000000@0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP030000
002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000
002GM:X0UgBZ00P0UgBZ00@0000009MdZP00000000000`000?l309b3^0<0ool00P2RS;`00`000000
XXbl0::<_0070::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02RS;`01@2RS;`00`000000
XXbl0::<_0030::<_0<0000000<0WX2b0000002NP;801P2NP;840?oo0280oooo000^0?ooo`D00?l0
8`3oool30000o`@0oooo0`3oo`0300000080FP0/00<0000005X0;01J02`00`1J02`00`000000FP0/
05X0;00305X0;0030000001J02`0FP0/0080FP0/0`00000507P^I0030000001h;V@0N2iT00D0N2iT
00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT0080N2iT
0P0000000`28CX@0000008Q>Q00708Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@0
1@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@0
10000002095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ
095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ
095TVP05095TVP<00000202GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00P0UgBZ
00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00H0UgBZ
00<0000009MdZP2GM:X01`2GM:X300000080W8>h0`000?l309b3^0<0ool00P2RS;`00`000000XXbl
0::<_0070::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02RS;`01P2RS;`00`000000XXbl
00000002000000D0WX2b00<0000009j0/P2NP;801@2NP;830?oo0280oooo000_0?ooo`D00?l08P3o
ool30000o`<0oooo103oo`0405X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;01J02`0101J
02`50000000307P^I0000000N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^
I00507P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I00000000P00000308Q>Q00300000028
CX@0R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q00300000028
CX@0R4j400D0R4j400<0000008Q>Q028CX@01@28CX@4000000H0TFBJ00<00000095TVP2AI9X01`2A
I9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ0080TFBJ0`0000000`2GM:X0000009Md
ZP0809MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09Md
ZP0709MdZP030000002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09Md
ZP0309MdZP<0000000<0W8>h0000002LPkP00P2LPkP30000o`<0W8>h103oo`000`2RS;`000000::<
_0080::<_0030000002RS;`0XXbl00H0XXbl00<000000::<_02RS;`01@2RS;`3000000P0WX2b00<0
000009j0/P2NP;801@2NP;830?oo0280oooo000a0?ooo`@00?l08@3oool30000o`80oooo103oo`05
05X0;0030000001J02`0FP0/00<0FP0/00<0000005X0;01J02`00P1J02`3000000D0N2iT00<00000
07P^I01h;V@0101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT00D0N2iT00<00000
07P^I01h;V@00`1h;V@3000000H0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q004
08Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q002
08Q>Q0<0000000<0TFBJ0000002AI9X01`2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0
TFBJ00D0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0
TFBJ00L0TFBJ00<00000095TVP0000000P00000409MdZP030000002GM:X0UgBZ00L0UgBZ00<00000
09MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00H0UgBZ00<00000
09MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0000000<000001@2LPkP0
0`000000W8>h09b3^0030000o`@0W8>h0`3oo`020::<_0030000002RS;`0XXbl00L0XXbl00<00000
0::<_02RS;`01P2RS;`00`000000XXbl0::<_0040000000309j0/P000000WX2b00P0WX2b00<00000
09j0/P2NP;801@2NP;840?oo0240oooo000b0?ooo`@00?l07`3oool30000o`<0oooo103oo`0405X0
;0030000001J02`0FP0/00<0FP0/00@0000005X0;01J02`0FP0/0P0000000`1h;V@0000007P^I004
07P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I004
07P^I0030000001h;V@0N2iT0080N2iT0P0000000`28CX@0000008Q>Q00608Q>Q00300000028CX@0
R4j400H0R4j400<0000008Q>Q028CX@01028CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0
R4j400D0R4j400<0000008Q>Q00000000P000004095TVP030000002AI9X0TFBJ00H0TFBJ00<00000
095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000
095TVP2AI9X01`2AI9X00`000000TFBJ095TVP05095TVP<00000202GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP07
09MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X3000000T0W8>h00<00000
09b3^02LPkP00`000?l409b3^0<0ool00P2RS;`00`000000XXbl0::<_0070::<_0030000002RS;`0
XXbl00D0XXbl1000000609j0/P030000002NP;80WX2b00H0WX2b00<0000009j0/P2NP;801P2NP;83
0?oo0240oooo000c0?ooo`@00?l07P3oool30000o`80oooo103oo`0405X0;0030000001J02`0FP0/
00@0FP0/1000000207P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`00
0000N2iT07P^I00507P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I00000000P00000308Q>
Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00408Q>
Q00300000028CX@0R4j400H0R4j400<0000008Q>Q028CX@01028CX@3000000L0TFBJ00<00000095T
VP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095T
VP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ0080TFBJ0`0000000`2G
M:X0000009MdZP0809MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`00
0000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X0202GM:X00`00
0000UgBZ09MdZP0209MdZP<0000000<0W8>h0000002LPkP02@2LPkP00`000000W8>h09b3^0030000
o`@0W8>h103oo`000`2RS;`000000::<_0080::<_0030000002RS;`0XXbl00<0XXbl0P0000000`2N
P;80000009j0/P0709j0/P030000002NP;80WX2b00L0WX2b00<0000009j0/P2NP;801@2NP;830?oo
0240oooo000d0?ooo`@00?l07@3oool30000o`80oooo0`3oo`0505X0;0030000001J02`0FP0/0080
FP0/0`00000507P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`000000
N2iT07P^I00407P^I0030000001h;V@0N2iT00@0N2iT0`00000608Q>Q00300000028CX@0R4j400D0
R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400H0
R4j400<0000008Q>Q028CX@00P28CX@200000003095TVP000000TFBJ00L0TFBJ00<00000095TVP2A
I9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2A
I9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0000000800000102GM:X00`000000
UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000
UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000
UgBZ00000002000000D0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^0030000o`@0
W8>h0`3oo`020::<_0030000002RS;`0XXbl00L0XXbl00<000000::<_00000000P00000409j0/P03
0000002NP;80WX2b00D0WX2b00<0000009j0/P2NP;801`2NP;800`000000WX2b09j0/P0509j0/P@0
ool0803oool003D0oooo1000o`0L0?ooo`<0003o00<0oooo0?oo003oo`000P3oo`0405X0;0040000
001J02`0FP0/05X0;080000000<0N2iT0000001h;V@01@1h;V@00`000000N2iT07P^I00407P^I003
0000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I00400000003
08Q>Q0000000R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q003
00000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j400000002000000<0
TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0
TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00D0
TFBJ0`00000809MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000
UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000
UgBZ09MdZP0709MdZP<00000202LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00<0
003o102LPkP30?oo0080XXbl00<000000::<_02RS;`01P2RS;`3000000L0WX2b00<0000009j0/P2N
P;801@2NP;800`000000WX2b09j0/P0709j0/P030000002NP;80WX2b00H0WX2b0`3oo`0P0?ooo`00
=P3oool4003o01/0oooo0`000?l0103oool0ool00?oo003oo`0505X0;0@000000P1h;V@00`000000
N2iT07P^I00507P^I0030000001h;V@0N2iT00<0N2iT00<0000007P^I01h;V@01@1h;V@00`000000
N2iT07P^I00307P^I0@000001@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0
R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0
R4j40`000006095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000
TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000
TFBJ095TVP02095TVP<0000000<0UgBZ0000002GM:X0202GM:X00`000000UgBZ09MdZP0609MdZP03
0000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0809MdZP03
0000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X00`2GM:X30000000309b3^0000000W8>h00P0
W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^0030000o`@0W8>h0`3oo`020::<_003
0000002RS;`0XXbl00<0XXbl0`0000000`2NP;80000009j0/P0709j0/P030000002NP;80WX2b00H0
WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b09j0/P0609j0/P<0ool0803oool003L0oooo
1@00o`0I0?ooo`<0003o00@0oooo0?oo003oo`00ool00`1J02`3000000D0N2iT00<0000007P^I01h
;V@0101h;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h
;V@00P1h;V@20000000308Q>Q0000000R4j400H0R4j400<0000008Q>Q028CX@01@28CX@00`000000
R4j408Q>Q00508Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01@28CX@00`000000
R4j408Q>Q00208Q>Q0<0000000<0TFBJ0000002AI9X01P2AI9X00`000000TFBJ095TVP07095TVP03
0000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP06095TVP03
0000002AI9X0TFBJ00L0TFBJ00<00000095TVP0000000P00000409MdZP030000002GM:X0UgBZ00L0
UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0
UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0000000<0
00001@2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3^000
0?l00P000?l409b3^0@0ool00P2RS;`00`000000XXbl00000002000000D0WX2b00<0000009j0/P2N
P;801@2NP;800`000000WX2b09j0/P0609j0/P030000002NP;80WX2b00L0WX2b00<0000009j0/P2N
P;801@2NP;830?oo0200oooo000h0?ooo`D00?l0603oool30000o`<0ool0100000000`1h;V@00000
07P^I00507P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT
07P^I00407P^I0030000001h;V@00000008000000P28CX@00`3oool0000008Q>Q00608Q>Q0030000
0028CX@0R4j400D0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q0030000
0028CX@0R4j400D0R4j400<0000008Q>Q00000000P000004095TVP030000002AI9X0TFBJ00H0TFBJ
00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ
00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP05095TVP<00000202GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X3000000T0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0003o0080003o
1@2LPkP30?oo00040::<_00000000000000000P0WX2b00<0000009j0/P2NP;801P2NP;800`000000
WX2b09j0/P0509j0/P030000002NP;80WX2b00L0WX2b00<0000009j0/P2NP;801@2NP;830?oo0200
oooo000j0?ooo`@00?l05`3oool20000o`<0ool000<0000007P^I01h;V@00P1h;V@00`000000N2iT
07P^I00407P^I0030000001h;V@0N2iT00D0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT
07P^I00307P^I0<000001P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400@0R4j4
00<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400@0R4j4
0`000007095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ
095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ
095TVP02095TVP<0000000<0UgBZ0000002GM:X0202GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000
002GM:X0UgBZ00P0UgBZ00<0000009MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h00T0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0003o0080003o
1@2LPkP30?oo00030000002NP;80000000T0WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b
09j0/P0509j0/P030000002NP;80WX2b00L0WX2b00<0000009j0/P2NP;801@2NP;830?oo0200oooo
000k0?ooo`@00?l05P3oool20000o`<0ool01@1h;V@00`000000N2iT07P^I00407P^I0030000001h
;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I00207P^I080000000<0
R4j400000028CX@01028CX@00`3oool0R4j40000000708Q>Q00300000028CX@0R4j400@0R4j400<0
000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j40080R4j40P00
00000`2AI9X00000095TVP07095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ00000002000000@0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09Md
ZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09Md
ZP0709MdZP030000002GM:X0UgBZ00P0UgBZ00<0000009MdZP0000000P00000509b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00809b3^00500000000
0?l0003o0000o`000000102LPkP40?oo0080WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b
09j0/P0609j0/P030000002NP;80WX2b00H0WX2b00<0000009j0/P2NP;801`2NP;800`000000WX2b
09j0/P0509j0/P<0ool07`3oool003`0oooo1000o`0D0?ooo`80003o103oo`0507P^I0030000001h
;V@0N2iT00@0N2iT00<0000007P^I01h;V@0101h;V@00`000000N2iT07P^I00407P^I0030000001h
;V@00000008000000P28CX@00`3oool0000008Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0
000008Q>Q028CX@01028CX@00`000000R4j408Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0
000008Q>Q00000000P000003095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01@2A
I9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2A
I9X00`000000TFBJ095TVP05095TVP<00000202GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0809MdZP030000002G
M:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X3000000P0W8>h00<0000009b3^02LPkP0202L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h0`0000030000o`<000000`2L
PkP30?oo0080WX2b00<0000009j0/P2NP;801`2NP;800`000000WX2b09j0/P0509j0/P030000002N
P;80WX2b00H0WX2b00<0000009j0/P2NP;801`2NP;800`000000WX2b09j0/P0509j0/P<0ool07`3o
ool003d0oooo1000o`0C0?ooo`80003o0`3oo`0507P^I0030000001h;V@0N2iT00D0N2iT00<00000
07P^I01h;V@0101h;V@00`000000N2iT07P^I00307P^I0<000001P28CX@00`000000R4j408Q>Q002
08Q>Q0040?ooo`28CX@0R4j4000000H0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>
Q00608Q>Q00300000028CX@0R4j400@0R4j40`000006095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01@2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00L0TFBJ00<0
0000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP02095TVP<0000000<0UgBZ0000002GM:X0202G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2G
M:X00`000000UgBZ09MdZP0809MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X00`2G
M:X30000000309b3^0000000W8>h00P0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3
^00709b3^0030000002LPkP0W8>h00D0W8>h00@000000000W`0009l000000`0009`00`000000002I
0000V@020000000409b3^03oo`00ool00?oo0080WX2b00<0000009j0/P2NP;801`2NP;800`000000
WX2b09j0/P0609j0/P030000002NP;80WX2b00D0WX2b00<0000009j0/P2NP;801`2NP;800`000000
WX2b09j0/P0509j0/P<0ool07`3oool003h0oooo1000o`0B0?ooo`80003o0`3oo`0507P^I0030000
001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@01@1h;V@010000000N2iT07P^I01h;V@200000003
08Q>Q0000000R4j400@0R4j400<0oooo08Q>Q00000001`28CX@00`000000R4j408Q>Q00408Q>Q003
00000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01P28CX@00`000000R4j408Q>Q00208Q>Q080
000000<0TFBJ0000002AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00D0
TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP07095TVP030000002AI9X0TFBJ00H0
TFBJ00<00000095TVP0000000P00000409MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2G
M:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2G
M:X01`2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0000000<000001@2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000
W8>h09b3^00409b3^0050000000009l0002O0000W`0000000P0009`01P000000002I0000V@0009T0
000009b3^0@0ool000<0WX2b0000002NP;80202NP;800`000000WX2b09j0/P0609j0/P030000002N
P;80WX2b00H0WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b09j0/P0509j0/P<0ool07`3o
ool003l0oooo1@00o`0@0?ooo`<0003o0P3oo`0507P^I0030000001h;V@0N2iT00@0N2iT00<00000
07P^I01h;V@0101h;V@00`000000N2iT00000002000000<0R4j400<0000008Q>Q028CX@01@28CX@0
1@000000R4j408Q>Q028CX@0oooo00<0R4j400<0000008Q>Q028CX@01028CX@00`000000R4j408Q>
Q00508Q>Q00300000028CX@0R4j400H0R4j400<0000008Q>Q00000000P000003095TVP030000002A
I9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000002A
I9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP04095TVP@00000202G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2G
M:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2G
M:X3000000T0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP0102LPkP200000080002O00@000000000W00009`00000
0`0009T00`000000W8>h09b3^0030?oo0080WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b
09j0/P0609j0/P030000002NP;80WX2b00H0WX2b00<0000009j0/P2NP;801`2NP;800`000000WX2b
09j0/P04000000<0ool07`3oool00400oooo1@00o`0?0?ooo`<0003o00<0ool007P^I01h;V@0101h
;V@00`000000N2iT07P^I00407P^I0030000001h;V@0N2iT00<0N2iT0`00000608Q>Q00300000028
CX@0R4j40080R4j400@0oooo08Q>Q028CX@000001P28CX@00`000000R4j408Q>Q00508Q>Q0030000
0028CX@0R4j400D0R4j400<0000008Q>Q028CX@01028CX@4000000H0TFBJ00<00000095TVP2AI9X0
1P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0
1`2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00@000000P2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ
09MdZP0209MdZP<0000000<0W8>h0000002LPkP02@2LPkP00`000000W8>h09b3^00709b3^0030000
002LPkP0W8>h00P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00409b3^0800000
0P0009l010000000002L0000W00000020000V@8000000P2LPkP30?oo0080WX2b00<0000009j0/P2N
P;801`2NP;800`000000WX2b09j0/P0609j0/P030000002NP;80WX2b00D0WX2b00<0000009j0/P2N
P;801P2NP;84000000@0VWBV0`3oo`0O0?ooo`00@P3oool4003o00h0oooo0`000?l00`3oo`00N2iT
07P^I00307P^I0030000001h;V@0N2iT00@0N2iT00<0000007P^I01h;V@0100000000`28CX@00000
08Q>Q00608Q>Q0X0000000<0R4j40?ooo`28CX@00P28CX@00`000000R4j408Q>Q00508Q>Q0030000
0028CX@0R4j400D0R4j400<0000008Q>Q028CX@010000002095TVP030000002AI9X0TFBJ00D0TFBJ
00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ
00<00000095TVP2AI9X01`2AI9X00`000000TFBJ095TVP05095TVP@000001P2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0202GM:X00`000000UgBZ
00000002000000D0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000
002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00309b3^0050000
0000084000000000W`0000000P0009`010000000002I0000V@00000309b3^0@0ool000<0WX2b0000
002NP;80202NP;800`000000WX2b09j0/P0609j0/P030000002NP;80WX2b00D0WX2b00<0000009j0
/P2NP;800`2NP;830000000309YdYP000000VWBV00D0VWBV103oo`0N0?ooo`00@`3oool4003o00d0
oooo0`000?l00`3oo`00N2iT07P^I00307P^I0030000001h;V@0N2iT00<0N2iT1000000508Q>Q003
00000028CX@0R4j400D0R4j42@00000608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028
CX@01028CX@4000000H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP03
0000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095TVP07095TVP03
0000002AI9X0TFBJ0080TFBJ0`0000000`2GM:X0000009MdZP0809MdZP030000002GM:X0UgBZ00H0
UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0
UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP<00000202LPkP00`000000
W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00809b3^0030000002LPkP0W8>h00@0W8>h0P0000001@0009l000000000W00009`00000
0080002I00@0000009b3^02LPkP0W8>h103oo`0209j0/P030000002NP;80WX2b00H0WX2b00<00000
09j0/P2NP;801P2NP;800`000000WX2b09j0/P0609j0/P030000002NP;80000000800000102JM:H0
0`000000VWBV09YdYP0509YdYP<0ool07P3oool004@0oooo1000o`0<0?ooo`<0003o1P1h;V@01000
0000N2iT07P^I01h;V@20000000308Q>Q0000000R4j400H0R4j400<0000008Q>Q028CX@00`28CX@4
0?l000<0000000<0]P000000000000000P28CX@00`3oool0R4j408Q>Q00208Q>Q00300000028CX@0
R4j400D0R4j400<0000008Q>Q028CX@00P28CX@200000003095TVP000000TFBJ00L0TFBJ00<00000
095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00H0TFBJ00<00000
095TVP2AI9X01P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0000000800000102GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X0
0`000000UgBZ09MdZP0309MdZP<0000000<0W8>h0000002LPkP0202LPkP00`000000W8>h09b3^008
09b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^007
09b3^0030000002LPkP0W8>h00@0W8>h0P0000020000W`030000000009`000000080002I00@00000
09b3^00000000000103oo`0209j0/P030000002NP;80WX2b00L0WX2b00<0000009j0/P2NP;801@2N
P;800`000000WX2b09j0/P0509j0/P<00000202JM:H00`000000VWBV09YdYP0409YdYP<0ool07P3o
ool004D0oooo1000o`0;0?ooo`<0003o1@1h;V@00`000000N2iT00000002000000<0R4j400<00000
08Q>Q028CX@01@28CX@00`000000R4j408Q>Q0070?l00080]P000P0000000`28CX@0000008Q>Q006
08Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q00000000P000003095TVP030000002AI9X0
TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0
TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP<00000202GM:X0
0`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X0
0`000000UgBZ00000003000000D0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^008
09b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^008
09b3^0030000002LPkP0W8>h00@0W8>h0P0000001@0009l000000000W0000000002I00<000000`2O
T<@40?oo000309j0/P000000WX2b00P0WX2b00<0000009j0/P2NP;801P2NP;800`000000WX2b09j0
/P040000000309YdYP000000VWBV00P0VWBV00<0000009YdYP2JM:H0102JM:H40?oo01d0oooo0016
0?ooo`@00?l02@3oool30000o`030?oo001h;V@0N2iT0080N2iT0`00000608Q>Q00300000028CX@0
R4j400D0R4j42P3o0002000000<0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q004
08Q>Q0<000001P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000
095TVP2AI9X01@2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000
095TVP2AI9X00P2AI9X30000000309MdZP000000UgBZ00P0UgBZ00<0000009MdZP2GM:X01P2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00@0UgBZ1000000909b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00409b3^080000000H0002O
0000000009`000000000V@00000609n@a0<0ool00P2NP;800`000000WX2b09j0/P0609j0/P030000
002NP;80WX2b00D0WX2b1000000509YdYP030000002JM:H0VWBV00L0VWBV00<0000009YdYP2JM:H0
1@2JM:H30?oo01d0oooo00170?ooo`@00?l0203oool30000o`030?oo0000000000000080000000<0
R4j400000028CX@01P28CX@00`000000R4j408Q>Q00208Q>Q0X0o`0000<0000008Q>Q00000001@28
CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j40080R4j40P0000000`2AI9X00000095T
VP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095T
VP05095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ0000
0002000000@0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01000000209b3^0030000002LPkP0W8>h00P0W8>h00<0
000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0
000009b3^02LPkP0202LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00@0W8>h1000
0000100009`000000000V@00000609n@a0<0ool00P2NP;800`000000WX2b09j0/P0609j0/P030000
002NP;80WX2b00<0WX2b0P0000000`2JM:H0000009YdYP0709YdYP030000002JM:H0VWBV00H0VWBV
00<0000009YdYP2JM:H01@2JM:H30?oo01d0oooo00180?ooo`D00?l01P3oool30000o`0300000028
CX@0R4j400<0R4j400<0000008Q>Q028CX@01@28CX@00`000000R4j40?l000090?l000<0R4j400<0
000008Q>Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@00000008000000`2A
I9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2A
I9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00L0TFBJ00<00000095TVP2AI9X0102A
I9X3000000P0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP030000002G
M:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00H0UgBZ1000000709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00809b3^0030000002LPkP0000000<0000000@0Wi34000000000000002O
0P0000000`0009T0000009n@a00509n@a0@0ool000<0WX2b0000002NP;80202NP;800`000000WX2b
00000002000000<0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0709YdYP030000
002JM:H0VWBV00@0VWBV0`3oo`0M0?ooo`00B@3oool5003o00D0oooo0`000?l608Q>Q00300000028
CX@0R4j400@0R4j42P3o000608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@01028
CX@3000000H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000002A
I9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095TVP07095TVP030000002A
I9X0TFBJ0080TFBJ0P0000000`2GM:X0000009MdZP0809MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0209MdZP<0000000<0W8>h0000002LPkP0202L
PkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2L
PkP3000000H0Wi341P00000709n@a0<0ool000<0WX2b0000002NP;801P2NP;84000000L0VWBV00<0
000009YdYP2JM:H01@2JM:H00`000000VWBV09YdYP0709YdYP030000002JM:H0VWBV00@0VWBV103o
o`0L0?ooo`00B`3oool4003o00@0oooo0`000?l608Q>Q00300000028CX@0R4j40080R4j42@3o0000
0`28CX@0000008Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q028CX@010000000
0`2AI9X00000095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X0
0`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X0
0`000000TFBJ00000002000000<0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP07
09MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP0000000P00000509b3^0030000002LPkP0
W8>h00H0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00@0W8>h0`0000000`2OT<@0000009n@a00609n@a0D00000202OT<@30?oo0080WX2b00<00000
09j0/P2NP;801000000209YdYP030000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01@2JM:H0
0`000000VWBV09YdYP0709YdYP030000002JM:H0VWBV00D0VWBV0`3oo`0L0?ooo`00C03oool4003o
00<0oooo0`000?l608Q>Q00300000028CX@0o`0000P0o`001028CX@00`000000R4j408Q>Q00508Q>
Q00300000028CX@0R4j400@0R4j410000005095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095T
VP2AI9X01P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095T
VP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP<000001`2GM:X00`000000UgBZ09MdZP0609Md
ZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X3000000P0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP0202LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^00000000`00000509n@a0030000002OT<@0Wi3400D0Wi341000000809n@a0@0ool01000000609Yd
YP030000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0609Yd
YP030000002JM:H0VWBV00D0VWBV103oo`0K0?ooo`00C@3oool4003o0080oooo0`000?l508Q>Q0T0
o`001`28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j40080R4j40P0000000`2AI9X0
0000095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000
TFBJ095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000
TFBJ095TVP02095TVP<0000000<0UgBZ0000002GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP03
0000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP03
0000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h00P0
W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00H0
W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00H0
W8>h0`00000909n@a0030000002OT<@0Wi3400D0Wi341000000909n@a0<0ool000<0VWBV0000002J
M:H0202JM:H00`000000VWBV09YdYP0509YdYP030000002JM:H0VWBV00H0VWBV00<0000009YdYP2J
M:H01P2JM:H00`000000VWBV09YdYP0609YdYP<0ool06`3oool004h0oooo1000o`030000o`<0R4j4
2P3o00000`28CX@0000008Q>Q00608Q>Q00300000028CX@0R4j400D0R4j400<0000008Q>Q0000000
0P000003095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ
095TVP06095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ
095TVP05095TVP030000002AI9X0000000800000102GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP030000
002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ00000002000000D0W8>h
00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00P0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00809b3^0030000002LPkP0W8>h00L0W8>h
00<0000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400X0Wi3400<0000009n@a02OT<@0
1@2OT<@3000000T0Wi34103oo`000`000000VWBV09YdYP0709YdYP030000002JM:H0VWBV00H0VWBV
00<0000009YdYP2JM:H01@2JM:H00`000000VWBV09YdYP0709YdYP030000002JM:H0VWBV00D0VWBV
0`3oo`0K0?ooo`00C`3oool4003o0080003o2P3o000408Q>Q00300000028CX@0R4j400D0R4j400<0
000008Q>Q028CX@01028CX@3000000H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095T
VP05095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095T
VP06095TVP030000002AI9X0TFBJ00@0TFBJ0`00000809MdZP030000002GM:X0UgBZ00D0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0
000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP<00000202LPkP00`000000W8>h09b3
^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3
^00709b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h0000
0002000000D0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00509n@a080000000<0
Wi340000002OT<@0202OT<@30?oo000309YdYP000000VWBV00L0VWBV00<0000009YdYP2JM:H01P2J
M:H00`000000VWBV09YdYP0509YdYP030000002JM:H0VWBV00L0VWBV00<0000009YdYP2JM:H01@2J
M:H30?oo01/0oooo001@0?ooo`@00?l0203o000708Q>Q00300000028CX@0R4j400D0R4j400<00000
08Q>Q028CX@00P28CX@200000003095TVP000000TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X0
0`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01P2AI9X0
0`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00@0000000<0UgBZ0000002GM:X0202GM:X0
0`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X00P2GM:X3
0000000309b3^0000000W8>h00P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^007
09b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^008
09b3^0030000002LPkP0W8>h00L0W8>h0`00000809n@a0030000002OT<@0Wi3400P0Wi3400<00000
09n@a02OT<@01P2OT<@00`000000Wi340000000909n@a0<0ool000<0VWBV0000002JM:H01`2JM:H0
0`000000VWBV09YdYP0609YdYP030000002JM:H0VWBV00D0VWBV00<0000009YdYP2JM:H01`2JM:H0
0`000000VWBV09YdYP0509YdYP<0ool06`3oool00540oooo1@00o`030?l00080R4j400<0000008Q>
Q028CX@01@28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@00000008000000`2AI9X00`00
0000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`00
0000TFBJ095TVP05095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X40000
00D0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ
00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ
00L0UgBZ00<0000009MdZP0000000P00000509b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00P0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00@0W8>h0`0000000`2O
T<@0000009n@a00909n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@00`00
0000Wi3409n@a00709n@a0@0ool000<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0609Yd
YP030000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0509Yd
YP<0ool06`3oool00580oooo0`00o`000`3o0000R4j408Q>Q00308Q>Q00300000028CX@0R4j400D0
R4j400<0000008Q>Q028CX@01028CX@3000000H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000
TFBJ095TVP05095TVP030000002AI9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000
TFBJ095TVP06095TVP030000002AI9X0TFBJ0080TFBJ0`0000000`2GM:X0000009MdZP0709MdZP03
0000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP03
0000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP<0
0000202LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02L
PkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02L
PkP0202LPkP00`000000W8>h00000003000000D0Wi3400<0000009n@a02OT<@01`2OT<@00`000000
Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@30?oo0003
0000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0609YdYP03
0000002JM:H0VWBV00L0VWBV00<0000009YdYP2JM:H0102JM:H30?oo01/0oooo001B0?ooo`<0ool0
1P28CX@00`000000R4j408Q>Q00508Q>Q00300000028CX@0R4j400@0000000<0TFBJ0000002AI9X0
1P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0
1P2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP000000
0P00000409MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ
09MdZP0709MdZP030000002GM:X0UgBZ0080UgBZ0`0000000`2LPkP0000009b3^00809b3^0030000
002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000
002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0<00000
2@2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400T0Wi3400<0000009n@a02OT<@0
1`2OT<@00`000000Wi3409n@a00709n@a0<0ool000<0VWBV0000002JM:H01`2JM:H00`000000VWBV
09YdYP0609YdYP030000002JM:H0VWBV00D0VWBV00<0000009YdYP2JM:H01`2JM:H00`000000VWBV
09YdYP04000000<0ool06`3oool00580oooo0`3oo`0608Q>Q00300000028CX@0R4j400@0R4j41000
0005095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095T
VP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095T
VP04095TVP<000001`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0
000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X01`2GM:X00`000000UgBZ00000002000000D0W8>h00<0000009b3^02LPkP01P2L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP0102L
PkP30000000309n@a0000000Wi3400T0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@
a00809n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01P2OT<@40?oo00030000002J
M:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0509YdYP030000002J
M:H0VWBV00H0VWBV1000000409EUV0@0ool06P3oool00580oooo0`3oo`0608Q>Q00300000028CX@0
R4j40080R4j40P0000000`2AI9X00000095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000
095TVP2AI9X01@2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000
095TVP2AI9X01P2AI9X00`000000TFBJ095TVP02095TVP80000000<0UgBZ0000002GM:X0202GM:X0
0`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01@2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X3
000000P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00H0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^00000000`00000509n@a0030000002OT<@0Wi3400P0Wi3400<00000
09n@a02OT<@01`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi3400<00000
09n@a02OT<@01`2OT<@30?oo00030000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H0
0`000000VWBV09YdYP0609YdYP030000002JM:H0VWBV0080VWBV0`0000000`2EIIP0000009EUV006
09EUV0<0ool06P3oool00580oooo0`3oo`0608Q>Q00300000028CX@00000008000000`2AI9X00`00
0000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`00
0000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`00
0000TFBJ00000002000000<0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0509Md
ZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609Md
ZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h
00P0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h
00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h
00D0W8>h1000000909n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@0202OT<@00`00
0000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@30?oo
00030000002JM:H0VWBV00H0VWBV00<0000009YdYP2JM:H01P2JM:H00`000000VWBV09YdYP0609Yd
YP030000002JM:H0000000800000102EIIP00`000000UFFH09EUV00509EUV0<0ool06P3oool00580
oooo0`3oo`0508Q>Q0<000001P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0
TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0
TFBJ00<00000095TVP2AI9X0102AI9X4000000L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000
UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000
UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP0000000P00000509b3^003
0000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^003
0000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h09b3^00709b3^003
0000002LPkP0W8>h00@000000P2OT<@00`000000Wi3409n@a00909n@a0030000002OT<@0Wi3400L0
Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0
Wi3400<0000009n@a02OT<@01P2OT<@40?oo00P0VWBV00<0000009YdYP2JM:H01`2JM:H00`000000
VWBV09YdYP0409YdYP<000001`2EIIP00`000000UFFH09EUV00509EUV0<0ool06P3oool00580oooo
0`3oo`0308Q>Q080000000<0TFBJ0000002AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000
002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP030000
002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01000000209MdZP030000002GM:X0UgBZ00H0UgBZ
00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ
00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00@0UgBZ
1000000809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h
09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0202LPkP00`000000W8>h
09b3^00609b3^0@000001`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi34
00<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00909n@a0030000002OT<@0Wi3400L0Wi34
00<0000009n@a02OT<@01P2OT<@50?oo00L0VWBV00<0000009YdYP2JM:H01`2JM:H00`000000VWBV
09YdYP040000000309EUV0000000UFFH00L0UFFH00<0000009EUV02EIIP01@2EIIP30?oo01X0oooo
001B0?ooo`<0ool00`000003095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2A
I9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2A
I9X00`000000TFBJ095TVP04095TVP@000001P2GM:X00`000000UgBZ09MdZP0609MdZP030000002G
M:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP030000002G
M:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0400000080W8>h00<0
000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0
000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0
000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400P0Wi3400<0000009n@a02OT<@0202O
T<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@0202O
T<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400@0Wi340`0000040?oo00P0VWBV00<0
000009YdYP2JM:H0102JM:H5000000D0UFFH00<0000009EUV02EIIP01`2EIIP00`000000UFFH09EU
V00509EUV0<0ool06@3oool00580oooo0`3oo`06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000
095TVP2AI9X01@2AI9X00`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000
095TVP2AI9X01@2AI9X00`000000TFBJ095TVP02095TVP80000000<0UgBZ0000002GM:X01`2GM:X0
0`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X0
0`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X4
000000L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00P0W8>h00<0000009b3^00000000P00000509n@a0030000002OT<@0Wi3400L0Wi3400<00000
09n@a02OT<@0202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400P0Wi3400<00000
09n@a02OT<@0202OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0000000<00000102RW]03
0?oo00P0VWBV00<0000009YdYP2JM:H01000000209EUV0030000002EIIP0UFFH00H0UFFH00<00000
09EUV02EIIP01P2EIIP00`000000UFFH09EUV00509EUV0<0ool06@3oool00580oooo0`3oo`06095T
VP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095TVP06095T
VP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ000000020000
00<0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ
00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ
00H0UgBZ00<0000009MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h00P0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h0`00000809n@
a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00809n@
a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00609n@
a0<00000202RW]040?oo00H0VWBV1000000609EUV0030000002EIIP0UFFH00H0UFFH00<0000009EU
V02EIIP01P2EIIP00`000000UFFH09EUV00509EUV0<0ool06@3oool00580oooo0`3oo`06095TVP03
0000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095TVP03
0000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0102AI9X3000000L0UgBZ00<0000009MdZP2G
M:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2G
M:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP00
00000P00000509b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00609b3^0030000002LPkP0W8>h00@0W8>h0`0000000`2OT<@0000009n@a00909n@a003
0000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@02@2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00309n@a0<0
000000<0XYk@0000002RW]002@2RW]030?oo00@0VWBV0P0000000`2EIIP0000009EUV00709EUV003
0000002EIIP0UFFH00H0UFFH00<0000009EUV02EIIP01P2EIIP00`000000UFFH09EUV00509EUV0<0
ool06@3oool00580oooo0`3oo`06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0
1P2AI9X00`000000TFBJ095TVP05095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0
0P2AI9X20000000309MdZP000000UgBZ00L0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ0`00000809b3^0030000002LPkP0W8>h00H0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0000000<00000
1@2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
202OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
2@2OT<@00`000000Wi3400000002000000D0XYk@00<000000::Nd02RW]001`2RW]040?oo00<00000
0`2EIIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00H0UFFH00<0000009EUV02EIIP0
1P2EIIP00`000000UFFH09EUV00509EUV0<0ool06@3oool00580oooo0`3oo`06095TVP030000002A
I9X0TFBJ00H0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ095TVP05095TVP030000002A
I9X0TFBJ00D0TFBJ00<00000095TVP0000000P00000309MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ0080UgBZ0P00
00000`2LPkP0000009b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00609b3^0<000002@2OT<@00`000000Wi3409n@a00709n@a0030000002O
T<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00809n@a0030000002O
T<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@3000000P0XYk@00<000000::Nd02RW]00202R
W]030?oo00L0UFFH00<0000009EUV02EIIP01P2EIIP00`000000UFFH09EUV00509EUV0030000002E
IIP0UFFH00H0UFFH00<0000009EUV02EIIP01@2EIIP30?oo01T0oooo001B0?ooo`<0ool01P2AI9X0
0`000000TFBJ095TVP06095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X0
0`000000TFBJ095TVP04095TVP<000001`2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0
UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0
UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ00000002000000@0W8>h00<00000
09b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<00000
09b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<00000
09b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400T0Wi3400<0000009n@a02OT<@0202OT<@0
0`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@0
0`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400@0Wi340`0000000`2RW]0000000::Nd009
0::Nd0030000002RW]00XYk@00L0XYk@0`3oo`0709EUV0030000002EIIP0UFFH00H0UFFH00<00000
09EUV02EIIP01@2EIIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00D0UFFH0`3oo`0I
0?ooo`00DP3oool30?oo00H0TFBJ00<00000095TVP2AI9X01P2AI9X00`000000TFBJ095TVP05095T
VP030000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0100000000`2GM:X0000009MdZP0709Md
ZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01`2GM:X00`000000UgBZ09MdZP0409Md
ZP@000001`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h00000002000000D0Wi3400<0000009n@a02OT<@0202OT<@00`00
0000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`00
0000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a00000000`0000050::N
d0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]040?oo00H0UFFH00<0000009EU
V02EIIP01P2EIIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00D0UFFH00<0000009EU
V02EIIP01P2EIIP30?oo01P0oooo001B0?ooo`<0ool01`2AI9X00`000000TFBJ095TVP05095TVP03
0000002AI9X0TFBJ00D0TFBJ00<00000095TVP2AI9X0102AI9X4000000D0UgBZ00<0000009MdZP2G
M:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2G
M:X01P2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00L0UgBZ00<0000009MdZP2G
M:X01000000209b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h0`00000809n@a0030000002OT<@0Wi3400P0
Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400T0
Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0<000002@2RW]000`000000
XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@0`3oo`0609EUV0030000002EIIP0UFFH00H0
UFFH00<0000009EUV02EIIP01P2EIIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00D0
UFFH0`3oo`0H0?ooo`00DP3oool30?oo00L0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ
095TVP05095TVP030000002AI9X0TFBJ0080TFBJ0P0000000`2GM:X0000009MdZP0709MdZP030000
002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0509MdZP@00000
1`2LPkP00`000000W8>h09b3^00509b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0
1`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP0
1P2LPkP00`000000W8>h09b3^00309b3^0<0000000<0Wi340000002OT<@02@2OT<@00`000000Wi34
09n@a00709n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi34
09n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0102OT<@3000000030::N
d0000000XYk@00X0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0<0ool0
1P2EIIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00H0UFFH00<0000009EUV02EIIP0
1P2EIIP00`000000UFFH09EUV00509EUV0<0ool0603oool00580oooo0`3oo`07095TVP030000002A
I9X0TFBJ00D0TFBJ00<00000095TVP2AI9X01@2AI9X00`000000TFBJ00000002000000<0UgBZ00<0
000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0
000009MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h00P0W8>h00<0000009b3^02LPkP01P2L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2L
PkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^00000000P00
000509n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@
a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@
a00809n@a0030000002OT<@0000000<000001@2RW]000`000000XYk@0::Nd0080::Nd0030000002R
W]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]040?oo00D0UFFH00<0000009EUV02EIIP01P2E
IIP00`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00H0UFFH00<0000009EUV02EIIP00P2E
IIP3000000<0ool0603oool00580oooo0`3oo`07095TVP030000002AI9X0TFBJ00D0TFBJ00<00000
095TVP2AI9X0102AI9X3000000H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP0000000P00000509b3^0030000002LPkP0
W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00D0W8>h1000000809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@0
0`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@0
0`000000Wi3409n@a00609n@a0<000002@2RW]000`000000XYk@0::Nd0090::Nd0030000002RW]00
XYk@00L0XYk@00<000000::Nd02RW]001`2RW]030?oo00H0UFFH00<0000009EUV02EIIP01@2EIIP0
0`000000UFFH09EUV00609EUV0030000002EIIP0UFFH00H0UFFH00<0000009EUV00000000P000003
08iCQ@<0ool0603oool00580oooo0`3oo`07095TVP030000002AI9X0TFBJ00D0TFBJ00<00000095T
VP2AI9X00P2AI9X20000000309MdZP000000UgBZ00L0UgBZ00<0000009MdZP2GM:X01@2GM:X00`00
0000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`00
0000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ0`00000809b3^0030000002LPkP0W8>h
00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h
00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h
00@000000P2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@
a02OT<@01`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@
a02OT<@0202OT<@00`000000Wi3409n@a00309n@a0<0000000<0XYk@0000002RW]002P2RW]000`00
0000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]040?oo
00D0UFFH00<0000009EUV02EIIP01@2EIIP00`000000UFFH09EUV00709EUV0030000002EIIP0UFFH
00@0UFFH0`00000608iCQ@<0ool0603oool00580oooo0`3oo`07095TVP030000002AI9X0TFBJ00D0
TFBJ00<00000095TVP0000000P00000309MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2G
M:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2G
M:X01@2GM:X00`000000UgBZ09MdZP0709MdZP030000002GM:X0UgBZ0080UgBZ0P0000000`2LPkP0
000009b3^00809b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00609b3^0@000001`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0
Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400H0
Wi3400<0000009n@a02OT<@02@2OT<@00`000000Wi3400000002000000D0XYk@00<000000::Nd02R
W]00202RW]000`000000XYk@0::Nd0090::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02R
W]001`2RW]030?oo00D0UFFH00<0000009EUV02EIIP01P2EIIP00`000000UFFH09EUV00609EUV003
0000002EIIP0UFFH00@0000000<0SU>50000002>DhD01`2>DhD30?oo01L0oooo001B0?ooo`<0ool0
1`2AI9X00`000000TFBJ095TVP04095TVP<000001P2GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000
002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ00000002000000@0W8>h
00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h
00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h
00<0000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400P0Wi3400<0000009n@a02OT<@0
1`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi340`0000080::Nd0030000
002RW]00XYk@00T0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000
002RW]00XYk@00H0XYk@0`3oo`0509EUV0030000002EIIP0UFFH00H0UFFH00<0000009EUV02EIIP0
1@2EIIP4000000D0SU>500<0000008iCQ@2>DhD01P2>DhD30?oo01L0oooo001B0?ooo`<0ool01`2A
I9X00`000000TFBJ095TVP040000000309MdZP000000UgBZ00L0UgBZ00<0000009MdZP2GM:X01@2G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00@0UgBZ1000000709b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000002L
PkP00000008000001@2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00409n@a0<0000000<0XYk@0000002RW]002@2R
W]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]00202R
W]000`000000XYk@0::Nd0060::Nd0@0ool0102EIIP00`000000UFFH09EUV00609EUV0030000002E
IIP0UFFH0080UFFH0`0000000`2>DhD0000008iCQ@0608iCQ@030000002>DhD0SU>500H0SU>50`3o
o`0G0?ooo`00D`3oool30?oo00D0TFBJ1000000509MdZP030000002GM:X0UgBZ00H0UgBZ00<00000
09MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<00000
09MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00@000000P2LPkP0
0`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP0
0`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP0
0`000000W8>h09b3^00609b3^0<00000202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0
Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3400000003000000D0XYk@00<00000
0::Nd02RW]001`2RW]000`000000XYk@0::Nd0090::Nd0030000002RW]00XYk@00P0XYk@00<00000
0::Nd02RW]00202RW]000`000000XYk@0::Nd0060::Nd0<0ool0102EIIP00`000000UFFH09EUV006
09EUV0030000002EIIP0000000800000102>DhD00`000000SU>508iCQ@0508iCQ@030000002>DhD0
SU>500H0SU>50`3oo`0G0?ooo`00D`3oool30?oo00<0TFBJ0P0000000`2GM:X0000009MdZP0609Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0509Md
ZP@000001`2LPkP00`000000W8>h09b3^00509b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP01P2LPkP00`000000W8>h09b3^00309b3^0<0000000<0Wi340000002OT<@02@2OT<@00`00
0000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`00
0000Wi3409n@a00709n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01@2OT<@40000
00T0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00P0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0060::Nd0D0ool00`2EIIP00`00
0000UFFH09EUV00409EUV0<000001`2>DhD00`000000SU>508iCQ@0508iCQ@030000002>DhD0SU>5
00H0SU>50`3oo`0G0?ooo`00D`3oool30?oo00<000000`2GM:X00`000000UgBZ09MdZP0609MdZP03
0000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0709MdZP03
0000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0209MdZP80
000000<0W8>h0000002LPkP0202LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0
W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0
W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h00000002000000D0Wi3400<0000009n@a02O
T<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02O
T<@0100000030::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2RW]000`000000
XYk@0::Nd0080::Nd0030000002RW]00XYk@00T0XYk@00<000000::Nd02RW]00202RW]000`000000
XYk@0::Nd0060::Nd0@0ool00`2EIIP00`000000UFFH09EUV0040000000308iCQ@000000SU>500L0
SU>500<0000008iCQ@2>DhD01@2>DhD00`000000SU>508iCQ@0608iCQ@<0ool05`3oool005<0oooo
0`3oo`0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ
09MdZP0609MdZP030000002GM:X0000000800000102LPkP00`000000W8>h09b3^00609b3^0030000
002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00709b3^0030000
002LPkP0W8>h00D0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0<00000
202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1`2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1`2OT<@4000000L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000
002RW]00XYk@00P0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000
002RW]00XYk@00@0XYk@0P0000050?oo00D000001@2>DhD00`000000SU>508iCQ@0608iCQ@030000
002>DhD0SU>500D0SU>500<0000008iCQ@2>DhD01P2>DhD30?oo01L0oooo001C0?ooo`<0ool01`2G
M:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01@2G
M:X3000000L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00H0W8>h00<0000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400T0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400@0Wi340`00
00000`2RW]0000000::Nd0090::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2R
W]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00T0XYk@00<000000::Nd02RW]00202R
W]000`000000XYk@00000003000000@0Y:gN0`3oo`0208iCQ@030000002>DhD0SU>500D0SU>500<0
000008iCQ@2>DhD01P2>DhD00`000000SU>508iCQ@0608iCQ@030000002>DhD0SU>500D0SU>50`3o
o`0G0?ooo`00D`3oool30?oo00L0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP06
09MdZP030000002GM:X0UgBZ0080UgBZ0P0000000`2LPkP0000009b3^00709b3^0030000002LPkP0
W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0
0000008000001@2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<00000
09n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<00000
09n@a02OT<@0202OT<@00`000000Wi3400000003000000D0XYk@00<000000::Nd02RW]001`2RW]00
0`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]00202RW]00
0`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00H0XYk@100000080:B]gP@0ool000<0SU>5
0000002>DhD01P2>DhD00`000000SU>508iCQ@0608iCQ@030000002>DhD0SU>500H0SU>500<00000
08iCQ@2>DhD01@2>DhD30?oo01L0oooo001C0?ooo`<0ool01`2GM:X00`000000UgBZ09MdZP0509Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609Md
ZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP0000000P00000409b3^0030000002LPkP0W8>h
00D0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h
00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h
00D0W8>h1000000809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`00
0000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`00
0000Wi3409n@a00609n@a0<000002@2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00P0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00T0XYk@00<000000::Nd02RW]001@0000030:B]gP030000002T[Mh0Y:gN00L0Y:gN0`3oo`000`2>
DhD0000008iCQ@0608iCQ@030000002>DhD0SU>500L0SU>500<0000008iCQ@2>DhD01@2>DhD00`00
0000SU>508iCQ@0508iCQ@<0ool05`3oool005<0oooo0`3oo`0709MdZP030000002GM:X0UgBZ00D0
UgBZ00<0000009MdZP2GM:X01P2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00L0
UgBZ00<0000009MdZP2GM:X0102GM:X3000000L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01000000209n@a003
0000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400<0Wi340`0000000`2RW]0000000::Nd00:0::Nd0030000002RW]00XYk@00L0
XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0
XYk@00<000000::Nd02RW]001`2RW]04000000P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh40?oo0003
0000002>DhD0SU>500D0SU>500<0000008iCQ@2>DhD01`2>DhD00`000000SU>508iCQ@0508iCQ@03
0000002>DhD0SU>500D0SU>50`3oo`0G0?ooo`00E03oool30?oo00H0UgBZ00<0000009MdZP2GM:X0
1P2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X0
1`2GM:X00`000000UgBZ09MdZP040000000309b3^0000000W8>h00L0W8>h00<0000009b3^02LPkP0
1P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP0
1P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00D0W8>h1000000709n@a0030000
002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000
002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00809n@a0030000
002OT<@00000008000001@2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@
00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@
00<000000::Nd02RW]00102RW]0300000080Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN
0:B]gP070:B]gP<0ool000<0000008iCQ@2>DhD01@2>DhD00`000000SU>508iCQ@0708iCQ@030000
002>DhD0SU>500D0SU>500<0000008iCQ@2>DhD01@2>DhD30?oo01L0oooo001D0?ooo`<0ool01P2G
M:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00D0UgBZ00<0000009MdZP2GM:X01P2G
M:X00`000000UgBZ09MdZP0509MdZP@000001P2LPkP00`000000W8>h09b3^00509b3^0030000002L
PkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00309b3^080000000<0
Wi340000002OT<@0202OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0
000009n@a02OT<@01P2OT<@3000000P0XYk@00<000000::Nd02RW]002@2RW]000`000000XYk@0::N
d0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::N
d0080::Nd0030000002RW]00000000<000001@2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T
[Mh0Y:gN00L0Y:gN103oo`0808iCQ@030000002>DhD0SU>500H0SU>500<0000008iCQ@2>DhD01@2>
DhD00`000000SU>508iCQ@0208iCQ@<000000`3oo`0G0?ooo`00E03oool30?oo00L0UgBZ00<00000
09MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X0UgBZ00H0UgBZ00<00000
09MdZP2GM:X00P2GM:X30000000309b3^0000000W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP0
0`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP0
0`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^00000000P000004
09n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a007
09n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a007
09n@a0030000002OT<@0Wi3400<0Wi340`0000020::Nd0030000002RW]00XYk@00L0XYk@00<00000
0::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<00000
0::Nd02RW]00202RW]000`000000XYk@0::Nd0070::Nd0<000002P2T[Mh00`000000Y:gN0:B]gP08
0:B]gP030000002T[Mh0Y:gN00L0Y:gN0`3oo`0808iCQ@030000002>DhD0SU>500H0SU>500<00000
08iCQ@2>DhD01@2>DhD00`000000SU>500000002000000<0PSU[0`3oo`0G0?ooo`00E03oool30?oo
00L0UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ
00D0UgBZ00<0000009MdZP0000000P00000409b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3
^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP01@2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00D0W8>h1000000709n@
a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@
a0030000002OT<@0Wi3400P0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@
a0030000002OT<@00000008000001@2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@
00T0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00P0XYk@00<000000::Nd02RW]000`2RW]0300000080Y:gN00<000000:B]gP2T[Mh0202T[Mh00`00
0000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN103oo`0708iCQ@030000002>DhD0SU>5
00H0SU>500<0000008iCQ@2>DhD0102>DhD3000000H0PSU[0`3oo`0G0?ooo`00E03oool30?oo00L0
UgBZ00<0000009MdZP2GM:X01@2GM:X00`000000UgBZ09MdZP0609MdZP030000002GM:X0UgBZ00@0
UgBZ0`00000809b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01@2LPkP00`000000
W8>h09b3^00609b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00709b3^0030000002LPkP0W8>h00@000000P2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00509n@a0@0
00002@2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02R
W]00202RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02R
W]000`0000050:B]gP030000002T[Mh0Y:gN00T0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000
Y:gN0:B]gP070:B]gP<0ool01`2>DhD00`000000SU>508iCQ@0608iCQ@030000002>DhD0SU>500@0
000000<0PSU[00000022>F/01P22>F/30?oo01L0oooo001D0?ooo`<0ool01`2GM:X00`000000UgBZ
09MdZP0509MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0100000000`2LPkP00000
09b3^00809b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h
09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h
09b3^00609b3^0@000001`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi34
00<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi34
00<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a004000000<0XYk@00<000000::Nd02RW]00
1`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]00
202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@0`0000090:B]gP030000
002T[Mh0Y:gN00T0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP@0ool0
1P2>DhD00`000000SU>508iCQ@0408iCQ@D000001@22>F/00`000000PSU[088iJ`05088iJ`<0ool0
5`3oool005@0oooo0`3oo`0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X0102G
M:X4000000H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002L
PkP0W8>h00H0W8>h00<0000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400P0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400P0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi341000
00070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::N
d0080::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::N
d0040::Nd0<000000P2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00T0Y:gN00<0
00000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP060:B]gP@0ool01P2>DhD00`000000SU>508iC
Q@0400000080PSU[00<00000088iJ`22>F/01@22>F/00`000000PSU[088iJ`05088iJ`<0ool05`3o
ool005@0oooo0`3oo`0709MdZP030000002GM:X0UgBZ00H0UgBZ00<0000009MdZP2GM:X00P2GM:X2
0000000309b3^0000000W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^007
09b3^0030000002LPkP0W8>h00D0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^007
09b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^00000000P00000509n@a0030000002OT<@0
Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0
Wi3400<0Wi340`0000000`2RW]0000000::Nd0090::Nd0030000002RW]00XYk@00L0XYk@00<00000
0::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00P0XYk@00<00000
0::Nd02RW]00202RW]000`000000XYk@00000003000000D0Y:gN00<000000:B]gP2T[Mh0202T[Mh0
0`000000Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh5
0?oo00<0SU>510000006088iJ`0300000022>F/0PSU[00D0PSU[00<00000088iJ`22>F/01@22>F/3
0?oo01L0oooo001E0?ooo`<0ool01`2GM:X00`000000UgBZ09MdZP0509MdZP030000002GM:X00000
00800000102LPkP00`000000W8>h09b3^00509b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3
^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00D0W8>h00<0000009b3
^02LPkP01`2LPkP00`000000W8>h09b3^00509b3^0<00000202OT<@00`000000Wi3409n@a00709n@
a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@
a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi34000000020000
00D0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@
00D0XYk@1000000:0:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`00
0000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN103oo`0300000003088iJ`000000PSU[
00L0PSU[00<00000088iJ`22>F/01@22>F/00`000000PSU[088iJ`05088iJ`<0ool05`3oool005D0
oooo0`3oo`0709MdZP030000002GM:X0UgBZ00@0UgBZ0`00000709b3^0030000002LPkP0W8>h00H0
W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0
W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00<0
W8>h0P0000000`2OT<@0000009n@a00909n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02O
T<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01`2OT<@00`000000Wi3409n@a00609n@a0<00000202RW]000`000000XYk@0::Nd0080::Nd003
0000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0080::Nd003
0000002RW]00XYk@00P0XYk@00@000000::Nd02RW]00XYk@100000030:B]gP030000002T[Mh0Y:gN
00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN
00L0Y:gN00<000000:B]gP2T[Mh0202T[Mh30?oo00@0PSU[00<00000088iJ`22>F/01P22>F/00`00
0000PSU[088iJ`05088iJ`0300000022>F/0PSU[00D0PSU[0`3oo`0G0?ooo`00E@3oool30?oo00L0
UgBZ00<0000009MdZP2GM:X0100000000`2LPkP0000009b3^00709b3^0030000002LPkP0W8>h00H0
W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0
W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP000000080
0000102OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01`2OT<@00`000000Wi3409n@a00309n@a0<0000000<0XYk@0000002RW]002@2RW]000`000000
XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2RW]000`000000
XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@100000070:B]gP030000002T[Mh0Y:gN00T0
Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN00L0
Y:gN00<000000:B]gP2T[Mh0102T[Mh3000000@0ool00`22>F/00`000000PSU[088iJ`06088iJ`03
00000022>F/0PSU[00D0PSU[00<00000088iJ`22>F/01@22>F/30?oo01L0oooo001E0?ooo`<0ool0
1P2GM:X4000000H0W8>h00<0000009b3^02LPkP01@2LPkP00`000000W8>h09b3^00609b3^0030000
002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`000000W8>h09b3^00509b3^0030000
002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01@2LPkP4000000L0Wi3400<0000009n@a02OT<@0
202OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1P2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a0000000
0P0000050::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@
0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@
0::Nd0040::Nd0<000000P2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN00L0Y:gN
00<000000:B]gP2T[Mh0100000040:Bok@<0ool00`22>F/00`000000PSU[088iJ`06088iJ`030000
0022>F/0PSU[00D0PSU[00<00000088iJ`22>F/01@22>F/30?oo01L0oooo001E0?ooo`@0ool00`2G
M:X20000000309b3^0000000W8>h00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3
^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3
^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01000000209n@a0030000002O
T<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002O
T<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002O
T<@0Wi3400D0Wi34100000080::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2R
W]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202R
W]000`000000XYk@00000003000000D0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]
gP080:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`000000Y:gN0:B]
gP050:B]gP@00000202T_nd40?oo0080PSU[00<00000088iJ`22>F/01@22>F/00`000000PSU[088i
J`06088iJ`0300000022>F/0PSU[00@0PSU[103oo`0G0?ooo`00EP3oool30?oo00<00000102LPkP0
0`000000W8>h09b3^00509b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP0
0`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP0
0`000000W8>h09b3^00509b3^0@000001`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00400000080XYk@00<00000
0::Nd02RW]00202RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<00000
0::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@0`00000:
0:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP09
0:B]gP030000002T[Mh0Y:gN00P0Y:gN00@000000:B]gP2T[Mh0Y:gN100000030:Bok@030000002T
_nd0Y;o]00L0Y;o]103oo`000`22>F/00000088iJ`06088iJ`0300000022>F/0PSU[00H0PSU[00<0
0000088iJ`22>F/01022>F/40?oo01L0oooo001F0?ooo`<0ool01`2LPkP00`000000W8>h09b3^006
09b3^0030000002LPkP0W8>h00D0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^006
09b3^0030000002LPkP0W8>h00L0W8>h00<0000009b3^02LPkP01@2LPkP00`000000W8>h09b3^003
09b3^080000000<0Wi340000002OT<@0202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01P2OT<@4000000L0XYk@00<000000::Nd02RW]001`2RW]00
0`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]00
0`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00<0XYk@0`0000020:B]gP030000002T[Mh0
Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0
Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh4000000P0Y;o]00<000000:Bok@2T_nd01`2T_nd4
0?oo00P0PSU[00<00000088iJ`22>F/01P22>F/00`000000PSU[088iJ`04000000@0ool05`3oool0
05H0oooo0`3oo`0709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`00
0000W8>h09b3^00509b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01`2LPkP00`00
0000W8>h09b3^00609b3^0030000002LPkP0000000800000102OT<@00`000000Wi3409n@a00709n@
a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@
a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00309n@
a0<000000P2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::N
d02RW]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<000000::N
d02RW]001`2RW]000`000000XYk@0::Nd003000000D0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`00
0000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`00
0000Y:gN0:B]gP040:B]gP<000000P2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]
00P0Y;o]103oo`07088iJ`0300000022>F/0PSU[00D0PSU[1000000506d@?P<0ool05`3oool005H0
oooo0`3oo`0709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000
W8>h09b3^00509b3^0<000001`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0
Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0
Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3400000002000000D0XYk@00<000000::Nd02R
W]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02R
W]00202RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00D0XYk@100000090:B]gP03
0000002T[Mh0Y:gN00T0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP03
0000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0100000050:Bok@030000002T_nd0Y;o]00P0
Y;o]00<000000:Bok@2T_nd0202T_nd30?oo00L0PSU[00<00000088iJ`22>F/00P22>F/300000003
06d@?P000000KA0n00H0KA0n0`3oo`0G0?ooo`00EP3oool40?oo00L0W8>h00<0000009b3^02LPkP0
1P2LPkP00`000000W8>h09b3^00509b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP0
1P2LPkP00`000000W8>h09b3^00709b3^0030000002LPkP0W8>h00@0000000<0Wi340000002OT<@0
202OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@0
1`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1@2OT<@4000000T0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000
002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0070::Nd0040000
002RW]00XYk@0::Nd0@000000`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00T0
Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0
Y:gN0`00000:0:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd01`2T_nd40?oo00H0
PSU[00<00000088iJ`0000000P00000406d@?P030000001]43h0KA0n00D0KA0n0`3oo`0G0?ooo`00
E`3oool30?oo00L0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000
002LPkP0W8>h00D0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0@00000
1P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@0
1`2OT<@00`000000Wi3409n@a004000000<0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@
0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@
0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@100000070:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh0102T[Mh300000080Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]
0:Bok@080:Bok@030000002T_nd0Y;o]00L0Y;o]103oo`03088iJ`@000001P1]43h00`000000KA0n
06d@?P0506d@?P@0ool05`3oool005L0oooo0`3oo`0709b3^0030000002LPkP0W8>h00H0W8>h00<0
000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00D0W8>h00<0
000009b3^02LPkP00`2LPkP30000000309n@a0000000Wi3400L0Wi3400<0000009n@a02OT<@01`2O
T<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2O
T<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi34100000070::Nd0030000002R
W]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002R
W]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd0030::Nd0<000000P2T
[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T
[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01000
00050:Bok@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bo
k@070:Bok@@0ool00P00000206d@?P030000001]43h0KA0n00D0KA0n00<0000006d@?P1]43h01@1]
43h30?oo01P0oooo001G0?ooo`<0ool0202LPkP00`000000W8>h09b3^00509b3^0030000002LPkP0
W8>h00H0W8>h00<0000009b3^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0
0000008000001@2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<00000
09n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi3400<00000
09n@a02OT<@01P2OT<@00`000000Wi3409n@a00309n@a0<000000P2RW]000`000000XYk@0::Nd007
0::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd007
0::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd003
000000D0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0
Y:gN00T0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP050:B]gP@000002P2T_nd0
0`000000Y;o]0:Bok@090:Bok@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd01P2T_nd4
0?oo00@0KA0n00<0000006d@?P1]43h01@1]43h00`000000KA0n06d@?P0506d@?P<0ool0603oool0
05L0oooo103oo`0709b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01@2LPkP00`00
0000W8>h09b3^00609b3^0030000002LPkP0W8>h00D0W8>h0`00000809n@a0030000002OT<@0Wi34
00H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi34
00H0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a00609n@a0030000002OT<@00000
008000001@2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00P0XYk@00<000000::N
d02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<000000::N
d02RW]001`2RW]03000000T0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]
gP030000002T[Mh0Y:gN00T0Y:gN00<000000:B]gP2T[Mh01`2T[Mh010000000Y:gN0:B]gP2T[Mh4
000000<0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@090:Bok@030000002T_nd0
Y;o]00P0Y;o]00<000000:Bok@2T_nd0102T_nd2000000D0ool00P1]43h00`000000KA0n06d@?P06
06d@?P030000001]43h0KA0n00<0KA0n1@3oo`0H0?ooo`00F03oool30?oo00L0W8>h00<0000009b3
^02LPkP01P2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0000009b3
^02LPkP0100000000`2OT<@0000009n@a00809n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@
a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@
a02OT<@01`2OT<@00`000000Wi3409n@a00509n@a0<000002@2RW]000`000000XYk@0::Nd0070::N
d0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::N
d0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00102RW]0300000080Y:gN00<000000:B]
gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]
gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP070:B]gP@00000202T_nd00`000000Y;o]0:Bok@090:Bo
k@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@030000
00<0WMCk1P3oo`000`000000KA0n06d@?P0606d@?P030000001]43h0KA0n00<0KA0n103oo`0I0?oo
o`00F03oool30?oo00P0W8>h00<0000009b3^02LPkP01@2LPkP00`000000W8>h09b3^00609b3^003
0000002LPkP0W8>h00D0W8>h1000000609n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02O
T<@01P2OT<@00`000000Wi3409n@a00809n@a0030000002OT<@0Wi3400@000000P2RW]000`000000
XYk@0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00202RW]000`000000
XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001`2RW]000`000000
XYk@00000003000000D0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP03
0000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP030:B]gP<0
00000P2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T
_nd02@2T_nd00`000000Y;o]0:Bok@080:Bok@<00000202Me?/40?oo00030000001]43h0KA0n00D0
KA0n00<0000006d@?P1]43h00P1]43h2000000@0ool06@3oool005P0oooo103oo`0709b3^0030000
002LPkP0W8>h00H0W8>h00<0000009b3^02LPkP01@2LPkP00`000000W8>h09b3^00309b3^0800000
00<0Wi340000002OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0Wi34
00<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi34
00<0000009n@a02OT<@01P2OT<@4000000H0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@
0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@
0::Nd0070::Nd0030000002RW]00XYk@00D0XYk@1000000:0:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh00`0000060:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd0
2@2T_nd00`000000Y;o]0:Bok@090:Bok@030000002T_nd0Y;o]00@0Y;o]0`00000209gDn`030000
002Me?/0WMCk00L0WMCk103oo`0706d@?P030000001]43h00000008000000P0n00040?oo01T0oooo
001I0?ooo`<0ool01`2LPkP00`000000W8>h09b3^00609b3^0030000002LPkP0W8>h00H0W8>h00<0
000009b3^00000000P00000409n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2O
T<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2O
T<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400<0Wi340`0000020::Nd0030000002R
W]00XYk@00H0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002R
W]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002R
W]00XYk@00@000000`2T[Mh00`000000Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN00L0Y:gN00<0
00000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN0`00
00090:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bo
k@080:Bok@030000002T_nd0Y;o]00@000001P2Me?/00`000000WMCk09gDn`0709gDn`@0ool0101]
43h4000000D0?P000`3oo`0J0?ooo`00F@3oool30?oo00L0W8>h00<0000009b3^02LPkP01P2LPkP0
0`000000W8>h09b3^00509b3^0<000001`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0
Wi3400L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0
Wi3400P0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3400000002000000D0XYk@00<00000
0::Nd02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00L0XYk@00<00000
0::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00H0XYk@10000007
0:B]gP030000002T[Mh0Y:gN00T0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP07
0:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0102T[Mh300000080Y;o]00<00000
0:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00T0Y;o]00<00000
0:Bok@2T_nd01P2T_nd4000000/0WMCk00<0000009gDn`2Me?/01`2Me?/40?oo00<0000000<0?P00
0000000n00001@0n00040?oo01X0oooo001I0?ooo`@0ool01`2LPkP00`000000W8>h09b3^00609b3
^0030000002LPkP0W8>h00@0000000<0Wi340000002OT<@0202OT<@00`000000Wi3409n@a00609n@
a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@
a0030000002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01@2OT<@3000000T0XYk@00<000000::N
d02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::N
d02RW]00202RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00<0XYk@0`0000020:B]
gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP070:B]
gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP040000
00D0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]
00P0Y;o]00@000000:Bok@2T_nd0Y;o]1@00000309gDn`030000002Me?/0WMCk00X0WMCk00<00000
09gDn`2Me?/01`2Me?/50?oo0080?P0000<0000003h0000n00000P0n00060?oo01X0oooo001J0?oo
o`<0ool01`2LPkP00`000000W8>h09b3^00509b3^0@000001P2OT<@00`000000Wi3409n@a00609n@
a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@
a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@0202OT<@00`000000Wi3409n@a0040000
0080XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@
00P0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@
00L0XYk@00<000000::Nd00000000P0000050:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]
gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]
gP2T[Mh01@2T[Mh4000000X0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@080:Bo
k@030000002T_nd0Y;o]00L0Y;o]1000000909gDn`030000002Me?/0WMCk00X0WMCk00<0000009gD
n`2Me?/01@2Me?/2000000L0ool00`0n00050?oo01`0oooo001J0?ooo`<0ool01`2LPkP00`000000
W8>h09b3^00309b3^080000000<0Wi340000002OT<@01`2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a003
0000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@4000000H0XYk@00<000000::Nd02R
W]00202RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02R
W]001`2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00D0XYk@0`0000090:B]gP03
0000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP03
0000002T[Mh0Y:gN00L0Y:gN00@000000:B]gP2T[Mh0Y:gN100000030:Bok@030000002T_nd0Y;o]
00T0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]
00@0Y;o]0`00000209gDn`030000002Me?/0WMCk00T0WMCk00<0000009gDn`2Me?/02P2Me?/00`00
0000WMCk09gDn`0400000080ON3g3`3oo`0L0?ooo`00FP3oool40?oo00L0W8>h00<0000009b3^000
00000P00000409n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@0Wi3400<0Wi340`0000020::Nd0030000002RW]00XYk@00H0
XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0
XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0070::Nd0040000002RW]00XYk@0::N
d0@000000P2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]
gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN100000080:Bo
k@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@070:Bo
k@030000002T_nd0Y;o]00<000001P2Me?/00`000000WMCk09gDn`0909gDn`8000002P2Me?/30000
00P0ON3g2`3oo`0N0?ooo`00F`3oool30?oo00H0W8>h0`00000709n@a0030000002OT<@0Wi3400H0
Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400L0
Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@000000080
00001@2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02R
W]001P2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02R
W]001`2RW]04000000H0Y:gN00<000000:B]gP2T[Mh02@2T[Mh00`000000Y:gN0:B]gP070:B]gP03
0000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP030:B]gP<0
00000P2T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T
_nd02@2T_nd00`000000Y;o]0:Bok@060:Bok@@000002P2Me?/00`000000WMCk09gDn`0:09gDn`03
0000002Me?/0WMCk00@0WMCk0`00000307gPm`<00000101mh?L5000000D0ool0803oool005/0oooo
0`3oo`0209b3^0@0000000<0Wi340000002OT<@01`2OT<@00`000000Wi3409n@a00709n@a0030000
002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00609n@a0030000
002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01@2OT<@3000000T0XYk@00<000000::Nd02RW]00
1P2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]00
202RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00<0XYk@0`0000020:B]gP030000
002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP030000
002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP03000000H0Y;o]
00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00T0Y;o]
00@000000:Bok@2T_nd0Y;o]1000000309gDn`030000002Me?/0WMCk00T0WMCk0P00000;09gDn`03
0000002Me?/0WMCk00<000002@1mh?L5000002T0oooo001L0?ooo`040?oo000000000000000000H0
Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400H0
Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400L0
Wi3400<0000009n@a02OT<@0100000020::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02R
W]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02R
W]001`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00<000001@2T[Mh00`000000
Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000
Y:gN0:B]gP090:B]gP030000002T[Mh0Y:gN00D0Y:gN100000090:Bok@030000002T_nd0Y;o]00P0
Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@080:Bok@@00000202Me?/00`000000
WMCk09gDn`0:09gDn`030000002Me?/0WMCk00L0WMCk1000000907gPm`<00000;P3oool005`0oooo
0`3oo`0709n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi34
09n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi34
09n@a00609n@a0@000001P2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00H0XYk@
00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@
00<000000::Nd02RW]001@2RW]04000000T0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN
0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh0202T[Mh010000000Y:gN
0:B]gP2T[Mh4000000<0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd0102T_nd300000080WMCk00<0000009gDn`2M
e?/0202Me?/00`000000WMCk09gDn`0:09gDn`040000002Me?/0WMCk09gDn`D00000101mh?L30000
00<0ON3g0`00000a0?ooo`00G03oool40?oo00L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01P2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@0Wi3400<0Wi340`0000020::Nd0030000002RW]00XYk@00H0
XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0
XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0040000002RW]00XYk@0::N
d0@000000`2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]
gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN100000080:Bo
k@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bo
k@030000002T_nd0Y;o]00@000001P2Me?/00`000000WMCk09gDn`0809gDn`8000002P2Me?/40000
00/0ON3g1000000d0?ooo`00G@3oool30?oo00L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000
Wi3409n@a00609n@a0030000002OT<@00000008000001@2RW]000`000000XYk@0::Nd0060::Nd003
0000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd003
0000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001`2RW]04000000L0Y:gN00<000000:B]gP2T
[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T
[Mh0202T[Mh00`000000Y:gN0:B]gP030:B]gP<000000P2T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@060:Bok@@0
00002`2Me?/00`000000WMCk09gDn`0909gDn`030000002Me?/0WMCk00@0WMCk0`00000307gPm`@0
0000101mh?L4000003P0oooo001M0?ooo`<0ool01`2OT<@00`000000Wi3409n@a00609n@a0030000
002OT<@0Wi3400L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00609n@a0030000
002OT<@0Wi3400D0Wi340`0000090::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]00
1`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]00
1P2RW]000`000000XYk@0::Nd0030::Nd0<000000P2T[Mh00`000000Y:gN0:B]gP070:B]gP030000
002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP030000
002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh00`0000060:Bok@030000002T_nd0Y;o]00P0Y;o]
00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@040000002T_nd0Y;o]0:Bok@@0
00000`2Me?/00`000000WMCk09gDn`0:09gDn`8000002P2Me?/00`000000WMCk09gDn`03000000X0
ON3g1000000l0?ooo`00G@3oool40?oo00L0Wi3400<0000009n@a02OT<@01P2OT<@00`000000Wi34
09n@a00609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2OT<@00`000000Wi34
09n@a00400000080XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000
002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0030000
002RW]00XYk@00H0XYk@00<000000::Nd02RW]000`0000050:B]gP030000002T[Mh0Y:gN00P0Y:gN
00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00T0Y:gN
00<000000:B]gP2T[Mh01@2T[Mh4000000T0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]
0:Bok@090:Bok@030000002T_nd0Y;o]00L0Y;o]1000000809gDn`030000002Me?/0WMCk00/0WMCk
00<0000009gDn`2Me?/01P2Me?/4000000X0ON3g0`0000100?ooo`00GP3oool30?oo00L0Wi3400<0
000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi3400<0
000009n@a02OT<@01@2OT<@4000000H0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::N
d0060::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::N
d0080::Nd0030000002RW]00XYk@00D0XYk@0`0000090:B]gP030000002T[Mh0Y:gN00L0Y:gN00<0
00000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00@0
00000:B]gP2T[Mh0Y:gN100000030:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0
202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00@0Y;o]0`00000209gDn`030000
002Me?/0WMCk00P0WMCk00<0000009gDn`2Me?/02`2Me?/010000000WMCk09gDn`2Me?/4000000@0
ON3g1000000307gPm`<00000@`3oool005h0oooo103oo`0609n@a0030000002OT<@0Wi3400H0Wi34
00<0000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400<0Wi34
0P0000020::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@
0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@
0::Nd0070::Nd0040000002RW]00XYk@0::Nd0@000000P2T[Mh00`000000Y:gN0:B]gP080:B]gP03
0000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP03
0000002T[Mh0Y:gN00L0Y:gN100000080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T
_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00<000001P2Me?/00`000000
WMCk09gDn`0809gDn`8000002`2Me?/4000000/0ON3g100000160?ooo`00G`3oool30?oo00L0Wi34
00<0000009n@a02OT<@01P2OT<@00`000000Wi3409n@a00709n@a0030000002OT<@0Wi3400H0Wi34
00<0000009n@a00000000P0000040::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]00
202RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]00
1P2RW]000`000000XYk@0::Nd0070::Nd0@000001P2T[Mh00`000000Y:gN0:B]gP080:B]gP030000
002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP080:B]gP030000
002T[Mh0Y:gN00<0Y:gN0`0000020:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0
202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00H0Y;o]1000000:09gDn`030000
002Me?/0WMCk00T0WMCk00<0000009gDn`2Me?/01@2Me?/3000000<0ON3g1000000407gPm`@00000
BP3oool005l0oooo103oo`0609n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a02OT<@01`2O
T<@00`000000Wi3409n@a00509n@a0<00000202RW]000`000000XYk@0::Nd0060::Nd0030000002R
W]00XYk@00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002R
W]00XYk@00H0XYk@00<000000::Nd02RW]000`2RW]0300000080Y:gN00<000000:B]gP2T[Mh01P2T
[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh0202T
[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00<000001P2T_nd00`000000Y;o]0:Bo
k@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T_nd010000000Y;o]0:Bo
k@2T_nd4000000<0WMCk00<0000009gDn`2Me?/02@2Me?/2000000X0WMCk00<0000009gDn`2Me?/0
1000000:07gPm`@00000CP3oool00600oooo0`3oo`0709n@a0030000002OT<@0Wi3400H0Wi3400<0
000009n@a02OT<@01`2OT<@00`000000Wi3409n@a00400000080XYk@00<000000::Nd02RW]001P2R
W]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2R
W]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]000`00
00050:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]
gP080:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01@2T[Mh4000000T0Y;o]00<0
00000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@090:Bok@030000002T_nd0Y;o]00L0Y;o]1000
000809gDn`8000002`2Me?/00`000000WMCk09gDn`0609gDn`@000002`1mh?L300000580oooo001P
0?ooo`<0ool01`2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400H0Wi3410000006
0::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd007
0::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]00202RW]000`000000XYk@0::Nd005
0::Nd0<000002@2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<00000
0:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP040000002T[Mh0Y:gN0:B]gP@000000`2T
_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T
_nd00`000000Y;o]0:Bok@040:Bok@<000000P2Me?/00`000000WMCk09gDn`0909gDn`030000002M
e?/0WMCk00T0WMCk00@0000009gDn`2Me?/0WMCk1000000407gPm`@00000101mh?L3000005D0oooo
001P0?ooo`@0ool01P2OT<@00`000000Wi3409n@a00609n@a0030000002OT<@0Wi3400<0Wi340`00
00020::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::N
d0060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::N
d0070::Nd0040000002RW]00XYk@0::Nd0@000000P2T[Mh00`000000Y:gN0:B]gP080:B]gP030000
002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000
002T[Mh0Y:gN00L0Y:gN100000080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0
202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00<000001P2Me?/00`000000WMCk
09gDn`0909gDn`030000002Me?/0WMCk00L0WMCk1@00000<07gPm`@00000F03oool00640oooo0`3o
o`0709n@a0030000002OT<@0Wi3400H0Wi3400<0000009n@a00000000P0000050::Nd0030000002R
W]00XYk@00H0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002R
W]00XYk@00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0@000001`2T
[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T
[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00<0Y:gN0`0000020:Bok@030000002T
_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T
_nd0Y;o]00H0Y;o]1000000:09gDn`030000002Me?/0WMCk00T0WMCk0P00000309gDn`@00000101m
h?L4000000D0ON3g1000001L0?ooo`00H@3oool40?oo00H0Wi3400<0000009n@a02OT<@01@2OT<@3
000000T0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00
XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00
XYk@00<0XYk@0`0000020:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh0202T[Mh0
0`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh0
0`000000Y:gN0:B]gP03000000H0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@08
0:Bok@030000002T_nd0Y;o]00P0Y;o]00@000000:Bok@2T_nd0Y;o]1000000309gDn`030000002M
e?/0WMCk00T0WMCk0P00000:09gDn`@00000301mh?L500000600oooo001R0?ooo`<0ool01`2OT<@0
0`000000Wi3409n@a00400000080XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd006
0::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd007
0::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]000`0000050:B]gP030000002T[Mh0
Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0
Y:gN00P0Y:gN00<000000:B]gP2T[Mh01@2T[Mh4000000T0Y;o]00<000000:Bok@2T_nd0202T_nd0
0`000000Y;o]0:Bok@090:Bok@030000002T_nd0Y;o]00L0Y;o]1000000809gDn`8000002`2Me?/0
0`000000WMCk09gDn`0409gDn`<000000`1mh?L2000000T0ON3g0`00001T0?ooo`00HP3oool30?oo
00H0Wi34100000060::Nd0030000002RW]00XYk@00P0XYk@00<000000::Nd02RW]001P2RW]000`00
0000XYk@0::Nd0060::Nd0030000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`00
0000XYk@0::Nd0050::Nd0<000002@2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN
00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP040000002T[Mh0Y:gN
0:B]gP@000000`2T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<00000
0:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@040:Bok@<000000P2Me?/00`000000WMCk09gDn`09
09gDn`030000002Me?/0WMCk00T0WMCk00<0000009gDn`2Me?/00`00000807gPm`<000000`1mh?L3
000006L0oooo001R0?ooo`@0ool000<0Wi340000000000000P0000020::Nd0030000002RW]00XYk@
00H0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@
00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0040000002RW]00XYk@
0::Nd0@000000P2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<00000
0:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00H0Y:gN10000008
0:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@08
0:Bok@030000002T_nd0Y;o]00<000001P2Me?/2000000X0WMCk00<0000009gDn`2Me?/01`2Me?/4
000000d0ON3g1000001Z0?ooo`00H`3oool30?oo00030000002RW]00XYk@00@0XYk@00<000000::N
d02RW]001P2RW]000`000000XYk@0::Nd0080::Nd0030000002RW]00XYk@00H0XYk@00<000000::N
d02RW]001P2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@00D0XYk@1@0000070:B]
gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]
gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh00`2T[Mh200000080Y;o]00<000000:Bo
k@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bo
k@2T_nd01P2T_nd4000000/0WMCk00<0000009gDn`2Me?/0202Me?/2000000<0WMCk1000000407gP
m`@000001@1mh?L4000006h0oooo001S0?ooo`@0ool01`2RW]000`000000XYk@0::Nd0060::Nd003
0000002RW]00XYk@00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0060::Nd003
0000002RW]00XYk@00H0XYk@00@000000::Nd02RW]00XYk@100000030:B]gP030000002T[Mh0Y:gN
00H0Y:gN00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN
00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP03000000D0Y;o]00<000000:Bo
k@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00@000000:Bo
k@2T_nd0Y;o]1000000309gDn`8000002`2Me?/00`000000WMCk09gDn`0809gDn`@00000301mh?L5
00000780oooo001T0?ooo`<0ool01`2RW]000`000000XYk@0::Nd0070::Nd0030000002RW]00XYk@
00L0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@
00H0XYk@100000080:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`00
0000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01@2T[Mh40000
00T0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]
00L0Y;o]1000000909gDn`030000002Me?/0WMCk00T0WMCk0P00000609gDn`8000000`1mh?L40000
00D0ON3g1000001g0?ooo`00I03oool40?oo00L0XYk@00<000000::Nd02RW]001P2RW]000`000000
XYk@0::Nd0080::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001P2RW]000`000000
XYk@0::Nd0030::Nd08000000P2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0
Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00H0
Y:gN00@000000:B]gP2T[Mh0Y:gN100000030:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bo
k@2T_nd0202T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00@0Y;o]0`00000209gD
n`8000002P2Me?/2000000/0WMCk00<0000009gDn`2Me?/00`00000907gPm`D00000N`3oool006D0
oooo0`3oo`080::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001`2RW]000`000000
XYk@0::Nd0060::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]000`0000040:B]gP03
0000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP03
0000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01P2T[Mh4000000P0Y;o]00<000000:Bok@2T
_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T
_nd00`00000709gDn`030000002Me?/0WMCk00T0WMCk00<0000009gDn`2Me?/01`2Me?/4000000X0
ON3g0`00001o0?ooo`00I@3oool40?oo00L0XYk@00<000000::Nd02RW]001`2RW]000`000000XYk@
0::Nd0070::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]001@2RW]03000000P0Y:gN
00<000000:B]gP2T[Mh0202T[Mh00`000000Y:gN0:B]gP060:B]gP030000002T[Mh0Y:gN00L0Y:gN
00<000000:B]gP2T[Mh0202T[Mh010000000Y:gN0:B]gP2T[Mh400000080Y;o]00<000000:Bok@2T
_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T
_nd01P2T_nd3000000/0WMCk0P00000:09gDn`8000000`2Me?/4000000@0ON3g1000000307gPm`<0
0000PP3oool006H0oooo103oo`070::Nd0030000002RW]00XYk@00H0XYk@00<000000::Nd02RW]00
1`2RW]000`000000XYk@0::Nd0060::Nd0040000002RW]00XYk@0::Nd0@000000P2T[Mh00`000000
Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01P2T[Mh00`000000
Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN100000070:Bok@030000002T_nd0Y;o]00P0
Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@080:Bok@040000002T_nd0Y;o]0:Bo
k@@000000P2Me?/2000000`0WMCk00<0000009gDn`2Me?/01`2Me?/5000000`0ON3g0`0000250?oo
o`00I`3oool30?oo00P0XYk@00<000000::Nd02RW]001P2RW]000`000000XYk@0::Nd0070::Nd003
0000002RW]00XYk@00D0XYk@100000070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T
[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T
[Mh00`2T[Mh300000080Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd01P2T_nd5000000P0WMCk00<0000009gDn`2M
e?/02P2Me?/2000000<0WMCk1000000407gPm`@000001@1mh?L4000008P0oooo001W0?ooo`@0ool0
1`2RW]000`000000XYk@0::Nd0060::Nd0030000002RW]00XYk@00L0XYk@00@000000::Nd02RW]00
XYk@100000020:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000
Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01P2T[Mh00`000000
Y:gN0:B]gP03000000H0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00P0Y;o]00@000000:Bok@2T_nd0Y;o]1000000309gDn`8000002@2Me?/20000
00/0WMCk1000000<07gPm`D00000S03oool006P0oooo103oo`070::Nd0030000002RW]00XYk@00H0
XYk@00<000000::Nd02RW]001P2RW]04000000L0Y:gN00<000000:B]gP2T[Mh01P2T[Mh00`000000
Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00<000000:B]gP2T[Mh01P2T[Mh00`000000
Y:gN0:B]gP060:B]gP<000002P2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00P0
Y;o]00<000000:Bok@2T_nd01`2T_nd4000000T0WMCk00<0000009gDn`2Me?/0202Me?/00`000000
WMCk09gDn`0509gDn`<000000`1mh?L4000000D0ON3g1000002A0?ooo`00J@3oool30?oo00L0XYk@
00<000000::Nd02RW]001`2RW]000`000000XYk@0::Nd0030::Nd08000000P2T[Mh00`000000Y:gN
0:B]gP060:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN
0:B]gP080:B]gP030000002T[Mh0Y:gN00H0Y:gN00@000000:B]gP2T[Mh0Y:gN100000020:Bok@03
0000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00@0Y;o]0P00000209gDn`8000002P2Me?/2000000T0WMCk0P00000209gDn`<0
00002P1mh?L5000009D0oooo001Y0?ooo`@0ool01`2RW]000`000000XYk@0::Nd0060::Nd0030000
002RW]00XYk@00<00000102T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN
00<000000:B]gP2T[Mh01P2T[Mh00`000000Y:gN0:B]gP080:B]gP030000002T[Mh0Y:gN00H0Y:gN
100000070:Bok@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]
0:Bok@080:Bok@030000002T_nd0Y;o]00<000001P2Me?/00`000000WMCk09gDn`0909gDn`030000
002Me?/0WMCk00L0WMCk1000000;07gPm`800000V@3oool006X0oooo103oo`070::Nd0030000002R
W]00XYk@00D0XYk@0`0000080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01P2T
[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00P0Y:gN00@000000:B]gP2T[Mh0Y:gN
100000020:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]
0:Bok@070:Bok@030000002T_nd0Y;o]00H0Y;o]1000000:09gDn`8000002P2Me?/2000000<0WMCk
1000000407gPm`@00000101mh?L3000009/0oooo001[0?ooo`<0ool01`2RW]0010000000XYk@0::N
d02RW]0400000080Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP030000
002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP070:B]gP@00000
1`2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd0
1`2T_nd010000000Y;o]0:Bok@2T_nd4000000<0WMCk0P00000;09gDn`030000002Me?/0WMCk00L0
WMCk1@00000<07gPm`@00000WP3oool006/0oooo103oo`060::Nd0@000001`2T[Mh00`000000Y:gN
0:B]gP070:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN
0:B]gP070:B]gP030000002T[Mh0Y:gN00<0Y:gN0`0000020:Bok@030000002T_nd0Y;o]00L0Y;o]
00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@090:Bok@030000002T_nd0Y;o]00H0Y;o]
1000000909gDn`030000002Me?/0WMCk00T0WMCk0P00000309gDn`@00000101mh?L4000000D0ON3g
1000002R0?ooo`00K03oool40?oo00030::Nd00000000000008000000P2T[Mh00`000000Y:gN0:B]
gP060:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]
gP070:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T[Mh00`0000060:Bok@030000002T
_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@090:Bok@040000002T
_nd0Y;o]0:Bok@@000000P2Me?/2000000X0WMCk0P00000:09gDn`@00000301mh?L500000:H0oooo
001/0?ooo`@0ool000<000000:B]gP2T[Mh01@2T[Mh00`000000Y:gN0:B]gP060:B]gP030000002T
[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP060:B]gP030000002T
[Mh0Y:gN00H0Y:gN0`00000:0:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd01`2T
_nd00`000000Y;o]0:Bok@080:Bok@@00000202Me?/00`000000WMCk09gDn`0909gDn`030000002M
e?/0WMCk00D0WMCk0P00000407gPm`@000001@1mh?L400000:X0oooo001/0?ooo`D0ool01`2T[Mh0
0`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh0
0`000000Y:gN0:B]gP060:B]gP040000002T[Mh0Y:gN0:B]gP@000000P2T_nd00`000000Y;o]0:Bo
k@090:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bo
k@040:Bok@<000000P2Me?/2000000T0WMCk0P00000:09gDn`8000000P2Me?/3000000X0ON3g1@00
002^0?ooo`00KP3oool30?oo00P0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP06
0:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01P2T[Mh4000000L0Y;o]00<00000
0:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00L0Y;o]00<00000
0:Bok@2T_nd00`00000709gDn`030000002Me?/0WMCk00P0WMCk00<0000009gDn`2Me?/01`2Me?/6
000000L0ON3g1000002c0?ooo`00KP3oool40?oo00P0Y:gN00<000000:B]gP2T[Mh01P2T[Mh00`00
0000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00L0Y:gN00@000000:B]gP2T[Mh0Y:gN10000002
0:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd02@2T_nd00`000000Y;o]0:Bok@07
0:Bok@030000002T_nd0Y;o]00H0Y;o]0`00000;09gDn`8000002@2Me?/2000000<0WMCk10000006
07gPm`L00000]`3oool006l0oooo0`3oo`090:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]
gP2T[Mh01`2T[Mh00`000000Y:gN0:B]gP060:B]gP@000001`2T_nd00`000000Y;o]0:Bok@070:Bo
k@030000002T_nd0Y;o]00T0Y;o]00<000000:Bok@2T_nd01`2T_nd010000000Y;o]0:Bok@2T_nd4
00000080WMCk0P00000<09gDn`030000002Me?/0WMCk00L0WMCk1000000;07gPm`800000^`3oool0
06l0oooo103oo`080:B]gP030000002T[Mh0Y:gN00L0Y:gN00<000000:B]gP2T[Mh01`2T[Mh00`00
0000Y:gN0:B]gP030:B]gP8000000P2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]
00L0Y;o]0P00000:0:Bok@030000002T_nd0Y;o]00H0Y;o]1000000809gDn`8000002`2Me?/20000
00<0WMCk1000000407gPm`@00000101mh?L300000;d0oooo001`0?ooo`<0ool000<000000:B]gP2T
[Mh01P2T[Mh00`000000Y:gN0:B]gP070:B]gP030000002T[Mh0Y:gN00H0Y:gN00<000000:B]gP2T
[Mh00`0000050:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000
Y;o]0:Bok@080:Bok@040000002T_nd0Y;o]0:Bok@@000000P2Me?/2000000X0WMCk0P00000:09gD
n`@00000301mh?L400000<00oooo001`0?ooo`@0ool02@2T[Mh00`000000Y:gN0:B]gP060:B]gP03
0000002T[Mh0Y:gN00H0Y:gN0`0000090:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T
_nd0202T_nd00`000000Y;o]0:Bok@060:Bok@D00000202Me?/2000000X0WMCk0P00000409gDn`@0
0000101mh?L4000000D0ON3g100000330?ooo`00L@3oool40?oo00T0Y:gN00<000000:B]gP2T[Mh0
1P2T[Mh010000000Y:gN0:B]gP2T[Mh400000080Y;o]00<000000:Bok@2T_nd0202T_nd00`000000
Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00P0Y;o]00@000000:Bok@2T_nd0Y;o]1000000309gD
n`8000002P2Me?/00`000000WMCk09gDn`0909gDn`@00000301mh?L500000<L0oooo001b0?ooo`@0
ool0202T[Mh00`000000Y:gN0:B]gP060:B]gP@000001`2T_nd00`000000Y;o]0:Bok@080:Bok@03
0000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T_nd01`2T_nd4000000T0WMCk00<0000009gDn`2M
e?/0202Me?/2000000L0WMCk0P00000407gPm`@000001@1mh?L400000</0oooo001c0?ooo`<0ool0
00<000000:B]gP2T[Mh01P2T[Mh010000000Y:gN0:B]gP2T[Mh400000080Y;o]00<000000:Bok@2T
_nd01`2T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00L0Y;o]00<000000:Bok@2T
_nd0102T_nd200000080WMCk0P00000:09gDn`8000002P2Me?/200000080WMCk0`00000:07gPm`D0
0000c`3oool007<0oooo103oo`080:B]gP@000001`2T_nd00`000000Y;o]0:Bok@070:Bok@030000
002T_nd0Y;o]00P0Y;o]00<000000:Bok@2T_nd01`2T_nd00`000000Y;o]0:Bok@03000000H0WMCk
0P00000:09gDn`030000002Me?/0WMCk00L0WMCk1`00000707gPm`@00000d`3oool007@0oooo103o
o`030:B]gP@000000P2T_nd00`000000Y;o]0:Bok@070:Bok@030000002T_nd0Y;o]00L0Y;o]0P00
00090:Bok@030000002T_nd0Y;o]00H0Y;o]0`00000;09gDn`030000002Me?/0WMCk00P0WMCk0P00
000309gDn`@000001`1mh?L700000=L0oooo001e0?ooo`@0ool00P0000070:Bok@030000002T_nd0
Y;o]00L0Y;o]00<000000:Bok@2T_nd0202T_nd00`000000Y;o]0:Bok@070:Bok@040000002T_nd0
Y;o]0:Bok@@000000P2Me?/2000000/0WMCk0P00000909gDn`H000001`1mh?L400000=`0oooo001f
0?ooo`H0ool01`2T_nd00`000000Y;o]0:Bok@070:Bok@8000002@2T_nd00`000000Y;o]0:Bok@06
0:Bok@@00000202Me?/2000000/0WMCk0P00000309gDn`@000001P1mh?L700000>00oooo001g0?oo
o`D0ool0202T_nd00`000000Y;o]0:Bok@080:Bok@030000002T_nd0Y;o]00L0Y;o]00@000000:Bo
k@2T_nd0Y;o]1000000209gDn`8000002P2Me?/2000000X0WMCk1P00000707gPm`@00000i03oool0
07T0oooo103oo`080:Bok@8000002@2T_nd00`000000Y;o]0:Bok@060:Bok@@00000202Me?/20000
00X0WMCk0P00000409gDn`@000001P1mh?L700000>P0oooo001j0?ooo`@0ool02@2T_nd00`000000
Y;o]0:Bok@070:Bok@040000002T_nd0Y;o]0:Bok@@000000P2Me?/2000000X0WMCk0P00000:09gD
n`@000002`1mh?L200000>`0oooo001k0?ooo`D0ool0202T_nd00`000000Y;o]0:Bok@060:Bok@@0
0000202Me?/2000000X0WMCk0P00000409gDn`@00000101mh?L4000000@0ON3g0`00003^0?ooo`00
O03oool50?oo00P0Y;o]00@000000:Bok@2T_nd0Y;o]1000000209gDn`8000002P2Me?/2000000X0
WMCk1000000<07gPm`@00000l@3oool007d0oooo1@3oo`070:Bok@@00000202Me?/2000000X0WMCk
0P00000409gDn`@00000101mh?L5000000@0ON3g1000003d0?ooo`00OP3oool60?oo00030:Bok@00
00000000008000000P2Me?/2000000X0WMCk00<0000009gDn`2Me?/02@2Me?/4000000d0ON3g1000
003h0?ooo`00P03oool40?oo00030000002Me?/0WMCk00H0WMCk0P00000909gDn`8000001`2Me?/2
000000@0ON3g1@00000507gPm`@00000n`3oool00800oooo1P3oo`0909gDn`8000002@2Me?/20000
0080WMCk0`00000;07gPm`D00000o`3oool00880oooo1P3oo`0909gDn`800000202Me?/6000000P0
ON3g1000003o0?ooo`@0oooo00240?ooo`H0ool02@2Me?/200000080WMCk1000000607gPm`P00000
o`3oool80?ooo`00Q@3oool70?oo00P0WMCk1P00000707gPm`@00000o`3oool<0?ooo`00Q`3oool7
0?oo0080WMCk1000000607gPm`L00000o`3oool@0?ooo`00R@3oool50?oo00800000203oo`000`1m
h?L000000000000200000080ool0o`3ooolB0?ooo`00R`3oool=0?oo00030000003oo`00ool00080
ool0o`3ooolD0?ooo`00T03oool;0?oo0?l0oooo5P3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {398.75, 0}} -> {-0.000126583, 0.0131214, \
0.0033248, 0.0033248}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(helado;\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.53957e-017 1.06928 -0.0184111 1.14574 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 0 r
.007 w
[ ] 0 setdash
.60219 .66548 m
.58078 .66531 L
s
.5 Mabswid
.616 .135 .087 r
.5163 .65797 m .56975 .66479 L .57047 .66815 L p F P
0 g
s
.548 .086 .109 r
.56975 .66479 m .62431 .6645 L .62387 .66786 L p F P
0 g
s
1 1 0 r
.007 w
.56772 .66453 m
.57187 .66478 L
s
.5 Mabswid
.548 .086 .109 r
.62387 .66786 m .57047 .66815 L .56975 .66479 L p F P
0 g
s
.459 .01 .096 r
.62431 .6645 m .67796 .6571 L .67637 .66063 L p F P
0 g
s
.459 .01 .096 r
.67637 .66063 m .62387 .66786 L .62431 .6645 L p F P
0 g
s
1 1 0 r
.007 w
.62411 .6645 m
.62475 .66444 L
s
.51772 .65825 m
.51824 .65834 L
s
.51739 .65818 m
.51772 .65825 L
s
.5 Mabswid
.666 .158 .026 r
.46603 .64424 m .5163 .65797 L .51818 .66148 L p F P
0 g
s
.616 .135 .087 r
.57047 .66815 m .51818 .66148 L .5163 .65797 L p F P
0 g
s
1 1 0 r
.007 w
.51556 .65777 m
.5167 .65802 L
s
.5 Mabswid
.592 .09 .03 r
.51818 .66148 m .57047 .66815 L .57123 .67119 L p F P
0 g
s
.523 .041 .054 r
.57047 .66815 m .62387 .66786 L .6234 .67091 L p F P
0 g
s
.523 .041 .054 r
.6234 .67091 m .57123 .67119 L .57047 .66815 L p F P
0 g
s
.429 0 .039 r
.62387 .66786 m .67637 .66063 L .67468 .66385 L p F P
0 g
s
.429 0 .039 r
.67468 .66385 m .6234 .67091 L .62387 .66786 L p F P
0 g
s
.335 0 .044 r
.67796 .6571 m .72863 .64281 L .72594 .64667 L p F P
0 g
s
.335 0 .044 r
.72594 .64667 m .67637 .66063 L .67796 .6571 L p F P
0 g
s
1 1 0 r
.007 w
.6758 .6574 m
.67973 .6566 L
s
.5 Mabswid
.666 .158 .026 r
.51818 .66148 m .469 .64806 L .46603 .64424 L p F P
0 g
s
.638 .11 0 r
.469 .64806 m .51818 .66148 L .52014 .66469 L p F P
0 g
s
.592 .09 .03 r
.57123 .67119 m .52014 .66469 L .51818 .66148 L p F P
0 g
s
.562 .039 0 r
.52014 .66469 m .57123 .67119 L .57202 .67392 L p F P
0 g
s
.493 0 0 r
.57123 .67119 m .6234 .67091 L .6229 .67364 L p F P
0 g
s
.493 0 0 r
.6229 .67364 m .57202 .67392 L .57123 .67119 L p F P
0 g
s
.299 0 0 r
.67637 .66063 m .72594 .64667 L .72309 .65023 L p F P
0 g
s
.299 0 0 r
.72309 .65023 m .67468 .66385 L .67637 .66063 L p F P
0 g
s
.395 0 0 r
.6234 .67091 m .67468 .66385 L .67291 .66677 L p F P
0 g
s
.395 0 0 r
.67291 .66677 m .6229 .67364 L .6234 .67091 L p F P
0 g
s
.687 .149 0 r
.42092 .62399 m .46603 .64424 L .469 .64806 L p F P
0 g
s
1 1 0 r
.007 w
.46454 .64357 m
.46805 .64479 L
s
.5 Mabswid
.638 .11 0 r
.52014 .66469 m .47212 .6516 L .469 .64806 L p F P
0 g
s
.603 .055 0 r
.47212 .6516 m .52014 .66469 L .5222 .66758 L p F P
0 g
s
.562 .039 0 r
.57202 .67392 m .5222 .66758 L .52014 .66469 L p F P
0 g
s
.154 0 0 r
.72863 .64281 m .77431 .62205 L .7706 .62639 L p F P
0 g
s
.154 0 0 r
.7706 .62639 m .72594 .64667 L .72863 .64281 L p F P
0 g
s
1 1 0 r
.007 w
.7279 .64301 m
.72979 .64228 L
s
.5 Mabswid
.257 0 0 r
.67468 .66385 m .72309 .65023 L .7201 .65351 L p F P
0 g
s
.257 0 0 r
.7201 .65351 m .67291 .66677 L .67468 .66385 L p F P
0 g
s
.525 0 0 r
.5222 .66758 m .57202 .67392 L .57283 .67632 L p F P
0 g
s
.457 0 0 r
.57202 .67392 m .6229 .67364 L .62237 .67605 L p F P
0 g
s
.457 0 0 r
.62237 .67605 m .57283 .67632 L .57202 .67392 L p F P
0 g
s
.355 0 0 r
.6229 .67364 m .67291 .66677 L .67105 .66937 L p F P
0 g
s
.355 0 0 r
.67105 .66937 m .62237 .67605 L .6229 .67364 L p F P
0 g
s
.687 .149 0 r
.469 .64806 m .4249 .62829 L .42092 .62399 L p F P
0 g
s
.649 .093 0 r
.4249 .62829 m .469 .64806 L .47212 .6516 L p F P
0 g
s
.603 .055 0 r
.5222 .66758 m .47538 .65484 L .47212 .6516 L p F P
0 g
s
.561 0 0 r
.47538 .65484 m .5222 .66758 L .52434 .67016 L p F P
0 g
s
.525 0 0 r
.57283 .67632 m .52434 .67016 L .5222 .66758 L p F P
0 g
s
.106 0 0 r
.72594 .64667 m .7706 .62639 L .76668 .63047 L p F P
0 g
s
.106 0 0 r
.76668 .63047 m .72309 .65023 L .72594 .64667 L p F P
0 g
s
.208 0 0 r
.67291 .66677 m .7201 .65351 L .71697 .65648 L p F P
0 g
s
.208 0 0 r
.71697 .65648 m .67105 .66937 L .67291 .66677 L p F P
0 g
s
.482 0 0 r
.52434 .67016 m .57283 .67632 L .57368 .6784 L p F P
0 g
s
.414 0 0 r
.57283 .67632 m .62237 .67605 L .62181 .67814 L p F P
0 g
s
.414 0 0 r
.62181 .67814 m .57368 .6784 L .57283 .67632 L p F P
0 g
s
.309 0 0 r
.62237 .67605 m .67105 .66937 L .6691 .67165 L p F P
0 g
s
.309 0 0 r
.6691 .67165 m .62181 .67814 L .62237 .67605 L p F P
0 g
s
.649 .093 0 r
.47212 .6516 m .42908 .63232 L .4249 .62829 L p F P
0 g
s
.602 .031 0 r
.42908 .63232 m .47212 .6516 L .47538 .65484 L p F P
0 g
s
.052 0 0 r
.72309 .65023 m .76668 .63047 L .76257 .63427 L p F P
0 g
s
.052 0 0 r
.76257 .63427 m .7201 .65351 L .72309 .65023 L p F P
0 g
s
.561 0 0 r
.52434 .67016 m .47878 .65777 L .47538 .65484 L p F P
0 g
s
.512 0 0 r
.47878 .65777 m .52434 .67016 L .52657 .67242 L p F P
0 g
s
.482 0 0 r
.57368 .6784 m .52657 .67242 L .52434 .67016 L p F P
0 g
s
.154 0 0 r
.67105 .66937 m .71697 .65648 L .71369 .65914 L p F P
0 g
s
.154 0 0 r
.71369 .65914 m .6691 .67165 L .67105 .66937 L p F P
0 g
s
.431 0 0 r
.52657 .67242 m .57368 .6784 L .57456 .68014 L p F P
0 g
s
.364 0 0 r
.57368 .6784 m .62181 .67814 L .62122 .67989 L p F P
0 g
s
.364 0 0 r
.62122 .67989 m .57456 .68014 L .57368 .6784 L p F P
0 g
s
.255 0 0 r
.62181 .67814 m .6691 .67165 L .66706 .67361 L p F P
0 g
s
.255 0 0 r
.66706 .67361 m .62122 .67989 L .62181 .67814 L p F P
0 g
s
.641 .09 0 r
.38292 .59787 m .42092 .62399 L .4249 .62829 L p F P
0 g
s
1 1 0 r
.007 w
.41981 .62323 m
.42172 .62435 L
s
.5 Mabswid
.602 .031 0 r
.47538 .65484 m .43345 .63606 L .42908 .63232 L p F P
0 g
s
.547 0 0 r
.43345 .63606 m .47538 .65484 L .47878 .65777 L p F P
0 g
s
0 0 0 r
.77431 .62205 m .81304 .59548 L .80843 .60046 L p F P
0 g
s
0 0 0 r
.80843 .60046 m .7706 .62639 L .77431 .62205 L p F P
0 g
s
1 1 0 r
.007 w
.77253 .62286 m
.77542 .62129 L
s
.5 Mabswid
0 0 0 r
.7201 .65351 m .76257 .63427 L .75827 .63778 L p F P
0 g
s
0 0 0 r
.75827 .63778 m .71697 .65648 L .7201 .65351 L p F P
0 g
s
.512 0 0 r
.52657 .67242 m .48233 .66039 L .47878 .65777 L p F P
0 g
s
.453 0 0 r
.48233 .66039 m .52657 .67242 L .52889 .67435 L p F P
0 g
s
.431 0 0 r
.57456 .68014 m .52889 .67435 L .52657 .67242 L p F P
0 g
s
.093 0 0 r
.6691 .67165 m .71369 .65914 L .71028 .66149 L p F P
0 g
s
.093 0 0 r
.71028 .66149 m .66706 .67361 L .6691 .67165 L p F P
0 g
s
.37 0 0 r
.52889 .67435 m .57456 .68014 L .57546 .68155 L p F P
0 g
s
.305 0 0 r
.57456 .68014 m .62122 .67989 L .6206 .68131 L p F P
0 g
s
.305 0 0 r
.6206 .68131 m .57546 .68155 L .57456 .68014 L p F P
0 g
s
.193 0 0 r
.62122 .67989 m .66706 .67361 L .66494 .67523 L p F P
0 g
s
.193 0 0 r
.66494 .67523 m .6206 .68131 L .62122 .67989 L p F P
0 g
s
.641 .09 0 r
.4249 .62829 m .38778 .60279 L .38292 .59787 L p F P
0 g
s
.582 .023 0 r
.38778 .60279 m .4249 .62829 L .42908 .63232 L p F P
0 g
s
.547 0 0 r
.47878 .65777 m .43801 .63953 L .43345 .63606 L p F P
0 g
s
.484 0 0 r
.43801 .63953 m .47878 .65777 L .48233 .66039 L p F P
0 g
s
0 0 0 r
.7706 .62639 m .80843 .60046 L .80358 .60519 L p F P
0 g
s
0 0 0 r
.80358 .60519 m .76668 .63047 L .7706 .62639 L p F P
0 g
s
0 0 0 r
.71697 .65648 m .75827 .63778 L .75378 .641 L p F P
0 g
s
0 0 0 r
.75378 .641 m .71369 .65914 L .71697 .65648 L p F P
0 g
s
.453 0 0 r
.52889 .67435 m .48601 .6627 L .48233 .66039 L p F P
0 g
s
.385 0 0 r
.48601 .6627 m .52889 .67435 L .53129 .67595 L p F P
0 g
s
.37 0 0 r
.57546 .68155 m .53129 .67595 L .52889 .67435 L p F P
0 g
s
.027 0 0 r
.66706 .67361 m .71028 .66149 L .70673 .66352 L p F P
0 g
s
.027 0 0 r
.70673 .66352 m .66494 .67523 L .66706 .67361 L p F P
0 g
s
.301 0 0 r
.53129 .67595 m .57546 .68155 L .57639 .68261 L p F P
0 g
s
.239 0 0 r
.57546 .68155 m .6206 .68131 L .61995 .68238 L p F P
0 g
s
.239 0 0 r
.61995 .68238 m .57639 .68261 L .57546 .68155 L p F P
0 g
s
.125 0 0 r
.6206 .68131 m .66494 .67523 L .66274 .67652 L p F P
0 g
s
.125 0 0 r
.66274 .67652 m .61995 .68238 L .6206 .68131 L p F P
0 g
s
.582 .023 0 r
.42908 .63232 m .39287 .60747 L .38778 .60279 L p F P
0 g
s
.516 0 0 r
.39287 .60747 m .42908 .63232 L .43345 .63606 L p F P
0 g
s
0 0 0 r
.76668 .63047 m .80358 .60519 L .79849 .60967 L p F P
0 g
s
0 0 0 r
.79849 .60967 m .76257 .63427 L .76668 .63047 L p F P
0 g
s
.484 0 0 r
.48233 .66039 m .44276 .6427 L .43801 .63953 L p F P
0 g
s
.412 0 0 r
.44276 .6427 m .48233 .66039 L .48601 .6627 L p F P
0 g
s
0 0 0 r
.71369 .65914 m .75378 .641 L .7491 .64393 L p F P
0 g
s
0 0 0 r
.7491 .64393 m .71028 .66149 L .71369 .65914 L p F P
0 g
s
.385 0 0 r
.53129 .67595 m .48983 .66469 L .48601 .6627 L p F P
0 g
s
.309 0 0 r
.48983 .66469 m .53129 .67595 L .53377 .67721 L p F P
0 g
s
.301 0 0 r
.57639 .68261 m .53377 .67721 L .53129 .67595 L p F P
0 g
s
0 0 0 r
.66494 .67523 m .70673 .66352 L .70304 .66523 L p F P
0 g
s
0 0 0 r
.70304 .66523 m .66274 .67652 L .66494 .67523 L p F P
0 g
s
.516 0 0 r
.43345 .63606 m .39821 .61188 L .39287 .60747 L p F P
0 g
s
.443 0 0 r
.39821 .61188 m .43345 .63606 L .43801 .63953 L p F P
0 g
s
.224 0 0 r
.53377 .67721 m .57639 .68261 L .57735 .68333 L p F P
0 g
s
.164 0 0 r
.57639 .68261 m .61995 .68238 L .61928 .6831 L p F P
0 g
s
.164 0 0 r
.61928 .6831 m .57735 .68333 L .57639 .68261 L p F P
0 g
s
.051 0 0 r
.61995 .68238 m .66274 .67652 L .66045 .67747 L p F P
0 g
s
.051 0 0 r
.66045 .67747 m .61928 .6831 L .61995 .68238 L p F P
0 g
s
0 0 0 r
.76257 .63427 m .79849 .60967 L .79316 .61389 L p F P
0 g
s
0 0 0 r
.79316 .61389 m .75827 .63778 L .76257 .63427 L p F P
0 g
s
.412 0 0 r
.48601 .6627 m .44769 .64557 L .44276 .6427 L p F P
0 g
s
.333 0 0 r
.44769 .64557 m .48601 .6627 L .48983 .66469 L p F P
0 g
s
0 0 0 r
.71028 .66149 m .7491 .64393 L .74423 .64656 L p F P
0 g
s
0 0 0 r
.74423 .64656 m .70673 .66352 L .71028 .66149 L p F P
0 g
s
.309 0 0 r
.53377 .67721 m .49379 .66636 L .48983 .66469 L p F P
0 g
s
.227 0 0 r
.49379 .66636 m .53377 .67721 L .53633 .67813 L p F P
0 g
s
.224 0 0 r
.57735 .68333 m .53633 .67813 L .53377 .67721 L p F P
0 g
s
0 .038 .539 r
.35382 .56676 m .38292 .59787 L .38778 .60279 L p F P
0 g
s
1 1 0 r
.007 w
.37931 .59473 m
.38216 .59706 L
s
.3831 .59783 m
.38435 .59886 L
s
.5 Mabswid
0 0 0 r
.66274 .67652 m .70304 .66523 L .69922 .66661 L p F P
0 g
s
0 0 0 r
.69922 .66661 m .66045 .67747 L .66274 .67652 L p F P
0 g
s
.443 0 0 r
.43801 .63953 m .40377 .61604 L .39821 .61188 L p F P
0 g
s
0 .19 .611 r
.40377 .61604 m .43801 .63953 L .44276 .6427 L p F P
0 g
s
.141 0 0 r
.53633 .67813 m .57735 .68333 L .57833 .68369 L p F P
0 g
s
.084 0 0 r
.57735 .68333 m .61928 .6831 L .61857 .68348 L p F P
0 g
s
.084 0 0 r
.61857 .68348 m .57833 .68369 L .57735 .68333 L p F P
0 g
s
0 0 0 r
.75827 .63778 m .79316 .61389 L .78761 .61784 L p F P
0 g
s
0 0 0 r
.78761 .61784 m .75378 .641 L .75827 .63778 L p F P
0 g
s
0 0 0 r
.61928 .6831 m .66045 .67747 L .65809 .67807 L p F P
0 g
s
0 0 0 r
.65809 .67807 m .61857 .68348 L .61928 .6831 L p F P
0 g
s
0 0 0 r
.81304 .59548 m .84298 .56401 L .83764 .56975 L p F P
0 g
s
0 0 0 r
.83764 .56975 m .80843 .60046 L .81304 .59548 L p F P
0 g
s
1 1 0 r
.007 w
.81212 .59611 m
.81409 .59438 L
s
.5 Mabswid
.333 0 0 r
.48983 .66469 m .45281 .64814 L .44769 .64557 L p F P
0 g
s
0 .33 .673 r
.45281 .64814 m .48983 .66469 L .49379 .66636 L p F P
0 g
s
0 0 0 r
.70673 .66352 m .74423 .64656 L .73919 .64888 L p F P
0 g
s
0 0 0 r
.73919 .64888 m .70304 .66523 L .70673 .66352 L p F P
0 g
s
0 .038 .539 r
.38778 .60279 m .35939 .57244 L .35382 .56676 L p F P
0 g
s
0 .106 .607 r
.35939 .57244 m .38778 .60279 L .39287 .60747 L p F P
0 g
s
0 .19 .611 r
.44276 .6427 m .40957 .61992 L .40377 .61604 L p F P
0 g
s
0 .259 .681 r
.40957 .61992 m .44276 .6427 L .44769 .64557 L p F P
0 g
s
.227 0 0 r
.53633 .67813 m .49787 .66769 L .49379 .66636 L p F P
0 g
s
.141 0 0 r
.57833 .68369 m .53897 .67871 L .53633 .67813 L p F P
0 g
s
0 .445 .716 r
.49787 .66769 m .53633 .67813 L .53897 .67871 L p F P
0 g
s
.191 .715 .698 r
.66045 .67747 m .69922 .66661 L .69527 .66765 L p F P
0 g
s
.191 .715 .698 r
.69527 .66765 m .65809 .67807 L .66045 .67747 L p F P
0 g
s
.531 .852 .558 r
.80843 .60046 m .83764 .56975 L .83203 .57528 L p F P
0 g
s
1 1 0 r
.007 w
.81486 .59371 m
.81706 .59176 L
s
.5 Mabswid
.531 .852 .558 r
.83203 .57528 m .80358 .60519 L .80843 .60046 L p F P
0 g
s
1 1 0 r
.007 w
.81706 .59176 m
.82294 .58659 L
s
.5 Mabswid
.417 .83 .644 r
.75378 .641 m .78761 .61784 L .78183 .62152 L p F P
0 g
s
.417 .83 .644 r
.78183 .62152 m .7491 .64393 L .75378 .641 L p F P
0 g
s
0 0 0 r
.57833 .68369 m .61857 .68348 L .61784 .6835 L p F P
0 g
s
0 0 0 r
.61784 .6835 m .57934 .6837 L .57833 .68369 L p F P
0 g
s
0 .529 .729 r
.53897 .67871 m .57833 .68369 L .57934 .6837 L p F P
0 g
s
.107 .66 .72 r
.61857 .68348 m .65809 .67807 L .65564 .67832 L p F P
0 g
s
.107 .66 .72 r
.65564 .67832 m .61784 .6835 L .61857 .68348 L p F P
0 g
s
0 .33 .673 r
.49379 .66636 m .4581 .65041 L .45281 .64814 L p F P
0 g
s
0 .398 .745 r
.4581 .65041 m .49379 .66636 L .49787 .66769 L p F P
0 g
s
.332 .803 .72 r
.70304 .66523 m .73919 .64888 L .73397 .65089 L p F P
0 g
s
.332 .803 .72 r
.73397 .65089 m .69922 .66661 L .70304 .66523 L p F P
0 g
s
0 .106 .607 r
.39287 .60747 m .36523 .5779 L .35939 .57244 L p F P
0 g
s
0 .171 .668 r
.36523 .5779 m .39287 .60747 L .39821 .61188 L p F P
0 g
s
1 1 0 r
.007 w
.36715 .58287 m
.36979 .58545 L
s
.36979 .58545 m
.37931 .59473 L
s
.5 Mabswid
0 .259 .681 r
.44769 .64557 m .41558 .62354 L .40957 .61992 L p F P
0 g
s
0 .324 .744 r
.41558 .62354 m .44769 .64557 L .45281 .64814 L p F P
0 g
s
.576 .893 .625 r
.80358 .60519 m .83203 .57528 L .82614 .58059 L p F P
0 g
s
.576 .893 .625 r
.82614 .58059 m .79849 .60967 L .80358 .60519 L p F P
0 g
s
1 1 0 r
.007 w
.36485 .58017 m
.36715 .58287 L
s
.35649 .57033 m
.36485 .58017 L
s
.5 Mabswid
0 .445 .716 r
.53897 .67871 m .50208 .66869 L .49787 .66769 L p F P
0 g
s
0 .512 .789 r
.50208 .66869 m .53897 .67871 L .54169 .67894 L p F P
0 g
s
0 .529 .729 r
.57934 .6837 m .54169 .67894 L .53897 .67871 L p F P
0 g
s
.468 .873 .712 r
.7491 .64393 m .78183 .62152 L .77582 .62492 L p F P
0 g
s
.468 .873 .712 r
.77582 .62492 m .74423 .64656 L .7491 .64393 L p F P
0 g
s
.261 .769 .773 r
.65809 .67807 m .69527 .66765 L .6912 .66836 L p F P
0 g
s
.261 .769 .773 r
.6912 .66836 m .65564 .67832 L .65809 .67807 L p F P
0 g
s
.032 .593 .804 r
.54169 .67894 m .57934 .6837 L .58038 .68335 L p F P
0 g
s
.084 .642 .783 r
.57934 .6837 m .61784 .6835 L .61709 .68316 L p F P
0 g
s
.084 .642 .783 r
.61709 .68316 m .58038 .68335 L .57934 .6837 L p F P
0 g
s
0 .171 .668 r
.39821 .61188 m .37134 .58313 L .36523 .5779 L p F P
0 g
s
0 .233 .722 r
.37134 .58313 m .39821 .61188 L .40377 .61604 L p F P
0 g
s
0 .398 .745 r
.49787 .66769 m .46357 .65236 L .4581 .65041 L p F P
0 g
s
0 .461 .807 r
.46357 .65236 m .49787 .66769 L .50208 .66869 L p F P
0 g
s
.185 .718 .796 r
.61784 .6835 m .65564 .67832 L .65312 .67822 L p F P
0 g
s
.185 .718 .796 r
.65312 .67822 m .61709 .68316 L .61784 .6835 L p F P
0 g
s
.39 .846 .786 r
.69922 .66661 m .73397 .65089 L .72858 .65258 L p F P
0 g
s
.39 .846 .786 r
.72858 .65258 m .69527 .66765 L .69922 .66661 L p F P
0 g
s
.615 .927 .686 r
.79849 .60967 m .82614 .58059 L .81999 .58566 L p F P
0 g
s
1 1 0 r
.007 w
.82294 .58659 m
.83472 .57425 L
s
.5 Mabswid
.615 .927 .686 r
.81999 .58566 m .79316 .61389 L .79849 .60967 L p F P
0 g
s
0 .324 .744 r
.45281 .64814 m .42182 .62687 L .41558 .62354 L p F P
0 g
s
0 .384 .798 r
.42182 .62687 m .45281 .64814 L .4581 .65041 L p F P
0 g
s
.514 .906 .772 r
.74423 .64656 m .77582 .62492 L .7696 .62804 L p F P
0 g
s
.514 .906 .772 r
.7696 .62804 m .73919 .64888 L .74423 .64656 L p F P
0 g
s
0 .512 .789 r
.54169 .67894 m .50642 .66936 L .50208 .66869 L p F P
0 g
s
.033 .57 .849 r
.50642 .66936 m .54169 .67894 L .54448 .67881 L p F P
0 g
s
.032 .593 .804 r
.58038 .68335 m .54448 .67881 L .54169 .67894 L p F P
0 g
s
.327 .812 .837 r
.65564 .67832 m .6912 .66836 L .687 .66873 L p F P
0 g
s
.327 .812 .837 r
.687 .66873 m .65312 .67822 L .65564 .67832 L p F P
0 g
s
1 1 0 r
.007 w
.83472 .57425 m
.8396 .56808 L
s
.8396 .56808 m
.84186 .56522 L
s
.5 Mabswid
0 .233 .722 r
.40377 .61604 m .37771 .58813 L .37134 .58313 L p F P
0 g
s
0 .29 .77 r
.37771 .58813 m .40377 .61604 L .40957 .61992 L p F P
0 g
s
0 .461 .807 r
.50208 .66869 m .4692 .65399 L .46357 .65236 L p F P
0 g
s
.003 .517 .859 r
.4692 .65399 m .50208 .66869 L .50642 .66936 L p F P
0 g
s
.115 .648 .865 r
.54448 .67881 m .58038 .68335 L .58144 .68264 L p F P
0 g
s
.164 .696 .85 r
.58038 .68335 m .61709 .68316 L .6163 .68245 L p F P
0 g
s
.164 .696 .85 r
.6163 .68245 m .58144 .68264 L .58038 .68335 L p F P
0 g
s
.258 .765 .859 r
.61709 .68316 m .65312 .67822 L .65052 .67777 L p F P
0 g
s
.258 .765 .859 r
.65052 .67777 m .6163 .68245 L .61709 .68316 L p F P
0 g
s
.648 .952 .739 r
.79316 .61389 m .81999 .58566 L .81358 .59049 L p F P
0 g
s
.648 .952 .739 r
.81358 .59049 m .78761 .61784 L .79316 .61389 L p F P
0 g
s
.442 .879 .842 r
.69527 .66765 m .72858 .65258 L .72302 .65396 L p F P
0 g
s
.442 .879 .842 r
.72302 .65396 m .6912 .66836 L .69527 .66765 L p F P
0 g
s
0 .384 .798 r
.4581 .65041 m .42827 .62991 L .42182 .62687 L p F P
0 g
s
0 .438 .844 r
.42827 .62991 m .4581 .65041 L .46357 .65236 L p F P
0 g
s
1 1 0 r
.007 w
.35459 .56759 m
.35649 .57033 L
s
.5 Mabswid
.554 .931 .823 r
.73919 .64888 m .7696 .62804 L .76317 .63087 L p F P
0 g
s
.554 .931 .823 r
.76317 .63087 m .73397 .65089 L .73919 .64888 L p F P
0 g
s
0 .29 .77 r
.40957 .61992 m .38434 .59288 L .37771 .58813 L p F P
0 g
s
0 .343 .81 r
.38434 .59288 m .40957 .61992 L .41558 .62354 L p F P
0 g
s
.033 .57 .849 r
.54448 .67881 m .51087 .66968 L .50642 .66936 L p F P
0 g
s
.113 .62 .898 r
.51087 .66968 m .54448 .67881 L .54735 .67832 L p F P
0 g
s
.115 .648 .865 r
.58144 .68264 m .54735 .67832 L .54448 .67881 L p F P
0 g
s
0 .192 .722 r
.33524 .5318 m .35382 .56676 L .35939 .57244 L p F P
0 g
s
.385 .844 .889 r
.65312 .67822 m .687 .66873 L .68268 .66875 L p F P
0 g
s
.385 .844 .889 r
.68268 .66875 m .65052 .67777 L .65312 .67822 L p F P
0 g
s
.675 .97 .786 r
.78761 .61784 m .81358 .59049 L .80691 .59507 L p F P
0 g
s
.675 .97 .786 r
.80691 .59507 m .78183 .62152 L .78761 .61784 L p F P
0 g
s
.003 .517 .859 r
.50642 .66936 m .47501 .6553 L .4692 .65399 L p F P
0 g
s
.081 .565 .9 r
.47501 .6553 m .50642 .66936 L .51087 .66968 L p F P
0 g
s
.789 .975 .689 r
.84298 .56401 m .86248 .52879 L .85662 .53542 L p F P
0 g
s
.789 .975 .689 r
.85662 .53542 m .83764 .56975 L .84298 .56401 L p F P
0 g
s
1 1 0 r
.007 w
.84338 .56329 m
.84497 .56127 L
s
.5 Mabswid
.487 .901 .888 r
.6912 .66836 m .72302 .65396 L .71729 .655 L p F P
0 g
s
.487 .901 .888 r
.71729 .655 m .687 .66873 L .6912 .66836 L p F P
0 g
s
0 .438 .844 r
.46357 .65236 m .43493 .63266 L .42827 .62991 L p F P
0 g
s
.031 .487 .881 r
.43493 .63266 m .46357 .65236 L .4692 .65399 L p F P
0 g
s
.193 .692 .913 r
.54735 .67832 m .58144 .68264 L .58252 .68156 L p F P
0 g
s
.239 .739 .903 r
.58144 .68264 m .6163 .68245 L .61549 .68139 L p F P
0 g
s
.239 .739 .903 r
.61549 .68139 m .58252 .68156 L .58144 .68264 L p F P
0 g
s
.324 .8 .909 r
.6163 .68245 m .65052 .67777 L .64785 .67695 L p F P
0 g
s
.324 .8 .909 r
.64785 .67695 m .61549 .68139 L .6163 .68245 L p F P
0 g
s
.586 .946 .865 r
.73397 .65089 m .76317 .63087 L .75653 .6334 L p F P
0 g
s
.586 .946 .865 r
.75653 .6334 m .72858 .65258 L .73397 .65089 L p F P
0 g
s
0 .343 .81 r
.41558 .62354 m .39122 .59738 L .38434 .59288 L p F P
0 g
s
0 .391 .844 r
.39122 .59738 m .41558 .62354 L .42182 .62687 L p F P
0 g
s
0 .192 .722 r
.35939 .57244 m .34131 .53836 L .33524 .5318 L p F P
0 g
s
0 .242 .758 r
.34131 .53836 m .35939 .57244 L .36523 .5779 L p F P
0 g
s
1 1 0 r
.007 w
.34742 .55718 m
.35116 .56261 L
s
.35116 .56261 m
.35314 .56547 L
s
.5 Mabswid
.697 .982 .824 r
.78183 .62152 m .80691 .59507 L .79999 .59941 L p F P
0 g
s
.697 .982 .824 r
.79999 .59941 m .77582 .62492 L .78183 .62152 L p F P
0 g
s
.113 .62 .898 r
.54735 .67832 m .51545 .66965 L .51087 .66968 L p F P
0 g
s
.187 .66 .935 r
.51545 .66965 m .54735 .67832 L .55028 .67748 L p F P
0 g
s
.193 .692 .913 r
.58252 .68156 m .55028 .67748 L .54735 .67832 L p F P
0 g
s
.805 .988 .731 r
.83764 .56975 m .85662 .53542 L .85047 .54186 L p F P
0 g
s
.805 .988 .731 r
.85047 .54186 m .83203 .57528 L .83764 .56975 L p F P
0 g
s
.436 .866 .928 r
.65052 .67777 m .68268 .66875 L .67824 .66842 L p F P
0 g
s
.436 .866 .928 r
.67824 .66842 m .64785 .67695 L .65052 .67777 L p F P
0 g
s
.081 .565 .9 r
.51087 .66968 m .48097 .65628 L .47501 .6553 L p F P
0 g
s
.152 .605 .931 r
.48097 .65628 m .51087 .66968 L .51545 .66965 L p F P
0 g
s
.031 .487 .881 r
.4692 .65399 m .44179 .63512 L .43493 .63266 L p F P
0 g
s
.099 .528 .91 r
.44179 .63512 m .4692 .65399 L .47501 .6553 L p F P
0 g
s
.525 .914 .922 r
.687 .66873 m .71729 .655 L .71141 .65572 L p F P
0 g
s
.525 .914 .922 r
.71141 .65572 m .68268 .66875 L .687 .66873 L p F P
0 g
s
0 .242 .758 r
.36523 .5779 m .34767 .54472 L .34131 .53836 L p F P
0 g
s
1 1 0 r
.007 w
.34003 .54348 m
.34742 .55718 L
s
.5 Mabswid
0 .289 .789 r
.34767 .54472 m .36523 .5779 L .37134 .58313 L p F P
0 g
s
.613 .955 .898 r
.72858 .65258 m .75653 .6334 L .74969 .63563 L p F P
0 g
s
.613 .955 .898 r
.74969 .63563 m .72302 .65396 L .72858 .65258 L p F P
0 g
s
.263 .726 .949 r
.55028 .67748 m .58252 .68156 L .58362 .68012 L p F P
0 g
s
.306 .771 .942 r
.58252 .68156 m .61549 .68139 L .61466 .67995 L p F P
0 g
s
.306 .771 .942 r
.61466 .67995 m .58362 .68012 L .58252 .68156 L p F P
0 g
s
0 .391 .844 r
.42182 .62687 m .39835 .60163 L .39122 .59738 L p F P
0 g
s
.046 .434 .871 r
.39835 .60163 m .42182 .62687 L .42827 .62991 L p F P
0 g
s
.381 .825 .946 r
.61549 .68139 m .64785 .67695 L .64511 .67578 L p F P
0 g
s
.381 .825 .946 r
.64511 .67578 m .61466 .67995 L .61549 .68139 L p F P
0 g
s
.713 .987 .857 r
.77582 .62492 m .79999 .59941 L .79283 .60348 L p F P
0 g
s
.713 .987 .857 r
.79283 .60348 m .7696 .62804 L .77582 .62492 L p F P
0 g
s
.816 .996 .767 r
.83203 .57528 m .85047 .54186 L .84402 .54811 L p F P
0 g
s
1 1 0 r
.007 w
.85198 .55026 m
.8536 .54774 L
s
.84497 .56127 m
.85198 .55026 L
s
.5 Mabswid
.816 .996 .767 r
.84402 .54811 m .82614 .58059 L .83203 .57528 L p F P
0 g
s
.187 .66 .935 r
.55028 .67748 m .52013 .66928 L .51545 .66965 L p F P
0 g
s
.254 .691 .961 r
.52013 .66928 m .55028 .67748 L .55329 .67627 L p F P
0 g
s
.263 .726 .949 r
.58362 .68012 m .55329 .67627 L .55028 .67748 L p F P
0 g
s
.479 .879 .957 r
.64785 .67695 m .67824 .66842 L .6737 .66775 L p F P
0 g
s
.479 .879 .957 r
.6737 .66775 m .64511 .67578 L .64785 .67695 L p F P
0 g
s
0 .289 .789 r
.37134 .58313 m .35432 .55088 L .34767 .54472 L p F P
0 g
s
.015 .331 .815 r
.35432 .55088 m .37134 .58313 L .37771 .58813 L p F P
0 g
s
.099 .528 .91 r
.47501 .6553 m .44884 .63727 L .44179 .63512 L p F P
0 g
s
.161 .564 .932 r
.44884 .63727 m .47501 .6553 L .48097 .65628 L p F P
0 g
s
.152 .605 .931 r
.51545 .66965 m .48708 .65694 L .48097 .65628 L p F P
0 g
s
.217 .638 .954 r
.48708 .65694 m .51545 .66965 L .52013 .66928 L p F P
0 g
s
.046 .434 .871 r
.42827 .62991 m .40571 .60562 L .39835 .60163 L p F P
0 g
s
.104 .472 .894 r
.40571 .60562 m .42827 .62991 L .43493 .63266 L p F P
0 g
s
.556 .92 .948 r
.68268 .66875 m .71141 .65572 L .70538 .65611 L p F P
0 g
s
.556 .92 .948 r
.70538 .65611 m .67824 .66842 L .68268 .66875 L p F P
0 g
s
.634 .957 .923 r
.72302 .65396 m .74969 .63563 L .74266 .63756 L p F P
0 g
s
.634 .957 .923 r
.74266 .63756 m .71729 .655 L .72302 .65396 L p F P
0 g
s
.823 .999 .798 r
.82614 .58059 m .84402 .54811 L .83729 .55415 L p F P
0 g
s
.823 .999 .798 r
.83729 .55415 m .81999 .58566 L .82614 .58059 L p F P
0 g
s
1 1 0 r
.007 w
.8536 .54774 m
.86051 .53372 L
s
.5 Mabswid
.725 .988 .883 r
.7696 .62804 m .79283 .60348 L .78544 .60729 L p F P
0 g
s
.725 .988 .883 r
.78544 .60729 m .76317 .63087 L .7696 .62804 L p F P
0 g
s
.324 .751 .973 r
.55329 .67627 m .58362 .68012 L .58475 .6783 L p F P
0 g
s
.365 .794 .97 r
.58362 .68012 m .61466 .67995 L .6138 .67815 L p F P
0 g
s
.365 .794 .97 r
.6138 .67815 m .58475 .6783 L .58362 .68012 L p F P
0 g
s
.431 .84 .971 r
.61466 .67995 m .64511 .67578 L .6423 .67424 L p F P
0 g
s
.431 .84 .971 r
.6423 .67424 m .6138 .67815 L .61466 .67995 L p F P
0 g
s
.015 .331 .815 r
.37771 .58813 m .36125 .55684 L .35432 .55088 L p F P
0 g
s
.067 .37 .837 r
.36125 .55684 m .37771 .58813 L .38434 .59288 L p F P
0 g
s
1 1 0 r
.007 w
.3358 .53285 m
.34003 .54348 L
s
.5 Mabswid
.161 .564 .932 r
.48097 .65628 m .45609 .63912 L .44884 .63727 L p F P
0 g
s
.218 .595 .948 r
.45609 .63912 m .48097 .65628 L .48708 .65694 L p F P
0 g
s
.104 .472 .894 r
.43493 .63266 m .41331 .60934 L .40571 .60562 L p F P
0 g
s
.158 .506 .911 r
.41331 .60934 m .43493 .63266 L .44179 .63512 L p F P
0 g
s
.254 .691 .961 r
.55329 .67627 m .52493 .66855 L .52013 .66928 L p F P
0 g
s
.313 .716 .978 r
.52493 .66855 m .55329 .67627 L .55636 .6747 L p F P
0 g
s
.324 .751 .973 r
.58475 .6783 m .55636 .6747 L .55329 .67627 L p F P
0 g
s
.827 .999 .824 r
.81999 .58566 m .83729 .55415 L .83028 .55999 L p F P
0 g
s
.827 .999 .824 r
.83028 .55999 m .81358 .59049 L .81999 .58566 L p F P
0 g
s
.515 .884 .976 r
.64511 .67578 m .6737 .66775 L .66904 .66672 L p F P
0 g
s
.515 .884 .976 r
.66904 .66672 m .6423 .67424 L .64511 .67578 L p F P
0 g
s
.217 .638 .954 r
.52013 .66928 m .49335 .65726 L .48708 .65694 L p F P
0 g
s
.275 .665 .97 r
.49335 .65726 m .52013 .66928 L .52493 .66855 L p F P
0 g
s
.651 .955 .942 r
.71729 .655 m .74266 .63756 L .73544 .63917 L p F P
0 g
s
.651 .955 .942 r
.73544 .63917 m .71141 .65572 L .71729 .655 L p F P
0 g
s
.582 .92 .966 r
.67824 .66842 m .70538 .65611 L .69919 .65616 L p F P
0 g
s
.582 .92 .966 r
.69919 .65616 m .6737 .66775 L .67824 .66842 L p F P
0 g
s
.733 .984 .903 r
.76317 .63087 m .78544 .60729 L .77781 .61082 L p F P
0 g
s
.733 .984 .903 r
.77781 .61082 m .75653 .6334 L .76317 .63087 L p F P
0 g
s
.067 .37 .837 r
.38434 .59288 m .36845 .56259 L .36125 .55684 L p F P
0 g
s
.115 .406 .856 r
.36845 .56259 m .38434 .59288 L .39122 .59738 L p F P
0 g
s
.378 .769 .988 r
.55636 .6747 m .58475 .6783 L .58589 .67612 L p F P
0 g
s
.415 .808 .987 r
.58475 .6783 m .6138 .67815 L .61292 .67597 L p F P
0 g
s
.415 .808 .987 r
.61292 .67597 m .58589 .67612 L .58475 .6783 L p F P
0 g
s
.473 .848 .987 r
.6138 .67815 m .6423 .67424 L .63942 .67233 L p F P
0 g
s
.473 .848 .987 r
.63942 .67233 m .61292 .67597 L .6138 .67815 L p F P
0 g
s
.828 .996 .846 r
.81358 .59049 m .83028 .55999 L .82299 .5656 L p F P
0 g
s
.828 .996 .846 r
.82299 .5656 m .80691 .59507 L .81358 .59049 L p F P
0 g
s
.158 .506 .911 r
.44179 .63512 m .42113 .61279 L .41331 .60934 L p F P
0 g
s
.208 .537 .925 r
.42113 .61279 m .44179 .63512 L .44884 .63727 L p F P
0 g
s
.218 .595 .948 r
.48708 .65694 m .46352 .64066 L .45609 .63912 L p F P
0 g
s
.27 .621 .96 r
.46352 .64066 m .48708 .65694 L .49335 .65726 L p F P
0 g
s
.739 .978 .92 r
.75653 .6334 m .77781 .61082 L .76996 .61408 L p F P
0 g
s
.739 .978 .92 r
.76996 .61408 m .74969 .63563 L .75653 .6334 L p F P
0 g
s
.663 .948 .956 r
.71141 .65572 m .73544 .63917 L .72804 .64048 L p F P
0 g
s
.663 .948 .956 r
.72804 .64048 m .70538 .65611 L .71141 .65572 L p F P
0 g
s
.313 .716 .978 r
.55636 .6747 m .52983 .66747 L .52493 .66855 L p F P
0 g
s
.365 .734 .989 r
.52983 .66747 m .55636 .6747 L .55949 .67276 L p F P
0 g
s
.378 .769 .988 r
.58589 .67612 m .55949 .67276 L .55636 .6747 L p F P
0 g
s
.275 .665 .97 r
.52493 .66855 m .49976 .65724 L .49335 .65726 L p F P
0 g
s
.327 .686 .979 r
.49976 .65724 m .52493 .66855 L .52983 .66747 L p F P
0 g
s
.544 .883 .987 r
.6423 .67424 m .66904 .66672 L .66428 .66533 L p F P
0 g
s
.544 .883 .987 r
.66428 .66533 m .63942 .67233 L .6423 .67424 L p F P
0 g
s
.115 .406 .856 r
.39122 .59738 m .37593 .56812 L .36845 .56259 L p F P
0 g
s
.16 .438 .872 r
.37593 .56812 m .39122 .59738 L .39835 .60163 L p F P
0 g
s
.602 .915 .977 r
.6737 .66775 m .69919 .65616 L .69287 .65587 L p F P
0 g
s
.602 .915 .977 r
.69287 .65587 m .66904 .66672 L .6737 .66775 L p F P
0 g
s
1 1 0 r
.007 w
.86051 .53372 m
.86187 .5299 L
s
.5 Mabswid
.827 .991 .865 r
.80691 .59507 m .82299 .5656 L .81544 .571 L p F P
0 g
s
.827 .991 .865 r
.81544 .571 m .79999 .59941 L .80691 .59507 L p F P
0 g
s
.104 .305 .781 r
.32847 .49441 m .33524 .5318 L .34131 .53836 L p F P
0 g
s
1 1 0 r
.007 w
.3344 .52934 m
.33512 .53116 L
s
.5 Mabswid
.208 .537 .925 r
.44884 .63727 m .42917 .61596 L .42113 .61279 L p F P
0 g
s
.253 .563 .936 r
.42917 .61596 m .44884 .63727 L .45609 .63912 L p F P
0 g
s
.424 .78 .996 r
.55949 .67276 m .58589 .67612 L .58706 .67355 L p F P
0 g
s
.458 .815 .996 r
.58589 .67612 m .61292 .67597 L .61201 .67342 L p F P
0 g
s
.458 .815 .996 r
.61201 .67342 m .58706 .67355 L .58589 .67612 L p F P
0 g
s
.508 .849 .996 r
.61292 .67597 m .63942 .67233 L .63648 .67006 L p F P
0 g
s
.508 .849 .996 r
.63648 .67006 m .61201 .67342 L .61292 .67597 L p F P
0 g
s
.27 .621 .96 r
.49335 .65726 m .47113 .64188 L .46352 .64066 L p F P
0 g
s
.316 .643 .967 r
.47113 .64188 m .49335 .65726 L .49976 .65724 L p F P
0 g
s
.741 .969 .932 r
.74969 .63563 m .76996 .61408 L .76189 .61705 L p F P
0 g
s
.741 .969 .932 r
.76189 .61705 m .74266 .63756 L .74969 .63563 L p F P
0 g
s
.16 .438 .872 r
.39835 .60163 m .38366 .57342 L .37593 .56812 L p F P
0 g
s
.201 .467 .885 r
.38366 .57342 m .39835 .60163 L .40571 .60562 L p F P
0 g
s
.918 .975 .769 r
.86248 .52879 m .8702 .49127 L .86407 .49885 L p F P
0 g
s
.918 .975 .769 r
.86407 .49885 m .85662 .53542 L .86248 .52879 L p F P
0 g
s
.672 .939 .965 r
.70538 .65611 m .72804 .64048 L .72046 .64146 L p F P
0 g
s
.672 .939 .965 r
.72046 .64146 m .69919 .65616 L .70538 .65611 L p F P
0 g
s
.327 .686 .979 r
.52983 .66747 m .50631 .65688 L .49976 .65724 L p F P
0 g
s
.373 .703 .985 r
.50631 .65688 m .52983 .66747 L .53483 .66603 L p F P
0 g
s
.365 .734 .989 r
.55949 .67276 m .53483 .66603 L .52983 .66747 L p F P
0 g
s
.41 .747 .994 r
.53483 .66603 m .55949 .67276 L .56268 .67045 L p F P
0 g
s
.424 .78 .996 r
.58706 .67355 m .56268 .67045 L .55949 .67276 L p F P
0 g
s
.825 .984 .88 r
.79999 .59941 m .81544 .571 L .80763 .57616 L p F P
0 g
s
.825 .984 .88 r
.80763 .57616 m .79283 .60348 L .79999 .59941 L p F P
0 g
s
.104 .305 .781 r
.34131 .53836 m .33479 .50192 L .32847 .49441 L p F P
0 g
s
1 1 0 r
.007 w
.3306 .51483 m
.3344 .52934 L
s
.5 Mabswid
.142 .337 .798 r
.33479 .50192 m .34131 .53836 L .34767 .54472 L p F P
0 g
s
.568 .878 .993 r
.63942 .67233 m .66428 .66533 L .65942 .66359 L p F P
0 g
s
.568 .878 .993 r
.65942 .66359 m .63648 .67006 L .63942 .67233 L p F P
0 g
s
.618 .907 .984 r
.66904 .66672 m .69287 .65587 L .68641 .65525 L p F P
0 g
s
.618 .907 .984 r
.68641 .65525 m .66428 .66533 L .66904 .66672 L p F P
0 g
s
.253 .563 .936 r
.45609 .63912 m .43743 .61884 L .42917 .61596 L p F P
0 g
s
.294 .587 .943 r
.43743 .61884 m .45609 .63912 L .46352 .64066 L p F P
0 g
s
.201 .467 .885 r
.40571 .60562 m .39165 .57849 L .38366 .57342 L p F P
0 g
s
.239 .494 .896 r
.39165 .57849 m .40571 .60562 L .41331 .60934 L p F P
0 g
s
.913 .973 .789 r
.85662 .53542 m .86407 .49885 L .85764 .50629 L p F P
0 g
s
1 1 0 r
.007 w
.86383 .52438 m
.86563 .51931 L
s
.86278 .52733 m
.86383 .52438 L
s
.5 Mabswid
.913 .973 .789 r
.85764 .50629 m .85047 .54186 L .85662 .53542 L p F P
0 g
s
.742 .958 .941 r
.74266 .63756 m .76189 .61705 L .75362 .61974 L p F P
0 g
s
.742 .958 .941 r
.75362 .61974 m .73544 .63917 L .74266 .63756 L p F P
0 g
s
.316 .643 .967 r
.49976 .65724 m .47891 .64278 L .47113 .64188 L p F P
0 g
s
.358 .662 .972 r
.47891 .64278 m .49976 .65724 L .50631 .65688 L p F P
0 g
s
.464 .786 .999 r
.56268 .67045 m .58706 .67355 L .58824 .67062 L p F P
0 g
s
.494 .818 1 r
.58706 .67355 m .61201 .67342 L .61108 .6705 L p F P
0 g
s
.494 .818 1 r
.61108 .6705 m .58824 .67062 L .58706 .67355 L p F P
0 g
s
.537 .847 .998 r
.61201 .67342 m .63648 .67006 L .63348 .66741 L p F P
0 g
s
.537 .847 .998 r
.63348 .66741 m .61108 .6705 L .61201 .67342 L p F P
0 g
s
.142 .337 .798 r
.34767 .54472 m .3414 .50927 L .33479 .50192 L p F P
0 g
s
.178 .367 .814 r
.3414 .50927 m .34767 .54472 L .35432 .55088 L p F P
0 g
s
.82 .976 .892 r
.79283 .60348 m .80763 .57616 L .79957 .58108 L p F P
0 g
s
.82 .976 .892 r
.79957 .58108 m .78544 .60729 L .79283 .60348 L p F P
0 g
s
.678 .928 .971 r
.69919 .65616 m .72046 .64146 L .71272 .64213 L p F P
0 g
s
.678 .928 .971 r
.71272 .64213 m .69287 .65587 L .69919 .65616 L p F P
0 g
s
.373 .703 .985 r
.53483 .66603 m .51298 .65619 L .50631 .65688 L p F P
0 g
s
.413 .717 .986 r
.51298 .65619 m .53483 .66603 L .53992 .66423 L p F P
0 g
s
.41 .747 .994 r
.56268 .67045 m .53992 .66423 L .53483 .66603 L p F P
0 g
s
.907 .969 .806 r
.85047 .54186 m .85764 .50629 L .85091 .51357 L p F P
0 g
s
.907 .969 .806 r
.85091 .51357 m .84402 .54811 L .85047 .54186 L p F P
0 g
s
.449 .755 .994 r
.53992 .66423 m .56268 .67045 L .56593 .66778 L p F P
0 g
s
.464 .786 .999 r
.58824 .67062 m .56593 .66778 L .56268 .67045 L p F P
0 g
s
.63 .897 .986 r
.66428 .66533 m .68641 .65525 L .67982 .65428 L p F P
0 g
s
.63 .897 .986 r
.67982 .65428 m .65942 .66359 L .66428 .66533 L p F P
0 g
s
.294 .587 .943 r
.46352 .64066 m .44588 .62144 L .43743 .61884 L p F P
0 g
s
.332 .607 .949 r
.44588 .62144 m .46352 .64066 L .47113 .64188 L p F P
0 g
s
1 1 0 r
.007 w
.86563 .51931 m
.8689 .50461 L
s
.5 Mabswid
.239 .494 .896 r
.41331 .60934 m .39988 .58331 L .39165 .57849 L p F P
0 g
s
.275 .518 .905 r
.39988 .58331 m .41331 .60934 L .42113 .61279 L p F P
0 g
s
.588 .871 .994 r
.63648 .67006 m .65942 .66359 L .65446 .66149 L p F P
0 g
s
.588 .871 .994 r
.65446 .66149 m .63348 .66741 L .63648 .67006 L p F P
0 g
s
.178 .367 .814 r
.35432 .55088 m .34831 .51646 L .3414 .50927 L p F P
0 g
s
.211 .395 .827 r
.34831 .51646 m .35432 .55088 L .36125 .55684 L p F P
0 g
s
.741 .947 .948 r
.73544 .63917 m .75362 .61974 L .74515 .62214 L p F P
0 g
s
.741 .947 .948 r
.74515 .62214 m .72804 .64048 L .73544 .63917 L p F P
0 g
s
.815 .966 .903 r
.78544 .60729 m .79957 .58108 L .79127 .58575 L p F P
0 g
s
.815 .966 .903 r
.79127 .58575 m .77781 .61082 L .78544 .60729 L p F P
0 g
s
.358 .662 .972 r
.50631 .65688 m .48684 .64336 L .47891 .64278 L p F P
0 g
s
.396 .678 .973 r
.48684 .64336 m .50631 .65688 L .51298 .65619 L p F P
0 g
s
.682 .916 .973 r
.69287 .65587 m .71272 .64213 L .70481 .64247 L p F P
0 g
s
.682 .916 .973 r
.70481 .64247 m .68641 .65525 L .69287 .65587 L p F P
0 g
s
.9 .963 .822 r
.84402 .54811 m .85091 .51357 L .84389 .52068 L p F P
0 g
s
.9 .963 .822 r
.84389 .52068 m .83729 .55415 L .84402 .54811 L p F P
0 g
s
1 1 0 r
.007 w
.32869 .50006 m
.3306 .51483 L
s
.5 Mabswid
.498 .789 .997 r
.56593 .66778 m .58824 .67062 L .58944 .66731 L p F P
0 g
s
.524 .817 .999 r
.58824 .67062 m .61108 .6705 L .61013 .6672 L p F P
0 g
s
.524 .817 .999 r
.61013 .6672 m .58944 .66731 L .58824 .67062 L p F P
0 g
s
.561 .842 .997 r
.61108 .6705 m .63348 .66741 L .63042 .6644 L p F P
0 g
s
.561 .842 .997 r
.63042 .6644 m .61013 .6672 L .61108 .6705 L p F P
0 g
s
.275 .518 .905 r
.42113 .61279 m .40835 .58789 L .39988 .58331 L p F P
0 g
s
.308 .54 .912 r
.40835 .58789 m .42113 .61279 L .42917 .61596 L p F P
0 g
s
.332 .607 .949 r
.47113 .64188 m .45453 .62373 L .44588 .62144 L p F P
0 g
s
.367 .626 .952 r
.45453 .62373 m .47113 .64188 L .47891 .64278 L p F P
0 g
s
.211 .395 .827 r
.36125 .55684 m .35551 .52348 L .34831 .51646 L p F P
0 g
s
.242 .421 .839 r
.35551 .52348 m .36125 .55684 L .36845 .56259 L p F P
0 g
s
.413 .717 .986 r
.53992 .66423 m .51979 .65514 L .51298 .65619 L p F P
0 g
s
.449 .727 .986 r
.51979 .65514 m .53992 .66423 L .54511 .66208 L p F P
0 g
s
.449 .755 .994 r
.56593 .66778 m .54511 .66208 L .53992 .66423 L p F P
0 g
s
.639 .885 .986 r
.65942 .66359 m .67982 .65428 L .6731 .65296 L p F P
0 g
s
.639 .885 .986 r
.6731 .65296 m .65446 .66149 L .65942 .66359 L p F P
0 g
s
.738 .934 .952 r
.72804 .64048 m .74515 .62214 L .73648 .62424 L p F P
0 g
s
.738 .934 .952 r
.73648 .62424 m .72046 .64146 L .72804 .64048 L p F P
0 g
s
.809 .956 .911 r
.77781 .61082 m .79127 .58575 L .78274 .59017 L p F P
0 g
s
.809 .956 .911 r
.78274 .59017 m .76996 .61408 L .77781 .61082 L p F P
0 g
s
.483 .761 .992 r
.54511 .66208 m .56593 .66778 L .56923 .66473 L p F P
0 g
s
.498 .789 .997 r
.58944 .66731 m .56923 .66473 L .56593 .66778 L p F P
0 g
s
.603 .861 .992 r
.63348 .66741 m .65446 .66149 L .64941 .65903 L p F P
0 g
s
.603 .861 .992 r
.64941 .65903 m .63042 .6644 L .63348 .66741 L p F P
0 g
s
.892 .957 .835 r
.83729 .55415 m .84389 .52068 L .83659 .5276 L p F P
0 g
s
.892 .957 .835 r
.83659 .5276 m .83028 .55999 L .83729 .55415 L p F P
0 g
s
.396 .678 .973 r
.51298 .65619 m .49494 .64361 L .48684 .64336 L p F P
0 g
s
.43 .691 .973 r
.49494 .64361 m .51298 .65619 L .51979 .65514 L p F P
0 g
s
.308 .54 .912 r
.42917 .61596 m .41705 .59221 L .40835 .58789 L p F P
0 g
s
.338 .561 .918 r
.41705 .59221 m .42917 .61596 L .43743 .61884 L p F P
0 g
s
.242 .421 .839 r
.36845 .56259 m .36298 .53031 L .35551 .52348 L p F P
0 g
s
.271 .445 .85 r
.36298 .53031 m .36845 .56259 L .37593 .56812 L p F P
0 g
s
.684 .902 .974 r
.68641 .65525 m .70481 .64247 L .69676 .64249 L p F P
0 g
s
.684 .902 .974 r
.69676 .64249 m .67982 .65428 L .68641 .65525 L p F P
0 g
s
.367 .626 .952 r
.47891 .64278 m .46336 .62574 L .45453 .62373 L p F P
0 g
s
.399 .642 .954 r
.46336 .62574 m .47891 .64278 L .48684 .64336 L p F P
0 g
s
.802 .945 .918 r
.76996 .61408 m .78274 .59017 L .77397 .59433 L p F P
0 g
s
.802 .945 .918 r
.77397 .59433 m .76189 .61705 L .76996 .61408 L p F P
0 g
s
.527 .789 .993 r
.56923 .66473 m .58944 .66731 L .59065 .66362 L p F P
0 g
s
.55 .813 .995 r
.58944 .66731 m .61013 .6672 L .60916 .66352 L p F P
0 g
s
.55 .813 .995 r
.60916 .66352 m .59065 .66362 L .58944 .66731 L p F P
0 g
s
.58 .834 .993 r
.61013 .6672 m .63042 .6644 L .6273 .66102 L p F P
0 g
s
.58 .834 .993 r
.6273 .66102 m .60916 .66352 L .61013 .6672 L p F P
0 g
s
.735 .921 .955 r
.72046 .64146 m .73648 .62424 L .72764 .62603 L p F P
0 g
s
.735 .921 .955 r
.72764 .62603 m .71272 .64213 L .72046 .64146 L p F P
0 g
s
.883 .951 .847 r
.83028 .55999 m .83659 .5276 L .829 .53434 L p F P
0 g
s
.883 .951 .847 r
.829 .53434 m .82299 .5656 L .83028 .55999 L p F P
0 g
s
.449 .727 .986 r
.54511 .66208 m .52671 .65376 L .51979 .65514 L p F P
0 g
s
.481 .735 .983 r
.52671 .65376 m .54511 .66208 L .55038 .65956 L p F P
0 g
s
.483 .761 .992 r
.56923 .66473 m .55038 .65956 L .54511 .66208 L p F P
0 g
s
.646 .872 .983 r
.65446 .66149 m .6731 .65296 L .66627 .6513 L p F P
0 g
s
.646 .872 .983 r
.66627 .6513 m .64941 .65903 L .65446 .66149 L p F P
0 g
s
.271 .445 .85 r
.37593 .56812 m .37073 .53696 L .36298 .53031 L p F P
0 g
s
.298 .467 .859 r
.37073 .53696 m .37593 .56812 L .38366 .57342 L p F P
0 g
s
1 1 0 r
.007 w
.8689 .50461 m
.87003 .49205 L
s
.5 Mabswid
.338 .561 .918 r
.43743 .61884 m .42597 .59627 L .41705 .59221 L p F P
0 g
s
.367 .579 .923 r
.42597 .59627 m .43743 .61884 L .44588 .62144 L p F P
0 g
s
.513 .765 .987 r
.55038 .65956 m .56923 .66473 L .57258 .66131 L p F P
0 g
s
.527 .789 .993 r
.59065 .66362 m .57258 .66131 L .56923 .66473 L p F P
0 g
s
.616 .85 .988 r
.63042 .6644 m .64941 .65903 L .64427 .65621 L p F P
0 g
s
.616 .85 .988 r
.64427 .65621 m .6273 .66102 L .63042 .6644 L p F P
0 g
s
.43 .691 .973 r
.51979 .65514 m .50318 .64354 L .49494 .64361 L p F P
0 g
s
.46 .702 .972 r
.50318 .64354 m .51979 .65514 L .52671 .65376 L p F P
0 g
s
.685 .889 .972 r
.67982 .65428 m .69676 .64249 L .68856 .64218 L p F P
0 g
s
.685 .889 .972 r
.68856 .64218 m .6731 .65296 L .67982 .65428 L p F P
0 g
s
.795 .934 .923 r
.76189 .61705 m .77397 .59433 L .76499 .59823 L p F P
0 g
s
.795 .934 .923 r
.76499 .59823 m .75362 .61974 L .76189 .61705 L p F P
0 g
s
.874 .943 .857 r
.82299 .5656 m .829 .53434 L .82115 .54089 L p F P
0 g
s
.874 .943 .857 r
.82115 .54089 m .81544 .571 L .82299 .5656 L p F P
0 g
s
.399 .642 .954 r
.48684 .64336 m .47237 .62743 L .46336 .62574 L p F P
0 g
s
.428 .656 .955 r
.47237 .62743 m .48684 .64336 L .49494 .64361 L p F P
0 g
s
.731 .908 .956 r
.71272 .64213 m .72764 .62603 L .71862 .62752 L p F P
0 g
s
.731 .908 .956 r
.71862 .62752 m .70481 .64247 L .71272 .64213 L p F P
0 g
s
.298 .467 .859 r
.38366 .57342 m .37874 .5434 L .37073 .53696 L p F P
0 g
s
.323 .488 .867 r
.37874 .5434 m .38366 .57342 L .39165 .57849 L p F P
0 g
s
1 1 0 r
.007 w
.32869 .50006 m
.3287 .49567 L
s
.5 Mabswid
.367 .579 .923 r
.44588 .62144 m .43509 .60006 L .42597 .59627 L p F P
0 g
s
.393 .596 .927 r
.43509 .60006 m .44588 .62144 L .45453 .62373 L p F P
0 g
s
.551 .788 .987 r
.57258 .66131 m .59065 .66362 L .59188 .65957 L p F P
0 g
s
.571 .808 .988 r
.59065 .66362 m .60916 .66352 L .60817 .65948 L p F P
0 g
s
.571 .808 .988 r
.60817 .65948 m .59188 .65957 L .59065 .66362 L p F P
0 g
s
.597 .825 .987 r
.60916 .66352 m .6273 .66102 L .62413 .65727 L p F P
0 g
s
.597 .825 .987 r
.62413 .65727 m .60817 .65948 L .60916 .66352 L p F P
0 g
s
.481 .735 .983 r
.55038 .65956 m .53374 .65202 L .52671 .65376 L p F P
0 g
s
.509 .741 .978 r
.53374 .65202 m .55038 .65956 L .55574 .65669 L p F P
0 g
s
.513 .765 .987 r
.57258 .66131 m .55574 .65669 L .55038 .65956 L p F P
0 g
s
.865 .936 .866 r
.81544 .571 m .82115 .54089 L .81304 .54722 L p F P
0 g
s
.865 .936 .866 r
.81304 .54722 m .80763 .57616 L .81544 .571 L p F P
0 g
s
.651 .859 .979 r
.64941 .65903 m .66627 .6513 L .65933 .64929 L p F P
0 g
s
.651 .859 .979 r
.65933 .64929 m .64427 .65621 L .64941 .65903 L p F P
0 g
s
.787 .922 .927 r
.75362 .61974 m .76499 .59823 L .75581 .60185 L p F P
0 g
s
.787 .922 .927 r
.75581 .60185 m .74515 .62214 L .75362 .61974 L p F P
0 g
s
.46 .702 .972 r
.52671 .65376 m .51155 .64314 L .50318 .64354 L p F P
0 g
s
.488 .711 .969 r
.51155 .64314 m .52671 .65376 L .53374 .65202 L p F P
0 g
s
.428 .656 .955 r
.49494 .64361 m .48155 .62882 L .47237 .62743 L p F P
0 g
s
.455 .669 .955 r
.48155 .62882 m .49494 .64361 L .50318 .64354 L p F P
0 g
s
.323 .488 .867 r
.39165 .57849 m .38701 .54964 L .37874 .5434 L p F P
0 g
s
.347 .507 .875 r
.38701 .54964 m .39165 .57849 L .39988 .58331 L p F P
0 g
s
.539 .766 .981 r
.55574 .65669 m .57258 .66131 L .57598 .65753 L p F P
0 g
s
.551 .788 .987 r
.59188 .65957 m .57598 .65753 L .57258 .66131 L p F P
0 g
s
.684 .874 .97 r
.6731 .65296 m .68856 .64218 L .68023 .64153 L p F P
0 g
s
.684 .874 .97 r
.68023 .64153 m .66627 .6513 L .6731 .65296 L p F P
0 g
s
.626 .838 .982 r
.6273 .66102 m .64427 .65621 L .63906 .65303 L p F P
0 g
s
.626 .838 .982 r
.63906 .65303 m .62413 .65727 L .6273 .66102 L p F P
0 g
s
.726 .894 .956 r
.70481 .64247 m .71862 .62752 L .70944 .62871 L p F P
0 g
s
.726 .894 .956 r
.70944 .62871 m .69676 .64249 L .70481 .64247 L p F P
0 g
s
.393 .596 .927 r
.45453 .62373 m .44442 .60358 L .43509 .60006 L p F P
0 g
s
.418 .612 .929 r
.44442 .60358 m .45453 .62373 L .46336 .62574 L p F P
0 g
s
.287 .374 .779 r
.33438 .45623 m .32847 .49441 L .33479 .50192 L p F P
0 g
s
1 1 0 r
.007 w
.3287 .4929 m
.32872 .48513 L
s
.5 Mabswid
.856 .928 .874 r
.80763 .57616 m .81304 .54722 L .80467 .55335 L p F P
0 g
s
.856 .928 .874 r
.80467 .55335 m .79957 .58108 L .80763 .57616 L p F P
0 g
s
.779 .911 .93 r
.74515 .62214 m .75581 .60185 L .74643 .6052 L p F P
0 g
s
.779 .911 .93 r
.74643 .6052 m .73648 .62424 L .74515 .62214 L p F P
0 g
s
.347 .507 .875 r
.39988 .58331 m .39552 .55566 L .38701 .54964 L p F P
0 g
s
.37 .526 .881 r
.39552 .55566 m .39988 .58331 L .40835 .58789 L p F P
0 g
s
.931 .904 .775 r
.8702 .49127 m .86522 .4531 L .85912 .46169 L p F P
0 g
s
.931 .904 .775 r
.85912 .46169 m .86407 .49885 L .8702 .49127 L p F P
0 g
s
1 1 0 r
.007 w
.87014 .49085 m
.87025 .48972 L
s
.5 Mabswid
.509 .741 .978 r
.55574 .65669 m .54088 .64994 L .53374 .65202 L p F P
0 g
s
.534 .745 .973 r
.54088 .64994 m .55574 .65669 L .56117 .65345 L p F P
0 g
s
.539 .766 .981 r
.57598 .65753 m .56117 .65345 L .55574 .65669 L p F P
0 g
s
.455 .669 .955 r
.50318 .64354 m .49088 .62991 L .48155 .62882 L p F P
0 g
s
.479 .68 .954 r
.49088 .62991 m .50318 .64354 L .51155 .64314 L p F P
0 g
s
.655 .846 .973 r
.64427 .65621 m .65933 .64929 L .65228 .64694 L p F P
0 g
s
.655 .846 .973 r
.65228 .64694 m .63906 .65303 L .64427 .65621 L p F P
0 g
s
.287 .374 .779 r
.33479 .50192 m .34065 .46474 L .33438 .45623 L p F P
0 g
s
.308 .396 .79 r
.34065 .46474 m .33479 .50192 L .3414 .50927 L p F P
0 g
s
.572 .784 .979 r
.57598 .65753 m .59188 .65957 L .59312 .65513 L p F P
0 g
s
.589 .801 .981 r
.59188 .65957 m .60817 .65948 L .60716 .65506 L p F P
0 g
s
.589 .801 .981 r
.60716 .65506 m .59312 .65513 L .59188 .65957 L p F P
0 g
s
.61 .816 .979 r
.60817 .65948 m .62413 .65727 L .62091 .65315 L p F P
0 g
s
.61 .816 .979 r
.62091 .65315 m .60716 .65506 L .60817 .65948 L p F P
0 g
s
.488 .711 .969 r
.53374 .65202 m .52005 .64241 L .51155 .64314 L p F P
0 g
s
.513 .719 .966 r
.52005 .64241 m .53374 .65202 L .54088 .64994 L p F P
0 g
s
.846 .92 .881 r
.79957 .58108 m .80467 .55335 L .79606 .55925 L p F P
0 g
s
.846 .92 .881 r
.79606 .55925 m .79127 .58575 L .79957 .58108 L p F P
0 g
s
.418 .612 .929 r
.46336 .62574 m .45394 .60682 L .44442 .60358 L p F P
0 g
s
.441 .626 .931 r
.45394 .60682 m .46336 .62574 L .47237 .62743 L p F P
0 g
s
.721 .881 .955 r
.69676 .64249 m .70944 .62871 L .7001 .62958 L p F P
0 g
s
.721 .881 .955 r
.7001 .62958 m .68856 .64218 L .69676 .64249 L p F P
0 g
s
1 1 0 r
.007 w
.86964 .47473 m
.87025 .48972 L
s
.5 Mabswid
.683 .86 .966 r
.66627 .6513 m .68023 .64153 L .67177 .64056 L p F P
0 g
s
.683 .86 .966 r
.67177 .64056 m .65933 .64929 L .66627 .6513 L p F P
0 g
s
.561 .766 .974 r
.56117 .65345 m .57598 .65753 L .57942 .65338 L p F P
0 g
s
.572 .784 .979 r
.59312 .65513 m .57942 .65338 L .57598 .65753 L p F P
0 g
s
.77 .899 .933 r
.73648 .62424 m .74643 .6052 L .73686 .60826 L p F P
0 g
s
.77 .899 .933 r
.73686 .60826 m .72764 .62603 L .73648 .62424 L p F P
0 g
s
.37 .526 .881 r
.40835 .58789 m .40427 .56146 L .39552 .55566 L p F P
0 g
s
.391 .543 .887 r
.40427 .56146 m .40835 .58789 L .41705 .59221 L p F P
0 g
s
.633 .826 .975 r
.62413 .65727 m .63906 .65303 L .63377 .64949 L p F P
0 g
s
.633 .826 .975 r
.63377 .64949 m .62091 .65315 L .62413 .65727 L p F P
0 g
s
.922 .901 .787 r
.86407 .49885 m .85912 .46169 L .85272 .47017 L p F P
0 g
s
.922 .901 .787 r
.85272 .47017 m .85764 .50629 L .86407 .49885 L p F P
0 g
s
.308 .396 .79 r
.3414 .50927 m .34722 .47313 L .34065 .46474 L p F P
0 g
s
.328 .416 .8 r
.34722 .47313 m .3414 .50927 L .34831 .51646 L p F P
0 g
s
.837 .911 .887 r
.79127 .58575 m .79606 .55925 L .78721 .56492 L p F P
0 g
s
.837 .911 .887 r
.78721 .56492 m .78274 .59017 L .79127 .58575 L p F P
0 g
s
.479 .68 .954 r
.51155 .64314 m .50036 .63068 L .49088 .62991 L p F P
0 g
s
.502 .691 .952 r
.50036 .63068 m .51155 .64314 L .52005 .64241 L p F P
0 g
s
.441 .626 .931 r
.47237 .62743 m .46364 .60977 L .45394 .60682 L p F P
0 g
s
.463 .64 .933 r
.46364 .60977 m .47237 .62743 L .48155 .62882 L p F P
0 g
s
1 1 0 r
.007 w
.32872 .48513 m
.33072 .47014 L
s
.5 Mabswid
.715 .868 .954 r
.68856 .64218 m .7001 .62958 L .69063 .63014 L p F P
0 g
s
.715 .868 .954 r
.69063 .63014 m .68023 .64153 L .68856 .64218 L p F P
0 g
s
.391 .543 .887 r
.41705 .59221 m .41324 .56703 L .40427 .56146 L p F P
0 g
s
.411 .559 .892 r
.41324 .56703 m .41705 .59221 L .42597 .59627 L p F P
0 g
s
.534 .745 .973 r
.56117 .65345 m .54811 .64751 L .54088 .64994 L p F P
0 g
s
.556 .748 .967 r
.54811 .64751 m .56117 .65345 L .56666 .64986 L p F P
0 g
s
.561 .766 .974 r
.57942 .65338 m .56666 .64986 L .56117 .65345 L p F P
0 g
s
.513 .719 .966 r
.54088 .64994 m .52868 .64134 L .52005 .64241 L p F P
0 g
s
.536 .725 .961 r
.52868 .64134 m .54088 .64994 L .54811 .64751 L p F P
0 g
s
.913 .897 .798 r
.85764 .50629 m .85272 .47017 L .84603 .47852 L p F P
0 g
s
.913 .897 .798 r
.84603 .47852 m .85091 .51357 L .85764 .50629 L p F P
0 g
s
.762 .888 .934 r
.72764 .62603 m .73686 .60826 L .72711 .61104 L p F P
0 g
s
.762 .888 .934 r
.72711 .61104 m .71862 .62752 L .72764 .62603 L p F P
0 g
s
.657 .832 .967 r
.63906 .65303 m .65228 .64694 L .64515 .64424 L p F P
0 g
s
.657 .832 .967 r
.64515 .64424 m .63377 .64949 L .63906 .65303 L p F P
0 g
s
.681 .846 .962 r
.65933 .64929 m .67177 .64056 L .6632 .63926 L p F P
0 g
s
.681 .846 .962 r
.6632 .63926 m .65228 .64694 L .65933 .64929 L p F P
0 g
s
.328 .416 .8 r
.34831 .51646 m .35407 .48139 L .34722 .47313 L p F P
0 g
s
.347 .435 .81 r
.35407 .48139 m .34831 .51646 L .35551 .52348 L p F P
0 g
s
.591 .78 .97 r
.57942 .65338 m .59312 .65513 L .59437 .65033 L p F P
0 g
s
.604 .794 .972 r
.59312 .65513 m .60716 .65506 L .60613 .65027 L p F P
0 g
s
.604 .794 .972 r
.60613 .65027 m .59437 .65033 L .59312 .65513 L p F P
0 g
s
.621 .806 .971 r
.60716 .65506 m .62091 .65315 L .61765 .64867 L p F P
0 g
s
.621 .806 .971 r
.61765 .64867 m .60613 .65027 L .60716 .65506 L p F P
0 g
s
.827 .903 .893 r
.78274 .59017 m .78721 .56492 L .77814 .57036 L p F P
0 g
s
.827 .903 .893 r
.77814 .57036 m .77397 .59433 L .78274 .59017 L p F P
0 g
s
.463 .64 .933 r
.48155 .62882 m .4735 .61244 L .46364 .60977 L p F P
0 g
s
.484 .652 .934 r
.4735 .61244 m .48155 .62882 L .49088 .62991 L p F P
0 g
s
.581 .765 .966 r
.56666 .64986 m .57942 .65338 L .5829 .64885 L p F P
0 g
s
.591 .78 .97 r
.59437 .65033 m .5829 .64885 L .57942 .65338 L p F P
0 g
s
.411 .559 .892 r
.42597 .59627 m .42244 .57236 L .41324 .56703 L p F P
0 g
s
.43 .574 .896 r
.42244 .57236 m .42597 .59627 L .43509 .60006 L p F P
0 g
s
.64 .814 .967 r
.62091 .65315 m .63377 .64949 L .62841 .6456 L p F P
0 g
s
.64 .814 .967 r
.62841 .6456 m .61765 .64867 L .62091 .65315 L p F P
0 g
s
.904 .893 .808 r
.85091 .51357 m .84603 .47852 L .83905 .48673 L p F P
0 g
s
.904 .893 .808 r
.83905 .48673 m .84389 .52068 L .85091 .51357 L p F P
0 g
s
.502 .691 .952 r
.52005 .64241 m .50997 .63113 L .50036 .63068 L p F P
0 g
s
.523 .7 .95 r
.50997 .63113 m .52005 .64241 L .52868 .64134 L p F P
0 g
s
.347 .435 .81 r
.35551 .52348 m .36121 .48951 L .35407 .48139 L p F P
0 g
s
.365 .454 .818 r
.36121 .48951 m .35551 .52348 L .36298 .53031 L p F P
0 g
s
.754 .876 .935 r
.71862 .62752 m .72711 .61104 L .71721 .61353 L p F P
0 g
s
.754 .876 .935 r
.71721 .61353 m .70944 .62871 L .71862 .62752 L p F P
0 g
s
.709 .854 .951 r
.68023 .64153 m .69063 .63014 L .68102 .63038 L p F P
0 g
s
.709 .854 .951 r
.68102 .63038 m .67177 .64056 L .68023 .64153 L p F P
0 g
s
.817 .894 .897 r
.77397 .59433 m .77814 .57036 L .76886 .57555 L p F P
0 g
s
.817 .894 .897 r
.76886 .57555 m .76499 .59823 L .77397 .59433 L p F P
0 g
s
.536 .725 .961 r
.54811 .64751 m .53741 .63994 L .52868 .64134 L p F P
0 g
s
.556 .731 .956 r
.53741 .63994 m .54811 .64751 L .55543 .64473 L p F P
0 g
s
.556 .748 .967 r
.56666 .64986 m .55543 .64473 L .54811 .64751 L p F P
0 g
s
.679 .833 .957 r
.65228 .64694 m .6632 .63926 L .65452 .63762 L p F P
0 g
s
.679 .833 .957 r
.65452 .63762 m .64515 .64424 L .65228 .64694 L p F P
0 g
s
.576 .75 .96 r
.55543 .64473 m .56666 .64986 L .57223 .6459 L p F P
0 g
s
.581 .765 .966 r
.5829 .64885 m .57223 .6459 L .56666 .64986 L p F P
0 g
s
.43 .574 .896 r
.43509 .60006 m .43184 .57744 L .42244 .57236 L p F P
0 g
s
.448 .589 .9 r
.43184 .57744 m .43509 .60006 L .44442 .60358 L p F P
0 g
s
.895 .889 .817 r
.84389 .52068 m .83905 .48673 L .83179 .49479 L p F P
0 g
s
.895 .889 .817 r
.83179 .49479 m .83659 .5276 L .84389 .52068 L p F P
0 g
s
.659 .819 .96 r
.63377 .64949 m .64515 .64424 L .63792 .64119 L p F P
0 g
s
.659 .819 .96 r
.63792 .64119 m .62841 .6456 L .63377 .64949 L p F P
0 g
s
.484 .652 .934 r
.49088 .62991 m .48353 .61482 L .4735 .61244 L p F P
0 g
s
.503 .664 .934 r
.48353 .61482 m .49088 .62991 L .50036 .63068 L p F P
0 g
s
.365 .454 .818 r
.36298 .53031 m .36861 .49748 L .36121 .48951 L p F P
0 g
s
.383 .471 .827 r
.36861 .49748 m .36298 .53031 L .37073 .53696 L p F P
0 g
s
.745 .865 .935 r
.70944 .62871 m .71721 .61353 L .70714 .61572 L p F P
0 g
s
.745 .865 .935 r
.70714 .61572 m .7001 .62958 L .70944 .62871 L p F P
0 g
s
.808 .886 .901 r
.76499 .59823 m .76886 .57555 L .75937 .58049 L p F P
0 g
s
.808 .886 .901 r
.75937 .58049 m .75581 .60185 L .76499 .59823 L p F P
0 g
s
1 1 0 r
.007 w
.86704 .45977 m
.86964 .47473 L
s
.5 Mabswid
.606 .776 .961 r
.5829 .64885 m .59437 .65033 L .59564 .64516 L p F P
0 g
s
.617 .786 .963 r
.59437 .65033 m .60613 .65027 L .60509 .64511 L p F P
0 g
s
.617 .786 .963 r
.60509 .64511 m .59564 .64516 L .59437 .65033 L p F P
0 g
s
.523 .7 .95 r
.52868 .64134 m .51971 .63127 L .50997 .63113 L p F P
0 g
s
.543 .708 .948 r
.51971 .63127 m .52868 .64134 L .53741 .63994 L p F P
0 g
s
.63 .795 .962 r
.60613 .65027 m .61765 .64867 L .61434 .64382 L p F P
0 g
s
.63 .795 .962 r
.61434 .64382 m .60509 .64511 L .60613 .65027 L p F P
0 g
s
.703 .841 .949 r
.67177 .64056 m .68102 .63038 L .67129 .63031 L p F P
0 g
s
.703 .841 .949 r
.67129 .63031 m .6632 .63926 L .67177 .64056 L p F P
0 g
s
.886 .885 .826 r
.83659 .5276 m .83179 .49479 L .82427 .5027 L p F P
0 g
s
.886 .885 .826 r
.82427 .5027 m .829 .53434 L .83659 .5276 L p F P
0 g
s
.448 .589 .9 r
.44442 .60358 m .44144 .58227 L .43184 .57744 L p F P
0 g
s
.466 .603 .903 r
.44144 .58227 m .44442 .60358 L .45394 .60682 L p F P
0 g
s
.599 .764 .958 r
.57223 .6459 m .5829 .64885 L .58642 .64397 L p F P
0 g
s
.606 .776 .961 r
.59564 .64516 m .58642 .64397 L .5829 .64885 L p F P
0 g
s
.645 .802 .958 r
.61765 .64867 m .62841 .6456 L .62298 .64135 L p F P
0 g
s
.645 .802 .958 r
.62298 .64135 m .61434 .64382 L .61765 .64867 L p F P
0 g
s
.383 .471 .827 r
.37073 .53696 m .37627 .50529 L .36861 .49748 L p F P
0 g
s
.399 .487 .834 r
.37627 .50529 m .37073 .53696 L .37874 .5434 L p F P
0 g
s
.503 .664 .934 r
.50036 .63068 m .4937 .6169 L .48353 .61482 L p F P
0 g
s
.521 .674 .934 r
.4937 .6169 m .50036 .63068 L .50997 .63113 L p F P
0 g
s
.798 .877 .905 r
.75581 .60185 m .75937 .58049 L .74969 .58518 L p F P
0 g
s
.798 .877 .905 r
.74969 .58518 m .74643 .6052 L .75581 .60185 L p F P
0 g
s
.556 .731 .956 r
.55543 .64473 m .54624 .63821 L .53741 .63994 L p F P
0 g
s
.575 .736 .951 r
.54624 .63821 m .55543 .64473 L .56284 .6416 L p F P
0 g
s
.576 .75 .96 r
.57223 .6459 m .56284 .6416 L .55543 .64473 L p F P
0 g
s
.737 .853 .935 r
.7001 .62958 m .70714 .61572 L .69694 .61762 L p F P
0 g
s
.737 .853 .935 r
.69694 .61762 m .69063 .63014 L .7001 .62958 L p F P
0 g
s
.676 .819 .952 r
.64515 .64424 m .65452 .63762 L .64575 .63565 L p F P
0 g
s
.676 .819 .952 r
.64575 .63565 m .63792 .64119 L .64515 .64424 L p F P
0 g
s
1 1 0 r
.007 w
.33072 .47014 m
.33429 .45681 L
s
.5 Mabswid
.876 .88 .834 r
.829 .53434 m .82427 .5027 L .81648 .51043 L p F P
0 g
s
.876 .88 .834 r
.81648 .51043 m .82115 .54089 L .829 .53434 L p F P
0 g
s
.594 .751 .953 r
.56284 .6416 m .57223 .6459 L .57784 .64159 L p F P
0 g
s
.599 .764 .958 r
.58642 .64397 m .57784 .64159 L .57223 .6459 L p F P
0 g
s
.466 .603 .903 r
.45394 .60682 m .45122 .58684 L .44144 .58227 L p F P
0 g
s
.482 .616 .906 r
.45122 .58684 m .45394 .60682 L .46364 .60977 L p F P
0 g
s
.659 .806 .953 r
.62841 .6456 m .63792 .64119 L .63061 .6378 L p F P
0 g
s
.659 .806 .953 r
.63061 .6378 m .62298 .64135 L .62841 .6456 L p F P
0 g
s
.399 .487 .834 r
.37874 .5434 m .38419 .51292 L .37627 .50529 L p F P
0 g
s
.415 .503 .841 r
.38419 .51292 m .37874 .5434 L .38701 .54964 L p F P
0 g
s
.543 .708 .948 r
.53741 .63994 m .52957 .63109 L .51971 .63127 L p F P
0 g
s
.561 .716 .944 r
.52957 .63109 m .53741 .63994 L .54624 .63821 L p F P
0 g
s
.697 .828 .945 r
.6632 .63926 m .67129 .63031 L .66145 .62992 L p F P
0 g
s
.697 .828 .945 r
.66145 .62992 m .65452 .63762 L .6632 .63926 L p F P
0 g
s
.788 .868 .908 r
.74643 .6052 m .74969 .58518 L .73983 .5896 L p F P
0 g
s
.788 .868 .908 r
.73983 .5896 m .73686 .60826 L .74643 .6052 L p F P
0 g
s
.521 .674 .934 r
.50997 .63113 m .50401 .61868 L .4937 .6169 L p F P
0 g
s
.538 .685 .933 r
.50401 .61868 m .50997 .63113 L .51971 .63127 L p F P
0 g
s
.867 .876 .841 r
.82115 .54089 m .81648 .51043 L .80844 .51799 L p F P
0 g
s
.867 .876 .841 r
.80844 .51799 m .81304 .54722 L .82115 .54089 L p F P
0 g
s
.62 .77 .952 r
.58642 .64397 m .59564 .64516 L .59691 .63962 L p F P
0 g
s
.628 .778 .953 r
.59564 .64516 m .60509 .64511 L .60403 .63958 L p F P
0 g
s
.628 .778 .953 r
.60403 .63958 m .59691 .63962 L .59564 .64516 L p F P
0 g
s
.728 .842 .935 r
.69063 .63014 m .69694 .61762 L .68661 .61921 L p F P
0 g
s
.728 .842 .935 r
.68661 .61921 m .68102 .63038 L .69063 .63014 L p F P
0 g
s
.638 .785 .952 r
.60509 .64511 m .61434 .64382 L .611 .63861 L p F P
0 g
s
.638 .785 .952 r
.611 .63861 m .60403 .63958 L .60509 .64511 L p F P
0 g
s
.482 .616 .906 r
.46364 .60977 m .46117 .59115 L .45122 .58684 L p F P
0 g
s
.498 .628 .909 r
.46117 .59115 m .46364 .60977 L .4735 .61244 L p F P
0 g
s
.415 .503 .841 r
.38701 .54964 m .39235 .52038 L .38419 .51292 L p F P
0 g
s
.43 .518 .847 r
.39235 .52038 m .38701 .54964 L .39552 .55566 L p F P
0 g
s
.614 .761 .95 r
.57784 .64159 m .58642 .64397 L .58997 .63872 L p F P
0 g
s
.62 .77 .952 r
.59691 .63962 m .58997 .63872 L .58642 .64397 L p F P
0 g
s
.649 .79 .95 r
.61434 .64382 m .62298 .64135 L .6175 .63674 L p F P
0 g
s
.649 .79 .95 r
.6175 .63674 m .611 .63861 L .61434 .64382 L p F P
0 g
s
.575 .736 .951 r
.56284 .6416 m .55516 .63614 L .54624 .63821 L p F P
0 g
s
.593 .74 .946 r
.55516 .63614 m .56284 .6416 L .57031 .63813 L p F P
0 g
s
.594 .751 .953 r
.57784 .64159 m .57031 .63813 L .56284 .6416 L p F P
0 g
s
.778 .86 .91 r
.73686 .60826 m .73983 .5896 L .7298 .59375 L p F P
0 g
s
.778 .86 .91 r
.7298 .59375 m .72711 .61104 L .73686 .60826 L p F P
0 g
s
.673 .806 .946 r
.63792 .64119 m .64575 .63565 L .63688 .63334 L p F P
0 g
s
.673 .806 .946 r
.63688 .63334 m .63061 .6378 L .63792 .64119 L p F P
0 g
s
.561 .716 .944 r
.54624 .63821 m .53952 .63058 L .52957 .63109 L p F P
0 g
s
.579 .723 .941 r
.53952 .63058 m .54624 .63821 L .55516 .63614 L p F P
0 g
s
.858 .871 .848 r
.81304 .54722 m .80844 .51799 L .80016 .52536 L p F P
0 g
s
.858 .871 .848 r
.80016 .52536 m .80467 .55335 L .81304 .54722 L p F P
0 g
s
.538 .685 .933 r
.51971 .63127 m .51443 .62016 L .50401 .61868 L p F P
0 g
s
.555 .694 .933 r
.51443 .62016 m .51971 .63127 L .52957 .63109 L p F P
0 g
s
.691 .816 .942 r
.65452 .63762 m .66145 .62992 L .65152 .6292 L p F P
0 g
s
.691 .816 .942 r
.65152 .6292 m .64575 .63565 L .65452 .63762 L p F P
0 g
s
.43 .518 .847 r
.39552 .55566 m .40075 .52764 L .39235 .52038 L p F P
0 g
s
.444 .533 .854 r
.40075 .52764 m .39552 .55566 L .40427 .56146 L p F P
0 g
s
.498 .628 .909 r
.4735 .61244 m .47129 .59518 L .46117 .59115 L p F P
0 g
s
.513 .64 .911 r
.47129 .59518 m .4735 .61244 L .48353 .61482 L p F P
0 g
s
.61 .752 .945 r
.57031 .63813 m .57784 .64159 L .58351 .63693 L p F P
0 g
s
.614 .761 .95 r
.58997 .63872 m .58351 .63693 L .57784 .64159 L p F P
0 g
s
.72 .831 .934 r
.68102 .63038 m .68661 .61921 L .67616 .6205 L p F P
0 g
s
.72 .831 .934 r
.67616 .6205 m .67129 .63031 L .68102 .63038 L p F P
0 g
s
.659 .793 .946 r
.62298 .64135 m .63061 .6378 L .62324 .63407 L p F P
0 g
s
.659 .793 .946 r
.62324 .63407 m .6175 .63674 L .62298 .64135 L p F P
0 g
s
.769 .851 .913 r
.72711 .61104 m .7298 .59375 L .71961 .59762 L p F P
0 g
s
.769 .851 .913 r
.71961 .59762 m .71721 .61353 L .72711 .61104 L p F P
0 g
s
.848 .866 .854 r
.80467 .55335 m .80016 .52536 L .79165 .53253 L p F P
0 g
s
.848 .866 .854 r
.79165 .53253 m .79606 .55925 L .80467 .55335 L p F P
0 g
s
.444 .533 .854 r
.40427 .56146 m .40937 .53471 L .40075 .52764 L p F P
0 g
s
.458 .547 .859 r
.40937 .53471 m .40427 .56146 L .41324 .56703 L p F P
0 g
s
.513 .64 .911 r
.48353 .61482 m .48156 .59894 L .47129 .59518 L p F P
0 g
s
.528 .651 .913 r
.48156 .59894 m .48353 .61482 L .4937 .6169 L p F P
0 g
s
.555 .694 .933 r
.52957 .63109 m .52497 .62133 L .51443 .62016 L p F P
0 g
s
.57 .703 .931 r
.52497 .62133 m .52957 .63109 L .53952 .63058 L p F P
0 g
s
1 1 0 r
.007 w
.86541 .45452 m
.86704 .45977 L
s
.5 Mabswid
.579 .723 .941 r
.55516 .63614 m .54957 .62976 L .53952 .63058 L p F P
0 g
s
.595 .729 .938 r
.54957 .62976 m .55516 .63614 L .56417 .63374 L p F P
0 g
s
.593 .74 .946 r
.57031 .63813 m .56417 .63374 L .55516 .63614 L p F P
0 g
s
.609 .743 .94 r
.56417 .63374 m .57031 .63813 L .57785 .63432 L p F P
0 g
s
.61 .752 .945 r
.58351 .63693 m .57785 .63432 L .57031 .63813 L p F P
0 g
s
.632 .765 .943 r
.58997 .63872 m .59691 .63962 L .59819 .63371 L p F P
0 g
s
.638 .77 .943 r
.59691 .63962 m .60403 .63958 L .60295 .63369 L p F P
0 g
s
.638 .77 .943 r
.60295 .63369 m .59819 .63371 L .59691 .63962 L p F P
0 g
s
.711 .82 .932 r
.67129 .63031 m .67616 .6205 L .6656 .62148 L p F P
0 g
s
.711 .82 .932 r
.6656 .62148 m .66145 .62992 L .67129 .63031 L p F P
0 g
s
.645 .775 .943 r
.60403 .63958 m .611 .63861 L .60762 .63303 L p F P
0 g
s
.645 .775 .943 r
.60762 .63303 m .60295 .63369 L .60403 .63958 L p F P
0 g
s
.67 .793 .941 r
.63061 .6378 m .63688 .63334 L .62794 .63071 L p F P
0 g
s
.67 .793 .941 r
.62794 .63071 m .62324 .63407 L .63061 .6378 L p F P
0 g
s
.759 .842 .915 r
.71721 .61353 m .71961 .59762 L .70928 .60121 L p F P
0 g
s
.759 .842 .915 r
.70928 .60121 m .70714 .61572 L .71721 .61353 L p F P
0 g
s
.685 .803 .938 r
.64575 .63565 m .65152 .6292 L .64149 .62817 L p F P
0 g
s
.685 .803 .938 r
.64149 .62817 m .63688 .63334 L .64575 .63565 L p F P
0 g
s
.839 .861 .86 r
.79606 .55925 m .79165 .53253 L .78291 .53949 L p F P
0 g
s
.839 .861 .86 r
.78291 .53949 m .78721 .56492 L .79606 .55925 L p F P
0 g
s
.628 .759 .941 r
.58351 .63693 m .58997 .63872 L .59354 .63311 L p F P
0 g
s
.632 .765 .943 r
.59819 .63371 m .59354 .63311 L .58997 .63872 L p F P
0 g
s
.652 .778 .941 r
.611 .63861 m .6175 .63674 L .61197 .63178 L p F P
0 g
s
.652 .778 .941 r
.61197 .63178 m .60762 .63303 L .611 .63861 L p F P
0 g
s
.458 .547 .859 r
.41324 .56703 m .41821 .54157 L .40937 .53471 L p F P
0 g
s
.471 .56 .864 r
.41821 .54157 m .41324 .56703 L .42244 .57236 L p F P
0 g
s
.528 .651 .913 r
.4937 .6169 m .49196 .60242 L .48156 .59894 L p F P
0 g
s
.542 .662 .915 r
.49196 .60242 m .4937 .6169 L .50401 .61868 L p F P
0 g
s
.407 .42 .762 r
.35326 .41911 m .33438 .45623 L .34065 .46474 L p F P
0 g
s
1 1 0 r
.007 w
.33452 .45596 m
.33472 .4552 L
s
.5 Mabswid
.625 .752 .938 r
.57785 .63432 m .58351 .63693 L .58923 .63191 L p F P
0 g
s
.628 .759 .941 r
.59354 .63311 m .58923 .63191 L .58351 .63693 L p F P
0 g
s
.57 .703 .931 r
.53952 .63058 m .53561 .62219 L .52497 .62133 L p F P
0 g
s
.585 .711 .93 r
.53561 .62219 m .53952 .63058 L .54957 .62976 L p F P
0 g
s
.749 .834 .916 r
.70714 .61572 m .70928 .60121 L .69881 .60452 L p F P
0 g
s
.749 .834 .916 r
.69881 .60452 m .69694 .61762 L .70714 .61572 L p F P
0 g
s
.659 .78 .938 r
.6175 .63674 m .62324 .63407 L .6158 .62999 L p F P
0 g
s
.659 .78 .938 r
.6158 .62999 m .61197 .63178 L .6175 .63674 L p F P
0 g
s
.83 .856 .866 r
.78721 .56492 m .78291 .53949 L .77396 .54624 L p F P
0 g
s
.83 .856 .866 r
.77396 .54624 m .77814 .57036 L .78721 .56492 L p F P
0 g
s
.703 .809 .931 r
.66145 .62992 m .6656 .62148 L .65495 .62215 L p F P
0 g
s
.703 .809 .931 r
.65495 .62215 m .65152 .6292 L .66145 .62992 L p F P
0 g
s
.471 .56 .864 r
.42244 .57236 m .42725 .5482 L .41821 .54157 L p F P
0 g
s
.484 .573 .869 r
.42725 .5482 m .42244 .57236 L .43184 .57744 L p F P
0 g
s
.542 .662 .915 r
.50401 .61868 m .50249 .60561 L .49196 .60242 L p F P
0 g
s
.556 .673 .916 r
.50249 .60561 m .50401 .61868 L .51443 .62016 L p F P
0 g
s
.595 .729 .938 r
.56417 .63374 m .5597 .62862 L .54957 .62976 L p F P
0 g
s
.61 .734 .934 r
.5597 .62862 m .56417 .63374 L .57324 .63101 L p F P
0 g
s
.609 .743 .94 r
.57785 .63432 m .57324 .63101 L .56417 .63374 L p F P
0 g
s
.679 .791 .934 r
.63688 .63334 m .64149 .62817 L .63139 .62681 L p F P
0 g
s
.679 .791 .934 r
.63139 .62681 m .62794 .63071 L .63688 .63334 L p F P
0 g
s
.74 .825 .917 r
.69694 .61762 m .69881 .60452 L .68822 .60754 L p F P
0 g
s
.74 .825 .917 r
.68822 .60754 m .68661 .61921 L .69694 .61762 L p F P
0 g
s
.624 .746 .934 r
.57324 .63101 m .57785 .63432 L .58545 .63016 L p F P
0 g
s
.625 .752 .938 r
.58923 .63191 m .58545 .63016 L .57785 .63432 L p F P
0 g
s
.82 .85 .871 r
.77814 .57036 m .77396 .54624 L .76481 .55276 L p F P
0 g
s
.82 .85 .871 r
.76481 .55276 m .76886 .57555 L .77814 .57036 L p F P
0 g
s
.407 .42 .762 r
.34065 .46474 m .35918 .42862 L .35326 .41911 L p F P
0 g
s
.419 .436 .771 r
.35918 .42862 m .34065 .46474 L .34722 .47313 L p F P
0 g
s
1 1 0 r
.007 w
.33593 .45222 m
.34072 .44044 L
s
.33472 .4552 m
.33593 .45222 L
s
.5 Mabswid
.666 .781 .935 r
.62324 .63407 m .62794 .63071 L .61894 .62774 L p F P
0 g
s
.666 .781 .935 r
.61894 .62774 m .6158 .62999 L .62324 .63407 L p F P
0 g
s
.905 .828 .76 r
.86522 .4531 m .84721 .41615 L .84145 .42574 L p F P
0 g
s
.905 .828 .76 r
.84145 .42574 m .85912 .46169 L .86522 .4531 L p F P
0 g
s
1 1 0 r
.007 w
.86243 .44494 m
.86452 .45165 L
s
.5 Mabswid
.484 .573 .869 r
.43184 .57744 m .43649 .55462 L .42725 .5482 L p F P
0 g
s
.496 .586 .874 r
.43649 .55462 m .43184 .57744 L .44144 .58227 L p F P
0 g
s
.585 .711 .93 r
.54957 .62976 m .54633 .62275 L .53561 .62219 L p F P
0 g
s
.599 .719 .929 r
.54633 .62275 m .54957 .62976 L .5597 .62862 L p F P
0 g
s
.556 .673 .916 r
.51443 .62016 m .51314 .6085 L .50249 .60561 L p F P
0 g
s
.569 .683 .917 r
.51314 .6085 m .51443 .62016 L .52497 .62133 L p F P
0 g
s
.694 .798 .929 r
.65152 .6292 m .65495 .62215 L .64422 .62251 L p F P
0 g
s
.694 .798 .929 r
.64422 .62251 m .64149 .62817 L .65152 .6292 L p F P
0 g
s
.643 .759 .933 r
.59354 .63311 m .59819 .63371 L .59948 .62745 L p F P
0 g
s
.646 .762 .934 r
.59819 .63371 m .60295 .63369 L .60187 .62744 L p F P
0 g
s
.646 .762 .934 r
.60187 .62744 m .59948 .62745 L .59819 .63371 L p F P
0 g
s
.65 .765 .933 r
.60295 .63369 m .60762 .63303 L .60421 .62711 L p F P
0 g
s
.65 .765 .933 r
.60421 .62711 m .60187 .62744 L .60295 .63369 L p F P
0 g
s
.811 .845 .875 r
.76886 .57555 m .76481 .55276 L .75547 .55905 L p F P
0 g
s
.811 .845 .875 r
.75547 .55905 m .75937 .58049 L .76886 .57555 L p F P
0 g
s
.73 .817 .918 r
.68661 .61921 m .68822 .60754 L .67753 .61026 L p F P
0 g
s
.73 .817 .918 r
.67753 .61026 m .67616 .6205 L .68661 .61921 L p F P
0 g
s
.64 .756 .932 r
.58923 .63191 m .59354 .63311 L .59715 .62715 L p F P
0 g
s
.643 .759 .933 r
.59948 .62745 m .59715 .62715 L .59354 .63311 L p F P
0 g
s
.654 .767 .932 r
.60762 .63303 m .61197 .63178 L .60639 .62648 L p F P
0 g
s
.654 .767 .932 r
.60639 .62648 m .60421 .62711 L .60762 .63303 L p F P
0 g
s
.496 .586 .874 r
.44144 .58227 m .4459 .56079 L .43649 .55462 L p F P
0 g
s
.508 .598 .878 r
.4459 .56079 m .44144 .58227 L .45122 .58684 L p F P
0 g
s
.419 .436 .771 r
.34722 .47313 m .36537 .43804 L .35918 .42862 L p F P
0 g
s
.431 .451 .779 r
.36537 .43804 m .34722 .47313 L .35407 .48139 L p F P
0 g
s
.897 .827 .769 r
.85912 .46169 m .84145 .42574 L .83541 .43525 L p F P
0 g
s
.897 .827 .769 r
.83541 .43525 m .85272 .47017 L .85912 .46169 L p F P
0 g
s
.61 .734 .934 r
.57324 .63101 m .5699 .62715 L .5597 .62862 L p F P
0 g
s
.624 .74 .93 r
.5699 .62715 m .57324 .63101 L .58237 .62794 L p F P
0 g
s
.624 .746 .934 r
.58545 .63016 m .58237 .62794 L .57324 .63101 L p F P
0 g
s
.638 .752 .931 r
.58545 .63016 m .58923 .63191 L .59498 .62654 L p F P
0 g
s
.64 .756 .932 r
.59715 .62715 m .59498 .62654 L .58923 .63191 L p F P
0 g
s
.672 .779 .93 r
.62794 .63071 m .63139 .62681 L .62123 .62514 L p F P
0 g
s
.672 .779 .93 r
.62123 .62514 m .61894 .62774 L .62794 .63071 L p F P
0 g
s
.569 .683 .917 r
.52497 .62133 m .52388 .61111 L .51314 .6085 L p F P
0 g
s
.581 .693 .918 r
.52388 .61111 m .52497 .62133 L .53561 .62219 L p F P
0 g
s
.658 .768 .931 r
.61197 .63178 m .6158 .62999 L .60831 .62558 L p F P
0 g
s
.658 .768 .931 r
.60831 .62558 m .60639 .62648 L .61197 .63178 L p F P
0 g
s
.599 .719 .929 r
.5597 .62862 m .55713 .62299 L .54633 .62275 L p F P
0 g
s
.613 .727 .927 r
.55713 .62299 m .5597 .62862 L .5699 .62715 L p F P
0 g
s
.802 .84 .88 r
.75937 .58049 m .75547 .55905 L .74595 .56509 L p F P
0 g
s
.802 .84 .88 r
.74595 .56509 m .74969 .58518 L .75937 .58049 L p F P
0 g
s
.508 .598 .878 r
.45122 .58684 m .45549 .56673 L .4459 .56079 L p F P
0 g
s
.52 .61 .883 r
.45549 .56673 m .45122 .58684 L .46117 .59115 L p F P
0 g
s
.72 .808 .919 r
.67616 .6205 m .67753 .61026 L .66674 .61268 L p F P
0 g
s
.72 .808 .919 r
.66674 .61268 m .6656 .62148 L .67616 .6205 L p F P
0 g
s
.686 .787 .927 r
.64149 .62817 m .64422 .62251 L .63343 .62256 L p F P
0 g
s
.686 .787 .927 r
.63343 .62256 m .63139 .62681 L .64149 .62817 L p F P
0 g
s
.638 .748 .928 r
.58237 .62794 m .58545 .63016 L .59309 .62566 L p F P
0 g
s
.638 .752 .931 r
.59498 .62654 m .59309 .62566 L .58545 .63016 L p F P
0 g
s
.431 .451 .779 r
.35407 .48139 m .37183 .44737 L .36537 .43804 L p F P
0 g
s
.443 .465 .787 r
.37183 .44737 m .35407 .48139 L .36121 .48951 L p F P
0 g
s
.662 .768 .928 r
.6158 .62999 m .61894 .62774 L .60987 .62445 L p F P
0 g
s
.662 .768 .928 r
.60987 .62445 m .60831 .62558 L .6158 .62999 L p F P
0 g
s
.889 .826 .778 r
.85272 .47017 m .83541 .43525 L .82909 .44467 L p F P
0 g
s
.889 .826 .778 r
.82909 .44467 m .84603 .47852 L .85272 .47017 L p F P
0 g
s
.581 .693 .918 r
.53561 .62219 m .53471 .61341 L .52388 .61111 L p F P
0 g
s
.594 .703 .919 r
.53471 .61341 m .53561 .62219 L .54633 .62275 L p F P
0 g
s
.792 .834 .884 r
.74969 .58518 m .74595 .56509 L .73626 .57089 L p F P
0 g
s
.792 .834 .884 r
.73626 .57089 m .73983 .5896 L .74969 .58518 L p F P
0 g
s
.52 .61 .883 r
.46117 .59115 m .46524 .57242 L .45549 .56673 L p F P
0 g
s
.531 .621 .886 r
.46524 .57242 m .46117 .59115 L .47129 .59518 L p F P
0 g
s
.711 .799 .92 r
.6656 .62148 m .66674 .61268 L .65587 .61481 L p F P
0 g
s
.711 .799 .92 r
.65587 .61481 m .65495 .62215 L .6656 .62148 L p F P
0 g
s
.613 .727 .927 r
.5699 .62715 m .56798 .62292 L .55713 .62299 L p F P
0 g
s
.626 .734 .925 r
.56798 .62292 m .5699 .62715 L .58015 .62536 L p F P
0 g
s
.624 .74 .93 r
.58237 .62794 m .58015 .62536 L .5699 .62715 L p F P
0 g
s
.677 .777 .925 r
.63139 .62681 m .63343 .62256 L .62258 .6223 L p F P
0 g
s
.677 .777 .925 r
.62258 .6223 m .62123 .62514 L .63139 .62681 L p F P
0 g
s
.638 .744 .926 r
.58015 .62536 m .58237 .62794 L .59155 .62455 L p F P
0 g
s
.638 .748 .928 r
.59309 .62566 m .59155 .62455 L .58237 .62794 L p F P
0 g
s
.783 .829 .888 r
.73983 .5896 m .73626 .57089 L .72642 .57644 L p F P
0 g
s
.783 .829 .888 r
.72642 .57644 m .7298 .59375 L .73983 .5896 L p F P
0 g
s
.666 .768 .926 r
.61894 .62774 m .62123 .62514 L .61102 .62314 L p F P
0 g
s
.666 .768 .926 r
.61102 .62314 m .60987 .62445 L .61894 .62774 L p F P
0 g
s
.594 .703 .919 r
.54633 .62275 m .54562 .61542 L .53471 .61341 L p F P
0 g
s
.606 .712 .919 r
.54562 .61542 m .54633 .62275 L .55713 .62299 L p F P
0 g
s
1 1 0 r
.007 w
.85582 .43036 m
.86243 .44494 L
s
.5 Mabswid
.531 .621 .886 r
.47129 .59518 m .47514 .57784 L .46524 .57242 L p F P
0 g
s
.543 .633 .89 r
.47514 .57784 m .47129 .59518 L .48156 .59894 L p F P
0 g
s
.443 .465 .787 r
.36121 .48951 m .37854 .45659 L .37183 .44737 L p F P
0 g
s
.454 .478 .795 r
.37854 .45659 m .36121 .48951 L .36861 .49748 L p F P
0 g
s
.882 .825 .787 r
.84603 .47852 m .82909 .44467 L .82251 .45397 L p F P
0 g
s
.882 .825 .787 r
.82251 .45397 m .83905 .48673 L .84603 .47852 L p F P
0 g
s
.701 .79 .92 r
.65495 .62215 m .65587 .61481 L .64493 .61663 L p F P
0 g
s
.701 .79 .92 r
.64493 .61663 m .64422 .62251 L .65495 .62215 L p F P
0 g
s
.652 .753 .924 r
.60077 .62083 m .59715 .62715 L .59948 .62745 L closepath p F P
0 g
s
.653 .754 .924 r
.60077 .62083 m .59948 .62745 L .60187 .62744 L closepath p F P
0 g
s
.654 .755 .924 r
.60077 .62083 m .60187 .62744 L .60421 .62711 L closepath p F P
0 g
s
.651 .752 .924 r
.60077 .62083 m .59498 .62654 L .59715 .62715 L closepath p F P
0 g
s
.656 .756 .924 r
.60077 .62083 m .60421 .62711 L .60639 .62648 L closepath p F P
0 g
s
.773 .823 .891 r
.7298 .59375 m .72642 .57644 L .71643 .58171 L p F P
0 g
s
.773 .823 .891 r
.71643 .58171 m .71961 .59762 L .7298 .59375 L p F P
0 g
s
.543 .633 .89 r
.48156 .59894 m .48517 .58301 L .47514 .57784 L p F P
0 g
s
.553 .644 .894 r
.48517 .58301 m .48156 .59894 L .49196 .60242 L p F P
0 g
s
.651 .751 .923 r
.60077 .62083 m .59309 .62566 L .59498 .62654 L closepath p F P
0 g
s
.606 .712 .919 r
.55713 .62299 m .55658 .61712 L .54562 .61542 L p F P
0 g
s
.617 .721 .92 r
.55658 .61712 m .55713 .62299 L .56798 .62292 L p F P
0 g
s
.657 .756 .923 r
.60077 .62083 m .60639 .62648 L .60831 .62558 L closepath p F P
0 g
s
.626 .734 .925 r
.58015 .62536 m .57888 .62254 L .56798 .62292 L p F P
0 g
s
.638 .741 .923 r
.57888 .62254 m .58015 .62536 L .59044 .62326 L p F P
0 g
s
.638 .744 .926 r
.59155 .62455 m .59044 .62326 L .58015 .62536 L p F P
0 g
s
.454 .478 .795 r
.36861 .49748 m .3855 .46568 L .37854 .45659 L p F P
0 g
s
.464 .492 .802 r
.3855 .46568 m .36861 .49748 L .37627 .50529 L p F P
0 g
s
.691 .782 .92 r
.64422 .62251 m .64493 .61663 L .63394 .61814 L p F P
0 g
s
.691 .782 .92 r
.63394 .61814 m .63343 .62256 L .64422 .62251 L p F P
0 g
s
.669 .766 .923 r
.62123 .62514 m .62258 .6223 L .61169 .62172 L p F P
0 g
s
.669 .766 .923 r
.61169 .62172 m .61102 .62314 L .62123 .62514 L p F P
0 g
s
.874 .823 .795 r
.83905 .48673 m .82251 .45397 L .81568 .46316 L p F P
0 g
s
.874 .823 .795 r
.81568 .46316 m .83179 .49479 L .83905 .48673 L p F P
0 g
s
.65 .75 .922 r
.60077 .62083 m .59155 .62455 L .59309 .62566 L closepath p F P
0 g
s
.658 .756 .922 r
.60077 .62083 m .60831 .62558 L .60987 .62445 L closepath p F P
0 g
s
.764 .818 .895 r
.71961 .59762 m .71643 .58171 L .70631 .58672 L p F P
0 g
s
.764 .818 .895 r
.70631 .58672 m .70928 .60121 L .71961 .59762 L p F P
0 g
s
.553 .644 .894 r
.49196 .60242 m .49532 .5879 L .48517 .58301 L p F P
0 g
s
.564 .655 .897 r
.49532 .5879 m .49196 .60242 L .50249 .60561 L p F P
0 g
s
.617 .721 .92 r
.56798 .62292 m .56759 .61851 L .55658 .61712 L p F P
0 g
s
.629 .73 .92 r
.56759 .61851 m .56798 .62292 L .57888 .62254 L p F P
0 g
s
.65 .749 .921 r
.60077 .62083 m .59044 .62326 L .59155 .62455 L closepath p F P
0 g
s
.66 .756 .922 r
.60077 .62083 m .60987 .62445 L .61102 .62314 L closepath p F P
0 g
s
.681 .773 .92 r
.63343 .62256 m .63394 .61814 L .6229 .61935 L p F P
0 g
s
.681 .773 .92 r
.6229 .61935 m .62258 .6223 L .63343 .62256 L p F P
0 g
s
.754 .812 .898 r
.70928 .60121 m .70631 .58672 L .69608 .59146 L p F P
0 g
s
.754 .812 .898 r
.69608 .59146 m .69881 .60452 L .70928 .60121 L p F P
0 g
s
.564 .655 .897 r
.50249 .60561 m .50558 .59252 L .49532 .5879 L p F P
0 g
s
.574 .665 .9 r
.50558 .59252 m .50249 .60561 L .51314 .6085 L p F P
0 g
s
1 1 0 r
.007 w
.34072 .44044 m
.34307 .43617 L
s
.34307 .43617 m
.3487 .42596 L
s
.5 Mabswid
.464 .492 .802 r
.37627 .50529 m .3927 .47464 L .3855 .46568 L p F P
0 g
s
.474 .505 .809 r
.3927 .47464 m .37627 .50529 L .38419 .51292 L p F P
0 g
s
.867 .822 .802 r
.83179 .49479 m .81568 .46316 L .8086 .47221 L p F P
0 g
s
.867 .822 .802 r
.8086 .47221 m .82427 .5027 L .83179 .49479 L p F P
0 g
s
.638 .741 .923 r
.59044 .62326 m .58981 .62184 L .57888 .62254 L p F P
0 g
s
.651 .747 .92 r
.60077 .62083 m .58981 .62184 L .59044 .62326 L closepath p F P
0 g
s
.574 .665 .9 r
.51314 .6085 m .51594 .59685 L .50558 .59252 L p F P
0 g
s
.584 .676 .903 r
.51594 .59685 m .51314 .6085 L .52388 .61111 L p F P
0 g
s
.629 .73 .92 r
.57888 .62254 m .57863 .61959 L .56759 .61851 L p F P
0 g
s
.64 .738 .92 r
.57863 .61959 m .57888 .62254 L .58981 .62184 L p F P
0 g
s
.745 .806 .901 r
.69881 .60452 m .69608 .59146 L .68573 .59591 L p F P
0 g
s
.745 .806 .901 r
.68573 .59591 m .68822 .60754 L .69881 .60452 L p F P
0 g
s
.661 .756 .921 r
.60077 .62083 m .61102 .62314 L .61169 .62172 L closepath p F P
0 g
s
.671 .764 .92 r
.62258 .6223 m .6229 .61935 L .61184 .62025 L p F P
0 g
s
.671 .764 .92 r
.61184 .62025 m .61169 .62172 L .62258 .6223 L p F P
0 g
s
.584 .676 .903 r
.52388 .61111 m .52639 .6009 L .51594 .59685 L p F P
0 g
s
.594 .686 .906 r
.52639 .6009 m .52388 .61111 L .53471 .61341 L p F P
0 g
s
.735 .8 .904 r
.68822 .60754 m .68573 .59591 L .6753 .60007 L p F P
0 g
s
.735 .8 .904 r
.6753 .60007 m .67753 .61026 L .68822 .60754 L p F P
0 g
s
.474 .505 .809 r
.38419 .51292 m .40013 .48346 L .3927 .47464 L p F P
0 g
s
.484 .517 .816 r
.40013 .48346 m .38419 .51292 L .39235 .52038 L p F P
0 g
s
.64 .738 .92 r
.58981 .62184 m .5897 .62037 L .57863 .61959 L p F P
0 g
s
.651 .746 .919 r
.60077 .62083 m .5897 .62037 L .58981 .62184 L closepath p F P
0 g
s
.661 .755 .92 r
.60077 .62083 m .61169 .62172 L .61184 .62025 L closepath p F P
0 g
s
.594 .686 .906 r
.53471 .61341 m .53691 .60465 L .52639 .6009 L p F P
0 g
s
.604 .696 .908 r
.53691 .60465 m .53471 .61341 L .54562 .61542 L p F P
0 g
s
.725 .794 .906 r
.67753 .61026 m .6753 .60007 L .66478 .60395 L p F P
0 g
s
.725 .794 .906 r
.66478 .60395 m .66674 .61268 L .67753 .61026 L p F P
0 g
s
.859 .82 .81 r
.82427 .5027 m .8086 .47221 L .80127 .48112 L p F P
0 g
s
.859 .82 .81 r
.80127 .48112 m .81648 .51043 L .82427 .5027 L p F P
0 g
s
.604 .696 .908 r
.54562 .61542 m .54748 .60811 L .53691 .60465 L p F P
0 g
s
.614 .706 .91 r
.54748 .60811 m .54562 .61542 L .55658 .61712 L p F P
0 g
s
.715 .788 .909 r
.66674 .61268 m .66478 .60395 L .6542 .60752 L p F P
0 g
s
.715 .788 .909 r
.6542 .60752 m .65587 .61481 L .66674 .61268 L p F P
0 g
s
.614 .706 .91 r
.55658 .61712 m .5581 .61127 L .54748 .60811 L p F P
0 g
s
.624 .716 .913 r
.5581 .61127 m .55658 .61712 L .56759 .61851 L p F P
0 g
s
.662 .752 .917 r
.60077 .62083 m .61062 .61742 L .60929 .6162 L closepath p F P
0 g
s
.662 .751 .916 r
.60077 .62083 m .60929 .6162 L .60757 .61519 L closepath p F P
0 g
s
.662 .749 .915 r
.60077 .62083 m .60757 .61519 L .60552 .61444 L closepath p F P
0 g
s
.661 .748 .915 r
.60077 .62083 m .60552 .61444 L .60325 .61398 L closepath p F P
0 g
s
.66 .747 .915 r
.60077 .62083 m .60325 .61398 L .60086 .61383 L closepath p F P
0 g
s
.659 .746 .915 r
.60077 .62083 m .60086 .61383 L .59847 .614 L closepath p F P
0 g
s
.658 .746 .915 r
.60077 .62083 m .59847 .614 L .59618 .61449 L closepath p F P
0 g
s
.656 .745 .915 r
.60077 .62083 m .59618 .61449 L .59411 .61527 L closepath p F P
0 g
s
.655 .745 .916 r
.60077 .62083 m .59411 .61527 L .59236 .61629 L closepath p F P
0 g
s
.654 .745 .917 r
.60077 .62083 m .59236 .61629 L .591 .61753 L closepath p F P
0 g
s
.653 .745 .917 r
.60077 .62083 m .591 .61753 L .5901 .61891 L closepath p F P
0 g
s
.652 .746 .918 r
.60077 .62083 m .5901 .61891 L .5897 .62037 L closepath p F P
0 g
s
.662 .754 .919 r
.60077 .62083 m .61184 .62025 L .61148 .61879 L closepath p F P
0 g
s
.662 .753 .918 r
.60077 .62083 m .61148 .61879 L .61062 .61742 L closepath p F P
0 g
s
.705 .781 .911 r
.65587 .61481 m .6542 .60752 L .64357 .6108 L p F P
0 g
s
.705 .781 .911 r
.64357 .6108 m .64493 .61663 L .65587 .61481 L p F P
0 g
s
.624 .716 .913 r
.56759 .61851 m .56875 .61412 L .5581 .61127 L p F P
0 g
s
.633 .726 .915 r
.56875 .61412 m .56759 .61851 L .57863 .61959 L p F P
0 g
s
.642 .736 .917 r
.57942 .61667 m .57863 .61959 L .5897 .62037 L p F P
0 g
s
.642 .736 .917 r
.5897 .62037 m .5901 .61891 L .57942 .61667 L p F P
0 g
s
.633 .726 .915 r
.57863 .61959 m .57942 .61667 L .56875 .61412 L p F P
0 g
s
.673 .761 .917 r
.61148 .61879 m .61184 .62025 L .6229 .61935 L p F P
0 g
s
.484 .517 .816 r
.39235 .52038 m .40778 .49212 L .40013 .48346 L p F P
0 g
s
.494 .529 .822 r
.40778 .49212 m .39235 .52038 L .40075 .52764 L p F P
0 g
s
.694 .775 .913 r
.64493 .61663 m .64357 .6108 L .6329 .61377 L p F P
0 g
s
.694 .775 .913 r
.6329 .61377 m .63394 .61814 L .64493 .61663 L p F P
0 g
s
.684 .768 .915 r
.6222 .61643 m .6229 .61935 L .63394 .61814 L p F P
0 g
s
.673 .761 .917 r
.6229 .61935 m .6222 .61643 L .61148 .61879 L p F P
0 g
s
.684 .768 .915 r
.63394 .61814 m .6329 .61377 L .6222 .61643 L p F P
0 g
s
.851 .818 .816 r
.81648 .51043 m .80127 .48112 L .79372 .48987 L p F P
0 g
s
.851 .818 .816 r
.79372 .48987 m .80844 .51799 L .81648 .51043 L p F P
0 g
s
.645 .734 .914 r
.58121 .61391 m .57942 .61667 L .5901 .61891 L p F P
0 g
s
.645 .734 .914 r
.5901 .61891 m .591 .61753 L .58121 .61391 L p F P
0 g
s
.674 .758 .914 r
.61062 .61742 m .61148 .61879 L .6222 .61643 L p F P
0 g
s
.494 .529 .822 r
.40075 .52764 m .41565 .50061 L .40778 .49212 L p F P
0 g
s
.503 .541 .829 r
.41565 .50061 m .40075 .52764 L .40937 .53471 L p F P
0 g
s
.843 .817 .823 r
.80844 .51799 m .79372 .48987 L .78594 .49846 L p F P
0 g
s
.843 .817 .823 r
.78594 .49846 m .80016 .52536 L .80844 .51799 L p F P
0 g
s
.649 .734 .911 r
.58393 .61143 m .58121 .61391 L .591 .61753 L p F P
0 g
s
.649 .734 .911 r
.591 .61753 m .59236 .61629 L .58393 .61143 L p F P
0 g
s
.674 .754 .911 r
.60929 .6162 m .61062 .61742 L .62048 .61369 L p F P
0 g
s
.674 .758 .914 r
.6222 .61643 m .62048 .61369 L .61062 .61742 L p F P
0 g
s
.638 .724 .91 r
.57142 .60997 m .56875 .61412 L .57942 .61667 L p F P
0 g
s
.638 .724 .91 r
.57942 .61667 m .58121 .61391 L .57142 .60997 L p F P
0 g
s
.685 .763 .91 r
.62048 .61369 m .6222 .61643 L .6329 .61377 L p F P
0 g
s
.503 .541 .829 r
.40937 .53471 m .42371 .50892 L .41565 .50061 L p F P
0 g
s
.512 .553 .835 r
.42371 .50892 m .40937 .53471 L .41821 .54157 L p F P
0 g
s
.836 .815 .829 r
.80016 .52536 m .78594 .49846 L .77796 .50688 L p F P
0 g
s
.836 .815 .829 r
.77796 .50688 m .79165 .53253 L .80016 .52536 L p F P
0 g
s
.652 .734 .909 r
.58743 .60937 m .58393 .61143 L .59236 .61629 L p F P
0 g
s
.652 .734 .909 r
.59236 .61629 m .59411 .61527 L .58743 .60937 L p F P
0 g
s
.674 .754 .911 r
.62048 .61369 m .61784 .61125 L .60929 .6162 L p F P
0 g
s
.673 .751 .909 r
.60757 .61519 m .60929 .6162 L .61784 .61125 L p F P
0 g
s
.631 .713 .906 r
.56163 .60573 m .5581 .61127 L .56875 .61412 L p F P
0 g
s
.631 .713 .906 r
.56875 .61412 m .57142 .60997 L .56163 .60573 L p F P
0 g
s
.512 .553 .835 r
.41821 .54157 m .43198 .51704 L .42371 .50892 L p F P
0 g
s
.521 .564 .84 r
.43198 .51704 m .41821 .54157 L .42725 .5482 L p F P
0 g
s
.696 .767 .907 r
.63034 .60965 m .6329 .61377 L .64357 .6108 L p F P
0 g
s
.685 .763 .91 r
.6329 .61377 m .63034 .60965 L .62048 .61369 L p F P
0 g
s
.656 .734 .907 r
.59157 .60781 m .58743 .60937 L .59411 .61527 L p F P
0 g
s
.656 .734 .907 r
.59411 .61527 m .59618 .61449 L .59157 .60781 L p F P
0 g
s
.673 .751 .909 r
.61784 .61125 m .61438 .60922 L .60757 .61519 L p F P
0 g
s
.671 .747 .907 r
.60552 .61444 m .60757 .61519 L .61438 .60922 L p F P
0 g
s
.828 .812 .835 r
.79165 .53253 m .77796 .50688 L .76977 .5151 L p F P
0 g
s
.828 .812 .835 r
.76977 .5151 m .78291 .53949 L .79165 .53253 L p F P
0 g
s
1 1 0 r
.007 w
.84976 .42036 m
.85582 .43036 L
s
.5 Mabswid
.623 .703 .902 r
.55186 .60118 m .54748 .60811 L .5581 .61127 L p F P
0 g
s
.623 .703 .902 r
.5581 .61127 m .56163 .60573 L .55186 .60118 L p F P
0 g
s
.644 .723 .906 r
.57548 .60625 m .57142 .60997 L .58121 .61391 L p F P
0 g
s
.644 .723 .906 r
.58121 .61391 m .58393 .61143 L .57548 .60625 L p F P
0 g
s
.521 .564 .84 r
.42725 .5482 m .44042 .52497 L .43198 .51704 L p F P
0 g
s
.53 .576 .846 r
.44042 .52497 m .42725 .5482 L .43649 .55462 L p F P
0 g
s
.66 .736 .906 r
.59615 .60683 m .59157 .60781 L .59618 .61449 L p F P
0 g
s
.66 .736 .906 r
.59618 .61449 m .59847 .614 L .59615 .60683 L p F P
0 g
s
.671 .747 .907 r
.61438 .60922 m .61028 .6077 L .60552 .61444 L p F P
0 g
s
.669 .744 .906 r
.60325 .61398 m .60552 .61444 L .61028 .6077 L p F P
0 g
s
.685 .757 .906 r
.61784 .61125 m .62048 .61369 L .63034 .60965 L p F P
0 g
s
.706 .771 .903 r
.64019 .6053 m .64357 .6108 L .6542 .60752 L p F P
0 g
s
.696 .767 .907 r
.64357 .6108 m .64019 .6053 L .63034 .60965 L p F P
0 g
s
.663 .738 .905 r
.60095 .60648 m .59615 .60683 L .59847 .614 L p F P
0 g
s
.663 .738 .905 r
.59847 .614 m .60086 .61383 L .60095 .60648 L p F P
0 g
s
.669 .744 .906 r
.61028 .6077 m .60573 .60678 L .60325 .61398 L p F P
0 g
s
.666 .741 .905 r
.60086 .61383 m .60325 .61398 L .60573 .60678 L p F P
0 g
s
.666 .741 .905 r
.60573 .60678 m .60095 .60648 L .60086 .61383 L p F P
0 g
s
.616 .692 .898 r
.54212 .59633 m .53691 .60465 L .54748 .60811 L p F P
0 g
s
.616 .692 .898 r
.54748 .60811 m .55186 .60118 L .54212 .59633 L p F P
0 g
s
.82 .81 .841 r
.78291 .53949 m .76977 .5151 L .76139 .52313 L p F P
0 g
s
.82 .81 .841 r
.76139 .52313 m .77396 .54624 L .78291 .53949 L p F P
0 g
s
.53 .576 .846 r
.43649 .55462 m .44903 .53268 L .44042 .52497 L p F P
0 g
s
.538 .587 .851 r
.44903 .53268 m .43649 .55462 L .4459 .56079 L p F P
0 g
s
.716 .775 .899 r
.65001 .60064 m .6542 .60752 L .66478 .60395 L p F P
0 g
s
.706 .771 .903 r
.6542 .60752 m .65001 .60064 L .64019 .6053 L p F P
0 g
s
.608 .682 .894 r
.53242 .59119 m .52639 .6009 L .53691 .60465 L p F P
0 g
s
.608 .682 .894 r
.53691 .60465 m .54212 .59633 L .53242 .59119 L p F P
0 g
s
.538 .587 .851 r
.4459 .56079 m .45781 .54017 L .44903 .53268 L p F P
0 g
s
.546 .598 .857 r
.45781 .54017 m .4459 .56079 L .45549 .56673 L p F P
0 g
s
.812 .808 .847 r
.77396 .54624 m .76139 .52313 L .75283 .53094 L p F P
0 g
s
.812 .808 .847 r
.75283 .53094 m .76481 .55276 L .77396 .54624 L p F P
0 g
s
.601 .671 .89 r
.52278 .58575 m .51594 .59685 L .52639 .6009 L p F P
0 g
s
.601 .671 .89 r
.52639 .6009 m .53242 .59119 L .52278 .58575 L p F P
0 g
s
.726 .779 .895 r
.65979 .59568 m .66478 .60395 L .6753 .60007 L p F P
0 g
s
.716 .775 .899 r
.66478 .60395 m .65979 .59568 L .65001 .60064 L p F P
0 g
s
.649 .723 .902 r
.58074 .60314 m .57548 .60625 L .58393 .61143 L p F P
0 g
s
.649 .723 .902 r
.58393 .61143 m .58743 .60937 L .58074 .60314 L p F P
0 g
s
.546 .598 .857 r
.45549 .56673 m .46674 .54744 L .45781 .54017 L p F P
0 g
s
.554 .608 .862 r
.46674 .54744 m .45549 .56673 L .46524 .57242 L p F P
0 g
s
.685 .757 .906 r
.63034 .60965 m .62639 .60597 L .61784 .61125 L p F P
0 g
s
.683 .751 .902 r
.61438 .60922 m .61784 .61125 L .62639 .60597 L p F P
0 g
s
.638 .712 .9 r
.56702 .60076 m .56163 .60573 L .57142 .60997 L p F P
0 g
s
.638 .712 .9 r
.57142 .60997 m .57548 .60625 L .56702 .60076 L p F P
0 g
s
.804 .806 .852 r
.76481 .55276 m .75283 .53094 L .7441 .53854 L p F P
0 g
s
.804 .806 .852 r
.7441 .53854 m .75547 .55905 L .76481 .55276 L p F P
0 g
s
.593 .661 .885 r
.5132 .58004 m .50558 .59252 L .51594 .59685 L p F P
0 g
s
.593 .661 .885 r
.51594 .59685 m .52278 .58575 L .5132 .58004 L p F P
0 g
s
.554 .608 .862 r
.46524 .57242 m .4758 .55447 L .46674 .54744 L p F P
0 g
s
.562 .619 .867 r
.4758 .55447 m .46524 .57242 L .47514 .57784 L p F P
0 g
s
.695 .759 .901 r
.62639 .60597 m .63034 .60965 L .64019 .6053 L p F P
0 g
s
.735 .782 .89 r
.66953 .59042 m .6753 .60007 L .68573 .59591 L p F P
0 g
s
.726 .779 .895 r
.6753 .60007 m .66953 .59042 L .65979 .59568 L p F P
0 g
s
.586 .651 .881 r
.5037 .57404 m .49532 .5879 L .50558 .59252 L p F P
0 g
s
.586 .651 .881 r
.50558 .59252 m .5132 .58004 L .5037 .57404 L p F P
0 g
s
.562 .619 .867 r
.47514 .57784 m .48499 .56125 L .4758 .55447 L p F P
0 g
s
.57 .63 .871 r
.48499 .56125 m .47514 .57784 L .48517 .58301 L p F P
0 g
s
.578 .64 .876 r
.4943 .56778 m .48517 .58301 L .49532 .5879 L p F P
0 g
s
.578 .64 .876 r
.49532 .5879 m .5037 .57404 L .4943 .56778 L p F P
0 g
s
.57 .63 .871 r
.48517 .58301 m .4943 .56778 L .48499 .56125 L p F P
0 g
s
.796 .803 .858 r
.75547 .55905 m .7441 .53854 L .73521 .54592 L p F P
0 g
s
.796 .803 .858 r
.73521 .54592 m .74595 .56509 L .75547 .55905 L p F P
0 g
s
1 1 0 r
.007 w
.3487 .42596 m
.35254 .42054 L
s
.5 Mabswid
.744 .786 .886 r
.67919 .58488 m .68573 .59591 L .69608 .59146 L p F P
0 g
s
.735 .782 .89 r
.68573 .59591 m .67919 .58488 L .66953 .59042 L p F P
0 g
s
.788 .8 .863 r
.74595 .56509 m .73521 .54592 L .72617 .55305 L p F P
0 g
s
.788 .8 .863 r
.72617 .55305 m .73626 .57089 L .74595 .56509 L p F P
0 g
s
.753 .789 .882 r
.68879 .57905 m .69608 .59146 L .70631 .58672 L p F P
0 g
s
.744 .786 .886 r
.69608 .59146 m .68879 .57905 L .67919 .58488 L p F P
0 g
s
.655 .724 .899 r
.58695 .60079 m .58074 .60314 L .58743 .60937 L p F P
0 g
s
.655 .724 .899 r
.58743 .60937 m .59157 .60781 L .58695 .60079 L p F P
0 g
s
.779 .798 .868 r
.73626 .57089 m .72617 .55305 L .717 .55994 L p F P
0 g
s
.779 .798 .868 r
.717 .55994 m .72642 .57644 L .73626 .57089 L p F P
0 g
s
.762 .792 .877 r
.6983 .57295 m .70631 .58672 L .71643 .58171 L p F P
0 g
s
.753 .789 .882 r
.70631 .58672 m .6983 .57295 L .68879 .57905 L p F P
0 g
s
.683 .751 .902 r
.62639 .60597 m .62121 .60292 L .61438 .60922 L p F P
0 g
s
.68 .745 .9 r
.61028 .6077 m .61438 .60922 L .62121 .60292 L p F P
0 g
s
.771 .795 .873 r
.72642 .57644 m .717 .55994 L .7077 .56658 L p F P
0 g
s
.771 .795 .873 r
.7077 .56658 m .71643 .58171 L .72642 .57644 L p F P
0 g
s
.762 .792 .877 r
.71643 .58171 m .7077 .56658 L .6983 .57295 L p F P
0 g
s
.633 .701 .895 r
.55858 .59496 m .55186 .60118 L .56163 .60573 L p F P
0 g
s
.633 .701 .895 r
.56163 .60573 m .56702 .60076 L .55858 .59496 L p F P
0 g
s
.705 .76 .895 r
.63493 .60038 m .64019 .6053 L .65001 .60064 L p F P
0 g
s
.695 .759 .901 r
.64019 .6053 m .63493 .60038 L .62639 .60597 L p F P
0 g
s
.661 .726 .897 r
.59382 .59932 m .58695 .60079 L .59157 .60781 L p F P
0 g
s
.661 .726 .897 r
.59157 .60781 m .59615 .60683 L .59382 .59932 L p F P
0 g
s
.68 .745 .9 r
.62121 .60292 m .61506 .60064 L .61028 .6077 L p F P
0 g
s
.677 .739 .898 r
.60573 .60678 m .61028 .6077 L .61506 .60064 L p F P
0 g
s
.646 .712 .895 r
.57403 .5966 m .56702 .60076 L .57548 .60625 L p F P
0 g
s
.646 .712 .895 r
.57548 .60625 m .58074 .60314 L .57403 .5966 L p F P
0 g
s
.693 .75 .896 r
.62121 .60292 m .62639 .60597 L .63493 .60038 L p F P
0 g
s
.667 .73 .896 r
.60103 .59879 m .59382 .59932 L .59615 .60683 L p F P
0 g
s
.667 .73 .896 r
.59615 .60683 m .60095 .60648 L .60103 .59879 L p F P
0 g
s
.677 .739 .898 r
.61506 .60064 m .60822 .59924 L .60573 .60678 L p F P
0 g
s
.672 .734 .897 r
.60095 .60648 m .60573 .60678 L .60822 .59924 L p F P
0 g
s
.672 .734 .897 r
.60822 .59924 m .60103 .59879 L .60095 .60648 L p F P
0 g
s
.628 .691 .889 r
.55014 .58885 m .54212 .59633 L .55186 .60118 L p F P
0 g
s
.628 .691 .889 r
.55186 .60118 m .55858 .59496 L .55014 .58885 L p F P
0 g
s
.714 .762 .89 r
.64346 .59448 m .65001 .60064 L .65979 .59568 L p F P
0 g
s
.705 .76 .895 r
.65001 .60064 m .64346 .59448 L .63493 .60038 L p F P
0 g
s
.655 .714 .892 r
.58231 .59345 m .57403 .5966 L .58074 .60314 L p F P
0 g
s
.655 .714 .892 r
.58074 .60314 m .58695 .60079 L .58231 .59345 L p F P
0 g
s
.693 .75 .896 r
.63493 .60038 m .62804 .5963 L .62121 .60292 L p F P
0 g
s
.689 .742 .892 r
.61506 .60064 m .62121 .60292 L .62804 .5963 L p F P
0 g
s
.623 .68 .884 r
.54174 .58245 m .53242 .59119 L .54212 .59633 L p F P
0 g
s
.623 .68 .884 r
.54212 .59633 m .55014 .58885 L .54174 .58245 L p F P
0 g
s
.491 .455 .745 r
.38473 .38501 m .35326 .41911 L .35918 .42862 L p F P
0 g
s
1 1 0 r
.007 w
.35448 .41779 m
.35865 .41189 L
s
.5 Mabswid
.643 .702 .889 r
.56731 .58974 m .55858 .59496 L .56702 .60076 L p F P
0 g
s
.643 .702 .889 r
.56702 .60076 m .57403 .5966 L .56731 .58974 L p F P
0 g
s
.723 .763 .884 r
.65197 .58828 m .65979 .59568 L .66953 .59042 L p F P
0 g
s
.714 .762 .89 r
.65979 .59568 m .65197 .58828 L .64346 .59448 L p F P
0 g
s
.701 .75 .889 r
.62804 .5963 m .63493 .60038 L .64346 .59448 L p F P
0 g
s
.663 .717 .889 r
.59149 .59148 m .58231 .59345 L .58695 .60079 L p F P
0 g
s
.663 .717 .889 r
.58695 .60079 m .59382 .59932 L .59149 .59148 L p F P
0 g
s
.689 .742 .892 r
.62804 .5963 m .61984 .59325 L .61506 .60064 L p F P
0 g
s
.683 .734 .889 r
.60822 .59924 m .61506 .60064 L .61984 .59325 L p F P
0 g
s
.617 .67 .878 r
.53337 .57575 m .52278 .58575 L .53242 .59119 L p F P
0 g
s
.617 .67 .878 r
.53242 .59119 m .54174 .58245 L .53337 .57575 L p F P
0 g
s
.491 .455 .745 r
.35918 .42862 m .38997 .39546 L .38473 .38501 L p F P
0 g
s
.498 .467 .753 r
.38997 .39546 m .35918 .42862 L .36537 .43804 L p F P
0 g
s
.732 .764 .879 r
.66044 .58178 m .66953 .59042 L .67919 .58488 L p F P
0 g
s
.723 .763 .884 r
.66953 .59042 m .66044 .58178 L .65197 .58828 L p F P
0 g
s
.868 .763 .744 r
.84721 .41615 m .81652 .38239 L .81142 .39292 L p F P
0 g
s
.868 .763 .744 r
.81142 .39292 m .84145 .42574 L .84721 .41615 L p F P
0 g
s
1 1 0 r
.007 w
.84721 .41615 m
.84976 .42036 L
s
.5 Mabswid
.67 .722 .888 r
.60111 .59077 m .59149 .59148 L .59382 .59932 L p F P
0 g
s
.67 .722 .888 r
.59382 .59932 m .60103 .59879 L .60111 .59077 L p F P
0 g
s
.683 .734 .889 r
.61984 .59325 m .61071 .59137 L .60822 .59924 L p F P
0 g
s
.677 .728 .888 r
.60103 .59879 m .60822 .59924 L .61071 .59137 L p F P
0 g
s
.677 .728 .888 r
.61071 .59137 m .60111 .59077 L .60103 .59879 L p F P
0 g
s
.64 .691 .882 r
.56061 .58258 m .55014 .58885 L .55858 .59496 L p F P
0 g
s
.64 .691 .882 r
.55858 .59496 m .56731 .58974 L .56061 .58258 L p F P
0 g
s
.612 .66 .873 r
.52505 .56878 m .5132 .58004 L .52278 .58575 L p F P
0 g
s
.612 .66 .873 r
.52278 .58575 m .53337 .57575 L .52505 .56878 L p F P
0 g
s
.498 .467 .753 r
.36537 .43804 m .39545 .40586 L .38997 .39546 L p F P
0 g
s
.506 .478 .76 r
.39545 .40586 m .36537 .43804 L .37183 .44737 L p F P
0 g
s
.71 .749 .882 r
.63486 .58936 m .64346 .59448 L .65197 .58828 L p F P
0 g
s
.701 .75 .889 r
.64346 .59448 m .63486 .58936 L .62804 .5963 L p F P
0 g
s
.654 .704 .884 r
.57767 .5858 m .56731 .58974 L .57403 .5966 L p F P
0 g
s
.654 .704 .884 r
.57403 .5966 m .58231 .59345 L .57767 .5858 L p F P
0 g
s
.696 .739 .884 r
.61984 .59325 m .62804 .5963 L .63486 .58936 L p F P
0 g
s
.74 .765 .873 r
.66887 .57499 m .67919 .58488 L .68879 .57905 L p F P
0 g
s
.732 .764 .879 r
.67919 .58488 m .66887 .57499 L .66044 .58178 L p F P
0 g
s
.863 .764 .752 r
.84145 .42574 m .81142 .39292 L .80607 .40339 L p F P
0 g
s
1 1 0 r
.007 w
.84411 .41212 m
.84721 .41615 L
s
.5 Mabswid
.863 .764 .752 r
.80607 .40339 m .83541 .43525 L .84145 .42574 L p F P
0 g
s
1 1 0 r
.007 w
.83665 .40243 m
.84411 .41212 L
s
.5 Mabswid
.607 .65 .867 r
.51679 .56153 m .5037 .57404 L .5132 .58004 L p F P
0 g
s
.607 .65 .867 r
.5132 .58004 m .52505 .56878 L .51679 .56153 L p F P
0 g
s
.506 .478 .76 r
.37183 .44737 m .40116 .41618 L .39545 .40586 L p F P
0 g
s
.513 .489 .768 r
.40116 .41618 m .37183 .44737 L .37854 .45659 L p F P
0 g
s
.748 .766 .868 r
.67724 .56792 m .68879 .57905 L .6983 .57295 L p F P
0 g
s
.74 .765 .873 r
.68879 .57905 m .67724 .56792 L .66887 .57499 L p F P
0 g
s
.857 .765 .76 r
.83541 .43525 m .80607 .40339 L .80049 .41379 L p F P
0 g
s
.857 .765 .76 r
.80049 .41379 m .82909 .44467 L .83541 .43525 L p F P
0 g
s
1 1 0 r
.007 w
.36688 .40249 m
.37051 .39834 L
s
.35865 .41189 m
.36688 .40249 L
s
.5 Mabswid
.602 .64 .861 r
.5086 .55401 m .4943 .56778 L .5037 .57404 L p F P
0 g
s
.602 .64 .861 r
.5037 .57404 m .51679 .56153 L .5086 .55401 L p F P
0 g
s
.513 .489 .768 r
.37854 .45659 m .40709 .42643 L .40116 .41618 L p F P
0 g
s
.52 .5 .775 r
.40709 .42643 m .37854 .45659 L .3855 .46568 L p F P
0 g
s
.637 .682 .875 r
.55392 .57511 m .54174 .58245 L .55014 .58885 L p F P
0 g
s
.637 .682 .875 r
.55014 .58885 m .56061 .58258 L .55392 .57511 L p F P
0 g
s
.664 .708 .881 r
.58914 .58332 m .57767 .5858 L .58231 .59345 L p F P
0 g
s
.664 .708 .881 r
.58231 .59345 m .59149 .59148 L .58914 .58332 L p F P
0 g
s
.696 .739 .884 r
.63486 .58936 m .62461 .58553 L .61984 .59325 L p F P
0 g
s
.69 .73 .881 r
.61071 .59137 m .61984 .59325 L .62461 .58553 L p F P
0 g
s
.718 .748 .876 r
.64167 .58212 m .65197 .58828 L .66044 .58178 L p F P
0 g
s
.71 .749 .882 r
.65197 .58828 m .64167 .58212 L .63486 .58936 L p F P
0 g
s
.756 .767 .862 r
.68553 .56057 m .6983 .57295 L .7077 .56658 L p F P
0 g
s
.748 .766 .868 r
.6983 .57295 m .68553 .56057 L .67724 .56792 L p F P
0 g
s
.851 .766 .768 r
.82909 .44467 m .80049 .41379 L .79467 .42412 L p F P
0 g
s
.851 .766 .768 r
.79467 .42412 m .82251 .45397 L .82909 .44467 L p F P
0 g
s
.596 .63 .856 r
.50049 .54623 m .48499 .56125 L .4943 .56778 L p F P
0 g
s
.596 .63 .856 r
.4943 .56778 m .5086 .55401 L .50049 .54623 L p F P
0 g
s
.52 .5 .775 r
.3855 .46568 m .41323 .43658 L .40709 .42643 L p F P
0 g
s
.526 .511 .782 r
.41323 .43658 m .3855 .46568 L .3927 .47464 L p F P
0 g
s
.652 .695 .876 r
.57302 .57782 m .56061 .58258 L .56731 .58974 L p F P
0 g
s
.652 .695 .876 r
.56731 .58974 m .57767 .5858 L .57302 .57782 L p F P
0 g
s
.703 .736 .877 r
.62461 .58553 m .63486 .58936 L .64167 .58212 L p F P
0 g
s
.673 .714 .879 r
.60118 .58243 m .58914 .58332 L .59149 .59148 L p F P
0 g
s
.673 .714 .879 r
.59149 .59148 m .60111 .59077 L .60118 .58243 L p F P
0 g
s
.69 .73 .881 r
.62461 .58553 m .6132 .58318 L .61071 .59137 L p F P
0 g
s
.682 .721 .879 r
.60111 .59077 m .61071 .59137 L .6132 .58318 L p F P
0 g
s
.591 .621 .85 r
.49248 .53821 m .4758 .55447 L .48499 .56125 L p F P
0 g
s
.591 .621 .85 r
.48499 .56125 m .50049 .54623 L .49248 .53821 L p F P
0 g
s
.763 .768 .857 r
.69375 .55296 m .7077 .56658 L .717 .55994 L p F P
0 g
s
.756 .767 .862 r
.7077 .56658 m .69375 .55296 L .68553 .56057 L p F P
0 g
s
.845 .767 .775 r
.82251 .45397 m .79467 .42412 L .78864 .43435 L p F P
0 g
s
.845 .767 .775 r
.78864 .43435 m .81568 .46316 L .82251 .45397 L p F P
0 g
s
.526 .511 .782 r
.3927 .47464 m .41958 .44661 L .41323 .43658 L p F P
0 g
s
.533 .522 .789 r
.41958 .44661 m .3927 .47464 L .40013 .48346 L p F P
0 g
s
.682 .721 .879 r
.6132 .58318 m .60118 .58243 L .60111 .59077 L p F P
0 g
s
.585 .611 .844 r
.48456 .52995 m .46674 .54744 L .4758 .55447 L p F P
0 g
s
.585 .611 .844 r
.4758 .55447 m .49248 .53821 L .48456 .52995 L p F P
0 g
s
.634 .672 .869 r
.54725 .56735 m .53337 .57575 L .54174 .58245 L p F P
0 g
s
.634 .672 .869 r
.54174 .58245 m .55392 .57511 L .54725 .56735 L p F P
0 g
s
.533 .522 .789 r
.40013 .48346 m .42613 .45653 L .41958 .44661 L p F P
0 g
s
.539 .532 .795 r
.42613 .45653 m .40013 .48346 L .40778 .49212 L p F P
0 g
s
.77 .768 .851 r
.70188 .54509 m .717 .55994 L .72617 .55305 L p F P
0 g
s
.763 .768 .857 r
.717 .55994 m .70188 .54509 L .69375 .55296 L p F P
0 g
s
.84 .767 .782 r
.81568 .46316 m .78864 .43435 L .78238 .44447 L p F P
0 g
s
.84 .767 .782 r
.78238 .44447 m .8086 .47221 L .81568 .46316 L p F P
0 g
s
.725 .747 .869 r
.64846 .57458 m .66044 .58178 L .66887 .57499 L p F P
0 g
s
.718 .748 .876 r
.66044 .58178 m .64846 .57458 L .64167 .58212 L p F P
0 g
s
.58 .601 .838 r
.47676 .52145 m .45781 .54017 L .46674 .54744 L p F P
0 g
s
.58 .601 .838 r
.46674 .54744 m .48456 .52995 L .47676 .52145 L p F P
0 g
s
.539 .532 .795 r
.40778 .49212 m .43287 .46631 L .42613 .45653 L p F P
0 g
s
.545 .542 .802 r
.43287 .46631 m .40778 .49212 L .41565 .50061 L p F P
0 g
s
.574 .592 .833 r
.46908 .51274 m .44903 .53268 L .45781 .54017 L p F P
0 g
s
.574 .592 .833 r
.45781 .54017 m .47676 .52145 L .46908 .51274 L p F P
0 g
s
.777 .769 .845 r
.70991 .53697 m .72617 .55305 L .73521 .54592 L p F P
0 g
s
.77 .768 .851 r
.72617 .55305 m .70991 .53697 L .70188 .54509 L p F P
0 g
s
.545 .542 .802 r
.41565 .50061 m .43978 .47594 L .43287 .46631 L p F P
0 g
s
.551 .552 .808 r
.43978 .47594 m .41565 .50061 L .42371 .50892 L p F P
0 g
s
.834 .768 .789 r
.8086 .47221 m .78238 .44447 L .77592 .45447 L p F P
0 g
s
.834 .768 .789 r
.77592 .45447 m .80127 .48112 L .8086 .47221 L p F P
0 g
s
.569 .582 .827 r
.46153 .50383 m .44042 .52497 L .44903 .53268 L p F P
0 g
s
.569 .582 .827 r
.44903 .53268 m .46908 .51274 L .46153 .50383 L p F P
0 g
s
.551 .552 .808 r
.42371 .50892 m .44687 .48541 L .43978 .47594 L p F P
0 g
s
.557 .562 .814 r
.44687 .48541 m .42371 .50892 L .43198 .51704 L p F P
0 g
s
.563 .572 .821 r
.45413 .49471 m .43198 .51704 L .44042 .52497 L p F P
0 g
s
.563 .572 .821 r
.44042 .52497 m .46153 .50383 L .45413 .49471 L p F P
0 g
s
.557 .562 .814 r
.43198 .51704 m .45413 .49471 L .44687 .48541 L p F P
0 g
s
.784 .769 .839 r
.71783 .52861 m .73521 .54592 L .7441 .53854 L p F P
0 g
s
.777 .769 .845 r
.73521 .54592 m .71783 .52861 L .70991 .53697 L p F P
0 g
s
.828 .768 .796 r
.80127 .48112 m .77592 .45447 L .76926 .46434 L p F P
0 g
s
.828 .768 .796 r
.76926 .46434 m .79372 .48987 L .80127 .48112 L p F P
0 g
s
.664 .7 .873 r
.5868 .57484 m .57302 .57782 L .57767 .5858 L p F P
0 g
s
.664 .7 .873 r
.57767 .5858 m .58914 .58332 L .5868 .57484 L p F P
0 g
s
.703 .736 .877 r
.64167 .58212 m .62938 .57751 L .62461 .58553 L p F P
0 g
s
.695 .725 .873 r
.6132 .58318 m .62461 .58553 L .62938 .57751 L p F P
0 g
s
.791 .769 .833 r
.72562 .52003 m .7441 .53854 L .75283 .53094 L p F P
0 g
s
.784 .769 .839 r
.7441 .53854 m .72562 .52003 L .71783 .52861 L p F P
0 g
s
.822 .769 .802 r
.79372 .48987 m .76926 .46434 L .76241 .47406 L p F P
0 g
s
.822 .769 .802 r
.76241 .47406 m .78594 .49846 L .79372 .48987 L p F P
0 g
s
.651 .685 .869 r
.56839 .56955 m .55392 .57511 L .56061 .58258 L p F P
0 g
s
.651 .685 .869 r
.56061 .58258 m .57302 .57782 L .56839 .56955 L p F P
0 g
s
.631 .662 .862 r
.54061 .55931 m .52505 .56878 L .53337 .57575 L p F P
0 g
s
.631 .662 .862 r
.53337 .57575 m .54725 .56735 L .54061 .55931 L p F P
0 g
s
.797 .769 .827 r
.73328 .51122 m .75283 .53094 L .76139 .52313 L p F P
0 g
s
.791 .769 .833 r
.75283 .53094 m .73328 .51122 L .72562 .52003 L p F P
0 g
s
.71 .734 .869 r
.62938 .57751 m .64167 .58212 L .64846 .57458 L p F P
0 g
s
.816 .769 .809 r
.78594 .49846 m .76241 .47406 L .75538 .48362 L p F P
0 g
s
.816 .769 .809 r
.75538 .48362 m .77796 .50688 L .78594 .49846 L p F P
0 g
s
.804 .769 .821 r
.7408 .50221 m .76139 .52313 L .76977 .5151 L p F P
0 g
s
.797 .769 .827 r
.76139 .52313 m .7408 .50221 L .73328 .51122 L p F P
0 g
s
.81 .769 .815 r
.77796 .50688 m .75538 .48362 L .74817 .49301 L p F P
0 g
s
.81 .769 .815 r
.74817 .49301 m .76977 .5151 L .77796 .50688 L p F P
0 g
s
.804 .769 .821 r
.76977 .5151 m .74817 .49301 L .7408 .50221 L p F P
0 g
s
.732 .746 .863 r
.65521 .56674 m .66887 .57499 L .67724 .56792 L p F P
0 g
s
.725 .747 .869 r
.66887 .57499 m .65521 .56674 L .64846 .57458 L p F P
0 g
s
.676 .706 .871 r
.60125 .57377 m .5868 .57484 L .58914 .58332 L p F P
0 g
s
.676 .706 .871 r
.58914 .58332 m .60118 .58243 L .60125 .57377 L p F P
0 g
s
1 1 0 r
.007 w
.82419 .38932 m
.83665 .40243 L
s
.5 Mabswid
.695 .725 .873 r
.62938 .57751 m .61569 .57468 L .6132 .58318 L p F P
0 g
s
.686 .715 .871 r
.60118 .58243 m .6132 .58318 L .61569 .57468 L p F P
0 g
s
.686 .715 .871 r
.61569 .57468 m .60125 .57377 L .60118 .58243 L p F P
0 g
s
.627 .653 .856 r
.53402 .55099 m .51679 .56153 L .52505 .56878 L p F P
0 g
s
.627 .653 .856 r
.52505 .56878 m .54061 .55931 L .53402 .55099 L p F P
0 g
s
.739 .745 .857 r
.66192 .55862 m .67724 .56792 L .68553 .56057 L p F P
0 g
s
.732 .746 .863 r
.67724 .56792 m .66192 .55862 L .65521 .56674 L p F P
0 g
s
.65 .676 .862 r
.56376 .56098 m .54725 .56735 L .55392 .57511 L p F P
0 g
s
.65 .676 .862 r
.55392 .57511 m .56839 .56955 L .56376 .56098 L p F P
0 g
s
.665 .691 .865 r
.58445 .56605 m .56839 .56955 L .57302 .57782 L p F P
0 g
s
.665 .691 .865 r
.57302 .57782 m .5868 .57484 L .58445 .56605 L p F P
0 g
s
.716 .731 .862 r
.63413 .56918 m .64846 .57458 L .65521 .56674 L p F P
0 g
s
.71 .734 .869 r
.64846 .57458 m .63413 .56918 L .62938 .57751 L p F P
0 g
s
.701 .721 .865 r
.61569 .57468 m .62938 .57751 L .63413 .56918 L p F P
0 g
s
1 1 0 r
.007 w
.37051 .39834 m
.38078 .38868 L
s
.38078 .38868 m
.38422 .38544 L
s
.5 Mabswid
.624 .644 .85 r
.52747 .54241 m .5086 .55401 L .51679 .56153 L p F P
0 g
s
.624 .644 .85 r
.51679 .56153 m .53402 .55099 L .52747 .54241 L p F P
0 g
s
.745 .744 .85 r
.66858 .55023 m .68553 .56057 L .69375 .55296 L p F P
0 g
s
.739 .745 .857 r
.68553 .56057 m .66858 .55023 L .66192 .55862 L p F P
0 g
s
.678 .699 .863 r
.60132 .5648 m .58445 .56605 L .5868 .57484 L p F P
0 g
s
.678 .699 .863 r
.5868 .57484 m .60125 .57377 L .60132 .5648 L p F P
0 g
s
.701 .721 .865 r
.63413 .56918 m .61816 .56586 L .61569 .57468 L p F P
0 g
s
.69 .709 .863 r
.60125 .57377 m .61569 .57468 L .61816 .56586 L p F P
0 g
s
.621 .635 .843 r
.52098 .53357 m .50049 .54623 L .5086 .55401 L p F P
0 g
s
.621 .635 .843 r
.5086 .55401 m .52747 .54241 L .52098 .53357 L p F P
0 g
s
.648 .667 .855 r
.55915 .55212 m .54061 .55931 L .54725 .56735 L p F P
0 g
s
.648 .667 .855 r
.54725 .56735 m .56376 .56098 L .55915 .55212 L p F P
0 g
s
.69 .709 .863 r
.61816 .56586 m .60132 .5648 L .60125 .57377 L p F P
0 g
s
.722 .728 .855 r
.63886 .56055 m .65521 .56674 L .66192 .55862 L p F P
0 g
s
.716 .731 .862 r
.65521 .56674 m .63886 .56055 L .63413 .56918 L p F P
0 g
s
.751 .742 .844 r
.67519 .54157 m .69375 .55296 L .70188 .54509 L p F P
0 g
s
.745 .744 .85 r
.69375 .55296 m .67519 .54157 L .66858 .55023 L p F P
0 g
s
.665 .683 .857 r
.58211 .55697 m .56376 .56098 L .56839 .56955 L p F P
0 g
s
.665 .683 .857 r
.56839 .56955 m .58445 .56605 L .58211 .55697 L p F P
0 g
s
.705 .716 .857 r
.61816 .56586 m .63413 .56918 L .63886 .56055 L p F P
0 g
s
.617 .626 .837 r
.51456 .52448 m .49248 .53821 L .50049 .54623 L p F P
0 g
s
.617 .626 .837 r
.50049 .54623 m .52098 .53357 L .51456 .52448 L p F P
0 g
s
.757 .741 .838 r
.68172 .53265 m .70188 .54509 L .70991 .53697 L p F P
0 g
s
.751 .742 .844 r
.70188 .54509 m .68172 .53265 L .67519 .54157 L p F P
0 g
s
.647 .659 .848 r
.55456 .54299 m .53402 .55099 L .54061 .55931 L p F P
0 g
s
.647 .659 .848 r
.54061 .55931 m .55915 .55212 L .55456 .54299 L p F P
0 g
s
.614 .617 .831 r
.50821 .51517 m .48456 .52995 L .49248 .53821 L p F P
0 g
s
.614 .617 .831 r
.49248 .53821 m .51456 .52448 L .50821 .51517 L p F P
0 g
s
.727 .725 .848 r
.64357 .55164 m .66192 .55862 L .66858 .55023 L p F P
0 g
s
.722 .728 .855 r
.66192 .55862 m .64357 .55164 L .63886 .56055 L p F P
0 g
s
.679 .692 .855 r
.60138 .55553 m .58211 .55697 L .58445 .56605 L p F P
0 g
s
.679 .692 .855 r
.58445 .56605 m .60132 .5648 L .60138 .55553 L p F P
0 g
s
.705 .716 .857 r
.63886 .56055 m .62062 .55675 L .61816 .56586 L p F P
0 g
s
.693 .703 .855 r
.60132 .5648 m .61816 .56586 L .62062 .55675 L p F P
0 g
s
1 1 0 r
.007 w
.81776 .38375 m
.82419 .38932 L
s
.5 Mabswid
.763 .739 .831 r
.68818 .52349 m .70991 .53697 L .71783 .52861 L p F P
0 g
s
.757 .741 .838 r
.70991 .53697 m .68818 .52349 L .68172 .53265 L p F P
0 g
s
.693 .703 .855 r
.62062 .55675 m .60138 .55553 L .60132 .5648 L p F P
0 g
s
.665 .675 .85 r
.57977 .5476 m .55915 .55212 L .56376 .56098 L p F P
0 g
s
.665 .675 .85 r
.56376 .56098 m .58211 .55697 L .57977 .5476 L p F P
0 g
s
.61 .608 .824 r
.50195 .50563 m .47676 .52145 L .48456 .52995 L p F P
0 g
s
.61 .608 .824 r
.48456 .52995 m .50821 .51517 L .50195 .50563 L p F P
0 g
s
.71 .712 .85 r
.62062 .55675 m .63886 .56055 L .64357 .55164 L p F P
0 g
s
.768 .738 .825 r
.69455 .51409 m .71783 .52861 L .72562 .52003 L p F P
0 g
s
.763 .739 .831 r
.71783 .52861 m .69455 .51409 L .68818 .52349 L p F P
0 g
s
.645 .65 .841 r
.55001 .53359 m .52747 .54241 L .53402 .55099 L p F P
0 g
s
.645 .65 .841 r
.53402 .55099 m .55456 .54299 L .55001 .53359 L p F P
0 g
s
.607 .6 .818 r
.49578 .49587 m .46908 .51274 L .47676 .52145 L p F P
0 g
s
.607 .6 .818 r
.47676 .52145 m .50195 .50563 L .49578 .49587 L p F P
0 g
s
.732 .722 .841 r
.64824 .54246 m .66858 .55023 L .67519 .54157 L p F P
0 g
s
.727 .725 .848 r
.66858 .55023 m .64824 .54246 L .64357 .55164 L p F P
0 g
s
1 1 0 r
.007 w
.38422 .38544 m
.38461 .38514 L
s
.5 Mabswid
.774 .736 .819 r
.70082 .50448 m .72562 .52003 L .73328 .51122 L p F P
0 g
s
.768 .738 .825 r
.72562 .52003 m .70082 .50448 L .69455 .51409 L p F P
0 g
s
.554 .484 .731 r
.42759 .35587 m .38473 .38501 L .38997 .39546 L p F P
0 g
s
.603 .591 .812 r
.48971 .48592 m .46153 .50383 L .46908 .51274 L p F P
0 g
s
.603 .591 .812 r
.46908 .51274 m .49578 .49587 L .48971 .48592 L p F P
0 g
s
.681 .685 .847 r
.60144 .54598 m .57977 .5476 L .58211 .55697 L p F P
0 g
s
.681 .685 .847 r
.58211 .55697 m .60138 .55553 L .60144 .54598 L p F P
0 g
s
.71 .712 .85 r
.64357 .55164 m .62307 .54735 L .62062 .55675 L p F P
0 g
s
.696 .697 .847 r
.60138 .55553 m .62062 .55675 L .62307 .54735 L p F P
0 g
s
.554 .484 .731 r
.38997 .39546 m .43186 .36715 L .42759 .35587 L p F P
0 g
s
.559 .494 .739 r
.43186 .36715 m .38997 .39546 L .39545 .40586 L p F P
0 g
s
1 1 0 r
.007 w
.38507 .38477 m
.38943 .38135 L
s
.5 Mabswid
.599 .582 .805 r
.48375 .47578 m .45413 .49471 L .46153 .50383 L p F P
0 g
s
.599 .582 .805 r
.46153 .50383 m .48971 .48592 L .48375 .47578 L p F P
0 g
s
.665 .667 .842 r
.57744 .53795 m .55456 .54299 L .55915 .55212 L p F P
0 g
s
.665 .667 .842 r
.55915 .55212 m .57977 .5476 L .57744 .53795 L p F P
0 g
s
.779 .735 .812 r
.707 .49465 m .73328 .51122 L .7408 .50221 L p F P
0 g
s
.774 .736 .819 r
.73328 .51122 m .707 .49465 L .70082 .50448 L p F P
0 g
s
.643 .642 .834 r
.54549 .52394 m .52098 .53357 L .52747 .54241 L p F P
0 g
s
.643 .642 .834 r
.52747 .54241 m .55001 .53359 L .54549 .52394 L p F P
0 g
s
.714 .707 .843 r
.62307 .54735 m .64357 .55164 L .64824 .54246 L p F P
0 g
s
.696 .697 .847 r
.62307 .54735 m .60144 .54598 L .60138 .55553 L p F P
0 g
s
.831 .71 .731 r
.81652 .38239 m .77429 .35375 L .77016 .36508 L p F P
0 g
s
.831 .71 .731 r
.77016 .36508 m .81142 .39292 L .81652 .38239 L p F P
0 g
s
.559 .494 .739 r
.39545 .40586 m .43631 .37839 L .43186 .36715 L p F P
0 g
s
.563 .503 .746 r
.43631 .37839 m .39545 .40586 L .40116 .41618 L p F P
0 g
s
1 1 0 r
.007 w
.39855 .3742 m
.3997 .3733 L
s
.38943 .38135 m
.39855 .3742 L
s
.5 Mabswid
.596 .574 .799 r
.47791 .46547 m .44687 .48541 L .45413 .49471 L p F P
0 g
s
.596 .574 .799 r
.45413 .49471 m .48375 .47578 L .47791 .46547 L p F P
0 g
s
.737 .719 .834 r
.65287 .533 m .67519 .54157 L .68172 .53265 L p F P
0 g
s
.732 .722 .841 r
.67519 .54157 m .65287 .533 L .64824 .54246 L p F P
0 g
s
.784 .733 .806 r
.71306 .48462 m .7408 .50221 L .74817 .49301 L p F P
0 g
s
.779 .735 .812 r
.7408 .50221 m .71306 .48462 L .707 .49465 L p F P
0 g
s
.563 .503 .746 r
.40116 .41618 m .44094 .38959 L .43631 .37839 L p F P
0 g
s
.568 .512 .753 r
.44094 .38959 m .40116 .41618 L .40709 .42643 L p F P
0 g
s
.592 .565 .793 r
.47219 .455 m .43978 .47594 L .44687 .48541 L p F P
0 g
s
.592 .565 .793 r
.44687 .48541 m .47791 .46547 L .47219 .455 L p F P
0 g
s
.827 .712 .738 r
.81142 .39292 m .77016 .36508 L .76583 .37639 L p F P
0 g
s
1 1 0 r
.007 w
.81252 .37921 m
.81499 .38135 L
s
.5 Mabswid
.827 .712 .738 r
.76583 .37639 m .80607 .40339 L .81142 .39292 L p F P
0 g
s
1 1 0 r
.007 w
.80989 .37694 m
.81252 .37921 L
s
.5 Mabswid
.568 .512 .753 r
.40709 .42643 m .44575 .40073 L .44094 .38959 L p F P
0 g
s
.572 .521 .76 r
.44575 .40073 m .40709 .42643 L .41323 .43658 L p F P
0 g
s
.588 .556 .786 r
.4666 .44438 m .43287 .46631 L .43978 .47594 L p F P
0 g
s
.588 .556 .786 r
.43978 .47594 m .47219 .455 L .4666 .44438 L p F P
0 g
s
.788 .731 .8 r
.71901 .47441 m .74817 .49301 L .75538 .48362 L p F P
0 g
s
.784 .733 .806 r
.74817 .49301 m .71901 .47441 L .71306 .48462 L p F P
0 g
s
.572 .521 .76 r
.41323 .43658 m .45073 .41179 L .44575 .40073 L p F P
0 g
s
.576 .53 .767 r
.45073 .41179 m .41323 .43658 L .41958 .44661 L p F P
0 g
s
.584 .548 .78 r
.46116 .43363 m .42613 .45653 L .43287 .46631 L p F P
0 g
s
.584 .548 .78 r
.43287 .46631 m .4666 .44438 L .46116 .43363 L p F P
0 g
s
.576 .53 .767 r
.41958 .44661 m .45587 .42276 L .45073 .41179 L p F P
0 g
s
.58 .539 .773 r
.45587 .42276 m .41958 .44661 L .42613 .45653 L p F P
0 g
s
.58 .539 .773 r
.42613 .45653 m .46116 .43363 L .45587 .42276 L p F P
0 g
s
.823 .715 .746 r
.80607 .40339 m .76583 .37639 L .76131 .38765 L p F P
0 g
s
.823 .715 .746 r
.76131 .38765 m .80049 .41379 L .80607 .40339 L p F P
0 g
s
.793 .729 .793 r
.72482 .46402 m .75538 .48362 L .76241 .47406 L p F P
0 g
s
.788 .731 .8 r
.75538 .48362 m .72482 .46402 L .71901 .47441 L p F P
0 g
s
.642 .634 .827 r
.54101 .51404 m .51456 .52448 L .52098 .53357 L p F P
0 g
s
.642 .634 .827 r
.52098 .53357 m .54549 .52394 L .54101 .51404 L p F P
0 g
s
.819 .717 .753 r
.80049 .41379 m .76131 .38765 L .7566 .39885 L p F P
0 g
s
.819 .717 .753 r
.7566 .39885 m .79467 .42412 L .80049 .41379 L p F P
0 g
s
.798 .728 .787 r
.7305 .45348 m .76241 .47406 L .76926 .46434 L p F P
0 g
s
.793 .729 .793 r
.76241 .47406 m .7305 .45348 L .72482 .46402 L p F P
0 g
s
.683 .678 .84 r
.60149 .53614 m .57744 .53795 L .57977 .5476 L p F P
0 g
s
.683 .678 .84 r
.57977 .5476 m .60144 .54598 L .60149 .53614 L p F P
0 g
s
.742 .716 .828 r
.65745 .52329 m .68172 .53265 L .68818 .52349 L p F P
0 g
s
.737 .719 .834 r
.68172 .53265 m .65745 .52329 L .65287 .533 L p F P
0 g
s
.665 .66 .835 r
.57512 .52803 m .55001 .53359 L .55456 .54299 L p F P
0 g
s
.665 .66 .835 r
.55456 .54299 m .57744 .53795 L .57512 .52803 L p F P
0 g
s
.815 .719 .76 r
.79467 .42412 m .7566 .39885 L .75171 .40998 L p F P
0 g
s
.815 .719 .76 r
.75171 .40998 m .78864 .43435 L .79467 .42412 L p F P
0 g
s
.714 .707 .843 r
.64824 .54246 m .62549 .53767 L .62307 .54735 L p F P
0 g
s
.699 .692 .84 r
.60144 .54598 m .62307 .54735 L .62549 .53767 L p F P
0 g
s
.802 .726 .78 r
.73604 .44279 m .76926 .46434 L .77592 .45447 L p F P
0 g
s
.798 .728 .787 r
.76926 .46434 m .73604 .44279 L .7305 .45348 L p F P
0 g
s
.811 .721 .767 r
.78864 .43435 m .75171 .40998 L .74665 .42103 L p F P
0 g
s
.811 .721 .767 r
.74665 .42103 m .78238 .44447 L .78864 .43435 L p F P
0 g
s
.806 .724 .773 r
.74142 .43197 m .77592 .45447 L .78238 .44447 L p F P
0 g
s
.802 .726 .78 r
.77592 .45447 m .74142 .43197 L .73604 .44279 L p F P
0 g
s
.718 .703 .835 r
.62549 .53767 m .64824 .54246 L .65287 .533 L p F P
0 g
s
.806 .724 .773 r
.78238 .44447 m .74665 .42103 L .74142 .43197 L p F P
0 g
s
1 1 0 r
.007 w
.79386 .36539 m
.79844 .36869 L
s
.79844 .36869 m
.80989 .37694 L
s
.5 Mabswid
.699 .692 .84 r
.62549 .53767 m .60149 .53614 L .60144 .54598 L p F P
0 g
s
.64 .626 .821 r
.53658 .50391 m .50821 .51517 L .51456 .52448 L p F P
0 g
s
.64 .626 .821 r
.51456 .52448 m .54101 .51404 L .53658 .50391 L p F P
0 g
s
.746 .713 .821 r
.66198 .51334 m .68818 .52349 L .69455 .51409 L p F P
0 g
s
.742 .716 .828 r
.68818 .52349 m .66198 .51334 L .65745 .52329 L p F P
0 g
s
.665 .652 .828 r
.57281 .51786 m .54549 .52394 L .55001 .53359 L p F P
0 g
s
.665 .652 .828 r
.55001 .53359 m .57512 .52803 L .57281 .51786 L p F P
0 g
s
1 1 0 r
.007 w
.3997 .3733 m
.41683 .36203 L
s
.5 Mabswid
.721 .699 .828 r
.6279 .52773 m .65287 .533 L .65745 .52329 L p F P
0 g
s
.718 .703 .835 r
.65287 .533 m .6279 .52773 L .62549 .53767 L p F P
0 g
s
.684 .672 .832 r
.60153 .52604 m .57512 .52803 L .57744 .53795 L p F P
0 g
s
.684 .672 .832 r
.57744 .53795 m .60149 .53614 L .60153 .52604 L p F P
0 g
s
.638 .618 .814 r
.53221 .49356 m .50195 .50563 L .50821 .51517 L p F P
0 g
s
.638 .618 .814 r
.50821 .51517 m .53658 .50391 L .53221 .49356 L p F P
0 g
s
.701 .686 .832 r
.60149 .53614 m .62549 .53767 L .6279 .52773 L p F P
0 g
s
0 .334 0 r
.59973 .75442 m .60706 .75397 L .60306 .77818 L closepath p F P
0 g
s
0 .489 0 r
.5941 .75172 m .59973 .75442 L .60306 .77818 L closepath p F P
0 g
s
.75 .71 .814 r
.66645 .50316 m .69455 .51409 L .70082 .50448 L p F P
0 g
s
.746 .713 .821 r
.69455 .51409 m .66645 .50316 L .66198 .51334 L p F P
0 g
s
0 0 0 r
.60706 .75397 m .6118 .75065 L .60306 .77818 L closepath p F P
0 g
s
.701 .686 .832 r
.6279 .52773 m .60153 .52604 L .60149 .53614 L p F P
0 g
s
.636 .611 .808 r
.52789 .483 m .49578 .49587 L .50195 .50563 L p F P
0 g
s
.636 .611 .808 r
.50195 .50563 m .53221 .49356 L .52789 .483 L p F P
0 g
s
.664 .645 .821 r
.57053 .50745 m .54101 .51404 L .54549 .52394 L p F P
0 g
s
.664 .645 .821 r
.54549 .52394 m .57281 .51786 L .57053 .50745 L p F P
0 g
s
.754 .707 .808 r
.67086 .49275 m .70082 .50448 L .707 .49465 L p F P
0 g
s
.75 .71 .814 r
.70082 .50448 m .67086 .49275 L .66645 .50316 L p F P
0 g
s
0 0 0 r
.59345 .74746 m .5941 .75172 L .60306 .77818 L closepath p F P
0 g
s
.724 .695 .821 r
.63027 .51753 m .65745 .52329 L .66198 .51334 L p F P
0 g
s
.721 .699 .828 r
.65745 .52329 m .63027 .51753 L .6279 .52773 L p F P
0 g
s
.685 .665 .825 r
.60157 .51569 m .57281 .51786 L .57512 .52803 L p F P
0 g
s
.685 .665 .825 r
.57512 .52803 m .60153 .52604 L .60157 .51569 L p F P
0 g
s
.704 .681 .825 r
.60153 .52604 m .6279 .52773 L .63027 .51753 L p F P
0 g
s
0 .875 0 r
.6118 .75065 m .61119 .74638 L .60306 .77818 L closepath p F P
0 g
s
.634 .603 .801 r
.52364 .47225 m .48971 .48592 L .49578 .49587 L p F P
0 g
s
.634 .603 .801 r
.49578 .49587 m .52789 .483 L .52364 .47225 L p F P
0 g
s
.758 .704 .801 r
.6752 .48214 m .707 .49465 L .71306 .48462 L p F P
0 g
s
.754 .707 .808 r
.707 .49465 m .6752 .48214 L .67086 .49275 L p F P
0 g
s
.704 .681 .825 r
.63027 .51753 m .60157 .51569 L .60153 .52604 L p F P
0 g
s
1 1 0 r
.007 w
.77891 .35641 m
.79386 .36539 L
s
.77621 .35479 m
.77891 .35641 L
s
.5 Mabswid
.664 .638 .814 r
.56826 .4968 m .53658 .50391 L .54101 .51404 L p F P
0 g
s
.664 .638 .814 r
.54101 .51404 m .57053 .50745 L .56826 .4968 L p F P
0 g
s
.632 .595 .795 r
.51947 .46132 m .48375 .47578 L .48971 .48592 L p F P
0 g
s
.632 .595 .795 r
.48971 .48592 m .52364 .47225 L .51947 .46132 L p F P
0 g
s
.728 .69 .814 r
.63263 .50709 m .66198 .51334 L .66645 .50316 L p F P
0 g
s
.724 .695 .821 r
.66198 .51334 m .63263 .50709 L .63027 .51753 L p F P
0 g
s
0 .334 0 r
.59819 .74412 m .59345 .74746 L .60306 .77818 L closepath p F P
0 g
s
.762 .701 .795 r
.67946 .47134 m .71306 .48462 L .71901 .47441 L p F P
0 g
s
.758 .704 .801 r
.71306 .48462 m .67946 .47134 L .6752 .48214 L p F P
0 g
s
.686 .659 .818 r
.6016 .50509 m .57053 .50745 L .57281 .51786 L p F P
0 g
s
.686 .659 .818 r
.57281 .51786 m .60157 .51569 L .6016 .50509 L p F P
0 g
s
.63 .588 .788 r
.51537 .45023 m .47791 .46547 L .48375 .47578 L p F P
0 g
s
.63 .588 .788 r
.48375 .47578 m .51947 .46132 L .51537 .45023 L p F P
0 g
s
.706 .675 .818 r
.60157 .51569 m .63027 .51753 L .63263 .50709 L p F P
0 g
s
0 .642 0 r
.61119 .74638 m .60555 .74367 L .60306 .77818 L closepath p F P
0 g
s
1 1 0 r
.007 w
.41683 .36203 m
.42586 .35705 L
s
.5 Mabswid
.765 .698 .788 r
.68363 .46036 m .71901 .47441 L .72482 .46402 L p F P
0 g
s
.762 .701 .795 r
.71901 .47441 m .68363 .46036 L .67946 .47134 L p F P
0 g
s
.663 .631 .807 r
.56602 .48594 m .53221 .49356 L .53658 .50391 L p F P
0 g
s
.663 .631 .807 r
.53658 .50391 m .56826 .4968 L .56602 .48594 L p F P
0 g
s
.628 .58 .782 r
.51135 .43898 m .47219 .455 L .47791 .46547 L p F P
0 g
s
.628 .58 .782 r
.47791 .46547 m .51537 .45023 L .51135 .43898 L p F P
0 g
s
.706 .675 .818 r
.63263 .50709 m .6016 .50509 L .60157 .51569 L p F P
0 g
s
.731 .686 .808 r
.63494 .49642 m .66645 .50316 L .67086 .49275 L p F P
0 g
s
.728 .69 .814 r
.66645 .50316 m .63494 .49642 L .63263 .50709 L p F P
0 g
s
0 .494 0 r
.60555 .74367 m .59819 .74412 L .60306 .77818 L closepath p F P
0 g
s
0 1 0 r
.007 w
.60077 .62083 m
.60256 .74385 L
s
.5 Mabswid
.768 .695 .782 r
.68772 .44921 m .72482 .46402 L .7305 .45348 L p F P
0 g
s
.765 .698 .788 r
.72482 .46402 m .68772 .44921 L .68363 .46036 L p F P
0 g
s
.625 .573 .775 r
.50743 .4276 m .4666 .44438 L .47219 .455 L p F P
0 g
s
.625 .573 .775 r
.47219 .455 m .51135 .43898 L .50743 .4276 L p F P
0 g
s
.686 .653 .811 r
.60163 .49426 m .56826 .4968 L .57053 .50745 L p F P
0 g
s
.686 .653 .811 r
.57053 .50745 m .6016 .50509 L .60163 .49426 L p F P
0 g
s
.708 .67 .811 r
.6016 .50509 m .63263 .50709 L .63494 .49642 L p F P
0 g
s
.623 .565 .769 r
.5036 .41609 m .46116 .43363 L .4666 .44438 L p F P
0 g
s
.623 .565 .769 r
.4666 .44438 m .50743 .4276 L .5036 .41609 L p F P
0 g
s
.772 .692 .775 r
.69171 .43791 m .7305 .45348 L .73604 .44279 L p F P
0 g
s
.768 .695 .782 r
.7305 .45348 m .69171 .43791 L .68772 .44921 L p F P
0 g
s
.663 .624 .801 r
.56381 .47487 m .52789 .483 L .53221 .49356 L p F P
0 g
s
.663 .624 .801 r
.53221 .49356 m .56602 .48594 L .56381 .47487 L p F P
0 g
s
.621 .558 .762 r
.49987 .40448 m .45587 .42276 L .46116 .43363 L p F P
0 g
s
.621 .558 .762 r
.46116 .43363 m .5036 .41609 L .49987 .40448 L p F P
0 g
s
.733 .682 .801 r
.63723 .48552 m .67086 .49275 L .6752 .48214 L p F P
0 g
s
.731 .686 .808 r
.67086 .49275 m .63723 .48552 L .63494 .49642 L p F P
0 g
s
.605 .512 .722 r
.47989 .33347 m .42759 .35587 L .43186 .36715 L p F P
0 g
s
.775 .689 .769 r
.6956 .42648 m .73604 .44279 L .74142 .43197 L p F P
0 g
s
.772 .692 .775 r
.73604 .44279 m .6956 .42648 L .69171 .43791 L p F P
0 g
s
.618 .55 .756 r
.49625 .39278 m .45073 .41179 L .45587 .42276 L p F P
0 g
s
.618 .55 .756 r
.45587 .42276 m .49987 .40448 L .49625 .39278 L p F P
0 g
s
.708 .67 .811 r
.63494 .49642 m .60163 .49426 L .6016 .50509 L p F P
0 g
s
.605 .512 .722 r
.43186 .36715 m .48291 .34539 L .47989 .33347 L p F P
0 g
s
.608 .519 .729 r
.48291 .34539 m .43186 .36715 L .43631 .37839 L p F P
0 g
s
1 1 0 r
.007 w
.43256 .35336 m
.4355 .35174 L
s
.42941 .35509 m
.43256 .35336 L
s
.5 Mabswid
.616 .543 .749 r
.49273 .38101 m .44575 .40073 L .45073 .41179 L p F P
0 g
s
.616 .543 .749 r
.45073 .41179 m .49625 .39278 L .49273 .38101 L p F P
0 g
s
1 1 0 r
.007 w
.77476 .35406 m
.77621 .35479 L
s
.5 Mabswid
.608 .519 .729 r
.43631 .37839 m .48606 .35729 L .48291 .34539 L p F P
0 g
s
.611 .527 .736 r
.48606 .35729 m .43631 .37839 L .44094 .38959 L p F P
0 g
s
.778 .686 .762 r
.69939 .41492 m .74142 .43197 L .74665 .42103 L p F P
0 g
s
.775 .689 .769 r
.74142 .43197 m .69939 .41492 L .6956 .42648 L p F P
0 g
s
.613 .535 .742 r
.48934 .36917 m .44094 .38959 L .44575 .40073 L p F P
0 g
s
.613 .535 .742 r
.44575 .40073 m .49273 .38101 L .48934 .36917 L p F P
0 g
s
.611 .527 .736 r
.44094 .38959 m .48934 .36917 L .48606 .35729 L p F P
0 g
s
.794 .666 .721 r
.77429 .35375 m .72248 .33198 L .71958 .34393 L p F P
0 g
s
.794 .666 .721 r
.71958 .34393 m .77016 .36508 L .77429 .35375 L p F P
0 g
s
.781 .683 .756 r
.70306 .40326 m .74665 .42103 L .75171 .40998 L p F P
0 g
s
.778 .686 .762 r
.74665 .42103 m .70306 .40326 L .69939 .41492 L p F P
0 g
s
.662 .618 .794 r
.56163 .46361 m .52364 .47225 L .52789 .483 L p F P
0 g
s
.662 .618 .794 r
.52789 .483 m .56381 .47487 L .56163 .46361 L p F P
0 g
s
.687 .647 .804 r
.60166 .48321 m .56602 .48594 L .56826 .4968 L p F P
0 g
s
.687 .647 .804 r
.56826 .4968 m .60163 .49426 L .60166 .48321 L p F P
0 g
s
.792 .669 .728 r
.77016 .36508 m .71958 .34393 L .71654 .35588 L p F P
0 g
s
1 1 0 r
.007 w
.75706 .34523 m
.76825 .35082 L
s
.76825 .35082 m
.77323 .3533 L
s
.5 Mabswid
.792 .669 .728 r
.71654 .35588 m .76583 .37639 L .77016 .36508 L p F P
0 g
s
.784 .679 .749 r
.70662 .39151 m .75171 .40998 L .7566 .39885 L p F P
0 g
s
.781 .683 .756 r
.75171 .40998 m .70662 .39151 L .70306 .40326 L p F P
0 g
s
.709 .665 .804 r
.60163 .49426 m .63494 .49642 L .63723 .48552 L p F P
0 g
s
.736 .678 .794 r
.63947 .47443 m .6752 .48214 L .67946 .47134 L p F P
0 g
s
.733 .682 .801 r
.6752 .48214 m .63947 .47443 L .63723 .48552 L p F P
0 g
s
.789 .673 .735 r
.76583 .37639 m .71654 .35588 L .71336 .36781 L p F P
0 g
s
.789 .673 .735 r
.71336 .36781 m .76131 .38765 L .76583 .37639 L p F P
0 g
s
.786 .676 .742 r
.71005 .37969 m .7566 .39885 L .76131 .38765 L p F P
0 g
s
.784 .679 .749 r
.7566 .39885 m .71005 .37969 L .70662 .39151 L p F P
0 g
s
.786 .676 .742 r
.76131 .38765 m .71336 .36781 L .71005 .37969 L p F P
0 g
s
1 1 0 r
.007 w
.4355 .35174 m
.45556 .34253 L
s
.5 Mabswid
.709 .665 .804 r
.63723 .48552 m .60166 .48321 L .60163 .49426 L p F P
0 g
s
.661 .611 .788 r
.55948 .45218 m .51947 .46132 L .52364 .47225 L p F P
0 g
s
.661 .611 .788 r
.52364 .47225 m .56163 .46361 L .55948 .45218 L p F P
0 g
s
.738 .674 .788 r
.64167 .46314 m .67946 .47134 L .68363 .46036 L p F P
0 g
s
.736 .678 .794 r
.67946 .47134 m .64167 .46314 L .63947 .47443 L p F P
0 g
s
.688 .641 .797 r
.60167 .47196 m .56381 .47487 L .56602 .48594 L p F P
0 g
s
.688 .641 .797 r
.56602 .48594 m .60166 .48321 L .60167 .47196 L p F P
0 g
s
.711 .66 .797 r
.60166 .48321 m .63723 .48552 L .63947 .47443 L p F P
0 g
s
.66 .604 .781 r
.55737 .44058 m .51537 .45023 L .51947 .46132 L p F P
0 g
s
.66 .604 .781 r
.51947 .46132 m .55948 .45218 L .55737 .44058 L p F P
0 g
s
.741 .67 .781 r
.64383 .45168 m .68363 .46036 L .68772 .44921 L p F P
0 g
s
.738 .674 .788 r
.68363 .46036 m .64383 .45168 L .64167 .46314 L p F P
0 g
s
.711 .66 .797 r
.63947 .47443 m .60167 .47196 L .60166 .48321 L p F P
0 g
s
1 1 0 r
.007 w
.73656 .33683 m
.75706 .34523 L
s
.5 Mabswid
.688 .635 .791 r
.60169 .46051 m .56163 .46361 L .56381 .47487 L p F P
0 g
s
.688 .635 .791 r
.56381 .47487 m .60167 .47196 L .60169 .46051 L p F P
0 g
s
.659 .598 .775 r
.5553 .42884 m .51135 .43898 L .51537 .45023 L p F P
0 g
s
.659 .598 .775 r
.51537 .45023 m .55737 .44058 L .5553 .42884 L p F P
0 g
s
.713 .655 .791 r
.60167 .47196 m .63947 .47443 L .64167 .46314 L p F P
0 g
s
.743 .666 .775 r
.64594 .44006 m .68772 .44921 L .69171 .43791 L p F P
0 g
s
.741 .67 .781 r
.68772 .44921 m .64594 .44006 L .64383 .45168 L p F P
0 g
s
1 1 0 r
.007 w
.45556 .34253 m
.47686 .33449 L
s
.5 Mabswid
.658 .591 .768 r
.55327 .41697 m .50743 .4276 L .51135 .43898 L p F P
0 g
s
.658 .591 .768 r
.51135 .43898 m .5553 .42884 L .55327 .41697 L p F P
0 g
s
.713 .655 .791 r
.64167 .46314 m .60169 .46051 L .60167 .47196 L p F P
0 g
s
.688 .629 .784 r
.60169 .4489 m .55948 .45218 L .56163 .46361 L p F P
0 g
s
.688 .629 .784 r
.56163 .46361 m .60169 .46051 L .60169 .4489 L p F P
0 g
s
.745 .662 .768 r
.648 .42829 m .69171 .43791 L .6956 .42648 L p F P
0 g
s
.743 .666 .775 r
.69171 .43791 m .648 .42829 L .64594 .44006 L p F P
0 g
s
.714 .65 .784 r
.60169 .46051 m .64167 .46314 L .64383 .45168 L p F P
0 g
s
.657 .584 .762 r
.55128 .40498 m .5036 .41609 L .50743 .4276 L p F P
0 g
s
.657 .584 .762 r
.50743 .4276 m .55327 .41697 L .55128 .40498 L p F P
0 g
s
.684 0 0 r
.50487 .49146 m .512 .48918 L .5175 .52301 L closepath p F P
0 g
s
.84 0 0 r
.49969 .49272 m .50487 .49146 L .5175 .52301 L closepath p F P
0 g
s
.448 0 0 r
.512 .48918 m .51693 .4872 L .5175 .52301 L closepath p F P
0 g
s
.747 .658 .762 r
.65 .41639 m .6956 .42648 L .69939 .41492 L p F P
0 g
s
.745 .662 .768 r
.6956 .42648 m .65 .41639 L .648 .42829 L p F P
0 g
s
1 0 0 r
.007 w
.47749 .37937 m
.48431 .40387 L
s
.46939 .35028 m
.47749 .37937 L
s
.46661 .34032 m
.46939 .35028 L
s
.46607 .33836 m
.46661 .34032 L
s
.5 Mabswid
.656 .578 .755 r
.54935 .3929 m .49987 .40448 L .5036 .41609 L p F P
0 g
s
.656 .578 .755 r
.5036 .41609 m .55128 .40498 L .54935 .3929 L p F P
0 g
s
.714 .65 .784 r
.64383 .45168 m .60169 .4489 L .60169 .46051 L p F P
0 g
s
.689 .623 .778 r
.60169 .43712 m .55737 .44058 L .55948 .45218 L p F P
0 g
s
.689 .623 .778 r
.55948 .45218 m .60169 .4489 L .60169 .43712 L p F P
0 g
s
.715 .645 .778 r
.60169 .4489 m .64383 .45168 L .64594 .44006 L p F P
0 g
s
.749 .653 .755 r
.65195 .40438 m .69939 .41492 L .70306 .40326 L p F P
0 g
s
.747 .658 .762 r
.69939 .41492 m .65195 .40438 L .65 .41639 L p F P
0 g
s
1 1 0 r
.007 w
.72455 .33285 m
.73656 .33683 L
s
.5 Mabswid
.655 .571 .749 r
.54746 .38073 m .49625 .39278 L .49987 .40448 L p F P
0 g
s
.655 .571 .749 r
.49987 .40448 m .54935 .3929 L .54746 .38073 L p F P
0 g
s
0 0 0 r
.49949 .49221 m .49969 .49272 L .5175 .52301 L closepath p F P
0 g
s
.753 0 0 r
.51693 .4872 m .51677 .48668 L .5175 .52301 L closepath p F P
0 g
s
.751 .649 .749 r
.65383 .39227 m .70306 .40326 L .70662 .39151 L p F P
0 g
s
.749 .653 .755 r
.70306 .40326 m .65383 .39227 L .65195 .40438 L p F P
0 g
s
.654 .565 .742 r
.54563 .3685 m .49273 .38101 L .49625 .39278 L p F P
0 g
s
.654 .565 .742 r
.49625 .39278 m .54746 .38073 L .54563 .3685 L p F P
0 g
s
.689 .617 .771 r
.60169 .4252 m .5553 .42884 L .55737 .44058 L p F P
0 g
s
.689 .617 .771 r
.55737 .44058 m .60169 .43712 L .60169 .4252 L p F P
0 g
s
1 1 0 r
.007 w
.47686 .33449 m
.47913 .3338 L
s
.5 Mabswid
.653 .558 .736 r
.54386 .35622 m .48934 .36917 L .49273 .38101 L p F P
0 g
s
.653 .558 .736 r
.49273 .38101 m .54563 .3685 L .54386 .35622 L p F P
0 g
s
.715 .645 .778 r
.64594 .44006 m .60169 .43712 L .60169 .4489 L p F P
0 g
s
.753 .645 .742 r
.65566 .38007 m .70662 .39151 L .71005 .37969 L p F P
0 g
s
.751 .649 .749 r
.70662 .39151 m .65566 .38007 L .65383 .39227 L p F P
0 g
s
.716 .64 .771 r
.60169 .43712 m .64594 .44006 L .648 .42829 L p F P
0 g
s
.651 .552 .729 r
.54214 .3439 m .48606 .35729 L .48934 .36917 L p F P
0 g
s
.651 .552 .729 r
.48934 .36917 m .54386 .35622 L .54214 .3439 L p F P
0 g
s
.648 .538 .716 r
.5389 .31925 m .47989 .33347 L .48291 .34539 L p F P
0 g
s
0 0 1 r
.007 w
.46607 .33836 m
.47743 .33407 L
s
.5 Mabswid
.65 .545 .722 r
.54049 .33157 m .48291 .34539 L .48606 .35729 L p F P
0 g
s
0 0 1 r
.007 w
.47743 .33407 m
.47999 .3331 L
s
.5 Mabswid
.65 .545 .722 r
.48606 .35729 m .54214 .3439 L .54049 .33157 L p F P
0 g
s
.648 .538 .716 r
.48291 .34539 m .54049 .33157 L .5389 .31925 L p F P
0 g
s
0 0 1 r
.007 w
.47999 .3331 m
.4865 .33064 L
s
1 1 0 r
.48139 .33311 m
.48699 .33141 L
s
.48699 .33141 m
.49922 .3277 L
s
.5 Mabswid
.754 .641 .736 r
.65742 .36782 m .71005 .37969 L .71336 .36781 L p F P
0 g
s
.753 .645 .742 r
.71005 .37969 m .65742 .36782 L .65566 .38007 L p F P
0 g
s
.756 .637 .729 r
.65911 .35551 m .71336 .36781 L .71654 .35588 L p F P
0 g
s
.754 .641 .736 r
.71336 .36781 m .65911 .35551 L .65742 .36782 L p F P
0 g
s
.759 .628 .715 r
.72248 .33198 m .66376 .31847 L .66228 .33082 L p F P
0 g
s
.759 .628 .715 r
.66228 .33082 m .71958 .34393 L .72248 .33198 L p F P
0 g
s
.757 .632 .722 r
.66073 .34317 m .71654 .35588 L .71958 .34393 L p F P
0 g
s
.756 .637 .729 r
.71654 .35588 m .66073 .34317 L .65911 .35551 L p F P
0 g
s
.757 .632 .722 r
.71958 .34393 m .66228 .33082 L .66073 .34317 L p F P
0 g
s
1 1 0 r
.007 w
.71488 .32964 m
.71718 .3304 L
s
.71718 .3304 m
.72066 .33156 L
s
.5 Mabswid
.689 .612 .765 r
.60167 .41315 m .55327 .41697 L .5553 .42884 L p F P
0 g
s
.689 .612 .765 r
.5553 .42884 m .60169 .4252 L .60167 .41315 L p F P
0 g
s
.718 .635 .765 r
.60169 .4252 m .648 .42829 L .65 .41639 L p F P
0 g
s
.716 .64 .771 r
.648 .42829 m .60169 .4252 L .60169 .43712 L p F P
0 g
s
.505 0 0 r
.50441 .49022 m .49949 .49221 L .5175 .52301 L closepath p F P
0 g
s
.719 0 0 r
.51159 .48793 m .50441 .49022 L .5175 .52301 L closepath p F P
0 g
s
1 0 0 r
.007 w
.48431 .40387 m
.50804 .48906 L
s
.5 Mabswid
.883 0 0 r
.51677 .48668 m .51159 .48793 L .5175 .52301 L closepath p F P
0 g
s
1 1 0 r
.007 w
.6922 .32376 m
.71488 .32964 L
s
.5 Mabswid
.689 .606 .758 r
.60166 .40099 m .55128 .40498 L .55327 .41697 L p F P
0 g
s
.689 .606 .758 r
.55327 .41697 m .60167 .41315 L .60166 .40099 L p F P
0 g
s
.719 .63 .758 r
.60167 .41315 m .65 .41639 L .65195 .40438 L p F P
0 g
s
.718 .635 .765 r
.65 .41639 m .60167 .41315 L .60169 .4252 L p F P
0 g
s
1 1 0 r
.007 w
.49922 .3277 m
.52247 .32222 L
s
.5 Mabswid
.689 .6 .752 r
.60163 .38874 m .54935 .3929 L .55128 .40498 L p F P
0 g
s
.689 .6 .752 r
.55128 .40498 m .60166 .40099 L .60163 .38874 L p F P
0 g
s
.719 .625 .752 r
.60166 .40099 m .65195 .40438 L .65383 .39227 L p F P
0 g
s
.719 .63 .758 r
.65195 .40438 m .60166 .40099 L .60167 .41315 L p F P
0 g
s
.689 .595 .745 r
.60161 .3764 m .54746 .38073 L .54935 .3929 L p F P
0 g
s
.689 .595 .745 r
.54935 .3929 m .60163 .38874 L .60161 .3764 L p F P
0 g
s
.72 .62 .745 r
.60163 .38874 m .65383 .39227 L .65566 .38007 L p F P
0 g
s
.719 .625 .752 r
.65383 .39227 m .60163 .38874 L .60166 .40099 L p F P
0 g
s
1 1 0 r
.007 w
.6687 .31923 m
.6922 .32376 L
s
.5 Mabswid
.689 .589 .739 r
.60157 .364 m .54563 .3685 L .54746 .38073 L p F P
0 g
s
.689 .589 .739 r
.54746 .38073 m .60161 .3764 L .60157 .364 L p F P
0 g
s
.721 .615 .739 r
.60161 .3764 m .65566 .38007 L .65742 .36782 L p F P
0 g
s
.72 .62 .745 r
.65566 .38007 m .60161 .3764 L .60163 .38874 L p F P
0 g
s
1 1 0 r
.007 w
.52247 .32222 m
.5366 .3198 L
s
.5 Mabswid
.688 .583 .732 r
.60153 .35156 m .54386 .35622 L .54563 .3685 L p F P
0 g
s
.688 .583 .732 r
.54563 .3685 m .60157 .364 L .60153 .35156 L p F P
0 g
s
.722 .61 .732 r
.60157 .364 m .65742 .36782 L .65911 .35551 L p F P
0 g
s
.721 .615 .739 r
.65742 .36782 m .60157 .364 L .60161 .3764 L p F P
0 g
s
.688 .577 .726 r
.60149 .33909 m .54214 .3439 L .54386 .35622 L p F P
0 g
s
.688 .577 .726 r
.54386 .35622 m .60153 .35156 L .60149 .33909 L p F P
0 g
s
.722 .606 .726 r
.60153 .35156 m .65911 .35551 L .66073 .34317 L p F P
0 g
s
.722 .61 .732 r
.65911 .35551 m .60153 .35156 L .60157 .364 L p F P
0 g
s
.688 .572 .719 r
.60144 .3266 m .54049 .33157 L .54214 .3439 L p F P
0 g
s
0 0 1 r
.007 w
.4865 .33064 m
.51166 .32114 L
s
.5 Mabswid
.688 .572 .719 r
.54214 .3439 m .60149 .33909 L .60144 .3266 L p F P
0 g
s
.687 .566 .713 r
.60138 .31413 m .5389 .31925 L .54049 .33157 L p F P
0 g
s
.687 .566 .713 r
.54049 .33157 m .60144 .3266 L .60138 .31413 L p F P
0 g
s
1 1 0 r
.007 w
.54069 .3191 m
.54638 .31812 L
s
.66497 .31875 m
.6687 .31923 L
s
.5 Mabswid
.723 .6 .719 r
.60149 .33909 m .66073 .34317 L .66228 .33082 L p F P
0 g
s
.722 .606 .726 r
.66073 .34317 m .60149 .33909 L .60153 .35156 L p F P
0 g
s
.724 .595 .713 r
.60144 .3266 m .66228 .33082 L .66376 .31847 L p F P
0 g
s
0 0 1 r
.007 w
.51166 .32114 m
.54131 .30995 L
s
.5 Mabswid
.723 .6 .719 r
.66228 .33082 m .60144 .3266 L .60149 .33909 L p F P
0 g
s
.724 .595 .713 r
.66376 .31847 m .60138 .31413 L .60144 .3266 L p F P
0 g
s
1 1 0 r
.007 w
.6446 .31611 m
.66171 .31833 L
s
.54638 .31812 m
.57077 .31544 L
s
.6201 .31443 m
.6446 .31611 L
s
.57077 .31544 m
.59542 .31421 L
s
.59542 .31421 m
.59991 .31425 L
s
.60359 .31428 m
.6201 .31443 L
s
.5 Mabswid
0 0 .844 r
.60025 .28752 m .59699 .28084 L .62654 .27777 L closepath p F P
0 g
s
0 0 .659 r
.60167 .29499 m .60025 .28752 L .62654 .27777 L closepath p F P
0 g
s
0 0 .116 r
.60043 .29891 m .60167 .29499 L .62654 .27777 L closepath p F P
0 g
s
0 0 .994 r
.59699 .28084 m .59379 .27884 L .62654 .27777 L closepath p F P
0 g
s
0 0 .94 r
.59723 .29695 m .60043 .29891 L .62654 .27777 L closepath p F P
0 g
s
0 0 .269 r
.59379 .27884 m .59252 .28274 L .62654 .27777 L closepath p F P
0 g
s
0 0 .803 r
.59395 .29025 m .59723 .29695 L .62654 .27777 L closepath p F P
0 g
s
0 0 .649 r
.59252 .28274 m .59395 .29025 L .62654 .27777 L closepath p F P
0 g
s
0 0 1 r
.007 w
.54131 .30995 m
.59392 .29008 L
s
.5 Mabswid
0 .249 0 r
.31762 .34795 m .32719 .36132 L .30374 .3416 L closepath p F P
0 g
s
0 .83 0 r
.31868 .3305 m .31762 .34795 L .30374 .3416 L closepath p F P
0 g
s
0 .874 0 r
.32978 .31913 m .31868 .3305 L .30374 .3416 L closepath p F P
0 g
s
0 .699 0 r
.32719 .36132 m .34185 .36279 L .30374 .3416 L closepath p F P
0 g
s
0 0 0 r
.34446 .32053 m .32978 .31913 L .30374 .3416 L closepath p F P
0 g
s
0 .899 0 r
.34185 .36279 m .35302 .35146 L .30374 .3416 L closepath p F P
0 g
s
0 .519 0 r
.35411 .33392 m .34446 .32053 L .30374 .3416 L closepath p F P
0 g
s
0 .778 0 r
.35302 .35146 m .35411 .33392 L .30374 .3416 L closepath p F P
0 g
s
0 1 0 r
.007 w
.35369 .3406 m
.46607 .33836 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3oool8
0?ooo`P00000X@3oool00?l0oooo3`00002R0?ooo`00o`3oool4000000D0002V1@00002S0?ooo`00
o`3oool00`000000002V0000YP040000YP80000000<0003=000000000000Y@3oool00?l0oooo00@0
00000000YP000:H0002V0`00000010000<d0000000000000002V0?ooo`00oP3oool30000o`800000
0`000<d300000:L0oooo003k0?ooo`H0003o0`000<d300000:T0oooo003h0?ooo`T0003o00D0003=
000000000000003`0000002Z0?ooo`00m@3oool:0000o`80oooo00@000000000l00000000000Z`3o
ool00?<0oooo2@000?l60?ooo`030000003oool0oooo0:/0oooo003`0?ooo`T0003o]`3oool00>d0
oooo2@000?nj0?ooo`00jP3oool:0000ok`0oooo003X0?ooo`T0003o_`3oool00>D0oooo2@000?o2
0?ooo`00hP3oool90000o`T0oooo703oo`2P0?ooo`00h03oool90000o`D0oooo:`3oo`2G0?ooo`00
g@3oool90000ocd0ool0S@3oool008h0oooo0`00001:0?ooo`P0003o4@3oo`0?0:n@]P030000002i
V;H0^IRf00X0^IRf603oo`280?ooo`00S@3oool8000004<0oooo2@000?l=0?oo01D0[i2f00<00000
0;VH]P2iV;H04`2iV;HD0?oo08<0oooo002<0?ooo`P0000000<008@00000003oool0?P3oool90000
o`H0ool0102URKL00`000000[i2f0:n@]P0H0:n@]P030000002iV;H0^IRf01P0^IRf00<000000<:P
]`32X;L00P32X;L=0?oo0800oooo002:0?ooo`P000001000Q0000`000000oooo0?ooo`0i0?ooo`X0
003o103oo`080:F9]`030000002_T;H0[i2f0180[i2f3@00000C0;VH]P0300000032X;L0`Z2g00P0
`Z2g2`3oo`1m0?ooo`00R@3oool7000000H008@000<000000?ooo`3oool0=@3oool00`3oo`00003o
0000o`080000o`@0ool02`2URKL00`000000[i2f0:n@]P040:n@]Ph000001P2`T[P00`000000^IVh
0;VI^0040;VI^0d000001P2iV;H00`000000`Z2g0<:P]`0<0<:P]``0ool0N03oool008P0oooo1P00
0009002400030000003oool0oooo0380oooo0P000?l20?oo00H0003o103oo`0=0:F9]`P00000502`
T[P00`000000^IVh0;VI^00A0;VI^0T000003`32X;L;0?oo07H0oooo00270?ooo`D000002P00Q003
00000300oooo1@000?l20?oo00<0003o00<0ool00:F9]`2URKL03@2URKL4000000030:J;^0000000
/9:h01T0/9:h00<000000;VI^02iVKP05`2iVKP00`000000`J6h0<6Q^004000000h0`Z2g2`3oo`1c
0?ooo`00QP3oool4000000H008@01P000002003700030000003oool0oooo01D0oooo6P00o`040000
o`<0ool03P2URKL4000000D0YX^h00<000000;2B^02`T[P0602`T[P00`000000^IVh0;VI^00G0;VI
^00300000031XKP0`J6h00@0`J6h1000000?0<:P]`030000003oo`00ool000H0ool0L03oool008@0
oooo10000003002400D000001`00a`0c003o00<0003o0P3oo`000`000000YHVg0:F9]`090:F9]`@0
00002@2VRkP00`000000/9:h0;2B^00H0;2B^0030000002iVKP0^IVh01H0^IVh00<000000<6Q^031
XKP02@31XKP4000000/0`Z2g00<000000<^Z^03oo`00203oo`1^0?ooo`00P`3oool8000000`00<L0
<`00o`000`3o0000ool009Z3^00209Z3^0030000002URKL0YHVg00D0YHVg1000000>0:J;^0030000
002`T[P0/9:h0140/9:h4`00000<0;VI^00300000031XKP0`J6h00d0`J6h100000060<:P]`030000
003;Z[P0bjZh00<0bjZh2@3oo`1[0?ooo`00PP3oool3000001800<L06@00o`0A0?ooo`L0ool00`3o
000509Z3^0030000002URKL0YHVg00@000004P2VRkP00`000000/9:h0;2B^0040;2B^0d000001P2`
TkT00`000000^9^i0;RK^@0:0;RK^@d000004`31XKP400000080`Z2g00<000000<^Z^03;Z[P01P3;
Z[P90?oo06P0oooo00230?ooo`P00000