(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   5449280,     200935]*)
(*NotebookOutlinePosition[   5451238,     200995]*)
(*  CellTagsIndexPosition[   5451096,     200987]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Superficies. Integrales de superficie", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[ParametricPlot::ppcom]\), "\n", 
    \(Off[General::spell1]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Superficies en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Section"],

Cell[TextData[{
  "En todo lo que sigue consideraremos funciones de una o varias variables \
con derivada continua o con derivadas parciales de primer orden continuas \
respectivamente. Las formas m\[AAcute]s frecuentes de definir una superficie \
en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " son las siguientes:\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " La superficie viene dada por ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una superficie de la forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`S = \({\((x, y, z)\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : \ \((x, y)\) \[Element] A\), 
            \ z = f(x, y)} = {
            \((x, y, f(x, y))\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : \ \((x, y)\) \[Element] A\)}
            \)\)]],
  "    "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde  ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \ \[DoubleStruckCapitalR]\^2\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " es un campo escalar de dos variables."
}], "Text"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida impl\[IAcute]citamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " por una ecuaci\[OAcute]n, es decir, se trata de una superficie de la \
forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm
      \`S = {\((x, y, z)\) \[Element] 
              \(\(\[DoubleStruckCapitalR]\^3\) : g(x, y, z)\) = 0}\)]],
  " "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es un campo escalar de tres variables."
}], "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " La superficie est\[AAcute] ",
  StyleBox["definida param\[EAcute]tricamente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", es decir, se trata de una superficie de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`S = \[Gamma](A)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es una funci\[OAcute]n de dos variables con valores en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". La funci\[OAcute]n \[Gamma] transforma un subconjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^\(2\ \)\)]],
  "en una superficie en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ". En este caso se acostumbra a interpretar los puntos del conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " como par\[AAcute]metros que describen la superficie. Si notamos ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, t)\) \[Element] A\)]],
  " un elemento gen\[EAcute]rico de ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  ", la funci\[OAcute]n \[Gamma] debe ser de la forma"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](s, t)\), "=", 
        RowBox[{\((x(s, t), y(s, t), z(s, t))\), "=", 
          RowBox[{
            RowBox[{\(x(s, t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(y(s, t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(s, t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y, por tanto ",
  Cell[BoxData[
      \(TraditionalForm
      \`S = \(\[Gamma](A) = {\((x(s, t), y(s, t), z(s, t))\), \ \ 
            \((s, t)\) \[Element] A}\)\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Observa que ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de ",
  StyleBox["b)",
    FontWeight->"Bold"],
  "  pues la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es el conjunto de puntos donde se anula la funci\[OAcute]n de tres \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y, z) = f(x, y) - z\)]],
  ", y tambi\[EAcute]n es un caso particular de ",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  pues ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n  ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  tiene como ecuaciones param\[EAcute]tricas  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Gamma] \((x, y)\) = \((x, y, f(x, y))\)\),
          FontWeight->"Plain"], TraditionalForm]],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Para cada uno de estos casos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando que permite representar la superficie dada:\n\
Plot3D[f[x,y],{x,a,b},{y,c,d},opciones]  representa la gr\[AAcute]fica de la \
funci\[OAcute]n",
  StyleBox[" f ",
    FontSlant->"Italic"],
  "en el intervalo [a,b]\[Times][c,d].\n\
ContourPlot3D[g[x,y,z],{x,xmin,xmax},{y,ymin,ymax},{z,zmin,zmax}, opciones] \
representa las superficies de nivel de la funci\[OAcute]n g[x,y,z], es decir \
las superficies de ecuaci\[OAcute]n impl\[IAcute]cita g[x,y,z]=c. Por defecto \
representa la superficie que corresponde al valor c=0. \n\
ParametricPlot3D[{x[s,t],y[s,t],z[s,t]},{s,a,b},{t,c,d},opciones]  representa \
la gr\[AAcute]fica de la superficie de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](s, t) = \((x(s, t), y(s, t), 
          z(s, t))\)\)]],
  " para  ",
  Cell[BoxData[
      \(TraditionalForm\`\((s, 
          t)\) \[Element] \([a, b]\)\[Times]\([c, d]\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[\ 
        x\ y\ Exp[\(-x\^2\) - y\^2], \ {x, \(-2\), 2}, {y, \(-2\), 2}, 
        PlotPoints -> 30, AxesLabel -> {X, Y, Z}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1984e-017 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.29165 .07573 -9.31117 -12.875 ]
[.29165 .07573 .68883 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.91861 .21225 0 -8.62807 ]
[.91861 .21225 10 4.24693 ]
[.01653 .31266 -24 -2.78251 ]
[.01653 .31266 0 6.21749 ]
[.00696 .37264 -6 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00299 .43496 -18 -2.88647 ]
[-0.00299 .43496 0 6.11353 ]
[-0.05457 .39542 -10 -4.05332 ]
[-0.05457 .39542 0 8.82168 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
1.000 setlinewidth
grestore
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
gsave
.91861 .21225 -61 -12.6281 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.02879 .30798 m
.03492 .30564 L
s
[(-0.1)] .01653 .31266 1 -0.38166 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0)] .00696 .37264 1 -0.37036 Mshowa
.00936 .43054 m
.01554 .42832 L
s
[(0.1)] -0.00299 .43496 1 -0.35856 Mshowa
.125 Mabswid
.02691 .31982 m
.03059 .31842 L
s
.02502 .33175 m
.0287 .33036 L
s
.02312 .34376 m
.0268 .34238 L
s
.0212 .35588 m
.02488 .3545 L
s
.01731 .38038 m
.02101 .37902 L
s
.01535 .39277 m
.01905 .39142 L
s
.01337 .40526 m
.01707 .40392 L
s
.01137 .41785 m
.01508 .41651 L
s
.03065 .29623 m
.03432 .29482 L
s
.0325 .28457 m
.03617 .28315 L
s
.03433 .27299 m
.038 .27157 L
s
.03615 .2615 m
.03982 .26007 L
s
.00734 .44332 m
.01105 .442 L
s
.0053 .45621 m
.00901 .4549 L
s
.00324 .4692 m
.00695 .46789 L
s
.00116 .48229 m
.00488 .48099 L
s
gsave
-0.05457 .39542 -71 -8.05332 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Z) show
1.000 setlinewidth
grestore
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.671 .746 .907 r
.39086 .69118 .40172 .70111 .41991 .69554 .40914 .68529 Metetra
.676 .743 .901 r
.40914 .68529 .41991 .69554 .43823 .68977 .42754 .67908 Metetra
.681 .737 .893 r
.42754 .67908 .43823 .68977 .45666 .68375 .44607 .67252 Metetra
.686 .73 .884 r
.44607 .67252 .45666 .68375 .47522 .6775 .46471 .6656 Metetra
.689 .721 .874 r
.46471 .6656 .47522 .6775 .4939 .67105 .48347 .65838 Metetra
.689 .711 .865 r
.48347 .65838 .4939 .67105 .51269 .66448 .50234 .651 Metetra
.686 .699 .856 r
.50234 .651 .51269 .66448 .5316 .65793 .52132 .64368 Metetra
.679 .687 .851 r
.52132 .64368 .5316 .65793 .55062 .65159 .54041 .63669 Metetra
.668 .676 .848 r
.54041 .63669 .55062 .65159 .56978 .64563 .55962 .63035 Metetra
.653 .666 .85 r
.55962 .63035 .56978 .64563 .58907 .64026 .57897 .62495 Metetra
.635 .66 .856 r
.57897 .62495 .58907 .64026 .60852 .63557 .59849 .62067 Metetra
.615 .658 .868 r
.59849 .62067 .60852 .63557 .62813 .6316 .61819 .61755 Metetra
.593 .662 .886 r
.61819 .61755 .62813 .6316 .64793 .62826 .63809 .61545 Metetra
.572 .674 .909 r
.63809 .61545 .64793 .62826 .6679 .62535 .65821 .61404 Metetra
.554 .696 .934 r
.65821 .61404 .6679 .62535 .68806 .62257 .67853 .61288 Metetra
.542 .726 .959 r
.67853 .61288 .68806 .62257 .70839 .6196 .69904 .61146 Metetra
.541 .763 .979 r
.69904 .61146 .70839 .6196 .72887 .61615 .7197 .60929 Metetra
.552 .8 .991 r
.7197 .60929 .72887 .61615 .74948 .612 .7405 .60603 Metetra
.576 .833 .994 r
.7405 .60603 .74948 .612 .77021 .60705 .76139 .60151 Metetra
.606 .856 .991 r
.76139 .60151 .77021 .60705 .79103 .60131 .78236 .59575 Metetra
.636 .868 .985 r
.78236 .59575 .79103 .60131 .81196 .59489 .8034 .58895 Metetra
.661 .868 .977 r
.8034 .58895 .81196 .59489 .83299 .58798 .82452 .58137 Metetra
.677 .859 .968 r
.82452 .58137 .83299 .58798 .85413 .58077 .84575 .57335 Metetra
.685 .844 .959 r
.84575 .57335 .85413 .58077 .87542 .57345 .86709 .56518 Metetra
.686 .826 .95 r
.86709 .56518 .87542 .57345 .89685 .56616 .88858 .55708 Metetra
.683 .809 .942 r
.88858 .55708 .89685 .56616 .91844 .55899 .91024 .5492 Metetra
.678 .793 .936 r
.91024 .5492 .91844 .55899 .9402 .55198 .93207 .5416 Metetra
.673 .781 .931 r
.93207 .5416 .9402 .55198 .96215 .54513 .9541 .53429 Metetra
.668 .771 .927 r
.9541 .53429 .96215 .54513 .98427 .53842 .97631 .52722 Metetra
.678 .744 .901 r
.37988 .68095 .39086 .69118 .40914 .68529 .39825 .67463 Metetra
.685 .74 .893 r
.39825 .67463 .40914 .68529 .42754 .67908 .41674 .66784 Metetra
.692 .733 .882 r
.41674 .66784 .42754 .67908 .44607 .67252 .43536 .66053 Metetra
.698 .723 .869 r
.43536 .66053 .44607 .67252 .46471 .6656 .4541 .6527 Metetra
.701 .711 .857 r
.4541 .6527 .46471 .6656 .48347 .65838 .47294 .64443 Metetra
.7 .698 .844 r
.47294 .64443 .48347 .65838 .50234 .651 .49189 .63594 Metetra
.695 .683 .834 r
.49189 .63594 .50234 .651 .52132 .64368 .51094 .62755 Metetra
.684 .668 .828 r
.51094 .62755 .52132 .64368 .54041 .63669 .53008 .6197 Metetra
.669 .653 .825 r
.53008 .6197 .54041 .63669 .55962 .63035 .54935 .61285 Metetra
.649 .64 .827 r
.54935 .61285 .55962 .63035 .57897 .62495 .56875 .60743 Metetra
.624 .63 .836 r
.56875 .60743 .57897 .62495 .59849 .62067 .58832 .60374 Metetra
.595 .624 .851 r
.58832 .60374 .59849 .62067 .61819 .61755 .6081 .60183 Metetra
.561 .626 .873 r
.6081 .60183 .61819 .61755 .63809 .61545 .62812 .6015 Metetra
.525 .637 .903 r
.62812 .6015 .63809 .61545 .65821 .61404 .64838 .60225 Metetra
.49 .66 .937 r
.64838 .60225 .65821 .61404 .67853 .61288 .66888 .60341 Metetra
.46 .697 .97 r
.66888 .60341 .67853 .61288 .69904 .61146 .68959 .60419 Metetra
.446 .745 .992 r
.68959 .60419 .69904 .61146 .7197 .60929 .71047 .60386 Metetra
.456 .796 .999 r
.71047 .60386 .7197 .60929 .7405 .60603 .73148 .60189 Metetra
.491 .844 .994 r
.73148 .60189 .7405 .60603 .76139 .60151 .75257 .59802 Metetra
.545 .882 .988 r
.75257 .59802 .76139 .60151 .78236 .59575 .7737 .59228 Metetra
.603 .906 .984 r
.7737 .59228 .78236 .59575 .8034 .58895 .79486 .58494 Metetra
.651 .912 .98 r
.79486 .58494 .8034 .58895 .82452 .58137 .81608 .57646 Metetra
.683 .903 .974 r
.81608 .57646 .82452 .58137 .84575 .57335 .83736 .56733 Metetra
.699 .884 .966 r
.83736 .56733 .84575 .57335 .86709 .56518 .85876 .55798 Metetra
.702 .859 .957 r
.85876 .55798 .86709 .56518 .88858 .55708 .88029 .54877 Metetra
.698 .834 .948 r
.88029 .54877 .88858 .55708 .91024 .5492 .90199 .53992 Metetra
.69 .812 .94 r
.90199 .53992 .91024 .5492 .93207 .5416 .92388 .53152 Metetra
.682 .794 .934 r
.92388 .53152 .93207 .5416 .9541 .53429 .94597 .52358 Metetra
.675 .78 .929 r
.94597 .52358 .9541 .53429 .97631 .52722 .96827 .51604 Metetra
.686 .743 .894 r
.36877 .67039 .37988 .68095 .39825 .67463 .38723 .66352 Metetra
.695 .737 .883 r
.38723 .66352 .39825 .67463 .41674 .66784 .40583 .65598 Metetra
.704 .728 .869 r
.40583 .65598 .41674 .66784 .43536 .66053 .42455 .6477 Metetra
.711 .716 .853 r
.42455 .6477 .43536 .66053 .4541 .6527 .44339 .63868 Metetra
.713 .701 .837 r
.44339 .63868 .4541 .6527 .47294 .64443 .46233 .62905 Metetra
.711 .685 .823 r
.46233 .62905 .47294 .64443 .49189 .63594 .48136 .6191 Metetra
.704 .668 .812 r
.48136 .6191 .49189 .63594 .51094 .62755 .50047 .60933 Metetra
.69 .65 .805 r
.50047 .60933 .51094 .62755 .53008 .6197 .51967 .60035 Metetra
.671 .632 .802 r
.51967 .60035 .53008 .6197 .54935 .61285 .53897 .59285 Metetra
.644 .615 .806 r
.53897 .59285 .54935 .61285 .56875 .60743 .55841 .58744 Metetra
.611 .6 .815 r
.55841 .58744 .56875 .60743 .58832 .60374 .57803 .58455 Metetra
.569 .589 .833 r
.57803 .58455 .58832 .60374 .6081 .60183 .59788 .58426 Metetra
.519 .583 .859 r
.59788 .58426 .6081 .60183 .62812 .6015 .618 .58629 Metetra
.459 .586 .893 r
.618 .58629 .62812 .6015 .64838 .60225 .63841 .58993 Metetra
.391 .603 .932 r
.63841 .58993 .64838 .60225 .66888 .60341 .6591 .59419 Metetra
.325 .636 .964 r
.6591 .59419 .66888 .60341 .68959 .60419 .68005 .59793 Metetra
.278 .682 .971 r
.68005 .59793 .68959 .60419 .71047 .60386 .70118 .60009 Metetra
.277 .737 .951 r
.70118 .60009 .71047 .60386 .73148 .60189 .72243 .59988 Metetra
.33 .798 .927 r
.72243 .59988 .73148 .60189 .75257 .59802 .74374 .59691 Metetra
.423 .861 .92 r
.74374 .59691 .75257 .59802 .7737 .59228 .76505 .59121 Metetra
.529 .914 .932 r
.76505 .59121 .7737 .59228 .79486 .58494 .78635 .5832 Metetra
.621 .944 .949 r
.78635 .5832 .79486 .58494 .81608 .57646 .80766 .57353 Metetra
.683 .946 .96 r
.80766 .57353 .81608 .57646 .83736 .56733 .82899 .56292 Metetra
.715 .926 .962 r
.82899 .56292 .83736 .56733 .85876 .55798 .85042 .55203 Metetra
.723 .896 .958 r
.85042 .55203 .85876 .55798 .88029 .54877 .87197 .54136 Metetra
.718 .863 .95 r
.87197 .54136 .88029 .54877 .90199 .53992 .89369 .53124 Metetra
.707 .834 .943 r
.89369 .53124 .90199 .53992 .92388 .53152 .91562 .52181 Metetra
.695 .809 .936 r
.91562 .52181 .92388 .53152 .94597 .52358 .93777 .51306 Metetra
.684 .79 .931 r
.93777 .51306 .94597 .52358 .96827 .51604 .96014 .50492 Metetra
.696 .741 .886 r
.35753 .6595 .36877 .67039 .38723 .66352 .3761 .65196 Metetra
.707 .734 .872 r
.3761 .65196 .38723 .66352 .40583 .65598 .39481 .6435 Metetra
.717 .723 .855 r
.39481 .6435 .40583 .65598 .42455 .6477 .41364 .63403 Metetra
.724 .71 .836 r
.41364 .63403 .42455 .6477 .44339 .63868 .43259 .62354 Metetra
.726 .693 .818 r
.43259 .62354 .44339 .63868 .46233 .62905 .45164 .61222 Metetra
.723 .675 .803 r
.45164 .61222 .46233 .62905 .48136 .6191 .47076 .6005 Metetra
.713 .656 .791 r
.47076 .6005 .48136 .6191 .50047 .60933 .48994 .58903 Metetra
.696 .635 .784 r
.48994 .58903 .50047 .60933 .51967 .60035 .50919 .57868 Metetra
.672 .615 .782 r
.50919 .57868 .51967 .60035 .53897 .59285 .52852 .57038 Metetra
.639 .594 .787 r
.52852 .57038 .53897 .59285 .55841 .58744 .54798 .565 Metetra
.596 .573 .798 r
.54798 .565 .55841 .58744 .57803 .58455 .56763 .5631 Metetra
.539 .552 .817 r
.56763 .5631 .57803 .58455 .59788 .58426 .58753 .56485 Metetra
.465 .534 .844 r
.58753 .56485 .59788 .58426 .618 .58629 .60774 .56982 Metetra
.368 .52 .877 r
.60774 .56982 .618 .58629 .63841 .58993 .6283 .57707 Metetra
.247 .514 .908 r
.6283 .57707 .63841 .58993 .6591 .59419 .6492 .58523 Metetra
.117 .518 .912 r
.6492 .58523 .6591 .59419 .68005 .59793 .6704 .59271 Metetra
.023 .537 .866 r
.6704 .59271 .68005 .59793 .70118 .60009 .69181 .59803 Metetra
.017 .581 .796 r
.69181 .59803 .70118 .60009 .72243 .59988 .71334 .60006 Metetra
.102 .658 .754 r
.71334 .60006 .72243 .59988 .74374 .59691 .73489 .59824 Metetra
.25 .761 .763 r
.73489 .59824 .74374 .59691 .76505 .59121 .7564 .59262 Metetra
.42 .865 .812 r
.7564 .59262 .76505 .59121 .78635 .5832 .77785 .58377 Metetra
.571 .94 .87 r
.77785 .58377 .78635 .5832 .80766 .57353 .79924 .57262 Metetra
.677 .971 .916 r
.79924 .57262 .80766 .57353 .82899 .56292 .82062 .56016 Metetra
.731 .962 .941 r
.82062 .56016 .82899 .56292 .85042 .55203 .84206 .54734 Metetra
.748 .931 .948 r
.84206 .54734 .85042 .55203 .87197 .54136 .86362 .53486 Metetra
.743 .893 .947 r
.86362 .53486 .87197 .54136 .89369 .53124 .88535 .52317 Metetra
.728 .856 .942 r
.88535 .52317 .89369 .53124 .91562 .52181 .9073 .51245 Metetra
.71 .825 .936 r
.9073 .51245 .91562 .52181 .93777 .51306 .92948 .50272 Metetra
.695 .801 .931 r
.92948 .50272 .93777 .51306 .96014 .50492 .95191 .49384 Metetra
.706 .741 .878 r
.34617 .64832 .35753 .6595 .3761 .65196 .36485 .64 Metetra
.72 .732 .861 r
.36485 .64 .3761 .65196 .39481 .6435 .38368 .63049 Metetra
.731 .721 .841 r
.38368 .63049 .39481 .6435 .41364 .63403 .40264 .61964 Metetra
.738 .706 .821 r
.40264 .61964 .41364 .63403 .43259 .62354 .42171 .60746 Metetra
.74 .689 .802 r
.42171 .60746 .43259 .62354 .45164 .61222 .44088 .5942 Metetra
.735 .669 .786 r
.44088 .5942 .45164 .61222 .47076 .6005 .4601 .58043 Metetra
.723 .649 .774 r
.4601 .58043 .47076 .6005 .48994 .58903 .47935 .56702 Metetra
.704 .627 .768 r
.47935 .56702 .48994 .58903 .50919 .57868 .49865 .5551 Metetra
.675 .604 .768 r
.49865 .5551 .50919 .57868 .52852 .57038 .51801 .5459 Metetra
.635 .578 .774 r
.51801 .5459 .52852 .57038 .54798 .565 .53748 .54056 Metetra
.579 .55 .786 r
.53748 .54056 .54798 .565 .56763 .5631 .55714 .53983 Metetra
.503 .518 .805 r
.55714 .53983 .56763 .5631 .58753 .56485 .57708 .54391 Metetra
.396 .48 .829 r
.57708 .54391 .58753 .56485 .60774 .56982 .59737 .55229 Metetra
.247 .436 .85 r
.59737 .55229 .60774 .56982 .6283 .57707 .61807 .56374 Metetra
.055 .385 .847 r
.61807 .56374 .6283 .57707 .6492 .58523 .63917 .57645 Metetra
0 .338 .786 r
.63917 .57645 .6492 .58523 .6704 .59271 .66062 .58832 Metetra
0 .324 .674 r
.66062 .58832 .6704 .59271 .69181 .59803 .68232 .59737 Metetra
.232 0 0 r
.68232 .59737 .69181 .59803 .71334 .60006 .70415 .60206 Metetra
.103 0 0 r
.70415 .60206 .71334 .60006 .73489 .59824 .72597 .60161 Metetra
.72597 .60161 .73489 .59824 .7564 .59262 .7477 .5961 Metetra
.326 .792 .68 r
.7477 .5961 .7564 .59262 .77785 .58377 .7693 .58628 Metetra
.532 .915 .779 r
.7693 .58628 .77785 .58377 .79924 .57262 .79079 .57338 Metetra
.677 .978 .858 r
.79079 .57338 .79924 .57262 .82062 .56016 .81221 .55876 Metetra
.753 .984 .906 r
.81221 .55876 .82062 .56016 .84206 .54734 .83365 .54369 Metetra
.777 .957 .929 r
.83365 .54369 .84206 .54734 .86362 .53486 .8552 .52909 Metetra
.771 .917 .936 r
.8552 .52909 .86362 .53486 .88535 .52317 .87693 .51557 Metetra
.751 .875 .936 r
.87693 .51557 .88535 .52317 .9073 .51245 .89888 .50337 Metetra
.729 .84 .933 r
.89888 .50337 .9073 .51245 .92948 .50272 .9211 .49249 Metetra
.708 .811 .929 r
.9211 .49249 .92948 .50272 .95191 .49384 .94359 .48277 Metetra
.716 .741 .871 r
.33467 .63692 .34617 .64832 .36485 .64 .35347 .62778 Metetra
.732 .733 .852 r
.35347 .62778 .36485 .64 .38368 .63049 .37243 .61715 Metetra
.744 .721 .83 r
.37243 .61715 .38368 .63049 .40264 .61964 .39153 .60483 Metetra
.752 .706 .808 r
.39153 .60483 .40264 .61964 .42171 .60746 .41074 .59086 Metetra
.754 .689 .789 r
.41074 .59086 .42171 .60746 .44088 .5942 .43003 .57555 Metetra
.749 .67 .774 r
.43003 .57555 .44088 .5942 .4601 .58043 .44937 .55961 Metetra
.736 .649 .763 r
.44937 .55961 .4601 .58043 .47935 .56702 .46871 .54415 Metetra
.713 .626 .759 r
.46871 .54415 .47935 .56702 .49865 .5551 .48807 .53058 Metetra
.68 .601 .76 r
.48807 .53058 .49865 .5551 .51801 .5459 .50745 .52044 Metetra
.632 .571 .768 r
.50745 .52044 .51801 .5459 .53748 .54056 .52692 .51514 Metetra
.562 .534 .782 r
.52692 .51514 .53748 .54056 .55714 .53983 .54658 .51563 Metetra
.459 .486 .8 r
.54658 .51563 .55714 .53983 .57708 .54391 .56654 .52219 Metetra
.307 .421 .814 r
.56654 .52219 .57708 .54391 .59737 .55229 .58689 .53418 Metetra
.092 .331 .806 r
.58689 .53418 .59737 .55229 .61807 .56374 .6077 .5501 Metetra
0 .225 .74 r
.6077 .5501 .61807 .56374 .63917 .57645 .62899 .56768 Metetra
0 .14 .613 r
.62899 .56768 .63917 .57645 .66062 .58832 .65069 .58429 Metetra
.456 0 0 r
.65069 .58429 .66062 .58832 .68232 .59737 .67268 .59737 Metetra
.396 0 0 r
.67268 .59737 .68232 .59737 .70415 .60206 .6948 .60495 Metetra
.225 0 0 r
.6948 .60495 .70415 .60206 .72597 .60161 .7169 .60602 Metetra
.7169 .60602 .72597 .60161 .7477 .5961 .73886 .60062 Metetra
.73886 .60062 .7477 .5961 .7693 .58628 .76063 .58974 Metetra
.552 .916 .738 r
.76063 .58974 .7693 .58628 .79079 .57338 .78221 .57495 Metetra
.711 .985 .823 r
.78221 .57495 .79079 .57338 .81221 .55876 .80368 .558 Metetra
.788 .994 .876 r
.80368 .558 .81221 .55876 .83365 .54369 .82513 .54049 Metetra
.81 .968 .905 r
.82513 .54049 .83365 .54369 .8552 .52909 .84667 .52361 Metetra
.8 .928 .919 r
.84667 .52361 .8552 .52909 .87693 .51557 .86839 .50812 Metetra
.775 .886 .925 r
.86839 .50812 .87693 .51557 .89888 .50337 .89036 .49433 Metetra
.747 .849 .926 r
.89036 .49433 .89888 .50337 .9211 .49249 .9126 .48223 Metetra
.721 .818 .925 r
.9126 .48223 .9211 .49249 .94359 .48277 .93514 .47162 Metetra
.726 .744 .866 r
.32302 .62545 .33467 .63692 .35347 .62778 .34195 .61551 Metetra
.743 .736 .845 r
.34195 .61551 .35347 .62778 .37243 .61715 .36104 .6038 Metetra
.758 .726 .823 r
.36104 .6038 .37243 .61715 .39153 .60483 .38029 .59009 Metetra
.766 .712 .801 r
.38029 .59009 .39153 .60483 .41074 .59086 .39965 .5744 Metetra
.769 .696 .782 r
.39965 .5744 .41074 .59086 .43003 .57555 .41909 .55714 Metetra
.764 .678 .768 r
.41909 .55714 .43003 .57555 .44937 .55961 .43855 .53914 Metetra
.75 .658 .759 r
.43855 .53914 .44937 .55961 .46871 .54415 .458 .52173 Metetra
.727 .636 .757 r
.458 .52173 .46871 .54415 .48807 .53058 .47742 .5066 Metetra
.689 .609 .762 r
.47742 .5066 .48807 .53058 .50745 .52044 .49683 .49557 Metetra
.631 .575 .773 r
.49683 .49557 .50745 .52044 .52692 .51514 .51632 .4903 Metetra
.542 .528 .79 r
.51632 .4903 .52692 .51514 .54658 .51563 .53597 .49194 Metetra
.402 .459 .804 r
.53597 .49194 .54658 .51563 .56654 .52219 .55593 .50083 Metetra
.189 .353 .798 r
.55593 .50083 .56654 .52219 .58689 .53418 .57631 .51624 Metetra
0 .209 .735 r
.57631 .51624 .58689 .53418 .6077 .5501 .59721 .53641 Metetra
0 .064 .603 r
.59721 .53641 .6077 .5501 .62899 .56768 .61865 .55866 Metetra
.535 .015 0 r
.61865 .55866 .62899 .56768 .65069 .58429 .64056 .57983 Metetra
.567 0 0 r
.64056 .57983 .65069 .58429 .67268 .59737 .6628 .59681 Metetra
.476 0 0 r
.6628 .59681 .67268 .59737 .6948 .60495 .68521 .60721 Metetra
.261 0 0 r
.68521 .60721 .6948 .60495 .7169 .60602 .70757 .60974 Metetra
.70757 .60974 .7169 .60602 .73886 .60062 .72976 .60445 Metetra
.409 .84 .698 r
.72976 .60445 .73886 .60062 .76063 .58974 .7517 .59254 Metetra
.653 .963 .783 r
.7517 .59254 .76063 .58974 .78221 .57495 .7734 .5759 Metetra
.783 .998 .832 r
.7734 .5759 .78221 .57495 .80368 .558 .79493 .55668 Metetra
.836 .989 .863 r
.79493 .55668 .80368 .558 .82513 .54049 .81641 .53679 Metetra
.843 .96 .884 r
.81641 .53679 .82513 .54049 .84667 .52361 .83796 .51771 Metetra
.825 .923 .9 r
.83796 .51771 .84667 .52361 .86839 .50812 .85969 .50031 Metetra
.796 .885 .91 r
.85969 .50031 .86839 .50812 .89036 .49433 .88168 .48498 Metetra
.763 .85 .916 r
.88168 .48498 .89036 .49433 .9126 .48223 .90396 .4717 Metetra
.733 .82 .918 r
.90396 .4717 .9126 .48223 .93514 .47162 .92656 .46023 Metetra
.734 .749 .864 r
.31122 .61407 .32302 .62545 .34195 .61551 .33027 .60349 Metetra
.754 .743 .843 r
.33027 .60349 .34195 .61551 .36104 .6038 .3495 .59089 Metetra
.77 .735 .821 r
.3495 .59089 .36104 .6038 .38029 .59009 .36889 .57603 Metetra
.781 .724 .8 r
.36889 .57603 .38029 .59009 .39965 .5744 .38841 .55895 Metetra
.785 .711 .782 r
.38841 .55895 .39965 .5744 .41909 .55714 .408 .5401 Metetra
.782 .696 .769 r
.408 .5401 .41909 .55714 .43855 .53914 .4276 .52043 Metetra
.769 .679 .764 r
.4276 .52043 .43855 .53914 .458 .52173 .44716 .50146 Metetra
.745 .659 .766 r
.44716 .50146 .458 .52173 .47742 .5066 .46667 .48506 Metetra
.704 .634 .776 r
.46667 .48506 .47742 .5066 .49683 .49557 .48614 .4733 Metetra
.634 .597 .794 r
.48614 .4733 .49683 .49557 .51632 .4903 .50564 .46805 Metetra
.517 .537 .815 r
.50564 .46805 .51632 .4903 .53597 .49194 .5253 .47059 Metetra
.32 .434 .822 r
.5253 .47059 .53597 .49194 .55593 .50083 .54525 .48131 Metetra
.025 .271 .769 r
.54525 .48131 .55593 .50083 .57631 .51624 .56565 .49945 Metetra
0 .078 .633 r
.56565 .49945 .57631 .51624 .59721 .53641 .5866 .52302 Metetra
0 0 .474 r
.5866 .52302 .59721 .53641 .61865 .55866 .60814 .54903 Metetra
.616 .106 0 r
.60814 .54903 .61865 .55866 .64056 .57983 .6302 .57389 Metetra
.604 .053 0 r
.6302 .57389 .64056 .57983 .6628 .59681 .65265 .59404 Metetra
.477 0 0 r
.65265 .59404 .6628 .59681 .68521 .60721 .67528 .60672 Metetra
.181 0 0 r
.67528 .60672 .68521 .60721 .70757 .60974 .69787 .61044 Metetra
.261 .77 .801 r
.69787 .61044 .70757 .60974 .72976 .60445 .72027 .60523 Metetra
.616 .958 .872 r
.72027 .60523 .72976 .60445 .7517 .59254 .74238 .59245 Metetra
.788 .995 .868 r
.74238 .59245 .7517 .59254 .7734 .5759 .7642 .57428 Metetra
.855 .982 .857 r
.7642 .57428 .7734 .5759 .79493 .55668 .78582 .55317 Metetra
.873 .956 .858 r
.78582 .55317 .79493 .55668 .81641 .53679 .80737 .53133 Metetra
.864 .927 .867 r
.80737 .53133 .81641 .53679 .83796 .51771 .82897 .51042 Metetra
.84 .898 .879 r
.82897 .51042 .83796 .51771 .85969 .50031 .85074 .49145 Metetra
.808 .868 .892 r
.85074 .49145 .85969 .50031 .88168 .48498 .87278 .47485 Metetra
.774 .84 .902 r
.87278 .47485 .88168 .48498 .90396 .4717 .89514 .4606 Metetra
.742 .815 .909 r
.89514 .4606 .90396 .4717 .92656 .46023 .91782 .4484 Metetra
.74 .757 .866 r
.29924 .603 .31122 .61407 .33027 .60349 .31841 .59201 Metetra
.761 .755 .846 r
.31841 .59201 .33027 .60349 .3495 .59089 .33776 .57888 Metetra
.78 .75 .825 r
.33776 .57888 .3495 .59089 .36889 .57603 .3573 .56335 Metetra
.795 .744 .806 r
.3573 .56335 .36889 .57603 .38841 .55895 .37696 .54546 Metetra
.802 .736 .79 r
.37696 .54546 .38841 .55895 .408 .5401 .39669 .52568 Metetra
.803 .727 .781 r
.39669 .52568 .408 .5401 .4276 .52043 .41644 .50505 Metetra
.793 .717 .779 r
.41644 .50505 .4276 .52043 .44716 .50146 .43613 .48517 Metetra
.771 .703 .788 r
.43613 .48517 .44716 .50146 .46667 .48506 .45575 .46803 Metetra
.726 .684 .809 r
.45575 .46803 .46667 .48506 .48614 .4733 .4753 .45583 Metetra
.641 .647 .841 r
.4753 .45583 .48614 .4733 .50564 .46805 .49485 .45054 Metetra
.475 .57 .871 r
.49485 .45054 .50564 .46805 .5253 .47059 .51453 .45354 Metetra
.18 .408 .847 r
.51453 .45354 .5253 .47059 .54525 .48131 .5345 .46525 Metetra
0 .166 .702 r
.5345 .46525 .54525 .48131 .56565 .49945 .5549 .48487 Metetra
0 0 .508 r
.5549 .48487 .56565 .49945 .5866 .52302 .57587 .51031 Metetra
.609 .136 0 r
.57587 .51031 .5866 .52302 .60814 .54903 .59745 .53839 Metetra
.633 .135 0 r
.59745 .53839 .60814 .54903 .6302 .57389 .61959 .56528 Metetra
.563 .035 0 r
.61959 .56528 .6302 .57389 .65265 .59404 .64215 .5872 Metetra
0 .205 .626 r
.64215 .5872 .65265 .59404 .67528 .60672 .66493 .60113 Metetra
.083 .584 .894 r
.66493 .60113 .67528 .60672 .69787 .61044 .68769 .60549 Metetra
.53 .858 .996 r
.68769 .60549 .69787 .61044 .72027 .60523 .71025 .60028 Metetra
.756 .927 .945 r
.71025 .60028 .72027 .60523 .74238 .59245 .73252 .58696 Metetra
.842 .921 .885 r
.73252 .58696 .74238 .59245 .7642 .57428 .75449 .56787 Metetra
.87 .904 .852 r
.75449 .56787 .7642 .57428 .78582 .55317 .77625 .54565 Metetra
.873 .886 .841 r
.77625 .54565 .78582 .55317 .80737 .53133 .7979 .52266 Metetra
.86 .87 .845 r
.7979 .52266 .80737 .53133 .82897 .51042 .81961 .50068 Metetra
.837 .854 .857 r
.81961 .50068 .82897 .51042 .85074 .49145 .84149 .48078 Metetra
.808 .837 .872 r
.84149 .48078 .85074 .49145 .87278 .47485 .86363 .46342 Metetra
.776 .819 .887 r
.86363 .46342 .87278 .47485 .89514 .4606 .88609 .44857 Metetra
.745 .802 .898 r
.88609 .44857 .89514 .4606 .91782 .4484 .90888 .43592 Metetra
.742 .767 .874 r
.28706 .59241 .29924 .603 .31841 .59201 .30633 .58138 Metetra
.766 .77 .856 r
.30633 .58138 .31841 .59201 .33776 .57888 .32579 .56822 Metetra
.788 .772 .838 r
.32579 .56822 .33776 .57888 .3573 .56335 .34544 .55268 Metetra
.807 .773 .822 r
.34544 .55268 .3573 .56335 .37696 .54546 .36523 .53478 Metetra
.82 .774 .81 r
.36523 .53478 .37696 .54546 .39669 .52568 .3851 .51502 Metetra
.826 .776 .805 r
.3851 .51502 .39669 .52568 .41644 .50505 .40498 .49442 Metetra
.823 .778 .811 r
.40498 .49442 .41644 .50505 .43613 .48517 .42481 .47454 Metetra
.804 .781 .831 r
.42481 .47454 .43613 .48517 .45575 .46803 .44456 .4574 Metetra
.757 .779 .871 r
.44456 .4574 .45575 .46803 .4753 .45583 .46422 .44516 Metetra
.641 .754 .931 r
.46422 .44516 .4753 .45583 .49485 .45054 .48387 .43978 Metetra
.369 .638 .959 r
.48387 .43978 .49485 .45054 .51453 .45354 .50362 .44263 Metetra
0 .348 .812 r
.50362 .44263 .51453 .45354 .5345 .46525 .52362 .45413 Metetra
0 .045 .55 r
.52362 .45413 .5345 .46525 .5549 .48487 .54404 .47348 Metetra
.606 .114 0 r
.54404 .47348 .5549 .48487 .57587 .51031 .56501 .49862 Metetra
.64 .154 0 r
.56501 .49862 .57587 .51031 .59745 .53839 .58658 .52637 Metetra
.583 .099 0 r
.58658 .52637 .59745 .53839 .61959 .56528 .60872 .55294 Metetra
0 .069 .589 r
.60872 .55294 .61959 .56528 .64215 .5872 .6313 .57455 Metetra
0 .352 .823 r
.6313 .57455 .64215 .5872 .66493 .60113 .65412 .58825 Metetra
.367 .611 .944 r
.65412 .58825 .66493 .60113 .68769 .60549 .67696 .59243 Metetra
.625 .733 .925 r
.67696 .59243 .68769 .60549 .71025 .60028 .69963 .58712 Metetra
.749 .775 .874 r
.69963 .58712 .71025 .60028 .73252 .58696 .72204 .57375 Metetra
.806 .788 .836 r
.72204 .57375 .73252 .58696 .75449 .56787 .74417 .55465 Metetra
.831 .794 .816 r
.74417 .55465 .75449 .56787 .77625 .54565 .7661 .53244 Metetra
.838 .797 .812 r
.7661 .53244 .77625 .54565 .7979 .52266 .78793 .50947 Metetra
.832 .798 .819 r
.78793 .50947 .7979 .52266 .81961 .50068 .80982 .48749 Metetra
.817 .798 .834 r
.80982 .48749 .81961 .50068 .84149 .48078 .83187 .46759 Metetra
.794 .795 .853 r
.83187 .46759 .84149 .48078 .86363 .46342 .85417 .4502 Metetra
.768 .79 .871 r
.85417 .4502 .86363 .46342 .88609 .44857 .87679 .4353 Metetra
.74 .783 .887 r
.87679 .4353 .88609 .44857 .90888 .43592 .89974 .42258 Metetra
.738 .779 .886 r
.27467 .58241 .28706 .59241 .30633 .58138 .294 .57178 Metetra
.764 .789 .874 r
.294 .57178 .30633 .58138 .32579 .56822 .31355 .5592 Metetra
.79 .801 .861 r
.31355 .5592 .32579 .56822 .34544 .55268 .33328 .54444 Metetra
.814 .814 .85 r
.33328 .54444 .34544 .55268 .36523 .53478 .35316 .52754 Metetra
.834 .83 .844 r
.35316 .52754 .36523 .53478 .3851 .51502 .37313 .50892 Metetra
.847 .85 .845 r
.37313 .50892 .3851 .51502 .40498 .49442 .39313 .48951 Metetra
.849 .875 .86 r
.39313 .48951 .40498 .49442 .42481 .47454 .4131 .47076 Metetra
.829 .907 .893 r
.4131 .47076 .42481 .47454 .44456 .4574 .43299 .45449 Metetra
.752 .933 .947 r
.43299 .45449 .44456 .4574 .46422 .44516 .45281 .44269 Metetra
.516 .883 .977 r
.45281 .44269 .46422 .44516 .48387 .43978 .4726 .43715 Metetra
.026 .585 .811 r
.4726 .43715 .48387 .43978 .50362 .44263 .49248 .43912 Metetra
.407 0 0 r
.49248 .43912 .50362 .44263 .52362 .45413 .51257 .44898 Metetra
.603 .04 0 r
.51257 .44898 .52362 .45413 .54404 .47348 .53304 .46597 Metetra
.657 .125 0 r
.53304 .46597 .54404 .47348 .56501 .49862 .55401 .48818 Metetra
.61 .104 0 r
.55401 .48818 .56501 .49862 .58658 .52637 .57554 .51272 Metetra
0 .025 .558 r
.57554 .51272 .58658 .52637 .60872 .55294 .5976 .53612 Metetra
0 .242 .757 r
.5976 .53612 .60872 .55294 .6313 .57455 .6201 .55499 Metetra
.256 .44 .851 r
.6201 .55499 .6313 .57455 .65412 .58825 .64286 .56665 Metetra
.493 .555 .848 r
.64286 .56665 .65412 .58825 .67696 .59243 .66568 .56969 Metetra
.627 .615 .819 r
.66568 .56969 .67696 .59243 .69963 .58712 .6884 .56414 Metetra
.704 .65 .793 r
.6884 .56414 .69963 .58712 .72204 .57375 .71091 .55131 Metetra
.748 .674 .779 r
.71091 .55131 .72204 .57375 .74417 .55465 .73321 .53329 Metetra
.774 .694 .775 r
.73321 .53329 .74417 .55465 .7661 .53244 .75535 .51244 Metetra
.787 .711 .78 r
.75535 .51244 .7661 .53244 .78793 .50947 .77742 .49089 Metetra
.789 .726 .793 r
.77742 .49089 .78793 .50947 .80982 .48749 .79955 .47021 Metetra
.783 .739 .812 r
.79955 .47021 .80982 .48749 .83187 .46759 .82185 .4514 Metetra
.769 .749 .835 r
.82185 .4514 .83187 .46759 .85417 .4502 .84439 .43486 Metetra
.75 .756 .857 r
.84439 .43486 .85417 .4502 .87679 .4353 .86722 .42057 Metetra
.729 .759 .876 r
.86722 .42057 .87679 .4353 .89974 .42258 .89037 .40825 Metetra
.727 .792 .904 r
.26204 .57305 .27467 .58241 .294 .57178 .28142 .56326 Metetra
.752 .811 .899 r
.28142 .56326 .294 .57178 .31355 .5592 .301 .55189 Metetra
.779 .835 .895 r
.301 .55189 .31355 .5592 .33328 .54444 .32077 .53876 Metetra
.806 .865 .892 r
.32077 .53876 .33328 .54444 .35316 .52754 .34069 .52387 Metetra
.827 .902 .892 r
.34069 .52387 .35316 .52754 .37313 .50892 .36072 .50758 Metetra
.835 .945 .894 r
.36072 .50758 .37313 .50892 .39313 .48951 .38081 .49063 Metetra
.808 .984 .89 r
.38081 .49063 .39313 .48951 .4131 .47076 .4009 .47418 Metetra
.695 .982 .85 r
.4009 .47418 .4131 .47076 .43299 .45449 .42094 .45972 Metetra
.42 .848 .71 r
.42094 .45972 .43299 .45449 .45281 .44269 .44095 .44887 Metetra
.44095 .44887 .45281 .44269 .4726 .43715 .46094 .4431 Metetra
.296 0 0 r
.46094 .4431 .4726 .43715 .49248 .43912 .48101 .44342 Metetra
.495 0 0 r
.48101 .44342 .49248 .43912 .51257 .44898 .50128 .4501 Metetra
.601 .043 0 r
.50128 .4501 .51257 .44898 .53304 .46597 .52185 .46251 Metetra
.618 .052 0 r
.52185 .46251 .53304 .46597 .55401 .48818 .54285 .47907 Metetra
.477 0 0 r
.54285 .47907 .55401 .48818 .57554 .51272 .56433 .4974 Metetra
0 .248 .759 r
.56433 .4974 .57554 .51272 .5976 .53612 .58628 .51472 Metetra
.223 .396 .825 r
.58628 .51472 .5976 .53612 .6201 .55499 .60862 .52833 Metetra
.43 .473 .803 r
.60862 .52833 .6201 .55499 .64286 .56665 .63122 .53614 Metetra
.547 .516 .773 r
.63122 .53614 .64286 .56665 .66568 .56969 .65393 .53707 Metetra
.618 .546 .752 r
.65393 .53707 .66568 .56969 .6884 .56414 .67662 .53116 Metetra
.665 .571 .74 r
.67662 .53116 .6884 .56414 .71091 .55131 .69921 .51945 Metetra
.697 .594 .737 r
.69921 .51945 .71091 .55131 .73321 .53329 .72167 .5036 Metetra
.719 .617 .742 r
.72167 .5036 .73321 .53329 .75535 .51244 .74404 .48548 Metetra
.734 .639 .754 r
.74404 .48548 .75535 .51244 .77742 .49089 .7664 .46676 Metetra
.742 .662 .772 r
.7664 .46676 .77742 .49089 .79955 .47021 .78884 .44872 Metetra
.743 .684 .795 r
.78884 .44872 .79955 .47021 .82185 .4514 .81145 .43214 Metetra
.737 .704 .82 r
.81145 .43214 .82185 .4514 .84439 .43486 .83428 .41735 Metetra
.726 .721 .846 r
.83428 .41735 .84439 .43486 .86722 .42057 .85738 .40434 Metetra
.712 .734 .868 r
.85738 .40434 .86722 .42057 .89037 .40825 .88077 .3929 Metetra
.705 .802 .925 r
.24917 .56423 .26204 .57305 .28142 .56326 .26856 .55568 Metetra
.724 .83 .93 r
.26856 .55568 .28142 .56326 .301 .55189 .28814 .54609 Metetra
.744 .868 .937 r
.28814 .54609 .301 .55189 .32077 .53876 .30789 .53533 Metetra
.759 .916 .943 r
.30789 .53533 .32077 .53876 .34069 .52387 .3278 .5234 Metetra
.751 .965 .934 r
.3278 .5234 .34069 .52387 .36072 .50758 .34784 .51052 Metetra
.68 .978 .874 r
.34784 .51052 .36072 .50758 .38081 .49063 .36797 .49717 Metetra
.49 .881 .704 r
.36797 .49717 .38081 .49063 .4009 .47418 .38814 .48413 Metetra
.38814 .48413 .4009 .47418 .42094 .45972 .40835 .47236 Metetra
.056 0 0 r
.40835 .47236 .42094 .45972 .44095 .44887 .42856 .46295 Metetra
.24 0 0 r
.42856 .46295 .44095 .44887 .46094 .4431 .44882 .45687 Metetra
.364 0 .018 r
.44882 .45687 .46094 .4431 .48101 .44342 .46916 .45479 Metetra
.447 0 .017 r
.46916 .45479 .48101 .44342 .50128 .4501 .48967 .45688 Metetra
.493 0 0 r
.48967 .45688 .50128 .4501 .52185 .46251 .51043 .46267 Metetra
.451 0 0 r
.51043 .46267 .52185 .46251 .54285 .47907 .53151 .47109 Metetra
0 .386 .794 r
.53151 .47109 .54285 .47907 .56433 .4974 .55297 .48058 Metetra
.269 .489 .885 r
.55297 .48058 .56433 .4974 .58628 .51472 .57479 .4893 Metetra
.446 .491 .813 r
.57479 .4893 .58628 .51472 .60862 .52833 .59694 .49555 Metetra
.528 .492 .759 r
.59694 .49555 .60862 .52833 .63122 .53614 .61932 .49801 Metetra
.577 .498 .729 r
.61932 .49801 .63122 .53614 .65393 .53707 .64186 .49603 Metetra
.61 .509 .714 r
.64186 .49603 .65393 .53707 .67662 .53116 .66446 .48965 Metetra
.636 .523 .709 r
.66446 .48965 .67662 .53116 .69921 .51945 .68707 .47955 Metetra
.656 .54 .711 r
.68707 .47955 .69921 .51945 .72167 .5036 .70967 .46678 Metetra
.672 .561 .72 r
.70967 .46678 .72167 .5036 .74404 .48548 .73229 .45251 Metetra
.685 .584 .736 r
.73229 .45251 .74404 .48548 .7664 .46676 .75496 .43782 Metetra
.695 .61 .757 r
.75496 .43782 .7664 .46676 .78884 .44872 .77775 .42353 Metetra
.7 .637 .783 r
.77775 .42353 .78884 .44872 .81145 .43214 .80071 .41015 Metetra
.7 .664 .811 r
.80071 .41015 .81145 .43214 .83428 .41735 .82388 .39789 Metetra
.697 .689 .839 r
.82388 .39789 .83428 .41735 .85738 .40434 .84729 .38676 Metetra
.69 .71 .863 r
.84729 .38676 .85738 .40434 .88077 .3929 .87095 .37662 Metetra
.671 .806 .947 r
.23607 .55573 .24917 .56423 .26856 .55568 .25544 .54872 Metetra
.673 .838 .963 r
.25544 .54872 .26856 .55568 .28814 .54609 .27497 .54131 Metetra
.666 .882 .978 r
.27497 .54131 .28814 .54609 .30789 .53533 .29466 .53345 Metetra
.63 .926 .973 r
.29466 .53345 .30789 .53533 .3278 .5234 .31451 .52516 Metetra
.513 .914 .885 r
.31451 .52516 .3278 .5234 .34784 .51052 .33449 .51649 Metetra
.33449 .51649 .34784 .51052 .36797 .49717 .35461 .50763 Metetra
.35461 .50763 .36797 .49717 .38814 .48413 .37484 .49883 Metetra
.153 0 0 r
.37484 .49883 .38814 .48413 .40835 .47236 .39518 .49045 Metetra
.259 0 .027 r
.39518 .49045 .40835 .47236 .42856 .46295 .41562 .48286 Metetra
.32 0 .092 r
.41562 .48286 .42856 .46295 .44882 .45687 .43618 .47642 Metetra
.351 0 .104 r
.43618 .47642 .44882 .45687 .46916 .45479 .45686 .47137 Metetra
.352 0 .056 r
.45686 .47137 .46916 .45479 .48967 .45688 .4777 .46774 Metetra
.298 0 0 r
.4777 .46774 .48967 .45688 .51043 .46267 .49873 .46538 Metetra
.054 0 0 r
.49873 .46538 .51043 .46267 .53151 .47109 .51998 .46387 Metetra
.424 .763 .996 r
.51998 .46387 .53151 .47109 .55297 .48058 .54147 .46266 Metetra
.56 .632 .88 r
.54147 .46266 .55297 .48058 .57479 .4893 .5632 .46113 Metetra
.583 .549 .782 r
.5632 .46113 .57479 .4893 .59694 .49555 .58515 .45867 Metetra
.592 .511 .732 r
.58515 .45867 .59694 .49555 .61932 .49801 .60731 .45486 Metetra
.6 .495 .706 r
.60731 .45486 .61932 .49801 .64186 .49603 .62964 .4495 Metetra
.607 .491 .695 r
.62964 .4495 .64186 .49603 .66446 .48965 .65211 .4426 Metetra
.615 .494 .692 r
.65211 .4426 .66446 .48965 .68707 .47955 .6747 .43439 Metetra
.623 .505 .698 r
.6747 .43439 .68707 .47955 .70967 .46678 .69742 .42523 Metetra
.632 .521 .71 r
.69742 .42523 .70967 .46678 .73229 .45251 .72027 .41551 Metetra
.641 .542 .727 r
.72027 .41551 .73229 .45251 .75496 .43782 .74325 .40561 Metetra
.649 .569 .751 r
.74325 .40561 .75496 .43782 .77775 .42353 .7664 .39579 Metetra
.656 .599 .778 r
.7664 .39579 .77775 .42353 .80071 .41015 .78973 .38625 Metetra
.662 .631 .808 r
.78973 .38625 .80071 .41015 .82388 .39789 .81326 .37704 Metetra
.665 .662 .837 r
.81326 .37704 .82388 .39789 .84729 .38676 .837 .36818 Metetra
.666 .689 .863 r
.837 .36818 .84729 .38676 .87095 .37662 .86096 .35962 Metetra
.625 .799 .966 r
.22276 .54727 .23607 .55573 .25544 .54872 .24209 .5419 Metetra
.598 .827 .987 r
.24209 .5419 .25544 .54872 .27497 .54131 .26155 .53683 Metetra
.538 .856 .997 r
.26155 .53683 .27497 .54131 .29466 .53345 .28114 .53212 Metetra
.4 .841 .938 r
.28114 .53212 .29466 .53345 .31451 .52516 .30087 .52776 Metetra
.153 .691 .706 r
.30087 .52776 .31451 .52516 .33449 .51649 .32075 .52369 Metetra
.096 0 0 r
.32075 .52369 .33449 .51649 .35461 .50763 .34081 .51973 Metetra
.246 0 0 r
.34081 .51973 .35461 .50763 .37484 .49883 .36105 .51561 Metetra
.316 0 .028 r
.36105 .51561 .37484 .49883 .39518 .49045 .3815 .51098 Metetra
.34 0 .102 r
.3815 .51098 .39518 .49045 .41562 .48286 .40217 .50542 Metetra
.333 0 .125 r
.40217 .50542 .41562 .48286 .43618 .47642 .42305 .49859 Metetra
.295 0 .1 r
.42305 .49859 .43618 .47642 .45686 .47137 .44412 .49025 Metetra
.204 0 .002 r
.44412 .49025 .45686 .47137 .4777 .46774 .46536 .48034 Metetra
.46536 .48034 .4777 .46774 .49873 .46538 .48675 .46906 Metetra
.521 .913 .794 r
.48675 .46906 .49873 .46538 .51998 .46387 .50825 .45684 Metetra
.756 .878 .934 r
.50825 .45684 .51998 .46387 .54147 .46266 .52984 .44423 Metetra
.717 .694 .827 r
.52984 .44423 .54147 .46266 .5632 .46113 .55154 .43189 Metetra
.672 .591 .756 r
.55154 .43189 .5632 .46113 .58515 .45867 .57335 .42039 Metetra
.641 .535 .717 r
.57335 .42039 .58515 .45867 .60731 .45486 .5953 .41012 Metetra
.621 .503 .697 r
.5953 .41012 .60731 .45486 .62964 .4495 .61743 .40129 Metetra
.608 .486 .688 r
.61743 .40129 .62964 .4495 .65211 .4426 .63976 .39385 Metetra
.599 .48 .688 r
.63976 .39385 .65211 .4426 .6747 .43439 .66232 .38758 Metetra
.595 .482 .695 r
.66232 .38758 .6747 .43439 .69742 .42523 .68512 .38213 Metetra
.595 .493 .709 r
.68512 .38213 .69742 .42523 .72027 .41551 .70816 .37712 Metetra
.598 .512 .728 r
.70816 .37712 .72027 .41551 .74325 .40561 .73143 .37218 Metetra
.604 .538 .753 r
.73143 .37218 .74325 .40561 .7664 .39579 .75492 .36705 Metetra
.613 .57 .782 r
.75492 .36705 .7664 .39579 .78973 .38625 .77861 .36153 Metetra
.623 .606 .813 r
.77861 .36153 .78973 .38625 .81326 .37704 .80249 .35555 Metetra
.632 .642 .842 r
.80249 .35555 .81326 .37704 .837 .36818 .82656 .3491 Metetra
.64 .674 .867 r
.82656 .3491 .837 .36818 .86096 .35962 .8508 .34223 Metetra
.575 .783 .977 r
.20925 .53851 .22276 .54727 .24209 .5419 .22853 .5347 Metetra
.511 .794 .997 r
.22853 .5347 .24209 .5419 .26155 .53683 .2479 .53187 Metetra
.385 .784 .986 r
.2479 .53187 .26155 .53683 .28114 .53212 .26738 .53018 Metetra
.155 .687 .855 r
.26738 .53018 .28114 .53212 .30087 .52776 .28697 .52961 Metetra
.123 0 0 r
.28697 .52961 .30087 .52776 .32075 .52369 .30672 .52999 Metetra
.307 0 0 r
.30672 .52999 .32075 .52369 .34081 .51973 .32668 .53081 Metetra
.384 0 0 r
.32668 .53081 .34081 .51973 .36105 .51561 .34691 .53127 Metetra
.396 0 .051 r
.34691 .53127 .36105 .51561 .3815 .51098 .36744 .53032 Metetra
.369 0 .092 r
.36744 .53032 .3815 .51098 .40217 .50542 .38831 .52678 Metetra
.303 0 .082 r
.38831 .52678 .40217 .50542 .42305 .49859 .40951 .51956 Metetra
.18 0 .01 r
.40951 .51956 .42305 .49859 .44412 .49025 .431 .50796 Metetra
.431 .50796 .44412 .49025 .46536 .48034 .45268 .49187 Metetra
.481 .819 .525 r
.45268 .49187 .46536 .48034 .48675 .46906 .47448 .47191 Metetra
.846 .997 .822 r
.47448 .47191 .48675 .46906 .50825 .45684 .4963 .44935 Metetra
.869 .863 .832 r
.4963 .44935 .50825 .45684 .52984 .44423 .51809 .42592 Metetra
.8 .723 .779 r
.51809 .42592 .52984 .44423 .55154 .43189 .53983 .40344 Metetra
.736 .628 .739 r
.53983 .40344 .55154 .43189 .57335 .42039 .56157 .38353 Metetra
.685 .565 .713 r
.56157 .38353 .57335 .42039 .5953 .41012 .58338 .36732 Metetra
.644 .522 .699 r
.58338 .36732 .5953 .41012 .61743 .40129 .60535 .35531 Metetra
.612 .494 .694 r
.60535 .35531 .61743 .40129 .63976 .39385 .62756 .34738 Metetra
.587 .477 .696 r
.62756 .34738 .63976 .39385 .66232 .38758 .65007 .34287 Metetra
.569 .471 .704 r
.65007 .34287 .66232 .38758 .68512 .38213 .67293 .34081 Metetra
.558 .476 .719 r
.67293 .34081 .68512 .38213 .70816 .37712 .69613 .34011 Metetra
.555 .492 .74 r
.69613 .34011 .70816 .37712 .73143 .37218 .71964 .33976 Metetra
.558 .517 .766 r
.71964 .33976 .73143 .37218 .75492 .36705 .74343 .33896 Metetra
.568 .551 .795 r
.74343 .33896 .75492 .36705 .77861 .36153 .76744 .3372 Metetra
.582 .59 .826 r
.76744 .3372 .77861 .36153 .80249 .35555 .79164 .33424 Metetra
.598 .629 .853 r
.79164 .33424 .80249 .35555 .82656 .3491 .81601 .33006 Metetra
.614 .665 .876 r
.81601 .33006 .82656 .3491 .8508 .34223 .84053 .32477 Metetra
.531 .759 .98 r
.19558 .52914 .20925 .53851 .22853 .5347 .21482 .52664 Metetra
.436 .749 .994 r
.21482 .52664 .22853 .5347 .2479 .53187 .23411 .52569 Metetra
.264 .7 .963 r
.23411 .52569 .2479 .53187 .26738 .53018 .25348 .52652 Metetra
0 .56 .808 r
.25348 .52652 .26738 .53018 .28697 .52961 .27294 .52918 Metetra
.263 0 0 r
.27294 .52918 .28697 .52961 .30672 .52999 .29255 .53333 Metetra
.41 0 0 r
.29255 .53333 .30672 .52999 .32668 .53081 .31241 .53824 Metetra
.454 0 0 r
.31241 .53824 .32668 .53081 .34691 .53127 .33259 .54265 Metetra
.432 0 0 r
.33259 .54265 .34691 .53127 .36744 .53032 .35318 .54489 Metetra
.353 0 0 r
.35318 .54489 .36744 .53032 .38831 .52678 .37423 .54308 Metetra
.202 0 0 r
.37423 .54308 .38831 .52678 .40951 .51956 .39572 .53551 Metetra
.39572 .53551 .40951 .51956 .431 .50796 .4176 .52107 Metetra
.4176 .52107 .431 .50796 .45268 .49187 .43973 .49962 Metetra
.836 .989 .724 r
.43973 .49962 .45268 .49187 .47448 .47191 .46196 .47218 Metetra
.932 .94 .779 r
.46196 .47218 .47448 .47191 .4963 .44935 .48415 .44083 Metetra
.904 .833 .766 r
.48415 .44083 .4963 .44935 .51809 .42592 .50619 .40828 Metetra
.846 .739 .745 r
.50619 .40828 .51809 .42592 .53983 .40344 .52807 .37737 Metetra
.785 .663 .729 r
.52807 .37737 .53983 .40344 .56157 .38353 .54983 .35055 Metetra
.726 .602 .718 r
.54983 .35055 .56157 .38353 .58338 .36732 .57158 .32949 Metetra
.671 .553 .713 r
.57158 .32949 .58338 .36732 .60535 .35531 .59345 .31489 Metetra
.621 .515 .712 r
.59345 .31489 .60535 .35531 .62756 .34738 .61558 .30653 Metetra
.578 .488 .717 r
.61558 .30653 .62756 .34738 .65007 .34287 .63807 .30342 Metetra
.543 .473 .727 r
.63807 .30342 .65007 .34287 .67293 .34081 .66097 .30409 Metetra
.519 .47 .742 r
.66097 .30409 .67293 .34081 .69613 .34011 .68429 .30688 Metetra
.507 .482 .764 r
.68429 .30688 .69613 .34011 .71964 .33976 .70799 .31026 Metetra
.507 .506 .79 r
.70799 .31026 .71964 .33976 .74343 .33896 .73201 .31302 Metetra
.52 .542 .819 r
.73201 .31302 .74343 .33896 .76744 .3372 .75629 .31435 Metetra
.54 .583 .847 r
.75629 .31435 .76744 .3372 .79164 .33424 .78077 .31387 Metetra
.565 .625 .871 r
.78077 .31387 .79164 .33424 .81601 .33006 .8054 .31155 Metetra
.589 .663 .889 r
.8054 .31155 .81601 .33006 .84053 .32477 .83017 .30756 Metetra
.503 .735 .977 r
.18177 .51895 .19558 .52914 .21482 .52664 .20099 .51735 Metetra
.393 .708 .985 r
.20099 .51735 .21482 .52664 .23411 .52569 .22023 .51771 Metetra
.212 .639 .952 r
.22023 .51771 .23411 .52569 .25348 .52652 .23952 .52035 Metetra
0 .499 .824 r
.23952 .52035 .25348 .52652 .27294 .52918 .25888 .52529 Metetra
.282 0 0 r
.25888 .52529 .27294 .52918 .29255 .53333 .27839 .53216 Metetra
.424 0 0 r
.27839 .53216 .29255 .53333 .31241 .53824 .29815 .54001 Metetra
.461 0 0 r
.29815 .54001 .31241 .53824 .33259 .54265 .31829 .54728 Metetra
.407 0 0 r
.31829 .54728 .33259 .54265 .35318 .54489 .33892 .55182 Metetra
.245 0 0 r
.33892 .55182 .35318 .54489 .37423 .54308 .3601 .55126 Metetra
.3601 .55126 .37423 .54308 .39572 .53551 .38185 .5434 Metetra
.543 .9 .691 r
.38185 .5434 .39572 .53551 .4176 .52107 .40407 .52684 Metetra
.846 .998 .778 r
.40407 .52684 .4176 .52107 .43973 .49962 .42661 .50144 Metetra
.936 .947 .768 r
.42661 .50144 .43973 .49962 .46196 .47218 .44925 .46855 Metetra
.939 .874 .745 r
.44925 .46855 .46196 .47218 .48415 .44083 .47181 .43083 Metetra
.913 .809 .731 r
.47181 .43083 .48415 .44083 .50619 .40828 .49414 .39174 Metetra
.874 .752 .725 r
.49414 .39174 .50619 .40828 .52807 .37737 .51621 .35484 Metetra
.825 .7 .726 r
.51621 .35484 .52807 .37737 .54983 .35055 .53808 .32314 Metetra
.768 .65 .731 r
.53808 .32314 .54983 .35055 .57158 .32949 .55986 .29867 Metetra
.704 .601 .739 r
.55986 .29867 .57158 .32949 .59345 .31489 .58172 .28224 Metetra
.636 .556 .747 r
.58172 .28224 .59345 .31489 .61558 .30653 .60384 .27356 Metetra
.57 .517 .757 r
.60384 .27356 .61558 .30653 .63807 .30342 .62633 .27138 Metetra
.512 .49 .769 r
.62633 .27138 .63807 .30342 .66097 .30409 .64927 .2739 Metetra
.47 .478 .784 r
.64927 .2739 .66097 .30409 .68429 .30688 .67268 .27908 Metetra
.448 .484 .804 r
.67268 .27908 .68429 .30688 .70799 .31026 .69653 .28504 Metetra
.448 .507 .827 r
.69653 .28504 .70799 .31026 .73201 .31302 .72073 .29025 Metetra
.467 .544 .852 r
.72073 .29025 .73201 .31302 .75629 .31435 .74521 .29372 Metetra
.498 .588 .875 r
.74521 .29372 .75629 .31435 .78077 .31387 .7699 .29497 Metetra
.534 .631 .893 r
.7699 .29497 .78077 .31387 .8054 .31155 .79475 .29393 Metetra
.568 .668 .905 r
.79475 .29393 .8054 .31155 .83017 .30756 .81973 .29082 Metetra
.494 .716 .97 r
.16783 .5078 .18177 .51895 .20099 .51735 .18707 .50664 Metetra
.388 .68 .976 r
.18707 .50664 .20099 .51735 .22023 .51771 .20631 .50767 Metetra
.226 .609 .953 r
.20631 .50767 .22023 .51771 .23952 .52035 .22556 .51122 Metetra
.017 .495 .874 r
.22556 .51122 .23952 .52035 .25888 .52529 .24487 .51735 Metetra
0 .361 .746 r
.24487 .51735 .25888 .52529 .27839 .53216 .26433 .52564 Metetra
.312 0 0 r
.26433 .52564 .27839 .53216 .29815 .54001 .28405 .53504 Metetra
.331 0 0 r
.28405 .53504 .29815 .54001 .31829 .54728 .30417 .5438 Metetra
.21 0 0 r
.30417 .5438 .31829 .54728 .33892 .55182 .32483 .54956 Metetra
.111 .655 .835 r
.32483 .54956 .33892 .55182 .3601 .55126 .34612 .54962 Metetra
.552 .912 .96 r
.34612 .54962 .3601 .55126 .38185 .5434 .36806 .54156 Metetra
.815 .959 .906 r
.36806 .54156 .38185 .5434 .40407 .52684 .39055 .5238 Metetra
.903 .912 .818 r
.39055 .5238 .40407 .52684 .42661 .50144 .4134 .4962 Metetra
.925 .861 .758 r
.4134 .4962 .42661 .50144 .44925 .46855 .43639 .46031 Metetra
.924 .822 .727 r
.43639 .46031 .44925 .46855 .47181 .43083 .45928 .41912 Metetra
.912 .791 .714 r
.45928 .41912 .47181 .43083 .49414 .39174 .48191 .37649 Metetra
.89 .764 .716 r
.48191 .37649 .49414 .39174 .51621 .35484 .50422 .33636 Metetra
.857 .737 .73 r
.50422 .33636 .51621 .35484 .53808 .32314 .52626 .30204 Metetra
.81 .708 .752 r
.52626 .30204 .53808 .32314 .55986 .29867 .54815 .27572 Metetra
.744 .671 .779 r
.54815 .27572 .55986 .29867 .58172 .28224 .57009 .25829 Metetra
.658 .625 .806 r
.57009 .25829 .58172 .28224 .60384 .27356 .59225 .24938 Metetra
.56 .575 .825 r
.59225 .24938 .60384 .27356 .62633 .27138 .61479 .24763 Metetra
.468 .53 .838 r
.61479 .24763 .62633 .27138 .64927 .2739 .63779 .25106 Metetra
.4 .502 .847 r
.63779 .25106 .64927 .2739 .67268 .27908 .66128 .25745 Metetra
.369 .499 .859 r
.66128 .25745 .67268 .27908 .69653 .28504 .68523 .2647 Metetra
.376 .52 .874 r
.68523 .2647 .69653 .28504 .72073 .29025 .70956 .27115 Metetra
.409 .559 .892 r
.70956 .27115 .72073 .29025 .74521 .29372 .73418 .27569 Metetra
.458 .603 .907 r
.73418 .27569 .74521 .29372 .7699 .29497 .75904 .27779 Metetra
.508 .645 .917 r
.75904 .27779 .7699 .29497 .79475 .29393 .78405 .27736 Metetra
.553 .679 .922 r
.78405 .27736 .79475 .29393 .81973 .29082 .8092 .27467 Metetra
.501 .704 .961 r
.15377 .49571 .16783 .5078 .18707 .50664 .17307 .49453 Metetra
.41 .666 .965 r
.17307 .49453 .18707 .50664 .20631 .50767 .19235 .49557 Metetra
.282 .603 .952 r
.19235 .49557 .20631 .50767 .22556 .51122 .21164 .49917 Metetra
.129 .516 .913 r
.21164 .49917 .22556 .51122 .24487 .51735 .23097 .50539 Metetra
0 .428 .858 r
.23097 .50539 .24487 .51735 .26433 .52564 .25044 .51379 Metetra
0 .382 .823 r
.25044 .51379 .26433 .52564 .28405 .53504 .27017 .52333 Metetra
0 .416 .846 r
.27017 .52333 .28405 .53504 .30417 .5438 .29032 .53223 Metetra
.149 .542 .924 r
.29032 .53223 .30417 .5438 .32483 .54956 .31103 .53807 Metetra
.431 .699 .977 r
.31103 .53807 .32483 .54956 .34612 .54962 .3324 .53814 Metetra
.669 .789 .938 r
.3324 .53814 .34612 .54962 .36806 .54156 .35446 .52995 Metetra
.8 .808 .858 r
.35446 .52995 .36806 .54156 .39055 .5238 .37712 .51192 Metetra
.862 .801 .789 r
.37712 .51192 .39055 .5238 .4134 .4962 .40019 .48392 Metetra
.89 .791 .744 r
.40019 .48392 .4134 .4962 .43639 .46031 .42343 .4475 Metetra
.902 .783 .719 r
.42343 .4475 .43639 .46031 .45928 .41912 .44659 .40572 Metetra
.905 .778 .711 r
.44659 .40572 .45928 .41912 .48191 .37649 .46949 .3625 Metetra
.899 .776 .718 r
.46949 .3625 .48191 .37649 .50422 .33636 .49205 .32182 Metetra
.882 .776 .741 r
.49205 .32182 .50422 .33636 .52626 .30204 .5143 .28704 Metetra
.848 .774 .78 r
.5143 .28704 .52626 .30204 .54815 .27572 .53637 .26037 Metetra
.785 .763 .834 r
.53637 .26037 .54815 .27572 .57009 .25829 .55845 .24269 Metetra
.68 .731 .889 r
.55845 .24269 .57009 .25829 .59225 .24938 .58073 .23365 Metetra
.536 .67 .924 r
.58073 .23365 .59225 .24938 .61479 .24763 .60336 .23186 Metetra
.39 .595 .927 r
.60336 .23186 .61479 .24763 .63779 .25106 .62644 .23531 Metetra
.294 .541 .916 r
.62644 .23531 .63779 .25106 .66128 .25745 .65001 .24176 Metetra
.265 .525 .912 r
.65001 .24176 .66128 .25745 .68523 .2647 .67403 .24908 Metetra
.293 .545 .919 r
.67403 .24908 .68523 .2647 .70956 .27115 .69846 .25559 Metetra
.354 .585 .93 r
.69846 .25559 .70956 .27115 .73418 .27569 .72319 .26017 Metetra
.425 .628 .938 r
.72319 .26017 .73418 .27569 .75904 .27779 .74816 .26227 Metetra
.491 .666 .94 r
.74816 .26227 .75904 .27779 .78405 .27736 .7733 .26182 Metetra
.545 .695 .938 r
.7733 .26182 .78405 .27736 .8092 .27467 .79859 .25907 Metetra
.519 .7 .952 r
.13959 .48279 .15377 .49571 .17307 .49453 .15898 .4812 Metetra
.446 .663 .954 r
.15898 .4812 .17307 .49453 .19235 .49557 .17836 .48171 Metetra
.352 .61 .946 r
.17836 .48171 .19235 .49557 .21164 .49917 .19774 .48462 Metetra
.25 .543 .925 r
.19774 .48462 .21164 .49917 .23097 .50539 .21717 .48998 Metetra
.17 .483 .899 r
.21717 .48998 .23097 .50539 .25044 .51379 .23672 .4974 Metetra
.15 .455 .884 r
.23672 .4974 .25044 .51379 .27017 .52333 .25654 .50587 Metetra
.213 .477 .889 r
.25654 .50587 .27017 .52333 .29032 .53223 .27675 .51372 Metetra
.352 .541 .9 r
.27675 .51372 .29032 .53223 .31103 .53807 .29753 .51869 Metetra
.519 .616 .889 r
.29753 .51869 .31103 .53807 .3324 .53814 .31896 .51823 Metetra
.659 .671 .851 r
.31896 .51823 .3324 .53814 .35446 .52995 .34109 .50999 Metetra
.755 .704 .804 r
.34109 .50999 .35446 .52995 .37712 .51192 .36384 .4925 Metetra
.816 .725 .764 r
.36384 .4925 .37712 .51192 .40019 .48392 .38702 .4656 Metetra
.854 .739 .736 r
.38702 .4656 .40019 .48392 .42343 .4475 .41041 .43077 Metetra
.879 .753 .72 r
.41041 .43077 .42343 .4475 .44659 .40572 .43375 .39085 Metetra
.894 .769 .717 r
.43375 .39085 .44659 .40572 .46949 .3625 .45685 .34953 Metetra
.9 .789 .728 r
.45685 .34953 .46949 .3625 .49205 .32182 .47964 .31057 Metetra
.896 .814 .758 r
.47964 .31057 .49205 .32182 .5143 .28704 .50212 .27716 Metetra
.874 .843 .812 r
.50212 .27716 .5143 .28704 .53637 .26037 .52442 .25139 Metetra
.811 .867 .889 r
.52442 .25139 .53637 .26037 .55845 .24269 .5467 .23412 Metetra
.674 .855 .969 r
.5467 .23412 .55845 .24269 .58073 .23365 .56915 .22503 Metetra
.459 .771 .997 r
.56915 .22503 .58073 .23365 .60336 .23186 .59192 .2228 Metetra
.257 .65 .964 r
.59192 .2228 .60336 .23186 .62644 .23531 .61511 .22552 Metetra
.153 .569 .931 r
.61511 .22552 .62644 .23531 .65001 .24176 .63876 .23106 Metetra
.152 .551 .927 r
.63876 .23106 .65001 .24176 .67403 .24908 .66286 .23742 Metetra
.219 .577 .942 r
.66286 .23742 .67403 .24908 .69846 .25559 .68736 .243 Metetra
.315 .62 .958 r
.68736 .243 .69846 .25559 .72319 .26017 .71217 .24674 Metetra
.41 .661 .963 r
.71217 .24674 .72319 .26017 .74816 .26227 .73722 .24814 Metetra
.488 .692 .959 r
.73722 .24814 .74816 .26227 .7733 .26182 .76247 .24711 Metetra
.546 .714 .95 r
.76247 .24711 .7733 .26182 .79859 .25907 .78787 .24391 Metetra
.542 .7 .942 r
.12527 .46922 .13959 .48279 .15898 .4812 .14478 .46695 Metetra
.487 .668 .943 r
.14478 .46695 .15898 .4812 .17836 .48171 .16429 .46651 Metetra
.419 .623 .937 r
.16429 .46651 .17836 .48171 .19774 .48462 .18382 .4682 Metetra
.352 .57 .921 r
.18382 .4682 .19774 .48462 .21717 .48998 .2034 .47204 Metetra
.305 .522 .9 r
.2034 .47204 .21717 .48998 .23672 .4974 .22311 .47768 Metetra
.302 .495 .881 r
.22311 .47768 .23672 .4974 .25654 .50587 .24307 .48423 Metetra
.352 .499 .866 r
.24307 .48423 .25654 .50587 .27675 .51372 .26341 .49022 Metetra
.443 .529 .851 r
.26341 .49022 .27675 .51372 .29753 .51869 .28427 .49364 Metetra
.548 .57 .829 r
.28427 .49364 .29753 .51869 .31896 .51823 .30576 .49225 Metetra
.644 .611 .802 r
.30576 .49225 .31896 .51823 .34109 .50999 .32792 .48402 Metetra
.721 .646 .774 r
.32792 .48402 .34109 .50999 .36384 .4925 .35067 .46762 Metetra
.779 .676 .751 r
.35067 .46762 .36384 .4925 .38702 .4656 .37387 .44292 Metetra
.822 .704 .734 r
.37387 .44292 .38702 .4656 .41041 .43077 .39731 .41117 Metetra
.855 .732 .727 r
.39731 .41117 .41041 .43077 .43375 .39085 .42074 .37487 Metetra
.879 .763 .73 r
.42074 .37487 .43375 .39085 .45685 .34953 .44399 .33725 Metetra
.896 .801 .747 r
.44399 .33725 .45685 .34953 .47964 .31057 .46698 .30165 Metetra
.9 .847 .783 r
.46698 .30165 .47964 .31057 .50212 .27716 .48969 .27093 Metetra
.879 .902 .843 r
.48969 .27093 .50212 .27716 .52442 .25139 .51223 .24698 Metetra
.797 .946 .921 r
.51223 .24698 .52442 .25139 .5467 .23412 .53475 .23061 Metetra
.601 .921 .972 r
.53475 .23061 .5467 .23412 .56915 .22503 .5574 .22152 Metetra
.327 .789 .941 r
.5574 .22152 .56915 .22503 .59192 .2228 .58035 .21854 Metetra
.121 .645 .881 r
.58035 .21854 .59192 .2228 .61511 .22552 .60368 .21998 Metetra
.049 .574 .867 r
.60368 .21998 .61511 .22552 .63876 .23106 .62744 .22391 Metetra
.087 .576 .9 r
.62744 .22391 .63876 .23106 .66286 .23742 .65162 .22855 Metetra
.19 .617 .945 r
.65162 .22855 .66286 .23742 .68736 .243 .67618 .23248 Metetra
.311 .663 .973 r
.67618 .23248 .68736 .243 .71217 .24674 .70105 .23475 Metetra
.418 .697 .979 r
.70105 .23475 .71217 .24674 .73722 .24814 .72618 .23492 Metetra
.499 .719 .97 r
.72618 .23492 .73722 .24814 .76247 .24711 .75151 .23292 Metetra
.555 .732 .957 r
.75151 .23292 .76247 .24711 .78787 .24391 .77701 .22897 Metetra
.566 .704 .935 r
.11077 .45521 .12527 .46922 .14478 .46695 .13043 .45209 Metetra
.525 .676 .934 r
.13043 .45209 .14478 .46695 .16429 .46651 .15012 .45049 Metetra
.477 .639 .927 r
.15012 .45049 .16429 .46651 .18382 .4682 .16983 .45066 Metetra
.431 .595 .913 r
.16983 .45066 .18382 .4682 .2034 .47204 .18961 .45261 Metetra
.402 .555 .892 r
.18961 .45261 .2034 .47204 .22311 .47768 .20952 .45604 Metetra
.401 .527 .869 r
.20952 .45604 .22311 .47768 .24307 .48423 .22967 .46021 Metetra
.434 .519 .846 r
.22967 .46021 .24307 .48423 .26341 .49022 .25016 .46387 Metetra
.493 .53 .824 r
.25016 .46387 .26341 .49022 .28427 .49364 .27114 .46538 Metetra
.565 .554 .801 r
.27114 .46538 .28427 .49364 .30576 .49225 .29269 .46288 Metetra
.635 .584 .78 r
.29269 .46288 .30576 .49225 .32792 .48402 .31484 .45468 Metetra
.698 .616 .761 r
.31484 .45468 .32792 .48402 .35067 .46762 .33756 .43967 Metetra
.751 .648 .747 r
.33756 .43967 .35067 .46762 .37387 .44292 .36071 .41773 Metetra
.795 .682 .74 r
.36071 .41773 .37387 .44292 .39731 .41117 .38412 .38988 Metetra
.831 .718 .74 r
.38412 .38988 .39731 .41117 .42074 .37487 .40757 .35816 Metetra
.861 .76 .75 r
.40757 .35816 .42074 .37487 .44399 .33725 .43091 .32524 Metetra
.883 .811 .773 r
.43091 .32524 .44399 .33725 .46698 .30165 .45404 .29396 Metetra
.89 .873 .814 r
.45404 .29396 .46698 .30165 .48969 .27093 .47696 .2667 Metetra
.86 .94 .871 r
.47696 .2667 .48969 .27093 .51223 .24698 .49974 .24513 Metetra
.745 .975 .924 r
.49974 .24513 .51223 .24698 .53475 .23061 .52251 .22992 Metetra
.508 .908 .913 r
.52251 .22992 .53475 .23061 .5574 .22152 .5454 .22087 Metetra
.244 .757 .842 r
.5454 .22087 .5574 .22152 .58035 .21854 .56855 .21698 Metetra
.081 .638 .798 r
.56855 .21698 .58035 .21854 .60368 .21998 .59205 .2168 Metetra
.044 .599 .821 r
.59205 .2168 .60368 .21998 .62744 .22391 .61593 .2187 Metetra
.106 .622 .887 r
.61593 .2187 .62744 .22391 .65162 .22855 .64021 .22118 Metetra
.223 .67 .952 r
.64021 .22118 .65162 .22855 .67618 .23248 .66484 .22303 Metetra
.348 .71 .985 r
.66484 .22303 .67618 .23248 .70105 .23475 .68978 .22346 Metetra
.449 .732 .987 r
.68978 .22346 .70105 .23475 .72618 .23492 .71497 .2221 Metetra
.522 .742 .975 r
.71497 .2221 .72618 .23492 .75151 .23292 .74039 .2189 Metetra
.571 .747 .96 r
.74039 .2189 .75151 .23292 .77701 .22897 .76599 .21405 Metetra
.587 .711 .928 r
.09609 .44093 .11077 .45521 .13043 .45209 .11591 .43692 Metetra
.557 .687 .926 r
.11591 .43692 .13043 .45209 .15012 .45049 .13578 .4341 Metetra
.524 .657 .919 r
.13578 .4341 .15012 .45049 .16983 .45066 .1557 .43267 Metetra
.492 .621 .906 r
.1557 .43267 .16983 .45066 .18961 .45261 .1757 .43263 Metetra
.471 .585 .887 r
.1757 .43263 .18961 .45261 .20952 .45604 .19584 .43375 Metetra
.469 .558 .863 r
.19584 .43375 .20952 .45604 .22967 .46021 .2162 .43542 Metetra
.49 .543 .838 r
.2162 .43542 .22967 .46021 .25016 .46387 .23688 .43667 Metetra
.529 .544 .814 r
.23688 .43667 .25016 .46387 .27114 .46538 .25798 .43619 Metetra
.579 .556 .793 r
.25798 .43619 .27114 .46538 .29269 .46288 .27959 .43253 Metetra
.631 .577 .775 r
.27959 .43253 .29269 .46288 .31484 .45468 .30175 .42435 Metetra
.682 .604 .762 r
.30175 .42435 .31484 .45468 .33756 .43967 .32441 .4108 Metetra
.729 .635 .753 r
.32441 .4108 .33756 .43967 .36071 .41773 .34747 .39175 Metetra
.771 .67 .752 r
.34747 .39175 .36071 .41773 .38412 .38988 .3708 .36798 Metetra
.807 .71 .758 r
.3708 .36798 .38412 .38988 .40757 .35816 .39422 .34108 Metetra
.839 .758 .774 r
.39422 .34108 .40757 .35816 .43091 .32524 .41759 .31317 Metetra
.862 .817 .803 r
.41759 .31317 .43091 .32524 .45404 .29396 .44084 .28647 Metetra
.867 .887 .847 r
.44084 .28647 .45404 .29396 .47696 .2667 .46394 .26294 Metetra
.827 .953 .899 r
.46394 .26294 .47696 .2667 .49974 .24513 .48695 .24391 Metetra
.696 .972 .925 r
.48695 .24391 .49974 .24513 .52251 .22992 .50996 .22998 Metetra
.472 .894 .887 r
.50996 .22998 .52251 .22992 .5454 .22087 .5331 .22097 Metetra
.258 .768 .824 r
.5331 .22097 .5454 .22087 .56855 .21698 .55647 .2161 Metetra
.141 .685 .805 r
.55647 .2161 .56855 .21698 .59205 .2168 .58015 .21418 Metetra
.129 .668 .846 r
.58015 .21418 .59205 .2168 .61593 .2187 .60418 .21392 Metetra
.198 .695 .916 r
.60418 .21392 .61593 .2187 .64021 .22118 .62857 .21409 Metetra
.306 .73 .973 r
.62857 .21409 .64021 .22118 .66484 .22303 .65329 .21372 Metetra
.412 .752 .994 r
.65329 .21372 .66484 .22303 .68978 .22346 .6783 .2122 Metetra
.494 .76 .99 r
.6783 .2122 .68978 .22346 .71497 .2221 .70358 .20922 Metetra
.551 .759 .974 r
.70358 .20922 .71497 .2221 .74039 .2189 .72907 .20475 Metetra
.589 .757 .958 r
.72907 .20475 .74039 .2189 .76599 .21405 .75478 .19895 Metetra
.605 .718 .924 r
.08119 .42654 .09609 .44093 .11591 .43692 .10117 .42167 Metetra
.584 .699 .921 r
.10117 .42167 .11591 .43692 .13578 .4341 .12123 .4177 Metetra
.561 .675 .915 r
.12123 .4177 .13578 .4341 .1557 .43267 .14136 .41475 Metetra
.538 .645 .903 r
.14136 .41475 .1557 .43267 .1757 .43263 .1616 .41284 Metetra
.523 .615 .886 r
.1616 .41284 .1757 .43263 .19584 .43375 .18197 .41177 Metetra
.52 .589 .864 r
.18197 .41177 .19584 .43375 .2162 .43542 .20255 .4111 Metetra
.532 .572 .841 r
.20255 .4111 .2162 .43542 .23688 .43667 .22343 .41009 Metetra
.557 .565 .818 r
.22343 .41009 .23688 .43667 .25798 .43619 .24467 .40775 Metetra
.592 .57 .798 r
.24467 .40775 .25798 .43619 .27959 .43253 .26636 .403 Metetra
.632 .584 .782 r
.26636 .403 .27959 .43253 .30175 .42435 .28851 .39485 Metetra
.673 .605 .771 r
.28851 .39485 .30175 .42435 .32441 .4108 .31111 .38263 Metetra
.712 .633 .767 r
.31111 .38263 .32441 .4108 .34747 .39175 .33408 .36626 Metetra
.749 .666 .769 r
.33408 .36626 .34747 .39175 .3708 .36798 .35731 .3463 Metetra
.784 .708 .78 r
.35731 .3463 .3708 .36798 .39422 .34108 .38067 .32393 Metetra
.813 .758 .801 r
.38067 .32393 .39422 .34108 .41759 .31317 .40405 .30072 Metetra
.834 .818 .834 r
.40405 .30072 .41759 .31317 .44084 .28647 .42738 .27838 Metetra
.835 .886 .879 r
.42738 .27838 .44084 .28647 .46394 .26294 .45063 .2584 Metetra
.791 .946 .925 r
.45063 .2584 .46394 .26294 .48695 .24391 .47385 .24182 Metetra
.674 .959 .943 r
.47385 .24182 .48695 .24391 .50996 .22998 .4971 .2291 Metetra
.5 .904 .916 r
.4971 .2291 .50996 .22998 .5331 .22097 .52048 .22013 Metetra
.345 .821 .88 r
.52048 .22013 .5331 .22097 .55647 .2161 .54408 .2143 Metetra
.266 .767 .879 r
.54408 .2143 .55647 .2161 .58015 .21418 .56795 .21071 Metetra
.268 .756 .916 r
.56795 .21071 .58015 .21418 .60418 .21392 .59214 .20836 Metetra
.327 .768 .964 r
.59214 .20836 .60418 .21392 .62857 .21409 .61665 .2063 Metetra
.408 .78 .993 r
.61665 .2063 .62857 .21409 .65329 .21372 .64148 .20381 Metetra
.483 .782 .997 r
.64148 .20381 .65329 .21372 .6783 .2122 .66659 .20042 Metetra
.54 .776 .985 r
.66659 .20042 .6783 .2122 .70358 .20922 .69195 .19589 Metetra
.58 .769 .969 r
.69195 .19589 .70358 .20922 .72907 .20475 .71755 .19021 Metetra
.607 .763 .954 r
.71755 .19021 .72907 .20475 .75478 .19895 .74336 .18349 Metetra
.62 .725 .921 r
.06606 .41212 .08119 .42654 .10117 .42167 .0862 .4065 Metetra
.606 .711 .919 r
.0862 .4065 .10117 .42167 .12123 .4177 .10644 .40151 Metetra
.589 .692 .913 r
.10644 .40151 .12123 .4177 .14136 .41475 .12678 .39723 Metetra
.574 .668 .903 r
.12678 .39723 .14136 .41475 .1616 .41284 .14723 .39369 Metetra
.562 .643 .888 r
.14723 .39369 .1616 .41284 .18197 .41177 .16784 .39073 Metetra
.558 .62 .87 r
.16784 .39073 .18197 .41177 .20255 .4111 .18864 .38803 Metetra
.565 .602 .849 r
.18864 .38803 .20255 .4111 .22343 .41009 .2097 .38506 Metetra
.581 .593 .829 r
.2097 .38506 .22343 .41009 .24467 .40775 .23109 .38111 Metetra
.605 .592 .811 r
.23109 .38111 .24467 .40775 .26636 .403 .25286 .37542 Metetra
.635 .6 .797 r
.25286 .37542 .26636 .403 .28851 .39485 .27503 .36726 Metetra
.667 .616 .789 r
.27503 .36726 .28851 .39485 .31111 .38263 .29758 .35617 Metetra
.699 .64 .786 r
.29758 .35617 .31111 .38263 .33408 .36626 .32047 .34207 Metetra
.731 .671 .791 r
.32047 .34207 .33408 .36626 .35731 .3463 .34362 .32536 Metetra
.76 .71 .805 r
.34362 .32536 .35731 .3463 .38067 .32393 .36692 .30687 Metetra
.785 .757 .828 r
.36692 .30687 .38067 .32393 .40405 .30072 .39029 .28773 Metetra
.8 .813 .862 r
.39029 .28773 .40405 .30072 .42738 .27838 .41368 .26917 Metetra
.796 .873 .904 r
.41368 .26917 .42738 .27838 .45063 .2584 .43706 .25228 Metetra
.757 .923 .944 r
.43706 .25228 .45063 .2584 .47385 .24182 .46046 .23782 Metetra
.671 .939 .965 r
.46046 .23782 .47385 .24182 .4971 .2291 .48393 .22616 Metetra
.556 .913 .961 r
.48393 .22616 .4971 .2291 .52048 .22013 .50754 .21719 Metetra
.457 .87 .951 r
.50754 .21719 .52048 .22013 .54408 .2143 .53136 .2105 Metetra
.408 .836 .956 r
.53136 .2105 .54408 .2143 .56795 .21071 .55543 .20542 Metetra
.412 .821 .977 r
.55543 .20542 .56795 .21071 .59214 .20836 .57979 .20121 Metetra
.449 .814 .995 r
.57979 .20121 .59214 .20836 .61665 .2063 .60445 .19719 Metetra
.498 .806 1 r
.60445 .19719 .61665 .2063 .64148 .20381 .6294 .19282 Metetra
.543 .794 .991 r
.6294 .19282 .64148 .20381 .66659 .20042 .65461 .18777 Metetra
.578 .782 .976 r
.65461 .18777 .66659 .20042 .69195 .19589 .68009 .18187 Metetra
.604 .772 .961 r
.68009 .18187 .69195 .19589 .71755 .19021 .7058 .17511 Metetra
.622 .765 .948 r
.7058 .17511 .71755 .19021 .74336 .18349 .73174 .16757 Metetra
.632 .732 .92 r
.05067 .39772 .06606 .41212 .0862 .4065 .07096 .39146 Metetra
.622 .721 .917 r
.07096 .39146 .0862 .4065 .10644 .40151 .09137 .38563 Metetra
.611 .707 .913 r
.09137 .38563 .10644 .40151 .12678 .39723 .1119 .38026 Metetra
.6 .689 .905 r
.1119 .38026 .12678 .39723 .14723 .39369 .13256 .37538 Metetra
.592 .669 .893 r
.13256 .37538 .14723 .39369 .16784 .39073 .15338 .37088 Metetra
.588 .65 .879 r
.15338 .37088 .16784 .39073 .18864 .38803 .17439 .36653 Metetra
.591 .634 .862 r
.17439 .36653 .18864 .38803 .2097 .38506 .19564 .36197 Metetra
.602 .623 .845 r
.19564 .36197 .2097 .38506 .23109 .38111 .21717 .35672 Metetra
.618 .619 .83 r
.21717 .35672 .23109 .38111 .25286 .37542 .23903 .35024 Metetra
.639 .623 .818 r
.23903 .35024 .25286 .37542 .27503 .36726 .26123 .34205 Metetra
.664 .635 .811 r
.26123 .34205 .27503 .36726 .29758 .35617 .28376 .33183 Metetra
.689 .654 .81 r
.28376 .33183 .29758 .35617 .32047 .34207 .3066 .31952 Metetra
.714 .681 .816 r
.3066 .31952 .32047 .34207 .34362 .32536 .32968 .30538 Metetra
.737 .715 .83 r
.32968 .30538 .34362 .32536 .36692 .30687 .35294 .28998 Metetra
.756 .756 .853 r
.35294 .28998 .36692 .30687 .39029 .28773 .37631 .27409 Metetra
.765 .803 .884 r
.37631 .27409 .39029 .28773 .41368 .26917 .39975 .25857 Metetra
.759 .851 .92 r
.39975 .25857 .41368 .26917 .43706 .25228 .42325 .24417 Metetra
.729 .89 .954 r
.42325 .24417 .43706 .25228 .46046 .23782 .44682 .23142 Metetra
.674 .908 .976 r
.44682 .23142 .46046 .23782 .48393 .22616 .47049 .22059 Metetra
.606 .902 .986 r
.47049 .22059 .48393 .22616 .50754 .21719 .49431 .21161 Metetra
.549 .881 .989 r
.49431 .21161 .50754 .21719 .53136 .2105 .51834 .20418 Metetra
.52 .86 .994 r
.51834 .20418 .53136 .2105 .55543 .20542 .54261 .19785 Metetra
.52 .842 .999 r
.54261 .19785 .55543 .20542 .57979 .20121 .56714 .19209 Metetra
.538 .825 .998 r
.56714 .19209 .57979 .20121 .60445 .19719 .59195 .18644 Metetra
.563 .809 .991 r
.59195 .18644 .60445 .19719 .6294 .19282 .61703 .18051 Metetra
.587 .794 .978 r
.61703 .18051 .6294 .19282 .65461 .18777 .64238 .17409 Metetra
.607 .781 .964 r
.64238 .17409 .65461 .18777 .68009 .18187 .66798 .16704 Metetra
.622 .771 .952 r
.66798 .16704 .68009 .18187 .7058 .17511 .69381 .15938 Metetra
.633 .764 .941 r
.69381 .15938 .7058 .17511 .73174 .16757 .71989 .15114 Metetra
.64 .737 .919 r
.03503 .38332 .05067 .39772 .07096 .39146 .05546 .37656 Metetra
.634 .73 .917 r
.05546 .37656 .07096 .39146 .09137 .38563 .07603 .37005 Metetra
.626 .719 .914 r
.07603 .37005 .09137 .38563 .1119 .38026 .09673 .36384 Metetra
.619 .706 .908 r
.09673 .36384 .1119 .38026 .13256 .37538 .11757 .35791 Metetra
.613 .692 .899 r
.11757 .35791 .13256 .37538 .15338 .37088 .13858 .35222 Metetra
.611 .677 .888 r
.13858 .35222 .15338 .37088 .17439 .36653 .15978 .3466 Metetra
.612 .663 .875 r
.15978 .3466 .17439 .36653 .19564 .36197 .1812 .34082 Metetra
.618 .653 .862 r
.1812 .34082 .19564 .36197 .21717 .35672 .20287 .33455 Metetra
.629 .648 .85 r
.20287 .33455 .21717 .35672 .23903 .35024 .22483 .32746 Metetra
.644 .65 .841 r
.22483 .32746 .23903 .35024 .26123 .34205 .24708 .31921 Metetra
.662 .658 .835 r
.24708 .31921 .26123 .34205 .28376 .33183 .26962 .30961 Metetra
.681 .672 .835 r
.26962 .30961 .28376 .33183 .3066 .31952 .29244 .2986 Metetra
.699 .694 .841 r
.29244 .2986 .3066 .31952 .32968 .30538 .31549 .28636 Metetra
.716 .722 .854 r
.31549 .28636 .32968 .30538 .35294 .28998 .33873 .27326 Metetra
.728 .755 .874 r
.33873 .27326 .35294 .28998 .37631 .27409 .36212 .2598 Metetra
.733 .791 .899 r
.36212 .2598 .37631 .27409 .39975 .25857 .38562 .24655 Metetra
.727 .827 .927 r
.38562 .24655 .39975 .25857 .42325 .24417 .40922 .23401 Metetra
.706 .855 .953 r
.40922 .23401 .42325 .24417 .44682 .23142 .43294 .22254 Metetra
.673 .871 .974 r
.43294 .22254 .44682 .23142 .47049 .22059 .45679 .21231 Metetra
.636 .872 .986 r
.45679 .21231 .47049 .22059 .49431 .21161 .48081 .20328 Metetra
.605 .863 .992 r
.48081 .20328 .49431 .21161 .51834 .20418 .50503 .19526 Metetra
.588 .848 .994 r
.50503 .19526 .51834 .20418 .54261 .19785 .52949 .18793 Metetra
.585 .832 .992 r
.52949 .18793 .54261 .19785 .56714 .19209 .5542 .18095 Metetra
.592 .816 .985 r
.5542 .18095 .56714 .19209 .59195 .18644 .57917 .17401 Metetra
.603 .801 .975 r
.57917 .17401 .59195 .18644 .61703 .18051 .6044 .16686 Metetra
.615 .787 .964 r
.6044 .16686 .61703 .18051 .64238 .17409 .62988 .15935 Metetra
.626 .776 .953 r
.62988 .15935 .64238 .17409 .66798 .16704 .65562 .1514 Metetra
.635 .768 .943 r
.65562 .1514 .66798 .16704 .69381 .15938 .68159 .143 Metetra
.642 .762 .936 r
.68159 .143 .69381 .15938 .71989 .15114 .70781 .1342 Metetra
.646 .742 .919 r
.01913 .3689 .03503 .38332 .05546 .37656 .03969 .36175 Metetra
.642 .737 .918 r
.03969 .36175 .05546 .37656 .07603 .37005 .06039 .35473 Metetra
.637 .729 .915 r
.06039 .35473 .07603 .37005 .09673 .36384 .08125 .34787 Metetra
.633 .72 .911 r
.08125 .34787 .09673 .36384 .11757 .35791 .10226 .34117 Metetra
.629 .71 .905 r
.10226 .34117 .11757 .35791 .13858 .35222 .12344 .33458 Metetra
.627 .699 .897 r
.12344 .33458 .13858 .35222 .15978 .3466 .1448 .32802 Metetra
.627 .689 .888 r
.1448 .32802 .15978 .3466 .1812 .34082 .16638 .32133 Metetra
.631 .68 .878 r
.16638 .32133 .1812 .34082 .20287 .33455 .18818 .31431 Metetra
.638 .676 .869 r
.18818 .31431 .20287 .33455 .22483 .32746 .21024 .30674 Metetra
.648 .676 .862 r
.21024 .30674 .22483 .32746 .24708 .31921 .23256 .29841 Metetra
.661 .681 .859 r
.23256 .29841 .24708 .31921 .26962 .30961 .25514 .2892 Metetra
.674 .692 .859 r
.25514 .2892 .26962 .30961 .29244 .2986 .27797 .27908 Metetra
.686 .708 .864 r
.27797 .27908 .29244 .2986 .31549 .28636 .30103 .26816 Metetra
.698 .729 .875 r
.30103 .26816 .31549 .28636 .33873 .27326 .32428 .25665 Metetra
.705 .754 .89 r
.32428 .25665 .33873 .27326 .36212 .2598 .3477 .2449 Metetra
.707 .78 .909 r
.3477 .2449 .36212 .2598 .38562 .24655 .37127 .23324 Metetra
.702 .804 .929 r
.37127 .23324 .38562 .24655 .40922 .23401 .39498 .22199 Metetra
.689 .824 .948 r
.39498 .22199 .40922 .23401 .43294 .22254 .41884 .2114 Metetra
.67 .835 .963 r
.41884 .2114 .43294 .22254 .45679 .21231 .44285 .20156 Metetra
.65 .838 .973 r
.44285 .20156 .45679 .21231 .48081 .20328 .46706 .19245 Metetra
.633 .834 .978 r
.46706 .19245 .48081 .20328 .50503 .19526 .49147 .18395 Metetra
.623 .824 .978 r
.49147 .18395 .50503 .19526 .52949 .18793 .5161 .17585 Metetra
.62 .813 .974 r
.5161 .17585 .52949 .18793 .5542 .18095 .54098 .16795 Metetra
.622 .8 .968 r
.54098 .16795 .5542 .18095 .57917 .17401 .56611 .16004 Metetra
.627 .789 .959 r
.56611 .16004 .57917 .17401 .6044 .16686 .5915 .15197 Metetra
.633 .778 .951 r
.5915 .15197 .6044 .16686 .62988 .15935 .61713 .14363 Metetra
.638 .77 .943 r
.61713 .14363 .62988 .15935 .65562 .1514 .64301 .13497 Metetra
.643 .764 .936 r
.64301 .13497 .65562 .1514 .68159 .143 .66914 .12601 Metetra
.647 .759 .931 r
.66914 .12601 .68159 .143 .70781 .1342 .69551 .11675 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
gsave
.29165 .07573 -70.3112 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.563},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001GR000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooolY0?ooo`030?ooe02K0000000000@00000
00<0VmCo0?ooo`3oool0OP3oool00?l0oooo:P3oool00`3DV`00002K0=Coo`020?ooo`030>ZjV`2j
j_l0oooo07l0oooo003o0?ooob/0oooo00<0omBK0000LP2jj_l0P`3oool00?l0oooo;03oool00`3o
j[X0LP0007:jjP220?ooo`00o`3oool^0?ooo`030;Yb001b^^X0oooo0800oooo003o0?ooobl0oooo
00<0^W:K0=Coo`3oool0O`3oool00?l0oooo:P3oool00`3Z^W80VmCo0?ooo`020?ooo`030=BK002K
e?l0oooo07l0oooo003o0?ooobX0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o0800oooo
003o0?ooob/0oooo00D0omBK000000000000001b0;[Zo`0A0?ooo`030?ooe02K0000000000@00000
00<0VmCo0?ooo`3oool0IP3oool00?l0oooo@P3oool00`3DV`00002K0=Coo`020?ooo`030>ZjV`2j
j_l0oooo06L0oooo003o0?oood<0oooo00<0omBK0000LP2jj_l0J`3oool00?l0ooooA03oool00`3o
j[X0LP0007:jjP1Z0?ooo`00o`3oooli0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3o
ool0103oool00`2jLP00L[[Z0?ooo`1X0?ooo`00o`3ooom70?ooo`030;YbV`3Dool0oooo06L0oooo
003o0?oood80oooo00<0j[Yb09_Do`3oool00P3oool00`3DV`00VmCo0?ooo`1W0?ooo`00o`3ooom2
0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`1X0?ooo`00o`3ooolb0?ooo`8000003`3o
ool01@3oe9/00000000000000780^^[o06T0oooo003o0?oooc00oooo1@00001l0?ooo`00o`3oool]
0?ooo`<000000`3oool2000007`0oooo003o0?ooob/0oooo0P0000060?ooo`030000003oool00000
07/0oooo003o0?ooobP0oooo0`0000080?ooo`040000003oool0oooo000007X0oooo003o0?ooobH0
oooo0P00000;0?ooo`040000003oool0oooo000007X0oooo003o0?ooob<0oooo0`00000=0?ooo`05
0000003oool0oooo0?ooo`000000N@3oool00?l0oooo8@3oool2000000<0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07H0oooo003o0?oooah0oooo
0`00000B0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0MP3oool00?l0oooo703o
ool2000001H0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1e0?ooo`00o`3ooolI
0?ooo`<00000603oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo07@0oooo003o0?oo
oaH0oooo0`00000K0?ooo`030000003oool0oooo0080oooo0P00001f0?ooo`00hP3oool00`3o/5d0
00000000000300000003001M/03oool0oooo02P0oooo0P0000000`3oool000000?ooo`0K0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0L`3oool00>D0oooo00<0R38b08SGo`3oool0
:03oool3000000@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo0780oooo003U0?ooo`0308Pb<P28eol0oooo02H0oooo0P00000S0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0LP3oool00>D0oooo00<0R38b08SGo`3oool08`3oool3
000002D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1a0?ooo`00i@3oool00`28
<S80R=Oo0?ooo`0Q0?ooo`800000:03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo
0700oooo003U0?ooo`0308Pb<P28eol0oooo01h0oooo0`00000Z0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0L03oool008/0oooo00H0/5d0000000000000<XSG0?ooo`3GR3820000
0003001M/03oool0oooo04l0oooo00<0R38b08SGo`3oool0703oool2000000<0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06l0oooo002<0?ooo`03
0;1M000bR=L0oooo0080oooo00<0R38003:8e`3oool0CP3oool01@3GR3800000000bR028<S80R=Oo
01X0oooo0`00000_0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0K`3oool008d0
oooo00D0R38003:8e`3oool0R38003:8e`1B0?ooo`030=N8<P000380R=Oo01P0oooo0P00000b0?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool0KP3oool008h0oooo00<0R3800000000b
R=L0J`3oool3000003@0oooo00<000000?ooo`3oool0203oool3000006l0oooo002>0?ooo`030;1M
00000000GK3o06T0oooo0P00000g0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
K@3oool008d0oooo00D0/5d0001M/03ook00G@0b08SGo`1U0?ooo`@00000>03oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo06`0oooo002<0?ooo`070;1M0000GK00oooo0?ooo`3oehP0
<P0b08SGo`1R0?ooo`800000103oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0J`3oool008/0oooo00H0/5d0000000000380R=Oo0?ooo`2`G@020000
000305f`o`3oool0oooo05`0oooo0`00000o0?ooo`030000003oool0oooo00/0oooo00<000000?oo
o`3oool0J`3oool00?00oooo0P0000120?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool0JP3oool00>d0oooo0`0000140?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
J@3oool00>/0oooo0P0000170?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0J@3o
ool00>P0oooo0`0000020?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`1X0?ooo`00i@3oool3000000H0oooo00<000000?ooo`3oool0@`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo06L0oooo003S0?ooo`800000C`3oool00`000000
oooo0?ooo`0>0?ooo`800000J@3oool00>00oooo0`00001A0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0IP3oool00=h0oooo0P00001D0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0I@3oool00=/0oooo0`0000020?ooo`030000003oool0oooo0540oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`1U0?ooo`00f@3oool2000005T0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`1T0?ooo`00eP3oool3000005/0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`1S0?ooo`00e03oool2000005h0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`1S0?ooo`00X@3oool01@3o/5d00000000000000000GK3o02/0oooo
0`00001P0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0HP3oool00:40oooo00H0
R39M0;3oo`3oool0oon`05d0G@2`oolX0?ooo`80000000<0oooo0000003oool0H03oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0640oooo002P0?ooo`030?n`G@00GK00oooo0080oooo
00<0ehPb03:8e`3oool0903oool3000000@0oooo00<000000?ooo`3oool0GP3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0640oooo002P0?ooo`030=N8<P0bR=L0oooo0080oooo00<0
ok1M001M/03oool08P3oool2000006T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0000
000C0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0AP3oool00:00oooo00<0ehPb
03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0O0?ooo`<00000J`3oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo01<0oooo00<0^W9b0;[Zo`3oool0B@3oool00:00oooo00<0ehPb03:8
e`3oool00P3oool00`3o/5d005f`0?ooo`0M0?ooo`800000KP3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo01<0oooo00<0^W9b0;[Zo`3oool0B@3oool00:00oooo00<0ok1M03:8e`3o
ool00P3oool00`3GR380<XSG0?ooo`0J0?ooo`<00000L03oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0180oooo00<0^W9b0;[Zo`3oool0B@3oool00:40oooo00H0R38005f`o`3oool0
omN80380G@2`oolI0?ooo`8000000`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo
01P0oooo00<000000?ooo`3oool01@3oool00`2jLP0000000000000300000003001b^P3oool0oooo
00<0oooo00<0^W9b0;[Zo`3oool0B@3oool00:40oooo00D0oon`05d000000000000b08SGo`0G0?oo
o`<00000M03oool2000001X0oooo00<000000?ooo`3oool04@3oool00`2jLW80^^[o0?ooo`190?oo
o`00^`3oool2000007D0oooo0P0000000`2U`^h000000000000J0?ooo`030000003oool0oooo0100
oooo00<0^W9b0;[Zo`3oool0B@3oool00;P0oooo0`00001d0?ooo`<000000`2U`^h2000001/0oooo
00<000000?ooo`3oool0303oool01@3Z^W800000001b^P2jLW80^^[o04X0oooo002f0?ooo`800000
M@3oool2000000H0YL;^00<000000:G2kP0000006P3oool00`000000oooo0?ooo`0>0?ooo`030>Zj
LP000780^^[o04X0oooo002c0?ooo`<000000P3oool00`000000oooo0?ooo`1_0?ooo`<00000202U
`^h010000000YL;^0:G2kP00000I0?ooo`800000G03oool00;00oooo0`00001c0?ooo`@000000P2T
`nl00`000000YL;^0:G2kP060:G2kP050000002U`^h0YL;^0:G2kP0000005P3oool2000000030?oo
o`000000oooo05/0oooo002^0?ooo`800000LP3oool4000000H0Y<?_00<000000:G2kP2U`^h01P2U
`^h01@000000YL;^0:G2kP2U`^h0000001X0oooo00<000000?ooo`3oool0F@3oool00:/0oooo0`00
001a0?ooo`<000002`2T`nl00`000000YL;^0:G2kP050:G2kP040000002U`^h0YL;^0:G2kP800000
6P3oool00`000000oooo0?ooo`1H0?ooo`00Z@3oool300000740oooo0P0000020:?5l@030000002T
`nl0Y<?_00X0Y<?_00<000000:G2kP2U`^h0102U`^h010000000YL;^0000000000020:C3k`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0F03oool00:H0oooo0`0000020?ooo`030000003o
ool0oooo06`0oooo0`0000040:?5l@030000002T`nl0Y<?_00/0Y<?_00<000000:G2kP2U`^h00P2U
`^h3000000@0Y<?_00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1G0?ooo`00Y03oool2
000000H0oooo00<000000?ooo`3oool0J@3oool2000000P0XlGa00<000000:C3k`2T`nl02P2T`nl0
0`000000YL;^0:G2kP02000000030:C3k`000000Y<?_00D0Y<?_00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`1F0?ooo`00X@3oool300000740oooo0`00000;0:?5l@030000002T`nl0Y<?_
00T0Y<?_0`0000040:C3k`030000002T`nl0Y<?_00@0Y<?_00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`1F0?ooo`00W`3oool200000740oooo0`0000020:;7l`030000002SaO40XlGa00X0
XlGa00<000000:C3k`2T`nl0102T`nl400000080X/Ca00<000000:C3k`2T`nl00P2T`nl00`000000
Y<?_0:C3k`050:C3k`030000003oool0oooo01L0oooo00<000000?ooo`3oool0E@3oool009`0oooo
0`00001_0?ooo`@000001P2Rao<00`000000XlGa0:?5l@090:?5l@030000002T`nl0Y<?_00@00000
1P2Ra?400`000000Y<?_0:C3k`020:C3k`030000002T`nl0Y<?_00D0Y<?_00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`1D0?ooo`00VP3oool2000000<0oooo00<000000?ooo`3oool0J@3o
ool3000000X0X/Oc00<000000:?5l@2SaO402@2SaO43000000/0X/Ca00D000000:C3k`2T`nl0Y<?_
000000070:C3k`8000005`3oool3000005H0oooo002G0?ooo`<00000KP3oool300000080X<We00<0
00000:;7l`2Rao<02@2Rao<00`000000XlGa0:?5l@050:?5l@<000000P2Pa_<00`000000X/Ca0:;4
l@0:0:;4l@040000002T`nl0Y<?_000000<0Y<?_100000020:;3l0030000003oool0oooo01L0oooo
00<000000?ooo`3oool0D`3oool00640oooo00<0ok1M0000000000000`0000000`00GK00oooo0?oo
o`0[0?ooo`800000K@3oool4000000H0X<We00<000000:;7l`2Rao<02@2Rao<00`000000XlGa0:?5
l@04000000H0X<Kc00<000000:;4l@2Ra?402@2Ra?400`000000Y<?_0:C3k`04000000H0X/?`00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`1B0?ooo`00I03oool00`28<S80R=Oo0?ooo`0[
0?ooo`<00000K03oool3000000X0X<We00<000000:;7l`2Rao<02@2Rao<3000000X0X<Kc00<00000
0:;4l@2Ra?402@2Ra?44000000X0X/?`00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1B
0?ooo`00I03oool00`28<S80R=Oo0?ooo`0Y0?ooo`800000K03oool300000080Wlcg00<000000:39
m@2PbOD02@2PbOD00`000000X/Oc0:;7l`050:;7l`<000000P2MbOH00`000000X<Kc0:36l`090:36
l`030000002Ra?40X/Ca00D0X/Ca0`00000209o5l`8000002`2R`o000`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo0540oooo001T0?ooo`0308Pb<P28eol0oooo02H0oooo0`0000020?ooo`03
0000003oool0oooo06D0oooo1000000609o<m`030000002PbOD0X<We00T0X<We00<000000:;7l`2R
ao<01000000609g9mP030000002Pa_<0X<Kc00T0X<Kc00<000000:;4l@2Ra?401000000609o5l`03
0000002R`o00X/?`00T0X/?`00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1@0?ooo`00
F03oool00`28<P0000000000000300000003000bR03oool0oooo00<0oooo00<0R38b08SGo`3oool0
903oool2000006X0oooo0`00000:09o<m`030000002PbOD0X<We00T0X<We0`00000:09g9mP030000
002Pa_<0X<Kc00T0X<Kc0`00000:09o5l`030000002R`o00X/?`00T0X/?`0P00000I0?ooo`030000
003oool0oooo0500oooo001T0?ooo`0308Pb<P28eol0oooo0240oooo0`00001Z0?ooo`8000000P2N
d?T00`000000Wlcg09o<m`0909o<m`030000002PbOD0X<We00D0X<We0`00000209[=n@030000002M
bOH0WLWf00T0WLWf00<000000:36l`2Pa_<01@2Pa_<300000080VlOf00<0000009o5l`2OaO<0202O
aO<2000000L0X/?`0`00000209o3lP030000003oool0oooo01L0oooo00<000000?ooo`3oool0C`3o
ool006@0oooo00<0R38b08SGo`3oool07P3oool3000006/0oooo0P00000509k@n@030000002Oc?L0
Wlcg00T0Wlcg00<000000:39m@2PbOD01000000609[=n@030000002MbOH0WLWf00T0WLWf00<00000
0:36l`2Pa_<01000000609_7mP030000002OaO<0WlGc00L0WlGc00<0000009o5l`0000000P2R`o04
000000D0Wl?b00<000000?ooo`3oool05P3oool300000500oooo001Q0?ooo`050=N8<P00000003:8
08Pb<P28eol07@3oool4000006X0oooo0P00000809k@n@030000002Oc?L0Wlcg00P0Wlcg0`00000;
09[=n@030000002MbOH0WLWf00L0WLWf1000000:09_7mP030000002OaO<0WlGc00L0WlGc00<00000
09o5l`0000000P00000:09o3lP030000003oool0oooo01L0oooo00<000000?ooo`3oool0CP3oool0
06<0oooo00<0ehPb0000<P28eol06`3oool2000006/0oooo0`00000;09k@n@030000002Oc?L0Wlcg
00@0Wlcg0`00000209O@o0030000002JcOT0V/gi00X0V/gi00@0000009g9mP2MbOH0WLWf1@000003
09K;nP030000002KaoH0VlOf00T0VlOf00<0000009o5l`2OaO<01@2OaO<300000080V/Gf00<00000
09o3lP2O`o802@2O`o800`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04d0oooo001n0?oo
o`<00000JP3oool300000080Wm;j00<0000009k@n@2Nd?T02P2Nd?T00`000000Wlcg09o<m`030000
00H0Um3l00<0000009[=n@2JcOT02@2JcOT4000000T0U/_j00<0000009_7mP2KaoH02@2KaoH00`00
0000WlGc09o5l`040000000309[5mP000000V/Gf00<0V/Gf00<0000009o3lP2O`o802@2O`o800`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo04`0oooo001k0?ooo`<00000J@3oool4000000H0
Wm;j0P00000909k@n@@000002P2Gd?`00`000000V/gi09[=n@0509[=n@<000000P2@cod00`000000
U/_j09K;nP0909K;nP030000002KaoH0VlOf00L0VlOf1000000509[5mP030000002JaOH0V/Gf0080
V/Gf00<0000009o3lP2O`o802@2O`o800`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04`0
oooo001i0?ooo`800000J@3oool3000000`0Wm;j00@0000009k@n@2Nd?T0W]3i1@00000309GDo@03
0000002Gd?`0Um3l00T0Um3l00<0000009[=n@2JcOT010000006093?o@030000002FboX0U/_j00T0
U/_j00@0000009_7mP2KaoH0VlOf1@00000309?8n@030000002JaOH0V/Gf00@0V/Gf00<0000009[5
mP2JaOH00P2JaOH00`000000Wl?b09o3lP0709o3lP<000006@3oool00`000000oooo0?ooo`1;0?oo
o`00MP3oool3000000030?ooo`000000oooo06D0oooo0`0000020:;EnP030000002Od_X0Wm;j00X0
Wm;j1000000909GDo@800000202Gd?`4000000/0T<om00<0000009K;nP2FboX01`2FboX5000000T0
TlSi00<0000009[5mP2JaOH00`2JaOH00`000000V/Gf09[5mP0309[5mP040000002O`o80Wl?b09o3
lPD000000`2K`o@00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo04X0oooo001d0?ooo`80
0000I`3oool4000000H0X]Gj0P00000709oBnP<000000P2FfOh00`000000UMCm09GDo@0:09GDo@04
0000002Gd?`0Um3l09O@o0@000000`29dol00`000000T<om093?o@0:093?o@040000002FboX0U/_j
09K;nPD000000`2;bod00`000000TlSi09?8n@0909?8n@030000002JaOH0V/Gf0080V/Gf00<00000
09[5mP2JaOH00P2JaOH5000000P0Vl?d00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1:
0?ooo`00L@3oool3000006H0oooo0`00000<0:;EnP030000002Od_X0Wm;j00@000001P2FfOh20000
00T0UMCm1@00000808WCo`8000002@2@cod5000000T0Rl_m00<0000009?8n@2Cb?T02@2Cb?T01000
0000V/Gf09[5mP2JaOH5000000<0U<Ch00<0000009_3m02K`o@0202K`o@00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo04T0oooo001_0?ooo`800000I`3oool200000080Y]Ki0P00000;0:;E
nP<00000302FfOh010000000UMCm09GDo@2Ee?d5000000<0QMOo00<0000008WCo`29dol02@29dol0
10000000T<om093?o@2@cod5000000<0Olko00<0000008_;o@2;bod02@2;bod00`000000TlSi09?8
n@0709?8n@H000001`2Da?P00`000000Vl?d09_3m00909_3m0030000003oool0oooo01D0oooo0`00
001:0?ooo`00K03oool3000006L0oooo0P0000060:KFn@030000002ReOX0X]Gj00D0X]Gj0`000002
09[Lo@030000002FfOh0U]Wn00X0U]Wn1000000908GGo`8000002029dol5000000T0Olko00<00000
08_;o@2;bod02@2;bod010000000TlSi09?8n@2Cb?T5000000<0R/Kl00<0000009C4n0000000202D
a?P00`000000Vl?d09_3m00809_3m0030000003oool0oooo01L0oooo00<000000?ooo`3oool0:@3o
ool00`3oom@0V`0000000002000000030000LP2jj_l0oooo01L0oooo001Z0?ooo`8000000P3oool0
0`000000oooo0?ooo`1S0?ooo`8000002@2Ve_T200000080X]Gj0`00000609[Lo@8000001`2FfOh3
00000080QMcn0P00000;08GGo`0400000029dol0RM?o08WCo`@000000`1bd?h2000000X0Olko00<0
000008_;o@2;bod01`2;bod5000000P0R/Kl00<0000009C4n00000002@2Da?P00`000000Vl?d09_3
m00609_3m0<000006@3oool00`000000oooo0?ooo`0Z0?ooo`030?ooe02K09/0e?oo01X0oooo001W
0?ooo`<000001@3oool00`000000oooo0?ooo`1O0?ooo`<00000302Ve_T3000000/0V]cm00<00000
09KIoP2FfOh01000000708GLoP8000001P25eol7000000T0L]3n0P00000907o>o`040000002;bod0
Rl_m08_;o@D000000`1kb?l00`000000R/Kl08[6o00808[6o08000002@2Da?P010000000Vl?d09_3
m02K`o@5000000<0U/7e00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0Y0?ooo`030?oo
e02K09/0e?oo01X0oooo001U0?ooo`800000J03oool200000080ZmGf00<000000:KFn@2Ve_T0202V
e_T200000080X]ol00<0000009[Lo@2Jg?d02@2Jg?d3000000/0QMcn2000000506WBnP8000001`1b
d?hA000000T0NlSo00<0000008[6o02:a_`0202:a_`00`000000U<Ch09C4n00609C4n0D000002@2F
`OD00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02T0oooo00<0oooD09/0V`3Dool06P3o
ool00680oooo0`00001W0?ooo`<000001@2[eOH2000000D0Y]Ki0`0000050:;Oo08000001P2Jg?d3
000000<0S>7m0`00000408GLoP@00000101Xe_@2000000H0JM;j2P00000505?4mP030000001Xaoh0
J<On00L0J<On00<0000007_8o`1kb?l0201kb?l00`000000R/Kl08[6o00808[6o0040000002Da?P0
U<Ch09C4n0D000000`2=`_T00`000000U/7e09K1m@0809K1m@030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0:03oool00`3DV`00LW9b001b^P0J0?ooo`00H03oool2000006P0oooo0P00000:
0:_EmP030000002Ve_T0Y]Ki008000002P2Rgo`00`000000V]cm09[Lo@03000000T0S>7m10000009
06SFm0L000001P14`NX2000000P0DlCf0P00000806S7oP8000002@1kb?l00`000000R/Kl08[6o004
08[6o0L000002@2=`_T00`000000U/7e09K1m@0809K1m@030000003oool0oooo01L0oooo00<00000
0?ooo`3oool09P3oool01@3Z^W8009_D0?ooo`3Z^W8009_D01T0oooo001M0?ooo`<000000P3oool0
0`000000oooo0?ooo`1R0?ooo`<00000302[eOH3000000`0X]ol0`00000908cQo@<000000`1dg_<2
000000@0J=Kd1000000404C4h@8000001P14`NX9000000@0DlCf00<0000006S7oP1Xaoh00`1XaohD
000000<0O/;m00<0000007k2o@0000002`2=`_T00`000000U/7e09K1m@0809K1m@030000003oool0
oooo01H0oooo00<000000?ooo`3oool09@3oool00`3oj[X0LW:j0?ooo`020?ooo`030=BK002Ke?l0
oooo01L0oooo001K0?ooo`800000J03oool200000080/=;b0P0000090:_EmP8000000P2/g_T20000
00P0X]ol0`00000309_Vo08000000`2<hOd4000000L0M=kc5@000006026[f080000000<0<[7Z0000
000000002000000504jjn@030000001Y`?h0JL3n00L0JL3n00<0000007k2o@1n`_d01@1n`_d01000
0000O/;m07k2o@00000;08g2n@030000002F`OD0U/7e00@0U/7e1@00000H0?ooo`030000003oool0
oooo02<0oooo00H0j[Yb000000000000L[[Z0?ooo`3oe9/20000000307:jjP3oool0oooo01D0oooo
000V0?ooo`030?oo/01M0000000000@0000000<0GK3o0?ooo`3oool0:03oool3000006P0oooo0P00
00060;3BlP030000002[eOH0ZmGf00@0ZmGf0P0000060:cNn@8000000`2Rgo`3000000P0VnKl1000
000507CNl`T000000`12a=8L0000000303:ajP000000000000P0C[[i0P00000806W0oP8000001@1n
`_d01@000000O/;m07k2o@1n`_d0000000T0SL;i2000000509:om@030000003oool0oooo01<0oooo
0`00000;0?ooo`050?oDV`00000000000000002Ke?l0=@3oool002L0oooo00<0/5d00000G@2`ool0
0P3oool00`3GR5d0R=Oo0?ooo`0V0?ooo`<00000J@3oool2000000T0/=;b0P0000020:_EmP800000
2P2/g_T3000000P0VnKl0`00000408kYmQH000001@1CbO02000000807ZGQ2@0000000`0;VM800000
0000000201^Oh`T00000101>^_T00`000000JL3n06W0oP0706W0oP030000001n`_d0O/;m0080O/;m
00<0000007k2o@1n`_d00P1n`_d010000000SL;i08g2n@2=`_T5000000<0QKgi00<0000009:om@2B
_oD0202B_oD00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00H0^W:K0=Coo`3o
ool0oooD09/0V`3Doold0?ooo`00:03oool00`3o/5d0000b08SGo`0X0?ooo`@00000I`3oool30000
00`0/=;b0`00000:0:cNn@8000000`2/j?T2000000<0VnKl0`00000508kYmP<000000`1oinX20000
00<0N>CS0P00000308;Xj@8000000P2IjoP2000000H0DlW`2@0000000`0NYN4000000000000200bB
g@L000000`0KWn<200000080>J_c7000000808Fmn@030000002B_oD0T[oe00P0T[oe00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`060?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:j
jP3oool0<`3oool002T0oooo00<0omN80380000bR=L09@3oool2000006T0oooo0P0000020;?=k@80
00002@2`d_8200000080]=[c0P0000060:cNn@<000001`2/j?T4000000@0S^Wf0`00000407oWjP80
00000`1hi><2000000<0P^SY0P00000609W[n0H000001@1eaOl010000000@JKf046VmP11Y_H70000
00<039;M2@00000603V[l`030000001I]O`0FKGl00L0FKGl00D0000007:ko01b^o`0L[_l00000005
07:ko00300000025_OT0QKgi00P0QKgi00<0000009:om@2B_oD0202B_oD00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo00H0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0c
0?ooo`007P3oool00`2jLP0000000000000300000003000bR03oool0oooo00@0oooo00<0R38003:8
e`3oool0803oool3000006T0oooo0P0000060;?=k@030000002`d_80/=;b00@0/=;b0P0000060;CJ
l`8000000P2/g_T2000000T0[>Si0P0000030:_`m`D00000101oinX2000000<0N>CS0P00000308;X
j@8000001P2IjoP200000080[=[h0P00000807G5o`8000001P11Y_H00`0000009i7^000000060000
00<05Y?V1@00000403V[l`030000001I]O`0FKGl00L0FKGl00@0000007:ko01b^o`000001P1b^o`0
0`000000QKgi08Fmn@0808Fmn@030000002B_oD0T[oe00H0T[oe0`00000G0?ooo`030000003oool0
oooo00D0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0c0?ooo`00;03oool00`28
<Ud0/?oo0?ooo`0L0?ooo`<00000JP3oool2000000T0/lg]0P0000020;3BlP8000002P2df_<20000
00T0[>Si0P0000050:_`m`8000000`2/mO4?000000@0VN_h0`0000060:cJn0800000201eaOl00`00
0000@JKf046VmP04046VmP800000100WTNh4000000@05Y?V00<00000032Ml@0000000`0000000`0i
Zo<0000005Veo00705Veo0040000001b^o`0L[_l000000H0L[_l00<0000008Fmn@25_OT02025_OT0
10000000T[oe09:om@2B_oD5000000<0S[_d00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`040?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0<`3oool002L0oooo00<0ehPb
05f`o`3oool00P3oool00`2`G@00GK3o0?ooo`0J0?ooo`800000J`3oool2000000d0/lg]0P00000:
0;CJl`80000000<0^^?d0000000000001P2/j?T2000000D0Zo3g0P0000050:cel@8000000`2bn>`2
000000<0__W/0P0000030<cbj`@000002P2/f_P?000000<0@JKf00<0000002NAkP0WTNh0100WTNh4
000000805Y?V00<00000032Ml@0`WO400P0`WO47000000@0FKGl00<0000007:ko00000001`1b^o`0
0`000000QKgi08Fmn@0408Fmn@L00000202>^o@00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo00@0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0c0?ooo`009`3oool01`3o
/5d0001M0;3oo`3oool0ok1M0000<P28eol0603oool3000000030?ooo`000000000006P0oooo0P00
00000`2danP000000;?=k@0:0;?=k@80000000<0^]?]0000002df_<01`2df_<2000000D0^^?d0P00
00020:cXn@8000001@2[l?L2000000D0[?Ga0P0000040;;hk0030000002nnN`0__W/0080__W/00<0
00000<cbj`3<l^/0103<l^/00`000000cmgS000000080:cJn08000000P2^^n<00`000000RJ_/08V[
k00608V[k0040000001SV>d0HiS]06>Hk@L00000100WTNh00`0000009Xg]02J=k@04000000H0<9ga
00@0000004nYn@1?ZOT0CjWi5@00000507nhn0030000002>^o@0S[_d00P0S[_d00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`040?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo=03oool0
02P0oooo00D0ok1M000000000000000b08SGo`0G0?ooo`800000K03oool2000000@0]<OX00<00000
0;?=k@2ccNd01P2ccNd2000000@0^]?]0P0000040;CJl`8000002@2jho@4000000<0Zo3g0P000005
0:cel@800000102bn>`2000000<0__W/0P0000050<cbj`8000000`3?gN<00`000000[=[h0:cJn003
0:cJn0800000102^^n<00`000000RJ_/08V[k00608V[k0030000001SV>d0HiS]00H0HiS]00<00000
04^:jP0000000`0000000`0WTNh0000002J=k@0302J=k@@00000100`WO42000000L0CjWi00<00000
06^bnP1[/_X01`1[/_X00`000000OkSh07nhn00707nhn0030000002>^o@0S[_d00T0S[_d00<00000
0?ooo`3oool0503oool2000000D0oooo00D0oooD09/000000000001b0;[Zo`0e0?ooo`00@@3oool3
000006`0oooo0P0000070;C7j0030000002ccNd0/lg]00<0/lg]0P0000080;[Ck@040000002df_<0
0000000000X0^^?d0P0000030<7/l@D000000`2/mO42000000D0/_S/00<000000;kik02nnN`00P2n
nN`00`000000c?;[0<cbj`040<cbj`030000003?gN<0cmgS00@0cmgS00<000000:cJn02/f_P00P00
00070:jkh`0300000029Zn`0RJ_/00H0RJ_/00<0000006>Hk@1SV>d01@1SV>d00`000000Bh[Z04^:
jP0304^:jP@00000100VSNd00`000000>9?a0000000400000003032Ml@000000CjWi00D0CjWi0`00
000806^bnP030000001o^?P0OkSh00L0OkSh00<0000008jkm02>^o@0202>^o@00`000000oooo0?oo
o`0B0?ooo`80000000<0oooo0000003oool0?P3oool003h0oooo0`00001]0?ooo`8000002P2danP0
0`000000/lg]0;?=k@02000000/0^]?]00<000000;[Sm02jho@02@2jho@00`000000`Nca0<7/l@04
0<7/l@040000003:l^`0b_;/0<[bk0D000000`2bn>`2000000<0__W/0P0000060<cbj`030000003?
gN<0cmgS00H0cmgS0P00000:0:jkh`0300000029Zn`0RJ_/00H0RJ_/00<0000006>Hk@1SV>d01@1S
V>d00`000000Bh[Z04^:jP0504^:jP@000000P0VSNd2000000@0>9?a1`0000001@1?ZOT0000004nY
n@1?ZOT0000000L0Jk;j00<0000007nhn01o^?P0201o^?P00`000000S[_d08jkm00608jkm0<00000
5`3oool00`000000oooo0?ooo`0l0?ooo`00?03oool4000006/0oooo0`00000=0;C7j08000002`2j
dnd2000000030<;Ij`000000000000L0^^?d0P0000050<7/l@8000001@3:l^`010000000do?V0=?c
iP3ClnH9000000D0c?;[0P0000080<oMh`0300000038`mD0000000X0[[_S00<0000008V[k029Zn`0
1P29Zn`00`000000HiS]06>Hk@0606>Hk@030000001;R^X0Bh[Z00@0Bh[Z00@0000004>6j@13Q^T0
@hKY1@00000603RCl@040000001@W_D0D9ke052Nm@X000000`1[/_X00`000000OkSh07nhn00707nh
n0040000002>^o@0S[_d08jkm0D000000`2;]_<00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo03/0oooo000j0?ooo`800000K@3oool200000080]<7S00<000000;C7j02danP02@2danP20000
00030;_:iP000000^]?]00T0^]?]00<000000<;Ij`32fN/00`32fN/00`000000^^?d0;[Sm0030;[S
m00300000031k?40`Nca00@0`Nca00<000000<[bk03:l^`0103:l^`00`000000do?V0=?ciP030=?c
iP030000003Ll=h0g?3N0080g?3N00<000000>7Ve`3Qi]L00P0000020<cbj`030000003?gN<0cmgS
00L0cmgS00D000000<S3e@38`mD0b<?E0000000:0:jkh`h000000`1SV>d00`000000Bh[Z04^:jP05
04^:jP0300000013Q^T0@hKY00@0@hKY0`00000503RCl@<000000P1@W_D01@000000D9ke052Nm@1@
W_D0000000<0J:Wf4@00000908^fl`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>`3o
ool003L0oooo0`00001]0?ooo`8000001@2d`N<00`000000]<OX0;C7j0070;C7j0030000002kb^H0
^l[V0080^l[V00<000000;[Ck@2jdnd01@2jdnd2000000L0`]W[0P0000000`2jho@0000000000006
0<7/l@030000003:l^`0b_;/00@0b_;/00<000000=?ciP3ClnH00`3ClnH00`000000g?3N0=c`gP02
0=c`gP030000003Qi]L0hNKG00<0hNKG0P0000090<oMh`0300000038`mD0b<?E0080b<?E00<00000
0:jkh`2^^n<01P2^^n<3000000T0Si?C00@0000007N7eP1gQmH0MhOF1P00000604^:jP0300000013
Q^T0@hKY00D0@hKY1`000004052Nm@050000001@W_D0D9ke052Nm@000000201XZOH00`000000O;7e
07bam@0707bam@030000002;]_<0RkKc00P0RkKc00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0j0?ooo`00=@3oool2000006h0oooo0P0000080;C1h`030000002danP0]<OX00@0]<OX0P00
00060;_:iP800000102jdnd00`000000`]W[0<;Ij`090<;Ij`8000001@31k?42000000D0b_;/0P00
00050=?ciP030000003Ll=h0g?3N0080g?3N00<000000>7Ve`3Qi]L0103Qi]L00`000000gmO?0000
00060<oMh`8000001P38`mD00`000000[[_S0:jkh`030:jkh`8000000`2XWlh00`000000Si?C08nC
d`0608nCd`030000001gQmH0MhOF00H0MhOF1000000404^:jP0300000013Q^T0@hKY00@0@hKY0`00
00000`1;Rn/0000000000002000000@0D9ke00D00000052Nm@1@W_D0D9ke0000000806RYmP030000
001l/OD0O;7e00L0O;7e00<0000008^fl`2;]_<0202;]_<00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo03T0oooo000c0?ooo`800000KP3oool2000000/0]<7S00<000000;C7j02danP00P2d
anP00`000000^l[V0;_:iP080;_:iP040000002jdnd00000000000X0`]W[0P0000020<_Oi`800000
0P31k?400`000000b_;/0<[bk0040<[bk0030000003ClnH0do?V00<0do?V0P0000040=c`gP030000
003Qi]L0hNKG00@0hNKG00@000000=oGc`3Oell0gmO?0P0000030<oMh`0300000038`mD0b<?E00L0
b<?E00<000000:jkh`2^^n<00P0000050:ROcP030000002?Tm<0Si?C00L0Si?C00<0000007N7eP1g
QmH01@1gQmH010000000IX3H06J0f01VP=P5000000@0@hKY0P0000000`13Q^T0000004^;j`0404^;
j`@000000P1@W_D01@000000D9ke052Nm@1@W_D0000000P0J:Wf00<0000007bam@1l/OD01`1l/OD0
0`000000RkKc08^fl`0808^fl`030000003oool0oooo01@0oooo00<000000?ooo`3oool0>@3oool0
03<0oooo0P00001/0?ooo`80000000<0/[[O0000002d`N<02`2d`N<010000000]<OX00000000000<
0;_:iP0300000032fN/0`]W[00P0`]W[0P0000060<_Oi`<000001@3:l^`00`000000do?V0=?ciP03
0=?ciP030000003Ll=h0g?3N00<0g?3N00<000000>7Ve`3Qi]L0103Qi]L00`000000gmO?0=oGc`04
0=oGc`030000003?gN<0000000/0b<?E0P0000080:ROcP030000002?Tm<0Si?C00H0Si?C00<00000
07N7eP1gQmH01P1gQmH00`000000IX3H06J0f00406J0f0D000001013Q^T00`000000Bh_[04^;j`04
04^;j`030000001JUNh0000000@0000000<0D9ke0000001XZOH0201XZOH00`000000O;7e07bam@07
07bam@030000002;]_<0RkKc00@0RkKc1@00000F0?ooo`030000003oool0oooo03P0oooo000b0?oo
o`@00000J@3oool2000000@0/[[O00<000000;C1h`2d`N<02P2d`N<00`000000^l[V0;_:iP0:0;_:
iP80000000<0`lgR00000032fN/01`32fN/00`000000bmoW0<_Oi`060<_Oi`030000003Eh^40eN;Q
008000000P3:l^`00`000000do?V0=?ciP030=?ciP030000003Ll=h0g?3N00@0g?3N00<000000>7V
e`3Qi]L00`3Qi]L00`000000gmO?0=oGc`060=oGc`0300000038`mD0b<?E00T0b<?E0P0000090:RO
cP030000002?Tm<0Si?C00L0Si?C00<0000007N7eP1gQmH01@1gQmH00`000000IX3H06J0f00306J0
f0<000000P1NOm/40000000304>6j@000000Bh_[00H0Bh_[00H0000005ZEkP1JUNh0FYG^0000001J
UNhL000000D0Rk7`00<000000?ooo`3oool04@3oool2000000030?ooo`000000oooo03P0oooo000c
0?ooo`040000003oool0oooo000006H0oooo0P0000070;:jg`030000002d`N<0]<7S00L0]<7S0P00
00000`2j`Ml000000;_:iP090;_:iP0300000033cN80`lgR0080`lgR0P0000040<;Ij`800000203;
gnL00`000000eN;Q0=GRh@030=GRh@@000000`3ClnH00`000000g?3N0=c`gP040=c`gP030000003Q
i]L0hNKG00<0hNKG00<000000=oGc`3Oell01P3Oell00`000000fLK7000000080<S3e@8000000P2n
ZlL00`000000Z9o>0:ROcP070:ROcP030000002?Tm<0Si?C00H0Si?C00<0000007N7eP1gQmH01P1g
QmH00`000000IX3H00000002000000<0IX3H00<0000005iof`1NOm/00`1NOm/4000000D0Bh_[00<0
000005ZEkP1JUNh00P1JUNh01@000000FYG^05ZEkP1JUNh0000000T0K:3`00<0000007fZl01mZ_00
1`1mZ_000`000000Rk7`08^al00708^al0030000003oool0oooo01@0oooo00<000000?ooo`3oool0
=`3oool00380oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1Q0?ooo`8000002@2b
^]l00`000000]<7S0;C1h`050;C1h`800000102j`Ml00`000000^l[V0;_:iP050;_:iP8000001`33
cN8010000000`]W[0000000000090<_Oi`030000003Eh^40eN;Q00@0eN;Q00@000000=gSf03MhmP0
gN?H100000050=c`gP030000003Qi]L0hNKG00@0hNKG00<000000=oGc`3Oell01@3Oell010000000
fLK70=W6a`0000070<S3e@030000002nZlL0_Z_70080_Z_700<000000:ROcP2XWlh01`2XWlh00`00
0000Si?C08nCd`0708nCd`030000001gQmH0MhOF00@0MhOF0`00000606J0f0030000001NOm/0GWoK
00D0GWoK00<000000625g`0000000P00000304^;j`030000001JUNh0FYG^0080FYG^00@0000005ZE
kP1JUNh000002@1/X?000`000000OJ[`07fZl00707fZl0030000002;/O00Rk7`00P0Rk7`00<00000
0?ooo`3oool0503oool00`000000oooo0?ooo`0f0?ooo`00<P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo05h0oooo0P00000<0;:jg`030000002d`N<0]<7S0080]<7S0P0000070;[1
g`800000102kb^H00`000000`lgR0<?=hP080<?=hP030000003;gnL0bmoW00L0bmoW0P0000060=GR
h@030000003MhmP0gN?H00<0gN?H00<000000>?Od03Sgm000P0000020=c`gP030000003Qi]L0hNKG
00@0hNKG00<000000=oGc`3Oell01@3Oell00`000000fLK70=W6a`020=W6a`0300000038`mD0b<?E
00<0b<?E00<000000;j[a`2nZlL0102nZlL00`000000Z9o>0:ROcP070:ROcP030000002?Tm<0Si?C
00H0Si?C00@0000007N7eP1gQmH0MhOF0`00000207N7eP030000001VP=P0IX3H00D0IX3H00<00000
05iof`1NOm/01@1NOm/010000000H8GO0625g`1PQMl5000000@0FYG^00@0000005ZEkP1JUNh00000
2@1/X?000`000000OJ[`07fZl00707fZl0030000002;/O00Rk7`00P0Rk7`00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0e0?ooo`00<P3oool2000000D0oooo00<000000?ooo`3oool0F`3o
ool200000080[kGM00<000000;:jg`2b^]l02P2b^]l010000000]<7S00000000000;0;[1g`040000
002kb^H00000000000X0`lgR00@000000<c@g000000000001P3;gnL00`000000eN;Q0=GRh@050=GR
h@030000003MhmP0gN?H00<0gN?H00<000000>?Od03Sgm000`3Sgm03000000D0hNKG00<000000=oG
c`3Oell01@3Oell00`000000fLK70=W6a`040=W6a`0300000038`mD0b<?E008000001`2nZlL00`00
0000Z9o>0:ROcP070:ROcP030000002?Tm<0Si?C00<0Si?C2@00000307N7eP030000001VP=P0IX3H
00D0IX3H00<0000005iof`1NOm/01@1NOm/00`000000H8GO0625g`050625g`@0000000<0FYG^0000
001JUNh00P1JUNh00`000000K:3`06bPl00606bPl0030000001mZ_00OJ[`00P0OJ[`00<0000008^a
l02;/O001`2;/O000`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03D0oooo000a0?ooo`80
00001`3oool00`000000oooo0?ooo`1H0?ooo`8000001@2_]Md00`000000/[[O0;:jg`0:0;:jg`03
0000002j`Ml0^/7O00`0^/7O00<000000<?=hP33cN802033cN82000000@0c=3L00<000000<_Oi`3;
gnL00P3;gnL00`000000eN;Q0=GRh@050=GRh@030000003MhmP0gN?H00@0gN?H00<000000>?Od03S
gm000`3Sgm000`000000i]S80>KHb00200000080hNKG00<000000=oGc`3Oell01@3Oell00`000000
fLK70=W6a`050=W6a`0300000038`mD0000000X0_Z_700<000000:ROcP2XWlh01P2XWlh600000003
0964`@0000000000008000001023OL@7000000D0IX3H00<0000005iof`1NOm/01@1NOm/00`000000
H8GO0625g`060625g`030000001XSn@0000000<0000000<0FYG^0000001/X?00201/X?000`000000
OJ[`07fZl00707fZl0030000002;/O00Rk7`00@0Rk7`1@00000F0?ooo`030000003oool0oooo03@0
oooo000b0?ooo`030000003oool0oooo00H0oooo0P00001F0?ooo`800000202_]Md00`000000/[[O
0;:jg`070;:jg`80000000<0]kSJ0000002j`Ml02P2j`Ml2000000030<71fP000000`lgR00L0`lgR
00<000000<c@g03<d=`01@3<d=`2000000030<_Oi`000000eN;Q00H0eN;Q00<000000=gSf03MhmP0
103MhmP00`000000hmo@0>?Od0030>?Od0030000003Vf<P0i]S800<0i]S80P0000080=oGc`030000
003Ia/L0fLK700H0fLK700<000000;j[a`2nZlL02@2nZlL00`000000Z9o>0:ROcP030:ROcP<00000
00<0XXjo0000002AQ<400P2AQ<42000000@0THC100<0000008=ma023OL@01@23OL@00`000000N7[8
07Qjb0040000000306J0f0000000GWoK00H0GWoK00<000000625g`1PQMl01P1PQMl00`000000J8oT
06R?i00206R?i0P00000101/X?000`000000OJ[`07fZl00407fZl0X000001@2=[N`00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo03<0oooo000b0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0D03oool3000000X0[kGM00<000000;:jg`2b^]l01@2b^]l2000000@0]kSJ00<0
00000;[1g`2j`Ml01`2j`Ml00`000000`L7J0<71fP020<71fP0300000033cN80`lgR00@0`lgR00<0
00000<c@g03<d=`0203<d=`00`000000eN;Q0=GRh@050=GRh@030000003MhmP0gN?H00@0gN?H00<0
00000>?Od03Sgm00103Sgm000`000000i]S80>KHb0030>KHb0030000003Ud<80000000H0gmO?00<0
00000=W6a`3Ia/L01P3Ia/L00`000000ckG00000000;0;j[a`030000002XWlh00000008000001@2R
S[l3000000H0THC100<0000008=ma023OL@01P23OL@00`000000N7[807Qjb00307Qjb0D000001@1N
Om/00`000000H8GO0625g`060625g`030000001XSn@0J8oT0080J8oT00@0000006R?i01XSn@00000
0`1eV^P;000000D0PZGZ00<0000008f]k02=[N`01`2=[N`00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo03<0oooo000a0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0C@3o
ool200000080[;7K00<000000:neg@2_]Md02@2_]Md00`000000/[[O0;:jg`020;:jg`8000001`2g
^=X00`000000^/7O0;[1g`040;[1g`8000001P31`MX010000000`lgR0<?=hP33cN82000000X0c=3L
00@000000=GAe@0000000000103Eh^400`000000gN?H0=gSf0040=gSf0030000003Sgm00hmo@00@0
hmo@00<000000>KHb03Vf<P0103Vf<P00`000000iM320>G@`P02000000<0gmO?00<000000=W6a`3I
a/L01P3Ia/L010000000ckG00<ne`000000;0;j[a`8000001@2RS[l4000000P0THC100<0000008=m
a023OL@01P23OL@00`000000N7[807Qjb00507Qjb0030000001bNld0LW_=00@0000000<0GWoK0000
001PQMl01`1PQMl00`000000J8oT06R?i00206R?i0040000001XSn@0J8oT000000T0MI[X00<00000
08:UjP22YNX01`22YNX00`000000SJg/08f]k00808f]k0030000003oool0oooo0180oooo00<00000
0?ooo`000000=03oool00340oooo0P00000<0?ooo`030000003oool0oooo04X0oooo0P0000040:ba
f`030000002_]Md0[kGM00X0[kGM00@000000;:jg`00000000002P2g^=X00`000000^/7O0;[1g`02
0;[1g`0300000031`MX0`L7J00L0`L7J00<000000<?=hP0000002`3<d=`00`000000eM7E0=GAe@02
0=GAe@80000000<0eN;Q0000003MhmP01@3MhmP00`000000hmo@0>?Od0040>?Od0030000003Vf<P0
i]S800@0i]S800<000000>G@`P3Ud<800`3Ud<800`000000gmO?000000090=W6a`050000003?]L00
ckG00<ne`00000002@2nZlL2000000<0XXjo0`0000040::>_`030000002AQ<40THC100H0THC100<0
000008=ma023OL@01@23OL@00`000000N7[807Qjb00607Qjb0030000001bNld0LW_=00<0LW_=1@00
00060625g`030000001XSn@0J8oT0080J8oT00@0000006R?i01XSn@00000201eV^P00`000000PZGZ
08:UjP0808:UjP030000002=[N`0SJg/00L0SJg/00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0a0?ooo`00<@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo04L0oooo0P00
00070:baf`030000002_]Md0[kGM00X0[kGM00<000000;NhfP2g^=X02`2g^=X010000000^/7O0000
0000000;0<71fP030000003<d=`0c=3L00T0c=3L00<000000=GAe@3EdMD01@3EdMD00`000000gN?H
0=gSf0040=gSf0030000003Sgm00hmo@00@0hmo@00<000000>KHb03Vf<P0103Vf<P00`000000iM32
0>G@`P050>G@`P030000003Ia/L0fLK700L0fLK700<000000<ne`03?]L000P3?]L000`000000_Z_7
0;j[a`060;j[a`030000002dVKd0]9Vm00<000001`2RS[l00`000000THC10964`@060964`@030000
0023OL@0Pgg400H0Pgg400<0000007Qjb01hN/P01@1hN/P00`000000LW_=079kc@05079kc@030000
001bPM<0LX7C00D0000000<0H8GO0000001XSn@0101XSn@010000000J8oT06R?i000000807FJj003
00000022YNX0PZGZ00L0PZGZ00<0000008f]k02=[N`0202=[N`00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo0340oooo000a0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
@`3oool3000000X0[;7K00<000000:neg@2_]Md01`2_]Md2000000030;:ae`000000]kSJ00`0]kSJ
00<000000<71fP31`MX02P31`MX00`000000b<7C000000090<c@g0030000003EdMD0eM7E00D0eM7E
00@000000=cAc@0000000000103MhmP00`000000hmo@0>?Od0040>?Od0030000003Vf<P0i]S800@0
i]S800<000000>G@`P3Ud<80103Ud<800`000000hLJm000000070=W6a`030000003?]L00ckG000@0
ckG000<000000;j[a`2nZlL0102nZlL5000000T0XXjo00<000000964`@2AQ<401P2AQ<400`000000
Pgg408=ma00608=ma0030000001hN/P0N7[800H0N7[800<00000079kc@1bNld01@1bNld00`000000
LX7C07:1d`0407:1d`D000000P1XSn@01@000000J8oT06R?i01XSn@0000000P0MI[X00<0000008:U
jP22YNX01`22YNX00`000000SJg/08f]k00708f]k0030000003oool0oooo01D0oooo00<000000?oo
o`3oool0<03oool00340oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`100?ooo`80
00000P2Y[]/00`000000[;7K0:baf`090:baf`030000002_]Md0[kGM00@0[kGM0P0000030;:ae`03
0000002g^=X0]kSJ00T0]kSJ0P0000000`2l]m@000000<71fP090<71fP0500000038`M<0b<7C0<S1
d`0000001`3<d=`00`000000eM7E0=GAe@050=GAe@030000003LdLd0g=7=0080g=7=0P0000000`3M
hmP000000>?Od0050>?Od0030000003Vf<P0i]S800@0i]S800<000000>G@`P3Ud<801@3Ud<801000
0000hLJm0>76_@0000050=W6a`030000003?]L00ckG000D0ckG000<000000;j[a`2nZlL00P2nZlL3
000000@0]9Vm00<000000::>_`2RS[l01`2RS[l00`000000THC10964`@050964`@0300000023OL@0
Pgg400H0Pgg400<0000007Qjb01hN/P01P1hN/P00`000000LW_=079kc@05079kc@030000001bPM<0
LX7C00H0LX7C00<0000007N;fP1gRmX01@0000000`1XSn@0000007FJj00707FJj00300000022YNX0
PZGZ00L0PZGZ00<0000008f]k02=[N`0102=[N`5000001L0oooo00<000000?ooo`3oool0;`3oool0
0340oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0m0?ooo`800000102Y[]/00`00
0000[;7K0:baf`090:baf`030000002_]Md0[kGM0080[kGM0P0000060;:ae`030000002g^=X0]kSJ
00H0]kSJ0P0000030;bge00300000031`MX0`L7J00L0`L7J00<000000<S1d`38`M<00`38`M<00`00
0000c=3L0<c@g0030<c@g0030000003EdMD0eM7E00D0eM7E00<000000=cAc@3LdLd01@3LdLd00`00
0000hmo@0>?Od0040>?Od0030000003Vf<P0i]S800@0i]S800<000000>G@`P3Ud<801@3Ud<801@00
0000hLJm0>76_@3Qa[d0000000@0fLK700<000000<ne`03?]L001`3?]L04000000L0]9Vm00<00000
0::>_`2RS[l01`2RS[l00`000000THC10964`@060964`@0300000023OL@0Pgg400H0Pgg400<00000
07Qjb01hN/P01P1hN/P00`000000LW_=079kc@05079kc@030000001bPM<0LX7C00H0LX7C00<00000
07N;fP1gRmX00`1gRmXL000000D0TJ_W00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0_
0?ooo`00<03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03X0oooo0P0000070:V^
f`030000002//M/0[;7K00T0[;7K00@000000:neg@00000000002@2b/ML00`000000]kSJ0;NhfP04
0;NhfP030000002l]m@0_;OD00@0_;OD00<000000<71fP31`MX01031`MX2000000L0b<7C00D00000
0<c@g03<d=`0c=3L000000070=GAe@030000003LdLd0g=7=00D0g=7=00@000000>;?a@0000000000
0`3Sgm000`000000i]S80>KHb0040>KHb0030000003Ud<80iM3200D0iM3200<000000>76_@3Qa[d0
0`3Qa[d01@000000fLK70=W6a`3Ia/L0000000P0ckG00P0000000`2nZlL000000;BI_@070;BI_@03
0000002RS[l0XXjo00L0XXjo00<000000964`@2AQ<401P2AQ<400`000000Pgg408=ma00608=ma003
0000001hN/P0N7[800H0N7[800<00000079kc@1bNld01@1bNld00`000000LX7C07:1d`0607:1d`03
0000001gRmX0Mh_J00@0Mh_J00<0000007N;fP0000002@1oU]l00`000000R:7T08RQi00708RQi003
0000002AZnL0TJ_W00L0TJ_W00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0^0?ooo`00
<03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo03H0oooo0`00000:0:V^f`030000
002//M/0[;7K00P0[;7K0P00000<0;:ae`040000002g^=X0]kSJ0;NhfP800000202l]m@00`000000
`L7J0<71fP020<71fP0300000038`M<0b<7C00P0b<7C00<000000<c@g00000001`3EdMD00`000000
g=7=0=cAc@050=cAc@030000003RclD0h/o50080h/o50P0000000`3Sgm0000000>KHb0050>KHb003
0000003Ud<80iM3200D0iM3200<000000>76_@3Qa[d0103Qa[d00`000000fLK7000000060<ne`0<0
00000P3?]L000`000000]9Vm0;BI_@080;BI_@030000002RS[l0XXjo00L0XXjo00<000000964`@2A
Q<401@2AQ<400`000000Pgg408=ma00608=ma0030000001hN/P0N7[800L0N7[800<00000079kc@1b
Nld01@1bNld00`000000LX7C07:1d`0607:1d`030000001gRmX0Mh_J00<0Mh_J00@0000007N;fP1g
RmX00000201oU]l00`000000R:7T08RQi00708RQi0030000002AZnL0TJ_W00P0TJ_W00<000000?oo
o`3oool04`3oool3000002l0oooo000`0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool0<P3oool300000080YJgL00<000000:V^f`2Y[]/02@2Y[]/00`000000[;7K0:baf`050:baf`80
00000P2^[=D00`000000/[7G0;:ae`090;:ae`040000002g^=X00000000000/0_;OD00@000000<71
fP31`MX000003038`M<00`000000eM7E0=GAe@060=GAe@030000003LdLd0g=7=00D0g=7=00<00000
0>;?a@3RclD0103RclD00`000000i]S80>KHb0040>KHb0030000003Ud<80iM3200D0iM3200<00000
0>76_@3Qa[d01P3Qa[d00`000000ckG00<ne`0020<ne`0<00000103?]L02000000X0]9Vm00<00000
0::>_`2RS[l01`2RS[l00`000000THC10964`@060964`@0300000023OL@0Pgg400H0Pgg400<00000
07Qjb01hN/P01P1hN/P00`000000LW_=079kc@05079kc@030000001bPM<0LX7C00H0LX7C00<00000
07N;fP1gRmX0101gRmX00`000000Mh_J0000000907nFg`0300000028XN@0R:7T00L0R:7T00<00000
096[i`2AZnL0202AZnL00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02d0oooo000`0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool0;P3oool3000000D0YJgL00<000000:V^
f`2Y[]/02@2Y[]/00`000000[;7K0:baf`030:baf`800000102^[=D00`000000/[7G0;:ae`0:0;:a
e`030000002l]m@0_;OD00/0_;OD00<000000<71fP0000003038`M<00`000000d<;=000000060=GA
e@030000003LdLd0g=7=00D0g=7=00<000000>;?a@3RclD0103RclD010000000iLfo000000000003
0>KHb0030000003Ud<80iM3200D0iM3200<000000>76_@3Qa[d01P3Qa[d2000000040<ne`0000000
0000000000H0ckG000@000000<BV^`34Y[/000002@2dVKd00`000000XXjo0::>_`080::>_`030000
002AQ<40THC10080THC14@00000507Qjb0030000001bNld0LW_=00D0LW_=00<0000007:1d`1bPM<0
1P1bPM<00`000000Mh_J07N;fP0407N;fP030000001gRmX0000000P0OiKO00<0000008RQi028XN@0
1`28XN@00`000000TJ_W096[i`08096[i`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
;03oool002l0oooo1000000E0?ooo`030000003oool0oooo02X0oooo0`0000090:F]g0030000002Y
[]/0ZJkK00T0ZJkK00<000000:baf`2//M/00P0000070:j/e@030000002b/ML0/[7G00L0/[7G0P00
00000`2f[]0000000;bge00<0;bge00300000038`M<0b<7C00X0b<7C00@000000=32c@3@`/d0d<;=
0P0000030=GAe@030000003LdLd0g=7=00D0g=7=00<000000>;?a@3RclD01@3RclD010000000iLfo
0>G=_`3UcKl2000000030>KHb0000000iM3200H0iM3200<000000>76_@3Qa[d01P3Qa[d3000000P0
ckG000D000000<BV^`34Y[/0a:Jk0000000:0;BI_@030000002RS[l0XXjo00H0XXjo1P00000309=l
]`030000002;NKX0RgVj00H0RgVj00<0000008Ah_@24N;d00P24N;d:000000<0LW_=00<0000007:1
d`1bPM<01P1bPM<00`000000Mh_J07N;fP0507N;fP8000002@1oU]l00`000000R:7T08RQi00708RQ
i0030000002AZnL0TJ_W00H0TJ_W0`00000F0?ooo`030000003oool0oooo02`0oooo000`0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool09`3oool200000080XjgN00<000000:F]g02U
[M`0202U[M`00`000000ZJkK0:V^f`080:V^f`<000002@2^[=D00`000000/[7G0;:ae`060;:ae`05
0000002f[]00]Zk@0;J^d0000000302l]m@00`000000`[G>0000000:0<S1d`030000003@`/d0d<;=
00@0d<;=00<000000=GAe@0000001`3LdLd00`000000h/o50>;?a@050>;?a@030000003UcKl0iLfo
00@0iLfo00<000000>G@`P3Ud<801@3Ud<800`000000hLJm0>76_@040>76_@<000000P3K_;X00`00
0000ckG00<ne`0050<ne`00300000034Y[/0a:Jk0080a:Jk00<000000;BI_@2dVKd0202dVKd00`00
0000XXjo0::>_`030::>_`<0000000<0WX>f0000002CO;L01`2CO;L00`000000RgVj08]i^P0608]i
^P0300000024N;d0Q7Rm00H0Q7Rm00<00000085k``21Nl<00P21Nl<9000000@0LX7C00<0000007N;
fP1gRmX0101gRmX00`000000Mh_J0000000907nFg`0300000028XN@0R:7T00H0R:7T00@00000096[
i`2AZnL0TJ_W1@00000309JYh`030000003oool0oooo01@0oooo00<000000?ooo`3oool0:`3oool0
0140oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00@0oooo00<0omBK
0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool08`3oool3000000@0XjgN00<000000:F]g02U[M`02@2U[M`00`000000ZJkK0:V^f`05
0:V^f`8000000P2YZ=D00`000000[ZcE0:j/e@080:j/e@030000002b/ML0/[7G00<0/[7G0P000005
0;J^d0030000002l]m@0_;OD00L0_;OD0P0000020<:ecP0300000038`M<0b<7C00L0b<7C00<00000
0=32c@3@`/d01P3@`/d00`000000g=7=0=cAc@060=cAc@030000003RclD0h/o500@0h/o500<00000
0>G=_`3UcKl0103UcKl00`000000i/Vj000000060>G@`P040000003Qa[d0hLJm0>76_@<0000000<0
hLJm0000003K_;X00`3K_;X00`000000ckG00<ne`0030<ne`00300000034Y[/0a:Jk00@0a:Jk00<0
00000;BI_@2dVKd0202dVKd00`000000XXjo00000002000000@0WX>f00<0000009=l]`2CO;L01P2C
O;L00`000000RgVj08]i^P0608]i^P0300000024N;d0Q7Rm00L0Q7Rm00<00000085k``21Nl<01@21
Nl<00`000000PH7:0861bP020861bPT000000`1gRmX2000000T0OiKO00<0000008RQi028XN@00`28
XN@7000000P0UZWS00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0Z0?ooo`004@3oool0
1P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@01`3oool00`2jLW80^^[o
0?ooo`070?ooo`030000003oool0oooo01T0oooo0P00000P0?ooo`<00000202S[Mh00`000000YJgL
0:F]g0080:F]g0030000002Y[]/0ZJkK00<0ZJkK0P0000040:VXe@030000002^[=D0[ZcE00T0[ZcE
00D000000;:ae`2b/ML0/[7G000000080;J^d0030000002l]m@0_;OD00D0_;OD00<000000<:ecP32
]Lh00`32]Lh00`000000b<7C0<S1d`040<S1d`800000203@`/d00`000000e/;6000000060=cAc@03
0000003RclD0h/o500D0h/o500<000000>G=_`3UcKl0103UcKl010000000i/Vj0>K9^P0000040>G@
`P030000003Qa[d0000000800000103Qa[d00`000000fkbj0=^l^P020=^l^P030000003?]L00ckG0
0080ckG000<000000<BV^`34Y[/01@34Y[/00`000000]9Vm0;BI_@080;BI_@800000202NPkH00`00
0000Tgbg09=l]`0509=l]`030000002;NKX0RgVj00H0RgVj00<0000008Ah_@24N;d01`24N;d00`00
0000PG_3085k``06085k``0300000021PLX0PH7:00D0PH7:00<0000008F:d@25R]400P25R]4D0000
00D0T9oN00<0000009JYh`2FZN<0202FZN<00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
02X0oooo000@0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03@3oool00`2jLW80
^^[o0?ooo`070?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool06P3oool300000080
XJkP00<000000:>]gP2S[Mh01`2S[Mh00`000000YJgL0:F]g0080:F]g0030000002Y[]/0ZJkK0080
00001`2YZ=D00`000000[ZcE0:j/e@080:j/e@040000002b/ML00000000000X0]Zk@00<000000;bg
e02l]m@00`2l]m@00`000000`[G>0<:ecP050<:ecP0300000038`M<0b<7C0080b<7C00<000000=32
c@3@`/d01`3@`/d01@000000e/;60=K2aP3F`/H0000000@0g=7=00<000000>;?a@3RclD01@3RclD0
0`000000iLfo0>G=_`040>G=_`030000003VbKX0i/Vj0080i/Vj00<000000>G@`P3Ud<800`000006
0>76_@030000003K_;X0fkbj00@0fkbj00@000000<ne`03?]L0000002034Y[/00`000000]9Vm0;BI
_@060;BI_@<000002@2NPkH00`000000Tgbg09=l]`0609=l]`030000002;NKX0RgVj00H0RgVj00<0
000008Ah_@24N;d01P24N;d00`000000PG_3085k``06085k``0300000021PLX0PH7:00H0PH7:00<0
000008F:d@25R]401@25R]42000000T0RYGH00<00000092OgP2@Wmh01`2@Wmh00`000000UZWS09JY
h`0809JYh`030000003oool0oooo01D0oooo00<000000?ooo`3oool0:@3oool00100oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0=0?ooo`030;YbLP2jj_l0oooo00H0oooo0`00000M
0?ooo`030000003oool0oooo01H0oooo0`0000050:6^h0030000002S[Mh0XjgN00P0XjgN00<00000
0:F]g02U[M`01`2U[M`3000000T0ZJSE00<000000:j/e@2^[=D02@2^[=D00`000000]Zk@0;J^d00:
0;J^d0040000002l]m@0_;OD0;bge08000002@32]Lh010000000b<7C0<S1d`00000:0=32c@030000
003F`/H0e/;60080e/;600@000000=cAc@3LdLd000001`3RclD00`000000iLfo0>G=_`050>G=_`03
0000003VbKX0i/Vj00<0i/Vj0`0000070>76_@030000003K_;X0fkbj00D0fkbj00<000000<ne`000
00002P34Y[/00`000000]9Vm0;BI_@040;BI_@050000002[SKH0Zhff0:^=]P000000202NPkH00`00
0000Tgbg09=l]`0609=l]`030000002;NKX0RgVj00H0RgVj00<0000008Ah_@24N;d01`24N;d00`00
0000PG_3085k``06085k``0300000021PLX0PH7:00D0PH7:00<0000008F:d@25R]401P25R]420000
00T0RYGH00<00000092OgP2@Wmh01`2@Wmh00`000000UZWS09JYh`0809JYh`030000003oool0oooo
01<0oooo0`0000090?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0603oool000L0
oooo00<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002K
e03oool03@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool04P3oool3000000T0XJkP00<000000:>]gP2S[Mh01`2S[Mh00`000000YJgL0:F]g0040:F]
g0<000000P2TY]L00`000000ZJSE0:VXe@080:VXe@030000002^[=D0[ZcE00H0[ZcE0P0000000`2`
Yll000000;J^d00;0;J^d0030000002l]m@0000000/0`[G>00<000000<S1d`0000002P3@`/d00`00
0000e/;60=K2aP040=K2aP030000003LdLd0000000L0h/o500<000000>G=_`3UcKl0103UcKl01000
0000i/Vj0>K9^P3VbKX3000000030>K9^P000000hLJm00L0hLJm00<000000=^l^P3K_;X01P3K_;X0
0`000000a:Jk0<BV^`090<BV^`030000002dVKd0]9Vm0080]9Vm0P0000040:^=]P030000002NPkH0
WX>f00H0WX>f00<0000009=l]`2CO;L01P2CO;L00`000000RgVj08]i^P0608]i^P0300000024N;d0
Q7Rm00L0Q7Rm00<00000085k``21Nl<01P21Nl<00`000000PH7:0861bP060861bP0300000025R]40
QH[A00H0QH[A00<0000008ZEf02:UMP01`2:UMP00`000000T9oN092OgP07092OgP030000002FZN<0
UZWS00P0UZWS00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0:0?ooo`030;YbLP2jj_l0
oooo01/0oooo000@0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03@3oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool03@3oool40000
0080X;3S00<000000:6^h02Q[^00202Q[^000`000000XjgN0:>]gP070:>]gP030000002U[M`0YJgL
00<000001@2TY]L00`000000ZJSE0:VXe@080:VXe@030000002^[=D0[ZcE00@0[ZcE0P0000030;2W
c`030000002f[]00]Zk@00/0]Zk@00<000000<:ecP32]Lh02`32]Lh00`000000d<;=0=32c@080=32
c@030000003F`/H0e/;600H0e/;600<000000>;?a@3RclD01@3RclD00`000000iLfo0>G=_`050>G=
_`@000000`3VbKX00`000000i/Jg000000060>76_@030000003K_;X0fkbj00H0fkbj0P00000;0<BV
^`050000002dVKd0]9Vm0;BI_@0000001P2[SKH00`000000WX>f09j3]P0709j3]P030000002CO;L0
Tgbg00H0Tgbg00<0000008]i^P2;NKX01P2;NKX00`000000Q7Rm08Ah_@0608Ah_@0300000021Nl<0
PG_300H0PG_300<000000861bP21PLX01P21PLX00`000000QH[A08F:d@0708F:d@030000002:UMP0
RYGH00L0RYGH00<00000092OgP2@Wmh01`2@Wmh00`000000UZWS09JYh`0609JYh`<000005`3oool0
0`000000oooo0?ooo`090?ooo`030;YbLP2jj_l0oooo01/0oooo000@0?ooo`030?oDV`1b^^X0oooo
0080oooo00<0j[Yb07:jjP3oool03@3oool00`2jLW80^^[o0?ooo`060?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool0203oool4000000L0X;3S00<000000:6^h02Q[^00202Q[^000`00
0000XjgN0:>]gP060:>]gP<000002@2TY]L00`000000ZJSE0:VXe@080:VXe@040000002^[=D0[ZcE
0:j/e@8000001P2`Yll00`000000]Zk@0;J^d0090;J^d0030000002kZlX0000000/0`[G>00<00000
0<Rea`000000203@`/d00`000000e/;60=K2aP060=K2aP030000003L`[l0000000H0h/o500<00000
0>G=_`3UcKl00`3UcKl3000000H0i/Vj00@000000>K6]`3Va[L000001@3Qa[d00`000000fkbj0=^l
^P060=^l^P030000003C/kT0000000/0a:Jk0`0000080:^=]P030000002NPkH0WX>f00H0WX>f00<0
000009=l]`2CO;L01P2CO;L00`000000RgVj08]i^P0608]i^P0300000024N;d0Q7Rm00H0Q7Rm00<0
0000085k``21Nl<01`21Nl<00`000000PH7:0861bP060861bP0300000025R]40QH[A00H0QH[A00<0
000008ZEf02:UMP01`2:UMP00`000000T9oN092OgP07092OgP040000002FZN<0UZWS09JYh`D00000
0`2MZ^000`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<0^W9b0;[Zo`3oool0
6`3oool00140oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`050>ZjLP00000007:j0;Yb
LP2jj_l01`3oool200000280oooo00<000000?ooo`3oool0103oool300000080X;;U00<000000:2`
h`2P/><01`2P/><00`000000XJkP0:6^h0070:6^h0030000002S[Mh0XjgN00@0XjgN0P0000020:6U
f@030000002TY]L0Y:KG00P0Y:KG00<000000:VXe@2YZ=D01`2YZ=D010000000[ZcE000000000009
0;2Wc`030000002f[]00]Zk@00H0]Zk@0P0000020;^[bP0300000032]Lh0`[G>00P0`[G>00D00000
0<Rea`38]LL0b;G7000000060=32c@030000003F`/H0e/;600L0e/;600@000000=c2_`3L`[l00000
103RclD010000000iLfo0>G=_`3UcKl4000000L0i/Vj00D000000>K6]`3Va[L0i/Jg000000040>76
_@030000003K_;X0fkbj00H0fkbj00@000000=>c^@3C/kT000002`34Y[/00`000000Zhff0:^=]P08
0:^=]P030000002NPkH0WX>f00H0WX>f00<0000009=l]`2CO;L01P2CO;L00`000000RgVj08]i^P07
08]i^P0300000024N;d0Q7Rm00H0Q7Rm00<00000085k``21Nl<01P21Nl<00`000000PH7:0861bP06
0861bP0300000025R]40QH[A00L0QH[A00<0000008ZEf02:UMP01`2:UMP00`000000T9oN092OgP05
092OgPD00000202MZ^000`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00P0oooo00<0^W9b
0;[Zo`3oool06`3oool00140oooo00D0oooD09/000000000001b0;[Zo`0>0?ooo`030>ZjLP000780
^^[o00L0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`03000000D0X;;U00<00000
0:2`h`2P/><01`2P/><00`000000XJkP0:6^h0080:6^h0030000002S[Mh0XjgN00<00000102QYMT0
0`000000Y:KG0:BVe`080:BVe`030000002YZ=D0ZJSE00P0ZJSE00<000000;2Wc`2`Yll02@2`Yll0
0`000000]Zk@0;J^d0050;J^d0030000002kZlX0^j_:00<0^j_:00<000000<:ecP32]Lh01P32]Lh0
0`000000b;G70<Rea`030<Rea`030000003@`/d0d<;=0080d<;=00<000000=K2aP3F`/H01`3F`/H0
0`000000g<:o0=c2_`020=c2_`050000003RclD0h/o50000003UcKl00`0000030>G=_`030000003V
bKX0i/Vj00D0i/Vj00<000000>K6]`3Va[L00P3Va[L010000000hLJm0>76_@0000090=^l^P050000
003C/kT0dk>i0=>c^@0000002@34Y[/2000000X0Zhff00<0000009j3]P2NPkH01P2NPkH00`000000
Tgbg09=l]`0709=l]`030000002;NKX0RgVj00H0RgVj00<0000008Ah_@24N;d01P24N;d00`000000
PG_3085k``07085k``0300000021PLX0PH7:00H0PH7:00<0000008F:d@25R]401P25R]42000000P0
RYGH00@00000092OgP2@Wmh0T9oN1000000209VQfP030000002MZ^00WJ[P00T0WJ[P00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`070?ooo`030;YbLP2jj_l0oooo01/0oooo000^0?ooo`03
0000003oool0oooo0280oooo0`0000090:2bi@030000002P/><0X;3S00L0X;3S00<000000:6^h02Q
[^001P2Q[^04000000P0XJGI00<000000:BVe`2TY]L0202TY]L00`000000ZJSE0:VXe@050:VXe@80
000000<0ZJ;?0000002`Yll02P2`Yll00`000000]Zk@0;J^d0030;J^d0030000002kZlX0^j_:00@0
^j_:00<000000<:ecP32]Lh01032]Lh2000000L0b;G700D000000=32c@3@`/d0d<;=000000080=K2
aP030000003L`[l0g<:o00@0g<:o100000050>G=_`030000003VbKX0i/Vj00D0i/Vj00<000000>K6
]`3Va[L0103Va[L00`000000hLJm000000080=^l^P030000003C/kT0dk>i0080dk>i00<000000<BV
^`34Y[/01P34Y[/010000000^IZg0;VJ]`0000090:^=]P030000002NPkH0WX>f00L0WX>f00<00000
09=l]`2CO;L01P2CO;L00`000000RgVj08]i^P0608]i^P0300000024N;d0Q7Rm00H0Q7Rm00<00000
085k``21Nl<01`21Nl<00`000000PH7:0861bP060861bP0300000025R]40QH[A00L0QH[A0P000004
08ZEf0L000001`2IXMX00`000000WJ[P09fZh00809fZh0030000003oool0oooo01H0oooo00<00000
0?ooo`3oool01P3oool00`2jLW80^^[o0?ooo`0K0?ooo`00;P3oool00`000000oooo0?ooo`0N0?oo
o`@000000P2Q]NL00`000000X;;U0:2bi@080:2bi@030000002P/><0X;3S00L0X;3S00@000000:6^
h02Q[^00XJkP1000000309jWg0030000002QYMT0XJGI00L0XJGI00<000000:BVe`2TY]L0202TY]L0
0`000000ZJSE0:VXe@020:VXe@8000000`2YX/l00`000000/:O?0;2Wc`0:0;2Wc`030000002f[]00
]Zk@00800000202kZlX00`000000`[G>0<:ecP020<:ecP0300000038]LL0b;G700P0b;G700<00000
0=32c@0000002@3F`/H00`000000g<:o0=c2_`030=c2_`<000001`3UcKl00`000000i/Vj0>K9^P05
0>K9^P030000003Va[L0i/Jg00D0i/Jg00<000000=^l^P3K_;X01P3K_;X00`000000dk>i0=>c^@04
0=>c^@0300000034Y[/0a:Jk00@0a:Jk00D000000;VJ]`2iV[L0^IZg0000000:0:^=]P030000002N
PkH0WX>f00H0WX>f00<0000009=l]`2CO;L01P2CO;L00`000000RgVj08]i^P0708]i^P0300000024
N;d0Q7Rm00H0Q7Rm00<00000085k``21Nl<01`21Nl<00`000000PH7:0861bP060861bP0300000025
R]40QH[A0080QH[A2P00000409BGd`030000002IXMX0VJ7J00L0VJ7J00<0000009fZh02MZ^002@2M
Z^000`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00<0oooo00D0j[Yb00000000L[X0^W9b
0;[Zo`0L0?ooo`00;P3oool00`000000oooo0?ooo`0J0?ooo`@000001`2Q]NL00`000000X;;U0:2b
i@080:2bi@030000002P/><0X;3S00H0X;3S1000000709jWg0030000002QYMT0XJGI00L0XJGI00<0
00000:BVe`2TY]L0202TY]L00`000000ZJSE0:VXe@02000000H0ZJ;?00<000000;2Wc`2`Yll02@2`
Yll00`000000]Zk@0000000;0;^[bP0400000032]Lh0`[G>000000`0b;G700<000000=K2aP3F`/H0
1`3F`/H010000000g<:o0=c2_`3L`[l3000000040=c2_`000000hL>j000000D0iLfo00<000000>K9
^P3VbKX01@3VbKX00`000000i/Jg0>K6]`050>K6]`030000003S`kL0000000L0fkbj00<000000=>c
^@3C/kT0103C/kT00`000000a:Jk0<BV^`030<BV^`030000002iV[L0^IZg0080^IZg00<000000:^=
]P2[SKH0202[SKH00`000000WX>f09j3]P0609j3]P030000002CO;L0Tgbg00L0Tgbg00<0000008]i
^P2;NKX00P2;NKXU000000D0THg;0P00000809BGd`030000002IXMX0VJ7J00L0VJ7J00<0000009fZ
h02MZ^00202MZ^000`000000oooo0?ooo`0C0?ooo`80000000<0oooo0000003oool01@3oool00`3Z
^W80001b0;[Zo`0L0?ooo`00;@3oool2000001X0oooo0P0000020::hj@030000002Q]NL0XKGW00L0
XKGW00<000000:2bi@2P/^D01`2P/^D00`000000X;3S0:2`h`040:2`h`8000000P2LZMl00`000000
WZOL09jWg00709jWg0030000002QYMT0XJGI00L0XJGI00<000000:BVe`2TY]L01`2TY]L3000000T0
ZJ;?00<000000;2Wc`2`Yll02@2`Yll00`000000^j_:0;^[bP0:0;^[bP0300000032]Lh0000000`0
b;G700<000000<je`P0000001`3F`/H00`000000g<:o00000002000000@0g<:o00@000000>73^P3Q
`kX00000103UcKl00`000000i/Vj0>K9^P040>K9^P030000003Va[L0i/Jg00H0i/Jg00<000000>?3
]`0000001P3K_;X00`000000dk>i0=>c^@060=>c^@0500000034Y[/0a:Jk0<BV^`0000001P2iV[L0
0`000000Zhff0:^=]P070:^=]P030000002NPkH0WX>f00H0WX>f00<0000009=l]`2CO;L01@2CO;L7
000000@0TGRd00<0000008ii^02>NKP01P2>NKP00`000000SWfm08im_@0708im_@030000002>Q<@0
SXC400H0SXC400<00000096=b`2ASL/01`2ASL/00`000000U9OC0000000709BGd`030000002IXMX0
VJ7J00L0VJ7J00<0000009fZh02MZ^00202MZ^02000001P0oooo00<000000?ooo`3oool08P3oool0
02d0oooo00<000000?ooo`3oool05P3oool3000000D0X[SY00<000000:6ei`2Q]NL01P2Q]NL00`00
0000X;;U0:2bi@080:2bi@030000002P/><0X;3S00<00000102LZMl00`000000WZOL09jWg00709jW
g0030000002QYMT0XJGI00P0XJGI00<000000:BVe`2TY]L00`2TY]L3000000030:>Od@000000ZJ;?
00T0ZJ;?00<000000;2Wc`2`Yll01`2`Yll2000000030;:Sb@000000^j_:00/0^j_:00<000000<Re
a`38]LL02P38]LL010000000c[G20<je`P0000060=K2aP<000001P3L`[l00`000000hL>j0>73^P02
0>73^P040000003UcKl0iLfo000000L0i/Vj00<000000>K6]`3Va[L01@3Va[L01@000000hl>g0>?3
]`3S`kL0000000@0fkbj00<000000=>c^@3C/kT01`3C/kT010000000a:Jk0<BV^`0000070;VJ]`03
0000002[SKH0Zhff00P0Zhff00<0000009j3]P2NPkH01P2NPkH00`000000Tgbg09=l]`0400000080
UWZb00<00000095h]02AN;@01`2AN;@00`000000SWVh08ii^00608ii^0030000002>OKd0SWfm00L0
SWfm00<0000008j4a02>Q<@01P2>Q<@00`000000THg;096=b`07096=b`030000002DUm<0000000L0
U9OC00<0000009VQfP2IXMX01`2IXMX00`000000WJ[P09fZh00409fZh0<000000P2S[=d00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0280oooo000]0?ooo`030000003oool0oooo01<0oooo
0`0000090::hj@030000002Q]NL0XKGW00H0XKGW00<000000:2bi@2P/^D01P2P/^D4000000P0W:WO
00<0000009jWg02NYm`01`2NYm`00`000000XJGI0:6Uf@070:6Uf@030000002TY]L0Y:KG00<00000
1@2SWm400`000000ZJ;?0:VRc`080:VRc`030000002`Yll0/:O?00@0/:O?0P0000030;:Sb@030000
002kZlX0^j_:00T0^j_:00<000000;nZa00000002`38]LL01@000000c[G20<je`P3>]L8000000080
e/;6100000080=c2_`030000003Q`kX0hL>j00<0hL>j00<000000>G=_`0000001P3VbKX00`000000
i/Jg0>K6]`060>K6]`030000003S`kL0hl>g0080hl>g00D000000=^l^P3K_;X0fkbj0000000:0=>c
^@800000202iV[L00`000000Zhff0:^=]P080:^=]P030000002NPkH0WX>f00D0WX>f1000000709Ij
/P030000002AN;@0TGRd00H0TGRd00<0000008ii^02>NKP01P2>NKP00`000000SWfm08im_@0708im
_@030000002>Q<@0SXC400H0SXC400<00000096=b`2ASL/01`2ASL/00`000000U9OC0000000709BG
d`030000002IXMX0VJ7J00L0VJ7J00<0000009fZh02MZ^00100000050:>/g@030000003oool0oooo
01H0oooo00<000000?ooo`3oool08@3oool002d0oooo00<000000?ooo`3oool04@3oool200000080
Xk[Z00<000000::hj@2R^>T01`2R^>T00`000000XKGW0:6ei`070:6ei`040000002P/^D0X;;U0:2b
i@@000000`2L[N<00`000000W:WO09bYg`0709bYg`030000002NYm`0WZOL00H0WZOL00<000000:6U
f@2QYMT01`2QYMT3000000P0XioA00<000000:VRc`2YX/l02@2YX/l010000000/:O?0;2Wc`2`Yll2
000000H0/Z?900<000000;^[bP2kZlX01`2kZlX010000000_j[40;nZa000000:0<Rea`030000003>
]L80c[G20080c[G20`0000020=K2aP030000003L`[l0g<:o00H0g<:o00<000000>73^P3Q`kX01@3Q
`kX00`000000i/Vj0>K9^P050>K9^P030000003Va[L0i/Jg00D0i/Jg00<000000>?3]`3S`kL0103S
`kL00`000000fkbj0000000;0=>c^@030000002iV[L0^IZg00P0^IZg00<000000:^=]P2[SKH01`2[
SKH00`000000WX>f09j3]P0309j3]P80000000<0W7ja0000002FN[80202FN[800`000000TGRd095h
]006095h]0030000002>NKP0SWVh00H0SWVh00<0000008im_@2>OKd01`2>OKd00`000000SXC408j4
a00608j4a0030000002ASL/0THg;00P0THg;00<0000009BGd`0000001`2DUm<00`000000VJ7J09VQ
fP0509VQfP@000002P2S[=d00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0200oooo000]
0?ooo`030000003oool0oooo00h0oooo0`0000050:>jjP030000002R^>T0X[SY00L0X[SY00<00000
0:6ei`2Q]NL01P2Q]NL4000000L0W:gS00<0000009bYg`2LZMl01`2LZMl00`000000WZOL09jWg007
09jWg0030000002QYMT0XJGI00<0XJGI0`0000000`2NW]@000000:>Od@090:>Od@030000002YX/l0
ZJ;?00P0ZJ;?00@000000;2Wc`0000000000202bXlT00`000000^j_:0;^[bP060;^[bP030000002o
Z/@0_j[40080_j[400<000000<Rea`38]LL01P38]LL00`000000c[G20<je`P0300000080c[G200<0
00000=K2aP000000203L`[l00`000000hL>j0>73^P050>73^P030000003Ta;L0000000D0i/Vj00<0
00000>K6]`3Va[L01@3Va[L00`000000hl>g0>?3]`050>?3]`030000003K_;X0000000X0dk>i0P00
000:0;VJ]`030000002[SKH0Zhff00P0Zhff00<0000009j3]P0000000P00000409an/@030000002F
N[80UWZb00H0UWZb00<00000095h]02AN;@01P2AN;@00`000000SWVh08ii^00708ii^0030000002>
OKd0SWfm00L0SWfm00<0000008j4a02>Q<@01P2>Q<@00`000000THg;096=b`07096=b`040000002D
Um<0U9OC000000H0U9OC00@0000009VQfP2IXMX0VJ7J100000030:6Te`030000002S[=d0XjcM00P0
XjcM00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0P0?ooo`00;03oool3000000`0oooo
0`0000090:>jjP030000002R^>T0X[SY00L0X[SY00@000000:6ei`2Q]NL0XKGW1000000209baiP03
0000002L[N<0W:gS00L0W:gS00<0000009bYg`2LZMl01`2LZMl00`000000WZOL09jWg00609jWg003
0000002QYMT0XJGI00<000001@2NW]@00`000000XioA0:>Od@070:>Od@030000002YX/l0ZJ;?00T0
ZJ;?00<000000;:Sb@2bXlT02@2bXlT00`000000^j_:0;^[bP030;^[bP8000001P2oZ/@00`000000
b;G70<Rea`040<Rea`@000001@3>]L800`000000e/;6000000080=c2_`030000003Q`kX0hL>j00D0
hL>j00@000000>C4]`3Ta;L00000103VbKX00`000000i/Jg0>K6]`050>K6]`030000003S`kL0hl>g
00H0hl>g00<000000=>c^@3C/kT0203C/kT010000000b:Vj0<RY^P0000090;VJ]`030000002[SKH0
Zhff00P0Zhff0P00000709an/@030000002FN[80UWZb00H0UWZb00<00000095h]02AN;@01`2AN;@0
0`000000SWVh08ii^00608ii^0030000002>OKd0SWfm00L0SWfm00<0000008j4a02>Q<@01P2>Q<@0
0`000000THg;096=b`08096=b`030000002DUm<0000000D0U9OC1@0000070:6Te`030000002S[=d0
XjcM00T0XjcM00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0O0?ooo`00;03oool00`00
0000oooo0?ooo`0:0?ooo`8000000P2T_>/00`000000Xk[Z0:>jjP080:>jjP030000002R^>T0X[SY
00H0X[SY1000000709baiP030000002L[N<0W:gS00L0W:gS00<0000009bYg`2LZMl01`2LZMl00`00
0000WZOL09jWg00509jWg0<00000202NW]@00`000000XioA0:>Od@080:>Od@030000002YX/l0ZJ;?
00H0ZJ;?0`00000;0;:Sb@030000002kZlX0^j_:0080^j_:00<000000;nZa02oZ/@01P2oZ/@00`00
0000b;G70<Rea`030<Rea`8000002@3>]L800`000000g<:o0=c2_`060=c2_`030000003Q`kX0hL>j
00D0hL>j00<000000>C4]`3Ta;L00P3Ta;L010000000i/Vj0>K9^P0000070>K6]`030000003S`kL0
hl>g00H0hl>g0P00000:0=>c^@0400000038ZKX0b:Vj000000X0^IZg00<000000:^=]P2[SKH01@2[
SKH3000000P0W7ja00<0000009Ij/P2FN[801`2FN[800`000000TGRd095h]006095h]0030000002>
NKP0SWVh00H0SWVh00<0000008im_@2>OKd01`2>OKd00`000000SXC408j4a00708j4a0030000002A
SL/0THg;00L0THg;00<0000009BGd`2DUm<01@00000209nKd0030000002QY=L0XJCG00P0XJCG00<0
00000:>/g@2S[=d0202S[=d00`000000oooo0?ooo`0E0?ooo`<00000803oool002`0oooo00<00000
0?ooo`3oool01`3oool3000000D0Y;c[00<000000:>jjP2S^^X0202S^^X010000000X[SY0::hj@2R
^>T400000080W[CX00<0000009baiP2L/NH01`2L/NH00`000000W:gS09b]h`0709b]h`030000002L
ZMl0W:WO00H0W:WO00@0000009jWg02NYm`0WZOL1000000209ZOf0030000002NW]@0WYkD00L0WYkD
00<000000:>Od@2SWm401`2SWm400`000000ZJ;?0:VRc`040:VRc`8000000`2ZWLT00`000000/Z?9
0;:Sb@090;:Sb@040000002kZlX0^j_:000000X0_j[400<000000<Rea`0000000P00000:0<je`P03
0000003D]kd0000000L0g<:o00<000000>73^P3Q`kX01@3Q`kX00`000000i<Bg0>C4]`030>C4]`03
0000003VbKX0000000L0i/Jg00<000000>?3]`3S`kL01P3S`kL00`000000gl2i000000080=>c^@05
00000038ZKX0b:Vj0<RY^P0000002P2iV[L00`000000Zhff0:^=]P030:^=]P8000000P2TQK800`00
0000W7ja09an/@0609an/@030000002FN[80UWZb00L0UWZb00<00000095h]02AN;@01P2AN;@00`00
0000SWVh08ii^00708ii^0030000002>OKd0SWfm00H0SWfm00<0000008j4a02>Q<@01`2>Q<@00`00
0000THg;096=b`07096=b`D000001P2OVm000`000000XJCG0:6Te`080:6Te`030000002S[=d0XjcM
00L0XjcM0P00000H0?ooo`030000003oool0oooo01h0oooo000/0?ooo`030000003oool0oooo00<0
oooo100000090:Blj`030000002S^^X0Xk[Z00L0Xk[Z1000000709jdj0030000002L/NH0W;7V00H0
W;7V00<0000009b]h`2L[N<01`2L[N<00`000000W:WO09bYg`0309bYg`L000001P2JWmP00`000000
WYkD09jNe00709jNe0030000002SWm40XioA00P0XioA00@000000:VRc`2YX/l0ZJ;?0P0000050:ZM
b@030000002bXlT0/Z?900T0/Z?900<000000;^[bP0000002P2oZ/@300000080b;G700<000000<je
`P3>]L80203>]L800`000000e;Nm000000060=c2_`030000003Q`kX0hL>j00D0hL>j00<000000>C4
]`3Ta;L01@3Ta;L00`000000i/Jg0>K6]`050>K6]`030000003S`kL0hl>g00H0hl>g00@000000=o0
^@3O`;T000001`3C/kT00`000000b:Vj0<RY^P030<RY^P030000002iV[L0^IZg00L0^IZg00@00000
0:^=]P2[SKH0Zhff0P0000050:B5/P030000002LO[40W7ja00H0W7ja00<0000009Ij/P2FN[801P2F
N[800`000000TGRd095h]007095h]0030000002>NKP0SWVh00H0SWVh00<0000008im_@2>OKd01`2>
OKd00`000000SXC408j4a00608j4a0030000002ASL/0THg;00@0THg;0`0000000`2LTLP0000009nK
d00209nKd0030000002OVm00Wi_@00<0Wi_@00<000000:6Te`2QY=L02@2QY=L00`000000XjcM0:>/
g@030:>/g@<000000P2Z/=`00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01d0oooo000/
0?ooo`H000000`2U_N/00`000000Y;c[0:Blj`080:Blj`030000002S^^X0Xk[Z00@0Xk[Z0P000002
0:2hj@030000002N]>P0W[CX00L0W[CX00<0000009baiP2L/NH01P2L/NH00`000000W:gS09b]h`06
09b]h`H000001@2GX]`00`000000VYoH09ZOf00609ZOf0030000002NW]@0WYkD00L0WYkD00<00000
0:>Od@2SWm401`2SWm4010000000ZJ;?0000000000080:ZMb@030000002bXlT0/Z?900T0/Z?900<0
00000;nZa02oZ/@01P2oZ/@300000080_j[400<000000<Rea`0000002P3>]L801@000000e;Nm0=Bg
_@3D]kd0000000@0g<:o00<000000>73^P3Q`kX01P3Q`kX00`000000i<Bg0>C4]`040>C4]`030000
003WakH0000000D0i/Jg00<000000>?3]`3S`kL01P3S`kL00`000000gl2i0=o0^@020=o0^@030000
003C/kT0dk>i00<0dk>i00<000000<RY^P38ZKX01038ZKX00`000000^IZg0;VJ]`080;VJ]`<00000
1`2TQK800`000000W7ja09an/@0609an/@030000002FN[80UWZb00H0UWZb00<00000095h]02AN;@0
1`2AN;@00`000000SWVh08ii^00608ii^0030000002>OKd0SWfm00L0SWfm00<0000008j4a02>Q<@0
1`2>Q<@00`000000THg;00000003000000D0W97800@0000009nKd02OVm0000001P2OVm000`000000
XJCG0:6Te`080:6Te`030000002S[=d0XjcM00<000001@2Z/=`00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01`0oooo000[0?ooo`<00000202U_N/00`000000Y;c[0:Blj`080:Blj`030000
002S^^X0Xk[Z00<000001@2P^>T00`000000W[CX09jdj00609jdj0030000002L/NH0W;7V00L0W;7V
00@0000009b]h`2L[N<0W:gS1000000209JVh@030000002GX]`0Uj;L00H0Uj;L00<0000009ZOf02J
WmP01`2JWmP00`000000WYkD09jNe00609jNe0030000002SWm40XioA00L0XioA0P00000:0:ZMb@03
0000002bXlT0/Z?900P0/Z?90P0000050;nZa0<000001P2oZ/@00`000000c[G20<je`P080<je`P03
0000003D]kd0e;Nm00<0e;Nm00D000000=c2_`3L`[l0g<:o000000070>73^P030000003Ta;L0i<Bg
00D0i<Bg00@000000>O7]P3WakH00000103Va[L00`000000hl>g0>?3]`060>?3]`030000003O`;T0
gl2i0080gl2i00<000000=>c^@3C/kT00P3C/kT00`000000b:Vj0<RY^P050<RY^P030000002iV[L0
^IZg00P0^IZg00<000000:B5/P2TQK801`2TQK800`000000W7ja09an/@0609an/@030000002FN[80
UWZb00L0UWZb00<00000095h]02AN;@01P2AN;@00`000000SWVh08ii^00708ii^0030000002>OKd0
SWfm00H0SWfm00<0000008j4a02>Q<@01@2>Q<@4000000T0W97800D0000009nKd02OVm00Wi_@0000
000509nKd0030000002QY=L0XJCG00P0XJCG0`0000090:Z`g0030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0703oool002`0oooo00<000000:Fmj`2U_N/0202U_N/2000000P0Y;c[0`000009
0:2hj@030000002N]>P0W[CX00H0W[CX00<0000009baiP2L/NH01P2L/NH4000000H0UZKQ00<00000
09NRg02GX]`01`2GX]`00`000000VYoH09ZOf00609ZOf0030000002NW]@0WYkD00L0WYkD00<00000
0:>Od@2SWm400`2SWm43000000030::Ic0000000ZYg900X0ZYg900<000000;:Sb@2bXlT01@2bXlT2
00000080]Z;400<000000;nZa00000000P0000080;nZa00300000035Zl00000000T0c[G200<00000
0=Bg_@3D]kd0103D]kd00`000000g<:o000000070>73^P030000003Ta;L0i<Bg00D0i<Bg00<00000
0>O7]P3WakH00P3WakH010000000i/Jg0>K6]`0000080>?3]`030000003O`;T0gl2i00@0gl2i00@0
00000=>c^@3C/kT000002038ZKX00`000000^IZg0;VJ]`060;VJ]`<000002@2TQK800`000000W7ja
09an/@0609an/@030000002FN[80UWZb00L0UWZb00<00000095h]02AN;@01`2AN;@00`000000SWVh
08ii^00608ii^0030000002>OKd0SWfm00L0SWfm00<0000008j4a02>Q<@01000000209Z9`0030000
002LTLP0W97800T0W97800D0000009nKd02OVm00Wi_@0000000509nKd0030000002QY=L0XJCG00D0
XJCG0P0000020:ZYeP030000002Z/=`0Z[3L00P0Z[3L00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`0K0?ooo`00803oool01@3oe9/00000000000000000VmCo00H0oooo00<000000?ooo`00
00002`2U_N/010000000Y;c[0:Blj`2T_>/400000080X[[Z00<000000:2hj@2P^>T01`2P^>T00`00
0000W[CX09jdj00709jdj0040000002L/NH0W;7V09baiP@000000P2GZn@00`000000UZKQ09JVh@06
09JVh@030000002GX]`0Uj;L00H0Uj;L00<0000009ZOf02JWmP01`2JWmP00`000000WYkD09jNe006
09jNe0030000002SWm40XioA00<000001@2RVL`00`000000ZYg90:ZMb@080:ZMb@030000002bXlT0
/Z?900@0/Z?900@000000;JRa02fX/@0]Z;40`00000:0;nZa00400000035Zl00aJ_0000000P0c[G2
00<000000=Bg_@3D]kd01@3D]kd00`000000g<:o000000070>73^P030000003Ta;L0i<Bg00D0i<Bg
00<000000>O7]P3WakH00`3WakH00`000000i/Jg000000070>?3]`030000003O`;T0gl2i00D0gl2i
00@000000=>c^@3C/kT000002@38ZKX00`000000^IZg0;VJ]`040;VJ]`050000002_T;H0[i2f0:n@
]P0000002@2TQK800`000000W7ja09an/@0609an/@030000002FN[80UWZb00H0UWZb00<00000095h
]02AN;@01`2AN;@00`000000SWVh08ii^00608ii^0030000002>OKd0SWfm00D0SWfm1@00000709Z9
`0030000002LTLP0W97800P0W97800<0000009nKd02OVm000P2OVm000`000000Wi_@09nKd00209nK
d0030000002QY=L0XJCG0080XJCG0`0000040:ZYeP030000002Z/=`0Z[3L00P0Z[3L00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0J0?ooo`00803oool01P2jLY/0e?oo0?ooo`3oom@0V`2K
0=Coo`D0oooo00<000000?ooo`3oool00P0000090:Fmj`@000001`2R^^X00`000000X;SY0:2hj@07
0:2hj@030000002N]>P0W[CX00H0W[CX1000000609N[i0030000002FY^40UZKQ00L0UZKQ00<00000
09NRg02GX]`01P2GX]`00`000000VYoH09ZOf00709ZOf0030000002NW]@0WYkD00D0WYkD0`000008
0::Ic0030000002ZWLT0ZYg900T0ZYg900<000000;:Sb@2bXlT00P2bXlT00`000000]Z;400000002
00000080]Z;400<000000;nZa02oZ/@01`2oZ/@00`000000aJ_00<F[`0020<F[`0030000003>]L80
c[G200@0c[G200<000000=Bg_@3D]kd01`3D]kd00`000000hL>j0>73^P050>73^P030000003Ta;L0
i<Bg00D0i<Bg00<000000>O7]P3WakH01@3WakH00`000000hl>g0>?3]`060>?3]`030000003O`;T0
gl2i00H0gl2i0P00000:0<RY^P030000002iV[L0^IZg0080^IZg0P0000040:n@]P030000002TQK80
Y8Fb00L0Y8Fb00<0000009an/@2LO[401P2LO[400`000000UWZb09Ij/P0709Ij/P030000002AN;@0
TGRd00H0TGRd00<0000008ii^02>NKP01`2>NKP00`000000SWfm08im_@0400000080VH>j00<00000
09Z9`02JRL001`2JRL000`000000W97809bAb00809bAb0030000002OVm00Wi_@0080Wi_@00<00000
09nKd02OVm000`2OVm0010000000XJCG0000000000080:ZYeP030000002Z/=`0Z[3L00L0Z[3L0P00
000H0?ooo`030000003oool0oooo01X0oooo000O0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb
07:jjP3oool0103oool2000000<0oooo00<000000:Fmj`2U_N/0102U_N/200000080Xkc[00<00000
0::jjP2R^^X01`2R^^X00`000000X;SY0:2hj@070:2hj@040000002N]>P0W[CX09jdj0@000000P2I
/>L00`000000Uj_T09N[i00609N[i0030000002FY^40UZKQ00H0UZKQ00<0000009NRg02GX]`01P2G
X]`00`000000VYoH09ZOf00709ZOf0040000002NW]@0WYkD09jNe0@000000P2JUll00`000000XYW<
0::Ic0070::Ic0030000002ZWLT0ZYg900P0ZYg900<000000;:Sb@2bXlT0100000050;JRa0030000
002oZ/@0_j[400H0_j[400<000000<F[`035Zl000`35Zl000`000000c[G20<je`P030<je`P030000
003D]kd0e;Nm00L0e;Nm00<000000=Zk^P0000001P3Q`kX00`000000i<Bg0>C4]`050>C4]`030000
003WakH0ilNf00@0ilNf00<000000>W:]P0000001P3S`kL00`000000gl2i0=o0^@070=o0^@030000
0038ZKX0b:Vj00T0b:Vj00D000000;VJ]`2iV[L0^IZg000000060:n@]P030000002TQK80Y8Fb00L0
Y8Fb00<0000009an/@2LO[401P2LO[400`000000UWZb09Ij/P0709Ij/P030000002AN;@0TGRd00H0
TGRd00<0000008ii^02>NKP01@2>NKP5000000L0VH>j00<0000009Z9`02JRL001`2JRL000`000000
W97809bAb00809bAb0030000002OVm00Wi_@0080Wi_@00@0000009nKd02OVm00Wi_@0`00000:0:ZY
eP030000002Z/=`0Z[3L00D0Z[3L0P0000020;2eg0030000003oool0oooo01<0oooo0P0000000`3o
ool000000?ooo`0J0?ooo`007`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00@0
oooo00<000000?ooo`3oool00`3oool00`000000YKg[0:Fmj`03000000D0Xkc[00<000000::jjP2R
^^X01`2R^^X00`000000X;SY0:2hj@060:2hj@@000001`2I/>L00`000000Uj_T09N[i00609N[i003
0000002FY^40UZKQ00H0UZKQ00<0000009NRg02GX]`01P2GX]`00`000000VYoH09ZOf00509ZOf0D0
00001P2JUll00`000000XYW<0::Ic0070::Ic0030000002ZWLT0ZYg900T0ZYg9100000080;JRa003
0000002oZ/@0_j[400<0_j[40P0000070<F[`0030000003>]L80c[G20080c[G200<000000=Bg_@3D
]kd01`3D]kd010000000f[^j0=Zk^P0000040>73^P030000003Ta;L0i<Bg00D0i<Bg00<000000>O7
]P3WakH01@3WakH010000000jLZf0>W:]P0000050>?3]`030000003O`;T0gl2i00H0gl2i0P00000<
0<RY^P<000001`2_T;H00`000000Y8Fb0:B5/P070:B5/P030000002LO[40W7ja00L0W7ja00<00000
09Ij/P2FN[801P2FN[800`000000TGRd095h]007095h]0030000002>NKP0SWVh00@000000P2HO[D0
0`000000VH>j09V3^P0709V3^P030000002JRL00VXW000L0VXW000<0000009bAb02LTLP0202LTLP0
0`000000Wi_@09nKd00309nKd0<0000000<0ZJ7>0000002ZZMH02`2ZZMH00`000000Z[3L0:Z`g002
0:Z`g0800000102`]M`00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo000O0?oo
o`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0103oool00`000000oooo0?ooo`040?oo
o`8000002@2S_>/00`000000X[[Z0::jjP070::jjP040000002P^>T0X;SY0:2hj@@000000P2L]>T0
0`000000VK3W09V`i`0709V`i`030000002GZn@0Uj_T00H0Uj_T00<0000009JVh@2FY^401P2FY^40
0`000000Uj;L09NRg00509NRg0040000002JWmP0VYoH09ZOf0@000000P2DUm@00`000000VYO?09ZG
c`0709ZGc`030000002RVL`0XYW<00L0XYW<00<000000:ZMb@2ZWLT01P2ZWLT3000000/0]Z;400<0
00000;nZa02oZ/@00P2oZ/@00`000000aJ_00<F[`0070<F[`0050000003>]L80c[G20<je`P000000
2@3D]kd01@000000f[^j0=Zk^P3J^kX0000000@0hL>j00<000000>C4]`3Ta;L01@3Ta;L00`000000
ilNf0>O7]P040>O7]P050000003Yb[H0jLZf0>W:]P000000103S`kL00`000000gl2i0=o0^@070=o0
^@030000003H_Kh0000000/0b:Vj00<000000:n@]P2_T;H0202_T;H00`000000Y8Fb0:B5/P060:B5
/P030000002LO[40W7ja00L0W7ja00<0000009Ij/P2FN[801P2FN[800`000000TGRd095h]005095h
]0D000001`2HO[D00`000000VH>j09V3^P0709V3^P030000002JRL00VXW000L0VXW000<0000009bA
b02LTLP0202LTLP00`000000Wi_@00000003000000@0ZJ7>00<000000:ZYeP2ZZMH02@2ZZMH00`00
0000Z[3L0:Z`g002000000L0/;GL00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?oo
o`007`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00@0oooo00<000000?ooo`3o
ool01@3oool00`000000Xkc[0:>lj`080:>lj`030000002R^^X0X[[Z00H0X[[Z1000000709bdj@03
0000002I/>L0VK3W00H0VK3W00<0000009N[i02GZn@01P2GZn@00`000000UZKQ09JVh@0609JVh@03
0000002GX]`0Uj;L00<0Uj;L1P00000709BGe0030000002JUll0VYO?00H0VYO?00<000000::Ic02R
VL`01`2RVL`00`000000ZYg90:ZMb@030:ZMb@H00000302fX/@010000000_j[40;nZa000000;0<F[
`0030000003>]L80000000T0e;Nm00<000000=Zk^P3J^kX00`3J^kX010000000hL>j0>73^P000007
0>C4]`030000003WakH0ilNf00D0ilNf00<000000>W:]P3Yb[H00P3Yb[H010000000hl>g0>?3]`00
00090=o0^@040000003H_Kh0f;fn000000X0b:Vj0P00000:0:n@]P030000002TQK80Y8Fb00L0Y8Fb
00<0000009an/@2LO[401P2LO[400`000000UWZb09Ij/P0709Ij/P030000002AN;@0TGRd00@00000
0P2HNk400`000000V7je09Qn]@0709Qn]@030000002IPkX0VH>j00L0VH>j00<0000009Z9`02JRL00
1`2JRL000`000000W97809bAb00709bAb0<00000102YXLh01@000000ZJ7>0:VQcP2YXLh0000000`0
ZZWF0P0000090;2eg0030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool001l0oooo
00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`040?ooo`030000003oool0oooo00H0oooo
00<000000:>lj`2S_>/0202S_>/010000000X[[Z0::jjP2R^^X400000080WkSZ00<0000009bdj@2L
]>T01`2L]>T00`000000VK3W09V`i`0609V`i`030000002GZn@0Uj_T00H0Uj_T00<0000009JVh@2F
Y^400`2FY^48000000@0T9[I00<0000009BGe02DUm@01P2DUm@00`000000VYO?09ZGc`0709ZGc`03
0000002RVL`0XYW<00L0XYW<00<000000:ZMb@0000000P0000000`2ZWLT00000000000030:bJa@03
0000002fX/@0]Z;400T0]Z;400<000000;nZa00000003035Zl000`000000c[G2000000090=Bg_@03
0000003J^kX0f[^j00@0f[^j00<000000>73^P0000001`3Ta;L00`000000ilNf0>O7]P040>O7]P03
0000003Yb[H0jLZf00@0jLZf00<000000>?3]`000000203O`;T00`000000f;fn0=Rm_P020=Rm_P03
00000038ZKX0b:Vj00H0b:Vj00@000000;bP_@2lX;d000002@2_T;H00`000000Y8Fb0:B5/P070:B5
/P030000002LO[40W7ja00H0W7ja00<0000009Ij/P2FN[801@2FN[85000000L0V7^a00<0000009Qn
]@2HO[D01P2HO[D00`000000VH>j09V3^P0709V3^P030000002JRL00VXW000P0VXW000<0000009bA
b02LTLP0102LTLP2000000030:NIa`000000ZJ7>00D0ZJ7>00D000000:VQcP2YXLh0ZJ7>00000009
0:ZYeP80000000<0/[3F0000002`]M`02@2`]M`00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo01L0oooo000P0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo103oool2000000T0oooo00<0
00000:>lj`2S_>/01`2S_>/4000000L0WkSZ00<0000009bdj@2L]>T01`2L]>T00`000000VK3W09V`
i`0609V`i`030000002GZn@0Uj_T00<0Uj_T2000000408jNgP030000002@V]T0T9[I00D0T9[I00<0
000009BGe02DUm@01`2DUm@00`000000VYO?09ZGc`0609ZGc`030000002RVL`0XYW<00H0XYW<0`00
00020:ZMb@8000001@2/V/D00`000000]Z;40;JRa00:0;JRa00300000035Zl00aJ_000`0aJ_000<0
00000=Bg_@3D]kd01`3D]kd00`000000f[^j0=Zk^P060=Zk^P030000003Ta;L0i<Bg00D0i<Bg00<0
00000>O7]P3WakH01@3WakH00`000000jLZf0>W:]P050>W:]P030000003O`;T0gl2i00L0gl2i00<0
00000=Rm_P3H_Kh00P3H_Kh00`000000b:Vj0<RY^P050<RY^P050000002lX;d0_:2m0;bP_@000000
2P2_T;H00`000000Y8Fb0:B5/P060:B5/P030000002LO[40W7ja00L0W7ja00<0000009Ij/P2FN[80
1000000209Uj/0030000002HNk40V7^a00L0V7^a00<0000009Qn]@2HO[D01`2HO[D00`000000VH>j
09V3^P0709V3^P030000002JRL00VXW000L0VXW000<0000009bAb02LTLP00P2LTLP2000000@0YiW7
00<000000:VQcP2YXLh0102YXLh010000000ZJ7>0:VQcP0000070:ZYeP8000000`2b/=H00`000000
/;GL0;2eg0080;2eg0030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00200oooo
00D0oooD09/000000000001b0;[Zo`050?ooo`030000003oool0oooo00T0oooo00<000000:>lj`2S
_>/0102S_>/200000080XK_[00<0000009nhjP2O^>X01`2O^>X00`000000W;CY09bdj@0709bdj@03
0000002I/>L0VK3W00<0VK3W2000000408nTh`030000002>W]h0SYkN00D0SYkN00<00000092Jf@2@
V]T01P2@V]T00`000000U9OD09BGe00609BGe0030000002JUll0VYO?00L0VYO?00<000000::Ic02R
VL`00P2RVL`300000080XYW<0`0000080:bJa@030000002fX/@0]Z;400P0]Z;400<000000;ZR`000
00003035Zl000`000000bjjm000000070=Bg_@030000003J^kX0f[^j00H0f[^j00<000000>70^000
00001P3Ta;L00`000000ilNf0>O7]P040>O7]P030000003Yb[H0jLZf00D0jLZf00<000000>W?^`00
00001`3O`;T00`000000f;fn0=Rm_P040=Rm_P0300000038ZKX0b:Vj00<0b:Vj00<000000;bP_@2l
X;d00P2lX;d00`000000[i2f0:n@]P080:n@]P030000002TQK80Y8Fb00H0Y8Fb00<0000009an/@2L
O[401P2LO[44000000L0VGZ`00<0000009Qk/@2HNk401P2HNk400`000000V7je09Qn]@0709Qn]@03
0000002IPkX0VH>j00L0VH>j00<0000009Z9`02JRL00202JRL0010000000W9780000000000060:NI
a`030000002YXLh0ZJ7>00@0ZJ7>00D000000:VQcP2YXLh0ZJ7>000000040:ZYeP8000001P2b/=H0
0`000000/;GL0;2eg0070;2eg08000006@3oool00`000000oooo0?ooo`0E0?ooo`00103oool00`3D
V`0000000000000300000003002Ke03oool0oooo01d0oooo00<000000?ooo`3oool02P3oool00`00
0000Xkc[0:>lj`03000000D0XK_[00<0000009nhjP2O^>X01`2O^>X00`000000W;CY09bdj@0609bd
j@H00000102BZnL00`000000SjCS08nTh`0508nTh`030000002>W]h0SYkN00H0SYkN00<00000092J
f@2@V]T01@2@V]T00`000000U9OD09BGe00709BGe0030000002JUll0VYO?00H0VYO?00<000000::I
c00000000P0000040::Ic08000002P2/V/D00`000000]Z;40;JRa0070;JRa0040000002jX/00^Z;0
000000/0aJ_000@000000<^^_@3;[[d000001`3D]kd00`000000f[^j0=Zk^P060=Zk^P040000003Q
`;P0hL2h000000@0i<Bg00<000000>O7]P3WakH01@3WakH00`000000jLZf0>W:]P050>W:]P030000
003Yck/0000000H0gl2i00<000000=Rm_P3H_Kh01@3H_Kh00`000000b:Vj0<RY^P020<RY^P030000
002lX;d0_:2m00@0_:2m00<000000:n@]P2_T;H01`2_T;H00`000000Y8Fb0:B5/P070:B5/P030000
002LO[40W7ja0080W7ja0`0000000`2KO;00000009Uj/00809Uj/0030000002HNk40V7^a00L0V7^a
00<0000009Qn]@2HO[D01P2HO[D00`000000VH>j09V3^P0709V3^P030000002JRL00VXW000L0VXW0
0`0000090:NIa`030000002YXLh0ZJ7>00@0ZJ7>00@000000:VQcP2YXLh000000P2ZZMH2000000P0
/[3F00<000000;2eg02`]M`01@2`]M`200000080][_N00<000000?ooo`3oool0503oool3000001L0
oooo00040?ooo`030?oDV`00L[X0oooo0080oooo00<0omBK002Ke03oool07P3oool00`000000oooo
0?ooo`0;0?ooo`8000002@2Q^n/00`000000WkSZ09nhjP0709nhjP040000002L]>T0W;CY09bdj@@0
00000P2F/NT00`000000TZ_W09:[i`0509:[i`030000002?Y><0SjCS00H0SjCS00<0000008jNgP2>
W]h01@2>W]h00`000000T9[I092Jf@06092Jf@030000002DUm@0U9OD00H0U9OD00<0000009ZGc`2J
Ull01P2JUll2000000D0XYW<0P0000000`2QULP000000:bJa@0:0:bJa@030000002fX/@0]Z;400D0
]Z;400<000000;ZR`02jX/000P2jX/000`000000aJ_00<F[`0080<F[`0050000003;[[d0bjjm0<^^
_@0000001@3D]kd00`000000f[^j0=Zk^P060=Zk^P050000003Q`;P0hL2h0>70^0000000103Ta;L0
0`000000ilNf0>O7]P040>O7]P030000003Yb[H0jLZf00D0jLZf00D000000>W?^`3Yck/0jLnk0000
00050=o0^@030000003H_Kh0f;fn00H0f;fn00@000000<RY^P38ZKX000001`2lX;d00`000000[i2f
0:n@]P080:n@]P030000002TQK80Y8Fb00H0Y8Fb00<0000009an/@0000000P00000509]l/0030000
002IN[00VGZ`00H0VGZ`00<0000009Qk/@2HNk401`2HNk400`000000V7je09Qn]@0709Qn]@030000
002IPkX0VH>j00L0VH>j00<0000009Z9`02JRL00102JRL02000000030:JA`0000000YiW700T0YiW7
00<000000:VQcP2YXLh01@2YXLh00`000000ZJ7>0:VQcP02000000/0/[3F00<000000;2eg02`]M`0
0P2`]M`2000000@0][_N00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0D0?ooo`001@3o
ool01P3Z^W8009_D0?ooo`3oool0omBK002Ke1l0oooo00<000000?ooo`3oool0303oool00`000000
XK_[0:6kj`080:6kj`030000002O^>X0WkSZ00H0WkSZ1000000609Jaj@030000002BZnL0TZ_W00H0
TZ_W00<0000008nTh`2?Y><01@2?Y><00`000000SYkN08jNgP0608jNgP030000002@V]T0T9[I00H0
T9[I00<0000009BGe02DUm@01P2DUm@00`000000VYO?09ZGc`0209ZGc`<0000000@0VYO?0000002R
VL`0XYW<0`0000040:6Eb0030000002/V/D0[9[500P0[9[500<000000;JRa02fX/@00`2fX/@20000
00D0^Z;000<000000<F[`035Zl001`35Zl000`000000bjjm0<^^_@020<^^_@030000003D]kd0e;Nm
00<0e;Nm00<000000=Zk^P3J^kX01P3J^kX00`000000hL2h0>70^0020>70^0040000003Ta;L0i<Bg
000000L0ilNf00<000000>W:]P3Yb[H01@3Yb[H00`000000jLnk0>W?^`020>W?^`050000003O`;T0
gl2i0=o0^@0000002@3H_Kh00`000000b:Vj000000080;bP_@030000002_T;H0[i2f00P0[i2f00<0
00000:B5/P2TQK801P2TQK82000000P0Vgb`00<0000009Uj/02IN[001P2IN[000`000000V7^a09Qk
/@0709Qk/@030000002HO[D0V7je00L0V7je00<0000009V3^P2IPkX01`2IPkX00`000000VXW009Z9
`00209Z9`0800000102VTL000`000000YiW70:NIa`070:NIa`030000002YXLh0ZJ7>00H0ZJ7>0P00
00000`2cZLl000000;:`eP0:0;:`eP030000002`]M`0/;GL008000001`2f^mh00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01<0oooo00060?ooo`050=BK0000Vm@0oooo0?oDV`00Vm@07`3o
ool2000000h0oooo00<000000:6kj`2Q^n/0202Q^n/010000000WkSZ09nhjP2O^>X400000080VkK[
00<0000009Jaj@2F/NT01P2F/NT00`000000TZ_W09:[i`0509:[i`030000002?Y><0SjCS00H0SjCS
00<0000008jNgP2>W]h01@2>W]h00`000000T9[I092Jf@06092Jf@030000002DUm@0U9OD00H0U9OD
00<0000009ZGc`0000000P00000309ZGc`@000001`2QULP00`000000[9[50:bJa@090:bJa@050000
002fX/@0]Z;40;JRa0000000202jX/000`000000aJ_00<F[`0050<F[`0030000003;[[d0bjjm00@0
bjjm00D000000=Bg_@3D]kd0e;Nm000000080=Zk^P030000003Q`;P0hL2h00@0hL2h00<000000>C4
]`0000001P3WakH00`000000jLZf0>W:]P050>W:]P030000003Yck/0jLnk00@0jLnk00<000000=o0
^@0000002`3H_Kh00`000000_:2m0;bP_@080;bP_@030000002_T;H0[i2f00L0[i2f00<000000:B5
/P2TQK80102TQK83000000T0Vgb`00<0000009Uj/02IN[001`2IN[000`000000V7^a09Qk/@0609Qk
/@030000002HO[D0V7je00L0V7je00<0000009V3^P2IPkX0202IPkX010000000VXW0000000000006
0:JA`0030000002WVLL0YiW700P0YiW700<000000:VQcP2YXLh00`2YXLh300000080/jW?00<00000
0;:`eP2b/=H02P2b/=H2000000X0][_N00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0C
0?ooo`001`3oool00`3DV`00L[[Z0?ooo`0O0?ooo`800000403oool2000000P0XK_[1000000709^f
j`030000002F/NT0U[7Y00H0U[7Y00<0000009:[i`2BZnL01@2BZnL00`000000SjCS08nTh`0608nT
h`030000002>W]h0SYkN00D0SYkN00<00000092Jf@2@V]T01P2@V]T00`000000U9OD09BGe00409BG
e0<000000P2JUll400000080Ui7<00<000000:6Eb02QULP01`2QULP00`000000[9[50:bJa@080:bJ
a@040000002fX/@0]Z;4000000T0^Z;000<000000<F[`035Zl001035Zl000`000000bjjm0<^^_@06
0<^^_@030000003D]kd0000000T0f[^j00<000000>70^03Q`;P01@3Q`;P00`000000ilNf0>O7]P05
0>O7]P030000003Yb[H0jLZf00D0jLZf00<000000>W?^`3Yck/0103Yck/00`000000gl2i0000000:
0=Rm_P8000002P2lX;d00`000000[i2f0:n@]P070:n@]P030000002TQK80Y8Fb0080Y8Fb0P000003
09j0/P030000002KO;00Vgb`00H0Vgb`00<0000009Uj/02IN[001`2IN[000`000000V7^a09Qk/@07
09Qk/@030000002HO[D0V7je00L0V7je00<0000009V3^P2IPkX01P2IPkX3000000P0YY7000<00000
0:NIa`2WVLL0202WVLL010000000ZJ7>0:VQcP2YXLh2000000<0/jW?00@000000;>Yc`2cZLl00000
2@2b/=H3000000/0][_N00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0B0?ooo`00203o
ool00`2jLP00VmCo0?ooo`0N0?ooo`030000003oool0oooo0140oooo00@000000:6kj`2Q^n/0XK_[
1000000209jij`030000002K]^/0VkK[00L0VkK[00<0000009Jaj@2F/NT01P2F/NT00`000000TZ_W
09:[i`0509:[i`030000002?Y><0SjCS00D0SjCS00<0000008jNgP2>W]h01@2>W]h00`000000T9[I
092Jf@06092Jf@040000002DUm@0U9OD09BGe0P000001`2GTL`00`000000XIG80:6Eb0060:6Eb003
0000002/V/D0[9[500T0[9[50P00000;0;ZR`00300000035Zl00aJ_00080aJ_000<000000<^^_@3;
[[d01`3;[[d00`000000e;Nm000000080=Zk^P030000003Q`;P0hL2h00D0hL2h00<000000>K8^000
00001@3WakH00`000000jLZf0>W:]P050>W:]P030000003Yck/0jLnk00H0jLnk00<000000=Rm_P3H
_Kh0203H_Kh010000000c;W70<bia`0000090;bP_@030000002_T;H0[i2f00P0[i2f00@000000:B5
/P00000000001@2NP;800`000000Vgb`09]l/00709]l/0030000002IN[00VGZ`00H0VGZ`00<00000
09Qk/@2HNk401`2HNk400`000000V7je09Qn]@0709Qn]@030000002IPkX0VH>j00@0VH>j0P000000
0`2TR[X000000:JA`0090:JA`0030000002WVLL0YiW700P0YiW70`0000060;>Yc`040000002cZLl0
/jW?000000H0/[3F0P0000030;Vhf0030000002f^mh0][_N00T0][_N00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0A0?ooo`00103oool01`3oe9/009_D0?ooo`3oool0oooD09/0LP2jj_l0
7P3oool00`000000oooo0?ooo`0B0?ooo`<000001`2N^N/00`000000VkK[09^fj`0609^fj`030000
002F/NT0U[7Y00H0U[7Y00<0000009:[i`2BZnL01@2BZnL00`000000SjCS08nTh`0308nThaT00000
0`2>T=400`000000Ui7<09NAc00709NAc0030000002QULP0XIG800L0XIG800<000000:bJa@2/V/D0
202/V/D00`000000^Z;00;ZR`00:0;ZR`00500000035Zl00aJ_00<F[`00000002`3;[[d00`000000
f[^j0=Zk^P060=Zk^P030000003Q`;P0hL2h00H0hL2h00@000000>K8^03Vb;P00000103WakH00`00
0000jLZf0>W:]P040>W:]P030000003Yck/0jLnk00H0jLnk00<000000>OEa0000000203H_Kh01@00
0000c;W70<bia`3<^LL0000000X0_:2m00<000000:n@]P2_T;H01P2_T;H3000000L0WX2b00<00000
09]l/02KO;001`2KO;000`000000VGZ`09Uj/00609Uj/0030000002HNk40V7^a00L0V7^a00<00000
09Qn]@2HO[D01`2HO[D00`000000VH>j09V3^P0209V3^P800000102TR[X00`000000YY700:JA`007
0:JA`0030000002WVLL0YiW700P0YiW700<000000;>Yc`2cZLl01`2cZLl010000000/jW?0;>Yc`00
00030;:`eP8000001@2i^=P00`000000][_N0;JkgP070;JkgP80000000<0^/;P0000003oool05`3o
ool00`000000oooo0?ooo`060?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool00@3o
ool000@0oooo00<0omBK0000000000000`0000000`2Ke?l0oooo0?ooo`0L0?ooo`030000003oool0
oooo01<0oooo00<0000009jij`2N^N/01`2N^N/00`000000VkK[09^fj`0609^fj`030000002F/NT0
U[7Y00D0U[7Y3P00000408FMhP0300000025U]d0QIKM00D0QIKM00<0000008RBe`28T]L00P28T]L4
000000P0SY3A00<0000009NAc02GTL`01`2GTL`00`000000XIG80:6Eb0060:6Eb0030000002/V/D0
[9[500H0[9[50`00000=0;ZR`00400000035Zl00aJ_0000000X0bjjm00<000000=:d^`0000001`3J
^kX00`000000hL2h0>70^0050>70^0030000003Vb;P0i/Rh0080i/Rh00@000000>O7]P3WakH00000
1`3Yb[H00`000000jLnk0>W?^`060>W?^`030000003WeL@0000000L0f;fn00<000000<bia`3<^LL0
0`3<^LL00`000000_:2m0;bP_@070;bP_@030000002_T;H0[i2f00@0[i2f0P0000000`2TR;L00000
09j0/P0709j0/P030000002KO;00Vgb`00L0Vgb`00<0000009Uj/02IN[001`2IN[000`000000V7^a
09Qk/@0709Qk/@030000002HO[D0V7je00L0V7je00@0000009V3^P00000000001P2TR[X00`000000
YY700:JA`0080:JA`0030000002WVLL0YiW700D0YiW70P0000000`2cXlP000000;>Yc`070;>Yc`05
0000002cZLl0/jW?0000002b/=H00P0000080;Vhf0030000002f^mh0][_N00@0][_N0P0000030;[2
h0030000003oool0oooo01D0oooo00<000000?ooo`000000203oool00`3DV`00002K0=Coo`020?oo
o`030>ZjV`2jj_l0oooo0080oooo000Y0?ooo`8000005@3oool00`000000W[W[09jij`0709jij`03
0000002K]^/0VkK[00H0VkK[00<0000009Jaj@2F/NT01000000208n/jP0300000029YNL0RJGW00D0
RJGW00<0000008FMhP25WN801@25WN800`000000QIKM08FFg@0508FFg@0300000028T]L000000080
00001028T]L00`000000SY3A08j@d@0508j@d@030000002GTL`0Ui7<00L0Ui7<00<000000:6Eb02Q
ULP01`2QULP00`000000[9[50:bJa@030:bJa@8000000`2^V/<00`000000^Z;00;ZR`00:0;ZR`003
00000035Zl00000000X0bjjm00@000000=:d^`3B];/000001P3J^kX00`000000hL2h0>70^0060>70
^0030000003Vb;P0i/Rh00<0i/Rh00<000000>O7]P0000001P3Yb[H00`000000jLnk0>W?^`060>W?
^`050000003WeL@0imG40>OEa00000001@3H_Kh00`000000c;W70<bia`040<bia`030000002lX;d0
_:2m00L0_:2m00<000000:n@]P2_T;H00P2_T;H2000000<0Y8Rg00<0000009j0/P2NP;801`2NP;80
0`000000Vgb`09]l/00609]l/0030000002IN[00VGZ`00L0VGZ`00<0000009Qk/@2HNk401`2HNk40
0`000000V7je09Qn]@0609Qn]@<00000202TR[X00`000000YY700:JA`0080:JA`0030000002WVLL0
YiW700<0YiW70P0000030;>Sb0030000002cZLl0/jW?00L0/jW?00@000000;>Yc`2cZLl000002P2i
^=P00`000000][_N0;JkgP020;JkgP8000001P2j`^000`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo00H0oooo00<0omBK0000LP2jj_l01P3oool002P0oooo0P00000G0?ooo`030000002N^N/0
W[W[00L0W[W[00<0000009^fj`2K]^/00`2K]^/5000000L0SjcZ00<0000008VUi`29YNL01@29YNL0
0`000000QIgR08FMhP0508FMhP0300000025U]d0QIKM00@0QIKM0P00000708RBe`030000002>T=40
SY3A00H0SY3A00<0000009NAc02GTL`01`2GTL`00`000000XIG80:6Eb0060:6Eb0040000002/V/D0
[9[50:bJa@8000001@2^V/<00`000000^Z;00;ZR`00;0;ZR`0030000003;[[d0bjjm00T0bjjm00D0
00000=:d^`3B];/0d[Bk000000050=Zk^P030000003Q`;P0hL2h00D0hL2h00<000000>K8^03Vb;P0
1@3Vb;P00`000000jLZf0>W:]P050>W:]P030000003Yck/0jLnk00D0jLnk00<000000>OEa03WeL@0
0P3WeL@00`000000f;fn0=Rm_P020=Rm_P030000003<^LL0c;W700H0c;W700<000000;bP_@2lX;d0
1`2lX;d010000000[i2f0000000000060:B8]`030000002NP;80WX2b00H0WX2b00<0000009]l/02K
O;001`2KO;000`000000VGZ`09Uj/00609Uj/0030000002HNk40V7^a00L0V7^a00<0000009Qn]@2H
O[D00`2HO[D3000000030:65]@000000Y8Zj00T0Y8Zj00<000000:JA`02VTL001`2VTL0010000000
YiW70:NIa`2WVLL2000000H0/j?800<000000;>Yc`2cZLl01`2cZLl3000000/0^KSH00@000000;Jk
gP0000000000202j`^000`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00L0oooo00<0onZj
0780001b^^X01@3oool002P0oooo00<000000?ooo`3oool05`3oool00`000000W[W[09jij`0609ji
j`H00000102E/^/00`000000SjcZ08n/jP0608n/jP0300000029YNL0RJGW00D0RJGW00<0000008FM
hP25WN801@25WN800`000000QIKM08FFg@0300000080QIKM00<0000008RBe`28T]L01@28T]L00`00
0000SY3A08j@d@0508j@d@030000002GTL`0Ui7<00L0Ui7<00<000000:6Eb02QULP01`2QULP30000
00P0[Y[300<000000;ZR`02jX/002@2jX/000`000000`:Fo000000090<^^_@030000003B];/0d[Bk
0080d[Bk00<000000=Zk^P3J^kX00P3J^kX00`000000hL2h0>70^0060>70^0030000003Vb;P0i/Rh
00@0i/Rh00<000000>cB^P0000001@3Yb[H00`000000jLnk0>W?^`060>W?^`030000003WeL@0imG4
00<0imG400@000000=Rm_P3H_Kh000002@3<^LL00`000000_:2m0;bP_@070;bP_@800000202TR;L0
0`000000WX2b09j0/P0609j0/P030000002KO;00Vgb`00L0Vgb`00<0000009Uj/02IN[001`2IN[00
0`000000V7^a09Qk/@0709Qk/@030000002HO[D00000008000001@2QQKD00`000000Y8Zj0:B:^P07
0:B:^P030000002VTL00YY7000P0YY700`0000080;>Sb0030000002cZLl0/jW?00H0/jW?0P000002
0;bdd@030000002i^=P0^KSH00P0^KSH0P00000;0;[2h0030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0203oool00`2jLP00L[[Z0?ooo`030?ooo`00:03oool00`000000oooo0?ooo`0H0?oo
o`040000002N^N/0W[W[09jij`@000000P2J]n`00`000000UK;[09Fbj`0609Fbj`030000002?[>X0
SjcZ00D0SjcZ00<0000008VUi`29YNL01@29YNL00`000000QIgR08FMhP0508FMhP<000001@25U]d0
0`000000R9;G08RBe`0508RBe`030000002>T=40SY3A00H0SY3A00<0000009NAc02GTL`01`2GTL`0
0`000000XIG80:6Eb0050:6Eb08000002P2^V/<00`000000^Z;00;ZR`0070;ZR`08000000P30YKl0
0`000000bjjm0<^^_@060<^^_@030000003B];/0d[Bk00@0d[Bk00D000000=Zk^P3J^kX0f[^j0000
00070>70^0030000003Vb;P0i/Rh00D0i/Rh00@000000>cB^P3/d[X00000103Yb[H00`000000jLnk
0>W?^`050>W?^`030000003WeL@0imG400@0imG400<000000=Rm_P0000002`3<^LL00`000000_:2m
0;bP_@040;bP_@<000002@2TR;L00`000000WX2b09j0/P0609j0/P030000002KO;00Vgb`00L0Vgb`
00<0000009Uj/02IN[001`2IN[000`000000V7^a09Qk/@0609Qk/@<00000202QQKD00`000000Y8Zj
0:B:^P070:B:^P030000002VTL00YY7000P0YY7000<000000;>Sb02cXlP02@2cXlP00`000000/jW?
0;>Yc`030;>Yc`8000000P2l]=400`000000_;CA000000080;Vhf080000000<0_l7K0000002j`^00
202j`^02000000030;g8h`000000oooo01P0oooo00<000000?ooo`3oool0203oool00`2jLY/0e?oo
0?ooo`020?ooo`00:03oool00`000000oooo0?ooo`0I0?ooo`<000001`2J]n`00`000000UK;[09Fb
j`0509Fbj`030000002?[>X0SjcZ00H0SjcZ00<0000008VUi`29YNL01@29YNL010000000QIgR08FM
hP25WN830000000308FMhP000000QIKM00H0QIKM00<0000008RBe`28T]L01@28T]L00`000000SY3A
08j@d@0508j@d@030000002GTL`0Ui7<00L0Ui7<00<000000:6Eb02QULP00`2QULP2000000030:6C
aP000000[Y[300X0[Y[300<000000;ZR`02jX/001@2jX/000`000000`:Fo0<2U_`030<2U_`030000
003;[[d0bjjm00@0bjjm00<000000=:d^`3B];/01P3B];/00`000000f[^j000000070>70^0030000
003Vb;P0i/Rh00D0i/Rh00<000000>cB^P3/d[X00P3/d[X010000000jLZf0>W:]P0000070>W?^`03
0000003WeL@0imG400H0imG400<000000<bia`3<^LL02P3<^LL00`000000_:2m0;bP_@020;bP_@80
00000`2/Ul400`000000Y8Rg0:B8]`060:B8]`030000002NP;80WX2b00L0WX2b00<0000009]l/02K
O;001P2KO;000`000000VGZ`09Uj/00709Uj/0030000002HNk40V7^a00@0V7^a0P0000000`2OPK80
00000:65]@080:65]@030000002TR[X0Y8Zj00P0Y8Zj00<000000:JA`02VTL001@2VTL03000000`0
/j?800D000000;>Yc`2cZLl0/jW?000000050;bdd@030000002l]=40000000D0^KSH0P0000040;o1
f`030000002j`^00^/;P00@0^/;P0P0000030;g8h`030000003oool0oooo01L0oooo00<000000?oo
o`3oool00`3oool00`3Z^W80VmCo0?ooo`020?ooo`030=BK002Ke?l0oooo0080oooo000X0?ooo`03
0000003oool0000001X0oooo00<0000009Zgk02J]n`01P2J]n`00`000000UK;[09Fbj`0609Fbj`03
0000002?[>X0SjcZ00H0SjcZ00<0000008VUi`29YNL01@29YNL3000000D0QIgR00<0000008FFg@25
U]d01@25U]d00`000000R9;G08RBe`0408RBe`030000002>T=40SY3A00H0SY3A00<0000009NAc02G
TL`01`2GTL`00`000000XIG800000002000000@0XI?600<000000:jJ``2^V/<0202^V/<00`000000
^Z;00;ZR`0040;ZR`00300000030YKl0`:Fo00@0`:Fo00<000000<^^_@3;[[d0103;[[d00`000000
d[Bk0=:d^`060=:d^`030000003J^kX0000000L0hL2h00<000000>K8^03Vb;P01@3Vb;P00`000000
k=:j0>cB^P030>cB^P030000003Yb[H0000000H0jLnk00<000000>OEa03WeL@01P3WeL@00`000000
g]cD0000000<0<bia`040000002lX;d00000000000D0[9O100<000000:B8]`2TR;L01`2TR;L00`00
0000WX2b09j0/P0609j0/P030000002KO;00Vgb`00L0Vgb`00<0000009Uj/02IN[001P2IN[000`00
0000V7^a09Qk/@0209Qk/@800000102OPK800`000000XHFe0:65]@060:65]@030000002TR[X0Y8Zj
00P0Y8Zj00<000000:JA`02VTL000`2VTL02000000<0/Ic100<000000;>Sb02cXlP02@2cXlP01000
0000/jW?0000000000070;bdd@8000000`2i^=P2000000H0_l7K00<000000;[2h02j`^000P2j`^02
000000H0_LSS00<000000?ooo`3oool05P3oool2000000@0oooo00L0omBK0000V`3Dool0oooo0?oD
V`000780^^[o00<0oooo000X0?ooo`800000703oool00`000000V[O/09Zgk00609Zgk0030000002E
/^/0UK;[00H0UK;[00<0000008n/jP2?[>X00`2?[>X?000000<0QIgR00<0000008FFg@25U]d01@25
U]d00`000000R9;G08RBe`0508RBe`030000002>T=40SY3A00D0SY3A00<0000009NAc02GTL`01@2G
TL`4000000L0XI?600<000000:jJ``2^V/<02@2^V/<00`000000^Z;00;ZR`0020;ZR`00300000030
YKl0`:Fo00H0`:Fo00<000000<^^_@3;[[d00P3;[[d00`000000d[Bk0=:d^`080=:d^`030000003Q
`;P0hL2h00D0hL2h00<000000>K8^03Vb;P01@3Vb;P00`000000k=:j0>cB^P050>cB^P030000003Y
ck/0jLnk00D0jLnk00<000000>OEa03WeL@01@3WeL@010000000g]cD0=kLe000000<0<bia`800000
1`2/Ul400`000000Y8Rg0:B8]`070:B8]`030000002NP;80WX2b00H0WX2b00<0000009]l/02KO;00
1`2KO;000`000000VGZ`09Uj/00709Uj/0040000002HNk400000000000H0Wh6b00<000000:65]@2Q
QKD01`2QQKD00`000000Y8Zj0:B:^P070:B:^P040000002VTL00YY700:JA`08000001@2aW<400`00
0000/j?80;>Sb00:0;>Sb0030000002l]=40_;CA00L0_;CA00<000000;bdd@0000000P0000090;o1
f`040000002j`^000000000000T0_LSS00<000000?ooo`3oool04P3oool3000000030?ooo`000000
oooo00@0oooo00D0omBK000000000000001b0;[Zo`040?ooo`002P3oool01@3oe9/0000000000000
0000VmCo00D0oooo00<0e9/000000000Vm@0103oool00`3oe9/000000000000300000003002Ke03o
ool0oooo00@0oooo00<000000?ooo`3oool0703oool00`000000V[O/09Zgk00609Zgk0030000002E
/^/0UK;[00<0UK;[2000000408JXj`<000001@1mW^L00`000000N9GS07REh`0@000000<0R9;G00<0
000008j@d@2>T=401P2>T=400`000000Ui7<09NAc00400000080U8k;00<000000:6CaP2QTlH01`2Q
TlH00`000000[Y[30:jJ``080:jJ``030000002jX/00^Z;0008000002@30YKl01@000000bjjm0<^^
_@3;[[d0000000X0d[Bk00<000000=Zm_00000001P3Q`;P00`000000i/Rh0>K8^0050>K8^0030000
003/d[X0k=:j00@0k=:j00<000000?3O_P0000001@3Yck/00`000000imG40>OEa0050>OEa0030000
003Ng=@0g]cD0080g]cD00<000000<bia`3<^LL01`3<^LL3000000T0[9O100<000000:B8]`2TR;L0
1P2TR;L00`000000WX2b09j0/P0609j0/P030000002KO;00Vgb`00L0Vgb`00<0000009Uj/02IN[00
1P2IN[03000000P0Wh6b00<000000:65]@2QQKD01`2QQKD00`000000Y8Zj0:B:^P080:B:^P<00000
202aW<400`000000/j?80;>Sb0080;>Sb08000002P2l]=42000000`0_l7K00<000000;g8h`2mb><0
2@2mb><00`000000oooo0?ooo`0>0?ooo`@00000103oool00`000000oooo0?ooo`0<0?ooo`002P3o
ool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@01`3oool00`2jLW80
^^[o0?ooo`060?ooo`030000003oool0oooo01h0oooo00<0000009Zgk02J]n`01@2J]n`6000000@0
SZo]00<0000008JXj`26Z>/00P26Z>/30000000308JXj`000000OIkW00D0OIkW00<0000007REh`1h
UN<01@1hUN<00`000000N8kL07R>g00407R>g0040000001mRmH0OH_F07f;ePl000001`2DS//00`00
0000XI?60:6CaP060:6CaP030000002^V/<0[Y[300T0[Y[30P00000<0<2U_`030000003;[[d00000
00/0d[Bk00@000000=Zm_03J_K`00000103Q`;P00`000000i/Rh0>K8^0050>K8^0030000003/d[X0
k=:j00D0k=:j00<000000?3O_P3`gkh00P0000020>W?^`030000003WeL@0imG400D0imG400<00000
0=kLe03Ng=@0103Ng=@00`000000c;W70<bia`040<bia`8000000`2g/M<00`000000[9O10:bG`@06
0:bG`@030000002TR;L0Y8Rg00H0Y8Rg00<0000009j0/P2NP;801`2NP;800`000000Vgb`09]l/006
09]l/0030000002IN[00VGZ`00<0VGZ`0`0000000`2MO[40000009n1/P0809n1/P030000002QQKD0
XHFe00L0XHFe00<000000:B:^P2TR[X0202TR[X00`000000/Ic10;6L`@080;6L`@030000002cXlP0
/j?800H0/j?80P0000020;j_b`030000002l]=40_;CA00L0_;CA0`0000090;o1f`80000000<0a<[N
0000002mb><02P2mb><00`000000oooo0?ooo`0:0?ooo`<00000203oool00`000000oooo0?ooo`0<
0?ooo`002@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00d0oooo00<0^W9b0;[Z
o`3oool01P3oool00`000000oooo0?ooo`0O0?ooo`030000002J]n`0V[O/00@000000P2F]^d00`00
0000SZo]08j_k@0608j_k@0400000026Z>/00000000000D0QZS[00<0000007fNi`1mW^L0101mW^L0
0`000000N9GS07REh`0407REh`030000001hS]`0N8kL00D0N8kL00<0000007f;eP1mRmH0101mRmH0
0`000000Qh_@08N;d00508N;d0030000002DS//0U8k;00L0U8k;00<000000:6CaP2QTlH01`2QTlH0
0`000000[Y[30:jJ``080:jJ``0300000030YKl0`:Fo00/0`:Fo00<000000<^^_@0000002P3B];/0
1@000000f[fl0=Zm_03J_K`0000000@0hL2h00<000000>K8^03Vb;P0103Vb;P00`000000k=:j0>cB
^P050>cB^P030000003`gkh0l=nn00<0l=nn00<000000>W?^`0000001`3WeL@00`000000g]cD0=kL
e0050=kLe0040000003<^LL0c;W70<bia`8000001@2g/M<00`000000[9O10:bG`@060:bG`@030000
002TR;L0Y8Rg00L0Y8Rg00<0000009j0/P2NP;801P2NP;800`000000Vgb`09]l/00709]l/0030000
002IN[000000008000001@2MO[400`000000Wh6b09n1/P0709n1/P030000002QQKD0XHFe00L0XHFe
00<000000:B:^P2TR[X01@2TR[X3000000/0/Ic100<000000;>Sb02cXlP0102cXlP00`000000_Zo;
0;j_b`020;j_b`030000002l]=40_;CA00H0_;CA00@000000<Boe@34_mD00000202o`M/01@000000
a<[N0<C:gP34b]h0000000T0_LSS0P0000000`2ncND000000?ooo`070?ooo`<00000303oool00`00
0000oooo0?ooo`0;0?ooo`002@3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00d0
oooo00<0^W9b0;[Zo`3oool01P3oool200000240oooo0P00000709Jfk@030000002>[nd0SZo]00@0
SZo]0`00000708JXj`030000001mW^L0OIkW00@0OIkW00<0000007REh`1hUN<01@1hUN<00`000000
N8kL07R>g00407R>g0030000001mRmH0OH_F00D0OH_F00<0000008N;d027Rm001@27Rm000`000000
U8k;09B>b`0709B>b`030000002QTlH0XI?600H0XI?600<000000:jJ``2^V/<01`2^V/<00`000000
/Yg20000000=0<2U_`030000003B];/0d[Bk00P0d[Bk00<000000=Zm_03J_K`00`3J_K`010000000
hL2h0>70^00000070>K8^0030000003/d[X0k=:j00@0k=:j00<000000?3O_P3`gkh01@3`gkh00`00
0000imG40>OEa0050>OEa0030000003Ng=@0g]cD00H0g]cD00@000000<bia`00000000001`2g/M<0
0`000000[9O10:bG`@070:bG`@030000002TR;L0Y8Rg00H0Y8Rg00<0000009j0/P2NP;801P2NP;80
0`000000Vgb`09]l/00609]l/0<00000202MO[400`000000Wh6b09n1/P0709n1/P030000002QQKD0
XHFe00L0XHFe00<000000:B:^P2TR[X0102TR[X01@000000[iFl0:nE_02_UK`0000000X0/Ic100<0
00000;>Sb02cXlP00`2cXlP00`000000_Zo;0;j_b`040;j_b`030000002l]=40_;CA00@0_;CA00@0
00000<Boe@34_mD0a;oE0P0000050;o1f`8000001@34b]h00`000000_LSS0;g8h`040;g8h`800000
0`2ncND00`000000oooo0?ooo`020?ooo`@000003`3oool00`000000oooo0?ooo`0;0?ooo`002@3o
ool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00d0oooo00<0^W9b0;[Zo`3oool01P3o
ool00`000000oooo0?ooo`0Q0?ooo`030000002F]^d0U[K]00H0U[K]00<0000008j_k@2>[nd00`00
000308j_k@0300000026Z>/0QZS[00D0QZS[00<0000007fNi`1mW^L0101mW^L00`000000N9GS07RE
h`0407REh`030000001hS]`0N8kL00D0N8kL00<0000007f;eP1mRmH0101mRmH00`000000Qh_@08N;
d00508N;d0030000002DS//0U8k;00L0U8k;00<000000:6CaP2QTlH01`2QTlH00`000000[Y[30:jJ
``040:jJ``8000000P2bWL800`000000`:Fo0<2U_`0:0<2U_`0300000037[L00000000T0d[Bk00<0
00000=Zm_03J_K`0103J_K`00`000000hL2h000000060>K8^0030000003/d[X0k=:j00D0k=:j00<0
00000?3O_P3`gkh0103`gkh010000000k_370000000000040>OEa0030000003Ng=@0g]cD00P0g]cD
00<000000;Nad`2g/M<0202g/M<00`000000[9O10:bG`@060:bG`@030000002TR;L0Y8Rg00H0Y8Rg
00<0000009j0/P2NP;801P2NP;800`000000Vgb`09]l/00309]l/0<0000000<0Vgfa0000002MO[40
202MO[400`000000Wh6b09n1/P0709n1/P030000002QQKD0XHFe00L0XHFe00<000000:B:^P2TR[X0
0P2TR[X2000000@0[iFl00<000000;6L`@2aW<402@2aW<400`000000/j?80;>Sb002000000L0_Zo;
00<000000;bdd@2l]=400P2l]=42000000D0a;oE0P0000030;o1f`0300000034b]h0a<[N00H0a<[N
00@000000;g8h`2mb><0_LSS0P0000060;k=i@@000004`3oool00`000000oooo0?ooo`0;0?ooo`00
2@3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00d0oooo00<0^W9b0;[Zo`3oool0
1P3oool00`000000oooo0?ooo`0R0?ooo`030000002F]^d0U[K]00D0U[K]0`00000708j_k@030000
0026Z>/0QZS[00D0QZS[00<0000007fNi`1mW^L0101mW^L00`000000N9GS07REh`0407REh`030000
001hS]`0N8kL00@0N8kL00<0000007f;eP1mRmH01@1mRmH00`000000Qh_@08N;d00508N;d0030000
002DS//0U8k;00H0U8k;00<000000:6CaP2QTlH01`2QTlH00`000000[Y[30:jJ``030:jJ``030000
002bWL80/Yg200<0/Yg200<000000<2U_`30YKl02030YKl010000000ajg00<N]`00000080=:d^`03
0000003J_K`0f[fl00H0f[fl00<000000>K8^03Vb;P01@3Vb;P00`000000k=:j0>cB^P040>cB^P03
0000003`gkh0l=nn00@0l=nn00<000000>k`a`3^l<L00P3^l<L2000000030>OEa0000000g]cD00P0
g]cD0P0000000`31h>l000000;Nad`080;Nad`030000002/Ul40[9O100H0[9O100<000000:B8]`2T
R;L01P2TR;L00`000000WX2b09j0/P0709j0/P030000002KO;000000008000001@2KOK400`000000
WGja09en/@0609en/@030000002OPK80Wh6b00P0Wh6b00<000000:65]@2QQKD01P2QQKD01@000000
Y8Zj0:B:^P2TR[X0000000L0[iFl00<000000;6L`@2aW<40202aW<400`000000/j?80000000:0;j_
b`040000002l]=40_;CA000000P0a;oE00@000000;o1f`00000000002@34b]h010000000_LSS0000
000000080;k=i@030000003oool0oooo01@0oooo00<000000?ooo`3oool02`3oool000T0oooo00<0
omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0=0?ooo`030;YbLP2jj_l0oooo00H0oooo00<0
00000?ooo`3oool08`3oool010000000U[K]09Jfk@2F]^d300000080U[K]00<0000008j_k@2>[nd0
0`2>[nd?00000080OIkW00<0000007REh`1hUN<0101hUN<00`000000N8kL07R>g00507R>g0030000
001mRmH0OH_F00@0OH_F00<0000008N;d027Rm001@27Rm000`000000U8k;09B>b`0709B>b`030000
002QTlH0XI?600L0XI?600D000000:jJ``2^V/<0[Y[3000000060;:M`P0300000030YKl0`:Fo00L0
`:Fo00<000000<N]`037[L000P37[L000`000000d[Bk0=:d^`040=:d^`030000003J_K`0f[fl00H0
f[fl00<000000>?:_P0000001@3Vb;P00`000000k=:j0>cB^P040>cB^P030000003`gkh0l=nn00D0
l=nn00<000000>k`a`3^l<L0103^l<L00`000000g]cD0=kLe0070=kLe00500000031h>l0`N3_0<7P
k`0000002@2g/M<00`000000[9O10:bG`@070:bG`@030000002TR;L0Y8Rg00H0Y8Rg00<0000009j0
/P2NP;80102NP;84000000P0Vgfa00<0000009en/@2MO[401`2MO[400`000000Wh6b09n1/P0709n1
/P030000002QQKD0XHFe00L0XHFe0`0000080:nE_0030000002aW<40/Ic100T0/Ic100<000000;j_
b`2n[l/02@2n[l/00`000000_;CA000000090<Boe@8000003034b]h00`000000_/gU0;k=i@080;k=
i@8000005@3oool00`000000oooo0?ooo`0;0?ooo`002P3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K
0=Coo`/0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`060?ooo`030000003oool0oooo02D0oooo0`00
000309Jfk@P000001026[Nl00`000000NZ?]07ZSk@0507ZSk@030000001^V>T0KYSY00D000001@1h
UN<00`000000N8kL07R>g00407R>g0030000001mRmH0OH_F00D0OH_F00<0000008N;d027Rm001@27
Rm000`000000U8k;09B>b`0609B>b`030000002QTlH0XI?600L0XI?600@000000:jJ``0000000000
202bWL800`000000`:Fo0<2U_`050<2U_`0300000037[L00ajg000<0ajg000<000000=:d^`3B];/0
0`3B];/00`000000f[fl0=Zm_0070=Zm_0040000003Sb[h0hlZn000000@0i/Rh00<000000>cB^P3/
d[X0103/d[X00`000000l=nn0?3O_P040?3O_P030000003^l<L0k_3700@0k_3700@000000=SodP00
000000001@3Ng=@2000000D0`N3_00<000000;Nad`2g/M<01`2g/M<00`000000[9O10:bG`@060:bG
`@030000002TR;L0Y8Rg00H0Y8Rg00<0000009j0/P2NP;801000000209Un]0030000002KOK40Vgfa
00L0Vgfa00<0000009en/@2MO[401`2MO[400`000000Wh6b09n1/P0709n1/P030000002QQKD0XHFe
00L0XHFe00<000000:nE_02_UK`0202_UK`00`000000/Ic10;6L`@080;6L`@800000302n[l/00`00
0000a;oE0<Boe@080<Boe@<000002@34b]h2000000030<KAh`000000_/gU00H0_/gU0P0000020;g@
j0030000003oool0oooo0180oooo00<000000?ooo`3oool02`3oool000X0oooo00D0oooD09/00000
0000001b0;[Zo`0>0?ooo`030>ZjLP000780^^[o00H0oooo0P00000S0?ooo`<0000000<0oooo0000
000000000`000004092dk`0300000026[Nl0QZg_00D0QZg_00<0000007ZSk@1jXnd01@1jXnd00`00
0000KYSY06jHj@0406jHj@D0000000<0N9GS0000001hS]`01P1hS]`00`000000OH_F07f;eP0407f;
eP0300000027Rm00Qh_@00D0Qh_@00<0000009B>b`2DS//01`2DS//00`000000XI?60:6CaP060:6C
aP8000002P2bWL800`000000`:Fo0<2U_`040<2U_`0300000037[L00ajg000D0ajg000<000000=:d
^`3B];/00P3B];/00`000000f[fl0=Zm_0060=Zm_0030000003Sb[h0hlZn0080hlZn00@000000>K8
^03Vb;P000001P3/d[X00`000000l=nn0?3O_P040?3O_P030000003^l<L0k_3700@0k_3700<00000
0=SodP3Hom800P3Hom82000000030=kLe0000000000000P0`N3_00<000000;Nad`2g/M<01P2g/M<0
0`000000[9O10:bG`@060:bG`@030000002TR;L0Y8Rg00D0Y8Rg1000000709Un]0030000002KOK40
Vgfa00H0Vgfa00<0000009en/@2MO[401`2MO[400`000000Wh6b09n1/P0809n1/P030000002QQKD0
XHFe00D0XHFe0P00000;0:nE_0030000002aW<40/Ic100D0/Ic10P0000020;fYa@030000002n[l/0
_Zo;00P0_Zo;00<000000<Rmc`0000002034_mD00`000000bl_J0<_;fP02000000H0a<[N0P000003
0<KAh`030000002ncND0_/gU00<0_/gU0P0000050;g@j0030000003oool0oooo0140oooo00<00000
0?ooo`3oool02`3oool002H0oooo00<000000?ooo`3oool07`3oool3000000D0oooo00<00000092d
k`2@]>l01P2@]>l00`000000QZg_08J]k`0508J]k`030000001jXnd0NZ?]00D0NZ?]00<0000006jH
j@1^V>T00`1^V>T00`000000IXkT06J>i00206J>i0H000000`1hS]`00`000000OH_F07f;eP0507f;
eP0300000027Rm00Qh_@00D0Qh_@00<0000009B>b`2DS//01P2DS//00`000000XI?60:6CaP030:6C
aP<0000000<0XYG70000002bWL802P2bWL800`000000`:Fo0<2U_`030<2U_`0300000037[L00ajg0
00D0ajg000D000000=:d^`3B];/0d[Bk000000090=Zm_0030000003Sb[h0hlZn00<0hlZn00<00000
0>K8^00000001P3/d[X00`000000l=nn0?3O_P030?3O_P030000003^l<L0k_3700@0k_3700<00000
0=SodP3Hom801@3Hom800`000000`N3_0<7Pk`090<7Pk`030000002g/M<0]k7C00D0]k7C00<00000
0:bG`@2/Ul401`2/Ul400`000000Y8Rg0:B8]`040000000309N2^`000000VGjd00P0VGjd00<00000
09]m/@2KOK401`2KOK400`000000WGja09en/@0609en/@030000002OPK80Wh6b00P0Wh6b00<00000
0:65]@2QQKD00`2QQKD200000080[8nh00<000000:nE_02_UK`0202_UK`00`000000/Ic10;6L`@04
0;6L`@030000002mZLD0_JW50080_JW500<000000;j_b`2n[l/01P2n[l/200000080b;g?00<00000
0<Boe@34_mD01@34_mD00`000000bl_J0<_;fP020<_;fP0300000034b]h0a<[N0080a<[N0P000006
0<KAh`030000002ncND0_/gU00800000202md>P00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00/0oooo000V0?ooo`030000003oool0oooo01d0oooo0P0000090?ooo`030000002@]>l0T;C_
00H0T;C_00<0000008J]k`26[Nl01@26[Nl00`000000NZ?]07ZSk@0507ZSk@030000001^V>T0KYSY
00<0KYSY00<0000006J>i01VS^@0101VS^@00`000000IXKN06J6gP06000000D0OH_F00<0000008N;
d027Rm001@27Rm000`000000U8k;09B>b`0709B>b`030000002QTlH00000008000001@2RULL00`00
0000/Yg20;:M`P080;:M`P0300000030YKl0`:Fo0080`:Fo00<000000<N]`037[L001`37[L000`00
0000d[Bk000000090=Zm_0030000003Sb[h0hlZn00D0hlZn00<000000>cB^P3/d[X0103/d[X00`00
0000l=nn0?3O_P040?3O_P030000003^l<L0k_3700<0k_3700<000000=SodP3Hom80103Hom820000
000308GYb`000000`N3_00T0`N3_00<000000;Nad`2g/M<01P2g/M<00`000000[9O10:bG`@020:bG
`@L000001P2GP[/00`000000VGjd09Un]00609Un]0030000002KOK40Vgfa00L0Vgfa00<0000009en
/@2MO[401`2MO[400`000000Wh6b09n1/P0709n1/P030000002QQKD0XHFe0080XHFe00<000000:b?
^02/SkP00P2/SkP00`000000[iFl0:nE_0090:nE_0030000002aW<40/Ic10080/Ic100<000000;fY
a@2mZLD0102mZLD00`000000_Zo;0;j_b`040;j_b`0300000038_Ll0b;g?00<0b;g?00<000000<Bo
e@34_mD00P34_mD2000000D0bl_J0P0000000`34b]h00000000000090<KAh`8000002`2md>P00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00X0oooo000V0?ooo`030000003oool0oooo01X0
oooo0`00000<0?ooo`030000002@]>l0T;C_00H0T;C_00<0000008J]k`26[Nl01@26[Nl00`000000
NZ?]07ZSk@0507ZSk@030000001^V>T0KYSY00<0KYSY00<0000006J>i01VS^@00`1VS^@00`000000
IXKN06J6gP0406J6gP030000001_Q=P0000000<000000P1mRmH00`000000Qh_@08N;d00508N;d003
0000002DS//0U8k;0080U8k;1P0000080::Ea`030000002bWL80/Yg200T0/Yg200@000000<2U_`30
YKl000002P37[L000`000000d[Bk000000080=Zm_0030000003Sb[h0hlZn00D0hlZn00@000000>cL
`P00000000000`3/d[X00`000000l=nn0?3O_P040?3O_P030000003^l<L0k_3700<0k_3700<00000
0=SodP3Hom800`3Hom82000000@0QNW;0P0000050<7Pka400000102ES<P00`000000Uh:k09N2^`06
09N2^`030000002IO[@0VGjd00H0VGjd00<0000009]m/@2KOK401`2KOK400`000000WGja09en/@07
09en/@030000002OPK80Wh6b00L0Wh6b00D000000:65]@2QQKD0XHFe000000060:b?^0030000002_
UK`0[iFl00P0[iFl00<000000;6L`@2aW<400P0000070;fYa@030000002n[l/0_Zo;00<0_Zo;00<0
00000<Rmc`38_Ll01@38_Ll010000000a;oE0<Boe@0000080<_;fP8000002P36dN<00`000000a]OV
000000090;g@j080000000<0^m7[0000003oool0403oool00`000000oooo0?ooo`0:0?ooo`009P3o
ool00`000000oooo0?ooo`0G0?ooo`<00000403oool00`000000T;C_092dk`06092dk`0300000026
[Nl0QZg_00@0QZg_00<0000007ZSk@1jXnd01@1jXnd00`000000KYSY06jHj@0406jHj@030000001V
S^@0IXkT00<0IXkT00<0000006J6gP1VQ]h0101VQ]h00`000000KhCH06n4f00206n4f0l00000102@
SLd00`000000XYG70::Ea`080::Ea`030000002bWL80/Yg200P0/Yg200<000000<2U_`0000003037
[L000`000000f[fl0=Zm_0070=Zm_0030000003Sb[h0hlZn00D0hlZn00@000000>cL`P3/g<80k=c2
0P0000000`3/d[X000000?3O_P040?3O_P030000003^l<L0k_3700<0k_3700<000000=SodP3Hom80
0P3Hom8?000000D0K<?n00<0000008nQh@2?XN40102?XN400`000000UHc809F<b00709F<b0030000
002GP[/0Uh:k00D0Uh:k00<0000009Un]02IO[@01`2IO[@00`000000Vgfa09]m/@0609]m/@030000
002MO[40WGja00L0WGja00<0000009n1/P2OPK80202OPK83000000L0[8nh00<000000:nE_02_UK`0
2@2_UK`2000000X0_JW500<000000;j_b`2n[l/00P0000080<Rmc`0300000034_mD0000000T0bl_J
0`0000070<KAh`8000000`36enH00`000000_M3X0;g@j0040;g@j08000000`2kdN/00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00X0oooo000U0?ooo`030000003oool0000001D0oooo0`00
000D0?ooo`030000002@]>l0T;C_00<0T;C_5000000406jHj@030000001VS^@0IXkT00@0IXkT00<0
000006J6gP1VQ]h00`1VQ]h00`000000KhCH06n4f00406n4f0030000001nQm80OXOB00H0OXOB00<0
0000092=c@2@SLd01P2@SLd00`000000XYG70::Ea`070::Ea`030000002bWL80/Yg200T0/Yg200<0
00000<N]`037[L002P37[L000`000000d;W3000000070=Zm_0030000003Sb[h0hlZn00D0hlZn00<0
00000>cL`P3/g<80103/g<82000000@0l=nn00<000000>k`a`3^l<L00`3^l<L010000000f?oB0=So
dP3Hom8300000080Y:GG1@00000307VAgP<000001P1/`oh00`000000Sj7Q08nQh@0508nQh@030000
002ES<P0UHc800H0UHc800<0000009N2^`2GP[/01@2GP[/00`000000VGjd09Un]00709Un]0030000
002KOK40Vgfa00L0Vgfa00<0000009en/@2MO[401`2MO[400`000000Wh6b09n1/P0709n1/P030000
002/SkP0[8nh00L0[8nh00<000000:nE_02_UK`02@2_UK`00`000000_JW50;fYa@090;fYa@030000
002n[l/0000000/0b;g?00<000000<_;fP3;bmX01P3;bmX200000080c]KO0P0000050<KAh`030000
0036enH0a]OV00<0a]OV00<000000;g@j02md>P00P2md>P2000000H0^m7[00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0:0?ooo`009@3oool2000001<0oooo0`00000H0?ooo`D00000102:
/o400`000000O:_a07b[l@0407b[l@030000001[Wnl0Jio_00D0Jio_1@0000000`1^V>T0000006J>
i00506J>i0030000001VQ]h0IXKN00<0IXKN00<0000006n4f01_Q=P0101_Q=P00`000000OXOB07j7
dP0507j7dP030000002@SLd0T8g=00H0T8g=00<000000::Ea`2RULL01`2RULL00`000000/Yg20;:M
`P080;:M`P8000002`37[L0010000000d;W30=2i``0000070=Zm_0030000003Sb[h0hlZn00@0hlZn
00<000000>cL`P3/g<80103/g<800`000000ko;40>oba00200000080l=nn00<000000>k`a`3^l<L0
0P3^l<L00`000000f?oB0000000700000080XYS;00<0000008B9d024RM001@0000000`0^J=P00000
0000000506c3oP030000002?XN40Sj7Q00@0Sj7Q00<0000009F<b02ES<P01P2ES<P00`000000Uh:k
09N2^`0609N2^`030000002IO[@0VGjd00H0VGjd00<0000009]m/@2KOK401`2KOK400`000000WGja
09en/@0709en/@030000002OPK80Wh6b00D0Wh6b0`00000:0:b?^0030000002_UK`0[iFl00L0[iFl
0P00000<0;fYa@0300000038_Ll0b;g?00T0b;g?00<000000=7<e@0000001P3;bmX00`000000c]KO
0<kFg`020<kFg`8000001036dN<00`000000a]OV0<KGiP050<KGiP040000002md>P00000000000P0
^m7[00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0:0?ooo`009@3oool00`000000oooo
0?ooo`0?0?ooo`<00000703oool00`000000R[?a08Zcl@0608Zcl@030000001lZo40O:_a00@0O:_a
00<0000006^Ok`1[Wnl01@1[Wnl010000000FY7[05ZAj`1JTN/4000000@0IXkT00<0000006J6gP1V
Q]h00`1VQ]h00`000000KhCH06n4f00406n4f0030000001nQm80OXOB00H0OXOB00<00000092=c@2@
SLd01P2@SLd00`000000XYG70::Ea`070::Ea`030000002bWL80/Yg200D0/Yg20P0000020;RUaP03
00000037[L00ajg000P0ajg000D000000=2i``3@^L<0d;W3000000050=Zm_0030000003Sb[h0hlZn
00D0hlZn00<000000>cL`P3/g<80103/g<800`000000ko;40>oba0020>oba0d000001P2RV</00`00
0000Q8W@08B9d00408B9d0H000000`1/`oh00`000000Sj7Q08nQh@0508nQh@030000002ES<P0UHc8
00D0UHc800<0000009N2^`2GP[/01P2GP[/00`000000VGjd09Un]00609Un]0030000002KOK40Vgfa
00L0Vgfa00<0000009en/@2MO[401`2MO[400`000000Wh6b09n1/P0309n1/P8000000`2WR[H00`00
0000[8nh0:b?^0070:b?^0030000002_UK`0[iFl00D0[iFl0P0000020;^S`@030000002mZLD0_JW5
00P0_JW500<000000<Vib`0000002@38_Ll010000000dLcE0=7<e@0000050<_;fP030000003>e]l0
c]KO00@0c]KO0P0000000`36dN<00000000000090<KGiP030000002kdN/0^m7[00P0^m7[0P00000?
0?ooo`030000003oool0oooo00X0oooo000U0?ooo`030000003oool0oooo00`0oooo0`00000P0?oo
o`030000002:/o40R[?a00H0R[?a00<0000007b[l@1lZo40101lZo400`000000Jio_06^Ok`0506^O
k`030000001JTN/0FY7[00<0FY7[1@0000000`1VS^@0000006J6gP0406J6gP030000001_Q=P0KhCH
00@0KhCH00<0000007j7dP1nQm801@1nQm800`000000T8g=092=c@06092=c@030000002RULL0XYG7
00L0XYG700<000000;:M`P2bWL80102bWL800`000000^:G60;RUaP020;RUaP0300000037[L00ajg0
00L0ajg000<000000=2i``3@^L<00P3@^L<00`000000f[fl0=Zm_0020=Zm_0030000003Sb[h0hlZn
00D0hlZn00<000000>cL`P3/g<80103/g<800`000000ko;40>oba0030>oba0030000003FoKT0e_fi
0080e_fi00<0000007_AQP000000100000080::Hb`0300000024RM00Q8W@00@0Q8W@00<00000055_
dP0000001000000206c3oP030000002?XN40Sj7Q00@0Sj7Q00<0000009F<b02ES<P01P2ES<P00`00
0000Uh:k09N2^`0509N2^`030000002IO[@0VGjd00L0VGjd00<0000009]m/@2KOK401P2KOK400`00
0000WGja09en/@0709en/@040000002OPK80Wh6b09n1/P8000001@2WR[H00`000000[8nh0:b?^007
0:b?^0030000002_UK`0[iFl00@0[iFl00<000000;^S`@2kXl400P2kXl400`000000_JW50;fYa@07
0;fYa@0400000039^L/0bKW;000000P0b;g?00<000000=7<e@3Ac=D00P3Ac=D00`000000bl_J0<_;
fP02000000P0c]KO0P0000090<KGiP80000000<0`mWZ0000002kdN/01P2kdN/200000080^=7/00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0:0?ooo`009@3oool00`000000oooo0?ooo`09
0?ooo`<00000903oool2000000L0R[?a00<0000007b[l@1lZo40101lZo400`000000Jio_06^Ok`04
06^Ok`030000001JTN/0FY7[00<0FY7[00<0000004j5iP1>QNH00P1>QNH4000000<0IXKN00<00000
06n4f01_Q=P0101_Q=P00`000000OXOB07j7dP0607j7dP030000002@SLd0T8g=00D0T8g=00<00000
0::Ea`2RULL0202RULL00`000000/Yg20;:M`P020;:M`P030000002hYLH0^:G600@0^:G600<00000
0<N]`037[L001@37[L000`000000d;W30=2i``040=2i``050000003J_K`0f[fl0=Zm_00000001P3S
b[h00`000000k=c20>cL`P040>cL`P030000003_l/@0ko;400@0ko;400@000000=Km^@3FoKT0e_fi
0`0000000`2i[ll000000;BRaP020;BRaP030000002RV</0XYS;00D0XYS;00<0000008B9d024RM00
1024RM0010000000DFoB055_dP1AKm8200000004001Rb`0000000000000000L0Sj7Q00<0000009F<
b02ES<P01@2ES<P00`000000Uh:k09N2^`0609N2^`030000002IO[@0VGjd00H0VGjd00<0000009]m
/@2KOK401`2KOK400`000000WGja09en/@0709en/@<000001`2WR[H00`000000[8nh0:b?^0080:b?
^0030000002_UK`0[iFl0080[iFl00<000000;^S`@2kXl40102kXl400`000000_JW50;fYa@050;fY
a@0300000039^L/0bKW;0080bKW;00<000000<Rmc`38_Ll00`38_Ll2000000D0dLcE00<000000<_;
fP0000002@3>e]l4000000H0a]OV0P0000030<?IjP030000002kdN/0^m7[00<0^m7[0P0000040;SA
k0030000003oool0oooo00d0oooo00<000000?ooo`3oool02@3oool002D0oooo0P0000080?ooo`80
0000:@3oool00`000000R[?a08Zcl@0208Zcl@L000000`1lZo400`000000Jio_06^Ok`0406^Ok`03
0000001JTN/0FY7[00<0FY7[00<0000004j5iP1>QNH0101>QNH300000080IXKN00<0000006n4f01_
Q=P0101_Q=P00`000000OXOB07j7dP0507j7dP030000002@SLd0T8g=00H0T8g=00<000000::Ea`2R
ULL01`2RULL00`000000/Yg20;:M`P02000000L0^:G600<000000<N]`037[L001037[L000`000000
d;W30=2i``060=2i``030000003J_K`0000000L0hlZn00<000000>cL`P3/g<80103/g<800`000000
ko;40>oba0030>oba0040000003FoKT0e_fi0=Km^@80000000<0^Jo?000000000000102dX/H00`00
0000XYS;0::Hb`060::Hb`0300000024RM00Q8W@00@0Q8W@00<00000055_dP1AKm800P1AKm800`00
000006;;001Rb`03000000D0Sj7Q00<0000009F<b02ES<P01@2ES<P00`000000Uh:k09N2^`0609N2
^`030000002IO[@0VGjd00H0VGjd00<0000009]m/@2KOK401`2KOK400`000000WGja09en/@0609en
/@8000002@2WR[H00`000000[8nh0:b?^0080:b?^0030000002_UK`0[iFl008000001`2kXl400`00
0000_JW50;fYa@030;fYa@8000001@39^L/00`000000b;g?0<Rmc`020<Rmc`030000003Ac=D0dLcE
00H0dLcE00<000000<kFg`3>e]l01`3>e]l00`000000c]kT0<kNi002000000@0a]OV0P0000060<?I
jP030000002kdN/0^m7[008000001`2hdN`00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00T0oooo000T0?ooo`8000001P3oool3000002`0oooo1000000408Bcl`030000001bZO@0LZWd00P0
00000`1[Wnl00`000000FY7[05ZAj`0305ZAj`030000001>QNH0CXGV00<0CXGV00<0000004enh@1=
O^400`00000606n4f0030000001nQm80OXOB00H0OXOB00<00000092=c@2@SLd01@2@SLd00`000000
XYG70::Ea`080::Ea`8000002P2hYLH00`000000ajg00<N]`0020<N]`0030000003@^L<0d;W300L0
d;W300<000000=Zm_00000001P3Sb[h00`000000k=c20>cL`P040>cL`P030000003_l/@0ko;400<0
ko;400H000000=Km^@3FoKT0e_fi0000002i[ll2000000L0]:;600<000000::Hb`2RV</01@2RV</0
0`000000Q8W@08B9d00408B9d0030000001AKm80DFoB00<0DFoB00@00000001Rb`00H//006;;0`00
000408nQh@030000002ES<P0UHc800D0UHc800<0000009N2^`2GP[/01@2GP[/00`000000VGjd09Un
]00709Un]0030000002KOK40Vgfa00H0Vgfa00<0000009en/@2MO[40102MO[42000000030::5]@00
0000YhZf00T0YhZf00<000000:b?^02/SkP0202/SkP2000000X0^j?100D000000;fYa@2mZLD0_JW5
000000080<Vib`0400000038_Ll0b;g?000000P0dLcE00<000000=KJf`0000001P3>e]l2000000@0
c]kT0P0000000`36enH00000000000090<?IjP8000002P2hdN`00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo00T0oooo000T0?ooo`030000003oool0oooo0080oooo0`00000`0?ooo`030000
0024/o<0Q;?c00D0Q;?c00<0000007:Ym01bZO@0101bZO@00`000000FYcb05ZLlP06000000@0FY7[
00<0000004j5iP1>QNH00`1>QNH010000000CGkQ04enh@1=O^43000000D0KhCH00<0000007j7dP1n
Qm801@1nQm800`000000T8g=092=c@06092=c@030000002RULL0XYG700H0XYG70P00000;0;RUaP05
00000037[L00ajg00<N]`00000002`3@^L<00`000000hlZn0>?:_P050>?:_P030000003/g<80k=c2
00<0k=c200<000000>oba03_l/@00`3_l/@01`000000e_fi0=Km^@3FoKT000000<Fcb@0000002@2d
X/H00`000000XYS;0::Hb`060::Hb`0300000024RM00Q8W@00@0Q8W@00<00000055_dP1AKm800`1A
Km8200000004001Rb`000000A7gR04AmhP8000000P2?XN400`000000UHc809F<b00509F<b0030000
002GP[/0Uh:k00H0Uh:k00<0000009Un]02IO[@01P2IO[@00`000000Vgfa09]m/@0609]m/@030000
002MO[40WGja0080WGja0P0000040::5]@030000002WR[H0YhZf00L0YhZf00<000000:b?^02/SkP0
202/SkP00`000000^j?10;^S`@090;^S`@040000002mZLD0_JW5000000T0bKW;00<000000<Rmc`00
0000203Ac=D01@000000e][K0=KJf`3Ff]/0000000@0c]KO00<000000<kNi03>g^@01@3>g^@20000
00T0`mWZ0P0000000`2ofNd000000;SAk0070;SAk080000000<0]Lo]0000003oool02`3oool00`00
0000oooo0?ooo`090?ooo`00903oool00`000000oooo00000002000003@0oooo00<0000008Bcl`24
/o<01@24/o<00`000000LZWd07:Ym00407:Ym0030000001JW?80FYcb00@0FYcb1P00000504j5iP03
0000001=O^40CGkQ00<0CGkQ1@0000000`1_Q=P0000007j7dP0707j7dP030000002@SLd0T8g=00D0
T8g=00<000000::Ea`2RULL00`2RULL3000000030:BLc@000000^:G600/0^:G600@000000<N]`037
[L0000002P3@^L<00`000000g<g9000000050>?:_P030000003/g<80k=c200<0k=c200<000000>ob
a03_l/@0103_l/@01@000000e_fi0=Km^@000000aK?9008000002P2dX/H00`000000XYS;0::Hb`05
0::Hb`0300000024RM00Q8W@00@0Q8W@00<00000055_dP1AKm800`1AKm801@0000001TG400000000
H//0000000<0A7gR0P0000000`2?XN40000009F<b00509F<b0030000002GP[/0Uh:k00H0Uh:k00<0
000009Un]02IO[@01P2IO[@00`000000Vgfa09]m/@0709]m/@040000002MO[400000000000H0XXFe
00<000000:N:]P2WR[H01`2WR[H00`000000[8nh0:b?^0070:b?^0800000302kXl42000000/0bKW;
00<000000=7<e@3Ac=D01P3Ac=D00`000000e][K0=KJf`030=KJf`040000003>e]l00000000000P0
c]kT00<000000<_Rj00000001`33fNX00`000000_mW]0;oIk@020;oIk@030000002hdN`0^=7/00<0
^=7/0P0000040;G?k@030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool002@0oooo
0P00000h0?ooo`0300000024/o<0Q;?c00D0Q;?c00<0000007:Ym01bZO@0101bZO@00`000000FYcb
05ZLlP0405ZLlP040000000oRn`0?h_/03n;k0<00000101>QNH00`000000CGkQ04enh@0204enh@03
0000001JOmd0FWoM0080FWoM1`00000307j7dP030000002@SLd0T8g=00H0T8g=00<000000::Ea`00
00000P0000050:BLc@030000002hYLH0^:G600T0^:G600<000000<N]`00000002P3@^L<010000000
g<g90=c=b@3LcLT200000080hlZn00<000000>cL`P3/g<80103/g<800`000000ko;40>oba0030>ob
a0060000003FoKT0e_fi00000035/lT000000P2nZ<@00`000000]:;60;BRaP070;BRaP030000002R
V</0XYS;00D0XYS;1@00000308B9d0030000001AKm80DFoB00<0DFoB00D0000000I5a000000006;;
0000000404AmhP<000001@2ES<P00`000000Uh:k09N2^`0609N2^`030000002IO[@0VGjd00H0VGjd
00<0000009]m/@2KOK401@2KOK44000000P0XXFe00<000000:N:]P2WR[H0202WR[H00`000000[8nh
0:b?^0040:b?^08000000P2hWKd00`000000^j?10;^S`@090;^S`@0300000039^L/0bKW;00T0bKW;
00<000000=C<d@0000001P3Ac=D00`000000e][K0=KJf`050=KJf`030000003>g^@0c]kT00H0c]kT
0P000000103;h^P000000<_Rj00000040<?IjP8000001P2ofNd00`000000^=7/0;SAk002000000L0
]Lo]00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`009@3oool00`000000oooo
0?ooo`0g0?ooo`0300000024/o<0Q;?c00D0Q;?c00<0000007:Ym01bZO@0101bZO@00`000000FYcb
05ZLlP0305ZLlP030000000oRn`0?h_/00<0?h_/0`00000304j5iP030000001=O^40CGkQ0080CGkQ
00<0000005Yog@1JOmd0101JOmd010000000LHOI0767f@1aQmT>000000P0Y9c=00<000000;RUaP2h
YLH02P2hYLH00`000000d;W30=2i``090=2i``030000003LcLT0g<g900<0g<g900<000000>?:_P00
00001@3/g<800`000000ko;40>oba0030>oba0030000003FoKT0e_fi00<000000`2nZ<@00`000000
]:;60;BRaP080;BRaP030000002RV</0XYS;00@0000000<0XI?50000002:QlX00P2:QlX5000000@0
DFoB00<0000000I5a006AL@00`00000404AmhP030000001bOM00000000<000000P2ES<P00`000000
Uh:k09N2^`0509N2^`030000002IO[@0VGjd00L0VGjd00<0000009]m/@2KOK401000000209b2]P03
0000002RQKD0XXFe00L0XXFe00<000000:N:]P2WR[H0202WR[H00`000000[8nh0:b?^0030:b?^003
0000002hWKd0^9fm0080^9fm00<000000;^S`@2kXl40202kXl42000000X0bKW;00D000000=C<d@3D
c=40e<cA000000040=7<e@030000003Ff]/0e][K00D0e][K00<000000=OUh@0000001P3>g^@00`00
0000bn;X0<_Rj0020<_Rj0040000003;h^P000000<?IjP800000202ofNd3000000T0]Lo]0P000009
0?ooo`030000003oool0oooo00T0oooo000V0?ooo`800000>03ooolA000000@0FYcb00<0000003n;
k00oRn`00`0oRn`00`000000:g_V00000003000000D0CGkQ00<0000005Yog@1JOmd00`1JOmd00`00
0000LHOI0767f@050767f@030000002<TM@0S97D00D0S97D00<000000:BLc@2TW<d0202TW<d00`00
0000^:G60;RUaP080;RUaP0300000031]<d0000000T0d;W300<000000=c=b@3LcLT01@3LcLT20000
00@0k=c200<000000>oba03_l/@00`3_l/@00`000000e_fi00000002000000H0_ZS400<000000;BR
aP2dX/H01`2dX/H3000000H0XI?500<0000008Z7bP2:QlX0102:QlX3000000<0DFoB00<0000000I5
a006AL@00P00000504AmhP030000001bOM00LWg@0080LWg@1`00000409N2^`030000002IO[@0VGjd
0080VGjd1`00000709b2]P030000002RQKD0XXFe00L0XXFe00<000000:N:]P2WR[H01`2WR[H00`00
0000[8nh0:b?^0020:b?^0030000002hWKd0^9fm00@0^9fm00<000000;^S`@2kXl401P2kXl401000
0000bKK70<Vfa`0000080<Vib`030000003Dc=40e<cA0080e<cA00D000000=7<e@3Ac=D0dLcE0000
00070=KJf`050000003GiN40enGQ0=OUh@000000103>g^@00`000000bn;X0<_Rj0040<_Rj0030000
003;h^P0000000P0_mW]0P0000020;[GkP030000002ecnd0]Lo]00D0]Lo]0P0000020;7=kP030000
003oool0oooo00L0oooo00<000000?ooo`3oool0203oool002P0oooo00<000000?ooo`3oool0=P3o
ool00`000000P;Cf082dmP05082dmP030000001XZ_L0J:[g00@0J:[g1@0000000`1JW?80000003n;
k00403n;k0040000000[NnH0:g_V02]kiP<00000101=O^400`000000FWoM05Yog@0305Yog@030000
001aQmT0LHOI00D0LHOI00<0000008bAe02<TM@01@2<TM@00`000000Y9c=0:BLc@070:BLc@030000
002hYLH0^:G600H0^:G60P0000020<6dc@030000003@^L<0d;W300H0d;W300<000000=c=b@3LcLT0
1@3LcLT00`000000inWA0>OYd@0200000080k=c200<000000>oba03_l/@00`3_l/@2000000030<Fc
b@000000_ZS400H0_ZS400<000000;BRaP2dX/H01@2dX/H3000000P0XI?500<0000008Z7bP2:QlX0
102:QlX00`000000IWG=06Iec@04000000<01TG40P00000404AmhP030000001bOM00LWg@00@0LWg@
00<0000008Mm`P27OL800P27OL89000000@0Tgnj00<0000009b2]P2LP[H01`2LP[H00`000000XXFe
0::5]@070::5]@030000002WR[H0YhZf00L0YhZf00<000000:b?^02/SkP00P0000070;RM_@030000
002kXl40^j?100D0^j?100D000000<Vfa`39]/L0bKK7000000070<Vib`030000003Dc=40e<cA00@0
e<cA00<000000=7<e@0000001`3Ff]/00`000000enGQ0=OUh@030=OUh@040000003>g^@000000000
00L0bn;X0P0000000`36h^`000000;oIk@040;oIk@800000102jenh00`000000]Lo]0;G?k@030;G?
k@800000102acNh00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0oooo000Y0?ooo`03
0000003oool0oooo03H0oooo00<00000082dmP20]?H01@20]?H2000000D0J:[g00@0000004RJl`18
V_<0B9[c1000000403n;k0030000000[NnH0:g_V0080:g_V0`00000204enh@030000001JOmd0FWoM
00@0FWoM00<000000767f@1aQmT0101aQmT00`000000S97D08bAe00508bAe0030000002TW<d0Y9c=
00P0Y9c=00<000000;RUaP2hYLH0102hYLH00`000000`KC=0<6dc@030<6dc@030000003@^L<0d;W3
00@0d;W300<000000=c=b@3LcLT01@3LcLT00`000000inWA0>OYd@030>OYd@T0000000<0bkO70000
002nZ<@0202nZ<@00`000000]:;60;BRaP020;BRaP8000000`2`Vl<00`000000XI?50:6Ca@060:6C
a@030000002:QlX0RXO:00@0RXO:00<0000006Iec@1VMLd00P1VMLd2000000801TG400<0000007X0
000000001014ON800`000000LWg@079md004079md00300000027OL80Qgg200D0Qgg200<0000009=o
^P2COkX01`2COkX00`000000W8:f09b2]P0609b2]P030000002RQKD0XXFe00L0XXFe00<000000:N:
]P2WR[H0202WR[H2000000X0^9fm00<000000;^S`@2kXl400`2kXl400`000000bKK70<Vfa`030<Vf
a`0300000039^L/0bKW;00<0bKW;00<000000=C<d@3Dc=401P3Dc=400`000000e][K0=KJf`040=KJ
f`8000001`3GiN400`000000bn;X0<_Rj0050<_Rj080000000D0a^;/00000036h^`0a^;/00000002
0;oIk@8000001`2jenh00`000000]Lo]0;G?k@02000000L0/Lg^00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`080?ooo`00:P3oool00`000000oooo0?ooo`0f0?ooo`8000001`20]?H00`00
0000J:[g06RZm`0306RZm`8000001018V_<50000000303n;k0000000:g_V00<0:g_V00<0000002Id
hP0000000`00000505Yog@030000001aQmT0LHOI00D0LHOI00<0000008bAe02<TM@01@2<TM@00`00
0000Y9c=0:BLc@070:BLc@030000002hYLH0^:G600<0^:G600<000000<6dc@31]<d01031]<d00`00
0000d;W30=2i``030=2i``030000003LcLT0g<g900H0g<g900<000000>OYd@3WjM400`3WjM400`00
0000f?o70=Soa`030=Soa`030000003;]lL0bkO7008000002@2nZ<@00`000000]:;60;BRaP020000
00D0/9_300<000000:6Ca@2QTlD01P2QTlD00`000000RXO:08Z7bP0408Z7bP030000001VMLd0IWG=
00<0IWG=0P00000200I5a0<000000`14ON800`000000LWg@079md004079md00300000027OL80Qgg2
00H0Qgg200<0000009=o^P2COkX01P2COkX00`000000W8:f09b2]P0709b2]P030000002RQKD0XXFe
00H0XXFe00<000000:N:]P2WR[H0202WR[H00`000000^9fm0;RM_@090;RM_@030000002kXl40^j?1
00<0^j?100<000000<Vfa`39]/L00`39]/L00`000000bKW;0<Vib`020<Vib`030000003Dc=40e<cA
00H0e<cA00<000000=cNf0000000103Ff]/00`000000enGQ0=OUh@060=OUh@030000003Ck>H00000
00@0bn;X0P0000040<KRk00300000036h^`0a^;/008000002@2jenh3000000T0/Lg^00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`080?ooo`00:`3oool2000003P0oooo00<00000082dmP20
]?H00P20]?H7000000<0J:[g00<0000004RJl`18V_<00`18V_<00`0000008HCY0264j@0400000080
:g_V00<0000002IdhP0VM>800P0VM>83000000@0FWoM00<000000767f@1aQmT0101aQmT00`000000
S97D08bAe00508bAe0030000002TW<d0Y9c=00P0Y9c=00<000000;RUaP2hYLH00P0000080<6dc@05
0000003@^L<0d;W30=2i``000000203LcLT00`000000inWA0>OYd@030>OYd@030000003HolL0f?o7
00<0f?o700@000000<^ga`3;]lL000000P34[L<00`000000_ZS40;jXa0070;jXa0800000202`Vl<0
0`000000XI?50:6Ca@050:6Ca@030000002:QlX0RXO:00D0RXO:00<0000006Iec@1VMLd00`1VMLd3
0000000400I5a0000000000000000080A7gR00<00000079md01bOM001@1bOM000`000000Qgg208Mm
`P0508Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H01`2LP[H00`000000XXFe0::5
]@070::5]@030000002WR[H0YhZf00D0YhZf0`00000<0;RM_@050000002kXl40^j?10;^S`@000000
1`39]/L010000000bKW;0<Vib`0000080=C<d@040000003Lg]P0g=kH000000<0e][K00<000000=OU
h@3GiN401@3GiN42000000<0dncV00@000000<_Rj000000000001`36h^`2000000030<3Ok`000000
^]O^00H0^]O^0P0000020;GCk`030000002acNh0/Lg^00L0/Lg^0P0000070?ooo`030000003oool0
oooo00P0oooo000]0?ooo`030000003oool0oooo03H0oooo1000000407jgn0030000001S[_T0Hjki
00P000000P18V_<2000000<08HCY0`0000000`0[NnH0000002IdhP0402IdhP<000000`1JOmd00`00
0000LHOI0767f@040767f@030000002<TM@0S97D00D0S97D00<000000:BLc@2TW<d01`2TW<d00`00
0000^:G60000000;0<6dc@040000003@^L<0d;W3000000L0g<g900<000000>OYd@3WjM40103WjM40
0`000000f?o70=Soa`020=Soa`040000003;]lL0bkO7000000<0a:g300<000000;jXa02nZ<@01P2n
Z<@2000000T0/9_300<000000:6Ca@2QTlD01P2QTlD00`000000RXO:08Z7bP0408Z7bP030000001V
MLd0IWG=00<0IWG=00D00000031Jc00`F/`0000000I5a0040000000304AmhP000000LWg@00D0LWg@
00<0000008Mm`P27OL801@27OL800`000000Tgnj09=o^P0709=o^P030000002LP[H0W8:f00H0W8:f
00<000000::5]@2RQKD01`2RQKD00`000000YhZf0:N:]P040:N:]P050000002bV;`0/YRl0;:H_000
00002`2hWKd010000000^j?10;^S`@0000080<Vfa`0300000039^L/0000000P0e<cA00<000000=cN
f03Lg]P00P3Lg]P00`000000e][K000000070=OUh@030000003Ck>H0dncV00@0dncV00<000000<KR
k036h^`01@36h^`300000080`=o_00<000000;[GkP2jenh00`2jenh2000000@0]M?_00<000000;7=
kP2acNh0102acNh300000080[l[^00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?oo
o`00;P3oool00`000000oooo0?ooo`0f0?ooo`030000001n]oP0O[Oh00D0O[Oh00<0000006>^n@1S
[_T0101S[_T00`000000>I_c03VKl`06000000808HCY00<00000001]f`0000000P00000402IdhP03
0000000fN^<0=W[S00@000001P1aQmT00`000000S97D08bAe00508bAe0030000002TW<d0Y9c=00L0
Y9c=0P00000<0<6dc@030000003@^L<0000000L0g<g900<000000>OYd@3WjM40103WjM4010000000
f?o70=Soa`3HolL200000080bkO700<000000<B]``34[L<00`34[L<00`000000_ZS40;jXa0040;jX
a0040000002jX/40^Z;1000000P0/9_300<000000:6Ca@2QTlD01P2QTlD00`000000RXO:08Z7bP05
08Z7bP030000001VMLd0IWG=00<0IWG=00H00000031Jc00`F/`0000000I5a0000002000o`P800000
1P1bOM000`000000Qgg208Mm`P0608Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H0
1P2LP[H00`000000XXFe0::5]@070::5]@030000002WR[H0YhZf0080YhZf0P0000040;:H_0030000
002hWKd0^9fm00X0^9fm0P00000:0<Vfa`030000003Dc=40e<cA00H0e<cA00<000000=cNf03Lg]P0
103Lg]P00`000000enGQ0=OUh@050=OUh@030000003Ck>H0dncV00<0dncV0P0000000`3<kN/00000
0<KRk0030<KRk08000000`30gnl010000000`=o_0<3Ok`0000020;[GkP8000001`2ednl00`000000
/Lg^0;7=kP03000000D0[l[^00<000000?ooo`3oool0103oool00`000000oooo0?ooo`080?ooo`00
;`3oool00`000000oooo0?ooo`0f0?ooo`8000001P1n]oP2000000D0Hjki0P00000503VKl`<00000
00@08HCY00000000KM/006gK0P00000402IdhP030000000fN^<0=W[S0080=W[S0`0000050767f@03
0000002<TM@0S97D00D0S97D00<000000:BLc@2TW<d00`2TW<d300000080Z:_I00<000000<6dc@31
]<d02P31]<d00`000000g<g90=c=b@050=c=b@030000003WjM40inWA00@0inWA00D000000=Soa`3H
olL0f?o7000000030<^ga`0300000034[L<0a:g300@0a:g300<000000;jXa02nZ<@00P2nZ<@20000
00<0^Z;100<000000;2K``2`Vl<01`2`Vl<00`000000XI?50:6Ca@060:6Ca@030000002:QlX0RXO:
00@0RXO:00<0000006Iec@1VMLd00`1VMLd010000000<5[<031Jc00`F/`30000008003o20P000006
079md00300000027OL80Qgg200D0Qgg200<0000009=o^P2COkX01P2COkX00`000000W8:f09b2]P07
09b2]P030000002RQKD0XXFe00H0XXFe00D000000:N:]P2WR[H0YhZf000000070;:H_0030000002h
WKd0^9fm00T0^9fm00<000000<Vfa`39]/L02039]/L00`000000e/c?000000060=C<d@030000003L
g]P0g=kH00@0g=kH00<000000=g]g@000000103GiN42000000D0dncV00<000000<c]j`3<kN/00P3<
kN/010000000a^;/0000000000060<3Ok`0300000030gnl0`=o_008000002@2ednl3000000T0[l[^
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`080?ooo`00<03oool00`000000oooo0?oo
o`0g0?ooo`030000001n]oP0O[Oh00D0O[Oh00<0000006>^n@1S[_T0101S[_T00`000000>I_c03VK
l`0303VKl`D000000`00KM/2000000<09WCR00<0000003Ijh`0fN^<00`0fN^<5000000030767f@00
0000S97D00H0S97D00<000000:BLc@2TW<d00`0000050:R[f@0300000031]<d0`KC=00T0`KC=00<0
00000<c>f`0000001@3LcLT00`000000inWA0>OYd@040>OYd@050000003HolL0f?o70=Soa`000000
0`3;]lL00`000000a:g30<B]``060<B]``040000002nZ<@0_ZS4000000H0^Z;100<000000;2K``2`
Vl<01P2`Vl<00`000000XI?50:6Ca@050:6Ca@/00000101VMLd00`000000<5[<031Jc002031Jc080
00000P00?l800`000000LWg@079md004079md00300000027OL80Qgg200D0Qgg200<0000009=o^P2C
OkX01P2COkX00`000000W8:f09b2]P0709b2]P030000002RQKD0XXFe00L0XXFe0`0000080;:H_003
0000002hWKd0^9fm00P0^9fm0P0000090<Vfa`050000003Fc<l0e/c?0=K<c`000000103Dc=400`00
0000g=kH0=cNf0040=cNf0040000003MkMd0gNgM0=g]g@80000000<0enGQ0000003Ck>H0103Ck>H2
000000H0c>g[00<000000<3Ok`30gnl01`30gnl2000000030;[Kl@000000]M?_00D0]M?_0`000002
0;7?k`030000002_b^h0[l[^00L0[l[^0P0000050?ooo`030000003oool0oooo00L0oooo000a0?oo
o`800000>03ooolC000000<0>I_c00<0000000Ang`0000000P000002001]f`<000000P0VM>800`00
0000=W[S03Ijh`0203Ijh`030000001JR^H0FX[V0080FX[V300000090:R[f@0300000031]<d0`KC=
00H0`KC=0P0000030<c>f`8000000`3LcLT00`000000inWA0>OYd@030>OYd@090000003HolL0f?o7
0=Soa`000000cK[70000003;]lL0000000T0a:g300<000000;jXa00000001`2jX/400`000000/9_3
0;2K``070;2K``030000002QTlD0XI?500@0000000<0XI;40000002?R<P01P2?R<P010000000MGc<
00000000000206Iec@030000000`F/`0<5[<00<0<5[<0P000002000o`P800000101bOM000`000000
Qgg208Mm`P0608Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H01P2LP[H00`000000
XXFe0::5]@070::5]@030000002bV;`0/YRl00P0/YRl00<000000;RM_@2hWKd01`2hWKd010000000
a[760<JaaP0000070<Vfa`030000003Fc<l0e/c?0080e/c?00D000000=C<d@3Dc=40e<cA00000006
0=cNf0030000003MkMd0gNgM00@0gNgM00<000000=?/iP3Ck>H00`3Ck>H00`000000c>g[0<c]j`04
0<c]j`80000000<0aN[_00000030gnl01@30gnl3000000<0^]_a00<000000;GCk`2ednl00`000005
0;7?k`030000002_b^h0[l[^00@0[l[^0`0000020:c7k@030000003oool0oooo0080oooo00<00000
0?ooo`3oool01`3oool003<0oooo00<000000?ooo`3oool0=P3oool2000000H0P;cj0P00000506Be
o080000000<0=Z?c000000000000100000001@04O]l0000000000000000006gK00D000001@0fN^<0
0`000000FX[V05Z:iP0405Z:iP0300000024WN<0Q9gS00D0Q9gS00<000000:R[f@2XZmT01`2XZmT0
0`000000`KC=0<6dc@050<6dc@030000003<c]/0c<kK00D0c<kK00<000000=c=b@0000001P3WjM40
10000000f?o70000000000030<fja`0300000034[L<0a:g300T0a:g300<000000;ZR`@2jX/401`2j
X/400`000000/9_30;2K``060;2K``<000001P2QT/@00`000000ShS808n8b00508n8b0030000001e
O<`0MGc<0080000000<0IWG=0000000`F/`00`0`F/`300000003000o`P000000>FGC008000000`1b
OM000`000000Qgg208Mm`P0508Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H01`2L
P[H00`000000XXFe0::5]@040::5]@<000002`2bV;`00`000000^9fm0;RM_@050;RM_@0500000036
/LH0a[760<JaaP0000001P39]/L00`000000e/c?0=K<c`040=K<c`030000003Dc=40000000H0g=kH
00<000000=g]g@3MkMd0103MkMd01@000000eoGR000000000000dncV008000001P3<kN/00`000000
aN[_0<GZk`020<GZk`8000000P30gnl2000000<0^]_a00@000000;[Kl@2jfo40^]_a0P0000090;7?
k`030000002_b^h0[l[^00<000001@2/and00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00L0oooo000d0?ooo`030000003oool0oooo03L0oooo00<00000082lnP20_?X01@20_?X2000000D0
I;Gl0P00000503JSl`P0000000@0067B0000000000000000100fN^<00`000000FX[V05Z:iP0305Z:
iP0300000024WN<0Q9gS00D0Q9gS00<000000:R[f@2XZmT0202XZmT00`000000`KC=0<6dc@030<6d
c@030000003<c]/0c<kK00L0c<kK0`0000040>OYd@@000000`3=^/L00`000000b;;4000000090<B]
``8000002@2jX/400`000000/9_30;2K``040;2K``<00000202QT/@00`000000ShS808n8b00508n8
b0030000001eO<`0MGc<0080MGc<0P000005031Jc0<0000000@003o20000000iIM<0>FGC0P000000
0`1bOM00000008Mm`P0608Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H01`2LP[H0
0`000000XXFe0::5]@030::5]@050000002ZT[d0ZY:m0:ZB_@0000002P2bV;`00`000000^9fm0;RM
_@030;RM_@8000001@36/LH00`000000bKK70<Vfa`030<Vfa`030000003Fc<l0e/c?00D0e/c?00<0
00000=cNf03Lg]P0103Lg]P00`000000gNgM0=g]g@040=g]g@030000003GmN80eoGR0080eoGR00<0
00000<c]j`3<kN/0103<kN/2000000L0aN[_0P0000060;[Kl@<0000000<0]=Ga0000002acnl0202a
cnl3000000T0[<O]00D000000?ooo`3oool0oooo000000090?ooo`00=@3oool00`000000oooo0?oo
o`0g0?ooo`8000001020_?XH00000080067B0`00000303Ijh`030000001JR^H0FX[V00<0FX[V00<0
000008BMh`24WN<01@24WN<00`000000Z:_I0:R[f@080:R[f@0300000031]<d0`KC=008000002@3<
c]/010000000d?GW0=3ei`3@mNL6000000@0cK[700@000000<Rba038//@000002034[L<010000000
_jS20;nX`P0000090;ZR`@040000002`Vl<0/9_30;2K``8000000`2^VL800`000000XI;40:6Ba006
0:6Ba0030000002?R<P0ShS800D0ShS800<0000007Elc01eO<`00`1eO<`2000000<0<5[<00<00000
000e_00000000P00000403UUd`<000001`27OL800`000000Tgnj09=o^P0609=o^P030000002LP[H0
W8:f00H0W8:f00@000000::5]@2RQKD0XXFe0P0000040:ZB_@030000002bV;`0/YRl00T0/YRl00D0
00000;RM_@2hWKd0^9fm000000070<JaaP0300000039]/L0bKK70080bKK700<000000=K<c`3Fc<l0
1@3Fc<l00`000000gn;G000000040=cNf0030000003MkMd0gNgM00@0gNgM00<000000=OehP3GmN80
0P3GmN8010000000coOW0000000000020<c]j`8000001`35j^l2000000030;kTlP000000^]_a00@0
^]_a0P0000040;CEl@030000002acnl0/Lo_00@0/Lo_0P0000020:k;k`030000002/and0[<O]00L0
[<O]00D000000?ooo`3oool0oooo000000090?ooo`00=P3oool2000003T0oooo1000000408O2nP80
00001`1__oh2000000D0@k?f1P0000000`00HM800000001Zf004000000D0FX[V00<0000008BMh`24
WN<01@24WN<00`000000Z:_I0:R[f@080:R[f@0300000031]<d0000000T0c<kK0P0000060=3ei`<0
0000103=^/L00`000000b;;40<Rba0020<Rba00300000034[L<0a:g300@0a:g300D000000;nX`P2o
Z<80_jS2000000090;ZR`@040000002`Vl<00000000000D0[YW200<000000:6Ba02QT/@01P2QT/@0
0`000000ShS808n8b00508n8b0030000001eO<`0MGc<00<0MGc<00@0000004i[d000000000000P0`
F/`00`00000003Fl00000002000000D0>FGC0P00000608Mm`P030000002COkX0Tgnj00H0Tgnj00<0
000009b2]P2LP[H01`2LP[H3000000L0ZY:m00<000000;:H_02bV;`0202bV;`010000000^9fm0;RM
_@0000090<JaaP0400000039]/L0bKK7000000L0e/c?00@000000=oRe`3Oh]L0gn;G0P0000000`3L
g]P000000=g]g@040=g]g@800000103GmN800`000000coOW0<ogi`020<ogi`8000001`35j^l20000
00@0_^Cb00<000000;[Kl@2jfo400P0000020;CEl@030000002deO40]=Ga0080]=Ga00<000000;7?
k`2acnl00`0000050:k;k`030000002/and0[<O]00H0[<O]0P0000020?ooo`030000003oool0oooo
00L0oooo000h0?ooo`030000003oool0oooo03L0oooo00<0000008O2nP27`_X01P27`_X2000000D0
Kkon40000003001Zf0<00000101JR^H00`000000Q9gS08BMh`0508BMh`030000002XZmT0Z:_I00L0
Z:_I0P0000090<c>f`030000003@mNL0d?GW00@0d?GW0`0000050<fja`0300000038//@0b;;400<0
b;;400<000000<B]``34[L<00P34[L<2000000D0_jS200<000000;ZR`@2jX/401`2jX/400`000000
[YW20:jI`P060:jI`P030000002QT/@0XI;400D0XI;400<0000008n8b02?R<P01P2?R<P00`000000
MGc<07Elc00307Elc0030000001>Jm00CV_@00<000000P00=K`3000000@0>FGC00<0000006iic@00
00000P00000308Mm`P030000002COkX0Tgnj00H0Tgnj00<0000009b2]P2LP[H01@2LP[H3000000T0
ZY:m00<000000;:H_02bV;`02@2bV;`2000000X0a[7600<000000<Vfa`0000001`3Fc<l00`000000
gn;G0=oRe`040=oRe`030000003MkMd0gNgM00<0gNgM00<000000=OehP3GmN800`3GmN800`000000
coOW0<ogi`020<ogi`80000000<0a_C]00000035j^l00`35j^l2000000H0_^Cb0`0000050;CEl@04
0000002deO40]=Ga0;CEl@<000002@2^bnl010000000[<O]0:c7k@2/and400000080ZlG]00<00000
0?ooo`0000002@3oool003T0oooo00<000000?ooo`3oool0=`3oool2000000P0Ql;j1@00000508;;
o`<000000`1Rb?`6000000@006[H0`00000305Z:iP0300000024WN<0Q9gS00D0Q9gS00<000000:R[
f@2XZmT00`2XZmT300000080ZlW`00<000000<c>f`3<c]/01@3<c]/00`000000d?GW0=3ei`040=3e
i`@00000103=^/L00`000000b;;40<Rba0050<Rba00400000034[L<0a:g3000000L0_jS200<00000
0;ZR`@2jX/401@2jX/43000000P0[YW200<000000:6Ba02QT/@01P2QT/@00`000000ShS808n8b005
08n8b0030000001eO<`0MGc<00<0MGc<00<0000004i[d01>Jm000P1>Jm0200000004000e_0000000
00J>000000D0>FGC00@0000006iic@1^NLd0KWW=0`0000000`27OL80000009=o^P0709=o^P030000
002LP[H0W8:f00@000000P2NRl000`000000ZY:m0:ZB_@070:ZB_@030000002bV;`0/YRl00T0/YRl
00<000000<JaaP36/LH02P36/LH00`000000e/c?0=K<c`050=K<c`030000003Oh]L0gn;G00@0gn;G
00@000000=odf`00000000000P3MkMd00`000000eoGR0=OehP020=OehP800000103?mnL00`000000
a_C]0<Kdk@020<Kdk@0400000035j^l00000000000H0_^Cb0P0000020;OLl`030000002deO40]=Ga
00@0]=Ga0`0000020;3?l0030000002^bnl0[/__00L0[/__100000060:_5k@040000003oool0oooo
000000P0oooo000j0?ooo`030000003oool0oooo03P0oooo00@0000008O2nP27`_X0Ql;j10000002
09?8nP8000002@22bol3000000H0RM_o0P000003001Zf0030000000VR^`0000000<000001`24WN<0
0`000000Z:_I0:R[f@03000000H0ZlW`0P0000030<c>f`8000001P3@mNL2000000<0cKc:00@00000
0<fja`3=^/L000002038//@00`000000a:g3000000090;nX`P030000002jX/40^Z;100<0^Z;100D0
00000;JP`P2fX<80]Z32000000070:jI`P030000002QT/@0XI;400H0XI;400<0000008n8b02?R<P0
1P2?R<P00`000000MGc<07Elc00307Elc0030000001>Jm00CV_@00<0CV_@00D00000000e_0000000
00J>0000000403UUd`030000001^NLd0KWW=00@0KWW=3@00000709j;`0030000002ZT[d0ZY:m00L0
ZY:m00<000000;:H_02bV;`01`2bV;`2000000/0a[7600<000000=C;d00000001P3Fc<l00`000000
gn;G0=oRe`030=oRe`030000003Om=/0goCK0080goCK0P0000040=OehP030000003?mnL0coOW0080
coOW0P0000060<Kdk@030000002ni?80_^Cb00@0_^Cb0P0000040;OLl`030000002deO40]=Ga00<0
]=Ga0P0000040;3?l0030000002^bnl0[/__00@0[/__0`0000020:c7kP030000002[aNd0ZlG]00H0
ZlG]00<000000?ooo`000000203oool003/0oooo0P00000i0?ooo`<00000202Cb?X2000000<0P/_o
1000000309WCo08000000`29fol50000008006[H00@0000002J:k00VR^`09X[/2`00000;0:_9l003
0000003<c]/0000000H0d?GW0`0000040<flbP030000003=^/L0000000X0b;;400<000000;nX`P2o
Z<80202oZ<8010000000^Z;10;ZR`@2jX/42000000@0]Z3200<000000:jI`P2^VL801P2^VL800`00
0000XI;40:6Ba0060:6Ba0030000002?R<P0ShS80080ShS81@00000507Elc0030000001>Jm00CV_@
0080CV_@100000000`001Xh0000003UUd`0303UUd`030000001^NLd0KWW=00@0KWW=00<0000008b4
a@2<Q<D01P2<Q<D00`000000WX_009j;`00709j;`0030000002ZT[d0ZY:m00L0ZY:m00<000000;:H
_02bV;`01@2bV;`200000080_jc700<000000<JaaP36/LH01`36/LH01@000000e<_@0=C;d03Dbm00
000000@0e/c?00<000000=oRe`3Oh]L00`3Oh]L00`000000goCK0=odf`030=odf`060000003FoM`0
00000000003GmN800000103?mnL00`000000a_C]0<Kdk@040<Kdk@80000000<0_nkb000000000000
0P2ni?82000000L0]mcc00<000000;CEl@2deO400P0000020;3?l0030000002`co00/<o`0080/<o`
00<000000:k;k`2^bnl00`0000050:c7kP030000002[aNd0ZlG]00H0ZlG]0`0000080?ooo`00?@3o
ool00`000000oooo0?ooo`0g0?ooo`8000002@2Cb?X4000000T0VM?l0`0000050:[QnP@00000100V
R^`00`000000K[;j06jbnP0506jbnP8000002P2[bO04000000@0d?GW0P0000070<flbP0300000038
//@0b;;400P0b;;40P00000;0;nX`P<000001`2fX<800`000000[YW20:jI`P050:jI`P030000002Q
T/@0XI;400D0XI;41P00000309B<b@0300000020Q<h0000000<0000000<0MGc<0000001>Jm00101>
Jm000`0000005eC>00000003000000<0>FGC00<0000006iic@1^NLd01@1^NLd00`000000S8C508b4
a@0608b4a@030000002NRl00WX_000H0WX_000<000000:ZB_@2ZT[d01`2ZT[d00`000000/YRl0;:H
_0040;:H_0030000002o[<L0_jc70080_jc700<000000<JaaP36/LH01P36/LH00`000000e<_@0=C;
d0020=C;d0050000003Fc<l0e/c?0=K<c`0000001@3Oh]L00`000000goCK0=odf`030=odf`030000
003FoM`0e_gL0080e_gL0P0000020<ogi`8000001@36m>d2000000D0_nkb0P0000090;OLl`<00000
1@2`co0010000000/<o`0;3?l02`co03000000T0[<O^00<000000:_5k@2[aNd00`2[aNd200000080
oooo00<000000?ooo`3oool01P3oool003h0oooo00<000000?ooo`3oool0>03oool2000000<0TlSj
1000000209o<m`8000001`2Ido`2000000<0[=Kf0P0000030:[QnP80000000@0_]k_000000000000
00000`0VR^`2000000L0K[;j00<000000:_9l02[bO001@2[bO02000000@0SNWe100000080<flbP03
00000038]/P0000000P0b;;400@000000<>]a033[L@000002P2oZ<800`000000]Z320;JP`P070;JP
`P030000002^VL80[YW200H0[YW200<000000:6Ba02QT/@0100000000`2RTlH0000009B<b@0709B<
b@0300000020Q<h0P8C>0080P8C>1000000404i[d0030000000GE<h0000000<000000P0iIM<00`00
0000KWW=06iic@0506iic@030000002<Q<D0S8C500H0S8C500<0000009j;`02NRl001`2NRl000`00
0000ZY:m0:ZB_@070:ZB_@030000002bV;`0/YRl0080/YRl00<000000;n/a`2o[<L0102o[<L00`00
0000a[760<JaaP030<JaaP8000001P3Dbm000`000000e/c?000000060=oRe`030000003Om=/0goCK
0080goCK00<000000=Kmg03FoM`00P3FoM`00`000000bOkP0<Wnh003000000@0a_C]0P0000050;o^
lP80000000<0^NGe0000002gg?<01P2gg?<200000080/]Gb00<000000;3?l02`co00102`co030000
0080[L__00<000000:c7kP2/anh01`2/anh00`000000ZlG]0:_5k@03000000@0oooo00<000000?oo
o`3oool01P3oool003l0oooo00<000000?ooo`3oool0>@3oool3000000P0Wlcg0P00000209WCo0<0
00001`2/e_H3000000H0_]k_100000000`0VR^`0000006jbnP0606jbnP8000000P2[bO03000000D0
SNWe0`0000090<flbP0400000038]/P0b;K8000000L0b;;400D000000<>]a033[L@0`jg400000009
0;nX`P8000002P2fX<800`000000[YW20:jI`P040:jI`P@000001P2RTlH00`000000U8c909B<b@05
09B<b@0300000020Q<h0P8C>00@0P8C>00@0000006Eje000000000000`1>Jm001@0000005eC>0000
0000000003g10080000000<0>FGC0000001^NLd01@1^NLd00`000000S8C508b4a@0608b4a@030000
002NRl00WX_000L0WX_000<000000:ZB_@2ZT[d01`2ZT[d00`000000/YRl0;:H_002000000L0_jc7
00<000000<JaaP36/LH00P36/LH00`000000e<_@0=C;d0070=C;d0030000003Oh]L0gn;G00@0gn;G
00@000000=odf`3Om=/0goCK0P0000040=Kmg00500000039o^00bOkP0<Wnh00000000P30nnL40000
00D0_nkb0P0000040;WUm@8000000P2gg?<3000000D0/]Gb00<000000;3?l02`co00100000040:g;
k`030000002/anh0[<O^00H0[<O^100000070?ooo`030000003oool0oooo00H0oooo00100?ooo`80
0000>P3oool2000000T0Wlcg0`0000090:cFmP8000000P2ie>h200000080_]k_0P0000040<OEi@h0
0000102=jOD3000000040<k5dP000000bkk>000000L0cKc:00<000000<Rfb038]/P00P38]/P00`00
0000b;;40<Rba0020<Rba08000001@33[L@00`000000_jS20;nX`P040;nX`P8000000P2lY/<00`00
0000]Z320;JP`P070;JP`P030000002^VL80[YW20080[YW20P0000000`2/V/@000000::CaP070::C
aP030000002DS<T0U8c900H0U8c900<000000824cP20Q<h01020Q<h00`000000IG[D06Eje0040000
00805eC>0P000002000m`@8000001`1^NLd00`000000S8C508b4a@0608b4a@030000002NRl00WX_0
00H0WX_000<000000:ZB_@2ZT[d0202ZT[d2000000X0_jc700@000000<JaaP36/LH000002@3Dbm00
0`000000g^OJ000000040=oRe`050000003Om=/0goCK0=odf`0000001@3FoM`00`000000bOkP0<Wn
h002000000<0`?_W0P0000000`2km_000000000000020;o^lP8000001`2iiOD3000000P0/]Gb0`00
00040:g;k`030000002]bnl0[L__0080[L__00@000000:c7kP2/anh0[<O^1000000;0?ooo`030000
003oool0oooo00H0oooo00120?ooo`030000003oool0oooo03T0oooo00<0000009o<m`2Oc?L0102O
c?L200000080Zlkb0P0000060:cFmP8000001P2ie>h2000000P0amGU00<000000<[=g03:cM`03@00
00030<k5dP050000003;_/h0bkk>0<^ncP000000103=_<X2000000H0b;K800@000000<Rba038//@0
00001`33[L@00`000000_jS20;nX`P030;nX`P030000002lY/<0_:K30080_:K300<000000;JP`P2f
X<80202fX<8010000000[YW20000000000040:bJa0030000002RTlH0XY?600H0XY?600<0000009B<
b@2DS<T01@2DS<T00`000000P8C>0824cP040824cP030000001UN]@0IG[D00<0IG[D0P00000201MD
cP0400000000?L4003g1000m`@8000001P1^NLd00`000000S8C508b4a@0608b4a@030000002NRl00
WX_000H0WX_000<000000:ZB_@2ZT[d0202ZT[d00`000000_jc70;n/a`090;n/a`0300000036/LH0
000000T0e<_@00@000000=kWfP3NimX0g^OJ0P0000000`3Oh]L000000=odf`020=odf`030000003F
oM`0e_gL0080e_gL0P0000020<Wnh00400000030nnL0`?_W0<3ki`8000001@2km_02000000L0^NGe
0P0000020;?Km0030000002beO80/]Gb00@0/]Gb0P0000020:k?l@030000002]bnl0[L__00<0[L__
00@000000:g;k`2]bnl0[L__1000000@0?ooo`030000003oool0oooo00D0oooo00130?ooo`030000
003oool0oooo03T0oooo0P00000209o<m`8000001P2[c_8200000080[=Kf0P0000070;WDkP800000
00<0`<oV0000000000001@37eND00`000000b/gL0<[=g0070<[=g0030000003>aM80c/GB00H0c/GB
00<000000<^ncP3;_/h00P3;_/h01@000000cKc:0<flbP3=_<X0000000P0b;K800<000000<Rba000
00002@33[L@01@000000_jS20;nX`P2oZ<80000000H0_:K300<000000;JP`P2fX<801`2fX<820000
00H0[9[400<000000::CaP2RTlH01P2RTlH00`000000U8c909B<b@0509B<b@0300000020Q<h0P8C>
00D0P8C>00<0000006Eje01UN]@0101UN]@20000000301MDcP00000003g1008003g100<0000006ii
c@1^NLd0101^NLd00`000000S8C508b4a@0608b4a@030000002NRl00WX_000L0WX_000<000000:ZB
_@2ZT[d01@2ZT[d3000000`0_jc700<000000=C;d03Dbm001`3Dbm000`000000g^OJ0=kWfP040=kW
fP8000000P3Om=/00`000000e_gL0=Kmg0020=Kmg00500000039o^00bOkP0<Wnh00000000P30nnL2
000000D0^oK`0P0000000`2gkOH000000;WUm@040;WUm@8000001@2cfo@00`000000/]Gb0;;ElP03
000000D0[/oa00<000000:g;k`2]bnl00P2]bnl010000000[L__00000000000D0?ooo`030000003o
ool0oooo00D0oooo00140?ooo`030000003oool0oooo03X0oooo0P0000090:_>lP<00000202ie>h0
0`000000`<oV0<3?iP030<3?iP80000000<0amGU0000000000002@3:cM`00`000000bLGF00000005
0<k5dP8000001P3;_/h00`000000cKc:0000000:0<Rfb00300000033[L@0`jg400P0`jg400@00000
0;nX`P00000000001`2lY/<00`000000]Z320;JP`P050;JP`P<00000202/V/@00`000000XY?60::C
aP060::CaP030000002DS<T0U8c900D0U8c900<000000824cP20Q<h01020Q<h00`000000IG[D06Ej
e00406Eje0050000000oKmT0000001MDcP0000000`00?L42000000D0KWW=00<0000008b4a@2<Q<D0
1@2<Q<D00`000000WX_009j;`00709j;`0030000002ZT[d0ZY:m00<0ZY:m0P0000030;BVb`030000
002o[<L0_jc700P0_jc700<000000<k9eP0000001P3Dbm02000000H0g^OJ00<000000=[kf`3Jnm/0
0`0000030=Kmg00300000039o^00bOkP0080000000<0`?_W0000000000001@2km_02000000@0]ngf
00<000000;WUm@2iiOD00P0000070;?Km0<000002@2^co400`000000[L__0:g;k`03000001H0oooo
00<000000?ooo`3oool01@3oool004D0oooo0P00000k0?ooo`8000001P2[c_8200000080]<g/0P00
00050;WDkP8000002030cnH00`000000b/gL0<[=g0070<[=g08000000`39aMH01@000000c/GB0<k5
dP3>aM80000000T0bkk>00<000000<Rfb038]/P02038]/P00`000000a;;80000000:0<>]a0030000
002lY/<0_:K300P0_:K300<000000;JP`P2fX<800`2fX<801@000000]:340;BPa02dX<@0000000L0
[9[400<000000::CaP2RTlH01P2RTlH00`000000U8c909B<b@0509B<b@0300000020Q<h0P8C>00D0
P8C>00<0000006Eje01UN]@0101UN]@00`000000?foI000000020000008003g100@00000045`f@00
000000000`1^NLd00`000000S8C508b4a@0608b4a@030000002NRl00WX_000H0WX_000@000000:ZB
_@2ZT[d0ZY:m0P0000050;BVb`030000002o[<L0_jc700L0_jc700D000000<k9eP3>bMH0c/WF0000
00040=C;d0030000003NimX0g^OJ00D0g^OJ00D000000=[kf`3Jnm/0f__K000000020<Soe0T00000
1@2km_02000000H0]ngf0`0000060;?Km0<000000P2_do<00`000000[/oa0:k?l@070:k?l@<00000
0`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00D0oooo00170?ooo`030000003o
ool0oooo03X0oooo0P0000020:_>lP8000001P2dcN`2000000030;WDkP000000000000P0`<oV0P00
00000`33bMl000000<[=g0060<[=g00300000039aMH0bLGF00@0bLGF00<000000<k5dP0000002@3;
_/h00`000000akW<000000080<Rfb00400000034//P0a;;8000000T0`jg400<000000;n[aP000000
2@2lY/<010000000]Z320;JP`P2fX<82000000@0]:3400<000000:bJa02/V/@01P2/V/@00`000000
XY?60::CaP060::CaP030000002DS<T0U8c900D0U8c900<000000824cP20Q<h01020Q<h00`000000
IG[D06Eje00406Eje0040000000oKmT0?foI03m_f@8000000P00?L400`000000@G3I045`f@020000
000306iic@000000S8C500L0S8C500<0000009j;`02NRl001`2NRl03000000P0]:K;00<000000;n/
a`2o[<L01@2o[<L00`000000c/WF0<k9eP020<k9eP050000003Dbm00e<_@0=C;d00000001`3NimX0
1@000000f__K0=[kf`3Jnm/0000000<0b?oD0P000000102fo=8000000000002]n]/2000000040:gh
jP00000000000;_fl08000001P2gkOH200000080/^;g0P0000020;?Km0<000001@2_do<00`000000
[/oa0:k?l@040:k?l@<000001`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00D0
oooo00180?ooo`030000003oool0oooo03/0oooo0P00000:0;C=k00300000030cnH0`<oV00L0`<oV
00<000000<?9g`33bMl00P33bMl2000000@0b/gL00<000000<W5eP39aMH01P39aMH00`000000bkk>
0<^ncP070<^ncP0500000037^L`0akW<0<Nic00000001P38]/P00`000000a;;80<Bbb0020<Bbb003
00000033[L@0`jg400D0`jg400@000000;n[aP2oZlH000002P2lY/<3000000L0]:3400<000000:bJ
a02/V/@01@2/V/@00`000000XY?60::CaP050::CaQ<000001@1UN]@00`000000?foI03m_f@0203m_
f@<000001011L=T3000000L0S8C500<0000009j;`02NRl001@2NRl03000000X0]:K;00<000000;n/
a`2o[<L00`2o[<L2000000H0c/WF00<000000=C;d00000001P3NimX2000000<0f__K00D000000<So
e038om@0b?oD000000020;KldP040000002]n]/0[O[K000000D0[OSZ0P0000040;O]mP<000001P2b
h_L2000000T0[m?c00<000000:k?l@2^co400`00000:0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool01@3oool004T0oooo00<000000?ooo`3oool0>`3oool00`000000]<g/0;C=k006
0;C=k080000000<0^/[W0000000000001@30cnH2000000L0`lWO00@000000<[=g000000000002039
aMH00`000000akoC000000070<^ncP0300000037^L`0akW<0080akW<00<000000<Rfb038]/P00`38
]/P00`000000a;;80<Bbb0040<Bbb00300000033[L@0`jg40080`jg40P0000040;n[aP030000002l
Y/<0_:K300L0_:K300<000000;BPa02dX<@01`2dX<@00`000000[9[40:bJa0060:bJa0030000002R
TlH0XY?600@0000000<0XiS90000002HT/`01P2HT/`00`000000RHgA08V=d@0508V=d@030000001g
R=P0000000<0000000<0IG[D0000000oKmT0100oKmT3000000D0@G3I1@00000408b4a@030000002N
Rl00WX_000@000000`2PWM400`000000]:K;0;BVb`080;BVb`050000002o[<L0_jc70;n/a`000000
2@3>bMH00`000000g^OJ0=kWfP040=kWfP030000003Jnm/0f__K0080f__K00<000000<Soe038om@0
0P000000102fo=8000000000002]n]/2000000@0[OSZ0P0000020:kbm@@000001`2bh_L200000003
0:oHm@000000[m?c00P0[m?c0`00000>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool01@3oool004X0oooo00<000000?ooo`3oool0>`3oool2000000@0]<g/0P0000050;[:i`800000
00<0`<oV0000000000002P33bMl00`000000bLGF0<W5eP070<W5eP0500000037_m<0akoC0<Nod`00
00001@3;_/h00`000000akW<0<Nic0040<Nic00500000038]/P0b;K80<Rfb00000002034//P01000
0000`jg40<>]a00000060;n[aP030000002lY/<0_:K300D0_:K30`0000090;BPa0030000002/V/@0
[9[400H0[9[40`0000060:>Hb@030000002HT/`0V9;<00D0V9;<00<0000008V=d@29SM401@29SM40
0`000000MhSH07N8f00207N8f0@00000100oKmT3000000D0@G3I00@0000007j>f@1nS]T0OXkI1`00
00070:2Md@030000002dY//0]:K;00P0]:K;00@000000;n/a`2o[<L000002@3>bMH00`000000en_R
000000040=kWfP030000003Jnm/0f__K0080f__K00@000000<Soe038om@000000P2fo=8010000000
[O[K0000000000040:ghjP8000000`2^l_D200000080[^Oi00<000000;;Rm`2bh_L00`2bh_L20000
00@0[mSe00<000000:oCl`2_do<0102_do<200000180oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`050?ooo`00B`3oool2000003d0oooo00@000000;C=k000000000002@2jb^L00`00
0000`lWO0<?9g`080<?9g`80000000<0a<GK00000039aMH01@39aMH2000000D0akoC00D000000<^n
cP3;_/h0bkk>000000080<Nic00300000038]/P0000000T0a;;800<000000<>]a0000000202oZlH0
0`000000_:K30;bV``030;bV``050000002iY/H0^JK60;VVaP0000002@2dX<@00`000000[9[40:bJ
a0030:bJa080000000<0[9g80000002SV<T01P2SV<T00`000000V9;<09RBc00509RBc00300000029
SM40RHgA00D0RHgA00<0000007N8f01gR=P01@1gR=P300000080?foI0`000005045`f@030000001n
S]T0OXkI00H0OXkI00<000000:2Md@2PWM401`2PWM400`000000]:K;0;BVb`080;BVb`8000002@3>
bMH010000000en_R0=O[hP3Gjn82000000030=kWfP000000f__K00<0f__K00D000000<Soe0000000
00000;KldP05000000<0[OSZ0P0000030:kbm@8000001@2^ioT00`000000/^;g0;;Rm`02000000L0
[mSe00<000000:oCl`2_do<00`00000E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool0103oool004d0oooo00<000000?ooo`3oool0>`3oool00`000000^/[W0;[:i`070;[:i`800000
00<0_<OR00000033bMl01`33bMl00`000000a<GK0<C5f`020<C5f`8000000`39aMH00`000000akoC
0<Nod`060<Nod`030000003;_/h0000000X0akW<00<000000<Bbb034//P02@34//P00`000000_j_6
0;n[aP080;n[aP050000002lY/<0_:K30;bV``000000102iY/H00`000000]:340;BPa0070;BPa004
0000002/V/@0[9[40:bJa08000000`2/WLP00`000000XiS90:>Hb@060:>Hb@030000002HT/`0V9;<
00D0V9;<00<0000008V=d@29SM401@29SM400`000000MhSH07N8f00407N8f0030000001NQN00GXGP
00H000001@11L=T00`000000OXkI07j>f@0507j>f@030000002PWM40X9gA00L0X9gA00<000000;BV
b`2dY//0202dY//00`000000c/WF0<k9eP070<k9eP030000003Gjn80en_R00@0en_R0P0000030=[k
f`T000000P2Bl=h3000000<0[_;e0P0000070:kWn@<000002@2_f?D3000001P0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`040?ooo`00CP3oool00`000000oooo0?ooo`0k0?ooo`80
00001@2jb^L2000000@0_<OR0P0000040<?9g`8000001`34aM/00`000000bLGF0000000:0<Nod`03
00000037^L`0akW<00P0akW<00<000000<Bfc@0000002@34//P2000000X0_j_600@000000;bV``00
000000001P2iY/H00`000000]:340;BPa0070;BPa0<000001P2/WLP00`000000XiS90:>Hb@050:>H
b@030000002HT/`0V9;<00D0V9;<00<0000008V=d@29SM401@29SM400`000000MhSH07N8f00507N8
f0030000001NQN00GXGP0080GXGP1@000003045`f@030000001nS]T0OXkI00H0OXkI00<000000:2M
d@2PWM401`2PWM400`000000]:K;0;BVb`050;BVb`80000000<0_lKO0000003>bMH01P3>bMH00`00
0000en_R0=O[hP040=O[hP0300000039o]h0bOkN00D0000000<0SNZl0000000000000P00000209;`
gP8000000`2NlO83000000L0[^Oi0P0000020:gKm`030000002_f?D0[mSe00@0[mSe0`00000L0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0103oool004l0oooo00<000000?ooo`3o
ool0?03oool2000000030;[:i`000000000000P0_<OR00@000000<?9g`00000000002P34aM/00`00
0000akoC0<Nod`080<Nod`0300000035_=80000000L0akW<0P0000020<Bfc@0300000034//P0a;;8
00H0a;;800@000000<6`b@31/<T000002P2oZlH00`000000^JK60;VVaP060;VVaP030000002dX<@0
]:3400L0]:3400<000000:bMb02/WLP01P2/WLP00`000000XiS90:>Hb@060:>Hb@030000002HT/`0
V9;<00D0V9;<00<0000008V=d@29SM401@29SM400`000000MhSH07N8f00407N8f0030000001NQN00
GXGP00@0GXGP1@000002045`f@030000001nS]T0OXkI00D0OXkI00<000000:2Md@2PWM401`2PWM40
0`000000]:K;0;BVb`040;BVb`030000002oa]l0_lKO0080_lKO00<000000<k9eP3>bMH00`3>bMH0
0`000000en_R0=O[hP030=O[hP8000000`39o]h40000000508gZ_000000000000000002Bl=h00`00
000309kalP8000000P2VjOX2000000<0[^Oi0`0000050:gKm`030000002_f?D0[mSe00<00000803o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo001@0?ooo`800000?P3oool0
0`000000_<OR0;c7hP090;c7hP0300000034aM/0a<GK00P0a<GK0P0000000`32`MP000000<Nod`06
0<Nod`8000000`35_=800`000000akW<0<Nic0030<Nic00300000034]/d0a;K=00<0a;K=00<00000
0<Bbb034//P01034//P01@000000`K390<6`b@31/<T0000000T0_j_60P0000090;VVaP030000002d
X<@0]:3400@0]:340`0000090:bMb0030000002SV<T0XiS900D0XiS900<0000009RBc02HT/`01@2H
T/`00`000000RHgA08V=d@0508V=d@030000001gR=P0MhSH00D0MhSH00<0000005j5h01NQN00101N
QN020000008005[B0P0000000`11L=T0000007j>f@0607j>f@030000002PWM40X9gA00L0X9gA00@0
00000;BVb`2dY//0]:K;0P0000060;o6g`050000003>bMH0c/WF0<k9eP0000001@3Gjn800`000000
bOkN0<WngP020<WngP040000002Wm/P0000008gZ_0H000000`2NlO83000000H0Y^Wj0`0000080:gK
m`<00000903oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo001B0?ooo`03
0000003oool0oooo03`0oooo00<000000;c7hP2lan801P2lan82000000030;g4g`000000a<GK00L0
a<GK00<000000<;1f032`MP00P32`MP00`000000akoC0<Nod`030<Nod`0300000035_=80aKcB00<0
aKcB00<000000<Nic037^L`00P37^L`00`000000a;K=0<Bfc@040<Bfc@0300000034//P0a;;80080
a;;80P0000050<6`b@030000002oZlH0_j_600@0_j_60P0000020;b[b@030000002iY/H0^JK600H0
^JK600<000000;BPa02dX<@00P2dX<@2000000<0/Z;800<000000:bMb02/WLP01P2/WLP00`000000
XiS90:>Hb@060:>Hb@030000002HT/`0V9;<0080V9;<3`00000307N8f0030000001NQN00GXGP00@0
GXGP00<0000003n3j00000000`00F]82000000L0OXkI00<000000:2Md@2PWM401`2PWM4010000000
]:K;0000000000090;o6g`030000003>bMH0000000D0en_R00@000000<WngP39o]h0bOkN0P000000
0`2Wm/P0000000000004000000<0QnW^0`0000060:KYnP<000000P2Yg_X2000000<0[M_g1000000W
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0103oool005<0oooo00<000000?oo
o`3oool0?03oool2000000@0_<OR0P0000040;g4g`8000001034aM/2000000D0`/7H00<000000<No
d`37_m<00P37_m<00`000000aKcB0<FldP050<FldP0400000037^L`00000000000P0a;K=00@00000
0<Bbb034//P000001`31/<T00`000000_j_60;n[aP030;n[aP030000002lZlT0_:_90080_:_900<0
00000;VVaP2iY/H01`2iY/H010000000]:340000000000050;:Rb0030000002/WLP0[9g800L0[9g8
00<000000:>Hb@2SV<T0102SV<T6000000<0W9W@00<00000096Fe@2AU]D01P2AU]D00`000000Q9GK
08BEf`08000000<0GXGP00<0000003n3j00000001000F]83000000D0OXkI00<000000:2Md@2PWM40
1@2PWM43000000`0_lKO00<000000=O[hP3Gjn800P3Gjn82000000<0bOkN00<000000:Ofb0000000
1@00000308OYkP8000000P2Jio/200000080Y^Wj0`0000060:WNnP@00000;03oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00@0oooo001D0?ooo`030000003oool0oooo03d0oooo00@0
00000;c7hP0000000000202ma=l010000000a<GK0000000000080<;1f00400000037_m<000000000
00T0aKcB00<000000<Bfc@34]/d02034]/d00`000000a;;8000000090<6`b@050000002oZlH0_j_6
0;n[aP0000001P2lZlT00`000000^JK60;VVaP060;VVaP800000202bX/P00`000000[9g80:bMb006
0:bMb0030000002SV<T0XiS900@0000000<0Y9g>0000002LVM001`2LVM000`000000TIKE096Fe@05
096Fe@0300000024UM/0Q9GK00D0Q9GK00<0000007FFi01eU^@020000003001JdP030000001MW?40
000000<0000000<0OXkI0000002PWM400P2PWM44000000<0Wk_/00<000000;o6g`2oa]l01`2oa]l2
000000050<7]l@00000000000=O[hP0000000`39o]h800000080QnW^0`00000509[Wn`<000001`2Y
g_X200000340oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`030?ooo`00E@3oool2
000003h0oooo00<000000;g4g`2ma=l02@2ma=l00`000000`/7H0<;1f0090<;1f00300000035_=80
aKcB00P0aKcB00<000000<:idP0000002P34]/d00`000000`K390<6`b@080<6`b@040000002oZlH0
0000000000L0_:_900<000000;VVaP2iY/H0102iY/H3000000T0/Z;800<000000:bMb02/WLP01P2/
WLP3000000H0Y9g>00<0000009bId02LVM001@2LVM000`000000TIKE096Fe@06096Fe@0300000024
UM/0Q9GK00@0Q9GK00<0000007FFi01eU^@01@1eU^@40000008005[B00<0000005fLl@1MW?400`1M
W?45000000P0Wk_/00<000000;o6g`2oa]l0102oa]l2000000D0`Nga3`00000409[Wn`@000000P2R
g_`2000000<0ZMkj0`00000c0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3o
ool005L0oooo00<000000?ooo`3oool0?03oool00`000000_LCO0;g4g`060;g4g`80000000<0_L7M
00000032`MP01`32`MP2000000030<6ne`000000aKcB00L0aKcB00D000000<:idP32^M80`[WB0000
00070<Bfc@80000000<0`;C>00000031/<T02@31/<T00`000000_:_90;b[b@080;b[b@040000002i
Y/H0^JK60;VVaP8000000`2fYlX00`000000/Z;80;:Rb0070;:Rb0030000002/WLP0[9g800<0[9g8
0P0000000`2[XLd000000:BMcP060:BMcP030000002LVM00W9W@00H0W9W@00<00000096Fe@2AU]D0
1@2AU]D00`000000Q9GK08BEf`0508BEf`030000001eU^@0MIKT00D0MIKT00<0000006BJkP1TV^h0
0P0000000`00F]80000005fLl@0605fLl@030000002O^n`0Wk_/00L0Wk_/00<000000;o6g`2oa]l0
0P2oa]l2000000D0`Nga0P00000209geg`T00000102;hO`4000000P0X]kl0`00000g0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool00`3oool005P0oooo00<000000?ooo`3oool0?03o
ool00`000000_LCO0;g4g`030;g4g`800000102m`Md2000000@0`/7H0P0000040<6ne`0300000035
_=80aKcB00<0aKcB0P0000040<:idP0300000034]/d0a;K=00@0a;K=00<000000<2dcP30]<h00P30
]<h00`000000`K390<6`b@050<6`b@80000000<0_K3=0000002lZlT0202lZlT010000000^JK60000
000000050;JWbP030000002bX/P0/Z;800L0/Z;800<000000:bMb02/WLP00`0000040:^Qc@030000
002TWLh0Y9g>00D0Y9g>00<0000009bId02LVM001@2LVM000`000000TIKE096Fe@06096Fe@030000
0024UM/0Q9GK00D0Q9GK00<0000007FFi01eU^@0101eU^@010000000I9[^06BJkP1TV^h200000003
001JdP000000GIca00H0GIca00<0000009nkk02O^n`01`2O^n`010000000_lKO0000000000060<7]
l@030000002MmMl0WOGO00L000001P2;hO`200000080Vm_m00<000000:;No02Rg_`01@2Rg_`20000
03/0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`030?ooo`00F@3oool00`000000
oooo0?ooo`0l0?ooo`030000002ma=l0_LCO00800000202m`Md010000000`/7H0000000000070<6n
e`0500000035_=80aKcB0<FldP0000001`32^M800`000000a;K=0<Bfc@020<Bfc@0300000030]<h0
`;C>00<0`;C>00<000000<6`b@31/<T01031/<T01@000000_K3=0;f`c@2m/<d0000000X0_:_900<0
00000;JWbP2fYlX01P2fYlX00`000000/Z;80;:Rb0070;:Rb08000001`2[XLd00`000000Y9g>0:BM
cP050:BMcP030000002LVM00W9W@00H0W9W@00<00000096Fe@2AU]D01@2AU]D00`000000Q9GK08BE
f`0508BEf`030000001eU^@0MIKT00D0MIKT00<0000006BJkP1TV^h00P1TV^h2000000L0GIca00<0
000009nkk02O^n`01P2O^n`3000000H0`Nga0P0000000`2MmMl000000000000300000080OMSn0P00
000308_Qo0<000001@2Kfod200000080X]kl0`00000n0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool00`3oool005X0oooo0P00000m0?ooo`8000002`2m`Md00`000000`KkG0<6ne`08
0<6ne`0300000035_=80000000T0`[WB00@000000<Bfc@00000000001`30]<h00`000000`K390<6`
b@020<6`b@030000002m/<d0_K3=00<0_K3=00<000000;b[b@2lZlT01@2lZlT3000000P0]ZO:00<0
00000;:Rb02bX/P01@2bX/P3000000T0Zj7=00<000000:BMcP2TWLh01@2TWLh00`000000W9W@09bI
d00509bId0030000002AU]D0TIKE00<0TIKE7P00000305fLl@040000002O^n`0Wk_/09nkk0@00000
0`27foh200000080`Nga0P000000102MmMl0000000000000000607gHoPD00000202Kfod400000440
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`00G03oool00`000000oooo
0?ooo`0k0?ooo`030000002m`Md0_L7M00L0_L7M0P0000000`2k_md000000<6ne`090<6ne`030000
0032^M80`[WB00T0`[WB00<000000<2dcP30]<h02030]<h010000000`K390000000000060;f`c@03
0000002lZlT0_:_900@0_:_900D000000;V/c@2i[<d0^Jc=000000080;JWbP030000002bX/P0/Z;8
0080/Z;80P0000030;2VcP030000002[XLd0Zj7=00H0Zj7=00<000000:BMcP2TWLh01@2TWLh00`00
0000W9W@09bId00309bId0P00000102HWmT00`000000Sj3O08nPg`0508nPg`0300000026XnL0QZ?W
00D0QZ?W00<0000007fXk`1mZ>l00`1mZ>l2000000805IGT1`00000808OKoPL0000000<0M<_o0000
000000001@00000409?EoP8000000`2Kfod4000004H0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`030?ooo`00G@3oool00`000000oooo0?ooo`0k0?ooo`030000002m`Md0_L7M00D0
_L7M00<000000;^og@2k_md00P2k_md00`000000`KkG0<6ne`050<6ne`80000000<0_[cH00000032
^M801`32^M82000000030;jhe0000000`;C>00T0`;C>00<000000;f`c@2m/<d01`2m/<d010000000
_:_90;b[b@2lZlT2000000@0^Jc=00<000000;JWbP2fYlX01P2fYlX00`000000/Z;80;:Rb0020000
00D0/:K>00<000000:^Qc@2[XLd01`2[XLd00`000000Y9g>0:BMcP040:BMcPH00000102OXMH00`00
0000V9oI09ROf@0509ROf@030000002?X=l0Sj3O00D0Sj3O00<0000008JSi`26XnL01@26XnL00`00
0000OJS_07fXk`0507fXk`H0000000<05IGT0000000000001027foh80000000307C;o`0000000000
008000000P2=c?d00`000000TmGn09?EoP0609?EoP@00000B`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo0080oooo001N0?ooo`030000003oool0oooo03/0oooo00<000000;g1g@2m
`Md00P2m`Md2000000D0^koM00<000000<6ne`31_]L00`31_]L2000000@0_[cH00<000000<:idP32
^M801032^M801@000000_[SD0;jhe02n^=@0000000P0`;C>0P0000000`2l]=8000000;f`c@070;f`
c@040000002lZlT00000000000L0^Jc=00<000000;JWbP2fYlX01P2fYlX2000000P0/:K>00<00000
0:^Qc@2[XLd01P2[XLd00`000000Y9g>0:BMcP0400000080YZ?C00<0000009nQeP2OXMH01@2OXMH0
0`000000V9oI09ROf@0609ROf@030000002?X=l0Sj3O00D0Sj3O00<0000008JSi`26XnL01@26XnL0
0`000000OJS_07fXk`0507fXk`030000001e/_P0MK;h0080MK;h4000000708g<o@040000002CeOh0
TmGn09?EoP@00000D03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo001O
0?ooo`800000?03oool010000000_L7M0000000000080;^og@0300000031_]L0`KkG008000001P2n
_=P00`000000`[WB0<:idP020<:idP8000001@2n^=@00`000000`;C>0<2dcP040<2dcP050000002l
]=80_;CB0;bddP0000002@2m/<d00`000000^Jc=0;V/c@070;V/c@030000002fYlX0]ZO:00@0]ZO:
0P0000000`2dZll000000;2VcP070;2VcP030000002[XLd0Zj7=00H0Zj7=0`0000060:JSd`030000
002OXMH0Wj7F00H0Wj7F00<0000009ROf@2HWmT01P2HWmT00`000000Sj3O08nPg`0408nPg`030000
0026XnL0QZ?W00D0QZ?W00<0000007fXk`1mZ>l00`1mZ>l@000000D0R/?j0P00000508g<o@H00000
E03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0080oooo001Q0?ooo`030000003o
ool0oooo03X0oooo00<000000;^og@2k_md02@2k_md2000000T0_[cH00@000000<:idP0000000000
202n^=@010000000`;C>0<2dcP30]<h2000000D0_;CB00<000000;f`c@2m/<d0102m/<d200000003
0;Vad@000000^Jc=00P0^Jc=00@000000;JWbP2fYlX0]ZO:0P0000030;B[c`030000002`Y/h0/:K>
00L0/:K>00<000000:^Qc@2[XLd00`2[XLd200000080ZjOC00<000000:JSd`2VXm<01@2VXm<00`00
0000Wj7F09nQeP0609nQeP030000002HWmT0V9oI00D0V9oI00<0000008nPg`2?X=l00P2?X=l@0000
00@0SK;_00<0000008Zim@2:^OD01@2:^OD00`000000R/?j08[3nP0708[3nPH00000F`3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo001R0?ooo`030000003oool0oooo03X0
oooo00<000000;^og@2k_md01P2k_md2000000030;Vng@000000_[cH00T0_[cH00<000000;jhe02n
^=@0202n^=@010000000`;C>0000000000080;bddP040000002m/<d0_K3=0;f`c@8000000`2i/M40
0`000000^Jc=0;V/c@070;V/c@040000002fYlX00000000000H0]:_?00<000000;2VcP2`Y/h01P2`
Y/h00`000000Zj7=0:^Qc@03000000@0ZjOC00<000000:JSd`2VXm<01@2VXm<00`000000Wj7F09nQ
eP0609nQeP030000002HWmT0V9oI00<0V9oI1`00000409NYhP030000002B[>P0TZcX00D0TZcX00<0
000008fbk`2=/^l01P2=/^l00`000000R[We08Zim@0508Zim@8000000`2:`oX400000680oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`020?ooo`00H`3oool00`000000oooo0?ooo`0j
0?ooo`800000102k_md2000000@0^KkM00<000000;jlf02n_=P01@2n_=P2000000030;^kfP000000
_[SD00T0_[SD00<000000;bddP2l]=80202l]=8010000000_K3=0000000000060;Vad@030000002i
[<d0^Jc=00L0^Jc=00<000000;B[c`2dZll01`2dZll00`000000/:K>0;2VcP050;2VcP<00000202[
Ym<00`000000YZ?C0:JSd`050:JSd`030000002OXMH0Wj7F00D0Wj7F1P00000409fXgP030000002G
ZN80UjWR00D0UjWR00<0000009:/j02B[>P01@2B[>P00`000000SK;_08fbk`0608fbk`030000002:
^OD0R[We00<0R[We1P00001V0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3o
ool006@0oooo00<000000?ooo`3oool0>`3oool010000000^koM0000000000070;Vng@030000002n
_=P0_[cH0080_[cH0P0000040;^kfP030000002n^=@0_[SD00D0_[SD0P0000000`2k^=L000000;bd
dP090;bddP030000002i/M40^K7A00H0^K7A00<000000;V/c@2i[<d01@2i[<d2000000030;J_dP00
0000]:_?00P0]:_?00<000000;2VcP2`Y/h00P2`Y/h200000080[j_C00<000000:^Wd`2[Ym<01P2[
Ym<00`000000YZ?C0:JSd`050:JSd`040000002OXMH0Wj7F09nQeP@000000P2RZ=/00`000000WJSN
09fXgP0509fXgP030000002GZN80UjWR00D0UjWR00<0000009:/j02B[>P01P2B[>P00`000000SK;_
08fbk`0308fbk`P00000K@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo
001U0?ooo`800000?03oool00`000000^KkM0;Vng@080;Vng@040000002n_=P00000000000L0^k_J
00<000000;jhe02n^=@00P2n^=@2000000@0^kSG00<000000;bddP2l]=801@2l]=82000000030;Ve
eP000000^K7A00L0^K7A00<000000;V/c@2i[<d00P2i[<d2000000<0]ZoB00<000000;B[c`2dZll0
1`2dZll00`000000/:K>0;2VcP02000000@0[j_C00<000000:^Wd`2[Ym<01`2[Ym<00`000000YZ?C
0:JSd`040:JSd`@000001P2RZ=/00`000000WJSN09fXgP0609fXgP030000002GZN80UjWR00D0UjWR
00<0000009:/j02B[>P00`2B[>P8000007H0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`020?ooo`00I`3oool00`000000oooo0?ooo`0j0?ooo`030000002i_]d0^KkM00P0^KkM00<0
00000;^kfP2k^mX0202k^mX010000000_[SD0000000000060;^he`030000002l]=80_;CB00<0_;CB
0P0000030;VeeP030000002i/M40^K7A00H0^K7A00<000000;V/c@2i[<d00P0000060;J_dP030000
002dZll0]:_?00H0]:_?0`0000070:n[d`030000002[Ym<0ZjOC00H0ZjOC00<000000:JSd`2VXm<0
100000020:NZf@030000002RZ=/0XZSK00H0XZSK00<0000009fXgP2MZ=h01P2MZ=h00`000000UjWR
09NYhP0409NYhPH00000O`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0040oooo
001X0?ooo`030000003oool0oooo03X0oooo00<000000;Vng@2i_]d01@2i_]d2000000030;NmgP00
0000^k_J00T0^k_J00<000000;^he`2k^=L01`2k^=L00`000000_;CB0;bddP02000000H0^KGF00<0
00000;Vad@2i/M401@2i/M43000000T0]ZoB00<000000;B[c`2dZll00`2dZll200000080/JkE00<0
00000:n[d`2_Zm<01@2_Zm<00`000000ZjOC0:^Wd`060:^Wd`<000001P2WZ]T00`000000XZSK0::X
f`070::Xf`030000002MZ=h0WJSN00D0WJSN00<0000009NYhP2GZN80100000250?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00@3oool006T0oooo00<000000?ooo`3oool0>@3oool0
0`000000^KkM0;Vng@030;Vng@800000102g_Mh00`000000^k_J0;^kfP050;^kfP80000000<0^;_L
0000002k^=L0202k^=L2000000T0^KGF00<000000;Vad@2i/M400P2i/M4200000080][?F00<00000
0;J_dP2f[m801`2f[m800`000000]:_?0;B[c`03000000@0/JkE00<000000:n[d`2_Zm<01P2_Zm<0
0`000000ZjOC0:^Wd`030:^Wd`8000000P2[[MT00`000000Yj[I0:NZf@050:NZf@030000002RZ=/0
XZSK00H0XZSK00<0000009fXgP2MZ=h00`2MZ=h5000008X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`010?ooo`00JP3oool2000003X0oooo00<000000;Vng@2i_]d00P0000060;Nm
gP030000002k^mX0^k_J00<0^k_J0P0000040;Rkg0030000002k^=L0^kSG00@0^kSG0P0000000`2g
^MX000000;VeeP080;VeeP030000002i/M40^K7A008000001@2f/mH00`000000]ZoB0;J_dP070;J_
dP800000202a[]D00`000000[j_C0:n[d`050:n[d`030000002[Ym<0ZjOC00<00000102[[MT00`00
0000Yj[I0:NZf@060:NZf@030000002RZ=/0XZSK00D0XZSK1P00002@0?ooo`050000003oool0oooo
0?ooo`0000000`3oool006`0oooo00<000000?ooo`3oool0>03oool2000000T0]kgN00<000000;^k
fP2k^mX00P0000060;Rkg0030000002k^=L0^kSG0080^kSG0P0000040;NifP030000002i]MH0^KGF
00L0^KGF0P0000070;JceP030000002f[m80]ZoB00D0]ZoB0P0000000`2c/]P000000;6^e@080;6^
e@030000002_Zm<0[j_C00@0[j_C0`0000080:^]f@030000002WZ]T0Yj[I00D0Yj[I00@000000::X
f`2RZ=/0XZSK1000002G0?ooo`040000003oool0oooo000000<0oooo001]0?ooo`030000003oool0
oooo03P0oooo00<000000;NmgP2g_Mh01`2g_Mh3000000T0^;_L00@000000;^he`00000000001P2g
^MX00`000000^KGF0;VeeP050;VeeP80000000<0][OJ0000002f/mH01`2f/mH00`000000]ZoB0;J_
dP020;J_dP8000000`2c/]P00`000000/JkE0;6^e@070;6^e@030000002_Zm<0[j_C00@000000P2]
[mT00`000000ZjgI0:^]f@070:^]f@030000002WZ]T0Yj[I00@0Yj[I1000002K0?ooo`040000003o
ool0oooo000000<0oooo001^0?ooo`030000003oool0oooo03P0oooo0P0000050;NmgP8000000P2d
_N000`000000^;_L0;Rkg0070;Rkg08000002@2g^MX00`000000^KGF0;VeeP020;VeeP8000000`2f
]mX00`000000][?F0;JceP070;JceP040000002f[m800000000000H0/k;H00<000000;6^e@2a[]D0
1P2a[]D3000000L0[JoI00<000000:^]f@2[[MT01P2[[MT00`000000Yj[I0:NZf@0400000:00oooo
00<000000?ooo`0000000`3oool006l0oooo0P00000j0?ooo`030000002g_Mh0]kgN008000001@2d
_N02000000D0^;_L0P0000020;Bkg`030000002g^MX0]kWJ00L0]kWJ00@000000;VeeP0000000000
1P2f]mX00`000000][?F0;JceP060;JceP8000002@2c/]P00`000000/JkE0;6^e@030;6^e@800000
0P2_/]/00`000000[JoI0:f_f@050:f_f@030000002[[MT0ZjgI00H0ZjgI0`00002U0?ooo`030000
003oool000000080oooo001a0?ooo`030000003oool0oooo03P0oooo0P0000090;Bmh0030000002h
^m`0^;_L008000001@2d^ml00`000000]kWJ0;NifP060;NifP8000002@2f]mX00`000000][?F0;Jc
eP030;JceP8000000P2c]]/00`000000/k;H0;>bf0060;>bf0030000002a[]D0/JkE00<00000102_
/]/00`000000[JoI0:f_f@060:f_f@040000002[[MT0ZjgI0:^]f@@00000Z@3oool200000080oooo
001b0?ooo`030000003oool0oooo03P0oooo00<000000;Bmh02d_N001`2d_N03000000L0];_O00<0
00000;NifP2g^MX0102g^MX200000080];[N00<000000;JgfP2f]mX01P2f]mX00`000000][?F0;Jc
eP03000000D0/kKK00<000000;>bf02c/]P01@2c/]P3000000P0[k;K00<000000:f_f@2][mT01@2]
[mT400000:d0oooo0P0000020?ooo`00L`3oool00`000000oooo0?ooo`0h0?ooo`030000002d_N00
];gP00@0];gP0P0000020;:mhP030000002d^ml0];_O00H0];_O00<000000;NifP2g^MX00`000005
0;BjgP030000002f]mX0][OJ00D0][OJ0`0000080;>ff`030000002c/]P0/k;H00<0/k;H0P000002
0;2fg@030000002_/]/0[k;K00L0[k;K00<000000:f_f@2][mT00P2][mT200000;40oooo0P000002
0?ooo`00M03oool2000003T0oooo00<000000;Bmh02d_N000`0000050;:mhP030000002d^ml0];_O
00D0];_O0`0000080;BjgP030000002f]mX0][OJ00<0][OJ0P0000020;:igP030000002c]]/0/kKK
00L0/kKK00<000000;>bf02c/]P00P0000050;2fg@030000002_/]/0[k;K00H0[k;K00<000000:f_
f@2][mT00P00002_0?ooo`@00000103oool007H0oooo00<000000?ooo`3oool0=`3oool2000000P0
/[gR00<000000;Bkg`2d^ml00`2d^ml200000080/KcR00<000000;BjgP2d^]h01`2d^]h00`000000
][OJ0;JgfP02000000D0/[WN00<000000;>ff`2c]]/01P2c]]/3000000L0/;KM00<000000:nbf`2_
/]/01P2_/]/300000:d0oooo100000080?ooo`00M`3oool00`000000oooo0?ooo`0g0?ooo`030000
002b_N80/[gR00L0/[gR00<000000;Bkg`2d^ml00P0000050;6lhP030000002d^]h0];[N00H0];[N
0`0000070;:igP030000002c]]/0/kKK00@0/kKK0P0000020;2hg`030000002`]]d0/;KM00H0/;KM
00@000000:nbf`2_/]/0[k;K1000002/0?ooo`@00000303oool007P0oooo00<000000?ooo`3oool0
=`3oool00`000000/[gR0;:mhP060;:mhP<00000202a_>800`000000];[N0;BjgP030;BjgP800000
0P2a^n400`000000/[WN0;:igP060;:igP030000002c]]/0/kKK00<000001@2`^=l00`000000/;KM
0;2fg@050;2fg@@00000[03oool400000100oooo001i0?ooo`800000>03oool00`000000/[gR0;:m
hP030;:mhP8000000P2__^@00`000000/KcR0;6lhP070;6lhP030000002d^]h0];[N008000001@2a
^n400`000000/[WN0;:igP050;:igP<00000202`^=l00`000000/;KM0;2fg@030;2fg@800000[03o
ool4000001@0oooo001k0?ooo`030000003oool0oooo03H0oooo00<000000;:mhP2b_N800P000005
0:nni0030000002a_>80/KcR00H0/KcR0`0000070;6kh@030000002b^Mh0/[WN00<0/[WN0P000002
0:njhP030000002`^=l0/;SO00L0/;SO00<000000;2fg@2`]]d00P00002[0?ooo`<00000603oool0
07`0oooo00<000000?ooo`3oool0=P3oool2000000P0[kkT00@000000;6lhP2a_>80/KcR10000002
0:nmi0030000002a^n40/K_Q00H0/K_Q00<000000;:igP2b^Mh00P0000050:njhP030000002`^=l0
/;SO00H0/;SO0`00002Y0?ooo`@000006`3oool007d0oooo00<000000?ooo`3oool0=P3oool00`00
0000[kkT0:nni0060:nni0@000001`2__N@00`000000/K_Q0;6kh@050;6kh@<00000202_^^800`00
0000/;SO0;2hg`030;2hg`800000Z03oool4000001l0oooo001n0?ooo`030000003oool0oooo03H0
oooo00<000000:nni02__^@00`2__^@200000080[KkV00<000000:nmi02__N@01`2__N@00`000000
/K_Q0;6kh@0400000080[[cT00<000000:njhP2_^^801`2_^^800`000000/;SO0;2hg`0200000:H0
oooo1000000S0?ooo`00O`3oool2000003L0oooo00<000000:nni02__^@00P0000050:fniP030000
002__N@0[kgT00H0[kgT0`0000070:jli0030000002_^^80[k[R00H0[k[R0`00002T0?ooo`@00000
9`3oool00840oooo00<000000?ooo`3oool0=@3oool2000000P0[KkV00<000000:nmi02__N@00`2_
_N@200000080[KkV00<000000:jli02^_>@01P2^_>@010000000[k[R0:njhP2_^^8400000:@0oooo
0`00000[0?ooo`00PP3oool00`000000oooo0?ooo`0e0?ooo`030000002]_^H0[KkV00L0[KkV00<0
00000:nmi02__N@00P0000050:fniP030000002^_>@0[[cT00D0[[cT1000002T0?ooo`@00000;P3o
ool008<0oooo00<000000?ooo`3oool0=@3oool00`000000[KkV0:fniP060:fniP<00000202]_^H0
0`000000[[cT0:jli00400000:@0oooo1000000b0?ooo`00Q03oool2000003H0oooo00@000000:fn
iP2]_^H0[KkV100000020:^nj0030000002]_^H0[KkV00H0[KkV0`00002T0?ooo`@00000=P3oool0
08H0oooo00<000000?ooo`3oool0=03oool3000000L0ZkkX00<000000:fniP2]_^H00`2]_^H20000
0:<0oooo1000000j0?ooo`00Q`3oool00`000000oooo0?ooo`0d0?ooo`030000002[_^P0ZkkX00L0
ZkkX00<000000:fniP2]_^H00P00002Q0?ooo`@00000?P3oool008P0oooo00<000000?ooo`3oool0
=03oool2000000L0ZkkX0`00002P0?ooo`<00000@P3oool008T0oooo0P00000f0?ooo`030000002[
_^P0ZkkX00@00000W`3oool4000004D0oooo002;0?ooo`030000003oool0oooo03@0oooo0P00002O
0?ooo`@00000B@3oool008`0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`2J0?oo
o`@00000C@3oool008d0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`2G0?ooo`@0
0000D@3oool008h0oooo0P00000a0?ooo`030000003oool0oooo09<0oooo1000001E0?ooo`00T03o
ool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0900oooo0`00001I0?ooo`00T@3oool0
0`000000oooo0?ooo`0]0?ooo`030000003oool0oooo08`0oooo1000001L0?ooo`00TP3oool00`00
0000oooo0?ooo`0/0?ooo`030000003oool0oooo08P0oooo1000001P0?ooo`00T`3oool2000002`0
oooo00<000000?ooo`3oool0Q03oool4000006@0oooo002E0?ooo`030000003oool0oooo02T0oooo
00<000000?ooo`3oool0P03oool4000006P0oooo002F0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool0O@3oool3000006`0oooo002G0?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0N@3oool4000006l0oooo002H0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0M@3oool4000007<0oooo002I0?ooo`8000009P3oool00`000000oooo0?ooo`1a0?ooo`@0
0000M`3oool009/0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`1]0?ooo`@00000
N`3oool009`0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`1Y0?ooo`@00000O`3o
ool009d0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1V0?ooo`<00000P`3oool0
09h0oooo0P00000Q0?ooo`030000003oool0oooo0680oooo100000260?ooo`00X03oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo05h0oooo1000002:0?ooo`00X@3oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo05X0oooo1000002>0?ooo`00XP3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo05H0oooo1000002B0?ooo`00X`3oool2000001`0oooo00<00000
0?ooo`3oool0D`3oool3000009H0oooo002U0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool0C`3oool4000009T0oooo002V0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0B`3oool4000009d0oooo002W0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
A`3oool400000:40oooo002X0?ooo`8000005`3oool00`000000oooo0?ooo`130?ooo`@00000Y@3o
ool00:X0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0o0?ooo`@00000Z@3oool0
0:/0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0l0?ooo`<00000[@3oool00:`0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0h0?ooo`@00000/03oool00:d0oooo
0P00000B0?ooo`030000003oool0oooo03@0oooo1000002d0?ooo`00[`3oool00`000000oooo0?oo
o`0?0?ooo`030000003oool0oooo0300oooo1000002h0?ooo`00/03oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo02d0oooo1000002l0?ooo`00/@3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo02T0oooo100000300?ooo`00/P3oool00`000000oooo0?ooo`0;0?ooo`03
0000003oool0oooo02H0oooo0`0000340?ooo`00/`3oool2000000/0oooo00<000000?ooo`3oool0
8P3oool400000<L0oooo002e0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool07P3o
ool400000</0oooo002f0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06P3oool4
00000<l0oooo002g0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool05P3oool40000
0=<0oooo002h0?ooo`8000001P3oool00`000000oooo0?ooo`0C0?ooo`<00000e`3oool00;X0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`@00000fP3oool00;/0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0;0?ooo`@00000gP3oool00;`0oooo00D00000
0?ooo`3oool0oooo000000090?ooo`@00000hP3oool00;d0oooo0P0000000`3oool000000?ooo`04
0?ooo`@00000iP3oool00;l0oooo0P0000000`3oool000000000000200000>X0oooo00300?ooo`80
0000kP3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {349.313, 0}} -> {-0.0883766, 0.00577152, \
0.00363888, 0.00363888}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(esfera = 
        ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
            Sin[\[Phi]] Sin[\[Theta]], 
            Cos[\[Theta]]}, {\[Phi], \(-\[Pi]\), \[Pi]}, {\[Theta], 
            0, \[Pi]}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08777 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0576738 1.16792 -3.0954e-017 1.16792 [
[.09032 .22973 -11.8285 -9 ]
[.09032 .22973 .17155 0 ]
[.21918 .17532 -22.6085 -9 ]
[.21918 .17532 1.39151 0 ]
[.35517 .11792 -5.39002 -9 ]
[.35517 .11792 .60998 0 ]
[.49889 .0573 -15.3837 -9 ]
[.49889 .0573 2.61626 0 ]
[.65103 -0.00682 -4.86581 -9 ]
[.65103 -0.00682 1.13419 0 ]
[.00886 .82785 -6.92493 0 ]
[.00886 .82785 5.07507 9 ]
[.12049 .90619 -13.4177 0 ]
[.12049 .90619 10.5823 9 ]
[.22061 .97645 -3.26163 0 ]
[.22061 .97645 2.73837 9 ]
[.3109 1.03981 -9.54321 0 ]
[.3109 1.03981 8.45679 9 ]
[.39276 1.09724 -3.11047 0 ]
[.39276 1.09724 2.88953 9 ]
[.07322 .26204 -12 -2.61848 ]
[.07322 .26204 0 6.38152 ]
[.05471 .37835 -24 -2.72137 ]
[.05471 .37835 0 6.27863 ]
[.03459 .50481 -6 -2.83416 ]
[.03459 .50481 0 6.16584 ]
[.01263 .64281 -18 -2.95834 ]
[.01263 .64281 0 6.04166 ]
[-0.01142 .794 -6 -3.09573 ]
[-0.01142 .794 0 5.90427 ]
[ 0 0 0 0 ]
[ 1 1.08777 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08845 .24527 m
.67201 0 L
s
.10049 .2402 m
.10558 .24544 L
s
[(-1)] .09032 .22973 .97141 1 Mshowa
.22885 .18626 m
.23368 .19173 L
s
[(-0.5)] .21918 .17532 .88404 1 Mshowa
.36426 .12934 m
.36881 .13505 L
s
[(0)] .35517 .11792 .79667 1 Mshowa
.50734 .06921 m
.51156 .07516 L
s
[(0.5)] .49889 .0573 .7093 1 Mshowa
.65874 .00557 m
.6626 .01177 L
s
[(1)] .65103 -0.00682 .62194 1 Mshowa
.125 Mabswid
.12563 .22964 m
.12865 .23281 L
s
.15102 .21896 m
.15402 .22216 L
s
.17669 .20818 m
.17965 .2114 L
s
.20263 .19728 m
.20556 .20053 L
s
.25535 .17512 m
.25822 .17843 L
s
.28213 .16386 m
.28497 .1672 L
s
.30921 .15248 m
.31201 .15585 L
s
.33659 .14097 m
.33935 .14437 L
s
.39224 .11758 m
.39494 .12104 L
s
.42054 .10569 m
.42319 .10917 L
s
.44915 .09367 m
.45176 .09718 L
s
.47808 .08151 m
.48065 .08505 L
s
.53693 .05677 m
.53942 .06037 L
s
.56686 .04419 m
.56931 .04782 L
s
.59714 .03147 m
.59954 .03513 L
s
.62776 .0186 m
.63012 .02229 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
.08669 .25641 m
.09342 .25359 L
s
[(-1)] .07322 .26204 1 -0.41811 Mshowa
.06829 .37298 m
.07508 .3703 L
s
[(-0.5)] .05471 .37835 1 -0.39525 Mshowa
.04828 .49974 m
.05513 .4972 L
s
[(0)] .03459 .50481 1 -0.37019 Mshowa
.02644 .63807 m
.03335 .63571 L
s
[(0.5)] .01263 .64281 1 -0.34259 Mshowa
.00252 .78966 m
.00949 .78748 L
s
[(1)] -0.01142 .794 1 -0.31206 Mshowa
.125 Mabswid
.08313 .27897 m
.08717 .27729 L
s
.07951 .3019 m
.08356 .30024 L
s
.07583 .3252 m
.07989 .32356 L
s
.07209 .34889 m
.07616 .34727 L
s
.06442 .39748 m
.0685 .39588 L
s
.06049 .42239 m
.06458 .42081 L
s
.05649 .44773 m
.06058 .44617 L
s
.05242 .47351 m
.05652 .47197 L
s
.04407 .52643 m
.04818 .52493 L
s
.03978 .5536 m
.0439 .55211 L
s
.03541 .58125 m
.03954 .57979 L
s
.03097 .60941 m
.03511 .60796 L
s
.02184 .66727 m
.02599 .66588 L
s
.01714 .69701 m
.0213 .69564 L
s
.01236 .72731 m
.01652 .72596 L
s
.00749 .75819 m
.01166 .75686 L
s
.25 Mabswid
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
.41815 .58175 m
.08845 .24527 L
s
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.41815 .58175 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.40056 1.08777 L
s
.40056 1.08777 m
.41815 .58175 L
s
0 0 m
1 0 L
1 1.08777 L
0 1.08777 L
closepath
clip
newpath
.5 Mabswid
.722 .592 .71 r
.48269 .56077 m .52893 .56353 L .52909 .594 L p F P
0 g
s
.722 .592 .71 r
.52909 .594 m .47888 .59106 L .48269 .56077 L p F P
0 g
s
.69 .566 .71 r
.57922 .59053 m .52909 .594 L .52893 .56353 L p F P
0 g
s
.722 .576 .69 r
.47888 .59106 m .52909 .594 L .52923 .6244 L p F P
0 g
s
.688 .548 .69 r
.52909 .594 m .57922 .59053 L .58282 .62076 L p F P
0 g
s
.688 .548 .69 r
.58282 .62076 m .52923 .6244 L .52909 .594 L p F P
0 g
s
.72 .607 .73 r
.48696 .53067 m .52874 .53321 L .52893 .56353 L p F P
0 g
s
.72 .607 .73 r
.52893 .56353 m .48269 .56077 L .48696 .53067 L p F P
0 g
s
.691 .583 .73 r
.57509 .56028 m .52893 .56353 L .52874 .53321 L p F P
0 g
s
.69 .566 .71 r
.52893 .56353 m .57509 .56028 L .57922 .59053 L p F P
0 g
s
.722 .576 .69 r
.52923 .6244 m .47557 .62131 L .47888 .59106 L p F P
0 g
s
.723 .56 .669 r
.47557 .62131 m .52923 .6244 L .52936 .65449 L p F P
0 g
s
.686 .53 .669 r
.52923 .6244 m .58282 .62076 L .58586 .65072 L p F P
0 g
s
.686 .53 .669 r
.58586 .65072 m .52936 .65449 L .52923 .6244 L p F P
0 g
s
.752 .62 .713 r
.43807 .55207 m .48269 .56077 L .47888 .59106 L p F P
0 g
s
.752 .62 .713 r
.47888 .59106 m .43039 .58178 L .43807 .55207 L p F P
0 g
s
.756 .606 .692 r
.43039 .58178 m .47888 .59106 L .47557 .62131 L p F P
0 g
s
.748 .633 .732 r
.44668 .52267 m .48696 .53067 L .48269 .56077 L p F P
0 g
s
.748 .633 .732 r
.48269 .56077 m .43807 .55207 L .44668 .52267 L p F P
0 g
s
.718 .622 .749 r
.49167 .50098 m .52854 .50326 L .52874 .53321 L p F P
0 g
s
.718 .622 .749 r
.52874 .53321 m .48696 .53067 L .49167 .50098 L p F P
0 g
s
.691 .6 .749 r
.57046 .53022 m .52874 .53321 L .52854 .50326 L p F P
0 g
s
.691 .583 .73 r
.52874 .53321 m .57046 .53022 L .57509 .56028 L p F P
0 g
s
.656 .542 .713 r
.6275 .58074 m .57922 .59053 L .57509 .56028 L p F P
0 g
s
.652 .522 .693 r
.57922 .59053 m .6275 .58074 L .63447 .61047 L p F P
0 g
s
.652 .522 .693 r
.63447 .61047 m .58282 .62076 L .57922 .59053 L p F P
0 g
s
.66 .561 .733 r
.61951 .5511 m .57509 .56028 L .57046 .53022 L p F P
0 g
s
.656 .542 .713 r
.57509 .56028 m .61951 .5511 L .6275 .58074 L p F P
0 g
s
.756 .606 .692 r
.47557 .62131 m .4237 .61157 L .43039 .58178 L p F P
0 g
s
.758 .592 .671 r
.4237 .61157 m .47557 .62131 L .47278 .6513 L p F P
0 g
s
.723 .56 .669 r
.52936 .65449 m .47278 .6513 L .47557 .62131 L p F P
0 g
s
.743 .646 .752 r
.45615 .49381 m .49167 .50098 L .48696 .53067 L p F P
0 g
s
.743 .646 .752 r
.48696 .53067 m .44668 .52267 L .45615 .49381 L p F P
0 g
s
.647 .501 .671 r
.58282 .62076 m .63447 .61047 L .64035 .64008 L p F P
0 g
s
.647 .501 .671 r
.64035 .64008 m .58586 .65072 L .58282 .62076 L p F P
0 g
s
.691 .6 .749 r
.52854 .50326 m .56536 .50057 L .57046 .53022 L p F P
0 g
s
.663 .581 .752 r
.61056 .52178 m .57046 .53022 L .56536 .50057 L p F P
0 g
s
.66 .561 .733 r
.57046 .53022 m .61056 .52178 L .61951 .5511 L p F P
0 g
s
.723 .543 .647 r
.47278 .6513 m .52936 .65449 L .52946 .68406 L p F P
0 g
s
.683 .511 .647 r
.52936 .65449 m .58586 .65072 L .58831 .6802 L p F P
0 g
s
.683 .511 .647 r
.58831 .6802 m .52946 .68406 L .52936 .65449 L p F P
0 g
s
.715 .636 .769 r
.49677 .47194 m .52832 .47392 L .52854 .50326 L p F P
0 g
s
.715 .636 .769 r
.52854 .50326 m .49167 .50098 L .49677 .47194 L p F P
0 g
s
.691 .617 .769 r
.56536 .50057 m .52854 .50326 L .52832 .47392 L p F P
0 g
s
.758 .592 .671 r
.47278 .6513 m .41805 .64121 L .4237 .61157 L p F P
0 g
s
.761 .577 .648 r
.41805 .64121 m .47278 .6513 L .47053 .68079 L p F P
0 g
s
.723 .543 .647 r
.52946 .68406 m .47053 .68079 L .47278 .6513 L p F P
0 g
s
.641 .479 .648 r
.58586 .65072 m .64035 .64008 L .6451 .66931 L p F P
0 g
s
.641 .479 .648 r
.6451 .66931 m .58831 .6802 L .58586 .65072 L p F P
0 g
s
.737 .658 .771 r
.46642 .4657 m .49677 .47194 L .49167 .50098 L p F P
0 g
s
.737 .658 .771 r
.49167 .50098 m .45615 .49381 L .46642 .4657 L p F P
0 g
s
.691 .617 .769 r
.52832 .47392 m .55983 .47158 L .56536 .50057 L p F P
0 g
s
.667 .601 .772 r
.6007 .493 m .56536 .50057 L .55983 .47158 L p F P
0 g
s
.663 .581 .752 r
.56536 .50057 m .6007 .493 L .61056 .52178 L p F P
0 g
s
.775 .663 .738 r
.40945 .50944 m .44668 .52267 L .43807 .55207 L p F P
0 g
s
.775 .663 .738 r
.43807 .55207 m .39675 .53766 L .40945 .50944 L p F P
0 g
s
.782 .652 .718 r
.39675 .53766 m .43807 .55207 L .43039 .58178 L p F P
0 g
s
.782 .652 .718 r
.43039 .58178 m .3854 .56639 L .39675 .53766 L p F P
0 g
s
.789 .64 .697 r
.3854 .56639 m .43039 .58178 L .4237 .61157 L p F P
0 g
s
.627 .542 .739 r
.6605 .53623 m .61951 .5511 L .61056 .52178 L p F P
0 g
s
.619 .519 .719 r
.61951 .5511 m .6605 .53623 L .67214 .56486 L p F P
0 g
s
.619 .519 .719 r
.67214 .56486 m .6275 .58074 L .61951 .5511 L p F P
0 g
s
.722 .524 .623 r
.47053 .68079 m .52946 .68406 L .52953 .71286 L p F P
0 g
s
.68 .49 .623 r
.52946 .68406 m .58831 .6802 L .59014 .70896 L p F P
0 g
s
.68 .49 .623 r
.59014 .70896 m .52953 .71286 L .52946 .68406 L p F P
0 g
s
.611 .496 .698 r
.6275 .58074 m .67214 .56486 L .68231 .59378 L p F P
0 g
s
.611 .496 .698 r
.68231 .59378 m .63447 .61047 L .6275 .58074 L p F P
0 g
s
.768 .673 .758 r
.42341 .48195 m .45615 .49381 L .44668 .52267 L p F P
0 g
s
.768 .673 .758 r
.44668 .52267 m .40945 .50944 L .42341 .48195 L p F P
0 g
s
.633 .564 .759 r
.64747 .50813 m .61056 .52178 L .6007 .493 L p F P
0 g
s
.627 .542 .739 r
.61056 .52178 m .64747 .50813 L .6605 .53623 L p F P
0 g
s
.789 .64 .697 r
.4237 .61157 m .37549 .59539 L .3854 .56639 L p F P
0 g
s
.794 .628 .675 r
.37549 .59539 m .4237 .61157 L .41805 .64121 L p F P
0 g
s
.711 .651 .788 r
.50225 .44377 m .52809 .44542 L .52832 .47392 L p F P
0 g
s
.711 .651 .788 r
.52832 .47392 m .49677 .47194 L .50225 .44377 L p F P
0 g
s
.691 .635 .789 r
.55983 .47158 m .52832 .47392 L .52809 .44542 L p F P
0 g
s
.603 .472 .675 r
.63447 .61047 m .68231 .59378 L .6909 .62278 L p F P
0 g
s
.603 .472 .675 r
.6909 .62278 m .64035 .64008 L .63447 .61047 L p F P
0 g
s
.761 .577 .648 r
.47053 .68079 m .4135 .67047 L .41805 .64121 L p F P
0 g
s
.762 .56 .623 r
.4135 .67047 m .47053 .68079 L .46885 .70955 L p F P
0 g
s
.722 .524 .623 r
.52953 .71286 m .46885 .70955 L .47053 .68079 L p F P
0 g
s
.634 .456 .624 r
.58831 .6802 m .6451 .66931 L .64865 .69795 L p F P
0 g
s
.634 .456 .624 r
.64865 .69795 m .59014 .70896 L .58831 .6802 L p F P
0 g
s
.759 .682 .778 r
.43851 .45541 m .46642 .4657 L .45615 .49381 L p F P
0 g
s
.759 .682 .778 r
.45615 .49381 m .42341 .48195 L .43851 .45541 L p F P
0 g
s
.73 .67 .791 r
.47742 .43858 m .50225 .44377 L .49677 .47194 L p F P
0 g
s
.73 .67 .791 r
.49677 .47194 m .46642 .4657 L .47742 .43858 L p F P
0 g
s
.691 .635 .789 r
.52809 .44542 m .55389 .44347 L .55983 .47158 L p F P
0 g
s
.669 .621 .792 r
.59003 .465 m .55983 .47158 L .55389 .44347 L p F P
0 g
s
.667 .601 .772 r
.55983 .47158 m .59003 .465 L .6007 .493 L p F P
0 g
s
.64 .586 .778 r
.63317 .48078 m .6007 .493 L .59003 .465 L p F P
0 g
s
.633 .564 .759 r
.6007 .493 m .63317 .48078 L .64747 .50813 L p F P
0 g
s
.794 .628 .675 r
.41805 .64121 m .36712 .62445 L .37549 .59539 L p F P
0 g
s
.799 .614 .651 r
.36712 .62445 m .41805 .64121 L .4135 .67047 L p F P
0 g
s
.593 .446 .651 r
.64035 .64008 m .6909 .62278 L .69783 .65161 L p F P
0 g
s
.593 .446 .651 r
.69783 .65161 m .6451 .66931 L .64035 .64008 L p F P
0 g
s
.72 .504 .596 r
.46885 .70955 m .52953 .71286 L .52958 .74066 L p F P
0 g
s
.675 .467 .596 r
.52953 .71286 m .59014 .70896 L .59133 .73676 L p F P
0 g
s
.675 .467 .596 r
.59133 .73676 m .52958 .74066 L .52953 .71286 L p F P
0 g
s
.748 .691 .797 r
.45465 .43004 m .47742 .43858 L .46642 .4657 L p F P
0 g
s
.748 .691 .797 r
.46642 .4657 m .43851 .45541 L .45465 .43004 L p F P
0 g
s
.669 .621 .792 r
.55389 .44347 m .57859 .438 L .59003 .465 L p F P
0 g
s
.647 .609 .798 r
.61769 .45439 m .59003 .465 L .57859 .438 L p F P
0 g
s
.64 .586 .778 r
.59003 .465 m .61769 .45439 L .63317 .48078 L p F P
0 g
s
.802 .696 .748 r
.3768 .49138 m .40945 .50944 L .39675 .53766 L p F P
0 g
s
.802 .696 .748 r
.39675 .53766 m .36038 .51795 L .3768 .49138 L p F P
0 g
s
.813 .688 .727 r
.36038 .51795 m .39675 .53766 L .3854 .56639 L p F P
0 g
s
.706 .667 .809 r
.50805 .41671 m .52785 .41799 L .52809 .44542 L p F P
0 g
s
.706 .667 .809 r
.52809 .44542 m .50225 .44377 L .50805 .41671 L p F P
0 g
s
.689 .653 .809 r
.55389 .44347 m .52809 .44542 L .52785 .41799 L p F P
0 g
s
.762 .56 .623 r
.46885 .70955 m .4101 .69912 L .4135 .67047 L p F P
0 g
s
.763 .541 .596 r
.4101 .69912 m .46885 .70955 L .46776 .73735 L p F P
0 g
s
.72 .504 .596 r
.52958 .74066 m .46776 .73735 L .46885 .70955 L p F P
0 g
s
.791 .703 .768 r
.39479 .4658 m .42341 .48195 L .40945 .50944 L p F P
0 g
s
.791 .703 .768 r
.40945 .50944 m .3768 .49138 L .39479 .4658 L p F P
0 g
s
.627 .43 .596 r
.59014 .70896 m .64865 .69795 L .65096 .72574 L p F P
0 g
s
.627 .43 .596 r
.65096 .72574 m .59133 .73676 L .59014 .70896 L p F P
0 g
s
.589 .524 .749 r
.6964 .5161 m .6605 .53623 L .64747 .50813 L p F P
0 g
s
.578 .497 .728 r
.6605 .53623 m .6964 .5161 L .71136 .54332 L p F P
0 g
s
.578 .497 .728 r
.71136 .54332 m .67214 .56486 L .6605 .53623 L p F P
0 g
s
.722 .683 .812 r
.48907 .41268 m .50805 .41671 L .50225 .44377 L p F P
0 g
s
.722 .683 .812 r
.50225 .44377 m .47742 .43858 L .48907 .41268 L p F P
0 g
s
.601 .549 .769 r
.6797 .48969 m .64747 .50813 L .63317 .48078 L p F P
0 g
s
.589 .524 .749 r
.64747 .50813 m .6797 .48969 L .6964 .5161 L p F P
0 g
s
.813 .688 .727 r
.3854 .56639 m .34568 .54529 L .36038 .51795 L p F P
0 g
s
.822 .679 .705 r
.34568 .54529 m .3854 .56639 L .37549 .59539 L p F P
0 g
s
.689 .653 .809 r
.52785 .41799 m .5476 .41648 L .55389 .44347 L p F P
0 g
s
.671 .642 .812 r
.57859 .438 m .55389 .44347 L .5476 .41648 L p F P
0 g
s
.799 .614 .651 r
.4135 .67047 m .36037 .65332 L .36712 .62445 L p F P
0 g
s
.803 .598 .625 r
.36037 .65332 m .4135 .67047 L .4101 .69912 L p F P
0 g
s
.779 .71 .787 r
.41421 .44143 m .43851 .45541 L .42341 .48195 L p F P
0 g
s
.779 .71 .787 r
.42341 .48195 m .39479 .4658 L .41421 .44143 L p F P
0 g
s
.583 .419 .625 r
.6451 .66931 m .69783 .65161 L .70303 .68004 L p F P
0 g
s
.583 .419 .625 r
.70303 .68004 m .64865 .69795 L .6451 .66931 L p F P
0 g
s
.565 .47 .706 r
.67214 .56486 m .71136 .54332 L .72445 .57111 L p F P
0 g
s
.565 .47 .706 r
.72445 .57111 m .68231 .59378 L .67214 .56486 L p F P
0 g
s
.612 .575 .788 r
.6614 .4643 m .63317 .48078 L .61769 .45439 L p F P
0 g
s
.601 .549 .769 r
.63317 .48078 m .6614 .4643 L .6797 .48969 L p F P
0 g
s
.822 .679 .705 r
.37549 .59539 m .33283 .57319 L .34568 .54529 L p F P
0 g
s
.831 .668 .681 r
.33283 .57319 m .37549 .59539 L .36712 .62445 L p F P
0 g
s
.736 .7 .817 r
.4717 .40606 m .48907 .41268 L .47742 .43858 L p F P
0 g
s
.736 .7 .817 r
.47742 .43858 m .45465 .43004 L .4717 .40606 L p F P
0 g
s
.671 .642 .812 r
.5476 .41648 m .56649 .41223 L .57859 .438 L p F P
0 g
s
.653 .633 .817 r
.60116 .42919 m .57859 .438 L .56649 .41223 L p F P
0 g
s
.647 .609 .798 r
.57859 .438 m .60116 .42919 L .61769 .45439 L p F P
0 g
s
.552 .441 .682 r
.68231 .59378 m .72445 .57111 L .73553 .59925 L p F P
0 g
s
.552 .441 .682 r
.73553 .59925 m .6909 .62278 L .68231 .59378 L p F P
0 g
s
.765 .715 .806 r
.43491 .41846 m .45465 .43004 L .43851 .45541 L p F P
0 g
s
.765 .715 .806 r
.43851 .45541 m .41421 .44143 L .43491 .41846 L p F P
0 g
s
.717 .48 .567 r
.46776 .73735 m .52958 .74066 L .52961 .76721 L p F P
0 g
s
.669 .442 .567 r
.52958 .74066 m .59133 .73676 L .59186 .76336 L p F P
0 g
s
.669 .442 .567 r
.59186 .76336 m .52961 .76721 L .52958 .74066 L p F P
0 g
s
.623 .6 .807 r
.64165 .44012 m .61769 .45439 L .60116 .42919 L p F P
0 g
s
.612 .575 .788 r
.61769 .45439 m .64165 .44012 L .6614 .4643 L p F P
0 g
s
.803 .598 .625 r
.4101 .69912 m .35531 .68177 L .36037 .65332 L p F P
0 g
s
.806 .58 .595 r
.35531 .68177 m .4101 .69912 L .40789 .72691 L p F P
0 g
s
.763 .541 .596 r
.46776 .73735 m .40789 .72691 L .4101 .69912 L p F P
0 g
s
.762 .519 .565 r
.40789 .72691 m .46776 .73735 L .46728 .76394 L p F P
0 g
s
.717 .48 .567 r
.52961 .76721 m .46728 .76394 L .46776 .73735 L p F P
0 g
s
.831 .668 .681 r
.36712 .62445 m .32195 .60141 L .33283 .57319 L p F P
0 g
s
.839 .656 .655 r
.32195 .60141 m .36712 .62445 L .36037 .65332 L p F P
0 g
s
.7 .683 .831 r
.51415 .391 m .52759 .39189 L .52785 .41799 L p F P
0 g
s
.7 .683 .831 r
.52785 .41799 m .50805 .41671 L .51415 .391 L p F P
0 g
s
.687 .673 .831 r
.5476 .41648 m .52785 .41799 L .52759 .39189 L p F P
0 g
s
.617 .401 .565 r
.59133 .73676 m .65096 .72574 L .65198 .75244 L p F P
0 g
s
.617 .401 .565 r
.65198 .75244 m .59186 .76336 L .59133 .73676 L p F P
0 g
s
.571 .388 .595 r
.64865 .69795 m .70303 .68004 L .70641 .70781 L p F P
0 g
s
.571 .388 .595 r
.70641 .70781 m .65096 .72574 L .64865 .69795 L p F P
0 g
s
.712 .695 .833 r
.50128 .38823 m .51415 .391 L .50805 .41671 L p F P
0 g
s
.712 .695 .833 r
.50805 .41671 m .48907 .41268 L .50128 .38823 L p F P
0 g
s
.537 .41 .655 r
.6909 .62278 m .73553 .59925 L .74449 .6275 L p F P
0 g
s
.537 .41 .655 r
.74449 .6275 m .69783 .65161 L .6909 .62278 L p F P
0 g
s
.687 .673 .831 r
.52759 .39189 m .541 .39085 L .5476 .41648 L p F P
0 g
s
.673 .664 .833 r
.56649 .41223 m .5476 .41648 L .541 .39085 L p F P
0 g
s
.749 .72 .825 r
.45672 .3971 m .4717 .40606 L .45465 .43004 L p F P
0 g
s
.749 .72 .825 r
.45465 .43004 m .43491 .41846 L .45672 .3971 L p F P
0 g
s
.653 .633 .817 r
.56649 .41223 m .5837 .4054 L .60116 .42919 L p F P
0 g
s
.634 .626 .825 r
.62061 .41738 m .60116 .42919 L .5837 .4054 L p F P
0 g
s
.623 .6 .807 r
.60116 .42919 m .62061 .41738 L .64165 .44012 L p F P
0 g
s
.722 .709 .837 r
.48954 .38369 m .50128 .38823 L .48907 .41268 L p F P
0 g
s
.722 .709 .837 r
.48907 .41268 m .4717 .40606 L .48954 .38369 L p F P
0 g
s
.673 .664 .833 r
.541 .39085 m .5538 .38792 L .56649 .41223 L p F P
0 g
s
.659 .658 .837 r
.5837 .4054 m .56649 .41223 L .5538 .38792 L p F P
0 g
s
.813 .738 .781 r
.3716 .4459 m .39479 .4658 L .3768 .49138 L p F P
0 g
s
.813 .738 .781 r
.3768 .49138 m .35018 .46906 L .3716 .4459 L p F P
0 g
s
.829 .735 .761 r
.35018 .46906 m .3768 .49138 L .36038 .51795 L p F P
0 g
s
.797 .74 .8 r
.39464 .42425 m .41421 .44143 L .39479 .4658 L p F P
0 g
s
.797 .74 .8 r
.39479 .4658 m .3716 .4459 L .39464 .42425 L p F P
0 g
s
.829 .735 .761 r
.36038 .51795 m .33058 .49353 L .35018 .46906 L p F P
0 g
s
.843 .73 .74 r
.33058 .49353 m .36038 .51795 L .34568 .54529 L p F P
0 g
s
.564 .537 .783 r
.70578 .46705 m .6797 .48969 L .6614 .4643 L p F P
0 g
s
.547 .507 .762 r
.6797 .48969 m .70578 .46705 L .72561 .49133 L p F P
0 g
s
.547 .507 .762 r
.72561 .49133 m .6964 .5161 L .6797 .48969 L p F P
0 g
s
.581 .566 .801 r
.68411 .44412 m .6614 .4643 L .64165 .44012 L p F P
0 g
s
.564 .537 .783 r
.6614 .4643 m .68411 .44412 L .70578 .46705 L p F P
0 g
s
.839 .656 .655 r
.36037 .65332 m .31316 .62972 L .32195 .60141 L p F P
0 g
s
.846 .642 .626 r
.31316 .62972 m .36037 .65332 L .35531 .68177 L p F P
0 g
s
.779 .741 .818 r
.41912 .40428 m .43491 .41846 L .41421 .44143 L p F P
0 g
s
.779 .741 .818 r
.41421 .44143 m .39464 .42425 L .41912 .40428 L p F P
0 g
s
.529 .476 .741 r
.6964 .5161 m .72561 .49133 L .74343 .51674 L p F P
0 g
s
.529 .476 .741 r
.74343 .51674 m .71136 .54332 L .6964 .5161 L p F P
0 g
s
.712 .454 .533 r
.46728 .76394 m .52961 .76721 L .52961 .79228 L p F P
0 g
s
.662 .413 .533 r
.52961 .76721 m .59186 .76336 L .59171 .7885 L p F P
0 g
s
.662 .413 .533 r
.59171 .7885 m .52961 .79228 L .52961 .76721 L p F P
0 g
s
.597 .594 .819 r
.6608 .42271 m .64165 .44012 L .62061 .41738 L p F P
0 g
s
.581 .566 .801 r
.64165 .44012 m .6608 .42271 L .68411 .44412 L p F P
0 g
s
.52 .377 .626 r
.69783 .65161 m .74449 .6275 L .75121 .65563 L p F P
0 g
s
.52 .377 .626 r
.75121 .65563 m .70303 .68004 L .69783 .65161 L p F P
0 g
s
.843 .73 .74 r
.34568 .54529 m .31299 .51911 L .33058 .49353 L p F P
0 g
s
.856 .724 .716 r
.31299 .51911 m .34568 .54529 L .33283 .57319 L p F P
0 g
s
.732 .724 .843 r
.47947 .37755 m .48954 .38369 L .4717 .40606 L p F P
0 g
s
.732 .724 .843 r
.4717 .40606 m .45672 .3971 L .47947 .37755 L p F P
0 g
s
.806 .58 .595 r
.40789 .72691 m .35203 .70954 L .35531 .68177 L p F P
0 g
s
.809 .559 .562 r
.35203 .70954 m .40789 .72691 L .40692 .7536 L p F P
0 g
s
.762 .519 .565 r
.46728 .76394 m .40692 .7536 L .40789 .72691 L p F P
0 g
s
.659 .658 .837 r
.5538 .38792 m .56543 .38324 L .5837 .4054 L p F P
0 g
s
.645 .653 .844 r
.59846 .39627 m .5837 .4054 L .56543 .38324 L p F P
0 g
s
.634 .626 .825 r
.5837 .4054 m .59846 .39627 L .62061 .41738 L p F P
0 g
s
.556 .354 .561 r
.65096 .72574 m .70641 .70781 L .70791 .73468 L p F P
0 g
s
.556 .354 .561 r
.70791 .73468 m .65198 .75244 L .65096 .72574 L p F P
0 g
s
.51 .443 .717 r
.71136 .54332 m .74343 .51674 L .75905 .54308 L p F P
0 g
s
.51 .443 .717 r
.75905 .54308 m .72445 .57111 L .71136 .54332 L p F P
0 g
s
.76 .741 .835 r
.44481 .38617 m .45672 .3971 L .43491 .41846 L p F P
0 g
s
.76 .741 .835 r
.43491 .41846 m .41912 .40428 L .44481 .38617 L p F P
0 g
s
.76 .493 .53 r
.40692 .7536 m .46728 .76394 L .46744 .78907 L p F P
0 g
s
.712 .454 .533 r
.52961 .79228 m .46744 .78907 L .46728 .76394 L p F P
0 g
s
.614 .623 .836 r
.63606 .40301 m .62061 .41738 L .59846 .39627 L p F P
0 g
s
.597 .594 .819 r
.62061 .41738 m .63606 .40301 L .6608 .42271 L p F P
0 g
s
.606 .368 .529 r
.59186 .76336 m .65198 .75244 L .65168 .77779 L p F P
0 g
s
.606 .368 .529 r
.65168 .77779 m .59171 .7885 L .59186 .76336 L p F P
0 g
s
.691 .7 .854 r
.5205 .3669 m .52732 .36736 L .52759 .39189 L p F P
0 g
s
.691 .7 .854 r
.52759 .39189 m .51415 .391 L .5205 .3669 L p F P
0 g
s
.683 .693 .854 r
.541 .39085 m .52759 .39189 L .52732 .36736 L p F P
0 g
s
.699 .708 .855 r
.51397 .36548 m .5205 .3669 L .51415 .391 L p F P
0 g
s
.699 .708 .855 r
.51415 .391 m .50128 .38823 L .51397 .36548 L p F P
0 g
s
.683 .693 .854 r
.52732 .36736 m .53413 .36682 L .541 .39085 L p F P
0 g
s
.674 .688 .855 r
.5538 .38792 m .541 .39085 L .53413 .36682 L p F P
0 g
s
.856 .724 .716 r
.33283 .57319 m .29757 .54557 L .31299 .51911 L p F P
0 g
s
.869 .716 .69 r
.29757 .54557 m .33283 .57319 L .32195 .60141 L p F P
0 g
s
.705 .717 .858 r
.50804 .36315 m .51397 .36548 L .50128 .38823 L p F P
0 g
s
.705 .717 .858 r
.50128 .38823 m .48954 .38369 L .50804 .36315 L p F P
0 g
s
.674 .688 .855 r
.53413 .36682 m .54062 .36532 L .5538 .38792 L p F P
0 g
s
.665 .684 .858 r
.56543 .38324 m .5538 .38792 L .54062 .36532 L p F P
0 g
s
.846 .642 .626 r
.35531 .68177 m .30657 .65787 L .31316 .62972 L p F P
0 g
s
.853 .625 .593 r
.30657 .65787 m .35531 .68177 L .35203 .70954 L p F P
0 g
s
.489 .407 .691 r
.72445 .57111 m .75905 .54308 L .7723 .57012 L p F P
0 g
s
.489 .407 .691 r
.7723 .57012 m .73553 .59925 L .72445 .57111 L p F P
0 g
s
.739 .739 .852 r
.47152 .3701 m .47947 .37755 L .45672 .3971 L p F P
0 g
s
.739 .739 .852 r
.45672 .3971 m .44481 .38617 L .47152 .3701 L p F P
0 g
s
.645 .653 .844 r
.56543 .38324 m .57535 .37699 L .59846 .39627 L p F P
0 g
s
.63 .652 .853 r
.61009 .38519 m .59846 .39627 L .57535 .37699 L p F P
0 g
s
.614 .623 .836 r
.59846 .39627 m .61009 .38519 L .63606 .40301 L p F P
0 g
s
.502 .339 .593 r
.70303 .68004 m .75121 .65563 L .75558 .68337 L p F P
0 g
s
.502 .339 .593 r
.75558 .68337 m .70641 .70781 L .70303 .68004 L p F P
0 g
s
.711 .726 .862 r
.50297 .36001 m .50804 .36315 L .48954 .38369 L p F P
0 g
s
.711 .726 .862 r
.48954 .38369 m .47947 .37755 L .50297 .36001 L p F P
0 g
s
.665 .684 .858 r
.54062 .36532 m .54649 .36292 L .56543 .38324 L p F P
0 g
s
.656 .682 .863 r
.57535 .37699 m .56543 .38324 L .54649 .36292 L p F P
0 g
s
.869 .716 .69 r
.32195 .60141 m .28449 .57271 L .29757 .54557 L p F P
0 g
s
.881 .706 .66 r
.28449 .57271 m .32195 .60141 L .31316 .62972 L p F P
0 g
s
.791 .77 .834 r
.40804 .38805 m .41912 .40428 L .39464 .42425 L p F P
0 g
s
.791 .77 .834 r
.39464 .42425 m .38077 .40452 L .40804 .38805 L p F P
0 g
s
.813 .775 .817 r
.38077 .40452 m .39464 .42425 L .3716 .4459 L p F P
0 g
s
.813 .775 .817 r
.3716 .4459 m .35499 .42297 L .38077 .40452 L p F P
0 g
s
.833 .778 .799 r
.35499 .42297 m .3716 .4459 L .35018 .46906 L p F P
0 g
s
.809 .559 .562 r
.40692 .7536 m .35059 .73639 L .35203 .70954 L p F P
0 g
s
.809 .534 .522 r
.35059 .73639 m .40692 .7536 L .40722 .77893 L p F P
0 g
s
.76 .493 .53 r
.46744 .78907 m .40722 .77893 L .40692 .7536 L p F P
0 g
s
.706 .422 .492 r
.46744 .78907 m .52961 .79228 L .52959 .8156 L p F P
0 g
s
.652 .378 .492 r
.52961 .79228 m .59171 .7885 L .59085 .81192 L p F P
0 g
s
.652 .378 .492 r
.59085 .81192 m .52959 .8156 L .52961 .79228 L p F P
0 g
s
.465 .368 .661 r
.73553 .59925 m .7723 .57012 L .78303 .59762 L p F P
0 g
s
.465 .368 .661 r
.78303 .59762 m .74449 .6275 L .73553 .59925 L p F P
0 g
s
.571 .592 .835 r
.67418 .4028 m .6608 .42271 L .63606 .40301 L p F P
0 g
s
.547 .56 .819 r
.6608 .42271 m .67418 .4028 L .70015 .42098 L p F P
0 g
s
.547 .56 .819 r
.70015 .42098 m .68411 .44412 L .6608 .42271 L p F P
0 g
s
.768 .764 .849 r
.43657 .37372 m .44481 .38617 L .41912 .40428 L p F P
0 g
s
.768 .764 .849 r
.41912 .40428 m .40804 .38805 L .43657 .37372 L p F P
0 g
s
.539 .314 .522 r
.65198 .75244 m .70791 .73468 L .70746 .76037 L p F P
0 g
s
.539 .314 .522 r
.70746 .76037 m .65168 .77779 L .65198 .75244 L p F P
0 g
s
.523 .527 .801 r
.68411 .44412 m .70015 .42098 L .72438 .44101 L p F P
0 g
s
.523 .527 .801 r
.72438 .44101 m .70578 .46705 L .68411 .44412 L p F P
0 g
s
.833 .778 .799 r
.35018 .46906 m .33094 .44326 L .35499 .42297 L p F P
0 g
s
.853 .78 .779 r
.33094 .44326 m .35018 .46906 L .33058 .49353 L p F P
0 g
s
.594 .622 .85 r
.64672 .38665 m .63606 .40301 L .61009 .38519 L p F P
0 g
s
.571 .592 .835 r
.63606 .40301 m .64672 .38665 L .67418 .4028 L p F P
0 g
s
.715 .736 .868 r
.49901 .35621 m .50297 .36001 L .47947 .37755 L p F P
0 g
s
.715 .736 .868 r
.47947 .37755 m .47152 .3701 L .49901 .35621 L p F P
0 g
s
.656 .682 .863 r
.54649 .36292 m .55148 .35972 L .57535 .37699 L p F P
0 g
s
.647 .681 .869 r
.58311 .36943 m .57535 .37699 L .55148 .35972 L p F P
0 g
s
.63 .652 .853 r
.57535 .37699 m .58311 .36943 L .61009 .38519 L p F P
0 g
s
.497 .491 .781 r
.70578 .46705 m .72438 .44101 L .74663 .46274 L p F P
0 g
s
.497 .491 .781 r
.74663 .46274 m .72561 .49133 L .70578 .46705 L p F P
0 g
s
.756 .463 .487 r
.40722 .77893 m .46744 .78907 L .46824 .81248 L p F P
0 g
s
.706 .422 .492 r
.52959 .8156 m .46824 .81248 L .46744 .78907 L p F P
0 g
s
.744 .756 .862 r
.46608 .36163 m .47152 .3701 L .44481 .38617 L p F P
0 g
s
.744 .756 .862 r
.44481 .38617 m .43657 .37372 L .46608 .36163 L p F P
0 g
s
.592 .329 .487 r
.59171 .7885 m .65168 .77779 L .65001 .80153 L p F P
0 g
s
.592 .329 .487 r
.65001 .80153 m .59085 .81192 L .59171 .7885 L p F P
0 g
s
.616 .653 .863 r
.61802 .37264 m .61009 .38519 L .58311 .36943 L p F P
0 g
s
.594 .622 .85 r
.61009 .38519 m .61802 .37264 L .64672 .38665 L p F P
0 g
s
.853 .625 .593 r
.35203 .70954 m .30229 .68562 L .30657 .65787 L p F P
0 g
s
.858 .604 .554 r
.30229 .68562 m .35203 .70954 L .35059 .73639 L p F P
0 g
s
.853 .78 .779 r
.33058 .49353 m .30886 .46522 L .33094 .44326 L p F P
0 g
s
.872 .78 .756 r
.30886 .46522 m .33058 .49353 L .31299 .51911 L p F P
0 g
s
.68 .718 .878 r
.52732 .36736 m .5205 .3669 L .52705 .34466 L closepath p F P
0 g
s
.677 .716 .878 r
.53413 .36682 m .52732 .36736 L .52705 .34466 L closepath p F P
0 g
s
.682 .721 .879 r
.5205 .3669 m .51397 .36548 L .52705 .34466 L closepath p F P
0 g
s
.673 .714 .879 r
.54062 .36532 m .53413 .36682 L .52705 .34466 L closepath p F P
0 g
s
.48 .296 .554 r
.70641 .70781 m .75558 .68337 L .75751 .71045 L p F P
0 g
s
.48 .296 .554 r
.75751 .71045 m .70791 .73468 L .70641 .70781 L p F P
0 g
s
.685 .724 .88 r
.51397 .36548 m .50804 .36315 L .52705 .34466 L closepath p F P
0 g
s
.881 .706 .66 r
.31316 .62972 m .2739 .60028 L .28449 .57271 L p F P
0 g
s
.893 .693 .626 r
.2739 .60028 m .31316 .62972 L .30657 .65787 L p F P
0 g
s
.67 .713 .88 r
.54649 .36292 m .54062 .36532 L .52705 .34466 L closepath p F P
0 g
s
.47 .454 .758 r
.72561 .49133 m .74663 .46274 L .76668 .486 L p F P
0 g
s
.47 .454 .758 r
.76668 .486 m .74343 .51674 L .72561 .49133 L p F P
0 g
s
.717 .746 .875 r
.49633 .35191 m .49901 .35621 L .47152 .3701 L p F P
0 g
s
.717 .746 .875 r
.47152 .3701 m .46608 .36163 L .49633 .35191 L p F P
0 g
s
.686 .728 .882 r
.50804 .36315 m .50297 .36001 L .52705 .34466 L closepath p F P
0 g
s
.647 .681 .869 r
.55148 .35972 m .55535 .35587 L .58311 .36943 L p F P
0 g
s
.638 .683 .875 r
.58833 .3609 m .58311 .36943 L .55535 .35587 L p F P
0 g
s
.616 .653 .863 r
.58311 .36943 m .58833 .3609 L .61802 .37264 L p F P
0 g
s
.667 .712 .882 r
.55148 .35972 m .54649 .36292 L .52705 .34466 L closepath p F P
0 g
s
.439 .325 .627 r
.74449 .6275 m .78303 .59762 L .79108 .62533 L p F P
0 g
s
.439 .325 .627 r
.79108 .62533 m .75121 .65563 L .74449 .6275 L p F P
0 g
s
.872 .78 .756 r
.31299 .51911 m .28898 .48866 L .30886 .46522 L p F P
0 g
s
.891 .778 .731 r
.28898 .48866 m .31299 .51911 L .29757 .54557 L p F P
0 g
s
.688 .731 .884 r
.50297 .36001 m .49901 .35621 L .52705 .34466 L closepath p F P
0 g
s
.664 .712 .884 r
.55535 .35587 m .55148 .35972 L .52705 .34466 L closepath p F P
0 g
s
.439 .412 .732 r
.74343 .51674 m .76668 .486 L .7843 .51057 L p F P
0 g
s
.439 .412 .732 r
.7843 .51057 m .75905 .54308 L .74343 .51674 L p F P
0 g
s
.745 .772 .875 r
.46344 .35254 m .46608 .36163 L .43657 .37372 L p F P
0 g
s
.745 .772 .875 r
.43657 .37372 m .43243 .36027 L .46344 .35254 L p F P
0 g
s
.772 .787 .865 r
.43243 .36027 m .43657 .37372 L .40804 .38805 L p F P
0 g
s
.772 .787 .865 r
.40804 .38805 m .40232 .37047 L .43243 .36027 L p F P
0 g
s
.798 .8 .853 r
.40232 .37047 m .40804 .38805 L .38077 .40452 L p F P
0 g
s
.809 .534 .522 r
.40722 .77893 m .35104 .76205 L .35059 .73639 L p F P
0 g
s
.807 .504 .476 r
.35104 .76205 m .40722 .77893 L .40884 .80264 L p F P
0 g
s
.756 .463 .487 r
.46824 .81248 m .40884 .80264 L .40722 .77893 L p F P
0 g
s
.688 .735 .886 r
.49901 .35621 m .49633 .35191 L .52705 .34466 L closepath p F P
0 g
s
.661 .713 .886 r
.55792 .35154 m .55535 .35587 L .52705 .34466 L closepath p F P
0 g
s
.638 .683 .875 r
.55535 .35587 m .55792 .35154 L .58833 .3609 L p F P
0 g
s
.603 .657 .876 r
.62182 .35914 m .61802 .37264 L .58833 .3609 L p F P
0 g
s
.573 .626 .866 r
.61802 .37264 m .62182 .35914 L .652 .36898 L p F P
0 g
s
.573 .626 .866 r
.652 .36898 m .64672 .38665 L .61802 .37264 L p F P
0 g
s
.717 .756 .883 r
.49508 .34732 m .49633 .35191 L .46608 .36163 L p F P
0 g
s
.717 .756 .883 r
.46608 .36163 m .46344 .35254 L .49508 .34732 L p F P
0 g
s
.543 .593 .855 r
.64672 .38665 m .652 .36898 L .681 .38123 L p F P
0 g
s
.543 .593 .855 r
.681 .38123 m .67418 .4028 L .64672 .38665 L p F P
0 g
s
.518 .268 .474 r
.65168 .77779 m .70746 .76037 L .70501 .78462 L p F P
0 g
s
.518 .268 .474 r
.70501 .78462 m .65001 .80153 L .65168 .77779 L p F P
0 g
s
.631 .686 .883 r
.59074 .35177 m .58833 .3609 L .55792 .35154 L p F P
0 g
s
.603 .657 .876 r
.58833 .3609 m .59074 .35177 L .62182 .35914 L p F P
0 g
s
.798 .8 .853 r
.38077 .40452 m .3734 .38305 L .40232 .37047 L p F P
0 g
s
.824 .812 .839 r
.3734 .38305 m .38077 .40452 L .35499 .42297 L p F P
0 g
s
.696 .384 .444 r
.46824 .81248 m .52959 .8156 L .52953 .8369 L p F P
0 g
s
.638 .337 .443 r
.52959 .8156 m .59085 .81192 L .58928 .83337 L p F P
0 g
s
.638 .337 .443 r
.58928 .83337 m .52953 .8369 L .52959 .8156 L p F P
0 g
s
.893 .693 .626 r
.30657 .65787 m .26596 .62803 L .2739 .60028 L p F P
0 g
s
.903 .677 .587 r
.26596 .62803 m .30657 .65787 L .30229 .68562 L p F P
0 g
s
.891 .778 .731 r
.29757 .54557 m .2715 .5134 L .28898 .48866 L p F P
0 g
s
.909 .774 .701 r
.2715 .5134 m .29757 .54557 L .28449 .57271 L p F P
0 g
s
.51 .558 .841 r
.67418 .4028 m .681 .38123 L .70854 .39579 L p F P
0 g
s
.51 .558 .841 r
.70854 .39579 m .70015 .42098 L .67418 .4028 L p F P
0 g
s
.858 .604 .554 r
.35059 .73639 m .3004 .71268 L .30229 .68562 L p F P
0 g
s
.861 .578 .509 r
.3004 .71268 m .35059 .73639 L .35104 .76205 L p F P
0 g
s
.688 .738 .889 r
.49633 .35191 m .49508 .34732 L .52705 .34466 L closepath p F P
0 g
s
.659 .714 .889 r
.55905 .34693 m .55792 .35154 L .52705 .34466 L closepath p F P
0 g
s
.631 .686 .883 r
.55792 .35154 m .55905 .34693 L .59074 .35177 L p F P
0 g
s
.409 .276 .586 r
.75121 .65563 m .79108 .62533 L .79633 .653 L p F P
0 g
s
.409 .276 .586 r
.79633 .653 m .75558 .68337 L .75121 .65563 L p F P
0 g
s
.824 .812 .839 r
.35499 .42297 m .34595 .39792 L .3734 .38305 L p F P
0 g
s
.849 .822 .822 r
.34595 .39792 m .35499 .42297 L .33094 .44326 L p F P
0 g
s
.406 .366 .702 r
.75905 .54308 m .7843 .51057 L .79929 .53626 L p F P
0 g
s
.406 .366 .702 r
.79929 .53626 m .7723 .57012 L .75905 .54308 L p F P
0 g
s
.454 .246 .507 r
.70791 .73468 m .75751 .71045 L .75693 .73662 L p F P
0 g
s
.454 .246 .507 r
.75693 .73662 m .70746 .76037 L .70791 .73468 L p F P
0 g
s
.749 .425 .436 r
.40884 .80264 m .46824 .81248 L .4697 .83391 L p F P
0 g
s
.696 .384 .444 r
.52953 .8369 m .4697 .83391 L .46824 .81248 L p F P
0 g
s
.573 .281 .435 r
.59085 .81192 m .65001 .80153 L .64695 .82339 L p F P
0 g
s
.573 .281 .435 r
.64695 .82339 m .58928 .83337 L .59085 .81192 L p F P
0 g
s
.475 .52 .824 r
.70015 .42098 m .70854 .39579 L .73434 .41256 L p F P
0 g
s
.475 .52 .824 r
.73434 .41256 m .72438 .44101 L .70015 .42098 L p F P
0 g
s
.687 .74 .892 r
.49508 .34732 m .49531 .34264 L .52705 .34466 L closepath p F P
0 g
s
.715 .764 .891 r
.49531 .34264 m .49508 .34732 L .46344 .35254 L p F P
0 g
s
.657 .716 .892 r
.5587 .34226 m .55905 .34693 L .52705 .34466 L closepath p F P
0 g
s
.625 .691 .892 r
.55905 .34693 m .5587 .34226 L .59018 .34246 L p F P
0 g
s
.625 .691 .892 r
.59018 .34246 m .59074 .35177 L .55905 .34693 L p F P
0 g
s
.656 .719 .895 r
.55685 .33773 m .5587 .34226 L .52705 .34466 L closepath p F P
0 g
s
.656 .722 .898 r
.55359 .33357 m .55685 .33773 L .52705 .34466 L closepath p F P
0 g
s
.685 .742 .895 r
.49531 .34264 m .49704 .33809 L .52705 .34466 L closepath p F P
0 g
s
.656 .725 .9 r
.54907 .32998 m .55359 .33357 L .52705 .34466 L closepath p F P
0 g
s
.657 .729 .902 r
.5435 .32713 m .54907 .32998 L .52705 .34466 L closepath p F P
0 g
s
.659 .733 .904 r
.53713 .32516 m .5435 .32713 L .52705 .34466 L closepath p F P
0 g
s
.662 .736 .905 r
.53027 .32417 m .53713 .32516 L .52705 .34466 L closepath p F P
0 g
s
.665 .739 .905 r
.52326 .32421 m .53027 .32417 L .52705 .34466 L closepath p F P
0 g
s
.669 .741 .905 r
.51643 .32528 m .52326 .32421 L .52705 .34466 L closepath p F P
0 g
s
.673 .743 .904 r
.51012 .32733 m .51643 .32528 L .52705 .34466 L closepath p F P
0 g
s
.676 .744 .902 r
.50462 .33025 m .51012 .32733 L .52705 .34466 L closepath p F P
0 g
s
.68 .744 .9 r
.50019 .33389 m .50462 .33025 L .52705 .34466 L closepath p F P
0 g
s
.683 .744 .897 r
.49704 .33809 m .50019 .33389 L .52705 .34466 L closepath p F P
0 g
s
.715 .764 .891 r
.46344 .35254 m .46376 .34323 L .49531 .34264 L p F P
0 g
s
.743 .787 .888 r
.46376 .34323 m .46344 .35254 L .43243 .36027 L p F P
0 g
s
.591 .664 .89 r
.59074 .35177 m .59018 .34246 L .62121 .34531 L p F P
0 g
s
.591 .664 .89 r
.62121 .34531 m .62182 .35914 L .59074 .35177 L p F P
0 g
s
.849 .822 .822 r
.33094 .44326 m .32025 .41497 L .34595 .39792 L p F P
0 g
s
.874 .831 .802 r
.32025 .41497 m .33094 .44326 L .30886 .46522 L p F P
0 g
s
.743 .787 .888 r
.43243 .36027 m .43268 .34645 L .46376 .34323 L p F P
0 g
s
.771 .809 .883 r
.43268 .34645 m .43243 .36027 L .40232 .37047 L p F P
0 g
s
.909 .774 .701 r
.28449 .57271 m .25665 .5392 L .2715 .5134 L p F P
0 g
s
.926 .767 .665 r
.25665 .5392 m .28449 .57271 L .2739 .60028 L p F P
0 g
s
.711 .771 .9 r
.49704 .33809 m .49531 .34264 L .46376 .34323 L p F P
0 g
s
.436 .477 .804 r
.72438 .44101 m .73434 .41256 L .75813 .43141 L p F P
0 g
s
.436 .477 .804 r
.75813 .43141 m .74663 .46274 L .72438 .44101 L p F P
0 g
s
.621 .699 .901 r
.5587 .34226 m .55685 .33773 L .58664 .33341 L p F P
0 g
s
.621 .699 .901 r
.58664 .33341 m .59018 .34246 L .5587 .34226 L p F P
0 g
s
.554 .634 .885 r
.62182 .35914 m .62121 .34531 L .65149 .3508 L p F P
0 g
s
.554 .634 .885 r
.65149 .3508 m .652 .36898 L .62182 .35914 L p F P
0 g
s
.368 .315 .666 r
.7723 .57012 m .79929 .53626 L .81145 .56282 L p F P
0 g
s
.368 .315 .666 r
.81145 .56282 m .78303 .59762 L .7723 .57012 L p F P
0 g
s
.903 .677 .587 r
.30229 .68562 m .26079 .65571 L .26596 .62803 L p F P
0 g
s
.911 .656 .54 r
.26079 .65571 m .30229 .68562 L .3004 .71268 L p F P
0 g
s
.771 .809 .883 r
.40232 .37047 m .40236 .3523 L .43268 .34645 L p F P
0 g
s
.799 .831 .876 r
.40236 .3523 m .40232 .37047 L .3734 .38305 L p F P
0 g
s
.704 .777 .908 r
.50019 .33389 m .49704 .33809 L .46707 .33414 L p F P
0 g
s
.711 .771 .9 r
.46376 .34323 m .46707 .33414 L .49704 .33809 L p F P
0 g
s
.618 .708 .909 r
.55685 .33773 m .55359 .33357 L .58024 .32506 L p F P
0 g
s
.618 .708 .909 r
.58024 .32506 m .58664 .33341 L .55685 .33773 L p F P
0 g
s
.874 .831 .802 r
.30886 .46522 m .29656 .43407 L .32025 .41497 L p F P
0 g
s
.898 .838 .778 r
.29656 .43407 m .30886 .46522 L .28898 .48866 L p F P
0 g
s
.513 .6 .878 r
.652 .36898 m .65149 .3508 L .68072 .35893 L p F P
0 g
s
.513 .6 .878 r
.68072 .35893 m .681 .38123 L .652 .36898 L p F P
0 g
s
.737 .801 .903 r
.46707 .33414 m .46376 .34323 L .43268 .34645 L p F P
0 g
s
.807 .504 .476 r
.40884 .80264 m .35344 .78626 L .35104 .76205 L p F P
0 g
s
.802 .465 .418 r
.35344 .78626 m .40884 .80264 L .4118 .82445 L p F P
0 g
s
.749 .425 .436 r
.4697 .83391 m .4118 .82445 L .40884 .80264 L p F P
0 g
s
.374 .219 .538 r
.75558 .68337 m .79633 .653 L .79865 .68036 L p F P
0 g
s
.374 .219 .538 r
.79865 .68036 m .75751 .71045 L .75558 .68337 L p F P
0 g
s
.581 .675 .904 r
.59018 .34246 m .58664 .33341 L .61614 .3318 L p F P
0 g
s
.581 .675 .904 r
.61614 .3318 m .62121 .34531 L .59018 .34246 L p F P
0 g
s
.491 .211 .416 r
.65001 .80153 m .70501 .78462 L .70053 .80716 L p F P
0 g
s
.491 .211 .416 r
.70053 .80716 m .64695 .82339 L .65001 .80153 L p F P
0 g
s
.861 .578 .509 r
.35104 .76205 m .30099 .7388 L .3004 .71268 L p F P
0 g
s
.861 .546 .453 r
.30099 .7388 m .35104 .76205 L .35344 .78626 L p F P
0 g
s
.393 .43 .78 r
.74663 .46274 m .75813 .43141 L .77963 .45219 L p F P
0 g
s
.393 .43 .78 r
.77963 .45219 m .76668 .486 L .74663 .46274 L p F P
0 g
s
.694 .779 .917 r
.50462 .33025 m .50019 .33389 L .47324 .32571 L p F P
0 g
s
.704 .777 .908 r
.46707 .33414 m .47324 .32571 L .50019 .33389 L p F P
0 g
s
.619 .718 .917 r
.55359 .33357 m .54907 .32998 L .57127 .31781 L p F P
0 g
s
.619 .718 .917 r
.57127 .31781 m .58024 .32506 L .55359 .33357 L p F P
0 g
s
.421 .187 .451 r
.70746 .76037 m .75693 .73662 L .75376 .76158 L p F P
0 g
s
.421 .187 .451 r
.75376 .76158 m .70501 .78462 L .70746 .76037 L p F P
0 g
s
.799 .831 .876 r
.3734 .38305 m .37311 .36077 L .40236 .3523 L p F P
0 g
s
.827 .851 .865 r
.37311 .36077 m .3734 .38305 L .34595 .39792 L p F P
0 g
s
.681 .335 .382 r
.4697 .83391 m .52953 .8369 L .52945 .85593 L p F P
0 g
s
.619 .285 .382 r
.52953 .8369 m .58928 .83337 L .58698 .85258 L p F P
0 g
s
.619 .285 .382 r
.58698 .85258 m .52945 .85593 L .52953 .8369 L p F P
0 g
s
.926 .767 .665 r
.2739 .60028 m .2446 .56585 L .25665 .5392 L p F P
0 g
s
.942 .756 .623 r
.2446 .56585 m .2739 .60028 L .26596 .62803 L p F P
0 g
s
.468 .562 .867 r
.681 .38123 m .68072 .35893 L .70859 .36965 L p F P
0 g
s
.468 .562 .867 r
.70859 .36965 m .70854 .39579 L .681 .38123 L p F P
0 g
s
.683 .779 .923 r
.51012 .32733 m .50462 .33025 L .48203 .31836 L p F P
0 g
s
.694 .779 .917 r
.47324 .32571 m .48203 .31836 L .50462 .33025 L p F P
0 g
s
.622 .73 .924 r
.54907 .32998 m .5435 .32713 L .56012 .31205 L p F P
0 g
s
.622 .73 .924 r
.56012 .31205 m .57127 .31781 L .54907 .32998 L p F P
0 g
s
.737 .801 .903 r
.43268 .34645 m .4374 .33289 L .46707 .33414 L p F P
0 g
s
.763 .83 .904 r
.4374 .33289 m .43268 .34645 L .40236 .3523 L p F P
0 g
s
.536 .647 .905 r
.62121 .34531 m .61614 .3318 L .64505 .33296 L p F P
0 g
s
.536 .647 .905 r
.64505 .33296 m .65149 .3508 L .62121 .34531 L p F P
0 g
s
.898 .838 .778 r
.28898 .48866 m .27515 .45506 L .29656 .43407 L p F P
0 g
s
.922 .843 .748 r
.27515 .45506 m .28898 .48866 L .2715 .5134 L p F P
0 g
s
.325 .255 .623 r
.78303 .59762 m .81145 .56282 L .82059 .59002 L p F P
0 g
s
.325 .255 .623 r
.82059 .59002 m .79108 .62533 L .78303 .59762 L p F P
0 g
s
.725 .811 .918 r
.47324 .32571 m .46707 .33414 L .4374 .33289 L p F P
0 g
s
.737 .378 .371 r
.4118 .82445 m .4697 .83391 L .47184 .85309 L p F P
0 g
s
.681 .335 .382 r
.52945 .85593 m .47184 .85309 L .4697 .83391 L p F P
0 g
s
.671 .776 .929 r
.51643 .32528 m .51012 .32733 L .49302 .31246 L p F P
0 g
s
.683 .779 .923 r
.48203 .31836 m .49302 .31246 L .51012 .32733 L p F P
0 g
s
.628 .741 .929 r
.5435 .32713 m .53713 .32516 L .54734 .30806 L p F P
0 g
s
.628 .741 .929 r
.54734 .30806 m .56012 .31205 L .5435 .32713 L p F P
0 g
s
.574 .689 .919 r
.58664 .33341 m .58024 .32506 L .60675 .31927 L p F P
0 g
s
.574 .689 .919 r
.60675 .31927 m .61614 .3318 L .58664 .33341 L p F P
0 g
s
.547 .223 .37 r
.58928 .83337 m .64695 .82339 L .64249 .84309 L p F P
0 g
s
.547 .223 .37 r
.64249 .84309 m .58698 .85258 L .58928 .83337 L p F P
0 g
s
.659 .771 .932 r
.52326 .32421 m .51643 .32528 L .50569 .30831 L p F P
0 g
s
.671 .776 .929 r
.49302 .31246 m .50569 .30831 L .51643 .32528 L p F P
0 g
s
.636 .753 .932 r
.53713 .32516 m .53027 .32417 L .53354 .30605 L p F P
0 g
s
.636 .753 .932 r
.53354 .30605 m .54734 .30806 L .53713 .32516 L p F P
0 g
s
.345 .376 .75 r
.76668 .486 m .77963 .45219 L .79859 .47474 L p F P
0 g
s
.345 .376 .75 r
.79859 .47474 m .7843 .51057 L .76668 .486 L p F P
0 g
s
.827 .851 .865 r
.34595 .39792 m .34522 .37181 L .37311 .36077 L p F P
0 g
s
.856 .871 .85 r
.34522 .37181 m .34595 .39792 L .32025 .41497 L p F P
0 g
s
.647 .763 .934 r
.53027 .32417 m .52326 .32421 L .51943 .30614 L p F P
0 g
s
.659 .771 .932 r
.50569 .30831 m .51943 .30614 L .52326 .32421 L p F P
0 g
s
.647 .763 .934 r
.51943 .30614 m .53354 .30605 L .53027 .32417 L p F P
0 g
s
.911 .656 .54 r
.3004 .71268 m .25851 .68304 L .26079 .65571 L p F P
0 g
s
.916 .628 .482 r
.25851 .68304 m .3004 .71268 L .30099 .7388 L p F P
0 g
s
.418 .517 .852 r
.70854 .39579 m .70859 .36965 L .73482 .38291 L p F P
0 g
s
.418 .517 .852 r
.73482 .38291 m .73434 .41256 L .70854 .39579 L p F P
0 g
s
.763 .83 .904 r
.40236 .3523 m .40832 .3344 L .4374 .33289 L p F P
0 g
s
.791 .86 .901 r
.40832 .3344 m .40236 .3523 L .37311 .36077 L p F P
0 g
s
.332 .151 .48 r
.75751 .71045 m .79865 .68036 L .79795 .70711 L p F P
0 g
s
.332 .151 .48 r
.79795 .70711 m .75693 .73662 L .75751 .71045 L p F P
0 g
s
.709 .817 .932 r
.48203 .31836 m .47324 .32571 L .44645 .32025 L p F P
0 g
s
.725 .811 .918 r
.4374 .33289 m .44645 .32025 L .47324 .32571 L p F P
0 g
s
.484 .613 .903 r
.65149 .3508 m .64505 .33296 L .67309 .33694 L p F P
0 g
s
.484 .613 .903 r
.67309 .33694 m .68072 .35893 L .65149 .3508 L p F P
0 g
s
.572 .707 .933 r
.58024 .32506 m .57127 .31781 L .59342 .30837 L p F P
0 g
s
.572 .707 .933 r
.59342 .30837 m .60675 .31927 L .58024 .32506 L p F P
0 g
s
.942 .756 .623 r
.26596 .62803 m .23555 .5931 L .2446 .56585 L p F P
0 g
s
.955 .74 .572 r
.23555 .5931 m .26596 .62803 L .26079 .65571 L p F P
0 g
s
.922 .843 .748 r
.2715 .5134 m .25628 .47778 L .27515 .45506 L p F P
0 g
s
.945 .844 .712 r
.25628 .47778 m .2715 .5134 L .25665 .5392 L p F P
0 g
s
.748 .847 .925 r
.44645 .32025 m .4374 .33289 L .40832 .3344 L p F P
0 g
s
.861 .546 .453 r
.35344 .78626 m .30412 .7637 L .30099 .7388 L p F P
0 g
s
.856 .503 .383 r
.30412 .7637 m .35344 .78626 L .35782 .80873 L p F P
0 g
s
.802 .465 .418 r
.4118 .82445 m .35782 .80873 L .35344 .78626 L p F P
0 g
s
.79 .414 .344 r
.35782 .80873 m .4118 .82445 L .4161 .8441 L p F P
0 g
s
.737 .378 .371 r
.47184 .85309 m .4161 .8441 L .4118 .82445 L p F P
0 g
s
.856 .871 .85 r
.32025 .41497 m .31899 .38537 L .34522 .37181 L p F P
0 g
s
.885 .889 .829 r
.31899 .38537 m .32025 .41497 L .29656 .43407 L p F P
0 g
s
.522 .665 .927 r
.61614 .3318 m .60675 .31927 L .63284 .31634 L p F P
0 g
s
.522 .665 .927 r
.63284 .31634 m .64505 .33296 L .61614 .3318 L p F P
0 g
s
.275 .186 .57 r
.79108 .62533 m .82059 .59002 L .82656 .61759 L p F P
0 g
s
.275 .186 .57 r
.82656 .61759 m .79633 .653 L .79108 .62533 L p F P
0 g
s
.29 .313 .712 r
.7843 .51057 m .79859 .47474 L .81476 .49885 L p F P
0 g
s
.29 .313 .712 r
.81476 .49885 m .79929 .53626 L .7843 .51057 L p F P
0 g
s
.455 .14 .341 r
.64695 .82339 m .70053 .80716 L .69399 .82769 L p F P
0 g
s
.455 .14 .341 r
.69399 .82769 m .64249 .84309 L .64695 .82339 L p F P
0 g
s
.38 .114 .38 r
.70501 .78462 m .75376 .76158 L .74796 .78505 L p F P
0 g
s
.38 .114 .38 r
.74796 .78505 m .70053 .80716 L .70501 .78462 L p F P
0 g
s
.359 .465 .832 r
.73434 .41256 m .73482 .38291 L .75909 .39864 L p F P
0 g
s
.359 .465 .832 r
.75909 .39864 m .75813 .43141 L .73434 .41256 L p F P
0 g
s
.689 .818 .944 r
.49302 .31246 m .48203 .31836 L .45948 .30919 L p F P
0 g
s
.709 .817 .932 r
.44645 .32025 m .45948 .30919 L .48203 .31836 L p F P
0 g
s
.575 .726 .945 r
.57127 .31781 m .56012 .31205 L .57676 .29966 L p F P
0 g
s
.575 .726 .945 r
.57676 .29966 m .59342 .30837 L .57127 .31781 L p F P
0 g
s
.791 .86 .901 r
.37311 .36077 m .38015 .33871 L .40832 .3344 L p F P
0 g
s
.819 .89 .894 r
.38015 .33871 m .37311 .36077 L .34522 .37181 L p F P
0 g
s
.658 .272 .303 r
.47184 .85309 m .52945 .85593 L .52934 .87241 L p F P
0 g
s
.592 .218 .302 r
.52945 .85593 m .58698 .85258 L .58395 .86926 L p F P
0 g
s
.592 .218 .302 r
.58395 .86926 m .52934 .87241 L .52945 .85593 L p F P
0 g
s
.423 .571 .897 r
.68072 .35893 m .67309 .33694 L .69995 .34376 L p F P
0 g
s
.423 .571 .897 r
.69995 .34376 m .70859 .36965 L .68072 .35893 L p F P
0 g
s
.665 .813 .954 r
.50569 .30831 m .49302 .31246 L .4759 .30028 L p F P
0 g
s
.689 .818 .944 r
.45948 .30919 m .4759 .30028 L .49302 .31246 L p F P
0 g
s
.583 .747 .955 r
.56012 .31205 m .54734 .30806 L .55758 .29361 L p F P
0 g
s
.583 .747 .955 r
.55758 .29361 m .57676 .29966 L .56012 .31205 L p F P
0 g
s
.945 .844 .712 r
.25665 .5392 m .2402 .50203 L .25628 .47778 L p F P
0 g
s
.967 .841 .666 r
.2402 .50203 m .25665 .5392 L .2446 .56585 L p F P
0 g
s
.916 .628 .482 r
.30099 .7388 m .25922 .70974 L .25851 .68304 L p F P
0 g
s
.916 .589 .41 r
.25922 .70974 m .30099 .7388 L .30412 .7637 L p F P
0 g
s
.885 .889 .829 r
.29656 .43407 m .29473 .40136 L .31899 .38537 L p F P
0 g
s
.913 .905 .802 r
.29473 .40136 m .29656 .43407 L .27515 .45506 L p F P
0 g
s
.716 .314 .286 r
.4161 .8441 m .47184 .85309 L .47465 .86974 L p F P
0 g
s
.658 .272 .303 r
.52934 .87241 m .47465 .86974 L .47184 .85309 L p F P
0 g
s
.511 .147 .284 r
.58698 .85258 m .64249 .84309 L .63661 .86037 L p F P
0 g
s
.511 .147 .284 r
.63661 .86037 m .58395 .86926 L .58698 .85258 L p F P
0 g
s
.723 .857 .945 r
.45948 .30919 m .44645 .32025 L .42009 .31765 L p F P
0 g
s
.748 .847 .925 r
.40832 .3344 m .42009 .31765 L .44645 .32025 L p F P
0 g
s
.955 .74 .572 r
.26079 .65571 m .22965 .62067 L .23555 .5931 L p F P
0 g
s
.965 .715 .509 r
.22965 .62067 m .26079 .65571 L .25851 .68304 L p F P
0 g
s
.279 .07 .406 r
.75693 .73662 m .79795 .70711 L .79414 .73297 L p F P
0 g
s
.279 .07 .406 r
.79414 .73297 m .75376 .76158 L .75693 .73662 L p F P
0 g
s
.77 .885 .928 r
.42009 .31765 m .40832 .3344 L .38015 .33871 L p F P
0 g
s
.513 .688 .947 r
.60675 .31927 m .59342 .30837 L .61531 .30182 L p F P
0 g
s
.513 .688 .947 r
.61531 .30182 m .63284 .31634 L .60675 .31927 L p F P
0 g
s
.641 .802 .96 r
.51943 .30614 m .50569 .30831 L .49491 .294 L p F P
0 g
s
.665 .813 .954 r
.4759 .30028 m .49491 .294 L .50569 .30831 L p F P
0 g
s
.226 .239 .665 r
.79929 .53626 m .81476 .49885 L .8279 .52431 L p F P
0 g
s
.226 .239 .665 r
.8279 .52431 m .81145 .56282 L .79929 .53626 L p F P
0 g
s
.598 .768 .961 r
.54734 .30806 m .53354 .30605 L .53683 .29057 L p F P
0 g
s
.598 .768 .961 r
.53683 .29057 m .55758 .29361 L .54734 .30806 L p F P
0 g
s
.292 .403 .804 r
.75813 .43141 m .75909 .39864 L .7811 .41672 L p F P
0 g
s
.292 .403 .804 r
.7811 .41672 m .77963 .45219 L .75813 .43141 L p F P
0 g
s
.457 .632 .93 r
.64505 .33296 m .63284 .31634 L .65824 .31637 L p F P
0 g
s
.457 .632 .93 r
.65824 .31637 m .67309 .33694 L .64505 .33296 L p F P
0 g
s
.618 .787 .963 r
.53354 .30605 m .51943 .30614 L .51558 .2907 L p F P
0 g
s
.641 .802 .96 r
.49491 .294 m .51558 .2907 L .51943 .30614 L p F P
0 g
s
.618 .787 .963 r
.51558 .2907 m .53683 .29057 L .53354 .30605 L p F P
0 g
s
.214 .104 .505 r
.79633 .653 m .82656 .61759 L .8292 .64524 L p F P
0 g
s
.214 .104 .505 r
.8292 .64524 m .79865 .68036 L .79633 .653 L p F P
0 g
s
.819 .89 .894 r
.34522 .37181 m .35317 .34586 L .38015 .33871 L p F P
0 g
s
.847 .92 .881 r
.35317 .34586 m .34522 .37181 L .31899 .38537 L p F P
0 g
s
.35 .519 .883 r
.70859 .36965 m .69995 .34376 L .72531 .35344 L p F P
0 g
s
.35 .519 .883 r
.72531 .35344 m .73482 .38291 L .70859 .36965 L p F P
0 g
s
.856 .503 .383 r
.35782 .80873 m .30983 .78708 L .30412 .7637 L p F P
0 g
s
.842 .445 .293 r
.30983 .78708 m .35782 .80873 L .36421 .82918 L p F P
0 g
s
.79 .414 .344 r
.4161 .8441 m .36421 .82918 L .35782 .80873 L p F P
0 g
s
.69 .859 .963 r
.4759 .30028 m .45948 .30919 L .43721 .30291 L p F P
0 g
s
.723 .857 .945 r
.42009 .31765 m .43721 .30291 L .45948 .30919 L p F P
0 g
s
.913 .905 .802 r
.27515 .45506 m .27273 .41967 L .29473 .40136 L p F P
0 g
s
.94 .916 .764 r
.27273 .41967 m .27515 .45506 L .25628 .47778 L p F P
0 g
s
.326 .023 .288 r
.70053 .80716 m .74796 .78505 L .73951 .80673 L p F P
0 g
s
.326 .023 .288 r
.73951 .80673 m .69399 .82769 L .70053 .80716 L p F P
0 g
s
.967 .841 .666 r
.2446 .56585 m .22713 .52759 L .2402 .50203 L p F P
0 g
s
.985 .83 .607 r
.22713 .52759 m .2446 .56585 L .23555 .5931 L p F P
0 g
s
.768 .346 .248 r
.36421 .82918 m .4161 .8441 L .42178 .86132 L p F P
0 g
s
.716 .314 .286 r
.47465 .86974 m .42178 .86132 L .4161 .8441 L p F P
0 g
s
.511 .716 .964 r
.59342 .30837 m .57676 .29966 L .59326 .29017 L p F P
0 g
s
.511 .716 .964 r
.59326 .29017 m .61531 .30182 L .59342 .30837 L p F P
0 g
s
.406 .049 .244 r
.64249 .84309 m .69399 .82769 L .68539 .84594 L p F P
0 g
s
.406 .049 .244 r
.68539 .84594 m .63661 .86037 L .64249 .84309 L p F P
0 g
s
.211 .327 .765 r
.77963 .45219 m .7811 .41672 L .80058 .43702 L p F P
0 g
s
.211 .327 .765 r
.80058 .43702 m .79859 .47474 L .77963 .45219 L p F P
0 g
s
.149 .152 .605 r
.81145 .56282 m .8279 .52431 L .8378 .55088 L p F P
0 g
s
.149 .152 .605 r
.8378 .55088 m .82059 .59002 L .81145 .56282 L p F P
0 g
s
.77 .885 .928 r
.38015 .33871 m .39443 .31799 L .42009 .31765 L p F P
0 g
s
.792 .923 .924 r
.39443 .31799 m .38015 .33871 L .35317 .34586 L p F P
0 g
s
.965 .715 .509 r
.25851 .68304 m .22705 .6483 L .22965 .62067 L p F P
0 g
s
.968 .68 .428 r
.22705 .6483 m .25851 .68304 L .25922 .70974 L p F P
0 g
s
.916 .589 .41 r
.30412 .7637 m .26299 .73552 L .25922 .70974 L p F P
0 g
s
.907 .537 .318 r
.26299 .73552 m .30412 .7637 L .30983 .78708 L p F P
0 g
s
.375 .588 .926 r
.67309 .33694 m .65824 .31637 L .68268 .31945 L p F P
0 g
s
.375 .588 .926 r
.68268 .31945 m .69995 .34376 L .67309 .33694 L p F P
0 g
s
.735 .9 .953 r
.43721 .30291 m .42009 .31765 L .39443 .31799 L p F P
0 g
s
.847 .92 .881 r
.31899 .38537 m .32769 .35583 L .35317 .34586 L p F P
0 g
s
.874 .947 .857 r
.32769 .35583 m .31899 .38537 L .29473 .40136 L p F P
0 g
s
.435 .659 .955 r
.63284 .31634 m .61531 .30182 L .63671 .29833 L p F P
0 g
s
.435 .659 .955 r
.63671 .29833 m .65824 .31637 L .63284 .31634 L p F P
0 g
s
.651 .851 .977 r
.49491 .294 m .4759 .30028 L .45894 .29101 L p F P
0 g
s
.69 .859 .963 r
.43721 .30291 m .45894 .29101 L .4759 .30028 L p F P
0 g
s
.213 0 .312 r
.75376 .76158 m .79414 .73297 L .78719 .75762 L p F P
0 g
s
.213 0 .312 r
.78719 .75762 m .74796 .78505 L .75376 .76158 L p F P
0 g
s
.141 .005 .422 r
.79865 .68036 m .8292 .64524 L .8284 .67268 L p F P
0 g
s
.141 .005 .422 r
.8284 .67268 m .79795 .70711 L .79865 .68036 L p F P
0 g
s
.52 .746 .978 r
.57676 .29966 m .55758 .29361 L .56775 .28208 L p F P
0 g
s
.52 .746 .978 r
.56775 .28208 m .59326 .29017 L .57676 .29966 L p F P
0 g
s
.62 .187 .196 r
.47465 .86974 m .52934 .87241 L .5292 .88606 L p F P
0 g
s
.549 .128 .195 r
.52934 .87241 m .58395 .86926 L .5802 .88315 L p F P
0 g
s
.549 .128 .195 r
.5802 .88315 m .5292 .88606 L .52934 .87241 L p F P
0 g
s
.261 .452 .86 r
.73482 .38291 m .72531 .35344 L .74888 .36594 L p F P
0 g
s
.261 .452 .86 r
.74888 .36594 m .75909 .39864 L .73482 .38291 L p F P
0 g
s
.94 .916 .764 r
.25628 .47778 m .25328 .44016 L .27273 .41967 L p F P
0 g
s
.963 .922 .713 r
.25328 .44016 m .25628 .47778 L .2402 .50203 L p F P
0 g
s
.679 .228 .172 r
.42178 .86132 m .47465 .86974 L .47814 .8836 L p F P
0 g
s
.62 .187 .196 r
.5292 .88606 m .47814 .8836 L .47465 .86974 L p F P
0 g
s
.458 .046 .169 r
.58395 .86926 m .63661 .86037 L .62931 .87494 L p F P
0 g
s
.458 .046 .169 r
.62931 .87494 m .5802 .88315 L .58395 .86926 L p F P
0 g
s
.609 .834 .986 r
.51558 .2907 m .49491 .294 L .48421 .2826 L p F P
0 g
s
.651 .851 .977 r
.45894 .29101 m .48421 .2826 L .49491 .294 L p F P
0 g
s
.985 .83 .607 r
.23555 .5931 m .2173 .55422 L .22713 .52759 L p F P
0 g
s
.997 .809 .532 r
.2173 .55422 m .23555 .5931 L .22965 .62067 L p F P
0 g
s
.54 .778 .986 r
.55758 .29361 m .53683 .29057 L .5401 .278 L p F P
0 g
s
.54 .778 .986 r
.5401 .278 m .56775 .28208 L .55758 .29361 L p F P
0 g
s
.115 .236 .712 r
.79859 .47474 m .80058 .43702 L .81723 .45938 L p F P
0 g
s
.115 .236 .712 r
.81723 .45938 m .81476 .49885 L .79859 .47474 L p F P
0 g
s
.571 .808 .989 r
.53683 .29057 m .51558 .2907 L .51175 .27818 L p F P
0 g
s
.609 .834 .986 r
.48421 .2826 m .51175 .27818 L .51558 .2907 L p F P
0 g
s
.571 .808 .989 r
.51175 .27818 m .5401 .278 L .53683 .29057 L p F P
0 g
s
.058 .046 .527 r
.82059 .59002 m .8378 .55088 L .84426 .5783 L p F P
0 g
s
.058 .046 .527 r
.84426 .5783 m .82656 .61759 L .82059 .59002 L p F P
0 g
s
.842 .445 .293 r
.36421 .82918 m .31814 .80866 L .30983 .78708 L p F P
0 g
s
.813 .365 .175 r
.31814 .80866 m .36421 .82918 L .37261 .84733 L p F P
0 g
s
.768 .346 .248 r
.42178 .86132 m .37261 .84733 L .36421 .82918 L p F P
0 g
s
.792 .923 .924 r
.35317 .34586 m .36976 .32137 L .39443 .31799 L p F P
0 g
s
.81 .96 .909 r
.36976 .32137 m .35317 .34586 L .32769 .35583 L p F P
0 g
s
.683 .902 .974 r
.45894 .29101 m .43721 .30291 L .41546 .29969 L p F P
0 g
s
.735 .9 .953 r
.39443 .31799 m .41546 .29969 L .43721 .30291 L p F P
0 g
s
.874 .947 .857 r
.29473 .40136 m .30403 .36859 L .32769 .35583 L p F P
0 g
s
.897 .969 .82 r
.30403 .36859 m .29473 .40136 L .27273 .41967 L p F P
0 g
s
.423 .692 .975 r
.61531 .30182 m .59326 .29017 L .60943 .28382 L p F P
0 g
s
.423 .692 .975 r
.60943 .28382 m .63671 .29833 L .61531 .30182 L p F P
0 g
s
.254 0 .167 r
.69399 .82769 m .73951 .80673 L .72841 .82633 L p F P
0 g
s
.254 0 .167 r
.72841 .82633 m .68539 .84594 L .69399 .82769 L p F P
0 g
s
.271 .526 .911 r
.69995 .34376 m .68268 .31945 L .70584 .32565 L p F P
0 g
s
.271 .526 .911 r
.70584 .32565 m .72531 .35344 L .69995 .34376 L p F P
0 g
s
.968 .68 .428 r
.25922 .70974 m .22786 .67568 L .22705 .6483 L p F P
0 g
s
.96 .627 .325 r
.22786 .67568 m .25922 .70974 L .26299 .73552 L p F P
0 g
s
.151 .367 .821 r
.75909 .39864 m .74888 .36594 L .77034 .38121 L p F P
0 g
s
.151 .367 .821 r
.77034 .38121 m .7811 .41672 L .75909 .39864 L p F P
0 g
s
.727 .251 .118 r
.37261 .84733 m .42178 .86132 L .4288 .87581 L p F P
0 g
s
.679 .228 .172 r
.47814 .8836 m .4288 .87581 L .42178 .86132 L p F P
0 g
s
.74 .942 .95 r
.41546 .29969 m .39443 .31799 L .36976 .32137 L p F P
0 g
s
.335 0 .112 r
.63661 .86037 m .68539 .84594 L .67475 .86162 L p F P
0 g
s
.335 0 .112 r
.67475 .86162 m .62931 .87494 L .63661 .86037 L p F P
0 g
s
.907 .537 .318 r
.30983 .78708 m .26988 .76006 L .26299 .73552 L p F P
0 g
s
.882 .462 .199 r
.26988 .76006 m .30983 .78708 L .31814 .80866 L p F P
0 g
s
.05 0 .315 r
.79795 .70711 m .8284 .67268 L .82407 .6996 L p F P
0 g
s
.05 0 .315 r
.82407 .6996 m .79414 .73297 L .79795 .70711 L p F P
0 g
s
.33 .612 .952 r
.65824 .31637 m .63671 .29833 L .65736 .29804 L p F P
0 g
s
.33 .612 .952 r
.65736 .29804 m .68268 .31945 L .65824 .31637 L p F P
0 g
s
.963 .922 .713 r
.2402 .50203 m .23665 .46267 L .25328 .44016 L p F P
0 g
s
.979 .916 .643 r
.23665 .46267 m .2402 .50203 L .22713 .52759 L p F P
0 g
s
.127 0 .189 r
.74796 .78505 m .78719 .75762 L .77706 .78076 L p F P
0 g
s
.127 0 .189 r
.77706 .78076 m .73951 .80673 L .74796 .78505 L p F P
0 g
s
.997 .809 .532 r
.22965 .62067 m .21088 .58165 L .2173 .55422 L p F P
0 g
s
.997 .771 .434 r
.21088 .58165 m .22965 .62067 L .22705 .6483 L p F P
0 g
s
0 .123 .639 r
.81476 .49885 m .81723 .45938 L .83079 .48359 L p F P
0 g
s
0 .123 .639 r
.83079 .48359 m .8279 .52431 L .81476 .49885 L p F P
0 g
s
.62 .887 .989 r
.48421 .2826 m .45894 .29101 L .44232 .28486 L p F P
0 g
s
.683 .902 .974 r
.41546 .29969 m .44232 .28486 L .45894 .29101 L p F P
0 g
s
.426 .731 .99 r
.59326 .29017 m .56775 .28208 L .57775 .2737 L p F P
0 g
s
.426 .731 .99 r
.57775 .2737 m .60943 .28382 L .59326 .29017 L p F P
0 g
s
0 0 .425 r
.82656 .61759 m .84426 .5783 L .84713 .60626 L p F P
0 g
s
0 0 .425 r
.84713 .60626 m .8292 .64524 L .82656 .61759 L p F P
0 g
s
.558 .067 .048 r
.47814 .8836 m .5292 .88606 L .52903 .89663 L p F P
0 g
s
.48 .004 .046 r
.5292 .88606 m .5802 .88315 L .57572 .89399 L p F P
0 g
s
.48 .004 .046 r
.57572 .89399 m .52903 .89663 L .5292 .88606 L p F P
0 g
s
.897 .969 .82 r
.27273 .41967 m .28251 .38409 L .30403 .36859 L p F P
0 g
s
.912 .981 .762 r
.28251 .38409 m .27273 .41967 L .25328 .44016 L p F P
0 g
s
.81 .96 .909 r
.32769 .35583 m .34638 .32784 L .36976 .32137 L p F P
0 g
s
.82 .989 .875 r
.34638 .32784 m .32769 .35583 L .30403 .36859 L p F P
0 g
s
.137 .439 .875 r
.72531 .35344 m .70584 .32565 L .72744 .335 L p F P
0 g
s
.137 .439 .875 r
.72744 .335 m .74888 .36594 L .72531 .35344 L p F P
0 g
s
.615 .105 .015 r
.4288 .87581 m .47814 .8836 L .48229 .89439 L p F P
0 g
s
.558 .067 .048 r
.52903 .89663 m .48229 .89439 L .47814 .8836 L p F P
0 g
s
.016 .257 .76 r
.7811 .41672 m .77034 .38121 L .78937 .39915 L p F P
0 g
s
.016 .257 .76 r
.78937 .39915 m .80058 .43702 L .7811 .41672 L p F P
0 g
s
.377 0 .01 r
.5802 .88315 m .62931 .87494 L .62063 .88653 L p F P
0 g
s
.377 0 .01 r
.62063 .88653 m .57572 .89399 L .5802 .88315 L p F P
0 g
s
.553 .858 .997 r
.51175 .27818 m .48421 .2826 L .47371 .27435 L p F P
0 g
s
.62 .887 .989 r
.44232 .28486 m .47371 .27435 L .48421 .2826 L p F P
0 g
s
.449 .774 .998 r
.56775 .28208 m .5401 .278 L .54331 .26859 L p F P
0 g
s
.449 .774 .998 r
.54331 .26859 m .57775 .2737 L .56775 .28208 L p F P
0 g
s
.96 .627 .325 r
.26299 .73552 m .23216 .70251 L .22786 .67568 L p F P
0 g
s
.931 .55 .191 r
.23216 .70251 m .26299 .73552 L .26988 .76006 L p F P
0 g
s
.979 .916 .643 r
.22713 .52759 m .22311 .48699 L .23665 .46267 L p F P
0 g
s
.981 .892 .547 r
.22311 .48699 m .22713 .52759 L .2173 .55422 L p F P
0 g
s
.659 .937 .967 r
.44232 .28486 m .41546 .29969 L .39447 .29967 L p F P
0 g
s
.74 .942 .95 r
.36976 .32137 m .39447 .29967 L .41546 .29969 L p F P
0 g
s
.813 .365 .175 r
.37261 .84733 m .32907 .82813 L .31814 .80866 L p F P
0 g
s
.755 .252 .016 r
.32907 .82813 m .37261 .84733 L .38301 .86291 L p F P
0 g
s
.727 .251 .118 r
.4288 .87581 m .38301 .86291 L .37261 .84733 L p F P
0 g
s
.295 .644 .967 r
.63671 .29833 m .60943 .28382 L .62508 .28078 L p F P
0 g
s
.295 .644 .967 r
.62508 .28078 m .65736 .29804 L .63671 .29833 L p F P
0 g
s
.731 .975 .925 r
.39447 .29967 m .36976 .32137 L .34638 .32784 L p F P
0 g
s
.493 .818 1 r
.5401 .278 m .51175 .27818 L .50799 .26882 L p F P
0 g
s
.553 .858 .997 r
.47371 .27435 m .50799 .26882 L .51175 .27818 L p F P
0 g
s
0 0 .177 r
.79414 .73297 m .82407 .6996 L .81617 .72567 L p F P
0 g
s
0 0 .177 r
.81617 .72567 m .78719 .75762 L .79414 .73297 L p F P
0 g
s
.493 .818 1 r
.50799 .26882 m .54331 .26859 L .5401 .278 L p F P
0 g
s
.153 0 .005 r
.68539 .84594 m .72841 .82633 L .7147 .84355 L p F P
0 g
s
.153 0 .005 r
.7147 .84355 m .67475 .86162 L .68539 .84594 L p F P
0 g
s
0 0 .538 r
.8279 .52431 m .83079 .48359 L .84103 .50944 L p F P
0 g
s
0 0 .538 r
.84103 .50944 m .8378 .55088 L .8279 .52431 L p F P
0 g
s
.188 .537 .926 r
.68268 .31945 m .65736 .29804 L .677 .30109 L p F P
0 g
s
.188 .537 .926 r
.677 .30109 m .70584 .32565 L .68268 .31945 L p F P
0 g
s
.997 .771 .434 r
.22705 .6483 m .20805 .60959 L .21088 .58165 L p F P
0 g
s
.977 .71 .306 r
.20805 .60959 m .22705 .6483 L .22786 .67568 L p F P
0 g
s
.882 .462 .199 r
.31814 .80866 m .2799 .78307 L .26988 .76006 L p F P
0 g
s
.83 .357 .042 r
.2799 .78307 m .31814 .80866 L .32907 .82813 L p F P
0 g
s
.017 0 .028 r
.73951 .80673 m .77706 .78076 L .76377 .80207 L p F P
0 g
s
.017 0 .028 r
.76377 .80207 m .72841 .82633 L .73951 .80673 L p F P
0 g
s
.651 .117 0 r
.38301 .86291 m .4288 .87581 L .43717 .88733 L p F P
0 g
s
.615 .105 .015 r
.48229 .89439 m .43717 .88733 L .4288 .87581 L p F P
0 g
s
0 0 .292 r
.8292 .64524 m .84713 .60626 L .84626 .63448 L p F P
0 g
s
0 0 .292 r
.84626 .63448 m .8284 .67268 L .8292 .64524 L p F P
0 g
s
.23 0 0 r
.62931 .87494 m .67475 .86162 L .66209 .87446 L p F P
0 g
s
.23 0 0 r
.66209 .87446 m .62063 .88653 L .62931 .87494 L p F P
0 g
s
.912 .981 .762 r
.25328 .44016 m .26341 .40224 L .28251 .38409 L p F P
0 g
s
.909 .972 .673 r
.26341 .40224 m .25328 .44016 L .23665 .46267 L p F P
0 g
s
.82 .989 .875 r
.30403 .36859 m .32458 .33744 L .34638 .32784 L p F P
0 g
s
.812 1 .809 r
.32458 .33744 m .30403 .36859 L .28251 .38409 L p F P
0 g
s
0 .116 .666 r
.80058 .43702 m .78937 .39915 L .8057 .41965 L p F P
0 g
s
0 .116 .666 r
.8057 .41965 m .81723 .45938 L .80058 .43702 L p F P
0 g
s
.558 .906 .972 r
.47371 .27435 m .44232 .28486 L .42624 .28202 L p F P
0 g
s
.659 .937 .967 r
.39447 .29967 m .42624 .28202 L .44232 .28486 L p F P
0 g
s
0 .317 .806 r
.74888 .36594 m .72744 .335 L .74717 .3475 L p F P
0 g
s
0 .317 .806 r
.74717 .3475 m .77034 .38121 L .74888 .36594 L p F P
0 g
s
.283 .685 .972 r
.60943 .28382 m .57775 .2737 L .58744 .26871 L p F P
0 g
s
.283 .685 .972 r
.58744 .26871 m .62508 .28078 L .60943 .28382 L p F P
0 g
s
.981 .892 .547 r
.2173 .55422 m .2129 .5129 L .22311 .48699 L p F P
0 g
s
.959 .84 .417 r
.2129 .5129 m .2173 .55422 L .21088 .58165 L p F P
0 g
s
.931 .55 .191 r
.26988 .76006 m .24001 .72845 L .23216 .70251 L p F P
0 g
s
.868 .438 .021 r
.24001 .72845 m .26988 .76006 L .2799 .78307 L p F P
0 g
s
0 0 .403 r
.8378 .55088 m .84103 .50944 L .84772 .53665 L p F P
0 g
s
0 0 .403 r
.84772 .53665 m .84426 .5783 L .8378 .55088 L p F P
0 g
s
0 0 .003 r
.78719 .75762 m .81617 .72567 L .80468 .75055 L p F P
0 g
s
0 0 .003 r
.80468 .75055 m .77706 .78076 L .78719 .75762 L p F P
0 g
s
.45 0 0 r
.48229 .89439 m .52903 .89663 L .52884 .90386 L p F P
0 g
s
.368 0 0 r
.52903 .89663 m .57572 .89399 L .57053 .90151 L p F P
0 g
s
.368 0 0 r
.57053 .90151 m .52884 .90386 L .52903 .89663 L p F P
0 g
s
.977 .71 .306 r
.22786 .67568 m .20893 .63774 L .20805 .60959 L p F P
0 g
s
.925 .615 .144 r
.20893 .63774 m .22786 .67568 L .23216 .70251 L p F P
0 g
s
.731 .975 .925 r
.34638 .32784 m .3745 .30296 L .39447 .29967 L p F P
0 g
s
.694 .982 .86 r
.3745 .30296 m .34638 .32784 L .32458 .33744 L p F P
0 g
s
.603 .948 .919 r
.42624 .28202 m .39447 .29967 L .3745 .30296 L p F P
0 g
s
0 .421 .857 r
.70584 .32565 m .677 .30109 L .69538 .30757 L p F P
0 g
s
0 .421 .857 r
.69538 .30757 m .72744 .335 L .70584 .32565 L p F P
0 g
s
.501 0 0 r
.43717 .88733 m .48229 .89439 L .48708 .90187 L p F P
0 g
s
.45 0 0 r
.52884 .90386 m .48708 .90187 L .48229 .89439 L p F P
0 g
s
.452 .854 .97 r
.50799 .26882 m .47371 .27435 L .46352 .26949 L p F P
0 g
s
.558 .906 .972 r
.42624 .28202 m .46352 .26949 L .47371 .27435 L p F P
0 g
s
.114 .554 .917 r
.65736 .29804 m .62508 .28078 L .64001 .28123 L p F P
0 g
s
.114 .554 .917 r
.64001 .28123 m .677 .30109 L .65736 .29804 L p F P
0 g
s
.249 0 0 r
.57572 .89399 m .62063 .88653 L .6106 .89489 L p F P
0 g
s
.249 0 0 r
.6106 .89489 m .57053 .90151 L .57572 .89399 L p F P
0 g
s
.304 .735 .97 r
.57775 .2737 m .54331 .26859 L .54643 .26261 L p F P
0 g
s
.304 .735 .97 r
.54643 .26261 m .58744 .26871 L .57775 .2737 L p F P
0 g
s
0 0 .125 r
.8284 .67268 m .84626 .63448 L .84156 .66259 L p F P
0 g
s
0 0 .125 r
.84156 .66259 m .82407 .6996 L .8284 .67268 L p F P
0 g
s
.755 .252 .016 r
.38301 .86291 m .34256 .84521 L .32907 .82813 L p F P
0 g
s
.65 .093 0 r
.34256 .84521 m .38301 .86291 L .39537 .87562 L p F P
0 g
s
.651 .117 0 r
.43717 .88733 m .39537 .87562 L .38301 .86291 L p F P
0 g
s
.83 .357 .042 r
.32907 .82813 m .29303 .80423 L .2799 .78307 L p F P
0 g
s
.733 .21 0 r
.29303 .80423 m .32907 .82813 L .34256 .84521 L p F P
0 g
s
.909 .972 .673 r
.23665 .46267 m .24704 .42289 L .26341 .40224 L p F P
0 g
s
.877 .928 .543 r
.24704 .42289 m .23665 .46267 L .22311 .48699 L p F P
0 g
s
.018 0 0 r
.67475 .86162 m .7147 .84355 L .69842 .85811 L p F P
0 g
s
.018 0 0 r
.69842 .85811 m .66209 .87446 L .67475 .86162 L p F P
0 g
s
0 0 0 r
.72841 .82633 m .76377 .80207 L .74739 .82124 L p F P
0 g
s
0 0 0 r
.74739 .82124 m .7147 .84355 L .72841 .82633 L p F P
0 g
s
.362 .793 .968 r
.54331 .26859 m .50799 .26882 L .50434 .26287 L p F P
0 g
s
.452 .854 .97 r
.46352 .26949 m .50434 .26287 L .50799 .26882 L p F P
0 g
s
.362 .793 .968 r
.50434 .26287 m .54643 .26261 L .54331 .26859 L p F P
0 g
s
0 0 .53 r
.81723 .45938 m .8057 .41965 L .81902 .44253 L p F P
0 g
s
0 0 .53 r
.81902 .44253 m .83079 .48359 L .81723 .45938 L p F P
0 g
s
.812 1 .809 r
.28251 .38409 m .30468 .35016 L .32458 .33744 L p F P
0 g
s
.771 .974 .696 r
.30468 .35016 m .28251 .38409 L .26341 .40224 L p F P
0 g
s
.959 .84 .417 r
.21088 .58165 m .20623 .54013 L .2129 .5129 L p F P
0 g
s
.9 .75 .25 r
.20623 .54013 m .21088 .58165 L .20805 .60959 L p F P
0 g
s
0 .154 .687 r
.77034 .38121 m .74717 .3475 L .76473 .3631 L p F P
0 g
s
0 .154 .687 r
.76473 .3631 m .78937 .39915 L .77034 .38121 L p F P
0 g
s
.516 0 0 r
.39537 .87562 m .43717 .88733 L .44683 .8956 L p F P
0 g
s
.501 0 0 r
.48708 .90187 m .44683 .8956 L .43717 .88733 L p F P
0 g
s
.08 0 0 r
.62063 .88653 m .66209 .87446 L .6475 .88419 L p F P
0 g
s
.08 0 0 r
.6475 .88419 m .6106 .89489 L .62063 .88653 L p F P
0 g
s
0 0 .23 r
.84426 .5783 m .84772 .53665 L .85069 .56494 L p F P
0 g
s
0 0 .23 r
.85069 .56494 m .84713 .60626 L .84426 .5783 L p F P
0 g
s
.868 .438 .021 r
.2799 .78307 m .25142 .75318 L .24001 .72845 L p F P
0 g
s
.756 .285 0 r
.25142 .75318 m .2799 .78307 L .29303 .80423 L p F P
0 g
s
.925 .615 .144 r
.23216 .70251 m .21361 .66575 L .20893 .63774 L p F P
0 g
s
.827 .479 0 r
.21361 .66575 m .23216 .70251 L .24001 .72845 L p F P
0 g
s
.441 .877 .891 r
.46352 .26949 m .42624 .28202 L .4109 .28266 L p F P
0 g
s
.603 .948 .919 r
.3745 .30296 m .4109 .28266 L .42624 .28202 L p F P
0 g
s
0 0 0 r
.77706 .78076 m .80468 .75055 L .78964 .77391 L p F P
0 g
s
0 0 0 r
.78964 .77391 m .76377 .80207 L .77706 .78076 L p F P
0 g
s
.074 .581 .888 r
.62508 .28078 m .58744 .26871 L .5967 .26731 L p F P
0 g
s
.074 .581 .888 r
.5967 .26731 m .64001 .28123 L .62508 .28078 L p F P
0 g
s
0 0 0 r
.82407 .6996 m .84156 .66259 L .833 .69027 L p F P
0 g
s
0 0 0 r
.833 .69027 m .81617 .72567 L .82407 .6996 L p F P
0 g
s
.694 .982 .86 r
.32458 .33744 m .35584 .30965 L .3745 .30296 L p F P
0 g
s
.611 .937 .731 r
.35584 .30965 m .32458 .33744 L .30468 .35016 L p F P
0 g
s
.877 .928 .543 r
.22311 .48699 m .23369 .44588 L .24704 .42289 L p F P
0 g
s
.8 .836 .369 r
.23369 .44588 m .22311 .48699 L .2129 .5129 L p F P
0 g
s
0 .251 .721 r
.72744 .335 m .69538 .30757 L .71221 .31752 L p F P
0 g
s
0 .251 .721 r
.71221 .31752 m .74717 .3475 L .72744 .335 L p F P
0 g
s
.492 .9 .797 r
.4109 .28266 m .3745 .30296 L .35584 .30965 L p F P
0 g
s
0 0 .348 r
.83079 .48359 m .81902 .44253 L .8291 .46758 L p F P
0 g
s
0 0 .348 r
.8291 .46758 m .84103 .50944 L .83079 .48359 L p F P
0 g
s
0 .402 .791 r
.677 .30109 m .64001 .28123 L .65401 .28531 L p F P
0 g
s
0 .402 .791 r
.65401 .28531 m .69538 .30757 L .677 .30109 L p F P
0 g
s
.733 .21 0 r
.34256 .84521 m .30923 .82323 L .29303 .80423 L p F P
0 g
s
.574 .019 0 r
.30923 .82323 m .34256 .84521 L .35858 .85961 L p F P
0 g
s
.65 .093 0 r
.39537 .87562 m .35858 .85961 L .34256 .84521 L p F P
0 g
s
.771 .974 .696 r
.26341 .40224 m .28698 .36596 L .30468 .35016 L p F P
0 g
s
.681 .89 .526 r
.28698 .36596 m .26341 .40224 L .24704 .42289 L p F P
0 g
s
.9 .75 .25 r
.20805 .60959 m .20328 .56839 L .20623 .54013 L p F P
0 g
s
.794 .614 .052 r
.20328 .56839 m .20805 .60959 L .20893 .63774 L p F P
0 g
s
.272 0 0 r
.48708 .90187 m .52884 .90386 L .52862 .90751 L p F P
0 g
s
.189 0 0 r
.52884 .90386 m .57053 .90151 L .56468 .90548 L p F P
0 g
s
.189 0 0 r
.56468 .90548 m .52862 .90751 L .52884 .90386 L p F P
0 g
s
.477 0 0 r
.35858 .85961 m .39537 .87562 L .40963 .88522 L p F P
0 g
s
.516 0 0 r
.44683 .8956 m .40963 .88522 L .39537 .87562 L p F P
0 g
s
0 0 0 r
.7147 .84355 m .74739 .82124 L .728 .83798 L p F P
0 g
s
0 0 0 r
.728 .83798 m .69842 .85811 L .7147 .84355 L p F P
0 g
s
0 0 0 r
.66209 .87446 m .69842 .85811 L .6797 .86973 L p F P
0 g
s
0 0 0 r
.6797 .86973 m .6475 .88419 L .66209 .87446 L p F P
0 g
s
.282 .782 .859 r
.50434 .26287 m .46352 .26949 L .45379 .26821 L p F P
0 g
s
.441 .877 .891 r
.4109 .28266 m .45379 .26821 L .46352 .26949 L p F P
0 g
s
0 0 .509 r
.78937 .39915 m .76473 .3631 L .77983 .38174 L p F P
0 g
s
0 0 .509 r
.77983 .38174 m .8057 .41965 L .78937 .39915 L p F P
0 g
s
.312 0 0 r
.44683 .8956 m .48708 .90187 L .4925 .90579 L p F P
0 g
s
.272 0 0 r
.52862 .90751 m .4925 .90579 L .48708 .90187 L p F P
0 g
s
.087 .624 .857 r
.58744 .26871 m .54643 .26261 L .54942 .26027 L p F P
0 g
s
.087 .624 .857 r
.54942 .26027 m .5967 .26731 L .58744 .26871 L p F P
0 g
s
.062 0 0 r
.57053 .90151 m .6106 .89489 L .59928 .89978 L p F P
0 g
s
.062 0 0 r
.59928 .89978 m .56468 .90548 L .57053 .90151 L p F P
0 g
s
0 0 .027 r
.84713 .60626 m .85069 .56494 L .84979 .59397 L p F P
0 g
s
0 0 .027 r
.84979 .59397 m .84626 .63448 L .84713 .60626 L p F P
0 g
s
.827 .479 0 r
.24001 .72845 m .22215 .69329 L .21361 .66575 L p F P
0 g
s
.679 .305 0 r
.22215 .69329 m .24001 .72845 L .25142 .75318 L p F P
0 g
s
.756 .285 0 r
.29303 .80423 m .26635 .77636 L .25142 .75318 L p F P
0 g
s
.588 .095 0 r
.26635 .77636 m .29303 .80423 L .30923 .82323 L p F P
0 g
s
.158 .692 .844 r
.54643 .26261 m .50434 .26287 L .50085 .26057 L p F P
0 g
s
.282 .782 .859 r
.45379 .26821 m .50085 .26057 L .50434 .26287 L p F P
0 g
s
.158 .692 .844 r
.50085 .26057 m .54942 .26027 L .54643 .26261 L p F P
0 g
s
0 0 0 r
.76377 .80207 m .78964 .77391 L .77113 .79542 L p F P
0 g
s
0 0 0 r
.77113 .79542 m .74739 .82124 L .76377 .80207 L p F P
0 g
s
0 0 0 r
.81617 .72567 m .833 .69027 L .82057 .71715 L p F P
0 g
s
0 0 0 r
.82057 .71715 m .80468 .75055 L .81617 .72567 L p F P
0 g
s
.304 0 0 r
.40963 .88522 m .44683 .8956 L .45773 .90039 L p F P
0 g
s
.312 0 0 r
.4925 .90579 m .45773 .90039 L .44683 .8956 L p F P
0 g
s
.8 .836 .369 r
.2129 .5129 m .22359 .471 L .23369 .44588 L p F P
0 g
s
0 0 0 r
.22359 .471 m .2129 .5129 L .20623 .54013 L p F P
0 g
s
0 0 0 r
.6106 .89489 m .6475 .88419 L .63106 .89058 L p F P
0 g
s
0 0 0 r
.63106 .89058 m .59928 .89978 L .6106 .89489 L p F P
0 g
s
.611 .937 .731 r
.30468 .35016 m .33874 .3198 L .35584 .30965 L p F P
0 g
s
0 0 0 r
.33874 .3198 m .30468 .35016 L .28698 .36596 L p F P
0 g
s
.726 .448 0 r
.84103 .50944 m .8291 .46758 L .8357 .49455 L p F P
0 g
s
.726 .448 0 r
.8357 .49455 m .84772 .53665 L .84103 .50944 L p F P
0 g
s
.257 .757 .706 r
.45379 .26821 m .4109 .28266 L .39652 .28691 L p F P
0 g
s
.492 .9 .797 r
.35584 .30965 m .39652 .28691 L .4109 .28266 L p F P
0 g
s
.794 .614 .052 r
.20893 .63774 m .2042 .59736 L .20328 .56839 L p F P
0 g
s
0 0 .159 r
.2042 .59736 m .20893 .63774 L .21361 .66575 L p F P
0 g
s
.486 0 0 r
.74717 .3475 m .71221 .31752 L .72723 .33096 L p F P
0 g
s
.486 0 0 r
.72723 .33096 m .76473 .3631 L .74717 .3475 L p F P
0 g
s
0 .396 .699 r
.64001 .28123 m .5967 .26731 L .6054 .26969 L p F P
0 g
s
0 .396 .699 r
.6054 .26969 m .65401 .28531 L .64001 .28123 L p F P
0 g
s
.681 .89 .526 r
.24704 .42289 m .27177 .38474 L .28698 .36596 L p F P
0 g
s
0 0 0 r
.27177 .38474 m .24704 .42289 L .23369 .44588 L p F P
0 g
s
.782 .717 .184 r
.84626 .63448 m .84979 .59397 L .84493 .62339 L p F P
0 g
s
.782 .717 .184 r
.84493 .62339 m .84156 .66259 L .84626 .63448 L p F P
0 g
s
0 0 0 r
.39652 .28691 m .35584 .30965 L .33874 .3198 L p F P
0 g
s
.682 .252 0 r
.8057 .41965 m .77983 .38174 L .79218 .40326 L p F P
0 g
s
.682 .252 0 r
.79218 .40326 m .81902 .44253 L .8057 .41965 L p F P
0 g
s
.574 .019 0 r
.35858 .85961 m .3284 .83977 L .30923 .82323 L p F P
0 g
s
.477 0 0 r
.40963 .88522 m .377 .87106 L .35858 .85961 L p F P
0 g
s
0 .196 .622 r
.3284 .83977 m .35858 .85961 L .377 .87106 L p F P
0 g
s
.387 0 0 r
.69538 .30757 m .65401 .28531 L .66687 .29313 L p F P
0 g
s
.387 0 0 r
.66687 .29313 m .71221 .31752 L .69538 .30757 L p F P
0 g
s
.432 .835 .636 r
.69842 .85811 m .728 .83798 L .70576 .85198 L p F P
0 g
s
.432 .835 .636 r
.70576 .85198 m .6797 .86973 L .69842 .85811 L p F P
0 g
s
.304 0 0 r
.45773 .90039 m .42568 .89146 L .40963 .88522 L p F P
0 g
s
0 .338 .688 r
.377 .87106 m .40963 .88522 L .42568 .89146 L p F P
0 g
s
.679 .305 0 r
.25142 .75318 m .23453 .71999 L .22215 .69329 L p F P
0 g
s
0 0 .466 r
.23453 .71999 m .25142 .75318 L .26635 .77636 L p F P
0 g
s
.33 .798 .698 r
.6475 .88419 m .6797 .86973 L .65867 .87817 L p F P
0 g
s
.33 .798 .698 r
.65867 .87817 m .63106 .89058 L .6475 .88419 L p F P
0 g
s
.588 .095 0 r
.30923 .82323 m .28472 .79766 L .26635 .77636 L p F P
0 g
s
0 .109 .613 r
.28472 .79766 m .30923 .82323 L .3284 .83977 L p F P
0 g
s
0 .557 .715 r
.4925 .90579 m .52862 .90751 L .52837 .90737 L p F P
0 g
s
.05 .617 .716 r
.52862 .90751 m .56468 .90548 L .55819 .90569 L p F P
0 g
s
.05 .617 .716 r
.55819 .90569 m .52837 .90737 L .52862 .90751 L p F P
0 g
s
0 0 0 r
.20623 .54013 m .21699 .49799 L .22359 .471 L p F P
0 g
s
0 0 .058 r
.21699 .49799 m .20623 .54013 L .20328 .56839 L p F P
0 g
s
.737 .886 .485 r
.80468 .75055 m .82057 .71715 L .80434 .74285 L p F P
0 g
s
.737 .886 .485 r
.80434 .74285 m .78964 .77391 L .80468 .75055 L p F P
0 g
s
.257 .757 .706 r
.39652 .28691 m .44464 .2707 L .45379 .26821 L p F P
0 g
s
0 0 0 r
.50085 .26057 m .45379 .26821 L .44464 .2707 L p F P
0 g
s
.178 0 0 r
.5967 .26731 m .54942 .26027 L .55223 .26177 L p F P
0 g
s
.178 0 0 r
.55223 .26177 m .6054 .26969 L .5967 .26731 L p F P
0 g
s
0 .525 .747 r
.45773 .90039 m .4925 .90579 L .49851 .90595 L p F P
0 g
s
0 .557 .715 r
.52837 .90737 m .49851 .90595 L .4925 .90579 L p F P
0 g
s
.607 .906 .628 r
.74739 .82124 m .77113 .79542 L .7493 .81474 L p F P
0 g
s
.607 .906 .628 r
.7493 .81474 m .728 .83798 L .74739 .82124 L p F P
0 g
s
.165 .703 .751 r
.56468 .90548 m .59928 .89978 L .58676 .90098 L p F P
0 g
s
.165 .703 .751 r
.58676 .90098 m .55819 .90569 L .56468 .90548 L p F P
0 g
s
.865 .613 .081 r
.84772 .53665 m .8357 .49455 L .83862 .52313 L p F P
0 g
s
.865 .613 .081 r
.83862 .52313 m .85069 .56494 L .84772 .53665 L p F P
0 g
s
0 0 .159 r
.21361 .66575 m .20907 .62667 L .2042 .59736 L p F P
0 g
s
0 0 .356 r
.20907 .62667 m .21361 .66575 L .22215 .69329 L p F P
0 g
s
0 0 0 r
.28698 .36596 m .32349 .33341 L .33874 .3198 L p F P
0 g
s
0 0 0 r
.32349 .33341 m .28698 .36596 L .27177 .38474 L p F P
0 g
s
.096 0 0 r
.54942 .26027 m .50085 .26057 L .49756 .26212 L p F P
0 g
s
0 0 0 r
.44464 .2707 m .49756 .26212 L .50085 .26057 L p F P
0 g
s
.096 0 0 r
.49756 .26212 m .55223 .26177 L .54942 .26027 L p F P
0 g
s
.877 .841 .376 r
.84156 .66259 m .84493 .62339 L .83607 .65283 L p F P
0 g
s
.877 .841 .376 r
.83607 .65283 m .833 .69027 L .84156 .66259 L p F P
0 g
s
0 0 0 r
.23369 .44588 m .25932 .40637 L .27177 .38474 L p F P
0 g
s
0 0 0 r
.25932 .40637 m .23369 .44588 L .22359 .471 L p F P
0 g
s
0 .519 .804 r
.42568 .89146 m .45773 .90039 L .4698 .90148 L p F P
0 g
s
0 .525 .747 r
.49851 .90595 m .4698 .90148 L .45773 .90039 L p F P
0 g
s
.692 .176 0 r
.76473 .3631 m .72723 .33096 L .74018 .34785 L p F P
0 g
s
.692 .176 0 r
.74018 .34785 m .77983 .38174 L .76473 .3631 L p F P
0 g
s
.312 .803 .809 r
.59928 .89978 m .63106 .89058 L .61291 .89339 L p F P
0 g
s
.312 .803 .809 r
.61291 .89339 m .58676 .90098 L .59928 .89978 L p F P
0 g
s
.837 .434 0 r
.81902 .44253 m .79218 .40326 L .80154 .42749 L p F P
0 g
s
.837 .434 0 r
.80154 .42749 m .8291 .46758 L .81902 .44253 L p F P
0 g
s
0 0 0 r
.44464 .2707 m .39652 .28691 L .38333 .29489 L p F P
0 g
s
0 0 0 r
.33874 .3198 m .38333 .29489 L .39652 .28691 L p F P
0 g
s
.439 0 0 r
.65401 .28531 m .6054 .26969 L .61341 .27599 L p F P
0 g
s
.439 0 0 r
.61341 .27599 m .66687 .29313 L .65401 .28531 L p F P
0 g
s
0 0 .466 r
.26635 .77636 m .25071 .74549 L .23453 .71999 L p F P
0 g
s
0 .079 .635 r
.25071 .74549 m .26635 .77636 L .28472 .79766 L p F P
0 g
s
0 0 0 r
.38333 .29489 m .33874 .3198 L .32349 .33341 L p F P
0 g
s
0 .196 .622 r
.377 .87106 m .3504 .85355 L .3284 .83977 L p F P
0 g
s
0 .394 .804 r
.3504 .85355 m .377 .87106 L .39769 .8793 L p F P
0 g
s
0 .338 .688 r
.42568 .89146 m .39769 .8793 L .377 .87106 L p F P
0 g
s
0 0 .058 r
.20328 .56839 m .21407 .52655 L .21699 .49799 L p F P
0 g
s
0 0 .254 r
.21407 .52655 m .20328 .56839 L .2042 .59736 L p F P
0 g
s
.606 .038 0 r
.71221 .31752 m .66687 .29313 L .67837 .30475 L p F P
0 g
s
.606 .038 0 r
.67837 .30475 m .72723 .33096 L .71221 .31752 L p F P
0 g
s
.548 .927 .812 r
.6797 .86973 m .70576 .85198 L .68087 .86298 L p F P
0 g
s
.548 .927 .812 r
.68087 .86298 m .65867 .87817 L .6797 .86973 L p F P
0 g
s
.803 .964 .647 r
.78964 .77391 m .80434 .74285 L .78442 .76701 L p F P
0 g
s
.803 .964 .647 r
.78442 .76701 m .77113 .79542 L .78964 .77391 L p F P
0 g
s
0 .109 .613 r
.3284 .83977 m .30639 .81675 L .28472 .79766 L p F P
0 g
s
0 .297 .773 r
.30639 .81675 m .3284 .83977 L .3504 .85355 L p F P
0 g
s
.95 .735 .272 r
.85069 .56494 m .83862 .52313 L .83773 .553 L p F P
0 g
s
.95 .735 .272 r
.83773 .553 m .84979 .59397 L .85069 .56494 L p F P
0 g
s
0 0 .356 r
.22215 .69329 m .21794 .65595 L .20907 .62667 L p F P
0 g
s
0 0 .52 r
.21794 .65595 m .22215 .69329 L .23453 .71999 L p F P
0 g
s
.02 .529 .868 r
.39769 .8793 m .42568 .89146 L .44341 .89412 L p F P
0 g
s
0 .519 .804 r
.4698 .90148 m .44341 .89412 L .42568 .89146 L p F P
0 g
s
.682 .972 .781 r
.728 .83798 m .7493 .81474 L .72435 .83156 L p F P
0 g
s
.682 .972 .781 r
.72435 .83156 m .70576 .85198 L .728 .83798 L p F P
0 g
s
.473 .894 .872 r
.63106 .89058 m .65867 .87817 L .63553 .88319 L p F P
0 g
s
.473 .894 .872 r
.63553 .88319 m .61291 .89339 L .63106 .89058 L p F P
0 g
s
.926 .917 .534 r
.833 .69027 m .83607 .65283 L .82322 .68188 L p F P
0 g
s
.926 .917 .534 r
.82322 .68188 m .82057 .71715 L .833 .69027 L p F P
0 g
s
0 0 0 r
.22359 .471 m .24991 .43067 L .25932 .40637 L p F P
0 g
s
0 0 .131 r
.24991 .43067 m .22359 .471 L .21699 .49799 L p F P
0 g
s
0 0 0 r
.27177 .38474 m .31036 .35044 L .32349 .33341 L p F P
0 g
s
0 0 0 r
.31036 .35044 m .27177 .38474 L .25932 .40637 L p F P
0 g
s
.228 .725 .913 r
.49851 .90595 m .52837 .90737 L .5281 .90326 L p F P
0 g
s
.284 .77 .913 r
.52837 .90737 m .55819 .90569 L .55112 .90196 L p F P
0 g
s
.284 .77 .913 r
.55112 .90196 m .5281 .90326 L .52837 .90737 L p F P
0 g
s
.176 0 0 r
.49756 .26212 m .44464 .2707 L .43624 .27709 L p F P
0 g
s
0 0 0 r
.38333 .29489 m .43624 .27709 L .44464 .2707 L p F P
0 g
s
.409 0 0 r
.6054 .26969 m .55223 .26177 L .55481 .26729 L p F P
0 g
s
.409 0 0 r
.55481 .26729 m .61341 .27599 L .6054 .26969 L p F P
0 g
s
.203 .692 .925 r
.4698 .90148 m .49851 .90595 L .50505 .90216 L p F P
0 g
s
.228 .725 .913 r
.5281 .90326 m .50505 .90216 L .49851 .90595 L p F P
0 g
s
.93 .571 .149 r
.8291 .46758 m .80154 .42749 L .80767 .45418 L p F P
0 g
s
.93 .571 .149 r
.80767 .45418 m .8357 .49455 L .8291 .46758 L p F P
0 g
s
.365 .823 .926 r
.55819 .90569 m .58676 .90098 L .57314 .89832 L p F P
0 g
s
.365 .823 .926 r
.57314 .89832 m .55112 .90196 L .55819 .90569 L p F P
0 g
s
.825 .351 0 r
.77983 .38174 m .74018 .34785 L .75079 .36809 L p F P
0 g
s
.825 .351 0 r
.75079 .36809 m .79218 .40326 L .77983 .38174 L p F P
0 g
s
0 .079 .635 r
.28472 .79766 m .27056 .76942 L .25071 .74549 L p F P
0 g
s
0 .245 .759 r
.27056 .76942 m .28472 .79766 L .30639 .81675 L p F P
0 g
s
0 0 .254 r
.2042 .59736 m .21498 .55635 L .21407 .52655 L p F P
0 g
s
0 0 .414 r
.21498 .55635 m .2042 .59736 L .20907 .62667 L p F P
0 g
s
.829 .996 .766 r
.77113 .79542 m .78442 .76701 L .76099 .78926 L p F P
0 g
s
.829 .996 .766 r
.76099 .78926 m .7493 .81474 L .77113 .79542 L p F P
0 g
s
.208 .67 .944 r
.44341 .89412 m .4698 .90148 L .48292 .8987 L p F P
0 g
s
.203 .692 .925 r
.50505 .90216 m .48292 .8987 L .4698 .90148 L p F P
0 g
s
.321 0 0 r
.55223 .26177 m .49756 .26212 L .49454 .26766 L p F P
0 g
s
.176 0 0 r
.43624 .27709 m .49454 .26766 L .49756 .26212 L p F P
0 g
s
.321 0 0 r
.49454 .26766 m .55481 .26729 L .55223 .26177 L p F P
0 g
s
.462 .875 .945 r
.58676 .90098 m .61291 .89339 L .59323 .89246 L p F P
0 g
s
.462 .875 .945 r
.59323 .89246 m .57314 .89832 L .58676 .90098 L p F P
0 g
s
.988 .813 .426 r
.84979 .59397 m .83773 .553 L .83294 .58377 L p F P
0 g
s
.988 .813 .426 r
.83294 .58377 m .84493 .62339 L .84979 .59397 L p F P
0 g
s
0 0 .52 r
.23453 .71999 m .23078 .68482 L .21794 .65595 L p F P
0 g
s
0 .097 .646 r
.23078 .68482 m .23453 .71999 L .25071 .74549 L p F P
0 g
s
0 .394 .804 r
.39769 .8793 m .37502 .86433 L .3504 .85355 L p F P
0 g
s
.111 .545 .915 r
.37502 .86433 m .39769 .8793 L .42047 .88412 L p F P
0 g
s
.02 .529 .868 r
.44341 .89412 m .42047 .88412 L .39769 .8793 L p F P
0 g
s
0 0 0 r
.32349 .33341 m .37153 .30664 L .38333 .29489 L p F P
0 g
s
.059 0 0 r
.37153 .30664 m .32349 .33341 L .31036 .35044 L p F P
0 g
s
.156 0 0 r
.43624 .27709 m .38333 .29489 L .37153 .30664 L p F P
0 g
s
0 .297 .773 r
.3504 .85355 m .33117 .83332 L .30639 .81675 L p F P
0 g
s
.047 .447 .876 r
.33117 .83332 m .3504 .85355 L .37502 .86433 L p F P
0 g
s
.617 .953 .918 r
.65867 .87817 m .68087 .86298 L .65357 .87074 L p F P
0 g
s
.617 .953 .918 r
.65357 .87074 m .63553 .88319 L .65867 .87817 L p F P
0 g
s
.613 .056 0 r
.66687 .29313 m .61341 .27599 L .62058 .28629 L p F P
0 g
s
.613 .056 0 r
.62058 .28629 m .67837 .30475 L .66687 .29313 L p F P
0 g
s
.94 .956 .654 r
.82057 .71715 m .82322 .68188 L .80649 .71013 L p F P
0 g
s
.94 .956 .654 r
.80649 .71013 m .80434 .74285 L .82057 .71715 L p F P
0 g
s
.745 .226 0 r
.72723 .33096 m .67837 .30475 L .6883 .32017 L p F P
0 g
s
.745 .226 0 r
.6883 .32017 m .74018 .34785 L .72723 .33096 L p F P
0 g
s
.716 .986 .88 r
.70576 .85198 m .72435 .83156 L .69652 .84558 L p F P
0 g
s
.716 .986 .88 r
.69652 .84558 m .68087 .86298 L .70576 .85198 L p F P
0 g
s
0 0 .131 r
.21699 .49799 m .24374 .45738 L .24991 .43067 L p F P
0 g
s
0 0 .298 r
.24374 .45738 m .21699 .49799 L .21407 .52655 L p F P
0 g
s
.239 .656 .96 r
.42047 .88412 m .44341 .89412 L .46264 .89302 L p F P
0 g
s
.208 .67 .944 r
.48292 .8987 m .46264 .89302 L .44341 .89412 L p F P
0 g
s
.561 .915 .961 r
.61291 .89339 m .63553 .88319 L .61051 .88461 L p F P
0 g
s
.561 .915 .961 r
.61051 .88461 m .59323 .89246 L .61291 .89339 L p F P
0 g
s
0 0 0 r
.25932 .40637 m .29959 .37078 L .31036 .35044 L p F P
0 g
s
.033 0 .153 r
.29959 .37078 m .25932 .40637 L .24991 .43067 L p F P
0 g
s
.973 .664 .311 r
.8357 .49455 m .80767 .45418 L .81039 .48303 L p F P
0 g
s
.973 .664 .311 r
.81039 .48303 m .83862 .52313 L .8357 .49455 L p F P
0 g
s
0 .245 .759 r
.30639 .81675 m .2939 .79142 L .27056 .76942 L p F P
0 g
s
.062 .379 .843 r
.2939 .79142 m .30639 .81675 L .33117 .83332 L p F P
0 g
s
0 0 .414 r
.20907 .62667 m .2198 .58701 L .21498 .55635 L p F P
0 g
s
0 .013 .537 r
.2198 .58701 m .20907 .62667 L .21794 .65595 L p F P
0 g
s
.896 .477 .166 r
.79218 .40326 m .75079 .36809 L .75884 .39153 L p F P
0 g
s
.896 .477 .166 r
.75884 .39153 m .80154 .42749 L .79218 .40326 L p F P
0 g
s
.828 .997 .845 r
.7493 .81474 m .76099 .78926 L .73431 .80925 L p F P
0 g
s
.828 .997 .845 r
.73431 .80925 m .72435 .83156 L .7493 .81474 L p F P
0 g
s
0 .097 .646 r
.25071 .74549 m .24752 .71286 L .23078 .68482 L p F P
0 g
s
.02 .232 .738 r
.24752 .71286 m .25071 .74549 L .27056 .76942 L p F P
0 g
s
.997 .86 .545 r
.84493 .62339 m .83294 .58377 L .82421 .61503 L p F P
0 g
s
.997 .86 .545 r
.82421 .61503 m .83607 .65283 L .84493 .62339 L p F P
0 g
s
.344 0 0 r
.49454 .26766 m .43624 .27709 L .42871 .28749 L p F P
0 g
s
.156 0 0 r
.37153 .30664 m .42871 .28749 L .43624 .27709 L p F P
0 g
s
.932 .969 .741 r
.80434 .74285 m .80649 .71013 L .78601 .73717 L p F P
0 g
s
.932 .969 .741 r
.78601 .73717 m .78442 .76701 L .80434 .74285 L p F P
0 g
s
.416 .796 .991 r
.50505 .90216 m .5281 .90326 L .52781 .89505 L p F P
0 g
s
.451 .825 .991 r
.5281 .90326 m .55112 .90196 L .54354 .89416 L p F P
0 g
s
.451 .825 .991 r
.54354 .89416 m .52781 .89505 L .5281 .90326 L p F P
0 g
s
.562 .027 0 r
.61341 .27599 m .55481 .26729 L .55713 .27691 L p F P
0 g
s
.562 .027 0 r
.55713 .27691 m .62058 .28629 L .61341 .27599 L p F P
0 g
s
.395 .77 .992 r
.48292 .8987 m .50505 .90216 L .51206 .89429 L p F P
0 g
s
.416 .796 .991 r
.52781 .89505 m .51206 .89429 L .50505 .90216 L p F P
0 g
s
.111 .545 .915 r
.42047 .88412 m .40203 .87184 L .37502 .86433 L p F P
0 g
s
.047 .447 .876 r
.37502 .86433 m .35881 .84708 L .33117 .83332 L p F P
0 g
s
.213 .558 .935 r
.35881 .84708 m .37502 .86433 L .40203 .87184 L p F P
0 g
s
.498 .853 .992 r
.55112 .90196 m .57314 .89832 L .55855 .89165 L p F P
0 g
s
.498 .853 .992 r
.55855 .89165 m .54354 .89416 L .55112 .90196 L p F P
0 g
s
.287 .646 .968 r
.40203 .87184 m .42047 .88412 L .44511 .88532 L p F P
0 g
s
.239 .656 .96 r
.46264 .89302 m .44511 .88532 L .42047 .88412 L p F P
0 g
s
.722 .968 .935 r
.68087 .86298 m .69652 .84558 L .66614 .85654 L p F P
0 g
s
.722 .968 .935 r
.66614 .85654 m .65357 .87074 L .68087 .86298 L p F P
0 g
s
.646 .935 .968 r
.63553 .88319 m .65357 .87074 L .62418 .87507 L p F P
0 g
s
.646 .935 .968 r
.62418 .87507 m .61051 .88461 L .63553 .88319 L p F P
0 g
s
.059 0 0 r
.31036 .35044 m .36134 .32217 L .37153 .30664 L p F P
0 g
s
.194 0 .129 r
.36134 .32217 m .31036 .35044 L .29959 .37078 L p F P
0 g
s
0 0 .298 r
.21407 .52655 m .24101 .48622 L .24374 .45738 L p F P
0 g
s
.058 0 .426 r
.24101 .48622 m .21407 .52655 L .21498 .55635 L p F P
0 g
s
.391 .746 .992 r
.46264 .89302 m .48292 .8987 L .49697 .89192 L p F P
0 g
s
.395 .77 .992 r
.51206 .89429 m .49697 .89192 L .48292 .8987 L p F P
0 g
s
.552 .876 .992 r
.57314 .89832 m .59323 .89246 L .57221 .88764 L p F P
0 g
s
.552 .876 .992 r
.57221 .88764 m .55855 .89165 L .57314 .89832 L p F P
0 g
s
.819 .361 .139 r
.74018 .34785 m .6883 .32017 L .69645 .33932 L p F P
0 g
s
.819 .361 .139 r
.69645 .33932 m .75079 .36809 L .74018 .34785 L p F P
0 g
s
.295 0 .06 r
.42871 .28749 m .37153 .30664 L .36134 .32217 L p F P
0 g
s
.473 0 0 r
.55481 .26729 m .49454 .26766 L .49184 .27732 L p F P
0 g
s
.344 0 0 r
.42871 .28749 m .49184 .27732 L .49454 .26766 L p F P
0 g
s
.473 0 0 r
.49184 .27732 m .55713 .27691 L .55481 .26729 L p F P
0 g
s
0 .013 .537 r
.21794 .65595 m .22857 .61812 L .2198 .58701 L p F P
0 g
s
.067 .139 .631 r
.22857 .61812 m .21794 .65595 L .23078 .68482 L p F P
0 g
s
.062 .379 .843 r
.33117 .83332 m .32049 .81114 L .2939 .79142 L p F P
0 g
s
.197 .484 .897 r
.32049 .81114 m .33117 .83332 L .35881 .84708 L p F P
0 g
s
.987 .724 .435 r
.83862 .52313 m .81039 .48303 L .80957 .51371 L p F P
0 g
s
.987 .724 .435 r
.80957 .51371 m .83773 .553 L .83862 .52313 L p F P
0 g
s
.713 .219 .066 r
.67837 .30475 m .62058 .28629 L .62678 .30064 L p F P
0 g
s
.713 .219 .066 r
.62678 .30064 m .6883 .32017 L .67837 .30475 L p F P
0 g
s
.02 .232 .738 r
.27056 .76942 m .268 .73965 L .24752 .71286 L p F P
0 g
s
.138 .343 .804 r
.268 .73965 m .27056 .76942 L .2939 .79142 L p F P
0 g
s
.81 .978 .897 r
.72435 .83156 m .73431 .80925 L .70469 .82665 L p F P
0 g
s
.81 .978 .897 r
.70469 .82665 m .69652 .84558 L .72435 .83156 L p F P
0 g
s
.033 0 .153 r
.24991 .43067 m .29143 .39428 L .29959 .37078 L p F P
0 g
s
.147 0 .301 r
.29143 .39428 m .24991 .43067 L .24374 .45738 L p F P
0 g
s
.987 .885 .635 r
.83607 .65283 m .82421 .61503 L .81158 .64635 L p F P
0 g
s
.987 .885 .635 r
.81158 .64635 m .82322 .68188 L .83607 .65283 L p F P
0 g
s
.4 .726 .99 r
.44511 .88532 m .46264 .89302 L .48318 .88803 L p F P
0 g
s
.391 .746 .992 r
.49697 .89192 m .48318 .88803 L .46264 .89302 L p F P
0 g
s
.909 .966 .805 r
.78442 .76701 m .78601 .73717 L .76201 .76259 L p F P
0 g
s
.909 .966 .805 r
.76201 .76259 m .76099 .78926 L .78442 .76701 L p F P
0 g
s
.605 .891 .989 r
.59323 .89246 m .61051 .88461 L .58388 .88228 L p F P
0 g
s
.605 .891 .989 r
.58388 .88228 m .57221 .88764 L .59323 .89246 L p F P
0 g
s
.927 .563 .31 r
.80154 .42749 m .75884 .39153 L .76413 .41794 L p F P
0 g
s
.927 .563 .31 r
.76413 .41794 m .80767 .45418 L .80154 .42749 L p F P
0 g
s
.287 .646 .968 r
.44511 .88532 m .43112 .87591 L .40203 .87184 L p F P
0 g
s
.213 .558 .935 r
.40203 .87184 m .389 .85777 L .35881 .84708 L p F P
0 g
s
.344 .638 .963 r
.389 .85777 m .40203 .87184 L .43112 .87591 L p F P
0 g
s
.71 .933 .962 r
.65357 .87074 m .66614 .85654 L .63357 .86423 L p F P
0 g
s
.71 .933 .962 r
.63357 .86423 m .62418 .87507 L .65357 .87074 L p F P
0 g
s
.058 0 .426 r
.21498 .55635 m .24186 .51683 L .24101 .48622 L p F P
0 g
s
.152 .087 .524 r
.24186 .51683 m .21498 .55635 L .2198 .58701 L p F P
0 g
s
.067 .139 .631 r
.23078 .68482 m .24126 .64924 L .22857 .61812 L p F P
0 g
s
.161 .244 .702 r
.24126 .64924 m .23078 .68482 L .24752 .71286 L p F P
0 g
s
.197 .484 .897 r
.35881 .84708 m .35003 .82825 L .32049 .81114 L p F P
0 g
s
.309 .567 .93 r
.35003 .82825 m .35881 .84708 L .389 .85777 L p F P
0 g
s
.42 .709 .983 r
.43112 .87591 m .44511 .88532 L .47133 .88277 L p F P
0 g
s
.4 .726 .99 r
.48318 .88803 m .47133 .88277 L .44511 .88532 L p F P
0 g
s
.138 .343 .804 r
.2939 .79142 m .292 .76481 L .268 .73965 L p F P
0 g
s
.236 .433 .852 r
.292 .76481 m .2939 .79142 L .32049 .81114 L p F P
0 g
s
.653 .896 .982 r
.61051 .88461 m .62418 .87507 L .59304 .87579 L p F P
0 g
s
.653 .896 .982 r
.59304 .87579 m .58388 .88228 L .61051 .88461 L p F P
0 g
s
.451 .018 .123 r
.49184 .27732 m .42871 .28749 L .4222 .30191 L p F P
0 g
s
.295 0 .06 r
.36134 .32217 m .4222 .30191 L .42871 .28749 L p F P
0 g
s
.983 .763 .529 r
.83773 .553 m .80957 .51371 L .80511 .5458 L p F P
0 g
s
.983 .763 .529 r
.80511 .5458 m .83294 .58377 L .83773 .553 L p F P
0 g
s
.966 .896 .703 r
.82322 .68188 m .81158 .64635 L .79516 .67725 L p F P
0 g
s
.966 .896 .703 r
.79516 .67725 m .80649 .71013 L .82322 .68188 L p F P
0 g
s
.783 .949 .928 r
.69652 .84558 m .70469 .82665 L .67249 .84117 L p F P
0 g
s
.783 .949 .928 r
.67249 .84117 m .66614 .85654 L .69652 .84558 L p F P
0 g
s
.648 .179 .126 r
.62058 .28629 m .55713 .27691 L .55914 .29071 L p F P
0 g
s
.648 .179 .126 r
.55914 .29071 m .62678 .30064 L .62058 .28629 L p F P
0 g
s
.194 0 .129 r
.29959 .37078 m .35298 .3414 L .36134 .32217 L p F P
0 g
s
.29 0 .275 r
.35298 .3414 m .29959 .37078 L .29143 .39428 L p F P
0 g
s
.532 .807 .996 r
.51206 .89429 m .52781 .89505 L .52751 .88267 L p F P
0 g
s
.55 .821 .996 r
.52781 .89505 m .54354 .89416 L .53553 .88221 L p F P
0 g
s
.55 .821 .996 r
.53553 .88221 m .52751 .88267 L .52781 .89505 L p F P
0 g
s
.88 .953 .851 r
.76099 .78926 m .76201 .76259 L .73478 .78599 L p F P
0 g
s
.88 .953 .851 r
.73478 .78599 m .73431 .80925 L .76099 .78926 L p F P
0 g
s
.52 .791 .995 r
.49697 .89192 m .51206 .89429 L .51947 .88228 L p F P
0 g
s
.532 .807 .996 r
.52751 .88267 m .51947 .88228 L .51206 .89429 L p F P
0 g
s
.573 .834 .995 r
.54354 .89416 m .55855 .89165 L .54317 .88092 L p F P
0 g
s
.573 .834 .995 r
.54317 .88092 m .53553 .88221 L .54354 .89416 L p F P
0 g
s
.854 .454 .282 r
.75079 .36809 m .69645 .33932 L .70265 .36208 L p F P
0 g
s
.854 .454 .282 r
.70265 .36208 m .75884 .39153 L .75079 .36809 L p F P
0 g
s
.147 0 .301 r
.24374 .45738 m .28608 .42071 L .29143 .39428 L p F P
0 g
s
.234 .049 .413 r
.28608 .42071 m .24374 .45738 L .24101 .48622 L p F P
0 g
s
.513 .776 .991 r
.48318 .88803 m .49697 .89192 L .51178 .88106 L p F P
0 g
s
.52 .791 .995 r
.51947 .88228 m .51178 .88106 L .49697 .89192 L p F P
0 g
s
.388 .024 .22 r
.4222 .30191 m .36134 .32217 L .35298 .3414 L p F P
0 g
s
.598 .844 .991 r
.55855 .89165 m .57221 .88764 L .5501 .87886 L p F P
0 g
s
.598 .844 .991 r
.5501 .87886 m .54317 .88092 L .55855 .89165 L p F P
0 g
s
.936 .621 .419 r
.80767 .45418 m .76413 .41794 L .76648 .44703 L p F P
0 g
s
.936 .621 .419 r
.76648 .44703 m .81039 .48303 L .80767 .45418 L p F P
0 g
s
.764 .332 .225 r
.6883 .32017 m .62678 .30064 L .63188 .319 L p F P
0 g
s
.764 .332 .225 r
.63188 .319 m .69645 .33932 L .6883 .32017 L p F P
0 g
s
.563 .114 .143 r
.55713 .27691 m .49184 .27732 L .4895 .29115 L p F P
0 g
s
.451 .018 .123 r
.4222 .30191 m .4895 .29115 L .49184 .27732 L p F P
0 g
s
.563 .114 .143 r
.4895 .29115 m .55914 .29071 L .55713 .27691 L p F P
0 g
s
.161 .244 .702 r
.24752 .71286 m .25775 .67993 L .24126 .64924 L p F P
0 g
s
.24 .331 .757 r
.25775 .67993 m .24752 .71286 L .268 .73965 L p F P
0 g
s
.42 .709 .983 r
.47133 .88277 m .46195 .87636 L .43112 .87591 L p F P
0 g
s
.344 .638 .963 r
.43112 .87591 m .42137 .86516 L .389 .85777 L p F P
0 g
s
.447 .695 .972 r
.42137 .86516 m .43112 .87591 L .46195 .87636 L p F P
0 g
s
.514 .761 .986 r
.47133 .88277 m .48318 .88803 L .50479 .87906 L p F P
0 g
s
.513 .776 .991 r
.51178 .88106 m .50479 .87906 L .48318 .88803 L p F P
0 g
s
.152 .087 .524 r
.2198 .58701 m .24637 .54882 L .24186 .51683 L p F P
0 g
s
.227 .185 .6 r
.24637 .54882 m .2198 .58701 L .22857 .61812 L p F P
0 g
s
.236 .433 .852 r
.32049 .81114 m .31924 .78792 L .292 .76481 L p F P
0 g
s
.32 .509 .886 r
.31924 .78792 m .32049 .81114 L .35003 .82825 L p F P
0 g
s
.623 .849 .986 r
.57221 .88764 m .58388 .88228 L .55599 .87612 L p F P
0 g
s
.623 .849 .986 r
.55599 .87612 m .5501 .87886 L .57221 .88764 L p F P
0 g
s
.69 .891 .971 r
.62418 .87507 m .63357 .86423 L .59923 .86846 L p F P
0 g
s
.69 .891 .971 r
.59923 .86846 m .59304 .87579 L .62418 .87507 L p F P
0 g
s
.309 .567 .93 r
.389 .85777 m .38214 .84246 L .35003 .82825 L p F P
0 g
s
.4 .632 .948 r
.38214 .84246 m .389 .85777 L .42137 .86516 L p F P
0 g
s
.941 .898 .757 r
.80649 .71013 m .79516 .67725 L .77513 .70728 L p F P
0 g
s
.941 .898 .757 r
.77513 .70728 m .78601 .73717 L .80649 .71013 L p F P
0 g
s
.846 .934 .884 r
.73431 .80925 m .73478 .78599 L .70468 .80701 L p F P
0 g
s
.846 .934 .884 r
.70468 .80701 m .70469 .82665 L .73431 .80925 L p F P
0 g
s
.751 .915 .947 r
.66614 .85654 m .67249 .84117 L .63814 .85255 L p F P
0 g
s
.751 .915 .947 r
.63814 .85255 m .63357 .86423 L .66614 .85654 L p F P
0 g
s
.97 .788 .602 r
.83294 .58377 m .80511 .5458 L .797 .57886 L p F P
0 g
s
.97 .788 .602 r
.797 .57886 m .82421 .61503 L .83294 .58377 L p F P
0 g
s
.519 .748 .979 r
.46195 .87636 m .47133 .88277 L .49881 .87637 L p F P
0 g
s
.514 .761 .986 r
.50479 .87906 m .49881 .87637 L .47133 .88277 L p F P
0 g
s
.646 .85 .978 r
.58388 .88228 m .59304 .87579 L .56056 .87282 L p F P
0 g
s
.646 .85 .978 r
.56056 .87282 m .55599 .87612 L .58388 .88228 L p F P
0 g
s
.24 .331 .757 r
.268 .73965 m .27787 .70971 L .25775 .67993 L p F P
0 g
s
.306 .406 .8 r
.27787 .70971 m .268 .73965 L .292 .76481 L p F P
0 g
s
.29 0 .275 r
.29143 .39428 m .34664 .36421 L .35298 .3414 L p F P
0 g
s
.359 .103 .383 r
.34664 .36421 m .29143 .39428 L .28608 .42071 L p F P
0 g
s
.234 .049 .413 r
.24101 .48622 m .28372 .44978 L .28608 .42071 L p F P
0 g
s
.3 .146 .498 r
.28372 .44978 m .24101 .48622 L .24186 .51683 L p F P
0 g
s
.32 .509 .886 r
.35003 .82825 m .34936 .80863 L .31924 .78792 L p F P
0 g
s
.391 .573 .911 r
.34936 .80863 m .35003 .82825 L .38214 .84246 L p F P
0 g
s
.868 .519 .387 r
.75884 .39153 m .70265 .36208 L .70671 .38824 L p F P
0 g
s
.868 .519 .387 r
.70671 .38824 m .76413 .41794 L .75884 .39153 L p F P
0 g
s
.912 .895 .799 r
.78601 .73717 m .77513 .70728 L .75173 .73598 L p F P
0 g
s
.912 .895 .799 r
.75173 .73598 m .76201 .76259 L .78601 .73717 L p F P
0 g
s
.81 .911 .909 r
.70469 .82665 m .70468 .80701 L .67212 .82529 L p F P
0 g
s
.81 .911 .909 r
.67212 .82529 m .67249 .84117 L .70469 .82665 L p F P
0 g
s
.4 .632 .948 r
.42137 .86516 m .4164 .85353 L .38214 .84246 L p F P
0 g
s
.477 .684 .957 r
.4164 .85353 m .42137 .86516 L .45551 .86909 L p F P
0 g
s
.447 .695 .972 r
.46195 .87636 m .45551 .86909 L .42137 .86516 L p F P
0 g
s
.518 .141 .264 r
.4895 .29115 m .4222 .30191 L .41686 .32032 L p F P
0 g
s
.388 .024 .22 r
.35298 .3414 m .41686 .32032 L .4222 .30191 L p F P
0 g
s
.227 .185 .6 r
.22857 .61812 m .25456 .58173 L .24637 .54882 L p F P
0 g
s
.289 .266 .66 r
.25456 .58173 m .22857 .61812 L .24126 .64924 L p F P
0 g
s
.933 .662 .501 r
.81039 .48303 m .76648 .44703 L .76577 .47843 L p F P
0 g
s
.933 .662 .501 r
.76577 .47843 m .80957 .51371 L .81039 .48303 L p F P
0 g
s
.717 .878 .956 r
.63357 .86423 m .63814 .85255 L .60213 .86059 L p F P
0 g
s
.717 .878 .956 r
.60213 .86059 m .59923 .86846 L .63357 .86423 L p F P
0 g
s
.695 .286 .266 r
.62678 .30064 m .55914 .29071 L .56079 .30866 L p F P
0 g
s
.695 .286 .266 r
.56079 .30866 m .63188 .319 L .62678 .30064 L p F P
0 g
s
.519 .748 .979 r
.49881 .87637 m .49412 .87311 L .46195 .87636 L p F P
0 g
s
.529 .737 .97 r
.45551 .86909 m .46195 .87636 L .49412 .87311 L p F P
0 g
s
.666 .847 .969 r
.59304 .87579 m .59923 .86846 L .5636 .8691 L p F P
0 g
s
.666 .847 .969 r
.5636 .8691 m .56056 .87282 L .59304 .87579 L p F P
0 g
s
.601 .792 .972 r
.52719 .8661 m .51947 .88228 L .52751 .88267 L closepath p F P
0 g
s
.607 .796 .972 r
.52719 .8661 m .52751 .88267 L .53553 .88221 L closepath p F P
0 g
s
.597 .787 .971 r
.52719 .8661 m .51178 .88106 L .51947 .88228 L closepath p F P
0 g
s
.952 .804 .66 r
.82421 .61503 m .797 .57886 L .78529 .6124 L p F P
0 g
s
.952 .804 .66 r
.78529 .6124 m .81158 .64635 L .82421 .61503 L p F P
0 g
s
.613 .799 .971 r
.52719 .8661 m .53553 .88221 L .54317 .88092 L closepath p F P
0 g
s
.45 .134 .336 r
.41686 .32032 m .35298 .3414 L .34664 .36421 L p F P
0 g
s
.595 .782 .97 r
.52719 .8661 m .50479 .87906 L .51178 .88106 L closepath p F P
0 g
s
.619 .802 .969 r
.52719 .8661 m .54317 .88092 L .5501 .87886 L closepath p F P
0 g
s
.79 .412 .34 r
.69645 .33932 m .63188 .319 L .63576 .34126 L p F P
0 g
s
.79 .412 .34 r
.63576 .34126 m .70265 .36208 L .69645 .33932 L p F P
0 g
s
.306 .406 .8 r
.292 .76481 m .30137 .73814 L .27787 .70971 L p F P
0 g
s
.363 .47 .835 r
.30137 .73814 m .292 .76481 L .31924 .78792 L p F P
0 g
s
.391 .573 .911 r
.38214 .84246 m .38196 .8266 L .34936 .80863 L p F P
0 g
s
.453 .628 .928 r
.38196 .8266 m .38214 .84246 L .4164 .85353 L p F P
0 g
s
.594 .777 .967 r
.52719 .8661 m .49881 .87637 L .50479 .87906 L closepath p F P
0 g
s
.626 .803 .967 r
.52719 .8661 m .5501 .87886 L .55599 .87612 L closepath p F P
0 g
s
.772 .886 .927 r
.67249 .84117 m .67212 .82529 L .63757 .84056 L p F P
0 g
s
.772 .886 .927 r
.63757 .84056 m .63814 .85255 L .67249 .84117 L p F P
0 g
s
.881 .888 .833 r
.76201 .76259 m .75173 .73598 L .72529 .76288 L p F P
0 g
s
.881 .888 .833 r
.72529 .76288 m .73478 .78599 L .76201 .76259 L p F P
0 g
s
.615 .223 .277 r
.55914 .29071 m .4895 .29115 L .48758 .30911 L p F P
0 g
s
.518 .141 .264 r
.41686 .32032 m .48758 .30911 L .4895 .29115 L p F P
0 g
s
.615 .223 .277 r
.48758 .30911 m .56079 .30866 L .55914 .29071 L p F P
0 g
s
.477 .684 .957 r
.45551 .86909 m .45235 .86125 L .4164 .85353 L p F P
0 g
s
.542 .728 .96 r
.45235 .86125 m .45551 .86909 L .49095 .86942 L p F P
0 g
s
.529 .737 .97 r
.49412 .87311 m .49095 .86942 L .45551 .86909 L p F P
0 g
s
.594 .772 .965 r
.52719 .8661 m .49412 .87311 L .49881 .87637 L closepath p F P
0 g
s
.633 .803 .965 r
.52719 .8661 m .55599 .87612 L .56056 .87282 L closepath p F P
0 g
s
.681 .839 .959 r
.59923 .86846 m .60213 .86059 L .56496 .86514 L p F P
0 g
s
.681 .839 .959 r
.56496 .86514 m .5636 .8691 L .59923 .86846 L p F P
0 g
s
.289 .266 .66 r
.24126 .64924 m .26638 .6151 L .25456 .58173 L p F P
0 g
s
.34 .335 .708 r
.26638 .6151 m .24126 .64924 L .25775 .67993 L p F P
0 g
s
.3 .146 .498 r
.24186 .51683 m .28445 .48113 L .28372 .44978 L p F P
0 g
s
.352 .225 .565 r
.28445 .48113 m .24186 .51683 L .24637 .54882 L p F P
0 g
s
.453 .628 .928 r
.4164 .85353 m .41656 .84155 L .38196 .8266 L p F P
0 g
s
.508 .677 .941 r
.41656 .84155 m .4164 .85353 L .45235 .86125 L p F P
0 g
s
.363 .47 .835 r
.31924 .78792 m .32794 .76476 L .30137 .73814 L p F P
0 g
s
.413 .527 .864 r
.32794 .76476 m .31924 .78792 L .34936 .80863 L p F P
0 g
s
.596 .768 .962 r
.52719 .8661 m .49095 .86942 L .49412 .87311 L closepath p F P
0 g
s
.932 .815 .708 r
.81158 .64635 m .78529 .6124 L .77009 .64592 L p F P
0 g
s
.932 .815 .708 r
.77009 .64592 m .79516 .67725 L .81158 .64635 L p F P
0 g
s
.639 .802 .961 r
.52719 .8661 m .56056 .87282 L .5636 .8691 L closepath p F P
0 g
s
.359 .103 .383 r
.28608 .42071 m .34248 .39039 L .34664 .36421 L p F P
0 g
s
.41 .189 .465 r
.34248 .39039 m .28608 .42071 L .28372 .44978 L p F P
0 g
s
.925 .692 .566 r
.80957 .51371 m .76577 .47843 L .76193 .51173 L p F P
0 g
s
.925 .692 .566 r
.76193 .51173 m .80511 .5458 L .80957 .51371 L p F P
0 g
s
.733 .858 .94 r
.63814 .85255 m .63757 .84056 L .60153 .85256 L p F P
0 g
s
.733 .858 .94 r
.60153 .85256 m .60213 .86059 L .63814 .85255 L p F P
0 g
s
.849 .879 .862 r
.73478 .78599 m .72529 .76288 L .69618 .78758 L p F P
0 g
s
.849 .879 .862 r
.69618 .78758 m .70468 .80701 L .73478 .78599 L p F P
0 g
s
.871 .566 .467 r
.76413 .41794 m .70671 .38824 L .70852 .4175 L p F P
0 g
s
.871 .566 .467 r
.70852 .4175 m .76648 .44703 L .76413 .41794 L p F P
0 g
s
.542 .728 .96 r
.49095 .86942 m .48945 .86547 L .45235 .86125 L p F P
0 g
s
.599 .764 .958 r
.52719 .8661 m .48945 .86547 L .49095 .86942 L closepath p F P
0 g
s
.644 .8 .958 r
.52719 .8661 m .5636 .8691 L .56496 .86514 L closepath p F P
0 g
s
.508 .677 .941 r
.45235 .86125 m .45266 .85322 L .41656 .84155 L p F P
0 g
s
.557 .721 .95 r
.45266 .85322 m .45235 .86125 L .48945 .86547 L p F P
0 g
s
.692 .829 .949 r
.60213 .86059 m .60153 .85256 L .56455 .86112 L p F P
0 g
s
.692 .829 .949 r
.56455 .86112 m .56496 .86514 L .60213 .86059 L p F P
0 g
s
.413 .527 .864 r
.34936 .80863 m .35719 .78915 L .32794 .76476 L p F P
0 g
s
.458 .579 .888 r
.35719 .78915 m .34936 .80863 L .38196 .8266 L p F P
0 g
s
.34 .335 .708 r
.25775 .67993 m .28173 .6484 L .26638 .6151 L p F P
0 g
s
.384 .395 .749 r
.28173 .6484 m .25775 .67993 L .27787 .70971 L p F P
0 g
s
.561 .231 .365 r
.48758 .30911 m .41686 .32032 L .4128 .34261 L p F P
0 g
s
.45 .134 .336 r
.34664 .36421 m .4128 .34261 L .41686 .32032 L p F P
0 g
s
.815 .867 .886 r
.70468 .80701 m .69618 .78758 L .66484 .80967 L p F P
0 g
s
.815 .867 .886 r
.66484 .80967 m .67212 .82529 L .70468 .80701 L p F P
0 g
s
.722 .362 .367 r
.63188 .319 m .56079 .30866 L .56205 .33066 L p F P
0 g
s
.722 .362 .367 r
.56205 .33066 m .63576 .34126 L .63188 .319 L p F P
0 g
s
.557 .721 .95 r
.48945 .86547 m .48972 .86145 L .45266 .85322 L p F P
0 g
s
.603 .761 .955 r
.52719 .8661 m .48972 .86145 L .48945 .86547 L closepath p F P
0 g
s
.494 .217 .423 r
.4128 .34261 m .34664 .36421 L .34248 .39039 L p F P
0 g
s
.648 .797 .954 r
.52719 .8661 m .56496 .86514 L .56455 .86112 L closepath p F P
0 g
s
.909 .821 .748 r
.79516 .67725 m .77009 .64592 L .7516 .67889 L p F P
0 g
s
.909 .821 .748 r
.7516 .67889 m .77513 .70728 L .79516 .67725 L p F P
0 g
s
.458 .579 .888 r
.38196 .8266 m .38869 .81093 L .35719 .78915 L p F P
0 g
s
.499 .627 .908 r
.38869 .81093 m .38196 .8266 L .41656 .84155 L p F P
0 g
s
.352 .225 .565 r
.24637 .54882 m .28837 .51434 L .28445 .48113 L p F P
0 g
s
.393 .291 .619 r
.28837 .51434 m .24637 .54882 L .25456 .58173 L p F P
0 g
s
.802 .469 .425 r
.70265 .36208 m .63576 .34126 L .63831 .36722 L p F P
0 g
s
.802 .469 .425 r
.63831 .36722 m .70671 .38824 L .70265 .36208 L p F P
0 g
s
.651 .793 .951 r
.52719 .8661 m .56455 .86112 L .56239 .85722 L closepath p F P
0 g
s
.652 .789 .947 r
.52719 .8661 m .56239 .85722 L .55856 .85364 L closepath p F P
0 g
s
.652 .784 .944 r
.52719 .8661 m .55856 .85364 L .55322 .85054 L closepath p F P
0 g
s
.651 .779 .942 r
.52719 .8661 m .55322 .85054 L .54664 .84808 L closepath p F P
0 g
s
.649 .775 .94 r
.52719 .8661 m .54664 .84808 L .53911 .84638 L closepath p F P
0 g
s
.646 .77 .939 r
.52719 .8661 m .53911 .84638 L .531 .84553 L closepath p F P
0 g
s
.641 .766 .939 r
.52719 .8661 m .531 .84553 L .52271 .84557 L closepath p F P
0 g
s
.637 .763 .939 r
.52719 .8661 m .52271 .84557 L .51464 .84649 L closepath p F P
0 g
s
.631 .76 .94 r
.52719 .8661 m .51464 .84649 L .50717 .84826 L closepath p F P
0 g
s
.625 .759 .942 r
.52719 .8661 m .50717 .84826 L .50067 .85077 L closepath p F P
0 g
s
.62 .758 .945 r
.52719 .8661 m .50067 .85077 L .49545 .85392 L closepath p F P
0 g
s
.614 .758 .948 r
.52719 .8661 m .49545 .85392 L .49174 .85753 L closepath p F P
0 g
s
.608 .759 .951 r
.52719 .8661 m .49174 .85753 L .48972 .86145 L closepath p F P
0 g
s
.779 .852 .906 r
.67212 .82529 m .66484 .80967 L .63175 .82881 L p F P
0 g
s
.779 .852 .906 r
.63175 .82881 m .63757 .84056 L .67212 .82529 L p F P
0 g
s
.499 .627 .908 r
.41656 .84155 m .42196 .82976 L .38869 .81093 L p F P
0 g
s
.538 .673 .925 r
.42196 .82976 m .41656 .84155 L .45266 .85322 L p F P
0 g
s
.913 .714 .619 r
.80511 .5458 m .76193 .51173 L .75495 .54644 L p F P
0 g
s
.913 .714 .619 r
.75495 .54644 m .797 .57886 L .80511 .5458 L p F P
0 g
s
.574 .716 .939 r
.45649 .84537 m .45266 .85322 L .48972 .86145 L p F P
0 g
s
.574 .716 .939 r
.48972 .86145 m .49174 .85753 L .45649 .84537 L p F P
0 g
s
.698 .816 .938 r
.56239 .85722 m .56455 .86112 L .60153 .85256 L p F P
0 g
s
.538 .673 .925 r
.45266 .85322 m .45649 .84537 L .42196 .82976 L p F P
0 g
s
.74 .836 .924 r
.63757 .84056 m .63175 .82881 L .59742 .84474 L p F P
0 g
s
.74 .836 .924 r
.59742 .84474 m .60153 .85256 L .63757 .84056 L p F P
0 g
s
.384 .395 .749 r
.27787 .70971 m .3004 .68114 L .28173 .6484 L p F P
0 g
s
.422 .449 .783 r
.3004 .68114 m .27787 .70971 L .30137 .73814 L p F P
0 g
s
.698 .816 .938 r
.60153 .85256 m .59742 .84474 L .56239 .85722 L p F P
0 g
s
.41 .189 .465 r
.28372 .44978 m .34063 .41964 L .34248 .39039 L p F P
0 g
s
.448 .258 .529 r
.34063 .41964 m .28372 .44978 L .28445 .48113 L p F P
0 g
s
.648 .303 .374 r
.56079 .30866 m .48758 .30911 L .48612 .33112 L p F P
0 g
s
.561 .231 .365 r
.4128 .34261 m .48612 .33112 L .48758 .30911 L p F P
0 g
s
.648 .303 .374 r
.48612 .33112 m .56205 .33066 L .56079 .30866 L p F P
0 g
s
.886 .825 .782 r
.77513 .70728 m .7516 .67889 L .73007 .71079 L p F P
0 g
s
.886 .825 .782 r
.73007 .71079 m .75173 .73598 L .77513 .70728 L p F P
0 g
s
.59 .714 .93 r
.46372 .83807 m .45649 .84537 L .49174 .85753 L p F P
0 g
s
.59 .714 .93 r
.49174 .85753 m .49545 .85392 L .46372 .83807 L p F P
0 g
s
.7 .803 .929 r
.55856 .85364 m .56239 .85722 L .59742 .84474 L p F P
0 g
s
.869 .601 .53 r
.76648 .44703 m .70852 .4175 L .70798 .44951 L p F P
0 g
s
.869 .601 .53 r
.70798 .44951 m .76577 .47843 L .76648 .44703 L p F P
0 g
s
.422 .449 .783 r
.30137 .73814 m .32213 .71278 L .3004 .68114 L p F P
0 g
s
.455 .498 .814 r
.32213 .71278 m .30137 .73814 L .32794 .76476 L p F P
0 g
s
.393 .291 .619 r
.25456 .58173 m .29547 .54892 L .28837 .51434 L p F P
0 g
s
.428 .347 .663 r
.29547 .54892 m .25456 .58173 L .26638 .6151 L p F P
0 g
s
.607 .715 .921 r
.47405 .8317 m .46372 .83807 L .49545 .85392 L p F P
0 g
s
.607 .715 .921 r
.49545 .85392 m .50067 .85077 L .47405 .8317 L p F P
0 g
s
.7 .803 .929 r
.59742 .84474 m .58993 .83751 L .55856 .85364 L p F P
0 g
s
.698 .788 .921 r
.55322 .85054 m .55856 .85364 L .58993 .83751 L p F P
0 g
s
.861 .826 .812 r
.75173 .73598 m .73007 .71079 L .70583 .74109 L p F P
0 g
s
.861 .826 .812 r
.70583 .74109 m .72529 .76288 L .75173 .73598 L p F P
0 g
s
.566 .672 .91 r
.43248 .81875 m .42196 .82976 L .45649 .84537 L p F P
0 g
s
.566 .672 .91 r
.45649 .84537 m .46372 .83807 L .43248 .81875 L p F P
0 g
s
.74 .812 .909 r
.58993 .83751 m .59742 .84474 L .63175 .82881 L p F P
0 g
s
.9 .731 .663 r
.797 .57886 m .75495 .54644 L .74488 .58204 L p F P
0 g
s
.9 .731 .663 r
.74488 .58204 m .78529 .6124 L .797 .57886 L p F P
0 g
s
.455 .498 .814 r
.32794 .76476 m .34661 .74281 L .32213 .71278 L p F P
0 g
s
.486 .543 .841 r
.34661 .74281 m .32794 .76476 L .35719 .78915 L p F P
0 g
s
.623 .718 .914 r
.487 .82658 m .47405 .8317 L .50067 .85077 L p F P
0 g
s
.623 .718 .914 r
.50067 .85077 m .50717 .84826 L .487 .82658 L p F P
0 g
s
.698 .788 .921 r
.58993 .83751 m .57938 .83123 L .55322 .85054 L p F P
0 g
s
.693 .774 .914 r
.54664 .84808 m .55322 .85054 L .57938 .83123 L p F P
0 g
s
.541 .63 .889 r
.40223 .79621 m .38869 .81093 L .42196 .82976 L p F P
0 g
s
.541 .63 .889 r
.42196 .82976 m .43248 .81875 L .40223 .79621 L p F P
0 g
s
.494 .217 .423 r
.34248 .39039 m .41013 .36858 L .4128 .34261 L p F P
0 g
s
.525 .283 .49 r
.41013 .36858 m .34248 .39039 L .34063 .41964 L p F P
0 g
s
.835 .826 .839 r
.72529 .76288 m .70583 .74109 L .67925 .76933 L p F P
0 g
s
.835 .826 .839 r
.67925 .76933 m .69618 .78758 L .72529 .76288 L p F P
0 g
s
.591 .299 .442 r
.48612 .33112 m .4128 .34261 L .41013 .36858 L p F P
0 g
s
.486 .543 .841 r
.35719 .78915 m .37346 .77077 L .34661 .74281 L p F P
0 g
s
.514 .587 .866 r
.37346 .77077 m .35719 .78915 L .38869 .81093 L p F P
0 g
s
.775 .819 .887 r
.62083 .8179 m .63175 .82881 L .66484 .80967 L p F P
0 g
s
.74 .812 .909 r
.63175 .82881 m .62083 .8179 L .58993 .83751 L p F P
0 g
s
.514 .587 .866 r
.38869 .81093 m .40223 .79621 L .37346 .77077 L p F P
0 g
s
.736 .418 .443 r
.63576 .34126 m .56205 .33066 L .56288 .35652 L p F P
0 g
s
.736 .418 .443 r
.56288 .35652 m .63831 .36722 L .63576 .34126 L p F P
0 g
s
.807 .513 .491 r
.70671 .38824 m .63831 .36722 L .63944 .39661 L p F P
0 g
s
.807 .513 .491 r
.63944 .39661 m .70852 .4175 L .70671 .38824 L p F P
0 g
s
.638 .723 .909 r
.50195 .82297 m .487 .82658 L .50717 .84826 L p F P
0 g
s
.638 .723 .909 r
.50717 .84826 m .51464 .84649 L .50195 .82297 L p F P
0 g
s
.693 .774 .914 r
.57938 .83123 m .56624 .82622 L .54664 .84808 L p F P
0 g
s
.686 .761 .909 r
.53911 .84638 m .54664 .84808 L .56624 .82622 L p F P
0 g
s
.806 .823 .864 r
.69618 .78758 m .67925 .76933 L .65077 .79507 L p F P
0 g
s
.806 .823 .864 r
.65077 .79507 m .66484 .80967 L .69618 .78758 L p F P
0 g
s
.775 .819 .887 r
.66484 .80967 m .65077 .79507 L .62083 .8179 L p F P
0 g
s
.448 .258 .529 r
.28445 .48113 m .34121 .4516 L .34063 .41964 L p F P
0 g
s
.478 .315 .581 r
.34121 .4516 m .28445 .48113 L .28837 .51434 L p F P
0 g
s
.652 .73 .906 r
.51818 .82108 m .50195 .82297 L .51464 .84649 L p F P
0 g
s
.652 .73 .906 r
.51464 .84649 m .52271 .84557 L .51818 .82108 L p F P
0 g
s
.686 .761 .909 r
.56624 .82622 m .55116 .82275 L .53911 .84638 L p F P
0 g
s
.676 .749 .906 r
.531 .84553 m .53911 .84638 L .55116 .82275 L p F P
0 g
s
.428 .347 .663 r
.26638 .6151 m .30571 .58436 L .29547 .54892 L p F P
0 g
s
.457 .397 .702 r
.30571 .58436 m .26638 .6151 L .28173 .6484 L p F P
0 g
s
.592 .674 .897 r
.44771 .80909 m .43248 .81875 L .46372 .83807 L p F P
0 g
s
.592 .674 .897 r
.46372 .83807 m .47405 .8317 L .44771 .80909 L p F P
0 g
s
.665 .738 .905 r
.53486 .82101 m .51818 .82108 L .52271 .84557 L p F P
0 g
s
.665 .738 .905 r
.52271 .84557 m .531 .84553 L .53486 .82101 L p F P
0 g
s
.676 .749 .906 r
.55116 .82275 m .53486 .82101 L .531 .84553 L p F P
0 g
s
.734 .789 .896 r
.57938 .83123 m .58993 .83751 L .62083 .8179 L p F P
0 g
s
.864 .629 .581 r
.76577 .47843 m .70798 .44951 L .70502 .48381 L p F P
0 g
s
.864 .629 .581 r
.70502 .48381 m .76193 .51173 L .76577 .47843 L p F P
0 g
s
.885 .744 .701 r
.78529 .6124 m .74488 .58204 L .73184 .61796 L p F P
0 g
s
.885 .744 .701 r
.73184 .61796 m .77009 .64592 L .78529 .6124 L p F P
0 g
s
.668 .363 .448 r
.56205 .33066 m .48612 .33112 L .48516 .35699 L p F P
0 g
s
.591 .299 .442 r
.41013 .36858 m .48516 .35699 L .48612 .33112 L p F P
0 g
s
.668 .363 .448 r
.48516 .35699 m .56288 .35652 L .56205 .33066 L p F P
0 g
s
.457 .397 .702 r
.28173 .6484 m .31897 .6201 L .30571 .58436 L p F P
0 g
s
.482 .442 .736 r
.31897 .6201 m .28173 .6484 L .3004 .68114 L p F P
0 g
s
.617 .679 .887 r
.46698 .8013 m .44771 .80909 L .47405 .8317 L p F P
0 g
s
.617 .679 .887 r
.47405 .8317 m .487 .82658 L .46698 .8013 L p F P
0 g
s
.577 .635 .872 r
.4221 .78324 m .40223 .79621 L .43248 .81875 L p F P
0 g
s
.577 .635 .872 r
.43248 .81875 m .44771 .80909 L .4221 .78324 L p F P
0 g
s
.734 .789 .896 r
.62083 .8179 m .60525 .80837 L .57938 .83123 L p F P
0 g
s
.725 .767 .886 r
.56624 .82622 m .57938 .83123 L .60525 .80837 L p F P
0 g
s
.765 .787 .871 r
.60525 .80837 m .62083 .8179 L .65077 .79507 L p F P
0 g
s
.869 .755 .735 r
.77009 .64592 m .73184 .61796 L .71601 .65362 L p F P
0 g
s
.869 .755 .735 r
.71601 .65362 m .7516 .67889 L .77009 .64592 L p F P
0 g
s
.478 .315 .581 r
.28837 .51434 m .34426 .48583 L .34121 .4516 L p F P
0 g
s
.502 .363 .624 r
.34426 .48583 m .28837 .51434 L .29547 .54892 L p F P
0 g
s
.525 .283 .49 r
.34063 .41964 m .40896 .39796 L .41013 .36858 L p F P
0 g
s
.549 .336 .543 r
.40896 .39796 m .34063 .41964 L .34121 .4516 L p F P
0 g
s
.482 .442 .736 r
.3004 .68114 m .33507 .65555 L .31897 .6201 L p F P
0 g
s
.505 .483 .766 r
.33507 .65555 m .3004 .68114 L .32213 .71278 L p F P
0 g
s
.561 .597 .847 r
.39764 .7545 m .37346 .77077 L .40223 .79621 L p F P
0 g
s
.561 .597 .847 r
.40223 .79621 m .4221 .78324 L .39764 .7545 L p F P
0 g
s
.64 .688 .879 r
.48934 .7958 m .46698 .8013 L .487 .82658 L p F P
0 g
s
.64 .688 .879 r
.487 .82658 m .50195 .82297 L .48934 .7958 L p F P
0 g
s
.808 .547 .544 r
.70852 .4175 m .63944 .39661 L .63911 .42904 L p F P
0 g
s
.808 .547 .544 r
.63911 .42904 m .70798 .44951 L .70852 .4175 L p F P
0 g
s
.725 .767 .886 r
.60525 .80837 m .58571 .80075 L .56624 .82622 L p F P
0 g
s
.712 .746 .879 r
.55116 .82275 m .56624 .82622 L .58571 .80075 L p F P
0 g
s
.856 .651 .624 r
.76193 .51173 m .70502 .48381 L .69966 .51991 L p F P
0 g
s
.856 .651 .624 r
.69966 .51991 m .75495 .54644 L .76193 .51173 L p F P
0 g
s
.611 .352 .501 r
.48516 .35699 m .41013 .36858 L .40896 .39796 L p F P
0 g
s
.791 .783 .846 r
.63042 .78227 m .65077 .79507 L .67925 .76933 L p F P
0 g
s
.765 .787 .871 r
.65077 .79507 m .63042 .78227 L .60525 .80837 L p F P
0 g
s
.852 .764 .765 r
.7516 .67889 m .71601 .65362 L .69763 .68844 L p F P
0 g
s
.852 .764 .765 r
.69763 .68844 m .73007 .71079 L .7516 .67889 L p F P
0 g
s
.745 .462 .502 r
.63831 .36722 m .56288 .35652 L .56326 .38596 L p F P
0 g
s
.745 .462 .502 r
.56326 .38596 m .63944 .39661 L .63831 .36722 L p F P
0 g
s
.505 .483 .766 r
.32213 .71278 m .35375 .69014 L .33507 .65555 L p F P
0 g
s
.525 .522 .795 r
.35375 .69014 m .32213 .71278 L .34661 .74281 L p F P
0 g
s
.543 .56 .821 r
.37472 .7233 m .34661 .74281 L .37346 .77077 L p F P
0 g
s
.543 .56 .821 r
.37346 .77077 m .39764 .7545 L .37472 .7233 L p F P
0 g
s
.525 .522 .795 r
.34661 .74281 m .37472 .7233 L .35375 .69014 L p F P
0 g
s
.661 .699 .874 r
.51367 .79291 m .48934 .7958 L .50195 .82297 L p F P
0 g
s
.661 .699 .874 r
.50195 .82297 m .51818 .82108 L .51367 .79291 L p F P
0 g
s
.712 .746 .879 r
.58571 .80075 m .56315 .79546 L .55116 .82275 L p F P
0 g
s
.697 .728 .874 r
.53486 .82101 m .55116 .82275 L .56315 .79546 L p F P
0 g
s
.813 .778 .82 r
.65448 .75328 m .67925 .76933 L .70583 .74109 L p F P
0 g
s
.791 .783 .846 r
.67925 .76933 m .65448 .75328 L .63042 .78227 L p F P
0 g
s
.833 .772 .793 r
.73007 .71079 m .69763 .68844 L .67701 .72184 L p F P
0 g
s
.833 .772 .793 r
.67701 .72184 m .70583 .74109 L .73007 .71079 L p F P
0 g
s
.609 .644 .859 r
.44743 .77273 m .4221 .78324 L .44771 .80909 L p F P
0 g
s
.609 .644 .859 r
.44771 .80909 m .46698 .8013 L .44743 .77273 L p F P
0 g
s
.813 .778 .82 r
.70583 .74109 m .67701 .72184 L .65448 .75328 L p F P
0 g
s
.75 .757 .859 r
.58571 .80075 m .60525 .80837 L .63042 .78227 L p F P
0 g
s
.68 .712 .873 r
.53871 .79279 m .51367 .79291 L .51818 .82108 L p F P
0 g
s
.68 .712 .873 r
.51818 .82108 m .53486 .82101 L .53871 .79279 L p F P
0 g
s
.697 .728 .874 r
.56315 .79546 m .53871 .79279 L .53486 .82101 L p F P
0 g
s
.502 .363 .624 r
.29547 .54892 m .34979 .52183 L .34426 .48583 L p F P
0 g
s
.523 .406 .661 r
.34979 .52183 m .29547 .54892 L .30571 .58436 L p F P
0 g
s
.848 .67 .661 r
.75495 .54644 m .69966 .51991 L .69192 .55723 L p F P
0 g
s
.848 .67 .661 r
.69192 .55723 m .74488 .58204 L .75495 .54644 L p F P
0 g
s
.681 .41 .505 r
.56288 .35652 m .48516 .35699 L .48474 .38643 L p F P
0 g
s
.611 .352 .501 r
.40896 .39796 m .48474 .38643 L .48516 .35699 L p F P
0 g
s
.681 .41 .505 r
.48474 .38643 m .56326 .38596 L .56288 .35652 L p F P
0 g
s
.549 .336 .543 r
.34121 .4516 m .40933 .43037 L .40896 .39796 L p F P
0 g
s
.567 .38 .587 r
.40933 .43037 m .34121 .4516 L .34426 .48583 L p F P
0 g
s
.639 .655 .85 r
.47699 .76529 m .44743 .77273 L .46698 .8013 L p F P
0 g
s
.639 .655 .85 r
.46698 .8013 m .48934 .7958 L .47699 .76529 L p F P
0 g
s
.601 .61 .833 r
.4287 .74126 m .39764 .7545 L .4221 .78324 L p F P
0 g
s
.601 .61 .833 r
.4221 .78324 m .44743 .77273 L .4287 .74126 L p F P
0 g
s
.806 .575 .588 r
.70798 .44951 m .63911 .42904 L .63726 .46407 L p F P
0 g
s
.806 .575 .588 r
.63726 .46407 m .70502 .48381 L .70798 .44951 L p F P
0 g
s
.75 .757 .859 r
.63042 .78227 m .60471 .77199 L .58571 .80075 L p F P
0 g
s
.732 .731 .85 r
.56315 .79546 m .58571 .80075 L .60471 .77199 L p F P
0 g
s
.77 .747 .832 r
.60471 .77199 m .63042 .78227 L .65448 .75328 L p F P
0 g
s
.523 .406 .661 r
.30571 .58436 m .35775 .55902 L .34979 .52183 L p F P
0 g
s
.54 .444 .695 r
.35775 .55902 m .30571 .58436 L .31897 .6201 L p F P
0 g
s
.626 .396 .55 r
.48474 .38643 m .40896 .39796 L .40933 .43037 L p F P
0 g
s
.75 .497 .55 r
.63944 .39661 m .56326 .38596 L .56315 .41861 L p F P
0 g
s
.75 .497 .55 r
.56315 .41861 m .63911 .42904 L .63944 .39661 L p F P
0 g
s
.838 .686 .694 r
.74488 .58204 m .69192 .55723 L .68192 .59516 L p F P
0 g
s
.838 .686 .694 r
.68192 .59516 m .73184 .61796 L .74488 .58204 L p F P
0 g
s
.665 .67 .845 r
.50925 .76137 m .47699 .76529 L .48934 .7958 L p F P
0 g
s
.665 .67 .845 r
.48934 .7958 m .51367 .79291 L .50925 .76137 L p F P
0 g
s
.732 .731 .85 r
.60471 .77199 m .57488 .76483 L .56315 .79546 L p F P
0 g
s
.712 .708 .845 r
.53871 .79279 m .56315 .79546 L .57488 .76483 L p F P
0 g
s
.591 .577 .807 r
.4111 .70738 m .37472 .7233 L .39764 .7545 L p F P
0 g
s
.591 .577 .807 r
.39764 .7545 m .4287 .74126 L .4111 .70738 L p F P
0 g
s
.788 .737 .806 r
.62293 .74034 m .65448 .75328 L .67701 .72184 L p F P
0 g
s
.77 .747 .832 r
.65448 .75328 m .62293 .74034 L .60471 .77199 L p F P
0 g
s
.54 .444 .695 r
.31897 .6201 m .36804 .5968 L .35775 .55902 L p F P
0 g
s
.555 .479 .725 r
.36804 .5968 m .31897 .6201 L .33507 .65555 L p F P
0 g
s
.69 .687 .843 r
.54248 .76122 m .50925 .76137 L .51367 .79291 L p F P
0 g
s
.69 .687 .843 r
.51367 .79291 m .53871 .79279 L .54248 .76122 L p F P
0 g
s
.712 .708 .845 r
.57488 .76483 m .54248 .76122 L .53871 .79279 L p F P
0 g
s
.827 .7 .724 r
.73184 .61796 m .68192 .59516 L .6698 .63306 L p F P
0 g
s
.827 .7 .724 r
.6698 .63306 m .71601 .65362 L .73184 .61796 L p F P
0 g
s
.567 .38 .587 r
.34426 .48583 m .41129 .46535 L .40933 .43037 L p F P
0 g
s
.582 .418 .625 r
.41129 .46535 m .34426 .48583 L .34979 .52183 L p F P
0 g
s
.58 .545 .78 r
.39494 .67161 m .35375 .69014 L .37472 .7233 L p F P
0 g
s
.58 .545 .78 r
.37472 .7233 m .4111 .70738 L .39494 .67161 L p F P
0 g
s
.636 .625 .823 r
.46513 .73188 m .4287 .74126 L .44743 .77273 L p F P
0 g
s
.636 .625 .823 r
.44743 .77273 m .47699 .76529 L .46513 .73188 L p F P
0 g
s
.555 .479 .725 r
.33507 .65555 m .3805 .63454 L .36804 .5968 L p F P
0 g
s
.568 .513 .753 r
.3805 .63454 m .33507 .65555 L .35375 .69014 L p F P
0 g
s
.803 .598 .625 r
.70502 .48381 m .63726 .46407 L .6339 .50116 L p F P
0 g
s
.803 .598 .625 r
.6339 .50116 m .69966 .51991 L .70502 .48381 L p F P
0 g
s
.803 .725 .779 r
.64004 .70626 m .67701 .72184 L .69763 .68844 L p F P
0 g
s
.788 .737 .806 r
.67701 .72184 m .64004 .70626 L .62293 .74034 L p F P
0 g
s
.748 .716 .822 r
.57488 .76483 m .60471 .77199 L .62293 .74034 L p F P
0 g
s
.568 .513 .753 r
.35375 .69014 m .39494 .67161 L .3805 .63454 L p F P
0 g
s
.69 .448 .551 r
.56326 .38596 m .48474 .38643 L .48488 .41907 L p F P
0 g
s
.626 .396 .55 r
.40933 .43037 m .48488 .41907 L .48474 .38643 L p F P
0 g
s
.816 .713 .752 r
.71601 .65362 m .6698 .63306 L .65576 .6703 L p F P
0 g
s
.816 .713 .752 r
.65576 .6703 m .69763 .68844 L .71601 .65362 L p F P
0 g
s
.69 .448 .551 r
.48488 .41907 m .56315 .41861 L .56326 .38596 L p F P
0 g
s
.803 .725 .779 r
.69763 .68844 m .65576 .6703 L .64004 .70626 L p F P
0 g
s
.637 .433 .59 r
.48488 .41907 m .40933 .43037 L .41129 .46535 L p F P
0 g
s
.752 .527 .59 r
.63911 .42904 m .56315 .41861 L .56256 .45401 L p F P
0 g
s
.752 .527 .59 r
.56256 .45401 m .63726 .46407 L .63911 .42904 L p F P
0 g
s
.667 .643 .817 r
.50499 .72692 m .46513 .73188 L .47699 .76529 L p F P
0 g
s
.667 .643 .817 r
.47699 .76529 m .50925 .76137 L .50499 .72692 L p F P
0 g
s
.582 .418 .625 r
.34979 .52183 m .41483 .50237 L .41129 .46535 L p F P
0 g
s
.594 .453 .658 r
.41483 .50237 m .34979 .52183 L .35775 .55902 L p F P
0 g
s
.748 .716 .822 r
.62293 .74034 m .58615 .73129 L .57488 .76483 L p F P
0 g
s
.723 .688 .817 r
.54248 .76122 m .57488 .76483 L .58615 .73129 L p F P
0 g
s
.632 .597 .796 r
.45395 .69605 m .4111 .70738 L .4287 .74126 L p F P
0 g
s
.632 .597 .796 r
.4287 .74126 m .46513 .73188 L .45395 .69605 L p F P
0 g
s
.799 .619 .658 r
.69966 .51991 m .6339 .50116 L .62907 .53971 L p F P
0 g
s
.799 .619 .658 r
.62907 .53971 m .69192 .55723 L .69966 .51991 L p F P
0 g
s
.76 .701 .796 r
.58615 .73129 m .62293 .74034 L .64004 .70626 L p F P
0 g
s
.696 .664 .815 r
.5461 .72672 m .50499 .72692 L .50925 .76137 L p F P
0 g
s
.696 .664 .815 r
.50925 .76137 m .54248 .76122 L .5461 .72672 L p F P
0 g
s
.723 .688 .817 r
.58615 .73129 m .5461 .72672 L .54248 .76122 L p F P
0 g
s
.594 .453 .658 r
.35775 .55902 m .41993 .54084 L .41483 .50237 L p F P
0 g
s
.604 .484 .689 r
.41993 .54084 m .35775 .55902 L .36804 .5968 L p F P
0 g
s
.696 .48 .591 r
.56315 .41861 m .48488 .41907 L .4856 .45445 L p F P
0 g
s
.637 .433 .59 r
.41129 .46535 m .4856 .45445 L .48488 .41907 L p F P
0 g
s
.626 .569 .77 r
.44367 .65839 m .39494 .67161 L .4111 .70738 L p F P
0 g
s
.626 .569 .77 r
.4111 .70738 m .45395 .69605 L .44367 .65839 L p F P
0 g
s
.696 .48 .591 r
.4856 .45445 m .56256 .45401 L .56315 .41861 L p F P
0 g
s
.793 .637 .688 r
.69192 .55723 m .62907 .53971 L .62283 .57908 L p F P
0 g
s
.793 .637 .688 r
.62283 .57908 m .68192 .59516 L .69192 .55723 L p F P
0 g
s
.771 .686 .769 r
.59676 .69535 m .64004 .70626 L .65576 .6703 L p F P
0 g
s
.76 .701 .796 r
.64004 .70626 m .59676 .69535 L .58615 .73129 L p F P
0 g
s
.645 .465 .625 r
.4856 .45445 m .41129 .46535 L .41483 .50237 L p F P
0 g
s
.752 .552 .625 r
.63726 .46407 m .56256 .45401 L .56148 .49161 L p F P
0 g
s
.752 .552 .625 r
.56148 .49161 m .6339 .50116 L .63726 .46407 L p F P
0 g
s
.668 .618 .79 r
.50098 .69007 m .45395 .69605 L .46513 .73188 L p F P
0 g
s
.668 .618 .79 r
.46513 .73188 m .50499 .72692 L .50098 .69007 L p F P
0 g
s
.604 .484 .689 r
.36804 .5968 m .42651 .58012 L .41993 .54084 L p F P
0 g
s
.613 .513 .717 r
.42651 .58012 m .36804 .5968 L .3805 .63454 L p F P
0 g
s
.731 .67 .79 r
.5461 .72672 m .58615 .73129 L .59676 .69535 L p F P
0 g
s
.62 .541 .744 r
.43447 .61953 m .3805 .63454 L .39494 .67161 L p F P
0 g
s
.62 .541 .744 r
.39494 .67161 m .44367 .65839 L .43447 .61953 L p F P
0 g
s
.613 .513 .717 r
.3805 .63454 m .43447 .61953 L .42651 .58012 L p F P
0 g
s
.787 .654 .716 r
.68192 .59516 m .62283 .57908 L .61527 .61859 L p F P
0 g
s
.787 .654 .716 r
.61527 .61859 m .6698 .63306 L .68192 .59516 L p F P
0 g
s
.779 .67 .743 r
.60653 .65757 m .65576 .6703 L .6698 .63306 L p F P
0 g
s
.771 .686 .769 r
.65576 .6703 m .60653 .65757 L .59676 .69535 L p F P
0 g
s
.779 .67 .743 r
.6698 .63306 m .61527 .61859 L .60653 .65757 L p F P
0 g
s
.701 .642 .788 r
.54951 .68983 m .50098 .69007 L .50499 .72692 L p F P
0 g
s
.701 .642 .788 r
.50499 .72692 m .5461 .72672 L .54951 .68983 L p F P
0 g
s
.731 .67 .79 r
.59676 .69535 m .54951 .68983 L .5461 .72672 L p F P
0 g
s
.645 .465 .625 r
.41483 .50237 m .48688 .49203 L .4856 .45445 L p F P
0 g
s
.652 .494 .656 r
.48688 .49203 m .41483 .50237 L .41993 .54084 L p F P
0 g
s
.701 .509 .625 r
.56256 .45401 m .4856 .45445 L .48688 .49203 L p F P
0 g
s
.751 .575 .656 r
.6339 .50116 m .56148 .49161 L .55992 .5308 L p F P
0 g
s
.751 .575 .656 r
.55992 .5308 m .62907 .53971 L .6339 .50116 L p F P
0 g
s
.701 .509 .625 r
.48688 .49203 m .56148 .49161 L .56256 .45401 L p F P
0 g
s
.667 .594 .764 r
.49728 .6514 m .44367 .65839 L .45395 .69605 L p F P
0 g
s
.667 .594 .764 r
.45395 .69605 m .50098 .69007 L .49728 .6514 L p F P
0 g
s
.738 .651 .764 r
.54951 .68983 m .59676 .69535 L .60653 .65757 L p F P
0 g
s
.652 .494 .656 r
.41993 .54084 m .48872 .53119 L .48688 .49203 L p F P
0 g
s
.657 .521 .685 r
.48872 .53119 m .41993 .54084 L .42651 .58012 L p F P
0 g
s
.665 .57 .738 r
.49397 .61157 m .43447 .61953 L .44367 .65839 L p F P
0 g
s
.665 .57 .738 r
.44367 .65839 m .49728 .6514 L .49397 .61157 L p F P
0 g
s
.749 .595 .685 r
.62907 .53971 m .55992 .5308 L .55791 .57091 L p F P
0 g
s
.749 .595 .685 r
.55791 .57091 m .62283 .57908 L .62907 .53971 L p F P
0 g
s
.703 .621 .762 r
.55266 .65112 m .49728 .6514 L .50098 .69007 L p F P
0 g
s
.703 .621 .762 r
.50098 .69007 m .54951 .68983 L .55266 .65112 L p F P
0 g
s
.738 .651 .764 r
.60653 .65757 m .55266 .65112 L .54951 .68983 L p F P
0 g
s
.743 .633 .738 r
.55266 .65112 m .60653 .65757 L .61527 .61859 L p F P
0 g
s
.657 .521 .685 r
.42651 .58012 m .4911 .57127 L .48872 .53119 L p F P
0 g
s
.662 .546 .712 r
.4911 .57127 m .42651 .58012 L .43447 .61953 L p F P
0 g
s
.703 .534 .656 r
.56148 .49161 m .48688 .49203 L .48872 .53119 L p F P
0 g
s
.662 .546 .712 r
.43447 .61953 m .49397 .61157 L .4911 .57127 L p F P
0 g
s
.703 .534 .656 r
.48872 .53119 m .55992 .5308 L .56148 .49161 L p F P
0 g
s
.746 .615 .712 r
.62283 .57908 m .55791 .57091 L .55547 .61125 L p F P
0 g
s
.746 .615 .712 r
.55547 .61125 m .61527 .61859 L .62283 .57908 L p F P
0 g
s
.743 .633 .738 r
.61527 .61859 m .55547 .61125 L .55266 .65112 L p F P
0 g
s
.705 .6 .737 r
.55547 .61125 m .49397 .61157 L .49728 .6514 L p F P
0 g
s
.705 .6 .737 r
.49728 .6514 m .55266 .65112 L .55547 .61125 L p F P
0 g
s
.705 .557 .684 r
.55992 .5308 m .48872 .53119 L .4911 .57127 L p F P
0 g
s
.705 .557 .684 r
.4911 .57127 m .55791 .57091 L .55992 .5308 L p F P
0 g
s
.705 .579 .711 r
.55791 .57091 m .4911 .57127 L .49397 .61157 L p F P
0 g
s
.705 .579 .711 r
.49397 .61157 m .55547 .61125 L .55791 .57091 L p F P
0 g
s
.25 Mabswid
.67201 0 m
.92712 .41514 L
s
.92712 .41514 m
1 .9504 L
s
1 .9504 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.08845 .24527 m
0 .80562 L
s
0 .80562 m
.70587 .58762 L
s
.70587 .58762 m
.67201 0 L
s
.67201 0 m
.08845 .24527 L
s
.08845 .24527 m
.67201 0 L
s
.10049 .2402 m
.10558 .24544 L
s
[(-1)] .09032 .22973 .97141 1 Mshowa
.22885 .18626 m
.23368 .19173 L
s
[(-0.5)] .21918 .17532 .88404 1 Mshowa
.36426 .12934 m
.36881 .13505 L
s
[(0)] .35517 .11792 .79667 1 Mshowa
.50734 .06921 m
.51156 .07516 L
s
[(0.5)] .49889 .0573 .7093 1 Mshowa
.65874 .00557 m
.6626 .01177 L
s
[(1)] .65103 -0.00682 .62194 1 Mshowa
.125 Mabswid
.12563 .22964 m
.12865 .23281 L
s
.15102 .21896 m
.15402 .22216 L
s
.17669 .20818 m
.17965 .2114 L
s
.20263 .19728 m
.20556 .20053 L
s
.25535 .17512 m
.25822 .17843 L
s
.28213 .16386 m
.28497 .1672 L
s
.30921 .15248 m
.31201 .15585 L
s
.33659 .14097 m
.33935 .14437 L
s
.39224 .11758 m
.39494 .12104 L
s
.42054 .10569 m
.42319 .10917 L
s
.44915 .09367 m
.45176 .09718 L
s
.47808 .08151 m
.48065 .08505 L
s
.53693 .05677 m
.53942 .06037 L
s
.56686 .04419 m
.56931 .04782 L
s
.59714 .03147 m
.59954 .03513 L
s
.62776 .0186 m
.63012 .02229 L
s
.25 Mabswid
0 .80562 m
.40056 1.08777 L
s
.01109 .81342 m
.0122 .80621 L
s
[(-1)] .00886 .82785 .15416 -1 Mshowa
.1222 .89169 m
.12306 .88445 L
s
[(-0.5)] .12049 .90619 .11814 -1 Mshowa
.22187 .9619 m
.22251 .95463 L
s
[(0)] .22061 .97645 .08721 -1 Mshowa
.31178 1.02524 m
.31222 1.01795 L
s
[(0.5)] .3109 1.03981 .06036 -1 Mshowa
.3933 1.08266 m
.39357 1.07536 L
s
[(1)] .39276 1.09724 .03682 -1 Mshowa
.125 Mabswid
.03432 .82979 m
.03495 .82546 L
s
.05703 .84579 m
.05763 .84145 L
s
.07924 .86143 m
.07981 .85709 L
s
.10095 .87673 m
.1015 .87238 L
s
.14299 .90634 m
.14348 .90199 L
s
.16334 .92067 m
.1638 .91632 L
s
.18326 .93471 m
.18369 .93035 L
s
.20277 .94845 m
.20318 .94409 L
s
.24059 .97509 m
.24095 .97072 L
s
.25893 .988 m
.25926 .98364 L
s
.2769 1.00066 m
.27721 .99629 L
s
.29451 1.01307 m
.2948 1.0087 L
s
.32872 1.03717 m
.32896 1.03279 L
s
.34533 1.04887 m
.34555 1.04449 L
s
.36162 1.06034 m
.36183 1.05597 L
s
.37761 1.0716 m
.37779 1.06723 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{264.75, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006=0001[b000`400?l00000o`00003oo`3ooon>
0?ooo`00o`3oool30?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0PP3oool00?l0
oooo1P3oool00`2jLW80^^[o0?ooo`250?ooo`00o`3oool60?ooo`030;YbLP2jj_l0oooo08D0oooo
003o0?ooo`H0oooo00<0^W9b0;[Zo`3oool0Q@3oool00?l0oooo1P3oool00`2jLW80^^[o0?ooo`25
0?ooo`00o`3oool60?ooo`030;YbLP2jj_l0oooo08D0oooo003o0?ooo`H0oooo00<0^W9b0;[Zo`3o
ool0Q@3oool00?l0oooo0`3oool01@3Z^W800000001b^P2jLW80^^[o08H0oooo003o0?ooo`D0oooo
00<0j[Yb0000LP2jj_l0QP3oool00?l0ooooSP3oool00?l0ooooSP3oool00?l0ooooSP3oool00?l0
ooooSP3oool00?l0ooooSP3oool00?l0ooooSP3oool00?l0oooo403oool2000007`0oooo003o0?oo
o`h0oooo0P0000000`3oool000000000001k0?ooo`00o`3oool;0?ooo`<000000`3oool2000007/0
oooo003o0?ooo`T0oooo0P0000000`3oool000000?ooo`030?ooo`030000003oool0000007X0oooo
003o0?ooo`L0oooo0P0000040?ooo`070000003oool0oooo0?ooo`000000oooo0000001j0?ooo`00
o`3oool40?ooo`<000002P3oool010000000oooo0?ooo`00001i0?ooo`00o`3oool010000000oooo
00000000000=0?ooo`050000003oool0oooo0?ooo`000000N03oool00?h0oooo0`00000?0?ooo`05
0000003oool0oooo0?ooo`000000N03oool00?`0oooo0P0000020?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1e0?ooo`00^`3oool01@3o/5d00000
000000000000GK3o00D0oooo00<0/5d000000000GK001@3oool01@2`G@000000000000000000GK3o
02P0oooo0P00000E0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0M03oool00;/0
oooo00H0R39M0;3oo`3oool0oon`05d0G@2`ool40?ooo`030;1M0000000005f`00@0oooo00L0/5d0
001M/03oool0oooo0?oGR00b0000GK3o02@0oooo0`00000G0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0M03oool00;X0oooo00<0ok1M001M/03oool00P3oool00`3GR380<XSG0?oo
o`0?0?ooo`030?n`G@00GK00oooo0200oooo0`00000J0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0L`3oool00;X0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0?
0?ooo`030?n`G@00GK00oooo01h0oooo1000000K0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0L`3oool00;X0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0?0?oo
o`0308Pb001M/?l0oooo01`0oooo0P00000O0?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0LP3oool00;X0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0:0?ooo`03
0?oo/01M000000000080000000<0<XSG0?ooo`3oool06P3oool200000240oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1a0?ooo`00^P3oool00`3o/5d0<XSG0?ooo`020?ooo`030=N8
<P0bR=L0oooo00X0oooo00<0oon`05d0G@2`ool0703oool3000002<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`1a0?ooo`00^`3oool01P28<P00GK3o0?ooo`3oehP0<P1M0;3oo`/0
oooo00<0oon`05d0G@2`ool06P3oool2000002H0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`1`0?ooo`00^`3oool01@3ook00G@00000000000380R=Oo00`0oooo00<0oon`05d00000
00000P0000000`0005d0/?oo0?ooo`0B0?ooo`<0000000<0oooo0000003oool09@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo0700oooo003T0?ooo`800000:`3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo06l0oooo003R0?ooo`800000;@3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo06h0oooo003N0?ooo`@00000;`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo06h0oooo003M0?ooo`800000<P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo06d0oooo003J0?ooo`<000000P3oool00`000000oooo0?ooo`0_0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0K03oool00=P0oooo0P00000g0?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0K03oool00=H0oooo0P00000i0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0J`3oool00=<0oooo0`00000k0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0J`3oool00=40oooo0P0000000`3oool000000?ooo`0k0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0JP3oool00<h0oooo0`0000040?ooo`03
0000003oool0oooo03X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1Y0?ooo`00
c03oool2000004@0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1Y0?ooo`00b@3o
ool3000004H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1X0?ooo`00a`3oool3
000004P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1X0?ooo`00UP3oool01@3o
/5d00000000000000000GK3o02X0oooo0P0000030?ooo`030000003oool0oooo04D0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`1W0?ooo`00UP3oool01P28<Ud0/?oo0?ooo`3ook00
G@1M0;3oobH0oooo0`00001=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0IP3o
ool009D0oooo00<0ok1M001M/03oool00P3oool00`3GR380<XSG0?ooo`0S0?ooo`800000D03oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo06H0oooo002E0?ooo`030=N8<P0bR=L0oooo
0080oooo00<0ok1M001M/03oool08@3oool200000580oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`1U0?ooo`00U@3oool00`3GR380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo01h0
oooo0`0000000`3oool000000?ooo`1A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool0I03oool009D0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0L0?ooo`800000
E`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo06@0oooo002E0?ooo`030?n`G@0b
R=L0oooo0080oooo00<0ehPb03:8e`3oool06@3oool3000005T0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`1S0?ooo`00UP3oool01P28<P00GK3o0?ooo`3oehP0<P1M0;3ooaP0oooo
0P00001L0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0H`3oool009H0oooo00D0
oon`05d000000000000b08SGo`0G0?ooo`<00000G@3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo0680oooo002_0?ooo`<000000`3oool00`000000oooo0?ooo`1J0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool0H@3oool00:d0oooo0P00001S0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0H@3oool00:X0oooo0`00001U0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0H03oool00:P0oooo0P00001X0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0H03oool00:H0oooo0P0000020?ooo`030000003oool0oooo06D0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1O0?ooo`00X`3oool3000006d0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`1N0?ooo`00X@3oool200000700oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`1N0?ooo`00WP3oool300000780oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`1M0?ooo`00W03oool200000080oooo00<000000?ooo`3o
ool0L03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo05`0oooo002I0?ooo`<00000
1@3oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
G03oool009L0oooo0P00001j0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0F`3o
ool009D0oooo0P00001l0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0F`3oool0
05<0oooo00D0ok1M000000000000000005f`o`050?ooo`030;1M0000000005f`00D0oooo00D0/5d0
000000000000000005f`o`0X0?ooo`<0000000<0oooo0000003oool0N`3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo05X0oooo001C0?ooo`0608PbG@2`ool0oooo0?oo/01M05d0/?oo
103oool00`2`G@000000001M/0040?ooo`070;1M0000GK00oooo0?ooo`3oehP0<P0005f`o`0U0?oo
o`800000P@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo05T0oooo001B0?ooo`03
0?n`G@00GK00oooo0080oooo00<0ehPb03:8e`3oool03`3oool00`3o/5d005f`0?ooo`0Q0?ooo`<0
0000P`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo05T0oooo001B0?ooo`030=N8
<P0bR=L0oooo0080oooo00<0ok1M001M/03oool03`3oool00`3o/5d005f`0?ooo`0O0?ooo`800000
QP3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo05P0oooo00190?ooo`0308Pb0000
0000000000<0000000D003:80?ooo`3oool0ehPb03:8e`030?ooo`030?n`G@00GK00oooo00l0oooo
00<0R38005f`o`3oool07@3oool3000008L0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`1H0?ooo`00DP3oool00`3GR380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00X0oooo00<0
oon`05d0000000000P0000000`0bR=L0oooo0?ooo`0J0?ooo`<000000`3oool00`000000oooo0?oo
o`240?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0E`3oool00580oooo00<0ok1M
03:8e`3oool00P3oool00`3GR380<XSG0?ooo`0:0?ooo`030?oo/01M05d0/?oo01d0oooo0P00002=
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0EP3oool005<0oooo00H0R38005f`
o`3oool0omN80380G@2`ool;0?ooo`030?oo/01M05d0/?oo01X0oooo0`00002?0?ooo`030000003o
ool0oooo01h0oooo00<000000?ooo`3oool0EP3oool005<0oooo00D0oon`05d000000000000b08SG
o`0<0?ooo`030?oo/01M000000000080000000<0001M0;3oo`3oool04`3oool300000940oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`1E0?ooo`00O@3oool2000000<0oooo00<00000
0?ooo`3oool0SP3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo05@0oooo001j0?oo
o`<00000UP3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo05@0oooo001h0?ooo`80
0000VP3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo05<0oooo001e0?ooo`<00000
W03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo05<0oooo001c0?ooo`8000000`3o
ool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0DP3o
ool00740oooo0P00002Q0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0D@3oool0
06h0oooo0`00002S0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0D@3oool006`0
oooo0`00002U0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0D03oool006T0oooo
0`0000020?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`1@0?ooo`00I`3oool2000000H0oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo04l0oooo001U0?ooo`800000[@3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo04h0oooo000c0?ooo`030?n`G@000000000000<0000000<005f`0?oo
o`3oool09P3oool300000:l0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1>0?oo
o`00=P3oool00`28<S80R=Oo0?ooo`0W0?ooo`8000000`3oool00`000000oooo0?ooo`2/0?ooo`03
0000003oool0oooo02H0oooo00<000000?ooo`3oool0C@3oool003H0oooo00<0R38b08SGo`3oool0
903oool300000;@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`1<0?ooo`00=P3o
ool00`28<S80R=Oo0?ooo`0R0?ooo`800000]`3oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo04`0oooo000Z0?ooo`0308Pb00000000000000<0000000<003:80?ooo`3oool00`3oool0
0`28<S80R=Oo0?ooo`0P0?ooo`800000^@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo04/0oooo000f0?ooo`0308Pb<P28eol0oooo01d0oooo0`0000020?ooo`800000]`3oool00`00
0000oooo0?ooo`0X0?ooo`030000003oool0oooo04/0oooo000f0?ooo`0308Pb<P28eol0oooo01/0
oooo0P00002n0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0BP3oool003<0oooo
00D0ehPb00000000<XP0R38b08SGo`0I0?ooo`<00000`03oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo04T0oooo000e0?ooo`030=N8<P000380R=Oo01L0oooo0`0000320?ooo`030000
003oool0oooo02X0oooo00<000000?ooo`3oool0B@3oool004d0oooo0P0000030?ooo`030000003o
ool0oooo0<00oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`180?ooo`00BP3oool3
00000<P0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`170?ooo`00B03oool20000
0</0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`170?ooo`00A@3oool400000<`0
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`160?ooo`00@`3oool2000000@0oooo
00<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo04H0oooo
00110?ooo`800000dP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo04D0oooo000n
0?ooo`<00000e03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo04@0oooo000l0?oo
o`80000000<0oooo0000003oool0e03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
04@0oooo000j0?ooo`800000103oool00`000000oooo0?ooo`3B0?ooo`030000003oool0oooo02l0
oooo00<000000?ooo`3oool0@`3oool003X0oooo0P00003I0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0@`3oool003X0oooo00<000000?ooo`000000f03oool00`000000oooo0?oo
o`0`0?ooo`030000003oool0oooo0480oooo000j0?ooo`040000003oool0000000000=L0oooo00<0
00000?ooo`3oool0<@3oool00`000000oooo0?ooo`110?ooo`00>@3oool300000080oooo00<00000
0?ooo`3oool0e03oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0440oooo000i0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0d`3oool00`000000oooo0?ooo`0b0?oo
o`030000003oool0oooo0400oooo000i0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0S03ooolI000002d0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0o0?ooo`00
;@3oool00`3oe9/000000000000300000003002Ke03oool0oooo00<0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`250?oooa8000002@1B000010000000J00006P0001X0008000002D0
oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0o0?ooo`00<03oool00`2jLW80^^[o
0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0OP3oool9000000<0;@00
00<000000580001B00002@1B000=000000H0J0002000000O0?ooo`030000003oool0oooo03@0oooo
00<000000?ooo`3oool0?P3oool00300oooo00<0^W9b0;[Zo`3oool01P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo07T0oooo2000000502d000l000002P1i00000`000000S`H008l6
0005000000X0J0000P00000L0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0?P3o
ool00300oooo00<0^W9b0;[Zo`3oool01@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo07D0oooo1@00000402d000L000000`1H00000`000000N@0007T0000C07T000030000002?1P00
S`H000D0S`H01P00000506P000@000006P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0
oooo03d0oooo000T0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2j
LW80^^[o0?ooo`050?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0L@3oool<0000
00T0F00000<0000007T0001i00005@1i00000`000000S`H008l6000:08l600D0000000@0J0000000
001`0000L0001000000F0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0?03oool0
0300oooo00<0^W9b0;[Zo`3oool01@3oool00`000000oooo0000000;0?ooo`030000003oool0oooo
06`0oooo2000000?05P001h000003P2?1P04000000<0L0001000000C0?ooo`030000003oool0oooo
03D0oooo00<000000?ooo`3oool0?03oool00300oooo00<0^W9b0;[Zo`3oool01@3oool2000000d0
oooo00<000000?ooo`3oool0J03oool50000000302L000000000F00000`0F0001P00000207<47`03
0000002@7B@0T1dT01D0T1dT00@000000:D]802U;B00YBdP2000000908l600@000000`1`00040000
0100oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0k0?ooo`00;@3oool01@3Z^W80
0000001b^P2jLW80^^[o00H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1T0?oo
o`H000000`0W00000`000000F00005P0000505P000H00000201c11l00`000000T1dT090M900E090M
90030000002U;B00YBdP00T0YBdP2000000208l600030000002L3P00W0h000@000000P1`00030000
00h0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0k0?ooo`00;`3oool00`3Z^W80
001b0;[Zo`060?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0H@3oool5000000D0
9`0000<0000005P0001H00001P00000=07<47`030000002@7B@0T1dT01H0T1dT00<000000:D]802U
;B004@2U;B05000000@0W0h00`000003070000030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0j0?ooo`00>03oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo05d0oooo1000000802L000@000004`1c11l00`000000T1dT090M900F090M90030000
002U;B00YBdP01@0YBdP00<000000;Hh400000000P00000409`>00<0000000<0L000000000000000
2P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo03T0oooo000g0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0FP3oool3000000P09`000P0000000`1;00l0000007<4
7`0B07<47b000000502U;B0010000000]SP@0;Hh402f>103000000@0W0h01@0000080?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool0>@3oool003L0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`1G0?ooo`800000200W0003000000<0B`0?00<0000007<47`1c11l02`1c
11l6000000<0Q2A300<0000009diAP2M>DH05P2M>DH010000000/DU40;59A02aBD@6000000h0YBdP
00<000000;Hh402f>100102f>103000000H0W0h00P0000060?ooo`030000003oool0oooo03T0oooo
00<000000?ooo`3oool0>03oool003L0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?oo
o`1D0?ooo`8000001`0W0003000000D0B`0?00<0000007<47`1c11l01P1c11l6000000T0Q2A300<0
000009diAP2M>DH05P2M>DH00`000000/DU40;59A0070;59A0H00000202U;B000`000000]SP@0;Hh
40070;Hh40<00000102L3P03000000@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?oo
o`0g0?ooo`00=`3oool2000001D0oooo00<000000?ooo`3oool0DP3oool2000000D09`000`000008
04/03`030000001c11l0L`@O00H000003`2494<00`000000WCU609diAP0F09diAP030000002aBD@0
/DU400d0/DU41P0000030:D]80030000002f>100]SP@00T0]SP@0`00000209`>00@000000P3oool0
0`000000oooo0?ooo`0j0?ooo`030000003oool0oooo03L0oooo000g0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0C`3oool4000000809`000`00000904/03`D00000502494<00`00
0000WCU609diAP0H09diAP030000002aBD@0/DU40180/DU41@00000=0;Hh40@0000000<0V`T00000
000000000P00000m0?ooo`030000003oool0oooo03H0oooo000g0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0C03oool8000000T0B`0?0`0000000`1S1SP0000008@T@`0F08@T@`03
0000002M>DH0WCU601P0WCU600<000000;59A02aBD@05@2aBD@00`000000`e@i00000002000000h0
]SP@00<0000009/9002K2@000`00000l0?ooo`030000003oool0oooo03H0oooo000f0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0B@3oool7000000T0B`0?0`00000306<6>0030000
002494<0Q2A301H0Q2A300<0000009diAP2M>DH0602M>DH00`000000/DU40;59A00F0;59A0040000
0033E3T0`e@i0<=D>@@000002`2f>1020000000409/9000000000000000003`0oooo00<000000?oo
o`3oool0=@3oool003H0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`170?ooo`H0
0000201;00l3000000H0H`Hh00<0000008@T@`2494<04`2494<S000001@0/DU400<000000<=D>@33
E3T01@33E3T3000000P0]SP@00D000000;hi00000000000009/90003000003/0oooo00<000000?oo
o`3oool0=03oool003H0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`140?ooo`L0
00001@1;00l4000000T0H`Hh00<0000008@T@`2494<03@2494<6000000<0Sc]M00<000000:E=G`2U
CEl0602UCEl00`000000^5aM0;QLG@020;QLG@P00000302aBD@00`000000`e@i0<=D>@080<=D>@<0
00001P2f>1000`000000_ST0000000020000000309/900000000000003X0oooo00<000000?ooo`3o
ool0=03oool003H0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`120?ooo`D00000
0P0?00000`000000B`0?04/03`03000000d0H`Hh00<0000008@T@`2494<01P2494<7000000T0Sc]M
00<000000:E=G`2UCEl0602UCEl00`000000^5aM0;QLG@0:0;QLG@T00000102aBD@00`000000`e@i
0<=D>@0:0<=D>@@000000`2f>10200000080_ST00P0000000`2K2@0000000000000i0?ooo`030000
003oool0oooo03<0oooo000f0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0?`3o
ool5000000<03`001000000?06<6>0040000002494<0Q2A308@T@`H00000402?>ed00`000000YDeO
0:E=G`0H0:E=G`030000002hG5d0^5aM01<0^5aM1P00000?0<=D>@D00000102n>@0010000000V`T0
09/90000000h0?ooo`030000003oool0oooo03<0oooo000f0?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool0?@3oool4000000@03`000P00000A06<6>0D000005P2?>ed00`000000YDeO
0:E=G`0H0:E=G`030000002hG5d0^5aM01L0^5aM00<000000<YYE`0000000P00000@0<=D>@800000
102n>@020000000309/900000000oooo03L0oooo00<000000?ooo`3oool0<P3oool003D0oooo00<0
00000?ooo`0000007`3oool00`000000oooo0?ooo`0k0?ooo`@000000`0?00000`000000<@0Q0000
000?06<6>0<0000000<0Lb9F0000002?>ed0602?>ed00`000000YDeO0:E=G`0H0:E=G`030000002h
G5d0^5aM01L0^5aM00<000000<YYE`3:JEL00P3:JEL3000000d0`e@i0`0000050;hi00<00000>03o
ool00`000000oooo0?ooo`0a0?ooo`00=@3oool200000240oooo00<000000?ooo`3oool0>@3oool3
000000<03`000P0000000`0a0240000006<6>00<06<6>0<00000101c8UH00`000000Sc]M08lkG@0G
08lkG@030000002UCEl0YDeO01P0YDeO00<000000;QLG@2hG5d05`2hG5d00`000000bVUG0<YYE`05
0<YYE`<000002`33E3T010000000dE`S0000000000050;hi00<00000=P3oool00`000000oooo0?oo
o`0a0?ooo`00=@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03L0oooo0`000003
00l0008000000`0a02400`000000H`Hh06<6>00806<6>0<000001`1c8UH00`000000Sc]M08lkG@0G
08lkG@030000002UCEl0YDeO01P0YDeO00<000000;QLG@2hG5d05`2hG5d00`000000bVUG0<YYE`08
0<YYE`<000002033E3T010000000dE`S0=5L8`3AG2<2000000D0_ST00P00000f0?ooo`030000003o
ool0oooo0300oooo000e0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0=@3oool2
000000@03`0000<0000003408@0a02400P0a02400`000000H`Hh06<6>00706<6>08000002@1c8UH0
0`000000Sc]M08lkG@0E08lkGB<000005P2hG5d00`000000bVUG0<YYE`0:0<YYE`<000001@33E3T2
000000@0dE`S0P0000050;hi00030000003oool0oooo03@0oooo00<000000?ooo`3oool0;`3oool0
03D0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0c0?ooo`030000000?00003`00
00803`000P00000503408@030000001S1SP0H`Hh00@0H`Hh0`00000;07<REP030000002?>ed0Sc]M
00h0Sc]M1`00000309M<L@030000002[G780Zeab01P0Zeab00<000000;a[L@2lJg400P2lJg490000
00d0^5aM00<000000<YYE`3:JEL03@3:JEL300000080`e@i0P0000060=5L8`800000102n>@000`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo02l0oooo000e0?ooo`030000003oool0oooo02<0
oooo00<000000?ooo`3oool0<@3oool0100000003`0000l0000?0002000000L0<@0Q00@0000006<6
>01S1SP0H`Hh0`00000>07<REP030000002?>ed0Sc]M00P0Sc]M1P00000:09M<L@030000002[G780
Zeab01P0Zeab00<000000;a[L@2lJg402`2lJg49000000@0^5aM00<000000<YYE`3:JEL0403:JEL3
000000030<=D>@000000dE`S00H0dE`S0P0000030;hi00800000=03oool00`000000oooo0?ooo`0^
0?ooo`00=@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02l0oooo00D0000000l0
000?00003`000000000803408@030000001S1SP00000008000004@1c8UH010000000Sc]M08lkG@2?
>ed700000100Udaa00<000000:]LLP2[G780602[G7800`000000_6]a0;a[L@0D0;a[L@H000004`3:
JEL3000000T0dE`S0P000000102n>@0000000;4]0000000c0?ooo`030000003oool0oooo02h0oooo
000d0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0;03oool2000000803`000P00
000903408@8000004`1c8UH5000001L0Udaa00<000000:]LLP2[G780602[G7800`000000_6]a0;a[
L@0H0;a[L@030000003=N6`0000000800000403:JEL00`000000bVUG00000002000000T0dE`S0`00
00000`2a;@0000000?ooo`0b0?ooo`030000003oool0oooo02d0oooo000d0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0:P3oool5000000T0<@0Q00<0000004X0AP0000004@1c8UH3
0000000307hgK0000000Udaa01P0Udaa00<000000:]LLP2[G7806P2[G7800`000000_6]a0;a[L@0G
0;a[L@030000003=N6`0cGQ/0080cGQ/0`00000=0<YYE`030000003:JEL000000080fWA80P000009
0=5L8`80000000<0/Bd00000003oool0<P3oool00`000000oooo0?ooo`0/0?ooo`00=03oool30000
02P0oooo00<000000?ooo`3oool0:03oool4000000T0<@0Q0P0000000`1:04H0000007<REP0>07<R
EP<00000101n=f`00`000000Udaa09M<L@0G09M<L@030000002[G780Zeab01X0Zeab00<000000;a[
L@2lJg405`2lJg400`000000cGQ/0<ehK0050<ehK0<000002P3:JEL010000000bVUG0<YYE`000003
0=YdB08000002@3AG2<010000000/Bd000000000000a0?ooo`030000003oool0oooo02`0oooo000d
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool09P3oool3000000T0<@0Q0P000003
04X0AP030000001c8UH0Lb9F00X0Lb9F0`00000707hgK0030000002GC740Udaa01L0Udaa00<00000
0:]LLP2[G7806P2[G7800`000000_6]a0;a[L@0G0;a[L@030000003=N6`0cGQ/00P0cGQ/10000006
0<YYE`040000003:JEL0bVUG000000D0fWA80P0000070=5L8`8000000P2a;@000`000000oooo0?oo
o`0_0?ooo`030000003oool0oooo02/0oooo000d0?ooo`030000003oool0oooo02X0oooo00<00000
0?ooo`3oool0903oool3000000P0<@0Q0P00000504X0AP030000001c8UH0Lb9F00L0Lb9F0`00000:
07hgK0030000002GC740Udaa01L0Udaa00<000000:]LLP2[G7806P2[G7800`000000_6]a0;a[L@0G
0;a[L@030000003=N6`0cGQ/00`0cGQ/0`0000030<YYE`040000003:JEL0bVUG000000L0fWA80P00
00060=5L8`8000000P2a;@000`000000oooo0?ooo`0^0?ooo`030000003oool0oooo02/0oooo000d
0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool08@3oool5000000H0<@0Q0P000007
04X0AP030000001c8UH0Lb9F00@0Lb9F0`00000<07hgK0030000002GC740Udaa01D0Udaa9000000G
0;a[L@030000003=N6`0cGQ/00h0cGQ/100000020<YYE`030000003JM4P0fWA800L0fWA80P000004
0=5L8`050000003CF@0000000000002a;@000P00000_0?ooo`030000003oool0oooo02X0oooo000c
0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool07`3oool5000000D0<@0Q0P000008
04X0AP030000001c8UH0Lb9F0080Lb9F0`00000?07hgK0030000002GC740Udaa00h0Udaa1`000003
09aJP0030000002^J840[VR101X0[VR100@000000;ifP02nMX00_WJ01`00000@0;a[L@030000003=
N6`0cGQ/0140cGQ/0`0000000`3:JEL000000=YdB0090=YdB08000000`3AG2<010000000deT00==I
000000020;4]00030000003oool0oooo02d0oooo00<000000?ooo`3oool0:@3oool003<0oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`0M0?ooo`H000000`0a0242000000X0BP1600<0
000007<REP0000000P00000B07hgK0030000002GC740Udaa00P0Udaa1P00000:09aJP0030000002^
J840[VR101X0[VR100<000000;ifP02nMX00202nMX06000000X0_6]a00<000000<ehK03=N6`04@3=
N6`00`000000cGQ/0<ehK002000000`0fWA80P0000000`3AG2<000000==I00020==I00040000002a
;@00/Bd0000002h0oooo00<000000?ooo`3oool0:@3oool003<0oooo00<000000?ooo`3oool0;`3o
ool00`000000oooo0?ooo`0K0?ooo`H000000P0a0242000000`0BP160P00000E07hgK0040000002G
C740Udaa09M<L@L00000402LFX000`000000[VR10:iXP@0J0:iXP@030000002nMX00_WJ000h0_WJ0
1`0000030;a[L@030000003=N6`0cGQ/0140cGQ/00@000000<ehK03=N6`0cGQ/0`00000<0=YdB0<0
00000`3CF@0010000000/Bd00;4]0000000^0?ooo`030000003oool0oooo02P0oooo000c0?ooo`03
0000003oool0oooo0300oooo00<000000?ooo`3oool06@3oool9000000`0BP1600<0000005/JHP00
00005@1n=f`5000001L0W5Z000<000000:iXP@2^J8406P2^J8400`000000_WJ00;ifP00E0;ifP0D0
00004P3=N6`01@000000cGQ/0<ehK03=N6`000000080gXAS0P00000<0=YdB0030000003CF@00deT0
0080deT000<000000;4]00000000;`3oool00`000000oooo0?ooo`0W0?ooo`00<`3oool00`000000
oooo0000000a0?ooo`030000003oool0oooo01L0oooo2000000<04X0AP8000000P1K6V800`000000
OSM/07hgK00@07hgK0<0000000<0QTQm0000002LFX006@2LFX000`000000[VR10:iXP@0J0:iXP@03
0000002nMX00_WJ001P0_WJ000<000000<j3O@0000000P00000@0<ehK0040000003=N6`0cGQ/0000
00@0gXAS0P00000:0=YdB0800000103CF@000`000000/Bd00000000^0?ooo`030000003oool0oooo
02L0oooo000c0?ooo`800000<`3oool00`000000oooo0?ooo`0E0?ooo`P000002`1:04H2000000<0
FaYR00<0000007hgK01n=f`03P1n=f`3000000@0QTQm00<0000009aJP02LFX00602LFX000`000000
[VR10:iXP@0J0:iXP@030000002nMX00_WJ001P0_WJ000<000000<j3O@3>Pgd00P3>Pgd3000000d0
cGQ/00@000000<ehK03=N6`000001P3NQ6<2000000T0fWA80`0000030==I00<00000;P3oool00`00
0000oooo0?ooo`0V0?ooo`00<`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01@0
oooo1`00000:04X0AP8000001@1K6V800`000000OSM/07hgK00;07hgK0<000001`26B7d00`000000
W5Z009aJP00H09aJP0030000002^J840[VR101X0[VR100<000000;ifP02nMX00602nMX000`000000
cX=m0<j3O@050<j3O@<000002P3=N6`010000000cGQ/0<ehK00000080=j4H`030000003JM4P0fWA8
00H0fWA800@000000>Ej:P3UNRX00000103CF@02000002d0oooo00<000000?ooo`3oool09P3oool0
01D0oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0
000000000000000009_Do`060?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool04P3o
ool60000000300P09`000000BP1600L0BP160P00000705/JHP030000001n=f`0OSM/00L0OSM/1000
000:08I8O@030000002LFX00W5Z001P0W5Z000<000000:iXP@2^J8406P2^J8400`000000_WJ00;if
P00H0;ifP0030000003>Pgd0cX=m00P0cX=m100000060<ehK0050000003=N6`0cGQ/0<ehK0000000
203NQ6<2000000H0fWA800D000000>Ej:P3UNRX0iGXZ000000040==I00030000003oool0oooo02`0
oooo00<000000?ooo`3oool09@3oool001D0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?oo
o`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00D0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`0@0?ooo`H000000P0802L00`000000BP1604X0
AP0404X0AP8000002@1K6V800`000000OSM/07hgK00407hgK0<000003P26B7d00`000000W5Z009aJ
P00H09aJP0030000002^J840[VR101X0[VR100<000000;ifP02nMX00602nMX000`000000cX=m0<j3
O@0<0<j3O@<000000`3=N6`01@000000cGQ/0<ehK03=N6`0000000X0gXAS0P0000050=YdB0050000
003UNRX0iGXZ0>Ej:P000000103CF@000`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02@0
oooo000D0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D
0?ooo`040?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool03P3oool600000080200W
00<0000004X0AP1:04H00`1:04H2000000X0FaYR00<0000007hgK01n=f`00P1n=f`300000100QTQm
00<0000009aJP02LFX006@2LFX000`000000[VR10:iXP@0J0:iXP@030000002nMX00_WJ001T0_WJ0
00<000000<j3O@3>Pgd03P3>Pgd4000000<0cGQ/00<000000=j4H`3NQ6<02P3NQ6<2000000<0fWA8
00<000000>Ej:P3UNRX00P3UNRX00`000000deT00==I00020==I00030000003oool0oooo02/0oooo
00<000000?ooo`3oool0903oool001@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0?0?ooo`030?oDV`00Vm@0oooo00@0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`0<0?ooo`H000000`0802L010000000BP1604X0AP1:04H2000000`0FaYR00<0000007hgK0000000
0P00000C08I8O@030000002LFX00W5Z001H0W5Z09000000H0;ifP0030000003>Pgd0cX=m0140cX=m
0`0000000`3=N6`000000=j4H`0=0=j4H`80000000<0fWA80000003UNRX0103UNRX200000080deT0
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0S0?ooo`002`3oool00`2jLP0000000000
000300000005001b^P3oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb
002Ke?l0oooo00@0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0;0?ooo`D00000
100802L010000000BP1600000000000>05/JHP8000005P26B7d00`000000W5Z009aJP00?09aJP0L0
00000`2PIH`00`000000/7:=0;1bS@0J0;1bS@040000002oOh`0_gn<0;moS0L000004@2nMX000`00
0000cX=m0<j3O@0A0<j3O@030000003>Pgd0cX=m00800000403NQ6<3000000H0iGXZ00@000000==I
003CF@000000;@3oool00`000000oooo0?ooo`0S0?ooo`00503oool00`3Z^W80L[[Z0?ooo`020?oo
o`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`040?oo
o`030000003oool0oooo03X0oooo00<000000?ooo`3oool02@3oool4000000D0200W0`00000>05/J
HP<000005`26B7d00`000000W5Z009aJP00809aJP0L000002P2PIH`00`000000/7:=0;1bS@0J0;1b
S@030000002oOh`0_gn<00P0_gn<1`00000:0;ifP0030000003>Pgd0cX=m0140cX=m00@000000<j3
O@3>Pgd0cX=m0`00000@0=j4H`030000003UNRX0iGXZ00D0iGXZ00@000000==I000000000000;@3o
ool00`000000oooo0?ooo`0R0?ooo`00503oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0
oooo00X0oooo00<0oooD09/0V`3Dool0203oool00`000000oooo0000000l0?ooo`030000003oool0
oooo00L0oooo1000000600P09`030000001K6V80FaYR00`0FaYR0P00000206P`M`0300000026B7d0
QTQm01D0QTQm00@0000009aJP02LFX00W5Z01`00000A0:1US0030000002`LXd0/7:=01X0/7:=00<0
00000;moS02oOh`03`2oOh`7000000<0_WJ000<000000<j3O@3>Pgd04@3>Pgd01@000000cX=m0<j3
O@3>Pgd000000080gY1g0P00000>0=j4H`8000001`3UNRX010000000deT000000000000]0?ooo`03
0000003oool0oooo0240oooo000E0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3o
om@0V`2K0=Coo`080?ooo`800000?P3oool00`000000oooo0?ooo`060?ooo`<000001P0802L20000
00d0FaYR00<0000006P`M`1X<7L00P1X<7L00`000000QTQm08I8O@0D08I8O@D00000602PIH`00`00
0000/7:=0;1bS@0J0;1bS@030000002oOh`0_gn<01H0_gn<1@00000B0<j3O@050000003>Pgd0cX=m
0<j3O@000000103NT7L2000000`0gXAS00@000000>f@C`00000000001P3UNRX3000002d0oooo00<0
00000?ooo`3oool08@3oool001D0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K
000000000080000000<0002K0=Coo`3oool00`3oool00`000000oooo0?ooo`0n0?ooo`030000003o
ool0oooo00@0oooo0`00000600P09`030000000U04d0000000/0FaYR0P00000506P`M`0300000026
B7d0QTQm0140QTQm0`0000000`2<EX/000000:1US00J0:1US0030000002`LXd0/7:=01X0/7:=00<0
00000;moS02oOh`06@2oOh`00`000000cXb;00000003000000h0cX=m00D000000<j3O@3>Pgd0cX=m
000000060=j@M`8000002`3NQ6<010000000kI1?0>f@C`0000070>Ej:P800000;@3oool00`000000
oooo0?ooo`0P0?ooo`00<@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo0080oooo
0`00000500P09`8000000P0U04d00`000000FaYR05/JHP0705/JHP8000001`1X<7L00`000000QTQm
08I8O@0>08I8O@<00000102<EX/00`000000X6F<0:1US00I0:1US0030000002`LXd0/7:=01X0/7:=
00<000000;moS02oOh`06@2oOh`00`000000cXb;0<j<R`030<j<R`<000002`3>Pgd01@000000cX=m
0<j3O@3>Pgd0000000P0gY1g0P0000090=j4H`050000003]T4l0kI1?0>f@C`0000001`3UNRX20000
02d0oooo00<000000?ooo`3oool07`3oool00340oooo00<000000?ooo`3oool0@03oool010000000
oooo0?ooo`3oool2000000D0200W00<0000002D0C@0U04d00P0U04d00`000000FaYR05/JHP0605/J
HP030000001X<7L0J31g00H0J31g00<0000008I8O@26B7d03026B7d3000000L0S5J;00<000000:1U
S02PIH`06@2PIH`00`000000/7:=0;1bS@0J0;1bS@030000002oOh`0_gn<01T0_gn<00<000000<j<
R`3>S8/01P3>S8/4000000L0cX=m00<000000<j3O@3>Pgd00P3>Pgd00`000000gY1g0=j@M`070=j@
M`8000001`3NQ6<00`000000kI1?0>f@C`020>f@C`030000003UNRX0iGXZ00@0iGXZ0P00000]0?oo
o`030000003oool0oooo01l0oooo000a0?ooo`030000003oool0oooo0440oooo00<000000?ooo`00
00000P00000400P09`030000000U04d09@1=00809@1=00<0000005/JHP1K6V801@1K6V82000000T0
J31g00<0000008I8O@26B7d02026B7d4000000X0S5J;00<000000:1US02PIH`06@2PIH`00`000000
/7:=0;1bS@0J0;1bS@030000002oOh`0_gn<01T0_gn<00<000000<j<R`3>S8/02P3>S8/4000000<0
cX=m00<000000<j3O@3>Pgd00P3>Pgd00`000000gY1g0=j@M`090=j@M`8000001@3NQ6<00`000000
kI1?0>f@C`030>f@C`030000003UNRX0iGXZ00@0iGXZ0P00000]0?ooo`030000003oool0oooo01h0
oooo000`0?ooo`030000003oool0oooo04<0oooo0`00000400P09`030000000U04d09@1=00<09@1=
00<0000005/JHP1K6V800`1K6V82000000/0J31g00<0000008I8O@26B7d01@26B7d3000000h0S5J;
00<000000:1US02PIH`06@2PIH`00`000000/7:=0;1bS@0J0;1bS@030000002oOh`0_gn<01T0_gn<
00<000000<j<R`3>S8/03P3>S8/4000000@0cX=m00<000000=j@M`3NT7L02`3NT7L2000000<0gXAS
00<000000>f@C`3]T4l0103]T4l2000000@0iGXZ0`00000/0?ooo`030000003oool0oooo01h0oooo
000`0?ooo`030000003oool0oooo04<0oooo0`00000300P09`030000000U04d09@1=00@09@1=00<0
000005/JHP1K6V800P1K6V800`000000J31g06P`M`0;06P`M`0300000026B7d0QTQm0080QTQm0`00
000A08aFR`030000002PIH`0X6F<01T0X6F<00<000000;1bS@2`LXd06P2`LXd00`000000_gn<0;mo
S00I0;moS0030000003>S8/0cXb;0140cXb;100000000`3>Pgd000000=j@M`0>0=j@M`8000000P3N
Q6<00`000000kI1?0>f@C`050>f@C`060000003UNRX0iGXZ0>Ej:P000000eVl00P00000[0?ooo`80
00007`3oool00300oooo00<000000?ooo`3oool0@P3oool3000000<0200W00<0000002D0C@0U04d0
1@0U04d00`000000FaYR05/JHP02000000h0J31g00<0000008I8O@0000000P00000E08aFR`030000
002PIH`0X6F<01P0X6F<00<000000;1bS@2`LXd06P2`LXd00`000000_gn<0;moS00I0;moS0030000
003>S8/0cXb;0140cXb;00@000000<j<R`3>S8/0cXb;0P00000A0=j@M`<00000203]T4l010000000
iGXZ0>Ej:P3UNRX2000000030:i0003oool0oooo02H0oooo0`0000000`3oool000000?ooo`0N0?oo
o`00<03oool00`000000oooo0?ooo`120?ooo`<000000P0802L00`0000009@1=02D0C@0602D0C@<0
0000401X<7L2000001P0S5J;00<000000:1US02PIH`05@2PIH`T000001P0_gn<00<000000<j<R`3>
S8/04P3>S8/010000000cXb;0<j<R`3>S8/300000140gY1g00<000000>f@C`3]T4l01`3]T4l01@00
0000iGXZ0>Ej:P000000eVl000800000903oool3000000@0oooo00<000000?ooo`3oool07@3oool0
0300oooo0P0000120?ooo`<0000000<0200W0000000000002@0U04d00`000000J31g06P`M`0>06P`
M`<000006@2<EX/00`000000X6F<0:1US00>0:1US0L000000`2SKYL00`000000/WZG0;9jU`0J0;9j
U`0400000030QYL0`8JG0<26U`L000004@2oOh`00`000000cXb;0<j<R`0B0<j<R`050000003>S8/0
cXb;0<j<R`0000000P3NVHL2000000l0gY1g0P0000090>f@C`<0000000<0eVl00000000000008@3o
ool3000000L0oooo00<000000?ooo`3oool07@3oool00300oooo00<000000?ooo`3oool0@03oool5
000000X09@1=0P00000>06P`M`8000000P1b@XL00`000000S5J;08aFR`0G08aFR`030000002PIH`0
X6F<00P0X6F<1P00000:0:=^U`030000002bNYL0/WZG01X0/WZG00<000000<26U`30QYL02030QYL7
000000X0_gn<00<000000<j<R`3>S8/04P3>S8/01@000000cXb;0<j<R`3>S8/0000000@0gYV70P00
000=0=j@M`040000003_WV/00000000000T0kI1?0P0000000`3FK`0000000000000M0?ooo`<00000
2`3oool00`000000oooo0?ooo`0L0?ooo`00<03oool00`000000oooo0?ooo`100?ooo`@000002@0U
04d20000000303/<J@000000J31g00/0J31g0P0000040792Q`030000002<EX/0S5J;01L0S5J;00@0
00000:1US02PIH`0X6F<1`00000@0:=^U`030000002bNYL0/WZG01X0/WZG00<000000<26U`30QYL0
3`30QYL7000000<0_gn<00<000000<j<R`3>S8/04P3>S8/01@000000cXb;0<j<R`3>S8/0000000H0
gYV70P00000;0=j@M`050000003_WV/0kii[0>nNJ`0000002@3]T4l010000000eVl00=I_0000000J
0?ooo`<000003P3oool00`000000oooo0?ooo`0L0?ooo`00;`3oool00`000000oooo0?ooo`100?oo
o`@000002@0U04d01@000000>`aY03/<J@0k36T0000000X0J31g0P0000060792Q`030000002<EX/0
S5J;01H0S5J;1@00000G0:=^U`030000002bNYL0/WZG01X0/WZG00<000000<26U`30QYL05P30QYL5
000001<0cXb;00D000000<j<R`3>S8/0cXb;000000080=jIQ`8000002@3NT7L00`000000kii[0>nN
J`020>nNJ`030000003]T4l0kI1?00H0kI1?0P0000000`3FK`0000000000000F0?ooo`<000004@3o
ool00`000000oooo0?ooo`0L0?ooo`00;`3oool00`000000oooo0?ooo`100?ooo`@00000200U04d0
0`000000>`aY03/<J@0203/<J@030000001X<7L0J31g00L0J31g00<000000792Q`1b@XL01P1b@XL0
0`000000S5J;08aFR`0C08aFR`<0000000<0TF6F0000002SKYL06@2SKYL00`000000/WZG0;9jU`0J
0;9jU`0300000030QYL0`8JG01T0`8JG00<000000<jCUP0000000`00000?0<j<R`050000003>S8/0
cXb;0<j<R`0000002P3NVHL2000000L0gY1g00<000000>nNJ`3_WV/00`3_WV/00`000000kI1?0>f@
C`050>f@C`8000000P3FK`000`000000oooo0?ooo`0A0?ooo`<00000503oool00`000000oooo0?oo
o`0L0?ooo`00;`3oool00`000000oooo0?ooo`0o0?ooo`D000001`0U04d00`000000>`aY03/<J@02
03/<J@030000001X<7L0J31g00H0J31g0P0000090792Q`030000002<EX/0S5J;0100S5J;0`000004
095QUP030000002SKYL0XfjG01P0XfjG00<000000;9jU`2bNYL06P2bNYL00`000000`8JG0<26U`0I
0<26U`030000003>TiH0cY>F00<0cY>F0`00000<0<j<R`050000003>S8/0cXb;0<j<R`000000303N
VHL2000000H0gY1g00<000000>nNJ`3_WV/00`3_WV/00`000000kI1?0>f@C`050>f@C`8000000P3F
K`000`000000oooo0?ooo`0=0?ooo`<000005`3oool00`000000oooo0?ooo`0L0?ooo`00;`3oool0
0`000000oooo0?ooo`0o0?ooo`@000001`0U04d00`000000>`aY03/<J@0303/<J@030000001X<7L0
J31g00@0J31g0P00000<0792Q`030000002<EX/0S5J;00`0S5J;0`000007095QUP030000002SKYL0
XfjG01P0XfjG00<000000;9jU`2bNYL06P2bNYL00`000000`8JG0<26U`0I0<26U`030000003>TiH0
cY>F00H0cY>F100000080<j<R`050000003>S8/0cXb;0<j<R`0000003P3NVHL2000000@0gY1g00<0
00000>nNJ`3_WV/0103_WV/2000000D0kI1?00D000000>jB9P000000eVl00000000<0?ooo`<00000
6P3oool00`000000oooo0?ooo`0L0?ooo`00;`3oool00`000000oooo0?ooo`0n0?ooo`D000001@0U
04d2000000H0>`aY00<0000006P`M`1X<7L00P1X<7L2000000h0LT:700<0000008aFR`2<EX/0202<
EX/4000000X0TF6F00<000000:=^U`2SKYL0602SKYL00`000000/WZG0;9jU`0J0;9jU`0300000030
QYL0`8JG01T0`8JG00<000000<jCUP3>TiH02P3>TiH4000000@0cXb;00D000000<j<R`3>S8/0cXb;
0000000@0=jIQ`8000000P3NT7L00`000000kii[0>nNJ`060>nNJ`030000003]T4l0kI1?0080kI1?
00<000000>jB9P0000000P3FK`000`000000oooo0?ooo`050?ooo`@000007@3oool00`000000oooo
0?ooo`0L0?ooo`00;`3oool00`000000oooo0?ooo`0n0?ooo`<0000000<0000Q0000000U04d00`0U
04d00`000000>`aY03/<J@0603/<J@030000001X<7L0J31g00800000401b@XL00`000000S5J;08aF
R`0508aFR`<000003P2AHIH00`000000XfjG0:=^U`0H0:=^U`030000002bNYL0/WZG01X0/WZG00<0
00000<26U`30QYL06@30QYL00`000000cY>F0<jCUP0>0<jCUP<0000000<0cXb;0000003>S8/00P3>
S8/00`000000gYV70=jIQ`0@0=jIQ`<000002@3_WV/01@000000kI1?0>f@C`3]T4l000000080kY8V
00<000000=I_00000000103oool300000280oooo00<000000?ooo`3oool06`3oool002h0oooo0`00
000n0?ooo`<000000P0002401@0000009@1=02D0C@0U04d0000000T0>`aY0`00000B0792Q`030000
002<EX/0S5J;0080S5J;0`00000A095QUP030000002SKYL0XfjG01P0XfjG00<000000;9jU`2bNYL0
6P2bNYL00`000000`8JG0<26U`0H0<26U`030000003>TiH0cY>F0180cY>F100000000`3>S8/00000
0=jIQ`0C0=jIQ`030000003_WV/0kii[00P0kii[00@000000>f@C`3]T4l000000`3^TRH00`000000
eVl000000003000002D0oooo00<000000?ooo`3oool06`3oool002h0oooo00<000000?ooo`3oool0
?P3oool300000080000Q00@0000002D0C@0U04d000002P0k36T00`000000LT:70792Q`0B0792Q`03
0000002<EX/0000000800000502AHIH00`000000XfjG0:=^U`0H0:=^U`030000002bNYL0/WZG01X0
/WZG00<000000<26U`30QYL06030QYL00`000000cY>F0<jCUP0C0<jCUP030000003>TiH0cY>F0080
0000503NVHL2000000X0kii[0P0000001`3]T4l000000>jB9P3^TRH000000=I_00000000:03oool0
0`000000oooo0?ooo`0K0?ooo`00;P3oool00`000000oooo0?ooo`0m0?ooo`<000000P0002401000
00009@1=00000000000:03/<J@800000501b@XL2000001L0TF6F00<000000:=^U`2SKYL0602SKYL0
0`000000/WZG0;9jU`0J0;9jU`0300000030QYL0`8JG01P0`8JG00<000000<jCUP3>TiH04`3>TiH0
10000000cY>F0<jCUP3>TiH300000180gYV700@000000>jYP000000000002P3_WV/2000000<0kY8V
00<000000=I_000000009`3oool00`000000oooo0?ooo`0K0?ooo`00;P3oool00`000000oooo0?oo
o`0m0?ooo`<000000P000242000000X0>`aY0P0000000`1<9Gl000000792Q`0A0792Q`<00000602A
HIH00`000000XfjG0:=^U`0E0:=^UbD000005P30QYL00`000000cY>F0<jCUP0C0<jCUP050000003>
TiH0cY>F0<jCUP0000000P3MXI@200000100gYV700D000000>jYP03^ZH00kZV00000000:0>nNJ`03
0000003^TRH0kY8V0080kY8V0P00000W0?ooo`030000003oool0oooo01/0oooo000^0?ooo`030000
003oool0oooo03d0oooo0P00000300008@030000000k36T0>`aY00P0>`aY00D0000004`UO`1<9Gl0
C2Eo0000000@0792Q`8000000P1jD9@00`000000TF6F095QUP0F095QUP030000002SKYL0XfjG00h0
XfjG1`0000030:EgW`030000002cPYl0/h:O01X0/h:O00<000000<2=W`30SIl00P30SIl9000000d0
`8JG00<000000<jCUP3>TiH04`3>TiH01@000000cY>F0<jCUP3>TiH0000000@0gJ6D0P00000>0=jI
Q`030000003^ZH00kZV00080kZV000<000000>nNJ`3_WV/01`3_WV/2000000<0kY8V0P00000W0?oo
o`030000003oool0oooo01/0oooo000^0?ooo`030000003oool0oooo03`0oooo0P00000300008@80
00002@0k36T00`000000C2Eo04`UO`0204`UO`030000001b@XL0LT:700`0LT:70P00000407Y@U003
0000002AHIH0TF6F01H0TF6F00<000000:=^U`2SKYL0202SKYL6000000X0YGNO00<000000;>2W`2c
PYl06P2cPYl00`000000`8fO0<2=W`0;0<2=W`T000001030QYL00`000000cY>F0<jCUP0C0<jCUP05
0000003>TiH0cY>F0<jCUP0000001P3MXI@2000000`0gYV700<000000>jYP03^ZH000`3^ZH000`00
0000kii[0>nNJ`060>nNJ`800000103^TRH2000002H0oooo00<000000?ooo`3oool06`3oool002h0
oooo00<000000?ooo`3oool0?03oool2000000<0000Q0P00000803/<J@030000001<9Gl0C2Eo00<0
C2Eo00<000000792Q`1b@XL02P1b@XL2000000H0NU2D00<00000095QUP2AHIH05P2AHIH010000000
XfjG0:=^U`2SKYL700000100YGNO00<000000;>2W`2cPYl06P2cPYl00`000000`8fO0<2=W`0D0<2=
W`H00000503>TiH01@000000cY>F0<jCUP3>TiH0000000P0gJ6D0P00000:0=jIQ`030000003^ZH00
kZV000@0kZV000<000000>nNJ`3_WV/01@3_WV/00`000000nJU?000000040>jB9P030000003oool0
oooo02@0oooo00<000000?ooo`3oool06`3oool002d0oooo00<000000?ooo`3oool0?@3oool01`00
0000000Q00008@00024000000000C00000001`0k36T00`000000C2Eo04`UO`0404`UO`030000001b
@XL0LT:700P0LT:70P00000807Y@U0030000002AHIH0TF6F01D0TF6F1@00000G0:EgW`030000002c
PYl0/h:O01X0/h:O00<000000<2=W`30SIl06030SIl00`000000cIVO0000000200000140cY>F00D0
00000<jCUP3>TiH0cY>F0000000:0=fQU0800000203NVHL00`000000kZV00>jYP0050>jYP0800000
1@3_WV/010000000nJU?0?VYC`0000030>jB9P8000009P3oool00`000000oooo0?ooo`0J0?ooo`00
;@3oool00`000000oooo0?ooo`0l0?ooo`8000000P00024010000000001<0000C000000503/<J@80
00001`1<9Gl00`000000LT:70792Q`060792Q`8000002P1jD9@00`000000TF6F095QUP0A095QUP@0
000000<0U6^O0000002UMil06@2UMil00`000000/h:O0;>2W`0J0;>2W`0300000030SIl0`8fO01P0
`8fO00<000000<fIW`3=VIl00P3=VIl3000000l0cY>F00<000000<jCUP0000003@3MXI@2000000H0
gYV700<000000>jYP03^ZH001`3^ZH000`000000kii[0>nNJ`020>nNJ`050000003iZDl0nJU?0?VY
C`0000000`3^TRH00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01X0oooo000]0?ooo`03
0000003oool0000003`0oooo00L0000000008@000240000Q0000000004`0000000D0>`aY00<00000
04`UO`1<9Gl01`1<9Gl00`000000LT:70792Q`040792Q`8000003@1jD9@00`000000TF6F095QUP0=
095QUP<000001@2DJil00`000000YGNO0:EgW`0H0:EgW`030000002cPYl0/h:O01X0/h:O00<00000
0<2=W`30SIl06030SIl00`000000cIVO0<fIW`050<fIW`<00000303>TiH00`000000cY>F0000000?
0=fQU0800000103NVHL00`000000kZV00>jYP0080>jYP0030000003_WV/0kii[0080kii[00@00000
0?VYC`3iZDl000000`3^TRH00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01X0oooo000]
0?ooo`800000?@3oool010000000000Q00008@0000020000C0030000000k36T0>`aY0080>`aY00<0
000004`UO`1<9Gl0201<9Gl00`000000LT:70792Q`020792Q`8000003`1jD9@00`000000TF6F095Q
UP0:095QUP<00000202DJil00`000000YGNO0:EgW`0H0:EgW`030000002cPYl0/h:O01T0/h:O00<0
00000<2=W`30SIl06@30SIl00`000000cIVO0<fIW`080<fIW`@00000203>TiH00`000000cY>F0000
000A0=fQU08000000P3NVHL00`000000kZV00>jYP0090>jYP0050000003_WV/0kii[0>nNJ`000000
0`3iZDl01@000000kY8V0>jB9P3^TRH0000002D0oooo00<000000?ooo`3oool06P3oool002d0oooo
00<000000?ooo`3oool0>`3oool010000000000Q00008@0000030000C0050000000k36T0>`aY03/<
J@0000002`1<9Gl00`000000LT:70792Q`0200000140NU2D00<00000095QUP2AHIH01P2AHIH40000
00`0U6^O00<000000:EgW`2UMil0602UMil00`000000/h:O0;>2W`0H0;>2W`0300000030SIl0`8fO
01T0`8fO00<000000<fIW`3=VIl0303=VIl3000000D0cY>F00<000000<jCUP0000004`3MXI@30000
00`0kZV00P0000000`3_WV/000000?VYC`030?VYC`040000003^TRH0kY8V000002D0oooo00<00000
0?ooo`3oool06P3oool002d0oooo00<000000?ooo`3oool0>`3oool010000000000Q00008@000003
0000C0040000000k36T00000000000`0C2Eo0`00000C07Y@U0030000002AHIH0TF6F00<0TF6F0`00
000@09A[W`030000002UMil0YGNO01P0YGNO00<000000;>2W`2cPYl0602cPYl00`000000`8fO0<2=
W`0I0<2=W`030000003=VIl0cIVO00l0cIVO0`0000020<jCUP030000003>TiH0000001D0gJ6D00<0
00000>jYP03^ZH00303^ZH02000000D0nJU?00<000000>jB9P0000009@3oool00`000000oooo0?oo
o`0J0?ooo`00;03oool00`000000oooo0?ooo`0l0?ooo`03000000000240000000@0001<0P00000>
04`UO`030000001jD9@0NU2D01<0NU2D00<00000095QUP0000000`00000C09A[W`030000002UMil0
YGNO01P0YGNO00<000000;>2W`2cPYl0602cPYl00`000000`8fO0<2=W`0H0<2=W`030000003=VIl0
cIVO01<0cIVO0`0000000`3>TiH000000=fQU00D0=fQU08000003P3^ZH000`000000nJU?0?VYC`03
0?VYC`040000003^TRH00000000002@0oooo00<000000?ooo`3oool06P3oool002`0oooo00<00000
0?ooo`3oool0>`3oool00`000000000Q000000050000C0030000001<9Gl0C2Eo00`0C2Eo0P00000E
07Y@U08000005`2DJil00`000000YGNO0:EgW`0H0:EgW`030000002cPYl0/h:O01P0/h:O00<00000
0<2=W`30SIl06030SIl00`000000cIVO0<fIW`0E0<fIW`@00000503MXI@010000000k;6@00000000
000<0>jYP08000001@3iZDl00`000000kY8V0000000U0?ooo`030000003oool0oooo01T0oooo000/
0?ooo`030000003oool0oooo03/0oooo00<0000000008@000000100004`2000000`0C2Eo0P000000
0`1J>I00000007Y@U00B07Y@U0<00000602DJil00`000000YGNO0:EgW`0H0:EgW`030000002cPYl0
/h:O01P0/h:O00<000000<2=W`30SIl06030SIl00`000000cIVO0<fIW`0E0<fIW`040000003=VIl0
00000=^VW`8000004P3MXI@01@000000k;6@0>baT03//I00000000/0kZV00P0000060?VYC`800000
9@3oool00`000000oooo0?ooo`0I0?ooo`00;03oool00`000000oooo0?ooo`0k0?ooo`8000001@00
04`2000000/0C2Eo00D0000005XiT01J>I00FSV@0000000A07Y@U08000000P20G9l00`000000U6^O
09A[W`0F09A[W`030000002UMil0YGNO01P0YGNO00<000000;>2W`2cPYl02`2cPYlA000001L0`8fO
00<000000<fIW`3=VIl05@3=VIl00`000000cIVO000000030=^VW`800000403MXI@00`000000k;6@
0>baT0020>baT0030000003^ZH00kZV000P0kZV000<000000?biK`0000001P3iZDl2000002@0oooo
00<000000?ooo`3oool06@3oool002`0oooo00<000000?ooo`3oool0>`3oool00`000000001<0000
C0030000C0030000000>06d0000000X0C2Eo00<0000005XiT01J>I000P1J>I000`000000NU2D07Y@
U00=07Y@U08000001020G9l00`000000U6^O09A[W`0G09A[W`030000002UMil0YGNO01<0YGNO4P00
000=0;>8Y`0400000030TjL0`9>W0<2CY`L000004030SIl00`000000cIVO0<fIW`0E0<fIW`030000
003=VIl0000000D0fjJO0P00000>0=fQU0030000003//I00k;6@00<0k;6@00<000000>jYP03^ZH00
1`3^ZH0010000000o;U_0?biK`0000050?VYC`800000903oool00`000000oooo0?ooo`0I0?ooo`00
;03oool00`000000oooo0000000j0?ooo`800000100004`0100000003P1]00h0K@00000904`UO`03
0000001J>I00FSV@00<0FSV@00<0000007Y@U01jD9@02`1jD9@2000000L0P5bO00<0000009A[W`2D
Jil05P2DJil00`000000YGNO0:EgW`0;0:EgW`P00000102VOZL00`000000/hRW0;>8Y`0H0;>8Y`03
00000030TjL0`9>W00P0`9>W1P00000:0<2=W`030000003=VIl0cIVO01D0cIVO0P0000080=^VW`80
00002`3MXI@00`000000k;6@0>baT0050>baT0030000003^ZH00kZV000H0kZV000D000000?biK`3l
^Fl0o;U_000000050?VYC`030000003oool0oooo0280oooo00<000000?ooo`3oool06@3oool002/0
oooo0`00000k0?ooo`030000000004`0001<00<0001<00@0000000h0K@0>06d00000201<9Gl00`00
0000FSV@05XiT00405XiT0030000001jD9@0NU2D00T0NU2D0P000009081LW`030000002DJil0U6^O
01H0U6^O00<000000:EgW`2UMil00P2UMil9000000`0YWjW00<000000;>8Y`2cR:L0602cR:L00`00
0000`9>W0<2CY`0>0<2CY`L000000`30SIl00`000000cIVO0<fIW`0E0<fIW`8000002P3KYYl20000
00T0gJ6D00<000000>baT03//I001P3//I02000000H0kZV000D000000?biK`3l^Fl0o;U_00000005
0?VYC`8000008`3oool00`000000oooo0?ooo`0I0?ooo`00:`3oool00`000000oooo0?ooo`0k0?oo
o`030000000004`0001<0080001<00D0000000h0K@0>06d03P1]0000000604`UO`800000201J>I00
0`000000NU2D07Y@U00607Y@U08000002`20G9l00`000000U6^O09A[W`0E09A[W`H000005@2VOZL0
0`000000/hRW0;>8Y`0H0;>8Y`0300000030TjL0`9>W01D0`9>W1@00000F0<fIW`800000303KYYl2
000000L0gJ6D00<000000>baT03//I00203//I000`000000kZV00>jYP0030>jYP0030000003l^Fl0
o;U_0080o;U_00<000000?VYC`3iZDl00P3iZDl2000002<0oooo00<000000?ooo`3oool06@3oool0
0200oooo00D0omBK000000000000000009_Do`060?ooo`030000003oool0oooo03X0oooo0P000003
0000C0030000000>06d03P1]00803P1]00<0000004`UO`1<9Gl00`1<9Gl00`000000FSV@05XiT008
05XiT0030000001jD9@0NU2D00@0NU2D0P00000=081LW`030000002DJil0U6^O0180U6^O0`000000
0`2HLjP000000:InY`0H0:InY`030000002cR:L0/hRW01P0/hRW00<000000<2CY`30TjL06030TjL0
0`000000c9jX0000000300000180cIVO0P00000>0=^VW`8000001@3MXI@00`000000k;6@0>baT009
0>baT0030000003^ZH00kZV00080kZV000<000000?biK`3l^Fl00`3l^Fl010000000nJU?0?VYC`3i
ZDl2000002@0oooo00<000000?ooo`3oool0603oool00200oooo00H0^W:K0=Coo`3oool0oooD09/0
V`3Dool50?ooo`030000003oool0oooo03X0oooo0P0000030000C0030000000>06d03P1]00803P1]
00<0000004`UO`1<9Gl00P1<9Gl00`000000FSV@05XiT00905XiT0030000001jD9@0NU2D0080NU2D
0P00000?081LW`030000002DJil0U6^O00l0U6^O0`00000409QcZ0030000002VOZL0YWjW01L0YWjW
00<000000;>8Y`2cR:L0602cR:L00`000000`9>W0<2CY`0H0<2CY`030000003<WZP0c9jX00<0c9jX
0`00000?0<fIW`800000403KYYl2000000<0gJ6D00<000000>baT03//I002P3//I001@000000kZV0
0>jYP03^ZH00000000H0o;U_00<000000?VYC`3iZDl00`00000S0?ooo`030000003oool0oooo01P0
oooo000O0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool0103oool00`000000oooo
0?ooo`0j0?ooo`8000000P0004`00`0000003P1]00h0K@0300h0K@050000001<9Gl0C2Eo04`UO`00
0000301J>I000`000000NU2D07Y@U00200000140P5bO00<0000009A[W`2DJil0302DJil3000000L0
V7>X00<000000:InY`2VOZL05`2VOZL00`000000/hRW0;>8Y`0H0;>8Y`0300000030TjL0`9>W01P0
`9>W00<000000<bNZ03<WZP01P3<WZP3000000`0cIVO0P00000B0=^VW`80000000<0gJ6D0000003/
/I00303//I02000000030>jYP0000000o;U_00D0o;U_00<000000?VYC`3iZDl00`00000S0?ooo`03
0000003oool0oooo01P0oooo000O0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
103oool00`000000oooo0?ooo`0j0?ooo`040000000004`0001<000000H03P1]00@0000004`UO`00
000000003@1J>I03000001<0P5bO00<0000009A[W`2DJil02@2DJil3000000X0V7>X00<000000:In
Y`2VOZL05`2VOZL00`000000/hRW0;>8Y`0H0;>8Y`0300000030TjL0`9>W01L0`9>W00<000000<bN
Z03<WZP02P3<WZP4000000P0cIVO00<000000=^VW`3KYYl04`3KYYl2000000l0k;6@0P0000070?bi
K`030000003iZDl0nJU?008000008`3oool00`000000oooo0?ooo`0H0?ooo`007`3oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00@0oooo00<000000?ooo`3oool0>@3oool200000080
001<00<0000000h0K@0>06d0100>06d2000000l0FSV@00<00000081LW`20G9l05020G9l00`000000
U6^O09A[W`0509A[W`<000003@2HLjP00`000000YWjW0:InY`0H0:InY`030000002cR:L0/hRW01L0
/hRW00<000000<2CY`30TjL05`30TjL00`000000c9jX0<bNZ00>0<bNZ0<000001@3=VIl00`000000
fjJO0=^VW`0D0=^VW`8000003`3//I000`000000o;U_0?biK`060?biK`040000003iZDl000000000
02<0oooo00<000000?ooo`3oool0603oool001l0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/0
09_D0?ooo`030?ooo`030000003oool0oooo03X0oooo0P0000000`0004`0000000h0K@0600h0K@03
0000001J>I00FSV@00d0FSV@0P00000F081LW`030000002DJil0U6^O0080U6^O0`00000@09QcZ003
0000002VOZL0YWjW01P0YWjW00<000000;>8Y`2cR:L05`2cR:L00`000000`9>W0<2CY`0G0<2CY`03
0000003<WZP0c9jX0140c9jX100000000`3=VIl000000000000E0=^VW`040000003Y]Yh000000000
00d0k;6@0P0000080?biK`@000008P3oool00`000000oooo0?ooo`0H0?ooo`007`3oool00`3oe9/0
L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00<0oooo00<000000?ooo`3oool0>P3oool3000000L0
3P1]0P00000=05XiT080000000<0I4ZN00000020G9l05@20G9l00`000000U6^O00000002000001<0
V7>X00<000000:InY`2VOZL0602VOZL00`000000/hRW0;>8Y`0G0;>8Y`0300000030TjL0`9>W01L0
`9>W00<000000<bNZ03<WZP05@3<WZP3000001@0fjJO00<000000>VfWP3Y]Yh00P3Y]Yh00`000000
k;6@0>baT00:0>baT0800000203l^Fl400000280oooo00<000000?ooo`3oool0603oool00200oooo
00H0^W8009_Do`3oool0onZj0780V`3Dool40?ooo`030000003oool0oooo03X0oooo0`00000700h0
K@800000301J>I000`000000I4ZN06A:WP0206A:WP0300000020G9l0P5bO0180P5bO0`00000G09Qc
Z0030000002VOZL0YWjW01L0YWjW00<000000;>8Y`2cR:L05`2cR:L00`000000`9>W0<2CY`0G0<2C
Y`030000003<WZP0c9jX01H0c9jX0`00000C0=^VW`030000003Y]Yh0jKJN00<0jKJN00<000000>ba
T03//I00203//I0010000000nl>70?_3Q`0000080?biK`030000003MW1@0000002<0oooo00<00000
0?ooo`3oool05`3oool00200oooo00D0oooD09/000000000001b0;[Zo`050?ooo`800000>P3oool0
0`000000000>0000000700h0K@040000000V5XH09QJ6000000X0FSV@00<0000006A:WP1TBYh00`1T
BYh00`000000P5bO081LW`0@081LW`80000000<0QFNY0000002HLjP05`2HLjP00`000000YWjW0:In
Y`0G0:InY`030000002cR:L0/hRW01L0/hRW00<000000<2CY`30TjL05`30TjL00`000000c9jX0<bN
Z00F0<bNZ080000000<0fJ^Y0000000000004@3KYYl00`000000jKJN0>VfWP040>VfWP030000003/
/I00k;6@00L0k;6@00D000000?_3Q`3k`hL0nl>7000000070?biK`030000003MW1@0000002<0oooo
00<000000?ooo`3oool05`3oool002X0oooo00<000000?ooo`3oool0>@3oool00`000000000>0000
000600h0K@050000000V5XH09QJ602HFQP0000002@1J>I000`000000I4ZN06A:WP0406A:WP030000
0020G9l0P5bO00h0P5bO0P00000308EWZ@030000002HLjP0V7>X01H0V7>X00<000000:InY`2VOZL0
5`2VOZL00`000000/hRW0;>8Y`0G0;>8Y`0300000030TjL0`9>W01L0`9>W00<000000<bNZ03<WZP0
5@3<WZP00`000000fJ^Y000000030=V[Z@8000003`3KYYl00`000000jKJN0>VfWP050>VfWP800000
1`3//I000`000000nl>70?_3Q`020?_3Q`030000003l^Fl0o;U_00@0o;U_0`00000S0?ooo`030000
003oool0oooo01L0oooo000Z0?ooo`030000003oool0oooo03T0oooo0`00000500h0K@030000000V
5XH09QJ600809QJ600<0000005XiT01J>I001@1J>I02000000L0I4ZN00<00000081LW`20G9l03020
G9l2000000H0QFNY00<0000009QcZ02HLjP05@2HLjP00`000000YWjW0:InY`0C0:InYb<000005030
TjL00`000000c9jX0<bNZ00F0<bNZ0030000003IZjT0000000D0fJ^Y0P00000<0=^VW`030000003Y
]Yh0jKJN00P0jKJN00<000000>baT03//I00103//I000`000000nl>70?_3Q`020?_3Q`030000003l
^Fl0o;U_00@0o;U_1000000R0?ooo`030000003oool0oooo01L0oooo000Y0?ooo`030000003oool0
oooo03X0oooo0`00000500h0K@030000000V5XH09QJ600809QJ600<0000005XiT01J>I00101J>I00
0`000000I4ZN06A:WP0806A:WP0300000020G9l0P5bO00T0P5bO0P00000808EWZ@030000002HLjP0
V7>X01D0V7>X00<000000:InY`2VOZL02`2VOZL8000000@0Z8F_00<000000;B>[`2dSZl05`2dSZl0
0`000000_iR_0;nH[`020;nH[`P000003030TjL00`000000c9jX0<bNZ00F0<bNZ0030000003IZjT0
000000L0fJ^Y0P00000:0=^VW`030000003Y]Yh0jKJN00T0jKJN00<000000>baT03//I000`3//I00
0`000000nl>70?_3Q`030?_3Q`030000003l^Fl0o;U_00<0o;U_0P0000000`3MW1@000000?ooo`0Q
0?ooo`030000003oool0oooo01L0oooo000Y0?ooo`030000003oool0oooo03T0oooo00@000000000
3P0000000000100>06d00`0000009QJ602HFQP0302HFQP030000001J>I00FSV@00<0FSV@00<00000
06A:WP1TBYh02@1TBYh00`000000P5bO081LW`06081LW`<000002P25IjT00`000000V7>X09QcZ00E
09QcZ0030000002VOZL0YWjW0080YWjW2@00000<0:R5[`030000002dSZl0]8j_01L0]8j_00<00000
0;nH[`2oV:l02P2oV:l8000000@0`9>W00<000000<bNZ03<WZP05P3<WZP00`000000fJ^Y00000009
0=V[Z@800000203KYYl00`000000jKJN0>VfWP0:0>VfWP030000003//I00k;6@0080k;6@00<00000
0?_3Q`3k`hL0103k`hL00`000000o;U_0?biK`020?biK`80000000<0gI`D0000003oool08@3oool0
0`000000oooo0?ooo`0G0?ooo`00:@3oool00`000000oooo0?ooo`0i0?ooo`040000000000h00000
000000<03P1]00<0000002HFQP0V5XH0100V5XH00`000000FSV@05XiT00205XiT0030000001TBYh0
I4ZN00X0I4ZN00<00000081LW`20G9l01020G9l2000000d0QFNY00<0000009QcZ02HLjP0502HLjP6
000001D0Z8F_00<000000;B>[`2dSZl05`2dSZl00`000000_iR_0;nH[`0B0;nH[`H000005P3<WZP0
10000000fJ^Y0=V[Z@00000;0=V[Z@8000001P3KYYl00`000000jKJN0>VfWP0;0>VfWP80000000<0
k;6@0000003k`hL01P3k`hL01@000000o;U_0?biK`3l^Fl000000080lka50P00000R0?ooo`030000
003oool0oooo01L0oooo000Y0?ooo`030000003oool0oooo03T0oooo0P0000000`000440000000h0
K@0200h0K@030000000V5XH09QJ600D09QJ600@0000005XiT000000000003@1TBYh00`000000P5bO
081LW`02081LW`8000004025IjT00`000000V7>X09QcZ00@09QcZ0<0000000<0VW^`0000002XQJl0
602XQJl00`000000]8j_0;B>[`0G0;B>[`030000002oV:l0_iR_01H0_iR_00<000000<^S/0000000
0`00000B0<bNZ0040000003IZjT0fJ^Y000000d0fJ^Y0P0000030=^VW`030000003Y]Yh0jKJN00h0
jKJN0P0000080?_3Q`040000003l^Fl0o;U_00000080lka50P00000R0?ooo`030000003oool0oooo
01L0oooo000Y0?ooo`030000003oool0oooo03T0oooo0P0000001@000440000000h0K@0>06d00000
00P09QJ60P00000@06A:WP0400000020G9l0000000000180QFNY00<0000009QcZ02HLjP03@2HLjP3
000000@0VW^`00<000000:R5[`2XQJl05`2XQJl00`000000]8j_0;B>[`0G0;B>[`030000002oV:l0
_iR_01H0_iR_00<000000<^S/03;Xk000`3;Xk04000000h0c9jX00@000000=V[Z@3IZjT000003`3I
ZjT2000000030=^VW`000000jKJN0100jKJN00<000000?_3Q`3k`hL01`3k`hL00`000000o;U_0000
00020?>lA@8000008`3oool00`000000oooo0?ooo`0F0?ooo`00:@3oool00`000000oooo0?ooo`0i
0?ooo`80000000@000110000000>06d000002@0V5XH00`000000I4ZN06A:WP0?06A:WP8000005025
IjT00`000000V7>X09QcZ00:09QcZ0<00000202JNk000`000000Z8F_0:R5[`0F0:R5[`030000002d
SZl0]8j_01L0]8j_00<000000;nH[`2oV:l05P2oV:l00`000000bj>`0<^S/0070<^S/0@000002P3<
WZP010000000fJ^Y0=V[Z@00000A0=V[Z@8000004@3Y]Yh2000000T0nl>70P0000020?>lA@800000
8`3oool00`000000oooo0?ooo`0F0?ooo`00:@3oool00`000000oooo0?ooo`0i0?ooo`80000000<0
00110000000000002@0V5XH200000100I4ZN0P00000E08EWZ@030000002HLjP0V7>X00H0V7>X1000
000;09Yk/0030000002XQJl0Z8F_01H0Z8F_00<000000;B>[`2dSZl05P2dSZl00`000000_iR_0;nH
[`0F0;nH[`030000003;Xk00bj>`00`0bj>`100000050<bNZ0050000003IZjT0fJ^Y0=V[Z@000000
4P3IZjT3000000h0jKJN00@000000?S9VP3hbIX00000203k`hL2000000<0lka500<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`0F0?ooo`00:03oool3000003X0oooo00<000000000@@000440
0P00000902HFQP8000003P1TBYh200000080KERY00<0000008EWZ@25IjT04`25IjT00`000000V7>X
09QcZ00209QcZ0<000003`2JNk000`000000Z8F_0:R5[`0F0:R5[`030000002dSZl0]8j_01H0]8j_
00<000000;nH[`2oV:l05P2oV:l00`000000bj>`0<^S/00@0<^S/0@0000000<0c9jX0000003IZjT0
0P3IZjT00`000000fJ^Y0=V[Z@0?0=V[Z@050000003V^jT0i[^Y0>JkZ@0000003@3Y]Yh010000000
n<VJ0?S9VP0000090?_3Q`040000003c_4D0lka50?>lA@8000008P3oool00`000000oooo0?ooo`0F
0?ooo`00:03oool00`000000oooo0?ooo`0i0?ooo`8000000P0004400`0000009QJ602HFQP0702HF
QP040000000j;iT0>RnI000000`0I4ZN00<0000006eHZ@1]F:T00P1]F:T00`000000QFNY08EWZ@0C
08EWZ@030000002HLjP00000008000004P2JNk000`000000Z8F_0:R5[`0F0:R5[`030000002dSZl0
]8j_01H0]8j_00<000000;nH[`2oV:l05P2oV:l00`000000bj>`0<^S/00D0<^S/08000000`3IZjT0
0`000000fJ^Y0=V[Z@0?0=V[Z@030000003V^jT0i[^Y0080i[^Y00<000000>VfWP3Y]Yh02P3Y]Yh0
1@000000n<VJ0?S9VP3hbIX0000000P0nl>700@000000?>lA@3c_4D0lka50P00000R0?ooo`030000
003oool0oooo01H0oooo000X0?ooo`030000003oool0oooo03T0oooo0P0000020000@@030000000V
5XH09QJ600H09QJ600D0000003X_V@0j;iT0>RnI0000000;06A:WP030000001]F:T0KERY00<0KERY
00<0000008EWZ@25IjT04P25IjT3000001D0VW^`00<000000:R5[`2XQJl05P2XQJl00`000000]8j_
0;B>[`0F0;B>[`030000002oV:l0_iR_01H0_iR_00<000000<^S/03;Xk005@3;Xk03000000030=V[
Z@000000fJ^Y0100fJ^Y00<000000>JkZ@3V^jT00`3V^jT2000000X0jKJN00<000000?S9VP3hbIX0
0P3hbIX00`000000nl>70?_3Q`050?_3Q`8000000P3c_4D200000280oooo00<000000?ooo`3oool0
5P3oool002P0oooo00<000000?ooo`3oool0>@3oool200000080001100<0000002HFQP0V5XH01@0V
5XH00`000000>RnI03X_V@0203X_V@030000001TBYh0I4ZN00P0I4ZN00<0000006eHZ@1]F:T01@1]
F:T00`000000QFNY08EWZ@0?08EWZ@80000000<0RW6a0000002JNk005P2JNk000`000000Z8F_0:R5
[`0E0:R5[`030000002dSZl0]8j_01H0]8j_00<000000;nH[`2oV:l05P2oV:l00`000000bj>`0<^S
/00D0<^S/0040000003F[k40eZna0=J_/@800000403IZjT00`000000i[^Y0>JkZ@060>JkZ@030000
003Y]Yh0jKJN00H0jKJN00<000000?S9VP3hbIX0103hbIX00`000000nl>70?_3Q`040?_3Q`800000
0`3c_4D00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01H0oooo000X0?ooo`030000003o
ool0oooo03T0oooo00H000000000@@00044000000000J@00000602HFQP030000000j;iT0>RnI0080
>RnI00<0000006A:WP1TBYh01P1TBYh2000000P0KERY00<0000008EWZ@25IjT03@25IjT2000000<0
RW6a00<0000009Yk/02JNk005@2JNk000`000000Z8F_0:R5[`0E0:R5[`030000002dSZl0]8j_01H0
]8j_00<000000;nH[`2oV:l05P2oV:l00`000000bj>`0<^S/00D0<^S/0030000003F[k40eZna0080
eZna0`00000>0=V[Z@030000003V^jT0i[^Y00L0i[^Y00<000000>VfWP3Y]Yh01@3Y]Yh00`000000
n<VJ0?S9VP040?S9VP030000003k`hL0nl>700@0nl>70P0000030?>lA@030000003oool0oooo0240
oooo00<000000?ooo`3oool05@3oool002P0oooo00<000000?ooo`3oool0>@3oool01P0000000011
0000@@000000001Y000000D09QJ600<0000003X_V@0j;iT0100j;iT00`000000I4ZN06A:WP0406A:
WP030000001]F:T0KERY00P0KERY00<0000008EWZ@25IjT02`25IjT2000000H0RW6a00<0000009Yk
/02JNk00502JNk000`000000Z8F_0:R5[`0E0:R5[`030000002dSZl0]8j_01H0]8j_00<000000;nH
[`2oV:l05P2oV:l00`000000bj>`0<^S/00D0<^S/0030000003F[k40eZna00<0eZna00@000000=J_
/@0000000000303IZjT00`000000i[^Y0>JkZ@080>JkZ@8000001@3Y]Yh00`000000n<VJ0?S9VP05
0?S9VP030000003k`hL0nl>700<0nl>700<000000?c@K@0000000P3c_4D00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo01D0oooo000W0?ooo`030000003oool0oooo03X0oooo00H000000000
@@00044000000000J@00000402HFQP030000000j;iT0>RnI00D0>RnI00<0000006A:WP1TBYh00`1T
BYh00`000000KERY06eHZ@0906eHZ@0300000025IjT0QFNY00T0QFNY0P00000808Ya/@030000002J
Nk00VW^`01@0VW^`00<000000:R5[`2XQJl05@2XQJl00`000000]8j_0;B>[`0:0;B>[a000000502o
V:l00`000000bj>`0<^S/00E0<^S/0030000003F[k40eZna00<0eZna00@000000=J_/@3F[k40eZna
0P00000:0=V[Z@030000003V^jT0i[^Y00X0i[^Y00<000000>VfWP3Y]Yh00P3Y]Yh00`000000n<VJ
0?S9VP060?S9VP050000003k`hL0nl>70?_3Q`0000000P3ld6d010000000lka50?>lA@00000S0?oo
o`030000003oool0oooo01D0oooo000W0?ooo`030000003oool0oooo03X0oooo00H000000000@@00
044000000000J@00000402HFQP030000000j;iT0>RnI00D0>RnI00<0000006A:WP1TBYh00P1TBYh0
0`000000KERY06eHZ@0;06eHZ@0300000025IjT0QFNY00H0QFNY0P00000:08Ya/@030000002JNk00
VW^`01@0VW^`00<000000:R5[`2XQJl04P2XQJl@000000`0]9Bf00@000000;jM]P2nWKH0_Yff2000
000<0;nH[`030000003;Xk00bj>`01@0bj>`00<000000=J_/@3F[k40103F[k400`000000eZna0=J_
/@030=J_/@8000001`3IZjT00`000000i[^Y0>JkZ@0<0>JkZ@040000003Y]Yh0jKJN000000X0n<VJ
00@000000?_3Q`3k`hL000000P3ld6d010000000lka50?>lA@00000S0?ooo`030000003oool0oooo
01D0oooo000W0?ooo`030000003oool0oooo03X0oooo00H000000000@@00044000000000J@000003
02HFQP030000000j;iT0>RnI00H0>RnI00<0000006A:WP1TBYh00P00000>06eHZ@0300000025IjT0
QFNY00@0QFNY0P00000<08Ya/@030000002JNk00VW^`01D0VW^`00<000000:R5[`2XQJl02@2XQJl8
000000<0ZH^f00<000000;BD]P2dU;H05P2dU;H00`000000_Yff0;jM]P090;jM]PP00000102oV:l0
0`000000bj>`0<^S/00D0<^S/0030000003F[k40eZna00@0eZna00<000000=J_/@3F[k401@3F[k42
000000D0fJ^Y00<000000>JkZ@3V^jT03@3V^jT3000000/0n<VJ00<000000?_3Q`0000000`3ld6d0
0`000000lka50000000S0?ooo`030000003oool0oooo01D0oooo000W0?ooo`030000003oool0oooo
03X0oooo00<000000000@@0000000P0006T0100000009QJ602HFQP00000:03X_V@800000401]F:T0
0`000000QFNY08EWZ@0208EWZ@8000003P2:LK400`000000VW^`09Yk/00E09Yk/0040000002XQJl0
Z8F_0:R5[`P000002`2YRkH00`000000]9Bf0;BD]P0F0;BD]P030000002nWKH0_Yff0140_Yff1P00
000E0<^S/0030000003F[k40eZna00@0eZna00<000000=J_/@3F[k401`3F[k42000000<0fJ^Y00<0
00000>JkZ@3V^jT03`3V^jT00`000000n<VJ0?S9VP090?S9VP030000003k`hL0000000<0o=1]00<0
00000?>lA@0000008`3oool00`000000oooo0?ooo`0E0?ooo`009`3oool2000003/0oooo00<00000
0000@@0000000`0006T2000000/0>RnI00<0000006eHZ@1]F:T0401]F:T010000000QFNY00000000
000A08Ya/@030000002JNk00VW^`01<0VW^`1@00000C0:V;]P030000002dU;H0]9Bf01H0]9Bf00<0
00000;jM]P2nWKH05@2nWKH00`000000bJNg0000000300000100bj>`00<000000=J_/@3F[k401@3F
[k400`000000eZna0=J_/@090=J_/@<000004P3V^jT2000000/0n<VJ0P0000030?c@K@030000003c
_4D0000002<0oooo00<000000?ooo`3oool05@3oool002L0oooo00<000000?ooo`3oool0>P3oool0
0`0000000011000000030000J@8000002P0j;iT200000180KERY0P00000C08Ya/@030000002JNk00
VW^`00l0VW^`100000000`2LPkL000000:V;]P0F0:V;]P030000002dU;H0]9Bf01D0]9Bf00<00000
0;jM]P2nWKH05@2nWKH00`000000bJNg0<VW]`030<VW]`<000003@3;Xk000`000000eZna0=J_/@05
0=J_/@030000003F[k40eZna00/0eZna00<000000>JkZ@3V^jT03`3V^jT00`000000llfX0000000<
0?S9VP030000003ld6d0o=1]0080o=1]0P00000T0?ooo`030000003oool0oooo01@0oooo000V0?oo
o`030000003oool0oooo03`0oooo0P0000030000J@030000000j;iT0>RnI00T0>RnI00<0000004U4
Z0000000401]F:T2000001@0RW6a00<0000009Yk/02JNk002`2JNk04000000D0W8>g00<000000:V;
]P2YRkH05@2YRkH00`000000]9Bf0;BD]P0E0;BD]P030000002nWKH0_Yff01@0_Yff00<000000<VW
]`39YkL01`39YkL4000000T0bj>`00<000000=J_/@3F[k401@3F[k400`000000eZna0=J_/@0;0=J_
/@<000003`3V^jT010000000llfX0??=Z000000;0?S9VP030000003ld6d0o=1]0080o=1]0P00000T
0?ooo`030000003oool0oooo01@0oooo000V0?ooo`030000003oool0oooo03`0oooo0P0000030000
J@030000000j;iT0>RnI00P0>RnI00@0000004U4Z019A:P000003P1]F:T200000080M6Fc00<00000
08Ya/@2:LK404@2:LK400`000000VW^`09Yk/00809Yk/0<000002P2LPkL00`000000ZH^f0:V;]P0D
0:V;]P030000002dU;H0]9Bf01D0]9Bf00<000000;jM]P2nWKH0502nWKH00`000000bJNg0<VW]`0;
0<VW]`<000001P3;Xk000`000000eZna0=J_/@040=J_/@800000303F[k401@000000h[jc0>:n/`3R
_[<0000000h0i[^Y00D000000??=Z03ccJP0llfX000000090?S9VP030000003og8/0000000<0o=1]
0P00000T0?ooo`030000003oool0oooo01@0oooo000V0?ooo`030000003oool0oooo03`0oooo00@0
00000000J@0006T0001Y0P00000903X_V@0500000019A:P0BDBX04U4Z00000003@1]F:T00`000000
M6Fc07AU/`0207AU/`030000002:LK40RW6a0180RW6a00<0000009Yk/02JNk000`2JNk04000000d0
W8>g00<000000:V;]P2YRkH0502YRkH00`000000]9Bf0;BD]P0D0;BD]P030000002nWKH0_Yff01D0
_Yff00<000000<VW]`39YkL03P39YkL4000000030<^S/0000000eZna00<0eZna0`0000020=J_/@03
0000003F[k40eZna00T0eZna00<000000>:n/`3R_[<00P3R_[<00`000000i[^Y0>JkZ@0:0>JkZ@03
0000003ccJP0llfX00<0llfX00<000000?S9VP3hbIX01P3hbIX00`000000omb;000000040?c@K@03
0000003oool0oooo0280oooo00<000000?ooo`3oool0503oool002H0oooo00<000000?ooo`3oool0
?03oool01`000000001Y0000J@0006T000000003R@0000001`0j;iT00`000000BDBX04U4Z00304U4
Z0030000001]F:T0KERY00T0KERY00<0000007AU/`1dIK<0101dIK<00`000000RW6a08Ya/@0A08Ya
/@030000002JNk00000000<000004@2LPkL00`000000ZH^f0:V;]P0D0:V;]P030000002dU;H0]9Bf
01@0]9Bf00<000000;jM]P2nWKH05@2nWKH00`000000bJNg0<VW]`0B0<VW]`H000001P3F[k400`00
0000eZna0=J_/@080=J_/@030000003R_[<0h[jc00<0h[jc0P00000:0>JkZ@030000003ccJP0llfX
00<0llfX00<000000?S9VP3hbIX01P3hbIX00`000000omb;000000040?c@K@030000003oool0oooo
0280oooo00<000000?ooo`3oool0503oool002H0oooo00<000000?ooo`3oool0?03oool01`000000
001Y0000J@0006T000000003R@0000001`0j;iT00`000000BDBX04U4Z00304U4Z0030000001]F:T0
KERY00P0KERY00<0000007AU/`1dIK<01@1dIK<00`000000RW6a08Ya/@0@08Ya/@<000005@2LPkL0
0`000000ZH^f0:V;]P0D0:V;]P030000002dU;H0]9Bf01@0]9Bf00<000000;jM]P2nWKH05@2nWKH0
0`000000bJNg0<VW]`0A0<VW]`<0000000<0dk>i0000000000001`3F[k400`000000eZna0=J_/@07
0=J_/@030000003R_[<0h[jc00H0h[jc00<000000>JkZ@3V^jT01`3V^jT00`000000llfX0??=Z004
0??=Z0030000003hbIX0n<VJ00@0n<VJ00@000000?oLR`3og8/00000103ld6d00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo01@0oooo000V0?ooo`030000003oool0oooo03`0oooo00L00000
0000J@0006T0001Y000000000hT0000000H0>RnI00<0000004U4Z019A:P01019A:P00`000000KERY
06eHZ@0606eHZ@800000201dIK<00`000000RW6a08Ya/@0>08Ya/@80000000<0SWZi0000002LPkL0
5@2LPkL00`000000ZH^f0:V;]P0D0:V;]P030000002dU;H0]9Bf01@0]9Bf00<000000;jM]P2nWKH0
502nWKH00`000000bJNg0<VW]`0?0<VW]`<0000000<0bJNg0000003C/kT00`3C/kT2000000H0eZna
00<000000=J_/@3F[k401P3F[k400`000000h[jc0>:n/`070>:n/`030000003V^jT0i[^Y00H0i[^Y
00<000000??=Z03ccJP01@3ccJP00`000000n<VJ0?S9VP030?S9VP050000003og8/0omb;0?oLR`00
00000`3ld6d00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo01@0oooo000V0?ooo`030000
003oool0oooo03`0oooo00@000000000J@0006T000000P000hT00`000000>RnI03X_V@0303X_V@03
00000019A:P0BDBX00D0BDBX00<0000006eHZ@1]F:T01@1]F:T00`000000M6Fc07AU/`0907AU/`03
0000002:LK40RW6a00/0RW6a0P00000408ij^@030000002LPkL0W8>g01@0W8>g00<000000:V;]P2Y
RkH0502YRkH00`000000]9Bf0;BD]P0C0;BD]P030000002nWKH0_Yff01@0_Yff00<000000<VW]`39
YkL03039YkL3000000@0bJNg00<000000=>c^@3C/kT0103C/kT2000000D0eZna00<000000=J_/@3F
[k401@3F[k400`000000h[jc0>:n/`080>:n/`8000001@3V^jT00`000000llfX0??=Z0060??=Z003
0000003hbIX0n<VJ00<0n<VJ00D000000?oLR`3og8/0omb;000000020?c@K@8000009@3oool00`00
0000oooo0?ooo`0C0?ooo`009@3oool00`000000oooo0?ooo`0m0?ooo`040000000006T0001Y0000
00<000>900<0000003X_V@0j;iT00P0j;iT00`000000BDBX04U4Z00604U4Z0030000001]F:T0KERY
00<0KERY00<0000007AU/`1dIK<02P1dIK<00`000000RW6a08Ya/@0908Ya/@8000001P2>N[T00`00
0000W8>g09b3]`0D09b3]`030000002YRkH0ZH^f01@0ZH^f00<000000;BD]P2dU;H04`2dU;H00`00
0000_Yff0;jM]P0D0;jM]P0300000039YkL0bJNg00P0bJNg100000070<VW]`030000003C/kT0dk>i
00H0dk>i0P0000040=J_/@030000003F[k40eZna00@0eZna00<000000>:n/`3R_[<02P3R_[<00`00
0000i[^Y0>JkZ@020>JkZ@030000003ccJP0llfX00L0llfX00D000000?S9VP3hbIX0n<VJ00000004
0?oLR`040000003ld6d0o=1]000002H0oooo00<000000?ooo`3oool04`3oool002D0oooo00<00000
0?ooo`000000?@3oool010000000001Y0000J@0000030003R@050000000j;iT0>RnI03X_V@000000
2@19A:P00`000000KERY06eHZ@0206eHZ@030000001dIK<0M6Fc00/0M6Fc00<0000008Ya/@2:LK40
1`2:LK42000000P0SWZi00<0000009b3]`2LPkL0502LPkL00`000000ZH^f0:V;]P0D0:V;]P030000
002dU;H0]9Bf01<0]9Bf00<000000;jM]P2nWKH0502nWKH00`000000bJNg0<VW]`050<VW]`<00000
2`39YkL00`000000dk>i0=>c^@080=>c^@8000000`3F[k400`000000eZna0=J_/@020=J_/@030000
003R_[<0h[jc00`0h[jc00D000000>JkZ@3V^jT0i[^Y0000000:0??=Z0040000003hbIX0n<VJ0000
00@0omb;00@000000?c@K@3ld6d000009P3oool00`000000oooo0?ooo`0C0?ooo`009@3oool20000
03h0oooo00@000000000J@0006T000000`000hT010000000>RnI03X_V@00000:04U4Z0030000001]
F:T0KERY008000003`1dIK<00`000000RW6a08Ya/@0408Ya/@8000002`2>N[T00`000000W8>g09b3
]`0C09b3]`030000002YRkH0ZH^f0140ZH^f7@00000C0;jM]P0300000039YkL0bJNg0080bJNg0`00
000=0<VW]`030000003C/kT0dk>i00/0dk>i0P0000020=J_/@050000003F[k40eZna0=J_/@000000
3`3R_[<3000000`0llfX00<000000?S9VP0000001@3og8/00`000000o=1]0000000V0?ooo`030000
003oool0oooo01<0oooo000U0?ooo`030000003oool0oooo03d0oooo0`0000040003R@030000000j
;iT0000000`0BDBX0P00000A07AU/`030000002:LK40RW6a0080RW6a0P00000=08ij^@030000002L
PkL0W8>g01@0W8>g00<000000:V;]P2YRkH02@2YRkH7000000<0ZY6l00<000000;BI_02dVK`04`2d
VK`010000000_Z:l0;jR_02nX[`7000000/0_Yff00<000000<VW]`0000000`00000@0<VW]`030000
003C/kT0dk>i00d0dk>i0`0000030=J_/@030000003R_[<0h[jc00l0h[jc00<000000??=Z03ccJP0
2P3ccJP2000000H0omb;00<000000?c@K@0000009P3oool00`000000oooo0?ooo`0C0?ooo`009@3o
ool00`000000oooo0?ooo`0m0?ooo`<000001@000hT2000000`0BDBX00<0000007AU/`1dIK<04@1d
IK<010000000RW6a00000000000?08ij^@030000002LPkL0W8>g01@0W8>g00@000000:V;]P2YRkH0
ZH^f2000000:0:ZA_0030000002dVK`0]9Vl01<0]9Vl00<000000;jR_02nX[`0202nX[`800000080
_Yff0`00000D0<VW]`030000003C/kT0dk>i00l0dk>i0P0000000`3F[k4000000>:n/`0A0>:n/`80
0000303ccJP00`000000omb;0?oLR`040?oLR`030000003ld6d0000002H0oooo00<000000?ooo`3o
ool04`3oool002D0oooo00<000000?ooo`3oool0?P3oool2000000D000>900<0000004U4Z019A:P0
2P19A:P2000001<0M6Fc0P00000B08ij^@030000002LPkL0W8>g0180W8>g1@00000B0:ZA_0030000
002dVK`0]9Vl01<0]9Vl00<000000;jR_02nX[`03`2nX[`6000001<0bJNg00<000000=>c^@3C/kT0
4P3C/kT200000140h[jc00@000000>k@]@3^d;D000002`3ccJP00`000000omb;0?oLR`040?oLR`<0
00009P3oool00`000000oooo0?ooo`0C0?ooo`00903oool00`000000oooo0?ooo`0o0?ooo`800000
1@000hT00`000000BDBX04U4Z00904U4Z0040000001GEKD0EeFe00000140M6Fc0P00000C08ij^@03
0000002LPkL0W8>g00l0W8>g0`0000000`2NR[h000000:ZA_00D0:ZA_0030000002dVK`0]9Vl01<0
]9Vl00<000000;jR_02nX[`0302nX[`3000000@0_Z:l00<000000<N[_P0000000`00000?0<VW]`03
0000003C/kT0dk>i01<0dk>i0`00000?0>:n/`040000003^d;D0k]2e000000X0llfX00<000000?cR
XP0000001P3og8/2000002H0oooo00<000000?ooo`3oool04`3oool002@0oooo00<000000?ooo`3o
ool0?`3oool00`00000000>90003R@040003R@8000002P19A:P010000000EeFe05ME]@00000?07AU
/`8000000P1kLK`00`000000SWZi08ij^@0A08ij^@030000002LPkL0W8>g00X0W8>g1000000409j:
_P030000002ZTK`0ZY6l01<0ZY6l00<000000;BI_02dVK`04`2dVK`00`000000_Z:l0;jR_0080;jR
_0@000001`2nX[`00`000000aj^n0<N[_P030<N[_P@000002`39YkL00`000000dk>i0=>c^@0B0=>c
^@050000003N`K`000000=k1_00000003@3R_[<00`000000k]2e0>k@]@020>k@]@030000003ccJP0
llfX00L0llfX00<000000?cRXP0000001P3og8/2000002L0oooo00<000000?ooo`3oool04P3oool0
02@0oooo00<000000?ooo`3oool0?`3oool00`00000000>90003R@030003R@030000000A8j400000
00T0BDBX00<0000005ME]@1GEKD00P1GEKD00`000000M6Fc07AU/`0;07AU/`030000001kLK`0Ng6l
0080Ng6l00<0000008ij^@2>N[T04@2>N[T00`000000W8>g09b3]`0709b3]`<000002@2NR[h00`00
0000ZY6l0:ZA_00B0:ZA_0030000002dVK`0]9Vl01<0]9Vl00<000000;jR_02nX[`01@2nX[`30000
00X0_Z:l00<000000<N[_P37Zkh02037Zkh4000000L0bJNg00<000000=>c^@3C/kT04P3C/kT00`00
0000g/6l000000020=k1_0030000003R_[<0h[jc00X0h[jc00<000000>k@]@3^d;D00`3^d;D00`00
0000llfX0??=Z0060??=Z0040000003lhZ80o>:R000000D0omb;00<000000?ooo`3oool09P3oool0
0`000000oooo0?ooo`0B0?ooo`00903oool00`000000oooo0?ooo`0o0?ooo`03000000000hT000>9
00<000>900@00000014SX@0A8j4000001`19A:P00`000000EeFe05ME]@0305ME]@030000001dIK<0
M6Fc00X0M6Fc00<0000007]a_01kLK`0101kLK`00`000000SWZi08ij^@0@08ij^@030000002LPkL0
W8>g00@0W8>g0`00000<09j:_P030000002ZTK`0ZY6l0180ZY6l00<000000;BI_02dVK`04`2dVK`0
0`000000_Z:l0;jR_0020;jR_0<000003@2nX[`00`000000aj^n0<N[_P0<0<N[_P@000000P39YkL0
0`000000dk>i0=>c^@0B0=>c^@050000003N`K`0g/6l0=k1_00000000P3N`K`2000000T0h[jc00<0
00000>k@]@3^d;D01@3^d;D00`000000llfX0??=Z0040??=Z0050000003lhZ80o>:R0?cRXP000000
103og8/2000002P0oooo00<000000?ooo`3oool04P3oool002@0oooo00<000000?ooo`3oool0?`3o
ool2000000@000>900@00000014SX@0A8j4000001P19A:P00`000000EeFe05ME]@0505ME]@030000
001dIK<0M6Fc00P0M6Fc00<0000007]a_01kLK`01@1kLK`00`000000SWZi08ij^@0A08ij^@030000
002LPkL0000000<000003`2NR[h00`000000ZY6l0:ZA_00C0:ZA_0030000002dVK`0]9Vl0140]9Vl
00<000000;jR_02nX[`00`00000@0;jR_00300000037Zkh0aj^n0100aj^n1000000C0=>c^@030000
003N`K`0g/6l0080g/6l00D000000=k1_03N`K`0g/6l000000080>:n/`030000003^d;D0k]2e00H0
k]2e00<000000??=Z03ccJP00`3ccJP01@000000o>:R0?cRXP3lhZ80000000@0omb;0P00000X0?oo
o`030000003oool0oooo0180oooo000T0?ooo`030000003oool0000003l0oooo0P0000040003R@05
0000000A8j404B>Q014SX@0000001@19A:P00`000000EeFe05ME]@0505ME]@030000001dIK<0M6Fc
00H0M6Fc0P00000807]a_0030000002>N[T0SWZi0100SWZi0`00000C09j:_P030000002ZTK`0ZY6l
01<0ZY6l00<000000;BI_02dVK`0402dVK`4000001<0_Z:l00<000000<N[_P37Zkh04P37Zkh01000
0000d;K000000000000@0=>c^@030000003N`K`0g/6l00@0g/6l00@000000=k1_03N`K`0g/6l0P00
00060>:n/`030000003^d;D0k]2e00L0k]2e00D000000??=Z03ccJP0llfX000000050?cRXP040000
003og8/0omb;0?oLR`800000:03oool00`000000oooo0?ooo`0B0?ooo`00903oool200000400oooo
0P0000030003R@030000000A8j404B>Q00804B>Q00<0000004U4Z019A:P00P19A:P00`000000EeFe
05ME]@0705ME]@030000001dIK<0M6Fc00@0M6Fc00<0000007]a_01kLK`02@1kLK`00`000000SWZi
08ij^@0=08ij^@80000000<0TH?00000002NR[h04`2NR[h00`000000ZY6l0:ZA_00C0:ZA_0030000
002dVK`0]9Vl00d0]9Vl0`0000000`2dVK`000000;jR_00C0;jR_00300000037Zkh0aj^n0180aj^n
00<000000=2f`03@]/000P3@]/02000000h0dk>i00<000000=k1_03N`K`01@3N`K`00`000000g/6l
0=k1_0020=k1_0030000003R_[<0h[jc0080h[jc00<000000>k@]@3^d;D0203^d;D01@000000llfX
0??=Z03ccJP0000000D0o>:R00H000000?oLR`3og8/000000>3GH000000X0?ooo`030000003oool0
oooo0180oooo00050?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002Ke005
0?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`100?ooo`<000000P00
0hT00`0000004B>Q014SX@03014SX@0400000019A:P0BDBX000000X0EeFe00<0000007AU/`1dIK<0
0`1dIK<00`000000Ng6l07]a_00:07]a_0030000002>N[T0SWZi00X0SWZi0`0000040963`0030000
002NR[h0WXZn0180WXZn00<000000:ZA_02ZTK`04P2ZTK`00`000000]9Vl0;BI_00:0;BI_0<00000
102dVK`00`000000_Z:l0;jR_00B0;jR_00300000037Zkh0aj^n0180aj^n00<000000=2f`03@]/00
103@]/02000000/0dk>i00<000000=k1_03N`K`01`3N`K`00`000000g/6l0=k1_0020=k1_0050000
003R_[<0h[jc0>:n/`0000002`3^d;D010000000llfX0??=Z00000050?cRXP060000003og8/0omb;
0000003Pef000000:03oool00`000000oooo0?ooo`0B0?ooo`001@3oool01P2jLY/0e?oo0?ooo`3o
om@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780
002Ke?l01P3oool00`000000oooo0?ooo`100?ooo`<000000P000hT00`0000004B>Q014SX@03014S
X@0300000019A:P0000000`0EeFe00<0000007AU/`1dIK<00P00000=07]a_0030000002>N[T0SWZi
00P0SWZi0P0000070963`0030000002NR[h0WXZn0180WXZn00<000000:ZA_02ZTK`04P2ZTK`00`00
0000]9Vl0;BI_0070;BI_0<000001`2dVK`00`000000_Z:l0;jR_00B0;jR_00300000037Zkh0aj^n
0180aj^n00<000000=2f`03@]/001P3@]/02000000T0dk>i00<000000=k1_03N`K`01`3N`K`00`00
0000g/6l0=k1_0030=k1_0<000003@3^d;D2000000L0o>:R00<000000?oLR`0000000P00000Y0?oo
o`030000003oool0oooo0140oooo00040?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3o
ool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo0440oooo00D000000000F`00
000000>900000006014SX@800000301GEKD00`000000M6Fc0000000@07]a_0030000002>N[T0SWZi
00D0SWZi0P00000:0963`0030000002NR[h0WXZn0140WXZn00<000000:ZA_02ZTK`04P2ZTK`00`00
0000]9Vl0;BI_0030;BI_0@000002P2dVK`00`000000_Z:l0;jR_00B0;jR_00300000037Zkh0aj^n
0140aj^n00<000000=2f`03@]/002@3@]/02000000H0dk>i00<000000=k1_03N`K`02@3N`K`00`00
0000g/6l0=k1_0040=k1_0030000003^d;D0k]2e00`0k]2e00<000000?cRXP3lhZ801@3lhZ800`00
0000omb;00000002000002T0oooo00<000000?ooo`3oool04@3oool000@0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3o
ool0@@3oool01@000000001K000000000hT0000000H04B>Q00<0000005ME]@1GEKD0301GEKD00`00
0000Ng6l07]a_00?07]a_0030000002>N[T0SWZi0080SWZi0`00000<0963`0030000002NR[h0WXZn
0140WXZn00<000000:ZA_02ZTK`04P2ZTK`00`000000]9Vl0;BI_003000000h0]9Vl00<000000;jR
_02nX[`04P2nX[`00`000000aj^n0<N[_P0A0<N[_P030000003@]/00d;K000/0d;K00P0000040=>c
^@030000003N`K`0g/6l00X0g/6l00<000000=k1_03N`K`00P3N`K`00`000000j=:o0000000<0>k@
]@800000203lhZ800`000000h=MP0000000Z0?ooo`030000003oool0oooo0140oooo00040?ooo`03
0>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`050?ooo`03
0000003oool0oooo0440oooo00@000000000F`00000000001`0A8j42000000`0EeFe00<00000069U
_`0000004@1kLK`010000000SWZi00000000000?0963`0030000002NR[h0WXZn0180WXZn00<00000
0:ZA_02ZTK`03@2ZTK`M000000l0_Z:l00<000000<N[_P37Zkh04@37Zkh00`000000d;K00=2f`00>
0=2f`080000000<0dk>i0000003N`K`03@3N`K`01@000000g/6l0=k1_03N`K`000000080j=:o00<0
00000>k@]@3^d;D02@3^d;D00`000000mnFc000000070?cRXP030000003Pef00000002X0oooo00<0
00000?ooo`3oool04@3oool000@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:
0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?ooo`11
0?ooo`040000000005/0001K000000H04B>Q00<0000002Tn/`0000002`1GEKD010000000HVFo069U
_`00000A07]a_08000004P2APl000`000000WXZn09j:_P0A09j:_P030000002ZTK`0ZY6l00<0ZY6l
3`00000C0;>N``030000002lY/<0_:K30080_:K32P0000050;jR_00300000037Zkh0aj^n0140aj^n
00<000000=2f`03@]/00403@]/02000000l0g/6l00<000000=k1_00000000`3Xd[l00`000000k]2e
0>k@]@080>k@]@040000003giK<0mnFc000000L0o>:R00<000000>3GH0000000:P3oool00`000000
oooo0?ooo`0A0?ooo`00103oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo
00<0oooD09/0V`3Dool02@3oool00`000000oooo0?ooo`120?ooo`80000000<0001K0000000A8j40
1@0A8j4010000000:Cjc02Tn/`00000:05ME]@050000001RIKl0HVFo069U_`0000003`1kLK`00`00
0000PG_40000000B0963`0030000002NR[h0WXZn0100WXZn1`0000070:ZH``<00000102ZV<<00`00
0000/ik30;>N``0A0;>N``030000002lY/<0_:K300`0_:K31`00000B0<N[_P030000003@]/00d;K0
0100d;K000@000000=[3``00000000003@3N`K`00`000000g/6l000000040>SB_`030000003^d;D0
k]2e00L0k]2e00@000000?OU/`3giK<000001P3lhZ82000000030>3GH0000000oooo02T0oooo00<0
00000?ooo`3oool04@3oool000D0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?oo
e02K09/0e?oo00T0oooo00<000000?ooo`3oool0@`3oool00`000000001K00000006014SX@040000
000Y?[<0:Cjc000000T0EeFe00<00000069U_`1RIKl00P1RIKl00`000000Ng6l07]a_00<07]a_004
00000021Nl@0PG_400000180TH?000<0000009j:_P2NR[h0302NR[h4000000030:2Aa@000000ZYS3
00P0ZYS30`0000070:ZH``030000002cW/<0/ik30140/ik300<000000;bV``2lY/<04@2lY/<00`00
0000aJo400000003000000d0aj^n00<000000=2f`03@]/004@3@]/001@000000f/?30=[3``3J`l<0
000000d0g/6l00<000000>SB_`3Xd[l0103Xd[l00`000000k]2e0>k@]@050>k@]@030000003giK<0
mnFc0080mnFc00<000000?cRXP3lhZ800`3lhZ82000000030>3GH0000000oooo02T0oooo00<00000
0?ooo`3oool04@3oool000D0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K0000
00000080000000<0002K0=Coo`3oool0103oool00`000000oooo0?ooo`130?ooo`040000000005/0
0000000000@04B>Q00<0000002Tn/`0Y?[<00P0Y?[<00`000000EeFe05ME]@0505ME]@030000001R
IKl0HVFo00@0HVFo00<0000007]a_01kLK`02@1kLK`2000000@0PG_400<000000963`02APl00402A
Pl000`000000WXZn09j:_P0809j:_P<000001P2PTLD00`000000ZYS30:ZH``030:ZH``<000002P2Z
V<<00`000000/ik30;>N``0A0;>N``030000002lY/<0_:K30100_:K300<000000<F_a035[l@01035
[l@3000000X0aj^n00<000000=2f`03@]/00403@]/000`000000f/?30=[3``030=[3``8000002P3N
`K`00`000000j=:o000000060>SB_`030000003^d;D0k]2e00@0k]2e00<000000?OU/`3giK<00P3g
iK<00`000000o>:R0?cRXP020?cRXP050000003]jXP000000>3GH0000000:`3oool00`000000oooo
0?ooo`0@0?ooo`008P3oool2000004@0oooo00@000000000F`0000000000100A8j400`000000:Cjc
02Tn/`0202Tn/`030000001GEKD0EeFe00@0EeFe00<00000069U_`1RIKl01@1RIKl00`000000Ng6l
07]a_00807]a_00300000021Nl@0PG_400@0PG_400<000000963`02APl00402APl000`000000WXZn
09j:_P0409j:_P@000002@2PTLD00`000000ZYS300000003000000d0ZYS300<000000;>N``2cW/<0
4@2cW/<00`000000_:K30;bV``0@0;bV``0300000035[l@0aJo400L0aJo4100000060<N[_P030000
003@]/00d;K00100d;K000<000000=[3``3J`l<01@3J`l<00`000000g/6l0=k1_0070=k1_0040000
003Xd[l0j=:o000000H0j=:o00<000000>k@]@3^d;D00P3^d;D00`000000mnFc0?OU/`030?OU/`03
0000003lhZ80o>:R0080o>:R00D000000>gZR0000000h=MP0000000[0?ooo`030000003oool0oooo
0100oooo000R0?ooo`030000003oool0oooo04<0oooo00D000000000F`000000002500000003014S
X@030000000Y?[<0:Cjc00<0:Cjc00<0000005ME]@1GEKD00P1GEKD00`000000HVFo069U_`07069U
_`030000001kLK`0Ng6l00H0Ng6l00<00000085ka021Nl@01P21Nl@00`000000TH?00963`00@0963
`0030000002NR[h0000000<00000302PTLD300000140ZYS300<000000;>N``2cW/<04@2cW/<00`00
0000_:K30;bV``0@0;bV``0300000035[l@0aJo400/0aJo4100000000`37Zkh000000=2f`00A0=2f
`0030000003J`l<0f/?300L0f/?300<000000=k1_03N`K`01@3N`K`00`000000j=:o0>SB_`020>SB
_`030000003Xd[l0j=:o00@0j=:o00D000000>k@]@3^d;D0k]2e000000050?OU/`050000003lhZ80
o>:R0?cRXP0000000P3]jXP2000002`0oooo00<000000?ooo`3oool0403oool00280oooo00<00000
0?ooo`3oool0A03oool2000000030000Q@0000004B>Q00804B>Q00<0000002Tn/`0Y?[<00`0Y?[<0
1@000000EeFe05ME]@1GEKD0000000/0HVFo00<0000007]a_01kLK`0101kLK`00`000000PG_4085k
a007085ka0030000002APl00TH?000l0TH?00`00000=0:2Aa@<0000000<0X9750000002ZV<<04@2Z
V<<00`000000/ik30;>N``0@0;>N``030000002lY/<0_:K30140_:K300<000000<F_a035[l@03`35
[l@300000100d;K000<000000=[3``3J`l<02@3J`l<2000000D0g/6l00<000000>SB_`3Xd[l00`3X
d[l00`000000j=:o0>SB_`030>SB_`040000003^d;D0k]2e000000L0mnFc00P000000?cRXP3lhZ80
00000>gZR0000000h=MP000002`0oooo00<000000?ooo`3oool0403oool00240oooo00<000000?oo
o`3oool0A@3oool2000000050000Q@0000004B>Q014SX@0000001`0Y?[<010000000EeFe05ME]@00
000;069U_`030000001kLK`0Ng6l00<0Ng6l00<00000085ka021Nl@02@21Nl@00`000000TH?00963
`00<0963`080000000<0U8_70000002PTLD02P2PTLD3000000D0X97500<000000:ZH``2ZV<<0402Z
V<<00`000000/ik30;>N``0?0;>N``030000002lY/<0_:K30100_:K300<000000<F_a035[l@04@35
[l@010000000cKW700000000000>0=2f`0030000003J`l<0f/?300/0f/?300D000000=k1_03N`K`0
g/6l000000060>SB_`030000003Xd[l0j=:o00@0j=:o00<000000>k@]@0000001`3giK<00`000000
o>:R000000020>gZR0030000003Pef00000002`0oooo00<000000?ooo`3oool0403oool00240oooo
00<000000?ooo`3oool0A@3oool01`000000001K0000000008D00000014SX@0000001`0Y?[<00`00
0000EeFe0000000=069U_`030000001kLK`0Ng6l008000003021Nl@00`000000TH?00963`00:0963
`0800000102DRlL00`000000X9750:2Aa@040:2Aa@@00000202PTLD00`000000ZYS30:ZH``0@0:ZH
``030000002cW/<0/ik300l0/ik300<000000;bV``2lY/<0402lY/<00`000000aJo40<F_a00@0<F_
a0030000003=^LL0cKW70080cKW70`00000:0=2f`0030000003J`l<0f/?300d0f/?30P0000000`3N
`K`000000>SB_`060>SB_`030000003Xd[l0j=:o00@0j=:o00<000000?OU/`3giK<01P3giK<00`00
0000o>:R000000020>gZR0800000;@3oool00`000000oooo0?ooo`0@0?ooo`008@3oool00`000000
oooo0?ooo`150?ooo`070000000005/000000000Q@0000004B>Q0000000802Tn/`030000001RIKl0
HVFo00`0HVFo00<0000007]a_00000003`21Nl@00`000000TH?00963`0070963`08000001P2DRlL0
10000000X9750:2Aa@2PTLD3000000`0X97500<000000:ZH``2ZV<<0402ZV<<00`000000/ik30;>N
``0?0;>N``030000002lY/<0_:K30100_:K300<000000<F_a035[l@04035[l@00`000000cKW70<fi
a`050<fia`800000203@]/000`000000f/?30=[3``0?0=[3``030000003Xd[l0j=:o00L0j=:o00<0
00000>SB_`3Xd[l00P3Xd[l2000000T0mnFc00@000000>gZR03]jXP0kNZ80P00000]0?ooo`030000
003oool0oooo0100oooo000Q0?ooo`030000003oool0oooo04H0oooo0P0000020000Q@030000000Y
?[<0:Cjc00L0:Cjc0P00000>069U_`0300000021Nl@0PG_400h0PG_400<000000963`02APl001@2A
Pl02000000T0U8_70`00000@0:2Aa@030000002ZV<<0ZYS300l0ZYS300<000000;>N``2cW/<03`2c
W/<00`000000_:K30;bV``0?0;bV``0300000035[l@0aJo40100aJo400<000000<fia`3=^LL0203=
^LL3000000@0d;K000<000000=[3``3J`l<03`3J`l<00`000000h]?8000000090>SB_`070000003X
d[l0j=:o0>SB_`000000l>G1000000080?OU/`040000003]jXP0kNZ80>gZR0800000;@3oool00`00
0000oooo0?ooo`0@0?ooo`008@3oool00`000000oooo0?ooo`160?ooo`8000000P0008D00`000000
:Cjc02Tn/`0602Tn/`030000000mE<40000000d0HVFo00<0000006abb00000004021Nl@00`000000
TH?00963`0020963`0800000202DRlL400000180X97500<000000:ZH``2ZV<<03`2ZV<<00`000000
/ik30;>N``0?0;>N``030000002lY/<0_:K300l0_:K300<000000<F_a035[l@04035[l@00`000000
cKW70<fia`0;0<fia`8000000P3@]/000`000000f/?30=[3``0?0=[3``040000003RdlP0h]?80000
00T0j=:o00<000000>SB_`0000000P3`iL400`000000mnFc0?OU/`050?OU/`8000000`3]jXP20000
02h0oooo00<000000?ooo`3oool03`3oool00240oooo00<000000?ooo`3oool0AP3oool200000080
00250P00000702Tn/`040000000mE<40?EC1000000/0HVFo00@0000006abb01/L/P000004021Nl@0
0`000000TH?00963`002000000H0U8_71000000409B;a`030000002PTLD0X97500l0X97500<00000
0:ZH``2ZV<<03`2ZV<<00`000000/ik30;>N``0?0;>N``030000002lY/<0_:K300l0_:K300<00000
0<F_a035[l@03`35[l@00`000000cKW70<fia`0>0<fia`8000004@3J`l<01@000000h]?80>;Cb03R
dlP0000000T0j=:o0P0000030?3U`@030000003giK<0mnFc00D0mnFc0P0000030>gZR0030000003o
ool0oooo02d0oooo00<000000?ooo`3oool03`3oool00240oooo00<000000?ooo`3oool0A`3oool0
0`00000000250000Q@02000000L0:Cjc00D0000003eD`@0mE<40?EC100000009069U_`030000001/
L/P0K7;80080K7;800<00000085ka021Nl@03P21Nl@2000000D0U8_70`00000809B;a`030000002P
TLD0X97500l0X97500<000000:ZH``2ZV<<02`2ZV<<K000000d0_:K300<000000<F_a035[l@03`35
[l@00`000000cKW70<fia`0>0<fia`030000003EaL/0000000l0f/?300<000000>;Cb03RdlP00`3R
dlP00`000000j=:o0>SB_`060>SB_`800000103`iL400`000000mnFc0?OU/`030?OU/`030000003`
m:L0000000<0kNZ800<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0?0?ooo`00803oool0
0`000000oooo0?ooo`180?ooo`060000000008D00025000000006:D000001@0Y?[<00`000000?EC1
03eD`@0203eD`@030000001RIKl0HVFo00H0HVFo00<0000006abb01/L/P0101/L/P00`000000PG_4
085ka00;085ka080000000@0QXG;0000002DRlL0U8_70`00000<09B;a`030000002PTLD0X97500l0
X97500<000000:ZH``2ZV<<00P2ZV<<8000000@0Zik:00<000000;>Tb@2cY<T03`2cY<T00`000000
^j_:0;^[bP020;^[bPP00000102lY/<00`000000aJo40<F_a00?0<F_a0030000003=^LL0cKW700l0
cKW700<000000=G5b`3EaL/00P00000=0=[3``030000003RdlP0h]?800@0h]?800<000000>SB_`3X
d[l01@3Xd[l00`000000l>G1000000030?3U`@030000003giK<0mnFc00<0mnFc00<000000?3dY`00
00000P3]jXP00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00l0oooo000P0?ooo`030000
003oool0000004P0oooo00@000000000Q@0008D000250P00000502Tn/`030000000mE<40?EC100<0
?EC100<00000069U_`1RIKl0101RIKl00`000000K7;806abb00606abb00300000021Nl@0PG_400T0
PG_400@0000008J5b`26QL/0QXG;0`00000?09B;a`030000002PTLD0X97500h0X9751P00000<0:^N
bP030000002cY<T0/jC900l0/jC900<000000;^[bP2kZlX02P2kZlX600000100aJo400<000000<fi
a`3=^LL03P3=^LL00`000000eLG;0=G5b`030=G5b`030000003J`l<0f/?300T0f/?300<000000>;C
b03RdlP01P3RdlP00`000000j=:o0>SB_`030>SB_`050000003`iL40l>G10?3U`@0000000P3`iL40
0`000000mnFc0?OU/`020?OU/`040000003`m:L0l?BW00000080kNZ800<000000?ooo`3oool0;P3o
ool00`000000oooo0?ooo`0?0?ooo`00803oool2000004X0oooo00H000000000Q@0008D00000000H
Y@00000402Tn/`030000000mE<40?EC100<0?EC100<00000069U_`1RIKl0101RIKl00`000000K7;8
06abb00606abb00300000021Nl@0PG_400P0PG_41@0000000`26QL/0000009B;a`0@09B;a`030000
002PTLD0X97500T0X975100000000`2QV</000000:^NbP0?0:^NbP030000002cY<T0/jC900l0/jC9
00<000000;^[bP2kZlX03P2kZlX00`000000`[?;00000003000000/0aJo400<000000<fia`3=^LL0
3`3=^LL00`000000eLG;0=G5b`040=G5b`030000003J`l<0f/?300L0f/?300<000000>;Cb03RdlP0
203RdlP01@000000j=:o0>SB_`3Xd[l0000000D0l>G100@000000?3U`@3`iL4000000P3giK<01`00
0000l?BW0?3dY`3`m:L000000>gZR0000000<@3oool00`000000oooo0?ooo`0?0?ooo`00803oool0
0`000000oooo0?ooo`190?ooo`040000000008D000250000008001RU00@0000002Tn/`0Y?[<00000
1`0mE<400`000000HVFo069U_`02069U_`030000001/L/P0K7;800P0K7;800<00000085ka021Nl@0
1@21Nl@3000000H0QXG;00<0000009B;a`2DRlL03P2DRlL00`000000X9750:2Aa@050:2Aa@@00000
1P2QV</00`000000Zik:0:^NbP0>0:^NbP030000002cY<T0/jC900h0/jC900<000000;^[bP2kZlX0
3@2kZlX00`000000`[?;0<:cb`040<:cb`@000001`35[l@00`000000cKW70<fia`0>0<fia`030000
003EaL/0eLG;00H0eLG;0P0000070=[3``030000003RdlP0h]?800P0h]?800@000000>SB_`3Xd[l0
00001`3`iL400`000000l>G1000000020?OU/`040000003`m:L0l?BW00000080kNZ800<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`0?0?ooo`00803oool00`000000oooo0?ooo`1:0?ooo`03
0000000008D00000008001RU00@0000002Tn/`0Y?[<00000200mE<4010000000HVFo069U_`00000<
06abb00400000021Nl@0PG_4085ka0<000002@26QL/00`000000U8_709B;a`0?09B;a`030000002P
TLD0X97500@000002P2QV</00`000000Zik:0:^NbP0>0:^NbP030000002cY<T0/jC900h0/jC900<0
00000;^[bP2kZlX03@2kZlX00`000000`[?;0<:cb`080<:cb`@000000P35[l@00`000000cKW70<fi
a`0?0<fia`030000003EaL/0eLG;00P0eLG;00<000000=[3``3J`l<00`3J`l<00`000000h]?80>;C
b00:0>;Cb0030000003Xd[l0000000L0l>G100D000000?3U`@000000mnFc000000030?3dY`030000
003]jXP0000003<0oooo00<000000?ooo`3oool03P3oool00200oooo00<000000?ooo`3oool0BP3o
ool00`000000002500000003000HY@030000000Y?[<0000000P0?EC100<00000069U_`0000003@1/
L/P400000003085ka0000000QXG;00X0QXG;00<0000009B;a`2DRlL03@2DRlL4000000h0XIS;00<0
00000:^NbP2[W/X03P2[W/X00`000000/jC90;>Tb@0>0;>Tb@030000002kZlX0^j_:00d0^j_:00<0
00000<:cb`32/l/03032/l/4000000l0cKW700<000000=G5b`3EaL/02P3EaL/01@000000f/?30=[3
``3J`l<0000000h0h]?800<000000?3U`@3`iL401`3`iL4010000000l>G10000000000030?3dY`03
0000003]jXP0000003<0oooo00<000000?ooo`3oool03P3oool001l0oooo00<000000?ooo`3oool0
C03oool2000000<001RU0P00000:03eD`@030000001/L/P0K7;800T0K7;80`0000000`1/L/P00000
085ka002000000d0QXG;00<0000009B;a`2DRlL02P2DRlL200000080Ui?>00<000000:6Hb`2QV</0
3P2QV</00`000000Zik:0:^NbP0=0:^NbP030000002cY<T0/jC900d0/jC900<000000;^[bP2kZlX0
3@2kZlX00`000000`[?;0<:cb`0>0<:cb`0300000039_<h0bKc>008000003@3=^LL00`000000eLG;
0=G5b`0;0=G5b`80000000<0f/?30000003RdlP0303RdlP2000000X0l>G10P0000040?3dY`800000
=03oool00`000000oooo0?ooo`0>0?ooo`007`3oool00`000000oooo0?ooo`1<0?ooo`0300000000
08D0000000<001RU00<0000003eD`@0mE<40200mE<42000000L0K7;80`00000506abb00300000026
QL/0QXG;00d0QXG;00<0000009B;a`2DRlL0202DRlL2000000@0Ui?>00<000000:6Hb`2QV</03P2Q
V</00`000000Zik:0:^NbP0=0:^NbP030000002cY<T0/jC900d0/jC900<000000;^[bP2kZlX03@2k
ZlX00`000000`[?;0<:cb`0>0<:cb`0300000039_<h0bKc>0080bKc>0P00000:0<fia`030000003E
aL/0eLG;00h0eLG;00<000000>;Cb03RdlP0303RdlP00`000000jNG<000000090?3U`@800000103`
m:L2000003@0oooo00<000000?ooo`3oool03P3oool001l0oooo00<000000?ooo`3oool0C@3oool2
000000<001RU0P00000803eD`@040000001>Il`0CVO<000000<0K7;80`00000706abb0030000001d
Om00000000l0QXG;00<0000009B;a`2DRlL01@2DRlL2000000L0Ui?>00<000000:6Hb`2QV</03@2Q
V</00`000000Zik:0:^NbP0=0:^NbP030000002cY<T0/jC900d0/jC900<000000;^[bP2kZlX03@2k
ZlX00`000000`[?;0<:cb`0=0<:cb`0300000039_<h0bKc>00D0bKc>0`0000070<fia`030000003E
aL/0eLG;00d0eLG;00<000000=cCc`000000303RdlP010000000jNG<0>WUc00000080?3U`@040000
003^n;d00000000000<0l?BW00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0>0?ooo`00
7`3oool00`000000oooo0?ooo`1=0?ooo`8000000`006:D00`0000001C^l0000000703eD`@030000
001>Il`0CVO<00@000002@1/L/P01@000000M7o@07Aod01dOm00000000l0QXG;00<0000009B;a`2D
RlL00P2DRlL2000000T0Ui?>00<000000:6Hb`2QV</03@2QV</00`000000Zik:0:^NbP0=0:^NbP03
0000002cY<T0/jC900d0/jC900<000000;^[bP2kZlX03@2kZlX00`000000`[?;0<:cb`0=0<:cb`03
00000039_<h0bKc>00P0bKc>0P0000040<fia`030000003EaL/0eLG;00d0eLG;00D000000=cCc`3L
dll0g=??0000000:0>;Cb0050000003YiL`0jNG<0>WUc0000000203`iL4010000000k_Rm00000000
00030?3dY`030000003oool0oooo03<0oooo00<000000?ooo`3oool03P3oool001l0oooo00<00000
0?ooo`3oool0CP3oool01`00000001RU000HY@006:D0000000Dk_00000001`0mE<430000000304iW
c0000000K7;800X0K7;800D0000007Aod01dOm00M7o@0000000?08J5b`030000002DRlL0U8_70080
0000302GTlh00`000000XIS;0:6Hb`0=0:6Hb`030000002[W/X0Zik:00d0Zik:00<000000;>Tb@2c
Y<T0302cY<T00`000000^j_:0;^[bP0<0;^[bP0300000032/l/0`[?;00d0`[?;00<000000<VlcP39
_<h02`39_<h200000080cKW700<000000=G5b`3EaL/03@3EaL/00`000000g=??0=cCc`020=cCc`03
0000003RdlP0h]?800H0h]?800<000000>WUc03YiL`00`3YiL`00`000000l>G10?3U`@040?3U`@08
0000003^n;d0k_Rm0000003`m:L000000?3dY`00000f0?ooo`030000003oool0oooo00h0oooo000O
0?ooo`030000003oool0oooo04h0oooo0P000003000HY@0300000005>k`0000000<0?EC110000004
04iWc0030000001/L/P0K7;800L0K7;800<0000007Aod01dOm000`1dOm000`000000QXG;08J5b`0=
08J5b`8000003P2GTlh00`000000XIS;0:6Hb`0=0:6Hb`030000002[W/X0Zik:00d0Zik:00<00000
0;>Tb@2cY<T0302cY<T00`000000^j_:0;^[bP0<0;^[bP0300000032/l/0`[?;00d0`[?;00<00000
0<VlcP39_<h03@39_<h2000000l0eLG;00<000000=cCc`3Ldll0103Ldll00`000000h]?80>;Cb005
0>;Cb0030000003YiL`0jNG<00<0jNG<00<000000?3U`@3`iL400`3`iL401@000000k_Rm0>kh_@3^
n;d000000080l?BW0P00000g0?ooo`030000003oool0oooo00d0oooo000O0?ooo`800000D03oool0
1@00000001RU000HY@006:D0000000801C^l0`00000203eD`@030000001>Il`0CVO<00@0CVO<00<0
000006abb01/L/P01@1/L/P00`000000M7o@07Aod00507Aod00300000026QL/0QXG;00X0QXG;0P00
00000`2;Sm80000009NCcP0>09NCcP030000002QV</0XIS;00`0XIS;00<000000:^NbP2[W/X03@2[
W/X00`000000/jC90;>Tb@050;>Tb@/000002`2kZlX00`000000`[?;0<:cb`0<0<:cb`0300000039
_<h0bKc>00h0bKc>00@000000=37d@0000000000303EaL/00`000000g=??0=cCc`050=cCc`030000
003RdlP0h]?800@0h]?800<000000>WUc03YiL`01@3YiL`01@000000l>G10?3U`@3`iL40000000<0
k_Rm00@000000?3dY`3`m:L0l?BW0P00000g0?ooo`030000003oool0oooo00d0oooo000N0?ooo`80
0000D@3oool200000003000HY@00000000000080000000<01C^l0000000mE<400P0mE<400`000000
CVO<04iWc00504iWc0030000001/L/P0K7;800<0K7;800<0000007Aod01dOm001`1dOm000`000000
QXG;08J5b`0808J5b`050000002;Sm80RhoB08^?dP0000003`2GTlh00`000000XIS;0:6Hb`0=0:6H
b`030000002[W/X0Zik:00D0Zik:3`0000070;:Yd0040000002i/=40^K3A0;V`d@L000000`2kZlX0
0`000000`[?;0<:cb`0=0<:cb`0300000039_<h0bKc>00d0bKc>00<000000=37d@3@am400P3@am40
0`000000eLG;0=G5b`080=G5b`030000003Ldll0g=??00L0g=??00<000000>;Cb03RdlP00P3RdlP0
0`000000jNG<0>WUc0060>WUc0040000003`iL40l>G1000000@0k_Rm00<000000?3dY`3`m:L00P00
00000`3oool000000?ooo`0e0?ooo`030000003oool0oooo00d0oooo000N0?ooo`030000003oool0
oooo0500oooo0`0000000`006:D0000000Dk_00300Dk_0040000000mE<40?EC1000000P0CVO<00D0
000006abb01/L/P0K7;80000000;07Aod00300000026QL/0QXG;00H0QXG;00<0000008^?dP2;Sm80
0`2;Sm800`000000Ui?>09NCcP0=09NCcP030000002QV</0XIS;00/0XIS;2@0000070:ZTd@030000
002bZM00/ZW@00`0/ZW@00<000000;V`d@2i/=40202i/=46000000`0`[?;00<000000<VlcP39_<h0
3P39_<h00`000000d<OA0=37d@030=37d@030000003EaL/0eLG;00H0eLG;00<000000=cCc`3Ldll0
2@3Ldll010000000h]?80>;Cb00000090>WUc0040000003`iL40l>G1000000@0k_Rm00@000000?3d
Y`3`m:L000000`3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo00d0oooo000N0?oo
o`030000003oool0oooo04d0oooo0`0000001@3oool00000000000006:D0000000@01C^l00@00000
03eD`@0mE<400000201>Il`01@000000K7;806abb01/L/P0000000`0M7o@00<0000008J5b`26QL/0
0`26QL/2000000L0RhoB00<0000009NCcP2GTlh0302GTlh00`000000XIS;0:6Hb`080:6Hb`<00000
00<0XYoB0000002ZY=403@2ZY=400`000000/ZW@0;:Yd00<0;:Yd0030000002i/=40^K3A00/0^K3A
00<000000;ngdP2o]m80100000080<:cb`0300000039_<h0bKc>00d0bKc>00<000000=37d@3@am40
1@3@am42000000D0eLG;00<000000=cCc`3Ldll02`3Ldll00`000000h]?80000000:0>WUc0800000
1@3^n;d010000000l?BW0000000000030?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3o
ool03@3oool001h0oooo00<000000?ooo`3oool0BP3oool3000000D0oooo0`00000500Dk_0800000
2P1>Il`00`000000K7;80000000=07Aod00300000026QL/0QXG;0080QXG;00<0000008^?dP2;Sm80
1`2;Sm800`000000Ui?>09NCcP0=09NCcP030000002QV</0XIS;00<0XIS;100000050::OdP030000
002ZY=40ZZCA00/0ZZCA00<000000;:Yd02bZM002`2bZM000`000000^K3A0;V`d@0;0;V`d@030000
002o]m80_kOB00D0_kOB1@0000020<:cb`0300000039_<h0bKc>00d0bKc>00<000000=37d@3@am40
203@am400`000000eLG;0=G5b`020=G5b`030000003Ldll0g=??00`0g=??00<000000>WUc03YiL`0
2@3YiL`00`000000k_Rm0>kh_@040>kh_@<000001@3oool00`000000oooo0?ooo`0b0?ooo`030000
003oool0oooo00d0oooo000N0?ooo`030000003oool0oooo04H0oooo100000080?ooo`0400000000
07L00000000000D01C^l00<0000004iWc01>Il`02@1>Il`00`000000M7o@07Aod00=07Aod0040000
0026QL/00000000000/0RhoB00<0000009NCcP2GTlh0302GTlh00`000000XIS;0:6Hb`03000000T0
XYoB00<000000:ZTd@2ZY=402`2ZY=400`000000/ZW@0;:Yd00;0;:Yd0030000002i/=40^K3A00/0
^K3A00<000000;ngdP2o]m802P2o]m84000000d0bKc>00<000000=37d@3@am402P3@am4200000003
0=G5b`000000g=??00d0g=??0P00000:0>WUc08000001P3^n;d3000000H0oooo00<000000?ooo`3o
ool0<@3oool00`000000oooo0?ooo`0=0?ooo`007P3oool00`000000oooo0?ooo`130?ooo`<00000
3@3oool3000000D01C^l0P00000:04iWc08000003`1dOm000`000000RhoB08^?dP0<08^?dP030000
002GTlh0Ui?>00/0Ui?>0`00000<0::OdP030000002ZY=40ZZCA00/0ZZCA00<000000;:Yd02bZM00
2`2bZM000`000000^K3A0;V`d@0;0;V`d@030000002o]m80_kOB00/0_kOB00<000000<Foe035_m@0
0P00000:0<VlcP030000003@am40d<OA00d0d<OA00<000000=cCc`3Ldll0303Ldll010000000hN?E
0>7Se@0000080>WUc0030000003Xmlh0000000H0k_Rm0P0000080?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool0303oool001d0oooo00<000000?ooo`3oool0@@3oool300000100oooo
00<000000000M`0000001@05>k`00`0000008eO=0000000804iWc0040000001LN=D0G7SE000000d0
M7o@00<0000007b;e`0000003@2;Sm800`000000Ui?>09NCcP0909NCcP8000000P2IW=D00`000000
XYoB0::OdP0;0::OdP030000002ZY=40ZZCA00X0ZZCA00<000000;:Yd02bZM002`2bZM000`000000
^K3A0;V`d@0:0;V`d@030000002o]m80_kOB00`0_kOB00<000000<Foe035_m@00P35_m@2000000L0
bKc>00<000000=37d@3@am403@3@am400`000000eM?F0000000<0=cCc`050000003QhmD0hN?E0>7S
e@000000203YiL`00`000000j?O>000000050>kh_@<000002@3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo00`0oooo000M0?ooo`030000003oool0oooo03d0oooo1000000D0?ooo`<0
00001005>k`0100000008eO=02=Gc@00000704iWc0050000001LN=D0G7SE05ahe@0000002`1dOm00
1@000000O8_G07b;e`1lRmL0000000d0RhoB00<0000009NCcP2GTlh01P2GTlh2000000@0VIcE00<0
00000::OdP2RWm802`2RWm800`000000ZZCA0:ZTd@0;0:ZTd@030000002bZM00/ZW@00X0/ZW@00<0
00000;V`d@2i/=402P2i/=400`000000_kOB0;ngdP0;0;ngdP0300000035_m@0aKoD00D0aKoD0P00
00050<VlcP030000003@am40d<OA00`0d<OA00D000000=GCeP3EdmH0eM?F0000000:0=cCc`030000
003QhmD0hN?E00<0hN?E00<000000>WUc03YiL`0103YiL`010000000j?O>0>SgcP0000040>kh_@<0
00002P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00`0oooo000M0?ooo`030000
003oool0oooo03X0oooo0`00000H0?ooo`040000000007L00000000000<01C^l00D0000002=Gc@0S
Eld08eO=0000000604iWc0030000001LN=D0G7SE0080G7SE00<0000007Aod01dOm001`1dOm000`00
0000O8_G07b;e`0207b;e`030000002;Sm80RhoB00`0RhoB00<0000009NCcP2GTlh00P2GTlh30000
00L0VIcE00<000000::OdP2RWm802P2RWm800`000000ZZCA0:ZTd@0;0:ZTd@030000002bZM00/ZW@
00X0/ZW@00<000000;V`d@2i/=402P2i/=400`000000_kOB0;ngdP0;0;ngdP0300000035_m@0aKoD
00L0aKoD0P0000020<VlcP030000003@am40d<OA00`0d<OA00<000000=GCeP3EdmH00`3EdmH00`00
0000g=??0=cCc`060=cCc`030000003QhmD0hN?E00@0hN?E00<000000>WUc03YiL`00`3YiL`01@00
0000j?O>0>SgcP3Xmlh0000000@0k_Rm0`00000;0?ooo`030000003oool0oooo02l0oooo00<00000
0?ooo`3oool0303oool001d0oooo00<000000?ooo`3oool0=`3oool3000001`0oooo0`00000300Dk
_0030000000SEld08eO=00808eO=00<0000004iWc01>Il`00P1>Il`00`000000G7SE05ahe@0405ah
e@8000001P1dOm000`000000O8_G07b;e`0407b;e`030000002;Sm80RhoB00/0RhoB00<0000009NC
cP2GTlh00P00000;09VLe@030000002RWm80XYoB00T0XYoB00<000000:ZTd@2ZY=402`2ZY=400`00
0000/ZW@0;:Yd0090;:Yd0030000002i/=40^K3A00X0^K3A00<000000;ngdP2o]m802`2o]m800`00
0000aKoD0<Foe00:0<Foe08000003P3@am400`000000eM?F0=GCeP040=GCeP030000003Ldll0g=??
00D0g=??00<000000>7Se@3QhmD01@3QhmD00`000000jNG<0>WUc0020>WUc0030000003Xmlh0j?O>
0080j?O>00@000000>kh_@3^n;d0k_Rm0`00000=0?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool0303oool001d0oooo0P00000e0?ooo`<00000803oool00`0007L000000000000300Dk
_0030000000SEld08eO=00808eO=00D0000004iWc01>Il`0CVO<0000000805ahe@030000001dOm00
M7o@00<0M7o@00<0000007b;e`1lRmL01@1lRmL00`000000RhoB08^?dP0;08^?dP8000003@2IW=D0
0`000000XYoB0::OdP0:0::OdP030000002ZY=40ZZCA00X0ZZCA00<000000;:Yd02bZM002@2bZM00
0`000000^K3A0;V`d@0:0;V`d@030000002o]m80_kOB00X0_kOB00<000000<Foe035_m@02`35_m@0
10000000b/SH00000000000;0=37d@030000003EdmH0eM?F00H0eM?F00<000000=cCc`3Ldll00`3L
dll00`000000hN?E0>7Se@070>7Se@040000003YiL`0jNG<000000D0j?O>00D000000>kh_@3^n;d0
00000<gfY@02000000h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0<0?ooo`00
7@3oool00`000000oooo0?ooo`0`0?ooo`@000008`3oool200000005000DXP0000001C^l00Dk_000
00001@0SEld010000000CVO<04iWc000000905ahe@050000001dOm00M7o@07Aod00000002@1lRmL0
0`000000RhoB08^?dP0808^?dP80000000<0SiSH0000002IW=D03@2IW=D00`000000XYoB0::OdP09
0::OdP030000002ZY=40ZZCA00X0ZZCA00<000000;:Yd02bZM002@2bZM000`000000^K3A0;V`d@0:
0;V`d@030000002o]m80_kOB00X0_kOB00<000000<Foe035_m@02P35_m@00`000000b/SH0<[8f002
0<[8f0030000003@am40d<OA00L0d<OA00<000000=GCeP3EdmH0203EdmH01@000000g=??0=cCc`3L
dll0000000X0hN?E00@000000>WUc03YiL`000001@3Xmlh010000000k_Rm0000003=mZD200000100
oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0<0?ooo`00703oool00`000000oooo
0?ooo`0^0?ooo`<00000:03oool01P00000001BR000DXP0000001C^l000000H08eO=0P00000;05ah
e@030000001dOm00000000/0O8_G00<0000008^?dP2;Sm801P2;Sm800`000000SiSH08nHf00208nH
f0030000002IW=D0VIcE00/0VIcE00<000000::OdP2RWm802@2RWm800`000000ZZCA0:ZTd@080:ZT
dA@000001P2i/=400`000000_kOB0;ngdP0:0;ngdP0300000035_m@0aKoD00/0aKoD00<000000<[8
f03:b=P00`3:b=P2000000H0d<OA00<000000=GCeP3EdmH02P3EdmH00`000000g=??0000000<0>7S
e@8000001P3Xmlh010000000k_Rm0000003=mZD200000140oooo00<000000?ooo`3oool0:`3oool0
0`000000oooo0?ooo`0<0?ooo`00703oool00`000000oooo0?ooo`0[0?ooo`<00000:`3oool20000
0004000DXP0000001C^l000000L08eO=00<0000005ahe@1LN=D02P1LN=D00`000000O8_G07b;e`0;
07b;e`030000002;Sm80RhoB00<0RhoB0P00000608nHf0030000002IW=D0VIcE00/0VIcE00<00000
0::OdP2RWm802@2RWm8010000000ZZCA0:ZTd@2ZY=4600000080ZZ_H00<000000;2_e`2`[mL02@2`
[mL00`000000][GH0;Jef0030;Jef0P000002`2o]m800`000000aKoD0<Foe00:0<Foe0030000003:
b=P0b/SH00H0b/SH00<000000=37d@3@am400P3@am400`000000eM?F0=GCeP0<0=GCeP030000003Q
hmD0hN?E00/0hN?E00<000000>SgcP3Xmlh01@3Xmlh200000080cOJU00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00/0oooo000L0?ooo`030000003oool0
oooo02P0oooo0`00000_0?ooo`03000000005:8001BR008000001`0SEld2000000/0G7SE0P00000<
07b;e`030000002;Sm80RhoB0080RhoB00<0000008nHf02?V=P01`2?V=P00`000000VIcE09VLe@0;
09VLe@030000002RWm80XYoB00H0XYoB1P0000080:Z[f0030000002`[mL0/:oG00T0/:oG00<00000
0;Jef02f]MP02@2f]MP00`000000^k_I00000003000000H0_kOB00<000000<Foe035_m@02P35_m@0
0`000000b/SH0<[8f0080<[8f080000000<0d<OA0000003EdmH03@3EdmH2000000`0hN?E0P000007
0>SgcP030000003=mZD0cOJU008000004`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo00/0oooo000L0?ooo`030000003oool0oooo02@0oooo1000000b0?ooo`8000000P005:800`00
00008eO=02=Gc@0502=Gc@030000000lK]X0000000T0G7SE00<0000006V6g@1YQ]d00P00000;07b;
e`040000002;Sm800000000000X0SiSH00<0000009VLe@2IW=D02`2IW=D010000000XYoB0::OdP2R
Wm8500000080XjOI00<000000:Z[f02ZZmP02@2ZZmP00`000000/:oG0;2_e`090;2_e`030000002f
]MP0][GH00P0][GH00<000000;^kf@2k^mT0102k^mT400000080_kOB00<000000<Foe035_m@02@35
_m@00`000000b/SH0<[8f00;0<[8f0030000003EdmH0eM?F00`0eM?F00@000000=WQg03IhM`00000
2@3QhmD2000000030>7cf@000000j?O>00D0j?O>0P0000020<gfY@030000003oool0oooo01<0oooo
00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0;0?ooo`00703oool00`000000oooo0?oo
o`0Q0?ooo`<00000=`3oool00`00000001BR000DXP02000000H08eO=00@0000003a^fP0lK]X00000
201LN=D00`000000JHKM06V6g@0206V6g@030000001lRmL0O8_G00T0O8_G00<0000008nHf02?V=P0
2`2?V=P00`000000VIcE09VLe@0:09VLe@@00000202SYmT00`000000ZZ_H0:Z[f0090:Z[f0030000
002`[mL0/:oG00P0/:oG00<000000;Jef02f]MP0202f]MP00`000000^k_I0;^kf@080;^kf@<00000
2P35_m@00`000000b/SH0<[8f00;0<[8f0030000003>d]d0000000`0eM?F00D000000=WQg03IhM`0
fN7L000000080>7Se@050000003QlmT0hO?I0>7cf@0000001@3Xmlh200000080cOJU0P00000F0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool02`3oool001`0oooo00<000000?ooo`3o
ool07P3oool3000003X0oooo0P000002000DXP8000001@0SEld01@000000?6kJ03a^fP0lK]X00000
00L0G7SE00<0000006V6g@1YQ]d00`1YQ]d00`000000O8_G07b;e`0707b;e`0300000023U]d00000
00d0SiSH00<0000009VLe@2IW=D01`2IW=D200000080VjCK00<000000:>Wf@2SYmT01`2SYmT00`00
0000ZZ_H0:Z[f0090:Z[f0030000002`[mL0/:oG00P0/:oG00<000000;Jef02f]MP0202f]MP00`00
0000^k_I0;^kf@080;^kf@030000002o`M/0_l7K008000001`35_m@00`000000b/SH0<[8f00;0<[8
f0050000003>d]d0c];M0<kBg@0000002P3EdmH00`000000fN7L0=WQg0030=WQg0030000003QhmD0
hN?E00@0hN?E00<000000>7cf@3QlmT00P3QlmT00`000000j?O>0>SgcP020>SgcP030000003Do/@0
00000080cOJU00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo00/0oooo000L0?ooo`030000003oool0oooo01/0oooo0`00000n0?ooo`06000000005:8001BR
00000000?/800000100SEld00`000000?6kJ03a^fP0203a^fP800000101LN=D00`000000JHKM06V6
g@0506V6g@030000001lRmL0O8_G00D0O8_G00@0000008>Fg@23U]d0PiKM0P00000<08nHf0030000
002IW=D0VIcE00<0VIcE0`00000409^Tf`030000002SYmT0XjOI00P0XjOI00<000000:Z[f02ZZmP0
202ZZmP00`000000/:oG0;2_e`070;2_e`030000002f]MP0][GH00P0][GH00<000000;^kf@2k^mT0
2@2k^mT00`000000_l7K0;o1f`020;o1f`8000001@35_m@00`000000b/SH0<[8f00:0<[8f0030000
003>d]d0c];M00<0c];M00<000000=GCeP3EdmH01@3EdmH2000000H0fN7L00<000000>7Se@3QhmD0
0`3QhmD00`000000hO?I0>7cf@020>7cf@040000003Xmlh0j?O>0>SgcP80000000D0e?k40000003=
mZD0cOJU0000000I0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool02`3oool001/0
oooo00<000000?ooo`3oool0603oool400000480oooo00H00000000DXP005:800000000n`P000003
02=Gc@030000000lK]X0?6kJ00@0?6kJ00D0000005ahe@1LN=D0G7SE0000000806V6g@030000001l
RmL0O8_G00<0O8_G00<0000008>Fg@23U]d01023U]d00`000000SiSH08nHf00:08nHf0030000002I
W=D0VIcE00800000202KY=/00`000000XjOI0:>Wf@070:>Wf@030000002ZZmP0ZZ_H00P0ZZ_H00<0
00000;2_e`2`[mL01`2`[mL00`000000][GH0;Jef0080;Jef0030000002k^mT0^k_I00P0^k_I00<0
00000;o1f`2o`M/01@2o`M/200000080aKoD00<000000<[8f03:b=P02P3:b=P00`000000c];M0<kB
g@050<kBg@030000003EdmH0eM?F00<0eM?F00<000000=WQg03IhM`01`3IhM`00`000000hN?E0>7S
e@02000000D0hO?I00@000000>SgcP3Xmlh000000`3Do/@00`000000cOJU0000000K0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool02`3oool001/0oooo00<000000?ooo`3oool05@3o
ool3000004L0oooo00<00000000DXP0000000P00?/80100000008eO=02=Gc@00000703a^fP040000
001LN=D0G7SE000000T0JHKM0P00000307b;e`0300000023U]d0PiKM00D0PiKM00<0000008nHf02?
V=P02P2?V=P2000000/0VjCK00<000000:>Wf@2SYmT01`2SYmT00`000000ZZ_H0:Z[f0070:Z[f003
0000002`[mL0/:oG00L0/:oG00<000000;Jef02f]MP0202f]MP00`000000^k_I0;^kf@070;^kf@03
0000002o`M/0_l7K00P0_l7K0P00000;0<[8f08000002@3>d]d01@000000eM?F0=GCeP3EdmH00000
00X0fN7L00<000000>7Se@0000001`3QlmT00`000000j?O>000000030=Cna0030000003=mZD00000
01d0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0:0?ooo`006`3oool00`000000
oooo0?ooo`0B0?ooo`<00000B`3oool00`00000001BR00000002000n`P030000000SEld0000000P0
?6kJ0P00000<06V6g@030000001lRmL0000000T0PiKM00<0000008nHf02?V=P01`2?V=P200000003
09>Rg`000000VjCK00X0VjCK00<000000:>Wf@2SYmT01`2SYmT00`000000ZZ_H0:Z[f0070:Z[f003
0000002`[mL0/:oG00L0/:oG00<000000;Jef02f]MP01`2f]MP00`000000^k_I0;^kf@080;^kf@03
0000002o`M/0_l7K00P0_l7K00@000000<?9gP0000000000203:b=P00`000000c];M0<kBg@0:0<kB
g@030000003EdmH0000000`0fN7L00<000000>7cf@3QlmT01P3QlmT2000000@0e?k40P00000O0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool02P3oool001/0oooo0`00000>0?ooo`@0
0000C`3oool2000000<003k20P00000903a^fP030000001YQ]d0JHKM00/0JHKM00<0000008>Fg@23
U]d02@23U]d00`000000SiSH08nHf00508nHf0030000002CX]l0Tj;O0080Tj;O00<0000009^Tf`2K
Y=/02@2KY=/00`000000XjOI0:>Wf@070:>Wf@030000002ZZmP0ZZ_H00L0ZZ_H00<000000;2_e`2`
[mL01P2`[mL00`000000][GH0;Jef0070;Jef0030000002k^mT0^k_I00L0^k_I00<000000;o1f`2o
`M/0202o`M/00`000000`lWN0<?9gP020<?9gP8000001@3:b=P00`000000c];M0<kBg@0<0<kBg@03
0000003IhM`0fN7L00T0fN7L0`0000080>7cf@030000003Do/@0e?k40080e?k400<000000<gfY@00
0000803oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00X0oooo000>0?ooo`030?oD
V`000000000000<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`0;0?ooo`<00000
E03oool2000000<003k200<0000003a^fP0lK]X01`0lK]X3000000/0JHKM0`00000:08>Fg@800000
102?V=P00`000000Tj;O09>Rg`0409>Rg`030000002KY=/0VjCK00P0VjCK00<000000:>Wf@2SYmT0
1`2SYmT00`000000ZZ_H0:Z[f0070:Z[f0030000002`[mL0/:oG00H0/:oG00<000000;Jef02f]MP0
1`2f]MP00`000000^k_I0;^kf@070;^kf@030000002o`M/0_l7K00L0_l7K00<000000<?9gP33bMh0
1@33bMh200000080b/SH00<000000<kBg@3>d]d02`3>d]d3000000X0fN7L00@000000=S_hP3Hkn80
00001`3QlmT2000000@0e?k40P00000R0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool02P3oool00140oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`080?ooo`<00000
F03oool00`00000003k2000n`P02000n`P8000001`0lK]X010000000DH;R0562hP00000906V6g@05
0000001eU><0MICS07FDh`0000002`23U]d010000000SiSH00000000000809>Rg`030000002KY=/0
VjCK00P0VjCK00<000000:>Wf@2SYmT01`2SYmT00`000000ZZ_H0:Z[f0020:Z[f1800000102f]MP0
0`000000^k_I0;^kf@070;^kf@030000002o`M/0_l7K00L0_l7K00<000000<?9gP33bMh02033bMh2
000000d0c];M00D000000=3MhP3@gN80d=gR000000080=WQg0050000003Hkn80f>oR0=S_hP000000
1@3QlmT3000000@0e?k40P00000S0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0
2P3oool00140oooo00<0^W9b0;[Zo`3oool01P3oool00`000000oooo0?ooo`060?ooo`<00000G03o
ool01`00000003k2000n`P00?/80000000mQe`0000001P0lK]X010000000DH;R0562hP1AP^820000
00L0JHKM00<0000007FDh`1eU><00P1eU><00`000000PiKM08>Fg@0908>Fg@030000002CX]l0Tj;O
00T0Tj;O00<0000009^Tf`2KY=/0202KY=/00`000000XjOI0:>Wf@050:>Wf@H00000102Y/]l00`00
0000[[KO0:jfg`060:jfg`030000002b^]l0/[[O0080/[[O1P0000070;^kf@030000002o`M/0_l7K
00L0_l7K00<000000<?9gP33bMh02@33bMh00`000000a]7S0000000:0<kBg@800000103@gN800`00
0000fN7L0=WQg0040=WQg0800000103Hkn800`000000hO?I0>7cf@020>7cf@040000003ComP0dooH
000000@0e?k400<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo00X0oooo000A0?ooo`030;YbLP2jj_l0oooo00H0oooo00<000000?ooo`3oool00P3oool40000
0600oooo00L00000000n`P00?/8003k20000000?HML0000000D0?6kJ00<000000562hP1AP^800`1A
P^82000000@0JHKM00<0000007FDh`1eU><0101eU><2000000P0PiKM00@0000008ZQh`0000000000
2P2CX]l00`000000VjCK09^Tf`0709^Tf`040000002SYmT0XjOI0:>Wf@@0000000<0Xk3Q0000002Y
/]l01`2Y/]l00`000000[[KO0:jfg`060:jfg`030000002b^]l0/[[O00D0/[[O00<000000;Jnh@2f
_^40100000030;^kf@030000002o`M/0_l7K00H0_l7K00<000000<?9gP33bMh02033bMh2000000<0
a]7S00<000000<kBg@3>d]d01P3>d]d00`000000d=gR0=3MhP050=3MhP030000003IhM`0fN7L0080
fN7L00<000000=S_hP3Hkn800`3Hkn800`000000hO?I0>7cf@020>7cf@040000003ComP0dooH0000
00@0e?k400<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo
00X0oooo000A0?ooo`030;YbLP2jj_l0oooo00H0oooo00<000000?ooo`0000000P00001U0?ooo`04
00000000?/8003k2000000803f7G0P00000303a^fP030000001AP^80DH;R00D0DH;R00D0000006V6
g@1YQ]d0JHKM0000000807FDh`0300000023U]d0PiKM00@0PiKM00<0000008ZQh`2:XN<00P2:XN<0
0`000000Tj;O09>Rg`0809>Rg`030000002KY=/0VjCK00H0VjCK100000060:>`h@030000002Y/]l0
ZK;O00D0ZK;O00<000000:jfg`2^]]l01P2^]]l00`000000/[[O0;:jg`050;:jg`030000002f_^40
][kQ00@0][kQ100000070;o1f`0300000033bMh0`lWN00P0`lWN00<000000<KAh`36dN<00`36dN<0
0`000000c];M0<kBg@040<kBg@800000203@gN801@000000fN7L0=WQg03IhM`0000000H0f>oR00D0
00000>7cf@3QlmT0hO?I000000030=?of0050000003Do/@0e?k40=Cna0000000:@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo00T0oooo000A0?ooo`030;YbLP2jj_l0oooo00H0oooo
0P00001Y0?ooo`0400000000?/8003k2000000<03f7G00@0000003a^fP0lK]X00000201AP^830000
00X0MICS00<0000008>Fg@23U]d00P23U]d00`000000RZ7S08ZQh`0408ZQh`030000002CX]l0Tj;O
00P0Tj;O00<0000009^Tf`2KY=/00`2KY=/200000080WJgS00<000000:>`h@2S/>401@2S/>400`00
0000ZK;O0:Vbg`050:Vbg`030000002^]]l0[[KO00H0[[KO00<000000;:jg`2b^]l0102b^]l00`00
0000][kQ0;Jnh@060;Jnh@030000002ia>80^LCR00@000000P2o`M/00`000000`lWN0<?9gP080<?9
gP0300000036dN<0a]7S00D0a]7S00<000000<kBg@3>d]d00P3>d]d00`000000d=gR0=3MhP090=3M
hP<000001`3Hkn8010000000hO?I0000000000040=?of0040000003Do/@0e?k4000002/0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`090?ooo`004@3oool00`2jLW80^^[o0?ooo`07
0?ooo`80000000<0oooo0000003oool0IP3oool3000000@03f7G0`00000:0562hP030000001eU><0
MICS00T0MICS0P0000000`23U]d0000008ZQh`0708ZQh`8000002@2CX]l00`000000VjCK09^Tf`02
000000D0WJgS00<000000:>`h@2S/>401@2S/>400`000000ZK;O0:Vbg`040:Vbg`030000002^]]l0
[[KO00D0[[KO00<000000;:jg`2b^]l01@2b^]l00`000000][kQ0;Jnh@050;Jnh@030000002ia>80
^LCR00D0^LCR0P00000:0<?9gP0300000036dN<0a]7S00L0a]7S00@000000<kBg@0000000000303@
gN800`000000f>oR0=S_hP070=S_hP8000001@3ComP010000000e?k400000000000/0?ooo`030000
003oool0oooo0240oooo00<000000?ooo`3oool02@3oool000h0oooo00D0j[Yb00000000L[X0^W9b
0;[Zo`0:0?ooo`800000I`3oool01000000001^L00000000000500mQe`030000001AP^80DH;R00P0
DH;R0`00000;07FDh`030000002:XN<0RZ7S00T0RZ7S00<0000009>Rg`2CX]l01`2CX]l2000000L0
WJgS00<000000:>`h@2S/>401@2S/>400`000000ZK;O0:Vbg`050:Vbg`030000002^]]l0[[KO00@0
[[KO00<000000;:jg`2b^]l0102b^]l00`000000][kQ0;Jnh@060;Jnh@030000002ia>80^LCR00D0
^LCR00@000000;_9i@00000000001`33bMh00`000000a]7S0<KAh`090<KAh`030000003@gN80d=gR
00X0d=gR0`0000090=S_hP030000003ComP0dooH00@0dooH0`00000^0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool02@3oool00100oooo00<0j[Yb0000LP2jj_l02`3oool00`000000
oooo0?ooo`1V0?ooo`03000000006i`0000000D03f7G0`0000080562hP030000001TT^T0I9;Y0080
00002@1eU><3000000X0RZ7S00<0000009>Rg`2CX]l0102CX]l20000000309N/i@000000WJgS00L0
WJgS00<000000:>`h@2S/>40102S/>400`000000ZK;O0:Vbg`050:Vbg`030000002^]]l0[[KO00@0
[[KO00<000000;:jg`2b^]l0102b^]l00`000000][kQ0;Jnh@050;Jnh@030000002ia>80^LCR00D0
^LCR00<000000;_9i@2kbND00P2kbND00`000000`lWN0<?9gP020<?9gP8000002P36dN<3000000X0
d=gR0P0000020<oYj0030000003Hkn80f>oR00D0f>oR0`0000050=?of0<00000<03oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo00T0oooo000O0?ooo`800000I`3oool00`00000001^L
0000000500mQe`030000000bNnD0000000L0DH;R00<0000006BBj@1TT^T00P1TT^T00`000000MICS
07FDh`0507FDh`040000001oX>P0Oj3X07nPj08000002@2:XN<200000080Tj;O0P00000409N/i@03
0000002M[N<0WJgS00H0WJgS00<000000:>`h@2S/>40102S/>400`000000ZK;O0:Vbg`040:Vbg`03
0000002^]]l0[[KO00@0[[KO00<000000;:jg`2b^]l00`2b^]l00`000000][kQ0;Jnh@050;Jnh@03
0000002ia>80^LCR00D0^LCR00<000000;_9i@2kbND0102kbND2000000030<?9gP000000a]7S00T0
a]7S0P0000030<OJi`030000003@gN80d=gR00H0d=gR00<000000<oYj03?jNP00P3?jNP00`000000
f>oR0=S_hP030=S_hP80000000<0co[U0000003ComP01@3ComP200000380oooo00<000000?ooo`3o
ool07P3oool00`000000oooo0?ooo`090?ooo`008@3oool00`000000oooo0?ooo`1U0?ooo`040000
00006i`00000000000<03f7G00<00000039ki@0bNnD00P0000050562hP030000001TT^T0I9;Y00<0
I9;Y0P00000507FDh`030000001oX>P0Oj3X00<0Oj3X00<0000008ZQh`2:XN<0202:XN<2000000L0
UjcU00<0000009f]h`2M[N<01P2M[N<00`000000Xk3Q0:>`h@030:>`h@030000002Y/]l0ZK;O00@0
ZK;O00<000000:jfg`2^]]l0102^]]l00`000000/[[O0;:jg`030;:jg`030000002f_^40][kQ00@0
][kQ00<000000;W4hP2ia>801@2ia>800`000000^lWU0;_9i@070;_9i@0300000036dN<0a]7S00P0
a]7S00<000000<OJi`37f^L00`37f^L00`000000d=gR0=3MhP040=3MhP8000001@3?jNP00`000000
f>oR0=S_hP020=S_hP050000003?n^D0co[U0<oji@000000103ComP3000003@0oooo00<000000?oo
o`3oool07@3oool00`000000oooo0?ooo`090?ooo`008P3oool2000006H0oooo00@00000000KW000
000000000`0?HML010000000<W_U039ki@0bNnD2000000<0DH;R00<0000006BBj@1TT^T01@1TT^T2
000000<0MICS00<0000007nPj01oX>P0101oX>P2000000L0RZ7S00@00000092/j000000000001`2G
[>D2000000H0WJgS00<000000:>`h@2S/>40102S/>4010000000ZK;O0:Vbg`2Y/]l<00000080/[[O
00<000000;Jnh@2f_^401@2f_^400`000000^LCR0;W4hP040;W4hP030000002kbND0^lWU00H0^lWU
0P0000000`2mcnP000000<KAh`060<KAh`8000001`37f^L010000000d=gR0=3MhP3@gN82000000L0
cnWX00<000000=S_hP3Hkn800P0000030<oji@030000003ComP0dooH0080dooH0`00000f0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0203oool002@0oooo00<000000?ooo`3oool0
I03oool00`00000001^L000000020000000300mQe`000000<W_U00@0<W_U00@000000562hP1AP^80
00002@1TT^T3000000T0Oj3X0P00000408ZQh`030000002@[>P0T:cX0080T:cX00<0000009N/i@2G
[>D01P2G[>D00`000000WJgS09f]h`0409f]h`040000002S/>40Xk3Q0:>`h@H000000P2V^^L00`00
0000Z[cW0:Zli`040:Zli`030000002]_nL0[KoW00D00000102f_^400`000000^LCR0;W4hP040;W4
hP030000002kbND0^lWU00H0^lWU00<000000;g?j02mcnP00P2mcnP00`000000a]7S0<KAh`020<KA
h`8000002@37f^L010000000d=gR0000000000090<oYj0<000001@3?n^D00`000000dooH0=?of004
000003L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`080?ooo`009@3oool00`00
0000oooo0000001T0?ooo`07000000006i`00000001<a@0000003f7G00000005039ki@<000002`1T
T^T2000000X0Oj3X0P0000000`2:XN<00000092/j005092/j08000001`2G[>D00`000000WJgS09f]
h`0309f]h`@000000`2S^NP00`000000Y[[W0:Jji`020:Jji`030000002Z_>L0Z[cW00@0Z[cW00<0
00000:foi`2]_nL00P2]_nL30:o2j0D000001@2ia>800`000000^lWU0;_9i@050;_9i@8000001P2m
cnP010000000a]7S00000000000;0<OJi`8000002P3?jNP2000000L0co[U00@000000=?of0000000
[_S70P00000i0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0203oool002H0oooo
0P00001U0?ooo`8000000P00C<D2000000L0<W_U0P00000:06BBj@040000001cX>d00000000000X0
Oj3X0P000008092/j08000001P2G[>D00`000000WJgS09f]h`0200000080WkOY00<000000:>ij02S
^NP00P2S^NP00`000000Y[[W0:Jji`030:Jji`030000002Z_>L0Z[cW0080Z[cW00<000000:foi`2]
_nL00P2]_nL00`000000[l;X0:o2j0030:o2j0030000002aa^T0/LKY008000000P2ia>800`000000
^lWU0;_9i@040;_9i@8000002@2mcnP00`000000am[W0<OJi`090<OJi`80000000<0aN;]0000003?
jNP01`3?jNP2000000030<Sbk@000000co[U00D0co[U0`0000000`2^n<L000000000000k0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool0203oool002P0oooo00<000000?ooo`3oool0
H`3oool2000000<004c500<00000039ki@0bNnD0100bNnD010000000Ci7^00000000000806BBj@04
0000001cX>d0Lj3]07>Pk@8000001`1oX>P00`000000RJc/08V/k002000000P0T:cX00<0000009N/
i@2G[>D0102G[>D2000000D0WkOY00<000000:>ij02S^NP00P2S^NP00`000000Y[[W0:Jji`020:Jj
i`030000002Z_>L0Z[cW0080Z[cW00D000000:foi`2]_nL0[KoW000000050:o2j0030000002aa^T0
/LKY00<0/LKY0P0000060;_9i@030000002mcnP0_LoX00H0_LoX0P0000000`2me^`000000<OJi`07
0<OJi`<000000`35h^d00`000000cnWX0<oYj0040<oYj08000000P38l^d00`000000co[U0<oji@05
0<oji@040000002^n<L0[_S7000003h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`080?ooo`00:@3oool2000006D0oooo00@00000001<a@00C<D004c50P000005039ki@030000001?
TNh0Ci7^008000001P1TT^T00`000000Lj3]07>Pk@0307>Pk@<00000101oX>P00`000000RJc/08V/
k00208V/k08000001`2@[>P200000080UjcU0P0000000`2K]n/000000000000509ngj@050000002S
^NP0XkWX0:>ij0000000102V^^L00`000000Z[cW0:Zli`020:Zli`050000002]_nL0[KoW0:foi`00
0000102_`^P00`000000/LKY0;76j@030;76j@80000000<0//W[0000000000000P2kbND2000000L0
_LoX0P0000040;gFk00300000037f^L0am[W0080am[W0`0000060<GRk@040000003?jNP0cnWX0<oY
j0<000001038l^d00`000000co[U0<oji@030<oji@8000000P2^n<L00`000000oooo0?ooo`0n0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool0203oool002/0oooo00<000000?ooo`3o
ool0H`3oool01000000004c5001<a@00C<D3000000<0<W_U00<0000004nAkP1?TNh00P1?TNh30000
00<0I9;Y00<0000007>Pk@1cX>d01P1cX>d20000000307nPj0000000RJc/00H0RJc/0P000007092/
j08000001@2K]n/00`000000WkOY09ngj@0209ngj@030000002S^NP0XkWX0080XkWX00D000000:Jj
i`2V^^L0Y[[W000000040:Zli`040000002]_nL0[KoW000000@0[l;X00<000000;76j@2aa^T00`2a
a^T00`000000//W[0;;9j`030;;9j`8000001`2mcnP2000000H0_MK/00<000000<OJi`37f^L00P00
00090<GRk@040000003?jNP00000000000H0b?;]00<000000<oji@3?n^D00P3?n^D300000080[_S7
00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00P0oooo
000M0?ooo`030?n`G@000000000000<0000000<005f`0?ooo`3oool01P3oool010000000oooo0?oo
o`00001R0?ooo`0600000000C<D004c5001<a@00000037;P0P000002039ki@030000001?TNh0Ci7^
00@0Ci7^0P0000000`1TT^T0000007>Pk@0907>Pk@<000002029[>`2000000@0T:cX00@0000009Nf
kP00000000001@2K]n/00`000000WkOY09ngj@0209ngj@030000002S^NP0XkWX0080XkWX00D00000
0:Jji`2V^^L0Y[[W000000020:Zli`050000002]_nL0[KoW0:foi`000000102_`^P00`000000/LKY
0;76j@020;76j@030000002bbN/0//W[00<0//W[0P0000000`2ccNd000000;g?j0030;g?j0800000
202me^`3000000X0aN;]0`0000080<Sbk@030000003?n^D0co[U0080000000<0]ocQ0000002^n<L0
0P0000130?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0203oool00200oooo00<0
R38b08SGo`3oool02P3oool3000006<0oooo0P0000000`00C<D0000000abh00200abh0<00000201?
TNh3000000X0Lj3]00@0000008:]l000000000002029[>`200000080T:cX00@0000009NfkP2G]^h0
UkK^0P00000409^gj`8000000`2O]nT01@000000XkWX0:>ij02S^NP0000000<0Y[[W00@000000:Zl
i`2Z_>L000000P2]_nL00`000000[l;X0:o2j0020:o2j0040000002aa^T0/LKY0;76j@800000102b
bN/2000000<0/lg]00<000000;g?j02mcnP00P0000070;gFk0<0000000<0^m_`00000035h^d01`35
h^d3000000030<3ZlP000000b?;]00L0b?;]00@000000<oji@00000000000P2go>400`000000[_S7
000000160?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool01`3oool00200oooo00<0
R38b08SGo`3oool0303oool00`000000oooo0?ooo`1S0?ooo`0300000000C<D0000000@037;P0`00
000704nAkP030000001VXO800000008000001`1cX>d010000000PZg`08:]l022[O03000000L0RJc/
0`00000509NfkP800000102K]n/01@000000WkOY09ngj@2O]nT000000080XkWX300000020:o2j005
0000002aa^T0/LKY0;76j@000000102bbN/2000000H0/lg]0P0000050;gFk0@00000102kfo000`00
0000aN;]0<GRk@020<GRk@@000000`30j_800`000000b?;]0<Sbk@060<Sbk@<000000`2go>430000
04P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`070?ooo`00803oool00`28<S80
R=Oo0?ooo`0=0?ooo`800000I03oool3000000D037;P1000000504nAkP040000001VXO80IZ7b06JQ
lP<00000101cX>d00`000000PZg`08:]l00408:]l0<000001029[>`00`000000T[O`09:gl0030000
00@0UkK^0P00000309^gj`8000000P2O]nT200000080XL;`00<000000:?3l00000000P2Ta?000`00
0000YLG`000000020:K6l08000000P2aa^T2000000<0//W[0P0000040;?=k@<000000P2bd?000`00
0000_MK/0;gFk003000000P0^m_`00<000000<GRk@0000000P0000070<3ZlP0300000038l^d0b?;]
00<0b?;]100000040;Olh@<00000BP3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
00L0oooo000D0?ooo`030;Yb00000000000000<0000000<003:80?ooo`3oool00`3oool00`28<S80
R=Oo0?ooo`0?0?ooo`030000003oool0oooo06<0oooo0P00000500abh0030000000fS^l0=Xk_0080
00000`1?TNh00`000000IZ7b06JQlP0406JQlP<0000000<0Lj3]00000022[O002022[O0200000080
RJc/00<0000009:gl02B]o000`2B]o0400000080UkK^0P00000309^gj`80000000D0Wl;a0000002Q
`_00XL;`000000020:?3l0050000002Ta?0000000:G5l00000000P2Va_0010000000Y/Oa00000000
00030;;9j`8000000`2ccNd3000000H0/]3`0P0000090;_Kl0@000002P30j_8010000000b?;]0<Sb
k@38l^d200000080^?O_00@000000;Olh@2go>40]ocQ0`00001=0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool01`3oool00200oooo00<0R38b08SGo`3oool0403oool00`000000oooo
0?ooo`1T0?ooo`800000100<L^0010000000=Xk_03J>k`0fS^l30000000304nAkP000000IZ7b00L0
IZ7b1000000908:]l0@00000202B]o030000000509NfkP00000000000000002N`_400P000000202O
`_4000000000002Q`_0000000:?3l0000000Y<C`0P0000020:K6l0050000002Vao4000000000002V
b?400`0000020;?=k@<00000102bd?04000000030;7DlP000000^m_`00D0^m_`100000020;OPm003
00000030j_80`>[b00P0`>[b00<000000<Sbk@0000000P0000030;Sgk`030000002go>40]ocQ00@0
0000CP3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00L0oooo000P0?ooo`0308Pb
<P28eol0oooo0140oooo0P0000000`3oool000000?ooo`1R0?ooo`<000000P0<L^000`000000=Xk_
03J>k`0403J>k`<00000201VXO800`000000NZod07Z_m004000000H0PZg`00<0000008jhl`2>^?<0
1000000709:gl0T0000000<0Wl;a0000002Q`_000`0000000`2UaO00000000000006000000030:K9
lP000000000000800000102bd?03000000D0/MCb00<000000;_Kl02kfo00100000060;OPm0030000
0030j_80`>[b00L0`>[b0`0000050;Sgk`030000002go>40000000@00000D03oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo00L0oooo000M0?ooo`050=N8<P00000003:808Pb<P28eol0
503oool2000006D0oooo0`0000000`0<L^00000003J>k`0603J>k`D000001@1VXO800`000000NZod
07Z_m00307Z_m0@000000P22[O000`000000S[Sc08jhl`0408jhl`D000000P2B]o0010000000Vl;c
09_2l`2K`_<8000000030:72l0000000000000X000000P2Vbo<00`000000/]3`00000003000000D0
/MCb1P0000090;OPm00300000030j_80`>[b00@0`>[b1@0000060;Sgk`<0000000<0S>g?00000000
0000D`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo000O0?ooo`030=N8
<P000380R=Oo01D0oooo0P00001U0?ooo`D000001`0fS^l010000000F:?f05RSmP1HXoH400000003
06JQlP000000NZod00P0NZod2@00000508jhl`T0000000<0Vl;c0000000000004`0000030;7DlPH0
00000`2^e_D00`000000]n3d0;OPm0090;OPm00300000030j_80`>[b00@000000`2ek_H00`000000
^?O_0;Sgk`030;Sgk`<0000000@0S>g?0000000000000000E@3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo00H0oooo000i0?ooo`030000003oool0oooo06@0oooo1@00000503J>k`03
0000001HXoH0F:?f00D0F:?f1@00000807Z_m0030000002:^_D0R[[e00@0R[[e9`0000080:kFm@03
0000002gh?@0]n3d00@0]n3d2@0000060;G^mP040000002hmnl0^?O_0;Sgk`@000000P2<kLl20000
05P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`060?ooo`00>P3oool00`000000
oooo0?ooo`1U0?ooo`H000000`0fS^l00`000000F:?f05RSmP0705RSmP030000001b/OP0000000D0
00000`1j[o@00`000000R[[e08Zjm@0:08Zjm@040000002I`oD0VL?e09W3mA@000000`2Tc?D00`00
0000[]Ke0:kFm@040:kFm@d000001@2`i?P00`000000]Nkf0;G^mP060;G^mPD0000000@0WO?[0000
00000000S>g?0P00001J0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool01P3oool0
03/0oooo0P00001W0?ooo`<0000000<078_Z0000000000000`00000905RSmP030000001b/OP0L[7h
00@0L[7h500000000`2Ha?H00000000000030000000309S6m`000000000001D000001@2Zf?P00`00
0000/>Ch0;3Tn0090;3Tn0030000002ek_H0]Nkf00@0]Nkf1000000409gcj`040000002<kLl00000
000005d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`00?@3oool00`00
0000oooo0000001V0?ooo`<000000`0LRnX7000000@0F:?f00<0000007:an01b/OP01`1b/OP20000
00L0Qkch2`0000000`2Ha_L00000000000020000000409W:n0000000000009c<n0<0000000@0X<gg
000000000000X/gg200000070:[Hn0030000002`i?P0/>Ch00P0/>Ch00<000000;G^mP0000001`00
000509gcj`<00000H03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo000n
0?ooo`800000J03oool3000000<078_Z0P00000304VUmaL000001P24_oX200000080V<Kg0P000000
2`2Hb?P0000009S9n0000000VL[h0000002KboP0000009c<n0000000W/gh0080000000<0X<gg0000
000000000P0000050:GInQ@000001@2UkoL00`000000WO?[09gcj`0309gcj`<00000H`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00H0oooo00100?ooo`030000003oool0oooo06L0
oooo1000000201b;jP8000001`19YOL2000000T0JkGk00<0000008BonP24_oX01@24_oX3000000<0
Pl;l0P00000209S8n0030000002HbOP000000080VL[h00<0000009_;n00000000P2Lc?P00`000000
W/gh09k=n002000000<0WmWl1@0000040:GInP8000002@2WiO/2000000L0YNog00@0000009gcj`2M
ln/0WO?[1000001V0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01P3oool00440
oooo0P00001Z0?ooo`L000001`19YOL2000000P0JkGk00<0000008BonP24_oX01000000408?2o080
00000P23a_d60000000309W:n0000000Vl_h00H000000P2If?d2000000H0WmWl1`0000060:OUn`80
00001`2UkoL8000006T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`050?ooo`00
@`3oool01@000000oooo0?ooo`3oool0000006L0oooo0P0000000`05Qmh000000000000E000000@0
Pl;l0`00000408?6o@0400000025b_h0QL[n00000080R<kn0`00000208cBoP040000002BeOh0T]Gn
000000@0VMSm0`00000309oIo08000001@2Ji?dE000006/0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`050?ooo`00A03oool010000000oooo0?ooo`00001W0?ooo`040000003oool0
0000000000801HON0P00000703fWm@8000002@1V^Od4000000D0PlKm0P00000308G:oP0500000028
c_h0R<kn08S>oP0000000`2<d_h010000000T]Gn09;EoP2BeOh2000000D0VMSm0`00000:09[To@80
00001P2?j_H200000080NNCO0`00001_0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool01@3oool004D0oooo0`00001W0?ooo`040000003oool0oooo0?ooo`8000000P05Qmh2000000L0
?JOe0P00000406Jio@@000000`1T__d200000080PlKm00<0000008G:oP25b_h00P25b_h00`000000
R<kn08S>oP0208S>oP030000002<d_h0S=;n0080S=;n00<0000009;EoP2BeOh00P2BeOh00`000000
VMSm09WHo@02000000<0SN3m1000000409[To@8000001@2?j_H7000007<0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`050?ooo`00A`3oool00`000000oooo0?ooo`1U0?ooo`030000
003oool0oooo00<0oooo1P00000503fWm@H000002@1T__d4000000<0QL[n00<0000008S>oP28c_h0
0P28c_h00`000000S=;n08cBoP0208cBoP040000002BeOh0T]Gn09;EoP@000002@2=h?d?000007L0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`00B03oool2000006D0oooo
00<000000?ooo`3oool01P3oool8000000D0=J_a1000000406Bno@800000101UaOdA000000@0Om[m
0`00000308gPo@@00000101fgo430000000404o=c`0000000000000007/0oooo00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`050?ooo`00BP3oool00`000000oooo0?ooo`1R0?ooo`030000
003oool0oooo00X0oooo2000000503F[l@@000001`1UaOd00`000000J/_m06[;o@0406[;o@030000
001cdod0Lm?m00@0Lm?m00<0000007oJo@1of_d01@1of_d4000000@0M]oa10000000101?cLl00000
00000000001n0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool01@3oool004/0oooo
00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0>0?ooo`T00000100c/N`4000000<0ILGm
00<0000006[;o@1Zbod0101Zbod00`000000Lm?m07?Co@0407?Co@040000001of_d0Om[m07oJo@@0
0000101Md^d900000880oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`040?ooo`00
C03oool300000600oooo00<000000?ooo`3oool04`3oool9000000<0<k7/5@00000305gBk@T00000
R03oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo001>0?ooo`030000003o
ool0oooo05h0oooo00<000000?ooo`3oool06@3oool;000000D0>[WY00<0000004S5j@18aNT00`18
aNT;000008l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`00C`3oool2
000005d0oooo00<000000?ooo`3oool0903oool=000009X0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`040?ooo`00D@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo
0<`0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`040?ooo`00DP3oool00`000000
oooo0?ooo`1I0?ooo`030000003oool0oooo0<`0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`040?ooo`00D`3oool2000000030?ooo`000000oooo05H0oooo00<000000?ooo`3oool0
c@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo000m0?ooo`050?n`G@00
000000000000001M/?l01@3oool00`2`G@000000001M/0050?ooo`060;1M0000000000000000001M
/?l0oooo0P00001G0?ooo`030000003oool0oooo0<h0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`00?@3oool01P28<Ud0/?oo0?ooo`3ook00G@1M0;3oo`@0oooo00<0/5d0
00000000GK00103oool0202`G@0005f`0?ooo`3oool0omN80380001M/?l0oooo0P00001F0?ooo`03
0000003oool0oooo0<l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`00
?03oool00`3o/5d005f`0?ooo`020?ooo`030=N8<P0bR=L0oooo00l0oooo00<0ok1M001M/03oool0
0P3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0=00oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`030?ooo`00?03oool00`3GR380<XSG0?ooo`020?ooo`030?n`G@00
GK00oooo00l0oooo00<0ok1M001M/03oool00`3oool00`000000oooo0?ooo`1B0?ooo`030000003o
ool0oooo0=00oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`00<`3oool0
0`28<P0000000000000300000005000bR03oool0oooo0=N8<P0bR=L00`3oool00`3o/5d005f`0?oo
o`0?0?ooo`0308Pb001M/?l0oooo00@0oooo0P0000000`3oool000000?ooo`1?0?ooo`030000003o
ool0oooo0=40oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`00?03oool0
0`3GR380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00X0oooo00<0oon`05d0000000000P000000
0`0bR=L0oooo0?ooo`060?ooo`800000D03oool00`000000oooo0?ooo`3B0?ooo`050000003oool0
oooo0?ooo`0000001@3oool003`0oooo00<0ok1M03:8e`3oool00P3oool00`3GR380<XSG0?ooo`0:
0?ooo`030?oo/01M05d0/?oo00`0oooo0P00001?0?ooo`030000003oool0oooo0=<0oooo00@00000
0?ooo`3oool000001@3oool003d0oooo00H0R38005f`o`3oool0omN80380G@2`ool;0?ooo`030?oo
/01M05d0/?oo00h0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`3D0?ooo`030000
003oool0000000D0oooo000m0?ooo`050?oo/01M000000000000<P28eol0303oool00`3ook00G@00
00000002000000030000G@2`ool0oooo00X0oooo00<000000?ooo`3oool0B`3oool00`000000oooo
0?ooo`3E0?ooo`030000003oool0000000@0oooo001Q0?ooo`80000000<0oooo0000003oool0B03o
ool00`000000oooo0?ooo`3E0?ooo`030000003oool0000000@0oooo001S0?ooo`800000B@3oool0
0`000000oooo0?ooo`3F0?ooo`800000103oool006@0oooo0P0000180?ooo`030000003oool0oooo
0=D0oooo0`0000040?ooo`00IP3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo0=40
oooo100000070?ooo`00I`3oool01@000000oooo0?ooo`3oool000000480oooo00<000000?ooo`3o
ool0c@3oool4000000/0oooo001X0?ooo`80000000<0oooo0000003oool0@@3oool00`000000oooo
0?ooo`380?ooo`D000003`3oool006X0oooo0P0000120?ooo`030000003oool0oooo0<@0oooo1000
000D0?ooo`00J`3oool200000440oooo00<000000?ooo`3oool0`03oool4000001P0oooo001]0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool0^`3oool5000001`0oooo001^0?ooo`03
0000003oool0oooo03d0oooo00<000000?ooo`3oool0]`3oool400000240oooo001_0?ooo`800000
00<0oooo0000003oool0>P3oool00`000000oooo0?ooo`2c0?ooo`@000009@3oool00740oooo0P00
000k0?ooo`030000003oool0oooo0:l0oooo1000000Y0?ooo`00LP3oool2000003X0oooo00<00000
0?ooo`3oool0ZP3oool5000002d0oooo001d0?ooo`030000003oool0oooo03L0oooo00<000000?oo
o`3oool0YP3oool400000380oooo001e0?ooo`050000003oool0oooo0?ooo`000000<`3oool00`00
0000oooo0?ooo`2S0?ooo`@00000=P3oool007H0oooo0P0000000`3oool000000?ooo`0b0?ooo`03
0000003oool0oooo09h0oooo1@00000j0?ooo`00N03oool2000003<0oooo00<000000?ooo`3oool0
VP3oool4000003l0oooo001X0?ooo`050?n`G@00000000000000001M/?l0303oool200000380oooo
00<000000?ooo`3oool0UP3oool4000004<0oooo001X0?ooo`0608PbG@2`ool0oooo0?oo/01M05d0
/?oo3@3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo0940oooo1@0000170?ooo`00
I`3oool00`3o/5d005f`0?ooo`020?ooo`030=N8<P0bR=L0oooo00d0oooo00@000000?ooo`3oool0
0000;@3oool00`000000oooo0?ooo`2=0?ooo`@00000C03oool006L0oooo00<0ehPb03:8e`3oool0
0P3oool00`3o/5d005f`0?ooo`0>0?ooo`<00000;@3oool00`000000oooo0?ooo`290?ooo`@00000
D03oool006L0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0@0?ooo`030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0Q03oool5000005@0oooo001W0?ooo`030=N8<P0bR=L0
oooo0080oooo00<0ok1M001M/03oool04@3oool2000002/0oooo00<000000?ooo`3oool0P03oool4
000005T0oooo001W0?ooo`030?n`G@0bR=L0oooo0080oooo00<0ehPb03:8e`3oool04`3oool00`00
0000oooo0?ooo`0X0?ooo`030000003oool0oooo07`0oooo1000001M0?ooo`00J03oool01P28<P00
GK3o0?ooo`3oehP0<P1M0;3ooaD0oooo00@000000?ooo`3oool000009P3oool00`000000oooo0?oo
o`1g0?ooo`D00000H@3oool006P0oooo00D0oon`05d000000000000b08SGo`0G0?ooo`<000009P3o
ool00`000000oooo0?ooo`1c0?ooo`@00000IP3oool008H0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`1_0?ooo`@00000JP3oool008L0oooo0P0000030?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool0J`3oool4000006h0oooo00290?ooo`040000003oool0oooo0000
0200oooo00<000000?ooo`3oool0IP3oool500000780oooo002:0?ooo`<00000803oool00`000000
oooo0?ooo`1R0?ooo`@00000M`3oool008`0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`1N0?ooo`@00000N`3oool008d0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?oo
o`1I0?ooo`D00000O`3oool008h0oooo0P0000020?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0E@3oool4000008@0oooo002@0?ooo`030000003oool0000001X0oooo00<000000?oo
o`3oool0D@3oool4000008P0oooo002A0?ooo`8000006P3oool00`000000oooo0?ooo`1<0?ooo`D0
0000S03oool009<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`180?ooo`@00000
T@3oool009@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`140?ooo`@00000U@3o
ool009D0oooo0P0000000`3oool000000?ooo`0C0?ooo`030000003oool0oooo03l0oooo1@00002I
0?ooo`00U`3oool2000001@0oooo00<000000?ooo`3oool0>`3oool4000009h0oooo002H0?ooo`80
00004`3oool00`000000oooo0?ooo`0g0?ooo`@00000XP3oool007l0oooo00D0ok1M000000000000
000005f`o`050?ooo`030;1M0000000005f`00D0oooo00D0/5d0000000000000000005f`o`040?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0<`3oool500000:H0oooo001o0?ooo`06
08PbG@2`ool0oooo0?oo/01M05d0/?oo103oool00`2`G@000000001M/0040?ooo`070;1M0000GK00
oooo0?ooo`3oehP0<P0005f`o`040?ooo`040000003oool0oooo000000d0oooo00<000000?ooo`3o
ool0;`3oool400000:/0oooo001n0?ooo`030?n`G@00GK00oooo0080oooo00<0ehPb03:8e`3oool0
3`3oool00`3o/5d005f`0?ooo`040?ooo`<000003@3oool00`000000oooo0?ooo`0[0?ooo`@00000
[`3oool007h0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0?0?ooo`030?n`G@00
GK00oooo00H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0V0?ooo`D00000/`3o
ool007h0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0?0?ooo`0308Pb001M/?l0
oooo00L0oooo0P00000;0?ooo`030000003oool0oooo0280oooo1000002h0?ooo`00OP3oool00`3G
R380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00X0oooo00<0oon`05d0000000000P0000000`0b
R=L0oooo0?ooo`090?ooo`040000003oool0oooo000000L0oooo00<000000?ooo`3oool07P3oool4
00000;`0oooo001n0?ooo`030?n`G@0bR=L0oooo0080oooo00<0ehPb03:8e`3oool02P3oool00`3o
ok00G@1M0;3oo`0?0?ooo`030000003oool0000000L0oooo00<000000?ooo`3oool06P3oool40000
0<00oooo001o0?ooo`0608Pb001M/?l0oooo0?oGR00b05d0/?oo2`3oool00`3ook00G@1M0;3oo`0@
0?ooo`8000001`3oool00`000000oooo0?ooo`0E0?ooo`D00000a03oool007l0oooo00D0oon`05d0
00000000000b08SGo`0<0?ooo`030?oo/01M000000000080000000<0001M0;3oo`3oool03@3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000001<0oooo100000390?ooo`00YP3oool20000
0080oooo00<000000?ooo`0000003`3oool400000<d0oooo002X0?ooo`050000003oool000000?oo
o`0000002P3oool500000=40oooo002Y0?ooo`80000000<0oooo0000003oool01@3oool400000=H0
oooo002Z0?ooo`<000000P3oool400000=X0oooo002/0?ooo`<00000gP3oool00?l0ooooSP3oool0
0?l0ooooSP3oool00?l0ooooSP3oool00?l0ooooSP3oool00?l0ooooSP3oool00?l0ooooSP3oool0
0?l0ooooSP3oool00:H0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`3N0?ooo`00
Z@3oool00`2jLW80^^[o0?ooo`3Q0?ooo`00Z@3oool00`2jLW80^^[o0?ooo`3Q0?ooo`00Z@3oool0
0`2jLW80^^[o0?ooo`3Q0?ooo`00Z@3oool00`2jLW80^^[o0?ooo`3Q0?ooo`00Z@3oool00`2jLW80
^^[o0?ooo`3Q0?ooo`00Z@3oool00`2jLW80^^[o0?ooo`3Q0?ooo`00YP3oool01@3Z^W800000001b
^P2jLW80^^[o0>80oooo002X0?ooo`030>ZjLP000780^^[o0>80oooo0000\
\>"],
  ImageRangeCache->{{{0, 396.125}, {430.875, 0}} -> {-0.0122941, -0.037443, \
0.00351098, 0.00351098}}]
}, Open  ]],

Cell["\<\
Controlando los par\[AAcute]metros puedes conseguir representar partes de la \
superficie. \
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[{Cos[\[Phi]] Sin[\[Theta]], 
          Sin[\[Phi]] Sin[\[Theta]], Cos[\[Theta]]}, {\[Phi], \(-\[Pi]\)/5, 
          3  \[Pi]/2}, {\[Theta], \[Pi]/8, \[Pi] - \[Pi]/8}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.05469 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0436334 1.13972 -1.14654e-016 1.13972 [
[.08375 .23169 -11.8927 -9 ]
[.08375 .23169 .10728 0 ]
[.21414 .17706 -22.7201 -9 ]
[.21414 .17706 1.27993 0 ]
[.35181 .11941 -5.41368 -9 ]
[.35181 .11941 .58632 0 ]
[.49737 .05849 -15.442 -9 ]
[.49737 .05849 2.55799 0 ]
[.65153 -0.00598 -4.881 -9 ]
[.65153 -0.00598 1.119 0 ]
[.0094 .78939 -6.9259 0 ]
[.0094 .78939 5.0741 9 ]
[.12074 .86902 -13.4191 0 ]
[.12074 .86902 10.5809 9 ]
[.22067 .94049 -3.26189 0 ]
[.22067 .94049 2.73811 9 ]
[.31085 1.00498 -9.54377 0 ]
[.31085 1.00498 8.45623 9 ]
[.39265 1.06348 -3.1106 0 ]
[.39265 1.06348 2.8894 9 ]
[.05158 .3624 -24 -2.7205 ]
[.05158 .3624 0 6.2795 ]
[.03129 .48968 -6 -2.83339 ]
[.03129 .48968 0 6.16661 ]
[.00915 .62858 -18 -2.9577 ]
[.00915 .62858 0 6.0423 ]
[ 0 0 0 0 ]
[ 1 1.05469 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08232 .24662 m
.6737 0 L
s
.09373 .24186 m
.09872 .24694 L
s
[(-1)] .08375 .23169 .98212 1 Mshowa
.22363 .18768 m
.22838 .193 L
s
[(-0.5)] .21414 .17706 .89334 1 Mshowa
.36074 .13051 m
.36521 .13606 L
s
[(0)] .35181 .11941 .80456 1 Mshowa
.50567 .07007 m
.50981 .07586 L
s
[(0.5)] .49737 .05849 .71578 1 Mshowa
.6591 .00609 m
.66288 .01212 L
s
[(1)] .65153 -0.00598 .627 1 Mshowa
.125 Mabswid
.11916 .23125 m
.12213 .23433 L
s
.14486 .22053 m
.1478 .22364 L
s
.17084 .2097 m
.17375 .21283 L
s
.19709 .19875 m
.19997 .20191 L
s
.25046 .1765 m
.25328 .17971 L
s
.27758 .16519 m
.28036 .16843 L
s
.305 .15375 m
.30774 .15703 L
s
.33271 .1422 m
.33543 .1455 L
s
.38908 .11869 m
.39172 .12205 L
s
.41774 .10674 m
.42034 .11013 L
s
.44672 .09466 m
.44928 .09807 L
s
.47602 .08243 m
.47855 .08588 L
s
.53565 .05757 m
.5381 .06107 L
s
.56598 .04492 m
.56838 .04846 L
s
.59666 .03213 m
.59902 .03569 L
s
.6277 .01918 m
.63001 .02278 L
s
.25 Mabswid
0 .767 m
.40076 1.05469 L
s
.01158 .77531 m
.01266 .76827 L
s
[(-1)] .0094 .78939 .15432 -1 Mshowa
.12242 .85487 m
.12325 .8478 L
s
[(-0.5)] .12074 .86902 .11826 -1 Mshowa
.22191 .9263 m
.22253 .9192 L
s
[(0)] .22067 .94049 .0873 -1 Mshowa
.31171 .99076 m
.31214 .98365 L
s
[(0.5)] .31085 1.00498 .06042 -1 Mshowa
.39317 1.04924 m
.39344 1.04212 L
s
[(1)] .39265 1.06348 .03687 -1 Mshowa
.125 Mabswid
.03475 .79194 m
.03537 .78771 L
s
.0574 .8082 m
.05799 .80397 L
s
.07955 .8241 m
.08011 .81986 L
s
.10122 .83966 m
.10175 .83541 L
s
.14316 .86977 m
.14364 .86552 L
s
.16347 .88435 m
.16392 .8801 L
s
.18336 .89862 m
.18378 .89437 L
s
.20283 .9126 m
.20323 .90835 L
s
.2406 .93971 m
.24094 .93545 L
s
.25891 .95286 m
.25924 .9486 L
s
.27686 .96574 m
.27716 .96148 L
s
.29446 .97837 m
.29474 .97411 L
s
.32863 1.00291 m
.32887 .99864 L
s
.34523 1.01482 m
.34545 1.01055 L
s
.36151 1.02651 m
.36171 1.02224 L
s
.37749 1.03798 m
.37767 1.03371 L
s
.25 Mabswid
.08232 .24662 m
0 .767 L
s
.06483 .35717 m
.07145 .35455 L
s
[(-0.5)] .05158 .3624 1 -0.39544 Mshowa
.04465 .48473 m
.05133 .48226 L
s
[(0)] .03129 .48968 1 -0.37036 Mshowa
.02263 .62396 m
.02936 .62165 L
s
[(0.5)] .00915 .62858 1 -0.34273 Mshowa
.125 Mabswid
.06093 .38182 m
.06491 .38026 L
s
.05696 .40689 m
.06095 .40535 L
s
.05293 .43239 m
.05692 .43087 L
s
.04883 .45833 m
.05283 .45683 L
s
.0404 .51159 m
.04442 .51013 L
s
.03608 .53894 m
.0401 .53749 L
s
.03167 .56677 m
.0357 .56534 L
s
.02719 .59511 m
.03123 .5937 L
s
.06866 .33292 m
.07263 .33134 L
s
.07243 .30908 m
.0764 .30748 L
s
.07614 .28563 m
.0801 .28401 L
s
.07979 .26256 m
.08374 .26093 L
s
.01798 .65335 m
.02203 .65199 L
s
.01324 .68329 m
.0173 .68195 L
s
.00842 .71379 m
.01248 .71247 L
s
.0035 .74487 m
.00757 .74357 L
s
.25 Mabswid
.08232 .24662 m
0 .767 L
s
0 .767 m
.40076 1.05469 L
s
.40076 1.05469 m
.41708 .58471 L
s
.41708 .58471 m
.08232 .24662 L
s
.6737 0 m
.93222 .41777 L
s
.93222 .41777 m
1 .91485 L
s
1 .91485 m
.70513 .54553 L
s
.70513 .54553 m
.6737 0 L
s
.08232 .24662 m
0 .767 L
s
0 .767 m
.70513 .54553 L
s
.70513 .54553 m
.6737 0 L
s
.6737 0 m
.08232 .24662 L
s
.41708 .58471 m
.93222 .41777 L
s
.93222 .41777 m
1 .91485 L
s
1 .91485 m
.40076 1.05469 L
s
.40076 1.05469 m
.41708 .58471 L
s
0 0 m
1 0 L
1 1.05469 L
0 1.05469 L
closepath
clip
newpath
.5 Mabswid
.73 .599 .711 r
.47176 .54932 m .51153 .55313 L .5106 .57611 L p F P
0 g
s
.73 .599 .711 r
.5106 .57611 m .4683 .57212 L .47176 .54932 L p F P
0 g
s
.703 .577 .71 r
.5533 .57547 m .5106 .57611 L .51153 .55313 L p F P
0 g
s
.731 .588 .696 r
.4683 .57212 m .5106 .57611 L .50976 .59906 L p F P
0 g
s
.703 .564 .695 r
.5106 .57611 m .5533 .57547 L .55477 .59841 L p F P
0 g
s
.703 .564 .695 r
.55477 .59841 m .50976 .59906 L .5106 .57611 L p F P
0 g
s
.728 .61 .725 r
.47555 .52663 m .51254 .53022 L .51153 .55313 L p F P
0 g
s
.728 .61 .725 r
.51153 .55313 m .47176 .54932 L .47555 .52663 L p F P
0 g
s
.703 .589 .725 r
.55167 .55252 m .51153 .55313 L .51254 .53022 L p F P
0 g
s
.703 .577 .71 r
.51153 .55313 m .55167 .55252 L .5533 .57547 L p F P
0 g
s
.676 .556 .711 r
.5953 .57023 m .5533 .57547 L .55167 .55252 L p F P
0 g
s
.674 .542 .696 r
.5533 .57547 m .5953 .57023 L .59905 .59295 L p F P
0 g
s
.674 .542 .696 r
.59905 .59295 m .55477 .59841 L .5533 .57547 L p F P
0 g
s
.703 .589 .725 r
.51254 .53022 m .5499 .52965 L .55167 .55252 L p F P
0 g
s
.677 .569 .726 r
.59115 .54752 m .55167 .55252 L .5499 .52965 L p F P
0 g
s
.676 .556 .711 r
.55167 .55252 m .59115 .54752 L .5953 .57023 L p F P
0 g
s
.731 .588 .696 r
.50976 .59906 m .46517 .59492 L .4683 .57212 L p F P
0 g
s
.732 .577 .68 r
.46517 .59492 m .50976 .59906 L .50902 .6219 L p F P
0 g
s
.702 .552 .68 r
.50976 .59906 m .55477 .59841 L .55608 .62122 L p F P
0 g
s
.702 .552 .68 r
.55608 .62122 m .50902 .6219 L .50976 .59906 L p F P
0 g
s
.671 .528 .681 r
.55477 .59841 m .59905 .59295 L .60239 .6156 L p F P
0 g
s
.671 .528 .681 r
.60239 .6156 m .55608 .62122 L .55477 .59841 L p F P
0 g
s
.726 .621 .74 r
.47963 .50413 m .51364 .50747 L .51254 .53022 L p F P
0 g
s
.726 .621 .74 r
.51254 .53022 m .47555 .52663 L .47963 .50413 L p F P
0 g
s
.703 .601 .739 r
.5499 .52965 m .51254 .53022 L .51364 .50747 L p F P
0 g
s
.703 .601 .739 r
.51364 .50747 m .54798 .50694 L .5499 .52965 L p F P
0 g
s
.679 .583 .741 r
.58662 .52493 m .5499 .52965 L .54798 .50694 L p F P
0 g
s
.677 .569 .726 r
.5499 .52965 m .58662 .52493 L .59115 .54752 L p F P
0 g
s
.732 .577 .68 r
.50902 .6219 m .46238 .61762 L .46517 .59492 L p F P
0 g
s
.733 .565 .664 r
.46238 .61762 m .50902 .6219 L .50837 .64452 L p F P
0 g
s
.701 .538 .664 r
.50902 .6219 m .55608 .62122 L .55721 .64382 L p F P
0 g
s
.701 .538 .664 r
.55721 .64382 m .50837 .64452 L .50902 .6219 L p F P
0 g
s
.756 .624 .713 r
.43343 .54119 m .47176 .54932 L .4683 .57212 L p F P
0 g
s
.756 .624 .713 r
.4683 .57212 m .42749 .56357 L .43343 .54119 L p F P
0 g
s
.759 .614 .698 r
.42749 .56357 m .4683 .57212 L .46517 .59492 L p F P
0 g
s
.753 .633 .728 r
.43991 .51896 m .47555 .52663 L .47176 .54932 L p F P
0 g
s
.753 .633 .728 r
.47176 .54932 m .43343 .54119 L .43991 .51896 L p F P
0 g
s
.669 .513 .664 r
.55608 .62122 m .60239 .6156 L .60529 .63807 L p F P
0 g
s
.669 .513 .664 r
.60529 .63807 m .55721 .64382 L .55608 .62122 L p F P
0 g
s
.724 .631 .755 r
.48401 .48193 m .51481 .48499 L .51364 .50747 L p F P
0 g
s
.724 .631 .755 r
.51364 .50747 m .47963 .50413 L .48401 .48193 L p F P
0 g
s
.702 .613 .754 r
.54798 .50694 m .51364 .50747 L .51481 .48499 L p F P
0 g
s
.759 .614 .698 r
.46517 .59492 m .42212 .58603 L .42749 .56357 L p F P
0 g
s
.761 .604 .682 r
.42212 .58603 m .46517 .59492 L .46238 .61762 L p F P
0 g
s
.749 .643 .743 r
.4469 .49699 m .47963 .50413 L .47555 .52663 L p F P
0 g
s
.749 .643 .743 r
.47555 .52663 m .43991 .51896 L .4469 .49699 L p F P
0 g
s
.702 .613 .754 r
.51481 .48499 m .54593 .48451 L .54798 .50694 L p F P
0 g
s
.68 .596 .755 r
.58173 .50255 m .54798 .50694 L .54593 .48451 L p F P
0 g
s
.679 .583 .741 r
.54798 .50694 m .58173 .50255 L .58662 .52493 L p F P
0 g
s
.65 .551 .729 r
.62891 .53822 m .59115 .54752 L .58662 .52493 L p F P
0 g
s
.646 .536 .714 r
.59115 .54752 m .62891 .53822 L .63551 .56046 L p F P
0 g
s
.646 .536 .714 r
.63551 .56046 m .5953 .57023 L .59115 .54752 L p F P
0 g
s
.642 .52 .699 r
.5953 .57023 m .63551 .56046 L .64148 .58279 L p F P
0 g
s
.642 .52 .699 r
.64148 .58279 m .59905 .59295 L .5953 .57023 L p F P
0 g
s
.653 .566 .744 r
.62172 .51617 m .58662 .52493 L .58173 .50255 L p F P
0 g
s
.65 .551 .729 r
.58662 .52493 m .62172 .51617 L .62891 .53822 L p F P
0 g
s
.638 .504 .683 r
.59905 .59295 m .64148 .58279 L .64679 .60511 L p F P
0 g
s
.638 .504 .683 r
.64679 .60511 m .60239 .6156 L .59905 .59295 L p F P
0 g
s
.733 .565 .664 r
.50837 .64452 m .45996 .64014 L .46238 .61762 L p F P
0 g
s
.733 .552 .647 r
.45996 .64014 m .50837 .64452 L .50782 .66682 L p F P
0 g
s
.7 .524 .647 r
.50837 .64452 m .55721 .64382 L .55817 .66612 L p F P
0 g
s
.7 .524 .647 r
.55817 .66612 m .50782 .66682 L .50837 .64452 L p F P
0 g
s
.761 .604 .682 r
.46238 .61762 m .41734 .60845 L .42212 .58603 L p F P
0 g
s
.764 .593 .666 r
.41734 .60845 m .46238 .61762 L .45996 .64014 L p F P
0 g
s
.666 .498 .647 r
.55721 .64382 m .60529 .63807 L .60775 .66026 L p F P
0 g
s
.666 .498 .647 r
.60775 .66026 m .55817 .66612 L .55721 .64382 L p F P
0 g
s
.745 .652 .758 r
.45438 .47538 m .48401 .48193 L .47963 .50413 L p F P
0 g
s
.745 .652 .758 r
.47963 .50413 m .4469 .49699 L .45438 .47538 L p F P
0 g
s
.721 .642 .769 r
.48865 .46011 m .51606 .46287 L .51481 .48499 L p F P
0 g
s
.721 .642 .769 r
.51481 .48499 m .48401 .48193 L .48865 .46011 L p F P
0 g
s
.701 .625 .768 r
.54593 .48451 m .51481 .48499 L .51606 .46287 L p F P
0 g
s
.68 .596 .755 r
.54593 .48451 m .57649 .48048 L .58173 .50255 L p F P
0 g
s
.657 .581 .759 r
.61395 .4944 m .58173 .50255 L .57649 .48048 L p F P
0 g
s
.653 .566 .744 r
.58173 .50255 m .61395 .4944 L .62172 .51617 L p F P
0 g
s
.701 .625 .768 r
.51606 .46287 m .54375 .46243 L .54593 .48451 L p F P
0 g
s
.681 .61 .77 r
.57649 .48048 m .54593 .48451 L .54375 .46243 L p F P
0 g
s
.634 .488 .667 r
.60239 .6156 m .64679 .60511 L .65142 .62733 L p F P
0 g
s
.634 .488 .667 r
.65142 .62733 m .60529 .63807 L .60239 .6156 L p F P
0 g
s
.764 .593 .666 r
.45996 .64014 m .41318 .63075 L .41734 .60845 L p F P
0 g
s
.765 .581 .649 r
.41318 .63075 m .45996 .64014 L .45791 .66237 L p F P
0 g
s
.733 .552 .647 r
.50782 .66682 m .45791 .66237 L .45996 .64014 L p F P
0 g
s
.776 .659 .733 r
.40662 .50736 m .43991 .51896 L .43343 .54119 L p F P
0 g
s
.776 .659 .733 r
.43343 .54119 m .39757 .52887 L .40662 .50736 L p F P
0 g
s
.782 .651 .718 r
.39757 .52887 m .43343 .54119 L .42749 .56357 L p F P
0 g
s
.74 .661 .772 r
.46232 .45422 m .48865 .46011 L .48401 .48193 L p F P
0 g
s
.74 .661 .772 r
.48401 .48193 m .45438 .47538 L .46232 .45422 L p F P
0 g
s
.733 .539 .629 r
.45791 .66237 m .50782 .66682 L .50737 .68872 L p F P
0 g
s
.698 .51 .629 r
.50782 .66682 m .55817 .66612 L .55895 .688 L p F P
0 g
s
.698 .51 .629 r
.55895 .688 m .50737 .68872 L .50782 .66682 L p F P
0 g
s
.782 .651 .718 r
.42749 .56357 m .38927 .55063 L .39757 .52887 L p F P
0 g
s
.786 .642 .703 r
.38927 .55063 m .42749 .56357 L .42212 .58603 L p F P
0 g
s
.771 .667 .748 r
.41637 .4862 m .4469 .49699 L .43991 .51896 L p F P
0 g
s
.771 .667 .748 r
.43991 .51896 m .40662 .50736 L .41637 .4862 L p F P
0 g
s
.662 .481 .629 r
.55817 .66612 m .60775 .66026 L .60975 .68209 L p F P
0 g
s
.662 .481 .629 r
.60975 .68209 m .55895 .688 L .55817 .66612 L p F P
0 g
s
.681 .61 .77 r
.54375 .46243 m .57093 .45881 L .57649 .48048 L p F P
0 g
s
.66 .597 .773 r
.60564 .473 m .57649 .48048 L .57093 .45881 L p F P
0 g
s
.657 .581 .759 r
.57649 .48048 m .60564 .473 L .61395 .4944 L p F P
0 g
s
.629 .471 .649 r
.60529 .63807 m .65142 .62733 L .65533 .64935 L p F P
0 g
s
.629 .471 .649 r
.65533 .64935 m .60775 .66026 L .60529 .63807 L p F P
0 g
s
.786 .642 .703 r
.42212 .58603 m .38176 .57256 L .38927 .55063 L p F P
0 g
s
.791 .633 .686 r
.38176 .57256 m .42212 .58603 L .41734 .60845 L p F P
0 g
s
.718 .653 .784 r
.49355 .43879 m .51737 .44121 L .51606 .46287 L p F P
0 g
s
.718 .653 .784 r
.51606 .46287 m .48865 .46011 L .49355 .43879 L p F P
0 g
s
.7 .638 .783 r
.54375 .46243 m .51606 .46287 L .51737 .44121 L p F P
0 g
s
.62 .534 .735 r
.66391 .5248 m .62891 .53822 L .62172 .51617 L p F P
0 g
s
.614 .517 .72 r
.62891 .53822 m .66391 .5248 L .67283 .54636 L p F P
0 g
s
.614 .517 .72 r
.67283 .54636 m .63551 .56046 L .62891 .53822 L p F P
0 g
s
.765 .674 .763 r
.42679 .4655 m .45438 .47538 L .4469 .49699 L p F P
0 g
s
.765 .674 .763 r
.4469 .49699 m .41637 .4862 L .42679 .4655 L p F P
0 g
s
.7 .638 .783 r
.51737 .44121 m .54144 .44083 L .54375 .46243 L p F P
0 g
s
.682 .624 .785 r
.57093 .45881 m .54375 .46243 L .54144 .44083 L p F P
0 g
s
.626 .551 .75 r
.6542 .50353 m .62172 .51617 L .61395 .4944 L p F P
0 g
s
.62 .534 .735 r
.62172 .51617 m .6542 .50353 L .66391 .5248 L p F P
0 g
s
.608 .499 .704 r
.63551 .56046 m .67283 .54636 L .68091 .56811 L p F P
0 g
s
.608 .499 .704 r
.68091 .56811 m .64148 .58279 L .63551 .56046 L p F P
0 g
s
.765 .581 .649 r
.45791 .66237 m .40965 .65283 L .41318 .63075 L p F P
0 g
s
.767 .569 .63 r
.40965 .65283 m .45791 .66237 L .45624 .68422 L p F P
0 g
s
.733 .539 .629 r
.50737 .68872 m .45624 .68422 L .45791 .66237 L p F P
0 g
s
.791 .633 .686 r
.41734 .60845 m .37507 .59455 L .38176 .57256 L p F P
0 g
s
.794 .623 .669 r
.37507 .59455 m .41734 .60845 L .41318 .63075 L p F P
0 g
s
.631 .568 .765 r
.64372 .48265 m .61395 .4944 L .60564 .473 L p F P
0 g
s
.626 .551 .75 r
.61395 .4944 m .64372 .48265 L .6542 .50353 L p F P
0 g
s
.735 .67 .787 r
.47068 .4336 m .49355 .43879 L .48865 .46011 L p F P
0 g
s
.735 .67 .787 r
.48865 .46011 m .46232 .45422 L .47068 .4336 L p F P
0 g
s
.602 .481 .688 r
.64148 .58279 m .68091 .56811 L .6881 .58995 L p F P
0 g
s
.602 .481 .688 r
.6881 .58995 m .64679 .60511 L .64148 .58279 L p F P
0 g
s
.758 .682 .777 r
.43784 .44533 m .46232 .45422 L .45438 .47538 L p F P
0 g
s
.758 .682 .777 r
.45438 .47538 m .42679 .4655 L .43784 .44533 L p F P
0 g
s
.682 .624 .785 r
.54144 .44083 m .56507 .43764 L .57093 .45881 L p F P
0 g
s
.662 .612 .788 r
.59683 .45208 m .57093 .45881 L .56507 .43764 L p F P
0 g
s
.66 .597 .773 r
.57093 .45881 m .59683 .45208 L .60564 .473 L p F P
0 g
s
.732 .524 .61 r
.45624 .68422 m .50737 .68872 L .50703 .7101 L p F P
0 g
s
.696 .494 .61 r
.50737 .68872 m .55895 .688 L .55955 .70938 L p F P
0 g
s
.696 .494 .61 r
.55955 .70938 m .50703 .7101 L .50737 .68872 L p F P
0 g
s
.623 .452 .63 r
.60775 .66026 m .65533 .64935 L .65851 .67105 L p F P
0 g
s
.623 .452 .63 r
.65851 .67105 m .60975 .68209 L .60775 .66026 L p F P
0 g
s
.658 .464 .61 r
.55895 .688 m .60975 .68209 L .61127 .70344 L p F P
0 g
s
.658 .464 .61 r
.61127 .70344 m .55955 .70938 L .55895 .688 L p F P
0 g
s
.637 .585 .779 r
.63253 .46224 m .60564 .473 L .59683 .45208 L p F P
0 g
s
.631 .568 .765 r
.60564 .473 m .63253 .46224 L .64372 .48265 L p F P
0 g
s
.595 .462 .67 r
.64679 .60511 m .6881 .58995 L .69437 .61179 L p F P
0 g
s
.595 .462 .67 r
.69437 .61179 m .65142 .62733 L .64679 .60511 L p F P
0 g
s
.794 .623 .669 r
.41318 .63075 m .36924 .61651 L .37507 .59455 L p F P
0 g
s
.798 .613 .651 r
.36924 .61651 m .41318 .63075 L .40965 .65283 L p F P
0 g
s
.714 .664 .799 r
.49868 .41805 m .51875 .42012 L .51737 .44121 L p F P
0 g
s
.714 .664 .799 r
.51737 .44121 m .49355 .43879 L .49868 .41805 L p F P
0 g
s
.698 .65 .798 r
.54144 .44083 m .51737 .44121 L .51875 .42012 L p F P
0 g
s
.698 .65 .798 r
.51875 .42012 m .53903 .41979 L .54144 .44083 L p F P
0 g
s
.682 .638 .8 r
.56507 .43764 m .54144 .44083 L .53903 .41979 L p F P
0 g
s
.75 .689 .792 r
.44946 .42579 m .47068 .4336 L .46232 .45422 L p F P
0 g
s
.75 .689 .792 r
.46232 .45422 m .43784 .44533 L .44946 .42579 L p F P
0 g
s
.767 .569 .63 r
.45624 .68422 m .40679 .67457 L .40965 .65283 L p F P
0 g
s
.768 .555 .61 r
.40679 .67457 m .45624 .68422 L .45497 .70558 L p F P
0 g
s
.732 .524 .61 r
.50703 .7101 m .45497 .70558 L .45624 .68422 L p F P
0 g
s
.792 .694 .756 r
.38894 .47201 m .41637 .4862 L .40662 .50736 L p F P
0 g
s
.792 .694 .756 r
.40662 .50736 m .37664 .49207 L .38894 .47201 L p F P
0 g
s
.8 .688 .741 r
.37664 .49207 m .40662 .50736 L .39757 .52887 L p F P
0 g
s
.8 .688 .741 r
.39757 .52887 m .36522 .51262 L .37664 .49207 L p F P
0 g
s
.807 .681 .725 r
.36522 .51262 m .39757 .52887 L .38927 .55063 L p F P
0 g
s
.728 .679 .802 r
.47944 .41363 m .49868 .41805 L .49355 .43879 L p F P
0 g
s
.728 .679 .802 r
.49355 .43879 m .47068 .4336 L .47944 .41363 L p F P
0 g
s
.662 .612 .788 r
.56507 .43764 m .58755 .43172 L .59683 .45208 L p F P
0 g
s
.642 .602 .794 r
.62068 .4424 m .59683 .45208 L .58755 .43172 L p F P
0 g
s
.637 .585 .779 r
.59683 .45208 m .62068 .4424 L .63253 .46224 L p F P
0 g
s
.587 .442 .652 r
.65142 .62733 m .69437 .61179 L .69968 .63354 L p F P
0 g
s
.587 .442 .652 r
.69968 .63354 m .65533 .64935 L .65142 .62733 L p F P
0 g
s
.682 .638 .8 r
.53903 .41979 m .55893 .41707 L .56507 .43764 L p F P
0 g
s
.665 .628 .803 r
.58755 .43172 m .56507 .43764 L .55893 .41707 L p F P
0 g
s
.784 .699 .771 r
.40206 .4525 m .42679 .4655 L .41637 .4862 L p F P
0 g
s
.784 .699 .771 r
.41637 .4862 m .38894 .47201 L .40206 .4525 L p F P
0 g
s
.807 .681 .725 r
.38927 .55063 m .35473 .53354 L .36522 .51262 L p F P
0 g
s
.814 .674 .709 r
.35473 .53354 m .38927 .55063 L .38176 .57256 L p F P
0 g
s
.617 .433 .61 r
.60975 .68209 m .65851 .67105 L .66094 .69236 L p F P
0 g
s
.617 .433 .61 r
.66094 .69236 m .61127 .70344 L .60975 .68209 L p F P
0 g
s
.731 .508 .589 r
.45497 .70558 m .50703 .7101 L .5068 .73086 L p F P
0 g
s
.693 .477 .59 r
.50703 .7101 m .55955 .70938 L .55995 .73015 L p F P
0 g
s
.693 .477 .59 r
.55995 .73015 m .5068 .73086 L .50703 .7101 L p F P
0 g
s
.798 .613 .651 r
.40965 .65283 m .3643 .63833 L .36924 .61651 L p F P
0 g
s
.801 .601 .632 r
.3643 .63833 m .40965 .65283 L .40679 .67457 L p F P
0 g
s
.654 .445 .589 r
.55955 .70938 m .61127 .70344 L .6123 .72421 L p F P
0 g
s
.654 .445 .589 r
.6123 .72421 m .55995 .73015 L .55955 .70938 L p F P
0 g
s
.775 .705 .785 r
.41595 .43366 m .43784 .44533 L .42679 .4655 L p F P
0 g
s
.775 .705 .785 r
.42679 .4655 m .40206 .4525 L .41595 .43366 L p F P
0 g
s
.596 .537 .759 r
.68309 .48729 m .6542 .50353 L .64372 .48265 L p F P
0 g
s
.588 .518 .743 r
.6542 .50353 m .68309 .48729 L .69512 .50753 L p F P
0 g
s
.588 .518 .743 r
.69512 .50753 m .66391 .5248 L .6542 .50353 L p F P
0 g
s
.814 .674 .709 r
.38176 .57256 m .34522 .55475 L .35473 .53354 L p F P
0 g
s
.82 .666 .692 r
.34522 .55475 m .38176 .57256 L .37507 .59455 L p F P
0 g
s
.579 .498 .728 r
.66391 .5248 m .69512 .50753 L .70618 .52819 L p F P
0 g
s
.579 .498 .728 r
.70618 .52819 m .67283 .54636 L .66391 .5248 L p F P
0 g
s
.605 .556 .773 r
.67014 .46757 m .64372 .48265 L .63253 .46224 L p F P
0 g
s
.596 .537 .759 r
.64372 .48265 m .67014 .46757 L .68309 .48729 L p F P
0 g
s
.742 .695 .807 r
.46161 .40699 m .47944 .41363 L .47068 .4336 L p F P
0 g
s
.742 .695 .807 r
.47068 .4336 m .44946 .42579 L .46161 .40699 L p F P
0 g
s
.57 .478 .711 r
.67283 .54636 m .70618 .52819 L .7162 .54917 L p F P
0 g
s
.57 .478 .711 r
.7162 .54917 m .68091 .56811 L .67283 .54636 L p F P
0 g
s
.665 .628 .803 r
.55893 .41707 m .57784 .41203 L .58755 .43172 L p F P
0 g
s
.647 .62 .808 r
.60821 .42323 m .58755 .43172 L .57784 .41203 L p F P
0 g
s
.642 .602 .794 r
.58755 .43172 m .60821 .42323 L .62068 .4424 L p F P
0 g
s
.613 .575 .788 r
.65634 .44845 m .63253 .46224 L .62068 .4424 L p F P
0 g
s
.605 .556 .773 r
.63253 .46224 m .65634 .44845 L .67014 .46757 L p F P
0 g
s
.579 .421 .632 r
.65533 .64935 m .69968 .63354 L .704 .65507 L p F P
0 g
s
.579 .421 .632 r
.704 .65507 m .65851 .67105 L .65533 .64935 L p F P
0 g
s
.765 .709 .799 r
.43053 .41556 m .44946 .42579 L .43784 .44533 L p F P
0 g
s
.765 .709 .799 r
.43784 .44533 m .41595 .43366 L .43053 .41556 L p F P
0 g
s
.82 .666 .692 r
.37507 .59455 m .33674 .57615 L .34522 .55475 L p F P
0 g
s
.826 .658 .674 r
.33674 .57615 m .37507 .59455 L .36924 .61651 L p F P
0 g
s
.768 .555 .61 r
.45497 .70558 m .40461 .69589 L .40679 .67457 L p F P
0 g
s
.768 .54 .589 r
.40461 .69589 m .45497 .70558 L .45411 .72635 L p F P
0 g
s
.731 .508 .589 r
.5068 .73086 m .45411 .72635 L .45497 .70558 L p F P
0 g
s
.56 .457 .694 r
.68091 .56811 m .7162 .54917 L .72514 .57038 L p F P
0 g
s
.56 .457 .694 r
.72514 .57038 m .6881 .58995 L .68091 .56811 L p F P
0 g
s
.61 .412 .589 r
.61127 .70344 m .66094 .69236 L .66258 .71315 L p F P
0 g
s
.61 .412 .589 r
.66258 .71315 m .6123 .72421 L .61127 .70344 L p F P
0 g
s
.801 .601 .632 r
.40679 .67457 m .36028 .65992 L .3643 .63833 L p F P
0 g
s
.804 .588 .61 r
.36028 .65992 m .40679 .67457 L .40461 .69589 L p F P
0 g
s
.621 .594 .802 r
.64173 .43002 m .62068 .4424 L .60821 .42323 L p F P
0 g
s
.613 .575 .788 r
.62068 .4424 m .64173 .43002 L .65634 .44845 L p F P
0 g
s
.729 .491 .567 r
.45411 .72635 m .5068 .73086 L .50668 .75091 L p F P
0 g
s
.69 .459 .567 r
.5068 .73086 m .55995 .73015 L .56016 .7502 L p F P
0 g
s
.69 .459 .567 r
.56016 .7502 m .50668 .75091 L .5068 .73086 L p F P
0 g
s
.55 .435 .675 r
.6881 .58995 m .72514 .57038 L .73293 .59173 L p F P
0 g
s
.55 .435 .675 r
.73293 .59173 m .69437 .61179 L .6881 .58995 L p F P
0 g
s
.755 .714 .814 r
.44576 .3983 m .46161 .40699 L .44946 .42579 L p F P
0 g
s
.755 .714 .814 r
.44946 .42579 m .43053 .41556 L .44576 .3983 L p F P
0 g
s
.826 .658 .674 r
.36924 .61651 m .32935 .59764 L .33674 .57615 L p F P
0 g
s
.832 .648 .654 r
.32935 .59764 m .36924 .61651 L .3643 .63833 L p F P
0 g
s
.648 .425 .566 r
.55995 .73015 m .6123 .72421 L .61282 .74431 L p F P
0 g
s
.648 .425 .566 r
.61282 .74431 m .56016 .7502 L .55995 .73015 L p F P
0 g
s
.647 .62 .808 r
.57784 .41203 m .59518 .4048 L .60821 .42323 L p F P
0 g
s
.57 .399 .61 r
.65851 .67105 m .704 .65507 L .70729 .6763 L p F P
0 g
s
.57 .399 .61 r
.70729 .6763 m .66094 .69236 L .65851 .67105 L p F P
0 g
s
.629 .613 .816 r
.6264 .41237 m .60821 .42323 L .59518 .4048 L p F P
0 g
s
.621 .594 .802 r
.60821 .42323 m .6264 .41237 L .64173 .43002 L p F P
0 g
s
.813 .724 .767 r
.36549 .45473 m .38894 .47201 L .37664 .49207 L p F P
0 g
s
.813 .724 .767 r
.37664 .49207 m .35093 .47344 L .36549 .45473 L p F P
0 g
s
.823 .72 .751 r
.35093 .47344 m .37664 .49207 L .36522 .51262 L p F P
0 g
s
.802 .727 .781 r
.38099 .43672 m .40206 .4525 L .38894 .47201 L p F P
0 g
s
.802 .727 .781 r
.38894 .47201 m .36549 .45473 L .38099 .43672 L p F P
0 g
s
.823 .72 .751 r
.36522 .51262 m .33739 .49278 L .35093 .47344 L p F P
0 g
s
.833 .716 .735 r
.33739 .49278 m .36522 .51262 L .35473 .53354 L p F P
0 g
s
.791 .73 .795 r
.39736 .41951 m .41595 .43366 L .40206 .4525 L p F P
0 g
s
.791 .73 .795 r
.40206 .4525 m .38099 .43672 L .39736 .41951 L p F P
0 g
s
.768 .54 .589 r
.45411 .72635 m .40314 .71668 L .40461 .69589 L p F P
0 g
s
.768 .524 .565 r
.40314 .71668 m .45411 .72635 L .45367 .74643 L p F P
0 g
s
.729 .491 .567 r
.50668 .75091 m .45367 .74643 L .45411 .72635 L p F P
0 g
s
.539 .412 .655 r
.69437 .61179 m .73293 .59173 L .73955 .6131 L p F P
0 g
s
.539 .412 .655 r
.73955 .6131 m .69968 .63354 L .69437 .61179 L p F P
0 g
s
.804 .588 .61 r
.40461 .69589 m .35723 .68117 L .36028 .65992 L p F P
0 g
s
.806 .574 .587 r
.35723 .68117 m .40461 .69589 L .40314 .71668 L p F P
0 g
s
.833 .716 .735 r
.35473 .53354 m .32494 .51265 L .33739 .49278 L p F P
0 g
s
.842 .71 .718 r
.32494 .51265 m .35473 .53354 L .34522 .55475 L p F P
0 g
s
.779 .732 .809 r
.41452 .40318 m .43053 .41556 L .41595 .43366 L p F P
0 g
s
.779 .732 .809 r
.41595 .43366 m .39736 .41951 L .41452 .40318 L p F P
0 g
s
.832 .648 .654 r
.3643 .63833 m .32308 .61913 L .32935 .59764 L p F P
0 g
s
.837 .637 .633 r
.32308 .61913 m .3643 .63833 L .36028 .65992 L p F P
0 g
s
.575 .546 .785 r
.69236 .44952 m .67014 .46757 L .65634 .44845 L p F P
0 g
s
.563 .524 .77 r
.67014 .46757 m .69236 .44952 L .70747 .46782 L p F P
0 g
s
.563 .524 .77 r
.70747 .46782 m .68309 .48729 L .67014 .46757 L p F P
0 g
s
.602 .389 .564 r
.6123 .72421 m .66258 .71315 L .66342 .73332 L p F P
0 g
s
.602 .389 .564 r
.66342 .73332 m .61282 .74431 L .6123 .72421 L p F P
0 g
s
.551 .502 .755 r
.68309 .48729 m .70747 .46782 L .72154 .48679 L p F P
0 g
s
.551 .502 .755 r
.72154 .48679 m .69512 .50753 L .68309 .48729 L p F P
0 g
s
.587 .567 .799 r
.67628 .43197 m .65634 .44845 L .64173 .43002 L p F P
0 g
s
.575 .546 .785 r
.65634 .44845 m .67628 .43197 L .69236 .44952 L p F P
0 g
s
.629 .613 .816 r
.59518 .4048 m .61041 .39559 L .6264 .41237 L p F P
0 g
s
.538 .48 .738 r
.69512 .50753 m .72154 .48679 L .73448 .50633 L p F P
0 g
s
.538 .48 .738 r
.73448 .50633 m .70618 .52819 L .69512 .50753 L p F P
0 g
s
.598 .588 .812 r
.6593 .41526 m .64173 .43002 L .6264 .41237 L p F P
0 g
s
.587 .567 .799 r
.64173 .43002 m .6593 .41526 L .67628 .43197 L p F P
0 g
s
.842 .71 .718 r
.34522 .55475 m .31363 .53296 L .32494 .51265 L p F P
0 g
s
.851 .704 .7 r
.31363 .53296 m .34522 .55475 L .33674 .57615 L p F P
0 g
s
.766 .733 .823 r
.43239 .3878 m .44576 .3983 L .43053 .41556 L p F P
0 g
s
.766 .733 .823 r
.43053 .41556 m .41452 .40318 L .43239 .3878 L p F P
0 g
s
.727 .472 .541 r
.45367 .74643 m .50668 .75091 L .50668 .77013 L p F P
0 g
s
.685 .438 .542 r
.50668 .75091 m .56016 .7502 L .56016 .76943 L p F P
0 g
s
.685 .438 .542 r
.56016 .76943 m .50668 .77013 L .50668 .75091 L p F P
0 g
s
.559 .374 .587 r
.66094 .69236 m .70729 .6763 L .70952 .69711 L p F P
0 g
s
.559 .374 .587 r
.70952 .69711 m .66258 .71315 L .66094 .69236 L p F P
0 g
s
.642 .402 .541 r
.56016 .7502 m .61282 .74431 L .61284 .76362 L p F P
0 g
s
.642 .402 .541 r
.61284 .76362 m .56016 .76943 L .56016 .7502 L p F P
0 g
s
.525 .456 .721 r
.70618 .52819 m .73448 .50633 L .74623 .52636 L p F P
0 g
s
.525 .456 .721 r
.74623 .52636 m .7162 .54917 L .70618 .52819 L p F P
0 g
s
.526 .387 .634 r
.69968 .63354 m .73955 .6131 L .74492 .6344 L p F P
0 g
s
.526 .387 .634 r
.74492 .6344 m .704 .65507 L .69968 .63354 L p F P
0 g
s
.61 .609 .826 r
.64152 .39946 m .6264 .41237 L .61041 .39559 L p F P
0 g
s
.598 .588 .812 r
.6264 .41237 m .64152 .39946 L .6593 .41526 L p F P
0 g
s
.837 .637 .633 r
.36028 .65992 m .31798 .6405 L .32308 .61913 L p F P
0 g
s
.841 .625 .61 r
.31798 .6405 m .36028 .65992 L .35723 .68117 L p F P
0 g
s
.851 .704 .7 r
.33674 .57615 m .30354 .55361 L .31363 .53296 L p F P
0 g
s
.859 .697 .68 r
.30354 .55361 m .33674 .57615 L .32935 .59764 L p F P
0 g
s
.768 .524 .565 r
.45367 .74643 m .40238 .73683 L .40314 .71668 L p F P
0 g
s
.767 .505 .539 r
.40238 .73683 m .45367 .74643 L .45366 .76571 L p F P
0 g
s
.727 .472 .541 r
.50668 .77013 m .45366 .76571 L .45367 .74643 L p F P
0 g
s
.511 .431 .702 r
.7162 .54917 m .74623 .52636 L .75673 .54679 L p F P
0 g
s
.511 .431 .702 r
.75673 .54679 m .72514 .57038 L .7162 .54917 L p F P
0 g
s
.806 .574 .587 r
.40314 .71668 m .35515 .70198 L .35723 .68117 L p F P
0 g
s
.807 .558 .562 r
.35515 .70198 m .40314 .71668 L .40238 .73683 L p F P
0 g
s
.61 .609 .826 r
.61041 .39559 m .623 .38465 L .64152 .39946 L p F P
0 g
s
.593 .363 .537 r
.61282 .74431 m .66342 .73332 L .66344 .75277 L p F P
0 g
s
.593 .363 .537 r
.66344 .75277 m .61284 .76362 L .61282 .74431 L p F P
0 g
s
.805 .758 .809 r
.38272 .40326 m .39736 .41951 L .38099 .43672 L p F P
0 g
s
.805 .758 .809 r
.38099 .43672 m .36431 .41856 L .38272 .40326 L p F P
0 g
s
.819 .758 .795 r
.36431 .41856 m .38099 .43672 L .36549 .45473 L p F P
0 g
s
.513 .36 .61 r
.704 .65507 m .74492 .6344 L .74902 .65552 L p F P
0 g
s
.513 .36 .61 r
.74902 .65552 m .70729 .6763 L .704 .65507 L p F P
0 g
s
.819 .758 .795 r
.36549 .45473 m .34684 .4348 L .36431 .41856 L p F P
0 g
s
.833 .758 .78 r
.34684 .4348 m .36549 .45473 L .35093 .47344 L p F P
0 g
s
.548 .347 .561 r
.66258 .71315 m .70952 .69711 L .71066 .71739 L p F P
0 g
s
.548 .347 .561 r
.71066 .71739 m .66342 .73332 L .66258 .71315 L p F P
0 g
s
.791 .756 .822 r
.40198 .38898 m .41452 .40318 L .39736 .41951 L p F P
0 g
s
.791 .756 .822 r
.39736 .41951 m .38272 .40326 L .40198 .38898 L p F P
0 g
s
.859 .697 .68 r
.32935 .59764 m .29473 .57451 L .30354 .55361 L p F P
0 g
s
.867 .689 .659 r
.29473 .57451 m .32935 .59764 L .32308 .61913 L p F P
0 g
s
.496 .405 .682 r
.72514 .57038 m .75673 .54679 L .7659 .5675 L p F P
0 g
s
.496 .405 .682 r
.7659 .5675 m .73293 .59173 L .72514 .57038 L p F P
0 g
s
.833 .758 .78 r
.35093 .47344 m .33039 .45191 L .34684 .4348 L p F P
0 g
s
.846 .757 .765 r
.33039 .45191 m .35093 .47344 L .33739 .49278 L p F P
0 g
s
.775 .754 .834 r
.42199 .37579 m .43239 .3878 L .41452 .40318 L p F P
0 g
s
.775 .754 .834 r
.41452 .40318 m .40198 .38898 L .42199 .37579 L p F P
0 g
s
.723 .45 .513 r
.45366 .76571 m .50668 .77013 L .50679 .78842 L p F P
0 g
s
.68 .415 .514 r
.50668 .77013 m .56016 .76943 L .55996 .78773 L p F P
0 g
s
.68 .415 .514 r
.55996 .78773 m .50679 .78842 L .50668 .77013 L p F P
0 g
s
.841 .625 .61 r
.35723 .68117 m .3141 .66165 L .31798 .6405 L p F P
0 g
s
.845 .612 .585 r
.3141 .66165 m .35723 .68117 L .35515 .70198 L p F P
0 g
s
.634 .377 .512 r
.56016 .76943 m .61284 .76362 L .61232 .78203 L p F P
0 g
s
.634 .377 .512 r
.61232 .78203 m .55996 .78773 L .56016 .76943 L p F P
0 g
s
.846 .757 .765 r
.33739 .49278 m .31507 .46982 L .33039 .45191 L p F P
0 g
s
.858 .755 .748 r
.31507 .46982 m .33739 .49278 L .32494 .51265 L p F P
0 g
s
.559 .562 .813 r
.69164 .41324 m .67628 .43197 L .6593 .41526 L p F P
0 g
s
.543 .538 .799 r
.67628 .43197 m .69164 .41324 L .70957 .42896 L p F P
0 g
s
.543 .538 .799 r
.70957 .42896 m .69236 .44952 L .67628 .43197 L p F P
0 g
s
.575 .585 .826 r
.67275 .39851 m .6593 .41526 L .64152 .39946 L p F P
0 g
s
.559 .562 .813 r
.6593 .41526 m .67275 .39851 L .69164 .41324 L p F P
0 g
s
.526 .513 .785 r
.69236 .44952 m .70957 .42896 L .72645 .44559 L p F P
0 g
s
.526 .513 .785 r
.72645 .44559 m .70747 .46782 L .69236 .44952 L p F P
0 g
s
.59 .607 .838 r
.65302 .38484 m .64152 .39946 L .623 .38465 L p F P
0 g
s
.575 .585 .826 r
.64152 .39946 m .65302 .38484 L .67275 .39851 L p F P
0 g
s
.807 .558 .562 r
.40238 .73683 m .35409 .72223 L .35515 .70198 L p F P
0 g
s
.808 .54 .533 r
.35409 .72223 m .40238 .73683 L .40236 .75623 L p F P
0 g
s
.767 .505 .539 r
.45366 .76571 m .40236 .75623 L .40238 .73683 L p F P
0 g
s
.48 .377 .66 r
.73293 .59173 m .7659 .5675 L .77368 .58842 L p F P
0 g
s
.48 .377 .66 r
.77368 .58842 m .73955 .6131 L .73293 .59173 L p F P
0 g
s
.509 .488 .769 r
.70747 .46782 m .72645 .44559 L .7422 .46307 L p F P
0 g
s
.509 .488 .769 r
.7422 .46307 m .72154 .48679 L .70747 .46782 L p F P
0 g
s
.765 .484 .509 r
.40236 .75623 m .45366 .76571 L .45408 .78408 L p F P
0 g
s
.723 .45 .513 r
.50679 .78842 m .45408 .78408 L .45366 .76571 L p F P
0 g
s
.867 .689 .659 r
.32308 .61913 m .28725 .59556 L .29473 .57451 L p F P
0 g
s
.875 .679 .635 r
.28725 .59556 m .32308 .61913 L .31798 .6405 L p F P
0 g
s
.59 .607 .838 r
.623 .38465 m .63252 .37229 L .65302 .38484 L p F P
0 g
s
.858 .755 .748 r
.32494 .51265 m .30094 .48843 L .31507 .46982 L p F P
0 g
s
.87 .752 .73 r
.30094 .48843 m .32494 .51265 L .31363 .53296 L p F P
0 g
s
.499 .33 .584 r
.70729 .6763 m .74902 .65552 L .7518 .67635 L p F P
0 g
s
.499 .33 .584 r
.7518 .67635 m .70952 .69711 L .70729 .6763 L p F P
0 g
s
.582 .334 .507 r
.61284 .76362 m .66344 .75277 L .66262 .77138 L p F P
0 g
s
.582 .334 .507 r
.66262 .77138 m .61232 .78203 L .61284 .76362 L p F P
0 g
s
.491 .461 .752 r
.72154 .48679 m .7422 .46307 L .75672 .4813 L p F P
0 g
s
.491 .461 .752 r
.75672 .4813 m .73448 .50633 L .72154 .48679 L p F P
0 g
s
.535 .318 .531 r
.66342 .73332 m .71066 .71739 L .71068 .73704 L p F P
0 g
s
.535 .318 .531 r
.71068 .73704 m .66344 .75277 L .66342 .73332 L p F P
0 g
s
.87 .752 .73 r
.31363 .53296 m .2881 .50766 L .30094 .48843 L p F P
0 g
s
.882 .748 .71 r
.2881 .50766 m .31363 .53296 L .30354 .55361 L p F P
0 g
s
.845 .612 .585 r
.35515 .70198 m .31146 .68248 L .3141 .66165 L p F P
0 g
s
.849 .596 .556 r
.31146 .68248 m .35515 .70198 L .35409 .72223 L p F P
0 g
s
.462 .346 .635 r
.73955 .6131 m .77368 .58842 L .78001 .60941 L p F P
0 g
s
.462 .346 .635 r
.78001 .60941 m .74492 .6344 L .73955 .6131 L p F P
0 g
s
.471 .433 .733 r
.73448 .50633 m .75672 .4813 L .76992 .5002 L p F P
0 g
s
.471 .433 .733 r
.76992 .5002 m .74623 .52636 L .73448 .50633 L p F P
0 g
s
.718 .425 .48 r
.45408 .78408 m .50679 .78842 L .50703 .80567 L p F P
0 g
s
.673 .388 .482 r
.50679 .78842 m .55996 .78773 L .55955 .805 L p F P
0 g
s
.673 .388 .482 r
.55955 .805 m .50703 .80567 L .50679 .78842 L p F P
0 g
s
.782 .777 .848 r
.41494 .36264 m .42199 .37579 L .40198 .38898 L p F P
0 g
s
.782 .777 .848 r
.40198 .38898 m .39339 .37339 L .41494 .36264 L p F P
0 g
s
.8 .783 .837 r
.39339 .37339 m .40198 .38898 L .38272 .40326 L p F P
0 g
s
.875 .679 .635 r
.31798 .6405 m .28117 .61665 L .28725 .59556 L p F P
0 g
s
.881 .668 .609 r
.28117 .61665 m .31798 .6405 L .3141 .66165 L p F P
0 g
s
.8 .783 .837 r
.38272 .40326 m .3726 .38536 L .39339 .37339 L p F P
0 g
s
.817 .788 .825 r
.3726 .38536 m .38272 .40326 L .36431 .41856 L p F P
0 g
s
.624 .348 .479 r
.55996 .78773 m .61232 .78203 L .61128 .79943 L p F P
0 g
s
.624 .348 .479 r
.61128 .79943 m .55955 .805 L .55996 .78773 L p F P
0 g
s
.817 .788 .825 r
.36431 .41856 m .35268 .39851 L .3726 .38536 L p F P
0 g
s
.834 .792 .812 r
.35268 .39851 m .36431 .41856 L .34684 .4348 L p F P
0 g
s
.882 .748 .71 r
.30354 .55361 m .27663 .52741 L .2881 .50766 L p F P
0 g
s
.893 .743 .688 r
.27663 .52741 m .30354 .55361 L .29473 .57451 L p F P
0 g
s
.482 .298 .554 r
.70952 .69711 m .7518 .67635 L .75323 .69678 L p F P
0 g
s
.482 .298 .554 r
.75323 .69678 m .71066 .71739 L .70952 .69711 L p F P
0 g
s
.808 .54 .533 r
.40236 .75623 m .35406 .74182 L .35409 .72223 L p F P
0 g
s
.807 .519 .501 r
.35406 .74182 m .40236 .75623 L .40309 .77477 L p F P
0 g
s
.765 .484 .509 r
.45408 .78408 m .40309 .77477 L .40236 .75623 L p F P
0 g
s
.451 .402 .713 r
.74623 .52636 m .76992 .5002 L .78173 .51968 L p F P
0 g
s
.451 .402 .713 r
.78173 .51968 m .75673 .54679 L .74623 .52636 L p F P
0 g
s
.57 .608 .852 r
.66045 .36894 m .65302 .38484 L .63252 .37229 L p F P
0 g
s
.549 .584 .842 r
.65302 .38484 m .66045 .36894 L .68155 .38025 L p F P
0 g
s
.549 .584 .842 r
.68155 .38025 m .67275 .39851 L .65302 .38484 L p F P
0 g
s
.57 .608 .852 r
.63252 .37229 m .6386 .35889 L .66045 .36894 L p F P
0 g
s
.834 .792 .812 r
.34684 .4348 m .33372 .41276 L .35268 .39851 L p F P
0 g
s
.85 .796 .798 r
.33372 .41276 m .34684 .4348 L .33039 .45191 L p F P
0 g
s
.528 .559 .83 r
.67275 .39851 m .68155 .38025 L .70179 .39277 L p F P
0 g
s
.528 .559 .83 r
.70179 .39277 m .69164 .41324 L .67275 .39851 L p F P
0 g
s
.761 .459 .474 r
.40309 .77477 m .45408 .78408 L .45496 .80143 L p F P
0 g
s
.718 .425 .48 r
.50703 .80567 m .45496 .80143 L .45408 .78408 L p F P
0 g
s
.506 .532 .817 r
.69164 .41324 m .70179 .39277 L .72105 .40644 L p F P
0 g
s
.506 .532 .817 r
.72105 .40644 m .70957 .42896 L .69164 .41324 L p F P
0 g
s
.442 .313 .608 r
.74492 .6344 m .78001 .60941 L .78484 .63039 L p F P
0 g
s
.442 .313 .608 r
.78484 .63039 m .74902 .65552 L .74492 .6344 L p F P
0 g
s
.85 .796 .798 r
.33039 .45191 m .31584 .42805 L .33372 .41276 L p F P
0 g
s
.867 .799 .782 r
.31584 .42805 m .33039 .45191 L .31507 .46982 L p F P
0 g
s
.52 .284 .497 r
.66344 .75277 m .71068 .73704 L .70957 .75594 L p F P
0 g
s
.52 .284 .497 r
.70957 .75594 m .66262 .77138 L .66344 .75277 L p F P
0 g
s
.568 .302 .472 r
.61232 .78203 m .66262 .77138 L .66095 .78903 L p F P
0 g
s
.568 .302 .472 r
.66095 .78903 m .61128 .79943 L .61232 .78203 L p F P
0 g
s
.849 .596 .556 r
.35409 .72223 m .31011 .70286 L .31146 .68248 L p F P
0 g
s
.851 .577 .524 r
.31011 .70286 m .35409 .72223 L .35406 .74182 L p F P
0 g
s
.881 .668 .609 r
.3141 .66165 m .27653 .63767 L .28117 .61665 L p F P
0 g
s
.888 .654 .58 r
.27653 .63767 m .3141 .66165 L .31146 .68248 L p F P
0 g
s
.483 .504 .803 r
.70957 .42896 m .72105 .40644 L .73924 .4212 L p F P
0 g
s
.483 .504 .803 r
.73924 .4212 m .72645 .44559 L .70957 .42896 L p F P
0 g
s
.893 .743 .688 r
.29473 .57451 m .26659 .54759 L .27663 .52741 L p F P
0 g
s
.904 .737 .663 r
.26659 .54759 m .29473 .57451 L .28725 .59556 L p F P
0 g
s
.428 .37 .69 r
.75673 .54679 m .78173 .51968 L .79206 .53965 L p F P
0 g
s
.428 .37 .69 r
.79206 .53965 m .7659 .5675 L .75673 .54679 L p F P
0 g
s
.867 .799 .782 r
.31507 .46982 m .29914 .44431 L .31584 .42805 L p F P
0 g
s
.882 .801 .764 r
.29914 .44431 m .31507 .46982 L .30094 .48843 L p F P
0 g
s
.786 .799 .864 r
.41154 .34875 m .41494 .36264 L .39339 .37339 L p F P
0 g
s
.459 .474 .787 r
.72645 .44559 m .73924 .4212 L .75623 .43698 L p F P
0 g
s
.459 .474 .787 r
.75623 .43698 m .7422 .46307 L .72645 .44559 L p F P
0 g
s
.463 .261 .52 r
.71066 .71739 m .75323 .69678 L .75326 .71668 L p F P
0 g
s
.463 .261 .52 r
.75326 .71668 m .71068 .73704 L .71066 .71739 L p F P
0 g
s
.711 .395 .442 r
.45496 .80143 m .50703 .80567 L .50738 .82176 L p F P
0 g
s
.663 .357 .444 r
.50703 .80567 m .55955 .805 L .55893 .82111 L p F P
0 g
s
.663 .357 .444 r
.55893 .82111 m .50738 .82176 L .50703 .80567 L p F P
0 g
s
.786 .799 .864 r
.39339 .37339 m .38914 .35688 L .41154 .34875 L p F P
0 g
s
.805 .81 .855 r
.38914 .35688 m .39339 .37339 L .3726 .38536 L p F P
0 g
s
.612 .315 .441 r
.55955 .805 m .61128 .79943 L .60969 .8157 L p F P
0 g
s
.612 .315 .441 r
.60969 .8157 m .55893 .82111 L .55955 .805 L p F P
0 g
s
.42 .276 .577 r
.74902 .65552 m .78484 .63039 L .78812 .65123 L p F P
0 g
s
.42 .276 .577 r
.78812 .65123 m .7518 .67635 L .74902 .65552 L p F P
0 g
s
.807 .519 .501 r
.40309 .77477 m .35509 .76062 L .35406 .74182 L p F P
0 g
s
.805 .494 .463 r
.35509 .76062 m .40309 .77477 L .40459 .79235 L p F P
0 g
s
.761 .459 .474 r
.45496 .80143 m .40459 .79235 L .40309 .77477 L p F P
0 g
s
.549 .612 .868 r
.6386 .35889 m .64096 .34488 L .66346 .35227 L p F P
0 g
s
.549 .612 .868 r
.66346 .35227 m .66045 .36894 L .6386 .35889 L p F P
0 g
s
.882 .801 .764 r
.30094 .48843 m .28371 .46147 L .29914 .44431 L p F P
0 g
s
.898 .801 .744 r
.28371 .46147 m .30094 .48843 L .2881 .50766 L p F P
0 g
s
.404 .334 .665 r
.7659 .5675 m .79206 .53965 L .80084 .56 L p F P
0 g
s
.404 .334 .665 r
.80084 .56 m .77368 .58842 L .7659 .5675 L p F P
0 g
s
.805 .81 .855 r
.3726 .38536 m .36746 .36636 L .38914 .35688 L p F P
0 g
s
.825 .82 .845 r
.36746 .36636 m .3726 .38536 L .35268 .39851 L p F P
0 g
s
.904 .737 .663 r
.28725 .59556 m .25806 .5681 L .26659 .54759 L p F P
0 g
s
.915 .728 .636 r
.25806 .5681 m .28725 .59556 L .28117 .61665 L p F P
0 g
s
.432 .442 .769 r
.7422 .46307 m .75623 .43698 L .77193 .45372 L p F P
0 g
s
.432 .442 .769 r
.77193 .45372 m .75672 .4813 L .7422 .46307 L p F P
0 g
s
.523 .587 .86 r
.66045 .36894 m .66346 .35227 L .68526 .36105 L p F P
0 g
s
.523 .587 .86 r
.68526 .36105 m .68155 .38025 L .66045 .36894 L p F P
0 g
s
.756 .43 .434 r
.40459 .79235 m .45496 .80143 L .45628 .81765 L p F P
0 g
s
.711 .395 .442 r
.50738 .82176 m .45628 .81765 L .45496 .80143 L p F P
0 g
s
.888 .654 .58 r
.31146 .68248 m .27338 .65851 L .27653 .63767 L p F P
0 g
s
.893 .638 .546 r
.27338 .65851 m .31146 .68248 L .31011 .70286 L p F P
0 g
s
.851 .577 .524 r
.35406 .74182 m .31008 .72269 L .31011 .70286 L p F P
0 g
s
.852 .555 .486 r
.31008 .72269 m .35406 .74182 L .35509 .76062 L p F P
0 g
s
.501 .245 .458 r
.66262 .77138 m .70957 .75594 L .70731 .77397 L p F P
0 g
s
.501 .245 .458 r
.70731 .77397 m .66095 .78903 L .66262 .77138 L p F P
0 g
s
.825 .82 .845 r
.35268 .39851 m .34663 .37716 L .36746 .36636 L p F P
0 g
s
.845 .83 .833 r
.34663 .37716 m .35268 .39851 L .33372 .41276 L p F P
0 g
s
.552 .264 .431 r
.61128 .79943 m .66095 .78903 L .65842 .80562 L p F P
0 g
s
.552 .264 .431 r
.65842 .80562 m .60969 .8157 L .61128 .79943 L p F P
0 g
s
.495 .559 .85 r
.68155 .38025 m .68526 .36105 L .70622 .37118 L p F P
0 g
s
.495 .559 .85 r
.70622 .37118 m .70179 .39277 L .68155 .38025 L p F P
0 g
s
.898 .801 .744 r
.2881 .50766 m .26967 .47945 L .28371 .46147 L p F P
0 g
s
.913 .8 .722 r
.26967 .47945 m .2881 .50766 L .27663 .52741 L p F P
0 g
s
.404 .407 .749 r
.75672 .4813 m .77193 .45372 L .78624 .47133 L p F P
0 g
s
.404 .407 .749 r
.78624 .47133 m .76992 .5002 L .75672 .4813 L p F P
0 g
s
.377 .295 .636 r
.77368 .58842 m .80084 .56 L .80799 .58062 L p F P
0 g
s
.377 .295 .636 r
.80799 .58062 m .78001 .60941 L .77368 .58842 L p F P
0 g
s
.845 .83 .833 r
.33372 .41276 m .32677 .38923 L .34663 .37716 L p F P
0 g
s
.864 .838 .819 r
.32677 .38923 m .33372 .41276 L .31584 .42805 L p F P
0 g
s
.441 .22 .481 r
.71068 .73704 m .75326 .71668 L .75188 .73596 L p F P
0 g
s
.441 .22 .481 r
.75188 .73596 m .70957 .75594 L .71068 .73704 L p F P
0 g
s
.785 .822 .882 r
.41199 .33457 m .41154 .34875 L .38914 .35688 L p F P
0 g
s
.915 .728 .636 r
.28117 .61665 m .25112 .58884 L .25806 .5681 L p F P
0 g
s
.924 .717 .605 r
.25112 .58884 m .28117 .61665 L .27653 .63767 L p F P
0 g
s
.465 .529 .839 r
.70179 .39277 m .70622 .37118 L .72623 .38263 L p F P
0 g
s
.465 .529 .839 r
.72623 .38263 m .72105 .40644 L .70179 .39277 L p F P
0 g
s
.396 .234 .542 r
.7518 .67635 m .78812 .65123 L .7898 .67183 L p F P
0 g
s
.396 .234 .542 r
.7898 .67183 m .75323 .69678 L .7518 .67635 L p F P
0 g
s
.701 .361 .397 r
.45628 .81765 m .50738 .82176 L .50786 .83659 L p F P
0 g
s
.651 .321 .4 r
.50738 .82176 m .55893 .82111 L .55809 .83596 L p F P
0 g
s
.651 .321 .4 r
.55809 .83596 m .50786 .83659 L .50738 .82176 L p F P
0 g
s
.529 .62 .887 r
.64096 .34488 m .63944 .33071 L .66184 .33536 L p F P
0 g
s
.529 .62 .887 r
.66184 .33536 m .66346 .35227 L .64096 .34488 L p F P
0 g
s
.913 .8 .722 r
.27663 .52741 m .25709 .49816 L .26967 .47945 L p F P
0 g
s
.928 .798 .696 r
.25709 .49816 m .27663 .52741 L .26659 .54759 L p F P
0 g
s
.785 .822 .882 r
.38914 .35688 m .38948 .33998 L .41199 .33457 L p F P
0 g
s
.806 .838 .875 r
.38948 .33998 m .38914 .35688 L .36746 .36636 L p F P
0 g
s
.597 .275 .395 r
.55893 .82111 m .60969 .8157 L .60755 .83075 L p F P
0 g
s
.597 .275 .395 r
.60755 .83075 m .55809 .83596 L .55893 .82111 L p F P
0 g
s
.805 .494 .463 r
.40459 .79235 m .3572 .77854 L .35509 .76062 L p F P
0 g
s
.801 .464 .418 r
.3572 .77854 m .40459 .79235 L .40687 .80883 L p F P
0 g
s
.756 .43 .434 r
.45628 .81765 m .40687 .80883 L .40459 .79235 L p F P
0 g
s
.373 .369 .725 r
.76992 .5002 m .78624 .47133 L .79906 .48972 L p F P
0 g
s
.373 .369 .725 r
.79906 .48972 m .78173 .51968 L .76992 .5002 L p F P
0 g
s
.893 .638 .546 r
.31011 .70286 m .27176 .67906 L .27338 .65851 L p F P
0 g
s
.897 .618 .507 r
.27176 .67906 m .31011 .70286 L .31008 .72269 L p F P
0 g
s
.864 .838 .819 r
.31584 .42805 m .30798 .40252 L .32677 .38923 L p F P
0 g
s
.883 .846 .802 r
.30798 .40252 m .31584 .42805 L .29914 .44431 L p F P
0 g
s
.433 .497 .825 r
.72105 .40644 m .72623 .38263 L .74516 .39535 L p F P
0 g
s
.433 .497 .825 r
.74516 .39535 m .73924 .4212 L .72105 .40644 L p F P
0 g
s
.852 .555 .486 r
.35509 .76062 m .31139 .74186 L .31008 .72269 L p F P
0 g
s
.85 .529 .443 r
.31139 .74186 m .35509 .76062 L .3572 .77854 L p F P
0 g
s
.347 .252 .602 r
.78001 .60941 m .80799 .58062 L .81345 .60142 L p F P
0 g
s
.347 .252 .602 r
.81345 .60142 m .78484 .63039 L .78001 .60941 L p F P
0 g
s
.479 .2 .412 r
.66095 .78903 m .70731 .77397 L .70387 .79101 L p F P
0 g
s
.479 .2 .412 r
.70387 .79101 m .65842 .80562 L .66095 .78903 L p F P
0 g
s
.496 .593 .881 r
.66346 .35227 m .66184 .33536 L .6836 .34152 L p F P
0 g
s
.496 .593 .881 r
.6836 .34152 m .68526 .36105 L .66346 .35227 L p F P
0 g
s
.747 .396 .387 r
.40687 .80883 m .45628 .81765 L .45806 .83262 L p F P
0 g
s
.701 .361 .397 r
.50786 .83659 m .45806 .83262 L .45628 .81765 L p F P
0 g
s
.806 .838 .875 r
.36746 .36636 m .36763 .34685 L .38948 .33998 L p F P
0 g
s
.827 .854 .867 r
.36763 .34685 m .36746 .36636 L .34663 .37716 L p F P
0 g
s
.924 .717 .605 r
.27653 .63767 m .24582 .60969 L .25112 .58884 L p F P
0 g
s
.933 .704 .569 r
.24582 .60969 m .27653 .63767 L .27338 .65851 L p F P
0 g
s
.883 .846 .802 r
.29914 .44431 m .29039 .41697 L .30798 .40252 L p F P
0 g
s
.903 .852 .783 r
.29039 .41697 m .29914 .44431 L .28371 .46147 L p F P
0 g
s
.532 .219 .382 r
.60969 .8157 m .65842 .80562 L .65501 .82102 L p F P
0 g
s
.532 .219 .382 r
.65501 .82102 m .60755 .83075 L .60969 .8157 L p F P
0 g
s
.398 .461 .809 r
.73924 .4212 m .74516 .39535 L .76289 .40928 L p F P
0 g
s
.398 .461 .809 r
.76289 .40928 m .75623 .43698 L .73924 .4212 L p F P
0 g
s
.367 .188 .501 r
.75323 .69678 m .7898 .67183 L .78984 .69205 L p F P
0 g
s
.367 .188 .501 r
.78984 .69205 m .75326 .71668 L .75323 .69678 L p F P
0 g
s
.928 .798 .696 r
.26659 .54759 m .24608 .5175 L .25709 .49816 L p F P
0 g
s
.942 .793 .667 r
.24608 .5175 m .26659 .54759 L .25806 .5681 L p F P
0 g
s
.339 .326 .698 r
.78173 .51968 m .79906 .48972 L .81029 .50882 L p F P
0 g
s
.339 .326 .698 r
.81029 .50882 m .79206 .53965 L .78173 .51968 L p F P
0 g
s
.415 .172 .435 r
.70957 .75594 m .75188 .73596 L .74905 .75447 L p F P
0 g
s
.415 .172 .435 r
.74905 .75447 m .70731 .77397 L .70957 .75594 L p F P
0 g
s
.778 .843 .901 r
.41636 .32059 m .41199 .33457 L .38948 .33998 L p F P
0 g
s
.459 .563 .874 r
.68526 .36105 m .6836 .34152 L .70459 .34917 L p F P
0 g
s
.459 .563 .874 r
.70459 .34917 m .70622 .37118 L .68526 .36105 L p F P
0 g
s
.827 .854 .867 r
.34663 .37716 m .34658 .35519 L .36763 .34685 L p F P
0 g
s
.849 .869 .856 r
.34658 .35519 m .34663 .37716 L .32677 .38923 L p F P
0 g
s
.897 .618 .507 r
.31008 .72269 m .27172 .69919 L .27176 .67906 L p F P
0 g
s
.898 .594 .462 r
.27172 .69919 m .31008 .72269 L .31139 .74186 L p F P
0 g
s
.51 .632 .907 r
.63944 .33071 m .634 .31686 L .65552 .3188 L p F P
0 g
s
.51 .632 .907 r
.65552 .3188 m .66184 .33536 L .63944 .33071 L p F P
0 g
s
.903 .852 .783 r
.28371 .46147 m .27411 .43252 L .29039 .41697 L p F P
0 g
s
.922 .857 .761 r
.27411 .43252 m .28371 .46147 L .26967 .47945 L p F P
0 g
s
.313 .203 .564 r
.78484 .63039 m .81345 .60142 L .81715 .62226 L p F P
0 g
s
.313 .203 .564 r
.81715 .62226 m .78812 .65123 L .78484 .63039 L p F P
0 g
s
.359 .421 .789 r
.75623 .43698 m .76289 .40928 L .77931 .42437 L p F P
0 g
s
.359 .421 .789 r
.77931 .42437 m .77193 .45372 L .75623 .43698 L p F P
0 g
s
.801 .464 .418 r
.40687 .80883 m .36039 .79544 L .3572 .77854 L p F P
0 g
s
.793 .427 .365 r
.36039 .79544 m .40687 .80883 L .40993 .82412 L p F P
0 g
s
.747 .396 .387 r
.45806 .83262 m .40993 .82412 L .40687 .80883 L p F P
0 g
s
.687 .318 .343 r
.45806 .83262 m .50786 .83659 L .50845 .85003 L p F P
0 g
s
.635 .277 .347 r
.50786 .83659 m .55809 .83596 L .55704 .84943 L p F P
0 g
s
.635 .277 .347 r
.55704 .84943 m .50845 .85003 L .50786 .83659 L p F P
0 g
s
.778 .843 .901 r
.38948 .33998 m .39452 .32326 L .41636 .32059 L p F P
0 g
s
.799 .865 .898 r
.39452 .32326 m .38948 .33998 L .36763 .34685 L p F P
0 g
s
.301 .279 .667 r
.79206 .53965 m .81029 .50882 L .81984 .52851 L p F P
0 g
s
.301 .279 .667 r
.81984 .52851 m .80084 .56 L .79206 .53965 L p F P
0 g
s
.933 .704 .569 r
.27338 .65851 m .24222 .63054 L .24582 .60969 L p F P
0 g
s
.939 .686 .527 r
.24222 .63054 m .27338 .65851 L .27176 .67906 L p F P
0 g
s
.577 .228 .34 r
.55809 .83596 m .60755 .83075 L .60486 .84443 L p F P
0 g
s
.577 .228 .34 r
.60486 .84443 m .55704 .84943 L .55809 .83596 L p F P
0 g
s
.942 .793 .667 r
.25806 .5681 m .23671 .53738 L .24608 .5175 L p F P
0 g
s
.955 .786 .633 r
.23671 .53738 m .25806 .5681 L .25112 .58884 L p F P
0 g
s
.418 .53 .863 r
.70622 .37118 m .70459 .34917 L .72467 .35829 L p F P
0 g
s
.418 .53 .863 r
.72467 .35829 m .72623 .38263 L .70622 .37118 L p F P
0 g
s
.85 .529 .443 r
.3572 .77854 m .31406 .76023 L .31139 .74186 L p F P
0 g
s
.846 .496 .391 r
.31406 .76023 m .3572 .77854 L .36039 .79544 L p F P
0 g
s
.849 .869 .856 r
.32677 .38923 m .32645 .36495 L .34658 .35519 L p F P
0 g
s
.87 .884 .843 r
.32645 .36495 m .32677 .38923 L .30798 .40252 L p F P
0 g
s
.452 .148 .357 r
.65842 .80562 m .70387 .79101 L .69925 .80694 L p F P
0 g
s
.452 .148 .357 r
.69925 .80694 m .65501 .82102 L .65842 .80562 L p F P
0 g
s
.334 .134 .453 r
.75326 .71668 m .78984 .69205 L .78821 .71179 L p F P
0 g
s
.334 .134 .453 r
.78821 .71179 m .75188 .73596 L .75326 .71668 L p F P
0 g
s
.468 .605 .904 r
.66184 .33536 m .65552 .3188 L .67647 .32234 L p F P
0 g
s
.468 .605 .904 r
.67647 .32234 m .6836 .34152 L .66184 .33536 L p F P
0 g
s
.734 .353 .329 r
.40993 .82412 m .45806 .83262 L .4603 .84623 L p F P
0 g
s
.687 .318 .343 r
.50845 .85003 m .4603 .84623 L .45806 .83262 L p F P
0 g
s
.317 .376 .765 r
.77193 .45372 m .77931 .42437 L .79431 .44054 L p F P
0 g
s
.317 .376 .765 r
.79431 .44054 m .78624 .47133 L .77193 .45372 L p F P
0 g
s
.922 .857 .761 r
.26967 .47945 m .25926 .4491 L .27411 .43252 L p F P
0 g
s
.94 .86 .734 r
.25926 .4491 m .26967 .47945 L .25709 .49816 L p F P
0 g
s
.764 .861 .921 r
.42458 .3073 m .41636 .32059 L .39452 .32326 L p F P
0 g
s
.383 .117 .381 r
.70731 .77397 m .74905 .75447 L .74477 .77211 L p F P
0 g
s
.383 .117 .381 r
.74477 .77211 m .70387 .79101 L .70731 .77397 L p F P
0 g
s
.507 .165 .323 r
.60755 .83075 m .65501 .82102 L .65073 .83512 L p F P
0 g
s
.507 .165 .323 r
.65073 .83512 m .60486 .84443 L .60755 .83075 L p F P
0 g
s
.799 .865 .898 r
.36763 .34685 m .37327 .32751 L .39452 .32326 L p F P
0 g
s
.82 .887 .892 r
.37327 .32751 m .36763 .34685 L .34658 .35519 L p F P
0 g
s
.373 .491 .85 r
.72623 .38263 m .72467 .35829 L .74372 .36885 L p F P
0 g
s
.373 .491 .85 r
.74372 .36885 m .74516 .39535 L .72623 .38263 L p F P
0 g
s
.275 .147 .519 r
.78812 .65123 m .81715 .62226 L .81905 .64304 L p F P
0 g
s
.275 .147 .519 r
.81905 .64304 m .7898 .67183 L .78812 .65123 L p F P
0 g
s
.259 .226 .63 r
.80084 .56 m .81984 .52851 L .82763 .54869 L p F P
0 g
s
.259 .226 .63 r
.82763 .54869 m .80799 .58062 L .80084 .56 L p F P
0 g
s
.87 .884 .843 r
.30798 .40252 m .30736 .37611 L .32645 .36495 L p F P
0 g
s
.892 .897 .826 r
.30736 .37611 m .30798 .40252 L .29039 .41697 L p F P
0 g
s
.493 .648 .927 r
.634 .31686 m .62476 .30385 L .64459 .30318 L p F P
0 g
s
.493 .648 .927 r
.64459 .30318 m .65552 .3188 L .634 .31686 L p F P
0 g
s
.898 .594 .462 r
.31139 .74186 m .27329 .71879 L .27172 .69919 L p F P
0 g
s
.897 .564 .409 r
.27329 .71879 m .31139 .74186 L .31406 .76023 L p F P
0 g
s
.955 .786 .633 r
.25112 .58884 m .22907 .55769 L .23671 .53738 L p F P
0 g
s
.967 .775 .593 r
.22907 .55769 m .25112 .58884 L .24582 .60969 L p F P
0 g
s
.939 .686 .527 r
.27176 .67906 m .24037 .65126 L .24222 .63054 L p F P
0 g
s
.944 .664 .478 r
.24037 .65126 m .27176 .67906 L .27172 .69919 L p F P
0 g
s
.42 .572 .899 r
.6836 .34152 m .67647 .32234 L .69673 .32749 L p F P
0 g
s
.42 .572 .899 r
.69673 .32749 m .70459 .34917 L .6836 .34152 L p F P
0 g
s
.269 .326 .737 r
.78624 .47133 m .79431 .44054 L .80776 .45773 L p F P
0 g
s
.269 .326 .737 r
.80776 .45773 m .79906 .48972 L .78624 .47133 L p F P
0 g
s
.94 .86 .734 r
.25709 .49816 m .24594 .46663 L .25926 .4491 L p F P
0 g
s
.958 .861 .702 r
.24594 .46663 m .25709 .49816 L .24608 .5175 L p F P
0 g
s
.793 .427 .365 r
.40993 .82412 m .36468 .81121 L .36039 .79544 L p F P
0 g
s
.78 .382 .301 r
.36468 .81121 m .40993 .82412 L .41378 .83809 L p F P
0 g
s
.734 .353 .329 r
.4603 .84623 m .41378 .83809 L .40993 .82412 L p F P
0 g
s
.764 .861 .921 r
.39452 .32326 m .40421 .30732 L .42458 .3073 L p F P
0 g
s
.782 .889 .921 r
.40421 .30732 m .39452 .32326 L .37327 .32751 L p F P
0 g
s
.846 .496 .391 r
.36039 .79544 m .31812 .77769 L .31406 .76023 L p F P
0 g
s
.837 .456 .329 r
.31812 .77769 m .36039 .79544 L .36468 .81121 L p F P
0 g
s
.82 .887 .892 r
.34658 .35519 m .35273 .33334 L .37327 .32751 L p F P
0 g
s
.841 .909 .882 r
.35273 .33334 m .34658 .35519 L .32645 .36495 L p F P
0 g
s
.322 .447 .832 r
.74516 .39535 m .74372 .36885 L .76161 .38082 L p F P
0 g
s
.322 .447 .832 r
.76161 .38082 m .76289 .40928 L .74516 .39535 L p F P
0 g
s
.295 .072 .396 r
.75188 .73596 m .78821 .71179 L .78488 .7309 L p F P
0 g
s
.295 .072 .396 r
.78488 .7309 m .74905 .75447 L .75188 .73596 L p F P
0 g
s
.667 .266 .276 r
.4603 .84623 m .50845 .85003 L .50918 .86197 L p F P
0 g
s
.613 .223 .281 r
.50845 .85003 m .55704 .84943 L .55577 .8614 L p F P
0 g
s
.613 .223 .281 r
.55577 .8614 m .50918 .86197 L .50845 .85003 L p F P
0 g
s
.892 .897 .826 r
.29039 .41697 m .28945 .38862 L .30736 .37611 L p F P
0 g
s
.913 .909 .804 r
.28945 .38862 m .29039 .41697 L .27411 .43252 L p F P
0 g
s
.55 .169 .273 r
.55704 .84943 m .60486 .84443 L .60162 .85665 L p F P
0 g
s
.55 .169 .273 r
.60162 .85665 m .55577 .8614 L .55704 .84943 L p F P
0 g
s
.742 .875 .941 r
.43643 .29519 m .42458 .3073 L .40421 .30732 L p F P
0 g
s
.211 .166 .587 r
.80799 .58062 m .82763 .54869 L .83359 .56926 L p F P
0 g
s
.211 .166 .587 r
.83359 .56926 m .81345 .60142 L .80799 .58062 L p F P
0 g
s
.418 .084 .29 r
.65501 .82102 m .69925 .80694 L .69345 .82165 L p F P
0 g
s
.418 .084 .29 r
.69345 .82165 m .65073 .83512 L .65501 .82102 L p F P
0 g
s
.441 .621 .928 r
.65552 .3188 m .64459 .30318 L .66395 .3042 L p F P
0 g
s
.441 .621 .928 r
.66395 .3042 m .67647 .32234 L .65552 .3188 L p F P
0 g
s
.23 .084 .466 r
.7898 .67183 m .81905 .64304 L .8191 .66363 L p F P
0 g
s
.23 .084 .466 r
.8191 .66363 m .78984 .69205 L .7898 .67183 L p F P
0 g
s
.967 .775 .593 r
.24582 .60969 m .22324 .57833 L .22907 .55769 L p F P
0 g
s
.976 .76 .545 r
.22324 .57833 m .24582 .60969 L .24222 .63054 L p F P
0 g
s
.345 .051 .315 r
.70387 .79101 m .74477 .77211 L .73901 .78874 L p F P
0 g
s
.345 .051 .315 r
.73901 .78874 m .69925 .80694 L .70387 .79101 L p F P
0 g
s
.479 .669 .947 r
.62476 .30385 m .61197 .29215 L .62935 .28911 L p F P
0 g
s
.479 .669 .947 r
.62935 .28911 m .64459 .30318 L .62476 .30385 L p F P
0 g
s
.365 .534 .89 r
.70459 .34917 m .69673 .32749 L .71618 .33425 L p F P
0 g
s
.365 .534 .89 r
.71618 .33425 m .72467 .35829 L .70459 .34917 L p F P
0 g
s
.715 .299 .257 r
.41378 .83809 m .4603 .84623 L .46301 .85836 L p F P
0 g
s
.667 .266 .276 r
.50918 .86197 m .46301 .85836 L .4603 .84623 L p F P
0 g
s
.215 .268 .703 r
.79906 .48972 m .80776 .45773 L .81957 .47584 L p F P
0 g
s
.215 .268 .703 r
.81957 .47584 m .81029 .50882 L .79906 .48972 L p F P
0 g
s
.958 .861 .702 r
.24608 .5175 m .23425 .48502 L .24594 .46663 L p F P
0 g
s
.974 .858 .664 r
.23425 .48502 m .24608 .5175 L .23671 .53738 L p F P
0 g
s
.897 .564 .409 r
.31406 .76023 m .27649 .73773 L .27329 .71879 L p F P
0 g
s
.891 .527 .345 r
.27649 .73773 m .31406 .76023 L .31812 .77769 L p F P
0 g
s
.944 .664 .478 r
.27172 .69919 m .24033 .67175 L .24037 .65126 L p F P
0 g
s
.945 .635 .419 r
.24033 .67175 m .27172 .69919 L .27329 .71879 L p F P
0 g
s
.473 .1 .249 r
.60486 .84443 m .65073 .83512 L .64557 .8478 L p F P
0 g
s
.473 .1 .249 r
.64557 .8478 m .60162 .85665 L .60486 .84443 L p F P
0 g
s
.264 .396 .809 r
.76289 .40928 m .76161 .38082 L .77822 .39415 L p F P
0 g
s
.264 .396 .809 r
.77822 .39415 m .77931 .42437 L .76289 .40928 L p F P
0 g
s
.841 .909 .882 r
.32645 .36495 m .33303 .34074 L .35273 .33334 L p F P
0 g
s
.862 .929 .868 r
.33303 .34074 m .32645 .36495 L .30736 .37611 L p F P
0 g
s
.782 .889 .921 r
.37327 .32751 m .38433 .30902 L .40421 .30732 L p F P
0 g
s
.8 .916 .917 r
.38433 .30902 m .37327 .32751 L .35273 .33334 L p F P
0 g
s
.913 .909 .804 r
.27411 .43252 m .27284 .40244 L .28945 .38862 L p F P
0 g
s
.933 .919 .776 r
.27284 .40244 m .27411 .43252 L .25926 .4491 L p F P
0 g
s
.711 .881 .96 r
.45155 .28473 m .43643 .29519 L .4183 .29277 L p F P
0 g
s
.742 .875 .941 r
.40421 .30732 m .4183 .29277 L .43643 .29519 L p F P
0 g
s
.156 .098 .535 r
.81345 .60142 m .83359 .56926 L .83763 .5901 L p F P
0 g
s
.156 .098 .535 r
.83763 .5901 m .81715 .62226 L .81345 .60142 L p F P
0 g
s
.248 0 .327 r
.74905 .75447 m .78488 .7309 L .77983 .74927 L p F P
0 g
s
.248 0 .327 r
.77983 .74927 m .74477 .77211 L .74905 .75447 L p F P
0 g
s
.753 .906 .944 r
.4183 .29277 m .40421 .30732 L .38433 .30902 L p F P
0 g
s
.38 .586 .924 r
.67647 .32234 m .66395 .3042 L .68273 .30694 L p F P
0 g
s
.38 .586 .924 r
.68273 .30694 m .69673 .32749 L .67647 .32234 L p F P
0 g
s
.302 .488 .875 r
.72467 .35829 m .71618 .33425 L .73467 .34262 L p F P
0 g
s
.302 .488 .875 r
.73467 .34262 m .74372 .36885 L .72467 .35829 L p F P
0 g
s
.976 .76 .545 r
.24222 .63054 m .21927 .59917 L .22324 .57833 L p F P
0 g
s
.982 .739 .489 r
.21927 .59917 m .24222 .63054 L .24037 .65126 L p F P
0 g
s
.837 .456 .329 r
.36468 .81121 m .32357 .79411 L .31812 .77769 L p F P
0 g
s
.822 .405 .252 r
.32357 .79411 m .36468 .81121 L .37008 .82574 L p F P
0 g
s
.78 .382 .301 r
.41378 .83809 m .37008 .82574 L .36468 .81121 L p F P
0 g
s
.178 .01 .402 r
.78984 .69205 m .8191 .66363 L .81725 .6839 L p F P
0 g
s
.178 .01 .402 r
.81725 .6839 m .78821 .71179 L .78984 .69205 L p F P
0 g
s
.154 .202 .661 r
.81029 .50882 m .81957 .47584 L .82963 .49479 L p F P
0 g
s
.154 .202 .661 r
.82963 .49479 m .81984 .52851 L .81029 .50882 L p F P
0 g
s
.472 .694 .964 r
.61197 .29215 m .59603 .28221 L .61028 .27713 L p F P
0 g
s
.472 .694 .964 r
.61028 .27713 m .62935 .28911 L .61197 .29215 L p F P
0 g
s
.759 .325 .22 r
.37008 .82574 m .41378 .83809 L .41842 .85062 L p F P
0 g
s
.715 .299 .257 r
.46301 .85836 m .41842 .85062 L .41378 .83809 L p F P
0 g
s
.974 .858 .664 r
.23671 .53738 m .2243 .50418 L .23425 .48502 L p F P
0 g
s
.987 .851 .618 r
.2243 .50418 m .23671 .53738 L .22907 .55769 L p F P
0 g
s
.417 .643 .95 r
.64459 .30318 m .62935 .28911 L .64637 .28781 L p F P
0 g
s
.417 .643 .95 r
.64637 .28781 m .66395 .3042 L .64459 .30318 L p F P
0 g
s
.198 .337 .779 r
.77931 .42437 m .77822 .39415 L .79341 .40879 L p F P
0 g
s
.198 .337 .779 r
.79341 .40879 m .79431 .44054 L .77931 .42437 L p F P
0 g
s
.862 .929 .868 r
.30736 .37611 m .31432 .34971 L .33303 .34074 L p F P
0 g
s
.882 .949 .848 r
.31432 .34971 m .30736 .37611 L .28945 .38862 L p F P
0 g
s
.637 .199 .192 r
.46301 .85836 m .50918 .86197 L .51002 .8723 L p F P
0 g
s
.581 .155 .198 r
.50918 .86197 m .55577 .8614 L .55429 .87176 L p F P
0 g
s
.581 .155 .198 r
.55429 .87176 m .51002 .8723 L .50918 .86197 L p F P
0 g
s
.933 .919 .776 r
.25926 .4491 m .25765 .41751 L .27284 .40244 L p F P
0 g
s
.952 .925 .741 r
.25765 .41751 m .25926 .4491 L .24594 .46663 L p F P
0 g
s
.513 .096 .187 r
.55577 .8614 m .60162 .85665 L .59783 .86728 L p F P
0 g
s
.513 .096 .187 r
.59783 .86728 m .55429 .87176 L .55577 .8614 L p F P
0 g
s
.374 .006 .206 r
.65073 .83512 m .69345 .82165 L .68646 .83501 L p F P
0 g
s
.374 .006 .206 r
.68646 .83501 m .64557 .8478 L .65073 .83512 L p F P
0 g
s
.8 .916 .917 r
.35273 .33334 m .36507 .3124 L .38433 .30902 L p F P
0 g
s
.817 .943 .908 r
.36507 .3124 m .35273 .33334 L .33303 .34074 L p F P
0 g
s
.945 .635 .419 r
.27329 .71879 m .24212 .69186 L .24033 .67175 L p F P
0 g
s
.94 .598 .349 r
.24212 .69186 m .27329 .71879 L .27649 .73773 L p F P
0 g
s
.297 0 .234 r
.69925 .80694 m .73901 .78874 L .73179 .80425 L p F P
0 g
s
.297 0 .234 r
.73179 .80425 m .69345 .82165 L .69925 .80694 L p F P
0 g
s
.891 .527 .345 r
.31812 .77769 m .28133 .75588 L .27649 .73773 L p F P
0 g
s
.878 .478 .266 r
.28133 .75588 m .31812 .77769 L .32357 .79411 L p F P
0 g
s
.673 .878 .975 r
.46944 .27633 m .45155 .28473 L .43639 .28017 L p F P
0 g
s
.711 .881 .96 r
.4183 .29277 m .43639 .28017 L .45155 .28473 L p F P
0 g
s
.686 .231 .167 r
.41842 .85062 m .46301 .85836 L .46617 .8689 L p F P
0 g
s
.637 .199 .192 r
.51002 .8723 m .46617 .8689 L .46301 .85836 L p F P
0 g
s
.092 .019 .472 r
.81715 .62226 m .83763 .5901 L .83971 .61108 L p F P
0 g
s
.092 .019 .472 r
.83971 .61108 m .81905 .64304 L .81715 .62226 L p F P
0 g
s
.473 .722 .979 r
.59603 .28221 m .5775 .27444 L .58802 .26774 L p F P
0 g
s
.473 .722 .979 r
.58802 .26774 m .61028 .27713 L .59603 .28221 L p F P
0 g
s
.227 .432 .853 r
.74372 .36885 m .73467 .34262 L .75207 .35258 L p F P
0 g
s
.227 .432 .853 r
.75207 .35258 m .76161 .38082 L .74372 .36885 L p F P
0 g
s
.306 .543 .914 r
.69673 .32749 m .68273 .30694 L .70079 .31141 L p F P
0 g
s
.306 .543 .914 r
.70079 .31141 m .71618 .33425 L .69673 .32749 L p F P
0 g
s
.428 .018 .157 r
.60162 .85665 m .64557 .8478 L .63954 .85895 L p F P
0 g
s
.428 .018 .157 r
.63954 .85895 m .59783 .86728 L .60162 .85665 L p F P
0 g
s
.084 .127 .609 r
.81984 .52851 m .82963 .49479 L .83784 .51446 L p F P
0 g
s
.084 .127 .609 r
.83784 .51446 m .82763 .54869 L .81984 .52851 L p F P
0 g
s
.753 .906 .944 r
.38433 .30902 m .40057 .29208 L .4183 .29277 L p F P
0 g
s
.763 .936 .941 r
.40057 .29208 m .38433 .30902 L .36507 .3124 L p F P
0 g
s
.982 .739 .489 r
.24037 .65126 m .21724 .62009 L .21927 .59917 L p F P
0 g
s
.983 .709 .42 r
.21724 .62009 m .24037 .65126 L .24033 .67175 L p F P
0 g
s
.987 .851 .618 r
.22907 .55769 m .21618 .524 L .2243 .50418 L p F P
0 g
s
.997 .837 .561 r
.21618 .524 m .22907 .55769 L .22324 .57833 L p F P
0 g
s
.712 .913 .964 r
.43639 .28017 m .4183 .29277 L .40057 .29208 L p F P
0 g
s
.122 .267 .74 r
.79431 .44054 m .79341 .40879 L .80706 .42467 L p F P
0 g
s
.122 .267 .74 r
.80706 .42467 m .80776 .45773 L .79431 .44054 L p F P
0 g
s
.191 0 .242 r
.74477 .77211 m .77983 .74927 L .77305 .76676 L p F P
0 g
s
.191 0 .242 r
.77305 .76676 m .73901 .78874 L .74477 .77211 L p F P
0 g
s
.116 0 .325 r
.78821 .71179 m .81725 .6839 L .81349 .70372 L p F P
0 g
s
.116 0 .325 r
.81349 .70372 m .78488 .7309 L .78821 .71179 L p F P
0 g
s
.882 .949 .848 r
.28945 .38862 m .29671 .36022 L .31432 .34971 L p F P
0 g
s
.9 .965 .82 r
.29671 .36022 m .28945 .38862 L .27284 .40244 L p F P
0 g
s
.952 .925 .741 r
.24594 .46663 m .244 .43375 L .25765 .41751 L p F P
0 g
s
.967 .927 .697 r
.244 .43375 m .24594 .46663 L .23425 .48502 L p F P
0 g
s
.673 .878 .975 r
.43639 .28017 m .45785 .27003 L .46944 .27633 L p F P
0 g
s
.4 .67 .969 r
.62935 .28911 m .61028 .27713 L .62425 .27384 L p F P
0 g
s
.4 .67 .969 r
.62425 .27384 m .64637 .28781 L .62935 .28911 L p F P
0 g
s
.34 .606 .947 r
.66395 .3042 m .64637 .28781 L .6629 .28832 L p F P
0 g
s
.34 .606 .947 r
.6629 .28832 m .68273 .30694 L .66395 .3042 L p F P
0 g
s
.817 .943 .908 r
.33303 .34074 m .34655 .31749 L .36507 .3124 L p F P
0 g
s
.831 .968 .891 r
.34655 .31749 m .33303 .34074 L .31432 .34971 L p F P
0 g
s
.822 .405 .252 r
.37008 .82574 m .33042 .80938 L .32357 .79411 L p F P
0 g
s
.796 .339 .157 r
.33042 .80938 m .37008 .82574 L .37658 .83889 L p F P
0 g
s
.759 .325 .22 r
.41842 .85062 m .37658 .83889 L .37008 .82574 L p F P
0 g
s
.726 .251 .119 r
.37658 .83889 m .41842 .85062 L .42384 .8616 L p F P
0 g
s
.686 .231 .167 r
.46617 .8689 m .42384 .8616 L .41842 .85062 L p F P
0 g
s
.94 .598 .349 r
.27649 .73773 m .24577 .71148 L .24212 .69186 L p F P
0 g
s
.927 .549 .263 r
.24577 .71148 m .27649 .73773 L .28133 .75588 L p F P
0 g
s
.019 0 .396 r
.81905 .64304 m .83971 .61108 L .83976 .63207 L p F P
0 g
s
.019 0 .396 r
.83976 .63207 m .8191 .66363 L .81905 .64304 L p F P
0 g
s
.14 .365 .822 r
.76161 .38082 m .75207 .35258 L .76826 .36411 L p F P
0 g
s
.14 .365 .822 r
.76826 .36411 m .77822 .39415 L .76161 .38082 L p F P
0 g
s
.878 .478 .266 r
.32357 .79411 m .28784 .77313 L .28133 .75588 L p F P
0 g
s
.855 .416 .17 r
.28784 .77313 m .32357 .79411 L .33042 .80938 L p F P
0 g
s
.003 .039 .545 r
.82763 .54869 m .83784 .51446 L .84412 .53477 L p F P
0 g
s
.003 .039 .545 r
.84412 .53477 m .83359 .56926 L .82763 .54869 L p F P
0 g
s
.236 0 .133 r
.69345 .82165 m .73179 .80425 L .7231 .8185 L p F P
0 g
s
.236 0 .133 r
.7231 .8185 m .68646 .83501 L .69345 .82165 L p F P
0 g
s
.316 0 .101 r
.64557 .8478 m .68646 .83501 L .67829 .8469 L p F P
0 g
s
.316 0 .101 r
.67829 .8469 m .63954 .85895 L .64557 .8478 L p F P
0 g
s
.217 .487 .895 r
.71618 .33425 m .70079 .31141 L .71801 .31764 L p F P
0 g
s
.217 .487 .895 r
.71801 .31764 m .73467 .34262 L .71618 .33425 L p F P
0 g
s
.594 .114 .084 r
.46617 .8689 m .51002 .8723 L .51099 .8809 L p F P
0 g
s
.535 .068 .092 r
.51002 .8723 m .55429 .87176 L .55259 .8804 L p F P
0 g
s
.535 .068 .092 r
.55259 .8804 m .51099 .8809 L .51002 .8723 L p F P
0 g
s
.997 .837 .561 r
.22324 .57833 m .20997 .54438 L .21618 .524 L p F P
0 g
s
1 .814 .491 r
.20997 .54438 m .22324 .57833 L .21927 .59917 L p F P
0 g
s
.035 .185 .69 r
.80776 .45773 m .80706 .42467 L .81907 .44172 L p F P
0 g
s
.035 .185 .69 r
.81907 .44172 m .81957 .47584 L .80776 .45773 L p F P
0 g
s
.462 .004 .078 r
.55429 .87176 m .59783 .86728 L .5935 .87622 L p F P
0 g
s
.462 .004 .078 r
.5935 .87622 m .55259 .8804 L .55429 .87176 L p F P
0 g
s
.658 .908 .98 r
.45785 .27003 m .43639 .28017 L .42152 .27738 L p F P
0 g
s
.712 .913 .964 r
.40057 .29208 m .42152 .27738 L .43639 .28017 L p F P
0 g
s
.983 .709 .42 r
.24033 .67175 m .21719 .64097 L .21724 .62009 L p F P
0 g
s
.975 .668 .337 r
.21719 .64097 m .24033 .67175 L .24212 .69186 L p F P
0 g
s
.9 .965 .82 r
.27284 .40244 m .28035 .37224 L .29671 .36022 L p F P
0 g
s
.914 .975 .78 r
.28035 .37224 m .27284 .40244 L .25765 .41751 L p F P
0 g
s
.763 .936 .941 r
.36507 .3124 m .38335 .29317 L .40057 .29208 L p F P
0 g
s
.767 .965 .929 r
.38335 .29317 m .36507 .3124 L .34655 .31749 L p F P
0 g
s
.967 .927 .697 r
.23425 .48502 m .23201 .4511 L .244 .43375 L p F P
0 g
s
.977 .92 .64 r
.23201 .4511 m .23425 .48502 L .2243 .50418 L p F P
0 g
s
.394 .702 .983 r
.61028 .27713 m .58802 .26774 L .59835 .26287 L p F P
0 g
s
.394 .702 .983 r
.59835 .26287 m .62425 .27384 L .61028 .27713 L p F P
0 g
s
.044 0 .231 r
.78488 .7309 m .81349 .70372 L .80778 .72295 L p F P
0 g
s
.044 0 .231 r
.80778 .72295 m .77983 .74927 L .78488 .7309 L p F P
0 g
s
.705 .942 .959 r
.42152 .27738 m .40057 .29208 L .38335 .29317 L p F P
0 g
s
.641 .143 .052 r
.42384 .8616 m .46617 .8689 L .46978 .87772 L p F P
0 g
s
.594 .114 .084 r
.51099 .8809 m .46978 .87772 L .46617 .8689 L p F P
0 g
s
.121 0 .139 r
.73901 .78874 m .77305 .76676 L .76455 .78325 L p F P
0 g
s
.121 0 .139 r
.76455 .78325 m .73179 .80425 L .73901 .78874 L p F P
0 g
s
.831 .968 .891 r
.31432 .34971 m .32891 .32429 L .34655 .31749 L p F P
0 g
s
.84 .988 .862 r
.32891 .32429 m .31432 .34971 L .29671 .36022 L p F P
0 g
s
.367 0 .039 r
.59783 .86728 m .63954 .85895 L .63265 .86844 L p F P
0 g
s
.367 0 .039 r
.63265 .86844 m .5935 .87622 L .59783 .86728 L p F P
0 g
s
.244 .556 .932 r
.68273 .30694 m .6629 .28832 L .67885 .29067 L p F P
0 g
s
.244 .556 .932 r
.67885 .29067 m .70079 .31141 L .68273 .30694 L p F P
0 g
s
.307 .632 .963 r
.64637 .28781 m .62425 .27384 L .63785 .27241 L p F P
0 g
s
.307 .632 .963 r
.63785 .27241 m .6629 .28832 L .64637 .28781 L p F P
0 g
s
.037 .283 .777 r
.77822 .39415 m .76826 .36411 L .7831 .37716 L p F P
0 g
s
.037 .283 .777 r
.7831 .37716 m .79341 .40879 L .77822 .39415 L p F P
0 g
s
.927 .549 .263 r
.28133 .75588 m .25131 .73046 L .24577 .71148 L p F P
0 g
s
.9 .484 .159 r
.25131 .73046 m .28133 .75588 L .28784 .77313 L p F P
0 g
s
0 0 .466 r
.83359 .56926 m .84412 .53477 L .84839 .55557 L p F P
0 g
s
0 0 .466 r
.84839 .55557 m .83763 .5901 L .83359 .56926 L p F P
0 g
s
.658 .908 .98 r
.42152 .27738 m .44647 .26554 L .45785 .27003 L p F P
0 g
s
0 0 .303 r
.8191 .66363 m .83976 .63207 L .83774 .65294 L p F P
0 g
s
0 0 .303 r
.83774 .65294 m .81725 .6839 L .8191 .66363 L p F P
0 g
s
.796 .339 .157 r
.37658 .83889 m .33866 .82337 L .33042 .80938 L p F P
0 g
s
.753 .254 .038 r
.33866 .82337 m .37658 .83889 L .38417 .85055 L p F P
0 g
s
.726 .251 .119 r
.42384 .8616 m .38417 .85055 L .37658 .83889 L p F P
0 g
s
0 .089 .625 r
.81957 .47584 m .81907 .44172 L .82931 .45985 L p F P
0 g
s
0 .089 .625 r
.82931 .45985 m .82963 .49479 L .81957 .47584 L p F P
0 g
s
1 .814 .491 r
.21927 .59917 m .20574 .56519 L .20997 .54438 L p F P
0 g
s
.993 .778 .406 r
.20574 .56519 m .21927 .59917 L .21724 .62009 L p F P
0 g
s
.11 .415 .862 r
.73467 .34262 m .71801 .31764 L .73425 .32563 L p F P
0 g
s
.11 .415 .862 r
.73425 .32563 m .75207 .35258 L .73467 .34262 L p F P
0 g
s
.914 .975 .78 r
.25765 .41751 m .26535 .38573 L .28035 .37224 L p F P
0 g
s
.92 .977 .726 r
.26535 .38573 m .25765 .41751 L .244 .43375 L p F P
0 g
s
.977 .92 .64 r
.2243 .50418 m .22178 .46946 L .23201 .4511 L p F P
0 g
s
.979 .903 .568 r
.22178 .46946 m .2243 .50418 L .21618 .524 L p F P
0 g
s
.975 .668 .337 r
.24212 .69186 m .21916 .66167 L .21719 .64097 L p F P
0 g
s
.955 .613 .237 r
.21916 .66167 m .24212 .69186 L .24577 .71148 L p F P
0 g
s
.674 .155 0 r
.38417 .85055 m .42384 .8616 L .43004 .87092 L p F P
0 g
s
.641 .143 .052 r
.46978 .87772 m .43004 .87092 L .42384 .8616 L p F P
0 g
s
.855 .416 .17 r
.33042 .80938 m .29601 .78933 L .28784 .77313 L p F P
0 g
s
.814 .334 .052 r
.29601 .78933 m .33042 .80938 L .33866 .82337 L p F P
0 g
s
.767 .965 .929 r
.34655 .31749 m .36675 .29609 L .38335 .29317 L p F P
0 g
s
.763 .986 .901 r
.36675 .29609 m .34655 .31749 L .32891 .32429 L p F P
0 g
s
.159 0 .008 r
.68646 .83501 m .7231 .8185 L .71296 .83137 L p F P
0 g
s
.159 0 .008 r
.71296 .83137 m .67829 .8469 L .68646 .83501 L p F P
0 g
s
.238 0 0 r
.63954 .85895 m .67829 .8469 L .66897 .85721 L p F P
0 g
s
.238 0 0 r
.66897 .85721 m .63265 .86844 L .63954 .85895 L p F P
0 g
s
.629 .93 .97 r
.44647 .26554 m .42152 .27738 L .40704 .27645 L p F P
0 g
s
.705 .942 .959 r
.38335 .29317 m .40704 .27645 L .42152 .27738 L p F P
0 g
s
0 0 .117 r
.77983 .74927 m .80778 .72295 L .80013 .74146 L p F P
0 g
s
0 0 .117 r
.80013 .74146 m .77305 .76676 L .77983 .74927 L p F P
0 g
s
.84 .988 .862 r
.29671 .36022 m .31228 .33281 L .32891 .32429 L p F P
0 g
s
.84 .999 .817 r
.31228 .33281 m .29671 .36022 L .28035 .37224 L p F P
0 g
s
.528 .003 0 r
.46978 .87772 m .51099 .8809 L .51208 .88767 L p F P
0 g
s
.468 0 0 r
.51099 .8809 m .55259 .8804 L .55068 .8872 L p F P
0 g
s
.468 0 0 r
.55068 .8872 m .51208 .88767 L .51099 .8809 L p F P
0 g
s
.687 .964 .938 r
.40704 .27645 m .38335 .29317 L .36675 .29609 L p F P
0 g
s
.388 0 0 r
.55259 .8804 m .5935 .87622 L .58863 .88335 L p F P
0 g
s
.388 0 0 r
.58863 .88335 m .55068 .8872 L .55259 .8804 L p F P
0 g
s
.036 0 .013 r
.73179 .80425 m .76455 .78325 L .75433 .7986 L p F P
0 g
s
.036 0 .013 r
.75433 .7986 m .7231 .8185 L .73179 .80425 L p F P
0 g
s
.287 .663 .971 r
.62425 .27384 m .59835 .26287 L .60843 .2599 L p F P
0 g
s
.287 .663 .971 r
.60843 .2599 m .63785 .27241 L .62425 .27384 L p F P
0 g
s
.125 .486 .901 r
.70079 .31141 m .67885 .29067 L .69408 .29491 L p F P
0 g
s
.125 .486 .901 r
.69408 .29491 m .71801 .31764 L .70079 .31141 L p F P
0 g
s
0 .183 .714 r
.79341 .40879 m .7831 .37716 L .79647 .39168 L p F P
0 g
s
0 .183 .714 r
.79647 .39168 m .80706 .42467 L .79341 .40879 L p F P
0 g
s
0 0 .369 r
.83763 .5901 m .84839 .55557 L .85058 .57676 L p F P
0 g
s
0 0 .369 r
.85058 .57676 m .83971 .61108 L .83763 .5901 L p F P
0 g
s
0 0 .192 r
.81725 .6839 m .83774 .65294 L .83363 .67356 L p F P
0 g
s
0 0 .192 r
.83363 .67356 m .81349 .70372 L .81725 .6839 L p F P
0 g
s
0 0 .542 r
.82963 .49479 m .82931 .45985 L .83768 .47896 L p F P
0 g
s
0 0 .542 r
.83768 .47896 m .83784 .51446 L .82963 .49479 L p F P
0 g
s
.993 .778 .406 r
.21724 .62009 m .20358 .58632 L .20574 .56519 L p F P
0 g
s
.972 .727 .302 r
.20358 .58632 m .21724 .62009 L .21719 .64097 L p F P
0 g
s
.571 .028 0 r
.43004 .87092 m .46978 .87772 L .47385 .88473 L p F P
0 g
s
.528 .003 0 r
.51208 .88767 m .47385 .88473 L .46978 .87772 L p F P
0 g
s
.187 .573 .938 r
.6629 .28832 m .63785 .27241 L .65099 .27292 L p F P
0 g
s
.187 .573 .938 r
.65099 .27292 m .67885 .29067 L .6629 .28832 L p F P
0 g
s
.9 .484 .159 r
.28784 .77313 m .25874 .74868 L .25131 .73046 L p F P
0 g
s
.855 .4 .033 r
.25874 .74868 m .28784 .77313 L .29601 .78933 L p F P
0 g
s
.92 .977 .726 r
.244 .43375 m .25185 .40062 L .26535 .38573 L p F P
0 g
s
.915 .965 .653 r
.25185 .40062 m .244 .43375 L .23201 .4511 L p F P
0 g
s
.979 .903 .568 r
.21618 .524 m .21342 .48873 L .22178 .46946 L p F P
0 g
s
.967 .871 .477 r
.21342 .48873 m .21618 .524 L .20997 .54438 L p F P
0 g
s
0 .323 .81 r
.75207 .35258 m .73425 .32563 L .74939 .33537 L p F P
0 g
s
0 .323 .81 r
.74939 .33537 m .76826 .36411 L .75207 .35258 L p F P
0 g
s
.281 0 0 r
.5935 .87622 m .63265 .86844 L .62491 .87617 L p F P
0 g
s
.281 0 0 r
.62491 .87617 m .58863 .88335 L .5935 .87622 L p F P
0 g
s
.955 .613 .237 r
.24577 .71148 m .22319 .68206 L .21916 .66167 L p F P
0 g
s
.916 .539 .117 r
.22319 .68206 m .24577 .71148 L .25131 .73046 L p F P
0 g
s
.753 .254 .038 r
.38417 .85055 m .34827 .83595 L .33866 .82337 L p F P
0 g
s
.684 .143 0 r
.34827 .83595 m .38417 .85055 L .39284 .86061 L p F P
0 g
s
.674 .155 0 r
.43004 .87092 m .39284 .86061 L .38417 .85055 L p F P
0 g
s
.629 .93 .97 r
.40704 .27645 m .43537 .26295 L .44647 .26554 L p F P
0 g
s
.763 .986 .901 r
.32891 .32429 m .35091 .30085 L .36675 .29609 L p F P
0 g
s
.743 .993 .852 r
.35091 .30085 m .32891 .32429 L .31228 .33281 L p F P
0 g
s
.814 .334 .052 r
.33866 .82337 m .30583 .80435 L .29601 .78933 L p F P
0 g
s
.749 .23 0 r
.30583 .80435 m .33866 .82337 L .34827 .83595 L p F P
0 g
s
.84 .999 .817 r
.28035 .37224 m .29679 .34303 L .31228 .33281 L p F P
0 g
s
.827 .994 .75 r
.29679 .34303 m .28035 .37224 L .26535 .38573 L p F P
0 g
s
0 0 0 r
.77305 .76676 m .80013 .74146 L .79054 .7591 L p F P
0 g
s
0 0 0 r
.79054 .7591 m .76455 .78325 L .77305 .76676 L p F P
0 g
s
.592 .03 0 r
.39284 .86061 m .43004 .87092 L .437 .87845 L p F P
0 g
s
.571 .028 0 r
.47385 .88473 m .437 .87845 L .43004 .87092 L p F P
0 g
s
.061 0 0 r
.67829 .8469 m .71296 .83137 L .70139 .84275 L p F P
0 g
s
.061 0 0 r
.70139 .84275 m .66897 .85721 L .67829 .8469 L p F P
0 g
s
0 .065 .629 r
.80706 .42467 m .79647 .39168 L .80824 .40761 L p F P
0 g
s
0 .065 .629 r
.80824 .40761 m .81907 .44172 L .80706 .42467 L p F P
0 g
s
0 0 .253 r
.83971 .61108 m .85058 .57676 L .85064 .59818 L p F P
0 g
s
0 0 .253 r
.85064 .59818 m .83976 .63207 L .83971 .61108 L p F P
0 g
s
0 0 .438 r
.83784 .51446 m .83768 .47896 L .84409 .49896 L p F P
0 g
s
0 0 .438 r
.84409 .49896 m .84412 .53477 L .83784 .51446 L p F P
0 g
s
.578 .934 .933 r
.43537 .26295 m .40704 .27645 L .39307 .27743 L p F P
0 g
s
.687 .964 .938 r
.36675 .29609 m .39307 .27743 L .40704 .27645 L p F P
0 g
s
.648 .968 .89 r
.39307 .27743 m .36675 .29609 L .35091 .30085 L p F P
0 g
s
0 .391 .843 r
.71801 .31764 m .69408 .29491 L .70848 .30105 L p F P
0 g
s
0 .391 .843 r
.70848 .30105 m .73425 .32563 L .71801 .31764 L p F P
0 g
s
.137 0 0 r
.63265 .86844 m .66897 .85721 L .65852 .86582 L p F P
0 g
s
.137 0 0 r
.65852 .86582 m .62491 .87617 L .63265 .86844 L p F P
0 g
s
.972 .727 .302 r
.21719 .64097 m .20352 .60763 L .20358 .58632 L p F P
0 g
s
.931 .655 .179 r
.20352 .60763 m .21719 .64097 L .21916 .66167 L p F P
0 g
s
0 0 .061 r
.81349 .70372 m .83363 .67356 L .82741 .69376 L p F P
0 g
s
0 0 .061 r
.82741 .69376 m .80778 .72295 L .81349 .70372 L p F P
0 g
s
.967 .871 .477 r
.20997 .54438 m .20702 .50882 L .21342 .48873 L p F P
0 g
s
.937 .818 .365 r
.20702 .50882 m .20997 .54438 L .20574 .56519 L p F P
0 g
s
0 0 0 r
.7231 .8185 m .75433 .7986 L .74243 .81268 L p F P
0 g
s
0 0 0 r
.74243 .81268 m .71296 .83137 L .7231 .8185 L p F P
0 g
s
.915 .965 .653 r
.23201 .4511 m .23997 .41687 L .25185 .40062 L p F P
0 g
s
.893 .933 .557 r
.23997 .41687 m .23201 .4511 L .22178 .46946 L p F P
0 g
s
.147 .597 .929 r
.63785 .27241 m .60843 .2599 L .61817 .25893 L p F P
0 g
s
.147 .597 .929 r
.61817 .25893 m .65099 .27292 L .63785 .27241 L p F P
0 g
s
0 .208 .731 r
.76826 .36411 m .74939 .33537 L .76329 .34684 L p F P
0 g
s
0 .208 .731 r
.76329 .34684 m .7831 .37716 L .76826 .36411 L p F P
0 g
s
.855 .4 .033 r
.29601 .78933 m .26805 .76599 L .25874 .74868 L p F P
0 g
s
.782 .292 0 r
.26805 .76599 m .29601 .78933 L .30583 .80435 L p F P
0 g
s
.429 0 0 r
.47385 .88473 m .51208 .88767 L .51328 .89249 L p F P
0 g
s
.369 0 0 r
.51208 .88767 m .55068 .8872 L .54856 .89207 L p F P
0 g
s
.369 0 0 r
.54856 .89207 m .51328 .89249 L .51208 .88767 L p F P
0 g
s
.283 0 0 r
.55068 .8872 m .58863 .88335 L .58324 .88856 L p F P
0 g
s
.283 0 0 r
.58324 .88856 m .54856 .89207 L .55068 .8872 L p F P
0 g
s
.916 .539 .117 r
.25131 .73046 m .22928 .70199 L .22319 .68206 L p F P
0 g
s
.854 .443 0 r
.22928 .70199 m .25131 .73046 L .25874 .74868 L p F P
0 g
s
.036 .487 .883 r
.67885 .29067 m .65099 .27292 L .66357 .27541 L p F P
0 g
s
.036 .487 .883 r
.66357 .27541 m .69408 .29491 L .67885 .29067 L p F P
0 g
s
.465 0 0 r
.437 .87845 m .47385 .88473 L .47835 .88982 L p F P
0 g
s
.429 0 0 r
.51328 .89249 m .47835 .88982 L .47385 .88473 L p F P
0 g
s
.827 .994 .75 r
.26535 .38573 m .28257 .35493 L .29679 .34303 L p F P
0 g
s
.792 .965 .654 r
.28257 .35493 m .26535 .38573 L .25185 .40062 L p F P
0 g
s
.743 .993 .852 r
.31228 .33281 m .33594 .30747 L .35091 .30085 L p F P
0 g
s
.702 .976 .771 r
.33594 .30747 m .31228 .33281 L .29679 .34303 L p F P
0 g
s
.165 0 0 r
.58863 .88335 m .62491 .87617 L .61635 .88203 L p F P
0 g
s
.165 0 0 r
.61635 .88203 m .58324 .88856 L .58863 .88335 L p F P
0 g
s
0 0 .117 r
.83976 .63207 m .85064 .59818 L .84851 .61971 L p F P
0 g
s
0 0 .117 r
.84851 .61971 m .83774 .65294 L .83976 .63207 L p F P
0 g
s
0 0 .517 r
.81907 .44172 m .80824 .40761 L .81829 .42488 L p F P
0 g
s
0 0 .517 r
.81829 .42488 m .82931 .45985 L .81907 .44172 L p F P
0 g
s
.684 .143 0 r
.39284 .86061 m .35924 .84701 L .34827 .83595 L p F P
0 g
s
.581 .004 0 r
.35924 .84701 m .39284 .86061 L .40257 .86895 L p F P
0 g
s
.592 .03 0 r
.437 .87845 m .40257 .86895 L .39284 .86061 L p F P
0 g
s
0 0 .311 r
.84412 .53477 m .84409 .49896 L .84845 .51971 L p F P
0 g
s
0 0 .311 r
.84845 .51971 m .84839 .55557 L .84412 .53477 L p F P
0 g
s
0 0 0 r
.76455 .78325 m .79054 .7591 L .77903 .77574 L p F P
0 g
s
0 0 0 r
.77903 .77574 m .75433 .7986 L .76455 .78325 L p F P
0 g
s
.749 .23 0 r
.34827 .83595 m .31727 .81808 L .30583 .80435 L p F P
0 g
s
.651 .098 0 r
.31727 .81808 m .34827 .83595 L .35924 .84701 L p F P
0 g
s
.578 .934 .933 r
.39307 .27743 m .42464 .26234 L .43537 .26295 L p F P
0 g
s
.931 .655 .179 r
.21916 .66167 m .20562 .62897 L .20352 .60763 L p F P
0 g
s
.864 .56 .036 r
.20562 .62897 m .21916 .66167 L .22319 .68206 L p F P
0 g
s
.937 .818 .365 r
.20574 .56519 m .20267 .52959 L .20702 .50882 L p F P
0 g
s
.883 .741 .232 r
.20267 .52959 m .20574 .56519 L .20358 .58632 L p F P
0 g
s
.893 .933 .557 r
.22178 .46946 m .22982 .43437 L .23997 .41687 L p F P
0 g
s
.847 .875 .436 r
.22982 .43437 m .22178 .46946 L .21342 .48873 L p F P
0 g
s
0 0 0 r
.80778 .72295 m .82741 .69376 L .81907 .71342 L p F P
0 g
s
0 0 0 r
.81907 .71342 m .80013 .74146 L .80778 .72295 L p F P
0 g
s
0 0 0 r
.66897 .85721 m .70139 .84275 L .68844 .85251 L p F P
0 g
s
0 0 0 r
.68844 .85251 m .65852 .86582 L .66897 .85721 L p F P
0 g
s
0 .268 .749 r
.73425 .32563 m .70848 .30105 L .72192 .30911 L p F P
0 g
s
0 .268 .749 r
.72192 .30911 m .74939 .33537 L .73425 .32563 L p F P
0 g
s
.648 .968 .89 r
.35091 .30085 m .3797 .28037 L .39307 .27743 L p F P
0 g
s
.581 .94 .803 r
.3797 .28037 m .35091 .30085 L .33594 .30747 L p F P
0 g
s
.471 0 0 r
.40257 .86895 m .437 .87845 L .44471 .88411 L p F P
0 g
s
.465 0 0 r
.47835 .88982 m .44471 .88411 L .437 .87845 L p F P
0 g
s
0 .07 .619 r
.7831 .37716 m .76329 .34684 L .77584 .36 L p F P
0 g
s
0 .07 .619 r
.77584 .36 m .79647 .39168 L .7831 .37716 L p F P
0 g
s
.494 .905 .854 r
.42464 .26234 m .39307 .27743 L .3797 .28037 L p F P
0 g
s
0 0 0 r
.71296 .83137 m .74243 .81268 L .72888 .82536 L p F P
0 g
s
0 0 0 r
.72888 .82536 m .70139 .84275 L .71296 .83137 L p F P
0 g
s
.854 .443 0 r
.25874 .74868 m .23745 .72132 L .22928 .70199 L p F P
0 g
s
.761 .323 0 r
.23745 .72132 m .25874 .74868 L .26805 .76599 L p F P
0 g
s
.782 .292 0 r
.30583 .80435 m .27923 .78226 L .26805 .76599 L p F P
0 g
s
.677 .16 0 r
.27923 .78226 m .30583 .80435 L .31727 .81808 L p F P
0 g
s
.008 0 0 r
.62491 .87617 m .65852 .86582 L .64697 .87262 L p F P
0 g
s
.008 0 0 r
.64697 .87262 m .61635 .88203 L .62491 .87617 L p F P
0 g
s
0 .491 .841 r
.65099 .27292 m .61817 .25893 L .62752 .26001 L p F P
0 g
s
0 .491 .841 r
.62752 .26001 m .66357 .27541 L .65099 .27292 L p F P
0 g
s
0 .365 .783 r
.69408 .29491 m .66357 .27541 L .67548 .27992 L p F P
0 g
s
0 .365 .783 r
.67548 .27992 m .70848 .30105 L .69408 .29491 L p F P
0 g
s
.792 .965 .654 r
.25185 .40062 m .26974 .36846 L .28257 .35493 L p F P
0 g
s
.729 .903 .527 r
.26974 .36846 m .25185 .40062 L .23997 .41687 L p F P
0 g
s
0 0 0 r
.83774 .65294 m .84851 .61971 L .84417 .6412 L p F P
0 g
s
0 0 0 r
.84417 .6412 m .83363 .67356 L .83774 .65294 L p F P
0 g
s
0 0 .379 r
.82931 .45985 m .81829 .42488 L .82653 .4434 L p F P
0 g
s
0 0 .379 r
.82653 .4434 m .83768 .47896 L .82931 .45985 L p F P
0 g
s
.702 .976 .771 r
.29679 .34303 m .32196 .31598 L .33594 .30747 L p F P
0 g
s
.631 .922 .652 r
.32196 .31598 m .29679 .34303 L .28257 .35493 L p F P
0 g
s
0 0 .165 r
.84839 .55557 m .84845 .51971 L .85069 .5411 L p F P
0 g
s
0 0 .165 r
.85069 .5411 m .85058 .57676 L .84839 .55557 L p F P
0 g
s
.287 0 0 r
.47835 .88982 m .51328 .89249 L .5146 .89528 L p F P
0 g
s
.229 0 0 r
.51328 .89249 m .54856 .89207 L .54625 .8949 L p F P
0 g
s
.229 0 0 r
.54625 .8949 m .5146 .89528 L .51328 .89249 L p F P
0 g
s
.14 0 0 r
.54856 .89207 m .58324 .88856 L .57734 .89175 L p F P
0 g
s
.14 0 0 r
.57734 .89175 m .54625 .8949 L .54856 .89207 L p F P
0 g
s
.883 .741 .232 r
.20358 .58632 m .20043 .55092 L .20267 .52959 L p F P
0 g
s
.802 .638 .082 r
.20043 .55092 m .20358 .58632 L .20352 .60763 L p F P
0 g
s
.864 .56 .036 r
.22319 .68206 m .20991 .65021 L .20562 .62897 L p F P
0 g
s
.769 .442 0 r
.20991 .65021 m .22319 .68206 L .22928 .70199 L p F P
0 g
s
.847 .875 .436 r
.21342 .48873 m .22152 .45305 L .22982 .43437 L p F P
0 g
s
.773 .787 .291 r
.22152 .45305 m .21342 .48873 L .20702 .50882 L p F P
0 g
s
0 0 0 r
.75433 .7986 m .77903 .77574 L .76564 .79124 L p F P
0 g
s
0 0 0 r
.76564 .79124 m .74243 .81268 L .75433 .7986 L p F P
0 g
s
0 0 0 r
.80013 .74146 m .81907 .71342 L .80864 .73238 L p F P
0 g
s
0 0 0 r
.80864 .73238 m .79054 .7591 L .80013 .74146 L p F P
0 g
s
.314 0 0 r
.44471 .88411 m .47835 .88982 L .48327 .89289 L p F P
0 g
s
.287 0 0 r
.5146 .89528 m .48327 .89289 L .47835 .88982 L p F P
0 g
s
.651 .098 0 r
.35924 .84701 m .33031 .83039 L .31727 .81808 L p F P
0 g
s
.515 0 0 r
.33031 .83039 m .35924 .84701 L .37153 .85642 L p F P
0 g
s
.581 .004 0 r
.40257 .86895 m .37153 .85642 L .35924 .84701 L p F P
0 g
s
.435 0 0 r
.37153 .85642 m .40257 .86895 L .41332 .87547 L p F P
0 g
s
.471 0 0 r
.44471 .88411 m .41332 .87547 L .40257 .86895 L p F P
0 g
s
.018 0 0 r
.58324 .88856 m .61635 .88203 L .607 .88591 L p F P
0 g
s
.018 0 0 r
.607 .88591 m .57734 .89175 L .58324 .88856 L p F P
0 g
s
0 0 .475 r
.79647 .39168 m .77584 .36 L .7869 .37482 L p F P
0 g
s
0 0 .475 r
.7869 .37482 m .80824 .40761 L .79647 .39168 L p F P
0 g
s
0 .118 .613 r
.74939 .33537 m .72192 .30911 L .73429 .31909 L p F P
0 g
s
0 .118 .613 r
.73429 .31909 m .76329 .34684 L .74939 .33537 L p F P
0 g
s
.494 .905 .854 r
.3797 .28037 m .41436 .26377 L .42464 .26234 L p F P
0 g
s
.581 .94 .803 r
.33594 .30747 m .36705 .2853 L .3797 .28037 L p F P
0 g
s
.48 .867 .669 r
.36705 .2853 m .33594 .30747 L .32196 .31598 L p F P
0 g
s
.761 .323 0 r
.26805 .76599 m .24768 .73991 L .23745 .72132 L p F P
0 g
s
.638 .183 0 r
.24768 .73991 m .26805 .76599 L .27923 .78226 L p F P
0 g
s
0 0 0 r
.65852 .86582 m .68844 .85251 L .67416 .86054 L p F P
0 g
s
0 0 0 r
.67416 .86054 m .64697 .87262 L .65852 .86582 L p F P
0 g
s
0 0 0 r
.70139 .84275 m .72888 .82536 L .71373 .83653 L p F P
0 g
s
0 0 0 r
.71373 .83653 m .68844 .85251 L .70139 .84275 L p F P
0 g
s
.677 .16 0 r
.31727 .81808 m .29224 .79735 L .27923 .78226 L p F P
0 g
s
.538 .009 0 r
.29224 .79735 m .31727 .81808 L .33031 .83039 L p F P
0 g
s
.373 .826 .72 r
.41436 .26377 m .3797 .28037 L .36705 .2853 L p F P
0 g
s
.729 .903 .527 r
.23997 .41687 m .25844 .38358 L .26974 .36846 L p F P
0 g
s
.637 .806 .372 r
.25844 .38358 m .23997 .41687 L .22982 .43437 L p F P
0 g
s
0 0 0 r
.83363 .67356 m .84417 .6412 L .8376 .66248 L p F P
0 g
s
0 0 0 r
.8376 .66248 m .82741 .69376 L .83363 .67356 L p F P
0 g
s
0 0 .007 r
.85058 .57676 m .85069 .5411 L .85075 .56298 L p F P
0 g
s
0 0 .007 r
.85075 .56298 m .85064 .59818 L .85058 .57676 L p F P
0 g
s
.304 0 0 r
.41332 .87547 m .44471 .88411 L .45313 .88777 L p F P
0 g
s
.314 0 0 r
.48327 .89289 m .45313 .88777 L .44471 .88411 L p F P
0 g
s
0 0 .222 r
.83768 .47896 m .82653 .4434 L .83283 .46305 L p F P
0 g
s
0 0 .222 r
.83283 .46305 m .84409 .49896 L .83768 .47896 L p F P
0 g
s
.802 .638 .082 r
.20352 .60763 m .20038 .57267 L .20043 .55092 L p F P
0 g
s
0 0 .077 r
.20038 .57267 m .20352 .60763 L .20562 .62897 L p F P
0 g
s
.631 .922 .652 r
.28257 .35493 m .30911 .32635 L .32196 .31598 L p F P
0 g
s
.528 .826 .496 r
.30911 .32635 m .28257 .35493 L .26974 .36846 L p F P
0 g
s
0 .211 .633 r
.70848 .30105 m .67548 .27992 L .68662 .2865 L p F P
0 g
s
0 .211 .633 r
.68662 .2865 m .72192 .30911 L .70848 .30105 L p F P
0 g
s
.773 .787 .291 r
.20702 .50882 m .21516 .47281 L .22152 .45305 L p F P
0 g
s
0 0 0 r
.21516 .47281 m .20702 .50882 L .20267 .52959 L p F P
0 g
s
.769 .442 0 r
.22928 .70199 m .2164 .67119 L .20991 .65021 L p F P
0 g
s
0 0 .278 r
.2164 .67119 m .22928 .70199 L .23745 .72132 L p F P
0 g
s
0 0 0 r
.61635 .88203 m .64697 .87262 L .63437 .87751 L p F P
0 g
s
0 0 0 r
.63437 .87751 m .607 .88591 L .61635 .88203 L p F P
0 g
s
0 .344 .694 r
.66357 .27541 m .62752 .26001 L .63638 .26323 L p F P
0 g
s
0 .344 .694 r
.63638 .26323 m .67548 .27992 L .66357 .27541 L p F P
0 g
s
.594 .811 .411 r
.79054 .7591 m .80864 .73238 L .79613 .75049 L p F P
0 g
s
.594 .811 .411 r
.79613 .75049 m .77903 .77574 L .79054 .7591 L p F P
0 g
s
0 0 0 r
.74243 .81268 m .76564 .79124 L .75043 .80547 L p F P
0 g
s
0 0 0 r
.75043 .80547 m .72888 .82536 L .74243 .81268 L p F P
0 g
s
.661 .239 0 r
.80824 .40761 m .7869 .37482 L .79637 .39121 L p F P
0 g
s
.661 .239 0 r
.79637 .39121 m .81829 .42488 L .80824 .40761 L p F P
0 g
s
.515 0 0 r
.37153 .85642 m .34489 .84115 L .33031 .83039 L p F P
0 g
s
.435 0 0 r
.41332 .87547 m .3851 .86409 L .37153 .85642 L p F P
0 g
s
0 .221 .621 r
.34489 .84115 m .37153 .85642 L .3851 .86409 L p F P
0 g
s
.103 0 0 r
.48327 .89289 m .5146 .89528 L .51603 .89593 L p F P
0 g
s
.051 0 0 r
.5146 .89528 m .54625 .8949 L .54375 .8956 L p F P
0 g
s
.051 0 0 r
.54375 .8956 m .51603 .89593 L .5146 .89528 L p F P
0 g
s
.555 .045 0 r
.76329 .34684 m .73429 .31909 L .74548 .33097 L p F P
0 g
s
.555 .045 0 r
.74548 .33097 m .77584 .36 L .76329 .34684 L p F P
0 g
s
0 0 0 r
.54625 .8949 m .57734 .89175 L .57097 .89285 L p F P
0 g
s
0 0 0 r
.57097 .89285 m .54375 .8956 L .54625 .8949 L p F P
0 g
s
.638 .183 0 r
.27923 .78226 m .25994 .7576 L .24768 .73991 L p F P
0 g
s
0 0 .503 r
.25994 .7576 m .27923 .78226 L .29224 .79735 L p F P
0 g
s
.304 0 0 r
.45313 .88777 m .42505 .88005 L .41332 .87547 L p F P
0 g
s
0 .33 .666 r
.3851 .86409 m .41332 .87547 L .42505 .88005 L p F P
0 g
s
.803 .694 .152 r
.85064 .59818 m .85075 .56298 L .84857 .5852 L p F P
0 g
s
.803 .694 .152 r
.84857 .5852 m .84851 .61971 L .85064 .59818 L p F P
0 g
s
.747 .818 .348 r
.82741 .69376 m .8376 .66248 L .82882 .6834 L p F P
0 g
s
.747 .818 .348 r
.82882 .6834 m .81907 .71342 L .82741 .69376 L p F P
0 g
s
.79 .507 0 r
.84409 .49896 m .83283 .46305 L .83713 .48374 L p F P
0 g
s
.79 .507 0 r
.83713 .48374 m .84845 .51971 L .84409 .49896 L p F P
0 g
s
.123 0 0 r
.45313 .88777 m .48327 .89289 L .48859 .89384 L p F P
0 g
s
.103 0 0 r
.51603 .89593 m .48859 .89384 L .48327 .89289 L p F P
0 g
s
.637 .806 .372 r
.22982 .43437 m .24876 .40021 L .25844 .38358 L p F P
0 g
s
0 0 0 r
.24876 .40021 m .22982 .43437 L .22152 .45305 L p F P
0 g
s
.48 .867 .669 r
.32196 .31598 m .35522 .29226 L .36705 .2853 L p F P
0 g
s
0 0 0 r
.35522 .29226 m .32196 .31598 L .30911 .32635 L p F P
0 g
s
.538 .009 0 r
.33031 .83039 m .30703 .81113 L .29224 .79735 L p F P
0 g
s
0 .149 .617 r
.30703 .81113 m .33031 .83039 L .34489 .84115 L p F P
0 g
s
0 0 .077 r
.20562 .62897 m .20255 .5947 L .20038 .57267 L p F P
0 g
s
0 0 .233 r
.20255 .5947 m .20562 .62897 L .20991 .65021 L p F P
0 g
s
.373 .826 .72 r
.36705 .2853 m .40461 .2673 L .41436 .26377 L p F P
0 g
s
.149 .688 .707 r
.57734 .89175 m .607 .88591 L .5969 .88774 L p F P
0 g
s
.149 .688 .707 r
.5969 .88774 m .57097 .89285 L .57734 .89175 L p F P
0 g
s
.42 .836 .659 r
.68844 .85251 m .71373 .83653 L .69705 .84607 L p F P
0 g
s
.42 .836 .659 r
.69705 .84607 m .67416 .86054 L .68844 .85251 L p F P
0 g
s
0 0 0 r
.20267 .52959 m .21083 .49351 L .21516 .47281 L p F P
0 g
s
0 0 .032 r
.21083 .49351 m .20267 .52959 L .20043 .55092 L p F P
0 g
s
.325 .795 .696 r
.64697 .87262 m .67416 .86054 L .65861 .86674 L p F P
0 g
s
.325 .795 .696 r
.65861 .86674 m .63437 .87751 L .64697 .87262 L p F P
0 g
s
0 0 .278 r
.23745 .72132 m .22509 .69176 L .2164 .67119 L p F P
0 g
s
0 0 .429 r
.22509 .69176 m .23745 .72132 L .24768 .73991 L p F P
0 g
s
0 0 0 r
.40461 .2673 m .36705 .2853 L .35522 .29226 L p F P
0 g
s
.528 .826 .496 r
.26974 .36846 m .2975 .33857 L .30911 .32635 L p F P
0 g
s
0 0 0 r
.2975 .33857 m .26974 .36846 L .25844 .38358 L p F P
0 g
s
.674 .902 .558 r
.77903 .77574 m .79613 .75049 L .78161 .7676 L p F P
0 g
s
.674 .902 .558 r
.78161 .7676 m .76564 .79124 L .77903 .77574 L p F P
0 g
s
.522 0 0 r
.72192 .30911 m .68662 .2865 L .69689 .29516 L p F P
0 g
s
.522 0 0 r
.69689 .29516 m .73429 .31909 L .72192 .30911 L p F P
0 g
s
.123 0 0 r
.48859 .89384 m .46223 .88936 L .45313 .88777 L p F P
0 g
s
0 .469 .751 r
.42505 .88005 m .45313 .88777 L .46223 .88936 L p F P
0 g
s
.564 .9 .66 r
.72888 .82536 m .75043 .80547 L .73345 .81829 L p F P
0 g
s
.564 .9 .66 r
.73345 .81829 m .71373 .83653 L .72888 .82536 L p F P
0 g
s
.422 0 0 r
.67548 .27992 m .63638 .26323 L .64468 .26861 L p F P
0 g
s
.422 0 0 r
.64468 .26861 m .68662 .2865 L .67548 .27992 L p F P
0 g
s
.288 .785 .77 r
.607 .88591 m .63437 .87751 L .62078 .8804 L p F P
0 g
s
.288 .785 .77 r
.62078 .8804 m .5969 .88774 L .607 .88591 L p F P
0 g
s
.79 .383 0 r
.81829 .42488 m .79637 .39121 L .80413 .40911 L p F P
0 g
s
.79 .383 0 r
.80413 .40911 m .82653 .4434 L .81829 .42488 L p F P
0 g
s
.879 .791 .3 r
.84851 .61971 m .84857 .5852 L .84414 .60761 L p F P
0 g
s
.879 .791 .3 r
.84414 .60761 m .84417 .6412 L .84851 .61971 L p F P
0 g
s
0 0 .503 r
.29224 .79735 m .27419 .77425 L .25994 .7576 L p F P
0 g
s
0 .116 .641 r
.27419 .77425 m .29224 .79735 L .30703 .81113 L p F P
0 g
s
.813 .899 .487 r
.81907 .71342 m .82882 .6834 L .81783 .70381 L p F P
0 g
s
.813 .899 .487 r
.81783 .70381 m .80864 .73238 L .81907 .71342 L p F P
0 g
s
.703 .203 0 r
.77584 .36 m .74548 .33097 L .75535 .34471 L p F P
0 g
s
.703 .203 0 r
.75535 .34471 m .7869 .37482 L .77584 .36 L p F P
0 g
s
.883 .624 .103 r
.84845 .51971 m .83713 .48374 L .83933 .50532 L p F P
0 g
s
.883 .624 .103 r
.83933 .50532 m .85069 .5411 L .84845 .51971 L p F P
0 g
s
0 0 .233 r
.20991 .65021 m .20697 .61685 L .20255 .5947 L p F P
0 g
s
0 0 .375 r
.20697 .61685 m .20991 .65021 L .2164 .67119 L p F P
0 g
s
0 0 0 r
.22152 .45305 m .24084 .41828 L .24876 .40021 L p F P
0 g
s
0 0 0 r
.24084 .41828 m .22152 .45305 L .21516 .47281 L p F P
0 g
s
0 .221 .621 r
.3851 .86409 m .36095 .85024 L .34489 .84115 L p F P
0 g
s
0 .376 .77 r
.36095 .85024 m .3851 .86409 L .39988 .8699 L p F P
0 g
s
0 .33 .666 r
.42505 .88005 m .39988 .8699 L .3851 .86409 L p F P
0 g
s
0 0 .032 r
.20043 .55092 m .2086 .51504 L .21083 .49351 L p F P
0 g
s
0 0 .186 r
.2086 .51504 m .20043 .55092 L .20038 .57267 L p F P
0 g
s
0 0 .429 r
.24768 .73991 m .23596 .71176 L .22509 .69176 L p F P
0 g
s
0 0 .561 r
.23596 .71176 m .24768 .73991 L .25994 .7576 L p F P
0 g
s
0 .149 .617 r
.34489 .84115 m .32355 .82348 L .30703 .81113 L p F P
0 g
s
0 .297 .751 r
.32355 .82348 m .34489 .84115 L .36095 .85024 L p F P
0 g
s
0 0 0 r
.30911 .32635 m .34432 .30125 L .35522 .29226 L p F P
0 g
s
0 0 0 r
.34432 .30125 m .30911 .32635 L .2975 .33857 L p F P
0 g
s
0 .483 .818 r
.39988 .8699 m .42505 .88005 L .43771 .88262 L p F P
0 g
s
0 .469 .751 r
.46223 .88936 m .43771 .88262 L .42505 .88005 L p F P
0 g
s
.096 .642 .834 r
.48859 .89384 m .51603 .89593 L .51756 .89437 L p F P
0 g
s
.141 .682 .828 r
.51603 .89593 m .54375 .8956 L .54107 .89409 L p F P
0 g
s
.141 .682 .828 r
.54107 .89409 m .51756 .89437 L .51603 .89593 L p F P
0 g
s
.212 .735 .838 r
.54375 .8956 m .57097 .89285 L .56415 .89176 L p F P
0 g
s
.212 .735 .838 r
.56415 .89176 m .54107 .89409 L .54375 .8956 L p F P
0 g
s
.513 .909 .795 r
.67416 .86054 m .69705 .84607 L .67892 .85386 L p F P
0 g
s
.513 .909 .795 r
.67892 .85386 m .65861 .86674 L .67416 .86054 L p F P
0 g
s
.73 .961 .681 r
.76564 .79124 m .78161 .7676 L .76513 .78356 L p F P
0 g
s
.73 .961 .681 r
.76513 .78356 m .75043 .80547 L .76564 .79124 L p F P
0 g
s
0 0 0 r
.25844 .38358 m .28725 .3526 L .2975 .33857 L p F P
0 g
s
0 0 0 r
.28725 .3526 m .25844 .38358 L .24876 .40021 L p F P
0 g
s
.438 .876 .836 r
.63437 .87751 m .65861 .86674 L .64186 .87101 L p F P
0 g
s
.438 .876 .836 r
.64186 .87101 m .62078 .8804 L .63437 .87751 L p F P
0 g
s
.079 .617 .856 r
.46223 .88936 m .48859 .89384 L .49429 .8926 L p F P
0 g
s
.096 .642 .834 r
.51756 .89437 m .49429 .8926 L .48859 .89384 L p F P
0 g
s
0 0 0 r
.35522 .29226 m .39549 .27298 L .40461 .2673 L p F P
0 g
s
.305 .797 .863 r
.57097 .89285 m .5969 .88774 L .5861 .88742 L p F P
0 g
s
.305 .797 .863 r
.5861 .88742 m .56415 .89176 L .57097 .89285 L p F P
0 g
s
0 0 0 r
.39549 .27298 m .35522 .29226 L .34432 .30125 L p F P
0 g
s
.629 .954 .779 r
.71373 .83653 m .73345 .81829 L .7148 .82958 L p F P
0 g
s
.629 .954 .779 r
.7148 .82958 m .69705 .84607 L .71373 .83653 L p F P
0 g
s
.882 .503 .032 r
.82653 .4434 m .80413 .40911 L .81008 .42842 L p F P
0 g
s
.882 .503 .032 r
.81008 .42842 m .83283 .46305 L .82653 .4434 L p F P
0 g
s
.667 .121 0 r
.73429 .31909 m .69689 .29516 L .70618 .30589 L p F P
0 g
s
.667 .121 0 r
.70618 .30589 m .74548 .33097 L .73429 .31909 L p F P
0 g
s
.927 .862 .429 r
.84417 .6412 m .84414 .60761 L .83744 .63003 L p F P
0 g
s
.927 .862 .429 r
.83744 .63003 m .8376 .66248 L .84417 .6412 L p F P
0 g
s
.853 .953 .604 r
.80864 .73238 m .81783 .70381 L .80469 .72353 L p F P
0 g
s
.853 .953 .604 r
.80469 .72353 m .79613 .75049 L .80864 .73238 L p F P
0 g
s
.945 .714 .247 r
.85069 .5411 m .83933 .50532 L .83939 .52765 L p F P
0 g
s
.945 .714 .247 r
.83939 .52765 m .85075 .56298 L .85069 .5411 L p F P
0 g
s
0 .116 .641 r
.30703 .81113 m .29037 .78972 L .27419 .77425 L p F P
0 g
s
0 .251 .751 r
.29037 .78972 m .30703 .81113 L .32355 .82348 L p F P
0 g
s
0 0 .375 r
.2164 .67119 m .21365 .63896 L .20697 .61685 L p F P
0 g
s
0 0 .497 r
.21365 .63896 m .2164 .67119 L .22509 .69176 L p F P
0 g
s
.091 .605 .887 r
.43771 .88262 m .46223 .88936 L .47196 .8888 L p F P
0 g
s
.079 .617 .856 r
.49429 .8926 m .47196 .8888 L .46223 .88936 L p F P
0 g
s
0 0 0 r
.21516 .47281 m .23476 .43768 L .24084 .41828 L p F P
0 g
s
0 0 .123 r
.23476 .43768 m .21516 .47281 L .21083 .49351 L p F P
0 g
s
0 0 .186 r
.20038 .57267 m .20855 .53725 L .2086 .51504 L p F P
0 g
s
0 0 .321 r
.20855 .53725 m .20038 .57267 L .20255 .5947 L p F P
0 g
s
.577 0 0 r
.68662 .2865 m .64468 .26861 L .65234 .27619 L p F P
0 g
s
.577 0 0 r
.65234 .27619 m .69689 .29516 L .68662 .2865 L p F P
0 g
s
.81 .338 0 r
.7869 .37482 m .75535 .34471 L .76381 .36027 L p F P
0 g
s
.81 .338 0 r
.76381 .36027 m .79637 .39121 L .7869 .37482 L p F P
0 g
s
0 0 .561 r
.25994 .7576 m .24896 .73103 L .23596 .71176 L p F P
0 g
s
0 .118 .669 r
.24896 .73103 m .25994 .7576 L .27419 .77425 L p F P
0 g
s
.412 .859 .896 r
.5969 .88774 m .62078 .8804 L .60627 .88121 L p F P
0 g
s
.412 .859 .896 r
.60627 .88121 m .5861 .88742 L .5969 .88774 L p F P
0 g
s
0 .376 .77 r
.39988 .8699 m .37841 .85757 L .36095 .85024 L p F P
0 g
s
.024 .505 .877 r
.37841 .85757 m .39988 .8699 L .4158 .87377 L p F P
0 g
s
0 .483 .818 r
.43771 .88262 m .4158 .87377 L .39988 .8699 L p F P
0 g
s
0 .297 .751 r
.36095 .85024 m .34171 .83426 L .32355 .82348 L p F P
0 g
s
0 .424 .849 r
.34171 .83426 m .36095 .85024 L .37841 .85757 L p F P
0 g
s
.762 .991 .776 r
.75043 .80547 m .76513 .78356 L .74679 .79824 L p F P
0 g
s
.762 .991 .776 r
.74679 .79824 m .73345 .81829 L .75043 .80547 L p F P
0 g
s
0 0 0 r
.2975 .33857 m .33446 .31228 L .34432 .30125 L p F P
0 g
s
0 0 0 r
.33446 .31228 m .2975 .33857 L .28725 .3526 L p F P
0 g
s
0 0 0 r
.24876 .40021 m .27847 .36838 L .28725 .3526 L p F P
0 g
s
0 0 .03 r
.27847 .36838 m .24876 .40021 L .24084 .41828 L p F P
0 g
s
.578 .942 .89 r
.65861 .86674 m .67892 .85386 L .65945 .85981 L p F P
0 g
s
.578 .942 .89 r
.65945 .85981 m .64186 .87101 L .65861 .86674 L p F P
0 g
s
.127 .601 .918 r
.4158 .87377 m .43771 .88262 L .45124 .88309 L p F P
0 g
s
.091 .605 .887 r
.47196 .8888 m .45124 .88309 L .43771 .88262 L p F P
0 g
s
.952 .91 .537 r
.8376 .66248 m .83744 .63003 L .82848 .6523 L p F P
0 g
s
.952 .91 .537 r
.82848 .6523 m .82882 .6834 L .8376 .66248 L p F P
0 g
s
.872 .983 .697 r
.79613 .75049 m .80469 .72353 L .78945 .7424 L p F P
0 g
s
.872 .983 .697 r
.78945 .7424 m .78161 .7676 L .79613 .75049 L p F P
0 g
s
.94 .596 .177 r
.83283 .46305 m .81008 .42842 L .81413 .44901 L p F P
0 g
s
.94 .596 .177 r
.81413 .44901 m .83713 .48374 L .83283 .46305 L p F P
0 g
s
.67 .976 .864 r
.69705 .84607 m .7148 .82958 L .69458 .83922 L p F P
0 g
s
.67 .976 .864 r
.69458 .83922 m .67892 .85386 L .69705 .84607 L p F P
0 g
s
0 0 .497 r
.22509 .69176 m .22259 .66086 L .21365 .63896 L p F P
0 g
s
0 .035 .598 r
.22259 .66086 m .22509 .69176 L .23596 .71176 L p F P
0 g
s
.981 .78 .369 r
.85075 .56298 m .83939 .52765 L .83724 .55057 L p F P
0 g
s
.981 .78 .369 r
.83724 .55057 m .84857 .5852 L .85075 .56298 L p F P
0 g
s
.52 .911 .926 r
.62078 .8804 m .64186 .87101 L .62401 .87327 L p F P
0 g
s
.52 .911 .926 r
.62401 .87327 m .60627 .88121 L .62078 .8804 L p F P
0 g
s
0 .251 .751 r
.32355 .82348 m .30839 .80387 L .29037 .78972 L p F P
0 g
s
0 .368 .833 r
.30839 .80387 m .32355 .82348 L .34171 .83426 L p F P
0 g
s
0 0 .321 r
.20255 .5947 m .21071 .55998 L .20855 .53725 L p F P
0 g
s
0 0 .435 r
.21071 .55998 m .20255 .5947 L .20697 .61685 L p F P
0 g
s
0 0 .123 r
.21083 .49351 m .23063 .4583 L .23476 .43768 L p F P
0 g
s
0 0 .256 r
.23063 .4583 m .21083 .49351 L .2086 .51504 L p F P
0 g
s
0 0 0 r
.34432 .30125 m .38707 .28082 L .39549 .27298 L p F P
0 g
s
.068 0 0 r
.38707 .28082 m .34432 .30125 L .33446 .31228 L p F P
0 g
s
.768 .257 0 r
.74548 .33097 m .70618 .30589 L .7144 .31867 L p F P
0 g
s
.768 .257 0 r
.7144 .31867 m .75535 .34471 L .74548 .33097 L p F P
0 g
s
0 .118 .669 r
.27419 .77425 m .26405 .74941 L .24896 .73103 L p F P
0 g
s
0 .236 .753 r
.26405 .74941 m .27419 .77425 L .29037 .78972 L p F P
0 g
s
.88 .446 .08 r
.79637 .39121 m .76381 .36027 L .77075 .37757 L p F P
0 g
s
.88 .446 .08 r
.77075 .37757 m .80413 .40911 L .79637 .39121 L p F P
0 g
s
.775 .997 .846 r
.73345 .81829 m .74679 .79824 L .72669 .8115 L p F P
0 g
s
.775 .997 .846 r
.72669 .8115 m .7148 .82958 L .73345 .81829 L p F P
0 g
s
.686 .146 0 r
.69689 .29516 m .65234 .27619 L .65927 .28599 L p F P
0 g
s
.686 .146 0 r
.65927 .28599 m .70618 .30589 L .69689 .29516 L p F P
0 g
s
0 .424 .849 r
.37841 .85757 m .3614 .84337 L .34171 .83426 L p F P
0 g
s
.12 .525 .914 r
.3614 .84337 m .37841 .85757 L .39718 .86303 L p F P
0 g
s
.024 .505 .877 r
.4158 .87377 m .39718 .86303 L .37841 .85757 L p F P
0 g
s
.959 .938 .625 r
.82882 .6834 m .82848 .6523 L .8173 .67425 L p F P
0 g
s
.959 .938 .625 r
.8173 .67425 m .81783 .70381 L .82882 .6834 L p F P
0 g
s
.181 .601 .942 r
.39718 .86303 m .4158 .87377 L .43277 .8756 L p F P
0 g
s
.127 .601 .918 r
.45124 .88309 m .43277 .8756 L .4158 .87377 L p F P
0 g
s
0 0 .03 r
.24084 .41828 m .27127 .38584 L .27847 .36838 L p F P
0 g
s
0 0 .171 r
.27127 .38584 m .24084 .41828 L .23476 .43768 L p F P
0 g
s
.875 .994 .77 r
.78161 .7676 m .78945 .7424 L .77219 .76027 L p F P
0 g
s
.875 .994 .77 r
.77219 .76027 m .76513 .78356 L .78161 .7676 L p F P
0 g
s
0 .035 .598 r
.23596 .71176 m .23376 .68237 L .22259 .66086 L p F P
0 g
s
0 .146 .678 r
.23376 .68237 m .23596 .71176 L .24896 .73103 L p F P
0 g
s
0 0 0 r
.28725 .3526 m .32574 .32531 L .33446 .31228 L p F P
0 g
s
.048 0 .05 r
.32574 .32531 m .28725 .3526 L .27847 .36838 L p F P
0 g
s
.996 .826 .47 r
.84857 .5852 m .83724 .55057 L .83288 .57392 L p F P
0 g
s
.996 .826 .47 r
.83288 .57392 m .84414 .60761 L .84857 .5852 L p F P
0 g
s
.973 .665 .299 r
.83713 .48374 m .81413 .44901 L .81622 .47077 L p F P
0 g
s
.973 .665 .299 r
.81622 .47077 m .83933 .50532 L .83713 .48374 L p F P
0 g
s
.618 .944 .946 r
.64186 .87101 m .65945 .85981 L .63875 .86382 L p F P
0 g
s
.618 .944 .946 r
.63875 .86382 m .62401 .87327 L .64186 .87101 L p F P
0 g
s
0 0 .435 r
.20697 .61685 m .2151 .58307 L .21071 .55998 L p F P
0 g
s
0 0 .529 r
.2151 .58307 m .20697 .61685 L .21365 .63896 L p F P
0 g
s
.689 .972 .92 r
.67892 .85386 m .69458 .83922 L .67292 .8471 L p F P
0 g
s
.689 .972 .92 r
.67292 .8471 m .65945 .85981 L .67892 .85386 L p F P
0 g
s
0 .236 .753 r
.29037 .78972 m .28114 .76674 L .26405 .74941 L p F P
0 g
s
.035 .336 .817 r
.28114 .76674 m .29037 .78972 L .30839 .80387 L p F P
0 g
s
0 .368 .833 r
.34171 .83426 m .32815 .81657 L .30839 .80387 L p F P
0 g
s
.106 .463 .889 r
.32815 .81657 m .34171 .83426 L .3614 .84337 L p F P
0 g
s
0 0 .256 r
.2086 .51504 m .2285 .48001 L .23063 .4583 L p F P
0 g
s
0 0 .367 r
.2285 .48001 m .2086 .51504 L .20855 .53725 L p F P
0 g
s
.83 .363 .088 r
.75535 .34471 m .7144 .31867 L .72144 .33348 L p F P
0 g
s
.83 .363 .088 r
.72144 .33348 m .76381 .36027 L .75535 .34471 L p F P
0 g
s
.92 .527 .21 r
.80413 .40911 m .77075 .37757 L .77608 .39653 L p F P
0 g
s
.92 .527 .21 r
.77608 .39653 m .81008 .42842 L .80413 .40911 L p F P
0 g
s
.068 0 0 r
.33446 .31228 m .37944 .29085 L .38707 .28082 L p F P
0 g
s
.18 0 .032 r
.37944 .29085 m .33446 .31228 L .32574 .32531 L p F P
0 g
s
.774 .988 .894 r
.7148 .82958 m .72669 .8115 L .70495 .82321 L p F P
0 g
s
.774 .988 .894 r
.70495 .82321 m .69458 .83922 L .7148 .82958 L p F P
0 g
s
.954 .952 .694 r
.81783 .70381 m .8173 .67425 L .80394 .69568 L p F P
0 g
s
.954 .952 .694 r
.80394 .69568 m .80469 .72353 L .81783 .70381 L p F P
0 g
s
.866 .992 .824 r
.76513 .78356 m .77219 .76027 L .75303 .77698 L p F P
0 g
s
.866 .992 .824 r
.75303 .77698 m .74679 .79824 L .76513 .78356 L p F P
0 g
s
0 .146 .678 r
.24896 .73103 m .2471 .70333 L .23376 .68237 L p F P
0 g
s
.039 .241 .742 r
.2471 .70333 m .24896 .73103 L .26405 .74941 L p F P
0 g
s
.997 .856 .552 r
.84414 .60761 m .83288 .57392 L .82629 .59752 L p F P
0 g
s
.997 .856 .552 r
.82629 .59752 m .83744 .63003 L .84414 .60761 L p F P
0 g
s
.12 .525 .914 r
.39718 .86303 m .38252 .8507 L .3614 .84337 L p F P
0 g
s
.245 .602 .952 r
.38252 .8507 m .39718 .86303 L .41715 .86654 L p F P
0 g
s
.181 .601 .942 r
.43277 .8756 m .41715 .86654 L .39718 .86303 L p F P
0 g
s
0 0 .529 r
.21365 .63896 m .22175 .60635 L .2151 .58307 L p F P
0 g
s
.017 .097 .604 r
.22175 .60635 m .21365 .63896 L .22259 .66086 L p F P
0 g
s
0 0 .171 r
.23476 .43768 m .26574 .40489 L .27127 .38584 L p F P
0 g
s
.063 0 .286 r
.26574 .40489 m .23476 .43768 L .23063 .4583 L p F P
0 g
s
.987 .715 .398 r
.83933 .50532 m .81622 .47077 L .81627 .49354 L p F P
0 g
s
.987 .715 .398 r
.81627 .49354 m .83939 .52765 L .83933 .50532 L p F P
0 g
s
.035 .336 .817 r
.30839 .80387 m .30014 .78288 L .28114 .76674 L p F P
0 g
s
.138 .42 .863 r
.30014 .78288 m .30839 .80387 L .32815 .81657 L p F P
0 g
s
.754 .262 .06 r
.70618 .30589 m .65927 .28599 L .66542 .29799 L p F P
0 g
s
.754 .262 .06 r
.66542 .29799 m .7144 .31867 L .70618 .30589 L p F P
0 g
s
.048 0 .05 r
.27847 .36838 m .31827 .34031 L .32574 .32531 L p F P
0 g
s
.143 0 .182 r
.31827 .34031 m .27847 .36838 L .27127 .38584 L p F P
0 g
s
.106 .463 .889 r
.3614 .84337 m .34953 .8277 L .32815 .81657 L p F P
0 g
s
.217 .54 .926 r
.34953 .8277 m .3614 .84337 L .38252 .8507 L p F P
0 g
s
0 0 .367 r
.20855 .53725 m .22845 .50266 L .2285 .48001 L p F P
0 g
s
.039 0 .457 r
.22845 .50266 m .20855 .53725 L .21071 .55998 L p F P
0 g
s
.694 .954 .952 r
.65945 .85981 m .67292 .8471 L .64995 .85313 L p F P
0 g
s
.694 .954 .952 r
.64995 .85313 m .63875 .86382 L .65945 .85981 L p F P
0 g
s
.94 .956 .75 r
.80469 .72353 m .80394 .69568 L .78848 .71643 L p F P
0 g
s
.94 .956 .75 r
.78848 .71643 m .78945 .7424 L .80469 .72353 L p F P
0 g
s
.764 .969 .926 r
.69458 .83922 m .70495 .82321 L .68173 .83325 L p F P
0 g
s
.764 .969 .926 r
.68173 .83325 m .67292 .8471 L .69458 .83922 L p F P
0 g
s
.039 .241 .742 r
.26405 .74941 m .26255 .72356 L .2471 .70333 L p F P
0 g
s
.126 .324 .791 r
.26255 .72356 m .26405 .74941 L .28114 .76674 L p F P
0 g
s
.85 .98 .865 r
.74679 .79824 m .75303 .77698 L .73209 .79238 L p F P
0 g
s
.85 .98 .865 r
.73209 .79238 m .72669 .8115 L .74679 .79824 L p F P
0 g
s
.941 .588 .316 r
.81008 .42842 m .77608 .39653 L .77971 .41703 L p F P
0 g
s
.941 .588 .316 r
.77971 .41703 m .81413 .44901 L .81008 .42842 L p F P
0 g
s
.99 .875 .619 r
.83744 .63003 m .82629 .59752 L .81748 .62118 L p F P
0 g
s
.99 .875 .619 r
.81748 .62118 m .82848 .6523 L .83744 .63003 L p F P
0 g
s
.866 .444 .211 r
.76381 .36027 m .72144 .33348 L .72723 .35024 L p F P
0 g
s
.866 .444 .211 r
.72723 .35024 m .77075 .37757 L .76381 .36027 L p F P
0 g
s
.017 .097 .604 r
.22259 .66086 m .23063 .62963 L .22175 .60635 L p F P
0 g
s
.097 .184 .666 r
.23063 .62963 m .22259 .66086 L .23376 .68237 L p F P
0 g
s
.138 .42 .863 r
.32815 .81657 m .32092 .79768 L .30014 .78288 L p F P
0 g
s
.228 .491 .896 r
.32092 .79768 m .32815 .81657 L .34953 .8277 L p F P
0 g
s
.18 0 .032 r
.32574 .32531 m .37269 .30305 L .37944 .29085 L p F P
0 g
s
.266 0 .164 r
.37269 .30305 m .32574 .32531 L .31827 .34031 L p F P
0 g
s
.989 .75 .479 r
.83939 .52765 m .81627 .49354 L .81424 .51715 L p F P
0 g
s
.989 .75 .479 r
.81424 .51715 m .83724 .55057 L .83939 .52765 L p F P
0 g
s
.245 .602 .952 r
.41715 .86654 m .40493 .85616 L .38252 .8507 L p F P
0 g
s
.063 0 .286 r
.23063 .4583 m .26198 .42542 L .26574 .40489 L p F P
0 g
s
.141 0 .38 r
.26198 .42542 m .23063 .4583 L .2285 .48001 L p F P
0 g
s
.039 0 .457 r
.21071 .55998 m .23051 .52609 L .22845 .50266 L p F P
0 g
s
.114 .074 .531 r
.23051 .52609 m .21071 .55998 L .2151 .58307 L p F P
0 g
s
.217 .54 .926 r
.38252 .8507 m .37239 .83713 L .34953 .8277 L p F P
0 g
s
.311 .602 .949 r
.37239 .83713 m .38252 .8507 L .40493 .85616 L p F P
0 g
s
.921 .953 .794 r
.78945 .7424 m .78848 .71643 L .77101 .73632 L p F P
0 g
s
.921 .953 .794 r
.77101 .73632 m .77219 .76027 L .78945 .7424 L p F P
0 g
s
.143 0 .182 r
.27127 .38584 m .31213 .35722 L .31827 .34031 L p F P
0 g
s
.219 0 .288 r
.31213 .35722 m .27127 .38584 L .26574 .40489 L p F P
0 g
s
.126 .324 .791 r
.28114 .76674 m .28002 .74289 L .26255 .72356 L p F P
0 g
s
.202 .395 .83 r
.28002 .74289 m .28114 .76674 L .30014 .78288 L p F P
0 g
s
.829 .964 .895 r
.72669 .8115 m .73209 .79238 L .7095 .80632 L p F P
0 g
s
.829 .964 .895 r
.7095 .80632 m .70495 .82321 L .72669 .8115 L p F P
0 g
s
.796 .35 .186 r
.7144 .31867 m .66542 .29799 L .67069 .31218 L p F P
0 g
s
.796 .35 .186 r
.67069 .31218 m .72144 .33348 L .7144 .31867 L p F P
0 g
s
.747 .944 .946 r
.67292 .8471 m .68173 .83325 L .65718 .84152 L p F P
0 g
s
.747 .944 .946 r
.65718 .84152 m .64995 .85313 L .67292 .8471 L p F P
0 g
s
.976 .886 .674 r
.82848 .6523 m .81748 .62118 L .8065 .64471 L p F P
0 g
s
.976 .886 .674 r
.8065 .64471 m .8173 .67425 L .82848 .6523 L p F P
0 g
s
.097 .184 .666 r
.23376 .68237 m .2417 .65272 L .23063 .62963 L p F P
0 g
s
.166 .259 .716 r
.2417 .65272 m .23376 .68237 L .2471 .70333 L p F P
0 g
s
.228 .491 .896 r
.34953 .8277 m .34334 .811 L .32092 .79768 L p F P
0 g
s
.305 .551 .92 r
.34334 .811 m .34953 .8277 L .37239 .83713 L p F P
0 g
s
.949 .633 .401 r
.81413 .44901 m .77971 .41703 L .78158 .43894 L p F P
0 g
s
.949 .633 .401 r
.78158 .43894 m .81622 .47077 L .81413 .44901 L p F P
0 g
s
.984 .776 .545 r
.83724 .55057 m .81424 .51715 L .81012 .54143 L p F P
0 g
s
.984 .776 .545 r
.81012 .54143 m .83288 .57392 L .83724 .55057 L p F P
0 g
s
.114 .074 .531 r
.2151 .58307 m .23471 .55012 L .23051 .52609 L p F P
0 g
s
.177 .153 .591 r
.23471 .55012 m .2151 .58307 L .22175 .60635 L p F P
0 g
s
.885 .504 .31 r
.77075 .37757 m .72723 .35024 L .73167 .36887 L p F P
0 g
s
.885 .504 .31 r
.73167 .36887 m .77608 .39653 L .77075 .37757 L p F P
0 g
s
.899 .946 .829 r
.77219 .76027 m .77101 .73632 L .75166 .75517 L p F P
0 g
s
.899 .946 .829 r
.75166 .75517 m .75303 .77698 L .77219 .76027 L p F P
0 g
s
.141 0 .38 r
.2285 .48001 m .26004 .44729 L .26198 .42542 L p F P
0 g
s
.205 .063 .456 r
.26004 .44729 m .2285 .48001 L .22845 .50266 L p F P
0 g
s
.311 .602 .949 r
.40493 .85616 m .39658 .84477 L .37239 .83713 L p F P
0 g
s
.202 .395 .83 r
.30014 .78288 m .29938 .76115 L .28002 .74289 L p F P
0 g
s
.269 .457 .861 r
.29938 .76115 m .30014 .78288 L .32092 .79768 L p F P
0 g
s
.805 .943 .916 r
.70495 .82321 m .7095 .80632 L .68545 .81868 L p F P
0 g
s
.805 .943 .916 r
.68545 .81868 m .68173 .83325 L .70495 .82321 L p F P
0 g
s
.266 0 .164 r
.31827 .34031 m .3669 .31739 L .37269 .30305 L p F P
0 g
s
.331 .015 .269 r
.3669 .31739 m .31827 .34031 L .31213 .35722 L p F P
0 g
s
.959 .891 .719 r
.8173 .67425 m .8065 .64471 L .79341 .66791 L p F P
0 g
s
.959 .891 .719 r
.79341 .66791 m .80394 .69568 L .8173 .67425 L p F P
0 g
s
.166 .259 .716 r
.2471 .70333 m .25492 .67544 L .2417 .65272 L p F P
0 g
s
.226 .326 .757 r
.25492 .67544 m .2471 .70333 L .26255 .72356 L p F P
0 g
s
.305 .551 .92 r
.37239 .83713 m .36724 .82271 L .34334 .811 L p F P
0 g
s
.372 .601 .936 r
.36724 .82271 m .37239 .83713 L .39658 .84477 L p F P
0 g
s
.219 0 .288 r
.26574 .40489 m .30742 .37593 L .31213 .35722 L p F P
0 g
s
.279 .048 .373 r
.30742 .37593 m .26574 .40489 L .26198 .42542 L p F P
0 g
s
.874 .935 .857 r
.75303 .77698 m .75166 .75517 L .73056 .77281 L p F P
0 g
s
.874 .935 .857 r
.73056 .77281 m .73209 .79238 L .75303 .77698 L p F P
0 g
s
.973 .794 .6 r
.83288 .57392 m .81012 .54143 L .8039 .56619 L p F P
0 g
s
.973 .794 .6 r
.8039 .56619 m .82629 .59752 L .83288 .57392 L p F P
0 g
s
.819 .416 .286 r
.72144 .33348 m .67069 .31218 L .67502 .3285 L p F P
0 g
s
.819 .416 .286 r
.67502 .3285 m .72723 .35024 L .72144 .33348 L p F P
0 g
s
.949 .667 .471 r
.81622 .47077 m .78158 .43894 L .78162 .4621 L p F P
0 g
s
.949 .667 .471 r
.78162 .4621 m .81627 .49354 L .81622 .47077 L p F P
0 g
s
.269 .457 .861 r
.32092 .79768 m .32051 .77817 L .29938 .76115 L p F P
0 g
s
.327 .511 .885 r
.32051 .77817 m .32092 .79768 L .34334 .811 L p F P
0 g
s
.177 .153 .591 r
.22175 .60635 m .24106 .57456 L .23471 .55012 L p F P
0 g
s
.231 .222 .642 r
.24106 .57456 m .22175 .60635 L .23063 .62963 L p F P
0 g
s
.779 .92 .932 r
.68173 .83325 m .68545 .81868 L .66009 .82934 L p F P
0 g
s
.779 .92 .932 r
.66009 .82934 m .65718 .84152 L .68173 .83325 L p F P
0 g
s
.205 .063 .456 r
.22845 .50266 m .25999 .47035 L .26004 .44729 L p F P
0 g
s
.258 .137 .518 r
.25999 .47035 m .22845 .50266 L .23051 .52609 L p F P
0 g
s
.226 .326 .757 r
.26255 .72356 m .27019 .69758 L .25492 .67544 L p F P
0 g
s
.279 .384 .791 r
.27019 .69758 m .26255 .72356 L .28002 .74289 L p F P
0 g
s
.939 .892 .757 r
.80394 .69568 m .79341 .66791 L .77829 .69058 L p F P
0 g
s
.939 .892 .757 r
.77829 .69058 m .78848 .71643 L .80394 .69568 L p F P
0 g
s
.894 .551 .389 r
.77608 .39653 m .73167 .36887 L .7347 .38928 L p F P
0 g
s
.894 .551 .389 r
.7347 .38928 m .77971 .41703 L .77608 .39653 L p F P
0 g
s
.372 .601 .936 r
.39658 .84477 m .39246 .8327 L .36724 .82271 L p F P
0 g
s
.849 .921 .88 r
.73209 .79238 m .73056 .77281 L .70788 .78909 L p F P
0 g
s
.849 .921 .88 r
.70788 .78909 m .7095 .80632 L .73209 .79238 L p F P
0 g
s
.327 .511 .885 r
.34334 .811 m .34325 .7938 L .32051 .77817 L p F P
0 g
s
.38 .559 .904 r
.34325 .7938 m .34334 .811 L .36724 .82271 L p F P
0 g
s
.331 .015 .269 r
.31213 .35722 m .36214 .33382 L .3669 .31739 L p F P
0 g
s
.381 .098 .353 r
.36214 .33382 m .31213 .35722 L .30742 .37593 L p F P
0 g
s
.96 .807 .646 r
.82629 .59752 m .8039 .56619 L .79561 .59122 L p F P
0 g
s
.96 .807 .646 r
.79561 .59122 m .81748 .62118 L .82629 .59752 L p F P
0 g
s
.231 .222 .642 r
.23063 .62963 m .24953 .59923 L .24106 .57456 L p F P
0 g
s
.278 .282 .684 r
.24953 .59923 m .23063 .62963 L .2417 .65272 L p F P
0 g
s
.279 .048 .373 r
.26198 .42542 m .3042 .39636 L .30742 .37593 L p F P
0 g
s
.327 .123 .442 r
.3042 .39636 m .26198 .42542 L .26004 .44729 L p F P
0 g
s
.279 .384 .791 r
.28002 .74289 m .28742 .71897 L .27019 .69758 L p F P
0 g
s
.326 .436 .82 r
.28742 .71897 m .28002 .74289 L .29938 .76115 L p F P
0 g
s
.918 .891 .789 r
.78848 .71643 m .77829 .69058 L .76123 .71253 L p F P
0 g
s
.918 .891 .789 r
.76123 .71253 m .77101 .73632 L .78848 .71643 L p F P
0 g
s
.944 .693 .528 r
.81627 .49354 m .78162 .4621 L .77981 .48636 L p F P
0 g
s
.944 .693 .528 r
.77981 .48636 m .81424 .51715 L .81627 .49354 L p F P
0 g
s
.822 .906 .898 r
.7095 .80632 m .70788 .78909 L .68379 .80386 L p F P
0 g
s
.822 .906 .898 r
.68379 .80386 m .68545 .81868 L .7095 .80632 L p F P
0 g
s
.258 .137 .518 r
.23051 .52609 m .26187 .49443 L .25999 .47035 L p F P
0 g
s
.302 .201 .57 r
.26187 .49443 m .23051 .52609 L .23471 .55012 L p F P
0 g
s
.38 .559 .904 r
.36724 .82271 m .36741 .80791 L .34325 .7938 L p F P
0 g
s
.427 .602 .919 r
.36741 .80791 m .36724 .82271 L .39246 .8327 L p F P
0 g
s
.832 .467 .364 r
.72723 .35024 m .67502 .3285 L .67835 .34686 L p F P
0 g
s
.832 .467 .364 r
.67835 .34686 m .73167 .36887 L .72723 .35024 L p F P
0 g
s
.326 .436 .82 r
.29938 .76115 m .30648 .7394 L .28742 .71897 L p F P
0 g
s
.369 .483 .845 r
.30648 .7394 m .29938 .76115 L .32051 .77817 L p F P
0 g
s
.278 .282 .684 r
.2417 .65272 m .26008 .6239 L .24953 .59923 L p F P
0 g
s
.32 .335 .72 r
.26008 .6239 m .2417 .65272 L .25492 .67544 L p F P
0 g
s
.896 .586 .453 r
.77971 .41703 m .7347 .38928 L .73626 .41131 L p F P
0 g
s
.896 .586 .453 r
.73626 .41131 m .78158 .43894 L .77971 .41703 L p F P
0 g
s
.895 .887 .816 r
.77101 .73632 m .76123 .71253 L .74239 .73355 L p F P
0 g
s
.895 .887 .816 r
.74239 .73355 m .75166 .75517 L .77101 .73632 L p F P
0 g
s
.945 .816 .685 r
.81748 .62118 m .79561 .59122 L .78527 .61631 L p F P
0 g
s
.945 .816 .685 r
.78527 .61631 m .8065 .64471 L .81748 .62118 L p F P
0 g
s
.794 .89 .914 r
.68545 .81868 m .68379 .80386 L .65848 .81699 L p F P
0 g
s
.794 .89 .914 r
.65848 .81699 m .66009 .82934 L .68545 .81868 L p F P
0 g
s
.427 .602 .919 r
.39246 .8327 m .39282 .82036 L .36741 .80791 L p F P
0 g
s
.327 .123 .442 r
.26004 .44729 m .30255 .41836 L .3042 .39636 L p F P
0 g
s
.367 .186 .499 r
.30255 .41836 m .26004 .44729 L .25999 .47035 L p F P
0 g
s
.936 .713 .576 r
.81424 .51715 m .77981 .48636 L .77612 .51151 L p F P
0 g
s
.936 .713 .576 r
.77612 .51151 m .81012 .54143 L .81424 .51715 L p F P
0 g
s
.369 .483 .845 r
.32051 .77817 m .32722 .7587 L .30648 .7394 L p F P
0 g
s
.407 .526 .866 r
.32722 .7587 m .32051 .77817 L .34325 .7938 L p F P
0 g
s
.381 .098 .353 r
.30742 .37593 m .35848 .35225 L .36214 .33382 L p F P
0 g
s
.42 .166 .42 r
.35848 .35225 m .30742 .37593 L .3042 .39636 L p F P
0 g
s
.302 .201 .57 r
.23471 .55012 m .26569 .51936 L .26187 .49443 L p F P
0 g
s
.34 .256 .614 r
.26569 .51936 m .23471 .55012 L .24106 .57456 L p F P
0 g
s
.872 .881 .839 r
.75166 .75517 m .74239 .73355 L .72189 .75348 L p F P
0 g
s
.872 .881 .839 r
.72189 .75348 m .73056 .77281 L .75166 .75517 L p F P
0 g
s
.32 .335 .72 r
.25492 .67544 m .27266 .64837 L .26008 .6239 L p F P
0 g
s
.356 .383 .751 r
.27266 .64837 m .25492 .67544 L .27019 .69758 L p F P
0 g
s
.929 .823 .719 r
.8065 .64471 m .78527 .61631 L .77297 .64125 L p F P
0 g
s
.929 .823 .719 r
.77297 .64125 m .79341 .66791 L .8065 .64471 L p F P
0 g
s
.407 .526 .866 r
.34325 .7938 m .34947 .7767 L .32722 .7587 L p F P
0 g
s
.443 .566 .884 r
.34947 .7767 m .34325 .7938 L .36741 .80791 L p F P
0 g
s
.848 .875 .86 r
.73056 .77281 m .72189 .75348 L .69992 .77211 L p F P
0 g
s
.848 .875 .86 r
.69992 .77211 m .70788 .78909 L .73056 .77281 L p F P
0 g
s
.838 .508 .428 r
.73167 .36887 m .67835 .34686 L .68062 .36718 L p F P
0 g
s
.838 .508 .428 r
.68062 .36718 m .7347 .38928 L .73167 .36887 L p F P
0 g
s
.894 .615 .506 r
.78158 .43894 m .73626 .41131 L .7363 .43483 L p F P
0 g
s
.894 .615 .506 r
.7363 .43483 m .78162 .4621 L .78158 .43894 L p F P
0 g
s
.443 .566 .884 r
.36741 .80791 m .37305 .79323 L .34947 .7767 L p F P
0 g
s
.475 .604 .9 r
.37305 .79323 m .36741 .80791 L .39282 .82036 L p F P
0 g
s
.356 .383 .751 r
.27019 .69758 m .28717 .67242 L .27266 .64837 L p F P
0 g
s
.389 .427 .779 r
.28717 .67242 m .27019 .69758 L .28742 .71897 L p F P
0 g
s
.926 .729 .617 r
.81012 .54143 m .77612 .51151 L .77055 .53736 L p F P
0 g
s
.926 .729 .617 r
.77055 .53736 m .8039 .56619 L .81012 .54143 L p F P
0 g
s
.34 .256 .614 r
.24106 .57456 m .27147 .54492 L .26569 .51936 L p F P
0 g
s
.372 .305 .652 r
.27147 .54492 m .24106 .57456 L .24953 .59923 L p F P
0 g
s
.823 .866 .878 r
.70788 .78909 m .69992 .77211 L .67665 .78931 L p F P
0 g
s
.823 .866 .878 r
.67665 .78931 m .68379 .80386 L .70788 .78909 L p F P
0 g
s
.912 .827 .749 r
.79341 .66791 m .77297 .64125 L .75878 .66581 L p F P
0 g
s
.912 .827 .749 r
.75878 .66581 m .77829 .69058 L .79341 .66791 L p F P
0 g
s
.367 .186 .499 r
.25999 .47035 m .30251 .44179 L .30255 .41836 L p F P
0 g
s
.399 .24 .546 r
.30251 .44179 m .25999 .47035 L .26187 .49443 L p F P
0 g
s
.475 .604 .9 r
.39282 .82036 m .39776 .80816 L .37305 .79323 L p F P
0 g
s
.797 .857 .895 r
.68379 .80386 m .67665 .78931 L .65229 .8049 L p F P
0 g
s
.797 .857 .895 r
.65229 .8049 m .65848 .81699 L .68379 .80386 L p F P
0 g
s
.42 .166 .42 r
.3042 .39636 m .35599 .37259 L .35848 .35225 L p F P
0 g
s
.452 .223 .475 r
.35599 .37259 m .3042 .39636 L .30255 .41836 L p F P
0 g
s
.389 .427 .779 r
.28742 .71897 m .30349 .69585 L .28717 .67242 L p F P
0 g
s
.418 .467 .804 r
.30349 .69585 m .28742 .71897 L .30648 .7394 L p F P
0 g
s
.894 .829 .775 r
.77829 .69058 m .75878 .66581 L .74281 .68978 L p F P
0 g
s
.894 .829 .775 r
.74281 .68978 m .76123 .71253 L .77829 .69058 L p F P
0 g
s
.372 .305 .652 r
.24953 .59923 m .27916 .5709 L .27147 .54492 L p F P
0 g
s
.401 .349 .685 r
.27916 .5709 m .24953 .59923 L .26008 .6239 L p F P
0 g
s
.915 .742 .653 r
.8039 .56619 m .77055 .53736 L .76313 .56368 L p F P
0 g
s
.915 .742 .653 r
.76313 .56368 m .79561 .59122 L .8039 .56619 L p F P
0 g
s
.418 .467 .804 r
.30648 .7394 m .32151 .71843 L .30349 .69585 L p F P
0 g
s
.446 .504 .826 r
.32151 .71843 m .30648 .7394 L .32722 .7587 L p F P
0 g
s
.89 .638 .551 r
.78162 .4621 m .7363 .43483 L .73479 .45965 L p F P
0 g
s
.89 .638 .551 r
.73479 .45965 m .77981 .48636 L .78162 .4621 L p F P
0 g
s
.841 .54 .481 r
.7347 .38928 m .68062 .36718 L .68179 .38931 L p F P
0 g
s
.841 .54 .481 r
.68179 .38931 m .73626 .41131 L .7347 .38928 L p F P
0 g
s
.876 .83 .799 r
.76123 .71253 m .74281 .68978 L .7252 .71294 L p F P
0 g
s
.876 .83 .799 r
.7252 .71294 m .74239 .73355 L .76123 .71253 L p F P
0 g
s
.399 .24 .546 r
.26187 .49443 m .30411 .46647 L .30251 .44179 L p F P
0 g
s
.427 .287 .587 r
.30411 .46647 m .26187 .49443 L .26569 .51936 L p F P
0 g
s
.446 .504 .826 r
.32722 .7587 m .34107 .73998 L .32151 .71843 L p F P
0 g
s
.471 .54 .846 r
.34107 .73998 m .32722 .7587 L .34947 .7767 L p F P
0 g
s
.471 .54 .846 r
.34947 .7767 m .36201 .7603 L .34107 .73998 L p F P
0 g
s
.495 .574 .865 r
.36201 .7603 m .34947 .7767 L .37305 .79323 L p F P
0 g
s
.401 .349 .685 r
.26008 .6239 m .28874 .59708 L .27916 .5709 L p F P
0 g
s
.426 .389 .714 r
.28874 .59708 m .26008 .6239 L .27266 .64837 L p F P
0 g
s
.856 .83 .821 r
.74239 .73355 m .7252 .71294 L .70611 .73509 L p F P
0 g
s
.856 .83 .821 r
.70611 .73509 m .72189 .75348 L .74239 .73355 L p F P
0 g
s
.495 .574 .865 r
.37305 .79323 m .38412 .7792 L .36201 .7603 L p F P
0 g
s
.517 .607 .882 r
.38412 .7792 m .37305 .79323 L .39776 .80816 L p F P
0 g
s
.517 .607 .882 r
.39776 .80816 m .40723 .79653 L .38412 .7792 L p F P
0 g
s
.904 .753 .684 r
.79561 .59122 m .76313 .56368 L .75389 .59025 L p F P
0 g
s
.904 .753 .684 r
.75389 .59025 m .78527 .61631 L .79561 .59122 L p F P
0 g
s
.452 .223 .475 r
.30255 .41836 m .35471 .39469 L .35599 .37259 L p F P
0 g
s
.477 .271 .521 r
.35471 .39469 m .30255 .41836 L .30251 .44179 L p F P
0 g
s
.836 .829 .841 r
.72189 .75348 m .70611 .73509 L .68568 .75602 L p F P
0 g
s
.836 .829 .841 r
.68568 .75602 m .69992 .77211 L .72189 .75348 L p F P
0 g
s
.884 .657 .59 r
.77981 .48636 m .73479 .45965 L .7317 .48557 L p F P
0 g
s
.884 .657 .59 r
.7317 .48557 m .77612 .51151 L .77981 .48636 L p F P
0 g
s
.792 .824 .877 r
.64161 .79351 m .65229 .8049 L .67665 .78931 L p F P
0 g
s
.815 .827 .86 r
.69992 .77211 m .68568 .75602 L .66412 .77555 L p F P
0 g
s
.815 .827 .86 r
.66412 .77555 m .67665 .78931 L .69992 .77211 L p F P
0 g
s
.792 .824 .877 r
.67665 .78931 m .66412 .77555 L .64161 .79351 L p F P
0 g
s
.426 .389 .714 r
.27266 .64837 m .30014 .62322 L .28874 .59708 L p F P
0 g
s
.449 .426 .741 r
.30014 .62322 m .27266 .64837 L .28717 .67242 L p F P
0 g
s
.427 .287 .587 r
.26569 .51936 m .30738 .49219 L .30411 .46647 L p F P
0 g
s
.45 .328 .622 r
.30738 .49219 m .26569 .51936 L .27147 .54492 L p F P
0 g
s
.891 .762 .712 r
.78527 .61631 m .75389 .59025 L .74291 .61682 L p F P
0 g
s
.891 .762 .712 r
.74291 .61682 m .77297 .64125 L .78527 .61631 L p F P
0 g
s
.84 .567 .525 r
.73626 .41131 m .68179 .38931 L .68181 .4131 L p F P
0 g
s
.84 .567 .525 r
.68181 .4131 m .7363 .43483 L .73626 .41131 L p F P
0 g
s
.449 .426 .741 r
.28717 .67242 m .31326 .64909 L .30014 .62322 L p F P
0 g
s
.47 .46 .765 r
.31326 .64909 m .28717 .67242 L .30349 .69585 L p F P
0 g
s
.477 .271 .521 r
.30251 .44179 m .35467 .41842 L .35471 .39469 L p F P
0 g
s
.498 .313 .56 r
.35467 .41842 m .30251 .44179 L .30411 .46647 L p F P
0 g
s
.878 .769 .738 r
.77297 .64125 m .74291 .61682 L .73027 .64316 L p F P
0 g
s
.878 .769 .738 r
.73027 .64316 m .75878 .66581 L .77297 .64125 L p F P
0 g
s
.877 .673 .623 r
.77612 .51151 m .7317 .48557 L .72706 .51238 L p F P
0 g
s
.877 .673 .623 r
.72706 .51238 m .77055 .53736 L .77612 .51151 L p F P
0 g
s
.554 .613 .866 r
.40039 .76635 m .38412 .7792 L .40723 .79653 L p F P
0 g
s
.554 .613 .866 r
.40723 .79653 m .421 .78591 L .40039 .76635 L p F P
0 g
s
.45 .328 .622 r
.27147 .54492 m .3123 .51876 L .30738 .49219 L p F P
0 g
s
.47 .365 .653 r
.3123 .51876 m .27147 .54492 L .27916 .5709 L p F P
0 g
s
.47 .46 .765 r
.30349 .69585 m .32801 .67445 L .31326 .64909 L p F P
0 g
s
.489 .492 .787 r
.32801 .67445 m .30349 .69585 L .32151 .71843 L p F P
0 g
s
.539 .584 .848 r
.3806 .74523 m .36201 .7603 L .38412 .7792 L p F P
0 g
s
.539 .584 .848 r
.38412 .7792 m .40039 .76635 L .3806 .74523 L p F P
0 g
s
.489 .492 .787 r
.32151 .71843 m .34425 .69908 L .32801 .67445 L p F P
0 g
s
.506 .524 .808 r
.34425 .69908 m .32151 .71843 L .34107 .73998 L p F P
0 g
s
.781 .793 .862 r
.62673 .78324 m .64161 .79351 L .66412 .77555 L p F P
0 g
s
.864 .775 .761 r
.75878 .66581 m .73027 .64316 L .71608 .66902 L p F P
0 g
s
.864 .775 .761 r
.71608 .66902 m .74281 .68978 L .75878 .66581 L p F P
0 g
s
.523 .554 .828 r
.36183 .72274 m .34107 .73998 L .36201 .7603 L p F P
0 g
s
.523 .554 .828 r
.36201 .7603 m .3806 .74523 L .36183 .72274 L p F P
0 g
s
.506 .524 .808 r
.34107 .73998 m .36183 .72274 L .34425 .69908 L p F P
0 g
s
.838 .589 .563 r
.7363 .43483 m .68181 .4131 L .68068 .43837 L p F P
0 g
s
.838 .589 .563 r
.68068 .43837 m .73479 .45965 L .7363 .43483 L p F P
0 g
s
.801 .791 .843 r
.64651 .76311 m .66412 .77555 L .68568 .75602 L p F P
0 g
s
.781 .793 .862 r
.66412 .77555 m .64651 .76311 L .62673 .78324 L p F P
0 g
s
.85 .78 .783 r
.74281 .68978 m .71608 .66902 L .70045 .69418 L p F P
0 g
s
.85 .78 .783 r
.70045 .69418 m .7252 .71294 L .74281 .68978 L p F P
0 g
s
.47 .365 .653 r
.27916 .5709 m .31886 .54593 L .3123 .51876 L p F P
0 g
s
.488 .399 .681 r
.31886 .54593 m .27916 .5709 L .28874 .59708 L p F P
0 g
s
.869 .687 .653 r
.77055 .53736 m .72706 .51238 L .72087 .53984 L p F P
0 g
s
.869 .687 .653 r
.72087 .53984 m .76313 .56368 L .77055 .53736 L p F P
0 g
s
.818 .788 .824 r
.66551 .74143 m .68568 .75602 L .70611 .73509 L p F P
0 g
s
.801 .791 .843 r
.68568 .75602 m .66551 .74143 L .64651 .76311 L p F P
0 g
s
.835 .785 .804 r
.7252 .71294 m .70045 .69418 L .68354 .71838 L p F P
0 g
s
.835 .785 .804 r
.68354 .71838 m .70611 .73509 L .7252 .71294 L p F P
0 g
s
.498 .313 .56 r
.30411 .46647 m .35592 .44358 L .35467 .41842 L p F P
0 g
s
.516 .35 .594 r
.35592 .44358 m .30411 .46647 L .30738 .49219 L p F P
0 g
s
.818 .788 .824 r
.70611 .73509 m .68354 .71838 L .66551 .74143 L p F P
0 g
s
.587 .621 .853 r
.42136 .7552 m .40039 .76635 L .421 .78591 L p F P
0 g
s
.587 .621 .853 r
.421 .78591 m .43864 .77672 L .42136 .7552 L p F P
0 g
s
.488 .399 .681 r
.28874 .59708 m .32701 .57346 L .31886 .54593 L p F P
0 g
s
.505 .431 .707 r
.32701 .57346 m .28874 .59708 L .30014 .62322 L p F P
0 g
s
.861 .699 .68 r
.76313 .56368 m .72087 .53984 L .71318 .56771 L p F P
0 g
s
.861 .699 .68 r
.71318 .56771 m .75389 .59025 L .76313 .56368 L p F P
0 g
s
.835 .608 .596 r
.73479 .45965 m .68068 .43837 L .67837 .46492 L p F P
0 g
s
.835 .608 .596 r
.67837 .46492 m .7317 .48557 L .73479 .45965 L p F P
0 g
s
.768 .764 .85 r
.60812 .77451 m .62673 .78324 L .64651 .76311 L p F P
0 g
s
.577 .594 .834 r
.40473 .73213 m .3806 .74523 L .40039 .76635 L p F P
0 g
s
.577 .594 .834 r
.40039 .76635 m .42136 .7552 L .40473 .73213 L p F P
0 g
s
.505 .431 .707 r
.30014 .62322 m .3367 .6011 L .32701 .57346 L p F P
0 g
s
.519 .46 .73 r
.3367 .6011 m .30014 .62322 L .31326 .64909 L p F P
0 g
s
.516 .35 .594 r
.30738 .49219 m .35845 .46997 L .35592 .44358 L p F P
0 g
s
.531 .382 .625 r
.35845 .46997 m .30738 .49219 L .3123 .51876 L p F P
0 g
s
.852 .71 .705 r
.75389 .59025 m .71318 .56771 L .70404 .59573 L p F P
0 g
s
.852 .71 .705 r
.70404 .59573 m .74291 .61682 L .75389 .59025 L p F P
0 g
s
.567 .568 .814 r
.38892 .70771 m .36183 .72274 L .3806 .74523 L p F P
0 g
s
.567 .568 .814 r
.3806 .74523 m .40473 .73213 L .38892 .70771 L p F P
0 g
s
.783 .758 .83 r
.62436 .75251 m .64651 .76311 L .66551 .74143 L p F P
0 g
s
.768 .764 .85 r
.64651 .76311 m .62436 .75251 L .60812 .77451 L p F P
0 g
s
.519 .46 .73 r
.31326 .64909 m .34784 .62861 L .3367 .6011 L p F P
0 g
s
.532 .488 .753 r
.34784 .62861 m .31326 .64909 L .32801 .67445 L p F P
0 g
s
.616 .631 .843 r
.44634 .74621 m .42136 .7552 L .43864 .77672 L p F P
0 g
s
.616 .631 .843 r
.43864 .77672 m .45956 .76933 L .44634 .74621 L p F P
0 g
s
.556 .542 .794 r
.37407 .68216 m .34425 .69908 L .36183 .72274 L p F P
0 g
s
.556 .542 .794 r
.36183 .72274 m .38892 .70771 L .37407 .68216 L p F P
0 g
s
.532 .488 .753 r
.32801 .67445 m .36034 .65571 L .34784 .62861 L p F P
0 g
s
.545 .516 .774 r
.36034 .65571 m .32801 .67445 L .34425 .69908 L p F P
0 g
s
.545 .516 .774 r
.34425 .69908 m .37407 .68216 L .36034 .65571 L p F P
0 g
s
.831 .625 .625 r
.7317 .48557 m .67837 .46492 L .67489 .49251 L p F P
0 g
s
.831 .625 .625 r
.67489 .49251 m .72706 .51238 L .7317 .48557 L p F P
0 g
s
.843 .72 .728 r
.74291 .61682 m .70404 .59573 L .69354 .62363 L p F P
0 g
s
.843 .72 .728 r
.69354 .62363 m .73027 .64316 L .74291 .61682 L p F P
0 g
s
.797 .752 .811 r
.63999 .72896 m .66551 .74143 L .68354 .71838 L p F P
0 g
s
.783 .758 .83 r
.66551 .74143 m .63999 .72896 L .62436 .75251 L p F P
0 g
s
.751 .738 .84 r
.58642 .76767 m .60812 .77451 L .62436 .75251 L p F P
0 g
s
.531 .382 .625 r
.3123 .51876 m .36227 .49737 L .35845 .46997 L p F P
0 g
s
.544 .412 .652 r
.36227 .49737 m .3123 .51876 L .31886 .54593 L p F P
0 g
s
.833 .729 .75 r
.73027 .64316 m .69354 .62363 L .68177 .65116 L p F P
0 g
s
.833 .729 .75 r
.68177 .65116 m .71608 .66902 L .73027 .64316 L p F P
0 g
s
.81 .744 .791 r
.65486 .70407 m .68354 .71838 L .70045 .69418 L p F P
0 g
s
.797 .752 .811 r
.68354 .71838 m .65486 .70407 L .63999 .72896 L p F P
0 g
s
.822 .737 .771 r
.71608 .66902 m .68177 .65116 L .66884 .67806 L p F P
0 g
s
.822 .737 .771 r
.66884 .67806 m .70045 .69418 L .71608 .66902 L p F P
0 g
s
.81 .744 .791 r
.70045 .69418 m .66884 .67806 L .65486 .70407 L p F P
0 g
s
.611 .607 .823 r
.43359 .72154 m .40473 .73213 L .42136 .7552 L p F P
0 g
s
.611 .607 .823 r
.42136 .7552 m .44634 .74621 L .43359 .72154 L p F P
0 g
s
.826 .64 .652 r
.72706 .51238 m .67489 .49251 L .67026 .52089 L p F P
0 g
s
.826 .64 .652 r
.67026 .52089 m .72087 .53984 L .72706 .51238 L p F P
0 g
s
.544 .412 .652 r
.31886 .54593 m .36736 .52553 L .36227 .49737 L p F P
0 g
s
.555 .44 .677 r
.36736 .52553 m .31886 .54593 L .32701 .57346 L p F P
0 g
s
.764 .729 .82 r
.59843 .74418 m .62436 .75251 L .63999 .72896 L p F P
0 g
s
.751 .738 .84 r
.62436 .75251 m .59843 .74418 L .58642 .76767 L p F P
0 g
s
.605 .584 .803 r
.42145 .69554 m .38892 .70771 L .40473 .73213 L p F P
0 g
s
.605 .584 .803 r
.40473 .73213 m .43359 .72154 L .42145 .69554 L p F P
0 g
s
.555 .44 .677 r
.32701 .57346 m .37367 .55419 L .36736 .52553 L p F P
0 g
s
.566 .466 .7 r
.37367 .55419 m .32701 .57346 L .3367 .6011 L p F P
0 g
s
.82 .654 .676 r
.72087 .53984 m .67026 .52089 L .6645 .54981 L p F P
0 g
s
.82 .654 .676 r
.6645 .54981 m .71318 .56771 L .72087 .53984 L p F P
0 g
s
.775 .719 .801 r
.61001 .71915 m .63999 .72896 L .65486 .70407 L p F P
0 g
s
.764 .729 .82 r
.63999 .72896 m .61001 .71915 L .59843 .74418 L p F P
0 g
s
.598 .561 .783 r
.41002 .66844 m .37407 .68216 L .38892 .70771 L p F P
0 g
s
.598 .561 .783 r
.38892 .70771 m .42145 .69554 L .41002 .66844 L p F P
0 g
s
.566 .466 .7 r
.3367 .6011 m .38117 .58309 L .37367 .55419 L p F P
0 g
s
.575 .491 .722 r
.38117 .58309 m .3367 .6011 L .34784 .62861 L p F P
0 g
s
.591 .538 .763 r
.39943 .64048 m .36034 .65571 L .37407 .68216 L p F P
0 g
s
.591 .538 .763 r
.37407 .68216 m .41002 .66844 L .39943 .64048 L p F P
0 g
s
.575 .491 .722 r
.34784 .62861 m .38979 .61194 L .38117 .58309 L p F P
0 g
s
.583 .514 .743 r
.38979 .61194 m .34784 .62861 L .36034 .65571 L p F P
0 g
s
.814 .666 .699 r
.71318 .56771 m .6645 .54981 L .65768 .579 L p F P
0 g
s
.814 .666 .699 r
.65768 .579 m .70404 .59573 L .71318 .56771 L p F P
0 g
s
.583 .514 .743 r
.36034 .65571 m .39943 .64048 L .38979 .61194 L p F P
0 g
s
.784 .709 .781 r
.62105 .69279 m .65486 .70407 L .66884 .67806 L p F P
0 g
s
.775 .719 .801 r
.65486 .70407 m .62105 .69279 L .61001 .71915 L p F P
0 g
s
.808 .678 .72 r
.70404 .59573 m .65768 .579 L .64984 .60816 L p F P
0 g
s
.808 .678 .72 r
.64984 .60816 m .69354 .62363 L .70404 .59573 L p F P
0 g
s
.793 .699 .761 r
.63143 .66533 m .66884 .67806 L .68177 .65116 L p F P
0 g
s
.784 .709 .781 r
.66884 .67806 m .63143 .66533 L .62105 .69279 L p F P
0 g
s
.801 .689 .741 r
.69354 .62363 m .64984 .60816 L .64106 .63703 L p F P
0 g
s
.801 .689 .741 r
.64106 .63703 m .68177 .65116 L .69354 .62363 L p F P
0 g
s
.793 .699 .761 r
.68177 .65116 m .64106 .63703 L .63143 .66533 L p F P
0 g
s
.25 Mabswid
.6737 0 m
.93222 .41777 L
s
.93222 .41777 m
1 .91485 L
s
1 .91485 m
.70513 .54553 L
s
.70513 .54553 m
.6737 0 L
s
.08232 .24662 m
0 .767 L
s
0 .767 m
.70513 .54553 L
s
.70513 .54553 m
.6737 0 L
s
.6737 0 m
.08232 .24662 L
s
.08232 .24662 m
.6737 0 L
s
.09373 .24186 m
.09872 .24694 L
s
[(-1)] .08375 .23169 .98212 1 Mshowa
.22363 .18768 m
.22838 .193 L
s
[(-0.5)] .21414 .17706 .89334 1 Mshowa
.36074 .13051 m
.36521 .13606 L
s
[(0)] .35181 .11941 .80456 1 Mshowa
.50567 .07007 m
.50981 .07586 L
s
[(0.5)] .49737 .05849 .71578 1 Mshowa
.6591 .00609 m
.66288 .01212 L
s
[(1)] .65153 -0.00598 .627 1 Mshowa
.125 Mabswid
.11916 .23125 m
.12213 .23433 L
s
.14486 .22053 m
.1478 .22364 L
s
.17084 .2097 m
.17375 .21283 L
s
.19709 .19875 m
.19997 .20191 L
s
.25046 .1765 m
.25328 .17971 L
s
.27758 .16519 m
.28036 .16843 L
s
.305 .15375 m
.30774 .15703 L
s
.33271 .1422 m
.33543 .1455 L
s
.38908 .11869 m
.39172 .12205 L
s
.41774 .10674 m
.42034 .11013 L
s
.44672 .09466 m
.44928 .09807 L
s
.47602 .08243 m
.47855 .08588 L
s
.53565 .05757 m
.5381 .06107 L
s
.56598 .04492 m
.56838 .04846 L
s
.59666 .03213 m
.59902 .03569 L
s
.6277 .01918 m
.63001 .02278 L
s
.25 Mabswid
0 .767 m
.40076 1.05469 L
s
.01158 .77531 m
.01266 .76827 L
s
[(-1)] .0094 .78939 .15432 -1 Mshowa
.12242 .85487 m
.12325 .8478 L
s
[(-0.5)] .12074 .86902 .11826 -1 Mshowa
.22191 .9263 m
.22253 .9192 L
s
[(0)] .22067 .94049 .0873 -1 Mshowa
.31171 .99076 m
.31214 .98365 L
s
[(0.5)] .31085 1.00498 .06042 -1 Mshowa
.39317 1.04924 m
.39344 1.04212 L
s
[(1)] .39265 1.06348 .03687 -1 Mshowa
.125 Mabswid
.03475 .79194 m
.03537 .78771 L
s
.0574 .8082 m
.05799 .80397 L
s
.07955 .8241 m
.08011 .81986 L
s
.10122 .83966 m
.10175 .83541 L
s
.14316 .86977 m
.14364 .86552 L
s
.16347 .88435 m
.16392 .8801 L
s
.18336 .89862 m
.18378 .89437 L
s
.20283 .9126 m
.20323 .90835 L
s
.2406 .93971 m
.24094 .93545 L
s
.25891 .95286 m
.25924 .9486 L
s
.27686 .96574 m
.27716 .96148 L
s
.29446 .97837 m
.29474 .97411 L
s
.32863 1.00291 m
.32887 .99864 L
s
.34523 1.01482 m
.34545 1.01055 L
s
.36151 1.02651 m
.36171 1.02224 L
s
.37749 1.03798 m
.37767 1.03371 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{273.063, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006I0001[b000`400?l00000o`00003oo`3ooonJ
0?ooo`00o`3oool;0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0QP3oool00?l0
oooo3P3oool00`2jLW80^^[o0?ooo`290?ooo`00o`3oool>0?ooo`030;YbLP2jj_l0oooo08T0oooo
003o0?ooo`h0oooo00<0^W9b0;[Zo`3oool0R@3oool00?l0oooo3P3oool00`2jLW80^^[o0?ooo`29
0?ooo`00o`3oool>0?ooo`030;YbLP2jj_l0oooo08T0oooo003o0?ooo`h0oooo00<0^W9b0;[Zo`3o
ool0R@3oool00?l0oooo2`3oool01@3Z^W800000001b^P2jLW80^^[o08X0oooo003o0?ooo`d0oooo
00<0j[Yb0000LP2jj_l0RP3oool00?l0ooooVP3oool00?l0ooooVP3oool00?l0ooooVP3oool00?l0
ooooVP3oool00?l0ooooVP3oool00?l0oooo6@3oool2000007l0oooo003o0?oooaL0oooo0P000000
0`3oool000000000001n0?ooo`00o`3ooolE0?ooo`8000000`3oool2000007h0oooo003o0?oooa80
oooo100000040?ooo`030000003oool0000007d0oooo003o0?oooa00oooo0P0000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`000000O@3oool00?l0oooo3@3oool3000000H0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo07X0oooo003o0?ooo`/0oooo0P00
000=0?ooo`050000003oool0oooo0?ooo`000000N`3oool00?l0oooo2@3oool2000000l0oooo00D0
00000?ooo`3oool0oooo0000001k0?ooo`00o`3oool60?ooo`@00000403oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo07P0oooo003o0?ooo`@0oooo0P0000040?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1g0?ooo`00`@3oool01@3o
/5d00000000000000000GK3o00D0oooo00<0/5d000000000GK001@3oool01@2`G@00000000000000
0000GK3o02T0oooo0P00000G0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0M`3o
ool00<40oooo00H0R39M0;3oo`3oool0oon`05d0G@2`ool40?ooo`030;1M0000000005f`00@0oooo
00L0/5d0001M/03oool0oooo0?oGR00b0000GK3o02D0oooo0`00000I0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0MP3oool00<00oooo00<0ok1M001M/03oool00P3oool00`3GR380
<XSG0?ooo`0?0?ooo`030?n`G@00GK00oooo0280oooo0P00000L0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0MP3oool00<00oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`
0?ooo`0?0?ooo`030?n`G@00GK00oooo01l0oooo1000000M0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0M@3oool00<00oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?oo
o`0?0?ooo`0308Pb001M/?l0oooo01d0oooo0P0000040?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1d0?ooo`00`03oool00`3GR380<XSG0?ooo`02
0?ooo`030?n`G@00GK00oooo00X0oooo00<0oon`05d0000000000P0000000`0bR=L0oooo0?ooo`0K
0?ooo`8000008`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo07@0oooo00300?oo
o`030?n`G@0bR=L0oooo0080oooo00<0ehPb03:8e`3oool02P3oool00`3ook00G@1M0;3oo`0M0?oo
o`<000009@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07<0oooo00310?ooo`06
08Pb001M/?l0oooo0?oGR00b05d0/?oo2`3oool00`3ook00G@1M0;3oo`0K0?ooo`800000:03oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0780oooo00310?ooo`050?oo/01M00000000
0000<P28eol0303oool00`3ook00G@0000000002000000030000G@2`ool0oooo01@0oooo0`00000Y
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0LP3oool00>/0oooo0`0000030?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1a0?oo
o`00j@3oool2000002l0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1a0?ooo`00
iP3oool300000340oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`1`0?ooo`00i03o
ool2000003@0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1_0?ooo`00hP3oool2
00000080oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo06l0oooo003O0?ooo`<00000>03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
06h0oooo003M0?ooo`800000>`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo06d0
oooo003K0?ooo`800000?P3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo06d0oooo
003H0?ooo`<00000@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo06`0oooo003F
0?ooo`8000000P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0K03oool00=@0oooo0P0000050?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`1[0?ooo`00d@3oool3000004L0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`1Z0?ooo`00c`3oool2000004X0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`1Z0?ooo`00c03oool3000004`0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`1Y0?ooo`00V@3oool01@3o/5d00000000000000000GK3o02`0oooo0P00
00030?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`1Y0?ooo`00V@3oool01P28<Ud0/?oo0?ooo`3ook00G@1M0;3oobT0oooo0P00001A0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0J03oool009P0oooo00<0ok1M001M/03oool00P3o
ool00`3GR380<XSG0?ooo`0U0?ooo`<00000D`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo06L0oooo002H0?ooo`030=N8<P0bR=L0oooo0080oooo00<0ok1M001M/03oool08`3oool2
000005H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1W0?ooo`00V03oool00`3G
R380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo0240oooo0P0000000`3oool000000?ooo`1E0?oo
o`030000003oool0oooo0180oooo00<000000?ooo`3oool0IP3oool009P0oooo00<0ehPb03:8e`3o
ool00P3oool00`3o/5d005f`0?ooo`0N0?ooo`<00000FP3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo06D0oooo002H0?ooo`030?n`G@0bR=L0oooo0080oooo00<0ehPb03:8e`3oool0
703oool2000005d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`1U0?ooo`00V@3o
ool01P28<P00GK3o0?ooo`3oehP0<P1M0;3ooaX0oooo0`00001O0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0I03oool009T0oooo00D0oon`05d000000000000b08SGo`0I0?ooo`80
0000HP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo06@0oooo002e0?ooo`800000
0P3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
H`3oool00;80oooo0`00001W0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0HP3o
ool00;00oooo0P00001Z0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0HP3oool0
0:h0oooo0P00001/0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0H@3oool00:/0
oooo0`0000000`3oool000000?ooo`1[0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0H03oool00:T0oooo0P00001a0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
H03oool00:H0oooo0`00001c0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0G`3o
ool00:@0oooo0P00001f0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0G`3oool0
0:80oooo0P00001h0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0GP3oool009l0
oooo0`0000020?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`1M0?ooo`00W@3oool2000000H0oooo00<000000?ooo`3oool0M03oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo05d0oooo002K0?ooo`800000O`3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo05`0oooo002H0?ooo`<00000P@3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo05`0oooo001D0?ooo`050?n`G@00000000000000001M/?l01@3oool0
0`2`G@000000001M/0050?ooo`050;1M0000000000000000001M/?l0:`3oool2000000030?ooo`00
0000oooo0840oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1K0?ooo`00E03oool0
1P28<Ud0/?oo0?ooo`3ook00G@1M0;3oo`@0oooo00<0/5d000000000GK00103oool01`2`G@0005f`
0?ooo`3oool0omN80380001M/?l09`3oool3000008H0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`1J0?ooo`00D`3oool00`3o/5d005f`0?ooo`020?ooo`030=N8<P0bR=L0oooo00l0
oooo00<0ok1M001M/03oool0903oool2000008T0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`1J0?ooo`00D`3oool00`3GR380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00l0oooo
00<0ok1M001M/03oool08@3oool3000008/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`1I0?ooo`00BP3oool00`28<P0000000000000300000005000bR03oool0oooo0=N8<P0bR=L0
0`3oool00`3o/5d005f`0?ooo`0?0?ooo`0308Pb001M/?l0oooo01l0oooo0`00002=0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0F03oool005<0oooo00<0ehPb03:8e`3oool00P3o
ool00`3o/5d005f`0?ooo`0:0?ooo`030?oo/01M000000000080000000<0<XSG0?ooo`3oool07@3o
ool2000000<0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo05P0oooo001C0?ooo`030?n`G@0bR=L0oooo0080oooo00<0ehPb03:8e`3oool02P3oool0
0`3ook00G@1M0;3oo`0P0?ooo`800000T`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo05L0oooo001D0?ooo`0608Pb001M/?l0oooo0?oGR00b05d0/?oo2`3oool00`3ook00G@1M0;3o
o`0M0?ooo`<00000U@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo05L0oooo001D
0?ooo`050?oo/01M000000000000<P28eol0303oool00`3ook00G@0000000002000000030000G@2`
ool0oooo01H0oooo0P00002H0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0EP3o
ool00800oooo0`0000020?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`1E0?ooo`00OP3oool2000009d0oooo00<000000?ooo`3oool08@3oool00`00
0000oooo0?ooo`1E0?ooo`00O03oool2000009l0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`1D0?ooo`00N@3oool300000:40oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`1C0?ooo`00M`3oool2000000030?ooo`000000oooo0:40oooo00<000000?ooo`3oool08`3o
ool00`000000oooo0?ooo`1C0?ooo`00M@3oool200000:H0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`1B0?ooo`00LP3oool300000:P0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`1B0?ooo`00K`3oool300000:/0oooo00<000000?ooo`3oool09@3oool00`000000
oooo0?ooo`1A0?ooo`00KP3oool300000:`0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`1@0?ooo`00J`3oool3000000<0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo0500oooo001Y0?ooo`800000/P3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo04l0oooo001U0?ooo`@00000]03oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo04h0oooo000b0?ooo`030?n`G@000000000000<0000000<005f`0?ooo`3o
ool0:@3oool200000;L0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1>0?ooo`00
=@3oool00`28<S80R=Oo0?ooo`0Z0?ooo`8000000P3oool00`000000oooo0?ooo`2d0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool0C@3oool003D0oooo00<0R38b08SGo`3oool09`3o
ool300000;`0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`1=0?ooo`00=@3oool0
0`28<S80R=Oo0?ooo`0U0?ooo`800000_`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo04`0oooo000Y0?ooo`0308Pb00000000000000<0000000<003:80?ooo`3oool00`3oool00`28
<S80R=Oo0?ooo`0S0?ooo`800000`@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo
04/0oooo000e0?ooo`0308Pb<P28eol0oooo0200oooo0`0000000`3oool000000?ooo`300?ooo`03
0000003oool0oooo02X0oooo00<000000?ooo`3oool0B`3oool003D0oooo00<0R38b08SGo`3oool0
7P3oool200000<H0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`1:0?ooo`00<P3o
ool01@3GR3800000000bR028<S80R=Oo01`0oooo0`0000380?ooo`030000003oool0oooo02/0oooo
00<000000?ooo`3oool0BP3oool003@0oooo00<0ehPb0000<P28eol06P3oool200000</0oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`190?ooo`00C`3oool2000000030?ooo`000000
00000<X0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`180?ooo`00C03oool30000
0<l0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`180?ooo`00BP3oool200000=80
oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`170?ooo`00B03oool200000=@0oooo
00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`160?ooo`00A@3oool3000000030?ooo`00
0000oooo0=<0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`160?ooo`00@`3oool2
00000=T0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`150?ooo`00@03oool30000
0=/0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`150?ooo`00?P3oool200000=h0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`140?ooo`00?03oool2000000030?oo
o`000000oooo0=d0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`130?ooo`00>P3o
ool2000000@0oooo00<000000?ooo`3oool0f`3oool00`000000oooo0?ooo`0b0?ooo`030000003o
ool0oooo04<0oooo000j0?ooo`800000h`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0
oooo0480oooo000j0?ooo`030000003oool000000>80oooo00<000000?ooo`3oool0<`3oool00`00
0000oooo0?ooo`110?ooo`00>P3oool010000000oooo0?ooo`00003Q0?ooo`030000003oool0oooo
03<0oooo00<000000?ooo`3oool0@@3oool003T0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`320?ooo`<000006@3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0400
oooo000i0?ooo`800000103oool00`000000oooo0?ooo`1h0?ooo`<00000@`3oool3000000<09IS]
1000000E0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0@03oool003T0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`1c0?ooo`D000000P2Cknh4000003/0oooo1000
000304VYn0<000000P0UV>d500000180oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`0o0?ooo`00>@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo06l0oooo0`000000
0`1nimX000000000000309?_kP8000000`2Qk_P5000003<0oooo0`00000306Bcn`8000001@19ZOP2
000000<09IS]1000000@0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0?P3oool0
03T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1/0?ooo`<0000000<0O^OJ0000
000000000`2Cknh2000000@0XNkh0P0000040:SXnP<00000;`3oool010000000NKSj000000000005
06Bcn`8000001@19ZOP3000000<09IS]1000000=0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool0?P3oool003T0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`1Y0?oo
o`<0000000<0O^OJ0000000000000`2Cknh2000000@0XNkh0P0000060:SXnP80000000<0[>3i0000
003oool0:`3oool2000000@0NKSj0P00000506Bcn`8000001@19ZOP:000000/0oooo00<000000?oo
o`3oool0=`3oool00`000000oooo0?ooo`0m0?ooo`00>03oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo06H0oooo0`0000000`1nimX000000000000309?_kP800000102Qk_P2000000H0
Z>Sj0P0000040:cPn@800000:@3oool2000000L0NKSj0P00000406Bcn`H000000`1>XOH200000003
02nBl0000000T`0000D00000203oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo03`0
oooo000h0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0H`3ooolB000000D0Z>Sj
0P0000080:cPn@030000003oool0oooo02P0oooo0P00000707VhnP@000000`1VZoP2000000H0CZ7f
00D0000002nBl0000000000009<000020000000306`000000000000000H0oooo00<000000?ooo`3o
ool0>03oool00`000000oooo0?ooo`0l0?ooo`00>03oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0600oooo1P0000040:ofl0030000002dlOD0]?7e00<0]?7e00@000000;KYmP2fjOH0
]^Wf1@0000070:cPn@800000;P3oool2000000<0NKSj0P00000207RamP8000001@1VZoP2000000D0
CZ7f1@0000001P2C00000000000000000000K000000000@0oooo00<000000?ooo`3oool0>@3oool0
0`000000oooo0?ooo`0k0?ooo`00>03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
05d0oooo1P0000040:ofl0800000102dlOD2000000D0]^Wf0P0000020;KQm@8000000`2/h?T20000
0380oooo0`00000607RamP030000001VZoP0IZ_h00@0IZ_h0P00000504jQmP80000000D0[bD00000
00000000000009<0000400000080oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0k
0?ooo`00=`3oool3000000h0oooo00<000000?ooo`3oool0FP3oool500000003014000000000[oK`
00<0[oK`00<000000;Cam@2dlOD00`2dlOD00`000000]^Wf0;KYmP040;KYmP030000002fhOD0]^7e
00@0]^7e0`00000f0?ooo`8000001P1h/OH00`000000IZ_h06J[n00506J[n0800000101>XOH30000
0080[bD00P0000001P2C00000000000000000000oooo000003`0oooo00<000000?ooo`3oool0>P3o
ool003P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1G0?ooo`D000000`0A0000
1@000000[oK`0:ofl02_m_00000000D0]?7e00<000000;KYmP2fjOH0102fjOH00`000000]^7e0;KQ
m@050;KQm@030000003oool0oooo03P0oooo00<0000007RamP1h/OH0101h/OH2000000@0IZ_h2@00
00000`31@`l00000000000020:lU008000000P2C0002000003d0oooo00<000000?ooo`3oool0>@3o
ool003L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1E0?ooo`D000000P0A0002
00000080[oK`0P0000040;Cam@8000001@2fjOH2000000H0]^7e0P00000l0?ooo`800000101h/OH6
000000@0JZCc00<0000005NKlP1GVo800P1GVo800`000000`D<?0<533`0200000080[bD01@00000l
0?ooo`030000003oool0oooo03T0oooo000g0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0D`3oool4000000804@005P0000040;KQm@030000003oool0oooo03h0oooo1000000307Z[
lP030000001ZY?<0JZCc00D0JZCc00D0000005NKlP1GVo80Ei_b000000040<533`8000000`2_9@04
000003/0oooo00<000000?ooo`3oool0>03oool003L0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`1@0?ooo`@000000P0A000200000080;P0800<000000<Cgk@0000001@33ko000`00
0000`>Oa0<3Wl@040<3Wl@030000002mgo00_Mo`0080_Mo`100000120?ooo`030000001jZo80NZ_b
00@0NZ_b00<0000006ZTl`1ZY?<01@1ZY?<01@000000Ei_b05NKlP1GVo80000000D0`D<?0P000002
0:lU00040000002_9@000000000003X0oooo00<000000?ooo`3oool0>03oool003L0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`1>0?ooo`<000000P0A0002000000<0;P0800<00000
0<Cgk@0000001@33ko000`000000`>Oa0<3Wl@040<3Wl@030000002mgo00_Mo`00D0_Mo`00<00000
0?ooo`3oool0@P3oool2000000D0NZ_b0P00000606ZTl`030000001GVo80Ei_b008000001P31@`l3
00000080[bD00`00000i0?ooo`030000003oool0oooo03L0oooo000g0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool0B`3oool3000000804@000P00000502h0208000001@33ko000`00
0000`>Oa0<3Wl@030<3Wl@8000001P2mgo02000004L0oooo00<0000007Z[lP1jZo80101jZo800`00
0000JZCc06ZTl`0406ZTl`040000001GVo8000000<]I;`8000001P31@`l2000000030:lU00000000
ZQh000800000>@3oool00`000000oooo0?ooo`0f0?ooo`00=`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo04T0oooo0P0000020140008000001@0^00P3000000D0`no`00<000000<3W
l@30io400`30io400`000000_Mo`0;gOl0050;gOl0030000003oool0oooo04P0oooo4@0000020<]I
;`8000001031@`l00`000000`D<?00000002000000040:XN000000000000000003L0oooo00<00000
0?ooo`3oool0=P3oool003L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`170?oo
o`80000000<04@000000000000001@0^00P20000000304@0:@000000`no`00@0`no`00<000000<3W
l@30io403000001<0?ooo`030000001nYNd0OZG]00@0OZG]00<00000072Nk@1`W^d0101`W^d20000
00@0beT_0`0000000`31@`l000000<533`030<533`060000002Z7P00ZQh00000002500000000=P3o
ool00`000000oooo0?ooo`0e0?ooo`00=P3oool3000001P0oooo00<000000?ooo`3oool0A03oool5
000000D0;P080P00000204@0:@0300000033ko00`no`00L000000P38hn/00`000000`mc[0<?Lj`05
0<?Lj`030000003oool0oooo04/0oooo00<0000007jUk@1nYNd0101nYNd00`000000L9k]072Nk@04
072Nk@030000001QU^`0000000H0beT_0P0000050<533`80000000@0ZQh00000000000000000=P3o
ool00`000000oooo0?ooo`0d0?ooo`00=P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo0480oooo1000000502h020800000101402T300000080c>[Z00<000000<SSj`38hn/01038hn/0
0`000000`mc[0<?Lj`050<?Lj`030000003oool0oooo04`0oooo00<0000007jUk@1nYNd0101nYNd0
0`000000L9k]072Nk@04072Nk@<000001P3;FBl4000000<0`D<?0`0000000`2Z7P0000000000000e
0?ooo`030000003oool0oooo03@0oooo000f0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0?`3oool4000000D0;P080P00000504@0:@030000003<j^X0c>[Z00<0c>[Z00<000000<SS
j`38hn/00`38hn/00`000000`mc[0<?Lj`050<?Lj`030000003oool0oooo04d0oooo00<0000007jU
k@1nYNd01@1nYNd00`000000L9k]072Nk@04072Nk@040000003AJTT00000000000@0beT_00@00000
0<]I;`3;FBl0beT_0P0000001@31@`l000000<A10034@@0000000080ZQh00P00000d0?ooo`030000
003oool0oooo03<0oooo000f0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0?@3o
ool5000000<0;P080P00000704@0:@030000003<j^X0c>[Z0080c>[Z00<000000<SSj`38hn/01038
hn/00`000000`mc[0<?Lj`050<?Lj`030000003oool0oooo04h0oooo1000000307jUk@030000001`
W^d0L9k]00D0L9k]00<000000=5ZB@3AJTT00P0000020<]I;`030000003;FBl0beT_00<0beT_0`00
00020<A10080000000<0ZQh0000000000000<`3oool00`000000oooo0?ooo`0c0?ooo`00=P3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo03/0oooo1@00000202h0208000001`1402T0
0`000000E0=4000000040<cZjP0300000038hn/0b>?[00<0b>?[00<000000<?Lj`33g>/00P33g>/4
00000540oooo00@0000008:Qj022XNP0PZ7X20000003072Nk@030000003AJTT0dFY90080dFY90`00
00080<]I;`0400000034@@00a4400<A10080000000<0ZQh00000003oool0<P3oool00`000000oooo
0?ooo`0b0?ooo`00=P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03P0oooo2@00
000704@0:@80000000<0E0=40000003<j^X00`3<j^X00`000000b>?[0<SSj`030<SSj`H000000`37
enH00`000000oooo0?ooo`1@0?ooo`0300000022XNP0PZ7X00@0PZ7X00@0000007NJi`1gV^L0Mi[W
100000060=5ZB@<000001P3;FBl3000000<0a44000<000000:XN00000000<`3oool00`000000oooo
0?ooo`0a0?ooo`00=@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03H0oooo2000
000704@0:@8000000`1D0d@00`000000c>[Z0<cZjP020<cZjP0300000038hn/0000000<0000000<0
c=gU00000037enH01@37enH00`000000oooo0?ooo`1A0?ooo`0300000022XNP0PZ7X00D0PZ7X00<0
000007NJi`1gV^L0101gV^L00`000000dFY90=5ZB@030=5ZB@030000003AJTT0dFY900<00000103;
FBl00`000000e5`F000000030<A100<00000<P3oool00`000000oooo0?ooo`0a0?ooo`00=@3oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03@0oooo1`00000704@0:@8000001@1D0d@0
0`000000c>[Z0<cZjP04000000@0c=gU00<000000<OGiP37enH01@37enH00`000000oooo0?ooo`1B
0?ooo`0300000022XNP0PZ7X00@0PZ7X00<0000007NJi`1gV^L0101gV^L2000000@0dFY900<00000
0=5ZB@3AJTT00`3AJTT200000080beT_00<000000=AL5P3DG1H00P0000030<A100800000<P3oool0
0`000000oooo0?ooo`0`0?ooo`00=@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
0380oooo1P0000000`0<00`0000004@0:@0404@0:@8000001P1D0d@4000000030=7Si0000000c=gU
00D0c=gU00<000000<OGiP37enH01@37enH00`000000oooo0?ooo`1B0?ooo`<000001@22XNP00`00
0000Mi[W07NJi`0307NJi`040000003DMed0000000000080dFY900<000000=5ZB@3AJTT01@3AJTT2
000000030<]I;`000000e5`F0080e5`F00<000000<A10034@@000P34@@000`000000oooo0?ooo`0`
0?ooo`030000003oool0oooo02l0oooo000e0?ooo`8000008`3oool00`000000oooo0?ooo`0`0?oo
o`H0000000<0300<0000001402T00`1402T2000000P0E0=400D000000=7Si03Ahn@0dN?T00000007
0<cMi@0300000037enH0amOV00@0amOV00<000000?ooo`3oool0D`3oool00`000000QikS08NNh`04
0000000308:Qj0000000Mi[W00@0Mi[W00@000000=AgG@3DMed0e7MM0`00000:0=5ZB@030000003D
G1H0e5`F0080e5`F0P0000030<A100800000<03oool00`000000oooo0?ooo`0_0?ooo`00=@3oool0
0`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02h0oooo1P00000200`030030000001402T0
A00Y00800000201D0d@00`000000HAUJ000000030=7Si0030000003<gND0c=gU00D0c=gU00<00000
0<OGiP37enH00`37enH2000005D0oooo00<0000008NNh`27W^<01027W^<4000000<0Mi[W00<00000
0=AgG@3DMed00`3DMed2000000T0dFY90`0000040=AL5P0300000034@@00a44000<00000<03oool0
0`000000oooo0?ooo`0^0?ooo`00=@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
02`0oooo1@00000300`030040000001402T00000000000P0E0=40P000002064IFP050000003Ahn@0
dN?T0=7Si00000001P3<gND00`000000amOV0<OGiP04000000030<SBh@000000oooo05@0oooo00<0
000008NNh`27W^<01P27W^<00`000000OYOQ00000004000000@0e7MM00@000000=AgG@0000000000
203AJTT00`000000gG4f000000040=AL5P80000000@0a4400000000000000000;`3oool00`000000
oooo0?ooo`0^0?ooo`00=03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02X0oooo
1@00000400`030800000201D0d@2000000@0HAUJ00D000000=7Si03Ahn@0dN?T000000050<cMi@@0
00001@38d^400`000000oooo0?ooo`1D0?ooo`0300000027W^<0QikS00D0QikS00<0000007jGh@1n
Un400`1nUn400`000000e7MM0=AgG@030=AgG@030000003DMed0e7MM008000001P3AJTT00`000000
gG4f0=ea=P02000000@0e5`F00<000000<A1000000000P00000_0?ooo`030000003oool0oooo02d0
oooo000d0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0:03oool5000000<0300<
00<0000002@0;P0000001`1D0d@2000000D0HAUJ00D000000=7Si03Ahn@0dN?T000000020<cMi@@0
000000<0c]KO00000038d^401P38d^400`000000oooo0?ooo`1D0?ooo`0300000027W^<0QikS00D0
QikS00<0000007jGh@1nUn400`1nUn400`000000e7MM0=AgG@030=AgG@030000003DMed0e7MM0080
e7MM0P0000040=5ZB@030000003MLCH0gG4f0080gG4f0P0000030=AL5P80000000<0/c<000000000
0000;`3oool00`000000oooo0?ooo`0/0?ooo`00=03oool00`000000oooo0?ooo`0X0?ooo`030000
003oool0oooo02H0oooo1000000400`030030000000T02h0000000H0E0=40P000007064IFP040000
003Ahn@0dN?T0=7Si0<000001@3>e]l00`000000b=;Q0<SBh@050<SBh@030000003oool0oooo05@0
oooo0P00000608NNh`030000001nUn40OYOQ00<0OYOQ0P0000040=AgG@030000003DMed0e7MM00@0
e7MM0P0000020=5ZB@030000003MLCH0gG4f00@0gG4f00<000000=AL5P3DG1H00P3DG1H010000000
/c<000000000000^0?ooo`030000003oool0oooo02`0oooo000d0?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0903oool4000000<0300<0P00000202@0;P030000001D0d@0E0=40080
E0=40P000009064IFP030000003Ahn@00000008000001`3>e]l00`000000b=;Q0<SBh@040<SBh@80
0000EP3oool00`000000S9cN0000000300000080QikS00<0000007jGh@1nUn400`1nUn4010000000
eX9]0000000000020=AgG@030000003DMed0e7MM00H0e7MM0P0000000`3AJTT000000=ea=P050=ea
=P8000000`3DG1H010000000/c<00;<c0000000^0?ooo`030000003oool0oooo02/0oooo000d0?oo
o`030000003oool0oooo02X0oooo00<000000?ooo`3oool08P3oool4000000<0300<00<0000002@0
;P0T02h00P0T02h00`000000E0=405@3A002000000X0HAUJ0`0000020=?Jg@030000003>e]l0c]KO
00D0c]KO00<000000<SBh@38d^400P38d^42000000030<W<g@000000oooo05D0oooo00<0000008bL
gP2<W=h00`2<W=h4000000@0OYOQ00@000000=J2K@3FPVd0eX9]0`00000;0=AgG@030000003MLCH0
gG4f00H0gG4f00<000000=AL5P3DG1H00P0000020;<c00030000003oool0oooo02/0oooo00<00000
0?ooo`3oool0:`3oool003@0oooo0`00000[0?ooo`030000003oool0oooo0200oooo0`00000300`0
30800000100T02h010000000E0=400000000000:064IFP80000000<0JbY[0000003Cf]d00P3Cf]d0
0`000000c]KO0<kFg`050<kFg`0300000038d^400000008000000`39c=d00`000000oooo0?ooo`1C
0?ooo`030000002<W=h0S9cN00H0S9cN00@0000008FFg000000000000P1nUn400`000000eX9]0=J2
K@030=J2K@8000002P3DMed3000000L0gG4f0P0000000`3DG1H00000000000020;<c00030000003o
ool0oooo02/0oooo00<000000?ooo`3oool0:P3oool003<0oooo0P00000^0?ooo`030000003oool0
oooo01h0oooo0`00000300`030030000000T02h0900^00@0900^0P00000:064IFP8000000`1[:V/0
1@000000dm[M0=?Jg@3Cf]d0000000L0c]KO0P0000070<W<g@030000003oool0oooo0580oooo00<0
000008bLgP2<W=h01P2<W=h010000000QIKL08FFg025U]`3000000D0eX9]00@000000=J2K@000000
00002@3DMed010000000hX5?0000000000070=ea=P80000000D0ceH00000002c<`00/c<00000000]
0?ooo`030000003oool0oooo02T0oooo000c0?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool07@3oool30000000300`030000000000000D0900^00<0000003P0B@0000002@1Q6EX20000
00D0JbY[00D000000=?Jg@3Cf]d0dm[M000000050<kFg`<000002039c=d00`000000oooo0?ooo`1B
0?ooo`030000002<W=h0S9cN00H0S9cN00<0000008FFg025U]`00`25U]`2000000@0eX9]00@00000
0=J2K@3FPVd0eX9]0`0000060=AgG@050000003RPDl0hX5?0>:1C`000000203MLCH00`000000ceH0
000000020;<c00030000003oool0oooo02X0oooo00<000000?ooo`3oool0:@3oool001D0oooo00D0
omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000
000009_Do`070?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool06`3oool300000003
00`030000000900^00D0900^00<0000003P0B@000000201Q6EX2000000H0JbY[00<000000=?Jg@3C
f]d00P3Cf]d010000000c]KO0<kFg`3>e]l200000080c/oJ00<000000<W<g@39c=d01P39c=d00`00
0000oooo0?ooo`1B0?ooo`<000001@2<W=h00`000000QIKL08FFg00508FFg0030000003FPVd0eX9]
0080eX9]00<000000=J2K@3FPVd0103FPVd2000000@0e7MM00<000000>:1C`3RPDl00P3RPDl20000
00H0gG4f0P0000001@3?EP0000000000002c<`00000002`0oooo00<000000?ooo`3oool0:03oool0
01D0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0
e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0<03oool00`000000
oooo0?ooo`0I0?ooo`D000001@0T02h200000080>01900<00000064IFP1Q6EX0101Q6EX2000000P0
JbY[00<000000=?Jg@3Cf]d00P3Cf]d010000000c]KO0000000000040<k?fP0300000039c=d0bLcM
00@0bLcM0P0000000`38a]T000000?ooo`1A0?ooo`040000002AVmX0TI_J096KfP8000000`2<W=h0
0`000000QIKL08FFg00508FFg0030000003FPVd0eX9]0080eX9]00<000000=J2K@3FPVd01P3FPVd2
00000080e7MM00<000000>:1C`3RPDl0103RPDl2000000D0gG4f0P0000020<mF00800000;@3oool0
0`000000oooo0?ooo`0W0?ooo`00503oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo
00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo
01P0oooo0`00000602@0;P030000000h04T0>0190080>01900<00000064IFP1Q6EX00P1Q6EX20000
00X0JbY[00<000000=?Jg@3Cf]d00P3Cf]d2000000L0c/oJ00@000000<W<g@39c=d0bLcM0P000003
0<S6f@030000003oool0oooo0500oooo00<00000096KfP2AVmX00`2AVmX20000000308bLgP000000
QIKL00H0QIKL0P0000030=J2K@030000003FPVd0eX9]00P0eX9]0P0000000`3DMed000000>:1C`06
0>:1C`8000000`3MLCH00`000000hG8D000000020<mF00800000;03oool00`000000oooo0?ooo`0W
0?ooo`00503oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002K
e03oool01@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01H0oooo1000000502@0
;P030000000h04T0>01900<0>01900<00000064IFP1Q6EX00P00000<06/ZJ`030000003Cf]d0dm[M
00<00000203>cmX010000000bLcM0000000000060<S6f@030000003oool0oooo04h0oooo00<00000
096KfP2AVmX01P2AVmX2000000L0QIKL00H000000=N:N`00000000000=J2K@00000=0=J2K@030000
003RPDl0hX5?00L0hX5?00L000000=ea=P3MLCH0gG4f0000003QLQ@000000080ceH00P00000/0?oo
o`030000003oool0oooo02H0oooo000;0?ooo`030;Yb00000000000000<0000000D007:j0?ooo`3o
ool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo01@0oooo1000000402@0;P8000001@0h04T01000
0000HAUJ00000000000=06/ZJ`@000000P3CdMP00`000000c/oJ0<k?fP060<k?fP8000002038a]T0
0`000000oooo0?ooo`1>0?ooo`030000002AVmX0TI_J00H0TI_J00@0000008bEe`00000000001@25
U]`010000000ehYk0=N:N`3GRW/3000000`0eX9]0`0000080>:1C`80000000D0gG4f0000003QLQ@0
hG8D000000020<mF00030000003oool0oooo02X0oooo00<000000?ooo`3oool09P3oool001@0oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K0000000000800000
00<0L[[Z0?ooo`3oool0103oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0180oooo
0`0000000`0000L0000002@0;P0202@0;P030000000h04T0>01900D0>0190P00000=06/ZJ`800000
00<0LcUi0000003CdMP00`3CdMP00`000000c/oJ0<k?fP040<k?fP80000000<0c<SF00000038a]T0
2038a]T00`000000oooo0?ooo`1<0?ooo`040000002GVmH00000000000H0TI_J00@0000008bEe`2<
UML0S9GG0P00000308FFg0030000003GRW/0ehYk0080ehYk00@000000=N:N`00000000002P3FPVd0
0`000000i8eS0>B=H`02000000P0hX5?0`0000020>5b50040000003?EP00ceH0000002`0oooo00<0
00000?ooo`3oool09@3oool001@0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:
0?ooo`030?ooe02K09/0e?oo00T0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0@
0?ooo`D000000P0T02h2000000H0>0190`00000<06/ZJ`8000000`1c>GT00`000000dm7H0=?Af003
0=?Af0030000003>cmX0c/oJ0080c/oJ00D000000<c8eP3<b=H0c<SF000000070<S6f@80000000<0
a/7E0000003oool0B`3oool00`000000Ui_F09NKeP0209NKeP030000002AVmX0TI_J0080TI_J00<0
000008bEe`2<UML0102<UML20000000308FFg0000000ehYk00<0ehYk00@000000=N:N`3GRW/0ehYk
0`0000070=J2K@030000003TSF<0i8eS0080i8eS00<000000>:1C`3RPDl01`3RPDl01P000000hG8D
0>5b503QLQ@000000<mF00800000;03oool00`000000oooo0?ooo`0T0?ooo`005@3oool01P2jLP00
VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02@3oool2000003P0oooo00<00000
0?ooo`3oool03P3oool40000000400001`000000900^000000L0>01900@0000004L<G`1735l00000
2P1[:V/2000000D0LcUi00<000000=?Af03CdMP00`3CdMP00`000000c/oJ0<k?fP02000000D0c<SF
00<000000<S6f@38a]T00`38a]T00`000000a/7E0<K1e@020<K1e@030000003oool0oooo04T0oooo
00<0000009NKeP2GVmH00`2GVmH01@000000TI_J096KfP2AVmX0000000P0S9GG0P0000040=N:N`03
0000003GRW/0ehYk00@0ehYk0P0000060=J2K@030000003TSF<0i8eS0080i8eS0P0000070>:1C`80
00000`3QLQ@00`000000ceH00000000/0?ooo`030000003oool0oooo02@0oooo000E0?ooo`050?oo
e02K000000000000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo00@0
oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0<0?ooo`@0000000@0000700000000
000000001P0h04T2000000<0A`aO00<0000006/ZJ`1[:V/01P1[:V/2000000L0LcUi00<000000=?A
f03CdMP00`3CdMP3000000P0c<SF00D000000<S6f@38a]T0b<KI000000050<K1e@030000003oool0
oooo04P0oooo00<0000009NKeP2GVmH01@2GVmH3000000X0S9GG00<000000=N:N`3GRW/00P3GRW/0
0`000000ehYk0=N:N`060=N:N`<000000`3FPVd00`000000i8eS0>B=H`040>B=H`8000001P3RPDl2
000000<0hG8D0`00000/0?ooo`030000003oool0oooo02<0oooo000b0?ooo`030000003oool0oooo
03T0oooo00<000000?ooo`3oool02P3oool400000080000700<0000003P0B@0h04T01@0h04T00`00
0000A`aO04L<G`0204L<G`030000001[:V/0JbY[00D0JbY[0P00000907<iN@030000003CdMP0dm7H
00<0dm7H00<000000<c8eP3<b=H0203<b=H010000000b<KI0000000000070<K1e@030000003oool0
oooo04H0oooo00<0000009NKeP2GVmH0202GVmH00`000000S9GG08bEe`0708bEe`8000001@3GRW/0
0`000000ehYk0=N:N`080=N:N`80000000<0eX9]0000003TSF<01`3TSF<2000000@0hX5?00<00000
0>^6=@0000000`3QLQ@3000002`0oooo00<000000?ooo`3oool08P3oool00380oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`090?ooo`<000000P0000L2000000H0>01900<0000004L<
G`1735l00`1735l00`000000JbY[06/ZJ`0306/ZJ`8000002`1c>GT010000000dm7H0=?Af03CdMP2
000000030=79d`000000c<SF00T0c<SF00<000000<K1e@36`MD02036`MD00`000000oooo0?ooo`14
0?ooo`040000002LVm<00000000000L0Ui_F00@0000009>Ed`00000000001`2<UML3000000@0ehYk
00<000000=N:N`3GRW/02P3GRW/2000000X0i8eS00D000000>:1C`3RPDl0hX5?000000020>^6=@04
0000003QLQ@0hG8D0>5b50800000;03oool00`000000oooo0?ooo`0R0?ooo`00<@3oool00`000000
oooo0?ooo`0l0?ooo`030000003oool0oooo00L0oooo0`00000200001`8000001@0h04T2000000H0
A`aO00@0000006/ZJ`1[:V/0JbY[0P00000=07<iN@040000003CdMP0dm7H000000<0dLWC00<00000
0<c8eP3<b=H01`3<b=H00`000000b/7B000000080<K1e@0300000034^m80000004<0oooo0P000004
09bKd`030000002GVmH0Ui_F00<0Ui_F00<0000009>Ed`2CUM<00P2CUM<00`000000S9GG08bEe`03
08bEe`0400000027Sm@000000=NAQP8000000P3GRW/00`000000ehYk0=N:N`0;0=N:N`<000002@3T
SF<2000000030>:1C`000000jhHe0080jhHe00@000000>5b503QLQ@0hG8D0P00000/0?ooo`030000
003oool0oooo0240oooo000a0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool01P3o
ool30000000400001`000000000[000000@0>01900<0000004L<G`1735l01P1735l010000000JbY[
00000000000>07<iN@80000000<0dm7H0000003AbM<0103AbM<00`000000c<SF0<c8eP040<c8eP80
00000P3:`M800`000000a/7E0<K1e@050<K1e@0400000034^m80a;_B0<BkdP800000@03oool00`00
0000W9_C09bKd`0509bKd`030000002GVmH0Ui_F0080Ui_F00<0000009>Ed`2CUM<00`2CUM<20000
00<0S9GG00<0000008N?e00000000`3GTHH3000000d0ehYk00@000000>FFL`3UUW<000002P3TSF<3
000000<0jhHe00<000000>5b503QLQ@00`00000[0?ooo`030000003oool0oooo0240oooo000a0?oo
o`030000003oool0oooo03h0oooo00<000000?ooo`3oool0103oool30000000500001`000000000[
0000:`0000000P0h04T2000000T0A`aO0P00000>07<iN@80000000<0NTF50000000000001P3AbM<0
0`000000c<SF0<c8eP030<c8eP030000003:`M80b/7B00<0b/7B00<000000<K1e@36`MD00P36`MD2
000000H0a;_B00<000000?ooo`3oool0?03oool00`000000W9_C09bKd`0709bKd`80000000<0Ui_F
0000002CUM<01`2CUM<300000080QhoD00<000000=NAQP3GTHH00`3GTHH3000000/0ehYk00@00000
0>FFL`3UUW<0iIIc0P00000:0>B=H`030000003[QSD0jhHe0080jhHe00<000000>5b503QLQ@00P00
000/0?ooo`030000003oool0oooo0200oooo000a0?ooo`030000003oool0oooo03l0oooo00<00000
0?ooo`3oool00`3oool20000000300001`000000000[0080000[00<0000003P0B@0000002@1735l3
000000d0LcUi0P00000307Y5Q@030000003AbM<0dLWC00H0dLWC00D000000<c8eP3<b=H0c<SF0000
00070<[1dP0400000036`MD0a/7E000000T0a;_B00<000000?ooo`3oool0>@3oool2000000030:6L
d0000000W9_C00T0W9_C00<0000009>Ed`2CUM<02@2CUM<010000000QhoD08N?e00000050=NAQP03
0000003GTHH0ei66008000002@3GRW/00`000000iIIc0>FFL`030>FFL`030000003TSF<0i8eS00L0
i8eS0P0000040>^6=@030000003QLQ@0000000800000;03oool00`000000oooo0?ooo`0O0?ooo`00
<@3oool00`000000oooo0?ooo`100?ooo`040000003oool0oooo0?ooo`80000000<0000700000000
02/00P0002/3000000T0A`aO00@0000005<OL@1C7g4000002`1c>GT2000000D0NTF500<000000=79
d`3AbM<01P3AbM<010000000c<SF0000000000080<[1dP0300000036`MD0000000T0a;_B00@00000
0<6fd00000000000=`3oool2000000@0XIc@00<0000009bKd`2LVm<01P2LVm<00`000000VIK?0000
000909>Ed`030000002?Sm000000008000001@3GTHH00`000000ei660=NAQP020=NAQP800000203G
RW/00`000000iIIc0>FFL`030>FFL`8000001`3TSF<00`000000l9I@000000040>^6=@030000003Q
LQ@0000000800000:`3oool00`000000oooo0?ooo`0O0?ooo`00<@3oool200000480oooo00@00000
0?ooo`3oool000000P0000L01@000000000[0000:`0002/0000000T0A`aO0P00000305<OL@030000
001c>GT0LcUi00L0LcUi0P00000707Y5Q@030000003AbM<0dLWC00L0dLWC00<000000<[1dP3:`M80
2@3:`M800`000000a;_B0<BkdP070<BkdP0300000031]]00`KK@0080`KK@0P00000c0?ooo`800000
1`2QW=000`000000W9_C09bKd`0409bKd`050000002IU/l0VIK?09VFc`0000001`2CUM<00`000000
Sho@08n?d00208n?d0030000003GTHH0ei6600<0ei6600<000000=NAQP3GTHH0103GTHH3000000D0
ehYk00<000000>FFL`3UUW<01@3UUW<2000000D0i8eS00@000000?2FD03`UU000000103[QSD30000
00030:Tm003oool0oooo02X0oooo00<000000?ooo`3oool07P3oool00300oooo0P0000140?ooo`<0
000000<000070000000002/00P0002/2000000P0A`aO00<0000005<OL@1C7g400P1C7g400`000000
LcUi07<iN@0507<iN@<000002@1jAHD2000000H0dLWC0P0000000`3>`/l000000<[1dP080<[1dP04
00000037^ll00000000000H0a;_B00<000000<6fd031]]001@31]]03000002h0oooo0P0000000`2U
W/h000000:6Ld0070:6Ld0040000002LVm<0W9_C09bKd`8000001@2IU/l2000000@0TiGC00<00000
08n?d02?Sm000`2?Sm000`000000ei660=NAQP030=NAQP030000003GTHH0ei6600L0ei660P000003
0=N:N`030000003UUW<0iIIc00L0iIIc00<000000>B=H`3TSF<00P3TSF<01@000000l9I@0?2FD03`
UU00000000@0jhHe1000000/0?ooo`030000003oool0oooo01d0oooo000`0?ooo`030000003oool0
oooo04@0oooo00<0000000001`0000000`0002/00`00000040190000000704L<G`030000001C7g40
Dama00<0Dama00<0000007<iN@1c>GT00`1c>GT2000000`0NTF50P0000050=79d`030000003>`/l0
c/;?0080c/;?00<000000<[1dP3:`M801@3:`M800`000000ak_?0<Nkc`020<Nkc`0300000034^m80
a;_B0080a;_B00<000000<6fd031]]001P31]]000`000000_K7>0;facP02000002X0oooo0P000003
0:FNcP030000002QW=00XIc@00L0XIc@00<0000009bKd`0000002@2IU/l01@000000TiGC09>Ed`2C
UM<0000000D0Sho@00<000000=NAQP3GTHH00`3GTHH00`000000ei660=NAQP090=NAQP80000000<0
ehYk0000003UUW<02@3UUW<2000000<0i8eS00D000000?2FD03`UU00l9I@000000040>^6=@040000
003:HP000000000002/0oooo00<000000?ooo`3oool07@3oool00300oooo00<000000?ooo`3oool0
@`3oool3000000<0000[00@000000100B@0@04T000001@1735l2000000H0Dama00@0000007<iN@1c
>GT0LcUi0P00000>07Y5Q@030000003Eb/l0000000<0dLWC00<000000<k2c`3>`/l0103>`/l00`00
0000b/7B0<[1dP030<[1dP0300000037^ll0ak_?00@0ak_?0P0000000`34^m8000000<6fd0080<6f
d0030000002m/Lh0_K7>0080_K7>0P00000U0?ooo`<000001P2UW/h00`000000XIc@0:6Ld0070:6L
d0030000002IU/l0VIK?00T0VIK?00<0000009>Ed`0000001P2?Sm02000000@0ei6600<000000=NA
QP3GTHH02`3GTHH2000000`0iIIc00@000000>B=H`3TSF<00000103`UU0200000080jhHe0P000000
0`3:HP0000000?ooo`0[0?ooo`030000003oool0oooo01`0oooo000`0?ooo`030000003oool0oooo
04<0oooo0P0000030000:`040000000@04T04019000000D0A`aO00<0000005<OL@1C7g401P1C7g40
10000000LcUi00000000000@07Y5Q@040000003Eb/l000000=79d`800000203>`/l01@000000b/7B
0<[1dP3:`M80000000T0ak_?00<000000<6fd031]]001`31]]000`000000_K7>0;facP050;facPD0
0000703oool400000080ZZ3=00<000000:FNcP2UW/h01@2UW/h00`000000XIc@0:6Ld0040:6Ld080
000000<0WYS=0000002IU/l02P2IU/l00`000000Sho@08n?d00508n?d0040000003FUY0000000000
0080ei6600<000000=NAQP3GTHH0303GTHH3000000/0iIIc0`0000060?2FD0050000003[QSD0jhHe
0000003:HP000P00000[0?ooo`030000003oool0oooo01`0oooo000`0?ooo`030000003oool0oooo
0480oooo0P0000030000:`050000000@04T040190100B@0000000`1735l2000000T0Dama0P00000A
07Y5Q@8000000P3Eb/l00`000000c/;?0<k2c`090<k2c`030000003:`M80000000T0ak_?00@00000
0<>ec000000000001P31]]000`000000_K7>0;facP060;facP030000002j[Ld0^Zg=0080^Zg=1`00
000@0?ooo`D000001P2ZX<d00`000000YIk>0:FNcP060:FNcP040000002QW=00XIc@0:6Ld0800000
102NV<d00`000000VIK?09VFc`0709VFc`030000002FTL`0000000H0Sho@00@000000=JFT03FUY00
eYJ@0`00000>0=NAQP030000003TWH40i9f1008000002`3UUW<00`000000l9I@0?2FD0050?2FD006
0000003[QSD000000000003:HP000000:`3oool2000001d0oooo000`0?ooo`030000003oool0oooo
0440oooo0`0000020000:`030000000@04T040190080401900@0000004L<G`1735l000002@1C7g43
00000100NTF50P0000001P1oD8l000000=G:c`000000dL;;000000/0c/;?00<000000<Nkc`37^ll0
2037^ll010000000`kG<0<>ec033]L`2000000<0`KK@00<000000;facP2m/Lh01`2m/Lh00`000000
^Zg=0;Z]c@050;Z]c@040000002fZL`0]ZW<0;JYc10000000`2^Xl`00`000000ZZ3=0:ZPc@060:ZP
c@030000002UW/h0YIk>00D0YIk>00@000000:6Ld000000000001`2NV<d00`000000VIK?09VFc`05
09VFc`050000002FTL`0UY7<09JAc00000001@2?Sm000`000000eYJ@0=JFT0030=JFT0<00000303G
THH00`000000i9f10>BMP@020>BMP@030000003UUW<0iIIc00P0iIIc0P0000070?2FD0060000003[
QSD000000000003:HP0000009`3oool3000000030?ooo`000000oooo01`0oooo000`0?ooo`030000
003oool0oooo0440oooo0P0000030000:`030000000@04T04019008040190`00000905<OL@040000
001M;gl0GBmo000000h0NTF50P00000307m@S`8000000`3A`//00`000000c/;?0<k2c`070<k2c`04
0000003:^//00000000000L0ak_?00<000000<>ec033]L`01033]L`2000000030<6fd0000000_K7>
00L0_K7>00<000000;Z]c@2j[Ld01@2j[Ld00`000000]ZW<0;JYc0060;JYc0030000002bY/`0/ZK<
00@0/ZK<00<000000:jSc02^Xl`01@2^Xl`00`000000ZZ3=0:ZPc@060:ZPc@030000002UW/h0YIk>
00D0YIk>0P00000909jHc@030000002IU/l0VIK?00<0VIK?0P00000509JAc0030000002?Sm00Sho@
0080Sho@00<000000=JFT03FUY000`3FUY000`000000eYJ@0=JFT002000000X0ei6600<000000>BM
P@3TWH400`3TWH42000000P0iIIc00<000000?:RIP0000001`3`UU03000000030<YR00000000oooo
02<0oooo0`0000040?ooo`030000003oool0oooo01/0oooo000_0?ooo`030000003oool0oooo0440
oooo0`0000020000:`030000000@04T0401900<0401900<0000005<OL@1C7g401`1C7g42000000<0
GBmo00<0000007Y5Q@1jAHD02P1jAHD2000000D0Oe2?00<000000=72b`3A`//00`3A`//00`000000
c/;?0<k2c`050<k2c`030000003:^//0b[[;0080b[[;00<000000<Nkc`37^ll00`37^ll00`000000
`kG<0<>ec0070<>ec0800000202m/Lh00`000000^Zg=0;Z]c@050;Z]c@030000002fZL`0]ZW<00H0
]ZW<00<000000;:Vc02bY/`0102bY/`00`000000[Z?<0:jSc0060:jSc0030000002ZX<d0ZZ3=00H0
ZZ3=00<000000:FNcP2UW/h00P2UW/h200000080Y9[;00<0000009jHc@2NV<d01`2NV<d01@000000
VIK?09VFc`2IU/l0000000L0UY7<00<0000008n?d02?Sm000P2?Sm000`000000eYJ@0=JFT0030=JF
T0030000003FUY00eYJ@0080eYJ@0P0000080=NAQP030000003TWH40i9f100D0i9f10P0000060>FF
L`040000003bXVH0lZ9V000000L0l9I@0`0000000`3:HP0000000?ooo`0O0?ooo`<000001`3oool0
0`000000oooo0?ooo`0K0?ooo`00;`3oool00`000000oooo0?ooo`110?ooo`8000000P0002/00`00
000040190100B@030100B@800000201C7g400`000000GBmo05d_O`0305d_O`030000001jAHD0NTF5
00P0NTF50P00000707m@S`030000003A`//0dL;;00@0dL;;00<000000<k2c`3>`/l00`3>`/l00`00
0000b[[;0<Zjb`040<Zjb`0500000037^ll0ak_?0<Nkc`0000002@33]L`00`000000_k3:0;n`bP02
000000D0_K7>00<000000;Z]c@2j[Ld01P2j[Ld00`000000]ZW<0;JYc0060;JYc0030000002bY/`0
/ZK<00@0/ZK<00<000000:jSc02^Xl`01P2^Xl`00`000000ZZ3=0:ZPc@060:ZPc@030000002UW/h0
YIk>00800000102TV//00`000000WYS=09jHc@0809jHc@030000002IU/l0000000T0UY7<00<00000
08n?d02?Sm000P0000050=JFT0030000003FUY00eYJ@00@0eYJ@0`0000050=NAQP030000003TWH40
i9f100L0i9f10P0000040>FFL`050000003bXVH0lZ9V0?:RIP0000001`3`UU0010000000hH080000
0000000M0?ooo`<000002`3oool00`000000oooo0?ooo`0J0?ooo`00;`3oool200000440oooo0`00
00000`0002/000000100B@040100B@030000000T0640000000L0Dama00<0000005d_O`1M;gl0101M
;gl00`000000NTF507Y5Q@0507Y5Q@<000002@1oD8l00`000000dL;;0=72b`050=72b`050000003>
`/l0c/;?0<k2c`000000203:^//2000000030<Nkc`000000`kG<00P0`kG<00<000000;n`bP2o/<X0
0P2o/<X300000080_K7>00<000000;Z]c@2j[Ld01P2j[Ld00`000000]ZW<0;JYc0050;JYc0030000
002bY/`0/ZK<00D0/ZK<00<000000:jSc02^Xl`01P2^Xl`00`000000ZZ3=0:ZPc@060:ZPc@<00000
1`2TV//00`000000WYS=09jHc@0809jHc@030000002FTL`0UY7<00T0UY7<00@0000008n?d0000000
00001@3FUY000`000000eYJ@0=JFT0070=JFT08000000`3GTHH00`000000i9f10>BMP@090>BMP@03
0000003UUW<0iIIc0080iIIc00D000000?:RIP3bXVH0lZ9V000000060?2FD080000000<0hH080000
00000000603oool4000000h0oooo00<000000?ooo`3oool06P3oool002l0oooo00<000000?ooo`3o
ool0@03oool4000000D0401900@0000002@0H@0T064000001@1C7g42000000L0GBmo00<0000007Y5
Q@1jAHD00`1jAHD2000000`0Oe2?00<000000=72b`3A`//01P3A`//00`000000c/;?0000000;0<Zj
b`0300000033]L`0`kG<00L0`kG<00<000000;n`bP2o/<X01P2o/<X4000000H0^Zg=00<000000;JY
c02fZL`01P2fZL`00`000000/ZK<0;:Vc0060;:Vc0030000002^Xl`0[Z?<00D0[Z?<00<000000:ZP
c@2ZX<d00`2ZX<d3000000030:VLb@000000Y9[;00P0Y9[;00<0000009jHc@2NV<d01@2NV<d20000
000309bCb@000000UY7<00X0UY7<00<0000008^9c00000001P3FUY000`000000eYJ@0=JFT0080=JF
T080000000<0ei660000003TWH402`3TWH4200000080iIIc00<000000?:RIP3bXVH00P3bXVH20000
00@0l9I@0P0000000`3QP0P000000000000E0?ooo`<000004P3oool00`000000oooo0?ooo`0J0?oo
o`00;`3oool00`000000oooo0?ooo`0o0?ooo`@000001@0@04T010000000901Q02@0H@00000505<O
L@030000001M;gl0GBmo00L0GBmo00@0000007Y5Q@1jAHD0NTF50P00000>07m@S`030000003A`//0
dL;;00L0dL;;00<000000<Zjb`3:^//02@3:^//010000000a[C80000000000070<>ec0030000002o
/<X0_k3:00L0_k3:00<000000;b[b@2lZlT0100000020;Z]c@030000002fZL`0]ZW<00H0]ZW<00<0
00000;:Vc02bY/`01P2bY/`00`000000[Z?<0:jSc0060:jSc0030000002ZX<d00000008000001@2Y
W<T00`000000Y9[;0:BJb`070:BJb`030000002NV<d0WYS=0080WYS=0P00000409bCb@030000002F
TL`0UY7<00L0UY7<00@0000009>;b000000000001P3FUY000`000000eYJ@0=JFT00:0=JFT0800000
3P3TWH43000000H0lZ9V00P000000?2FD03`UU00l9I@0000003`V2d000000>60208000004@3oool3
000001D0oooo00<000000?ooo`3oool06P3oool002l0oooo00<000000?ooo`3oool0?`3oool30000
00D0401900D0000002@0H@0T0640901Q0000000305<OL@8000002P1M;gl010000000NTF500000000
000@07m@S`030000003A`//0dL;;00H0dL;;00<000000<fja`0000002P3:^//01@000000a[C80<Jd
b036]<P0000000D0`kG<00<000000;n`bP2o/<X01`2o/<X00`000000_:_90;b[b@050;b[b@L00000
102fZL`00`000000/ZK<0;:Vc0060;:Vc0030000002^Xl`0[Z?<0080[Z?<1P0000080:VLb@030000
002TV//0Y9[;00L0Y9[;00<0000009jHc@2NV<d00P00000709bCb@030000002FTL`0UY7<00D0UY7<
00@0000009>;b02CRlP0Th_80P0000050=JFT0030000003FUY00eYJ@00/0eYJ@0`00000>0>BMP@03
0000003bXVH0lZ9V00D0lZ9V00H000000?2FD03`UU0000000?2H;@0000020>6020030000003oool0
oooo00`0oooo0`00000H0?ooo`030000003oool0oooo01X0oooo000^0?ooo`030000003oool0oooo
03l0oooo100000040100B@030000000T0640901Q0080901Q00@0000005<OL@1C7g400000301M;gl2
00000180Oe2?00<000000=72b`3A`//01@3A`//010000000cK[70<fja`3=^/L2000000L0b[[;00<0
00000<Jdb036]<P00`36]<P2000000<0`kG<00<000000;n`bP2o/<X01`2o/<X00`000000_:_90;b[
b@070;b[b@030000002gYlP0]jO80080]jO84P0000040:jOb0030000002YW<T0ZIc900L0ZIc900<0
00000:BJb`2TV//01`2TV//3000000T0W9?900<0000009JAc02FTL`00`2FTL`2000000@0Th_800@0
00000=FKV000000000000`3FUY000`000000eYJ@0=JFT00;0=JFT0030000003SXhd0hj>=00800000
303TWH42000000L0lZ9V00L000000?2FD03`UU0000000?2H;@000000hH08008000002P3oool30000
01/0oooo00<000000?ooo`3oool06P3oool002h0oooo00<000000?ooo`3oool0?`3oool4000000<0
401900<0000002@0H@0T06400`0T0643000000/0GBmo0`00000B07m@S`8000001P3A`//00`000000
cK[70<fja`040<fja`030000003:^//0b[[;00<0b[[;00<000000<Jdb036]<P01P36]<P3000000T0
_k3:00<000000;b[b@2lZlT01`2lZlT00`000000]jO80;NWb0070;NWb0030000002cXlP0/j?800H0
/j?800<000000:jOb02^WlP01P2^WlP00`000000ZIc90:VLb@080:VLb@030000002TV//0Y9[;00@0
Y9[;0P0000020:>Ea`030000002LTlT0W9?900P0W9?900D0000009JAc02FTL`0UY7<0000000609>;
b0040000003EViP0eI^H0=FKV0@000003@3FUY000`000000hj>=0>>SS@020>>SS@030000003TWH40
i9f100T0i9f100<000000?:ZN00000001`3bXVH00`000000l9I@000000020?2H;@030000003QP0P0
000000L0oooo0`00000N0?ooo`030000003oool0oooo01X0oooo000^0?ooo`030000003oool0oooo
03h0oooo0`0000001@0001l000000100B@0@04T0000000H0901Q00<0000005d_O`1M;gl02P1M;gl0
10000000ISf;06HmR`00000@07m@S`80000000<0Q5VH0000000000001@3A`//00`000000cK[70<fj
a`050<fja`050000003:^//0b[[;0<Zjb`0000002`36]<P2000000P0_k3:00<000000;b[b@2lZlT0
1`2lZlT00`000000]jO80;NWb0070;NWb0030000002cXlP0/j?800H0/j?800<000000:jOb02^WlP0
1`2^WlP00`000000ZIc90:VLb@070:VLb@030000002TV//0Y9[;0080Y9[;0P0000040:>Ea`030000
002LTlT0W9?900T0W9?900<0000009JAc00000001`2CRlP00`000000eI^H0=FKV0040=FKV0800000
303FUY000`000000hj>=0>>SS@030>>SS@8000002@3TWH4010000000lZYh0?:ZN00000070?:RIP80
00000P3`V2d00`000000hH08000000040?ooo`<000008@3oool00`000000oooo0?ooo`0J0?ooo`00
;P3oool00`000000oooo0?ooo`0n0?ooo`@000000P0@04T00`000000901Q02@0H@0402@0H@800000
2P1M;gl2000000<0ISf;00<0000007m@S`1oD8l0301oD8l2000000<0Q5VH00<000000=G2a`000000
0`3A`//00`000000cK[70<fja`070<fja`80000000<0b[[;00000036]<P02@36]<P00`000000`Zk6
0<:^aP03000000D0_k3:00<000000;b[b@2lZlT01`2lZlT00`000000]jO80;NWb0070;NWb0030000
002cXlP0/j?800H0/j?800<000000:jOb02^WlP01`2^WlP00`000000ZIc90:VLb@080:VLb@040000
002TV//00000000000L0XiG700<0000009bCb@2LTlT02@2LTlT00`000000Th_809>;b00609>;b003
0000003EViP0eI^H00@0eI^H00<000000=FKV00000000P0000080=JFT0030000003SXhd0hj>=00H0
hj>=0P0000070>BMP@050000003bZWP0lZYh0?:ZN00000001`3bXVH01P000000l9P]0?2H;@3`V2d0
00000>6020@000009@3oool00`000000oooo0?ooo`0I0?ooo`00;P3oool00`000000oooo0?ooo`0m
0?ooo`<0000000@0000O0000000@04T000001P0T06400`000000=11d0000000905d_O`030000001V
?H/0ISf;00<0ISf;00<0000007m@S`1oD8l02P1oD8l2000000D0Q5VH00H000000=G2a`3E`/L00000
0=72b`00000<0<fja`0300000036]<P0a[C800T0a[C800<000000<:^aP32[/H00`32[/H300000003
0;n`bP000000_:_900T0_:_900<000000;NWb02gYlP01`2gYlP00`000000/j?80;>Sb0060;>Sb003
0000002^WlP0[Yo800L0[Yo800<000000:VLb@2YW<T01`2YW<T3000000T0XiG700<0000009bCb@2L
TlT01`2LTlT20000000309Z>a@000000Th_800D0Th_800<000000=FKV03EViP01@3EViP00`000000
eI^H0=FKV0020=FKV08000001P3FUY000`000000hj>=0>>SS@080>>SS@8000001@3TWH400`000000
lZYh0?:ZN0020?:ZN0030000003bXVH0lZ9V00@0lZ9V0P0000030?2H;@800000:03oool00`000000
oooo0?ooo`0I0?ooo`00;P3oool00`000000oooo0?ooo`0m0?ooo`<0000000<0000O000000000000
1P0T064010000000=11d03@@M000000805d_O`030000001V?H/0ISf;00@0ISf;00<0000007m@S`1o
D8l0201oD8l2000000L0Q5VH00D000000=G2a`3E`/L0eL;70000000<0<fja`0400000038//D00000
000000P0a[C800<000000<:^aP32[/H01`32[/H4000000L0_:_900<000000;NWb02gYlP0202gYlP0
0`000000/j?80;>Sb0070;>Sb0030000002^WlP0[Yo800H0[Yo800<000000:VLb@2YW<T0102YW<T3
000000030:RHa@000000XiG700X0XiG700<0000009bCb@2LTlT0102LTlT2000000<0VXk500<00000
09>;b02CRlP0102CRlP00`000000eI^H0=FKV0050=FKV0030000003EViP0eI^H00@0eI^H0`000003
0=JFT0030000003SXhd0hj>=00X0hj>=00<000000>BMP@3TWH400P3TWH400`000000lZYh0?:ZN003
0?:ZN0800000103bXVH2000000<0l9P]0P00000X0?ooo`030000003oool0oooo01T0oooo000]0?oo
o`<00000?@3oool300000080000O00<0000002@0H@0T0640100T06401@000000=11d03@@M00d47@0
000000H0GBmo0P00000806HmR`030000001oD8l0Oe2?00D0Oe2?0P00000908AIV0060000003E`/L0
eL;70000003@^L@000002`3=^/L010000000b;;50<Rba@38//D2000000H0a[C800<000000<:^aP32
[/H02032[/H00`000000_JW50;fYa@0500000080_:_900<000000;NWb02gYlP0202gYlP00`000000
/j?80;>Sb0070;>Sb0030000002^WlP0[Yo800L0[Yo800<000000:VLb@0000000`0000050:RHa@03
0000002SULL0XiG700T0XiG700@0000009bCb@2LTlT0W9?90P00000609Z>a@030000002CRlP0Th_8
00<0Th_800<000000=FKV03EViP01@3EViP00`000000eI^H0=FKV0070=FKV080000000<0eYJ@0000
003SXhd0303SXhd200000080i9f100<000000?:ZN03bZWP01@3bZWP01`000000lZ9V0?:RIP3bXVH0
00000?VZC00000000`3`V2d2000002L0oooo00<000000?ooo`3oool06@3oool002d0oooo00<00000
0?ooo`3oool0?@3oool30000000300007`000000000000D0901Q00<0000003@@M00d47@00P0d47@0
0`000000GBmo05d_O`0305d_O`030000001V?H/0ISf;00P0ISf;00<0000007m@S`1oD8l00`1oD8l2
000000`0Q5VH0P0000030=2ia0800000203=^/L00`000000b;;50<Rba@040<Rba@8000000`36]<P0
0`000000`Zk60<:^aP080<:^aP030000002mZLD0_JW500H0_JW5200000050;NWb0030000002cXlP0
/j?800L0/j?800<000000:jOb02^WlP00`2^WlP6000000T0Z9S500<000000:>Ea`2SULL02@2SULL0
10000000W9?900000000000909Z>a@030000002CRlP0Th_80080Th_800<000000=FKV03EViP01@3E
ViP00`000000eI^H0=FKV0090=FKV08000003`3SXhd3000000P0lZYh00@000000?:RIP3bXVH00000
0P3iZT`00`000000l9P]0?2H;@02000002L0oooo00<000000?ooo`3oool06@3oool002d0oooo00<0
00000?ooo`3oool0?@3oool200000080000O0P00000402@0H@030000000d47@0=11d00<0=11d00@0
000005d_O`1M;gl0GBmo0P00000;06HmR`040000001oD8l0Oe2?07m@S`8000003P24FIP00`000000
d;W40=2ia0040=2ia0030000003=^/L0cK[700@0cK[700<000000<Rba@38//D01`38//D200000003
0<Jdb0000000`Zk600T0`Zk600<000000;fYa@2mZLD0202mZLD00`000000^:C40;RTa0030;RTa1D0
0000102^W<D00`000000Z9S50:RHa@080:RHa@030000002SULL0XiG700T0XiG70P00000<09Z>a@03
0000002CRlP0Th_8008000001`3EViP00`000000eI^H0=FKV00:0=FKV0<000003`3SXhd00`000000
lZYh0?:ZN0070?:ZN0060000003bXVH0lZ9V0000003iZT`000000`3`V2d00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo01T0oooo000]0?ooo`030000003oool0oooo03d0oooo0P0000001000
01l000000000@@00000402@0H@030000000d47@0=11d00<0=11d00@0000005d_O`1M;gl000003@1V
?H/010000000Oe2?00000000000@08AIV0030000003@^L@0d;W400D0d;W400<000000<fja`3=^/L0
0`3=^/L00`000000b;;50<Rba@090<Rba@8000002@32[/H00`000000_JW50;fYa@090;fYa@030000
002hY<@0^:C400P0^:C400<000000;>Oa02cWl@01`2cWl@00`000000[Yc50:jLa@070:jLa@030000
002XV<D0Z9S500T0Z9S500<000000:>Ea`2SULL01@2SULL3000000030:6A``000000VXk500/0VXk5
00@0000009>;b0000000T8K50P0000060=FKV0030000003EViP0eI^H00X0eI^H00<000000>:XU`3R
Z9L00P00000=0>>SS@8000002@3bZWP00`000000lZ9V000000020?VZC0040000003`V2d0l9P]0000
02L0oooo00<000000?ooo`3oool06@3oool002d0oooo00<000000?ooo`3oool0?03oool200000080
000O00<000000000@@0000000`0T06400`000000=11d03@@M00403@@M0<000003P1V?H/200000180
Q5VH00<000000=2ia03@^L@01P3@^L@200000080cK[700<000000<Rba@38//D02@38//D00`000000
`jc30<>/``02000000L0`Zk600<000000;fYa@2mZLD02@2mZLD00`000000^:C40;RTa0080;RTa003
0000002cWl@0/io400L0/io400<000000:jLa@2^W<D0202^W<D00`000000Z9S50:RHa@080:RHa@03
0000002SULL0XiG700<0XiG70P0000050:6A``030000002JS/D0VXk500X0VXk500D000000926a@2@
Q/D000000=BOW`02000000@0eI^H00<000000=FKV03EViP02P3EViP00`000000hZRG0>:XU`020>:X
U`030000003SXhd0hj>=00X0hj>=00<000000?6aQ`0000002@3bZWP2000000<0nJY<00@000000?2H
;@00000000009`3oool00`000000oooo0?ooo`0H0?ooo`00;@3oool00`000000oooo0?ooo`0l0?oo
o`80000000@0000O00000000044000000`0T06400`000000=11d03@@M00503@@M0030000001V?H/0
ISf;00`0ISf;0`00000B08AIV08000002P3@^L@00`000000cK[70000000;0<Rba@0300000033[<<0
`jc30080`jc30`0000040<:^aP030000002mZLD0_JW500P0_JW500<000000;RTa02hY<@02@2hY<@0
0`000000/io40;>Oa0070;>Oa0030000002^W<D0[Yc500P0[Yc500<000000:RHa@2XV<D02@2XV<D0
0`000000XiG700000002000000L0XI7300<0000009Z>a@2JS/D0202JS/D20000000409R9`P000000
T8K5000000<0e9nO0`0000000`3EViP000000=FKV00;0=FKV0030000003RZ9L0hZRG00<0hZRG0P00
000:0>>SS@040000003a/HL0lK67000000T0lZYh00<000000?VZC03iZT`00P3iZT`00`000000l9P]
0000000W0?ooo`030000003oool0oooo01P0oooo000]0?ooo`030000003oool0oooo03`0oooo00H0
000000007`0001l000000000@@00000202@0H@030000000d47@0=11d00D0=11d0P00000=06HmR`04
0000001]BIH0KDVF00000100Q5VH0P0000000`27HIl000000=2ia00:0=2ia00300000038//D0b;;5
00T0b;;500<000000<>/``33[<<01P33[<<2000000030<:^aP000000_JW500X0_JW500<000000;RT
a02hY<@02@2hY<@00`000000/io40;>Oa0070;>Oa0030000002^W<D0[Yc500P0[Yc500<000000:RH
a@2XV<D0202XV<D3000000/0XI7300<0000009Z>a@2JS/D01@2JS/D2000000<0V8W200<000000926
a@0000001P3DWil2000000/0eI^H00<000000>:XU`3RZ9L01P3RZ9L2000000P0hj>=00D000000?6a
Q`3a/HL0lK67000000080?:ZN08000000`3iZT`00`000000l9P]0000000W0?ooo`030000003oool0
oooo01P0oooo000/0?ooo`030000003oool0oooo03d0oooo00<0000000007`0000000P0004400`00
0000901Q0000000703@@M003000000128h@0000000/0ISf;0P00000306e9UP0300000024FIP0Q5VH
00`0Q5VH0P00000308MQW`030000003@^L@0d;W400P0d;W400@000000<Za`@00000000002@38//D0
0`000000`jc30<>/``080<>/``@000002@2mZLD00`000000^:C40;RTa0080;RTa0030000002cWl@0
/io400T0/io400<000000:jLa@2^W<D01`2^W<D00`000000Z9S50:RHa@040:RHa@@0000000<0Z9C2
0000002QTL<02`2QTL<00`000000VXk509Z>a@0409Z>a@030000002HRL80V8W200@0V8W20P000007
0=BOW`@00000203EViP00`000000hZRG0>:XU`080>:XU`8000001@3SXhd00`000000lK670?6aQ`03
0?6aQ`030000003bZWP0lZYh00D0lZYh0P0000040?VZC0<000009P3oool00`000000oooo0?ooo`0H
0?ooo`00;03oool00`000000oooo0?ooo`0l0?ooo`030000000001l0000000<000110P00000703@@
M004000000128h@0@R>4000000T0ISf;0P00000506e9UP0300000024FIP0Q5VH00T0Q5VH0`000006
08MQW`030000003@^L@0d;W400L0d;W400@000000<Za`@3:/L40b[710P0000060<Rba@0300000033
[<<0`jc300X0`jc300<000000;jV`P2nY/801P0000030;fYa@030000002hY<@0^:C400P0^:C400<0
00000;>Oa02cWl@02@2cWl@00`000000[Yc50:jLa@080:jLa@030000002XV<D0000000<000001P2X
U<800`000000XI730:6A``0:0:6A``040000002JS/D0VXk509Z>a@8000001`2HRL800`000000e9nO
0=BOW`070=BOW`030000003DWil0e9nO008000001P3EViP00`000000hZRG0>:XU`0:0>:XU`030000
003SXhd0hj>=0080hj>=00<000000?6aQ`3a/HL0103a/HL2000000D0lZYh00<000000?bgI@000000
103iZT`2000002H0oooo00<000000?ooo`3oool0603oool002`0oooo00<000000?ooo`3oool0?03o
ool00`000000000O000000030000@@030000000d47@0=11d00D0=11d00D00000048SQ0128h@0@R>4
0000000806HmR`030000001]BIH0KDVF00H0KDVF00<0000008AIV024FIP01P24FIP2000000T0Qf6O
00<000000=2ia03@^L@01P3@^L@00`000000b[710<Za`@040<Za`@8000001038//D00`000000`jc3
0<>/``090<>/``030000002nY/80_ZK200L0_ZK21P0000080;RTa0030000002cWl@0/io400T0/io4
00<000000:jLa@2^W<D00`2^W<D7000000X0Z9C200<000000:6A``2QTL<02P2QTL<010000000VXk5
00000000000909R9`P030000003DWil0e9nO00L0e9nO00<000000=BOW`3DWil00P3DWil3000000<0
eI^H00<000000>:XU`3RZ9L02`3RZ9L200000080hj>=00<000000?6aQ`3a/HL01P3a/HL00`000000
lZYh0?:ZN0020?:ZN0040000003l]fD0o;MU000000<0nJY<0P00000V0?ooo`030000003oool0oooo
01P0oooo000/0?ooo`<00000?03oool2000000<000110P00000603@@M003000000128h@0@R>400<0
@R>400<0000006HmR`1V?H/00`1V?H/2000000T0KDVF00<0000008AIV024FIP00`24FIP3000000/0
Qf6O0`0000050=2ia0030000003:/L40b[7100L0b[710P0000000`38//D000000<>/``0;0<>/``03
0000002nY/80_ZK200X0_ZK200<000000;VQ`@2iXL401P0000020;RTa0030000002cWl@0/io400@0
/io42`0000050:jH`@030000002XU<80Z9C200X0Z9C200<000000:6A``2QTL<02@2QTL<2000000/0
V8W200<000000=BOW`3DWil01`3DWil00`000000e9nO0=BOW`050=BOW`80000000<0eI^H0000003R
Z9L03P3RZ9L3000000T0lK6700D000000?:ZN03bZWP0lZYh000000020?bgI@030000003iZT`0nJY<
0080nJY<00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0H0?ooo`00;03oool00`000000
oooo0?ooo`0l0?ooo`8000000`000442000000D0=11d00<00000048SQ0128h@010128h@00`000000
ISf;06HmR`0206HmR`030000001]BIH0KDVF00T0KDVF00@0000008AIV024FIP0Q5VH0P00000>08MQ
W`040000003B^<00d[S0000000<0d;W400<000000<Za`@3:/L402P3:/L43000000/0`jc300<00000
0;jV`P2nY/802P2nY/800`000000^J710;VQ`@060;VQ`@T000001@2cW<400`000000[YS10:jH`@08
0:jH`@030000002XU<80Z9C200X0Z9C200<000000:6A``2QTL<01P2QTL<3000000030:2=_`000000
V8W200X0V8W200<000000=BOW`3DWil01`3DWil00`000000e9nO0=BOW`070=BOW`8000004@3RZ9L0
0`000000lK670?6aQ`080?6aQ`040000003bZWP0lZYh000000<0o;MU00@000000?VZC03iZT`0nJY<
0P00000U0?ooo`030000003oool0oooo01P0oooo000P0?ooo`050?oDV`00000000000000002Ke?l0
1`3oool00`000000oooo0?ooo`0k0?ooo`8000000`0004400`000000001M0000000403@@M0030000
00128h@0@R>400D0@R>400<0000006HmR`1V?H/00P00000<06e9UP0400000024FIP0000000000100
Qf6O00@000000=:h`03B^<00d[S00P0000000`3@^L@000000<Za`@0;0<Za`@0300000035Z[l0aJZo
00<000002033[<<00`000000_ZK20;jV`P090;jV`P030000002iXL40^J7100T0^J7100<000000;>L
`@2cW<402@2cW<400`000000[YS10:jH`@090:jH`@030000002XU<80Z9C200X0Z9C200<000000:6A
``2QTL<00`2QTL<2000000D0X8fo00<0000009R9`P2HRL80202HRL800`000000e9nO0=BOW`070=BO
W`030000003DWil0e9nO00P0e9nO0`00000?0>:XU`8000002P3a/HL00`000000lZYh000000040?bg
I@030000003iZT`0nJY<008000009P3oool00`000000oooo0?ooo`0G0?ooo`00803oool01P2jLY/0
e?oo0?ooo`3oom@0V`2K0=Coo`D0oooo00<000000?ooo`3oool0?03oool2000000<0001100<00000
0000G@0000000`0d47@00`000000@R>4048SQ006048SQ0<000003P1]BIH2000001<0Qf6O00<00000
0=:h`03B^<000P3B^<000`000000b[710<Za`@0;0<Za`@0300000035Z[l0aJZo00<0aJZo0`000004
0<>/``030000002nY/80_ZK200X0_ZK200<000000;VQ`@2iXL402@2iXL400`000000/ic10;>L`@09
0;>L`@030000002^V<40[YS100T0[YS100<000000:RD`P2XU<802P2XU<800`000000XI730:6A``03
000000L0X8fo00<0000009R9`P2HRL80202HRL82000000P0e9nO00<000000=BOW`3DWil0203DWil0
0`000000h:bO0>2/W`02000000d0hZRG00<000000>nfT`0000002P3a/HL2000000D0o;MU00@00000
0?VZC000000000009P3oool00`000000oooo0?ooo`0G0?ooo`007`3oool00`3oe9/009_D0?ooo`02
0?ooo`030>ZjLP1b^^X0oooo00@0oooo00<000000?ooo`3oool0?03oool01@00000000110000@@00
044000000080001M00@0000003@@M00d47@000002@128h@00`000000KDVF06e9UP0<06e9UP<00000
5027HIl01P000000d[S00=:h`03B^<0000000<b`_@8000002P3:/L400`000000aJZo0<FZ_`070<FZ
_`<0000000<0`jc30000002nY/802`2nY/800`000000^J710;VQ`@090;VQ`@030000002cW<40/ic1
00T0/ic100<000000:jH`@2^V<402@2^V<400`000000Z9C20:RD`P090:RD`P@000002`2PSKl00`00
0000V8W209R9`P0509R9`P<0000000<0dj>V0000000000001P3DWil00`000000e9nO0=BOW`070=BO
W`030000003P[9l0h:bO00<0h:bO00<000000>:XU`3RZ9L02P3RZ9L010000000kkJC0>nfT`00000:
0?6aQ`030000003l]fD0o;MU00<0o;MU00@000000?VZC000000000009P3oool00`000000oooo0?oo
o`0G0?ooo`007`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00@0oooo00<00000
0?ooo`3oool0?03oool01@00000000110000@@00044000000080001M00<0000003@@M00000002@12
8h@2000000d0KDVF00@0000007=CW`1cDil000004`27HIl2000000<0d[S000@000000<b`_@3</;d0
c;2m0P0000080<Za`@0300000035Z[l0aJZo00X0aJZo0`00000;0;jV`P030000002iXL40^J7100T0
^J7100<000000;>L`@2cW<402P2cW<400`000000[YS10:jH`@080:jH`@030000002XU<80Z9C200D0
Z9C2100000020:N@_P030000002PSKl0X8fo00X0X8fo00<0000009R9`P2HRL800`2HRL8200000080
UXBn00@000000=>SYP3CXjH0dj>V0P0000040=BOW`030000003DWil0e9nO00L0e9nO00<000000>2/
W`3P[9l0103P[9l2000000X0hZRG00D000000>nfT`3_]Y<0kkJC000000090?6aQ`8000001@3l]fD0
10000000nJY<00000000000U0?ooo`030000003oool0oooo01L0oooo000O0?ooo`030>ZjLP1b^^X0
oooo0080oooo00<0omBK002Ke03oool0103oool00`000000oooo0?ooo`0l0?ooo`04000000000440
0011000000<0001M0P000009048SQ0030000001=<i40000000/0KDVF0P00000407=CW`0300000027
HIl0Qf6O00h0Qf6O0P0000001@2;JJH000000=:h`03B^<00000000H0c;2m0P0000050<Za`@030000
0035Z[l0aJZo00`0aJZo00<000000;nT_P0000000`0000060;jV`P030000002iXL40^J7100X0^J71
00<000000;>L`@2cW<402P2cW<400`000000[YS10:jH`@090:jH`@030000002XU<80Z9C200@00000
1`2WT;h00`000000X8fo0:2=_`0:0:2=_`050000002HRL80V8W209R9`P0000000`2FQ;h00`000000
dj>V0=>SYP040=>SYP<0000000<0e9nO0000003DWil0203DWil00`000000h:bO0>2/W`060>2/W`80
00001`3RZ9L00`000000kkJC0>nfT`030>nfT`030000003a/HL0lK6700H0lK670P0000060?bgI@<0
00009@3oool00`000000oooo0?ooo`0G0?ooo`007`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00@0oooo00<000000?ooo`3oool0>`3oool200000080001100D000000000G@0005d0
001M00000009048SQ0040000001=<i40CC>A000000X0KDVF00<0000007=CW`1cDil0101cDil00`00
0000Qf6O08MQW`0<08MQW`8000000`2;JJH010000000d[S00=:h`00000080<b`_@8000000`3:/L40
0`000000aJZo0<FZ_`0;0<FZ_`030000002oY;h0_jBn00@0_jBn100000020;jV`P030000002iXL40
^J7100X0^J7100<000000;>L`@2cW<402P2cW<400`000000[YS10:jH`@070:jH`@D000002`2WT;h0
0`000000X8fo0:2=_`0:0:2=_`040000002HRL800000000000@0UXBn00<000000=>SYP3CXjH01`3C
XjH2000000T0e9nO00<000000>2/W`3P[9l0203P[9l2000000D0hZRG00<000000>nfT`3_]Y<0103_
]Y<2000000H0lK6700<000000?foNP0000001@3l]fD3000002D0oooo00<000000?ooo`3oool05`3o
ool001l0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`040?ooo`030000003oool0
oooo03/0oooo0P0000000`00044000000000G@020000G@80000020128h@01@000000CC>A04dcT@1=
<i40000000T0KDVF00<0000007=CW`1cDil01@1cDil00`000000Qf6O08MQW`0908MQW`<000001@2;
JJH00`000000d[S00000000;0<b`_@<000003P35Z[l00`000000_jBn0;nT_P080;nT_PT000001P2i
XL400`000000/ic10;>L`@0:0;>L`@040000002^V<40[YS10:jH`@H000000P2]UKd00`000000Yi2n
0:N@_P0;0:N@_P030000002PSKl0X8fo00X0X8fo0P00000609J4_P030000003CXjH0dj>V00P0dj>V
100000060=BOW`030000003P[9l0h:bO00X0h:bO00<000000>:XU`3RZ9L00P3RZ9L00`000000kkJC
0>nfT`060>nfT`030000003a/HL0lK6700<0lK6700@000000?foNP3m_gX000001@3l]fD2000002D0
oooo00<000000?ooo`3oool05`3oool00200oooo00H0^W8009_Do`3oool0onZj0780V`3Dool40?oo
o`030000003oool0oooo03`0oooo0P0000000`00044000000000G@020000G@8000001`128h@00`00
0000CC>A04dcT@0204dcT@030000001]BIH0KDVF00D0KDVF0P00000807=CW`0300000027HIl0Qf6O
00L0Qf6O0P00000808]YYP030000003B^<00000000d0c;2m0P00000<0<FZ_`030000002oY;h0_jBn
00/0_jBn00<000000;VN_@2iW[d0102iW[dG000000P0[IFm00<000000:N@_P2WT;h0302WT;h00`00
0000X8fo0:2=_`060:2=_`<0000000<0WXRl0000002FQ;h01@2FQ;h00`000000dj>V0=>SYP080=>S
YP040000003CXjH0dj>V0=>SYP8000000`3DWil00`000000h:bO0>2/W`0<0>2/W`8000000P3RZ9L0
0`000000kkJC0>nfT`070>nfT`050000003a/HL0lK670?6aQ`0000000`3m_gX00`000000o;MU0?bg
I@030?bgI@030000003RWaX0000002D0oooo00<000000?ooo`3oool05P3oool00200oooo00D0oooD
09/000000000001b0;[Zo`050?ooo`030000003oool0000003`0oooo00<000080000000000000`00
05d00`0000002@1d00000006048SQ0030000001=<i40CC>A00@0CC>A00<0000006e9UP1]BIH00`1]
BIH00`000000Le>O07=CW`0807=CW`0300000027HIl0Qf6O00@0Qf6O0`00000:08]YYP8000003P3<
/;d00`000000aZRk00000002000000T0aJZo00<000000;nT_P2oY;h02P2oY;h00`000000^Ijm0;VN
_@0;0;VN_@030000002cVKd0/iVm00X0/iVm00<000000:fE_@2]UKd02P2]UKd00`000000Yi2n0:N@
_P0;0:N@_P030000002PSKl0X8fo00<0X8fo0`00000509j8_0030000002FQ;h0UXBn00<0UXBn00<0
00000=>SYP3CXjH0203CXjH00`000000dj>V0=>SYP030=>SYP80000000<0e9nO0000003P[9l03`3P
[9l3000000X0kkJC00@000000?6aQ`3a/HL00000103m_gX00`000000o;MU0?bgI@020?bgI@<00000
9@3oool00`000000oooo0?ooo`0F0?ooo`00:P3oool2000003`0oooo00@000000000200000000000
0`0005d00`0000002@1d00000005048SQ0030000001=<i40CC>A00D0CC>A00@0000006e9UP1]BIH0
KDVF0P00000<07=CW`0400000027HIl0Qf6O08MQW`8000003P2;JJH00`000000c;2m0<b`_@0;0<b`
_@0300000036Z;/0aZRk00<0aZRk100000050<FZ_`030000002oY;h0_jBn00X0_jBn00<000000;VN
_@2iW[d02`2iW[d00`000000/iVm0;>I_@0:0;>I_@030000002]UKd0[IFm00X0[IFm00<000000:N@
_P2WT;h0302WT;h00`000000X8fo00000002000000P0WXRl00<0000009J4_P2FQ;h00`2FQ;h00`00
0000dj>V0=>SYP080=>SYP030000003CXjH0dj>V00D0dj>V0P00000B0>2/W`030000003_]Y<0kkJC
00T0kkJC00<000000?6aQ`0000001@3m_gX010000000o;MU0?bgI@3l]fD3000002D0oooo00<00000
0?ooo`3oool05P3oool002X0oooo00<000000?ooo`3oool0>`3oool00`0000000008000000030000
G@050000000907@02@1d00T0M00000000`128h@00`000000CC>A04dcT@0604dcT@040000001]BIH0
KDVF000000h0Le>O00@0000008MQW`0000000000402;JJH3000000/0c;2m00<000000<JX^`36Z;/0
1`36Z;/3000000030<FZ_`000000_jBn00`0_jBn00<000000;VN_@2iW[d02`2iW[d00`000000/iVm
0;>I_@0:0;>I_@030000002]UKd0[IFm00X0[IFm00<000000:N@_P2WT;h02`2WT;h3000000/0WXRl
00<0000009J4_P2FQ;h00P2FQ;h00`000000dj>V0=>SYP090=>SYP030000003CXjH0dj>V00H0dj>V
0`00000@0>2/W`8000002`3_]Y<2000000H0oKmj00<000000?bgI@3l]fD00`00000U0?ooo`030000
003oool0oooo01H0oooo000Z0?ooo`030000003oool0oooo03/0oooo00<000000000200000000P00
05d00`0000002@1d00T0M00200T0M004000000128h@0@R>4000000T0CC>A0`00000?07=CW`800000
4P2;JJH00`000000cZji0<j^^@02000000P0c;2m00<000000<JX^`36Z;/02`36Z;/4000000/0_jBn
00<000000;VN_@2iW[d02`2iW[d00`000000/iVm0;>I_@0:0;>I_@030000002]UKd0[IFm00X0[IFm
00<000000:N@_P2WT;h01`2WT;h4000000030:J=^P000000WXRl00`0WXRl00D0000009J4_P2FQ;h0
UXBn0000000;0=>SYP030000003CXjH0dj>V00H0dj>V00<000000=j_Y`3N[jL00P00000>0>2/W`03
0000003]^Yd0000000/0kkJC00<000000?foNP3m_gX0103m_gX00`000000o;MU0?bgI@0200000003
0>:O6P000000oooo02<0oooo00<000000?ooo`3oool05P3oool002X0oooo00<000000?ooo`3oool0
>`3oool300000080001M00<0000000T0M00907@00P0907@00`000000@R>40000000:04dcT@030000
001cDil0Le>O00d0Le>O0`00000C08]YYP030000003>[[T0cZji0080cZji0P0000060<b`_@030000
0036Z;/0aZRk00`0aZRk00<000000<2R^P30X[X0100000060;nT_P030000002iW[d0^Ijm00/0^Ijm
00<000000;>I_@2cVKd02`2cVKd00`000000[IFm0:fE_@0;0:fE_@030000002WT;h0Yi2n00<0Yi2n
0`0000050:J=^P030000002NR;`0WXRl00/0WXRl00@0000009J4_P2FQ;h0UXBn0P00000:0=>SYP03
0000003CXjH0dj>V00D0dj>V00<000000=j_Y`3N[jL00`3N[jL2000000/0h:bO00@000000>fjW@3]
^Yd0kKZM0P0000090>nfT`8000001P3m_gX010000000o;MU0000003a]Sl2000002@0oooo00<00000
0?ooo`3oool05P3oool002X0oooo00<000000?ooo`3oool0>P3oool01P0000000008000000000000
001M000000D02@1d0P00000:04dcT@8000003P1cDil010000000N5fW07QMY`00000C08]YYP030000
003>[[T0cZji00@0cZji0P0000040<b`_@0300000036Z;/0aZRk00/0aZRk00<000000<2R^P30X[X0
1@30X[X400000080_jBn00<000000;VN_@2iW[d02`2iW[d00`000000/iVm0;>I_@0;0;>I_@030000
002]UKd0[IFm00/0[IFm00<000000:N@_P0000000`0000090:J=^P030000002NR;`0WXRl00/0WXRl
10000000103AYjd000000000000000080=>SYP030000003CXjH0dj>V00@0dj>V00<000000=j_Y`3N
[jL01@3N[jL2000000T0h:bO00<000000>fjW@3]^Yd00`3]^Yd00`000000kkJC0>nfT`060>nfT`80
00001`3m_gX2000000030?6f?`000000000002@0oooo00<000000?ooo`3oool05P3oool002T0oooo
00<000000?ooo`3oool0>`3oool01@00000000080000000005d0000000H02@1d00<0000004dcT@1=
<i40201=<i400`000000Ed6M0000000<07=CW`800000101hGJL00`000000RfVV08]YYP0?08]YYP80
0000203>[[T2000000030<b`_@000000aZRk00d0aZRk00<000000<2R^P30X[X02@30X[X6000000X0
^Ijm00<000000;>I_@2cVKd02`2cVKd00`000000[IFm0:fE_@050:fE_@P000003@2VSKX00`000000
WXRl09j8_00:09j8_08000000P2DOkX00`000000dJN]0=6W[@020=6W[@8000001P3CXjH00`000000
dj>V0=>SYP040=>SYP030000003N[jL0gZnW00L0gZnW0P0000070>2/W`030000003]^Yd0kKZM00@0
kKZM00<000000>nfT`3_]Y<01@3_]Y<00`000000nlJ;000000060?foNP80000000<0lKHo00000000
0000903oool00`000000oooo0?ooo`0F0?ooo`00:@3oool00`000000oooo0?ooo`0k0?ooo`<00000
00<0001M0000000907@0100907@2000000T0CC>A00D0000005M1W@1G@Id0Ed6M0000000907=CW`80
00001P1hGJL00`000000RfVV08]YYP0=08]YYP80000000<0SW2]0000003>[[T02@3>[[T3000000d0
aZRk00<000000<2R^P30X[X02`30X[X010000000^Ybi0;ZL^@2jW;T7000000<0^Ijm00<000000;>I
_@2cVKd01@2cVKd>000000H0[I6i00<000000:J=^P2VSKX0302VSKX00`000000WXRl09j8_00809j8
_080000000@0WHBh0000002DOkX000001`3AYjd3000000<0dj>V00<000000=>SYP3CXjH0103CXjH0
0`000000gZnW0=j_Y`090=j_Y`8000001@3P[9l00`000000kKZM0>fjW@050>fjW@030000003_]Y<0
kkJC00@0kkJC00@000000?_6R`3kaX/000001P3m_gX010000000lKHo0?6f?`00000U0?ooo`030000
003oool0oooo01D0oooo000Y0?ooo`030000003oool0oooo03/0oooo1000000600T0M0800000201=
<i400`000000Ed6M05M1W@0205M1W@030000001cDil0Le>O00H0Le>O00<0000007QMY`1hGJL01P1h
GJL00`000000RfVV08]YYP0;08]YYP800000102>L:d00`000000cZji0<j^^@080<j^^@0400000038
Y[L00000000000X0aZRk00<000000<2R^P30X[X03030X[X00`000000^Ybi0;ZL^@080;ZL^@/00000
1P2cU[T00`000000[I6i0:fA^@0;0:fA^@030000002VSKX0YXfj00`0YXfj00<0000009j8_02NR;`0
1@2NR;`3000000@0WHBh0P00000:0=6W[@@000001P3CXjH00`000000gZnW0=j_Y`0;0=j_Y`800000
0P3P[9l00`000000kKZM0>fjW@070>fjW@030000003_]Y<0kkJC0080kkJC00<000000?_6R`3kaX/0
0P3kaX/00`000000oKmj0?foNP030?foNP040000003a]Sl0lKHo000002D0oooo00<000000?ooo`3o
ool05@3oool002T0oooo00<000000?ooo`3oool0>`3oool4000000D02@1d00<0000001dBQ`000000
1`1=<i400`000000Ed6M05M1W@0305M1W@030000001cDil0Le>O00@0Le>O0P00000907QMY`030000
002;JJH0RfVV00T0RfVV0P00000608i`[@030000003>[[T0cZji00L0cZji00<000000<RV]`38Y[L0
0P38Y[L3000000L0aZRk00<000000<2R^P30X[X03030X[X00`000000^Ybi0;ZL^@0;0;ZL^@030000
002cU[T0/iJi00/0/iJi00<000000:fA^@2]TKT0302]TKT00`000000YXfj0:J=^P0<0:J=^P040000
002NR;`0WXRl09j8_0<000001`2MQ;P2000000d0dJN]0P0000040=>SYP030000003N[jL0gZnW00h0
gZnW0`00000:0>fjW@8000000P3_]Y<00`000000nlJ;0?_6R`020?_6R`030000003m_gX0oKmj00<0
oKmj0P0000000`3a]Sl000000000000T0?ooo`030000003oool0oooo01D0oooo000Y0?ooo`800000
?03oool00`0000P000000000000600T0M0030000000M4XL0000000D0CC>A0P00000605M1W@030000
001cDil0Le>O00<0Le>O00<0000007QMY`1hGJL02@1hGJL00`000000RfVV08]YYP0608]YYP<00000
202>L:d00`000000cZji0<j^^@070<j^^@0300000038Y[L0b:Jg00D0b:Jg0`0000040<JX^`030000
0030X[X0`::j00`0`::j00<000000;ZL^@2jW;T02`2jW;T00`000000/iJi0;>F^@0;0;>F^@030000
002]TKT0[I6i00`0[I6i00<000000:J=^P2VSKX0302VSKX010000000WXRl00000000000;09f4^003
0000003AYjd0dJN]00/0dJN]00<000000=6W[@0000000P0000000`3CXjH000000=j_Y`0A0=j_Y`03
0000003]^Yd0kKZM00X0kKZM00<000000>nfT`0000001@3kaX/00`000000oKmj0?foNP020?foNP80
000000<0lKHo000000000000903oool00`000000oooo0?ooo`0E0?ooo`00:03oool2000003`0oooo
0P0000000`0002l0000000T0M00400T0M0050000000M4XL07A:701dBQ`0000000`1=<i400`000000
Ed6M05M1W@0705M1W@030000001cDil0Le>O00800000301hGJL00`000000RfVV08]YYP0408]YYP80
00002`2>L:d00`000000cZji0<j^^@060<j^^@0300000038Y[L0b:Jg00T0b:Jg0P0000000`36Z;/0
00000<2R^P0=0<2R^P030000002jW;T0^Ybi00`0^Ybi00<000000;>F^@2cU[T02`2cU[T00`000000
[I6i0:fA^@0<0:fA^@030000002VSKX0YXfj00X0YXfj1000000=09f4^0030000003AYjd0dJN]00/0
dJN]00<000000=6W[@3AYjd00P3AYjd200000180gZnW0P00000<0>fjW@8000001P3kaX/01P000000
oKmj0?foNP000000nlMN00000080lKHo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0E
0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`80000000<0000_0000000907@00`0907@00`00
00007A:701dBQ`0201dBQ`040000001=<i40CC>A000000X0Ed6M0`00000?07QMY`040000002;JJH0
RfVV08]YYP8000003P2>L:d2000000H0cZji00<000000<RV]`38Y[L02`38Y[L4000000`0`::j00<0
00000;ZL^@2jW;T0302jW;T00`000000/iJi0;>F^@0<0;>F^@030000002]TKT0[I6i00/0[I6i00<0
00000:J=^P2VSKX01P2VSKX400000080YHVf00<0000009f4^02MQ;P0302MQ;P00`000000dJN]0=6W
[@0;0=6W[@030000003AYjd0dJN]00<0dJN]0`00000?0=j_Y`040000003Z_JL0j[fW000000`0kKZM
00<000000?_6R`3kaX/01@3kaX/00`000000oKmj000000020?_7GP030000003a]Sl0000002@0oooo
00<000000?ooo`3oool05@3oool002P0oooo00<000000?ooo`3oool0>`3oool4000000@02@1d00<0
000001dBQ`0M4XL00P0M4XL00`000000CC>A0000000;05M1W@030000001hGJL0N5fW00l0N5fW00@0
000008]YYP0000000000402>L:d010000000d:be0000000000040<j^^@0300000038Y[L0b:Jg00`0
b:Jg00<000000<6O]P31WkH01@0000070<2R^P030000002jW;T0^Ybi00`0^Ybi00<000000;>F^@2c
U[T0302cU[T00`000000[I6i0:fA^@0<0:fA^@030000002VSKX0YXfj00D000001`2URKH00`000000
WHBh09f4^00:09f4^0030000003AYjd0dJN]00/0dJN]0P0000040=6W[@040000003L/Zh0g;:^0=bb
[P8000003@3N[jL01@000000j[fW0>ZmY`3Z_JL0000000/0kKZM0P0000060?_6R`030000003m_gX0
00000080nlMN00<000000?6f?`000000903oool00`000000oooo0?ooo`0E0?ooo`00:03oool00`00
0000oooo0?ooo`0k0?ooo`040000000002l00000000000<02@1d00<0000001dBQ`0M4XL00`0M4XL2
000000/0Ed6M0P00000A07QMY`8000004P2>L:d010000000d:be0=2/]@3@[;D2000000030<j^^@00
0000b:Jg00d0b:Jg00<000000<6O]P31WkH01P31WkH500000080`::j00<000000;ZL^@2jW;T0302j
W;T00`000000/iJi0;>F^@0<0;>F^@030000002]TKT0[I6i00T0[I6i1P00000<0:F9]P030000002M
Q;P0WHBh00X0WHBh00<000000=6W[@3AYjd0203AYjd300000080dJN]00D000000=6W[@3AYjd0dJN]
000000050=bb[P8000002`3N[jL00`000000j[fW0>ZmY`020>ZmY`030000003]^Yd0kKZM00L0kKZM
00<000000?W;V@0000001`3kaX/200000080nlMN00<000000?6f?`0000009@3oool00`000000oooo
0?ooo`0D0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`070000000002l000000000DP000000
2@1d0000000601dBQ`030000001G@Id0Ed6M00T0Ed6M00@0000005m>YP1OCZH000003P1hGJL30000
01<0SW2]00<000000=2/]@3@[;D00`3@[;D3000000d0b:Jg00<000000<6O]P31WkH02`31WkH:0000
00L0^Ybi00<000000;>F^@2cU[T0302cU[T010000000[I6i0:fA^@2]TKT8000000<0[Hjf00<00000
0:F9]P2URKH0302URKH00`000000WHBh09f4^00909f4^0<000001P3AYjd3000000H0dJN]00@00000
0=6W[@3AYjd000001`3L/Zh00`000000gZnW0=j_Y`070=j_Y`030000003Z_JL0j[fW00@0j[fW00<0
00000>fjW@3]^Yd01P3]^Yd010000000nL^I0?W;V@0000070?_6R`060000003kaeh0nlMN0000003a
]Sl000009@3oool00`000000oooo0?ooo`0D0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`07
0000000002l000000000DP0000002@1d0000000501dBQ`8000002P1G@Id01@000000GdjV05m>YP1O
CZH0000000`0N5fW0P00000307aV[P030000002>L:d0SW2]0140SW2]00<000000=2/]@3@[;D00`3@
[;D00`000000bJBc00000002000000X0b:Jg00<000000<6O]P31WkH03@31WkH00`000000^YVf0;ZI
]P050;ZI]QX000002`2]S[H00`000000YHVf0:F9]P0=0:F9]P030000002MQ;P0WHBh00H0WHBh0P00
00000`2KOk@000000=2Z/P06000000T0dJN]00@000000=6W[@3AYjd00000203L/Zh2000000L0gZnW
00<000000>ZmY`3Z_JL01@3Z_JL2000000H0kKZM00D000000?W;V@3ibiT0nL^I000000060?_6R`04
0000003kaeh0nlMN0?_7GP8000009@3oool00`000000oooo0?ooo`0D0?ooo`00:03oool00`000000
oooo0?ooo`0k0?ooo`8000000P000582000000H07A:700<0000002dWU`000000201G@Id00`000000
GdjV05m>YP0205m>YP030000001hGJL0N5fW00T0N5fW00<0000007aV[P1lIZh00`1lIZh00`000000
SW2]08i`[@0@08i`[@800000103@[;D00`000000bJBc0<VT/`030<VT/`8000002038Y[L00`000000
`Inf0<6O]P0=0<6O]P030000002jVKH0^YVf00`0^YVf00<000000;>C]@2cTkD0302cTkD00`000000
[Hjf0:f>]P0=0:f>]P030000002URKH0YHVf00`0YHVf00<0000009f4^02MQ;P00`2MQ;P300000080
Vgnd00<000000=2Z/P0000001@00000;0=6W[@8000002`3L/Zh2000000D0gZnW00<000000>ZmY`3Z
_JL01`3Z_JL00`000000kKZM0>fjW@020>fjW@030000003ibiT0nL^I0080nL^I00<000000?_6R`3k
aX/0103kaX/200000080nlMN0P00000U0?ooo`030000003oool0oooo01@0oooo000W0?ooo`030000
003oool0oooo03`0oooo0P0000020000DP8000001@0M4XL010000000;BNG02dWU`00000705M1W@03
0000001OCZH0GdjV00<0GdjV00<0000007QMY`1hGJL01`1hGJL2000000H0O6J^00<0000008i`[@2>
L:d03P2>L:d200000003091g/`000000d:be00<0d:be00<000000<VT/`39Y;<01@39Y;<3000000@0
b:Jg00<000000<6O]P31WkH03P31WkH00`000000^YVf0;ZI]P0<0;ZI]P030000002cTkD0/i>e00`0
/i>e00<000000:f>]P2]S[H03@2]S[H00`000000YHVf0:F9]P0=0:F9]P030000002MQ;P000000080
0000102KOk@3000000H0d:Zb0P00000:0=6W[@030000003L/Zh0g;:^00/0g;:^0P0000030=j_Y`03
0000003Z_JL0j[fW00P0j[fW00D000000>fjW@3]^Yd0kKZM000000050?W;V@030000003kaX/0nlJ;
0080nlJ;00<000000?kCN00000000P3kaeh2000002D0oooo00<000000?ooo`3oool0503oool002L0
oooo00<000000?ooo`3oool0?03oool200000080001B00<0000001dBQ`0M4XL0100M4XL010000000
;BNG02dWU`00000605M1W@030000001OCZH0GdjV00D0GdjV00<0000007QMY`1hGJL0101hGJL20000
00P0O6J^00<0000008i`[@2>L:d02`2>L:d3000000@0T7Nc00D000000=2/]@3@[;D0d:be0000000:
0<VT/`<0000000<0b:Jg00000031WkH03P31WkH00`000000^YVf0;ZI]P0=0;ZI]P030000002cTkD0
/i>e00`0/i>e00<000000:f>]P2]S[H03@2]S[H00`000000YHVf0:F9]P0<0:F9]P<00000102KOk@3
0000000309]o]0000000d:Zb00P0d:Zb0`0000070=6W[@8000003P3L/Zh3000000`0j[fW00@00000
0>fjW@3]^Yd000001P3ibiT01`000000nlJ;0?_6R`3kaX/000000?kCN00000000`3kaeh00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo01@0oooo000W0?ooo`030000003oool0oooo03`0oooo
0P0000020000DP030000000M4XL07A:700<07A:700<0000002dWU`0]9iL00P0]9iL00`000000Ed6M
05M1W@0205M1W@030000001OCZH0GdjV00H0GdjV00<0000007QMY`1hGJL00`1hGJL00`000000O6J^
07aV[P0907aV[P030000002>L:d0SW2]00P0SW2]0P000007091g/`040000003@[;D0d:be000000h0
bJBc1000000=0<6O]P030000002jVKH0^YVf00d0^YVf00<000000;>C]@2cTkD0302cTkD00`000000
[Hjf0:f>]P0=0:f>]P030000002URKH0YHVf00P0YHVf10000000102TQK80000009]o]02KOk@30000
00@0Vgnd00<000000=2Z/P3@Z[802P3@Z[83000000@0dJN]00<000000=bb[P0000003`3L/Zh00`00
0000j[fW0>ZmY`0;0>ZmY`8000001`3ibiT01@000000nlJ;0?_6R`3kaX/000000080o]=h00@00000
0?_7GP3kaeh000009@3oool00`000000oooo0?ooo`0D0?ooo`009`3oool2000003d0oooo0P000002
0000DP030000000M4XL07A:700<07A:700<0000002dWU`0]9iL00P0]9iL01@000000Ed6M05M1W@1G
@Id0000000T0GdjV00@0000007QMY`1hGJL0N5fW0P00000<07aV[P030000002>L:d0SW2]00D0SW2]
0`000009091g/`040000003@[;D0d:be000000l0bJBc00<000000<:M/P32WK801@0000080<6O]P03
0000002jVKH0^YVf00d0^YVf00<000000;>C]@2cTkD03@2cTkD00`000000[Hjf0:f>]P0=0:f>]P03
0000002URKH0YHVf00<0YHVf100000050:B5/P<000001P2KOk@00`000000d:Zb0=2Z/P0>0=2Z/P80
000000D0dJN]0000003L/Zh0g;:^0000000?0=bb[P8000003@3Z_JL00`000000nL^I0?W;V@060?W;
V@040000003kaX/0nlJ;00000080o]=h00@000000?_7GP3kaeh000009@3oool00`000000oooo0?oo
o`0D0?ooo`009`3oool00`000000oooo0?ooo`0l0?ooo`06000000000580001B0000000006l00000
0`0M4XL00`000000;BNG02dWU`0302dWU`040000001G@Id0Ed6M000000/0GdjV0`00000>07aV[P03
0000002>L:d0SW2]0080SW2]0`00000<091g/`040000003@[;D0d:be000000l0bJBc00<000000<:M
/P32WK801@32WK8600000080`Inf00<000000;ZI]P2jVKH03@2jVKH00`000000/i>e0;>C]@0=0;>C
]@030000002]S[H0[Hjf00d0[Hjf00<000000:F9]P0000000`0000050:B5/P@0000000<0Y8Fb0000
002KOk@01P2KOk@00`000000d:Zb0=2Z/P0@0=2Z/P8000000`3L/Zh00`000000g;:^0=bb[P0;0=bb
[P040000003W`:l0il2_000000`0j[fW0P0000080?W;V@8000000`3ndgP010000000nlMN0?_7GP00
000V0?ooo`030000003oool0oooo01<0oooo000W0?ooo`030000003oool0oooo03`0oooo00H00000
0000DP00058000000000K`00000301dBQ`030000000]9iL0;BNG00@0;BNG0P00000<05m>YP030000
001lIZh0O6J^00l0O6J^00@0000008i`[@0000000000402@Mk<2000000l0bJBc00<000000<:M/P32
WK803032WK86000000`0^YVf00<000000;>C]@2cTkD03@2cTkD00`000000[Hjf0:f>]P0:0:f>]PD0
00001P2TQK83000000D0Y8Fb00<0000009]o]02KOk@01@2KOk@00`000000d:Zb0=2Z/P0A0=2Z/P<0
00000P3L/Zh00`000000g;:^0=bb[P0:0=bb[P050000003W`:l0il2_0>O0[`0000002P3Z_JL00`00
0000mLjU000000080?W;V@8000000`3ndgP010000000nlMN0?_7GP00000V0?ooo`030000003oool0
oooo01<0oooo000W0?ooo`030000003oool0oooo03`0oooo00H000000000DP00058000000000K`00
000201dBQ`030000000]9iL0;BNG00D0;BNG00<0000005m>YP1OCZH02P1OCZH200000140O6J^0P00
000B091g/`<000003P39Y;<00`000000`Yfb0<:M/P0>0<:M/P040000002kU[80^iJb0;^F/PP00000
102jVKH00`000000/i>e0;>C]@0=0;>C]@030000002]S[H0[Hjf0080[Hjf200000030:b:/P030000
002TQK80Y8Fb0080Y8Fb0`0000080:B5/P030000002KOk@0Vgnd00D0Vgnd00<000000=2Z/P3@Z[80
403@Z[8010000000f[Fd0=Ze]03J]K@2000000030=bb[P000000g;:^00T0g;:^00<000000>O0[`3W
`:l00`3W`:l00`000000j[fW0>ZmY`070>ZmY`040000003ecZD0mLjU000000P0nL^I00<000000?kC
N03ndgP00P3ndgP3000002H0oooo00<000000?ooo`3oool04`3oool002H0oooo00<000000?ooo`3o
ool0?@3oool01P000000001B0000DP000000001_000000807A:700<0000002dWU`0]9iL0100]9iL2
000000/0GdjV00@0000006II[`1VFJl000003P1lIZh3000001<0T7Nc0P000000103:XZl000000000
0000000;0<VT/`0300000032WK80`Yfb00h0`Yfb00<000000;^F/P2kU[802@2kU[8I000000/0[8Zb
00<000000:B5/P0000000P00000;0:B5/P030000002KOk@0Vgnd00<0Vgnd0P00000C0=2Z/P030000
003J]K@0f[Fd00<0f[Fd0`0000090=bb[P030000003W`:l0il2_00@0il2_00<000000>ZmY`3Z_JL0
1P3Z_JL01@000000mLjU0?G>Y@3ecZD0000000L0nL^I00<000000?kCN03ndgP00P3ndgP3000002H0
oooo00<000000?ooo`3oool04`3oool002H0oooo00<000000?ooo`3oool0?@3oool00`000000001B
000000030000K`8000001`0]9iL00`000000>cRT0000000905m>YP050000001VFJl0IUV_06II[`00
00003@1lIZh01@000000PFjd085^]021K[@000000180T7Nc00<000000<ZR[`3:XZl00`3:XZl30000
00P0bJBc00<000000<:M/P32WK803@32WK800`000000^iJb0;^F/P0>0;^F/P030000002cT;40/i2a
00d0/i2a00<000000:b:/P2/R[80302/R[83000000l0Y8Fb00<0000009]o]00000000P0000000`2J
Nk0000000000000B0=2Z/P030000003J]K@0f[Fd00D0f[Fd0P0000080=bb[P030000003W`:l0il2_
00D0il2_0P0000050>ZmY`030000003ecZD0mLjU00<0mLjU00<000000?W;V@3ibiT0103ibiT20000
00<0o]=h0`00000V0?ooo`030000003oool0oooo01<0oooo000V0?ooo`030000003oool0oooo03d0
oooo00<000000000DP0000000`0006l2000000H0;BNG00@0000003/hY00k>:@00000201OCZH00`00
0000IUV_06II[`0306II[`030000001lIZh0O6J^00P0O6J^0P000004085^]0030000002@Mk<0T7Nc
0140T7Nc00<000000<ZR[`3:XZl01@3:XZl3000000@0bJBc00<000000<:M/P32WK803P32WK800`00
0000^iJb0;^F/P0>0;^F/P030000002cT;40/i2a00d0/i2a00<000000:b:/P2/R[802@2/R[830000
00030:b:/P000000Y8Fb00h0Y8Fb0`00000409Yk/0030000003>[KP00000008000003P3@Z[800`00
0000f[Fd0=Ze]0070=Ze]0<000001@3L/Zh00`000000il2_0>O0[`080>O0[`030000003Z_JL0j[fW
0080j[fW00<000000?G>Y@3ecZD00`3ecZD00`000000nL^I0?W;V@030?W;V@030000003ofhd00000
00@0o]=h0P00000V0?ooo`030000003oool0oooo01<0oooo000V0?ooo`030000003oool0oooo03d0
oooo00<000000000DP0000000`0006l00`000000;BNG02dWU`0402dWU`050000000k>:@0>cRT03/h
Y00000001`1OCZH00`000000IUV_06II[`0406II[`030000001lIZh0O6J^00L0O6J^00<00000085^
]021K[@01@21K[@00`000000T7Nc091g/`0?091g/`8000002P3:XZl3000000030<VT/`000000`Yfb
00l0`Yfb00<000000;^F/P2kU[803P2kU[800`000000/i2a0;>@/@0=0;>@/@030000002/R[80[8Zb
00D0[8Zb100000050:b:/P030000002TQK80Y8Fb00P0Y8Fb100000000`2SPJh0000009Yk/00309Yk
/0030000003>[KP0cZfh00<0cZfh0`00000;0=2Z/P030000003J]K@0f[Fd00P0f[Fd00@000000=Ze
]000000000000`3L/Zh00`000000il2_0>O0[`090>O0[`050000003Z_JL0j[fW0>ZmY`0000001P3e
cZD00`000000nL^I0?W;V@020?W;V@040000003ofhd0om^=000000<0o]=h0P00000V0?ooo`030000
003oool0oooo01<0oooo000V0?ooo`030000003oool0oooo03h0oooo0P0000030000K`030000000]
9iL0;BNG00@0;BNG00D0000003/hY00k>:@0>cRT0000000605m>YP030000001VFJl0IUV_00D0IUV_
00<0000007aV[P1lIZh01@1lIZh2000000P0PFjd00<00000091g/`2@Mk<0302@Mk<30000000309=m
^0000000bZ:_00`0bZ:_1000000>0<:M/P030000002kU[80^iJb00h0^iJb00<000000;>@/@2cT;40
3@2cT;400`000000[8Zb0:b:/P020:b:/P<000002@2/R[800`000000Y8Fb0:B5/P040:B5/P@00000
1@2SPJh00`000000VW^`09Yk/00209Yk/0030000003>[KP0cZfh00H0cZfh0`0000080=2Z/P030000
003J]K@0f[Fd00T0f[Fd00<000000=Ze]03J]K@00`00000=0>O0[`040000003Z_JL0j[fW000000L0
mLjU00D000000?W;V@3ibiT0nL^I000000020?oKS@040000003ndgP0o]=h0?kCN08000009`3oool0
0`000000oooo0?ooo`0B0?ooo`009P3oool00`000000oooo0?ooo`0n0?ooo`040000000006l0001_
0000K`8000001@0]9iL00`000000>cRT03/hY00303/hY0030000001OCZH0GdjV0080GdjV00<00000
06II[`1VFJl01`1VFJl00`000000O6J^07aV[P0207aV[P8000002P21K[@00`000000T7Nc091g/`09
091g/`<000001@2COKP00`000000bZ:_0<ZR[`0;0<ZR[`0300000032VZh0`YZ^00D000002032WK80
0`000000^iJb0;^F/P0>0;^F/P030000002cT;40/i2a00h0/i2a00<000000:b:/P0000000P00000<
0:b:/P030000002TQK80Y8Fb00@000002P2SPJh01@000000VW^`09Yk/02JNk00000000/0cZfh0`00
00050=2Z/P030000003J]K@0f[Fd00T0f[Fd00<000000=Ze]03J]K@00P3J]K@00`000000il2_0>O0
[`0<0>O0[`8000002@3ecZD010000000nL^I0?W;V@0000020?oKS@040000003ndgP0o]=h0?kCN080
00009`3oool00`000000oooo0?ooo`0B0?ooo`009@3oool00`000000oooo0?ooo`0o0?ooo`070000
000006l0001_0000K`00000000270000000302dWU`030000000k>:@0>cRT00@0>cRT00D0000005m>
YP1OCZH0GdjV0000000:06II[`050000001lIZh0O6J^07aV[P0000003@21K[@00`000000T7Nc091g
/`06091g/`800000202COKP00`000000bZ:_0<ZR[`0:0<ZR[`0300000032VZh0`YZ^00H0`YZ^1P00
00020<:M/P030000002kU[80^iJb00h0^iJb00<000000;>@/@2cT;403@2cT;43000000/0[8Zb1`00
000>0:>1[P050000002JNk00VW^`09Yk/00000003P3>[KP3000000030=2Z/P000000f[Fd00`0f[Fd
00@000000=Ze]03J]K@0f[Fd0P00000>0>O0[`030000003ecZD0mLjU00L0mLjU00<000000?W;V@00
0000103ofhd00`000000o]=h0?kCN002000002L0oooo00<000000?ooo`3oool04P3oool002D0oooo
0`00000o0?ooo`070000000006l0001_0000K`00000000270000000302dWU`030000000k>:@0>cRT
00@0>cRT00@0000005m>YP1OCZH00000301VFJl3000000h0PFjd00<00000091g/`2@Mk<00`2@Mk<3
000000X0Tgfh00<000000<ZR[`3:XZl02P3:XZl00`000000`YZ^0<:J[P0<0<:J[PL00000302kU[80
0`000000/i2a0;>@/@0:0;>@/@<0000000<0/i2a0000002/R[800`2/R[88000000@0ZhN^00<00000
0:>1[P2SPJh03P2SPJh010000000VW^`09Yk/000000B0<j]^08000003P3J]K@00`000000f[Fd0000
00020>C3]P030000003W`:l0il2_00/0il2_0P0000090?G>Y@800000103ofhd00`000000o]=h0?kC
N002000002L0oooo00<000000?ooo`3oool04P3oool002D0oooo00<000000?ooo`3oool0?`3oool0
1`000000001_0000K`0006l000000000Q`0000000P0]9iL00`000000>cRT03/hY00603/hY0800000
3@1VFJl00`000000PFjd085^]00?085^]0030000002@Mk<00000008000003@2COKP00`000000bZ:_
0<ZR[`0:0<ZR[`0300000032VZh0`YZ^00h0`YZ^00<000000;^C[P2kTjh00P2kTjh8000000@0^iJb
00<000000;>@/@2cT;401P2cT;4=000000`0ZhN^00<000000:>1[P2SPJh03P2SPJh010000000VW^`
09Yk/000000C0<j]^0<000003@3J]K@2000000<0i<>f0P00000:0>O0[`030000003ad:l0000000X0
mLjU00<000000?oKS@3ofhd00P3ofhd00`000000o]=h00000002000002L0oooo00<000000?ooo`3o
ool04P3oool002D0oooo00<000000?ooo`3oool0?`3oool010000000001_0000K`0000020000Q`03
0000000]9iL0000000T0>cRT00<0000006II[`1VFJl02`1VFJl200000140PFjd0P00000A09=m^0<0
00002@3:XZl00`000000`YZ^0<:J[P0>0<:J[P030000002kTjh0^i>^00X0^i>^3P0000070;>=[P03
0000002[Qjh0ZhN^00h0ZhN^00<000000:>1[P2SPJh03`2SPJh00`000000VW^`0000000B0<j]^004
0000003G^;X0ekRj0=Nh^P8000002`3J]K@2000000D0i<>f00<000000>O0[`3W`:l01`3W`:l01000
0000lM2_0?7@[`0000090?G>Y@030000003ofhd0om^=00<0om^=1000000W0?ooo`030000003oool0
oooo0180oooo000U0?ooo`030000003oool0oooo03l0oooo0P0000000`0006l000000000Q`020000
Q`800000200k>:@2000000`0IUV_00@0000006eS]P1]HkH000003P21K[@300000180Tgfh00<00000
0<^OZ`3;Wj/0100000040<ZR[`0300000032VZh0`YZ^00l0`YZ^00<000000;^C[P2kTjh03P2kTjh0
0`000000/hf^0;>=[P03000000/0/hf^00<000000:^7[P2[Qjh03P2[Qjh00`000000Xh6^0:>1[P0?
0:>1[P030000002JNk0000000180cZfh00<000000=Nh^P3G^;X00`3G^;X2000000T0f[Fd0P000006
0>C3]P030000003W`:l0il2_00D0il2_00<000000?7@[`3ad:l00P3ad:l00`000000mLjU0?G>Y@05
0?G>Y@030000003mgih0000000@0om^=1000000W0?ooo`030000003oool0oooo0180oooo000U0?oo
o`030000003oool0oooo03l0oooo0P0000000`0006l000000000Q`020000Q`030000000k>:@0>cRT
00L0>cRT00<0000004M8[`0000002P1VFJl01@000000KF>f06eS]P1]HkH0000000d0PFjd00D00000
08Ae^P24MKX0Q7Fj0000000A09=m^0030000003;Wj/0bin[00@0bin[0`0000000`3:XZl000000<:J
[P0@0<:J[P030000002kTjh0^i>^00h0^i>^0`00000>0;>=[P030000002[Qjh0ZhN^00l0ZhN^00<0
00000:>1[P2SPJh0302SPJh4000001<0cZfh00<000000=Nh^P3G^;X01@3G^;X00`000000f[Fd0=Ze
]0060=Ze]0030000003T`kH0000000H0i<>f00<000000>O0[`3W`:l0103W`:l00`000000lM2_0?7@
[`030?7@[`030000003ecZD0mLjU00@0mLjU00<000000?gOWP0000001@3ofhd3000002L0oooo00<0
00000?ooo`3oool04P3oool002@0oooo00<000000?ooo`3oool0@03oool2000000030000K`000000
00270080002700<0000003/hY00k>:@01P0k>:@010000000AdR_04M8[`00000906II[`030000001]
HkH0KF>f00<0KF>f00<00000085^]021K[@02021K[@2000000@0Q7Fj00<0000009=m^02COKP0402C
OKP00`000000bin[0<^OZ`060<^OZ`@000003P32VZh00`000000^i>^0;^C[P0<0;^C[P@00000402c
SJh00`000000ZhN^0:^7[P0?0:^7[P030000002SPJh0Xh6^00P0Xh6^100000020:9lZP<000004@3>
[KP00`000000ekRj0=Nh^P070=Nh^P8000001@3J]K@01@000000i<>f0>C3]P3T`kH0000000H0i<>f
00<000000>O0[`3W`:l00P3W`:l00`000000lM2_0?7@[`040?7@[`030000003ecZD0mLjU00<0mLjU
00@000000?gOWP3mgih000001@3ofhd2000002T0oooo00<000000?ooo`3oool04@3oool002@0oooo
00<000000?ooo`3oool0@03oool3000000@000270P00000603/hY00300000017B:l0AdR_0080AdR_
00<0000006II[`1VFJl0101VFJl2000000H0KF>f00<00000085^]021K[@01`21K[@00`000000Q7Fj
08Ae^P0408Ae^P030000002COKP0Tgfh00l0Tgfh0P0000090<^OZ`0300000033UjX0`iNZ00@00000
2P32VZh00`000000^i>^0;^C[P090;^C[P<000000`2kTjh00`000000/hf^0;>=[P0?0;>=[P030000
002[Qjh0ZhN^00h0ZhN^00<000000:>1[P2SPJh0102SPJh4000000H0XWbZ0P000000103=/;d00000
00000000000>0<j]^0030000003G^;X0ekRj00T0ekRj0P0000030=Ze]0030000003T`kH0i<>f0080
i<>f00<000000>C3]P3T`kH0103T`kH200000080il2_00<000000?7@[`3ad:l01@3ad:l00`000000
mLjU0?G>Y@020?G>Y@050000003mgih0oMnN0?gOWP000000103ofhd2000002T0oooo00<000000?oo
o`3oool04@3oool002@0oooo00<000000?ooo`3oool0@@3oool00`0003/000000000Q`020000Q`03
0000000469X0000000H0>cRT00<0000004M8[`17B:l00P17B:l00`000000IUV_06II[`0306II[`03
0000001]HkH0KF>f00H0KF>f00<00000085^]021K[@01@21K[@2000000P0Q7Fj00<0000009=m^02C
OKP0302COKP20000000309F3_P000000bin[00P0bin[00<000000<>GZP33UjX01033UjX4000000H0
`YZ^00<000000;^C[P2kTjh01P2kTjh3000000H0^i>^00<000000;>=[P2cSJh03`2cSJh00`000000
ZhN^0:^7[P0>0:^7[P030000002SPJh0Xh6^00@000002P2RO:X00`000000cK2m0<f`_@030<f`_@<0
00002P3>[KP00`000000ekRj0=Nh^P0<0=Nh^P<000001P3T`kH00`000000i<>f0>C3]P050>C3]P80
00002@3ad:l010000000mLjU0?G>Y@0000040?gOWP040000003ofhd0om^=0?oKS@<00000:@3oool0
0`000000oooo0?ooo`0A0?ooo`00903oool00`000000oooo0?ooo`110?ooo`8000000`0008L01000
000011RJ00@HVP00000403/hY00300000017B:l0AdR_00@0AdR_00D0000006II[`1VFJl0IUV_0000
000:06eS]P0300000021K[@0PFjd0080PFjd0P00000:08Ae^P030000002COKP0Tgfh00X0Tgfh0P00
000409F3_P030000003;Wj/0bin[00H0bin[00<000000<>GZP33UjX02033UjX400000080`YZ^00<0
00000;^C[P2kTjh00P2kTjh4000000T0^i>^00<000000;>=[P2cSJh03`2cSJh00`000000ZhN^0:^7
[P0:0:^7[PL000003P2RO:X00`000000cK2m0<f`_@060<f`_@800000203>[KP00`000000ekRj0=Nh
^P0>0=Nh^P030000003T`kH0i<>f00@0i<>f00<000000>C3]P3T`kH01P3T`kH00`000000lM2_0?7@
[`080?7@[`030000003ecZD0000000@0oMnN00@000000?oKS@3ofhd0om^=0`00000Y0?ooo`030000
003oool0oooo0140oooo000T0?ooo`030000003oool0oooo0440oooo0P0000030000Q`0400000004
69X011RJ000000@0>cRT00<0000004M8[`17B:l01017B:l010000000IUV_06II[`00000;06eS]P05
00000021K[@0PFjd085^]00000003@24MKX00`000000Tgfh09=m^00709=m^08000001P2EPkh00`00
0000bin[0<^OZ`060<^OZ`0300000033UjX0`iNZ00`0`iNZ2`0000090;^C[P030000002cSJh0/hf^
00l0/hf^00<000000:^7[P2[Qjh00P2[Qjh8000000@0Zh>Y00<000000:9lZP2RO:X03P2RO:X00`00
0000cK2m0<f`_@080<f`_@<000001@3>[KP00`000000ekRj0=Nh^P0>0=Nh^P8000001P3T`kH00`00
0000i<>f0>C3]P050>C3]P8000002@3ad:l2000000H0oMnN00@000000?oKS@000000kMa]0P00000Y
0?ooo`030000003oool0oooo0140oooo000T0?ooo`<00000@@3oool2000000<0002700D0000000@H
VP0469X011RJ0000000203/hY00300000017B:l0AdR_00H0AdR_0P00000=06eS]P<000003P24MKX0
0`000000Tgfh09=m^00409=m^0<00000202EPkh00`000000bin[0<^OZ`050<^OZ`0300000033UjX0
`iNZ00h0`iNZ0`0000070;^@ZB000000302[PjT00`000000XWbZ0:9lZP0>0:9lZP030000003=/;d0
cK2m00/0cK2m0`0000000`3>[KP000000=Nh^P0?0=Nh^P040000003Pa;`0h<Bl000000H0i<>f00<0
00000>C3]P3T`kH00`3T`kH00`000000kM:h0000000:0?7@[`030000003mgih0oMnN00@0oMnN00@0
00000?oKS@000000kMa]0P00000Y0?ooo`030000003oool0oooo0140oooo000S0?ooo`800000@`3o
ool3000000030000Q`00000011RJ00<011RJ00<0000003/hY00000002@17B:l00`000000KF>f06eS
]P0<06eS]P0300000024MKX0Q7Fj00h0Q7Fj00<0000009=m^02COKP00P2COKP2000000`0UH>n00<0
00000<^OZ`3;Wj/0103;Wj/00`000000`iNZ0<>GZP0;0<>GZP<0000000<0`iNZ0000002kT:T0402k
T:T00`000000/hVY0;>9Z@0?0;>9Z@030000002[PjT0Zh>Y00h0Zh>Y00<000000:9lZP2RO:X03@2R
O:X00`000000cK2m0<f`_@0?0<f`_@800000403G^;X010000000h<Bl0>34_03Pa;`2000000D0i<>f
00<000000>C3]P3T`kH00P3T`kH010000000kM:h0>gB^00000090?7@[`030000003mgih0oMnN00@0
oMnN00@000000?oKS@000000kMa]0P00000Y0?ooo`030000003oool0oooo0140oooo00050?ooo`05
0?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002Ke0050?ooo`050=BK000000000000
0000002Ke?l01`3oool00`000000oooo0?ooo`120?ooo`<0000000<000270000000469X0100469X2
000000P0AdR_00<00000055E^0000000301]HkH200000140Q7Fj00@0000009=m^000000000003P2E
Pkh3000000@0bin[00<000000<>GZP33UjX02033UjX3000000@0`iNZ00<000000;^@Z@2kT:T03`2k
T:T00`000000/hVY0;>9Z@0?0;>9Z@030000002[PjT0Zh>Y00h0Zh>Y00<000000:9lZP2RO:X03@2R
O:X00`000000cK2m0<f`_@0?0<f`_@040000003E^[l00000000000d0ekRj00<000000>34_03Pa;`0
103Pa;`00`000000i<>f0>C3]P030>C3]P040000003T`kH0i<>f000000@0kM:h00<000000?7@[`3a
d:l01@3ad:l00`000000nN:/000000060?gOWP030000003]g6d0kMa]00800000:P3oool00`000000
oooo0?ooo`0@0?ooo`001@3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/00000
0000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo0?oo
o`120?ooo`<0000000<000270000000469X0100469X00`000000AdR_04M8[`0704M8[`030000001A
EKP0000000/0KF>f00@00000079]_@1bKKd000004024MKX200000140UH>n00<000000<bLYP000000
0P0000000`3;Wj/000000<>GZP060<>GZP<000001P33UjX00`000000^i2Y0;^@Z@0@0;^@Z@030000
002cRJT0/hVY00l0/hVY00<000000:^3Z@2[PjT03`2[PjT00`000000XWbZ0:9lZP090:9lZP@00000
4@3=/;d010000000eKZo0=Fj_`3E^[l2000000/0ekRj00<000000>34_03Pa;`01@3Pa;`00`000000
i<>f0>C3]P020>C3]P040000003T`kH0i<>f000000D0kM:h00<000000?7@[`3ad:l0103ad:l00`00
0000nN:/000000060?gOWP030000003]g6d0kMa]00800000:P3oool00`000000oooo0?ooo`0@0?oo
o`00103oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03o
ool01@3oool00`000000oooo0?ooo`120?ooo`<0000000<000270000000469X0100469X00`000000
AdR_04M8[`0604M8[`050000001AEKP0DEFh055E^00000002@1]HkH01@000000LVfm079]_@1bKKd0
000000h0Q7Fj0`00000B09F3_P030000003<W:H0c9bV0080c9bV100000000`33UjX0000000000002
000000T0`iNZ00<000000;^@Z@2kT:T0402kT:T00`000000/hVY0;>9Z@0?0;>9Z@030000002[PjT0
Zh>Y00l0Zh>Y00<000000:9lZP2RO:X0102RO:X5000000<0XGRV00<000000<f`_@3=/;d03P3=/;d0
0`000000eKZo0=Fj_`040=Fj_`8000002@3G^;X00`000000h<Bl0>34_0060>34_0030000003T`kH0
i<>f0080i<>f00<000000>C3]P0000001@3]d[P00`000000lM2_0?7@[`030?7@[`050000003ihZ`0
nN:/0?WR[00000001@3mgih010000000kMa]0>gLK@00000[0?ooo`030000003oool0oooo0100oooo
00040?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?oo
o`050?ooo`030000003oool0oooo0480oooo00@000000000>`0005l000001@0469X00`00000062nZ
0000000604M8[`030000001AEKP0DEFh0080DEFh00<0000006eS]P1]HkH01P1]HkH00`000000LVfm
079]_@03079]_@0300000024MKX0Q7Fj00T0Q7Fj0P00000308Ql`0030000002EPkh0UH>n00l0UH>n
00<000000<bLYP3<W:H00`3<W:H9000000P0`iNZ00<000000;^@Z@2kT:T0402kT:T00`000000/hVY
0;>9Z@0?0;>9Z@030000002[PjT0Zh>Y00l0Zh>Y00<000000:9lZP2RO:X0100000070:5hYP030000
003=/;d0cK2m00l0cK2m00<000000=Fj_`3E^[l01P3E^[l2000000H0ekRj00<000000>34_03Pa;`0
203Pa;`00`000000i<>f0>C3]P020>C3]P030000003]d[P0kM:h00D0kM:h00<000000?7@[`3ad:l0
0P3ad:l01@000000nN:/0?WR[03ihZ`0000000@0oMnN0P0000020>gLK@030000003oool0oooo02T0
oooo00<000000?ooo`3oool0403oool000@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D
0?ooo`0?0?ooo`030;Yb002Ke?l0oooo00D0oooo00<000000?ooo`3oool0@`3oool3000000D011RJ
00<0000001P_ZP0000001P17B:l00`000000DEFh055E^003055E^0030000001]HkH0KF>f00<0KF>f
0P000006079]_@0300000024MKX0Q7Fj00P0Q7Fj00<0000008Ql`028O<000`28O<000`000000UH>n
09F3_P0@09F3_P030000003<W:H0c9bV00<000002033U:H600000080`iNZ00<000000;^@Z@2kT:T0
402kT:T00`000000/hVY0;>9Z@0?0;>9Z@030000002[PjT0Zh>Y00d0Zh>Y1@00000;0:5hYP800000
3`3=/;d00`000000eKZo0=Fj_`090=Fj_`800000103G^;X00`000000h<Bl0>34_0090>34_0800000
0P3T`kH2000000L0kM:h00@000000?7@[`3ad:l00000103ihZ`00`000000oMnN0?gOWP020?gOWP80
00000P3]g6d00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0100oooo00040?ooo`030>Zj
LP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`00000000020000000307:j
jP3oool0oooo00D0oooo00<000000?ooo`3oool0@`3oool3000000D011RJ00@0000001P_ZP0H;jX0
00001017B:l00`000000DEFh055E^004055E^0030000001]HkH0KF>f0080KF>f00<00000079]_@1b
KKd01`1bKKd00`000000Q7Fj08Ae^P0508Ae^P8000001`28O<000`000000UH>n09F3_P0>09F3_P@0
000000<0c9bV00000033U:H03P33U:H7000000h0^i2Y00<000000;>9Z@2cRJT03`2cRJT00`000000
Zh>Y0:^3Z@070:^3Z@H000000P2ZOjD00`000000XGRV0:5hYP0;0:5hYP030000003;//8000000080
0000303=/;d00`000000eKZo0=Fj_`0;0=Fj_`80000000<0ekRj0000003Pa;`03@3Pa;`200000080
kM:h00<000000>gB^03]d[P01@3]d[P00`000000lM2_000000050?WR[0040000003mgih0oMnN0?gO
WP8000000P3]g6d00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0100oooo00040?ooo`03
0?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`090?ooo`03
0000003oool0oooo04@0oooo0`00000500@HVP040000000H;jX062nZ000000@0AdR_00<00000055E
^01AEKP01@1AEKP010000000KF>f06eS]P00000:079]_@0300000024MKX0Q7Fj00@0Q7Fj00<00000
08Ql`028O<001`28O<000`000000UH>n09F3_P0<09F3_P@000000`3<W:H00`000000`iBV0<>DYP0?
0<>DYP030000002kSJD0^hfU0080^hfU2P0000040;^@Z@030000002cRJT0/hVY00l0/hVY00@00000
0:^3Z@2[PjT0Zh>Y1P0000080:YoY@030000002QN:H0XGRV00X0XGRV00<000000<^b`P3;//800`3;
//83000000P0cK2m00<000000=Fj_`3E^[l03P3E^[l2000000l0h<Bl00@000000>gB^03]d[P00000
1`3]d[P2000000H0nN:/00H000000?gOWP3mgih000000??XR@0000020>gLK@030000003oool0oooo
02T0oooo00<000000?ooo`3oool0403oool000D0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;
0?ooo`030?ooe02K09/0e?oo00T0oooo00<000000?ooo`3oool0A03oool4000000<011RJ00<00000
01P_ZP0H;jX00P0H;jX010000000AdR_04M8[`000008055E^0030000001]HkH0000000`0LVfm00@0
000008Ae^P24MKX0Q7Fj0P00000;08Ql`0030000002EPkh0UH>n00P0UH>n0`00000409N9``040000
003<W:H0c9bV00000140`iBV00<000000;^=Y@2kSJD0302kSJDJ000000h0ZWnU00<000000:5hYP2Q
N:H02P2QN:H00`000000bk;20<^b`P060<^b`P<000001@3=/;d00`000000eKZo0=Fj_`0>0=Fj_`03
0000003Ma/80000000d0h<Bl00<000000>WC_`0000000P3]d[P00`000000kM:h0>gB^0050>gB^003
0000003ihZ`0nN:/00D0nN:/00D000000?gOWP000000lnR9000000020>gLK@030000003oool0oooo
02T0oooo00<000000?ooo`3oool0403oool000D0oooo00D0oooD09/000000000001b0;[Zo`0<0?oo
o`030?ooe02K000000000080000000<0002K0=Coo`3oool0103oool00`000000oooo0?ooo`150?oo
o`<000000`0469X00`00000062nZ01P_ZP0201P_ZP0300000017B:l0000000X0DEFh00<00000079]
_@1bKKd02`1bKKd010000000Q7Fj00000000000=08Ql`0030000002EPkh0UH>n00@0UH>n10000007
09N9``030000003<W:H000000180`iBV00<000000;^=Y@2kSJD0402kSJD00`000000/hJU0;>6Y@0?
0;>6Y@030000002ZOjD0ZWnU00l0ZWnU00<000000:5hYP2QN:H02P2QN:H00`000000bk;20<^b`P09
0<^b`P<0000000<0cK2m0000003E^[l0403E^[l010000000gLK20=g6`P00000<0>34_0030000003Y
dkl0000000<0kM:h00<000000>gB^03]d[P00`3]d[P2000000L0nN:/00L000000?gOWP000000lnR9
0000003]g6d0000002d0oooo00<000000?ooo`3oool03`3oool00280oooo00<000000?ooo`3oool0
A@3oool2000000050000O`00000011RJ00@HVP0000001@0H;jX2000000T0DEFh00<0000005]R`000
00003@1bKKd00`000000R7c008Ql`00>08Ql`0030000002EPkh0UH>n00D000002@2GRL<00`000000
c9bV0000000B0<>DYP030000002kSJD0^hfU0100^hfU00<000000;>6Y@2cQZD03`2cQZD00`000000
ZWnU0:YoY@0@0:YoY@030000002QN:H0XGRV00P0XGRV00<000000<^b`P3;//803@3;//8200000100
eKZo00<000000=g6`P3Ma/800P3Ma/800`000000h<Bl0>34_0080>34_0050000003Ydkl0jM>o0>WC
_`0000000`3]d[P00`000000kM:h0>gB^0020>gB^0030000003ei;P0000000L0nN:/00H000000??X
R@3cj8T000000>gLK@00000]0?ooo`030000003oool0oooo00l0oooo000R0?ooo`800000AP3oool2
000000050000O`00000011RJ00@HVP0000001@0H;jX00`000000DEFh055E^008055E^0030000001K
H/00000000`0LVfm00<0000007Qe``0000003`28O<05000000d0UhW31000000@0<>DYP030000002k
SJD0^hfU0100^hfU00<000000;>6Y@2cQZD03`2cQZD00`000000ZWnU0:YoY@0@0:YoY@030000002Q
N:H0XGRV00P0XGRV00<000000<^b`P3;//803@3;//8010000000d[c500000000000>0=Fj_`030000
003Ma/80gLK200<0gLK200<000000>34_03Pa;`01P3Pa;`00`000000jM>o0>WC_`030>WC_`050000
003]d[P0kM:h0>gB^00000000P3]d[P010000000mNBh0?GT^00000070?WR[0030000003cj8T0lnR9
00<00000;@3oool00`000000oooo0?ooo`0?0?ooo`008P3oool00`000000oooo0?ooo`150?ooo`80
00000P0007l2000000H062nZ0P000008055E^0050000001KH/00Ff;005]R`00000002@1bKKd20000
0080N7G300<0000008Ql`028O<002P28O<030000000308Ql`0000000000000l0UhW30P0000020<BA
X@D000002`33U:H00`000000^hfU0;^=Y@0@0;^=Y@030000002cQZD0/hJU00l0/hJU00<000000:Yo
Y@2ZOjD0402ZOjD00`000000XGRV0:5hYP040:5hYP@00000403;//8010000000d[c50=:la@3B_<D2
000000/0eKZo00<000000=g6`P3Ma/801@3Ma/82000000H0h<Bl00<000000>WC_`3Ydkl00`3Ydkl0
1@000000kM:h0>gB^03]d[P000000080kM:h00@000000?GT^03ei;P000001P3ihZ`200000080lnR9
0P00000^0?ooo`030000003oool0oooo00l0oooo000Q0?ooo`030000003oool0oooo04L0oooo0P00
00000`0007l000000000000501P_ZP030000000Z@[L0000000L0DEFh00<0000005]R`01KH/000P1K
H/000`000000LVfm079]_@06079]_@030000001hML<0N7G300<0N7G300<0000008Ql`028O<001P28
O<0300000080R7c00`00000A09N9``0300000034TJ40a96Q00D0a96Q100000070<>DYP030000002k
SJD0^hfU0100^hfU00<000000;>6Y@2cQZD0402cQZD00`000000ZWnU0:YoY@0?0:YoY@030000002Q
N:H0XGRV00@000000`2OLj400`000000bk;20<^b`P0=0<^b`P030000003B_<D0d[c500@0d[c50P00
00080=Fj_`030000003Ma/80gLK200P0gLK200<000000>34_03Pa;`00P3Pa;`00`000000jM>o0>WC
_`050>WC_`040000003]d[P0kM:h0>gB^0800000103ei;P00`000000nN:/0?WR[0030?WR[0800000
0P3cj8T2000002h0oooo00<000000?ooo`3oool03`3oool00240oooo00<000000?ooo`3oool0A`3o
ool200000080001o00<0000001P_ZP0H;jX00`0H;jX010000000:T:g02Y2]`000005055E^0030000
001KH/00Ff;000@0Ff;000<00000079]_@1bKKd0101bKKd00`000000N7G307Qe``0507Qe``030000
0028O<00R7c00080R7c00`00000308Ql`08000000`2;Q<H00`000000UhW309N9``0>09N9``030000
0034TJ40a96Q00T0a96Q1@0000020<>DYP030000002kSJD0^hfU0100^hfU00<000000;>6Y@2cQZD0
402cQZD00`000000ZWnU0:YoY@0;0:YoY@L000001`2OLj400`000000bk;20<^b`P0=0<^b`P030000
003B_<D0d[c500H0d[c50P0000060=Fj_`030000003Ma/80gLK200T0gLK200@000000>34_03Pa;`0
00002@3Ydkl01@000000kM:h0>gB^03]d[P0000000@0mNBh00<000000?WR[03ihZ`00P3ihZ`00`00
0000mO2O000000020??XR@800000;P3oool00`000000oooo0?ooo`0?0?ooo`008@3oool00`000000
oooo0?ooo`170?ooo`8000000P0007l00`00000062nZ01P_ZP0301P_ZP040000000Z@[L0:T:g0000
00D0DEFh00<0000005]R`01KH/00101KH/000`000000LVfm079]_@03079]_@030000001hML<0N7G3
00H0N7G31@00000508Ql`0030000002;Q<H0RhC600<0RhC600<0000009N9``2GRL<03P2GRL<00`00
0000a96Q0<BAX@0>0<BAX@`000002@2kSJD00`000000/hJU0;>6Y@0@0;>6Y@030000002ZOjD0ZWnU
0080ZWnU2@0000040:UkX@030000002OLj40Wg>Q00H0Wg>Q00<000000<^b`P3;//803@3;//800`00
0000d[c50=:la@090=:la@8000000`3E^[l00`000000gLK20=g6`P0;0=g6`P030000003Pa;`00000
00X0jM>o00D000000>gB^0000000mNBh000000040?GT^0040000003ihZ`0nN:/00000080mO2O00@0
00000??XR@3cj8T00000;`3oool00`000000oooo0?ooo`0?0?ooo`008@3oool00`000000oooo0?oo
o`170?ooo`8000000P0007l2000000@062nZ00D0000002Y2]`0Z@[L0:T:g00000003055E^0030000
001KH/00Ff;000H0Ff;000<00000079]_@1bKKd00P00000707Qe``@000001P28O<02000000L0RhC6
00<0000009N9``2GRL<03P2GRL<00`000000a96Q0<BAX@0?0<BAX@030000002kRJ40^hVQ00L0^hVQ
8@00000=0:UkX@030000002OLj40Wg>Q00H0Wg>Q0P00000>0<^b`P030000003B_<D0d[c500/0d[c5
0P0000000`3E^[l000000=g6`P0=0=g6`P030000003Ydkl0jM>o00T0jM>o00D000000>gB^0000000
mNBh000000040?GT^0040000003ihZ`0nN:/00000080mO2O00@000000??XR@3cj8T00000;`3oool0
0`000000oooo0?ooo`0?0?ooo`008@3oool00`000000oooo0?ooo`180?ooo`030000000007l0001o
008000000`0H;jX00`000000:T:g02Y2]`0302Y2]`030000001AEKP0000000T0Ff;000<00000079]
_@0000001P1hML<3000000@0N7G300@0000008Ql`028O<00R7c00P00000908^4aP030000002GRL<0
UhW300d0UhW30P00000A0<BAX@030000002kRJ40^hVQ0100^hVQ00<000000;:2X@2bPZ40402bPZ40
0`000000ZG^Q0:UkX@0?0:UkX@030000002OLj40Wg>Q00H0Wg>Q00<000000<Rea`0000000`000009
0<^b`P030000003B_<D0d[c500h0d[c500<000000=g6`P3Ma/80303Ma/800`000000i=C60000000;
0>WC_`050000003ei;P0mNBh0?GT^00000000`3ei;P00`000000nN:/000000030?G`W`040000003c
j8T0000000000300oooo00<000000?ooo`3oool03P3oool00240oooo00<000000?ooo`3oool0B03o
ool01P000000001o0000O`00000000RI0000008062nZ00<0000002Y2]`0Z@[L00`0Z@[L00`000000
DEFh0000000:05]R`0030000001hML<0N7G30080N7G30`00000707Qe``0400000028O<0000000000
00`0RhC600<0000009N9``2GRL<02@2GRL<30000000309V?b0000000a96Q0100a96Q00<000000;^9
X@2kRJ40402kRJ400`000000/X:Q0;:2X@0@0;:2X@030000002YNj40ZG^Q00l0ZG^Q00<0000009mc
X@2OLj401@2OLj400`000000b;G70<Rea`040<Rea`<000001P3;//800`000000d[c50=:la@0=0=:l
a@030000003IalP0000000d0gLK200@000000>CDaP3Te<H000002@3Ydkl2000000@0mNBh00@00000
0?GT^03ei;P0mNBh0P0000030?G`W`030000003cj8T000000340oooo00<000000?ooo`3oool03P3o
ool00240oooo00<000000?ooo`3oool0B03oool01P000000001o0000O`00000000RI0000008062nZ
00<0000002Y2]`0Z@[L0100Z@[L00`000000Ff;005]R`00805]R`0030000001SKLL0000000<00000
2`1hML<00`000000RhC608^4aP0<08^4aP030000002GRL<0UhW300L0UhW30P00000509V?b0030000
0034TJ40a96Q00d0a96Q00<000000;^9X@2kRJ404@2kRJ400`000000/X:Q0;:2X@0@0;:2X@030000
002YNj40ZG^Q0100ZG^Q00<0000009mcX@2OLj40102OLj400`000000b;G70<Rea`070<Rea`@00000
00<0bk;20000003B_<D03`3B_<D00`000000fLO80=W7b002000000X0gLK200<000000>CDaP3Te<H0
0P3Te<H00`000000jM>o0>WC_`060>WC_`030000003`i<40000000@0mNBh00@000000?GT^03ei;P0
0000103el9l300000340oooo00<000000?ooo`3oool03P3oool00200oooo00<000000?ooo`3oool0
BP3oool00`000000001o000000020008V@030000000H;jX0000000H0:T:g0P00000905]R`0<00000
3@1hML<00`000000OGg90000000>08^4aP030000002GRL<0UhW300<0UhW30`00000709V?b0D00000
2`34TJ400`000000^hVQ0;^9X@0@0;^9X@030000002bPZ40/X:Q0140/X:Q00<000000:UkX@2YNj40
402YNj400`000000Wg>Q09mcX@0309mcX@0300000038]LL0b;G700`0b;G70P00000?0=:la@030000
003IalP0fLO800<0fLO800<000000=g6`P3Ma/801P3Ma/800`000000i=C60>CDaP040>CDaP030000
003Ydkl0jM>o00@0jM>o00@000000?3T`@3`i<4000001@3ei;P3000000@0mO2O0`00000a0?ooo`03
0000003oool0oooo00h0oooo000P0?ooo`030000003oool0oooo04X0oooo00D000000000O`0007l0
00000008V@02000000H0:T:g00<0000003UC`@0000001@1KH/04000000<0Hfg700<0000007Qe``1h
ML<0201hML<200000080OGg900<0000008^4aP2;Q<H0302;Q<H00`000000UhW309N9``03000000/0
VHo800@000000<B>W034SY`0a8jL100000070<BAX@030000002kRJ40^hVQ0100^hVQ00<000000;:2
X@2bPZ404@2bPZ400`000000ZG^Q0:UkX@0@0:UkX@030000002OLj40Wg>Q00@000003P38]LL01000
0000ckk:00000000000=0=:la@030000003IalP0fLO800@0fLO800<000000=g6`P3Ma/801@3Ma/80
0`000000i=C60>CDaP040>CDaP030000003Ydkl0jM>o00<0jM>o00<000000?3T`@3`i<400P3`i<40
0`000000mNBh0?GT^0020?GT^0<00000103el9l200000380oooo00<000000?ooo`3oool03P3oool0
0200oooo0P00001<0?ooo`030000000007l00000008000RI00<0000002Y2]`0Z@[L0100Z@[L01@00
0000>E?103UC`@000000Ff;000<000000`1KH/000`000000Hfg706=]a`0206=]a`030000001hML<0
N7G300H0N7G300<0000007emb@1mOLT00`1mOLT00`000000RhC608^4aP0<08^4aP8000003P2ISlP0
0`000000a8jL0<B>W0050<B>W0D000000P34TJ400`000000^hVQ0;^9X@0@0;^9X@030000002bPZ40
/X:Q0140/X:Q00<000000:UkX@2YNj40302YNj47000000<0WFjL00<000000<Rea`38]LL03038]LL0
10000000ckk:0<nnbP3?_/X2000000X0d[c500<000000=W7b03IalP01P3IalP00`000000gLK20=g6
`P030=g6`P030000003Te<H0i=C600H0i=C600<000000>WC_`3Ydkl00P3Ydkl00`000000l>C10?3T
`@020?3T`@030000003ei;P0mNBh0080mNBh0`0000040?G`W`800000<P3oool00`000000oooo0?oo
o`0>0?ooo`00803oool00`000000oooo0?ooo`1;0?ooo`030000000007l00000008000RI0P000005
02Y2]`030000000iDl400000008000001@1KH/000`000000Hfg706=]a`0306=]a`030000001hML<0
N7G300D0N7G300<0000007emb@1mOLT01@1mOLT00`000000RhC608^4aP0908^4aP80000000<0SX[;
0000002ISlP03@2ISlP00`000000a8jL0<B>W00:0<B>W0`000002@2kRJ400`000000/X:Q0;:2X@0A
0;:2X@030000002YNj40ZG^Q0080ZG^Q2P0000040:QfW0030000002MKY`0WFjL0080WFjL00<00000
0<Rea`38]LL03038]LL00`000000ckk:0<nnbP040<nnbP030000003B_<D0d[c500H0d[c500<00000
0=W7b03IalP0203IalP200000080gLK200<000000>CDaP3Te<H0203Te<H010000000jM>o0>WC_`00
00050?3T`@050000003ei;P0mNBh0?GT^00000000P3dlk4010000000mO2O0?G`W`3el9l2000003<0
oooo00<000000?ooo`3oool03P3oool00200oooo00<000000?ooo`3oool0C03oool20000008000RI
0P00000402Y2]`<000000P0iDl400`000000Ff;005]R`00205]R`0030000001SKLL0Hfg700D0Hfg7
00<0000007Qe``1hML<00`1hML<00`000000OGg907emb@0607emb@030000002;Q<H0RhC600L0RhC6
0P00000308j:b`030000002ISlP0VHo800d0VHo800<000000<B>W034SY`02`34SY`00`000000^hJL
0;^6W0070;^6W28000003P2XMY`00`000000WFjL09e^W00209e^W00300000038]LL0b;G700`0b;G7
00<000000<nnbP3?_/X01@3?_/X2000000H0d[c500<000000=W7b03IalP02P3IalP00`000000gLK2
0000000;0>CDaP030000003Ydkl0000000H0l>C100@000000?GT^03ei;P000000P3dlk4200000080
mO2O0P00000d0?ooo`030000003oool0oooo00d0oooo000P0?ooo`030000003oool0oooo04`0oooo
0P0000020008V@03000000009Jd0000000@000001@0iDl401@000000Ff;005]R`01KH/00000000P0
Hfg700<0000007Qe``1hML<00P00000:07emb@030000002;Q<H0RhC600@0RhC60P00000608j:b`03
0000002ISlP0VHo800`0VHo800<000000<B>W034SY`02`34SY`00`000000^hJL0;^6W00@0;^6W003
0000002bOY`0/WjL0140/WjL00<000000:QfW02XMY`0402XMY`01@000000WFjL09e^W02MKY`00000
00h0b;G700<000000<nnbP3?_/X0203?_/X2000000<0d[c500<000000=W7b03IalP0303IalP00`00
0000i=C60>CDaP0;0>CDaP030000003`i<40l>C100D0l>C100<000000?GT^0000000103dlk440000
03D0oooo00<000000?ooo`3oool03@3oool001l0oooo00<000000?ooo`3oool0CP3oool00`000000
00RI0008V@03000000<0:T:g00<0000003UC`@0iDl40100iDl400`000000Ff;00000000906=]a`03
0000001hML<0000000d0OGg900@0000008^4aP2;Q<H0RhC60P00000808j:b`030000002ISlP0VHo8
00d0VHo800<000000<B>W034SY`02P34SY`00`000000^hJL0;^6W00@0;^6W0030000002bOY`0/WjL
0140/WjL00<000000:QfW02XMY`0402XMY`010000000WFjL09e^W02MKY`2000000d0b;G700<00000
0<nnbP3?_/X02P3?_/X2000000030=:la@000000fLO800`0fLO800<000000>3Dc00000002`3Te<H2
000000P0l>C10P0000040?Cc/@@00000=@3oool00`000000oooo0?ooo`0=0?ooo`007`3oool00`00
0000oooo0?ooo`1=0?ooo`D000000P009Jd010000000:T:g02Y2]`00000603UC`@030000001KH/00
000000X0Hfg700<0000007emb@1mOLT0301mOLT010000000RhC600000000000;08j:b`030000002I
SlP0VHo800/0VHo80P00000<0<B>W0030000002kQY`0^hJL0100^hJL00<000000;9nW02bOY`04@2b
OY`00`000000Z7JL0:QfW00A0:QfW0050000002MKY`0WFjL00000036^<d00`0000090<Rea`030000
003?_/X0ckk:00d0ckk:00<000000=W7b03IalP0303IalP010000000h=C<0>3Dc00000090>CDaP04
0000003[i<T0jnC9000000L0l>C100<000000?Cc/@3dlk400`3dlk44000003D0oooo00<000000?oo
o`3oool03@3oool001l0oooo00<000000?ooo`3oool0BP3oool300000080oooo00@000000008V@00
29T000000P009Jd00`000000:T:g0000000703UC`@030000001SKLL0Hfg700P0Hfg700<0000006]g
c@0000003P1mOLT00`000000SX[;08j:b`0<08j:b`030000002ISlP0VHo800P0VHo80P0000000`2J
ULd000000000000;0<B>W0030000002kQY`0^hJL0100^hJL00<000000;9nW02bOY`04@2bOY`00`00
0000Z7JL0:QfW00A0:QfW0030000002MKY`0000000D0a[S=100000050<Rea`030000003?_/X0ckk:
00`0ckk:00@000000=G8c@00000000002`3IalP00`000000h=C<0>3Dc0020>3Dc0030000003Te<H0
i=C600D0i=C600D000000>_Tb@3[i<T0jnC9000000060?3T`@8000001@3dlk44000003D0oooo00<0
00000?ooo`3oool03@3oool001l0oooo00<000000?ooo`3oool0A`3oool3000000D0oooo0P000000
100029T00000000U[@009Jd2000000P0>E?10P00000906=]a`040000001[Mld0JgO=000000`0OGg9
00<000000866cP0000003@2>R//00`000000VHo809V?b00609V?b0800000102JULd5000000L0a8jL
00<000000;^6W02kQY`0402kQY`00`000000/WjL0;9nW00A0;9nW0030000002XMY`0Z7JL0140Z7JL
00<0000009e^W00000002@36^<d3000000030<Rea`000000ckk:00h0ckk:00D000000=G8c@3Eb<d0
eLS=000000090=W7b0030000003Pe<`0h=C<00<0h=C<00<000000>CDaP3Te<H0103Te<H00`000000
jnC90>_Tb@020>_Tb@030000003`i<40l>C100<0l>C100<000000?3d_`0000001@3dlk401@000000
d>Il0000003oool0000003@0oooo00<000000?ooo`3oool03@3oool001l0oooo00<000000?ooo`3o
ool0A03oool3000000P0oooo0P0000000`0029T00000000U[@02000U[@030000000iDl40>E?100D0
>E?100<0000004MRbP000000201SKLL01@000000JgO=06]gc@1[Mld0000000/0OGg900@000000866
cP21Q/h000003P2>R//00`000000VHo809V?b00209V?b0<000001P2JULd00`000000a8ZF0<B:UP02
0<B:UPD000000P34SY`00`000000^hJL0;^6W00@0;^6W0030000002bOY`0/WjL0140/WjL00<00000
0:QfW02XMY`03@2XMY`6000000d0a[S=0P00000>0<nnbP030000003Eb<d0eLS=00<0eLS=00<00000
0=W7b03IalP01P3IalP00`000000h=C<0>3Dc0040>3Dc0030000003Te<H0i=C600<0i=C600<00000
0>_Tb@3[i<T00P3[i<T00`000000l>C10?3T`@030?3T`@030000003`m;l0000000D0m?>a0P000003
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool03@3oool001l0oooo00<000000?oo
o`3oool0@@3oool3000000`0oooo0`000003000U[@8000001P0iDl4010000000Af;:04MRbP000006
06=]a`030000001[Mld0JgO=00<0JgO=00<0000007emb@1mOLT01`1mOLT00`000000PHK>0866cP02
0866cP030000002>R//0SX[;00/0SX[;00<0000009V?b02ISlP00P00000:09ZEc@0300000034RYH0
a8ZF00H0a8ZF1`00000>0;^6W0030000002bOY`0/WjL0140/WjL00<000000:QfW02XMY`00`2XMY`:
000000@0Yg6F0P00000=0<Jhc@040000003<`<l00000000000/0ckk:00<000000=G8c@3Eb<d01@3E
b<d2000000D0fLO800<000000>3Dc03Pe<`01P3Pe<`01@000000i=C60>CDaP3Te<H0000000H0jnC9
00D000000?3T`@3`i<40l>C1000000020?3d_`030000003dlk40m?>a0080m?>a0`0000030?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool03@3oool001h0oooo00<000000?ooo`3oool0
?`3oool3000000l0oooo0`000003000U[@8000001P0iDl401@000000Af;:04MRbP17H/X0000000D0
Hfg700<0000006]gc@1[Mld0101[Mld00`000000OGg907emb@0407emb@8000001P21Q/h00`000000
SX[;08j:b`0:08j:b`<00000302JULd00`000000a8ZF0<B:UP080<B:UP030000002kPYH0^h:F0080
^h:F2P0000040;^6W0030000002bOY`0/WjL00P0/WjL3`00000>0:MaUP8000003@36^<d010000000
c<3?0<c0c`3<`<l2000000T0ckk:00<000000=G8c@3Eb<d01`3Eb<d01@000000fLO80=W7b03IalP0
000000X0h=C<00<000000>CDaP0000001`3[i<T010000000l>C10?3T`@0000030?3d_`030000003d
lk40m?>a0080m?>a00<000000=3VO0000000103oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo00`0oooo000N0?ooo`800000?03oool400000180oooo0`000003000U[@0300000009?Kd0
000000@0>E?100<0000004MRbP17H/X00`17H/X01@000000Hfg706=]a`1SKLL0000000P0JgO=00<0
000007emb@1mOLT00P1mOLT00`000000PHK>0866cP060866cP030000002>R//0SX[;00P0SX[;0P00
0002096Ad0030000002JULd0VYG=00X0VYG=00<000000<B:UP34RYH02034RYH00`000000^h:F0;^2
UP0<0;^2UPl000002@2aNYL00`000000Yg6F0:MaUP0A0:MaUP0300000036^<d0a[S=00/0a[S=00<0
00000<c0c`3<`<l0103<`<l2000000H0ckk:00<000000=G8c@3Eb<d02@3Eb<d2000000030=W7b000
0000h=C<00X0h=C<00<000000>_Tb@3[i<T01P3[i<T00`000000l>C1000000050?3d_`030000003d
lk40m?>a00<000001P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00`0oooo000N
0?ooo`030000003oool0oooo03P0oooo0`00000G0?ooo`<000000P009Jd0100000002Cfm00Tm_@00
000303UC`@0300000017H/X0Af;:00<0Af;:00@0000006=]a`1SKLL000002@1[Mld01@000000OGg9
07emb@1mOLT0000000X0PHK>00<0000008j:b`2>R//01@2>R//2000000@0TI7@00<0000009ZEc@2J
ULd02`2JULd00`000000a8ZF0<B:UP070<B:UP030000002kPYH0^h:F0100^h:F00<000000;5jU`2a
NYL04@2aNYL00`000000Yg6F0:MaUP0A0:MaUP0300000036^<d0a[S=00/0a[S=00<000000<c0c`3<
`<l01P3<`<l2000000<0ckk:00<000000=G8c@3Eb<d0303Eb<d00`000000h=C<0>3Dc0090>3Dc080
00002@3[i<T2000000D0l?Bo00@000000?Cc/@000000f_>J0P0000070?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool0303oool001h0oooo00<000000?ooo`3oool0=@3oool3000001X0
oooo00<000000000K@0000000P009Jd01@0000002Cfm00Tm_@09?Kd000000080>E?100<0000004MR
bP17H/X01017H/X00`000000Hfg70000000:06]gc@030000001mOLT0000000`0PHK>00<0000008j:
b`2>R//00P2>R//2000000L0TI7@00<0000009ZEc@2JULd02P2JULd00`000000a8ZF0<B:UP060<B:
UP030000002kPYH0^h:F0140^h:F00<000000;5jU`2aNYL04@2aNYL00`000000Yg6F0:MaUP0@0:Ma
UP0300000036^<d0a[S=00/0a[S=00<000000<c0c`3<`<l02@3<`<l2000000030<nnbP000000eLS=
00`0eLS=00<000000=_DdP0000002@3Pe<`010000000iN?@0>GSd00000080>_Tb@030000003`m;l0
l?Bo00@0l?Bo00<000000?Cc/@0000000P0000090?ooo`030000003oool0oooo02h0oooo00<00000
0?ooo`3oool0303oool001h0oooo00<000000?ooo`3oool0<P3oool3000001h0oooo0`000002000U
[@0400000009?Kd02Cfm00000080>E?100<0000004MRbP17H/X01@17H/X00`000000JgO=06]gc@0:
06]gc@0300000021Q/h0PHK>00/0PHK>00<0000008j:b`2>R//00P00000:096Ad0030000002JULd0
VYG=00X0VYG=00<000000<B:UP34RYH01@34RYH00`000000^h:F0;^2UP0A0;^2UP030000002aNYL0
/GZG0140/GZG00<000000:MaUP2WLIH0402WLIH2000000/0a[S=00<000000<c0c`3<`<l0303<`<l0
0`000000eLS=0=G8c@0;0=G8c@050000003Ke=80fmCB0=_DdP0000001`3Pe<`01@000000iN?@0>GS
d03Uhm00000000L0jnC90P0000060?3d_`80000000<0f_>J0000000000002@3oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo00`0oooo000N0?ooo`030000003oool0oooo02l0oooo0`00
000Q0?ooo`80000000@0002?000000009Jd000000`09?Kd2000000P0Af;:0P00000:06]gc@030000
001bPM<0000000d0PHK>0P00000<096Ad0030000002JULd0VYG=00T0VYG=0P0000070<B:UP030000
002kPYH0^h:F0140^h:F00<000000;5jU`2aNYL04@2aNYL00`000000Yg6F0:MaUP0@0:MaUP030000
0033^]400000008000002036^<d00`000000c<3?0<c0c`0;0<c0c`030000003AbM80000000/0eLS=
00<000000=_DdP3Ke=800`3Ke=800`000000h=C<0>3Dc0030>3Dc0030000003Uhm00iN?@00<0iN?@
00<000000>_Tb@3[i<T00`3[i<T00`000000jo?;000000060?3d_`@000002`3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo00`0oooo000N0?ooo`030000003oool0oooo02`0oooo0`00
000U0?ooo`80000000<0002?0000000000001009?Kd00`000000Af;:04MRbP0504MRbP040000001C
Km40DfoA000000P0JgO=00D0000007:1d`1bPM<0LX7C0000000;0866cP0300000025SM<0000000d0
TI7@00<0000009ZEc@2JULd01P2JULd200000080W9_B1@0000020<B:UP030000002kPYH0^h:F0140
^h:F00<000000;5jU`2aNYL04@2aNYL00`000000Yg6F0:MaUP0=0:MaUP<000001@33^]42000000D0
a[S=00<000000<c0c`3<`<l02`3<`<l010000000dLWB0=79dP3AbM82000000P0eLS=00<000000=_D
dP3Ke=80103Ke=800`000000h=C<0>3Dc0030>3Dc0030000003Uhm00iN?@00<0iN?@00<000000>_T
b@3[i<T00P3[i<T010000000jo?;0>_cb`0000060?3d_`040000003JliX00000000000`0oooo00<0
00000?ooo`3oool0;03oool00`000000oooo0?ooo`0<0?ooo`007@3oool00`000000oooo0?ooo`0Y
0?ooo`@00000:03oool2000000030000S`000000000000@02Cfm0P00000604MRbP050000001CKm40
DfoA05=_d@0000001`1[Mld00`000000LX7C07:1d`0207:1d`0300000021Q/h0PHK>00L0PHK>00D0
000008F=d`25SM<0QHgC0000000=096Ad0030000002JULd0VYG=0080VYG=0`00000409bKdP030000
0034QY00a8J@0080a8J@3000000:0;^2UP030000002aNYL0/GZG0140/GZG00<000000:MaUP2WLIH0
0`2WLIH:00000080YFb@00<000000<>jd@33^]401@33^]4300000080a[S=00<000000<c0c`3<`<l0
2P3<`<l00`000000dLWB0=79dP040=79dP030000003Eb<d0eLS=00@0eLS=00<000000=_DdP3Ke=80
1P3Ke=801@000000h=C<0>3Dc03Pe<`0000000L0iN?@00D000000>_Tb@3[i<T0jnC9000000020>_c
b`030000003`m;l0l?Bo00<0l?Bo0P0000000`3JliX000000?ooo`0=0?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool02`3oool001d0oooo00<000000?ooo`3oool09P3oool3000002d0
oooo0P0000000`0008l0000000Tm_@0300Tm_@030000000PD/X0000000D0Af;:00D0000005=_d@1C
Km40DfoA0000000606]gc@030000001bPM<0LX7C00@0LX7C00<000000866cP21Q/h01@21Q/h00`00
0000QHgC08F=d`0208F=d`030000002ATM00TI7@00/0TI7@00<0000009ZEc@2JULd00P00000809bK
dP0300000034QY00a8J@00<0a8J@00<000000;YmT@2jOI401`2jOI4T000000/0YFb@00<000000<>j
d@33^]402@33^]43000000/0c<3?00<000000=79dP3AbM801P3AbM800`000000eLS=0=G8c@020=G8
c@030000003Ke=80fmCB00P0fmCB00<000000>3Dc0000000203Uhm0010000000jnC90>_Tb@000003
0>_cb`030000003`m;l0l?Bo0080l?Bo0P0000000`3JliX000000000000>0?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool02`3oool001d0oooo00<000000?ooo`3oool08`3oool30000
0300oooo0P0000000`0008l000000000000300Tm_@040000000PD/X085;:000000<0Af;:00<00000
05=_d@1CKm400`1CKm400`000000JgO=06]gc@0206]gc@030000001bPM<0LX7C00H0LX7C00<00000
0866cP21Q/h00`21Q/h00`000000QHgC08F=d`0408F=d`030000002ATM00TI7@00/0TI7@0P00000:
09bKdP0300000034QY00a8J@00<0a8J@00<000000;YmT@2jOI404@2jOI400`000000/7FA0;1eT@0A
0;1eT@030000002UK900YFb@00h0YFb@00<000000<>jd@33^]402@33^]400`000000b<;D0<S2e002
000000T0c<3?00<000000=79dP3AbM801`3AbM82000000030=G8c@000000fmCB00/0fmCB00<00000
0>GSd03Uhm00203Uhm02000000D0jo?;00P000000?3d_`3`m;l000000=ok/P000000f_>J00000100
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0;0?ooo`007@3oool00`000000oooo
0?ooo`0P0?ooo`<00000=03oool010000000002?0000S`00000300Tm_@040000000PD/X085;:0000
00<0Af;:00<0000005=_d@1CKm40101CKm4010000000JgO=06]gc@00000:07:1d`0500000021Q/h0
PHK>0866cP0000002025SM<00`000000TI7@096Ad008096Ad080000000<0TiSE0000002LVm802P2L
Vm800`000000a8J@0<B6T0020<B6T0030000002jOI40^WfA0140^WfA00<000000;1eT@2`MI404@2`
MI400`000000YFb@0:E/T00=0:E/T00300000033^]40`k[A00X0`k[A00<000000<S2e038`]@00P38
`]@3000000D0c<3?00<000000=79dP3AbM802P3AbM800`000000fmCB0=_DdP0:0=_DdP8000002P3U
hm000`000000jo?;0>_cb`040>_cb`030000003`m;l0l?Bo0080000000<0f_>J0000003oool04@3o
ool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo00/0oooo000M0?ooo`030000003oool0
oooo01d0oooo0`00000g0?ooo`80000000<0002?0000000000000P09?Kd01@00000085;:021BbP0P
D/X000000080Af;:00<0000005=_d@1CKm401@1CKm400`000000JgO=0000000;07:1d`0300000021
Q/h0000000X0QHgC00<00000096Ad02ATM001@2ATM02000000<0TiSE00<0000009bKdP2LVm802@2L
Vm800`000000a8J@0<B6T0020<B6T0030000002jOI40^WfA0140^WfA00<000000;1eT@2`MI404@2`
MI400`000000YFb@0:E/T00=0:E/T00300000033^]40`k[A00T0`k[A00<000000<S2e038`]@01P38
`]@200000080c<3?00<000000=79dP3AbM802P3AbM800`000000e]CG0000000:0=_DdP040000003O
hMH0gn7F000000P0iN?@0P0000060>_cb`070000003`m;l000000=ok/P000000f_>J0000000C0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool02`3oool001d0oooo00<000000?ooo`3o
ool06P3oool3000003/0oooo00<000000000S`0008l00P0000000`09?Kd00000021BbP03021BbP80
00002@1CKm400`000000LX7C07:1d`0;07:1d`0300000025SM<0QHgC00T0QHgC00<00000096Ad02A
TM000`2ATM02000000H0TiSE00<0000009bKdP2LVm802@2LVm801@000000a8J@0<B6T034QY000000
01<0^WfA00<000000;1eT@2`MI404@2`MI400`000000YFb@0:E/T00<0:E/T00300000033^]40`k[A
00X0`k[A00<000000<S2e038`]@02038`]@2000000`0dLWB00D000000=KDe`3Fe=L0e]CG00000008
0=_DdP050000003OhMH0gn7F0=oQeP0000001`3Uhm000`000000i_;D000000060>_cb`8000000P3O
nk82000001D0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0;0?ooo`00703oool0
0`000000oooo0000000G0?ooo`@00000?`3oool010000000002?000000007Z/2000000D085;:00<0
000005=_d@1CKm401`1CKm42000000/0LX7C00<0000007R:f00000002`25SM<00`000000TI7@096A
d002000000T0TiSE00<0000009bKdP2LVm80202LVm801@000000a8J@0<B6T034QY00000001<0^WfA
00<000000;1eT@2`MI404@2`MI400`000000YFb@0:E/T00<0:E/T08000002P33^]400`000000b<;D
0<S2e0090<S2e0030000003=b]L0000000X0dLWB00<000000=KDe`3Fe=L00`3Fe=L00`000000fmCB
0=_DdP040=_DdP030000003OhMH0gn7F00<0gn7F00<000000>GSd03Uhm000`3Uhm0010000000i_;D
0>Kbe00000060>_cb`030000003Onk80go^b008000005P3oool00`000000oooo0?ooo`0X0?ooo`03
0000003oool0oooo00/0oooo000L0?ooo`8000005@3oool3000004@0oooo0P0000000`007Z/00000
00000005021BbP8000001`1CKm4010000000GW_H05ikf000000907:1d`050000001hR]P0N8[H07R:
f00000002`25SM<2000000/0TiSE00<0000009bKdP2LVm80202LVm89000000l0^WfA00<000000;1e
T@2`MI404@2`MI400`000000YFb@0:E/T0080:E/T0@000000P30_=L2000000P0`k[A00<000000<S2
e038`]@02038`]@010000000cL[G0<g:e`3=b]L2000000L0dLWB00<000000=KDe`3Fe=L0103Fe=L0
0`000000fmCB0=_DdP030=_DdP030000003OhMH0gn7F00@0gn7F00<000000>GSd03Uhm000P3Uhm00
1@000000i_;D0>Kbe03Vl]@0000000D0jo?;0P0000020=ok/P030000003oool0oooo01H0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0;0?ooo`00703oool00`000000oooo0?ooo`0A
0?ooo`<00000A`3oool01@000000002?000000007Z/0000000D085;:00<0000003=Ue00000001P1C
Km401@000000GW_H05ikf01NNmP0000000L0LX7C00<0000007R:f01hR]P00`1hR]P00`000000QHgC
08F=d`0708F=d`0300000029UMT0000000`0TiSE00<0000009bKdP2LVm801@2LVm8200000080WJ7G
00<000000<B1R@000000102jN8X:000000D0^WfA00<000000;1eT@2`MI404@2`MI4010000000YFb@
0:E/T02UK907000000<0Y6J:00<000000<2le`30_=L00P30_=L3000000@0`k[A00<000000<S2e038
`]@02@38`]@00`000000cL[G0<g:e`030<g:e`030000003AbM80dLWB00@0dLWB00<000000=KDe`3F
e=L01@3Fe=L01@000000fmCB0=_DdP3Ke=80000000P0gn7F00D000000>GSd03Uhm00iN?@00000003
0>Kbe0030000003[ll/0jo?;0080jo?;0P0000020=ok/P8000006@3oool00`000000oooo0?ooo`0W
0?ooo`030000003oool0oooo00X0oooo000L0?ooo`030000003oool0oooo00h0oooo0`00001;0?oo
o`80000000<001j[000000000000100PD/X010000000<fGD03=Ue000000505=_d@030000001NNmP0
GW_H0080GW_H0P00000507:1d`030000001hR]P0N8[H00<0N8[H00<0000008F=d`25SM<01P25SM<0
1@000000RIGI08VEf@29UMT0000000`0TiSE00<0000009bKdP2LVm800P2LVm82000000@0WJ7G00<0
00000<B1R@0000003P2jN8XM000000T0Y6J:00<000000<2le`30_=L01P30_=L200000080`k[A00<0
00000<S2e038`]@02038`]@00`000000cL[G0<g:e`050<g:e`030000003AbM80dLWB0080dLWB00<0
00000=KDe`3Fe=L01`3Fe=L00`000000fmCB000000090=oQeP040000003Uhm00iN?@000000@0i_;D
00<000000>_cb`3[ll/00P0000001@3Oo/D000000=ok/P3Onk80000001/0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0:0?ooo`00703oool00`000000oooo0?ooo`0;0?ooo`<00000
C`3oool200000003000NZ`000000000000<085;:00@0000003=Ue00cIM@0<fGD0P00000305=_d@03
0000001NNmP0GW_H00@0GW_H00D0000007:1d`1bPM<0LX7C0000000707R:f00300000025SM<0QHgC
00<0QHgC0P00000508VEf@030000002CV=D0TiSE00T0TiSE00<0000009bKdP2LVm800P00000709fQ
e`8000004`2jN8X00`000000[g2:0:m`RP0A0:m`RP030000002TIXX0Y6J:00X0Y6J:00<000000<2l
e`30_=L02030_=L2000000X0b<;D00<000000<g:e`3=b]L01`3=b]L2000000030=79dP000000e]CG
00X0e]CG00<000000=oQeP3OhMH02@3OhMH2000000D0i_;D00<000000>_cb`0000000`3Oo/D00`00
0000go^b0000000M0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool02P3oool001`0
oooo00<000000?ooo`3oool0203oool3000005<0oooo00D00000000NZ`00000003c000000003021B
bP030000000cIM@0<fGD0080<fGD00<0000005=_d@000000201NNmP00`000000LX7C0000000907R:
f00500000025SM<0QHgC08F=d`0000002029UMT00`000000TiSE09>He@0909>He@8000002@2MXML2
000001<0^WR:00<000000:m`RP2_L8X04@2_L8X00`000000Y6J:0:AVRP090:AVRP0300000030_=L0
`;cG00T0`;cG00@000000<C3f@00000000001`38`]@00`000000cL[G0<g:e`0:0<g:e`030000003F
e=L0e]CG00T0e]CG00<000000=WOg00000002P3OhMH00`000000i_;D0>Kbe0040>Kbe08000000`3O
o/D010000000go^b00000000000M0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
2P3oool001/0oooo00<000000?ooo`3oool01@3oool4000005L0oooo00D00000000NZ`00000003c0
00000002021BbP030000000cIM@0<fGD00<0<fGD0P00000905ikf0030000001hR]P0N8[H00T0N8[H
00<0000008F=d`0000002P29UMT00`000000TiSE09>He@0609>He@80000000<0UYkJ0000002MXML0
2@2MXML00`000000^WR:0;YhRP0A0;YhRP030000002_L8X0[g2:0140[g2:00<000000:AVRP2TIXX0
2@2TIXX00`000000`;cG0<2le`080<2le`0300000034`mT0a<?I0080a<?I0P0000050<S2e0030000
003=b]L0cL[G00T0cL[G00<000000=3Cg00000002@3Fe=L010000000fMoL0=WOg00000090=oQeP80
00001P3Vl]@00`000000gok50=ona@020=ona@<000007`3oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo00X0oooo000K0?ooo`030000003oool0oooo0080oooo0`00001K0?ooo`030000
00007Z/00000008003c000<00000021BbP0000001P0cIM@00`000000GW_H05ikf00705ikf0800000
2`1hR]P00`000000RIGI08VEf@0:08VEf@030000002CV=D0TiSE00<0TiSE0P00000309JNfP030000
002MXML0WJ7G00P0WJ7G00<000000;YhRP2jN8X04@2jN8X00`000000[g2:0:m`RP0A0:m`RP030000
002TIXX0Y6J:00P0Y6J:00<000000<2le`30_=L02030_=L00`000000a<?I0<C3f@050<C3f@800000
0P38`]@00`000000cL[G0<g:e`090<g:e`050000003@dm`0d=?L0=3Cg00000001`3Fe=L00`000000
fMoL0=WOg0020=WOg0030000003OhMH0gn7F00@0gn7F0P0000000`3Okm/000000>Kbe0040>Kbe080
0000103Oo/D200000240oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0:0?ooo`00
6`3oool00`000000oooo00000002000005l0oooo0P000003000l`08000001P0cIM@2000000L0GW_H
00<0000006R6g@1XQ]d00P00000807R:f0030000001nT]d0000000`0RIGI00<0000009>He@2CV=D0
0P00000609JNfP030000002MXML0WJ7G00P0WJ7G00<000000;YhRP2jN8X0402jN8X00`000000[g2:
0:m`RP0A0:m`RP030000002TIXX0Y6J:00P0Y6J:00<000000<2le`30_=L01`30_=L00`000000a<?I
0<C3f@080<C3f@8000002`3=b]L00`000000d=?L0=3Cg0020=3Cg0030000003Fe=L0e]CG00<0e]CG
0P0000050=WOg0030000003OhMH0gn7F00<0gn7F00D000000=o_f`3Okm/0gnoK000000040>Kbe003
0000003MoM80000000<0gok50`00000R0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool02P3oool001/0oooo0P00001S0?ooo`8000000`00?<000`000000<fGD03=Ue00403=Ue0040000
0014M=`00000000000D0GW_H00<0000006R6g@1XQ]d00P1XQ]d00`000000N8[H07R:f00507R:f003
0000001nT]d0OY;M008000002`29UMT2000000T0UYkJ00<0000009fQe`2MXML01`2MXML9000000X0
^WR:00<000000:m`RP2_L8X04@2_L8X00`000000Y6J:0:AVRP030:AVRPH000002@30_=L00`000000
a<?I0<C3f@080<C3f@0400000037bm`00000000000L0cL[G0P0000060=3Cg0050000003Fe=L0e]CG
0=KDe`000000203Igm`01@000000gn7F0=oQeP3OhMH0000000@0gnoK00L000000>Kbe03Vl]@0i_;D
0000003MoM80000000@0gok50P00000T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool02@3oool001`0oooo0P0000020?ooo`030000003oool0oooo05d0oooo0P000003000l`0800000
1@0cIM@01@000000A7CL04Adg014M=`0000000@0GW_H00<0000006R6g@1XQ]d00`1XQ]d00`000000
N8[H07R:f00307R:f0030000001nT]d0OY;M00<0OY;M00<0000008VEf@29UMT01`29UMT00`000000
SIcM0000000:09JNfP030000002MXML0WJ7G00H0WJ7G0P0000070;UcPb@000001P2RH8<2000000H0
`;cG00<000000<C3f@34`mT02034`mT00`000000al_L0<O;g0020<O;g0800000103=b]L00`000000
d=?L0=3Cg0070=3Cg0030000003Fe=L0000000T0fMoL00@000000=oQeP00000000001@3Okm/01000
0000i_;D0>Kbe00000020=gmdP040000003Oo/D0gok50=ona@8000009@3oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo00T0oooo000N0?ooo`800000H@3oool2000000<003c00P000004
03=Ue00300000014M=`0A7CL0080A7CL00D0000005ikf01NNmP0GW_H0000000606R6g@8000000P1h
R]P00`000000OY;M07jBg@0507jBg@0300000029UMT0RIGI00D0RIGI00D0000008fLg@2=W=d0SIcM
0000000909JNfP030000002MXML0WJ7G00@0WJ7G0P00000C0;UcP`030000002^JX<0[VZ30140[VZ3
00<000000:9PP`2RH8<02`2RH8<300000080`;cG00<000000<C3f@34`mT02034`mT00`000000al_L
0<O;g0050<O;g080000000<0cL[G0000003@dm`02P3@dm`00`000000fMoL0=WOg0090=WOg0030000
003Okm/0gnoK00D0gnoK00<000000>Kbe00000000`3MoM800`000000gok50=ona@03000002H0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`090?ooo`007`3oool00`000000oooo0?oo
o`1P0?ooo`0600000000?<0003c0000l`000000025KA0P00000203=Ue00300000014M=`0A7CL00<0
A7CL0`00000906R6g@030000001hR]P0000000P0OY;M0P00000308VEf@8000001@2=W=d00`000000
UYkJ09JNfP0709JNfP030000002MXML0WJ7G00<0000000<0`g^20000002iLh<04P2iLh<00`000000
[VZ30:iZP`0A0:iZP`030000002RH8<0XV2300h0XV230`0000080<C3f@8000002P37bm`00`000000
d=?L0=3Cg0080=3Cg0<000002@3Igm`3000000L0gnoK0P0000040=gmdP030000003Oo/D000000080
0000:03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo00T0oooo000P0?ooo`800000
H@3oool01000000003c0000l`000000300QFd@030000000cIM@0000000L0A7CL00<0000006R6g@1X
Q]d0201XQ]d00`000000OY;M07jBg@0907jBg@0300000029UMT0000000P0SIcM0P00000809JNfP80
00001033Nh800`000000^G>30;UcP`0A0;UcP`030000002^JX<0[VZ30140[VZ300<000000:9PP`2R
H8<04@2RH8<2000000D0a<?I00<000000<O;g037bm`02@37bm`00`000000b];P000000080=3Cg005
0000003BgN00d]gP0=;Mh00000001`3Igm`010000000fN_Q0=W[h@0000070=o_f`030000003MoM80
gOgB0080gOgB00<000000=ona@0000000P00000Z0?ooo`030000003oool0oooo01l0oooo00<00000
0?ooo`3oool02@3oool00280oooo00<000000?ooo`3oool0GP3oool20000008003c000@0000000QF
d@08E]4025KA0P00000704Adg0800000201XQ]d010000000LI3R00000000000:07jBg@030000002=
W=d0SIcM00T0SIcM00<0000009JNfP2FW]X00`2FW]X5000000<0`g^200<000000;UcP`2iLh<04@2i
Lh<00`000000[VZ30:iZP`0A0:iZP`030000002RH8<0XV230140XV2300@0000009AEP@0000000000
0P34`mT00`000000al_L0<O;g0080<O;g08000000`3:d^000`000000d=?L0=3Cg0030=3Cg0800000
103BgN000`000000fMoL0=WOg0030=WOg08000000`3Ijn400`000000gnoK0=o_f`040=o_f`800000
103MoM82000000030;[f[P000000oooo02/0oooo00<000000?ooo`3oool07P3oool00`000000oooo
0?ooo`090?ooo`008`3oool2000005l0oooo0P0000000`00?<00000000QFd@0300QFd@0300000014
M=`0A7CL00D0A7CL00@0000005>2hP00000000001P1XQ]d01@000000LI3R076@hP1aT>80000000P0
OY;M00@0000008BKh@00000000002P2=W=d00`000000UYkJ09JNfP02000000D0`WEi2000000?0;Uc
P`030000002^JX<0[VZ30140[VZ300<000000:9PP`2RH8<03@2RH8<700000003095=N00000000000
00X0al_L00<000000<[Bh03:d^000`3:d^000`000000d=?L0=3Cg0020=3Cg0030000003BgN00d]gP
00D0d]gP00D000000=WOg03Igm`0fMoL000000050=W[h@030000003Okm/0gnoK0080gnoK0`000005
0=gmdP030000002jmZh0000002d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`09
0?ooo`009@3oool00`000000oooo0?ooo`1M0?ooo`<000001008E]42000000H0A7CL00D0000005>2
hP1CP^80Dh;R0000000406R6g@030000001aT>80LI3R00<0LI3R0P00000507jBg@0300000024Vn40
Q9_Q0080Q9_Q00<0000008fLg@2=W=d0202=W=d2000000X0`WEi00<000000;M/NP2gK7X00P2gK7X:
000000D0^G>300<000000:iZP`2^JX<04@2^JX<00`000000XV230:9PP`030:9PP`X00000102OFGX0
0`000000TDeh095=N003095=N08000001`37bm`00`000000b];P0<[Bh0050<[Bh0040000003@dm`0
0000000000P0d]gP00@000000=WOg000000000001P3Ijn401@000000gnoK0=o_f`3Okm/000000080
fO[M00<000000=gmdP3MoM800P3MoM8010000000^_J^00000000000^0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool02@3oool002H0oooo00<000000?ooo`000000G@3oool3000000@0
25KA0`00000404Adg0030000001CP^80Dh;R0080Dh;R00D0000006R6g@1XQ]d0J8KM00000007076@
hP030000001nT]d0OY;M0080OY;M00<0000008BKh@24Vn400`24Vn42000000L0SIcM00<000000<9e
N@32MGT02P32MGT00`000000]faj0;M/NP0<0;M/NQl000003P2OFGX00`000000TDeh095=N005095=
N00300000037bm`0al_L0080al_L0P0000090<[Bh0030000003BgN00d]gP00T0d]gP00<000000=W[
h@3Ijn401P3Ijn4010000000gnoK0=o_f`0000030=Wjg@040000003MoM80gOgB0=gmdP80000000<0
^_J^0000003oool0;`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo00P0oooo000W
0?ooo`800000GP3oool2000000@025KA00@0000002=[g00SJm`000000`14M=`00`000000Dh;R05>2
hP0305>2hP<000002@1aT>820000000307jBg@000000Q9_Q00L0Q9_Q00<0000008fLg@2=W=d00P2=
W=d2000000d0`WEi00<000000;M/NP2gK7X04@2gK7X00`000000[6=k0:aSN`0A0:aSN`030000002O
FGX0WeUj0140WeUj00<00000095=N02ACGP01P2ACGP2000000030<O;g0000000b];P00P0b];P0`00
00090=;Mh0<00000203Ijn43000000@0fO[M00<000000=gmdP0000000P0000000`2jmZh000000?oo
o`0a0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0203oool002T0oooo00<00000
0?ooo`3oool0G03oool30000008025KA00D0000002=[g00SJm`08f_L0000000204Adg0030000001C
P^80Dh;R00D0Dh;R00<00000076@hP1aT>802@1aT>800`000000Q9_Q08BKh@0808BKh@80000000<0
SIcM0000000000003`32MGT00`000000]faj0;M/NP0@0;M/NP030000002/Hg/0[6=k0140[6=k00<0
000009mINP2OFGX04@2OFGX00`000000TDeh095=N004095=N0D000002@3:d^001@000000c=_U0<cK
i@3<fnD0000000L0d]gP00@000000=;Wi@3BinD00000203Ijn400`000000fO[M0=Wjg@030=Wjg@07
0000003MoM8000000<?maP000000^_J^0000000d0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool0203oool002X0oooo00<000000?ooo`3oool0G03oool30000008025KA00@0000002=[
g00SJm`08f_L0`00000705>2hP<00000201aT>8010000000NI[V00000000000:08BKh@0300000031
KVl0`Fi_00H000002@32MGT00`000000]faj0;M/NP0@0;M/NP030000002/Hg/0[6=k0140[6=k00<0
000009mINP2OFGX04@2OFGX00`000000TDeh095=N004000000D0SD=^00<000000<[Bh03:d^00103:
d^02000000@0c=_U00<000000=;Mh03BgN000`3BgN02000000<0d^OU00<000000=W[h@3Ijn40103I
jn43000000D0fO[M0P0000020<?maP800000=@3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo00P0oooo000[0?ooo`800000G@3oool30000000300QFd@0000008f_L00@08f_L00<00000
05>2hP1CP^801@1CP^800`000000HHoW066?i`02000000H0LI3R00D0000007VJiP1iV^H0NI[V0000
000808BKh@0300000031KVl0`Fi_00L0`Fi_1P0000030<9eN@030000002gK7X0]faj0100]faj00<0
00000:aSN`2/Hg/04@2/Hg/00`000000WeUj09mINP0=09mINPL000002P2=@fh00`000000b];P0<[B
h0020<[Bh0030000003<fnD0c=_U00D0c=_U00D000000=;Mh03BgN00d]gP000000060=;Wi@030000
003Ijn40fN_Q0080fN_Q00<000000=Cfi@0000001P3In]d00`000000`og60<?maP02000003L0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`080?ooo`007P3oool00`3o/5d000000000
000300000003001M/03oool0oooo00H0oooo00<000000?ooo`3oool0F`3oool00`00000004300000
0002000000@08f_L0`00000505>2hP030000001QSnL0HHoW0080HHoW0P000003076@hP030000001i
V^H0NI[V00<0NI[V0P00000508BKh@8000003`31KVl8000000h0]faj00<000000:aSN`2/Hg/04@2/
Hg/00`000000WeUj09mINP0309mINPX00000102LD7000`000000SD=^08e3KP0;08e3KP040000003:
d^000000000000P0c=_U00@000000=;Mh000000000001`3BinD00`000000fN_Q0=W[h@0200000080
e?KU00<000000=Wjg@3In]d00P3In]d200000080`og60P00000i0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0203oool00240oooo00<0R38b08SGo`3oool02P3oool2000000030?oo
o`000000oooo05T0oooo00@000000010`000@<0000001@0SJm`00`000000>WgU0000000405>2hP03
0000001QSnL0HHoW00@0HHoW0P0000000`1aT>80000007VJiP0607VJiP0300000024Vn40Q9_Q0080
Q9_Q0P00000B0<5^K`030000002fIG40]VEa0080]VEa2P0000040;M/NP030000002/Hg/0[6=k00P0
[6=k3`00000>09a@L0030000002=@fh0SD=^00`0SD=^00<000000<cKi@3<fnD02@3<fnD00`000000
d^OU0=;Wi@070=;Wi@<00000103Dm^D01`000000fO[M0=Wjg@3In]d000000<Kof00000000P33oLH0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0203oool0
0240oooo00<0R38b08SGo`3oool0303oool00`000000oooo0?ooo`1J0?ooo`0300000000@<000430
008000000`0SJm`00`000000>WgU03Ymi@0200000080Dh;R00<00000066?i`1QSnL01P1QSnL00`00
0000NI[V07VJiP0707VJiP80000000@0Q9_Q0000003=MV/000004P31KVl00`000000]VEa0;IUL@0<
0;IUL@l000002@2YFg400`000000W51`09a@L00@09a@L0030000002=@fh0SD=^00d0SD=^00<00000
0<cKi@3<fnD01`3<fnD3000000T0d^OU00<000000=Cfi@3Dm^D0103Dm^D01P000000fO[M00000000
0000a_oH00000080`og600<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo00L0oooo000Q0?ooo`0308Pb<P28eol0oooo00`0oooo0P00001L0?ooo`0300000000
@<000430008000000`0SJm`010000000>WgU03Ymi@0jOND3000000P0HHoW0`00000907VJiP030000
003;KEd0000000@000003`31KVl00`000000]VEa0;IUL@0@0;IUL@030000002YFg40ZE]a0140ZE]a
00<0000009a@L02LD700402LD7000`000000SD=^08e3KP0708e3KPH0000000<0R3QQ0000003<fnD0
1@3<fnD200000080bn?Y00<000000=;Wi@3BinD01@3BinD3000000D0e?KU0`0000020<Kof0040000
0033oLH00000000003h0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`070?ooo`00
5@3oool00`2jLP0000000000000300000003000bR03oool0oooo00<0oooo00<0R38b08SGo`3oool0
3P3oool2000005/0oooo00<000000010`000@<000`0000000`0SJm`0000003Ymi@0403Ymi@800000
1`1QSnL00`000000KI[[06fJj`02000000H0NI[V00D000000<]]G@3;KEd0bfeM000000030;mUH`H0
00002@31KVl00`000000]VEa0;IUL@0@0;IUL@030000002YFg40ZE]a0140ZE]a00<0000009a@L02L
D700402LD70010000000SD=^08e3KP2=@fh6000000L0R3QQ00<000000<cKi@3<fnD00P3<fnD20000
00@0bn?Y00<000000=;Wi@3BinD00`3BinD2000000030<kajP000000e?KU00D0e?KU00H000000<Ko
f036omP0a_oH00000033oLH200000400oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`070?ooo`008@3oool00`28<S80R=Oo0?ooo`0@0?ooo`030000003oool0oooo05T0oooo0`000002
001Ne@<00000100jOND010000000CXg[000000000005066?i`030000001]V^/0KI[[0080KI[[0P00
000407VJiP030000003;KEd0bfeM0080bfeM00<000000;mUH`2oIF<01P2oIF<6000000<0`Fi_00<0
00000;IUL@2fIG40402fIG400`000000ZE]a0:UKL@0A0:UKL@030000002LD700W51`00`0W51`2000
000=08PhH@80000000<0c=_U0000000000001`3;hnT00`000000d^OU0=;Wi@02000000<0c_7Z00<0
00000=Cfi@3Dm^D00P3Dm^D2000000@0a_oH0`0000120?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool01`3oool00240oooo00<0R38b08SGo`3oool04@3oool2000005X0oooo0`000003
001Ne@030000000jOND0>WgU00<0>WgU00<0000004j=j`1>SN/00P000003066?i`030000001]V^/0
KI[[00@0KI[[0P0000000`1iV^H000000<]]G@040<]]G@030000002oIF<0_fES00`0_fES2000000>
0;IUL@030000002YFg40ZE]a0140ZE]a00<0000009a@L02LD7000P2LD70:000000@0V4IU00<00000
08PhH@28>6403P28>643000000T0bn?Y0`0000050<kajP030000003Dm^D0e?KU0080000000<0a_cT
00000036omP00P36omP3000004@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`07
0?ooo`007P3oool01@3GR3800000000bR028<S80R=Oo01@0oooo00<000000?ooo`000000F03oool3
000000<005kE0P00000303Ymi@030000001>SN/0CXg[0080CXg[0P0000000`1QSnL0000006fJj`07
06fJj`<00000103;KEd00`000000_fES0;mUH`0?0;mUH`030000002cG6D0/eaU0080/eaU2P000004
0;IUL@030000002YFg40ZE]a00P0ZE]a3P00000>09Q6I@0300000028>640R3QQ00`0R3QQ10000009
0<_Sj@8000001P3>lNX010000000e?KU0000000000020<Kli00300000036omP0a_oH00<00000AP3o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00L0oooo000P0?ooo`030=N8<P000380
R=Oo01D0oooo0P00001I0?ooo`<000000`00G]D300000080>WgU00<0000004j=j`1>SN/00`1>SN/3
000000P0KI[[00<000000<MQC@0000000`0000000`3;KEd000000;mUH`0?0;mUH`030000002cG6D0
/eaU00`0/eaU3`0000090:IBIP030000002HAVD0V4IU00l0V4IU00<0000008PhH@28>6402@28>644
00000080PBYB0P0000070<_Sj@80000000<0an_^0000003>lNX0103>lNX3000000@0a_cT00<00000
0<Kof00000000P0000180?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool01`3oool0
03T0oooo0P00001J0?ooo`<0000000@005kE0000000KM^<06gKS0`00000604j=j`040000001OVNl0
0000000000H0KI[[00<000000<MQC@37HDd00`37HDd4000000h0_fES00<000000;=LI@2cG6D0402c
G6D00`000000YU9V0:IBIP0A0:IBIP030000002HAVD0V4IU00l0V4IU00<0000008PhH@28>6401028
>645000000D0PBYB00@0000006/EBP1[5DX000000`3;hnT300000080an_^00<000000<kajP3>lNX0
0P3>lNX3000000D0a_cT00<000000<Kof00000000P00001:0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool01`3oool003/0oooo00<000000?ooo`3oool0F03oool5000000<06gKS0P00
000604j=j`030000001OVNl0GiW_00<000000`1]V^/00`000000af5=0<MQC@040<MQC@030000002k
FU@0^eYD00H000002@2oIF<00`000000/eaU0;=LI@0?0;=LI@030000002VDVH0YU9V0100YU9V00<0
000009Q6I@2HAVD0402HAVD00`000000R3QQ08PhH@04000000X0PBYB00D0000006/EBP1[5DX00000
0<_Sj@02000000D0an_^00<000000<kajP3>lNX00P0000020<?hk@0300000036o>@0a_cT00<0a_cT
1000001<0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01P3oool003`0oooo00<0
00000?ooo`3oool0F03oool200000003001<`0000000000000@06gKS0P00000404j=j`030000001O
VNl0GiW_00<0GiW_0P0000000`1]V^/000000<MQC@050<MQC@030000002kFU@0^eYD00H0^eYD1P00
00030;mUH`030000002cG6D0/eaU0100/eaU00<000000:IBIP2VDVH03`2VDVH00`000000V4IU09Q6
I@0<09Q6I@L000003P21:U800`000000JaE:06/EBP02000000H0an_^00@000000<kajP0000000000
0`33n>d00`000000a_cT0<Kli0020<Kli0@00000C`3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo00H0oooo000m0?ooo`800000F@3oool300000003001<`00000006gKS00806gKS00@0
000003N:k@00000000000P1>SN/00`000000GiW_05nIk`0505nIk`@000001@37HDd00`000000^eYD
0;]JE00;0;]JE0d000002@2cG6D00`000000YU9V0:IBIP0?0:IBIP030000002HAVD0V4IU0080V4IU
2P00000409<jE`0300000021:U80PBYB00d0PBYB00<0000006/EBP0000000P0000060<O[kP<00000
1033n>d010000000a_cT0<Kli036o>@500000500oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`060?ooo`00?`3oool00`000000oooo0000001H0?ooo`80000000<004c0000000000000
0P0KM^<00`000000=h[]03N:k@020000000304j=j`000000GiW_00H0GiW_00<000000<9C>032DcP0
100000000`37HDd000000;]JE00?0;]JE0030000002_DEL0[e5G00L0[e5G8000000>09<jE`030000
0021:U80PBYB00/0PBYB100000000`1O0C@000000<O[kP030<O[kP@000001P33n>d4000000040:_i
g@000000000000000580oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`060?ooo`00
@03oool2000005T0oooo0P0000001P00C<0000000000000000006gKS000000<0=h[]1000000505nI
k`0300000032DcP0`U<h00@0`U<h1000000>0;]JE0030000002_DEL0[e5G0100[e5G00<000000:96
F02RAUP03`2RAUP00`000000TcYG09<jE`0?09<jE`0300000021:U80PBYB00H0PBYB1P00000207TI
?`050000001O0C@0G`4d00000037jnh00`0000030;oalP0300000033n>d0`oS]0080`oS]0`000002
0:_ig@<00000E@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00H0oooo00120?oo
o`030000003oool0oooo05P0oooo00<00000001<`00000000`00000503N:k@030000001?V_800000
00<000000P1OVNl00`000000`U<h0<9C>0040<9C>0030000002gC440]da100H000002@2kFU@00`00
0000[e5G0:mAE`0?0:mAE`030000002RAUP0XTIH00l0XTIH00<0000009<jE`2C>UL03`2C>UL00`00
0000PBYB084ZDP06000000P0NATo00<0000005l1=01O0C@00P0000050;oalP0400000033n>d0`oS]
0<?hk@<000000`2[nMd3000005L0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`06
0?ooo`00@`3oool00`000000oooo0?ooo`1H0?ooo`80000000<004c000000000K=T00P00000403N:
k@030000001?V_80Ci[b0080Ci[b0`0000070<9C>0030000002gC440]da100D0]da11P0000030;]J
E0030000002_DEL0[e5G00l0[e5G00<000000:96F02RAUP03`2RAUP00`000000TcYG09<jE`0;09<j
E`L000003@1i6Cl010000000G`4d05l1=00000070;oalP@0000000<0/?S[0000002[nMd00P2[nMd2
000005X0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`060?ooo`00A03oool20000
05X0oooo0`0000001000K=T0000000000000000203N:k@030000001?V_80Ci[b00D0Ci[b10000003
0<9C>0030000002gC440]da100/0]da1300000090:mAE`030000002RAUP0XTIH00l0XTIH00<00000
09<jE`2C>UL00P2C>UL9000000@0S2]500<0000007TI?`1i6Cl03@1i6Cl010000000G`4d00000000
00050;oalP<000000`2`n>/00`000000ZoWM0:_ig@03000005/0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`050?ooo`00AP3oool010000000oooo0?ooo`00001H0?ooo`<0000000<0
06cI0000000000000`00000704nJlP030000002i@1h0^D0N00<0000000<0`U<h0000002gC4403P2g
C4400`000000ZTA60:Y4AP060:Y4AR0000003@2<:dD00`000000NATo07TI?`0;07TI?`<0000000<0
D00I0000002olO800P2olO84000000@0/?S[00<000000:_ig@0000000P00001N0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool01@3oool004L0oooo0`00001I0?ooo`D000000P0NQ^T4
000000@0Ci[b00<000000;U07P2i@1h00`2i@1h4000000d0]da100<000000:Y4AP2ZA4H03`2ZA4H0
0`000000W3U709`iA`0?09`iA`030000002<:dD0S2]500h0S2]500<0000007TI?`1i6Cl01P1i6Cl6
0000000406d4:0000000D00I05006@@000000P2am?<00`000000/?S[0;3hj`020;3hj`@00000H@3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00D0oooo00190?ooo`030000003oool0
oooo05T0oooo1@00000201j6j@H0000000<0Ci[b0000002i@1h0102i@1h00`000000[c/Z0:lk:P06
000000P0]da100<000000:Y4AP2ZA4H03P2ZA4H00`000000W3U709`iA`0?09`iA`030000002<:dD0
S2]500h0S2]500<0000007TI?`1i6Cl01P00000606d4:0030000001@01T0D00I00800000102am?<0
10000000/?S[0;3hj`2`n>/5000006<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`050?ooo`00BP3oool00`000000oooo0?ooo`1J0?ooo`D000000P0NQ^T010000000?Y[c03jJl`0n
V_<4000000@0^D0N00<000000:lk:P2_>bX01@2_>bX600000080]da100<000000:Y4AP2ZA4H03P2Z
A4H00`000000W3U709`iA`0?09`iA`030000002<:dD0S2]500X0S2]51`00000<06d4:0<000001@2a
m?<8000006H0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`00B`3oool2
000005/0oooo0P0000000`00H<D0000000000004000000@0?Y[c1P00000=0:lk:P/00000202ZA4H0
0`000000W3U709`iA`0?09`iA`030000002<:dD0S2]50080S2]52000000408<H;`030000001]12P0
K@@X00T0K@@X0`0000000`0l000000000;7dl`030;7dl`<000000P2ClN<3000006P0oooo00<00000
0?ooo`3oool02`3oool00`000000oooo0?ooo`050?ooo`00C@3oool00`000000oooo0?ooo`1J0?oo
o`80000000@0063500000006PN001X7P0`00000303jJl`040000002/9`00[2L00:`W00@00000302_
>bX00`000000Xc8a0:<b<@060:<b<Al000002`2362l00`000000K@@X06d4:00506d4:0D0000000D0
G@090000000l000000000;7dl`0500000080To7S0`00001[0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool01@3oool004h0oooo00@000000?ooo`3oool00000FP3oool4000000801X7P
100000000`0nV_<000000:`W00030:`W00030000002T90d0000000@000001`2_>bX00`000000Xc8a
0:<b<@0>0:<b<@030000002D9c80U2Lb00l0U2Lb00<0000008<H;`2362l03@2362l00`000000K@@X
06d4:005000000H0G@09100000000`2NlO8000000000000209?ah`<00000KP3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo00D0oooo001?0?ooo`<00000G03oool4000000801X7P0P00
00000`0^VO40000000000004000000H0Y2@=1P0000020:lk:P030000002S<S40Xc8a00d0Xc8a00<0
000009@W<P2D9c803P2D9c800`000000PaP_08<H;`0:08<H;`L00000201M00T400000080W_7b0P00
00000`2ClN<000000000000200000740oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`040?ooo`00D@3oool00`000000oooo0?ooo`1M0?ooo`@0000000@01X7P000000000000;YWa0P00
00000`2G1`00000000000002000000T0Y2@=2P0000080:<b<@030000002D9c80U2Lb00h0U2Lb00<0
000008<H;`2362l00P2362l8000000<0MP4C00<0000005d02@1M00T0101M00T@000007@0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`040?ooo`00DP3oool2000005l0oooo2P000000
102G1`0000000987002B1`04000000H0Y2@=00<0000009PM5@2H7AD01@2H7ADN000000/0MP4C00<0
000005d02@0000001000000304L000@0000000@0QNW]000000000000L>3F0`00001f0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool0103oool005@0oooo00<000000?ooo`3oool0G@3o
ool01@000000oooo00000000000007_A00L000001@2B1`0500000080Y2@=00<0000009PM5@2H7AD0
302H7AD00`000000R14G08PA5`0>08PA5`030000001f0A<0MP4C00T0MP4C1P00000604L000800000
0`25jNd200000003073PeP000000000007X0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`040?ooo`00E@3oool00`000000oooo0?ooo`1L0?ooo`040000003oool0oooo0?ooo`800000
00<007_A0000000000000`0PVN/4000000H0TPL02P00000809PM5@03000000284AL0R14G00`0R14G
00<0000007H14`1f0A<00P1f0A<800000080H`0000<0000004L00017000010170003000000<0QNW]
1@00001m0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0103oool005H0oooo0P00
00000`3oool000000?ooo`1I0?ooo`030000003oool0oooo00<0oooo1@000003022Ij`T000000P2B
1`000`000000Q`0008L0000408L001`000002P1S00000`000000A`000000000<00000840oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`00?`3oool01@3o/5d0000000000000
0000GK3o00D0oooo00<0/5d000000000GK001@3oool01@2`G@000000000000000000GK3o0080oooo
00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`060?ooo`X00000101g0007000000X0Q`00
00<0000007L0001g0000301g00000`000000H`0006<0000506<000L000000`0Z000200000080JM_U
1@0000240?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool003l0oooo00H0
R39M0;3oo`3oool0oon`05d0G@2`ool40?ooo`030;1M0000000005f`00@0oooo00L0/5d0001M/03o
ool0oooo0?oGR00b0000GK3o0080oooo0P00001I0?ooo`030000003oool0oooo00X0oooo2`000002
07L000030000001]0000K@000080K@001P00000308L000030000001g0000M`0000D0M`003`000005
04P000030000000Z000000000080000000<0JM_U0000000000000P0000290?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool003h0oooo00<0ok1M001M/03oool00P3oool00`3G
R380<XSG0?ooo`0?0?ooo`030?n`G@00GK00oooo00<0oooo00<000000?ooo`3oool0EP3oool00`00
0000oooo0?ooo`0>0?oooa4000000`1]000;000000H0GP0000<0000004P0001800001018000>0000
08d0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`00?P3oool00`3GR380
<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00l0oooo00<0ok1M001M/03oool0103oool00`000000
oooo0?ooo`1E0?ooo`030000003oool0oooo0180oooo<@00002C0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00`3oool003D0oooo00<0R3800000000000000`0000001@00<XP0oooo
0?ooo`3GR380<XSG00<0oooo00<0ok1M001M/03oool03`3oool00`28<P00GK3o0?ooo`050?ooo`80
000000<0oooo0000003oool0DP3oool00`000000oooo0?ooo`0H0?ooo`H000001@0HY=DB00000080
=[cF1`00002I0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool003h0oooo
00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0:0?ooo`030?oo/01M0000000000800000
00<0<XSG0?ooo`3oool01`3oool2000005<0oooo00<000000?ooo`3oool08P3ooolE00000:00oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`00?P3oool00`3o/5d0<XSG0?oo
o`020?ooo`030=N8<P0bR=L0oooo00X0oooo00<0oon`05d0G@2`ool03@3oool00`000000oooo0?oo
o`1A0?ooo`030000003oool0oooo0=P0oooo00D000000?ooo`3oool0oooo000000050?ooo`00?`3o
ool01P28<P00GK3o0?ooo`3oehP0<P1M0;3oo`/0oooo00<0oon`05d0G@2`ool03P3oool200000540
oooo00<000000?ooo`3oool0f@3oool010000000oooo0?ooo`0000050?ooo`00?`3oool01@3ook00
G@00000000000380R=Oo00`0oooo00<0oon`05d0000000000P0000000`0005d0/?oo0?ooo`0;0?oo
o`030000003oool0oooo04h0oooo00<000000?ooo`3oool0fP3oool00`000000oooo000000050?oo
o`00I03oool2000000030?ooo`000000oooo04/0oooo00<000000?ooo`3oool0f`3oool00`000000
oooo000000040?ooo`00IP3oool2000004`0oooo00<000000?ooo`3oool0f`3oool00`000000oooo
000000040?ooo`00I`3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo0=`0oooo0P00
00040?ooo`00J03oool2000004X0oooo00<000000?ooo`3oool0f`3oool3000000@0oooo001Z0?oo
o`030000003oool0oooo04L0oooo00<000000?ooo`3oool0e`3oool4000000L0oooo001[0?ooo`80
00000P3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo0=<0oooo1000000;0?ooo`00
K@3oool00`000000oooo000000140?ooo`030000003oool0oooo0<l0oooo1000000?0?ooo`00KP3o
ool2000004@0oooo00<000000?ooo`3oool0bP3oool5000001<0oooo001_0?ooo`800000@`3oool0
0`000000oooo0?ooo`360?ooo`@00000603oool00740oooo00<000000?ooo`3oool0@03oool00`00
0000oooo0?ooo`320?ooo`@00000703oool00780oooo00<000000?ooo`3oool0?`3oool00`000000
oooo0?ooo`2n0?ooo`@00000803oool007<0oooo0P0000000`3oool000000?ooo`0l0?ooo`030000
003oool0oooo0;T0oooo1@00000T0?ooo`00M@3oool2000003`0oooo00<000000?ooo`3oool0]P3o
ool4000002T0oooo001f0?ooo`800000>`3oool00`000000oooo0?ooo`2b0?ooo`@00000;@3oool0
07P0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`2]0?ooo`D00000<@3oool007T0
oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`2Y0?ooo`@00000=P3oool007X0oooo
0P0000000`3oool000000?ooo`0d0?ooo`030000003oool0oooo0:D0oooo1000000j0?ooo`00O03o
ool2000003D0oooo00<000000?ooo`3oool0X@3oool4000003h0oooo001[0?ooo`050?n`G@000000
00000000001M/?l03@3oool2000003@0oooo00<000000?ooo`3oool0W03oool500000480oooo001[
0?ooo`0608PbG@2`ool0oooo0?oo/01M05d0/?oo3P3oool00`000000oooo0?ooo`0a0?ooo`030000
003oool0oooo09P0oooo100000170?ooo`00JP3oool00`3o/5d005f`0?ooo`020?ooo`030=N8<P0b
R=L0oooo00h0oooo00@000000?ooo`3oool00000;`3oool00`000000oooo0?ooo`2D0?ooo`@00000
B`3oool006X0oooo00<0ehPb03:8e`3oool00P3oool00`3o/5d005f`0?ooo`0?0?ooo`<00000;`3o
ool00`000000oooo0?ooo`2@0?ooo`@00000C`3oool006X0oooo00<0ehPb03:8e`3oool00P3oool0
0`3o/5d005f`0?ooo`0A0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0R`3oool5
000005<0oooo001Z0?ooo`030=N8<P0bR=L0oooo0080oooo00<0ok1M001M/03oool04P3oool00`00
0000oooo0?ooo`0/0?ooo`030000003oool0oooo08L0oooo1000001H0?ooo`00JP3oool00`3o/5d0
<XSG0?ooo`020?ooo`030=N8<P0bR=L0oooo01<0oooo0P00000/0?ooo`030000003oool0oooo08<0
oooo1000001L0?ooo`00J`3oool01P28<P00GK3o0?ooo`3oehP0<P1M0;3ooaH0oooo00@000000?oo
o`3oool00000:03oool00`000000oooo0?ooo`1o0?ooo`@00000H03oool006/0oooo00D0oon`05d0
00000000000b08SGo`0H0?ooo`<00000:03oool00`000000oooo0?ooo`1j0?ooo`D00000I03oool0
08X0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1f0?ooo`@00000J@3oool008/0
oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1b0?ooo`@00000K@3oool008`0oooo
0P0000030?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0KP3oool400000740oooo
002>0?ooo`040000003oool0oooo00000240oooo00<000000?ooo`3oool0J@3oool5000007D0oooo
002?0?ooo`8000008P3oool00`000000oooo0?ooo`1U0?ooo`@00000NP3oool00900oooo0P00000Q
0?ooo`030000003oool0oooo0640oooo1000001n0?ooo`00TP3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo05`0oooo1@0000220?ooo`00T`3oool2000001h0oooo00<000000?ooo`3o
ool0F03oool4000008L0oooo002E0?ooo`030000003oool0000001/0oooo00<000000?ooo`3oool0
E03oool4000008/0oooo002F0?ooo`8000006`3oool00`000000oooo0?ooo`1@0?ooo`@00000S`3o
ool009L0oooo0P00000J0?ooo`030000003oool0oooo04/0oooo1@00002C0?ooo`00V@3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo04L0oooo1000002H0?ooo`00VP3oool200000003
0?ooo`000000oooo01@0oooo00<000000?ooo`3oool0@`3oool4000009`0oooo002L0?ooo`800000
5@3oool00`000000oooo0?ooo`0o0?ooo`@00000X03oool009d0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0j0?ooo`D00000Y03oool008@0oooo00D0ok1M000000000000000005f`
o`050?ooo`030;1M0000000005f`00D0oooo00D0/5d0000000000000000005f`o`030?ooo`800000
4P3oool00`000000oooo0?ooo`0g0?ooo`@00000Z@3oool008@0oooo00H0R39M0;3oo`3oool0oon`
05d0G@2`ool40?ooo`030;1M0000000005f`00@0oooo00L0/5d0001M/03oool0oooo0?oGR00b0000
GK3o00@0oooo00@000000?ooo`3oool000003P3oool00`000000oooo0?ooo`0c0?ooo`@00000[@3o
ool008<0oooo00<0ok1M001M/03oool00P3oool00`3GR380<XSG0?ooo`0?0?ooo`030?n`G@00GK00
oooo00@0oooo0`00000>0?ooo`030000003oool0oooo02l0oooo1000002a0?ooo`00P`3oool00`3G
R380<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00l0oooo00<0ok1M001M/03oool01P3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo02X0oooo1@00002e0?ooo`00P`3oool00`3GR380
<XSG0?ooo`020?ooo`030?n`G@00GK00oooo00l0oooo00<0R38005f`o`3oool01`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo02H0oooo1000002j0?ooo`00P`3oool00`3GR380<XSG
0?ooo`020?ooo`030?n`G@00GK00oooo00X0oooo00<0oon`05d0000000000P0000000`0bR=L0oooo
0?ooo`080?ooo`8000002`3oool00`000000oooo0?ooo`0R0?ooo`@00000_P3oool008<0oooo00<0
ok1M03:8e`3oool00P3oool00`3GR380<XSG0?ooo`0:0?ooo`030?oo/01M05d0/?oo00l0oooo00<0
00000?ooo`000000203oool00`000000oooo0?ooo`0M0?ooo`D00000`P3oool008@0oooo00H0R380
05f`o`3oool0omN80380G@2`ool;0?ooo`030?oo/01M05d0/?oo0100oooo0P0000080?ooo`030000
003oool0oooo01T0oooo100000370?ooo`00Q03oool01@3ook00G@00000000000380R=Oo00`0oooo
00<0oon`05d0000000000P0000000`0005d0/?oo0?ooo`0<0?ooo`8000001`3oool00`000000oooo
0?ooo`0E0?ooo`@00000b`3oool00:/0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo0140oooo1000003?0?ooo`00[03oool2000000050?ooo`000000oooo0?ooo`000000
3P3oool500000=<0oooo002^0?ooo`8000000P3oool00`000000oooo0?ooo`080?ooo`@00000f03o
ool00:l0oooo00@000000?ooo`3oool000001P3oool400000=`0oooo002`0?ooo`<000000P3oool4
00000>00oooo002b0?ooo`<00000i03oool00?l0ooooVP3oool00?l0ooooVP3oool00?l0ooooVP3o
ool00?l0ooooVP3oool00?l0ooooVP3oool00?l0ooooVP3oool00?l0ooooVP3oool00:/0oooo00<0
omBK0000000000000`0000000`00Vm@0oooo0?ooo`3U0?ooo`00[P3oool00`2jLW80^^[o0?ooo`3X
0?ooo`00[P3oool00`2jLW80^^[o0?ooo`3X0?ooo`00[P3oool00`2jLW80^^[o0?ooo`3X0?ooo`00
[P3oool00`2jLW80^^[o0?ooo`3X0?ooo`00[P3oool00`2jLW80^^[o0?ooo`3X0?ooo`00[P3oool0
0`2jLW80^^[o0?ooo`3X0?ooo`00Z`3oool01@3Z^W800000001b^P2jLW80^^[o0>T0oooo002]0?oo
o`030>ZjLP000780^^[o0>T0oooo0000\
\>"],
  ImageRangeCache->{{{0, 408.563}, {430.875, 0}} -> {-0.02499, -0.0366175, \
0.0034851, 0.0034851}}]
}, Open  ]],

Cell[TextData[{
  "Una forma interesante de ver la gr\[AAcute]fica de una funci\[OAcute]n es \
mediante curvas de nivel. Por este m\[EAcute]todo lo que se hace es \
representar la gr\[AAcute]fica de una funci\[OAcute]n en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " proyectando sobre el plano XY las curvas intersecci\[OAcute]n de dicha \
superficie con planos paralelos al plano XY (",
  StyleBox["curvas de nivel",
    FontWeight->"Bold"],
  "). Las curvas de nivel unen los puntos de la superficie que tienen la \
misma altura. Est\[AAcute]s acostumbrado a ver estas representaciones porque \
los mapas topogr\[AAcute]ficos representan el relieve del terreno por curvas \
de nivel. Esta representaci\[OAcute]n permite ver las zonas donde la funci\
\[OAcute]n var\[IAcute]a m\[AAcute]s r\[AAcute]pidamente porque las curvas de \
nivel est\[AAcute]n m\[AAcute]s pr\[OAcute]ximas entre s\[IAcute]. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ContourPlot[f[x,y],{x,a,b},{y,c,d},opciones]\" \
que representa curvas de nivel de la gr\[AAcute]fica de la funci\[OAcute]n \
f[x,y] para una sucesi\[OAcute]n de valores de altura igualmente espaciados.  \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representa con tonos m\[AAcute]s luminosos las zonas donde la funci\
\[OAcute]n toma valores m\[AAcute]s grandes y con tonos m\[AAcute]s oscuros \
las zonas donde la funci\[OAcute]n es m\[AAcute]s peque\[NTilde]a. Veamos el \
gr\[AAcute]fico de contorno de la primera superficie."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ContourPlot[
        x\ y\ Exp[\(-x\^2\) - y\^2], {x, \(-2\), 2}, {y, \(-2\), 
          2}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.5 0.240385 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.25962 -0.0125 -6 -9 ]
[.25962 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.74038 -0.0125 -3 -9 ]
[.74038 -0.0125 3 0 ]
[.98077 -0.0125 -3 -9 ]
[.98077 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -12 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .25962 -12 -4.5 ]
[-0.0125 .25962 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .74038 -6 -4.5 ]
[-0.0125 .74038 0 4.5 ]
[-0.0125 .98077 -6 -4.5 ]
[-0.0125 .98077 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.25962 0 m
.25962 .00625 L
s
[(-1)] .25962 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.74038 0 m
.74038 .00625 L
s
[(1)] .74038 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(2)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.06731 0 m
.06731 .00375 L
s
.11538 0 m
.11538 .00375 L
s
.16346 0 m
.16346 .00375 L
s
.21154 0 m
.21154 .00375 L
s
.30769 0 m
.30769 .00375 L
s
.35577 0 m
.35577 .00375 L
s
.40385 0 m
.40385 .00375 L
s
.45192 0 m
.45192 .00375 L
s
.54808 0 m
.54808 .00375 L
s
.59615 0 m
.59615 .00375 L
s
.64423 0 m
.64423 .00375 L
s
.69231 0 m
.69231 .00375 L
s
.78846 0 m
.78846 .00375 L
s
.83654 0 m
.83654 .00375 L
s
.88462 0 m
.88462 .00375 L
s
.93269 0 m
.93269 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(-2)] -0.0125 .01923 1 0 Mshowa
0 .25962 m
.00625 .25962 L
s
[(-1)] -0.0125 .25962 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .74038 m
.00625 .74038 L
s
[(1)] -0.0125 .74038 1 0 Mshowa
0 .98077 m
.00625 .98077 L
s
[(2)] -0.0125 .98077 1 0 Mshowa
.125 Mabswid
0 .06731 m
.00375 .06731 L
s
0 .11538 m
.00375 .11538 L
s
0 .16346 m
.00375 .16346 L
s
0 .21154 m
.00375 .21154 L
s
0 .30769 m
.00375 .30769 L
s
0 .35577 m
.00375 .35577 L
s
0 .40385 m
.00375 .40385 L
s
0 .45192 m
.00375 .45192 L
s
0 .54808 m
.00375 .54808 L
s
0 .59615 m
.00375 .59615 L
s
0 .64423 m
.00375 .64423 L
s
0 .69231 m
.00375 .69231 L
s
0 .78846 m
.00375 .78846 L
s
0 .83654 m
.00375 .83654 L
s
0 .88462 m
.00375 .88462 L
s
0 .93269 m
.00375 .93269 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.25962 .99375 m
.25962 1 L
s
.5 .99375 m
.5 1 L
s
.74038 .99375 m
.74038 1 L
s
.98077 .99375 m
.98077 1 L
s
.125 Mabswid
.06731 .99625 m
.06731 1 L
s
.11538 .99625 m
.11538 1 L
s
.16346 .99625 m
.16346 1 L
s
.21154 .99625 m
.21154 1 L
s
.30769 .99625 m
.30769 1 L
s
.35577 .99625 m
.35577 1 L
s
.40385 .99625 m
.40385 1 L
s
.45192 .99625 m
.45192 1 L
s
.54808 .99625 m
.54808 1 L
s
.59615 .99625 m
.59615 1 L
s
.64423 .99625 m
.64423 1 L
s
.69231 .99625 m
.69231 1 L
s
.78846 .99625 m
.78846 1 L
s
.83654 .99625 m
.83654 1 L
s
.88462 .99625 m
.88462 1 L
s
.93269 .99625 m
.93269 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .25962 m
1 .25962 L
s
.99375 .5 m
1 .5 L
s
.99375 .74038 m
1 .74038 L
s
.99375 .98077 m
1 .98077 L
s
.125 Mabswid
.99625 .06731 m
1 .06731 L
s
.99625 .11538 m
1 .11538 L
s
.99625 .16346 m
1 .16346 L
s
.99625 .21154 m
1 .21154 L
s
.99625 .30769 m
1 .30769 L
s
.99625 .35577 m
1 .35577 L
s
.99625 .40385 m
1 .40385 L
s
.99625 .45192 m
1 .45192 L
s
.99625 .54808 m
1 .54808 L
s
.99625 .59615 m
1 .59615 L
s
.99625 .64423 m
1 .64423 L
s
.99625 .69231 m
1 .69231 L
s
.99625 .78846 m
1 .78846 L
s
.99625 .83654 m
1 .83654 L
s
.99625 .88462 m
1 .88462 L
s
.99625 .93269 m
1 .93269 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 g
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
0 g
.5 Mabswid
.6 g
.21955 .05244 m
.25962 .03685 L
.29968 .02816 L
.33974 .02633 L
.37981 .03278 L
.41987 .05266 L
.4283 .05929 L
.45841 .09936 L
.45994 .10275 L
.47327 .13942 L
.48141 .17949 L
.48605 .21955 L
.48867 .25962 L
.48999 .29968 L
.49026 .33974 L
.4893 .37981 L
.48601 .41987 L
.47395 .45994 L
.45994 .47395 L
.41987 .48601 L
.37981 .4893 L
.33974 .49026 L
.29968 .48999 L
.25962 .48867 L
.21955 .48605 L
.17949 .48141 L
.13942 .47327 L
.10275 .45994 L
.09936 .45841 L
.05929 .4283 L
.05266 .41987 L
.03278 .37981 L
.02633 .33974 L
.02816 .29968 L
.03685 .25962 L
.05244 .21955 L
.05929 .20603 L
.07517 .17949 L
.09936 .14602 L
.10503 .13942 L
.13942 .10503 L
.14602 .09936 L
.17949 .07517 L
.20603 .05929 L
F
0 g
.21955 .05244 m
.25962 .03685 L
.29968 .02816 L
.33974 .02633 L
.37981 .03278 L
.41987 .05266 L
.4283 .05929 L
.45841 .09936 L
.45994 .10275 L
.47327 .13942 L
.48141 .17949 L
.48605 .21955 L
.48867 .25962 L
.48999 .29968 L
.49026 .33974 L
.4893 .37981 L
.48601 .41987 L
.47395 .45994 L
.45994 .47395 L
.41987 .48601 L
.37981 .4893 L
.33974 .49026 L
.29968 .48999 L
.25962 .48867 L
.21955 .48605 L
.17949 .48141 L
.13942 .47327 L
.10275 .45994 L
.09936 .45841 L
.05929 .4283 L
.05266 .41987 L
.03278 .37981 L
.02633 .33974 L
.02816 .29968 L
.03685 .25962 L
.05244 .21955 L
.05929 .20603 L
.07517 .17949 L
.09936 .14602 L
.10503 .13942 L
.13942 .10503 L
.14602 .09936 L
.17949 .07517 L
.20603 .05929 L
.21955 .05244 L
s
.4 g
.13942 .52673 m
.17949 .51859 L
.21955 .51395 L
.25962 .51133 L
.29968 .51001 L
.33974 .50974 L
.37981 .5107 L
.41987 .51399 L
.45994 .52605 L
.47395 .54006 L
.48601 .58013 L
.4893 .62019 L
.49026 .66026 L
.48999 .70032 L
.48867 .74038 L
.48605 .78045 L
.48141 .82051 L
.47327 .86058 L
.45994 .89725 L
.45841 .90064 L
.4283 .94071 L
.41987 .94734 L
.37981 .96722 L
.33974 .97367 L
.29968 .97184 L
.25962 .96315 L
.21955 .94756 L
.20603 .94071 L
.17949 .92483 L
.14602 .90064 L
.13942 .89497 L
.10503 .86058 L
.09936 .85398 L
.07517 .82051 L
.05929 .79397 L
.05244 .78045 L
.03685 .74038 L
.02816 .70032 L
.02633 .66026 L
.03278 .62019 L
.05266 .58013 L
.05929 .5717 L
.09936 .54159 L
.10275 .54006 L
F
0 g
.13942 .52673 m
.17949 .51859 L
.21955 .51395 L
.25962 .51133 L
.29968 .51001 L
.33974 .50974 L
.37981 .5107 L
.41987 .51399 L
.45994 .52605 L
.47395 .54006 L
.48601 .58013 L
.4893 .62019 L
.49026 .66026 L
.48999 .70032 L
.48867 .74038 L
.48605 .78045 L
.48141 .82051 L
.47327 .86058 L
.45994 .89725 L
.45841 .90064 L
.4283 .94071 L
.41987 .94734 L
.37981 .96722 L
.33974 .97367 L
.29968 .97184 L
.25962 .96315 L
.21955 .94756 L
.20603 .94071 L
.17949 .92483 L
.14602 .90064 L
.13942 .89497 L
.10503 .86058 L
.09936 .85398 L
.07517 .82051 L
.05929 .79397 L
.05244 .78045 L
.03685 .74038 L
.02816 .70032 L
.02633 .66026 L
.03278 .62019 L
.05266 .58013 L
.05929 .5717 L
.09936 .54159 L
.10275 .54006 L
.13942 .52673 L
s
.7 g
.25962 .12898 m
.29968 .11718 L
.33974 .11465 L
.37981 .12349 L
.41172 .13942 L
.41987 .15049 L
.44138 .17949 L
.45675 .21955 L
.45994 .23205 L
.46514 .25962 L
.46937 .29968 L
.47022 .33974 L
.46717 .37981 L
.45994 .4142 L
.45663 .41987 L
.41987 .45663 L
.4142 .45994 L
.37981 .46717 L
.33974 .47022 L
.29968 .46937 L
.25962 .46514 L
.23205 .45994 L
.21955 .45675 L
.17949 .44138 L
.15049 .41987 L
.13942 .41172 L
.12349 .37981 L
.11465 .33974 L
.11718 .29968 L
.12898 .25962 L
.13942 .23658 L
.15019 .21955 L
.17949 .18327 L
.18327 .17949 L
.21955 .15019 L
.23658 .13942 L
F
0 g
.25962 .12898 m
.29968 .11718 L
.33974 .11465 L
.37981 .12349 L
.41172 .13942 L
.41987 .15049 L
.44138 .17949 L
.45675 .21955 L
.45994 .23205 L
.46514 .25962 L
.46937 .29968 L
.47022 .33974 L
.46717 .37981 L
.45994 .4142 L
.45663 .41987 L
.41987 .45663 L
.4142 .45994 L
.37981 .46717 L
.33974 .47022 L
.29968 .46937 L
.25962 .46514 L
.23205 .45994 L
.21955 .45675 L
.17949 .44138 L
.15049 .41987 L
.13942 .41172 L
.12349 .37981 L
.11465 .33974 L
.11718 .29968 L
.12898 .25962 L
.13942 .23658 L
.15019 .21955 L
.17949 .18327 L
.18327 .17949 L
.21955 .15019 L
.23658 .13942 L
.25962 .12898 L
s
.3 g
.25962 .53486 m
.29968 .53063 L
.33974 .52978 L
.37981 .53283 L
.4142 .54006 L
.41987 .54337 L
.45663 .58013 L
.45994 .5858 L
.46717 .62019 L
.47022 .66026 L
.46937 .70032 L
.46514 .74038 L
.45994 .76795 L
.45675 .78045 L
.44138 .82051 L
.41987 .84951 L
.41172 .86058 L
.37981 .87651 L
.33974 .88535 L
.29968 .88282 L
.25962 .87102 L
.23658 .86058 L
.21955 .84981 L
.18327 .82051 L
.17949 .81673 L
.15019 .78045 L
.13942 .76342 L
.12898 .74038 L
.11718 .70032 L
.11465 .66026 L
.12349 .62019 L
.13942 .58828 L
.15049 .58013 L
.17949 .55862 L
.21955 .54325 L
.23205 .54006 L
F
0 g
.25962 .53486 m
.29968 .53063 L
.33974 .52978 L
.37981 .53283 L
.4142 .54006 L
.41987 .54337 L
.45663 .58013 L
.45994 .5858 L
.46717 .62019 L
.47022 .66026 L
.46937 .70032 L
.46514 .74038 L
.45994 .76795 L
.45675 .78045 L
.44138 .82051 L
.41987 .84951 L
.41172 .86058 L
.37981 .87651 L
.33974 .88535 L
.29968 .88282 L
.25962 .87102 L
.23658 .86058 L
.21955 .84981 L
.18327 .82051 L
.17949 .81673 L
.15019 .78045 L
.13942 .76342 L
.12898 .74038 L
.11718 .70032 L
.11465 .66026 L
.12349 .62019 L
.13942 .58828 L
.15049 .58013 L
.17949 .55862 L
.21955 .54325 L
.23205 .54006 L
.25962 .53486 L
s
.8 g
.29968 .17067 m
.33974 .16751 L
.37981 .17871 L
.38176 .17949 L
.41987 .21587 L
.4223 .21955 L
.43996 .25962 L
.44773 .29968 L
.44923 .33974 L
.44374 .37981 L
.42201 .41987 L
.41987 .42201 L
.37981 .44374 L
.33974 .44923 L
.29968 .44773 L
.25962 .43996 L
.21955 .4223 L
.21587 .41987 L
.17949 .38176 L
.17871 .37981 L
.16751 .33974 L
.17067 .29968 L
.17949 .27291 L
.18594 .25962 L
.21543 .21955 L
.21955 .21543 L
.25962 .18594 L
.27291 .17949 L
F
0 g
.29968 .17067 m
.33974 .16751 L
.37981 .17871 L
.38176 .17949 L
.41987 .21587 L
.4223 .21955 L
.43996 .25962 L
.44773 .29968 L
.44923 .33974 L
.44374 .37981 L
.42201 .41987 L
.41987 .42201 L
.37981 .44374 L
.33974 .44923 L
.29968 .44773 L
.25962 .43996 L
.21955 .4223 L
.21587 .41987 L
.17949 .38176 L
.17871 .37981 L
.16751 .33974 L
.17067 .29968 L
.17949 .27291 L
.18594 .25962 L
.21543 .21955 L
.21955 .21543 L
.25962 .18594 L
.27291 .17949 L
.29968 .17067 L
s
.2 g
.21955 .5777 m
.25962 .56004 L
.29968 .55227 L
.33974 .55077 L
.37981 .55626 L
.41987 .57799 L
.42201 .58013 L
.44374 .62019 L
.44923 .66026 L
.44773 .70032 L
.43996 .74038 L
.4223 .78045 L
.41987 .78413 L
.38176 .82051 L
.37981 .82129 L
.33974 .83249 L
.29968 .82933 L
.27291 .82051 L
.25962 .81406 L
.21955 .78457 L
.21543 .78045 L
.18594 .74038 L
.17949 .72709 L
.17067 .70032 L
.16751 .66026 L
.17871 .62019 L
.17949 .61824 L
.21587 .58013 L
F
0 g
.21955 .5777 m
.25962 .56004 L
.29968 .55227 L
.33974 .55077 L
.37981 .55626 L
.41987 .57799 L
.42201 .58013 L
.44374 .62019 L
.44923 .66026 L
.44773 .70032 L
.43996 .74038 L
.4223 .78045 L
.41987 .78413 L
.38176 .82051 L
.37981 .82129 L
.33974 .83249 L
.29968 .82933 L
.27291 .82051 L
.25962 .81406 L
.21955 .78457 L
.21543 .78045 L
.18594 .74038 L
.17949 .72709 L
.17067 .70032 L
.16751 .66026 L
.17871 .62019 L
.17949 .61824 L
.21587 .58013 L
.21955 .5777 L
s
.9 g
.29968 .21643 m
.33974 .21221 L
.36613 .21955 L
.37981 .22707 L
.41142 .25962 L
.41987 .29207 L
.42164 .29968 L
.4244 .33974 L
.41987 .36513 L
.41662 .37981 L
.37981 .41662 L
.36513 .41987 L
.33974 .4244 L
.29968 .42164 L
.29207 .41987 L
.25962 .41142 L
.22707 .37981 L
.21955 .36613 L
.21221 .33974 L
.21643 .29968 L
.21955 .29093 L
.2371 .25962 L
.25962 .2371 L
.29093 .21955 L
F
0 g
.29968 .21643 m
.33974 .21221 L
.36613 .21955 L
.37981 .22707 L
.41142 .25962 L
.41987 .29207 L
.42164 .29968 L
.4244 .33974 L
.41987 .36513 L
.41662 .37981 L
.37981 .41662 L
.36513 .41987 L
.33974 .4244 L
.29968 .42164 L
.29207 .41987 L
.25962 .41142 L
.22707 .37981 L
.21955 .36613 L
.21221 .33974 L
.21643 .29968 L
.21955 .29093 L
.2371 .25962 L
.25962 .2371 L
.29093 .21955 L
.29968 .21643 L
s
.1 g
.29968 .57836 m
.33974 .5756 L
.36513 .58013 L
.37981 .58338 L
.41662 .62019 L
.41987 .63487 L
.4244 .66026 L
.42164 .70032 L
.41987 .70793 L
.41142 .74038 L
.37981 .77293 L
.36613 .78045 L
.33974 .78779 L
.29968 .78357 L
.29093 .78045 L
.25962 .7629 L
.2371 .74038 L
.21955 .70907 L
.21643 .70032 L
.21221 .66026 L
.21955 .63387 L
.22707 .62019 L
.25962 .58858 L
.29207 .58013 L
F
0 g
.29968 .57836 m
.33974 .5756 L
.36513 .58013 L
.37981 .58338 L
.41662 .62019 L
.41987 .63487 L
.4244 .66026 L
.42164 .70032 L
.41987 .70793 L
.41142 .74038 L
.37981 .77293 L
.36613 .78045 L
.33974 .78779 L
.29968 .78357 L
.29093 .78045 L
.25962 .7629 L
.2371 .74038 L
.21955 .70907 L
.21643 .70032 L
.21221 .66026 L
.21955 .63387 L
.22707 .62019 L
.25962 .58858 L
.29207 .58013 L
.29968 .57836 L
s
1 g
.33974 .25916 m
.34192 .25962 L
.37981 .28612 L
.38898 .29968 L
.39539 .33974 L
.37981 .37029 L
.37029 .37981 L
.33974 .39539 L
.29968 .38898 L
.28612 .37981 L
.25962 .34192 L
.25916 .33974 L
.25962 .31815 L
.2659 .29968 L
.29968 .2659 L
.31815 .25962 L
F
0 g
.33974 .25916 m
.34192 .25962 L
.37981 .28612 L
.38898 .29968 L
.39539 .33974 L
.37981 .37029 L
.37029 .37981 L
.33974 .39539 L
.29968 .38898 L
.28612 .37981 L
.25962 .34192 L
.25916 .33974 L
.25962 .31815 L
.2659 .29968 L
.29968 .2659 L
.31815 .25962 L
.33974 .25916 L
s
.29968 .61102 m
.33974 .60461 L
.37029 .62019 L
.37981 .62971 L
.39539 .66026 L
.38898 .70032 L
.37981 .71388 L
.34192 .74038 L
.33974 .74084 L
.31815 .74038 L
.29968 .7341 L
.2659 .70032 L
.25962 .68185 L
.25916 .66026 L
.25962 .65808 L
.28612 .62019 L
F
.29968 .61102 m
.33974 .60461 L
.37029 .62019 L
.37981 .62971 L
.39539 .66026 L
.38898 .70032 L
.37981 .71388 L
.34192 .74038 L
.33974 .74084 L
.31815 .74038 L
.29968 .7341 L
.2659 .70032 L
.25962 .68185 L
.25916 .66026 L
.25962 .65808 L
.28612 .62019 L
.29968 .61102 L
s
.6 g
.54006 .52605 m
.58013 .51399 L
.62019 .5107 L
.66026 .50974 L
.70032 .51001 L
.74038 .51133 L
.78045 .51395 L
.82051 .51859 L
.86058 .52673 L
.89725 .54006 L
.90064 .54159 L
.94071 .5717 L
.94734 .58013 L
.96722 .62019 L
.97367 .66026 L
.97184 .70032 L
.96315 .74038 L
.94756 .78045 L
.94071 .79397 L
.92483 .82051 L
.90064 .85398 L
.89497 .86058 L
.86058 .89497 L
.85398 .90064 L
.82051 .92483 L
.79397 .94071 L
.78045 .94756 L
.74038 .96315 L
.70032 .97184 L
.66026 .97367 L
.62019 .96722 L
.58013 .94734 L
.5717 .94071 L
.54159 .90064 L
.54006 .89725 L
.52673 .86058 L
.51859 .82051 L
.51395 .78045 L
.51133 .74038 L
.51001 .70032 L
.50974 .66026 L
.5107 .62019 L
.51399 .58013 L
.52605 .54006 L
F
0 g
.54006 .52605 m
.58013 .51399 L
.62019 .5107 L
.66026 .50974 L
.70032 .51001 L
.74038 .51133 L
.78045 .51395 L
.82051 .51859 L
.86058 .52673 L
.89725 .54006 L
.90064 .54159 L
.94071 .5717 L
.94734 .58013 L
.96722 .62019 L
.97367 .66026 L
.97184 .70032 L
.96315 .74038 L
.94756 .78045 L
.94071 .79397 L
.92483 .82051 L
.90064 .85398 L
.89497 .86058 L
.86058 .89497 L
.85398 .90064 L
.82051 .92483 L
.79397 .94071 L
.78045 .94756 L
.74038 .96315 L
.70032 .97184 L
.66026 .97367 L
.62019 .96722 L
.58013 .94734 L
.5717 .94071 L
.54159 .90064 L
.54006 .89725 L
.52673 .86058 L
.51859 .82051 L
.51395 .78045 L
.51133 .74038 L
.51001 .70032 L
.50974 .66026 L
.5107 .62019 L
.51399 .58013 L
.52605 .54006 L
.54006 .52605 L
s
.4 g
.58013 .05266 m
.62019 .03278 L
.66026 .02633 L
.70032 .02816 L
.74038 .03685 L
.78045 .05244 L
.79397 .05929 L
.82051 .07517 L
.85398 .09936 L
.86058 .10503 L
.89497 .13942 L
.90064 .14602 L
.92483 .17949 L
.94071 .20603 L
.94756 .21955 L
.96315 .25962 L
.97184 .29968 L
.97367 .33974 L
.96722 .37981 L
.94734 .41987 L
.94071 .4283 L
.90064 .45841 L
.89725 .45994 L
.86058 .47327 L
.82051 .48141 L
.78045 .48605 L
.74038 .48867 L
.70032 .48999 L
.66026 .49026 L
.62019 .4893 L
.58013 .48601 L
.54006 .47395 L
.52605 .45994 L
.51399 .41987 L
.5107 .37981 L
.50974 .33974 L
.51001 .29968 L
.51133 .25962 L
.51395 .21955 L
.51859 .17949 L
.52673 .13942 L
.54006 .10275 L
.54159 .09936 L
.5717 .05929 L
F
0 g
.58013 .05266 m
.62019 .03278 L
.66026 .02633 L
.70032 .02816 L
.74038 .03685 L
.78045 .05244 L
.79397 .05929 L
.82051 .07517 L
.85398 .09936 L
.86058 .10503 L
.89497 .13942 L
.90064 .14602 L
.92483 .17949 L
.94071 .20603 L
.94756 .21955 L
.96315 .25962 L
.97184 .29968 L
.97367 .33974 L
.96722 .37981 L
.94734 .41987 L
.94071 .4283 L
.90064 .45841 L
.89725 .45994 L
.86058 .47327 L
.82051 .48141 L
.78045 .48605 L
.74038 .48867 L
.70032 .48999 L
.66026 .49026 L
.62019 .4893 L
.58013 .48601 L
.54006 .47395 L
.52605 .45994 L
.51399 .41987 L
.5107 .37981 L
.50974 .33974 L
.51001 .29968 L
.51133 .25962 L
.51395 .21955 L
.51859 .17949 L
.52673 .13942 L
.54006 .10275 L
.54159 .09936 L
.5717 .05929 L
.58013 .05266 L
s
.7 g
.62019 .53283 m
.66026 .52978 L
.70032 .53063 L
.74038 .53486 L
.76795 .54006 L
.78045 .54325 L
.82051 .55862 L
.84951 .58013 L
.86058 .58828 L
.87651 .62019 L
.88535 .66026 L
.88282 .70032 L
.87102 .74038 L
.86058 .76342 L
.84981 .78045 L
.82051 .81673 L
.81673 .82051 L
.78045 .84981 L
.76342 .86058 L
.74038 .87102 L
.70032 .88282 L
.66026 .88535 L
.62019 .87651 L
.58828 .86058 L
.58013 .84951 L
.55862 .82051 L
.54325 .78045 L
.54006 .76795 L
.53486 .74038 L
.53063 .70032 L
.52978 .66026 L
.53283 .62019 L
.54006 .5858 L
.54337 .58013 L
.58013 .54337 L
.5858 .54006 L
F
0 g
.62019 .53283 m
.66026 .52978 L
.70032 .53063 L
.74038 .53486 L
.76795 .54006 L
.78045 .54325 L
.82051 .55862 L
.84951 .58013 L
.86058 .58828 L
.87651 .62019 L
.88535 .66026 L
.88282 .70032 L
.87102 .74038 L
.86058 .76342 L
.84981 .78045 L
.82051 .81673 L
.81673 .82051 L
.78045 .84981 L
.76342 .86058 L
.74038 .87102 L
.70032 .88282 L
.66026 .88535 L
.62019 .87651 L
.58828 .86058 L
.58013 .84951 L
.55862 .82051 L
.54325 .78045 L
.54006 .76795 L
.53486 .74038 L
.53063 .70032 L
.52978 .66026 L
.53283 .62019 L
.54006 .5858 L
.54337 .58013 L
.58013 .54337 L
.5858 .54006 L
.62019 .53283 L
s
.3 g
.62019 .12349 m
.66026 .11465 L
.70032 .11718 L
.74038 .12898 L
.76342 .13942 L
.78045 .15019 L
.81673 .17949 L
.82051 .18327 L
.84981 .21955 L
.86058 .23658 L
.87102 .25962 L
.88282 .29968 L
.88535 .33974 L
.87651 .37981 L
.86058 .41172 L
.84951 .41987 L
.82051 .44138 L
.78045 .45675 L
.76795 .45994 L
.74038 .46514 L
.70032 .46937 L
.66026 .47022 L
.62019 .46717 L
.5858 .45994 L
.58013 .45663 L
.54337 .41987 L
.54006 .4142 L
.53283 .37981 L
.52978 .33974 L
.53063 .29968 L
.53486 .25962 L
.54006 .23205 L
.54325 .21955 L
.55862 .17949 L
.58013 .15049 L
.58828 .13942 L
F
0 g
.62019 .12349 m
.66026 .11465 L
.70032 .11718 L
.74038 .12898 L
.76342 .13942 L
.78045 .15019 L
.81673 .17949 L
.82051 .18327 L
.84981 .21955 L
.86058 .23658 L
.87102 .25962 L
.88282 .29968 L
.88535 .33974 L
.87651 .37981 L
.86058 .41172 L
.84951 .41987 L
.82051 .44138 L
.78045 .45675 L
.76795 .45994 L
.74038 .46514 L
.70032 .46937 L
.66026 .47022 L
.62019 .46717 L
.5858 .45994 L
.58013 .45663 L
.54337 .41987 L
.54006 .4142 L
.53283 .37981 L
.52978 .33974 L
.53063 .29968 L
.53486 .25962 L
.54006 .23205 L
.54325 .21955 L
.55862 .17949 L
.58013 .15049 L
.58828 .13942 L
.62019 .12349 L
s
.8 g
.58013 .57799 m
.62019 .55626 L
.66026 .55077 L
.70032 .55227 L
.74038 .56004 L
.78045 .5777 L
.78413 .58013 L
.82051 .61824 L
.82129 .62019 L
.83249 .66026 L
.82933 .70032 L
.82051 .72709 L
.81406 .74038 L
.78457 .78045 L
.78045 .78457 L
.74038 .81406 L
.72709 .82051 L
.70032 .82933 L
.66026 .83249 L
.62019 .82129 L
.61824 .82051 L
.58013 .78413 L
.5777 .78045 L
.56004 .74038 L
.55227 .70032 L
.55077 .66026 L
.55626 .62019 L
.57799 .58013 L
F
0 g
.58013 .57799 m
.62019 .55626 L
.66026 .55077 L
.70032 .55227 L
.74038 .56004 L
.78045 .5777 L
.78413 .58013 L
.82051 .61824 L
.82129 .62019 L
.83249 .66026 L
.82933 .70032 L
.82051 .72709 L
.81406 .74038 L
.78457 .78045 L
.78045 .78457 L
.74038 .81406 L
.72709 .82051 L
.70032 .82933 L
.66026 .83249 L
.62019 .82129 L
.61824 .82051 L
.58013 .78413 L
.5777 .78045 L
.56004 .74038 L
.55227 .70032 L
.55077 .66026 L
.55626 .62019 L
.57799 .58013 L
.58013 .57799 L
s
.2 g
.62019 .17871 m
.66026 .16751 L
.70032 .17067 L
.72709 .17949 L
.74038 .18594 L
.78045 .21543 L
.78457 .21955 L
.81406 .25962 L
.82051 .27291 L
.82933 .29968 L
.83249 .33974 L
.82129 .37981 L
.82051 .38176 L
.78413 .41987 L
.78045 .4223 L
.74038 .43996 L
.70032 .44773 L
.66026 .44923 L
.62019 .44374 L
.58013 .42201 L
.57799 .41987 L
.55626 .37981 L
.55077 .33974 L
.55227 .29968 L
.56004 .25962 L
.5777 .21955 L
.58013 .21587 L
.61824 .17949 L
F
0 g
.62019 .17871 m
.66026 .16751 L
.70032 .17067 L
.72709 .17949 L
.74038 .18594 L
.78045 .21543 L
.78457 .21955 L
.81406 .25962 L
.82051 .27291 L
.82933 .29968 L
.83249 .33974 L
.82129 .37981 L
.82051 .38176 L
.78413 .41987 L
.78045 .4223 L
.74038 .43996 L
.70032 .44773 L
.66026 .44923 L
.62019 .44374 L
.58013 .42201 L
.57799 .41987 L
.55626 .37981 L
.55077 .33974 L
.55227 .29968 L
.56004 .25962 L
.5777 .21955 L
.58013 .21587 L
.61824 .17949 L
.62019 .17871 L
s
.9 g
.66026 .5756 m
.70032 .57836 L
.70793 .58013 L
.74038 .58858 L
.77293 .62019 L
.78045 .63387 L
.78779 .66026 L
.78357 .70032 L
.78045 .70907 L
.7629 .74038 L
.74038 .7629 L
.70907 .78045 L
.70032 .78357 L
.66026 .78779 L
.63387 .78045 L
.62019 .77293 L
.58858 .74038 L
.58013 .70793 L
.57836 .70032 L
.5756 .66026 L
.58013 .63487 L
.58338 .62019 L
.62019 .58338 L
.63487 .58013 L
F
0 g
.66026 .5756 m
.70032 .57836 L
.70793 .58013 L
.74038 .58858 L
.77293 .62019 L
.78045 .63387 L
.78779 .66026 L
.78357 .70032 L
.78045 .70907 L
.7629 .74038 L
.74038 .7629 L
.70907 .78045 L
.70032 .78357 L
.66026 .78779 L
.63387 .78045 L
.62019 .77293 L
.58858 .74038 L
.58013 .70793 L
.57836 .70032 L
.5756 .66026 L
.58013 .63487 L
.58338 .62019 L
.62019 .58338 L
.63487 .58013 L
.66026 .5756 L
s
.1 g
.66026 .21221 m
.70032 .21643 L
.70907 .21955 L
.74038 .2371 L
.7629 .25962 L
.78045 .29093 L
.78357 .29968 L
.78779 .33974 L
.78045 .36613 L
.77293 .37981 L
.74038 .41142 L
.70793 .41987 L
.70032 .42164 L
.66026 .4244 L
.63487 .41987 L
.62019 .41662 L
.58338 .37981 L
.58013 .36513 L
.5756 .33974 L
.57836 .29968 L
.58013 .29207 L
.58858 .25962 L
.62019 .22707 L
.63387 .21955 L
F
0 g
.66026 .21221 m
.70032 .21643 L
.70907 .21955 L
.74038 .2371 L
.7629 .25962 L
.78045 .29093 L
.78357 .29968 L
.78779 .33974 L
.78045 .36613 L
.77293 .37981 L
.74038 .41142 L
.70793 .41987 L
.70032 .42164 L
.66026 .4244 L
.63487 .41987 L
.62019 .41662 L
.58338 .37981 L
.58013 .36513 L
.5756 .33974 L
.57836 .29968 L
.58013 .29207 L
.58858 .25962 L
.62019 .22707 L
.63387 .21955 L
.66026 .21221 L
s
1 g
.66026 .60461 m
.70032 .61102 L
.71388 .62019 L
.74038 .65808 L
.74084 .66026 L
.74038 .68185 L
.7341 .70032 L
.70032 .7341 L
.68185 .74038 L
.66026 .74084 L
.65808 .74038 L
.62019 .71388 L
.61102 .70032 L
.60461 .66026 L
.62019 .62971 L
.62971 .62019 L
F
0 g
.66026 .60461 m
.70032 .61102 L
.71388 .62019 L
.74038 .65808 L
.74084 .66026 L
.74038 .68185 L
.7341 .70032 L
.70032 .7341 L
.68185 .74038 L
.66026 .74084 L
.65808 .74038 L
.62019 .71388 L
.61102 .70032 L
.60461 .66026 L
.62019 .62971 L
.62971 .62019 L
.66026 .60461 L
s
.66026 .25916 m
.68185 .25962 L
.70032 .2659 L
.7341 .29968 L
.74038 .31815 L
.74084 .33974 L
.74038 .34192 L
.71388 .37981 L
.70032 .38898 L
.66026 .39539 L
.62971 .37981 L
.62019 .37029 L
.60461 .33974 L
.61102 .29968 L
.62019 .28612 L
.65808 .25962 L
F
.66026 .25916 m
.68185 .25962 L
.70032 .2659 L
.7341 .29968 L
.74038 .31815 L
.74084 .33974 L
.74038 .34192 L
.71388 .37981 L
.70032 .38898 L
.66026 .39539 L
.62971 .37981 L
.62019 .37029 L
.60461 .33974 L
.61102 .29968 L
.62019 .28612 L
.65808 .25962 L
.66026 .25916 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`007P3oool00`3oom@0V`000000
00040000000309_Do`3oool0oooo05T0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?oo
o`1F0?ooo`050?oDV`00000000000000002Ke?l0G03oool00`3oe9/000000000000300000003002K
e03oool0oooo05P0oooo00<0oooD09/000000000100000000`2Ke?l0oooo0?ooo`040?ooo`007`3o
ool00`3DV`00002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo05d0oooo00<0^W9b0;[Zo`3oool0F@3o
ool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Cooeh0oooo00<0^W9b0;[Zo`3oool0G03oool00`3DV`00
002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo00D0oooo000P0?ooo`030?oDV`000780^^[o0640oooo
00<0^W9b0;[Zo`3oool0F03oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo05d0oooo
00<0^W9b0;[Zo`3oool0G@3oool00`3oe9/0001b0;[Zo`090?ooo`008@3oool00`3oj[X0LP0007:j
jP1P0?ooo`030;YbLP2jj_l0oooo05P0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`1M0?ooo`030;YbLP2jj_l0oooo05h0oooo00<0onZj0780001b^^X0203oool001H0oooo00<0^W80
0000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0oooo0580oooo00<0^W80
0000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo05P0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`1M0?ooo`030;YbLP2jj_l0oooo0600oooo00<0^W80
07:jjP3oool01P3oool002@0oooo00<0^W:K0=Coo`3oool0G@3oool00`2jLW80^^[o0?ooo`1H0?oo
o`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0G@3oool00`2jLW80^^[o0?ooo`1Q0?oo
o`030;YbV`3Dool0oooo00D0oooo000O0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0e9/009_Do`3o
ool0G@3oool00`2jLW80^^[o0?ooo`1H0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3o
ool0G@3oool00`2jLW80^^[o0?ooo`1L0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0e9/009_Do`3o
ool01@3oool001l0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o05/0oooo00D0j[Yb0000
0000L[X0^W9b0;[Zo`1J0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?ooF`3oool01@3Z^W800000
001b^P2jLW80^^[o05d0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o00H0oooo000P0?oo
o`050?oDV`00000000000000LP2jj_l0GP3oool00`3Z^W80001b0;[Zo`1J0?ooo`050?ooe02K0000
00000000LP2jj_l0GP3oool00`3Z^W80001b0;[Zo`1N0?ooo`050?oDV`00000000000000LP2jj_l0
1`3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool001L0ooooo`00002I00000040
oooo000G0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00D0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0A0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`050?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo00D0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`3o0?oo
oiD0oooo0@0000010?ooo`002@3oool00`3oom@0V`00000000040000000309_Do`3oool0oooo00@0
oooo00<000000?ooo`3oool0o`3ooonE0?ooo`4000000@3oool000X0oooo00<0e9/00000V`3Dool0
0P3oool00`3Z^Y/0^^[o0?ooo`050?ooo`030000003oool0oooo0?l0ooooU@3oool100000040oooo
000;0?ooo`030?oDV`000780^^[o00T0oooo00<000000?ooo`3oool0o`3ooonE0?ooo`4000000@3o
ool000`0oooo00<0onZj0780001b^^X0203oool300000?l0ooooT`3oool300000040oooo00000`3o
ool0^W800000000400000003001b^P3oool0oooo00@0oooo00<0^W8007:jjP3oool01P3oool00`00
0000oooo0?ooo`040?ooool0OgmoR@1oOgl80?ooo`4000000@3oool000l0oooo00<0^W:K0=Coo`3o
ool01@3oool00`000000oooo0?ooo`040?ooool0OgmoR@1oOgl80?ooo`4000000@3oool000X0oooo
00<0j[Yb09_Do`3oool00P3oool00`3DV`00VmCo0?ooo`050?ooo`030000003oool0oooo00@0oooo
O01oOgl:000007h0Ogmo2P00001j07moO`P0oooo0@0000010?ooo`002P3oool01`3oe9/0002K0=Co
o`3oool0omBK0000LP2jj_l01P3oool00`000000oooo0?ooo`040?ooog40Ogmo2`00000:09VIV@D0
0000L`1oOgl6000000X0IVIV2`00001_07moO`P0oooo0@0000010?ooo`002`3oool01@3oe9/00000
000000000780^^[o00L0oooo00<000000?ooo`3oool0103ooom[07moO`H000006P2IVIT6000006L0
Ogmo1P00000K06IVIPD00000JP1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103ooomU07moO`H000009P2IVIT400000600Ogmo0`00000V06IVIPH00000I01oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103ooomQ07moO`@00000<02IVIT2000005`0Ogmo0P00
000_06IVIP@00000H01oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooomO
07moO`800000=P2IVIT2000005P0Ogmo0P00000e06IVIP800000GP1oOgl80?ooo`4000000@3oool0
01L0oooo00<000000?ooo`3oool0103ooomM07moO`800000>P2IVIT2000005@0Ogmo0P00000i06IV
IP<00000F`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooomK07moO`80
0000?P2IVIT200000500Ogmo0P00000n06IVIP800000F@1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103ooomH07moO`<00000@P2IVIT2000004`0Ogmo0P00001206IVIP800000
E`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooomF07moO`800000A`2I
VIT2000004P0Ogmo0P00001606IVIP<00000E01oOgl80?ooo`4000000@3oool001L0oooo00<00000
0?ooo`3oool0103ooomD07moO`800000B`2IVIT2000004@0Ogmo0P00001;06IVIP800000DP1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooomB07moO`800000C`2IVIT20000
0400Ogmo0P00001?06IVIP800000D01oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3o
ool0103ooom@07moO`800000D`2IVIT00`000000Ogmo07moO`0l07moO`030000001VIVH0IVIV0540
IVIV0P00001>07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooodh0Ogmo
0P00001F09VIV@030000001oOgl0Ogmo03X0Ogmo00<0000006IVIP1VIVH0E01VIVH2000004`0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0ooooC@1oOgl00`000000VIVI09VI
V@1G09VIV@030000001oOgl0Ogmo03P0Ogmo00<0000006IVIP1VIVH0E`1VIVH00`000000Ogmo07mo
O`1907moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oood/0Ogmo0P00001K
09VIV@030000001oOgl0Ogmo03H0Ogmo00<0000006IVIP1VIVH0F@1VIVH2000004T0Ogmo203oool1
00000040oooo000G0?ooo`030000003oool0oooo00@0ooooB@1oOgl2000005d0VIVI00<0000007mo
O`1oOgl0=@1oOgl00`000000IVIV06IVIP1L06IVIP800000A`1oOgl80?ooo`4000000@3oool001L0
oooo0P0000050?ooodL0Ogmo0P00001P09VIV@030000001oOgl0Ogmo03@0Ogmo00<0000006IVIP1V
IVH0GP1VIVH2000004D0Ogmo1`3oool200000040oooo000G0?ooo`030000003oool0oooo00@0oooo
A@1oOgl2000006<0VIVI00<0000007moO`1oOgl0<P1oOgl00`000000IVIV06IVIP1Q06IVIP800000
@`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooom307moO`800000IP2I
VIT00`000000Ogmo07moO`0`07moO`030000001VIVH0IVIV06@0IVIV0P00001107moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?oood80Ogmo00<0000009VIV@2IVIT0IP2IVIT0
0`000000Ogmo07moO`0_07moO`030000001VIVH0IVIV06L0IVIV00<0000007moO`1oOgl0?P1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooom007moO`800000JP2IVIT00`00
0000Ogmo07moO`0]07moO`030000001VIVH0IVIV06T0IVIV0P00000n07moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?ooocl0Ogmo00<0000009VIV@2IVIT0J`2IVIT00`000000
Ogmo07moO`0[07moO`030000001VIVH0IVIV06`0IVIV00<0000007moO`1oOgl0>`1oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oooln07moO`030000002IVIT0VIVI06d0VIVI
00<0000007moO`1oOgl0:P1oOgl00`000000IVIV06IVIP1]06IVIP030000001oOgl0Ogmo03X0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo?01oOgl200000700VIVI00<0
000007moO`1oOgl0:@1oOgl00`000000IVIV06IVIP1_06IVIP800000>P1oOgl80?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103ooolk07moO`030000002IVIT0VIVI0740VIVI00<00000
07moO`1oOgl09`1oOgl00`000000IVIV06IVIP1b06IVIP030000001oOgl0Ogmo03L0Ogmo203oool1
00000040oooo000G0?ooo`030000003oool0oooo00@0oooo>@1oOgl2000007D0VIVI00<0000007mo
O`1oOgl09@1oOgl00`000000IVIV06IVIP1d06IVIP800000=`1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103ooolh07moO`030000002IVIT0VIVI07H0VIVI00<0000007moO`1o
Ogl08`1oOgl00`000000IVIV06IVIP1g06IVIP030000001oOgl0Ogmo03@0Ogmo203oool100000040
oooo000G0?ooo`030000003oool0oooo00@0oooo=`1oOgl00`000000VIVI09VIV@1g09VIV@030000
001oOgl0Ogmo02<0Ogmo00<0000006IVIP1VIVH0N01VIVH00`000000Ogmo07moO`0c07moO`P0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooocD0Ogmo0P00001k09VIV@030000001o
Ogl0Ogmo0240Ogmo00<0000006IVIP1VIVH0NP1VIVH2000003<0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo=01oOgl00`000000VIVI09VIV@1l09VIV@030000001oOgl0
Ogmo01l0Ogmo00<0000006IVIP1VIVH0O@1VIVH00`000000Ogmo07moO`0`07moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?oooc80Ogmo0P00002009VIV@030000001oOgl0Ogmo
01h0Ogmo00<0000006IVIP1VIVH0OP1VIVH00`000000Ogmo07moO`0_07moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?oooc40Ogmo00<0000009VIV@2IVIT0P02IVIT00`000000
Ogmo07moO`0N07moO`030000001VIVH0IVIV07l0IVIV00<0000007moO`1oOgl0;P1oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oool`07moO`030000002IVIT0VIVI0880VIVI
00<0000007moO`1oOgl0701oOgl00`000000IVIV06IVIP2106IVIP030000001oOgl0Ogmo02d0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo;`1oOgl00`000000VIVI09VI
V@2309VIV@030000001oOgl0Ogmo01`0Ogmo00<0000006IVIP1VIVH0PP1VIVH00`000000Ogmo07mo
O`0/07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobh0Ogmo00<00000
09VIV@2IVIT0Q@2IVIT00`000000Ogmo07moO`0J07moO`030000001VIVH0IVIV08@0IVIV00<00000
07moO`1oOgl0:`1oOgl80?ooo`4000000@3oool001L0oooo0P0000050?ooobd0Ogmo00<0000009VI
V@2IVIT0C02IVIT900000340VIVI00<0000007moO`1oOgl06P1oOgl00`000000IVIV06IVIP0^06IV
IPX00000C@1VIVH00`000000Ogmo07moO`0Z07moO`L0oooo0P0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooob`0Ogmo00<0000009VIV@2IVIT0@`2IVIT:000000T0/k>c1000000]09VIV@03
0000001oOgl0Ogmo01X0Ogmo00<0000006IVIP1VIVH0:P1VIVH4000000X0C4a<2P00001406IVIP03
0000001oOgl0Ogmo02T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo
:`1oOgl00`000000VIVI09VIV@1009VIV@@000005`2c/k<4000002X0VIVI00<0000007moO`1oOgl0
601oOgl00`000000IVIV06IVIP0W06IVIP@00000601<C4`300000480IVIV00<0000007moO`1oOgl0
:01oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolZ07moO`030000002I
VIT0VIVI03h0VIVI0`00000O0;>c/`@000009P2IVIT00`000000Ogmo07moO`0H07moO`030000001V
IVH0IVIV02<0IVIV1000000O04a<C0<00000@01VIVH00`000000Ogmo07moO`0W07moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?ooobT0Ogmo00<0000009VIV@2IVIT0?02IVIT3
000002H0/k>c1000000S09VIV@030000001oOgl0Ogmo01H0Ogmo00<0000006IVIP1VIVH0801VIVH4
000002H0C4a<1000000m06IVIP030000001oOgl0Ogmo02H0Ogmo203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo:01oOgl00`000000VIVI09VIV@0i09VIV@@00000;@2c/k<20000
0240VIVI00<0000007moO`1oOgl05P1oOgl00`000000IVIV06IVIP0N06IVIP800000;P1<C4`30000
03/0IVIV00<0000007moO`1oOgl09@1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3o
ool0103ooolW07moO`030000002IVIT0VIVI03L0VIVI0`00000c0;>c/`8000007`2IVIT00`000000
Ogmo07moO`0F07moO`030000001VIVH0IVIV01`0IVIV0P00000c04a<C0<00000>@1VIVH00`000000
Ogmo07moO`0T07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobH0Ogmo
00<0000009VIV@2IVIT0=P2IVIT2000003P0/k>c0P00000N09VIV@030000001oOgl0Ogmo01@0Ogmo
00<0000006IVIP1VIVH06`1VIVH2000003P0C4a<0P00000h06IVIP030000001oOgl0Ogmo02<0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo9@1oOgl00`000000VIVI09VI
V@0e09VIV@800000?02c/k<2000001`0VIVI00<0000007moO`1oOgl0501oOgl00`000000IVIV06IV
IP0I06IVIP800000?01<C4`3000003H0IVIV00<0000007moO`1oOgl08P1oOgl80?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103ooolT07moO`030000002IVIT0VIVI03@0VIVI0P000010
0;>c/`8000006`2IVIT00`000000Ogmo07moO`0B07moO`030000001VIVH0IVIV01P0IVIV0P000011
04a<C0800000=@1VIVH00`000000Ogmo07moO`0Q07moO`P0oooo0@0000010?ooo`005`3oool00`00
0000oooo0?ooo`040?ooob<0Ogmo00<0000009VIV@2IVIT0<`2IVIT2000004@0/k>c0P00000I09VI
V@030000001oOgl0Ogmo0180Ogmo00<0000006IVIP1VIVH05P1VIVH2000004D0C4a<0P00000d06IV
IP030000001oOgl0Ogmo0200Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0
oooo8P1oOgl00`000000VIVI09VIV@0b09VIV@800000B02c/k<00`000000VIVI09VIV@0F09VIV@03
0000001oOgl0Ogmo0180Ogmo00<0000006IVIP1VIVH05@1VIVH00`000000C4a<04a<C01704a<C080
0000<`1VIVH00`000000Ogmo07moO`0O07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?ooob80Ogmo00<0000009VIV@2IVIT0<@2IVIT00`000000/k>c0;>c/`190;>c/`030000
002IVIT0VIVI01D0VIVI00<0000007moO`1oOgl04P1oOgl00`000000IVIV06IVIP0E06IVIP030000
001<C4`0C4a<04T0C4a<00<0000006IVIP1VIVH0<@1VIVH00`000000Ogmo07moO`0N07moO`P0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob40Ogmo00<0000009VIV@2IVIT0<@2I
VIT00`000000/k>c0;>c/`1:0;>c/`030000002IVIT0VIVI01H0VIVI00<0000007moO`1oOgl0401o
Ogl00`000000IVIV06IVIP0E06IVIP030000001<C4`0C4a<04/0C4a<00<0000006IVIP1VIVH0<@1V
IVH00`000000Ogmo07moO`0M07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`04
0?ooob00Ogmo00<0000009VIV@2IVIT0<02IVIT2000004h0/k>c00<0000009VIV@2IVIT05@2IVIT0
0`000000Ogmo07moO`0@07moO`030000001VIVH0IVIV01D0IVIV00<0000004a<C01<C4`0C01<C4`2
00000380IVIV00<0000007moO`1oOgl0701oOgl80?ooo`4000000@3oool001L0oooo00<000000?oo
o`3oool0103ooolP07moO`030000002IVIT0VIVI02l0VIVI00<000000;>c/`2c/k<0C`2c/k<00`00
0000VIVI09VIV@0D09VIV@030000001oOgl0Ogmo0100Ogmo00<0000006IVIP1VIVH0501VIVH00`00
0000C4a<04a<C01?04a<C0030000001VIVH0IVIV02l0IVIV00<0000007moO`1oOgl0701oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolO07moO`030000002IVIT0VIVI02l0
VIVI00<000000;>c/`2c/k<0D@2c/k<00`000000VIVI09VIV@0C09VIV@030000001oOgl0Ogmo0100
Ogmo00<0000006IVIP1VIVH04`1VIVH00`000000C4a<04a<C01A04a<C0030000001VIVH0IVIV02l0
IVIV00<0000007moO`1oOgl06`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103ooolN07moO`030000002IVIT0VIVI02h0VIVI0P00001D0;>c/`030000002IVIT0VIVI01<0VIVI
00<0000007moO`1oOgl0401oOgl00`000000IVIV06IVIP0B06IVIP030000001<C4`0C4a<05<0C4a<
0P00000`06IVIP030000001oOgl0Ogmo01X0Ogmo203oool100000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo7@1oOgl00`000000VIVI09VIV@0^09VIV@030000002c/k<0/k>c05D0/k>c00<0
000009VIV@2IVIT04P2IVIT00`000000Ogmo07moO`0@07moO`030000001VIVH0IVIV0180IVIV00<0
000004a<C01<C4`0E@1<C4`00`000000IVIV06IVIP0^06IVIP030000001oOgl0Ogmo01T0Ogmo203o
ool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo7@1oOgl00`000000VIVI09VIV@0]
09VIV@030000002c/k<0/k>c05L0/k>c00<0000009VIV@2IVIT04P2IVIT00`000000Ogmo07moO`0>
07moO`030000001VIVH0IVIV0180IVIV00<0000004a<C01<C4`0E`1<C4`00`000000IVIV06IVIP0]
06IVIP030000001oOgl0Ogmo01T0Ogmo203oool100000040oooo000G0?ooo`8000001@3ooolL07mo
O`030000002IVIT0VIVI02d0VIVI00<000000;>c/`2c/k<0F@2c/k<00`000000VIVI09VIV@0A09VI
V@030000001oOgl0Ogmo00h0Ogmo00<0000006IVIP1VIVH04@1VIVH00`000000C4a<04a<C01I04a<
C0030000001VIVH0IVIV02d0IVIV00<0000007moO`1oOgl0601oOgl70?ooo`8000000@3oool001L0
oooo00<000000?ooo`3oool0103ooolK07moO`030000002IVIT0VIVI02`0VIVI0P00001L0;>c/`03
0000002IVIT0VIVI0140VIVI00<0000007moO`1oOgl03P1oOgl00`000000IVIV06IVIP0@06IVIP03
0000001<C4`0C4a<05/0C4a<0P00000^06IVIP030000001oOgl0Ogmo01L0Ogmo203oool100000040
oooo000G0?ooo`030000003oool0oooo00@0oooo6`1oOgl00`000000VIVI09VIV@0[09VIV@030000
002c/k<0/k>c0300/k>c2@00000T0;>c/`030000002IVIT0VIVI0100VIVI00<0000007moO`1oOgl0
3P1oOgl00`000000IVIV06IVIP0@06IVIP030000001<C4`0C4a<0240C4a<2P00000b04a<C0030000
001VIVH0IVIV02/0IVIV00<0000007moO`1oOgl05`1oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103ooolJ07moO`030000002IVIT0VIVI02/0VIVI00<000000;>c/`2c/k<09`2c
/k<:000000T0c<c<1000000Q0;>c/`030000002IVIT0VIVI00l0VIVI00<0000007moO`1oOgl03P1o
Ogl00`000000IVIV06IVIP0?06IVIP030000001<C4`0C4a<01h0C4a<1000000:03<c<`X00000:@1<
C4`00`000000IVIV06IVIP0[06IVIP030000001oOgl0Ogmo01H0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo6@1oOgl00`000000VIVI09VIV@0[09VIV@030000002c/k<0
/k>c02D0/k>c0`00000G0<c<c0@000007P2c/k<00`000000VIVI09VIV@0>09VIV@030000001oOgl0
Ogmo00h0Ogmo00<0000006IVIP1VIVH03P1VIVH00`000000C4a<04a<C00K04a<C0@00000600c<c<3
000002L0C4a<00<0000006IVIP1VIVH0:`1VIVH00`000000Ogmo07moO`0E07moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?oooaP0Ogmo00<0000009VIV@2IVIT0:P2IVIT20000
02H0/k>c0P00000N0<c<c0@000006P2c/k<00`000000VIVI09VIV@0?09VIV@030000001oOgl0Ogmo
00`0Ogmo00<0000006IVIP1VIVH03P1VIVH00`000000C4a<04a<C00H04a<C0@000007`0c<c<20000
02H0C4a<0P00000/06IVIP030000001oOgl0Ogmo01@0Ogmo203oool100000040oooo000G0?ooo`03
0000003oool0oooo00@0oooo601oOgl00`000000VIVI09VIV@0Y09VIV@030000002c/k<0/k>c02<0
/k>c0`00000T0<c<c0<00000602c/k<00`000000VIVI09VIV@0>09VIV@030000001oOgl0Ogmo00`0
Ogmo00<0000006IVIP1VIVH03P1VIVH00`000000C4a<04a<C00E04a<C0<000009@0c<c<3000002D0
C4a<00<0000006IVIP1VIVH0:@1VIVH00`000000Ogmo07moO`0D07moO`P0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?oooaL0Ogmo00<0000009VIV@2IVIT0:@2IVIT00`000000/k>c
0;>c/`0Q0;>c/`<00000:P3<c<`00`000000/k>c0;>c/`0F0;>c/`030000002IVIT0VIVI00d0VIVI
00<0000007moO`1oOgl0301oOgl00`000000IVIV06IVIP0=06IVIP030000001<C4`0C4a<01H0C4a<
00<0000003<c<`0c<c<0:00c<c<3000002<0C4a<00<0000006IVIP1VIVH0:@1VIVH00`000000Ogmo
07moO`0C07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooaH0Ogmo00<0
000009VIV@2IVIT0:@2IVIT00`000000/k>c0;>c/`0O0;>c/`<00000;P3<c<`00`000000/k>c0;>c
/`0E0;>c/`030000002IVIT0VIVI00d0VIVI00<0000007moO`1oOgl0301oOgl00`000000IVIV06IV
IP0=06IVIP030000001<C4`0C4a<01D0C4a<00<0000003<c<`0c<c<0;00c<c<200000280C4a<00<0
000006IVIP1VIVH0:@1VIVH00`000000Ogmo07moO`0B07moO`P0oooo0@0000010?ooo`005`3oool0
0`000000oooo0?ooo`040?oooaH0Ogmo00<0000009VIV@2IVIT0:02IVIT00`000000/k>c0;>c/`0N
0;>c/`800000<P3<c<`00`000000/k>c0;>c/`0E0;>c/`030000002IVIT0VIVI00`0VIVI00<00000
07moO`1oOgl0301oOgl00`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<01D0C4a<00<00000
03<c<`0c<c<0;`0c<c<200000240C4a<00<0000006IVIP1VIVH0:01VIVH00`000000Ogmo07moO`0B
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooaD0Ogmo00<0000009VI
V@2IVIT0:02IVIT00`000000/k>c0;>c/`0N0;>c/`030000003<c<`0c<c<03<0c<c<00<000000;>c
/`2c/k<0502c/k<00`000000VIVI09VIV@0<09VIV@030000001oOgl0Ogmo00`0Ogmo00<0000006IV
IP1VIVH0301VIVH00`000000C4a<04a<C00D04a<C0030000000c<c<0<c<c0380<c<c0P00000P04a<
C0030000001VIVH0IVIV02P0IVIV00<0000007moO`1oOgl04@1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103ooolE07moO`030000002IVIT0VIVI02P0VIVI00<000000;>c/`2c
/k<0702c/k<2000003L0c<c<0P00000D0;>c/`030000002IVIT0VIVI00`0VIVI00<0000007moO`1o
Ogl02`1oOgl00`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<01<0C4a<0P00000g03<c<`03
0000001<C4`0C4a<01d0C4a<00<0000006IVIP1VIVH0:01VIVH00`000000Ogmo07moO`0A07moO`P0
oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooa@0Ogmo00<0000009VIV@2IVIT0
:02IVIT00`000000/k>c0;>c/`0L0;>c/`030000003<c<`0c<c<03T0c<c<00<000000;>c/`2c/k<0
4P2c/k<00`000000VIVI09VIV@0<09VIV@030000001oOgl0Ogmo00X0Ogmo00<0000006IVIP1VIVH0
301VIVH00`000000C4a<04a<C00B04a<C0030000000c<c<0<c<c03P0<c<c00<0000004a<C01<C4`0
7@1<C4`00`000000IVIV06IVIP0X06IVIP030000001oOgl0Ogmo0100Ogmo203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0oooo4`1oOgl00`000000VIVI09VIV@0X09VIV@030000002c
/k<0/k>c01`0/k>c00<000000<c<c03<c<`0>`3<c<`00`000000/k>c0;>c/`0A0;>c/`030000002I
VIT0VIVI00`0VIVI00<0000007moO`1oOgl02P1oOgl00`000000IVIV06IVIP0<06IVIP030000001<
C4`0C4a<0140C4a<00<0000003<c<`0c<c<0>P0c<c<2000001h0C4a<00<0000006IVIP1VIVH0:01V
IVH00`000000Ogmo07moO`0?07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`04
0?oooa<0Ogmo00<0000009VIV@2IVIT09`2IVIT00`000000/k>c0;>c/`0K0;>c/`800000?`3<c<`0
0`000000/k>c0;>c/`0A0;>c/`030000002IVIT0VIVI00/0VIVI00<0000007moO`1oOgl02P1oOgl0
0`000000IVIV06IVIP0;06IVIP030000001<C4`0C4a<0140C4a<00<0000003<c<`0c<c<0?@0c<c<0
0`000000C4a<04a<C00L04a<C0030000001VIVH0IVIV02L0IVIV00<0000007moO`1oOgl03`1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolB07moO`030000002IVIT0VIVI
02L0VIVI00<000000;>c/`2c/k<06`2c/k<00`000000c<c<0<c<c0100<c<c0030000002c/k<0/k>c
0100/k>c00<0000009VIV@2IVIT02`2IVIT00`000000Ogmo07moO`0:07moO`030000001VIVH0IVIV
00/0IVIV00<0000004a<C01<C4`0401<C4`00`000000<c<c03<c<`0o03<c<`8000007@1<C4`00`00
0000IVIV06IVIP0W06IVIP030000001oOgl0Ogmo00h0Ogmo203oool100000040oooo000G0?ooo`03
0000003oool0oooo00@0oooo4P1oOgl00`000000VIVI09VIV@0W09VIV@030000002c/k<0/k>c01X0
/k>c00<000000<c<c03<c<`0@P3<c<`00`000000/k>c0;>c/`0?0;>c/`030000002IVIT0VIVI00/0
VIVI00<0000007moO`1oOgl02P1oOgl00`000000IVIV06IVIP0;06IVIP030000001<C4`0C4a<00l0
C4a<00<0000003<c<`0c<c<0@P0c<c<00`000000C4a<04a<C00J04a<C0030000001VIVH0IVIV02L0
IVIV00<0000007moO`1oOgl03P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103ooolA07moO`030000002IVIT0VIVI02L0VIVI00<000000;>c/`2c/k<06@2c/k<2000004H0c<c<
00<000000;>c/`2c/k<03`2c/k<00`000000VIVI09VIV@0:09VIV@030000001oOgl0Ogmo00X0Ogmo
00<0000006IVIP1VIVH02P1VIVH00`000000C4a<04a<C00?04a<C0030000000c<c<0<c<c04@0<c<c
0P00000K04a<C0030000001VIVH0IVIV02L0IVIV00<0000007moO`1oOgl03@1oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103oool@07moO`030000002IVIT0VIVI02L0VIVI00<0
00000;>c/`2c/k<06@2c/k<00`000000c<c<0<c<c0170<c<c08000003`2c/k<00`000000VIVI09VI
V@0:09VIV@030000001oOgl0Ogmo00X0Ogmo00<0000006IVIP1VIVH02P1VIVH00`000000C4a<04a<
C00=04a<C0800000B@0c<c<00`000000C4a<04a<C00I04a<C0030000001VIVH0IVIV02H0IVIV00<0
000007moO`1oOgl03@1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool@
07moO`030000002IVIT0VIVI02H0VIVI00<000000;>c/`2c/k<06@2c/k<00`000000c<c<0<c<c01:
0<c<c0030000002c/k<0/k>c00`0/k>c00<0000009VIV@2IVIT02P2IVIT00`000000Ogmo07moO`09
07moO`030000001VIVH0IVIV00X0IVIV00<0000004a<C01<C4`03@1<C4`00`000000<c<c03<c<`1:
03<c<`030000001<C4`0C4a<01T0C4a<00<0000006IVIP1VIVH09P1VIVH00`000000Ogmo07moO`0<
07moO`P0oooo0@0000010?ooo`005`3oool2000000D0oooo3`1oOgl00`000000VIVI09VIV@0V09VI
V@030000002c/k<0/k>c01P0/k>c0P00000[0<c<c0D000007P3<c<`00`000000/k>c0;>c/`0<0;>c
/`030000002IVIT0VIVI00X0VIVI00<0000007moO`1oOgl0201oOgl00`000000IVIV06IVIP0:06IV
IP030000001<C4`0C4a<00`0C4a<00<0000003<c<`0c<c<0700c<c<5000002/0<c<c0P00000J04a<
C0030000001VIVH0IVIV02D0IVIV00<0000007moO`1oOgl0301oOgl70?ooo`8000000@3oool001L0
oooo00<000000?ooo`3oool0103oool?07moO`030000002IVIT0VIVI02H0VIVI00<000000;>c/`2c
/k<05`2c/k<00`000000c<c<0<c<c00S0<c<c0P000001@3Vi^H4000001/0c<c<00<000000;>c/`2c
/k<02`2c/k<00`000000VIVI09VIV@0:09VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1V
IVH02P1VIVH00`000000C4a<04a<C00;04a<C0030000000c<c<0<c<c01T0<c<c1000000501TI6@P0
00009@0c<c<00`000000C4a<04a<C00G04a<C0030000001VIVH0IVIV02H0IVIV00<0000007moO`1o
Ogl02`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool>07moO`030000
002IVIT0VIVI02H0VIVI00<000000;>c/`2c/k<05`2c/k<00`000000c<c<0<c<c00N0<c<c0H00000
4@3Vi^H4000001L0c<c<00<000000;>c/`2c/k<0302c/k<00`000000VIVI09VIV@0909VIV@030000
001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH02@1VIVH00`000000C4a<04a<C00;04a<C0030000
000c<c<0<c<c01H0<c<c1000000A01TI6@H000007`0c<c<00`000000C4a<04a<C00H04a<C0030000
001VIVH0IVIV02D0IVIV00<0000007moO`1oOgl02`1oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103oool>07moO`030000002IVIT0VIVI02D0VIVI00<000000;>c/`2c/k<05`2c
/k<00`000000c<c<0<c<c00L0<c<c0<000006`3Vi^H2000001H0c<c<00<000000;>c/`2c/k<02`2c
/k<00`000000VIVI09VIV@0909VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH02@1V
IVH00`000000C4a<04a<C00;04a<C0030000000c<c<0<c<c01@0<c<c0P00000K01TI6@<000007@0c
<c<00`000000C4a<04a<C00H04a<C0030000001VIVH0IVIV02D0IVIV00<0000007moO`1oOgl02P1o
Ogl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool>07moO`030000002IVIT0
VIVI02@0VIVI00<000000;>c/`2c/k<05`2c/k<00`000000c<c<0<c<c00K0<c<c0800000803Vi^H2
000001@0c<c<00<000000;>c/`2c/k<02`2c/k<00`000000VIVI09VIV@0909VIV@030000001oOgl0
Ogmo00P0Ogmo00<0000006IVIP1VIVH02@1VIVH00`000000C4a<04a<C00;04a<C0030000000c<c<0
<c<c0180<c<c0P00000P01TI6@800000700c<c<00`000000C4a<04a<C00H04a<C0030000001VIVH0
IVIV02@0IVIV00<0000007moO`1oOgl02P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?oo
o`3oool0103oool=07moO`030000002IVIT0VIVI02D0VIVI00<000000;>c/`2c/k<05P2c/k<00`00
0000c<c<0<c<c00J0<c<c0800000903Vi^H2000001<0c<c<00<000000;>c/`2c/k<02P2c/k<00`00
0000VIVI09VIV@0909VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH02@1VIVH00`00
0000C4a<04a<C00:04a<C0030000000c<c<0<c<c0140<c<c0P00000T01TI6@8000006`0c<c<00`00
0000C4a<04a<C00G04a<C0030000001VIVH0IVIV02D0IVIV00<0000007moO`1oOgl02@1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool=07moO`030000002IVIT0VIVI02@0
VIVI00<000000;>c/`2c/k<05`2c/k<00`000000c<c<0<c<c00H0<c<c0800000:03Vi^H00`000000
c<c<0<c<c00@0<c<c0030000002c/k<0/k>c00/0/k>c00<0000009VIV@2IVIT0202IVIT00`000000
Ogmo07moO`0807moO`030000001VIVH0IVIV00P0IVIV00<0000004a<C01<C4`02`1<C4`00`000000
<c<c03<c<`0?03<c<`800000:00I6AT00`000000<c<c03<c<`0H03<c<`030000001<C4`0C4a<01P0
C4a<00<0000006IVIP1VIVH0901VIVH00`000000Ogmo07moO`0907moO`P0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooo``0Ogmo00<0000009VIV@2IVIT0902IVIT00`000000/k>c
0;>c/`0G0;>c/`030000003<c<`0c<c<01L0c<c<0P00000[0>KViP030000003<c<`0c<c<0100c<c<
00<000000;>c/`2c/k<02P2c/k<00`000000VIVI09VIV@0809VIV@030000001oOgl0Ogmo00P0Ogmo
00<0000006IVIP1VIVH0201VIVH00`000000C4a<04a<C00:04a<C0030000000c<c<0<c<c00l0<c<c
00<0000001TI6@0I6AT0:@0I6AT2000001T0<c<c00<0000004a<C01<C4`05`1<C4`00`000000IVIV
06IVIP0T06IVIP030000001oOgl0Ogmo00T0Ogmo203oool100000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo301oOgl00`000000VIVI09VIV@0S09VIV@030000002c/k<0/k>c01L0/k>c00<0
00000<c<c03<c<`05P3<c<`2000002h0i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c
/`0:0;>c/`030000002IVIT0VIVI00P0VIVI00<0000007moO`1oOgl0201oOgl00`000000IVIV06IV
IP0806IVIP030000001<C4`0C4a<00X0C4a<00<0000003<c<`0c<c<03P0c<c<00`0000006ATI01TI
6@0/01TI6@800000600c<c<00`000000C4a<04a<C00G04a<C0030000001VIVH0IVIV02@0IVIV00<0
000007moO`1oOgl0201oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool<
07moO`030000002IVIT0VIVI02<0VIVI00<000000;>c/`2c/k<05P2c/k<00`000000c<c<0<c<c00E
0<c<c0800000<@3Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c/k<0/k>c00T0/k>c00<00000
09VIV@2IVIT0202IVIT00`000000Ogmo07moO`0807moO`030000001VIVH0IVIV00P0IVIV00<00000
04a<C01<C4`02@1<C4`00`000000<c<c03<c<`0>03<c<`030000000I6AT06ATI02l06ATI0P00000G
03<c<`030000001<C4`0C4a<01H0C4a<00<0000006IVIP1VIVH0901VIVH00`000000Ogmo07moO`08
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`/0Ogmo00<0000009VI
V@2IVIT08`2IVIT00`000000/k>c0;>c/`0G0;>c/`030000003<c<`0c<c<01@0c<c<00<000000>KV
iP3Vi^H0<P3Vi^H00`000000c<c<0<c<c00>0<c<c0030000002c/k<0/k>c00T0/k>c00<0000009VI
V@2IVIT0202IVIT00`000000Ogmo07moO`0807moO`030000001VIVH0IVIV00P0IVIV00<0000004a<
C01<C4`02@1<C4`00`000000<c<c03<c<`0=03<c<`030000000I6AT06ATI03806ATI00<0000003<c
<`0c<c<05@0c<c<00`000000C4a<04a<C00F04a<C0030000001VIVH0IVIV02@0IVIV00<0000007mo
O`1oOgl01`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool;07moO`03
0000002IVIT0VIVI02<0VIVI00<000000;>c/`2c/k<05P2c/k<00`000000c<c<0<c<c00D0<c<c003
0000003Vi^H0i^KV03@0i^KV00<000000<c<c03<c<`03@3<c<`00`000000/k>c0;>c/`0:0;>c/`03
0000002IVIT0VIVI00L0VIVI00<0000007moO`1oOgl01`1oOgl00`000000IVIV06IVIP0806IVIP03
0000001<C4`0C4a<00T0C4a<00<0000003<c<`0c<c<03@0c<c<00`0000006ATI01TI6@0d01TI6@03
0000000c<c<0<c<c01@0<c<c00<0000004a<C01<C4`05`1<C4`00`000000IVIV06IVIP0S06IVIP03
0000001oOgl0Ogmo00L0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo
2`1oOgl00`000000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01H0/k>c00<000000<c<c03<c<`0
503<c<`00`000000i^KV0>KViP0f0>KViP030000003<c<`0c<c<00d0c<c<00<000000;>c/`2c/k<0
2@2c/k<00`000000VIVI09VIV@0809VIV@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH0
201VIVH00`000000C4a<04a<C00904a<C0030000000c<c<0<c<c00`0<c<c00<0000001TI6@0I6AT0
=P0I6AT00`000000<c<c03<c<`0D03<c<`030000001<C4`0C4a<01H0C4a<00<0000006IVIP1VIVH0
8`1VIVH00`000000Ogmo07moO`0707moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooo`X0Ogmo00<0000009VIV@2IVIT08`2IVIT00`000000/k>c0;>c/`0E0;>c/`030000003<
c<`0c<c<01@0c<c<00<000000>KViP3Vi^H0>03Vi^H00`000000c<c<0<c<c00<0<c<c0030000002c
/k<0/k>c00T0/k>c00<0000009VIV@2IVIT0202IVIT00`000000Ogmo07moO`0607moO`030000001V
IVH0IVIV00P0IVIV00<0000004a<C01<C4`02@1<C4`00`000000<c<c03<c<`0<03<c<`030000000I
6AT06ATI03L06ATI00<0000003<c<`0c<c<0500c<c<00`000000C4a<04a<C00F04a<C0030000001V
IVH0IVIV02<0IVIV00<0000007moO`1oOgl01P1oOgl80?ooo`4000000@3oool001L0oooo00<00000
0?ooo`3oool0103oool:07moO`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<05P2c/k<0
0`000000c<c<0<c<c00C0<c<c0030000003Vi^H0i^KV03X0i^KV00<000000<c<c03<c<`0303<c<`0
0`000000/k>c0;>c/`080;>c/`030000002IVIT0VIVI00P0VIVI00<0000007moO`1oOgl01P1oOgl0
0`000000IVIV06IVIP0806IVIP030000001<C4`0C4a<00P0C4a<00<0000003<c<`0c<c<0300c<c<0
0`0000006ATI01TI6@0i01TI6@030000000c<c<0<c<c01@0<c<c00<0000004a<C01<C4`05@1<C4`0
0`000000IVIV06IVIP0S06IVIP030000001oOgl0Ogmo00H0Ogmo203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo2@1oOgl00`000000VIVI09VIV@0S09VIV@030000002c/k<0/k>c
01D0/k>c00<000000<c<c03<c<`04`3<c<`00`000000i^KV0>KViP0l0>KViP030000003<c<`0c<c<
00/0c<c<00<000000;>c/`2c/k<0202c/k<00`000000VIVI09VIV@0809VIV@030000001oOgl0Ogmo
00H0Ogmo00<0000006IVIP1VIVH0201VIVH00`000000C4a<04a<C00804a<C0030000000c<c<0<c<c
00/0<c<c00<0000001TI6@0I6AT0>`0I6AT2000001D0<c<c00<0000004a<C01<C4`05@1<C4`00`00
0000IVIV06IVIP0R06IVIP030000001oOgl0Ogmo00H0Ogmo203oool100000040oooo000:0?ooo`03
0?oDV`000000000000<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`T0
Ogmo00<0000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0E0;>c/`030000003<c<`0c<c<01<0
c<c<00<000000>KViP3Vi^H0?P3Vi^H00`000000c<c<0<c<c00;0<c<c0030000002c/k<0/k>c00L0
/k>c00<0000009VIV@2IVIT0202IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00P0
IVIV00<0000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`0;03<c<`030000000I6AT06ATI03h0
6ATI00<0000003<c<`0c<c<04`0c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0IVIV02<0
IVIV00<0000007moO`1oOgl01@1oOgl80?ooo`4000000@3oool000d0oooo00<0^W9b0;[Zo`3oool0
1`3oool00`000000oooo0?ooo`040?ooo`T0Ogmo00<0000009VIV@2IVIT08P2IVIT00`000000/k>c
0;>c/`0D0;>c/`030000003<c<`0c<c<01<0c<c<00<000000>KViP3Vi^H0@03Vi^H00`000000c<c<
0<c<c00:0<c<c0030000002c/k<0/k>c00P0/k>c00<0000009VIV@2IVIT01`2IVIT00`000000Ogmo
07moO`0607moO`030000001VIVH0IVIV00L0IVIV00<0000004a<C01<C4`0201<C4`00`000000<c<c
03<c<`0:03<c<`030000000I6AT06ATI04006ATI00<0000003<c<`0c<c<04P0c<c<00`000000C4a<
04a<C00E04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl01@1oOgl80?ooo`400000
0@3oool000d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`040?ooo`P0Ogmo00<0
000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0E0;>c/`030000003<c<`0c<c<0180c<c<00<0
00000>KViP3Vi^H0@P3Vi^H00`000000c<c<0<c<c00:0<c<c0030000002c/k<0/k>c00L0/k>c00<0
000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00L0IVIV00<0
000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`0:03<c<`030000000I6AT06ATI04806ATI00<0
000003<c<`0c<c<04P0c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0IVIV02<0IVIV00<0
000007moO`1oOgl0101oOgl80?ooo`4000000@3oool000d0oooo00<0^W9b0;[Zo`3oool01`3oool3
000000@0oooo201oOgl00`000000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01@0/k>c00<00000
0<c<c03<c<`04P3<c<`00`000000i^KV0>KViP0M0>KViP`000006`3Vi^H00`000000c<c<0<c<c009
0<c<c0030000002c/k<0/k>c00L0/k>c00<0000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`06
07moO`030000001VIVH0IVIV00L0IVIV00<0000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`09
03<c<`030000000I6AT06ATI01T06ATI3000000O01TI6@030000000c<c<0<c<c0180<c<c00<00000
04a<C01<C4`0501<C4`00`000000IVIV06IVIP0R06IVIP030000001oOgl0Ogmo00@0Ogmo1P3oool3
00000040oooo00000`3oool0^W800000000400000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Z
o`3oool01`3oool00`000000oooo0?ooo`040?ooo`P0Ogmo00<0000009VIV@2IVIT08P2IVIT00`00
0000/k>c0;>c/`0D0;>c/`030000003<c<`0c<c<0140c<c<00<000000>KViP3Vi^H0703Vi^H20000
00`0oooo0P00000I0>KViP030000003<c<`0c<c<00T0c<c<00<000000;>c/`2c/k<01`2c/k<00`00
0000VIVI09VIV@0709VIV@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01`1VIVH00`00
0000C4a<04a<C00704a<C0030000000c<c<0<c<c00T0<c<c00<0000001TI6@0I6AT05`0I6AT@0000
01h06ATI00<0000003<c<`0c<c<04@0c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0IVIV
0280IVIV00<0000007moO`1oOgl0101oOgl80?ooo`4000000@3oool000d0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`040?ooo`P0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000
/k>c0;>c/`0D0;>c/`030000003<c<`0c<c<0180c<c<00<000000>KViP3Vi^H06P3Vi^H200000100
oooo00<000000>KViP3Vi^H05`3Vi^H00`000000c<c<0<c<c0080<c<c0030000002c/k<0/k>c00L0
/k>c00<0000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00L0
IVIV00<0000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`0803<c<`030000000I6AT06ATI01L0
6ATI4`00000L01TI6@030000000c<c<0<c<c0180<c<c00<0000004a<C01<C4`0501<C4`00`000000
IVIV06IVIP0Q06IVIP030000001oOgl0Ogmo00@0Ogmo203oool100000040oooo000=0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool0103oool707moO`030000002IVIT0VIVI0280VIVI
00<000000;>c/`2c/k<0502c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV01T0i^KV
0P00000C0?ooo`030000003Vi^H0i^KV01H0i^KV00<000000<c<c03<c<`02@3<c<`00`000000/k>c
0;>c/`060;>c/`030000002IVIT0VIVI00L0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV
06IVIP0706IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<02@0c<c<00`0000006ATI
01TI6@0E01TI6AL000006`0I6AT00`000000<c<c03<c<`0A03<c<`030000001<C4`0C4a<01@0C4a<
00<0000006IVIP1VIVH08P1VIVH00`000000Ogmo07moO`0307moO`P0oooo0@0000010?ooo`002P3o
ool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool0103oool707moO`030000
002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<0502c/k<00`000000c<c<0<c<c00A0<c<c0030000
003Vi^H0i^KV01P0i^KV00<000000?ooo`3oool0503oool2000001H0i^KV00<000000<c<c03<c<`0
2@3<c<`00`000000/k>c0;>c/`060;>c/`030000002IVIT0VIVI00L0VIVI00<0000007moO`1oOgl0
1P1oOgl00`000000IVIV06IVIP0706IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<0
2@0c<c<00`0000006ATI01TI6@0D01TI6AT000006P0I6AT00`000000<c<c03<c<`0A03<c<`030000
001<C4`0C4a<01@0C4a<00<0000006IVIP1VIVH08P1VIVH00`000000Ogmo07moO`0307moO`P0oooo
0@0000010?ooo`00303oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo00@0oooo1`1o
Ogl00`000000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`04@3<
c<`00`000000i^KV0>KViP0H0>KViP030000003oool0oooo01L0oooo00<000000>KViP3Vi^H04`3V
i^H00`000000c<c<0<c<c0090<c<c0030000002c/k<0/k>c00L0/k>c00<0000009VIV@2IVIT01P2I
VIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01`1<
C4`00`000000<c<c03<c<`0903<c<`030000000I6AT06ATI01<06ATI6`00000J01TI6@030000000c
<c<0<c<c0140<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0R06IVIP030000001o
Ogl0Ogmo00<0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo1`1oOgl0
0`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01@0/k>c00<000000<c<c03<c<`04@3<c<`0
0`000000i^KV0>KViP0G0>KViP030000003oool0oooo01T0oooo00<000000>KViP3Vi^H04`3Vi^H0
0`000000c<c<0<c<c0080<c<c0030000002c/k<0/k>c00L0/k>c00<0000009VIV@2IVIT01P2IVIT0
0`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01`1<C4`0
0`000000<c<c03<c<`0803<c<`030000000I6AT06ATI01806ATI7P00000I01TI6@030000000c<c<0
<c<c0140<c<c00<0000004a<C01<C4`0501<C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0
Ogmo00<0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo1P1oOgl00`00
0000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01@0/k>c00<000000<c<c03<c<`0403<c<`00`00
0000i^KV0>KViP0G0>KViP030000003oool0oooo01/0oooo0P00000C0>KViP030000003<c<`0c<c<
00P0c<c<00<000000;>c/`2c/k<01`2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo
00H0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00704a<C0030000000c<c<0<c<c
00P0<c<c00<0000001TI6@0I6AT04@0I6ATP000001T06ATI00<0000003<c<`0c<c<0400c<c<00`00
0000C4a<04a<C00D04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl00P1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0280
VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV01H0
i^KV00<000000?ooo`3oool07P3oool00`000000i^KV0>KViP0@0>KViP030000003<c<`0c<c<00P0
c<c<00<000000;>c/`2c/k<01`2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00H0
Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00704a<C0030000000c<c<0<c<c00P0
<c<c00<0000001TI6@0I6AT03`0I6ATS000001P06ATI00<0000003<c<`0c<c<04@0c<c<00`000000
C4a<04a<C00C04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl00P1oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0240VIVI
00<000000;>c/`2c/k<0502c/k<00`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV01H0i^KV
00<000000?ooo`3oool0803oool00`000000i^KV0>KViP0@0>KViP030000003<c<`0c<c<00P0c<c<
00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00H0Ogmo
00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00P0<c<c
00<0000001TI6@0I6AT03`0I6ATU000001P06ATI00<0000003<c<`0c<c<0400c<c<00`000000C4a<
04a<C00D04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`1oOgl00P1oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0240VIVI00<0
00000;>c/`2c/k<0502c/k<00`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV01D0i^KV00<0
00000?ooo`3oool08P3oool200000100i^KV00<000000<c<c03<c<`0203<c<`00`000000/k>c0;>c
/`060;>c/`030000002IVIT0VIVI00H0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IV
IP0606IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI
6@0=01TI6BP000005`0I6AT00`000000<c<c03<c<`0@03<c<`030000001<C4`0C4a<01@0C4a<00<0
000006IVIP1VIVH08@1VIVH00`000000Ogmo07moO`0207moO`P0oooo0@0000010?ooo`005`3oool0
0`000000oooo0?ooo`040?ooo`D0Ogmo00<0000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0C
0;>c/`030000003<c<`0c<c<0100c<c<00<000000>KViP3Vi^H05@3Vi^H00`000000oooo0?ooo`0U
0?ooo`030000003Vi^H0i^KV00d0i^KV00<000000<c<c03<c<`0203<c<`00`000000/k>c0;>c/`06
0;>c/`030000002IVIT0VIVI00H0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP06
06IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0<
01TI6BX000005`0I6AT00`000000<c<c03<c<`0@03<c<`030000001<C4`0C4a<01<0C4a<00<00000
06IVIP1VIVH08P1VIVH010000000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo00<00000
0?ooo`3oool0103oool507moO`030000002IVIT0VIVI0240VIVI00<000000;>c/`2c/k<0502c/k<0
0`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV01@0i^KV00<000000?ooo`3oool09`3oool0
0`000000i^KV0>KViP0<0>KViP030000003<c<`0c<c<00P0c<c<00<000000;>c/`2c/k<01P2c/k<0
0`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01P1VIVH0
0`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT02`0I6AT/
000001H06ATI00<0000003<c<`0c<c<0400c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0
IVIV0240IVIV00@0000007moO`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000003oool0
oooo00@0oooo1@1oOgl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<00000
0<c<c03<c<`0403<c<`00`000000i^KV0>KViP0D0>KViP030000003oool0oooo02P0oooo00<00000
0>KViP3Vi^H03@3Vi^H00`000000c<c<0<c<c0070<c<c0030000002c/k<0/k>c00L0/k>c00<00000
09VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00D0IVIV00<00000
04a<C01<C4`01`1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00`06ATI;@00000F
01TI6@030000000c<c<0<c<c0100<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0Q
06IVIP040000001oOgl0Ogmo07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`04
0?ooo`D0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0
c<c<0100c<c<00<000000>KViP3Vi^H04`3Vi^H00`000000oooo0?ooo`0Z0?ooo`030000003Vi^H0
i^KV00`0i^KV00<000000<c<c03<c<`01`3<c<`00`000000/k>c0;>c/`070;>c/`030000002IVIT0
VIVI00D0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP0506IVIP030000001<C4`0
C4a<00L0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0;01TI6Bl000005@0I6AT0
0`000000<c<c03<c<`0@03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH0
10000000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool4
07moO`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00?
0<c<c0030000003Vi^H0i^KV01<0i^KV00<000000?ooo`3oool0;03oool00`000000i^KV0>KViP0;
0>KViP030000003<c<`0c<c<00P0c<c<00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@05
09VIV@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01@1VIVH00`000000C4a<04a<C006
04a<C0030000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT02`0I6AT`000001@06ATI00<00000
03<c<`0c<c<0400c<c<00`000000C4a<04a<C00C04a<C0030000001VIVH0IVIV0280IVIV00<00000
07moO`1oOgl0203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo101oOgl00`00
0000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`0403<c<`00`00
0000i^KV0>KViP0B0>KViP030000003oool0oooo02d0oooo00<000000>KViP3Vi^H0303Vi^H00`00
0000c<c<0<c<c0070<c<c0030000002c/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01@2IVIT00`00
0000Ogmo07moO`0607moO`030000001VIVH0IVIV00D0IVIV00<0000004a<C01<C4`01P1<C4`00`00
0000<c<c03<c<`0703<c<`030000000I6AT06ATI00/06ATI<P00000D01TI6@030000000c<c<0<c<c
0100<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0Ogmo
00P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`@0Ogmo00<0000009VIV@2I
VIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<0100c<c<00<000000>KViP3V
i^H04@3Vi^H00`000000oooo0?ooo`0_0?ooo`030000003Vi^H0i^KV00/0i^KV00<000000<c<c03<
c<`01`3<c<`00`000000/k>c0;>c/`060;>c/`030000002IVIT0VIVI00D0VIVI00<0000007moO`1o
Ogl01P1oOgl00`000000IVIV06IVIP0506IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c
<c<01`0c<c<00`0000006ATI01TI6@0;01TI6C<000004`0I6AT00`000000<c<c03<c<`0@03<c<`03
0000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH00`000000Ogmo07moO`080?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oool407moO`030000002IVIT0VIVI0240VIVI
00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV0140i^KV
00<000000?ooo`3oool0;`3oool00`000000i^KV0>KViP0;0>KViP030000003<c<`0c<c<00L0c<c<
00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0509VIV@030000001oOgl0Ogmo00H0Ogmo
00<0000006IVIP1VIVH01@1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00L0<c<c
00<0000001TI6@0I6AT02`0I6ATc000001<06ATI00<0000003<c<`0c<c<0400c<c<00`000000C4a<
04a<C00C04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`1oOgl0203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0oooo101oOgl00`000000VIVI09VIV@0Q09VIV@030000002c
/k<0/k>c01<0/k>c00<000000<c<c03<c<`0403<c<`00`000000i^KV0>KViP0@0>KViP030000003o
ool0oooo0300oooo00<000000>KViP3Vi^H02`3Vi^H00`000000c<c<0<c<c0070<c<c0030000002c
/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0607moO`030000001V
IVH0IVIV00D0IVIV00<0000004a<C01<C4`01P1<C4`00`000000<c<c03<c<`0703<c<`030000000I
6AT06ATI00/06ATI=000000B01TI6@030000000c<c<0<c<c0100<c<c00<0000004a<C01<C4`04`1<
C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0Ogmo00P0oooo0@0000010?ooo`005`3oool2
000000D0oooo101oOgl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<00000
0<c<c03<c<`0403<c<`00`000000i^KV0>KViP0@0>KViP030000003oool0oooo0340oooo00<00000
0>KViP3Vi^H02P3Vi^H00`000000c<c<0<c<c0070<c<c0030000002c/k<0/k>c00H0/k>c00<00000
09VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00D0IVIV00<00000
04a<C01<C4`01P1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00X06ATI=@00000B
01TI6@030000000c<c<0<c<c0100<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0Q
06IVIP030000001oOgl0Ogmo00L0oooo0P0000010?ooo`005`3oool00`000000oooo0?ooo`040?oo
o`@0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<
00l0c<c<00<000000>KViP3Vi^H0403Vi^H00`000000oooo0?ooo`0b0?ooo`030000003Vi^H0i^KV
00X0i^KV00<000000<c<c03<c<`01`3<c<`00`000000/k>c0;>c/`060;>c/`030000002IVIT0VIVI
00D0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP0506IVIP030000001<C4`0C4a<
00H0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6CD000004P0I6AT00`00
0000<c<c03<c<`0@03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH00`00
0000Ogmo07moO`080?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool407moO`03
0000002IVIT0VIVI0240VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00?0<c<c003
0000003Vi^H0i^KV0100i^KV00<000000?ooo`3oool0<P3oool00`000000i^KV0>KViP0:0>KViP03
0000003<c<`0c<c<00L0c<c<00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0509VIV@03
0000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01@1VIVH00`000000C4a<04a<C00604a<C003
0000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02P0I6ATe000001<06ATI00<0000003<c<`0c
<c<03`0c<c<00`000000C4a<04a<C00C04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`1o
Ogl0203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo101oOgl00`000000VIVI
09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`03`3<c<`00`000000i^KV
0>KViP0?0>KViP030000003oool0oooo03<0oooo00<000000>KViP3Vi^H02P3Vi^H00`000000c<c<
0<c<c0070<c<c0030000002c/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo
07moO`0607moO`030000001VIVH0IVIV00D0IVIV00<0000004a<C01<C4`01P1<C4`00`000000<c<c
03<c<`0703<c<`030000000I6AT06ATI00X06ATI=P00000B01TI6@030000000c<c<0<c<c00l0<c<c
00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0Ogmo00P0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`@0Ogmo00<0000009VIV@2IVIT08@2I
VIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<00l0c<c<00<000000>KViP3Vi^H03`3V
i^H00`000000oooo0?ooo`0c0?ooo`030000003Vi^H0i^KV00X0i^KV00<000000<c<c03<c<`01`3<
c<`00`000000/k>c0;>c/`060;>c/`030000002IVIT0VIVI00D0VIVI00<0000007moO`1oOgl01P1o
Ogl00`000000IVIV06IVIP0506IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<01`0c
<c<00`0000006ATI01TI6@0:01TI6CH000004P0I6AT00`000000<c<c03<c<`0?03<c<`030000001<
C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH00`000000Ogmo07moO`080?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103oool307moO`030000002IVIT0VIVI0240VIVI00<00000
0;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV00l0i^KV00<00000
0?ooo`3oool0<`3oool00`000000i^KV0>KViP0:0>KViP030000003<c<`0c<c<00L0c<c<00<00000
0;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0509VIV@030000001oOgl0Ogmo00D0Ogmo00<00000
06IVIP1VIVH01P1VIVH00`000000C4a<04a<C00504a<C0030000000c<c<0<c<c00L0<c<c00<00000
01TI6@0I6AT02P0I6ATg000001806ATI00<0000003<c<`0c<c<03`0c<c<00`000000C4a<04a<C00C
04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`1oOgl0203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo0`1oOgl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c
01<0/k>c00<000000<c<c03<c<`0403<c<`00`000000i^KV0>KViP0?0>KViP030000003oool0oooo
03@0oooo00<000000>KViP3Vi^H02P3Vi^H00`000000c<c<0<c<c0070<c<c0030000002c/k<0/k>c
00D0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0507moO`030000001VIVH0IVIV
00H0IVIV00<0000004a<C01<C4`01@1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI
00X06ATI=`00000B01TI6@030000000c<c<0<c<c0100<c<c00<0000004a<C01<C4`04`1<C4`00`00
0000IVIV06IVIP0Q06IVIP030000001oOgl0oooo00L0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooo`<0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`03
0000003<c<`0c<c<0100c<c<00<000000>KViP3Vi^H03`3Vi^H00`000000oooo0?ooo`0d0?ooo`03
0000003Vi^H0i^KV00X0i^KV00<000000<c<c03<c<`01`3<c<`00`000000/k>c0;>c/`050;>c/`03
0000002IVIT0VIVI00D0VIVI00<0000007moO`1oOgl01@1oOgl00`000000IVIV06IVIP0606IVIP03
0000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6CL0
00004P0I6AT00`000000<c<c03<c<`0@03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1V
IVH08@1VIVH00`000000Ogmo0?ooo`070?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103oool307moO`030000002IVIT0VIVI0240VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<
0<c<c00@0<c<c0030000003Vi^H0i^KV00l0i^KV00<000000?ooo`3oool0=03oool00`000000i^KV
0>KViP0:0>KViP030000003<c<`0c<c<00L0c<c<00<000000;>c/`2c/k<01@2c/k<00`000000VIVI
09VIV@0509VIV@030000001oOgl0Ogmo00D0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<
04a<C00504a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02P0I6ATg000001806ATI
00<0000003<c<`0c<c<0400c<c<00`000000C4a<04a<C00C04a<C0030000001VIVH0IVIV0240IVIV
00<0000007moO`3oool01`3oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo0`1o
Ogl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`03`3<
c<`00`000000i^KV0>KViP0@0>KViP030000003oool0oooo03@0oooo00<000000>KViP3Vi^H02P3V
i^H00`000000c<c<0<c<c0070<c<c0030000002c/k<0/k>c00D0/k>c00<0000009VIV@2IVIT01@2I
VIT00`000000Ogmo07moO`0507moO`030000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01@1<
C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00X06ATI>000000A01TI6@030000000c
<c<0<c<c0100<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0Q06IVIP030000001o
Ogl0oooo00L0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`<0Ogmo00<00000
09VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<00l0c<c<00<00000
0>KViP3Vi^H0403Vi^H00`000000oooo0?ooo`0d0?ooo`030000003Vi^H0i^KV00X0i^KV00<00000
0<c<c03<c<`01`3<c<`00`000000/k>c0;>c/`050;>c/`030000002IVIT0VIVI00D0VIVI00<00000
07moO`1oOgl01@1oOgl00`000000IVIV06IVIP0606IVIP030000001<C4`0C4a<00D0C4a<00<00000
03<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6CP000004P0I6AT00`000000<c<c03<c<`0?
03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH00`000000Ogmo0?ooo`07
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool307moO`030000002IVIT0VIVI
0240VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00?0<c<c0030000003Vi^H0i^KV
0100i^KV00<000000?ooo`3oool0=@3oool00`000000i^KV0>KViP090>KViP030000003<c<`0c<c<
00L0c<c<00<000000;>c/`2c/k<01@2c/k<00`000000VIVI09VIV@0509VIV@030000001oOgl0Ogmo
00D0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00504a<C0030000000c<c<0<c<c
00L0<c<c00<0000001TI6@0I6AT02@0I6ATi000001806ATI00<0000003<c<`0c<c<03`0c<c<00`00
0000C4a<04a<C00C04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`3oool01`3oool10000
0040oooo000G0?ooo`030000003oool0oooo00@0oooo0`1oOgl00`000000VIVI09VIV@0Q09VIV@03
0000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`03`3<c<`00`000000i^KV0>KViP0@0>KViP03
0000003oool0oooo03D0oooo00<000000>KViP3Vi^H02@3Vi^H00`000000c<c<0<c<c0070<c<c003
0000002c/k<0/k>c00D0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0507moO`03
0000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01@1<C4`00`000000<c<c03<c<`0703<c<`03
0000000I6AT06ATI00T06ATI>@00000B01TI6@030000000c<c<0<c<c00l0<c<c00<0000004a<C01<
C4`04`1<C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0oooo00L0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooo`<0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c
0;>c/`0C0;>c/`030000003<c<`0c<c<00l0c<c<00<000000>KViP3Vi^H0403Vi^H00`000000oooo
0?ooo`0e0?ooo`030000003Vi^H0i^KV00T0i^KV00<000000<c<c03<c<`01`3<c<`00`000000/k>c
0;>c/`050;>c/`030000002IVIT0VIVI00D0VIVI00<0000007moO`1oOgl01@1oOgl00`000000IVIV
06IVIP0606IVIP030000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI
01TI6@0901TI6CT000004P0I6AT00`000000<c<c03<c<`0?03<c<`030000001<C4`0C4a<01<0C4a<
00<0000006IVIP1VIVH08@1VIVH00`000000Ogmo0?ooo`070?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103oool307moO`030000002IVIT0VIVI0240VIVI00<000000;>c/`2c/k<04`2c
/k<00`000000c<c<0<c<c00?0<c<c0030000003Vi^H0i^KV0100i^KV00<000000?ooo`3oool0=03o
ool00`000000i^KV0>KViP0:0>KViP030000003<c<`0c<c<00L0c<c<00<000000;>c/`2c/k<01@2c
/k<00`000000VIVI09VIV@0509VIV@030000001oOgl0Ogmo00D0Ogmo00<0000006IVIP1VIVH01P1V
IVH00`000000C4a<04a<C00504a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02@0I
6ATh000001<06ATI00<0000003<c<`0c<c<03`0c<c<00`000000C4a<04a<C00C04a<C0030000001V
IVH0IVIV0240IVIV00<0000007moO`3oool01`3oool100000040oooo000G0?ooo`030000003oool0
oooo00@0oooo0`1oOgl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<00000
0<c<c03<c<`0403<c<`00`000000i^KV0>KViP0@0>KViP030000003oool0oooo03<0oooo00<00000
0>KViP3Vi^H02P3Vi^H00`000000c<c<0<c<c0070<c<c0030000002c/k<0/k>c00D0/k>c00<00000
09VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0507moO`030000001VIVH0IVIV00H0IVIV00<00000
04a<C01<C4`01@1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00X06ATI=P00000C
01TI6@030000000c<c<0<c<c00l0<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IVIP0R
06IVIP030000001oOgl0oooo00L0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oo
o`@0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<
00l0c<c<00<000000>KViP3Vi^H0403Vi^H00`000000oooo0?ooo`0b0?ooo`030000003Vi^H0i^KV
00X0i^KV00<000000<c<c03<c<`0203<c<`00`000000/k>c0;>c/`050;>c/`030000002IVIT0VIVI
00D0VIVI00<0000007moO`1oOgl01@1oOgl00`000000IVIV06IVIP0606IVIP030000001<C4`0C4a<
00D0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0901TI6CH000004`0I6AT00`00
0000<c<c03<c<`0?03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08@1VIVH00`00
0000Ogmo07moO`080?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool407moO`03
0000002IVIT0VIVI0240VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00?0<c<c003
0000003Vi^H0i^KV0140i^KV00<000000?ooo`3oool0<@3oool00`000000i^KV0>KViP0:0>KViP03
0000003<c<`0c<c<00L0c<c<00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0509VIV@03
0000001oOgl0Ogmo00D0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00504a<C003
0000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT02P0I6ATd000001@06ATI00<0000003<c<`0c
<c<03`0c<c<00`000000C4a<04a<C00C04a<C0030000001VIVH0IVIV0240IVIV00<0000007moO`1o
Ogl0203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo101oOgl00`000000VIVI
09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`03`3<c<`00`000000i^KV
0>KViP0B0>KViP030000003oool0oooo02l0oooo00<000000>KViP3Vi^H02`3Vi^H00`000000c<c<
0<c<c0070<c<c0030000002c/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo
07moO`0507moO`030000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01P1<C4`00`000000<c<c
03<c<`0703<c<`030000000I6AT06ATI00X06ATI<`00000E01TI6@030000000c<c<0<c<c00h0<c<c
00<0000004a<C01<C4`0501<C4`00`000000IVIV06IVIP0Q06IVIP030000001oOgl0Ogmo00P0oooo
0@0000010?ooo`005`3oool2000000D0oooo101oOgl00`000000VIVI09VIV@0Q09VIV@030000002c
/k<0/k>c01<0/k>c00<000000<c<c03<c<`0403<c<`00`000000i^KV0>KViP0B0>KViP030000003o
ool0oooo02d0oooo00<000000>KViP3Vi^H0303Vi^H00`000000c<c<0<c<c0070<c<c0030000002c
/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01@2IVIT00`000000Ogmo07moO`0507moO`030000001V
IVH0IVIV00H0IVIV00<0000004a<C01<C4`01P1<C4`00`000000<c<c03<c<`0703<c<`030000000I
6AT06ATI00/06ATI<P00000D01TI6@030000000c<c<0<c<c00l0<c<c00<0000004a<C01<C4`04`1<
C4`00`000000IVIV06IVIP0R06IVIP030000001oOgl0Ogmo00L0oooo0P0000010?ooo`005`3oool0
0`000000oooo0?ooo`040?ooo`@0Ogmo00<0000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0C
0;>c/`030000003<c<`0c<c<00l0c<c<00<000000>KViP3Vi^H04P3Vi^H00`000000oooo0?ooo`0]
0?ooo`030000003Vi^H0i^KV00`0i^KV00<000000<c<c03<c<`01`3<c<`00`000000/k>c0;>c/`06
0;>c/`030000002IVIT0VIVI00D0VIVI00<0000007moO`1oOgl01@1oOgl00`000000IVIV06IVIP06
06IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0;
01TI6C4000005@0I6AT00`000000<c<c03<c<`0?03<c<`030000001<C4`0C4a<01<0C4a<00<00000
06IVIP1VIVH08P1VIVH00`000000Ogmo07moO`080?ooo`4000000@3oool001L0oooo00<000000?oo
o`3oool0103oool407moO`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<04`2c/k<00`00
0000c<c<0<c<c00?0<c<c0030000003Vi^H0i^KV01<0i^KV00<000000?ooo`3oool0:`3oool00`00
0000i^KV0>KViP0<0>KViP030000003<c<`0c<c<00P0c<c<00<000000;>c/`2c/k<01@2c/k<00`00
0000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00D0Ogmo00<0000006IVIP1VIVH01P1VIVH00`00
0000C4a<04a<C00604a<C0030000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT02`0I6AT_0000
01H06ATI00<0000003<c<`0c<c<03P0c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0IVIV
0240IVIV00@0000007moO`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo
00@0oooo1@1oOgl00`000000VIVI09VIV@0Q09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<
c03<c<`03`3<c<`00`000000i^KV0>KViP0D0>KViP030000003oool0oooo02X0oooo00<000000>KV
iP3Vi^H0303Vi^H00`000000c<c<0<c<c0080<c<c0030000002c/k<0/k>c00D0/k>c00<0000009VI
V@2IVIT01P2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00H0IVIV00<0000004a<
C01<C4`01@1<C4`00`000000<c<c03<c<`0803<c<`030000000I6AT06ATI00/06ATI;`00000F01TI
6@030000000c<c<0<c<c00h0<c<c00<0000004a<C01<C4`0501<C4`00`000000IVIV06IVIP0Q06IV
IP040000001oOgl0Ogmo07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oo
o`D0Ogmo00<0000009VIV@2IVIT08@2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<
0100c<c<00<000000>KViP3Vi^H0503Vi^H00`000000oooo0?ooo`0X0?ooo`030000003Vi^H0i^KV
00d0i^KV00<000000<c<c03<c<`0203<c<`00`000000/k>c0;>c/`050;>c/`030000002IVIT0VIVI
00H0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP0606IVIP030000001<C4`0C4a<
00D0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0<01TI6Bd000005P0I6AT00`00
0000<c<c03<c<`0?03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH08P1VIVH01000
0000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool507mo
O`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00?0<c<
c0030000003Vi^H0i^KV01@0i^KV00<000000?ooo`3oool0:03oool00`000000i^KV0>KViP0=0>KV
iP030000003<c<`0c<c<00P0c<c<00<000000;>c/`2c/k<01@2c/k<00`000000VIVI09VIV@0609VI
V@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00504a<
C0030000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT0300I6AT/000001L06ATI00<0000003<c
<`0c<c<03`0c<c<00`000000C4a<04a<C00C04a<C0030000001VIVH0IVIV0280IVIV00@0000007mo
O`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo1@1oOgl00`00
0000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01<0/k>c00<000000<c<c03<c<`0403<c<`00`00
0000i^KV0>KViP0D0>KViP030000003oool0oooo02H0oooo00<000000>KViP3Vi^H03@3Vi^H00`00
0000c<c<0<c<c0080<c<c0030000002c/k<0/k>c00H0/k>c00<0000009VIV@2IVIT01P2IVIT00`00
0000Ogmo07moO`0607moO`030000001VIVH0IVIV00H0IVIV00<0000004a<C01<C4`01@1<C4`00`00
0000<c<c03<c<`0803<c<`030000000I6AT06ATI00d06ATI:`00000F01TI6@030000000c<c<0<c<c
00l0<c<c00<0000004a<C01<C4`0501<C4`00`000000IVIV06IVIP0R06IVIP040000001oOgl0Ogmo
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`D0Ogmo00<0000009VI
V@2IVIT08P2IVIT00`000000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<0100c<c<00<000000>KV
iP3Vi^H05@3Vi^H00`000000oooo0?ooo`0T0?ooo`030000003Vi^H0i^KV00h0i^KV00<000000<c<
c03<c<`0203<c<`00`000000/k>c0;>c/`060;>c/`030000002IVIT0VIVI00H0VIVI00<0000007mo
O`1oOgl01P1oOgl00`000000IVIV06IVIP0606IVIP030000001<C4`0C4a<00H0C4a<00<0000003<c
<`0c<c<01`0c<c<00`0000006ATI01TI6@0>01TI6BT000005`0I6AT00`000000<c<c03<c<`0?03<c
<`030000001<C4`0C4a<01@0C4a<00<0000006IVIP1VIVH08P1VIVH010000000Ogmo07moO`1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI
0240VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV
01D0i^KV00<000000?ooo`3oool08P3oool00`000000i^KV0>KViP0?0>KViP030000003<c<`0c<c<
00P0c<c<00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo
00H0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c
00P0<c<c00<0000001TI6@0I6AT03P0I6ATW000001L06ATI00<0000003<c<`0c<c<0400c<c<00`00
0000C4a<04a<C00C04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl00P1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0280
VIVI00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00@0<c<c0030000003Vi^H0i^KV01D0
i^KV00<000000?ooo`3oool08P3oool00`000000i^KV0>KViP0>0>KViP030000003<c<`0c<c<00T0
c<c<00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00H0
Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00P0
<c<c00<0000001TI6@0I6AT03`0I6ATV000001L06ATI00<0000003<c<`0c<c<03`0c<c<00`000000
C4a<04a<C00D04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl00P1oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0280VIVI
00<000000;>c/`2c/k<04`2c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV01D0i^KV
00<000000?ooo`3oool0803oool00`000000i^KV0>KViP0?0>KViP030000003<c<`0c<c<00T0c<c<
00<000000;>c/`2c/k<01P2c/k<00`000000VIVI09VIV@0609VIV@030000001oOgl0Ogmo00H0Ogmo
00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00P0<c<c
00<0000001TI6@0I6AT0400I6ATT000001L06ATI00<0000003<c<`0c<c<0400c<c<00`000000C4a<
04a<C00D04a<C0030000001VIVH0IVIV0280IVIV00<0000007moO`1oOgl00P1oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103oool607moO`030000002IVIT0VIVI0280VIVI00<0
00000;>c/`2c/k<0502c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV01D0i^KV0P00
000N0?ooo`8000004@3Vi^H00`000000c<c<0<c<c0090<c<c0030000002c/k<0/k>c00L0/k>c00<0
000009VIV@2IVIT01P2IVIT00`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00H0IVIV00<0
000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`0803<c<`030000000I6AT06ATI01006ATI8P00
000G01TI6@030000000c<c<0<c<c0140<c<c00<0000004a<C01<C4`04`1<C4`00`000000IVIV06IV
IP0S06IVIP030000001oOgl0Ogmo0080Ogmo203oool100000040oooo000G0?ooo`030000003oool0
oooo00@0oooo1`1oOgl00`000000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01@0/k>c00<00000
0<c<c03<c<`04@3<c<`00`000000i^KV0>KViP0F0>KViP030000003oool0oooo01T0oooo0P00000B
0>KViP030000003<c<`0c<c<00X0c<c<00<000000;>c/`2c/k<01`2c/k<00`000000VIVI09VIV@06
09VIV@030000001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01P1VIVH00`000000C4a<04a<C007
04a<C0030000000c<c<0<c<c00T0<c<c00<0000001TI6@0I6AT04@0I6ATN000001P06ATI00<00000
03<c<`0c<c<04@0c<c<00`000000C4a<04a<C00D04a<C0030000001VIVH0IVIV0280IVIV00<00000
07moO`1oOgl00`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool707mo
O`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<05@2c/k<00`000000c<c<0<c<c00A0<c<
c0030000003Vi^H0i^KV01H0i^KV0P00000G0?ooo`8000004`3Vi^H00`000000c<c<0<c<c00:0<c<
c0030000002c/k<0/k>c00L0/k>c00<0000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`0607mo
O`030000001VIVH0IVIV00L0IVIV00<0000004a<C01<C4`01`1<C4`00`000000<c<c03<c<`0903<c
<`030000000I6AT06ATI01806ATI6`00000H01TI6@030000000c<c<0<c<c0140<c<c00<0000004a<
C01<C4`0501<C4`00`000000IVIV06IVIP0S06IVIP030000001oOgl0Ogmo00<0Ogmo203oool10000
0040oooo000G0?ooo`030000003oool0oooo00@0oooo201oOgl00`000000VIVI09VIV@0R09VIV@03
0000002c/k<0/k>c01D0/k>c00<000000<c<c03<c<`04@3<c<`00`000000i^KV0>KViP0G0>KViP<0
00004P3oool2000001@0i^KV00<000000<c<c03<c<`02`3<c<`00`000000/k>c0;>c/`070;>c/`03
0000002IVIT0VIVI00L0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP0706IVIP03
0000001<C4`0C4a<00L0C4a<00<0000003<c<`0c<c<02P0c<c<00`0000006ATI01TI6@0C01TI6AL0
00006@0I6AT00`000000<c<c03<c<`0A03<c<`030000001<C4`0C4a<01D0C4a<00<0000006IVIP1V
IVH08P1VIVH00`000000Ogmo07moO`0407moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?ooo`P0Ogmo00<0000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0F0;>c/`030000
003<c<`0c<c<0140c<c<00<000000>KViP3Vi^H06@3Vi^H5000000/0oooo0P00000E0>KViP030000
003<c<`0c<c<00/0c<c<00<000000;>c/`2c/k<0202c/k<00`000000VIVI09VIV@0709VIV@030000
001oOgl0Ogmo00H0Ogmo00<0000006IVIP1VIVH01`1VIVH00`000000C4a<04a<C00804a<C0030000
000c<c<0<c<c00X0<c<c00<0000001TI6@0I6AT0500I6ATB000001/06ATI00<0000003<c<`0c<c<0
4@0c<c<00`000000C4a<04a<C00E04a<C0030000001VIVH0IVIV02<0IVIV00<0000007moO`1oOgl0
101oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool907moO`030000002I
VIT0VIVI0280VIVI00<000000;>c/`2c/k<05P2c/k<00`000000c<c<0<c<c00A0<c<c0030000003V
i^H0i^KV01d0i^KV1P0000030?ooo`8000005P3Vi^H00`000000c<c<0<c<c00<0<c<c0030000002c
/k<0/k>c00P0/k>c00<0000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`0607moO`030000001V
IVH0IVIV00L0IVIV00<0000004a<C01<C4`0201<C4`00`000000<c<c03<c<`0;03<c<`030000000I
6AT06ATI01D06ATI2`00000O01TI6@030000000c<c<0<c<c0140<c<c00<0000004a<C01<C4`05P1<
C4`00`000000IVIV06IVIP0R06IVIP030000001oOgl0Ogmo00D0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo2@1oOgl00`000000VIVI09VIV@0R09VIV@030000002c/k<0
/k>c01L0/k>c00<000000<c<c03<c<`04@3<c<`00`000000i^KV0>KViP0R0>KViP<000005`3Vi^H0
0`000000c<c<0<c<c00<0<c<c0030000002c/k<0/k>c00P0/k>c00<0000009VIV@2IVIT0202IVIT0
0`000000Ogmo07moO`0607moO`030000001VIVH0IVIV00L0IVIV00<0000004a<C01<C4`02@1<C4`0
0`000000<c<c03<c<`0;03<c<`030000000I6AT06ATI01H06ATI0`00000S01TI6@8000004`0c<c<0
0`000000C4a<04a<C00F04a<C0030000001VIVH0IVIV02<0IVIV00<0000007moO`1oOgl01@1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool:07moO`030000002IVIT0VIVI
0280VIVI00<000000;>c/`2c/k<05`2c/k<00`000000c<c<0<c<c00A0<c<c0030000003Vi^H0i^KV
03X0i^KV00<000000<c<c03<c<`03@3<c<`00`000000/k>c0;>c/`080;>c/`030000002IVIT0VIVI
00P0VIVI00<0000007moO`1oOgl01P1oOgl00`000000IVIV06IVIP0806IVIP030000001<C4`0C4a<
00P0C4a<00<0000003<c<`0c<c<0300c<c<00`0000006ATI01TI6@0j01TI6@030000000c<c<0<c<c
0180<c<c00<0000004a<C01<C4`05`1<C4`00`000000IVIV06IVIP0R06IVIP030000001oOgl0Ogmo
00H0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo2P1oOgl00`000000
VIVI09VIV@0R09VIV@030000002c/k<0/k>c01L0/k>c00<000000<c<c03<c<`04P3<c<`00`000000
i^KV0>KViP0h0>KViP030000003<c<`0c<c<00d0c<c<00<000000;>c/`2c/k<02@2c/k<00`000000
VIVI09VIV@0709VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH01`1VIVH00`000000
C4a<04a<C00904a<C0030000000c<c<0<c<c00`0<c<c00<0000001TI6@0I6AT0>00I6AT00`000000
<c<c03<c<`0B03<c<`030000001<C4`0C4a<01L0C4a<00<0000006IVIP1VIVH08`1VIVH00`000000
Ogmo07moO`0607moO`P0oooo0@0000010?ooo`005`3oool2000000D0oooo2`1oOgl00`000000VIVI
09VIV@0R09VIV@030000002c/k<0/k>c01L0/k>c00<000000<c<c03<c<`04P3<c<`00`000000i^KV
0>KViP0f0>KViP030000003<c<`0c<c<00h0c<c<00<000000;>c/`2c/k<02@2c/k<00`000000VIVI
09VIV@0709VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH01`1VIVH00`000000C4a<
04a<C00904a<C0030000000c<c<0<c<c00d0<c<c00<0000001TI6@0I6AT0=P0I6AT00`000000<c<c
03<c<`0C03<c<`030000001<C4`0C4a<01L0C4a<00<0000006IVIP1VIVH08P1VIVH00`000000Ogmo
07moO`0707moO`L0oooo0P0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`/0Ogmo00<0
000009VIV@2IVIT08P2IVIT00`000000/k>c0;>c/`0H0;>c/`030000003<c<`0c<c<0180c<c<00<0
00000>KViP3Vi^H0=03Vi^H00`000000c<c<0<c<c00>0<c<c0030000002c/k<0/k>c00X0/k>c00<0
000009VIV@2IVIT01`2IVIT00`000000Ogmo07moO`0807moO`030000001VIVH0IVIV00L0IVIV00<0
000004a<C01<C4`02P1<C4`00`000000<c<c03<c<`0=03<c<`030000000I6AT06ATI03@06ATI00<0
000003<c<`0c<c<04`0c<c<00`000000C4a<04a<C00G04a<C0030000001VIVH0IVIV02<0IVIV00<0
000007moO`1oOgl01`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool<
07moO`030000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<0602c/k<00`000000c<c<0<c<c00B
0<c<c0030000003Vi^H0i^KV0380i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`09
0;>c/`030000002IVIT0VIVI00P0VIVI00<0000007moO`1oOgl0201oOgl00`000000IVIV06IVIP08
06IVIP030000001<C4`0C4a<00T0C4a<00<0000003<c<`0c<c<03P0c<c<00`0000006ATI01TI6@0b
01TI6@030000000c<c<0<c<c01<0<c<c00<0000004a<C01<C4`0601<C4`00`000000IVIV06IVIP0R
06IVIP030000001oOgl0Ogmo00P0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo
00@0oooo301oOgl00`000000VIVI09VIV@0R09VIV@030000002c/k<0/k>c01T0/k>c00<000000<c<
c03<c<`04P3<c<`200000340i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0:0;>c
/`030000002IVIT0VIVI00P0VIVI00<0000007moO`1oOgl0201oOgl00`000000IVIV06IVIP0806IV
IP030000001<C4`0C4a<00X0C4a<00<0000003<c<`0c<c<03P0c<c<00`0000006ATI01TI6@0_01TI
6@8000005@0c<c<00`000000C4a<04a<C00H04a<C0030000001VIVH0IVIV02<0IVIV00<0000007mo
O`1oOgl0201oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool=07moO`03
0000002IVIT0VIVI0280VIVI00<000000;>c/`2c/k<06@2c/k<00`000000c<c<0<c<c00C0<c<c0@0
0000;03Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c00X0/k>c00<0000009VIV@2I
VIT0202IVIT00`000000Ogmo07moO`0807moO`030000001VIVH0IVIV00P0IVIV00<0000004a<C01<
C4`02P1<C4`00`000000<c<c03<c<`0?03<c<`030000000I6AT06ATI02/06ATI0`00000F03<c<`03
0000001<C4`0C4a<01P0C4a<00<0000006IVIP1VIVH08`1VIVH00`000000Ogmo07moO`0907moO`P0
oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`d0Ogmo00<0000009VIV@2IVIT0
8`2IVIT2000001X0/k>c00<000000<c<c03<c<`05P3<c<`3000002L0i^KV0P00000B0<c<c0030000
002c/k<0/k>c00/0/k>c00<0000009VIV@2IVIT0202IVIT00`000000Ogmo07moO`0807moO`030000
001VIVH0IVIV00P0IVIV00<0000004a<C01<C4`02`1<C4`00`000000<c<c03<c<`0?03<c<`800000
9`0I6AT4000001P0<c<c00<0000004a<C01<C4`0601<C4`00`000000IVIV06IVIP0T06IVIP030000
001oOgl0Ogmo00T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo3P1o
Ogl00`000000VIVI09VIV@0T09VIV@030000002c/k<0/k>c01P0/k>c00<000000<c<c03<c<`0603<
c<`400000200i^KV0`00000D0<c<c0030000002c/k<0/k>c00X0/k>c00<0000009VIV@2IVIT02@2I
VIT00`000000Ogmo07moO`0807moO`030000001VIVH0IVIV00T0IVIV00<0000004a<C01<C4`02P1<
C4`00`000000<c<c03<c<`0A03<c<`<000008@0I6AT3000001/0<c<c00<0000004a<C01<C4`0601<
C4`00`000000IVIV06IVIP0T06IVIP030000001oOgl0Ogmo00X0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo3P1oOgl00`000000VIVI09VIV@0U09VIV@030000002c/k<0
/k>c01P0/k>c00<000000<c<c03<c<`06`3<c<`<000000h0i^KV1P00000E0<c<c08000003@2c/k<0
0`000000VIVI09VIV@0909VIV@030000001oOgl0Ogmo00P0Ogmo00<0000006IVIP1VIVH02@1VIVH0
0`000000C4a<04a<C00;04a<C0800000500c<c<7000000h06ATI3000000M03<c<`030000001<C4`0
C4a<01P0C4a<00<0000006IVIP1VIVH09@1VIVH00`000000Ogmo07moO`0:07moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?ooo`l0Ogmo00<0000009VIV@2IVIT09@2IVIT20000
01T0/k>c0P00000W0<c<c0h000006@3<c<`2000000h0/k>c00<0000009VIV@2IVIT02P2IVIT00`00
0000Ogmo07moO`0807moO`030000001VIVH0IVIV00X0IVIV00<0000004a<C01<C4`0301<C4`20000
01T0<c<c3P00000W03<c<`8000006@1<C4`2000002L0IVIV00<0000007moO`1oOgl02`1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool@07moO`030000002IVIT0VIVI02H0
VIVI00<000000;>c/`2c/k<0602c/k<2000004X0c<c<0P00000?0;>c/`030000002IVIT0VIVI00X0
VIVI00<0000007moO`1oOgl02P1oOgl00`000000IVIV06IVIP0:06IVIP030000001<C4`0C4a<00d0
C4a<0P00001:03<c<`8000006P1<C4`00`000000IVIV06IVIP0V06IVIP030000001oOgl0Ogmo00`0
Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo4@1oOgl00`000000VIVI
09VIV@0V09VIV@8000006P2c/k<2000004H0c<c<0P00000@0;>c/`030000002IVIT0VIVI00/0VIVI
00<0000007moO`1oOgl02P1oOgl00`000000IVIV06IVIP0;06IVIP030000001<C4`0C4a<00h0C4a<
0P00001503<c<`<000006P1<C4`2000002P0IVIV00<0000007moO`1oOgl03@1oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103ooolB07moO`030000002IVIT0VIVI02L0VIVI00<0
00000;>c/`2c/k<06@2c/k<200000480c<c<0P00000A0;>c/`030000002IVIT0VIVI00`0VIVI00<0
000007moO`1oOgl02P1oOgl00`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<00l0C4a<00<0
000003<c<`0c<c<0@00c<c<2000001`0C4a<00<0000006IVIP1VIVH09`1VIVH00`000000Ogmo07mo
O`0>07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooa<0Ogmo0P00000X
09VIV@8000006`2c/k<3000003d0c<c<0P00000B0;>c/`030000002IVIT0VIVI00`0VIVI00<00000
07moO`1oOgl0301oOgl00`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<00l0C4a<0P00000n
03<c<`800000701<C4`2000002P0IVIV0P00000A07moO`P0oooo0@0000010?ooo`005`3oool00`00
0000oooo0?ooo`040?oooaD0Ogmo00<0000009VIV@2IVIT09`2IVIT00`000000/k>c0;>c/`0K0;>c
/`800000>@3<c<`2000001<0/k>c00<0000009VIV@2IVIT03@2IVIT00`000000Ogmo07moO`0<07mo
O`030000001VIVH0IVIV00d0IVIV00<0000004a<C01<C4`0401<C4`2000003T0<c<c0`00000M04a<
C0030000001VIVH0IVIV02L0IVIV00<0000007moO`1oOgl04@1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103ooolF07moO`030000002IVIT0VIVI02L0VIVI0P00000M0;>c/`80
0000=@3<c<`2000001@0/k>c00<0000009VIV@2IVIT03P2IVIT00`000000Ogmo07moO`0<07moO`03
0000001VIVH0IVIV00h0IVIV00<0000004a<C01<C4`04@1<C4`2000003D0<c<c0P00000N04a<C080
0000:@1VIVH00`000000Ogmo07moO`0B07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?oooaL0Ogmo0P00000Y09VIV@8000007@2c/k<4000002l0c<c<0P00000E0;>c/`030000
002IVIT0VIVI00h0VIVI00<0000007moO`1oOgl03@1oOgl00`000000IVIV06IVIP0?06IVIP030000
001<C4`0C4a<0180C4a<0P00000_03<c<`@000007P1<C4`2000002T0IVIV0P00000E07moO`P0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooaT0Ogmo00<0000009VIV@2IVIT0:02I
VIT2000001l0/k>c1P00000V0<c<c0<000005P2c/k<00`000000VIVI09VIV@0?09VIV@030000001o
Ogl0Ogmo00h0Ogmo00<0000006IVIP1VIVH03`1VIVH00`000000C4a<04a<C00C04a<C0<000009`0c
<c<500000200C4a<0P00000Z06IVIP030000001oOgl0Ogmo01D0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo6P1oOgl00`000000VIVI09VIV@0Y09VIV@8000008`2c/k<6
000001/0c<c<1@00000H0;>c/`030000002IVIT0VIVI0100VIVI00<0000007moO`1oOgl03P1oOgl0
0`000000IVIV06IVIP0@06IVIP030000001<C4`0C4a<01D0C4a<1P00000K03<c<`H000008`1<C4`2
000002/0IVIV00<0000007moO`1oOgl05P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?oo
o`3oool0103ooolK07moO`800000:`2IVIT2000002L0/k>c2P00000;0<c<c0H00000702c/k<00`00
0000VIVI09VIV@0A09VIV@030000001oOgl0Ogmo00h0Ogmo00<0000006IVIP1VIVH04@1VIVH00`00
0000C4a<04a<C00J04a<C0H000002`0c<c<:000002L0C4a<0P00000[06IVIP8000006@1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolM07moO`030000002IVIT0VIVI02X0
VIVI0`00000^0;>c/`/000008@2c/k<00`000000VIVI09VIV@0A09VIV@030000001oOgl0Ogmo0100
Ogmo00<0000006IVIP1VIVH04@1VIVH00`000000C4a<04a<C00O04a<C0/00000;P1<C4`3000002`0
IVIV00<0000007moO`1oOgl06@1oOgl80?ooo`4000000@3oool001L0oooo0P0000050?oooah0Ogmo
00<0000009VIV@2IVIT0;02IVIT2000005L0/k>c00<0000009VIV@2IVIT04P2IVIT00`000000Ogmo
07moO`0@07moO`030000001VIVH0IVIV0180IVIV00<0000004a<C01<C4`0E@1<C4`2000002h0IVIV
00<0000007moO`1oOgl06P1oOgl70?ooo`8000000@3oool001L0oooo00<000000?ooo`3oool0103o
oolO07moO`800000;P2IVIT2000005@0/k>c00<0000009VIV@2IVIT04`2IVIT00`000000Ogmo07mo
O`0@07moO`030000001VIVH0IVIV01<0IVIV00<0000004a<C01<C4`0DP1<C4`2000002h0IVIV0P00
000M07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob40Ogmo00<00000
09VIV@2IVIT0;@2IVIT4000004h0/k>c0P00000E09VIV@030000001oOgl0Ogmo0180Ogmo00<00000
06IVIP1VIVH04`1VIVH00`000000C4a<04a<C01=04a<C0@00000;`1VIVH00`000000Ogmo07moO`0M
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob80Ogmo0P00000a09VI
V@D00000A@2c/k<4000001L0VIVI00<0000007moO`1oOgl04P1oOgl00`000000IVIV06IVIP0D06IV
IP@00000AP1<C4`500000300IVIV0`00000P07moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooob@0Ogmo0`00000c09VIV@H00000>`2c/k<4000001X0VIVI00<0000007moO`1o
Ogl0501oOgl00`000000IVIV06IVIP0G06IVIP@00000?01<C4`600000380IVIV0`00000S07moO`P0
oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobL0Ogmo0`00000f09VIV@L00000
;`2c/k<5000001d0VIVI00<0000007moO`1oOgl05P1oOgl00`000000IVIV06IVIP0J06IVIPD00000
<01<C4`7000003D0IVIV0`00000V07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooobX0Ogmo0`00000j09VIV@P000007@2c/k<:00000240VIVI00<0000007moO`1oOgl0601o
Ogl00`000000IVIV06IVIP0N06IVIP/000007@1<C4`8000003T0IVIV0`00000Y07moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?ooobd0Ogmo0`00000o09VIVAd00000:P2IVIT0
0`000000Ogmo07moO`0J07moO`030000001VIVH0IVIV02P0IVIV7@00000n06IVIP<00000;01oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool`07moO`@00000P@2IVIT00`00
0000Ogmo07moO`0L07moO`030000001VIVH0IVIV07l0IVIV0`00000_07moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?oooc@0Ogmo1000001k09VIV@800000801oOgl2000007/0
IVIV1000000b07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooocP0Ogmo
1000001d09VIV@<00000901oOgl3000007@0IVIV1000000f07moO`P0oooo0@0000010?ooo`005`3o
ool00`000000oooo0?ooo`040?oooc`0Ogmo1000001]09VIV@<00000:P1oOgl3000006d0IVIV1000
000j07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oood00Ogmo1P00001S
09VIV@@00000<01oOgl4000006<0IVIV1P00000n07moO`P0oooo0@0000010?ooo`005`3oool00`00
0000oooo0?ooo`040?ooodH0Ogmo2000001H09VIV@<00000>01oOgl3000005P0IVIV2000001407mo
O`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooodh0Ogmo3000001209VIV@X0
0000?P1oOgl900000480IVIV3@00001<07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?oooeX0Ogmo@P00001A07moOd800000F@1oOgl80?ooo`4000000@3oool000/0oooo00D0
omBK000000000000000009_Do`070?ooo`030000003oool0oooo00@0ooooo`1oOgn907moO`P0oooo
0@0000010?ooo`002`3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`H0oooo00<000000?ooo`3o
ool0103ooooo07moOhT0Ogmo203oool100000040oooo000:0?ooo`030?oDV`00Vm@0oooo0080oooo
00<0j[Yb07:jjP3oool01@3oool00`000000oooo0?ooo`040?ooool0OgmoR@1oOgl80?ooo`400000
0@3oool000X0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?ooo`<00000103o
oooo07moOhT0Ogmo1P3oool300000040oooo000:0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool01@3oool00`000000oooo0?ooo`040?ooool0OgmoR@1oOgl80?ooo`4000000@3oool0
00X0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo
00@0ooooo`1oOgn907moO`P0oooo0@0000010?ooo`002P3oool00`3oe9/0L[[Z0?ooo`020?ooo`03
0>ZjLP1b^^X0oooo00D0oooo00<000000?ooo`3oool0103ooooo07moOhT0Ogmo203oool100000040
oooo000;0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo1P3oool00`000000oooo0?ooo`040?oo
of/0Ogmo8000001c07moOb000000JP1oOgl80?ooo`4000000@3oool000/0oooo00D0oooD09/00000
0000001b0;[Zo`070?ooo`030000003oool0oooo00@0ooooF`1oOgl@00000200IVIV4@00001B07mo
Oa000000802IVITA000005T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0
ooooC`1oOgl<00000440IVIV2P00000n07moO`X00000@@2IVIT<000004d0Ogmo203oool100000040
oooo000G0?ooo`030000003oool0oooo00@0ooooA`1oOgl8000005L0IVIV0`00000h07moO`<00000
E`2IVIT8000004D0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo@01o
Ogl700000680IVIV0`00000b07moO`<00000HP2IVIT7000003h0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo>P1oOgl6000006`0IVIV1000000Z07moO`@00000K02IVIT5
000003T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo=01oOgl60000
07H0IVIV0`00000T07moO`<00000M@2IVIT6000003<0Ogmo203oool100000040oooo000G0?ooo`03
0000003oool0oooo00@0oooo<01oOgl4000007l0IVIV0P00000P07moO`800000OP2IVIT4000002l0
Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo;P1oOgl2000004`0IVIV
2`00000^06IVIP030000001oOgl0Ogmo01`0Ogmo00<0000009VIV@2IVIT0:`2IVIT<000004/0VIVI
0P00000]07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob/0Ogmo0`00
001106IVIPd000002`1<C4`8000002L0IVIV00<0000007moO`1oOgl06P1oOgl00`000000VIVI09VI
V@0T09VIV@P00000302c/k<<00000440VIVI0`00000Z07moO`P0oooo0@0000010?ooo`005`3oool0
0`000000oooo0?ooo`040?ooobT0Ogmo0P00000l06IVIPP00000801<C4`700000240IVIV00<00000
07moO`1oOgl0601oOgl00`000000VIVI09VIV@0N09VIV@L00000802c/k<8000003`0VIVI0P00000X
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobH0Ogmo0`00000g06IV
IPL00000;`1<C4`4000001h0IVIV00<0000007moO`1oOgl05P1oOgl00`000000VIVI09VIV@0K09VI
V@@00000;`2c/k<7000003L0VIVI0`00000U07moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooob@0Ogmo0P00000d06IVIPH00000>P1<C4`5000001X0IVIV00<0000007moO`1o
Ogl0501oOgl00`000000VIVI09VIV@0G09VIV@D00000>P2c/k<6000003@0VIVI0P00000S07moO`P0
oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob40Ogmo0`00000a06IVIPD00000
A@1<C4`4000001L0IVIV00<0000007moO`1oOgl04P1oOgl00`000000VIVI09VIV@0E09VIV@<00000
A@2c/k<600000300VIVI1000000O07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooob00Ogmo00<0000006IVIP1VIVH0;P1VIVH4000004h0C4a<0P00000E06IVIP030000001o
Ogl0Ogmo0180Ogmo00<0000009VIV@2IVIT04`2IVIT2000004h0/k>c1000000`09VIV@030000001o
Ogl0Ogmo01`0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo7P1oOgl2
000002l0IVIV0P00001D04a<C0030000001VIVH0IVIV01<0IVIV00<0000007moO`1oOgl0401oOgl0
0`000000VIVI09VIV@0C09VIV@030000002c/k<0/k>c0580/k>c0P00000_09VIV@800000701oOgl8
0?ooo`4000000@3oool001L0oooo0P0000050?oooad0Ogmo00<0000006IVIP1VIVH0;01VIVH30000
05L0C4a<00<0000006IVIP1VIVH04P1VIVH00`000000Ogmo07moO`0@07moO`030000002IVIT0VIVI
0180VIVI00<000000;>c/`2c/k<0E@2c/k<3000002h0VIVI00<0000007moO`1oOgl06@1oOgl70?oo
o`8000000@3oool001L0oooo00<000000?ooo`3oool0103ooolL07moO`030000001VIVH0IVIV02X0
IVIV0`00000`04a<C0/00000801<C4`00`000000IVIV06IVIP0A06IVIP030000001oOgl0Ogmo0100
Ogmo00<0000009VIV@2IVIT04@2IVIT00`000000/k>c0;>c/`0M0;>c/``00000<02c/k<3000002`0
VIVI00<0000007moO`1oOgl0601oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103ooolK07moO`030000001VIVH0IVIV02T0IVIV0P00000X04a<C0/000002`0c<c<8000001T0C4a<
00<0000006IVIP1VIVH04@1VIVH00`000000Ogmo07moO`0>07moO`030000002IVIT0VIVI0140VIVI
00<000000;>c/`2c/k<05P2c/k<8000000`0c<c<2`00000X0;>c/`800000:`2IVIT00`000000Ogmo
07moO`0G07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooaX0Ogmo00<0
000006IVIP1VIVH09`1VIVH3000002@0C4a<1P00000N03<c<`D000005@1<C4`00`000000IVIV06IV
IP0@06IVIP030000001oOgl0Ogmo00h0Ogmo00<0000009VIV@2IVIT0402IVIT00`000000/k>c0;>c
/`0B0;>c/`D000007`3<c<`5000002D0/k>c0`00000Y09VIV@030000001oOgl0Ogmo01H0Ogmo203o
ool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo601oOgl2000002P0IVIV0P00000Q
04a<C0H00000:@0c<c<2000001@0C4a<00<0000006IVIP1VIVH03`1VIVH00`000000Ogmo07moO`0>
07moO`030000002IVIT0VIVI00l0VIVI00<000000;>c/`2c/k<04@2c/k<2000002T0c<c<1P00000R
0;>c/`800000:02IVIT2000001H0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo
00@0oooo5`1oOgl00`000000IVIV06IVIP0W06IVIP030000001<C4`0C4a<01d0C4a<1000000a03<c
<`8000004`1<C4`00`000000IVIV06IVIP0>06IVIP030000001oOgl0Ogmo00d0Ogmo00<0000009VI
V@2IVIT03`2IVIT00`000000/k>c0;>c/`0@0;>c/`800000<@3<c<`400000200/k>c00<0000009VI
V@2IVIT09`2IVIT00`000000Ogmo07moO`0C07moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?oooaH0Ogmo00<0000006IVIP1VIVH09P1VIVH2000001h0C4a<0P00000g03<c<`80
00004P1<C4`00`000000IVIV06IVIP0>06IVIP030000001oOgl0Ogmo00`0Ogmo00<0000009VIV@2I
VIT03P2IVIT00`000000/k>c0;>c/`0?0;>c/`800000=`3<c<`2000001l0/k>c0P00000X09VIV@03
0000001oOgl0Ogmo0180Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo
5@1oOgl00`000000IVIV06IVIP0V06IVIP030000001<C4`0C4a<01`0C4a<0P00000k03<c<`800000
4@1<C4`00`000000IVIV06IVIP0=06IVIP030000001oOgl0Ogmo00`0Ogmo00<0000009VIV@2IVIT0
3@2IVIT00`000000/k>c0;>c/`0?0;>c/`030000003<c<`0c<c<03T0c<c<0`00000N0;>c/`030000
002IVIT0VIVI02H0VIVI00<0000007moO`1oOgl04@1oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103ooolC07moO`800000:01VIVH00`000000C4a<04a<C00K04a<C0800000?`0c
<c<200000100C4a<00<0000006IVIP1VIVH0301VIVH00`000000Ogmo07moO`0<07moO`030000002I
VIT0VIVI00`0VIVI00<000000;>c/`2c/k<03P2c/k<2000003l0c<c<0P00000M0;>c/`030000002I
VIT0VIVI02H0VIVI0P00000A07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`04
0?oooa80Ogmo00<0000006IVIP1VIVH09P1VIVH2000001/0C4a<0`00001303<c<`8000003`1<C4`0
0`000000IVIV06IVIP0<06IVIP030000001oOgl0Ogmo00X0Ogmo00<0000009VIV@2IVIT0302IVIT0
0`000000/k>c0;>c/`0=0;>c/`800000@`3<c<`2000001`0/k>c0P00000X09VIV@030000001oOgl0
Ogmo00h0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo4@1oOgl00`00
0000IVIV06IVIP0V06IVIP030000001<C4`0C4a<01T0C4a<0P00001803<c<`8000003P1<C4`00`00
0000IVIV06IVIP0;06IVIP030000001oOgl0Ogmo00X0Ogmo00<0000009VIV@2IVIT02`2IVIT00`00
0000/k>c0;>c/`0<0;>c/`800000A`3<c<`3000001/0/k>c00<0000009VIV@2IVIT09P2IVIT00`00
0000Ogmo07moO`0=07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooa00
Ogmo00<0000006IVIP1VIVH09P1VIVH00`000000C4a<04a<C00H04a<C08000009P0c<c<:000001`0
<c<c0P00000=04a<C0030000001VIVH0IVIV00X0IVIV00<0000007moO`1oOgl02P1oOgl00`000000
VIVI09VIV@0:09VIV@030000002c/k<0/k>c00/0/k>c0P00000L0<c<c0X000009P3<c<`2000001X0
/k>c00<0000009VIV@2IVIT09P2IVIT00`000000Ogmo07moO`0<07moO`P0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooo`l0Ogmo00<0000006IVIP1VIVH09@1VIVH2000001T0C4a<
0P00000N03<c<`X000002P0I6AT5000001T0<c<c00<0000004a<C01<C4`02`1<C4`00`000000IVIV
06IVIP0:06IVIP030000001oOgl0Ogmo00P0Ogmo00<0000009VIV@2IVIT02P2IVIT00`000000/k>c
0;>c/`0;0;>c/`030000003<c<`0c<c<01H0c<c<1P00000:0>KViPX000007P3<c<`2000001T0/k>c
0P00000W09VIV@030000001oOgl0Ogmo00/0Ogmo203oool100000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo3P1oOgl00`000000IVIV06IVIP0U06IVIP030000001<C4`0C4a<01P0C4a<00<0
000003<c<`0c<c<06P0c<c<4000001T06ATI1@00000E03<c<`030000001<C4`0C4a<00/0C4a<00<0
000006IVIP1VIVH02@1VIVH00`000000Ogmo07moO`0807moO`030000002IVIT0VIVI00T0VIVI00<0
00000;>c/`2c/k<02`2c/k<00`000000c<c<0<c<c00B0<c<c0D000006P3Vi^H4000001`0c<c<00<0
00000;>c/`2c/k<0602c/k<00`000000VIVI09VIV@0U09VIV@030000001oOgl0Ogmo00X0Ogmo203o
ool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo3@1oOgl00`000000IVIV06IVIP0T
06IVIP8000006P1<C4`00`000000<c<c03<c<`0G03<c<`@000008P0I6AT400000180<c<c00<00000
04a<C01<C4`02P1<C4`00`000000IVIV06IVIP0906IVIP030000001oOgl0Ogmo00P0Ogmo00<00000
09VIV@2IVIT0202IVIT00`000000/k>c0;>c/`0;0;>c/`030000003<c<`0c<c<00l0c<c<1000000S
0>KViP@000006@3<c<`00`000000/k>c0;>c/`0H0;>c/`030000002IVIT0VIVI02@0VIVI00<00000
07moO`1oOgl02P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool=07mo
O`030000001VIVH0IVIV0280IVIV0P00000K04a<C0030000000c<c<0<c<c01<0<c<c1@00000Z01TI
6@030000000c<c<0<c<c00l0<c<c00<0000004a<C01<C4`02`1<C4`00`000000IVIV06IVIP0806IV
IP030000001oOgl0Ogmo00P0Ogmo00<0000009VIV@2IVIT0202IVIT00`000000/k>c0;>c/`0;0;>c
/`030000003<c<`0c<c<00h0c<c<00<000000>KViP3Vi^H0:@3Vi^H4000001H0c<c<00<000000;>c
/`2c/k<0602c/k<2000002D0VIVI00<0000007moO`1oOgl02@1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103oool<07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<
C4`06P1<C4`00`000000<c<c03<c<`0A03<c<`<00000<00I6AT00`000000<c<c03<c<`0?03<c<`03
0000001<C4`0C4a<00X0C4a<00<0000006IVIP1VIVH0201VIVH00`000000Ogmo07moO`0807moO`03
0000002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<02P2c/k<00`000000c<c<0<c<c00>0<c<c003
0000003Vi^H0i^KV02h0i^KV0`00000D0<c<c0030000002c/k<0/k>c01T0/k>c00<0000009VIV@2I
VIT08P2IVIT00`000000Ogmo07moO`0907moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?ooo``0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00I04a<C0030000
000c<c<0<c<c0140<c<c00<0000001TI6@0I6AT0<P0I6AT00`000000<c<c03<c<`0>03<c<`030000
001<C4`0C4a<00X0C4a<00<0000006IVIP1VIVH0201VIVH00`000000Ogmo07moO`0807moO`030000
002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<02P2c/k<00`000000c<c<0<c<c00=0<c<c0030000
003Vi^H0i^KV0380i^KV00<000000<c<c03<c<`04P3<c<`00`000000/k>c0;>c/`0I0;>c/`030000
002IVIT0VIVI0280VIVI00<0000007moO`1oOgl0201oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103oool;07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`06@1<
C4`00`000000<c<c03<c<`0A03<c<`030000000I6AT06ATI03@06ATI00<0000003<c<`0c<c<03P0c
<c<00`000000C4a<04a<C00:04a<C0030000001VIVH0IVIV00L0IVIV00<0000007moO`1oOgl0201o
Ogl00`000000VIVI09VIV@0709VIV@030000002c/k<0/k>c00X0/k>c00<000000<c<c03<c<`03@3<
c<`00`000000i^KV0>KViP0d0>KViP030000003<c<`0c<c<0180c<c<00<000000;>c/`2c/k<0602c
/k<00`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00P0Ogmo203oool100000040oooo000G
0?ooo`8000001@3oool;07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`0601<C4`0
0`000000<c<c03<c<`0A03<c<`030000000I6AT06ATI03H06ATI00<0000003<c<`0c<c<03@0c<c<0
0`000000C4a<04a<C00:04a<C0030000001VIVH0IVIV00L0IVIV00<0000007moO`1oOgl0201oOgl0
0`000000VIVI09VIV@0709VIV@030000002c/k<0/k>c00X0/k>c00<000000<c<c03<c<`0303<c<`0
0`000000i^KV0>KViP0f0>KViP030000003<c<`0c<c<0180c<c<00<000000;>c/`2c/k<0602c/k<0
0`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00L0Ogmo1`3oool200000040oooo000G0?oo
o`030000003oool0oooo00@0oooo2P1oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0C4a<
01P0C4a<00<0000003<c<`0c<c<04@0c<c<00`0000006ATI01TI6@0h01TI6@030000000c<c<0<c<c
00d0<c<c00<0000004a<C01<C4`02@1<C4`00`000000IVIV06IVIP0706IVIP030000001oOgl0Ogmo
00P0Ogmo00<0000009VIV@2IVIT01`2IVIT00`000000/k>c0;>c/`090;>c/`030000003<c<`0c<c<
00`0c<c<00<000000>KViP3Vi^H0>03Vi^H00`000000c<c<0<c<c00B0<c<c0030000002c/k<0/k>c
01L0/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo07moO`0707moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?ooo`X0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000
C4a<04a<C00G04a<C0030000000c<c<0<c<c0140<c<c00<0000001TI6@0I6AT0>P0I6AT00`000000
<c<c03<c<`0<03<c<`030000001<C4`0C4a<00T0C4a<00<0000006IVIP1VIVH01`1VIVH00`000000
Ogmo07moO`0707moO`030000002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<0202c/k<00`000000
c<c<0<c<c00<0<c<c0030000003Vi^H0i^KV03X0i^KV00<000000<c<c03<c<`04@3<c<`00`000000
/k>c0;>c/`0H0;>c/`030000002IVIT0VIVI0280VIVI00<0000007moO`1oOgl01P1oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oool907moO`030000001VIVH0IVIV0280IVIV
00<0000004a<C01<C4`0601<C4`00`000000<c<c03<c<`0@03<c<`030000000I6AT06ATI03`06ATI
00<0000003<c<`0c<c<0300c<c<00`000000C4a<04a<C00804a<C0030000001VIVH0IVIV00P0IVIV
00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0709VIV@030000002c/k<0/k>c00T0/k>c
00<000000<c<c03<c<`02`3<c<`00`000000i^KV0>KViP0l0>KViP030000003<c<`0c<c<0140c<c<
00<000000;>c/`2c/k<05`2c/k<00`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00H0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo2@1oOgl00`000000IVIV06IV
IP0R06IVIP030000001<C4`0C4a<01L0C4a<00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI
6@0S01TI6@@000005`0I6AT00`000000<c<c03<c<`0<03<c<`030000001<C4`0C4a<00P0C4a<00<0
000006IVIP1VIVH01`1VIVH00`000000Ogmo07moO`0607moO`030000002IVIT0VIVI00L0VIVI00<0
00000;>c/`2c/k<0202c/k<00`000000c<c<0<c<c00;0<c<c0030000003Vi^H0i^KV01H0i^KV1000
000T0>KViP8000004P3<c<`00`000000/k>c0;>c/`0G0;>c/`030000002IVIT0VIVI0280VIVI00<0
000007moO`1oOgl01@1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool8
07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`05`1<C4`00`000000<c<c03<c<`0@
03<c<`030000000I6AT06ATI01l06ATI2`00000F01TI6@030000000c<c<0<c<c00/0<c<c00<00000
04a<C01<C4`0201<C4`00`000000IVIV06IVIP0706IVIP030000001oOgl0Ogmo00H0Ogmo00<00000
09VIV@2IVIT01`2IVIT00`000000/k>c0;>c/`080;>c/`030000003<c<`0c<c<00X0c<c<00<00000
0>KViP3Vi^H05@3Vi^H2000000@0oooo1@00000Q0>KViP030000003<c<`0c<c<0100c<c<00<00000
0;>c/`2c/k<05P2c/k<00`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00D0Ogmo203oool1
00000040oooo000G0?ooo`030000003oool0oooo00@0oooo201oOgl00`000000IVIV06IVIP0R06IV
IP030000001<C4`0C4a<01H0C4a<00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0J01TI
6A<000005@0I6AT00`000000<c<c03<c<`0;03<c<`030000001<C4`0C4a<00L0C4a<00<0000006IV
IP1VIVH01`1VIVH00`000000Ogmo07moO`0607moO`030000002IVIT0VIVI00L0VIVI00<000000;>c
/`2c/k<01`2c/k<00`000000c<c<0<c<c00:0<c<c0030000003Vi^H0i^KV01@0i^KV0P00000;0?oo
o`H00000703Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01H0/k>c00<0000009VI
V@2IVIT08P2IVIT00`000000Ogmo07moO`0407moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooo`L0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00F04a<C003
0000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT0600I6ATH000001@06ATI00<0000003<c<`0c
<c<02P0c<c<00`000000C4a<04a<C00704a<C0030000001VIVH0IVIV00L0IVIV00<0000007moO`1o
Ogl01P1oOgl00`000000VIVI09VIV@0709VIV@030000002c/k<0/k>c00L0/k>c00<000000<c<c03<
c<`02@3<c<`00`000000i^KV0>KViP0C0>KViP8000004`3oool3000001X0i^KV00<000000<c<c03<
c<`0403<c<`00`000000/k>c0;>c/`0E0;>c/`030000002IVIT0VIVI0280VIVI00<0000007moO`1o
Ogl0101oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool707moO`030000
001VIVH0IVIV0280IVIV00<0000004a<C01<C4`05@1<C4`00`000000<c<c03<c<`0@03<c<`030000
000I6AT06ATI01L06ATI7000000C01TI6@030000000c<c<0<c<c00X0<c<c00<0000004a<C01<C4`0
1`1<C4`00`000000IVIV06IVIP0606IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT0
1P2IVIT00`000000/k>c0;>c/`070;>c/`030000003<c<`0c<c<00T0c<c<00<000000>KViP3Vi^H0
4P3Vi^H2000001P0oooo0P00000I0>KViP030000003<c<`0c<c<0100c<c<00<000000;>c/`2c/k<0
5@2c/k<00`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00<0Ogmo203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0oooo1P1oOgl00`000000IVIV06IVIP0R06IVIP030000001<
C4`0C4a<01D0C4a<00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0F01TI6B0000004P0I
6AT00`000000<c<c03<c<`0903<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH01P1V
IVH00`000000Ogmo07moO`0607moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01`2c
/k<00`000000c<c<0<c<c0080<c<c0030000003Vi^H0i^KV0140i^KV0P00000L0?ooo`800000603V
i^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01@0/k>c00<0000009VIV@2IVIT08P2I
VIT00`000000Ogmo07moO`0307moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`04
0?ooo`H0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00C04a<C08000004P0c<c<0
0`0000006ATI01TI6@0E01TI6B@000004@0I6AT00`000000<c<c03<c<`0903<c<`030000001<C4`0
C4a<00H0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo07moO`0607moO`030000002IVIT0
VIVI00H0VIVI00<000000;>c/`2c/k<01P2c/k<00`000000c<c<0<c<c0080<c<c0030000003Vi^H0
i^KV0100i^KV0P00000P0?ooo`8000005`3Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0
/k>c01@0/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo07moO`0207moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?ooo`H0Ogmo00<0000006IVIP1VIVH08P1VIVH00`00
0000C4a<04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT05@0I6ATV0000
01006ATI00<0000003<c<`0c<c<02@0c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV
00H0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c
00H0/k>c00<000000<c<c03<c<`0203<c<`00`000000i^KV0>KViP0?0>KViP030000003oool0oooo
0280oooo00<000000>KViP3Vi^H0503Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c
01@0/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo07moO`0207moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?ooo`H0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000
C4a<04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT05@0I6ATV00000140
6ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV00H0
IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c00H0
/k>c00<000000<c<c03<c<`0203<c<`00`000000i^KV0>KViP0>0>KViP030000003oool0oooo02<0
oooo00<000000>KViP3Vi^H05@3Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01<0
/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo07moO`0207moO`P0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooo`D0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<
04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT05@0I6ATX000001006ATI
00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV00H0IVIV
00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c00H0/k>c
00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP0>0>KViP030000003oool0oooo02D0oooo
00<000000>KViP3Vi^H0503Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01@0/k>c
00<0000009VIV@2IVIT08P2IVIT010000000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103oool507moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`0
4`1<C4`00`000000<c<c03<c<`0@03<c<`030000000I6AT06ATI01@06ATI:P00000?01TI6@030000
000c<c<0<c<c00P0<c<c00<0000004a<C01<C4`01P1<C4`00`000000IVIV06IVIP0606IVIP030000
001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`060;>c/`030000
003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H03@3Vi^H00`000000oooo0?ooo`0V0?ooo`030000
003Vi^H0i^KV01D0i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0D0;>c/`030000
002IVIT0VIVI0280VIVI00@0000007moO`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000
003oool0oooo00@0oooo1@1oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0C4a<01<0C4a<
00<0000003<c<`0c<c<03`0c<c<00`0000006ATI01TI6@0E01TI6B/000003`0I6AT00`000000<c<c
03<c<`0803<c<`030000001<C4`0C4a<00D0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo
07moO`0607moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01@2c/k<00`000000c<c<
0<c<c0080<c<c0030000003Vi^H0i^KV00d0i^KV00<000000?ooo`3oool09`3oool00`000000i^KV
0>KViP0D0>KViP030000003<c<`0c<c<00l0c<c<00<000000;>c/`2c/k<0502c/k<00`000000VIVI
09VIV@0R09VIV@040000001oOgl0Ogmo07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo
0?ooo`040?ooo`D0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00C04a<C0030000
000c<c<0<c<c00l0<c<c00<0000001TI6@0I6AT0500I6AT/000000l06ATI00<0000003<c<`0c<c<0
200c<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV00H0IVIV00<0000007moO`1oOgl0
1P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c00D0/k>c00<000000<c<c03<c<`0
203<c<`00`000000i^KV0>KViP0<0>KViP030000003oool0oooo02T0oooo00<000000>KViP3Vi^H0
503Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT0
8P2IVIT010000000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103oool507moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c
03<c<`0@03<c<`030000000I6AT06ATI01<06ATI;P00000>01TI6@030000000c<c<0<c<c00P0<c<c
00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0606IVIP030000001oOgl0Ogmo00H0Ogmo
00<0000009VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`050;>c/`030000003<c<`0c<c<00P0c<c<
00<000000>KViP3Vi^H0303Vi^H00`000000oooo0?ooo`0Y0?ooo`030000003Vi^H0i^KV01@0i^KV
00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0D0;>c/`030000002IVIT0VIVI0240VIVI
00@0000007moO`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo
1@1oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<0
3`0c<c<00`0000006ATI01TI6@0C01TI6Bl000003P0I6AT00`000000<c<c03<c<`0803<c<`030000
001<C4`0C4a<00D0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo07moO`0607moO`030000
002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01@2c/k<00`000000c<c<0<c<c0080<c<c0030000
003Vi^H0i^KV00/0i^KV00<000000?ooo`3oool0:`3oool00`000000i^KV0>KViP0D0>KViP030000
003<c<`0c<c<00h0c<c<00<000000;>c/`2c/k<0502c/k<00`000000VIVI09VIV@0Q09VIV@040000
001oOgl0Ogmo07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`@0Ogmo
00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c00l0<c<c
00<0000001TI6@0I6AT04`0I6AT`000000h06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<
04a<C00604a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1oOgl01@1oOgl00`000000VIVI
09VIV@0609VIV@030000002c/k<0/k>c00H0/k>c00<000000<c<c03<c<`01`3<c<`00`000000i^KV
0>KViP0<0>KViP030000003oool0oooo02`0oooo00<000000>KViP3Vi^H04`3Vi^H00`000000c<c<
0<c<c00?0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo
07moO`080?ooo`4000000@3oool001L0oooo0P0000050?ooo`@0Ogmo00<0000006IVIP1VIVH08P1V
IVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c00l0<c<c00<0000001TI6@0I6AT04P0I
6ATa000000h06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00604a<C0030000001V
IVH0IVIV00D0IVIV00<0000007moO`1oOgl01@1oOgl00`000000VIVI09VIV@0609VIV@030000002c
/k<0/k>c00H0/k>c00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP0;0>KViP030000003o
ool0oooo02d0oooo00<000000>KViP3Vi^H04`3Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c
/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08P2IVIT00`000000Ogmo07moO`070?ooo`8000000@3o
ool001L0oooo00<000000?ooo`3oool0103oool407moO`030000001VIVH0IVIV0240IVIV00<00000
04a<C01<C4`04`1<C4`00`000000<c<c03<c<`0@03<c<`030000000I6AT06ATI01406ATI<`00000=
01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01P1<C4`00`000000IVIV06IVIP05
06IVIP030000001oOgl0Ogmo00D0Ogmo00<0000009VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`06
0;>c/`030000003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02`3Vi^H00`000000oooo0?ooo`0^
0?ooo`030000003Vi^H0i^KV0180i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0D
0;>c/`030000002IVIT0VIVI0240VIVI00<0000007moO`1oOgl0203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo101oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<
01<0C4a<00<0000003<c<`0c<c<03`0c<c<00`0000006ATI01TI6@0B01TI6C<000003@0I6AT00`00
0000<c<c03<c<`0703<c<`030000001<C4`0C4a<00H0C4a<00<0000006IVIP1VIVH01@1VIVH00`00
0000Ogmo07moO`0507moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01P2c/k<00`00
0000c<c<0<c<c0070<c<c0030000003Vi^H0i^KV00X0i^KV00<000000?ooo`3oool0;`3oool00`00
0000i^KV0>KViP0C0>KViP030000003<c<`0c<c<00l0c<c<00<000000;>c/`2c/k<04`2c/k<00`00
0000VIVI09VIV@0Q09VIV@030000001oOgl0Ogmo00P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooo`@0Ogmo00<0000006IVIP1VIVH08@1VIVH00`000000C4a<04a<C00C04a<C003
0000000c<c<0<c<c00l0<c<c00<0000001TI6@0I6AT04@0I6ATe000000`06ATI00<0000003<c<`0c
<c<0200c<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1o
Ogl01@1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c00D0/k>c00<000000<c<c03<
c<`0203<c<`00`000000i^KV0>KViP0:0>KViP030000003oool0oooo0300oooo00<000000>KViP3V
i^H04P3Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2I
VIT08@2IVIT00`000000Ogmo07moO`080?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103oool407moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c
03<c<`0?03<c<`030000000I6AT06ATI01006ATI=P00000<01TI6@030000000c<c<0<c<c00P0<c<c
00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00D0Ogmo
00<0000009VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`050;>c/`030000003<c<`0c<c<00P0c<c<
00<000000>KViP3Vi^H02@3Vi^H00`000000oooo0?ooo`0b0?ooo`030000003Vi^H0i^KV0140i^KV
00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI
00<0000007moO`1oOgl0203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo0`1o
Ogl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<0400c
<c<00`0000006ATI01TI6@0@01TI6CL00000300I6AT00`000000<c<c03<c<`0703<c<`030000001<
C4`0C4a<00D0C4a<00<0000006IVIP1VIVH01@1VIVH00`000000Ogmo07moO`0507moO`030000002I
VIT0VIVI00H0VIVI00<000000;>c/`2c/k<01@2c/k<00`000000c<c<0<c<c0070<c<c0030000003V
i^H0i^KV00X0i^KV00<000000?ooo`3oool0<P3oool00`000000i^KV0>KViP0A0>KViP030000003<
c<`0c<c<00l0c<c<00<000000;>c/`2c/k<0502c/k<00`000000VIVI09VIV@0Q09VIV@030000001o
Ogl0oooo00L0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`<0Ogmo00<00000
06IVIP1VIVH08@1VIVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c00l0<c<c00<00000
01TI6@0I6AT0400I6ATh000000`06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C005
04a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1oOgl01@1oOgl00`000000VIVI09VIV@06
09VIV@030000002c/k<0/k>c00D0/k>c00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP09
0>KViP030000003oool0oooo03@0oooo00<000000>KViP3Vi^H04@3Vi^H00`000000c<c<0<c<c00?
0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo0?ooo`07
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool307moO`030000001VIVH0IVIV
0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c<`0?03<c<`030000000I6AT06ATI
01006ATI>@00000;01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01@1<C4`00`00
0000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00D0Ogmo00<0000009VIV@2IVIT01P2IVIT00`00
0000/k>c0;>c/`050;>c/`030000003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02@3Vi^H00`00
0000oooo0?ooo`0e0?ooo`030000003Vi^H0i^KV0100i^KV00<000000<c<c03<c<`03`3<c<`00`00
0000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI00<0000007moO`3oool01`3oool10000
0040oooo000G0?ooo`030000003oool0oooo00@0oooo0`1oOgl00`000000IVIV06IVIP0Q06IVIP03
0000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<03`0c<c<00`0000006ATI01TI6@0@01TI6CT0
00002`0I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00D0C4a<00<0000006IVIP1V
IVH01@1VIVH00`000000Ogmo07moO`0507moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c
/k<01@2c/k<00`000000c<c<0<c<c0070<c<c0030000003Vi^H0i^KV00T0i^KV00<000000?ooo`3o
ool0=@3oool00`000000i^KV0>KViP0@0>KViP030000003<c<`0c<c<00l0c<c<00<000000;>c/`2c
/k<04`2c/k<00`000000VIVI09VIV@0Q09VIV@030000001oOgl0oooo00L0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooo`<0Ogmo00<0000006IVIP1VIVH08@1VIVH00`000000C4a<
04a<C00C04a<C0030000000c<c<0<c<c00l0<c<c00<0000001TI6@0I6AT0400I6ATi000000/06ATI
00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV00D0IVIV
00<0000007moO`1oOgl01@1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c00D0/k>c
00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP090>KViP030000003oool0oooo03D0oooo
00<000000>KViP3Vi^H0403Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c/k<0/k>c01<0/k>c
00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo0?ooo`070?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103oool307moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<
C4`00`000000<c<c03<c<`0?03<c<`030000000I6AT06ATI01006ATI>000000<01TI6@030000000c
<c<0<c<c00L0<c<c00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0506IVIP030000001o
Ogl0Ogmo00D0Ogmo00<0000009VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`050;>c/`030000003<
c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02P3Vi^H00`000000oooo0?ooo`0d0?ooo`030000003V
i^H0i^KV0100i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0C0;>c/`030000002I
VIT0VIVI0240VIVI00<0000007moO`3oool01`3oool100000040oooo000G0?ooo`030000003oool0
oooo00@0oooo0`1oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<00<00000
03<c<`0c<c<03`0c<c<00`0000006ATI01TI6@0@01TI6CP00000300I6AT00`000000<c<c03<c<`07
03<c<`030000001<C4`0C4a<00D0C4a<00<0000006IVIP1VIVH01@1VIVH00`000000Ogmo07moO`05
07moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01@2c/k<00`000000c<c<0<c<c007
0<c<c0030000003Vi^H0i^KV00X0i^KV00<000000?ooo`3oool0<`3oool00`000000i^KV0>KViP0@
0>KViP030000003<c<`0c<c<0100c<c<00<000000;>c/`2c/k<04`2c/k<00`000000VIVI09VIV@0Q
09VIV@030000001oOgl0oooo00L0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oo
o`<0Ogmo00<0000006IVIP1VIVH08@1VIVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c
0100<c<c00<0000001TI6@0I6AT03`0I6ATh000000`06ATI00<0000003<c<`0c<c<01`0c<c<00`00
0000C4a<04a<C00504a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1oOgl01@1oOgl00`00
0000VIVI09VIV@0609VIV@030000002c/k<0/k>c00D0/k>c00<000000<c<c03<c<`01`3<c<`00`00
0000i^KV0>KViP0:0>KViP030000003oool0oooo03<0oooo00<000000>KViP3Vi^H0403Vi^H00`00
0000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08@2IVIT00`00
0000Ogmo0?ooo`070?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool307moO`03
0000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c<`0@03<c<`03
0000000I6AT06ATI00l06ATI>000000<01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<
C4`01@1<C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00D0Ogmo00<0000009VIV@2I
VIT01P2IVIT00`000000/k>c0;>c/`050;>c/`030000003<c<`0c<c<00L0c<c<00<000000>KViP3V
i^H02P3Vi^H00`000000oooo0?ooo`0c0?ooo`030000003Vi^H0i^KV0100i^KV00<000000<c<c03<
c<`0403<c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI00<0000007moO`3o
ool01`3oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo0`1oOgl00`000000IVIV
06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<0400c<c<00`0000006ATI
01TI6@0?01TI6CP00000300I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00D0C4a<
00<0000006IVIP1VIVH01@1VIVH00`000000Ogmo07moO`0507moO`030000002IVIT0VIVI00H0VIVI
00<000000;>c/`2c/k<01@2c/k<00`000000c<c<0<c<c0070<c<c0030000003Vi^H0i^KV00X0i^KV
00<000000?ooo`3oool0<`3oool00`000000i^KV0>KViP0@0>KViP030000003<c<`0c<c<0100c<c<
00<000000;>c/`2c/k<04`2c/k<00`000000VIVI09VIV@0Q09VIV@030000001oOgl0oooo00L0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`<0Ogmo00<0000006IVIP1VIVH08@1V
IVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT03`0I
6ATg000000`06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00604a<C0030000001V
IVH0IVIV00D0IVIV00<0000007moO`1oOgl01@1oOgl00`000000VIVI09VIV@0609VIV@030000002c
/k<0/k>c00D0/k>c00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP0:0>KViP030000003o
ool0oooo03<0oooo00<000000>KViP3Vi^H0403Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c
/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo07moO`080?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103oool407moO`030000001VIVH0IVIV0240IVIV00<00000
04a<C01<C4`04`1<C4`00`000000<c<c03<c<`0?03<c<`030000000I6AT06ATI00l06ATI=`00000<
01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01P1<C4`00`000000IVIV06IVIP05
06IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01@2IVIT00`000000/k>c0;>c/`06
0;>c/`030000003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02P3Vi^H00`000000oooo0?ooo`0b
0?ooo`030000003Vi^H0i^KV0100i^KV00<000000<c<c03<c<`03`3<c<`00`000000/k>c0;>c/`0C
0;>c/`030000002IVIT0VIVI0240VIVI00<0000007moO`1oOgl0203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo101oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<
01<0C4a<00<0000003<c<`0c<c<03`0c<c<00`0000006ATI01TI6@0@01TI6CH00000300I6AT00`00
0000<c<c03<c<`0703<c<`030000001<C4`0C4a<00H0C4a<00<0000006IVIP1VIVH01@1VIVH00`00
0000Ogmo07moO`0607moO`030000002IVIT0VIVI00D0VIVI00<000000;>c/`2c/k<01P2c/k<00`00
0000c<c<0<c<c0070<c<c0030000003Vi^H0i^KV00X0i^KV00<000000?ooo`3oool0<@3oool00`00
0000i^KV0>KViP0A0>KViP030000003<c<`0c<c<00l0c<c<00<000000;>c/`2c/k<04`2c/k<00`00
0000VIVI09VIV@0Q09VIV@030000001oOgl0Ogmo00P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?ooo`@0Ogmo00<0000006IVIP1VIVH08@1VIVH00`000000C4a<04a<C00C04a<C003
0000000c<c<0<c<c00l0<c<c00<0000001TI6@0I6AT0400I6ATf000000`06ATI00<0000003<c<`0c
<c<01`0c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1o
Ogl01P1oOgl00`000000VIVI09VIV@0509VIV@030000002c/k<0/k>c00H0/k>c00<000000<c<c03<
c<`01`3<c<`00`000000i^KV0>KViP0:0>KViP030000003oool0oooo0340oooo00<000000>KViP3V
i^H04@3Vi^H00`000000c<c<0<c<c00?0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2I
VIT08@2IVIT00`000000Ogmo07moO`080?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0
103oool407moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c
03<c<`0?03<c<`030000000I6AT06ATI01006ATI=P00000<01TI6@030000000c<c<0<c<c00L0<c<c
00<0000004a<C01<C4`01P1<C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00H0Ogmo
00<0000009VIV@2IVIT01@2IVIT00`000000/k>c0;>c/`060;>c/`030000003<c<`0c<c<00L0c<c<
00<000000>KViP3Vi^H02P3Vi^H00`000000oooo0?ooo`0a0?ooo`030000003Vi^H0i^KV0100i^KV
00<000000<c<c03<c<`0403<c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI
00<0000007moO`1oOgl0203oool100000040oooo000G0?ooo`8000001@3oool407moO`030000001V
IVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c<`0@03<c<`030000000I
6AT06ATI01006ATI=@00000<01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01P1<
C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01@2I
VIT00`000000/k>c0;>c/`060;>c/`030000003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02P3V
i^H00`000000oooo0?ooo`0a0?ooo`030000003Vi^H0i^KV0100i^KV00<000000<c<c03<c<`0403<
c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI00<0000007moO`1oOgl01`3o
ool200000040oooo000G0?ooo`030000003oool0oooo00@0oooo101oOgl00`000000IVIV06IVIP0Q
06IVIP030000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0@
01TI6C@000003@0I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00H0C4a<00<00000
06IVIP1VIVH01@1VIVH00`000000Ogmo07moO`0607moO`030000002IVIT0VIVI00D0VIVI00<00000
0;>c/`2c/k<01P2c/k<00`000000c<c<0<c<c0070<c<c0030000003Vi^H0i^KV00/0i^KV00<00000
0?ooo`3oool0;`3oool00`000000i^KV0>KViP0A0>KViP030000003<c<`0c<c<0100c<c<00<00000
0;>c/`2c/k<04`2c/k<00`000000VIVI09VIV@0Q09VIV@030000001oOgl0Ogmo00P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?ooo`@0Ogmo00<0000006IVIP1VIVH08@1VIVH00`00
0000C4a<04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT04@0I6ATc0000
00d06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV
00D0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0509VIV@030000002c/k<0/k>c
00H0/k>c00<000000<c<c03<c<`01`3<c<`00`000000i^KV0>KViP0;0>KViP030000003oool0oooo
02l0oooo00<000000>KViP3Vi^H04@3Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c
01<0/k>c00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo07moO`080?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103oool407moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<
C4`04`1<C4`00`000000<c<c03<c<`0@03<c<`030000000I6AT06ATI01406ATI<`00000=01TI6@03
0000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01P1<C4`00`000000IVIV06IVIP0506IVIP03
0000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01@2IVIT00`000000/k>c0;>c/`060;>c/`03
0000003<c<`0c<c<00L0c<c<00<000000>KViP3Vi^H02`3Vi^H00`000000oooo0?ooo`0_0?ooo`03
0000003Vi^H0i^KV0140i^KV00<000000<c<c03<c<`0403<c<`00`000000/k>c0;>c/`0C0;>c/`03
0000002IVIT0VIVI0240VIVI00<0000007moO`1oOgl0203oool100000040oooo000G0?ooo`030000
003oool0oooo00@0oooo101oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<
00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0B01TI6C4000003P0I6AT00`000000<c<c
03<c<`0703<c<`030000001<C4`0C4a<00H0C4a<00<0000006IVIP1VIVH01@1VIVH00`000000Ogmo
07moO`0607moO`030000002IVIT0VIVI00D0VIVI00<000000;>c/`2c/k<01P2c/k<00`000000c<c<
0<c<c0070<c<c0030000003Vi^H0i^KV00`0i^KV00<000000?ooo`3oool0;@3oool00`000000i^KV
0>KViP0B0>KViP030000003<c<`0c<c<0100c<c<00<000000;>c/`2c/k<04`2c/k<00`000000VIVI
09VIV@0Q09VIV@030000001oOgl0Ogmo00P0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooo`@0Ogmo00<0000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00C04a<C0030000000c
<c<0<c<c00l0<c<c00<0000001TI6@0I6AT04`0I6AT_000000h06ATI00<0000003<c<`0c<c<0200c
<c<00`000000C4a<04a<C00604a<C0030000001VIVH0IVIV00D0IVIV00<0000007moO`1oOgl01P1o
Ogl00`000000VIVI09VIV@0509VIV@030000002c/k<0/k>c00H0/k>c00<000000<c<c03<c<`0203<
c<`00`000000i^KV0>KViP0;0>KViP030000003oool0oooo02`0oooo00<000000>KViP3Vi^H04P3V
i^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08@2I
VIT010000000Ogmo07moO`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103o
ool507moO`030000001VIVH0IVIV0240IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c
<`0@03<c<`030000000I6AT06ATI01<06ATI;P00000>01TI6@030000000c<c<0<c<c00L0<c<c00<0
000004a<C01<C4`01`1<C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00H0Ogmo00<0
000009VIV@2IVIT01@2IVIT00`000000/k>c0;>c/`070;>c/`030000003<c<`0c<c<00L0c<c<00<0
00000>KViP3Vi^H0303Vi^H00`000000oooo0?ooo`0Z0?ooo`030000003Vi^H0i^KV01<0i^KV00<0
00000<c<c03<c<`0403<c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0240VIVI00@0
000007moO`1oOgl0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo1@1o
Ogl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01<0C4a<00<0000003<c<`0c<c<0400c
<c<00`0000006ATI01TI6@0D01TI6B`000003`0I6AT00`000000<c<c03<c<`0703<c<`030000001<
C4`0C4a<00H0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo07moO`0607moO`030000002I
VIT0VIVI00D0VIVI00<000000;>c/`2c/k<01`2c/k<00`000000c<c<0<c<c0070<c<c0030000003V
i^H0i^KV00`0i^KV00<000000?ooo`3oool0:@3oool00`000000i^KV0>KViP0D0>KViP030000003<
c<`0c<c<0100c<c<00<000000;>c/`2c/k<04`2c/k<00`000000VIVI09VIV@0Q09VIV@040000001o
Ogl0Ogmo07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`D0Ogmo00<0
000006IVIP1VIVH08P1VIVH00`000000C4a<04a<C00C04a<C0030000000c<c<0<c<c0100<c<c00<0
000001TI6@0I6AT0500I6ATZ000000l06ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<
C00604a<C0030000001VIVH0IVIV00H0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VI
V@0609VIV@030000002c/k<0/k>c00H0/k>c00<000000<c<c03<c<`0203<c<`00`000000i^KV0>KV
iP0<0>KViP030000003oool0oooo02L0oooo00<000000>KViP3Vi^H0503Vi^H00`000000c<c<0<c<
c00@0<c<c0030000002c/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08P2IVIT010000000Ogmo07mo
O`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool507moO`030000001V
IVH0IVIV0280IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c<`0@03<c<`030000000I
6AT06ATI01D06ATI:000000@01TI6@030000000c<c<0<c<c00P0<c<c00<0000004a<C01<C4`01P1<
C4`00`000000IVIV06IVIP0606IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01P2I
VIT00`000000/k>c0;>c/`060;>c/`030000003<c<`0c<c<00P0c<c<00<000000>KViP3Vi^H03@3V
i^H2000002H0oooo00<000000>KViP3Vi^H05@3Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c
/k<0/k>c01<0/k>c00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo07moO`0207moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?ooo`H0Ogmo00<0000006IVIP1VIVH08@1VIVH0
0`000000C4a<04a<C00D04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT05@0I6ATU
000001806ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00604a<C0030000001VIVH0
IVIV00H0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0
/k>c00H0/k>c00<000000<c<c03<c<`0203<c<`00`000000i^KV0>KViP0?0>KViP030000003oool0
oooo0280oooo00<000000>KViP3Vi^H05@3Vi^H00`000000c<c<0<c<c00@0<c<c0030000002c/k<0
/k>c01@0/k>c00<0000009VIV@2IVIT08@2IVIT00`000000Ogmo07moO`0207moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?ooo`H0Ogmo00<0000006IVIP1VIVH08@1VIVH00`00
0000C4a<04a<C00D04a<C0030000000c<c<0<c<c0100<c<c00<0000001TI6@0I6AT05P0I6ATS0000
01806ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00704a<C0030000001VIVH0IVIV
00H0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0609VIV@030000002c/k<0/k>c
00H0/k>c00<000000<c<c03<c<`02@3<c<`00`000000i^KV0>KViP0?0>KViP8000008@3oool00`00
0000i^KV0>KViP0F0>KViP030000003<c<`0c<c<0100c<c<00<000000;>c/`2c/k<04`2c/k<00`00
0000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo0080Ogmo203oool100000040oooo000G0?ooo`03
0000003oool0oooo00@0oooo1P1oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0C4a<01<0
C4a<00<0000003<c<`0c<c<04@0c<c<00`0000006ATI01TI6@0F01TI6B4000004`0I6AT00`000000
<c<c03<c<`0803<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000
Ogmo07moO`0607moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01`2c/k<00`000000
c<c<0<c<c0080<c<c0030000003Vi^H0i^KV0140i^KV00<000000?ooo`3oool07@3oool00`000000
i^KV0>KViP0F0>KViP030000003<c<`0c<c<0140c<c<00<000000;>c/`2c/k<04`2c/k<00`000000
VIVI09VIV@0R09VIV@030000001oOgl0Ogmo0080Ogmo203oool100000040oooo000G0?ooo`030000
003oool0oooo00@0oooo1P1oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0C4a<01@0C4a<
00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0G01TI6Ah000005@0I6AT00`000000<c<c
03<c<`0803<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo
07moO`0607moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01`2c/k<00`000000c<c<
0<c<c0080<c<c0030000003Vi^H0i^KV0180i^KV00<000000?ooo`3oool06`3oool00`000000i^KV
0>KViP0F0>KViP030000003<c<`0c<c<0140c<c<00<000000;>c/`2c/k<0502c/k<00`000000VIVI
09VIV@0Q09VIV@030000001oOgl0Ogmo00<0Ogmo203oool100000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo1`1oOgl00`000000IVIV06IVIP0Q06IVIP030000001<C4`0C4a<01@0C4a<00<0
000003<c<`0c<c<04@0c<c<00`0000006ATI01TI6@0G01TI6A`000005P0I6AT00`000000<c<c03<c
<`0803<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH01P1VIVH00`000000Ogmo07mo
O`0607moO`030000002IVIT0VIVI00H0VIVI00<000000;>c/`2c/k<01`2c/k<00`000000c<c<0<c<
c0080<c<c0030000003Vi^H0i^KV01<0i^KV0P00000J0?ooo`030000003Vi^H0i^KV01L0i^KV00<0
00000<c<c03<c<`04@3<c<`00`000000/k>c0;>c/`0D0;>c/`030000002IVIT0VIVI0240VIVI00<0
000007moO`1oOgl00`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool7
07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`04`1<C4`00`000000<c<c03<c<`0B
03<c<`030000000I6AT06ATI01L06ATI6P00000F01TI6@030000000c<c<0<c<c00T0<c<c00<00000
04a<C01<C4`01P1<C4`00`000000IVIV06IVIP0706IVIP030000001oOgl0Ogmo00H0Ogmo00<00000
09VIV@2IVIT01P2IVIT00`000000/k>c0;>c/`070;>c/`030000003<c<`0c<c<00T0c<c<00<00000
0>KViP3Vi^H0503Vi^H00`000000oooo0?ooo`0F0?ooo`030000003Vi^H0i^KV01L0i^KV00<00000
0<c<c03<c<`04P3<c<`00`000000/k>c0;>c/`0C0;>c/`030000002IVIT0VIVI0280VIVI00<00000
07moO`1oOgl00`1oOgl80?ooo`4000000@3oool000X0oooo00<0omBK0000000000000`0000000`00
Vm@0oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo1`1oOgl00`000000IVIV06IVIP0R06IV
IP030000001<C4`0C4a<01@0C4a<00<0000003<c<`0c<c<04@0c<c<00`0000006ATI01TI6@0H01TI
6AL00000600I6AT00`000000<c<c03<c<`0903<c<`030000001<C4`0C4a<00H0C4a<00<0000006IV
IP1VIVH01`1VIVH00`000000Ogmo07moO`0607moO`030000002IVIT0VIVI00L0VIVI00<000000;>c
/`2c/k<01P2c/k<00`000000c<c<0<c<c0090<c<c0030000003Vi^H0i^KV01D0i^KV0P00000E0?oo
o`030000003Vi^H0i^KV01P0i^KV00<000000<c<c03<c<`04@3<c<`00`000000/k>c0;>c/`0D0;>c
/`030000002IVIT0VIVI0280VIVI00<0000007moO`1oOgl00`1oOgl80?ooo`4000000@3oool000d0
oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`040?ooo`L0Ogmo00<0000006IVIP1V
IVH08P1VIVH00`000000C4a<04a<C00D04a<C0030000000c<c<0<c<c0180<c<c00<0000001TI6@0I
6AT0600I6ATE000001T06ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00704a<C003
0000001VIVH0IVIV00L0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0709VIV@03
0000002c/k<0/k>c00L0/k>c00<000000<c<c03<c<`0203<c<`00`000000i^KV0>KViP0G0>KViP03
0000003oool0oooo0100oooo0P00000J0>KViP030000003<c<`0c<c<0180c<c<00<000000;>c/`2c
/k<0502c/k<00`000000VIVI09VIV@0Q09VIV@030000001oOgl0Ogmo00@0Ogmo203oool100000040
oooo000=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0103oool807moO`030000
001VIVH0IVIV0280IVIV00<0000004a<C01<C4`0501<C4`00`000000<c<c03<c<`0A03<c<`030000
000I6AT06ATI01X06ATI4P00000I01TI6@030000000c<c<0<c<c00T0<c<c00<0000004a<C01<C4`0
1`1<C4`00`000000IVIV06IVIP0706IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT0
1`2IVIT00`000000/k>c0;>c/`070;>c/`030000003<c<`0c<c<00T0c<c<00<000000>KViP3Vi^H0
5`3Vi^H2000000`0oooo1000000L0>KViP030000003<c<`0c<c<0140c<c<00<000000;>c/`2c/k<0
502c/k<00`000000VIVI09VIV@0R09VIV@030000001oOgl0Ogmo00@0Ogmo203oool100000040oooo
000=0?ooo`030;YbLP2jj_l0oooo00L0oooo0`0000040?ooo`P0Ogmo00<0000006IVIP1VIVH08P1V
IVH00`000000C4a<04a<C00D04a<C0030000000c<c<0<c<c0180<c<c00<0000001TI6@0I6AT07@0I
6AT<000001/06ATI00<0000003<c<`0c<c<02@0c<c<00`000000C4a<04a<C00704a<C0030000001V
IVH0IVIV00L0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0709VIV@030000002c
/k<0/k>c00L0/k>c00<000000<c<c03<c<`02@3<c<`00`000000i^KV0>KViP0I0>KViP`000007`3V
i^H00`000000c<c<0<c<c00B0<c<c0030000002c/k<0/k>c01@0/k>c00<0000009VIV@2IVIT08P2I
VIT00`000000Ogmo07moO`0407moO`H0oooo0`0000010?ooo`003@3oool00`2jLW80^^[o0?ooo`07
0?ooo`030000003oool0oooo00@0oooo201oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0
C4a<01D0C4a<00<0000003<c<`0c<c<04P0c<c<00`0000006ATI01TI6@1201TI6@030000000c<c<0
<c<c00X0<c<c00<0000004a<C01<C4`01`1<C4`00`000000IVIV06IVIP0706IVIP030000001oOgl0
Ogmo00H0Ogmo00<0000009VIV@2IVIT01`2IVIT00`000000/k>c0;>c/`070;>c/`030000003<c<`0
c<c<00X0c<c<00<000000>KViP3Vi^H0@P3Vi^H00`000000c<c<0<c<c00B0<c<c0030000002c/k<0
/k>c01@0/k>c00<0000009VIV@2IVIT08`2IVIT00`000000Ogmo07moO`0407moO`P0oooo0@000001
0?ooo`003@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo00@0oooo2@1oOgl00`00
0000IVIV06IVIP0R06IVIP030000001<C4`0C4a<01@0C4a<00<0000003<c<`0c<c<04`0c<c<00`00
00006ATI01TI6@1001TI6@030000000c<c<0<c<c00X0<c<c00<0000004a<C01<C4`0201<C4`00`00
0000IVIV06IVIP0706IVIP030000001oOgl0Ogmo00H0Ogmo00<0000009VIV@2IVIT01`2IVIT00`00
0000/k>c0;>c/`080;>c/`030000003<c<`0c<c<00X0c<c<00<000000>KViP3Vi^H0@03Vi^H00`00
0000c<c<0<c<c00B0<c<c0030000002c/k<0/k>c01D0/k>c00<0000009VIV@2IVIT08P2IVIT00`00
0000Ogmo07moO`0507moO`P0oooo0@0000010?ooo`003@3oool00`2jLW80^^[o0?ooo`070?ooo`03
0000003oool0oooo00@0oooo2@1oOgl00`000000IVIV06IVIP0R06IVIP030000001<C4`0C4a<01D0
C4a<00<0000003<c<`0c<c<04`0c<c<00`0000006ATI01TI6@0n01TI6@030000000c<c<0<c<c00/0
<c<c00<0000004a<C01<C4`01`1<C4`00`000000IVIV06IVIP0806IVIP030000001oOgl0Ogmo00H0
Ogmo00<0000009VIV@2IVIT01`2IVIT00`000000/k>c0;>c/`080;>c/`030000003<c<`0c<c<00/0
c<c<00<000000>KViP3Vi^H0?P3Vi^H00`000000c<c<0<c<c00C0<c<c0030000002c/k<0/k>c01@0
/k>c00<0000009VIV@2IVIT08`2IVIT00`000000Ogmo07moO`0507moO`P0oooo0@0000010?ooo`00
2P3oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool0103oool907moO`03
0000001VIVH0IVIV02<0IVIV00<0000004a<C01<C4`05@1<C4`00`000000<c<c03<c<`0C03<c<`03
0000000I6AT06ATI03`06ATI00<0000003<c<`0c<c<02`0c<c<00`000000C4a<04a<C00804a<C003
0000001VIVH0IVIV00P0IVIV00<0000007moO`1oOgl01P1oOgl00`000000VIVI09VIV@0809VIV@03
0000002c/k<0/k>c00P0/k>c00<000000<c<c03<c<`02P3<c<`00`000000i^KV0>KViP0m0>KViP03
0000003<c<`0c<c<01<0c<c<00<000000;>c/`2c/k<05@2c/k<00`000000VIVI09VIV@0S09VIV@03
0000001oOgl0Ogmo00D0Ogmo203oool100000040oooo000<0?ooo`030>ZjLP000780^^[o00P0oooo
00<000000?ooo`3oool0103oool:07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`0
5P1<C4`00`000000<c<c03<c<`0C03<c<`030000000I6AT06ATI03X06ATI00<0000003<c<`0c<c<0
300c<c<00`000000C4a<04a<C00804a<C0030000001VIVH0IVIV00P0IVIV00<0000007moO`1oOgl0
1P1oOgl00`000000VIVI09VIV@0809VIV@030000002c/k<0/k>c00P0/k>c00<000000<c<c03<c<`0
2`3<c<`00`000000i^KV0>KViP0j0>KViP8000005@3<c<`00`000000/k>c0;>c/`0E0;>c/`030000
002IVIT0VIVI02<0VIVI00<0000007moO`1oOgl01P1oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103oool:07moO`030000001VIVH0IVIV0280IVIV00<0000004a<C01<C4`05P1<
C4`00`000000<c<c03<c<`0D03<c<`030000000I6AT06ATI03P06ATI00<0000003<c<`0c<c<03@0c
<c<00`000000C4a<04a<C00804a<C0030000001VIVH0IVIV00P0IVIV00<0000007moO`1oOgl01P1o
Ogl00`000000VIVI09VIV@0809VIV@030000002c/k<0/k>c00P0/k>c00<000000<c<c03<c<`0303<
c<`00`000000i^KV0>KViP0h0>KViP030000003<c<`0c<c<01@0c<c<00<000000;>c/`2c/k<05P2c
/k<00`000000VIVI09VIV@0S09VIV@030000001oOgl0Ogmo00H0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo2P1oOgl00`000000IVIV06IVIP0S06IVIP030000001<C4`0
C4a<01H0C4a<00<0000003<c<`0c<c<0500c<c<00`0000006ATI01TI6@0f01TI6@030000000c<c<0
<c<c00d0<c<c00<0000004a<C01<C4`02@1<C4`00`000000IVIV06IVIP0806IVIP030000001oOgl0
Ogmo00H0Ogmo00<0000009VIV@2IVIT0202IVIT00`000000/k>c0;>c/`090;>c/`030000003<c<`0
c<c<00`0c<c<00<000000>KViP3Vi^H0=P3Vi^H00`000000c<c<0<c<c00E0<c<c0030000002c/k<0
/k>c01D0/k>c00<0000009VIV@2IVIT0902IVIT00`000000Ogmo07moO`0607moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?ooo`/0Ogmo00<0000006IVIP1VIVH08P1VIVH00`00
0000C4a<04a<C00G04a<C0030000000c<c<0<c<c01@0<c<c00<0000001TI6@0I6AT0=@0I6AT00`00
0000<c<c03<c<`0=03<c<`030000001<C4`0C4a<00T0C4a<00<0000006IVIP1VIVH0201VIVH00`00
0000Ogmo07moO`0607moO`030000002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<02@2c/k<00`00
0000c<c<0<c<c00=0<c<c0030000003Vi^H0i^KV03@0i^KV00<000000<c<c03<c<`05@3<c<`00`00
0000/k>c0;>c/`0F0;>c/`030000002IVIT0VIVI02<0VIVI00<0000007moO`1oOgl01`1oOgl80?oo
o`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool;07moO`030000001VIVH0IVIV02<0
IVIV00<0000004a<C01<C4`05P1<C4`00`000000<c<c03<c<`0E03<c<`030000000I6AT06ATI03<0
6ATI00<0000003<c<`0c<c<03@0c<c<00`000000C4a<04a<C00904a<C0030000001VIVH0IVIV00P0
IVIV00<0000007moO`1oOgl0201oOgl00`000000VIVI09VIV@0709VIV@030000002c/k<0/k>c00X0
/k>c00<000000<c<c03<c<`03@3<c<`00`000000i^KV0>KViP0b0>KViP030000003<c<`0c<c<01D0
c<c<00<000000;>c/`2c/k<05P2c/k<00`000000VIVI09VIV@0T09VIV@030000001oOgl0Ogmo00L0
Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo301oOgl00`000000IVIV
06IVIP0R06IVIP030000001<C4`0C4a<01L0C4a<00<0000003<c<`0c<c<05@0c<c<2000003806ATI
00<0000003<c<`0c<c<03P0c<c<00`000000C4a<04a<C00904a<C0030000001VIVH0IVIV00P0IVIV
00<0000007moO`1oOgl0201oOgl00`000000VIVI09VIV@0809VIV@030000002c/k<0/k>c00T0/k>c
00<000000<c<c03<c<`03P3<c<`00`000000i^KV0>KViP0_0>KViP8000005`3<c<`00`000000/k>c
0;>c/`0G0;>c/`030000002IVIT0VIVI02<0VIVI00<0000007moO`1oOgl0201oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103oool<07moO`030000001VIVH0IVIV02<0IVIV00<0
000004a<C01<C4`05`1<C4`00`000000<c<c03<c<`0F03<c<`800000;`0I6AT00`000000<c<c03<c
<`0>03<c<`030000001<C4`0C4a<00X0C4a<00<0000006IVIP1VIVH0201VIVH00`000000Ogmo07mo
O`0807moO`030000002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<02P2c/k<00`000000c<c<0<c<
c00=0<c<c0030000003Vi^H0i^KV02h0i^KV00<000000<c<c03<c<`05`3<c<`00`000000/k>c0;>c
/`0F0;>c/`030000002IVIT0VIVI02@0VIVI00<0000007moO`1oOgl0201oOgl80?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103oool<07moO`030000001VIVH0IVIV02<0IVIV00<00000
04a<C01<C4`05`1<C4`00`000000<c<c03<c<`0H03<c<`030000000I6AT06ATI02/06ATI00<00000
03<c<`0c<c<03`0c<c<00`000000C4a<04a<C00:04a<C0030000001VIVH0IVIV00P0IVIV00<00000
07moO`1oOgl0201oOgl00`000000VIVI09VIV@0809VIV@030000002c/k<0/k>c00X0/k>c00<00000
0<c<c03<c<`03P3<c<`00`000000i^KV0>KViP0[0>KViP8000006@3<c<`00`000000/k>c0;>c/`0G
0;>c/`030000002IVIT0VIVI02@0VIVI00<0000007moO`1oOgl0201oOgl80?ooo`4000000@3oool0
01L0oooo00<000000?ooo`3oool0103oool=07moO`030000001VIVH0IVIV02<0IVIV00<0000004a<
C01<C4`05`1<C4`00`000000<c<c03<c<`0H03<c<`800000:P0I6AT00`000000<c<c03<c<`0@03<c
<`030000001<C4`0C4a<00X0C4a<00<0000006IVIP1VIVH0201VIVH00`000000Ogmo07moO`0807mo
O`030000002IVIT0VIVI00P0VIVI00<000000;>c/`2c/k<02P2c/k<00`000000c<c<0<c<c00?0<c<
c0030000003Vi^H0i^KV02T0i^KV00<000000<c<c03<c<`0603<c<`00`000000/k>c0;>c/`0G0;>c
/`030000002IVIT0VIVI02@0VIVI00<0000007moO`1oOgl02@1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103oool=07moO`030000001VIVH0IVIV02@0IVIV00<0000004a<C01<
C4`05`1<C4`00`000000<c<c03<c<`0I03<c<`030000000I6AT06ATI02H06ATI00<0000003<c<`0c
<c<0400c<c<00`000000C4a<04a<C00;04a<C0030000001VIVH0IVIV00P0IVIV00<0000007moO`1o
Ogl0201oOgl00`000000VIVI09VIV@0809VIV@030000002c/k<0/k>c00/0/k>c00<000000<c<c03<
c<`03`3<c<`00`000000i^KV0>KViP0V0>KViP8000006P3<c<`00`000000/k>c0;>c/`0H0;>c/`03
0000002IVIT0VIVI02@0VIVI00<0000007moO`1oOgl02@1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103oool=07moO`030000001VIVH0IVIV02D0IVIV00<0000004a<C01<C4`0
5`1<C4`00`000000<c<c03<c<`0I03<c<`800000900I6AT2000001<0<c<c00<0000004a<C01<C4`0
2P1<C4`00`000000IVIV06IVIP0906IVIP030000001oOgl0Ogmo00P0Ogmo00<0000009VIV@2IVIT0
2@2IVIT00`000000/k>c0;>c/`0:0;>c/`030000003<c<`0c<c<0100c<c<0P00000U0>KViP030000
003<c<`0c<c<01X0c<c<00<000000;>c/`2c/k<05`2c/k<00`000000VIVI09VIV@0U09VIV@030000
001oOgl0Ogmo00T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo3P1o
Ogl00`000000IVIV06IVIP0T06IVIP030000001<C4`0C4a<01L0C4a<00<0000003<c<`0c<c<06`0c
<c<2000002006ATI0P00000D03<c<`030000001<C4`0C4a<00/0C4a<00<0000006IVIP1VIVH02@1V
IVH00`000000Ogmo07moO`0807moO`030000002IVIT0VIVI00T0VIVI00<000000;>c/`2c/k<02`2c
/k<00`000000c<c<0<c<c00A0<c<c08000008@3Vi^H2000001`0c<c<00<000000;>c/`2c/k<0602c
/k<00`000000VIVI09VIV@0T09VIV@030000001oOgl0Ogmo00X0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo3P1oOgl00`000000IVIV06IVIP0U06IVIP030000001<C4`0
C4a<01L0C4a<00<0000003<c<`0c<c<0700c<c<2000001`06ATI0P00000F03<c<`030000001<C4`0
C4a<00/0C4a<00<0000006IVIP1VIVH02@1VIVH00`000000Ogmo07moO`0807moO`030000002IVIT0
VIVI00T0VIVI00<000000;>c/`2c/k<02`2c/k<00`000000c<c<0<c<c00C0<c<c0<00000703Vi^H2
000001d0c<c<00<000000;>c/`2c/k<0602c/k<00`000000VIVI09VIV@0U09VIV@030000001oOgl0
Ogmo00X0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo3`1oOgl00`00
0000IVIV06IVIP0U06IVIP030000001<C4`0C4a<01L0C4a<0P00000N03<c<`H000004P0I6AT40000
01L0<c<c00<0000004a<C01<C4`0301<C4`00`000000IVIV06IVIP0906IVIP030000001oOgl0Ogmo
00P0Ogmo00<0000009VIV@2IVIT02@2IVIT00`000000/k>c0;>c/`0<0;>c/`030000003<c<`0c<c<
01D0c<c<1000000B0>KViPH000007P3<c<`00`000000/k>c0;>c/`0H0;>c/`030000002IVIT0VIVI
02D0VIVI00<0000007moO`1oOgl02`1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3o
ool0103oool?07moO`030000001VIVH0IVIV02H0IVIV00<0000004a<C01<C4`0601<C4`00`000000
<c<c03<c<`0Q03<c<`P000001P0I6AT4000001X0<c<c00<0000004a<C01<C4`0301<C4`00`000000
IVIV06IVIP0:06IVIP030000001oOgl0Ogmo00P0Ogmo00<0000009VIV@2IVIT02P2IVIT00`000000
/k>c0;>c/`0<0;>c/`030000003<c<`0c<c<01P0c<c<100000060>KViPP000008P3<c<`2000001X0
/k>c00<0000009VIV@2IVIT09P2IVIT00`000000Ogmo07moO`0;07moO`P0oooo0@0000010?ooo`00
5`3oool2000000D0oooo401oOgl00`000000IVIV06IVIP0V06IVIP030000001<C4`0C4a<01P0C4a<
0P00000Y03<c<`H000007@0c<c<00`000000C4a<04a<C00=04a<C0030000001VIVH0IVIV00X0IVIV
00<0000007moO`1oOgl0201oOgl00`000000VIVI09VIV@0:09VIV@030000002c/k<0/k>c00d0/k>c
00<000000<c<c03<c<`06`3<c<`6000002T0c<c<00<000000;>c/`2c/k<06@2c/k<00`000000VIVI
09VIV@0V09VIV@030000001oOgl0Ogmo00`0Ogmo1`3oool200000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo401oOgl00`000000IVIV06IVIP0V06IVIP030000001<C4`0C4a<01X0C4a<00<0
000003<c<`0c<c<0B00c<c<00`000000C4a<04a<C00=04a<C0030000001VIVH0IVIV00X0IVIV00<0
000007moO`1oOgl02@1oOgl00`000000VIVI09VIV@0:09VIV@030000002c/k<0/k>c00h0/k>c00<0
00000<c<c03<c<`0B03<c<`00`000000/k>c0;>c/`0J0;>c/`030000002IVIT0VIVI02H0VIVI00<0
000007moO`1oOgl0301oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolA
07moO`030000001VIVH0IVIV02H0IVIV00<0000004a<C01<C4`06P1<C4`00`000000<c<c03<c<`16
03<c<`030000001<C4`0C4a<00h0C4a<00<0000006IVIP1VIVH02P1VIVH00`000000Ogmo07moO`0:
07moO`030000002IVIT0VIVI00X0VIVI00<000000;>c/`2c/k<03P2c/k<00`000000c<c<0<c<c015
0<c<c0800000702c/k<00`000000VIVI09VIV@0V09VIV@030000001oOgl0Ogmo00d0Ogmo203oool1
00000040oooo000G0?ooo`030000003oool0oooo00@0oooo4P1oOgl00`000000IVIV06IVIP0V06IV
IP030000001<C4`0C4a<01X0C4a<0P00001503<c<`030000001<C4`0C4a<00l0C4a<00<0000006IV
IP1VIVH02P1VIVH00`000000Ogmo07moO`0:07moO`030000002IVIT0VIVI00X0VIVI00<000000;>c
/`2c/k<03`2c/k<00`000000c<c<0<c<c0130<c<c0030000002c/k<0/k>c01/0/k>c00<0000009VI
V@2IVIT09P2IVIT00`000000Ogmo07moO`0>07moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?oooa80Ogmo00<0000006IVIP1VIVH09`1VIVH00`000000C4a<04a<C00K04a<C003
0000000c<c<0<c<c0440<c<c00<0000004a<C01<C4`03`1<C4`00`000000IVIV06IVIP0;06IVIP03
0000001oOgl0Ogmo00X0Ogmo00<0000009VIV@2IVIT02`2IVIT00`000000/k>c0;>c/`0?0;>c/`03
0000003<c<`0c<c<0400c<c<0P00000M0;>c/`030000002IVIT0VIVI02L0VIVI00<0000007moO`1o
Ogl03P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolC07moO`030000
001VIVH0IVIV02L0IVIV00<0000004a<C01<C4`06`1<C4`00`000000<c<c03<c<`0o03<c<`030000
001<C4`0C4a<0100C4a<00<0000006IVIP1VIVH02`1VIVH00`000000Ogmo07moO`0:07moO`030000
002IVIT0VIVI00/0VIVI00<000000;>c/`2c/k<0402c/k<00`000000c<c<0<c<c00n0<c<c0030000
002c/k<0/k>c01`0/k>c00<0000009VIV@2IVIT09`2IVIT00`000000Ogmo07moO`0?07moO`P0oooo
0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooa<0Ogmo00<0000006IVIP1VIVH0:01V
IVH00`000000C4a<04a<C00K04a<C0800000?@0c<c<2000001<0C4a<00<0000006IVIP1VIVH02`1V
IVH00`000000Ogmo07moO`0:07moO`030000002IVIT0VIVI00/0VIVI00<000000;>c/`2c/k<04@2c
/k<2000003`0c<c<0P00000N0;>c/`030000002IVIT0VIVI02P0VIVI00<0000007moO`1oOgl03`1o
Ogl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolD07moO`030000001VIVH0
IVIV02P0IVIV00<0000004a<C01<C4`0701<C4`00`000000<c<c03<c<`0i03<c<`030000001<C4`0
C4a<0180C4a<00<0000006IVIP1VIVH0301VIVH00`000000Ogmo07moO`0:07moO`030000002IVIT0
VIVI00`0VIVI00<000000;>c/`2c/k<04P2c/k<00`000000c<c<0<c<c00h0<c<c0030000002c/k<0
/k>c01d0/k>c00<0000009VIV@2IVIT0:02IVIT00`000000Ogmo07moO`0@07moO`P0oooo0@000001
0?ooo`005`3oool00`000000oooo0?ooo`040?oooa@0Ogmo00<0000006IVIP1VIVH0:01VIVH00`00
0000C4a<04a<C00M04a<C0030000000c<c<0<c<c03L0<c<c00<0000004a<C01<C4`04`1<C4`00`00
0000IVIV06IVIP0<06IVIP030000001oOgl0Ogmo00X0Ogmo00<0000009VIV@2IVIT0302IVIT00`00
0000/k>c0;>c/`0C0;>c/`030000003<c<`0c<c<03H0c<c<00<000000;>c/`2c/k<07P2c/k<00`00
0000VIVI09VIV@0X09VIV@030000001oOgl0Ogmo0100Ogmo203oool100000040oooo000G0?ooo`03
0000003oool0oooo00@0oooo5@1oOgl00`000000IVIV06IVIP0X06IVIP030000001<C4`0C4a<01d0
C4a<0P00000f03<c<`030000001<C4`0C4a<01<0C4a<00<0000006IVIP1VIVH0301VIVH00`000000
Ogmo07moO`0;07moO`030000002IVIT0VIVI00`0VIVI00<000000;>c/`2c/k<0502c/k<00`000000
c<c<0<c<c00c0<c<c0800000802c/k<00`000000VIVI09VIV@0X09VIV@030000001oOgl0Ogmo0140
Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo5@1oOgl00`000000IVIV
06IVIP0Y06IVIP030000001<C4`0C4a<01h0C4a<00<0000003<c<`0c<c<0<P0c<c<00`000000C4a<
04a<C00D04a<C0030000001VIVH0IVIV00`0IVIV00<0000007moO`1oOgl0301oOgl00`000000VIVI
09VIV@0<09VIV@030000002c/k<0/k>c01@0/k>c00<000000<c<c03<c<`0<@3<c<`00`000000/k>c
0;>c/`0O0;>c/`030000002IVIT0VIVI02T0VIVI00<0000007moO`1oOgl04@1oOgl80?ooo`400000
0@3oool001L0oooo00<000000?ooo`3oool0103ooolF07moO`030000001VIVH0IVIV02T0IVIV00<0
000004a<C01<C4`07P1<C4`200000340<c<c00<0000004a<C01<C4`05@1<C4`00`000000IVIV06IV
IP0<06IVIP030000001oOgl0Ogmo00`0Ogmo00<0000009VIV@2IVIT0302IVIT00`000000/k>c0;>c
/`0E0;>c/`030000003<c<`0c<c<02h0c<c<0P00000Q0;>c/`030000002IVIT0VIVI02T0VIVI00<0
000007moO`1oOgl04P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolF
07moO`030000001VIVH0IVIV02T0IVIV00<0000004a<C01<C4`0801<C4`2000002h0<c<c00<00000
04a<C01<C4`05@1<C4`00`000000IVIV06IVIP0=06IVIP030000001oOgl0Ogmo00`0Ogmo00<00000
09VIV@2IVIT03@2IVIT00`000000/k>c0;>c/`0E0;>c/`030000003<c<`0c<c<02/0c<c<0P00000R
0;>c/`030000002IVIT0VIVI02X0VIVI00<0000007moO`1oOgl04P1oOgl80?ooo`4000000@3oool0
01L0oooo00<000000?ooo`3oool0103ooolG07moO`030000001VIVH0IVIV02T0IVIV00<0000004a<
C01<C4`08@1<C4`3000002P0<c<c0`00000H04a<C0030000001VIVH0IVIV00d0IVIV00<0000007mo
O`1oOgl0301oOgl00`000000VIVI09VIV@0=09VIV@030000002c/k<0/k>c01H0/k>c0P00000Y0<c<
c0800000902c/k<00`000000VIVI09VIV@0Y09VIV@030000001oOgl0Ogmo01<0Ogmo203oool10000
0040oooo000G0?ooo`030000003oool0oooo00@0oooo601oOgl00`000000IVIV06IVIP0Y06IVIP03
0000001<C4`0C4a<02<0C4a<0`00000R03<c<`<000006P1<C4`00`000000IVIV06IVIP0>06IVIP03
0000001oOgl0Ogmo00`0Ogmo00<0000009VIV@2IVIT03P2IVIT00`000000/k>c0;>c/`0G0;>c/`@0
00008P3<c<`3000002D0/k>c00<0000009VIV@2IVIT0:@2IVIT00`000000Ogmo07moO`0D07moO`P0
oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooaP0Ogmo00<0000006IVIP1VIVH0
:P1VIVH2000002H0C4a<0P00000M03<c<`<00000701<C4`00`000000IVIV06IVIP0?06IVIP030000
001oOgl0Ogmo00`0Ogmo00<0000009VIV@2IVIT03P2IVIT00`000000/k>c0;>c/`0K0;>c/`<00000
7@3<c<`2000002H0/k>c0P00000/09VIV@030000001oOgl0Ogmo01@0Ogmo203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0oooo6@1oOgl00`000000IVIV06IVIP0[06IVIP030000001<
C4`0C4a<02D0C4a<0`00000F03<c<`@000007`1<C4`00`000000IVIV06IVIP0>06IVIP030000001o
Ogl0Ogmo00h0Ogmo00<0000009VIV@2IVIT03P2IVIT00`000000/k>c0;>c/`0M0;>c/`<000005`3<
c<`3000002L0/k>c00<0000009VIV@2IVIT0:`2IVIT00`000000Ogmo07moO`0E07moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?oooaX0Ogmo00<0000006IVIP1VIVH0:`1VIVH0
0`000000C4a<04a<C00W04a<C0T000002P0c<c<300000280C4a<00<0000006IVIP1VIVH03`1VIVH0
0`000000Ogmo07moO`0>07moO`030000002IVIT0VIVI00l0VIVI00<000000;>c/`2c/k<07`2c/k<4
000000X0c<c<2@00000Y0;>c/`030000002IVIT0VIVI02/0VIVI00<0000007moO`1oOgl05P1oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolK07moO`030000001VIVH0IVIV
02/0IVIV00<0000004a<C01<C4`0;`1<C4`:000002@0C4a<00<0000006IVIP1VIVH0401VIVH00`00
0000Ogmo07moO`0>07moO`030000002IVIT0VIVI0100VIVI00<000000;>c/`2c/k<08P2c/k<:0000
0340/k>c00<0000009VIV@2IVIT0:`2IVIT00`000000Ogmo07moO`0G07moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?oooa/0Ogmo00<0000006IVIP1VIVH0;01VIVH2000005`0
C4a<00<0000006IVIP1VIVH04@1VIVH00`000000Ogmo07moO`0>07moO`030000002IVIT0VIVI0100
VIVI00<000000;>c/`2c/k<0F`2c/k<2000002h0VIVI00<0000007moO`1oOgl05`1oOgl80?ooo`40
00000@3oool001L0oooo0P0000050?oooa`0Ogmo00<0000006IVIP1VIVH0;@1VIVH00`000000C4a<
04a<C01I04a<C0030000001VIVH0IVIV0140IVIV00<0000007moO`1oOgl03P1oOgl00`000000VIVI
09VIV@0A09VIV@030000002c/k<0/k>c05T0/k>c00<0000009VIV@2IVIT0;@2IVIT00`000000Ogmo
07moO`0H07moO`L0oooo0P0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooad0Ogmo00<0
000006IVIP1VIVH0;@1VIVH00`000000C4a<04a<C01G04a<C0030000001VIVH0IVIV0140IVIV00<0
000007moO`1oOgl03`1oOgl00`000000VIVI09VIV@0B09VIV@030000002c/k<0/k>c05L0/k>c00<0
000009VIV@2IVIT0;@2IVIT00`000000Ogmo07moO`0I07moO`P0oooo0@0000010?ooo`005`3oool0
0`000000oooo0?ooo`040?oooad0Ogmo00<0000006IVIP1VIVH0;P1VIVH00`000000C4a<04a<C01E
04a<C0030000001VIVH0IVIV0180IVIV00<0000007moO`1oOgl0401oOgl00`000000VIVI09VIV@0B
09VIV@030000002c/k<0/k>c05D0/k>c00<0000009VIV@2IVIT0;P2IVIT00`000000Ogmo07moO`0I
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oooah0Ogmo00<0000006IV
IP1VIVH0;P1VIVH2000005@0C4a<00<0000006IVIP1VIVH04`1VIVH00`000000Ogmo07moO`0@07mo
O`030000002IVIT0VIVI0180VIVI00<000000;>c/`2c/k<0D`2c/k<200000300VIVI00<0000007mo
O`1oOgl06P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolO07moO`03
0000001VIVH0IVIV02l0IVIV00<0000004a<C01<C4`0D@1<C4`00`000000IVIV06IVIP0C06IVIP03
0000001oOgl0Ogmo0100Ogmo00<0000009VIV@2IVIT04`2IVIT00`000000/k>c0;>c/`1A0;>c/`03
0000002IVIT0VIVI02l0VIVI00<0000007moO`1oOgl06`1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103ooolP07moO`030000001VIVH0IVIV02l0IVIV00<0000004a<C01<C4`0
C`1<C4`00`000000IVIV06IVIP0D06IVIP030000001oOgl0Ogmo0100Ogmo00<0000009VIV@2IVIT0
502IVIT00`000000/k>c0;>c/`1?0;>c/`030000002IVIT0VIVI02l0VIVI00<0000007moO`1oOgl0
701oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolP07moO`030000001V
IVH0IVIV0300IVIV0P00001>04a<C0030000001VIVH0IVIV01D0IVIV00<0000007moO`1oOgl0401o
Ogl00`000000VIVI09VIV@0E09VIV@030000002c/k<0/k>c04`0/k>c0P00000b09VIV@030000001o
Ogl0Ogmo01`0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo8@1oOgl0
0`000000IVIV06IVIP0a06IVIP800000B`1<C4`00`000000IVIV06IVIP0E06IVIP030000001oOgl0
Ogmo0180Ogmo00<0000009VIV@2IVIT0502IVIT00`000000/k>c0;>c/`1:0;>c/`800000<`2IVIT0
0`000000Ogmo07moO`0M07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?oo
ob80Ogmo00<0000006IVIP1VIVH0<P1VIVH2000004P0C4a<00<0000006IVIP1VIVH05P1VIVH00`00
0000Ogmo07moO`0B07moO`030000002IVIT0VIVI01D0VIVI00<000000;>c/`2c/k<0A`2c/k<20000
03<0VIVI0P00000P07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooob<0
Ogmo00<0000006IVIP1VIVH0<`1VIVH00`000000C4a<04a<C01404a<C0030000001VIVH0IVIV01L0
IVIV00<0000007moO`1oOgl04P1oOgl00`000000VIVI09VIV@0F09VIV@030000002c/k<0/k>c04D0
/k>c00<0000009VIV@2IVIT0<P2IVIT00`000000Ogmo07moO`0P07moO`P0oooo0@0000010?ooo`00
5`3oool00`000000oooo0?ooo`040?ooob@0Ogmo00<0000006IVIP1VIVH0<`1VIVH200000480C4a<
0P00000J06IVIP030000001oOgl0Ogmo0180Ogmo00<0000009VIV@2IVIT05`2IVIT2000004<0/k>c
0P00000d09VIV@030000001oOgl0Ogmo0240Ogmo203oool100000040oooo000G0?ooo`030000003o
ool0oooo00@0oooo9@1oOgl00`000000IVIV06IVIP0d06IVIP800000?P1<C4`2000001/0IVIV00<0
000007moO`1oOgl0501oOgl00`000000VIVI09VIV@0H09VIV@800000?`2c/k<2000003D0VIVI00<0
000007moO`1oOgl08P1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooolV
07moO`030000001VIVH0IVIV03D0IVIV0P00000j04a<C08000007@1VIVH00`000000Ogmo07moO`0D
07moO`030000002IVIT0VIVI01X0VIVI0P00000k0;>c/`800000=P2IVIT00`000000Ogmo07moO`0S
07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobL0Ogmo00<0000006IV
IP1VIVH0=P1VIVH2000003H0C4a<0P00000N06IVIP030000001oOgl0Ogmo01H0Ogmo00<0000009VI
V@2IVIT06`2IVIT2000003L0/k>c0P00000g09VIV@030000001oOgl0Ogmo02@0Ogmo203oool10000
0040oooo000G0?ooo`030000003oool0oooo00@0oooo:01oOgl00`000000IVIV06IVIP0g06IVIP<0
0000<@1<C4`200000200IVIV00<0000007moO`1oOgl05P1oOgl00`000000VIVI09VIV@0M09VIV@80
0000<P2c/k<3000003P0VIVI00<0000007moO`1oOgl09@1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103ooolY07moO`030000001VIVH0IVIV03T0IVIV1000000[04a<C0800000
8P1VIVH00`000000Ogmo07moO`0F07moO`030000002IVIT0VIVI01l0VIVI0P00000/0;>c/`@00000
>P2IVIT00`000000Ogmo07moO`0V07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?oo
o`040?ooobX0Ogmo00<0000006IVIP1VIVH0?01VIVH4000002@0C4a<0`00000S06IVIP030000001o
Ogl0Ogmo01P0Ogmo00<0000009VIV@2IVIT0802IVIT3000002D0/k>c1000000m09VIV@030000001o
Ogl0Ogmo02L0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo:`1oOgl0
0`000000IVIV06IVIP0o06IVIP@000006`1<C4`5000002H0IVIV00<0000007moO`1oOgl0601oOgl0
0`000000VIVI09VIV@0S09VIV@H000006`2c/k<400000400VIVI00<0000007moO`1oOgl0:01oOgl8
0?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool/07moO`030000001VIVH0IVIV
0480IVIV2P00000;04a<C0H00000:P1VIVH00`000000Ogmo07moO`0J07moO`030000002IVIT0VIVI
02P0VIVI1P00000;0;>c/`X00000@`2IVIT00`000000Ogmo07moO`0Y07moO`P0oooo0@0000010?oo
o`005`3oool2000000D0oooo;@1oOgl00`000000IVIV06IVIP1;06IVIP/00000<01VIVH00`000000
Ogmo07moO`0J07moO`030000002IVIT0VIVI02h0VIVI2`00001<09VIV@030000001oOgl0Ogmo02X0
Ogmo1`3oool200000040oooo000G0?ooo`030000003oool0oooo00@0oooo;P1oOgl00`000000IVIV
06IVIP2506IVIP030000001oOgl0Ogmo01X0Ogmo00<0000009VIV@2IVIT0Q02IVIT00`000000Ogmo
07moO`0[07moO`P0oooo0@0000010?ooo`005`3oool00`000000oooo0?ooo`040?ooobl0Ogmo00<0
000006IVIP1VIVH0P`1VIVH00`000000Ogmo07moO`0L07moO`030000002IVIT0VIVI0880VIVI00<0
000007moO`1oOgl0;01oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103oool`
07moO`030000001VIVH0IVIV0880IVIV00<0000007moO`1oOgl0701oOgl00`000000VIVI09VIV@21
09VIV@030000001oOgl0Ogmo02d0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo
00@0oooo<@1oOgl00`000000IVIV06IVIP2006IVIP030000001oOgl0Ogmo01h0Ogmo00<0000009VI
V@2IVIT0O`2IVIT00`000000Ogmo07moO`0^07moO`P0oooo0@0000010?ooo`005`3oool00`000000
oooo0?ooo`040?oooc80Ogmo00<0000006IVIP1VIVH0O`1VIVH00`000000Ogmo07moO`0N07moO`03
0000002IVIT0VIVI07h0VIVI00<0000007moO`1oOgl0;`1oOgl80?ooo`4000000@3oool001L0oooo
00<000000?ooo`3oool0103ooolc07moO`030000001VIVH0IVIV07d0IVIV00<0000007moO`1oOgl0
7`1oOgl00`000000VIVI09VIV@1n09VIV@030000001oOgl0Ogmo02l0Ogmo203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0oooo=01oOgl00`000000IVIV06IVIP1l06IVIP030000001o
Ogl0Ogmo01l0Ogmo00<0000009VIV@2IVIT0O@2IVIT00`000000Ogmo07moO`0`07moO`P0oooo0@00
00010?ooo`005`3oool00`000000oooo0?ooo`040?ooocD0Ogmo0P00001k06IVIP030000001oOgl0
Ogmo0240Ogmo00<0000009VIV@2IVIT0NP2IVIT2000003<0Ogmo203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0oooo=`1oOgl00`000000IVIV06IVIP1g06IVIP030000001oOgl0Ogmo
02<0Ogmo00<0000009VIV@2IVIT0N02IVIT00`000000Ogmo07moO`0c07moO`P0oooo0@0000010?oo
o`005`3oool00`000000oooo0?ooo`040?ooocP0Ogmo00<0000006IVIP1VIVH0MP1VIVH00`000000
Ogmo07moO`0S07moO`030000002IVIT0VIVI07L0VIVI00<0000007moO`1oOgl0=01oOgl80?ooo`40
00000@3oool001L0oooo00<000000?ooo`3oool0103oooli07moO`800000M@1VIVH00`000000Ogmo
07moO`0U07moO`030000002IVIT0VIVI07@0VIVI0P00000g07moO`P0oooo0@0000010?ooo`005`3o
ool00`000000oooo0?ooo`040?oooc/0Ogmo00<0000006IVIP1VIVH0L@1VIVH00`000000Ogmo07mo
O`0W07moO`030000002IVIT0VIVI0780VIVI00<0000007moO`1oOgl0=`1oOgl80?ooo`4000000@3o
ool001L0oooo00<000000?ooo`3oool0103oooll07moO`800000L01VIVH00`000000Ogmo07moO`0Y
07moO`030000002IVIT0VIVI06l0VIVI0P00000j07moO`P0oooo0@0000010?ooo`005`3oool00`00
0000oooo0?ooo`040?oooch0Ogmo00<0000006IVIP1VIVH0K@1VIVH00`000000Ogmo07moO`0Z07mo
O`030000002IVIT0VIVI06d0VIVI00<0000007moO`1oOgl0>P1oOgl80?ooo`4000000@3oool001L0
oooo00<000000?ooo`3oool0103ooolo07moO`030000001VIVH0IVIV06/0IVIV00<0000007moO`1o
Ogl0:`1oOgl00`000000VIVI09VIV@1/09VIV@030000001oOgl0Ogmo03/0Ogmo203oool100000040
oooo000G0?ooo`030000003oool0oooo00@0oooo@01oOgl2000006X0IVIV00<0000007moO`1oOgl0
;@1oOgl00`000000VIVI09VIV@1Y09VIV@800000?P1oOgl80?ooo`4000000@3oool001L0oooo00<0
00000?ooo`3oool0103ooom207moO`030000001VIVH0IVIV06H0IVIV00<0000007moO`1oOgl0;`1o
Ogl00`000000VIVI09VIV@1W09VIV@030000001oOgl0Ogmo03h0Ogmo203oool100000040oooo000G
0?ooo`030000003oool0oooo00@0oooo@`1oOgl2000006H0IVIV00<0000007moO`1oOgl0<01oOgl0
0`000000VIVI09VIV@1T09VIV@800000@@1oOgl80?ooo`4000000@3oool001L0oooo00<000000?oo
o`3oool0103ooom507moO`800000H`1VIVH00`000000Ogmo07moO`0b07moO`030000002IVIT0VIVI
0640VIVI0P00001307moO`P0oooo0@0000010?ooo`005`3oool2000000D0ooooA`1oOgl200000600
IVIV00<0000007moO`1oOgl0=01oOgl00`000000VIVI09VIV@1N09VIV@800000A@1oOgl70?ooo`80
00000@3oool001L0oooo00<000000?ooo`3oool0103ooom907moO`800000G@1VIVH00`000000Ogmo
07moO`0e07moO`030000002IVIT0VIVI05`0VIVI0P00001707moO`P0oooo0@0000010?ooo`005`3o
ool00`000000oooo0?ooo`040?oood/0Ogmo0P00001K06IVIP030000001oOgl0Ogmo03H0Ogmo00<0
000009VIV@2IVIT0F@2IVIT2000004T0Ogmo203oool100000040oooo000G0?ooo`030000003oool0
oooo00@0ooooC@1oOgl00`000000IVIV06IVIP1G06IVIP030000001oOgl0Ogmo03P0Ogmo00<00000
09VIV@2IVIT0E`2IVIT00`000000Ogmo07moO`1907moO`P0oooo0@0000010?ooo`005`3oool00`00
0000oooo0?ooo`040?ooodh0Ogmo0P00001F06IVIP030000001oOgl0Ogmo03X0Ogmo00<0000009VI
V@2IVIT0E02IVIT2000004`0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0
ooooD01oOgl2000005<0IVIV00<0000007moO`1oOgl0?01oOgl00`000000VIVI09VIV@1A09VIV@80
0000CP1oOgl80?ooo`4000000@3oool001L0oooo00<000000?ooo`3oool0103ooomB07moO`800000
C`1VIVH200000400Ogmo00<0000009VIV@2IVIT0CP2IVIT200000500Ogmo203oool100000040oooo
000G0?ooo`030000003oool0oooo00@0ooooE01oOgl2000004/0IVIV0P00001307moO`800000B`2I
VIT300000580Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0ooooEP1oOgl3
000004H0IVIV0P00001707moO`800000AP2IVIT3000005D0Ogmo203oool100000040oooo000G0?oo
o`030000003oool0oooo00@0ooooF@1oOgl300000440IVIV0P00001;07moO`800000@P2IVIT20000
05P0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0ooooG01oOgl2000003d0
IVIV0P00001?07moO`800000?@2IVIT3000005X0Ogmo203oool100000040oooo000G0?ooo`030000
003oool0oooo00@0ooooGP1oOgl3000003P0IVIV0P00001C07moO`800000>02IVIT3000005d0Ogmo
203oool100000040oooo000G0?ooo`030000003oool0oooo00@0ooooH@1oOgl400000380IVIV0P00
001G07moO`800000<`2IVIT300000600Ogmo203oool100000040oooo000G0?ooo`030000003oool0
oooo00@0ooooI@1oOgl4000002`0IVIV0P00001K07moO`800000;@2IVIT4000006<0Ogmo203oool1
00000040oooo000G0?ooo`030000003oool0oooo00@0ooooJ@1oOgl4000002<0IVIV1@00001O07mo
O`H000008`2IVIT4000006L0Ogmo203oool100000040oooo000G0?ooo`030000003oool0oooo00@0
ooooK@1oOgl4000001L0IVIV2000001Z07moO`P000005`2IVIT4000006/0Ogmo203oool100000040
oooo00090?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0103oool00`000000oooo
0?ooo`040?ooog40Ogmo5`00001j07moOaL00000K`1oOgl80?ooo`4000000@3oool000X0oooo00<0
e9/00000V`3Dool00P3oool00`3Z^Y/0^^[o0?ooo`050?ooo`030000003oool0oooo00@0ooooo`1o
Ogn907moO`P0oooo0@0000010?ooo`002`3oool00`3oe9/0001b0;[Zo`090?ooo`030000003oool0
oooo00@0ooooo`1oOgn907moO`P0oooo0@0000010?ooo`00303oool00`3oj[X0LP0007:jjP080?oo
o`<00000103ooooo07moOhT0Ogmo1P3oool300000040oooo000>0?ooo`030;Yb001b^^X0oooo00H0
oooo00<000000?ooo`3oool0o`3ooonE0?ooo`4000000@3oool000l0oooo00<0^W:K0=Coo`3oool0
1@3oool00`000000oooo0?ooo`3o0?oooiD0oooo0@0000010?ooo`002P3oool00`3Z^W80VmCo0?oo
o`020?ooo`030=BK002Ke?l0oooo00D0oooo00<000000?ooo`3oool0o`3ooonE0?ooo`4000000@3o
ool000X0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o00H0oooo00<000000?ooo`3oool0
o`3ooonE0?ooo`4000000@3oool000/0oooo00D0omBK000000000000001b0;[Zo`070?ooo`030000
003oool0oooo0?l0ooooU@3oool100000040oooo000G0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo05l0oooo00<0
00000?ooo`3oool0G`3oool00`000000oooo0?ooo`050?ooo`4000000@3oool001L0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool01@3oool100000040oooo000G0?ooool00000V@0000010?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-2.31568, -2.29368, 0.0153049, \
0.0153049}}]
}, Open  ]],

Cell[TextData[{
  "Las superficies m\[AAcute]s sencillas son las cu\[AAcute]dricas. Se llaman \
as\[IAcute] las superficies definidas impl\[IAcute]citamente como el conjunto \
de puntos donde se anula una funci\[OAcute]n polin\[OAcute]mica de grado dos \
con tres variables. Las cu\[AAcute]dricas son la generalizaci\[OAcute]n a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " de las c\[OAcute]nicas."
}], "Text"],

Cell["\<\
Para representar superficies impl\[IAcute]citamente definidas hay que cargar \
el paquete siguiente que pone a nuestra disposici\[OAcute]n el comando \
ContourPlot3D[ ] que es el an\[AAcute]logo en tres dimensiones de \
ContourPlot[ ]. \
\>", "Text"],

Cell["<<Graphics`ContourPlot3D`", "Input",
  CellTags->"S5.30.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(ContourPlot3D[
        2  x^2 + y^2 - z^2 - 1, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {x, \(-2\), 
          2}, \ {y, \(-2\), 2}, \ {z, \(-2\), 
          2}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotPoints -> {{5, 7}, {5, 
              7}, {5, 7}}];\)\( (*\ 
      Hiperboloide\ de\ una\ hoja\ *) \)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.20697 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.10821 1.28215 -4.45607e-017 1.28215 [
[ 0 0 0 0 ]
[ 1 1.20697 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0906 .22388 m
0 .87288 L
s
0 .87288 m
.45324 1.20697 L
s
.45324 1.20697 m
.46448 .62078 L
s
.46448 .62078 m
.0906 .22388 L
s
.62307 0 m
.92888 .4688 L
s
.92888 .4688 m
1 1.08172 L
s
1 1.08172 m
.64371 .67398 L
s
.64371 .67398 m
.62307 0 L
s
.0906 .22388 m
0 .87288 L
s
0 .87288 m
.64371 .67398 L
s
.64371 .67398 m
.62307 0 L
s
.62307 0 m
.0906 .22388 L
s
.46448 .62078 m
.92888 .4688 L
s
.92888 .4688 m
1 1.08172 L
s
1 1.08172 m
.45324 1.20697 L
s
.45324 1.20697 m
.46448 .62078 L
s
0 0 m
1 0 L
1 1.20697 L
0 1.20697 L
closepath
clip
newpath
.5 Mabswid
.566 .056 .001 r
.5842 .58329 m .58931 .58518 L .5797 .59074 L p F P
0 g
s
.566 .056 .001 r
.55927 .58071 m .5842 .58329 L p .5797 .59074 L F P
0 g
s
.566 .056 .001 r
.5546 .58331 m .55927 .58071 L p .5797 .59074 L F P
0 g
s
.63 .137 .062 r
.5546 .58331 m .54527 .57838 L .55927 .58071 L closepath p F P
0 g
s
.483 0 0 r
.5797 .59074 m .58931 .58518 L .61247 .59019 L p F P
0 g
s
.622 .108 .004 r
.54527 .57838 m .5546 .58331 L .54652 .58659 L p F P
0 g
s
.622 .108 .004 r
.52433 .57425 m .54527 .57838 L p .54652 .58659 L F P
0 g
s
.622 .108 .004 r
.51959 .57607 m .52433 .57425 L p .54652 .58659 L F P
0 g
s
.677 .183 .065 r
.51959 .57607 m .51266 .57127 L .52433 .57425 L closepath p F P
0 g
s
.672 .159 .01 r
.51266 .57127 m .51959 .57607 L .50965 .57848 L p F P
0 g
s
.672 .159 .01 r
.48514 .56329 m .51266 .57127 L p .50965 .57848 L F P
0 g
s
.566 .056 .001 r
.5797 .59074 m .57249 .58999 L .5546 .58331 L p F P
0 g
s
.549 .015 0 r
.57249 .58999 m .54652 .58659 L .5546 .58331 L closepath p F P
0 g
s
.483 0 0 r
.61247 .59019 m .61 .59166 L .5797 .59074 L p F P
0 g
s
.377 0 0 r
.62413 .59092 m .61 .59166 L .61247 .59019 L closepath p F P
0 g
s
.609 .074 0 r
.53512 .58435 m .50965 .57848 L .51959 .57607 L closepath p F P
0 g
s
.622 .108 .004 r
.54652 .58659 m .53512 .58435 L .51959 .57607 L p F P
0 g
s
.672 .159 .01 r
.48446 .56345 m .48514 .56329 L p .50965 .57848 L F P
0 g
s
.72 .227 .071 r
.48446 .56345 m .48372 .56281 L .48514 .56329 L closepath p F P
0 g
s
.716 .208 .019 r
.48372 .56281 m .48446 .56345 L .47143 .56456 L p F P
0 g
s
.716 .208 .019 r
.47143 .56456 m .45812 .55306 L .48372 .56281 L p F P
0 g
s
.672 .159 .01 r
.50965 .57848 m .50348 .5767 L .48446 .56345 L p F P
0 g
s
.663 .131 0 r
.50348 .5767 m .48446 .56345 L .47143 .56456 L p F P
0 g
s
.441 0 0 r
.61 .59166 m .62413 .59092 L p .62814 .59828 L F P
0 g
s
.441 0 0 r
.60105 .5986 m .61 .59166 L p .62814 .59828 L F P
0 g
s
.533 .038 .027 r
.61 .59166 m .60105 .5986 L .57765 .59226 L p F P
0 g
s
.533 .038 .027 r
.57765 .59226 m .5797 .59074 L .61 .59166 L p F P
0 g
s
.441 0 0 r
.62413 .59092 m .63587 .59209 L .62814 .59828 L p F P
0 g
s
.604 .124 .087 r
.57765 .59226 m .57249 .58999 L .5797 .59074 L closepath p F P
0 g
s
.595 .092 .028 r
.57249 .58999 m .57765 .59226 L .56799 .59786 L p F P
0 g
s
.595 .092 .028 r
.54652 .58659 m .57249 .58999 L p .56799 .59786 L F P
0 g
s
.595 .092 .028 r
.54243 .58885 m .54652 .58659 L p .56799 .59786 L F P
0 g
s
.657 .172 .089 r
.54243 .58885 m .53512 .58435 L .54652 .58659 L closepath p F P
0 g
s
.514 0 0 r
.56799 .59786 m .57765 .59226 L .60105 .5986 L p F P
0 g
s
.709 .185 0 r
.45812 .55306 m .47143 .56456 L .46703 .56434 L p F P
0 g
s
.709 .185 0 r
.43867 .54477 m .45812 .55306 L p .46703 .56434 L F P
0 g
s
.323 0 0 r
.62814 .59828 m .63587 .59209 L .65946 .59049 L p F P
0 g
s
.652 .146 .032 r
.53512 .58435 m .54243 .58885 L .53327 .59245 L p F P
0 g
s
.652 .146 .032 r
.50965 .57848 m .53512 .58435 L p .53327 .59245 L F P
0 g
s
.652 .146 .032 r
.50697 .57948 m .50965 .57848 L p .53327 .59245 L F P
0 g
s
.705 .219 .092 r
.50697 .57948 m .50348 .5767 L .50965 .57848 L closepath p F P
0 g
s
.582 .054 0 r
.56048 .59688 m .53327 .59245 L .54243 .58885 L closepath p F P
0 g
s
.595 .092 .028 r
.56799 .59786 m .56048 .59688 L .54243 .58885 L p F P
0 g
s
.754 .254 .03 r
.43597 .5446 m .43404 .5426 L .43867 .54477 L closepath p F P
0 g
s
.709 .185 0 r
.43597 .5446 m .43867 .54477 L p .46703 .56434 L F P
0 g
s
.702 .198 .038 r
.50348 .5767 m .50697 .57948 L .49404 .58227 L p F P
0 g
s
.702 .198 .038 r
.49404 .58227 m .47574 .56759 L .50348 .5767 L p F P
0 g
s
.663 .131 0 r
.47143 .56456 m .47574 .56759 L .50348 .5767 L p F P
0 g
s
.749 .235 0 r
.43404 .5426 m .43597 .5446 L .42235 .54189 L p F P
0 g
s
.749 .235 0 r
.42235 .54189 m .41212 .53121 L .43404 .5426 L p F P
0 g
s
.176 0 0 r
.65475 .59435 m .65946 .59049 L .68314 .58488 L p F P
0 g
s
.323 0 0 r
.65946 .59049 m .65475 .59435 L .62814 .59828 L p F P
0 g
s
.652 .146 .032 r
.53327 .59245 m .52469 .59049 L .50697 .57948 L p F P
0 g
s
.643 .115 0 r
.52469 .59049 m .50697 .57948 L .49404 .58227 L closepath p F P
0 g
s
.709 .185 0 r
.46703 .56434 m .45069 .55741 L .43597 .5446 L p F P
0 g
s
.696 .157 0 r
.45069 .55741 m .43597 .5446 L .42235 .54189 L p F P
0 g
s
.647 .097 0 r
.47574 .56759 m .46703 .56434 L .47143 .56456 L closepath p F P
0 g
s
.441 0 0 r
.62814 .59828 m .60811 .59933 L .60105 .5986 L p F P
0 g
s
.405 0 0 r
.60811 .59933 m .59939 .5996 L .60105 .5986 L closepath p F P
0 g
s
.514 0 0 r
.60105 .5986 m .59939 .5996 L .56799 .59786 L p F P
0 g
s
.696 .173 0 r
.46703 .56434 m .47574 .56759 L .49404 .58227 L p F P
0 g
s
.47 0 0 r
.59939 .5996 m .60811 .59933 L p .61821 .60711 L F P
0 g
s
.47 0 0 r
.58933 .60758 m .59939 .5996 L p .61821 .60711 L F P
0 g
s
.563 .075 .056 r
.59939 .5996 m .58933 .60758 L .56569 .59961 L p F P
0 g
s
.563 .075 .056 r
.56569 .59961 m .56799 .59786 L .59939 .5996 L p F P
0 g
s
.494 .019 .057 r
.62473 .60176 m .60811 .59933 L .62814 .59828 L closepath p F P
0 g
s
.47 0 0 r
.60811 .59933 m .62473 .60176 L .61821 .60711 L p F P
0 g
s
.391 0 0 r
.62473 .60176 m .62814 .59828 L .65475 .59435 L p F P
0 g
s
.632 .16 .116 r
.56569 .59961 m .56048 .59688 L .56799 .59786 L closepath p F P
0 g
s
.176 0 0 r
.68314 .58488 m .67947 .58796 L .65475 .59435 L p F P
0 g
s
.004 0 0 r
.67947 .58796 m .68314 .58488 L .70682 .57525 L p F P
0 g
s
.696 .173 0 r
.45811 .56475 m .46703 .56434 L p .49404 .58227 L F P
0 g
s
.745 .248 .047 r
.45811 .56475 m .45069 .55741 L .46703 .56434 L closepath p F P
0 g
s
.627 .132 .058 r
.56048 .59688 m .56569 .59961 L .55602 .60521 L p F P
0 g
s
.627 .132 .058 r
.53327 .59245 m .56048 .59688 L p .55602 .60521 L F P
0 g
s
.737 .213 0 r
.41212 .53121 m .42235 .54189 L .41357 .53899 L p F P
0 g
s
.737 .213 0 r
.39128 .51922 m .41212 .53121 L p .41357 .53899 L F P
0 g
s
.26 0 0 r
.6486 .60083 m .65475 .59435 L .67947 .58796 L p F P
0 g
s
.391 0 0 r
.65475 .59435 m .6486 .60083 L .62473 .60176 L p F P
0 g
s
.547 .033 0 r
.55602 .60521 m .56569 .59961 L .58933 .60758 L p F P
0 g
s
.627 .132 .058 r
.52996 .59428 m .53327 .59245 L p .55602 .60521 L F P
0 g
s
.686 .21 .117 r
.52996 .59428 m .52469 .59049 L .53327 .59245 L closepath p F P
0 g
s
0 0 0 r
.70237 .57905 m .70682 .57525 L .73045 .56157 L p F P
0 g
s
.004 0 0 r
.70682 .57525 m .70237 .57905 L .67947 .58796 L p F P
0 g
s
.684 .188 .062 r
.52469 .59049 m .52996 .59428 L .51944 .59824 L p F P
0 g
s
.684 .188 .062 r
.49404 .58227 m .52469 .59049 L p .51944 .59824 L F P
0 g
s
.74 .228 0 r
.45069 .55741 m .45811 .56475 L .44664 .56358 L p F P
0 g
s
.74 .228 0 r
.42749 .5464 m .45069 .55741 L p .44664 .56358 L F P
0 g
s
.696 .157 0 r
.42235 .54189 m .42749 .5464 L .45069 .55741 L p F P
0 g
s
.349 0 0 r
.61821 .60711 m .62473 .60176 L .6486 .60083 L p F P
0 g
s
.102 0 0 r
.67257 .5954 m .67947 .58796 L .70237 .57905 L p F P
0 g
s
.26 0 0 r
.67947 .58796 m .67257 .5954 L .6486 .60083 L p F P
0 g
s
0 0 0 r
.7235 .56756 m .73045 .56157 L .74218 .55273 L p F P
0 g
s
0 0 0 r
.73045 .56157 m .7235 .56756 L .70237 .57905 L p F P
0 g
s
.627 .132 .058 r
.55602 .60521 m .54816 .60394 L .52996 .59428 L p F P
0 g
s
.617 .097 0 r
.54816 .60394 m .51944 .59824 L .52996 .59428 L closepath p F P
0 g
s
.449 .836 .614 r
.75183 .54568 m .75395 .5443 L .75184 .54581 L p F P
0 g
s
.449 .836 .614 r
.75184 .54581 m .74218 .55273 L .75183 .54568 L p F P
0 g
s
.518 .844 .553 r
.75183 .54568 m .76942 .52889 L p .75178 .54525 L F P
0 g
s
0 0 0 r
.74218 .55273 m .75183 .54568 L p .7235 .56756 L F P
0 g
s
0 0 0 r
.75183 .54568 m .7442 .55228 L p .73757 .55718 L F P
0 g
s
0 0 0 r
.7235 .56756 m .74006 .55477 L .73757 .55718 L F
.74006 .55477 m .75183 .54568 L .73757 .55718 L F
.7442 .55228 m .73706 .55767 L .7235 .56756 L p F P
0 g
s
0 0 0 r
.73706 .55767 m .74278 .55322 L p .73576 .55893 L F P
0 g
s
0 0 0 r
.7146 .57614 m .73706 .55767 L .73576 .55893 L F
.518 .844 .553 r
.7442 .55228 m .75183 .54568 L p .75178 .54525 L F P
0 g
s
.737 .213 0 r
.41357 .53899 m .40593 .53461 L .39128 .51922 L p F P
0 g
s
.719 .187 0 r
.37594 .50943 m .39128 .51922 L .40593 .53461 L p F P
0 g
s
.675 .126 0 r
.42749 .5464 m .41357 .53899 L .42235 .54189 L closepath p F P
0 g
s
.588 .907 .653 r
.75183 .54568 m .75395 .5443 L .77728 .52383 L p F P
0 g
s
.696 .949 .671 r
.78241 .51848 m .79476 .5033 L p .76942 .52889 L F P
0 g
s
.696 .949 .671 r
.76942 .52889 m .77728 .52383 L .78241 .51848 L p F P
0 g
s
.588 .907 .653 r
.77728 .52383 m .76942 .52889 L .75183 .54568 L p F P
0 g
s
.678 .16 0 r
.4808 .5847 m .49404 .58227 L .51398 .59679 L p F P
0 g
s
.733 .241 .069 r
.4808 .5847 m .46766 .57247 L .49404 .58227 L closepath p F P
0 g
s
.684 .188 .062 r
.51944 .59824 m .51398 .59679 L .49404 .58227 L p F P
0 g
s
.696 .173 0 r
.49404 .58227 m .46766 .57247 L .45811 .56475 L p F P
0 g
s
.683 .143 0 r
.46766 .57247 m .44664 .56358 L .45811 .56475 L closepath p F P
0 g
s
.74 .228 0 r
.44664 .56358 m .44304 .56188 L .42749 .5464 L p F P
0 g
s
.73 .204 0 r
.41357 .53899 m .42749 .5464 L .44304 .56188 L p F P
0 g
s
0 0 0 r
.69655 .58545 m .70237 .57905 L .7235 .56756 L p F P
0 g
s
.102 0 0 r
.70237 .57905 m .69655 .58545 L .67257 .5954 L p F P
0 g
s
.193 0 0 r
.64543 .6035 m .6486 .60083 L .67257 .5954 L p F P
0 g
s
.349 0 0 r
.6486 .60083 m .64543 .6035 L .61821 .60711 L p F P
0 g
s
.438 0 0 r
.59171 .60794 m .5887 .60796 L .58933 .60758 L closepath p F P
0 g
s
.547 .033 0 r
.58933 .60758 m .5887 .60796 L .55602 .60521 L p F P
0 g
s
.47 0 0 r
.61821 .60711 m .59171 .60794 L .58933 .60758 L p F P
0 g
s
.719 .187 0 r
.37278 .50794 m .37594 .50943 L p .40593 .53461 L F P
0 g
s
.772 .263 0 r
.37278 .50794 m .37167 .50657 L .37594 .50943 L closepath p F P
0 g
s
.503 .009 .015 r
.57793 .61674 m .5887 .60796 L .59171 .60794 L p F P
0 g
s
.594 .116 .088 r
.55602 .60521 m .5887 .60796 L .57793 .61674 L p F P
0 g
s
.522 .056 .089 r
.61328 .61236 m .59171 .60794 L .61821 .60711 L closepath p F P
0 g
s
.503 .009 .015 r
.59171 .60794 m .61328 .61236 L p .57793 .61674 L F P
0 g
s
.418 0 .018 r
.61328 .61236 m .61821 .60711 L .64543 .6035 L p F P
0 g
s
.755 .242 0 r
.37167 .50657 m .37278 .50794 L .35852 .49936 L p F P
0 g
s
.755 .242 0 r
.35852 .49936 m .35352 .49315 L .37167 .50657 L p F P
0 g
s
.73 .219 .007 r
.46766 .57247 m .4808 .5847 L .47668 .58477 L p F P
0 g
s
.73 .219 .007 r
.44664 .56358 m .46766 .57247 L p .47668 .58477 L F P
0 g
s
.594 .116 .088 r
.55341 .60725 m .55602 .60521 L p .57793 .61674 L F P
0 g
s
.661 .2 .146 r
.55341 .60725 m .54816 .60394 L .55602 .60521 L closepath p F P
0 g
s
.73 .204 0 r
.40849 .53766 m .41357 .53899 L p .44304 .56188 L F P
0 g
s
.778 .277 .005 r
.40849 .53766 m .40593 .53461 L .41357 .53899 L closepath p F P
0 g
s
.719 .187 0 r
.40593 .53461 m .3861 .52199 L .37278 .50794 L p F P
0 g
s
.692 .157 0 r
.3861 .52199 m .37278 .50794 L .35852 .49936 L p F P
0 g
s
.66 .175 .09 r
.54816 .60394 m .55341 .60725 L .54379 .61283 L p F P
0 g
s
.66 .175 .09 r
.51944 .59824 m .54816 .60394 L p .54379 .61283 L F P
0 g
s
.281 0 0 r
.64543 .6035 m .67051 .59717 L .66173 .60709 L p F P
0 g
s
.281 0 0 r
.66173 .60709 m .63745 .61227 L .64543 .6035 L p F P
0 g
s
.193 0 0 r
.67257 .5954 m .67051 .59717 L .64543 .6035 L p F P
0 g
s
.418 0 .018 r
.64543 .6035 m .63745 .61227 L .61328 .61236 L p F P
0 g
s
.775 .968 .674 r
.79113 .50559 m .80057 .49415 L .79476 .5033 L closepath p F P
0 g
s
.696 .949 .671 r
.79476 .5033 m .79113 .50559 L p .76942 .52889 L F P
0 g
s
.006 0 0 r
.67051 .59717 m .67257 .5954 L .69655 .58545 L p F P
0 g
s
.768 .258 0 r
.40593 .53461 m .40849 .53766 L .3944 .53194 L p F P
0 g
s
.768 .258 0 r
.3944 .53194 m .3861 .52199 L .40593 .53461 L p F P
0 g
s
0 0 0 r
.72046 .57096 m .73706 .55767 L .7235 .56756 L closepath p F P
0 g
s
0 0 0 r
.7235 .56756 m .72046 .57096 L .69655 .58545 L p F P
0 g
s
.594 .116 .088 r
.57793 .61674 m .57557 .61654 L .55341 .60725 L p F P
0 g
s
.583 .077 .016 r
.57557 .61654 m .54379 .61283 L .55341 .60725 L closepath p F P
0 g
s
.66 .175 .09 r
.51716 .5995 m .51944 .59824 L p .54379 .61283 L F P
0 g
s
.715 .251 .148 r
.51716 .5995 m .51398 .59679 L .51944 .59824 L closepath p F P
0 g
s
.73 .204 0 r
.44304 .56188 m .42101 .55021 L .40849 .53766 L p F P
0 g
s
.711 .175 0 r
.42101 .55021 m .40849 .53766 L .3944 .53194 L p F P
0 g
s
.111 0 0 r
.69355 .58808 m .67051 .59717 L .66173 .60709 L p F P
0 g
s
.006 0 0 r
.69655 .58545 m .69355 .58808 L .67051 .59717 L p F P
0 g
s
.717 .233 .095 r
.51398 .59679 m .51716 .5995 L .50493 .60386 L p F P
0 g
s
.717 .233 .095 r
.48499 .58778 m .51398 .59679 L p .50493 .60386 L F P
0 g
s
.678 .16 0 r
.51398 .59679 m .48499 .58778 L .4808 .5847 L p F P
0 g
s
.73 .219 .007 r
.44453 .56358 m .44664 .56358 L p .47668 .58477 L F P
0 g
s
.774 .29 .078 r
.44453 .56358 m .44304 .56188 L .44664 .56358 L closepath p F P
0 g
s
0 0 0 r
.69355 .58808 m .69655 .58545 L .72046 .57096 L p F P
0 g
s
.643 .903 .585 r
.76777 .53031 m .77295 .52455 L .76942 .52889 L closepath p F P
0 g
s
.696 .949 .671 r
.79113 .50559 m .77295 .52455 L .76942 .52889 L p F P
0 g
s
.518 .844 .553 r
.76942 .52889 m .76777 .53031 L .7442 .55228 L p F P
0 g
s
.772 .273 .021 r
.44304 .56188 m .44453 .56358 L .43067 .56131 L p F P
0 g
s
.772 .273 .021 r
.43067 .56131 m .42101 .55021 L .44304 .56188 L p F P
0 g
s
.378 0 0 r
.60836 .61652 m .61328 .61236 L .63745 .61227 L p F P
0 g
s
.503 .009 .015 r
.61328 .61236 m .60836 .61652 L .57793 .61674 L p F P
0 g
s
.831 .99 .731 r
.80057 .49415 m .80846 .47999 L p .78476 .50834 L F P
0 g
s
.831 .99 .731 r
.78476 .50834 m .79113 .50559 L .80057 .49415 L p F P
0 g
s
.66 .175 .09 r
.54379 .61283 m .5355 .61119 L .51716 .5995 L p F P
0 g
s
.654 .145 .022 r
.5355 .61119 m .50493 .60386 L .51716 .5995 L closepath p F P
0 g
s
.73 .219 .007 r
.47668 .58477 m .45935 .57748 L .44453 .56358 L p F P
0 g
s
.72 .193 0 r
.45935 .57748 m .44453 .56358 L .43067 .56131 L p F P
0 g
s
.731 .217 0 r
.35352 .49315 m .35852 .49936 L .3441 .4888 L p F P
0 g
s
.731 .217 0 r
.3441 .4888 m .33633 .47913 L .35352 .49315 L p F P
0 g
s
.768 .985 .742 r
.77295 .52455 m .78476 .50834 L .79113 .50559 L closepath p F P
0 g
s
0 0 0 r
.7146 .57614 m .72046 .57096 L .73706 .55767 L p F P
0 g
s
0 0 0 r
.72046 .57096 m .7146 .57614 L .69355 .58808 L p F P
0 g
s
.665 .126 0 r
.48499 .58778 m .47668 .58477 L .4808 .5847 L closepath p F P
0 g
s
.733 .959 .674 r
.77295 .52455 m .78476 .50834 L p .75987 .53541 L F P
0 g
s
.733 .959 .674 r
.75987 .53541 m .76777 .53031 L .77295 .52455 L p F P
0 g
s
.557 .862 .557 r
.74278 .55322 m .75987 .53541 L p .74248 .55264 L F P
0 g
s
.484 .855 .624 r
.74283 .55332 m .73706 .55767 L .74278 .55322 L p F P
0 g
s
0 0 0 r
.74278 .55322 m .73421 .56083 L p .73205 .56251 L F P
0 g
s
0 0 0 r
.7146 .57614 m .73576 .55893 L .73205 .56251 L F
.73576 .55893 m .74278 .55322 L .73205 .56251 L F
.73421 .56083 m .7318 .56275 L .7146 .57614 L p F P
0 g
s
.523 .875 .635 r
.7318 .56275 m .73367 .56118 L .73421 .56083 L closepath p F P
0 g
s
0 0 0 r
.7318 .56275 m .73367 .56118 L p .73136 .56318 L F P
0 g
s
0 0 0 r
.70579 .58532 m .7318 .56275 L .73136 .56318 L F
.557 .862 .557 r
.73421 .56083 m .74278 .55322 L p .74248 .55264 L F P
0 g
s
.484 .855 .624 r
.74278 .55322 m .7442 .55228 L .74283 .55332 L p F P
0 g
s
.627 .924 .661 r
.76777 .53031 m .75987 .53541 L .74278 .55322 L p F P
0 g
s
.627 .924 .661 r
.74278 .55322 m .7442 .55228 L .76777 .53031 L p F P
0 g
s
.752 .235 0 r
.3861 .52199 m .3944 .53194 L .38012 .52408 L p F P
0 g
s
.752 .235 0 r
.38012 .52408 m .36738 .50874 L .3861 .52199 L p F P
0 g
s
.692 .157 0 r
.35852 .49936 m .36738 .50874 L .3861 .52199 L p F P
0 g
s
0 0 0 r
.68602 .59676 m .69355 .58808 L .7146 .57614 L p F P
0 g
s
.111 0 0 r
.66173 .60709 m .68602 .59676 L .69355 .58808 L p F P
0 g
s
.717 .233 .095 r
.50493 .60386 m .50298 .60326 L .48499 .58778 L p F P
0 g
s
.715 .209 .03 r
.47668 .58477 m .48499 .58778 L .50298 .60326 L p F P
0 g
s
.655 .123 0 r
.36738 .50874 m .35852 .49936 L .3441 .4888 L p F P
0 g
s
.715 .209 .03 r
.46726 .58613 m .47668 .58477 L p .50298 .60326 L F P
0 g
s
.765 .286 .101 r
.46726 .58613 m .45935 .57748 L .47668 .58477 L closepath p F P
0 g
s
.764 .252 0 r
.42101 .55021 m .43067 .56131 L .42132 .55827 L p F P
0 g
s
.764 .252 0 r
.40028 .53786 m .42101 .55021 L p .42132 .55827 L F P
0 g
s
.711 .175 0 r
.3944 .53194 m .40028 .53786 L .42101 .55021 L p F P
0 g
s
.554 .097 .124 r
.57729 .61743 m .57793 .61674 L .60836 .61652 L p F P
0 g
s
.631 .188 .18 r
.57729 .61743 m .57557 .61654 L .57793 .61674 L closepath p F P
0 g
s
.628 .161 .124 r
.57557 .61654 m .57729 .61743 L .56712 .62601 L p F P
0 g
s
.628 .161 .124 r
.54379 .61283 m .57557 .61654 L p .56712 .62601 L F P
0 g
s
.448 0 .053 r
.60836 .61652 m .63626 .61331 L .62723 .6238 L p F P
0 g
s
.448 0 .053 r
.60153 .6242 m .60836 .61652 L p .62723 .6238 L F P
0 g
s
.554 .097 .124 r
.60836 .61652 m .60153 .6242 L .57729 .61743 L p F P
0 g
s
.378 0 0 r
.63745 .61227 m .63626 .61331 L .60836 .61652 L p F P
0 g
s
.213 0 0 r
.63626 .61331 m .63745 .61227 L .66173 .60709 L closepath p F P
0 g
s
.539 .053 .052 r
.56712 .62601 m .57729 .61743 L .60153 .6242 L p F P
0 g
s
.876 .986 .715 r
.80489 .48144 m .81197 .47164 L .80846 .47999 L closepath p F P
0 g
s
.831 .99 .731 r
.80846 .47999 m .80489 .48144 L p .78476 .50834 L F P
0 g
s
.306 0 0 r
.62723 .6238 m .63626 .61331 L .66173 .60709 L p F P
0 g
s
.698 .188 0 r
.33633 .47913 m .3441 .4888 L .32954 .47622 L p F P
0 g
s
.698 .188 0 r
.32954 .47622 m .32013 .46448 L .33633 .47913 L p F P
0 g
s
.628 .161 .124 r
.5408 .61524 m .54379 .61283 L p .56712 .62601 L F P
0 g
s
.692 .243 .18 r
.5408 .61524 m .5355 .61119 L .54379 .61283 L closepath p F P
0 g
s
.682 .141 0 r
.40028 .53786 m .3944 .53194 L .38012 .52408 L p F P
0 g
s
.695 .223 .126 r
.5355 .61119 m .5408 .61524 L .53133 .62074 L p F P
0 g
s
.695 .223 .126 r
.50493 .60386 m .5355 .61119 L p .53133 .62074 L F P
0 g
s
.764 .268 .041 r
.45935 .57748 m .46726 .58613 L .45725 .58572 L p F P
0 g
s
.764 .268 .041 r
.43589 .56624 m .45935 .57748 L p .45725 .58572 L F P
0 g
s
.72 .193 0 r
.43067 .56131 m .43589 .56624 L .45935 .57748 L p F P
0 g
s
0 0 0 r
.71021 .58128 m .7318 .56275 L .7146 .57614 L closepath p F P
0 g
s
0 0 0 r
.7146 .57614 m .71021 .58128 L .68602 .59676 L p F P
0 g
s
.725 .207 0 r
.36738 .50874 m .38012 .52408 L .37725 .52208 L p F P
0 g
s
.725 .207 0 r
.34978 .49483 m .36738 .50874 L p .37725 .52208 L F P
0 g
s
.655 .123 0 r
.3441 .4888 m .34978 .49483 L .36738 .50874 L p F P
0 g
s
.809 .973 .673 r
.78158 .51034 m .78897 .50071 L .78476 .50834 L closepath p F P
0 g
s
.831 .99 .731 r
.80489 .48144 m .78897 .50071 L .78476 .50834 L p F P
0 g
s
.733 .959 .674 r
.78476 .50834 m .78158 .51034 L p .75987 .53541 L F P
0 g
s
.122 0 0 r
.65298 .61753 m .66173 .60709 L .68489 .59779 L p F P
0 g
s
.009 0 0 r
.66173 .60709 m .68602 .59676 L .68489 .59779 L closepath p F P
0 g
s
.306 0 0 r
.66173 .60709 m .65298 .61753 L .62723 .6238 L p F P
0 g
s
.622 .127 .054 r
.5597 .62515 m .53133 .62074 L .5408 .61524 L closepath p F P
0 g
s
.628 .161 .124 r
.56712 .62601 m .5597 .62515 L .5408 .61524 L p F P
0 g
s
.904 .985 .749 r
.81197 .47164 m .81901 .4512 L p .79728 .48303 L F P
0 g
s
.904 .985 .749 r
.79728 .48303 m .80489 .48144 L .81197 .47164 L p F P
0 g
s
.701 .16 0 r
.43589 .56624 m .42132 .55827 L .43067 .56131 L closepath p F P
0 g
s
.764 .252 0 r
.42132 .55827 m .41435 .55413 L .40028 .53786 L p F P
0 g
s
.747 .227 0 r
.38085 .52482 m .40028 .53786 L .41435 .55413 L p F P
0 g
s
.682 .141 0 r
.38012 .52408 m .38085 .52482 L .40028 .53786 L p F P
0 g
s
.869 .995 .772 r
.78897 .50071 m .79728 .48303 L .80489 .48144 L closepath p F P
0 g
s
.695 .223 .126 r
.50404 .60435 m .50493 .60386 L p .53133 .62074 L F P
0 g
s
.745 .295 .181 r
.50404 .60435 m .50298 .60326 L .50493 .60386 L closepath p F P
0 g
s
.751 .281 .13 r
.50298 .60326 m .50404 .60435 L .49059 .60881 L p F P
0 g
s
.751 .281 .13 r
.49059 .60881 m .47569 .59344 L .50298 .60326 L p F P
0 g
s
.715 .209 .03 r
.50298 .60326 m .47569 .59344 L .46726 .58613 L p F P
0 g
s
.607 .085 0 r
.34978 .49483 m .3441 .4888 L .32954 .47622 L p F P
0 g
s
.683 .916 .587 r
.75801 .53705 m .76323 .53078 L .75987 .53541 L closepath p F P
0 g
s
.733 .959 .674 r
.78158 .51034 m .76323 .53078 L .75987 .53541 L p F P
0 g
s
.557 .862 .557 r
.75987 .53541 m .75801 .53705 L .73421 .56083 L p F P
0 g
s
.695 .223 .126 r
.53133 .62074 m .5225 .61864 L .50404 .60435 L p F P
0 g
s
.694 .197 .059 r
.5225 .61864 m .50404 .60435 L .49059 .60881 L p F P
0 g
s
.706 .18 0 r
.47569 .59344 m .45725 .58572 L .46726 .58613 L closepath p F P
0 g
s
.86 .99 .728 r
.78897 .50071 m .79728 .48303 L p .77433 .51333 L F P
0 g
s
.86 .99 .728 r
.77433 .51333 m .78158 .51034 L .78897 .50071 L p F P
0 g
s
0 0 0 r
.68489 .59779 m .68602 .59676 L .71021 .58128 L p F P
0 g
s
.802 .99 .743 r
.76323 .53078 m .77433 .51333 L .78158 .51034 L closepath p F P
0 g
s
.764 .268 .041 r
.45725 .58572 m .45079 .58264 L .43589 .56624 L p F P
0 g
s
.758 .246 0 r
.42132 .55827 m .43589 .56624 L .45079 .58264 L p F P
0 g
s
.448 0 .053 r
.62723 .6238 m .61781 .62488 L .60153 .6242 L p F P
0 g
s
.412 0 0 r
.61781 .62488 m .59871 .62667 L .60153 .6242 L closepath p F P
0 g
s
.539 .053 .052 r
.60153 .6242 m .59871 .62667 L .56712 .62601 L p F P
0 g
s
.656 .157 0 r
.32013 .46448 m .32954 .47622 L .31485 .4616 L p F P
0 g
s
.656 .157 0 r
.31485 .4616 m .30491 .44918 L .32013 .46448 L p F P
0 g
s
.773 .968 .675 r
.76323 .53078 m .77433 .51333 L p .7501 .54216 L F P
0 g
s
.773 .968 .675 r
.7501 .54216 m .75801 .53705 L .76323 .53078 L p F P
0 g
s
0 0 0 r
.70579 .58532 m .68489 .59779 L .67638 .60817 L p F P
0 g
s
.122 0 0 r
.68489 .59779 m .67638 .60817 L .65298 .61753 L p F P
0 g
s
0 0 0 r
.71021 .58128 m .70579 .58532 L .68489 .59779 L p F P
0 g
s
.67 .94 .667 r
.75801 .53705 m .7501 .54216 L .73367 .56118 L p F P
0 g
s
.67 .94 .667 r
.73367 .56118 m .73421 .56083 L .75801 .53705 L p F P
0 g
s
0 0 0 r
.70579 .58532 m .71021 .58128 L .7318 .56275 L p F P
0 g
s
.725 .207 0 r
.37725 .52208 m .3631 .51093 L .34978 .49483 L p F P
0 g
s
.689 .175 0 r
.33332 .48024 m .34978 .49483 L .3631 .51093 L p F P
0 g
s
.607 .085 0 r
.32954 .47622 m .33332 .48024 L .34978 .49483 L p F P
0 g
s
0 0 0 r
.7245 .56957 m .70579 .58532 L p .72441 .5692 L F P
0 g
s
0 0 0 r
.73367 .56118 m .7245 .56957 L p .72441 .5692 L F P
0 g
s
0 0 0 r
.7245 .56957 m .72396 .57024 L .72451 .5696 L p F P
0 g
s
.601 .879 .56 r
.7245 .56957 m .72567 .56821 L .74799 .54408 L p F P
0 g
s
0 0 0 r
.72451 .5696 m .72567 .56821 L .7245 .56957 L p F P
0 g
s
.601 .879 .56 r
.7501 .54216 m .73367 .56118 L .7245 .56957 L p F P
0 g
s
.753 .262 .068 r
.47569 .59344 m .49059 .60881 L .48935 .60895 L p F P
0 g
s
.753 .262 .068 r
.45725 .58572 m .47569 .59344 L p .48935 .60895 L F P
0 g
s
.64 .102 0 r
.38085 .52482 m .37725 .52208 L .38012 .52408 L closepath p F P
0 g
s
.482 .027 .093 r
.58944 .63779 m .59871 .62667 L .61781 .62488 L p F P
0 g
s
.588 .144 .163 r
.56712 .62601 m .59871 .62667 L .58944 .63779 L p F P
0 g
s
.747 .227 0 r
.41435 .55413 m .39484 .54108 L .38085 .52482 L p F P
0 g
s
.719 .195 0 r
.37725 .52208 m .38085 .52482 L .39484 .54108 L p F P
0 g
s
.588 .144 .163 r
.58944 .63779 m .56491 .62855 L .56712 .62601 L p F P
0 g
s
.662 .232 .216 r
.56491 .62855 m .5597 .62515 L .56712 .62601 L closepath p F P
0 g
s
.758 .246 0 r
.41658 .55713 m .42132 .55827 L p .45079 .58264 L F P
0 g
s
.804 .321 .055 r
.41658 .55713 m .41435 .55413 L .42132 .55827 L closepath p F P
0 g
s
.665 .211 .163 r
.5597 .62515 m .56491 .62855 L .55646 .63599 L p F P
0 g
s
.665 .211 .163 r
.53133 .62074 m .5597 .62515 L p .55646 .63599 L F P
0 g
s
.503 .077 .164 r
.62602 .62567 m .61781 .62488 L .62723 .6238 L closepath p F P
0 g
s
.482 .027 .093 r
.61781 .62488 m .62602 .62567 L p .58944 .63779 L F P
0 g
s
.382 0 .096 r
.62602 .62567 m .62723 .6238 L .65298 .61753 L p F P
0 g
s
.784 .285 0 r
.36565 .51446 m .3631 .51093 L .37725 .52208 L closepath p F P
0 g
s
.719 .195 0 r
.36565 .51446 m .37725 .52208 L p .39484 .54108 L F P
0 g
s
.798 .304 0 r
.41435 .55413 m .41658 .55713 L .40225 .5511 L p F P
0 g
s
.798 .304 0 r
.40225 .5511 m .39484 .54108 L .41435 .55413 L p F P
0 g
s
.665 .211 .163 r
.52784 .62367 m .53133 .62074 L p .55646 .63599 L F P
0 g
s
.724 .289 .216 r
.52784 .62367 m .5225 .61864 L .53133 .62074 L closepath p F P
0 g
s
.579 .105 .093 r
.55646 .63599 m .56491 .62855 L .58944 .63779 L closepath p F P
0 g
s
.928 .973 .725 r
.81851 .45128 m .81927 .45009 L .81901 .4512 L closepath p F P
0 g
s
.904 .985 .749 r
.81901 .4512 m .81851 .45128 L p .79728 .48303 L F P
0 g
s
.549 .046 0 r
.33332 .48024 m .32954 .47622 L .31485 .4616 L p F P
0 g
s
.382 0 .096 r
.65298 .61753 m .65065 .62127 L .62602 .62567 L p F P
0 g
s
.335 0 .003 r
.61845 .63508 m .62602 .62567 L .65065 .62127 L p F P
0 g
s
.482 .027 .093 r
.62602 .62567 m .61845 .63508 L .58944 .63779 L p F P
0 g
s
.939 .96 .745 r
.81927 .45009 m .81851 .45128 L .80877 .45111 L p F P
0 g
s
.939 .96 .745 r
.80877 .45111 m .82267 .42947 L .81927 .45009 L p F P
0 g
s
.753 .262 .068 r
.45344 .58608 m .45725 .58572 L p .48935 .60895 L F P
0 g
s
.797 .333 .136 r
.45344 .58608 m .45079 .58264 L .45725 .58572 L closepath p F P
0 g
s
.904 .985 .749 r
.81851 .45128 m .79882 .4785 L .79728 .48303 L p F P
0 g
s
.919 .973 .771 r
.79882 .4785 m .81851 .45128 L .80877 .45111 L p F P
0 g
s
0 0 0 r
.69971 .59285 m .70579 .58532 L .7245 .56957 L p F P
0 g
s
0 0 0 r
.69971 .59285 m .70579 .58532 L p .67638 .60817 L F P
0 g
s
.758 .246 0 r
.45079 .58264 m .42878 .57065 L .41658 .55713 L p F P
0 g
s
.741 .217 0 r
.42878 .57065 m .41658 .55713 L .40225 .5511 L p F P
0 g
s
.605 .123 0 r
.30491 .44918 m .31485 .4616 L .30006 .44491 L p F P
0 g
s
.605 .123 0 r
.30006 .44491 m .2907 .43319 L .30491 .44918 L p F P
0 g
s
.9 .981 .708 r
.79526 .48381 m .79882 .4785 L .79728 .48303 L closepath p F P
0 g
s
.86 .99 .728 r
.79728 .48303 m .79526 .48381 L p .77433 .51333 L F P
0 g
s
.731 .274 .165 r
.5225 .61864 m .52784 .62367 L .51865 .62901 L p F P
0 g
s
.731 .274 .165 r
.4919 .60984 m .5225 .61864 L p .51865 .62901 L F P
0 g
s
.694 .197 .059 r
.49059 .60881 m .4919 .60984 L .5225 .61864 L p F P
0 g
s
.222 0 .012 r
.65065 .62127 m .65298 .61753 L .67638 .60817 L p F P
0 g
s
.799 .32 .078 r
.45079 .58264 m .45344 .58608 L .43933 .58447 L p F P
0 g
s
.799 .32 .078 r
.43933 .58447 m .42878 .57065 L .45079 .58264 L p F P
0 g
s
.689 .175 0 r
.3631 .51093 m .34659 .49633 L .33332 .48024 L p F P
0 g
s
.64 .139 0 r
.31799 .46494 m .33332 .48024 L .34659 .49633 L p F P
0 g
s
.582 .1 0 r
.31799 .46494 m .33123 .48102 L p .31752 .46496 L F P
0 g
s
.549 .046 0 r
.31485 .4616 m .31799 .46494 L p .31816 .46494 L F P
0 g
s
0 0 .514 r
.31799 .46494 m .31485 .4616 L .30006 .44491 L p F P
0 g
s
0 0 .514 r
.30383 .44892 m .31799 .46494 L p .30378 .44907 L F P
0 g
s
0 0 .514 r
.30006 .44491 m .30383 .44892 L p .30378 .44907 L F P
0 g
s
.582 .1 0 r
.30383 .44892 m .31799 .46494 L p .31752 .46496 L F P
0 g
s
.582 .1 0 r
.31704 .46497 m .30383 .44892 L p .31752 .46496 L F P
0 g
s
.582 .1 0 r
.33123 .48102 m .31704 .46497 L p .31752 .46496 L F P
0 g
s
.614 .157 0 r
.31704 .46497 m .32145 .47114 L .31673 .46498 L p F P
0 g
s
0 0 .478 r
.30383 .44892 m .31704 .46497 L p .30393 .44854 L F P
0 g
s
0 0 .478 r
.30403 .44816 m .29083 .43213 L p .30393 .44854 L F P
0 g
s
0 0 .478 r
.31704 .46497 m .30403 .44816 L p .30393 .44854 L F P
0 g
s
0 0 .437 r
.30403 .44816 m .29461 .4341 L .30407 .44803 L p F P
0 g
s
.614 .157 0 r
.30655 .45168 m .30403 .44816 L .31704 .46497 L p F P
0 g
s
0 0 .437 r
.30407 .44803 m .30655 .45168 L .30403 .44816 L p F P
0 g
s
.614 .157 0 r
.31673 .46498 m .30655 .45168 L p .31704 .46497 L F P
0 g
s
0 0 .478 r
.29083 .43213 m .30383 .44892 L p .30393 .44854 L F P
0 g
s
.549 .046 0 r
.31799 .46494 m .33332 .48024 L p .31816 .46494 L F P
0 g
s
.843 .975 .669 r
.77175 .51495 m .77707 .50745 L .77433 .51333 L closepath p F P
0 g
s
.86 .99 .728 r
.79526 .48381 m .77707 .50745 L .77433 .51333 L p F P
0 g
s
.773 .968 .675 r
.77433 .51333 m .77175 .51495 L p .7501 .54216 L F P
0 g
s
.923 .976 .739 r
.79882 .4785 m .79526 .48381 L .78532 .48554 L p F P
0 g
s
.923 .976 .739 r
.78532 .48554 m .80425 .45736 L .79882 .4785 L p F P
0 g
s
.919 .973 .771 r
.80877 .45111 m .80425 .45736 L .79882 .4785 L p F P
0 g
s
.893 .989 .765 r
.77707 .50745 m .79526 .48381 L .78532 .48554 L closepath p F P
0 g
s
.753 .262 .068 r
.48935 .60895 m .46612 .59927 L .45344 .58608 L p F P
0 g
s
.749 .238 0 r
.46612 .59927 m .45344 .58608 L .43933 .58447 L p F P
0 g
s
.665 .211 .163 r
.55646 .63599 m .54342 .63398 L .52784 .62367 L p F P
0 g
s
.665 .182 .096 r
.54342 .63398 m .51865 .62901 L .52784 .62367 L closepath p F P
0 g
s
.758 .259 0 r
.3631 .51093 m .36565 .51446 L .35102 .50251 L p F P
0 g
s
.758 .259 0 r
.35102 .50251 m .34659 .49633 L .3631 .51093 L p F P
0 g
s
.687 .164 0 r
.4919 .60984 m .48935 .60895 L .49059 .60881 L closepath p F P
0 g
s
.222 0 .012 r
.67638 .60817 m .67524 .61003 L .65065 .62127 L p F P
0 g
s
.136 0 0 r
.64463 .62895 m .65065 .62127 L .67524 .61003 L p F P
0 g
s
.335 0 .003 r
.65065 .62127 m .64463 .62895 L .61845 .63508 L p F P
0 g
s
.727 .927 .587 r
.74799 .54408 m .75325 .53718 L .7501 .54216 L closepath p F P
0 g
s
.773 .968 .675 r
.77175 .51495 m .75325 .53718 L .7501 .54216 L p F P
0 g
s
.601 .879 .56 r
.74799 .54408 m .7501 .54216 L p .7245 .56957 L F P
0 g
s
.736 .255 .101 r
.48935 .60895 m .4919 .60984 L .50915 .62629 L p F P
0 g
s
.731 .274 .165 r
.51865 .62901 m .50915 .62629 L .4919 .60984 L p F P
0 g
s
.889 .986 .721 r
.77707 .50745 m .78532 .48554 L p .76342 .51822 L F P
0 g
s
.889 .986 .721 r
.76342 .51822 m .77175 .51495 L .77707 .50745 L p F P
0 g
s
.719 .195 0 r
.39484 .54108 m .37666 .52731 L .36565 .51446 L p F P
0 g
s
.677 .159 0 r
.37666 .52731 m .36565 .51446 L .35102 .50251 L p F P
0 g
s
.783 .281 0 r
.39484 .54108 m .40225 .5511 L .38774 .54238 L p F P
0 g
s
.783 .281 0 r
.38774 .54238 m .37666 .52731 L .39484 .54108 L p F P
0 g
s
.736 .255 .101 r
.4768 .6127 m .48935 .60895 L p .50915 .62629 L F P
0 g
s
.786 .332 .168 r
.4768 .6127 m .46612 .59927 L .48935 .60895 L closepath p F P
0 g
s
.837 .993 .741 r
.75325 .53718 m .76342 .51822 L .77175 .51495 L closepath p F P
0 g
s
.024 0 0 r
.67524 .61003 m .68338 .60401 L .67638 .60817 L closepath p F P
0 g
s
0 0 0 r
.67638 .60817 m .68338 .60401 L .69971 .59285 L p F P
0 g
s
.814 .974 .674 r
.75325 .53718 m .76342 .51822 L p .74011 .54917 L F P
0 g
s
.814 .974 .674 r
.74011 .54917 m .74799 .54408 L .75325 .53718 L p F P
0 g
s
.796 .302 .01 r
.42878 .57065 m .43933 .58447 L .43322 .5825 L p F P
0 g
s
.796 .302 .01 r
.40834 .55788 m .42878 .57065 L p .43322 .5825 L F P
0 g
s
.741 .217 0 r
.40225 .5511 m .40834 .55788 L .42878 .57065 L p F P
0 g
s
0 0 0 r
.66811 .61935 m .67524 .61003 L .68338 .60401 L p F P
0 g
s
.136 0 0 r
.67524 .61003 m .66811 .61935 L .64463 .62895 L p F P
0 g
s
.716 .955 .672 r
.72567 .56821 m .74011 .54917 L .74799 .54408 L closepath p F P
0 g
s
0 0 .446 r
.2907 .43319 m .30006 .44491 L .28519 .42613 L p F P
0 g
s
0 0 .446 r
.28519 .42613 m .2775 .41651 L .2907 .43319 L p F P
0 g
s
0 0 0 r
.68338 .60401 m .69718 .59526 L p .66811 .61935 L F P
0 g
s
0 0 0 r
.68338 .60401 m .69718 .59526 L .69971 .59285 L closepath p F P
0 g
s
0 0 0 r
.7245 .56957 m .72396 .57024 L .69971 .59285 L p F P
0 g
s
.535 .123 .207 r
.58944 .63779 m .61845 .63508 L .6143 .64217 L closepath p F P
0 g
s
.521 .079 .14 r
.58037 .64962 m .58944 .63779 L .6143 .64217 L p F P
0 g
s
.625 .195 .207 r
.55646 .63599 m .58944 .63779 L .58037 .64962 L p F P
0 g
s
0 0 0 r
.71532 .57846 m .69718 .59526 L p .71546 .57818 L F P
0 g
s
0 0 0 r
.72396 .57024 m .71532 .57846 L p .71546 .57818 L F P
0 g
s
0 0 0 r
.71532 .57846 m .71347 .58093 L .71528 .57853 L p F P
0 g
s
0 0 0 r
.69718 .59526 m .69971 .59285 L .72396 .57024 L p F P
0 g
s
.651 .896 .562 r
.73769 .55144 m .71864 .57407 L .71532 .57846 L p F P
0 g
s
0 0 0 r
.71528 .57853 m .71864 .57407 L .71532 .57846 L p F P
0 g
s
.651 .896 .562 r
.72567 .56821 m .74011 .54917 L p .71532 .57846 L F P
0 g
s
.651 .896 .562 r
.71532 .57846 m .72396 .57024 L .72567 .56821 L p F P
0 g
s
.64 .139 0 r
.34659 .49633 m .33123 .48102 L .31799 .46494 L p F P
0 g
s
.625 .195 .207 r
.55218 .64133 m .55646 .63599 L p .58037 .64962 L F P
0 g
s
.695 .281 .256 r
.55218 .64133 m .54342 .63398 L .55646 .63599 L closepath p F P
0 g
s
.411 0 .141 r
.6143 .64217 m .61845 .63508 L .64463 .62895 L p F P
0 g
s
.942 .942 .758 r
.82267 .42947 m .82407 .41315 L p .80542 .45043 L F P
0 g
s
.942 .942 .758 r
.80542 .45043 m .80877 .45111 L .82267 .42947 L p F P
0 g
s
.704 .265 .207 r
.54342 .63398 m .55218 .64133 L .54617 .64693 L p F P
0 g
s
.704 .265 .207 r
.51865 .62901 m .54342 .63398 L p .54617 .64693 L F P
0 g
s
.711 .182 0 r
.40834 .55788 m .40225 .5511 L .38774 .54238 L p F P
0 g
s
.792 .319 .108 r
.46612 .59927 m .4768 .6127 L .47214 .61295 L p F P
0 g
s
.792 .319 .108 r
.44249 .58778 m .46612 .59927 L p .47214 .61295 L F P
0 g
s
.749 .238 0 r
.43933 .58447 m .44249 .58778 L .46612 .59927 L p F P
0 g
s
.722 .229 0 r
.34659 .49633 m .35102 .50251 L .33628 .48808 L p F P
0 g
s
.722 .229 0 r
.33628 .48808 m .33123 .48102 L .34659 .49633 L p F P
0 g
s
.755 .253 0 r
.37666 .52731 m .38774 .54238 L .37799 .53475 L p F P
0 g
s
.755 .253 0 r
.35981 .5128 m .37666 .52731 L p .37799 .53475 L F P
0 g
s
.677 .159 0 r
.35102 .50251 m .35981 .5128 L .37666 .52731 L p F P
0 g
s
.926 .955 .785 r
.80425 .45736 m .80542 .45043 L .80877 .45111 L closepath p F P
0 g
s
0 0 0 r
.71532 .57846 m .69718 .59526 L .68896 .60617 L p F P
0 g
s
0 0 0 r
.69718 .59526 m .68896 .60617 L .66811 .61935 L p F P
0 g
s
.934 .961 .759 r
.78532 .48554 m .80425 .45736 L .80542 .45043 L p F P
0 g
s
.704 .265 .207 r
.51451 .63266 m .51865 .62901 L p .54617 .64693 L F P
0 g
s
.757 .338 .255 r
.51451 .63266 m .50915 .62629 L .51865 .62901 L closepath p F P
0 g
s
.242 0 .055 r
.63928 .63841 m .64463 .62895 L .66811 .61935 L p F P
0 g
s
.411 0 .141 r
.64463 .62895 m .63928 .63841 L .6143 .64217 L p F P
0 g
s
.621 .117 0 r
.35981 .5128 m .35102 .50251 L .33628 .48808 L p F P
0 g
s
.796 .302 .01 r
.43322 .5825 m .42145 .57519 L .40834 .55788 L p F P
0 g
s
.781 .278 0 r
.38947 .54432 m .40834 .55788 L .42145 .57519 L p F P
0 g
s
.711 .182 0 r
.38774 .54238 m .38947 .54432 L .40834 .55788 L p F P
0 g
s
.769 .33 .207 r
.50915 .62629 m .51451 .63266 L .50584 .63772 L p F P
0 g
s
.769 .33 .207 r
.48077 .61652 m .50915 .62629 L p .50584 .63772 L F P
0 g
s
.736 .255 .101 r
.50915 .62629 m .48077 .61652 L .4768 .6127 L p F P
0 g
s
0 .031 .57 r
.30383 .44892 m .30006 .44491 L .28519 .42613 L p F P
0 g
s
.733 .206 0 r
.44249 .58778 m .43322 .5825 L .43933 .58447 L closepath p F P
0 g
s
.625 .195 .207 r
.58037 .64962 m .56702 .6489 L .55218 .64133 L p F P
0 g
s
.623 .164 .141 r
.56702 .6489 m .54617 .64693 L .55218 .64133 L closepath p F P
0 g
s
.368 0 .049 r
.6103 .64758 m .6143 .64217 L .63928 .63841 L p F P
0 g
s
.521 .079 .14 r
.6143 .64217 m .6103 .64758 L .58037 .64962 L p F P
0 g
s
.941 .963 .727 r
.7751 .48688 m .7887 .46485 L .78532 .48554 L closepath p F P
0 g
s
.889 .986 .721 r
.78532 .48554 m .76485 .51436 L .76342 .51822 L p F P
0 g
s
.916 .979 .755 r
.76485 .51436 m .78532 .48554 L .7751 .48688 L p F P
0 g
s
.934 .961 .759 r
.79872 .44996 m .7887 .46485 L .78532 .48554 L p F P
0 g
s
.934 .961 .759 r
.80542 .45043 m .79872 .44996 L p .78532 .48554 L F P
0 g
s
0 0 .499 r
.2775 .41651 m .28519 .42613 L .27026 .40526 L p F P
0 g
s
0 0 .499 r
.27026 .40526 m .26533 .39909 L .2775 .41651 L p F P
0 g
s
.951 .946 .732 r
.79872 .44996 m .80648 .4369 L .80542 .45043 L closepath p F P
0 g
s
.942 .942 .758 r
.82209 .41266 m .80648 .4369 L .80542 .45043 L p F P
0 g
s
.942 .942 .758 r
.82407 .41315 m .82209 .41266 L p .80542 .45043 L F P
0 g
s
.792 .319 .108 r
.47214 .61295 m .45627 .60527 L .44249 .58778 L p F P
0 g
s
.792 .301 .035 r
.43322 .5825 m .44249 .58778 L .45627 .60527 L p F P
0 g
s
.876 .973 .662 r
.76164 .51933 m .76485 .51436 L .76342 .51822 L closepath p F P
0 g
s
.814 .974 .674 r
.76342 .51822 m .76164 .51933 L p .74011 .54917 L F P
0 g
s
0 .031 .57 r
.28519 .42613 m .29083 .43213 L .30383 .44892 L p F P
0 g
s
.735 .229 .021 r
.48077 .61652 m .47214 .61295 L .4768 .6127 L closepath p F P
0 g
s
.955 .93 .733 r
.82209 .41266 m .82412 .40913 L .82407 .41315 L closepath p F P
0 g
s
.704 .265 .207 r
.54617 .64693 m .52671 .64304 L .51451 .63266 L p F P
0 g
s
.711 .245 .143 r
.52671 .64304 m .50584 .63772 L .51451 .63266 L closepath p F P
0 g
s
.025 0 0 r
.66423 .6264 m .66811 .61935 L .68896 .60617 L closepath p F P
0 g
s
.242 0 .055 r
.66811 .61935 m .66423 .6264 L .63928 .63841 L p F P
0 g
s
.673 .195 0 r
.33123 .48102 m .33628 .48808 L .32145 .47114 L p F P
0 g
s
.673 .195 0 r
.32145 .47114 m .31704 .46497 L .33123 .48102 L p F P
0 g
s
.773 .936 .584 r
.73769 .55144 m .74299 .54376 L .74011 .54917 L closepath p F P
0 g
s
.651 .896 .562 r
.74011 .54917 m .73769 .55144 L p .71532 .57846 L F P
0 g
s
.814 .974 .674 r
.76164 .51933 m .74299 .54376 L .74011 .54917 L p F P
0 g
s
.916 .977 .711 r
.76485 .51436 m .77074 .49301 L p .75192 .52289 L F P
0 g
s
.916 .977 .711 r
.75192 .52289 m .76164 .51933 L .76485 .51436 L p F P
0 g
s
.916 .979 .755 r
.7751 .48688 m .77074 .49301 L .76485 .51436 L p F P
0 g
s
.792 .301 .035 r
.42496 .58077 m .43322 .5825 L p .45627 .60527 L F P
0 g
s
.834 .375 .118 r
.42496 .58077 m .42145 .57519 L .43322 .5825 L closepath p F P
0 g
s
.872 .991 .736 r
.74299 .54376 m .75192 .52289 L .76164 .51933 L closepath p F P
0 g
s
.952 .911 .74 r
.82412 .40913 m .82