(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   8314734,     329548]*)
(*NotebookOutlinePosition[   8316829,     329609]*)
(*  CellTagsIndexPosition[   8316625,     329600]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Coordenadas curvil\[IAcute]neas", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(Off[ParametricPlot3D::ppcom]\), "\n", 
    \(Off[General::spell1]\), "\[IndentingNewLine]", 
    \(Off[General::spell]\)}], "Input",
  InitializationCell->True],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(\(vector2D[x_: {0, 0}, y_]\)\(:=\)\(Arrow[x, x + y]\)\(\ \)\( (*\ 
        traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x . \ 
              Por\ defecto\ x = {0, 0}*) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordpolares := 
        Show[Graphics[{Line[{{\(- .75\), 0}, {2, 0}}], 
              Line[{{0, \(- .3\)}, {0, 2}}], Text["\<Y\>", {0.1, 1.9}], 
              Text["\<X\>", {2,  .1}], {Blue, Text["\<P\>", {1.16, 1}]}, 
              Circle[{0, 0},  .4, {0, \[Pi]/4}], 
              Arrow[ .4 {Cos[\[Pi]/4 -  .07], 
                    Sin[\[Pi]/4 -  .1]},  .4 {\@2/2, \@2/2}, 
                HeadLength ->  .04], {Red, 
                Arrow[{1, 1}, {1, 1} +  .4 {1, 1}, HeadLength ->  .04], 
                Arrow[{1, 1}, {1, 1} +  .4 {\(-1\), 1}, 
                  HeadLength ->  .04]}, {PointSize[ .035], Hue[ .6], 
                Point[{1, 1}], Hue[0], Point[{0, 1}], Point[{1, 0}], 
                Text["\<x=\[Rho]cos\[Theta]\>", {1, \(- .15\)}], 
                Text["\<y=\[Rho]sen\[Theta]\>", {\(- .45\), 1.0}], 
                Text["\<\[Theta]\>", { .5,  .2}], 
                Text[\*"\"\<\[Rho]=\!\(\@\(x\^2 + y\^2\)\)\>\"", {1.15,  \
.6}]}, Text[\*"\"\<\!\(e\_\[Rho]\)\>\"", {1.5, 1.5}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", { .5, 
                  1.5}], {Line[{{0, 0}, {1, 1}}], Dashing[{ .02,  .02}], 
                Line[{{0, 1}, {1, 1}, {1, 0}}]}}], 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          AspectRatio \[Rule] Automatic, 
          TextStyle \[Rule] {FontSize \[Rule] 12, FontWeight -> "\<Bold\>"}, 
          ImageSize \[Rule] {563, 234}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordcilindricas := 
        Show[Graphics[{Line[{{0, 6}, {0, 0}, {2, 4}, {0, 0}, {6, 0}, {0, 
                    0}, {\(-4\), \(-4\)}}], {Dashing[{ .012,  .012}], 
                Line[{{0, 5.5}, {2, 4}, {2, \(-1.5\)}, {0, 
                      0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {3.5, 0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {\(-1.5\), \(-1.5\)}}]}, 
              Circle[{0, 0},  .6, {\(-3\) \[Pi]/4, ArcTan[\(- .75\)]}], {Hue[
                  0], PointSize[ .02], \ Point[{0.01, 5.5}], 
                Text["\<z\>", {\(- .3\), 5.5}], 
                Text[\*"\"\<\[Rho]=\!\(\@\(x\^2 + y\^2\)\)\>\"", {3, \
\(-1.7\)}], Text["\<x=\[Rho]cos\[Theta]\>", {\(-1.7\), \(-1.8\)}], 
                Text["\<y=\[Rho]sen\[Theta]\>", {3.7,  .35}], 
                Text["\<\[Theta]\>", {0, \(-1\)}]}, {Hue[0], 
                PointSize[ .02], \ Point[{3.5, 0}]}, {Hue[0], 
                PointSize[ .02], \ Point[{\(-1.5\), \(-1.5\)}]}, {Hue[0.6], 
                PointSize[ .02], \ Point[{2, 4}]}, {Red, 
                Arrow[{2, 4}, {2, 4} +  .4 {0, 4}, HeadLength ->  .04], 
                Arrow[{2, 4}, {2, 4} +  .6 {2, \(-1.5\)}, 
                  HeadLength ->  .04], \n\t\t\t\tArrow[{2, 4}, {2, 4} + 
                    1.2 {1.3,  .5}, HeadLength ->  .04]}, {Blue, 
                Text["\<P\>", {2.55, 3.9}]}, 
              Text["\<X\>", {\(-3.4\), \(-3.9\)}], 
              Text["\<Z\>", {0.3, 5.95}], Text["\<Y\>", {5.95, 0.25}], 
              Text[\*"\"\<\!\(e\_z\)\>\"", {2, 6}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", {3.9, 4.8}], 
              Text[\*"\"\<\!\(e\_\[Rho]\)\>\"", {3.4, 2.9}]}], 
          AspectRatio \[Rule] Automatic, 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          TextStyle \[Rule] {FontSize \[Rule] 12, 
              FontWeight -> "\<Bold\>"}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(coordesfericas := 
        Show[Graphics[{Line[{{0, 6}, {0, 0}, {2, 4}, {0, 0}, {6, 0}, {0, 
                    0}, {\(-4\), \(-4\)}}], {Dashing[{ .012,  .012}], 
                Line[{{0, 5.5}, {2, 4}, {2, \(-1.5\)}, {0, 
                      0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {3.5, 0}}]}, {Dashing[{ .012,  .012}], 
                Line[{{2, \(-1.5\)}, {\(-1.5\), \(-1.5\)}}]}, 
              Circle[{0, 0}, 2, {ArcTan[2], \[Pi]/2}], 
              Circle[{0, 0},  .6, {\(-3\) \[Pi]/4, ArcTan[\(- .75\)]}], {Hue[
                  0], PointSize[ .02], \ Point[{0.01, 5.5}], 
                Text["\<z=rcos\[Theta]\>", {1, 5.6}], 
                Text[\*"\"\<r=\!\(\@\(x\^2 + y\^2 + z\^2\)\)\>\"", {2.9, 
                    2.12}], Text["\<rsen\[Theta]\>", {2.2, \(-1.8\)}], 
                Text["\<x=rsen\[Theta]cos\[Phi]\>", {\(-1.7\), \(-1.8\)}], 
                Text["\<y=rsen\[Theta]sen\[Phi]\>", {3.7,  .35}], 
                Text["\<\[Theta]\>", { .485, 2.47}], 
                Text["\<\[Phi]\>", {0, \(-1\)}]}, {Hue[0], PointSize[ .02], \ 
                Point[{3.5, 0}]}, {Hue[0], PointSize[ .02], \ 
                Point[{\(-1.5\), \(-1.5\)}]}, {Hue[0.6], PointSize[ .02], \ 
                Point[{2, 4}]}, {Red, 
                Arrow[{2, 4}, {2, 4} +  .4 {2, 4}, HeadLength ->  .04], 
                Arrow[{2, 4}, {2, 4} +  .6 {2, \(-1.5\)}, 
                  HeadLength ->  .04], \n\t\t\t\tArrow[{2, 4}, {2, 4} + 
                    1.2 {1.3,  .5}, HeadLength ->  .04]}, {Blue, 
                Text["\<P\>", {2.55, 3.9}]}, 
              Text["\<X\>", {\(-3.4\), \(-3.9\)}], 
              Text["\<Z\>", {0.3, 5.95}], Text["\<Y\>", {5.95, 0.25}], 
              Text[\*"\"\<\!\(e\_r\)\>\"", {2.9, 5.8}], 
              Text[\*"\"\<\!\(e\_\[Phi]\)\>\"", {3.9, 4.8}], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", {3.4, 2.9}]}], 
          AspectRatio \[Rule] Automatic, 
          Background \[Rule] RGBColor[1, 1, 0.75], 
          TextStyle \[Rule] {FontSize \[Rule] 12, 
              FontWeight -> "\<Bold\>"}];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[{
    \(Unprotect[Sqrt]; 
    Unprotect[Power]; \@p_\^2 := 
      p /; Positive[p]; \@\(p_*q_\) := \(\@p\) \@q /; 
        Positive[p] && Positive[q]; Protect[Power]; Protect[Sqrt];\), "\n", 
    \(\(Unprotect[Positive];\)\), "\n", 
    \(\(Positive[
          Sin[\[Theta]]] = \(Positive[
            r] = \(Positive[\[Rho]] = \(Positive[
                u] = \(Positive[
                  v] = \(Positive[
                    w] = \(Positive[
                      y] = \(Positive[
                        x + \@\(x\^2 + y\^2\)] = \(Positive[\@p_] = \
\(Positive[p_\^2] = \(Positive[p_\^2 + q_\^2] = 
                            True\)\)\)\)\)\)\)\)\)\);\)\), "\n", 
    \(Positive[\(-\@p_\)] = False; 
    Positive[p_\ q_] = Positive[p] && Positive[q]; 
    Positive[1\/p_] = Positive[p];\), "\n", 
    \(\(Protect[Positive];\)\), "\n", 
    \(Unprotect[ArcTan]; 
    ArcTan[\[Rho]\ Cos[\[Theta]], \[Rho]\ Sin[\[Theta]]] = \[Theta]; 
    ArcTan[r\ Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Sin[\[Theta]]\ Sin[\[Phi]]] = \[Phi]; Protect[ArcTan];\), "\n", 
    \(Unprotect[ArcCos]; ArcCos[Cos[\[Theta]]] = \[Theta]; 
    Protect[ArcCos];\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(todospositivos[x_List] := 
      Positive[x[\([1]\)]] && Positive[x[\([2]\)]] && 
        Positive[x[\([3]\)]]\)], "Input",
  InitializationCell->True],

Cell["<<Graphics`Animation`", "Input",
  InitializationCell->True,
  CellTags->"S5.29.1"],

Cell[BoxData[{
    \(\(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Phi]]\ Sin[\[Theta]], 
          r\ Cos[\[Theta]]};\)\), "\[IndentingNewLine]", 
    \(\(planoscoordenados[
          r_, \[Theta]_, \[Phi]_] := {ParametricPlot3D[
            Evaluate[g[r, tz, fi]], {tz, 0, \[Pi]}, {fi, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[u, \[Theta], v]], {u, 0, 3.5}, {v, 0, 
              2  \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[
            Evaluate[g[\[Rho], th, \(-\[Phi]\)]], {\[Rho], 0, 3.5}, {th, 
              0, \[Pi]}, \[IndentingNewLine]BoxRatios \[Rule] {1, 1, 1}, 
            DisplayFunction \[Rule] Identity]};\)\), "\[IndentingNewLine]", 
    \(fg[1] = planoscoordenados[1, \[Pi]/3 -  .9, \(-\[Pi]\)/2. ]; 
    fg[2] = planoscoordenados[1, \[Pi]/3 -  .625, \(-\[Pi]\)/2. ];\), "\n", 
    \(\(fg[3] = 
        planoscoordenados[1, \[Pi]/3 -  .4, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[4] = 
        planoscoordenados[1, \[Pi]/3 -  .125, \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[5] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/2. ];\)\), "\n", 
    \(\(fg[6] = 
        planoscoordenados[1, \[Pi]/3. , \(-3\) \[Pi]/8. ];\)\), "\n", 
    \(\(fg[7] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/4. ];\)\), "\n", 
    \(\(fg[8] = planoscoordenados[1, \[Pi]/3. , \(-\[Pi]\)/8. ];\)\), "\n", 
    \(\(fg[9] = planoscoordenados[1, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(fg[10] = planoscoordenados[1.25, \[Pi]/3. , 0. ];\)\), "\n", 
    \(fg[11] = planoscoordenados[1.5, \[Pi]/3. , 0. ]; 
    fg[12] = planoscoordenados[1.75, \[Pi]/3. , 0. ];\), "\n", 
    \(\(fg[13] = planoscoordenados[2, \[Pi]/3. , 0. ];\)\), "\n", 
    \(\(esfericasmovie := 
        Table[Show[{Graphics3D[{Thickness[ .01], 
                  Line[{{\(-4\), 0, 0}, {4, 0, 
                        0}}], \[IndentingNewLine]Line[{{0, \(-4\), 0}, {0, 4, 
                        0}}], Line[{{0, 0, \(-4\)}, {0, 0, 4}}], 
                  Text["\<x\>", {4, 0, 0}, {\(-1.25\), 1}], 
                  Text["\<y\>", {0, 4, 0}, {\(-1\), 
                      1}], \[IndentingNewLine]Text["\<z\>", {0, 0, 
                      4}, {0, \(-1.25\)}]}], 
              Graphics3D[{Hue[0], PointSize[ .03], Point[g[2, \[Pi]/3, 0]]}], 
              fg[k]}, Boxed \[Rule] False, Axes -> None, 
            PlotRange \[Rule] {{\(-4\), 4}, {\(-4\), 4}, {\(-4\), 4}}, 
            DisplayFunction \[Rule] $DisplayFunction, 
            ImageSize \[Rule] {527.25, 404.375}], {k, 1, 13}];\)\)}], "Input",\

  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Coordenadas polares", "Section"],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta]) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " es una biyecci\[OAcute]n de",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            FormBox[\(\[CapitalOmega] = \),
              "TraditionalForm"], 
            FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "] sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  ". Los n\[UAcute]meros \[Rho] y \[Theta] dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = \[Rho]\ cos\ \[Theta], \ 
      y = \[Rho]\ sen\ \[Theta]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] > 0\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(-\[Pi]\),
            "TraditionalForm"], "<", "\[Theta]", "\[LessEqual]", "\[Pi]"}], 
        TraditionalForm]]],
  " se llaman las coordenadas polares del punto de coordenadas cartesianas  ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(coordpolares;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .83636 
%%ImageSize: 563 234 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
1 1 .75 r
MFill
% Scaling calculations
0.28355 0.34632 0.12381 0.34632 [
[ 0 0 0 0 ]
[ 1 .83636 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .83636 L
0 .83636 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.04 0.01 moveto 0 0 lineto
-0.04 -0.01 lineto fill
-0.04 0.01 moveto 0 0 lineto
-0.04 -0.01 lineto
-0.04 0.01 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.02381 .12381 m
.97619 .12381 L
s
.28355 .01991 m
.28355 .81645 L
s
gsave
.31818 .78182 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97619 .15844 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 1 r
gsave
.68528 .47013 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
(P) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 0 r
newpath
.28355 .12381 .13853 0 45 arc
s
.38812 .2115 m
.3815 .22176 L
s
% Start of user PostScript
0.301933 0.253193 0.282843 0.282843 MAarrowhead1
% End of user PostScript
1 0 0 r
.62987 .47013 m
.7684 .60866 L
s
% Start of user PostScript
1. 1. 1.4 1.4 MAarrowhead1
% End of user PostScript
.62987 .47013 m
.49134 .60866 L
s
% Start of user PostScript
1. 1. 0.6 1.4 MAarrowhead1
% End of user PostScript
0 .4 1 r
.035 w
.62987 .47013 Mdot
1 0 0 r
.28355 .47013 Mdot
.62987 .12381 Mdot
gsave
.62987 .07186 -88.375 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(x) show
70.250 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
77.500 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(r) show
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(cos) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
113.750 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.12771 .47013 -88.4688 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.188 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(y) show
70.438 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
77.688 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(r) show
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(sen) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
113.938 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45671 .19307 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.68182 .3316 -96.8125 -13.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 18.250 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(r) show
70.250 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
1.000 0.000 0.000 setrgbcolor
%%IncludeResource: font Mathematica2Mono-Bold
%%IncludeFont: Mathematica2Mono-Bold
/Mathematica2Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
77.500 9.875 moveto
(\\217) show
88.813 9.875 moveto
(!) show
91.625 9.875 moveto
(!) show
94.438 9.875 moveto
(!) show
97.250 9.875 moveto
(!) show
100.063 9.875 moveto
(!) show
102.875 9.875 moveto
(!) show
105.688 9.875 moveto
(!) show
108.500 9.875 moveto
(!) show
111.313 9.875 moveto
(!) show
114.125 9.875 moveto
(!) show
116.938 9.875 moveto
(!) show
119.750 9.875 moveto
(!) show
122.563 9.875 moveto
(!) show
125.375 9.875 moveto
(!) show
127.000 9.875 moveto
(!) show
89.625 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(x) show
96.875 15.063 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
105.313 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(+) show
115.625 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(y) show
122.875 15.063 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
130.625 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 0 r
gsave
.80303 .64329 -69.4063 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.250 16.750 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(r) show
75.813 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45671 .64329 -69.4063 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.250 16.750 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
75.813 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.5 Mabswid
.28355 .12381 m
.62987 .47013 L
s
[ .02 .02 ] 0 setdash
.28355 .47013 m
.62987 .47013 L
.62987 .12381 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{563, 234},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000=<0001Gb000`400?l00000o`00003oo`3ooooo
0?ooool0ooooC`3oool00?l0oonoo`3ookoo0?oo_dl0oono003o0?oo_ol0oonoo`3ookm?0?oo_`00
o`3ookoo0?oo_ol0oonoC`3ookl00?l0oonoo`3ookoo0?oo_dl0oono003o0?oo_ol0oonoo`3ookm?
0?oo_`00o`3ookoo0?oo_ol0oonoC`3ookl00?l0oonoo`3ookoo0?oo_dl0oono003o0?oo_ol0oono
o`3ookm?0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo
_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono
0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<
0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo
_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o
0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono
0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono
00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07`0oono00<0
oon_0?mb003oLX`0o`3ookn00?oo_`00o`3ookm<0?oo_`030000003ookl0oono07d0oono00<0oi/0
0?l0M03ookl0o`3ookmo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07d0oono00<0okYE0?l0
E@3oj[l0o`3ookmo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono06P0oono00L0okYE0?l0003o
0000o`000?mbS03ookl0oi/000<0o`0000<0oi^O0?oo_`3ookl0203ookl0103ojX`0o`000?oD[`3o
LP030?l000030?nKW`3ookl0oono00<0oono00<0oon_0?mb003o00000`3o00000`3o07@0oono0?oo
_`020?oo_`030?oo[`3oLP00o`000080o`0000<0og:<0?oo_`3ookl00P3ookl00`3o^UD0o`000?l0
00030?l000030?l0E@3oj[l0oono00<0oono00D0okYE0?l0003o0000o`000?l0M03o0?oo_dl0oono
003o0?oo_d`0oono00<000000?oo_`3ookl0J03ookl01`3o^UD0o`000?l0003o0000og:<0?oo_`3o
V`000`3o00000`3oVil0onZ<0?l000050?l000040?l0M03ookl0oono0?ooW`L0o`0000D0o`1d0?oo
_`3ookl0oono0?oZS0080?l000030?oD_`3ookl0onZ<00H0o`0000D0o`1E0?oZ_`3ookl0oono0?nK
00070?l000040?nj[`3ookl0oono0?nK00H0o`0000<0omBo0?oo_`3ookl0o`3ookm;0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono06T0oono00/0oonO0?l0003o0000og:<0?oo[`3oLP00o`000?l0
E@3oj[l0oono0?oZS0060?l000070?l0M03ookl0oono0?oo[`3oLP00o`000?oD_`030?oo_`030?nj
E@3o0000og:<0080oono00<0oi/00?l0003oVil0103ookl01`3oe7@0o`000?oD_`3oojl0og800?l0
003oVil00`3ookl00`3oV`00o`000?mbS0020?oo_`030?njE@3o05D0onZo00<0oono00L0onZ<0?l0
003oVil0oono0?oZS03o0000og:<00<0oono00@0onZ<0?l0003o0000omBoo`3ookm<0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono06/0oono00D0oi/00?l0003o0000o`000?mbS00>0?oo_`030?nK
003o07@0oono00@0oono00H0oi/00?l0E@3oj[l0oonO0?l0003oLX`80?oo_`030?oZS03o0000oi^O
00D0oono00<0oi/00?l0E@3oj[l0103ookl02P3ojX`0o`000?l0003o0000o`1E0?oZ_`3ookl0omAd
0?l0003oe;l40?oo_`030?oo[`3oLP00og:<0?l0oonoC03ookl00?l0oonoC03ookl00`000000oono
0?oo_`1[0?oo_`050?njE@3o0000o`000?l0003o^Zl00`3ookl00`3ojX`0o`000?l000040?l00007
0?l0M03ookl0oono0?oo_`3oe7@0o`000?oD_`040?oo_`060?oDM03o0000omBo0?ooW`3o0000o`1d
1@3ookl01P3oV`00o`1d0?oo_`3ojX`0o`000?mbS0@0oono00L0oon_0?mb003o05D0onZo0?oo_`3o
ojl0og8000@0o`0000D0oi^O0?oo_`3ookl0oono0?oDM0080?l000030?l0E@3oj[l0oono0?l0oono
BP3ookl00?l0oonoC03ookl00`000000oono0?oo_`1Y0?oo_`050?oo[`3oLP00o`000?l0E@3ojYl0
0P3o0000103oLX`0oono0?oo_`3ojX`60?l000080?l0M03ookl0oono0?oo_`3ooil0o`000?l0E@3o
j[l20?oo_`080?oo[`3oLP00o`1E0?oZ_`3ookl0oi/00?l0003oLX`30?oo_`080?ooW`3o0000o`1E
0?oZ_`3oojl0og800?l0003oVil30?oo_`030?nK003o0000og:<0080oono00<0omAd0?l0003o^Zl0
0`3ookl01@3o^UD0o`1E0?oZ_`3ookl0onZ<00T0o`0000<0omBo0?oo_`3ookl0o`3ookm90?oo_`00
o`3ookm<0?oo_`030000003ookl0oono06P0oono00L0onZ<0?l0003o0000o`000?mbS03ookl0oi/0
0080o`0000<0o`1E0?oZ_`3ookl02`3ookl00`3oe7@0o`000?l000040?l000040?nKW`3ookl0oono
0?ooW`L0o`0000@0o`1E0?oZ_`3ookl0onZ<1P3o00001@3o05D0onZo0?oo_`3ookl0oonO00L0o`00
00D0omBo0?oo_`3oojl0og800?l0M0050?oo_`030?oDM03o0000okZ_0?l0oonoB`3ookl00?l0oono
C03ookl00`000000oono0?oo_`1X0?oo_`070?oZS03o0000o`000?l0003oLX`0oono0?nK00020?l0
00030?l0E@3oj[l0oono00`0oono00<0oonO0?l0003o00000P3o00000`3o^Zl0oono0?oo_`030?oo
_`070?nK003o0000o`000?l0003oLX`0omAd0?l0M0040?oo_`050?nK003o0000o`000?l0003oVil0
1@3ookl00`3ooil0o`000?l000030?l000080?l0E@3oj[l0oono0?oo_`3ojX`0o`000?l0E@3oj[l2
0?oo_`040?oo[`3oLP00o`1E0?oZ_ol0oonoB`3ookl00?l0oonoC03ookl00`000000oono0?oo_`2[
0?oo_`030?oDM03o0000o`0000@0o`0000<0oi^O0?oo_`3ookl0o`3ookm:0?oo_`00o`3ookm<0?oo
_`030000003ookl0oono0:`0oono00<0oon_0?mb003o00000P3o00000`3oVil0oono0?oo_`3o0?oo
_d/0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o
0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono
0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono
00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3o
okl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo
_`3ookl0R`3ookl60?l00?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`2:0?oo_`P0
o`00o`3ookm]0?oo_`00o`3ookm<0?oo_`030000003ookl0oono08T0oono2P3o003o0?oo_f`0oono
003o0?oo_d`0oono00<000000?oo_`3ookl0R03ookl<0?l00?l0oonoJ`3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`270?oo_`d0o`00o`3ookm[0?oo_`00o`3ookm<0?oo_`030000003ookl0oono
08L0oono3P3o003o0?oo_fX0oono003N0?oo_oL000001`3o00000`000000o`000?l000040?l008/0
0000gP3ookl00?l0oonoC03ookl2000003P0oono00<000000?oo_`3ookl0C@3ookl70?l000030000
003o0000o`0000@0o`00o`3ookmZ0?oo_`00o`3ookm<0?oo_`030000003ookl0000003L0oono00<0
00000?oo_`3ookl0C@3ookl70?l000030000003o0000o`0000@0o`00o`3ookmZ0?oo_`00o`3ookm<
0?oo_`040000003ookl0oono000003H0oono00<000000?oo_`3ookl0C@3ookl70?l000030000003o
0000o`0000<0o`00o`3ookm[0?oo_`00o`3ookm<0?oo_`050000003ookl0oono0?oo_`000000=@3o
okl00`000000oono0?oo_`1>0?oo_`H0o`0000<000000?l0003o00000`3o003o0?oo_f/0oono003o
0?oo_d`0oono00<000000?oo_`3ookl00P3ookl00`000000oono0?oo_`0a0?oo_`030000003ookl0
oono0500oono1@3o00000`000000o`000?l000020?l00?l0oonoK03ookl00?l0oonoC03ookl00`00
0000oono0?oo_`030?oo_`030000003ookl0oono0300oono00<000000?oo_`3ookl0D@3ookl40?l0
00040000003o0000o`000?l00?l0oonoK@3ookl00?l0oonoC03ookl00`000000oono0?oo_`040?oo
_`030000003ookl0oono02l0oono00<000000?oo_`3ookl0DP3ookl60?l00?l0oonoKP3ookl00?l0
oonoC03ookl00`000000oono0?oo_`050?oo_`030000003ookl0oono02h0oono00<000000?oo_`3o
okl0o`3ooko60?oo_`00o`3ookm<0?oo_`030000003ookl0oono00H0oono00<000000?oo_`3ookl0
;@3ookl00`000000oono0?oo_`3o0?oo_lH0oono003o0?oo_d`0oono00<000000?oo_`3ookl01`3o
okl00`000000oono0?oo_`0/0?oo_`030000003ookl0oono0?l0oonoaP3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`080?oo_`030000003ookl0oono02/0oono00<000000?oo_`3ookl0g`3ookl0
0`3oojl0^W800000000200000003001bS03Zokl0e9/000<0000000<0001d0=Co_`3ookl0f03ookl0
0?l0oonoC03ookl00`000000oono0?oo_`090?oo_`030000003ookl0oono02X0oono00<000000?oo
_`3ookl0g`3ookl00`3oojl0^W800000000200000003001bS03Zokl0e9/000<0000000<0001d0=Co
_`3ookl0f03ookl00?l0oonoC03ookl00`000000oono0?oo_`0:0?oo_`030000003ookl0oono02P0
oono00<000000?oo_`3ookl0hP3ookl02@3oe7@000000000M03Dokl0oono0?ooW`2K0000000009_D
_`3K0?oo_`00o`3ookm<0?oo_`030000003ookl0oono00/0oono00<000000?oo_`3ookl09`3ookl0
0`000000oono0?oo_`1F0?oo_`030000003ookl0oono08X0oono00L0j[YE0000000007@0e?n_0;Yb
00000000L[Z_0=`0oono003o0?oo_d`0oono00<000000?oo_`3ookl0303ookl00`000000oono0?oo
_`0V0?oo_`030000003ookl0oono05H0oono00<000000?oo_`3ookl0R`3ookl01@3DV`0000000000
0000000009^O0=d0oono003o0?oo_d`0oono00<000000?oo_`3ookl03@3ookl00`000000oono0?oo
_`0T0?oo_`030000003ookl0oono05L0oono00<000000?oo_`3ookl0R`3ookl01@3oojl0^W800000
0000LX`0j_no0=d0oono003o0?oo_d`0oono00<000000?oo_`3ookl03P3ookl00`000000oono0?oo
_`0S0?oo_`030000003ookl0oono05L0oono00<000000?oo_`3ookl0R`3ookl01@3oe7@000000000
00000000L[Z_0=d0oono003o0?oo_d`0oono00<000000?oo_`3ookl03`3ookl00`000000oono0?oo
_`0R0?oo_`030000003ookl0oono05L0oono00<000000?oo_`3ookl0RP3ookl01`3ojX`0LP000000
E@2jjYl0V`000000002Ke;l0g03ookl00?l0oonoC03ookl00`000000oono0?oo_`0@0?oo_`030000
003ookl0oono0200oono00<000000?oo_`3ookl0F03ookl00`000000oono0?oo_`290?oo_`090?oZ
S01b0000000009_D_`3ookl0onZ<0780000005D0^^Zo0=/0oono003o0?oo_d`0oono00<000000?oo
_`3ookl04@3ookl00`000000oono0?oo_`0O0?oo_`030000003ookl0oono05P0oono00<000000?oo
_`3ookl0R03ookl01`3DV`000000000000000000L[Z_0?oo_`3Z^UD00`0000000`00LX`0j_no0?oo
_`3H0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0180oono00<000000?oo_`3ookl07@3ookl0
0`000000oono0?oo_`1I0?oo_`030000003ookl0oono08P0oono00L0e9/0000000000000000007:j
[`3ookl0j[YE00<0000000<007:<0>[o_`3ookl0f03ookl00?l0oonoC03ookl00`000000oono0?oo
_`0C0?oo_`030000003ookl0oono01`0oono00<000000?oo_`3ookl0F@3ookl00`000000oono0?oo
_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0503ookl00`000000oono0?oo_`0K
0?oo_`030000003ookl0oono0?l0oonobP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0E0?oo
_`030000003ookl0oono01T0oono00<000000?oo_`3ookl0o`3ooko;0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono01H0oono00<000000?oo_`3ookl04P3ookl00`000000oono0?oo_`030?oo_`03
0000003ookl0oono0?l0oonob`3ookl00?l0oonoC03ookl00`000000oono0?oo_`0G0?oo_`030000
003ookl0oono0140oono0`0000030?oo_`030000003ookl0oono00h0oono00D0okYE0?l0003o0000
o`000?l0M03o0?oo_kP0oono003o0?oo_d`0oono00<000000?oo_`3ookl0603ookl00`000000oono
0?oo_`0?0?oo_`D0000000<0oono0000003ookl03`3ookl00`3oV`00o`000?l000040?l000030?oD
_`3ookl0oono0?l0oono]03ookl00?l0oonoC03ookl00`000000oono0?oo_`0I0?oo_`030000003o
okl0oono00h0oono1`00000?0?oo_`030?oZS03o0000og:<00<0oono00@0onZ<0?l0003o0000omBo
o`3ookne0?oo_`00o`3ookm<0?oo_`030000003ookl0oono01X0oono00<000000?oo_`3ookl03@3o
okl8000000h0oono00<0omAd0?l0003oe;l0103ookl00`3oojl0og800?mbS03o0?oo_kD0oono003o
0?oo_d`0oono00<000000?oo_`3ookl06`3ookl00`000000oono0?oo_`0;0?oo_`X000003@3ookl0
0`3oe7@0o`000?l000060?l000030?l0E@3oj[l0oono0?l0oono/`3ookl00?l0oonoC03ookl00`00
0000oono0?oo_`0L0?oo_`030000003ookl0oono00X0oono2@00000>0?oo_`030?oZS03o0000o`00
00L0o`0000<0omBo0?oo_`3ookl0@@3ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0
oono00<000000?oo_`3ookl07@3ookl00`000000oono0?oo_`090?oo_`P000003`3ookl00`3oojl0
og800?l0M0050?oo_`030?oDM03o0000okZ_04<0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00
o`3ookm<0?oo_`030000003ookl0oono01h0oono00<000000?oo_`3ookl01`3ookl800000140oono
00@0onZ<0?l0003o05D0onZo0P3ookl0103oojl0og800?l0E@3oj[m30?oo_`030000003ookl0oono
0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0O0?oo_`030000003ookl0oono00H0
oono1`00000C0?oo_`030?oDM03o0000o`0000@0o`0000<0oi^O0?oo_`3ookl0@P3ookl00`000000
oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0803ookl00`000000oono
0?oo_`050?oo_`H000005@3ookl00`3oojl0og800?l000020?l000030?nKW`3ookl0oono04<0oono
00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0240oono00<0
00000?oo_`3ookl0103ookl500000640oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<
0?oo_`030000003ookl0oono0280oono00<000000?oo_`3ookl00P3ookl4000006<0oono00<00000
0?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono02<0oono00@000000?oo
_`3ookl0oono0`00001T0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`00
0000oono0?oo_`0T0?oo_`030000003ookl0oono00800000I@3ookl00`000000oono0?oo_`3o0?oo
_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl09@3ookl300000?l0oonoe`3ookl00?l0oono
C03ookl00`000000oono0?oo_`0V0?oo_`030000003ookl0oono0?l0oonoeP3ookl00?l0oonoC03o
okl00`000000oono0?oo_`0W0?oo_`030000003ookl0oono0?l0oonoe@3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`0X0?oo_`030000003ookl0oono0?l0oonoe03ookl00?l0oonoC03ookl00`00
0000oono0?oo_`0Y0?oo_`030000003ookl0oono0?l0oonod`3ookl00?l0oonoC03ookl00`000000
oono0?oo_`0Z0?oo_`030000003ookl0oono0?l0oonodP3ookl00?l0oonoC03ookl00`000000oono
0?oo_`0[0?oo_`030000003ookl0oono0?l0oonod@3ookl00?l0oonoC03ookl00`000000oono0?oo
_`0/0?oo_`030000003ookl0oono05l0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<
0?oo_`030000003ookl0oono02d0oono00<000000?oo_`3ookl0GP3ookl00`000000oono0?oo_`3o
0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0;P3ookl00`000000oono0?oo_`1M0?oo
_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0_0?oo_`03
0000003ookl0oono05`0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono0300oono00<000000?oo_`3ookl0F`3ookl00`000000oono0?oo_`3o0?oo_fh0oono
003o0?oo_d`0oono00<000000?oo_`3ookl0<@3ookl00`000000oono0?oo_`1J0?oo_`030000003o
okl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0b0?oo_`030000003ookl0
oono05T0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono
03<0oono00<000000?oo_`3ookl0F03ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0
oono00<000000?oo_`3ookl0=03ookl00`000000oono0?oo_`1G0?oo_`030000003ookl0oono0?l0
oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0e0?oo_`030000003ookl0oono05H0oono
00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono03H0oono00<0
00000?oo_`3ookl0o`3ooko60?oo_`00o`3ookm<0?oo_`030000003ookl0oono03L0oono00<00000
0?oo_`3ookl0o`3ooko50?oo_`00o`3ookm<0?oo_`030000003ookl0oono03P0oono00<000000?oo
_`3ookl0o`3ooko40?oo_`00o`3ookm<0?oo_`030000003ookl0oono03T0oono00<000000?oo_`3o
okl0o`3ooko30?oo_`00o`3ookm<0?oo_`030000003ookl0oono03X0oono00<000000?oo_`3ookl0
o`3ooko20?oo_`00o`3ookm<0?oo_`030000003ookl0oono03/0oono00<000000?oo_`3ookl0o`3o
oko10?oo_`00o`3ookm<0?oo_`030000003ookl0oono03`0oono00<000000?oo_`3ookl0o`3ooko0
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono03d0oono00<000000?oo_`3ookl0CP3ookl00`00
0000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0?P3ookl00`000000
oono0?oo_`1=0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono
0?oo_`0o0?oo_`030000003ookl0oono04`0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono0400oono00<000000?oo_`3ookl0B`3ookl00`000000oono0?oo
_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0@@3ookl00`000000oono0?oo_`1:
0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`120?oo
_`030000003ookl0oono04T0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono04<0oono00<000000?oo_`3ookl0B03ookl00`000000oono0?oo_`3o0?oo_fh0
oono003o0?oo_d`0oono00<000000?oo_`3ookl0A03ookl00`000000oono0?oo_`170?oo_`030000
003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`150?oo_`030000003o
okl0oono04H0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0
oono04H0oono00<000000?oo_`3ookl0A@3ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo
_d`0oono00<000000?oo_`3ookl0A`3ookl00`000000oono0?oo_`3o0?oo_kD0oono003o0?oo_d`0
oono00<000000?oo_`3ookl0B03ookl00`000000oono0?oo_`3o0?oo_k@0oono003o0?oo_d`0oono
00<000000?oo_`3ookl0B@3ookl00`000000oono0?oo_`3o0?oo_k<0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0BP3ookl00`000000oono0?oo_`3o0?oo_k80oono003o0?oo_d`0oono00<00000
0?oo_`3ookl0B`3ookl00`000000oono0?oo_`0R0?oo_`030?oo[`3oLP00og:<04d0oono00<0oi/0
0?l0003o00000`3o00000`3oLX`0oono0?oo_`3o0?oo_cH0oono003o0?oo_d`0oono00<000000?oo
_`3ookl0C03ookl00`000000oono0?oo_`0R0?oo_`030?nK003o07@0oono01/0oono00<0oonO0?oD
_`3ookl0;P3ookl00`3oV`00o`000?l000030?l000030?mbS03ookl0oono0?l0oono=P3ookl00?l0
oonoC03ookl00`000000oono0?oo_`1=0?oo_`030000003ookl0oono0240oono00<0okYE0?l0E@3o
j[l06`3ookl00`3o^UD0oi^O0?oo_`0a0?oo_`030?oDM03o0000og:<0?l0oono>@3ookl00?l0oono
C03ookl00`000000oono0?oo_`1>0?oo_`030000003ookl0oono0200oono00@0onZ<0?l0003oe:l0
og800`3o00000`3oVil0oono0?oo_`0C0?oo_`030000003o0000o`1d00P0oono00L0okYE0?l0003o
0000o`000?mbS03ookl0oi/000<0o`0000<0oi^O0?oo_`3ookl03P3ookl00`3oe7@0o`000?oD_`0=
0?oo_`030?nK003o0000omBo0?l0oono>03ookl00?l0oonoC03ookl00`000000oono0?oo_`1?0?oo
_`030000003ookl0oono01l0oono00<0oonO0?l0003o00001@3o0000103o07@0oono0?oo_`3ojX`6
0?l000030?l0M03ookl0oono00P0oono00@000000?l0003o0000omBo1`3ookl01`3o^UD0o`000?l0
003o0000og:<0?oo_`3oV`000`3o00000`3oVil0oono0?oo_`0>0?oo_`030?oDM03o0000omBo00`0
oono00@0onZ<0?l0003o0000og:<o`3ooklh0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0500
oono00<000000?oo_`3ookl07P3ookl0103oojl0og800?l0003oe;l30?oo_`050?njE@3o0000og:<
0?oo_`3ojX`01P3o00000`3o07@0oono0?oo_`070?oo_`050?ooW`000000og9E0?l0003o^Zl0203o
okl02@3ooil0o`000?l0003oLX`0oon_0?mb003o0000o`1E0?oZ_`0A0?oo_`030?oDM03o0000omBo
00`0oono00D0oi/00?l0003o0000o`000?oD_`3o0?oo_cL0oono003o0?oo_d`0oono00<000000?oo
_`3ookl0D@3ookl00`000000oono0?oo_`0N0?oo_`030?nK003o07@0oono00@0oono00<0oi/00?l0
E@3oj[l04@3ookl01@3o^UD000000?oD_`3oV`00og:<00X0oono00D0oi/00?l0003o0000o`000?mb
S00@0?oo_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3ookl01`3ookl01P3oe7@0o`000?mb
S03ojX`0o`000?l0M?l0oono=`3ookl00?l0oonoC03ookl00`000000oono0?oo_`1B0?oo_`030000
003ookl0oono01d0oono00<0omAd0?l0003oe;l0103ookl0103oe7@0o`000?oD_`3ojX`60?l00003
0?l0M03ookl0oono00H0oono00L0oonO0?l000000000oono0?njE@3o05D0onZo00T0oono00D0okYE
0?l0003o0000o`000?nj[`0@0?oo_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3ookl01P3o
okl0203oojl0og800?l0E@3oj[l0oono0?njE@3o0000okZ_o`3ooklf0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono05<0oono00<000000?oo_`3ookl0703ookl0103ooil0o`000?l0E@3oj[l20?oo
_`050?oo[`3oLP00o`1E0?oZ_`3ojX`01P3o00000`3o07@0oono0?oo_`060?oo_`070?njE@3o0000
00000?oo_`3ojX`0o`000?nj[`070?oo_`050?oo[`3oLP00o`000?l0E@3ojYl00P3o00000`3oLX`0
oono0?oDM0050?l000030?nKW`3ookl0oono00P0oono00<0omAd0?l0003oe;l02P3ookl00`3oe7@0
o`000?nKW`020?oo_`050?ooW`3o0000o`1d0?oo_`3oe7@01@3o00000`3oVil0oono0?oo_`3o0?oo
_b`0oono003o0?oo_d`0oono00<000000?oo_`3ookl0E03ookl00`000000oono0?oo_`0L0?oo_`03
0?oDM03o0000o`0000@0o`0000<0oi^O0?oo_`3ookl03P3ookl0203ooil0o`000?mbS0000000oono
0?oo[`3oLP00og:<1P3ookl01`3ojX`0o`000?l0003o0000og:<0?oo_`3oV`000P3o00001@3o05D0
onZo0?njE@3o0000omBo00d0oono00<0omAd0?l0003oe;l02@3ookl01`3o^UD0o`000?l0003o0000
oi^O0?oo[`3oLP000`3o0000103oe;l0okYE0?l0003oe;oo0?oo_c40oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0E@3ookl00`000000oono0?oo_`0L0?oo_`030?ooW`3o0000o`000080o`0000<0
okZ_0?oo_`3ookl03`3ookl0103o^UD0o`000?oD_`0000020?oo_`030?njE@3o07@0oono00D0oono
00L0onZ<0?l0003o0000o`000?mbS03ookl0oi/00080o`0000H0o`1E0?oZ_`3ookl0oonO0?l0003o
Vil<0?oo_`030?oDM03o0000omBo00T0oono00L0okYE0?l0003o0000o`000?nKW`3oojl0og8000<0
o`0000D0omBo0?oo_`3ooil0o`000?nKW`3o0?oo_c00oono003o0?oo_d`0oono00<000000?oo_`3o
okl0EP3ookl00`000000oono0?oo_`0^0?oo_`080?nK003o0000oi^O0?ooW`3o0000og:<0?oo_`00
00020?oo_`030?oDM03o0000omBo0180oono00<0oon_0?mb003oLX`0903ookl00`3oojl0og800?mb
S03o0?oo_bl0oono003o0?oo_d`0oono00<000000?oo_`3ookl0E`3ookl00`000000oono0?oo_`0]
0?oo_`030?oo[`3oLP00o`000080o`0000<0omBo0?oo_`3ookl00P3ookl00`3ooil0o`000?nKW`0C
0?oo_`030?oo[`3oLP00oi^O02@0oono00<0oon_0?mb003oVil0o`3ookl^0?oo_`00o`3ookm<0?oo
_`030000003ookl0oono05P0oono00<000000?oo_`3ookl0;`3ookl00`3o^UD0og:<0?oo_`050?oo
_`030?nK003o07@0oono00h0oono00<0oonO0?l0003oe;l00P3ookl00`3o^UD0og:<0?oo_`0O0?oo
_`030?ooW`3o0000omBo0080oono00<0okYE0?mbS03ookl0o`3ookl]0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono05T0oono00<000000?oo_`3ookl0=P3ookl00`3oe7@0o`000?oD_`0>0?oo_`07
0?oo[`3oLP00oi^O0?oo_`3ooil0o`000?nj[`0P0?oo_`070?oo[`3oLP00oi^O0?oo_`3ooil0o`00
0?nj[`3o0?oo_bh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0FP3ookl00`000000oono0?oo
_`0e0?oo_`030?oZS03o0000okZ_00l0oono00D0oon_0?mb003o0000o`000?nKW`0R0?oo_`050?oo
[`3oLP00o`000?l0003oVil0o`3ookl_0?oo_`00o`3ookm<0?oo_`030000003ookl0oono05/0oono
00<000000?oo_`3ookl0=03ookl00`3oojl0og800?mbS03o0?oo_fX0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0G03ookl00`000000oono0?oo_`0d0?oo_`030?njE@3o05D0onZo0?l0oonoJ@3o
okl00?l0oonoC03ookl00`000000oono0?oo_`1M0?oo_`030000003ookl0oono03<0oono00<0onZ<
0?l0003o^Zl0o`3ookmY0?oo_`00o`3ookm<0?oo_`030000003ookl0oono05h0oono00<000000?oo
_`3ookl0<P3ookl00`3ooil0o`000?mbS03o0?oo_fT0oono003o0?oo_d`0oono00<000000?oo_`3o
okl0G`3ookl00`000000oono0?oo_`0/0?oo_`030000003ookl0oono00<0oono00<0oi/00?l0003o
0000?P3o00000`3o07@0oono0?oo_`3o0?oo_bL0oono003o0?oo_d`0oono00<000000?oo_`3ookl0
H03ookl00`000000oono0?oo_`0[0?oo_`030000003ookl0oono00<0oono00<0omAd0?l0003o0000
?P3o00000`3o07@0oono0?oo_`3o0?oo_bL0oono003o0?oo_d`0oono00<000000?oo_`3ookl0H@3o
okl00`000000oono0?oo_`0Z0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`1R0?oo_`030000003ookl0oono02T0oono00<000000?oo_`3ookl0o`3ookm^
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono06<0oono00<000000?oo_`3ookl0:03ookl00`00
0000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0I03ookl00`000000
oono0?oo_`0W0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono
0?oo_`1U0?oo_`030000003ookl0oono02H0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono06H0oono00<000000?oo_`3ookl09@3ookl00`000000oono0?oo
_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0I`3ookl00`000000oono0?oo_`0T
0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`1X0?oo
_`030000003ookl0oono0?l0oonoU03ookl00?l0oonoC03ookl00`000000oono0?oo_`1Y0?oo_`03
0000003ookl0oono0?l0oonoT`3ookl00?l0oonoC03ookl00`000000oono0?oo_`1Z0?oo_`030000
003ookl0oono0?l0oonoTP3ookl00?l0oonoC03ookl00`000000oono0?oo_`1[0?oo_`030000003o
okl0oono0?l0oonoT@3ookl00?l0oonoC03ookl00`000000oono0?oo_`1/0?oo_`030000003ookl0
oono0?l0oonoT03ookl00?l0oonoC03ookl00`000000oono0?oo_`1]0?oo_`030000003ookl0oono
0?l0oonoS`3ookl00?l0oonoC03ookl00`000000oono0?oo_`1^0?oo_`030000003ookl0oono0?l0
oonoSP3ookl00?l0oonoC03ookl00`000000oono0?oo_`1_0?oo_`030000003ookl0oono01`0oono
00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0700oono00<0
00000?oo_`3ookl06`3ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<00000
0?oo_`3ookl0L@3ookl00`000000oono0?oo_`0J0?oo_`030000003ookl0oono0?l0oonoKP3ookl0
0?l0oonoC03ookl00`000000oono0?oo_`1b0?oo_`030000003ookl0oono01T0oono00<000000?oo
_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07<0oono00<000000?oo_`3o
okl0603ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0
M03ookl00`000000oono0?oo_`0G0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03o
okl00`000000oono0?oo_`1e0?oo_`030000003ookl0oono01H0oono00<000000?oo_`3ookl0o`3o
okm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07H0oono00<000000?oo_`3ookl05@3ookl0
0`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3ookl0M`3ookl00`00
0000oono0?oo_`0D0?oo_`030000003ookl0oono0?l0oonoKP3ookl00?l0oonoC03ookl00`000000
oono0?oo_`1h0?oo_`030000003ookl0oono01<0oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00
o`3ookm<0?oo_`030000003ookl0oono07T0oono00<000000?oo_`3ookl0o`3ookn30?oo_`00o`3o
okm<0?oo_`030000003ookl0oono07X0oono00<000000?oo_`3ookl0o`3ookn20?oo_`00o`3ookm<
0?oo_`030000003ookl0oono07/0oono00<000000?oo_`3ookl0o`3ookn10?oo_`00o`3ookm<0?oo
_`030000003ookl0oono07`0oono00<000000?oo_`3ookl0o`3ookn00?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono07d0oono00<000000?oo_`3ookl0o`3ookmo0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono07h0oono00<000000?oo_`3ookl0o`3ookmn0?oo_`00o`3ookm<0?oo_`030000003o
okl0oono07l0oono00<000000?oo_`3ookl0o`3ookmm0?oo_`00o`3ookm<0?oo_`030000003ookl0
oono0800oono00<000000?oo_`3ookl02`3ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo
_d`0oono00<000000?oo_`3ookl0P@3ookl00`000000oono0?oo_`0:0?oo_`030000003ookl0oono
0?l0oonoKP3ookl00?l0oonoC03ookl00`000000oono0?oo_`220?oo_`030000003ookl0oono00T0
oono00<000000?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono08<0oono
00<000000?oo_`3ookl0203ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0Q03ookl00`000000oono0?oo_`070?oo_`030000003ookl0oono0?l0oonoKP3o
okl00?l0oonoC03ookl00`000000oono0?oo_`250?oo_`030000003ookl0oono00H0oono00<00000
0?oo_`3ookl0o`3ookm^0?oo_`00o`3ookm<0?oo_`030000003ookl0oono08H0oono00<000000?oo
_`3ookl01@3ookl00`000000oono0?oo_`3o0?oo_fh0oono003o0?oo_d`0oono00<000000?oo_`3o
okl0Q`3ookl00`000000oono0?oo_`040?oo_`030000003ookl0oono0?l0oonoKP3ookl00>@0oono
00<0oi/00?l0003o00000`3o00000`3oLX`0oono0?oo_`0;0?oo_`030?oo[`3oLP00og:<04d0oono
1P3o00280?oo_`030000003ookl0oono00<006Ko00<00000001Vo`00I_l0o`3ookm^0?oo_`00i03o
okl00`3oV`00o`000?l000030?l000030?mbS03ookl0oono00`0oono00<0oi/00?l0M03ookl0B`3o
okl80?l008P0oono00<00000001Vo`00I_l00P00I_l01000000006Ko001Vo`00I_oo0?oo_fd0oono
003W0?oo_`030?oDM03o0000og:<00l0oono00<0okYE0?l0E@3oj[l0BP3ookl:0?l008L0oono00<0
06Ko00000000I_l01`00I_oo0?oo_f`0oono003X0?oo_`030?nK003o0000omBo00h0oono00@0onZ<
0?l0003oe:l0og800`3o00000`3oVil0oono0?oo_`020?oo_`030?njE@3o0000o`0000<0o`0000<0
o`1E0?oZ_`3ookl00`3ookl00`3ooil0o`000?l000040?l000030?oD_`3ookl0omAd00<0o`0000<0
og:<0?oo_`3o^UD00`3o0000103o^Zl0oono0?oo_`3o^UD30?l000030?l0M03ookl0oono01L0oono
303o00250?oo_`<006Ko00<00000001Vo`00I_l01P00I_l;0?oo_`030?oob`2jL_l0003o00@0003o
00<0VmBo0?oo_`3ookl0o`3ookmF0?oo_`00i`3ookl0103ojX`0o`000?l0003oLX`40?oo_`030?oZ
S03o0000o`0000@0o`0000@0o`1d0?oo_`3ookl0oonO1`3o00001@3o07@0oono0?oo_`3ookl0oi/0
00L0o`0000@0okZ_0?oo_`3ookl0okYE1`3o00000`3o05D0onZo0?oDM0030?l000030?mbS03ookl0
okYE00<0o`0000<0okZ_0?oo_`3oV`001P3o00000`3oe;l0oono0?oo_`0D0?oo_`d0o`00Q03ookl5
001Vo`0300000000I_l006Ko00D006Ko2`3ookl00`3ool/0^W;o0000o`040000o`0309_D_`3ookl0
oono0?l0oonoEP3ookl00>L0oono00D0oi/00?l0003o0000o`000?oD_`030?oo_`030?oZS03o0000
o`0000@0o`0000L0o`1d0?oo_`3ookl0oon_0?mb003o0000omBo00<0oono00<0okYE0?l0003oLX`0
0P3ookl00`3o^UD0o`1E0?oZ_`030?oo_`070?oZS03o0000oi^O0?oo_`3ojX`0o`000?l0M0090?oo
_`030?oZS03o0000oi^O00<0oono00L0omAd0?l0003oe;l0oono0?oZS03o0000og:<00<0oono00@0
onZ<0?l0003o0000omBo5@3ookl>0?l008<0oono1P00I_l00`00000006Ko001Vo`05001Vo``0oono
00<0omC/0000o`1b^//0o`3ookmK0?oo_`00iP3ookl01P3oe7@0o`000?mbS03ojX`0o`000?l0M0h0
oono00<0oi/00?l0M03ookl0103ookl00`3oV`00o`1E0?oZ_`040?oo_`080?oZS03o0000o`000?l0
003o05D0onZo0?oo_`3oe7@80?l000060?l0E@3oj[l0oono0?oZS03o0000oi^O0`3ookl01`3oe7@0
o`000?oD_`3ookl0omAd0?l0003oe;l0103ookl00`3oojl0og800?mbS00E0?oo_`L0o`002@000007
0?oo_`X000001`3ookl9000000P0oono2@0000080?oo_`T000001`3ookl:000000L0oono2@000008
0?oo_`T00000203ookl90000008006Ko00<00000001Vo`00I_l01000I_l<0?oo_`030?oDk0000?l0
L[[;0?l0oonoF`3ookl00>D0oono00P0oon_0?mb003o05D0onZo0?oo_`3o^UD0o`000?nj[`80oono
00<0onZ<0?l0003o0000103o00001`3o07@0oono0?oo_`3ookl0omAd0?l0003oe;l0103ookl01P3o
e7@0o`000?oD_`3ookl0oon_0?mb00@0o`0000D0oi^O0?oo_`3ookl0oono0?oDM0080?l000060?l0
M03ookl0oono0?oZS03o0000oi^O0`3ookl01@3oe7@0o`000?oD_`3ookl0omAd00P0o`0000<0o`1E
0?oZ_`3ookl04`3ookl>0?l008<0oono3P00I_l<0?oo_`030?oDk0000?l0003o00<0003o00<0VmBo
0?oo_`3ookl0o`3ookmE0?oo_`00i@3ookl00`3oe7@0o`000?nKW`020?oo_`030?ooW`3o0000o`1d
0080oono00<0onZ<0?l0003o0000103o0000203o07@0oono0?oo_`3ookl0oonO0?l0003o05D0onZo
0P3ookl0203oojl0og800?l0E@3oj[l0oono0?oDM03o0000okZ_0`3ookl0203o^UD0o`1E0?oZ_`3o
okl0onZ<0?l0003o05D0onZo0`3ookl00`3oe7@0o`000?nKW`020?oo_`040?oZS03o0000o`000?oD
_`80oono00D0okYE0?l0003oe;l0oono0?oZS0090?l000030?oD_`3ookl0oono0180oono3P3o0023
0?oo_`h006Ko303ookl00`3oe>`0003o0000o`040000o`03002Ke`3ookl0oono0?l0oonoE03ookl0
0>@0oono00L0okYE0?l0003o0000o`000?nKW`3oojl0og8000<0o`0000<0omBo0?oo_`3ookl02P3o
okl00`3oe7@0o`000?l000040?l000040?nKW`3ookl0oono0?ooW`L0o`0000@0omBo0?oo_`3ookl0
omAd1P3o0000103o07@0oono0?oo_`3oe7@20?l000030?nKM03o0000o`000080o`0000H0o`1E0?oZ
_`3ookl0oon_0?mb003o07@50?oo_`030?oDM03o0000okZ_01@0oono3@3o00240?oo_`d006Ko3@3o
okl00`3oe>`0003o07:jb`020?oo_`040?ooe`2K0?l0003o09_D_ol0oonoE@3ookl00>@0oono00L0
okYE0?l0003o0000o`000?nKW`3oojl0og8000<0o`0000<0omBo0?oo_`3ookl02`3ookl00`3ooil0
o`000?l000020?l000030?nj[`3ookl0oono0080oono00<0oonO0?l0003o00000`3o00000`3o05D0
onZo0?oo_`020?oo_`030?ooW`3o0000o`000080o`0000D0oi^O0?oo_`3ookl0oono0?oDM0020?l0
00060?nKW`3ojX`0o`000?l0003o05D0onZo0`3ookl0103ojX`0o`000?l0E@3oj[l20?oo_`040?oo
[`3oLP00o`1E0?oZ_aD0oono303o00250?oo_``006Ko3@3ookl00`3oe>`0003o07:jb`030?oo_`03
0?oDk0000?l0L[[;0?l0oonoE@3ookl00?l0oono:03ookl00`3oe7@0o`000?l000040?l000030?nK
W`3ookl0oono01D0oono2P3o00270?oo_`X006Ko00<0o`000?oo_`3ookl02`3ookl00`3oe>`0003o
07:jb`020?oo_`040?oob`2jL_l0003o09_D_ol0oonoE@3ookl00?l0oono:@3ookl00`3oojl0og80
0?l000020?l000030?nKW`3ookl0oono01L0oono203o00270?oo_`030?l0003ookl006Ko00L006Ko
0P3ookl00`3o0000oono0?oo_`080?oo_`030?oob`2jL_l0003o00H0003o00<007;R0>[o_`3ookl0
o`3ookmD0?oo_`00o`3ookm90?oo_`H0o`00Q`3ookl0103o0000oono0?oo_`3ookl6001Vo`@0oono
00<0o`000?oo_`3ookl01`3ookl00`3ool/0^W;o0000o`050000o`03002Ke`3ookl0oono0?l0oono
E@3ookl00?l0oonoC03ookl00`000000oono0?oo_`260?oo_`030?l0003ookl0oono00d0oono00<0
o`000?oo_`3ookl0o`3ookmV0?oo_`00o`3ookm<0?oo_`030000003ookl0oono08D0oono00<0o`00
0?oo_`3ookl03`3ookl00`3o0000oono0?oo_`3o0?oo_fD0oono003o0?oo_d`0oono00<000000?oo
_`3ookl0Q03ookl00`3o0000oono0?oo_`0A0?oo_`030?l0003ookl0oono0?l0oonoI03ookl00?l0
oonoC03ookl00`000000oono0?oo_`230?oo_`030?l0003ookl0oono01<0oono00<0o`000?oo_`3o
okl0o`3ookmS0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0880oono00<0o`000?oo_`3ookl0
5@3ookl00`3o0000oono0?oo_`3o0?oo_f80oono003o0?oo_d`0oono00<000000?oo_`3ookl0P@3o
okl00`3o0000oono0?oo_`0G0?oo_`030?l0003ookl0oono0?l0oonoH@3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`200?oo_`030?l0003ookl0oono01T0oono00<0o`000?oo_`3ookl0o`3ookmP
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07l0oono00<0o`000?oo_`3ookl06`3ookl00`3o
0000oono0?oo_`3o0?oo_el0oono003o0?oo_d`0oono00<000000?oo_`3ookl0OP3ookl00`3o0000
oono0?oo_`0M0?oo_`030?l0003ookl0oono0?l0oonoGP3ookl00?l0oonoC03ookl00`000000oono
0?oo_`1m0?oo_`030?l0003ookl0oono01l0oono00<0o`000?oo_`3ookl0o`3ookmM0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono07`0oono00<0o`000?oo_`3ookl08@3ookl00`3o0000oono0?oo
_`3o0?oo_e`0oono003o0?oo_d`0oono00<000000?oo_`3ookl0N`3ookl00`3o0000oono0?oo_`0S
0?oo_`030?l0003ookl0oono0?l0oonoF`3ookl00?l0oonoC03ookl00`000000oono0?oo_`1j0?oo
_`030?l0003ookl0oono02D0oono00<0o`000?oo_`3ookl0o`3ookmJ0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono07T0oono00<0o`000?oo_`3ookl09`3ookl00`3o0000oono0?oo_`3o0?oo_eT0
oono003o0?oo_d`0oono00<000000?oo_`3ookl0N03ookl00`3o0000oono0?oo_`0Y0?oo_`030?l0
003ookl0oono0?l0oonoF03ookl00?l0oonoC03ookl00`000000oono0?oo_`1g0?oo_`030?l0003o
okl0oono02/0oono00<0o`000?oo_`3ookl0o`3ookmG0?oo_`00o`3ookm<0?oo_`030000003ookl0
oono07H0oono00<0o`000?oo_`3ookl0;@3ookl00`3o0000oono0?oo_`3o0?oo_eH0oono003o0?oo
_d`0oono00<000000?oo_`3ookl0M@3ookl00`3o0000oono0?oo_`0_0?oo_`030?l0003ookl0oono
0?l0oonoE@3ookl00?l0oonoC03ookl00`000000oono0?oo_`1d0?oo_`030?l0003ookl0oono0340
oono00<0o`000?oo_`3ookl0o`3ookmD0?oo_`00o`3ookm<0?oo_`030000003ookl0oono07<0oono
00<0o`000?oo_`3ookl0<`3ookl00`3o0000oono0?oo_`3o0?oo_e<0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0LP3ookl00`3o0000oono0?oo_`0e0?oo_`030?l0003ookl0oono0?l0oonoDP3o
okl00?l0oonoC03ookl00`000000oono0?oo_`1a0?oo_`030?l0003ookl0oono03L0oono00<0o`00
0?oo_`3ookl0o`3ookmA0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0700oono00<0o`000?oo
_`3ookl0>@3ookl00`3o0000oono0?oo_`3o0?oo_e00oono003o0?oo_d`0oono00<000000?oo_`3o
okl0K`3ookl00`3o0000oono0?oo_`0k0?oo_`030?l0003ookl0oono0?l0oonoC`3ookl00?l0oono
C03ookl00`000000oono0?oo_`1^0?oo_`030?l0003ookl0oono03d0oono00<0o`000?oo_`3ookl0
o`3ookm>0?oo_`00o`3ookm<0?oo_`030000003ookl0oono06d0oono00<0o`000?oo_`3ookl0?`3o
okl00`3o0000oono0?oo_`3o0?oo_dd0oono003o0?oo_d`0oono00<000000?oo_`3ookl0K03ookl0
0`3o0000oono0?oo_`110?oo_`030?l0003ookl0oono0?l0oonoC03ookl00?l0oonoC03ookl00`00
0000oono0?oo_`1[0?oo_`030?l0003ookl0oono04<0oono00<0o`000?oo_`3ookl0o`3ookm;0?oo
_`00o`3ookm<0?oo_`030000003ookl0oono06X0oono00<0o`000?oo_`3ookl0A@3ookl00`3o0000
oono0?oo_`3o0?oo_dX0oono003o0?oo_d`0oono00<000000?oo_`3ookl0J@3ookl00`3o0000oono
0?oo_`170?oo_`030?l0003ookl0oono0?l0oonoB@3ookl00?l0oonoC03ookl00`000000oono0?oo
_`1X0?oo_`030?l0003ookl0oono04T0oono00<0o`000?oo_`3ookl0o`3ookm80?oo_`00o`3ookm<
0?oo_`030000003ookl0oono06L0oono00<0o`000?oo_`3ookl0B`3ookl00`3o0000oono0?oo_`3o
0?oo_dL0oono003o0?oo_d`0oono00<000000?oo_`3ookl0IP3ookl00`3o0000oono0?oo_`1=0?oo
_`030?l0003ookl0oono0?l0oonoAP3ookl00?l0oonoC03ookl00`000000oono0?oo_`1U0?oo_`03
0?l0003ookl0oono04l0oono00<0o`000?oo_`3ookl0o`3ookm50?oo_`00o`3ookm<0?oo_`030000
003ookl0oono06@0oono00<0o`000?oo_`3ookl0D@3ookl00`3o0000oono0?oo_`3o0?oo_d@0oono
003o0?oo_d`0oono00<000000?oo_`3ookl0G03ookl00`3o0000oono0?oo_`040?oo_`030?l0003o
okl0oono05<0oono00<0o`000?oo_`3ookl00`3ookl00`3o0000oono0?oo_`3o0?oo_cd0oono003o
0?oo_d`0oono00<000000?oo_`3ookl0F`3ookl30?l000@0oono00<0o`000?oo_`3ookl0E@3ookl0
103o0000oono0?oo_`3ookl30?l00?l0oono?P3ookl00?l0oonoC03ookl00`000000oono0?oo_`1K
0?oo_`@0o`000P3ookl00`3o0000oono0?oo_`1G0?oo_`030?l0003ookl0o`0000<0o`00o`3ookln
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono05X0oono1`3o001K0?oo_`H0o`00o`3ooklm0?oo
_`00o`3ookm<0?oo_`030000003ookl0oono05X0oono1`3o001J0?oo_`L0o`00o`3ooklm0?oo_`00
o`3ookm<0?oo_`030000003ookl0oono05T0oono2@3o001H0?oo_`T0o`00o`3ookll0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono05T0oono2P3o001F0?oo_`/0o`00o`3ooklk0?oo_`00o`3ookm<
0?oo_`030000003ookl0oono05P0oono2P3o001H0?oo_`X0o`00o`3ooklk0?oo_`00o`3ookm<0?oo
_`030000003ookl0oono05P0oono203o001L0?oo_`T0o`00o`3ooklj0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono05L0oono203o001O0?oo_`L0o`00o`3ooklj0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono05L0oono1P3o001R0?oo_`L0o`00o`3ookli0?oo_`00o`3ookm<0?oo_`030000003o
okl0oono05H0oono1P3o001U0?oo_`H0o`00o`3ooklh0?oo_`00o`3ookm<0?oo_`030000003ookl0
oono05H0oono103o001Y0?oo_`@0o`00o`3ooklh0?oo_`00o`3ookm<0?oo_`030000003ookl0oono
05D0oono0`3o001/0?oo_`@0o`00o`3ooklg0?oo_`00o`3ookm<0?oo_`030000003ookl0oono05D0
oono0P3o001_0?oo_`80o`00o`3ooklg0?oo_`00o`3ookm<0?oo_`030000003ookl0oono05@0oono
00<0o`000?oo_`3ookl0L@3ookl00`3o0000oono0?oo_`3o0?oo_c@0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl0
0?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3o
okl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03o
okl00`000000oono0?oo_`3F0?oo_`030?oo[`2jLP00VmBo0?l0oono9P3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`3G0?oo_`030=BK001b^Zl0oono0?l0oono9@3ookl00?l0oonoC03ookl00`00
0000oono0?oo_`170?oo_`050?oDM000000000000000E@2jj[l0R`3ookl00`3Z^UD009]d09/00002
00000003001bS03Zokl0oono0?l0oono803ookl00?l0oonoC03ookl00`000000oono0?oo_`160?oo
_`070?oZS01b0000VmBo0?oo_`3oe7@0000009_D_`2:0?oo_`030?oZS01b0000L[Z_0080oono00<0
e9/0001bS03Zokl0o`3ooklP0?oo_`00o`3ookm<0?oo_`030000003ookl0oono04H0oono00<0j[YE
001bS03Zokl00P3ookl00`3Z^UD0001d0=Co_`290?oo_`030?ooW`2K05D0^^Zo0080oono00<0oonO
09/0002Ke;l0o`3ooklP0?oo_`00o`3ookm<0?oo_`030000003ookl0oono03h0oono00<0oonO09/0
00000000100000000`2Ke;l0j[YE002KW`030?oo_`030?ooW`2K0000VmBo0800oono00<0oonO09/0
00000000100000001@2Ke;l0oono0?oo_`3DV`00L[Z_0080oono00<0oon_0;Yb001b^Zl0o`3ooklP
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono03d0oono00<0j[YE0000000000001@0000000`00
05D0^/=d000000050000000307:j[`3ookl0oono07d0oono00<0j[YE0000000000001@0000002P00
05D0^^Zo0?oo_`3oe7@0001d0=Co_`3ookl0onZ<0780002Ke;oo0?oo_b00oono003o0?oo_d`0oono
00<000000?oo_`3ookl0?03ookl0103ojX`0LP000000M03Dokl60?oo_`030?ooW`2K05D0^^Zo00<0
oono00<0e9/007:j[`3ookl0O@3ookl0103ojX`0LP000000M03Dokl90?oo_`050?oDM00000000000
0000002Ke;l0o`3ooklQ0?oo_`00o`3ookm<0?oo_`030000003ookl0oono03`0oono00<0omAd0000
000000001P0000002@0005D0^^Zo0?oDM00005D0^^Zo0?oo_`3ojX`0LP1E0;[Z_`1n0?oo_`030?oD
M0000000000000H0000000<0001E0;[Z_`3ookl0o`3ooklW0?oo_`00o`3ookm<0?oo_`030000003o
okl0oono03`0oono00<0omAd0000000000001P0000001@0007@0e?no0?oo_`3ojX`0LP0000800000
00<0VmBo0?oo_`3ookl0O@3ookl00`3oe7@0000000000006000000030000M03Dokl0oono0?l0oono
9`3ookl00?l0oonoC03ookl00`000000oono0?oo_`0l0?oo_`040?oZS01b0000001E0;[Z_`<0oono
00<0omAd00000000Vil0QP3ookl0103ojX`0LP000000E@2jj[l30?oo_`030?oDM000000009^O0?l0
oono:@3ookl00?l0oonoC03ookl00`000000oono0?oo_`0m0?oo_`030?oDM0000000000000@00000
00<0001d0=Co_`3ookl0QP3ookl00`3oe7@0000000000004000000030000M03Dokl0oono0?l0oono
:03ookl00?l0oonoC03ookl00`000000oono0?oo_`0n0?oo_`030?ooW`2K000000000080000000<0
09^O0?oo_`3ookl0R03ookl00`3ooil0V`000000000200000003002KW`3ookl0oono0?l0oono:@3o
okl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo
_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oono
C03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3o
okoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`00
0000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00
o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo
_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo
_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0
oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003o
okl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo
_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0
oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<0
00000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl0
0?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3o
okl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03o
okl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000
oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3o
okm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o
0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`03
0000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono
003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0
oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0
oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oono
o`3ookl00?l0oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<00000
0?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0
oonoC03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0
o`3ookoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl0
0`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo
_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono
0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00o`3ookm<
0?oo_`030000003ookl0oono00L0oono00<0oon_0;Yb00000000100000000`00LX`0j_no0?oo_`3o
0?oo_nh0oono003o0?oo_d`0oono00<000000?oo_`3ookl01`3ookl00`3oojl0^W80000000040000
0003001bS03Zokl0oono0?l0oonokP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0:0?oo_`03
0?oDM0000000L[Z_0?l0oonolP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0:0?oo_`030?oD
M0000000L[Z_0?l0oonolP3ookl00?l0oonoC03ookl00`000000oono0?oo_`0:0?oo_`030?oDM000
0000L[Z_0?l0oonolP3ookl00?l0oonoC03ookl00`000000oono0?oo_`090?oo_`050?ooW`2K0000
00000000M03Dokl0o`3ookoa0?oo_`00o`3ookm<0?oo_`030000003ookl0oono00T0oono00H0e9/0
0000000000000000001bS03Zokoo0?oo_o00oono003o0?oo_d`0oono00<000000?oo_`3ookl0203o
okl01`3Z^UD00000001bS03Zokl0e9/00000001b^Zl0o`3ooko`0?oo_`00o`3ookm<0?oo_`030000
003ookl0oono00L0oono00T0onZ<0780000007@0e?no0?oo_`3ooil0V`000000E@2jj[l0o`3ooko_
0?oo_`00o`3ookm<0?oo_`030000003ookl0oono00H0oono00P0e9/0000000000000000007:j[`3o
okl0onZ<07800080000000<009^O0?oo_`3ookl0o`3ooko/0?oo_`00o`3ookm<0?oo_`030000003o
okl0oono00H0oono00P0e9/0000000000000000007:j[`3ookl0onZ<07800080000000<009^O0?oo
_`3ookl0o`3ooko/0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oono
C03ookl00`000000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3o
okoo0?oo_`00o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`00
0000oono0?oo_`3o0?oo_ol0oono003o0?oo_d`0oono00<000000?oo_`3ookl0o`3ookoo0?oo_`00
o`3ookm<0?oo_`030000003ookl0oono0?l0oonoo`3ookl00?l0oonoC03ookl00`000000oono0?oo
_`3o0?oo_ol0oono003o0?oo_ol0oonoo`3ookm?0?oo_`00o`3ookoo0?oo_ol0oonoC`3ookl00?l0
oonoo`3ookoo0?oo_dl0oono003o0?oo_ol0oonoo`3ookm?0?oo_`00o`3ookoo0?oo_ol0oonoC`3o
okl00?l0oonoo`3ookoo0?oo_dl0oono003o0?oo_ol0oonoo`3ookm?0?oo_`00o`3ookoo0?oo_ol0
oonoC`3ookl00001\
\>"],
  ImageRangeCache->{{{0, 843.5}, {350, 0}} -> {-2.28509, -0.357514, \
0.0103501, 0.0103501}}]
}, Open  ]],

Cell[TextData[{
  "En vez de elegir el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(-\[Pi]\), \[Pi]\)\)\)]],
  "] para medir en radianes el ",
  StyleBox["\[AAcute]ngulo polar",
    FontWeight->"Bold"],
  " \[Theta], podemos elegir cualquier otro intervalo semiabierto de longitud \
2\[Pi], por ejemplo [",
  Cell[BoxData[
      \(TraditionalForm\`0, 2  \[Pi]\)]],
  "[. La elecci\[OAcute]n m\[AAcute]s conveniente desde un punto de vista \
matem\[AAcute]tico, por razones de c\[AAcute]lculo (definici\[OAcute]n del \
arcotangente) y de simetr\[IAcute]a,  es ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), \[Pi]\)]],
  "]. Observa que lo que hacemos es medir \[AAcute]ngulos en sentido \
antihorario desde la parte negativa del eje de abscisas. Los valores de \
\[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\), 0\)]],
  "[ corresponden a puntos situados en el semiplano inferior (",
  Cell[BoxData[
      \(TraditionalForm\`y < 0\)]],
  ") y valores de \[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`0, \[Pi]\)]],
  "[ corresponden a puntos situados en el semiplano superior (",
  Cell[BoxData[
      \(TraditionalForm\`y > 0\)]],
  "). Los valores de \[Theta] en el intervalo ]",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\)/2, \[Pi]/2\)]],
  "[ corresponden a puntos situados en el semiplano de la derecha (",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  ") y valores de \[Theta] en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(\(\(]\) \(\[Pi]/
                  2\)\), \[Pi]\)\(]\)\)\(\[Union]\)\)\(]\)\) - \[Pi], \
\(-\[Pi]\)/\(\(2\)\([\)\)\)]],
  " corresponden a puntos situados en el semiplano de la izquierda (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  "). "
}], "Text"],

Cell["\<\
Los siguientes comandos pasan de coordenadas polares a cartesianas y de \
cartesianas a polares.\
\>", "Text"],

Cell[BoxData[{
    \(\(polar2cart[{\[Rho]_, \[Theta]_}] = \(g[\[Rho]_, \[Theta]_] := {\[Rho]\
\ Cos[\[Theta]], \ \[Rho]\ Sin[\[Theta]]}\);\)\), "\n", 
    \(cart2polar[{x_, y_}] := {\@\(x\^2 + y\^2\), ArcTan[x, y]}\)}], "Input"],

Cell[TextData[{
  "El comando ArcTan[x,y] proporciona el valor de \[Theta] teniendo en cuenta \
el cuadrante donde est\[AAcute] situado el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x, y)\)\ \)\)]],
  "para lo cual suma o resta \[Pi] al valor de ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[y\/x]\)]],
  ". Para ",
  Cell[BoxData[
      \(TraditionalForm\`x > 0\)]],
  " se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[x, y] = ArcTan[y\/x]\)]],
  " pero esa igualdad no es cierta cuando ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  ". En muchos textos se afirma que el \[AAcute]ngulo polar, \[Theta], viene \
dado por la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = ArcTan[y\/x]\)]],
  ", debes tener claro que eso es falso cuando ",
  Cell[BoxData[
      \(TraditionalForm\`x < 0\)]],
  ". Recuerda que la funci\[OAcute]n arcotangente toma valores en el \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \(-\[Pi]\)/2\), \[Pi]/\(2[\)\)]],
  ". Para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en el segundo cuadrante (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, y > 0\)]],
  ") el \[AAcute]ngulo polar est\[AAcute] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \[Pi]/2\), \(\[Pi][\ \)\)]],
  "y es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi] + ArcTan[y\/x]\)]],
  ", y para ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " en el tercer cuadrante (",
  Cell[BoxData[
      \(TraditionalForm\`x < 0, y < 0\)]],
  ") el \[AAcute]ngulo polar est\[AAcute] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(] \(-\[Pi]\)\), \(-\[Pi]\)/\(2[\ \)\)]],
  "y es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`ArcTan[y\/x] - \[Pi]\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Cuando se utiliza el sistema de coordenadas polares los vectores se \
refieren a una base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " que se ha representado en la figura anterior. En el lenguaje \
t\[IAcute]pico de los textos de f\[IAcute]sica se dice que el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Rho]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Rho] manteniendo \[Theta] constante y el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Theta] manteniendo \[Rho] constante. En t\[EAcute]rminos \
matem\[AAcute]ticos, quiz\[AAcute]s m\[AAcute]s precisos, observa que el \
vector de posici\[OAcute]n del punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " es  ",
  Cell[BoxData[
      \(TraditionalForm
      \`g(\[Rho], \[Theta]) = 
        \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " su variaci\[OAcute]n con respecto a \[Rho] manteniendo \[Theta] constante \
es la derivada parcial respecto a \[Rho] y su variaci\[OAcute]n con respecto \
a \[Theta] manteniendo \[Rho] constante es la derivada parcial respecto a \
\[Theta]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(D[g[\[Rho], \[Theta]], \[Rho]]\), "\n", 
    \(D[g[\[Rho], \[Theta]], \[Theta]]\)}], "Input"],

Cell[BoxData[
    \({Cos[\[Theta]], Sin[\[Theta]]}\)], "Output"],

Cell[BoxData[
    \({\(-\[Rho]\)\ Sin[\[Theta]], \[Rho]\ Cos[\[Theta]]}\)], "Output"]
}, Open  ]],

Cell["Observa que estos vectores son ortogonales", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[g[\[Rho], \[Theta]], \[Rho]] . D[g[\[Rho], \[Theta]], \[Theta]] // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Para obtener una base ortonormal a partir de ellos todo lo que tenemos que \
hacer es normalizarlos. El primero tiene norma igual a 1 y el segundo tiene \
norma igual a \[Rho]. Por tanto, los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Theta], \ sen\ \[Theta])\)}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "=", 
            \((\(-sen\)\ \[Theta], \ cos\ \[Theta])\)}]}], 
        TraditionalForm]]],
  " forman una base ortonormal. Es a dicha base a la que se refiere un vector \
cuando se usan coordenadas polares. Observa que los vectores de esta base \
dependen de la posici\[OAcute]n del punto, es decir, no se trata de una base \
fija. F\[IAcute]jate en que si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((\[Rho], \[Theta])\)\ \)\)]],
  "son las coordenadas polares de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((x, y)\), "=", 
          RowBox[{"\[Rho]", " ", 
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". En general, la expresi\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " de un vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", \((x, y)\)}], TraditionalForm]]],
  " se obtiene por el m\[EAcute]todo usual calculando sus proyecciones \
ortogonales sobre los vectores de la base:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(v = \[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket] 
                e\_\[Rho] + 
              \[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket] 
                e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\t\t(1)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que si escribimos ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", 
          \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)}], 
        TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[LeftAngleBracket]v | e\_\[Rho]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "\[Rho]"}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          StyleBox[
            \(\[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "0"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "Recuerda que la matriz jacobiana de una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(f(x, y) = \((\(f\_1\)(x, y), \(f\_2\)(x, y))\)\ 
      \)\)]],
  "es la matriz cuyas filas son los vectores gradiente de las funciones \
componentes de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " . El siguiente comando calcula la matriz jacobiana de un campo vectorial \
de dos variables."
}], "Text"],

Cell[BoxData[
    \(\(matrizjacobiana2[func_]\)[x_, y_] := 
      Module[{u, v}, 
        Outer[D, func[u, v], {u, v}] /. {u -> x, v -> y}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(matrizjacobiana2[g]\)[\[Rho], \[Theta]] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(Cos[\[Theta]]\), \(\(-\[Rho]\)\ Sin[\[Theta]]\)},
            {\(Sin[\[Theta]]\), \(\[Rho]\ Cos[\[Theta]]\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Las columnas de la matriz jacobiana son las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(D[g[\[Rho], \[Theta]], \[Theta]]\ \)\)]],
  " y",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \ D[g[\[Rho], \[Theta]], \[Theta]]\)\)]],
  ". Las normas eucl\[IAcute]deas de las columnas de la matriz jacobiana se \
llaman ",
  StyleBox["factores m\[EAcute]tricos ",
    FontWeight->"Bold"],
  "o ",
  StyleBox["factores de escala",
    FontWeight->"Bold"],
  " del cambio a cordenadas polares y son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Rho]}\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Expresi\[OAcute]n de la velocidad y la aceleraci\[OAcute]n en cordenadas \
polares\
\>", "Subsection"],

Cell[TextData[{
  "Consideremos un m\[OAcute]vil cuya trayectoria en el plano viene dada por \
la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sean ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho](t), \ \[Theta](t))\)\)]],
  " las coordenadas polares de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de forma que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
          \((\(\[Rho](t)\) cos\ \(\[Theta](t)\), 
              \(\[Rho](t)\) sen\ \(\[Theta](t)\))\), "=", 
            RowBox[{\(\[Rho](t)\), 
              RowBox[{
                StyleBox[\(e\_\[Rho]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((cos\ \(\[Theta](t)\), sen\ \(\[Theta](t)\))\)}], 
        TraditionalForm]]],
  ". Observa que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Rho]\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}], 
              \((\(-sen\)\ \(\[Theta](t)\), cos\ \(\[Theta](t)\))\)}], "=", 
            RowBox[{
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}], 
              RowBox[{
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  ". Tenemos que "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                RowBox[{\(\[Rho](t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\%\(\ \[VerticalLine]\)\),
                      FontWeight->"Bold"], "(", "t", ")"}]}]}], "=", 
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}]}]}],
          "TraditionalForm"], 
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la expresi\[OAcute]n de la velocidad en coordenadas polares. \
Derivando la expresi\[OAcute]n anterior y teniendo en cuenta que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_\[Theta]\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SuperscriptBox["\[Theta]", 
                  RowBox[{" ", 
                    StyleBox["\[VerticalLine]",
                      FontWeight->"Bold"]}]], "(", "t", ")"}]}], 
            RowBox[{
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  " puedes comprobar que la aceleraci\[OAcute]n viene dada por:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        FormBox[
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
              \((\(\[Rho]'\)' \((t)\) - 
                    \(\[Rho](t)\) \((\[Theta]\ ' \((t)\))\)\^2)\), 
                RowBox[{
                  StyleBox[\(e\_\[Rho]\),
                    FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
              \((2  \[Rho]' \((t)\) \[Theta]\ '\ \((t)\) + 
                  \(\[Rho](t)\) \(\[Theta]\ '\)\ ' \((t)\))\)}]}],
          "TraditionalForm"], 
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". En algunos libros de f\[IAcute]sica se usa la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Rho]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Rho]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " (o  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Rho]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(r\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ") y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Theta]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y se les da a estos vectores el extra\[NTilde]o nombre de ",
  StyleBox["versores. ",
    FontSlant->"Italic"],
  "Todav\[IAcute]a nadie me ha sabido explicar qu\[EAcute] es un versor.  "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expresi\[OAcute]n de la divergencia en cordenadas polares", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            \((\(f\_1\)(x, y), \(f\_2\)(x, y))\)}], " "}], 
        TraditionalForm]]],
  " un campo vectorial de dos variables. La divergencia de este campo es el \
campo escalar dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"div", 
          FormBox[
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
              \(\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y)\) + 
                \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y)\)\)}],
            "TraditionalForm"]}], TraditionalForm]]],
  ". Consideremos la expresi\[OAcute]n de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en coordenadas polares:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], "=", 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontWeight->"Bold"], "(", \(\[Rho]\ cos\ \[Theta], 
            \[Rho]\ sen\ \[Theta]\), ")"}], "=", 
          \((\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta]), 
            \(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta]))\)}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y calculemos las componentes ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Rho]\)(\[Rho], \[Theta])\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F\_\[Theta]\)(\[Rho], \[Theta])\ \)\)]],
  " de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], 
        TraditionalForm]]],
  " respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ", esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(\[Rho], \[Theta]\), ")"}], "=", 
          RowBox[{
            RowBox[{\(\(F\_\[Rho]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sabemos que dichas componentes viene dadas por las correspondientes \
proyecciones ortogonales:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      
                      FormBox[\(\(F\_\(\(\[Rho]\)\(\ \)\)\)(\[Rho], \[Theta]) \
= \[LeftAngleBracket]\),
                        "TraditionalForm"], 
                      RowBox[{
                        StyleBox["F",
                          FontWeight->"Bold"], 
                        "(", \(\[Rho], \ \ \ \[Theta]\), ")"}]}], "|", 
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], "="}],
              "TraditionalForm"], 
            
            FormBox[\(\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\),
              "TraditionalForm"], "cos", " ", "\[Theta]"}], 
          "+", \(\(\(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\) 
            sen\ \[Theta]\)}], TraditionalForm]]],
  "\n   ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    
                    FormBox[\(\(F\_\(\(\[Theta]\)\(\ \)\)\)(\[Rho], \[Theta]) \
= \[LeftAngleBracket]\),
                      "TraditionalForm"], 
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold"], "(", \(\[Rho], \ \ \ \[Theta]\), 
                      ")"}]}], "|", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"]}], "\[RightAngleBracket]"}], "="}],
            "TraditionalForm"], "-", 
          RowBox[{
            
            FormBox[\(\(f\_1\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\),
              "TraditionalForm"], "sen", " ", "\[Theta]"}], 
          "+", \(\(\(f\_2\)(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\) 
            cos\ \[Theta]\)}], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para obtener la expresi\[OAcute]n de la divergencia de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " en coordenadas polares debemos expresar la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[
              RowBox[{"div", 
                StyleBox["f",
                  FontWeight->"Bold",
                  
                  FontSlant->
                    "Italic"]}]], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "=", 
          RowBox[{
            RowBox[{
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                
                "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "+", 
            RowBox[{
              FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
                
                "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}]}]}], TextForm]]],
  " en t\[EAcute]rminos de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Rho], \ F\_\[Theta]\)]],
  " y de sus derivadas parciales. Hay dos formas de hacer esto. "
}], "Text"],

Cell["De forma indirecta", "Text",
  FontWeight->"Bold"],

Cell["\<\
Derivamos en las igualdades anteriores haciendo uso de la regla de la cadena \
(derivaci\[OAcute]n de una funci\[OAcute]n compuesta). Tenemos que:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], 
                "\[Rho]"]}], \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}],
         "=", 
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \(cos\^2\), " ", "\[Theta]"}], " ", "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "cos", " ", "\[Theta]", " ", "sen", " ", "\[Theta]"}], "+", 
          "\[IndentingNewLine]", "                        ", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "cos", " ", "\[Theta]", " ", "sen", " ", "\[Theta]"}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \(sen\^2\), " ", "\[Theta]"}]}]}], TextForm]], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], 
                "\[Theta]"]}], \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\
\)}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                
                "TraditionalForm"]}], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \((\(-\[Rho]\)\ sen\ \[Theta])\), "sen", " ", "\[Theta]"}], " ", 
          "-", 
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "\[Rho]", " ", "cos", " ", "\[Theta]", " ", "sen", " ", 
            "\[Theta]"}], "-", 
          RowBox[{
            SubscriptBox[
              StyleBox["f",
                FontSlant->"Italic"], 
              "1"], \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), 
            "cos", " ", "\[Theta]"}], "+", "\[IndentingNewLine]", 
          "                             ", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), \((\(-\[Rho]\)\ sen\ \[Theta])\), " ", "cos", " ", "\[Theta]"}], 
          "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\), "\[Rho]", " ", \(cos\^2\), " ", "\[Theta]"}], "-", 
          RowBox[{
            SubscriptBox[
              StyleBox["f",
                FontSlant->"Italic"], 
              "2"], \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), 
            "sen", " ", "\[Theta]"}]}]}], TextForm]], "Text"],

Cell[TextData[
"Sumando estas igualdades, despu\[EAcute]s de dividir por \[Rho] la segunda \
de ellas, se deduce que"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Rho]"]}], 
              \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}], "+", 
          RowBox[{\(1\/\[Rho]\), 
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Theta]"]}], 
              \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\)}]}], "=", 
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              "TraditionalForm"], 
            \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              "TraditionalForm"], 
            \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "-", 
          RowBox[{\(1\/\[Rho]\), 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"], 
            \((\[Rho], \[Theta])\)}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[" es decir", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{"div", 
              StyleBox["f",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]], 
          \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
                "TraditionalForm"], 
              \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}], "+", 
            RowBox[{
              FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
                "TraditionalForm"], 
              \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)}]}], "=", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Rho]"]}], 
                \(\[PartialD]\[Rho]\)], \((\[Rho], \[Theta])\)}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Theta]"]}], 
                \(\[PartialD]\[Theta]\)], \((\[Rho], \[Theta])\)}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "\[Rho]"], 
              \((\[Rho], \[Theta])\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["igualdad que suele escribirse en la forma", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"div", " ", 
          StyleBox["f",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "\[Rho]"]}], \(\[PartialD]\[Rho]\)], 
          "+", 
          RowBox[{\(1\/\[Rho]\), 
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "\[Theta]"]}], 
              \(\[PartialD]\[Theta]\)]}], "+", 
          RowBox[{\(1\/\[Rho]\), 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["e incluso m\[AAcute]s condesado, en la forma", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{"div", " ", 
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{\(1\/\[Rho]\), \(\[PartialD]\/\[PartialD]\[Rho]\), 
              RowBox[{"(", 
                RowBox[{"\[Rho]", " ", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "\[Rho]"]}], ")"}]}], "+", 
            RowBox[{\(1\/\[Rho]\), 
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], 
                    "\[Theta]"]}], \(\[PartialD]\[Theta]\)]}]}]}]], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y se dice que dicha expresi\[OAcute]n proporciona la divergencia de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en polares. "
}], "Text"],

Cell["De forma directa", "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "El camino que hemos seguido antes para obtener la expresi\[OAcute]n de la \
divergencia en coordenadas polares es un ",
  StyleBox["camino indirecto",
    FontSlant->"Italic"],
  ", pues hemos calculado las derivadas ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Rho]"]}], \(\[PartialD]\[Rho]\)], 
        TextForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        FractionBox[
          RowBox[{"\[PartialD]", 
            SubscriptBox[
              StyleBox["F",
                FontSlant->"Italic"], "\[Theta]"]}], \(\[PartialD]\[Theta]\)],
         TextForm]]],
  " y, al hacerlo, ",
  StyleBox["nos hemos dado cuenta",
    FontSlant->"Italic"],
  " de que pod\[IAcute]amos hacer una operaci\[OAcute]n sencilla con ellas \
para relacionarlas con ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\[PartialD]f\_1\/\[PartialD]x\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}], "+", 
          RowBox[{
            FormBox[\(\[PartialD]f\_2\/\[PartialD]y\),
              
              "TraditionalForm"], \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)}]}], TextForm]]],
  ". Un camino m\[AAcute]s natural consiste en expresar ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x, y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_2\)(x, y)\)]],
  " en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Rho]\)(\[Rho], \[Theta])\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\)(\[Rho], \[Theta])\)]],
  "; es decir, se trata de obtener las coordenadas cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(f\_1\)(x, y), \(f\_2\)(x, y))\)\)]],
  " del vector",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["f",
              FontWeight->"Bold"], "(", \(x, y\), ")"}]}], 
        TraditionalForm]]],
  " en funci\[OAcute]n de las coordenadas de dicho vector respecto de la base \
",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". Basta para ello tener en cuenta que: "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\((\(f\_1\)(x, y), \(f\_2\)(x, y))\), "=", 
        RowBox[{
          RowBox[{
            RowBox[{\(\(F\_\[Rho]\)(\[Rho], \[Theta])\), 
              SubscriptBox[
                StyleBox["e",
                  FontWeight->"Bold"], 
                StyleBox["\[Rho]",
                  FontWeight->"Bold"]]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta])\), 
              SubscriptBox[
                StyleBox["e",
                  FontWeight->"Bold"], 
                StyleBox["\[Theta]",
                  FontWeight->"Bold"]]}]}], "=", 
          RowBox[{
            RowBox[{"(", GridBox[{
                  {\(cos\ \[Theta]\), \(\(-sen\)\ \[Theta]\)},
                  {\(sen\ \[Theta]\), \(cos\ \[Theta]\)}
                  }], ")"}], 
            RowBox[{"(", GridBox[{
                  {\(\(F\_\[Rho]\)(\[Rho], \[Theta])\)},
                  {\(\(F\_\[Theta]\)(\[Rho], \[Theta])\)}
                  }], ")"}], " "}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir, la matriz cuyas columnas son los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\(\(\[Rho]\)\(\ \)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "y ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es justamente la matiz del cambio de base que necesitamos. Naturalmente, \
en esta igualdad debemos ver a \[Rho] y a \[Theta] como funciones de ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho](x, y) = \@\(x\^2 + y\^2\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta](x, y) = ArcTan\ [x, y]\)]],
  ". Vamos a pedirle ayuda a ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "para hacer los c\[AAcute]lculos. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\[Rho][x_, y_] := \@\(x\^2 + y\^2\);\)\), "\n", 
    \(\(\[Theta][x_, y_] := ArcTan[x, y];\)\), "\n", 
    \(\(A = 
        Transpose[{{Cos[\[Theta][x, y]], 
              Sin[\[Theta][x, y]]}, {\(-Sin[\[Theta][x, y]]\), 
              Cos[\[Theta][x, y]]}}];\)\), "\n", 
    \(f1[x_, 
        y_] = \((A . {F\[Rho][\[Rho][x, y], \[Theta][x, y]], 
              F\[Theta][\[Rho][x, y], \[Theta][x, y]]})\)[\([1]\)]\), "\n", 
    \(f2[x_, 
        y_] = \((A . {F\[Rho][\[Rho][x, y], \[Theta][x, y]], 
              F\[Theta][\[Rho][x, y], \[Theta][x, 
                  y]]})\)[\([2]\)]\)}], "Input"],

Cell[BoxData[
    \(Cos[ArcTan[x, y]]\ F\[Rho][\@\(x\^2 + y\^2\), ArcTan[x, y]] - 
      F\[Theta][\@\(x\^2 + y\^2\), ArcTan[x, y]]\ Sin[
          ArcTan[x, y]]\)], "Output"],

Cell[BoxData[
    \(Cos[ArcTan[x, y]]\ F\[Theta][\@\(x\^2 + y\^2\), ArcTan[x, y]] + 
      F\[Rho][\@\(x\^2 + y\^2\), ArcTan[x, y]]\ Sin[ArcTan[x, y]]\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Una vez que disponemos de ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_1\)(x, y)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(f\_2\)(x, y)\)]],
  " en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(F\_\[Rho]\)(\@\(x\^2 + y\^2\), \ ArcTan[x, y])\)]],
  " y de ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(F\_\[Theta]\)(\@\(x\^2 + y\^2\), \ ArcTan[x, y])\)]],
  ", todo lo que tenemos que hacer es calcular las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y)\), 
      \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y)\)\)]],
  " sumarlas, simplificar y sustituir ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)\)]],
  ". Esto lo hace ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " siempre que le demos una ayudita para que simplifique bien las \
ra\[IAcute]ces cuadradas (por ejemplo para que ",
  Cell[BoxData[
      \(TraditionalForm\`\@\[Rho]\^2\)]],
  "lo simplifique igual a \[Rho]) y para que sustituya ArcTan[\[Rho] Cos[\
\[Theta]], \[Rho] Sin[\[Theta]]] por \[Theta]. Esta ayudita la hemos incluido \
en las celdas de inicializaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((\((D[f1[x, y], x] + D[f2[x, y], y] // 
              Simplify)\) /. {x -> \[Rho]\ Cos[\[Theta]], 
            y -> \[Rho]\ Sin[\[Theta]]})\) // Simplify\)], "Input"],

Cell[BoxData[
    FractionBox[
      RowBox[{\(F\[Rho][\[Rho], \[Theta]]\), "+", 
        RowBox[{
          SuperscriptBox["F\[Theta]", 
            TagBox[\((0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(\[Rho], \[Theta]\), "]"}], "+", 
        RowBox[{"\[Rho]", " ", 
          RowBox[{
            SuperscriptBox["F\[Rho]", 
              TagBox[\((1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(\[Rho], \[Theta]\), "]"}]}]}], 
      "\[Rho]"]], "Output"]
}, Open  ]],

Cell["Que como puedes ver es la misma expresi\[OAcute]n obtenida antes.", 
  "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gradiente y elemento diferencial de longitud en coordenadas polares\
\>", "Subsection"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  " un campo escalar de dos variables. Sabemos que el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es el campo vectorial dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y)\)\), "=", 
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".  Hagamos en esta igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 
          y)\) = \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\)]],
  " para obtener"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\
\), "=", 
          RowBox[{
            
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((\[Rho]\ cos\ \[Theta], \
\ \[Rho]\ sen\ \[Theta])\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((\[Rho]\ cos\ \[Theta], \
\ \[Rho]\ sen\ \[Theta])\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La expresi\[OAcute]n del gradiente de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en polares viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\
\), "=", 
          RowBox[{
            RowBox[{\(\(f\_\[Rho]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Rho]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(f\_\[Theta]\)(\[Rho], \[Theta])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Rho]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Theta]\)]],
  " son las componentes del vector ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \
\[Theta])\)\)]],
  " en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_\[Rho]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". Dichas componentes sabemos que vienen dadas por"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            
            FormBox[\(\(f\_\[Rho]\)(\[Rho], \[Theta]) = \[LeftAngleBracket]\),
              
              
              "TraditionalForm"], \(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\
\ sen\ \[Theta])\)\), " ", 
            FormBox[
              RowBox[{"|", 
                StyleBox[\(e\_\[Rho]\),
                  FontWeight->"Bold"]}],
              "TraditionalForm"]}], "\[RightAngleBracket]"}], 
        "=", \(\(\[PartialD]f\/\[PartialD]x\) \((\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\ cos\ \[Theta] + \(\[PartialD]f\/\[PartialD]y\) \((\
\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ sen\ \[Theta]\)}], 
      TraditionalForm], "\n", 
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\(f\_\[Theta]\)(\[Rho], \[Theta]) = \
\[LeftAngleBracket]\),
                
                "TraditionalForm"], \(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\), " ", 
              FormBox[
                RowBox[{"|", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"]}],
                "TraditionalForm"]}], "\[RightAngleBracket]"}], 
          "=", \(\(-\(\[PartialD]f\/\[PartialD]x\)\) \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\ sen\ \[Theta] + \(\[PartialD]f\/\
\[PartialD]y\) \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ cos\ \
\[Theta]\)}],
        "TraditionalForm"], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell["que podemos escribir como sigue", "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\(\(f\_\[Rho]\)(\[Rho], \[Theta])\)\(=\)\),
              
              "TraditionalForm"], \(\[PartialD]f\/\[PartialD]x\), \((\[Rho]\ \
cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\), \(\[PartialD]\((\[Rho]\ \ cos\ \
\[Theta])\)\/\[PartialD]\[Rho]\)}], 
          "+", \(\(\[PartialD]f\/\[PartialD]y\) \((\[Rho]\ cos\ \[Theta], \ \
\[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ sen\ \[Theta])\)\/\
\[PartialD]\[Rho]\)}], 
        "=", \(\(\[PartialD]\/\[PartialD]\[Rho]\) 
          f \((\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)\)}], 
      TraditionalForm], "\n", 
    FormBox[
      RowBox[{\(\(f\_\[Theta]\) \((\[Rho], \[Theta])\)\), "=", 
        RowBox[{\(1\/\[Rho]\), 
          
          FormBox[\(\((\( \(\[PartialD]f\/\[PartialD]x\)\) \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ cos\ \
\[Theta])\)\/\[PartialD]\[Theta] + \(\[PartialD]f\/\[PartialD]y\) \((\[Rho]\ \
cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\ \[PartialD]\((\[Rho]\ \ sen\ \
\[Theta])\)\/\[PartialD]\[Theta])\) = \(1\/\[Rho]\) \
\(\[PartialD]\/\[PartialD]\[Theta]\) \(f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \
\[Theta])\)\),
            "TraditionalForm"]}]}], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell["Hemos obtenido as\[IAcute] que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\),
         "=", 
        RowBox[{
          
          RowBox[{\(\[PartialD]\/\[PartialD]\[Rho]\), \(f(\[Rho]\ cos\ \
\[Theta], \[Rho]\ sen\ \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Rho]"]}], "+", 
          
          RowBox[{\(1\/\[Rho]\), \(\[PartialD]\/\[PartialD]\[Theta]\), \(f(\
\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Theta]"], 
            "                          ", \((1)\), "      "}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es conveniente introducir la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`h(\[Rho], \[Theta]) = 
        f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)]],
  " con lo que la igualdad (1) se escribe mejor en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Del]\(f(\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\)\),
         "=", 
        RowBox[{
          
          RowBox[{\(\[PartialD]h\/\[PartialD]\[Rho]\), \((\[Rho]\ , \ \
\[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Rho]"]}], "+", 
          
          RowBox[{\(1\/\[Rho]\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((\
\[Rho], \[Theta])\), 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Theta]"], 
            "                                   ", \((2)\), "        "}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que en esta igualdad a la izquierda tenemos el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " calculado en la expresi\[OAcute]n de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en coordenadas cartesianas y evaluado en el punto (\[Rho]",
  " cos \[Theta], \[Rho] sen \[Theta]), y a la derecha lo que tenemos son las \
derivadas parciales de la funci\[OAcute]n compuesta ",
  Cell[BoxData[
      \(TraditionalForm\`h(\[Rho], \[Theta]) = 
        f(\[Rho]\ cos\ \[Theta], \[Rho]\ sen\ \[Theta])\)]],
  " evaluadas en el punto (\[Rho],\[Theta]). En los textos de f\[IAcute]sica \
es frecuente que no se distinga entre la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  " (pues, en definitiva, son la ",
  StyleBox["misma funci\[OAcute]n ",
    FontSlant->"Italic"],
  "expresada en ",
  StyleBox["distintas",
    FontSlant->"Italic"],
  " coordenadas) y que escriban la igualdad (1) en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        FrameBox[
          RowBox[{\(\[Del]f\), "=", 
            RowBox[{
              RowBox[{\(\[PartialD]f\/\[PartialD]\[Rho]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "\[Rho]"]}], "+", 
              RowBox[{\(1\/\[Rho]\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], \(\(\[Theta]\)\(\ \)\)], 
                "        "}]}]}]], 
        "                                     ", \((3)\), "      "}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
igualdad que constituye la \"expresi\[OAcute]n del gradiente en polares\". \
\>", "Text"],

Cell[TextData[{
  "Observa que en la expresi\[OAcute]n anterior del gradiente aparecen los \
inversos de los factores de escala multiplicando a las derivadas parciales a \
las que est\[AAcute] asociado cada uno de ellos. Como sabes, los factores de \
escala son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Rho]}\)]],
  "; el primero de ellos, 1, est\[AAcute] asociado a la primera columna de la \
matriz jacobiana del cambio de coordenadas que corresponde a la derivaci\
\[OAcute]n parcial respecto a la primera variable, \[Rho]; el segundo de \
ellos, \[Rho], est\[AAcute] asociado a la segunda columna de la matriz \
jacobiana del cambio de coordenadas que corresponde a la derivaci\[OAcute]n \
parcial respecto a la segunda variable, \[Theta]. "
}], "Text"],

Cell["\<\
Hemos visto antes que la velocidad en coordenadas polares se expresa por\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{\(\[Rho]'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], 
                "+", \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]],
  "\t\t(4)"
}], "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad suele escribirse con notaci\[OAcute]n m\[AAcute]s \
cl\[AAcute]sica en la forma\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[DifferentialD]", 
            FormBox[
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "=", 
                RowBox[{
                  RowBox[{\(\[DifferentialD]\[Rho]\), " ", 
                    StyleBox[\(e\_\[Rho]\),
                      FontWeight->"Bold"]}], "+", "\[Rho]"}]}],
              "TraditionalForm"]}], \(\[DifferentialD]\[Theta]\), " ", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  "\t\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Imaginemos ahora que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["es",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["la",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["funci\[OAcute]n",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["de",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["trayectoria",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["de",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["un",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox["m\[OAcute]vil",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          StyleBox[Cell["y"],
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Plain"], Cell[TextData[Cell[BoxData[
              FormBox[Cell[TextData[Cell[BoxData[
                    FormBox[
                      RowBox[{
                        StyleBox["r",
                          FontWeight->"Bold"], "(", "a", ")"}], 
                      TraditionalForm]]]]], TraditionalForm]]]]]}], 
        TraditionalForm]]],
  "es su punto inicial; entonces la distancia, ",
  Cell[BoxData[
      \(TraditionalForm\`s(t)\)]],
  ", recorrida por el m\[OAcute]vil en cada momento ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " viene dada por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(s \((t)\)\), "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%t\), 
            RowBox[{"||", 
              RowBox[{
                StyleBox[\(r'\),
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], \((t)\)}], 
              "||", \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%t\), 
              RowBox[{"||", 
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(\[Rho]'\), \((t)\), 
                        RowBox[{
                          StyleBox[\(e\_\[Rho]\),
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(\(\[Rho](t)\) \[Theta]\ ' \((t)\)\)}],
                    "TraditionalForm"], 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], 
                "||", \(\[DifferentialD]t\)}]}], 
            "=", \(\[Integral]\_a\%t\(\@\(\((\[Rho]' \((t)\))\)\^2 + \((\(\
\[Rho](t)\) \[Theta]\ ' \((t)\))\)\^2\)\) \(\(\[DifferentialD]\)\(t\)\(\ \ \ \
\ \ \ \ \ \ \)\)\)}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Y, por tanto, ",
  Cell[BoxData[
      \(TraditionalForm\`s' \((t)\) = \@\(\((\[Rho]' \((t)\))\)\^2 + \((\(\
\[Rho](t)\) \[Theta]\ ' \((t)\))\)\^2\)\)]],
  ". Esta igualdad suele escribirse en la forma"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\((\[DifferentialD]s)\)\^2 = \((\[DifferentialD]\
\[Rho])\)\^2 + \(\(\[Rho]\^2\)(\[DifferentialD]\[Theta]\ )\)\^2\)]],
  "\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y se llama ",
  StyleBox["elemento diferencial de longitud",
    FontSlant->"Italic"],
  " en coordenadas polares. Observa que aqu\[IAcute] aparecen los factores de \
escala 1 y \[Rho] elevados al cuadrado y multiplicando a las correspondientes \
\"diferenciales\" \[DifferentialD]\[Rho] y \[DifferentialD]\[Theta]. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Significado de los factores de escala", "Subsection"],

Cell["\<\
Consideremos la matriz jacobiana de la funci\[OAcute]n que introduce las \
coordenadas polares.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(A = \(matrizjacobiana2[g]\)[\[Rho], \[Theta]]\)], "Input"],

Cell[BoxData[
    \({{Cos[\[Theta]], \(-\[Rho]\)\ Sin[\[Theta]]}, {Sin[\[Theta]], \[Rho]\ \
Cos[\[Theta]]}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Esta matriz define una aplicaci\[OAcute]n lineal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " que a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " hace corresponder el vector ",
  Cell[BoxData[
      \(TraditionalForm\`A . \((x, y)\)\)]],
  ". Calculemos la norma eucl\[IAcute]dea de la imagen de un vector en dicha \
transformaci\[OAcute]n."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@\(\((A . {x, y})\) . \((A . {x, y})\)\) // Simplify\)], "Input"],

Cell[BoxData[
    \(\@\(x\^2 + y\^2\ \[Rho]\^2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Deducimos que para vectores situados a lo largo del eje de abscisas, es \
decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(A . \((x, 
                0)\)\)\)\(||\)\) = \(\(||\)\((x, 0)\)\(||\)\)\)]],
  " y, teniendo en cuenta la linealidad, se sigue que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(||\)\(A . \((x, 0)\)\)\) - 
            A . \((z, 0)\)\)\(||\)\) = \(\(\(||\)\(\((x, 0)\) - \((z, 
                0)\)\)\)\(||\)\)\)]],
  ", esto es, la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Rule] A . \((x, y)\)\)]],
  " conserva distancias en el eje X. Pues bien, este es el significado de que \
el factor de escala asociado a la primera variable sea igual a 1.\nDeducimos \
tambi\[EAcute]n que para vectores situados a lo largo del eje de ordenadas, \
es decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, y)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(A . \((0, 
                y)\)\)\)\(||\)\) = \[Rho] || \((0, y)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(||\)\(A . \((0, y)\)\)\) - 
            A . \((0, w)\)\)\(||\)\) = \[Rho] || \((0, y)\) - \((0, 
              w)\) || \)]],
  ", esto es, la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) \[Rule] A . \((x, y)\)\)]],
  " multiplica distancias por \[Rho] en el eje Y. Pues bien, este es el \
significado de que el factor de escala asociado a la segunda variable sea \
igual a \[Rho].\nEn resumen, los factores de escala indican las dilataciones \
a lo largo de los ejes que hace la aplicaci\[OAcute]n lineal asociada a la \
matriz jacobiana de la aplicaci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(g(\[Rho], \[Theta]) = \((\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\)\)\)\)]],
  ". Suele decirse que la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es la que, a ",
  StyleBox["escala infinitesimal",
    FontSlant->"Italic"],
  ", produce esas dilataciones. La expresi\[OAcute]n \"escala infinitesimal\" \
se entiende de la siguiente forma. Supongamos que fijamos valores ",
  Cell[BoxData[
      \(TraditionalForm\`\[Rho] = \[Rho]\_0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Theta] = \[Theta]\_0\)]],
  " y sea \[Delta]  un n\[UAcute]mero \"muy peque\[NTilde]o\" (lo que en los \
siglos XVII y XVIII se llamaba un \"infinit\[EAcute]simo\"; terminolog\
\[IAcute]a precient\[IAcute]fica que todav\[IAcute]a usan algunos textos de f\
\[IAcute]sica). Entonces, por la definici\[OAcute]n de derivada, tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\(\(||\)\(g(\[Rho]\_0 + \[Delta], \[Theta]\_0) - 
                g(\[Rho]\_0, \
\[Theta]\_0)\)\(||\)\(\(\[TildeEqual]\)\(\[Delta]\)\)\(||\)\(\(\[PartialD]g\/\
\[PartialD]\[Rho]\) \((\[Rho]\_0, \[Theta]\_0)\)\)\(||\)\) = \[Delta]\), 
          "                              ", "\n", 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["g",
                    FontSlant->"Italic"], 
                  "(", \(\[Rho]\_0, \ \[Theta]\_0\  + \ \[Delta]\), ")"}], 
                " ", "-", " ", 
                RowBox[{
                  StyleBox["g",
                    FontSlant->"Italic"], "(", \(\[Rho]\_0, \ \[Theta]\_0\), 
                  ")"}]}], "||", " ", \(\(\[TildeEqual]\)\(\ \)\(\[Delta]\)\),
               "||", \(\(\[PartialD]g\/\[PartialD]\[Theta]\) \((\[Rho]\_0, \ \
\[Theta]\_0)\)\), "||"}], " ", "=", " ", \(\[Delta]\[Rho]\_0\), 
            "              "}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La primera igualdad nos dice que si efectuamos \"incrementos \
infinitesimales\" en la primera variable la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " conserva distancias y la segunda igualdad nos dice que si efectuamos \
\"incrementos infinitesimales\" en la segunda variable la aplicaci\[OAcute]n \
",
  StyleBox["g ",
    FontSlant->"Italic"],
  "multiplica",
  StyleBox[" ",
    FontSlant->"Italic"],
  "las distancias por el correspondiente valor de la primera variable."
}], "Text"],

Cell[TextData[{
  "La expresi\[OAcute]n (5) del \"elemento diferencial de longitud\" en \
coordenadas polares tiene en cuenta dichos factores de escala. \n\
Naturalmente, para calcular la longitud de una curva dada por las ecuaciones \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((\(\[Rho](t)\) cos\ \(\[Theta](t)\), \ 
            \(\[Rho](t)\) sen\ \(\[Theta](t)\))\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", lo que se hace es integrar la rapidez con que dicha curva se recorre:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "'"}], \((t)\)}], "||"}], "=", 
        \(\@\(\((\[Rho]' \((t)\)\ cos\ \(\[Theta](t)\) - 
                    \(\[Rho](t)\)\ \[Theta]\ ' \((t)\)\ sen\ \(\[Theta](t)\))
                  \)\^2 + 
              \((\[Rho]' \((t)\)\ sen\ \(\[Theta](t)\) + 
                    \(\[Rho](t)\)\ \[Theta]\ ' \((t)\)\ cos\ \(\[Theta](t)\))
                  \)\^2\ \ \) = 
          \@\(\[Rho]' \((t)\)\^2 + 
              \(\(\[Rho](t)\)\^2\) \[Theta]\ \ ' \((t)\)\^2\)\)}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "en consecuencia, la longitud de ",
  StyleBox["r ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "||", 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_a\%b
              \(\@\( \[Rho]' \((t)\)\^2 + 
                    \(\(\[Rho](t)\)\^2\) \[Theta]\ \ ' \((t)\)\^2\)\) 
              \[DifferentialD]t\)}], TraditionalForm]]],
  ". ",
  "Observa que el valor obtenido para ",
  Cell[BoxData[
      FormBox[
        RowBox[{"||", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "'"}], \((t)\)}], "||"}], 
        TraditionalForm]]],
  " pod\[IAcute]amos haberlo calculado directamente usando la igualdad (4)."
}], "Text"],

Cell[TextData[{
  "Al igual que cada factor de escala mide la dilataci\[OAcute]n \
infinitesimal a lo largo de un eje, el producto de los factores de escala, en \
nuestro caso \[Rho], mide el cambio en el \[AAcute]rea de un \
rect\[AAcute]ngulo a escala infinitesimal. El producto de los factores de \
escala es justamente el determinante jacobiano. Recuerda que la \
f\[OAcute]rmula del cambio de variables a coordenadas polares en una integral \
doble afirma que si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar continuo en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  " se verifica que\t\t"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\[Integral]\(\[Integral]\_A\( f(x, y)\) \(d(x, 
                  y)\)\) = \[Integral]\(\[Integral]\_B\ \(\(f(\[Rho]\ cos\ \
\[Theta], \ \[Rho]\ sen\ \[Theta])\) \(\[Rho]\)\(\ \)\(d\) \((\[Rho], \
\[Theta])\)\(\ \)\)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((\[Rho], \[Theta])\), ":", 
                RowBox[{
                  
                  FormBox[
                    \((\[Rho]\ cos\ \[Theta], \ \[Rho]\ sen\ \[Theta])\),
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], 
              "}"}]}]}], TraditionalForm]]],
  ". Observa que ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es la expresi\[OAcute]n del conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " en coordenadas polares, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`A = g(B)\)]],
  ", y que en la segunda integral se multiplica por \[Rho]. Si \
particularizamos la igualdad anterior para la funci\[OAcute]n constante ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 1\)]],
  " obtenemos"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[CapitalAAcute]rea \((g(B))\)\), "=", 
          
          FormBox[\(\[Integral]\(\[Integral]\_A 
                    1 \( d(x, 
                      y)\)\) = \[Integral]\(\[Integral]\_B\ \[Rho]\ \
\(d(\[Rho], \[Theta])\)\)\),
            "TraditionalForm"], " "}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es un rect\[AAcute]ngulo muy peque\[NTilde]o (un rect\[AAcute]ngulo ",
  StyleBox["infinitesimal",
    FontSlant->"Italic"],
  ") se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\(\[Integral]\_B\ \[Rho]\ \(d(\[Rho], \[Theta])\)\)\  
          \[TildeEqual] \ 
          \[Rho] \(\[Integral]\(\[Integral]\_B\ d(\[Rho], \[Theta])\)\) = 
        \[Rho]\ \(\[CapitalAAcute]rea(B)\)\)]],
  " y obtenemos ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalAAcute]rea(g(B))\  \[TildeEqual] \ 
        \[Rho]\ \(\[CapitalAAcute]rea(B)\)\)]],
  ". En los libros de f\[IAcute]sica se dice que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Rho] \[DifferentialD]\[Rho] \[DifferentialD]\[Theta]\)]],
  " es el \"",
  StyleBox["elemento diferencial de \[AAcute]rea",
    FontSlant->"Italic"],
  "\" en coordenadas polares. "
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coordenadas esf\[EAcute]ricas", "Section"],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`g(
          r, \[Theta], \[Phi]) = \((r\ sen\ \[Theta]\ cos\ \[Phi]\ , \ 
          r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta])\)\)]],
  " es una biyecci\[OAcute]n de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{"\[CapitalOmega]", "=", 
                  
                  FormBox[\(\(\[DoubleStruckCapitalR]\^+\)\[Times]\([0, \
\[Pi]]\)\[Times]\),
                    "TraditionalForm"]}], "]"}], "-", "\[Pi]"}], ",", 
            "\[Pi]"}], "]"}], TraditionalForm]]],
  " sobre ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ".  Los n\[UAcute]meros ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \ \[Phi])\)\)]],
  " dados por ",
  Cell[BoxData[
      \(TraditionalForm\`x = r\ sen\ \[Theta]\ cos\ \[Phi], \ 
      y = \ r\ sen\ \[Theta]\ sen\ \[Phi], \ z = r\ cos\ \[Theta]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`r > 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] \ \[Theta] \[LessEqual] \[Pi]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) < \ \[Phi] \[LessEqual] \[Pi]\)]],
  ", se llaman las coordenadas esf\[EAcute]ricas del punto de cordenadas \
cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(coordesfericas;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
1 1 .75 r
MFill
% Scaling calculations
0.404762 0.0952381 0.404762 0.0952381 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.04 0.01 moveto 0 0 lineto
-0.04 -0.01 lineto fill
-0.04 0.01 moveto 0 0 lineto
-0.04 -0.01 lineto
-0.04 0.01 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.40476 .97619 m
.40476 .40476 L
.59524 .78571 L
.40476 .40476 L
.97619 .40476 L
.40476 .40476 L
.02381 .02381 L
s
[ .012 .012 ] 0 setdash
.40476 .92857 m
.59524 .78571 L
.59524 .2619 L
.40476 .40476 L
s
.59524 .2619 m
.7381 .40476 L
s
.59524 .2619 m
.2619 .2619 L
s
[ ] 0 setdash
newpath
.40476 .40476 .19048 63.435 90 arc
s
newpath
.40476 .40476 .05714 -135 -36.8699 arc
s
1 0 0 r
.02 w
.40571 .92857 Mdot
gsave
.5 .9381 -88.375 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(z) show
70.250 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
77.500 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(rcos) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
113.750 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.68095 .60667 -109.719 -13.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 18.250 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(r) show
70.250 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
1.000 0.000 0.000 setrgbcolor
%%IncludeResource: font Mathematica2Mono-Bold
%%IncludeFont: Mathematica2Mono-Bold
/Mathematica2Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
77.500 9.875 moveto
(\\217) show
88.813 9.875 moveto
(!) show
91.625 9.875 moveto
(!) show
94.438 9.875 moveto
(!) show
97.250 9.875 moveto
(!) show
100.063 9.875 moveto
(!) show
102.875 9.875 moveto
(!) show
105.688 9.875 moveto
(!) show
108.500 9.875 moveto
(!) show
111.313 9.875 moveto
(!) show
114.125 9.875 moveto
(!) show
116.938 9.875 moveto
(!) show
119.750 9.875 moveto
(!) show
122.563 9.875 moveto
(!) show
125.375 9.875 moveto
(!) show
128.188 9.875 moveto
(!) show
131.000 9.875 moveto
(!) show
133.813 9.875 moveto
(!) show
136.625 9.875 moveto
(!) show
139.438 9.875 moveto
(!) show
142.250 9.875 moveto
(!) show
145.063 9.875 moveto
(!) show
147.875 9.875 moveto
(!) show
150.688 9.875 moveto
(!) show
152.813 9.875 moveto
(!) show
89.625 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(x) show
96.875 15.063 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
105.313 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(+) show
115.625 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(y) show
122.875 15.063 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
131.313 18.250 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(+) show
141.438 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(z) show
148.688 15.063 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(2) show
156.438 18.250 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.61429 .23333 -81.125 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(rsen) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
99.250 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.24286 .23333 -102.875 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(x) show
70.250 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
77.500 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(rsen) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(cos) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(f) show
142.750 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.75714 .4381 -102.969 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.188 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(y) show
70.438 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(=) show
77.688 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(rsen) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(sen) show
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(f) show
142.938 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45095 .64 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(q) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40476 .30952 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(f) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.7381 .40476 Mdot
.2619 .2619 Mdot
0 .4 1 r
.59524 .78571 Mdot
1 0 0 r
.5 Mabswid
.59524 .78571 m
.67143 .9381 L
s
% Start of user PostScript
2. 4. 2.8 5.6 MAarrowhead1
% End of user PostScript
.59524 .78571 m
.70952 .7 L
s
% Start of user PostScript
2. 4. 3.2 3.1 MAarrowhead1
% End of user PostScript
.59524 .78571 m
.74381 .84286 L
s
% Start of user PostScript
2. 4. 3.56 4.6 MAarrowhead1
% End of user PostScript
0 0 1 r
gsave
.64762 .77619 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
(P) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 0 r
gsave
.08095 .03333 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43333 .97143 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Z) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.97143 .42857 -66.625 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
70.250 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
/Courier-Bold findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.68095 .95714 -69.4063 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.250 16.750 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(r) show
75.813 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.77619 .8619 -69.4063 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.250 16.750 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
75.813 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.72857 .68095 -69.4063 -11.7813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 14.938 moveto
%%IncludeResource: font Courier-Bold
%%IncludeFont: Courier-Bold
%%BeginResource: font Courier-Bold-MISO
%%BeginFont: Courier-Bold-MISO
/Courier-Bold /Courier-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
70.250 16.750 moveto
%%IncludeResource: font Mathematica1Mono-Bold
%%IncludeFont: Mathematica1Mono-Bold
/Mathematica1Mono-Bold findfont 8.500 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
75.813 14.938 moveto
%%IncludeResource: font Courier-Bold-MISO
%%IncludeFont: Courier-Bold-MISO
/Courier-Bold-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ookn`0?oo_`40oooo003o0?oo_k00oono0@3oool00?l0oono/03ookl10?ooo`00o`3o
okn`0?oo_`40oooo003o0?oo_k00oono0@3oool00?l0oono/03ookl10?ooo`00o`3ookn`0?oo_`40
oooo003o0?oo_k00oono0@3oool00?l0oono/03ookl10?ooo`00o`3ookn`0?oo_`40oooo000:0?oo
_`030000003ookl0oono00l0oono00<0oon_0;Yb000000000P0000000`00LX`0j_no0=BK00030000
00030000M03Dokl0oono0?l0oonoQP3ookl10?ooo`002`3ookl00`000000oono0?oo_`0>0?oo_`03
0?oo[`2jLP0000000080000000<007:<0>[o_`3DV`000`0000000`0007@0e?no0?oo_`3o0?oo_hH0
oono0@3oool000`0oono00<000000?oo_`3ookl03`3ookl02@3oe7@000000000M03Dokl0oono0?oo
W`2K0000000009_D_`3o0?oo_hT0oono0@3oool000d0oono00<000000?oo_`3ookl03`3ookl01`3Z
^UD000000000M03Dojl0^W800000001b^Zl0o`3ookn:0?oo_`40oooo000>0?oo_`030000003ookl0
oono00l0oono00D0e9/00000000000000000002KW`3o0?oo_h/0oono0@3oool000l0oono00<00000
0?oo_`3ookl03P3ookl01@3oojl0^W8000000000LX`0j_no0?l0oonoR`3ookl10?ooo`00403ookl0
0`000000oono0?oo_`0=0?oo_`050?oDM000000000000000001b^Zl0o`3ookn;0?oo_`40oooo000A
0?oo_`030000003ookl0oono00/0oono00L0onZ<0780000005D0^^ZO09/000000000VmBo0?l0oono
RP3ookl10?ooo`004P3ookl00`000000oono0?oo_`090?oo_`090?oZS01b0000000009_D_`3ookl0
onZ<0780000005D0^^Zo0?l0oonoR@3ookl10?ooo`004`3ookl00`000000oono0?oo_`070?oo_`07
0=BK0000000000000000001b^Zl0oono0>ZjE@0300000003001bS03Zokl0oono0?l0oonoQP3ookl1
0?ooo`00503ookl00`000000oono0?oo_`060?oo_`070=BK0000000000000000001b^Zl0oono0>Zj
E@0300000003001bS03Zokl0oono0?l0oonoQP3ookl10?ooo`005@3ookl00`000000oono0?oo_`3o
0?oo_iP0oono0@3oool001H0oono00<000000?oo_`3ookl0o`3ooknG0?oo_`40oooo000G0?oo_`03
0000003ookl0oono0?l0oonoUP3ookl10?ooo`00603ookl00`000000oono0?oo_`3o0?oo_iD0oono
0@3oool001T0oono00<000000?oo_`3ookl0o`3ooknD0?oo_`40oooo000J0?oo_`030000003ookl0
oono0?l0oonoT`3ookl10?ooo`006`3ookl00`000000oono0?oo_`3o0?oo_i80oono0@3oool001`0
oono00<000000?oo_`3ookl0o`3ooknA0?oo_`40oooo000M0?oo_`030000003ookl0oono0?l0oono
T03ookl10?ooo`007P3ookl00`000000oono0?oo_`3o0?oo_hl0oono0@3oool001l0oono00<00000
0?oo_`3ookl0o`3ookn>0?oo_`40oooo000P0?oo_`030000003ookl0oono0?l0oonoS@3ookl10?oo
o`008@3ookl00`000000oono0?oo_`3o0?oo_h`0oono0@3oool00280oono00<000000?oo_`3ookl0
o`3ookn;0?oo_`40oooo000S0?oo_`030000003ookl0oono0?l0oonoRP3ookl10?ooo`00903ookl0
0`000000oono0?oo_`3o0?oo_hT0oono0@3oool002D0oono00<000000?oo_`3ookl0o`3ookn80?oo
_`40oooo000V0?oo_`030000003ookl0oono0?l0oonoQ`3ookl10?ooo`009`3ookl00`000000oono
0?oo_`3o0?oo_hH0oono0@3oool002P0oono00<000000?oo_`3ookl0o`3ookn50?oo_`40oooo000Y
0?oo_`030000003ookl0oono0?l0oonoQ03ookl10?ooo`00:P3ookl00`000000oono0?oo_`3o0?oo
_h<0oono0@3oool002/0oono00<000000?oo_`3ookl0o`3ookn20?oo_`40oooo000/0?oo_`030000
003ookl0oono0?l0oonoP@3ookl10?ooo`00;@3ookl00`000000oono0?oo_`3o0?oo_h00oono0@3o
ool002h0oono00<000000?oo_`3ookl0o`3ookmo0?oo_`40oooo000_0?oo_`030000003ookl0oono
0?l0oonoOP3ookl10?ooo`00<03ookl00`000000oono0?oo_`3o0?oo_gd0oono0@3oool00340oono
00<000000?oo_`3ookl0o`3ookml0?oo_`40oooo000b0?oo_`030000003ookl0oono0?l0oonoN`3o
okl10?ooo`00<`3ookl00`000000oono0?oo_`3o0?oo_gX0oono0@3oool003@0oono00<000000?oo
_`3ookl0o`3ookmi0?oo_`40oooo000e0?oo_`030000003ookl0oono0?l0oonoN03ookl10?ooo`00
=P3ookl00`000000oono0?oo_`3o0?oo_gL0oono0@3oool003L0oono00<000000?oo_`3ookl0o`3o
okmf0?oo_`40oooo000h0?oo_`030000003ookl0oono0?l0oonoM@3ookl10?ooo`00>@3ookl00`00
0000oono0?oo_`3o0?oo_g@0oono0@3oool003X0oono00<000000?oo_`3ookl0o`3ookmc0?oo_`40
oooo000k0?oo_`030000003ookl0oono0?l0oonoLP3ookl10?ooo`00?03ookl00`000000oono0?oo
_`3o0?oo_g40oono0@3oool003d0oono00<000000?oo_`3ookl0o`3ookm`0?oo_`40oooo000n0?oo
_`030000003ookl0oono0?l0oonoK`3ookl10?ooo`00?`3ookl00`000000oono0?oo_`3o0?oo_fh0
oono0@3oool00400oono00<000000?oo_`3ookl0o`3ookm]0?oo_`40oooo00110?oo_`030000003o
okl0oono0?l0oonoK03ookl10?ooo`00@P3ookl00`000000oono0?oo_`3o0?oo_f/0oono0@3oool0
04<0oono00<000000?oo_`3ookl0o`3ookmZ0?oo_`40oooo00140?oo_`030000003ookl0oono0?l0
oonoJ@3ookl10?ooo`00A@3ookl00`000000oono0?oo_`3o0?oo_fP0oono0@3oool004H0oono00<0
00000?oo_`3ookl0o`3ookmW0?oo_`40oooo00170?oo_`030000003ookl0oono0?l0oonoIP3ookl1
0?ooo`00B03ookl00`000000oono0?oo_`3o0?oo_fD0oono0@3oool004T0oono00<000000?oo_`3o
okl0o`3ookmT0?oo_`40oooo001:0?oo_`030000003ookl0oono0?l0oonoH`3ookl10?ooo`00B`3o
okl00`000000oono0?oo_`3o0?oo_f80oono0@3oool004`0oono00<000000?oo_`3ookl0o`3ookmQ
0?oo_`40oooo001=0?oo_`030000003ookl0oono0?l0oonoH03ookl10?ooo`00CP3ookl00`000000
oono0?oo_`3o0?oo_el0oono0@3oool004l0oono00<000000?oo_`3ookl0o`3ookmN0?oo_`40oooo
001@0?oo_`030000003ookl0oono0?l0oonoG@3ookl10?ooo`00D@3ookl00`000000oono0?oo_`3o
0?oo_e`0oono0@3oool00580oono00<000000?oo_`3ookl0o`3ookmK0?oo_`40oooo001C0?oo_`03
0000003ookl0oono0?l0oonoFP3ookl10?ooo`00E03ookl00`000000oono0?oo_`3o0?oo_eT0oono
0@3oool005D0oono00<000000?oo_`3ookl0o`3ookmH0?oo_`40oooo001F0?oo_`030000003ookl0
oono0?l0oonoE`3ookl10?ooo`00E`3ookl00`000000oono0?oo_`3o0?oo_eH0oono0@3oool005P0
oono00<000000?oo_`3ookl0o`3ookmE0?oo_`40oooo001I0?oo_`030000003ookl0oono0?l0oono
E03ookl10?ooo`00FP3ookl00`000000oono0?oo_`3o0?oo_e<0oono0@3oool005/0oono00<00000
0?oo_`3ookl0o`3ookmB0?oo_`40oooo001L0?oo_`030000003ookl0oono0?l0oonoD@3ookl10?oo
o`00G@3ookl00`000000oono0?oo_`0m0?oo_`030?nK003o07@0oono0?l0oono403ookl10?ooo`00
GP3ookl00`000000oono0?oo_`0l0?oo_`030?oDM03o05D0onZo0?l0oono403ookl10?ooo`00G`3o
okl00`000000oono0?oo_`0k0?oo_`030?oZS03o0000okZ_0?l0oono403ookl10?ooo`00;03ookl0
1`3o^UD0o`000?l0003o0000og:<0?oo_`3oV`000`3o00000`3oVil0oono0?oo_`090?oo_`030?oo
[`3oLP00o`0000D0o`0000D0og:<0?oo_`3ookl0oono0?njE@050?l000030?l0E@3oj[l0oono00<0
oono00<0oonO0?l0003o0000103o00000`3oe;l0oono0?oDM0030?l000030?mbS03ookl0okYE00<0
o`0000@0okZ_0?oo_`3ookl0okYE0`3o00000`3o07@0oono0?oo_`040?oo_`030?oo[`3oLP00o`00
00<0o`0000<0o`1d0?oo_`3ookl00P3ookl00`3oojl0og800?l000020?l000030?mbS03ookl0oono
0080oono00<0okYE0?l0003o00000`3o00000`3o05D0onZo0?oo_`030?oo_`030?oDM03o0000o`00
0080o`0000<0oi^O0?oo_`3ookl0B@3ookl00`3oojl0og800?l000050?l000050?mbS03ookl0oono
0?oo_`3o^UD01@3o00000`3o05D0onZo0?oo_`030?oo_`030?ooW`3o0000o`0000@0o`0000<0omBo
0?oo_`3oe7@00`3o00000`3oLX`0oono0?njE@030?l000040?nj[`3ookl0oono0?njE@<0o`0000<0
o`1d0?oo_`3ookl0S@3ookl10?ooo`00;03ookl01`3o^UD0o`000?l0003o0000og:<0?oo_`3oV`00
0`3o00000`3oVil0oono0?oZS0060?l000050?l0M03ookl0oono0?oo[`3oLP001P3o00001@3oLX`0
oono0?oo_`3ookl0oi/000L0o`0000@0okZ_0?oo_`3ookl0okYE203o00000`3oj[l0omAd0?l00002
0?l000030?mbS03ookl0okYE00<0o`0000<0okZ_0?oo_`3oV`001P3o00001@3oe;l0oono0?oo_`3o
okl0onZ<00P0o`0000<0omBo0?oo_`3ojX`01P3o00001@3o05D0onZo0?oo_`3ookl0oi/000L0o`00
00@0okZ_0?oo_`3ookl0oi/01P3o00000`3o05D0onZo0?oo_`180?oo_`030?oo[`3oLP00o`0000D0
o`0000D0og:<0?oo_`3ookl0oono0?nK00070?l000040?nj[`3ookl0oono0?njE@L0o`0000<0o`1E
0?oZ_`3oe7@00`3o00000`3oLX`0oono0?njE@030?l000030?nj[`3ookl0oi/000H0o`0000<0omBo
0?oo_`3ookl0R`3ookl10?ooo`00;@3ookl02@3ooil0o`000?l0003oLX`0oon_0?mb003o0000o`1E
0?oZ_`020?oo_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3ookl00`3ookl00`3oV`00o`1E
0?oZ_`060?oo_`030?njE@3o05D0onZo00<0oono00L0onZ<0?l0003oVil0oono0?oZS03o0000o`1d
00L0oono00D000000?oo_`3ojX`0o`000?nKW`030?oo_`070?oDM03o0000omBo0?oo_`3ojX`0o`00
0?mbS0030?oo_`040?oZS03o0000o`000?oD_`80oono00<0oi/00?l0003oVil0103ookl01`3oe7@0
o`000?oD_`3oojl0og800?l0003oVil00`3ookl00`3oV`00o`000?mbS0020?oo_`030?njE@3o05D0
onZo00<0oono00h0onZ<0?l0003oVil0oono0?oZS03o0000o`1E0?oZ_`3o^UD0o`1d0?oo_`3o^UD0
o`000?mbS4`0oono00<0oi/00?l0E@3oj[l01P3ookl00`3o^UD0o`1E0?oZ_`030?oo_`070?oZS03o
0000oi^O0?oo_`3ojX`0o`000?l0M0090?oo_`030?oZS03o0000oi^O00<0oono00L0omAd0?l0003o
e;l0oono0?oZS03o0000og:<00<0oono00@0onZ<0?l0003o0000omBoS03ookl10?ooo`00;`3ookl0
1@3oV`00o`000?l0003o0000og:<0140oono00<0oi/00?l0E@3oj[l02@3ookl0203ojX`0o`000?l0
003o0000o`1E0?oZ_`3ookl0omAd203o00001P3o05D0onZo0000003ojX`0o`000?nKW`<0oono00L0
omAd0?l0003oe;l0oono0?oDM03o0000omBo00@0oono00L0oon_0?mb003oLX`0oono0?ooW`3o0000
og:<00P0oono00<0onZ<0?l0003oVil01@3ookl00`3oV`00o`1E0?oZ_`040?oo_`0B0?oZS03o0000
o`000?l0003o05D0onZo0?oo_`3oe7@0o`000?nj[`3ookl0omAd0?l0003oe;l0oono0?nK003o05D0
onZoB`3ookl00`3oV`00o`1E0?oZ_`090?oo_`080?oZS03o0000o`000?l0003o05D0onZo0?oo_`3o
e7@80?l000060?l0E@3oj[l0oono0?oZS03o0000oi^O0`3ookl01`3oe7@0o`000?oD_`3ookl0omAd
0?l0003oe;l0103ookl00`3oojl0og800?mbS02<0?oo_`40oooo000_0?oo_`050?njE@3o0000o`00
0?l0003o^Zl0103ookl00`3ojX`0o`000?l000040?l000030?l0M03ookl0oono00<0oono00<0oi/0
0?l0003o^Zl01P3ookl00`3oojl0og800?l000030?l000050?nKW`3ookl0oono0?oo_`3oe7@0203o
00001P3o07@0oono0?oo_`000000o`000?nKW`<0oono00D0omAd0?l0003oe;l0oono0?oDM0080?l0
00050?l0E@3oj[l0oonO0?l0003o07@01@3ookl01P3oV`00o`1d0?oo_`3ojX`0o`000?mbS0@0oono
00L0oon_0?mb003o05D0onZo0?oo_`3oojl0og8000@0o`0000l0oi^O0?oo_`3ookl0oono0?oZS03o
0000oi^O0?oo_`3ojX`0o`000?nj[`3ookl0okYE0?l0003oe;l0B`3ookl00`3oV`00o`000?nj[`06
0?oo_`030?oo[`3oLP00o`0000<0o`0000D0oi^O0?oo_`3ookl0oono0?oDM0080?l000060?l0M03o
okl0oono0?oZS03o0000oi^O0`3ookl01@3oe7@0o`000?oD_`3ookl0omAd00P0o`0000<0o`1E0?oZ
_`3ookl0RP3ookl10?ooo`00;@3ookl01@3oojl0og800?l0003o05D0onZO0080o`0000D0og:<0?oo
_`3ookl0oono0?oZS0060?l000030?l0M03ookl0oono00<0oono00@0oi/00?l0003o0000o`1d1@3o
okl00`3oe7@0o`000?nj[`030?oo_`080?njE@3o05D0onZo0?oo_`3ojX`0o`000?l0E@3oj[l30?oo
_`030?oDM03o0000oi^O0080oono00@0onZ<0>X0003o0000omBo0P3ookl01@3o^UD0o`000?oD_`3o
okl0onZ<00T0o`0000D0omBo0?oo_`3oV`00o`000?mbS0030?oo_`080?ooW`3o0000o`1E0?oZ_`3o
ojl0og800?l0003oVil30?oo_`030?nK003o0000og:<0080oono00<0omAd0?l0003o^Zl00`3ookl0
3`3o^UD0o`1E0?oZ_`3ookl0oon_0?mb003o0000okZ_0?ooW`3o0000oi^O0?oo[`3oLP00o`1E0?oZ
_`1;0?oo_`040?nK003o0000o`000?l0M0D0oono00<0omAd0?l0003o^Zl00`3ookl0203o^UD0o`1E
0?oZ_`3ookl0onZ<0?l0003o05D0onZo0`3ookl00`3oe7@0o`000?nKW`020?oo_`040?oZS03o0000
o`000?oD_`80oono00D0okYE0?l0003oe;l0oono0?oZS0090?l000030?oD_`3ookl0oono08T0oono
0@3oool002`0oono00L0onZ<0?l0003o0000o`000?mbS03ookl0oi/00080o`0000<0o`1E0?oZ_`3o
okl02`3ookl01@3o^UD0o`000?l0003o05D0omB<00@0o`0000<0okZ_0?oo_`3ooil01`3o0000103o
e;l0oono0?oo_`3oe7@60?l000040?l0M03ookl0oono0?oDM0L0o`0000H0o`1E0?oZ_`3ookl0oon_
0?mb003o07@50?oo_`050?oDM03o0000okZ_0?oo_`3ooil01`3o0000103o05D0onZo0?oo_`3ojX`6
0?l000050?l0E@3oj[l0oono0?oo_`3ooil01`3o0000103oe;l0oono0?oo_`3ooil70?l000030?mb
S03ookl0oono04P0oono00D0okYE0?l0003o0000o`1E0?oDS0040?l000030?nj[`3ookl0oonO00L0
o`0000@0omBo0?oo_`3ookl0omAd1P3o0000103o07@0oono0?oo_`3oe7@20?l000030?nKM03o0000
o`000080o`0000H0o`1E0?oZ_`3ookl0oon_0?mb003o07@50?oo_`030?oDM03o0000okZ_08/0oono
0@3oool002`0oono00L0onZ<0?l0003o0000o`000?mbS03ookl0oi/00080o`0000<0o`1E0?oZ_`3o
okl02`3ookl01P3o^UD0o`000?l0003o05D0onZo0?ooW`80o`0000D0og:<0?oo_`3ookl0oono0?oo
W`050?l000030?l0E@3oj[l0oono0080oono00<0oonO0?l0003o00000P3o00001@3oVil0oono0?oo
_`3ookl0omAd0080o`0000H0oi^O0000003o0000o`000?l0E@3oj[l30?oo_`040?oZS03o0000o`1E
0?oZ_`80oono00@0oon_0?mb003o05D0onZo0`3ookl01`3oV`00o`000?l0003o0000og:<0?oDM03o
07@0103ookl01@3oV`00o`000?l0003o0000oi^O00D0oono00<0oonO0?l0003o00000`3o00000`3o
05D0onZo0?oo_`030?oo_`030?njE@3o0000o`000080o`0000<0oi^O0?oo_`3ookl0B@3ookl01P3o
^UD0o`000?l0003o05D0onZo0?ooW`80o`0000D0og:<0?oo_`3ookl0oono0?ooW`050?l000030?l0
E@3oj[l0oono0080oono00<0oonO0?l0003o00000P3o00001@3oVil0oono0?oo_`3ookl0omAd0080
o`0000H0oi^O0?oZS03o0000o`000?l0E@3oj[l30?oo_`040?oZS03o0000o`1E0?oZ_`80oono00@0
oon_0?mb003o05D0onZoR`3ookl10?ooo`00J03ookl00`000000oono0?oo_`050?oo_`030?oDM03o
0000o`0000@0o`0000<0oi^O0?oo_`3ookl09@3ookl00`3oe7@0o`000?oD_`1i0?oo_`030?oDM03o
0000o`0000@0o`0000<0oi^O0?oo_`3ookl0RP3ookl10?ooo`00J@3ookl00`000000oono0?oo_`05
0?oo_`030?oo[`3oLP00o`000080o`0000<0oi^O0?oo_`3ookl09P3ookl00`3ojX`0o`000?nj[`1j
0?oo_`030?oo[`3oLP00o`000080o`0000<0oi^O0?oo_`3ookl0R`3ookl10?ooo`00JP3ookl00`00
0000oono0?oo_`0b0?oo_`030?oo[`3oLP00og:<0?l0oono3P3ookl10?ooo`00J`3ookl00`000000
oono0?oo_`3o0?oo_d80oono0@3oool006`0oono00<000000?oo_`3ookl0o`3ookm10?oo_`40oooo
001]0?oo_`030000003ookl0oono0080o`00o`3ookln0?oo_`40oooo001^0?oo_`H0o`00o`3ookll
0?oo_`40oooo001^0?oo_`H0o`00o`3ookll0?oo_`40oooo001]0?oo_`P0o`001P0000040?oo_`H0
0000103ookl6000000@0oono1`0000040?oo_`H00000103ookl6000000@0oono1`0000040?oo_`H0
0000103ookl6000000@0oono1`0000040?oo_`H00000103ookl6000000@0oono1`0000040?oo_`H0
0000[P3ookl10?ooo`00K@3ookl80?l008`0oono00<000000?oo_`3ookl0Z`3ookl10?ooo`00KP3o
okl60?l008X0oono00D000000?oo_`3ookl0oono0000002/0?oo_`40oooo001^0?oo_`H0o`00R@3o
okl010000000oono0?oo_`0000020?oo_`030000003ookl0oono0:T0oono0@3oool00700oono0P3o
00020?oo_`030000003ookl0oono08@0oono0P0000030?oo_`050000003ookl0oono0?oo_`000000
ZP3ookl10?ooo`00M@3ookl00`000000oono0?oo_`220?oo_`030000003ookl0oono00<0oono00<0
00000?oo_`3ookl0[03ookl10?ooo`00MP3ookl00`000000oono0?oo_`270?oo_`030000003ookl0
oono0:`0oono0@3oool007L0oono00<000000?oo_`3ookl0QP3ookl00`000000oono0?oo_`2/0?oo
_`40oooo001h0?oo_`030000003ookl0oono07/0oono00<000000?oo_`3ookl01`3ookl00`000000
oono0?oo_`040?oo_`030000003ookl0oono0:D0oono0@3oool007T0oono00<000000?oo_`3ookl0
N03ookl200000180oono00<000000?oo_`3ookl0Y03ookl10?ooo`00NP3ookl00`000000oono0?oo
_`1e0?oo_`8000005@3ookl200000:@0oono0@3oool007/0oono00<000000?oo_`3ookl0L`3ookl0
0`000000oono0?oo_`0G0?oo_`030000003ookl0oono0:40oono0@3oool007`0oono00<000000?oo
_`3ookl0o`3ookla0?oo_`40oooo001m0?oo_`030000003ookl0oono0800oono00<000000?oo_`3o
okl0[03ookl10?ooo`00OP3ookl00`000000oono0?oo_`0[0?oo_`030?nK003o07@0oono03h0oono
00<000000?oo_`3ookl0403ookl00`000000oono0?oo_`2/0?oo_`40oooo001o0?oo_`030000003o
okl0oono02X0oono00<0omAd0?l0E@3oj[l0?@3ookl00`000000oono0?oo_`0A0?oo_`030000003o
okl0oono00`0oono00<000000?oo_`3ookl0W@3ookl10?ooo`00P03ookl00`000000oono0?oo_`0Y
0?oo_`030?oZS03o0000okZ_03`0oono00<000000?oo_`3ookl04P3ookl00`000000oono0?oo_`0=
0?oo_`030000003ookl0oono09`0oono0@3oool00840oono00<000000?oo_`3ookl09`3ookl00`3o
e7@0o`000?l000020?l000030?nKW`3ookl0oono03L0oono00<000000?oo_`3ookl04`3ookl00`00
0000oono0?oo_`0=0?oo_`030000003ookl0oono09`0oono0@3oool00880oono00<000000?oo_`3o
okl09@3ookl00`3oV`00o`000?l000040?l000030?l0E@3oj[l0oono03D0oono00<000000?oo_`3o
okl0503ookl00`000000oono0?oo_`0>0?oo_`030000003ookl0oono09/0oono0@3oool008<0oono
00<000000?oo_`3ookl08`3ookl02P3ojX`0o`000?l0E@3oj[l0okYE0?l0M03ookl0okYE0?l0003o
LXaO0?oo_`030000003ookl0oono09X0oono0@3oool008@0oono00<000000?oo_`3ookl08P3ookl0
2`3oe7@0o`000?nj[`3ookl0omAd0?l0003oe;l0oono0?nK003o05D0onZo0?/0oono0@3oool008D0
oono00<000000?oo_`3ookl08@3ookl02`3ojX`0o`000?nKW`3ookl0onZ<0?l0003o^Zl0oono0?nj
E@3o0000omBo0340oono00<000000?oo_`3ookl0a`3ookl10?ooo`00QP3ookl00`000000oono0?oo
_`0P0?oo_`0;0?oo[`3oLP00o`000?nj[`3ooil0o`000?nKW`3oojl0og800?l0E@3oj[l0<03ookl0
0`000000oono0?oo_`0_0?oo_`030000003ookl0oono09H0oono0@3oool008L0oono00<000000?oo
_`3ookl0803ookl00`3ooil0o`000?l000050?l000030?mbS03ookl0oono02d0oono0P00000c0?oo
_`030000003ookl0oono09D0oono0@3oool008P0oono00<000000?oo_`3ookl08@3ookl00`3o^UD0
o`000?l000020?l000030?nKW`3ookl0oono02d0oono00<000000?oo_`3ookl0703ookl00`000000
oono0?oo_`0E0?oo_`030000003ookl0oono09@0oono0@3oool008T0oono00<000000?oo_`3ookl0
8P3ookl00`3oe7@0o`000?oD_`1?0?oo_`030000003ookl0oono01H0oono00<000000?oo_`3ookl0
T`3ookl10?ooo`00RP3ookl00`000000oono0?oo_`0Q0?oo_`030?oZS03o0000okZ_04l0oono00<0
00000?oo_`3ookl05`3ookl00`000000oono0?oo_`2B0?oo_`40oooo002;0?oo_`030000003ookl0
oono0200oono00<0oon_0?mb003oLX`0;03ookl00`000000oono0?oo_`0P0?oo_`030000003ookl0
oono0:`0oono0@3oool008`0oono00<000000?oo_`3ookl0C@3ookl00`000000oono0?oo_`0Q0?oo
_`030000003ookl0oono0:`0oono0@3oool008d0oono00<000000?oo_`3ookl0BP3ookl2000002@0
oono00<000000?oo_`3ookl0[03ookl10?ooo`00SP3ookl00`000000oono0?oo_`180?oo_`030000
003ookl0oono0440oono00<000000?oo_`3ookl0S`3ookl10?ooo`00S`3ookl00`000000oono0?oo
_`2<0?oo_`030000003ookl0oono08h0oono0@3oool00900oono00<000000?oo_`3ookl0S03ookl2
000008h0oono0@3oool00940oono00<000000?oo_`3ookl0@03ookl00`000000oono0?oo_`1:0?oo
_`030000003ookl0oono08/0oono0@3oool00980oono00<000000?oo_`3ookl0?P3ookl00`000000
oono0?oo_`0Z0?oo_`030000003ookl0oono0:`0oono0@3oool009<0oono00<000000?oo_`3ookl0
>`3ookl2000002d0oono00<000000?oo_`3ookl0[03ookl10?ooo`00U03ookl00`000000oono0?oo
_`0i0?oo_`030000003ookl0oono02d0oono00<000000?oo_`3ookl0[03ookl10?ooo`00U@3ookl0
0`000000oono0?oo_`0D0?oo_`D00000C`3ookl00`000000oono0?oo_`0R0?oo_`030000003ookl0
oono08L0oono0@3oool009H0oono00<000000?oo_`3ookl03P3ookl5000000D0oono1@00001:0?oo
_`030000003ookl0oono02<0oono00<000000?oo_`3ookl0QP3ookl10?ooo`00U`3ookl00`000000
oono0?oo_`0;0?oo_`8000003`3ookl3000001<0oono00<000000?oo_`3ookl0<@3ookl00`000000
oono0?oo_`0S0?oo_`030000003ookl0oono08H0oono0@3oool009P0oono00<000000?oo_`3ookl0
203ookl2000001@0oono0P00000@0?oo_`030000003ookl0oono05T0oono00<000000?oo_`3ookl0
Q@3ookl10?ooo`00V@3ookl00`000000oono0?oo_`050?oo_`800000603ookl00`000000oono0?oo
_`0;0?oo_`800000G@3ookl00`000000oono0?oo_`240?oo_`40oooo002J0?oo_`030000003ookl0
oono00<0oono00<000000?oo_`3ookl06@3ookl00`000000oono0?oo_`090?oo_`030000003ookl0
oono0>@0oono0@3oool009/0oono00D000000?oo_`3ookl0oono0000000M0?oo_`800000l03ookl1
0?ooo`00W03ookl00`000000oono0000000P0?oo_`030000003ookl0oono03h0oono00<000000?oo
_`3ookl0:@3ookl00`000000oono0?oo_`200?oo_`40oooo002M0?oo_`030000003ookl0oono0200
oono00D000000?oo_`3ookl0oono0000000k0?oo_`030000003ookl0oono02X0oono00<000000?oo
_`3ookl0O`3ookl10?ooo`00WP3ookl00`000000oono0?oo_`0P0?oo_`030000003ookl0000003`0
oono00<000000?oo_`3ookl0:`3ookl00`000000oono0?oo_`1n0?oo_`40oooo002O0?oo_`030000
003ookl0oono0200oono00<000000?oo_`3ookl0>`3ookl00`000000oono0?oo_`0/0?oo_`030000
003ookl0oono07d0oono0@3oool00:00oono00<000000?oo_`3ookl07P3ookl00`000000oono0?oo
_`0l0?oo_`030000003ookl0oono02d0oono00<000000?oo_`3ookl0O03ookl10?ooo`00X@3ookl0
0`000000oono0?oo_`0L0?oo_`030000003ookl0oono03d0oono00<000000?oo_`3ookl0[03ookl1
0?ooo`00XP3ookl00`000000oono0?oo_`3o0?oo_`/0oono0@3oool00:<0oono00<000000?oo_`3o
okl0o`3ookl:0?oo_`40oooo002T0?oo_`030000003ookl0oono01D0oono00<000000?oo_`3ookl0
M03ookl00`000000oono0?oo_`1i0?oo_`40oooo002U0?oo_`030000003ookl0oono01<0oono00<0
00000?oo_`3ookl0MP3ookl00`000000oono0?oo_`1h0?oo_`40oooo002V0?oo_`030000003ookl0
oono0100oono0P00001j0?oo_`800000N03ookl10?ooo`00Y`3ookl00`000000oono0?oo_`0>0?oo
_`030000003ookl0oono04D0oono00<000000?oo_`3ookl0=03ookl00`000000oono0?oo_`1e0?oo
_`40oooo002X0?oo_`030000003ookl0oono05D0oono00<000000?oo_`3ookl0[03ookl10?ooo`00
Z@3ookl00`000000oono0?oo_`1D0?oo_`030000003ookl0oono0:`0oono0@3oool00:X0oono00<0
00000?oo_`3ookl01P3ookl00`000000oono0?oo_`1:0?oo_`030000003ookl0oono0:`0oono0@3o
ool00:/0oono00<000000?oo_`3ookl0103ookl00`000000oono0?oo_`1;0?oo_`030000003ookl0
oono03P0oono00@000000?oo_`3o0000o`00L03ookl10?ooo`00[03ookl010000000oono0?oo_`3o
okl2000004h0oono00<000000?oo_`3ookl0>03ookl60?l006h0oono0@3oool00:d0oono00<00000
0?oo_`000000R`3ookl60?l006h0oono0@3oool00:h0oonoS00000080?l006<000002P3ookl10?oo
o`00[P3ookl00`000000oono0?oo_`290?oo_`P0o`00K@3ookl10?ooo`00[P3ookl2000008/0oono
1P3o001^0?oo_`40oooo002^0?oo_`800000D03ookl00`000000oono0?oo_`0h0?oo_`H0o`00KP3o
okl10?ooo`00[P3ookl00`000000oono0000001?0?oo_`030000003ookl0oono03X0oono0P3o001`
0?oo_`40oooo002^0?oo_`030000003ookl0000004l0oono00<000000?oo_`3ookl0[03ookl10?oo
o`00[P3ookl010000000oono0?oo_`00001>0?oo_`030000003ookl0oono09/0oono00<0oon_0;Yb
00000000100000000`00LX`0j_no0?oo_`070?oo_`40oooo002^0?oo_`040000003ookl0oono0000
04h0oono00<000000?oo_`3ookl0V`3ookl00`3oojl0^W800000000400000003001bS03Zokl0oono
00L0oono0@3oool00:h0oono00D000000?oo_`3ookl0oono0000001=0?oo_`030000003ookl0oono
00L0oono00<0oi/00?l0003o00000`3o00000`3oLX`0oono0?oo_`1X0?oo_`030?nK003o07@0oono
02<0oono00<0omAd0000001b^Zl02`3ookl10?ooo`00[P3ookl01@000000oono0?oo_`3ookl00000
05L0oono00<0oi/00?l0003o00000`3o00000`3oLX`0oono0?oo_`1X0?oo_`030?oDM03o05D0onZo
02<0oono00<0omAd0000001b^Zl02`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`020?oo_`03
0000003ookl0oono05L0oono00<0omAd0?l0003oLX`0J`3ookl00`3ojX`0o`000?nj[`0S0?oo_`03
0?oDM0000000L[Z_00/0oono0@3oool00:h0oono00<000000?oo_`3ookl00P3ookl00`000000oono
0?oo_`1H0?oo_`030?nK003o0000omBo00l0oono00<0oon_0?mb003o00001@3o00001@3oLX`0oono
0?oo_`3ookl0okYE00D0o`0000<0o`1E0?oZ_`3ookl00`3ookl00`3ooil0o`000?l000040?l00003
0?oD_`3ookl0omAd00<0o`0000<0og:<0?oo_`3o^UD00`3o0000103o^Zl0oono0?oo_`3o^UD30?l0
00030?l0M03ookl0oono00<0oono00<0okYE0?l0003o00000`3o00000`3o05D0onZo0?oo_`030?oo
_`030?ooW`3o0000o`0000@0o`0000<0omBo0?oo_`3oe7@00`3o00000`3oLX`0oono0?njE@030?l0
00040?nj[`3ookl0oono0?oDM0@0o`0000<0oi^O0?oo_`3ookl07P3ookl01@3ooil0V`0000000000
07@0e?no00X0oono0@3oool00:h0oono00<000000?oo_`3ookl00`3ookl00`000000oono0?oo_`1F
0?oo_`040?oZS03o0000o`000?mbS0D0oono00<0onZ<0?l0003o0000103o00001@3o07@0oono0?oo
_`3oojl0og8000H0o`0000D0og:<0?oo_`3ookl0oono0?nK00070?l000040?nj[`3ookl0oono0?nj
E@L0o`0000<0o`1E0?oZ_`3oe7@00`3o00000`3oLX`0oono0?njE@030?l000030?nj[`3ookl0oi/0
00H0o`0000D0omBo0?oo_`3ookl0oono0?nK00070?l000040?nj[`3ookl0oono0?njE@L0o`0000<0
o`1E0?oZ_`3oe7@00`3o00000`3oLX`0oono0?njE@030?l000030?nj[`3ookl0oi/000H0o`0000<0
o`1E0?oZ_`3ookl07@3ookl01P3DV`00000000000000000007:<0>[o_`T0oono0@3oool00:h0oono
00<000000?oo_`3ookl00`3ookl00`000000oono0?oo_`190?oo_`030000003ookl0oono00X0oono
00D0oi/00?l0003o0000o`000?oD_`040?oo_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3o
okl00`3ookl00`3oV`00o`1E0?oZ_`060?oo_`030?njE@3o05D0onZo00<0oono00L0onZ<0?l0003o
Vil0oono0?oZS03o0000o`1d00T0oono00<0onZ<0?l0003oVil00`3ookl01`3oe7@0o`000?oD_`3o
okl0onZ<0?l0003oLX`00`3ookl0103ojX`0o`000?l0003oe;l20?oo_`030?njE@3o05D0onZo00<0
oono00L0onZ<0?l0003oVil0oono0?oZS03o0000o`1d00T0oono00<0onZ<0?l0003oVil00`3ookl0
3P3oe7@0o`000?oD_`3ookl0onZ<0?l0003o05D0onZo0?njE@3o07@0oono0?njE@3o0000og:<7@3o
okl01`3Z^UD00000001bS03Zokl0e9/00000001b^Zl02@3ookl10?ooo`00[P3ookl00`000000oono
0?oo_`040?oo_`030000003ookl0oono04P0oono00<000000?oo_`3ookl02@3ookl01P3oe7@0o`00
0?mbS03ojX`0o`000?l0M140oono00<0oi/00?l0E@3oj[l02@3ookl0203ojX`0o`000?l0003o0000
o`1E0?oZ_`3ookl0omAd203o00001P3o05D0onZo0?oo_`3ojX`0o`000?nKW`<0oono00L0omAd0?l0
003oe;l0oono0?oDM03o0000omBo00@0oono00<0oon_0?mb003oLX`01@3ookl0203ojX`0o`000?l0
003o0000o`1E0?oZ_`3ookl0omAd203o00001P3o05D0onZo0?oo_`3ojX`0o`000?nKW`<0oono00l0
omAd0?l0003oe;l0oono0?oDM03o0000okZ_0?oo_`3oe7@0o`000?oD_`3ookl0oi/00?l0E@3oj[l0
6`3ookl02@3ojX`0LP000000M03Dokl0oono0?ooW`2K0000001E0;[Z_`080?oo_`40oooo002^0?oo
_`030000003ookl0oono00@0oono00<000000?oo_`3ookl0B03ookl00`000000oono0?oo_`080?oo
_`080?oo[`3oLP00o`1E0?oZ_`3ookl0okYE0?l0003o^Zl30?oo_`030?oZS03o0000o`0000@0o`00
00<0o`1d0?oo_`3ookl00`3ookl00`3oV`00o`000?nj[`060?oo_`030?oo[`3oLP00o`0000<0o`00
00D0oi^O0?oo_`3ookl0oono0?oDM0080?l000060?l0M03ookl0oono0?oZS03o0000oi^O0`3ookl0
1@3oe7@0o`000?oD_`3ookl0omAd00P0o`0000D0o`1E0?oZ_`3ookl0oon_0?mb00040?l000050?nK
W`3ookl0oono0?oo_`3oe7@0203o00001P3o07@0oono0?oo_`3ojX`0o`000?nKW`<0oono00l0omAd
0?l0003oe;l0oono0?oZS03o0000oi^O0?oo_`3ojX`0o`000?nj[`3ookl0okYE0?l0003oe;l06P3o
okl0203DV`000000000000000000L[Z_0?oo_`3ojX`0LP000P0000000`00Vil0oono0?oo_`050?oo
_`40oooo002^0?oo_`030000003ookl0oono00D0oono00<000000?oo_`3ookl0A`3ookl00`000000
oono0?oo_`080?oo_`030?oDM03o0000oi^O0080oono00<0oonO0?l0003o07@00`3ookl00`3ojX`0
o`000?l000040?l000030?l0M03ookl0oono00<0oono00@0oi/00?l0003o0000o`1d1@3ookl00`3o
e7@0o`000?nj[`030?oo_`080?njE@3o05D0onZo0?oo_`3ojX`0o`000?l0E@3oj[l30?oo_`030?oD
M03o0000oi^O0080oono00@0onZ<0?l0003o0000omBo0P3ookl01@3o^UD0o`000?oD_`3ookl0onZ<
00T0o`0000D0omBo0?oo_`3oe7@0o`000?nj[`030?oo_`080?njE@3o05D0onZo0?oo_`3ojX`0o`00
0?l0E@3oj[l30?oo_`030?oDM03o0000oi^O0080oono00@0onZ<0?l0003o0000omBo0P3ookl03`3o
^UD0o`000?oD_`3ookl0oon_0?mb003o0000okZ_0?ooW`3o0000oi^O0?oo[`3oLP00o`1E0?oZ_`0J
0?oo_`080=BK0000000000000000001b^Zl0oono0?oZS01b000200000003002KW`3ookl0oono00D0
oono0@3oool00:h0oono00<000000?oo_`3ookl01@3ookl00`000000oono0?oo_`170?oo_`030000
003ookl0oono00L0oono00L0okYE0?l0003o0000o`000?nKW`3oojl0og8000<0o`0000<0omBo0?oo
_`3ookl02P3ookl01@3o^UD0o`000?l0003o05D0omB<00@0o`0000<0okZ_0?oo_`3ooil01`3o0000
103oe;l0oono0?oo_`3oe7@60?l000040?l0M03ookl0oono0?oDM080o`0000<0oi]d0?l0003o0000
0P3o00001P3o05D0onZo0?oo_`3oojl0og800?l0M0D0oono00D0omAd0?l0003o^Zl0oono0?ooW`07
0?l000040?oD_`3ookl0oono0?oDM0H0o`0000@0o`1d0?oo_`3ookl0omAd0P3o00000`3oVg@0o`00
0?l000020?l000050?l0E@3oj[l0oono0?oo_`3ooil01`3o00000`3oLX`0oono0?oo_`0[0?oo_`40
oooo002^0?oo_`030000003ookl0oono00H0oono00<000000?oo_`3ookl0AP3ookl00`000000oono
0?oo_`070?oo_`070?njE@3o0000o`000?l0003oVil0oon_0?mb00030?l000030?oD_`3ookl0oono
00X0oono00H0okYE0?l0003o0000o`1E0?oZ_`3ooil20?l000050?mbS03ookl0oono0?oo_`3ooil0
1@3o00000`3o05D0onZo0?oo_`020?oo_`030?ooW`3o0000o`000080o`0000D0oi^O0?oo_`3ookl0
oono0?oDM0020?l000060?nKW`3ojX`0o`000?l0003o05D0onZo0`3ookl0103ojX`0o`000?l0E@3o
j[l20?oo_`040?oo[`3oLP00o`1E0?oZ_`80oono00<0oonO0?l0003o00000`3o00000`3o05D0onZo
0?oo_`020?oo_`030?ooW`3o0000o`000080o`0000D0oi^O0?oo_`3ookl0oono0?oDM0020?l00006
0?nKW`3ojX`0o`000?l0003o05D0onZo1@3ookl00`3o^UD0o`000?l000020?l000030?nKW`3ookl0
oono02`0oono0@3oool00:h0oono00<000000?oo_`3ookl01P3ookl00`000000oono0?oo_`160?oo
_`030000003ookl0oono04/0oono00<0omAd0?l0003o0000103o00000`3oVil0oono0?oo_`0U0?oo
_`030?oDM03o0000omBo02l0oono0@3oool00:h0oono00<000000?oo_`3ookl01`3ookl00`000000
oono0?oo_`2D0?oo_`030?oo[`3oLP00o`000080o`0000<0oi^O0?oo_`3ookl09P3ookl00`3ojX`0
o`000?nj[`0_0?oo_`40oooo002^0?oo_`030000003ookl0oono00L0oono00<000000?oo_`3ookl0
`P3ookl00`3oojl0og800?mbS00_0?oo_`40oooo002^0?oo_`030000003ookl0oono00P0oono00<0
00000?oo_`3ookl0l`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`080?oo_`030000003ookl0
oono0?<0oono0@3oool00:h0oono00<000000?oo_`3ookl02@3ookl00`000000oono0?oo_`130?oo
_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl02@3ookl00`000000
oono0?oo_`130?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl0
2P3ookl00`000000oono0?oo_`120?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<0
00000?oo_`3ookl02P3ookl00`000000oono0?oo_`120?oo_`030000003ookl0oono0:`0oono0@3o
ool00:h0oono00<000000?oo_`3ookl02`3ookl00`000000oono0?oo_`110?oo_`030000003ookl0
oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl02`3ookl00`000000oono0?oo_`110?oo
_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl0303ookl00`000000
oono0?oo_`3_0?oo_`40oooo002^0?oo_`030000003ookl0oono00`0oono00<000000?oo_`3ookl0
k`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0=0?oo_`030000003ookl0oono0>h0oono0@3o
ool00:h0oono00<000000?oo_`3ookl03@3ookl00`000000oono0?oo_`3^0?oo_`40oooo002^0?oo
_`030000003ookl0oono00h0oono00<000000?oo_`3ookl0?P3ookl00`000000oono0?oo_`2/0?oo
_`40oooo002^0?oo_`030000003ookl0oono00h0oono00<000000?oo_`3ookl0?P3ookl00`000000
oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono00l0oono00<000000?oo_`3ookl0
?@3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono00l0oono00<0
00000?oo_`3ookl0?@3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0
oono0100oono00<000000?oo_`3ookl0?03ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo
_`030000003ookl0oono0100oono00<000000?oo_`3ookl0?03ookl00`000000oono0?oo_`2/0?oo
_`40oooo002^0?oo_`030000003ookl0oono0140oono00<000000?oo_`3ookl0jP3ookl10?ooo`00
[P3ookl00`000000oono0?oo_`0A0?oo_`030000003ookl0oono0>X0oono0@3oool00:h0oono00<0
00000?oo_`3ookl04P3ookl00`000000oono0?oo_`3Y0?oo_`40oooo002^0?oo_`030000003ookl0
oono0180oono00<000000?oo_`3ookl0j@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0C0?oo
_`030000003ookl0oono03T0oono00<000000?oo_`3ookl0[03ookl10?ooo`00[P3ookl00`000000
oono0?oo_`0C0?oo_`030000003ookl0oono03T0oono00<000000?oo_`3ookl0[03ookl10?ooo`00
[P3ookl00`000000oono0?oo_`0D0?oo_`030000003ookl0oono03P0oono00<000000?oo_`3ookl0
[03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0D0?oo_`030000003ookl0oono03P0oono00<0
00000?oo_`3ookl0[03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0E0?oo_`030000003ookl0
oono03L0oono00<000000?oo_`3ookl0[03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0E0?oo
_`030000003ookl0oono03L0oono00<000000?oo_`3ookl0[03ookl10?ooo`00[P3ookl00`000000
oono0?oo_`0F0?oo_`030000003ookl0oono03H0oono00<000000?oo_`3ookl0[03ookl10?ooo`00
[P3ookl00`000000oono0?oo_`0F0?oo_`030000003ookl0oono0>D0oono0@3oool00:h0oono00<0
00000?oo_`3ookl05`3ookl00`000000oono0?oo_`3T0?oo_`40oooo002^0?oo_`030000003ookl0
oono01L0oono00<000000?oo_`3ookl0i03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0H0?oo
_`030000003ookl0oono0><0oono0@3oool00:h0oono00<000000?oo_`3ookl0603ookl00`000000
oono0?oo_`0d0?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl0
6@3ookl00`000000oono0?oo_`0c0?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<0
00000?oo_`3ookl06@3ookl00`000000oono0?oo_`0c0?oo_`030000003ookl0oono0:`0oono0@3o
ool00:h0oono00<000000?oo_`3ookl06P3ookl00`000000oono0?oo_`0b0?oo_`030000003ookl0
oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl06P3ookl00`000000oono0?oo_`0b0?oo
_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl06`3ookl00`000000
oono0?oo_`0a0?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl0
6`3ookl00`000000oono0?oo_`3P0?oo_`40oooo002^0?oo_`030000003ookl0oono01`0oono00<0
00000?oo_`3ookl0g`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0L0?oo_`030000003ookl0
oono0=l0oono0@3oool00:h0oono00<000000?oo_`3ookl07@3ookl00`000000oono0?oo_`3N0?oo
_`40oooo002^0?oo_`030000003ookl0oono01d0oono00<000000?oo_`3ookl0;`3ookl00`000000
oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono01h0oono00<000000?oo_`3ookl0
;P3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono01h0oono00<0
00000?oo_`3ookl0;P3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0
oono01l0oono00<000000?oo_`3ookl0;@3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo
_`030000003ookl0oono01l0oono00<000000?oo_`3ookl0;@3ookl00`000000oono0?oo_`2/0?oo
_`40oooo002^0?oo_`030000003ookl0oono0200oono00<000000?oo_`3ookl0;03ookl00`000000
oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono0200oono00<000000?oo_`3ookl0
f`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0Q0?oo_`030000003ookl0oono0=X0oono0@3o
ool00:h0oono00<000000?oo_`3ookl08@3ookl200000=/0oono0@3oool00:h0oono00<000000?oo
_`3ookl07`3ookl400000=/0oono0@3oool00:h0oono00<000000?oo_`3ookl07@3ookl2000000<0
oono00<000000?oo_`3ookl0:P3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000
003ookl0oono01/0oono0P0000060?oo_`030000003ookl0oono02T0oono00<000000?oo_`3ookl0
[03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0I0?oo_`800000203ookl00`000000oono0?oo
_`0Y0?oo_`030000003ookl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl05P3ookl3
000000/0oono00<000000?oo_`3ookl09P3ookl00`3ooil0omBo0000000]0?oo_`030?nK003o0000
o`0000<0o`0000<0og:<0?oo_`3ookl0N03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0B0?oo
_`@000003P3ookl00`000000oono0?oo_`0V0?oo_`030?njE@3oVil0000002d0oono00<0oi/00?l0
003o00000`3o00000`3oLX`0oono0?oo_`1h0?oo_`40oooo002^0?oo_`030000003ookl0oono00d0
oono1@00000C0?oo_`030000003ookl0oono02@0oono00@0oonO0?l0003o07@0V`00<03ookl00`3o
e7@0o`000?mbS01k0?oo_`40oooo002^0?oo_`030000003ookl0oono00H0oono1`00000H0?oo_`03
0000003ookl0oono00H0oono00<0oon_0?mb003o00001@3o00000`3oLX`0oono0?oo_`0C0?oo_`04
0?njE@3o0000o`000=@000H0oono00L0okYE0?l0003o0000o`000?mbS03ookl0oi/000<0o`0000<0
oi^O0?oo_`3ookl03P3ookl00`3oe7@0o`000?oD_`0=0?oo_`030?nK003o0000omBo01@0oono00<0
omAd0?l0003oe;l02P3ookl00`3oe7@0o`000?l000050?l000030?nj[`3ookl0oono04h0oono0@3o
ool00:h0oono2@00000P0?oo_`030000003ookl0oono00D0oono00<0oon_0?mb003o00001@3o0000
1@3oLX`0oono0?oo_`3ookl0onZ<00H0o`0000<0o`1d0?oo_`3ookl01`3ookl01@3ooil0o`000?mb
E@3o0000okZ_00H0oono00L0okYE0?l0003o0000o`000?mbS03ookl0oi/000<0o`0000<0oi^O0?oo
_`3ookl03P3ookl00`3oe7@0o`000?oD_`0<0?oo_`040?oZS03o0000o`000?mbS1@0oono00<0omAd
0?l0003oe;l02P3ookl00`3oe7@0o`000?l000050?l000030?nj[`3ookl0oono04h0oono0@3oool0
0:h0oono00<000000?oo_`3ookl09P3ookl00`000000oono0?oo_`080?oo_`030?nK003o05D0onZo
00H0oono00<0onZ<0?l0003o0000103o00000`3o07@0oono0?oo_`070?oo_`050?njE@3o0000omBo
0?nK003oLX`01`3ookl02@3ooil0o`000?l0003oLX`0oon_0?mb003o0000o`1E0?oZ_`0A0?oo_`03
0?oDM03o0000omBo00`0oono00D0oi/00?l0003o0000o`000?oD_`0C0?oo_`030?oDM03o0000omBo
00/0oono00P0omAd0?l0003o0000omBo0?oo_`3oe7@0o`000?nj[e00oono0@3oool00:h0oono00<0
00000?oo_`3ookl09`3ookl00`000000oono0?oo_`070?oo_`030?nK003o05D0onZo01H0oono00L0
oonO0?l0003oLX`0oono0?njE@3o05D0onZo00P0oono00D0oi/00?l0003o0000o`000?mbS00@0?oo
_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3ookl01`3ookl01P3oe7@0o`000?mbS03ojX`0
o`000?l0M100oono00<0onZ<0?l0003o0000103o00000`3o07@0oono0?oo_`080?oo_`040?oDM03o
0000o`000?oD_e<0oono0@3oool00:h0oono00<000000?oo_`3ookl09`3ookl00`000000oono0?oo
_`070?oo_`030?nK003o0000okZ_00H0oono00<0onZ<0?l0003o0000103o00000`3o07@0oono0?oo
_`060?oo_`070?njE@3o0000omBo0?oo_`3ojX`0o`000?nj[`080?oo_`050?njE@3o0000o`000?l0
003o^Zl0403ookl00`3ojX`0o`000?l000040?l000030?l0M03ookl0oono00H0oono00P0oon_0?mb
003o05D0onZo0?oo_`3o^UD0o`000?nj[`l0oono00<0onZ<0?l0003o0000103o00000`3o07@0oono
0?oo_`090?oo_`040?oDM03o0000o`000?oD_e80oono0@3oool00:h0oono00<000000?oo_`3ookl0
:03ookl00`000000oono0?oo_`060?oo_`040?nK003o0000o`000?l0M0D0oono00<0onZ<0?l0003o
0000103o00000`3o07@0oono0?oo_`050?oo_`030?ooW`3o0000og:<0080oono00<0oon_0;X0003o
LX`01P3ookl01@3oojl0og800?l0003o05D0onZO0080o`0000@0og:<0?oo_`3ookl0omAd1@3o0000
0`3oVil0oono0?oo_`070?oo_`030?oDM03o0000omBo00X0oono00<0omAd0?l0003oVil00P3ookl0
0`3ooil0o`000?l0M0020?oo_`030?oDM03o0000o`0000<0o`0000<0oi^O0?oo_`3ookl01`3ookl0
0`3oe7@0o`000?oD_`0:0?oo_`050?oZS03o0000okZ_0?oo_`3oe7@00P3o00000`3oe;l0oono0?oD
M0050?l000030?nKW`3ookl0oono04L0oono0@3oool00:h0oono00<000000?oo_`3ookl0:03ookl0
0`000000oono0?oo_`040?oo_`050?njE@3o0000o`000?l0E@3oe8`0103o00000`3o^Zl0oono0?oo
_`0>0?oo_`030?njE@3o0000omBo00<0oono00<0LP000?l0M03ookl0103ookl01`3ojX`0o`000?l0
003o0000og:<0?oo_`3oV`000P3o00001P3o05D0onZo0?oo_`3o^UD0o`000?oD_``0oono00<0omAd
0?l0003oe;l02@3ookl01`3o^UD0o`000?l0003o0000oi^O0?oo[`3oLP000`3o00001@3oe;l0oono
0?njE@3o0000omBo00`0oono00<0omAd0?l0003oe;l02P3ookl00`3ojX`0o`000?l000050?l00005
0?oD_`3ookl0okYE0?l0003oe;l0C03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0Y0?oo_`03
0000003ookl0oono00<0oono00H0okYE0?l0003o0000o`1E0?oZ_`3ooil20?l000030?mbS03ookl0
oono00/0oono00H0oi/00?l0003oVil0oonO0?l0003oLX`40?oo_`030000003o0000omBo00@0oono
00L0onZ<0?l0003o0000o`000?mbS03ookl0oi/00080o`0000L0o`1E0?oZ_`3ookl0oono0?ooW`3o
0000oi^O00/0oono00<0omAd0?l0003oe;l02@3ookl01`3o^UD0o`000?l0003o0000oi^O0?oo[`3o
LP000`3o00001P3oe;l0oono0?oo_`3ooil0o`000?nKW`/0oono00<0omAd0?l0003oe;l02P3ookl0
0`3ojX`0o`000?l000050?l000060?oD_`3ookl0oono0?ooW`3o0000oi^OB`3ookl10?ooo`00[P3o
okl00`000000oono0?oo_`0Y0?oo_`030000003ookl0oono01T0oono00<0oon_0?mb003o00000P3o
00000`3oe;l0oono0?oo_`020?oo_`030000003o0000oi^O0180oono00<0oon_0?mb003oLX`0903o
okl00`3oojl0og800?mbS00S0?oo_`030?oo[`3oLP00og:<04X0oono0@3oool00:h0oono00<00000
0?oo_`3ookl0:P3ookl00`000000oono0?oo_`0K0?oo_`030?njE@3oLX`0oono00@0oono00<00000
0?nK003o07@04`3ookl00`3oojl0og800?nKW`0T0?oo_`030?oo[`3oLP00oi^O02<0oono00<0oon_
0?mb003oVil0B@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0Z0?oo_`030000003ookl0oono
0280oono00@000000?oDM03o0000omBo3P3ookl00`3ooil0o`000?oD_`020?oo_`030?njE@3oLX`0
oono01l0oono00<0oonO0?l0003oe;l00P3ookl00`3o^UD0og:<0?oo_`0N0?oo_`030?ooW`3o0000
omBo0080oono00<0okYE0?mbS03ookl0B03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0[0?oo
_`030000003ookl0oono0280oono00<0onZ<0?l0003o^Zl03P3ookl01`3oojl0og800?nKW`3ookl0
oonO0?l0003o^Zl0803ookl01`3oojl0og800?nKW`3ookl0oonO0?l0003o^Zl07`3ookl01`3oojl0
og800?nKW`3ookl0oonO0?l0003o^Zl0B@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0[0?oo
_`030000003ookl0oono0280oono00<0oon_0?mb003oLX`03`3ookl01@3oojl0og800?l0003o0000
oi^O0280oono00D0oon_0?mb003o0000o`000?nKW`0Q0?oo_`050?oo[`3oLP00o`000?l0003oVil0
BP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0/0?oo_`030000003ookl0oono0280oono00<0
okYE0?l0E@3oj[l0ZP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0/0?oo_`030000003ookl0
oono0280oono00<0onZ<0?l0003o^Zl0ZP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0]0?oo
_`030000003ookl0oono01l0oono00D000000?oo_`3ooil0o`000?mbS02Z0?oo_`40oooo002^0?oo
_`030000003ookl0oono02d0oono00<000000?oo_`3ookl07`3ookl010000000oono0?oo_`3oV`1V
0?l000030?l0M03ookl0oono0480oono0@3oool00:h0oono00<000000?oo_`3ookl03@3ookl01@3o
^UD0o`000?l0003o0000o`1d01`0oono00<000000?oo_`3ookl07P3ookl010000000oono0?oo_`3o
e7AV0?l000030?l0M03ookl0oono0480oono0@3oool00:h0oono00<000000?oo_`3ookl0303ookl0
0`3oV`00o`000?l000040?l000030?oD_`3ookl0oono01P0oono00<000000?oo_`3ookl07P3ookl0
0`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono00/0oono00<0onZ<0?l0
003oLX`00`3ookl0103ojX`0o`000?l0003oe;lJ0?oo_`030000003ookl0oono01d0oono00<00000
0?oo_`3ookl0[03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0;0?oo_`030?oDM03o0000omBo
00@0oono00<0oon_0?mb003oLX`06P3ookl00`000000oono0?oo_`0M0?oo_`030000003ookl0oono
0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl02`3ookl00`3oe7@0o`000?l000060?l00003
0?l0E@3oj[l0oono01T0oono00<000000?oo_`3ookl0b`3ookl10?ooo`00[P3ookl00`000000oono
0?oo_`0;0?oo_`030?oZS03o0000o`0000L0o`0000<0omBo0?oo_`3ookl0603ookl00`000000oono
0?oo_`3;0?oo_`40oooo002^0?oo_`030000003ookl0oono00/0oono00<0oon_0?mb003o07@01@3o
okl00`3oe7@0o`000?nj[`0K0?oo_`030000003ookl0oono0<X0oono0@3oool00:h0oono00<00000
0?oo_`3ookl0303ookl0103ojX`0o`000?l0E@3oj[l20?oo_`040?oo[`3oLP00o`1E0?oZ_a/0oono
00<000000?oo_`3ookl0bP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0=0?oo_`030?oDM03o
0000o`0000@0o`0000<0oi^O0?oo_`3ookl06`3ookl00`000000oono0?oo_`0J0?oo_`030000003o
okl0oono0:`0oono0@3oool00:h0oono00<000000?oo_`3ookl03P3ookl00`3oojl0og800?l00002
0?l000030?nKW`3ookl0oono01`0oono00<000000?oo_`3ookl06P3ookl00`000000oono0?oo_`2/
0?oo_`40oooo002^0?oo_`030000003ookl0oono03<0oono00<000000?oo_`3ookl06@3ookl00`00
0000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono03<0oono00<000000?oo_`3o
okl06@3ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003ookl0oono03@0oono
00<000000?oo_`3ookl0603ookl00`000000oono0?oo_`2/0?oo_`40oooo002^0?oo_`030000003o
okl0oono03@0oono00<000000?oo_`3ookl0603ookl00`000000oono0?oo_`2/0?oo_`40oooo002^
0?oo_`030000003ookl0oono03D0oono00<000000?oo_`3ookl05`3ookl00`000000oono0?oo_`2/
0?oo_`40oooo002^0?oo_`030000003ookl0oono03D0oono00<000000?oo_`3ookl0D`3ookl01@3o
e7@000000000000005D0^^Zo06h0oono0@3oool00:h0oono00<000000?oo_`3ookl0=P3ookl00`00
0000oono0?oo_`1A0?oo_`070?oZS01b0000VmBo0?oo_`3oe7@0000009_D_`1]0?oo_`40oooo002^
0?oo_`030000003ookl0oono03H0oono00<000000?oo_`3ookl0B03ookl00`3ooil0V`0000000004
0000000509_D_`3ookl0j[YE001bS03Zokl00P3ookl00`3Z^UD0001d0=Co_`1/0?oo_`40oooo002^
0?oo_`030000003ookl0oono03L0oono00<000000?oo_`3ookl0AP3ookl00`3Z^UD0000000000005
000000040000E@2jj[l0j[YE002KW`<0oono00<0oonO09/0002Ke;l0K03ookl10?ooo`00[P3ookl0
0`000000oono0?oo_`0g0?oo_`030000003ookl0oono01D0oono00<000000?oo_`3ookl0;@3ookl0
103ojX`0LP000000M03Dokl70?oo_`030?oDM0000000000000@0000000<0L[Z_0?oo_`3ookl0JP3o
okl10?ooo`00[P3ookl00`000000oono0?oo_`0h0?oo_`030000003ookl0oono01@0oono00<00000
0?oo_`3ookl0;@3ookl00`3oe7@0000000000006000000050000E@2jj[l0oonO09/0E@2jj[l00`3o
okl00`3DV`00L[Z_0?oo_`1[0?oo_`40oooo002^0?oo_`030000003ookl0oono03P0oono00<00000
0?oo_`3ookl0503ookl00`000000oono0?oo_`0]0?oo_`030?oDM0000000000000H0000000X0001d
0=Co_`3ookl0omAd0000E@2jj[l0oono0?oZS01b05D0^^ZoK03ookl10?ooo`00[P3ookl00`000000
oono0?oo_`0i0?oo_`030000003ookl0oono01<0oono00<000000?oo_`3ookl0;@3ookl0103ojX`0
LP000000E@2jj[l30?oo_`030?oDM000000009^O00<0oono00D0onZ<078000000000000009_D_`1]
0?oo_`40oooo002^0?oo_`030000003ookl0oono03T0oono00<000000?oo_`3ookl04`3ookl00`00
0000oono0?oo_`0^0?oo_`030?oDM0000000000000@0000000<0001d0=Co_`3ookl0M03ookl10?oo
o`00[P3ookl00`000000oono0?oo_`0j0?oo_`030000003ookl0oono0180oono00<000000?oo_`3o
okl0;`3ookl00`3ooil0V`000000000200000003002KW`3ookl0oono07D0oono0@3oool00:h0oono
00<000000?oo_`3ookl0>P3ookl00`000000oono0?oo_`310?oo_`40oooo002^0?oo_`030000003o
okl0oono03/0oono00<000000?oo_`3ookl0`03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0k
0?oo_`030000003ookl0oono0<00oono0@3oool00:h0oono00<000000?oo_`3ookl0?03ookl00`00
0000oono0?oo_`2o0?oo_`40oooo002^0?oo_`030000003ookl0oono03`0oono00<000000?oo_`3o
okl0403ookl00`000000oono0?oo_`0]0?oo_`80o`00O@3ookl10?ooo`00[P3ookl00`000000oono
0?oo_`0m0?oo_`030000003ookl0oono00l0oono00<000000?oo_`3ookl0:`3ookl30?l007h0oono
0@3oool00:h0oono00<000000?oo_`3ookl0?@3ookl00`000000oono0?oo_`0?0?oo_`030000003o
okl0oono02T0oono103o001o0?oo_`40oooo002^0?oo_`030000003ookl0oono03h0oono00<00000
0?oo_`3ookl03P3ookl00`000000oono0?oo_`0W0?oo_`H0o`00O`3ookl10?ooo`00[P3ookl00`00
0000oono0?oo_`0n0?oo_`030000003ookl0oono00h0oono00<000000?oo_`3ookl0903ookl80?l0
0800oono0@3oool00:h0oono00<000000?oo_`3ookl0?`3ookl00`000000oono0?oo_`0=0?oo_`03
0000003ookl0oono0280oono2@3o00210?oo_`40oooo002^0?oo_`030000003ookl0oono03l0oono
00<000000?oo_`3ookl0<03ookl:0?l00880oono0@3oool00:h0oono00<000000?oo_`3ookl0@03o
okl00`000000oono0?oo_`0]0?oo_`/0o`00P`3ookl10?ooo`00[P3ookl00`000000oono0?oo_`10
0?oo_`030000003ookl0oono02h0oono2P3o00230?oo_`40oooo002^0?oo_`030000003ookl0oono
0440oono00<000000?oo_`3ookl0;@3ookl90?l008@0oono0@3oool00:h0oono00<000000?oo_`3o
okl0@@3ookl00`000000oono0?oo_`0;0?oo_`030000003ookl0oono0200oono1`3o00250?oo_`40
oooo002^0?oo_`030000003ookl0oono0480oono00<000000?oo_`3ookl02P3ookl00`000000oono
0?oo_`0O0?oo_`L0o`00QP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`120?oo_`030000003o
okl0oono00X0oono00<000000?oo_`3ookl07P3ookl0103o0000oono0?oo_`3ookl40?l008H0oono
0@3oool00:h0oono00<000000?oo_`3ookl0@`3ookl00`000000oono0?oo_`090?oo_`030000003o
okl0oono01d0oono00<0o`000?oo_`3ookl00P3ookl30?l008L0oono0@3oool00:h0oono00<00000
0?oo_`3ookl0@`3ookl00`000000oono0?oo_`090?oo_`030000003ookl0oono01/0oono0P3o0006
0?oo_`030?l0003ookl0oono08H0oono0@3oool00:h0oono00<000000?oo_`3ookl0A03ookl00`00
0000oono0?oo_`080?oo_`030000003ookl0oono01X0oono00<0o`000?oo_`3ookl0S`3ookl10?oo
o`00[P3ookl00`000000oono0?oo_`140?oo_`030000003ookl0oono00P0oono00<000000?oo_`3o
okl06@3ookl00`3o0000oono0?oo_`2@0?oo_`40oooo002^0?oo_`030000003ookl0oono04D0oono
00<000000?oo_`3ookl08@3ookl20?l009<0oono0@3oool00:h0oono00<000000?oo_`3ookl0A@3o
okl00`000000oono0?oo_`0P0?oo_`030?l0003ookl0oono09<0oono0@3oool00:h0oono00<00000
0?oo_`3ookl0AP3ookl00`000000oono0?oo_`0N0?oo_`030?l0003ookl0oono09@0oono0@3oool0
0:h0oono00<000000?oo_`3ookl0AP3ookl00`000000oono0?oo_`0L0?oo_`80o`00U`3ookl10?oo
o`00[P3ookl00`000000oono0?oo_`170?oo_`030000003ookl0oono00D0oono00<000000?oo_`3o
okl04P3ookl00`3o0000oono0?oo_`2G0?oo_`40oooo002^0?oo_`030000003ookl0oono04L0oono
00<000000?oo_`3ookl01@3ookl00`000000oono0?oo_`0A0?oo_`030?l0003ookl0oono09P0oono
0@3oool00:h0oono00<000000?oo_`3ookl0B03ookl00`000000oono0?oo_`040?oo_`030000003o
okl0oono00l0oono0P3o002K0?oo_`40oooo002^0?oo_`030000003ookl0oono04P0oono00<00000
0?oo_`3ookl0103ookl00`000000oono0?oo_`0>0?oo_`030?l0003ookl0oono09/0oono0@3oool0
0:h0oono00<000000?oo_`3ookl0B@3ookl00`000000oono0?oo_`030?oo_`030000003ookl0oono
00d0oono00<0o`000?oo_`3ookl0W03ookl10?ooo`00[P3ookl00`000000oono0?oo_`190?oo_`03
0000003ookl0oono00<0oono00<000000?oo_`3ookl02`3ookl20?l009l0oono0@3oool00:h0oono
00<000000?oo_`3ookl0BP3ookl00`000000oono0?oo_`0?0?oo_`030?l0003ookl0oono09l0oono
0@3oool00:h0oono00<000000?oo_`3ookl0BP3ookl00`000000oono0?oo_`0>0?oo_`030?l0003o
okl0oono0:00oono0@3oool00:h0oono00<000000?oo_`3ookl0B`3ookl00`000000oono0?oo_`0;
0?oo_`80o`001@3ookl00`3ool/0^W;o0000o`040000o`0309_D_`3ookl0oono09@0oono0@3oool0
0:h0oono00<000000?oo_`3ookl0B`3ookl00`000000oono0?oo_`0:0?oo_`030?l0003ookl0oono
00D0oono00<0ooo;0;Ybo`000?l010000?l00`2Ke;l0oono0?oo_`2D0?oo_`40oooo002^0?oo_`03
0000003ookl0oono04`0oono00@000000?oo_`3ookl000001`3ookl00`3o0000oono0?oo_`080?oo
_`030?oDk0000?l0L[[;09T0oono0@3oool00:h0oono00<000000?oo_`3ookl0C03ookl010000000
oono0?oo_`0000050?oo_`80o`002`3ookl00`3oe>`0003o07:jb`2I0?oo_`40oooo002^0?oo_`03
0000003ookl0oono04d0oono00<000000?oo_`000000103ookl00`3o0000oono0?oo_`0;0?oo_`03
0?oDk0000?l0003o00<0003o00<0VmBo0?oo_`3ookl0T`3ookl10?ooo`00[P3ookl00`000000oono
0?oo_`1=0?oo_`0300000000I_l006Ko00<0oono00<0o`000?oo_`3ookl0303ookl00`3oe>`0003o
0000o`040000o`03002Ke`3ookl0oono0980oono0@3oool00:h0oono00<000000?oo_`3ookl0C03o
okl5001Vo`80o`003`3ookl00`3oe>`0003o07:jb`020?oo_`040?ooe`2K0?l0003o09_D_i<0oono
0@3oool00:h0oono00<000000?oo_`3ookl0C03ookl4001Vo`030?l00000I_l0oono00l0oono00<0
omC/0000o`1b^//00`3ookl00`3oe>`0003o07:jb`2C0?oo_`40oooo002^0?oo_`030000003ookl0
oono04/0oono1000I_l20?l0008006Ko3`3ookl00`3oe>`0003o07:jb`020?oo_`040?oob`2jL_l0
003o09_D_i<0oono0@3oool00:h0oono00<000000?oo_`3ookl0B`3ookl4001Vo`040?l00000I_l0
o`000?l000d0oono00<0ooo;0;Ybo`000?l01P000?l00`00L^80j_no0?oo_`2B0?oo_`40oooo002^
0?oo_`030000003ookl0oono04`0oono1000I_l00`3o000006Ko0?oo_`030?l000X0oono00<0ooo;
0;Ybo`000?l01@000?l00`00VmL0oono0?oo_`2C0?oo_`40oooo002^0?oo_`030000003ookl0oono
04`0oono1000I_l00`3o000006Ko0?oo_`030?oo_`80o`00YP3ookl10?ooo`00[P3ookl00`000000
oono0?oo_`1:0?oo_`8000000P3ookl2001Vo`030?oo_`3o0000oono00D0oono0`3o002S0?oo_`40
oooo002^0?oo_`030000003ookl0oono04P0oono0P0000070?oo_`030?l0003ookl0oono00L0oono
0`3o002P0?oo_`40oooo002^0?oo_`030000003ookl0oono04L0oono00<000000?oo_`3ookl0203o
okl00`3o0000oono0?oo_`090?oo_`80o`00WP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`1B
0?oo_`030?l0003ookl0oono00/0oono0`3o002K0?oo_`40oooo002^0?oo_`030000003ookl0oono
05<0oono00<0o`000?oo_`3ookl03@3ookl20?l009T0oono0@3oool00:h0oono00<000000?oo_`3o
okl0@`3ookl00`000000oono0?oo_`0=0?oo_`030?l0003ookl0oono00l0oono0`3o002F0?oo_`40
oooo002^0?oo_`030000003ookl0oono0480oono00<000000?oo_`3ookl03`3ookl00`3o0000oono
0?oo_`0A0?oo_`80o`00U03ookl10?ooo`00[P3ookl00`000000oono0?oo_`100?oo_`8000004P3o
okl00`3o0000oono0?oo_`0C0?oo_`<0o`00T@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0o
0?oo_`030000003ookl0oono01<0oono00<0o`000?oo_`3ookl05@3ookl20?l008l0oono0@3oool0
0:h0oono00<000000?oo_`3ookl0E@3ookl00`3o0000oono0?oo_`0G0?oo_`<0o`00S03ookl10?oo
o`00[P3ookl00`000000oono0?oo_`1F0?oo_`030?l0003ookl0oono01T0oono0`3o00290?oo_`40
oooo002^0?oo_`030000003ookl0oono03/0oono00<000000?oo_`3ookl0603ookl00`3o0000oono
0?oo_`0L0?oo_`80o`002P3ookl00`3o0000oono0?oo_`1j0?oo_`40oooo002^0?oo_`030000003o
okl0oono03X0oono00<000000?oo_`3ookl06P3ookl00`3o0000oono0?oo_`0M0?oo_`<0o`001P3o
okl40?l007X0oono0@3oool00:h0oono00<000000?oo_`3ookl0>03ookl2000001d0oono00<0o`00
0?oo_`3ookl0803ookl20?l000@0oono1@3o001i0?oo_`40oooo002^0?oo_`030000003ookl0oono
03L0oono00<000000?oo_`3ookl07P3ookl00`3o0000oono0?oo_`0Q0?oo_`X0o`00N03ookl10?oo
o`00[P3ookl00`000000oono0?oo_`1H0?oo_`030?l0003ookl0oono02@0oono2@3o001f0?oo_`40
oooo002^0?oo_`030000003ookl0oono05T0oono00<0o`000?oo_`3ookl08P3ookl;0?l007D0oono
0@3oool00:h0oono00<000000?oo_`3ookl0<`3ookl00`000000oono0?oo_`0S0?oo_`030?l0003o
okl0oono0280oono3@3o001c0?oo_`40oooo002^0?oo_`030000003ookl0oono0380oono00<00000
0?oo_`3ookl09@3ookl00`3o0000oono0?oo_`0P0?oo_`l0o`00LP3ookl10?ooo`00[P3ookl00`00
0000oono0?oo_`0a0?oo_`030000003ookl0oono02H0oono00<0o`000?oo_`3ookl0803ookl@0?l0
0740oono0@3oool00:h0oono00<000000?oo_`3ookl0<03ookl00`000000oono0?oo_`0X0?oo_`03
0?l0003ookl0oono02@0oono3@3o001_0?oo_`40oooo002^0?oo_`030000003ookl0oono02l0oono
00<000000?oo_`3ookl0:@3ookl00`3o0000oono0?oo_`0]0?oo_`D0o`00403ookl00`3Z^UD009^O
0?oo_`1K0?oo_`40oooo002^0?oo_`030000003ookl0oono05`0oono00<0o`000?oo_`3ookl0@@3o
okl00`3ojX`0LW:<0>[o_`1K0?oo_`40oooo002^0?oo_`030000003ookl0oono05`0oono00<0o`00
0?oo_`3ookl0@03ookl01@3oe7@0000000000000000009^O05X0oono0@3oool00:h0oono00<00000
0?oo_`3ookl0:P3ookl00`000000oono0?oo_`0`0?oo_`030?l0003ookl0oono03h0oono00P0onZ<
0780002Ke:l0^W8009_D_`3DV`0007:<0>[o_eP0oono0@3oool00:h0oono00<000000?oo_`3ookl0
:@3ookl00`000000oono0?oo_`0a0?oo_`030?l0003ookl0oono03D0oono00<0oonO09/000000000
100000002P2Ke;l0oono0>ZjE@00LX`0j_no0>ZjE@1b^Zl0oon_0;Yb002Ke;mH0?oo_`40oooo002^
0?oo_`030000003ookl0oono02L0oono0P00000e0?oo_`030?l0003ookl0oono03<0oono00<0j[YE
0000000000001@0000002P0005D0^^Zo0?oDM000LX`0j_no0?oDM000Vil0oon_0;Yb001b^ZmH0?oo
_`40oooo002^0?oo_`030000003ookl0oono02H0oono00<000000?oo_`3ookl0=@3ookl00`3o0000
oono0?oo_`0b0?oo_`040?oZS01b0000001d0=Co_`L0oono00P0oon_0;Yb0000Vil0onZ<0780M03D
jX`0LP0009_D_eP0oono0@3oool00:h0oono00<000000?oo_`3ookl0G`3ookl00`3o0000oono0?oo
_`0a0?oo_`030?oDM0000000000000H0000000D0001E0;[Z_`3ookl0oono0=BK00030000000307:j
[`3ookl0oono05L0oono0@3oool00:h0oono00<000000?oo_`3ookl0G`3ookl00`3o0000oono0?oo
_`0a0?oo_`030?oDM0000000000000H0000000<0001d0=Co_`3ookl00`3ookl00`3DV`00L[Z_0?oo
_`1I0?oo_`40oooo002^0?oo_`030000003ookl0oono0280oono00<000000?oo_`3ookl0>`3ookl0
0`3o0000oono0?oo_`0`0?oo_`040?oZS01b0000001E0;[Z_`<0oono00<0omAd00000000Vil01@3o
okl00`3oe7@009^O0?oo_`1I0?oo_`40oooo002^0?oo_`030000003ookl0oono0240oono00<00000
0?oo_`3ookl0?03ookl00`3o0000oono0?oo_`0a0?oo_`030?oDM0000000000000@0000000<0001d
0=Co_`3ookl0H03ookl10?ooo`00[P3ookl00`000000oono0?oo_`0O0?oo_`800000@03ookl00`3o
0000oono0?oo_`0a0?oo_`030?ooW`2K000000000080000000<009^O0?oo_`3ookl0H@3ookl10?oo
o`00[P3ookl00`000000oono0?oo_`0N0?oo_`030000003ookl0oono0400oono00<0o`000?oo_`3o
okl0VP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`1R0?oo_`030?l0003ookl0oono09T0oono
0@3oool00:h0oono00<000000?oo_`3ookl0HP3ookl00`3o0000oono0?oo_`2I0?oo_`40oooo002^
0?oo_`030000003ookl0oono01X0oono00<000000?oo_`3ookl0AP3ookl00`3o0000oono0?oo_`2H
0?oo_`40oooo002^0?oo_`030000003ookl0oono01T0oono00<000000?oo_`3ookl0A`3ookl00`3o
0000oono0?oo_`2H0?oo_`40oooo002^0?oo_`030000003ookl0oono01L0oono0P00001;0?oo_`03
0?l0003ookl0oono09L0oono0@3oool00:h0oono00<000000?oo_`3ookl05P3ookl00`000000oono
0?oo_`1;0?oo_`030?l0003ookl0oono09L0oono0@3oool00:h0oono00<000000?oo_`3ookl0I@3o
okl00`3o0000oono0?oo_`2F0?oo_`40oooo002^0?oo_`030000003ookl0oono06D0oono00<0o`00
0?oo_`3ookl0UP3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0B0?oo_`030000003ookl0oono
0540oono00<0o`000?oo_`3ookl0U@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`0@0?oo_`80
0000E03ookl00`3o0000oono0?oo_`2E0?oo_`40oooo002^0?oo_`030000003ookl0oono00h0oono
0P00001G0?oo_`030?l0003ookl0oono09@0oono0@3oool00:h0oono00<000000?oo_`3ookl03@3o
okl00`000000oono0?oo_`1G0?oo_`040?l0003ookl0oono0?oo_`80o`00T@3ookl10?ooo`00[P3o
okl00`000000oono0?oo_`1X0?oo_`D0o`00T@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`1V
0?oo_`L0o`00T@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`090?oo_`030000003ookl0oono
05P0oono2P3o002@0?oo_`40oooo002^0?oo_`030000003ookl0oono00P0oono00<000000?oo_`3o
okl0FP3ookl90?l00900oono0@3oool00:h0oono00<000000?oo_`3ookl01`3ookl00`000000oono
0?oo_`1L0?oo_`P0o`00T03ookl10?ooo`00[P3ookl00`000000oono0?oo_`060?oo_`030000003o
okl0oono05h0oono1`3o002@0?oo_`40oooo002^0?oo_`030000003ookl0oono00D0oono00<00000
0?oo_`3ookl0G`3ookl80?l008l0oono0@3oool00:h0oono00<000000?oo_`3ookl0J03ookl70?l0
08l0oono0@3oool00:h0oono0P3o001Z0?oo_`H0o`00S`3ookl10?ooo`00[03ookl60?l000030000
003ookl0oono06H0oono1@3o002?0?oo_`40oooo002/0?oo_`H0o`00JP3ookl50?l008h0oono0@3o
ool00:/0oono203o001Z0?oo_`@0o`00SP3ookl10?ooo`00Z`3ookl?0?l000030?nj[`3ookl0oono
00X0oono00<0oon_0?mb003o00001@3o00000`3oLX`0oono0?oo_`020?oo_`030?oo[`3oLP00o`00
00<0o`0000<0o`1d0?oo_`3ookl00P3ookl00`3oojl0og800?l000020?l000030?mbS03ookl0oono
0080oono00<0okYE0?l0003o00000`3o00000`3o05D0onZo0?oo_`030?oo_`050?njE@3o0000o`00
0?l0003o07@0903ookl30?l008h0oono0@3oool00:`0oono1P3o00000`3oe7@0o`000?l000050?l0
00040?nj[`3ookl0oono0?oZS0H0o`0000D0o`1d0?oo_`3ookl0oon_0?mb00060?l000050?mbS03o
okl0oono0?oo_`3ojX`0203o00000`3oe;l0oono0?oZS0060?l000050?l0E@3oj[l0oono0?oo_`3o
V`001`3o0000103o^Zl0oono0?oo_`3oV`060?l000030?oD_`3ookl0oono0200oono0`3o002>0?oo
_`40oooo002/0?oo_`H0o`0000T0oono0?oDM03o0000o`000?oD_`3ookl0omAd0?l0003o^Zl00P3o
okl00`3ojX`0o`000?l000040?l000030?l0M03ookl0oono00<0oono00<0oi/00?l0E@3oj[l01P3o
okl00`3oV`00o`000?nKW`040?oo_`070?oDM03o0000omBo0?oo[`3oLP00o`000?nKW`030?oo_`03
0?nK003o0000og:<0080oono00<0okYE0?l0E@3oj[l00`3ookl01`3ojX`0o`000?nKW`3ookl0onZ<
0?l0003oLX`00`3ookl0103ojX`0o`000?l0003oe;lR0?oo_`<0o`00S@3ookl10?ooo`00[P3ookl2
0?l000@0oono00@0omAd0?l0003o0000omBo4P3ookl00`3oV`00o`1E0?oZ_`050?oo_`030?ooW`3o
0000og:<00P0oono00<0onZ<0?l0003oVil01@3ookl00`3oV`00o`1E0?oZ_`040?oo_`0:0?oZS03o
0000o`000?l0003o05D0onZo0?oo_`3oe7@0o`000?oD_`@0oono00<0oon_0?mb003oLX`08`3ookl2
0?l008d0oono0@3oool00:h0oono00<000000?oo_`3ookl0103ookl0103oe7@0o`000?l0003oe;l4
0?oo_`030?oZS03o0000o`0000@0o`0000<0o`1d0?oo_`3ookl00`3ookl00`3oV`00o`000?nj[`05
0?oo_`030?ooW`3o0000o`1d00D0oono00H0oi/00?l0M03ookl0onZ<0?l0003oLX`40?oo_`070?oo
[`3oLP00o`1E0?oZ_`3ookl0oon_0?mb00040?l000050?nKW`3ookl0oono0?oo_`3oe7@0203o0000
0`3o05D0onZo0?oo_`0R0?oo_`030?l0003ookl0oono08/0oono0@3oool00:h0oono00T000000?oo
_`3ookl0oono0?oZS03o0000okZ_0?oo_`3oe7@00P3o00001@3oe;l0oono0?oo_`3ookl0onZ<00H0
o`0000<0o`1d0?oo_`3ookl00`3ookl0103oV`00o`000?l0003o07@50?oo_`030?nK003o0000og:<
00<0oono00P0oonO0?l0003o05D0onZo0?oo[`3oLP00o`000?nKW`<0oono00<0oi/00?l0003oLX`0
0P3ookl00`3oe7@0o`000?nj[`030?oo_`050?njE@3o05D0onZo0?oo_`3ojX`02@3o00000`3oe;l0
oono0?oo_`2_0?oo_`40oooo002^0?oo_`050000003ookl0oono0?oo_`3ojX`01`3o00000`3oe;l0
oono0?oo_`0;0?oo_`050?njE@3o0000o`000?l0E@3oe8`0103o00000`3o^Zl0oono0?ooW`070?l0
00040?l0E@3oj[l0oono0?oZS0H0o`0000D0o`1E0?oZ_`3ookl0oono0?ooW`070?l000050?oD_`3o
okl0oon_0?mb003o07@01@3ookl00`3oe7@0o`000?nj[`0Y0?oo_`050?oDM000000000000000001b
^Zl0P`3ookl10?ooo`00[P3ookl01@000000oono0?oo_`3ookl0onZ<00L0o`0000<0omBo0?oo_`3o
okl02`3ookl01P3o^UD0o`000?l0003o05D0onZo0?ooW`80o`0000<0og:<0?oo_`3ookl00P3ookl0
1`3oV`00o`000?l0003o0000og:<0?oDM03o07@0103ookl01@3oV`00o`000?l0003o0000oi^O00D0
oono00<0oonO0?l0003o00000`3o0000203o05D0onZo0?oo_`3ookl0onZ<0?l0003o05D0onZo0P3o
okl0103oojl0og800?l0E@3oj[lZ0?oo_`030=BK0000Vil0oono08@0oono0@3oool00:h0oono00<0
00000?oo_`3ookl0A03ookl00`3oe7@0o`000?l000040?l000030?nKW`3ookl0oono01h0oono00<0
oonO09/000000000100000001P2Ke;l0oono0?oo_`3ookl0e9/0002KWhD0oono0@3oool00:h0oono
00<000000?oo_`3ookl0A@3ookl00`3oojl0og800?l000020?l000030?nKW`3ookl0oono01h0oono
00<0j[YE0000000000001@0000001`0005D0^^Zo0?oo_`3ookl0e9/00000M03Dokl0Q03ookl10?oo
o`00[P3ookl00`000000oono0?oo_`1Z0?oo_`040?oZS01b0000001d0=Co_`T0oono00H0e9/00000
000007@0e?no0>ZjE@00Vin10?oo_`40oooo002^0?oo_`030000003ookl0oono06X0oono00<0omAd
0000000000001P0000002P0005D0^^Zo0?ooW`2K00000000002KW`3DV`0000000000E@2jj[n10?oo
_`40oooo002^0?oo_`030000003ookl0oono06X0oono00<0omAd0000000000001P0000000`0007@0
e?no0?oo_`280?oo_`40oooo002^0?oo_`030000003ookl0oono06X0oono00@0onZ<0780000005D0
^^Zo0`3ookl00`3oe7@00000002KW`2:0?oo_`40oooo002^0?oo_`030000003ookl0oono00D0oono
00<0e9/00000000000001@0000000`00LX`0j_no0?oo_`1K0?oo_`030?oDM0000000000000@00000
00<0001d0=Co_`3ookl0R@3ookl10?ooo`00[P3ookl00`000000oono0?oo_`050?oo_`030=BK0000
0000000000D0000000<007:<0>[o_`3ookl0G03ookl00`3ooil0V`000000000200000003002KW`3o
okl0oono08X0oono0@3oool00:h0oono00<000000?oo_`3ookl01@3ookl0103oe7@000000000M03D
okl20?oo_`040?ooW`2K000007:<0>[o_nl0oono0@3oool00:h0oono00<000000?oo_`3ookl01P3o
okl0203Z^UD00000001bS03Zokl0oono0?ooW`2K000009^Ol03ookl10?ooo`00[P3ookl00`000000
oono0?oo_`070?oo_`030=BK0000000009^O0?@0oono0@3oool00:h0oono00<000000?oo_`3ookl0
1`3ookl0103oojl0^W800000001b^Zoc0?oo_`40oooo002^0?oo_`030000003ookl0oono00P0oono
00@0oonO09/000000000VmBolP3ookl10?ooo`00]P3ookl0203oe7@0000007:j[`3ookl0onZ<0780
000005D0^^Zol@3ookl10?ooo`00]P3ookl00`3oe7@0000007:j[`020?oo_`040?oDM0000000001d
0=Co_o00oono0@3oool00;H0oono00<0omAd0000000000001@0000000`2Ke;l0oono0?oo_`3^0?oo
_`40oooo002f0?oo_`030?oDM0000000000000D0000000<0VmBo0?oo_`3ookl0kP3ookl10?ooo`00
o`3ookn`0?oo_`40oooo003o0?oo_k00oono0@3oool00?l0oono/03ookl10?ooo`00o`3ookn`0?oo
_`40oooo003o0?oo_k00oono0@3oool00?l0oono/03ookl10?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-4.25005, -4.25005, 0.0365433, \
0.0365433}}]
}, Open  ]],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". La notaci\[OAcute]n y el orden en que se escriben las coordenadas esf\
\[EAcute]ricas var\[IAcute]a de unos textos a otros. Las definiciones \
anteriores son las mismas que se usan en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " y eso nos permitir\[AAcute] aprovechar en lo que sigue los comandos del \
programa. En muchos textos los papeles de \[Phi] y \[Theta] est\[AAcute]n \
intercambiados con respecto a los nuestros. \nPor lo que se refiere al \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(] \(-\[Pi]\)\), \[Pi]]\)\ \)\)]],
  "elegido para medir en radianes el \[AAcute]ngulo \[Phi], podemos hacer las \
mismas observaciones que las hechas para las coordenadas polares. Con \
frecuencia dicho intervalo se sustituye por",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([0, 2 \( \[Pi][\)\)\)\)]],
  " lo que, dicho sea de paso, complica las f\[OAcute]rmulas del cambio de \
cartesianas a esf\[EAcute]ricas. Cuando en un libro se usen coordenadas esf\
\[EAcute]ricas debes comprobar c\[OAcute]mo se definen dichas coordenadas."
}], "Text"],

Cell["\<\
El siguiente comando carga el paquete para an\[AAcute]lisis vectorial.\
\>", "Text"],

Cell[BoxData[
    \(<< Calculus`VectorAnalysis`\)], "Input"],

Cell["Los siguientes comandos no precisan explicaci\[OAcute]n.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\ Spherical\)\)], "Input"],

Cell[BoxData[
    RowBox[{"\<\"Spherical represents the spherical coordinate system with \
default variables Rr, Ttheta, and Pphi. Spherical[r, theta, phi] represents \
the spherical coordinate system with variables r, theta, and phi.\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"Calculus`VectorAnalysis`",
        Active->True,
        ButtonStyle->"AddOnsLink"]}]], "Print",
  CellTags->"Info3349602765-8162306"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Coordinates[Spherical]\)], "Input"],

Cell[BoxData[
    \({Rr, Ttheta, Pphi}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoordinateRanges[Spherical]\)], "Input"],

Cell[BoxData[
    \({0 \[LessEqual] Rr < \[Infinity], 
      0 \[LessEqual] Ttheta \[LessEqual] \[Pi], \(-\[Pi]\) < 
        Pphi \[LessEqual] \[Pi]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(CoordinatesToCartesian[{r, \[Theta], \[Phi]}, Spherical]\)\( (*\ 
      paso\ de\ esf\[EAcute]ricas\ a\ cartesianas\ *) \)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \({r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
      r\ Cos[\[Theta]]}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(CoordinatesFromCartesian[{x, y, z}, Spherical]\)\( (*\ 
      paso\ de\ cartesianas\ a\ esf\[EAcute]ricas\ *) \)\)\)], "Input"],

Cell[BoxData[
    \({\@\(x\^2 + y\^2 + z\^2\), ArcCos[z\/\@\(x\^2 + y\^2 + z\^2\)], 
      ArcTan[x, y]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Cuando se utiliza el sistema de coordenadas esf\[EAcute]ricas los vectores \
se refieren a una base ortonormal ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            StyleBox[",",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            SubscriptBox[
              StyleBox["e",
                FontWeight->"Bold"], "\[Phi]"]}], "}"}], TraditionalForm]]],
  " que se ha representado en la figura anterior (trasladada al punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  "). En el lenguaje t\[IAcute]pico de los textos de f\[IAcute]sica se dice \
que el vector ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_r\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta ",
  StyleBox["r",
    FontSlant->"Italic"],
  " manteniendo \[Theta] y \[Phi] constantes, el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Theta]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Theta] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Phi] constantes y el vector  ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(e\_\[Phi]\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es un vector unitario en el sentido en que se mueve el punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " cuando aumenta \[Phi] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Theta] constantes. En t\[EAcute]rminos matem\[AAcute]ticos, quiz\
\[AAcute]s m\[AAcute]s precisos, observa que el vector de posici\[OAcute]n \
del punto ",
  StyleBox["P",
    FontSlant->"Italic"],
  " de cordenadas esf\[EAcute]ricas  ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \ \[Phi])\)\)]],
  " es  ",
  Cell[BoxData[
      \(TraditionalForm\`g(
          r, \[Theta], \[Phi]) = \((r\ cos\ \[Phi]\ sen\ \[Theta], \ 
          r\ sen\ \[Phi]\ sen\ \[Theta], r\ cos\ \[Theta])\)\)]],
  "; su variaci\[OAcute]n con respecto a ",
  StyleBox["r",
    FontSlant->"Italic"],
  " manteniendo \[Theta] y \[Phi] constantes es la derivada parcial respecto \
a ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", su variaci\[OAcute]n con respecto a \[Theta] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Phi] constantes es la derivada parcial respecto a \[Theta] y su \
variaci\[OAcute]n con respecto a \[Phi] manteniendo ",
  StyleBox["r",
    FontSlant->"Italic"],
  " y \[Theta] constantes es la derivada parcial respecto a \[Phi]. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[g]\), "\n", 
    \(g[r_, \[Theta]_, \[Phi]_] := {r\ Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Sin[\[Phi]]\ Sin[\[Theta]], r\ Cos[\[Theta]]}\), "\n", 
    \(u1 = D[g[r, \[Theta], \[Phi]], r]\), "\n", 
    \(u2 = D[g[r, \[Theta], \[Phi]], \[Theta]]\), "\n", 
    \(u3 = D[g[r, \[Theta], \[Phi]], \[Phi]]\)}], "Input"],

Cell[BoxData[
    \({Cos[\[Phi]]\ Sin[\[Theta]], Sin[\[Theta]]\ Sin[\[Phi]], 
      Cos[\[Theta]]}\)], "Output"],

Cell[BoxData[
    \({r\ Cos[\[Theta]]\ Cos[\[Phi]], 
      r\ Cos[\[Theta]]\ Sin[\[Phi]], \(-r\)\ Sin[\[Theta]]}\)], "Output"],

Cell[BoxData[
    \({\(-r\)\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Phi]]\ Sin[\[Theta]], 
      0}\)], "Output"]
}, Open  ]],

Cell["Observa que estos vectores son ortogonales", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({u1 . u2, u1 . u3, u2 . u3} // Simplify\)], "Input"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output"]
}, Open  ]],

Cell["\<\
Para obtener una base ortonormal a partir de ellos todo lo que tenemos que \
hacer es normalizarlos. Calculemos sus normas.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({norma[u1], norma[u2], norma[u3]} // Simplify\)], "Input"],

Cell[BoxData[
    \({1, r, r\ Sin[\[Theta]]}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Deducimos que los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Phi]\ sen\ \[Theta], sen\ \[Phi]\ sen\ \[Theta], 
              cos\ \[Theta])\)}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "=", 
            \((cos\ \[Phi]\ cos\ \[Theta], sen\ \[Phi]\ cos\ \[Theta], 
              \(-sen\)\ \[Theta])\)}], ",", " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "=", 
            \((\(-sen\)\ \[Phi]\ , \ cos\ \[Phi], 0)\)}]}], 
        TraditionalForm]]],
  " forman una base ortonormal. Es a dicha base a la que se refiere un vector \
cuando se usan coordenadas esf\[EAcute]ricas. Observa que los vectores de \
esta base dependen de la posici\[OAcute]n del punto, es decir, no se trata de \
una base fija. F\[IAcute]jate en que si ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((r, \[Theta], \[Phi])\)\ \)\)]],
  "son las coordenadas esf\[EAcute]ricas de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((x, y, z)\), "=", 
          RowBox[{"r", " ", 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". En general, la expresi\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " de un vector  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  " se obtiene por el m\[EAcute]todo usual calculando sus proyecciones \
ortogonales sobre los vectores de la base:"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(v = \[LeftAngleBracket]v | e\_r\[RightAngleBracket] e\_r + 
              \[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket] 
                e\_\[Theta] + 
              \[LeftAngleBracket]v | e\_\[Phi]\[RightAngleBracket] 
                e\_\[Phi]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "\t\t"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que si escribimos ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "=", 
          \((r\ sen\ \[Theta]\ cos\ \[Phi]\ , \ 
            r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta])\)}], 
        TraditionalForm]]],
  " entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[LeftAngleBracket]v | e\_r\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", "r"}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          
          StyleBox[
            \(\[LeftAngleBracket]v | e\_\[Theta]\[RightAngleBracket]\),
            FontWeight->"Bold"], "=", 
          RowBox[{
            
            StyleBox[
              \(\[LeftAngleBracket]v | e\_\[Phi]\[RightAngleBracket]\),
              FontWeight->"Bold"], "=", "0"}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  "A continuaci\[OAcute]n se definen los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " como funciones que son de \[Theta] y \[Phi]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(er[\[Theta]_, \[Phi]_] = u1/norma[u1] // Simplify\), "\n", 
    \(e\[Theta][\[Theta]_, \[Phi]_] = u2/norma[u2] // Simplify\), "\n", 
    \(e\[Phi][\[Theta]_, \[Phi]_] = u3/norma[u3] // Simplify\)}], "Input"],

Cell[BoxData[
    \({Cos[\[Phi]]\ Sin[\[Theta]], Sin[\[Theta]]\ Sin[\[Phi]], 
      Cos[\[Theta]]}\)], "Output"],

Cell[BoxData[
    \({Cos[\[Theta]]\ Cos[\[Phi]], 
      Cos[\[Theta]]\ Sin[\[Phi]], \(-Sin[\[Theta]]\)}\)], "Output"],

Cell[BoxData[
    \({\(-Sin[\[Phi]]\), Cos[\[Phi]], 0}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica muestra la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Theta], \[Phi]} = {\[Pi]/4, \[Pi]/4}\)]],
  ". Para visualizarla mejor dicha base se ha desplazado al punto de \
coordenadas esf\[EAcute]ricas ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \[Pi]/4, \[Pi]/4}\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(punto = 
        CoordinatesToCartesian[{1, \[Pi]/4, \[Pi]/4}, Spherical];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[punto], 
              vector3D[punto,  .5*er[\[Pi]/4, \[Pi]/4], Blue], 
              vector3D[punto,  .5*e\[Theta][\[Pi]/4, \[Pi]/4], Green], 
              vector3D[punto,  .7*e\[Phi][\[Pi]/4, \[Pi]/4], Red], 
              Text[\*"\"\<\!\(e\_r\)\>\"", 
                punto +  .55*er[\[Pi]/4, \[Pi]/4]], 
              Text[\*"\"\<\!\(e\_\[Theta]\)\>\"", 
                punto +  .6*
                    e\[Theta][\[Pi]/4, \[Pi]/
                        4]], \n\t\t\t\tText[\*"\"\<\!\(e\_\[Phi]\)\>\"", 
                punto +  .78*e\[Phi][\[Pi]/4, \[Pi]/4]]}, Axes -> True, 
            PlotRange -> All, Ticks -> None, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14, 
                FontWeight -> "\<Bold\>"}]];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.21928 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.11366 1.28917 5.62701e-017 1.28917 [
[ 0 0 0 0 ]
[ 1 1.21928 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08996 .22434 m
.6266 0 L
s
0 .88987 m
.44562 1.21928 L
s
.08996 .22434 m
0 .88987 L
s
.08996 .22434 m
0 .88987 L
s
0 .88987 m
.44562 1.21928 L
s
.44562 1.21928 m
.45772 .61568 L
s
.45772 .61568 m
.08996 .22434 L
s
.6266 0 m
.92836 .46097 L
s
.92836 .46097 m
1 1.09161 L
s
1 1.09161 m
.64836 .69094 L
s
.64836 .69094 m
.6266 0 L
s
.08996 .22434 m
0 .88987 L
s
0 .88987 m
.64836 .69094 L
s
.64836 .69094 m
.6266 0 L
s
.6266 0 m
.08996 .22434 L
s
.45772 .61568 m
.92836 .46097 L
s
.92836 .46097 m
1 1.09161 L
s
1 1.09161 m
.44562 1.21928 L
s
.44562 1.21928 m
.45772 .61568 L
s
0 0 m
1 0 L
1 1.21928 L
0 1.21928 L
closepath
clip
newpath
.5 Mabswid
.799 0 0 r
.47236 .88862 m .48899 .88504 L .46706 .94513 L closepath p F P
0 g
s
.967 0 0 r
.46523 .90245 m .47236 .88862 L .46706 .94513 L closepath p F P
0 g
s
0 0 0 r
.47191 .91848 m .46523 .90245 L .46706 .94513 L closepath p F P
0 g
s
.44 0 0 r
.50545 .8937 m .51221 .90959 L .46706 .94513 L closepath p F P
0 g
s
.624 0 0 r
.48899 .88504 m .50545 .8937 L .46706 .94513 L closepath p F P
0 g
s
.341 0 0 r
.48854 .92723 m .47191 .91848 L .46706 .94513 L closepath p F P
0 g
s
.064 0 0 r
.51221 .90959 m .50526 .9235 L .46706 .94513 L closepath p F P
0 g
s
.508 0 0 r
.50526 .9235 m .48854 .92723 L .46706 .94513 L closepath p F P
0 g
s
0 .956 0 r
.77276 .56242 m .7798 .55644 L .82412 .5466 L closepath p F P
0 g
s
0 .761 0 r
.7738 .57447 m .77276 .56242 L .82412 .5466 L closepath p F P
0 g
s
0 .568 0 r
.78225 .58558 m .7738 .57447 L .82412 .5466 L closepath p F P
0 g
s
0 .313 0 r
.79324 .58933 m .78225 .58558 L .82412 .5466 L closepath p F P
0 g
s
0 0 0 r
.80037 .58346 m .79324 .58933 L .82412 .5466 L closepath p F P
0 g
s
0 .856 0 r
.7994 .57134 m .80037 .58346 L .82412 .5466 L closepath p F P
0 g
s
0 .559 0 r
.79085 .56012 m .7994 .57134 L .82412 .5466 L closepath p F P
0 g
s
0 .076 0 r
.7798 .55644 m .79085 .56012 L .82412 .5466 L closepath p F P
0 g
s
0 0 0 r
.52903 .6116 m .54156 .59225 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.50789 .63151 m .52903 .6116 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.49013 .64066 m .50789 .63151 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.54156 .59225 m .5381 .58463 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.48612 .63353 m .49013 .64066 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.5381 .58463 m .52029 .59355 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.49859 .61395 m .48612 .63353 L .60198 .70207 L closepath p F P
0 g
s
0 0 0 r
.52029 .59355 m .49859 .61395 L .60198 .70207 L closepath p F P
0 g
s
1 0 0 r
.007 w
.47961 .92253 m
.60198 .70207 L
s
0 1 0 r
.60198 .70207 m
.79571 .56649 L
s
0 0 0 r
.13893 .23198 m
.50721 .60585 L
s
.5 Mabswid
0 0 .599 r
.80558 .92183 m .81652 .91127 L .85811 .96208 L closepath p F P
0 g
s
0 0 .705 r
.81652 .91127 m .82409 .90223 L .85811 .96208 L closepath p F P
0 g
s
0 0 .368 r
.79756 .92782 m .80558 .92183 L .85811 .96208 L closepath p F P
0 g
s
0 0 .457 r
.82409 .90223 m .82385 .89997 L .85811 .96208 L closepath p F P
0 g
s
0 0 .798 r
.79717 .92571 m .79756 .92782 L .85811 .96208 L closepath p F P
0 g
s
0 0 .52 r
.82385 .89997 m .81583 .90592 L .85811 .96208 L closepath p F P
0 g
s
0 0 .823 r
.80474 .91662 m .79717 .92571 L .85811 .96208 L closepath p F P
0 g
s
0 0 .697 r
.81583 .90592 m .80474 .91662 L .85811 .96208 L closepath p F P
0 g
s
0 0 1 r
.007 w
.60198 .70207 m
.80914 .91238 L
s
0 g
gsave
.88472 .9891 -68.5313 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 18.063 moveto
%%IncludeResource: font Times-Bold
%%IncludeFont: Times-Bold
%%BeginResource: font Times-Bold-MISO
%%BeginFont: Times-Bold-MISO
/Times-Bold /Times-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.250 20.313 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 9.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(r) show
74.063 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.86476 .51817 -68.7813 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 18.063 moveto
%%IncludeResource: font Times-Bold
%%IncludeFont: Times-Bold
%%BeginResource: font Times-Bold-MISO
%%BeginFont: Times-Bold-MISO
/Times-Bold /Times-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.250 20.313 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 9.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(q) show
74.563 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.45379 .96904 -69.2813 -13.7188 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 27.4375 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 18.063 moveto
%%IncludeResource: font Times-Bold
%%IncludeFont: Times-Bold
%%BeginResource: font Times-Bold-MISO
%%BeginFont: Times-Bold-MISO
/Times-Bold /Times-Bold-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(e) show
69.250 20.313 moveto
%%IncludeResource: font Mathematica1-Bold
%%IncludeFont: Mathematica1-Bold
/Mathematica1-Bold findfont 9.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f) show
75.563 18.063 moveto
%%IncludeResource: font Times-Bold-MISO
%%IncludeFont: Times-Bold-MISO
/Times-Bold-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.6266 0 m
.92836 .46097 L
s
.92836 .46097 m
1 1.09161 L
s
1 1.09161 m
.64836 .69094 L
s
.64836 .69094 m
.6266 0 L
s
.08996 .22434 m
0 .88987 L
s
0 .88987 m
.64836 .69094 L
s
.64836 .69094 m
.6266 0 L
s
.6266 0 m
.08996 .22434 L
s
.08996 .22434 m
.6266 0 L
s
0 .88987 m
.44562 1.21928 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{236.188, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005R0001[b000`400?l00000o`00003og03oool2
000008@0oooo003J0?ooo`80000000<0oooo000000000000P`3oool00=L0oooo0`0000030?ooo`80
0000P`3oool00=D0oooo0P0000060?ooo`030000003oool000000880oooo003C0?ooo`800000203o
ool010000000oooo0?ooo`0000210?ooo`00d03oool3000000X0oooo00@000000?ooo`3oool00000
P@3oool00<h0oooo0P00000=0?ooo`050000003oool0oooo0?ooo`000000P03oool00</0oooo0`00
000?0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0O@3oool00<T0oooo0P00000B
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0O@3oool00<L0oooo0P00000D0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0O03oool00<@0oooo0`00000F0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0N`3oool00<80oooo0P00000I0?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool0N`3oool00;l0oooo0`00000K0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0NP3oool00;d0oooo0P00000N0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0NP3oool00;/0oooo0P00000P0?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0N@3oool00;P0oooo0`00000R0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0N03oool00;H0oooo0P00000V0?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0N03oool00;<0oooo0`00000X0?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0M`3oool00;40oooo0P00000[0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0MP3oool00:l0oooo0P00000]0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0MP3oool00:`0oooo0`00000_0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool0M@3oool00:X0oooo0P00000b0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
M03oool00:L0oooo0`00000d0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0M03o
ool00:D0oooo0P00000g0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0L`3oool0
0:<0oooo0P00000i0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0LP3oool00:00
oooo0`00000k0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0LP3oool009h0oooo
0P00000n0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0L@3oool009/0oooo0`00
00100?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0L03oool009T0oooo0P000013
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0L03oool009L0oooo0P0000150?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool0K`3oool009@0oooo0`0000170?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0KP3oool00980oooo0P00001:0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0KP3oool008l0oooo0`00001<0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0K@3oool008d0oooo0P00001?0?ooo`030000003oool0
oooo0140oooo00<000000?ooo`3oool0K@3oool008/0oooo0P00001A0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0K03oool008P0oooo0`00001C0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0J`3oool008H0oooo0P00001F0?ooo`030000003oool0oooo01<0oooo
00<000000?ooo`3oool0J`3oool008<0oooo0`00001H0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool0JP3oool00840oooo0P00001K0?ooo`030000003oool0oooo01D0oooo00<00000
0?ooo`3oool0J@3oool007l0oooo0P00001M0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool0J@3oool007`0oooo0`00001O0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0J03oool007X0oooo0P00001R0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
I`3oool007L0oooo0`00001T0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0I`3o
ool007D0oooo0P00001W0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0IP3oool0
0780oooo0`00001Y0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0I@3oool00700
oooo0P00001/0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0I@3oool006h0oooo
0P00001_0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0I03oool006/0oooo0`00
001a0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0H`3oool006T0oooo0P00001d
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0H`3oool006H0oooo0`00001f0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0HP3oool006@0oooo0P00001i0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0H@3oool00680oooo0P00001k0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool0H@3oool005l0oooo0`00001m0?ooo`030000003o
ool0oooo01d0oooo00<000000?ooo`3oool0H03oool005d0oooo0P0000200?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool0H03oool005X0oooo0`0000220?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool0G`3oool005P0oooo0P0000250?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0GP3oool005H0oooo0P0000270?ooo`030000003oool0oooo01l0oooo
00<000000?ooo`3oool0GP3oool005<0oooo0`0000290?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0G@3oool00540oooo0P00002<0?ooo`030000003oool0oooo0240oooo00<00000
0?ooo`3oool0G03oool004h0oooo0`00002>0?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool0G03oool004`0oooo0P00002A0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3o
ool0F`3oool004X0oooo0P00002C0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
FP3oool004L0oooo0`00002E0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0FP3o
ool004D0oooo0P00002H0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0F@3oool0
0480oooo0`00002J0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0F03oool00400
oooo0P00002M0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0F03oool003h0oooo
0P00002O0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0E`3oool003/0oooo0`00
002Q0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0EP3oool003T0oooo0P00002T
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0EP3oool003H0oooo0`00002V0?oo
o`030000003oool0oooo02P0oooo00<000000?ooo`3oool0E@3oool003@0oooo0P00002Y0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool0E03oool00380oooo0P00002[0?ooo`030000
003oool0oooo02T0oooo00<000000?ooo`3oool0E03oool002l0oooo0`00002]0?ooo`030000003o
ool0oooo02X0oooo00<000000?ooo`3oool0D`3oool002d0oooo0P00002`0?ooo`030000003oool0
oooo02X0oooo00<000000?ooo`3oool0D`3oool002X0oooo0`00002b0?ooo`030000003oool0oooo
02/0oooo00<000000?ooo`3oool0DP3oool002P0oooo0P00002e0?ooo`030000003oool0oooo02`0
oooo00<000000?ooo`3oool0D@3oool002H0oooo0P00002g0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool0D@3oool002<0oooo0`00002j0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool0D03oool00240oooo0P00002m0?ooo`030000003oool0oooo02d0oooo00<00000
0?ooo`3oool0C`3oool001l0oooo0P00002o0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool0C`3oool001l0oooo0P00002o0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool0CP3oool001l0oooo00<000000?ooo`0000003`3oool00`000000oooo0?ooo`2/0?ooo`030000
003oool0oooo02l0oooo00<000000?ooo`3oool0C@3oool001l0oooo00@000000?ooo`3oool00000
3@3oool300000:d0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`1=0?ooo`007P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00/0oooo0`00002/0?ooo`030000003o
ool0oooo0300oooo00<000000?ooo`3oool0C03oool001h0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0;0?ooo`<00000Z`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0
oooo04/0oooo000N0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool30000
0:X0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1;0?ooo`007P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00/0oooo0`00002Y0?ooo`030000003oool0oooo0380
oooo00<000000?ooo`3oool0BP3oool001h0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0;0?ooo`<00000Z03oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo04T0oooo
000N0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0303oool300000:L0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`190?ooo`007P3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00`0oooo0`00002V0?ooo`030000003oool0oooo03@0oooo00<00000
0?ooo`3oool0B03oool001h0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0<0?oo
o`<00000Y@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo04L0oooo000M0?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool0303oool300000:@0oooo00<000000?ooo`3o
ool0=@3oool00`000000oooo0?ooo`170?ooo`007@3oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo00`0oooo0`00002S0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
AP3oool001d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`<00000XP3o
ool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo04H0oooo000M0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0303oool300000:40oooo00<000000?ooo`3oool0=`3oool0
0`000000oooo0?ooo`150?ooo`007@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00`0oooo0`00002P0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0A03oool001d0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`<00000W`3oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo04@0oooo000M0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0303oool3000009h0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`130?ooo`00703oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00`0oooo0`00
002M0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0@P3oool001`0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`<00000W03oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo0480oooo000L0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool0303oool3000009/0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`110?oo
o`00703oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00`0oooo0`00002J0?ooo`03
0000003oool0oooo03`0oooo00<000000?ooo`3oool0@03oool001`0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0<0?ooo`<00000V@3oool00`000000oooo0?ooo`0l0?ooo`030000
003oool0oooo0400oooo000L0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0303o
ool3000009P0oooo00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0o0?ooo`00703oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00`0oooo0`00002G0?ooo`030000003oool0
oooo03h0oooo00<000000?ooo`3oool0?P3oool001`0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0=0?ooo`<00000UP3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
03h0oooo000K0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool03@3oool3000009D0
oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0m0?ooo`006`3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo00d0oooo0`00002E0?ooo`030000003oool0oooo03l0oooo
00<000000?ooo`3oool0?03oool001/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0=0?ooo`<00000U03oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo03`0oooo000K
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool03@3oool3000009<0oooo00<00000
0?ooo`3oool0@03oool00`000000oooo0?ooo`0k0?ooo`006`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo00d0oooo0`00002B0?ooo`030000003oool0oooo0440oooo00<000000?oo
o`3oool0>P3oool001/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0=0?ooo`<0
0000T@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo03X0oooo000K0?ooo`030000
003oool0oooo0200oooo00<000000?ooo`3oool03@3oool300000900oooo00<000000?ooo`3oool0
@P3oool00`000000oooo0?ooo`0i0?ooo`006`3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo00d0oooo0`00002?0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0>@3o
ool001X0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0=0?ooo`800000S`3oool0
0`000000oooo0?ooo`130?ooo`030000003oool0oooo03P0oooo000J0?ooo`030000003oool0oooo
02@0oooo00<000000?ooo`3oool03@3oool2000008h0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`0g0?ooo`006P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00`0
oooo0`00002=0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0=`3oool001X0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0<0?ooo`<00000S03oool00`000000oooo
0?ooo`150?ooo`030000003oool0oooo03H0oooo000J0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool0303oool3000008/0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0e0?ooo`006P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00`0oooo0`00002:
0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0=@3oool001X0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`0<0?ooo`<00000R@3oool00`000000oooo0?ooo`170?oo
o`030000003oool0oooo03@0oooo000I0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0303oool3000008P0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0c0?ooo`00
6@3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00`0oooo0`0000270?ooo`030000
003oool0oooo04P0oooo00<000000?ooo`3oool0<`3oool001T0oooo00<000000?ooo`3oool0;03o
ool00`000000oooo0?ooo`0=0?ooo`<00000QP3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo0380oooo000I0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool03@3oool3
000008D0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0a0?ooo`006@3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo00d0oooo0`0000240?ooo`030000003oool0oooo
04X0oooo00<000000?ooo`3oool0<@3oool001T0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0=0?ooo`<00000P`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0300
oooo000I0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool03@3oool300000880oooo
00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0_0?ooo`006@3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo00d0oooo0`0000210?ooo`030000003oool0oooo04`0oooo00<0
00000?ooo`3oool0;`3oool001P0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0=
0?ooo`<00000P03oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo02h0oooo000H0?oo
o`030000003oool0oooo03@0oooo00<000000?ooo`3oool03@3oool3000007l0oooo00<000000?oo
o`3oool0CP3oool00`000000oooo0?ooo`0]0?ooo`00603oool00`000000oooo0?ooo`0e0?ooo`03
0000003oool0oooo00d0oooo0`00001n0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3o
ool0;@3oool001P0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0=0?ooo`<00000
O@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo02`0oooo000H0?ooo`030000003o
ool0oooo03L0oooo00<000000?ooo`3oool03@3oool3000007`0oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`0/0?ooo`00603oool00`000000oooo0?ooo`0h0?ooo`030000003oool0
oooo00d0oooo0`00001k0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0:`3oool0
01P0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0=0?ooo`<00000NP3oool00`00
0000oooo0?ooo`1A0?ooo`030000003oool0oooo02X0oooo000G0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool03@3oool3000007T0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`0Z0?ooo`005`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo00d0oooo
0`00001h0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0:@3oool001L0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`0=0?ooo`<00000N03oool00`000000oooo0?oo
o`1B0?ooo`030000003oool0oooo02P0oooo000G0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool03@3oool3000007L0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0X
0?ooo`005`3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo00h0oooo0`00001f0?oo
o`030000003oool0oooo05<0oooo00<000000?ooo`3oool09`3oool001L0oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`0>0?ooo`<00000M@3oool00`000000oooo0?ooo`1D0?ooo`03
0000003oool0oooo02H0oooo000G0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
3P3oool3000007@0oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`0V0?ooo`005`3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00h0oooo0`00001c0?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool09@3oool001H0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`0>0?ooo`<00000LP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0
oooo02@0oooo000F0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool03P3oool30000
0740oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0T0?ooo`005P3oool00`000000
oooo0?ooo`150?ooo`030000003oool0oooo00h0oooo0`00001`0?ooo`030000003oool0oooo05L0
oooo00<000000?ooo`3oool08`3oool001H0oooo00<000000?ooo`3oool0AP3oool00`000000oooo
0?ooo`0>0?ooo`<00000K`3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo0280oooo
000F0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool03P3oool3000006h0oooo00<0
00000?ooo`3oool0F03oool00`000000oooo0?ooo`0R0?ooo`005P3oool00`000000oooo0?ooo`18
0?ooo`030000003oool0oooo00h0oooo0`00001]0?ooo`030000003oool0oooo05T0oooo00<00000
0?ooo`3oool08@3oool001H0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0>0?oo
o`<00000K03oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo0200oooo000F0?ooo`03
0000003oool0oooo04X0oooo00<000000?ooo`3oool03P3oool3000006/0oooo00<000000?ooo`3o
ool0FP3oool00`000000oooo0?ooo`0P0?ooo`005@3oool00`000000oooo0?ooo`1<0?ooo`030000
003oool0oooo00h0oooo0`00001Z0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0
7`3oool001D0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0>0?ooo`<00000J@3o
ool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo01l0oooo000E0?ooo`030000003oool0
oooo04h0oooo00<000000?ooo`3oool03P3oool3000006P0oooo00<000000?ooo`3oool0G03oool0
0`000000oooo0?ooo`0N0?ooo`005@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo
00h0oooo0`00001W0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool07@3oool001D0
oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0>0?ooo`<00000IP3oool00`000000
oooo0?ooo`1M0?ooo`030000003oool0oooo01d0oooo000E0?ooo`030000003oool0oooo0500oooo
00<000000?ooo`3oool03`3oool3000006D0oooo00<000000?ooo`3oool0GP3oool00`000000oooo
0?ooo`0L0?ooo`005@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00l0oooo0`00
001T0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool06`3oool001@0oooo00<00000
0?ooo`3oool0D`3oool00`000000oooo0?ooo`0?0?ooo`<00000H`3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo01/0oooo000D0?ooo`030000003oool0oooo05@0oooo00<000000?oo
o`3oool03`3oool300000680oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0J0?oo
o`00503oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo00l0oooo0`00001Q0?ooo`03
0000003oool0oooo0640oooo00<000000?ooo`3oool06@3oool001@0oooo00<000000?ooo`3oool0
EP3oool00`000000oooo0?ooo`0?0?ooo`<00000H03oool00`000000oooo0?ooo`1Q0?ooo`030000
003oool0oooo01T0oooo000D0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool03`3o
ool3000005l0oooo00<000000?ooo`3oool0H@3oool2000001X0oooo000D0?ooo`030000003oool0
oooo05P0oooo00<000000?ooo`3oool03`3oool3000005h0oooo00<000000?ooo`3oool0GP3oool3
000000030?ooo`000000oooo01T0oooo000D0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool03`3oool3000005d0oooo00<000000?ooo`3oool0F`3oool3000000@0oooo00<000000?oo
o`3oool0603oool001@0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0?0?ooo`<0
0000G03oool00`000000oooo0?ooo`1H0?ooo`<000001`3oool00`000000oooo0?ooo`0H0?ooo`00
4`3oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo00l0oooo0`00001K0?ooo`030000
003oool0oooo05D0oooo0`00000:0?ooo`030000003oool0oooo01P0oooo000C0?ooo`030000003o
ool0oooo05d0oooo00<000000?ooo`3oool03`3oool3000005/0oooo00<000000?ooo`3oool0D@3o
ool3000000h0oooo00<000000?ooo`3oool05`3oool001<0oooo00<000000?ooo`3oool0GP3oool0
0`000000oooo0?ooo`0?0?ooo`<00000FP3oool00`000000oooo0?ooo`1>0?ooo`<000004@3oool0
0`000000oooo0?ooo`0G0?ooo`004`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo
00l0oooo0`00001I0?ooo`030000003oool0oooo04X0oooo1000000D0?ooo`030000003oool0oooo
01L0oooo000C0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool03`3oool3000005P0
oooo00<000000?ooo`3oool0A`3oool3000001P0oooo00<000000?ooo`3oool05`3oool001<0oooo
00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0?0?ooo`<00000E`3oool00`000000oooo
0?ooo`140?ooo`<000006`3oool00`000000oooo0?ooo`0G0?ooo`004`3oool00`000000oooo0?oo
o`1R0?ooo`030000003oool0oooo00l0oooo0`00001F0?ooo`030000003oool0oooo0440oooo0`00
00090?ooo`040=BK00000000000009_Doa40oooo00<000000?ooo`3oool05`3oool00180oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`0@0?ooo`<00000E@3oool00`000000oooo0?oo
o`0n0?ooo`<000002`3oool01P3oe9/0001b0;[Zo`3oj[X0LP0009_Doa00oooo00<000000?ooo`3o
ool05`3oool00180oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0@0?ooo`<00000
E03oool00`000000oooo0?ooo`0k0?ooo`<000003P3oool01`3Z^W80001b0;[Zo`3oool0j[Yb0000
V`3Dool03`3oool00`000000oooo0?ooo`0G0?ooo`004P3oool00`000000oooo0?ooo`1U0?ooo`03
0000003oool0oooo0100oooo0`00001C0?ooo`030000003oool0oooo03P0oooo0`0000090?ooo`03
0?oojP2jLP0000000080000000X007:j0>[oo`3oool0j[Yb0000002Ke?l0oooo0?oZ^P1b0000L[[Z
403oool00`000000oooo0?ooo`0F0?ooo`004P3oool00`000000oooo0?ooo`1V0?ooo`030000003o
ool0oooo0100oooo0`00001B0?ooo`030000003oool0oooo03D0oooo0`00000;0?ooo`0:0?oojP2j
LP0000000000002Ke?l0oooo0?oZ^P1bVm@0oooo0>ZjLPD0000000<007:j0>[oo`3oool03P3oool0
0`000000oooo0?ooo`0F0?ooo`004P3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo
0100oooo0`00001A0?ooo`030000003oool0oooo0380oooo0`00000>0?ooo`040>ZjLP0000000000
002Ke0<0oooo00X0omBj0;[Zo`3oj[X0LP00001b^P3Zool0oooo0=BK00000780^^[o3`3oool00`00
0000oooo0?ooo`0F0?ooo`004P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo0100
oooo0`00001@0?ooo`030000003oool0oooo02l0oooo0`00000@0?ooo`050?oojP2jLP0000000000
002Ke?l01@3oool0203oonX0^W800000LP2jj_l0oooo0?oDV`000780^^[o3`3oool00`000000oooo
0?ooo`0F0?ooo`004P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0100oooo0`00
001?0?ooo`030000003oool0oooo02`0oooo0`00000C0?ooo`050?oojP2jLP0000000000LP2jj_l0
1P3oool01`3oe9/00000002Ke03oool0omBK0000002Ke?l03`3oool00`000000oooo0?ooo`0F0?oo
o`004P3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo0100oooo0P00001?0?ooo`03
0000003oool0oooo02T0oooo0`00000F0?ooo`030?oojP2jLP00000000H0000000T0VmCo0?ooo`3o
ool0e9/00000LP2jj_l0omBK0000LP2jj_l03`3oool00`000000oooo0?ooo`0F0?ooo`004@3oool0
0`000000oooo0?ooo`1/0?ooo`030000003oool0oooo0100oooo0P00001>0?ooo`030000003oool0
oooo02H0oooo0`00000J0?ooo`090=BK00000000002K0=Coo`3oool0onZj078000000780^^[o00<0
oooo00@0j[Yb000000000000L[[Z403oool00`000000oooo0?ooo`0F0?ooo`004@3oool00`000000
oooo0?ooo`1]0?ooo`030000003oool0oooo00l0oooo0`00001=0?ooo`030000003oool0oooo0280
oooo1000000M0?ooo`090?oDV`000000001b0;[Zo`3oool0onZj07800000L[X0j_oo01L0oooo00<0
00000?ooo`3oool05P3oool00140oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`0?
0?ooo`<00000C03oool00`000000oooo0?ooo`0O0?ooo`<000008P3oool01`3DV`000000002Ke03o
ool0j[Yb0000002Ke?l0603oool00`000000oooo0?ooo`0F0?ooo`004@3oool00`000000oooo0?oo
o`1_0?ooo`030000003oool0oooo00l0oooo0`00001;0?ooo`030000003oool0oooo01`0oooo0`00
000V0?ooo`050?oDV`00000000000000002Ke?l06P3oool00`000000oooo0?ooo`0E0?ooo`004@3o
ool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo00l0oooo0`00001:0?ooo`030000003o
ool0oooo01T0oooo0`0000180?ooo`030000003oool0oooo01D0oooo000A0?ooo`030000003oool0
oooo0740oooo00<000000?ooo`3oool03`3oool3000004T0oooo00<000000?ooo`3oool05P3oool3
000004/0oooo00<000000?ooo`3oool05@3oool00140oooo00<000000?ooo`3oool0LP3oool00`00
0000oooo0?ooo`0?0?ooo`<00000B03oool00`000000oooo0?ooo`0C0?ooo`<00000CP3oool00`00
0000oooo0?ooo`0E0?ooo`00403oool00`000000oooo0?ooo`1d0?ooo`030000003oool0oooo00l0
oooo0`0000170?ooo`030000003oool0oooo0100oooo0`00001A0?ooo`030000003oool0oooo01D0
oooo000@0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool03`3oool3000004H0oooo
00<000000?ooo`3oool03@3oool3000005@0oooo00<000000?ooo`3oool05@3oool00100oooo00<0
00000?ooo`3oool0MP3oool00`000000oooo0?ooo`0?0?ooo`<00000A@3oool00`000000oooo0?oo
o`0:0?ooo`<00000E`3oool00`000000oooo0?ooo`0E0?ooo`00403oool00`000000oooo0?ooo`1f
0?ooo`030000003oool0oooo0100oooo0`0000140?ooo`030000003oool0oooo00L0oooo0`00001J
0?ooo`030000003oool0oooo01D0oooo000@0?ooo`030000003oool0oooo07L0oooo00<000000?oo
o`3oool0403oool3000004<0oooo00<000000?ooo`3oool0103oool3000003@0oooo0`00000W0?oo
o`030000003oool0oooo01@0oooo000@0?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3o
ool0403oool300000480oooo00@000000?ooo`3oool0oooo0`00000b0?ooo`L00000:03oool00`00
0000oooo0?ooo`0D0?ooo`00403oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo0100
oooo0`0000110?ooo`@00000;`3oool60000008001<00P0000000`00S`0000000000000X0?ooo`03
0000003oool0oooo01@0oooo000@0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0
403oool3000003h0oooo0`00000_0?ooo`<000001@004`030000008008l00P00000Y0?ooo`030000
003oool0oooo01@0oooo000?0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0403o
ool3000003T0oooo100000020?ooo`030000003oool0oooo02/0oooo1@000003000C008000001000
S`02000002X0oooo00<000000?ooo`3oool0503oool000l0oooo00<000000?ooo`3oool0O@3oool0
0`000000oooo0?ooo`0@0?ooo`<00000=@3oool3000000H0oooo00<000000?ooo`3oool0:P3oool2
000000@00<800`000005002?000300000000f`00000002X0oooo00<000000?ooo`3oool0503oool0
00l0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`0@0?ooo`<00000<@3oool30000
00X0oooo00<000000?ooo`3oool0:@3oool00`0000000<80003200050032000300000000o`0008l0
008008l000<00000003K00000000:`3oool00`000000oooo0?ooo`0D0?ooo`003`3oool00`000000
oooo0?ooo`1o0?ooo`030000003oool0oooo0100oooo0`00000]0?ooo`<000003@3oool00`000000
oooo0?ooo`0Y0?ooo`0300000000`P000<8000<00<800P000003003o0004002?000000000=/00000
02`0oooo00<000000?ooo`3oool0503oool000l0oooo00<000000?ooo`3oool0P03oool00`000000
oooo0?ooo`0@0?ooo`<00000:@3oool300000100oooo00<000000?ooo`3oool0:P3oool00`000000
0<8000320002000000@00?l000@008l000000000f`000000;@3oool00`000000oooo0?ooo`0D0?oo
o`003`3oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo0100oooo0`00000U0?ooo`<0
00004`3oool00`000000oooo0?ooo`0Z0?ooo`<0000000<00940003o0000o`000P00o`0200000080
0=/000<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0C0?ooo`003`3oool00`000000oooo
0?ooo`220?ooo`030000003oool0oooo0100oooo0`00000Q0?ooo`<000005P3oool00`000000oooo
0?ooo`0Z0?ooo`0300000000T@000?l000<00?l000H0094000000000D0000000003K0000000_0?oo
o`030000003oool0oooo01<0oooo000?0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3o
ool0403oool3000001d0oooo0`00000I0?ooo`030000003oool0oooo02/0oooo1000o`001000T@00
0000001@0000D00200000300oooo00<000000?ooo`3oool04`3oool000h0oooo00<000000?ooo`3o
ool0Q@3oool00`000000oooo0?ooo`0@0?ooo`<000006@3oool3000001`0oooo00<000000?ooo`3o
ool0:@3oool4003o0080094000@00000001@0000D00005000P00000`0?ooo`030000003oool0oooo
01<0oooo000>0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0403oool300000100
oooo0P0000030?ooo`<000007`3oool00`000000oooo0?ooo`0X0?ooo`@00?l000<00000002A0000
00000`00D00200000340oooo00<000000?ooo`3oool04`3oool000h0oooo00<000000?ooo`3oool0
Q`3oool00`000000oooo0?ooo`0@0?ooo`<000003@3oool700000280oooo00<000000?ooo`3oool0
9`3oool3003o00<0oooo0P000003001@00030000003oool0oooo0300oooo00<000000?ooo`3oool0
4`3oool000h0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`0@0?ooo`<000002P3o
ool7000002@0oooo00<000000?ooo`3oool09@3oool4003o00H0oooo0`00000c0?ooo`030000003o
ool0oooo01<0oooo000>0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool04@3oool3
000000L0oooo2P00000S0?ooo`030000003oool0oooo02@0oooo1000o`0m0?ooo`030000003oool0
oooo01<0oooo000>0?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool04@3oool30000
00@0oooo3000000S0?ooo`030000003oool0oooo0280oooo1000o`100?ooo`030000003oool0oooo
0180oooo000>0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool04@3ooolC00000280
oooo00<000000?ooo`3oool08@3oool4003o0440oooo00<000000?ooo`3oool04P3oool000d0oooo
00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0@0?ooo`@0000000<0oooo000000000000
3000000R0?ooo`030000003oool0oooo01l0oooo1000o`130?ooo`030000003oool0oooo0180oooo
000=0?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0303oool300000080oooo4P00
000Q0?ooo`030000003oool0oooo01h0oooo1000o`140?ooo`030000003oool0oooo0180oooo000=
0?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0203oool3000000H0oooo4@00000Q
0?ooo`030000003oool0oooo01`0oooo1000o`160?ooo`030000003oool0oooo0180oooo000=0?oo
o`030000003oool0oooo08l0oooo00<000000?ooo`3oool0103oool3000000T0oooo4P00000P0?oo
o`030000003oool0oooo01/0oooo1000o`170?ooo`030000003oool0oooo0180oooo000=0?ooo`03
0000003oool0oooo0900oooo00<000000?ooo`3oool00`00000;0?oooa<00000803oool00`000000
oooo0?ooo`0J0?ooo`<00?l0B@3oool00`000000oooo0?ooo`0B0?ooo`003@3oool00`000000oooo
0?ooo`2A0?ooo`8000003@3ooolE000001l0oooo00<000000?ooo`3oool0603oool4003o04X0oooo
00<000000?ooo`3oool04P3oool000d0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?oo
o`0;0?oooaH000007`3oool00`000000oooo0?ooo`0G0?ooo`@00?l0B`3oool00`000000oooo0?oo
o`0B0?ooo`003@3oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo00X0oooo6000000N
0?ooo`030000003oool0oooo01D0oooo1000o`1>0?ooo`030000003oool0oooo0140oooo000<0?oo
o`030000003oool0oooo0980oooo00<000000?ooo`3oool02@3ooolI000001h0oooo00<000000?oo
o`3oool0503oool4003o04l0oooo00<000000?ooo`3oool04@3oool000`0oooo00<000000?ooo`3o
ool0TP3oool00`000000oooo0?ooo`090?oooaX000007@3oool00`000000oooo0?ooo`0B0?ooo`@0
0?l0D@3oool00`000000oooo0?ooo`0A0?ooo`00303oool00`000000oooo0?ooo`2B0?ooo`030000
003oool0oooo00P0oooo6`00000M0?ooo`030000003oool0oooo0140oooo1000o`1B0?ooo`030000
003oool0oooo0140oooo000<0?ooo`030000003oool0oooo0980oooo00<000000?ooo`3oool01`3o
oolM000001`0oooo00<000000?ooo`3oool03`3oool4003o05@0oooo00<000000?ooo`3oool04@3o
ool000`0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`080?oooa`00000703oool0
0`000000oooo0?ooo`0>0?ooo`@00?l0E@3oool00`000000oooo0?ooo`0A0?ooo`00303oool00`00
0000oooo0?ooo`2B0?ooo`030000003oool0oooo00P0oooo7@00000K0?ooo`030000003oool0oooo
00d0oooo0`00o`1G0?ooo`030000003oool0oooo0140oooo000<0?ooo`030000003oool0oooo0980
oooo00<000000?ooo`3oool02@3ooolL000001/0oooo00<000000?ooo`3oool02`3oool4003o05P0
oooo00<000000?ooo`3oool04@3oool000/0oooo00<000000?ooo`3oool0T`3oool00`000000oooo
0?ooo`0:0?oooa`000006P3oool00`000000oooo0?ooo`0:0?ooo`@00?l0F@3oool00`000000oooo
0?ooo`0A0?ooo`002`3oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo00`0oooo6`00
000I0?ooo`030000003oool0oooo00P0oooo1000o`1L0?ooo`030000003oool0oooo0100oooo000;
0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool03P3ooolI000001X0oooo00<00000
0?ooo`3oool01P3oool4003o05d0oooo00<000000?ooo`3oool0403oool000/0oooo00<000000?oo
o`3oool0T`3oool00`000000oooo0?ooo`0@0?oooaP000006@3oool00`000000oooo0?ooo`040?oo
o`@00?l0G`3oool00`000000oooo0?ooo`0@0?ooo`002`3oool00`000000oooo0?ooo`2C0?ooo`03
0000003oool0oooo0140oooo5`00000I0?ooo`030000003oool0oooo00<0oooo1000o`1P0?ooo`03
0000003oool0oooo0100oooo000;0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0
4`3ooolF000001P0oooo00<000000?ooo`3oool00P3oool3003o0680oooo00<000000?ooo`3oool0
403oool000/0oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0E0?oooa@00000603o
ool00`000000oooo0?ooo`04003o06<0oooo00<000000?ooo`3oool0403oool000/0oooo00<00000
0?ooo`3oool0T`3oool00`000000oooo0?ooo`0G0?oooa<000005`3oool00`000000oooo003o0003
003o06@0oooo00<000000?ooo`3oool0403oool000X0oooo00<000000?ooo`3oool0U03oool00`00
0000oooo0?ooo`0I0?oooa4000005`3oool0100000000?l0003o0000o`1V0?ooo`030000003oool0
oooo0100oooo000:0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool06P3ooolA0000
01D0oooo00@00?l000000000o`000?l0J03oool00`000000oooo0?ooo`0?0?ooo`002P3oool00`00
0000oooo0?ooo`2D0?ooo`030000003oool0oooo01`0oooo3`00000C0?ooo`<00?l000<000000?oo
o`3oool0J03oool00`000000oooo0?ooo`0?0?ooo`002P3oool00`000000oooo0?ooo`2D0?ooo`03
0000003oool0oooo01h0oooo3P00000A0?ooo`@00?l000<000000?ooo`3oool0J03oool00`000000
oooo0?ooo`0?0?ooo`002P3oool00`000000oooo0?ooo`2D0?ooo`030000003oool0oooo0200oooo
3000000?0?ooo`@00?l00P3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00l0oooo
000:0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool08@3oool<000000d0oooo1000
o`030?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool03`3oool000X0oooo00<00000
0?ooo`3oool0U03oool00`000000oooo0?ooo`0S0?ooo`X00000303oool3003o00D0oooo00<00000
0?ooo`3oool0J03oool00`000000oooo0?ooo`0?0?ooo`002@3oool00`000000oooo0?ooo`2E0?oo
o`030000003oool0oooo02D0oooo2@0000090?ooo`@00?l01P3oool00`000000oooo0?ooo`1X0?oo
o`030000003oool0oooo00l0oooo00090?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3o
ool09`3oool7000000P0oooo1000o`070?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3o
ool03`3oool000T0oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`0Z0?ooo`H00000
1@3oool4003o00P0oooo0P00001Z0?ooo`030000003oool0oooo00l0oooo00090?ooo`030000003o
ool0oooo09@0oooo00<000000?ooo`3oool0:`3oool5000000@0oooo1000o`060?ooo`<000000P3o
ool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo00h0oooo00090?ooo`030000003oool0
oooo09@0oooo00<000000?ooo`3oool0;@3oool4000000030?ooo`00o`000?l000800?l0103oool4
000000H0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0>0?ooo`002@3oool00`00
0000oooo0?ooo`2D0?ooo`030000003oool0oooo02l0oooo0P00000010000?l00?l0003o0000o`02
0?ooo`<000002`3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00h0oooo00090?oo
o`030000003oool0oooo09@0oooo00<000000?ooo`3oool0<03oool30000o`040?ooo`0000000000
000000l0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`0>0?ooo`002@3oool00`00
0000oooo0?ooo`2D0?ooo`030000003oool0oooo0300oooo00@0o`0000000000000000004P3oool0
0`000000oooo0?ooo`1U0?ooo`030000003oool0oooo00h0oooo00080?ooo`030000003oool0oooo
09D0oooo00<000000?ooo`3oool0;@3oool4000000040?ooo`000?l0003o0000oa80oooo00<00000
0?ooo`3oool0I03oool00`000000oooo0?ooo`0>0?ooo`00203oool00`000000oooo0?ooo`2E0?oo
o`030000003oool0oooo02X0oooo0`0000020?ooo`80o`000P3oool30000oa80oooo00<000000?oo
o`3oool0H`3oool00`000000oooo0?ooo`0>0?ooo`00203oool00`000000oooo0?ooo`2E0?ooo`03
0000003oool0oooo02L0oooo0`0000050?ooo`030?l0003oool0oooo0080oooo0`000?lB0?ooo`03
0000003oool0oooo0680oooo00<000000?ooo`3oool03P3oool000P0oooo00<000000?ooo`3oool0
U@3oool00`000000oooo0?ooo`0S0?ooo`@000001`3oool20?l000D0oooo0`000?lB0?ooo`030000
003oool0oooo0680oooo00<000000?ooo`3oool03@3oool000P0oooo00<000000?ooo`3oool0U@3o
ool00`000000oooo0?ooo`0P0?ooo`<000002P3oool20?l000L0oooo0`000?lB0?ooo`030000003o
ool0oooo0640oooo00<000000?ooo`3oool03@3oool000P0oooo00<000000?ooo`3oool0U@3oool0
0`000000oooo0?ooo`0M0?ooo`<000003@3oool00`3o0000oooo0?ooo`070?ooo`<0003o4P3oool0
0`000000oooo0?ooo`1P0?ooo`030000003oool0oooo00d0oooo00080?ooo`030000003oool0oooo
09D0oooo00<000000?ooo`3oool06P3oool3000000l0oooo0P3o000:0?ooo`<0003o4P3oool00`00
0000oooo0?ooo`1O0?ooo`030000003oool0oooo00d0oooo00080?ooo`030000003oool0oooo09D0
oooo00<000000?ooo`3oool05P3oool400000180oooo00<0o`000?ooo`3oool02P3oool30000oa40
oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo
0?ooo`2F0?ooo`030000003oool0oooo01<0oooo0`00000E0?ooo`80o`003@3oool30000oa40oooo
00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`0=0?ooo`001`3oool00`000000oooo0?oo
o`2F0?ooo`030000003oool0oooo0100oooo0`00000H0?ooo`030?l0003oool0oooo00d0oooo0`00
0?lA0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool03@3oool000L0oooo00<00000
0?ooo`3oool0UP3oool00`000000oooo0?ooo`0=0?ooo`<000006P3oool20?l00100oooo0`000?lA
0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool03@3oool000L0oooo00<000000?oo
o`3oool0UP3oool00`000000oooo0?ooo`090?ooo`@000007@3oool00`3o0000oooo0?ooo`0@0?oo
o`<0003o4@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo00d0oooo00070?ooo`03
0000003oool0oooo09H0oooo00<000000?ooo`3oool01P3oool300000200oooo0P3o000C0?ooo`<0
003o4@3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo00`0oooo00070?ooo`030000
003oool0oooo09H0oooo00<000000?ooo`3oool00`3oool300000280oooo0P3o000E0?ooo`<0003o
4@3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo00`0oooo00070?ooo`030000003o
ool0oooo09H0oooo00<000000?ooo`0000000`00000U0?ooo`030?l0003oool0oooo01D0oooo0`00
0?lA0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0303oool000H0oooo00<00000
0?ooo`3oool0UP3oool3000002P0oooo0P3o000H0?ooo`<0003o403oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo00`0oooo00060?ooo`030000003oool0oooo09<0oooo0`0000000`3o
ool000000?ooo`0X0?ooo`030?l0003oool0oooo01P0oooo0`000?l@0?ooo`030000003oool0oooo
05P0oooo00<000000?ooo`3oool0303oool000H0oooo00<000000?ooo`3oool0T03oool3000000@0
oooo00<000000?ooo`3oool09P3oool20?l001/0oooo0`000?l@0?ooo`030000003oool0oooo05L0
oooo00<000000?ooo`3oool0303oool000H0oooo00<000000?ooo`3oool0S03oool4000000L0oooo
00<000000?ooo`3oool09P3oool00`3o0000oooo0?ooo`0K0?ooo`<0003o403oool00`000000oooo
0?ooo`1F0?ooo`030000003oool0oooo00`0oooo00060?ooo`030000003oool0oooo08T0oooo0`00
000;0?ooo`030000003oool0oooo02D0oooo0P3o000N0?ooo`<0003o403oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo00`0oooo00060?ooo`030000003oool0oooo08H0oooo0`00000>
0?ooo`030000003oool0oooo02D0oooo00<0o`000?ooo`3oool07P3oool30000oa00oooo00<00000
0?ooo`3oool0E@3oool00`000000oooo0?ooo`0;0?ooo`001P3oool00`000000oooo0?ooo`230?oo
o`<000004@3oool00`000000oooo0?ooo`0T0?ooo`80o`008@3oool30000oa00oooo00<000000?oo
o`3oool0E03oool00`000000oooo0?ooo`0;0?ooo`001P3oool00`000000oooo0?ooo`1o0?ooo`@0
0000503oool00`000000oooo0?ooo`0S0?ooo`80o`008`3oool30000oa00oooo00<000000?ooo`3o
ool0D`3oool00`000000oooo0?ooo`0;0?ooo`001@3oool00`000000oooo0?ooo`1m0?ooo`<00000
603oool00`000000oooo0?ooo`0S0?ooo`030?l0003oool0oooo02<0oooo0`000?l@0?ooo`030000
003oool0oooo0580oooo00<000000?ooo`3oool02`3oool000D0oooo00<000000?ooo`3oool0NP3o
ool3000001/0oooo00<000000?ooo`3oool08P3oool20?l002H0oooo0`000?l?0?ooo`030000003o
ool0oooo0580oooo00<000000?ooo`3oool02`3oool000D0oooo00<000000?ooo`3oool0MP3oool4
000001h0oooo00<000000?ooo`3oool08P3oool00`3o0000oooo0?ooo`0V0?ooo`<0003o3`3oool0
0`000000oooo0?ooo`1A0?ooo`030000003oool0oooo00/0oooo00050?ooo`030000003oool0oooo
07<0oooo0`00000R0?ooo`030000003oool0oooo0240oooo0P3o000Y0?ooo`<0003o3`3oool00`00
0000oooo0?ooo`1@0?ooo`030000003oool0oooo00/0oooo00050?ooo`030000003oool0oooo0700
oooo0`00000U0?ooo`030000003oool0oooo0240oooo00<0o`000?ooo`3oool0:@3oool30000o`l0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0;0?ooo`001@3oool00`000000oooo
0?ooo`1]0?ooo`<00000:03oool00`000000oooo0?ooo`0P0?ooo`80o`00;03oool30000o`l0oooo
00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`0;0?ooo`001@3oool00`000000oooo0?oo
o`1Y0?ooo`@00000:`3oool00`000000oooo0?ooo`0P0?ooo`030?l0003oool0oooo02`0oooo0`00
0?l?0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool02P3oool000@0oooo00<00000
0?ooo`3oool0I`3oool3000002l0oooo00<000000?ooo`3oool07`3oool20?l002l0oooo0`000?l?
0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool02P3oool000@0oooo00<000000?oo
o`3oool0I03oool300000380oooo00<000000?ooo`3oool07`3oool00`3o0000oooo0?ooo`0_0?oo
o`<0003o3`3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00X0oooo00040?ooo`03
0000003oool0oooo0640oooo0`00000e0?ooo`030000003oool0oooo01h0oooo0P3o000b0?ooo`<0
003o3P3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00X0oooo00040?ooo`030000
003oool0oooo05d0oooo1000000h0?ooo`030000003oool0oooo01d0oooo0P3o000d0?ooo`<0003o
3P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00X0oooo00040?ooo`030000003o
ool0oooo05X0oooo0`00000l0?ooo`030000003oool0oooo01d0oooo00<0o`000?ooo`3oool0=03o
ool20000o`l0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0:0?ooo`00103oool0
0`000000oooo0?ooo`1G0?ooo`<00000?`3oool00`000000oooo0?ooo`0L0?ooo`80o`00=`3oool2
0000o`l0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0:0?ooo`00103oool00`00
0000oooo0?ooo`1C0?ooo`@00000@P3oool00`000000oooo0?ooo`0L0?ooo`030?l0003oool0oooo
03H0oooo0`000?l?0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool02P3oool000@0
oooo00<000000?ooo`3oool0D03oool3000004H0oooo00<000000?ooo`3oool06`3oool20?l003T0
oooo0`000?l?0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool02@3oool000<0oooo
00<000000?ooo`3oool0CP3oool3000004T0oooo00<000000?ooo`3oool06`3oool00`3o0000oooo
0?ooo`0i0?ooo`<0003o3`3oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo00T0oooo
00030?ooo`030000003oool0oooo04/0oooo0`00001<0?ooo`030000003oool0oooo01X0oooo0P3o
000l0?ooo`<0003o3`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00T0oooo0003
0?ooo`030000003oool0oooo04L0oooo1000001?0?ooo`030000003oool0oooo01X0oooo00<0o`00
0?ooo`3oool0?03oool30000o`h0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`09
0?ooo`000`3oool00`000000oooo0?ooo`140?ooo`<00000D`3oool00`000000oooo0?ooo`0I0?oo
o`80o`00?`3oool30000o`h0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`090?oo
o`000`3oool00`000000oooo0?ooo`110?ooo`<00000EP3oool00`000000oooo0?ooo`0H0?ooo`80
o`00@@3oool30000o`h0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`090?ooo`00
0`3oool00`000000oooo0?ooo`0n0?ooo`<00000F@3oool00`000000oooo0?ooo`0H0?ooo`030?l0
003oool0oooo0440oooo0`000?l>0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0
2@3oool000<0oooo00<000000?ooo`3oool0>P3oool4000005`0oooo00<000000?ooo`3oool05`3o
ool20?l004@0oooo0`000?l>0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool02@3o
ool000<0oooo00<000000?ooo`3oool0=`3oool300000600oooo00<000000?ooo`3oool05`3oool0
0`3o0000oooo0?ooo`140?ooo`<0003o3P3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo00T0oooo00020?ooo`030000003oool0oooo03D0oooo0`00001S0?ooo`030000003oool0oooo
01H0oooo0P3o00170?ooo`<0003o3P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
00P0oooo00020?ooo`030000003oool0oooo0340oooo1000001U0?ooo`030000003oool0oooo01L0
oooo00<0o`000?ooo`3oool0A`3oool30000o`h0oooo00<000000?ooo`3oool0@03oool00`000000
oooo0?ooo`080?ooo`000P3oool00`000000oooo0?ooo`0^0?ooo`<00000J@3oool00`000000oooo
0?ooo`0F0?ooo`80o`00BP3oool30000o`d0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`080?ooo`000P3oool00`000000oooo0?ooo`0[0?ooo`<00000K03oool00`000000oooo0?oo
o`0F0?ooo`030?l0003oool0oooo04X0oooo0`000?l=0?ooo`030000003oool0oooo03l0oooo00<0
00000?ooo`3oool0203oool00080oooo00<000000?ooo`3oool0:03oool3000006l0oooo00<00000
0?ooo`3oool05@3oool20?l004d0oooo0`000?l=0?ooo`030000003oool0oooo03h0oooo00<00000
0?ooo`3oool0203oool00080oooo00<000000?ooo`3oool0903oool400000780oooo00<000000?oo
o`3oool0503oool20?l004l0oooo0`000?l=0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool0203oool00080oooo00<000000?ooo`3oool08@3oool3000007H0oooo00<000000?ooo`3o
ool0503oool00`3o0000oooo0?ooo`1?0?ooo`<0003o3@3oool00`000000oooo0?ooo`0l0?ooo`03
0000003oool0oooo00P0oooo00000`3oool000000?ooo`0P0?ooo`<00000N@3oool00`000000oooo
0?ooo`0C0?ooo`80o`00DP3oool30000o`d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo
0?ooo`080?ooo`0000<0oooo0000003oool07@3oool3000007`0oooo00<000000?ooo`3oool04`3o
ool00`3o0000oooo0?ooo`1B0?ooo`<0003o3@3oool00`000000oooo0?ooo`0k0?ooo`030000003o
ool0oooo00L0oooo00000`3oool000000?ooo`0I0?ooo`@00000O`3oool00`000000oooo0?ooo`0B
0?ooo`80o`00E@3oool30000o`d0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`07
0?ooo`0000<0oooo0000003oool05P3oool3000008<0oooo00<000000?ooo`3oool04P3oool00`3o
0000oooo0?ooo`1E0?ooo`<0003o3@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo
00L0oooo00000`3oool000000?ooo`0C0?ooo`<00000QP3oool00`000000oooo0?ooo`0A0?ooo`80
o`00F03oool30000o``0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`070?ooo`00
00<0oooo0000003oool03`3oool4000008T0oooo00<000000?ooo`3oool04@3oool00`3o0000oooo
0?ooo`1H0?ooo`<0003o303oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo00L0oooo
00000`3oool000000?ooo`0<0?ooo`<00000S@3oool00`000000oooo0?ooo`0@0?ooo`80o`00F`3o
ool30000o``0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`070?ooo`0000<0oooo
0000003oool02@3oool300000900oooo00<000000?ooo`3oool0403oool00`3o0000oooo0?ooo`1K
0?ooo`<0003o303oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo00L0oooo00000`00
0000oooo0?ooo`060?ooo`<00000T`3oool00`000000oooo0?ooo`0?0?ooo`80o`00GP3oool30000
o``0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`070?ooo`0000<000000?ooo`3o
ool00P3oool4000009H0oooo00<000000?ooo`3oool02@3oool2000000<0oooo0P3o001P0?ooo`<0
003o303oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00L0oooo00000`000000oooo
00000002000009X0oooo00<000000?ooo`3oool01P3oool3000000060<`00000000000000000003o
ool0o`00HP3oool30000o``0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`060?oo
o`000P00002M0?ooo`030000003oool0oooo00@0oooo0P0000030<`000040000002O0000W`0009l0
0080o`00H`3oool30000o``0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`060?oo
o`0000<0oooo000000000000W03oool00`000000oooo0?ooo`030?ooo`800000103<00001P000000
W`0009l0002O0000o`0009l000800000HP3oool30000o`/0oooo00<000000?ooo`3oool0<`3oool0
0`000000oooo0?ooo`060?ooo`000`3oool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo
00<0oooo0P0000040<`000030000002O0000W`000080o`0000<0W`00000000000000H`3oool30000
o`/0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`060?ooo`00103oool00`000000
oooo0?ooo`2H0?ooo`030000003oool0oooo0080oooo00<000000?L0000000000`3<00001@000000
W`0009l0002O0000o`000080W`0000<00000070000000000H`3oool30000o`/0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`060?ooo`001@3oool2000009P0oooo00<000000?ooo`3o
ool00P3oool00`000000m`00000000030<`000030000002O0000W`000080o`0000D0W`000000001`
0000L0000000001T0?ooo`<0003o203oool010000000oooo0?ooo`00000b0?ooo`030000003oool0
oooo00H0oooo00070?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool00P3oool20000
00<0c00000L0000009l0002O0000W`000?l0002O0000000000<0L00000<000000?ooo`3oool0H`3o
ool30000o`D0oooo0P0000001@0008D000000?ooo`3oool000000340oooo00<000000?ooo`3oool0
1P3oool000P0oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`020?ooo`8000000`3<
00000`000000W`0009l000020?l000030000001`0000L00000<0L00000<000000?ooo`3oool0H`3o
ool30000o`<0oooo00D000000000Q@0008D00025000000030?ooo`030000003oool0oooo02h0oooo
00<000000?ooo`3oool01P3oool000T0oooo0P00002D0?ooo`030000003oool0oooo0080oooo0P00
00030<`000060000002O0000o`000?l0002O000000001@1`00000`000000oooo0?ooo`1T0?ooo`<0
003o00@0oooo000000000;8000000`0008D01@000000oooo0?ooo`3oool000000300oooo00<00000
0?ooo`3oool01@3oool000/0oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`020?oo
o`8000000P3<00001P000000W`0009l0003o0000W`00000000D0L0000P00001W0?ooo`<0003o0P00
0;801@00000000250000Q@0008D0000000@0oooo00<000000?ooo`3oool0;@3oool00`000000oooo
0?ooo`050?ooo`00303oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo0080oooo0`00
00000`3<0000000009l000020?l000030000001`0000L0000080L0000`00001Y0?ooo`030000o`00
0;80002b0080002b00D000000000Q@0008D00025000000030?ooo`030000003oool0oooo02d0oooo
00<000000?ooo`3oool01@3oool000d0oooo0P00002@0?ooo`030000003oool0oooo0080oooo0`00
00001@3<0000000009l0003o0000000000@0L00000@000000100000@00000000J03oool00`000000
002b0000/P040000/P040000000008D00025000000@0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`050?ooo`003`3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0080
oooo1@0000020?l000050000001`0000L0000700000000000P0@00000`000000oooo0?ooo`1V0?oo
o`03000000000=80000000H0002b00@000000000Q@0008D00000103oool00`000000oooo0?ooo`0[
0?ooo`030000003oool0oooo00D0oooo000@0?ooo`030000003oool0oooo08`0oooo00<000000?oo
o`3oool00P3oool300000080E`0000<0o`000000001`00000P1`00000`0000004000000000020000
06L0oooo00D000000000dP000=80003B000000050000/P040000000008D00025000000D0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`050?ooo`004@3oool2000008`0oooo00<00000
0?ooo`3oool00P3oool2000000<0E`0000<0o`0005L0000000001P00001W0?ooo`03000000000=80
003B00<0003B0P0000040000/P040000000008D00025000000D0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`050?ooo`004`3oool00`000000oooo0?ooo`290?ooo`030000003oool0
oooo0080oooo0P00000505L00003000000220000PP0000800000JP3oool2000000D0003B00<00000
0000/P000;800P000;800`0000000025000000060?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool01@3oool001@0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`020?oo
o`800000101G000010000000PP0000000000001^0?ooo`80000010000=800`000000002b0000/P02
0000/P030000000008D0000000H0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`05
0?ooo`005@3oool2000008P0oooo00D000000?ooo`3oool0e9/009_Do`02000000<0E`0000<00000
088000000000LP3oool00`000000003B0000dP020000dP05000000000;80002b0000/P0000000P00
08D00`000000oooo0?ooo`040?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0103o
ool001L0oooo00<000000?ooo`3oool0Q@3oool01@000000oooo0?ooo`3Z^W8009_D0080000000<0
E`000000000000000P00001d0?ooo`8000000`000=801`000000002b0000/P000;8000000000Q@00
00001`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00@0oooo000H0?ooo`800000
Q@3oool01`000000oooo0?ooo`3oj[X0LP2K0000001G00000`00001h0?ooo`8000000P000=820000
0080002b00<000000000Q@0000001P3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo
00@0oooo000J0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3DV`001@00001l0?ooo`05
000000000=80003B0000dP0000000P000;82000000L0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`040?ooo`006`3oool00`000000oooo0?ooo`210?ooo`090000003Z^W80000007:j
e02jLP0000000=BK00000000VmCo07`0oooo0P0000020000dP05000000000;8000000000Q@000000
1`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo00@0oooo000L0?ooo`800000P@3o
ool02P000000e9/00000002Ke?l0j[Yb001b^P3Zool0e9/00000V`3Doomm0?ooo`80000000<0003B
000000000;800P0000080?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0103oool0
01h0oooo00<000000?ooo`3oool0OP3oool02P000000j[Yb0000002Ke?l0onZj0780002Ke?l0omBK
0000001b^^Yo0?ooo`<0000000<0002b000000000000203oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo00@0oooo000O0?ooo`030000003oool0oooo07H0oooo00<0oooZ0;Yb00000000
0P0000003000L[X0j_oo0000003oom@0V`00001b^P3ZonX0^W80002Ke03oj[X0LP00002Ke840oooo
100000090?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0103oool00200oooo0P00
001e0?ooo`0B0?oojP2jLP0000000000002Ke?l0oooo0?oZ^P1bVm@000000?ooo`3oe9/00000002K
e03DV`00002K0=CDV`000000L[[ZPP3oool4000000T0oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`040?ooo`008P3oool00`000000oooo0?ooo`1b0?ooo`040>ZjLP0000000000002K
e0<0oooo00H0omBj0000003oool0oooo0?ooe02K000300000003002Ke03oool0oooo08<0oooo0P00
000:0?ooo`<0000000<007:j0>[oo`3oool07@3oool00`000000oooo0?ooo`030?ooo`008`3oool0
0`000000oooo0?ooo`1`0?ooo`050?oojP2jLP0000000000002Ke?l0103oool00`000000oooo0?oo
o`020?ooo`030?oZ^P1b000009_D08P0oooo00<000000?ooo`3oool01`3oool010000000^W800000
LP2jj_lO0?ooo`030000003oool0oooo00<0oooo000T0?ooo`800000L03oool01@3oonX0^W800000
00000780^^[o00@0oooo00<000000?ooo`3oool00P3oool0103oom@0V`00001b^P3ZoonA0?ooo`04
0?oojP000000001b0;[Zoal0oooo00<000000?ooo`3oool00`3oool002H0oooo00<000000?ooo`3o
ool0K@3oool00`3oonX0^W8000000007000000@0oooo00@0oooZ0;Yb00000780^^[oT@3oool0103o
onX0^W800000002jj_lO0?ooo`030000003oool0oooo00<0oooo000W0?ooo`030000003oool0oooo
06d0oooo00T0e9/00000000009/0e?oo0?ooo`3oj[X0LP000000LP000000TP3oool00`3oonX0^W80
0000000200000004001b^P3Zool0oooZ0;Yb008000007`3oool00`000000oooo0?ooo`030?ooo`00
:03oool2000006d0oooo00T0omBK000000000780^^[o0?ooo`3oj[X0LP00001b^P000000T@3oool0
3`3oonX0^W80000000000000VmCo0?ooo`3oj[X0LY_D0?oojP2jLP00001b079bV`00000007:j0>[o
o`0L0?ooo`030000003oool0oooo00<0oooo000Z0?ooo`030000003oool0oooo06/0oooo00P0e9/0
00000000Vm@0oooo0>ZjLP000000VmCo00000940oooo00@0j[Yb00000000000009_D0`3oool0203o
e;X0^/>K000000000780^^[D09/000000000j_oo703oool00`000000oooo0?ooo`030?ooo`00:`3o
ool00`000000oooo0?ooo`1[0?ooo`070?oDV`00000000000000002Ke?l0oooo0000002@0?ooo`05
0?oojP2jLP0000000000002Ke?l02P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
00<0oooo000/0?ooo`800000L@3oool00`000000oooo0?ooo`2>0?ooo`050?oojP2jLP0000000000
LP2jj_l02`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0080oooo000^0?ooo`03
0000003oool0oooo06h0oooo00<000000?ooo`3oool0SP3oool00`3oonX0^W800000000600000003
09_Do`3oool0oooo00@0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`020?ooo`00
;`3oool2000006h0oooo00<000000?ooo`3oool0S`3oool02@3DV`0000000000V`3Dool0oooo0?oZ
^P1b0000001b0;[Zo`070?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool0
0340oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?ooo`2?0?ooo`090?oDV`000000001b
0;[Zo`3oool0onZj07800000L[X0j_oo00P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`020?ooo`00<P3oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo0940oooo00L0
e9/000000000Vm@0oooo0>ZjLP000000VmCo00X0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`020?ooo`00<`3oool2000006T0oooo00<000000?ooo`3oool0TP3oool01@3oe9/00000
000000000000VmCo00`0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`020?ooo`00
=@3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`020?ooo`00=P3oool00`000000oooo0?ooo`1U0?ooo`030000003o
ool0oooo0:D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`020?ooo`00=`3oool2
000006D0oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo0080oooo000i0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool0YP3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo0040oooo000j0?ooo`030000003oool0oooo0640
oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0040
oooo000k0?ooo`800000H@3oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool00@3oool003d0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?oo
o`2Y0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool00@3oool003h0oooo00<00000
0?ooo`3oool0G@3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool00@3oool003l0oooo0P00001M0?ooo`030000003oool0oooo0:/0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`010?ooo`00@@3oool00`000000oooo0?ooo`1J0?ooo`03
0000003oool0oooo0:`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`010?ooo`00
@P3oool00`000000oooo0?ooo`1I0?ooo`030000003oool0oooo0:d0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`010?ooo`00@`3oool2000005T0oooo00<000000?ooo`3oool0[P3o
ool00`000000oooo0?ooo`0=0?ooo`4000000@3oool10?ooo`00A@3oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo0:h0oooo00<000000?ooo`3oool03@3oool100000040oooo0@3oool0
04H0oooo0P00001F0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0303oool10000
0040oooo0@3oool004P0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`2`0?ooo`03
0000003oool0oooo00/0oooo0@0000010?ooo`40oooo00190?ooo`030000003oool0oooo0580oooo
00<000000?ooo`3oool0/@3oool00`000000oooo0?ooo`0:0?ooo`4000000@3oool10?ooo`00BP3o
ool200000580oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`090?ooo`4000000@3o
ool10?ooo`00C03oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo0;<0oooo00<00000
0?ooo`3oool0203oool100000040oooo0@3oool004d0oooo00<000000?ooo`3oool0CP3oool00`00
0000oooo0?ooo`2d0?ooo`030000003oool0oooo00L0oooo0@0000010?ooo`40oooo001>0?ooo`80
0000CP3oool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo00H0oooo0@0000010?ooo`40
oooo001@0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0]@3oool00`000000oooo
0?ooo`070?ooo`4000000@3oool00540oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?oo
o`2f0?ooo`030000003oool0oooo00H0oooo0@0000010?ooo`00DP3oool2000004X0oooo00<00000
0?ooo`3oool0]`3oool00`000000oooo0?ooo`050?ooo`4000000@3oool005@0oooo00<000000?oo
o`3oool0A`3oool00`000000oooo0?ooo`2h0?ooo`030000003oool0oooo00@0oooo0@0000010?oo
o`00E@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0;T0oooo00<000000?ooo`3o
ool00`3oool100000040oooo001F0?ooo`800000AP3oool00`000000oooo0?ooo`2j0?ooo`030000
003oool0oooo0080oooo0@0000010?ooo`00F03oool00`000000oooo0?ooo`130?ooo`030000003o
ool0oooo0;/0oooo00D000000?ooo`3oool0oooo000000010?ooo`00F@3oool2000004<0oooo00<0
00000?ooo`3oool0_03oool010000000oooo0?ooo`0000010?ooo`00F`3oool00`000000oooo0?oo
o`100?ooo`030000003oool0oooo0;`0oooo00@000000?ooo`3oool0oooo0@00000005`0oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo00400000001M
0?ooo`800000?`3oool00`000000oooo0?ooo`2n0?ooo`4000000@3oool100000000G`3oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo0;l0oooo0P0000000600oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`2n0?ooo`<00000001Q0?ooo`800000>`3oool00`000000oooo
0?ooo`2j0?ooo`@000000`3oool006<0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?oo
o`2f0?ooo`@000001`3oool006@0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`2a
0?ooo`D000002`3oool006D0oooo0P00000g0?ooo`030000003oool0oooo0:d0oooo1000000@0?oo
o`00I`3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0:T0oooo1000000D0?ooo`00
J03oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0:@0oooo1@00000H0?ooo`00J@3o
ool2000003<0oooo00<000000?ooo`3oool0X03oool4000001d0oooo001[0?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool0V`3oool500000240oooo001/0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool0U`3oool4000002H0oooo001]0?ooo`800000;`3oool00`000000
oooo0?ooo`2C0?ooo`@00000:P3oool006l0oooo00<000000?ooo`3oool0;03oool00`000000oooo
0?ooo`2>0?ooo`D00000;P3oool00700oooo0P00000/0?ooo`030000003oool0oooo08X0oooo1000
000c0?ooo`00LP3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo08H0oooo1000000g
0?ooo`00L`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0840oooo1@00000k0?oo
o`00M03oool2000002P0oooo00<000000?ooo`3oool0O@3oool400000400oooo001f0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0N@3oool4000004@0oooo001g0?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0M03oool5000004P0oooo001h0?ooo`800000903oool0
0`000000oooo0?ooo`1`0?ooo`@00000C@3oool007X0oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`1]0?ooo`@00000D@3oool007/0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`1X0?ooo`D00000E@3oool007`0oooo0P00000O0?ooo`030000003oool0oooo06@0oooo
1000001J0?ooo`00OP3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0600oooo1000
001N0?ooo`00O`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo05/0oooo1@00001R
0?ooo`00P03oool2000001/0oooo00<000000?ooo`3oool0E`3oool4000006L0oooo00220?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0DP3oool5000006/0oooo00230?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0CP3oool400000700oooo00240?ooo`8000005`3o
ool00`000000oooo0?ooo`1:0?ooo`@00000M03oool008H0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`150?ooo`D00000N03oool008L0oooo0P00000D0?ooo`030000003oool0oooo
0440oooo1000001m0?ooo`00R@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo03d0
oooo100000210?ooo`00RP3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03P0oooo
1@0000250?ooo`00R`3oool200000100oooo00<000000?ooo`3oool0=03oool4000008X0oooo002=
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0<03oool4000008h0oooo002>0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0:`3oool500000980oooo002?0?ooo`80
0000303oool00`000000oooo0?ooo`0W0?ooo`@00000U`3oool00940oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0S0?ooo`@00000V`3oool00980oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0N0?ooo`D00000W`3oool009<0oooo0P0000080?ooo`030000003oool0
oooo01X0oooo1000002T0?ooo`00U@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
01D0oooo1@00002X0?ooo`00UP3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0140
oooo1000002]0?ooo`00U`3oool2000000@0oooo00<000000?ooo`3oool03@3oool400000;40oooo
002I0?ooo`050000003oool0oooo0?ooo`0000002P3oool500000;D0oooo002J0?ooo`040000003o
ool0oooo000000H0oooo1000002j0?ooo`00V`3oool300000080oooo1000002n0?ooo`00W@3oool3
00000<80oooo0000\
\>"],
  ImageRangeCache->{{{0, 353.25}, {430.875, 0}} -> {0.0881614, -0.000185166, \
0.00329385, 0.00329385}}]
}, Open  ]],

Cell[TextData[{
  "Recuerda que la matriz jacobiana de una funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
            \((\(f\_1\)(x, y, z), \(f\_2\)(x, y, z), \(f\_3\)(x, y, z))\)}], 
          " "}], TraditionalForm]]],
  "es la matriz cuyas filas son los vectores gradiente de las funciones \
componentes de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " . El siguiente comando calcula la matriz jacobiana de un campo vectorial \
de tres variables."
}], "Text"],

Cell[BoxData[
    \(\(matrizjacobiana3[func_]\)[x_, y_, z_] := 
      Module[{u, v, w}, 
        Outer[D, func[u, v, w], {u, v, w}] /. {u -> x, v -> y, 
            w -> z}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(matrizjacobiana3[g]\)[r, \[Theta], \[Phi]] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(Cos[\[Phi]]\ Sin[\[Theta]]\), \(r\ Cos[\[Theta]]\ \
Cos[\[Phi]]\), \(\(-r\)\ Sin[\[Theta]]\ Sin[\[Phi]]\)},
            {\(Sin[\[Theta]]\ Sin[\[Phi]]\), \(r\ Cos[\[Theta]]\ \
Sin[\[Phi]]\), \(r\ Cos[\[Phi]]\ Sin[\[Theta]]\)},
            {\(Cos[\[Theta]]\), \(\(-r\)\ Sin[\[Theta]]\), "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Las columnas de la matriz jacobiana son las derivadas parciales ",
  Cell[BoxData[
      \(TraditionalForm\`\(u1 = D[g[r, \[Theta], \[Phi]], r]\ \)\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \ u2 = D[g[r, \[Theta], \[Phi]], \[Phi]]\)\)]],
  " y  ",
  Cell[BoxData[
      \(TraditionalForm\`u3 = D[g[r, \[Theta], \[Phi]], \[Theta]]\)]],
  ". Las normas eucl\[IAcute]deas de las columnas de la matriz jacobiana se \
llaman ",
  StyleBox["factores m\[EAcute]tricos ",
    FontWeight->"Bold"],
  "o ",
  StyleBox["factores de escala",
    FontWeight->"Bold"],
  " del cambio a cordenadas esf\[EAcute]ricas y son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, r, \ r\ sen\ \[Theta]}\)]],
  ". "
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
Expresi\[OAcute]n de la velocidad y la aceleraci\[OAcute]n en cordenadas esf\
\[EAcute]ricas\
\>", "Subsection"],

Cell[TextData[{
  "Consideremos un m\[OAcute]vil cuya trayectoria en el espacio viene dada \
por la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". Sean ",
  Cell[BoxData[
      \(TraditionalForm\`\((r(t), \ \[Theta](t), \[Phi](t))\)\)]],
  " las coordenadas esf\[EAcute]ricas de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de forma que"
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
          \((\(r(t)\) cos\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
              \(r(t)\) sen\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
              \(r(t)\)\ cos\ \(\[Theta](t)\))\), "=", 
            RowBox[{\(r(t)\), 
              RowBox[{
                StyleBox[\(e\_r\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((cos\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), 
            sen\ \(\[Phi](t)\) sen\ \(\[Theta](t)\), cos\ \(\[Theta](t)\))
            \)}], TraditionalForm]]],
  ". Es f\[AAcute]cil comprobar que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(e\_r\%\(\ \[VerticalLine]\)\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{\(\[Theta]\ '\), \((t)\), 
              RowBox[{
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
            RowBox[{\(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), 
              RowBox[{
                StyleBox[\(e\_\[Phi]\),
                  FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
        TraditionalForm]]],
  ". Podemos pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que lo haga."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"(*", " ", 
        RowBox[{
          RowBox[{"definimos", " ", "los", " ", "vectores", " ", 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], 
            StyleBox[\((t)\),
              FontWeight->"Plain"]}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], ",", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], 
            StyleBox[\((t)\),
              FontWeight->"Plain"]}]}], 
        StyleBox[" ",
          FontWeight->"Plain"], 
        StyleBox["*)",
          FontWeight->"Plain"]}], "\n", 
      RowBox[{\(er[t_] = er[\[Theta][t], \[Phi][t]]\), ";", 
        "\n", \(e\[Theta][t_] = e\[Theta][\[Theta][t], \[Phi][t]]\), ";", 
        "\n", \(e\[Phi][t_] = e\[Phi][\[Theta][t], \[Phi][t]]\), ";", "\n", 
        RowBox[{\(D[er[t], t]\), "==", 
          RowBox[{
            RowBox[{\(\(\[Theta]\ '\)[t]\), 
              RowBox[{
                StyleBox["e\[Theta]",
                  FontWeight->"Bold"], "[", "t", "]"}]}], "+", 
            RowBox[{\(\(\[Phi]'\)[t]\), \(Sin[\[Theta][t]]\), 
              RowBox[{
                StyleBox["e\[Phi]",
                  FontWeight->"Bold"], "[", "t", "]"}]}]}]}]}], 
      " ", \( (*\ comprobamos\ esta\ igualdad\ *) \)}]], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Deducimos que ", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{
                  RowBox[{\(r'\), \((t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                  RowBox[{\(r(t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\%\(\ \[VerticalLine]\)\),
                        FontWeight->"Bold"], "(", "t", ")"}]}]}], "=", 
                RowBox[{
                  RowBox[{\(r'\), \((t)\), 
                    RowBox[{
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                  \(\(r(t)\) \[Theta]\ ' \((t)\)\)}]}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \(r(t)\), \(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la expresi\[OAcute]n de la velocidad en coordenadas \
esf\[EAcute]ricas. Podemos pedirle a Mathematica que lo compruebe. Para ello \
calculamos las componentes del vector velocidad respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              StyleBox[\(e\_r\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], ",", 
            RowBox[{
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], ",", 
            RowBox[{
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}]}], "}"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(R[t_] := r[t] er[t];\)\), "\n", 
    \({\(R'\)[t] . er[t], \(R'\)[t] . e\[Theta][t], \(R'\)[t] . e\[Phi][t]} // 
      Simplify\)}], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["r", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], ",", 
        RowBox[{\(r[t]\), " ", 
          RowBox[{
            SuperscriptBox["\[Theta]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{\(r[t]\), " ", \(Sin[\[Theta][t]]\), " ", 
          RowBox[{
            SuperscriptBox["\[Phi]", "\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Derivando la expresi\[OAcute]n anterior puedes comprobar que la aceleraci\
\[OAcute]n viene dada por:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{
                \((\(r'\)' \((t)\) - \(r(t)\) \[Theta]\ ' \((t)\)\^2 - 
                      \(r(t)\) \[Phi]' \(\((t)\)\^2\) sen\^2\ \(\[Theta](t)\))
                    \), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \((2  r' \((t)\) \[Theta]\ '\ \((t)\) + 
                    \(r(t)\) \(\[Theta]\ '\)\ ' \((t)\) - 
                    \(r(t)\) \[Phi]' \(\((t)\)\^2\) sen\ \(\[Theta](t)\)\ cos
                      \ \(\[Theta](t)\))\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \((2  r' \((t)\) \[Phi]' \((t)\)\ sen\ \(\[Theta](t)\) + 
              2 \( r(t)\) \[Phi]' \((t)\) \[Theta]\ ' \((t)\) cos\ 
                \(\[Theta](t)\) + 
              \(r(t)\) \(\[Phi]'\)' \((t)\) sen\ \(\[Theta](t)\))\), 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Volvamos a pedirle a Mathematica que lo compruebe calculando las \
componentes del vector aceleraci\[OAcute]n en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          FormBox[
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], ",", 
                RowBox[{
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}], ",", 
                RowBox[{
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], "}"}],
            "TraditionalForm"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({\(\(R'\)'\)[t] . er[t], \(\(R'\)'\)[t] . 
          e\[Theta][t], \(\(R'\)'\)[t] . e\[Phi][t]} // Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{\(-r[t]\), " ", 
            RowBox[{"(", 
              RowBox[{
                SuperscriptBox[
                  RowBox[{
                    SuperscriptBox["\[Theta]", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], "2"], "+", 
                RowBox[{\(Sin[\[Theta][t]]\^2\), " ", 
                  SuperscriptBox[
                    RowBox[{
                      SuperscriptBox["\[Phi]", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], "2"]}]}], 
              ")"}]}], "+", 
          RowBox[{
            SuperscriptBox["r", "\[Prime]\[Prime]",
              MultilineFunction->None], "[", "t", "]"}]}], ",", 
        RowBox[{
          RowBox[{"2", " ", 
            RowBox[{
              SuperscriptBox["r", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
            RowBox[{
              SuperscriptBox["\[Theta]", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{\(r[t]\), " ", 
            RowBox[{"(", 
              RowBox[{
                
                RowBox[{\(-Cos[\[Theta][t]]\), " ", \(Sin[\[Theta][t]]\), " ",
                   
                  SuperscriptBox[
                    RowBox[{
                      SuperscriptBox["\[Phi]", "\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], "2"]}], 
                "+", 
                RowBox[{
                  SuperscriptBox["\[Theta]", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], ")"}]}]}], 
        ",", 
        RowBox[{
          RowBox[{"2", " ", \(Sin[\[Theta][t]]\), " ", 
            RowBox[{
              SuperscriptBox["r", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
            RowBox[{
              SuperscriptBox["\[Phi]", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], "+", 
          RowBox[{\(r[t]\), " ", 
            RowBox[{"(", 
              RowBox[{
                RowBox[{"2", " ", \(Cos[\[Theta][t]]\), " ", 
                  RowBox[{
                    SuperscriptBox["\[Theta]", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox["\[Phi]", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{\(Sin[\[Theta][t]]\), " ", 
                  RowBox[{
                    SuperscriptBox["\[Phi]", "\[Prime]\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}]}], 
              ")"}]}]}]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Nota",
    FontWeight->"Bold"],
  ". En algunos libros de f\[IAcute]sica se usa la notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(r\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " , ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], "=", 
          StyleBox[\(\[Theta]\&^\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Bold"], 
          OverscriptBox["\[Phi]", 
            StyleBox["^",
              FontWeight->"Bold"]]}], TraditionalForm]]],
  ".  "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expresi\[OAcute]n de la divergencia en cordenadas esf\[EAcute]ricas", 
  "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
            "=", \((\(f\_1\)(x, y, z), \(f\_2\)(x, y, z), \(f\_3\)(x, y, 
                z))\)}], " "}], TraditionalForm]]],
  " un campo vectorial de tres variables. La divergencia de este campo es el \
campo escalar dado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"div", 
            FormBox[
              RowBox[{
                RowBox[{
                  StyleBox["f",
                    FontWeight->"Bold"], "(", \(x, y, z\), ")"}], 
                "=", \(\(\[PartialD]f\_1\/\[PartialD]x\) \((x, y, 
                      z)\) + \(\[PartialD]f\_2\/\[PartialD]y\) \((x, y, 
                      z)\)\)}],
              "TraditionalForm"]}], 
          "+", \(\(\[PartialD]f\_3\/\[PartialD]z\) \((x, y, z)\)\)}], 
        TraditionalForm]]],
  ". Consideremos la expresi\[OAcute]n de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], "=", 
        RowBox[{
          StyleBox["f",
            FontWeight->"Bold"], "(", \(r\ sen\ \[Theta]\ cos\ \[Phi]\ , 
          r\ sen\ \[Theta]\ sen\ \[Phi], r\ cos\ \[Theta]\), ")"}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y sean ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_r\)(r, \[Theta], \[Phi])\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(F\_\[Theta]\)(
        r, \[Theta], \[Phi])\)\(\ \)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Phi]\)(r, \[Theta], \[Phi])\)]],
  " las componentes de ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], 
        TraditionalForm]]],
  " respecto de la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ", esto es,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(r, \[Theta], \[Phi]\), ")"}], "=", 
          RowBox[{
            RowBox[{\(\(F\_r\)(r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Theta]\)(\[Rho], \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\(F\_\[Phi]\)(r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ". La expresi\[OAcute]n de la divergencia de ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas consiste en expresar la igualdad"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"div", " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            RowBox[{
              StyleBox["r",
                FontSlant->"Italic"], ",", "\[Theta]", ",", "\[Phi]"}], 
            ")"}]}], "=", 
        RowBox[{
          RowBox[{"div", " ", 
            StyleBox["f",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", "\n", "\t", 
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "1"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}], "+", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "2"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}], "+", "\[IndentingNewLine]", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  SubscriptBox[
                    StyleBox["f",
                      FontSlant->"Italic"], "3"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["z",
                    FontSlant->"Italic"]}]], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "en t\[EAcute]rminos de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_r\)(r, \[Theta], \[Phi]), 
      \(F\_\[Theta]\)(r, \[Theta], \[Phi]), 
      \(F\_\[Phi]\)(r, \[Theta], \[Phi])\)]],
  " y de sus derivadas parciales. El camino indirecto consistente en calcular \
derivadas parciales de ",
  Cell[BoxData[
      \(TraditionalForm\`F\_r\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\ \)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Phi]\)]],
  " para tratar de relacionarlas con ",
  Cell[BoxData[
      FormBox[
        RowBox[{"div", " ", 
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(r\ , \ \[Theta], \ \[Phi]\), 
            ")"}]}], TraditionalForm]]],
  " no se ve nada claro (puedes intentarlo para convencerte). Seguiremos el \
camino directo como hicimos para las coordenadas polares. Para ello \
expresaremos las componentes cartesianas del campo ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en funci\[OAcute]n de sus componentes ",
  Cell[BoxData[
      \(TraditionalForm\`F\_r\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(F\_\[Theta]\ \)\)]],
  "y ",
  Cell[BoxData[
      \(TraditionalForm\`F\_\[Phi]\)]],
  " en la base  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". La matriz del cambio de esta base a la base can\[OAcute]nica es la que \
tiene como columnas los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ","}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". En este proceso debemos considerar ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", \[Theta] y \[Phi] como funciones de ",
  Cell[BoxData[
      \(TraditionalForm\`x, \ y, \ z\)]],
  ". Los c\[AAcute]lculos son largos y es una gran ventaja disponer de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para hacerlos. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(r[x_, y_, z_] = \@\(x\^2 + y\^2 + z\^2\);\)\), "\n", 
    \(\(\[Theta][x_, y_, z_] = 
        ArcCos[z\/\@\(x\^2 + y\^2 + z\^2\)];\)\), "\n", 
    \(\(\[Phi][x_, y_, z_] = ArcTan[x, y];\)\), "\n", 
    \(\(er[x_, y_, z_] = er[\[Theta][x, y, z], \[Phi][x, y, z]];\)\), "\n", 
    \(\(e\[Theta][x_, y_, z_] = 
        e\[Theta][\[Theta][x, y, z], \[Phi][x, y, z]];\)\), "\n", 
    \(\(\(e\[Phi][x_, y_, z_] = 
        e\[Phi][\[Theta][x, y, z], \[Phi][x, y, z]];\)\(\n\)
    \)\t\t\), "\n", 
    \(\(B = 
        Transpose[{er[x, y, z], e\[Theta][x, y, z], 
            e\[Phi][x, y, z]}];\)\), "\n", 
    \(\(f1[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([1]\)];\)\), "\n", 
    \(\(f2[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([2]\)];\)\), "\n", 
    \(\(f3[x_, y_, 
          z_] = \((B . {F\_r[r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, z]], 
                F\_\[Theta][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]], \n\t\t\tF\_\[Phi][
                  r[x, y, z], \[Theta][x, y, z], \[Phi][x, y, 
                    z]]})\)[\([3]\)];\)\), "\n", 
    \(\((D[f1[x, y, z], x] + D[f2[x, y, z], y] + 
            D[f3[x, y, z], z] /. {x -> r*Cos[\[Phi]]*\ Sin[\[Theta]], 
            y -> r*\ Sin[\[Phi]]*\ Sin[\[Theta]], 
            z -> r*\ Cos[\[Theta]]\ })\) // Simplify\)}], "Input"],

Cell[BoxData[
    RowBox[{\(1\/r\), 
      RowBox[{"(", 
        RowBox[{\(2\ F\_r[r, \[Theta], \[Phi]]\), 
          "+", \(Cot[\[Theta]]\ F\_\[Theta][r, \[Theta], \[Phi]]\), "+", 
          RowBox[{\(Csc[\[Theta]]\), " ", 
            RowBox[{
              SuperscriptBox[\(F\_\[Phi]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}], "+", 
          RowBox[{
            SuperscriptBox[\(F\_\[Theta]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}], 
          "+", 
          RowBox[{"r", " ", 
            RowBox[{
              SuperscriptBox[\(F\_r\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["expresi\[OAcute]n que suele escribirse en la forma", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(1\/r\^2\) \[PartialD]\_r\((\ 
            r\^2*\ F\_r[r, \[Theta], \[Phi]])\) + \(1\/\(r*
              Sin[\[Theta]]\)\) \[PartialD]\_\[Theta]\ \((Sin[\[Theta]]*
              F\_\[Theta][r, \[Theta], \[Phi]])\) + \(1\/\(r*
              Sin[\[Theta]]\)\) \[PartialD]\_\[Phi] F\_\[Phi][
            r, \[Theta], \[Phi]]\)], "Input"],

Cell[BoxData[
    RowBox[{
      FractionBox[
        RowBox[{\(Csc[\[Theta]]\), " ", 
          RowBox[{
            SuperscriptBox[\(F\_\[Phi]\), 
              TagBox[\((0, 0, 1)\),
                Derivative],
              MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}]}],
         "r"], "+", 
      FractionBox[
        RowBox[{\(Csc[\[Theta]]\), " ", 
          RowBox[{"(", 
            
            RowBox[{\(Cos[\[Theta]]\ F\_\[Theta][r, \[Theta], \[Phi]]\), "+", 
              
              RowBox[{\(Sin[\[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox[\(F\_\[Theta]\), 
                    TagBox[\((0, 1, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
                  "]"}]}]}], ")"}]}], "r"], "+", 
      FractionBox[
        RowBox[{\(2\ r\ F\_r[r, \[Theta], \[Phi]]\), "+", 
          RowBox[{\(r\^2\), " ", 
            RowBox[{
              SuperscriptBox[\(F\_r\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}]}], \(r\^2\)]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Simplify[% == %%]\)\( (*\ 
      comprobamos\ que\ ambas\ expresiones\ son\ iguales\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Podemos usar comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " definidos en el paquete \"VectorAnalysis\" para obtener directamente el \
resultado anterior aunque, claro est\[AAcute], eso no te ayudar\[AAcute] a \
comprender el significado de dicho resultado."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Div[{F\_r[r\ , \[Theta], \[Phi]], F\_\[Theta][r\ , \[Theta], \[Phi]], 
          F\_\[Phi][r\ , \[Theta], \[Phi]]}, Spherical[r, \[Theta], \[Phi]]] // 
      Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{\(1\/r\), 
      RowBox[{"(", 
        RowBox[{\(2\ F\_r[r, \[Theta], \[Phi]]\), 
          "+", \(Cot[\[Theta]]\ F\_\[Theta][r, \[Theta], \[Phi]]\), "+", 
          RowBox[{\(Csc[\[Theta]]\), " ", 
            RowBox[{
              SuperscriptBox[\(F\_\[Phi]\), 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}], "+", 
          RowBox[{
            SuperscriptBox[\(F\_\[Theta]\), 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}], 
          "+", 
          RowBox[{"r", " ", 
            RowBox[{
              SuperscriptBox[\(F\_r\), 
                TagBox[\((1, 0, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}]}], ")"}]}]], "Output"]
}, Open  ]],

Cell["\<\
Tambi\[EAcute]n podemos calcular directamente el rotacional de un campo \
vectorial en coordenadas esf\[EAcute]ricas.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Curl[{F\_r[r\ , \[Theta], \[Phi]], F\_\[Theta][r\ , \[Theta], \[Phi]], 
          F\_\[Phi][r\ , \[Theta], \[Phi]]}, Spherical[r, \[Theta], \[Phi]]] // 
      Simplify\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        FractionBox[
          RowBox[{\(Cot[\[Theta]]\ F\_\[Phi][r, \[Theta], \[Phi]]\), "-", 
            RowBox[{\(Csc[\[Theta]]\), " ", 
              RowBox[{
                SuperscriptBox[\(F\_\[Theta]\), 
                  TagBox[\((0, 0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
                "]"}]}], "+", 
            RowBox[{
              SuperscriptBox[\(F\_\[Phi]\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}], "r"], ",", 
        RowBox[{"-", 
          FractionBox[
            RowBox[{\(F\_\[Phi][r, \[Theta], \[Phi]]\), "-", 
              RowBox[{\(Csc[\[Theta]]\), " ", 
                RowBox[{
                  SuperscriptBox[\(F\_r\), 
                    TagBox[\((0, 0, 1)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
                  "]"}]}], "+", 
              RowBox[{"r", " ", 
                RowBox[{
                  SuperscriptBox[\(F\_\[Phi]\), 
                    TagBox[\((1, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
                  "]"}]}]}], "r"]}], ",", 
        FractionBox[
          RowBox[{\(F\_\[Theta][r, \[Theta], \[Phi]]\), "-", 
            RowBox[{
              SuperscriptBox[\(F\_r\), 
                TagBox[\((0, 1, 0)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}],
             "+", 
            RowBox[{"r", " ", 
              RowBox[{
                SuperscriptBox[\(F\_\[Theta]\), 
                  TagBox[\((1, 0, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
                "]"}]}]}], "r"]}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Calcula la expresi\[OAcute]n del rotacional de un campo vectorial en \
coordenadas esf\[EAcute]ricas. Debes hacer t\[UAcute] los c\[AAcute]lculos y \
no usar los comandos espec\[IAcute]ficos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que se definen en el paquete \"VectorAnalysis\"."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Gradiente y elemento diferencial de longitud en coordenadas esf\[EAcute]ricas\
\
\>", "Subsection"],

Cell[TextData[{
  "Sea ",
  StyleBox["f",
    FontSlant->"Italic"],
  " un campo escalar de tres variables. Sabemos que el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  es el campo vectorial dado por "
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]\(f(x, y, z)\)\), "=", 
          RowBox[{
            RowBox[{\(\[PartialD]f\/\[PartialD]x\), \((x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(\[PartialD]f\/\[PartialD]y\), \((x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ".  "
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La expresi\[OAcute]n del gradiente de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "en esf\[EAcute]ricas viene dada por"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[Del]", 
          RowBox[{"f", "(", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "cos", " ", "\[Phi]"}], " ", ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "sen", " ", "\[Phi]"}], ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], "=", 
        RowBox[{
          RowBox[{\(\(f\_r\)(r, \[Theta], \[Phi])\), 
            StyleBox[\(e\_r\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(f\_\[Theta]\)(\[Rho], \[Theta], \[Phi])\), 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{\(\(f\_\[Phi]\)(r, \[Theta], \[Phi])\), 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Rho]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Theta]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f\_\[Phi]\)]],
  " son las componentes del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Del]f\), 
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "cos", " ", "\[Phi]"}], " ", ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                "sen", " ", "\[Phi]"}], ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], TraditionalForm]]],
  " en la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". En consecuencia se trata de hacer un simple cambio de coordenadas de la \
base can\[OAcute]nica a la base ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  ". La matriz de este cambio de base es la matriz inversa de la que tiene \
por columnas los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ", es decir, la matriz ",
  Cell[BoxData[
      FormBox[
        RowBox[{"M", "=", 
          RowBox[{"Inverse", "[", 
            RowBox[{"Transpose", "[", 
              FormBox[
                RowBox[{"{", 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], ",", 
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], ",", 
                    StyleBox[\(e\_\[Phi]\),
                      FontWeight->"Bold"]}], "}"}],
                "TraditionalForm"], "]"}], "]"}]}], TraditionalForm]]],
  "  y, como los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " son ortonormales dos a dos, se verifca que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"Transpose", "[", 
            FormBox[
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"]}], "}"}],
              "TraditionalForm"], "]"}], "=", 
          RowBox[{"Inverse", "[", 
            FormBox[
              RowBox[{"{", 
                RowBox[{
                  StyleBox[\(e\_r\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Theta]\),
                    FontWeight->"Bold"], ",", 
                  StyleBox[\(e\_\[Phi]\),
                    FontWeight->"Bold"]}], "}"}],
              "TraditionalForm"], "]"}]}], TraditionalForm]]],
  ", en consecuencia, M=",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            StyleBox[\(e\_r\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], ",", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}], "}"}], TraditionalForm]]],
  " es la matriz cuyos vectores fila son ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(e\_r\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Theta]\),
            FontWeight->"Bold"], ",", 
          StyleBox[\(e\_\[Phi]\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  ". Procura entender lo que sigue."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(gradf[x_, y_, z_] = {D[f[x, y, z], x], D[f[x, y, z], y], 
          D[f[x, y, z], z]};\)\), "\n", 
    \(\(reglas = {x -> r\ \ Cos[\[Phi]] Sin[\[Theta]], 
          y -> r\ \ Sin[\[Phi]] Sin\ [\[Theta]], 
          z -> r\ Cos[\[Theta]]};\)\), "\n", 
    \(\(M = {er[\[Theta], \[Phi]], e\[Theta][\[Theta], \[Phi]], 
          e\[Phi][\[Theta], \[Phi]]};\)\), "\n", 
    \(fr[r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([1]\)] /. 
            reglas)\) // Simplify\), "\n", 
    \(f\[Theta][
        r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([2]\)] /. 
            reglas)\) // Simplify\), "\n", 
    \(f\[Phi][
        r_, \[Theta]_, \[Phi]_] = \((\((M . gradf[x, y, z])\)[\([3]\)] /. 
            reglas)\) // Simplify\)}], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Cos[\[Theta]]\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}], "+", 
      RowBox[{\(Sin[\[Theta]]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{\(Sin[\[Phi]]\), " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1, 0)\),
                    Derivative],
                  MultilineFunction->None], 
                "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
                r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}], 
            "+", 
            RowBox[{\(Cos[\[Phi]]\), " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0, 0)\),
                    Derivative],
                  MultilineFunction->None], 
                "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
                r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}]}], 
          ")"}]}]}]], "Output"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(-Sin[\[Theta]]\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((0, 0, 1)\),
              Derivative],
            MultilineFunction->None], "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}], "+", 
      RowBox[{\(Cos[\[Theta]]\), " ", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{\(Sin[\[Phi]]\), " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1, 0)\),
                    Derivative],
                  MultilineFunction->None], 
                "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
                r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}], 
            "+", 
            RowBox[{\(Cos[\[Phi]]\), " ", 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0, 0)\),
                    Derivative],
                  MultilineFunction->None], 
                "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
                r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}]}], 
          ")"}]}]}]], "Output"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Cos[\[Phi]]\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((0, 1, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), "]"}]}], "-", 
      RowBox[{\(Sin[\[Phi]]\), " ", 
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(r\ Cos[\[Phi]]\ Sin[\[Theta]], 
          r\ Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\), 
          "]"}]}]}]], "Output"]
}, Open  ]],

Cell["\<\
Observando estos resultados nos damos cuenta de que pueden expresarse m\
\[AAcute]s f\[AAcute]cilmente como sigue.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Simplify[
      fr[r, \[Theta], \[Phi]] == 
        D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
            r\ Cos[\[Theta]]], r]]\), "\n", 
    \(Simplify[
      f\[Theta][r, \[Theta], \[Phi]] == \(1\/r\) 
          D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
              r\ Cos[\[Theta]]], \[Theta]]]\), "\n", 
    \(Simplify[
      f\[Phi][r, \[Theta], \[Phi]] == \(1\/\(r\ Sin[\[Theta]]\)\) 
          D[f[r\ Cos[\[Phi]]\ Sin[\[Theta]], r\ Sin[\[Theta]]\ Sin[\[Phi]], 
              r\ Cos[\[Theta]]], \[Phi]]]\)}], "Input"],

Cell[BoxData[
    \(True\)], "Output"],

Cell[BoxData[
    \(True\)], "Output"],

Cell[BoxData[
    \(True\)], "Output"]
}, Open  ]],

Cell["Hemos obtenido as\[IAcute] que", "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Del]", 
            RowBox[{"f", "(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", 
          RowBox[{
            RowBox[{\(\[PartialD]\/\[PartialD]r\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(1\/r\), \(\[PartialD]\/\[PartialD]\[Theta]\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]\/\[PartialD]\
\[Phi]\), 
              RowBox[{"f", "(", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "cos", " ", "\[Phi]"}], " ", ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                    "sen", " ", "\[Phi]"}], ",", 
                  RowBox[{
                    StyleBox["r",
                      FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
                ")"}], 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es conveniente introducir la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(h(r, \[Theta], \[Phi])\), "=", 
          RowBox[{"f", "(", 
            RowBox[{
            \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
              \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
              RowBox[{
                StyleBox["r",
                  FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
            ")"}]}], TraditionalForm]]],
  " con lo que la igualdad anterior se escribe mejor en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Del]", 
            RowBox[{"f", "(", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "cos", " ", "\[Phi]"}], " ", ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "sen", " ", "\[Theta]", " ", 
                  "sen", " ", "\[Phi]"}], ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}], "=", 
          RowBox[{
            
            RowBox[{\(\[PartialD]h\/\[PartialD]r\), \((r, \[Theta], \[Phi])\),
               
              StyleBox[\(e\_r\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/r\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((r, \
\[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Theta]\),
                FontWeight->"Bold"]}], "+", 
            
            RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]h\/\[PartialD]\
\[Phi]\), \((r, \[Theta], \[Phi])\), 
              StyleBox[\(e\_\[Phi]\),
                FontWeight->"Bold"], "\t\t"}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En los textos de f\[IAcute]sica es frecuente que no se distinga entre la \
funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n ",
  StyleBox["h",
    FontSlant->"Italic"],
  " (pues, en definitiva, son la ",
  StyleBox["misma funci\[OAcute]n ",
    FontSlant->"Italic"],
  "expresada en ",
  StyleBox["distintas",
    FontSlant->"Italic"],
  " coordenadas) y que escriban la igualdad anterior en la forma"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{\(\[Del]f\), "=", 
            RowBox[{
              RowBox[{\(\[PartialD]f\/\[PartialD]r\), 
                StyleBox[\(e\_r\),
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(1\/r\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                StyleBox[\(e\_\[Theta]\),
                  FontWeight->"Bold"]}], "+", 
              
              RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \
\(\[PartialD]f\/\[PartialD]\[Phi]\), 
                SubscriptBox[
                  StyleBox["e",
                    FontWeight->"Bold"], "\[Phi]"], "   \t"}]}]}],
          "TraditionalForm"]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
igualdad que constituye la \"expresi\[OAcute]n del gradiente en cordenadas \
esf\[EAcute]ricas\". \
\>", "Text"],

Cell[TextData[{
  "Podemos comprobarlo con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Grad[f[r, \[Theta], \[Phi]], 
      Spherical[r, \[Theta], \[Phi]]]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["f", 
            TagBox[\((1, 0, 0)\),
              Derivative],
            MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}], 
        ",", 
        FractionBox[
          RowBox[{
            SuperscriptBox["f", 
              TagBox[\((0, 1, 0)\),
                Derivative],
              MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), "]"}], 
          "r"], ",", 
        FractionBox[
          RowBox[{\(Csc[\[Theta]]\), " ", 
            RowBox[{
              SuperscriptBox["f", 
                TagBox[\((0, 0, 1)\),
                  Derivative],
                MultilineFunction->None], "[", \(r, \[Theta], \[Phi]\), 
              "]"}]}], "r"]}], "}"}]], "Output"]
}, Open  ]],

Cell[TextData[{
  "Observa que en la expresi\[OAcute]n anterior del gradiente aparecen los \
inversos de los factores de escala multiplicando a las derivadas parciales a \
las que est\[AAcute] asociado cada uno de ellos. Como sabes, los factores de \
escala son ",
  Cell[BoxData[
      \(TraditionalForm\`{1, r, r\ sen\ \[Theta]}\)]],
  "; el primero de ellos, 1, est\[AAcute] asociado a la primera columna de la \
matriz jacobiana del cambio de coordenadas que corresponde a la derivaci\
\[OAcute]n parcial respecto a la primera variable, r; el segundo de ellos, ",
  StyleBox["r",
    FontSlant->"Italic"],
  ", est\[AAcute] asociado a la segunda columna de la matriz jacobiana del \
cambio de coordenadas que corresponde a la derivaci\[OAcute]n parcial \
respecto a la segunda variable, \[Theta], el tercero de ellos, ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\ sen\ \[Theta], \)\)]],
  " est\[AAcute] asociado a la tercera columna de la matriz jacobiana del \
cambio de coordenadas que corresponde a la derivaci\[OAcute]n parcial \
respecto a la tercera variable, \[Phi]. "
}], "Text"],

Cell["\<\
Hemos visto antes que la velocidad en coordenadas esf\[EAcute]ricas se \
expresa por\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
              RowBox[{
                RowBox[{\(r'\), \((t)\), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                \(\(r(t)\) \[Theta]\ ' \((t)\)\)}]}],
            "TraditionalForm"], 
          RowBox[{
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
        RowBox[{
        \(r(t)\), \(\[Phi]'\), \((t)\), "sen", " ", \(\[Theta](t)\), " ", 
          RowBox[{
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]]], 
  "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad suele expresarse con notaci\[OAcute]n m\[AAcute]s \
cl\[AAcute]sica y tambi\[EAcute]n m\[AAcute]s confusa en la forma\
\>", "Text"],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"\[DifferentialD]", 
              FormBox[
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold"], "=", 
                  RowBox[{
                    RowBox[{\(\[DifferentialD]r\), " ", 
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"]}], "+", "r"}]}],
                "TraditionalForm"]}], \(\[DifferentialD]\[Theta]\), " ", 
            StyleBox[\(e\_\[Theta]\),
              FontWeight->"Bold"]}], "+", 
          RowBox[{
          "r", " ", "sen", " ", "\[Theta]", " ", \(\[DifferentialD]\[Phi]\), 
            " ", 
            StyleBox[\(e\_\[Phi]\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  "\t\t(5)"
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "(no te quepa duda, esta igualdad quiere decir exactamente lo mismo que la \
anterior pero en los libros de f\[IAcute]sica acostumbran a escribirla as\
\[IAcute]). Aqu\[IAcute] vuelven a aparecer los factores de escala ",
  Cell[BoxData[
      \(TraditionalForm\`1, \ r, \ r\ sen\ \[Theta]\)]],
  " multiplicando a las correspondientes \"diferenciales\" ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]\[Rho]\ , \[DifferentialD]\[Theta], 
      \ \[DifferentialD]\[Phi]\)]],
  ". La igualdad anterior es la expresi\[OAcute]n del \"elemento diferencial \
de longitud\" en coordenadas esf\[EAcute]ricas. "
}], "Text"],

Cell[TextData[{
  "Si hacemos el producto escalar ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]\[Del]f | 
          \[DifferentialD]r\[RightAngleBracket]\)]],
  " usando las igualdades anteriores obtenemos lo que sigue:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[LeftAngleBracket]\[Del]f | \[DifferentialD]r\
\[RightAngleBracket]\), "=", 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{\(\[PartialD]f\/\[PartialD]r\), 
                      StyleBox[\(e\_r\),
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{\(1\/r\), \(\[PartialD]f\/\[PartialD]\[Theta]\), 
                      StyleBox[\(e\_\[Theta]\),
                        FontWeight->"Bold"]}], "+", 
                    
                    RowBox[{\(1\/\(r\ sen\ \[Theta]\)\), \(\[PartialD]f\/\
\[PartialD]\[Phi]\), 
                      SubscriptBox[
                        StyleBox["e",
                          FontWeight->"Bold"], "\[Phi]"]}]}],
                  "TraditionalForm"], "|", 
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[
                        RowBox[{
                          RowBox[{\(\[DifferentialD]r\), " ", 
                            StyleBox[\(e\_r\),
                              FontWeight->"Bold"]}], "+", "r"}],
                        "TraditionalForm"], \(\[DifferentialD]\[Theta]\), " ",
                       
                      StyleBox[\(e\_\[Theta]\),
                        FontWeight->"Bold"]}], "+", 
                    RowBox[{
                    "r", " ", "sen", " ", "\[Theta]", 
                      " ", \(\[DifferentialD]\[Phi]\), " ", 
                      StyleBox[\(e\_\[Phi]\),
                        FontWeight->"Bold"]}]}],
                  "TraditionalForm"]}], "\[RightAngleBracket]"}], 
            "=", \(\(\[PartialD]f\/\[PartialD]r\) \[DifferentialD]r + \(\
\[PartialD]f\/\[PartialD]\[Theta]\) \[DifferentialD]\(\[Theta]++\) \(\
\[PartialD]f\/\[PartialD]\[Phi]\) \[DifferentialD]\[Phi]\)}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En esta igualdad se entiende que el gradiente est\[AAcute] calculado en \
puntos del camino ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  ". Con m\[AAcute]s detalle. Si ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Rho](t), \[Theta](t), \[Phi](t))\)\)]],
  " son las coordenadas esf\[EAcute]ricas del punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  ", la igualdad anterior quiere decir lo siguiente:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"\[LeftAngleBracket]", 
          
          RowBox[{\(\[Del]\(f(\(r(t)\)\ cos\ \(\[Phi](t)\) 
                  sen\ \(\[Theta](t)\), \ \(r(t)\)\ sen\ \(\[Phi](t)\) 
                  sen\ \(\[Theta](t)\), \(r(t)\) cos\ \(\[Theta](t)\))\)\), 
            "|", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], \((t)\)}]}], 
          "\[RightAngleBracket]"}], "=", 
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                
                RowBox[{\(\[PartialD]h\/\[PartialD]r\), \((r(t), \ \[Theta](
                      t), \[Phi](t))\), 
                  RowBox[{
                    StyleBox[\(e\_r\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(1\/\(r(
                        t)\)\), \(\[PartialD]h\/\[PartialD]\[Theta]\), \((r(
                      t), \ \[Theta](t), \[Phi](t))\), 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(1\/\(\(r(t)\)\ sen\ \(\[Theta](
                          t)\)\)\), \(\[PartialD]h\/\[PartialD]\[Phi]\), \((r(
                      t), \ \[Theta](t), \[Phi](t))\), 
                  SubscriptBox[
                    StyleBox["e",
                      FontWeight->"Bold"], "\[Phi]"]}]}], "|", 
              RowBox[{
                RowBox[{
                  FormBox[
                    RowBox[{
                      RowBox[{\(r'\), \((t)\), 
                        RowBox[{
                          StyleBox[\(e\_r\),
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(\(r(t)\) \[Theta]\ ' \((t)\)\)}],
                    "TraditionalForm"], 
                  RowBox[{
                    StyleBox[\(e\_\[Theta]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                
                RowBox[{\(r(t)\), \(\[Phi]'\), \((t)\), "sen", 
                  " ", \(\[Theta](t)\), " ", 
                  RowBox[{
                    StyleBox[\(e\_\[Phi]\),
                      FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
            "\[RightAngleBracket]"}], "=", "\n", 
          "\t\t", \(\(\[PartialD]h\/\[PartialD]r\) \((r(t), \ \[Theta](
                    t), \[Phi](t))\) 
                r' \((t)\) + \(\[PartialD]h\/\[PartialD]\[Theta]\) \((r(
                    t), \ \[Theta](t), \[Phi](
                    t))\) \[Theta]\ ' \((t)\) + \(\[PartialD]h\/\[PartialD]\
\[Phi]\) \((r(t), \ \[Theta](t), \[Phi](
                    t))\) \[Phi]\ ' \((t)\) = \(\[DifferentialD]\/\
\[DifferentialD]t\) \(h(r(t), \ \[Theta](t), \[Phi](t))\)\)}]}], 
      TraditionalForm]], "Text"],

Cell["Deducimos que", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                RowBox[{
                  RowBox[{"\[Del]", 
                    StyleBox["f",
                      FontSlant->"Italic"]}], 
                  \((\(r \((t)\)\)\ cos\ \(\[Phi] \((t)\)\) sen\ 
                      \(\[Theta] \((t)\)\), \ 
                    \(r \((t)\)\)\ sen\ \(\[Phi] \((t)\)\) sen\ 
                      \(\[Theta] \((t)\)\), 
                    \(r \((t)\)\) cos\ \(\[Theta] \((t)\)\))\)}], "|", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold"], "'"}], \((t)\)}]}], 
              "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["h",
                FontSlant->"Italic"], 
              \((\[Rho] \((b)\), \[Theta] \((b)\), \[Phi] \((b)\))\)}], "-", 
            \(h \((\[Rho] \((a)\), \[Theta] \((a)\), \[Phi] \((a)\))\)\)}], 
          "=", "\n", "\t\t", 
          RowBox[{"=", 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], 
                \((r \((b)\)\ cos\ \[Theta] \((b)\)\ sen\ \[Phi] \((b)\), 
                  r \((b)\)\ sen\ \[Theta] \((b)\)\ sen\ \[Phi] \((b)\), 
                  r \((b)\)\ cos\ \[Phi] \((b)\))\)}], "-", 
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], 
                \((r \((a)\)\ cos\ \[Theta] \((a)\)\ sen\ \[Phi] \((a)\), 
                  r \((a)\)\ sen\ \[Theta] \((a)\)\ sen\ \[Phi] \((a)\), 
                  r \((a)\)\ cos\ \[Phi] \((a)\))\)}]}]}]}]}], TextForm]], 
  "Text"],

Cell["\<\
Expresi\[OAcute]n de la integral de l\[IAcute]nea de un gradiente en \
coordenadas esf\[EAcute]ricas que es completamente an\[AAcute]loga a la \
conocida para coordenadas cartesianas. \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Significado de los factores de escala", "Subsection"],

Cell[TextData[{
  "Consideremos la matriz jacobiana en un punto gen\[EAcute]rico ",
  Cell[BoxData[
      \(TraditionalForm\`\((r, \[Theta], \[Phi])\)\)]],
  " de la funci\[OAcute]n que introduce las coordenadas esf\[EAcute]ricas."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(S = \(matrizjacobiana3[g]\)[r, \[Theta], \[Phi]]\)], "Input"],

Cell[BoxData[
    \({{Cos[\[Phi]]\ Sin[\[Theta]], 
        r\ Cos[\[Theta]]\ Cos[\[Phi]], \(-r\)\ Sin[\[Theta]]\ Sin[\[Phi]]}, \
{Sin[\[Theta]]\ Sin[\[Phi]], r\ Cos[\[Theta]]\ Sin[\[Phi]], 
        r\ Cos[\[Phi]]\ Sin[\[Theta]]}, {Cos[\[Theta]], \(-r\)\ \
Sin[\[Theta]], 0}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Esta matriz define una aplicaci\[OAcute]n lineal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " que a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " hace corresponder el vector ",
  Cell[BoxData[
      \(TraditionalForm\`S . \((x, y, z)\)\)]],
  ". Calculemos la norma eucl\[IAcute]dea de la imagen de un vector en dicha \
transformaci\[OAcute]n. A veces ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se empe\[NTilde]a en simplificar de forma poco apropiada y hay que \
decirle que haga lo que nosotros queremos."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[
      Collect[Expand[
            Simplify[\((S . {x, y, z})\) . \((S . {x, y, z})\)]], \(z\^2\) 
            r\^2] /. \((1\/2 - 1\/2\ Cos[2\ \[Theta]])\) -> 
          Sin[\[Theta]]\^2]\)], "Input"],

Cell[BoxData[
    \(\@\(x\^2 + r\^2\ y\^2 + r\^2\ z\^2\ Sin[\[Theta]]\^2\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Deducimos que para vectores situados a lo largo del eje X, es decir, de la \
forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, 0, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((x, 0, 0)\)\) || \) = \( || \((x, 0, 0)\) || \)\)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " conserva distancias en el eje X. Pues bien, este es el significado de que \
el factor de escala asociado a la primera variable sea igual a 1.\nDeducimos \
tambi\[EAcute]n que para vectores situados a lo largo del eje Y, es decir, de \
la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, y, 0)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((0, y, 0)\)\) || \) = r || \((0, y, 0)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " multiplica distancias por ",
  StyleBox["r",
    FontSlant->"Italic"],
  " en el eje Y. Pues bien, este es el significado de que el factor de escala \
asociado a la segunda variable sea igual a ",
  StyleBox["r",
    FontSlant->"Italic"],
  ".\nDeducimos tambi\[EAcute]n que para vectores situados a lo largo del eje \
Z, es decir, de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 0, z)\)\)]],
  ", se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || S . \((0, 0, z)\)\) || \) = 
        r\ sen\ \[Theta] || \((0, 0, z)\) || \)]],
  " y, teniendo en cuenta la linealidad, se sigue que la aplicaci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\) \[Rule] S . \((x, y, z)\)\)]],
  " multiplica distancias por ",
  Cell[BoxData[
      \(TraditionalForm\`r\ sen\ \[Theta]\)]],
  " en el eje Z. Pues bien, este es el significado de que el factor de escala \
asociado a la tercera variable sea igual a ",
  Cell[BoxData[
      \(TraditionalForm\`r\ sen\ \(\[Theta] . \)\)]],
  "\nEn resumen, los factores de escala indican las dilataciones a lo largo \
de los ejes que hace la aplicaci\[OAcute]n lineal asociada a la matriz \
jacobiana de la aplicaci\[OAcute]n",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\(g(r, \[Theta], \[Phi])\), "=", 
            RowBox[{"(", 
              RowBox[{
              \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
                \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                RowBox[{
                  StyleBox["r",
                    FontSlant->"Italic"], " ", "cos", " ", "\[Theta]"}]}], 
              ")"}]}]}], TraditionalForm]]],
  ". Suele decirse que la aplicaci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " es la que, a ",
  StyleBox["escala infinitesimal",
    FontSlant->"Italic"],
  ", produce esas dilataciones. Observa que la expresi\[OAcute]n del \
\"elemento diferencial de longitud\" en coordenadas esf\[EAcute]ricas tiene \
en cuenta dichos factores de escala. "
}], "Text"],

Cell[TextData[{
  "Al igual que cada factor de escala mide la dilataci\[OAcute]n \
infinitesimal a lo largo de un eje, el producto de los factores de escala, en \
nuestro caso ",
  Cell[BoxData[
      \(TraditionalForm\`r\^2\ sen\ \[Theta]\)]],
  ", mide el cambio en el volumen de un ortoedro a escala infinitesimal. El \
producto de los factores de escala es justamente el determinante jacobiano. \
Recuerda que la f\[OAcute]rmula del cambio de variables a coordenadas esf\
\[EAcute]ricas en una integral triple afirma que si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar continuo en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^3\)]],
  " se verifica que\t\t"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(\[Integral]\(\[Integral]\(\[Integral]\_A\( f(x, y, z)\) \(d(
                    x, y, z)\)\)\)\), "=", 
          RowBox[{"\[Integral]", 
            RowBox[{"\[Integral]", 
              RowBox[{\(\[Integral]\_B\), " ", 
                RowBox[{
                  RowBox[{"f", "(", 
                    
                    RowBox[{\(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", 
                      ",", \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                      RowBox[{
                        StyleBox["r",
                          FontSlant->"Italic"], " ", "cos", " ", 
                        "\[Theta]"}]}], ")"}], \(\(\(r\)\(\ \)\)\^2\), "sen", 
                  " ", "\[Theta]", " ", "d", \((r, \[Theta], \[Phi])\), 
                  " "}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"B", "=", 
            RowBox[{"{", 
              RowBox[{\((r, \[Theta], \[Phi])\), ":", 
                RowBox[{
                  FormBox[
                    RowBox[{"(", 
                      RowBox[{
                      \(r\ sen\ \[Theta]\ cos\ \[Phi]\), " ", ",", 
                        \(r\ sen\ \[Theta]\ sen\ \[Phi]\), ",", 
                        RowBox[{
                          StyleBox["r",
                            FontSlant->"Italic"], " ", "cos", " ", 
                          "\[Theta]"}]}], ")"}],
                    "TraditionalForm"], "\[Element]", " ", "A"}]}], 
              "}"}]}]}], TraditionalForm]]],
  ". Observa que ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es la expresi\[OAcute]n del conjunto ",
  StyleBox["A",
    FontSlant->"Italic"],
  " en coordenadas esf\[EAcute]ricas, es decir ",
  Cell[BoxData[
      \(TraditionalForm\`A = g(B)\)]],
  ", y que en la segunda integral se multiplica por ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(r\ \)\^2\) sen\ \[Theta]\)]],
  ". Si particularizamos la igualdad anterior para la funci\[OAcute]n \
constante ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 1\)]],
  " obtenemos"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{\(Volumen \((g(B))\)\), "=", 
          
          FormBox[\(\[Integral]\(\[Integral]\(\[Integral]\_A 
                      1 \( d(x, 
                        y)\)\)\) = \[Integral]\(\[Integral]\(\[Integral]\_B\ \
\(\(\(r\)\(\ \)\)\^2\) sen\ \[Theta]\ \(d(r, \[Theta], \[Phi])\)\)\)\),
            "TraditionalForm"], " "}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si ",
  StyleBox["B",
    FontSlant->"Italic"],
  " es un ortoedro muy peque\[NTilde]o (un ortoedro ",
  StyleBox["infinitesimal",
    FontSlant->"Italic"],
  ") se verifica que "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\(\[Integral]\(\[Integral]\_B\ \(\(\(r\)\(\ \
\)\)\^2\) sen\ \[Theta]\ \(d(
                  r, \[Theta], \[Phi])\)\)\)\  \[TildeEqual] \ \ \(\(\(r\)\(\ \
\)\)\^2\) 
          sen\ \[Theta] \(\[Integral]\(\[Integral]\(\[Integral]\_B\ 
                d(\[Rho], \[Theta])\)\)\) = \ \(\(\(r\)\(\ \)\)\^2\) 
        sen\ \[Theta]\ \(Volumen(B)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  " y obtenemos ",
  Cell[BoxData[
      \(TraditionalForm\`Volumen(
          g(B))\  \[TildeEqual] \ \ \(\(\(r\)\(\ \)\)\^2\) 
          sen\ \[Theta]\ \(Volumen(B)\)\)]],
  ". ",
  "Suele decirse que ",
  Cell[BoxData[
      \(TraditionalForm\`\(r\^2\) 
        sen\ \[Theta] \[DifferentialD]r \[DifferentialD]\[Theta] \(\(\
\[DifferentialD]\)\(\[Phi]\)\(\ \)\)\)]],
  "es el \"elemento diferencial de volumen\" en coordenadas \
esf\[EAcute]ricas. "
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando que proporciona los factores de escala."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ScaleFactors[{r, \[Theta], \[Phi]}, 
      Spherical[r, \[Theta], \[Phi]]]\)], "Input"],

Cell[BoxData[
    \({1, r, r\ Sin[\[Theta]]}\)], "Output"]
}, Open  ]],

Cell["\<\
Para terminar con las coordenadas esf\[EAcute]ricas ejecuta la siguiente \
celda para ver una animaci\[OAcute]n gr\[AAcute]fica en la que aparecen las \
superficies transformadas de los planos coordenados y se muestra c\[OAcute]mo \
un punto en coordenadas esf\[EAcute]ricas se sit\[UAcute]a mediante la \
intersecci\[OAcute]n de dichas superficies.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(esfericasmovie;\)\)], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
%%ImageSize: 527.25 404.375 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.12828e-017 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.966 .687 .452 r
.61863 .55097 m .62157 .54995 L .61233 .52311 L p F P
0 g
s
.966 .687 .452 r
.62157 .54995 m .61863 .55097 L .62662 .57731 L p F P
0 g
s
.966 .687 .452 r
.62662 .57731 m .62982 .57713 L .62157 .54995 L p F P
0 g
s
.966 .687 .452 r
.62982 .57713 m .62662 .57731 L .63356 .60377 L p F P
0 g
s
.966 .687 .452 r
.63356 .60377 m .63699 .60443 L .62982 .57713 L p F P
0 g
s
.966 .687 .452 r
.60967 .52496 m .61233 .52311 L .60216 .49683 L p F P
0 g
s
.966 .687 .452 r
.61233 .52311 m .60967 .52496 L .61863 .55097 L p F P
0 g
s
.966 .687 .452 r
.63699 .60443 m .63356 .60377 L .63941 .63013 L p F P
0 g
s
.966 .687 .452 r
.63941 .63013 m .64304 .63164 L .63699 .60443 L p F P
0 g
s
.966 .687 .452 r
.59981 .4995 m .60216 .49683 L .59113 .47132 L p F P
0 g
s
.966 .687 .452 r
.60216 .49683 m .59981 .4995 L .60967 .52496 L p F P
0 g
s
.966 .687 .452 r
.61566 .552 m .61863 .55097 L .60967 .52496 L p F P
0 g
s
.966 .687 .452 r
.61863 .55097 m .61566 .552 L .62339 .5775 L p F P
0 g
s
.966 .687 .452 r
.62339 .5775 m .62662 .57731 L .61863 .55097 L p F P
0 g
s
.966 .687 .452 r
.62662 .57731 m .62339 .5775 L .63011 .6031 L p F P
0 g
s
.966 .687 .452 r
.63011 .6031 m .63356 .60377 L .62662 .57731 L p F P
0 g
s
.966 .687 .452 r
.60699 .52683 m .60967 .52496 L .59981 .4995 L p F P
0 g
s
.966 .687 .452 r
.60967 .52496 m .60699 .52683 L .61566 .552 L p F P
0 g
s
.966 .687 .452 r
.64304 .63164 m .63941 .63013 L .6441 .65618 L p F P
0 g
s
.966 .687 .452 r
.6441 .65618 m .64789 .65853 L .64304 .63164 L p F P
0 g
s
.966 .687 .452 r
.63356 .60377 m .63011 .6031 L .63576 .62861 L p F P
0 g
s
.966 .687 .452 r
.63576 .62861 m .63941 .63013 L .63356 .60377 L p F P
0 g
s
.966 .687 .452 r
.58912 .47479 m .59113 .47132 L .57934 .44679 L p F P
0 g
s
.966 .687 .452 r
.59113 .47132 m .58912 .47479 L .59981 .4995 L p F P
0 g
s
.966 .687 .452 r
.59744 .50219 m .59981 .4995 L .58912 .47479 L p F P
0 g
s
.966 .687 .452 r
.59981 .4995 m .59744 .50219 L .60699 .52683 L p F P
0 g
s
.966 .687 .452 r
.61267 .55304 m .61566 .552 L .60699 .52683 L p F P
0 g
s
.966 .687 .452 r
.61566 .552 m .61267 .55304 L .62014 .57768 L p F P
0 g
s
.966 .687 .452 r
.62014 .57768 m .62339 .5775 L .61566 .552 L p F P
0 g
s
.966 .687 .452 r
.62339 .5775 m .62014 .57768 L .62663 .60243 L p F P
0 g
s
.966 .687 .452 r
.62663 .60243 m .63011 .6031 L .62339 .5775 L p F P
0 g
s
.966 .687 .452 r
.60429 .52871 m .60699 .52683 L .59744 .50219 L p F P
0 g
s
.966 .687 .452 r
.60699 .52683 m .60429 .52871 L .61267 .55304 L p F P
0 g
s
.966 .687 .452 r
.63941 .63013 m .63576 .62861 L .64028 .6538 L p F P
0 g
s
.966 .687 .452 r
.64028 .6538 m .6441 .65618 L .63941 .63013 L p F P
0 g
s
.966 .687 .452 r
.57934 .44679 m .57768 .45105 L .58912 .47479 L p F P
0 g
s
.966 .687 .452 r
.58709 .47829 m .58912 .47479 L .57768 .45105 L p F P
0 g
s
.966 .687 .452 r
.58912 .47479 m .58709 .47829 L .59744 .50219 L p F P
0 g
s
.966 .687 .452 r
.64789 .65853 m .6441 .65618 L .64757 .68168 L p F P
0 g
s
.966 .687 .452 r
.64757 .68168 m .6515 .68488 L .64789 .65853 L p F P
0 g
s
.966 .687 .452 r
.63011 .6031 m .62663 .60243 L .63208 .62708 L p F P
0 g
s
.966 .687 .452 r
.63208 .62708 m .63576 .62861 L .63011 .6031 L p F P
0 g
s
.966 .687 .452 r
.59505 .5049 m .59744 .50219 L .58709 .47829 L p F P
0 g
s
.966 .687 .452 r
.59744 .50219 m .59505 .5049 L .60429 .52871 L p F P
0 g
s
.966 .687 .452 r
.57768 .45105 m .57934 .44679 L .56686 .42348 L p F P
0 g
s
.966 .687 .452 r
.60966 .55409 m .61267 .55304 L .60429 .52871 L p F P
0 g
s
.966 .687 .452 r
.61267 .55304 m .60966 .55409 L .61687 .57787 L p F P
0 g
s
.966 .687 .452 r
.61687 .57787 m .62014 .57768 L .61267 .55304 L p F P
0 g
s
.966 .687 .452 r
.62014 .57768 m .61687 .57787 L .62312 .60175 L p F P
0 g
s
.966 .687 .452 r
.62312 .60175 m .62663 .60243 L .62014 .57768 L p F P
0 g
s
.966 .687 .452 r
.60157 .53061 m .60429 .52871 L .59505 .5049 L p F P
0 g
s
.966 .687 .452 r
.60429 .52871 m .60157 .53061 L .60966 .55409 L p F P
0 g
s
.966 .687 .452 r
.63576 .62861 m .63208 .62708 L .63643 .65142 L p F P
0 g
s
.966 .687 .452 r
.63643 .65142 m .64028 .6538 L .63576 .62861 L p F P
0 g
s
.966 .687 .452 r
.6441 .65618 m .64028 .6538 L .64362 .67847 L p F P
0 g
s
.966 .687 .452 r
.64362 .67847 m .64757 .68168 L .6441 .65618 L p F P
0 g
s
.966 .687 .452 r
.57768 .45105 m .57602 .45533 L .58709 .47829 L p F P
0 g
s
.966 .687 .452 r
.58504 .48181 m .58709 .47829 L .57602 .45533 L p F P
0 g
s
.966 .687 .452 r
.58709 .47829 m .58504 .48181 L .59505 .5049 L p F P
0 g
s
.966 .687 .452 r
.62663 .60243 m .62312 .60175 L .62837 .62553 L p F P
0 g
s
.966 .687 .452 r
.62837 .62553 m .63208 .62708 L .62663 .60243 L p F P
0 g
s
.966 .687 .452 r
.59265 .50764 m .59505 .5049 L .58504 .48181 L p F P
0 g
s
.966 .687 .452 r
.59505 .5049 m .59265 .50764 L .60157 .53061 L p F P
0 g
s
.966 .687 .452 r
.56686 .42348 m .56559 .42849 L .57768 .45105 L p F P
0 g
s
.966 .687 .452 r
.57602 .45533 m .57768 .45105 L .56559 .42849 L p F P
0 g
s
.966 .687 .452 r
.60663 .55514 m .60966 .55409 L .60157 .53061 L p F P
0 g
s
.966 .687 .452 r
.60966 .55409 m .60663 .55514 L .61357 .57806 L p F P
0 g
s
.966 .687 .452 r
.61357 .57806 m .61687 .57787 L .60966 .55409 L p F P
0 g
s
.966 .687 .452 r
.6515 .68488 m .64757 .68168 L .64979 .70643 L p F P
0 g
s
.966 .687 .452 r
.64979 .70643 m .65381 .71045 L .6515 .68488 L p F P
0 g
s
.966 .687 .452 r
.61687 .57787 m .61357 .57806 L .61959 .60107 L p F P
0 g
s
.966 .687 .452 r
.61959 .60107 m .62312 .60175 L .61687 .57787 L p F P
0 g
s
.966 .687 .452 r
.59883 .53252 m .60157 .53061 L .59265 .50764 L p F P
0 g
s
.966 .687 .452 r
.60157 .53061 m .59883 .53252 L .60663 .55514 L p F P
0 g
s
.966 .687 .452 r
.63208 .62708 m .62837 .62553 L .63256 .64901 L p F P
0 g
s
.966 .687 .452 r
.63256 .64901 m .63643 .65142 L .63208 .62708 L p F P
0 g
s
.966 .687 .452 r
.56559 .42849 m .56686 .42348 L .5538 .40158 L p F P
0 g
s
.966 .687 .452 r
.64028 .6538 m .63643 .65142 L .63964 .67523 L p F P
0 g
s
.966 .687 .452 r
.63964 .67523 m .64362 .67847 L .64028 .6538 L p F P
0 g
s
.966 .687 .452 r
.57602 .45533 m .57434 .45965 L .58504 .48181 L p F P
0 g
s
.966 .687 .452 r
.58299 .48536 m .58504 .48181 L .57434 .45965 L p F P
0 g
s
.966 .687 .452 r
.58504 .48181 m .58299 .48536 L .59265 .50764 L p F P
0 g
s
.966 .687 .452 r
.62312 .60175 m .61959 .60107 L .62464 .62398 L p F P
0 g
s
.966 .687 .452 r
.62464 .62398 m .62837 .62553 L .62312 .60175 L p F P
0 g
s
.966 .687 .452 r
.56559 .42849 m .56431 .43353 L .57602 .45533 L p F P
0 g
s
.966 .687 .452 r
.57434 .45965 m .57602 .45533 L .56431 .43353 L p F P
0 g
s
.966 .687 .452 r
.59023 .51039 m .59265 .50764 L .58299 .48536 L p F P
0 g
s
.966 .687 .452 r
.59265 .50764 m .59023 .51039 L .59883 .53252 L p F P
0 g
s
.966 .687 .452 r
.64757 .68168 m .64362 .67847 L .64574 .70238 L p F P
0 g
s
.966 .687 .452 r
.64574 .70238 m .64979 .70643 L .64757 .68168 L p F P
0 g
s
.966 .687 .452 r
.60357 .5562 m .60663 .55514 L .59883 .53252 L p F P
0 g
s
.966 .687 .452 r
.60663 .55514 m .60357 .5562 L .61025 .57825 L p F P
0 g
s
.966 .687 .452 r
.61025 .57825 m .61357 .57806 L .60663 .55514 L p F P
0 g
s
.966 .687 .452 r
.61357 .57806 m .61025 .57825 L .61604 .60038 L p F P
0 g
s
.966 .687 .452 r
.61604 .60038 m .61959 .60107 L .61357 .57806 L p F P
0 g
s
.966 .687 .452 r
.5538 .40158 m .55293 .40731 L .56559 .42849 L p F P
0 g
s
.966 .687 .452 r
.56431 .43353 m .56559 .42849 L .55293 .40731 L p F P
0 g
s
.966 .687 .452 r
.59606 .53444 m .59883 .53252 L .59023 .51039 L p F P
0 g
s
.966 .687 .452 r
.59883 .53252 m .59606 .53444 L .60357 .5562 L p F P
0 g
s
.966 .687 .452 r
.62837 .62553 m .62464 .62398 L .62866 .64659 L p F P
0 g
s
.966 .687 .452 r
.62866 .64659 m .63256 .64901 L .62837 .62553 L p F P
0 g
s
.966 .687 .452 r
.63643 .65142 m .63256 .64901 L .63564 .67198 L p F P
0 g
s
.966 .687 .452 r
.63564 .67198 m .63964 .67523 L .63643 .65142 L p F P
0 g
s
.966 .687 .452 r
.57434 .45965 m .57265 .46399 L .58299 .48536 L p F P
0 g
s
.966 .687 .452 r
.58091 .48894 m .58299 .48536 L .57265 .46399 L p F P
0 g
s
.966 .687 .452 r
.58299 .48536 m .58091 .48894 L .59023 .51039 L p F P
0 g
s
.966 .687 .452 r
.56431 .43353 m .56302 .4386 L .57434 .45965 L p F P
0 g
s
.966 .687 .452 r
.57265 .46399 m .57434 .45965 L .56302 .4386 L p F P
0 g
s
.966 .687 .452 r
.61959 .60107 m .61604 .60038 L .62088 .62242 L p F P
0 g
s
.966 .687 .452 r
.62088 .62242 m .62464 .62398 L .61959 .60107 L p F P
0 g
s
.966 .687 .452 r
.58779 .51316 m .59023 .51039 L .58091 .48894 L p F P
0 g
s
.966 .687 .452 r
.59023 .51039 m .58779 .51316 L .59606 .53444 L p F P
0 g
s
.966 .687 .452 r
.64362 .67847 m .63964 .67523 L .64166 .69831 L p F P
0 g
s
.966 .687 .452 r
.64166 .69831 m .64574 .70238 L .64362 .67847 L p F P
0 g
s
.966 .687 .452 r
.65381 .71045 m .64979 .70643 L .6507 .73018 L p F P
0 g
s
.966 .687 .452 r
.6507 .73018 m .65478 .73501 L .65381 .71045 L p F P
0 g
s
.966 .687 .452 r
.55293 .40731 m .55206 .41308 L .56431 .43353 L p F P
0 g
s
.966 .687 .452 r
.56302 .4386 m .56431 .43353 L .55206 .41308 L p F P
0 g
s
.966 .687 .452 r
.60049 .55727 m .60357 .5562 L .59606 .53444 L p F P
0 g
s
.966 .687 .452 r
.60357 .5562 m .60049 .55727 L .6069 .57844 L p F P
0 g
s
.966 .687 .452 r
.6069 .57844 m .61025 .57825 L .60357 .5562 L p F P
0 g
s
.966 .687 .452 r
.55293 .40731 m .5538 .40158 L .54025 .38132 L p F P
0 g
s
.966 .687 .452 r
.61025 .57825 m .6069 .57844 L .61245 .59969 L p F P
0 g
s
.966 .687 .452 r
.61245 .59969 m .61604 .60038 L .61025 .57825 L p F P
0 g
s
.966 .687 .452 r
.59328 .53638 m .59606 .53444 L .58779 .51316 L p F P
0 g
s
.966 .687 .452 r
.59606 .53444 m .59328 .53638 L .60049 .55727 L p F P
0 g
s
.966 .687 .452 r
.62464 .62398 m .62088 .62242 L .62474 .64415 L p F P
0 g
s
.966 .687 .452 r
.62474 .64415 m .62866 .64659 L .62464 .62398 L p F P
0 g
s
.966 .687 .452 r
.63256 .64901 m .62866 .64659 L .63161 .6687 L p F P
0 g
s
.966 .687 .452 r
.63161 .6687 m .63564 .67198 L .63256 .64901 L p F P
0 g
s
.966 .687 .452 r
.57265 .46399 m .57095 .46836 L .58091 .48894 L p F P
0 g
s
.966 .687 .452 r
.57882 .49254 m .58091 .48894 L .57095 .46836 L p F P
0 g
s
.966 .687 .452 r
.58091 .48894 m .57882 .49254 L .58779 .51316 L p F P
0 g
s
.966 .687 .452 r
.56302 .4386 m .56172 .44371 L .57265 .46399 L p F P
0 g
s
.966 .687 .452 r
.57095 .46836 m .57265 .46399 L .56172 .44371 L p F P
0 g
s
.966 .687 .452 r
.61604 .60038 m .61245 .59969 L .6171 .62084 L p F P
0 g
s
.966 .687 .452 r
.6171 .62084 m .62088 .62242 L .61604 .60038 L p F P
0 g
s
.966 .687 .452 r
.64979 .70643 m .64574 .70238 L .64659 .72532 L p F P
0 g
s
.966 .687 .452 r
.64659 .72532 m .6507 .73018 L .64979 .70643 L p F P
0 g
s
.966 .687 .452 r
.58534 .51595 m .58779 .51316 L .57882 .49254 L p F P
0 g
s
.966 .687 .452 r
.58779 .51316 m .58534 .51595 L .59328 .53638 L p F P
0 g
s
.966 .687 .452 r
.63964 .67523 m .63564 .67198 L .63757 .69422 L p F P
0 g
s
.966 .687 .452 r
.63757 .69422 m .64166 .69831 L .63964 .67523 L p F P
0 g
s
.966 .687 .452 r
.55206 .41308 m .55118 .41889 L .56302 .4386 L p F P
0 g
s
.966 .687 .452 r
.56172 .44371 m .56302 .4386 L .55118 .41889 L p F P
0 g
s
.966 .687 .452 r
.54025 .38132 m .5398 .38774 L .55293 .40731 L p F P
0 g
s
.966 .687 .452 r
.55206 .41308 m .55293 .40731 L .5398 .38774 L p F P
0 g
s
.966 .687 .452 r
.59739 .55835 m .60049 .55727 L .59328 .53638 L p F P
0 g
s
.966 .687 .452 r
.60049 .55727 m .59739 .55835 L .60353 .57863 L p F P
0 g
s
.966 .687 .452 r
.60353 .57863 m .6069 .57844 L .60049 .55727 L p F P
0 g
s
.966 .687 .452 r
.6069 .57844 m .60353 .57863 L .60884 .59899 L p F P
0 g
s
.966 .687 .452 r
.60884 .59899 m .61245 .59969 L .6069 .57844 L p F P
0 g
s
.966 .687 .452 r
.62866 .64659 m .62474 .64415 L .62755 .6654 L p F P
0 g
s
.966 .687 .452 r
.62755 .6654 m .63161 .6687 L .62866 .64659 L p F P
0 g
s
.966 .687 .452 r
.62088 .62242 m .6171 .62084 L .62078 .6417 L p F P
0 g
s
.966 .687 .452 r
.62078 .6417 m .62474 .64415 L .62088 .62242 L p F P
0 g
s
.966 .687 .452 r
.59048 .53834 m .59328 .53638 L .58534 .51595 L p F P
0 g
s
.966 .687 .452 r
.59328 .53638 m .59048 .53834 L .59739 .55835 L p F P
0 g
s
.966 .687 .452 r
.57095 .46836 m .56923 .47276 L .57882 .49254 L p F P
0 g
s
.966 .687 .452 r
.57672 .49616 m .57882 .49254 L .56923 .47276 L p F P
0 g
s
.966 .687 .452 r
.57882 .49254 m .57672 .49616 L .58534 .51595 L p F P
0 g
s
.966 .687 .452 r
.56172 .44371 m .56042 .44885 L .57095 .46836 L p F P
0 g
s
.966 .687 .452 r
.56923 .47276 m .57095 .46836 L .56042 .44885 L p F P
0 g
s
.966 .687 .452 r
.64574 .70238 m .64166 .69831 L .64246 .72044 L p F P
0 g
s
.966 .687 .452 r
.64246 .72044 m .64659 .72532 L .64574 .70238 L p F P
0 g
s
.966 .687 .452 r
.63564 .67198 m .63161 .6687 L .63344 .6901 L p F P
0 g
s
.966 .687 .452 r
.63344 .6901 m .63757 .69422 L .63564 .67198 L p F P
0 g
s
.966 .687 .452 r
.61245 .59969 m .60884 .59899 L .61328 .61925 L p F P
0 g
s
.966 .687 .452 r
.61328 .61925 m .6171 .62084 L .61245 .59969 L p F P
0 g
s
.966 .687 .452 r
.58286 .51876 m .58534 .51595 L .57672 .49616 L p F P
0 g
s
.966 .687 .452 r
.58534 .51595 m .58286 .51876 L .59048 .53834 L p F P
0 g
s
.966 .687 .452 r
.5398 .38774 m .53936 .3942 L .55206 .41308 L p F P
0 g
s
.966 .687 .452 r
.55118 .41889 m .55206 .41308 L .53936 .3942 L p F P
0 g
s
.966 .687 .452 r
.55118 .41889 m .55029 .42472 L .56172 .44371 L p F P
0 g
s
.966 .687 .452 r
.56042 .44885 m .56172 .44371 L .55029 .42472 L p F P
0 g
s
.966 .687 .452 r
.65478 .73501 m .6507 .73018 L .65026 .7527 L p F P
0 g
s
.966 .687 .452 r
.65026 .7527 m .65437 .75832 L .65478 .73501 L p F P
0 g
s
.966 .687 .452 r
.59426 .55944 m .59739 .55835 L .59048 .53834 L p F P
0 g
s
.966 .687 .452 r
.59739 .55835 m .59426 .55944 L .60013 .57882 L p F P
0 g
s
.966 .687 .452 r
.60013 .57882 m .60353 .57863 L .59739 .55835 L p F P
0 g
s
.966 .687 .452 r
.62474 .64415 m .62078 .6417 L .62347 .66208 L p F P
0 g
s
.966 .687 .452 r
.62347 .66208 m .62755 .6654 L .62474 .64415 L p F P
0 g
s
.966 .687 .452 r
.6171 .62084 m .61328 .61925 L .6168 .63923 L p F P
0 g
s
.966 .687 .452 r
.6168 .63923 m .62078 .6417 L .6171 .62084 L p F P
0 g
s
.966 .687 .452 r
.60353 .57863 m .60013 .57882 L .60521 .59829 L p F P
0 g
s
.966 .687 .452 r
.60521 .59829 m .60884 .59899 L .60353 .57863 L p F P
0 g
s
.966 .687 .452 r
.5398 .38774 m .54025 .38132 L .52632 .36292 L p F P
0 g
s
.966 .687 .452 r
.58765 .5403 m .59048 .53834 L .58286 .51876 L p F P
0 g
s
.966 .687 .452 r
.59048 .53834 m .58765 .5403 L .59426 .55944 L p F P
0 g
s
.966 .687 .452 r
.64166 .69831 m .63757 .69422 L .6383 .71552 L p F P
0 g
s
.966 .687 .452 r
.6383 .71552 m .64246 .72044 L .64166 .69831 L p F P
0 g
s
.966 .687 .452 r
.56042 .44885 m .5591 .45402 L .56923 .47276 L p F P
0 g
s
.966 .687 .452 r
.56751 .47719 m .56923 .47276 L .5591 .45402 L p F P
0 g
s
.966 .687 .452 r
.56923 .47276 m .56751 .47719 L .57672 .49616 L p F P
0 g
s
.966 .687 .452 r
.5746 .49981 m .57672 .49616 L .56751 .47719 L p F P
0 g
s
.966 .687 .452 r
.57672 .49616 m .5746 .49981 L .58286 .51876 L p F P
0 g
s
.966 .687 .452 r
.63161 .6687 m .62755 .6654 L .62929 .68595 L p F P
0 g
s
.966 .687 .452 r
.62929 .68595 m .63344 .6901 L .63161 .6687 L p F P
0 g
s
.966 .687 .452 r
.60884 .59899 m .60521 .59829 L .60944 .61765 L p F P
0 g
s
.966 .687 .452 r
.60944 .61765 m .61328 .61925 L .60884 .59899 L p F P
0 g
s
.966 .687 .452 r
.53936 .3942 m .53891 .4007 L .55118 .41889 L p F P
0 g
s
.966 .687 .452 r
.55029 .42472 m .55118 .41889 L .53891 .4007 L p F P
0 g
s
.966 .687 .452 r
.6507 .73018 m .64659 .72532 L .64614 .74705 L p F P
0 g
s
.966 .687 .452 r
.64614 .74705 m .65026 .7527 L .6507 .73018 L p F P
0 g
s
.966 .687 .452 r
.58037 .5216 m .58286 .51876 L .5746 .49981 L p F P
0 g
s
.966 .687 .452 r
.58286 .51876 m .58037 .5216 L .58765 .5403 L p F P
0 g
s
.966 .687 .452 r
.55029 .42472 m .5494 .4306 L .56042 .44885 L p F P
0 g
s
.966 .687 .452 r
.5591 .45402 m .56042 .44885 L .5494 .4306 L p F P
0 g
s
.966 .687 .452 r
.52632 .36292 m .52632 .36999 L .5398 .38774 L p F P
0 g
s
.966 .687 .452 r
.53936 .3942 m .5398 .38774 L .52632 .36999 L p F P
0 g
s
.966 .687 .452 r
.62078 .6417 m .6168 .63923 L .61936 .65873 L p F P
0 g
s
.966 .687 .452 r
.61936 .65873 m .62347 .66208 L .62078 .6417 L p F P
0 g
s
.966 .687 .452 r
.63757 .69422 m .63344 .6901 L .63413 .71058 L p F P
0 g
s
.966 .687 .452 r
.63413 .71058 m .6383 .71552 L .63757 .69422 L p F P
0 g
s
.966 .687 .452 r
.59111 .56053 m .59426 .55944 L .58765 .5403 L p F P
0 g
s
.966 .687 .452 r
.59426 .55944 m .59111 .56053 L .5967 .57902 L p F P
0 g
s
.966 .687 .452 r
.5967 .57902 m .60013 .57882 L .59426 .55944 L p F P
0 g
s
.966 .687 .452 r
.61328 .61925 m .60944 .61765 L .61279 .63674 L p F P
0 g
s
.966 .687 .452 r
.61279 .63674 m .6168 .63923 L .61328 .61925 L p F P
0 g
s
.966 .687 .452 r
.60013 .57882 m .5967 .57902 L .60154 .59758 L p F P
0 g
s
.966 .687 .452 r
.60154 .59758 m .60521 .59829 L .60013 .57882 L p F P
0 g
s
.966 .687 .452 r
.5591 .45402 m .55778 .45923 L .56751 .47719 L p F P
0 g
s
.966 .687 .452 r
.56577 .48166 m .56751 .47719 L .55778 .45923 L p F P
0 g
s
.966 .687 .452 r
.56751 .47719 m .56577 .48166 L .5746 .49981 L p F P
0 g
s
.966 .687 .452 r
.58481 .54229 m .58765 .5403 L .58037 .5216 L p F P
0 g
s
.966 .687 .452 r
.58765 .5403 m .58481 .54229 L .59111 .56053 L p F P
0 g
s
.966 .687 .452 r
.57247 .50349 m .5746 .49981 L .56577 .48166 L p F P
0 g
s
.966 .687 .452 r
.5746 .49981 m .57247 .50349 L .58037 .5216 L p F P
0 g
s
.966 .687 .452 r
.62755 .6654 m .62347 .66208 L .62512 .68178 L p F P
0 g
s
.966 .687 .452 r
.62512 .68178 m .62929 .68595 L .62755 .6654 L p F P
0 g
s
.966 .687 .452 r
.64659 .72532 m .64246 .72044 L .64199 .74138 L p F P
0 g
s
.966 .687 .452 r
.64199 .74138 m .64614 .74705 L .64659 .72532 L p F P
0 g
s
.966 .687 .452 r
.53891 .4007 m .53846 .40722 L .55029 .42472 L p F P
0 g
s
.966 .687 .452 r
.5494 .4306 m .55029 .42472 L .53846 .40722 L p F P
0 g
s
.966 .687 .452 r
.5494 .4306 m .54851 .43651 L .5591 .45402 L p F P
0 g
s
.966 .687 .452 r
.55778 .45923 m .5591 .45402 L .54851 .43651 L p F P
0 g
s
.966 .687 .452 r
.60521 .59829 m .60154 .59758 L .60557 .61604 L p F P
0 g
s
.966 .687 .452 r
.60557 .61604 m .60944 .61765 L .60521 .59829 L p F P
0 g
s
.966 .687 .452 r
.57786 .52445 m .58037 .5216 L .57247 .50349 L p F P
0 g
s
.966 .687 .452 r
.58037 .5216 m .57786 .52445 L .58481 .54229 L p F P
0 g
s
.966 .687 .452 r
.52632 .36999 m .52632 .37709 L .53936 .3942 L p F P
0 g
s
.966 .687 .452 r
.53891 .4007 m .53936 .3942 L .52632 .37709 L p F P
0 g
s
.966 .687 .452 r
.63344 .6901 m .62929 .68595 L .62993 .70561 L p F P
0 g
s
.966 .687 .452 r
.62993 .70561 m .63413 .71058 L .63344 .6901 L p F P
0 g
s
.966 .687 .452 r
.6168 .63923 m .61279 .63674 L .61522 .65537 L p F P
0 g
s
.966 .687 .452 r
.61522 .65537 m .61936 .65873 L .6168 .63923 L p F P
0 g
s
.966 .687 .452 r
.64246 .72044 m .6383 .71552 L .63782 .73567 L p F P
0 g
s
.966 .687 .452 r
.63782 .73567 m .64199 .74138 L .64246 .72044 L p F P
0 g
s
.966 .687 .452 r
.60944 .61765 m .60557 .61604 L .60876 .63423 L p F P
0 g
s
.966 .687 .452 r
.60876 .63423 m .61279 .63674 L .60944 .61765 L p F P
0 g
s
.966 .687 .452 r
.58793 .56163 m .59111 .56053 L .58481 .54229 L p F P
0 g
s
.966 .687 .452 r
.59111 .56053 m .58793 .56163 L .59325 .57922 L p F P
0 g
s
.966 .687 .452 r
.59325 .57922 m .5967 .57902 L .59111 .56053 L p F P
0 g
s
.966 .687 .452 r
.65437 .75832 m .65026 .7527 L .64846 .77376 L p F P
0 g
s
.966 .687 .452 r
.64846 .77376 m .65255 .78014 L .65437 .75832 L p F P
0 g
s
.966 .687 .452 r
.55778 .45923 m .55644 .46447 L .56577 .48166 L p F P
0 g
s
.966 .687 .452 r
.56402 .48615 m .56577 .48166 L .55644 .46447 L p F P
0 g
s
.966 .687 .452 r
.56577 .48166 m .56402 .48615 L .57247 .50349 L p F P
0 g
s
.966 .687 .452 r
.53846 .40722 m .538 .41379 L .5494 .4306 L p F P
0 g
s
.966 .687 .452 r
.54851 .43651 m .5494 .4306 L .538 .41379 L p F P
0 g
s
.966 .687 .452 r
.62347 .66208 m .61936 .65873 L .62092 .67758 L p F P
0 g
s
.966 .687 .452 r
.62092 .67758 m .62512 .68178 L .62347 .66208 L p F P
0 g
s
.966 .687 .452 r
.5967 .57902 m .59325 .57922 L .59785 .59687 L p F P
0 g
s
.966 .687 .452 r
.59785 .59687 m .60154 .59758 L .5967 .57902 L p F P
0 g
s
.966 .687 .452 r
.57032 .50719 m .57247 .50349 L .56402 .48615 L p F P
0 g
s
.966 .687 .452 r
.57247 .50349 m .57032 .50719 L .57786 .52445 L p F P
0 g
s
.966 .687 .452 r
.58194 .54428 m .58481 .54229 L .57786 .52445 L p F P
0 g
s
.966 .687 .452 r
.58481 .54229 m .58194 .54428 L .58793 .56163 L p F P
0 g
s
.966 .687 .452 r
.54851 .43651 m .54761 .44245 L .55778 .45923 L p F P
0 g
s
.966 .687 .452 r
.55644 .46447 m .55778 .45923 L .54761 .44245 L p F P
0 g
s
.966 .687 .452 r
.52632 .37709 m .52632 .38423 L .53891 .4007 L p F P
0 g
s
.966 .687 .452 r
.53846 .40722 m .53891 .4007 L .52632 .38423 L p F P
0 g
s
.966 .687 .452 r
.60154 .59758 m .59785 .59687 L .60168 .61442 L p F P
0 g
s
.966 .687 .452 r
.60168 .61442 m .60557 .61604 L .60154 .59758 L p F P
0 g
s
.966 .687 .452 r
.57533 .52733 m .57786 .52445 L .57032 .50719 L p F P
0 g
s
.966 .687 .452 r
.57786 .52445 m .57533 .52733 L .58194 .54428 L p F P
0 g
s
.966 .687 .452 r
.62929 .68595 m .62512 .68178 L .6257 .70061 L p F P
0 g
s
.966 .687 .452 r
.6257 .70061 m .62993 .70561 L .62929 .68595 L p F P
0 g
s
.966 .687 .452 r
.65026 .7527 m .64614 .74705 L .64436 .76735 L p F P
0 g
s
.966 .687 .452 r
.64436 .76735 m .64846 .77376 L .65026 .7527 L p F P
0 g
s
.966 .687 .452 r
.6383 .71552 m .63413 .71058 L .63363 .72994 L p F P
0 g
s
.966 .687 .452 r
.63363 .72994 m .63782 .73567 L .6383 .71552 L p F P
0 g
s
.966 .687 .452 r
.61279 .63674 m .60876 .63423 L .61106 .65198 L p F P
0 g
s
.966 .687 .452 r
.61106 .65198 m .61522 .65537 L .61279 .63674 L p F P
0 g
s
.966 .687 .452 r
.538 .41379 m .53755 .42039 L .54851 .43651 L p F P
0 g
s
.966 .687 .452 r
.54761 .44245 m .54851 .43651 L .53755 .42039 L p F P
0 g
s
.966 .687 .452 r
.61936 .65873 m .61522 .65537 L .61669 .67336 L p F P
0 g
s
.966 .687 .452 r
.61669 .67336 m .62092 .67758 L .61936 .65873 L p F P
0 g
s
.966 .687 .452 r
.55644 .46447 m .5551 .46975 L .56402 .48615 L p F P
0 g
s
.966 .687 .452 r
.56226 .49067 m .56402 .48615 L .5551 .46975 L p F P
0 g
s
.966 .687 .452 r
.56402 .48615 m .56226 .49067 L .57032 .50719 L p F P
0 g
s
.966 .687 .452 r
.60557 .61604 m .60168 .61442 L .60469 .63171 L p F P
0 g
s
.966 .687 .452 r
.60469 .63171 m .60876 .63423 L .60557 .61604 L p F P
0 g
s
.966 .687 .452 r
.58473 .56275 m .58793 .56163 L .58194 .54428 L p F P
0 g
s
.966 .687 .452 r
.58793 .56163 m .58473 .56275 L .58978 .57941 L p F P
0 g
s
.966 .687 .452 r
.58978 .57941 m .59325 .57922 L .58793 .56163 L p F P
0 g
s
.966 .687 .452 r
.52632 .38423 m .52632 .39141 L .53846 .40722 L p F P
0 g
s
.966 .687 .452 r
.538 .41379 m .53846 .40722 L .52632 .39141 L p F P
0 g
s
.966 .687 .452 r
.56816 .51092 m .57032 .50719 L .56226 .49067 L p F P
0 g
s
.966 .687 .452 r
.57032 .50719 m .56816 .51092 L .57533 .52733 L p F P
0 g
s
.966 .687 .452 r
.59325 .57922 m .58978 .57941 L .59413 .59615 L p F P
0 g
s
.966 .687 .452 r
.59413 .59615 m .59785 .59687 L .59325 .57922 L p F P
0 g
s
.966 .687 .452 r
.54761 .44245 m .5467 .44843 L .55644 .46447 L p F P
0 g
s
.966 .687 .452 r
.5551 .46975 m .55644 .46447 L .5467 .44843 L p F P
0 g
s
.966 .687 .452 r
.57905 .5463 m .58194 .54428 L .57533 .52733 L p F P
0 g
s
.966 .687 .452 r
.58194 .54428 m .57905 .5463 L .58473 .56275 L p F P
0 g
s
.966 .687 .452 r
.64614 .74705 m .64199 .74138 L .64024 .76092 L p F P
0 g
s
.966 .687 .452 r
.64024 .76092 m .64436 .76735 L .64614 .74705 L p F P
0 g
s
.966 .687 .452 r
.62512 .68178 m .62092 .67758 L .62145 .69559 L p F P
0 g
s
.966 .687 .452 r
.62145 .69559 m .6257 .70061 L .62512 .68178 L p F P
0 g
s
.966 .687 .452 r
.59785 .59687 m .59413 .59615 L .59775 .61278 L p F P
0 g
s
.966 .687 .452 r
.59775 .61278 m .60168 .61442 L .59785 .59687 L p F P
0 g
s
.966 .687 .452 r
.63413 .71058 m .62993 .70561 L .62942 .72417 L p F P
0 g
s
.966 .687 .452 r
.62942 .72417 m .63363 .72994 L .63413 .71058 L p F P
0 g
s
.966 .687 .452 r
.57278 .53022 m .57533 .52733 L .56816 .51092 L p F P
0 g
s
.966 .687 .452 r
.57533 .52733 m .57278 .53022 L .57905 .5463 L p F P
0 g
s
.966 .687 .452 r
.53755 .42039 m .53709 .42703 L .54761 .44245 L p F P
0 g
s
.966 .687 .452 r
.5467 .44843 m .54761 .44245 L .53709 .42703 L p F P
0 g
s
.966 .687 .452 r
.60876 .63423 m .60469 .63171 L .60687 .64857 L p F P
0 g
s
.966 .687 .452 r
.60687 .64857 m .61106 .65198 L .60876 .63423 L p F P
0 g
s
.966 .687 .452 r
.52632 .39141 m .52632 .39862 L .538 .41379 L p F P
0 g
s
.966 .687 .452 r
.53755 .42039 m .538 .41379 L .52632 .39862 L p F P
0 g
s
.966 .687 .452 r
.61522 .65537 m .61106 .65198 L .61244 .66911 L p F P
0 g
s
.966 .687 .452 r
.61244 .66911 m .61669 .67336 L .61522 .65537 L p F P
0 g
s
.966 .687 .452 r
.5551 .46975 m .55375 .47506 L .56226 .49067 L p F P
0 g
s
.966 .687 .452 r
.56049 .49523 m .56226 .49067 L .55375 .47506 L p F P
0 g
s
.966 .687 .452 r
.56226 .49067 m .56049 .49523 L .56816 .51092 L p F P
0 g
s
.966 .687 .452 r
.60168 .61442 m .59775 .61278 L .6006 .62917 L p F P
0 g
s
.966 .687 .452 r
.6006 .62917 m .60469 .63171 L .60168 .61442 L p F P
0 g
s
.966 .687 .452 r
.5467 .44843 m .54579 .45445 L .5551 .46975 L p F P
0 g
s
.966 .687 .452 r
.55375 .47506 m .5551 .46975 L .54579 .45445 L p F P
0 g
s
.966 .687 .452 r
.64199 .74138 m .63782 .73567 L .6361 .75445 L p F P
0 g
s
.966 .687 .452 r
.6361 .75445 m .64024 .76092 L .64199 .74138 L p F P
0 g
s
.966 .687 .452 r
.56598 .51468 m .56816 .51092 L .56049 .49523 L p F P
0 g
s
.966 .687 .452 r
.56816 .51092 m .56598 .51468 L .57278 .53022 L p F P
0 g
s
.966 .687 .452 r
.58151 .56387 m .58473 .56275 L .57905 .5463 L p F P
0 g
s
.966 .687 .452 r
.58473 .56275 m .58151 .56387 L .58627 .57961 L p F P
0 g
s
.966 .687 .452 r
.58627 .57961 m .58978 .57941 L .58473 .56275 L p F P
0 g
s
.966 .687 .452 r
.58978 .57941 m .58627 .57961 L .59038 .59542 L p F P
0 g
s
.966 .687 .452 r
.59038 .59542 m .59413 .59615 L .58978 .57941 L p F P
0 g
s
.966 .687 .452 r
.57614 .54833 m .57905 .5463 L .57278 .53022 L p F P
0 g
s
.966 .687 .452 r
.57905 .5463 m .57614 .54833 L .58151 .56387 L p F P
0 g
s
.966 .687 .452 r
.62993 .70561 m .6257 .70061 L .62519 .71838 L p F P
0 g
s
.966 .687 .452 r
.62519 .71838 m .62942 .72417 L .62993 .70561 L p F P
0 g
s
.966 .687 .452 r
.62092 .67758 m .61669 .67336 L .61718 .69053 L p F P
0 g
s
.966 .687 .452 r
.61718 .69053 m .62145 .69559 L .62092 .67758 L p F P
0 g
s
.966 .687 .452 r
.59413 .59615 m .59038 .59542 L .5938 .61114 L p F P
0 g
s
.966 .687 .452 r
.5938 .61114 m .59775 .61278 L .59413 .59615 L p F P
0 g
s
.966 .687 .452 r
.53709 .42703 m .53663 .43371 L .5467 .44843 L p F P
0 g
s
.966 .687 .452 r
.54579 .45445 m .5467 .44843 L .53663 .43371 L p F P
0 g
s
.966 .687 .452 r
.57021 .53314 m .57278 .53022 L .56598 .51468 L p F P
0 g
s
.966 .687 .452 r
.57278 .53022 m .57021 .53314 L .57614 .54833 L p F P
0 g
s
.966 .687 .452 r
.52632 .39862 m .52632 .40586 L .53755 .42039 L p F P
0 g
s
.966 .687 .452 r
.53709 .42703 m .53755 .42039 L .52632 .40586 L p F P
0 g
s
.966 .687 .452 r
.65255 .78014 m .64846 .77376 L .64527 .7931 L p F P
0 g
s
.966 .687 .452 r
.64527 .7931 m .64928 .8002 L .65255 .78014 L p F P
0 g
s
.966 .687 .452 r
.60469 .63171 m .6006 .62917 L .60264 .64513 L p F P
0 g
s
.966 .687 .452 r
.60264 .64513 m .60687 .64857 L .60469 .63171 L p F P
0 g
s
.966 .687 .452 r
.61106 .65198 m .60687 .64857 L .60816 .66483 L p F P
0 g
s
.966 .687 .452 r
.60816 .66483 m .61244 .66911 L .61106 .65198 L p F P
0 g
s
.966 .687 .452 r
.63782 .73567 m .63363 .72994 L .63194 .74796 L p F P
0 g
s
.966 .687 .452 r
.63194 .74796 m .6361 .75445 L .63782 .73567 L p F P
0 g
s
.966 .687 .452 r
.55375 .47506 m .5524 .48041 L .56049 .49523 L p F P
0 g
s
.966 .687 .452 r
.5587 .49982 m .56049 .49523 L .5524 .48041 L p F P
0 g
s
.966 .687 .452 r
.56049 .49523 m .5587 .49982 L .56598 .51468 L p F P
0 g
s
.966 .687 .452 r
.54579 .45445 m .54487 .46051 L .55375 .47506 L p F P
0 g
s
.966 .687 .452 r
.5524 .48041 m .55375 .47506 L .54487 .46051 L p F P
0 g
s
.966 .687 .452 r
.59775 .61278 m .5938 .61114 L .59648 .62661 L p F P
0 g
s
.966 .687 .452 r
.59648 .62661 m .6006 .62917 L .59775 .61278 L p F P
0 g
s
.966 .687 .452 r
.6257 .70061 m .62145 .69559 L .62094 .71256 L p F P
0 g
s
.966 .687 .452 r
.62094 .71256 m .62519 .71838 L .6257 .70061 L p F P
0 g
s
.966 .687 .452 r
.56378 .51847 m .56598 .51468 L .5587 .49982 L p F P
0 g
s
.966 .687 .452 r
.56598 .51468 m .56378 .51847 L .57021 .53314 L p F P
0 g
s
.966 .687 .452 r
.61669 .67336 m .61244 .66911 L .61288 .68545 L p F P
0 g
s
.966 .687 .452 r
.61288 .68545 m .61718 .69053 L .61669 .67336 L p F P
0 g
s
.966 .687 .452 r
.57826 .56499 m .58151 .56387 L .57614 .54833 L p F P
0 g
s
.966 .687 .452 r
.58151 .56387 m .57826 .56499 L .58274 .57982 L p F P
0 g
s
.966 .687 .452 r
.58274 .57982 m .58627 .57961 L .58151 .56387 L p F P
0 g
s
.966 .687 .452 r
.64846 .77376 m .64436 .76735 L .64123 .78598 L p F P
0 g
s
.966 .687 .452 r
.64123 .78598 m .64527 .7931 L .64846 .77376 L p F P
0 g
s
.966 .687 .452 r
.58627 .57961 m .58274 .57982 L .58661 .59469 L p F P
0 g
s
.966 .687 .452 r
.58661 .59469 m .59038 .59542 L .58627 .57961 L p F P
0 g
s
.966 .687 .452 r
.57321 .55037 m .57614 .54833 L .57021 .53314 L p F P
0 g
s
.966 .687 .452 r
.57614 .54833 m .57321 .55037 L .57826 .56499 L p F P
0 g
s
.966 .687 .452 r
.52632 .40586 m .52632 .41314 L .53709 .42703 L p F P
0 g
s
.966 .687 .452 r
.53663 .43371 m .53709 .42703 L .52632 .41314 L p F P
0 g
s
.966 .687 .452 r
.53663 .43371 m .53616 .44042 L .54579 .45445 L p F P
0 g
s
.966 .687 .452 r
.54487 .46051 m .54579 .45445 L .53616 .44042 L p F P
0 g
s
.966 .687 .452 r
.63363 .72994 m .62942 .72417 L .62776 .74144 L p F P
0 g
s
.966 .687 .452 r
.62776 .74144 m .63194 .74796 L .63363 .72994 L p F P
0 g
s
.966 .687 .452 r
.59038 .59542 m .58661 .59469 L .58981 .60948 L p F P
0 g
s
.966 .687 .452 r
.58981 .60948 m .5938 .61114 L .59038 .59542 L p F P
0 g
s
.966 .687 .452 r
.56762 .53609 m .57021 .53314 L .56378 .51847 L p F P
0 g
s
.966 .687 .452 r
.57021 .53314 m .56762 .53609 L .57321 .55037 L p F P
0 g
s
.966 .687 .452 r
.60687 .64857 m .60264 .64513 L .60386 .66053 L p F P
0 g
s
.966 .687 .452 r
.60386 .66053 m .60816 .66483 L .60687 .64857 L p F P
0 g
s
.966 .687 .452 r
.6006 .62917 m .59648 .62661 L .5984 .64168 L p F P
0 g
s
.966 .687 .452 r
.5984 .64168 m .60264 .64513 L .6006 .62917 L p F P
0 g
s
.966 .687 .452 r
.62145 .69559 m .61718 .69053 L .61666 .70671 L p F P
0 g
s
.966 .687 .452 r
.61666 .70671 m .62094 .71256 L .62145 .69559 L p F P
0 g
s
.966 .687 .452 r
.64436 .76735 m .64024 .76092 L .63718 .77882 L p F P
0 g
s
.966 .687 .452 r
.63718 .77882 m .64123 .78598 L .64436 .76735 L p F P
0 g
s
.966 .687 .452 r
.5524 .48041 m .55103 .48579 L .5587 .49982 L p F P
0 g
s
.966 .687 .452 r
.55691 .50444 m .5587 .49982 L .55103 .48579 L p F P
0 g
s
.966 .687 .452 r
.5587 .49982 m .55691 .50444 L .56378 .51847 L p F P
0 g
s
.966 .687 .452 r
.54487 .46051 m .54395 .4666 L .5524 .48041 L p F P
0 g
s
.966 .687 .452 r
.55103 .48579 m .5524 .48041 L .54395 .4666 L p F P
0 g
s
.966 .687 .452 r
.61244 .66911 m .60816 .66483 L .60856 .68034 L p F P
0 g
s
.966 .687 .452 r
.60856 .68034 m .61288 .68545 L .61244 .66911 L p F P
0 g
s
.966 .687 .452 r
.5938 .61114 m .58981 .60948 L .59233 .62403 L p F P
0 g
s
.966 .687 .452 r
.59233 .62403 m .59648 .62661 L .5938 .61114 L p F P
0 g
s
.966 .687 .452 r
.56157 .52228 m .56378 .51847 L .55691 .50444 L p F P
0 g
s
.966 .687 .452 r
.56378 .51847 m .56157 .52228 L .56762 .53609 L p F P
0 g
s
.966 .687 .452 r
.52632 .41314 m .52632 .42046 L .53663 .43371 L p F P
0 g
s
.966 .687 .452 r
.53616 .44042 m .53663 .43371 L .52632 .42046 L p F P
0 g
s
.966 .687 .452 r
.62942 .72417 m .62519 .71838 L .62357 .73489 L p F P
0 g
s
.966 .687 .452 r
.62357 .73489 m .62776 .74144 L .62942 .72417 L p F P
0 g
s
.966 .687 .452 r
.53616 .44042 m .5357 .44717 L .54487 .46051 L p F P
0 g
s
.966 .687 .452 r
.54395 .4666 m .54487 .46051 L .5357 .44717 L p F P
0 g
s
.966 .687 .452 r
.57499 .56613 m .57826 .56499 L .57321 .55037 L p F P
0 g
s
.966 .687 .452 r
.57826 .56499 m .57499 .56613 L .57919 .58002 L p F P
0 g
s
.966 .687 .452 r
.57919 .58002 m .58274 .57982 L .57826 .56499 L p F P
0 g
s
.966 .687 .452 r
.58274 .57982 m .57919 .58002 L .5828 .59396 L p F P
0 g
s
.966 .687 .452 r
.5828 .59396 m .58661 .59469 L .58274 .57982 L p F P
0 g
s
.966 .687 .452 r
.57025 .55243 m .57321 .55037 L .56762 .53609 L p F P
0 g
s
.966 .687 .452 r
.57321 .55037 m .57025 .55243 L .57499 .56613 L p F P
0 g
s
.966 .687 .452 r
.64024 .76092 m .6361 .75445 L .63312 .77165 L p F P
0 g
s
.966 .687 .452 r
.63312 .77165 m .63718 .77882 L .64024 .76092 L p F P
0 g
s
.966 .687 .452 r
.58661 .59469 m .5828 .59396 L .5858 .60781 L p F P
0 g
s
.966 .687 .452 r
.5858 .60781 m .58981 .60948 L .58661 .59469 L p F P
0 g
s
.966 .687 .452 r
.61718 .69053 m .61288 .68545 L .61236 .70082 L p F P
0 g
s
.966 .687 .452 r
.61236 .70082 m .61666 .70671 L .61718 .69053 L p F P
0 g
s
.966 .687 .452 r
.60264 .64513 m .5984 .64168 L .59952 .6562 L p F P
0 g
s
.966 .687 .452 r
.59952 .6562 m .60386 .66053 L .60264 .64513 L p F P
0 g
s
.966 .687 .452 r
.56502 .53905 m .56762 .53609 L .56157 .52228 L p F P
0 g
s
.966 .687 .452 r
.56762 .53609 m .56502 .53905 L .57025 .55243 L p F P
0 g
s
.966 .687 .452 r
.59648 .62661 m .59233 .62403 L .59412 .6382 L p F P
0 g
s
.966 .687 .452 r
.59412 .6382 m .5984 .64168 L .59648 .62661 L p F P
0 g
s
.966 .687 .452 r
.54395 .4666 m .54302 .47273 L .55103 .48579 L p F P
0 g
s
.966 .687 .452 r
.54965 .4912 m .55103 .48579 L .54302 .47273 L p F P
0 g
s
.966 .687 .452 r
.55103 .48579 m .54965 .4912 L .55691 .50444 L p F P
0 g
s
.966 .687 .452 r
.55509 .50909 m .55691 .50444 L .54965 .4912 L p F P
0 g
s
.966 .687 .452 r
.55691 .50444 m .55509 .50909 L .56157 .52228 L p F P
0 g
s
.966 .687 .452 r
.60816 .66483 m .60386 .66053 L .60421 .67519 L p F P
0 g
s
.966 .687 .452 r
.60421 .67519 m .60856 .68034 L .60816 .66483 L p F P
0 g
s
.966 .687 .452 r
.62519 .71838 m .62094 .71256 L .61936 .72831 L p F P
0 g
s
.966 .687 .452 r
.61936 .72831 m .62357 .73489 L .62519 .71838 L p F P
0 g
s
.966 .687 .452 r
.52632 .42046 m .52632 .42781 L .53616 .44042 L p F P
0 g
s
.966 .687 .452 r
.5357 .44717 m .53616 .44042 L .52632 .42781 L p F P
0 g
s
.966 .687 .452 r
.58981 .60948 m .5858 .60781 L .58815 .62143 L p F P
0 g
s
.966 .687 .452 r
.58815 .62143 m .59233 .62403 L .58981 .60948 L p F P
0 g
s
.966 .687 .452 r
.5357 .44717 m .53523 .45396 L .54395 .4666 L p F P
0 g
s
.966 .687 .452 r
.54302 .47273 m .54395 .4666 L .53523 .45396 L p F P
0 g
s
.966 .687 .452 r
.6361 .75445 m .63194 .74796 L .62904 .76444 L p F P
0 g
s
.966 .687 .452 r
.62904 .76444 m .63312 .77165 L .6361 .75445 L p F P
0 g
s
.966 .687 .452 r
.55934 .52612 m .56157 .52228 L .55509 .50909 L p F P
0 g
s
.966 .687 .452 r
.56157 .52228 m .55934 .52612 L .56502 .53905 L p F P
0 g
s
.966 .687 .452 r
.57169 .56728 m .57499 .56613 L .57025 .55243 L p F P
0 g
s
.966 .687 .452 r
.57499 .56613 m .57169 .56728 L .5756 .58022 L p F P
0 g
s
.966 .687 .452 r
.5756 .58022 m .57919 .58002 L .57499 .56613 L p F P
0 g
s
.966 .687 .452 r
.57919 .58002 m .5756 .58022 L .57897 .59322 L p F P
0 g
s
.966 .687 .452 r
.57897 .59322 m .5828 .59396 L .57919 .58002 L p F P
0 g
s
.966 .687 .452 r
.61288 .68545 m .60856 .68034 L .60804 .69491 L p F P
0 g
s
.966 .687 .452 r
.60804 .69491 m .61236 .70082 L .61288 .68545 L p F P
0 g
s
.966 .687 .452 r
.56727 .55451 m .57025 .55243 L .56502 .53905 L p F P
0 g
s
.966 .687 .452 r
.57025 .55243 m .56727 .55451 L .57169 .56728 L p F P
0 g
s
.966 .687 .452 r
.64928 .8002 m .64527 .7931 L .64067 .81049 L p F P
0 g
s
.966 .687 .452 r
.64067 .81049 m .64457 .81826 L .64928 .8002 L p F P
0 g
s
.966 .687 .452 r
.5984 .64168 m .59412 .6382 L .59516 .65184 L p F P
0 g
s
.966 .687 .452 r
.59516 .65184 m .59952 .6562 L .5984 .64168 L p F P
0 g
s
.966 .687 .452 r
.62094 .71256 m .61666 .70671 L .61512 .7217 L p F P
0 g
s
.966 .687 .452 r
.61512 .7217 m .61936 .72831 L .62094 .71256 L p F P
0 g
s
.966 .687 .452 r
.5828 .59396 m .57897 .59322 L .58176 .60612 L p F P
0 g
s
.966 .687 .452 r
.58176 .60612 m .5858 .60781 L .5828 .59396 L p F P
0 g
s
.966 .687 .452 r
.59233 .62403 m .58815 .62143 L .58981 .6347 L p F P
0 g
s
.966 .687 .452 r
.58981 .6347 m .59412 .6382 L .59233 .62403 L p F P
0 g
s
.966 .687 .452 r
.52632 .42781 m .52632 .43521 L .5357 .44717 L p F P
0 g
s
.966 .687 .452 r
.53523 .45396 m .5357 .44717 L .52632 .43521 L p F P
0 g
s
.966 .687 .452 r
.63194 .74796 m .62776 .74144 L .62494 .75721 L p F P
0 g
s
.966 .687 .452 r
.62494 .75721 m .62904 .76444 L .63194 .74796 L p F P
0 g
s
.966 .687 .452 r
.56239 .54204 m .56502 .53905 L .55934 .52612 L p F P
0 g
s
.966 .687 .452 r
.56502 .53905 m .56239 .54204 L .56727 .55451 L p F P
0 g
s
.966 .687 .452 r
.54302 .47273 m .54209 .4789 L .54965 .4912 L p F P
0 g
s
.966 .687 .452 r
.54827 .49666 m .54965 .4912 L .54209 .4789 L p F P
0 g
s
.966 .687 .452 r
.54965 .4912 m .54827 .49666 L .55509 .50909 L p F P
0 g
s
.966 .687 .452 r
.60386 .66053 m .59952 .6562 L .59984 .67002 L p F P
0 g
s
.966 .687 .452 r
.59984 .67002 m .60421 .67519 L .60386 .66053 L p F P
0 g
s
.966 .687 .452 r
.55327 .51378 m .55509 .50909 L .54827 .49666 L p F P
0 g
s
.966 .687 .452 r
.55509 .50909 m .55327 .51378 L .55934 .52612 L p F P
0 g
s
.966 .687 .452 r
.53523 .45396 m .53476 .46079 L .54302 .47273 L p F P
0 g
s
.966 .687 .452 r
.54209 .4789 m .54302 .47273 L .53476 .46079 L p F P
0 g
s
.966 .687 .452 r
.64527 .7931 m .64123 .78598 L .63675 .80269 L p F P
0 g
s
.966 .687 .452 r
.63675 .80269 m .64067 .81049 L .64527 .7931 L p F P
0 g
s
.966 .687 .452 r
.5858 .60781 m .58176 .60612 L .58393 .61882 L p F P
0 g
s
.966 .687 .452 r
.58393 .61882 m .58815 .62143 L .5858 .60781 L p F P
0 g
s
.966 .687 .452 r
.55709 .52999 m .55934 .52612 L .55327 .51378 L p F P
0 g
s
.966 .687 .452 r
.55934 .52612 m .55709 .52999 L .56239 .54204 L p F P
0 g
s
.966 .687 .452 r
.60856 .68034 m .60421 .67519 L .6037 .68897 L p F P
0 g
s
.966 .687 .452 r
.6037 .68897 m .60804 .69491 L .60856 .68034 L p F P
0 g
s
.966 .687 .452 r
.61666 .70671 m .61236 .70082 L .61087 .71507 L p F P
0 g
s
.966 .687 .452 r
.61087 .71507 m .61512 .7217 L .61666 .70671 L p F P
0 g
s
.966 .687 .452 r
.62776 .74144 m .62357 .73489 L .62083 .74995 L p F P
0 g
s
.966 .687 .452 r
.62083 .74995 m .62494 .75721 L .62776 .74144 L p F P
0 g
s
.966 .687 .452 r
.56836 .56843 m .57169 .56728 L .56727 .55451 L p F P
0 g
s
.966 .687 .452 r
.57169 .56728 m .56836 .56843 L .57199 .58043 L p F P
0 g
s
.966 .687 .452 r
.57199 .58043 m .5756 .58022 L .57169 .56728 L p F P
0 g
s
.966 .687 .452 r
.52632 .43521 m .52632 .44263 L .53523 .45396 L p F P
0 g
s
.966 .687 .452 r
.53476 .46079 m .53523 .45396 L .52632 .44263 L p F P
0 g
s
.966 .687 .452 r
.5756 .58022 m .57199 .58043 L .5751 .59247 L p F P
0 g
s
.966 .687 .452 r
.5751 .59247 m .57897 .59322 L .5756 .58022 L p F P
0 g
s
.966 .687 .452 r
.59412 .6382 m .58981 .6347 L .59078 .64746 L p F P
0 g
s
.966 .687 .452 r
.59078 .64746 m .59516 .65184 L .59412 .6382 L p F P
0 g
s
.966 .687 .452 r
.56427 .5566 m .56727 .55451 L .56239 .54204 L p F P
0 g
s
.966 .687 .452 r
.56727 .55451 m .56427 .5566 L .56836 .56843 L p F P
0 g
s
.966 .687 .452 r
.64123 .78598 m .63718 .77882 L .63282 .79488 L p F P
0 g
s
.966 .687 .452 r
.63282 .79488 m .63675 .80269 L .64123 .78598 L p F P
0 g
s
.966 .687 .452 r
.59952 .6562 m .59516 .65184 L .59545 .66482 L p F P
0 g
s
.966 .687 .452 r
.59545 .66482 m .59984 .67002 L .59952 .6562 L p F P
0 g
s
.966 .687 .452 r
.54209 .4789 m .54115 .4851 L .54827 .49666 L p F P
0 g
s
.966 .687 .452 r
.54687 .50215 m .54827 .49666 L .54115 .4851 L p F P
0 g
s
.966 .687 .452 r
.54827 .49666 m .54687 .50215 L .55327 .51378 L p F P
0 g
s
.966 .687 .452 r
.58815 .62143 m .58393 .61882 L .58548 .63117 L p F P
0 g
s
.966 .687 .452 r
.58548 .63117 m .58981 .6347 L .58815 .62143 L p F P
0 g
s
.966 .687 .452 r
.57897 .59322 m .5751 .59247 L .57768 .60443 L p F P
0 g
s
.966 .687 .452 r
.57768 .60443 m .58176 .60612 L .57897 .59322 L p F P
0 g
s
.966 .687 .452 r
.55974 .54504 m .56239 .54204 L .55709 .52999 L p F P
0 g
s
.966 .687 .452 r
.56239 .54204 m .55974 .54504 L .56427 .5566 L p F P
0 g
s
.966 .687 .452 r
.55143 .5185 m .55327 .51378 L .54687 .50215 L p F P
0 g
s
.966 .687 .452 r
.55327 .51378 m .55143 .5185 L .55709 .52999 L p F P
0 g
s
.966 .687 .452 r
.53476 .46079 m .53428 .46765 L .54209 .4789 L p F P
0 g
s
.966 .687 .452 r
.54115 .4851 m .54209 .4789 L .53428 .46765 L p F P
0 g
s
.966 .687 .452 r
.62357 .73489 m .61936 .72831 L .6167 .74266 L p F P
0 g
s
.966 .687 .452 r
.6167 .74266 m .62083 .74995 L .62357 .73489 L p F P
0 g
s
.966 .687 .452 r
.60421 .67519 m .59984 .67002 L .59934 .683 L p F P
0 g
s
.966 .687 .452 r
.59934 .683 m .6037 .68897 L .60421 .67519 L p F P
0 g
s
.966 .687 .452 r
.61236 .70082 m .60804 .69491 L .6066 .7084 L p F P
0 g
s
.966 .687 .452 r
.6066 .7084 m .61087 .71507 L .61236 .70082 L p F P
0 g
s
.966 .687 .452 r
.63718 .77882 m .63312 .77165 L .62887 .78703 L p F P
0 g
s
.966 .687 .452 r
.62887 .78703 m .63282 .79488 L .63718 .77882 L p F P
0 g
s
.966 .687 .452 r
.58176 .60612 m .57768 .60443 L .57969 .61618 L p F P
0 g
s
.966 .687 .452 r
.57969 .61618 m .58393 .61882 L .58176 .60612 L p F P
0 g
s
.966 .687 .452 r
.55483 .53389 m .55709 .52999 L .55143 .5185 L p F P
0 g
s
.966 .687 .452 r
.55709 .52999 m .55483 .53389 L .55974 .54504 L p F P
0 g
s
.966 .687 .452 r
.52632 .44263 m .52632 .4501 L .53476 .46079 L p F P
0 g
s
.966 .687 .452 r
.53428 .46765 m .53476 .46079 L .52632 .4501 L p F P
0 g
s
.966 .687 .452 r
.58981 .6347 m .58548 .63117 L .58636 .64305 L p F P
0 g
s
.966 .687 .452 r
.58636 .64305 m .59078 .64746 L .58981 .6347 L p F P
0 g
s
.966 .687 .452 r
.59516 .65184 m .59078 .64746 L .59102 .65959 L p F P
0 g
s
.966 .687 .452 r
.59102 .65959 m .59545 .66482 L .59516 .65184 L p F P
0 g
s
.966 .687 .452 r
.56501 .5696 m .56836 .56843 L .56427 .5566 L p F P
0 g
s
.966 .687 .452 r
.56836 .56843 m .56501 .5696 L .56834 .58064 L p F P
0 g
s
.966 .687 .452 r
.56834 .58064 m .57199 .58043 L .56836 .56843 L p F P
0 g
s
.966 .687 .452 r
.61936 .72831 m .61512 .7217 L .61256 .73535 L p F P
0 g
s
.966 .687 .452 r
.61256 .73535 m .6167 .74266 L .61936 .72831 L p F P
0 g
s
.966 .687 .452 r
.57199 .58043 m .56834 .58064 L .57121 .59172 L p F P
0 g
s
.966 .687 .452 r
.57121 .59172 m .5751 .59247 L .57199 .58043 L p F P
0 g
s
.966 .687 .452 r
.54115 .4851 m .5402 .49135 L .54687 .50215 L p F P
0 g
s
.966 .687 .452 r
.54547 .50767 m .54687 .50215 L .5402 .49135 L p F P
0 g
s
.966 .687 .452 r
.54687 .50215 m .54547 .50767 L .55143 .5185 L p F P
0 g
s
.966 .687 .452 r
.63312 .77165 m .62904 .76444 L .62492 .77917 L p F P
0 g
s
.966 .687 .452 r
.62492 .77917 m .62887 .78703 L .63312 .77165 L p F P
0 g
s
.966 .687 .452 r
.56124 .55871 m .56427 .5566 L .55974 .54504 L p F P
0 g
s
.966 .687 .452 r
.56427 .5566 m .56124 .55871 L .56501 .5696 L p F P
0 g
s
.966 .687 .452 r
.53428 .46765 m .53381 .47456 L .54115 .4851 L p F P
0 g
s
.966 .687 .452 r
.5402 .49135 m .54115 .4851 L .53381 .47456 L p F P
0 g
s
.966 .687 .452 r
.58393 .61882 m .57969 .61618 L .58111 .62762 L p F P
0 g
s
.966 .687 .452 r
.58111 .62762 m .58548 .63117 L .58393 .61882 L p F P
0 g
s
.966 .687 .452 r
.60804 .69491 m .6037 .68897 L .60231 .7017 L p F P
0 g
s
.966 .687 .452 r
.60231 .7017 m .6066 .7084 L .60804 .69491 L p F P
0 g
s
.966 .687 .452 r
.54958 .52325 m .55143 .5185 L .54547 .50767 L p F P
0 g
s
.966 .687 .452 r
.55143 .5185 m .54958 .52325 L .55483 .53389 L p F P
0 g
s
.966 .687 .452 r
.5751 .59247 m .57121 .59172 L .57358 .60272 L p F P
0 g
s
.966 .687 .452 r
.57358 .60272 m .57768 .60443 L .5751 .59247 L p F P
0 g
s
.966 .687 .452 r
.59984 .67002 m .59545 .66482 L .59495 .67699 L p F P
0 g
s
.966 .687 .452 r
.59495 .67699 m .59934 .683 L .59984 .67002 L p F P
0 g
s
.966 .687 .452 r
.55707 .54808 m .55974 .54504 L .55483 .53389 L p F P
0 g
s
.966 .687 .452 r
.55974 .54504 m .55707 .54808 L .56124 .55871 L p F P
0 g
s
.966 .687 .452 r
.52632 .4501 m .52632 .4576 L .53428 .46765 L p F P
0 g
s
.966 .687 .452 r
.53381 .47456 m .53428 .46765 L .52632 .4576 L p F P
0 g
s
.966 .687 .452 r
.62904 .76444 m .62494 .75721 L .62095 .77128 L p F P
0 g
s
.966 .687 .452 r
.62095 .77128 m .62492 .77917 L .62904 .76444 L p F P
0 g
s
.966 .687 .452 r
.57768 .60443 m .57358 .60272 L .57542 .61353 L p F P
0 g
s
.966 .687 .452 r
.57542 .61353 m .57969 .61618 L .57768 .60443 L p F P
0 g
s
.966 .687 .452 r
.61512 .7217 m .61087 .71507 L .60841 .72801 L p F P
0 g
s
.966 .687 .452 r
.60841 .72801 m .61256 .73535 L .61512 .7217 L p F P
0 g
s
.966 .687 .452 r
.55255 .53782 m .55483 .53389 L .54958 .52325 L p F P
0 g
s
.966 .687 .452 r
.55483 .53389 m .55255 .53782 L .55707 .54808 L p F P
0 g
s
.966 .687 .452 r
.59078 .64746 m .58636 .64305 L .58658 .65433 L p F P
0 g
s
.966 .687 .452 r
.58658 .65433 m .59102 .65959 L .59078 .64746 L p F P
0 g
s
.966 .687 .452 r
.58548 .63117 m .58111 .62762 L .58192 .63861 L p F P
0 g
s
.966 .687 .452 r
.58192 .63861 m .58636 .64305 L .58548 .63117 L p F P
0 g
s
.966 .687 .452 r
.6037 .68897 m .59934 .683 L .598 .69497 L p F P
0 g
s
.966 .687 .452 r
.598 .69497 m .60231 .7017 L .6037 .68897 L p F P
0 g
s
.966 .687 .452 r
.5402 .49135 m .53925 .49763 L .54547 .50767 L p F P
0 g
s
.966 .687 .452 r
.54405 .51324 m .54547 .50767 L .53925 .49763 L p F P
0 g
s
.966 .687 .452 r
.54547 .50767 m .54405 .51324 L .54958 .52325 L p F P
0 g
s
.966 .687 .452 r
.53381 .47456 m .53333 .4815 L .5402 .49135 L p F P
0 g
s
.966 .687 .452 r
.53925 .49763 m .5402 .49135 L .53333 .4815 L p F P
0 g
s
.966 .687 .452 r
.56163 .57077 m .56501 .5696 L .56124 .55871 L p F P
0 g
s
.966 .687 .452 r
.56501 .5696 m .56163 .57077 L .56467 .58085 L p F P
0 g
s
.966 .687 .452 r
.56467 .58085 m .56834 .58064 L .56501 .5696 L p F P
0 g
s
.966 .687 .452 r
.64457 .81826 m .64067 .81049 L .63466 .82568 L p F P
0 g
s
.966 .687 .452 r
.63466 .82568 m .63841 .83407 L .64457 .81826 L p F P
0 g
s
.966 .687 .452 r
.59545 .66482 m .59102 .65959 L .59054 .67095 L p F P
0 g
s
.966 .687 .452 r
.59054 .67095 m .59495 .67699 L .59545 .66482 L p F P
0 g
s
.966 .687 .452 r
.62494 .75721 m .62083 .74995 L .61698 .76337 L p F P
0 g
s
.966 .687 .452 r
.61698 .76337 m .62095 .77128 L .62494 .75721 L p F P
0 g
s
.966 .687 .452 r
.56834 .58064 m .56467 .58085 L .56729 .59096 L p F P
0 g
s
.966 .687 .452 r
.56729 .59096 m .57121 .59172 L .56834 .58064 L p F P
0 g
s
.966 .687 .452 r
.57969 .61618 m .57542 .61353 L .57672 .62404 L p F P
0 g
s
.966 .687 .452 r
.57672 .62404 m .58111 .62762 L .57969 .61618 L p F P
0 g
s
.966 .687 .452 r
.55819 .56083 m .56124 .55871 L .55707 .54808 L p F P
0 g
s
.966 .687 .452 r
.56124 .55871 m .55819 .56083 L .56163 .57077 L p F P
0 g
s
.966 .687 .452 r
.54772 .52804 m .54958 .52325 L .54405 .51324 L p F P
0 g
s
.966 .687 .452 r
.54958 .52325 m .54772 .52804 L .55255 .53782 L p F P
0 g
s
.966 .687 .452 r
.61087 .71507 m .6066 .7084 L .60423 .72064 L p F P
0 g
s
.966 .687 .452 r
.60423 .72064 m .60841 .72801 L .61087 .71507 L p F P
0 g
s
.966 .687 .452 r
.52632 .4576 m .52632 .46514 L .53381 .47456 L p F P
0 g
s
.966 .687 .452 r
.53333 .4815 m .53381 .47456 L .52632 .46514 L p F P
0 g
s
.966 .687 .452 r
.57121 .59172 m .56729 .59096 L .56944 .601 L p F P
0 g
s
.966 .687 .452 r
.56944 .601 m .57358 .60272 L .57121 .59172 L p F P
0 g
s
.966 .687 .452 r
.55438 .55113 m .55707 .54808 L .55255 .53782 L p F P
0 g
s
.966 .687 .452 r
.55707 .54808 m .55438 .55113 L .55819 .56083 L p F P
0 g
s
.966 .687 .452 r
.64067 .81049 m .63675 .80269 L .63091 .81728 L p F P
0 g
s
.966 .687 .452 r
.63091 .81728 m .63466 .82568 L .64067 .81049 L p F P
0 g
s
.966 .687 .452 r
.62083 .74995 m .6167 .74266 L .61298 .75543 L p F P
0 g
s
.966 .687 .452 r
.61298 .75543 m .61698 .76337 L .62083 .74995 L p F P
0 g
s
.966 .687 .452 r
.59934 .683 m .59495 .67699 L .59368 .68821 L p F P
0 g
s
.966 .687 .452 r
.59368 .68821 m .598 .69497 L .59934 .683 L p F P
0 g
s
.966 .687 .452 r
.57358 .60272 m .56944 .601 L .57112 .61086 L p F P
0 g
s
.966 .687 .452 r
.57112 .61086 m .57542 .61353 L .57358 .60272 L p F P
0 g
s
.966 .687 .452 r
.58636 .64305 m .58192 .63861 L .5821 .64904 L p F P
0 g
s
.966 .687 .452 r
.5821 .64904 m .58658 .65433 L .58636 .64305 L p F P
0 g
s
.966 .687 .452 r
.55026 .54177 m .55255 .53782 L .54772 .52804 L p F P
0 g
s
.966 .687 .452 r
.55255 .53782 m .55026 .54177 L .55438 .55113 L p F P
0 g
s
.966 .687 .452 r
.58111 .62762 m .57672 .62404 L .57745 .63414 L p F P
0 g
s
.966 .687 .452 r
.57745 .63414 m .58192 .63861 L .58111 .62762 L p F P
0 g
s
.966 .687 .452 r
.53333 .4815 m .53285 .48849 L .53925 .49763 L p F P
0 g
s
.966 .687 .452 r
.53829 .50395 m .53925 .49763 L .53285 .48849 L p F P
0 g
s
.966 .687 .452 r
.53925 .49763 m .53829 .50395 L .54405 .51324 L p F P
0 g
s
.966 .687 .452 r
.59102 .65959 m .58658 .65433 L .58611 .66489 L p F P
0 g
s
.966 .687 .452 r
.58611 .66489 m .59054 .67095 L .59102 .65959 L p F P
0 g
s
.966 .687 .452 r
.6066 .7084 m .60231 .7017 L .60004 .71324 L p F P
0 g
s
.966 .687 .452 r
.60004 .71324 m .60423 .72064 L .6066 .7084 L p F P
0 g
s
.966 .687 .452 r
.63675 .80269 m .63282 .79488 L .62715 .80885 L p F P
0 g
s
.966 .687 .452 r
.62715 .80885 m .63091 .81728 L .63675 .80269 L p F P
0 g
s
.966 .687 .452 r
.54263 .51884 m .54405 .51324 L .53829 .50395 L p F P
0 g
s
.966 .687 .452 r
.54405 .51324 m .54263 .51884 L .54772 .52804 L p F P
0 g
s
.966 .687 .452 r
.52632 .46514 m .52632 .47272 L .53333 .4815 L p F P
0 g
s
.966 .687 .452 r
.53285 .48849 m .53333 .4815 L .52632 .47272 L p F P
0 g
s
.966 .687 .452 r
.57542 .61353 m .57112 .61086 L .57229 .62044 L p F P
0 g
s
.966 .687 .452 r
.57229 .62044 m .57672 .62404 L .57542 .61353 L p F P
0 g
s
.966 .687 .452 r
.6167 .74266 m .61256 .73535 L .60898 .74747 L p F P
0 g
s
.966 .687 .452 r
.60898 .74747 m .61298 .75543 L .6167 .74266 L p F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .56163 .57077 L .55819 .56083 L p F P
0 g
s
.966 .687 .452 r
.56163 .57077 m .55823 .57195 L .56097 .58106 L p F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .56467 .58085 L .56163 .57077 L p F P
0 g
s
.966 .687 .452 r
.56467 .58085 m .56097 .58106 L .56333 .59019 L p F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56729 .59096 L .56467 .58085 L p F P
0 g
s
.966 .687 .452 r
.54585 .53286 m .54772 .52804 L .54263 .51884 L p F P
0 g
s
.966 .687 .452 r
.54772 .52804 m .54585 .53286 L .55026 .54177 L p F P
0 g
s
.966 .687 .452 r
.55511 .56297 m .55819 .56083 L .55438 .55113 L p F P
0 g
s
.966 .687 .452 r
.55819 .56083 m .55511 .56297 L .55823 .57195 L p F P
0 g
s
.966 .687 .452 r
.63282 .79488 m .62887 .78703 L .62338 .8004 L p F P
0 g
s
.966 .687 .452 r
.62338 .8004 m .62715 .80885 L .63282 .79488 L p F P
0 g
s
.966 .687 .452 r
.59495 .67699 m .59054 .67095 L .58933 .68143 L p F P
0 g
s
.966 .687 .452 r
.58933 .68143 m .59368 .68821 L .59495 .67699 L p F P
0 g
s
.966 .687 .452 r
.56729 .59096 m .56333 .59019 L .56528 .59926 L p F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56944 .601 L .56729 .59096 L p F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .55438 .55113 L .55026 .54177 L p F P
0 g
s
.966 .687 .452 r
.55438 .55113 m .55168 .55421 L .55511 .56297 L p F P
0 g
s
.966 .687 .452 r
.60231 .7017 m .598 .69497 L .59584 .70581 L p F P
0 g
s
.966 .687 .452 r
.59584 .70581 m .60004 .71324 L .60231 .7017 L p F P
0 g
s
.966 .687 .452 r
.58192 .63861 m .57745 .63414 L .5776 .64371 L p F P
0 g
s
.966 .687 .452 r
.5776 .64371 m .5821 .64904 L .58192 .63861 L p F P
0 g
s
.966 .687 .452 r
.61256 .73535 m .60841 .72801 L .60497 .73948 L p F P
0 g
s
.966 .687 .452 r
.60497 .73948 m .60898 .74747 L .61256 .73535 L p F P
0 g
s
.966 .687 .452 r
.58658 .65433 m .5821 .64904 L .58165 .65879 L p F P
0 g
s
.966 .687 .452 r
.58165 .65879 m .58611 .66489 L .58658 .65433 L p F P
0 g
s
.966 .687 .452 r
.56944 .601 m .56528 .59926 L .56678 .60817 L p F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .57112 .61086 L .56944 .601 L p F P
0 g
s
.966 .687 .452 r
.53285 .48849 m .53236 .49551 L .53829 .50395 L p F P
0 g
s
.966 .687 .452 r
.53733 .51032 m .53829 .50395 L .53236 .49551 L p F P
0 g
s
.966 .687 .452 r
.53829 .50395 m .53733 .51032 L .54263 .51884 L p F P
0 g
s
.966 .687 .452 r
.57672 .62404 m .57229 .62044 L .57295 .62964 L p F P
0 g
s
.966 .687 .452 r
.57295 .62964 m .57745 .63414 L .57672 .62404 L p F P
0 g
s
.966 .687 .452 r
.62887 .78703 m .62492 .77917 L .6196 .79194 L p F P
0 g
s
.966 .687 .452 r
.6196 .79194 m .62338 .8004 L .62887 .78703 L p F P
0 g
s
.966 .687 .452 r
.54794 .54576 m .55026 .54177 L .54585 .53286 L p F P
0 g
s
.966 .687 .452 r
.55026 .54177 m .54794 .54576 L .55168 .55421 L p F P
0 g
s
.966 .687 .452 r
.5412 .52448 m .54263 .51884 L .53733 .51032 L p F P
0 g
s
.966 .687 .452 r
.54263 .51884 m .5412 .52448 L .54585 .53286 L p F P
0 g
s
.966 .687 .452 r
.52632 .47272 m .52632 .48034 L .53285 .48849 L p F P
0 g
s
.966 .687 .452 r
.53236 .49551 m .53285 .48849 L .52632 .48034 L p F P
0 g
s
.966 .687 .452 r
.59054 .67095 m .58611 .66489 L .58496 .67461 L p F P
0 g
s
.966 .687 .452 r
.58496 .67461 m .58933 .68143 L .59054 .67095 L p F P
0 g
s
.966 .687 .452 r
.57112 .61086 m .56678 .60817 L .56784 .61682 L p F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .57229 .62044 L .57112 .61086 L p F P
0 g
s
.966 .687 .452 r
.598 .69497 m .59368 .68821 L .59162 .69836 L p F P
0 g
s
.966 .687 .452 r
.59162 .69836 m .59584 .70581 L .598 .69497 L p F P
0 g
s
.966 .687 .452 r
.62492 .77917 m .62095 .77128 L .61581 .78346 L p F P
0 g
s
.966 .687 .452 r
.61581 .78346 m .6196 .79194 L .62492 .77917 L p F P
0 g
s
.966 .687 .452 r
.60841 .72801 m .60423 .72064 L .60094 .73147 L p F P
0 g
s
.966 .687 .452 r
.60094 .73147 m .60497 .73948 L .60841 .72801 L p F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .54585 .53286 L .5412 .52448 L p F P
0 g
s
.966 .687 .452 r
.54585 .53286 m .54396 .53771 L .54794 .54576 L p F P
0 g
s
.637 .548 .738 r
.54459 .5667 m .54656 .57521 L .55565 .57266 L p F P
0 g
s
.642 .571 .76 r
.54241 .55836 m .54459 .5667 L .55279 .56439 L p F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .55511 .56297 L p .5549 .56977 L F P
0 g
s
.642 .571 .76 r
.55192 .56216 m .54241 .55836 L .55279 .56439 L F
.647 .594 .781 r
.54004 .55028 m .54241 .55836 L .54963 .55631 L p F P
0 g
s
.966 .687 .452 r
.55511 .56297 m .55168 .55421 L p .5519 .56147 L F P
0 g
s
.647 .594 .781 r
.54866 .55412 m .54004 .55028 L .54963 .55631 L F
.652 .618 .803 r
.53751 .54256 m .54004 .55028 L .54619 .54853 L p F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .54794 .54576 L p .54861 .5534 L F P
0 g
s
.652 .618 .803 r
.54513 .54637 m .53751 .54256 L .54619 .54853 L F
.966 .687 .452 r
.54794 .54576 m .54396 .53771 L p .5451 .54605 L F P
0 g
s
.647 .594 .781 r
.54619 .54853 m .54004 .55028 L p .54866 .55412 L F P
0 g
s
.966 .687 .452 r
.54626 .54867 m .54794 .54576 L p .5451 .54605 L F P
0 g
s
.642 .571 .76 r
.54963 .55631 m .54241 .55836 L p .55192 .56216 L F P
0 g
s
.966 .687 .452 r
.54794 .54576 m .54561 .54978 L .54895 .55732 L p F P
0 g
s
.652 .618 .803 r
.54253 .54112 m .53751 .54256 L p .54513 .54637 L F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .53976 .53015 L p .54141 .53911 L F P
0 g
s
.656 .643 .825 r
.53485 .53527 m .53751 .54256 L .54253 .54112 L p F P
0 g
s
.656 .643 .825 r
.54135 .539 m .53485 .53527 L .54253 .54112 L F
.966 .687 .452 r
.54205 .5426 m .54259 .54123 L p .54141 .53911 L F P
0 g
s
.966 .687 .452 r
.54259 .54123 m .54396 .53771 L p .54141 .53911 L F P
0 g
s
.966 .687 .452 r
.54205 .5426 m .54561 .54978 L p .54505 .54566 L F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .54259 .54123 L p .54505 .54566 L F P
0 g
s
.966 .687 .452 r
.54259 .54123 m .54205 .5426 L p .54505 .54566 L F P
0 g
s
.656 .643 .825 r
.53866 .53417 m .53485 .53527 L p .54135 .539 L F P
0 g
s
.966 .687 .452 r
.53976 .53015 m .53538 .52316 L p .53748 .53227 L F P
0 g
s
.659 .669 .849 r
.53207 .52849 m .53485 .53527 L .53866 .53417 L p F P
0 g
s
.659 .669 .849 r
.53733 .53204 m .53207 .52849 L .53866 .53417 L F
.966 .687 .452 r
.5383 .53587 m .53871 .53425 L p .53748 .53227 L F P
0 g
s
.966 .687 .452 r
.53871 .53425 m .53976 .53015 L p .53748 .53227 L F P
0 g
s
.966 .687 .452 r
.5383 .53587 m .54205 .5426 L p .54126 .53832 L F P
0 g
s
.966 .687 .452 r
.53976 .53015 m .53871 .53425 L p .54126 .53832 L F P
0 g
s
.966 .687 .452 r
.53871 .53425 m .5383 .53587 L p .54126 .53832 L F P
0 g
s
.659 .669 .849 r
.53465 .52775 m .53207 .52849 L p .53733 .53204 L F P
0 g
s
.966 .687 .452 r
.53538 .52316 m .53089 .51682 L p .5334 .526 L F P
0 g
s
.661 .697 .873 r
.52922 .52231 m .53207 .52849 L .53465 .52775 L p F P
0 g
s
.661 .697 .873 r
.533 .52543 m .52922 .52231 L .53465 .52775 L F
.966 .687 .452 r
.5344 .52965 m .53468 .5278 L p .5334 .526 L F P
0 g
s
.966 .687 .452 r
.53468 .5278 m .53538 .52316 L p .5334 .526 L F P
0 g
s
.966 .687 .452 r
.5344 .52965 m .5383 .53587 L p .53729 .53148 L F P
0 g
s
.966 .687 .452 r
.53538 .52316 m .53468 .5278 L p .53729 .53148 L F P
0 g
s
.966 .687 .452 r
.53468 .5278 m .5344 .52965 L p .53729 .53148 L F P
0 g
s
.661 .697 .873 r
.53052 .52193 m .52922 .52231 L p .533 .52543 L F P
0 g
s
.966 .687 .452 r
.53089 .51682 m .52632 .51121 L p .52923 .52036 L F P
0 g
s
.662 .728 .899 r
.52632 .51679 m .52922 .52231 L .53052 .52193 L p F P
0 g
s
.966 .687 .452 r
.53039 .52401 m .53053 .52196 L p .52923 .52036 L F P
0 g
s
.966 .687 .452 r
.53053 .52196 m .53089 .51682 L p .52923 .52036 L F P
0 g
s
.966 .687 .452 r
.53089 .51682 m .53039 .52401 L .5344 .52965 L p F P
0 g
s
.672 .703 .87 r
.53207 .52849 m .52922 .52231 L .52735 .52257 L p F P
0 g
s
.669 .733 .897 r
.52735 .52257 m .52632 .51679 L .52544 .52258 L closepath p F P
0 g
s
.666 .73 .898 r
.52922 .52231 m .52632 .51679 L .52735 .52257 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .51121 m .52632 .51903 L .53039 .52401 L p F P
0 g
s
.662 .728 .899 r
.53052 .52193 m .53095 .52181 L .52632 .51679 L p F P
0 g
s
.661 .697 .873 r
.53551 .5275 m .53095 .52181 L .53052 .52193 L p F P
0 g
s
.661 .697 .873 r
.53551 .5275 m .53052 .52193 L .533 .52543 L F
.53465 .52775 m .53551 .5275 L p .533 .52543 L F P
0 g
s
.659 .669 .849 r
.53994 .5338 m .53551 .5275 L .53465 .52775 L p F P
0 g
s
.659 .669 .849 r
.53994 .5338 m .53465 .52775 L .53733 .53204 L F
.53866 .53417 m .53994 .5338 L p .53733 .53204 L F P
0 g
s
.656 .643 .825 r
.54421 .54064 m .53994 .5338 L .53866 .53417 L p F P
0 g
s
.656 .643 .825 r
.54421 .54064 m .53866 .53417 L .54135 .539 L F
.54253 .54112 m .54421 .54064 L p .54135 .539 L F P
0 g
s
.652 .618 .803 r
.54826 .54794 m .54421 .54064 L .54253 .54112 L p F P
0 g
s
.652 .618 .803 r
.54826 .54794 m .54253 .54112 L .54513 .54637 L F
.966 .687 .452 r
.54561 .54978 m .54626 .54867 L p .54619 .54853 L F P
0 g
s
.966 .687 .452 r
.54515 .54643 m .54619 .54853 L .5451 .54605 L F
.54561 .54978 m .54619 .54853 L .54515 .54643 L F
.54881 .55382 m .55168 .55421 L .54861 .5534 L F
.54969 .55647 m .55168 .55421 L p .54864 .5538 L F P
0 g
s
.637 .548 .738 r
.55279 .56439 m .54459 .5667 L p .55488 .57042 L F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .54895 .55732 L .55202 .56513 L p F P
0 g
s
.647 .594 .781 r
.55205 .55563 m .54826 .54794 L .54619 .54853 L p F P
0 g
s
.966 .687 .452 r
.54864 .5538 m .54881 .55382 L .54861 .5534 L F
.54895 .55732 m .54969 .55647 L p .54864 .5538 L F P
0 g
s
.647 .594 .781 r
.55205 .55563 m .54619 .54853 L .54866 .55412 L F
.652 .618 .803 r
.54619 .54853 m .54826 .54794 L p .54513 .54637 L F P
0 g
s
.966 .687 .452 r
.5521 .56192 m .55511 .56297 L .5519 .56147 L F
.55285 .56455 m .55511 .56297 L p .55191 .56185 L F P
0 g
s
.63 .525 .716 r
.55565 .57266 m .54656 .57521 L p .5575 .57882 L F P
0 g
s
.637 .548 .738 r
.55488 .57042 m .54459 .5667 L .55565 .57266 L F
.966 .687 .452 r
.55511 .56297 m .55202 .56513 L .55479 .57315 L p F P
0 g
s
.642 .571 .76 r
.55554 .56361 m .55205 .55563 L .54963 .55631 L p F P
0 g
s
.966 .687 .452 r
.55191 .56185 m .5521 .56192 L .5519 .56147 L F
.55202 .56513 m .55285 .56455 L p .55191 .56185 L F P
0 g
s
.642 .571 .76 r
.55554 .56361 m .54963 .55631 L .55192 .56216 L F
.647 .594 .781 r
.54963 .55631 m .55205 .55563 L p .54866 .55412 L F P
0 g
s
.637 .548 .738 r
.5587 .57181 m .55554 .56361 L .55279 .56439 L p F P
0 g
s
.966 .687 .452 r
.55489 .57014 m .55508 .57024 L .5549 .56977 L F
.55508 .57024 m .55823 .57195 L .5549 .56977 L F
.55488 .57043 m .55499 .57049 L .55489 .57014 L F
.637 .548 .738 r
.5587 .57181 m .55279 .56439 L .55488 .57042 L F
.642 .571 .76 r
.55279 .56439 m .55554 .56361 L p .55192 .56216 L F P
0 g
s
.966 .687 .452 r
.55499 .57049 m .55823 .57195 L .55489 .57014 L F
.55571 .57283 m .55823 .57195 L p .55488 .57043 L F P
0 g
s
.63 .525 .716 r
.54656 .57521 m .5483 .58381 L .55818 .58106 L p F P
0 g
s
.63 .525 .716 r
.5575 .57882 m .54656 .57521 L .55818 .58106 L F
.966 .687 .452 r
.55479 .57315 m .55725 .58127 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .5557 .57283 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.5557 .57283 m .55479 .57315 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .55823 .57195 L p .55753 .57855 L F P
0 g
s
.966 .687 .452 r
.55725 .58127 m .55822 .58122 L p .55753 .57855 L F P
0 g
s
.966 .687 .452 r
.55822 .58122 m .56097 .58106 L p .55753 .57855 L F P
0 g
s
.624 .501 .693 r
.55818 .58106 m .5483 .58381 L p .55977 .58726 L F P
0 g
s
.624 .501 .693 r
.5483 .58381 m .54979 .59241 L .56034 .58948 L p F P
0 g
s
.624 .501 .693 r
.55977 .58726 m .5483 .58381 L .56034 .58948 L F
.966 .687 .452 r
.55725 .58127 m .55935 .58942 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .55822 .58122 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.55822 .58122 m .55725 .58127 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56097 .58106 L p .55982 .58701 L F P
0 g
s
.966 .687 .452 r
.55935 .58942 m .56037 .58962 L p .55982 .58701 L F P
0 g
s
.966 .687 .452 r
.56037 .58962 m .56333 .59019 L p .55982 .58701 L F P
0 g
s
.616 .476 .669 r
.56034 .58948 m .54979 .59241 L p .56166 .59567 L F P
0 g
s
.616 .476 .669 r
.54979 .59241 m .55102 .60091 L .56213 .59784 L p F P
0 g
s
.616 .476 .669 r
.56166 .59567 m .54979 .59241 L .56213 .59784 L F
.966 .687 .452 r
.55935 .58942 m .56108 .59751 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56037 .58962 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56037 .58962 m .55935 .58942 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56333 .59019 L p .56172 .59543 L F P
0 g
s
.966 .687 .452 r
.56108 .59751 m .56215 .59796 L p .56172 .59543 L F P
0 g
s
.966 .687 .452 r
.56215 .59796 m .56528 .59926 L p .56172 .59543 L F P
0 g
s
.607 .45 .642 r
.56213 .59784 m .55102 .60091 L p .56315 .60394 L F P
0 g
s
.607 .45 .642 r
.56315 .60394 m .55102 .60091 L .56351 .60606 L F
.966 .687 .452 r
.56108 .59751 m .56242 .60546 L p .56314 .60389 L F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56215 .59796 L p .56314 .60389 L F P
0 g
s
.966 .687 .452 r
.56215 .59796 m .56108 .59751 L p .56314 .60389 L F P
0 g
s
.607 .45 .642 r
.55102 .60091 m .55197 .60922 L .56351 .60606 L p F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .56528 .59926 L p .56323 .60371 L F P
0 g
s
.966 .687 .452 r
.56242 .60546 m .56352 .60614 L p .56323 .60371 L F P
0 g
s
.966 .687 .452 r
.56352 .60614 m .56678 .60817 L p .56323 .60371 L F P
0 g
s
.597 .421 .613 r
.56351 .60606 m .55197 .60922 L p .56423 .61199 L F P
0 g
s
.597 .421 .613 r
.56423 .61199 m .55197 .60922 L .56447 .61403 L F
.966 .687 .452 r
.56242 .60546 m .56335 .61317 L p .56421 .61191 L F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .56352 .60614 L p .56421 .61191 L F P
0 g
s
.966 .687 .452 r
.56352 .60614 m .56242 .60546 L p .56421 .61191 L F P
0 g
s
.597 .421 .613 r
.55197 .60922 m .55264 .61726 L .56447 .61403 L p F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .56678 .60817 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.56335 .61317 m .56447 .61408 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.56447 .61408 m .56784 .61682 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.57229 .62044 m .56784 .61682 L .56842 .62512 L p F P
0 g
s
.585 .388 .581 r
.56447 .61403 m .55264 .61726 L p .56487 .61974 L F P
0 g
s
.585 .388 .581 r
.56487 .61974 m .55264 .61726 L .565 .62168 L F
.966 .687 .452 r
.56335 .61317 m .56386 .62056 L p .56486 .61962 L F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .56447 .61408 L p .56486 .61962 L F P
0 g
s
.966 .687 .452 r
.56447 .61408 m .56335 .61317 L p .56486 .61962 L F P
0 g
s
.585 .388 .581 r
.55264 .61726 m .553 .62494 L .565 .62168 L p F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .56784 .61682 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.56386 .62056 m .565 .6217 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.565 .6217 m .56842 .62512 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .57295 .62964 L .57229 .62044 L p F P
0 g
s
.966 .687 .452 r
.57295 .62964 m .56842 .62512 L .56852 .63297 L p F P
0 g
s
.571 .351 .543 r
.565 .62168 m .553 .62494 L p .56507 .62711 L F P
0 g
s
.571 .351 .543 r
.56507 .62711 m .553 .62494 L .56509 .62892 L F
.966 .687 .452 r
.56386 .62056 m .56395 .62756 L p .56507 .62694 L F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .565 .6217 L p .56507 .62694 L F P
0 g
s
.966 .687 .452 r
.565 .6217 m .56386 .62056 L p .56507 .62694 L F P
0 g
s
.571 .351 .543 r
.553 .62494 m .55306 .63218 L .56509 .62892 L p F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .56842 .62512 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56395 .62756 m .56509 .62891 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56509 .62891 m .56852 .63297 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .57308 .63836 L .57295 .62964 L p F P
0 g
s
.966 .687 .452 r
.57308 .63836 m .56852 .63297 L .56815 .6403 L p F P
0 g
s
.553 .307 .498 r
.56509 .62892 m .55306 .63218 L p .56482 .63399 L F P
0 g
s
.553 .307 .498 r
.56482 .63399 m .55306 .63218 L .56473 .63567 L F
.966 .687 .452 r
.56395 .62756 m .5636 .63407 L p .56483 .6338 L F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .56509 .62891 L p .56483 .6338 L F P
0 g
s
.966 .687 .452 r
.56509 .62891 m .56395 .62756 L p .56483 .6338 L F P
0 g
s
.553 .307 .498 r
.55306 .63218 m .55282 .63888 L .56473 .63567 L p F P
0 g
s
.966 .687 .452 r
.56815 .6403 m .56852 .63297 L p .56498 .63376 L F P
0 g
s
.966 .687 .452 r
.5636 .63407 m .56474 .63563 L p .56498 .63376 L F P
0 g
s
.966 .687 .452 r
.56474 .63563 m .56815 .6403 L p .56498 .63376 L F P
0 g
s
.529 .254 .442 r
.56473 .63567 m .55282 .63888 L p .56413 .64033 L F P
0 g
s
.966 .687 .452 r
.56815 .6403 m .5636 .63407 L .56282 .64004 L p F P
0 g
s
.966 .687 .452 r
.56729 .64701 m .56815 .6403 L p .56433 .64011 L F P
0 g
s
.966 .687 .452 r
.56427 .64035 m .56729 .64701 L .56433 .64011 L F
.56394 .64179 m .56729 .64701 L p .56416 .6401 L F P
0 g
s
.497 .188 .373 r
.56394 .64186 m .55227 .64499 L p .563 .64604 L F P
0 g
s
.529 .254 .442 r
.55282 .63888 m .55227 .64499 L .56394 .64186 L p F P
0 g
s
.529 .254 .442 r
.56413 .64033 m .55282 .63888 L .56394 .64186 L F
.966 .687 .452 r
.56282 .64004 m .56161 .64538 L p .56306 .64579 L F P
0 g
s
.966 .687 .452 r
.56729 .64701 m .56439 .64249 L p .56323 .64584 L F P
0 g
s
.497 .188 .373 r
.563 .64604 m .55227 .64499 L .5627 .6474 L F
.966 .687 .452 r
.56161 .64538 m .56595 .65303 L .56729 .64701 L p F P
0 g
s
.453 .103 .281 r
.5627 .6474 m .55142 .65041 L p .56143 .65106 L F P
0 g
s
.497 .188 .373 r
.55227 .64499 m .55142 .65041 L .5627 .6474 L p F P
0 g
s
.966 .687 .452 r
.56161 .64538 m .55999 .65003 L p .56152 .6508 L F P
0 g
s
.966 .687 .452 r
.56595 .65303 m .56315 .64809 L p .56171 .6509 L F P
0 g
s
.453 .103 .281 r
.56143 .65106 m .55142 .65041 L .56103 .65223 L F
.966 .687 .452 r
.55999 .65003 m .56415 .65828 L .56595 .65303 L p F P
0 g
s
.389 0 .157 r
.56103 .65223 m .55027 .6551 L p .55945 .65532 L F P
0 g
s
.453 .103 .281 r
.55142 .65041 m .55027 .6551 L .56103 .65223 L p F P
0 g
s
.966 .687 .452 r
.55999 .65003 m .55797 .65393 L p .55958 .65506 L F P
0 g
s
.966 .687 .452 r
.56415 .65828 m .56148 .65298 L p .55978 .65521 L F P
0 g
s
.389 0 .157 r
.55945 .65532 m .55027 .6551 L .55895 .65629 L F
.966 .687 .452 r
.55797 .65393 m .56189 .6627 L .56415 .65828 L p F P
0 g
s
.293 0 0 r
.55895 .65629 m .54883 .65898 L p .55706 .65876 L F P
0 g
s
.389 0 .157 r
.55027 .6551 m .54883 .65898 L .55895 .65629 L p F P
0 g
s
.966 .687 .452 r
.55797 .65393 m .55557 .65703 L p .55723 .65853 L F P
0 g
s
.966 .687 .452 r
.56189 .6627 m .55939 .6571 L p .55744 .65872 L F P
0 g
s
.293 0 0 r
.55706 .65876 m .54883 .65898 L .55647 .65952 L F
.966 .687 .452 r
.55557 .65703 m .5592 .66622 L .56189 .6627 L p F P
0 g
s
.148 0 0 r
.55647 .65952 m .54713 .66201 L p .55429 .66134 L F P
0 g
s
.293 0 0 r
.54883 .65898 m .54713 .66201 L .55647 .65952 L p F P
0 g
s
.966 .687 .452 r
.55557 .65703 m .5528 .65929 L p .55451 .66115 L F P
0 g
s
.966 .687 .452 r
.5592 .66622 m .55689 .66039 L p .55473 .66138 L F P
0 g
s
.148 0 0 r
.55429 .66134 m .54713 .66201 L .55363 .66189 L F
.966 .687 .452 r
.5528 .65929 m .5561 .6688 L .5592 .66622 L p F P
0 g
s
0 0 0 r
.55363 .66189 m .54517 .66413 L p .55117 .66301 L F P
0 g
s
.148 0 0 r
.54713 .66201 m .54517 .66413 L .55363 .66189 L p F P
0 g
s
.966 .687 .452 r
.5528 .65929 m .54971 .66067 L p .55144 .66288 L F P
0 g
s
.966 .687 .452 r
.55144 .66288 m .55166 .66316 L .55369 .66186 L F
.55402 .66281 m .55369 .66186 L p .55166 .66316 L F P
0 g
s
0 0 0 r
.55117 .66301 m .54517 .66413 L .55044 .66334 L F
.966 .687 .452 r
.54971 .66067 m .55263 .67039 L .5561 .6688 L p F P
0 g
s
0 0 0 r
.54517 .66413 m .54297 .66532 L .55044 .66334 L p F P
0 g
s
.266 .772 .776 r
.55044 .66334 m .54297 .66532 L p .54772 .66374 L F P
0 g
s
.43 0 .047 r
.53434 .66085 m .53374 .66373 L .54713 .66201 L p F P
0 g
s
.43 0 .047 r
.54713 .66201 m .54883 .65898 L .53434 .66085 L p F P
0 g
s
.31 0 0 r
.54517 .66413 m .54713 .66201 L .53374 .66373 L p F P
0 g
s
.966 .687 .452 r
.54971 .66067 m .54631 .66115 L p .54805 .66369 L F P
0 g
s
.966 .687 .452 r
.55263 .67039 m .55051 .66333 L p .54805 .66369 L F P
0 g
s
.966 .687 .452 r
.55051 .66333 m .54971 .66067 L p .54805 .66369 L F P
0 g
s
.126 0 0 r
.53304 .66569 m .53225 .6667 L .54297 .66532 L p F P
0 g
s
.126 0 0 r
.54297 .66532 m .54517 .66413 L .53304 .66569 L p F P
0 g
s
.266 .772 .776 r
.54297 .66532 m .54056 .66555 L .54694 .66386 L p F P
0 g
s
.266 .772 .776 r
.54772 .66374 m .54297 .66532 L .54694 .66386 L F
.966 .687 .452 r
.54883 .67097 m .55263 .67039 L p .54827 .66401 L F P
0 g
s
.966 .687 .452 r
.54631 .66115 m .54701 .66387 L p .54827 .66401 L F P
0 g
s
.966 .687 .452 r
.54701 .66387 m .54883 .67097 L p .54827 .66401 L F P
0 g
s
.31 0 0 r
.53374 .66373 m .53304 .66569 L .54517 .66413 L p F P
0 g
s
.44 .867 .932 r
.54694 .66386 m .54056 .66555 L p .54398 .66352 L F P
0 g
s
.966 .687 .452 r
.54631 .66115 m .54266 .6607 L p .54438 .66356 L F P
0 g
s
.966 .687 .452 r
.54883 .67097 m .54701 .66387 L p .54438 .66356 L F P
0 g
s
.966 .687 .452 r
.54701 .66387 m .54631 .66115 L p .54438 .66356 L F P
0 g
s
.44 .867 .932 r
.54056 .66555 m .53796 .66481 L .54318 .66343 L p F P
0 g
s
.44 .867 .932 r
.54398 .66352 m .54056 .66555 L .54318 .66343 L F
.966 .687 .452 r
.54472 .67051 m .54883 .67097 L p .54459 .66392 L F P
0 g
s
.966 .687 .452 r
.54266 .6607 m .54324 .66345 L p .54459 .66392 L F P
0 g
s
.966 .687 .452 r
.54324 .66345 m .54472 .67051 L p .54459 .66392 L F P
0 g
s
.547 .881 .989 r
.54318 .66343 m .53796 .66481 L p .53999 .66232 L F P
0 g
s
.505 .097 .201 r
.53486 .6571 m .53434 .66085 L .54883 .65898 L p F P
0 g
s
.11 .662 .722 r
.54056 .66555 m .54297 .66532 L .53225 .6667 L p F P
0 g
s
.966 .687 .452 r
.54266 .6607 m .53879 .65933 L p .54046 .66248 L F P
0 g
s
.966 .687 .452 r
.54472 .67051 m .54324 .66345 L p .54046 .66248 L F P
0 g
s
.966 .687 .452 r
.54324 .66345 m .54266 .6607 L p .54046 .66248 L F P
0 g
s
.547 .881 .989 r
.53796 .66481 m .5352 .66309 L .53918 .66203 L p F P
0 g
s
.547 .881 .989 r
.53999 .66232 m .53796 .66481 L .53918 .66203 L F
.246 0 0 r
.52061 .66576 m .52128 .66676 L .53225 .6667 L p F P
0 g
s
.246 0 0 r
.53225 .6667 m .53304 .66569 L .52061 .66576 L p F P
0 g
s
.004 0 0 r
.5314 .66673 m .53225 .6667 L .52128 .66676 L p F P
0 g
s
.11 .662 .722 r
.53225 .6667 m .5314 .66673 L .54056 .66555 L p F P
0 g
s
.329 .803 .913 r
.53796 .66481 m .54056 .66555 L .5314 .66673 L p F P
0 g
s
.966 .687 .452 r
.54037 .669 m .54472 .67051 L p .54066 .66287 L F P
0 g
s
.966 .687 .452 r
.53879 .65933 m .53923 .66206 L p .54066 .66287 L F P
0 g
s
.966 .687 .452 r
.53923 .66206 m .54037 .669 L p .54066 .66287 L F P
0 g
s
.603 .855 .991 r
.53918 .66203 m .5352 .66309 L p .53578 .66012 L F P
0 g
s
.631 .259 .321 r
.51873 .6526 m .51907 .65717 L .53486 .6571 L p F P
0 g
s
.631 .259 .321 r
.53486 .6571 m .53526 .65251 L .51873 .6526 L p F P
0 g
s
.592 .173 .215 r
.53434 .66085 m .53486 .6571 L .51907 .65717 L p F P
0 g
s
.966 .687 .452 r
.53879 .65933 m .53474 .65705 L p .53634 .66044 L F P
0 g
s
.966 .687 .452 r
.54037 .669 m .53923 .66206 L p .53634 .66044 L F P
0 g
s
.966 .687 .452 r
.53923 .66206 m .53879 .65933 L p .53634 .66044 L F P
0 g
s
.592 .173 .215 r
.51907 .65717 m .51951 .66093 L .53434 .66085 L p F P
0 g
s
.529 .052 .067 r
.53374 .66373 m .53434 .66085 L .51951 .66093 L p F P
0 g
s
.603 .855 .991 r
.5352 .66309 m .53232 .66041 L .53501 .65969 L p F P
0 g
s
.603 .855 .991 r
.53578 .66012 m .5352 .66309 L .53501 .65969 L F
.422 0 0 r
.52002 .6638 m .52061 .66576 L .53304 .66569 L p F P
0 g
s
.422 0 0 r
.53304 .66569 m .53374 .66373 L .52002 .6638 L p F P
0 g
s
.329 .803 .913 r
.5314 .66673 m .53047 .66578 L .53796 .66481 L p F P
0 g
s
.479 .847 .989 r
.5352 .66309 m .53796 .66481 L .53047 .66578 L p F P
0 g
s
.966 .687 .452 r
.53581 .66646 m .54037 .669 L p .53653 .66085 L F P
0 g
s
.966 .687 .452 r
.53474 .65705 m .53504 .65972 L p .53653 .66085 L F P
0 g
s
.966 .687 .452 r
.53504 .65972 m .53581 .66646 L p .53653 .66085 L F P
0 g
s
.632 .817 .971 r
.53501 .65969 m .53232 .66041 L p .53162 .65793 L F P
0 g
s
.632 .817 .971 r
.53175 .65787 m .53501 .65969 L .53162 .65793 L F
.53225 .6576 m .53501 .65969 L .53157 .65778 L F
.529 .052 .067 r
.51951 .66093 m .52002 .6638 L .53374 .66373 L p F P
0 g
s
.479 .847 .989 r
.53047 .66578 m .52949 .66383 L .5352 .66309 L p F P
0 g
s
.566 .838 .996 r
.53232 .66041 m .5352 .66309 L .52949 .66383 L p F P
0 g
s
.966 .687 .452 r
.53581 .66646 m .53474 .65705 L .53211 .65504 L p F P
0 g
s
.584 .392 .587 r
.53028 .65555 m .53205 .65508 L p .53213 .65763 L F P
0 g
s
.966 .687 .452 r
.53211 .65504 m .53204 .65499 L p .53236 .65817 L F P
0 g
s
.966 .687 .452 r
.53228 .65798 m .53236 .65817 L .53204 .65499 L F
.53236 .65817 m .53581 .66646 L .53211 .65504 L F
.671 .374 .46 r
.5183 .6412 m .51847 .64725 L .53557 .64716 L p F P
0 g
s
.671 .374 .46 r
.53557 .64716 m .53576 .64112 L .5183 .6412 L p F P
0 g
s
.655 .324 .399 r
.51847 .64725 m .51873 .6526 L .53526 .65251 L p F P
0 g
s
.655 .324 .399 r
.53526 .65251 m .53557 .64716 L .51847 .64725 L p F P
0 g
s
.683 .414 .509 r
.51823 .63453 m .5183 .6412 L .53576 .64112 L p F P
0 g
s
.683 .414 .509 r
.53576 .64112 m .53585 .63444 L .51823 .63453 L p F P
0 g
s
.966 .687 .452 r
.53367 .64767 m .53261 .63833 L .53059 .63677 L p F P
0 g
s
.966 .687 .452 r
.53082 .63966 m .53367 .64767 L .53059 .63677 L F
.696 .475 .583 r
.51836 .6196 m .51825 .6273 L .53583 .62721 L p F P
0 g
s
.69 .446 .549 r
.51825 .6273 m .51823 .63453 L .53585 .63444 L p F P
0 g
s
.69 .446 .549 r
.53585 .63444 m .53583 .62721 L .51825 .6273 L p F P
0 g
s
.7 .499 .613 r
.51856 .61151 m .51836 .6196 L .5357 .61951 L p F P
0 g
s
.696 .475 .583 r
.53583 .62721 m .5357 .61951 L .51836 .6196 L p F P
0 g
s
.7 .499 .613 r
.5357 .61951 m .53546 .61142 L .51856 .61151 L p F P
0 g
s
.966 .687 .452 r
.52915 .6187 m .5305 .61976 L p .52865 .61233 L F P
0 g
s
.584 .392 .587 r
.52988 .62777 m .52878 .62807 L p .52931 .62065 L F P
0 g
s
.966 .687 .452 r
.53155 .62903 m .5305 .61976 L .52915 .6187 L p F P
0 g
s
.966 .687 .452 r
.52937 .62144 m .53155 .62903 L .52915 .6187 L F
.584 .392 .587 r
.52878 .62807 m .52828 .61899 L .52916 .61875 L p F P
0 g
s
.584 .392 .587 r
.52916 .61875 m .52945 .61867 L p .52931 .62065 L F P
0 g
s
.584 .392 .587 r
.52931 .62065 m .52878 .62807 L .52916 .61875 L F
.52916 .61875 m .52828 .61899 L p .52859 .61156 L F P
0 g
s
.966 .687 .452 r
.52842 .61813 m .52895 .627 L .52987 .62772 L p F P
0 g
s
.966 .687 .452 r
.52987 .62772 m .53155 .62903 L p .52937 .62144 L F P
0 g
s
.966 .687 .452 r
.52842 .61813 m .52987 .62772 L .52937 .62144 L F
.52915 .6187 m .52842 .61813 L p .52937 .62144 L F P
0 g
s
.702 .521 .64 r
.51885 .60312 m .51856 .61151 L .53546 .61142 L p F P
0 g
s
.704 .542 .665 r
.51922 .59452 m .51885 .60312 L .53512 .60304 L p F P
0 g
s
.702 .521 .64 r
.53546 .61142 m .53512 .60304 L .51885 .60312 L p F P
0 g
s
.584 .392 .587 r
.52779 .60994 m .52729 .60094 L .52773 .60082 L p F P
0 g
s
.584 .392 .587 r
.52786 .60245 m .52779 .60994 L .52773 .60082 L F
.966 .687 .452 r
.52844 .60973 m .52944 .61053 L p .52792 .60317 L F P
0 g
s
.966 .687 .452 r
.52944 .61053 m .5284 .60133 L .52773 .60079 L p F P
0 g
s
.966 .687 .452 r
.52792 .60317 m .52944 .61053 L .52773 .60079 L F
.584 .392 .587 r
.52788 .60078 m .52866 .6097 L .52844 .60976 L p F P
0 g
s
.584 .392 .587 r
.52844 .60976 m .52779 .60994 L p .52786 .60245 L F P
0 g
s
.584 .392 .587 r
.52788 .60078 m .52844 .60976 L .52786 .60245 L F
.966 .687 .452 r
.52773 .60079 m .52736 .6005 L p .52792 .60317 L F P
0 g
s
.966 .687 .452 r
.52736 .6005 m .52789 .60929 L .52844 .60973 L p F P
0 g
s
.966 .687 .452 r
.52736 .6005 m .52844 .60973 L .52792 .60317 L F
.584 .392 .587 r
.52773 .60082 m .52788 .60078 L p .52786 .60245 L F P
0 g
s
.966 .687 .452 r
.5305 .61976 m .52944 .61053 L .52844 .60973 L p F P
0 g
s
.584 .392 .587 r
.52828 .61899 m .52779 .60994 L .52844 .60976 L p F P
0 g
s
.584 .392 .587 r
.52859 .61156 m .52828 .61899 L .52844 .60976 L F
.966 .687 .452 r
.52844 .60973 m .52789 .60929 L p .52865 .61233 L F P
0 g
s
.966 .687 .452 r
.52865 .61233 m .5305 .61976 L .52844 .60973 L F
.584 .392 .587 r
.52844 .60976 m .52866 .6097 L p .52859 .61156 L F P
0 g
s
.584 .392 .587 r
.52866 .6097 m .52945 .61867 L .52916 .61875 L p F P
0 g
s
.584 .392 .587 r
.52866 .6097 m .52916 .61875 L .52859 .61156 L F
.966 .687 .452 r
.53261 .63833 m .53155 .62903 L .52987 .62772 L p F P
0 g
s
.584 .392 .587 r
.52927 .63719 m .52878 .62807 L .52988 .62777 L p F P
0 g
s
.584 .392 .587 r
.53003 .62974 m .52927 .63719 L .52988 .62777 L F
.966 .687 .452 r
.5301 .63054 m .53261 .63833 L .52987 .62772 L F
.584 .392 .587 r
.5306 .63684 m .52927 .63719 L p .53003 .62974 L F P
0 g
s
.966 .687 .452 r
.52895 .627 m .52949 .63591 L .53059 .63677 L p F P
0 g
s
.966 .687 .452 r
.53059 .63677 m .53261 .63833 L p .5301 .63054 L F P
0 g
s
.966 .687 .452 r
.52895 .627 m .53059 .63677 L .5301 .63054 L F
.584 .392 .587 r
.53024 .62767 m .53104 .63672 L .5306 .63684 L p F P
0 g
s
.584 .392 .587 r
.53024 .62767 m .5306 .63684 L .53003 .62974 L F
.966 .687 .452 r
.52987 .62772 m .52895 .627 L p .5301 .63054 L F P
0 g
s
.584 .392 .587 r
.52988 .62777 m .53024 .62767 L p .53003 .62974 L F P
0 g
s
.584 .392 .587 r
.52945 .61867 m .53024 .62767 L .52988 .62777 L p F P
0 g
s
.584 .392 .587 r
.52945 .61867 m .52988 .62777 L .52931 .62065 L F
.966 .687 .452 r
.52789 .60929 m .52842 .61813 L .52915 .6187 L p F P
0 g
s
.966 .687 .452 r
.52789 .60929 m .52915 .6187 L .52865 .61233 L F
.584 .392 .587 r
.53132 .64594 m .52978 .64635 L p .53076 .63886 L F P
0 g
s
.966 .687 .452 r
.53474 .65705 m .53367 .64767 L .53132 .64586 L p F P
0 g
s
.584 .392 .587 r
.53028 .65555 m .52978 .64635 L .53132 .64594 L p F P
0 g
s
.584 .392 .587 r
.53149 .64801 m .53028 .65555 L .53132 .64594 L F
.966 .687 .452 r
.53155 .6488 m .53474 .65705 L .53132 .64586 L F
.584 .392 .587 r
.53205 .65508 m .53028 .65555 L p .53149 .64801 L F P
0 g
s
.966 .687 .452 r
.53003 .64487 m .53057 .65386 L .53204 .65499 L p F P
0 g
s
.966 .687 .452 r
.53204 .65499 m .53474 .65705 L p .53155 .6488 L F P
0 g
s
.966 .687 .452 r
.53003 .64487 m .53204 .65499 L .53155 .6488 L F
.584 .392 .587 r
.52978 .64635 m .52927 .63719 L .5306 .63684 L p F P
0 g
s
.584 .392 .587 r
.53076 .63886 m .52978 .64635 L .5306 .63684 L F
.966 .687 .452 r
.52949 .63591 m .53003 .64487 L .53132 .64586 L p F P
0 g
s
.966 .687 .452 r
.53132 .64586 m .53367 .64767 L p .53082 .63966 L F P
0 g
s
.966 .687 .452 r
.52949 .63591 m .53132 .64586 L .53082 .63966 L F
.584 .392 .587 r
.5306 .63684 m .53104 .63672 L p .53076 .63886 L F P
0 g
s
.584 .392 .587 r
.53184 .6458 m .53264 .65492 L .53205 .65508 L p F P
0 g
s
.584 .392 .587 r
.53184 .6458 m .53205 .65508 L .53149 .64801 L F
.966 .687 .452 r
.53132 .64586 m .53003 .64487 L p .53155 .6488 L F P
0 g
s
.584 .392 .587 r
.53132 .64594 m .53184 .6458 L p .53149 .64801 L F P
0 g
s
.584 .392 .587 r
.53104 .63672 m .53184 .6458 L .53132 .64594 L p F P
0 g
s
.584 .392 .587 r
.53104 .63672 m .53132 .64594 L .53076 .63886 L F
.966 .687 .452 r
.53059 .63677 m .52949 .63591 L p .53082 .63966 L F P
0 g
s
.584 .392 .587 r
.53205 .65508 m .53264 .65492 L p .53222 .65718 L F P
0 g
s
.584 .392 .587 r
.53222 .65718 m .53213 .65763 L .53205 .65508 L F
.566 .838 .996 r
.52949 .66383 m .52846 .66091 L .53232 .66041 L p F P
0 g
s
.614 .808 .975 r
.53232 .66041 m .52846 .66091 L p .52899 .65842 L F P
0 g
s
.644 .438 .589 r
.52773 .65588 m .53028 .65555 L p .52963 .65819 L F P
0 g
s
.614 .808 .975 r
.52903 .65827 m .53042 .65809 L .52899 .65842 L F
.53042 .65809 m .53232 .66041 L p .52899 .65842 L F P
0 g
s
.422 .809 .989 r
.52279 .66581 m .52363 .66386 L .52949 .66383 L p F P
0 g
s
.422 .809 .989 r
.52949 .66383 m .53047 .66578 L .52279 .66581 L p F P
0 g
s
.533 .816 .998 r
.52363 .66386 m .5245 .66093 L .52846 .66091 L p F P
0 g
s
.533 .816 .998 r
.52846 .66091 m .52949 .66383 L .52363 .66386 L p F P
0 g
s
.598 .797 .976 r
.52846 .66091 m .5245 .66093 L p .52625 .65858 L F P
0 g
s
.697 .48 .59 r
.52512 .6559 m .52773 .65588 L p .52697 .65843 L F P
0 g
s
.598 .797 .976 r
.52635 .65844 m .52778 .65843 L .52625 .65858 L F
.52778 .65843 m .52846 .66091 L p .52625 .65858 L F P
0 g
s
.697 .48 .59 r
.52507 .65844 m .52512 .6559 L p .52697 .65843 L F P
0 g
s
.598 .797 .976 r
.5254 .65704 m .5274 .65703 L p .52627 .65855 L F P
0 g
s
.598 .797 .976 r
.5245 .66093 m .52507 .65844 L p .52627 .65855 L F P
0 g
s
.598 .797 .976 r
.52507 .65844 m .5254 .65704 L p .52627 .65855 L F P
0 g
s
.496 0 0 r
.52061 .66576 m .52002 .6638 L .50658 .66221 L p F P
0 g
s
.496 0 0 r
.50658 .66221 m .50844 .66432 L .52061 .66576 L p F P
0 g
s
.384 .771 .989 r
.52363 .66386 m .52279 .66581 L .51528 .66492 L p F P
0 g
s
.603 .108 .05 r
.52002 .6638 m .51951 .66093 L .50496 .6592 L p F P
0 g
s
.603 .108 .05 r
.50496 .6592 m .50658 .66221 L .52002 .6638 L p F P
0 g
s
.384 .771 .989 r
.51528 .66492 m .51789 .66318 L .52363 .66386 L p F P
0 g
s
.508 .791 .996 r
.5245 .66093 m .52363 .66386 L .51789 .66318 L p F P
0 g
s
.508 .791 .996 r
.51789 .66318 m .52062 .66047 L .5245 .66093 L p F P
0 g
s
.663 .227 .203 r
.51951 .66093 m .51907 .65717 L .5036 .65533 L p F P
0 g
s
.697 .311 .313 r
.51907 .65717 m .51873 .6526 L .50252 .65066 L p F P
0 g
s
.697 .311 .313 r
.50252 .65066 m .5036 .65533 L .51907 .65717 L p F P
0 g
s
.718 .373 .394 r
.50171 .64524 m .50252 .65066 L .51873 .6526 L p F P
0 g
s
.718 .373 .394 r
.51873 .6526 m .51847 .64725 L .50171 .64524 L p F P
0 g
s
.73 .421 .457 r
.51847 .64725 m .5183 .6412 L .50119 .63915 L p F P
0 g
s
.73 .421 .457 r
.50119 .63915 m .50171 .64524 L .51847 .64725 L p F P
0 g
s
.938 .808 .351 r
.51589 .64169 m .51436 .65025 L .51419 .64876 L p F P
0 g
s
.938 .808 .351 r
.51389 .65213 m .51385 .65182 L .51419 .64876 L F
.51419 .64876 m .51436 .65025 L p .51389 .65214 L F P
0 g
s
.938 .808 .351 r
.51389 .65214 m .51389 .65213 L .51419 .64876 L F
.999 .797 .499 r
.51436 .65025 m .5151 .65167 L p .51448 .65364 L F P
0 g
s
.999 .797 .499 r
.51448 .65364 m .51447 .65362 L .51436 .65025 L F
.579 .72 .939 r
.51431 .6533 m .51404 .65326 L .51395 .6526 L F
.50817 .65238 m .51395 .6526 L p .51404 .65326 L F P
0 g
s
.587 .712 .929 r
.51395 .6526 m .51336 .65258 L p .51385 .65179 L F P
0 g
s
.587 .712 .929 r
.51336 .65258 m .50817 .65238 L p .51356 .65182 L F P
0 g
s
.587 .712 .929 r
.51336 .65258 m .51356 .65182 L .51385 .65179 L F
.50789 .65012 m .51376 .65107 L p .51385 .65179 L F P
0 g
s
.938 .808 .351 r
.51436 .65025 m .51395 .6526 L p .51389 .65216 L F P
0 g
s
.999 .797 .499 r
.51395 .6526 m .51436 .65025 L p .51447 .65362 L F P
0 g
s
.938 .808 .351 r
.51376 .65107 m .51419 .64876 L p .51385 .65187 L F P
0 g
s
.9 .665 .575 r
.51636 .65298 m .51762 .64409 L .51912 .64508 L p F P
0 g
s
.9 .665 .575 r
.51912 .64508 m .51807 .6541 L .51636 .65298 L p F P
0 g
s
.957 .73 .554 r
.5151 .65167 m .51653 .64295 L .51762 .64409 L p F P
0 g
s
.957 .73 .554 r
.51762 .64409 m .51636 .65298 L .5151 .65167 L p F P
0 g
s
.999 .797 .499 r
.51653 .64295 m .5151 .65167 L .51436 .65025 L p F P
0 g
s
.579 .72 .939 r
.51471 .65408 m .50929 .65454 L p .51431 .6533 L F P
0 g
s
.572 .73 .949 r
.51121 .65652 m .50929 .65454 L p .51506 .65471 L F P
0 g
s
.572 .73 .949 r
.51511 .65481 m .51121 .65652 L .51506 .65471 L F
.51552 .65554 m .51121 .65652 L p .51511 .65481 L F P
0 g
s
.569 .743 .958 r
.51382 .65821 m .51121 .65652 L p .5166 .656 L F P
0 g
s
.569 .743 .958 r
.51669 .65609 m .51382 .65821 L .5166 .656 L F
.51779 .65658 m .51738 .65675 L p .51685 .65597 L F P
0 g
s
.569 .743 .958 r
.51738 .65675 m .51382 .65821 L p .51669 .65609 L F P
0 g
s
.569 .743 .958 r
.51738 .65675 m .51669 .65609 L .51685 .65597 L F
.57 .756 .966 r
.51701 .65955 m .51382 .65821 L p .51859 .65707 L F P
0 g
s
.663 .227 .203 r
.5036 .65533 m .50496 .6592 L .51951 .66093 L p F P
0 g
s
.493 .766 .992 r
.52062 .66047 m .51789 .66318 L .51253 .66182 L p F P
0 g
s
.489 .742 .984 r
.51701 .65955 m .51253 .66182 L .50781 .65984 L p F P
0 g
s
.493 .766 .992 r
.51253 .66182 m .51701 .65955 L .52062 .66047 L p F P
0 g
s
.489 .742 .984 r
.50781 .65984 m .51382 .65821 L .51701 .65955 L p F P
0 g
s
.845 .61 .584 r
.51807 .6541 m .52017 .65498 L p .51931 .65723 L F P
0 g
s
.845 .61 .584 r
.51931 .65723 m .51929 .65722 L .51807 .6541 L F
.51779 .65658 m .51807 .6541 L p .51929 .65722 L F P
0 g
s
.57 .756 .966 r
.51738 .65675 m .51779 .65658 L p .51792 .65723 L F P
0 g
s
.57 .756 .966 r
.51779 .65658 m .52001 .65567 L p .51842 .65685 L F P
0 g
s
.57 .756 .966 r
.51792 .65723 m .51779 .65658 L .51842 .65685 L F
.51996 .6575 m .51966 .65771 L p .51881 .65702 L F P
0 g
s
.57 .756 .966 r
.51966 .65771 m .51701 .65955 L p .51872 .65715 L F P
0 g
s
.57 .756 .966 r
.51966 .65771 m .51872 .65715 L .51881 .65702 L F
.51382 .65821 m .51738 .65675 L p .51792 .65723 L F P
0 g
s
.57 .756 .966 r
.51872 .65715 m .51701 .65955 L .51859 .65707 L F
.575 .77 .971 r
.52062 .66047 m .51701 .65955 L p .52095 .65787 L F P
0 g
s
.368 .737 .989 r
.50826 .66315 m .51253 .66182 L .51789 .66318 L p F P
0 g
s
.794 .563 .587 r
.52017 .65498 m .52256 .65559 L p .52169 .65794 L F P
0 g
s
.794 .563 .587 r
.52169 .65794 m .52167 .65793 L .52017 .65498 L F
.51996 .6575 m .52017 .65498 L p .52167 .65793 L F P
0 g
s
.575 .77 .971 r
.51966 .65771 m .52162 .65635 L p .52039 .65811 L F P
0 g
s
.794 .563 .587 r
.51995 .65758 m .51996 .6575 L p .52168 .65796 L F P
0 g
s
.575 .77 .971 r
.52113 .6578 m .52039 .65811 L .52068 .65768 L F
.794 .563 .587 r
.52168 .65796 m .51996 .6575 L .52167 .65793 L F
.584 .784 .975 r
.5245 .66093 m .52062 .66047 L p .52354 .65837 L F P
0 g
s
.584 .784 .975 r
.52368 .65828 m .52372 .65841 L .52354 .65837 L F
.52372 .65841 m .5245 .66093 L .52354 .65837 L F
.52507 .65844 m .5245 .66093 L p .52368 .65828 L F P
0 g
s
.746 .521 .589 r
.52256 .65559 m .52512 .6559 L p .52428 .65835 L F P
0 g
s
.584 .784 .975 r
.52368 .65828 m .52354 .65837 L .52243 .65813 L F
.52062 .66047 m .52243 .65813 L p .52354 .65837 L F P
0 g
s
.575 .77 .971 r
.52243 .65813 m .52062 .66047 L p .52113 .6578 L F P
0 g
s
.794 .563 .587 r
.52208 .66484 m .51939 .66416 L p .52168 .65796 L F P
0 g
s
.794 .563 .587 r
.52256 .65559 m .52243 .65813 L p .52168 .65796 L F P
0 g
s
.794 .563 .587 r
.52243 .65813 m .52208 .66484 L p .52168 .65796 L F P
0 g
s
.746 .521 .589 r
.52208 .66484 m .52243 .65813 L p .52428 .65835 L F P
0 g
s
.746 .521 .589 r
.52243 .65813 m .52256 .65559 L p .52428 .65835 L F P
0 g
s
.746 .521 .589 r
.52512 .6559 m .52507 .65844 L p .52428 .65835 L F P
0 g
s
.584 .784 .975 r
.52344 .65681 m .5254 .65704 L p .52368 .65828 L F P
0 g
s
.584 .784 .975 r
.52243 .65813 m .52344 .65681 L p .52368 .65828 L F P
0 g
s
.575 .77 .971 r
.52162 .65635 m .52344 .65681 L p .52113 .6578 L F P
0 g
s
.575 .77 .971 r
.52113 .6578 m .52068 .65768 L .52162 .65635 L F
.51701 .65955 m .51966 .65771 L p .52039 .65811 L F P
0 g
s
.9 .665 .575 r
.51702 .66316 m .51508 .66191 L p .51721 .65635 L F P
0 g
s
.9 .665 .575 r
.51725 .65626 m .51724 .65637 L .51721 .65635 L F
.51724 .65637 m .51702 .66316 L .51721 .65635 L F
.51807 .6541 m .51779 .65658 L p .51725 .65624 L F P
0 g
s
.9 .665 .575 r
.51636 .65298 m .51807 .6541 L p .51725 .65624 L F P
0 g
s
.9 .665 .575 r
.51725 .65624 m .51724 .65623 L .51636 .65298 L F
.51725 .65626 m .51689 .65605 L .51636 .65298 L F
.569 .743 .958 r
.51121 .65652 m .51601 .65543 L p .51685 .65597 L F P
0 g
s
.9 .665 .575 r
.516 .65551 m .51601 .65543 L p .51689 .65605 L F P
0 g
s
.9 .665 .575 r
.51601 .65543 m .51636 .65298 L p .51689 .65605 L F P
0 g
s
.957 .73 .554 r
.51636 .65298 m .51601 .65543 L p .51561 .65504 L F P
0 g
s
.957 .73 .554 r
.5151 .65167 m .51636 .65298 L p .51562 .65502 L F P
0 g
s
.957 .73 .554 r
.51562 .65502 m .51561 .65501 L .5151 .65167 L F
.51471 .65408 m .5151 .65167 L p .51561 .65501 L F P
0 g
s
.572 .73 .949 r
.51415 .65413 m .51774 .65382 L p .51498 .65471 L F P
0 g
s
.957 .73 .554 r
.51469 .65416 m .51471 .65408 L p .51561 .65504 L F P
0 g
s
.572 .73 .949 r
.51532 .65472 m .51498 .65471 L .51523 .65462 L F
.957 .73 .554 r
.51561 .65504 m .51471 .65408 L .51561 .65501 L F
.572 .73 .949 r
.51774 .65382 m .5187 .65481 L p .51532 .65472 L F P
0 g
s
.572 .73 .949 r
.51532 .65472 m .51523 .65462 L .51774 .65382 L F
.50929 .65454 m .51415 .65413 L p .51498 .65471 L F P
0 g
s
.569 .743 .958 r
.5187 .65481 m .52001 .65567 L p .51685 .65597 L F P
0 g
s
.569 .743 .958 r
.51601 .65543 m .5187 .65481 L p .51685 .65597 L F P
0 g
s
.9 .665 .575 r
.51725 .65624 m .51779 .65658 L .51725 .65626 L F
.51779 .65658 m .51702 .66316 L p .51725 .65626 L F P
0 g
s
.368 .737 .989 r
.51789 .66318 m .51528 .66492 L .50826 .66315 L p F P
0 g
s
.845 .61 .584 r
.51939 .66416 m .51702 .66316 L p .51931 .65723 L F P
0 g
s
.845 .61 .584 r
.52017 .65498 m .51996 .6575 L p .51931 .65723 L F P
0 g
s
.845 .61 .584 r
.51996 .6575 m .51939 .66416 L p .51931 .65723 L F P
0 g
s
.845 .61 .584 r
.51778 .65667 m .51779 .65658 L p .5193 .65725 L F P
0 g
s
.57 .756 .966 r
.51881 .65702 m .51792 .65723 L .51842 .65685 L F
.845 .61 .584 r
.5193 .65725 m .51779 .65658 L .51929 .65722 L F
.57 .756 .966 r
.52001 .65567 m .52162 .65635 L p .51881 .65702 L F P
0 g
s
.57 .756 .966 r
.51881 .65702 m .51842 .65685 L .52001 .65567 L F
.957 .73 .554 r
.51508 .66191 m .51367 .66044 L p .51558 .65513 L F P
0 g
s
.572 .73 .949 r
.51601 .65543 m .51552 .65554 L p .51532 .65472 L F P
0 g
s
.957 .73 .554 r
.51561 .65504 m .5156 .65516 L .51558 .65513 L F
.5156 .65516 m .51508 .66191 L .51558 .65513 L F
.51601 .65543 m .51508 .66191 L p .51561 .65504 L F P
0 g
s
.722 .264 .162 r
.50496 .6592 m .5036 .65533 L .48912 .65165 L p F P
0 g
s
.494 .721 .973 r
.51382 .65821 m .50781 .65984 L .50393 .65733 L p F P
0 g
s
.494 .721 .973 r
.50393 .65733 m .51121 .65652 L .51382 .65821 L p F P
0 g
s
.999 .797 .499 r
.51367 .66044 m .51284 .65884 L p .51447 .65366 L F P
0 g
s
.999 .797 .499 r
.5151 .65167 m .51471 .65408 L p .51447 .65366 L F P
0 g
s
.999 .797 .499 r
.51471 .65408 m .51367 .66044 L p .51447 .65366 L F P
0 g
s
.572 .73 .949 r
.51552 .65554 m .51511 .65481 L .51532 .65472 L F
.587 .712 .929 r
.51376 .65107 m .51705 .65159 L p .51385 .65179 L F P
0 g
s
.598 .706 .919 r
.51705 .65159 m .51376 .65107 L p .51398 .65026 L F P
0 g
s
.587 .712 .929 r
.51385 .65179 m .51356 .65182 L .51359 .65172 L F
.579 .72 .939 r
.50929 .65454 m .50817 .65238 L p .51404 .65326 L F P
0 g
s
.579 .72 .939 r
.51405 .65336 m .50929 .65454 L .51404 .65326 L F
.938 .808 .351 r
.51264 .65717 m .51375 .65114 L p .51389 .65216 L F P
0 g
s
0 0 0 r
.51264 .65717 m .51307 .65552 L p .51388 .65063 L F P
0 g
s
.598 .706 .919 r
.51735 .65047 m .51705 .65159 L p .51398 .65026 L F P
0 g
s
0 0 0 r
.51419 .64876 m .51376 .65107 L p .51388 .65061 L F P
0 g
s
0 0 0 r
.51458 .64729 m .51419 .64876 L p .51388 .65061 L F P
0 g
s
0 0 0 r
.51388 .65061 m .51389 .6506 L .51458 .64729 L F
.51388 .65063 m .51396 .65034 L .51458 .64729 L F
.999 .797 .499 r
.51436 .65025 m .51589 .64169 L .51653 .64295 L p F P
0 g
s
.598 .706 .919 r
.51417 .64954 m .51735 .65047 L p .51398 .65026 L F P
0 g
s
0 0 0 r
.51415 .64962 m .51417 .64954 L p .51396 .65034 L F P
0 g
s
0 0 0 r
.51417 .64954 m .51458 .64729 L p .51396 .65034 L F P
0 g
s
0 0 .211 r
.51552 .64589 m .51458 .64729 L p .51446 .64911 L F P
0 g
s
.61 .702 .909 r
.51807 .64941 m .51735 .65047 L p .51468 .64878 L F P
0 g
s
.61 .702 .909 r
.51468 .64878 m .51475 .64869 L .51807 .64941 L F
0 0 .211 r
.51514 .6481 m .51552 .64589 L p .51446 .64911 L F P
0 g
s
.61 .702 .909 r
.51461 .64786 m .51514 .6481 L p .51441 .64861 L F P
0 g
s
.61 .702 .909 r
.51514 .6481 m .51807 .64941 L p .51475 .64869 L F P
0 g
s
.61 .702 .909 r
.51441 .64861 m .51514 .6481 L .51475 .64869 L F
.938 .808 .351 r
.51284 .65884 m .51264 .65717 L p .51389 .65216 L F P
0 g
s
.938 .808 .351 r
.51395 .6526 m .51284 .65884 L p .51389 .65216 L F P
0 g
s
.999 .797 .499 r
.51393 .65268 m .51395 .6526 L p .51447 .65366 L F P
0 g
s
.579 .72 .939 r
.51395 .6526 m .51718 .65273 L p .51431 .6533 L F P
0 g
s
.587 .712 .929 r
.51705 .65159 m .51718 .65273 L p .51385 .65179 L F P
0 g
s
.938 .808 .351 r
.51389 .65216 m .51385 .65187 L .51385 .65182 L F
.51389 .65216 m .51385 .65182 L .51389 .65213 L F
.587 .712 .929 r
.51718 .65273 m .51395 .6526 L p .51385 .65179 L F P
0 g
s
.938 .808 .351 r
.51389 .65214 m .51389 .65216 L .51389 .65213 L F
.579 .72 .939 r
.51431 .6533 m .51405 .65336 L .51404 .65326 L F
.999 .797 .499 r
.51284 .65884 m .51393 .65268 L p .51447 .65366 L F P
0 g
s
0 0 .211 r
.51458 .64729 m .51417 .64954 L p .51446 .64911 L F P
0 g
s
.737 .458 .506 r
.50096 .63244 m .50119 .63915 L .5183 .6412 L p F P
0 g
s
.938 .808 .351 r
.51419 .64876 m .51573 .64039 L .51589 .64169 L p F P
0 g
s
0 0 0 r
.51573 .64039 m .51419 .64876 L .51458 .64729 L p F P
0 g
s
.61 .702 .909 r
.50848 .64788 m .5099 .64577 L p .51447 .64865 L F P
0 g
s
.61 .702 .909 r
.51735 .65047 m .51359 .64937 L p .51447 .64865 L F P
0 g
s
.61 .702 .909 r
.51359 .64937 m .50848 .64788 L p .51447 .64865 L F P
0 g
s
.845 .61 .584 r
.51807 .6541 m .51912 .64508 L .52095 .64585 L p F P
0 g
s
.622 .701 .901 r
.51918 .64846 m .51807 .64941 L p .51593 .64742 L F P
0 g
s
.176 0 .354 r
.51697 .64465 m .51552 .64589 L p .51559 .64772 L F P
0 g
s
.176 0 .354 r
.51559 .64772 m .5156 .6477 L .51697 .64465 L F
.622 .701 .901 r
.51664 .64681 m .51918 .64846 L p .51593 .64742 L F P
0 g
s
.176 0 .354 r
.51663 .64689 m .51664 .64681 L p .51559 .64774 L F P
0 g
s
.176 0 .354 r
.51664 .64681 m .51697 .64465 L p .5156 .6477 L F P
0 g
s
.176 0 .354 r
.51559 .64774 m .51664 .64681 L .5156 .6477 L F
.737 .458 .506 r
.5183 .6412 m .51823 .63453 L .50096 .63244 L p F P
0 g
s
0 0 0 r
.51458 .64729 m .51607 .6391 L .51573 .64039 L p F P
0 g
s
0 0 .211 r
.51607 .6391 m .51458 .64729 L .51552 .64589 L p F P
0 g
s
.622 .701 .901 r
.51807 .64941 m .51514 .6481 L p .51593 .64742 L F P
0 g
s
.999 .797 .499 r
.51447 .65366 m .51395 .6526 L .51447 .65362 L F
.579 .72 .939 r
.51718 .65273 m .51774 .65382 L p .51431 .6533 L F P
0 g
s
.579 .72 .939 r
.51774 .65382 m .51471 .65408 L p .51431 .6533 L F P
0 g
s
.999 .797 .499 r
.51448 .65364 m .51447 .65366 L .51447 .65362 L F
.176 0 .354 r
.51414 .65396 m .51577 .65256 L p .51559 .64776 L F P
0 g
s
.176 0 .354 r
.51552 .64589 m .51513 .64818 L p .51559 .64776 L F P
0 g
s
.176 0 .354 r
.51513 .64818 m .51414 .65396 L p .51559 .64776 L F P
0 g
s
.742 .489 .548 r
.51823 .63453 m .51825 .6273 L .50101 .62521 L p F P
0 g
s
.742 .489 .548 r
.50101 .62521 m .50096 .63244 L .51823 .63453 L p F P
0 g
s
.999 .797 .499 r
.51589 .64169 m .5174 .63319 L .51794 .63426 L p F P
0 g
s
.999 .797 .499 r
.51794 .63426 m .51653 .64295 L .51589 .64169 L p F P
0 g
s
.938 .808 .351 r
.5174 .63319 m .51589 .64169 L .51573 .64039 L p F P
0 g
s
0 0 .211 r
.51552 .64589 m .5169 .63788 L .51607 .6391 L p F P
0 g
s
.957 .73 .554 r
.51653 .64295 m .51794 .63426 L .51888 .63525 L p F P
0 g
s
.957 .73 .554 r
.51888 .63525 m .51762 .64409 L .51653 .64295 L p F P
0 g
s
.176 0 .354 r
.5169 .63788 m .51552 .64589 L .51697 .64465 L p F P
0 g
s
.9 .665 .575 r
.52016 .63609 m .51912 .64508 L .51762 .64409 L p F P
0 g
s
.365 .132 .421 r
.51886 .64361 m .51697 .64465 L p .51722 .64649 L F P
0 g
s
.635 .702 .894 r
.51918 .64846 m .51664 .64681 L p .51767 .64625 L F P
0 g
s
.746 .521 .589 r
.52256 .65559 m .52304 .64639 L .52527 .64666 L p F P
0 g
s
.746 .521 .589 r
.52527 .64666 m .52512 .6559 L .52256 .65559 L p F P
0 g
s
.697 .48 .59 r
.52512 .6559 m .52527 .64666 L .52755 .64664 L p F P
0 g
s
.697 .48 .59 r
.52755 .64664 m .52773 .65588 L .52512 .6559 L p F P
0 g
s
.794 .563 .587 r
.52017 .65498 m .52095 .64585 L .52304 .64639 L p F P
0 g
s
.794 .563 .587 r
.52304 .64639 m .52256 .65559 L .52017 .65498 L p F P
0 g
s
.845 .61 .584 r
.52095 .64585 m .52017 .65498 L .51807 .6541 L p F P
0 g
s
.64 .739 .92 r
.52632 .65225 m .51807 .64941 L .51918 .64846 L closepath p F P
0 g
s
.636 .74 .923 r
.52632 .65225 m .51735 .65047 L .51807 .64941 L closepath p F P
0 g
s
.633 .741 .926 r
.52632 .65225 m .51705 .65159 L .51735 .65047 L closepath p F P
0 g
s
.365 .132 .421 r
.5186 .64574 m .51886 .64361 L p .51722 .64649 L F P
0 g
s
.176 0 .354 r
.51697 .64465 m .51816 .63678 L .5169 .63788 L p F P
0 g
s
.9 .665 .575 r
.51762 .64409 m .51888 .63525 L .52016 .63609 L p F P
0 g
s
.365 .132 .421 r
.51816 .63678 m .51697 .64465 L .51886 .64361 L p F P
0 g
s
.635 .702 .894 r
.52062 .64767 m .51918 .64846 L p .51767 .64625 L F P
0 g
s
.365 .132 .421 r
.51697 .64465 m .51664 .64681 L p .51722 .64649 L F P
0 g
s
.635 .702 .894 r
.51497 .64229 m .5186 .64574 L p .51767 .64625 L F P
0 g
s
.635 .702 .894 r
.5186 .64574 m .52062 .64767 L p .51767 .64625 L F P
0 g
s
.63 .744 .93 r
.52632 .65225 m .51718 .65273 L .51705 .65159 L closepath p F P
0 g
s
.365 .132 .421 r
.51577 .65256 m .5179 .65139 L p .51722 .64649 L F P
0 g
s
.365 .132 .421 r
.51664 .64681 m .51577 .65256 L p .51722 .64649 L F P
0 g
s
.365 .132 .421 r
.5179 .65139 m .5186 .64574 L p .51722 .64649 L F P
0 g
s
.635 .702 .894 r
.51767 .64625 m .51664 .64681 L .51752 .64602 L F
.5121 .64387 m .51497 .64229 L p .51752 .64602 L F P
0 g
s
.635 .702 .894 r
.51664 .64681 m .5121 .64387 L p .51752 .64602 L F P
0 g
s
.622 .701 .901 r
.5099 .64577 m .5121 .64387 L p .51593 .64742 L F P
0 g
s
.622 .701 .901 r
.51514 .6481 m .5099 .64577 L p .51593 .64742 L F P
0 g
s
.622 .701 .901 r
.5121 .64387 m .51664 .64681 L p .51593 .64742 L F P
0 g
s
.176 0 .354 r
.51559 .64772 m .51559 .64774 L .5156 .6477 L F
.51577 .65256 m .51663 .64689 L p .51559 .64774 L F P
0 g
s
0 0 .211 r
.51307 .65552 m .51414 .65396 L p .51446 .64911 L F P
0 g
s
0 0 .211 r
.51417 .64954 m .51307 .65552 L p .51446 .64911 L F P
0 g
s
0 0 .211 r
.51414 .65396 m .51514 .6481 L p .51446 .64911 L F P
0 g
s
.61 .702 .909 r
.51468 .64878 m .51441 .64861 L .51475 .64869 L F
.5099 .64577 m .51461 .64786 L p .51441 .64861 L F P
0 g
s
.598 .706 .919 r
.50848 .64788 m .51417 .64954 L p .51398 .65026 L F P
0 g
s
0 0 0 r
.51388 .65061 m .51376 .65107 L .51388 .65063 L F
.51376 .65107 m .51264 .65717 L p .51388 .65063 L F P
0 g
s
.938 .808 .351 r
.51375 .65114 m .51376 .65107 L p .51385 .65187 L F P
0 g
s
.598 .706 .919 r
.50789 .65012 m .50848 .64788 L p .51366 .65013 L F P
0 g
s
.598 .706 .919 r
.51398 .65026 m .51368 .65026 L .51366 .65013 L F
.51368 .65026 m .50789 .65012 L .51366 .65013 L F
.51376 .65107 m .50789 .65012 L p .51398 .65026 L F P
0 g
s
0 0 0 r
.51388 .65061 m .51388 .65063 L .51389 .6506 L F
.51307 .65552 m .51415 .64962 L p .51388 .65063 L F P
0 g
s
.587 .712 .929 r
.50817 .65238 m .50789 .65012 L p .51359 .65172 L F P
0 g
s
.587 .712 .929 r
.51356 .65182 m .50817 .65238 L .51359 .65172 L F
.572 .73 .949 r
.51532 .65472 m .51511 .65481 L .51506 .65471 L F
.5187 .65481 m .51601 .65543 L p .51532 .65472 L F P
0 g
s
.957 .73 .554 r
.51562 .65502 m .51561 .65504 L .51561 .65501 L F
.51367 .66044 m .51469 .65416 L p .51561 .65504 L F P
0 g
s
.569 .743 .958 r
.51685 .65597 m .51669 .65609 L .5166 .656 L F
.52001 .65567 m .51779 .65658 L p .51685 .65597 L F P
0 g
s
.9 .665 .575 r
.51725 .65624 m .51725 .65626 L .51724 .65623 L F
.51508 .66191 m .516 .65551 L p .51725 .65626 L F P
0 g
s
.57 .756 .966 r
.51881 .65702 m .51872 .65715 L .51859 .65707 L F
.52162 .65635 m .51996 .6575 L p .51881 .65702 L F P
0 g
s
.845 .61 .584 r
.51931 .65723 m .5193 .65725 L .51929 .65722 L F
.51702 .66316 m .51778 .65667 L p .5193 .65725 L F P
0 g
s
.575 .77 .971 r
.52113 .6578 m .5211 .65793 L .52095 .65787 L F
.5211 .65793 m .52062 .66047 L .52095 .65787 L F
.52344 .65681 m .52243 .65813 L p .52113 .6578 L F P
0 g
s
.794 .563 .587 r
.52169 .65794 m .52168 .65796 L .52167 .65793 L F
.51939 .66416 m .51995 .65758 L p .52168 .65796 L F P
0 g
s
.584 .784 .975 r
.5254 .65704 m .52507 .65844 L p .52368 .65828 L F P
0 g
s
.746 .521 .589 r
.52428 .65835 m .52507 .65844 L .52428 .65837 L F
.52496 .66518 m .52208 .66484 L p .52428 .65837 L F P
0 g
s
.746 .521 .589 r
.52507 .65844 m .52496 .66518 L p .52428 .65837 L F P
0 g
s
.697 .48 .59 r
.52496 .66518 m .52507 .65844 L p .52697 .65843 L F P
0 g
s
.697 .48 .59 r
.52791 .66516 m .52496 .66518 L p .52696 .65846 L F P
0 g
s
.697 .48 .59 r
.52773 .65588 m .52778 .65843 L p .52696 .65846 L F P
0 g
s
.697 .48 .59 r
.52778 .65843 m .52791 .66516 L p .52696 .65846 L F P
0 g
s
.644 .438 .589 r
.52778 .65843 m .52773 .65588 L p .52963 .65819 L F P
0 g
s
.614 .808 .975 r
.5274 .65703 m .52935 .65678 L p .529 .65838 L F P
0 g
s
.614 .808 .975 r
.52846 .66091 m .52778 .65843 L p .529 .65838 L F P
0 g
s
.614 .808 .975 r
.52778 .65843 m .5274 .65703 L p .529 .65838 L F P
0 g
s
.598 .797 .976 r
.5274 .65703 m .52778 .65843 L p .52635 .65844 L F P
0 g
s
.644 .438 .589 r
.52963 .65819 m .52961 .65825 L .52778 .65843 L F
.52791 .66516 m .52778 .65843 L p .52961 .65825 L F P
0 g
s
.644 .438 .589 r
.53078 .66479 m .52791 .66516 L p .52962 .65822 L F P
0 g
s
.644 .438 .589 r
.53028 .65555 m .53042 .65809 L p .52962 .65822 L F P
0 g
s
.644 .438 .589 r
.53042 .65809 m .53078 .66479 L p .52962 .65822 L F P
0 g
s
.584 .392 .587 r
.53042 .65809 m .53028 .65555 L p .53213 .65763 L F P
0 g
s
.632 .817 .971 r
.53232 .66041 m .53042 .65809 L p .53161 .65789 L F P
0 g
s
.584 .392 .587 r
.53212 .65769 m .53234 .65876 L .53078 .66479 L F
.966 .687 .452 r
.53277 .66416 m .53581 .66646 L p .53228 .65798 L F P
0 g
s
.584 .392 .587 r
.53278 .66426 m .53078 .66479 L p .53234 .65876 L F P
0 g
s
.632 .817 .971 r
.53157 .65778 m .53175 .65787 L .53162 .65793 L F
.584 .392 .587 r
.53078 .66479 m .53042 .65809 L p .53213 .65763 L F P
0 g
s
.966 .687 .452 r
.53689 .67591 m .53581 .66646 L .53277 .66416 L p F P
0 g
s
.004 0 0 r
.52128 .66676 m .52201 .66678 L .5314 .66673 L p F P
0 g
s
.242 .741 .905 r
.53047 .66578 m .5314 .66673 L .52201 .66678 L p F P
0 g
s
.584 .392 .587 r
.53129 .67407 m .53078 .66479 L .53278 .66426 L p F P
0 g
s
.584 .392 .587 r
.53295 .66639 m .53129 .67407 L .53278 .66426 L F
.966 .687 .452 r
.53301 .66719 m .53689 .67591 L .53277 .66416 L F
.53797 .68539 m .53689 .67591 L .53351 .67337 L p F P
0 g
s
.966 .687 .452 r
.53375 .67643 m .53797 .68539 L .53351 .67337 L F
.584 .392 .587 r
.53351 .67349 m .53129 .67407 L p .53295 .66639 L F P
0 g
s
.966 .687 .452 r
.53111 .6629 m .53165 .67198 L .53351 .67337 L p F P
0 g
s
.966 .687 .452 r
.53351 .67337 m .53689 .67591 L p .53301 .66719 L F P
0 g
s
.966 .687 .452 r
.53111 .6629 m .53351 .67337 L .53301 .66719 L F
.584 .392 .587 r
.5318 .68339 m .53129 .67407 L .53351 .67349 L p F P
0 g
s
.584 .392 .587 r
.53351 .67349 m .53426 .67329 L p .53369 .67564 L F P
0 g
s
.584 .392 .587 r
.53369 .67564 m .5318 .68339 L .53351 .67349 L F
.53345 .66408 m .53426 .67329 L .53351 .67349 L p F P
0 g
s
.584 .392 .587 r
.53345 .66408 m .53351 .67349 L .53295 .66639 L F
.966 .687 .452 r
.53905 .69491 m .53797 .68539 L .53424 .68262 L p F P
0 g
s
.966 .687 .452 r
.53449 .68571 m .53905 .69491 L .53424 .68262 L F
.584 .392 .587 r
.53425 .68275 m .5318 .68339 L p .53369 .67564 L F P
0 g
s
.966 .687 .452 r
.53165 .67198 m .5322 .6811 L .53424 .68262 L p F P
0 g
s
.966 .687 .452 r
.53424 .68262 m .53797 .68539 L p .53375 .67643 L F P
0 g
s
.966 .687 .452 r
.53165 .67198 m .53424 .68262 L .53375 .67643 L F
.584 .392 .587 r
.53231 .69275 m .5318 .68339 L .53425 .68275 L p F P
0 g
s
.584 .392 .587 r
.53425 .68275 m .53507 .68253 L p .53443 .68493 L F P
0 g
s
.584 .392 .587 r
.53443 .68493 m .53231 .69275 L .53425 .68275 L F
.53426 .67329 m .53507 .68253 L .53425 .68275 L p F P
0 g
s
.584 .392 .587 r
.53426 .67329 m .53425 .68275 L .53369 .67564 L F
.966 .687 .452 r
.54014 .70447 m .53905 .69491 L .53498 .69191 L p F P
0 g
s
.966 .687 .452 r
.53523 .69503 m .54014 .70447 L .53498 .69191 L F
.584 .392 .587 r
.53499 .69205 m .53231 .69275 L p .53443 .68493 L F P
0 g
s
.966 .687 .452 r
.5322 .6811 m .53275 .69027 L .53498 .69191 L p F P
0 g
s
.966 .687 .452 r
.53498 .69191 m .53905 .69491 L p .53449 .68571 L F P
0 g
s
.966 .687 .452 r
.5322 .6811 m .53498 .69191 L .53449 .68571 L F
.584 .392 .587 r
.53282 .70215 m .53231 .69275 L .53499 .69205 L p F P
0 g
s
.584 .392 .587 r
.53499 .69205 m .53589 .69182 L p .53517 .69425 L F P
0 g
s
.584 .392 .587 r
.53517 .69425 m .53282 .70215 L .53499 .69205 L F
.53507 .68253 m .53589 .69182 L .53499 .69205 L p F P
0 g
s
.584 .392 .587 r
.53507 .68253 m .53499 .69205 L .53443 .68493 L F
.966 .687 .452 r
.54123 .71407 m .54014 .70447 L .53572 .70125 L p F P
0 g
s
.966 .687 .452 r
.53597 .70439 m .54123 .71407 L .53572 .70125 L F
.584 .392 .587 r
.53574 .7014 m .53282 .70215 L p .53517 .69425 L F P
0 g
s
.966 .687 .452 r
.53275 .69027 m .5333 .69948 L .53572 .70125 L p F P
0 g
s
.966 .687 .452 r
.53572 .70125 m .54014 .70447 L p .53523 .69503 L F P
0 g
s
.966 .687 .452 r
.53275 .69027 m .53572 .70125 L .53523 .69503 L F
.584 .392 .587 r
.53334 .71159 m .53282 .70215 L .53574 .7014 L p F P
0 g
s
.584 .392 .587 r
.53574 .7014 m .53671 .70114 L p .53591 .70362 L F P
0 g
s
.584 .392 .587 r
.53591 .70362 m .53334 .71159 L .53574 .7014 L F
.53589 .69182 m .53671 .70114 L .53574 .7014 L p F P
0 g
s
.584 .392 .587 r
.53589 .69182 m .53574 .7014 L .53517 .69425 L F
.966 .687 .452 r
.54233 .7237 m .54123 .71407 L .53647 .71062 L p F P
0 g
s
.966 .687 .452 r
.53672 .71379 m .54233 .7237 L .53647 .71062 L F
.584 .392 .587 r
.53648 .71078 m .53334 .71159 L p .53591 .70362 L F P
0 g
s
.966 .687 .452 r
.5333 .69948 m .53386 .70873 L .53647 .71062 L p F P
0 g
s
.966 .687 .452 r
.53647 .71062 m .54123 .71407 L p .53597 .70439 L F P
0 g
s
.966 .687 .452 r
.5333 .69948 m .53647 .71062 L .53597 .70439 L F
.584 .392 .587 r
.53386 .72108 m .53334 .71159 L .53648 .71078 L p F P
0 g
s
.584 .392 .587 r
.53648 .71078 m .53754 .71051 L p .53666 .71302 L F P
0 g
s
.584 .392 .587 r
.53666 .71302 m .53386 .72108 L .53648 .71078 L F
.53671 .70114 m .53754 .71051 L .53648 .71078 L p F P
0 g
s
.584 .392 .587 r
.53671 .70114 m .53648 .71078 L .53591 .70362 L F
.966 .687 .452 r
.54343 .73337 m .54233 .7237 L .53722 .72004 L p F P
0 g
s
.966 .687 .452 r
.53747 .72323 m .54343 .73337 L .53722 .72004 L F
.584 .392 .587 r
.53723 .72021 m .53386 .72108 L p .53666 .71302 L F P
0 g
s
.966 .687 .452 r
.53386 .70873 m .53442 .71802 L .53722 .72004 L p F P
0 g
s
.966 .687 .452 r
.53722 .72004 m .54233 .7237 L p .53672 .71379 L F P
0 g
s
.966 .687 .452 r
.53386 .70873 m .53722 .72004 L .53672 .71379 L F
.584 .392 .587 r
.53438 .7306 m .53386 .72108 L .53723 .72021 L p F P
0 g
s
.584 .392 .587 r
.53723 .72021 m .53836 .71992 L p .53741 .72247 L F P
0 g
s
.584 .392 .587 r
.53741 .72247 m .53438 .7306 L .53723 .72021 L F
.53754 .71051 m .53836 .71992 L .53723 .72021 L p F P
0 g
s
.584 .392 .587 r
.53754 .71051 m .53723 .72021 L .53666 .71302 L F
.966 .687 .452 r
.54453 .74308 m .54343 .73337 L .53797 .72949 L p F P
0 g
s
.966 .687 .452 r
.53823 .73271 m .54453 .74308 L .53797 .72949 L F
.584 .392 .587 r
.53799 .72968 m .53438 .7306 L p .53741 .72247 L F P
0 g
s
.966 .687 .452 r
.53442 .71802 m .53498 .72736 L .53797 .72949 L p F P
0 g
s
.966 .687 .452 r
.53797 .72949 m .54343 .73337 L p .53747 .72323 L F P
0 g
s
.966 .687 .452 r
.53442 .71802 m .53797 .72949 L .53747 .72323 L F
.584 .392 .587 r
.5349 .74017 m .53438 .7306 L .53799 .72968 L p F P
0 g
s
.584 .392 .587 r
.53799 .72968 m .5392 .72937 L p .53817 .73196 L F P
0 g
s
.584 .392 .587 r
.53817 .73196 m .5349 .74017 L .53799 .72968 L F
.53836 .71992 m .5392 .72937 L .53799 .72968 L p F P
0 g
s
.584 .392 .587 r
.53836 .71992 m .53799 .72968 L .53741 .72247 L F
.966 .687 .452 r
.54564 .75282 m .54453 .74308 L .53873 .73899 L p F P
0 g
s
.966 .687 .452 r
.53899 .74223 m .54564 .75282 L .53873 .73899 L F
.584 .392 .587 r
.53874 .73919 m .5349 .74017 L p .53817 .73196 L F P
0 g
s
.966 .687 .452 r
.53498 .72736 m .53554 .73675 L .53873 .73899 L p F P
0 g
s
.966 .687 .452 r
.53873 .73899 m .54453 .74308 L p .53823 .73271 L F P
0 g
s
.966 .687 .452 r
.53498 .72736 m .53873 .73899 L .53823 .73271 L F
.584 .392 .587 r
.53543 .74977 m .5349 .74017 L .53874 .73919 L p F P
0 g
s
.584 .392 .587 r
.53874 .73919 m .54003 .73887 L p .53893 .74148 L F P
0 g
s
.584 .392 .587 r
.53893 .74148 m .53543 .74977 L .53874 .73919 L F
.5392 .72937 m .54003 .73887 L .53874 .73919 L p F P
0 g
s
.584 .392 .587 r
.5392 .72937 m .53874 .73919 L .53817 .73196 L F
.966 .687 .452 r
.54676 .76261 m .54564 .75282 L .53949 .74853 L p F P
0 g
s
.966 .687 .452 r
.53975 .75179 m .54676 .76261 L .53949 .74853 L F
.584 .392 .587 r
.5395 .74875 m .53543 .74977 L p .53893 .74148 L F P
0 g
s
.966 .687 .452 r
.53554 .73675 m .53611 .74618 L .53949 .74853 L p F P
0 g
s
.966 .687 .452 r
.53949 .74853 m .54564 .75282 L p .53899 .74223 L F P
0 g
s
.966 .687 .452 r
.53554 .73675 m .53949 .74853 L .53899 .74223 L F
.584 .392 .587 r
.53595 .75942 m .53543 .74977 L .5395 .74875 L p F P
0 g
s
.584 .392 .587 r
.5395 .74875 m .54087 .7484 L p .53969 .75105 L F P
0 g
s
.584 .392 .587 r
.53969 .75105 m .53595 .75942 L .5395 .74875 L F
.54003 .73887 m .54087 .7484 L .5395 .74875 L p F P
0 g
s
.584 .392 .587 r
.54003 .73887 m .5395 .74875 L .53893 .74148 L F
.966 .687 .452 r
.54787 .77243 m .54676 .76261 L .54025 .75812 L p F P
0 g
s
.966 .687 .452 r
.54051 .7614 m .54787 .77243 L .54025 .75812 L F
.584 .392 .587 r
.54027 .75835 m .53595 .75942 L p .53969 .75105 L F P
0 g
s
.966 .687 .452 r
.53611 .74618 m .53667 .75565 L .54025 .75812 L p F P
0 g
s
.966 .687 .452 r
.54025 .75812 m .54676 .76261 L p .53975 .75179 L F P
0 g
s
.966 .687 .452 r
.53611 .74618 m .54025 .75812 L .53975 .75179 L F
.584 .392 .587 r
.53648 .76912 m .53595 .75942 L .54027 .75835 L p F P
0 g
s
.584 .392 .587 r
.54027 .75835 m .54171 .75798 L p .54045 .76067 L F P
0 g
s
.584 .392 .587 r
.54045 .76067 m .53648 .76912 L .54027 .75835 L F
.54087 .7484 m .54171 .75798 L .54027 .75835 L p F P
0 g
s
.584 .392 .587 r
.54087 .7484 m .54027 .75835 L .53969 .75105 L F
.966 .687 .452 r
.549 .78229 m .54787 .77243 L .54102 .76774 L p F P
0 g
s
.966 .687 .452 r
.54128 .77105 m .549 .78229 L .54102 .76774 L F
.584 .392 .587 r
.54104 .76799 m .53648 .76912 L p .54045 .76067 L F P
0 g
s
.966 .687 .452 r
.53667 .75565 m .53725 .76517 L .54102 .76774 L p F P
0 g
s
.966 .687 .452 r
.54102 .76774 m .54787 .77243 L p .54051 .7614 L F P
0 g
s
.966 .687 .452 r
.53667 .75565 m .54102 .76774 L .54051 .7614 L F
.584 .392 .587 r
.53701 .77885 m .53648 .76912 L .54104 .76799 L p F P
0 g
s
.584 .392 .587 r
.54104 .76799 m .54256 .76761 L p .54122 .77032 L F P
0 g
s
.584 .392 .587 r
.54122 .77032 m .53701 .77885 L .54104 .76799 L F
.54171 .75798 m .54256 .76761 L .54104 .76799 L p F P
0 g
s
.584 .392 .587 r
.54171 .75798 m .54104 .76799 L .54045 .76067 L F
.966 .687 .452 r
.55012 .79219 m .549 .78229 L .54179 .77741 L p F P
0 g
s
.966 .687 .452 r
.54205 .78074 m .55012 .79219 L .54179 .77741 L F
.584 .392 .587 r
.54181 .77767 m .53701 .77885 L p .54122 .77032 L F P
0 g
s
.966 .687 .452 r
.53725 .76517 m .53782 .77473 L .54179 .77741 L p F P
0 g
s
.966 .687 .452 r
.54179 .77741 m .549 .78229 L p .54128 .77105 L F P
0 g
s
.966 .687 .452 r
.53725 .76517 m .54179 .77741 L .54128 .77105 L F
.584 .392 .587 r
.53755 .78863 m .53701 .77885 L .54181 .77767 L p F P
0 g
s
.584 .392 .587 r
.54181 .77767 m .54341 .77727 L p .54199 .78002 L F P
0 g
s
.584 .392 .587 r
.54199 .78002 m .53755 .78863 L .54181 .77767 L F
.54256 .76761 m .54341 .77727 L .54181 .77767 L p F P
0 g
s
.584 .392 .587 r
.54256 .76761 m .54181 .77767 L .54122 .77032 L F
.966 .687 .452 r
.55125 .80213 m .55012 .79219 L .54256 .78713 L p F P
0 g
s
.966 .687 .452 r
.54283 .79047 m .55125 .80213 L .54256 .78713 L F
.584 .392 .587 r
.54258 .7874 m .53755 .78863 L p .54199 .78002 L F P
0 g
s
.966 .687 .452 r
.53782 .77473 m .5384 .78434 L .54256 .78713 L p F P
0 g
s
.966 .687 .452 r
.54256 .78713 m .55012 .79219 L p .54205 .78074 L F P
0 g
s
.966 .687 .452 r
.53782 .77473 m .54256 .78713 L .54205 .78074 L F
.584 .392 .587 r
.53809 .79845 m .53755 .78863 L .54258 .7874 L p F P
0 g
s
.584 .392 .587 r
.54258 .7874 m .54427 .78698 L p .54277 .78976 L F P
0 g
s
.584 .392 .587 r
.54277 .78976 m .53809 .79845 L .54258 .7874 L F
.54341 .77727 m .54427 .78698 L .54258 .7874 L p F P
0 g
s
.584 .392 .587 r
.54341 .77727 m .54258 .7874 L .54199 .78002 L F
.966 .687 .452 r
.55239 .81211 m .55125 .80213 L .54334 .79689 L p F P
0 g
s
.966 .687 .452 r
.5436 .80025 m .55239 .81211 L .54334 .79689 L F
.584 .392 .587 r
.54336 .79717 m .53809 .79845 L p .54277 .78976 L F P
0 g
s
.966 .687 .452 r
.5384 .78434 m .53898 .794 L .54334 .79689 L p F P
0 g
s
.966 .687 .452 r
.54334 .79689 m .55125 .80213 L p .54283 .79047 L F P
0 g
s
.966 .687 .452 r
.5384 .78434 m .54334 .79689 L .54283 .79047 L F
.584 .392 .587 r
.53862 .80831 m .53809 .79845 L .54336 .79717 L p F P
0 g
s
.584 .392 .587 r
.54336 .79717 m .54513 .79674 L p .54355 .79955 L F P
0 g
s
.584 .392 .587 r
.54355 .79955 m .53862 .80831 L .54336 .79717 L F
.54427 .78698 m .54513 .79674 L .54336 .79717 L p F P
0 g
s
.584 .392 .587 r
.54427 .78698 m .54336 .79717 L .54277 .78976 L F
.966 .687 .452 r
.55353 .82213 m .55239 .81211 L .54412 .80669 L p F P
0 g
s
.966 .687 .452 r
.54439 .81007 m .55353 .82213 L .54412 .80669 L F
.584 .392 .587 r
.54414 .80698 m .53862 .80831 L p .54355 .79955 L F P
0 g
s
.966 .687 .452 r
.53898 .794 m .53956 .8037 L .54412 .80669 L p F P
0 g
s
.966 .687 .452 r
.54412 .80669 m .55239 .81211 L p .5436 .80025 L F P
0 g
s
.966 .687 .452 r
.53898 .794 m .54412 .80669 L .5436 .80025 L F
.584 .392 .587 r
.53917 .81822 m .53862 .80831 L .54414 .80698 L p F P
0 g
s
.584 .392 .587 r
.54414 .80698 m .54599 .80654 L p .54433 .80938 L F P
0 g
s
.584 .392 .587 r
.54433 .80938 m .53917 .81822 L .54414 .80698 L F
.54513 .79674 m .54599 .80654 L .54414 .80698 L p F P
0 g
s
.584 .392 .587 r
.54513 .79674 m .54414 .80698 L .54355 .79955 L F
.966 .687 .452 r
.55468 .83219 m .55353 .82213 L .5449 .81653 L p F P
0 g
s
.966 .687 .452 r
.54517 .81993 m .55468 .83219 L .5449 .81653 L F
.584 .392 .587 r
.54492 .81684 m .53917 .81822 L p .54433 .80938 L F P
0 g
s
.966 .687 .452 r
.53956 .8037 m .54014 .81345 L .5449 .81653 L p F P
0 g
s
.966 .687 .452 r
.5449 .81653 m .55353 .82213 L p .54439 .81007 L F P
0 g
s
.966 .687 .452 r
.53956 .8037 m .5449 .81653 L .54439 .81007 L F
.584 .392 .587 r
.53971 .82818 m .53917 .81822 L .54492 .81684 L p F P
0 g
s
.584 .392 .587 r
.54492 .81684 m .54685 .81638 L p .54512 .81925 L F P
0 g
s
.584 .392 .587 r
.54512 .81925 m .53971 .82818 L .54492 .81684 L F
.54599 .80654 m .54685 .81638 L .54492 .81684 L p F P
0 g
s
.584 .392 .587 r
.54599 .80654 m .54492 .81684 L .54433 .80938 L F
.966 .687 .452 r
.55583 .84229 m .55468 .83219 L .54569 .82642 L p F P
0 g
s
.966 .687 .452 r
.54596 .82984 m .55583 .84229 L .54569 .82642 L F
.584 .392 .587 r
.54571 .82675 m .53971 .82818 L p .54512 .81925 L F P
0 g
s
.966 .687 .452 r
.54014 .81345 m .54073 .82325 L .54569 .82642 L p F P
0 g
s
.966 .687 .452 r
.54569 .82642 m .55468 .83219 L p .54517 .81993 L F P
0 g
s
.966 .687 .452 r
.54014 .81345 m .54569 .82642 L .54517 .81993 L F
.584 .392 .587 r
.54026 .83817 m .53971 .82818 L .54571 .82675 L p F P
0 g
s
.584 .392 .587 r
.54571 .82675 m .54772 .82627 L p .54591 .82917 L F P
0 g
s
.584 .392 .587 r
.54591 .82917 m .54026 .83817 L .54571 .82675 L F
.54685 .81638 m .54772 .82627 L .54571 .82675 L p F P
0 g
s
.584 .392 .587 r
.54685 .81638 m .54571 .82675 L .54512 .81925 L F
.966 .687 .452 r
.55698 .85243 m .55583 .84229 L .54648 .83636 L p F P
0 g
s
.966 .687 .452 r
.54675 .8398 m .55698 .85243 L .54648 .83636 L F
.584 .392 .587 r
.5465 .8367 m .54026 .83817 L p .54591 .82917 L F P
0 g
s
.966 .687 .452 r
.54073 .82325 m .54132 .83309 L .54648 .83636 L p F P
0 g
s
.966 .687 .452 r
.54648 .83636 m .55583 .84229 L p .54596 .82984 L F P
0 g
s
.966 .687 .452 r
.54073 .82325 m .54648 .83636 L .54596 .82984 L F
.584 .392 .587 r
.5408 .84822 m .54026 .83817 L .5465 .8367 L p F P
0 g
s
.584 .392 .587 r
.5465 .8367 m .5486 .8362 L p .5467 .83913 L F P
0 g
s
.584 .392 .587 r
.5467 .83913 m .5408 .84822 L .5465 .8367 L F
.54772 .82627 m .5486 .8362 L .5465 .8367 L p F P
0 g
s
.584 .392 .587 r
.54772 .82627 m .5465 .8367 L .54591 .82917 L F
.966 .687 .452 r
.55814 .86261 m .55698 .85243 L .54727 .84634 L p F P
0 g
s
.966 .687 .452 r
.54755 .8498 m .55814 .86261 L .54727 .84634 L F
.584 .392 .587 r
.5473 .84669 m .5408 .84822 L p .5467 .83913 L F P
0 g
s
.966 .687 .452 r
.54132 .83309 m .54192 .84298 L .54727 .84634 L p F P
0 g
s
.966 .687 .452 r
.54727 .84634 m .55698 .85243 L p .54675 .8398 L F P
0 g
s
.966 .687 .452 r
.54132 .83309 m .54727 .84634 L .54675 .8398 L F
.584 .392 .587 r
.54136 .8583 m .5408 .84822 L .5473 .84669 L p F P
0 g
s
.584 .392 .587 r
.5473 .84669 m .54948 .84618 L p .5475 .84914 L F P
0 g
s
.584 .392 .587 r
.5475 .84914 m .54136 .8583 L .5473 .84669 L F
.5486 .8362 m .54948 .84618 L .5473 .84669 L p F P
0 g
s
.584 .392 .587 r
.5486 .8362 m .5473 .84669 L .5467 .83913 L F
.966 .687 .452 r
.54807 .85637 m .55814 .86261 L p .54755 .8498 L F P
0 g
s
.584 .392 .587 r
.54948 .84618 m .55036 .8562 L .5481 .85673 L p F P
0 g
s
.584 .392 .587 r
.5481 .85673 m .54136 .8583 L p .5475 .84914 L F P
0 g
s
.584 .392 .587 r
.54948 .84618 m .5481 .85673 L .5475 .84914 L F
.966 .687 .452 r
.54192 .84298 m .54251 .85292 L .54807 .85637 L p F P
0 g
s
.966 .687 .452 r
.54192 .84298 m .54807 .85637 L .54755 .8498 L F
.54727 .84634 m .54192 .84298 L p .54755 .8498 L F P
0 g
s
.966 .687 .452 r
.54648 .83636 m .54132 .83309 L p .54675 .8398 L F P
0 g
s
.966 .687 .452 r
.54569 .82642 m .54073 .82325 L p .54596 .82984 L F P
0 g
s
.966 .687 .452 r
.5449 .81653 m .54014 .81345 L p .54517 .81993 L F P
0 g
s
.966 .687 .452 r
.54412 .80669 m .53956 .8037 L p .54439 .81007 L F P
0 g
s
.966 .687 .452 r
.54334 .79689 m .53898 .794 L p .5436 .80025 L F P
0 g
s
.966 .687 .452 r
.54256 .78713 m .5384 .78434 L p .54283 .79047 L F P
0 g
s
.966 .687 .452 r
.54179 .77741 m .53782 .77473 L p .54205 .78074 L F P
0 g
s
.966 .687 .452 r
.54102 .76774 m .53725 .76517 L p .54128 .77105 L F P
0 g
s
.966 .687 .452 r
.54025 .75812 m .53667 .75565 L p .54051 .7614 L F P
0 g
s
.966 .687 .452 r
.53949 .74853 m .53611 .74618 L p .53975 .75179 L F P
0 g
s
.966 .687 .452 r
.53873 .73899 m .53554 .73675 L p .53899 .74223 L F P
0 g
s
.966 .687 .452 r
.53797 .72949 m .53498 .72736 L p .53823 .73271 L F P
0 g
s
.966 .687 .452 r
.53722 .72004 m .53442 .71802 L p .53747 .72323 L F P
0 g
s
.966 .687 .452 r
.53647 .71062 m .53386 .70873 L p .53672 .71379 L F P
0 g
s
.966 .687 .452 r
.53572 .70125 m .5333 .69948 L p .53597 .70439 L F P
0 g
s
.966 .687 .452 r
.53498 .69191 m .53275 .69027 L p .53523 .69503 L F P
0 g
s
.966 .687 .452 r
.53424 .68262 m .5322 .6811 L p .53449 .68571 L F P
0 g
s
.966 .687 .452 r
.53351 .67337 m .53165 .67198 L p .53375 .67643 L F P
0 g
s
.966 .687 .452 r
.53277 .66416 m .53111 .6629 L p .53301 .66719 L F P
0 g
s
.584 .392 .587 r
.53278 .66426 m .53345 .66408 L p .53295 .66639 L F P
0 g
s
.584 .392 .587 r
.53345 .66408 m .53278 .66426 L p .53234 .65876 L F P
0 g
s
.966 .687 .452 r
.53111 .6629 m .53277 .66416 L p .53206 .65745 L F P
0 g
s
.584 .392 .587 r
.53213 .65763 m .53214 .65769 L .53212 .65769 L F
.53214 .65769 m .53345 .66408 L .53212 .65769 L F
.632 .817 .971 r
.53591 .65945 m .53501 .65969 L p .53254 .65752 L F P
0 g
s
.553 .193 .311 r
.53526 .65251 m .53486 .6571 L .55027 .6551 L p F P
0 g
s
.585 .265 .393 r
.53557 .64716 m .53526 .65251 L .55142 .65041 L p F P
0 g
s
.553 .193 .311 r
.55027 .6551 m .55142 .65041 L .53526 .65251 L p F P
0 g
s
.505 .097 .201 r
.54883 .65898 m .55027 .6551 L .53486 .6571 L p F P
0 g
s
.966 .687 .452 r
.53879 .65933 m .53721 .6497 L .53367 .64767 L p F P
0 g
s
.966 .687 .452 r
.53367 .64767 m .53474 .65705 L .53879 .65933 L p F P
0 g
s
.966 .687 .452 r
.54266 .6607 m .5406 .65092 L .53721 .6497 L p F P
0 g
s
.966 .687 .452 r
.53721 .6497 m .53879 .65933 L .54266 .6607 L p F P
0 g
s
.966 .687 .452 r
.54631 .66115 m .5438 .65134 L .5406 .65092 L p F P
0 g
s
.966 .687 .452 r
.5406 .65092 m .54266 .6607 L .54631 .66115 L p F P
0 g
s
.966 .687 .452 r
.54971 .66067 m .54678 .65096 L .5438 .65134 L p F P
0 g
s
.966 .687 .452 r
.5438 .65134 m .54631 .66115 L .54971 .66067 L p F P
0 g
s
.623 .365 .506 r
.53585 .63444 m .53576 .64112 L .55282 .63888 L p F P
0 g
s
.607 .32 .456 r
.53576 .64112 m .53557 .64716 L .55227 .64499 L p F P
0 g
s
.607 .32 .456 r
.55227 .64499 m .55282 .63888 L .53576 .64112 L p F P
0 g
s
.585 .265 .393 r
.55142 .65041 m .55227 .64499 L .53557 .64716 L p F P
0 g
s
.966 .687 .452 r
.53564 .64009 m .53721 .6497 L .5406 .65092 L p F P
0 g
s
.966 .687 .452 r
.5413 .64155 m .5438 .65134 L .54678 .65096 L p F P
0 g
s
.966 .687 .452 r
.5438 .65134 m .5413 .64155 L .53855 .64116 L p F P
0 g
s
.966 .687 .452 r
.53855 .64116 m .5406 .65092 L .5438 .65134 L p F P
0 g
s
.966 .687 .452 r
.5406 .65092 m .53855 .64116 L .53564 .64009 L p F P
0 g
s
.966 .687 .452 r
.53408 .63051 m .53564 .64009 L .53855 .64116 L p F P
0 g
s
0 0 .332 r
.53689 .64028 m .53843 .64864 L .5383 .65012 L p F P
0 g
s
.703 .805 .928 r
.53886 .65094 m .54472 .64993 L p .53879 .65175 L F P
0 g
s
.695 .813 .939 r
.54452 .65219 m .54346 .65437 L p .53864 .65332 L F P
0 g
s
.695 .813 .939 r
.53865 .65321 m .54452 .65219 L .53864 .65332 L F
.53872 .65248 m .54452 .65219 L p .53835 .65326 L F P
0 g
s
.683 .819 .949 r
.54346 .65437 m .54161 .65636 L p .53759 .65477 L F P
0 g
s
.683 .819 .949 r
.53765 .65466 m .54346 .65437 L .53759 .65477 L F
.53801 .65396 m .54346 .65437 L p .53735 .65468 L F P
0 g
s
.668 .822 .958 r
.54161 .65636 m .53905 .65808 L p .53602 .65606 L F P
0 g
s
.668 .822 .958 r
.53612 .65596 m .54161 .65636 L .53602 .65606 L F
.53675 .65532 m .54161 .65636 L p .53583 .65594 L F P
0 g
s
.642 .865 .983 r
.53905 .65808 m .54518 .65965 L .54051 .66168 L p F P
0 g
s
.676 .867 .972 r
.54518 .65965 m .53905 .65808 L .54161 .65636 L p F P
0 g
s
.262 .164 .551 r
.53675 .65532 m .5364 .65288 L p .53761 .6544 L F P
0 g
s
.41 .267 .574 r
.53472 .65402 m .5364 .65288 L p .53623 .65567 L F P
0 g
s
.41 .267 .574 r
.53623 .65567 m .53611 .65575 L .53472 .65402 L F
.668 .822 .958 r
.53583 .65594 m .53612 .65596 L .53602 .65606 L F
.41 .267 .574 r
.53501 .6565 m .53472 .65402 L p .53611 .65575 L F P
0 g
s
.651 .821 .965 r
.53388 .65699 m .53501 .6565 L .53399 .65713 L F
.51 .338 .583 r
.53437 .65678 m .53502 .65658 L .53436 .65684 L F
.53472 .65402 m .53501 .6565 L p .53437 .65678 L F P
0 g
s
.51 .338 .583 r
.53501 .6565 m .53502 .65658 L p .53437 .65678 L F P
0 g
s
.51 .338 .583 r
.53264 .65492 m .53472 .65402 L p .53436 .65684 L F P
0 g
s
.51 .338 .583 r
.53286 .65743 m .53264 .65492 L p .53432 .6568 L F P
0 g
s
.651 .821 .965 r
.53591 .65945 m .53286 .65743 L p .53388 .65699 L F P
0 g
s
.51 .338 .583 r
.53436 .65684 m .53286 .65743 L .53432 .6568 L F
.966 .687 .452 r
.53057 .65386 m .53072 .65643 L p .53206 .65745 L F P
0 g
s
.584 .392 .587 r
.53264 .65492 m .53286 .65743 L p .53213 .65763 L F P
0 g
s
.966 .687 .452 r
.53204 .65499 m .53057 .65386 L p .53228 .65798 L F P
0 g
s
.651 .821 .965 r
.53115 .6563 m .53274 .65561 L p .53388 .65699 L F P
0 g
s
.651 .821 .965 r
.53286 .65743 m .53115 .6563 L p .53388 .65699 L F P
0 g
s
.651 .821 .965 r
.53274 .65561 m .53501 .6565 L p .53388 .65699 L F P
0 g
s
.668 .822 .958 r
.53274 .65561 m .53402 .65474 L p .53583 .65594 L F P
0 g
s
.668 .822 .958 r
.53905 .65808 m .53501 .6565 L p .53583 .65594 L F P
0 g
s
.668 .822 .958 r
.53501 .6565 m .53274 .65561 L p .53583 .65594 L F P
0 g
s
.41 .267 .574 r
.53614 .65579 m .53501 .6565 L .53611 .65575 L F
.53502 .65658 m .53501 .6565 L p .53622 .65589 L F P
0 g
s
.41 .267 .574 r
.53622 .65589 m .53501 .6565 L .53614 .65579 L F
.651 .821 .965 r
.53905 .65808 m .53591 .65945 L p .53399 .65713 L F P
0 g
s
.651 .821 .965 r
.53501 .6565 m .53905 .65808 L p .53399 .65713 L F P
0 g
s
.603 .855 .991 r
.53591 .65945 m .54051 .66168 L .53918 .66203 L p F P
0 g
s
.603 .855 .991 r
.53591 .65945 m .53918 .66203 L .53578 .66012 L F
.642 .865 .983 r
.54051 .66168 m .53591 .65945 L .53905 .65808 L p F P
0 g
s
.41 .267 .574 r
.53769 .66179 m .53579 .66307 L p .53622 .65582 L F P
0 g
s
.41 .267 .574 r
.5364 .65288 m .53676 .6554 L p .53622 .65582 L F P
0 g
s
.41 .267 .574 r
.53676 .6554 m .53769 .66179 L p .53622 .65582 L F P
0 g
s
.018 .001 .491 r
.53801 .65396 m .53761 .65156 L p .53849 .65295 L F P
0 g
s
.695 .813 .939 r
.53835 .65326 m .53927 .65346 L .53822 .65352 L F
.262 .164 .551 r
.5364 .65288 m .53761 .65156 L p .53763 .65437 L F P
0 g
s
.262 .164 .551 r
.53763 .65437 m .53761 .6544 L .5364 .65288 L F
.695 .813 .939 r
.53857 .654 m .53801 .65396 L p .53927 .65346 L F P
0 g
s
.262 .164 .551 r
.53761 .65156 m .53801 .65396 L p .53763 .65439 L F P
0 g
s
.695 .813 .939 r
.53801 .65396 m .53495 .65373 L p .53839 .65351 L F P
0 g
s
.695 .813 .939 r
.53927 .65346 m .53801 .65396 L .53839 .65351 L F
.683 .819 .949 r
.54161 .65636 m .53675 .65532 L p .53735 .65468 L F P
0 g
s
.262 .164 .551 r
.53906 .66032 m .53769 .66179 L p .53763 .65439 L F P
0 g
s
.262 .164 .551 r
.53801 .65396 m .53906 .66032 L p .53763 .65439 L F P
0 g
s
.018 .001 .491 r
.53851 .65298 m .53801 .65396 L .53849 .65295 L F
.966 .687 .452 r
.53721 .6497 m .53564 .64009 L .53261 .63833 L p F P
0 g
s
.966 .687 .452 r
.53261 .63833 m .53367 .64767 L .53721 .6497 L p F P
0 g
s
.41 .267 .574 r
.53512 .644 m .5364 .65288 L .53472 .65402 L p F P
0 g
s
.262 .164 .551 r
.5364 .65288 m .53512 .644 L .53618 .64285 L p F P
0 g
s
.262 .164 .551 r
.53618 .64285 m .53761 .65156 L .5364 .65288 L p F P
0 g
s
.695 .813 .939 r
.53495 .65373 m .53548 .65264 L p .53835 .65326 L F P
0 g
s
.695 .813 .939 r
.53835 .65326 m .53822 .65352 L .53495 .65373 L F
.54346 .65437 m .53857 .654 L p .53927 .65346 L F P
0 g
s
.683 .819 .949 r
.53402 .65474 m .53495 .65373 L p .53735 .65468 L F P
0 g
s
.683 .819 .949 r
.53675 .65532 m .53402 .65474 L p .53735 .65468 L F P
0 g
s
.262 .164 .551 r
.53763 .65443 m .53675 .65532 L .53761 .6544 L F
0 0 .332 r
.53872 .65248 m .5383 .65012 L p .53881 .65143 L F P
0 g
s
.018 .001 .491 r
.53761 .65156 m .5383 .65012 L p .53851 .65292 L F P
0 g
s
.018 .001 .491 r
.53851 .65292 m .53849 .65295 L .53761 .65156 L F
.695 .813 .939 r
.53835 .65326 m .53865 .65321 L .53864 .65332 L F
.018 .001 .491 r
.53984 .65871 m .53906 .66032 L p .53852 .65307 L F P
0 g
s
.018 .001 .491 r
.5383 .65012 m .53874 .65255 L p .53852 .65307 L F P
0 g
s
.018 .001 .491 r
.53874 .65255 m .53984 .65871 L p .53852 .65307 L F P
0 g
s
0 0 .332 r
.53843 .64864 m .53886 .65094 L p .53882 .65143 L F P
0 g
s
.798 .528 0 r
.53886 .65094 m .53843 .64864 L p .53855 .64991 L F P
0 g
s
.018 .001 .491 r
.53761 .65156 m .53618 .64285 L .53678 .64159 L p F P
0 g
s
.018 .001 .491 r
.53678 .64159 m .5383 .65012 L .53761 .65156 L p F P
0 g
s
.708 .794 .918 r
.53864 .65022 m .53872 .65049 L .53557 .6515 L F
0 0 .332 r
.5383 .65012 m .53843 .64864 L p .53882 .6514 L F P
0 g
s
0 0 .332 r
.53882 .6514 m .53881 .65143 L .5383 .65012 L F
.708 .794 .918 r
.53946 .65084 m .53886 .65094 L p .53974 .65017 L F P
0 g
s
.708 .794 .918 r
.53886 .65094 m .53557 .6515 L p .53872 .65049 L F P
0 g
s
.708 .794 .918 r
.53974 .65017 m .53886 .65094 L .53872 .65049 L F
.53557 .6515 m .53524 .65038 L p .53864 .65022 L F P
0 g
s
.703 .805 .928 r
.54452 .65219 m .53872 .65248 L p .53879 .65175 L F P
0 g
s
0 0 .332 r
.53998 .65704 m .53984 .65871 L p .53882 .65143 L F P
0 g
s
0 0 .332 r
.5383 .65012 m .53678 .64159 L .53689 .64028 L p F P
0 g
s
.708 .794 .918 r
.53524 .65038 m .53841 .64942 L p .53864 .65022 L F P
0 g
s
.703 .805 .928 r
.53557 .6515 m .53886 .65094 L p .53879 .65175 L F P
0 g
s
0 0 .332 r
.53882 .6514 m .53883 .65146 L .53881 .65143 L F
.798 .528 0 r
.53949 .65539 m .53998 .65704 L p .53854 .64987 L F P
0 g
s
.798 .528 0 r
.538 .64717 m .53841 .64942 L p .53854 .64987 L F P
0 g
s
0 0 .332 r
.53883 .65146 m .53872 .65248 L .53881 .65143 L F
.798 .528 0 r
.53841 .64942 m .53949 .65539 L p .53854 .64987 L F P
0 g
s
.798 .528 0 r
.53855 .64994 m .53886 .65094 L .53855 .64991 L F
.708 .794 .918 r
.53864 .65022 m .53974 .65017 L .53872 .65049 L F
.54472 .64993 m .53946 .65084 L p .53974 .65017 L F P
0 g
s
.703 .805 .928 r
.53548 .65264 m .53557 .6515 L p .53879 .65175 L F P
0 g
s
.703 .805 .928 r
.53872 .65248 m .53548 .65264 L p .53879 .65175 L F P
0 g
s
.703 .805 .928 r
.53879 .65175 m .53908 .65166 L .53911 .65177 L F
0 0 .332 r
.53886 .65094 m .53998 .65704 L p .53882 .65143 L F P
0 g
s
.708 .794 .918 r
.54407 .6477 m .54472 .64993 L p .53891 .65021 L F P
0 g
s
.708 .794 .918 r
.53864 .65022 m .53892 .65009 L .53891 .65021 L F
.53892 .65009 m .54407 .6477 L .53891 .65021 L F
.798 .528 0 r
.53843 .64864 m .538 .64717 L p .53854 .64987 L F P
0 g
s
.798 .528 0 r
.53854 .64987 m .53855 .64991 L .53843 .64864 L F
.708 .794 .918 r
.53841 .64942 m .54407 .6477 L p .53864 .65022 L F P
0 g
s
.798 .528 0 r
.53854 .64987 m .53855 .64994 L .53855 .64991 L F
.53998 .65704 m .53886 .65094 L p .53855 .64994 L F P
0 g
s
.703 .805 .928 r
.54472 .64993 m .54452 .65219 L p .53911 .65177 L F P
0 g
s
.703 .805 .928 r
.53908 .65166 m .54472 .64993 L .53911 .65177 L F
0 0 .332 r
.53984 .65871 m .53872 .65248 L p .53883 .65146 L F P
0 g
s
.695 .813 .939 r
.53548 .65264 m .53872 .65248 L p .53835 .65326 L F P
0 g
s
.018 .001 .491 r
.53851 .65292 m .53851 .65298 L .53849 .65295 L F
.53906 .66032 m .53801 .65396 L p .53851 .65298 L F P
0 g
s
.683 .819 .949 r
.53735 .65468 m .53765 .65466 L .53759 .65477 L F
.53495 .65373 m .53801 .65396 L p .53735 .65468 L F P
0 g
s
.262 .164 .551 r
.53763 .65437 m .53763 .65443 L .53761 .6544 L F
.53769 .66179 m .53675 .65532 L p .53763 .65443 L F P
0 g
s
.668 .822 .958 r
.53402 .65474 m .53675 .65532 L p .53583 .65594 L F P
0 g
s
.41 .267 .574 r
.53623 .65567 m .53622 .65589 L .53611 .65575 L F
.632 .817 .971 r
.53318 .65764 m .53591 .65945 L p .53296 .65776 L F P
0 g
s
.603 .855 .991 r
.53501 .65969 m .53591 .65945 L p .53578 .66012 L F P
0 g
s
.41 .267 .574 r
.53579 .66307 m .53502 .65658 L p .53622 .65589 L F P
0 g
s
.632 .817 .971 r
.53286 .65743 m .53318 .65764 L p .53258 .65754 L F P
0 g
s
.632 .817 .971 r
.53318 .65764 m .53296 .65776 L .53258 .65754 L F
.53286 .65743 m .53258 .65754 L .53254 .65752 L F
.53115 .6563 m .53501 .65969 L .53132 .65689 L F
.51 .338 .583 r
.53579 .66307 m .53345 .66408 L p .53436 .65684 L F P
0 g
s
.51 .338 .583 r
.53502 .65658 m .53579 .66307 L p .53436 .65684 L F P
0 g
s
.584 .392 .587 r
.53286 .65743 m .53345 .66408 L p .53213 .65763 L F P
0 g
s
.966 .687 .452 r
.53206 .65745 m .53277 .66416 L .53228 .65798 L F
.632 .817 .971 r
.52935 .65678 m .5307 .65642 L p .53161 .65789 L F P
0 g
s
.632 .817 .971 r
.53132 .65689 m .53161 .65789 L .5307 .65642 L F
.53042 .65809 m .52935 .65678 L p .53161 .65789 L F P
0 g
s
.632 .817 .971 r
.53132 .65689 m .53225 .6576 L .53157 .65778 L F
.966 .687 .452 r
.53072 .65643 m .53111 .6629 L p .53206 .65745 L F P
0 g
s
.632 .817 .971 r
.5307 .65642 m .53115 .6563 L p .53132 .65689 L F P
0 g
s
.614 .808 .975 r
.52935 .65678 m .53042 .65809 L p .52903 .65827 L F P
0 g
s
.632 .817 .971 r
.53115 .6563 m .53286 .65743 L p .53254 .65752 L F P
0 g
s
.51 .338 .583 r
.53345 .66408 m .53286 .65743 L p .53436 .65684 L F P
0 g
s
.547 .881 .989 r
.53918 .66203 m .54051 .66168 L p .53999 .66232 L F P
0 g
s
.547 .881 .989 r
.54051 .66168 m .54492 .66296 L .54318 .66343 L p F P
0 g
s
.547 .881 .989 r
.54051 .66168 m .54318 .66343 L .53999 .66232 L F
.44 .867 .932 r
.54318 .66343 m .54492 .66296 L p .54398 .66352 L F P
0 g
s
.44 .867 .932 r
.54492 .66296 m .54908 .66329 L .54694 .66386 L p F P
0 g
s
.44 .867 .932 r
.54492 .66296 m .54694 .66386 L .54398 .66352 L F
.266 .772 .776 r
.54694 .66386 m .54908 .66329 L p .54772 .66374 L F P
0 g
s
0 0 0 r
.55044 .66334 m .55294 .66268 L p .55117 .66301 L F P
0 g
s
.266 .772 .776 r
.54908 .66329 m .55294 .66268 L .55044 .66334 L p F P
0 g
s
.266 .772 .776 r
.54908 .66329 m .55044 .66334 L .54772 .66374 L F
.966 .687 .452 r
.5561 .6688 m .55402 .66281 L p .55166 .66316 L F P
0 g
s
.966 .687 .452 r
.55369 .66186 m .5528 .65929 L p .55144 .66288 L F P
0 g
s
0 0 0 r
.55294 .66268 m .55646 .66113 L .55363 .66189 L p F P
0 g
s
0 0 0 r
.55294 .66268 m .55363 .66189 L .55117 .66301 L F
.966 .687 .452 r
.55451 .66115 m .55473 .66138 L .55653 .65947 L F
.55689 .66039 m .55653 .65947 L p .55473 .66138 L F P
0 g
s
.966 .687 .452 r
.55653 .65947 m .55557 .65703 L p .55451 .66115 L F P
0 g
s
.148 0 0 r
.55363 .66189 m .55646 .66113 L p .55429 .66134 L F P
0 g
s
.148 0 0 r
.55646 .66113 m .55961 .65869 L .55647 .65952 L p F P
0 g
s
.148 0 0 r
.55646 .66113 m .55647 .65952 L .55429 .66134 L F
.966 .687 .452 r
.55723 .65853 m .55744 .65872 L .559 .65623 L F
.55939 .6571 m .559 .65623 L p .55744 .65872 L F P
0 g
s
.966 .687 .452 r
.559 .65623 m .55797 .65393 L p .55723 .65853 L F P
0 g
s
.293 0 0 r
.55647 .65952 m .55961 .65869 L p .55706 .65876 L F P
0 g
s
.293 0 0 r
.55961 .65869 m .56234 .65539 L .55895 .65629 L p F P
0 g
s
.293 0 0 r
.55961 .65869 m .55895 .65629 L .55706 .65876 L F
.966 .687 .452 r
.55958 .65506 m .55978 .65521 L .56107 .65216 L F
.56148 .65298 m .56107 .65216 L p .55978 .65521 L F P
0 g
s
.966 .687 .452 r
.56107 .65216 m .55999 .65003 L p .55958 .65506 L F P
0 g
s
.389 0 .157 r
.55895 .65629 m .56234 .65539 L p .55945 .65532 L F P
0 g
s
.389 0 .157 r
.56234 .65539 m .56464 .65127 L .56103 .65223 L p F P
0 g
s
.389 0 .157 r
.56234 .65539 m .56103 .65223 L .55945 .65532 L F
.966 .687 .452 r
.56152 .6508 m .56171 .6509 L .56272 .64733 L F
.56315 .64809 m .56272 .64733 L p .56171 .6509 L F P
0 g
s
.966 .687 .452 r
.56272 .64733 m .56161 .64538 L p .56152 .6508 L F P
0 g
s
.453 .103 .281 r
.56103 .65223 m .56464 .65127 L p .56143 .65106 L F P
0 g
s
.453 .103 .281 r
.56464 .65127 m .56648 .64639 L .5627 .6474 L p F P
0 g
s
.453 .103 .281 r
.56464 .65127 m .5627 .6474 L .56143 .65106 L F
.966 .687 .452 r
.56306 .64579 m .56323 .64584 L .56395 .6418 L F
.56439 .64249 m .56395 .6418 L p .56323 .64584 L F P
0 g
s
.966 .687 .452 r
.56395 .6418 m .56282 .64004 L p .56306 .64579 L F P
0 g
s
.497 .188 .373 r
.5627 .6474 m .56648 .64639 L p .563 .64604 L F P
0 g
s
.497 .188 .373 r
.56648 .64639 m .56785 .64081 L .56394 .64186 L p F P
0 g
s
.497 .188 .373 r
.56648 .64639 m .56394 .64186 L .563 .64604 L F
.966 .687 .452 r
.56416 .6401 m .56427 .64035 L .56433 .64011 L F
.56282 .64004 m .56394 .64179 L p .56416 .6401 L F P
0 g
s
.529 .254 .442 r
.56394 .64186 m .56785 .64081 L p .56413 .64033 L F P
0 g
s
.529 .254 .442 r
.56785 .64081 m .56873 .6346 L .56473 .63567 L p F P
0 g
s
.529 .254 .442 r
.56785 .64081 m .56473 .63567 L .56413 .64033 L F
.553 .307 .498 r
.56473 .63567 m .56873 .6346 L p .56482 .63399 L F P
0 g
s
.553 .307 .498 r
.56873 .6346 m .56913 .62783 L .56509 .62892 L p F P
0 g
s
.553 .307 .498 r
.56873 .6346 m .56509 .62892 L .56482 .63399 L F
.571 .351 .543 r
.56509 .62892 m .56913 .62783 L p .56507 .62711 L F P
0 g
s
.571 .351 .543 r
.56913 .62783 m .56903 .62059 L .565 .62168 L p F P
0 g
s
.571 .351 .543 r
.56913 .62783 m .565 .62168 L .56507 .62711 L F
.585 .388 .581 r
.565 .62168 m .56903 .62059 L p .56487 .61974 L F P
0 g
s
.585 .388 .581 r
.56903 .62059 m .56844 .61295 L .56447 .61403 L p F P
0 g
s
.585 .388 .581 r
.56903 .62059 m .56447 .61403 L .56487 .61974 L F
.597 .421 .613 r
.56447 .61403 m .56844 .61295 L p .56423 .61199 L F P
0 g
s
.597 .421 .613 r
.56844 .61295 m .56738 .605 L .56351 .60606 L p F P
0 g
s
.597 .421 .613 r
.56844 .61295 m .56351 .60606 L .56423 .61199 L F
.607 .45 .642 r
.56351 .60606 m .56738 .605 L p .56315 .60394 L F P
0 g
s
.607 .45 .642 r
.56738 .605 m .56585 .59682 L .56213 .59784 L p F P
0 g
s
.607 .45 .642 r
.56738 .605 m .56213 .59784 L .56315 .60394 L F
.616 .476 .669 r
.56213 .59784 m .56585 .59682 L p .56166 .59567 L F P
0 g
s
.616 .476 .669 r
.56585 .59682 m .56388 .5885 L .56034 .58948 L p F P
0 g
s
.616 .476 .669 r
.56585 .59682 m .56034 .58948 L .56166 .59567 L F
.624 .501 .693 r
.56034 .58948 m .56388 .5885 L p .55977 .58726 L F P
0 g
s
.624 .501 .693 r
.56388 .5885 m .56149 .58013 L .55818 .58106 L p F P
0 g
s
.624 .501 .693 r
.56388 .5885 m .55818 .58106 L .55977 .58726 L F
.63 .525 .716 r
.55818 .58106 m .56149 .58013 L p .5575 .57882 L F P
0 g
s
.63 .525 .716 r
.56149 .58013 m .5587 .57181 L .55565 .57266 L p F P
0 g
s
.63 .525 .716 r
.56149 .58013 m .55565 .57266 L .5575 .57882 L F
.637 .548 .738 r
.55565 .57266 m .5587 .57181 L p .55488 .57042 L F P
0 g
s
.966 .687 .452 r
.55479 .57315 m .55571 .57283 L p .55488 .57043 L F P
0 g
s
.01 w
.56902 .62964 m
.57132 .63215 L
s
.5 Mabswid
.74 .608 .711 r
.50712 .57542 m .50547 .58404 L .51967 .5858 L p F P
0 g
s
.01 w
.38796 .62733 m
.41557 .61849 L
s
.24699 .67247 m
.38796 .62733 L
s
.5 Mabswid
.74 .608 .711 r
.51967 .5858 m .52019 .57705 L .50712 .57542 L p F P
0 g
s
.742 .592 .689 r
.51922 .59452 m .51967 .5858 L .50547 .58404 L p F P
0 g
s
.706 .579 .71 r
.52019 .57705 m .51967 .5858 L .53415 .58572 L p F P
0 g
s
.01 w
.52632 .334 m
.52632 .47522 L
s
.5 Mabswid
.705 .56 .688 r
.51967 .5858 m .51922 .59452 L .53469 .59444 L p F P
0 g
s
.705 .56 .688 r
.53469 .59444 m .53415 .58572 L .51967 .5858 L p F P
0 g
s
.706 .579 .71 r
.53415 .58572 m .53353 .57698 L .52019 .57705 L p F P
0 g
s
.67 .551 .712 r
.53353 .57698 m .53415 .58572 L .5483 .58381 L p F P
0 g
s
.666 .531 .689 r
.53415 .58572 m .53469 .59444 L .54979 .59241 L p F P
0 g
s
.666 .531 .689 r
.54979 .59241 m .5483 .58381 L .53415 .58572 L p F P
0 g
s
.737 .624 .733 r
.50899 .56689 m .50712 .57542 L .52019 .57705 L p F P
0 g
s
.737 .624 .733 r
.52019 .57705 m .52079 .56837 L .50899 .56689 L p F P
0 g
s
.705 .596 .732 r
.52079 .56837 m .52019 .57705 L .53353 .57698 L p F P
0 g
s
.705 .596 .732 r
.53353 .57698 m .53283 .5683 L .52079 .56837 L p F P
0 g
s
.672 .571 .733 r
.53283 .5683 m .53353 .57698 L .54656 .57521 L p F P
0 g
s
.67 .551 .712 r
.5483 .58381 m .54656 .57521 L .53353 .57698 L p F P
0 g
s
.742 .592 .689 r
.50547 .58404 m .50405 .59265 L .51922 .59452 L p F P
0 g
s
.744 .575 .666 r
.51885 .60312 m .51922 .59452 L .50405 .59265 L p F P
0 g
s
.704 .542 .665 r
.53512 .60304 m .53469 .59444 L .51922 .59452 L p F P
0 g
s
.662 .509 .666 r
.53469 .59444 m .53512 .60304 L .55102 .60091 L p F P
0 g
s
.662 .509 .666 r
.55102 .60091 m .54979 .59241 L .53469 .59444 L p F P
0 g
s
.966 .687 .452 r
.57745 .63414 m .57295 .62964 L .57308 .63836 L p F P
0 g
s
.966 .687 .452 r
.57308 .63836 m .5776 .64371 L .57745 .63414 L p F P
0 g
s
.01 w
.57132 .63215 m
.57465 .63578 L
s
.5 Mabswid
.733 .639 .754 r
.51106 .55852 m .50899 .56689 L .52079 .56837 L p F P
0 g
s
.733 .639 .754 r
.52079 .56837 m .52145 .55984 L .51106 .55852 L p F P
0 g
s
.704 .614 .753 r
.52145 .55984 m .52079 .56837 L .53283 .5683 L p F P
0 g
s
.704 .614 .753 r
.53283 .5683 m .53206 .55978 L .52145 .55984 L p F P
0 g
s
.674 .591 .755 r
.53206 .55978 m .53283 .5683 L .54459 .5667 L p F P
0 g
s
.672 .571 .733 r
.54656 .57521 m .54459 .5667 L .53283 .5683 L p F P
0 g
s
.966 .687 .452 r
.5821 .64904 m .5776 .64371 L .57718 .65266 L p F P
0 g
s
.966 .687 .452 r
.57718 .65266 m .58165 .65879 L .5821 .64904 L p F P
0 g
s
.01 w
.57916 .6407 m
.67104 .74096 L
s
.5 Mabswid
.966 .687 .452 r
.62095 .77128 m .61698 .76337 L .61201 .77496 L p F P
0 g
s
.966 .687 .452 r
.61201 .77496 m .61581 .78346 L .62095 .77128 L p F P
0 g
s
.966 .687 .452 r
.53236 .49551 m .53187 .50257 L .53733 .51032 L p F P
0 g
s
.966 .687 .452 r
.53636 .51672 m .53733 .51032 L .53187 .50257 L p F P
0 g
s
.966 .687 .452 r
.53733 .51032 m .53636 .51672 L .5412 .52448 L p F P
0 g
s
.767 .654 .738 r
.49795 .56392 m .49489 .57215 L .50712 .57542 L p F P
0 g
s
.767 .654 .738 r
.50712 .57542 m .50899 .56689 L .49795 .56392 L p F P
0 g
s
.773 .641 .716 r
.50547 .58404 m .50712 .57542 L .49489 .57215 L p F P
0 g
s
.773 .641 .716 r
.49489 .57215 m .49218 .5805 L .50547 .58404 L p F P
0 g
s
.779 .627 .693 r
.50405 .59265 m .50547 .58404 L .49218 .5805 L p F P
0 g
s
.01 w
.41557 .61849 m
.4211 .61672 L
s
.5 Mabswid
.744 .575 .666 r
.50405 .59265 m .50289 .60116 L .51885 .60312 L p F P
0 g
s
.745 .557 .641 r
.51856 .61151 m .51885 .60312 L .50289 .60116 L p F P
0 g
s
.657 .486 .641 r
.53512 .60304 m .53546 .61142 L .55197 .60922 L p F P
0 g
s
.657 .486 .641 r
.55197 .60922 m .55102 .60091 L .53512 .60304 L p F P
0 g
s
.966 .687 .452 r
.52632 .48034 m .52632 .488 L .53236 .49551 L p F P
0 g
s
.966 .687 .452 r
.53187 .50257 m .53236 .49551 L .52632 .488 L p F P
0 g
s
.76 .667 .759 r
.50134 .5559 m .49795 .56392 L .50899 .56689 L p F P
0 g
s
.76 .667 .759 r
.50899 .56689 m .51106 .55852 L .50134 .5559 L p F P
0 g
s
.728 .654 .776 r
.5133 .55043 m .51106 .55852 L .52145 .55984 L p F P
0 g
s
.728 .654 .776 r
.52145 .55984 m .52216 .55155 L .5133 .55043 L p F P
0 g
s
.702 .631 .774 r
.52216 .55155 m .52145 .55984 L .53206 .55978 L p F P
0 g
s
.966 .687 .452 r
.60423 .72064 m .60004 .71324 L .5969 .72344 L p F P
0 g
s
.966 .687 .452 r
.5969 .72344 m .60094 .73147 L .60423 .72064 L p F P
0 g
s
.702 .631 .774 r
.53206 .55978 m .53121 .5515 L .52216 .55155 L p F P
0 g
s
.676 .612 .776 r
.53121 .5515 m .53206 .55978 L .54241 .55836 L p F P
0 g
s
.674 .591 .755 r
.54459 .5667 m .54241 .55836 L .53206 .55978 L p F P
0 g
s
.779 .627 .693 r
.49218 .5805 m .48986 .58889 L .50405 .59265 L p F P
0 g
s
.783 .612 .668 r
.50289 .60116 m .50405 .59265 L .48986 .58889 L p F P
0 g
s
.01 w
.4211 .61672 m
.42687 .61488 L
s
.5 Mabswid
.966 .687 .452 r
.59368 .68821 m .58933 .68143 L .58738 .69088 L p F P
0 g
s
.966 .687 .452 r
.58738 .69088 m .59162 .69836 L .59368 .68821 L p F P
0 g
s
.966 .687 .452 r
.53976 .53015 m .5412 .52448 L .53636 .51672 L p F P
0 g
s
.966 .687 .452 r
.5412 .52448 m .53976 .53015 L .54396 .53771 L p F P
0 g
s
.966 .687 .452 r
.58611 .66489 m .58165 .65879 L .58057 .66775 L p F P
0 g
s
.966 .687 .452 r
.58057 .66775 m .58496 .67461 L .58611 .66489 L p F P
0 g
s
.752 .679 .781 r
.50502 .54818 m .50134 .5559 L .51106 .55852 L p F P
0 g
s
.752 .679 .781 r
.51106 .55852 m .5133 .55043 L .50502 .54818 L p F P
0 g
s
.676 .612 .776 r
.54241 .55836 m .54004 .55028 L .53121 .5515 L p F P
0 g
s
.745 .557 .641 r
.50289 .60116 m .50199 .60948 L .51856 .61151 L p F P
0 g
s
.745 .537 .613 r
.51836 .6196 m .51856 .61151 L .50199 .60948 L p F P
0 g
s
.783 .612 .668 r
.48986 .58889 m .48794 .59722 L .50289 .60116 L p F P
0 g
s
.787 .596 .642 r
.50199 .60948 m .50289 .60116 L .48794 .59722 L p F P
0 g
s
.01 w
.42687 .61488 m
.431 .61356 L
s
.5 Mabswid
.652 .461 .613 r
.53546 .61142 m .5357 .61951 L .55264 .61726 L p F P
0 g
s
.652 .461 .613 r
.55264 .61726 m .55197 .60922 L .53546 .61142 L p F P
0 g
s
.966 .687 .452 r
.61698 .76337 m .61298 .75543 L .60821 .76644 L p F P
0 g
s
.966 .687 .452 r
.60821 .76644 m .61201 .77496 L .61698 .76337 L p F P
0 g
s
.722 .669 .798 r
.5157 .54268 m .5133 .55043 L .52216 .55155 L p F P
0 g
s
.722 .669 .798 r
.52216 .55155 m .52293 .5436 L .5157 .54268 L p F P
0 g
s
.7 .649 .796 r
.52293 .5436 m .52216 .55155 L .53121 .5515 L p F P
0 g
s
.7 .649 .796 r
.53121 .5515 m .53031 .54356 L .52293 .5436 L p F P
0 g
s
.676 .632 .798 r
.53031 .54356 m .53121 .5515 L .54004 .55028 L p F P
0 g
s
.797 .689 .746 r
.48818 .55959 m .48404 .56737 L .49489 .57215 L p F P
0 g
s
.797 .689 .746 r
.49489 .57215 m .49795 .56392 L .48818 .55959 L p F P
0 g
s
.807 .679 .723 r
.49218 .5805 m .49489 .57215 L .48404 .56737 L p F P
0 g
s
.787 .699 .768 r
.49275 .55207 m .48818 .55959 L .49795 .56392 L p F P
0 g
s
.787 .699 .768 r
.49795 .56392 m .50134 .5559 L .49275 .55207 L p F P
0 g
s
.807 .679 .723 r
.48404 .56737 m .48039 .57534 L .49218 .5805 L p F P
0 g
s
.815 .667 .699 r
.48986 .58889 m .49218 .5805 L .48039 .57534 L p F P
0 g
s
.01 w
.431 .61356 m
.43379 .61266 L
s
.5 Mabswid
.597 .527 .747 r
.55554 .56361 m .5587 .57181 L .5694 .56692 L p F P
0 g
s
.586 .5 .724 r
.5587 .57181 m .56149 .58013 L .57313 .57485 L p F P
0 g
s
.586 .5 .724 r
.57313 .57485 m .5694 .56692 L .5587 .57181 L p F P
0 g
s
.966 .687 .452 r
.60004 .71324 m .59584 .70581 L .59285 .71538 L p F P
0 g
s
.966 .687 .452 r
.59285 .71538 m .5969 .72344 L .60004 .71324 L p F P
0 g
s
.607 .553 .769 r
.55205 .55563 m .55554 .56361 L .56519 .55918 L p F P
0 g
s
.597 .527 .747 r
.5694 .56692 m .56519 .55918 L .55554 .56361 L p F P
0 g
s
.742 .691 .802 r
.50895 .54083 m .50502 .54818 L .5133 .55043 L p F P
0 g
s
.742 .691 .802 r
.5133 .55043 m .5157 .54268 L .50895 .54083 L p F P
0 g
s
.575 .472 .7 r
.56149 .58013 m .56388 .5885 L .57633 .58288 L p F P
0 g
s
.575 .472 .7 r
.57633 .58288 m .57313 .57485 L .56149 .58013 L p F P
0 g
s
.676 .632 .798 r
.54004 .55028 m .53751 .54256 L .53031 .54356 L p F P
0 g
s
.966 .687 .452 r
.5776 .64371 m .57308 .63836 L .57267 .64649 L p F P
0 g
s
.01 w
.57465 .63578 m
.57916 .6407 L
s
.5 Mabswid
.966 .687 .452 r
.57267 .64649 m .57718 .65266 L .5776 .64371 L p F P
0 g
s
.787 .596 .642 r
.48794 .59722 m .48646 .60542 L .50199 .60948 L p F P
0 g
s
.79 .577 .613 r
.50136 .61753 m .50199 .60948 L .48646 .60542 L p F P
0 g
s
.745 .537 .613 r
.50199 .60948 m .50136 .61753 L .51836 .6196 L p F P
0 g
s
.966 .687 .452 r
.63841 .83407 m .63466 .82568 L .62728 .83844 L p F P
0 g
s
.966 .687 .452 r
.62728 .83844 m .63081 .84738 L .63841 .83407 L p F P
0 g
s
.966 .687 .452 r
.55133 .57435 m .55479 .57315 L .55202 .56513 L p F P
0 g
s
.966 .687 .452 r
.55479 .57315 m .55133 .57435 L .55349 .58149 L p F P
0 g
s
.966 .687 .452 r
.55349 .58149 m .55725 .58127 L .55479 .57315 L p F P
0 g
s
.775 .708 .789 r
.4977 .5449 m .49275 .55207 L .50134 .5559 L p F P
0 g
s
.775 .708 .789 r
.50134 .5559 m .50502 .54818 L .4977 .5449 L p F P
0 g
s
.815 .667 .699 r
.48039 .57534 m .47725 .5834 L .48986 .58889 L p F P
0 g
s
.823 .654 .673 r
.48794 .59722 m .48986 .58889 L .47725 .5834 L p F P
0 g
s
.01 w
.43379 .61266 m
.43888 .61103 L
s
.5 Mabswid
.744 .515 .583 r
.51825 .6273 m .51836 .6196 L .50136 .61753 L p F P
0 g
s
.966 .687 .452 r
.58933 .68143 m .58496 .67461 L .58313 .68337 L p F P
0 g
s
.966 .687 .452 r
.58313 .68337 m .58738 .69088 L .58933 .68143 L p F P
0 g
s
.966 .687 .452 r
.55725 .58127 m .55349 .58149 L .55533 .58865 L p F P
0 g
s
.966 .687 .452 r
.55533 .58865 m .55935 .58942 L .55725 .58127 L p F P
0 g
s
.616 .58 .79 r
.54826 .54794 m .55205 .55563 L .56053 .55171 L p F P
0 g
s
.607 .553 .769 r
.56519 .55918 m .56053 .55171 L .55205 .55563 L p F P
0 g
s
.966 .687 .452 r
.61298 .75543 m .60898 .74747 L .6044 .7579 L p F P
0 g
s
.966 .687 .452 r
.6044 .7579 m .60821 .76644 L .61298 .75543 L p F P
0 g
s
.644 .433 .583 r
.5357 .61951 m .53583 .62721 L .553 .62494 L p F P
0 g
s
.644 .433 .583 r
.553 .62494 m .55264 .61726 L .5357 .61951 L p F P
0 g
s
.966 .687 .452 r
.54889 .56731 m .55202 .56513 L .54895 .55732 L p F P
0 g
s
.966 .687 .452 r
.55202 .56513 m .54889 .56731 L .55133 .57435 L p F P
0 g
s
.562 .442 .674 r
.56388 .5885 m .56585 .59682 L .57896 .59093 L p F P
0 g
s
.562 .442 .674 r
.57896 .59093 m .57633 .58288 L .56388 .5885 L p F P
0 g
s
.966 .687 .452 r
.52632 .488 m .52632 .4957 L .53187 .50257 L p F P
0 g
s
.966 .687 .452 r
.53138 .50968 m .53187 .50257 L .52632 .4957 L p F P
0 g
s
.966 .687 .452 r
.53187 .50257 m .53138 .50968 L .53636 .51672 L p F P
0 g
s
.966 .687 .452 r
.53538 .52316 m .53636 .51672 L .53138 .50968 L p F P
0 g
s
.966 .687 .452 r
.53636 .51672 m .53538 .52316 L .53976 .53015 L p F P
0 g
s
.966 .687 .452 r
.58165 .65879 m .57718 .65266 L .57616 .66087 L p F P
0 g
s
.966 .687 .452 r
.57616 .66087 m .58057 .66775 L .58165 .65879 L p F P
0 g
s
.714 .685 .821 r
.51823 .53536 m .5157 .54268 L .52293 .5436 L p F P
0 g
s
.714 .685 .821 r
.52293 .5436 m .52373 .53606 L .51823 .53536 L p F P
0 g
s
.696 .668 .819 r
.52373 .53606 m .52293 .5436 L .53031 .54356 L p F P
0 g
s
.696 .668 .819 r
.53031 .54356 m .52936 .53603 L .52373 .53606 L p F P
0 g
s
.676 .654 .821 r
.52936 .53603 m .53031 .54356 L .53751 .54256 L p F P
0 g
s
.966 .687 .452 r
.55935 .58942 m .55533 .58865 L .55685 .59575 L p F P
0 g
s
.966 .687 .452 r
.55685 .59575 m .56108 .59751 L .55935 .58942 L p F P
0 g
s
.966 .687 .452 r
.54619 .56044 m .54895 .55732 L .54561 .54978 L p F P
0 g
s
.966 .687 .452 r
.54895 .55732 m .54619 .56044 L .54889 .56731 L p F P
0 g
s
.761 .716 .811 r
.50299 .53815 m .4977 .5449 L .50502 .54818 L p F P
0 g
s
.761 .716 .811 r
.50502 .54818 m .50895 .54083 L .50299 .53815 L p F P
0 g
s
.823 .654 .673 r
.47725 .5834 m .47467 .59148 L .48794 .59722 L p F P
0 g
s
.83 .639 .645 r
.48646 .60542 m .48794 .59722 L .47467 .59148 L p F P
0 g
s
.01 w
.43888 .61103 m
.44252 .60987 L
s
.5 Mabswid
.966 .687 .452 r
.63466 .82568 m .63091 .81728 L .62374 .82949 L p F P
0 g
s
.966 .687 .452 r
.62374 .82949 m .62728 .83844 L .63466 .82568 L p F P
0 g
s
.625 .606 .811 r
.54421 .54064 m .54826 .54794 L .55548 .54459 L p F P
0 g
s
.616 .58 .79 r
.56053 .55171 m .55548 .54459 L .54826 .54794 L p F P
0 g
s
.73 .703 .825 r
.51309 .53395 m .50895 .54083 L .5157 .54268 L p F P
0 g
s
.73 .703 .825 r
.5157 .54268 m .51823 .53536 L .51309 .53395 L p F P
0 g
s
.548 .41 .645 r
.56585 .59682 m .56738 .605 L .581 .59891 L p F P
0 g
s
.548 .41 .645 r
.581 .59891 m .57896 .59093 L .56585 .59682 L p F P
0 g
s
.676 .654 .821 r
.53751 .54256 m .53485 .53527 L .52936 .53603 L p F P
0 g
s
.79 .577 .613 r
.48646 .60542 m .48543 .61338 L .50136 .61753 L p F P
0 g
s
.792 .556 .581 r
.50101 .62521 m .50136 .61753 L .48543 .61338 L p F P
0 g
s
.744 .515 .583 r
.50136 .61753 m .50101 .62521 L .51825 .6273 L p F P
0 g
s
.966 .687 .452 r
.59584 .70581 m .59162 .69836 L .58879 .7073 L p F P
0 g
s
.966 .687 .452 r
.58879 .7073 m .59285 .71538 L .59584 .70581 L p F P
0 g
s
.966 .687 .452 r
.56108 .59751 m .55685 .59575 L .55802 .60273 L p F P
0 g
s
.966 .687 .452 r
.55802 .60273 m .56242 .60546 L .56108 .59751 L p F P
0 g
s
.966 .687 .452 r
.60898 .74747 m .60497 .73948 L .60058 .74934 L p F P
0 g
s
.966 .687 .452 r
.60058 .74934 m .6044 .7579 L .60898 .74747 L p F P
0 g
s
.966 .687 .452 r
.54326 .55383 m .54561 .54978 L .54205 .5426 L p F P
0 g
s
.966 .687 .452 r
.54561 .54978 m .54326 .55383 L .54619 .56044 L p F P
0 g
s
.812 .736 .78 r
.48566 .5472 m .48011 .55408 L .48818 .55959 L p F P
0 g
s
.812 .736 .78 r
.48818 .55959 m .49275 .55207 L .48566 .5472 L p F P
0 g
s
.827 .73 .758 r
.48404 .56737 m .48818 .55959 L .48011 .55408 L p F P
0 g
s
.827 .73 .758 r
.48011 .55408 m .47508 .5613 L .48404 .56737 L p F P
0 g
s
.84 .722 .734 r
.48039 .57534 m .48404 .56737 L .47508 .5613 L p F P
0 g
s
.966 .687 .452 r
.63091 .81728 m .62715 .80885 L .6202 .82053 L p F P
0 g
s
.966 .687 .452 r
.6202 .82053 m .62374 .82949 L .63091 .81728 L p F P
0 g
s
.635 .402 .547 r
.53583 .62721 m .53585 .63444 L .55306 .63218 L p F P
0 g
s
.635 .402 .547 r
.55306 .63218 m .553 .62494 L .53583 .62721 L p F P
0 g
s
.566 .537 .781 r
.56053 .55171 m .56519 .55918 L .5731 .55358 L p F P
0 g
s
.55 .506 .759 r
.56519 .55918 m .5694 .56692 L .57819 .56074 L p F P
0 g
s
.01 w
.81401 .49093 m
.83926 .48285 L
s
.5 Mabswid
.55 .506 .759 r
.57819 .56074 m .5731 .55358 L .56519 .55918 L p F P
0 g
s
.746 .724 .832 r
.50855 .5319 m .50299 .53815 L .50895 .54083 L p F P
0 g
s
.746 .724 .832 r
.50895 .54083 m .51309 .53395 L .50855 .5319 L p F P
0 g
s
.796 .741 .802 r
.49167 .54073 m .48566 .5472 L .49275 .55207 L p F P
0 g
s
.796 .741 .802 r
.49275 .55207 m .4977 .5449 L .49167 .54073 L p F P
0 g
s
.83 .639 .645 r
.47467 .59148 m .47267 .59948 L .48646 .60542 L p F P
0 g
s
.836 .622 .613 r
.48543 .61338 m .48646 .60542 L .47267 .59948 L p F P
0 g
s
.01 w
.44252 .60987 m
.44496 .60908 L
s
.5 Mabswid
.534 .474 .735 r
.5694 .56692 m .57313 .57485 L .5827 .56817 L p F P
0 g
s
.01 w
.7874 .49945 m
.81401 .49093 L
s
.5 Mabswid
.534 .474 .735 r
.5827 .56817 m .57819 .56074 L .5694 .56692 L p F P
0 g
s
.634 .634 .833 r
.53994 .5338 m .54421 .54064 L .55009 .53789 L p F P
0 g
s
.625 .606 .811 r
.55548 .54459 m .55009 .53789 L .54421 .54064 L p F P
0 g
s
.966 .687 .452 r
.58496 .67461 m .58057 .66775 L .57886 .67583 L p F P
0 g
s
.966 .687 .452 r
.57886 .67583 m .58313 .68337 L .58496 .67461 L p F P
0 g
s
.582 .567 .803 r
.55548 .54459 m .56053 .55171 L .56748 .54676 L p F P
0 g
s
.566 .537 .781 r
.5731 .55358 m .56748 .54676 L .56053 .55171 L p F P
0 g
s
.532 .374 .613 r
.56738 .605 m .56844 .61295 L .58242 .60674 L p F P
0 g
s
.532 .374 .613 r
.58242 .60674 m .581 .59891 L .56738 .605 L p F P
0 g
s
.84 .722 .734 r
.47508 .5613 m .47063 .56877 L .48039 .57534 L p F P
0 g
s
.853 .714 .708 r
.47725 .5834 m .48039 .57534 L .47063 .56877 L p F P
0 g
s
.704 .701 .845 r
.52086 .52855 m .51823 .53536 L .52373 .53606 L p F P
0 g
s
.704 .701 .845 r
.52373 .53606 m .52457 .52903 L .52086 .52855 L p F P
0 g
s
.69 .688 .843 r
.52457 .52903 m .52373 .53606 L .52936 .53603 L p F P
0 g
s
.966 .687 .452 r
.56815 .6403 m .57267 .64649 L .57308 .63836 L p F P
0 g
s
.69 .688 .843 r
.52936 .53603 m .52837 .52901 L .52457 .52903 L p F P
0 g
s
.675 .678 .845 r
.52837 .52901 m .52936 .53603 L .53485 .53527 L p F P
0 g
s
.966 .687 .452 r
.56242 .60546 m .55802 .60273 L .55883 .60949 L p F P
0 g
s
.966 .687 .452 r
.55883 .60949 m .56335 .61317 L .56242 .60546 L p F P
0 g
s
.515 .44 .709 r
.57313 .57485 m .57633 .58288 L .58656 .57578 L p F P
0 g
s
.01 w
.76803 .50565 m
.7874 .49945 L
s
.5 Mabswid
.515 .44 .709 r
.58656 .57578 m .5827 .56817 L .57313 .57485 L p F P
0 g
s
.778 .745 .822 r
.49809 .53474 m .49167 .54073 L .4977 .5449 L p F P
0 g
s
.778 .745 .822 r
.4977 .5449 m .50299 .53815 L .49809 .53474 L p F P
0 g
s
.596 .597 .823 r
.55009 .53789 m .55548 .54459 L .56139 .54036 L p F P
0 g
s
.582 .567 .803 r
.56748 .54676 m .56139 .54036 L .55548 .54459 L p F P
0 g
s
.966 .687 .452 r
.54014 .54753 m .54205 .5426 L .5383 .53587 L p F P
0 g
s
.966 .687 .452 r
.54205 .5426 m .54014 .54753 L .54326 .55383 L p F P
0 g
s
.716 .715 .848 r
.51739 .5276 m .51309 .53395 L .51823 .53536 L p F P
0 g
s
.716 .715 .848 r
.51823 .53536 m .52086 .52855 L .51739 .5276 L p F P
0 g
s
.675 .678 .845 r
.53485 .53527 m .53207 .52849 L .52837 .52901 L p F P
0 g
s
.966 .687 .452 r
.57718 .65266 m .57267 .64649 L .57174 .65396 L p F P
0 g
s
.966 .687 .452 r
.57174 .65396 m .57616 .66087 L .57718 .65266 L p F P
0 g
s
.966 .687 .452 r
.60497 .73948 m .60094 .73147 L .59675 .74076 L p F P
0 g
s
.966 .687 .452 r
.59675 .74076 m .60058 .74934 L .60497 .73948 L p F P
0 g
s
.966 .687 .452 r
.52632 .4957 m .52632 .50343 L .53138 .50968 L p F P
0 g
s
.966 .687 .452 r
.53089 .51682 m .53138 .50968 L .52632 .50343 L p F P
0 g
s
.966 .687 .452 r
.53138 .50968 m .53089 .51682 L .53538 .52316 L p F P
0 g
s
.966 .687 .452 r
.62715 .80885 m .62338 .8004 L .61665 .81155 L p F P
0 g
s
.966 .687 .452 r
.61665 .81155 m .6202 .82053 L .62715 .80885 L p F P
0 g
s
.853 .714 .708 r
.47063 .56877 m .46682 .57641 L .47725 .5834 L p F P
0 g
s
.865 .703 .68 r
.47467 .59148 m .47725 .5834 L .46682 .57641 L p F P
0 g
s
.792 .556 .581 r
.48543 .61338 m .48487 .62102 L .50101 .62521 L p F P
0 g
s
.792 .532 .543 r
.50096 .63244 m .50101 .62521 L .48487 .62102 L p F P
0 g
s
.966 .687 .452 r
.59162 .69836 m .58738 .69088 L .58471 .69919 L p F P
0 g
s
.966 .687 .452 r
.58471 .69919 m .58879 .7073 L .59162 .69836 L p F P
0 g
s
.495 .403 .68 r
.57633 .58288 m .57896 .59093 L .58975 .58349 L p F P
0 g
s
.01 w
.75393 .51017 m
.76803 .50565 L
s
.5 Mabswid
.495 .403 .68 r
.58975 .58349 m .58656 .57578 L .57633 .58288 L p F P
0 g
s
.759 .747 .842 r
.50483 .52929 m .49809 .53474 L .50299 .53815 L p F P
0 g
s
.759 .747 .842 r
.50299 .53815 m .50855 .5319 L .50483 .52929 L p F P
0 g
s
.727 .731 .854 r
.51434 .52621 m .50855 .5319 L .51309 .53395 L p F P
0 g
s
.727 .731 .854 r
.51309 .53395 m .51739 .5276 L .51434 .52621 L p F P
0 g
s
.836 .622 .613 r
.47267 .59948 m .47128 .60732 L .48543 .61338 L p F P
0 g
s
.842 .602 .577 r
.48487 .62102 m .48543 .61338 L .47128 .60732 L p F P
0 g
s
.01 w
.44496 .60908 m
.44637 .60863 L
s
.5 Mabswid
.634 .634 .833 r
.55009 .53789 m .54442 .5317 L .53994 .5338 L p F P
0 g
s
.611 .628 .843 r
.54442 .5317 m .55009 .53789 L .55489 .53443 L p F P
0 g
s
.596 .597 .823 r
.56139 .54036 m .55489 .53443 L .55009 .53789 L p F P
0 g
s
.966 .687 .452 r
.54785 .57556 m .55133 .57435 L .54889 .56731 L p F P
0 g
s
.966 .687 .452 r
.55133 .57435 m .54785 .57556 L .5497 .5817 L p F P
0 g
s
.966 .687 .452 r
.5497 .5817 m .55349 .58149 L .55133 .57435 L p F P
0 g
s
.642 .663 .855 r
.53551 .5275 m .53994 .5338 L .54442 .5317 L p F P
0 g
s
.966 .687 .452 r
.55349 .58149 m .5497 .5817 L .55129 .58787 L p F P
0 g
s
.966 .687 .452 r
.55129 .58787 m .55533 .58865 L .55349 .58149 L p F P
0 g
s
.966 .687 .452 r
.54574 .5695 m .54889 .56731 L .54619 .56044 L p F P
0 g
s
.966 .687 .452 r
.54889 .56731 m .54574 .5695 L .54785 .57556 L p F P
0 g
s
.513 .334 .576 r
.56844 .61295 m .56903 .62059 L .5832 .61432 L p F P
0 g
s
.513 .334 .576 r
.5832 .61432 m .58242 .60674 L .56844 .61295 L p F P
0 g
s
.966 .687 .452 r
.62338 .8004 m .6196 .79194 L .61309 .80256 L p F P
0 g
s
.966 .687 .452 r
.61309 .80256 m .61665 .81155 L .62338 .8004 L p F P
0 g
s
.966 .687 .452 r
.56335 .61317 m .55883 .60949 L .55927 .61598 L p F P
0 g
s
.966 .687 .452 r
.55927 .61598 m .56386 .62056 L .56335 .61317 L p F P
0 g
s
.623 .365 .506 r
.55282 .63888 m .55306 .63218 L .53585 .63444 L p F P
0 g
s
.865 .703 .68 r
.46682 .57641 m .46367 .58416 L .47467 .59148 L p F P
0 g
s
.876 .691 .648 r
.47267 .59948 m .47467 .59148 L .46367 .58416 L p F P
0 g
s
.01 w
.44637 .60863 m
.44835 .608 L
s
.5 Mabswid
.966 .687 .452 r
.55533 .58865 m .55129 .58787 L .55259 .59398 L p F P
0 g
s
.966 .687 .452 r
.55259 .59398 m .55685 .59575 L .55533 .58865 L p F P
0 g
s
.966 .687 .452 r
.58057 .66775 m .57616 .66087 L .57457 .66826 L p F P
0 g
s
.966 .687 .452 r
.57457 .66826 m .57886 .67583 L .58057 .66775 L p F P
0 g
s
.966 .687 .452 r
.54342 .5636 m .54619 .56044 L .54326 .55383 L p F P
0 g
s
.966 .687 .452 r
.54619 .56044 m .54342 .5636 L .54574 .5695 L p F P
0 g
s
.966 .687 .452 r
.60094 .73147 m .5969 .72344 L .59291 .73217 L p F P
0 g
s
.966 .687 .452 r
.59291 .73217 m .59675 .74076 L .60094 .73147 L p F P
0 g
s
.966 .687 .452 r
.53684 .54162 m .5383 .53587 L .5344 .52965 L p F P
0 g
s
.966 .687 .452 r
.5383 .53587 m .53684 .54162 L .54014 .54753 L p F P
0 g
s
.473 .362 .648 r
.57896 .59093 m .581 .59891 L .59222 .59122 L p F P
0 g
s
.473 .362 .648 r
.59222 .59122 m .58975 .58349 L .57896 .59093 L p F P
0 g
s
.69 .718 .87 r
.52356 .52234 m .52086 .52855 L .52457 .52903 L p F P
0 g
s
.69 .718 .87 r
.52457 .52903 m .52544 .52258 L .52356 .52234 L p F P
0 g
s
.681 .71 .869 r
.52544 .52258 m .52457 .52903 L .52837 .52901 L p F P
0 g
s
.681 .71 .869 r
.52837 .52901 m .52735 .52257 L .52544 .52258 L p F P
0 g
s
.672 .703 .87 r
.52735 .52257 m .52837 .52901 L .53207 .52849 L p F P
0 g
s
.736 .749 .862 r
.51184 .52445 m .50483 .52929 L .50855 .5319 L p F P
0 g
s
.736 .749 .862 r
.50855 .5319 m .51434 .52621 L .51184 .52445 L p F P
0 g
s
.815 .778 .818 r
.48722 .53587 m .48041 .54151 L .48566 .5472 L p F P
0 g
s
.815 .778 .818 r
.48566 .5472 m .49167 .54073 L .48722 .53587 L p F P
0 g
s
.836 .778 .797 r
.48011 .55408 m .48566 .5472 L .48041 .54151 L p F P
0 g
s
.642 .663 .855 r
.54442 .5317 m .53852 .52608 L .53551 .5275 L p F P
0 g
s
.625 .659 .863 r
.53852 .52608 m .54442 .5317 L .54806 .52906 L p F P
0 g
s
.611 .628 .843 r
.55489 .53443 m .54806 .52906 L .54442 .5317 L p F P
0 g
s
.836 .778 .797 r
.48041 .54151 m .47412 .54764 L .48011 .55408 L p F P
0 g
s
.855 .777 .774 r
.47508 .5613 m .48011 .55408 L .47412 .54764 L p F P
0 g
s
.966 .687 .452 r
.58738 .69088 m .58313 .68337 L .58062 .69106 L p F P
0 g
s
.966 .687 .452 r
.58062 .69106 m .58471 .69919 L .58738 .69088 L p F P
0 g
s
.793 .776 .838 r
.49448 .53076 m .48722 .53587 L .49167 .54073 L p F P
0 g
s
.793 .776 .838 r
.49167 .54073 m .49809 .53474 L .49448 .53076 L p F P
0 g
s
.698 .727 .873 r
.52182 .52186 m .51739 .5276 L .52086 .52855 L p F P
0 g
s
.698 .727 .873 r
.52086 .52855 m .52356 .52234 L .52182 .52186 L p F P
0 g
s
.966 .687 .452 r
.55685 .59575 m .55259 .59398 L .55359 .59998 L p F P
0 g
s
.966 .687 .452 r
.55359 .59998 m .55802 .60273 L .55685 .59575 L p F P
0 g
s
.543 .558 .82 r
.56139 .54036 m .56748 .54676 L .57256 .54101 L p F P
0 g
s
.52 .522 .799 r
.56748 .54676 m .5731 .55358 L .5789 .54707 L p F P
0 g
s
.01 w
.73608 .51588 m
.75393 .51017 L
s
.5 Mabswid
.52 .522 .799 r
.5789 .54707 m .57256 .54101 L .56748 .54676 L p F P
0 g
s
.966 .687 .452 r
.6196 .79194 m .61581 .78346 L .60954 .79356 L p F P
0 g
s
.966 .687 .452 r
.60954 .79356 m .61309 .80256 L .6196 .79194 L p F P
0 g
s
.966 .687 .452 r
.5409 .5579 m .54326 .55383 L .54014 .54753 L p F P
0 g
s
.966 .687 .452 r
.54326 .55383 m .5409 .5579 L .54342 .5636 L p F P
0 g
s
.565 .592 .839 r
.55489 .53443 m .56139 .54036 L .5657 .53544 L p F P
0 g
s
.543 .558 .82 r
.57256 .54101 m .5657 .53544 L .56139 .54036 L p F P
0 g
s
.495 .485 .776 r
.5731 .55358 m .57819 .56074 L .58464 .55355 L p F P
0 g
s
.01 w
.71256 .52341 m
.73608 .51588 L
s
.5 Mabswid
.495 .485 .776 r
.58464 .55355 m .5789 .54707 L .5731 .55358 L p F P
0 g
s
.792 .532 .543 r
.48487 .62102 m .48477 .62827 L .50096 .63244 L p F P
0 g
s
.791 .502 .499 r
.50119 .63915 m .50096 .63244 L .48477 .62827 L p F P
0 g
s
.855 .777 .774 r
.47412 .54764 m .46842 .55418 L .47508 .5613 L p F P
0 g
s
.874 .774 .749 r
.47063 .56877 m .47508 .5613 L .46842 .55418 L p F P
0 g
s
.966 .687 .452 r
.57267 .64649 m .56815 .6403 L .56729 .64701 L p F P
0 g
s
.966 .687 .452 r
.56729 .64701 m .57174 .65396 L .57267 .64649 L p F P
0 g
s
.769 .772 .856 r
.5021 .52626 m .49448 .53076 L .49809 .53474 L p F P
0 g
s
.769 .772 .856 r
.49809 .53474 m .50483 .52929 L .5021 .52626 L p F P
0 g
s
.876 .691 .648 r
.46367 .58416 m .46123 .59191 L .47267 .59948 L p F P
0 g
s
.887 .675 .611 r
.47128 .60732 m .47267 .59948 L .46123 .59191 L p F P
0 g
s
.705 .738 .877 r
.52028 .52115 m .51434 .52621 L .51739 .5276 L p F P
0 g
s
.705 .738 .877 r
.51739 .5276 m .52182 .52186 L .52028 .52115 L p F P
0 g
s
.842 .602 .577 r
.47128 .60732 m .47051 .6149 L .48487 .62102 L p F P
0 g
s
.845 .578 .534 r
.48477 .62827 m .48487 .62102 L .47051 .6149 L p F P
0 g
s
.65 .694 .877 r
.53095 .52181 m .53551 .5275 L .53852 .52608 L p F P
0 g
s
.586 .625 .857 r
.54806 .52906 m .55489 .53443 L .55839 .53042 L p F P
0 g
s
.565 .592 .839 r
.5657 .53544 m .55839 .53042 L .55489 .53443 L p F P
0 g
s
.468 .446 .75 r
.57819 .56074 m .5827 .56817 L .58973 .56038 L p F P
0 g
s
.01 w
.69562 .52883 m
.71256 .52341 L
s
.5 Mabswid
.468 .446 .75 r
.58973 .56038 m .58464 .55355 L .57819 .56074 L p F P
0 g
s
.966 .687 .452 r
.52632 .50343 m .52632 .51121 L .53089 .51682 L p F P
0 g
s
.49 .288 .533 r
.56903 .62059 m .56913 .62783 L .58333 .62158 L p F P
0 g
s
.49 .288 .533 r
.58333 .62158 m .5832 .61432 L .56903 .62059 L p F P
0 g
s
.966 .687 .452 r
.5969 .72344 m .59285 .71538 L .58906 .72355 L p F P
0 g
s
.966 .687 .452 r
.58906 .72355 m .59291 .73217 L .5969 .72344 L p F P
0 g
s
.447 .317 .61 r
.581 .59891 m .58242 .60674 L .59394 .59888 L p F P
0 g
s
.447 .317 .61 r
.59394 .59888 m .59222 .59122 L .581 .59891 L p F P
0 g
s
.966 .687 .452 r
.56386 .62056 m .55927 .61598 L .55934 .62211 L p F P
0 g
s
.966 .687 .452 r
.55934 .62211 m .56395 .62756 L .56386 .62056 L p F P
0 g
s
.874 .774 .749 r
.46842 .55418 m .46338 .56106 L .47063 .56877 L p F P
0 g
s
.892 .77 .72 r
.46682 .57641 m .47063 .56877 L .46338 .56106 L p F P
0 g
s
.966 .687 .452 r
.55802 .60273 m .55359 .59998 L .55428 .60579 L p F P
0 g
s
.966 .687 .452 r
.55428 .60579 m .55883 .60949 L .55802 .60273 L p F P
0 g
s
.966 .687 .452 r
.61581 .78346 m .61201 .77496 L .60597 .78455 L p F P
0 g
s
.966 .687 .452 r
.60597 .78455 m .60954 .79356 L .61581 .78346 L p F P
0 g
s
.742 .767 .873 r
.51 .5224 m .5021 .52626 L .50483 .52929 L p F P
0 g
s
.742 .767 .873 r
.50483 .52929 m .51184 .52445 L .51 .5224 L p F P
0 g
s
.966 .687 .452 r
.5382 .55249 m .54014 .54753 L .53684 .54162 L p F P
0 g
s
.966 .687 .452 r
.54014 .54753 m .5382 .55249 L .5409 .5579 L p F P
0 g
s
.966 .687 .452 r
.53341 .53617 m .5344 .52965 L .53039 .52401 L p F P
0 g
s
.966 .687 .452 r
.5344 .52965 m .53341 .53617 L .53684 .54162 L p F P
0 g
s
.71 .749 .882 r
.51902 .52027 m .51184 .52445 L .51434 .52621 L p F P
0 g
s
.71 .749 .882 r
.51434 .52621 m .52028 .52115 L .51902 .52027 L p F P
0 g
s
.625 .659 .863 r
.54806 .52906 m .54097 .52429 L .53852 .52608 L p F P
0 g
s
.608 .659 .874 r
.54097 .52429 m .54806 .52906 L .55071 .52599 L p F P
0 g
s
.586 .625 .857 r
.55839 .53042 m .55071 .52599 L .54806 .52906 L p F P
0 g
s
.65 .694 .877 r
.53852 .52608 m .53247 .52109 L .53095 .52181 L p F P
0 g
s
.64 .692 .883 r
.53247 .52109 m .53852 .52608 L .54097 .52429 L p F P
0 g
s
.439 .403 .721 r
.5827 .56817 m .58656 .57578 L .5941 .56749 L p F P
0 g
s
.01 w
.68326 .53279 m
.69562 .52883 L
s
.5 Mabswid
.439 .403 .721 r
.5941 .56749 m .58973 .56038 L .5827 .56817 L p F P
0 g
s
.966 .687 .452 r
.57616 .66087 m .57174 .65396 L .57027 .66066 L p F P
0 g
s
.966 .687 .452 r
.57027 .66066 m .57457 .66826 L .57616 .66087 L p F P
0 g
s
.966 .687 .452 r
.58313 .68337 m .57886 .67583 L .57652 .68291 L p F P
0 g
s
.966 .687 .452 r
.57652 .68291 m .58062 .69106 L .58313 .68337 L p F P
0 g
s
.892 .77 .72 r
.46338 .56106 m .45904 .56821 L .46682 .57641 L p F P
0 g
s
.909 .763 .687 r
.46367 .58416 m .46682 .57641 L .45904 .56821 L p F P
0 g
s
.887 .675 .611 r
.46123 .59191 m .45954 .59958 L .47128 .60732 L p F P
0 g
s
.895 .655 .567 r
.47051 .6149 m .47128 .60732 L .45954 .59958 L p F P
0 g
s
.966 .687 .452 r
.61201 .77496 m .60821 .76644 L .6024 .77552 L p F P
0 g
s
.966 .687 .452 r
.6024 .77552 m .60597 .78455 L .61201 .77496 L p F P
0 g
s
.713 .76 .889 r
.5181 .51923 m .51 .5224 L .51184 .52445 L p F P
0 g
s
.713 .76 .889 r
.51184 .52445 m .51902 .52027 L .5181 .51923 L p F P
0 g
s
.966 .687 .452 r
.59285 .71538 m .58879 .7073 L .5852 .71492 L p F P
0 g
s
.966 .687 .452 r
.5852 .71492 m .58906 .72355 L .59285 .71538 L p F P
0 g
s
.673 .736 .898 r
.52544 .52258 m .52632 .51679 L .52356 .52234 L closepath p F P
0 g
s
.64 .692 .883 r
.54097 .52429 m .5337 .52019 L .53247 .52109 L p F P
0 g
s
.629 .692 .89 r
.5337 .52019 m .54097 .52429 L .54275 .52222 L p F P
0 g
s
.608 .659 .874 r
.55071 .52599 m .54275 .52222 L .54097 .52429 L p F P
0 g
s
.966 .687 .452 r
.55883 .60949 m .55428 .60579 L .55466 .61136 L p F P
0 g
s
.966 .687 .452 r
.55466 .61136 m .55927 .61598 L .55883 .60949 L p F P
0 g
s
.407 .355 .688 r
.58656 .57578 m .58975 .58349 L .59771 .5748 L p F P
0 g
s
.01 w
.67424 .53568 m
.68326 .53279 L
s
.5 Mabswid
.407 .355 .688 r
.59771 .5748 m .5941 .56749 L .58656 .57578 L p F P
0 g
s
.675 .739 .899 r
.52356 .52234 m .52632 .51679 L .52182 .52186 L closepath p F P
0 g
s
.416 .265 .566 r
.58242 .60674 m .5832 .61432 L .59488 .60639 L p F P
0 g
s
.416 .265 .566 r
.59488 .60639 m .59394 .59888 L .58242 .60674 L p F P
0 g
s
.966 .687 .452 r
.54433 .57678 m .54785 .57556 L .54574 .5695 L p F P
0 g
s
.966 .687 .452 r
.54785 .57556 m .54433 .57678 L .54588 .58192 L p F P
0 g
s
.966 .687 .452 r
.54588 .58192 m .5497 .5817 L .54785 .57556 L p F P
0 g
s
.966 .687 .452 r
.5497 .5817 m .54588 .58192 L .54721 .58708 L p F P
0 g
s
.966 .687 .452 r
.54721 .58708 m .55129 .58787 L .5497 .5817 L p F P
0 g
s
.775 .799 .872 r
.50049 .52293 m .49234 .5264 L .49448 .53076 L p F P
0 g
s
.775 .799 .872 r
.49448 .53076 m .5021 .52626 L .50049 .52293 L p F P
0 g
s
.803 .81 .857 r
.48722 .53587 m .49448 .53076 L .49234 .5264 L p F P
0 g
s
.966 .687 .452 r
.53537 .54742 m .53684 .54162 L .53341 .53617 L p F P
0 g
s
.966 .687 .452 r
.53684 .54162 m .53537 .54742 L .5382 .55249 L p F P
0 g
s
.966 .687 .452 r
.54257 .57171 m .54574 .5695 L .54342 .5636 L p F P
0 g
s
.966 .687 .452 r
.54574 .5695 m .54257 .57171 L .54433 .57678 L p F P
0 g
s
.803 .81 .857 r
.49234 .5264 m .48457 .53052 L .48722 .53587 L p F P
0 g
s
.829 .819 .839 r
.48041 .54151 m .48722 .53587 L .48457 .53052 L p F P
0 g
s
.677 .743 .9 r
.52182 .52186 m .52632 .51679 L .52028 .52115 L closepath p F P
0 g
s
.658 .727 .9 r
.53247 .52109 m .52632 .51679 L .53095 .52181 L closepath p F P
0 g
s
.845 .578 .534 r
.47051 .6149 m .47038 .62216 L .48477 .62827 L p F P
0 g
s
.846 .547 .482 r
.48515 .63503 m .48477 .62827 L .47038 .62216 L p F P
0 g
s
.791 .502 .499 r
.48477 .62827 m .48515 .63503 L .50119 .63915 L p F P
0 g
s
.786 .465 .444 r
.50171 .64524 m .50119 .63915 L .48515 .63503 L p F P
0 g
s
.561 .626 .874 r
.55071 .52599 m .55839 .53042 L .5604 .52602 L p F P
0 g
s
.53 .59 .859 r
.55839 .53042 m .5657 .53544 L .56819 .53006 L p F P
0 g
s
.53 .59 .859 r
.56819 .53006 m .5604 .52602 L .55839 .53042 L p F P
0 g
s
.745 .786 .886 r
.50893 .52015 m .50049 .52293 L .5021 .52626 L p F P
0 g
s
.745 .786 .886 r
.5021 .52626 m .51 .5224 L .50893 .52015 L p F P
0 g
s
.498 .551 .841 r
.5657 .53544 m .57256 .54101 L .57552 .53471 L p F P
0 g
s
.498 .551 .841 r
.57552 .53471 m .56819 .53006 L .5657 .53544 L p F P
0 g
s
.829 .819 .839 r
.48457 .53052 m .47727 .53525 L .48041 .54151 L p F P
0 g
s
.855 .827 .819 r
.47412 .54764 m .48041 .54151 L .47727 .53525 L p F P
0 g
s
.462 .233 .48 r
.56913 .62783 m .56873 .6346 L .58281 .62843 L p F P
0 g
s
.462 .233 .48 r
.58281 .62843 m .58333 .62158 L .56913 .62783 L p F P
0 g
s
.966 .687 .452 r
.55129 .58787 m .54721 .58708 L .54829 .59219 L p F P
0 g
s
.966 .687 .452 r
.54829 .59219 m .55259 .59398 L .55129 .58787 L p F P
0 g
s
.59 .661 .887 r
.54275 .52222 m .55071 .52599 L .55222 .52265 L p F P
0 g
s
.561 .626 .874 r
.5604 .52602 m .55222 .52265 L .55071 .52599 L p F P
0 g
s
.966 .687 .452 r
.56395 .62756 m .55934 .62211 L .55902 .62781 L p F P
0 g
s
.966 .687 .452 r
.55902 .62781 m .5636 .63407 L .56395 .62756 L p F P
0 g
s
.966 .687 .452 r
.54063 .56677 m .54342 .5636 L .5409 .5579 L p F P
0 g
s
.966 .687 .452 r
.54342 .5636 m .54063 .56677 L .54257 .57171 L p F P
0 g
s
.679 .747 .902 r
.52028 .52115 m .52632 .51679 L .51902 .52027 L closepath p F P
0 g
s
.654 .727 .902 r
.5337 .52019 m .52632 .51679 L .53247 .52109 L closepath p F P
0 g
s
.966 .687 .452 r
.60821 .76644 m .6044 .7579 L .59883 .76648 L p F P
0 g
s
.966 .687 .452 r
.59883 .76648 m .6024 .77552 L .60821 .76644 L p F P
0 g
s
.463 .51 .821 r
.57256 .54101 m .5789 .54707 L .58229 .53993 L p F P
0 g
s
.463 .51 .821 r
.58229 .53993 m .57552 .53471 L .57256 .54101 L p F P
0 g
s
.909 .763 .687 r
.45904 .56821 m .45546 .57556 L .46367 .58416 L p F P
0 g
s
.925 .753 .649 r
.46123 .59191 m .46367 .58416 L .45546 .57556 L p F P
0 g
s
.714 .771 .898 r
.51757 .5181 m .50893 .52015 L .51 .5224 L p F P
0 g
s
.714 .771 .898 r
.51 .5224 m .5181 .51923 L .51757 .5181 L p F P
0 g
s
.966 .687 .452 r
.52989 .53124 m .53039 .52401 L .52632 .51903 L p F P
0 g
s
.966 .687 .452 r
.53039 .52401 m .52989 .53124 L .53341 .53617 L p F P
0 g
s
.629 .692 .89 r
.54275 .52222 m .53459 .51914 L .5337 .52019 L p F P
0 g
s
.619 .695 .898 r
.53459 .51914 m .54275 .52222 L .54376 .51996 L p F P
0 g
s
.59 .661 .887 r
.55222 .52265 m .54376 .51996 L .54275 .52222 L p F P
0 g
s
.855 .827 .819 r
.47727 .53525 m .47053 .54053 L .47412 .54764 L p F P
0 g
s
.88 .833 .795 r
.46842 .55418 m .47412 .54764 L .47053 .54053 L p F P
0 g
s
.966 .687 .452 r
.57886 .67583 m .57457 .66826 L .57241 .67472 L p F P
0 g
s
.966 .687 .452 r
.57241 .67472 m .57652 .68291 L .57886 .67583 L p F P
0 g
s
.68 .751 .905 r
.51902 .52027 m .52632 .51679 L .5181 .51923 L closepath p F P
0 g
s
.65 .727 .905 r
.53459 .51914 m .52632 .51679 L .5337 .52019 L closepath p F P
0 g
s
.966 .687 .452 r
.55259 .59398 m .54829 .59219 L .54913 .59721 L p F P
0 g
s
.966 .687 .452 r
.54913 .59721 m .55359 .59998 L .55259 .59398 L p F P
0 g
s
.966 .687 .452 r
.57174 .65396 m .56729 .64701 L .56595 .65303 L p F P
0 g
s
.966 .687 .452 r
.56595 .65303 m .57027 .66066 L .57174 .65396 L p F P
0 g
s
.369 .301 .649 r
.58975 .58349 m .59222 .59122 L .6005 .58224 L p F P
0 g
s
.01 w
.66781 .53774 m
.67424 .53568 L
s
.5 Mabswid
.369 .301 .649 r
.6005 .58224 m .59771 .5748 L .58975 .58349 L p F P
0 g
s
.966 .687 .452 r
.58879 .7073 m .58471 .69919 L .58134 .70626 L p F P
0 g
s
.966 .687 .452 r
.58134 .70626 m .5852 .71492 L .58879 .7073 L p F P
0 g
s
.966 .687 .452 r
.53851 .56201 m .5409 .5579 L .5382 .55249 L p F P
0 g
s
.966 .687 .452 r
.5409 .5579 m .53851 .56201 L .54063 .56677 L p F P
0 g
s
.425 .464 .797 r
.5789 .54707 m .58464 .55355 L .58843 .54565 L p F P
0 g
s
.425 .464 .797 r
.58843 .54565 m .58229 .53993 L .5789 .54707 L p F P
0 g
s
.966 .687 .452 r
.55927 .61598 m .55466 .61136 L .55471 .61662 L p F P
0 g
s
.966 .687 .452 r
.55471 .61662 m .55934 .62211 L .55927 .61598 L p F P
0 g
s
.895 .655 .567 r
.45954 .59958 m .4586 .6071 L .47051 .6149 L p F P
0 g
s
.902 .63 .515 r
.47038 .62216 m .47051 .6149 L .4586 .6071 L p F P
0 g
s
.679 .754 .908 r
.5181 .51923 m .52632 .51679 L .51757 .5181 L closepath p F P
0 g
s
.647 .728 .908 r
.53509 .518 m .52632 .51679 L .53459 .51914 L closepath p F P
0 g
s
.619 .695 .898 r
.54376 .51996 m .53509 .518 L .53459 .51914 L p F P
0 g
s
.966 .687 .452 r
.53242 .54274 m .53341 .53617 L .52989 .53124 L p F P
0 g
s
.966 .687 .452 r
.53341 .53617 m .53242 .54274 L .53537 .54742 L p F P
0 g
s
.966 .687 .452 r
.6044 .7579 m .60058 .74934 L .59525 .75743 L p F P
0 g
s
.966 .687 .452 r
.59525 .75743 m .59883 .76648 L .6044 .7579 L p F P
0 g
s
.88 .833 .795 r
.47053 .54053 m .4644 .54632 L .46842 .55418 L p F P
0 g
s
.905 .836 .767 r
.46338 .56106 m .46842 .55418 L .4644 .54632 L p F P
0 g
s
.379 .204 .513 r
.5832 .61432 m .58333 .62158 L .59504 .61366 L p F P
0 g
s
.379 .204 .513 r
.59504 .61366 m .59488 .60639 L .5832 .61432 L p F P
0 g
s
.966 .687 .452 r
.55359 .59998 m .54913 .59721 L .5497 .60207 L p F P
0 g
s
.966 .687 .452 r
.5497 .60207 m .55428 .60579 L .55359 .59998 L p F P
0 g
s
.712 .782 .907 r
.51744 .51692 m .50866 .51781 L .50893 .52015 L p F P
0 g
s
.712 .782 .907 r
.50893 .52015 m .51757 .5181 L .51744 .51692 L p F P
0 g
s
.744 .804 .9 r
.50049 .52293 m .50893 .52015 L .50866 .51781 L p F P
0 g
s
.382 .414 .769 r
.58464 .55355 m .58973 .56038 L .59388 .55183 L p F P
0 g
s
.01 w
.65623 .54145 m
.66781 .53774 L
s
.5 Mabswid
.382 .414 .769 r
.59388 .55183 m .58843 .54565 L .58464 .55355 L p F P
0 g
s
.966 .687 .452 r
.53626 .55749 m .5382 .55249 L .53537 .54742 L p F P
0 g
s
.966 .687 .452 r
.5382 .55249 m .53626 .55749 L .53851 .56201 L p F P
0 g
s
.744 .804 .9 r
.50866 .51781 m .50008 .51946 L .50049 .52293 L p F P
0 g
s
.775 .825 .892 r
.49234 .5264 m .50049 .52293 L .50008 .51946 L p F P
0 g
s
.61 .7 .908 r
.53509 .518 m .54376 .51996 L .54395 .51762 L p F P
0 g
s
.574 .667 .902 r
.54376 .51996 m .55222 .52265 L .55253 .51917 L p F P
0 g
s
.574 .667 .902 r
.55253 .51917 m .54395 .51762 L .54376 .51996 L p F P
0 g
s
.678 .757 .911 r
.51757 .5181 m .52632 .51679 L .51744 .51692 L closepath p F P
0 g
s
.644 .73 .911 r
.53518 .51682 m .52632 .51679 L .53509 .518 L closepath p F P
0 g
s
.61 .7 .908 r
.54395 .51762 m .53518 .51682 L .53509 .518 L p F P
0 g
s
.925 .753 .649 r
.45546 .57556 m .45269 .58302 L .46123 .59191 L p F P
0 g
s
.94 .738 .603 r
.45954 .59958 m .46123 .59191 L .45269 .58302 L p F P
0 g
s
.535 .631 .893 r
.55222 .52265 m .5604 .52602 L .56083 .52146 L p F P
0 g
s
.535 .631 .893 r
.56083 .52146 m .55253 .51917 L .55222 .52265 L p F P
0 g
s
.775 .825 .892 r
.50008 .51946 m .49178 .52184 L .49234 .5264 L p F P
0 g
s
.806 .845 .88 r
.48457 .53052 m .49234 .5264 L .49178 .52184 L p F P
0 g
s
.641 .74 .92 r
.53305 .51359 m .52632 .51679 L .53414 .51457 L closepath p F P
0 g
s
.642 .744 .923 r
.53164 .51278 m .52632 .51679 L .53305 .51359 L closepath p F P
0 g
s
.643 .748 .925 r
.52998 .51218 m .52632 .51679 L .53164 .51278 L closepath p F P
0 g
s
.646 .752 .926 r
.52815 .51181 m .52632 .51679 L .52998 .51218 L closepath p F P
0 g
s
.649 .756 .927 r
.52624 .5117 m .52632 .51679 L .52815 .51181 L closepath p F P
0 g
s
.01 w
.52632 .47522 m
.52632 .5117 L
s
.5 Mabswid
.653 .759 .927 r
.52432 .51183 m .52632 .51679 L .52624 .5117 L closepath p F P
0 g
s
.657 .761 .926 r
.5225 .51222 m .52632 .51679 L .52432 .51183 L closepath p F P
0 g
s
.662 .763 .925 r
.52086 .51284 m .52632 .51679 L .5225 .51222 L closepath p F P
0 g
s
.666 .763 .923 r
.51948 .51367 m .52632 .51679 L .52086 .51284 L closepath p F P
0 g
s
.67 .763 .92 r
.51842 .51465 m .52632 .51679 L .51948 .51367 L closepath p F P
0 g
s
.674 .762 .917 r
.51773 .51575 m .52632 .51679 L .51842 .51465 L closepath p F P
0 g
s
.676 .76 .914 r
.51744 .51692 m .52632 .51679 L .51773 .51575 L closepath p F P
0 g
s
.642 .733 .914 r
.53486 .51566 m .52632 .51679 L .53518 .51682 L closepath p F P
0 g
s
.641 .736 .917 r
.53414 .51457 m .52632 .51679 L .53486 .51566 L closepath p F P
0 g
s
.966 .687 .452 r
.58471 .69919 m .58062 .69106 L .57747 .69759 L p F P
0 g
s
.966 .687 .452 r
.57747 .69759 m .58134 .70626 L .58471 .69919 L p F P
0 g
s
.846 .547 .482 r
.47038 .62216 m .4709 .629 L .48515 .63503 L p F P
0 g
s
.844 .508 .418 r
.48601 .64122 m .48515 .63503 L .4709 .629 L p F P
0 g
s
.786 .465 .444 r
.48515 .63503 m .48601 .64122 L .50171 .64524 L p F P
0 g
s
.326 .239 .602 r
.59222 .59122 m .59394 .59888 L .60245 .5897 L p F P
0 g
s
.326 .239 .602 r
.60245 .5897 m .6005 .58224 L .59222 .59122 L p F P
0 g
s
.492 .592 .882 r
.5604 .52602 m .56819 .53006 L .56874 .52446 L p F P
0 g
s
.492 .592 .882 r
.56874 .52446 m .56083 .52146 L .5604 .52602 L p F P
0 g
s
.966 .687 .452 r
.60058 .74934 m .59675 .74076 L .59167 .74837 L p F P
0 g
s
.966 .687 .452 r
.59167 .74837 m .59525 .75743 L .60058 .74934 L p F P
0 g
s
.905 .836 .767 r
.4644 .54632 m .45898 .55255 L .46338 .56106 L p F P
0 g
s
.929 .838 .734 r
.45904 .56821 m .46338 .56106 L .45898 .55255 L p F P
0 g
s
.966 .687 .452 r
.57457 .66826 m .57027 .66066 L .56828 .66652 L p F P
0 g
s
.966 .687 .452 r
.56828 .66652 m .57241 .67472 L .57457 .66826 L p F P
0 g
s
.707 .791 .916 r
.50866 .51781 m .51744 .51692 L .51773 .51575 L p F P
0 g
s
.966 .687 .452 r
.5636 .63407 m .55902 .62781 L .55833 .63303 L p F P
0 g
s
.966 .687 .452 r
.55833 .63303 m .56282 .64004 L .5636 .63407 L p F P
0 g
s
.426 .167 .415 r
.56873 .6346 m .56785 .64081 L .58163 .63479 L p F P
0 g
s
.426 .167 .415 r
.58163 .63479 m .58281 .62843 L .56873 .6346 L p F P
0 g
s
.603 .707 .917 r
.53518 .51682 m .54395 .51762 L .54332 .51531 L p F P
0 g
s
.603 .707 .917 r
.54332 .51531 m .53486 .51566 L .53518 .51682 L p F P
0 g
s
.776 .417 .375 r
.50252 .65066 m .50171 .64524 L .48601 .64122 L p F P
0 g
s
.806 .845 .88 r
.49178 .52184 m .48386 .52492 L .48457 .53052 L p F P
0 g
s
.836 .864 .865 r
.47727 .53525 m .48457 .53052 L .48386 .52492 L p F P
0 g
s
.966 .687 .452 r
.55428 .60579 m .5497 .60207 L .55001 .60672 L p F P
0 g
s
.966 .687 .452 r
.55001 .60672 m .55466 .61136 L .55428 .60579 L p F P
0 g
s
.334 .356 .735 r
.58973 .56038 m .5941 .56749 L .59856 .55838 L p F P
0 g
s
.01 w
.6468 .54446 m
.65623 .54145 L
s
.5 Mabswid
.334 .356 .735 r
.59856 .55838 m .59388 .55183 L .58973 .56038 L p F P
0 g
s
.966 .687 .452 r
.55934 .62211 m .55471 .61662 L .55443 .62152 L p F P
0 g
s
.966 .687 .452 r
.55443 .62152 m .55902 .62781 L .55934 .62211 L p F P
0 g
s
.966 .687 .452 r
.52632 .51903 m .52632 .52688 L .52989 .53124 L p F P
0 g
s
.446 .548 .867 r
.56819 .53006 m .57552 .53471 L .57619 .52815 L p F P
0 g
s
.446 .548 .867 r
.57619 .52815 m .56874 .52446 L .56819 .53006 L p F P
0 g
s
.966 .687 .452 r
.53388 .55325 m .53537 .54742 L .53242 .54274 L p F P
0 g
s
.966 .687 .452 r
.53537 .54742 m .53388 .55325 L .53626 .55749 L p F P
0 g
s
.707 .791 .916 r
.51773 .51575 m .50923 .51549 L .50866 .51781 L p F P
0 g
s
.737 .821 .916 r
.50008 .51946 m .50866 .51781 L .50923 .51549 L p F P
0 g
s
.558 .676 .918 r
.54395 .51762 m .55253 .51917 L .55161 .51573 L p F P
0 g
s
.558 .676 .918 r
.55161 .51573 m .54332 .51531 L .54395 .51762 L p F P
0 g
s
.699 .798 .926 r
.50923 .51549 m .51773 .51575 L .51842 .51465 L p F P
0 g
s
.597 .716 .927 r
.53486 .51566 m .54332 .51531 L .54189 .51312 L p F P
0 g
s
.597 .716 .927 r
.54189 .51312 m .53414 .51457 L .53486 .51566 L p F P
0 g
s
.966 .687 .452 r
.52939 .53851 m .52989 .53124 L .52632 .52688 L p F P
0 g
s
.966 .687 .452 r
.52989 .53124 m .52939 .53851 L .53242 .54274 L p F P
0 g
s
.902 .63 .515 r
.4586 .6071 m .45844 .61437 L .47038 .62216 L p F P
0 g
s
.905 .596 .451 r
.4709 .629 m .47038 .62216 L .45844 .61437 L p F P
0 g
s
.966 .687 .452 r
.54078 .57801 m .54433 .57678 L .54257 .57171 L p F P
0 g
s
.966 .687 .452 r
.54433 .57678 m .54078 .57801 L .54203 .58214 L p F P
0 g
s
.966 .687 .452 r
.54203 .58214 m .54588 .58192 L .54433 .57678 L p F P
0 g
s
.966 .687 .452 r
.59675 .74076 m .59291 .73217 L .58808 .73929 L p F P
0 g
s
.966 .687 .452 r
.58808 .73929 m .59167 .74837 L .59675 .74076 L p F P
0 g
s
.966 .687 .452 r
.54588 .58192 m .54203 .58214 L .54309 .58628 L p F P
0 g
s
.966 .687 .452 r
.54309 .58628 m .54721 .58708 L .54588 .58192 L p F P
0 g
s
.836 .864 .865 r
.48386 .52492 m .47641 .52869 L .47727 .53525 L p F P
0 g
s
.866 .881 .845 r
.47053 .54053 m .47727 .53525 L .47641 .52869 L p F P
0 g
s
.01 w
.34771 .38815 m
.3649 .40691 L
s
.5 Mabswid
.966 .687 .452 r
.53937 .57394 m .54257 .57171 L .54063 .56677 L p F P
0 g
s
.966 .687 .452 r
.54257 .57171 m .53937 .57394 L .54078 .57801 L p F P
0 g
s
.966 .687 .452 r
.63081 .84738 m .62728 .83844 L .61853 .84854 L p F P
0 g
s
.966 .687 .452 r
.61853 .84854 m .6218 .85795 L .63081 .84738 L p F P
0 g
s
.966 .687 .452 r
.58062 .69106 m .57652 .68291 L .57359 .6889 L p F P
0 g
s
.966 .687 .452 r
.57359 .6889 m .57747 .69759 L .58062 .69106 L p F P
0 g
s
.737 .821 .916 r
.50923 .51549 m .5009 .51601 L .50008 .51946 L p F P
0 g
s
.768 .85 .913 r
.49178 .52184 m .50008 .51946 L .5009 .51601 L p F P
0 g
s
.94 .738 .603 r
.45269 .58302 m .45076 .5905 L .45954 .59958 L p F P
0 g
s
.952 .717 .547 r
.4586 .6071 m .45954 .59958 L .45076 .5905 L p F P
0 g
s
.334 .13 .447 r
.58333 .62158 m .58281 .62843 L .59441 .62062 L p F P
0 g
s
.334 .13 .447 r
.59441 .62062 m .59504 .61366 L .58333 .62158 L p F P
0 g
s
.688 .802 .935 r
.51059 .5133 m .51842 .51465 L .51948 .51367 L p F P
0 g
s
.699 .798 .926 r
.51842 .51465 m .51059 .5133 L .50923 .51549 L p F P
0 g
s
.929 .838 .734 r
.45898 .55255 m .45431 .55916 L .45904 .56821 L p F P
0 g
s
.951 .835 .693 r
.45546 .57556 m .45904 .56821 L .45431 .55916 L p F P
0 g
s
.594 .726 .936 r
.53414 .51457 m .54189 .51312 L .53973 .51118 L p F P
0 g
s
.594 .726 .936 r
.53973 .51118 m .53305 .51359 L .53414 .51457 L p F P
0 g
s
.966 .687 .452 r
.54721 .58708 m .54309 .58628 L .54397 .59039 L p F P
0 g
s
.966 .687 .452 r
.54397 .59039 m .54829 .59219 L .54721 .58708 L p F P
0 g
s
.393 .498 .847 r
.57552 .53471 m .58229 .53993 L .58309 .53248 L p F P
0 g
s
.393 .498 .847 r
.58309 .53248 m .57619 .52815 L .57552 .53471 L p F P
0 g
s
.508 .641 .915 r
.55253 .51917 m .56083 .52146 L .55964 .51693 L p F P
0 g
s
.508 .641 .915 r
.55964 .51693 m .55161 .51573 L .55253 .51917 L p F P
0 g
s
.966 .687 .452 r
.53781 .56997 m .54063 .56677 L .53851 .56201 L p F P
0 g
s
.966 .687 .452 r
.54063 .56677 m .53781 .56997 L .53937 .57394 L p F P
0 g
s
.273 .165 .544 r
.59394 .59888 m .59488 .60639 L .60352 .59713 L p F P
0 g
s
.273 .165 .544 r
.60352 .59713 m .60245 .5897 L .59394 .59888 L p F P
0 g
s
.966 .687 .452 r
.55466 .61136 m .55001 .60672 L .55004 .61111 L p F P
0 g
s
.966 .687 .452 r
.55004 .61111 m .55471 .61662 L .55466 .61136 L p F P
0 g
s
.279 .29 .693 r
.5941 .56749 m .59771 .5748 L .60243 .56525 L p F P
0 g
s
.01 w
.63992 .54667 m
.6468 .54446 L
s
.5 Mabswid
.279 .29 .693 r
.60243 .56525 m .59856 .55838 L .5941 .56749 L p F P
0 g
s
.966 .687 .452 r
.62728 .83844 m .62374 .82949 L .61526 .83913 L p F P
0 g
s
.966 .687 .452 r
.61526 .83913 m .61853 .84854 L .62728 .83844 L p F P
0 g
s
.725 .834 .932 r
.5009 .51601 m .50923 .51549 L .51059 .5133 L p F P
0 g
s
.675 .803 .944 r
.5127 .51133 m .51948 .51367 L .52086 .51284 L p F P
0 g
s
.688 .802 .935 r
.51948 .51367 m .5127 .51133 L .51059 .5133 L p F P
0 g
s
.966 .687 .452 r
.57027 .66066 m .56595 .65303 L .56415 .65828 L p F P
0 g
s
.966 .687 .452 r
.56415 .65828 m .56828 .66652 L .57027 .66066 L p F P
0 g
s
.595 .739 .944 r
.53305 .51359 m .53973 .51118 L .53693 .50957 L p F P
0 g
s
.595 .739 .944 r
.53693 .50957 m .53164 .51278 L .53305 .51359 L p F P
0 g
s
.966 .687 .452 r
.54829 .59219 m .54397 .59039 L .54463 .59441 L p F P
0 g
s
.966 .687 .452 r
.54463 .59441 m .54913 .59721 L .54829 .59219 L p F P
0 g
s
.545 .69 .934 r
.54332 .51531 m .55161 .51573 L .5495 .51248 L p F P
0 g
s
.545 .69 .934 r
.5495 .51248 m .54189 .51312 L .54332 .51531 L p F P
0 g
s
.966 .687 .452 r
.53142 .54935 m .53242 .54274 L .52939 .53851 L p F P
0 g
s
.966 .687 .452 r
.53242 .54274 m .53142 .54935 L .53388 .55325 L p F P
0 g
s
.966 .687 .452 r
.53611 .56615 m .53851 .56201 L .53626 .55749 L p F P
0 g
s
.966 .687 .452 r
.53851 .56201 m .53611 .56615 L .53781 .56997 L p F P
0 g
s
.966 .687 .452 r
.59291 .73217 m .58906 .72355 L .58449 .7302 L p F P
0 g
s
.966 .687 .452 r
.58449 .7302 m .58808 .73929 L .59291 .73217 L p F P
0 g
s
.866 .881 .845 r
.47641 .52869 m .46951 .53309 L .47053 .54053 L p F P
0 g
s
.896 .896 .819 r
.4644 .54632 m .47053 .54053 L .46951 .53309 L p F P
0 g
s
.01 w
.3649 .40691 m
.38401 .42776 L
s
.5 Mabswid
.768 .85 .913 r
.5009 .51601 m .49283 .5173 L .49178 .52184 L p F P
0 g
s
.799 .88 .906 r
.48386 .52492 m .49178 .52184 L .49283 .5173 L p F P
0 g
s
.66 .801 .95 r
.51545 .50969 m .52086 .51284 L .5225 .51222 L p F P
0 g
s
.675 .803 .944 r
.52086 .51284 m .51545 .50969 L .5127 .51133 L p F P
0 g
s
.598 .752 .951 r
.53164 .51278 m .53693 .50957 L .53363 .50836 L p F P
0 g
s
.598 .752 .951 r
.53363 .50836 m .52998 .51218 L .53164 .51278 L p F P
0 g
s
.451 .6 .908 r
.56083 .52146 m .56874 .52446 L .56731 .5189 L p F P
0 g
s
.451 .6 .908 r
.56731 .5189 m .55964 .51693 L .56083 .52146 L p F P
0 g
s
.966 .687 .452 r
.62374 .82949 m .6202 .82053 L .61199 .82971 L p F P
0 g
s
.966 .687 .452 r
.61199 .82971 m .61526 .83913 L .62374 .82949 L p F P
0 g
s
.333 .441 .821 r
.58229 .53993 m .58843 .54565 L .58935 .53741 L p F P
0 g
s
.333 .441 .821 r
.58935 .53741 m .58309 .53248 L .58229 .53993 L p F P
0 g
s
.844 .508 .418 r
.4709 .629 m .47205 .63535 L .48601 .64122 L p F P
0 g
s
.834 .455 .336 r
.48733 .64679 m .48601 .64122 L .47205 .63535 L p F P
0 g
s
.776 .417 .375 r
.48601 .64122 m .48733 .64679 L .50252 .65066 L p F P
0 g
s
.966 .687 .452 r
.55902 .62781 m .55443 .62152 L .55382 .62598 L p F P
0 g
s
.966 .687 .452 r
.55382 .62598 m .55833 .63303 L .55902 .62781 L p F P
0 g
s
.645 .796 .955 r
.51871 .50845 m .5225 .51222 L .52432 .51183 L p F P
0 g
s
.66 .801 .95 r
.5225 .51222 m .51871 .50845 L .51545 .50969 L p F P
0 g
s
.606 .765 .955 r
.52998 .51218 m .53363 .50836 L .52998 .50763 L p F P
0 g
s
.606 .765 .955 r
.52998 .50763 m .52815 .51181 L .52998 .51218 L p F P
0 g
s
.966 .687 .452 r
.54913 .59721 m .54463 .59441 L .54509 .59831 L p F P
0 g
s
.966 .687 .452 r
.54509 .59831 m .5497 .60207 L .54913 .59721 L p F P
0 g
s
.966 .687 .452 r
.56282 .64004 m .55833 .63303 L .55726 .63769 L p F P
0 g
s
.966 .687 .452 r
.55726 .63769 m .56161 .64538 L .56282 .64004 L p F P
0 g
s
.966 .687 .452 r
.57652 .68291 m .57241 .67472 L .5697 .68019 L p F P
0 g
s
.966 .687 .452 r
.5697 .68019 m .57359 .6889 L .57652 .68291 L p F P
0 g
s
.378 .083 .331 r
.56785 .64081 m .56648 .64639 L .5798 .64059 L p F P
0 g
s
.378 .083 .331 r
.5798 .64059 m .58163 .63479 L .56785 .64081 L p F P
0 g
s
.966 .687 .452 r
.5343 .56253 m .53626 .55749 L .53388 .55325 L p F P
0 g
s
.966 .687 .452 r
.53626 .55749 m .5343 .56253 L .53611 .56615 L p F P
0 g
s
.63 .788 .958 r
.52234 .50767 m .52432 .51183 L .52624 .5117 L p F P
0 g
s
.645 .796 .955 r
.52432 .51183 m .52234 .50767 L .51871 .50845 L p F P
0 g
s
.951 .835 .693 r
.45431 .55916 m .45047 .56606 L .45546 .57556 L p F P
0 g
s
.972 .827 .642 r
.45269 .58302 m .45546 .57556 L .45047 .56606 L p F P
0 g
s
.617 .777 .958 r
.52815 .51181 m .52998 .50763 L .52616 .50739 L p F P
0 g
s
.617 .777 .958 r
.52616 .50739 m .52624 .5117 L .52815 .51181 L p F P
0 g
s
.63 .788 .958 r
.52624 .5117 m .52616 .50739 L .52234 .50767 L p F P
0 g
s
.966 .687 .452 r
.52632 .52688 m .52632 .53478 L .52939 .53851 L p F P
0 g
s
.706 .843 .948 r
.50291 .51274 m .51059 .5133 L .5127 .51133 L p F P
0 g
s
.725 .834 .932 r
.51059 .5133 m .50291 .51274 L .5009 .51601 L p F P
0 g
s
.966 .687 .452 r
.6202 .82053 m .61665 .81155 L .60872 .82028 L p F P
0 g
s
.966 .687 .452 r
.60872 .82028 m .61199 .82971 L .6202 .82053 L p F P
0 g
s
.536 .707 .949 r
.54189 .51312 m .5495 .51248 L .54629 .50959 L p F P
0 g
s
.536 .707 .949 r
.54629 .50959 m .53973 .51118 L .54189 .51312 L p F P
0 g
s
.758 .353 .284 r
.5036 .65533 m .50252 .65066 L .48733 .64679 L p F P
0 g
s
.751 .872 .935 r
.49283 .5173 m .5009 .51601 L .50291 .51274 L p F P
0 g
s
.966 .687 .452 r
.58906 .72355 m .5852 .71492 L .58089 .7211 L p F P
0 g
s
.966 .687 .452 r
.58089 .7211 m .58449 .7302 L .58906 .72355 L p F P
0 g
s
.952 .717 .547 r
.45076 .5905 m .4497 .59793 L .4586 .6071 L p F P
0 g
s
.96 .688 .476 r
.45844 .61437 m .4586 .6071 L .4497 .59793 L p F P
0 g
s
.213 .212 .64 r
.59771 .5748 m .6005 .58224 L .60542 .57235 L p F P
0 g
s
.01 w
.63502 .54824 m
.63992 .54667 L
s
.5 Mabswid
.213 .212 .64 r
.60542 .57235 m .60243 .56525 L .59771 .5748 L p F P
0 g
s
.966 .687 .452 r
.55471 .61662 m .55004 .61111 L .5498 .61519 L p F P
0 g
s
.966 .687 .452 r
.5498 .61519 m .55443 .62152 L .55471 .61662 L p F P
0 g
s
.483 .656 .937 r
.55161 .51573 m .55964 .51693 L .55688 .51265 L p F P
0 g
s
.483 .656 .937 r
.55688 .51265 m .5495 .51248 L .55161 .51573 L p F P
0 g
s
.799 .88 .906 r
.49283 .5173 m .48513 .51935 L .48386 .52492 L p F P
0 g
s
.829 .909 .893 r
.47641 .52869 m .48386 .52492 L .48513 .51935 L p F P
0 g
s
.01 w
.38401 .42776 m
.39979 .44498 L
s
.5 Mabswid
.896 .896 .819 r
.46951 .53309 m .46324 .53809 L .4644 .54632 L p F P
0 g
s
.925 .907 .786 r
.45898 .55255 m .4644 .54632 L .46324 .53809 L p F P
0 g
s
.905 .596 .451 r
.45844 .61437 m .45907 .62132 L .4709 .629 L p F P
0 g
s
.901 .55 .368 r
.47205 .63535 m .4709 .629 L .45907 .62132 L p F P
0 g
s
.966 .687 .452 r
.52889 .54582 m .52939 .53851 L .52632 .53478 L p F P
0 g
s
.966 .687 .452 r
.52939 .53851 m .52889 .54582 L .53142 .54935 L p F P
0 g
s
.384 .55 .895 r
.56874 .52446 m .57619 .52815 L .57453 .52162 L p F P
0 g
s
.384 .55 .895 r
.57453 .52162 m .56731 .5189 L .56874 .52446 L p F P
0 g
s
.966 .687 .452 r
.5497 .60207 m .54509 .59831 L .54533 .60204 L p F P
0 g
s
.966 .687 .452 r
.54533 .60204 m .55001 .60672 L .5497 .60207 L p F P
0 g
s
.21 .077 .471 r
.59488 .60639 m .59504 .61366 L .6037 .60442 L p F P
0 g
s
.21 .077 .471 r
.6037 .60442 m .60352 .59713 L .59488 .60639 L p F P
0 g
s
.275 .038 .362 r
.58281 .62843 m .58163 .63479 L .59298 .62717 L p F P
0 g
s
.275 .038 .362 r
.59298 .62717 m .59441 .62062 L .58281 .62843 L p F P
0 g
s
.263 .372 .787 r
.58843 .54565 m .59388 .55183 L .59491 .54289 L p F P
0 g
s
.263 .372 .787 r
.59491 .54289 m .58935 .53741 L .58843 .54565 L p F P
0 g
s
.966 .687 .452 r
.61665 .81155 m .61309 .80256 L .60544 .81085 L p F P
0 g
s
.966 .687 .452 r
.60544 .81085 m .60872 .82028 L .61665 .81155 L p F P
0 g
s
.966 .687 .452 r
.53239 .55913 m .53388 .55325 L .53142 .54935 L p F P
0 g
s
.966 .687 .452 r
.53388 .55325 m .53239 .55913 L .5343 .56253 L p F P
0 g
s
.681 .846 .962 r
.50603 .50981 m .5127 .51133 L .51545 .50969 L p F P
0 g
s
.706 .843 .948 r
.5127 .51133 m .50603 .50981 L .50291 .51274 L p F P
0 g
s
.966 .687 .452 r
.57241 .67472 m .56828 .66652 L .5658 .67145 L p F P
0 g
s
.966 .687 .452 r
.5658 .67145 m .5697 .68019 L .57241 .67472 L p F P
0 g
s
.532 .727 .963 r
.53973 .51118 m .54629 .50959 L .54213 .50718 L p F P
0 g
s
.532 .727 .963 r
.54213 .50718 m .53693 .50957 L .53973 .51118 L p F P
0 g
s
.966 .687 .452 r
.5852 .71492 m .58134 .70626 L .57729 .71199 L p F P
0 g
s
.966 .687 .452 r
.57729 .71199 m .58089 .7211 L .5852 .71492 L p F P
0 g
s
.966 .687 .452 r
.61309 .80256 m .60954 .79356 L .60216 .80141 L p F P
0 g
s
.966 .687 .452 r
.60216 .80141 m .60544 .81085 L .61309 .80256 L p F P
0 g
s
.972 .827 .642 r
.45047 .56606 m .44748 .57319 L .45269 .58302 L p F P
0 g
s
.988 .811 .577 r
.45076 .5905 m .45269 .58302 L .44748 .57319 L p F P
0 g
s
.751 .872 .935 r
.50291 .51274 m .49547 .51299 L .49283 .5173 L p F P
0 g
s
.776 .91 .932 r
.48513 .51935 m .49283 .5173 L .49547 .51299 L p F P
0 g
s
.01 w
.39979 .44498 m
.40644 .45223 L
s
.5 Mabswid
.829 .909 .893 r
.48513 .51935 m .47787 .52215 L .47641 .52869 L p F P
0 g
s
.859 .936 .872 r
.46951 .53309 m .47641 .52869 L .47787 .52215 L p F P
0 g
s
.01 w
.40644 .45223 m
.41783 .46467 L
s
.5 Mabswid
.966 .687 .452 r
.55001 .60672 m .54533 .60204 L .54535 .60556 L p F P
0 g
s
.966 .687 .452 r
.54535 .60556 m .55004 .61111 L .55001 .60672 L p F P
0 g
s
.966 .687 .452 r
.53721 .57925 m .54078 .57801 L .53937 .57394 L p F P
0 g
s
.966 .687 .452 r
.54078 .57801 m .53721 .57925 L .53815 .58236 L p F P
0 g
s
.966 .687 .452 r
.53815 .58236 m .54203 .58214 L .54078 .57801 L p F P
0 g
s
.925 .907 .786 r
.46324 .53809 m .45769 .54363 L .45898 .55255 L p F P
0 g
s
.951 .914 .742 r
.45431 .55916 m .45898 .55255 L .45769 .54363 L p F P
0 g
s
.966 .687 .452 r
.55833 .63303 m .55382 .62598 L .55289 .62997 L p F P
0 g
s
.966 .687 .452 r
.55289 .62997 m .55726 .63769 L .55833 .63303 L p F P
0 g
s
.966 .687 .452 r
.54203 .58214 m .53815 .58236 L .53895 .58548 L p F P
0 g
s
.966 .687 .452 r
.53895 .58548 m .54309 .58628 L .54203 .58214 L p F P
0 g
s
.407 .613 .934 r
.55964 .51693 m .56731 .5189 L .56393 .51364 L p F P
0 g
s
.407 .613 .934 r
.56393 .51364 m .55688 .51265 L .55964 .51693 L p F P
0 g
s
.966 .687 .452 r
.53615 .57619 m .53937 .57394 L .53781 .56997 L p F P
0 g
s
.966 .687 .452 r
.53937 .57394 m .53615 .57619 L .53721 .57925 L p F P
0 g
s
.722 .886 .956 r
.49547 .51299 m .50291 .51274 L .50603 .50981 L p F P
0 g
s
.966 .687 .452 r
.53041 .556 m .53142 .54935 L .52889 .54582 L p F P
0 g
s
.966 .687 .452 r
.53142 .54935 m .53041 .556 L .53239 .55913 L p F P
0 g
s
.652 .843 .973 r
.51012 .50736 m .51545 .50969 L .51871 .50845 L p F P
0 g
s
.681 .846 .962 r
.51545 .50969 m .51012 .50736 L .50603 .50981 L p F P
0 g
s
.304 .488 .874 r
.57619 .52815 m .58309 .53248 L .58123 .52506 L p F P
0 g
s
.304 .488 .874 r
.58123 .52506 m .57453 .52162 L .57619 .52815 L p F P
0 g
s
.135 .119 .573 r
.6005 .58224 m .60245 .5897 L .60751 .5796 L p F P
0 g
s
.01 w
.63173 .54929 m
.63502 .54824 L
s
.5 Mabswid
.135 .119 .573 r
.60751 .5796 m .60542 .57235 L .6005 .58224 L p F P
0 g
s
.966 .687 .452 r
.60954 .79356 m .60597 .78455 L .59889 .79197 L p F P
0 g
s
.966 .687 .452 r
.59889 .79197 m .60216 .80141 L .60954 .79356 L p F P
0 g
s
.535 .749 .974 r
.53693 .50957 m .54213 .50718 L .53722 .50539 L p F P
0 g
s
.535 .749 .974 r
.53722 .50539 m .53363 .50836 L .53693 .50957 L p F P
0 g
s
.966 .687 .452 r
.55443 .62152 m .5498 .61519 L .54929 .61891 L p F P
0 g
s
.966 .687 .452 r
.54929 .61891 m .55382 .62598 L .55443 .62152 L p F P
0 g
s
.462 .677 .958 r
.5495 .51248 m .55688 .51265 L .55266 .50884 L p F P
0 g
s
.462 .677 .958 r
.55266 .50884 m .54629 .50959 L .5495 .51248 L p F P
0 g
s
.966 .687 .452 r
.54309 .58628 m .53895 .58548 L .5396 .58857 L p F P
0 g
s
.966 .687 .452 r
.5396 .58857 m .54397 .59039 L .54309 .58628 L p F P
0 g
s
.966 .687 .452 r
.53497 .5732 m .53781 .56997 L .53611 .56615 L p F P
0 g
s
.966 .687 .452 r
.53781 .56997 m .53497 .5732 L .53615 .57619 L p F P
0 g
s
.18 .291 .742 r
.59388 .55183 m .59856 .55838 L .59969 .54886 L p F P
0 g
s
.01 w
.62804 .55047 m
.63173 .54929 L
s
.5 Mabswid
.18 .291 .742 r
.59969 .54886 m .59491 .54289 L .59388 .55183 L p F P
0 g
s
.966 .687 .452 r
.58134 .70626 m .57747 .69759 L .57368 .70286 L p F P
0 g
s
.966 .687 .452 r
.57368 .70286 m .57729 .71199 L .58134 .70626 L p F P
0 g
s
.966 .687 .452 r
.52632 .53478 m .52632 .54272 L .52889 .54582 L p F P
0 g
s
.834 .455 .336 r
.47205 .63535 m .47385 .64113 L .48733 .64679 L p F P
0 g
s
.812 .383 .227 r
.48912 .65165 m .48733 .64679 L .47385 .64113 L p F P
0 g
s
.758 .353 .284 r
.48733 .64679 m .48912 .65165 L .5036 .65533 L p F P
0 g
s
.96 .688 .476 r
.4497 .59793 m .44952 .60522 L .45844 .61437 L p F P
0 g
s
.959 .645 .386 r
.45907 .62132 m .45844 .61437 L .44952 .60522 L p F P
0 g
s
.01 w
.45063 .60727 m
.45072 .60724 L
s
.44835 .608 m
.45063 .60727 L
s
.5 Mabswid
.966 .687 .452 r
.56161 .64538 m .55726 .63769 L .55583 .64174 L p F P
0 g
s
.966 .687 .452 r
.55583 .64174 m .55999 .65003 L .56161 .64538 L p F P
0 g
s
.966 .687 .452 r
.54397 .59039 m .5396 .58857 L .54011 .5916 L p F P
0 g
s
.966 .687 .452 r
.54011 .5916 m .54463 .59441 L .54397 .59039 L p F P
0 g
s
.966 .687 .452 r
.56828 .66652 m .56415 .65828 L .56189 .6627 L p F P
0 g
s
.966 .687 .452 r
.56189 .6627 m .5658 .67145 L .56828 .66652 L p F P
0 g
s
.966 .687 .452 r
.53369 .57033 m .53611 .56615 L .5343 .56253 L p F P
0 g
s
.966 .687 .452 r
.53611 .56615 m .53369 .57033 L .53497 .5732 L p F P
0 g
s
.621 .832 .981 r
.51498 .50551 m .51871 .50845 L .52234 .50767 L p F P
0 g
s
.652 .843 .973 r
.51871 .50845 m .51498 .50551 L .51012 .50736 L p F P
0 g
s
.313 0 .22 r
.56648 .64639 m .56464 .65127 L .57734 .64575 L p F P
0 g
s
.313 0 .22 r
.57734 .64575 m .5798 .64059 L .56648 .64639 L p F P
0 g
s
.966 .687 .452 r
.60597 .78455 m .6024 .77552 L .59561 .78253 L p F P
0 g
s
.966 .687 .452 r
.59561 .78253 m .59889 .79197 L .60597 .78455 L p F P
0 g
s
.546 .772 .982 r
.53363 .50836 m .53722 .50539 L .53178 .50428 L p F P
0 g
s
.546 .772 .982 r
.53178 .50428 m .52998 .50763 L .53363 .50836 L p F P
0 g
s
.13 0 .378 r
.59504 .61366 m .59441 .62062 L .60298 .6115 L p F P
0 g
s
.13 0 .378 r
.60298 .6115 m .6037 .60442 L .59504 .61366 L p F P
0 g
s
.901 .55 .368 r
.45907 .62132 m .46048 .62786 L .47205 .63535 L p F P
0 g
s
.886 .486 .261 r
.47385 .64113 m .47205 .63535 L .46048 .62786 L p F P
0 g
s
.591 .816 .985 r
.52039 .50435 m .52234 .50767 L .52616 .50739 L p F P
0 g
s
.621 .832 .981 r
.52234 .50767 m .52039 .50435 L .51498 .50551 L p F P
0 g
s
.966 .687 .452 r
.55004 .61111 m .54535 .60556 L .54516 .60883 L p F P
0 g
s
.966 .687 .452 r
.54516 .60883 m .5498 .61519 L .55004 .61111 L p F P
0 g
s
.565 .795 .986 r
.52998 .50763 m .53178 .50428 L .52608 .50393 L p F P
0 g
s
.565 .795 .986 r
.52608 .50393 m .52616 .50739 L .52998 .50763 L p F P
0 g
s
.966 .687 .452 r
.54463 .59441 m .54011 .5916 L .54045 .59454 L p F P
0 g
s
.966 .687 .452 r
.54045 .59454 m .54509 .59831 L .54463 .59441 L p F P
0 g
s
.859 .936 .872 r
.47787 .52215 m .47115 .52566 L .46951 .53309 L p F P
0 g
s
.887 .959 .84 r
.46324 .53809 m .46951 .53309 L .47115 .52566 L p F P
0 g
s
.01 w
.41783 .46467 m
.43032 .47829 L
s
.5 Mabswid
.591 .816 .985 r
.52616 .50739 m .52608 .50393 L .52039 .50435 L p F P
0 g
s
.966 .687 .452 r
.53233 .5676 m .5343 .56253 L .53239 .55913 L p F P
0 g
s
.966 .687 .452 r
.5343 .56253 m .53233 .5676 L .53369 .57033 L p F P
0 g
s
.198 0 .252 r
.58163 .63479 m .5798 .64059 L .59077 .63325 L p F P
0 g
s
.198 0 .252 r
.59077 .63325 m .59298 .62717 L .58163 .63479 L p F P
0 g
s
.966 .687 .452 r
.52838 .55318 m .52889 .54582 L .52632 .54272 L p F P
0 g
s
.966 .687 .452 r
.52889 .54582 m .52838 .55318 L .53041 .556 L p F P
0 g
s
.966 .687 .452 r
.57747 .69759 m .57359 .6889 L .57007 .69372 L p F P
0 g
s
.966 .687 .452 r
.57007 .69372 m .57368 .70286 L .57747 .69759 L p F P
0 g
s
.966 .687 .452 r
.6024 .77552 m .59883 .76648 L .59232 .77308 L p F P
0 g
s
.966 .687 .452 r
.59232 .77308 m .59561 .78253 L .6024 .77552 L p F P
0 g
s
.776 .91 .932 r
.49547 .51299 m .48835 .51406 L .48513 .51935 L p F P
0 g
s
.799 .947 .919 r
.47787 .52215 m .48513 .51935 L .48835 .51406 L p F P
0 g
s
.951 .914 .742 r
.45769 .54363 m .45291 .54965 L .45431 .55916 L p F P
0 g
s
.973 .914 .683 r
.45047 .56606 m .45431 .55916 L .45291 .54965 L p F P
0 g
s
.988 .811 .577 r
.44748 .57319 m .4454 .58046 L .45076 .5905 L p F P
0 g
s
.997 .784 .494 r
.4497 .59793 m .45076 .5905 L .4454 .58046 L p F P
0 g
s
.681 .891 .974 r
.49957 .50913 m .50603 .50981 L .51012 .50736 L p F P
0 g
s
.722 .886 .956 r
.50603 .50981 m .49957 .50913 L .49547 .51299 L p F P
0 g
s
.207 .411 .842 r
.58309 .53248 m .58935 .53741 L .58731 .5292 L p F P
0 g
s
.207 .411 .842 r
.58731 .5292 m .58123 .52506 L .58309 .53248 L p F P
0 g
s
.447 .702 .975 r
.54629 .50959 m .55266 .50884 L .54719 .50566 L p F P
0 g
s
.447 .702 .975 r
.54719 .50566 m .54213 .50718 L .54629 .50959 L p F P
0 g
s
.312 .555 .921 r
.56731 .5189 m .57453 .52162 L .57059 .51544 L p F P
0 g
s
.312 .555 .921 r
.57059 .51544 m .56393 .51364 L .56731 .5189 L p F P
0 g
s
.081 .191 .68 r
.59856 .55838 m .60243 .56525 L .60364 .55525 L p F P
0 g
s
.01 w
.62225 .55232 m
.62804 .55047 L
s
.5 Mabswid
.081 .191 .68 r
.60364 .55525 m .59969 .54886 L .59856 .55838 L p F P
0 g
s
.966 .687 .452 r
.54509 .59831 m .54045 .59454 L .54063 .59734 L p F P
0 g
s
.966 .687 .452 r
.54063 .59734 m .54533 .60204 L .54509 .59831 L p F P
0 g
s
.041 .006 .487 r
.60245 .5897 m .60352 .59713 L .60866 .58693 L p F P
0 g
s
.041 .006 .487 r
.60866 .58693 m .60751 .5796 L .60245 .5897 L p F P
0 g
s
.966 .687 .452 r
.59883 .76648 m .59525 .75743 L .58904 .76362 L p F P
0 g
s
.966 .687 .452 r
.58904 .76362 m .59232 .77308 L .59883 .76648 L p F P
0 g
s
.733 .929 .955 r
.48835 .51406 m .49547 .51299 L .49957 .50913 L p F P
0 g
s
.966 .687 .452 r
.55382 .62598 m .54929 .61891 L .54851 .62223 L p F P
0 g
s
.966 .687 .452 r
.54851 .62223 m .55289 .62997 L .55382 .62598 L p F P
0 g
s
.966 .687 .452 r
.53089 .56504 m .53239 .55913 L .53041 .556 L p F P
0 g
s
.966 .687 .452 r
.53239 .55913 m .53089 .56504 L .53233 .5676 L p F P
0 g
s
.364 .632 .956 r
.55688 .51265 m .56393 .51364 L .55876 .50894 L p F P
0 g
s
.364 .632 .956 r
.55876 .50894 m .55266 .50884 L .55688 .51265 L p F P
0 g
s
.966 .687 .452 r
.55726 .63769 m .55289 .62997 L .55165 .63344 L p F P
0 g
s
.966 .687 .452 r
.55165 .63344 m .55583 .64174 L .55726 .63769 L p F P
0 g
s
.966 .687 .452 r
.57359 .6889 m .5697 .68019 L .56645 .68457 L p F P
0 g
s
.966 .687 .452 r
.56645 .68457 m .57007 .69372 L .57359 .6889 L p F P
0 g
s
.966 .687 .452 r
.5498 .61519 m .54516 .60883 L .54474 .6118 L p F P
0 g
s
.966 .687 .452 r
.54474 .6118 m .54929 .61891 L .5498 .61519 L p F P
0 g
s
.966 .687 .452 r
.59525 .75743 m .59167 .74837 L .58575 .75416 L p F P
0 g
s
.966 .687 .452 r
.58575 .75416 m .58904 .76362 L .59525 .75743 L p F P
0 g
s
.966 .687 .452 r
.54533 .60204 m .54063 .59734 L .54064 .59998 L p F P
0 g
s
.966 .687 .452 r
.54064 .59998 m .54535 .60556 L .54533 .60204 L p F P
0 g
s
.959 .645 .386 r
.44952 .60522 m .45023 .61229 L .45907 .62132 L p F P
0 g
s
.943 .581 .268 r
.46048 .62786 m .45907 .62132 L .45023 .61229 L p F P
0 g
s
.966 .687 .452 r
.52632 .54272 m .52632 .5507 L .52838 .55318 L p F P
0 g
s
.631 .883 .987 r
.50495 .5059 m .51012 .50736 L .51498 .50551 L p F P
0 g
s
.681 .891 .974 r
.51012 .50736 m .50495 .5059 L .49957 .50913 L p F P
0 g
s
.887 .959 .84 r
.47115 .52566 m .46504 .52986 L .46324 .53809 L p F P
0 g
s
.909 .975 .792 r
.45769 .54363 m .46324 .53809 L .46504 .52986 L p F P
0 g
s
.01 w
.43032 .47829 m
.43925 .48804 L
s
.5 Mabswid
.443 .732 .988 r
.54213 .50718 m .54719 .50566 L .5407 .50329 L p F P
0 g
s
.443 .732 .988 r
.5407 .50329 m .53722 .50539 L .54213 .50718 L p F P
0 g
s
.966 .687 .452 r
.5294 .56269 m .53041 .556 L .52838 .55318 L p F P
0 g
s
.966 .687 .452 r
.53041 .556 m .5294 .56269 L .53089 .56504 L p F P
0 g
s
.973 .914 .683 r
.45291 .54965 m .44896 .55608 L .45047 .56606 L p F P
0 g
s
.986 .9 .603 r
.44748 .57319 m .45047 .56606 L .44896 .55608 L p F P
0 g
s
.03 0 .256 r
.59441 .62062 m .59298 .62717 L .60136 .61828 L p F P
0 g
s
.03 0 .256 r
.60136 .61828 m .60298 .6115 L .59441 .62062 L p F P
0 g
s
.799 .947 .919 r
.48835 .51406 m .48164 .51593 L .47787 .52215 L p F P
0 g
s
.817 .979 .891 r
.47115 .52566 m .47787 .52215 L .48164 .51593 L p F P
0 g
s
.01 w
.43925 .48804 m
.44142 .49041 L
s
.5 Mabswid
.09 .313 .791 r
.58935 .53741 m .59491 .54289 L .59272 .53398 L p F P
0 g
s
.09 .313 .791 r
.59272 .53398 m .58731 .5292 L .58935 .53741 L p F P
0 g
s
.966 .687 .452 r
.59167 .74837 m .58808 .73929 L .58247 .7447 L p F P
0 g
s
.966 .687 .452 r
.58247 .7447 m .58575 .75416 L .59167 .74837 L p F P
0 g
s
.966 .687 .452 r
.5697 .68019 m .5658 .67145 L .56283 .6754 L p F P
0 g
s
.966 .687 .452 r
.56283 .6754 m .56645 .68457 L .5697 .68019 L p F P
0 g
s
.966 .687 .452 r
.55999 .65003 m .55583 .64174 L .55405 .64514 L p F P
0 g
s
.966 .687 .452 r
.55405 .64514 m .55797 .65393 L .55999 .65003 L p F P
0 g
s
.812 .383 .227 r
.47385 .64113 m .47626 .64626 L .48912 .65165 L p F P
0 g
s
.766 .281 .079 r
.49135 .65574 m .48912 .65165 L .47626 .64626 L p F P
0 g
s
.722 .264 .162 r
.48912 .65165 m .49135 .65574 L .50496 .6592 L p F P
0 g
s
.997 .784 .494 r
.4454 .58046 m .44426 .58779 L .4497 .59793 L p F P
0 g
s
.991 .737 .385 r
.44952 .60522 m .4497 .59793 L .44426 .58779 L p F P
0 g
s
.192 .476 .892 r
.57453 .52162 m .58123 .52506 L .57676 .51804 L p F P
0 g
s
.192 .476 .892 r
.57676 .51804 m .57059 .51544 L .57453 .52162 L p F P
0 g
s
.966 .687 .452 r
.53361 .58051 m .53721 .57925 L .53615 .57619 L p F P
0 g
s
.966 .687 .452 r
.53721 .57925 m .53361 .58051 L .53424 .58259 L p F P
0 g
s
.966 .687 .452 r
.53424 .58259 m .53815 .58236 L .53721 .57925 L p F P
0 g
s
0 .07 .597 r
.60243 .56525 m .60542 .57235 L .6067 .562 L p F P
0 g
s
.01 w
.61812 .55365 m
.62225 .55232 L
s
.5 Mabswid
0 .07 .597 r
.6067 .562 m .60364 .55525 L .60243 .56525 L p F P
0 g
s
.966 .687 .452 r
.53815 .58236 m .53424 .58259 L .53477 .58467 L p F P
0 g
s
.966 .687 .452 r
.53477 .58467 m .53895 .58548 L .53815 .58236 L p F P
0 g
s
.966 .687 .452 r
.5329 .57845 m .53615 .57619 L .53497 .5732 L p F P
0 g
s
.966 .687 .452 r
.53615 .57619 m .5329 .57845 L .53361 .58051 L p F P
0 g
s
.221 0 .07 r
.56464 .65127 m .56234 .65539 L .57427 .65021 L p F P
0 g
s
.221 0 .07 r
.57427 .65021 m .57734 .64575 L .56464 .65127 L p F P
0 g
s
.886 .486 .261 r
.46048 .62786 m .46267 .63391 L .47385 .64113 L p F P
0 g
s
.848 .394 .118 r
.47626 .64626 m .47385 .64113 L .46267 .63391 L p F P
0 g
s
.576 .863 .996 r
.51136 .50345 m .51498 .50551 L .52039 .50435 L p F P
0 g
s
.631 .883 .987 r
.51498 .50551 m .51136 .50345 L .50495 .5059 L p F P
0 g
s
.966 .687 .452 r
.53895 .58548 m .53477 .58467 L .53521 .58674 L p F P
0 g
s
.966 .687 .452 r
.53521 .58674 m .5396 .58857 L .53895 .58548 L p F P
0 g
s
.966 .687 .452 r
.54535 .60556 m .54064 .59998 L .54048 .60243 L p F P
0 g
s
.966 .687 .452 r
.54048 .60243 m .54516 .60883 L .54535 .60556 L p F P
0 g
s
.966 .687 .452 r
.53211 .57645 m .53497 .5732 L .53369 .57033 L p F P
0 g
s
.966 .687 .452 r
.53497 .5732 m .53211 .57645 L .5329 .57845 L p F P
0 g
s
.454 .766 .996 r
.53722 .50539 m .5407 .50329 L .53353 .50183 L p F P
0 g
s
.454 .766 .996 r
.53353 .50183 m .53178 .50428 L .53722 .50539 L p F P
0 g
s
.966 .687 .452 r
.58808 .73929 m .58449 .7302 L .57918 .73523 L p F P
0 g
s
.966 .687 .452 r
.57918 .73523 m .58247 .7447 L .58808 .73929 L p F P
0 g
s
0 0 .373 r
.60352 .59713 m .6037 .60442 L .60885 .59424 L p F P
0 g
s
0 0 .373 r
.60885 .59424 m .60866 .58693 L .60352 .59713 L p F P
0 g
s
.966 .687 .452 r
.52787 .56058 m .52838 .55318 L .52632 .5507 L p F P
0 g
s
.966 .687 .452 r
.52838 .55318 m .52787 .56058 L .5294 .56269 L p F P
0 g
s
.097 0 .106 r
.5798 .64059 m .57734 .64575 L .58779 .63878 L p F P
0 g
s
.097 0 .106 r
.58779 .63878 m .59077 .63325 L .5798 .64059 L p F P
0 g
s
.668 .93 .971 r
.49338 .50931 m .49957 .50913 L .50495 .5059 L p F P
0 g
s
.733 .929 .955 r
.49957 .50913 m .49338 .50931 L .48835 .51406 L p F P
0 g
s
.966 .687 .452 r
.55289 .62997 m .54851 .62223 L .54746 .6251 L p F P
0 g
s
.966 .687 .452 r
.54746 .6251 m .55165 .63344 L .55289 .62997 L p F P
0 g
s
.966 .687 .452 r
.5396 .58857 m .53521 .58674 L .53554 .58877 L p F P
0 g
s
.966 .687 .452 r
.53554 .58877 m .54011 .5916 L .5396 .58857 L p F P
0 g
s
.966 .687 .452 r
.54929 .61891 m .54474 .6118 L .5441 .61445 L p F P
0 g
s
.966 .687 .452 r
.5441 .61445 m .54851 .62223 L .54929 .61891 L p F P
0 g
s
.966 .687 .452 r
.53125 .57453 m .53369 .57033 L .53233 .5676 L p F P
0 g
s
.966 .687 .452 r
.53369 .57033 m .53125 .57453 L .53211 .57645 L p F P
0 g
s
.735 .966 .936 r
.48164 .51593 m .48835 .51406 L .49338 .50931 L p F P
0 g
s
.01 w
.44142 .49041 m
.44186 .49088 L
s
.5 Mabswid
.328 .657 .972 r
.55266 .50884 m .55876 .50894 L .55203 .50504 L p F P
0 g
s
.328 .657 .972 r
.55203 .50504 m .54719 .50566 L .55266 .50884 L p F P
0 g
s
.524 .834 .999 r
.51849 .50192 m .52039 .50435 L .52608 .50393 L p F P
0 g
s
.576 .863 .996 r
.52039 .50435 m .51849 .50192 L .51136 .50345 L p F P
0 g
s
.234 .563 .937 r
.56393 .51364 m .57059 .51544 L .56452 .50992 L p F P
0 g
s
.234 .563 .937 r
.56452 .50992 m .55876 .50894 L .56393 .51364 L p F P
0 g
s
.966 .687 .452 r
.5658 .67145 m .56189 .6627 L .5592 .66622 L p F P
0 g
s
.966 .687 .452 r
.5592 .66622 m .56283 .6754 L .5658 .67145 L p F P
0 g
s
.482 .801 1 r
.53178 .50428 m .53353 .50183 L .526 .50137 L p F P
0 g
s
.482 .801 1 r
.526 .50137 m .52608 .50393 L .53178 .50428 L p F P
0 g
s
.966 .687 .452 r
.58449 .7302 m .58089 .7211 L .57589 .72575 L p F P
0 g
s
.966 .687 .452 r
.57589 .72575 m .57918 .73523 L .58449 .7302 L p F P
0 g
s
.966 .687 .452 r
.54011 .5916 m .53554 .58877 L .53577 .59073 L p F P
0 g
s
.966 .687 .452 r
.53577 .59073 m .54045 .59454 L .54011 .5916 L p F P
0 g
s
.656 .137 0 r
.50658 .66221 m .50496 .6592 L .49135 .65574 L p F P
0 g
s
.524 .834 .999 r
.52608 .50393 m .526 .50137 L .51849 .50192 L p F P
0 g
s
.966 .687 .452 r
.53034 .57271 m .53233 .5676 L .53089 .56504 L p F P
0 g
s
.966 .687 .452 r
.53233 .5676 m .53034 .57271 L .53125 .57453 L p F P
0 g
s
.909 .975 .792 r
.46504 .52986 m .45961 .5347 L .45769 .54363 L p F P
0 g
s
.92 .977 .72 r
.45291 .54965 m .45769 .54363 L .45961 .5347 L p F P
0 g
s
.01 w
.44186 .49088 m
.44575 .49513 L
s
.5 Mabswid
.966 .687 .452 r
.55583 .64174 m .55165 .63344 L .55011 .63633 L p F P
0 g
s
.966 .687 .452 r
.55011 .63633 m .55405 .64514 L .55583 .64174 L p F P
0 g
s
.966 .687 .452 r
.54516 .60883 m .54048 .60243 L .54016 .60466 L p F P
0 g
s
.966 .687 .452 r
.54016 .60466 m .54474 .6118 L .54516 .60883 L p F P
0 g
s
.986 .9 .603 r
.44896 .55608 m .4459 .56286 L .44748 .57319 L p F P
0 g
s
.983 .867 .496 r
.4454 .58046 m .44748 .57319 L .4459 .56286 L p F P
0 g
s
0 .19 .716 r
.59491 .54289 m .59969 .54886 L .59737 .53936 L p F P
0 g
s
0 .19 .716 r
.59737 .53936 m .59272 .53398 L .59491 .54289 L p F P
0 g
s
.966 .687 .452 r
.54045 .59454 m .53577 .59073 L .53589 .5926 L p F P
0 g
s
.966 .687 .452 r
.53589 .5926 m .54063 .59734 L .54045 .59454 L p F P
0 g
s
.966 .687 .452 r
.58089 .7211 m .57729 .71199 L .57259 .71628 L p F P
0 g
s
.966 .687 .452 r
.57259 .71628 m .57589 .72575 L .58089 .7211 L p F P
0 g
s
.817 .979 .891 r
.48164 .51593 m .47541 .5186 L .47115 .52566 L p F P
0 g
s
.822 .998 .839 r
.46504 .52986 m .47115 .52566 L .47541 .5186 L p F P
0 g
s
.01 w
.44575 .49513 m
.45107 .50093 L
s
.5 Mabswid
.966 .687 .452 r
.52632 .5507 m .52632 .55872 L .52787 .56058 L p F P
0 g
s
.966 .687 .452 r
.52938 .571 m .53089 .56504 L .5294 .56269 L p F P
0 g
s
.966 .687 .452 r
.53089 .56504 m .52938 .571 L .53034 .57271 L p F P
0 g
s
.943 .581 .268 r
.45023 .61229 m .45184 .61906 L .46048 .62786 L p F P
0 g
s
.901 .488 .115 r
.46267 .63391 m .46048 .62786 L .45184 .61906 L p F P
0 g
s
0 0 .485 r
.60542 .57235 m .60751 .5796 L .60883 .56902 L p F P
0 g
s
.01 w
.61535 .55453 m
.61812 .55365 L
s
.5 Mabswid
0 0 .485 r
.60883 .56902 m .6067 .562 L .60542 .57235 L p F P
0 g
s
.04 .368 .837 r
.58123 .52506 m .58731 .5292 L .58237 .52141 L p F P
0 g
s
.04 .368 .837 r
.58237 .52141 m .57676 .51804 L .58123 .52506 L p F P
0 g
s
.991 .737 .385 r
.44426 .58779 m .44406 .59511 L .44952 .60522 L p F P
0 g
s
.962 .664 .244 r
.45023 .61229 m .44952 .60522 L .44406 .59511 L p F P
0 g
s
0 0 .098 r
.59298 .62717 m .59077 .63325 L .59886 .62469 L p F P
0 g
s
0 0 .098 r
.59886 .62469 m .60136 .61828 L .59298 .62717 L p F P
0 g
s
.583 .91 .977 r
.5 .50532 m .50495 .5059 L .51136 .50345 L p F P
0 g
s
.668 .93 .971 r
.50495 .5059 m .5 .50532 L .49338 .50931 L p F P
0 g
s
.966 .687 .452 r
.54063 .59734 m .53589 .5926 L .53589 .59437 L p F P
0 g
s
.966 .687 .452 r
.53589 .59437 m .54064 .59998 L .54063 .59734 L p F P
0 g
s
.966 .687 .452 r
.57729 .71199 m .57368 .70286 L .5693 .70679 L p F P
0 g
s
.966 .687 .452 r
.5693 .70679 m .57259 .71628 L .57729 .71199 L p F P
0 g
s
.966 .687 .452 r
.54851 .62223 m .5441 .61445 L .54326 .61674 L p F P
0 g
s
.966 .687 .452 r
.54326 .61674 m .54746 .6251 L .54851 .62223 L p F P
0 g
s
.306 .688 .977 r
.54719 .50566 m .55203 .50504 L .54405 .50211 L p F P
0 g
s
.306 .688 .977 r
.54405 .50211 m .5407 .50329 L .54719 .50566 L p F P
0 g
s
.966 .687 .452 r
.52838 .56943 m .5294 .56269 L .52787 .56058 L p F P
0 g
s
.966 .687 .452 r
.5294 .56269 m .52838 .56943 L .52938 .571 L p F P
0 g
s
0 0 .227 r
.6037 .60442 m .60298 .6115 L .60808 .60146 L p F P
0 g
s
0 0 .227 r
.60808 .60146 m .60885 .59424 L .6037 .60442 L p F P
0 g
s
.966 .687 .452 r
.54474 .6118 m .54016 .60466 L .53968 .60664 L p F P
0 g
s
.966 .687 .452 r
.53968 .60664 m .5441 .61445 L .54474 .6118 L p F P
0 g
s
.966 .687 .452 r
.55165 .63344 m .54746 .6251 L .54617 .6275 L p F P
0 g
s
.966 .687 .452 r
.54617 .6275 m .55011 .63633 L .55165 .63344 L p F P
0 g
s
.966 .687 .452 r
.57368 .70286 m .57007 .69372 L .566 .6973 L p F P
0 g
s
.966 .687 .452 r
.566 .6973 m .5693 .70679 L .57368 .70286 L p F P
0 g
s
.966 .687 .452 r
.55797 .65393 m .55405 .64514 L .55193 .64783 L p F P
0 g
s
.966 .687 .452 r
.55193 .64783 m .55557 .65703 L .55797 .65393 L p F P
0 g
s
.735 .966 .936 r
.49338 .50931 m .48754 .51034 L .48164 .51593 L p F P
0 g
s
.716 .985 .885 r
.47541 .5186 m .48164 .51593 L .48754 .51034 L p F P
0 g
s
.01 w
.45107 .50093 m
.45364 .50373 L
s
.5 Mabswid
.848 .394 .118 r
.46267 .63391 m .46561 .6394 L .47626 .64626 L p F P
0 g
s
.771 .263 0 r
.47927 .6507 m .47626 .64626 L .46561 .6394 L p F P
0 g
s
.766 .281 .079 r
.47626 .64626 m .47927 .6507 L .49135 .65574 L p F P
0 g
s
.966 .687 .452 r
.54064 .59998 m .53589 .59437 L .53579 .596 L p F P
0 g
s
.966 .687 .452 r
.53579 .596 m .54048 .60243 L .54064 .59998 L p F P
0 g
s
.92 .977 .72 r
.45961 .5347 m .45494 .54013 L .45291 .54965 L p F P
0 g
s
.91 .954 .616 r
.44896 .55608 m .45291 .54965 L .45494 .54013 L p F P
0 g
s
.678 .134 0 r
.494 .65902 m .49135 .65574 L .47927 .6507 L p F P
0 g
s
.656 .137 0 r
.49135 .65574 m .494 .65902 L .50658 .66221 L p F P
0 g
s
.966 .687 .452 r
.52735 .56802 m .52787 .56058 L .52632 .55872 L p F P
0 g
s
.966 .687 .452 r
.52787 .56058 m .52735 .56802 L .52838 .56943 L p F P
0 g
s
.629 .952 .934 r
.48754 .51034 m .49338 .50931 L .5 .50532 L p F P
0 g
s
.062 .459 .883 r
.57059 .51544 m .57676 .51804 L .56986 .51175 L p F P
0 g
s
.062 .459 .883 r
.56986 .51175 m .56452 .50992 L .57059 .51544 L p F P
0 g
s
.091 0 0 r
.56234 .65539 m .55961 .65869 L .57062 .65392 L p F P
0 g
s
.091 0 0 r
.57062 .65392 m .57427 .65021 L .56234 .65539 L p F P
0 g
s
0 0 0 r
.57734 .64575 m .57427 .65021 L .58408 .64368 L p F P
0 g
s
0 0 0 r
.58408 .64368 m .58779 .63878 L .57734 .64575 L p F P
0 g
s
.16 .575 .933 r
.55876 .50894 m .56452 .50992 L .5566 .50531 L p F P
0 g
s
.16 .575 .933 r
.5566 .50531 m .55203 .50504 L .55876 .50894 L p F P
0 g
s
0 .036 .605 r
.59969 .54886 m .60364 .55525 L .60122 .54527 L p F P
0 g
s
.01 w
.61291 .55532 m
.61535 .55453 L
s
.5 Mabswid
0 .036 .605 r
.60122 .54527 m .59737 .53936 L .59969 .54886 L p F P
0 g
s
.983 .867 .496 r
.4459 .56286 m .44376 .5699 L .4454 .58046 L p F P
0 g
s
.951 .802 .354 r
.44426 .58779 m .4454 .58046 L .44376 .5699 L p F P
0 g
s
.491 .871 .976 r
.50789 .50231 m .51136 .50345 L .51849 .50192 L p F P
0 g
s
.583 .91 .977 r
.51136 .50345 m .50789 .50231 L .5 .50532 L p F P
0 g
s
.966 .687 .452 r
.57007 .69372 m .56645 .68457 L .5627 .68781 L p F P
0 g
s
.966 .687 .452 r
.5627 .68781 m .566 .6973 L .57007 .69372 L p F P
0 g
s
.31 .726 .976 r
.5407 .50329 m .54405 .50211 L .53521 .50031 L p F P
0 g
s
.31 .726 .976 r
.53521 .50031 m .53353 .50183 L .5407 .50329 L p F P
0 g
s
.822 .998 .839 r
.47541 .5186 m .46974 .52203 L .46504 .52986 L p F P
0 g
s
.804 .992 .75 r
.45961 .5347 m .46504 .52986 L .46974 .52203 L p F P
0 g
s
.01 w
.45364 .50373 m
.45799 .50848 L
s
.5 Mabswid
.966 .687 .452 r
.52998 .58177 m .53361 .58051 L .5329 .57845 L p F P
0 g
s
.966 .687 .452 r
.53361 .58051 m .52998 .58177 L .53029 .58281 L p F P
0 g
s
.966 .687 .452 r
.53029 .58281 m .53424 .58259 L .53361 .58051 L p F P
0 g
s
.966 .687 .452 r
.53424 .58259 m .53029 .58281 L .53056 .58386 L p F P
0 g
s
.966 .687 .452 r
.53056 .58386 m .53477 .58467 L .53424 .58259 L p F P
0 g
s
.966 .687 .452 r
.52962 .58074 m .5329 .57845 L .53211 .57645 L p F P
0 g
s
.966 .687 .452 r
.5329 .57845 m .52962 .58074 L .52998 .58177 L p F P
0 g
s
.966 .687 .452 r
.54048 .60243 m .53579 .596 L .53557 .59749 L p F P
0 g
s
.966 .687 .452 r
.53557 .59749 m .54016 .60466 L .54048 .60243 L p F P
0 g
s
.966 .687 .452 r
.53477 .58467 m .53056 .58386 L .53078 .5849 L p F P
0 g
s
.966 .687 .452 r
.53078 .5849 m .53521 .58674 L .53477 .58467 L p F P
0 g
s
0 0 .336 r
.60751 .5796 m .60866 .58693 L .61001 .57625 L p F P
0 g
s
0 0 .336 r
.61001 .57625 m .60883 .56902 L .60751 .5796 L p F P
0 g
s
.966 .687 .452 r
.52922 .57973 m .53211 .57645 L .53125 .57453 L p F P
0 g
s
.966 .687 .452 r
.53211 .57645 m .52922 .57973 L .52962 .58074 L p F P
0 g
s
.966 .687 .452 r
.55405 .64514 m .55011 .63633 L .54828 .63861 L p F P
0 g
s
.966 .687 .452 r
.54828 .63861 m .55193 .64783 L .55405 .64514 L p F P
0 g
s
.966 .687 .452 r
.52632 .55872 m .52632 .56678 L .52735 .56802 L p F P
0 g
s
0 .224 .743 r
.58731 .5292 m .59272 .53398 L .58736 .52552 L p F P
0 g
s
0 .224 .743 r
.58736 .52552 m .58237 .52141 L .58731 .5292 L p F P
0 g
s
.966 .687 .452 r
.5441 .61445 m .53968 .60664 L .53904 .60835 L p F P
0 g
s
.966 .687 .452 r
.53904 .60835 m .54326 .61674 L .5441 .61445 L p F P
0 g
s
.966 .687 .452 r
.53521 .58674 m .53078 .5849 L .53095 .58591 L p F P
0 g
s
.966 .687 .452 r
.53095 .58591 m .53554 .58877 L .53521 .58674 L p F P
0 g
s
.966 .687 .452 r
.54746 .6251 m .54326 .61674 L .54222 .61865 L p F P
0 g
s
.966 .687 .452 r
.54222 .61865 m .54617 .6275 L .54746 .6251 L p F P
0 g
s
.966 .687 .452 r
.52879 .57877 m .53125 .57453 L .53034 .57271 L p F P
0 g
s
.966 .687 .452 r
.53125 .57453 m .52879 .57877 L .52922 .57973 L p F P
0 g
s
.966 .687 .452 r
.56645 .68457 m .56283 .6754 L .55941 .67831 L p F P
0 g
s
.966 .687 .452 r
.55941 .67831 m .5627 .68781 L .56645 .68457 L p F P
0 g
s
.901 .488 .115 r
.45184 .61906 m .45432 .62543 L .46267 .63391 L p F P
0 g
s
.815 .355 0 r
.46561 .6394 m .46267 .63391 L .45432 .62543 L p F P
0 g
s
.406 .822 .973 r
.51667 .50042 m .51849 .50192 L .526 .50137 L p F P
0 g
s
.491 .871 .976 r
.51849 .50192 m .51667 .50042 L .50789 .50231 L p F P
0 g
s
.962 .664 .244 r
.44406 .59511 m .44483 .60231 L .45023 .61229 L p F P
0 g
s
.893 .553 .066 r
.45184 .61906 m .45023 .61229 L .44483 .60231 L p F P
0 g
s
.966 .687 .452 r
.6218 .85795 m .61853 .84854 L .60849 .85577 L p F P
0 g
s
.966 .687 .452 r
.60849 .85577 m .61144 .86556 L .6218 .85795 L p F P
0 g
s
.343 .771 .973 r
.53353 .50183 m .53521 .50031 L .52593 .49974 L p F P
0 g
s
.343 .771 .973 r
.52593 .49974 m .526 .50137 L .53353 .50183 L p F P
0 g
s
.966 .687 .452 r
.53554 .58877 m .53095 .58591 L .53106 .5869 L p F P
0 g
s
.966 .687 .452 r
.53106 .5869 m .53577 .59073 L .53554 .58877 L p F P
0 g
s
.535 0 0 r
.50844 .66432 m .50658 .66221 L .494 .65902 L p F P
0 g
s
.966 .687 .452 r
.52833 .57785 m .53034 .57271 L .52938 .571 L p F P
0 g
s
.966 .687 .452 r
.53034 .57271 m .52833 .57785 L .52879 .57877 L p F P
0 g
s
.966 .687 .452 r
.61853 .84854 m .61526 .83913 L .60554 .84598 L p F P
0 g
s
.966 .687 .452 r
.60554 .84598 m .60849 .85577 L .61853 .84854 L p F P
0 g
s
.406 .822 .973 r
.526 .50137 m .52593 .49974 L .51667 .50042 L p F P
0 g
s
0 0 0 r
.59077 .63325 m .58779 .63878 L .59549 .63064 L p F P
0 g
s
0 0 0 r
.59549 .63064 m .59886 .62469 L .59077 .63325 L p F P
0 g
s
0 0 .043 r
.60298 .6115 m .60136 .61828 L .60635 .6085 L p F P
0 g
s
0 0 .043 r
.60635 .6085 m .60808 .60146 L .60298 .6115 L p F P
0 g
s
.966 .687 .452 r
.53577 .59073 m .53106 .5869 L .53112 .58784 L p F P
0 g
s
.966 .687 .452 r
.53112 .58784 m .53589 .5926 L .53577 .59073 L p F P
0 g
s
.966 .687 .452 r
.61526 .83913 m .61199 .82971 L .60259 .83619 L p F P
0 g
s
.966 .687 .452 r
.60259 .83619 m .60554 .84598 L .61526 .83913 L p F P
0 g
s
.966 .687 .452 r
.56283 .6754 m .5592 .66622 L .5561 .6688 L p F P
0 g
s
.966 .687 .452 r
.5561 .6688 m .55941 .67831 L .56283 .6754 L p F P
0 g
s
.966 .687 .452 r
.54016 .60466 m .53557 .59749 L .53524 .59881 L p F P
0 g
s
.966 .687 .452 r
.53524 .59881 m .53968 .60664 L .54016 .60466 L p F P
0 g
s
.966 .687 .452 r
.52785 .577 m .52938 .571 L .52838 .56943 L p F P
0 g
s
.966 .687 .452 r
.52938 .571 m .52785 .577 L .52833 .57785 L p F P
0 g
s
.966 .687 .452 r
.55011 .63633 m .54617 .6275 L .54464 .62938 L p F P
0 g
s
.966 .687 .452 r
.54464 .62938 m .54828 .63861 L .55011 .63633 L p F P
0 g
s
.91 .954 .616 r
.45494 .54013 m .45108 .54608 L .44896 .55608 L p F P
0 g
s
.866 .893 .47 r
.4459 .56286 m .44896 .55608 L .45108 .54608 L p F P
0 g
s
.966 .687 .452 r
.61199 .82971 m .60872 .82028 L .59964 .82641 L p F P
0 g
s
.966 .687 .452 r
.59964 .82641 m .60259 .83619 L .61199 .82971 L p F P
0 g
s
.966 .687 .452 r
.53589 .5926 m .53112 .58784 L .53112 .58872 L p F P
0 g
s
.966 .687 .452 r
.53112 .58872 m .53589 .59437 L .53589 .5926 L p F P
0 g
s
.49 .899 .912 r
.49532 .50565 m .5 .50532 L .50789 .50231 L p F P
0 g
s
.629 .952 .934 r
.5 .50532 m .49532 .50565 L .48754 .51034 L p F P
0 g
s
.966 .687 .452 r
.60872 .82028 m .60544 .81085 L .59669 .81663 L p F P
0 g
s
.966 .687 .452 r
.59669 .81663 m .59964 .82641 L .60872 .82028 L p F P
0 g
s
.966 .687 .452 r
.52735 .57621 m .52838 .56943 L .52735 .56802 L p F P
0 g
s
.966 .687 .452 r
.52838 .56943 m .52735 .57621 L .52785 .577 L p F P
0 g
s
.716 .985 .885 r
.48754 .51034 m .48212 .51223 L .47541 .5186 L p F P
0 g
s
.66 .965 .782 r
.46974 .52203 m .47541 .5186 L .48212 .51223 L p F P
0 g
s
.01 w
.45799 .50848 m
.46184 .51268 L
s
.5 Mabswid
.107 .591 .909 r
.55203 .50504 m .5566 .50531 L .54721 .50187 L p F P
0 g
s
.107 .591 .909 r
.54721 .50187 m .54405 .50211 L .55203 .50504 L p F P
0 g
s
0 0 .452 r
.60364 .55525 m .6067 .562 L .6042 .55167 L p F P
0 g
s
.01 w
.60919 .55651 m
.61291 .55532 L
s
.5 Mabswid
0 0 .452 r
.6042 .55167 m .60122 .54527 L .60364 .55525 L p F P
0 g
s
.966 .687 .452 r
.60544 .81085 m .60216 .80141 L .59375 .80686 L p F P
0 g
s
.966 .687 .452 r
.59375 .80686 m .59669 .81663 L .60544 .81085 L p F P
0 g
s
.951 .802 .354 r
.44376 .5699 m .44259 .57713 L .44426 .58779 L p F P
0 g
s
.879 .697 .176 r
.44406 .59511 m .44426 .58779 L .44259 .57713 L p F P
0 g
s
.966 .687 .452 r
.54326 .61674 m .53904 .60835 L .53825 .60977 L p F P
0 g
s
.966 .687 .452 r
.53825 .60977 m .54222 .61865 L .54326 .61674 L p F P
0 g
s
0 .307 .774 r
.57676 .51804 m .58237 .52141 L .57473 .51443 L p F P
0 g
s
0 .307 .774 r
.57473 .51443 m .56986 .51175 L .57676 .51804 L p F P
0 g
s
.966 .687 .452 r
.53589 .59437 m .53112 .58872 L .53106 .58954 L p F P
0 g
s
.966 .687 .452 r
.53106 .58954 m .53579 .596 L .53589 .59437 L p F P
0 g
s
.966 .687 .452 r
.60216 .80141 m .59889 .79197 L .59081 .79709 L p F P
0 g
s
.966 .687 .452 r
.59081 .79709 m .59375 .80686 L .60216 .80141 L p F P
0 g
s
.966 .687 .452 r
.52684 .57551 m .52735 .56802 L .52632 .56678 L p F P
0 g
s
.966 .687 .452 r
.52735 .56802 m .52684 .57551 L .52735 .57621 L p F P
0 g
s
.966 .687 .452 r
.53968 .60664 m .53524 .59881 L .53481 .59994 L p F P
0 g
s
.966 .687 .452 r
.53481 .59994 m .53904 .60835 L .53968 .60664 L p F P
0 g
s
.804 .992 .75 r
.46974 .52203 m .46471 .52619 L .45961 .5347 L p F P
0 g
s
.748 .941 .61 r
.45494 .54013 m .45961 .5347 L .46471 .52619 L p F P
0 g
s
.01 w
.46184 .51268 m
.46304 .51399 L
s
.5 Mabswid
.545 .928 .837 r
.48212 .51223 m .48754 .51034 L .49532 .50565 L p F P
0 g
s
.771 .263 0 r
.46561 .6394 m .46927 .64426 L .47927 .6507 L p F P
0 g
s
.634 .083 0 r
.48285 .65437 m .47927 .6507 L .46927 .64426 L p F P
0 g
s
.678 .134 0 r
.47927 .6507 m .48285 .65437 L .494 .65902 L p F P
0 g
s
.966 .687 .452 r
.59889 .79197 m .59561 .78253 L .58786 .78732 L p F P
0 g
s
.966 .687 .452 r
.58786 .78732 m .59081 .79709 L .59889 .79197 L p F P
0 g
s
0 0 .152 r
.60866 .58693 m .60885 .59424 L .61021 .58358 L p F P
0 g
s
0 0 .152 r
.61021 .58358 m .61001 .57625 L .60866 .58693 L p F P
0 g
s
.966 .687 .452 r
.54617 .6275 m .54222 .61865 L .54098 .62014 L p F P
0 g
s
.966 .687 .452 r
.54098 .62014 m .54464 .62938 L .54617 .6275 L p F P
0 g
s
.966 .687 .452 r
.55557 .65703 m .55193 .64783 L .5495 .64978 L p F P
0 g
s
.966 .687 .452 r
.5495 .64978 m .5528 .65929 L .55557 .65703 L p F P
0 g
s
0 .437 .831 r
.56452 .50992 m .56986 .51175 L .56085 .50651 L p F P
0 g
s
0 .437 .831 r
.56085 .50651 m .5566 .50531 L .56452 .50992 L p F P
0 g
s
0 0 0 r
.57427 .65021 m .57062 .65392 L .57966 .6479 L p F P
0 g
s
0 0 0 r
.57966 .6479 m .58408 .64368 L .57427 .65021 L p F P
0 g
s
.966 .687 .452 r
.59561 .78253 m .59232 .77308 L .58492 .77756 L p F P
0 g
s
.966 .687 .452 r
.58492 .77756 m .58786 .78732 L .59561 .78253 L p F P
0 g
s
0 .043 .596 r
.59272 .53398 m .59737 .53936 L .59167 .53033 L p F P
0 g
s
0 .043 .596 r
.59167 .53033 m .58736 .52552 L .59272 .53398 L p F P
0 g
s
.523 0 0 r
.49706 .66143 m .494 .65902 L .48285 .65437 L p F P
0 g
s
.535 0 0 r
.494 .65902 m .49706 .66143 L .50844 .66432 L p F P
0 g
s
.966 .687 .452 r
.53579 .596 m .53106 .58954 L .53095 .59028 L p F P
0 g
s
.966 .687 .452 r
.53095 .59028 m .53557 .59749 L .53579 .596 L p F P
0 g
s
.966 .687 .452 r
.52632 .56678 m .52632 .57489 L .52684 .57551 L p F P
0 g
s
.966 .687 .452 r
.59232 .77308 m .58904 .76362 L .58198 .7678 L p F P
0 g
s
.966 .687 .452 r
.58198 .7678 m .58492 .77756 L .59232 .77308 L p F P
0 g
s
0 0 0 r
.55961 .65869 m .55646 .66113 L .56642 .65682 L p F P
0 g
s
0 0 0 r
.56642 .65682 m .57062 .65392 L .55961 .65869 L p F P
0 g
s
.893 .553 .066 r
.44483 .60231 m .44656 .60933 L .45184 .61906 L p F P
0 g
s
.773 .398 0 r
.45432 .62543 m .45184 .61906 L .44656 .60933 L p F P
0 g
s
.966 .687 .452 r
.58904 .76362 m .58575 .75416 L .57904 .75804 L p F P
0 g
s
.966 .687 .452 r
.57904 .75804 m .58198 .7678 L .58904 .76362 L p F P
0 g
s
.966 .687 .452 r
.55193 .64783 m .54828 .63861 L .54619 .64026 L p F P
0 g
s
.966 .687 .452 r
.54619 .64026 m .5495 .64978 L .55193 .64783 L p F P
0 g
s
.343 .819 .879 r
.5046 .5021 m .50789 .50231 L .51667 .50042 L p F P
0 g
s
.49 .899 .912 r
.50789 .50231 m .5046 .5021 L .49532 .50565 L p F P
0 g
s
.815 .355 0 r
.45432 .62543 m .45766 .63135 L .46561 .6394 L p F P
0 g
s
.67 .176 0 r
.46927 .64426 m .46561 .6394 L .45766 .63135 L p F P
0 g
s
.095 .619 .877 r
.54405 .50211 m .54721 .50187 L .53679 .49975 L p F P
0 g
s
.095 .619 .877 r
.53679 .49975 m .53521 .50031 L .54405 .50211 L p F P
0 g
s
.966 .687 .452 r
.58575 .75416 m .58247 .7447 L .5761 .74829 L p F P
0 g
s
.966 .687 .452 r
.5761 .74829 m .57904 .75804 L .58575 .75416 L p F P
0 g
s
.966 .687 .452 r
.53557 .59749 m .53095 .59028 L .53079 .59094 L p F P
0 g
s
.966 .687 .452 r
.53079 .59094 m .53524 .59881 L .53557 .59749 L p F P
0 g
s
.966 .687 .452 r
.53904 .60835 m .53481 .59994 L .53428 .60088 L p F P
0 g
s
.966 .687 .452 r
.53428 .60088 m .53825 .60977 L .53904 .60835 L p F P
0 g
s
.966 .687 .452 r
.54222 .61865 m .53825 .60977 L .53732 .61088 L p F P
0 g
s
.966 .687 .452 r
.53732 .61088 m .54098 .62014 L .54222 .61865 L p F P
0 g
s
0 0 0 r
.60136 .61828 m .59886 .62469 L .60366 .61527 L p F P
0 g
s
0 0 0 r
.60366 .61527 m .60635 .6085 L .60136 .61828 L p F P
0 g
s
.866 .893 .47 r
.45108 .54608 m .44808 .5525 L .4459 .56286 L p F P
0 g
s
.776 .783 .283 r
.44376 .5699 m .4459 .56286 L .44808 .5525 L p F P
0 g
s
.317 0 0 r
.52128 .66676 m .52061 .66576 L .50844 .66432 L p F P
0 g
s
.966 .687 .452 r
.58247 .7447 m .57918 .73523 L .57317 .73854 L p F P
0 g
s
.966 .687 .452 r
.57317 .73854 m .5761 .74829 L .58247 .7447 L p F P
0 g
s
0 0 0 r
.58779 .63878 m .58408 .64368 L .59129 .63606 L p F P
0 g
s
0 0 0 r
.59129 .63606 m .59549 .63064 L .58779 .63878 L p F P
0 g
s
.966 .687 .452 r
.54828 .63861 m .54464 .62938 L .54288 .63074 L p F P
0 g
s
.966 .687 .452 r
.54288 .63074 m .54619 .64026 L .54828 .63861 L p F P
0 g
s
.966 .687 .452 r
.57918 .73523 m .57589 .72575 L .57023 .72879 L p F P
0 g
s
.966 .687 .452 r
.57023 .72879 m .57317 .73854 L .57918 .73523 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52998 .58177 L .52962 .58074 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53029 .58281 L .52998 .58177 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53056 .58386 L .53029 .58281 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52962 .58074 L .52922 .57973 L closepath p F P
0 g
s
0 0 .259 r
.6067 .562 m .60883 .56902 L .60628 .55846 L p F P
0 g
s
0 0 .259 r
.60628 .55846 m .6042 .55167 L .6067 .562 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53078 .5849 L .53056 .58386 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52922 .57973 L .52879 .57877 L closepath p F P
0 g
s
.966 .687 .452 r
.53524 .59881 m .53079 .59094 L .53057 .5915 L p F P
0 g
s
.966 .687 .452 r
.53057 .5915 m .53481 .59994 L .53524 .59881 L p F P
0 g
s
.966 .687 .452 r
.57589 .72575 m .57259 .71628 L .56729 .71905 L p F P
0 g
s
.966 .687 .452 r
.56729 .71905 m .57023 .72879 L .57589 .72575 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53095 .58591 L .53078 .5849 L closepath p F P
0 g
s
.879 .697 .176 r
.44259 .57713 m .44239 .58447 L .44406 .59511 L p F P
0 g
s
.756 .546 0 r
.44483 .60231 m .44406 .59511 L .44239 .58447 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52879 .57877 L .52833 .57785 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53106 .5869 L .53095 .58591 L closepath p F P
0 g
s
.217 .736 .856 r
.51495 .49987 m .51667 .50042 L .52593 .49974 L p F P
0 g
s
.343 .819 .879 r
.51667 .50042 m .51495 .49987 L .5046 .5021 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52833 .57785 L .52785 .577 L closepath p F P
0 g
s
.66 .965 .782 r
.48212 .51223 m .47718 .51497 L .46974 .52203 L p F P
0 g
s
.553 .88 .612 r
.46471 .52619 m .46974 .52203 L .47718 .51497 L p F P
0 g
s
.131 .667 .855 r
.53521 .50031 m .53679 .49975 L .52586 .49907 L p F P
0 g
s
.131 .667 .855 r
.52586 .49907 m .52593 .49974 L .53521 .50031 L p F P
0 g
s
.966 .687 .452 r
.57259 .71628 m .5693 .70679 L .56436 .70931 L p F P
0 g
s
.966 .687 .452 r
.56436 .70931 m .56729 .71905 L .57259 .71628 L p F P
0 g
s
.337 0 0 r
.51053 .66548 m .50844 .66432 L .49706 .66143 L p F P
0 g
s
.317 0 0 r
.50844 .66432 m .51053 .66548 L .52128 .66676 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53112 .58784 L .53106 .5869 L closepath p F P
0 g
s
.966 .687 .452 r
.54464 .62938 m .54098 .62014 L .53957 .62121 L p F P
0 g
s
.966 .687 .452 r
.53957 .62121 m .54288 .63074 L .54464 .62938 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52785 .577 L .52735 .57621 L closepath p F P
0 g
s
.966 .687 .452 r
.53825 .60977 m .53428 .60088 L .53366 .60162 L p F P
0 g
s
.966 .687 .452 r
.53366 .60162 m .53732 .61088 L .53825 .60977 L p F P
0 g
s
.748 .941 .61 r
.46471 .52619 m .46037 .53105 L .45494 .54013 L p F P
0 g
s
.642 .83 .419 r
.45108 .54608 m .45494 .54013 L .46037 .53105 L p F P
0 g
s
.966 .687 .452 r
.5693 .70679 m .566 .6973 L .56143 .69958 L p F P
0 g
s
.966 .687 .452 r
.56143 .69958 m .56436 .70931 L .5693 .70679 L p F P
0 g
s
0 0 0 r
.60885 .59424 m .60808 .60146 L .60942 .59095 L p F P
0 g
s
0 0 0 r
.60942 .59095 m .61021 .58358 L .60885 .59424 L p F P
0 g
s
.217 .736 .856 r
.52593 .49974 m .52586 .49907 L .51495 .49987 L p F P
0 g
s
0 .109 .596 r
.58237 .52141 m .58736 .52552 L .57906 .51794 L p F P
0 g
s
0 .109 .596 r
.57906 .51794 m .57473 .51443 L .58237 .52141 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53112 .58872 L .53112 .58784 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52735 .57621 L .52684 .57551 L closepath p F P
0 g
s
.966 .687 .452 r
.566 .6973 m .5627 .68781 L .5585 .68985 L p F P
0 g
s
.966 .687 .452 r
.5585 .68985 m .56143 .69958 L .566 .6973 L p F P
0 g
s
.332 .809 .753 r
.49097 .50689 m .49532 .50565 L .5046 .5021 L p F P
0 g
s
.545 .928 .837 r
.49532 .50565 m .49097 .50689 L .48212 .51223 L p F P
0 g
s
.966 .687 .452 r
.53481 .59994 m .53057 .5915 L .5303 .59197 L p F P
0 g
s
.966 .687 .452 r
.5303 .59197 m .53428 .60088 L .53481 .59994 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53106 .58954 L .53112 .58872 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52684 .57551 L .52632 .57489 L closepath p F P
0 g
s
0 0 .397 r
.59737 .53936 m .60122 .54527 L .59522 .53579 L p F P
0 g
s
0 0 .397 r
.59522 .53579 m .59167 .53033 L .59737 .53936 L p F P
0 g
s
0 .42 .746 r
.5566 .50531 m .56085 .50651 L .55015 .50258 L p F P
0 g
s
0 .42 .746 r
.55015 .50258 m .54721 .50187 L .5566 .50531 L p F P
0 g
s
.966 .687 .452 r
.5627 .68781 m .55941 .67831 L .55556 .68012 L p F P
0 g
s
.966 .687 .452 r
.55556 .68012 m .5585 .68985 L .5627 .68781 L p F P
0 g
s
.966 .687 .452 r
.54098 .62014 m .53732 .61088 L .53626 .61167 L p F P
0 g
s
.966 .687 .452 r
.53626 .61167 m .53957 .62121 L .54098 .62014 L p F P
0 g
s
.403 .826 .655 r
.47718 .51497 m .48212 .51223 L .49097 .50689 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53095 .59028 L .53106 .58954 L closepath p F P
0 g
s
.966 .687 .452 r
.55941 .67831 m .5561 .6688 L .55263 .67039 L p F P
0 g
s
.966 .687 .452 r
.55263 .67039 m .55556 .68012 L .55941 .67831 L p F P
0 g
s
.634 .083 0 r
.46927 .64426 m .47363 .64844 L .48285 .65437 L p F P
0 g
s
.426 0 0 r
.48697 .65722 m .48285 .65437 L .47363 .64844 L p F P
0 g
s
.523 0 0 r
.48285 .65437 m .48697 .65722 L .49706 .66143 L p F P
0 g
s
0 .238 .642 r
.56986 .51175 m .57473 .51443 L .56473 .50861 L p F P
0 g
s
0 .238 .642 r
.56473 .50861 m .56085 .50651 L .56986 .51175 L p F P
0 g
s
.773 .398 0 r
.44656 .60933 m .44924 .61607 L .45432 .62543 L p F P
0 g
s
0 0 .362 r
.45766 .63135 m .45432 .62543 L .44924 .61607 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53079 .59094 L .53095 .59028 L closepath p F P
0 g
s
.966 .687 .452 r
.53428 .60088 m .5303 .59197 L .52999 .59233 L p F P
0 g
s
.966 .687 .452 r
.52999 .59233 m .53366 .60162 L .53428 .60088 L p F P
0 g
s
0 0 0 r
.57062 .65392 m .56642 .65682 L .57459 .65139 L p F P
0 g
s
0 0 0 r
.57459 .65139 m .57966 .6479 L .57062 .65392 L p F P
0 g
s
.776 .783 .283 r
.44808 .5525 m .44599 .55932 L .44376 .5699 L p F P
0 g
s
0 0 0 r
.44259 .57713 m .44376 .5699 L .44599 .55932 L p F P
0 g
s
.966 .687 .452 r
.53732 .61088 m .53366 .60162 L .53295 .60213 L p F P
0 g
s
.966 .687 .452 r
.53295 .60213 m .53626 .61167 L .53732 .61088 L p F P
0 g
s
.966 .687 .452 r
.5528 .65929 m .5495 .64978 L .54678 .65096 L p F P
0 g
s
.966 .687 .452 r
.54678 .65096 m .54971 .66067 L .5528 .65929 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .53057 .5915 L .53079 .59094 L closepath p F P
0 g
s
.669 .821 .385 r
.59886 .62469 m .59549 .63064 L .60005 .62169 L p F P
0 g
s
.669 .821 .385 r
.60005 .62169 m .60366 .61527 L .59886 .62469 L p F P
0 g
s
.966 .687 .452 r
.5495 .64978 m .54619 .64026 L .54385 .64124 L p F P
0 g
s
.966 .687 .452 r
.54385 .64124 m .54678 .65096 L .5495 .64978 L p F P
0 g
s
.292 0 0 r
.50047 .66294 m .49706 .66143 L .48697 .65722 L p F P
0 g
s
.337 0 0 r
.49706 .66143 m .50047 .66294 L .51053 .66548 L p F P
0 g
s
.67 .176 0 r
.45766 .63135 m .46183 .63672 L .46927 .64426 L p F P
0 g
s
0 .031 .534 r
.47363 .64844 m .46927 .64426 L .46183 .63672 L p F P
0 g
s
.776 .527 0 r
.60883 .56902 m .61001 .57625 L .60743 .56557 L p F P
0 g
s
.776 .527 0 r
.60743 .56557 m .60628 .55846 L .60883 .56902 L p F P
0 g
s
0 0 0 r
.55646 .66113 m .55294 .66268 L .56173 .65887 L p F P
0 g
s
0 0 0 r
.56173 .65887 m .56642 .65682 L .55646 .66113 L p F P
0 g
s
.966 .687 .452 r
.54619 .64026 m .54288 .63074 L .54093 .63153 L p F P
0 g
s
.966 .687 .452 r
.54093 .63153 m .54385 .64124 L .54619 .64026 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .5303 .59197 L .53057 .5915 L closepath p F P
0 g
s
.756 .546 0 r
.44239 .58447 m .44318 .59182 L .44483 .60231 L p F P
0 g
s
0 0 .242 r
.44656 .60933 m .44483 .60231 L .44318 .59182 L p F P
0 g
s
.966 .687 .452 r
.53366 .60162 m .52999 .59233 L .52963 .59259 L p F P
0 g
s
.966 .687 .452 r
.52963 .59259 m .53295 .60213 L .53366 .60162 L p F P
0 g
s
.556 .859 .552 r
.58408 .64368 m .57966 .6479 L .5863 .64089 L p F P
0 g
s
.556 .859 .552 r
.5863 .64089 m .59129 .63606 L .58408 .64368 L p F P
0 g
s
.966 .687 .452 r
.54288 .63074 m .53957 .62121 L .538 .62183 L p F P
0 g
s
.966 .687 .452 r
.538 .62183 m .54093 .63153 L .54288 .63074 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52999 .59233 L .5303 .59197 L closepath p F P
0 g
s
.332 .809 .753 r
.5046 .5021 m .50155 .50285 L .49097 .50689 L p F P
0 g
s
0 0 0 r
.50155 .50285 m .5046 .5021 L .51495 .49987 L p F P
0 g
s
.966 .687 .452 r
.53957 .62121 m .53626 .61167 L .53508 .61213 L p F P
0 g
s
.966 .687 .452 r
.53508 .61213 m .538 .62183 L .53957 .62121 L p F P
0 g
s
.809 .774 .266 r
.60808 .60146 m .60635 .6085 L .60764 .59825 L p F P
0 g
s
.809 .774 .266 r
.60764 .59825 m .60942 .59095 L .60808 .60146 L p F P
0 g
s
.171 0 0 r
.54721 .50187 m .55015 .50258 L .53827 .50016 L p F P
0 g
s
.171 0 0 r
.53827 .50016 m .53679 .49975 L .54721 .50187 L p F P
0 g
s
.642 .83 .419 r
.46037 .53105 m .45679 .53654 L .45108 .54608 L p F P
0 g
s
0 0 0 r
.44808 .5525 m .45108 .54608 L .45679 .53654 L p F P
0 g
s
.553 .88 .612 r
.47718 .51497 m .47278 .51852 L .46471 .52619 L p F P
0 g
s
0 0 0 r
.46037 .53105 m .46471 .52619 L .47278 .51852 L p F P
0 g
s
.966 .687 .452 r
.53626 .61167 m .53295 .60213 L .53216 .60243 L p F P
0 g
s
.966 .687 .452 r
.53216 .60243 m .53508 .61213 L .53626 .61167 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52963 .59259 L .52999 .59233 L closepath p F P
0 g
s
0 .519 .718 r
.52201 .66678 m .52128 .66676 L .51053 .66548 L p F P
0 g
s
.966 .687 .452 r
.53295 .60213 m .52963 .59259 L .52924 .59273 L p F P
0 g
s
.966 .687 .452 r
.52924 .59273 m .53216 .60243 L .53295 .60213 L p F P
0 g
s
.62 .105 0 r
.58736 .52552 m .59167 .53033 L .58279 .52223 L p F P
0 g
s
.62 .105 0 r
.58279 .52223 m .57906 .51794 L .58736 .52552 L p F P
0 g
s
.762 .357 0 r
.60122 .54527 m .6042 .55167 L .59798 .54184 L p F P
0 g
s
.762 .357 0 r
.59798 .54184 m .59522 .53579 L .60122 .54527 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52924 .59273 L .52963 .59259 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .5288 .59276 L .52924 .59273 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52834 .59267 L .5288 .59276 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52786 .59248 L .52834 .59267 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52735 .59217 L .52786 .59248 L closepath p F P
0 g
s
.966 .687 .452 r
.52702 .5919 m .52735 .59217 L .52632 .58304 L p F P
0 g
s
.584 .392 .587 r
.52632 .58304 m .52709 .59189 L .52702 .59191 L p F P
0 g
s
.584 .392 .587 r
.52702 .59191 m .5268 .59197 L .52632 .58304 L p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52684 .59175 L .52702 .5919 L p F P
0 g
s
.697 .48 .59 r
.52632 .58304 m .52649 .59201 L .52617 .59201 L closepath p F P
0 g
s
.644 .438 .589 r
.52632 .58304 m .5268 .59197 L .52649 .59201 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .58304 m .52632 .59123 L .52684 .59175 L closepath p F P
0 g
s
.262 .164 .551 r
.52632 .58304 m .5277 .59146 L .52756 .59163 L closepath p F P
0 g
s
.937 .598 .361 r
.52632 .58304 m .52744 .59057 L .52763 .59072 L closepath p F P
0 g
s
.41 .267 .574 r
.52632 .58304 m .52756 .59163 L .52735 .59177 L closepath p F P
0 g
s
.88 .552 .425 r
.52632 .58304 m .52721 .59044 L .52744 .59057 L closepath p F P
0 g
s
.51 .338 .583 r
.52632 .58304 m .52735 .59177 L .52709 .59189 L closepath p F P
0 g
s
.821 .506 .457 r
.52632 .58304 m .52693 .59034 L .52721 .59044 L closepath p F P
0 g
s
.763 .461 .473 r
.52632 .58304 m .52662 .59028 L .52693 .59034 L closepath p F P
0 g
s
.706 .415 .48 r
.52632 .58304 m .5263 .59027 L .52662 .59028 L closepath p F P
0 g
s
.746 .521 .589 r
.52632 .58304 m .52617 .59201 L .52585 .59197 L closepath p F P
0 g
s
.645 .365 .48 r
.52632 .58304 m .52598 .59029 L .5263 .59027 L closepath p F P
0 g
s
.794 .563 .587 r
.52632 .58304 m .52585 .59197 L .52556 .5919 L closepath p F P
0 g
s
.575 .307 .472 r
.52632 .58304 m .52568 .59035 L .52598 .59029 L closepath p F P
0 g
s
.845 .61 .584 r
.52632 .58304 m .52556 .5919 L .5253 .59178 L closepath p F P
0 g
s
.487 .234 .455 r
.52632 .58304 m .5254 .59045 L .52568 .59035 L closepath p F P
0 g
s
.9 .665 .575 r
.52632 .58304 m .5253 .59178 L .52509 .59164 L closepath p F P
0 g
s
.365 .132 .421 r
.52632 .58304 m .52517 .59058 L .5254 .59045 L closepath p F P
0 g
s
.999 .797 .499 r
.52632 .58304 m .52494 .59147 L .52485 .59129 L closepath p F P
0 g
s
.957 .73 .554 r
.52632 .58304 m .52509 .59164 L .52494 .59147 L closepath p F P
0 g
s
.176 0 .354 r
.52632 .58304 m .52499 .59074 L .52517 .59058 L closepath p F P
0 g
s
.938 .808 .351 r
.52632 .58304 m .52485 .59129 L .52483 .5911 L closepath p F P
0 g
s
0 0 .211 r
.52632 .58304 m .52488 .59092 L .52499 .59074 L closepath p F P
0 g
s
0 0 0 r
.52632 .58304 m .52483 .5911 L .52488 .59092 L closepath p F P
0 g
s
.018 .001 .491 r
.52632 .58304 m .52779 .59128 L .5277 .59146 L closepath p F P
0 g
s
0 0 .332 r
.52632 .58304 m .5278 .59109 L .52779 .59128 L closepath p F P
0 g
s
.798 .528 0 r
.52632 .58304 m .52775 .5909 L .5278 .59109 L closepath p F P
0 g
s
.955 .619 .227 r
.52632 .58304 m .52763 .59072 L .52775 .5909 L closepath p F P
0 g
s
.01 w
.52632 .58304 m
.56504 .6253 L
s
.52632 .51679 m
.52632 .58304 L
s
.45408 .60617 m
.52632 .58304 L
s
.5 Mabswid
0 0 0 r
.44599 .55932 m .44484 .56644 L .44259 .57713 L p F P
0 g
s
0 0 .139 r
.44239 .58447 m .44259 .57713 L .44484 .56644 L p F P
0 g
s
.966 .687 .452 r
.53216 .60243 m .52924 .59273 L .5288 .59276 L p F P
0 g
s
.028 0 0 r
.51335 .5003 m .51495 .49987 L .52586 .49907 L p F P
0 g
s
0 0 0 r
.51495 .49987 m .51335 .5003 L .50155 .50285 L p F P
0 g
s
0 .496 .771 r
.51281 .66569 m .51053 .66548 L .50047 .66294 L p F P
0 g
s
0 .519 .718 r
.51053 .66548 m .51281 .66569 L .52201 .66678 L p F P
0 g
s
.129 0 0 r
.53679 .49975 m .53827 .50016 L .5258 .49939 L p F P
0 g
s
.129 0 0 r
.5258 .49939 m .52586 .49907 L .53679 .49975 L p F P
0 g
s
0 0 .362 r
.44924 .61607 m .45283 .62245 L .45766 .63135 L p F P
0 g
s
0 0 .558 r
.46183 .63672 m .45766 .63135 L .45283 .62245 L p F P
0 g
s
.403 .826 .655 r
.49097 .50689 m .487 .50904 L .47718 .51497 L p F P
0 g
s
0 0 0 r
.487 .50904 m .49097 .50689 L .50155 .50285 L p F P
0 g
s
.966 .687 .452 r
.53508 .61213 m .53216 .60243 L .5313 .60249 L p F P
0 g
s
.966 .687 .452 r
.5288 .59276 m .5313 .60249 L .53216 .60243 L p F P
0 g
s
0 0 0 r
.47278 .51852 m .47718 .51497 L .487 .50904 L p F P
0 g
s
.966 .687 .452 r
.538 .62183 m .53508 .61213 L .53379 .61224 L p F P
0 g
s
.966 .687 .452 r
.5313 .60249 m .53379 .61224 L .53508 .61213 L p F P
0 g
s
.407 0 0 r
.56085 .50651 m .56473 .50861 L .55283 .50424 L p F P
0 g
s
.407 0 0 r
.55283 .50424 m .55015 .50258 L .56085 .50651 L p F P
0 g
s
.966 .687 .452 r
.5313 .60249 m .5288 .59276 L .52834 .59267 L p F P
0 g
s
.028 0 0 r
.52586 .49907 m .5258 .49939 L .51335 .5003 L p F P
0 g
s
.896 .676 .162 r
.61001 .57625 m .61021 .58358 L .60762 .57293 L p F P
0 g
s
.896 .676 .162 r
.60762 .57293 m .60743 .56557 L .61001 .57625 L p F P
0 g
s
.768 .931 .575 r
.59549 .63064 m .59129 .63606 L .59555 .62769 L p F P
0 g
s
.768 .931 .575 r
.59555 .62769 m .60005 .62169 L .59549 .63064 L p F P
0 g
s
.555 0 0 r
.57473 .51443 m .57906 .51794 L .56817 .51161 L p F P
0 g
s
.555 0 0 r
.56817 .51161 m .56473 .50861 L .57473 .51443 L p F P
0 g
s
.966 .687 .452 r
.54093 .63153 m .538 .62183 L .53629 .622 L p F P
0 g
s
.966 .687 .452 r
.53379 .61224 m .53629 .622 L .538 .62183 L p F P
0 g
s
.426 0 0 r
.47363 .64844 m .47864 .65187 L .48697 .65722 L p F P
0 g
s
.292 0 0 r
.48697 .65722 m .49157 .65923 L .50047 .66294 L p F P
0 g
s
0 .344 .762 r
.49157 .65923 m .48697 .65722 L .47864 .65187 L p F P
0 g
s
.966 .687 .452 r
.54385 .64124 m .54093 .63153 L .53879 .63177 L p F P
0 g
s
.966 .687 .452 r
.53629 .622 m .53879 .63177 L .54093 .63153 L p F P
0 g
s
0 0 .242 r
.44318 .59182 m .44495 .5991 L .44656 .60933 L p F P
0 g
s
0 0 .431 r
.44924 .61607 m .44656 .60933 L .44495 .5991 L p F P
0 g
s
.966 .687 .452 r
.52834 .59267 m .53038 .60233 L .5313 .60249 L p F P
0 g
s
.966 .687 .452 r
.53038 .60233 m .52834 .59267 L .52786 .59248 L p F P
0 g
s
.523 .91 .771 r
.56642 .65682 m .56173 .65887 L .56892 .65408 L p F P
0 g
s
.523 .91 .771 r
.56892 .65408 m .57459 .65139 L .56642 .65682 L p F P
0 g
s
.966 .687 .452 r
.54678 .65096 m .54385 .64124 L .5413 .64155 L p F P
0 g
s
.966 .687 .452 r
.53879 .63177 m .5413 .64155 L .54385 .64124 L p F P
0 g
s
0 .031 .534 r
.46183 .63672 m .46678 .6415 L .47363 .64844 L p F P
0 g
s
0 .233 .722 r
.47864 .65187 m .47363 .64844 L .46678 .6415 L p F P
0 g
s
.966 .687 .452 r
.53379 .61224 m .5313 .60249 L .53038 .60233 L p F P
0 g
s
.892 .881 .449 r
.60635 .6085 m .60366 .61527 L .6049 .60541 L p F P
0 g
s
.892 .881 .449 r
.6049 .60541 m .60764 .59825 L .60635 .6085 L p F P
0 g
s
.966 .687 .452 r
.52786 .59248 m .52941 .60194 L .53038 .60233 L p F P
0 g
s
.966 .687 .452 r
.52941 .60194 m .52786 .59248 L .52735 .59217 L p F P
0 g
s
.662 .955 .733 r
.57966 .6479 m .57459 .65139 L .58058 .64505 L p F P
0 g
s
.662 .955 .733 r
.58058 .64505 m .5863 .64089 L .57966 .6479 L p F P
0 g
s
0 0 0 r
.45679 .53654 m .454 .54262 L .44808 .5525 L p F P
0 g
s
0 0 .021 r
.44599 .55932 m .44808 .5525 L .454 .54262 L p F P
0 g
s
.966 .687 .452 r
.55556 .68012 m .55263 .67039 L .54883 .67097 L p F P
0 g
s
.966 .687 .452 r
.5585 .68985 m .55556 .68012 L .55134 .6808 L p F P
0 g
s
.966 .687 .452 r
.54883 .67097 m .55134 .6808 L .55556 .68012 L p F P
0 g
s
0 .497 .839 r
.50422 .66352 m .50047 .66294 L .49157 .65923 L p F P
0 g
s
0 .496 .771 r
.50047 .66294 m .50422 .66352 L .51281 .66569 L p F P
0 g
s
.966 .687 .452 r
.53629 .622 m .53379 .61224 L .53241 .61201 L p F P
0 g
s
.966 .687 .452 r
.53038 .60233 m .53241 .61201 L .53379 .61224 L p F P
0 g
s
.966 .687 .452 r
.52735 .59217 m .5284 .60133 L .52941 .60194 L p F P
0 g
s
.584 .392 .587 r
.52729 .60094 m .5268 .59197 L .52702 .59191 L p F P
0 g
s
.966 .687 .452 r
.52717 .5938 m .5284 .60133 L .52702 .5919 L F
.584 .392 .587 r
.52702 .59191 m .52709 .59189 L p .52712 .59318 L F P
0 g
s
.584 .392 .587 r
.52712 .59318 m .52729 .60094 L .52702 .59191 L F
.966 .687 .452 r
.5284 .60133 m .52735 .59217 L .52702 .5919 L p F P
0 g
s
.966 .687 .452 r
.52702 .5919 m .52684 .59175 L p .52717 .5938 L F P
0 g
s
0 0 0 r
.47278 .51852 m .469 .52286 L .46037 .53105 L p F P
0 g
s
0 0 0 r
.45679 .53654 m .46037 .53105 L .469 .52286 L p F P
0 g
s
.447 .881 .844 r
.55294 .66268 m .54908 .66329 L .55658 .66004 L p F P
0 g
s
.447 .881 .844 r
.55658 .66004 m .56173 .65887 L .55294 .66268 L p F P
0 g
s
.966 .687 .452 r
.56143 .69958 m .5585 .68985 L .55386 .69064 L p F P
0 g
s
.966 .687 .452 r
.55134 .6808 m .55386 .69064 L .5585 .68985 L p F P
0 g
s
.746 .521 .589 r
.52539 .60095 m .52585 .59197 L .52617 .59201 L p F P
0 g
s
.746 .521 .589 r
.52617 .59201 m .52602 .60103 L .52539 .60095 L p F P
0 g
s
.697 .48 .59 r
.52602 .60103 m .52617 .59201 L .52649 .59201 L p F P
0 g
s
.697 .48 .59 r
.52649 .59201 m .52666 .60102 L .52602 .60103 L p F P
0 g
s
.644 .438 .589 r
.52666 .60102 m .52649 .59201 L .5268 .59197 L p F P
0 g
s
.886 .516 .043 r
.6042 .55167 m .60628 .55846 L .59991 .54841 L p F P
0 g
s
.886 .516 .043 r
.59991 .54841 m .59798 .54184 L .6042 .55167 L p F P
0 g
s
.794 .563 .587 r
.5248 .60079 m .52556 .5919 L .52585 .59197 L p F P
0 g
s
.794 .563 .587 r
.52585 .59197 m .52539 .60095 L .5248 .60079 L p F P
0 g
s
.644 .438 .589 r
.5268 .59197 m .52729 .60094 L .52666 .60102 L p F P
0 g
s
.966 .687 .452 r
.53241 .61201 m .53038 .60233 L .52941 .60194 L p F P
0 g
s
.845 .61 .584 r
.52428 .60057 m .5253 .59178 L .52556 .5919 L p F P
0 g
s
.845 .61 .584 r
.52556 .5919 m .5248 .60079 L .52428 .60057 L p F P
0 g
s
.584 .392 .587 r
.52773 .60082 m .52729 .60094 L p .52712 .59318 L F P
0 g
s
.966 .687 .452 r
.52684 .59175 m .52736 .6005 L .52773 .60079 L p F P
0 g
s
.966 .687 .452 r
.52773 .60079 m .5284 .60133 L p .52717 .5938 L F P
0 g
s
.966 .687 .452 r
.52684 .59175 m .52773 .60079 L .52717 .5938 L F
.584 .392 .587 r
.52709 .59189 m .52788 .60078 L .52773 .60082 L p F P
0 g
s
.584 .392 .587 r
.52709 .59189 m .52773 .60082 L .52712 .59318 L F
.51 .338 .583 r
.52788 .60078 m .52709 .59189 L .52735 .59177 L p F P
0 g
s
.966 .687 .452 r
.56436 .70931 m .56143 .69958 L .55639 .7005 L p F P
0 g
s
.966 .687 .452 r
.55386 .69064 m .55639 .7005 L .56143 .69958 L p F P
0 g
s
.9 .665 .575 r
.52386 .60028 m .52509 .59164 L .5253 .59178 L p F P
0 g
s
.9 .665 .575 r
.5253 .59178 m .52428 .60057 L .52386 .60028 L p F P
0 g
s
.51 .338 .583 r
.52735 .59177 m .52839 .60055 L .52788 .60078 L p F P
0 g
s
.41 .267 .574 r
.52839 .60055 m .52735 .59177 L .52756 .59163 L p F P
0 g
s
.966 .687 .452 r
.52736 .6005 m .52684 .59175 L .52632 .59123 L p F P
0 g
s
.957 .73 .554 r
.52355 .59995 m .52494 .59147 L .52509 .59164 L p F P
0 g
s
.957 .73 .554 r
.52509 .59164 m .52386 .60028 L .52355 .59995 L p F P
0 g
s
.781 .296 0 r
.59167 .53033 m .59522 .53579 L .58588 .52728 L p F P
0 g
s
.781 .296 0 r
.58588 .52728 m .58279 .52223 L .59167 .53033 L p F P
0 g
s
.41 .267 .574 r
.52756 .59163 m .5288 .60026 L .52839 .60055 L p F P
0 g
s
.262 .164 .551 r
.5288 .60026 m .52756 .59163 L .5277 .59146 L p F P
0 g
s
.966 .687 .452 r
.56729 .71905 m .56436 .70931 L .55891 .71037 L p F P
0 g
s
.966 .687 .452 r
.55639 .7005 m .55891 .71037 L .56436 .70931 L p F P
0 g
s
.999 .797 .499 r
.52337 .59959 m .52485 .59129 L .52494 .59147 L p F P
0 g
s
.999 .797 .499 r
.52494 .59147 m .52355 .59995 L .52337 .59959 L p F P
0 g
s
.262 .164 .551 r
.5277 .59146 m .5291 .59992 L .5288 .60026 L p F P
0 g
s
.018 .001 .491 r
.5291 .59992 m .5277 .59146 L .52779 .59128 L p F P
0 g
s
.966 .687 .452 r
.53879 .63177 m .53629 .622 L .53445 .62171 L p F P
0 g
s
.966 .687 .452 r
.53241 .61201 m .53445 .62171 L .53629 .622 L p F P
0 g
s
.938 .808 .351 r
.52333 .59921 m .52483 .5911 L .52485 .59129 L p F P
0 g
s
.938 .808 .351 r
.52485 .59129 m .52337 .59959 L .52333 .59921 L p F P
0 g
s
.018 .001 .491 r
.52779 .59128 m .52927 .59956 L .5291 .59992 L p F P
0 g
s
0 0 .332 r
.52927 .59956 m .52779 .59128 L .5278 .59109 L p F P
0 g
s
0 0 .139 r
.44484 .56644 m .44465 .5738 L .44239 .58447 L p F P
0 g
s
0 0 .322 r
.44318 .59182 m .44239 .58447 L .44465 .5738 L p F P
0 g
s
.966 .687 .452 r
.57023 .72879 m .56729 .71905 L .56144 .72025 L p F P
0 g
s
.966 .687 .452 r
.55891 .71037 m .56144 .72025 L .56729 .71905 L p F P
0 g
s
0 0 0 r
.52343 .59884 m .52488 .59092 L .52483 .5911 L p F P
0 g
s
0 0 0 r
.52483 .5911 m .52333 .59921 L .52343 .59884 L p F P
0 g
s
.966 .687 .452 r
.52632 .59123 m .52632 .59947 L .52736 .6005 L p F P
0 g
s
0 0 .332 r
.5278 .59109 m .5293 .59918 L .52927 .59956 L p F P
0 g
s
.798 .528 0 r
.5293 .59918 m .5278 .59109 L .52775 .5909 L p F P
0 g
s
.096 0 0 r
.49876 .50454 m .50155 .50285 L .51335 .5003 L p F P
0 g
s
0 0 0 r
.50155 .50285 m .49876 .50454 L .487 .50904 L p F P
0 g
s
0 0 .211 r
.52366 .59848 m .52499 .59074 L .52488 .59092 L p F P
0 g
s
0 0 .211 r
.52488 .59092 m .52343 .59884 L .52366 .59848 L p F P
0 g
s
.798 .528 0 r
.52775 .5909 m .52919 .5988 L .5293 .59918 L p F P
0 g
s
.955 .619 .227 r
.52919 .5988 m .52775 .5909 L .52763 .59072 L p F P
0 g
s
.966 .687 .452 r
.57317 .73854 m .57023 .72879 L .56398 .73014 L p F P
0 g
s
.966 .687 .452 r
.56144 .72025 m .56398 .73014 L .57023 .72879 L p F P
0 g
s
.412 0 0 r
.55015 .50258 m .55283 .50424 L .53962 .50156 L p F P
0 g
s
.412 0 0 r
.53962 .50156 m .53827 .50016 L .55015 .50258 L p F P
0 g
s
.176 0 .354 r
.52402 .59817 m .52517 .59058 L .52499 .59074 L p F P
0 g
s
.176 0 .354 r
.52499 .59074 m .52366 .59848 L .52402 .59817 L p F P
0 g
s
.955 .619 .227 r
.52763 .59072 m .52894 .59845 L .52919 .5988 L p F P
0 g
s
.937 .598 .361 r
.52894 .59845 m .52763 .59072 L .52744 .59057 L p F P
0 g
s
0 0 .558 r
.45283 .62245 m .45731 .6284 L .46183 .63672 L p F P
0 g
s
0 .174 .708 r
.46678 .6415 m .46183 .63672 L .45731 .6284 L p F P
0 g
s
.365 .132 .421 r
.52449 .5979 m .5254 .59045 L .52517 .59058 L p F P
0 g
s
.365 .132 .421 r
.52517 .59058 m .52402 .59817 L .52449 .5979 L p F P
0 g
s
.966 .687 .452 r
.5761 .74829 m .57317 .73854 L .56651 .74005 L p F P
0 g
s
.966 .687 .452 r
.56398 .73014 m .56651 .74005 L .57317 .73854 L p F P
0 g
s
.937 .598 .361 r
.52744 .59057 m .52858 .59814 L .52894 .59845 L p F P
0 g
s
.88 .552 .425 r
.52858 .59814 m .52744 .59057 L .52721 .59044 L p F P
0 g
s
.966 .687 .452 r
.52941 .60194 m .53096 .61144 L .53241 .61201 L p F P
0 g
s
.966 .687 .452 r
.53096 .61144 m .52941 .60194 L .5284 .60133 L p F P
0 g
s
.487 .234 .455 r
.52504 .59771 m .52568 .59035 L .5254 .59045 L p F P
0 g
s
.487 .234 .455 r
.5254 .59045 m .52449 .5979 L .52504 .59771 L p F P
0 g
s
.88 .552 .425 r
.52721 .59044 m .5281 .59789 L .52858 .59814 L p F P
0 g
s
.821 .506 .457 r
.5281 .59789 m .52721 .59044 L .52693 .59034 L p F P
0 g
s
.963 .78 .339 r
.61021 .58358 m .60942 .59095 L .60685 .58044 L p F P
0 g
s
.963 .78 .339 r
.60685 .58044 m .60762 .57293 L .61021 .58358 L p F P
0 g
s
.575 .307 .472 r
.52565 .59758 m .52598 .59029 L .52568 .59035 L p F P
0 g
s
.575 .307 .472 r
.52568 .59035 m .52504 .59771 L .52565 .59758 L p F P
0 g
s
.821 .506 .457 r
.52693 .59034 m .52755 .59769 L .5281 .59789 L p F P
0 g
s
.763 .461 .473 r
.52755 .59769 m .52693 .59034 L .52662 .59028 L p F P
0 g
s
.645 .365 .48 r
.52629 .59754 m .5263 .59027 L .52598 .59029 L p F P
0 g
s
.645 .365 .48 r
.52598 .59029 m .52565 .59758 L .52629 .59754 L p F P
0 g
s
.763 .461 .473 r
.52662 .59028 m .52693 .59758 L .52755 .59769 L p F P
0 g
s
.706 .415 .48 r
.52693 .59758 m .52662 .59028 L .5263 .59027 L p F P
0 g
s
.966 .687 .452 r
.57904 .75804 m .5761 .74829 L .56905 .74997 L p F P
0 g
s
.966 .687 .452 r
.56651 .74005 m .56905 .74997 L .5761 .74829 L p F P
0 g
s
.706 .415 .48 r
.5263 .59027 m .52629 .59754 L .52693 .59758 L p F P
0 g
s
.966 .687 .452 r
.5413 .64155 m .53879 .63177 L .5365 .63142 L p F P
0 g
s
.966 .687 .452 r
.53445 .62171 m .5365 .63142 L .53879 .63177 L p F P
0 g
s
.966 .687 .452 r
.53445 .62171 m .53241 .61201 L .53096 .61144 L p F P
0 g
s
.966 .687 .452 r
.58198 .7678 m .57904 .75804 L .5716 .7599 L p F P
0 g
s
.966 .687 .452 r
.56905 .74997 m .5716 .7599 L .57904 .75804 L p F P
0 g
s
.821 .987 .717 r
.59129 .63606 m .5863 .64089 L .59021 .63318 L p F P
0 g
s
.821 .987 .717 r
.59021 .63318 m .59555 .62769 L .59129 .63606 L p F P
0 g
s
0 0 .431 r
.44495 .5991 m .4477 .60623 L .44924 .61607 L p F P
0 g
s
0 .01 .582 r
.45283 .62245 m .44924 .61607 L .4477 .60623 L p F P
0 g
s
.191 .692 .912 r
.52279 .66581 m .52201 .66678 L .51281 .66569 L p F P
0 g
s
.242 .741 .905 r
.52201 .66678 m .52279 .66581 L .53047 .66578 L p F P
0 g
s
.966 .687 .452 r
.58492 .77756 m .58198 .7678 L .57414 .76985 L p F P
0 g
s
.966 .687 .452 r
.5716 .7599 m .57414 .76985 L .58198 .7678 L p F P
0 g
s
0 0 0 r
.487 .50904 m .48348 .51207 L .47278 .51852 L p F P
0 g
s
0 0 0 r
.469 .52286 m .47278 .51852 L .48348 .51207 L p F P
0 g
s
.966 .687 .452 r
.58786 .78732 m .58492 .77756 L .57669 .7798 L p F P
0 g
s
.966 .687 .452 r
.57414 .76985 m .57669 .7798 L .58492 .77756 L p F P
0 g
s
.966 .687 .452 r
.5365 .63142 m .53855 .64116 L .5413 .64155 L p F P
0 g
s
.966 .687 .452 r
.5284 .60133 m .52944 .61053 L .53096 .61144 L p F P
0 g
s
.069 0 0 r
.48348 .51207 m .487 .50904 L .49876 .50454 L p F P
0 g
s
.93 .941 .593 r
.60366 .61527 m .60005 .62169 L .60121 .61233 L p F P
0 g
s
.93 .941 .593 r
.60121 .61233 m .6049 .60541 L .60366 .61527 L p F P
0 g
s
.966 .687 .452 r
.59081 .79709 m .58786 .78732 L .57924 .78977 L p F P
0 g
s
.966 .687 .452 r
.57669 .7798 m .57924 .78977 L .58786 .78732 L p F P
0 g
s
.719 .186 0 r
.57906 .51794 m .58279 .52223 L .57115 .51547 L p F P
0 g
s
.719 .186 0 r
.57115 .51547 m .56817 .51161 L .57906 .51794 L p F P
0 g
s
.966 .687 .452 r
.59375 .80686 m .59081 .79709 L .5818 .79976 L p F P
0 g
s
.966 .687 .452 r
.57924 .78977 m .5818 .79976 L .59081 .79709 L p F P
0 g
s
.599 .03 0 r
.56473 .50861 m .56817 .51161 L .55521 .50685 L p F P
0 g
s
.599 .03 0 r
.55521 .50685 m .55283 .50424 L .56473 .50861 L p F P
0 g
s
0 0 .021 r
.454 .54262 m .45206 .54921 L .44599 .55932 L p F P
0 g
s
0 0 .208 r
.44484 .56644 m .44599 .55932 L .45206 .54921 L p F P
0 g
s
.179 .657 .93 r
.51528 .66492 m .51281 .66569 L .50422 .66352 L p F P
0 g
s
.191 .692 .912 r
.51281 .66569 m .51528 .66492 L .52279 .66581 L p F P
0 g
s
.254 0 0 r
.51189 .50171 m .51335 .5003 L .5258 .49939 L p F P
0 g
s
.096 0 0 r
.51335 .5003 m .51189 .50171 L .49876 .50454 L p F P
0 g
s
.746 .521 .589 r
.52492 .60996 m .52539 .60095 L .52602 .60103 L p F P
0 g
s
.746 .521 .589 r
.52602 .60103 m .52587 .61007 L .52492 .60996 L p F P
0 g
s
.697 .48 .59 r
.52587 .61007 m .52602 .60103 L .52666 .60102 L p F P
0 g
s
.697 .48 .59 r
.52666 .60102 m .52684 .61007 L .52587 .61007 L p F P
0 g
s
.644 .438 .589 r
.52684 .61007 m .52666 .60102 L .52729 .60094 L p F P
0 g
s
0 .344 .762 r
.47864 .65187 m .48423 .65451 L .49157 .65923 L p F P
0 g
s
.061 .509 .894 r
.49662 .66035 m .49157 .65923 L .48423 .65451 L p F P
0 g
s
0 .497 .839 r
.49157 .65923 m .49662 .66035 L .50422 .66352 L p F P
0 g
s
.358 0 0 r
.53827 .50016 m .53962 .50156 L .52574 .5007 L p F P
0 g
s
.358 0 0 r
.52574 .5007 m .5258 .49939 L .53827 .50016 L p F P
0 g
s
0 .233 .722 r
.46678 .6415 m .47246 .6456 L .47864 .65187 L p F P
0 g
s
0 .399 .848 r
.48423 .65451 m .47864 .65187 L .47246 .6456 L p F P
0 g
s
.794 .563 .587 r
.52404 .60973 m .5248 .60079 L .52539 .60095 L p F P
0 g
s
.794 .563 .587 r
.52539 .60095 m .52492 .60996 L .52404 .60973 L p F P
0 g
s
.644 .438 .589 r
.52729 .60094 m .52779 .60994 L .52684 .61007 L p F P
0 g
s
.966 .687 .452 r
.59669 .81663 m .59375 .80686 L .58436 .80975 L p F P
0 g
s
.966 .687 .452 r
.5818 .79976 m .58436 .80975 L .59375 .80686 L p F P
0 g
s
.966 .687 .452 r
.5365 .63142 m .53445 .62171 L .53251 .62096 L p F P
0 g
s
.966 .687 .452 r
.53096 .61144 m .53251 .62096 L .53445 .62171 L p F P
0 g
s
.845 .61 .584 r
.52326 .60939 m .52428 .60057 L .5248 .60079 L p F P
0 g
s
.845 .61 .584 r
.5248 .60079 m .52404 .60973 L .52326 .60939 L p F P
0 g
s
.51 .338 .583 r
.52866 .6097 m .52788 .60078 L .52839 .60055 L p F P
0 g
s
.615 .956 .898 r
.56173 .65887 m .55658 .66004 L .56272 .65595 L p F P
0 g
s
.615 .956 .898 r
.56272 .65595 m .56892 .65408 L .56173 .65887 L p F P
0 g
s
.966 .687 .452 r
.59964 .82641 m .59669 .81663 L .58692 .81976 L p F P
0 g
s
.966 .687 .452 r
.58436 .80975 m .58692 .81976 L .59669 .81663 L p F P
0 g
s
.9 .665 .575 r
.52262 .60896 m .52386 .60028 L .52428 .60057 L p F P
0 g
s
.9 .665 .575 r
.52428 .60057 m .52326 .60939 L .52262 .60896 L p F P
0 g
s
.51 .338 .583 r
.52839 .60055 m .52943 .60936 L .52866 .6097 L p F P
0 g
s
.41 .267 .574 r
.52943 .60936 m .52839 .60055 L .5288 .60026 L p F P
0 g
s
.966 .687 .452 r
.53251 .62096 m .53096 .61144 L .52944 .61053 L p F P
0 g
s
.719 .988 .852 r
.57459 .65139 m .56892 .65408 L .57418 .6485 L p F P
0 g
s
.719 .988 .852 r
.57418 .6485 m .58058 .64505 L .57459 .65139 L p F P
0 g
s
.966 .687 .452 r
.52789 .60929 m .52736 .6005 L .52632 .59947 L p F P
0 g
s
.956 .63 .225 r
.60628 .55846 m .60743 .56557 L .60097 .55542 L p F P
0 g
s
.956 .63 .225 r
.60097 .55542 m .59991 .54841 L .60628 .55846 L p F P
0 g
s
.966 .687 .452 r
.60259 .83619 m .59964 .82641 L .58949 .82978 L p F P
0 g
s
.966 .687 .452 r
.58692 .81976 m .58949 .82978 L .59964 .82641 L p F P
0 g
s
.957 .73 .554 r
.52216 .60847 m .52355 .59995 L .52386 .60028 L p F P
0 g
s
.957 .73 .554 r
.52386 .60028 m .52262 .60896 L .52216 .60847 L p F P
0 g
s
.41 .267 .574 r
.5288 .60026 m .53005 .60892 L .52943 .60936 L p F P
0 g
s
.262 .164 .551 r
.53005 .60892 m .5288 .60026 L .5291 .59992 L p F P
0 g
s
.254 0 0 r
.5258 .49939 m .52574 .5007 L .51189 .50171 L p F P
0 g
s
0 0 0 r
.469 .52286 m .46586 .52793 L .45679 .53654 L p F P
0 g
s
0 0 .064 r
.454 .54262 m .45679 .53654 L .46586 .52793 L p F P
0 g
s
.966 .687 .452 r
.60554 .84598 m .60259 .83619 L .59205 .83981 L p F P
0 g
s
.966 .687 .452 r
.58949 .82978 m .59205 .83981 L .60259 .83619 L p F P
0 g
s
.999 .797 .499 r
.52189 .60792 m .52337 .59959 L .52355 .59995 L p F P
0 g
s
.999 .797 .499 r
.52355 .59995 m .52216 .60847 L .52189 .60792 L p F P
0 g
s
.262 .164 .551 r
.5291 .59992 m .5305 .60842 L .53005 .60892 L p F P
0 g
s
.018 .001 .491 r
.5305 .60842 m .5291 .59992 L .52927 .59956 L p F P
0 g
s
0 0 .322 r
.44465 .5738 m .44542 .5813 L .44318 .59182 L p F P
0 g
s
0 0 .468 r
.44495 .5991 m .44318 .59182 L .44542 .5813 L p F P
0 g
s
.966 .687 .452 r
.60849 .85577 m .60554 .84598 L .59463 .84986 L p F P
0 g
s
.966 .687 .452 r
.59205 .83981 m .59463 .84986 L .60554 .84598 L p F P
0 g
s
.938 .808 .351 r
.52183 .60736 m .52333 .59921 L .52337 .59959 L p F P
0 g
s
.938 .808 .351 r
.52337 .59959 m .52189 .60792 L .52183 .60736 L p F P
0 g
s
.018 .001 .491 r
.52927 .59956 m .53075 .60788 L .5305 .60842 L p F P
0 g
s
0 0 .332 r
.53075 .60788 m .52927 .59956 L .5293 .59918 L p F P
0 g
s
.877 .44 .081 r
.59522 .53579 m .59798 .54184 L .58828 .53301 L p F P
0 g
s
.877 .44 .081 r
.58828 .53301 m .58588 .52728 L .59522 .53579 L p F P
0 g
s
.966 .687 .452 r
.61144 .86556 m .60849 .85577 L .5972 .85992 L p F P
0 g
s
.966 .687 .452 r
.59463 .84986 m .5972 .85992 L .60849 .85577 L p F P
0 g
s
0 0 0 r
.52198 .6068 m .52343 .59884 L .52333 .59921 L p F P
0 g
s
0 0 0 r
.52333 .59921 m .52183 .60736 L .52198 .6068 L p F P
0 g
s
.966 .687 .452 r
.52632 .59947 m .52632 .60775 L .52789 .60929 L p F P
0 g
s
0 0 .332 r
.5293 .59918 m .5308 .60731 L .53075 .60788 L p F P
0 g
s
.798 .528 0 r
.5308 .60731 m .5293 .59918 L .52919 .5988 L p F P
0 g
s
.966 .687 .452 r
.53855 .64116 m .5365 .63142 L .53408 .63051 L p F P
0 g
s
.966 .687 .452 r
.53251 .62096 m .53408 .63051 L .5365 .63142 L p F P
0 g
s
.966 .687 .452 r
.5972 .85992 m .59978 .86999 L .61144 .86556 L p F P
0 g
s
.991 .844 .479 r
.60942 .59095 m .60764 .59825 L .60512 .58802 L p F P
0 g
s
.991 .844 .479 r
.60512 .58802 m .60685 .58044 L .60942 .59095 L p F P
0 g
s
.202 .634 .949 r
.50826 .66315 m .50422 .66352 L .49662 .66035 L p F P
0 g
s
.179 .657 .93 r
.50422 .66352 m .50826 .66315 L .51528 .66492 L p F P
0 g
s
0 0 .211 r
.52233 .60627 m .52366 .59848 L .52343 .59884 L p F P
0 g
s
0 0 .211 r
.52343 .59884 m .52198 .6068 L .52233 .60627 L p F P
0 g
s
.798 .528 0 r
.52919 .5988 m .53063 .60675 L .5308 .60731 L p F P
0 g
s
.955 .619 .227 r
.53063 .60675 m .52919 .5988 L .52894 .59845 L p F P
0 g
s
0 .174 .708 r
.45731 .6284 m .46264 .63384 L .46678 .6415 L p F P
0 g
s
0 .324 .811 r
.47246 .6456 m .46678 .6415 L .46264 .63384 L p F P
0 g
s
.557 .92 .95 r
.54908 .66329 m .54492 .66296 L .55104 .66031 L p F P
0 g
s
.557 .92 .95 r
.55104 .66031 m .55658 .66004 L .54908 .66329 L p F P
0 g
s
.966 .687 .452 r
.55134 .6808 m .54883 .67097 L .54472 .67051 L p F P
0 g
s
.966 .687 .452 r
.52944 .61053 m .5305 .61976 L .53251 .62096 L p F P
0 g
s
.176 0 .354 r
.52286 .6058 m .52402 .59817 L .52366 .59848 L p F P
0 g
s
.176 0 .354 r
.52366 .59848 m .52233 .60627 L .52286 .6058 L p F P
0 g
s
.955 .619 .227 r
.52894 .59845 m .53027 .60623 L .53063 .60675 L p F P
0 g
s
.937 .598 .361 r
.53027 .60623 m .52894 .59845 L .52858 .59814 L p F P
0 g
s
0 .01 .582 r
.4477 .60623 m .45139 .61311 L .45283 .62245 L p F P
0 g
s
0 .162 .693 r
.45731 .6284 m .45283 .62245 L .45139 .61311 L p F P
0 g
s
.365 .132 .421 r
.52356 .60541 m .52449 .5979 L .52402 .59817 L p F P
0 g
s
.365 .132 .421 r
.52402 .59817 m .52286 .6058 L .52356 .60541 L p F P
0 g
s
.937 .598 .361 r
.52858 .59814 m .52972 .60576 L .53027 .60623 L p F P
0 g
s
.88 .552 .425 r
.52972 .60576 m .52858 .59814 L .5281 .59789 L p F P
0 g
s
.837 .999 .814 r
.5863 .64089 m .58058 .64505 L .58409 .6381 L p F P
0 g
s
.837 .999 .814 r
.58409 .6381 m .59021 .63318 L .5863 .64089 L p F P
0 g
s
.966 .687 .452 r
.53408 .63051 m .53251 .62096 L .5305 .61976 L p F P
0 g
s
.487 .234 .455 r
.52439 .60511 m .52504 .59771 L .52449 .5979 L p F P
0 g
s
.487 .234 .455 r
.52449 .5979 m .52356 .60541 L .52439 .60511 L p F P
0 g
s
.88 .552 .425 r
.5281 .59789 m .52901 .60538 L .52972 .60576 L p F P
0 g
s
.821 .506 .457 r
.52901 .60538 m .5281 .59789 L .52755 .59769 L p F P
0 g
s
.575 .307 .472 r
.52531 .60492 m .52565 .59758 L .52504 .59771 L p F P
0 g
s
.575 .307 .472 r
.52504 .59771 m .52439 .60511 L .52531 .60492 L p F P
0 g
s
.821 .506 .457 r
.52755 .59769 m .52817 .60509 L .52901 .60538 L p F P
0 g
s
.763 .461 .473 r
.52817 .60509 m .52755 .59769 L .52693 .59758 L p F P
0 g
s
.936 .966 .698 r
.60005 .62169 m .59555 .62769 L .59661 .61894 L p F P
0 g
s
.936 .966 .698 r
.59661 .61894 m .60121 .61233 L .60005 .62169 L p F P
0 g
s
.645 .365 .48 r
.52628 .60486 m .52629 .59754 L .52565 .59758 L p F P
0 g
s
.645 .365 .48 r
.52565 .59758 m .52531 .60492 L .52628 .60486 L p F P
0 g
s
.746 .521 .589 r
.52445 .61901 m .52492 .60996 L .52587 .61007 L p F P
0 g
s
.746 .521 .589 r
.52587 .61007 m .52572 .61916 L .52445 .61901 L p F P
0 g
s
.697 .48 .59 r
.52572 .61916 m .52587 .61007 L .52684 .61007 L p F P
0 g
s
.763 .461 .473 r
.52693 .59758 m .52724 .60491 L .52817 .60509 L p F P
0 g
s
.706 .415 .48 r
.52724 .60491 m .52693 .59758 L .52629 .59754 L p F P
0 g
s
.697 .48 .59 r
.52684 .61007 m .52702 .61916 L .52572 .61916 L p F P
0 g
s
.644 .438 .589 r
.52702 .61916 m .52684 .61007 L .52779 .60994 L p F P
0 g
s
.706 .415 .48 r
.52629 .59754 m .52628 .60486 L .52724 .60491 L p F P
0 g
s
.966 .687 .452 r
.55386 .69064 m .55134 .6808 L .54679 .68033 L p F P
0 g
s
.966 .687 .452 r
.54472 .67051 m .54679 .68033 L .55134 .6808 L p F P
0 g
s
.794 .563 .587 r
.52327 .6187 m .52404 .60973 L .52492 .60996 L p F P
0 g
s
.794 .563 .587 r
.52492 .60996 m .52445 .61901 L .52327 .6187 L p F P
0 g
s
.644 .438 .589 r
.52779 .60994 m .52828 .61899 L .52702 .61916 L p F P
0 g
s
.272 0 0 r
.49629 .50718 m .49876 .50454 L .51189 .50171 L p F P
0 g
s
.069 0 0 r
.49876 .50454 m .49629 .50718 L .48348 .51207 L p F P
0 g
s
.845 .61 .584 r
.52223 .61825 m .52326 .60939 L .52404 .60973 L p F P
0 g
s
.845 .61 .584 r
.52404 .60973 m .52327 .6187 L .52223 .61825 L p F P
0 g
s
.51 .338 .583 r
.52945 .61867 m .52866 .6097 L .52943 .60936 L p F P
0 g
s
0 0 .208 r
.45206 .54921 m .45098 .55623 L .44484 .56644 L p F P
0 g
s
0 0 .356 r
.44465 .5738 m .44484 .56644 L .45098 .55623 L p F P
0 g
s
.574 .025 0 r
.55283 .50424 m .55521 .50685 L .54081 .50393 L p F P
0 g
s
.574 .025 0 r
.54081 .50393 m .53962 .50156 L .55283 .50424 L p F P
0 g
s
0 0 0 r
.48348 .51207 m .48043 .51597 L .469 .52286 L p F P
0 g
s
.109 0 .057 r
.46586 .52793 m .469 .52286 L .48043 .51597 L p F P
0 g
s
.9 .665 .575 r
.52138 .61768 m .52262 .60896 L .52326 .60939 L p F P
0 g
s
.9 .665 .575 r
.52326 .60939 m .52223 .61825 L .52138 .61768 L p F P
0 g
s
.51 .338 .583 r
.52943 .60936 m .53048 .61821 L .52945 .61867 L p F P
0 g
s
.41 .267 .574 r
.53048 .61821 m .52943 .60936 L .53005 .60892 L p F P
0 g
s
.966 .687 .452 r
.52842 .61813 m .52789 .60929 L .52632 .60775 L p F P
0 g
s
.966 .687 .452 r
.55639 .7005 m .55386 .69064 L .54886 .69017 L p F P
0 g
s
.966 .687 .452 r
.54679 .68033 m .54886 .69017 L .55386 .69064 L p F P
0 g
s
.957 .73 .554 r
.52076 .61702 m .52216 .60847 L .52262 .60896 L p F P
0 g
s
.957 .73 .554 r
.52262 .60896 m .52138 .61768 L .52076 .61702 L p F P
0 g
s
.41 .267 .574 r
.53005 .60892 m .53131 .61763 L .53048 .61821 L p F P
0 g
s
.262 .164 .551 r
.53131 .61763 m .53005 .60892 L .5305 .60842 L p F P
0 g
s
.812 .335 .069 r
.58279 .52223 m .58588 .52728 L .57361 .52016 L p F P
0 g
s
.812 .335 .069 r
.57361 .52016 m .57115 .51547 L .58279 .52223 L p F P
0 g
s
.985 .706 .368 r
.60743 .56557 m .60762 .57293 L .60115 .5628 L p F P
0 g
s
.985 .706 .368 r
.60115 .5628 m .60097 .55542 L .60743 .56557 L p F P
0 g
s
.01 w
.60525 .55777 m
.60669 .55731 L
s
.60288 .55853 m
.60525 .55777 L
s
.60669 .55731 m
.60919 .55651 L
s
.60151 .55897 m
.60288 .55853 L
s
.5 Mabswid
0 .399 .848 r
.47246 .6456 m .4788 .64899 L .48423 .65451 L p F P
0 g
s
.17 .52 .918 r
.49036 .65632 m .48423 .65451 L .4788 .64899 L p F P
0 g
s
.061 .509 .894 r
.48423 .65451 m .49036 .65632 L .49662 .66035 L p F P
0 g
s
0 0 .468 r
.44542 .5813 m .44716 .58885 L .44495 .5991 L p F P
0 g
s
0 .062 .579 r
.4477 .60623 m .44495 .5991 L .44716 .58885 L p F P
0 g
s
.999 .797 .499 r
.5204 .6163 m .52189 .60792 L .52216 .60847 L p F P
0 g
s
.999 .797 .499 r
.52216 .60847 m .52076 .61702 L .5204 .6163 L p F P
0 g
s
.219 0 0 r
.48043 .51597 m .48348 .51207 L .49629 .50718 L p F P
0 g
s
.262 .164 .551 r
.5305 .60842 m .53191 .61697 L .53131 .61763 L p F P
0 g
s
.018 .001 .491 r
.53191 .61697 m .5305 .60842 L .53075 .60788 L p F P
0 g
s
0 0 .064 r
.46586 .52793 m .46343 .53369 L .454 .54262 L p F P
0 g
s
.059 0 .231 r
.45206 .54921 m .454 .54262 L .46343 .53369 L p F P
0 g
s
.739 .978 .918 r
.56892 .65408 m .56272 .65595 L .56719 .6512 L p F P
0 g
s
.739 .978 .918 r
.56719 .6512 m .57418 .6485 L .56892 .65408 L p F P
0 g
s
.966 .687 .452 r
.53564 .64009 m .53408 .63051 L .53155 .62903 L p F P
0 g
s
.966 .687 .452 r
.5305 .61976 m .53155 .62903 L .53408 .63051 L p F P
0 g
s
.251 .617 .957 r
.50205 .66055 m .49662 .66035 L .49036 .65632 L p F P
0 g
s
.202 .634 .949 r
.49662 .66035 m .50205 .66055 L .50826 .66315 L p F P
0 g
s
.714 .202 .009 r
.56817 .51161 m .57115 .51547 L .55727 .51039 L p F P
0 g
s
.714 .202 .009 r
.55727 .51039 m .55521 .50685 L .56817 .51161 L p F P
0 g
s
.966 .687 .452 r
.55891 .71037 m .55639 .7005 L .55094 .70004 L p F P
0 g
s
.966 .687 .452 r
.54886 .69017 m .55094 .70004 L .55639 .7005 L p F P
0 g
s
.938 .808 .351 r
.52032 .61555 m .52183 .60736 L .52189 .60792 L p F P
0 g
s
.938 .808 .351 r
.52189 .60792 m .5204 .6163 L .52032 .61555 L p F P
0 g
s
.018 .001 .491 r
.53075 .60788 m .53225 .61624 L .53191 .61697 L p F P
0 g
s
0 0 .332 r
.53225 .61624 m .53075 .60788 L .5308 .60731 L p F P
0 g
s
.661 .947 .957 r
.55658 .66004 m .55104 .66031 L .55604 .65697 L p F P
0 g
s
.661 .947 .957 r
.55604 .65697 m .56272 .65595 L .55658 .66004 L p F P
0 g
s
.993 .88 .586 r
.60764 .59825 m .6049 .60541 L .60245 .59557 L p F P
0 g
s
.993 .88 .586 r
.60245 .59557 m .60512 .58802 L .60764 .59825 L p F P
0 g
s
.925 .541 .243 r
.59798 .54184 m .59991 .54841 L .58996 .53938 L p F P
0 g
s
.925 .541 .243 r
.58996 .53938 m .58828 .53301 L .59798 .54184 L p F P
0 g
s
0 0 0 r
.52051 .61481 m .52198 .6068 L .52183 .60736 L p F P
0 g
s
0 0 0 r
.52183 .60736 m .52032 .61555 L .52051 .61481 L p F P
0 g
s
.966 .687 .452 r
.52632 .60775 m .52632 .61607 L .52842 .61813 L p F P
0 g
s
0 0 .332 r
.5308 .60731 m .53231 .61549 L .53225 .61624 L p F P
0 g
s
.798 .528 0 r
.53231 .61549 m .5308 .60731 L .53063 .60675 L p F P
0 g
s
.411 0 0 r
.51059 .5041 m .51189 .50171 L .52574 .5007 L p F P
0 g
s
.272 0 0 r
.51189 .50171 m .51059 .5041 L .49629 .50718 L p F P
0 g
s
0 .162 .693 r
.45139 .61311 m .45598 .61966 L .45731 .6284 L p F P
0 g
s
.078 .286 .771 r
.46264 .63384 m .45731 .6284 L .45598 .61966 L p F P
0 g
s
.509 0 0 r
.53962 .50156 m .54081 .50393 L .52569 .503 L p F P
0 g
s
.509 0 0 r
.52569 .503 m .52574 .5007 L .53962 .50156 L p F P
0 g
s
0 .324 .811 r
.46264 .63384 m .46874 .63869 L .47246 .6456 L p F P
0 g
s
.152 .44 .874 r
.4788 .64899 m .47246 .6456 L .46874 .63869 L p F P
0 g
s
.966 .687 .452 r
.56144 .72025 m .55891 .71037 L .55302 .70993 L p F P
0 g
s
.966 .687 .452 r
.55094 .70004 m .55302 .70993 L .55891 .71037 L p F P
0 g
s
0 0 .211 r
.52098 .6141 m .52233 .60627 L .52198 .6068 L p F P
0 g
s
0 0 .211 r
.52198 .6068 m .52051 .61481 L .52098 .6141 L p F P
0 g
s
.798 .528 0 r
.53063 .60675 m .53209 .61475 L .53231 .61549 L p F P
0 g
s
.955 .619 .227 r
.53209 .61475 m .53063 .60675 L .53027 .60623 L p F P
0 g
s
.746 .521 .589 r
.52398 .6281 m .52445 .61901 L .52572 .61916 L p F P
0 g
s
.746 .521 .589 r
.52572 .61916 m .52557 .62829 L .52398 .6281 L p F P
0 g
s
.697 .48 .59 r
.52557 .62829 m .52572 .61916 L .52702 .61916 L p F P
0 g
s
.697 .48 .59 r
.52702 .61916 m .52719 .62828 L .52557 .62829 L p F P
0 g
s
.644 .438 .589 r
.52719 .62828 m .52702 .61916 L .52828 .61899 L p F P
0 g
s
.794 .563 .587 r
.5225 .62771 m .52327 .6187 L .52445 .61901 L p F P
0 g
s
.794 .563 .587 r
.52445 .61901 m .52398 .6281 L .5225 .62771 L p F P
0 g
s
.644 .438 .589 r
.52828 .61899 m .52878 .62807 L .52719 .62828 L p F P
0 g
s
.829 .986 .874 r
.58058 .64505 m .57418 .6485 L .57725 .64239 L p F P
0 g
s
.829 .986 .874 r
.57725 .64239 m .58409 .6381 L .58058 .64505 L p F P
0 g
s
.923 .969 .773 r
.59555 .62769 m .59021 .63318 L .59116 .62514 L p F P
0 g
s
.923 .969 .773 r
.59116 .62514 m .59661 .61894 L .59555 .62769 L p F P
0 g
s
.176 0 .354 r
.5217 .61348 m .52286 .6058 L .52233 .60627 L p F P
0 g
s
.176 0 .354 r
.52233 .60627 m .52098 .6141 L .5217 .61348 L p F P
0 g
s
.937 .598 .361 r
.5316 .61405 m .53027 .60623 L .52972 .60576 L p F P
0 g
s
.955 .619 .227 r
.53027 .60623 m .5316 .61405 L .53209 .61475 L p F P
0 g
s
.411 0 0 r
.52574 .5007 m .52569 .503 L .51059 .5041 L p F P
0 g
s
.845 .61 .584 r
.5212 .62715 m .52223 .61825 L .52327 .6187 L p F P
0 g
s
.845 .61 .584 r
.52327 .6187 m .5225 .62771 L .5212 .62715 L p F P
0 g
s
.51 .338 .583 r
.53024 .62767 m .52945 .61867 L .53048 .61821 L p F P
0 g
s
.966 .687 .452 r
.56398 .73014 m .56144 .72025 L .5551 .71983 L p F P
0 g
s
.966 .687 .452 r
.55302 .70993 m .5551 .71983 L .56144 .72025 L p F P
0 g
s
.365 .132 .421 r
.52263 .61295 m .52356 .60541 L .52286 .6058 L p F P
0 g
s
.365 .132 .421 r
.52286 .6058 m .5217 .61348 L .52263 .61295 L p F P
0 g
s
.937 .598 .361 r
.52972 .60576 m .53086 .61343 L .5316 .61405 L p F P
0 g
s
.88 .552 .425 r
.53086 .61343 m .52972 .60576 L .52901 .60538 L p F P
0 g
s
.9 .665 .575 r
.52013 .62645 m .52138 .61768 L .52223 .61825 L p F P
0 g
s
.9 .665 .575 r
.52223 .61825 m .5212 .62715 L .52013 .62645 L p F P
0 g
s
0 0 .356 r
.45098 .55623 m .4508 .56361 L .44465 .5738 L p F P
0 g
s
.072 .008 .47 r
.44542 .5813 m .44465 .5738 L .4508 .56361 L p F P
0 g
s
.51 .338 .583 r
.53048 .61821 m .53153 .6271 L .53024 .62767 L p F P
0 g
s
.41 .267 .574 r
.53153 .6271 m .53048 .61821 L .53131 .61763 L p F P
0 g
s
.966 .687 .452 r
.53155 .62903 m .53261 .63833 L .53564 .64009 L p F P
0 g
s
.372 .708 .986 r
.51253 .66182 m .50826 .66315 L .50205 .66055 L p F P
0 g
s
.487 .234 .455 r
.52374 .61256 m .52439 .60511 L .52356 .60541 L p F P
0 g
s
.487 .234 .455 r
.52356 .60541 m .52263 .61295 L .52374 .61256 L p F P
0 g
s
.88 .552 .425 r
.52901 .60538 m .52991 .61291 L .53086 .61343 L p F P
0 g
s
.821 .506 .457 r
.52991 .61291 m .52901 .60538 L .52817 .60509 L p F P
0 g
s
.966 .687 .452 r
.52895 .627 m .52842 .61813 L .52632 .61607 L p F P
0 g
s
.615 .903 .985 r
.54492 .66296 m .54051 .66168 L .54518 .65965 L p F P
0 g
s
.615 .903 .985 r
.54518 .65965 m .55104 .66031 L .54492 .66296 L p F P
0 g
s
.957 .73 .554 r
.51936 .62562 m .52076 .61702 L .52138 .61768 L p F P
0 g
s
.957 .73 .554 r
.52138 .61768 m .52013 .62645 L .51936 .62562 L p F P
0 g
s
.575 .307 .472 r
.52497 .61231 m .52531 .60492 L .52439 .60511 L p F P
0 g
s
.575 .307 .472 r
.52439 .60511 m .52374 .61256 L .52497 .61231 L p F P
0 g
s
.41 .267 .574 r
.53131 .61763 m .53257 .62638 L .53153 .6271 L p F P
0 g
s
.262 .164 .551 r
.53257 .62638 m .53131 .61763 L .53191 .61697 L p F P
0 g
s
.821 .506 .457 r
.52817 .60509 m .52879 .61253 L .52991 .61291 L p F P
0 g
s
.763 .461 .473 r
.52879 .61253 m .52817 .60509 L .52724 .60491 L p F P
0 g
s
0 .062 .579 r
.44716 .58885 m .44984 .59637 L .4477 .60623 L p F P
0 g
s
.095 .18 .663 r
.45139 .61311 m .4477 .60623 L .44984 .59637 L p F P
0 g
s
.645 .365 .48 r
.52626 .61222 m .52628 .60486 L .52531 .60492 L p F P
0 g
s
.645 .365 .48 r
.52531 .60492 m .52497 .61231 L .52626 .61222 L p F P
0 g
s
.763 .461 .473 r
.52724 .60491 m .52756 .6123 L .52879 .61253 L p F P
0 g
s
.706 .415 .48 r
.52756 .6123 m .52724 .60491 L .52628 .60486 L p F P
0 g
s
.991 .755 .478 r
.60762 .57293 m .60685 .58044 L .60044 .57046 L p F P
0 g
s
.991 .755 .478 r
.60044 .57046 m .60115 .5628 L .60762 .57293 L p F P
0 g
s
.706 .415 .48 r
.52628 .60486 m .52626 .61222 L .52756 .6123 L p F P
0 g
s
.966 .687 .452 r
.56651 .74005 m .56398 .73014 L .55719 .72976 L p F P
0 g
s
.966 .687 .452 r
.5551 .71983 m .55719 .72976 L .56398 .73014 L p F P
0 g
s
.966 .687 .452 r
.54679 .68033 m .54472 .67051 L .54037 .669 L p F P
0 g
s
.999 .797 .499 r
.5189 .62472 m .5204 .6163 L .52076 .61702 L p F P
0 g
s
.999 .797 .499 r
.52076 .61702 m .51936 .62562 L .5189 .62472 L p F P
0 g
s
.109 0 .057 r
.48043 .51597 m .47791 .52069 L .46586 .52793 L p F P
0 g
s
.01 w
.46304 .51399 m
.46774 .51912 L
s
.5 Mabswid
.218 0 .217 r
.46343 .53369 m .46586 .52793 L .47791 .52069 L p F P
0 g
s
.262 .164 .551 r
.53191 .61697 m .53333 .62555 L .53257 .62638 L p F P
0 g
s
.018 .001 .491 r
.53333 .62555 m .53191 .61697 L .53225 .61624 L p F P
0 g
s
.979 .896 .666 r
.6049 .60541 m .60121 .61233 L .59885 .603 L p F P
0 g
s
.979 .896 .666 r
.59885 .603 m .60245 .59557 L .6049 .60541 L p F P
0 g
s
.17 .52 .918 r
.4788 .64899 m .48574 .65161 L .49036 .65632 L p F P
0 g
s
.312 .604 .95 r
.49695 .65726 m .49036 .65632 L .48574 .65161 L p F P
0 g
s
.251 .617 .957 r
.49036 .65632 m .49695 .65726 L .50205 .66055 L p F P
0 g
s
.059 0 .231 r
.46343 .53369 m .46173 .54007 L .45206 .54921 L p F P
0 g
s
.16 0 .358 r
.45098 .55623 m .45206 .54921 L .46173 .54007 L p F P
0 g
s
.859 .439 .226 r
.58588 .52728 m .58828 .53301 L .57552 .52564 L p F P
0 g
s
.859 .439 .226 r
.57552 .52564 m .57361 .52016 L .58588 .52728 L p F P
0 g
s
.39 0 .084 r
.49415 .51074 m .49629 .50718 L .51059 .5041 L p F P
0 g
s
.219 0 0 r
.49629 .50718 m .49415 .51074 L .48043 .51597 L p F P
0 g
s
.966 .687 .452 r
.56905 .74997 m .56651 .74005 L .55929 .73971 L p F P
0 g
s
.966 .687 .452 r
.55719 .72976 m .55929 .73971 L .56651 .74005 L p F P
0 g
s
.938 .808 .351 r
.5188 .62379 m .52032 .61555 L .5204 .6163 L p F P
0 g
s
.938 .808 .351 r
.5204 .6163 m .5189 .62472 L .5188 .62379 L p F P
0 g
s
.018 .001 .491 r
.53225 .61624 m .53375 .62465 L .53333 .62555 L p F P
0 g
s
0 0 .332 r
.53375 .62465 m .53225 .61624 L .53231 .61549 L p F P
0 g
s
.737 .946 .949 r
.56272 .65595 m .55604 .65697 L .55968 .65309 L p F P
0 g
s
.737 .946 .949 r
.55968 .65309 m .56719 .6512 L .56272 .65595 L p F P
0 g
s
.666 .181 .089 r
.55521 .50685 m .55727 .51039 L .54185 .50727 L p F P
0 g
s
.666 .181 .089 r
.54185 .50727 m .54081 .50393 L .55521 .50685 L p F P
0 g
s
.078 .286 .771 r
.45598 .61966 m .46143 .6258 L .46264 .63384 L p F P
0 g
s
.192 .386 .826 r
.46874 .63869 m .46264 .63384 L .46143 .6258 L p F P
0 g
s
.746 .521 .589 r
.52351 .63722 m .52398 .6281 L .52557 .62829 L p F P
0 g
s
.746 .521 .589 r
.52557 .62829 m .52542 .63745 L .52351 .63722 L p F P
0 g
s
.697 .48 .59 r
.52542 .63745 m .52557 .62829 L .52719 .62828 L p F P
0 g
s
.697 .48 .59 r
.52719 .62828 m .52737 .63744 L .52542 .63745 L p F P
0 g
s
.644 .438 .589 r
.52737 .63744 m .52719 .62828 L .52878 .62807 L p F P
0 g
s
.944 .61 .365 r
.59991 .54841 m .60097 .55542 L .59088 .5463 L p F P
0 g
s
.944 .61 .365 r
.59088 .5463 m .58996 .53938 L .59991 .54841 L p F P
0 g
s
0 0 0 r
.51904 .62286 m .52051 .61481 L .52032 .61555 L p F P
0 g
s
0 0 0 r
.52032 .61555 m .5188 .62379 L .51904 .62286 L p F P
0 g
s
.794 .563 .587 r
.52173 .63676 m .5225 .62771 L .52398 .6281 L p F P
0 g
s
.794 .563 .587 r
.52398 .6281 m .52351 .63722 L .52173 .63676 L p F P
0 g
s
.966 .687 .452 r
.52632 .61607 m .52632 .62444 L .52895 .627 L p F P
0 g
s
.644 .438 .589 r
.52878 .62807 m .52927 .63719 L .52737 .63744 L p F P
0 g
s
.152 .44 .874 r
.46874 .63869 m .47554 .64291 L .4788 .64899 L p F P
0 g
s
.275 .528 .912 r
.48574 .65161 m .4788 .64899 L .47554 .64291 L p F P
0 g
s
0 0 .332 r
.53231 .61549 m .53383 .62371 L .53375 .62465 L p F P
0 g
s
.798 .528 0 r
.53383 .62371 m .53231 .61549 L .53209 .61475 L p F P
0 g
s
.324 0 .171 r
.47791 .52069 m .48043 .51597 L .49415 .51074 L p F P
0 g
s
.966 .687 .452 r
.54886 .69017 m .54679 .68033 L .54195 .6787 L p F P
0 g
s
.966 .687 .452 r
.54037 .669 m .54195 .6787 L .54679 .68033 L p F P
0 g
s
.392 .683 .976 r
.50781 .65984 m .50205 .66055 L .49695 .65726 L p F P
0 g
s
.372 .708 .986 r
.50205 .66055 m .50781 .65984 L .51253 .66182 L p F P
0 g
s
.899 .957 .825 r
.59021 .63318 m .58409 .6381 L .58492 .63086 L p F P
0 g
s
.899 .957 .825 r
.58492 .63086 m .59116 .62514 L .59021 .63318 L p F P
0 g
s
.966 .687 .452 r
.5716 .7599 m .56905 .74997 L .56139 .74969 L p F P
0 g
s
.966 .687 .452 r
.55929 .73971 m .56139 .74969 L .56905 .74997 L p F P
0 g
s
.845 .61 .584 r
.52016 .63609 m .5212 .62715 L .5225 .62771 L p F P
0 g
s
.845 .61 .584 r
.5225 .62771 m .52173 .63676 L .52016 .63609 L p F P
0 g
s
.51 .338 .583 r
.53104 .63672 m .53024 .62767 L .53153 .6271 L p F P
0 g
s
.676 .912 .975 r
.55104 .66031 m .54518 .65965 L .54898 .65711 L p F P
0 g
s
.676 .912 .975 r
.54898 .65711 m .55604 .65697 L .55104 .66031 L p F P
0 g
s
.809 .958 .91 r
.57418 .6485 m .56719 .6512 L .56979 .64599 L p F P
0 g
s
.809 .958 .91 r
.56979 .64599 m .57725 .64239 L .57418 .6485 L p F P
0 g
s
.774 .324 .178 r
.57115 .51547 m .57361 .52016 L .55898 .51482 L p F P
0 g
s
.774 .324 .178 r
.55898 .51482 m .55727 .51039 L .57115 .51547 L p F P
0 g
s
0 0 .211 r
.51963 .62198 m .52098 .6141 L .52051 .61481 L p F P
0 g
s
0 0 .211 r
.52051 .61481 m .51904 .62286 L .51963 .62198 L p F P
0 g
s
.798 .528 0 r
.53209 .61475 m .53355 .62278 L .53383 .62371 L p F P
0 g
s
.955 .619 .227 r
.53355 .62278 m .53209 .61475 L .5316 .61405 L p F P
0 g
s
.9 .665 .575 r
.51888 .63525 m .52013 .62645 L .5212 .62715 L p F P
0 g
s
.9 .665 .575 r
.5212 .62715 m .52016 .63609 L .51888 .63525 L p F P
0 g
s
.51 .338 .583 r
.53153 .6271 m .53259 .63603 L .53104 .63672 L p F P
0 g
s
.41 .267 .574 r
.53259 .63603 m .53153 .6271 L .53257 .62638 L p F P
0 g
s
.072 .008 .47 r
.4508 .56361 m .45152 .57125 L .44542 .5813 L p F P
0 g
s
.162 .119 .558 r
.44716 .58885 m .44542 .5813 L .45152 .57125 L p F P
0 g
s
.966 .687 .452 r
.57414 .76985 m .5716 .7599 L .56349 .75968 L p F P
0 g
s
.966 .687 .452 r
.56139 .74969 m .56349 .75968 L .5716 .7599 L p F P
0 g
s
.966 .687 .452 r
.52949 .63591 m .52895 .627 L .52632 .62444 L p F P
0 g
s
.176 0 .354 r
.52053 .6212 m .5217 .61348 L .52098 .6141 L p F P
0 g
s
.176 0 .354 r
.52098 .6141 m .51963 .62198 L .52053 .6212 L p F P
0 g
s
.095 .18 .663 r
.44984 .59637 m .45345 .60375 L .45139 .61311 L p F P
0 g
s
.187 .278 .726 r
.45598 .61966 m .45139 .61311 L .45345 .60375 L p F P
0 g
s
.955 .619 .227 r
.5316 .61405 m .53294 .62191 L .53355 .62278 L p F P
0 g
s
.937 .598 .361 r
.53294 .62191 m .5316 .61405 L .53086 .61343 L p F P
0 g
s
.957 .73 .554 r
.51794 .63426 m .51936 .62562 L .52013 .62645 L p F P
0 g
s
.957 .73 .554 r
.52013 .62645 m .51888 .63525 L .51794 .63426 L p F P
0 g
s
.41 .267 .574 r
.53257 .62638 m .53384 .63517 L .53259 .63603 L p F P
0 g
s
.262 .164 .551 r
.53384 .63517 m .53257 .62638 L .53333 .62555 L p F P
0 g
s
.983 .786 .562 r
.60685 .58044 m .60512 .58802 L .59884 .57829 L p F P
0 g
s
.983 .786 .562 r
.59884 .57829 m .60044 .57046 L .60685 .58044 L p F P
0 g
s
.966 .687 .452 r
.55094 .70004 m .54886 .69017 L .54354 .68842 L p F P
0 g
s
.966 .687 .452 r
.54195 .6787 m .54354 .68842 L .54886 .69017 L p F P
0 g
s
.365 .132 .421 r
.5217 .62054 m .52263 .61295 L .5217 .61348 L p F P
0 g
s
.365 .132 .421 r
.5217 .61348 m .52053 .6212 L .5217 .62054 L p F P
0 g
s
.509 .061 .122 r
.50947 .50745 m .51059 .5041 L .52569 .503 L p F P
0 g
s
.39 0 .084 r
.51059 .5041 m .50947 .50745 L .49415 .51074 L p F P
0 g
s
.937 .598 .361 r
.53086 .61343 m .53202 .62114 L .53294 .62191 L p F P
0 g
s
.88 .552 .425 r
.53202 .62114 m .53086 .61343 L .52991 .61291 L p F P
0 g
s
.597 .133 .123 r
.54081 .50393 m .54185 .50727 L .52564 .50627 L p F P
0 g
s
.597 .133 .123 r
.52564 .50627 m .52569 .503 L .54081 .50393 L p F P
0 g
s
.957 .901 .726 r
.60121 .61233 m .59661 .61894 L .59438 .61021 L p F P
0 g
s
.957 .901 .726 r
.59438 .61021 m .59885 .603 L .60121 .61233 L p F P
0 g
s
.966 .687 .452 r
.57669 .7798 m .57414 .76985 L .5656 .7697 L p F P
0 g
s
.966 .687 .452 r
.56349 .75968 m .5656 .7697 L .57414 .76985 L p F P
0 g
s
.999 .797 .499 r
.5174 .63319 m .5189 .62472 L .51936 .62562 L p F P
0 g
s
.999 .797 .499 r
.51936 .62562 m .51794 .63426 L .5174 .63319 L p F P
0 g
s
.262 .164 .551 r
.53333 .62555 m .53475 .63418 L .53384 .63517 L p F P
0 g
s
.018 .001 .491 r
.53475 .63418 m .53333 .62555 L .53375 .62465 L p F P
0 g
s
.487 .234 .455 r
.52309 .62005 m .52374 .61256 L .52263 .61295 L p F P
0 g
s
.487 .234 .455 r
.52263 .61295 m .5217 .62054 L .52309 .62005 L p F P
0 g
s
.88 .552 .425 r
.52991 .61291 m .53083 .6205 L .53202 .62114 L p F P
0 g
s
.821 .506 .457 r
.53083 .6205 m .52991 .61291 L .52879 .61253 L p F P
0 g
s
.575 .307 .472 r
.52463 .61974 m .52497 .61231 L .52374 .61256 L p F P
0 g
s
.575 .307 .472 r
.52374 .61256 m .52309 .62005 L .52463 .61974 L p F P
0 g
s
.821 .506 .457 r
.52879 .61253 m .52942 .62002 L .53083 .6205 L p F P
0 g
s
.763 .461 .473 r
.52942 .62002 m .52879 .61253 L .52756 .6123 L p F P
0 g
s
.192 .386 .826 r
.46143 .6258 m .46768 .63146 L .46874 .63869 L p F P
0 g
s
.286 .467 .864 r
.47554 .64291 m .46874 .63869 L .46768 .63146 L p F P
0 g
s
.509 .061 .122 r
.52569 .503 m .52564 .50627 L .50947 .50745 L p F P
0 g
s
.645 .365 .48 r
.52625 .61963 m .52626 .61222 L .52497 .61231 L p F P
0 g
s
.645 .365 .48 r
.52497 .61231 m .52463 .61974 L .52625 .61963 L p F P
0 g
s
.746 .521 .589 r
.52304 .64639 m .52351 .63722 L .52542 .63745 L p F P
0 g
s
.746 .521 .589 r
.52542 .63745 m .52527 .64666 L .52304 .64639 L p F P
0 g
s
.697 .48 .59 r
.52527 .64666 m .52542 .63745 L .52737 .63744 L p F P
0 g
s
.763 .461 .473 r
.52756 .6123 m .52787 .61973 L .52942 .62002 L p F P
0 g
s
.706 .415 .48 r
.52787 .61973 m .52756 .6123 L .52626 .61222 L p F P
0 g
s
.697 .48 .59 r
.52737 .63744 m .52755 .64664 L .52527 .64666 L p F P
0 g
s
.644 .438 .589 r
.52755 .64664 m .52737 .63744 L .52927 .63719 L p F P
0 g
s
.16 0 .358 r
.46173 .54007 m .46079 .547 L .45098 .55623 L p F P
0 g
s
.238 .08 .454 r
.4508 .56361 m .45098 .55623 L .46079 .547 L p F P
0 g
s
.706 .415 .48 r
.52626 .61222 m .52625 .61963 L .52787 .61973 L p F P
0 g
s
.218 0 .217 r
.47791 .52069 m .47596 .52618 L .46343 .53369 L p F P
0 g
s
.01 w
.46774 .51912 m
.47204 .52381 L
s
.5 Mabswid
.298 .036 .337 r
.46173 .54007 m .46343 .53369 L .47596 .52618 L p F P
0 g
s
.966 .687 .452 r
.57924 .78977 m .57669 .7798 L .56771 .77973 L p F P
0 g
s
.966 .687 .452 r
.5656 .7697 m .56771 .77973 L .57669 .7798 L p F P
0 g
s
.938 .808 .351 r
.51727 .63207 m .5188 .62379 L .5189 .62472 L p F P
0 g
s
.938 .808 .351 r
.5189 .62472 m .5174 .63319 L .51727 .63207 L p F P
0 g
s
.018 .001 .491 r
.53375 .62465 m .53526 .6331 L .53475 .63418 L p F P
0 g
s
0 0 .332 r
.53526 .6331 m .53375 .62465 L .53383 .62371 L p F P
0 g
s
.794 .563 .587 r
.52095 .64585 m .52173 .63676 L .52351 .63722 L p F P
0 g
s
.794 .563 .587 r
.52351 .63722 m .52304 .64639 L .52095 .64585 L p F P
0 g
s
.644 .438 .589 r
.52927 .63719 m .52978 .64635 L .52755 .64664 L p F P
0 g
s
.312 .604 .95 r
.48574 .65161 m .4932 .65342 L .49695 .65726 L p F P
0 g
s
.421 .662 .961 r
.50393 .65733 m .49695 .65726 L .4932 .65342 L p F P
0 g
s
.392 .683 .976 r
.49695 .65726 m .50393 .65733 L .50781 .65984 L p F P
0 g
s
.87 .938 .862 r
.58409 .6381 m .57725 .64239 L .57796 .63602 L p F P
0 g
s
.87 .938 .862 r
.57796 .63602 m .58492 .63086 L .58409 .6381 L p F P
0 g
s
.966 .687 .452 r
.55302 .70993 m .55094 .70004 L .54514 .69818 L p F P
0 g
s
.966 .687 .452 r
.54354 .68842 m .54514 .69818 L .55094 .70004 L p F P
0 g
s
.723 .905 .959 r
.55604 .65697 m .54898 .65711 L .55174 .65415 L p F P
0 g
s
.723 .905 .959 r
.55174 .65415 m .55968 .65309 L .55604 .65697 L p F P
0 g
s
.275 .528 .912 r
.47554 .64291 m .48298 .64643 L .48574 .65161 L p F P
0 g
s
.374 .595 .931 r
.4932 .65342 m .48574 .65161 L .48298 .64643 L p F P
0 g
s
.845 .61 .584 r
.51912 .64508 m .52016 .63609 L .52173 .63676 L p F P
0 g
s
.845 .61 .584 r
.52173 .63676 m .52095 .64585 L .51912 .64508 L p F P
0 g
s
.88 .511 .343 r
.58828 .53301 m .58996 .53938 L .57686 .53183 L p F P
0 g
s
.88 .511 .343 r
.57686 .53183 m .57552 .52564 L .58828 .53301 L p F P
0 g
s
.51 .338 .583 r
.53184 .6458 m .53104 .63672 L .53259 .63603 L p F P
0 g
s
.946 .657 .459 r
.60097 .55542 m .60115 .5628 L .59104 .5537 L p F P
0 g
s
.01 w
.52632 .58304 m
.5981 .56006 L
s
.60106 .55911 m
.60151 .55897 L
s
.5 Mabswid
.946 .657 .459 r
.59104 .5537 m .59088 .5463 L .60097 .55542 L p F P
0 g
s
.783 .924 .93 r
.56719 .6512 m .55968 .65309 L .56178 .64884 L p F P
0 g
s
.783 .924 .93 r
.56178 .64884 m .56979 .64599 L .56719 .6512 L p F P
0 g
s
0 0 0 r
.51756 .63096 m .51904 .62286 L .5188 .62379 L p F P
0 g
s
0 0 0 r
.5188 .62379 m .51727 .63207 L .51756 .63096 L p F P
0 g
s
.966 .687 .452 r
.52632 .62444 m .52632 .63285 L .52949 .63591 L p F P
0 g
s
.966 .687 .452 r
.5818 .79976 m .57924 .78977 L .56983 .78979 L p F P
0 g
s
.966 .687 .452 r
.56771 .77973 m .56983 .78979 L .57924 .78977 L p F P
0 g
s
0 0 .332 r
.53383 .62371 m .53535 .63197 L .53526 .6331 L p F P
0 g
s
.798 .528 0 r
.53535 .63197 m .53383 .62371 L .53355 .62278 L p F P
0 g
s
.162 .119 .558 r
.45152 .57125 m .45314 .57906 L .44716 .58885 L p F P
0 g
s
.235 .21 .625 r
.44984 .59637 m .44716 .58885 L .45314 .57906 L p F P
0 g
s
.51 .338 .583 r
.53259 .63603 m .53365 .645 L .53184 .6458 L p F P
0 g
s
.41 .267 .574 r
.53365 .645 m .53259 .63603 L .53384 .63517 L p F P
0 g
s
.187 .278 .726 r
.45345 .60375 m .45795 .61092 L .45598 .61966 L p F P
0 g
s
.265 .359 .774 r
.46143 .6258 m .45598 .61966 L .45795 .61092 L p F P
0 g
s
.966 .687 .452 r
.54195 .6787 m .54037 .669 L .53581 .66646 L p F P
0 g
s
.466 .084 .231 r
.49237 .51519 m .49415 .51074 L .50947 .50745 L p F P
0 g
s
.324 0 .171 r
.49415 .51074 m .49237 .51519 L .47791 .52069 L p F P
0 g
s
.966 .687 .452 r
.53003 .64487 m .52949 .63591 L .52632 .63285 L p F P
0 g
s
0 0 .211 r
.51827 .62991 m .51963 .62198 L .51904 .62286 L p F P
0 g
s
0 0 .211 r
.51904 .62286 m .51756 .63096 L .51827 .62991 L p F P
0 g
s
.798 .528 0 r
.53355 .62278 m .53503 .63087 L .53535 .63197 L p F P
0 g
s
.955 .619 .227 r
.53503 .63087 m .53355 .62278 L .53294 .62191 L p F P
0 g
s
.716 .29 .234 r
.55727 .51039 m .55898 .51482 L .54271 .51153 L p F P
0 g
s
.716 .29 .234 r
.54271 .51153 m .54185 .50727 L .55727 .51039 L p F P
0 g
s
.968 .805 .627 r
.60512 .58802 m .60245 .59557 L .59636 .58622 L p F P
0 g
s
.968 .805 .627 r
.59636 .58622 m .59884 .57829 L .60512 .58802 L p F P
0 g
s
.396 .074 .297 r
.47596 .52618 m .47791 .52069 L .49237 .51519 L p F P
0 g
s
.931 .898 .773 r
.59661 .61894 m .59116 .62514 L .58907 .61712 L p F P
0 g
s
.931 .898 .773 r
.58907 .61712 m .59438 .61021 L .59661 .61894 L p F P
0 g
s
.966 .687 .452 r
.58436 .80975 m .5818 .79976 L .57195 .79987 L p F P
0 g
s
.966 .687 .452 r
.56983 .78979 m .57195 .79987 L .5818 .79976 L p F P
0 g
s
.966 .687 .452 r
.5551 .71983 m .55302 .70993 L .54674 .70796 L p F P
0 g
s
.966 .687 .452 r
.54514 .69818 m .54674 .70796 L .55302 .70993 L p F P
0 g
s
.676 .867 .972 r
.54161 .65636 m .54898 .65711 L .54518 .65965 L p F P
0 g
s
.41 .267 .574 r
.53384 .63517 m .53512 .644 L .53365 .645 L p F P
0 g
s
.262 .164 .551 r
.53512 .644 m .53384 .63517 L .53475 .63418 L p F P
0 g
s
.805 .408 .302 r
.57361 .52016 m .57552 .52564 L .5603 .52009 L p F P
0 g
s
.805 .408 .302 r
.5603 .52009 m .55898 .51482 L .57361 .52016 L p F P
0 g
s
.176 0 .354 r
.51935 .62897 m .52053 .6212 L .51963 .62198 L p F P
0 g
s
.176 0 .354 r
.51963 .62198 m .51827 .62991 L .51935 .62897 L p F P
0 g
s
.937 .598 .361 r
.53429 .62982 m .53294 .62191 L .53202 .62114 L p F P
0 g
s
.955 .619 .227 r
.53294 .62191 m .53429 .62982 L .53503 .63087 L p F P
0 g
s
.286 .467 .864 r
.46768 .63146 m .47464 .63655 L .47554 .64291 L p F P
0 g
s
.365 .533 .889 r
.48298 .64643 m .47554 .64291 L .47464 .63655 L p F P
0 g
s
.966 .687 .452 r
.58692 .81976 m .58436 .80975 L .57407 .80998 L p F P
0 g
s
.966 .687 .452 r
.57195 .79987 m .57407 .80998 L .58436 .80975 L p F P
0 g
s
.262 .164 .551 r
.53475 .63418 m .53618 .64285 L .53512 .644 L p F P
0 g
s
.018 .001 .491 r
.53618 .64285 m .53475 .63418 L .53526 .6331 L p F P
0 g
s
.644 .438 .589 r
.52773 .65588 m .52755 .64664 L .52978 .64635 L p F P
0 g
s
.838 .915 .887 r
.57725 .64239 m .56979 .64599 L .57036 .64056 L p F P
0 g
s
.838 .915 .887 r
.57036 .64056 m .57796 .63602 L .57725 .64239 L p F P
0 g
s
.365 .132 .421 r
.52076 .62818 m .5217 .62054 L .52053 .6212 L p F P
0 g
s
.365 .132 .421 r
.52053 .6212 m .51935 .62897 L .52076 .62818 L p F P
0 g
s
.644 .438 .589 r
.52978 .64635 m .53028 .65555 L .52773 .65588 L p F P
0 g
s
.937 .598 .361 r
.53202 .62114 m .53318 .6289 L .53429 .62982 L p F P
0 g
s
.88 .552 .425 r
.53318 .6289 m .53202 .62114 L .53083 .6205 L p F P
0 g
s
.966 .687 .452 r
.54354 .68842 m .54195 .6787 L .53689 .67591 L p F P
0 g
s
.966 .687 .452 r
.53581 .66646 m .53689 .67591 L .54195 .6787 L p F P
0 g
s
.238 .08 .454 r
.46079 .547 m .46063 .5544 L .4508 .56361 L p F P
0 g
s
.299 .168 .529 r
.45152 .57125 m .4508 .56361 L .46063 .5544 L p F P
0 g
s
.966 .687 .452 r
.55719 .72976 m .5551 .71983 L .54834 .71777 L p F P
0 g
s
.966 .687 .452 r
.54674 .70796 m .54834 .71777 L .5551 .71983 L p F P
0 g
s
.966 .687 .452 r
.58949 .82978 m .58692 .81976 L .5762 .8201 L p F P
0 g
s
.966 .687 .452 r
.57407 .80998 m .5762 .8201 L .58692 .81976 L p F P
0 g
s
.374 .595 .931 r
.48298 .64643 m .49097 .6492 L .4932 .65342 L p F P
0 g
s
.455 .646 .94 r
.50108 .65441 m .4932 .65342 L .49097 .6492 L p F P
0 g
s
.421 .662 .961 r
.4932 .65342 m .50108 .65441 L .50393 .65733 L p F P
0 g
s
.51 .338 .583 r
.53264 .65492 m .53184 .6458 L .53365 .645 L p F P
0 g
s
.938 .808 .351 r
.51573 .64039 m .51727 .63207 L .5174 .63319 L p F P
0 g
s
.487 .234 .455 r
.52243 .62759 m .52309 .62005 L .5217 .62054 L p F P
0 g
s
.487 .234 .455 r
.5217 .62054 m .52076 .62818 L .52243 .62759 L p F P
0 g
s
.88 .552 .425 r
.53083 .6205 m .53175 .62813 L .53318 .6289 L p F P
0 g
s
.821 .506 .457 r
.53175 .62813 m .53083 .6205 L .52942 .62002 L p F P
0 g
s
.018 .001 .491 r
.53526 .6331 m .53678 .64159 L .53618 .64285 L p F P
0 g
s
0 0 .332 r
.53678 .64159 m .53526 .6331 L .53535 .63197 L p F P
0 g
s
.265 .359 .774 r
.45795 .61092 m .46327 .61777 L .46143 .6258 L p F P
0 g
s
.331 .428 .811 r
.46768 .63146 m .46143 .6258 L .46327 .61777 L p F P
0 g
s
.235 .21 .625 r
.45314 .57906 m .45564 .58696 L .44984 .59637 L p F P
0 g
s
.295 .286 .679 r
.45345 .60375 m .44984 .59637 L .45564 .58696 L p F P
0 g
s
.505 .702 .958 r
.51121 .65652 m .50393 .65733 L .50108 .65441 L p F P
0 g
s
.754 .888 .939 r
.55968 .65309 m .55174 .65415 L .55332 .65092 L p F P
0 g
s
.754 .888 .939 r
.55332 .65092 m .56178 .64884 L .55968 .65309 L p F P
0 g
s
.298 .036 .337 r
.47596 .52618 m .47459 .53239 L .46173 .54007 L p F P
0 g
s
.357 .131 .427 r
.46079 .547 m .46173 .54007 L .47459 .53239 L p F P
0 g
s
.94 .69 .532 r
.60115 .5628 m .60044 .57046 L .59042 .56148 L p F P
0 g
s
.94 .69 .532 r
.59042 .56148 m .59104 .5537 L .60115 .5628 L p F P
0 g
s
.575 .307 .472 r
.52428 .62722 m .52463 .61974 L .52309 .62005 L p F P
0 g
s
.575 .307 .472 r
.52309 .62005 m .52243 .62759 L .52428 .62722 L p F P
0 g
s
.704 .862 .957 r
.54898 .65711 m .54161 .65636 L .54346 .65437 L p F P
0 g
s
.704 .862 .957 r
.54346 .65437 m .55174 .65415 L .54898 .65711 L p F P
0 g
s
.568 .175 .257 r
.50854 .51172 m .50947 .50745 L .52564 .50627 L p F P
0 g
s
.466 .084 .231 r
.50947 .50745 m .50854 .51172 L .49237 .51519 L p F P
0 g
s
.821 .506 .457 r
.52942 .62002 m .53006 .62755 L .53175 .62813 L p F P
0 g
s
.763 .461 .473 r
.53006 .62755 m .52942 .62002 L .52787 .61973 L p F P
0 g
s
.648 .241 .258 r
.54185 .50727 m .54271 .51153 L .52561 .51048 L p F P
0 g
s
.648 .241 .258 r
.52561 .51048 m .52564 .50627 L .54185 .50727 L p F P
0 g
s
.902 .89 .809 r
.59116 .62514 m .58492 .63086 L .58301 .62364 L p F P
0 g
s
.902 .89 .809 r
.58301 .62364 m .58907 .61712 L .59116 .62514 L p F P
0 g
s
.51 .338 .583 r
.53365 .645 m .53472 .65402 L .53264 .65492 L p F P
0 g
s
.41 .267 .574 r
.53472 .65402 m .53365 .645 L .53512 .644 L p F P
0 g
s
.645 .365 .48 r
.52623 .62709 m .52625 .61963 L .52463 .61974 L p F P
0 g
s
.645 .365 .48 r
.52463 .61974 m .52428 .62722 L .52623 .62709 L p F P
0 g
s
.763 .461 .473 r
.52787 .61973 m .52819 .6272 L .53006 .62755 L p F P
0 g
s
.706 .415 .48 r
.52819 .6272 m .52787 .61973 L .52625 .61963 L p F P
0 g
s
.706 .415 .48 r
.52625 .61963 m .52623 .62709 L .52819 .6272 L p F P
0 g
s
.966 .687 .452 r
.59205 .83981 m .58949 .82978 L .57834 .83025 L p F P
0 g
s
.966 .687 .452 r
.5762 .8201 m .57834 .83025 L .58949 .82978 L p F P
0 g
s
.886 .563 .431 r
.58996 .53938 m .59088 .5463 L .57759 .53867 L p F P
0 g
s
.886 .563 .431 r
.57759 .53867 m .57686 .53183 L .58996 .53938 L p F P
0 g
s
.949 .816 .679 r
.60245 .59557 m .59885 .603 L .59303 .59413 L p F P
0 g
s
.949 .816 .679 r
.59303 .59413 m .59636 .58622 L .60245 .59557 L p F P
0 g
s
0 0 0 r
.51607 .6391 m .51756 .63096 L .51727 .63207 L p F P
0 g
s
0 0 0 r
.51727 .63207 m .51573 .64039 L .51607 .6391 L p F P
0 g
s
.966 .687 .452 r
.52632 .63285 m .52632 .64131 L .53003 .64487 L p F P
0 g
s
0 0 .332 r
.53535 .63197 m .53689 .64028 L .53678 .64159 L p F P
0 g
s
.798 .528 0 r
.53689 .64028 m .53535 .63197 L .53503 .63087 L p F P
0 g
s
.966 .687 .452 r
.53057 .65386 m .53003 .64487 L .52632 .64131 L p F P
0 g
s
.966 .687 .452 r
.55929 .73971 m .55719 .72976 L .54995 .72762 L p F P
0 g
s
.966 .687 .452 r
.54834 .71777 m .54995 .72762 L .55719 .72976 L p F P
0 g
s
.365 .533 .889 r
.47464 .63655 m .48224 .64101 L .48298 .64643 L p F P
0 g
s
.432 .589 .907 r
.49097 .6492 m .48298 .64643 L .48224 .64101 L p F P
0 g
s
.568 .175 .257 r
.52564 .50627 m .52561 .51048 L .50854 .51172 L p F P
0 g
s
.966 .687 .452 r
.59463 .84986 m .59205 .83981 L .58048 .84042 L p F P
0 g
s
.966 .687 .452 r
.57834 .83025 m .58048 .84042 L .59205 .83981 L p F P
0 g
s
.805 .889 .905 r
.56979 .64599 m .56178 .64884 L .56222 .64443 L p F P
0 g
s
.805 .889 .905 r
.56222 .64443 m .57036 .64056 L .56979 .64599 L p F P
0 g
s
.966 .687 .452 r
.54514 .69818 m .54354 .68842 L .53797 .68539 L p F P
0 g
s
.966 .687 .452 r
.53689 .67591 m .53797 .68539 L .54354 .68842 L p F P
0 g
s
0 0 .211 r
.5169 .63788 m .51827 .62991 L .51756 .63096 L p F P
0 g
s
0 0 .211 r
.51756 .63096 m .51607 .6391 L .5169 .63788 L p F P
0 g
s
.798 .528 0 r
.53503 .63087 m .53651 .63899 L .53689 .64028 L p F P
0 g
s
.955 .619 .227 r
.53651 .63899 m .53503 .63087 L .53429 .62982 L p F P
0 g
s
.331 .428 .811 r
.46327 .61777 m .46936 .62423 L .46768 .63146 L p F P
0 g
s
.388 .488 .84 r
.47464 .63655 m .46768 .63146 L .46936 .62423 L p F P
0 g
s
.396 .074 .297 r
.49237 .51519 m .491 .52047 L .47596 .52618 L p F P
0 g
s
.447 .164 .39 r
.47459 .53239 m .47596 .52618 L .491 .52047 L p F P
0 g
s
.516 .18 .338 r
.491 .52047 m .49237 .51519 L .50854 .51172 L p F P
0 g
s
.966 .687 .452 r
.5972 .85992 m .59463 .84986 L .58263 .85061 L p F P
0 g
s
.966 .687 .452 r
.58048 .84042 m .58263 .85061 L .59463 .84986 L p F P
0 g
s
.966 .687 .452 r
.56139 .74969 m .55929 .73971 L .55156 .73749 L p F P
0 g
s
.966 .687 .452 r
.54995 .72762 m .55156 .73749 L .55929 .73971 L p F P
0 g
s
.295 .286 .679 r
.45564 .58696 m .45899 .59483 L .45345 .60375 L p F P
0 g
s
.347 .352 .723 r
.45795 .61092 m .45345 .60375 L .45899 .59483 L p F P
0 g
s
.299 .168 .529 r
.46063 .5544 m .46126 .56217 L .45152 .57125 L p F P
0 g
s
.348 .241 .588 r
.45314 .57906 m .45152 .57125 L .46126 .56217 L p F P
0 g
s
.455 .646 .94 r
.49097 .6492 m .4994 .65119 L .50108 .65441 L p F P
0 g
s
.522 .687 .942 r
.50929 .65454 m .50108 .65441 L .4994 .65119 L p F P
0 g
s
.505 .702 .958 r
.50108 .65441 m .50929 .65454 L .51121 .65652 L p F P
0 g
s
.176 0 .354 r
.51816 .63678 m .51935 .62897 L .51827 .62991 L p F P
0 g
s
.176 0 .354 r
.51827 .62991 m .5169 .63788 L .51816 .63678 L p F P
0 g
s
.872 .879 .838 r
.58492 .63086 m .57796 .63602 L .57625 .62969 L p F P
0 g
s
.872 .879 .838 r
.57625 .62969 m .58301 .62364 L .58492 .63086 L p F P
0 g
s
.743 .367 .34 r
.55898 .51482 m .5603 .52009 L .54337 .51668 L p F P
0 g
s
.743 .367 .34 r
.54337 .51668 m .54271 .51153 L .55898 .51482 L p F P
0 g
s
.937 .598 .361 r
.53565 .63778 m .53429 .62982 L .53318 .6289 L p F P
0 g
s
.955 .619 .227 r
.53429 .62982 m .53565 .63778 L .53651 .63899 L p F P
0 g
s
.819 .469 .393 r
.57552 .52564 m .57686 .53183 L .56123 .52616 L p F P
0 g
s
.819 .469 .393 r
.56123 .52616 m .5603 .52009 L .57552 .52564 L p F P
0 g
s
.725 .85 .941 r
.55174 .65415 m .54346 .65437 L .54452 .65219 L p F P
0 g
s
.725 .85 .941 r
.54452 .65219 m .55332 .65092 L .55174 .65415 L p F P
0 g
s
.927 .822 .722 r
.59885 .603 m .59438 .61021 L .5889 .60193 L p F P
0 g
s
.927 .822 .722 r
.5889 .60193 m .59303 .59413 L .59885 .603 L p F P
0 g
s
.93 .714 .59 r
.60044 .57046 m .59884 .57829 L .58902 .56955 L p F P
0 g
s
.93 .714 .59 r
.58902 .56955 m .59042 .56148 L .60044 .57046 L p F P
0 g
s
.966 .687 .452 r
.59978 .86999 m .5972 .85992 L .58478 .86083 L p F P
0 g
s
.966 .687 .452 r
.58263 .85061 m .58478 .86083 L .5972 .85992 L p F P
0 g
s
.365 .132 .421 r
.51981 .63587 m .52076 .62818 L .51935 .62897 L p F P
0 g
s
.365 .132 .421 r
.51935 .62897 m .51816 .63678 L .51981 .63587 L p F P
0 g
s
.432 .589 .907 r
.48224 .64101 m .49038 .6448 L .49097 .6492 L p F P
0 g
s
.49 .635 .918 r
.4994 .65119 m .49097 .6492 L .49038 .6448 L p F P
0 g
s
.937 .598 .361 r
.53318 .6289 m .53435 .6367 L .53565 .63778 L p F P
0 g
s
.88 .552 .425 r
.53435 .6367 m .53318 .6289 L .53175 .62813 L p F P
0 g
s
.966 .687 .452 r
.54674 .70796 m .54514 .69818 L .53905 .69491 L p F P
0 g
s
.966 .687 .452 r
.53797 .68539 m .53905 .69491 L .54514 .69818 L p F P
0 g
s
.357 .131 .427 r
.47459 .53239 m .47383 .53923 L .46079 .547 L p F P
0 g
s
.403 .207 .497 r
.46063 .5544 m .46079 .547 L .47383 .53923 L p F P
0 g
s
.772 .862 .917 r
.56178 .64884 m .55332 .65092 L .55364 .64757 L p F P
0 g
s
.772 .862 .917 r
.55364 .64757 m .56222 .64443 L .56178 .64884 L p F P
0 g
s
.966 .687 .452 r
.56349 .75968 m .56139 .74969 L .55318 .74739 L p F P
0 g
s
.966 .687 .452 r
.55156 .73749 m .55318 .74739 L .56139 .74969 L p F P
0 g
s
.487 .234 .455 r
.52177 .63518 m .52243 .62759 L .52076 .62818 L p F P
0 g
s
.487 .234 .455 r
.52076 .62818 m .51981 .63587 L .52177 .63518 L p F P
0 g
s
.88 .552 .425 r
.53175 .62813 m .53267 .63581 L .53435 .6367 L p F P
0 g
s
.821 .506 .457 r
.53267 .63581 m .53175 .62813 L .53006 .62755 L p F P
0 g
s
.388 .488 .84 r
.46936 .62423 m .47615 .6302 L .47464 .63655 L p F P
0 g
s
.438 .54 .863 r
.48224 .64101 m .47464 .63655 L .47615 .6302 L p F P
0 g
s
.966 .687 .452 r
.58478 .86083 m .58693 .87106 L .59978 .86999 L p F P
0 g
s
.641 .775 .945 r
.52632 .65225 m .52935 .65678 L .5274 .65703 L closepath p F P
0 g
s
.966 .687 .452 r
.53057 .65386 m .52632 .64981 L p .52769 .65355 L F P
0 g
s
.966 .687 .452 r
.53072 .65644 m .53057 .65386 L p .52769 .65355 L F P
0 g
s
.646 .777 .943 r
.5307 .65642 m .52935 .65678 L .52632 .65225 L p F P
0 g
s
.636 .772 .945 r
.52632 .65225 m .5274 .65703 L .5254 .65704 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .64981 m .52632 .65836 L .53111 .6629 L p F P
0 g
s
.646 .777 .943 r
.52632 .65225 m .53115 .6563 L .5307 .65642 L p F P
0 g
s
.966 .687 .452 r
.53111 .6629 m .53072 .65644 L p .52769 .65355 L F P
0 g
s
.966 .687 .452 r
.52632 .64131 m .52632 .64981 L .53057 .65386 L p F P
0 g
s
.886 .601 .5 r
.59088 .5463 m .59104 .5537 L .57772 .54608 L p F P
0 g
s
.886 .601 .5 r
.57772 .54608 m .57759 .53867 L .59088 .5463 L p F P
0 g
s
.798 .528 0 r
.53843 .64864 m .53689 .64028 L .53651 .63899 L p F P
0 g
s
.575 .307 .472 r
.52394 .63475 m .52428 .62722 L .52243 .62759 L p F P
0 g
s
.575 .307 .472 r
.52243 .62759 m .52177 .63518 L .52394 .63475 L p F P
0 g
s
.632 .768 .945 r
.52632 .65225 m .5254 .65704 L .52344 .65681 L closepath p F P
0 g
s
.841 .866 .861 r
.57796 .63602 m .57036 .64056 L .56888 .63518 L p F P
0 g
s
.841 .866 .861 r
.56888 .63518 m .57625 .62969 L .57796 .63602 L p F P
0 g
s
.821 .506 .457 r
.53006 .62755 m .53069 .63514 L .53267 .63581 L p F P
0 g
s
.763 .461 .473 r
.53069 .63514 m .53006 .62755 L .52819 .6272 L p F P
0 g
s
.347 .352 .723 r
.45899 .59483 m .46316 .60258 L .45795 .61092 L p F P
0 g
s
.391 .409 .759 r
.46327 .61777 m .45795 .61092 L .46316 .60258 L p F P
0 g
s
.629 .764 .944 r
.52632 .65225 m .52344 .65681 L .52162 .65635 L closepath p F P
0 g
s
.645 .365 .48 r
.52622 .6346 m .52623 .62709 L .52428 .62722 L p F P
0 g
s
.645 .365 .48 r
.52428 .62722 m .52394 .63475 L .52622 .6346 L p F P
0 g
s
.746 .521 .589 r
.5216 .67412 m .52208 .66484 L .52496 .66518 L p F P
0 g
s
.746 .521 .589 r
.52496 .66518 m .52481 .6745 L .5216 .67412 L p F P
0 g
s
.697 .48 .59 r
.52481 .6745 m .52496 .66518 L .52791 .66516 L p F P
0 g
s
.763 .461 .473 r
.52819 .6272 m .52851 .63473 L .53069 .63514 L p F P
0 g
s
.706 .415 .48 r
.52851 .63473 m .52819 .6272 L .52623 .62709 L p F P
0 g
s
.697 .48 .59 r
.52791 .66516 m .52809 .67448 L .52481 .6745 L p F P
0 g
s
.644 .438 .589 r
.52809 .67448 m .52791 .66516 L .53078 .66479 L p F P
0 g
s
.706 .415 .48 r
.52623 .62709 m .52622 .6346 L .52851 .63473 L p F P
0 g
s
.605 .258 .355 r
.50782 .51688 m .50854 .51172 L .52561 .51048 L p F P
0 g
s
.516 .18 .338 r
.50854 .51172 m .50782 .51688 L .491 .52047 L p F P
0 g
s
.522 .687 .942 r
.4994 .65119 m .50817 .65238 L .50929 .65454 L p F P
0 g
s
.627 .759 .942 r
.52632 .65225 m .52162 .65635 L .52001 .65567 L closepath p F P
0 g
s
.794 .563 .587 r
.5186 .67337 m .51939 .66416 L .52208 .66484 L p F P
0 g
s
.794 .563 .587 r
.52208 .66484 m .5216 .67412 L .5186 .67337 L p F P
0 g
s
.651 .779 .942 r
.52632 .65225 m .53274 .65561 L .53115 .6563 L closepath p F P
0 g
s
.644 .438 .589 r
.53078 .66479 m .53129 .67407 L .52809 .67448 L p F P
0 g
s
.678 .318 .356 r
.54271 .51153 m .54337 .51668 L .52558 .51559 L p F P
0 g
s
.678 .318 .356 r
.52558 .51559 m .52561 .51048 L .54271 .51153 L p F P
0 g
s
.348 .241 .588 r
.46126 .56217 m .46268 .57022 L .45314 .57906 L p F P
0 g
s
.389 .303 .637 r
.45564 .58696 m .45314 .57906 L .46268 .57022 L p F P
0 g
s
.905 .825 .757 r
.59438 .61021 m .58907 .61712 L .584 .60952 L p F P
0 g
s
.905 .825 .757 r
.584 .60952 m .5889 .60193 L .59438 .61021 L p F P
0 g
s
.49 .635 .918 r
.49038 .6448 m .49897 .64784 L .4994 .65119 L p F P
0 g
s
.541 .676 .926 r
.50817 .65238 m .4994 .65119 L .49897 .64784 L p F P
0 g
s
.966 .687 .452 r
.5656 .7697 m .56349 .75968 L .55481 .75733 L p F P
0 g
s
.966 .687 .452 r
.55318 .74739 m .55481 .75733 L .56349 .75968 L p F P
0 g
s
.738 .834 .924 r
.55332 .65092 m .54452 .65219 L .54472 .64993 L p F P
0 g
s
.738 .834 .924 r
.54472 .64993 m .55364 .64757 L .55332 .65092 L p F P
0 g
s
.798 .528 0 r
.53651 .63899 m .538 .64717 L .53843 .64864 L p F P
0 g
s
.955 .619 .227 r
.538 .64717 m .53651 .63899 L .53565 .63778 L p F P
0 g
s
.966 .687 .452 r
.54834 .71777 m .54674 .70796 L .54014 .70447 L p F P
0 g
s
.966 .687 .452 r
.53905 .69491 m .54014 .70447 L .54674 .70796 L p F P
0 g
s
.626 .755 .939 r
.52632 .65225 m .52001 .65567 L .5187 .65481 L closepath p F P
0 g
s
.845 .61 .584 r
.51597 .67227 m .51702 .66316 L .51939 .66416 L p F P
0 g
s
.845 .61 .584 r
.51939 .66416 m .5186 .67337 L .51597 .67227 L p F P
0 g
s
.656 .779 .939 r
.52632 .65225 m .53402 .65474 L .53274 .65561 L closepath p F P
0 g
s
.438 .54 .863 r
.47615 .6302 m .48355 .63562 L .48224 .64101 L p F P
0 g
s
.483 .586 .882 r
.49038 .6448 m .48224 .64101 L .48355 .63562 L p F P
0 g
s
.51 .338 .583 r
.53426 .67329 m .53345 .66408 L .53579 .66307 L p F P
0 g
s
.917 .731 .637 r
.59884 .57829 m .59636 .58622 L .58687 .57781 L p F P
0 g
s
.917 .731 .637 r
.58687 .57781 m .58902 .56955 L .59884 .57829 L p F P
0 g
s
.605 .258 .355 r
.52561 .51048 m .52558 .51559 L .50782 .51688 L p F P
0 g
s
.81 .85 .88 r
.57036 .64056 m .56222 .64443 L .56099 .64005 L p F P
0 g
s
.81 .85 .88 r
.56099 .64005 m .56888 .63518 L .57036 .64056 L p F P
0 g
s
.447 .164 .39 r
.491 .52047 m .49003 .52654 L .47459 .53239 L p F P
0 g
s
.484 .235 .461 r
.47383 .53923 m .47459 .53239 L .49003 .52654 L p F P
0 g
s
.626 .751 .936 r
.52632 .65225 m .5187 .65481 L .51774 .65382 L closepath p F P
0 g
s
.661 .778 .936 r
.52632 .65225 m .53495 .65373 L .53402 .65474 L closepath p F P
0 g
s
.9 .665 .575 r
.51381 .67088 m .51508 .66191 L .51702 .66316 L p F P
0 g
s
.9 .665 .575 r
.51702 .66316 m .51597 .67227 L .51381 .67088 L p F P
0 g
s
.937 .598 .361 r
.53701 .64578 m .53565 .63778 L .53435 .6367 L p F P
0 g
s
.955 .619 .227 r
.53565 .63778 m .53701 .64578 L .538 .64717 L p F P
0 g
s
.391 .409 .759 r
.46316 .60258 m .46811 .61012 L .46327 .61777 L p F P
0 g
s
.43 .459 .789 r
.46936 .62423 m .46327 .61777 L .46811 .61012 L p F P
0 g
s
.825 .514 .463 r
.57686 .53183 m .57759 .53867 L .56174 .53294 L p F P
0 g
s
.825 .514 .463 r
.56174 .53294 m .56123 .52616 L .57686 .53183 L p F P
0 g
s
.51 .338 .583 r
.53579 .66307 m .53686 .67216 L .53426 .67329 L p F P
0 g
s
.41 .267 .574 r
.53686 .67216 m .53579 .66307 L .53769 .66179 L p F P
0 g
s
.55 .253 .417 r
.49003 .52654 m .491 .52047 L .50782 .51688 L p F P
0 g
s
.966 .687 .452 r
.56771 .77973 m .5656 .7697 L .55643 .76729 L p F P
0 g
s
.966 .687 .452 r
.55481 .75733 m .55643 .76729 L .5656 .7697 L p F P
0 g
s
.541 .676 .926 r
.49897 .64784 m .50789 .65012 L .50817 .65238 L p F P
0 g
s
.403 .207 .497 r
.47383 .53923 m .47371 .54664 L .46063 .5544 L p F P
0 g
s
.438 .269 .553 r
.46126 .56217 m .46063 .5544 L .47371 .54664 L p F P
0 g
s
.758 .424 .418 r
.5603 .52009 m .56123 .52616 L .54384 .52266 L p F P
0 g
s
.758 .424 .418 r
.54384 .52266 m .54337 .51668 L .5603 .52009 L p F P
0 g
s
.483 .586 .882 r
.48355 .63562 m .49147 .64041 L .49038 .6448 L p F P
0 g
s
.524 .629 .897 r
.49897 .64784 m .49038 .6448 L .49147 .64041 L p F P
0 g
s
.881 .824 .787 r
.58907 .61712 m .58301 .62364 L .5784 .6168 L p F P
0 g
s
.881 .824 .787 r
.5784 .6168 m .584 .60952 L .58907 .61712 L p F P
0 g
s
.627 .747 .933 r
.52632 .65225 m .51774 .65382 L .51718 .65273 L closepath p F P
0 g
s
.966 .687 .452 r
.53165 .67198 m .53111 .6629 L .52632 .65836 L p F P
0 g
s
.665 .777 .933 r
.52632 .65225 m .53548 .65264 L .53495 .65373 L closepath p F P
0 g
s
.01 w
.52632 .65309 m
.52632 .65755 L
s
.5 Mabswid
.777 .833 .895 r
.56222 .64443 m .55364 .64757 L .55269 .64425 L p F P
0 g
s
.777 .833 .895 r
.55269 .64425 m .56099 .64005 L .56222 .64443 L p F P
0 g
s
.365 .132 .421 r
.51886 .64361 m .51981 .63587 L .51816 .63678 L p F P
0 g
s
.881 .629 .554 r
.59104 .5537 m .59042 .56148 L .57722 .55397 L p F P
0 g
s
.881 .629 .554 r
.57722 .55397 m .57772 .54608 L .59104 .5537 L p F P
0 g
s
.937 .598 .361 r
.53435 .6367 m .53552 .64455 L .53701 .64578 L p F P
0 g
s
.88 .552 .425 r
.53552 .64455 m .53435 .6367 L .53267 .63581 L p F P
0 g
s
.957 .73 .554 r
.51223 .66926 m .51367 .66044 L .51508 .66191 L p F P
0 g
s
.957 .73 .554 r
.51508 .66191 m .51381 .67088 L .51223 .66926 L p F P
0 g
s
.746 .521 .589 r
.52112 .68345 m .5216 .67412 L .52481 .6745 L p F P
0 g
s
.746 .521 .589 r
.52481 .6745 m .52466 .68386 L .52112 .68345 L p F P
0 g
s
.697 .48 .59 r
.52466 .68386 m .52481 .6745 L .52809 .67448 L p F P
0 g
s
.966 .687 .452 r
.54995 .72762 m .54834 .71777 L .54123 .71407 L p F P
0 g
s
.966 .687 .452 r
.54014 .70447 m .54123 .71407 L .54834 .71777 L p F P
0 g
s
.697 .48 .59 r
.52809 .67448 m .52827 .68384 L .52466 .68386 L p F P
0 g
s
.644 .438 .589 r
.52827 .68384 m .52809 .67448 L .53129 .67407 L p F P
0 g
s
.389 .303 .637 r
.46268 .57022 m .46486 .57846 L .45564 .58696 L p F P
0 g
s
.423 .356 .677 r
.45899 .59483 m .45564 .58696 L .46486 .57846 L p F P
0 g
s
.41 .267 .574 r
.53769 .66179 m .53898 .67075 L .53686 .67216 L p F P
0 g
s
.262 .164 .551 r
.53898 .67075 m .53769 .66179 L .53906 .66032 L p F P
0 g
s
.794 .563 .587 r
.51782 .68262 m .5186 .67337 L .5216 .67412 L p F P
0 g
s
.794 .563 .587 r
.5216 .67412 m .52112 .68345 L .51782 .68262 L p F P
0 g
s
.644 .438 .589 r
.53129 .67407 m .5318 .68339 L .52827 .68384 L p F P
0 g
s
.524 .629 .897 r
.49147 .64041 m .49982 .64451 L .49897 .64784 L p F P
0 g
s
.562 .668 .909 r
.50789 .65012 m .49897 .64784 L .49982 .64451 L p F P
0 g
s
.43 .459 .789 r
.46811 .61012 m .47375 .61735 L .46936 .62423 L p F P
0 g
s
.465 .505 .816 r
.47615 .6302 m .46936 .62423 L .47375 .61735 L p F P
0 g
s
.487 .234 .455 r
.5211 .64282 m .52177 .63518 L .51981 .63587 L p F P
0 g
s
.487 .234 .455 r
.51981 .63587 m .51886 .64361 L .5211 .64282 L p F P
0 g
s
.88 .552 .425 r
.53267 .63581 m .5336 .64353 L .53552 .64455 L p F P
0 g
s
.821 .506 .457 r
.5336 .64353 m .53267 .63581 L .53069 .63514 L p F P
0 g
s
.668 .774 .929 r
.52632 .65225 m .53557 .6515 L .53548 .65264 L closepath p F P
0 g
s
.902 .744 .677 r
.59636 .58622 m .59303 .59413 L .58398 .58617 L p F P
0 g
s
.902 .744 .677 r
.58398 .58617 m .58687 .57781 L .59636 .58622 L p F P
0 g
s
.966 .687 .452 r
.56983 .78979 m .56771 .77973 L .55807 .77729 L p F P
0 g
s
.966 .687 .452 r
.55643 .76729 m .55807 .77729 L .56771 .77973 L p F P
0 g
s
.744 .815 .908 r
.55364 .64757 m .54472 .64993 L .54407 .6477 L p F P
0 g
s
.744 .815 .908 r
.54407 .6477 m .55269 .64425 L .55364 .64757 L p F P
0 g
s
.856 .822 .814 r
.58301 .62364 m .57625 .62969 L .57217 .62369 L p F P
0 g
s
.856 .822 .814 r
.57217 .62369 m .5784 .6168 L .58301 .62364 L p F P
0 g
s
.845 .61 .584 r
.51491 .68141 m .51597 .67227 L .5186 .67337 L p F P
0 g
s
.845 .61 .584 r
.5186 .67337 m .51782 .68262 L .51491 .68141 L p F P
0 g
s
.51 .338 .583 r
.53507 .68253 m .53426 .67329 L .53686 .67216 L p F P
0 g
s
.575 .307 .472 r
.52359 .64233 m .52394 .63475 L .52177 .63518 L p F P
0 g
s
.575 .307 .472 r
.52177 .63518 m .5211 .64282 L .52359 .64233 L p F P
0 g
s
.821 .506 .457 r
.53069 .63514 m .53133 .64277 L .5336 .64353 L p F P
0 g
s
.763 .461 .473 r
.53133 .64277 m .53069 .63514 L .52851 .63473 L p F P
0 g
s
.562 .668 .909 r
.49982 .64451 m .50848 .64788 L .50789 .65012 L p F P
0 g
s
.999 .797 .499 r
.5113 .66748 m .51284 .65884 L .51367 .66044 L p F P
0 g
s
.999 .797 .499 r
.51367 .66044 m .51223 .66926 L .5113 .66748 L p F P
0 g
s
.262 .164 .551 r
.53906 .66032 m .54051 .66912 L .53898 .67075 L p F P
0 g
s
.018 .001 .491 r
.54051 .66912 m .53906 .66032 L .53984 .65871 L p F P
0 g
s
.671 .763 .92 r
.52632 .65225 m .53335 .64839 L .53448 .64933 L closepath p F P
0 g
s
.67 .759 .917 r
.52632 .65225 m .53188 .64761 L .53335 .64839 L closepath p F P
0 g
s
.668 .755 .915 r
.52632 .65225 m .53015 .64703 L .53188 .64761 L closepath p F P
0 g
s
.665 .751 .914 r
.52632 .65225 m .52823 .64667 L .53015 .64703 L closepath p F P
0 g
s
.662 .747 .913 r
.52632 .65225 m .52623 .64656 L .52823 .64667 L closepath p F P
0 g
s
.01 w
.52632 .6346 m
.52632 .64656 L
s
.5 Mabswid
.658 .744 .913 r
.52632 .65225 m .52423 .64669 L .52623 .64656 L closepath p F P
0 g
s
.654 .741 .914 r
.52632 .65225 m .52233 .64707 L .52423 .64669 L closepath p F P
0 g
s
.65 .74 .915 r
.52632 .65225 m .52062 .64767 L .52233 .64707 L closepath p F P
0 g
s
.645 .739 .917 r
.52632 .65225 m .51918 .64846 L .52062 .64767 L closepath p F P
0 g
s
.67 .771 .926 r
.52632 .65225 m .53524 .65038 L .53557 .6515 L closepath p F P
0 g
s
.671 .767 .923 r
.52632 .65225 m .53448 .64933 L .53524 .65038 L closepath p F P
0 g
s
.01 w
.52632 .65225 m
.52632 .65309 L
s
.5 Mabswid
.645 .365 .48 r
.52621 .64215 m .52622 .6346 L .52394 .63475 L p F P
0 g
s
.645 .365 .48 r
.52394 .63475 m .52359 .64233 L .52621 .64215 L p F P
0 g
s
.763 .461 .473 r
.52851 .63473 m .52883 .6423 L .53133 .64277 L p F P
0 g
s
.706 .415 .48 r
.52883 .6423 m .52851 .63473 L .52622 .6346 L p F P
0 g
s
.706 .415 .48 r
.52622 .6346 m .52621 .64215 L .52883 .6423 L p F P
0 g
s
.709 .782 .909 r
.53524 .65038 m .53448 .64933 L p .53792 .64874 L F P
0 g
s
.955 .619 .227 r
.53841 .64942 m .538 .64717 L p .53769 .64842 L F P
0 g
s
.709 .782 .909 r
.54407 .6477 m .53841 .64942 L p .53792 .64874 L F P
0 g
s
.709 .782 .909 r
.53841 .64942 m .53524 .65038 L p .53792 .64874 L F P
0 g
s
.955 .619 .227 r
.538 .64717 m .53701 .64578 L p .53769 .64842 L F P
0 g
s
.709 .782 .909 r
.54258 .6456 m .54407 .6477 L p .53792 .64874 L F P
0 g
s
.709 .782 .909 r
.53448 .64933 m .53739 .64799 L p .53792 .64874 L F P
0 g
s
.955 .619 .227 r
.53701 .64578 m .53739 .64799 L p .53769 .64842 L F P
0 g
s
.709 .782 .909 r
.53739 .64799 m .54258 .6456 L p .53792 .64874 L F P
0 g
s
.955 .619 .227 r
.53838 .65383 m .53949 .65539 L p .53769 .64842 L F P
0 g
s
.955 .619 .227 r
.53739 .64799 m .53838 .65383 L p .53769 .64842 L F P
0 g
s
.955 .619 .227 r
.53949 .65539 m .53841 .64942 L p .53769 .64842 L F P
0 g
s
.465 .505 .816 r
.47375 .61735 m .48004 .62416 L .47615 .6302 L p F P
0 g
s
.497 .548 .839 r
.48355 .63562 m .47615 .6302 L .48004 .62416 L p F P
0 g
s
.629 .32 .429 r
.50731 .52286 m .50782 .51688 L .52558 .51559 L p F P
0 g
s
.55 .253 .417 r
.50782 .51688 m .50731 .52286 L .49003 .52654 L p F P
0 g
s
.9 .665 .575 r
.51252 .67989 m .51381 .67088 L .51597 .67227 L p F P
0 g
s
.9 .665 .575 r
.51597 .67227 m .51491 .68141 L .51252 .67989 L p F P
0 g
s
.696 .375 .429 r
.54337 .51668 m .54384 .52266 L .52556 .52155 L p F P
0 g
s
.696 .375 .429 r
.52556 .52155 m .52558 .51559 L .54337 .51668 L p F P
0 g
s
.51 .338 .583 r
.53686 .67216 m .53794 .6813 L .53507 .68253 L p F P
0 g
s
.41 .267 .574 r
.53794 .6813 m .53686 .67216 L .53898 .67075 L p F P
0 g
s
.966 .687 .452 r
.55156 .73749 m .54995 .72762 L .54233 .7237 L p F P
0 g
s
.966 .687 .452 r
.54123 .71407 m .54233 .7237 L .54995 .72762 L p F P
0 g
s
.966 .687 .452 r
.57195 .79987 m .56983 .78979 L .55971 .78731 L p F P
0 g
s
.966 .687 .452 r
.55807 .77729 m .55971 .78731 L .56983 .78979 L p F P
0 g
s
.484 .235 .461 r
.49003 .52654 m .4895 .53333 L .47383 .53923 L p F P
0 g
s
.01 w
.47204 .52381 m
.47955 .53201 L
s
.5 Mabswid
.512 .293 .518 r
.47371 .54664 m .47383 .53923 L .4895 .53333 L p F P
0 g
s
.423 .356 .677 r
.46486 .57846 m .46779 .58678 L .45899 .59483 L p F P
0 g
s
.453 .403 .712 r
.46316 .60258 m .45899 .59483 L .46779 .58678 L p F P
0 g
s
.831 .818 .837 r
.57625 .62969 m .56888 .63518 L .56538 .63009 L p F P
0 g
s
.831 .818 .837 r
.56538 .63009 m .57217 .62369 L .57625 .62969 L p F P
0 g
s
.438 .269 .553 r
.47371 .54664 m .47421 .55452 L .46126 .56217 L p F P
0 g
s
.467 .322 .599 r
.46268 .57022 m .46126 .56217 L .47421 .55452 L p F P
0 g
s
.938 .808 .351 r
.51107 .66563 m .51264 .65717 L .51284 .65884 L p F P
0 g
s
.938 .808 .351 r
.51284 .65884 m .5113 .66748 L .51107 .66563 L p F P
0 g
s
.826 .549 .519 r
.57759 .53867 m .57772 .54608 L .56183 .54036 L p F P
0 g
s
.826 .549 .519 r
.56183 .54036 m .56174 .53294 L .57759 .53867 L p F P
0 g
s
.497 .548 .839 r
.48004 .62416 m .48689 .63049 L .48355 .63562 L p F P
0 g
s
.527 .588 .859 r
.49147 .64041 m .48355 .63562 L .48689 .63049 L p F P
0 g
s
.018 .001 .491 r
.53984 .65871 m .54138 .66733 L .54051 .66912 L p F P
0 g
s
0 0 .332 r
.54138 .66733 m .53984 .65871 L .53998 .65704 L p F P
0 g
s
.886 .754 .711 r
.59303 .59413 m .5889 .60193 L .58039 .5945 L p F P
0 g
s
.886 .754 .711 r
.58039 .5945 m .58398 .58617 L .59303 .59413 L p F P
0 g
s
.873 .652 .6 r
.59042 .56148 m .58902 .56955 L .57611 .56224 L p F P
0 g
s
.873 .652 .6 r
.57611 .56224 m .57722 .55397 L .59042 .56148 L p F P
0 g
s
.966 .687 .452 r
.5322 .6811 m .53165 .67198 L .52632 .66695 L p F P
0 g
s
.966 .687 .452 r
.52632 .65836 m .52632 .66695 L .53165 .67198 L p F P
0 g
s
.01 w
.52632 .65755 m
.52632 .66148 L
s
.52632 .66148 m
.52632 .66692 L
s
.5 Mabswid
.708 .77 .9 r
.53448 .64933 m .53335 .64839 L p .53666 .64739 L F P
0 g
s
.937 .598 .361 r
.53739 .64799 m .53701 .64578 L p .53631 .6471 L F P
0 g
s
.708 .77 .9 r
.54258 .6456 m .53739 .64799 L p .53666 .64739 L F P
0 g
s
.708 .77 .9 r
.53739 .64799 m .53448 .64933 L p .53666 .64739 L F P
0 g
s
.937 .598 .361 r
.53701 .64578 m .53552 .64455 L p .53631 .6471 L F P
0 g
s
.708 .77 .9 r
.54032 .64373 m .54258 .6456 L p .53666 .64739 L F P
0 g
s
.708 .77 .9 r
.53335 .64839 m .53585 .64672 L p .53666 .64739 L F P
0 g
s
.937 .598 .361 r
.53552 .64455 m .53585 .64672 L p .53631 .6471 L F P
0 g
s
.708 .77 .9 r
.53585 .64672 m .54032 .64373 L p .53666 .64739 L F P
0 g
s
.937 .598 .361 r
.5367 .65245 m .53838 .65383 L p .53631 .6471 L F P
0 g
s
.937 .598 .361 r
.53585 .64672 m .5367 .65245 L p .53631 .6471 L F P
0 g
s
.937 .598 .361 r
.53838 .65383 m .53739 .64799 L p .53631 .6471 L F P
0 g
s
.629 .32 .429 r
.52558 .51559 m .52556 .52155 L .50731 .52286 L p F P
0 g
s
.746 .521 .589 r
.52063 .69281 m .52112 .68345 L .52466 .68386 L p F P
0 g
s
.746 .521 .589 r
.52466 .68386 m .5245 .69326 L .52063 .69281 L p F P
0 g
s
.697 .48 .59 r
.5245 .69326 m .52466 .68386 L .52827 .68384 L p F P
0 g
s
.697 .48 .59 r
.52827 .68384 m .52845 .69324 L .5245 .69326 L p F P
0 g
s
.644 .438 .589 r
.52845 .69324 m .52827 .68384 L .5318 .68339 L p F P
0 g
s
.804 .812 .857 r
.56888 .63518 m .56099 .64005 L .55812 .63592 L p F P
0 g
s
.804 .812 .857 r
.55812 .63592 m .56538 .63009 L .56888 .63518 L p F P
0 g
s
.583 .665 .894 r
.50192 .64136 m .5099 .64577 L .50848 .64788 L p F P
0 g
s
.583 .665 .894 r
.50848 .64788 m .49982 .64451 L .50192 .64136 L p F P
0 g
s
.574 .31 .479 r
.4895 .53333 m .49003 .52654 L .50731 .52286 L p F P
0 g
s
.527 .588 .859 r
.48689 .63049 m .49421 .63625 L .49147 .64041 L p F P
0 g
s
.556 .627 .878 r
.49982 .64451 m .49147 .64041 L .49421 .63625 L p F P
0 g
s
.957 .73 .554 r
.51078 .67811 m .51223 .66926 L .51381 .67088 L p F P
0 g
s
.957 .73 .554 r
.51381 .67088 m .51252 .67989 L .51078 .67811 L p F P
0 g
s
.744 .794 .893 r
.55269 .64425 m .54407 .6477 L .54258 .6456 L p F P
0 g
s
.41 .267 .574 r
.53898 .67075 m .54028 .67975 L .53794 .6813 L p F P
0 g
s
.262 .164 .551 r
.54028 .67975 m .53898 .67075 L .54051 .66912 L p F P
0 g
s
.556 .627 .878 r
.49421 .63625 m .50192 .64136 L .49982 .64451 L p F P
0 g
s
.794 .563 .587 r
.51702 .69191 m .51782 .68262 L .52112 .68345 L p F P
0 g
s
.794 .563 .587 r
.52112 .68345 m .52063 .69281 L .51702 .69191 L p F P
0 g
s
.644 .438 .589 r
.5318 .68339 m .53231 .69275 L .52845 .69324 L p F P
0 g
s
.767 .467 .48 r
.56123 .52616 m .56174 .53294 L .5441 .52941 L p F P
0 g
s
.767 .467 .48 r
.5441 .52941 m .54384 .52266 L .56123 .52616 L p F P
0 g
s
.775 .804 .876 r
.56099 .64005 m .55269 .64425 L .55049 .64111 L p F P
0 g
s
.775 .804 .876 r
.55049 .64111 m .55812 .63592 L .56099 .64005 L p F P
0 g
s
.744 .794 .893 r
.54258 .6456 m .55049 .64111 L .55269 .64425 L p F P
0 g
s
.966 .687 .452 r
.57407 .80998 m .57195 .79987 L .56135 .79737 L p F P
0 g
s
.966 .687 .452 r
.55971 .78731 m .56135 .79737 L .57195 .79987 L p F P
0 g
s
.453 .403 .712 r
.46779 .58678 m .47143 .59507 L .46316 .60258 L p F P
0 g
s
.48 .446 .743 r
.46811 .61012 m .46316 .60258 L .47143 .59507 L p F P
0 g
s
.704 .757 .894 r
.53335 .64839 m .53188 .64761 L p .5349 .64622 L F P
0 g
s
.88 .552 .425 r
.53585 .64672 m .53552 .64455 L p .53445 .64598 L F P
0 g
s
.704 .757 .894 r
.54032 .64373 m .53585 .64672 L p .5349 .64622 L F P
0 g
s
.704 .757 .894 r
.53585 .64672 m .53335 .64839 L p .5349 .64622 L F P
0 g
s
.88 .552 .425 r
.53552 .64455 m .5336 .64353 L p .53445 .64598 L F P
0 g
s
.704 .757 .894 r
.5374 .64217 m .54032 .64373 L p .5349 .64622 L F P
0 g
s
.704 .757 .894 r
.53188 .64761 m .53386 .64566 L p .5349 .64622 L F P
0 g
s
.88 .552 .425 r
.5336 .64353 m .53386 .64566 L p .53445 .64598 L F P
0 g
s
.704 .757 .894 r
.53386 .64566 m .5374 .64217 L p .5349 .64622 L F P
0 g
s
.88 .552 .425 r
.53454 .6513 m .5367 .65245 L p .53445 .64598 L F P
0 g
s
.88 .552 .425 r
.53386 .64566 m .53454 .6513 L p .53445 .64598 L F P
0 g
s
.88 .552 .425 r
.5367 .65245 m .53585 .64672 L p .53445 .64598 L F P
0 g
s
0 0 0 r
.51156 .6638 m .51307 .65552 L .51264 .65717 L p F P
0 g
s
0 0 0 r
.51264 .65717 m .51107 .66563 L .51156 .6638 L p F P
0 g
s
.845 .61 .584 r
.51384 .6906 m .51491 .68141 L .51782 .68262 L p F P
0 g
s
.845 .61 .584 r
.51782 .68262 m .51702 .69191 L .51384 .6906 L p F P
0 g
s
.51 .338 .583 r
.53589 .69182 m .53507 .68253 L .53794 .6813 L p F P
0 g
s
0 0 .332 r
.53998 .65704 m .54154 .66548 L .54138 .66733 L p F P
0 g
s
.798 .528 0 r
.54154 .66548 m .53998 .65704 L .53949 .65539 L p F P
0 g
s
.966 .687 .452 r
.55318 .74739 m .55156 .73749 L .54343 .73337 L p F P
0 g
s
.966 .687 .452 r
.54233 .7237 m .54343 .73337 L .55156 .73749 L p F P
0 g
s
.869 .762 .741 r
.5889 .60193 m .584 .60952 L .57614 .6027 L p F P
0 g
s
.869 .762 .741 r
.57614 .6027 m .58039 .5945 L .5889 .60193 L p F P
0 g
s
.999 .797 .499 r
.50976 .67617 m .5113 .66748 L .51223 .66926 L p F P
0 g
s
.999 .797 .499 r
.51223 .66926 m .51078 .67811 L .50976 .67617 L p F P
0 g
s
.262 .164 .551 r
.54051 .66912 m .54197 .67796 L .54028 .67975 L p F P
0 g
s
.018 .001 .491 r
.54197 .67796 m .54051 .66912 L .54138 .66733 L p F P
0 g
s
.647 .705 .889 r
.52233 .64707 m .52062 .64767 L p .51982 .64531 L F P
0 g
s
.487 .234 .455 r
.5211 .64282 m .51886 .64361 L p .51929 .6455 L F P
0 g
s
.487 .234 .455 r
.52092 .64493 m .5211 .64282 L p .51929 .6455 L F P
0 g
s
.647 .705 .889 r
.51838 .64109 m .52092 .64493 L p .51982 .64531 L F P
0 g
s
.647 .705 .889 r
.52092 .64493 m .52233 .64707 L p .51982 .64531 L F P
0 g
s
.487 .234 .455 r
.51886 .64361 m .5186 .64574 L p .51929 .6455 L F P
0 g
s
.647 .705 .889 r
.51497 .64229 m .51838 .64109 L p .51982 .64531 L F P
0 g
s
.647 .705 .889 r
.52062 .64767 m .5186 .64574 L p .51982 .64531 L F P
0 g
s
.647 .705 .889 r
.5186 .64574 m .51497 .64229 L p .51982 .64531 L F P
0 g
s
.487 .234 .455 r
.5179 .65139 m .52043 .65051 L p .51929 .6455 L F P
0 g
s
.487 .234 .455 r
.5186 .64574 m .5179 .65139 L p .51929 .6455 L F P
0 g
s
.487 .234 .455 r
.52043 .65051 m .52092 .64493 L p .51929 .6455 L F P
0 g
s
.467 .322 .599 r
.47421 .55452 m .47535 .56278 L .46268 .57022 L p F P
0 g
s
.492 .367 .638 r
.46486 .57846 m .46268 .57022 L .47535 .56278 L p F P
0 g
s
.698 .746 .888 r
.53188 .64761 m .53015 .64703 L p .53275 .64529 L F P
0 g
s
.821 .506 .457 r
.53386 .64566 m .5336 .64353 L p .53221 .64511 L F P
0 g
s
.698 .746 .888 r
.5374 .64217 m .53386 .64566 L p .53275 .64529 L F P
0 g
s
.698 .746 .888 r
.53386 .64566 m .53188 .64761 L p .53275 .64529 L F P
0 g
s
.821 .506 .457 r
.5336 .64353 m .53133 .64277 L p .53221 .64511 L F P
0 g
s
.698 .746 .888 r
.53395 .64101 m .5374 .64217 L p .53275 .64529 L F P
0 g
s
.698 .746 .888 r
.53015 .64703 m .53151 .64487 L p .53275 .64529 L F P
0 g
s
.821 .506 .457 r
.53133 .64277 m .53151 .64487 L p .53221 .64511 L F P
0 g
s
.698 .746 .888 r
.53151 .64487 m .53395 .64101 L p .53275 .64529 L F P
0 g
s
.821 .506 .457 r
.53198 .65045 m .53454 .6513 L p .53221 .64511 L F P
0 g
s
.821 .506 .457 r
.53151 .64487 m .53198 .65045 L p .53221 .64511 L F P
0 g
s
.821 .506 .457 r
.53454 .6513 m .53386 .64566 L p .53221 .64511 L F P
0 g
s
.604 .664 .881 r
.50517 .63853 m .5121 .64387 L .5099 .64577 L p F P
0 g
s
.604 .664 .881 r
.5099 .64577 m .50192 .64136 L .50517 .63853 L p F P
0 g
s
.74 .774 .881 r
.55049 .64111 m .54258 .6456 L .54032 .64373 L p F P
0 g
s
.9 .665 .575 r
.51123 .68894 m .51252 .67989 L .51491 .68141 L p F P
0 g
s
.9 .665 .575 r
.51491 .68141 m .51384 .6906 L .51123 .68894 L p F P
0 g
s
.966 .687 .452 r
.5762 .8201 m .57407 .80998 L .563 .80746 L p F P
0 g
s
.966 .687 .452 r
.56135 .79737 m .563 .80746 L .57407 .80998 L p F P
0 g
s
.51 .338 .583 r
.53794 .6813 m .53903 .69048 L .53589 .69182 L p F P
0 g
s
.41 .267 .574 r
.53903 .69048 m .53794 .6813 L .54028 .67975 L p F P
0 g
s
.48 .446 .743 r
.47143 .59507 m .47575 .60323 L .46811 .61012 L p F P
0 g
s
.504 .486 .77 r
.47375 .61735 m .46811 .61012 L .47575 .60323 L p F P
0 g
s
.575 .307 .472 r
.52359 .64233 m .5211 .64282 L p .52169 .64477 L F P
0 g
s
.659 .71 .885 r
.52423 .64669 m .52233 .64707 L p .52227 .64466 L F P
0 g
s
.659 .71 .885 r
.52349 .64442 m .52423 .64669 L p .52227 .64466 L F P
0 g
s
.575 .307 .472 r
.52349 .64442 m .52359 .64233 L p .52169 .64477 L F P
0 g
s
.575 .307 .472 r
.5211 .64282 m .52092 .64493 L p .52169 .64477 L F P
0 g
s
.659 .71 .885 r
.51838 .64109 m .52217 .64034 L p .52227 .64466 L F P
0 g
s
.659 .71 .885 r
.52233 .64707 m .52092 .64493 L p .52227 .64466 L F P
0 g
s
.659 .71 .885 r
.52092 .64493 m .51838 .64109 L p .52227 .64466 L F P
0 g
s
.575 .307 .472 r
.52043 .65051 m .52324 .64995 L p .52169 .64477 L F P
0 g
s
.575 .307 .472 r
.52092 .64493 m .52043 .65051 L p .52169 .64477 L F P
0 g
s
.575 .307 .472 r
.52324 .64995 m .52349 .64442 L p .52169 .64477 L F P
0 g
s
.659 .71 .885 r
.52217 .64034 m .52349 .64442 L p .52227 .64466 L F P
0 g
s
.865 .67 .638 r
.58902 .56955 m .58687 .57781 L .5744 .57079 L p F P
0 g
s
.865 .67 .638 r
.5744 .57079 m .57611 .56224 L .58902 .56955 L p F P
0 g
s
.763 .461 .473 r
.53133 .64277 m .52883 .6423 L p .52969 .64453 L F P
0 g
s
.69 .735 .885 r
.53015 .64703 m .52823 .64667 L p .53028 .64464 L F P
0 g
s
.69 .735 .885 r
.53151 .64487 m .53015 .64703 L p .53028 .64464 L F P
0 g
s
.763 .461 .473 r
.53151 .64487 m .53133 .64277 L p .52969 .64453 L F P
0 g
s
.69 .735 .885 r
.53014 .6403 m .53395 .64101 L p .53028 .64464 L F P
0 g
s
.69 .735 .885 r
.52823 .64667 m .52892 .64439 L p .53028 .64464 L F P
0 g
s
.763 .461 .473 r
.52883 .6423 m .52892 .64439 L p .52969 .64453 L F P
0 g
s
.69 .735 .885 r
.52892 .64439 m .53014 .6403 L p .53028 .64464 L F P
0 g
s
.763 .461 .473 r
.52915 .64992 m .53198 .65045 L p .52969 .64453 L F P
0 g
s
.763 .461 .473 r
.52892 .64439 m .52915 .64992 L p .52969 .64453 L F P
0 g
s
.763 .461 .473 r
.53198 .65045 m .53151 .64487 L p .52969 .64453 L F P
0 g
s
.69 .735 .885 r
.53395 .64101 m .53151 .64487 L p .53028 .64464 L F P
0 g
s
0 0 .211 r
.51274 .66207 m .51414 .65396 L .51307 .65552 L p F P
0 g
s
0 0 .211 r
.51307 .65552 m .51156 .6638 L .51274 .66207 L p F P
0 g
s
.512 .293 .518 r
.4895 .53333 m .48941 .54075 L .47371 .54664 L p F P
0 g
s
.01 w
.48804 .54127 m
.52632 .58304 L
s
.48527 .53825 m
.48552 .53852 L
s
.48451 .53742 m
.48527 .53825 L
s
.47955 .53201 m
.48451 .53742 L
s
.5 Mabswid
.534 .34 .564 r
.47421 .55452 m .47371 .54664 L .48941 .54075 L p F P
0 g
s
.798 .528 0 r
.53949 .65539 m .541 .66365 L .54154 .66548 L p F P
0 g
s
.955 .619 .227 r
.541 .66365 m .53949 .65539 L .53838 .65383 L p F P
0 g
s
.645 .365 .48 r
.52621 .64215 m .52359 .64233 L p .5243 .64436 L F P
0 g
s
.671 .716 .883 r
.52623 .64656 m .52423 .64669 L p .52492 .64432 L F P
0 g
s
.671 .716 .883 r
.5262 .64424 m .52623 .64656 L p .52492 .64432 L F P
0 g
s
.645 .365 .48 r
.5262 .64424 m .52621 .64215 L p .5243 .64436 L F P
0 g
s
.671 .716 .883 r
.52217 .64034 m .52615 .64007 L p .52492 .64432 L F P
0 g
s
.671 .716 .883 r
.52423 .64669 m .52349 .64442 L p .52492 .64432 L F P
0 g
s
.645 .365 .48 r
.52359 .64233 m .52349 .64442 L p .5243 .64436 L F P
0 g
s
.671 .716 .883 r
.52349 .64442 m .52217 .64034 L p .52492 .64432 L F P
0 g
s
.645 .365 .48 r
.52324 .64995 m .52619 .64976 L p .5243 .64436 L F P
0 g
s
.645 .365 .48 r
.52349 .64442 m .52324 .64995 L p .5243 .64436 L F P
0 g
s
.645 .365 .48 r
.52619 .64976 m .5262 .64424 L p .5243 .64436 L F P
0 g
s
.671 .716 .883 r
.52615 .64007 m .5262 .64424 L p .52492 .64432 L F P
0 g
s
.706 .415 .48 r
.52883 .6423 m .52621 .64215 L p .52701 .64428 L F P
0 g
s
.681 .725 .883 r
.52823 .64667 m .52623 .64656 L p .52763 .64432 L F P
0 g
s
.681 .725 .883 r
.52892 .64439 m .52823 .64667 L p .52763 .64432 L F P
0 g
s
.706 .415 .48 r
.52892 .64439 m .52883 .6423 L p .52701 .64428 L F P
0 g
s
.681 .725 .883 r
.52615 .64007 m .53014 .6403 L p .52763 .64432 L F P
0 g
s
.681 .725 .883 r
.52623 .64656 m .5262 .64424 L p .52763 .64432 L F P
0 g
s
.706 .415 .48 r
.52621 .64215 m .5262 .64424 L p .52701 .64428 L F P
0 g
s
.681 .725 .883 r
.5262 .64424 m .52615 .64007 L p .52763 .64432 L F P
0 g
s
.706 .415 .48 r
.52619 .64976 m .52915 .64992 L p .52701 .64428 L F P
0 g
s
.706 .415 .48 r
.5262 .64424 m .52619 .64976 L p .52701 .64428 L F P
0 g
s
.706 .415 .48 r
.52915 .64992 m .52892 .64439 L p .52701 .64428 L F P
0 g
s
.681 .725 .883 r
.53014 .6403 m .52892 .64439 L p .52763 .64432 L F P
0 g
s
.852 .768 .769 r
.584 .60952 m .5784 .6168 L .57128 .61068 L p F P
0 g
s
.852 .768 .769 r
.57128 .61068 m .57614 .6027 L .584 .60952 L p F P
0 g
s
.746 .521 .589 r
.52014 .70222 m .52063 .69281 L .5245 .69326 L p F P
0 g
s
.746 .521 .589 r
.5245 .69326 m .52435 .7027 L .52014 .70222 L p F P
0 g
s
.697 .48 .59 r
.52435 .7027 m .5245 .69326 L .52845 .69324 L p F P
0 g
s
.697 .48 .59 r
.52845 .69324 m .52864 .70268 L .52435 .7027 L p F P
0 g
s
.644 .438 .589 r
.52864 .70268 m .52845 .69324 L .53231 .69275 L p F P
0 g
s
.825 .577 .565 r
.57772 .54608 m .57722 .55397 L .56148 .54833 L p F P
0 g
s
.825 .577 .565 r
.56148 .54833 m .56183 .54036 L .57772 .54608 L p F P
0 g
s
.966 .687 .452 r
.53275 .69027 m .5322 .6811 L .52632 .6756 L p F P
0 g
s
.966 .687 .452 r
.52632 .66695 m .52632 .6756 L .5322 .6811 L p F P
0 g
s
.01 w
.52632 .66692 m
.52632 .67434 L
s
.5 Mabswid
.585 .629 .861 r
.49848 .63251 m .50517 .63853 L .50192 .64136 L p F P
0 g
s
.585 .629 .861 r
.50192 .64136 m .49421 .63625 L .49848 .63251 L p F P
0 g
s
.646 .369 .486 r
.50703 .52961 m .50731 .52286 L .52556 .52155 L p F P
0 g
s
.574 .31 .479 r
.50731 .52286 m .50703 .52961 L .4895 .53333 L p F P
0 g
s
.938 .808 .351 r
.5095 .67414 m .51107 .66563 L .5113 .66748 L p F P
0 g
s
.938 .808 .351 r
.5113 .66748 m .50976 .67617 L .5095 .67414 L p F P
0 g
s
.767 .775 .86 r
.55812 .63592 m .55049 .64111 L .54714 .63832 L p F P
0 g
s
.74 .774 .881 r
.54032 .64373 m .54714 .63832 L .55049 .64111 L p F P
0 g
s
.708 .42 .486 r
.54384 .52266 m .5441 .52941 L .52555 .52828 L p F P
0 g
s
.708 .42 .486 r
.52555 .52828 m .52556 .52155 L .54384 .52266 L p F P
0 g
s
.018 .001 .491 r
.54138 .66733 m .54293 .676 L .54197 .67796 L p F P
0 g
s
0 0 .332 r
.54293 .676 m .54138 .66733 L .54154 .66548 L p F P
0 g
s
.794 .563 .587 r
.51623 .70124 m .51702 .69191 L .52063 .69281 L p F P
0 g
s
.794 .563 .587 r
.52063 .69281 m .52014 .70222 L .51623 .70124 L p F P
0 g
s
.966 .687 .452 r
.55481 .75733 m .55318 .74739 L .54453 .74308 L p F P
0 g
s
.966 .687 .452 r
.54343 .73337 m .54453 .74308 L .55318 .74739 L p F P
0 g
s
.504 .486 .77 r
.47575 .60323 m .48067 .61115 L .47375 .61735 L p F P
0 g
s
.526 .523 .795 r
.48004 .62416 m .47375 .61735 L .48067 .61115 L p F P
0 g
s
.644 .438 .589 r
.53231 .69275 m .53282 .70215 L .52864 .70268 L p F P
0 g
s
.957 .73 .554 r
.50932 .68701 m .51078 .67811 L .51252 .67989 L p F P
0 g
s
.957 .73 .554 r
.51252 .67989 m .51123 .68894 L .50932 .68701 L p F P
0 g
s
.624 .667 .871 r
.50943 .63617 m .51497 .64229 L .5121 .64387 L p F P
0 g
s
.624 .667 .871 r
.5121 .64387 m .50517 .63853 L .50943 .63617 L p F P
0 g
s
.41 .267 .574 r
.54028 .67975 m .54158 .68879 L .53903 .69048 L p F P
0 g
s
.262 .164 .551 r
.54158 .68879 m .54028 .67975 L .54197 .67796 L p F P
0 g
s
.732 .754 .87 r
.54714 .63832 m .54032 .64373 L .5374 .64217 L p F P
0 g
s
.966 .687 .452 r
.57834 .83025 m .5762 .8201 L .56465 .81757 L p F P
0 g
s
.966 .687 .452 r
.563 .80746 m .56465 .81757 L .5762 .8201 L p F P
0 g
s
.566 .594 .84 r
.49211 .62589 m .49848 .63251 L .49421 .63625 L p F P
0 g
s
.566 .594 .84 r
.49421 .63625 m .48689 .63049 L .49211 .62589 L p F P
0 g
s
.833 .772 .794 r
.5784 .6168 m .57217 .62369 L .56588 .61832 L p F P
0 g
s
.833 .772 .794 r
.56588 .61832 m .57128 .61068 L .5784 .6168 L p F P
0 g
s
.176 0 .354 r
.51456 .66052 m .51577 .65256 L .51414 .65396 L p F P
0 g
s
.176 0 .354 r
.51414 .65396 m .51274 .66207 L .51456 .66052 L p F P
0 g
s
.526 .523 .795 r
.48067 .61115 m .48615 .61874 L .48004 .62416 L p F P
0 g
s
.546 .559 .818 r
.48689 .63049 m .48004 .62416 L .48615 .61874 L p F P
0 g
s
.592 .357 .528 r
.48941 .54075 m .4895 .53333 L .50703 .52961 L p F P
0 g
s
.937 .598 .361 r
.53976 .66193 m .53838 .65383 L .5367 .65245 L p F P
0 g
s
.955 .619 .227 r
.53838 .65383 m .53976 .66193 L .541 .66365 L p F P
0 g
s
.791 .776 .839 r
.56538 .63009 m .55812 .63592 L .55374 .63223 L p F P
0 g
s
.767 .775 .86 r
.54714 .63832 m .55374 .63223 L .55812 .63592 L p F P
0 g
s
.546 .559 .818 r
.48615 .61874 m .49211 .62589 L .48689 .63049 L p F P
0 g
s
.492 .367 .638 r
.47535 .56278 m .47711 .57131 L .46486 .57846 L p F P
0 g
s
.512 .407 .672 r
.46779 .58678 m .46486 .57846 L .47711 .57131 L p F P
0 g
s
.845 .61 .584 r
.51277 .69983 m .51384 .6906 L .51702 .69191 L p F P
0 g
s
.845 .61 .584 r
.51702 .69191 m .51623 .70124 L .51277 .69983 L p F P
0 g
s
.646 .369 .486 r
.52556 .52155 m .52555 .52828 L .50703 .52961 L p F P
0 g
s
.51 .338 .583 r
.53671 .70114 m .53589 .69182 L .53903 .69048 L p F P
0 g
s
.77 .502 .529 r
.56174 .53294 m .56183 .54036 L .54414 .53684 L p F P
0 g
s
.77 .502 .529 r
.54414 .53684 m .5441 .52941 L .56174 .53294 L p F P
0 g
s
.813 .774 .817 r
.57217 .62369 m .56538 .63009 L .56001 .62554 L p F P
0 g
s
.813 .774 .817 r
.56001 .62554 m .56588 .61832 L .57217 .62369 L p F P
0 g
s
.791 .776 .839 r
.55374 .63223 m .56001 .62554 L .56538 .63009 L p F P
0 g
s
.855 .686 .671 r
.58687 .57781 m .58398 .58617 L .57209 .57951 L p F P
0 g
s
.855 .686 .671 r
.57209 .57951 m .5744 .57079 L .58687 .57781 L p F P
0 g
s
0 0 0 r
.51004 .67213 m .51156 .6638 L .51107 .66563 L p F P
0 g
s
0 0 0 r
.51107 .66563 m .5095 .67414 L .51004 .67213 L p F P
0 g
s
.643 .672 .863 r
.5145 .63438 m .51838 .64109 L .51497 .64229 L p F P
0 g
s
.643 .672 .863 r
.51497 .64229 m .50943 .63617 L .5145 .63438 L p F P
0 g
s
0 0 .332 r
.54154 .66548 m .54311 .67397 L .54293 .676 L p F P
0 g
s
.798 .528 0 r
.54311 .67397 m .54154 .66548 L .541 .66365 L p F P
0 g
s
.732 .754 .87 r
.5374 .64217 m .54281 .636 L .54714 .63832 L p F P
0 g
s
.721 .735 .862 r
.54281 .636 m .5374 .64217 L .53395 .64101 L p F P
0 g
s
.999 .797 .499 r
.5082 .6849 m .50976 .67617 L .51078 .67811 L p F P
0 g
s
.999 .797 .499 r
.51078 .67811 m .50932 .68701 L .5082 .6849 L p F P
0 g
s
.365 .132 .421 r
.51694 .65922 m .5179 .65139 L .51577 .65256 L p F P
0 g
s
.365 .132 .421 r
.51577 .65256 m .51456 .66052 L .51694 .65922 L p F P
0 g
s
.937 .598 .361 r
.5367 .65245 m .53789 .6604 L .53976 .66193 L p F P
0 g
s
.88 .552 .425 r
.53789 .6604 m .5367 .65245 L .53454 .6513 L p F P
0 g
s
.262 .164 .551 r
.54197 .67796 m .54343 .68684 L .54158 .68879 L p F P
0 g
s
.018 .001 .491 r
.54343 .68684 m .54197 .67796 L .54293 .676 L p F P
0 g
s
.966 .687 .452 r
.58048 .84042 m .57834 .83025 L .56631 .82772 L p F P
0 g
s
.966 .687 .452 r
.56465 .81757 m .56631 .82772 L .57834 .83025 L p F P
0 g
s
.9 .665 .575 r
.50994 .69804 m .51123 .68894 L .51384 .6906 L p F P
0 g
s
.9 .665 .575 r
.51384 .6906 m .51277 .69983 L .50994 .69804 L p F P
0 g
s
.51 .338 .583 r
.53903 .69048 m .54012 .6997 L .53671 .70114 L p F P
0 g
s
.41 .267 .574 r
.54012 .6997 m .53903 .69048 L .54158 .68879 L p F P
0 g
s
.966 .687 .452 r
.55643 .76729 m .55481 .75733 L .54564 .75282 L p F P
0 g
s
.966 .687 .452 r
.54453 .74308 m .54564 .75282 L .55481 .75733 L p F P
0 g
s
.534 .34 .564 r
.48941 .54075 m .48977 .54872 L .47421 .55452 L p F P
0 g
s
.552 .381 .603 r
.47535 .56278 m .47421 .55452 L .48977 .54872 L p F P
0 g
s
.612 .634 .848 r
.50408 .62939 m .50943 .63617 L .50517 .63853 L p F P
0 g
s
.612 .634 .848 r
.50517 .63853 m .49848 .63251 L .50408 .62939 L p F P
0 g
s
.755 .749 .847 r
.55374 .63223 m .54714 .63832 L .54281 .636 L p F P
0 g
s
.746 .521 .589 r
.51965 .71166 m .52014 .70222 L .52435 .7027 L p F P
0 g
s
.746 .521 .589 r
.52435 .7027 m .52419 .71218 L .51965 .71166 L p F P
0 g
s
.697 .48 .59 r
.52419 .71218 m .52435 .7027 L .52864 .70268 L p F P
0 g
s
.697 .48 .59 r
.52864 .70268 m .52882 .71216 L .52419 .71218 L p F P
0 g
s
.644 .438 .589 r
.52882 .71216 m .52864 .70268 L .53282 .70215 L p F P
0 g
s
.512 .407 .672 r
.47711 .57131 m .47946 .58 L .46779 .58678 L p F P
0 g
s
.53 .444 .702 r
.47143 .59507 m .46779 .58678 L .47946 .58 L p F P
0 g
s
.821 .6 .603 r
.57722 .55397 m .57611 .56224 L .56071 .55675 L p F P
0 g
s
.821 .6 .603 r
.56071 .55675 m .56148 .54833 L .57722 .55397 L p F P
0 g
s
.661 .68 .858 r
.52014 .63326 m .52217 .64034 L .51838 .64109 L p F P
0 g
s
.661 .68 .858 r
.51838 .64109 m .5145 .63438 L .52014 .63326 L p F P
0 g
s
.721 .735 .862 r
.53395 .64101 m .53768 .63426 L .54281 .636 L p F P
0 g
s
.709 .719 .857 r
.53768 .63426 m .53395 .64101 L .53014 .6403 L p F P
0 g
s
.487 .234 .455 r
.51976 .65824 m .52043 .65051 L .5179 .65139 L p F P
0 g
s
.487 .234 .455 r
.5179 .65139 m .51694 .65922 L .51976 .65824 L p F P
0 g
s
.88 .552 .425 r
.53454 .6513 m .53548 .65913 L .53789 .6604 L p F P
0 g
s
.821 .506 .457 r
.53548 .65913 m .53454 .6513 L .53198 .65045 L p F P
0 g
s
.966 .687 .452 r
.5333 .69948 m .53275 .69027 L .52632 .68428 L p F P
0 g
s
.966 .687 .452 r
.52632 .6756 m .52632 .68428 L .53275 .69027 L p F P
0 g
s
.794 .563 .587 r
.51542 .71062 m .51623 .70124 L .52014 .70222 L p F P
0 g
s
.794 .563 .587 r
.52014 .70222 m .51965 .71166 L .51542 .71062 L p F P
0 g
s
.644 .438 .589 r
.53282 .70215 m .53334 .71159 L .52882 .71216 L p F P
0 g
s
0 0 .211 r
.51134 .67023 m .51274 .66207 L .51156 .6638 L p F P
0 g
s
0 0 .211 r
.51156 .6638 m .51004 .67213 L .51134 .67023 L p F P
0 g
s
.844 .698 .701 r
.58398 .58617 m .58039 .5945 L .56923 .58829 L p F P
0 g
s
.844 .698 .701 r
.56923 .58829 m .57209 .57951 L .58398 .58617 L p F P
0 g
s
.798 .528 0 r
.541 .66365 m .54251 .67197 L .54311 .67397 L p F P
0 g
s
.955 .619 .227 r
.54251 .67197 m .541 .66365 L .53976 .66193 L p F P
0 g
s
.678 .691 .855 r
.52607 .63286 m .52615 .64007 L .52217 .64034 L p F P
0 g
s
.678 .691 .855 r
.52217 .64034 m .52014 .63326 L .52607 .63286 L p F P
0 g
s
.709 .719 .857 r
.53014 .6403 m .53201 .6332 L .53768 .63426 L p F P
0 g
s
.694 .704 .855 r
.53201 .6332 m .53014 .6403 L .52615 .64007 L p F P
0 g
s
.966 .687 .452 r
.58263 .85061 m .58048 .84042 L .56798 .83791 L p F P
0 g
s
.966 .687 .452 r
.56631 .82772 m .56798 .83791 L .58048 .84042 L p F P
0 g
s
.957 .73 .554 r
.50786 .69596 m .50932 .68701 L .51123 .68894 L p F P
0 g
s
.957 .73 .554 r
.51123 .68894 m .50994 .69804 L .50786 .69596 L p F P
0 g
s
.938 .808 .351 r
.50793 .68269 m .5095 .67414 L .50976 .67617 L p F P
0 g
s
.938 .808 .351 r
.50976 .67617 m .5082 .6849 L .50793 .68269 L p F P
0 g
s
.694 .704 .855 r
.52615 .64007 m .52607 .63286 L .53201 .6332 L p F P
0 g
s
.575 .307 .472 r
.52289 .65763 m .52324 .64995 L .52043 .65051 L p F P
0 g
s
.575 .307 .472 r
.52043 .65051 m .51976 .65824 L .52289 .65763 L p F P
0 g
s
.41 .267 .574 r
.54158 .68879 m .5429 .69788 L .54012 .6997 L p F P
0 g
s
.262 .164 .551 r
.5429 .69788 m .54158 .68879 L .54343 .68684 L p F P
0 g
s
.018 .001 .491 r
.54293 .676 m .54448 .68472 L .54343 .68684 L p F P
0 g
s
0 0 .332 r
.54448 .68472 m .54293 .676 L .54311 .67397 L p F P
0 g
s
.821 .506 .457 r
.53198 .65045 m .53263 .65818 L .53548 .65913 L p F P
0 g
s
.763 .461 .473 r
.53263 .65818 m .53198 .65045 L .52915 .64992 L p F P
0 g
s
.658 .409 .533 r
.50699 .53704 m .50703 .52961 L .52555 .52828 L p F P
0 g
s
.592 .357 .528 r
.50703 .52961 m .50699 .53704 L .48941 .54075 L p F P
0 g
s
.6 .602 .825 r
.49898 .62203 m .50408 .62939 L .49848 .63251 L p F P
0 g
s
.6 .602 .825 r
.49848 .63251 m .49211 .62589 L .49898 .62203 L p F P
0 g
s
.715 .457 .533 r
.5441 .52941 m .54414 .53684 L .52554 .53571 L p F P
0 g
s
.715 .457 .533 r
.52554 .53571 m .52555 .52828 L .5441 .52941 L p F P
0 g
s
.845 .61 .584 r
.51169 .70911 m .51277 .69983 L .51623 .70124 L p F P
0 g
s
.845 .61 .584 r
.51623 .70124 m .51542 .71062 L .51169 .70911 L p F P
0 g
s
.774 .743 .824 r
.56001 .62554 m .55374 .63223 L .54804 .62916 L p F P
0 g
s
.755 .749 .847 r
.54281 .636 m .54804 .62916 L .55374 .63223 L p F P
0 g
s
.51 .338 .583 r
.53754 .71051 m .53671 .70114 L .54012 .6997 L p F P
0 g
s
.53 .444 .702 r
.47946 .58 m .48239 .58875 L .47143 .59507 L p F P
0 g
s
.547 .478 .729 r
.47575 .60323 m .47143 .59507 L .48239 .58875 L p F P
0 g
s
.606 .396 .569 r
.48977 .54872 m .48941 .54075 L .50699 .53704 L p F P
0 g
s
.645 .365 .48 r
.52618 .65741 m .52619 .64976 L .52324 .64995 L p F P
0 g
s
.645 .365 .48 r
.52324 .64995 m .52289 .65763 L .52618 .65741 L p F P
0 g
s
.763 .461 .473 r
.52915 .64992 m .52948 .6576 L .53263 .65818 L p F P
0 g
s
.706 .415 .48 r
.52948 .6576 m .52915 .64992 L .52619 .64976 L p F P
0 g
s
.706 .415 .48 r
.52619 .64976 m .52618 .65741 L .52948 .6576 L p F P
0 g
s
.638 .642 .838 r
.51075 .62702 m .5145 .63438 L .50943 .63617 L p F P
0 g
s
.638 .642 .838 r
.50943 .63617 m .50408 .62939 L .51075 .62702 L p F P
0 g
s
.966 .687 .452 r
.55807 .77729 m .55643 .76729 L .54676 .76261 L p F P
0 g
s
.966 .687 .452 r
.54564 .75282 m .54676 .76261 L .55643 .76729 L p F P
0 g
s
.772 .53 .57 r
.56183 .54036 m .56148 .54833 L .54397 .54486 L p F P
0 g
s
.772 .53 .57 r
.54397 .54486 m .54414 .53684 L .56183 .54036 L p F P
0 g
s
.74 .725 .838 r
.54804 .62916 m .54281 .636 L .53768 .63426 L p F P
0 g
s
.833 .71 .729 r
.58039 .5945 m .57614 .6027 L .56585 .59702 L p F P
0 g
s
.833 .71 .729 r
.56585 .59702 m .56923 .58829 L .58039 .5945 L p F P
0 g
s
.176 0 .354 r
.51335 .66852 m .51456 .66052 L .51274 .66207 L p F P
0 g
s
.176 0 .354 r
.51274 .66207 m .51134 .67023 L .51335 .66852 L p F P
0 g
s
.552 .381 .603 r
.48977 .54872 m .49057 .55713 L .47535 .56278 L p F P
0 g
s
.567 .417 .637 r
.47711 .57131 m .47535 .56278 L .49057 .55713 L p F P
0 g
s
.588 .572 .802 r
.4942 .61418 m .49898 .62203 L .49211 .62589 L p F P
0 g
s
.588 .572 .802 r
.49211 .62589 m .48615 .61874 L .4942 .61418 L p F P
0 g
s
.658 .409 .533 r
.52555 .52828 m .52554 .53571 L .50699 .53704 L p F P
0 g
s
.937 .598 .361 r
.54115 .67008 m .53976 .66193 L .53789 .6604 L p F P
0 g
s
.955 .619 .227 r
.53976 .66193 m .54115 .67008 L .54251 .67197 L p F P
0 g
s
.547 .478 .729 r
.48239 .58875 m .48585 .59744 L .47575 .60323 L p F P
0 g
s
.561 .51 .755 r
.48067 .61115 m .47575 .60323 L .48585 .59744 L p F P
0 g
s
.966 .687 .452 r
.58478 .86083 m .58263 .85061 L .56965 .84812 L p F P
0 g
s
.966 .687 .452 r
.56798 .83791 m .56965 .84812 L .58263 .85061 L p F P
0 g
s
.791 .736 .801 r
.56588 .61832 m .56001 .62554 L .55302 .62175 L p F P
0 g
s
.774 .743 .824 r
.54804 .62916 m .55302 .62175 L .56001 .62554 L p F P
0 g
s
.816 .619 .637 r
.57611 .56224 m .5744 .57079 L .55952 .56552 L p F P
0 g
s
.816 .619 .637 r
.55952 .56552 m .56071 .55675 L .57611 .56224 L p F P
0 g
s
.9 .665 .575 r
.50864 .70718 m .50994 .69804 L .51277 .69983 L p F P
0 g
s
.9 .665 .575 r
.51277 .69983 m .51169 .70911 L .50864 .70718 L p F P
0 g
s
.999 .797 .499 r
.50664 .69367 m .5082 .6849 L .50932 .68701 L p F P
0 g
s
.999 .797 .499 r
.50932 .68701 m .50786 .69596 L .50664 .69367 L p F P
0 g
s
.575 .541 .779 r
.48981 .60595 m .4942 .61418 L .48615 .61874 L p F P
0 g
s
.575 .541 .779 r
.48615 .61874 m .48067 .61115 L .48981 .60595 L p F P
0 g
s
0 0 0 r
.50851 .6805 m .51004 .67213 L .5095 .67414 L p F P
0 g
s
0 0 0 r
.5095 .67414 m .50793 .68269 L .50851 .6805 L p F P
0 g
s
.51 .338 .583 r
.54012 .6997 m .54122 .70896 L .53754 .71051 L p F P
0 g
s
.41 .267 .574 r
.54122 .70896 m .54012 .6997 L .5429 .69788 L p F P
0 g
s
.561 .51 .755 r
.48585 .59744 m .48981 .60595 L .48067 .61115 L p F P
0 g
s
.262 .164 .551 r
.54343 .68684 m .5449 .69578 L .5429 .69788 L p F P
0 g
s
.018 .001 .491 r
.5449 .69578 m .54343 .68684 L .54448 .68472 L p F P
0 g
s
.82 .719 .754 r
.57614 .6027 m .57128 .61068 L .56198 .60557 L p F P
0 g
s
.82 .719 .754 r
.56198 .60557 m .56585 .59702 L .57614 .6027 L p F P
0 g
s
0 0 .332 r
.54311 .67397 m .54469 .68251 L .54448 .68472 L p F P
0 g
s
.798 .528 0 r
.54469 .68251 m .54311 .67397 L .54251 .67197 L p F P
0 g
s
.746 .521 .589 r
.51916 .72115 m .51965 .71166 L .52419 .71218 L p F P
0 g
s
.746 .521 .589 r
.52419 .71218 m .52403 .7217 L .51916 .72115 L p F P
0 g
s
.697 .48 .59 r
.52403 .7217 m .52419 .71218 L .52882 .71216 L p F P
0 g
s
.697 .48 .59 r
.52882 .71216 m .52901 .72168 L .52403 .7217 L p F P
0 g
s
.644 .438 .589 r
.52901 .72168 m .52882 .71216 L .53334 .71159 L p F P
0 g
s
.806 .728 .778 r
.57128 .61068 m .56588 .61832 L .55769 .61385 L p F P
0 g
s
.791 .736 .801 r
.55302 .62175 m .55769 .61385 L .56588 .61832 L p F P
0 g
s
.806 .728 .778 r
.55769 .61385 m .56198 .60557 L .57128 .61068 L p F P
0 g
s
.661 .654 .832 r
.51817 .62554 m .52014 .63326 L .5145 .63438 L p F P
0 g
s
.661 .654 .832 r
.5145 .63438 m .51075 .62702 L .51817 .62554 L p F P
0 g
s
.74 .725 .838 r
.53768 .63426 m .54129 .62687 L .54804 .62916 L p F P
0 g
s
.722 .703 .831 r
.54129 .62687 m .53768 .63426 L .53201 .6332 L p F P
0 g
s
.365 .132 .421 r
.51597 .6671 m .51694 .65922 L .51456 .66052 L p F P
0 g
s
.365 .132 .421 r
.51456 .66052 m .51335 .66852 L .51597 .6671 L p F P
0 g
s
.794 .563 .587 r
.51462 .72004 m .51542 .71062 L .51965 .71166 L p F P
0 g
s
.794 .563 .587 r
.51965 .71166 m .51916 .72115 L .51462 .72004 L p F P
0 g
s
.644 .438 .589 r
.53334 .71159 m .53386 .72108 L .52901 .72168 L p F P
0 g
s
.937 .598 .361 r
.53789 .6604 m .53909 .66839 L .54115 .67008 L p F P
0 g
s
.88 .552 .425 r
.53909 .66839 m .53789 .6604 L .53548 .65913 L p F P
0 g
s
.966 .687 .452 r
.53386 .70873 m .5333 .69948 L .52632 .69302 L p F P
0 g
s
.966 .687 .452 r
.52632 .68428 m .52632 .69302 L .5333 .69948 L p F P
0 g
s
.631 .614 .814 r
.50717 .61911 m .51075 .62702 L .50408 .62939 L p F P
0 g
s
.631 .614 .814 r
.50408 .62939 m .49898 .62203 L .50717 .61911 L p F P
0 g
s
.966 .687 .452 r
.55971 .78731 m .55807 .77729 L .54787 .77243 L p F P
0 g
s
.966 .687 .452 r
.54676 .76261 m .54787 .77243 L .55807 .77729 L p F P
0 g
s
.966 .687 .452 r
.58693 .87106 m .58478 .86083 L .57132 .85836 L p F P
0 g
s
.966 .687 .452 r
.56965 .84812 m .57132 .85836 L .58478 .86083 L p F P
0 g
s
.755 .714 .814 r
.55302 .62175 m .54804 .62916 L .54129 .62687 L p F P
0 g
s
.683 .667 .828 r
.52599 .62501 m .52607 .63286 L .52014 .63326 L p F P
0 g
s
.683 .667 .828 r
.52014 .63326 m .51817 .62554 L .52599 .62501 L p F P
0 g
s
.567 .417 .637 r
.49057 .55713 m .49181 .56588 L .47711 .57131 L p F P
0 g
s
.579 .449 .667 r
.47946 .58 m .47711 .57131 L .49181 .56588 L p F P
0 g
s
.957 .73 .554 r
.50639 .70495 m .50786 .69596 L .50994 .69804 L p F P
0 g
s
.957 .73 .554 r
.50994 .69804 m .50864 .70718 L .50639 .70495 L p F P
0 g
s
.722 .703 .831 r
.53201 .6332 m .53382 .62546 L .54129 .62687 L p F P
0 g
s
.704 .684 .828 r
.53382 .62546 m .53201 .6332 L .52607 .63286 L p F P
0 g
s
.41 .267 .574 r
.5429 .69788 m .54421 .70701 L .54122 .70896 L p F P
0 g
s
.262 .164 .551 r
.54421 .70701 m .5429 .69788 L .5449 .69578 L p F P
0 g
s
.606 .396 .569 r
.50699 .53704 m .50717 .54506 L .48977 .54872 L p F P
0 g
s
.618 .429 .605 r
.49057 .55713 m .48977 .54872 L .50717 .54506 L p F P
0 g
s
.845 .61 .584 r
.51061 .71842 m .51169 .70911 L .51542 .71062 L p F P
0 g
s
.845 .61 .584 r
.51542 .71062 m .51462 .72004 L .51061 .71842 L p F P
0 g
s
0 0 .211 r
.50993 .67843 m .51134 .67023 L .51004 .67213 L p F P
0 g
s
0 0 .211 r
.51004 .67213 m .50851 .6805 L .50993 .67843 L p F P
0 g
s
.666 .443 .571 r
.50717 .54506 m .50699 .53704 L .52554 .53571 L p F P
0 g
s
.51 .338 .583 r
.53836 .71992 m .53754 .71051 L .54122 .70896 L p F P
0 g
s
.938 .808 .351 r
.50634 .69129 m .50793 .68269 L .5082 .6849 L p F P
0 g
s
.938 .808 .351 r
.5082 .6849 m .50664 .69367 L .50634 .69129 L p F P
0 g
s
.704 .684 .828 r
.52607 .63286 m .52599 .62501 L .53382 .62546 L p F P
0 g
s
.487 .234 .455 r
.51908 .66603 m .51976 .65824 L .51694 .65922 L p F P
0 g
s
.487 .234 .455 r
.51694 .65922 m .51597 .6671 L .51908 .66603 L p F P
0 g
s
.81 .637 .667 r
.5744 .57079 m .57209 .57951 L .55793 .57452 L p F P
0 g
s
.81 .637 .667 r
.55793 .57452 m .55952 .56552 L .5744 .57079 L p F P
0 g
s
.798 .528 0 r
.54251 .67197 m .54403 .68033 L .54469 .68251 L p F P
0 g
s
.955 .619 .227 r
.54403 .68033 m .54251 .67197 L .54115 .67008 L p F P
0 g
s
.88 .552 .425 r
.53548 .65913 m .53643 .667 L .53909 .66839 L p F P
0 g
s
.821 .506 .457 r
.53643 .667 m .53548 .65913 L .53263 .65818 L p F P
0 g
s
.72 .487 .572 r
.54414 .53684 m .54397 .54486 L .52555 .54375 L p F P
0 g
s
.72 .487 .572 r
.52555 .54375 m .52554 .53571 L .54414 .53684 L p F P
0 g
s
.018 .001 .491 r
.54448 .68472 m .54605 .69348 L .5449 .69578 L p F P
0 g
s
0 0 .332 r
.54605 .69348 m .54448 .68472 L .54469 .68251 L p F P
0 g
s
.772 .555 .605 r
.56148 .54833 m .56071 .55675 L .54358 .55337 L p F P
0 g
s
.772 .555 .605 r
.54358 .55337 m .54397 .54486 L .56148 .54833 L p F P
0 g
s
.575 .307 .472 r
.52253 .66535 m .52289 .65763 L .51976 .65824 L p F P
0 g
s
.575 .307 .472 r
.51976 .65824 m .51908 .66603 L .52253 .66535 L p F P
0 g
s
.966 .687 .452 r
.57132 .85836 m .573 .86864 L .58693 .87106 L p F P
0 g
s
.625 .587 .791 r
.50382 .61073 m .50717 .61911 L .49898 .62203 L p F P
0 g
s
.625 .587 .791 r
.49898 .62203 m .4942 .61418 L .50382 .61073 L p F P
0 g
s
.821 .506 .457 r
.53263 .65818 m .53328 .66595 L .53643 .667 L p F P
0 g
s
.763 .461 .473 r
.53328 .66595 m .53263 .65818 L .52948 .6576 L p F P
0 g
s
.666 .443 .571 r
.52554 .53571 m .52555 .54375 L .50717 .54506 L p F P
0 g
s
.767 .702 .79 r
.55769 .61385 m .55302 .62175 L .54473 .61891 L p F P
0 g
s
.755 .714 .814 r
.54129 .62687 m .54473 .61891 L .55302 .62175 L p F P
0 g
s
.579 .449 .667 r
.49181 .56588 m .49346 .57486 L .47946 .58 L p F P
0 g
s
.591 .479 .694 r
.48239 .58875 m .47946 .58 L .49346 .57486 L p F P
0 g
s
.9 .665 .575 r
.50733 .71637 m .50864 .70718 L .51169 .70911 L p F P
0 g
s
.9 .665 .575 r
.51169 .70911 m .51061 .71842 L .50733 .71637 L p F P
0 g
s
.66 .628 .807 r
.5163 .61727 m .51817 .62554 L .51075 .62702 L p F P
0 g
s
.66 .628 .807 r
.51075 .62702 m .50717 .61911 L .5163 .61727 L p F P
0 g
s
.51 .338 .583 r
.54122 .70896 m .54232 .71827 L .53836 .71992 L p F P
0 g
s
.41 .267 .574 r
.54232 .71827 m .54122 .70896 L .54421 .70701 L p F P
0 g
s
.645 .365 .48 r
.52616 .66511 m .52618 .65741 L .52289 .65763 L p F P
0 g
s
.645 .365 .48 r
.52289 .65763 m .52253 .66535 L .52616 .66511 L p F P
0 g
s
.733 .688 .807 r
.54473 .61891 m .54129 .62687 L .53382 .62546 L p F P
0 g
s
.746 .521 .589 r
.51867 .73068 m .51916 .72115 L .52403 .7217 L p F P
0 g
s
.746 .521 .589 r
.52403 .7217 m .52388 .73127 L .51867 .73068 L p F P
0 g
s
.697 .48 .59 r
.52388 .73127 m .52403 .7217 L .52901 .72168 L p F P
0 g
s
.763 .461 .473 r
.52948 .6576 m .52981 .66532 L .53328 .66595 L p F P
0 g
s
.706 .415 .48 r
.52981 .66532 m .52948 .6576 L .52618 .65741 L p F P
0 g
s
.966 .687 .452 r
.56135 .79737 m .55971 .78731 L .549 .78229 L p F P
0 g
s
.966 .687 .452 r
.54787 .77243 m .549 .78229 L .55971 .78731 L p F P
0 g
s
.697 .48 .59 r
.52901 .72168 m .52919 .73124 L .52388 .73127 L p F P
0 g
s
.644 .438 .589 r
.52919 .73124 m .52901 .72168 L .53386 .72108 L p F P
0 g
s
.999 .797 .499 r
.50507 .70249 m .50664 .69367 L .50786 .69596 L p F P
0 g
s
.999 .797 .499 r
.50786 .69596 m .50639 .70495 L .50507 .70249 L p F P
0 g
s
.804 .652 .694 r
.57209 .57951 m .56923 .58829 L .55595 .58364 L p F P
0 g
s
.804 .652 .694 r
.55595 .58364 m .55793 .57452 L .57209 .57951 L p F P
0 g
s
.706 .415 .48 r
.52618 .65741 m .52616 .66511 L .52981 .66532 L p F P
0 g
s
.176 0 .354 r
.51212 .67658 m .51335 .66852 L .51134 .67023 L p F P
0 g
s
.176 0 .354 r
.51134 .67023 m .50993 .67843 L .51212 .67658 L p F P
0 g
s
.262 .164 .551 r
.5449 .69578 m .54638 .70475 L .54421 .70701 L p F P
0 g
s
.018 .001 .491 r
.54638 .70475 m .5449 .69578 L .54605 .69348 L p F P
0 g
s
.937 .598 .361 r
.54255 .67827 m .54115 .67008 L .53909 .66839 L p F P
0 g
s
.955 .619 .227 r
.54115 .67008 m .54255 .67827 L .54403 .68033 L p F P
0 g
s
0 0 0 r
.50697 .68893 m .50851 .6805 L .50793 .68269 L p F P
0 g
s
0 0 0 r
.50793 .68269 m .50634 .69129 L .50697 .68893 L p F P
0 g
s
.794 .563 .587 r
.51381 .7295 m .51462 .72004 L .51916 .72115 L p F P
0 g
s
.794 .563 .587 r
.51916 .72115 m .51867 .73068 L .51381 .7295 L p F P
0 g
s
.644 .438 .589 r
.53386 .72108 m .53438 .7306 L .52919 .73124 L p F P
0 g
s
.617 .56 .768 r
.50074 .60201 m .50382 .61073 L .4942 .61418 L p F P
0 g
s
.617 .56 .768 r
.4942 .61418 m .48981 .60595 L .50074 .60201 L p F P
0 g
s
0 0 .332 r
.54469 .68251 m .54627 .69109 L .54605 .69348 L p F P
0 g
s
.798 .528 0 r
.54627 .69109 m .54469 .68251 L .54403 .68033 L p F P
0 g
s
.591 .479 .694 r
.49346 .57486 m .49552 .58395 L .48239 .58875 L p F P
0 g
s
.6 .507 .72 r
.48585 .59744 m .48239 .58875 L .49552 .58395 L p F P
0 g
s
.618 .429 .605 r
.50717 .54506 m .50759 .55357 L .49057 .55713 L p F P
0 g
s
.627 .459 .636 r
.49181 .56588 m .49057 .55713 L .50759 .55357 L p F P
0 g
s
.778 .691 .767 r
.56198 .60557 m .55769 .61385 L .54796 .6105 L p F P
0 g
s
.767 .702 .79 r
.54473 .61891 m .54796 .6105 L .55769 .61385 L p F P
0 g
s
.966 .687 .452 r
.53442 .71802 m .53386 .70873 L .52632 .7018 L p F P
0 g
s
.966 .687 .452 r
.52632 .69302 m .52632 .7018 L .53386 .70873 L p F P
0 g
s
.77 .576 .635 r
.56071 .55675 m .55952 .56552 L .54298 .56228 L p F P
0 g
s
.77 .576 .635 r
.54298 .56228 m .54358 .55337 L .56071 .55675 L p F P
0 g
s
.686 .645 .804 r
.52592 .61662 m .52599 .62501 L .51817 .62554 L p F P
0 g
s
.686 .645 .804 r
.51817 .62554 m .5163 .61727 L .52592 .61662 L p F P
0 g
s
.796 .666 .719 r
.56923 .58829 m .56585 .59702 L .5536 .59275 L p F P
0 g
s
.796 .666 .719 r
.5536 .59275 m .55595 .58364 L .56923 .58829 L p F P
0 g
s
.609 .534 .744 r
.49796 .59304 m .50074 .60201 L .48981 .60595 L p F P
0 g
s
.609 .534 .744 r
.48981 .60595 m .48585 .59744 L .49796 .59304 L p F P
0 g
s
.733 .688 .807 r
.53382 .62546 m .53555 .61717 L .54473 .61891 L p F P
0 g
s
.71 .665 .804 r
.53555 .61717 m .53382 .62546 L .52599 .62501 L p F P
0 g
s
.6 .507 .72 r
.49552 .58395 m .49796 .59304 L .48585 .59744 L p F P
0 g
s
.673 .472 .605 r
.50759 .55357 m .50717 .54506 L .52555 .54375 L p F P
0 g
s
.788 .679 .744 r
.56585 .59702 m .56198 .60557 L .55093 .60175 L p F P
0 g
s
.778 .691 .767 r
.54796 .6105 m .55093 .60175 L .56198 .60557 L p F P
0 g
s
.845 .61 .584 r
.50953 .72778 m .51061 .71842 L .51462 .72004 L p F P
0 g
s
.845 .61 .584 r
.51462 .72004 m .51381 .7295 L .50953 .72778 L p F P
0 g
s
.957 .73 .554 r
.50492 .71398 m .50639 .70495 L .50864 .70718 L p F P
0 g
s
.957 .73 .554 r
.50864 .70718 m .50733 .71637 L .50492 .71398 L p F P
0 g
s
.723 .513 .605 r
.54397 .54486 m .54358 .55337 L .52557 .55229 L p F P
0 g
s
.723 .513 .605 r
.52557 .55229 m .52555 .54375 L .54397 .54486 L p F P
0 g
s
.71 .665 .804 r
.52599 .62501 m .52592 .61662 L .53555 .61717 L p F P
0 g
s
.788 .679 .744 r
.55093 .60175 m .5536 .59275 L .56585 .59702 L p F P
0 g
s
.51 .338 .583 r
.5392 .72937 m .53836 .71992 L .54232 .71827 L p F P
0 g
s
.365 .132 .421 r
.51499 .67503 m .51597 .6671 L .51335 .66852 L p F P
0 g
s
.365 .132 .421 r
.51335 .66852 m .51212 .67658 L .51499 .67503 L p F P
0 g
s
.41 .267 .574 r
.54421 .70701 m .54554 .71618 L .54232 .71827 L p F P
0 g
s
.262 .164 .551 r
.54554 .71618 m .54421 .70701 L .54638 .70475 L p F P
0 g
s
.937 .598 .361 r
.53909 .66839 m .54029 .67644 L .54255 .67827 L p F P
0 g
s
.88 .552 .425 r
.54029 .67644 m .53909 .66839 L .53643 .667 L p F P
0 g
s
.657 .604 .784 r
.51454 .60857 m .5163 .61727 L .50717 .61911 L p F P
0 g
s
.657 .604 .784 r
.50717 .61911 m .50382 .61073 L .51454 .60857 L p F P
0 g
s
.742 .673 .783 r
.54796 .6105 m .54473 .61891 L .53555 .61717 L p F P
0 g
s
.938 .808 .351 r
.50474 .69994 m .50634 .69129 L .50664 .69367 L p F P
0 g
s
.938 .808 .351 r
.50664 .69367 m .50507 .70249 L .50474 .69994 L p F P
0 g
s
.966 .687 .452 r
.563 .80746 m .56135 .79737 L .55012 .79219 L p F P
0 g
s
.966 .687 .452 r
.549 .78229 m .55012 .79219 L .56135 .79737 L p F P
0 g
s
.018 .001 .491 r
.54605 .69348 m .54762 .70228 L .54638 .70475 L p F P
0 g
s
0 0 .332 r
.54762 .70228 m .54605 .69348 L .54627 .69109 L p F P
0 g
s
0 0 .211 r
.50851 .68669 m .50993 .67843 L .50851 .6805 L p F P
0 g
s
0 0 .211 r
.50851 .6805 m .50697 .68893 L .50851 .68669 L p F P
0 g
s
.673 .472 .605 r
.52555 .54375 m .52557 .55229 L .50759 .55357 L p F P
0 g
s
.798 .528 0 r
.54403 .68033 m .54557 .68873 L .54627 .69109 L p F P
0 g
s
.955 .619 .227 r
.54557 .68873 m .54403 .68033 L .54255 .67827 L p F P
0 g
s
.627 .459 .636 r
.50759 .55357 m .50824 .56246 L .49181 .56588 L p F P
0 g
s
.634 .486 .664 r
.49346 .57486 m .49181 .56588 L .50824 .56246 L p F P
0 g
s
.487 .234 .455 r
.51839 .67386 m .51908 .66603 L .51597 .6671 L p F P
0 g
s
.487 .234 .455 r
.51597 .6671 m .51499 .67503 L .51839 .67386 L p F P
0 g
s
.768 .594 .663 r
.55952 .56552 m .55793 .57452 L .54218 .57145 L p F P
0 g
s
.768 .594 .663 r
.54218 .57145 m .54298 .56228 L .55952 .56552 L p F P
0 g
s
.9 .665 .575 r
.50601 .7256 m .50733 .71637 L .51061 .71842 L p F P
0 g
s
.9 .665 .575 r
.51061 .71842 m .50953 .72778 L .50601 .7256 L p F P
0 g
s
.746 .521 .589 r
.51817 .74025 m .51867 .73068 L .52388 .73127 L p F P
0 g
s
.746 .521 .589 r
.52388 .73127 m .52372 .74087 L .51817 .74025 L p F P
0 g
s
.697 .48 .59 r
.52372 .74087 m .52388 .73127 L .52919 .73124 L p F P
0 g
s
.88 .552 .425 r
.53643 .667 m .53738 .67492 L .54029 .67644 L p F P
0 g
s
.821 .506 .457 r
.53738 .67492 m .53643 .667 L .53328 .66595 L p F P
0 g
s
.697 .48 .59 r
.52919 .73124 m .52938 .74084 L .52372 .74087 L p F P
0 g
s
.644 .438 .589 r
.52938 .74084 m .52919 .73124 L .53438 .7306 L p F P
0 g
s
.51 .338 .583 r
.54232 .71827 m .54342 .72761 L .5392 .72937 L p F P
0 g
s
.41 .267 .574 r
.54342 .72761 m .54232 .71827 L .54554 .71618 L p F P
0 g
s
.654 .581 .76 r
.51293 .59953 m .51454 .60857 L .50382 .61073 L p F P
0 g
s
.654 .581 .76 r
.50382 .61073 m .50074 .60201 L .51293 .59953 L p F P
0 g
s
.688 .624 .78 r
.52585 .60779 m .52592 .61662 L .5163 .61727 L p F P
0 g
s
.688 .624 .78 r
.5163 .61727 m .51454 .60857 L .52585 .60779 L p F P
0 g
s
.794 .563 .587 r
.513 .739 m .51381 .7295 L .51867 .73068 L p F P
0 g
s
.794 .563 .587 r
.51867 .73068 m .51817 .74025 L .513 .739 L p F P
0 g
s
.999 .797 .499 r
.5035 .71136 m .50507 .70249 L .50639 .70495 L p F P
0 g
s
.999 .797 .499 r
.50639 .70495 m .50492 .71398 L .5035 .71136 L p F P
0 g
s
.644 .438 .589 r
.53438 .7306 m .5349 .74017 L .52938 .74084 L p F P
0 g
s
.742 .673 .783 r
.53555 .61717 m .53717 .60845 L .54796 .6105 L p F P
0 g
s
.716 .647 .78 r
.53717 .60845 m .53555 .61717 L .52592 .61662 L p F P
0 g
s
.749 .658 .76 r
.55093 .60175 m .54796 .6105 L .53717 .60845 L p F P
0 g
s
.262 .164 .551 r
.54638 .70475 m .54787 .71377 L .54554 .71618 L p F P
0 g
s
.018 .001 .491 r
.54787 .71377 m .54638 .70475 L .54762 .70228 L p F P
0 g
s
.678 .498 .635 r
.50824 .56246 m .50759 .55357 L .52557 .55229 L p F P
0 g
s
.575 .307 .472 r
.52217 .67313 m .52253 .66535 L .51908 .66603 L p F P
0 g
s
.575 .307 .472 r
.51908 .66603 m .51839 .67386 L .52217 .67313 L p F P
0 g
s
.725 .536 .635 r
.54358 .55337 m .54298 .56228 L .52559 .56124 L p F P
0 g
s
.725 .536 .635 r
.52559 .56124 m .52557 .55229 L .54358 .55337 L p F P
0 g
s
.821 .506 .457 r
.53328 .66595 m .53394 .67378 L .53738 .67492 L p F P
0 g
s
.763 .461 .473 r
.53394 .67378 m .53328 .66595 L .52981 .66532 L p F P
0 g
s
.634 .486 .664 r
.50824 .56246 m .50911 .57162 L .49346 .57486 L p F P
0 g
s
.641 .511 .689 r
.49552 .58395 m .49346 .57486 L .50911 .57162 L p F P
0 g
s
.716 .647 .78 r
.52592 .61662 m .52585 .60779 L .53717 .60845 L p F P
0 g
s
.966 .687 .452 r
.53498 .72736 m .53442 .71802 L .52632 .71064 L p F P
0 g
s
.966 .687 .452 r
.52632 .7018 m .52632 .71064 L .53442 .71802 L p F P
0 g
s
.176 0 .354 r
.5109 .68468 m .51212 .67658 L .50993 .67843 L p F P
0 g
s
.176 0 .354 r
.50993 .67843 m .50851 .68669 L .5109 .68468 L p F P
0 g
s
0 0 0 r
.50542 .6974 m .50697 .68893 L .50634 .69129 L p F P
0 g
s
0 0 0 r
.50634 .69129 m .50474 .69994 L .50542 .6974 L p F P
0 g
s
.966 .687 .452 r
.56465 .81757 m .563 .80746 L .55125 .80213 L p F P
0 g
s
.966 .687 .452 r
.55012 .79219 m .55125 .80213 L .563 .80746 L p F P
0 g
s
.764 .612 .689 r
.55793 .57452 m .55595 .58364 L .54118 .58077 L p F P
0 g
s
.764 .612 .689 r
.54118 .58077 m .54218 .57145 L .55793 .57452 L p F P
0 g
s
.937 .598 .361 r
.54395 .68651 m .54255 .67827 L .54029 .67644 L p F P
0 g
s
.955 .619 .227 r
.54255 .67827 m .54395 .68651 L .54557 .68873 L p F P
0 g
s
0 0 .332 r
.54627 .69109 m .54787 .69972 L .54762 .70228 L p F P
0 g
s
.798 .528 0 r
.54787 .69972 m .54627 .69109 L .54557 .68873 L p F P
0 g
s
.645 .365 .48 r
.52615 .67286 m .52616 .66511 L .52253 .66535 L p F P
0 g
s
.645 .365 .48 r
.52253 .66535 m .52217 .67313 L .52615 .67286 L p F P
0 g
s
.763 .461 .473 r
.52981 .66532 m .53014 .67309 L .53394 .67378 L p F P
0 g
s
.706 .415 .48 r
.53014 .67309 m .52981 .66532 L .52616 .66511 L p F P
0 g
s
.65 .558 .737 r
.51147 .59028 m .51293 .59953 L .50074 .60201 L p F P
0 g
s
.65 .558 .737 r
.50074 .60201 m .49796 .59304 L .51147 .59028 L p F P
0 g
s
.845 .61 .584 r
.50844 .73718 m .50953 .72778 L .51381 .7295 L p F P
0 g
s
.845 .61 .584 r
.51381 .7295 m .513 .739 L .50844 .73718 L p F P
0 g
s
.706 .415 .48 r
.52616 .66511 m .52615 .67286 L .53014 .67309 L p F P
0 g
s
.51 .338 .583 r
.54003 .73887 m .5392 .72937 L .54342 .72761 L p F P
0 g
s
.755 .643 .737 r
.5536 .59275 m .55093 .60175 L .53866 .59939 L p F P
0 g
s
.749 .658 .76 r
.53717 .60845 m .53866 .59939 L .55093 .60175 L p F P
0 g
s
.641 .511 .689 r
.50911 .57162 m .51019 .58094 L .49552 .58395 L p F P
0 g
s
.646 .535 .714 r
.49796 .59304 m .49552 .58395 L .51019 .58094 L p F P
0 g
s
.678 .498 .635 r
.52557 .55229 m .52559 .56124 L .50824 .56246 L p F P
0 g
s
.957 .73 .554 r
.50343 .72306 m .50492 .71398 L .50733 .71637 L p F P
0 g
s
.957 .73 .554 r
.50733 .71637 m .50601 .7256 L .50343 .72306 L p F P
0 g
s
.646 .535 .714 r
.51019 .58094 m .51147 .59028 L .49796 .59304 L p F P
0 g
s
.41 .267 .574 r
.54554 .71618 m .54687 .7254 L .54342 .72761 L p F P
0 g
s
.262 .164 .551 r
.54687 .7254 m .54554 .71618 L .54787 .71377 L p F P
0 g
s
.76 .628 .713 r
.55595 .58364 m .5536 .59275 L .54001 .59013 L p F P
0 g
s
.76 .628 .713 r
.54001 .59013 m .54118 .58077 L .55595 .58364 L p F P
0 g
s
.755 .643 .737 r
.53866 .59939 m .54001 .59013 L .5536 .59275 L p F P
0 g
s
.688 .604 .757 r
.52578 .59864 m .52585 .60779 L .51454 .60857 L p F P
0 g
s
.688 .604 .757 r
.51454 .60857 m .51293 .59953 L .52578 .59864 L p F P
0 g
s
.719 .63 .757 r
.53866 .59939 m .53717 .60845 L .52585 .60779 L p F P
0 g
s
.682 .521 .662 r
.50911 .57162 m .50824 .56246 L .52559 .56124 L p F P
0 g
s
.725 .557 .662 r
.54298 .56228 m .54218 .57145 L .52563 .57046 L p F P
0 g
s
.725 .557 .662 r
.52563 .57046 m .52559 .56124 L .54298 .56228 L p F P
0 g
s
.938 .808 .351 r
.50314 .70863 m .50474 .69994 L .50507 .70249 L p F P
0 g
s
.938 .808 .351 r
.50507 .70249 m .5035 .71136 L .50314 .70863 L p F P
0 g
s
.365 .132 .421 r
.51401 .68301 m .51499 .67503 L .51212 .67658 L p F P
0 g
s
.365 .132 .421 r
.51212 .67658 m .5109 .68468 L .51401 .68301 L p F P
0 g
s
.018 .001 .491 r
.54762 .70228 m .5492 .71114 L .54787 .71377 L p F P
0 g
s
0 0 .332 r
.5492 .71114 m .54762 .70228 L .54787 .69972 L p F P
0 g
s
.746 .521 .589 r
.51768 .74986 m .51817 .74025 L .52372 .74087 L p F P
0 g
s
.746 .521 .589 r
.52372 .74087 m .52356 .75052 L .51768 .74986 L p F P
0 g
s
.697 .48 .59 r
.52356 .75052 m .52372 .74087 L .52938 .74084 L p F P
0 g
s
.697 .48 .59 r
.52938 .74084 m .52957 .75049 L .52356 .75052 L p F P
0 g
s
.644 .438 .589 r
.52957 .75049 m .52938 .74084 L .5349 .74017 L p F P
0 g
s
.719 .63 .757 r
.52585 .60779 m .52578 .59864 L .53866 .59939 L p F P
0 g
s
.937 .598 .361 r
.54029 .67644 m .54151 .68453 L .54395 .68651 L p F P
0 g
s
.88 .552 .425 r
.54151 .68453 m .54029 .67644 L .53738 .67492 L p F P
0 g
s
.9 .665 .575 r
.50469 .73487 m .50601 .7256 L .50953 .72778 L p F P
0 g
s
.9 .665 .575 r
.50953 .72778 m .50844 .73718 L .50469 .73487 L p F P
0 g
s
.51 .338 .583 r
.54342 .72761 m .54454 .73701 L .54003 .73887 L p F P
0 g
s
.41 .267 .574 r
.54454 .73701 m .54342 .72761 L .54687 .7254 L p F P
0 g
s
0 0 .211 r
.50709 .69499 m .50851 .68669 L .50697 .68893 L p F P
0 g
s
0 0 .211 r
.50697 .68893 m .50542 .6974 L .50709 .69499 L p F P
0 g
s
.966 .687 .452 r
.56631 .82772 m .56465 .81757 L .55239 .81211 L p F P
0 g
s
.966 .687 .452 r
.55125 .80213 m .55239 .81211 L .56465 .81757 L p F P
0 g
s
.682 .521 .662 r
.52559 .56124 m .52563 .57046 L .50911 .57162 L p F P
0 g
s
.798 .528 0 r
.54557 .68873 m .54711 .69719 L .54787 .69972 L p F P
0 g
s
.955 .619 .227 r
.54711 .69719 m .54557 .68873 L .54395 .68651 L p F P
0 g
s
.794 .563 .587 r
.51219 .74854 m .513 .739 L .51817 .74025 L p F P
0 g
s
.794 .563 .587 r
.51817 .74025 m .51768 .74986 L .51219 .74854 L p F P
0 g
s
.688 .584 .734 r
.52572 .58929 m .52578 .59864 L .51293 .59953 L p F P
0 g
s
.688 .584 .734 r
.51293 .59953 m .51147 .59028 L .52572 .58929 L p F P
0 g
s
.644 .438 .589 r
.5349 .74017 m .53543 .74977 L .52957 .75049 L p F P
0 g
s
.685 .543 .687 r
.51019 .58094 m .50911 .57162 L .52563 .57046 L p F P
0 g
s
.722 .612 .734 r
.54001 .59013 m .53866 .59939 L .52578 .59864 L p F P
0 g
s
.725 .576 .687 r
.54218 .57145 m .54118 .58077 L .52567 .57986 L p F P
0 g
s
.725 .576 .687 r
.52567 .57986 m .52563 .57046 L .54218 .57145 L p F P
0 g
s
.999 .797 .499 r
.50191 .72027 m .5035 .71136 L .50492 .71398 L p F P
0 g
s
.999 .797 .499 r
.50492 .71398 m .50343 .72306 L .50191 .72027 L p F P
0 g
s
.262 .164 .551 r
.54787 .71377 m .54937 .72284 L .54687 .7254 L p F P
0 g
s
.018 .001 .491 r
.54937 .72284 m .54787 .71377 L .5492 .71114 L p F P
0 g
s
.686 .564 .711 r
.52567 .57986 m .52572 .58929 L .51147 .59028 L p F P
0 g
s
.686 .564 .711 r
.51147 .59028 m .51019 .58094 L .52567 .57986 L p F P
0 g
s
.487 .234 .455 r
.51771 .68174 m .51839 .67386 L .51499 .67503 L p F P
0 g
s
.487 .234 .455 r
.51499 .67503 m .51401 .68301 L .51771 .68174 L p F P
0 g
s
.685 .543 .687 r
.52563 .57046 m .52567 .57986 L .51019 .58094 L p F P
0 g
s
.722 .612 .734 r
.52578 .59864 m .52572 .58929 L .54001 .59013 L p F P
0 g
s
.88 .552 .425 r
.53738 .67492 m .53834 .68289 L .54151 .68453 L p F P
0 g
s
.821 .506 .457 r
.53834 .68289 m .53738 .67492 L .53394 .67378 L p F P
0 g
s
.724 .594 .711 r
.54118 .58077 m .54001 .59013 L .52572 .58929 L p F P
0 g
s
.724 .594 .711 r
.52572 .58929 m .52567 .57986 L .54118 .58077 L p F P
0 g
s
.966 .687 .452 r
.53554 .73675 m .53498 .72736 L .52632 .71952 L p F P
0 g
s
.966 .687 .452 r
.52632 .71064 m .52632 .71952 L .53498 .72736 L p F P
0 g
s
.845 .61 .584 r
.50734 .74662 m .50844 .73718 L .513 .739 L p F P
0 g
s
.845 .61 .584 r
.513 .739 m .51219 .74854 L .50734 .74662 L p F P
0 g
s
.51 .338 .583 r
.54087 .7484 m .54003 .73887 L .54454 .73701 L p F P
0 g
s
0 0 0 r
.50387 .70591 m .50542 .6974 L .50474 .69994 L p F P
0 g
s
0 0 0 r
.50474 .69994 m .50314 .70863 L .50387 .70591 L p F P
0 g
s
.957 .73 .554 r
.50194 .73218 m .50343 .72306 L .50601 .7256 L p F P
0 g
s
.957 .73 .554 r
.50601 .7256 m .50469 .73487 L .50194 .73218 L p F P
0 g
s
0 0 .332 r
.54787 .69972 m .54947 .7084 L .5492 .71114 L p F P
0 g
s
.798 .528 0 r
.54947 .7084 m .54787 .69972 L .54711 .69719 L p F P
0 g
s
.575 .307 .472 r
.52181 .68095 m .52217 .67313 L .51839 .67386 L p F P
0 g
s
.575 .307 .472 r
.51839 .67386 m .51771 .68174 L .52181 .68095 L p F P
0 g
s
.41 .267 .574 r
.54687 .7254 m .54821 .73466 L .54454 .73701 L p F P
0 g
s
.262 .164 .551 r
.54821 .73466 m .54687 .7254 L .54937 .72284 L p F P
0 g
s
.176 0 .354 r
.50966 .69284 m .5109 .68468 L .50851 .68669 L p F P
0 g
s
.176 0 .354 r
.50851 .68669 m .50709 .69499 L .50966 .69284 L p F P
0 g
s
.821 .506 .457 r
.53394 .67378 m .5346 .68166 L .53834 .68289 L p F P
0 g
s
.763 .461 .473 r
.5346 .68166 m .53394 .67378 L .53014 .67309 L p F P
0 g
s
.955 .619 .227 r
.54395 .68651 m .54537 .6948 L .54711 .69719 L p F P
0 g
s
.937 .598 .361 r
.54537 .6948 m .54395 .68651 L .54151 .68453 L p F P
0 g
s
.966 .687 .452 r
.56798 .83791 m .56631 .82772 L .55353 .82213 L p F P
0 g
s
.966 .687 .452 r
.55239 .81211 m .55353 .82213 L .56631 .82772 L p F P
0 g
s
.645 .365 .48 r
.52614 .68067 m .52615 .67286 L .52217 .67313 L p F P
0 g
s
.645 .365 .48 r
.52217 .67313 m .52181 .68095 L .52614 .68067 L p F P
0 g
s
.746 .521 .589 r
.51718 .75951 m .51768 .74986 L .52356 .75052 L p F P
0 g
s
.746 .521 .589 r
.52356 .75052 m .5234 .7602 L .51718 .75951 L p F P
0 g
s
.697 .48 .59 r
.5234 .7602 m .52356 .75052 L .52957 .75049 L p F P
0 g
s
.763 .461 .473 r
.53014 .67309 m .53047 .68091 L .5346 .68166 L p F P
0 g
s
.706 .415 .48 r
.53047 .68091 m .53014 .67309 L .52615 .67286 L p F P
0 g
s
.697 .48 .59 r
.52957 .75049 m .52975 .76017 L .5234 .7602 L p F P
0 g
s
.644 .438 .589 r
.52975 .76017 m .52957 .75049 L .53543 .74977 L p F P
0 g
s
.706 .415 .48 r
.52615 .67286 m .52614 .68067 L .53047 .68091 L p F P
0 g
s
.9 .665 .575 r
.50337 .74419 m .50469 .73487 L .50844 .73718 L p F P
0 g
s
.9 .665 .575 r
.50844 .73718 m .50734 .74662 L .50337 .74419 L p F P
0 g
s
.938 .808 .351 r
.50153 .71737 m .50314 .70863 L .5035 .71136 L p F P
0 g
s
.938 .808 .351 r
.5035 .71136 m .50191 .72027 L .50153 .71737 L p F P
0 g
s
.51 .338 .583 r
.54454 .73701 m .54565 .74644 L .54087 .7484 L p F P
0 g
s
.41 .267 .574 r
.54565 .74644 m .54454 .73701 L .54821 .73466 L p F P
0 g
s
.018 .001 .491 r
.5492 .71114 m .55079 .72004 L .54937 .72284 L p F P
0 g
s
0 0 .332 r
.55079 .72004 m .5492 .71114 L .54947 .7084 L p F P
0 g
s
.794 .563 .587 r
.51137 .75813 m .51219 .74854 L .51768 .74986 L p F P
0 g
s
.794 .563 .587 r
.51768 .74986 m .51718 .75951 L .51137 .75813 L p F P
0 g
s
.644 .438 .589 r
.53543 .74977 m .53595 .75942 L .52975 .76017 L p F P
0 g
s
.365 .132 .421 r
.51302 .69104 m .51401 .68301 L .5109 .68468 L p F P
0 g
s
.365 .132 .421 r
.5109 .68468 m .50966 .69284 L .51302 .69104 L p F P
0 g
s
.937 .598 .361 r
.54151 .68453 m .54272 .69268 L .54537 .6948 L p F P
0 g
s
.88 .552 .425 r
.54272 .69268 m .54151 .68453 L .53834 .68289 L p F P
0 g
s
0 0 .211 r
.50565 .70335 m .50709 .69499 L .50542 .6974 L p F P
0 g
s
0 0 .211 r
.50542 .6974 m .50387 .70591 L .50565 .70335 L p F P
0 g
s
.999 .797 .499 r
.50032 .72923 m .50191 .72027 L .50343 .72306 L p F P
0 g
s
.999 .797 .499 r
.50343 .72306 m .50194 .73218 L .50032 .72923 L p F P
0 g
s
.798 .528 0 r
.54711 .69719 m .54866 .7057 L .54947 .7084 L p F P
0 g
s
.955 .619 .227 r
.54866 .7057 m .54711 .69719 L .54537 .6948 L p F P
0 g
s
.262 .164 .551 r
.54937 .72284 m .55087 .73195 L .54821 .73466 L p F P
0 g
s
.018 .001 .491 r
.55087 .73195 m .54937 .72284 L .55079 .72004 L p F P
0 g
s
.966 .687 .452 r
.56965 .84812 m .56798 .83791 L .55468 .83219 L p F P
0 g
s
.966 .687 .452 r
.55353 .82213 m .55468 .83219 L .56798 .83791 L p F P
0 g
s
.966 .687 .452 r
.53611 .74618 m .53554 .73675 L .52632 .72845 L p F P
0 g
s
.966 .687 .452 r
.52632 .71952 m .52632 .72845 L .53554 .73675 L p F P
0 g
s
.845 .61 .584 r
.50624 .75611 m .50734 .74662 L .51219 .74854 L p F P
0 g
s
.845 .61 .584 r
.51219 .74854 m .51137 .75813 L .50624 .75611 L p F P
0 g
s
.51 .338 .583 r
.54171 .75798 m .54087 .7484 L .54565 .74644 L p F P
0 g
s
.957 .73 .554 r
.50044 .74135 m .50194 .73218 L .50469 .73487 L p F P
0 g
s
.957 .73 .554 r
.50469 .73487 m .50337 .74419 L .50044 .74135 L p F P
0 g
s
.487 .234 .455 r
.51701 .68968 m .51771 .68174 L .51401 .68301 L p F P
0 g
s
.487 .234 .455 r
.51401 .68301 m .51302 .69104 L .51701 .68968 L p F P
0 g
s
.41 .267 .574 r
.54821 .73466 m .54955 .74397 L .54565 .74644 L p F P
0 g
s
.262 .164 .551 r
.54955 .74397 m .54821 .73466 L .55087 .73195 L p F P
0 g
s
.88 .552 .425 r
.53834 .68289 m .5393 .69091 L .54272 .69268 L p F P
0 g
s
.821 .506 .457 r
.5393 .69091 m .53834 .68289 L .5346 .68166 L p F P
0 g
s
0 0 0 r
.5023 .71448 m .50387 .70591 L .50314 .70863 L p F P
0 g
s
0 0 0 r
.50314 .70863 m .50153 .71737 L .5023 .71448 L p F P
0 g
s
.746 .521 .589 r
.51667 .76921 m .51718 .75951 L .5234 .7602 L p F P
0 g
s
.746 .521 .589 r
.5234 .7602 m .52324 .76993 L .51667 .76921 L p F P
0 g
s
.697 .48 .59 r
.52324 .76993 m .5234 .7602 L .52975 .76017 L p F P
0 g
s
.697 .48 .59 r
.52975 .76017 m .52994 .7699 L .52324 .76993 L p F P
0 g
s
.644 .438 .589 r
.52994 .7699 m .52975 .76017 L .53595 .75942 L p F P
0 g
s
0 0 .332 r
.54947 .7084 m .55108 .71713 L .55079 .72004 L p F P
0 g
s
.798 .528 0 r
.55108 .71713 m .54947 .7084 L .54866 .7057 L p F P
0 g
s
.176 0 .354 r
.50841 .70104 m .50966 .69284 L .50709 .69499 L p F P
0 g
s
.176 0 .354 r
.50709 .69499 m .50565 .70335 L .50841 .70104 L p F P
0 g
s
.9 .665 .575 r
.50203 .75355 m .50337 .74419 L .50734 .74662 L p F P
0 g
s
.9 .665 .575 r
.50734 .74662 m .50624 .75611 L .50203 .75355 L p F P
0 g
s
.794 .563 .587 r
.51055 .76776 m .51137 .75813 L .51718 .75951 L p F P
0 g
s
.794 .563 .587 r
.51718 .75951 m .51667 .76921 L .51055 .76776 L p F P
0 g
s
.937 .598 .361 r
.54679 .70314 m .54537 .6948 L .54272 .69268 L p F P
0 g
s
.955 .619 .227 r
.54537 .6948 m .54679 .70314 L .54866 .7057 L p F P
0 g
s
.644 .438 .589 r
.53595 .75942 m .53648 .76912 L .52994 .7699 L p F P
0 g
s
.575 .307 .472 r
.52145 .68883 m .52181 .68095 L .51771 .68174 L p F P
0 g
s
.575 .307 .472 r
.51771 .68174 m .51701 .68968 L .52145 .68883 L p F P
0 g
s
.51 .338 .583 r
.54565 .74644 m .54677 .75592 L .54171 .75798 L p F P
0 g
s
.41 .267 .574 r
.54677 .75592 m .54565 .74644 L .54955 .74397 L p F P
0 g
s
.821 .506 .457 r
.5346 .68166 m .53527 .68959 L .5393 .69091 L p F P
0 g
s
.763 .461 .473 r
.53527 .68959 m .5346 .68166 L .53047 .68091 L p F P
0 g
s
.966 .687 .452 r
.57132 .85836 m .56965 .84812 L .55583 .84229 L p F P
0 g
s
.966 .687 .452 r
.55468 .83219 m .55583 .84229 L .56965 .84812 L p F P
0 g
s
.938 .808 .351 r
.49991 .72616 m .50153 .71737 L .50191 .72027 L p F P
0 g
s
.938 .808 .351 r
.50191 .72027 m .50032 .72923 L .49991 .72616 L p F P
0 g
s
.018 .001 .491 r
.55079 .72004 m .55239 .72898 L .55087 .73195 L p F P
0 g
s
0 0 .332 r
.55239 .72898 m .55079 .72004 L .55108 .71713 L p F P
0 g
s
.645 .365 .48 r
.52612 .68852 m .52614 .68067 L .52181 .68095 L p F P
0 g
s
.645 .365 .48 r
.52181 .68095 m .52145 .68883 L .52612 .68852 L p F P
0 g
s
.763 .461 .473 r
.53047 .68091 m .5308 .68878 L .53527 .68959 L p F P
0 g
s
.706 .415 .48 r
.5308 .68878 m .53047 .68091 L .52614 .68067 L p F P
0 g
s
.706 .415 .48 r
.52614 .68067 m .52612 .68852 L .5308 .68878 L p F P
0 g
s
.845 .61 .584 r
.50514 .76564 m .50624 .75611 L .51137 .75813 L p F P
0 g
s
.845 .61 .584 r
.51137 .75813 m .51055 .76776 L .50514 .76564 L p F P
0 g
s
.999 .797 .499 r
.49872 .73824 m .50032 .72923 L .50194 .73218 L p F P
0 g
s
.999 .797 .499 r
.50194 .73218 m .50044 .74135 L .49872 .73824 L p F P
0 g
s
.51 .338 .583 r
.54256 .76761 m .54171 .75798 L .54677 .75592 L p F P
0 g
s
.966 .687 .452 r
.53667 .75565 m .53611 .74618 L .52632 .73743 L p F P
0 g
s
.966 .687 .452 r
.52632 .72845 m .52632 .73743 L .53611 .74618 L p F P
0 g
s
.262 .164 .551 r
.55087 .73195 m .55238 .74111 L .54955 .74397 L p F P
0 g
s
.018 .001 .491 r
.55238 .74111 m .55087 .73195 L .55239 .72898 L p F P
0 g
s
0 0 .211 r
.50421 .71175 m .50565 .70335 L .50387 .70591 L p F P
0 g
s
0 0 .211 r
.50387 .70591 m .5023 .71448 L .50421 .71175 L p F P
0 g
s
.365 .132 .421 r
.51202 .69912 m .51302 .69104 L .50966 .69284 L p F P
0 g
s
.365 .132 .421 r
.50966 .69284 m .50841 .70104 L .51202 .69912 L p F P
0 g
s
.798 .528 0 r
.54866 .7057 m .55021 .71425 L .55108 .71713 L p F P
0 g
s
.955 .619 .227 r
.55021 .71425 m .54866 .7057 L .54679 .70314 L p F P
0 g
s
.937 .598 .361 r
.54272 .69268 m .54395 .70087 L .54679 .70314 L p F P
0 g
s
.88 .552 .425 r
.54395 .70087 m .54272 .69268 L .5393 .69091 L p F P
0 g
s
.957 .73 .554 r
.49894 .75057 m .50044 .74135 L .50337 .74419 L p F P
0 g
s
.957 .73 .554 r
.50337 .74419 m .50203 .75355 L .49894 .75057 L p F P
0 g
s
.746 .521 .589 r
.51617 .77895 m .51667 .76921 L .52324 .76993 L p F P
0 g
s
.746 .521 .589 r
.52324 .76993 m .52308 .77971 L .51617 .77895 L p F P
0 g
s
.697 .48 .59 r
.52308 .77971 m .52324 .76993 L .52994 .7699 L p F P
0 g
s
.966 .687 .452 r
.573 .86864 m .57132 .85836 L .55698 .85243 L p F P
0 g
s
.966 .687 .452 r
.55583 .84229 m .55698 .85243 L .57132 .85836 L p F P
0 g
s
.697 .48 .59 r
.52994 .7699 m .53013 .77967 L .52308 .77971 L p F P
0 g
s
.644 .438 .589 r
.53013 .77967 m .52994 .7699 L .53648 .76912 L p F P
0 g
s
.41 .267 .574 r
.54955 .74397 m .5509 .75332 L .54677 .75592 L p F P
0 g
s
.262 .164 .551 r
.5509 .75332 m .54955 .74397 L .55238 .74111 L p F P
0 g
s
0 0 0 r
.50073 .7231 m .5023 .71448 L .50153 .71737 L p F P
0 g
s
0 0 0 r
.50153 .71737 m .49991 .72616 L .50073 .7231 L p F P
0 g
s
.794 .563 .587 r
.50972 .77743 m .51055 .76776 L .51667 .76921 L p F P
0 g
s
.794 .563 .587 r
.51667 .76921 m .51617 .77895 L .50972 .77743 L p F P
0 g
s
.644 .438 .589 r
.53648 .76912 m .53701 .77885 L .53013 .77967 L p F P
0 g
s
.9 .665 .575 r
.50069 .76296 m .50203 .75355 L .50624 .75611 L p F P
0 g
s
.9 .665 .575 r
.50624 .75611 m .50514 .76564 L .50069 .76296 L p F P
0 g
s
0 0 .332 r
.55108 .71713 m .5527 .7259 L .55239 .72898 L p F P
0 g
s
.798 .528 0 r
.5527 .7259 m .55108 .71713 L .55021 .71425 L p F P
0 g
s
.51 .338 .583 r
.54677 .75592 m .5479 .76544 L .54256 .76761 L p F P
0 g
s
.41 .267 .574 r
.5479 .76544 m .54677 .75592 L .5509 .75332 L p F P
0 g
s
.487 .234 .455 r
.51632 .69767 m .51701 .68968 L .51302 .69104 L p F P
0 g
s
.487 .234 .455 r
.51302 .69104 m .51202 .69912 L .51632 .69767 L p F P
0 g
s
.88 .552 .425 r
.5393 .69091 m .54028 .69898 L .54395 .70087 L p F P
0 g
s
.821 .506 .457 r
.54028 .69898 m .5393 .69091 L .53527 .68959 L p F P
0 g
s
.176 0 .354 r
.50716 .7093 m .50841 .70104 L .50565 .70335 L p F P
0 g
s
.176 0 .354 r
.50565 .70335 m .50421 .71175 L .50716 .7093 L p F P
0 g
s
.938 .808 .351 r
.49828 .73499 m .49991 .72616 L .50032 .72923 L p F P
0 g
s
.938 .808 .351 r
.50032 .72923 m .49872 .73824 L .49828 .73499 L p F P
0 g
s
.937 .598 .361 r
.54822 .71153 m .54679 .70314 L .54395 .70087 L p F P
0 g
s
.955 .619 .227 r
.54679 .70314 m .54822 .71153 L .55021 .71425 L p F P
0 g
s
.018 .001 .491 r
.55239 .72898 m .554 .73798 L .55238 .74111 L p F P
0 g
s
0 0 .332 r
.554 .73798 m .55239 .72898 L .5527 .7259 L p F P
0 g
s
.845 .61 .584 r
.50403 .77522 m .50514 .76564 L .51055 .76776 L p F P
0 g
s
.845 .61 .584 r
.51055 .76776 m .50972 .77743 L .50403 .77522 L p F P
0 g
s
.966 .687 .452 r
.55698 .85243 m .55814 .86261 L .573 .86864 L p F P
0 g
s
.51 .338 .583 r
.54341 .77727 m .54256 .76761 L .5479 .76544 L p F P
0 g
s
.575 .307 .472 r
.52109 .69675 m .52145 .68883 L .51701 .68968 L p F P
0 g
s
.575 .307 .472 r
.51701 .68968 m .51632 .69767 L .52109 .69675 L p F P
0 g
s
.821 .506 .457 r
.53527 .68959 m .53594 .69757 L .54028 .69898 L p F P
0 g
s
.763 .461 .473 r
.53594 .69757 m .53527 .68959 L .5308 .68878 L p F P
0 g
s
.966 .687 .452 r
.53725 .76517 m .53667 .75565 L .52632 .74646 L p F P
0 g
s
.966 .687 .452 r
.52632 .73743 m .52632 .74646 L .53667 .75565 L p F P
0 g
s
.999 .797 .499 r
.49711 .7473 m .49872 .73824 L .50044 .74135 L p F P
0 g
s
.999 .797 .499 r
.50044 .74135 m .49894 .75057 L .49711 .7473 L p F P
0 g
s
.262 .164 .551 r
.55238 .74111 m .5539 .75031 L .5509 .75332 L p F P
0 g
s
.018 .001 .491 r
.5539 .75031 m .55238 .74111 L .554 .73798 L p F P
0 g
s
.645 .365 .48 r
.52611 .69643 m .52612 .68852 L .52145 .68883 L p F P
0 g
s
.645 .365 .48 r
.52145 .68883 m .52109 .69675 L .52611 .69643 L p F P
0 g
s
.746 .521 .589 r
.51566 .78873 m .51617 .77895 L .52308 .77971 L p F P
0 g
s
.746 .521 .589 r
.52308 .77971 m .52292 .78952 L .51566 .78873 L p F P
0 g
s
.697 .48 .59 r
.52292 .78952 m .52308 .77971 L .53013 .77967 L p F P
0 g
s
.763 .461 .473 r
.5308 .68878 m .53114 .6967 L .53594 .69757 L p F P
0 g
s
.706 .415 .48 r
.53114 .6967 m .5308 .68878 L .52612 .68852 L p F P
0 g
s
.697 .48 .59 r
.53013 .77967 m .53032 .78949 L .52292 .78952 L p F P
0 g
s
.644 .438 .589 r
.53032 .78949 m .53013 .77967 L .53701 .77885 L p F P
0 g
s
.957 .73 .554 r
.49742 .75983 m .49894 .75057 L .50203 .75355 L p F P
0 g
s
.957 .73 .554 r
.50203 .75355 m .50069 .76296 L .49742 .75983 L p F P
0 g
s
.706 .415 .48 r
.52612 .68852 m .52611 .69643 L .53114 .6967 L p F P
0 g
s
0 0 .211 r
.50276 .7202 m .50421 .71175 L .5023 .71448 L p F P
0 g
s
0 0 .211 r
.5023 .71448 m .50073 .7231 L .50276 .7202 L p F P
0 g
s
.41 .267 .574 r
.5509 .75332 m .55226 .76272 L .5479 .76544 L p F P
0 g
s
.262 .164 .551 r
.55226 .76272 m .5509 .75332 L .5539 .75031 L p F P
0 g
s
.798 .528 0 r
.55021 .71425 m .55178 .72285 L .5527 .7259 L p F P
0 g
s
.955 .619 .227 r
.55178 .72285 m .55021 .71425 L .54822 .71153 L p F P
0 g
s
.365 .132 .421 r
.51102 .70725 m .51202 .69912 L .50841 .70104 L p F P
0 g
s
.365 .132 .421 r
.50841 .70104 m .50716 .7093 L .51102 .70725 L p F P
0 g
s
.794 .563 .587 r
.50889 .78715 m .50972 .77743 L .51617 .77895 L p F P
0 g
s
.794 .563 .587 r
.51617 .77895 m .51566 .78873 L .50889 .78715 L p F P
0 g
s
.644 .438 .589 r
.53701 .77885 m .53755 .78863 L .53032 .78949 L p F P
0 g
s
.937 .598 .361 r
.54395 .70087 m .54518 .70911 L .54822 .71153 L p F P
0 g
s
.88 .552 .425 r
.54518 .70911 m .54395 .70087 L .54028 .69898 L p F P
0 g
s
.9 .665 .575 r
.49935 .77242 m .50069 .76296 L .50514 .76564 L p F P
0 g
s
.9 .665 .575 r
.50514 .76564 m .50403 .77522 L .49935 .77242 L p F P
0 g
s
.51 .338 .583 r
.5479 .76544 m .54903 .77501 L .54341 .77727 L p F P
0 g
s
.41 .267 .574 r
.54903 .77501 m .5479 .76544 L .55226 .76272 L p F P
0 g
s
0 0 0 r
.49915 .73177 m .50073 .7231 L .49991 .72616 L p F P
0 g
s
0 0 0 r
.49991 .72616 m .49828 .73499 L .49915 .73177 L p F P
0 g
s
0 0 .332 r
.5527 .7259 m .55433 .73473 L .554 .73798 L p F P
0 g
s
.798 .528 0 r
.55433 .73473 m .5527 .7259 L .55178 .72285 L p F P
0 g
s
.845 .61 .584 r
.50291 .78484 m .50403 .77522 L .50972 .77743 L p F P
0 g
s
.845 .61 .584 r
.50972 .77743 m .50889 .78715 L .50291 .78484 L p F P
0 g
s
.51 .338 .583 r
.54427 .78698 m .54341 .77727 L .54903 .77501 L p F P
0 g
s
.938 .808 .351 r
.49664 .74388 m .49828 .73499 L .49872 .73824 L p F P
0 g
s
.938 .808 .351 r
.49872 .73824 m .49711 .7473 L .49664 .74388 L p F P
0 g
s
.487 .234 .455 r
.51562 .7057 m .51632 .69767 L .51202 .69912 L p F P
0 g
s
.487 .234 .455 r
.51202 .69912 m .51102 .70725 L .51562 .7057 L p F P
0 g
s
.88 .552 .425 r
.54028 .69898 m .54125 .7071 L .54518 .70911 L p F P
0 g
s
.821 .506 .457 r
.54125 .7071 m .54028 .69898 L .53594 .69757 L p F P
0 g
s
.018 .001 .491 r
.554 .73798 m .55562 .74702 L .5539 .75031 L p F P
0 g
s
0 0 .332 r
.55562 .74702 m .554 .73798 L .55433 .73473 L p F P
0 g
s
.966 .687 .452 r
.53782 .77473 m .53725 .76517 L .52632 .75554 L p F P
0 g
s
.966 .687 .452 r
.52632 .74646 m .52632 .75554 L .53725 .76517 L p F P
0 g
s
.176 0 .354 r
.5059 .71761 m .50716 .7093 L .50421 .71175 L p F P
0 g
s
.176 0 .354 r
.50421 .71175 m .50276 .7202 L .5059 .71761 L p F P
0 g
s
.937 .598 .361 r
.54966 .71998 m .54822 .71153 L .54518 .70911 L p F P
0 g
s
.955 .619 .227 r
.54822 .71153 m .54966 .71998 L .55178 .72285 L p F P
0 g
s
.999 .797 .499 r
.49549 .7564 m .49711 .7473 L .49894 .75057 L p F P
0 g
s
.999 .797 .499 r
.49894 .75057 m .49742 .75983 L .49549 .7564 L p F P
0 g
s
.746 .521 .589 r
.51516 .79855 m .51566 .78873 L .52292 .78952 L p F P
0 g
s
.746 .521 .589 r
.52292 .78952 m .52275 .79938 L .51516 .79855 L p F P
0 g
s
.697 .48 .59 r
.52275 .79938 m .52292 .78952 L .53032 .78949 L p F P
0 g
s
.697 .48 .59 r
.53032 .78949 m .53051 .79934 L .52275 .79938 L p F P
0 g
s
.644 .438 .589 r
.53051 .79934 m .53032 .78949 L .53755 .78863 L p F P
0 g
s
.262 .164 .551 r
.5539 .75031 m .55542 .75956 L .55226 .76272 L p F P
0 g
s
.018 .001 .491 r
.55542 .75956 m .5539 .75031 L .55562 .74702 L p F P
0 g
s
.957 .73 .554 r
.4959 .76915 m .49742 .75983 L .50069 .76296 L p F P
0 g
s
.957 .73 .554 r
.50069 .76296 m .49935 .77242 L .4959 .76915 L p F P
0 g
s
.575 .307 .472 r
.52072 .70473 m .52109 .69675 L .51632 .69767 L p F P
0 g
s
.575 .307 .472 r
.51632 .69767 m .51562 .7057 L .52072 .70473 L p F P
0 g
s
.41 .267 .574 r
.55226 .76272 m .55362 .77216 L .54903 .77501 L p F P
0 g
s
.262 .164 .551 r
.55362 .77216 m .55226 .76272 L .55542 .75956 L p F P
0 g
s
.821 .506 .457 r
.53594 .69757 m .53661 .7056 L .54125 .7071 L p F P
0 g
s
.763 .461 .473 r
.53661 .7056 m .53594 .69757 L .53114 .6967 L p F P
0 g
s
.794 .563 .587 r
.50806 .79691 m .50889 .78715 L .51566 .78873 L p F P
0 g
s
.794 .563 .587 r
.51566 .78873 m .51516 .79855 L .50806 .79691 L p F P
0 g
s
.644 .438 .589 r
.53755 .78863 m .53809 .79845 L .53051 .79934 L p F P
0 g
s
1 0 0 r
.03 w
.66035 .61112 Mdot
.5 Mabswid
.9 .665 .575 r
.49799 .78192 m .49935 .77242 L .50403 .77522 L p F P
0 g
s
.9 .665 .575 r
.50403 .77522 m .50291 .78484 L .49799 .78192 L p F P
0 g
s
0 0 .211 r
.5013 .72871 m .50276 .7202 L .50073 .7231 L p F P
0 g
s
0 0 .211 r
.50073 .7231 m .49915 .73177 L .5013 .72871 L p F P
0 g
s
.51 .338 .583 r
.54903 .77501 m .55017 .78462 L .54427 .78698 L p F P
0 g
s
.41 .267 .574 r
.55017 .78462 m .54903 .77501 L .55362 .77216 L p F P
0 g
s
.798 .528 0 r
.55178 .72285 m .55336 .73151 L .55433 .73473 L p F P
0 g
s
.955 .619 .227 r
.55336 .73151 m .55178 .72285 L .54966 .71998 L p F P
0 g
s
.645 .365 .48 r
.52609 .70439 m .52611 .69643 L .52109 .69675 L p F P
0 g
s
.645 .365 .48 r
.52109 .69675 m .52072 .70473 L .52609 .70439 L p F P
0 g
s
.763 .461 .473 r
.53114 .6967 m .53148 .70468 L .53661 .7056 L p F P
0 g
s
.706 .415 .48 r
.53148 .70468 m .53114 .6967 L .52611 .69643 L p F P
0 g
s
.706 .415 .48 r
.52611 .69643 m .52609 .70439 L .53148 .70468 L p F P
0 g
s
.365 .132 .421 r
.51002 .71544 m .51102 .70725 L .50716 .7093 L p F P
0 g
s
.365 .132 .421 r
.50716 .7093 m .5059 .71761 L .51002 .71544 L p F P
0 g
s
.937 .598 .361 r
.54518 .70911 m .54643 .71741 L .54966 .71998 L p F P
0 g
s
.88 .552 .425 r
.54643 .71741 m .54518 .70911 L .54125 .7071 L p F P
0 g
s
0 0 0 r
.49755 .74048 m .49915 .73177 L .49828 .73499 L p F P
0 g
s
0 0 0 r
.49828 .73499 m .49664 .74388 L .49755 .74048 L p F P
0 g
s
.845 .61 .584 r
.50179 .79451 m .50291 .78484 L .50889 .78715 L p F P
0 g
s
.845 .61 .584 r
.50889 .78715 m .50806 .79691 L .50179 .79451 L p F P
0 g
s
.51 .338 .583 r
.54513 .79674 m .54427 .78698 L .55017 .78462 L p F P
0 g
s
0 0 .332 r
.55433 .73473 m .55597 .7436 L .55562 .74702 L p F P
0 g
s
.798 .528 0 r
.55597 .7436 m .55433 .73473 L .55336 .73151 L p F P
0 g
s
.938 .808 .351 r
.49499 .75282 m .49664 .74388 L .49711 .7473 L p F P
0 g
s
.938 .808 .351 r
.49711 .7473 m .49549 .7564 L .49499 .75282 L p F P
0 g
s
.966 .687 .452 r
.5384 .78434 m .53782 .77473 L .52632 .76467 L p F P
0 g
s
.966 .687 .452 r
.52632 .75554 m .52632 .76467 L .53782 .77473 L p F P
0 g
s
.746 .521 .589 r
.51464 .80842 m .51516 .79855 L .52275 .79938 L p F P
0 g
s
.746 .521 .589 r
.52275 .79938 m .52259 .80928 L .51464 .80842 L p F P
0 g
s
.697 .48 .59 r
.52259 .80928 m .52275 .79938 L .53051 .79934 L p F P
0 g
s
.697 .48 .59 r
.53051 .79934 m .53071 .80924 L .52259 .80928 L p F P
0 g
s
.644 .438 .589 r
.53071 .80924 m .53051 .79934 L .53809 .79845 L p F P
0 g
s
.018 .001 .491 r
.55562 .74702 m .55724 .75611 L .55542 .75956 L p F P
0 g
s
0 0 .332 r
.55724 .75611 m .55562 .74702 L .55597 .7436 L p F P
0 g
s
.999 .797 .499 r
.49386 .76555 m .49549 .7564 L .49742 .75983 L p F P
0 g
s
.999 .797 .499 r
.49742 .75983 m .4959 .76915 L .49386 .76555 L p F P
0 g
s
.262 .164 .551 r
.55542 .75956 m .55695 .76886 L .55362 .77216 L p F P
0 g
s
.018 .001 .491 r
.55695 .76886 m .55542 .75956 L .55724 .75611 L p F P
0 g
s
.487 .234 .455 r
.51491 .7138 m .51562 .7057 L .51102 .70725 L p F P
0 g
s
.487 .234 .455 r
.51102 .70725 m .51002 .71544 L .51491 .7138 L p F P
0 g
s
.794 .563 .587 r
.50722 .80671 m .50806 .79691 L .51516 .79855 L p F P
0 g
s
.794 .563 .587 r
.51516 .79855 m .51464 .80842 L .50722 .80671 L p F P
0 g
s
.957 .73 .554 r
.49437 .7785 m .4959 .76915 L .49935 .77242 L p F P
0 g
s
.957 .73 .554 r
.49935 .77242 m .49799 .78192 L .49437 .7785 L p F P
0 g
s
.176 0 .354 r
.50463 .72597 m .5059 .71761 L .50276 .7202 L p F P
0 g
s
.176 0 .354 r
.50276 .7202 m .5013 .72871 L .50463 .72597 L p F P
0 g
s
.88 .552 .425 r
.54125 .7071 m .54224 .71528 L .54643 .71741 L p F P
0 g
s
.821 .506 .457 r
.54224 .71528 m .54125 .7071 L .53661 .7056 L p F P
0 g
s
.644 .438 .589 r
.53809 .79845 m .53862 .80831 L .53071 .80924 L p F P
0 g
s
.937 .598 .361 r
.5511 .72847 m .54966 .71998 L .54643 .71741 L p F P
0 g
s
.955 .619 .227 r
.54966 .71998 m .5511 .72847 L .55336 .73151 L p F P
0 g
s
.41 .267 .574 r
.55362 .77216 m .55499 .78165 L .55017 .78462 L p F P
0 g
s
.262 .164 .551 r
.55499 .78165 m .55362 .77216 L .55695 .76886 L p F P
0 g
s
.9 .665 .575 r
.49663 .79146 m .49799 .78192 L .50291 .78484 L p F P
0 g
s
.9 .665 .575 r
.50291 .78484 m .50179 .79451 L .49663 .79146 L p F P
0 g
s
.51 .338 .583 r
.55017 .78462 m .55131 .79428 L .54513 .79674 L p F P
0 g
s
.41 .267 .574 r
.55131 .79428 m .55017 .78462 L .55499 .78165 L p F P
0 g
s
.575 .307 .472 r
.52035 .71277 m .52072 .70473 L .51562 .7057 L p F P
0 g
s
.575 .307 .472 r
.51562 .7057 m .51491 .7138 L .52035 .71277 L p F P
0 g
s
0 0 .211 r
.49983 .73726 m .5013 .72871 L .49915 .73177 L p F P
0 g
s
0 0 .211 r
.49915 .73177 m .49755 .74048 L .49983 .73726 L p F P
0 g
s
.821 .506 .457 r
.53661 .7056 m .53729 .71369 L .54224 .71528 L p F P
0 g
s
.763 .461 .473 r
.53729 .71369 m .53661 .7056 L .53148 .70468 L p F P
0 g
s
.845 .61 .584 r
.50066 .80422 m .50179 .79451 L .50806 .79691 L p F P
0 g
s
.845 .61 .584 r
.50806 .79691 m .50722 .80671 L .50066 .80422 L p F P
0 g
s
.798 .528 0 r
.55336 .73151 m .55494 .74021 L .55597 .7436 L p F P
0 g
s
.955 .619 .227 r
.55494 .74021 m .55336 .73151 L .5511 .72847 L p F P
0 g
s
.51 .338 .583 r
.54599 .80654 m .54513 .79674 L .55131 .79428 L p F P
0 g
s
.645 .365 .48 r
.52608 .7124 m .52609 .70439 L .52072 .70473 L p F P
0 g
s
.645 .365 .48 r
.52072 .70473 m .52035 .71277 L .52608 .7124 L p F P
0 g
s
.746 .521 .589 r
.51413 .81834 m .51464 .80842 L .52259 .80928 L p F P
0 g
s
.746 .521 .589 r
.52259 .80928 m .52243 .81922 L .51413 .81834 L p F P
0 g
s
.697 .48 .59 r
.52243 .81922 m .52259 .80928 L .53071 .80924 L p F P
0 g
s
.763 .461 .473 r
.53148 .70468 m .53182 .71271 L .53729 .71369 L p F P
0 g
s
.706 .415 .48 r
.53182 .71271 m .53148 .70468 L .52609 .70439 L p F P
0 g
s
0 0 0 r
.49595 .74925 m .49755 .74048 L .49664 .74388 L p F P
0 g
s
0 0 0 r
.49664 .74388 m .49499 .75282 L .49595 .74925 L p F P
0 g
s
.697 .48 .59 r
.53071 .80924 m .5309 .81918 L .52243 .81922 L p F P
0 g
s
.644 .438 .589 r
.5309 .81918 m .53071 .80924 L .53862 .80831 L p F P
0 g
s
.365 .132 .421 r
.509 .72367 m .51002 .71544 L .5059 .71761 L p F P
0 g
s
.365 .132 .421 r
.5059 .71761 m .50463 .72597 L .509 .72367 L p F P
0 g
s
.966 .687 .452 r
.53898 .794 m .5384 .78434 L .52632 .77385 L p F P
0 g
s
.966 .687 .452 r
.52632 .76467 m .52632 .77385 L .5384 .78434 L p F P
0 g
s
.706 .415 .48 r
.52609 .70439 m .52608 .7124 L .53182 .71271 L p F P
0 g
s
0 0 .332 r
.55597 .7436 m .55762 .75252 L .55724 .75611 L p F P
0 g
s
.798 .528 0 r
.55762 .75252 m .55597 .7436 L .55494 .74021 L p F P
0 g
s
.937 .598 .361 r
.54643 .71741 m .54768 .72576 L .5511 .72847 L p F P
0 g
s
.88 .552 .425 r
.54768 .72576 m .54643 .71741 L .54224 .71528 L p F P
0 g
s
.938 .808 .351 r
.49333 .7618 m .49499 .75282 L .49549 .7564 L p F P
0 g
s
.938 .808 .351 r
.49549 .7564 m .49386 .76555 L .49333 .7618 L p F P
0 g
s
.018 .001 .491 r
.55724 .75611 m .55887 .76525 L .55695 .76886 L p F P
0 g
s
0 0 .332 r
.55887 .76525 m .55724 .75611 L .55762 .75252 L p F P
0 g
s
.794 .563 .587 r
.50638 .81656 m .50722 .80671 L .51464 .80842 L p F P
0 g
s
.794 .563 .587 r
.51464 .80842 m .51413 .81834 L .50638 .81656 L p F P
0 g
s
.999 .797 .499 r
.49222 .77475 m .49386 .76555 L .4959 .76915 L p F P
0 g
s
.999 .797 .499 r
.4959 .76915 m .49437 .7785 L .49222 .77475 L p F P
0 g
s
.644 .438 .589 r
.53862 .80831 m .53917 .81822 L .5309 .81918 L p F P
0 g
s
.262 .164 .551 r
.55695 .76886 m .55849 .7782 L .55499 .78165 L p F P
0 g
s
.018 .001 .491 r
.55849 .7782 m .55695 .76886 L .55887 .76525 L p F P
0 g
s
.957 .73 .554 r
.49284 .78791 m .49437 .7785 L .49799 .78192 L p F P
0 g
s
.957 .73 .554 r
.49799 .78192 m .49663 .79146 L .49284 .78791 L p F P
0 g
s
.41 .267 .574 r
.55499 .78165 m .55637 .79119 L .55131 .79428 L p F P
0 g
s
.262 .164 .551 r
.55637 .79119 m .55499 .78165 L .55849 .7782 L p F P
0 g
s
.9 .665 .575 r
.49527 .80106 m .49663 .79146 L .50179 .79451 L p F P
0 g
s
.9 .665 .575 r
.50179 .79451 m .50066 .80422 L .49527 .80106 L p F P
0 g
s
.51 .338 .583 r
.55131 .79428 m .55246 .80398 L .54599 .80654 L p F P
0 g
s
.41 .267 .574 r
.55246 .80398 m .55131 .79428 L .55637 .79119 L p F P
0 g
s
.176 0 .354 r
.50336 .73438 m .50463 .72597 L .5013 .72871 L p F P
0 g
s
.176 0 .354 r
.5013 .72871 m .49983 .73726 L .50336 .73438 L p F P
0 g
s
.487 .234 .455 r
.5142 .72194 m .51491 .7138 L .51002 .71544 L p F P
0 g
s
.487 .234 .455 r
.51002 .71544 m .509 .72367 L .5142 .72194 L p F P
0 g
s
.937 .598 .361 r
.55256 .73701 m .5511 .72847 L .54768 .72576 L p F P
0 g
s
.955 .619 .227 r
.5511 .72847 m .55256 .73701 L .55494 .74021 L p F P
0 g
s
.88 .552 .425 r
.54224 .71528 m .54323 .72351 L .54768 .72576 L p F P
0 g
s
.821 .506 .457 r
.54323 .72351 m .54224 .71528 L .53729 .71369 L p F P
0 g
s
.845 .61 .584 r
.49953 .81398 m .50066 .80422 L .50722 .80671 L p F P
0 g
s
.845 .61 .584 r
.50722 .80671 m .50638 .81656 L .49953 .81398 L p F P
0 g
s
.51 .338 .583 r
.54685 .81638 m .54599 .80654 L .55246 .80398 L p F P
0 g
s
.746 .521 .589 r
.51362 .82829 m .51413 .81834 L .52243 .81922 L p F P
0 g
s
.746 .521 .589 r
.52243 .81922 m .52226 .82921 L .51362 .82829 L p F P
0 g
s
.697 .48 .59 r
.52226 .82921 m .52243 .81922 L .5309 .81918 L p F P
0 g
s
.697 .48 .59 r
.5309 .81918 m .53109 .82917 L .52226 .82921 L p F P
0 g
s
.644 .438 .589 r
.53109 .82917 m .5309 .81918 L .53917 .81822 L p F P
0 g
s
0 0 .211 r
.49835 .74587 m .49983 .73726 L .49755 .74048 L p F P
0 g
s
0 0 .211 r
.49755 .74048 m .49595 .74925 L .49835 .74587 L p F P
0 g
s
.798 .528 0 r
.55494 .74021 m .55654 .74896 L .55762 .75252 L p F P
0 g
s
.955 .619 .227 r
.55654 .74896 m .55494 .74021 L .55256 .73701 L p F P
0 g
s
.966 .687 .452 r
.53956 .8037 m .53898 .794 L .52632 .78308 L p F P
0 g
s
.966 .687 .452 r
.52632 .77385 m .52632 .78308 L .53898 .794 L p F P
0 g
s
.575 .307 .472 r
.51998 .72085 m .52035 .71277 L .51491 .7138 L p F P
0 g
s
.575 .307 .472 r
.51491 .7138 m .5142 .72194 L .51998 .72085 L p F P
0 g
s
.821 .506 .457 r
.53729 .71369 m .53797 .72182 L .54323 .72351 L p F P
0 g
s
.763 .461 .473 r
.53797 .72182 m .53729 .71369 L .53182 .71271 L p F P
0 g
s
0 0 0 r
.49434 .75807 m .49595 .74925 L .49499 .75282 L p F P
0 g
s
0 0 0 r
.49499 .75282 m .49333 .7618 L .49434 .75807 L p F P
0 g
s
.794 .563 .587 r
.50554 .82646 m .50638 .81656 L .51413 .81834 L p F P
0 g
s
.794 .563 .587 r
.51413 .81834 m .51362 .82829 L .50554 .82646 L p F P
0 g
s
.644 .438 .589 r
.53917 .81822 m .53971 .82818 L .53109 .82917 L p F P
0 g
s
0 0 .332 r
.55762 .75252 m .55928 .76149 L .55887 .76525 L p F P
0 g
s
.798 .528 0 r
.55928 .76149 m .55762 .75252 L .55654 .74896 L p F P
0 g
s
.938 .808 .351 r
.49166 .77084 m .49333 .7618 L .49386 .76555 L p F P
0 g
s
.938 .808 .351 r
.49386 .76555 m .49222 .77475 L .49166 .77084 L p F P
0 g
s
.999 .797 .499 r
.49058 .784 m .49222 .77475 L .49437 .7785 L p F P
0 g
s
.999 .797 .499 r
.49437 .7785 m .49284 .78791 L .49058 .784 L p F P
0 g
s
.365 .132 .421 r
.50798 .73196 m .509 .72367 L .50463 .72597 L p F P
0 g
s
.365 .132 .421 r
.50463 .72597 m .50336 .73438 L .50798 .73196 L p F P
0 g
s
.018 .001 .491 r
.55887 .76525 m .56051 .77443 L .55849 .7782 L p F P
0 g
s
0 0 .332 r
.56051 .77443 m .55887 .76525 L .55928 .76149 L p F P
0 g
s
.645 .365 .48 r
.52606 .72046 m .52608 .7124 L .52035 .71277 L p F P
0 g
s
.645 .365 .48 r
.52035 .71277 m .51998 .72085 L .52606 .72046 L p F P
0 g
s
.957 .73 .554 r
.49129 .79736 m .49284 .78791 L .49663 .79146 L p F P
0 g
s
.957 .73 .554 r
.49663 .79146 m .49527 .80106 L .49129 .79736 L p F P
0 g
s
.763 .461 .473 r
.53182 .71271 m .53216 .72079 L .53797 .72182 L p F P
0 g
s
.706 .415 .48 r
.53216 .72079 m .53182 .71271 L .52608 .7124 L p F P
0 g
s
.937 .598 .361 r
.54768 .72576 m .54893 .73416 L .55256 .73701 L p F P
0 g
s
.88 .552 .425 r
.54893 .73416 m .54768 .72576 L .54323 .72351 L p F P
0 g
s
.262 .164 .551 r
.55849 .7782 m .56004 .7876 L .55637 .79119 L p F P
0 g
s
.018 .001 .491 r
.56004 .7876 m .55849 .7782 L .56051 .77443 L p F P
0 g
s
.41 .267 .574 r
.55637 .79119 m .55775 .80077 L .55246 .80398 L p F P
0 g
s
.262 .164 .551 r
.55775 .80077 m .55637 .79119 L .56004 .7876 L p F P
0 g
s
.706 .415 .48 r
.52608 .7124 m .52606 .72046 L .53216 .72079 L p F P
0 g
s
.9 .665 .575 r
.49389 .8107 m .49527 .80106 L .50066 .80422 L p F P
0 g
s
.9 .665 .575 r
.50066 .80422 m .49953 .81398 L .49389 .8107 L p F P
0 g
s
.51 .338 .583 r
.55246 .80398 m .55362 .81373 L .54685 .81638 L p F P
0 g
s
.41 .267 .574 r
.55362 .81373 m .55246 .80398 L .55775 .80077 L p F P
0 g
s
.845 .61 .584 r
.49839 .82378 m .49953 .81398 L .50638 .81656 L p F P
0 g
s
.845 .61 .584 r
.50638 .81656 m .50554 .82646 L .49839 .82378 L p F P
0 g
s
.51 .338 .583 r
.54772 .82627 m .54685 .81638 L .55362 .81373 L p F P
0 g
s
.746 .521 .589 r
.5131 .83829 m .51362 .82829 L .52226 .82921 L p F P
0 g
s
.746 .521 .589 r
.52226 .82921 m .5221 .83924 L .5131 .83829 L p F P
0 g
s
.697 .48 .59 r
.5221 .83924 m .52226 .82921 L .53109 .82917 L p F P
0 g
s
.176 0 .354 r
.50207 .74284 m .50336 .73438 L .49983 .73726 L p F P
0 g
s
.176 0 .354 r
.49983 .73726 m .49835 .74587 L .50207 .74284 L p F P
0 g
s
.697 .48 .59 r
.53109 .82917 m .53129 .8392 L .5221 .83924 L p F P
0 g
s
.644 .438 .589 r
.53129 .8392 m .53109 .82917 L .53971 .82818 L p F P
0 g
s
.937 .598 .361 r
.55402 .74561 m .55256 .73701 L .54893 .73416 L p F P
0 g
s
.955 .619 .227 r
.55256 .73701 m .55402 .74561 L .55654 .74896 L p F P
0 g
s
.487 .234 .455 r
.51348 .73014 m .5142 .72194 L .509 .72367 L p F P
0 g
s
.487 .234 .455 r
.509 .72367 m .50798 .73196 L .51348 .73014 L p F P
0 g
s
.88 .552 .425 r
.54323 .72351 m .54423 .73179 L .54893 .73416 L p F P
0 g
s
.821 .506 .457 r
.54423 .73179 m .54323 .72351 L .53797 .72182 L p F P
0 g
s
.966 .687 .452 r
.54014 .81345 m .53956 .8037 L .52632 .79236 L p F P
0 g
s
.966 .687 .452 r
.52632 .78308 m .52632 .79236 L .53956 .8037 L p F P
0 g
s
.794 .563 .587 r
.50469 .8364 m .50554 .82646 L .51362 .82829 L p F P
0 g
s
.794 .563 .587 r
.51362 .82829 m .5131 .83829 L .50469 .8364 L p F P
0 g
s
.644 .438 .589 r
.53971 .82818 m .54026 .83817 L .53129 .8392 L p F P
0 g
s
0 0 .211 r
.49686 .75453 m .49835 .74587 L .49595 .74925 L p F P
0 g
s
0 0 .211 r
.49595 .74925 m .49434 .75807 L .49686 .75453 L p F P
0 g
s
.798 .528 0 r
.55654 .74896 m .55814 .75777 L .55928 .76149 L p F P
0 g
s
.955 .619 .227 r
.55814 .75777 m .55654 .74896 L .55402 .74561 L p F P
0 g
s
0 0 0 r
.49272 .76694 m .49434 .75807 L .49333 .7618 L p F P
0 g
s
0 0 0 r
.49333 .7618 m .49166 .77084 L .49272 .76694 L p F P
0 g
s
.999 .797 .499 r
.48893 .7933 m .49058 .784 L .49284 .78791 L p F P
0 g
s
.999 .797 .499 r
.49284 .78791 m .49129 .79736 L .48893 .7933 L p F P
0 g
s
.957 .73 .554 r
.48974 .80686 m .49129 .79736 L .49527 .80106 L p F P
0 g
s
.957 .73 .554 r
.49527 .80106 m .49389 .8107 L .48974 .80686 L p F P
0 g
s
.938 .808 .351 r
.48998 .77992 m .49166 .77084 L .49222 .77475 L p F P
0 g
s
.938 .808 .351 r
.49222 .77475 m .49058 .784 L .48998 .77992 L p F P
0 g
s
0 0 .332 r
.55928 .76149 m .56094 .77051 L .56051 .77443 L p F P
0 g
s
.798 .528 0 r
.56094 .77051 m .55928 .76149 L .55814 .75777 L p F P
0 g
s
.575 .307 .472 r
.5196 .72899 m .51998 .72085 L .5142 .72194 L p F P
0 g
s
.575 .307 .472 r
.5142 .72194 m .51348 .73014 L .5196 .72899 L p F P
0 g
s
.9 .665 .575 r
.49251 .82038 m .49389 .8107 L .49953 .81398 L p F P
0 g
s
.9 .665 .575 r
.49953 .81398 m .49839 .82378 L .49251 .82038 L p F P
0 g
s
.41 .267 .574 r
.55775 .80077 m .55914 .8104 L .55362 .81373 L p F P
0 g
s
.262 .164 .551 r
.55914 .8104 m .55775 .80077 L .5616 .79704 L p F P
0 g
s
.262 .164 .551 r
.56004 .7876 m .5616 .79704 L .55775 .80077 L p F P
0 g
s
.018 .001 .491 r
.5616 .79704 m .56004 .7876 L .56216 .78367 L p F P
0 g
s
.018 .001 .491 r
.56051 .77443 m .56216 .78367 L .56004 .7876 L p F P
0 g
s
0 0 .332 r
.56216 .78367 m .56051 .77443 L .56094 .77051 L p F P
0 g
s
.821 .506 .457 r
.53797 .72182 m .53866 .73001 L .54423 .73179 L p F P
0 g
s
.763 .461 .473 r
.53866 .73001 m .53797 .72182 L .53216 .72079 L p F P
0 g
s
.51 .338 .583 r
.55362 .81373 m .55478 .82353 L .54772 .82627 L p F P
0 g
s
.41 .267 .574 r
.55478 .82353 m .55362 .81373 L .55914 .8104 L p F P
0 g
s
.365 .132 .421 r
.50695 .7403 m .50798 .73196 L .50336 .73438 L p F P
0 g
s
.365 .132 .421 r
.50336 .73438 m .50207 .74284 L .50695 .7403 L p F P
0 g
s
.845 .61 .584 r
.49725 .83363 m .49839 .82378 L .50554 .82646 L p F P
0 g
s
.845 .61 .584 r
.50554 .82646 m .50469 .8364 L .49725 .83363 L p F P
0 g
s
.937 .598 .361 r
.54893 .73416 m .5502 .74261 L .55402 .74561 L p F P
0 g
s
.88 .552 .425 r
.5502 .74261 m .54893 .73416 L .54423 .73179 L p F P
0 g
s
.51 .338 .583 r
.5486 .8362 m .54772 .82627 L .55478 .82353 L p F P
0 g
s
.645 .365 .48 r
.52605 .72858 m .52606 .72046 L .51998 .72085 L p F P
0 g
s
.645 .365 .48 r
.51998 .72085 m .5196 .72899 L .52605 .72858 L p F P
0 g
s
.746 .521 .589 r
.51258 .84834 m .5131 .83829 L .5221 .83924 L p F P
0 g
s
.746 .521 .589 r
.5221 .83924 m .52193 .84932 L .51258 .84834 L p F P
0 g
s
.697 .48 .59 r
.52193 .84932 m .5221 .83924 L .53129 .8392 L p F P
0 g
s
.763 .461 .473 r
.53216 .72079 m .5325 .72893 L .53866 .73001 L p F P
0 g
s
.706 .415 .48 r
.5325 .72893 m .53216 .72079 L .52606 .72046 L p F P
0 g
s
.697 .48 .59 r
.53129 .8392 m .53148 .84928 L .52193 .84932 L p F P
0 g
s
.644 .438 .589 r
.53148 .84928 m .53129 .8392 L .54026 .83817 L p F P
0 g
s
.706 .415 .48 r
.52606 .72046 m .52605 .72858 L .5325 .72893 L p F P
0 g
s
.794 .563 .587 r
.50384 .84638 m .50469 .8364 L .5131 .83829 L p F P
0 g
s
.794 .563 .587 r
.5131 .83829 m .51258 .84834 L .50384 .84638 L p F P
0 g
s
.644 .438 .589 r
.54026 .83817 m .5408 .84822 L .53148 .84928 L p F P
0 g
s
.966 .687 .452 r
.54073 .82325 m .54014 .81345 L .52632 .8017 L p F P
0 g
s
.966 .687 .452 r
.52632 .79236 m .52632 .8017 L .54014 .81345 L p F P
0 g
s
.176 0 .354 r
.50078 .75136 m .50207 .74284 L .49835 .74587 L p F P
0 g
s
.176 0 .354 r
.49835 .74587 m .49686 .75453 L .50078 .75136 L p F P
0 g
s
.937 .598 .361 r
.5555 .75425 m .55402 .74561 L .5502 .74261 L p F P
0 g
s
.955 .619 .227 r
.55402 .74561 m .5555 .75425 L .55814 .75777 L p F P
0 g
s
.487 .234 .455 r
.51276 .73839 m .51348 .73014 L .50798 .73196 L p F P
0 g
s
.487 .234 .455 r
.50798 .73196 m .50695 .7403 L .51276 .73839 L p F P
0 g
s
.88 .552 .425 r
.54423 .73179 m .54523 .74012 L .5502 .74261 L p F P
0 g
s
.821 .506 .457 r
.54523 .74012 m .54423 .73179 L .53866 .73001 L p F P
0 g
s
0 0 .211 r
.49536 .76324 m .49686 .75453 L .49434 .75807 L p F P
0 g
s
0 0 .211 r
.49434 .75807 m .49272 .76694 L .49536 .76324 L p F P
0 g
s
.957 .73 .554 r
.48818 .81641 m .48974 .80686 L .49389 .8107 L p F P
0 g
s
.957 .73 .554 r
.49389 .8107 m .49251 .82038 L .48818 .81641 L p F P
0 g
s
.9 .665 .575 r
.49113 .83012 m .49251 .82038 L .49839 .82378 L p F P
0 g
s
.9 .665 .575 r
.49839 .82378 m .49725 .83363 L .49113 .83012 L p F P
0 g
s
.999 .797 .499 r
.48726 .80265 m .48893 .7933 L .49129 .79736 L p F P
0 g
s
.999 .797 .499 r
.49129 .79736 m .48974 .80686 L .48726 .80265 L p F P
0 g
s
.798 .528 0 r
.55814 .75777 m .55975 .76662 L .56094 .77051 L p F P
0 g
s
.955 .619 .227 r
.55975 .76662 m .55814 .75777 L .5555 .75425 L p F P
0 g
s
.41 .267 .574 r
.55914 .8104 m .56054 .82008 L .55478 .82353 L p F P
0 g
s
.262 .164 .551 r
.56054 .82008 m .55914 .8104 L .56316 .80653 L p F P
0 g
s
.262 .164 .551 r
.5616 .79704 m .56316 .80653 L .55914 .8104 L p F P
0 g
s
0 0 0 r
.49109 .77586 m .49272 .76694 L .49166 .77084 L p F P
0 g
s
0 0 0 r
.49166 .77084 m .48998 .77992 L .49109 .77586 L p F P
0 g
s
.938 .808 .351 r
.4883 .78906 m .48998 .77992 L .49058 .784 L p F P
0 g
s
.938 .808 .351 r
.49058 .784 m .48893 .7933 L .4883 .78906 L p F P
0 g
s
.51 .338 .583 r
.55478 .82353 m .55594 .83337 L .5486 .8362 L p F P
0 g
s
.41 .267 .574 r
.55594 .83337 m .55478 .82353 L .56054 .82008 L p F P
0 g
s
.018 .001 .491 r
.56316 .80653 m .5616 .79704 L .56382 .79295 L p F P
0 g
s
.018 .001 .491 r
.56216 .78367 m .56382 .79295 L .5616 .79704 L p F P
0 g
s
0 0 .332 r
.56094 .77051 m .56262 .77958 L .56216 .78367 L p F P
0 g
s
.798 .528 0 r
.56262 .77958 m .56094 .77051 L .55975 .76662 L p F P
0 g
s
0 0 .332 r
.56382 .79295 m .56216 .78367 L .56262 .77958 L p F P
0 g
s
.845 .61 .584 r
.4961 .84353 m .49725 .83363 L .50469 .8364 L p F P
0 g
s
.845 .61 .584 r
.50469 .8364 m .50384 .84638 L .4961 .84353 L p F P
0 g
s
.51 .338 .583 r
.54948 .84618 m .5486 .8362 L .55594 .83337 L p F P
0 g
s
.746 .521 .589 r
.51205 .85843 m .51258 .84834 L .52193 .84932 L p F P
0 g
s
.746 .521 .589 r
.52193 .84932 m .52177 .85944 L .51205 .85843 L p F P
0 g
s
.697 .48 .59 r
.52177 .85944 m .52193 .84932 L .53148 .84928 L p F P
0 g
s
.697 .48 .59 r
.53148 .84928 m .53168 .8594 L .52177 .85944 L p F P
0 g
s
.644 .438 .589 r
.53168 .8594 m .53148 .84928 L .5408 .84822 L p F P
0 g
s
.575 .307 .472 r
.51923 .73718 m .5196 .72899 L .51348 .73014 L p F P
0 g
s
.575 .307 .472 r
.51348 .73014 m .51276 .73839 L .51923 .73718 L p F P
0 g
s
.821 .506 .457 r
.53866 .73001 m .53936 .73826 L .54523 .74012 L p F P
0 g
s
.763 .461 .473 r
.53936 .73826 m .53866 .73001 L .5325 .72893 L p F P
0 g
s
.365 .132 .421 r
.50592 .7487 m .50695 .7403 L .50207 .74284 L p F P
0 g
s
.365 .132 .421 r
.50207 .74284 m .50078 .75136 L .50592 .7487 L p F P
0 g
s
.794 .563 .587 r
.50298 .85641 m .50384 .84638 L .51258 .84834 L p F P
0 g
s
.794 .563 .587 r
.51258 .84834 m .51205 .85843 L .50298 .85641 L p F P
0 g
s
.644 .438 .589 r
.5408 .84822 m .54136 .8583 L .53168 .8594 L p F P
0 g
s
.937 .598 .361 r
.5502 .74261 m .55147 .75112 L .5555 .75425 L p F P
0 g
s
.88 .552 .425 r
.55147 .75112 m .5502 .74261 L .54523 .74012 L p F P
0 g
s
.966 .687 .452 r
.54132 .83309 m .54073 .82325 L .52632 .81109 L p F P
0 g
s
.966 .687 .452 r
.52632 .8017 m .52632 .81109 L .54073 .82325 L p F P
0 g
s
.645 .365 .48 r
.52603 .73675 m .52605 .72858 L .5196 .72899 L p F P
0 g
s
.645 .365 .48 r
.5196 .72899 m .51923 .73718 L .52603 .73675 L p F P
0 g
s
.763 .461 .473 r
.5325 .72893 m .53285 .73712 L .53936 .73826 L p F P
0 g
s
.706 .415 .48 r
.53285 .73712 m .5325 .72893 L .52605 .72858 L p F P
0 g
s
.706 .415 .48 r
.52605 .72858 m .52603 .73675 L .53285 .73712 L p F P
0 g
s
.176 0 .354 r
.49948 .75993 m .50078 .75136 L .49686 .75453 L p F P
0 g
s
.176 0 .354 r
.49686 .75453 m .49536 .76324 L .49948 .75993 L p F P
0 g
s
.9 .665 .575 r
.48973 .8399 m .49113 .83012 L .49725 .83363 L p F P
0 g
s
.9 .665 .575 r
.49725 .83363 m .4961 .84353 L .48973 .8399 L p F P
0 g
s
.957 .73 .554 r
.48661 .82601 m .48818 .81641 L .49251 .82038 L p F P
0 g
s
.957 .73 .554 r
.49251 .82038 m .49113 .83012 L .48661 .82601 L p F P
0 g
s
.937 .598 .361 r
.55698 .76295 m .5555 .75425 L .55147 .75112 L p F P
0 g
s
.955 .619 .227 r
.5555 .75425 m .55698 .76295 L .55975 .76662 L p F P
0 g
s
.51 .338 .583 r
.55594 .83337 m .55711 .84326 L .54948 .84618 L p F P
0 g
s
.41 .267 .574 r
.55711 .84326 m .55594 .83337 L .56194 .8298 L p F P
0 g
s
.41 .267 .574 r
.56054 .82008 m .56194 .8298 L .55594 .83337 L p F P
0 g
s
.999 .797 .499 r
.48559 .81205 m .48726 .80265 L .48974 .80686 L p F P
0 g
s
.999 .797 .499 r
.48974 .80686 m .48818 .81641 L .48559 .81205 L p F P
0 g
s
.262 .164 .551 r
.56194 .8298 m .56054 .82008 L .56474 .81607 L p F P
0 g
s
.262 .164 .551 r
.56316 .80653 m .56474 .81607 L .56054 .82008 L p F P
0 g
s
.845 .61 .584 r
.49495 .85347 m .4961 .84353 L .50384 .84638 L p F P
0 g
s
.845 .61 .584 r
.50384 .84638 m .50298 .85641 L .49495 .85347 L p F P
0 g
s
0 0 .211 r
.49386 .77201 m .49536 .76324 L .49272 .76694 L p F P
0 g
s
0 0 .211 r
.49272 .76694 m .49109 .77586 L .49386 .77201 L p F P
0 g
s
.018 .001 .491 r
.56474 .81607 m .56316 .80653 L .56549 .80229 L p F P
0 g
s
.018 .001 .491 r
.56382 .79295 m .56549 .80229 L .56316 .80653 L p F P
0 g
s
.51 .338 .583 r
.55036 .8562 m .54948 .84618 L .55711 .84326 L p F P
0 g
s
.938 .808 .351 r
.4866 .79825 m .4883 .78906 L .48893 .7933 L p F P
0 g
s
.938 .808 .351 r
.48893 .7933 m .48726 .80265 L .4866 .79825 L p F P
0 g
s
.487 .234 .455 r
.51204 .74669 m .51276 .73839 L .50695 .7403 L p F P
0 g
s
.487 .234 .455 r
.50695 .7403 m .50592 .7487 L .51204 .74669 L p F P
0 g
s
0 0 0 r
.48945 .78484 m .49109 .77586 L .48998 .77992 L p F P
0 g
s
0 0 0 r
.48998 .77992 m .4883 .78906 L .48945 .78484 L p F P
0 g
s
.798 .528 0 r
.55975 .76662 m .56137 .77553 L .56262 .77958 L p F P
0 g
s
.955 .619 .227 r
.56137 .77553 m .55975 .76662 L .55698 .76295 L p F P
0 g
s
.88 .552 .425 r
.54523 .74012 m .54624 .74851 L .55147 .75112 L p F P
0 g
s
.821 .506 .457 r
.54624 .74851 m .54523 .74012 L .53936 .73826 L p F P
0 g
s
0 0 .332 r
.56549 .80229 m .56382 .79295 L .56431 .78871 L p F P
0 g
s
0 0 .332 r
.56262 .77958 m .56431 .78871 L .56382 .79295 L p F P
0 g
s
.798 .528 0 r
.56431 .78871 m .56262 .77958 L .56137 .77553 L p F P
0 g
s
.966 .687 .452 r
.54192 .84298 m .54132 .83309 L .52632 .82053 L p F P
0 g
s
.966 .687 .452 r
.52632 .81109 m .52632 .82053 L .54132 .83309 L p F P
0 g
s
.575 .307 .472 r
.51885 .74543 m .51923 .73718 L .51276 .73839 L p F P
0 g
s
.575 .307 .472 r
.51276 .73839 m .51204 .74669 L .51885 .74543 L p F P
0 g
s
.821 .506 .457 r
.53936 .73826 m .54005 .74656 L .54624 .74851 L p F P
0 g
s
.763 .461 .473 r
.54005 .74656 m .53936 .73826 L .53285 .73712 L p F P
0 g
s
.365 .132 .421 r
.50488 .75715 m .50592 .7487 L .50078 .75136 L p F P
0 g
s
.365 .132 .421 r
.50078 .75136 m .49948 .75993 L .50488 .75715 L p F P
0 g
s
.937 .598 .361 r
.55147 .75112 m .55275 .75968 L .55698 .76295 L p F P
0 g
s
.88 .552 .425 r
.55275 .75968 m .55147 .75112 L .54624 .74851 L p F P
0 g
s
.9 .665 .575 r
.48833 .84973 m .48973 .8399 L .4961 .84353 L p F P
0 g
s
.9 .665 .575 r
.4961 .84353 m .49495 .85347 L .48833 .84973 L p F P
0 g
s
.957 .73 .554 r
.48503 .83566 m .48661 .82601 L .49113 .83012 L p F P
0 g
s
.957 .73 .554 r
.49113 .83012 m .48973 .8399 L .48503 .83566 L p F P
0 g
s
.51 .338 .583 r
.55711 .84326 m .55829 .85319 L .55036 .8562 L p F P
0 g
s
.41 .267 .574 r
.55829 .85319 m .55711 .84326 L .56335 .83957 L p F P
0 g
s
.41 .267 .574 r
.56194 .8298 m .56335 .83957 L .55711 .84326 L p F P
0 g
s
.645 .365 .48 r
.52602 .74498 m .52603 .73675 L .51923 .73718 L p F P
0 g
s
.645 .365 .48 r
.51923 .73718 m .51885 .74543 L .52602 .74498 L p F P
0 g
s
.763 .461 .473 r
.53285 .73712 m .5332 .74536 L .54005 .74656 L p F P
0 g
s
.706 .415 .48 r
.5332 .74536 m .53285 .73712 L .52603 .73675 L p F P
0 g
s
.262 .164 .551 r
.56335 .83957 m .56194 .8298 L .56632 .82565 L p F P
0 g
s
.262 .164 .551 r
.56474 .81607 m .56632 .82565 L .56194 .8298 L p F P
0 g
s
.999 .797 .499 r
.48391 .8215 m .48559 .81205 L .48818 .81641 L p F P
0 g
s
.999 .797 .499 r
.48818 .81641 m .48661 .82601 L .48391 .8215 L p F P
0 g
s
.706 .415 .48 r
.52603 .73675 m .52602 .74498 L .5332 .74536 L p F P
0 g
s
.176 0 .354 r
.49817 .76855 m .49948 .75993 L .49536 .76324 L p F P
0 g
s
.176 0 .354 r
.49536 .76324 m .49386 .77201 L .49817 .76855 L p F P
0 g
s
.018 .001 .491 r
.56632 .82565 m .56474 .81607 L .56717 .81168 L p F P
0 g
s
.018 .001 .491 r
.56549 .80229 m .56717 .81168 L .56474 .81607 L p F P
0 g
s
.937 .598 .361 r
.55847 .77171 m .55698 .76295 L .55275 .75968 L p F P
0 g
s
.955 .619 .227 r
.55698 .76295 m .55847 .77171 L .56137 .77553 L p F P
0 g
s
.938 .808 .351 r
.4849 .80749 m .4866 .79825 L .48726 .80265 L p F P
0 g
s
.938 .808 .351 r
.48726 .80265 m .48559 .81205 L .4849 .80749 L p F P
0 g
s
0 0 .211 r
.49234 .78083 m .49386 .77201 L .49109 .77586 L p F P
0 g
s
0 0 .211 r
.49109 .77586 m .48945 .78484 L .49234 .78083 L p F P
0 g
s
0 0 0 r
.4878 .79386 m .48945 .78484 L .4883 .78906 L p F P
0 g
s
0 0 0 r
.4883 .78906 m .4866 .79825 L .4878 .79386 L p F P
0 g
s
0 0 .332 r
.56717 .81168 m .56549 .80229 L .566 .79788 L p F P
0 g
s
0 0 .332 r
.56431 .78871 m .566 .79788 L .56549 .80229 L p F P
0 g
s
.798 .528 0 r
.56137 .77553 m .56301 .78449 L .56431 .78871 L p F P
0 g
s
.955 .619 .227 r
.56301 .78449 m .56137 .77553 L .55847 .77171 L p F P
0 g
s
.798 .528 0 r
.566 .79788 m .56431 .78871 L .56301 .78449 L p F P
0 g
s
.487 .234 .455 r
.51131 .75505 m .51204 .74669 L .50592 .7487 L p F P
0 g
s
.487 .234 .455 r
.50592 .7487 m .50488 .75715 L .51131 .75505 L p F P
0 g
s
.88 .552 .425 r
.54624 .74851 m .54726 .75695 L .55275 .75968 L p F P
0 g
s
.821 .506 .457 r
.54726 .75695 m .54624 .74851 L .54005 .74656 L p F P
0 g
s
.966 .687 .452 r
.54251 .85292 m .54192 .84298 L .52632 .83003 L p F P
0 g
s
.966 .687 .452 r
.52632 .82053 m .52632 .83003 L .54192 .84298 L p F P
0 g
s
.41 .267 .574 r
.56335 .83957 m .56477 .84939 L .55829 .85319 L p F P
0 g
s
.957 .73 .554 r
.48345 .84536 m .48503 .83566 L .48973 .8399 L p F P
0 g
s
.957 .73 .554 r
.48973 .8399 m .48833 .84973 L .48345 .84536 L p F P
0 g
s
.575 .307 .472 r
.51847 .75373 m .51885 .74543 L .51204 .74669 L p F P
0 g
s
.575 .307 .472 r
.51204 .74669 m .51131 .75505 L .51847 .75373 L p F P
0 g
s
.365 .132 .421 r
.50383 .76566 m .50488 .75715 L .49948 .75993 L p F P
0 g
s
.365 .132 .421 r
.49948 .75993 m .49817 .76855 L .50383 .76566 L p F P
0 g
s
.262 .164 .551 r
.56477 .84939 m .56335 .83957 L .56791 .83529 L p F P
0 g
s
.262 .164 .551 r
.56632 .82565 m .56791 .83529 L .56335 .83957 L p F P
0 g
s
.821 .506 .457 r
.54005 .74656 m .54075 .75491 L .54726 .75695 L p F P
0 g
s
.763 .461 .473 r
.54075 .75491 m .54005 .74656 L .5332 .74536 L p F P
0 g
s
.937 .598 .361 r
.55275 .75968 m .55404 .76829 L .55847 .77171 L p F P
0 g
s
.88 .552 .425 r
.55404 .76829 m .55275 .75968 L .54726 .75695 L p F P
0 g
s
.999 .797 .499 r
.48222 .831 m .48391 .8215 L .48661 .82601 L p F P
0 g
s
.999 .797 .499 r
.48661 .82601 m .48503 .83566 L .48222 .831 L p F P
0 g
s
.018 .001 .491 r
.56791 .83529 m .56632 .82565 L .56886 .82112 L p F P
0 g
s
.018 .001 .491 r
.56717 .81168 m .56886 .82112 L .56632 .82565 L p F P
0 g
s
.938 .808 .351 r
.48318 .81678 m .4849 .80749 L .48559 .81205 L p F P
0 g
s
.938 .808 .351 r
.48559 .81205 m .48391 .8215 L .48318 .81678 L p F P
0 g
s
.645 .365 .48 r
.526 .75326 m .52602 .74498 L .51885 .74543 L p F P
0 g
s
.645 .365 .48 r
.51885 .74543 m .51847 .75373 L .526 .75326 L p F P
0 g
s
.176 0 .354 r
.49685 .77723 m .49817 .76855 L .49386 .77201 L p F P
0 g
s
.176 0 .354 r
.49386 .77201 m .49234 .78083 L .49685 .77723 L p F P
0 g
s
.763 .461 .473 r
.5332 .74536 m .53355 .75366 L .54075 .75491 L p F P
0 g
s
.706 .415 .48 r
.53355 .75366 m .5332 .74536 L .52602 .74498 L p F P
0 g
s
0 0 .332 r
.56886 .82112 m .56717 .81168 L .5677 .80711 L p F P
0 g
s
0 0 .332 r
.566 .79788 m .5677 .80711 L .56717 .81168 L p F P
0 g
s
.955 .619 .227 r
.55847 .77171 m .55997 .78051 L .56301 .78449 L p F P
0 g
s
.937 .598 .361 r
.55997 .78051 m .55847 .77171 L .55404 .76829 L p F P
0 g
s
0 0 0 r
.48614 .80294 m .4878 .79386 L .4866 .79825 L p F P
0 g
s
0 0 0 r
.4866 .79825 m .4849 .80749 L .48614 .80294 L p F P
0 g
s
.706 .415 .48 r
.52602 .74498 m .526 .75326 L .53355 .75366 L p F P
0 g
s
0 0 .211 r
.49082 .7897 m .49234 .78083 L .48945 .78484 L p F P
0 g
s
0 0 .211 r
.48945 .78484 m .4878 .79386 L .49082 .7897 L p F P
0 g
s
.798 .528 0 r
.5677 .80711 m .566 .79788 L .56465 .79351 L p F P
0 g
s
.798 .528 0 r
.56301 .78449 m .56465 .79351 L .566 .79788 L p F P
0 g
s
.955 .619 .227 r
.56465 .79351 m .56301 .78449 L .55997 .78051 L p F P
0 g
s
.966 .687 .452 r
.52632 .83003 m .52632 .83958 L .54251 .85292 L p F P
0 g
s
.487 .234 .455 r
.51058 .76347 m .51131 .75505 L .50488 .75715 L p F P
0 g
s
.487 .234 .455 r
.50488 .75715 m .50383 .76566 L .51058 .76347 L p F P
0 g
s
.88 .552 .425 r
.54726 .75695 m .54828 .76545 L .55404 .76829 L p F P
0 g
s
.821 .506 .457 r
.54828 .76545 m .54726 .75695 L .54075 .75491 L p F P
0 g
s
.262 .164 .551 r
.56791 .83529 m .5695 .84498 L .56477 .84939 L p F P
0 g
s
.999 .797 .499 r
.48052 .84055 m .48222 .831 L .48503 .83566 L p F P
0 g
s
.999 .797 .499 r
.48503 .83566 m .48345 .84536 L .48052 .84055 L p F P
0 g
s
.018 .001 .491 r
.5695 .84498 m .56791 .83529 L .57055 .8306 L p F P
0 g
s
.018 .001 .491 r
.56886 .82112 m .57055 .8306 L .56791 .83529 L p F P
0 g
s
.365 .132 .421 r
.50278 .77422 m .50383 .76566 L .49817 .76855 L p F P
0 g
s
.365 .132 .421 r
.49817 .76855 m .49685 .77723 L .50278 .77422 L p F P
0 g
s
.575 .307 .472 r
.51808 .76209 m .51847 .75373 L .51131 .75505 L p F P
0 g
s
.575 .307 .472 r
.51131 .75505 m .51058 .76347 L .51808 .76209 L p F P
0 g
s
.937 .598 .361 r
.55404 .76829 m .55534 .77696 L .55997 .78051 L p F P
0 g
s
.88 .552 .425 r
.55534 .77696 m .55404 .76829 L .54828 .76545 L p F P
0 g
s
.821 .506 .457 r
.54075 .75491 m .54146 .76332 L .54828 .76545 L p F P
0 g
s
.763 .461 .473 r
.54146 .76332 m .54075 .75491 L .53355 .75366 L p F P
0 g
s
.938 .808 .351 r
.48146 .82613 m .48318 .81678 L .48391 .8215 L p F P
0 g
s
.938 .808 .351 r
.48391 .8215 m .48222 .831 L .48146 .82613 L p F P
0 g
s
0 0 .332 r
.57055 .8306 m .56886 .82112 L .56942 .81639 L p F P
0 g
s
0 0 .332 r
.5677 .80711 m .56942 .81639 L .56886 .82112 L p F P
0 g
s
.176 0 .354 r
.49553 .78596 m .49685 .77723 L .49234 .78083 L p F P
0 g
s
.176 0 .354 r
.49234 .78083 m .49082 .7897 L .49553 .78596 L p F P
0 g
s
0 0 0 r
.48447 .81208 m .48614 .80294 L .4849 .80749 L p F P
0 g
s
0 0 0 r
.4849 .80749 m .48318 .81678 L .48447 .81208 L p F P
0 g
s
0 0 .211 r
.48929 .79863 m .49082 .7897 L .4878 .79386 L p F P
0 g
s
0 0 .211 r
.4878 .79386 m .48614 .80294 L .48929 .79863 L p F P
0 g
s
.937 .598 .361 r
.56148 .78937 m .55997 .78051 L .55534 .77696 L p F P
0 g
s
.955 .619 .227 r
.55997 .78051 m .56148 .78937 L .56465 .79351 L p F P
0 g
s
.798 .528 0 r
.56942 .81639 m .5677 .80711 L .5663 .80258 L p F P
0 g
s
.798 .528 0 r
.56465 .79351 m .5663 .80258 L .5677 .80711 L p F P
0 g
s
.645 .365 .48 r
.52599 .7616 m .526 .75326 L .51847 .75373 L p F P
0 g
s
.645 .365 .48 r
.51847 .75373 m .51808 .76209 L .52599 .7616 L p F P
0 g
s
.763 .461 .473 r
.53355 .75366 m .53391 .76202 L .54146 .76332 L p F P
0 g
s
.706 .415 .48 r
.53391 .76202 m .53355 .75366 L .526 .75326 L p F P
0 g
s
.955 .619 .227 r
.5663 .80258 m .56465 .79351 L .56148 .78937 L p F P
0 g
s
.706 .415 .48 r
.526 .75326 m .52599 .7616 L .53391 .76202 L p F P
0 g
s
.487 .234 .455 r
.50984 .77194 m .51058 .76347 L .50383 .76566 L p F P
0 g
s
.487 .234 .455 r
.50383 .76566 m .50278 .77422 L .50984 .77194 L p F P
0 g
s
.88 .552 .425 r
.54828 .76545 m .54931 .774 L .55534 .77696 L p F P
0 g
s
.821 .506 .457 r
.54931 .774 m .54828 .76545 L .54146 .76332 L p F P
0 g
s
.018 .001 .491 r
.57055 .8306 m .57226 .84014 L .5695 .84498 L p F P
0 g
s
.938 .808 .351 r
.47972 .83552 m .48146 .82613 L .48222 .831 L p F P
0 g
s
.938 .808 .351 r
.48222 .831 m .48052 .84055 L .47972 .83552 L p F P
0 g
s
.365 .132 .421 r
.50172 .78283 m .50278 .77422 L .49685 .77723 L p F P
0 g
s
.365 .132 .421 r
.49685 .77723 m .49553 .78596 L .50172 .78283 L p F P
0 g
s
0 0 .332 r
.57226 .84014 m .57055 .8306 L .57114 .82572 L p F P
0 g
s
0 0 .332 r
.56942 .81639 m .57114 .82572 L .57055 .8306 L p F P
0 g
s
.937 .598 .361 r
.55534 .77696 m .55664 .78568 L .56148 .78937 L p F P
0 g
s
.88 .552 .425 r
.55664 .78568 m .55534 .77696 L .54931 .774 L p F P
0 g
s
.575 .307 .472 r
.51769 .77051 m .51808 .76209 L .51058 .76347 L p F P
0 g
s
.575 .307 .472 r
.51058 .76347 m .50984 .77194 L .51769 .77051 L p F P
0 g
s
.821 .506 .457 r
.54146 .76332 m .54217 .77179 L .54931 .774 L p F P
0 g
s
.763 .461 .473 r
.54217 .77179 m .54146 .76332 L .53391 .76202 L p F P
0 g
s
0 0 0 r
.4828 .82127 m .48447 .81208 L .48318 .81678 L p F P
0 g
s
0 0 0 r
.48318 .81678 m .48146 .82613 L .4828 .82127 L p F P
0 g
s
.176 0 .354 r
.4942 .79475 m .49553 .78596 L .49082 .7897 L p F P
0 g
s
.176 0 .354 r
.49082 .7897 m .48929 .79863 L .4942 .79475 L p F P
0 g
s
.798 .528 0 r
.57114 .82572 m .56942 .81639 L .56796 .8117 L p F P
0 g
s
.798 .528 0 r
.5663 .80258 m .56796 .8117 L .56942 .81639 L p F P
0 g
s
0 0 .211 r
.48774 .80761 m .48929 .79863 L .48614 .80294 L p F P
0 g
s
0 0 .211 r
.48614 .80294 m .48447 .81208 L .48774 .80761 L p F P
0 g
s
.937 .598 .361 r
.563 .79829 m .56148 .78937 L .55664 .78568 L p F P
0 g
s
.955 .619 .227 r
.56148 .78937 m .563 .79829 L .5663 .80258 L p F P
0 g
s
.955 .619 .227 r
.56796 .8117 m .5663 .80258 L .563 .79829 L p F P
0 g
s
.645 .365 .48 r
.52597 .77 m .52599 .7616 L .51808 .76209 L p F P
0 g
s
.645 .365 .48 r
.51808 .76209 m .51769 .77051 L .52597 .77 L p F P
0 g
s
.763 .461 .473 r
.53391 .76202 m .53426 .77043 L .54217 .77179 L p F P
0 g
s
.706 .415 .48 r
.53426 .77043 m .53391 .76202 L .52599 .7616 L p F P
0 g
s
.706 .415 .48 r
.52599 .7616 m .52597 .77 L .53426 .77043 L p F P
0 g
s
.487 .234 .455 r
.50909 .78047 m .50984 .77194 L .50278 .77422 L p F P
0 g
s
.487 .234 .455 r
.50278 .77422 m .50172 .78283 L .50909 .78047 L p F P
0 g
s
.88 .552 .425 r
.54931 .774 m .55035 .78261 L .55664 .78568 L p F P
0 g
s
.821 .506 .457 r
.55035 .78261 m .54931 .774 L .54217 .77179 L p F P
0 g
s
0 0 .332 r
.57114 .82572 m .57288 .83511 L .57226 .84014 L p F P
0 g
s
.365 .132 .421 r
.50065 .79151 m .50172 .78283 L .49553 .78596 L p F P
0 g
s
.365 .132 .421 r
.49553 .78596 m .4942 .79475 L .50065 .79151 L p F P
0 g
s
0 0 0 r
.48111 .83051 m .4828 .82127 L .48146 .82613 L p F P
0 g
s
0 0 0 r
.48146 .82613 m .47972 .83552 L .48111 .83051 L p F P
0 g
s
.937 .598 .361 r
.55664 .78568 m .55796 .79446 L .563 .79829 L p F P
0 g
s
.88 .552 .425 r
.55796 .79446 m .55664 .78568 L .55035 .78261 L p F P
0 g
s
.798 .528 0 r
.57288 .83511 m .57114 .82572 L .56963 .82087 L p F P
0 g
s
.798 .528 0 r
.56796 .8117 m .56963 .82087 L .57114 .82572 L p F P
0 g
s
.575 .307 .472 r
.51731 .77898 m .51769 .77051 L .50984 .77194 L p F P
0 g
s
.575 .307 .472 r
.50984 .77194 m .50909 .78047 L .51731 .77898 L p F P
0 g
s
0 0 .211 r
.48619 .81665 m .48774 .80761 L .48447 .81208 L p F P
0 g
s
0 0 .211 r
.48447 .81208 m .4828 .82127 L .48619 .81665 L p F P
0 g
s
.176 0 .354 r
.49285 .8036 m .4942 .79475 L .48929 .79863 L p F P
0 g
s
.176 0 .354 r
.48929 .79863 m .48774 .80761 L .49285 .8036 L p F P
0 g
s
.821 .506 .457 r
.54217 .77179 m .54289 .78031 L .55035 .78261 L p F P
0 g
s
.763 .461 .473 r
.54289 .78031 m .54217 .77179 L .53426 .77043 L p F P
0 g
s
.937 .598 .361 r
.56453 .80726 m .563 .79829 L .55796 .79446 L p F P
0 g
s
.955 .619 .227 r
.563 .79829 m .56453 .80726 L .56796 .8117 L p F P
0 g
s
.955 .619 .227 r
.56963 .82087 m .56796 .8117 L .56453 .80726 L p F P
0 g
s
.645 .365 .48 r
.52596 .77845 m .52597 .77 L .51769 .77051 L p F P
0 g
s
.645 .365 .48 r
.51769 .77051 m .51731 .77898 L .52596 .77845 L p F P
0 g
s
.763 .461 .473 r
.53426 .77043 m .53462 .7789 L .54289 .78031 L p F P
0 g
s
.706 .415 .48 r
.53462 .7789 m .53426 .77043 L .52597 .77 L p F P
0 g
s
.706 .415 .48 r
.52597 .77 m .52596 .77845 L .53462 .7789 L p F P
0 g
s
.487 .234 .455 r
.50834 .78905 m .50909 .78047 L .50172 .78283 L p F P
0 g
s
.487 .234 .455 r
.50172 .78283 m .50065 .79151 L .50834 .78905 L p F P
0 g
s
.88 .552 .425 r
.55035 .78261 m .55139 .79127 L .55796 .79446 L p F P
0 g
s
.821 .506 .457 r
.55139 .79127 m .55035 .78261 L .54289 .78031 L p F P
0 g
s
.365 .132 .421 r
.49957 .80024 m .50065 .79151 L .4942 .79475 L p F P
0 g
s
.365 .132 .421 r
.4942 .79475 m .49285 .8036 L .49957 .80024 L p F P
0 g
s
.798 .528 0 r
.56963 .82087 m .57131 .8301 L .57288 .83511 L p F P
0 g
s
.937 .598 .361 r
.55796 .79446 m .55928 .8033 L .56453 .80726 L p F P
0 g
s
.88 .552 .425 r
.55928 .8033 m .55796 .79446 L .55139 .79127 L p F P
0 g
s
0 0 .211 r
.48463 .82575 m .48619 .81665 L .4828 .82127 L p F P
0 g
s
0 0 .211 r
.4828 .82127 m .48111 .83051 L .48463 .82575 L p F P
0 g
s
.176 0 .354 r
.4915 .8125 m .49285 .8036 L .48774 .80761 L p F P
0 g
s
.176 0 .354 r
.48774 .80761 m .48619 .81665 L .4915 .8125 L p F P
0 g
s
.955 .619 .227 r
.57131 .8301 m .56963 .82087 L .56607 .81629 L p F P
0 g
s
.955 .619 .227 r
.56453 .80726 m .56607 .81629 L .56963 .82087 L p F P
0 g
s
.575 .307 .472 r
.51691 .78751 m .51731 .77898 L .50909 .78047 L p F P
0 g
s
.575 .307 .472 r
.50909 .78047 m .50834 .78905 L .51691 .78751 L p F P
0 g
s
.937 .598 .361 r
.56607 .81629 m .56453 .80726 L .55928 .8033 L p F P
0 g
s
.821 .506 .457 r
.54289 .78031 m .54361 .78889 L .55139 .79127 L p F P
0 g
s
.763 .461 .473 r
.54361 .78889 m .54289 .78031 L .53462 .7789 L p F P
0 g
s
.645 .365 .48 r
.52594 .78696 m .52596 .77845 L .51731 .77898 L p F P
0 g
s
.645 .365 .48 r
.51731 .77898 m .51691 .78751 L .52594 .78696 L p F P
0 g
s
.763 .461 .473 r
.53462 .7789 m .53499 .78743 L .54361 .78889 L p F P
0 g
s
.706 .415 .48 r
.53499 .78743 m .53462 .7789 L .52596 .77845 L p F P
0 g
s
.706 .415 .48 r
.52596 .77845 m .52594 .78696 L .53499 .78743 L p F P
0 g
s
.487 .234 .455 r
.50759 .7977 m .50834 .78905 L .50065 .79151 L p F P
0 g
s
.487 .234 .455 r
.50065 .79151 m .49957 .80024 L .50759 .7977 L p F P
0 g
s
.88 .552 .425 r
.55139 .79127 m .55244 .8 L .55928 .8033 L p F P
0 g
s
.821 .506 .457 r
.55244 .8 m .55139 .79127 L .54361 .78889 L p F P
0 g
s
.365 .132 .421 r
.49849 .80903 m .49957 .80024 L .49285 .8036 L p F P
0 g
s
.365 .132 .421 r
.49285 .8036 m .4915 .8125 L .49849 .80903 L p F P
0 g
s
.937 .598 .361 r
.55928 .8033 m .56061 .81219 L .56607 .81629 L p F P
0 g
s
.88 .552 .425 r
.56061 .81219 m .55928 .8033 L .55244 .8 L p F P
0 g
s
.176 0 .354 r
.49014 .82146 m .4915 .8125 L .48619 .81665 L p F P
0 g
s
.176 0 .354 r
.48619 .81665 m .48463 .82575 L .49014 .82146 L p F P
0 g
s
.955 .619 .227 r
.56607 .81629 m .56762 .82537 L .57131 .8301 L p F P
0 g
s
.937 .598 .361 r
.56762 .82537 m .56607 .81629 L .56061 .81219 L p F P
0 g
s
.575 .307 .472 r
.51652 .7961 m .51691 .78751 L .50834 .78905 L p F P
0 g
s
.575 .307 .472 r
.50834 .78905 m .50759 .7977 L .51652 .7961 L p F P
0 g
s
.821 .506 .457 r
.54361 .78889 m .54433 .79753 L .55244 .8 L p F P
0 g
s
.763 .461 .473 r
.54433 .79753 m .54361 .78889 L .53499 .78743 L p F P
0 g
s
.645 .365 .48 r
.52592 .79553 m .52594 .78696 L .51691 .78751 L p F P
0 g
s
.645 .365 .48 r
.51691 .78751 m .51652 .7961 L .52592 .79553 L p F P
0 g
s
.763 .461 .473 r
.53499 .78743 m .53535 .79601 L .54433 .79753 L p F P
0 g
s
.706 .415 .48 r
.53535 .79601 m .53499 .78743 L .52594 .78696 L p F P
0 g
s
.706 .415 .48 r
.52594 .78696 m .52592 .79553 L .53535 .79601 L p F P
0 g
s
.487 .234 .455 r
.50683 .8064 m .50759 .7977 L .49957 .80024 L p F P
0 g
s
.487 .234 .455 r
.49957 .80024 m .49849 .80903 L .50683 .8064 L p F P
0 g
s
.88 .552 .425 r
.55244 .8 m .5535 .80878 L .56061 .81219 L p F P
0 g
s
.821 .506 .457 r
.5535 .80878 m .55244 .8 L .54433 .79753 L p F P
0 g
s
.365 .132 .421 r
.4974 .81787 m .49849 .80903 L .4915 .8125 L p F P
0 g
s
.365 .132 .421 r
.4915 .8125 m .49014 .82146 L .4974 .81787 L p F P
0 g
s
.937 .598 .361 r
.56061 .81219 m .56195 .82114 L .56762 .82537 L p F P
0 g
s
.88 .552 .425 r
.56195 .82114 m .56061 .81219 L .5535 .80878 L p F P
0 g
s
.575 .307 .472 r
.51612 .80474 m .51652 .7961 L .50759 .7977 L p F P
0 g
s
.575 .307 .472 r
.50759 .7977 m .50683 .8064 L .51612 .80474 L p F P
0 g
s
.821 .506 .457 r
.54433 .79753 m .54506 .80622 L .5535 .80878 L p F P
0 g
s
.763 .461 .473 r
.54506 .80622 m .54433 .79753 L .53535 .79601 L p F P
0 g
s
.645 .365 .48 r
.52591 .80415 m .52592 .79553 L .51652 .7961 L p F P
0 g
s
.645 .365 .48 r
.51652 .7961 m .51612 .80474 L .52591 .80415 L p F P
0 g
s
.763 .461 .473 r
.53535 .79601 m .53572 .80465 L .54506 .80622 L p F P
0 g
s
.706 .415 .48 r
.53572 .80465 m .53535 .79601 L .52592 .79553 L p F P
0 g
s
.706 .415 .48 r
.52592 .79553 m .52591 .80415 L .53572 .80465 L p F P
0 g
s
.01 w
.52632 .80417 m
.52632 .87974 L
s
.5 Mabswid
.487 .234 .455 r
.50607 .81516 m .50683 .8064 L .49849 .80903 L p F P
0 g
s
.487 .234 .455 r
.49849 .80903 m .4974 .81787 L .50607 .81516 L p F P
0 g
s
.88 .552 .425 r
.5535 .80878 m .55456 .81762 L .56195 .82114 L p F P
0 g
s
.821 .506 .457 r
.55456 .81762 m .5535 .80878 L .54506 .80622 L p F P
0 g
s
.575 .307 .472 r
.51572 .81345 m .51612 .80474 L .50683 .8064 L p F P
0 g
s
.575 .307 .472 r
.50683 .8064 m .50607 .81516 L .51572 .81345 L p F P
0 g
s
.821 .506 .457 r
.54506 .80622 m .5458 .81498 L .55456 .81762 L p F P
0 g
s
.763 .461 .473 r
.5458 .81498 m .54506 .80622 L .53572 .80465 L p F P
0 g
s
.645 .365 .48 r
.52589 .81284 m .52591 .80415 L .51612 .80474 L p F P
0 g
s
.645 .365 .48 r
.51612 .80474 m .51572 .81345 L .52589 .81284 L p F P
0 g
s
.763 .461 .473 r
.53572 .80465 m .53609 .81336 L .5458 .81498 L p F P
0 g
s
.706 .415 .48 r
.53609 .81336 m .53572 .80465 L .52591 .80415 L p F P
0 g
s
.706 .415 .48 r
.52591 .80415 m .52589 .81284 L .53609 .81336 L p F P
0 g
s
gsave
.83926 .48285 -59.75 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.67104 .74096 -61 -16.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.52632 .87974 -66 -2.39062 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{527.25, 404.375},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000<F0002GR000`400?l00000o`00003oo`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI
0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0oooo
o`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?oo
ool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo
003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oo
oaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3o
oooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0
ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3o
ool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0
oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo
0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00
o`3ooooo0?ooool0oooo6@3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool5
00000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0
ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3o
ool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0
ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03o
ool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool50000
0?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0oooo
N`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool0
0?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0oooo
V03oool500000?l0ooooN`3oool00?l0ooooV03oool500000?l0ooooN`3oool00?l0ooooV03oool5
00000?l0ooooN`3oool00?l0ooooV03oool600000?l0ooooNP3oool00?l0ooooV03oool500000003
0?N_L`000000oooo0?l0ooooN03oool00?l0ooooV03oool5000000030?N_L`000000oooo0?l0oooo
N03oool00?l0ooooV03oool500000080mjmc00<000000?ooo`3oool0o`3ooomf0?ooo`00o`3ooonH
0?ooo`H000000P3g[g<00`000000oooo0?ooo`3o0?ooogD0oooo003o0?oooiP0oooo1@0000001@3g
[g<000000?N_L`3g[g<000000?l0ooooMP3oool00?l0ooooV03oool500000080mjmc00<000000?N_
L`000000o`3ooomf0?ooo`00o`3ooolf0?ooo`030000003oool0oooo05l0oooo1@0000030?N_L`03
0000003g[g<000000?l0ooooM@3oool00?l0oooo=@3oool300000600oooo1P0000020?N_L`040000
003g[g<0000000000?l0ooooM03oool00?l0oooo=03oool5000005l0oooo1P0000030?N_L`<00000
o`3ooomd0?ooo`00o`3ooolc0?ooo`L00000GP3oool5000000030?N_L`000000mjmc0080mjmc00<0
00000?N_L`000000o`3ooomc0?ooo`00o`3ooold0?ooo`L00000G@3oool500000080mjmc00<00000
0?N_L`3g[g<00P0000000`3g[g<000000?ooo`3o0?ooog40oooo003o0?ooocD0oooo1`00001L0?oo
o`H000000P3g[g<2000000040?N_L`000000mjmc00000?l0ooooLP3oool00?l0oooo=P3oool70000
05/0oooo1@0000000`3g[g<000000?N_L`0200000080mjmc00<000000?N_L`000000o`3oooma0?oo
o`00o`3ooolg0?ooo`H00000F`3oool500000080mjmc00<000000?N_L`0000000`3g[g<200000?l0
ooooL@3oool00?l0oooo>03oool6000005X0oooo1@0000020?N_L`040000003g[g<0000000000080
mjmc00<000000?N_L`000000o`3ooom`0?ooo`00o`3oooli0?ooo`H00000F@3oool600000080mjmc
0`0000030?N_L`030000003g[g<000000?l0ooooK`3oool00?l0oooo>@3oool7000005P0oooo1@00
00001`3g[g<000000?N_L`3g[g<000000?N_L`0000000P3g[g<00`000000mjmc0000003o0?ooofl0
oooo003o0?ooocX0oooo1`00001G0?ooo`D000000P3g[g<01P000000mjmc000000000000mjmc0000
0080mjmc00<000000?N_L`000000o`3ooom^0?ooo`00o`3ooolk0?ooo`L00000EP3oool500000080
mjmc00H000000?N_L`00000000000?N_L`0000030?N_L`<00000o`3ooom]0?ooo`00o`3oooll0?oo
o`L00000E@3oool600000080mjmc0P000000103g[g<000000?N_L`0000020?N_L`<00000o`3ooom]
0?ooo`00o`3ooolm0?ooo`L00000E03oool5000000050?N_L`000000mjmc0?N_L`0000000P3g[g<0
0`000000mjmc000000020?N_L`030000003g[g<000000?l0ooooK03oool00?l0oooo?P3oool70000
05<0oooo1@0000020?N_L`060000003g[g<000000000003g[g<000000P3g[g<01P000000mjmc0000
00000000mjmc00000?l0ooooJ`3oool00?l0oooo?`3oool700000580oooo1@0000020?N_L`040000
003g[g<0000000000080mjmc00P000000?N_L`00000000000?N_L`000000mjmc00000?l0ooooJ`3o
ool00?l0oooo@03oool700000540oooo1P0000020?N_L`80000000@0mjmc0000003g[g<000000P3g
[g<01P000000mjmc0?N_L`000000mjmc00000?l0ooooJP3oool00?l0oooo@@3oool700000500oooo
1@0000001`3g[g<000000?N_L`3g[g<000000?N_L`0000000P3g[g<01P000000mjmc000000000000
mjmc00000080mjmc00<000000?ooo`3oool0o`3ooomW0?ooo`00o`3ooom20?ooo`H00000D03oool5
000000040?N_L`000000mjmc0?N_L`80000000@0mjmc0000003g[g<0mjmc0`0000020?N_L`030000
003g[g<000000?l0ooooJ@3oool00?l0oooo@`3oool6000004l0oooo1@0000020?N_L`80000000H0
mjmc0000003g[g<0mjmc0000003g[g<2000000040?N_L`000000mjmc00000080mjmc00<000000?oo
o`3oool0o`3ooomV0?ooo`00o`3ooom40?ooo`H00000CP3oool600000080mjmc00H000000?N_L`3g
[g<000000?N_L`0000020?N_L`030000003g[g<000000080mjmc00@000000?N_L`3g[g<00000o`3o
oomW0?ooo`00o`3ooom40?ooo`L00000C@3oool5000000030?N_L`000000mjmc008000000P3g[g<0
10000000mjmc0000003g[g<2000000070?N_L`000000mjmc0?N_L`000000mjmc0000003o0?ooofL0
oooo003o0?ooodD0oooo1`00001<0?ooo`D0000000T0mjmc0000003g[g<000000?N_L`000000mjmc
0000003g[g<00P000000103g[g<000000?N_L`0000020?N_L`040000003g[g<0mjmc00000?l0oooo
IP3oool00?l0ooooAP3oool7000004/0oooo1@0000020?N_L`80000000L0mjmc0000003g[g<0mjmc
0000003g[g<000000080mjmc00<000000?N_L`0000000P3g[g<010000000mjmc00000000003o0?oo
ofD0oooo003o0?ooodL0oooo1`00001:0?ooo`H000000P3g[g<010000000mjmc0?N_L`0000020?N_
L`<000000P3g[g<010000000mjmc0000003g[g<2000000030?N_L`000000oooo0?l0ooooI03oool0
0?l0ooooB03oool7000004T0oooo1@0000000`3g[g<000000?N_L`0200000080mjmc00<000000?N_
L`0000000P0000020?N_L`030000003g[g<000000080mjmc00@000000?N_L`3g[g<00000o`3ooomT
0?ooo`00o`3ooom90?ooo`L00000B03oool5000000030?N_L`000000mjmc008000000`3g[g<01@00
0000mjmc0000003g[g<000000080mjmc00@000000?N_L`000000mjmc0P0000000`3g[g<000000?oo
o`3o0?ooof<0oooo003o0?ooodX0oooo1`0000170?ooo`D000000P3g[g<2000000060?N_L`000000
mjmc0?N_L`000000mjmc0P0000001@3g[g<000000?N_L`000000mjmc0080000000D0mjmc0000003g
[g<0mjmc0000003o0?ooof<0oooo003o0?oood/0oooo1`0000160?ooo`H000000P3g[g<010000000
mjmc0?N_L`0000020?N_L`<0000000L0mjmc0000003g[g<0mjmc0000003g[g<000000080mjmc00<0
00000?N_L`000000o`3ooomS0?ooo`00o`3ooom<0?ooo`L00000A@3oool600000080mjmc0P000000
0`3g[g<000000?N_L`020?N_L`050000003g[g<000000?N_L`0000000P3g[g<3000000050?N_L`00
0000mjmc0?N_L`000000o`3ooomR0?ooo`00o`3ooom=0?ooo`L00000A03oool5000000030?N_L`00
0000mjmc008000000P3g[g<01P000000mjmc0?N_L`000000mjmc00000080mjmc00<000000?N_L`00
00000P0000020?N_L`030000003g[g<000000?l0ooooHP3oool00?l0ooooCP3oool7000004<0oooo
1@0000020?N_L`80000000@0mjmc0000003g[g<0mjmc0P000000103g[g<000000?N_L`0000020?N_
L`070000003g[g<000000?N_L`000000mjmc000000020?N_L`030000003oool0oooo0?l0ooooG`3o
ool00?l0ooooC`3oool700000480oooo1@0000030?N_L`030000003g[g<000000080mjmc0P000004
0?N_L`050000003g[g<000000000003g[g<00P0000020?N_L`030000003g[g<000000?l0ooooH@3o
ool00?l0ooooD03oool700000440oooo1P0000020?N_L`80000000D0mjmc0000003g[g<0mjmc0000
00020?N_L`030000003g[g<000000080mjmc00L000000?N_L`000000mjmc0000003g[g<000000080
mjmc00<000000?ooo`3oool0o`3ooomN0?ooo`00o`3ooomA0?ooo`L00000@03oool5000000050?N_
L`00000000000?N_L`0000000P3g[g<01P000000mjmc000000000000mjmc00000080mjmc00<00000
0?N_L`0000000P3g[g<200000080mjmc00<000000?N_L`000000o`3ooomP0?ooo`00o`3ooomB0?oo
o`H00000@03oool500000080mjmc00D000000?N_L`3g[g<000000?N_L`02000000060?N_L`000000
mjmc0?N_L`000000mjmc0P000000203g[g<000000?N_L`000000mjmc0000003g[g<000000P3g[g<0
0`000000oooo0?ooo`3o0?oooed0oooo003o0?oooe<0oooo1P00000o0?ooo`D000000P3g[g<20000
0080mjmc00<000000?N_L`0000000P3g[g<00`000000mjmc000000020?N_L`030000003g[g<0mjmc
0080mjmc00L000000?N_L`000000mjmc0000003g[g<000000?l0ooooG`3oool00?l0ooooE03oool6
000003h0oooo1P0000000`3g[g<00000000000030?N_L`<000000P3g[g<010000000mjmc0000003g
[g<2000000070?N_L`000000mjmc0000003g[g<000000?N_L`02000000030?N_L`000000oooo0?l0
ooooG@3oool00?l0ooooE03oool7000003d0oooo1@0000001@3g[g<000000000003g[g<000000080
mjmc0`0000020?N_L`080000003g[g<000000000003g[g<000000?N_L`0000020?N_L`070000003g
[g<000000?N_L`000000mjmc0000003o0?oooeh0oooo003o0?oooeD0oooo1`00000l0?ooo`D00000
0P3g[g<00`000000mjmc000000030?N_L`030000003g[g<000000080mjmc00<000000?N_L`000000
0P3g[g<01P000000mjmc0000003g[g<000000?N_L`8000000`3g[g<00`000000oooo0?ooo`3o0?oo
oe/0oooo003o0?oooeH0oooo1`00000k0?ooo`D000000P3g[g<2000000040?N_L`000000mjmc0?N_
L`80000000@0mjmc0000003g[g<0mjmc0`000000103g[g<000000?N_L`0000020?N_L`070000003g
[g<000000?N_L`000000mjmc0000003o0?oooed0oooo003o0?oooeL0oooo1`00000j0?ooo`H00000
00<0mjmc0000000000000P3g[g<2000000040?N_L`000000mjmc00000080mjmc0`0000020?N_L`04
0000003g[g<000000?N_L`8000000P3g[g<010000000mjmc0?N_L`00003o0?oooe`0oooo003o0?oo
oeP0oooo1`00000i0?ooo`D0000000H0mjmc000000000000mjmc0000003g[g<200000080mjmc00<0
00000?N_L`0000000P3g[g<01`000000mjmc0000003g[g<000000?N_L`0000000P3g[g<01`000000
mjmc0000003g[g<000000?N_L`000000o`3ooomL0?ooo`00o`3ooomI0?ooo`L00000>03oool50000
0080mjmc00H000000?N_L`3g[g<000000?N_L`0000020?N_L`080000003g[g<0mjmc0000003g[g<0
00000?N_L`0000020?N_L`0;0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`00
0000TP3oool01P3Z^W80000000000000Vm@0oooo0=BK0080000000<0L[[Z0?ooo`3oool0_P3oool0
0?l0ooooFP3oool7000003L0oooo1@0000020?N_L`8000000P3g[g<300000080mjmc00/000000?N_
L`00000000000?N_L`000000mjmc0000003g[g<000000?N_L`02000000080?N_L`000000mjmc0000
003g[g<000000?N_L`00002B0?ooo`070?oDV`000000VmCo0?ooo`3oe9/0000009_Do`310?ooo`00
o`3ooomK0?ooo`L00000=P3oool6000000030?N_L`00000000000080mjmc0`0000020?N_L`080000
003g[g<0mjmc0000003g[g<000000?N_L`0000020?N_L`0;0000003g[g<000000?N_L`000000mjmc
0000003g[g<000000?N_L`000000T`3oool01@3oom@0V`1b07:KLP1b09/0e?oo0<80oooo003o0?oo
oe`0oooo1`00000e0?ooo`D0000000D0mjmc000000000000mjmc000000020?N_L`030000003g[g<0
00000080mjmc00<000000?N_L`0000000P3g[g<010000000mjmc0000003g[g<2000000<0mjmc00L0
00000?N_L`000000mjmc0000003g[g<0000009<0oooo00<0^W80079bLP00L[X0``3oool00?l0oooo
G@3oool7000003@0oooo1@0000020?N_L`030000003g[g<000000080mjmc0`0000020?N_L`800000
00H0mjmc0000003g[g<000000?N_L`0000020?N_L`0;0000003g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`000000T@3oool01`3oom@0V`0007:jjP3oool0j[Yb0000V`3Dool0`@3oool0
0?l0ooooGP3oool6000003@0oooo1@0000020?N_L`80000000L0mjmc000000000000mjmc0000003g
[g<000000080mjmc00<000000?N_L`0000000P3g[g<01@000000mjmc0000003g[g<0000000@0mjmc
00L000000?N_L`000000mjmc0000003g[g<0000008l0oooo00T0onZj07800000000009_D0?ooo`3D
V`0000000000LP2jj_l0`03oool00?l0ooooG`3oool6000003<0oooo1`0000000`3g[g<000000?N_
L`0200000080mjmc00@000000?N_L`000000mjmc0P0000001@3g[g<000000?N_L`000000mjmc0080
000000`0mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`00003o0?oooeT0
oooo003o0?ooof00oooo1P00000b0?ooo`L000000P3g[g<00`000000mjmc000000020?N_L`080000
003g[g<000000000003g[g<000000?N_L`0000020?N_L`070000003g[g<000000?N_L`000000mjmc
000000020?N_L`060000003g[g<000000?N_L`000000mjmco`3ooomI0?ooo`00o`3ooomP0?ooo`L0
0000<@3oool5000000030?N_L`000000mjmc0080mjmc0`0000020?N_L`030000003g[g<000000080
mjmc00@000000?N_L`000000mjmc0P0000030?N_L`0;0000003g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`000000o`3ooomH0?ooo`00o`3ooomQ0?ooo`L00000<03oool5000000030?N_
L`00000000000080mjmc0`0000030?N_L`<0000000@0mjmc0000003g[g<000000P3g[g<01`000000
mjmc0000003g[g<000000?N_L`0000000P3g[g<00`000000mjmc000000020?N_L`030000003oool0
oooo08P0oooo00<000000?ooo`3oool0bP3oool00?l0ooooHP3oool7000002l0oooo1@0000000`3g
[g<00000000000030?N_L`030000003g[g<000000080mjmc0`0000020?N_L`070000003g[g<00000
0?N_L`000000mjmc000000020?N_L`0;0000003g[g<000000?N_L`000000mjmc0000003g[g<00000
0?N_L`000000Q`3oool400000</0oooo003o0?ooof<0oooo1`00000^0?ooo`L0000000@0mjmc0000
003g[g<0mjmc0P0000002P3g[g<000000?N_L`3g[g<000000?N_L`000000mjmc0000003g[g<20000
00080?N_L`000000mjmc0000003g[g<000000?N_L`0000020?N_L`060000003g[g<0mjmc0000003g
[g<00000Q03oool700000</0oooo003o0?ooof@0oooo1`00000]0?ooo`D0000000@0mjmc0000003g
[g<0mjmc0P0000002@3g[g<000000?N_L`3g[g<000000?N_L`000000mjmc000000020?N_L`070000
003g[g<000000?N_L`000000mjmc000000020?N_L`0;0000003g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`000000P03oool:00000</0oooo003o0?ooofD0oooo1`00000/0?ooo`D00000
00@0mjmc000000000000mjmc0P0000020?N_L`090000003g[g<000000000003g[g<000000?N_L`00
0000mjmc008000000`3g[g<01P000000mjmc0000003g[g<000000?N_L`8000000P3g[g<01@000000
mjmc0000003g[g<0000007d0oooo3@00003;0?ooo`00o`3ooomV0?ooo`L00000:`3oool700000004
0?N_L`000000mjmc00000080mjmc00P000000?N_L`3g[g<000000?N_L`000000mjmc00000080mjmc
00L000000?N_L`000000mjmc0000003g[g<000000080mjmc00P000000?N_L`000000mjmc0000003g
[g<000000?N_L`800000NP3oool?00000<`0oooo003o0?ooofL0oooo1`00000Z0?ooo`D0000000D0
mjmc0000003g[g<000000?N_L`0200000080mjmc00<000000?N_L`0000000P3g[g<01`000000mjmc
0000003g[g<000000?N_L`0000000P3g[g<010000000mjmc0000003g[g<200000080mjmc00L00000
0?N_L`000000mjmc0000003g[g<0000007H0oooo4000003>0?ooo`00o`3ooomX0?ooo`H00000:P3o
ool5000000040?N_L`000000mjmc0?N_L`<000000P3g[g<2000000050?N_L`000000mjmc0000003g
[g<00P000000203g[g<000000?N_L`000000mjmc0000003g[g<000000P3g[g<01P000000mjmc0000
003g[g<000000?N_L`80000000<0mjmc0000003oool0LP3oool@00000=40oooo003o0?ooofP0oooo
1`00000Y0?ooo`H0000000L0mjmc0000003g[g<0mjmc0000003g[g<000000080mjmc00<000000?N_
L`0000000P3g[g<01`000000mjmc0000003g[g<000000?N_L`0000000P3g[g<010000000mjmc0000
000000020?N_L`090000003g[g<000000?N_L`000000mjmc0000003g[g<0000006l0oooo4000003D
0?ooo`00o`3ooomX0?ooo`P00000:03oool6000000040?N_L`000000mjmc0?N_L`80000000<0mjmc
0000003g[g<00P0000000`3g[g<000000?N_L`020000000:0?N_L`000000mjmc0000003g[g<00000
0?N_L`000000mjmc00000080mjmc00@000000?N_L`00000000000P3g[g<2000000030?N_L`000000
oooo06`0oooo3`00003G0?ooo`00o`3ooomX0?ooo`T000009`3oool600000080mjmc0P0000000`3g
[g<000000?N_L`02000000040?N_L`000000mjmc00000080mjmc00L000000?N_L`000000mjmc0000
003g[g<000000080mjmc00l000000?N_L`3g[g<0mjmc0000003g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`000000J@3oool?00000=X0oooo003o0?ooofX0oooo2000000V0?ooo`L00000
00<0mjmc0000000000000P3g[g<00`000000mjmc000000020?N_L`050000003g[g<000000?N_L`00
00000P3g[g<02@000000mjmc0000003g[g<000000?N_L`000000mjmc000000020?N_L`80000000@0
mjmc0000003g[g<0mjmc0P0000000`3g[g<000000?ooo`1T0?oooa400000g03oool00?l0ooooK03o
ool7000002D0oooo1P000000103g[g<000000?N_L`0000030?N_L`<0000000<0mjmc0000003g[g<0
0P0000001`3g[g<000000?N_L`000000mjmc0000003g[g<00P0000020?N_L`050000003g[g<0mjmc
0000003g[g<00P0000020?N_L`040000003g[g<000000?N_Lf40oooo4@00003P0?ooo`00o`3ooom]
0?ooo`L00000703ooolD000000040?N_L`000000000000000080mjmc00D000000?N_L`000000mjmc
000000020?N_L`0?0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc
0000003g[g<000000080mjmc0P0000000`3g[g<000000?ooo`1K0?oooa800000h`3oool00?l0oooo
KP3oool7000001L0oooo2P00000406T00004000000220000PP00088000/0000000<0mjmc00000000
00000`3g[g<010000000mjmc0000003g[g<200000080mjmc00<000000?N_L`0000000P3g[g<01000
0000mjmc0000000000020?N_L`040000003g[g<0mjmc000005T0oooo4`00003U0?ooo`00o`3ooom_
0?ooo`L00000503oool50000000304D0000000000000018000000P2B1P06000000040?N_L`000000
mjmc00000080mjmc00h000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g
[g<000000?N_L`8000000P3g[g<00`000000mjmc0000001F0?oooa800000j03oool00?l0ooooL03o
ool600000180oooo0`00000010150000000000000000000206<05@03000000223al0PPlO0080PPlO
2@00000309PR7`030000002Z;QH0000000<0000000<0TPH00000002I1`000`0000020?N_L`040000
003g[g<0000000000080mjmc00D000000?N_L`000000mjmc000000020?N_L`040000003g[g<00000
00000080mjmc0P0000000`3g[g<000000?ooo`1B0?oooa800000j`3oool00?l0ooooL@3oool60000
00l0oooo1P00000306<05@L00000102A;4400`000000YCe20:Dm@P020:Dm@PH000000`2Z;QH40000
000309T7000000000000008000000P3g[g<03@000000mjmc0000003g[g<000000?N_L`000000mjmc
0000003g[g<000000?N_L`0000000`3g[g<010000000mjmc00000000001@0?oooa000000l03oool0
0?l0ooooL@3oool7000000`0oooo1@00000206<05@@0000000<0MaDk0000002A;440202A;4400`00
0000YCe20:Dm@P060:Dm@P030000002gBS/0000000<0000000<0ZRhF0000002f<`801`0000020?N_
L`070000003g[g<000000?N_L`000000mjmc000000020?N_L`040000003g[g<0mjmc000000<0mjmc
00<000000?N_L`000000C03oool@00000?<0oooo003o0?ooog80oooo1`0000090?ooo`@0000000<0
>0000000000000000P00000307LE>aP000000`2gBS/4000000<0]S<20`0000003@3g[g<000000?N_
L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00P0000020?N_L`040000003g
[g<00000000004T0oooo4000003f0?ooo`00o`3ooomc0?ooo`L000001P3oool40000000403P00000
0000000000000080MaDk1000000208@^EP030000002J@UX0VT9J00L0VT9J00<000000:eAF`2]DE/0
1P2]DE/00`000000_UeG0;iME`04000000030;M:>`000000aU8]00@0000000/0]S<2000000000000
00000?N_L`000000mjmc0000003g[g<000000?N_L`0200000080mjmc00T000000?N_L`000000mjmc
0000003g[g<000000?N_L`000000A03ooolA00000?T0oooo003o0?ooog<0oooo200000040?ooo`<0
000000@0>000000000000000DP0[1000000608@^EP030000002J@UX0VT9J00L0VT9J00<000000:eA
F`2]DE/01`2]DE/00`000000_UeG0;iME`030;iME`@000000`36DRd600000080mjmc00<000000?N_
L`0000000`3g[g<02P000000mjmc000000000000mjmc0000003g[g<000000?N_L`0000110?oooa80
0000n`3oool00?l0ooooM@3oool600000080oooo1P0000001@1B02/000000000001U4T`0000000H0
Q2iF6@0000050;iME`030000003>J4d00000008000000`36DRd40000000?0?N_L`000000mjmc0000
003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc00800000?P3ooolB0000
0?h0oooo003o0?ooogH0oooo3P00000206DBC00300000024;UH0Q2iF00D000000P2<@6X00`000000
XE5]0:5AK@070:5AK@030000002bGfd0/Um]00L0/Um]00<000000<9/J`32K6/0100000020;iME`04
0000003>J4d0cVQ=0<iXC@@0000000H0ceDA00000000000000000?N_L`0000020?N_L`030000003g
[g<0mjmc0080000000P0mjmc0000003g[g<000000?N_L`000000mjmc000003T0oooo4P00003o0?oo
o`<0oooo003o0?ooogH0oooo200000000`0K00h000000000000406DBC0@000001`2<@6X00`000000
XE5]0:5AK@070:5AK@030000002bGfd0/Um]00L0/Um]00<000000<9/J`32K6/01032K6/4000000D0
cVQ=0P0000020<mE4@8000000P3g[g<030000000mjmc0000003g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`800000=P3ooolB00000?l0oooo1P3oool00?l0ooooMP3oool:000000<0IA9<
0P0000000`1b:F<0000008a0JP0808a0JP030000002QDFd0XE5]00<0XE5]2@0000050;9OK@030000
0032K6/0`Va[00H0`Va[00<000000=5hI00000000P0000030<iXC@<000000P3?EA430000000>0?N_
L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`00000b0?oooa40
0000o`3oool:0?ooo`00o`3ooomh0?ooo`/000000`1b:F<00`000000S41Z08a0JP0508a0JPP00000
102UGW`00`000000]F]l0;E[O0020;E[O0X000001@32K6/010000000dGQT0=5hI03AN6@300000005
0<iXC@000000fg0i0000003?EA400`000000103g[g<000000?N_L`3g[g<200000080mjmc0P000002
0?N_L`800000<03oool@00000?l0oooo3@3oool00?l0ooooN03oool8000000H0LRUS00<0000008a0
JP2<@6X01@000002099?NP030000002UGW`0YEil00L0YEil00<000000;E[O02eJg`01`2eJg`00`00
0000a7Mj0<AgNP020<AgNPH000001P3AN6@200000080fg0i1@0000003@3g[g<000000?N_L`000000
mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<0;03ooolA00000?l0oooo403oool00?l0
ooooM`3oool200000080=`0g1P000004078YH`@000001P2BCgX00`000000YEil0:ENO0080:ENO003
0000002eJg`0]F]l00L0]F]l00<000000<AgNP34MgX01`34MgX3000000D0dGQT0`0000020=]`>@05
00000037B`0000000?N_L`0000000P3g[g<200000080mjmc0`0000020?N_L`030000003oool0oooo
02D0oooo4P00003o0?oooa<0oooo003o0?ooogH0oooo0`00000203L0=`X0000000<0Ncaf0000002B
CgX01@2BCgXJ000000L0a7Mj00<000000=>3MP3CPgH00P0000030=5hI0030000003QPUL0hH9G0080
000000`0fg0i00000037B`0000000?N_L`000000mjmc0000003g[g<000000?N_L`0000030?N_L`80
0000903ooolA00000?l0oooo5`3oool00?l0ooooM@3oool300000080=`0g00<0000004`9EP000000
1P00000307/lMP030000002BCgX0TTmj00@000000P2GFhL00`000000Z6R80:QXR0080:QXR0030000
002gM8P0]gB800L0]gB800<000000<F0Q`35P8L01@0000020<AgNP030000003CPgH0dh=f0080dh=f
0P0000000`3AN6@000000>62E`030>62E`<0000000<0ad/00000000000000P3g[g<300000080mjmc
00@000000?N_L`000000mjmc8P3oool@00000?l0oooo6P3oool00?l0ooooM03oool2000000040000
400000000000000000<0C0UF1`0000000`1k?7H0000000000002000000H0Ue^700<000000:QXR02X
J8P0202XJ8P00`000000]gB80;MdR0070;MdR00300000035P8L0aH2700D0aH27100000050=>3MP80
00001P3QPUL5000000030?N_L`000000mjmc0080mjmc0P000000103g[g<000000?N_L`00000M0?oo
oa800000o`3ooolL0?ooo`00o`3ooomd0?ooo`04000000000100000@000000<0C0UF3000000809MK
Q`030000002XJ8P0Z6R800P0Z6R800<000000;MdR02gM8P01`2gM8P00`000000aH270<F0Q`070<F0
Q`030000003CS8@00000008000000`3CPgH3000000@0hH9G0P000000103PL1@00000000000000002
0?N_L`040000003g[g<0000000000080mjmc0P00000J0?oooa800000o`3ooolO0?ooo`00o`3ooomc
0?ooo`03000000000100000@0080000000<0C0UF0000000000000P1K8Fd00`000000Ncaf00000007
000000P0Ue^700<000000:QXR02XJ8P00`2XJ8PB000000L0aH2700<000000=><Q03CS8@00P3CS8@3
000000030=>3MP000000hY1^008000000P3QPUL01@000000k8Xn0000003PL1@000000080mjmc0P00
00001@3g[g<000000?N_L`000000mjmc008000005`3ooolA00000?l0oooo8`3oool00?l0ooooLP3o
ool200000003000040000000000000800000101K8Fd00`000000Ncaf00000007000000H0Ue^72000
00050:YaTP030000002hO980^7bB00L0^7bB00<000000<F7T@35Qi401@0000020<F0Q`030000003C
S8@0dhb400D0dhb40P0000030>:@KP80000000<0hH9G0000003/RSh00`0000001@3g[g<000000?N_
L`000000mjmc0080000000@0mjmc0000003g[g<000004`3ooolA00000?l0oooo9P3oool00?l0oooo
LP3oool01@000000000@0000000?03/0000000H0Fb5]0P0000000`23Bh@000000000000500000080
Ue^71000000209]UT@030000002ZLI80ZW6B00P0ZW6B00<000000;QlTP2hO9801`2hO9800`000000
aHNA0<F7T@050<F7T@@000001`3CS8@3000000<0hY1^0P0000020>b:?P80000000D0mjmc0000003g
[g<000000?N_L`0200000080mjmc0P00000A0?oooa400000o`3ooolX0?ooo`00o`3oooma0?ooo`<0
000000<03`0k000000000000101K8Fd00`000000IcAo0000000208=;Q0T000001P2KII400`000000
ZW6B0:YaTP080:YaTP030000002hO980^7bB00L0^7bB00<000000<F7T@35Qi401`35Qi4010000000
di>@0000000000050=><Q0040000003RVGl0hYUo000000<0hY1^0P0000020>b:?P80000000P0mjmc
000000000000mjmc0000003g[g<000000?N_L`8000002`3ooolD00000?l0oooo:`3oool00?l0oooo
L@3oool20000000400l0>`000000:01K00000080Fb5]0P00000206LdO`0300000023Bh@0Pd^40080
Pd^40`0000000`28Ei00000009]UT@0709]UT@030000002ZLI80ZW6B00<0ZW6B2P0000050;QlTP03
00000035Qi40aHNA00L0aHNA00@000000=>CT03CTi00di>@0P0000030=><Q0050000003RVGl0hYUo
0>:IO`0000000P3RT6h010000000lIaM0000003/RSh2000000030?N_L`000000mjmc0080000000@0
mjmc0000003g[g<0mjmc0P0000060?oooa<00000o`3oool`0?ooo`00o`3ooom`0?ooo`@000000P0X
05/3000000@0IcAo00<0000008=;Q00000000P00000408QGT0030000002KII40VfFA00@0VfFA2000
00050:ahVP030000002iPiX0^H>J0080^H>J200000070<F7T@030000003CTi00di>@00<0di>@0P00
00000`3CS8@000000>:IO`030>:IO`<000000P3aW5d5000000070?N_L`000000mjmc0000003g[g<0
00000?N_L`02000000@0oooo4`00003o0?oooc80oooo003o0?ooog00oooo0`00000302P0F`030000
001W=7l0IcAo00@0IcAo0P00000708QGT0030000002KII40VfFA00@000000P2NKIX00`000000[7RJ
0:ahVP080:ahVP030000002iPiX0^H>J00L0^H>J00<000000<F>VP35SYX01@0000020<F7T@030000
003CTi00di>@00D0di>@0P0000060>:IO`040000003aW5d0lIaM0?6LG@@0000000L0mjmc0000003g
[g<000000?N_L`000000mjmc008000000P3ooolB00000?l0oooo=@3oool00?l0ooooK`3oool30000
00<0:01K0P00000406LdO`<000001`28Ei04000000H0WVfJ00<000000:ahVP2/N9X0202/N9X00`00
0000^H>J0;V3VP070;V3VP0300000035SYX0aHjJ00D0aHjJ100000070=>CT0<00000103RVGl20000
00<0lIaM00D000000>:42`00000000000?N_L`02000000030?N_L`000000000001<00000o`3ooolh
0?ooo`00o`3ooom_0?ooo`<000000P0X05/2000000<0IcAo0P0000020714S@0300000028Ei00R5N@
0080R5N@0`0000000`2=HIX0000009i]VP0809i]VP030000002/N9X0[7RJ00L0[7RJ00<000000;V3
VP2iPiX01`2iPiX00`000000aHjJ0<F>VP070<F>VP030000003BVIX0000000800000103CTi000`00
0000hJ6=0>6QS@0200000080hYUo00<000000?:XM@0000000P3aW5d4000000030?N_L`000000mjmc
01<00000o`3ooolk0?ooo`00o`3ooom^0?ooo`040000000000D0000002P0F`80000000<0?1Ad0000
001W=7l00P0000040714S@0300000028Ei00000000800000102=HIX00`000000WVfJ09i]VP0709i]
VP030000002/N9X0[7RJ00<0[7RJ2@0000050;V3VP0300000035SYX0aHjJ00L0aHjJ00<000000=:I
VP3BVIX00P3BVIX3000000030=>CT0000000hJ6=00<0hJ6=0`0000020?:XM@<0000000<0m:4i0000
000000004`00003o0?oooch0oooo003o0?ooofh0oooo1000000303`DM08000001P1`A8d2000000L0
SF6J00<0000009i]VP2NKIX01@2NKIX8000000@0[GnR00<000000;V9XP2iRJ800P2iRJ88000000H0
aHjJ00<000000=:IVP3BVIX01P3BVIX2000000H0hJ6=00<000000?:XM@3bZ7D00P3bZ7DB00000003
0?ooo`000000oooo0?l0oooo@03oool00?l0ooooK@3oool2000000030000=@000000?1Ad0080?1Ad
0P0000050714S@<00000202=HIX00`000000WVfJ09i]VP0500000080X7FR00<000000:eoXP2]Oj80
1`2]Oj800`000000^HVR0;V9XP070;V9XP0300000035Tj80aI>R00@000000P35SYX00`000000dYVJ
0=:IVP070=:IVP<00000103QXHd2000000030?:XM@000000000001000000o`3ooom50?ooo`00o`3o
oom]0?ooo`@000000P0l57@00`000000C2^7000000040714S@040000001gDYT0Me:I000000L0SF6J
100000070:1eXP030000002]Oj80[GnR00L0[GnR00<000000;V9XP2iRJ801`2iRJ800`000000aI>R
0<FCXP040<FCXP@00000203BVIX00`000000gjJI0=nVV@0200000080hJ6=00<000000?2`R0000000
4000003o0?ooodL0oooo003o0?ooofd0oooo00H000000000=@000000000003`DM000000304`[Q`04
0000001`A8d0L4B=000000@0Me:I00<0000008eQVP2=HIX00P2=HIX200000003095ZX`000000X7FR
00P0X7FR00<000000:eoXP2]Oj801`2]Oj800`000000^HVR0;V9XP060;V9XP0300000035Tj80aI>R
00L0aI>R00<000000=2NX`0000000P0000040=:IVP030000003OYYT0gjJI00<0gjJI0`0000020?2`
R0d0000000@0mjmc0000003g[g<00000o`3ooom60?ooo`00o`3ooom]0?ooo`80000000<0001K0000
00000000101<:hL3000000D0Me:I00<0000008eQVP0000000P000003095ZX`030000002PMJ80X7FR
00L0X7FR00<000000:eoXP2]Oj800`2]Oj89000000@0^HVR00<000000<FCXP35Tj801`35Tj800`00
0000d9jS0=2NX`020=2NX`<0000000<0dYVJ0000003OYYT01P3OYYT00`000000l;280?2`R0020?2`
R0T0000000@0mjmc0000003g[g<0mjmc0P00003o0?ooodH0oooo003o0?ooofd0oooo0P0000000`00
05/0000004`[Q`0404`[Q`030000001gDYT0Me:I00D0Me:I0P000007095ZX`030000002PMJ80X7FR
00@0X7FR200000040:j5Z@030000002iSZT0^HjY0080^HjY2@0000050<FCXP030000003@WZ<0d9jS
00D0d9jS0P0000070=nVV@800000103`/8P500000080mjmc0P0000000`3g[g<000000?N_L`020000
0?l0ooooAP3oool00?l0ooooK03oool2000000030000F`000000000000@0C2^70P00000507MBV@<0
0000202AJZ<00`000000X7FR0:1eXP0400000080XWbY00<000000:j5Z@2^QJT01`2^QJT00`000000
^HjY0;V>Z@060;V>Z@0300000034V:T0a9RY0080a9RY1`0000070=2NX`<000001@3OYYT00`000000
k[JG000000030?2`R080000000D0o;AN00000000000000000?N_L`02000000060?N_L`000000mjmc
0000003g[g<00000o`3ooom50?ooo`00o`3ooom/0?ooo`80000000<0001K0000000000000`1<:hL0
0`000000FCfF0000000307MBV@8000000P1mGJ<00`000000TFZS095ZX`05095ZX`@000001P2RO:T0
0`000000[XFY0:j5Z@070:j5Z@030000002iSZT0^HjY00H0^HjY00<000000<BHZ@34V:T01`34V:T0
10000000cj>Z0000000000040=2NX`040000003MZj<0gJ^S0=f[X`8000000P3OYYT02P000000k[JG
0>jfU`3^]YL000000?2`R0000000oL5j0000003l]5h3000000090?N_L`00000000000?N_L`000000
mjmc0000003g[g<000000?l0ooooA@3oool00?l0ooooK03oool3000000030182N0000000C2^70080
00000`1I?IH3000000D0OEfS00<00000095ZX`2AJZ<00P2AJZ<20000000309AbZP000000XWbY00P0
XWbY00<000000:j5Z@2^QJT01P2^QJT00`000000^HjY0;V>Z@060;V>Z@0300000034V:T0a9RY00L0
a9RY00@000000<nSZP3?XjX0cj>Z0`0000000`3@WZ<000000=f[X`040=f[X`<00000103^]YL20000
00030?g1NP000000o;AN00<0000000L0mjmc0000003g[g<000000?N_L`000000mjmc00800000o`3o
oom50?ooo`00o`3ooom/0?ooo`<0000000<04P9h0000000000001@1I?IH00`000000OEfS07eMX`05
07eMX`030000002AJZ<00000008000000`2DLZX00`000000XWbY0:9lZ@070:9lZ@030000002^QJT0
[XFY0080[XFY2@0000040;V>Z@0300000034V:T0a9RY00H0a9RY00<000000<nSZP3?XjX01@3?XjX2
000000L0gJ^S00<000000>jfU`3^]YL00`3^]YL00`000000oL5j0?g1NP03000000030?N_L`000000
mjmc0080000000H0mjmc0000003g[g<000000?N_L`00003o0?oood@0oooo003o0?ooof`0oooo0P00
00020182N0030000001I?IH0FCfF00<0FCfF0P00000707eMX`8000001`2DLZX00`000000XWbY0:9l
Z@040:9lZ@L00000102_Rjl00`000000^I>_0;VC[`020;VC[`T000001034V:T00`000000cj>Z0<nS
ZP060<nSZP<000001@3MZj<2000000@0k[JG0P0000001`3m`GX00000000000000000mjmc0000003g
[g<00P0000001P3g[g<000000?N_L`000000mjmc00000?l0ooooA03oool00?l0ooooJ`3oool30000
00030182N0000000000000@0FCfF00<0000006==X`0000001@1mGJ<3000000P0U7:Z00<000000:9l
Z@2RO:T0100000020:B2/0030000002_Rjl0[h^_00H0[h^_00<000000;VC[`2iTjl01P2iTjl00`00
0000`ib`0<>L/0020<>L/0H000001`3?XjX00`000000fZn[0=Z_Z`0200000080gJ^S00@000000>Zk
X`3Z^j<000000`3^]YL200000080oL5j00D000000>F]:@00000000000?N_L`02000000060?N_L`00
0000mjmc0000003g[g<00000o`3ooom40?ooo`00o`3ooom[0?ooo`040000000002<000000182N080
00000P1I?IH2000000<0HdfS00<0000007eMX`1mGJ<00P00000208=X[0030000002DLZX0U7:Z00D0
U7:Z100000060:B2/0030000002_Rjl0[h^_00H0[h^_00<000000;VC[`2iTjl01P2iTjl00`000000
`ib`0<>L/0060<>L/0040000003=Y[400000000000@0cj>Z00<000000=Z_Z`3J[j/00`3J[j/30000
00<0j[^S0P0000002`3^]YL000000?_9S`000000oL5j0000003U[BT000000?N_L`000000mjmc0080
000000H0mjmc0000003g[g<000000?N_L`00003o0?oood<0oooo003o0?ooof/0oooo1000000202TN
SP8000001@1SCJ<3000000D0PfR/00<0000009AbZP2DLZX0100000000`2GN[4000000:B2/0070:B2
/0030000002_Rjl0[h^_00H0[h^_00<000000;VC[`2iTjl01@2iTjl00`000000`ib`0<>L/0070<>L
/0040000003=Y[40cJJa0<fV/@<0000000<0cj>Z0000003J[j/01P3J[j/00`000000j[^S0>ZkX`03
0>ZkX`8000000P3kbHl4000000030?N_L`000000000000P00000o`3ooom30?ooo`00o`3ooom[0?oo
o`@000000P0Y7Xh00`000000HdfS06==X`0406==X`0300000023J:`0PfR/00D0PfR/0`00000509Mj
/@030000002TP[00Y8:`00H0Y8:`00<000000:n;[`2_Rjl00P2_Rjl8000000@0^I>_00<000000<>L
/033W;001P33W;000`000000cJJa0<fV/@050<fV/@8000001`3J[j/2000000D0j[^S00<000000?_9
S`3kbHl01P0000002@3g[g<000000000003g[g<000000?N_L`000000mjmc0000003o0?oood<0oooo
003o0?ooof/0oooo0`00000202TNSP8000001@1SCJ<2000000D0PfR/0`00000809Mj/@030000002T
P[00Y8:`00@0Y8:`1P0000040:n@]P040000002iV;H0^IRf0;VH]PL000001P33W;000`000000cJJa
0<fV/@060<fV/@<00000103J[j/010000000i[j]0>Jn[@0000030>ZkX`030000003gcZ0000000080
nlV?00l000000?K7EP000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_
L`000000o`3ooom20?ooo`00o`3ooom[0?ooo`0300000000058000000080:Aj>00<0000003`eW`00
00000P1SCJ<20000000306aK[@000000PfR/0080PfR/0P00000308Ma/`030000002GN[40UgZa00D0
UgZa00<000000:B2/02TP[00100000000`2UR;H000000:n@]P070:n@]P030000002iV;H0^IRf00D0
^IRf00<000000<:P]P32X;H0100000020<>L/0030000003=Y[40cJJa00D0cJJa00D000000=Rb/`3H
/[<0f;:c000000030=Z_Z`050000003V_Zd0i[j]0>Jn[@0000000P3Z^j<00`000000mljP00000002
0?_9S`030000003faeH000000080mjmc00X000000?N_L`00000000000?N_L`000000mjmc0000003g
[g<00000o`3ooom20?ooo`00o`3ooom[0?ooo`05000000000580000002TNSP0000000P0l=Il00`00
0000HdfS0000000406aK[@<000001@27LK<00`000000UgZa09Mj/@0409Mj/@@000001@2UR;H00`00
0000[i2f0:n@]P060:n@]P030000002iV;H0^IRf00D0^IRf00<000000<:P]P32X;H01032X;H40000
00H0cJJa00<000000=Rb/`3H/[<00P3H/[<3000000D0i[j]0P0000030?O>X0<0000000H0m/MF0000
00000000mjmc0000003g[g<2000000060?N_L`000000mjmc0000003g[g<00000o`3ooom20?ooo`00
o`3ooom[0?ooo`80000000<0001g0000000000000`0l=Il00`000000K5^]06aK[@0306aK[@030000
0027LK<0Qg6c00H0Qg6c00<0000009Mj/@0000000`0000000`2IPKP000000:F8]P070:F8]P030000
002_T;H0[i2f00D0[i2f00<000000;VH]P2iV;H01@2iV;H00`000000`Z2f0<:P]P060<:P]P030000
003;Z[P0000000<0000000<0cJJa0000003H/[<01P3H/[<00`000000i[j]0>Jn[@040>Jn[@040000
003gcZ00mljP0?O>X0<0000000H0m/MF000000000000mjmc0000003g[g<2000000060?N_L`000000
mjmc0000003g[g<00000o`3ooom20?ooo`00o`3ooom[0?ooo`80000000<0001g0000000l=Il00P0l
=Il2000000@0K5^]00<0000007=W]P0000001`27LK<2000000D0VH6h00<000000:F8]P2UR;H01P2U
R;H00`000000[i2f0:n@]P050:n@]P030000002iV;H0^IRf00D0^IRf00<000000<:P]P32X;H01@32
X;H00`000000bjZh0<^Z^0040<^Z^08000001`3H/[<2000000@0i[j]00<000000?;@[@0000000`3g
cZ004@000000oMQj0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc
0000003g[g<000000?l0oooo@@3oool00?l0ooooJ`3oool2000000030000M`000000?3FO0080?3FO
00<0000004]9[@0000000P1/Fjd010000000LfNf07=W]P00000508Ma/`<000001`2IPKP00`000000
YHRf0:F8]P040:F8]Q<000001P32X;H00`000000bjZh0<^Z^0050<^Z^0<00000103H/[<00`000000
h/6f0>;1]P0200000080i[j]00@000000?;@[@3bd:d000000P3gcZ000`000000oMQj000000020000
0080mjmc0P000000203g[g<000000?N_L`000000mjmc0000003g[g<00000o`3ooom10?ooo`00o`3o
oom/0?ooo`030000000007L000000080?3FO00@0000004]9[@1;BJd000000P1/Fjd01@000000LfNf
07=W]P1cIkH0000000<0Qg6c00D0000008aj^P2<N[X0S7Zj0000000609V1^0030000002UR;H0YHRf
00@0000000<0YXjl0000002`UK/01P2`UK/00`000000^9bk0;RL^`050;RL^`0300000031Y;`00000
00<0000000<0`Z2f0000003;Z[P01P3;Z[P01@000000eKFj0=Fe^P3E]KX0000000<0f;:c00<00000
0>;1]P3R`KH00P3R`KH2000000<0l]2]00D000000?O>X000000000000?gHNP02000000050?N_L`00
0000mjmc0000003g[g<00P0000001P3g[g<000000?N_L`000000mjmc00000?l0oooo@@3oool00?l0
ooooK03oool200000003000?U0000000000000@0BdV]0P00000407=W]P0400000027LK<000000000
00@0S7Zj00<0000009V1^02IPKP00`2IPKP4000000D0YXjl00<000000;2E^`2`UK/01@2`UK/00`00
0000^9bk0;RL^`050;RL^`0300000031Y;`0`JBl00<0`JBl0`0000060<^Z^0030000003E]KX0eKFj
0080eKFj0`0000060>;1]P030000003bd:d0l]2]0080l]2]0`000000303mf7X000000000003g[g<0
00000?N_L`000000mjmc0000003g[g<000000?N_L`80000000<0mjmc0000003oool0o`3ooom00?oo
o`00o`3ooom/0?ooo`80000000<000nD000000000000101;BJd00`000000LfNf07=W]P0407=W]P03
0000002<N[X0S7Zj00D0S7Zj00<0000009V1^00000000P0000000`2KR;h000000:J>_0070:J>_003
0000002`UK/0/9Fk00@0/9Fk00<000000;RL^`2hW;/0102hW;/00`000000`JBl0<6T_0050<6T_003
00000039[Kh0000000<0000000<0bjZh0000003E]KX01P3E]KX00`000000h/6f0>;1]P040>;1]P80
0000103bd:d00`000000o^6F000000020000000>0?N_L`000000mjmc0000003g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`00003o0?oood00oooo003o0?ooof`0oooo0P0000000`003i@0
000004]9[@0304]9[@8000001@1cIkH2000000L0S7Zj0P00000509^8_P030000002VS[`0YXjl00D0
YXjl00<000000;2E^`2`UK/0102`UK/00`000000^9bk0;RL^`040;RL^`0300000031Y;`0`JBl00D0
`JBl00<000000<V]_P39[Kh00`39[Kh2000000H0eKFj00<000000=k3_@000000103R`KH010000000
kM:h0>gB^00000020?;@[@80000000@0o^6F000000000000mjmc0P0000020?N_L`80000000P0mjmc
0000003g[g<000000?N_L`000000mjmc00000?l0oooo@03oool00?l0ooooK03oool200000003000?
U0000000BdV]0080BdV]00@0000005QJ^@1HF[T000000P1cIkH200000080NW:n00<0000008aj^P2<
N[X00P2<N[X3000000H0VhRn00<000000:J>_02VS[`0102VS[`A000000D0`JBl00<000000<V]_P39
[Kh01@39[Kh3000000@0eKFj00<000000=k3_@3N`kd00P0000020>;1]P040000003]d[P0kM:h0000
0080l]2]0P0000000`3nhIH0000000000002000000050?N_L`000000mjmc0000003g[g<00P000000
1P3g[g<000000?N_L`000000mjmc000000X0oooo1P3o003o0?oooc00oooo003o0?ooofd0oooo00@0
0000000?U000000000000P1;BJd01P000000F5Zi05QJ^@000000LfNf000000@0NW:n00<0000008aj
^P2<N[X00P00000308n2`@030000002KR;h0VhRn00@0VhRn00<000000:J>_00000000`0000000`2W
U<8000000;2J`@050;2J`@030000002hXL40^:7100@0^:7100<000000;nX`P0000000`0000000`31
Y;`000000<V]_P050<V]_P040000003A^<40dKS10=6h`@80000000<0eKFj0000003N`kd0103N`kd2
000000@0kM:h0P0000000`3jiJX000000?kQUP02000000030?N_L`000000000000<0000000D0mjmc
0000003g[g<000000?N_L`02000000030?N_L`000000oooo00P0oooo203o003o0?ooobl0oooo003o
0?ooofd0oooo0P000000100H;ZT0000004]9[@00000405QJ^@030000001jL[h0NW:n00@0NW:n0P00
000508n2`@030000002KR;h0VhRn00<0VhRn0`0000050:ND`P030000002`V/40/9[100@0/9[100<0
00000;RQ`@2hXL40102hXL400`000000_jS20;nX`P030;nX`P<000001@39[Kh00`000000dKS10=6h
`@030=6h`@8000001P3N`kd00`000000kM:h0>gB^0030>gB^0030000003jiJX0n^FZ00D0000000<0
mjmc0000003g[g<01`000000103g[g<000000?N_L`0000060?ooo``0o`00o`3oool]0?ooo`00o`3o
oom[0?ooo`@000000P0H;ZT00`000000F5Zi05QJ^@0205QJ^@030000001TJ<80000000@0NW:n00<0
0000085la@0000001P2?P/400`000000VhRn000000020000000309f?a0000000YiC200H0YiC200<0
00000;2J`@2`V/400`2`V/400`000000^:710;RQ`@030;RQ`@030000002oZ<80_jS200D0_jS200<0
00000<N`a00000000P0000000`39[Kh000000=6h`@050=6h`@030000003Ja<@0000000@0g/>m00<0
00000>OC`@0000000`3]d[P200000080n^FZ0P0000000`3g[g<000000?N_L`02000000070?N_L`00
0000mjmc0000003g[g<000000?N_L`05000000H0oooo303o003o0?ooobd0oooo003o0?ooofT0oooo
1P00000201P^Z@8000000`1HF[T00`000000I6S20000000307Yb_P0400000021O<D0PGc5000000H0
Sh;10P00000509f?a0030000002WU<80YiC200@0YiC200<000000;2J`@2`V/400`2`V/400`000000
^:710;RQ`@030;RQ`@030000002oZ<80_jS200@0_jS200<000000<N`a037/<@00`37/<@2000000H0
dKS100@000000=[4a03Ja<@000000P3N`kd010000000im?10>OC`@0000020>gB^0030000003di[T0
00000080n^FZ0P0000001`3g[g<000000?N_L`000000mjmc0000003g[g<00P000000203g[g<00000
0?N_L`000000mjmc0000003g[g<000001@3oool>0?l00?l0oooo;03oool00?l0ooooI@3oool:0000
008062jY0P00000205QJ^@070000001TJ<80I6S206AX`P000000NW:n00000004085la@040000002?
P/40Sh;108n2`@<000001P2MSl@00`000000YiC20:ND`P030:ND`Pl000001@2oZ<800`000000ak34
0<N`a0030<N`a0040000003>^/L00000000000<0dKS100<000000=[4a03Ja<@00P3Ja<@00`000000
g/>m000000030>OC`@060000003]d[P000000?CV^@000000n^FZ0`0000003@3g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00P0000000`3g[g<000000?ooo`03
0?oooa00o`00o`3oool[0?ooo`00o`3ooomS0?ooo`h000000P0_AkT00`000000F5Zi0000000406AX
`P0300000021O<D0PGc500<0PGc500@0000008n2`@00000000000`2CR/L00`000000WHo409f?a004
09f?a0030000002WU<8000000080000000<0Z9[80000002`WlL0102`WlL00`000000]jG70;NUa`03
0;NUa`030000002m[<P000000080000000<0_jS200000037/<@01@37/<@010000000c[[70<jja`3>
^/L2000000030=6h`@000000f/C400@0f/C400<000000>OC`@3Wdl400`3Wdl4010000000m>Ji0?CV
^@3di[T400000080mjmc0P0000003P3g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`00
0000mjmc0000003g[g<000000`3oool@0?l00?l0oooo:`3oool00?l0ooooH03ooolA000000<0;dNi
00<0000006AX`P1TJ<800P1TJ<800`000000KWG900000005085la@030000002CR/L0Th[700<0Th[7
00<0000009f?a02MSl@00`2MSl@3000000@0Z9[800<000000;2Oa`2`WlL00`2`WlL00`000000]jG7
0;NUa`030;NUa`030000002m[<P0_Jc80080_Jc8100000030<N`a0030000003>^/L0c[[700@0c[[7
00<000000=[4a03Ja<@00`3Ja<@00`000000hM;9000000030>OC`@8000000`3di[T400000080mjmc
010000000?N_L`00000000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g
[g<000000`3oool@0?l00?l0oooo:`3oool00?l0ooooG@3ooolD000000<0;dNi0P00000306AX`P03
0000001^MLT0000000@0PGc500<0000008J5b`0000001@2CR/L00`000000WHo40000000200000003
09nFbP000000Z9[800D0Z9[800<000000;2Oa`2`WlL00P2`WlL00`000000]jG70;NUa`020;NUa`03
0000002m[<P0_Jc800<0_Jc800@000000<BcbP34/lX0a;?:100000050<jja`030000003EaL/00000
00<0f/C400@000000>7Bb@3Qd/T000000P3Wdl400`000000k^G5000000030?CV^@@000000P3g[g<0
1P000000mjmc0000003g[g<000000?N_L`80000000P0mjmc0000003g[g<000000?N_L`000000mjmc
000000<0oooo403o003o0?ooob/0oooo003o0?oooeX0oooo4@0000020?ooo`030000003oool00000
008000000P0_AkT200000080I6S200H0000006ieb@1^MLT0KWG900000021O<D200000080QXG;00<0
000009>:a`2CR/L00`2CR/L2000000@0WiK:00<000000:RJb02XV/P0102XV/P00`000000/9o70;2O
a`020;2Oa`030000002gYLL0]jG70080]jG700<000000;f/b02m[<P00`2m[<P00`000000a;?:0<Bc
bP030<BcbP030000003:_<d0000000<0c[[700@000000=G5b`3EaL/0eLG;0P0000000`3Ja<@00000
0>7Bb@020>7Bb@030000003Wdl4000000080k^G500<000000?CV^@0000000`0000002`3g[g<00000
0?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0080000000H0mjmc0000003g[g<00000
0?N_L`0000030?oooa00o`00o`3oool[0?ooo`00o`3ooomG0?oooa<000001@3oool30000000702m7
^@000000@e_604=KaP000000I6S20000000406ieb@0300000026QL/0QXG;00<0QXG;00<0000009>:
a`2CR/L00P0000000`2FT/d0000009nFbP0409nFbP040000002XV/P0Z9[80:RJb0l000000P2m[<P0
0`000000a;?:0<BcbP040<BcbP030000003:_<d0b[c=0080000000<0c[[70000003EaL/0103EaL/0
0`000000hM;90>7Bb@030>7Bb@040000003^iLD0k^G50>kUa@80000000H0koNb0000000000000000
0?N_L`0000020?N_L`80000000T0mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00P00
00000`3g[g<000000?ooo`020?oooa00o`00o`3oool[0?ooo`00o`3ooomD0?oooa<000002@3oool4
000000<0@e_600<0000006ieb@1^MLT00P1^MLT00`000000Mh7@0000000508J5b`8000000`2FT/d0
0`000000WiK:09nFbP0309nFbP@000000P2XX<h00`000000[jG=0:nUc@020:nUc@030000002eZ/d0
]J[=0080]J[=00<000000;^`cP2k/<h0100000040<BcbP030000003:_<d0b[c=00<0b[c=00<00000
0=G5b`3EaL/00`3EaL/00`000000fm;@000000030>7Bb@8000000`3^iLD01@000000koNb00000000
0000mjmc00H0000000l0mjmc000000000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g
[g<000000?N_L`0000000`3oool>0?l00?l0oooo;03oool00?l0ooooDP3ooolA000000d0oooo0P00
00000`00:K40000004=KaP0204=KaP8000000P1^MLT010000000Mh7@07N1d000000408J5b`030000
002;Sm40000000@0UY;=00<0000009nFbP2OU/X00`0000050:RPcP030000002_YLd0[jG=0080[jG=
00<000000;FZc@2eZ/d00P2eZ/d00`000000^k3>0;^`cP020;^`cP0400000031]]00000000000080
a;?:00<000000<Zlc@3:_<d00P3:_<d00`000000d<KA000000030=G5b`040000003Kd]00fm;@0000
0080hM;900<000000>KSc`0000000P3^iLD2000000030>og/P00000000000080000000@0mjmc0000
003g[g<0mjmc0`0000000`3g[g<000000?N_L`02000000080?N_L`000000mjmc0000003g[g<00000
0?N_L`0000040?ooo``0o`00o`3oool]0?ooo`00o`3ooom?0?ooo`l000004`3oool01P00000002Va
000000000000@e_600000080E6g?00<0000006ieb@0000000`1gPM0010000000QXG;000000000002
08^?d@030000002FT/d0UY;=00<0UY;=0P0000030:6Md0030000002XX<h0Z:3>00<0Z:3>00D00000
0:nUc@2_YLd0[jG=000000030;FZc@030000002k/<h0^k3>0080^k3>00<000000<6fd031]]000P31
]]02000000@0b[c=00@000000=36d@3@a]40d<KA0P0000000`3EaL/000000=_Bd0020=_Bd0030000
003Qd/T000000080i^??0P0000001`3/n<D000000>og/P000000mjmc0000003g[g<00P0000020?N_
L`030000003g[g<000000080000000<0mjmc0000003g[g<00P0000001P3g[g<000000?N_L`000000
mjmc000000@0oooo303o003o0?ooobd0oooo003o0?oood/0oooo4@00000E0?ooo`<0000000<04dW5
0000000000000`1DKLl00`000000Mh7@07N1d00307N1d0030000002;Sm40RhoA00<0RhoA00<00000
09JBc@2FT/d00P0000000`2IV]<000000:6Md0020:6Md0030000002XX<h0Z:3>00<0Z:3>00D00000
0:nUc@2_YLd0[jG=000000030;FZc@030000002k/<h0^k3>0080^k3>00<000000<6fd031]]000P31
]]0010000000a[kB0000000000020<Zlc@030000003@a]40d<KA00<0d<KA00<000000=_Bd03Kd]00
0`3Kd]0010000000i^??0>KSc`3Vhll20000000?0>cha@00000000000000003g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`000000mjmc00<0000000<0mjmc0000003g[g<00P000000103g
[g<000000?N_L`0000060?ooo`P0o`00o`3oool_0?ooo`00o`3ooom80?oooa0000006P3oool30000
000301=9a@000000E6g?0080E6g?0P00000307N1d0030000001oS=H0000000D0RhoA0P00000309VJ
d`030000002QWM00XIg@0080XIg@00<000000:RPcP2XX<h0300000020;^`cP0300000031]]00`KK@
0080`KK@00<000000<JndP36_]800P36_]82000000D0d<KA00<000000=CAeP0000000`3Kd]020000
00<0i^??00<000000>cha@3/n<D00P0000001`3g[g<000000000003g[g<000000?N_L`0000000P3g
[g<2000000030?N_L`000000mjmc00<0000000D0mjmc0000003g[g<000000?N_L`02000000L0oooo
1P3o003o0?oooc00oooo003o0?ooodD0oooo4000000N0?ooo`030000SP0000004dW50080000000D0
E6g?0000001SO=L0HgcG0000000207N1d0040000001oS=H0OhcF000000<0RhoA00<00000092He`00
0000102IV]<00`000000XIg@0:6Md00400000080ZJOD00D000000:jZd`2^Z]<0[Z[C000000030;B_
d`030000002h/m@0000000<000000`31]]000`000000a[kB0<JndP020<JndP050000003:a]H00000
0000003@a]400P0000020=CAeP060000003Kd]0000000000003OhMH000000P3Vhll200000080k?S5
100000001@3g[g<000000000003g[g<000000080mjmc00L000000?N_L`00000000000?N_L`000000
mjmc00<0000000H0mjmc0000003g[g<000000?N_L`00003o0?oooc`0oooo003o0?oood80oooo4@00
000P0?ooo`@0000000<0<F;C0000000000000`1SO=L2000000@0OhcF00<0000008^?d@0000000`2@
V=L00`000000VI[C09VJd`0209VJd`8000000P2SY=H01@000000ZJOD0:VWe02YYm@0000000<0[Z[C
00@000000;B_d`2d[m<000000`2h/m@00`000000_KWF0;fieP03000000@0a[kB00<000000<[6eP3:
a]H00P3:a]H00`000000e=7F0=CAeP030=CAeP030000003OhMH0gn7F0080gn7F0P0000000`3Vm=<0
00000>cha@0200000080mjmc00H000000?N_L`00000000000?N_L`0000020?N_L`040000003g[g<0
00000?N_L`80000000<0mjmc0000003g[g<01@0000000`3g[g<000000?ooo`3o0?oooc/0oooo003o
0?ooocl0oooo4@00000T0?ooo`80000000@04dW50000000aH]<00000101SO=L00`000000OhcF07n<
eP0307n<eP030000002@V=L0T9SG00<0T9SG00H0000009VJd`000000000009bRf@0000020:>TeP03
0000002YYm@0ZJOD0080ZJOD00@000000:jZd`2^Z]<000000P2d[m<01@000000^;?D0;Rce02h/m@0
000000<0_KWF00H000000<6of000000000000<JndP0000040<[6eP030000003=cm/0000000<0e=7F
0P0000040=oQeP030000003Vm=<0i_CC00@000000P3g[g<3000000030?N_L`00000000000080mjmc
00H000000?N_L`000000mjmc0000003g[g<2000000050?N_L`000000mjmc0000003g[g<00`00003o
0?oooc`0oooo003o0?oooc`0oooo4@00000X0?ooo`<0000000<0<F;C0000000000000`1SO=L20000
00<0OhcF00<0000008JFf`0000001@2@V=L01@000000W:;I09bRf@2LX]T0000000<0XjCF00<00000
0:VWe02YYm@02@0000000`2h/m@000000;fieP020;fieP0300000031_mP0`KoH0080`KoH00<00000
0<[6eP3:a]H00P3:a]H01@000000cLoK0<g?f`000000e=7F0080000000<0emgL0000003OhMH00P3O
hMH200000080i_CC100000020?N_L`030000003g[g<000000080000000d0mjmc0000003g[g<00000
0?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0080000000@0mjmc0000003g[g<00000
o`3oooll0?ooo`00o`3ooolh0?oooa400000;03oool300000003035Rd`000000BGOM00<000000P1`
R]`20000000407n<eP000000QYKK08JFf`80000000D0T9SG000000000000UJ7L0000000309bRf@03
0000002SY=H0XjCF00<0000000D0ZJkK0000002]/=X0[K3J000000020;6dfP030000002e^=/00000
008000000P2m^MH01P000000`KoH0<6of031_mP000000<C6g080000000<0b/KF0000003=cm/00`3=
cm/00`000000emgL0=OMg0020=OMg0@000000P3Vm=<07@000000d_bg000000000000mjmc0000003g
[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`000000mjmc00800000o`3oooll0?ooo`00o`3ooole0?oooa40
0000<03oool500000080BGOM00<00000072:g01`R]`00P1`R]`2000000@0QYKK00<0000009FQg02E
XM`00P2EXM`00`000000W:;I09bRf@03000000050:B/g0000000ZJkK0:V^f`0000000P2]/=X00`00
0000/KCJ000000020;Fhf`030000002h_=`0^;cL00<000000P31_mP00`000000a<KL0<C6g0020<C6
g0040000003=cm/0cLoK0<g?f`<00000103GgM`00`000000g_3L0=k`g007000000070?N_L`000000
mjmc0000003g[g<000000?N_L`0300000080mjmc0P0000003P3g[g<000000?N_L`000000mjmc0000
003g[g<000000?N_L`000000mjmc0000003g[g<00000o`3ooolk0?ooo`00o`3ooolb0?oooa400000
=03oool200000004001Bc`000000BGOM04Ugg@<000000P1`R]`01`000000NiKQ000000000000QYKK
0000002>X>000P00000309FQg08000000P2OZ]h010000000Y:cL0:B/g00000020:V^f`050000002]
/=X000000;6dfP0000000P2e^=/010000000^;cL0;Rlg00000020;_1gP8000001034a]`200000003
0<g?f`000000000000<0cmWQ00<000000=OMg00000000P0000020=k`g0030000003Fom0000000080
000000@0mjmc0000003g[g<000000P3g[g<2000000030?N_L`000000mjmc00@0000000l0mjmc0000
00000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000o`3ooolk
0?ooo`00o`3oool_0?oooa400000>03oool01P00000005;?000000000000BGOM00000080GHSS0`00
000307^Fh@8000000`2>X>030000000309ZYh@000000Wj[N0080Wj[N00<000000:B/g00000000P2Y
[]/5000000050;Fhf`000000^;cL0;Rlg00000000`2k`Mh010000000_LKQ00000034a]`200000080
a/gP00<000000<oIh@3?fN400`3?fN4200000080e^[S0`0000020=Kod0040000003g[g<000000?N_
L`<000000P3g[g<2000000040?N_L`000000mjmc00000080mjmc00@000000?N_L`000000mjmc0P00
0000103g[g<000000?N_L`3g[g<2000000040?N_L`000000mjmc00000?l0oooo>`3oool00?l0oooo
;03ooolA000003`0oooo00<00000001Bc`0000000`00000305f8h`030000001kU^40NiKQ0080NiKQ
0`00000308jPh0030000002JZN40VZWQ008000000P2OZ]h7000000030:jihP000000000000<00000
0P2k`Mh2000000<0_LKQ00<000000<K=h036cN000`0000020<oIh@80000000@0c^?W0000003Fj^<0
e^[S0P0000000`3Do=l000000=Kod002000000060?N_L`000000mjmc0000003g[g<000000P3g[g<0
10000000mjmc0000000000020?N_L`030000003g[g<000000080000000<0mjmc0000003g[g<00P00
00020?N_L`80000000@0mjmc0000003g[g<00000o`3ooolk0?ooo`00o`3ooolY0?oooa000000@@3o
ool2000000809W3O00@0000005f8h`1MR><0GHSS0`0000000`1kU^40000008JQi@0208JQi@<00000
00<0UJ[T0000000000000P2JZN42000000030::ci000000000000080Z;GR00<0ZkOR0000002^^N80
0P0000000`2b_^<000000;C1i00200000080_LKQ0P0000020;k;i08000000`36eND200000080c^?W
00<000000=KZh`0000000P0000000`3Do=l0000000000005000000030?N_L`000000mjmc00@00000
00<0mjmc0000000000000P3g[g<010000000mjmc0000003g[g<3000000090?N_L`000000mjmc0000
003g[g<000000?N_L`000000mjmc00800000o`3ooolk0?ooo`00o`3ooolU0?oooa400000A@3oool2
000000809W3O0P000000101MR><0000006jFj01^U^P400000080QZ7U00D0000008n[j00000000000
09FZi005000000040::ci0000000000009=>N080000000<0]6Yj00000000000010000000102eaNH0
00000000002nbn@2000000030;k@j0000000a]GU0080000000<0aMcZ0000003>hnL00P3>hnL20000
0080coGX00<000000=Clg`0000001P000000103g[g<000000?N_L`0000020?N_L`0<0000003g[g<0
00000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0`0000002P3g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`00003o0?ooocX0oooo003o0?ooob80oooo4@0000190?ooo`@0
000000@0AXOY00000000000000000P1^U^P00`000000OJ;[07fRj`0400000080Sj_X0`0000000`2L
/nP0000000000004000000030:EMNP000000]6Yj00H000000P2eb>P2000000<0_]3X0P0000030<GL
jP030000003>hnL00000008000000P3?mNP;000000030?N_L`00000000000080mjmc0`0000003P3g
[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000P3g[g<2
000000040?N_L`000000mjmc00000?l0oooo>P3oool00?l0oooo7`3ooolA000004d0oooo1P000000
0`1OV>h000000000000300000080OJ;[00L0000008Z]k@000000000008n[j0000000VKC[00800000
00<0W;?X0000001l>g@00P0000000`2UGGX000000;AZNP02000000030=:1M0000000000000800000
00<0]L_[0000002nd>P00P000000102leN`000000<GLjP35g>X4000000040<S/kP000000coGX0<oe
j0@0000000<0mjmc0000000000001@0000000`3g[g<00000000000020?N_L`0>0000003g[g<00000
0?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<4000000070?N_L`000000
00000?N_L`000000mjmc0000003o0?ooocX0oooo003o0?oooa`0oooo4@00001A0?ooo`80000000<0
06KI0000000000000`0000000`1OV>h0000007BUl0050000000308Z]k@0000000000014000000P2e
bn/2000000<0_=G/0`0000001031ho0000000<S/kP38k>h700000080mjmc2@0000001@3g[g<00000
0?N_L`000000mjmc00<0000000@0mjmc0000003g[g<0mjmc0P0000020?N_L`80000000<0mjmc0000
003g[g<00P0000001@3g[g<000000000003g[g<000000?l0oooo>P3oool00?l0oooo6@3ooolA0000
05H0oooo0`0000000`0[QN/0000004nJl`040000000407BUl0000000QJoa08F_l@<000000`2F]^d2
0000000607`kM000000000000:EMNP000000]6Yj0P000000103BPG@000000000000000020;?>k@<0
000000@0^MW`00000031ho00`N?`1P0000020;gjj`80000000H0mjmc0000003g[g<0mjmc0000003g
[g<7000000080?N_L`000000mjmc0000003g[g<000000?N_L`0000020?N_L`060000003g[g<00000
0?N_L`000000mjmc0P000000103g[g<000000?N_L`3g[g<3000000030?N_L`00000000000?l0oooo
>P3oool00?l0oooo5P3oool@000005/0oooo1@00000304nJl`h0000000D0Tdih0000002UGGX00000
0;AZNP02000000030=:1M0000000000000X0000000H0^NOe0000002ll_80_?;b0000002mn^/30000
0080mjmc0P000000103g[g<000000?N_L`3g[g<8000000050?N_L`000000mjmc0000003g[g<01000
00001`3g[g<000000?N_L`000000mjmc0000003g[g<00P0000020?N_L`070000003g[g<000000?N_
L`000000mjmc0000003o0?ooocT0oooo003o0?oooa<0oooo4000001O0?ooo`H0000000<0Ci[c0000
001[ZOH00P1[ZOH010000000PK?e086cm@21/oD60000000709=>N0000000YEej0000002dJWX00000
0<=fN@02000000030>6=K00000000000008000000P2dg?@00`000000^NOe0;WWm@08000000060?N_
L`00000000000?N_L`000000mjmc0P0000020?N_L`P0000000H0mjmc0000003g[g<000000?N_L`00
00020?N_L`0>0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000
003g[g<3000000030?N_L`000000oooo0?l0oooo>03oool00?l0oooo3`3ooolA000006@0oooo3@00
00000`1n^?T000000000000<000000030>6=K000000000000080[Mgh1P0000000`2Yl_@000000000
000200000080mjmc0`0000001@3g[g<000000?N_L`3g[g<000000080mjmc2P0000020?N_L`800000
0P3g[g<30000000=0?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00000
0?N_L`0300000?l0oooo>@3oool00?l0oooo303ooolA000006T0oooo4@0000001`2CCWP000000:EM
NP000000]6Yj00000033MWT0400000000`3g[g<00000000000020?N_L`040000003g[g<000000000
0080mjmc00<000000?N_L`0000000P3g[g<800000080mjmc0P0000020?N_L`030000003g[g<00000
0080000000h0mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc
00000?l0oooo>@3oool00?l0oooo2@3ooolA000006l0oooo10000000100cX_8000000000001O]O`6
0000000709=>N0000000YEej0000002dJWX000000<=fN@02000000040>6=K0000000000000000080
WNOl0P000000102>jo<000000000000000020?N_L`030000003g[g<000000080mjmc00@000000?N_
L`3g[g<000000P3g[g<300000080mjmc2@0000002P3g[g<000000?N_L`000000mjmc0000003g[g<0
00000?N_L`0000020?N_L`80000000@0mjmc0000003g[g<000000P3g[g<2000000030?N_L`000000
oooo0?l0oooo>03oool00?l0oooo1P3ooolA000007@0oooo2P000000301l>g@0000009=>N0000000
YEej0000002dJWX000000<=fN@000000dX5d0>6=K0/000000P3g[g<00`000000mjmc0?N_L`020000
00030?N_L`000000mjmc00<0000000<0mjmc0000000000000P3g[g<00`000000mjmc000000080000
00070?N_L`000000mjmc0000003g[g<000000?N_L`05000000040?N_L`000000mjmc00000080mjmc
00@000000?N_L`0000000000o`3oooli0?ooo`00o`3oool30?oooa400000N`3oool60000000307`k
M0000000000000L0000000<0dX5d0000000000000`0000001`3g[g<000000?N_L`000000mjmc0000
003g[g<00`0000020?N_L`80000000@0mjmc000000000000mjmc0P0000020?N_L`040000003g[g<0
mjmc00000080mjmc20000000203g[g<000000?N_L`000000mjmc0000003g[g<000000P3g[g<01000
0000mjmc0000000000020?N_L`070000003g[g<000000?N_L`000000mjmc0000003o0?ooocP0oooo
003o0?oooa000000PP3oool50000000709=>N0000000YEej0000002dJWX000000<=fN@0700000004
0?N_L`000000mjmc00000080mjmc0P0000020?N_L`040000003g[g<0mjmc00000080mjmc00@00000
0?N_L`3g[g<000000P3g[g<2000000040?N_L`000000mjmc0?N_L`X000000P3g[g<2000000040?N_
L`000000mjmc0?N_L`<0000000X0mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00000
o`3ooolh0?ooo`00n`3ooolA000008@0oooo100000002`1l>g@0000009=>N0000000YEej0000002d
JWX000000<=fN@000000dX5d00D000000P3g[g<010000000mjmc0000003g[g<200000080mjmc00@0
00000?N_L`00000000000P3g[g<00`000000mjmc0?N_L`02000000030?N_L`000000mjmc00800000
0P3g[g<:00000080mjmc00@000000?N_L`00000000000P3g[g<03@000000mjmc0000003g[g<00000
0?N_L`000000mjmc0000003g[g<000000?N_L`000000o`3ooolh0?ooo`00n`3oool>000008L0oooo
100000002`1l>g@0000009=>N0000000YEej0000002dJWX000000<=fN@000000dX5d00`0000000@0
mjmc0000003g[g<0mjmc0P000000103g[g<000000?N_L`0000020?N_L`80000000D0mjmc0000003g
[g<0mjmc000000020?N_L`040000003g[g<000000?N_L`L0000000<0mjmc0000003g[g<00P000002
0?N_L`030000003g[g<000000080000000P0mjmc0000003g[g<000000?N_L`000000mjmc00000?l0
oooo>03oool00?/0oooo2`00002:0?ooo`80000000D0GB5[0000001l>g@0000009=>N00500000005
0<=fN@000000dX5d0000003QSF`00`0000020?N_L`030000003g[g<000000080mjmc0P0000020?N_
L`030000003g[g<0mjmc0080000000<0mjmc0000000000000P3g[g<200000080mjmc00<000000?N_
L`0000000P3g[g<2000000030?N_L`000000000000H0000000`0mjmc0000003g[g<000000?N_L`00
0000mjmc0000003g[g<000000?N_L`0000020?N_L`80000000<0mjmc0000003oool0o`3ooolg0?oo
o`00n`3oool8000008d0oooo0P0000000`1M8F/0000007`kM003000000030:EMNP000000]6Yj00D0
000000T0hHe/000000000000mjmc0000003g[g<000000?N_L`0000000P3g[g<00`000000mjmc0000
0002000000<0mjmc00@000000?N_L`00000000000`3g[g<00`000000mjmc0?N_L`0300000080mjmc
00<000000?N_L`000000200000002@3g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`03
00000080mjmc0P0000000`3g[g<000000?ooo`3o0?ooocL0oooo003k0?ooo`D00000T03oool60000
000909=>N0000000YEej0000002dJWX000000<=fN@000000dX5d00@0000000@0mjmc0000003g[g<0
00000P3g[g<00`000000mjmc0?N_L`0200000080mjmc00@000000?N_L`00000000000P3g[g<02000
0000mjmc0?N_L`3g[g<000000?N_L`000000mjmc0P0000020?N_L`030000003g[g<0mjmc00X00000
00T0mjmc0000003g[g<000000?N_L`000000mjmc0000003g[g<00P0000000`3g[g<000000?N_L`02
00000?l0oooo>03oool00?l0ooooT03oool30000000305dQJ`00000000000080Tdih00X000000:EM
NP000000]6Yj00000033MWT000000=:1M0000000hHe/0`0000001`3g[g<000000?N_L`000000mjmc
0000003g[g<00P0000002@3g[g<000000?N_L`000000mjmc0000003g[g<000000?N_L`0200000080
mjmc0`0000020?N_L`040000003g[g<0mjmc00000080mjmc2P000000103g[g<000000?N_L`3g[g<2
000000050?N_L`000000mjmc0000003g[g<00P0000000`3g[g<000000000003o0?ooocP0oooo003o
0?oooi00oooo100000002@1l>g@0000009=>N02CCWP000000:EMNP000000]6Yj000000020<=fN@03
0000003BPG@0000000D0000000<0mjmc0000003g[g<00P000000103g[g<000000?N_L`0000020?N_
L`030000003g[g<0mjmc0080000000D0mjmc0000003g[g<000000?N_L`0200000080mjmc0P000000
1P3g[g<000000?N_L`3g[g<000000?N_L`X000000P3g[g<2000000040?N_L`000000mjmc00000080
mjmc0`0000000`3g[g<000000?ooo`3o0?ooocH0oooo003o0?oooi00oooo100000000`1l>g@00000
00000009000000030=:1M0000000hHe/0080000000<0mjmc0000000000000`0000020?N_L`060000
003g[g<0mjmc0000003g[g<000000`3g[g<00`000000mjmc0?N_L`0200000080mjmc00D000000?N_
L`3g[g<000000?N_L`0200000080mjmc00<000000?N_L`0000002@0000020?N_L`060000003g[g<0
00000000003g[g<000000P3g[g<01@000000mjmc0000003g[g<000000?l0oooo=`3oool00?l0oooo
T03oool00`000000;@1J0000000300000080Tdih00D000000:EMNP000000]6Yj000000020<=fN@<0
000000L0hHe/000000000000mjmc0000003g[g<000000080mjmc00<000000?N_L`0000000P3g[g<2
000000050?N_L`000000mjmc0?N_L`0000000`3g[g<00`000000mjmc0?N_L`02000000070?N_L`00
0000mjmc0?N_L`000000mjmc000000020?N_L`/0000000<0mjmc0000003g[g<00P0000001P3g[g<0
00000?N_L`3g[g<000000?N_L`<00000o`3ooolg0?ooo`00o`3ooon?0?ooo`80000000L0;@1J0000
00000000O3]d0000002CCWP000000080YEej00<000000;AZNP0000000P33MWT00`000000dX5d0000
0005000000050?N_L`000000mjmc0?N_L`0000000P3g[g<01`000000mjmc0?N_L`000000mjmc0000
003g[g<00P0000020?N_L`8000000P3g[g<2000000040?N_L`000000mjmc0?N_L`<000000P3g[g<0
10000000mjmc0000003g[g<9000000030?N_L`000000mjmc008000000P3g[g<01@000000mjmc0000
003g[g<000000?l0oooo=`3oool00?l0ooooS`3oool50000000407`kM0000000Tdih00000080YEej
00T000000;AZNP2dJWX000000<=fN@000000dX5d0000003QSF`00`0000001P3g[g<000000?N_L`00
0000mjmc00000080mjmc100000020?N_L`80000000D0mjmc0000003g[g<000000?N_L`0200000080
mjmc0P0000020?N_L`<000000P3g[g<01@000000mjmc000000000000mjmc00P0000000<0mjmc0000
003g[g<00P0000020?N_L`050000003g[g<000000?N_L`000000o`3ooolg0?ooo`00o`3ooon?0?oo
o`<0000000D0GB5[0000001l>g@0000009=>N007000000050<=fN@000000dX5d0000003QSF`00`00
0000103g[g<000000?N_L`0000020?N_L`030000003g[g<0000000<0mjmc00<000000?N_L`000000
0P3g[g<200000080mjmc0P0000030?N_L`060000003g[g<0mjmc0000003g[g<000000P3g[g<01000
0000mjmc0000003g[g<;0000000:0?N_L`000000mjmc0000003g[g<000000?N_L`000000mjmc0000
0?l0oooo=`3oool00?l0ooooS`3oool30000000305dQJ`000000000000<000000P2UGGX00`000000
]6Yj0;AZNP05000000030>6=K0000000000000X000000`3g[g<010000000mjmc0000000000020?N_
L`050000003g[g<0mjmc0?N_L`0000000`3g[g<00`000000mjmc000000020?N_L`80000000@0mjmc
0000003g[g<000000P3g[g<00`000000mjmc000000050000000<0?N_L`000000mjmc0000003g[g<0
00000?N_L`000000mjmc0000003g[g<00000o`3ooolg0?ooo`00o`3ooon?0?ooo`030000000]05X0
00000080000000@0O3]d0000002CCWP000000P2UGGX01`000000]6Yj0;AZNP000000`gIi0000003B
PG@00`0000001P3_VE`000000?N_L`000000mjmc00000080mjmc00@000000?N_L`3g[g<000000`3g
[g<00`000000mjmc000000020?N_L`8000000P3g[g<200000080mjmc0`0000020?N_L`80000000@0
mjmc0000003g[g<000000P3g[g<<000000040?N_L`000000mjmc0?N_L`80000000<0mjmc0000003o
ool0o`3ooolf0?ooo`00o`3ooon>0?ooo`@0000000H0GB5[0000001l>g@0000009=>N00000020:EM
NP090000002dJWX0]6Yj00000033MWT000000=:1M0000000hHe/00D000000P3g[g<01P000000mjmc
0?N_L`000000mjmc000000<0mjmc00<000000?N_L`3g[g<00P000000103g[g<000000?N_L`3g[g<2
000000030?N_L`000000mjmc008000000P3g[g<01P000000mjmc000000000000mjmc00000080mjmc
2P000000103g[g<000000?N_L`0000020?N_L`80000000<0mjmc0000003oool0o`3ooolf0?ooo`00
o`3ooon>0?ooo`80000000<0;@1J0000000000000P1l>g@010000000Tdih0000002UGGX300000004
0;AZNP000000`gIi00000080dX5d0P0000001`3_VE`000000000003g[g<000000?N_L`0000000P3g
[g<00`000000mjmc0?N_L`0400000080mjmc0P0000020?N_L`8000000P3g[g<200000080mjmc00@0
00000?N_L`3g[g<000000P3g[g<00`000000mjmc000000020?N_L`040000003g[g<000000?N_L`X0
00000P3g[g<010000000mjmc00000000003o0?ooocL0oooo003o0?ooohh0oooo0`0000000`1M8F/0
000007`kM005000000030:EMNP000000]6Yj00D0000000<0dX5d0000003QSF`00`000000103g[g<0
00000?N_L`0000030?N_L`030000003g[g<0000000<0mjmc00@000000?N_L`3g[g<000000P3g[g<2
00000080mjmc0P0000020?N_L`80000000@0mjmc0000003g[g<0mjmc0`0000020?N_L`050000003g
[g<000000000003g[g<01`0000001P3g[g<000000?N_L`3g[g<000000?N_L`800000o`3ooolg0?oo
o`00o`3ooon>0?ooo`<0000000L0GB5[000000000000O3]d0000002CCWP000000080YEej00L00000
0;AZNP2dJWX000000<=fN@000000dX5d0080000000<0hHe/000000000000100000000`3g[g<00000
0?N_L`04000000<0mjmc00@000000?N_L`00000000000`3g[g<01@000000mjmc0?N_L`3g[g<00000
0080mjmc00@000000?N_L`00000000000P3g[g<300000080mjmc00@000000?N_L`000000mjmc2`00
00001P3g[g<000000?N_L`000000mjmc00000?l0oooo=P3oool00?l0ooooSP3oool500000080O3]d
00<0000009=>N00000000P2UGGX01P000000]6Yj0;AZNP000000`gIi00000080dX5d0`0000001@3_
VE`000000?N_L`000000mjmc00<0000000D0mjmc0000003g[g<0mjmc000000030?N_L`80000000<0
mjmc0000003g[g<00P0000030?N_L`030000003g[g<0000000<0mjmc00H000000?N_L`3g[g<00000
0?N_L`0000020?N_L`030000003g[g<000000080mjmc00<000000?N_L`0000001P0000001`3g[g<0
00000000003g[g<000000?N_L`000000o`3ooolf0?ooo`00o`3ooon>0?ooo`<0000000@0GB5[0000
001l>g@000000P2CCWP010000000YEej0:EMNP0000020;AZNP0700000033MWT0`gIi0000003BPG@0
00000>6=K00500000080mjmc00@000000?N_L`3g[g<000000P3g[g<01@000000mjmc0?N_L`3g[g<0
00000080mjmc00P000000?N_L`000000mjmc0000003g[g<000000?N_L`8000000`3g[g<00`000000
mjmc000000020?N_L`80000000@0mjmc0000003g[g<000000P3g[g<:000000060?N_L`000000mjmc
0000003g[g<00000o`3ooolf0?ooo`00o`3ooon=0?ooo`@0000000D0GB5[0000001l>g@0000009=>
N009000000070<=fN@000000dX5d0000003QSF`000000>nIG00300000080mjmc00@000000?N_L`3g
[g<000000`3g[g<4000000<0mjmc00L000000?N_L`3g[g<000000?N_L`000000mjmc008000000P3g
[g<010000000mjmc0000000000020?N_L`060000003g[g<000000000003g[g<000000P3g[g<30000
00030?N_L`000000000000P0000000<0mjmc0000003oool0o`3ooole0?ooo`00o`3ooon=0?ooo`<0
00000P1M8F/40000000509=>N0000000YEej0:EMNP0000000P2dJWX00`000000`gIi000000030000
0080hHe/0`0000001@3g[g<000000?N_L`3g[g<000000080mjmc00@000000?N_L`3g[g<000000`3g
[g<010000000mjmc0?N_L`0000030?N_L`050000003g[g<0mjmc0?N_L`0000000P3g[g<010000000
mjmc0000000000020?N_L`060000003g[g<0mjmc0000003g[g<000000P3g[g<010000000mjmc0000
003g[g<8000000040?N_L`000000mjmc00000?l0oooo=P3oool00?l0ooooS@3oool60000000507`k
M0000000Tdih09=>N00000000P2UGGX010000000]6Yj0;AZNP0000020<=fN@030000003BPG@00000
00D0000000D0mjmc0000003g[g<0mjmc000000020?N_L`@000000`3g[g<010000000mjmc00000000
00030?N_L`050000003g[g<0mjmc0?N_L`0000000P3g[g<01P000000mjmc0?N_L`000000mjmc0000
00<0mjmc0`0000020?N_L`030000003g[g<000000080000000<0mjmc00000000000010000000103g
[g<0000000000000003o0?ooocH0oooo003o0?ooohd0oooo0`00000205dQJ`030000001l>g@00000
0080Tdih00@000000:EMNP2UGGX000000P2dJWX01P000000`gIi0<=fN@000000dX5d00000080hHe/
2`0000030?N_L`040000003g[g<0mjmc0?N_L`80000000<0mjmc0000003g[g<00P0000020?N_L`05
0000003g[g<000000?N_L`0000000P3g[g<00`000000mjmc000000030?N_L`<0000000L0mjmc0000
003g[g<0mjmc0000003g[g<000000080mjmc1`0000000`3g[g<000000?ooo`3o0?ooocD0oooo003o
0?ooohd0oooo0`0000001@1M8F/0000007`kM01l>g@000000080Tdih00<000000:EMNP0000000P00
00001@2dJWX000000<=fN@33MWT000000080dX5d00<000000>6=K00000000P0000001@3g[g<00000
0?N_L`3g[g<000000080mjmc00D000000?N_L`3g[g<0mjmc000000030?N_L`0;0000003g[g<0mjmc
0000003g[g<000000?N_L`000000mjmc0000003g[g<00P0000030?N_L`<000000`3g[g<01@000000
mjmc0000003g[g<000000080mjmc00D000000?N_L`00000000000?N_L`07000000030?N_L`000000
oooo0?l0oooo=@3oool00?l0ooooS03oool40000000305dQJ`000000O3]d00H0000000<0YEej0000
002dJWX01P0000000`3BPG@000000>6=K005000000<0mjmc00@000000?N_L`3g[g<000000P3g[g<0
0`000000mjmc0?N_L`02000000<0mjmc00<000000?N_L`3g[g<00P0000030?N_L`040000003g[g<0
mjmc0?N_L`<000000`3g[g<01@000000mjmc0000003g[g<000000080mjmc00@000000?N_L`000000
mjmc2P00000<0?ooo`030?ooe02K000000000080000000<009_D0?ooo`3oool0o`3ooolR0?ooo`00
o`3ooon<0?ooo`@0000000D0GB5[000000000000O3]d0000000209=>N0040000002UGGX0YEej0000
0080]6Yj00D000000<=fN@33MWT000000=:1M002000000030>6=K0000000000000<000000`3g[g<0
10000000mjmc0?N_L`0000030?N_L`8000000P3g[g<010000000mjmc0?N_L`0000030?N_L`040000
003g[g<0mjmc0?N_L`80000000D0mjmc0000003g[g<0mjmc000000020?N_L`030000003g[g<0mjmc
00<000000P3g[g<00`000000mjmc000000020?N_L`030000003g[g<0000000H000003`3oool00`3o
e9/009_D0?ooo`3o0?ooob@0oooo003o0?oooh`0oooo0P000000100]05X0000000000000000207`k
M0040000002CCWP0Tdih00000080YEej00@000000;AZNP2dJWX000000P33MWT00`000000dX5d0=:1
M003000000050>nIG000000000000?N_L`0000000P3g[g<01P000000mjmc0?N_L`3g[g<000000?N_
L`8000000`3g[g<010000000mjmc0000000000030?N_L`080000003g[g<0mjmc0000003g[g<00000
0?N_L`0000020?N_L`80000000@0mjmc0000003g[g<0mjmc0`0000020?N_L`030000003g[g<00000
0080mjmc2P00000?0?ooo`030;YbLP2jj_l0oooo0?l0oooo8`3oool00?l0ooooS03oool400000004
05dQJ`000000O3]d000000<0Tdih00@000000:EMNP2UGGX000000P2dJWX020000000`gIi0<=fN@33
MWT000000=:1M0000000hHe/100000000`3g[g<000000?N_L`020?N_L`030000003g[g<000000080
000000<0mjmc0000003g[g<00`3g[g<2000000080?N_L`000000mjmc0000003g[g<000000?N_L`00
00020?N_L`8000000P3g[g<2000000070?N_L`000000mjmc0?N_L`000000mjmc000000020?N_L`03
0000003g[g<000000080mjmc0`0000000`3g[g<0000000000005000000d0oooo00<0oooD09/00000
Vm@0o`3ooolT0?ooo`00o`3ooon<0?ooo`80000000<0;@1J0000000000000P1l>g@00`000000Tdih
09=>N00900000080`gIi00<000000=:1M03BPG@00P0000000`3_VE`0000000000007000000030?N_
L`000000mjmc0080mjmc00D000000?N_L`3g[g<0mjmc000000020?N_L`070000003g[g<000000?N_
L`000000mjmc000000030?N_L`050000003g[g<0mjmc0000003g[g<00P000000103g[g<000000?N_
L`3g[g<2000000040?N_L`000000mjmc00000080mjmc00@000000?N_L`000000mjmc2000000<0?oo
o`040>ZjLP00Vm@0e9/009_Dool0oooo8`3oool00?l0ooooR`3oool40000000305dQJ`000000O3]d
00@0000000D0Tdih0000002UGGX0YEej000000020;AZNP0300000033MWT0000000<0000000<0dX5d
0000003QSF`01@0000030?N_L`050000003g[g<0mjmc0?N_L`0000000P3g[g<00`000000mjmc0?N_
L`02000000<0mjmc00D000000?N_L`3g[g<0mjmc000000040?N_L`030000003g[g<0000000<0mjmc
00<000000?N_L`0000000P3g[g<01P000000mjmc000000000000mjmc00000080mjmc00<000000?N_
L`0000000P0000000`3g[g<0000000000005000000/0oooo00@0^W9b0;[Zo`3oj[X0LW:jo`3ooolS
0?ooo`00o`3ooon;0?ooo`80000000<0;@1J0000001M8F/00P0000000`1l>g@0000009=>N00209=>
N0040000002UGGX0YEej00000080]6Yj00H000000<=fN@33MWT0`gIi0000003BPG@2000000030>6=
K0000000000000<000000`3g[g<01@000000mjmc0?N_L`3g[g<0000000<0mjmc0P0000020?N_L`04
0000003g[g<0mjmc000000<0mjmc00H000000?N_L`3g[g<0mjmc0000003g[g<2000000<0mjmc0`00
00020?N_L`060000003g[g<0mjmc0000003g[g<000000P3g[g<00`000000mjmc0000000200000080
mjmc1`0000090?ooo`060?oDV`00Vm@0oooo0?ooo`3DV`00VmCoo`3ooolR0?ooo`00o`3ooon;0?oo
o`80000000@0;@1J00000000000000000P1l>g@010000000Tdih09=>N00000030:EMNP050000002d
JWX0]6Yj0;AZNP0000000P33MWT00`000000dX5d0=:1M003000000050>nIG000000000000?N_L`00
00000`3g[g<010000000mjmc0?N_L`0000030?N_L`060000003g[g<0mjmc0?N_L`000000mjmc0P00
00020?N_L`030000003g[g<000000080mjmc00@000000?N_L`00000000000P3g[g<010000000mjmc
0000000000020?N_L`030000003g[g<0mjmc00<0000000L0mjmc0000003g[g<0mjmc0000003g[g<0
00000080mjmc200000080?ooo`060;YbLP2jj_l0oooo0?ooo`3oj[X0LW:jo`3ooolR0?ooo`00o`3o
oon;0?ooo`@0000000D0GB5[0000001l>g@0O3]d0000000209=>N0030000002UGGX0YEej00<00000
0P2dJWX010000000`gIi0<=fN@0000020=:1M0030000003QSF`0000000<0000000<0mjmc0000003g
[g<00P3g[g<010000000mjmc0?N_L`3g[g<4000000@0mjmc0P0000001P3g[g<000000?N_L`000000
mjmc00000080mjmc00@000000?N_L`3g[g<000000P3g[g<01P000000mjmc0?N_L`000000mjmc0000
00<0mjmc0`0000001P3g[g<000000?N_L`3g[g<000000?N_L`@0000000<0mjmc0000000000001000
00070?ooo`080=BK00000000002K0=Coo`3oom@0V`0000000000VmCo0?ooob40oooo003o0?oooh/0
oooo0P0000001@0]05X0000005dQJ`000000O3]d00L0000000<0YEej0000002dJWX01`0000001@3B
PG@000000>6=K0000000kiUL00`000000`3g[g<01@000000mjmc0?N_L`3g[g<000000080mjmc0P00
00030?N_L`8000000`3g[g<010000000mjmc0?N_L`0000020?N_L`030000003g[g<0000000<0mjmc
00D000000?N_L`000000mjmc000000020?N_L`030000003g[g<000000080mjmc00<000000?N_L`00
00001P00003o0?ooobl0oooo003o0?ooohX0oooo1000000205dQJ`80000000D0O3]d0000002CCWP0
Tdih000000030:EMNP050000002dJWX0]6Yj0;AZNP0000000P33MWT00`000000dX5d000000020000
00030>6=K0000000000000<000000`3g[g<01@000000mjmc0?N_L`3g[g<0000000<0mjmc00<00000
0?N_L`3g[g<00P0000030?N_L`030000003g[g<0mjmc0080mjmc00P000000?N_L`3g[g<000000?N_
L`000000mjmc00000080mjmc0`0000030?N_L`030000003g[g<00000008000000P3g[g<00`000000
mjmc000000020?N_L`<0000000<0oooo0000000000001000003o0?ooobh0oooo003o0?ooohX0oooo
0P0000000`0]05X000000000000200000080O3]d00@0000009=>N02CCWP000000`2UGGX01@000000
]6Yj0;AZNP2dJWX000000080`gIi00D000000=:1M03BPG@000000>6=K002000000050>nIG0000000
00000?N_L`0000000`3g[g<010000000mjmc0?N_L`0000040?N_L`8000000P3g[g<010000000mjmc
0000000000030?N_L`8000000P3g[g<010000000mjmc0000000000030?N_L`<000000P3g[g<00`00
0000mjmc0?N_L`0300000080mjmc00<000000?N_L`0000000P3g[g<3000000030?ooo`0000000000
00D00000o`3oool]0?ooo`00o`3ooon:0?ooo`80000000D0;@1J0000001M8F/0GB5[0000000207`k
M0040000002CCWP0Tdih000000<0YEej00D000000;AZNP2dJWX0]6Yj000000020<=fN@040000003B
PG@0dX5d00000080hHe/100000000`3g[g<000000?N_L`020?N_L`050000003g[g<0mjmc0?N_L`00
00000`3g[g<02@000000mjmc0?N_L`3g[g<000000?N_L`000000mjmc000000020?N_L`050000003g
[g<000000?N_L`0000000P3g[g<010000000mjmc0?N_L`0000020?N_L`040000003g[g<0mjmc0000
0080mjmc00<000000?N_L`0000000P3g[g<00`000000mjmc000000020?N_L`030000003g[g<00000
0080oooo1`00003o0?ooob`0oooo003o0?ooohX0oooo100000000`1M8F/0000007`kM00207`kM003
0000002CCWP0000000X0000000<0`gIi0000003BPG@00P3BPG@010000000hHe/0000003_VE`20000
00030?N_L`000000mjmc0080mjmc00H000000?N_L`3g[g<0mjmc0000003g[g<3000000@0mjmc00H0
00000?N_L`3g[g<000000?N_L`0000020?N_L`8000000`3g[g<2000000040?N_L`000000mjmc0?N_
L`80000000H0mjmc0000003g[g<0mjmc0000003g[g<2000000040?N_L`000000mjmc00000080mjmc
00<000000?N_L`0000000`3oool700000?l0oooo:`3oool00?l0ooooRP3oool20000000402d0FP00
0000GB5[00000080O3]d0`0000000`2CCWP000000:EMNP020:EMNP060000002dJWX0]6Yj0;AZNP00
0000`gIi0`0000020=:1M0040000003QSF`000000>nIG0<0000000<0mjmc0000003g[g<00P3g[g<0
0`000000mjmc0000000200000080mjmc00<000000?N_L`3g[g<00P3g[g<010000000mjmc0?N_L`3g
[g<2000000<0mjmc00P000000?N_L`3g[g<000000?N_L`000000mjmc00000080mjmc0P000000103g
[g<000000?N_L`0000020?N_L`80000000@0mjmc0000003g[g<000000P3g[g<00`000000mjmc0000
00040?ooo`L00000o`3ooolZ0?ooo`00o`3ooon:0?ooo`80000000<0;@1J0000001M8F/00`000000
1@1l>g@0000009=>N02CCWP0000000<0YEej00D000000;AZNP2dJWX0]6Yj000000020<=fN@030000
003BPG@000000080000000<0hHe/0000003_VE`02P0000000`3g[g<000000?N_L`030?N_L`030000
003g[g<0mjmc008000000`3g[g<00`000000mjmc0?N_L`020?N_L`040000003g[g<0mjmc00000080
mjmc0P0000020?N_L`060000003g[g<000000000003g[g<000000P3g[g<01P000000mjmc00000000
0000mjmc00000080mjmc00<000000?N_L`0000001@3oool700000?l0oooo:@3oool00?l0ooooRP3o
ool20000000402d0FP000000000000000080O3]d00D0000009=>N02CCWP0Tdih000000030:EMNP05
0000002dJWX0]6Yj0;AZNP0000000P33MWT010000000dX5d0=:1M03BPG@300000080kiUL0P000000
0`3g[g<000000?N_L`020?N_L`050000003g[g<0mjmc0?N_L`0000000`3g[g<300000080mjmc00D0
00000?N_L`000000mjmc000000020?N_L`050000003g[g<000000?N_L`0000000`3g[g<00`000000
mjmc000000030?N_L`030000003g[g<000000080mjmc00P000000?N_L`3g[g<000000?N_L`000000
mjmc00000080mjmc00<000000?ooo`3oool0103oool500000?l0oooo:P3oool00?l0ooooRP3oool4
0000000505dQJ`000000O3]d07`kM00000000`2CCWP01@000000YEej0:EMNP2UGGX0000000<0]6Yj
00D000000<=fN@33MWT0`gIi000000020=:1M0030000003QSF`0000000@0000000<0mjmc0000003g
[g<00P3g[g<01@000000mjmc0?N_L`3g[g<0000000<0mjmc00<000000?N_L`3g[g<00P3g[g<01@00
0000mjmc0000003g[g<000000080mjmc00D000000?N_L`000000mjmc000000030?N_L`030000003g
[g<0000000<0mjmc0`0000020?N_L`030000003g[g<0mjmc00<0000000D0mjmc0000003g[g<0mjmc
000000070?ooo`<00000o`3oool[0?ooo`00o`3ooon90?ooo`070000000003H0000002d0FP000000
GB5[0000000207`kM14000000P3BPG@00`000000hHe/000000020>nIG08000000P3g[g<01@000000
mjmc0?N_L`3g[g<0000000<0mjmc100000050?N_L`070000003g[g<0mjmc0?N_L`000000mjmc0000
00020?N_L`060000003g[g<0mjmc0?N_L`000000mjmc0P0000020?N_L`060000003g[g<000000000
003g[g<000000`3g[g<3000000050?N_L`000000mjmc0?N_L`000000203oool00`000000oooo0?oo
o`3o0?ooobX0oooo003o0?ooohT0oooo1000000205dQJ`@000000`2CCWP01@000000YEej0:EMNP2U
GGX0000000<0]6Yj00@000000<=fN@33MWT0`gIi100000020>6=K0040000003_VE`0000000000080
mjmc00D000000?N_L`3g[g<0mjmc000000020?N_L`8000000`3g[g<00`000000mjmc0?N_L`020?N_
L`040000003g[g<0mjmc0?N_L`8000000`3g[g<01P000000mjmc0?N_L`3g[g<000000?N_L`800000
0P3g[g<01P000000mjmc0?N_L`000000mjmc000000<0mjmc00D000000?N_L`000000mjmc00000002
0?N_L`030000003oool0oooo0?l0oooo<`3oool00?l0ooooR@3oool01@000000000f000000000000
GB5[008000000P1l>g@01@000000Tdih09=>N02CCWP0000000<0YEej00D000000;AZNP2dJWX0]6Yj
000000030<=fN@030000003BPG@0dX5d0080000000<0hHe/0000003_VE`02`0000000`3g[g<00000
0?N_L`020?N_L`040000003g[g<0mjmc0?N_L`800000103g[g<01@000000mjmc0?N_L`3g[g<00000
0080mjmc00D000000?N_L`3g[g<0mjmc000000020?N_L`060000003g[g<0mjmc0000003g[g<00000
0`3g[g<00`000000mjmc0000000200000080mjmc00<000000?ooo`3oool0o`3ooolc0?ooo`00o`3o
oon90?ooo`80000000D0;@1J000000000000GB5[0000000207`kM0050000002CCWP0Tdih09=>N000
00000`2UGGX01@000000]6Yj0;AZNP2dJWX0000000<0`gIi00D000000=:1M03BPG@000000>6=K002
000000060>nIG000000000000000003g[g<000000`3g[g<00`000000mjmc0?N_L`020?N_L`040000
003g[g<0mjmc00000080mjmc00@000000?N_L`3g[g<000000P3g[g<200000080mjmc00D000000?N_
L`000000mjmc000000030?N_L`040000003g[g<0mjmc00000080mjmc0`0000020?N_L`030000003g
[g<0mjmc00<000000P3g[g<00`000000oooo0?ooo`3o0?oooc<0oooo003o0?ooohT0oooo10000000
0`1M8F/0000007`kM00207`kM0030000002CCWP0Tdih00/000000P33MWT010000000dX5d0=:1M000
00020>6=K0<0000000@0m9hj0000003g[g<000000`3g[g<00`000000mjmc0?N_L`020?N_L`040000
003g[g<0mjmc0?N_L`8000000`3g[g<00`000000mjmc000000020?N_L`040000003g[g<000000?N_
L`8000000`3g[g<010000000mjmc0000000000020?N_L`040000003g[g<0000000000080mjmc00H0
00000?N_L`3g[g<000000?N_L`0000020?N_L`030000003oool0oooo0?l0oooo<`3oool00?l0oooo
R03oool01`000000000f0000000]05X0000005dQJ`0000000P1l>g@40000000309=>N0000000YEej
0080YEej00H000000;AZNP2dJWX0]6Yj00000033MWT400000080dX5d00T000000>6=K0000000kiUL
0000003dWSX000000?N_L`0000000`3g[g<00`000000mjmc0?N_L`020?N_L`050000003g[g<0mjmc
0?N_L`0000001@3g[g<200000080mjmc00<000000?N_L`0000000P3g[g<01P000000mjmc0?N_L`3g
[g<000000?N_L`8000000P3g[g<010000000mjmc0?N_L`0000020?N_L`050000003g[g<0mjmc0000
003g[g<00P0000000`3g[g<000000?ooo`3o0?oooc@0oooo003o0?ooohP0oooo1000000205dQJ`<0
000000<0O3]d0000002CCWP00P2CCWP01@000000YEej0:EMNP2UGGX0000000<0]6Yj00H000000<=f
N@33MWT0`gIi0000003BPG@300000080hHe/100000020?N_L`050000003g[g<0mjmc0?N_L`000000
103g[g<4000000D0mjmc00<000000?N_L`3g[g<00P3g[g<010000000mjmc0?N_L`3g[g<200000080
mjmc00@000000?N_L`3g[g<000000P3g[g<00`000000mjmc0?N_L`02000000080?N_L`000000mjmc
0?N_L`000000mjmc0000003g[g<200000?l0oooo=@3oool00?l0ooooR03oool00`000000000f0000
0004000000<0O3]d00D0000009=>N02CCWP0Tdih000000030:EMNP050000002dJWX0]6Yj0;AZNP00
00000`33MWT010000000dX5d0=:1M03BPG@5000000050?BN>P00000000000?N_L`0000000`3g[g<0
0`000000mjmc0?N_L`03000000<0mjmc00@000000?N_L`3g[g<0mjmc0P0000040?N_L`060000003g
[g<0mjmc0000003g[g<000000P3g[g<010000000mjmc0?N_L`0000020?N_L`050000003g[g<0mjmc
0000003g[g<00P0000001@3g[g<000000?N_L`3g[g<000000080mjmc00<000000?ooo`3oool0o`3o
oolc0?ooo`00o`3ooon80?ooo`80000000D0;@1J0000001M8F/0GB5[0000000207`kM0030000002C
CWP0Tdih0080Tdih00D000000:EMNP2UGGX0YEej000000030;AZNP0300000033MWT0`gIi0080`gIi
00@000000=:1M03BPG@000000P3QSF`00`000000kiUL0000000:00000080mjmc00D000000?N_L`3g
[g<0mjmc000000020?N_L`040000003g[g<0mjmc00000080mjmc0P0000020?N_L`030000003g[g<0
mjmc008000000P3g[g<010000000mjmc0000000000030?N_L`060000003g[g<0mjmc0000003g[g<0
00000P3g[g<010000000mjmc0?N_L`00003o0?ooocD0oooo003o0?ooohP0oooo1000000205dQJ`04
0000001l>g@0O3]d00000080Tdih3@0000020<=fN@040000003BPG@0dX5d00000080hHe/1@000000
0`3g[g<000000?N_L`020?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g[g<00P3g[g<2
000000<0mjmc00P000000?N_L`3g[g<000000?N_L`000000mjmc00000080mjmc0P0000020?N_L`04
0000003g[g<00000000000<0mjmc00H000000?N_L`3g[g<000000?N_L`0000020?N_L`040000003g
[g<0mjmc00000?l0oooo=@3oool00?l0ooooQ`3oool01@000000000f0000000]05X000000080GB5[
00<0000007`kM00000000`00000209=>N0050000002UGGX0YEej0:EMNP0000000`2dJWX00`000000
`gIi0<=fN@040000000;0=:1M0000000hHe/0>6=K0000000kiUL0000003dWSX000000?N_L`000000
103g[g<00`000000mjmc0?N_L`020?N_L`050000003g[g<0mjmc0?N_L`000000103g[g<00`000000
mjmc000000020?N_L`030000003g[g<0000000<0mjmc00@000000?N_L`3g[g<000000P3g[g<01000
0000mjmc0?N_L`0000030?N_L`<0000000<0mjmc0000003g[g<00P3g[g<00`000000oooo0?ooo`3o
0?oooc<0oooo003o0?ooohL0oooo1000000305dQJ`80000000<0O3]d0000002CCWP00`2CCWP01@00
0000YEej0:EMNP2UGGX0000000<0]6Yj00<000000<=fN@33MWT00P33MWT010000000dX5d00000000
00030>6=K0@000000P3g[g<01@000000mjmc0?N_L`3g[g<0000000@0mjmc00<000000?N_L`000000
0P0000050?N_L`8000000`3g[g<010000000mjmc0?N_L`3g[g<200000080mjmc00<000000?N_L`3g
[g<00P0000001P3g[g<000000?N_L`3g[g<000000?N_L`80000000<0mjmc0000003g[g<00P3g[g<0
0`000000oooo0?ooo`3o0?oooc<0oooo003o0?ooohL0oooo00D000000000=P000000000005dQJ`03
00000080O3]d00D0000009=>N02CCWP0Tdih000000040:EMNP030000002dJWX0]6Yj0080]6Yj00D0
00000<=fN@33MWT0`gIi000000020=:1M0<0000000D0hHe/000000000000m9hj000000020?N_L`03
0000003g[g<0mjmc0080mjmc00<000000?N_L`3g[g<00`0000030?N_L`030000003g[g<0mjmc0080
mjmc00<000000?N_L`3g[g<00P3g[g<01P000000mjmc0?N_L`3g[g<000000?N_L`8000000`3g[g<2
000000050?N_L`000000mjmc0?N_L`0000000P3g[g<00`000000mjmc000000030?N_L`030000003o
ool0oooo0?l0oooo<`3oool00?l0ooooQ`3oool20000000302d0FP00000000000080GB5[00@00000
07`kM01l>g@000000`2CCWP00`000000YEej0:EMNP0500000080]6Yj00D000000<=fN@33MWT0`gIi
000000020=:1M0030000003QSF`0hHe/0080000000<0kiUL0000000000002P0000000`3g[g<00000
0?N_L`030?N_L`040000003g[g<0mjmc0?N_L`8000000`3g[g<200000080mjmc00<000000?N_L`3g
[g<00P0000020?N_L`030000003g[g<0mjmc008000000P3g[g<01P000000mjmc0?N_L`000000mjmc
00000080mjmc00<000000?ooo`3oool0o`3ooold0?ooo`00o`3ooon70?ooo`@000000P1M8F/01@00
0000O3]d07`kM01l>g@000000080Tdih100000020:EMNP030000002dJWX0]6Yj00L000000`3BPG@0
0`000000hHe/0>6=K00400000080mjmc00<000000?N_L`3g[g<00P3g[g<00`000000mjmc0?N_L`02
0?N_L`030000003g[g<0mjmc0080mjmc0`0000020?N_L`080000003g[g<0mjmc0000003g[g<00000
0?N_L`0000030?N_L`040000003g[g<0mjmc000000<0mjmc00@000000?N_L`3g[g<000000P3g[g<3
00000080mjmc00<000000?ooo`3oool0o`3ooold0?ooo`00o`3ooon60?ooo`050000000003H00000
02d0FP0000000P1M8F/00`000000O3]d07`kM0040000000309=>N0000000YEej00<0YEej00<00000
0;AZNP2dJWX00P2dJWX010000000`gIi0<=fN@33MWT3000000060=:1M0000000hHe/0>6=K0000000
kiUL0`0000000`3g[g<000000?N_L`030?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g
[g<00P3g[g<00`000000mjmc0?N_L`020?N_L`030000003g[g<000000080mjmc0P0000040?N_L`04
0000003g[g<0mjmc000000<0mjmc00L000000?N_L`3g[g<000000?N_L`000000mjmc008000000P3g
[g<00`000000oooo0?ooo`3o0?oooc@0oooo003o0?ooohH0oooo0`000000100]05X0000005dQJ`1M
8F/30000000307`kM0000000Tdih0080Tdih00<000000:EMNP2UGGX00P2UGGX00`000000]6Yj0;AZ
NP020;AZNP0500000033MWT0`gIi0<=fN@0000000P3BPG@3000000030>6=K0000000kiUL00<00000
00<0mjmc0000003g[g<00`3g[g<00`000000mjmc0?N_L`020?N_L`040000003g[g<0mjmc0?N_L`80
00001@3g[g<2000000<0mjmc00T000000?N_L`3g[g<0mjmc0000003g[g<000000?N_L`0000000P3g
[g<010000000mjmc0000000000020?N_L`040000003g[g<0mjmc00000080mjmc00<000000?ooo`3o
ool0o`3ooold0?ooo`00o`3ooon60?ooo`040000000003H0000002d0FP@000000`1l>g@01@000000
Tdih09=>N02CCWP0000000@0YEej00<000000;AZNP2dJWX00P2dJWX01@000000`gIi0<=fN@33MWT0
000000<0dX5d00@000000>6=K000000000000P3_VE`200000080mjmc00<000000?N_L`3g[g<00P3g
[g<00`000000mjmc0?N_L`020?N_L`<000000P3g[g<00`000000mjmc0?N_L`020?N_L`040000003g
[g<0mjmc0?N_L`8000000`3g[g<010000000mjmc0000000000030?N_L`040000003g[g<000000000
0080mjmc00<000000?N_L`3g[g<00P0000000`3g[g<000000?ooo`3o0?ooocD0oooo003o0?ooohH0
oooo0P00000202d0FP040000001M8F/0GB5[000000<0O3]d00<0000009=>N02CCWP03@0000020<=f
N@050000003BPG@0dX5d0=:1M00000000P3QSF`500000080mjmc00<000000?N_L`3g[g<00P3g[g<0
0`000000mjmc0?N_L`03000000@0mjmc00@000000?N_L`3g[g<0mjmc0P0000030?N_L`050000003g
[g<000000?N_L`0000000`3g[g<01@000000mjmc0?N_L`3g[g<000000080mjmc00@000000?N_L`3g
[g<000000P3g[g<010000000mjmc00000000003o0?ooocH0oooo003o0?ooohH0oooo1@0000000`1M
8F/0000007`kM00207`kM0@0000000<0Tdih0000002UGGX00`2UGGX00`000000]6Yj0;AZNP020;AZ
NP0300000033MWT0000000<000000`3BPG@00`000000hHe/000000020>nIG0`000000P3g[g<00`00
0000mjmc0?N_L`030?N_L`<000000P3g[g<00`000000mjmc000000020?N_L`030000003g[g<00000
00<0mjmc00@000000?N_L`3g[g<000000`3g[g<01P000000mjmc0?N_L`000000mjmc000000<0mjmc
00<000000?ooo`3oool0o`3ooold0?ooo`00o`3ooon60?ooo`80000000H0;@1J0000001M8F/0GB5[
0000001l>g@20000000307`kM0000000Tdih0080Tdih00<000000:EMNP2UGGX00P2UGGX00`000000
]6Yj0;AZNP020;AZNP0600000033MWT0`gIi0<=fN@000000dX5d0P0000001P3BPG@000000>6=K03Q
SF`000000>nIG0<0000000<0mjmc0000003g[g<00`3g[g<00`000000mjmc0?N_L`020?N_L`030000
003g[g<0mjmc00<0mjmc00<000000?N_L`3g[g<00P3g[g<00`000000mjmc000000030?N_L`030000
003g[g<0mjmc0080mjmc00@000000?N_L`3g[g<000000`3g[g<300000080mjmc00D000000?N_L`3g
[g<0mjmc0000003o0?ooocH0oooo003o0?ooohH0oooo0P0000000`0]05X0000005dQJ`03000000<0
O3]d00D0000009=>N02CCWP0Tdih000000040:EMNP030000002dJWX0]6Yj0080]6Yj00D000000<=f
N@33MWT0`gIi000000030=:1M0<0000000<0hHe/0000003_VE`00`0000000`3g[g<000000?N_L`04
0?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g[g<00`0000050?N_L`030000003g[g<0
mjmc0080mjmc00T000000?N_L`3g[g<0mjmc0000003g[g<000000?N_L`0000000P3g[g<010000000
mjmc0000000000020?N_L`050000003g[g<0mjmc0?N_L`000000o`3ooolf0?ooo`00o`3ooon50?oo
o`8000000P0]05X20000000305dQJ`000000O3]d0080O3]d00<0000009=>N02CCWP00P2CCWP00`00
0000YEej0:EMNP020:EMNP030000002dJWX0]6Yj0080]6Yj00<000000<=fN@33MWT00P33MWT01P00
0000dX5d0=:1M03BPG@000000>6=K08000000P3_VE`2000000030?N_L`000000mjmc00@0mjmc00<0
00000?N_L`3g[g<00P3g[g<3000000<0mjmc00<000000?N_L`3g[g<00P3g[g<010000000mjmc0?N_
L`3g[g<2000000<0mjmc00@000000?N_L`00000000000`3g[g<010000000mjmc0?N_L`0000020?N_
L`040000003g[g<0mjmc00000?l0oooo=`3oool00?l0ooooQ@3oool500000080GB5[00D0000007`k
M01l>g@0O3]d0000000209=>N0l000000P33MWT01@000000dX5d0=:1M03BPG@000000080hHe/1@00
00020?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g[g<00P3g[g<00`000000mjmc0?N_
L`030?N_L`040000003g[g<0mjmc0?N_L`8000000`3g[g<01@000000mjmc0000003g[g<0000000<0
mjmc00D000000?N_L`3g[g<0mjmc000000020?N_L`040000003g[g<0mjmc00000080mjmc00<00000
0?ooo`3oool0o`3ooole0?ooo`00o`3ooon50?ooo`8000000P0]05X010000000GB5[05dQJ`000002
07`kM0@000000P2CCWP00`000000YEej0:EMNP020:EMNP030000002dJWX0]6Yj0080]6Yj00<00000
0<=fN@33MWT0100000020=:1M0040000003QSF`0hHe/00000080kiUL0`0000000`3g[g<000000?N_
L`040?N_L`030000003g[g<00000008000001@3g[g<010000000mjmc0?N_L`0000020?N_L`030000
003g[g<000000080mjmc00<000000?N_L`0000000`3g[g<200000080mjmc00<000000?N_L`3g[g<0
0`0000030?N_L`030000003oool0oooo0?l0oooo=@3oool00?l0ooooQ@3oool20000000302d0FP00
0000GB5[0080GB5[0`0000000`1l>g@0000009=>N00309=>N0030000002UGGX0YEej0080YEej00<0
00000;AZNP2dJWX00P2dJWX00`000000`gIi0<=fN@020<=fN@030000003BPG@00000008000000`3Q
SF`00`000000kiUL0000000;000000<0mjmc00<000000?N_L`3g[g<00`3g[g<2000000<0mjmc00<0
00000?N_L`0000000`3g[g<02@000000mjmc0?N_L`3g[g<000000?N_L`000000mjmc000000020?N_
L`040000003g[g<00000000000<0mjmc00<000000?ooo`3oool0o`3ooole0?ooo`00o`3ooon50?oo
o`80000000<0;@1J0000001M8F/00`00000307`kM0030000002CCWP0Tdih0080Tdih00<000000:EM
NP2UGGX00P2UGGX00`000000]6Yj0;AZNP020;AZNP0300000033MWT0`gIi0080`gIi00@000000=:1
M03BPG@0dX5d0`0000000`3QSF`000000>nIG003000000030?N_L`000000mjmc00@0mjmc00<00000
0?N_L`3g[g<00P3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0mjmc00<0mjmc00<00000
0?N_L`3g[g<00P3g[g<01@000000mjmc0?N_L`3g[g<000000080mjmc0P0000020?N_L`040000003g
[g<0mjmc000000<0mjmc00<000000?ooo`3oool0o`3ooole0?ooo`00o`3ooon40?ooo`8000000P0]
05X200000080GB5[00D0000007`kM01l>g@0O3]d0000000409=>N0030000002UGGX0YEej0080YEej
00<000000;AZNP2dJWX00P2dJWX00`000000`gIi0<=fN@020<=fN@050000003BPG@0dX5d0=:1M000
00000P3QSF`200000080kiUL0P0000020?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g
[g<00P3g[g<010000000mjmc0?N_L`3g[g<3000000D0mjmc00@000000?N_L`3g[g<0mjmc0P000002
0?N_L`030000003g[g<0mjmc0080mjmc00@000000?N_L`3g[g<000000P3g[g<200000080mjmc00<0
00000?ooo`3oool0o`3ooole0?ooo`00o`3ooon40?ooo`D000000P1M8F/00`000000O3]d07`kM002
07`kM0030000002CCWP0Tdih00l000000P33MWT00`000000dX5d0=:1M0020=:1M0030000003QSF`0
hHe/00D000000P3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0mjmc0080mjmc0`000002
0?N_L`030000003g[g<0mjmc0080mjmc0P0000030?N_L`050000003g[g<000000?N_L`0000000`3g
[g<200000080mjmc00<000000?N_L`3g[g<00P0000000`3g[g<000000?ooo`3o0?ooocL0oooo003o
0?oooh@0oooo0P00000202d0FP040000001M8F/0GB5[00000080O3]d1@00000209=>N0030000002U
GGX0YEej0080YEej00<000000;AZNP2dJWX00P2dJWX00`000000`gIi0<=fN@0500000080dX5d00@0
00000>6=K03QSF`000000P3_VE`2000000<0mjmc00<000000?N_L`3g[g<00P3g[g<00`000000mjmc
0?N_L`03000000D0mjmc00@000000?N_L`00000000000P3g[g<00`000000mjmc000000020?N_L`80
0000103g[g<01`000000mjmc0000003g[g<000000?N_L`0000000P3g[g<200000?l0oooo>03oool0
0?l0ooooQ03oool20000000302d0FP000000GB5[0080GB5[0`00000207`kM0030000002CCWP0Tdih
0080Tdih00<000000:EMNP2UGGX00P2UGGX00`000000]6Yj0;AZNP020;AZNP0300000033MWT0`gIi
0080`gIi00<000000=:1M03BPG@00`0000030>6=K0030000003_VE`0000000`000000P3g[g<00`00
0000mjmc0?N_L`030?N_L`800000103g[g<00`000000mjmc000000030?N_L`050000003g[g<0mjmc
0?N_L`0000000P3g[g<200000080mjmc00D000000?N_L`3g[g<0mjmc0000003o0?ooocP0oooo003o
0?oooh@0oooo0P0000000`0]05X0000005dQJ`03000000@0O3]d00D0000009=>N02CCWP0Tdih0000
00030:EMNPD000000P2dJWX00`000000`gIi0<=fN@020<=fN@030000003BPG@0dX5d0080dX5d0`00
00000`3QSF`000000>nIG002000000<0mjmc00<000000?N_L`3g[g<00P3g[g<00`000000mjmc0?N_
L`030?N_L`030000003g[g<0mjmc0080mjmc00<000000?N_L`3g[g<0103g[g<00`000000mjmc0?N_
L`020?N_L`050000003g[g<0mjmc0?N_L`0000000`3g[g<010000000mjmc0?N_L`0000030?N_L`03
0000003oool0oooo0?l0oooo=P3oool00?l0ooooP`3oool30000000302d0FP00000000000080GB5[
00D0000007`kM01l>g@0O3]d0000000409=>N0040000002UGGX0YEej0:EMNPD000000P2dJWX00`00
0000`gIi0<=fN@030<=fN@050000003BPG@0dX5d0=:1M00000000P3QSF`2000000040>nIG0000000
000000000080mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`020?N_L`040000003g
[g<0mjmc0?N_L`8000001P3g[g<02@000000mjmc0?N_L`3g[g<000000?N_L`000000mjmc00000004
0?N_L`040000003g[g<0mjmc00000080mjmc00<000000?ooo`3oool0o`3ooolg0?ooo`00o`3ooon3
0?ooo`D000000`1M8F/01@000000O3]d07`kM01l>g@000000080Tdih400000030<=fN@050000003B
PG@0dX5d0=:1M00000000`3QSF`500000080mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc
0?N_L`030?N_L`<000000P3g[g<00`000000mjmc0?N_L`020?N_L`8000000`3g[g<01@000000mjmc
0000003g[g<0000000<0mjmc0P0000020?N_L`040000003g[g<0mjmc00000?l0oooo>@3oool00?l0
ooooP`3oool30000000302d0FP000000GB5[0080GB5[00<0000007`kM01l>g@01000000209=>N003
0000002UGGX0YEej00<0YEej00<000000;AZNP2dJWX00P2dJWX00`000000`gIi0<=fN@0500000080
dX5d00T000000>6=K03QSF`0hHe/0000003_VE`000000?BN>P0000000`3g[g<00`000000mjmc0?N_
L`020?N_L`030000003g[g<0mjmc0080mjmc0P0000040?N_L`030000003g[g<0mjmc008000000P3g
[g<00`000000mjmc000000030?N_L`030000003g[g<0mjmc0080mjmc00@000000?N_L`0000000000
0`3g[g<00`000000oooo0?ooo`3o0?ooocL0oooo003o0?oooh<0oooo0`0000000`0]05X0000005dQ
J`0205dQJ`<0000000<0O3]d0000002CCWP00`2CCWP00`000000YEej0:EMNP030:EMNP030000002d
JWX0]6Yj0080]6Yj00<000000<=fN@33MWT00`33MWT00`000000dX5d00000002000000<0hHe/00<0
00000>nIG0000000100000000`3g[g<000000?N_L`040?N_L`060000003g[g<000000000003g[g<0
00001@3g[g<2000000@0mjmc00<000000?N_L`0000000`3g[g<01@000000mjmc0?N_L`3g[g<00000
0080mjmc0P0000020?N_L`030000003oool0oooo0?l0oooo>03oool00?l0ooooP`3oool300000003
02d0FP000000GB5[00<000000`1l>g@00`000000Tdih09=>N00209=>N0030000002UGGX0YEej00<0
YEej00<000000;AZNP2dJWX00`2dJWX00`000000`gIi0<=fN@020<=fN@040000003BPG@0dX5d0=:1
M0<0000000<0hHe/0000003_VE`00`0000020?N_L`T000000`3g[g<00`000000mjmc0?N_L`030?N_
L`030000003g[g<0mjmc00@0mjmc00@000000?N_L`3g[g<0mjmc0P0000030?N_L`050000003g[g<0
mjmc0?N_L`0000000P3g[g<00`000000oooo0?ooo`3o0?ooocP0oooo003o0?oooh80oooo0`000002
02d0FP8000000P1M8F/01@000000O3]d07`kM01l>g@0000000@0Tdih00@000000:EMNP2UGGX0YEej
1@0000030;AZNP0300000033MWT0`gIi0080`gIi00D000000=:1M03BPG@0dX5d000000020>6=K080
00000P3_VE`300000080mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`020?N_L`03
0000003g[g<0mjmc0080mjmc0P0000060?N_L`090000003g[g<0mjmc0?N_L`000000mjmc0000003g
[g<0000000@0mjmc00@000000?N_L`3g[g<00000o`3ooolj0?ooo`00o`3ooon20?ooo`<0000000<0
;@1J0000000000000P1M8F/00`000000O3]d07`kM00207`kM0030000002CCWP0Tdih014000000P33
MWT00`000000dX5d0=:1M0020=:1M0030000003QSF`0hHe/00H000000P3g[g<00`000000mjmc0?N_
L`030?N_L`030000003g[g<0mjmc00<0mjmc00@000000?N_L`00000000000P3g[g<00`000000mjmc
0?N_L`020?N_L`8000000P3g[g<01P000000mjmc0?N_L`000000mjmc000000<0mjmc00D000000?N_
L`000000mjmc0000003o0?ooocX0oooo003o0?oooh80oooo100000001@0]05X0000005dQJ`1M8F/0
00000080O3]d1@0000000`3;T9H000000;j5UP030;j5UPH00000103g[g<600000080dX5d00@00000
0>6=K03QSF`000000P3_VE`3000000<0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_
L`020?N_L`800000103g[g<01`000000mjmc0?N_L`3g[g<000000?N_L`0000000P3g[g<01@000000
mjmc0?N_L`3g[g<0000000@0mjmc00@000000?N_L`0000000000o`3ooolk0?ooo`00o`3ooon20?oo
o`050000000003H0000002d0FP0000000`1M8F/300000080f9bE00<000000<^@UP00000010000002
0;j5UPD0000000<0mjmc0000000000000P3g[g<00`000000mjmc0?N_L`0200000004089FU@000000
0000000000<0hHe/00<000000>nIG00000000P0000030?N_L`030000003g[g<0mjmc00<0mjmc00<0
00000?N_L`3g[g<00`0000050?N_L`040000003g[g<0mjmc000000<0mjmc0P0000040?N_L`030000
003g[g<0mjmc0080mjmc00@000000?N_L`3g[g<00000o`3ooolk0?ooo`00o`3ooon20?ooo`<00000
00<0;@1J0000001M8F/00P0000000`3VZY<000000=RLU@020=RLU@050000003;T9H0bi2F0<^@UP00
00000P2nQIH7000000<0mjmc00<000000?N_L`0000000P3g[g<00`2EI9H00000089FU@02089FU@<0
000000<0hHe/0000003_VE`03`0000020?N_L`030000003g[g<0mjmc00@0mjmc0P0000040?N_L`80
00000`3g[g<00`000000mjmc000000020?N_L`050000003g[g<0mjmc0?N_L`000000o`3ooolk0?oo
o`00o`3ooon20?ooo`040000000003H0000002d0FP<000000P3VZY<01@000000f9bE0=RLU@3HW9D0
000000<0bi2F00<000000;j5UP2nQIH00P2nQIH5000000@0mjmc0P0000020?N_L`0309ETUP000000
PUJE0080PUJE1@0000020>nIG08000000`3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0
mjmc00<0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0
mjmc0080mjmc00<000000?N_L`0000000P3g[g<010000000mjmc0?N_L`00003o0?oooc`0oooo003o
0?oooh40oooo0`0000001@0]05X000000?BjS@000000iZZC00<000000`3HW9D01@000000bi2F0<^@
UP3;T9H0000000@0_XFF1@0000050?N_L`050000003g[g<0mjmc09ETUP0000000`22EYD01@000000
J4BB06Q4TP000000@bV=00D000000P3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0mjmc
00<0mjmc00@000000?N_L`3g[g<0mjmc0`0000040?N_L`8000000`3g[g<01`000000mjmc0?N_L`3g
[g<000000?N_L`0000000P3g[g<00`000000oooo0?ooo`3o0?ooocX0oooo003o0?oooh40oooo1000
00020?BjS@040000003VZY<0iZZC0>JZT`<0000000<0f9bE0000003;T9H00P3;T9H00`000000_XFF
0;j5UP020;j5UPD000001@3g[g<30000000309ETUP000000PUJE00<000000P1XA9800`000000@bV=
04<YS@0400000080mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`040?N_L`<00000
0`3g[g<010000000mjmc0?N_L`0000020?N_L`040000003g[g<0mjmc000000<0mjmc0P0000030?N_
L`030000003oool0oooo0?l0oooo>P3oool00?l0ooooP@3oool01P000000000f000000000000m;Z=
000000@0iZZC00<000000=RLU@3HW9D00`0000020<^@UP030000002nQIH0_XFF0080_XFF1P000004
0?N_L`030000003g[g<0mjmc00<000000P22EYD020000000J4BB06Q4TP1XA980000004<YS@000000
101m0P0000030?N_L`030000003g[g<0mjmc00<0mjmc00<000000?N_L`3g[g<00P3g[g<2000000D0
mjmc00@000000?N_L`3g[g<000000P3g[g<00`000000mjmc000000050?N_L`040000003g[g<0mjmc
00000?l0oooo?@3oool00?l0ooooP@3oool2000000040?o<O`0000000000000000<0iZZC00<00000
0=RLU@3HW9D00P3HW9D00`000000bi2F0000000400000080_XFF1@0000000`3g[g<0000000000002
0?N_L`050000003g[g<0mjmc09ETUP0000000`22EYD010000000J4BB06Q4TP1XA9830000000300@0
O@000000000000<0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc00000002000000030?N_
L`000000mjmc00D0mjmc0P0000040?N_L`800000103g[g<200000080mjmc00<000000?ooo`3oool0
o`3ooolk0?ooo`00o`3ooon10?ooo`80000000@0olao0000003d^Xd000000`3VZY<00`000000f9bE
0=RLU@020=RLU@050000003;T9H0bi2F0<^@UP0000000P2nQIH7000000<0mjmc00<000000?N_L`00
00000P3g[g<00`2EI9H00000089FU@03089FU@060000001XA980J4BB00000013:Hd000000P0407d<
000000D0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0
mjmc00<0mjmc00D000000?N_L`000000mjmc0000003o0?ooocd0oooo003o0?oooh00oooo10000002
0?BjS@<0000000<0iZZC0000003HW9D00P3HW9D00`000000bi2F0<^@UP020<^@UP030000002nQIH0
_XFF0080_XFF1@0000040?N_L`8000000P3g[g<209ETUP0400000022EYD0PUJE089FU@@000000P13
:Hd400000080mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`040?N_L`040000003g
[g<0mjmc0?N_L`<00000103g[g<2000000@0mjmc00<000000?N_L`3g[g<00P00003o0?oooch0oooo
003o0?oooh00oooo00@000000?3>F@00000000000P3d^Xd00`000000iZZC0>JZT`02000000<0f9bE
00<000000<^@UP3;T9H00P3;T9H00`000000_XFF0;j5UP020;j5UPH00000103g[g<00`000000mjmc
0?N_L`0209ETUP0300000022EYD0PUJE008000000P1XA9800`000000@bV=04<YS@0400000080mjmc
00<000000?N_L`3g[g<0103g[g<00`000000mjmc0?N_L`040?N_L`<000000`3g[g<010000000mjmc
0?N_L`0000020?N_L`040000003g[g<0mjmc000000@0mjmc00<000000?ooo`3oool0o`3oooll0?oo
o`00o`3ooon00?ooo`040000003`cUT0000000000080m;Z=00@000000>JZT`3VZY<0iZZC0`000000
0`3HW9D000000<^@UP030<^@UP030000002nQIH0_XFF0080_XFF1@0000000`3g[g<000000?N_L`02
0?N_L`<000000P2EI9H300000003089FU@000000J4BB0080J4BB00@0000004<YS@000000101m0P00
00020?N_L`030000003g[g<0mjmc00@0mjmc00<000000?N_L`3g[g<00`3g[g<2000000D0mjmc00@0
00000?N_L`3g[g<000000P3g[g<00`000000mjmc000000040?N_L`030000003oool0oooo0?l0oooo
?@3oool00?l0ooooP03oool2000000030?o<O`0000000000008000000`3VZY<00`000000f9bE0=RL
U@0400000080bi2F00<000000;j5UP2nQIH00P2nQIH500000080mjmc00@000000?N_L`3g[g<00000
0P3g[g<00`000000UFBF00000003089FU@040000001XA980J4BB06Q4TP<000000P0407d01@000000
mjmc0?N_L`3g[g<0000000H0mjmc00<000000?N_L`0000000P0000000`3g[g<000000?N_L`050?N_
L`800000103g[g<2000000@0mjmc00<000000?ooo`3oool0o`3ooolm0?ooo`00o`3ooon10?ooo`03
0000003oc7l000000080m;Z=00@000000>JZT`3VZY<00000103HW9D00`000000bi2F0<^@UP0<0000
00<0mjmc0P0000000`3g[g<000000?N_L`0209ETUP0500000022EYD0PUJE089FU@0000000`1XA980
0`000000@bV=0000000200@0O@<0000000<0mjmc0000003g[g<00P3g[g<5000000@0mjmc00<00000
0?N_L`3g[g<0103g[g<00`000000mjmc0?N_L`030?N_L`030000003g[g<0mjmc0080mjmc00<00000
0?ooo`3oool0o`3oooln0?ooo`00o`3ooon10?ooo`8000000`3d^Xd2000000030>JZT`000000f9bE
00<0f9bE00<000000<^@UP3;T9H00P3;T9H00`000000_XFF0;j5UP020;j5UPD000001@3g[g<20000
0080mjmc00<0UFBF00000022EYD00P22EYD00`000000J4BB0000000200000080@bV=00<0000000@0
O@0000000P3g[g<5000000<0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`020?N_
L`<00000103g[g<2000000<0mjmc00<000000?ooo`3oool0o`3ooolo0?ooo`00o`3ooon10?ooo`80
00000`3d^Xd010000000iZZC0000000000040=RLU@030000003;T9H0bi2F0080bi2F00<000000;j5
UP2nQIH00P2nQIH5000000H0mjmc00D000000?N_L`3g[g<0UFBF00000003089FU@8000000P1XA980
0`000000@bV=04<YS@02000000@0mjmc00<000000?N_L`3g[g<0103g[g<00`000000mjmc0?N_L`04
0?N_L`040000003g[g<0mjmc000000<0mjmc00@000000?N_L`3g[g<000000P3g[g<010000000mjmc
0?N_L`00003o0?oood40oooo003o0?oooh80oooo00@000000?BjS@3d^Xd000000`3VZY<300000080
f9bE00D000000<^@UP3;T9H0bi2F000000050;j5UPH000001@3g[g<30000000309ETUP000000PUJE
00<000000`1XA98010000000@bV=04<YS@0000060?N_L`030000003g[g<0mjmc00<0mjmc00<00000
0?N_L`3g[g<0103g[g<3000000@0mjmc00@000000?N_L`3g[g<000000P3g[g<00`000000mjmc0000
003o0?oood80oooo003o0?oooh80oooo00@000000?BjS@3d^Xd000000`3VZY<00`000000f9bE0=RL
U@0400000080bi2F00<000000;j5UP2nQIH00`2nQIH8000000<0mjmc00<000000?N_L`3g[g<00`00
0002089FU@030000001XA980J4BB0080J4BB0`0000060?N_L`030000003g[g<0mjmc00@0mjmc00<0
00000?N_L`3g[g<00P3g[g<2000000L0mjmc0P0000040?N_L`800000o`3ooom20?ooo`00o`3ooon3
0?ooo`<000000`3VZY<00`000000f9bE0=RLU@020=RLU@030000003;T9H0000000@000000`2nQIH6
00000080Y72F00@000000?N_L`3g[g<000000P3g[g<00`2EI9H00000089FU@02089FU@030000001X
A980J4BB0080J4BB1P0000040?N_L`030000003g[g<0mjmc00<0mjmc00<000000?N_L`0000000P00
00000`3g[g<000000?N_L`060?N_L`030000003g[g<0mjmc00<0mjmc00<000000?ooo`3oool0o`3o
oom10?ooo`00o`3ooon50?ooo`050000003VZY<0iZZC0>JZT`000000103HW9D01@000000bi2F0<^@
UP3;T9H000000080_XFF2`000000102TL9H000000?N_L`0000020?N_L`0309ETUP000000PUJE00<0
PUJE00L0000006Q4TP1XA980J4BB0000003g[g<0000000<0mjmc300000050?N_L`030000003g[g<0
mjmc0080mjmc0`0000040?N_L`030000003oool0oooo0?l0oooo@P3oool00?l0ooooQP3oool20000
00030>JZT`000000f9bE0080f9bE00<000000<^@UP3;T9H00P3;T9H00`000000_XFF0;j5UP030;j5
UPH00000102TL9H200000080mjmc00<0UFBF00000022EYD00`22EYD010000000J4BB000000000002
0?N_L`030000003g[g<0mjmc00D0mjmc00<000000?N_L`3g[g<00`3g[g<00`000000mjmc0?N_L`04
0?N_L`050000003g[g<0mjmc0?N_L`0000000P3g[g<01@000000mjmc0?N_L`3g[g<000000?l0oooo
A@3oool00?l0ooooR03oool2000000<0f9bE00<000000<^@UP3;T9H00P3;T9H00`000000_XFF0;j5
UP030;j5UPH00000102TL9H200000080mjmc0P2EI9H010000000PUJE089FU@22EYD2000000@0mjmc
00<000000?N_L`3g[g<01@3g[g<00`000000mjmc0?N_L`040?N_L`030000003g[g<0mjmc00@0mjmc
0`0000030?N_L`040000003g[g<0mjmc00000?l0ooooAP3oool00?l0ooooRP3oool2000000030=RL
U@000000bi2F00<0bi2F00<000000;j5UP2nQIH00`2nQIH6000000D0Y72F0`00000209ETUP040000
0022EYD0000000000080mjmc0P0000030?N_L`030000003g[g<0mjmc00@0mjmc00<000000?N_L`3g
[g<0103g[g<00`000000mjmc0?N_L`040?N_L`030000003g[g<0mjmc00@0mjmc00<000000?N_L`00
0000o`3ooom60?ooo`00o`3ooon<0?ooo`@000000P3;T9H00`000000_XFF0;j5UP030;j5UPH00000
1@2TL9H00`000000UFBF00000004000000030?N_L`000000mjmc00<0mjmc0P0000000`3g[g<00000
0?N_L`060?N_L`030000003g[g<0mjmc00<0mjmc00<000000?N_L`3g[g<00P3g[g<3000000H0mjmc
0P00003o0?ooodL0oooo003o0?oooi00oooo5@0000020?ooo`8000000`3g[g<00`000000mjmc0?N_
L`030?N_L`D00000103g[g<00`000000mjmc0?N_L`040?N_L`040000003g[g<00000000000<0mjmc
00<000000?N_L`3g[g<00`3g[g<00`000000oooo0?ooo`3o0?ooodH0oooo003o0?oooiP0oooo1@00
000<0?ooo`80000000<0mjmc0000003g[g<01@3g[g<010000000mjmc0?N_L`3g[g<=000000D0mjmc
00<000000?N_L`3g[g<00P3g[g<00`000000oooo0?ooo`3o0?ooodL0oooo003o0?oooiP0oooo1@00
000>0?ooo`8000001P3g[g<00`000000mjmc0?N_L`050?N_L`030000003g[g<0mjmc00@0mjmc00<0
00000?N_L`3g[g<0103g[g<00`000000mjmc0?N_L`0200000?l0ooooBP3oool00?l0ooooV03oool5
00000100oooo0P0000040?N_L`030000003g[g<0mjmc00D0mjmc00<000000?N_L`3g[g<0103g[g<0
0`000000mjmc0?N_L`050?N_L`800000o`3ooom<0?ooo`00o`3ooonH0?ooo`D000004P3oool20000
00<0mjmc00<000000?N_L`3g[g<0103g[g<00`000000mjmc0?N_L`050?N_L`030000003g[g<0mjmc
00<0mjmc0P00003o0?ooodd0oooo003o0?oooiP0oooo1@00000D0?ooo`80000000<0mjmc0000003g
[g<01P3g[g<00`000000mjmc0?N_L`040?N_L`030000003g[g<0000000<00000o`3ooom?0?ooo`00
o`3ooonH0?ooo`D000005P3oool5000000@0mjmc00@000000?N_L`3g[g<0mjmc1@00003o0?oooe<0
oooo003o0?oooiP0oooo1@00000K0?ooo`P00000o`3ooomH0?ooo`00o`3ooonH0?ooo`D00000o`3o
oomk0?ooo`00o`3ooonH0?ooo`D00000o`3ooomk0?ooo`00o`3ooonH0?ooo`D00000o`3ooomk0?oo
o`00o`3ooonH0?ooo`D00000o`3ooomk0?ooo`00o`3ooonH0?ooo`D00000o`3ooomk0?ooo`00o`3o
oonH0?ooo`D00000o`3ooomk0?ooo`00o`3ooonH0?ooo`D00000o`3ooomk0?ooo`00o`3ooooo0?oo
ool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3o
oooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?oo
o`00o`3ooonG0?ooo`030>ZjLP000000000000<0000000<009_D0?ooo`3oool0o`3ooomh0?ooo`00
o`3ooonH0?ooo`060;Yb001b^^X0oooo0?ooo`3oe9/009_Do`3ooomj0?ooo`00o`3ooonI0?ooo`03
0;Yb0000Vm@0oooo0?l0ooooO03oool00?l0ooooVP3oool00`3DV`0007:j0?ooo`3o0?ooog/0oooo
003o0?oooiL0oooo00H0onZj07:Ke03oool0oooo0>ZjLP00L[[o0?ooog/0oooo003o0?oooiL0oooo
00<0onZj0780000000000`0000000`1b^^X0oooo0?ooo`3o0?ooogP0oooo003o0?ooool0ooooo`3o
oolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0
ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o
0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0
oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo
0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0oooo
o`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool0
0?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo
6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?oo
ool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3o
oooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?oo
o`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3o
oolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0
ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o
0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0
oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo
0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0oooo
o`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool0
0?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo
6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?oo
ool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3o
oooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?oo
o`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3o
oolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0
ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o
0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0
oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo
0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0oooo
o`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool0
0?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo
6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?oo
ool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?ooo`00o`3o
oooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3ooolI0?oo
o`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0ooooo`3o
oolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o0?ooool0
ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0oooo003o
0?ooool0ooooo`3ooolI0?ooo`00o`3ooooo0?ooool0oooo6@3oool00?l0ooooo`3ooooo0?oooaT0
oooo003o0?ooool0ooooo`3ooolI0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 789.875}, {605.563, 0}} -> {-0.129689, \
-4.65453*^-06, 0.00230589, 0.00230589}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
%%ImageSize: 527.25 404.375 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.12828e-017 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.966 .687 .452 r
.61863 .55097 m .62157 .54995 L .61233 .52311 L p F P
0 g
s
.966 .687 .452 r
.62157 .54995 m .61863 .55097 L .62662 .57731 L p F P
0 g
s
.966 .687 .452 r
.62662 .57731 m .62982 .57713 L .62157 .54995 L p F P
0 g
s
.966 .687 .452 r
.62982 .57713 m .62662 .57731 L .63356 .60377 L p F P
0 g
s
.966 .687 .452 r
.63356 .60377 m .63699 .60443 L .62982 .57713 L p F P
0 g
s
.966 .687 .452 r
.60967 .52496 m .61233 .52311 L .60216 .49683 L p F P
0 g
s
.966 .687 .452 r
.61233 .52311 m .60967 .52496 L .61863 .55097 L p F P
0 g
s
.966 .687 .452 r
.63699 .60443 m .63356 .60377 L .63941 .63013 L p F P
0 g
s
.966 .687 .452 r
.63941 .63013 m .64304 .63164 L .63699 .60443 L p F P
0 g
s
.966 .687 .452 r
.59981 .4995 m .60216 .49683 L .59113 .47132 L p F P
0 g
s
.966 .687 .452 r
.60216 .49683 m .59981 .4995 L .60967 .52496 L p F P
0 g
s
.966 .687 .452 r
.61566 .552 m .61863 .55097 L .60967 .52496 L p F P
0 g
s
.966 .687 .452 r
.61863 .55097 m .61566 .552 L .62339 .5775 L p F P
0 g
s
.966 .687 .452 r
.62339 .5775 m .62662 .57731 L .61863 .55097 L p F P
0 g
s
.966 .687 .452 r
.62662 .57731 m .62339 .5775 L .63011 .6031 L p F P
0 g
s
.966 .687 .452 r
.63011 .6031 m .63356 .60377 L .62662 .57731 L p F P
0 g
s
.966 .687 .452 r
.60699 .52683 m .60967 .52496 L .59981 .4995 L p F P
0 g
s
.966 .687 .452 r
.60967 .52496 m .60699 .52683 L .61566 .552 L p F P
0 g
s
.966 .687 .452 r
.64304 .63164 m .63941 .63013 L .6441 .65618 L p F P
0 g
s
.966 .687 .452 r
.6441 .65618 m .64789 .65853 L .64304 .63164 L p F P
0 g
s
.966 .687 .452 r
.63356 .60377 m .63011 .6031 L .63576 .62861 L p F P
0 g
s
.966 .687 .452 r
.63576 .62861 m .63941 .63013 L .63356 .60377 L p F P
0 g
s
.966 .687 .452 r
.58912 .47479 m .59113 .47132 L .57934 .44679 L p F P
0 g
s
.966 .687 .452 r
.59113 .47132 m .58912 .47479 L .59981 .4995 L p F P
0 g
s
.966 .687 .452 r
.59744 .50219 m .59981 .4995 L .58912 .47479 L p F P
0 g
s
.966 .687 .452 r
.59981 .4995 m .59744 .50219 L .60699 .52683 L p F P
0 g
s
.966 .687 .452 r
.61267 .55304 m .61566 .552 L .60699 .52683 L p F P
0 g
s
.966 .687 .452 r
.61566 .552 m .61267 .55304 L .62014 .57768 L p F P
0 g
s
.966 .687 .452 r
.62014 .57768 m .62339 .5775 L .61566 .552 L p F P
0 g
s
.966 .687 .452 r
.62339 .5775 m .62014 .57768 L .62663 .60243 L p F P
0 g
s
.966 .687 .452 r
.62663 .60243 m .63011 .6031 L .62339 .5775 L p F P
0 g
s
.966 .687 .452 r
.60429 .52871 m .60699 .52683 L .59744 .50219 L p F P
0 g
s
.966 .687 .452 r
.60699 .52683 m .60429 .52871 L .61267 .55304 L p F P
0 g
s
.966 .687 .452 r
.63941 .63013 m .63576 .62861 L .64028 .6538 L p F P
0 g
s
.966 .687 .452 r
.64028 .6538 m .6441 .65618 L .63941 .63013 L p F P
0 g
s
.966 .687 .452 r
.57934 .44679 m .57768 .45105 L .58912 .47479 L p F P
0 g
s
.966 .687 .452 r
.58709 .47829 m .58912 .47479 L .57768 .45105 L p F P
0 g
s
.966 .687 .452 r
.58912 .47479 m .58709 .47829 L .59744 .50219 L p F P
0 g
s
.966 .687 .452 r
.64789 .65853 m .6441 .65618 L .64757 .68168 L p F P
0 g
s
.966 .687 .452 r
.64757 .68168 m .6515 .68488 L .64789 .65853 L p F P
0 g
s
.966 .687 .452 r
.63011 .6031 m .62663 .60243 L .63208 .62708 L p F P
0 g
s
.966 .687 .452 r
.63208 .62708 m .63576 .62861 L .63011 .6031 L p F P
0 g
s
.966 .687 .452 r
.59505 .5049 m .59744 .50219 L .58709 .47829 L p F P
0 g
s
.966 .687 .452 r
.59744 .50219 m .59505 .5049 L .60429 .52871 L p F P
0 g
s
.966 .687 .452 r
.57768 .45105 m .57934 .44679 L .56686 .42348 L p F P
0 g
s
.966 .687 .452 r
.60966 .55409 m .61267 .55304 L .60429 .52871 L p F P
0 g
s
.966 .687 .452 r
.61267 .55304 m .60966 .55409 L .61687 .57787 L p F P
0 g
s
.966 .687 .452 r
.61687 .57787 m .62014 .57768 L .61267 .55304 L p F P
0 g
s
.966 .687 .452 r
.62014 .57768 m .61687 .57787 L .62312 .60175 L p F P
0 g
s
.966 .687 .452 r
.62312 .60175 m .62663 .60243 L .62014 .57768 L p F P
0 g
s
.966 .687 .452 r
.60157 .53061 m .60429 .52871 L .59505 .5049 L p F P
0 g
s
.966 .687 .452 r
.60429 .52871 m .60157 .53061 L .60966 .55409 L p F P
0 g
s
.966 .687 .452 r
.63576 .62861 m .63208 .62708 L .63643 .65142 L p F P
0 g
s
.966 .687 .452 r
.63643 .65142 m .64028 .6538 L .63576 .62861 L p F P
0 g
s
.966 .687 .452 r
.6441 .65618 m .64028 .6538 L .64362 .67847 L p F P
0 g
s
.966 .687 .452 r
.64362 .67847 m .64757 .68168 L .6441 .65618 L p F P
0 g
s
.966 .687 .452 r
.57768 .45105 m .57602 .45533 L .58709 .47829 L p F P
0 g
s
.966 .687 .452 r
.58504 .48181 m .58709 .47829 L .57602 .45533 L p F P
0 g
s
.966 .687 .452 r
.58709 .47829 m .58504 .48181 L .59505 .5049 L p F P
0 g
s
.966 .687 .452 r
.62663 .60243 m .62312 .60175 L .62837 .62553 L p F P
0 g
s
.966 .687 .452 r
.62837 .62553 m .63208 .62708 L .62663 .60243 L p F P
0 g
s
.966 .687 .452 r
.59265 .50764 m .59505 .5049 L .58504 .48181 L p F P
0 g
s
.966 .687 .452 r
.59505 .5049 m .59265 .50764 L .60157 .53061 L p F P
0 g
s
.966 .687 .452 r
.56686 .42348 m .56559 .42849 L .57768 .45105 L p F P
0 g
s
.966 .687 .452 r
.57602 .45533 m .57768 .45105 L .56559 .42849 L p F P
0 g
s
.966 .687 .452 r
.60663 .55514 m .60966 .55409 L .60157 .53061 L p F P
0 g
s
.966 .687 .452 r
.60966 .55409 m .60663 .55514 L .61357 .57806 L p F P
0 g
s
.966 .687 .452 r
.61357 .57806 m .61687 .57787 L .60966 .55409 L p F P
0 g
s
.966 .687 .452 r
.6515 .68488 m .64757 .68168 L .64979 .70643 L p F P
0 g
s
.966 .687 .452 r
.64979 .70643 m .65381 .71045 L .6515 .68488 L p F P
0 g
s
.966 .687 .452 r
.61687 .57787 m .61357 .57806 L .61959 .60107 L p F P
0 g
s
.966 .687 .452 r
.61959 .60107 m .62312 .60175 L .61687 .57787 L p F P
0 g
s
.966 .687 .452 r
.59883 .53252 m .60157 .53061 L .59265 .50764 L p F P
0 g
s
.966 .687 .452 r
.60157 .53061 m .59883 .53252 L .60663 .55514 L p F P
0 g
s
.966 .687 .452 r
.63208 .62708 m .62837 .62553 L .63256 .64901 L p F P
0 g
s
.966 .687 .452 r
.63256 .64901 m .63643 .65142 L .63208 .62708 L p F P
0 g
s
.966 .687 .452 r
.56559 .42849 m .56686 .42348 L .5538 .40158 L p F P
0 g
s
.966 .687 .452 r
.64028 .6538 m .63643 .65142 L .63964 .67523 L p F P
0 g
s
.966 .687 .452 r
.63964 .67523 m .64362 .67847 L .64028 .6538 L p F P
0 g
s
.966 .687 .452 r
.57602 .45533 m .57434 .45965 L .58504 .48181 L p F P
0 g
s
.966 .687 .452 r
.58299 .48536 m .58504 .48181 L .57434 .45965 L p F P
0 g
s
.966 .687 .452 r
.58504 .48181 m .58299 .48536 L .59265 .50764 L p F P
0 g
s
.966 .687 .452 r
.62312 .60175 m .61959 .60107 L .62464 .62398 L p F P
0 g
s
.966 .687 .452 r
.62464 .62398 m .62837 .62553 L .62312 .60175 L p F P
0 g
s
.966 .687 .452 r
.56559 .42849 m .56431 .43353 L .57602 .45533 L p F P
0 g
s
.966 .687 .452 r
.57434 .45965 m .57602 .45533 L .56431 .43353 L p F P
0 g
s
.966 .687 .452 r
.59023 .51039 m .59265 .50764 L .58299 .48536 L p F P
0 g
s
.966 .687 .452 r
.59265 .50764 m .59023 .51039 L .59883 .53252 L p F P
0 g
s
.966 .687 .452 r
.64757 .68168 m .64362 .67847 L .64574 .70238 L p F P
0 g
s
.966 .687 .452 r
.64574 .70238 m .64979 .70643 L .64757 .68168 L p F P
0 g
s
.966 .687 .452 r
.60357 .5562 m .60663 .55514 L .59883 .53252 L p F P
0 g
s
.966 .687 .452 r
.60663 .55514 m .60357 .5562 L .61025 .57825 L p F P
0 g
s
.966 .687 .452 r
.61025 .57825 m .61357 .57806 L .60663 .55514 L p F P
0 g
s
.966 .687 .452 r
.61357 .57806 m .61025 .57825 L .61604 .60038 L p F P
0 g
s
.966 .687 .452 r
.61604 .60038 m .61959 .60107 L .61357 .57806 L p F P
0 g
s
.966 .687 .452 r
.5538 .40158 m .55293 .40731 L .56559 .42849 L p F P
0 g
s
.966 .687 .452 r
.56431 .43353 m .56559 .42849 L .55293 .40731 L p F P
0 g
s
.966 .687 .452 r
.59606 .53444 m .59883 .53252 L .59023 .51039 L p F P
0 g
s
.966 .687 .452 r
.59883 .53252 m .59606 .53444 L .60357 .5562 L p F P
0 g
s
.966 .687 .452 r
.62837 .62553 m .62464 .62398 L .62866 .64659 L p F P
0 g
s
.966 .687 .452 r
.62866 .64659 m .63256 .64901 L .62837 .62553 L p F P
0 g
s
.966 .687 .452 r
.63643 .65142 m .63256 .64901 L .63564 .67198 L p F P
0 g
s
.966 .687 .452 r
.63564 .67198 m .63964 .67523 L .63643 .65142 L p F P
0 g
s
.966 .687 .452 r
.57434 .45965 m .57265 .46399 L .58299 .48536 L p F P
0 g
s
.966 .687 .452 r
.58091 .48894 m .58299 .48536 L .57265 .46399 L p F P
0 g
s
.966 .687 .452 r
.58299 .48536 m .58091 .48894 L .59023 .51039 L p F P
0 g
s
.966 .687 .452 r
.56431 .43353 m .56302 .4386 L .57434 .45965 L p F P
0 g
s
.966 .687 .452 r
.57265 .46399 m .57434 .45965 L .56302 .4386 L p F P
0 g
s
.966 .687 .452 r
.61959 .60107 m .61604 .60038 L .62088 .62242 L p F P
0 g
s
.966 .687 .452 r
.62088 .62242 m .62464 .62398 L .61959 .60107 L p F P
0 g
s
.966 .687 .452 r
.58779 .51316 m .59023 .51039 L .58091 .48894 L p F P
0 g
s
.966 .687 .452 r
.59023 .51039 m .58779 .51316 L .59606 .53444 L p F P
0 g
s
.966 .687 .452 r
.64362 .67847 m .63964 .67523 L .64166 .69831 L p F P
0 g
s
.966 .687 .452 r
.64166 .69831 m .64574 .70238 L .64362 .67847 L p F P
0 g
s
.966 .687 .452 r
.65381 .71045 m .64979 .70643 L .6507 .73018 L p F P
0 g
s
.966 .687 .452 r
.6507 .73018 m .65478 .73501 L .65381 .71045 L p F P
0 g
s
.966 .687 .452 r
.55293 .40731 m .55206 .41308 L .56431 .43353 L p F P
0 g
s
.966 .687 .452 r
.56302 .4386 m .56431 .43353 L .55206 .41308 L p F P
0 g
s
.966 .687 .452 r
.60049 .55727 m .60357 .5562 L .59606 .53444 L p F P
0 g
s
.966 .687 .452 r
.60357 .5562 m .60049 .55727 L .6069 .57844 L p F P
0 g
s
.966 .687 .452 r
.6069 .57844 m .61025 .57825 L .60357 .5562 L p F P
0 g
s
.966 .687 .452 r
.55293 .40731 m .5538 .40158 L .54025 .38132 L p F P
0 g
s
.966 .687 .452 r
.61025 .57825 m .6069 .57844 L .61245 .59969 L p F P
0 g
s
.966 .687 .452 r
.61245 .59969 m .61604 .60038 L .61025 .57825 L p F P
0 g
s
.966 .687 .452 r
.59328 .53638 m .59606 .53444 L .58779 .51316 L p F P
0 g
s
.966 .687 .452 r
.59606 .53444 m .59328 .53638 L .60049 .55727 L p F P
0 g
s
.966 .687 .452 r
.62464 .62398 m .62088 .62242 L .62474 .64415 L p F P
0 g
s
.966 .687 .452 r
.62474 .64415 m .62866 .64659 L .62464 .62398 L p F P
0 g
s
.966 .687 .452 r
.63256 .64901 m .62866 .64659 L .63161 .6687 L p F P
0 g
s
.966 .687 .452 r
.63161 .6687 m .63564 .67198 L .63256 .64901 L p F P
0 g
s
.966 .687 .452 r
.57265 .46399 m .57095 .46836 L .58091 .48894 L p F P
0 g
s
.966 .687 .452 r
.57882 .49254 m .58091 .48894 L .57095 .46836 L p F P
0 g
s
.966 .687 .452 r
.58091 .48894 m .57882 .49254 L .58779 .51316 L p F P
0 g
s
.966 .687 .452 r
.56302 .4386 m .56172 .44371 L .57265 .46399 L p F P
0 g
s
.966 .687 .452 r
.57095 .46836 m .57265 .46399 L .56172 .44371 L p F P
0 g
s
.966 .687 .452 r
.61604 .60038 m .61245 .59969 L .6171 .62084 L p F P
0 g
s
.966 .687 .452 r
.6171 .62084 m .62088 .62242 L .61604 .60038 L p F P
0 g
s
.966 .687 .452 r
.64979 .70643 m .64574 .70238 L .64659 .72532 L p F P
0 g
s
.966 .687 .452 r
.64659 .72532 m .6507 .73018 L .64979 .70643 L p F P
0 g
s
.966 .687 .452 r
.58534 .51595 m .58779 .51316 L .57882 .49254 L p F P
0 g
s
.966 .687 .452 r
.58779 .51316 m .58534 .51595 L .59328 .53638 L p F P
0 g
s
.966 .687 .452 r
.63964 .67523 m .63564 .67198 L .63757 .69422 L p F P
0 g
s
.966 .687 .452 r
.63757 .69422 m .64166 .69831 L .63964 .67523 L p F P
0 g
s
.966 .687 .452 r
.55206 .41308 m .55118 .41889 L .56302 .4386 L p F P
0 g
s
.966 .687 .452 r
.56172 .44371 m .56302 .4386 L .55118 .41889 L p F P
0 g
s
.966 .687 .452 r
.54025 .38132 m .5398 .38774 L .55293 .40731 L p F P
0 g
s
.966 .687 .452 r
.55206 .41308 m .55293 .40731 L .5398 .38774 L p F P
0 g
s
.966 .687 .452 r
.59739 .55835 m .60049 .55727 L .59328 .53638 L p F P
0 g
s
.966 .687 .452 r
.60049 .55727 m .59739 .55835 L .60353 .57863 L p F P
0 g
s
.966 .687 .452 r
.60353 .57863 m .6069 .57844 L .60049 .55727 L p F P
0 g
s
.966 .687 .452 r
.6069 .57844 m .60353 .57863 L .60884 .59899 L p F P
0 g
s
.966 .687 .452 r
.60884 .59899 m .61245 .59969 L .6069 .57844 L p F P
0 g
s
.966 .687 .452 r
.62866 .64659 m .62474 .64415 L .62755 .6654 L p F P
0 g
s
.966 .687 .452 r
.62755 .6654 m .63161 .6687 L .62866 .64659 L p F P
0 g
s
.966 .687 .452 r
.62088 .62242 m .6171 .62084 L .62078 .6417 L p F P
0 g
s
.966 .687 .452 r
.62078 .6417 m .62474 .64415 L .62088 .62242 L p F P
0 g
s
.966 .687 .452 r
.59048 .53834 m .59328 .53638 L .58534 .51595 L p F P
0 g
s
.966 .687 .452 r
.59328 .53638 m .59048 .53834 L .59739 .55835 L p F P
0 g
s
.966 .687 .452 r
.57095 .46836 m .56923 .47276 L .57882 .49254 L p F P
0 g
s
.966 .687 .452 r
.57672 .49616 m .57882 .49254 L .56923 .47276 L p F P
0 g
s
.966 .687 .452 r
.57882 .49254 m .57672 .49616 L .58534 .51595 L p F P
0 g
s
.966 .687 .452 r
.56172 .44371 m .56042 .44885 L .57095 .46836 L p F P
0 g
s
.966 .687 .452 r
.56923 .47276 m .57095 .46836 L .56042 .44885 L p F P
0 g
s
.966 .687 .452 r
.64574 .70238 m .64166 .69831 L .64246 .72044 L p F P
0 g
s
.966 .687 .452 r
.64246 .72044 m .64659 .72532 L .64574 .70238 L p F P
0 g
s
.966 .687 .452 r
.63564 .67198 m .63161 .6687 L .63344 .6901 L p F P
0 g
s
.966 .687 .452 r
.63344 .6901 m .63757 .69422 L .63564 .67198 L p F P
0 g
s
.966 .687 .452 r
.61245 .59969 m .60884 .59899 L .61328 .61925 L p F P
0 g
s
.966 .687 .452 r
.61328 .61925 m .6171 .62084 L .61245 .59969 L p F P
0 g
s
.966 .687 .452 r
.58286 .51876 m .58534 .51595 L .57672 .49616 L p F P
0 g
s
.966 .687 .452 r
.58534 .51595 m .58286 .51876 L .59048 .53834 L p F P
0 g
s
.966 .687 .452 r
.5398 .38774 m .53936 .3942 L .55206 .41308 L p F P
0 g
s
.966 .687 .452 r
.55118 .41889 m .55206 .41308 L .53936 .3942 L p F P
0 g
s
.966 .687 .452 r
.55118 .41889 m .55029 .42472 L .56172 .44371 L p F P
0 g
s
.966 .687 .452 r
.56042 .44885 m .56172 .44371 L .55029 .42472 L p F P
0 g
s
.966 .687 .452 r
.65478 .73501 m .6507 .73018 L .65026 .7527 L p F P
0 g
s
.966 .687 .452 r
.65026 .7527 m .65437 .75832 L .65478 .73501 L p F P
0 g
s
.966 .687 .452 r
.59426 .55944 m .59739 .55835 L .59048 .53834 L p F P
0 g
s
.966 .687 .452 r
.59739 .55835 m .59426 .55944 L .60013 .57882 L p F P
0 g
s
.966 .687 .452 r
.60013 .57882 m .60353 .57863 L .59739 .55835 L p F P
0 g
s
.966 .687 .452 r
.62474 .64415 m .62078 .6417 L .62347 .66208 L p F P
0 g
s
.966 .687 .452 r
.62347 .66208 m .62755 .6654 L .62474 .64415 L p F P
0 g
s
.966 .687 .452 r
.6171 .62084 m .61328 .61925 L .6168 .63923 L p F P
0 g
s
.966 .687 .452 r
.6168 .63923 m .62078 .6417 L .6171 .62084 L p F P
0 g
s
.966 .687 .452 r
.60353 .57863 m .60013 .57882 L .60521 .59829 L p F P
0 g
s
.966 .687 .452 r
.60521 .59829 m .60884 .59899 L .60353 .57863 L p F P
0 g
s
.966 .687 .452 r
.5398 .38774 m .54025 .38132 L .52632 .36292 L p F P
0 g
s
.966 .687 .452 r
.58765 .5403 m .59048 .53834 L .58286 .51876 L p F P
0 g
s
.966 .687 .452 r
.59048 .53834 m .58765 .5403 L .59426 .55944 L p F P
0 g
s
.966 .687 .452 r
.64166 .69831 m .63757 .69422 L .6383 .71552 L p F P
0 g
s
.966 .687 .452 r
.6383 .71552 m .64246 .72044 L .64166 .69831 L p F P
0 g
s
.966 .687 .452 r
.56042 .44885 m .5591 .45402 L .56923 .47276 L p F P
0 g
s
.966 .687 .452 r
.56751 .47719 m .56923 .47276 L .5591 .45402 L p F P
0 g
s
.966 .687 .452 r
.56923 .47276 m .56751 .47719 L .57672 .49616 L p F P
0 g
s
.966 .687 .452 r
.5746 .49981 m .57672 .49616 L .56751 .47719 L p F P
0 g
s
.966 .687 .452 r
.57672 .49616 m .5746 .49981 L .58286 .51876 L p F P
0 g
s
.966 .687 .452 r
.63161 .6687 m .62755 .6654 L .62929 .68595 L p F P
0 g
s
.966 .687 .452 r
.62929 .68595 m .63344 .6901 L .63161 .6687 L p F P
0 g
s
.966 .687 .452 r
.60884 .59899 m .60521 .59829 L .60944 .61765 L p F P
0 g
s
.966 .687 .452 r
.60944 .61765 m .61328 .61925 L .60884 .59899 L p F P
0 g
s
.966 .687 .452 r
.53936 .3942 m .53891 .4007 L .55118 .41889 L p F P
0 g
s
.966 .687 .452 r
.55029 .42472 m .55118 .41889 L .53891 .4007 L p F P
0 g
s
.966 .687 .452 r
.6507 .73018 m .64659 .72532 L .64614 .74705 L p F P
0 g
s
.966 .687 .452 r
.64614 .74705 m .65026 .7527 L .6507 .73018 L p F P
0 g
s
.966 .687 .452 r
.58037 .5216 m .58286 .51876 L .5746 .49981 L p F P
0 g
s
.966 .687 .452 r
.58286 .51876 m .58037 .5216 L .58765 .5403 L p F P
0 g
s
.966 .687 .452 r
.55029 .42472 m .5494 .4306 L .56042 .44885 L p F P
0 g
s
.966 .687 .452 r
.5591 .45402 m .56042 .44885 L .5494 .4306 L p F P
0 g
s
.966 .687 .452 r
.52632 .36292 m .52632 .36999 L .5398 .38774 L p F P
0 g
s
.966 .687 .452 r
.53936 .3942 m .5398 .38774 L .52632 .36999 L p F P
0 g
s
.966 .687 .452 r
.62078 .6417 m .6168 .63923 L .61936 .65873 L p F P
0 g
s
.966 .687 .452 r
.61936 .65873 m .62347 .66208 L .62078 .6417 L p F P
0 g
s
.966 .687 .452 r
.63757 .69422 m .63344 .6901 L .63413 .71058 L p F P
0 g
s
.966 .687 .452 r
.63413 .71058 m .6383 .71552 L .63757 .69422 L p F P
0 g
s
.966 .687 .452 r
.59111 .56053 m .59426 .55944 L .58765 .5403 L p F P
0 g
s
.966 .687 .452 r
.59426 .55944 m .59111 .56053 L .5967 .57902 L p F P
0 g
s
.966 .687 .452 r
.5967 .57902 m .60013 .57882 L .59426 .55944 L p F P
0 g
s
.966 .687 .452 r
.61328 .61925 m .60944 .61765 L .61279 .63674 L p F P
0 g
s
.966 .687 .452 r
.61279 .63674 m .6168 .63923 L .61328 .61925 L p F P
0 g
s
.966 .687 .452 r
.60013 .57882 m .5967 .57902 L .60154 .59758 L p F P
0 g
s
.966 .687 .452 r
.60154 .59758 m .60521 .59829 L .60013 .57882 L p F P
0 g
s
.966 .687 .452 r
.5591 .45402 m .55778 .45923 L .56751 .47719 L p F P
0 g
s
.966 .687 .452 r
.56577 .48166 m .56751 .47719 L .55778 .45923 L p F P
0 g
s
.966 .687 .452 r
.56751 .47719 m .56577 .48166 L .5746 .49981 L p F P
0 g
s
.966 .687 .452 r
.58481 .54229 m .58765 .5403 L .58037 .5216 L p F P
0 g
s
.966 .687 .452 r
.58765 .5403 m .58481 .54229 L .59111 .56053 L p F P
0 g
s
.966 .687 .452 r
.57247 .50349 m .5746 .49981 L .56577 .48166 L p F P
0 g
s
.966 .687 .452 r
.5746 .49981 m .57247 .50349 L .58037 .5216 L p F P
0 g
s
.966 .687 .452 r
.62755 .6654 m .62347 .66208 L .62512 .68178 L p F P
0 g
s
.966 .687 .452 r
.62512 .68178 m .62929 .68595 L .62755 .6654 L p F P
0 g
s
.966 .687 .452 r
.64659 .72532 m .64246 .72044 L .64199 .74138 L p F P
0 g
s
.966 .687 .452 r
.64199 .74138 m .64614 .74705 L .64659 .72532 L p F P
0 g
s
.966 .687 .452 r
.53891 .4007 m .53846 .40722 L .55029 .42472 L p F P
0 g
s
.966 .687 .452 r
.5494 .4306 m .55029 .42472 L .53846 .40722 L p F P
0 g
s
.966 .687 .452 r
.5494 .4306 m .54851 .43651 L .5591 .45402 L p F P
0 g
s
.966 .687 .452 r
.55778 .45923 m .5591 .45402 L .54851 .43651 L p F P
0 g
s
.966 .687 .452 r
.60521 .59829 m .60154 .59758 L .60557 .61604 L p F P
0 g
s
.966 .687 .452 r
.60557 .61604 m .60944 .61765 L .60521 .59829 L p F P
0 g
s
.966 .687 .452 r
.57786 .52445 m .58037 .5216 L .57247 .50349 L p F P
0 g
s
.966 .687 .452 r
.58037 .5216 m .57786 .52445 L .58481 .54229 L p F P
0 g
s
.966 .687 .452 r
.52632 .36999 m .52632 .37709 L .53936 .3942 L p F P
0 g
s
.966 .687 .452 r
.53891 .4007 m .53936 .3942 L .52632 .37709 L p F P
0 g
s
.966 .687 .452 r
.63344 .6901 m .62929 .68595 L .62993 .70561 L p F P
0 g
s
.966 .687 .452 r
.62993 .70561 m .63413 .71058 L .63344 .6901 L p F P
0 g
s
.966 .687 .452 r
.6168 .63923 m .61279 .63674 L .61522 .65537 L p F P
0 g
s
.966 .687 .452 r
.61522 .65537 m .61936 .65873 L .6168 .63923 L p F P
0 g
s
.966 .687 .452 r
.64246 .72044 m .6383 .71552 L .63782 .73567 L p F P
0 g
s
.966 .687 .452 r
.63782 .73567 m .64199 .74138 L .64246 .72044 L p F P
0 g
s
.966 .687 .452 r
.60944 .61765 m .60557 .61604 L .60876 .63423 L p F P
0 g
s
.966 .687 .452 r
.60876 .63423 m .61279 .63674 L .60944 .61765 L p F P
0 g
s
.966 .687 .452 r
.58793 .56163 m .59111 .56053 L .58481 .54229 L p F P
0 g
s
.966 .687 .452 r
.59111 .56053 m .58793 .56163 L .59325 .57922 L p F P
0 g
s
.966 .687 .452 r
.59325 .57922 m .5967 .57902 L .59111 .56053 L p F P
0 g
s
.966 .687 .452 r
.65437 .75832 m .65026 .7527 L .64846 .77376 L p F P
0 g
s
.966 .687 .452 r
.64846 .77376 m .65255 .78014 L .65437 .75832 L p F P
0 g
s
.966 .687 .452 r
.55778 .45923 m .55644 .46447 L .56577 .48166 L p F P
0 g
s
.966 .687 .452 r
.56402 .48615 m .56577 .48166 L .55644 .46447 L p F P
0 g
s
.966 .687 .452 r
.56577 .48166 m .56402 .48615 L .57247 .50349 L p F P
0 g
s
.966 .687 .452 r
.53846 .40722 m .538 .41379 L .5494 .4306 L p F P
0 g
s
.966 .687 .452 r
.54851 .43651 m .5494 .4306 L .538 .41379 L p F P
0 g
s
.966 .687 .452 r
.62347 .66208 m .61936 .65873 L .62092 .67758 L p F P
0 g
s
.966 .687 .452 r
.62092 .67758 m .62512 .68178 L .62347 .66208 L p F P
0 g
s
.966 .687 .452 r
.5967 .57902 m .59325 .57922 L .59785 .59687 L p F P
0 g
s
.966 .687 .452 r
.59785 .59687 m .60154 .59758 L .5967 .57902 L p F P
0 g
s
.966 .687 .452 r
.57032 .50719 m .57247 .50349 L .56402 .48615 L p F P
0 g
s
.966 .687 .452 r
.57247 .50349 m .57032 .50719 L .57786 .52445 L p F P
0 g
s
.966 .687 .452 r
.58194 .54428 m .58481 .54229 L .57786 .52445 L p F P
0 g
s
.966 .687 .452 r
.58481 .54229 m .58194 .54428 L .58793 .56163 L p F P
0 g
s
.966 .687 .452 r
.54851 .43651 m .54761 .44245 L .55778 .45923 L p F P
0 g
s
.966 .687 .452 r
.55644 .46447 m .55778 .45923 L .54761 .44245 L p F P
0 g
s
.966 .687 .452 r
.52632 .37709 m .52632 .38423 L .53891 .4007 L p F P
0 g
s
.966 .687 .452 r
.53846 .40722 m .53891 .4007 L .52632 .38423 L p F P
0 g
s
.966 .687 .452 r
.60154 .59758 m .59785 .59687 L .60168 .61442 L p F P
0 g
s
.966 .687 .452 r
.60168 .61442 m .60557 .61604 L .60154 .59758 L p F P
0 g
s
.966 .687 .452 r
.57533 .52733 m .57786 .52445 L .57032 .50719 L p F P
0 g
s
.966 .687 .452 r
.57786 .52445 m .57533 .52733 L .58194 .54428 L p F P
0 g
s
.966 .687 .452 r
.62929 .68595 m .62512 .68178 L .6257 .70061 L p F P
0 g
s
.966 .687 .452 r
.6257 .70061 m .62993 .70561 L .62929 .68595 L p F P
0 g
s
.966 .687 .452 r
.65026 .7527 m .64614 .74705 L .64436 .76735 L p F P
0 g
s
.966 .687 .452 r
.64436 .76735 m .64846 .77376 L .65026 .7527 L p F P
0 g
s
.966 .687 .452 r
.6383 .71552 m .63413 .71058 L .63363 .72994 L p F P
0 g
s
.966 .687 .452 r
.63363 .72994 m .63782 .73567 L .6383 .71552 L p F P
0 g
s
.966 .687 .452 r
.61279 .63674 m .60876 .63423 L .61106 .65198 L p F P
0 g
s
.966 .687 .452 r
.61106 .65198 m .61522 .65537 L .61279 .63674 L p F P
0 g
s
.966 .687 .452 r
.538 .41379 m .53755 .42039 L .54851 .43651 L p F P
0 g
s
.966 .687 .452 r
.54761 .44245 m .54851 .43651 L .53755 .42039 L p F P
0 g
s
.966 .687 .452 r
.61936 .65873 m .61522 .65537 L .61669 .67336 L p F P
0 g
s
.966 .687 .452 r
.61669 .67336 m .62092 .67758 L .61936 .65873 L p F P
0 g
s
.966 .687 .452 r
.55644 .46447 m .5551 .46975 L .56402 .48615 L p F P
0 g
s
.966 .687 .452 r
.56226 .49067 m .56402 .48615 L .5551 .46975 L p F P
0 g
s
.966 .687 .452 r
.56402 .48615 m .56226 .49067 L .57032 .50719 L p F P
0 g
s
.966 .687 .452 r
.60557 .61604 m .60168 .61442 L .60469 .63171 L p F P
0 g
s
.966 .687 .452 r
.60469 .63171 m .60876 .63423 L .60557 .61604 L p F P
0 g
s
.966 .687 .452 r
.58473 .56275 m .58793 .56163 L .58194 .54428 L p F P
0 g
s
.966 .687 .452 r
.58793 .56163 m .58473 .56275 L .58978 .57941 L p F P
0 g
s
.966 .687 .452 r
.58978 .57941 m .59325 .57922 L .58793 .56163 L p F P
0 g
s
.966 .687 .452 r
.52632 .38423 m .52632 .39141 L .53846 .40722 L p F P
0 g
s
.966 .687 .452 r
.538 .41379 m .53846 .40722 L .52632 .39141 L p F P
0 g
s
.966 .687 .452 r
.56816 .51092 m .57032 .50719 L .56226 .49067 L p F P
0 g
s
.966 .687 .452 r
.57032 .50719 m .56816 .51092 L .57533 .52733 L p F P
0 g
s
.966 .687 .452 r
.59325 .57922 m .58978 .57941 L .59413 .59615 L p F P
0 g
s
.966 .687 .452 r
.59413 .59615 m .59785 .59687 L .59325 .57922 L p F P
0 g
s
.966 .687 .452 r
.54761 .44245 m .5467 .44843 L .55644 .46447 L p F P
0 g
s
.966 .687 .452 r
.5551 .46975 m .55644 .46447 L .5467 .44843 L p F P
0 g
s
.966 .687 .452 r
.57905 .5463 m .58194 .54428 L .57533 .52733 L p F P
0 g
s
.966 .687 .452 r
.58194 .54428 m .57905 .5463 L .58473 .56275 L p F P
0 g
s
.966 .687 .452 r
.64614 .74705 m .64199 .74138 L .64024 .76092 L p F P
0 g
s
.966 .687 .452 r
.64024 .76092 m .64436 .76735 L .64614 .74705 L p F P
0 g
s
.966 .687 .452 r
.62512 .68178 m .62092 .67758 L .62145 .69559 L p F P
0 g
s
.966 .687 .452 r
.62145 .69559 m .6257 .70061 L .62512 .68178 L p F P
0 g
s
.966 .687 .452 r
.59785 .59687 m .59413 .59615 L .59775 .61278 L p F P
0 g
s
.966 .687 .452 r
.59775 .61278 m .60168 .61442 L .59785 .59687 L p F P
0 g
s
.966 .687 .452 r
.63413 .71058 m .62993 .70561 L .62942 .72417 L p F P
0 g
s
.966 .687 .452 r
.62942 .72417 m .63363 .72994 L .63413 .71058 L p F P
0 g
s
.966 .687 .452 r
.57278 .53022 m .57533 .52733 L .56816 .51092 L p F P
0 g
s
.966 .687 .452 r
.57533 .52733 m .57278 .53022 L .57905 .5463 L p F P
0 g
s
.966 .687 .452 r
.53755 .42039 m .53709 .42703 L .54761 .44245 L p F P
0 g
s
.966 .687 .452 r
.5467 .44843 m .54761 .44245 L .53709 .42703 L p F P
0 g
s
.966 .687 .452 r
.60876 .63423 m .60469 .63171 L .60687 .64857 L p F P
0 g
s
.966 .687 .452 r
.60687 .64857 m .61106 .65198 L .60876 .63423 L p F P
0 g
s
.966 .687 .452 r
.52632 .39141 m .52632 .39862 L .538 .41379 L p F P
0 g
s
.966 .687 .452 r
.53755 .42039 m .538 .41379 L .52632 .39862 L p F P
0 g
s
.966 .687 .452 r
.61522 .65537 m .61106 .65198 L .61244 .66911 L p F P
0 g
s
.966 .687 .452 r
.61244 .66911 m .61669 .67336 L .61522 .65537 L p F P
0 g
s
.966 .687 .452 r
.5551 .46975 m .55375 .47506 L .56226 .49067 L p F P
0 g
s
.966 .687 .452 r
.56049 .49523 m .56226 .49067 L .55375 .47506 L p F P
0 g
s
.966 .687 .452 r
.56226 .49067 m .56049 .49523 L .56816 .51092 L p F P
0 g
s
.966 .687 .452 r
.60168 .61442 m .59775 .61278 L .6006 .62917 L p F P
0 g
s
.966 .687 .452 r
.6006 .62917 m .60469 .63171 L .60168 .61442 L p F P
0 g
s
.966 .687 .452 r
.5467 .44843 m .54579 .45445 L .5551 .46975 L p F P
0 g
s
.966 .687 .452 r
.55375 .47506 m .5551 .46975 L .54579 .45445 L p F P
0 g
s
.966 .687 .452 r
.64199 .74138 m .63782 .73567 L .6361 .75445 L p F P
0 g
s
.966 .687 .452 r
.6361 .75445 m .64024 .76092 L .64199 .74138 L p F P
0 g
s
.966 .687 .452 r
.56598 .51468 m .56816 .51092 L .56049 .49523 L p F P
0 g
s
.966 .687 .452 r
.56816 .51092 m .56598 .51468 L .57278 .53022 L p F P
0 g
s
.966 .687 .452 r
.58151 .56387 m .58473 .56275 L .57905 .5463 L p F P
0 g
s
.966 .687 .452 r
.58473 .56275 m .58151 .56387 L .58627 .57961 L p F P
0 g
s
.966 .687 .452 r
.58627 .57961 m .58978 .57941 L .58473 .56275 L p F P
0 g
s
.966 .687 .452 r
.58978 .57941 m .58627 .57961 L .59038 .59542 L p F P
0 g
s
.966 .687 .452 r
.59038 .59542 m .59413 .59615 L .58978 .57941 L p F P
0 g
s
.966 .687 .452 r
.57614 .54833 m .57905 .5463 L .57278 .53022 L p F P
0 g
s
.966 .687 .452 r
.57905 .5463 m .57614 .54833 L .58151 .56387 L p F P
0 g
s
.966 .687 .452 r
.62993 .70561 m .6257 .70061 L .62519 .71838 L p F P
0 g
s
.966 .687 .452 r
.62519 .71838 m .62942 .72417 L .62993 .70561 L p F P
0 g
s
.966 .687 .452 r
.62092 .67758 m .61669 .67336 L .61718 .69053 L p F P
0 g
s
.966 .687 .452 r
.61718 .69053 m .62145 .69559 L .62092 .67758 L p F P
0 g
s
.966 .687 .452 r
.59413 .59615 m .59038 .59542 L .5938 .61114 L p F P
0 g
s
.966 .687 .452 r
.5938 .61114 m .59775 .61278 L .59413 .59615 L p F P
0 g
s
.966 .687 .452 r
.53709 .42703 m .53663 .43371 L .5467 .44843 L p F P
0 g
s
.966 .687 .452 r
.54579 .45445 m .5467 .44843 L .53663 .43371 L p F P
0 g
s
.966 .687 .452 r
.57021 .53314 m .57278 .53022 L .56598 .51468 L p F P
0 g
s
.966 .687 .452 r
.57278 .53022 m .57021 .53314 L .57614 .54833 L p F P
0 g
s
.966 .687 .452 r
.52632 .39862 m .52632 .40586 L .53755 .42039 L p F P
0 g
s
.966 .687 .452 r
.53709 .42703 m .53755 .42039 L .52632 .40586 L p F P
0 g
s
.966 .687 .452 r
.65255 .78014 m .64846 .77376 L .64527 .7931 L p F P
0 g
s
.966 .687 .452 r
.64527 .7931 m .64928 .8002 L .65255 .78014 L p F P
0 g
s
.966 .687 .452 r
.60469 .63171 m .6006 .62917 L .60264 .64513 L p F P
0 g
s
.966 .687 .452 r
.60264 .64513 m .60687 .64857 L .60469 .63171 L p F P
0 g
s
.966 .687 .452 r
.61106 .65198 m .60687 .64857 L .60816 .66483 L p F P
0 g
s
.966 .687 .452 r
.60816 .66483 m .61244 .66911 L .61106 .65198 L p F P
0 g
s
.966 .687 .452 r
.63782 .73567 m .63363 .72994 L .63194 .74796 L p F P
0 g
s
.966 .687 .452 r
.63194 .74796 m .6361 .75445 L .63782 .73567 L p F P
0 g
s
.966 .687 .452 r
.55375 .47506 m .5524 .48041 L .56049 .49523 L p F P
0 g
s
.966 .687 .452 r
.5587 .49982 m .56049 .49523 L .5524 .48041 L p F P
0 g
s
.966 .687 .452 r
.56049 .49523 m .5587 .49982 L .56598 .51468 L p F P
0 g
s
.966 .687 .452 r
.54579 .45445 m .54487 .46051 L .55375 .47506 L p F P
0 g
s
.966 .687 .452 r
.5524 .48041 m .55375 .47506 L .54487 .46051 L p F P
0 g
s
.966 .687 .452 r
.59775 .61278 m .5938 .61114 L .59648 .62661 L p F P
0 g
s
.966 .687 .452 r
.59648 .62661 m .6006 .62917 L .59775 .61278 L p F P
0 g
s
.966 .687 .452 r
.6257 .70061 m .62145 .69559 L .62094 .71256 L p F P
0 g
s
.966 .687 .452 r
.62094 .71256 m .62519 .71838 L .6257 .70061 L p F P
0 g
s
.966 .687 .452 r
.56378 .51847 m .56598 .51468 L .5587 .49982 L p F P
0 g
s
.966 .687 .452 r
.56598 .51468 m .56378 .51847 L .57021 .53314 L p F P
0 g
s
.966 .687 .452 r
.61669 .67336 m .61244 .66911 L .61288 .68545 L p F P
0 g
s
.966 .687 .452 r
.61288 .68545 m .61718 .69053 L .61669 .67336 L p F P
0 g
s
.966 .687 .452 r
.57826 .56499 m .58151 .56387 L .57614 .54833 L p F P
0 g
s
.966 .687 .452 r
.58151 .56387 m .57826 .56499 L .58274 .57982 L p F P
0 g
s
.966 .687 .452 r
.58274 .57982 m .58627 .57961 L .58151 .56387 L p F P
0 g
s
.966 .687 .452 r
.64846 .77376 m .64436 .76735 L .64123 .78598 L p F P
0 g
s
.966 .687 .452 r
.64123 .78598 m .64527 .7931 L .64846 .77376 L p F P
0 g
s
.966 .687 .452 r
.58627 .57961 m .58274 .57982 L .58661 .59469 L p F P
0 g
s
.966 .687 .452 r
.58661 .59469 m .59038 .59542 L .58627 .57961 L p F P
0 g
s
.966 .687 .452 r
.57321 .55037 m .57614 .54833 L .57021 .53314 L p F P
0 g
s
.966 .687 .452 r
.57614 .54833 m .57321 .55037 L .57826 .56499 L p F P
0 g
s
.966 .687 .452 r
.52632 .40586 m .52632 .41314 L .53709 .42703 L p F P
0 g
s
.966 .687 .452 r
.53663 .43371 m .53709 .42703 L .52632 .41314 L p F P
0 g
s
.966 .687 .452 r
.53663 .43371 m .53616 .44042 L .54579 .45445 L p F P
0 g
s
.966 .687 .452 r
.54487 .46051 m .54579 .45445 L .53616 .44042 L p F P
0 g
s
.966 .687 .452 r
.63363 .72994 m .62942 .72417 L .62776 .74144 L p F P
0 g
s
.966 .687 .452 r
.62776 .74144 m .63194 .74796 L .63363 .72994 L p F P
0 g
s
.966 .687 .452 r
.59038 .59542 m .58661 .59469 L .58981 .60948 L p F P
0 g
s
.966 .687 .452 r
.58981 .60948 m .5938 .61114 L .59038 .59542 L p F P
0 g
s
.966 .687 .452 r
.56762 .53609 m .57021 .53314 L .56378 .51847 L p F P
0 g
s
.966 .687 .452 r
.57021 .53314 m .56762 .53609 L .57321 .55037 L p F P
0 g
s
.966 .687 .452 r
.60687 .64857 m .60264 .64513 L .60386 .66053 L p F P
0 g
s
.966 .687 .452 r
.60386 .66053 m .60816 .66483 L .60687 .64857 L p F P
0 g
s
.966 .687 .452 r
.6006 .62917 m .59648 .62661 L .5984 .64168 L p F P
0 g
s
.966 .687 .452 r
.5984 .64168 m .60264 .64513 L .6006 .62917 L p F P
0 g
s
.966 .687 .452 r
.62145 .69559 m .61718 .69053 L .61666 .70671 L p F P
0 g
s
.966 .687 .452 r
.61666 .70671 m .62094 .71256 L .62145 .69559 L p F P
0 g
s
.966 .687 .452 r
.64436 .76735 m .64024 .76092 L .63718 .77882 L p F P
0 g
s
.966 .687 .452 r
.63718 .77882 m .64123 .78598 L .64436 .76735 L p F P
0 g
s
.966 .687 .452 r
.5524 .48041 m .55103 .48579 L .5587 .49982 L p F P
0 g
s
.966 .687 .452 r
.55691 .50444 m .5587 .49982 L .55103 .48579 L p F P
0 g
s
.966 .687 .452 r
.5587 .49982 m .55691 .50444 L .56378 .51847 L p F P
0 g
s
.966 .687 .452 r
.54487 .46051 m .54395 .4666 L .5524 .48041 L p F P
0 g
s
.966 .687 .452 r
.55103 .48579 m .5524 .48041 L .54395 .4666 L p F P
0 g
s
.966 .687 .452 r
.61244 .66911 m .60816 .66483 L .60856 .68034 L p F P
0 g
s
.966 .687 .452 r
.60856 .68034 m .61288 .68545 L .61244 .66911 L p F P
0 g
s
.966 .687 .452 r
.5938 .61114 m .58981 .60948 L .59233 .62403 L p F P
0 g
s
.966 .687 .452 r
.59233 .62403 m .59648 .62661 L .5938 .61114 L p F P
0 g
s
.966 .687 .452 r
.56157 .52228 m .56378 .51847 L .55691 .50444 L p F P
0 g
s
.966 .687 .452 r
.56378 .51847 m .56157 .52228 L .56762 .53609 L p F P
0 g
s
.966 .687 .452 r
.52632 .41314 m .52632 .42046 L .53663 .43371 L p F P
0 g
s
.966 .687 .452 r
.53616 .44042 m .53663 .43371 L .52632 .42046 L p F P
0 g
s
.966 .687 .452 r
.62942 .72417 m .62519 .71838 L .62357 .73489 L p F P
0 g
s
.966 .687 .452 r
.62357 .73489 m .62776 .74144 L .62942 .72417 L p F P
0 g
s
.966 .687 .452 r
.53616 .44042 m .5357 .44717 L .54487 .46051 L p F P
0 g
s
.966 .687 .452 r
.54395 .4666 m .54487 .46051 L .5357 .44717 L p F P
0 g
s
.966 .687 .452 r
.57499 .56613 m .57826 .56499 L .57321 .55037 L p F P
0 g
s
.966 .687 .452 r
.57826 .56499 m .57499 .56613 L .57919 .58002 L p F P
0 g
s
.966 .687 .452 r
.57919 .58002 m .58274 .57982 L .57826 .56499 L p F P
0 g
s
.966 .687 .452 r
.58274 .57982 m .57919 .58002 L .5828 .59396 L p F P
0 g
s
.966 .687 .452 r
.5828 .59396 m .58661 .59469 L .58274 .57982 L p F P
0 g
s
.966 .687 .452 r
.57025 .55243 m .57321 .55037 L .56762 .53609 L p F P
0 g
s
.966 .687 .452 r
.57321 .55037 m .57025 .55243 L .57499 .56613 L p F P
0 g
s
.966 .687 .452 r
.64024 .76092 m .6361 .75445 L .63312 .77165 L p F P
0 g
s
.966 .687 .452 r
.63312 .77165 m .63718 .77882 L .64024 .76092 L p F P
0 g
s
.966 .687 .452 r
.58661 .59469 m .5828 .59396 L .5858 .60781 L p F P
0 g
s
.966 .687 .452 r
.5858 .60781 m .58981 .60948 L .58661 .59469 L p F P
0 g
s
.966 .687 .452 r
.61718 .69053 m .61288 .68545 L .61236 .70082 L p F P
0 g
s
.966 .687 .452 r
.61236 .70082 m .61666 .70671 L .61718 .69053 L p F P
0 g
s
.966 .687 .452 r
.60264 .64513 m .5984 .64168 L .59952 .6562 L p F P
0 g
s
.966 .687 .452 r
.59952 .6562 m .60386 .66053 L .60264 .64513 L p F P
0 g
s
.966 .687 .452 r
.56502 .53905 m .56762 .53609 L .56157 .52228 L p F P
0 g
s
.966 .687 .452 r
.56762 .53609 m .56502 .53905 L .57025 .55243 L p F P
0 g
s
.966 .687 .452 r
.59648 .62661 m .59233 .62403 L .59412 .6382 L p F P
0 g
s
.966 .687 .452 r
.59412 .6382 m .5984 .64168 L .59648 .62661 L p F P
0 g
s
.966 .687 .452 r
.54395 .4666 m .54302 .47273 L .55103 .48579 L p F P
0 g
s
.966 .687 .452 r
.54965 .4912 m .55103 .48579 L .54302 .47273 L p F P
0 g
s
.966 .687 .452 r
.55103 .48579 m .54965 .4912 L .55691 .50444 L p F P
0 g
s
.966 .687 .452 r
.55509 .50909 m .55691 .50444 L .54965 .4912 L p F P
0 g
s
.966 .687 .452 r
.55691 .50444 m .55509 .50909 L .56157 .52228 L p F P
0 g
s
.966 .687 .452 r
.60816 .66483 m .60386 .66053 L .60421 .67519 L p F P
0 g
s
.966 .687 .452 r
.60421 .67519 m .60856 .68034 L .60816 .66483 L p F P
0 g
s
.966 .687 .452 r
.62519 .71838 m .62094 .71256 L .61936 .72831 L p F P
0 g
s
.966 .687 .452 r
.61936 .72831 m .62357 .73489 L .62519 .71838 L p F P
0 g
s
.966 .687 .452 r
.52632 .42046 m .52632 .42781 L .53616 .44042 L p F P
0 g
s
.966 .687 .452 r
.5357 .44717 m .53616 .44042 L .52632 .42781 L p F P
0 g
s
.966 .687 .452 r
.58981 .60948 m .5858 .60781 L .58815 .62143 L p F P
0 g
s
.966 .687 .452 r
.58815 .62143 m .59233 .62403 L .58981 .60948 L p F P
0 g
s
.966 .687 .452 r
.5357 .44717 m .53523 .45396 L .54395 .4666 L p F P
0 g
s
.966 .687 .452 r
.54302 .47273 m .54395 .4666 L .53523 .45396 L p F P
0 g
s
.966 .687 .452 r
.6361 .75445 m .63194 .74796 L .62904 .76444 L p F P
0 g
s
.966 .687 .452 r
.62904 .76444 m .63312 .77165 L .6361 .75445 L p F P
0 g
s
.966 .687 .452 r
.55934 .52612 m .56157 .52228 L .55509 .50909 L p F P
0 g
s
.966 .687 .452 r
.56157 .52228 m .55934 .52612 L .56502 .53905 L p F P
0 g
s
.966 .687 .452 r
.57169 .56728 m .57499 .56613 L .57025 .55243 L p F P
0 g
s
.966 .687 .452 r
.57499 .56613 m .57169 .56728 L .5756 .58022 L p F P
0 g
s
.966 .687 .452 r
.5756 .58022 m .57919 .58002 L .57499 .56613 L p F P
0 g
s
.966 .687 .452 r
.57919 .58002 m .5756 .58022 L .57897 .59322 L p F P
0 g
s
.966 .687 .452 r
.57897 .59322 m .5828 .59396 L .57919 .58002 L p F P
0 g
s
.966 .687 .452 r
.61288 .68545 m .60856 .68034 L .60804 .69491 L p F P
0 g
s
.966 .687 .452 r
.60804 .69491 m .61236 .70082 L .61288 .68545 L p F P
0 g
s
.966 .687 .452 r
.56727 .55451 m .57025 .55243 L .56502 .53905 L p F P
0 g
s
.966 .687 .452 r
.57025 .55243 m .56727 .55451 L .57169 .56728 L p F P
0 g
s
.966 .687 .452 r
.64928 .8002 m .64527 .7931 L .64067 .81049 L p F P
0 g
s
.966 .687 .452 r
.64067 .81049 m .64457 .81826 L .64928 .8002 L p F P
0 g
s
.966 .687 .452 r
.5984 .64168 m .59412 .6382 L .59516 .65184 L p F P
0 g
s
.966 .687 .452 r
.59516 .65184 m .59952 .6562 L .5984 .64168 L p F P
0 g
s
.966 .687 .452 r
.62094 .71256 m .61666 .70671 L .61512 .7217 L p F P
0 g
s
.966 .687 .452 r
.61512 .7217 m .61936 .72831 L .62094 .71256 L p F P
0 g
s
.966 .687 .452 r
.5828 .59396 m .57897 .59322 L .58176 .60612 L p F P
0 g
s
.966 .687 .452 r
.58176 .60612 m .5858 .60781 L .5828 .59396 L p F P
0 g
s
.966 .687 .452 r
.59233 .62403 m .58815 .62143 L .58981 .6347 L p F P
0 g
s
.966 .687 .452 r
.58981 .6347 m .59412 .6382 L .59233 .62403 L p F P
0 g
s
.966 .687 .452 r
.52632 .42781 m .52632 .43521 L .5357 .44717 L p F P
0 g
s
.966 .687 .452 r
.53523 .45396 m .5357 .44717 L .52632 .43521 L p F P
0 g
s
.966 .687 .452 r
.63194 .74796 m .62776 .74144 L .62494 .75721 L p F P
0 g
s
.966 .687 .452 r
.62494 .75721 m .62904 .76444 L .63194 .74796 L p F P
0 g
s
.966 .687 .452 r
.56239 .54204 m .56502 .53905 L .55934 .52612 L p F P
0 g
s
.966 .687 .452 r
.56502 .53905 m .56239 .54204 L .56727 .55451 L p F P
0 g
s
.966 .687 .452 r
.54302 .47273 m .54209 .4789 L .54965 .4912 L p F P
0 g
s
.966 .687 .452 r
.54827 .49666 m .54965 .4912 L .54209 .4789 L p F P
0 g
s
.966 .687 .452 r
.54965 .4912 m .54827 .49666 L .55509 .50909 L p F P
0 g
s
.966 .687 .452 r
.60386 .66053 m .59952 .6562 L .59984 .67002 L p F P
0 g
s
.966 .687 .452 r
.59984 .67002 m .60421 .67519 L .60386 .66053 L p F P
0 g
s
.966 .687 .452 r
.55327 .51378 m .55509 .50909 L .54827 .49666 L p F P
0 g
s
.966 .687 .452 r
.55509 .50909 m .55327 .51378 L .55934 .52612 L p F P
0 g
s
.966 .687 .452 r
.53523 .45396 m .53476 .46079 L .54302 .47273 L p F P
0 g
s
.966 .687 .452 r
.54209 .4789 m .54302 .47273 L .53476 .46079 L p F P
0 g
s
.966 .687 .452 r
.64527 .7931 m .64123 .78598 L .63675 .80269 L p F P
0 g
s
.966 .687 .452 r
.63675 .80269 m .64067 .81049 L .64527 .7931 L p F P
0 g
s
.966 .687 .452 r
.5858 .60781 m .58176 .60612 L .58393 .61882 L p F P
0 g
s
.966 .687 .452 r
.58393 .61882 m .58815 .62143 L .5858 .60781 L p F P
0 g
s
.966 .687 .452 r
.55709 .52999 m .55934 .52612 L .55327 .51378 L p F P
0 g
s
.966 .687 .452 r
.55934 .52612 m .55709 .52999 L .56239 .54204 L p F P
0 g
s
.966 .687 .452 r
.60856 .68034 m .60421 .67519 L .6037 .68897 L p F P
0 g
s
.966 .687 .452 r
.6037 .68897 m .60804 .69491 L .60856 .68034 L p F P
0 g
s
.966 .687 .452 r
.61666 .70671 m .61236 .70082 L .61087 .71507 L p F P
0 g
s
.966 .687 .452 r
.61087 .71507 m .61512 .7217 L .61666 .70671 L p F P
0 g
s
.966 .687 .452 r
.62776 .74144 m .62357 .73489 L .62083 .74995 L p F P
0 g
s
.966 .687 .452 r
.62083 .74995 m .62494 .75721 L .62776 .74144 L p F P
0 g
s
.966 .687 .452 r
.56836 .56843 m .57169 .56728 L .56727 .55451 L p F P
0 g
s
.966 .687 .452 r
.57169 .56728 m .56836 .56843 L .57199 .58043 L p F P
0 g
s
.966 .687 .452 r
.57199 .58043 m .5756 .58022 L .57169 .56728 L p F P
0 g
s
.966 .687 .452 r
.52632 .43521 m .52632 .44263 L .53523 .45396 L p F P
0 g
s
.966 .687 .452 r
.53476 .46079 m .53523 .45396 L .52632 .44263 L p F P
0 g
s
.966 .687 .452 r
.5756 .58022 m .57199 .58043 L .5751 .59247 L p F P
0 g
s
.966 .687 .452 r
.5751 .59247 m .57897 .59322 L .5756 .58022 L p F P
0 g
s
.966 .687 .452 r
.59412 .6382 m .58981 .6347 L .59078 .64746 L p F P
0 g
s
.966 .687 .452 r
.59078 .64746 m .59516 .65184 L .59412 .6382 L p F P
0 g
s
.966 .687 .452 r
.56427 .5566 m .56727 .55451 L .56239 .54204 L p F P
0 g
s
.966 .687 .452 r
.56727 .55451 m .56427 .5566 L .56836 .56843 L p F P
0 g
s
.966 .687 .452 r
.64123 .78598 m .63718 .77882 L .63282 .79488 L p F P
0 g
s
.966 .687 .452 r
.63282 .79488 m .63675 .80269 L .64123 .78598 L p F P
0 g
s
.966 .687 .452 r
.59952 .6562 m .59516 .65184 L .59545 .66482 L p F P
0 g
s
.966 .687 .452 r
.59545 .66482 m .59984 .67002 L .59952 .6562 L p F P
0 g
s
.966 .687 .452 r
.54209 .4789 m .54115 .4851 L .54827 .49666 L p F P
0 g
s
.966 .687 .452 r
.54687 .50215 m .54827 .49666 L .54115 .4851 L p F P
0 g
s
.966 .687 .452 r
.54827 .49666 m .54687 .50215 L .55327 .51378 L p F P
0 g
s
.966 .687 .452 r
.58815 .62143 m .58393 .61882 L .58548 .63117 L p F P
0 g
s
.966 .687 .452 r
.58548 .63117 m .58981 .6347 L .58815 .62143 L p F P
0 g
s
.966 .687 .452 r
.57897 .59322 m .5751 .59247 L .57768 .60443 L p F P
0 g
s
.966 .687 .452 r
.57768 .60443 m .58176 .60612 L .57897 .59322 L p F P
0 g
s
.966 .687 .452 r
.55974 .54504 m .56239 .54204 L .55709 .52999 L p F P
0 g
s
.966 .687 .452 r
.56239 .54204 m .55974 .54504 L .56427 .5566 L p F P
0 g
s
.966 .687 .452 r
.55143 .5185 m .55327 .51378 L .54687 .50215 L p F P
0 g
s
.966 .687 .452 r
.55327 .51378 m .55143 .5185 L .55709 .52999 L p F P
0 g
s
.966 .687 .452 r
.53476 .46079 m .53428 .46765 L .54209 .4789 L p F P
0 g
s
.966 .687 .452 r
.54115 .4851 m .54209 .4789 L .53428 .46765 L p F P
0 g
s
.966 .687 .452 r
.62357 .73489 m .61936 .72831 L .6167 .74266 L p F P
0 g
s
.966 .687 .452 r
.6167 .74266 m .62083 .74995 L .62357 .73489 L p F P
0 g
s
.966 .687 .452 r
.60421 .67519 m .59984 .67002 L .59934 .683 L p F P
0 g
s
.966 .687 .452 r
.59934 .683 m .6037 .68897 L .60421 .67519 L p F P
0 g
s
.966 .687 .452 r
.61236 .70082 m .60804 .69491 L .6066 .7084 L p F P
0 g
s
.966 .687 .452 r
.6066 .7084 m .61087 .71507 L .61236 .70082 L p F P
0 g
s
.966 .687 .452 r
.63718 .77882 m .63312 .77165 L .62887 .78703 L p F P
0 g
s
.966 .687 .452 r
.62887 .78703 m .63282 .79488 L .63718 .77882 L p F P
0 g
s
.966 .687 .452 r
.58176 .60612 m .57768 .60443 L .57969 .61618 L p F P
0 g
s
.966 .687 .452 r
.57969 .61618 m .58393 .61882 L .58176 .60612 L p F P
0 g
s
.966 .687 .452 r
.55483 .53389 m .55709 .52999 L .55143 .5185 L p F P
0 g
s
.966 .687 .452 r
.55709 .52999 m .55483 .53389 L .55974 .54504 L p F P
0 g
s
.966 .687 .452 r
.52632 .44263 m .52632 .4501 L .53476 .46079 L p F P
0 g
s
.966 .687 .452 r
.53428 .46765 m .53476 .46079 L .52632 .4501 L p F P
0 g
s
.966 .687 .452 r
.58981 .6347 m .58548 .63117 L .58636 .64305 L p F P
0 g
s
.966 .687 .452 r
.58636 .64305 m .59078 .64746 L .58981 .6347 L p F P
0 g
s
.966 .687 .452 r
.59516 .65184 m .59078 .64746 L .59102 .65959 L p F P
0 g
s
.966 .687 .452 r
.59102 .65959 m .59545 .66482 L .59516 .65184 L p F P
0 g
s
.966 .687 .452 r
.56501 .5696 m .56836 .56843 L .56427 .5566 L p F P
0 g
s
.966 .687 .452 r
.56836 .56843 m .56501 .5696 L .56834 .58064 L p F P
0 g
s
.966 .687 .452 r
.56834 .58064 m .57199 .58043 L .56836 .56843 L p F P
0 g
s
.966 .687 .452 r
.61936 .72831 m .61512 .7217 L .61256 .73535 L p F P
0 g
s
.966 .687 .452 r
.61256 .73535 m .6167 .74266 L .61936 .72831 L p F P
0 g
s
.966 .687 .452 r
.57199 .58043 m .56834 .58064 L .57121 .59172 L p F P
0 g
s
.966 .687 .452 r
.57121 .59172 m .5751 .59247 L .57199 .58043 L p F P
0 g
s
.966 .687 .452 r
.54115 .4851 m .5402 .49135 L .54687 .50215 L p F P
0 g
s
.966 .687 .452 r
.54547 .50767 m .54687 .50215 L .5402 .49135 L p F P
0 g
s
.966 .687 .452 r
.54687 .50215 m .54547 .50767 L .55143 .5185 L p F P
0 g
s
.966 .687 .452 r
.63312 .77165 m .62904 .76444 L .62492 .77917 L p F P
0 g
s
.966 .687 .452 r
.62492 .77917 m .62887 .78703 L .63312 .77165 L p F P
0 g
s
.966 .687 .452 r
.56124 .55871 m .56427 .5566 L .55974 .54504 L p F P
0 g
s
.966 .687 .452 r
.56427 .5566 m .56124 .55871 L .56501 .5696 L p F P
0 g
s
.966 .687 .452 r
.53428 .46765 m .53381 .47456 L .54115 .4851 L p F P
0 g
s
.966 .687 .452 r
.5402 .49135 m .54115 .4851 L .53381 .47456 L p F P
0 g
s
.966 .687 .452 r
.58393 .61882 m .57969 .61618 L .58111 .62762 L p F P
0 g
s
.966 .687 .452 r
.58111 .62762 m .58548 .63117 L .58393 .61882 L p F P
0 g
s
.966 .687 .452 r
.60804 .69491 m .6037 .68897 L .60231 .7017 L p F P
0 g
s
.966 .687 .452 r
.60231 .7017 m .6066 .7084 L .60804 .69491 L p F P
0 g
s
.966 .687 .452 r
.54958 .52325 m .55143 .5185 L .54547 .50767 L p F P
0 g
s
.966 .687 .452 r
.55143 .5185 m .54958 .52325 L .55483 .53389 L p F P
0 g
s
.966 .687 .452 r
.5751 .59247 m .57121 .59172 L .57358 .60272 L p F P
0 g
s
.966 .687 .452 r
.57358 .60272 m .57768 .60443 L .5751 .59247 L p F P
0 g
s
.966 .687 .452 r
.59984 .67002 m .59545 .66482 L .59495 .67699 L p F P
0 g
s
.966 .687 .452 r
.59495 .67699 m .59934 .683 L .59984 .67002 L p F P
0 g
s
.966 .687 .452 r
.55707 .54808 m .55974 .54504 L .55483 .53389 L p F P
0 g
s
.966 .687 .452 r
.55974 .54504 m .55707 .54808 L .56124 .55871 L p F P
0 g
s
.966 .687 .452 r
.52632 .4501 m .52632 .4576 L .53428 .46765 L p F P
0 g
s
.966 .687 .452 r
.53381 .47456 m .53428 .46765 L .52632 .4576 L p F P
0 g
s
.966 .687 .452 r
.62904 .76444 m .62494 .75721 L .62095 .77128 L p F P
0 g
s
.966 .687 .452 r
.62095 .77128 m .62492 .77917 L .62904 .76444 L p F P
0 g
s
.966 .687 .452 r
.57768 .60443 m .57358 .60272 L .57542 .61353 L p F P
0 g
s
.966 .687 .452 r
.57542 .61353 m .57969 .61618 L .57768 .60443 L p F P
0 g
s
.966 .687 .452 r
.61512 .7217 m .61087 .71507 L .60841 .72801 L p F P
0 g
s
.966 .687 .452 r
.60841 .72801 m .61256 .73535 L .61512 .7217 L p F P
0 g
s
.966 .687 .452 r
.55255 .53782 m .55483 .53389 L .54958 .52325 L p F P
0 g
s
.966 .687 .452 r
.55483 .53389 m .55255 .53782 L .55707 .54808 L p F P
0 g
s
.966 .687 .452 r
.59078 .64746 m .58636 .64305 L .58658 .65433 L p F P
0 g
s
.966 .687 .452 r
.58658 .65433 m .59102 .65959 L .59078 .64746 L p F P
0 g
s
.966 .687 .452 r
.58548 .63117 m .58111 .62762 L .58192 .63861 L p F P
0 g
s
.966 .687 .452 r
.58192 .63861 m .58636 .64305 L .58548 .63117 L p F P
0 g
s
.966 .687 .452 r
.6037 .68897 m .59934 .683 L .598 .69497 L p F P
0 g
s
.966 .687 .452 r
.598 .69497 m .60231 .7017 L .6037 .68897 L p F P
0 g
s
.966 .687 .452 r
.5402 .49135 m .53925 .49763 L .54547 .50767 L p F P
0 g
s
.966 .687 .452 r
.54405 .51324 m .54547 .50767 L .53925 .49763 L p F P
0 g
s
.966 .687 .452 r
.54547 .50767 m .54405 .51324 L .54958 .52325 L p F P
0 g
s
.966 .687 .452 r
.53381 .47456 m .53333 .4815 L .5402 .49135 L p F P
0 g
s
.966 .687 .452 r
.53925 .49763 m .5402 .49135 L .53333 .4815 L p F P
0 g
s
.966 .687 .452 r
.56163 .57077 m .56501 .5696 L .56124 .55871 L p F P
0 g
s
.966 .687 .452 r
.56501 .5696 m .56163 .57077 L .56467 .58085 L p F P
0 g
s
.966 .687 .452 r
.56467 .58085 m .56834 .58064 L .56501 .5696 L p F P
0 g
s
.966 .687 .452 r
.64457 .81826 m .64067 .81049 L .63466 .82568 L p F P
0 g
s
.966 .687 .452 r
.63466 .82568 m .63841 .83407 L .64457 .81826 L p F P
0 g
s
.966 .687 .452 r
.59545 .66482 m .59102 .65959 L .59054 .67095 L p F P
0 g
s
.966 .687 .452 r
.59054 .67095 m .59495 .67699 L .59545 .66482 L p F P
0 g
s
.966 .687 .452 r
.62494 .75721 m .62083 .74995 L .61698 .76337 L p F P
0 g
s
.966 .687 .452 r
.61698 .76337 m .62095 .77128 L .62494 .75721 L p F P
0 g
s
.966 .687 .452 r
.56834 .58064 m .56467 .58085 L .56729 .59096 L p F P
0 g
s
.966 .687 .452 r
.56729 .59096 m .57121 .59172 L .56834 .58064 L p F P
0 g
s
.966 .687 .452 r
.57969 .61618 m .57542 .61353 L .57672 .62404 L p F P
0 g
s
.966 .687 .452 r
.57672 .62404 m .58111 .62762 L .57969 .61618 L p F P
0 g
s
.966 .687 .452 r
.55819 .56083 m .56124 .55871 L .55707 .54808 L p F P
0 g
s
.966 .687 .452 r
.56124 .55871 m .55819 .56083 L .56163 .57077 L p F P
0 g
s
.966 .687 .452 r
.54772 .52804 m .54958 .52325 L .54405 .51324 L p F P
0 g
s
.966 .687 .452 r
.54958 .52325 m .54772 .52804 L .55255 .53782 L p F P
0 g
s
.966 .687 .452 r
.61087 .71507 m .6066 .7084 L .60423 .72064 L p F P
0 g
s
.966 .687 .452 r
.60423 .72064 m .60841 .72801 L .61087 .71507 L p F P
0 g
s
.966 .687 .452 r
.52632 .4576 m .52632 .46514 L .53381 .47456 L p F P
0 g
s
.966 .687 .452 r
.53333 .4815 m .53381 .47456 L .52632 .46514 L p F P
0 g
s
.966 .687 .452 r
.57121 .59172 m .56729 .59096 L .56944 .601 L p F P
0 g
s
.966 .687 .452 r
.56944 .601 m .57358 .60272 L .57121 .59172 L p F P
0 g
s
.966 .687 .452 r
.55438 .55113 m .55707 .54808 L .55255 .53782 L p F P
0 g
s
.966 .687 .452 r
.55707 .54808 m .55438 .55113 L .55819 .56083 L p F P
0 g
s
.966 .687 .452 r
.64067 .81049 m .63675 .80269 L .63091 .81728 L p F P
0 g
s
.966 .687 .452 r
.63091 .81728 m .63466 .82568 L .64067 .81049 L p F P
0 g
s
.966 .687 .452 r
.62083 .74995 m .6167 .74266 L .61298 .75543 L p F P
0 g
s
.966 .687 .452 r
.61298 .75543 m .61698 .76337 L .62083 .74995 L p F P
0 g
s
.966 .687 .452 r
.59934 .683 m .59495 .67699 L .59368 .68821 L p F P
0 g
s
.966 .687 .452 r
.59368 .68821 m .598 .69497 L .59934 .683 L p F P
0 g
s
.966 .687 .452 r
.57358 .60272 m .56944 .601 L .57112 .61086 L p F P
0 g
s
.966 .687 .452 r
.57112 .61086 m .57542 .61353 L .57358 .60272 L p F P
0 g
s
.966 .687 .452 r
.58636 .64305 m .58192 .63861 L .5821 .64904 L p F P
0 g
s
.966 .687 .452 r
.5821 .64904 m .58658 .65433 L .58636 .64305 L p F P
0 g
s
.966 .687 .452 r
.55026 .54177 m .55255 .53782 L .54772 .52804 L p F P
0 g
s
.966 .687 .452 r
.55255 .53782 m .55026 .54177 L .55438 .55113 L p F P
0 g
s
.966 .687 .452 r
.58111 .62762 m .57672 .62404 L .57745 .63414 L p F P
0 g
s
.966 .687 .452 r
.57745 .63414 m .58192 .63861 L .58111 .62762 L p F P
0 g
s
.966 .687 .452 r
.53333 .4815 m .53285 .48849 L .53925 .49763 L p F P
0 g
s
.966 .687 .452 r
.53829 .50395 m .53925 .49763 L .53285 .48849 L p F P
0 g
s
.966 .687 .452 r
.53925 .49763 m .53829 .50395 L .54405 .51324 L p F P
0 g
s
.966 .687 .452 r
.59102 .65959 m .58658 .65433 L .58611 .66489 L p F P
0 g
s
.966 .687 .452 r
.58611 .66489 m .59054 .67095 L .59102 .65959 L p F P
0 g
s
.966 .687 .452 r
.6066 .7084 m .60231 .7017 L .60004 .71324 L p F P
0 g
s
.966 .687 .452 r
.60004 .71324 m .60423 .72064 L .6066 .7084 L p F P
0 g
s
.966 .687 .452 r
.63675 .80269 m .63282 .79488 L .62715 .80885 L p F P
0 g
s
.966 .687 .452 r
.62715 .80885 m .63091 .81728 L .63675 .80269 L p F P
0 g
s
.966 .687 .452 r
.54263 .51884 m .54405 .51324 L .53829 .50395 L p F P
0 g
s
.966 .687 .452 r
.54405 .51324 m .54263 .51884 L .54772 .52804 L p F P
0 g
s
.966 .687 .452 r
.52632 .46514 m .52632 .47272 L .53333 .4815 L p F P
0 g
s
.966 .687 .452 r
.53285 .48849 m .53333 .4815 L .52632 .47272 L p F P
0 g
s
.966 .687 .452 r
.57542 .61353 m .57112 .61086 L .57229 .62044 L p F P
0 g
s
.966 .687 .452 r
.57229 .62044 m .57672 .62404 L .57542 .61353 L p F P
0 g
s
.966 .687 .452 r
.6167 .74266 m .61256 .73535 L .60898 .74747 L p F P
0 g
s
.966 .687 .452 r
.60898 .74747 m .61298 .75543 L .6167 .74266 L p F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .56163 .57077 L .55819 .56083 L p F P
0 g
s
.966 .687 .452 r
.56163 .57077 m .55823 .57195 L .56097 .58106 L p F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .56467 .58085 L .56163 .57077 L p F P
0 g
s
.966 .687 .452 r
.56467 .58085 m .56097 .58106 L .56333 .59019 L p F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56729 .59096 L .56467 .58085 L p F P
0 g
s
.966 .687 .452 r
.54585 .53286 m .54772 .52804 L .54263 .51884 L p F P
0 g
s
.966 .687 .452 r
.54772 .52804 m .54585 .53286 L .55026 .54177 L p F P
0 g
s
.966 .687 .452 r
.55511 .56297 m .55819 .56083 L .55438 .55113 L p F P
0 g
s
.966 .687 .452 r
.55819 .56083 m .55511 .56297 L .55823 .57195 L p F P
0 g
s
.966 .687 .452 r
.63282 .79488 m .62887 .78703 L .62338 .8004 L p F P
0 g
s
.966 .687 .452 r
.62338 .8004 m .62715 .80885 L .63282 .79488 L p F P
0 g
s
.966 .687 .452 r
.59495 .67699 m .59054 .67095 L .58933 .68143 L p F P
0 g
s
.966 .687 .452 r
.58933 .68143 m .59368 .68821 L .59495 .67699 L p F P
0 g
s
.966 .687 .452 r
.56729 .59096 m .56333 .59019 L .56528 .59926 L p F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56944 .601 L .56729 .59096 L p F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .55438 .55113 L .55026 .54177 L p F P
0 g
s
.966 .687 .452 r
.55438 .55113 m .55168 .55421 L .55511 .56297 L p F P
0 g
s
.966 .687 .452 r
.60231 .7017 m .598 .69497 L .59584 .70581 L p F P
0 g
s
.966 .687 .452 r
.59584 .70581 m .60004 .71324 L .60231 .7017 L p F P
0 g
s
.966 .687 .452 r
.58192 .63861 m .57745 .63414 L .5776 .64371 L p F P
0 g
s
.966 .687 .452 r
.5776 .64371 m .5821 .64904 L .58192 .63861 L p F P
0 g
s
.966 .687 .452 r
.61256 .73535 m .60841 .72801 L .60497 .73948 L p F P
0 g
s
.966 .687 .452 r
.60497 .73948 m .60898 .74747 L .61256 .73535 L p F P
0 g
s
.966 .687 .452 r
.58658 .65433 m .5821 .64904 L .58165 .65879 L p F P
0 g
s
.966 .687 .452 r
.58165 .65879 m .58611 .66489 L .58658 .65433 L p F P
0 g
s
.966 .687 .452 r
.56944 .601 m .56528 .59926 L .56678 .60817 L p F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .57112 .61086 L .56944 .601 L p F P
0 g
s
.966 .687 .452 r
.53285 .48849 m .53236 .49551 L .53829 .50395 L p F P
0 g
s
.966 .687 .452 r
.53733 .51032 m .53829 .50395 L .53236 .49551 L p F P
0 g
s
.966 .687 .452 r
.53829 .50395 m .53733 .51032 L .54263 .51884 L p F P
0 g
s
.966 .687 .452 r
.57672 .62404 m .57229 .62044 L .57295 .62964 L p F P
0 g
s
.966 .687 .452 r
.57295 .62964 m .57745 .63414 L .57672 .62404 L p F P
0 g
s
.966 .687 .452 r
.62887 .78703 m .62492 .77917 L .6196 .79194 L p F P
0 g
s
.966 .687 .452 r
.6196 .79194 m .62338 .8004 L .62887 .78703 L p F P
0 g
s
.966 .687 .452 r
.54794 .54576 m .55026 .54177 L .54585 .53286 L p F P
0 g
s
.966 .687 .452 r
.55026 .54177 m .54794 .54576 L .55168 .55421 L p F P
0 g
s
.966 .687 .452 r
.5412 .52448 m .54263 .51884 L .53733 .51032 L p F P
0 g
s
.966 .687 .452 r
.54263 .51884 m .5412 .52448 L .54585 .53286 L p F P
0 g
s
.966 .687 .452 r
.52632 .47272 m .52632 .48034 L .53285 .48849 L p F P
0 g
s
.966 .687 .452 r
.53236 .49551 m .53285 .48849 L .52632 .48034 L p F P
0 g
s
.966 .687 .452 r
.59054 .67095 m .58611 .66489 L .58496 .67461 L p F P
0 g
s
.966 .687 .452 r
.58496 .67461 m .58933 .68143 L .59054 .67095 L p F P
0 g
s
.966 .687 .452 r
.57112 .61086 m .56678 .60817 L .56784 .61682 L p F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .57229 .62044 L .57112 .61086 L p F P
0 g
s
.966 .687 .452 r
.598 .69497 m .59368 .68821 L .59162 .69836 L p F P
0 g
s
.966 .687 .452 r
.59162 .69836 m .59584 .70581 L .598 .69497 L p F P
0 g
s
.966 .687 .452 r
.62492 .77917 m .62095 .77128 L .61581 .78346 L p F P
0 g
s
.966 .687 .452 r
.61581 .78346 m .6196 .79194 L .62492 .77917 L p F P
0 g
s
.966 .687 .452 r
.60841 .72801 m .60423 .72064 L .60094 .73147 L p F P
0 g
s
.966 .687 .452 r
.60094 .73147 m .60497 .73948 L .60841 .72801 L p F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .54585 .53286 L .5412 .52448 L p F P
0 g
s
.966 .687 .452 r
.54585 .53286 m .54396 .53771 L .54794 .54576 L p F P
0 g
s
.637 .548 .738 r
.54459 .5667 m .54656 .57521 L .55565 .57266 L p F P
0 g
s
.642 .571 .76 r
.54241 .55836 m .54459 .5667 L .55279 .56439 L p F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .55511 .56297 L p .5549 .56977 L F P
0 g
s
.642 .571 .76 r
.55192 .56216 m .54241 .55836 L .55279 .56439 L F
.647 .594 .781 r
.54004 .55028 m .54241 .55836 L .54963 .55631 L p F P
0 g
s
.966 .687 .452 r
.55511 .56297 m .55168 .55421 L p .5519 .56147 L F P
0 g
s
.647 .594 .781 r
.54866 .55412 m .54004 .55028 L .54963 .55631 L F
.652 .618 .803 r
.53751 .54256 m .54004 .55028 L .54619 .54853 L p F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .54794 .54576 L p .54861 .5534 L F P
0 g
s
.652 .618 .803 r
.54513 .54637 m .53751 .54256 L .54619 .54853 L F
.966 .687 .452 r
.54794 .54576 m .54396 .53771 L p .5451 .54605 L F P
0 g
s
.647 .594 .781 r
.54619 .54853 m .54004 .55028 L p .54866 .55412 L F P
0 g
s
.966 .687 .452 r
.54626 .54867 m .54794 .54576 L p .5451 .54605 L F P
0 g
s
.642 .571 .76 r
.54963 .55631 m .54241 .55836 L p .55192 .56216 L F P
0 g
s
.966 .687 .452 r
.54794 .54576 m .54561 .54978 L .54895 .55732 L p F P
0 g
s
.652 .618 .803 r
.54253 .54112 m .53751 .54256 L p .54513 .54637 L F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .53976 .53015 L p .54141 .53911 L F P
0 g
s
.656 .643 .825 r
.53485 .53527 m .53751 .54256 L .54253 .54112 L p F P
0 g
s
.656 .643 .825 r
.54135 .539 m .53485 .53527 L .54253 .54112 L F
.966 .687 .452 r
.54205 .5426 m .54259 .54123 L p .54141 .53911 L F P
0 g
s
.966 .687 .452 r
.54259 .54123 m .54396 .53771 L p .54141 .53911 L F P
0 g
s
.966 .687 .452 r
.54205 .5426 m .54561 .54978 L p .54505 .54566 L F P
0 g
s
.966 .687 .452 r
.54396 .53771 m .54259 .54123 L p .54505 .54566 L F P
0 g
s
.966 .687 .452 r
.54259 .54123 m .54205 .5426 L p .54505 .54566 L F P
0 g
s
.656 .643 .825 r
.53866 .53417 m .53485 .53527 L p .54135 .539 L F P
0 g
s
.966 .687 .452 r
.53976 .53015 m .53538 .52316 L p .53748 .53227 L F P
0 g
s
.659 .669 .849 r
.53207 .52849 m .53485 .53527 L .53866 .53417 L p F P
0 g
s
.659 .669 .849 r
.53733 .53204 m .53207 .52849 L .53866 .53417 L F
.966 .687 .452 r
.5383 .53587 m .53871 .53425 L p .53748 .53227 L F P
0 g
s
.966 .687 .452 r
.53871 .53425 m .53976 .53015 L p .53748 .53227 L F P
0 g
s
.966 .687 .452 r
.5383 .53587 m .54205 .5426 L p .54126 .53832 L F P
0 g
s
.966 .687 .452 r
.53976 .53015 m .53871 .53425 L p .54126 .53832 L F P
0 g
s
.966 .687 .452 r
.53871 .53425 m .5383 .53587 L p .54126 .53832 L F P
0 g
s
.659 .669 .849 r
.53465 .52775 m .53207 .52849 L p .53733 .53204 L F P
0 g
s
.966 .687 .452 r
.53538 .52316 m .53089 .51682 L p .5334 .526 L F P
0 g
s
.661 .697 .873 r
.52922 .52231 m .53207 .52849 L .53465 .52775 L p F P
0 g
s
.661 .697 .873 r
.533 .52543 m .52922 .52231 L .53465 .52775 L F
.966 .687 .452 r
.5344 .52965 m .53468 .5278 L p .5334 .526 L F P
0 g
s
.966 .687 .452 r
.53468 .5278 m .53538 .52316 L p .5334 .526 L F P
0 g
s
.966 .687 .452 r
.5344 .52965 m .5383 .53587 L p .53729 .53148 L F P
0 g
s
.966 .687 .452 r
.53538 .52316 m .53468 .5278 L p .53729 .53148 L F P
0 g
s
.966 .687 .452 r
.53468 .5278 m .5344 .52965 L p .53729 .53148 L F P
0 g
s
.661 .697 .873 r
.53052 .52193 m .52922 .52231 L p .533 .52543 L F P
0 g
s
.966 .687 .452 r
.53089 .51682 m .52632 .51121 L p .52923 .52036 L F P
0 g
s
.662 .728 .899 r
.52632 .51679 m .52922 .52231 L .53052 .52193 L p F P
0 g
s
.966 .687 .452 r
.53039 .52401 m .53053 .52196 L p .52923 .52036 L F P
0 g
s
.966 .687 .452 r
.53053 .52196 m .53089 .51682 L p .52923 .52036 L F P
0 g
s
.966 .687 .452 r
.53089 .51682 m .53039 .52401 L .5344 .52965 L p F P
0 g
s
.672 .703 .87 r
.53207 .52849 m .52922 .52231 L .52735 .52257 L p F P
0 g
s
.669 .733 .897 r
.52735 .52257 m .52632 .51679 L .52544 .52258 L closepath p F P
0 g
s
.666 .73 .898 r
.52922 .52231 m .52632 .51679 L .52735 .52257 L closepath p F P
0 g
s
.966 .687 .452 r
.52632 .51121 m .52632 .51903 L .53039 .52401 L p F P
0 g
s
.662 .728 .899 r
.53052 .52193 m .53095 .52181 L .52632 .51679 L p F P
0 g
s
.661 .697 .873 r
.53551 .5275 m .53095 .52181 L .53052 .52193 L p F P
0 g
s
.661 .697 .873 r
.53551 .5275 m .53052 .52193 L .533 .52543 L F
.53465 .52775 m .53551 .5275 L p .533 .52543 L F P
0 g
s
.659 .669 .849 r
.53994 .5338 m .53551 .5275 L .53465 .52775 L p F P
0 g
s
.659 .669 .849 r
.53994 .5338 m .53465 .52775 L .53733 .53204 L F
.53866 .53417 m .53994 .5338 L p .53733 .53204 L F P
0 g
s
.656 .643 .825 r
.54421 .54064 m .53994 .5338 L .53866 .53417 L p F P
0 g
s
.656 .643 .825 r
.54421 .54064 m .53866 .53417 L .54135 .539 L F
.54253 .54112 m .54421 .54064 L p .54135 .539 L F P
0 g
s
.652 .618 .803 r
.54826 .54794 m .54421 .54064 L .54253 .54112 L p F P
0 g
s
.652 .618 .803 r
.54826 .54794 m .54253 .54112 L .54513 .54637 L F
.966 .687 .452 r
.54561 .54978 m .54626 .54867 L p .54619 .54853 L F P
0 g
s
.966 .687 .452 r
.54515 .54643 m .54619 .54853 L .5451 .54605 L F
.54561 .54978 m .54619 .54853 L .54515 .54643 L F
.54881 .55382 m .55168 .55421 L .54861 .5534 L F
.54969 .55647 m .55168 .55421 L p .54864 .5538 L F P
0 g
s
.637 .548 .738 r
.55279 .56439 m .54459 .5667 L p .55488 .57042 L F P
0 g
s
.966 .687 .452 r
.55168 .55421 m .54895 .55732 L .55202 .56513 L p F P
0 g
s
.647 .594 .781 r
.55205 .55563 m .54826 .54794 L .54619 .54853 L p F P
0 g
s
.966 .687 .452 r
.54864 .5538 m .54881 .55382 L .54861 .5534 L F
.54895 .55732 m .54969 .55647 L p .54864 .5538 L F P
0 g
s
.647 .594 .781 r
.55205 .55563 m .54619 .54853 L .54866 .55412 L F
.652 .618 .803 r
.54619 .54853 m .54826 .54794 L p .54513 .54637 L F P
0 g
s
.966 .687 .452 r
.5521 .56192 m .55511 .56297 L .5519 .56147 L F
.55285 .56455 m .55511 .56297 L p .55191 .56185 L F P
0 g
s
.63 .525 .716 r
.55565 .57266 m .54656 .57521 L p .5575 .57882 L F P
0 g
s
.637 .548 .738 r
.55488 .57042 m .54459 .5667 L .55565 .57266 L F
.966 .687 .452 r
.55511 .56297 m .55202 .56513 L .55479 .57315 L p F P
0 g
s
.642 .571 .76 r
.55554 .56361 m .55205 .55563 L .54963 .55631 L p F P
0 g
s
.966 .687 .452 r
.55191 .56185 m .5521 .56192 L .5519 .56147 L F
.55202 .56513 m .55285 .56455 L p .55191 .56185 L F P
0 g
s
.642 .571 .76 r
.55554 .56361 m .54963 .55631 L .55192 .56216 L F
.647 .594 .781 r
.54963 .55631 m .55205 .55563 L p .54866 .55412 L F P
0 g
s
.637 .548 .738 r
.5587 .57181 m .55554 .56361 L .55279 .56439 L p F P
0 g
s
.966 .687 .452 r
.55489 .57014 m .55508 .57024 L .5549 .56977 L F
.55508 .57024 m .55823 .57195 L .5549 .56977 L F
.55488 .57043 m .55499 .57049 L .55489 .57014 L F
.637 .548 .738 r
.5587 .57181 m .55279 .56439 L .55488 .57042 L F
.642 .571 .76 r
.55279 .56439 m .55554 .56361 L p .55192 .56216 L F P
0 g
s
.966 .687 .452 r
.55499 .57049 m .55823 .57195 L .55489 .57014 L F
.55571 .57283 m .55823 .57195 L p .55488 .57043 L F P
0 g
s
.63 .525 .716 r
.54656 .57521 m .5483 .58381 L .55818 .58106 L p F P
0 g
s
.63 .525 .716 r
.5575 .57882 m .54656 .57521 L .55818 .58106 L F
.966 .687 .452 r
.55479 .57315 m .55725 .58127 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.55823 .57195 m .5557 .57283 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.5557 .57283 m .55479 .57315 L p .5575 .57882 L F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .55823 .57195 L p .55753 .57855 L F P
0 g
s
.966 .687 .452 r
.55725 .58127 m .55822 .58122 L p .55753 .57855 L F P
0 g
s
.966 .687 .452 r
.55822 .58122 m .56097 .58106 L p .55753 .57855 L F P
0 g
s
.624 .501 .693 r
.55818 .58106 m .5483 .58381 L p .55977 .58726 L F P
0 g
s
.624 .501 .693 r
.5483 .58381 m .54979 .59241 L .56034 .58948 L p F P
0 g
s
.624 .501 .693 r
.55977 .58726 m .5483 .58381 L .56034 .58948 L F
.966 .687 .452 r
.55725 .58127 m .55935 .58942 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.56097 .58106 m .55822 .58122 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.55822 .58122 m .55725 .58127 L p .55977 .58725 L F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56097 .58106 L p .55982 .58701 L F P
0 g
s
.966 .687 .452 r
.55935 .58942 m .56037 .58962 L p .55982 .58701 L F P
0 g
s
.966 .687 .452 r
.56037 .58962 m .56333 .59019 L p .55982 .58701 L F P
0 g
s
.616 .476 .669 r
.56034 .58948 m .54979 .59241 L p .56166 .59567 L F P
0 g
s
.616 .476 .669 r
.54979 .59241 m .55102 .60091 L .56213 .59784 L p F P
0 g
s
.616 .476 .669 r
.56166 .59567 m .54979 .59241 L .56213 .59784 L F
.966 .687 .452 r
.55935 .58942 m .56108 .59751 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56333 .59019 m .56037 .58962 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56037 .58962 m .55935 .58942 L p .56166 .59564 L F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56333 .59019 L p .56172 .59543 L F P
0 g
s
.966 .687 .452 r
.56108 .59751 m .56215 .59796 L p .56172 .59543 L F P
0 g
s
.966 .687 .452 r
.56215 .59796 m .56528 .59926 L p .56172 .59543 L F P
0 g
s
.607 .45 .642 r
.56213 .59784 m .55102 .60091 L p .56315 .60394 L F P
0 g
s
.607 .45 .642 r
.56315 .60394 m .55102 .60091 L .56351 .60606 L F
.966 .687 .452 r
.56108 .59751 m .56242 .60546 L p .56314 .60389 L F P
0 g
s
.966 .687 .452 r
.56528 .59926 m .56215 .59796 L p .56314 .60389 L F P
0 g
s
.966 .687 .452 r
.56215 .59796 m .56108 .59751 L p .56314 .60389 L F P
0 g
s
.607 .45 .642 r
.55102 .60091 m .55197 .60922 L .56351 .60606 L p F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .56528 .59926 L p .56323 .60371 L F P
0 g
s
.966 .687 .452 r
.56242 .60546 m .56352 .60614 L p .56323 .60371 L F P
0 g
s
.966 .687 .452 r
.56352 .60614 m .56678 .60817 L p .56323 .60371 L F P
0 g
s
.597 .421 .613 r
.56351 .60606 m .55197 .60922 L p .56423 .61199 L F P
0 g
s
.597 .421 .613 r
.56423 .61199 m .55197 .60922 L .56447 .61403 L F
.966 .687 .452 r
.56242 .60546 m .56335 .61317 L p .56421 .61191 L F P
0 g
s
.966 .687 .452 r
.56678 .60817 m .56352 .60614 L p .56421 .61191 L F P
0 g
s
.966 .687 .452 r
.56352 .60614 m .56242 .60546 L p .56421 .61191 L F P
0 g
s
.597 .421 .613 r
.55197 .60922 m .55264 .61726 L .56447 .61403 L p F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .56678 .60817 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.56335 .61317 m .56447 .61408 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.56447 .61408 m .56784 .61682 L p .56431 .61177 L F P
0 g
s
.966 .687 .452 r
.57229 .62044 m .56784 .61682 L .56842 .62512 L p F P
0 g
s
.585 .388 .581 r
.56447 .61403 m .55264 .61726 L p .56487 .61974 L F P
0 g
s
.585 .388 .581 r
.56487 .61974 m .55264 .61726 L .565 .62168 L F
.966 .687 .452 r
.56335 .61317 m .56386 .62056 L p .56486 .61962 L F P
0 g
s
.966 .687 .452 r
.56784 .61682 m .56447 .61408 L p .56486 .61962 L F P
0 g
s
.966 .687 .452 r
.56447 .61408 m .56335 .61317 L p .56486 .61962 L F P
0 g
s
.585 .388 .581 r
.55264 .61726 m .553 .62494 L .565 .62168 L p F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .56784 .61682 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.56386 .62056 m .565 .6217 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.565 .6217 m .56842 .62512 L p .56497 .61951 L F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .57295 .62964 L .57229 .62044 L p F P
0 g
s
.966 .687 .452 r
.57295 .62964 m .56842 .62512 L .56852 .63297 L p F P
0 g
s
.571 .351 .543 r
.565 .62168 m .553 .62494 L p .56507 .62711 L F P
0 g
s
.571 .351 .543 r
.56507 .62711 m .553 .62494 L .56509 .62892 L F
.966 .687 .452 r
.56386 .62056 m .56395 .62756 L p .56507 .62694 L F P
0 g
s
.966 .687 .452 r
.56842 .62512 m .565 .6217 L p .56507 .62694 L F P
0 g
s
.966 .687 .452 r
.565 .6217 m .56386 .62056 L p .56507 .62694 L F P
0 g
s
.571 .351 .543 r
.553 .62494 m .55306 .63218 L .56509 .62892 L p F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .56842 .62512 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56395 .62756 m .56509 .62891 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56509 .62891 m .56852 .63297 L p .5652 .62687 L F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .57308 .63836 L .57295 .62964 L p F P
0 g
s
.966 .687 .452 r
.57308 .63836 m .56852 .63297 L .56815 .6403 L p F P
0 g
s
.553 .307 .498 r
.56509 .62892 m .55306 .63218 L p .56482 .63399 L F P
0 g
s
.553 .307 .498 r
.56482 .63399 m .55306 .63218 L .56473 .63567 L F
.966 .687 .452 r
.56395 .62756 m .5636 .63407 L p .56483 .6338 L F P
0 g
s
.966 .687 .452 r
.56852 .63297 m .56509 .62891 L p .56483 .6338 L F P
0 g
s
.966 .687 .452 r
.56509 .62891 m .56395 .62756 L p .56483 .6338 L F P
0 g
s
.553 .307 .498 r
.55306 .63218 m .55282 .63888 L .56473 .63567 L p F P
0 g
s
.966 .687 .452 r
.56815 .6403 m .56852 .63297 L p .56498 .63376 L F P
0 g
s
.966 .687 .452 r
.5636 .63407 m .56474 .63563 L p .56498 .63376 L F P
0 g
s
.966 .687 .452 r
.56474 .63563 m .56815 .6403 L p .56498 .63376 L F P
0 g
s
.529 .254 .442 r
.56473 .63567 m .55282 .63888 L p .56413 .64033 L F P
0 g
s
.966 .687 .452 r
.56815 .6403 m .5636 .63407 L .56282 .64004 L p F P
0 g
s
.966 .687 .452 r
.56729 .64701 m .56815 .6403 L p .56433 .64011 L F P
0 g
s
.966 .687 .452 r
.56427 .64035 m .56729 .64701 L .56433 .64011 L F
.56394 .64179 m .56729 .64701 L p .56416 .6401 L F P
0 g
s
.497 .188 .373 r
.56394 .64186 m .55227 .64499 L p .563 .64604 L F P
0 g
s
.529 .254 .442 r
.55282 .63888 m .55227 .64499 L .56394 .64186 L p F P
0 g
s
.529 .254 .442 r
.56413 .64033 m .55282 .63888 L .56394 .64186 L F
.966 .687 .452 r
.56282 .64004 m .56161 .64538 L p .56306 .64579 L F P
0 g
s
.966 .687 .452 r
.56729 .64701 m .56439 .64249 L p .56323 .64584 L F P
0 g
s
.497 .188 .373 r
.563 .64604 m .55227 .64499 L .5627 .6474 L F
.966 .687 .452 r
.56161 .64538 m .56595 .65303 L .56729 .64701 L p F P
0 g
s
.453 .103 .281 r
.5627 .6474 m .55142 .65041 L p .56143 .65106 L F P
0 g
s
.497 .188 .373 r
.55227 .64499 m .55142 .65041 L .5627 .6474 L p F P
0 g
s
.966 .687 .452 r
.56161 .64538 m .55999 .65003 L p .56152 .6508 L F P
0 g
s
.966 .687 .452 r
.56595 .65303 m .56315 .64809 L p .56171 .6509 L F P
0 g
s
.453 .103 .281 r
.56143 .65106 m .55142 .65041 L .56103 .65223 L F
.966 .687 .452 r
.55999 .65003 m .56415 .65828 L .56595 .65303 L p F P
0 g
s
.389 0 .157 r
.56103 .65223 m .55027 .6551 L p .55945 .65532 L F P
0 g
s
.453 .103 .281 r
.55142 .65041 m .55027 .6551 L .56103 .65223 L p F P
0 g
s
.966 .687 .452 r
.55999 .65003 m .55797 .65393 L p .55958 .65506 L F P
0 g
s
.966 .687 .452 r
.56415 .65828 m .56148 .65298 L p .55978 .65521 L F P
0 g
s
.389 0 .157 r
.55945 .65532 m .55027 .6551 L .55895 .65629 L F
.966 .687 .452 r
.55797 .65393 m .56189 .6627 L .56415 .65828 L p F P
0 g
s
.293 0 0 r
.55895 .65629 m .54883 .65898 L p .55706 .65876 L F P
0 g
s
.389 0 .157 r
.55027 .6551 m .54883 .65898 L .55895 .65629 L p F P
0 g
s
.966 .687 .452 r
.55797 .65393 m .55557 .65703 L p .55723 .65853 L F P
0 g
s
.966 .687 .452 r
.56189 .6627 m .55939 .6571 L p .55744 .65872 L F P
0 g
s
.293 0 0 r
.55706 .65876 m .54883 .65898 L .55647 .65952 L F
.966 .687 .452 r
.55557 .65703 m .5592 .66622 L .56189 .6627 L p F P
0 g
s
.148 0 0 r
.55647 .65952 m .54713 .66201 L p .55429 .66134 L F P
0 g
s
.293 0 0 r
.54883 .65898 m .54713 .66201 L .55647 .65952 L p F P
0 g
s
.966 .687 .452 r
.55557 .65703 m .5528 .65929 L p .55451 .66115 L F P
0 g
s
.966 .687 .452 r
.5592 .66622 m .55689 .66039 L p .55473 .66138 L F P
0 g
s
.148 0 0 r
.55429 .66134 m .54713 .66201 L .55363 .66189 L F
.966 .687 .452 r
.5528 .65929 m .5561 .6688 L .5592 .66622 L p F P
0 g
s
0 0 0 r
.55363 .66189 m .54517 .66413 L p .55117 .66301 L F P
0 g
s
.148 0 0 r
.54713 .66201 m .54517 .66413 L .55363 .66189 L p F P
0 g
s
.966 .687 .452 r
.5528 .65929 m .54971 .66067 L p .55144 .66288 L F P
0 g
s
.966 .687 .452 r
.55144 .66288 m .55166 .66316 L .55369 .66186 L F
.55402 .66281 m .55369 .66186 L 