(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    719713,      17908]*)
(*NotebookOutlinePosition[    721341,      17957]*)
(*  CellTagsIndexPosition[    721265,      17951]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Campos conservativos. Teorema de Green", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell["<<Graphics`Arrow`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell["<<Graphics`Colors`", "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],

Cell[BoxData[{
    \(vector2D[x_: {0, 0}, y_] := Arrow[x, x + y]\ \), "\n", 
    \(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \), "\n", 
    \(\(normaliza[x_]\  := 
        If[Simplify[x . x] == 0, x, \ x/norma[x]];\)\ \n\), "\n", 
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(curvacerradasimple := 
      Module[{graf1, vectgnteunit, vectnormalunit, \[Gamma]}, \[Gamma][t_] = 
          2 {\(-Sin[\[Pi]\ t]\) + 1\/5\ Cos[4\ \[Pi]\ t], 
              Cos[\[Pi]\ t] - 1\/8\ Sin[4  \[Pi]\ t]}; \n
        graf1 = ParametricPlot[\[Gamma][t], {t, 0, 2}, 
            PlotStyle \[Rule] {Thickness[0.01], Hue[0]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            Epilog -> {{Hue[0. ], 
                  Arrow[\[Gamma][ .15], \[Gamma][ .16], HeadLength ->  .07], 
                  Arrow[\[Gamma][ .55], \[Gamma][ .56], 
                    HeadLength ->  .07], \[IndentingNewLine]Arrow[\[Gamma][ \
.93], \[Gamma][ .94], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.35], \[Gamma][1.36], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.75], \[Gamma][1.76], HeadLength ->  .07]}, 
                Text["\<D\>", 1.5 { .4,  .4}], 
                Text["\<\[Gamma]\>", 2 { .75,  .6}]}, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14}, 
            Ticks -> None, PlotRange -> All, AspectRatio -> Automatic, 
            DisplayFunction \[Rule] 
              Identity]; \[IndentingNewLine]vectgnteunit = 
          Graphics[\n\t\tTable[{{Blue, 
                  vector2D[\[Gamma][t], tgtunit[\[Gamma], t]]}, {Red, 
                  PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0. , 2, 
                2/5. }]]; \n
        vectnormalunit = 
          Graphics[\n\t\tTable[
              If[Det[{tgtunit[\[Gamma], t], normalunit[\[Gamma], t]}] > 
                  0, {Green, 
                  vector2D[\[Gamma][t], normalunit[\[Gamma], t]]}, {Green, 
                  vector2D[\[Gamma][t], \(-normalunit[\[Gamma], t]\)]}], {t, 
                0. , 2, 2/5. }]]; \n
        Show[{graf1, vectgnteunit, vectnormalunit}, AspectRatio -> Automatic, 
          DisplayFunction -> $DisplayFunction]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(dominioconagujeros := 
      Module[{graf1, \[Gamma]}, \[IndentingNewLine]\[Gamma][t_] = 
          2 {\(-Sin[\[Pi]\ t]\) + 1\/5\ Cos[4\ \[Pi]\ t], 
              Cos[\[Pi]\ t] - 1\/8\ Sin[4  \[Pi]\ t]}; \n
        graf1 = ParametricPlot[\[Gamma][t], {t, 0, 2}, 
            PlotStyle \[Rule] {Thickness[0.01], Hue[0]}, 
            AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
            Epilog -> {{Hue[0. ], 
                  Arrow[\[Gamma][ .15], \[Gamma][ .16], HeadLength ->  .07], 
                  Arrow[\[Gamma][ .55], \[Gamma][ .56], 
                    HeadLength ->  .07], \[IndentingNewLine]Arrow[\[Gamma][ \
.93], \[Gamma][ .94], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.35], \[Gamma][1.36], HeadLength ->  .07], 
                  Arrow[\[Gamma][1.75], \[Gamma][1.76], HeadLength ->  .07]}, 
                Text["\<D\>", 1.5 { .4,  .4}], 
                Text["\<\[Gamma]\>", 2 { .75,  .6}]}, 
            TextStyle -> {FontFamily -> "\<Times\>", FontSize -> 14}, 
            Ticks -> None, PlotRange -> All, AspectRatio -> Automatic, 
            DisplayFunction \[Rule] Identity]; 
        Show[{graf1, 
            Graphics[{{Hue[0], Thickness[0.01], Circle[{ .5, \(- .5\)},  .3], 
                  Circle[{\(- .5\),  .5},  .3]}, {Hue[0], 
                  Arrow[{\(- .5\),  .5} +  .285 {Cos[ .15] +  .01, 
                          Sin[ .15]}, {\(- .5\),  .5} +  .3 {Cos[ .05] -  \
.035, Sin[ .05]}, HeadLength\  -> \  .035], 
                  Arrow[{ .5, \(- .5\)} +  .285 {Cos[ .15] +  .01, 
                          Sin[ .15]}, { .5, \(- .5\)} +  .3 {Cos[ .05] -  \
.025, Sin[ .05]}, HeadLength\  -> \  .037]}, 
                Text[\*"\"\<\!\(\[Gamma]\_1\)\>\"", { .8, \(- .1\)}], 
                Text[\*"\"\<\!\(\[Gamma]\_2\)\>\"", {\(- .2\),  .9}]}]}, 
          DisplayFunction -> $DisplayFunction]]\)], "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Campos conservativos", "Section"],

Cell[TextData[{
  "Recuerda que una integral de l\[IAcute]nea de un campo vectorial depende \
de DOS funciones: el campo vectorial  ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " y el camino \[Gamma]; necesitas conocer dichas funciones para poder \
calcular la integral. Para ello, todo lo que necesitas es obtener una \
primitiva, G, de la funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(g(t)\), "=", 
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold"], "(", \(\[Gamma](t)\), ")"}], "|", 
              \(\[Gamma]\ ' \((t)\)\)}], "\[RightAngleBracket]"}]}], 
        TraditionalForm]]],
  " y aplicar la regla de Barrow "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                  "|", " ", \(\[Gamma]' \((t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                StyleBox["g",
                  FontSlant->"Italic"], \((t)\), \(\[DifferentialD]t\)}]}], 
            "=", \(G \((b)\) - G \((a)\)\)}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que la funci\[OAcute]n ",
  StyleBox["g",
    FontSlant->"Italic"],
  " depende del camino \[Gamma]. Puede ocurrir que dos caminos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)]],
  " tengan los mismos puntos inicial y final pero las integrales ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox[" ",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  " sean distintas. El siguiente importante resultado nos dice que los campos \
vectoriales con la propiedad de que sus integrales de l\[IAcute]nea sobre \
cualquier camino dependen solamente de los puntos inicial y final del camino \
son campos de gradiente, y nos muestra c\[OAcute]mo calcular una integral de \
l\[IAcute]nea de un campo de gradiente."
}], "Text"],

Cell[TextData[{
  StyleBox["Teorema 1",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ", ",
  StyleBox["donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  ", ",
  StyleBox["un campo vectorial continuo",
    FontWeight->"Plain"],
  ". Las siguientes afirmaciones son equivalentes.\n",
  StyleBox["a) Para todo camino cerrado \[Gamma] en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{\(\[Integral]\_\[Gamma]\), 
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"]}],
            "TextForm"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox["0",
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[".\nb) La integral de l\[IAcute]nea de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" es independiente del camino, es decir, cualesquiera sean los \
caminos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" con los mismos puntos inicial y final se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], TextForm]]],
  StyleBox[".",
    FontWeight->"Plain"],
  "\nc) ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es un campo de gradiente, es decir, existe un campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " con derivadas parciales continuas tal que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", "x", ")"}], 
            "=", \(\[Del]\(f(x)\)\)}]}], TraditionalForm]]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] A\)]],
  ". \nSi el campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " verifica alguna de estas afirmaciones, en cuyo caso las verifica todas, \
se dice que es un ",
  StyleBox["campo conservativo",
    FontWeight->"Bold"],
  " (en ",
  StyleBox["A",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[TextData[{
  StyleBox["Demostraci\[OAcute]n",
    FontWeight->"Bold"],
  ". Es f\[AAcute]cil probar que a) es equivalente a b). No es tan \
f\[AAcute]cil probar que b) implica c) y no lo haremos aqu\[IAcute]. \
Probaremos que c) implica b). Para ello basta tener en cuenta que si ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " es una curva suave en ",
  StyleBox["A",
    FontSlant->"Italic"],
  ", entonces, por la regla de la cadena, se tiene que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`G(t) = f(\[Gamma](t))\)]],
  " es derivable y "
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`G\ ' \((t)\) = 
      \(\[LeftAngleBracket]\[Del]\(f(\[Gamma](t))\) | 
            \[Gamma]\ ' \((t)\)\[RightAngleBracket] = 
        \[LeftAngleBracket]F(\[Gamma](t)) | 
            \[Gamma]\ ' \((t)\)\[RightAngleBracket]\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es decir ",
  Cell[BoxData[
      \(TraditionalForm\`G(t) = f(\[Gamma](t))\)]],
  " es una primitiva de ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]F(\[Gamma](t)) | 
          \[Gamma]\ ' \((t)\)\[RightAngleBracket]\)]],
  ", luego"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["\[Del]",
                FontWeight->"Bold"], 
              StyleBox["f",
                FontWeight->"Plain",
                FontSlant->"Italic"]}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", \(\[Gamma]' \((t)\)\)}], 
                  "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  RowBox[{"\[LeftAngleBracket]", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"\[Del]", 
                          StyleBox["f",
                            FontSlant->"Italic"]}], \((\[Gamma] \((t)\))\)}], 
                      " ", "|", " ", \(\[Gamma]' \((t)\)\)}], 
                    "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], 
              "=", 
              RowBox[{
                RowBox[{\(\[Integral]\_a\%b\), 
                  RowBox[{
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], " ", "'"}], \((t)\), 
                    \(\[DifferentialD]t\)}]}], "=", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], \((b)\)}], "-", 
                    RowBox[{
                      StyleBox["G",
                        FontSlant->"Italic"], \((a)\)}]}], "=", 
                  RowBox[{
                    RowBox[{
                      StyleBox["f",
                        FontSlant->"Italic"], \((\[Gamma] \((b)\))\)}], "-", 
                    RowBox[{
                      StyleBox["f",
                        FontSlant->"Italic"], 
                      \((\[Gamma] \((a)\))\)}]}]}]}]}]}]}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "lo que prueba que la integral de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " a lo largo de \[Gamma] solamente depende de los puntos inicial y final de \
\[Gamma], por tanto ",
  StyleBox["cualesquiera sean los caminos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)],
    FontWeight->"Plain"],
  StyleBox[" y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)],
    FontWeight->"Plain"],
  StyleBox[" en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" con los mismos puntos inicial y final se verifica que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}], TextForm]]],
  "."
}], "Text"],

Cell["De la demostraci\[OAcute]n anterior debes recordar la igualdad ", "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              RowBox[{
                StyleBox["\[Del]",
                  FontWeight->"Bold"], 
                StyleBox["f",
                  FontWeight->"Plain",
                  FontSlant->"Italic"]}], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], \(\[DifferentialD]\[Gamma]\)}]}], "=", 
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], "(", "\[Beta]", ")"}], 
            "-", \(f(\[Alpha])\)}]}]], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["\<\
v\[AAcute]lida para cualquier camino \[Gamma] cuyo punto inicial sea \[Alpha] \
y cuyo punto final sea \[Beta].\
\>", "Text"],

Cell[TextData[{
  "En f\[IAcute]sica, cuando un campo vectorial ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es conservativo, a la funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " tal que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", \(\[Del]f\)}], TraditionalForm]]],
  " se le llama funci\[OAcute]n ",
  StyleBox["potencial",
    FontWeight->"Bold"],
  " de dicho campo y el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(-f\) \((x)\)\)]],
  " se llama ",
  StyleBox["energ\[IAcute]a potencial",
    FontWeight->"Bold"],
  " del punto ",
  StyleBox["x. ",
    FontSlant->"Italic"],
  "No hay en esto un criterio definido; algunos textos llaman funci\[OAcute]n \
potencial a la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-f\)\)]],
  ". Cuando ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " est\[AAcute] definido en un dominio (ver definici\[OAcute]n m\[AAcute]s \
adelante) la funci\[OAcute]n potencial, cuando existe, es \[UAcute]nica salvo \
una constante aditiva."
}], "Text"],

Cell[TextData[{
  "Conservaci\[OAcute]n de la energ\[IAcute]a en un campo de fuerzas \
conservativo",
  StyleBox[" ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Supongamos un objeto de masa ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " que recorre una trayectoria  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], ":", \([a, b]\)}], 
          "\[Rule]", \(\[DoubleStruckCapitalR]\^3\)}], TraditionalForm]]],
  "de modo que en cada punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de la trayectoria act\[UAcute]a sobre el m\[OAcute]vil una fuerza total \
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], ")"}], 
        TraditionalForm]]],
  ". En virtud de la segunda ley de Newton del movimiento, se verificar\
\[AAcute] que la fuerza total ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], ")"}], 
        TraditionalForm]]],
  " que act\[UAcute]a sobre el m\[OAcute]vil en cada punto de la trayectoria \
est\[AAcute] relacionada con la aceleraci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["a",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], "'"}], \((t)\)}]}], 
        TraditionalForm]]],
  " por la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", 
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], ")"}], "=", 
          RowBox[{"m", " ", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], "'"}], \((t)\)}]}], 
        TraditionalForm]]],
  ". En consecuencia, el trabajo realizado por dicha fuerza es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"W", "=", 
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((t)\)}], ")"}], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    "'"}]}], \((t)\), \(\[DifferentialD]t\)}]}], "=", 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["m",
                            FontSlant->"Italic"], 
                          StyleBox["r",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}]], "'"}], "'"}], 
                  RowBox[{\((t)\), 
                    StyleBox[".",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      "'"}]}], \((t)\), \(\[DifferentialD]t\)}]}], "=", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    FractionBox[
                      StyleBox["m",
                        FontSlant->"Italic"], "2"],
                    FontSlant->"Italic"], 
                  RowBox[{\(\[Integral]\_a\%b\), 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["d",
                            FontSlant->"Italic"], "dt"],
                        FontSlant->"Italic"], 
                      RowBox[{"(", " ", 
                        RowBox[{
                          RowBox[{
                            StyleBox["r",
                              FontWeight->"Bold",
                              FontSlant->"Italic"], "'"}], 
                          RowBox[{\((t)\), 
                            StyleBox[".",
                              FontWeight->"Bold"], 
                            RowBox[{
                              StyleBox["r",
                                FontWeight->"Bold",
                                FontSlant->"Italic"], "'"}]}], \((t)\)}], 
                        ")"}], \(\[DifferentialD]t\)}]}]}], "=", 
                RowBox[{
                  RowBox[{
                    StyleBox[
                      FractionBox[
                        StyleBox["m",
                          FontSlant->"Italic"], "2"],
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["(",
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["||",
                          FontSlant->"Plain"], 
                        RowBox[{
                          RowBox[{
                            StyleBox["r",
                              FontWeight->"Bold",
                              FontSlant->"Italic"], 
                            StyleBox["'",
                              FontSlant->"Plain"]}], 
                          StyleBox[\((b)\),
                            FontSlant->"Plain"]}], 
                        SuperscriptBox[
                          StyleBox["||",
                            FontSlant->"Plain"], "2"], 
                        RowBox[{"-", 
                          RowBox[{
                            StyleBox["||",
                              FontSlant->"Plain"], 
                            RowBox[{
                              RowBox[{
                                StyleBox["r",
                                  FontWeight->"Bold",
                                  FontSlant->"Italic"], 
                                StyleBox["'",
                                  FontSlant->"Plain"]}], 
                              StyleBox[\((a)\),
                                FontSlant->"Plain"]}], 
                            SuperscriptBox[
                              StyleBox["||",
                                FontSlant->"Plain"], "2"]}]}]}], ")"}]}], "=",
                   
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSlant->"Plain"], 
                          StyleBox["2",
                            FontSlant->"Plain"]],
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"], " ", 
                      StyleBox["v",
                        FontSlant->"Italic"], 
                      SuperscriptBox[
                        StyleBox[\((b)\),
                          FontSlant->"Plain"], "2"]}], "-", 
                    RowBox[{
                      StyleBox[
                        FractionBox[
                          StyleBox["1",
                            FontSlant->"Plain"], 
                          StyleBox["2",
                            FontSlant->"Plain"]],
                        FontSlant->"Italic"], 
                      StyleBox["m",
                        FontSlant->"Italic"], " ", 
                      StyleBox["v",
                        FontSlant->"Italic"], 
                      SuperscriptBox[
                        StyleBox[\((a)\),
                          FontSlant->"Plain"], "2"]}]}]}]}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde hemos representado con ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(v(t)\), "=", 
          RowBox[{"||", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "||"}]}], 
        TraditionalForm]]],
  " la rapidez del m\[OAcute]vil en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". La cantidad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[
            FractionBox[
              StyleBox["1",
                FontSlant->"Plain"], 
              StyleBox["2",
                FontSlant->"Plain"]],
            FontSlant->"Italic"], 
          StyleBox["m",
            FontSlant->"Italic"], " ", 
          StyleBox["v",
            FontSlant->"Italic"], 
          SuperscriptBox[
            StyleBox[\((t)\),
              FontSlant->"Plain"], "2"]}], TextForm]]],
  " se llama ",
  StyleBox["energ\[IAcute]a cin\[EAcute]tica",
    FontWeight->"Bold"],
  ". Hemos probado as\[IAcute] que el trabajo que realiza una fuerza sobre un \
m\[OAcute]vil es igual al incremento que experimeta la energ\[IAcute]a cin\
\[EAcute]tica del mismo debido a la acci\[OAcute]n de dicha fuerza. "
}], "Text"],

Cell[TextData[{
  StyleBox["b)",
    FontWeight->"Bold"],
  " Supongamos ahora que un m\[OAcute]vil se mueve dentro de un campo de \
fuerzas conservativo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["c",
                FontWeight->"Bold"]], "(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], "=", \(\[Del]\(f(x, y, z)\)\)}], 
        TraditionalForm]]],
  " donde ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es un campo escalar. En estas condiciones se define la energ\[IAcute]a \
potencial, ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y, z)\)]],
  ", de un objeto en el punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\((x, y, z)\)\)\)]],
  " por la igualdad ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y, z) = \(-f\) \((x, y, z)\)\)]],
  " y, en consecuencia, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["c",
                FontWeight->"Bold"]], "(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], "=", \(\(-\[Del]P\)\ \((x, y, z)\)\)}], 
        TraditionalForm]]],
  ". En esta situaci\[OAcute]n, por lo visto en el teorema 3, se verifica \
que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(W\_c\), "=", 
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              SubscriptBox[
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[\(\(c\)\(\ \)\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}]}]}], "=", 
          RowBox[{
            RowBox[{"-", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                RowBox[{
                  RowBox[{
                    StyleBox["\[Del]",
                      FontWeight->"Bold"], 
                    StyleBox["P",
                      FontWeight->"Plain",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontWeight->"Plain",
                    FontSlant->"Italic"], 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox[" ",
                    FontWeight->"Bold"], 
                  RowBox[{"\[DifferentialD]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]}]}]}]}], "=", 
            RowBox[{
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((a)\)}], ")"}]}], "-", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((b)\)}], 
                  StyleBox[")",
                    FontWeight->"Bold"]}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Igualdad que expresa que el trabajo realizado por un campo de fuerzas \
conservativo al mover un objeto a lo largo de un camino es igual a la \
diferencia de la energ\[IAcute]a potencial del objeto en los punto inicial y \
final del camino. \
\>", "Text"],

Cell[TextData[{
  StyleBox["c)",
    FontWeight->"Bold"],
  " Si adem\[AAcute]s de las fuerzas del campo conservativo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " act\[UAcute]a sobre el m\[OAcute]vil en cada punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " de su trayectoria una fuerza exterior ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(F\_e\),
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", 
          RowBox[{"r", 
            StyleBox["(",
              FontWeight->"Bold"], 
            StyleBox["t",
              FontWeight->"Bold"], 
            StyleBox[")",
              FontWeight->"Bold"]}], 
          StyleBox[")",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " entonces la fuerza total que act\[UAcute]a sobre el m\[OAcute]vil ser\
\[AAcute] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox[\(F\_c\),
              FontWeight->"Bold"], "+", 
            StyleBox[\(F\_e\),
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  " y el trabajo realizado por dicha fuerza viene dado por "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{"W", "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[
                FractionBox[
                  StyleBox["1",
                    FontSlant->"Plain"], 
                  StyleBox["2",
                    FontSlant->"Plain"]],
                FontSlant->"Italic"], 
              StyleBox["m",
                FontSlant->"Italic"], " ", 
              StyleBox["v",
                FontSlant->"Italic"], 
              SuperscriptBox[
                StyleBox[\((b)\),
                  FontSlant->"Plain"], "2"]}], "-", 
            RowBox[{
              StyleBox[
                FractionBox[
                  StyleBox["1",
                    FontSlant->"Plain"], 
                  StyleBox["2",
                    FontSlant->"Plain"]],
                FontSlant->"Italic"], 
              StyleBox["m",
                FontSlant->"Italic"], " ", 
              StyleBox["v",
                FontSlant->"Italic"], 
              SuperscriptBox[
                StyleBox[\((a)\),
                  FontSlant->"Plain"], "2"]}]}], "=", 
          RowBox[{
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]], 
              RowBox[{
                SubscriptBox[
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                StyleBox[".",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontSlant->"Plain"], 
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}]}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(c\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}], "+", 
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(e\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}]}], "=", 
              RowBox[{
                RowBox[{
                  StyleBox["P",
                    FontSlant->"Italic"], 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((a)\)}], ")"}]}], "-", 
                RowBox[{
                  StyleBox["P",
                    FontSlant->"Italic"], 
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((b)\)}], ")"}]}], "+", 
                RowBox[{
                  SubscriptBox["\[Integral]", 
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]], 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\(\(e\)\(\ \)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]], 
                    StyleBox[".",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["\[DifferentialD]",
                        FontSlant->"Plain"], 
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}]}]}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
de donde se sigue que el trabajo realizado por las fuerzas exteriores al \
campo viene dado por\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          RowBox[{
            SubscriptBox[
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[\(\(e\)\(\ \)\),
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            StyleBox[".",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[" ",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}], "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox[
                  FractionBox[
                    StyleBox["1",
                      FontSlant->"Plain"], 
                    StyleBox["2",
                      FontSlant->"Plain"]],
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"], " ", 
                StyleBox["v",
                  FontSlant->"Italic"], 
                SuperscriptBox[
                  StyleBox[\((b)\),
                    FontSlant->"Plain"], "2"]}], "+", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((b)\)}], ")"}]}]}], ")"}], "-", 
          
          RowBox[{"(", 
            RowBox[{
              RowBox[{
                StyleBox[
                  FractionBox[
                    StyleBox["1",
                      FontSlant->"Plain"], 
                    StyleBox["2",
                      FontSlant->"Plain"]],
                  FontSlant->"Italic"], 
                StyleBox["m",
                  FontSlant->"Italic"], " ", 
                StyleBox["v",
                  FontSlant->"Italic"], 
                SuperscriptBox[
                  StyleBox[\((a)\),
                    FontSlant->"Plain"], "2"]}], "+", 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((a)\)}], ")"}]}]}], ")"}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["d)",
    FontWeight->"Bold"],
  " En particular, si sobre el m\[OAcute]vil no act\[UAcute]an fuerzas \
exteriores, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(F\_e\),
            FontWeight->"Bold"], "=", "0"}], TraditionalForm]]],
  ", y el m\[OAcute]vil se desplaza debido solamente a la acci\[OAcute]n del \
campo ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(F\_c\),
          FontWeight->"Bold"], TraditionalForm]]],
  " deducimos que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["1",
                  FontSlant->"Plain"], 
                StyleBox["2",
                  FontSlant->"Plain"]],
              FontSlant->"Italic"], 
            StyleBox["m",
              FontSlant->"Italic"], " ", 
            StyleBox["v",
              FontSlant->"Italic"], 
            SuperscriptBox[
              StyleBox[\((b)\),
                FontSlant->"Plain"], "2"]}], "+", 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((b)\)}], ")"}]}]}], "=", 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["1",
                  FontSlant->"Plain"], 
                StyleBox["2",
                  FontSlant->"Plain"]],
              FontSlant->"Italic"], 
            StyleBox["m",
              FontSlant->"Italic"], " ", 
            StyleBox["v",
              FontSlant->"Italic"], 
            SuperscriptBox[
              StyleBox[\((a)\),
                FontSlant->"Plain"], "2"]}], "+", 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((a)\)}], ")"}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Igualdad que expresa que la suma de la energ\[IAcute]a cin\[EAcute]tica y \
de la energ\[IAcute]a potencial del objeto permanece constante. Este \
resultado se conoce como ",
  StyleBox["ley de conservaci\[OAcute]n de la energ\[IAcute]a",
    FontWeight->"Bold"],
  " y es v\[AAcute]lida para campos ",
  StyleBox["conservativos",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["El campo gravitacional es conservativo", "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Vimos en la lecci\[OAcute]n anterior que la fuerza de atracci\[OAcute]n \
gravitacional ejercida por un objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " que se encuentra en el origen sobre un objeto de masa unidad (",
  StyleBox["m",
    FontSlant->"Italic"],
  "=1) que se encuentra en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ x\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], " ", 
          StyleBox["+",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ y\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["+",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(\(-\ M\)\ G\ z\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["k",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold"],

Cell[TextData[{
  "Este campo vectorial est\[AAcute] definido en el abierto ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^3\\{\((0, 0, 0)\)}\)]],
  ". Es f\[AAcute]cil probar que el campo escalar ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["f",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        StyleBox[\(\(\(M\)\(\ \)\(G\)\(\ \)\)\/\@\(x\^2 + y\^2 + z\^2\)\),
          FontWeight->"Plain",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold",
  Background->GrayLevel[1]],

Cell[TextData[{
  "es una funci\[OAcute]n potencial para ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", esto es, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          \(\[Del]\(f(x, y, z)\)\)}], TraditionalForm]]],
  " para todo",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \((x, y, z)\) \[Element] A\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "An\[AAcute]logamente se prueba que el campo el\[EAcute]ctrico producido \
por una carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " es conservativo. La ley de Amp\[EAcute]re nos dice que el campo magn\
\[EAcute]tico producido por una corriente el\[EAcute]ctrica estacionaria no \
es conservativo."
}], "Text"],

Cell["\<\
El siguiente resultado, f\[AAcute]cil de probar, proporciona condiciones \
necesarias para que un campo sea conservativo.\
\>", "Text"],

Cell[TextData[{
  "Teorema 2",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["(",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"],
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox[\(F\_2\),
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox["...",
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox[\(F\_n\),
                    FontWeight->"Plain"]}], 
                StyleBox[")",
                  FontWeight->"Plain"]}], 
              StyleBox[":",
                FontWeight->"Plain"], 
              StyleBox["A",
                FontWeight->"Plain"]}], 
            StyleBox["\[Rule]",
              FontWeight->"Plain"], 
            StyleBox[\(\[DoubleStruckCapitalR]\^n\),
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".  Si ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" es conservativo entonces para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}], ")"}], "\[Element]", "A"}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" y para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i < j \[LessEqual] n\)],
    FontWeight->"Plain"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "i"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "j"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "j"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "i"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}], "                        ", 
          \((1)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para el caso de un campo vectorial de dos variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((P(x, y), Q(x, y))\),
              FontWeight->"Plain"]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "las condiciones (1) anteriores se reducen a"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["P",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["y",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["Q",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["x",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}], "                       ", 
          \((2)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para el caso de un campo vectorial de tres variables ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y, z\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((P(x, y, z), Q(x, y, z), R(x, y, z))\),
              FontWeight->"Plain"]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  "las condiciones (1) anteriores se reducen a"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            RowBox[{
              StyleBox["(",
                FontSlant->"Italic"], 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}]}], "  ", ",", " ", 
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["P",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["z",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["R",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["x",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}]}], "   ", ",", 
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["Q",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["z",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                StyleBox["R",
                  FontSlant->"Italic"]}], 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{"(", 
              StyleBox[\(x, y, z\),
                FontSlant->"Italic"], ")"}], "            ", \((3)\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es natural preguntarse si las condiciones necesarias del teorema anterior \
son tambi\[EAcute]n suficientes para que un campo sea conservativo. La \
respuesta es que, en general, no son suficientes. Por ejemplo, el campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", 
            \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]]}], ")"}], 
          "                      ", \((4)\)}]}], TextForm]], "Text",
  TextAlignment->Center,
  Background->GrayLevel[1]],

Cell["satisface las igualdades (2) pues", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              StyleBox["P",
                FontSlant->"Italic"]}], 
            RowBox[{"\[PartialD]", 
              StyleBox["y",
                FontSlant->"Italic"]}]], 
          RowBox[{"(", 
            StyleBox[\(x, y\),
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          RowBox[{
            FractionBox["\[PartialD]", 
              RowBox[{"\[PartialD]", 
                StyleBox["y",
                  FontSlant->"Italic"]}]], 
            RowBox[{
              StyleBox["(",
                FontSlant->"Italic"], 
              StyleBox[
                FractionBox[
                  StyleBox[\(-y\),
                    FontSlant->"Italic"], 
                  StyleBox[\(x\^2 + y\^2\),
                    FontSlant->"Italic"]],
                FontSlant->"Italic"], ")"}]}], "  ", "=", 
          RowBox[{
            FractionBox[
              RowBox[{
                SuperscriptBox[
                  StyleBox["y",
                    FontSlant->"Italic"], "2"], "-", 
                StyleBox[\(x\^2\),
                  FontSlant->"Italic"]}], 
              SuperscriptBox[
                RowBox[{"(", 
                  StyleBox[\(x\^2 + y\^2\),
                    FontSlant->"Italic"], 
                  StyleBox[")",
                    FontSlant->"Italic"]}], "2"]], "=", 
            RowBox[{
              RowBox[{
                FractionBox["\[PartialD]", 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], 
                RowBox[{
                  StyleBox["(",
                    FontSlant->"Italic"], 
                  StyleBox[
                    FractionBox["x", 
                      StyleBox[\(x\^2 + y\^2\),
                        FontSlant->"Italic"]],
                    FontSlant->"Italic"], ")"}]}], "   ", "=", 
              RowBox[{
                FractionBox[
                  RowBox[{"\[PartialD]", 
                    StyleBox["Q",
                      FontSlant->"Italic"]}], 
                  RowBox[{"\[PartialD]", 
                    StyleBox["x",
                      FontSlant->"Italic"]}]], 
                RowBox[{"(", 
                  StyleBox[\(x, y\),
                    FontSlant->"Italic"], ")"}]}]}]}]}]}], TextForm]], "Text",\

  TextAlignment->Center],

Cell["\<\
Sin embargo la integral de dicho campo en la circunferencia unidad vale\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox[\(C \((\((0, 0)\), 1)\)\),
              FontSlant->"Italic"]], 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        \(\[Integral]\_\(-
                \[Pi]\)\%\[Pi]\[LeftAngleBracket]\((\(-sen\)\ t, cos\ t)\) | 
                  \((\(-sen\)\ t, \ cos\ t)\)\[RightAngleBracket] 
              \[DifferentialD]t = 
          \(\[Integral]\_\(-\[Pi]\)\%\[Pi]\[DifferentialD]t = 
            2  \[Pi] \[NotEqual] 0\)\)}], TextForm]], "Text",
  TextAlignment->Center],

Cell["lo que prueba que el campo no es conservativo.", "Text"],

Cell[TextData[{
  "Estudiemos con m\[AAcute]s detalle el concepto de ",
  StyleBox["campo conservativo",
    FontSlant->"Italic"],
  ". Cuando se dice que un campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es conservativo, sin precisar nada m\[AAcute]s, se sobreentiende que ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es conservativo en todo su abierto de definici\[OAcute]n; pero puede \
ocurrir que un campo que no es conservativo en todo su abierto de definici\
\[OAcute]n s\[IAcute] lo sea en algunos subconjuntos del mismo. Es decir, el \
concepto de ",
  StyleBox["campo conservativo",
    FontSlant->"Italic"],
  " puede ",
  StyleBox["localizarse",
    FontSlant->"Italic"],
  " en algunos subconjuntos del abierto donde el campo est\[AAcute] definido. \
Unos conjuntos interesantes a este respecto son los ",
  StyleBox["conjuntos convexos",
    FontWeight->"Bold"],
  ". Recuerda que un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`C \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " se llama convexo si ",
  StyleBox["C",
    FontSlant->"Italic"],
  " contiene el segmento que une dos cualesquiera de sus puntos, esto es, \
para todos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], ",", 
          RowBox[{
            StyleBox["y",
              FontWeight->"Bold"], "\[Element]", "C"}]}], TraditionalForm]]],
  " se verifca que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"[", 
            RowBox[{
              StyleBox["x",
                FontWeight->"Bold"], ",", 
              StyleBox["y",
                FontWeight->"Bold"]}], "]"}], "\[Subset]", "C"}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], ",", 
            StyleBox["y",
              FontWeight->"Bold"]}], "]"}], TraditionalForm]]],
  " es el segmento que une ",
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "con ",
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"[", 
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], ",", 
            StyleBox["y",
              FontWeight->"Bold"]}], "]"}], "=", 
        RowBox[{"{", 
          RowBox[{
            RowBox[{\((1 - t)\), 
              StyleBox["x",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"t", " ", 
              RowBox[{
                StyleBox["y",
                  FontWeight->"Bold"], ":", 
                \(0 \[LessEqual] t \[LessEqual] 1\)}]}]}], "}"}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Ejemplos de conjuntos convexos en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " son los semiplanos (los semiespacios en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ") y los c\[IAcute]rculos (las bolas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "). Diremos que un campo ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es ",
  StyleBox["localmente conservativo",
    FontWeight->"Bold"],
  " cuando sea consevativo en todo conjunto abierto convexo contenido en el \
abierto donde dicho campo est\[AAcute] definido."
}], "Text"],

Cell["\<\
Estamos ya en condiciones de enunciar un rec\[IAcute]proco parcial del \
teorema 2.\
\>", "Text"],

Cell[TextData[{
  "Teorema 3",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"], ",", \(F\_2\), ",", 
                    "...", ",", \(F\_n\)}], ")"}], ":", "A"}], "\[Rule]", 
              \(\[DoubleStruckCapitalR]\^n\)}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".  Condiciones necesarias y suficientes para que ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" sea localmente conservativo es que para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}], ")"}], "\[Element]", "A"}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" y para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i < j \[LessEqual] n\)],
    FontWeight->"Plain"],
  StyleBox[" se veriquen las igualdades ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "i"]}], 
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["x",
                    FontSlant->"Italic"], "j"]}]], 
            RowBox[{"(", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "j"]}], 
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["x",
                    FontSlant->"Italic"], "i"]}]], 
            RowBox[{"(", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], ")"}]}]}], "                     "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El teorema anterior es bastante \[UAcute]til pero es un caso particular de \
un resultado m\[AAcute]s general. Para entender dicho resultado necesitamos \
el concepto de ",
  StyleBox["dominio simplemente conexo",
    FontWeight->"Bold"],
  ". Un conjunto abierto ",
  Cell[BoxData[
      FormBox[
        RowBox[{"A", "\[Subset]", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " con la propiedad de que dos puntos cualesquiera de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " pueden unirse por medio de una curva contenida en ",
  StyleBox["A",
    FontSlant->"Italic"],
  " se llama un ",
  StyleBox["dominio",
    FontWeight->"Bold"],
  ". Un dominio se llama ",
  StyleBox["simplemente conexo",
    FontWeight->"Bold"],
  " cuando todo camino cerrado en el dominio puede ",
  StyleBox["deformarse de forma continua",
    FontSlant->"Italic"],
  " ",
  StyleBox["sin salirse del dominio",
    FontSlant->"Italic"],
  " hasta convertirlo en un punto ",
  StyleBox["del dominio",
    FontSlant->"Italic"],
  ". La formalizaci\[OAcute]n matem\[AAcute]tica de la idea intuitiva de \
\"deformaci\[OAcute]n continua\" es complicada y considero innecesario \
precisarla aqu\[IAcute]. Intuitivamente, un dominio simplemente conexo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "es un dominio que \"no tiene agujeros\" pero esta idea intuitiva ya no \
sirve para dimensiones mayores que 2. Un ejemplo de dominio simplemente \
conexo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " es una regi\[OAcute]n del plano cuya frontera es una curva cerrada y \
simple. Los abiertos convexos son un tipo muy particular de dominios \
simplemente conexos. "
}], "Text"],

Cell[TextData[{
  "Teorema 4",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["(",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox[
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"],
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox[\(F\_2\),
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox["...",
                    FontWeight->"Plain"], 
                  StyleBox[",",
                    FontWeight->"Plain"], 
                  StyleBox[\(F\_n\),
                    FontWeight->"Plain"]}], 
                StyleBox[")",
                  FontWeight->"Plain"]}], 
              StyleBox[":",
                FontWeight->"Plain"], 
              StyleBox["A",
                FontWeight->"Plain"]}], 
            StyleBox["\[Rule]",
              FontWeight->"Plain"], 
            StyleBox[\(\[DoubleStruckCapitalR]\^n\),
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".  Supongamos que para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}], ")"}], "\[Element]", "A"}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" y para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i < j \[LessEqual] n\)],
    FontWeight->"Plain"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "i"]}], 
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["x",
                    FontSlant->"Italic"], "j"]}]], 
            RowBox[{"(", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["F",
                    FontSlant->"Italic"], "j"]}], 
              RowBox[{"\[PartialD]", 
                SubscriptBox[
                  StyleBox["x",
                    FontSlant->"Italic"], "i"]}]], 
            RowBox[{"(", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], ")"}]}]}], "                     "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Entonces ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es conservativo en todo dominio simplemente conexo contenido en ",
  StyleBox["A",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["\<\
Un resultado que es equivalente al anterior y muy \[UAcute]til para calcular \
integrales de l\[IAcute]nea de campos vectoriales es el siguiente.\
\>", "Text"],

Cell[TextData[{
  "Teorema 5",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{
                RowBox[{"(", 
                  RowBox[{
                    SubscriptBox[
                      StyleBox["F",
                        FontWeight->"Plain"], "1"], ",", \(F\_2\), ",", 
                    "...", ",", \(F\_n\)}], ")"}], ":", "A"}], "\[Rule]", 
              \(\[DoubleStruckCapitalR]\^n\)}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[", donde ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox["A",
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["es un conjunto abierto en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["un campo vectorial de clase ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".  Supongamos que para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  SubscriptBox[
                    StyleBox["x",
                      FontWeight->"Plain"], "1"], ",", \(x\_2\), ",", "...", 
                  ",", \(x\_n\)}], ")"}], "\[Element]", "A"}],
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" y para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] i < j \[LessEqual] n\)],
    FontWeight->"Plain"],
  StyleBox[" se verifica que ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "i"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "j"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}]}], "=", 
        RowBox[{
          FractionBox[
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["F",
                  FontSlant->"Italic"], "j"]}], 
            RowBox[{"\[PartialD]", 
              SubscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], "i"]}]], 
          RowBox[{"(", 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"], ")"}], "                   "}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Sean ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)]],
  " dos caminos cerrados en ",
  StyleBox["A",
    FontSlant->"Italic"],
  " (o bien dos caminos con los mismos puntos inicial y final) tales que es \
posible deformar continuamente el camino ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1\)]],
  " en el camino ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_2\)]],
  " sin salirse de ",
  StyleBox["A",
    FontSlant->"Italic"],
  " (manteniendo fijos los puntos inicial y final), entonces se verifica que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], 
        StyleBox["=",
          FontWeight->"Bold"], 
        RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), " ", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Aqu\[IAcute] puedes ver un ejemplo de deformaci\[OAcute]n continua de una \
curva cerrada en la circunferencia unidad.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Do[
        ParametricPlot[\((\((Abs[Sin[t] Cos[4  t]] +  .2)\) \((1 - s)\) + 
                s)\) {Cos[t], Sin[t]}, {t, 0, 2  Pi}, 
          AspectRatio \[Rule] Automatic, 
          PlotRange \[Rule] {{\(-1.1\), 1.1}, {\(-1.3\), 1.3}}, 
          PlotStyle \[Rule] {Hue[ .6], Thickness[ .008]}], {s, 0, 
          1,  .1}];\)\), "\[IndentingNewLine]", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.59091 .59091 m
.60469 .59412 L
.61685 .59784 L
.62882 .60261 L
.6393 .60828 L
.64345 .61127 L
.64698 .61452 L
.64823 .616 L
.6493 .61755 L
.64999 .61885 L
.65051 .62026 L
.65077 .62158 L
.6508 .62275 L
.65057 .62404 L
.65009 .62522 L
.64942 .62625 L
.64861 .62714 L
.64749 .62806 L
.64606 .62897 L
.64413 .62987 L
.64174 .6307 L
.6394 .63128 L
.63653 .63179 L
.63478 .63202 L
.63309 .63218 L
.63105 .63232 L
.62901 .63239 L
.62704 .63242 L
.62514 .6324 L
.62299 .63234 L
.6206 .63221 L
.61648 .63189 L
.61175 .63136 L
.60253 .62992 L
.5968 .62879 L
.59048 .62735 L
.58486 .62593 L
.58614 .62694 L
.58892 .62858 L
.68407 .69947 L
.7327 .75089 L
.75291 .7778 L
.76841 .80261 L
.7794 .82454 L
.78377 .83531 L
.78745 .84644 L
.78896 .85205 L
.79007 .85704 L
.79094 .8619 L
.79153 .86636 L
Mistroke
.79192 .87135 L
.792 .87578 L
.79177 .8804 L
.7915 .88288 L
.79117 .88504 L
.79033 .8889 L
.78928 .89227 L
.78783 .8957 L
.78596 .89905 L
.78362 .9022 L
.78106 .90481 L
.77848 .90685 L
.77539 .90871 L
.77247 .91002 L
.769 .91114 L
.76509 .91193 L
.76117 .91231 L
.75729 .91235 L
.75357 .91211 L
.7493 .91155 L
.7446 .9106 L
.73914 .90912 L
.73398 .90739 L
.72174 .90213 L
.69768 .88781 L
.66713 .8632 L
.63691 .83246 L
.58112 .75827 L
.55253 .70975 L
.54573 .69687 L
.53944 .68444 L
.53544 .67676 L
.53989 .68983 L
.5537 .7356 L
.56571 .78574 L
.57084 .81262 L
.57525 .84106 L
.57814 .86508 L
.57942 .87867 L
.58038 .89119 L
.58107 .90312 L
.58158 .91571 L
.58176 .92281 L
.58185 .92946 L
.58184 .94175 L
.58155 .95448 L
.58104 .96598 L
.58022 .97831 L
.57905 .99103 L
.57648 1.01105 L
Mistroke
.57336 1.02874 L
.5692 1.04688 L
.56391 1.06477 L
.55742 1.08185 L
.54946 1.09804 L
.54119 1.11085 L
.53299 1.12048 L
.52864 1.12454 L
.52446 1.12783 L
.5206 1.13036 L
.51647 1.13255 L
.51192 1.13438 L
.50769 1.13554 L
.50312 1.13623 L
.50052 1.13636 L
.4981 1.13631 L
.49356 1.13579 L
.49128 1.1353 L
.48876 1.1346 L
.48435 1.13292 L
.48025 1.13085 L
.47124 1.12444 L
.46632 1.11978 L
.46194 1.11486 L
.44749 1.09234 L
.44106 1.07823 L
.43481 1.06082 L
.42984 1.04308 L
.42603 1.02564 L
.42422 1.01546 L
.42251 1.00405 L
.42126 .99387 L
.42012 .98237 L
.41928 .97144 L
.41871 .961 L
.41831 .94975 L
.41813 .93743 L
.41819 .92579 L
.41846 .91458 L
.41886 .90439 L
.41949 .89316 L
.42056 .87893 L
.4218 .86572 L
.42553 .83554 L
.42986 .80865 L
.43546 .78018 L
.44757 .73101 L
.45561 .70376 L
.45987 .69055 L
.46396 .67847 L
Mistroke
.46047 .68462 L
.45336 .69864 L
.44045 .72245 L
.40973 .77214 L
.38182 .81019 L
.35147 .84502 L
.32294 .87194 L
.29815 .89063 L
.2869 .89755 L
.27522 .90358 L
.26484 .90782 L
.26006 .90936 L
.25582 .9105 L
.25065 .91156 L
.24804 .91194 L
.24535 .91221 L
.24101 .91237 L
.23866 .9123 L
.23653 .91213 L
.23274 .91155 L
.22951 .91071 L
.22604 .9094 L
.22302 .90782 L
.22008 .90577 L
.21729 .90321 L
.21519 .90071 L
.21318 .89763 L
.21139 .89398 L
.2106 .89192 L
.20988 .88966 L
.20934 .88758 L
.20886 .88522 L
.20827 .88085 L
.20801 .87611 L
.20807 .87151 L
.20823 .86902 L
.20849 .86621 L
.20886 .86322 L
.20931 .86036 L
.2116 .84985 L
.2153 .8379 L
.22559 .81391 L
.23849 .79096 L
.2806 .73532 L
.32946 .68738 L
.37666 .65071 L
.40076 .63483 L
.40618 .6315 L
.41174 .62818 L
.41564 .6258 L
Mistroke
.41019 .62719 L
.40084 .62927 L
.39157 .6309 L
.38669 .63155 L
.38247 .63198 L
.37847 .63227 L
.37491 .6324 L
.3719 .63241 L
.3689 .63231 L
.3665 .63215 L
.36403 .63187 L
.36159 .63148 L
.35921 .63096 L
.35719 .63036 L
.35554 .62974 L
.3538 .62888 L
.35241 .62799 L
.35137 .62712 L
.35048 .62611 L
.34977 .62494 L
.34952 .62432 L
.34933 .62363 L
.34919 .62235 L
.34929 .62111 L
.34962 .61983 L
.35014 .61858 L
.35077 .61744 L
.35163 .61618 L
.3542 .61332 L
.35733 .61066 L
.36599 .60518 L
.37832 .5996 L
.3934 .59464 L
.40124 .59262 L
.40512 .59174 L
.40868 .59099 L
.40602 .59027 L
.40274 .58955 L
.39561 .58778 L
.38129 .58332 L
.36912 .57824 L
.36373 .57539 L
.35865 .57214 L
.3553 .5695 L
.35247 .56667 L
.35126 .56513 L
.3504 .56374 L
.34976 .56236 L
.34937 .56108 L
.3492 .55995 L
Mistroke
.34923 .55878 L
.34945 .55771 L
.34982 .55678 L
.35046 .55573 L
.3514 .55467 L
.35253 .55374 L
.35378 .55294 L
.3555 .5521 L
.35738 .5514 L
.35927 .55085 L
.36156 .55034 L
.3643 .54991 L
.36579 .54974 L
.36752 .54959 L
.37076 .54943 L
.37404 .54941 L
.37735 .5495 L
.38104 .54972 L
.38436 .55001 L
.38817 .55045 L
.39729 .55187 L
.40652 .55376 L
.41206 .55509 L
.41527 .55592 L
.41397 .55494 L
.40331 .54856 L
.38184 .53468 L
.32962 .49458 L
.28302 .44919 L
.24599 .40241 L
.22949 .37539 L
.21819 .35157 L
.21367 .33907 L
.2118 .33272 L
.21021 .32617 L
.20958 .32301 L
.20909 .3201 L
.20841 .31482 L
.20806 .31007 L
.20802 .30516 L
.2083 .3007 L
.20882 .29684 L
.20974 .29266 L
.21093 .28898 L
.21231 .28583 L
.21381 .28314 L
.2157 .28044 L
.218 .27788 L
.2206 .27564 L
.22372 .27359 L
Mistroke
.22697 .27202 L
.23019 .2709 L
.23225 .27038 L
.23425 .26999 L
.23652 .26969 L
.23903 .26949 L
.24152 .26944 L
.24394 .26952 L
.24867 .26996 L
.25344 .27078 L
.25625 .27142 L
.25894 .27213 L
.27082 .27631 L
.28184 .2815 L
.29434 .28873 L
.325 .31163 L
.35466 .34015 L
.41158 .41243 L
.43748 .45415 L
.44957 .47597 L
.46022 .49668 L
.46488 .50598 L
.46062 .49354 L
.45223 .46698 L
.43712 .40918 L
.43147 .3819 L
.42649 .35281 L
.42415 .3362 L
.42234 .3212 L
.42084 .30619 L
.41974 .29229 L
.41902 .28058 L
.41848 .26813 L
.41829 .26112 L
.41817 .25453 L
.41814 .2423 L
.41837 .22969 L
.41883 .21823 L
.41959 .20594 L
.4207 .19319 L
.4219 .18247 L
.42345 .17122 L
.4269 .1518 L
.431 .13418 L
.43539 .11919 L
.44091 .10397 L
.4475 .08944 L
.45546 .07575 L
.46345 .06518 L
.46796 .0604 L
Mistroke
.47298 .05593 L
.4775 .05265 L
.48238 .04983 L
.48683 .04788 L
.48938 .04703 L
.49178 .0464 L
.496 .04568 L
.50057 .04546 L
.50509 .04582 L
.50919 .04663 L
.51389 .04816 L
.51829 .05017 L
.52597 .05511 L
.53401 .06239 L
.54246 .07271 L
.55077 .08616 L
.55727 .0996 L
.56368 .11636 L
.56947 .13598 L
.57387 .15562 L
.57591 .16714 L
.57781 .18018 L
.57927 .19295 L
.58035 .20515 L
.58077 .21121 L
.58115 .21783 L
.58164 .23003 L
.58186 .24215 L
.58184 .25348 L
.58158 .266 L
.58133 .27318 L
.58101 .27992 L
.58016 .29368 L
.57894 .30858 L
.57581 .33652 L
.5713 .36654 L
.56021 .4207 L
.5524 .45095 L
.54282 .483 L
.54045 .49031 L
.53779 .49825 L
.53522 .50569 L
.5374 .50153 L
.55017 .47647 L
.60255 .39219 L
.66332 .32214 L
.69133 .29856 L
.70531 .28895 L
.71933 .2809 L
.73087 .27562 L
Mistroke
.73667 .27349 L
.74263 .27171 L
.74785 .27053 L
.7524 .26983 L
.75676 .26948 L
.76067 .26948 L
.76421 .26977 L
.76788 .27041 L
.77146 .27143 L
.77458 .27271 L
.77726 .27417 L
.77953 .27574 L
.78397 .28004 L
.78592 .2827 L
.78749 .28543 L
.78895 .28868 L
.7902 .29244 L
.7907 .29445 L
.79116 .2967 L
.79173 .301 L
.79199 .30543 L
.79195 .30971 L
.79161 .31464 L
.791 .31952 L
.79022 .32405 L
.78911 .32913 L
.78569 .34103 L
.78139 .35259 L
.77093 .37462 L
.75637 .39888 L
.71202 .45459 L
.66443 .49964 L
.61861 .53437 L
.60721 .54194 L
.59553 .54927 L
.5901 .55255 L
.58511 .55547 L
.58759 .55518 L
.59269 .55394 L
.60291 .55183 L
.60814 .55096 L
.6128 .55033 L
.6176 .54983 L
.62002 .54964 L
.62254 .5495 L
.62463 .54943 L
.62675 .5494 L
.63032 .54947 L
.63335 .54966 L
.63632 .54999 L
Mistroke
.63888 .55043 L
.64098 .55091 L
.6432 .55159 L
.64528 .55246 L
.64694 .55338 L
.64821 .55431 L
.64919 .55529 L
.64991 .55628 L
.65037 .55721 L
.65069 .55827 L
.65081 .55947 L
.65069 .56079 L
.65039 .56195 L
.64985 .56326 L
.64915 .5645 L
.64836 .56565 L
.64602 .56828 L
.64 .57307 L
.63113 .57811 L
.6192 .58315 L
.605 .58762 L
.59091 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00/`3oool7001Vok<0oooo002_0?ooo`h006Ko/03oool00:h0oooo1P00I_l20?ooo`030000
003oool0oooo00D006Ko[`3oool00:`0oooo1000I_l60?ooo`030000003oool0oooo00<0oooo1000
I_n]0?ooo`00Z`3oool4001Vo`L0oooo00<000000?ooo`3oool0103oool4001Voj`0oooo002Z0?oo
o`<006Ko2@3oool00`000000oooo0?ooo`060?ooo`@006KoZP3oool00:P0oooo1000I_l:0?ooo`03
0000003oool0oooo00L0oooo0`00I_nZ0?ooo`00Z03oool3001Vo`/0oooo00<000000?ooo`3oool0
2@3oool2001VojT0oooo002W0?ooo`8006Ko3@3oool00`000000oooo0?ooo`0:0?ooo`8006KoZ03o
ool00:L0oooo00<006Ko0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`8006KoY`3oool0
0:H0oooo0P00I_l>0?ooo`030000003oool0oooo00`0oooo00<006Ko0?ooo`3oool0Y@3oool00:H0
oooo00<006Ko0?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`8006KoYP3oool00:D0oooo
0P00I_l?0?ooo`030000003oool0oooo00d0oooo00<006Ko0?ooo`3oool0Y03oool00:@0oooo0P00
I_l@0?ooo`030000003oool0oooo00d0oooo0P00I_nU0?ooo`00Y03oool00`00I_l0oooo0?ooo`0?
0?ooo`030000003oool0oooo00h0oooo0P00I_nT0?ooo`00X`3oool2001Voa40oooo00<000000?oo
o`3oool03`3oool00`00I_l0oooo0?ooo`2R0?ooo`00X`3oool00`00I_l0oooo0?ooo`0@0?ooo`03
0000003oool0oooo00l0oooo0P00I_nS0?ooo`00XP3oool2001Voa80oooo0P00000A0?ooo`03001V
o`3oool0oooo0:40oooo002R0?ooo`03001Vo`3oool0oooo0140oooo00<000000?ooo`3oool0403o
ool2001Voj80oooo002Q0?ooo`8006Ko4`3oool00`000000oooo0?ooo`0A0?ooo`8006KoX@3oool0
0:40oooo00<006Ko0?ooo`3oool04P3oool00`000000oooo0?ooo`0B0?ooo`03001Vo`3oool0oooo
09l0oooo002P0?ooo`8006Ko503oool00`000000oooo0?ooo`0B0?ooo`8006KoX03oool00:00oooo
00<006Ko0?ooo`3oool04`3oool00`000000oooo0?ooo`0B0?ooo`8006KoX03oool009l0oooo0P00
I_lE0?ooo`030000003oool0oooo0180oooo0`00I_nO0?ooo`00W`3oool2001VoaD0oooo00<00000
0?ooo`3oool04`3oool2001Voil0oooo002N0?ooo`8006Ko5P3oool00`000000oooo0?ooo`0C0?oo
o`8006KoW`3oool009h0oooo0P00I_lF0?ooo`030000003oool0oooo01<0oooo0`00I_nN0?ooo`00
W@3oool3001VoaH0oooo00<000000?ooo`3oool0503oool2001Voih0oooo002M0?ooo`8006Ko5`3o
ool00`000000oooo0?ooo`0D0?ooo`8006KoWP3oool009d0oooo0P00I_lG0?ooo`030000003oool0
oooo01@0oooo0P00I_nN0?ooo`00W@3oool2001Vo`X0oooo00<0omBK0000000000000`0000000`00
Vm@0oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo0`00I_nM0?ooo`00W@3oool2001Vo`d0
oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`8006KoW@3oool009d0oooo
0P00I_l=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2001Void0oooo
002L0?ooo`8006Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`<000005@3oool3001Voi`0oooo002L
0?ooo`8006Ko0P3oool00`2jLP0000000000000300000003001b^P3oool0oooo00<0oooo00<0^W9b
0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009`0oooo0P00I_l>0?oo
o`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2001Voi`0oooo002K0?ooo`<0
06Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00
V`3oool2001Vo``0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo01H0
oooo0`00I_nK0?ooo`00V`3oool2001Vo`h0oooo00<0j[Yb0000LP2jj_l0203oool00`000000oooo
0?ooo`0G0?ooo`8006KoV`3oool009X0oooo0`00I_lI0?ooo`030000003oool0oooo01L0oooo0P00
I_nK0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool05`3oool2001Voi/0oooo002J0?oo
o`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3oool009X0oooo0P00I_lJ0?ooo`03
0000003oool0oooo01L0oooo0P00I_nK0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool0
5`3oool2001Voi/0oooo002J0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3o
ool009X0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?ooo`00V@3oool2001V
oa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000
oooo0?ooo`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo
0P00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002H
0?ooo`<006Ko6`3oool2000001X0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?oo
o`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`80
06KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V03o
ool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool0
0`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo
01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0
oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009L0oooo0P00
I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00U`3oool2001Voad0oooo00<00000
0?ooo`3oool06@3oool2001VoiT0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I0?oo
o`8006KoV@3oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00
U`3oool2001Voad0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002G0?ooo`8006Ko7@3o
ool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0
oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001V
oiP0oooo002G0?ooo`8006Ko7@3oool2000001/0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo
00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?oo
o`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH
0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`80
06Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000
003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3o
ool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool0
09L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0
oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo
0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00
I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?oo
o`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool00540oooo3@00I_li0?ooo`80
06Ko7@3oool00`000000oooo0?ooo`0I0?ooo`8006Ko>P3oool<001Voe<0oooo001@0?oooa8006Ko
=@3oool2001Voad0oooo0P00000J0?ooo`8006Ko=P3ooolB001Voe40oooo001?0?ooo`@006Ko2P3o
ool8001Voc80oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_ld0?ooo`L006Ko2P3o
ool4001Voe00oooo001>0?ooo`<006Ko4@3oool5001Voc00oooo0P00I_lM0?ooo`030000003oool0
oooo01T0oooo0P00I_lb0?ooo`D006Ko403oool3001Vodl0oooo001=0?ooo`<006Ko503oool5001V
obh0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_l`0?ooo`D006Ko503oool2001V
odh0oooo001<0?ooo`<006Ko5`3oool4001Vobd0oooo0P00I_lM0?ooo`030000003oool0oooo01T0
oooo0P00I_l_0?ooo`@006Ko5P3oool3001Vodd0oooo001<0?ooo`8006Ko6P3oool4001Vob/0oooo
0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_l]0?ooo`@006Ko6@3oool2001Vodd0oooo
001;0?ooo`<006Ko6`3oool4001VobX0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00
I_l[0?ooo`D006Ko6P3oool3001Vod`0oooo001;0?ooo`8006Ko7P3oool4001VobP0oooo0P00I_lM
0?ooo`030000003oool0oooo01T0oooo0P00I_lZ0?ooo`@006Ko7@3oool2001Vod`0oooo001;0?oo
o`8006Ko7`3oool4001VobP0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lX0?oo
o`@006Ko7`3oool2001Vod`0oooo001;0?ooo`8006Ko8@3oool3001VobL0oooo0P00I_lL0?ooo`03
0000003oool0oooo01T0oooo0P00I_lW0?ooo`@006Ko803oool2001Vod`0oooo001:0?ooo`<006Ko
8P3oool4001VobD0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lV0?ooo`<006Ko
8P3oool2001Vod`0oooo001:0?ooo`8006Ko903oool4001Vob@0oooo0P00I_lL0?ooo`030000003o
ool0oooo01T0oooo0P00I_lT0?ooo`@006Ko8`3oool2001Vod`0oooo001:0?ooo`8006Ko9P3oool4
001Vob80oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lS0?ooo`@006Ko903oool2
001Vod`0oooo001:0?ooo`8006Ko9`3oool4001Vob40oooo0P00I_lL0?ooo`030000003oool0oooo
01T0oooo0P00I_lR0?ooo`<006Ko9P3oool2001Vod`0oooo001:0?ooo`8006Ko:@3oool3001Vob00
oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lQ0?ooo`<006Ko9`3oool2001Vod`0
oooo001;0?ooo`03001Vo`3oool0oooo02P0oooo0`00I_lO0?ooo`8006Ko703oool00`000000oooo
0?ooo`0I0?ooo`8006Ko7`3oool4001VobP0oooo0P00I_m<0?ooo`00B`3oool2001VobX0oooo0`00
I_lN0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko7P3oool4001VobT0oooo0P00
I_m<0?ooo`00C03oool00`00I_l0oooo0?ooo`0Y0?ooo`<006Ko7@3oool2001Voa`0oooo0P00000J
0?ooo`8006Ko7@3oool3001Vob/0oooo0P00I_m<0?ooo`00B`3oool2001Vob`0oooo0`00I_lL0?oo
o`8006Ko703oool00`000000oooo0?ooo`0H0?ooo`8006Ko7@3oool3001Vob`0oooo0P00I_m<0?oo
o`00B`3oool2001Vobd0oooo0`00I_lL0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0H0?ooo`80
06Ko703oool3001Vobd0oooo0P00I_m<0?ooo`00C03oool00`00I_l0oooo0?ooo`0/0?ooo`<006Ko
6`3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2001Voa/0oooo0`00I_l^0?ooo`8006Ko
C03oool004`0oooo0P00I_l^0?ooo`<006Ko6P3oool2001Voa/0oooo00<000000?ooo`3oool0603o
ool2001Voa/0oooo0P00I_l_0?ooo`03001Vo`3oool0oooo04/0oooo001=0?ooo`03001Vo`3oool0
oooo02d0oooo0`00I_lI0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0H0?ooo`8006Ko6P3oool2
001Vobl0oooo0P00I_m=0?ooo`00C03oool2001Voc00oooo0`00I_lH0?ooo`8006Ko6`3oool00`00
0000oooo0?ooo`0G0?ooo`8006Ko6P3oool3001Vobl0oooo0P00I_m=0?ooo`00C03oool3001Voc00
oooo0`00I_lH0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006Ko6@3oool3001Voc00
oooo0P00I_m=0?ooo`00C@3oool2001Voc40oooo0`00I_lG0?ooo`8006Ko6P3oool00`000000oooo
0?ooo`0G0?ooo`8006Ko603oool3001Voc40oooo00<006Ko0?ooo`3oool0C03oool004d0oooo0P00
I_lb0?ooo`<006Ko5P3oool2001VoaX0oooo00<000000?ooo`3oool05`3oool2001VoaL0oooo0`00
I_la0?ooo`8006KoCP3oool004d0oooo0`00I_lb0?ooo`8006Ko5P3oool2001VoaX0oooo00<00000
0?ooo`3oool05`3oool2001VoaL0oooo0P00I_lb0?ooo`03001Vo`3oool0oooo04d0oooo001>0?oo
o`8006Ko<`3oool2001VoaD0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0P00I_lF0?oo
o`8006Ko<P3oool2001Vodl0oooo001>0?ooo`8006Ko<`3oool3001Voa@0oooo0P00I_lJ0?ooo`03
0000003oool0oooo01L0oooo0P00I_lE0?ooo`<006Ko<P3oool00`00I_l0oooo0?ooo`1>0?ooo`00
C`3oool2001Voc<0oooo0`00I_lA0?ooo`030?oDV`0000000000008006Ko1@3oool00`3DV`000000
002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`0G0?ooo`80
06Ko503oool3001Voc80oooo0P00I_m@0?ooo`00D03oool00`00I_l0oooo0?ooo`0b0?ooo`<006Ko
403oool00`2jLY/0e?oo0?ooo`02001Vo`030=Coo`3oool0oooo0080oooo00<0e9/000000000Vm@0
103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo0?ooo`0G0?oo
o`8006Ko4`3oool3001Voc<0oooo0P00I_m@0?ooo`00D03oool2001Voc@0oooo0P00I_l?0?ooo`04
0?oDV`00Vm@0oooo0?ooo`8006Ko00<0L[[Z0?ooo`3oool03P3oool00`3oe9/009_D0?ooo`050?oo
o`030000003oool0oooo01L0oooo0P00I_lB0?ooo`<006Ko<`3oool3001Voe00oooo001A0?ooo`03
001Vo`3oool0oooo03<0oooo0P00I_l>0?ooo`040>ZjLP1b^^X0oooo0?ooo`8006Ko00<009_D0?oo
o`3oool03P3oool00`3oe9/009_D0?ooo`050?ooo`<000005`3oool2001Voa40oooo0`00I_ld0?oo
o`8006KoD@3oool00540oooo00<006Ko0?ooo`3oool0<`3oool3001Vo`@0oooo00<0^W8000000000
00000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z0080oooo0P00I_l00`00Vm@0oooo0?ooo`0>0?oo
o`030;Yb002Ke?l0oooo00D0oooo00<000000?ooo`3oool05P3oool2001Voa80oooo0P00I_ld0?oo
o`<006KoD@3oool00540oooo0P00I_le0?ooo`<006Ko303oool00`3Z^W80L[[Z0?ooo`020?ooo`80
06Ko2`3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3o
ool05P3oool2001Voa40oooo0P00I_le0?ooo`8006KoDP3oool00580oooo00<006Ko0?ooo`3oool0
=03oool3001Vo`/0oooo00<0omBK07:jjP3oool00P3oool2001Vo`/0oooo00<0oooD09/0V`3Dool0
2P3oool00`000000oooo0?ooo`0F0?ooo`8006Ko403oool3001VocD0oooo0P00I_mB0?ooo`00DP3o
ool2001VocH0oooo0P00I_l<0?ooo`040;Yb002Ke?l0oooo0?oZ^P8006Ko2`3oool00`3oom@0V`2K
0=Coo`0:0?ooo`030000003oool0oooo01H0oooo0P00I_l?0?ooo`<006Ko=P3oool00`00I_l0oooo
0?ooo`1A0?ooo`00D`3oool00`00I_l0oooo0?ooo`0e0?ooo`8006Ko2`3oool0103oom@0V`000000
00000782001Vo`/0oooo00<0oooD09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000
003oool0oooo01H0oooo0P00I_l>0?ooo`<006Ko=P3oool2001Voe<0oooo001C0?ooo`8006Ko=P3o
ool3001Vo`h0oooo0P00I_lH0?ooo`030000003oool0oooo01D0oooo0P00I_l>0?ooo`<006Ko=P3o
ool2001Voe@0oooo001D0?ooo`8006Ko=P3oool3001Vo`d0oooo0P00I_lH0?ooo`030000003oool0
oooo01D0oooo0P00I_l>0?ooo`8006Ko=`3oool00`00I_l0oooo0?ooo`1C0?ooo`00E@3oool00`00
I_l0oooo0?ooo`0e0?ooo`<006Ko3@3oool2001VoaL0oooo00<000000?ooo`3oool05@3oool2001V
o`d0oooo0P00I_lg0?ooo`8006KoE@3oool005D0oooo0P00I_lg0?ooo`<006Ko303oool2001VoaL0
oooo00<000000?ooo`3oool05@3oool2001Vo``0oooo0`00I_lf0?ooo`8006KoEP3oool005H0oooo
0P00I_lg0?ooo`8006Ko303oool2001VoaL0oooo00<000000?ooo`3oool05@3oool2001Vo`/0oooo
0`00I_lg0?ooo`03001Vo`3oool0oooo05D0oooo001G0?ooo`03001Vo`3oool0oooo03H0oooo0P00
I_l;0?ooo`8006Ko5`3oool00`000000oooo0?ooo`0D0?ooo`8006Ko303oool2001VocL0oooo0P00
I_mG0?ooo`00E`3oool2001VocL0oooo0`00I_l:0?ooo`8006Ko5`3oool00`000000oooo0?ooo`0D
0?ooo`8006Ko2`3oool2001VocL0oooo0P00I_mH0?ooo`00F03oool2001VocL0oooo0`00I_l:0?oo
o`8006Ko5P3oool00`000000oooo0?ooo`0D0?ooo`8006Ko2P3oool2001VocL0oooo0P00I_mI0?oo
o`00F@3oool2001VocL0oooo0`00I_l90?ooo`8006Ko5P3oool00`000000oooo0?ooo`0D0?ooo`80
06Ko2P3oool00`00I_l0oooo0?ooo`0e0?ooo`<006KoF@3oool005T0oooo0`00I_lg0?ooo`8006Ko
2@3oool2001VoaH0oooo00<000000?ooo`3oool0503oool2001Vo`T0oooo0P00I_lg0?ooo`8006Ko
FP3oool005X0oooo0P00I_lh0?ooo`8006Ko203oool2001VoaH0oooo00<000000?ooo`3oool04`3o
ool2001Vo`X0oooo00<006Ko0?ooo`3oool0=@3oool2001Voe/0oooo001K0?ooo`8006Ko=`3oool3
001Vo`L0oooo0`00I_lE0?ooo`800000503oool2001Vo`T0oooo0P00I_lf0?ooo`<006KoF`3oool0
05/0oooo0`00I_lg0?ooo`8006Ko203oool2001VoaD0oooo00<000000?ooo`3oool04`3oool2001V
o`P0oooo0P00I_lf0?ooo`<006KoG03oool005`0oooo0`00I_lg0?ooo`8006Ko1`3oool2001VoaD0
oooo00<000000?ooo`3oool04`3oool2001Vo`P0oooo00<006Ko0?ooo`3oool0=03oool3001Voed0
oooo001M0?ooo`<006Ko=`3oool00`00I_l0oooo0?ooo`050?ooo`8006Ko5@3oool00`000000oooo
0?ooo`0C0?ooo`8006Ko1`3oool2001VocH0oooo0P00I_mN0?ooo`00GP3oool3001VocH0oooo0P00
I_l60?ooo`<006Ko503oool00`000000oooo0?ooo`0B0?ooo`8006Ko1`3oool2001VocH0oooo0P00
I_mO0?ooo`00G`3oool2001VocL0oooo0P00I_l60?ooo`8006Ko503oool00`000000oooo0?ooo`0B
0?ooo`8006Ko1`3oool00`00I_l0oooo0?ooo`0d0?ooo`<006KoG`3oool00600oooo0P00I_lg0?oo
o`03001Vo`3oool0oooo00@0oooo0P00I_lD0?ooo`030000003oool0oooo0180oooo0P00I_l60?oo
o`8006Ko=@3oool3001Vof00oooo001P0?ooo`<006Ko=P3oool2001Vo`D0oooo0P00I_lD0?ooo`03
0000003oool0oooo0180oooo0P00I_l50?ooo`8006Ko=@3oool3001Vof40oooo001Q0?ooo`<006Ko
=P3oool00`00I_l0oooo0?ooo`030?ooo`<006Ko4`3oool00`000000oooo0?ooo`0A0?ooo`<006Ko
1@3oool00`00I_l0oooo0?ooo`0d0?ooo`8006KoHP3oool00680oooo0`00I_le0?ooo`8006Ko1@3o
ool2001Voa<0oooo00<000000?ooo`3oool04@3oool2001Vo`D0oooo0P00I_le0?ooo`8006KoH`3o
ool006<0oooo0`00I_le0?ooo`8006Ko103oool2001Voa<0oooo00<000000?ooo`3oool04@3oool2
001Vo`D0oooo00<006Ko0?ooo`3oool0<`3oool3001Vof<0oooo001T0?ooo`8006Ko=P3oool00`00
I_l0oooo0?ooo`020?ooo`8006Ko4`3oool00`000000oooo0?ooo`0@0?ooo`<006Ko103oool2001V
oc@0oooo0`00I_mT0?ooo`00I@3oool2001VocD0oooo0P00I_l30?ooo`8006Ko4`3oool00`000000
oooo0?ooo`0@0?ooo`8006Ko103oool2001Voc@0oooo0`00I_mU0?ooo`00I@3oool3001VocD0oooo
00@006Ko0?ooo`3oool0oooo0`00I_lB0?ooo`030000003oool0oooo0100oooo0P00I_l40?ooo`03
001Vo`3oool0oooo03<0oooo0P00I_mV0?ooo`00IP3oool3001Voc@0oooo0P00I_l30?ooo`8006Ko
4P3oool00`000000oooo0?ooo`0@0?ooo`8006Ko0`3oool2001Voc@0oooo0P00I_mW0?ooo`00I`3o
ool3001Voc@0oooo0P00I_l20?ooo`8006Ko4P3oool00`000000oooo0?ooo`0?0?ooo`<006Ko0P3o
ool2001Voc@0oooo0`00I_mW0?ooo`00J03oool3001Voc@0oooo00<006Ko0?ooo`3oool00P00I_lB
0?ooo`800000403oool2001Vo`<0oooo00<006Ko0?ooo`3oool0<P3oool3001VofP0oooo001Y0?oo
o`<006Ko<`3oool2001Vo`040?ooo`00I_l006Ko001Voa40oooo00<000000?ooo`3oool03`3oool2
001Vo`80oooo0P00I_lc0?ooo`<006KoJ@3oool006X0oooo0`00I_lc0?ooo`03001Vo`3oool0oooo
008006Ko4@3oool00`000000oooo0?ooo`0>0?ooo`<006Ko00<0oooo001Vo`00I_l0<`3oool3001V
ofX0oooo001[0?ooo`<006Ko<P3oool2001Vo`030?ooo`00I_l006Ko0140oooo00<000000?ooo`3o
ool03P3oool2001Vo`80oooo00<006Ko0?ooo`3oool0<@3oool3001Vof/0oooo001/0?ooo`<006Ko
<P3oool01000I_l0oooo001Vo`00I_lA0?ooo`030000003oool0oooo00h0oooo0P00I_l00`3oool0
06Ko001Vo`0b0?ooo`<006KoK03oool006d0oooo0`00I_la0?ooo`D006Ko403oool00`000000oooo
0?ooo`0=0?ooo`<006Ko00<0oooo001Vo`3oool0<@3oool3001Vofd0oooo001^0?ooo`<006Ko<@3o
ool01000I_l0oooo001Vo`00I_l@0?ooo`030000003oool0oooo00d0oooo0P00I_l00`3oool006Ko
001Vo`0a0?ooo`<006KoKP3oool006l0oooo0`00I_l`0?ooo`@006Ko403oool00`000000oooo0?oo
o`0=0?ooo`@006Ko<@3oool3001Vofl0oooo001`0?ooo`<006Ko<03oool4001Vo`l0oooo00<00000
0?ooo`3oool0303oool4001Voc40oooo0`00I_m`0?ooo`00L@3oool3001Vobl0oooo1000I_l?0?oo
o`030000003oool0oooo00`0oooo1000I_l`0?ooo`<006KoL@3oool00780oooo0`00I_l_0?ooo`<0
06Ko3`3oool00`000000oooo0?ooo`0<0?ooo`<006Ko<03oool3001Vog80oooo001c0?ooo`<006Ko
;P3oool3001Vo`l0oooo00<000000?ooo`3oool0303oool3001Vobl0oooo0`00I_mc0?ooo`00M03o
ool3001Vobh0oooo0`00I_l>0?ooo`030000003oool0oooo00/0oooo0`00I_l_0?ooo`<006KoM03o
ool007D0oooo0`00I_l]0?ooo`<006Ko3P3oool00`000000oooo0?ooo`0;0?ooo`8006Ko;`3oool3
001VogD0oooo001f0?ooo`<006Ko;@3oool2001Vo`h0oooo00<000000?ooo`3oool02P3oool3001V
obh0oooo0`00I_mf0?ooo`00M`3oool3001Vob`0oooo0P00I_l>0?ooo`030000003oool0oooo00X0
oooo0P00I_l^0?ooo`<006KoM`3oool007P0oooo1000I_l[0?ooo`8006Ko3@3oool00`000000oooo
0?ooo`0:0?ooo`8006Ko;@3oool3001VogP0oooo001i0?ooo`@006Ko:P3oool2001Vo`d0oooo0P00
000;0?ooo`8006Ko;03oool3001VogT0oooo001k0?ooo`<006Ko:P3oool2001Vo``0oooo00<00000
0?ooo`3oool02@3oool3001VobX0oooo1000I_mj0?ooo`00O03oool3001VocL0oooo00<000000?oo
o`3oool02@3oool3001VobT0oooo1000I_mk0?ooo`00O@3oool4001VocD0oooo00<000000?ooo`3o
ool02@3oool2001VobP0oooo1000I_mm0?ooo`00OP3oool4001Voc@0oooo00<000000?ooo`3oool0
2@3oool2001VobL0oooo1000I_mn0?ooo`00P03oool3001Voc<0oooo00<000000?ooo`3oool02@3o
ool2001VobD0oooo1000I_n00?ooo`00P@3oool3001Voc80oooo00<000000?ooo`3oool02@3oool0
0`00I_l0oooo0?ooo`0S0?ooo`@006KoP@3oool00880oooo1000I_l`0?ooo`030000003oool0oooo
00T0oooo00<006Ko0?ooo`3oool08P3oool3001Voh<0oooo00230?ooo`@006Ko;`3oool00`000000
oooo0?ooo`090?ooo`03001Vo`3oool0oooo0200oooo1000I_n40?ooo`00Q@3oool3001Vobh0oooo
00<000000?ooo`3oool0:`3oool4001VohD0oooo00260?ooo`<006Ko;@3oool00`000000oooo0?oo
o`0Y0?ooo`@006KoQ`3oool008L0oooo1000I_l[0?ooo`030000003oool0oooo02P0oooo1000I_n8
0?ooo`00R03oool4001VobX0oooo00<000000?ooo`3oool09`3oool3001VohX0oooo002:0?ooo`@0
06Ko:03oool00`000000oooo0?ooo`0U0?ooo`@006KoR`3oool008/0oooo1000I_lW0?ooo`030000
003oool0oooo02@0oooo1000I_n<0?ooo`00S@3oool4001VobD0oooo00<000000?ooo`3oool08`3o
ool3001Vohh0oooo002>0?ooo`@006Ko903oool200000280oooo1000I_n?0?ooo`004@3oool00`3o
e9/000000000000300000003002Ke03oool0oooo0480oooo00D0omBK000000000000000009_Do`05
0?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000000009_Do`0M0?ooo`@006Ko8P3o
ool00`000000oooo0?ooo`0P0?ooo`@006Ko803oool01@3oe9/00000000000000000VmCo00D0oooo
00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo04@0oooo00<0omBK00000000
00000`0000000`00Vm@0oooo0?ooo`0<0?ooo`00503oool00`2jLW80^^[o0?ooo`150?ooo`060;Yb
V`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo
0?ooo`3oj[X0LP0009_Do`0=0?oooa@006Ko8@3oool00`000000oooo0?ooo`0N0?oooa@006Ko4P3o
ool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`00
09_D0?ooo`3oool0onZj0780002Ke?l0AP3oool00`2jLW80^^[o0?ooo`0?0?ooo`00503oool00`2j
LW80^^[o0?ooo`140?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3o
e9/009_D0?ooo`0:0?oooaP006Ko7`3oool00`000000oooo0?ooo`0L0?oooaP006Ko3`3oool00`3o
e9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0A@3oool00`2j
LW80^^[o0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`140?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`090?ooo`D006Ko3@3oool7001Voal0
oooo00<000000?ooo`3oool06P3oool9001Vo`h0oooo1000I_l>0?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`150?ooo`030;YbLP2jj_l0oooo00l0
oooo00080?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2jLW80^^[o
0?ooo`0k0?ooo`030;Yb00000000000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`03
0?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool02@3oool3001Voa<0oooo0`00I_lO0?ooo`03
0000003oool0oooo01P0oooo2000I_lC0?ooo`8006Ko3P3oool00`3Z^W80L[[Z0?ooo`020?ooo`03
0?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0A@3oool00`2jLW80^^[o0?ooo`0?0?ooo`00
503oool00`2jLW80^^[o0?ooo`140?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
2P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00T0oooo0P00I_lf0?ooo`030000
003oool0oooo03<0oooo0P00I_l>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
2P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo04D0oooo00<0^W9b0;[Zo`3oool0
3`3oool001@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b
^^X0oooo00X0oooo00<0oooD09/0V`3Dool03P3oool3001VocD0oooo00<000000?ooo`3oool0<P3o
ool3001Vo`h0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K
09/0e?oo04X0oooo00<0^W9b0;[Zo`3oool03`3oool00140oooo00D0j[Yb00000000L[X0^W9b0;[Z
o`160?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0?0?ooo`<0
06Ko=03oool00`000000oooo0?ooo`0b0?ooo`<006Ko3`3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K
0=Coo`/0oooo00<0oooD09/0V`3Dool0A`3oool01@3Z^W800000001b^P2jLW80^^[o0100oooo000C
0?ooo`030>ZjLP000780^^[o04H0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K
000000000080000000<0002K0=Coo`3oool02`3oool3001Voc<0oooo00<000000?ooo`3oool0<@3o
ool3001Voa00oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K0000000000800000
00<0002K0=Coo`3oool0A03oool00`3Z^W80001b0;[Zo`0@0?ooo`00P@3oool4001Voc40oooo00<0
00000?ooo`3oool0<03oool3001Voh40oooo00220?ooo`D006Ko;`3oool00`000000oooo0?ooo`0]
0?ooo`D006KoPP3oool008@0oooo1@00I_l]0?ooo`030000003oool0oooo02X0oooo1`00I_n30?oo
o`00QP3oool5001Vob/0oooo00<000000?ooo`3oool0:03oool6001VohH0oooo00280?ooo`H006Ko
:03oool00`000000oooo0?ooo`0U0?ooo`H006KoR@3oool008X0oooo1`00I_lU0?ooo`030000003o
ool0oooo02<0oooo1P00I_n;0?ooo`00S@3oool6001Vob<0oooo00<000000?ooo`3oool07@3oool9
001Vohh0oooo002@000000@006Ko@P000006001Voi40000000000`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool01@3oool8001Vo`030?ooo`000000oooo00h0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00d0
oooo2@00I_l80?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool100000000
403oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo02<0oooo2P00I_lS0?ooo`030000
003oool0oooo02<0oooo1@00I_lX0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0
3`3oool008L0oooo1P00I_lY0?ooo`030000003oool0oooo02D0oooo1`00I_n80?ooo`00Q@3oool5
001Vob`0oooo00<000000?ooo`3oool09`3oool8001VohD0oooo00230?ooo`D006Ko;P3oool00`00
0000oooo0?ooo`0/0?ooo`D006KoP`3oool00880oooo1000I_l`0?ooo`030000003oool0oooo02h0
oooo1000I_n20?ooo`00P@3oool3001Voc80oooo00<000000?ooo`3oool0<03oool2001Voh80oooo
00200?ooo`<006Ko<`3oool00`000000oooo0?ooo`0a0?ooo`8006KoP@3oool007l0oooo0`00I_ld
0?ooo`030000003oool0oooo0380oooo0P00I_n00?ooo`00OP3oool3001VocD0oooo00<000000?oo
o`3oool0<P3oool3001Vogl0oooo001n0?ooo`8006Ko=P3oool00`000000oooo0?ooo`0c0?ooo`80
06KoO`3oool007h0oooo0P00I_lG0?ooo`03001Vo`3oool0oooo01`0oooo00<000000?ooo`3oool0
<`3oool2001Vogl0oooo001n0?ooo`<006Ko4@3oool7001Voad0oooo00<000000?ooo`3oool06`3o
ool6001Voa40oooo0`00I_mo0?ooo`00OP3oool5001Vo`/0oooo2P00I_lN0?ooo`030000003oool0
oooo01`0oooo2P00I_l:0?ooo`@006KoP03oool007l0oooo6000I_lO0?ooo`030000003oool0oooo
01d0oooo5`00I_n00?ooo`00P@3oool=001Vo`80oooo1@00I_lQ0?ooo`030000003oool0oooo01h0
oooo1000I_l30?ooo``006KoP`3oool008l0oooo1000I_lS0?ooo`8000008@3oool3001Voi40oooo
002=0?ooo`@006Ko9@3oool00`000000oooo0?ooo`0Q0?ooo`@006KoS`3oool008`0oooo1000I_lV
0?ooo`030000003oool0oooo0280oooo1000I_n>0?ooo`00RP3oool4001VobP0oooo00<000000?oo
o`3oool0903oool3001Vohd0oooo00290?ooo`@006Ko:@3oool00`000000oooo0?ooo`0U0?ooo`@0
06KoR`3oool008P0oooo0`00I_l[0?ooo`030000003oool0oooo02H0oooo1000I_n:0?ooo`00QP3o
ool4001Vob`0oooo00<000000?ooo`3oool0:03oool3001VohT0oooo00250?ooo`@006Ko;@3oool0
0`000000oooo0?ooo`0Y0?ooo`@006KoQ`3oool008@0oooo0`00I_l_0?ooo`030000003oool0oooo
02X0oooo1000I_n60?ooo`00PP3oool4001Voc00oooo00<000000?ooo`3oool0;03oool3001VohD0
oooo00210?ooo`@006Ko<@3oool00`000000oooo0?ooo`0]0?ooo`@006KoP`3oool00800oooo0`00
I_lc0?ooo`030000003oool0oooo02h0oooo1000I_n20?ooo`00O`3oool3001Voc@0oooo00<00000
0?ooo`3oool0<03oool4001Voh00oooo001m0?ooo`@006Ko=@3oool00`000000oooo0?ooo`0a0?oo
o`@006KoO`3oool007`0oooo1000I_lY0?ooo`03001Vo`3oool0oooo00X0oooo00<000000?ooo`3o
ool02@3oool3001VobL0oooo0`00I_mn0?ooo`00N`3oool3001VobX0oooo0`00I_l;0?ooo`030000
003oool0oooo00X0oooo0P00I_lX0?ooo`@006KoO03oool007T0oooo1000I_lZ0?ooo`<006Ko303o
ool2000000/0oooo0P00I_lY0?ooo`@006KoN`3oool007P0oooo1000I_lZ0?ooo`<006Ko3@3oool0
0`000000oooo0?ooo`0:0?ooo`<006Ko:P3oool3001VogX0oooo001g0?ooo`<006Ko;03oool3001V
o`d0oooo00<000000?ooo`3oool02P3oool3001Vob/0oooo1000I_mh0?ooo`00MP3oool3001Vob`0
oooo0`00I_l>0?ooo`030000003oool0oooo00X0oooo0`00I_l/0?ooo`@006KoM`3oool007D0oooo
0`00I_l]0?ooo`<006Ko3P3oool00`000000oooo0?ooo`0;0?ooo`<006Ko;@3oool3001VogH0oooo
001d0?ooo`<006Ko;P3oool3001Vo`h0oooo00<000000?ooo`3oool02`3oool3001Vobh0oooo1000
I_md0?ooo`00L`3oool3001Vobl0oooo0`00I_l>0?ooo`030000003oool0oooo00/0oooo0`00I_l_
0?ooo`@006KoL`3oool00780oooo0`00I_l_0?ooo`@006Ko3P3oool00`000000oooo0?ooo`0<0?oo
o`<006Ko<03oool3001Vog80oooo001a0?ooo`<006Ko<03oool3001Vo`l0oooo00<000000?ooo`3o
ool0303oool4001Voc00oooo0`00I_ma0?ooo`00L03oool3001Voc00oooo1000I_l?0?ooo`030000
003oool0oooo00`0oooo0P00I_l00`3oool006Ko001Vo`0`0?ooo`<006KoL03oool006l0oooo0`00
I_l`0?ooo`8006Ko00<0oooo001Vo`00I_l03`3oool00`000000oooo0?ooo`0<0?ooo`<006Ko00<0
oooo001Vo`3oool0<03oool3001Vofl0oooo001^0?ooo`<006Ko<@3oool00`00I_l0oooo001Vo`02
001Vo`l0oooo00<000000?ooo`3oool03@3oool2001Vo`030?ooo`00I_l006Ko0340oooo0`00I_m^
0?ooo`00K@3oool3001Voc40oooo0P00I_l00`3oool006Ko001Vo`0@0?ooo`030000003oool0oooo
00d0oooo0P00I_l20?ooo`03001Vo`3oool0oooo0300oooo0`00I_m]0?ooo`00K03oool3001Voc80
oooo00<006Ko0?ooo`3oool00P00I_l@0?ooo`030000003oool0oooo00d0oooo0`00I_l00`3oool0
06Ko001Vo`0b0?ooo`<006KoK03oool006/0oooo0`00I_lb0?ooo`8006Ko0P3oool2001Voa00oooo
00<000000?ooo`3oool03P3oool2001Vo`80oooo00<006Ko0?ooo`3oool0<@3oool3001Vof/0oooo
001Z0?ooo`<006Ko<`3oool00`00I_l0oooo0?ooo`03001Voa00oooo00<000000?ooo`3oool03P3o
ool2001Vo`80oooo0P00I_lc0?ooo`<006KoJP3oool006T0oooo0`00I_lc0?ooo`8006Ko0P3oool2
001Voa40oooo00<000000?ooo`3oool03P3oool2001Vo`<0oooo0P00I_lc0?ooo`<006KoJ@3oool0
06P0oooo0`00I_lc0?ooo`8006Ko0`3oool2001Voa40oooo0P00000?0?ooo`<006Ko0`3oool00`00
I_l0oooo0?ooo`0b0?ooo`<006KoJ03oool006L0oooo0`00I_ld0?ooo`04001Vo`3oool0oooo0?oo
o`<006Ko4@3oool00`000000oooo0?ooo`0?0?ooo`8006Ko0`3oool2001Voc@0oooo0`00I_mW0?oo
o`00IP3oool3001Voc@0oooo0P00I_l30?ooo`8006Ko4P3oool00`000000oooo0?ooo`0?0?ooo`80
06Ko103oool00`00I_l0oooo0?ooo`0c0?ooo`<006KoIP3oool006D0oooo0`00I_le0?ooo`03001V
o`3oool0oooo0080oooo0P00I_lB0?ooo`030000003oool0oooo00l0oooo0`00I_l30?ooo`8006Ko
=@3oool3001VofD0oooo001T0?ooo`<006Ko=@3oool2001Vo`@0oooo0P00I_lB0?ooo`030000003o
ool0oooo0100oooo0P00I_l40?ooo`03001Vo`3oool0oooo03@0oooo0`00I_mT0?ooo`00I03oool2
001VocD0oooo0P00I_l40?ooo`<006Ko4P3oool00`000000oooo0?ooo`0@0?ooo`8006Ko103oool2
001VocH0oooo0`00I_mS0?ooo`00H`3oool2001VocH0oooo00<006Ko0?ooo`3oool00`3oool2001V
oa<0oooo00<000000?ooo`3oool0403oool2001Vo`D0oooo00<006Ko0?ooo`3oool0=@3oool3001V
of80oooo001R0?ooo`<006Ko=@3oool2001Vo`D0oooo0P00I_lC0?ooo`030000003oool0oooo0100
oooo0`00I_l40?ooo`8006Ko=`3oool3001Vof40oooo001Q0?ooo`<006Ko=P3oool00`00I_l0oooo
0?ooo`030?ooo`<006Ko4`3oool00`000000oooo0?ooo`0A0?ooo`8006Ko1@3oool2001VocL0oooo
0P00I_mQ0?ooo`00H03oool3001VocH0oooo0P00I_l50?ooo`8006Ko503oool00`000000oooo0?oo
o`0A0?ooo`8006Ko1P3oool00`00I_l0oooo0?ooo`0f0?ooo`8006KoH03oool00600oooo0P00I_lf
0?ooo`8006Ko1P3oool2001Voa@0oooo00<000000?ooo`3oool04@3oool3001Vo`D0oooo0P00I_lh
0?ooo`8006KoG`3oool005l0oooo0P00I_lg0?ooo`03001Vo`3oool0oooo00D0oooo0P00I_lD0?oo
o`030000003oool0oooo0180oooo0P00I_l60?ooo`03001Vo`3oool0oooo03L0oooo00<006Ko0?oo
o`3oool0G@3oool005h0oooo0`00I_lf0?ooo`8006Ko1P3oool3001Voa@0oooo00<000000?ooo`3o
ool04P3oool2001Vo`H0oooo0P00I_lh0?ooo`8006KoGP3oool005d0oooo0`00I_lg0?ooo`03001V
o`3oool0oooo00D0oooo0P00I_lE0?ooo`030000003oool0oooo0180oooo0P00I_l70?ooo`8006Ko
>03oool2001Voed0oooo001L0?ooo`<006Ko=`3oool2001Vo`L0oooo0P00I_lE0?ooo`030000003o
ool0oooo0180oooo0`00I_l70?ooo`8006Ko>03oool2001Voe`0oooo001L0?ooo`8006Ko=`3oool2
001Vo`L0oooo0`00I_lE0?ooo`030000003oool0oooo01<0oooo0P00I_l80?ooo`03001Vo`3oool0
oooo03L0oooo00<006Ko0?ooo`3oool0FP3oool005/0oooo0P00I_lh0?ooo`03001Vo`3oool0oooo
00H0oooo0P00I_lF0?ooo`800000503oool2001Vo`P0oooo0P00I_lh0?ooo`8006KoF`3oool005X0
oooo0`00I_lg0?ooo`8006Ko203oool2001VoaH0oooo00<000000?ooo`3oool04`3oool3001Vo`P0
oooo0P00I_lh0?ooo`8006KoFP3oool005T0oooo0`00I_lg0?ooo`8006Ko2@3oool2001VoaH0oooo
00<000000?ooo`3oool0503oool2001Vo`T0oooo0P00I_lh0?ooo`03001Vo`3oool0oooo05P0oooo
001H0?ooo`<006Ko=`3oool2001Vo`T0oooo0`00I_lF0?ooo`030000003oool0oooo01@0oooo0P00
I_l:0?ooo`8006Ko=`3oool2001VoeT0oooo001H0?ooo`8006Ko>03oool00`00I_l0oooo0?ooo`08
0?ooo`8006Ko5`3oool00`000000oooo0?ooo`0D0?ooo`8006Ko2`3oool00`00I_l0oooo0?ooo`0f
0?ooo`8006KoF03oool005L0oooo0P00I_lh0?ooo`8006Ko2P3oool2001VoaL0oooo00<000000?oo
o`3oool0503oool2001Vo`/0oooo0P00I_lh0?ooo`03001Vo`3oool0oooo05H0oooo001F0?ooo`<0
06Ko=`3oool2001Vo`/0oooo0P00I_lG0?ooo`030000003oool0oooo01D0oooo0P00I_l;0?ooo`80
06Ko=`3oool2001VoeL0oooo001F0?ooo`8006Ko>03oool00`00I_l0oooo0?ooo`0:0?ooo`8006Ko
5`3oool00`000000oooo0?ooo`0E0?ooo`8006Ko303oool2001VocL0oooo0P00I_mF0?ooo`00E@3o
ool2001VocP0oooo0P00I_l;0?ooo`8006Ko603oool00`000000oooo0?ooo`0E0?ooo`8006Ko3@3o
ool00`00I_l0oooo0?ooo`0f0?ooo`03001Vo`3oool0oooo05@0oooo001E0?ooo`03001Vo`3oool0
oooo03H0oooo0P00I_l<0?ooo`8006Ko603oool00`000000oooo0?ooo`0E0?ooo`8006Ko3@3oool2
001VocL0oooo0P00I_mE0?ooo`00E03oool2001VocL0oooo0P00I_l=0?ooo`8006Ko603oool00`00
0000oooo0?ooo`0E0?ooo`8006Ko3P3oool2001VocL0oooo0P00I_mD0?ooo`00E03oool00`00I_l0
oooo0?ooo`0f0?ooo`03001Vo`3oool0oooo00`0oooo0P00I_lH0?ooo`030000003oool0oooo01H0
oooo0P00I_l>0?ooo`8006Ko=`3oool00`00I_l0oooo0?ooo`1B0?ooo`00D`3oool2001VocL0oooo
0P00I_l>0?ooo`8006Ko603oool00`000000oooo0?ooo`0F0?ooo`8006Ko3`3oool2001VocH0oooo
0P00I_mC0?ooo`00D`3oool00`00I_l0oooo0?ooo`0e0?ooo`8006Ko2`3oool00`3oe9/000000000
0002001Vo`D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo
00<000000?ooo`3oool05P3oool2001Voa00oooo00<006Ko0?ooo`3oool0=@3oool00`00I_l0oooo
0?ooo`1A0?ooo`00DP3oool2001VocH0oooo0P00I_l<0?ooo`030;YbV`3Dool0oooo008006Ko00<0
e?oo0?ooo`3oool00P3oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0
LP0009_Do`060?ooo`030000003oool0oooo01H0oooo0P00I_l@0?ooo`8006Ko=P3oool2001Voe80
oooo001B0?ooo`03001Vo`3oool0oooo03@0oooo0`00I_l;0?ooo`040?oDV`00Vm@0oooo0?ooo`80
06Ko00<0L[[Z0?ooo`3oool03P3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo01H0
oooo0P00I_lA0?ooo`8006Ko=P3oool00`00I_l0oooo0?ooo`1@0?ooo`00D@3oool2001VocD0oooo
0`00I_l<0?ooo`040>ZjLP1b^^X0oooo0?ooo`8006Ko00<009_D0?ooo`3oool03P3oool00`3oe9/0
09_D0?ooo`050?ooo`030000003oool0oooo01L0oooo0P00I_lA0?ooo`8006Ko=@3oool2001Voe40
oooo001A0?ooo`03001Vo`3oool0oooo03@0oooo0P00I_l=0?ooo`040>ZjLP1b^^X0oooo0?ooo`80
06Ko00<009_D0?ooo`3oool03P3oool00`2jLP00VmCo0?ooo`050?ooo`<000005`3oool2001Voa80
oooo00<006Ko0?ooo`3oool0=03oool00`00I_l0oooo0?ooo`1?0?ooo`00D03oool2001VocD0oooo
0P00I_l>0?ooo`040>ZjLP1b^^X0oooo0?ooo`8006Ko00<009_D0?ooo`3oool02@3oool00`3oom@0
V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool05`3oool2001Voa80
oooo0P00I_le0?ooo`8006KoD03oool00500oooo00<006Ko0?ooo`3oool0<`3oool3001Vo`h0oooo
00@0omBK07:jjP3oool0oooo0P00I_l00`1b^^X0oooo0?ooo`090?ooo`030?ooe02K09/0e?oo00X0
oooo00<000000?ooo`3oool05`3oool2001Voa<0oooo0P00I_le0?ooo`03001Vo`3oool0oooo04h0
oooo001@0?ooo`03001Vo`3oool0oooo0380oooo0`00I_l@0?ooo`030;Yb002Ke?l0oooo008006Ko
00<0e?oo0?ooo`3oool02@3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01L0oooo
0P00I_lD0?ooo`8006Ko=03oool2001Vodl0oooo001?0?ooo`8006Ko<`3oool3001Voa40oooo00<0
oooD09/0000000000P00I_l<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool01@3o
ool00`000000oooo0?ooo`0G0?ooo`8006Ko5@3oool2001Voc<0oooo0P00I_m?0?ooo`00C`3oool0
0`00I_l0oooo0?ooo`0a0?ooo`<006Ko5@3oool2001VoaT0oooo00<000000?ooo`3oool05`3oool2
001VoaH0oooo0P00I_lb0?ooo`8006KoC`3oool004h0oooo0P00I_lc0?ooo`8006Ko5@3oool2001V
oaX0oooo00<000000?ooo`3oool05`3oool2001VoaH0oooo0`00I_lb0?ooo`03001Vo`3oool0oooo
04d0oooo001>0?ooo`03001Vo`3oool0oooo0340oooo0P00I_lF0?ooo`8006Ko6P3oool00`000000
oooo0?ooo`0G0?ooo`8006Ko5`3oool3001Voc40oooo0P00I_m>0?ooo`00C@3oool2001Voc80oooo
0`00I_lF0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006Ko603oool3001Voc40oooo
00<006Ko0?ooo`3oool0C03oool004d0oooo0P00I_la0?ooo`<006Ko5`3oool2001VoaX0oooo00<0
00000?ooo`3oool0603oool2001VoaP0oooo0`00I_l`0?ooo`8006KoC@3oool004d0oooo0P00I_l`
0?ooo`<006Ko603oool2001VoaX0oooo00<000000?ooo`3oool0603oool2001VoaT0oooo0`00I_l`
0?ooo`03001Vo`3oool0oooo04/0oooo001<0?ooo`<006Ko;`3oool3001VoaT0oooo0P00I_lJ0?oo
o`030000003oool0oooo01P0oooo0P00I_lJ0?ooo`<006Ko;P3oool2001Vodd0oooo001<0?ooo`80
06Ko;P3oool4001VoaT0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0P00I_lK0?ooo`<0
06Ko;@3oool2001Vodd0oooo001<0?ooo`8006Ko;@3oool4001VoaX0oooo0P00I_lK0?ooo`030000
003oool0oooo01P0oooo0P00I_lL0?ooo`<006Ko;03oool2001Vodd0oooo001<0?ooo`8006Ko;03o
ool3001Voa`0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0P00I_lM0?ooo`<006Ko;03o
ool00`00I_l0oooo0?ooo`1;0?ooo`00B`3oool3001Vob/0oooo0`00I_lM0?ooo`8006Ko6`3oool0
0`000000oooo0?ooo`0H0?ooo`8006Ko7P3oool3001Vob/0oooo0P00I_m<0?ooo`00B`3oool2001V
obX0oooo1000I_lN0?ooo`8006Ko6`3oool2000001T0oooo0P00I_lO0?ooo`<006Ko:`3oool00`00
I_l0oooo0?ooo`1:0?ooo`00BP3oool3001VobT0oooo1000I_lN0?ooo`8006Ko703oool00`000000
oooo0?ooo`0H0?ooo`8006Ko803oool3001VobT0oooo0P00I_m<0?ooo`00BP3oool2001VobT0oooo
0`00I_lP0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko803oool4001VobL0oooo
0P00I_m<0?ooo`00BP3oool2001VobP0oooo0`00I_lQ0?ooo`8006Ko703oool00`000000oooo0?oo
o`0I0?ooo`8006Ko8@3oool4001VobH0oooo0P00I_m<0?ooo`00BP3oool2001VobH0oooo1000I_lR
0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko8`3oool3001VobD0oooo0P00I_m<
0?ooo`00BP3oool2001VobD0oooo1000I_lS0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?oo
o`8006Ko903oool3001Vob@0oooo0P00I_m<0?ooo`00BP3oool2001Vob@0oooo0`00I_lU0?ooo`80
06Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko9@3oool4001Vob80oooo0P00I_m<0?ooo`00
BP3oool3001Vob80oooo0`00I_lV0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko
9P3oool4001Vob40oooo0P00I_m<0?ooo`00B`3oool2001Vob00oooo1000I_lW0?ooo`8006Ko703o
ool00`000000oooo0?ooo`0I0?ooo`8006Ko:03oool3001Vob00oooo0P00I_m<0?ooo`00B`3oool2
001Voal0oooo1000I_lX0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko:@3oool4
001Voah0oooo0P00I_m<0?ooo`00B`3oool2001Voah0oooo0`00I_lZ0?ooo`8006Ko703oool00`00
0000oooo0?ooo`0I0?ooo`8006Ko:P3oool5001Voa`0oooo0P00I_m<0?ooo`00B`3oool3001Voa/0
oooo1000I_lZ0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`8006Ko;03oool4001VoaX0
oooo0`00I_m<0?ooo`00C03oool2001VoaX0oooo1000I_l[0?ooo`8006Ko7@3oool00`000000oooo
0?ooo`0I0?ooo`8006Ko;P3oool4001VoaP0oooo0P00I_m=0?ooo`00C03oool3001VoaL0oooo1000
I_l]0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`8006Ko;`3oool5001VoaH0oooo0P00
I_m=0?ooo`00C@3oool3001Voa@0oooo1@00I_l^0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I
0?ooo`8006Ko<@3oool5001Voa<0oooo0P00I_m>0?ooo`00CP3oool3001Voa40oooo1@00I_l`0?oo
o`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`8006Ko<`3oool5001Vo`l0oooo0`00I_m?0?oo
o`00C`3oool3001Vo`h0oooo1@00I_lb0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`80
06Ko=@3oool5001Vo``0oooo1000I_m?0?ooo`00D03oool4001Vo`T0oooo1P00I_ld0?ooo`8006Ko
7@3oool2000001X0oooo0P00I_lg0?ooo`D006Ko203oool4001Voe40oooo001A0?oooa0006Ko=P3o
ool2001Voad0oooo00<000000?ooo`3oool06@3oool2001VocT0oooo3P00I_mB0?ooo`00D`3oool;
001VocT0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0`00I_lj0?ooo`X006KoE03oool0
09L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0
oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo
0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00
I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?oo
o`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`03
0000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool0
6P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03o
ool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001V
oad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000
oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo
0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G
0?ooo`8006Ko7@3oool2000001X0oooo0P00I_nI0?ooo`00U`3oool2001Voad0oooo00<000000?oo
o`3oool06@3oool2001VoiT0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0I0?ooo`80
06KoV@3oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00U`3o
ool2001Voad0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002G0?ooo`8006Ko7@3oool0
0`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009L0oooo0`00I_lL0?ooo`030000003oool0oooo
01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0
oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009P0oooo0P00
I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<00000
0?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?oo
o`8006KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00
V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`<006Ko6`3o
ool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009T0oooo0P00I_lK0?ooo`030000003oool0
oooo01T0oooo0P00I_nI0?ooo`00V@3oool2001Voa/0oooo0P00000J0?ooo`8006KoV@3oool009T0
oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V@3oool2001Voa/0oooo
00<000000?ooo`3oool06@3oool2001VoiT0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?oo
o`0I0?ooo`8006KoV@3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0`00I_nI
0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002I0?ooo`<0
06Ko6P3oool00`000000oooo0?ooo`0H0?ooo`8006KoVP3oool009X0oooo0P00I_lJ0?ooo`030000
003oool0oooo01L0oooo0`00I_nJ0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool05`3o
ool2001Voi/0oooo002J0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3oool0
09X0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0P00I_nK0?ooo`00V`3oool2001VoaT0
oooo00<000000?ooo`3oool05P3oool3001Voi/0oooo002K0?ooo`8006Ko6@3oool00`000000oooo
0?ooo`0F0?ooo`8006KoW03oool009/0oooo0P00I_l<0?ooo`030?oDV`000000000000<0000000<0
09_D0?ooo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009/0oooo0P00I_l?
0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2001Voi`0oooo002K0?oo
o`8006Ko3`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?oo
o`00V`3oool3001Vo`h0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`80
06KoW03oool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo0`00000E0?ooo`8006Ko
W@3oool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3o
ool2001Void0oooo002L0?ooo`<006Ko3@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0
oooo01D0oooo0P00I_nM0?ooo`00W@3oool2001Vo`X0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`08
0?ooo`030000003oool0oooo01@0oooo0`00I_nM0?ooo`00W@3oool2001Vo``0oooo00<0j[Yb0000
LP2jj_l0203oool00`000000oooo0?ooo`0D0?ooo`8006KoWP3oool009d0oooo0`00I_lF0?ooo`03
0000003oool0oooo01@0oooo0P00I_nN0?ooo`00WP3oool2001VoaH0oooo00<000000?ooo`3oool0
503oool2001Voih0oooo002N0?ooo`8006Ko5P3oool00`000000oooo0?ooo`0C0?ooo`<006KoWP3o
ool009h0oooo0P00I_lF0?ooo`030000003oool0oooo01<0oooo0P00I_nO0?ooo`00WP3oool3001V
oaD0oooo00<000000?ooo`3oool04`3oool2001Voil0oooo002O0?ooo`8006Ko5@3oool00`000000
oooo0?ooo`0B0?ooo`<006KoW`3oool009l0oooo0P00I_lE0?ooo`030000003oool0oooo0180oooo
0P00I_nP0?ooo`00X03oool00`00I_l0oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo0P00
I_nP0?ooo`00X03oool2001Voa@0oooo00<000000?ooo`3oool04P3oool00`00I_l0oooo0?ooo`2O
0?ooo`00X@3oool00`00I_l0oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo0P00I_nQ0?oo
o`00X@3oool2001Voa<0oooo00<000000?ooo`3oool04@3oool00`00I_l0oooo0?ooo`2P0?ooo`00
XP3oool2001Voa80oooo0P00000A0?ooo`8006KoXP3oool00:<0oooo00<006Ko0?ooo`3oool0403o
ool00`000000oooo0?ooo`0@0?ooo`03001Vo`3oool0oooo0:40oooo002S0?ooo`8006Ko4@3oool0
0`000000oooo0?ooo`0?0?ooo`8006KoX`3oool00:@0oooo0P00I_l@0?ooo`030000003oool0oooo
00l0oooo00<006Ko0?ooo`3oool0XP3oool00:D0oooo00<006Ko0?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`8006KoY03oool00:D0oooo0P00I_l?0?ooo`030000003oool0oooo00d0oooo
0P00I_nU0?ooo`00YP3oool00`00I_l0oooo0?ooo`0=0?ooo`030000003oool0oooo00d0oooo00<0
06Ko0?ooo`3oool0Y03oool00:H0oooo0P00I_l>0?ooo`030000003oool0oooo00`0oooo0P00I_nV
0?ooo`00Y`3oool2001Vo`d0oooo00<000000?ooo`3oool02`3oool2001VojL0oooo002X0?ooo`03
001Vo`3oool0oooo00/0oooo00<000000?ooo`3oool02P3oool3001VojL0oooo002X0?ooo`8006Ko
303oool00`000000oooo0?ooo`090?ooo`<006KoZ03oool00:T0oooo0P00I_l;0?ooo`030000003o
ool0oooo00P0oooo0`00I_nY0?ooo`00Z@3oool3001Vo`X0oooo00<000000?ooo`3oool01`3oool3
001VojX0oooo002Z0?ooo`@006Ko203oool00`000000oooo0?ooo`060?ooo`<006KoZ`3oool00:/0
oooo1@00I_l60?ooo`030000003oool0oooo00@0oooo1000I_n/0?ooo`00[@3oool4001Vo`D0oooo
00@000000?ooo`3oool0oooo1P00I_n]0?ooo`00[`3oool5001Vo`80oooo00<000000?ooo`3oool0
1@00I_n_0?ooo`00/03oool;001Vok80oooo002b0?ooo`P006Ko/`3oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00001\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.62727 .59091 m
.63965 .59519 L
.65054 .59983 L
.6612 .60555 L
.67047 .61217 L
.67411 .61562 L
.67571 .61744 L
.67716 .61937 L
.67821 .62105 L
.67911 .62287 L
.67971 .62451 L
.68007 .62602 L
.68024 .62756 L
.68019 .62899 L
.67997 .63023 L
.67955 .63155 L
.67887 .63292 L
.67788 .63432 L
.67671 .63556 L
.67544 .63662 L
.67167 .63885 L
.66936 .63981 L
.6665 .64072 L
.66381 .64139 L
.66066 .64197 L
.65744 .6424 L
.6543 .64267 L
.6523 .64278 L
.6501 .64285 L
.64817 .64288 L
.64596 .64286 L
.64353 .64279 L
.64082 .64267 L
.63819 .64249 L
.63571 .64227 L
.63102 .64177 L
.62566 .64102 L
.62288 .64058 L
.61984 .64004 L
.61815 .64 L
.62044 .64155 L
.66257 .67312 L
.70482 .71171 L
.74247 .75479 L
.77406 .80336 L
.78004 .81539 L
.78546 .82804 L
.78924 .83867 L
.79239 .84983 L
.79377 .85635 L
Mistroke
.7943 .85944 L
.7947 .86219 L
.79501 .86481 L
.79526 .86758 L
.79543 .87045 L
.79551 .87309 L
.7954 .87794 L
.79523 .8803 L
.79495 .88282 L
.79422 .88709 L
.79326 .89085 L
.79197 .89456 L
.79029 .89821 L
.78859 .90109 L
.78645 .90399 L
.78384 .90676 L
.78068 .90936 L
.77736 .91142 L
.77404 .91297 L
.77065 .91412 L
.7673 .91492 L
.7634 .91548 L
.75899 .91571 L
.75667 .91568 L
.75408 .91554 L
.74921 .91497 L
.74425 .91404 L
.73951 .91285 L
.72994 .90965 L
.72051 .90557 L
.69752 .89234 L
.67356 .87419 L
.64684 .8491 L
.59185 .78099 L
.56457 .73757 L
.55827 .7264 L
.55164 .71411 L
.54922 .71011 L
.55142 .71719 L
.55558 .73121 L
.5682 .78151 L
.57367 .80934 L
.57781 .83528 L
.5806 .85756 L
.58174 .8689 L
.58276 .88113 L
.58324 .88805 L
.58361 .89441 L
.58415 .90682 L
.58443 .91797 L
Mistroke
.58449 .92962 L
.58433 .9408 L
.5839 .95279 L
.58325 .96389 L
.58244 .97397 L
.58039 .99241 L
.57746 1.01111 L
.57306 1.03174 L
.56804 1.04964 L
.56278 1.06452 L
.55658 1.07869 L
.55059 1.08982 L
.54354 1.10046 L
.53667 1.10874 L
.53014 1.115 L
.52215 1.12076 L
.51766 1.12316 L
.51335 1.12494 L
.50934 1.12613 L
.50562 1.12686 L
.50152 1.12724 L
.49716 1.12717 L
.49314 1.12666 L
.48876 1.12562 L
.48422 1.124 L
.48003 1.122 L
.47266 1.11724 L
.46504 1.11053 L
.4565 1.10052 L
.44896 1.08906 L
.44261 1.077 L
.43648 1.06263 L
.43166 1.04868 L
.42701 1.03204 L
.42338 1.0156 L
.42064 .9997 L
.41814 .97998 L
.41711 .9687 L
.41636 .95775 L
.41588 .94746 L
.41561 .93777 L
.4155 .92697 L
.41562 .91531 L
.41597 .90335 L
.41628 .8965 L
.41664 .89008 L
.41756 .87702 L
.41884 .86292 L
.42194 .83712 L
.4256 .81349 L
Mistroke
.43771 .75621 L
.44466 .73039 L
.44662 .72366 L
.4488 .71647 L
.4509 .70972 L
.44891 .71307 L
.43753 .73389 L
.42444 .75597 L
.40025 .79226 L
.37274 .82749 L
.34311 .85913 L
.31554 .88296 L
.29183 .89902 L
.28101 .90484 L
.26987 .90972 L
.26497 .91148 L
.25996 .91299 L
.25551 .91409 L
.25143 .91487 L
.24654 .91548 L
.24229 .91571 L
.23793 .91559 L
.23558 .91537 L
.23346 .91506 L
.23011 .91433 L
.22663 .91323 L
.22324 .91174 L
.22031 .91004 L
.21733 .90781 L
.21451 .90509 L
.21238 .90248 L
.21033 .89933 L
.20846 .8956 L
.20758 .89341 L
.20686 .89125 L
.20627 .88915 L
.20572 .88681 L
.20501 .88251 L
.20461 .8782 L
.20449 .87408 L
.20463 .86914 L
.20505 .86425 L
.20567 .85961 L
.20645 .85518 L
.20892 .84477 L
.21279 .83271 L
.21727 .82141 L
.23041 .79524 L
.26758 .74221 L
.31028 .69697 L
Mistroke
.35198 .66154 L
.36236 .65373 L
.37296 .64612 L
.37788 .6427 L
.38238 .63964 L
.37781 .64046 L
.37293 .64123 L
.36856 .64182 L
.36461 .64224 L
.36065 .64257 L
.35646 .64279 L
.35303 .64287 L
.35002 .64286 L
.34686 .64274 L
.34372 .64251 L
.34069 .64217 L
.33766 .64168 L
.33502 .64112 L
.3328 .64052 L
.33041 .63972 L
.32809 .63873 L
.32615 .63769 L
.32461 .63666 L
.32332 .63559 L
.32215 .63435 L
.32116 .63297 L
.32047 .63159 L
.32003 .63025 L
.31979 .62878 L
.31977 .62748 L
.31993 .62602 L
.3201 .62518 L
.32036 .62429 L
.32098 .62266 L
.32188 .62089 L
.32315 .61893 L
.3261 .6154 L
.32959 .61212 L
.33938 .60519 L
.35037 .5994 L
.36385 .59389 L
.36726 .59269 L
.36916 .59205 L
.37097 .59146 L
.37235 .59079 L
.3704 .59017 L
.36659 .5889 L
.3542 .58413 L
.34195 .57812 L
.33251 .57203 L
Mistroke
.32581 .56611 L
.32426 .56434 L
.32283 .56244 L
.32179 .56077 L
.32092 .55902 L
.32033 .55746 L
.31992 .55578 L
.31977 .55428 L
.31981 .55292 L
.31992 .55211 L
.32012 .55126 L
.32068 .54974 L
.32149 .54834 L
.32247 .5471 L
.32376 .54584 L
.32549 .54454 L
.32763 .54331 L
.32995 .54228 L
.33215 .5415 L
.33474 .54077 L
.33741 .54018 L
.34002 .53974 L
.3433 .53935 L
.34526 .53918 L
.34713 .53906 L
.35073 .53895 L
.35476 .53897 L
.35883 .53913 L
.36342 .53946 L
.36796 .53993 L
.37227 .54049 L
.3775 .54131 L
.38055 .54185 L
.38156 .54162 L
.37698 .5385 L
.37195 .53499 L
.29456 .46948 L
.25334 .42148 L
.23524 .39475 L
.22007 .36666 L
.21505 .35507 L
.21071 .34301 L
.20872 .33629 L
.20723 .33033 L
.20604 .32444 L
.20524 .31916 L
.20476 .31453 L
.20451 .30978 L
.20454 .3052 L
.20467 .30268 L
Mistroke
.20488 .30038 L
.20546 .29639 L
.2062 .29292 L
.20733 .28913 L
.20866 .28576 L
.21033 .28248 L
.21244 .27925 L
.21457 .27666 L
.21709 .27422 L
.21959 .27227 L
.22259 .27042 L
.22554 .26902 L
.22849 .26795 L
.23243 .26695 L
.23643 .26635 L
.24021 .26612 L
.24455 .26619 L
.24687 .26636 L
.2495 .26666 L
.25231 .2671 L
.25502 .26762 L
.26 .26883 L
.26558 .27055 L
.27548 .2744 L
.2869 .28002 L
.31149 .29581 L
.3587 .33855 L
.414 .40951 L
.42606 .42848 L
.4384 .44946 L
.44333 .45834 L
.44853 .46802 L
.44945 .46746 L
.44614 .45653 L
.43297 .4056 L
.42711 .37679 L
.4226 .34938 L
.41937 .32399 L
.41797 .30974 L
.41695 .29662 L
.41625 .28461 L
.41581 .27384 L
.41554 .26155 L
.41552 .25014 L
.41572 .23938 L
.41615 .22804 L
.41678 .21755 L
.41753 .20817 L
.41862 .19741 L
.42007 .18602 L
Mistroke
.42338 .16623 L
.42774 .1469 L
.4333 .12806 L
.43884 .11329 L
.44548 .09905 L
.45215 .08758 L
.45867 .07849 L
.46564 .07069 L
.47239 .06478 L
.48005 .05981 L
.48418 .05784 L
.48863 .05624 L
.49089 .05563 L
.49334 .05512 L
.49781 .05461 L
.50216 .05461 L
.50617 .05504 L
.51059 .05601 L
.51476 .05741 L
.51847 .05905 L
.52247 .06125 L
.53122 .06776 L
.539 .07568 L
.55209 .09458 L
.55866 .10755 L
.56408 .12068 L
.56949 .13689 L
.57437 .15557 L
.57657 .16596 L
.57868 .17778 L
.58035 .18905 L
.58162 .1996 L
.58269 .21066 L
.58347 .22136 L
.58406 .23289 L
.58429 .2395 L
.58442 .24566 L
.58449 .25605 L
.58436 .26766 L
.58397 .27994 L
.58337 .29159 L
.58253 .30377 L
.58136 .31688 L
.57861 .34067 L
.57425 .36917 L
.56932 .39502 L
.55797 .44206 L
.55439 .45472 L
.55235 .46159 L
.5504 .46796 L
Mistroke
.55152 .46792 L
.55758 .45667 L
.60638 .38051 L
.65535 .32418 L
.68216 .30063 L
.69581 .29063 L
.70976 .28188 L
.72137 .27584 L
.73348 .27087 L
.73852 .26925 L
.74376 .26789 L
.74852 .26696 L
.75271 .2664 L
.75666 .26614 L
.7607 .26615 L
.76433 .26644 L
.76746 .26693 L
.77096 .26779 L
.77451 .26904 L
.77762 .27054 L
.78028 .27218 L
.78497 .27617 L
.78727 .27885 L
.78916 .28162 L
.79086 .28474 L
.79224 .28793 L
.79352 .29187 L
.79442 .29571 L
.79506 .2999 L
.7953 .30235 L
.79544 .30467 L
.7955 .30907 L
.79529 .31391 L
.79486 .31841 L
.79425 .32273 L
.79336 .3276 L
.79215 .33295 L
.78853 .34532 L
.78396 .3575 L
.77262 .38115 L
.74432 .42461 L
.70583 .46908 L
.6618 .50933 L
.64113 .5255 L
.63254 .5318 L
.62783 .53514 L
.62357 .53812 L
.61948 .54092 L
.62034 .54169 L
.62551 .54082 L
Mistroke
.63003 .54018 L
.63478 .53963 L
.6372 .53941 L
.63969 .53922 L
.6441 .539 L
.64795 .53894 L
.65191 .53902 L
.65402 .53913 L
.65589 .53927 L
.65932 .53965 L
.66234 .54013 L
.66556 .54084 L
.66826 .54163 L
.67091 .54263 L
.67337 .54385 L
.6764 .54598 L
.67759 .54716 L
.67864 .54854 L
.67933 .54977 L
.67985 .55114 L
.68014 .55248 L
.68024 .55374 L
.68014 .55536 L
.67983 .55689 L
.67926 .5586 L
.67839 .56045 L
.67634 .56358 L
.67328 .56706 L
.66601 .57311 L
.65596 .57926 L
.64489 .58451 L
.63389 .58873 L
.62727 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002`0?ooo``006Ko/@3oool0
0:d0oooo4P00I_n^0?ooo`00[03oool5001Vo`D0oooo00<000000?ooo`3oool00P3oool5001Vojd0
oooo002Z0?ooo`@006Ko203oool00`000000oooo0?ooo`050?ooo`@006KoZ`3oool00:T0oooo1000
I_l90?ooo`030000003oool0oooo00H0oooo1000I_nZ0?ooo`00Z@3oool2001Vo`/0oooo00<00000
0?ooo`3oool0203oool3001VojT0oooo002X0?ooo`8006Ko303oool00`000000oooo0?ooo`090?oo
o`<006KoZ03oool00:L0oooo0P00I_l=0?ooo`030000003oool0oooo00X0oooo0P00I_nX0?ooo`00
Y`3oool00`00I_l0oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo0P00I_nW0?ooo`00YP3o
ool2001Vo`h0oooo00<000000?ooo`3oool0303oool2001VojH0oooo002U0?ooo`8006Ko3`3oool0
0`000000oooo0?ooo`0=0?ooo`03001Vo`3oool0oooo0:@0oooo002T0?ooo`8006Ko403oool00`00
0000oooo0?ooo`0=0?ooo`8006KoY@3oool00:@0oooo00<006Ko0?ooo`3oool03`3oool00`000000
oooo0?ooo`0>0?ooo`8006KoY03oool00:<0oooo0P00I_lA0?ooo`800000403oool2001Voj<0oooo
002S0?ooo`03001Vo`3oool0oooo0100oooo00<000000?ooo`3oool0403oool00`00I_l0oooo0?oo
o`2Q0?ooo`00XP3oool2001Voa80oooo00<000000?ooo`3oool0403oool2001Voj80oooo002R0?oo
o`03001Vo`3oool0oooo0140oooo00<000000?ooo`3oool0403oool2001Voj80oooo002Q0?ooo`80
06Ko4`3oool00`000000oooo0?ooo`0@0?ooo`<006KoX@3oool00:00oooo0P00I_lD0?ooo`030000
003oool0oooo0140oooo0P00I_nQ0?ooo`00X03oool00`00I_l0oooo0?ooo`0C0?ooo`030000003o
ool0oooo0140oooo0`00I_nP0?ooo`00W`3oool2001VoaD0oooo00<000000?ooo`3oool04P3oool2
001Voj00oooo002O0?ooo`03001Vo`3oool0oooo01@0oooo00<000000?ooo`3oool04P3oool2001V
oj00oooo002N0?ooo`8006Ko5P3oool00`000000oooo0?ooo`0B0?ooo`<006KoW`3oool009d0oooo
0`00I_lF0?ooo`030000003oool0oooo01<0oooo0P00I_nO0?ooo`00W@3oool2001VoaL0oooo00<0
00000?ooo`3oool04`3oool3001Voih0oooo002M0?ooo`8006Ko5`3oool00`000000oooo0?ooo`0D
0?ooo`8006KoWP3oool009`0oooo0`00I_l:0?ooo`030?oDV`000000000000<0000000<009_D0?oo
o`3oool0103oool00`000000oooo0?ooo`0D0?ooo`8006KoWP3oool009`0oooo0P00I_l>0?ooo`03
0;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0503oool3001Void0oooo002L0?ooo`8006Ko
3P3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01D0oooo0P00I_nM0?ooo`00V`3o
ool3001Vo`h0oooo00<0^W9b0;[Zo`3oool01`3oool3000001D0oooo0P00I_nM0?ooo`00V`3oool2
001Vo`<0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0
oooo00L0oooo00<000000?ooo`3oool05@3oool3001Voi`0oooo002K0?ooo`8006Ko3`3oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00V`3oool2001Vo`l0
oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009X0oooo
0`00I_l<0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`0F0?ooo`<0
06KoV`3oool009X0oooo0P00I_l?0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0
5`3oool2001Voi/0oooo002J0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3o
ool009X0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?ooo`00VP3oool2001V
oaX0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002J0?ooo`8006Ko6P3oool00`000000
oooo0?ooo`0H0?ooo`8006KoVP3oool009X0oooo0P00I_lJ0?ooo`030000003oool0oooo01P0oooo
0P00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002I
0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?oo
o`030000003oool0oooo01P0oooo0P00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3o
ool0603oool2001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0H0?ooo`8006Ko
VP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V@3oool2
001Voa/0oooo0P00000J0?ooo`8006KoV@3oool009P0oooo0`00I_lK0?ooo`030000003oool0oooo
01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0
oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`<006KoV03oool009P0oooo0P00
I_lL0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00V03oool2001Voa`0oooo00<00000
0?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?oo
o`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00
U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3o
ool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0
oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001V
oiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009H0oooo
0`00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00UP3oool2001Voah0oooo00<0
00000?ooo`3oool06P3oool2001VoiP0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0J
0?ooo`8006KoV03oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?oo
o`00UP3oool2001Voah0oooo0P00000K0?ooo`8006KoV03oool009H0oooo0P00I_lN0?ooo`030000
003oool0oooo01X0oooo0P00I_nH0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool06P3o
ool2001VoiP0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool0
09H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo00<006Ko0?ooo`3oool0UP3oool009H0
oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo
00<000000?ooo`3oool0703oool00`00I_l0oooo0?ooo`2E0?ooo`00UP3oool2001Voah0oooo00<0
00000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K
0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?oo
o`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko
7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003o
ool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2
001VoiL0oooo001B0?ooo`d006Ko=`3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001V
ocL0oooo3P00I_mB0?ooo`00D03ooolC001Voc<0oooo0P00I_lN0?ooo`030000003oool0oooo01/0
oooo0P00I_lb0?oooaD006KoD03oool004l0oooo1000I_l;0?ooo`L006Ko<@3oool2001Voah0oooo
0P00000L0?ooo`8006Ko<03oool8001Vo``0oooo1@00I_m>0?ooo`00CP3oool3001Voa40oooo1@00
I_l_0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006Ko;P3oool5001Voa<0oooo0`00
I_m>0?ooo`00C@3oool3001Voa@0oooo1@00I_l]0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K
0?ooo`8006Ko;03oool5001VoaH0oooo0`00I_m=0?ooo`00C03oool3001VoaL0oooo1@00I_l[0?oo
o`8006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`8006Ko;03oool4001VoaT0oooo0`00I_m<0?oo
o`00C03oool00`00I_l0oooo0?ooo`0I0?ooo`D006Ko:@3oool2001Voah0oooo00<000000?ooo`3o
ool06P3oool2001VobX0oooo1000I_lL0?ooo`8006KoC03oool004/0oooo0P00I_lM0?ooo`@006Ko
:03oool2001Voah0oooo00<000000?ooo`3oool06P3oool2001VobT0oooo1000I_lM0?ooo`8006Ko
C03oool004X0oooo0`00I_lO0?ooo`@006Ko9P3oool2001Voah0oooo00<000000?ooo`3oool06P3o
ool2001VobP0oooo0`00I_lO0?ooo`<006KoB`3oool004X0oooo0P00I_lQ0?ooo`D006Ko903oool2
001Voah0oooo00<000000?ooo`3oool06P3oool2001VobH0oooo1000I_lQ0?ooo`8006KoB`3oool0
04X0oooo0P00I_lS0?ooo`@006Ko8`3oool2001Voah0oooo00<000000?ooo`3oool06P3oool2001V
obD0oooo1000I_lR0?ooo`8006KoB`3oool004X0oooo00<006Ko0?ooo`3oool0903oool3001Vob80
oooo0P00I_lN0?ooo`030000003oool0oooo01X0oooo0P00I_lS0?ooo`@006Ko903oool2001Vod/0
oooo00190?ooo`8006Ko9`3oool3001Vob80oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo
0P00I_lR0?ooo`@006Ko9@3oool2001Vod/0oooo00190?ooo`8006Ko:03oool3001Vob40oooo0P00
I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_lQ0?ooo`<006Ko9`3oool2001Vod/0oooo0019
0?ooo`8006Ko:@3oool3001Vob00oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_lP
0?ooo`<006Ko:03oool2001Vod/0oooo00190?ooo`8006Ko:P3oool3001Voal0oooo0P00I_lM0?oo
o`030000003oool0oooo01X0oooo0P00I_lO0?ooo`<006Ko:@3oool2001Vod/0oooo00190?ooo`80
06Ko:`3oool3001Voah0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_lM0?ooo`@0
06Ko:P3oool2001Vod/0oooo00190?ooo`8006Ko;03oool3001Voad0oooo0P00I_lM0?ooo`030000
003oool0oooo01X0oooo0P00I_lL0?ooo`@006Ko:`3oool2001Vod/0oooo00190?ooo`8006Ko;@3o
ool4001Voa/0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_lL0?ooo`<006Ko;@3o
ool2001Vod/0oooo001:0?ooo`03001Vo`3oool0oooo02`0oooo1000I_lJ0?ooo`8006Ko7@3oool2
000001X0oooo0P00I_lK0?ooo`<006Ko;P3oool2001Vod/0oooo001:0?ooo`8006Ko;`3oool3001V
oaT0oooo0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_lJ0?ooo`<006Ko;`3oool2001V
od/0oooo001;0?ooo`03001Vo`3oool0oooo02h0oooo0`00I_lH0?ooo`<006Ko703oool00`000000
oooo0?ooo`0I0?ooo`8006Ko6@3oool3001Voc00oooo0P00I_m;0?ooo`00BP3oool2001Voc40oooo
0`00I_lH0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko603oool3001Voc40oooo
0P00I_m;0?ooo`00B`3oool00`00I_l0oooo0?ooo`0`0?ooo`<006Ko5`3oool2001Voa`0oooo00<0
00000?ooo`3oool06@3oool2001VoaL0oooo0`00I_lb0?ooo`8006KoB`3oool004/0oooo0P00I_lb
0?ooo`<006Ko5P3oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoaL0oooo0P00I_lc
0?ooo`03001Vo`3oool0oooo04X0oooo001<0?ooo`03001Vo`3oool0oooo0340oooo0`00I_lE0?oo
o`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006Ko5P3oool2001Voc<0oooo0P00I_m<0?oo
o`00B`3oool2001Voc@0oooo0P00I_lE0?ooo`<006Ko6`3oool00`000000oooo0?ooo`0I0?ooo`80
06Ko5@3oool3001Voc<0oooo0P00I_m<0?ooo`00B`3oool2001VocD0oooo0P00I_lE0?ooo`8006Ko
6`3oool00`000000oooo0?ooo`0H0?ooo`8006Ko5@3oool3001Voc@0oooo0P00I_m<0?ooo`00C03o
ool00`00I_l0oooo0?ooo`0d0?ooo`8006Ko503oool2001Voa/0oooo00<000000?ooo`3oool0603o
ool2001Voa@0oooo0`00I_le0?ooo`8006KoC03oool004`0oooo0P00I_lf0?ooo`8006Ko4`3oool2
001Voa/0oooo00<000000?ooo`3oool0603oool2001Voa<0oooo0`00I_le0?ooo`8006KoC@3oool0
04d0oooo00<006Ko0?ooo`3oool0=@3oool00`00I_l0oooo0?ooo`0A0?ooo`8006Ko6`3oool00`00
0000oooo0?ooo`0H0?ooo`8006Ko4P3oool3001VocH0oooo0P00I_m=0?ooo`00C@3oool2001VocH0
oooo0P00I_lC0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0H0?ooo`8006Ko4P3oool2001VocL0
oooo00<006Ko0?ooo`3oool0C03oool004h0oooo00<006Ko0?ooo`3oool0=@3oool2001Voa00oooo
00D0omBK00000000I_l006Ko09_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/000000000
0000000009_Do`070?ooo`030000003oool0oooo01P0oooo0P00I_lA0?ooo`8006Ko=`3oool2001V
odh0oooo001>0?ooo`8006Ko=`3oool2001Vo`l0oooo00H0^W:K0=Coo`00I_l006Ko09/0V`3Dool4
0?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo
00<000000?ooo`3oool0603oool2001Voa00oooo0`00I_lg0?ooo`03001Vo`3oool0oooo04d0oooo
001?0?ooo`03001Vo`3oool0oooo03H0oooo0P00I_l=0?ooo`030?oDV`00Vm@0oooo008006Ko00<0
j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo01P0oooo0P00
I_l?0?ooo`<006Ko=`3oool2001Vodl0oooo001?0?ooo`8006Ko>03oool00`00I_l0oooo0?ooo`0;
0?ooo`030>ZjLP1b^^X0oooo008006Ko00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`05
0?ooo`<00000603oool2001Vo`h0oooo0`00I_lh0?ooo`03001Vo`3oool0oooo04h0oooo001@0?oo
o`03001Vo`3oool0oooo03H0oooo0P00I_l30?ooo`030;Yb00000000000000<0000000H007:j0?oo
o`3oool0j[Yb07:jjP3oool2001Vo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3o
ool00`000000oooo0?ooo`0H0?ooo`8006Ko3@3oool3001VocP0oooo0P00I_m@0?ooo`00D03oool2
001VocP0oooo0P00I_l;0?ooo`030>ZjLP1b^^X0oooo008006Ko00<0omBK002Ke03oool02P3oool0
0`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool05`3oool2
001Vo`h0oooo0P00I_li0?ooo`03001Vo`3oool0oooo04l0oooo001A0?ooo`03001Vo`3oool0oooo
03L0oooo0P00I_l:0?ooo`030?oDV`1b^^X0oooo008006Ko00<0j[Yb07:jjP3oool02P3oool00`3o
om@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01L0oooo0P00I_l=0?ooo`8006Ko>P3oool00`00
I_l0oooo0?ooo`1?0?ooo`00D@3oool2001VocT0oooo00<006Ko0?ooo`3oool02@3oool01P2jLP00
VmCo001Vo`00I_l0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`0G
0?ooo`8006Ko303oool3001VocT0oooo0P00I_mA0?ooo`00DP3oool00`00I_l0oooo0?ooo`0g0?oo
o`8006Ko2P3oool01@3oom@0V`00001Vo`00I_l0^^[o00`0oooo00<0oooD09/0000000000P000000
0`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo01L0oooo0P00I_l;0?ooo`<006Ko>P3oool0
0`00I_l0oooo0?ooo`1@0?ooo`00DP3oool00`00I_l0oooo0?ooo`0h0?ooo`8006Ko303oool2001V
oaT0oooo00<000000?ooo`3oool05`3oool2001Vo`/0oooo0P00I_lj0?ooo`8006KoDP3oool00580
oooo0P00I_lj0?ooo`8006Ko2`3oool2001VoaT0oooo00<000000?ooo`3oool05P3oool2001Vo`/0
oooo0P00I_lk0?ooo`03001Vo`3oool0oooo0540oooo001C0?ooo`03001Vo`3oool0oooo03T0oooo
00<006Ko0?ooo`3oool02@3oool2001VoaT0oooo00<000000?ooo`3oool05P3oool2001Vo`X0oooo
0P00I_lk0?ooo`8006KoD`3oool005<0oooo0P00I_lj0?ooo`8006Ko2P3oool2001VoaT0oooo00<0
00000?ooo`3oool05P3oool2001Vo`X0oooo00<006Ko0?ooo`3oool0>@3oool2001Voe@0oooo001D
0?ooo`03001Vo`3oool0oooo03T0oooo0P00I_l90?ooo`8006Ko6@3oool00`000000oooo0?ooo`0F
0?ooo`8006Ko2@3oool2001Voc/0oooo00<006Ko0?ooo`3oool0D`3oool005@0oooo0P00I_lk0?oo
o`8006Ko2@3oool2001VoaP0oooo00<000000?ooo`3oool05P3oool2001Vo`P0oooo0P00I_lk0?oo
o`8006KoE@3oool005D0oooo00<006Ko0?ooo`3oool0>P3oool2001Vo`P0oooo0P00I_lH0?ooo`03
0000003oool0oooo01D0oooo0P00I_l90?ooo`03001Vo`3oool0oooo03T0oooo0P00I_mF0?ooo`00
E@3oool2001Voc`0oooo00<006Ko0?ooo`3oool01P3oool2001VoaP0oooo00<000000?ooo`3oool0
5@3oool2001Vo`P0oooo0P00I_lk0?ooo`03001Vo`3oool0oooo05D0oooo001F0?ooo`8006Ko>`3o
ool2001Vo`L0oooo0P00I_lH0?ooo`030000003oool0oooo01D0oooo0P00I_l80?ooo`03001Vo`3o
ool0oooo03T0oooo0P00I_mG0?ooo`00E`3oool2001Voc/0oooo0P00I_l60?ooo`8006Ko603oool0
0`000000oooo0?ooo`0E0?ooo`8006Ko1`3oool2001VocX0oooo0P00I_mH0?ooo`00F03oool00`00
I_l0oooo0?ooo`0j0?ooo`8006Ko1@3oool3001VoaL0oooo00<000000?ooo`3oool0503oool3001V
o`H0oooo0P00I_lk0?ooo`03001Vo`3oool0oooo05L0oooo001H0?ooo`8006Ko?03oool00`00I_l0
oooo0?ooo`040?ooo`8006Ko5`3oool2000001D0oooo0P00I_l70?ooo`03001Vo`3oool0oooo03T0
oooo0P00I_mI0?ooo`00F@3oool2001Voc/0oooo0P00I_l50?ooo`8006Ko5`3oool00`000000oooo
0?ooo`0D0?ooo`8006Ko1P3oool2001VocX0oooo0P00I_mJ0?ooo`00FP3oool2001Voc/0oooo0P00
I_l40?ooo`8006Ko5`3oool00`000000oooo0?ooo`0D0?ooo`8006Ko1@3oool2001Voc/0oooo00<0
06Ko0?ooo`3oool0F@3oool005/0oooo0P00I_lk0?ooo`03001Vo`3oool0oooo0080oooo0`00I_lF
0?ooo`030000003oool0oooo01<0oooo0`00I_l50?ooo`03001Vo`3oool0oooo03T0oooo0P00I_mK
0?ooo`00G03oool2001VocX0oooo0P00I_l40?ooo`8006Ko5P3oool00`000000oooo0?ooo`0C0?oo
o`8006Ko1@3oool2001VocX0oooo0P00I_mL0?ooo`00G03oool3001VocX0oooo0P00I_l30?ooo`80
06Ko5P3oool00`000000oooo0?ooo`0C0?ooo`8006Ko103oool2001VocX0oooo0P00I_mM0?ooo`00
G@3oool2001Voc/0oooo0P00I_l20?ooo`<006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`8006Ko
103oool00`00I_l0oooo0?ooo`0h0?ooo`<006KoG@3oool005h0oooo0P00I_lk0?ooo`04001Vo`3o
ool0oooo0?ooo`8006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`8006Ko0`3oool2001VocX0oooo
0P00I_mN0?ooo`00G`3oool2001VocX0oooo0P00I_l20?ooo`8006Ko5@3oool00`000000oooo0?oo
o`0B0?ooo`<006Ko0P3oool2001VocX0oooo0P00I_mO0?ooo`00G`3oool3001VocX0oooo00<006Ko
0?ooo`3oool00P00I_lE0?ooo`030000003oool0oooo0180oooo0P00I_l30?ooo`03001Vo`3oool0
oooo03P0oooo0`00I_mO0?ooo`00H03oool3001VocT0oooo0P00I_l0103oool006Ko001Vo`00I_lD
0?ooo`030000003oool0oooo0180oooo0P00I_l20?ooo`8006Ko>@3oool3001Vof00oooo001Q0?oo
o`<006Ko>@3oool00`00I_l0oooo0?ooo`02001Voa@0oooo00<000000?ooo`3oool04P3oool2001V
o`80oooo00<006Ko0?ooo`3oool0=`3oool3001Vof40oooo001R0?ooo`8006Ko>@3oool2001Vo`03
0?ooo`00I_l006Ko01@0oooo00<000000?ooo`3oool04@3oool3001Vo`030?ooo`00I_l006Ko03P0
oooo0`00I_mR0?ooo`00H`3oool2001VocT0oooo00<006Ko0?ooo`00I_l00P00I_lC0?ooo`030000
003oool0oooo0140oooo0P00I_l00`3oool006Ko001Vo`0i0?ooo`8006KoH`3oool006<0oooo0`00
I_lh0?ooo`8006Ko00<0oooo001Vo`00I_l04`3oool00`000000oooo0?ooo`0A0?ooo`8006Ko00<0
oooo001Vo`3oool0>03oool2001Vof@0oooo001T0?ooo`<006Ko>03oool01000I_l0oooo001Vo`00
I_lC0?ooo`030000003oool0oooo0140oooo1000I_lh0?ooo`<006KoI03oool006D0oooo0`00I_lg
0?ooo`@006Ko4`3oool200000140oooo1000I_lh0?ooo`<006KoI@3oool006H0oooo0`00I_lg0?oo
o`@006Ko4P3oool00`000000oooo0?ooo`0@0?ooo`<006Ko>03oool3001VofH0oooo001W0?ooo`80
06Ko>03oool3001Voa80oooo00<000000?ooo`3oool0403oool3001VocL0oooo0`00I_mW0?ooo`00
J03oool2001VocL0oooo0`00I_lB0?ooo`030000003oool0oooo0100oooo0P00I_lh0?ooo`8006Ko
J03oool006P0oooo0`00I_lg0?ooo`8006Ko4P3oool00`000000oooo0?ooo`0?0?ooo`<006Ko=`3o
ool2001VofT0oooo001Y0?ooo`<006Ko=P3oool3001Voa40oooo00<000000?ooo`3oool03P3oool3
001VocL0oooo0`00I_mY0?ooo`00JP3oool3001VocH0oooo0P00I_lA0?ooo`030000003oool0oooo
00h0oooo0`00I_lf0?ooo`<006KoJP3oool006/0oooo0`00I_lf0?ooo`03001Vo`3oool0oooo00l0
oooo00<000000?ooo`3oool0AP3oool3001Vof/0oooo001/0?ooo`<006KoA`3oool00`000000oooo
0?ooo`150?ooo`<006KoK03oool006d0oooo1000I_ld0?ooo`03001Vo`3oool0oooo00h0oooo00<0
00000?ooo`3oool0@`3oool4001Vofd0oooo001^0?ooo`@006KoA03oool00`000000oooo0?ooo`12
0?ooo`@006KoKP3oool00700oooo0`00I_m30?ooo`030000003oool0oooo0440oooo0`00I_m`0?oo
o`00L@3oool3001Vod80oooo00<000000?ooo`3oool0@03oool3001Vog40oooo001b0?ooo`<006Ko
@@3oool00`000000oooo0?ooo`0o0?ooo`<006KoLP3oool007<0oooo0`00I_m00?ooo`030000003o
ool0oooo03h0oooo0`00I_mc0?ooo`00M03oool4001Voch0oooo00<000000?ooo`3oool0?@3oool3
001Vog@0oooo001e0?ooo`@006Ko?@3oool00`000000oooo0?ooo`0k0?ooo`@006KoM@3oool007L0
oooo0`00I_ll0?ooo`800000>`3oool4001VogH0oooo001h0?ooo`<006Ko>`3oool00`000000oooo
0?ooo`0i0?ooo`<006KoN03oool007T0oooo0`00I_lj0?ooo`030000003oool0oooo03P0oooo0`00
I_mi0?ooo`00NP3oool3001VocT0oooo00<000000?ooo`3oool0=`3oool3001VogX0oooo001k0?oo
o`@006Ko=`3oool00`000000oooo0?ooo`0e0?ooo`@006KoN`3oool007`0oooo1000I_lf0?ooo`03
0000003oool0oooo03@0oooo1000I_ml0?ooo`00OP3oool3001VocD0oooo00<000000?ooo`3oool0
<`3oool3001Vogh0oooo001o0?ooo`<006Ko=03oool00`000000oooo0?ooo`0a0?ooo`@006KoO`3o
ool00800oooo0`00I_lc0?ooo`030000003oool0oooo0300oooo1000I_n00?ooo`00P@3oool3001V
oc80oooo00<000000?ooo`3oool0;`3oool3001Voh80oooo00220?ooo`@006Ko<03oool00`000000
oooo0?ooo`0^0?ooo`<006KoP`3oool008<0oooo1000I_l_0?ooo`030000003oool0oooo02d0oooo
0`00I_n40?ooo`00Q@3oool3001Vobh0oooo00<000000?ooo`3oool0:`3oool4001VohD0oooo0026
0?ooo`@006Ko;03oool00`000000oooo0?ooo`0Z0?ooo`@006KoQP3oool007X0oooo4P00I_lZ0?oo
o`030000003oool0oooo02P0oooo4@00I_mk0?ooo`00M`3ooolG001VobP0oooo00<000000?ooo`3o
ool09P3ooolG001VogL0oooo001e0?ooo`H006Ko303oool9001VobH0oooo0P00000U0?ooo`T006Ko
2`3oool6001VogH0oooo000A0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0@P3o
ool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01P3DV`000000
000000000000VmCo0?ooo`@006Ko?P3oool00`000000oooo0?ooo`0l0?ooo`<006Ko1@3oool01@3o
e9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`00000000000000
0000VmCo04@0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0<0?ooo`00503oool0
0`2jLW80^^[o0?ooo`150?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000
002Ke0040?ooo`060=BK0000Vm@0oooo0?ooo`3oj[X0LP001000I_lo0?ooo`030000003oool0oooo
03d0oooo0P00I_l50?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002K
e0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`160?ooo`030;YbLP2jj_l0oooo00l0
oooo000D0?ooo`030;YbLP2jj_l0oooo04@0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z
0?ooo`0?0?ooo`040?oDV`00I_l006Ko001Vod00oooo00<000000?ooo`3oool0?@3oool2001Vo`@0
oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo04D0
oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK001Vo`00I_l0@@3oool00`000000oooo
0?ooo`0m0?ooo`8006Ko103oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo
00<0omBK002Ke03oool0A@3oool00`2jLW80^^[o0?ooo`0?0?ooo`00203oool00`2jLP0000000000
000300000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool0>`3oool00`2jLP0000000000
000300000005001b^P3oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`040;Yb
0000I_l006Ko001Vod00oooo00<000000?ooo`3oool0?@3oool2001Vo`@0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo04D0oooo00<0^W9b0;[Zo`3o
ool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00X0oooo00<0oooD09/0000000000P000000101b^^X0oooo001Vo`00I_m00?ooo`03
0000003oool0oooo03d0oooo0P00I_l40?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03o
ool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo04D0oooo00<0^W9b0;[Zo`3o
ool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3oe9/0L[[Z0?ooo`020?ooo`030>Zj
LP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0103oool3001Vocl0oooo00<000000?ooo`3oool0
?03oool3001Vo`@0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?oo
e02K09/0e?oo04X0oooo00<0^W9b0;[Zo`3oool03`3oool00140oooo00D0j[Yb00000000L[X0^W9b
0;[Zo`160?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`040?oo
o`@006Ko?P3oool00`000000oooo0?ooo`0k0?ooo`<006Ko1P3oool01P2jLP00VmCo0?ooo`3oj[X0
LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool0A`3oool01@3Z^W800000001b^P2jLW80^^[o0100oooo
000C0?ooo`030>ZjLP000780^^[o04H0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?oo
e02K000000000080000000@0002K0=Coo`3oool0oooo1000I_ll0?ooo`030000003oool0oooo03X0
oooo0`00I_l70?ooo`050?ooe02K000000000000LP2jj_l0303oool00`3oom@0V`00000000020000
00030000V`3Dool0oooo04@0oooo00<0j[Yb0000LP2jj_l0403oool007L0oooo1@00I_lj0?ooo`03
0000003oool0oooo03T0oooo0`00I_mh0?ooo`00N@3oool4001VocT0oooo00<000000?ooo`3oool0
=`3oool4001VogT0oooo001k0?ooo`@006Ko=`3oool00`000000oooo0?ooo`0f0?ooo`@006KoNP3o
ool007`0oooo1000I_lf0?ooo`030000003oool0oooo03@0oooo1000I_ml0?ooo`00OP3oool4001V
oc@0oooo00<000000?ooo`3oool0<P3oool5001Vogd0oooo001o0?ooo`H006Ko<@3oool00`000000
oooo0?ooo`0^0?ooo`L006KoO`3oool00840oooo1`00I_l^0?ooo`030000003oool0oooo02/0oooo
1`00I_n20?ooo`00Q@000005001VoeT000001@00I_n50000000000<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0;0?ooo`/006Ko2@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00X0oooo1P00I_l>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo0@0000000100oooo00<000000?oo
o`3oool0D03oool00`000000oooo0?ooo`0I0?ooo`L006Ko<03oool00`000000oooo0?ooo`0]0?oo
o`L006Ko703oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00l0oooo001m0?ooo`D0
06Ko=03oool00`000000oooo0?ooo`0`0?ooo`L006KoO@3oool007/0oooo1@00I_lf0?ooo`030000
003oool0oooo03@0oooo1@00I_mk0?ooo`00NP3oool4001VocP0oooo00<000000?ooo`3oool0=P3o
ool4001VogX0oooo001i0?ooo`<006Ko>P3oool00`000000oooo0?ooo`0h0?ooo`<006KoN@3oool0
07P0oooo0`00I_lk0?ooo`030000003oool0oooo03T0oooo0`00I_mh0?ooo`00MP3oool4001Voc`0
oooo00<000000?ooo`3oool0>P3oool3001VogL0oooo001e0?ooo`@006Ko?@3oool00`000000oooo
0?ooo`0k0?ooo`<006KoMP3oool007@0oooo0`00I_lo0?ooo`030000003oool0oooo03`0oooo0`00
I_me0?ooo`00M03oool2001Vod00oooo00<000000?ooo`3oool0?@3oool2001VogD0oooo001c0?oo
o`<006Ko@03oool00`000000oooo0?ooo`0m0?ooo`8006KoM@3oool007<0oooo0P00I_m10?ooo`03
0000003oool0oooo03d0oooo0P00I_me0?ooo`00L`3oool2001Vod40oooo00<000000?ooo`3oool0
?@3oool2001VogD0oooo001c0?ooo`<006Ko@03oool00`000000oooo0?ooo`0m0?ooo`8006KoM@3o
ool007<0oooo1000I_lo0?ooo`030000003oool0oooo03`0oooo0`00I_me0?ooo`00M@3oool4001V
ocd0oooo0P00000l0?ooo`@006KoM@3oool007H0oooo1P00I_l:0?ooo`P006Ko:03oool00`000000
oooo0?ooo`0W0?ooo`L006Ko2@3oool7001VogH0oooo001h0?oooa@006Ko:P3oool00`000000oooo
0?ooo`0X0?oooa@006KoN03oool007/0oooo3`00I_l/0?ooo`030000003oool0oooo02T0oooo3`00
I_ml0?ooo`00Q@3oool3001Vobh0oooo00<000000?ooo`3oool0:P3oool4001VohH0oooo00240?oo
o`<006Ko;`3oool00`000000oooo0?ooo`0/0?ooo`<006KoQ@3oool008<0oooo0`00I_l`0?ooo`03
0000003oool0oooo02d0oooo1000I_n30?ooo`00P@3oool4001Voc40oooo00<000000?ooo`3oool0
;P3oool4001Voh80oooo00200?ooo`@006Ko<P3oool00`000000oooo0?ooo`0`0?ooo`@006KoP03o
ool007l0oooo0`00I_ld0?ooo`030000003oool0oooo0340oooo1000I_mo0?ooo`00OP3oool3001V
ocD0oooo00<000000?ooo`3oool0<`3oool3001Vogh0oooo001m0?ooo`<006Ko=P3oool00`000000
oooo0?ooo`0d0?ooo`@006KoO03oool007/0oooo1000I_lg0?ooo`030000003oool0oooo03D0oooo
1000I_mk0?ooo`00NP3oool4001VocP0oooo00<000000?ooo`3oool0=`3oool3001VogX0oooo001i
0?ooo`<006Ko>P3oool00`000000oooo0?ooo`0h0?ooo`<006KoN@3oool007P0oooo0`00I_lk0?oo
o`030000003oool0oooo03T0oooo0`00I_mh0?ooo`00M`3oool3001Voc`0oooo0P00000k0?ooo`<0
06KoM`3oool007H0oooo0`00I_lm0?ooo`030000003oool0oooo03/0oooo0`00I_mf0?ooo`00M03o
ool4001Voch0oooo00<000000?ooo`3oool0?03oool3001VogD0oooo001c0?ooo`@006Ko?`3oool0
0`000000oooo0?ooo`0m0?ooo`<006KoM03oool00780oooo0`00I_m10?ooo`030000003oool0oooo
03h0oooo1000I_mb0?ooo`00L@3oool3001Vod80oooo00<000000?ooo`3oool0?`3oool4001Vog40
oooo001`0?ooo`<006Ko@`3oool00`000000oooo0?ooo`110?ooo`<006KoL03oool006l0oooo0`00
I_m40?ooo`030000003oool0oooo0480oooo0`00I_m_0?ooo`00KP3oool3001VodD0oooo00<00000
0?ooo`3oool0@`3oool3001Vofh0oooo001]0?ooo`<006KoAP3oool00`000000oooo0?ooo`0>0?oo
o`03001Vo`3oool0oooo03<0oooo0`00I_m]0?ooo`00K03oool3001Voc@0oooo0P00I_lA0?ooo`03
0000003oool0oooo00h0oooo0P00I_le0?ooo`<006KoK03oool006/0oooo0`00I_le0?ooo`8006Ko
4@3oool00`000000oooo0?ooo`0>0?ooo`<006Ko=@3oool3001Vof/0oooo001Z0?ooo`<006Ko=P3o
ool2001Voa40oooo00<000000?ooo`3oool03P3oool3001VocH0oooo0`00I_mZ0?ooo`00J@3oool3
001VocH0oooo0P00I_lB0?ooo`030000003oool0oooo00h0oooo1000I_lf0?ooo`<006KoJ@3oool0
06P0oooo0`00I_lg0?ooo`8006Ko4P3oool00`000000oooo0?ooo`0?0?ooo`<006Ko=`3oool2001V
ofT0oooo001W0?ooo`<006Ko=`3oool2001Voa<0oooo00<000000?ooo`3oool03`3oool4001VocL0
oooo0P00I_mX0?ooo`00IP3oool3001VocL0oooo0`00I_lC0?ooo`030000003oool0oooo00l0oooo
1000I_lg0?ooo`<006KoI`3oool006D0oooo0`00I_lh0?ooo`<006Ko4`3oool200000140oooo1000
I_lg0?ooo`<006KoIP3oool006@0oooo0`00I_lh0?ooo`@006Ko4`3oool00`000000oooo0?ooo`0@
0?ooo`@006Ko>03oool3001VofD0oooo001S0?ooo`<006Ko>@3oool01000I_l0oooo001Vo`00I_lC
0?ooo`030000003oool0oooo0140oooo1000I_lh0?ooo`<006KoI03oool00680oooo0`00I_li0?oo
o`8006Ko00<0oooo001Vo`00I_l04`3oool00`000000oooo0?ooo`0A0?ooo`@006Ko>@3oool3001V
of<0oooo001Q0?ooo`<006Ko>@3oool2001Vo`040?ooo`00I_l006Ko001Voa<0oooo00<000000?oo
o`3oool04@3oool2001Vo`030?ooo`00I_l0oooo03T0oooo0`00I_mR0?ooo`00H@3oool2001VocX0
oooo00<006Ko0?ooo`3oool00P00I_lD0?ooo`030000003oool0oooo0140oooo1@00I_lj0?ooo`80
06KoHP3oool00600oooo0P00I_lj0?ooo`8006Ko0P3oool2001Voa@0oooo00<000000?ooo`3oool0
4P3oool2001Vo`030?ooo`00I_l006Ko03X0oooo0P00I_mQ0?ooo`00G`3oool2001Voc/0oooo00<0
06Ko0?ooo`3oool00`00I_lD0?ooo`030000003oool0oooo0180oooo0P00I_l20?ooo`03001Vo`3o
ool0oooo03P0oooo0`00I_mP0?ooo`00G`3oool00`00I_l0oooo0?ooo`0i0?ooo`8006Ko0P3oool2
001VoaD0oooo00<000000?ooo`3oool04P3oool2001Vo`80oooo0P00I_lj0?ooo`<006KoG`3oool0
05h0oooo0P00I_lj0?ooo`8006Ko0`3oool2001VoaD0oooo00<000000?ooo`3oool04P3oool3001V
o`80oooo0P00I_lj0?ooo`<006KoGP3oool005d0oooo0P00I_lk0?ooo`04001Vo`3oool0oooo0?oo
o`<006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`8006Ko0`3oool00`00I_l0oooo0?ooo`0i0?oo
o`8006KoGP3oool005`0oooo0P00I_lk0?ooo`8006Ko0`3oool2001VoaH0oooo00<000000?ooo`3o
ool04`3oool2001Vo`<0oooo0P00I_lk0?ooo`8006KoG@3oool005`0oooo00<006Ko0?ooo`3oool0
>@3oool2001Vo`@0oooo0P00I_lF0?ooo`030000003oool0oooo01<0oooo0`00I_l30?ooo`8006Ko
>`3oool2001Voe`0oooo001K0?ooo`8006Ko>`3oool00`00I_l0oooo0?ooo`030?ooo`8006Ko5P3o
ool00`000000oooo0?ooo`0D0?ooo`8006Ko103oool00`00I_l0oooo0?ooo`0j0?ooo`03001Vo`3o
ool0oooo05X0oooo001J0?ooo`8006Ko>`3oool2001Vo`D0oooo0P00I_lF0?ooo`030000003oool0
oooo01@0oooo0P00I_l40?ooo`8006Ko>`3oool2001Voe/0oooo001J0?ooo`03001Vo`3oool0oooo
03T0oooo0P00I_l60?ooo`8006Ko5P3oool00`000000oooo0?ooo`0D0?ooo`8006Ko1@3oool2001V
oc/0oooo0P00I_mJ0?ooo`00F@3oool2001VocX0oooo0P00I_l60?ooo`8006Ko5`3oool2000001D0
oooo0`00I_l50?ooo`03001Vo`3oool0oooo03X0oooo0P00I_mI0?ooo`00F03oool2001Voc/0oooo
00<006Ko0?ooo`3oool01@3oool2001VoaL0oooo00<000000?ooo`3oool05@3oool2001Vo`D0oooo
0P00I_ll0?ooo`03001Vo`3oool0oooo05L0oooo001H0?ooo`03001Vo`3oool0oooo03T0oooo0P00
I_l70?ooo`8006Ko5`3oool00`000000oooo0?ooo`0E0?ooo`8006Ko1P3oool2001Voc/0oooo0P00
I_mH0?ooo`00E`3oool2001VocX0oooo0P00I_l80?ooo`8006Ko5`3oool00`000000oooo0?ooo`0E
0?ooo`8006Ko1`3oool2001Voc/0oooo0P00I_mG0?ooo`00EP3oool2001Voc/0oooo00<006Ko0?oo
o`3oool01`3oool2001VoaL0oooo00<000000?ooo`3oool05@3oool2001Vo`L0oooo0`00I_lk0?oo
o`03001Vo`3oool0oooo05D0oooo001E0?ooo`8006Ko>`3oool2001Vo`P0oooo0P00I_lH0?ooo`03
0000003oool0oooo01H0oooo0P00I_l70?ooo`8006Ko>`3oool2001VoeH0oooo001E0?ooo`03001V
o`3oool0oooo03T0oooo0P00I_l90?ooo`8006Ko603oool00`000000oooo0?ooo`0F0?ooo`8006Ko
203oool2001Voc/0oooo0P00I_mE0?ooo`00E03oool2001Voc/0oooo00<006Ko0?ooo`3oool0203o
ool2001VoaP0oooo00<000000?ooo`3oool05P3oool2001Vo`P0oooo0`00I_lk0?ooo`8006KoE03o
ool005<0oooo0P00I_lk0?ooo`8006Ko2P3oool2001VoaP0oooo00<000000?ooo`3oool05P3oool2
001Vo`T0oooo0`00I_lk0?ooo`03001Vo`3oool0oooo0580oooo001C0?ooo`03001Vo`3oool0oooo
03T0oooo0P00I_l;0?ooo`8006Ko603oool00`000000oooo0?ooo`0F0?ooo`8006Ko2P3oool3001V
ocX0oooo0P00I_mC0?ooo`00DP3oool2001VocX0oooo0P00I_l;0?ooo`8006Ko6@3oool00`000000
oooo0?ooo`0G0?ooo`8006Ko2P3oool2001Voc/0oooo0P00I_mB0?ooo`00DP3oool00`00I_l0oooo
0?ooo`0i0?ooo`03001Vo`3oool0oooo00X0oooo0P00I_lI0?ooo`030000003oool0oooo01L0oooo
0P00I_l;0?ooo`8006Ko>`3oool00`00I_l0oooo0?ooo`1@0?ooo`00D@3oool2001VocX0oooo0P00
I_l<0?ooo`8006Ko6@3oool00`000000oooo0?ooo`0G0?ooo`8006Ko2`3oool3001VocX0oooo0P00
I_mA0?ooo`00D@3oool00`00I_l0oooo0?ooo`0h0?ooo`8006Ko2P3oool00`3oe9/0000000000002
001Vo`D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo00<0
00000?ooo`3oool05`3oool2001Vo``0oooo0`00I_li0?ooo`8006KoD@3oool00540oooo00<006Ko
0?ooo`3oool0=`3oool2001Vo`/0oooo00<0^W:K0=Coo`3oool00P00I_l00`3Dool0oooo0?ooo`02
0?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo
00<000000?ooo`3oool05`3oool2001Vo`d0oooo0`00I_li0?ooo`8006KoD03oool00500oooo0P00
I_lh0?ooo`8006Ko2`3oool00`3oe9/009_D0?ooo`03001Vo`0307:jjP3oool0oooo00h0oooo00<0
omBK002Ke03oool01@3oool00`000000oooo0?ooo`0H0?ooo`8006Ko3@3oool2001VocT0oooo0P00
I_m@0?ooo`00D03oool00`00I_l0oooo0?ooo`0g0?ooo`03001Vo`3oool0oooo00X0oooo00<0j[Yb
07:jjP3oool00P00I_l00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<00000
0?ooo`3oool0603oool2001Vo`h0oooo0P00I_li0?ooo`03001Vo`3oool0oooo04h0oooo001?0?oo
o`8006Ko>03oool2001Vo``0oooo00<0j[Yb07:jjP3oool00P00I_l00`3oe9/009_D0?ooo`0?0?oo
o`030;Yb002Ke?l0oooo00D0oooo0`00000H0?ooo`8006Ko3P3oool3001VocP0oooo0P00I_m?0?oo
o`00C`3oool00`00I_l0oooo0?ooo`0f0?ooo`8006Ko3@3oool00`3Z^W80L[[Z0?ooo`02001Vo`03
0?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`050?ooo`03
0000003oool0oooo01P0oooo0P00I_l?0?ooo`<006Ko>03oool00`00I_l0oooo0?ooo`1=0?ooo`00
CP3oool2001VocL0oooo0P00I_l>0?ooo`030?oDV`1b^^X006Ko008006Ko00<0j[Yb07:jjP3oool0
2P3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01P0oooo0P00I_l@0?ooo`<006Ko
=`3oool2001Vodh0oooo001>0?ooo`03001Vo`3oool0oooo03D0oooo0P00I_l@0?ooo`060;Yb0000
I_l006Ko0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01P0
oooo0P00I_lA0?ooo`8006Ko>03oool00`00I_l0oooo0?ooo`1<0?ooo`00C@3oool2001VocH0oooo
0`00I_l@0?ooo`050?ooe000I_l006Ko0000LP2jj_l0303oool00`3oom@0V`000000000200000003
0000V`3Dool0oooo00D0oooo00<000000?ooo`3oool0603oool2001Voa80oooo0P00I_lg0?ooo`80
06KoC@3oool004d0oooo00<006Ko0?ooo`3oool0=03oool3001Voa80oooo0P00I_lK0?ooo`030000
003oool0oooo01P0oooo0P00I_lB0?ooo`<006Ko=P3oool2001Vodd0oooo001<0?ooo`8006Ko=P3o
ool2001Voa<0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0P00I_lC0?ooo`<006Ko=@3o
ool2001Vodd0oooo001<0?ooo`8006Ko=@3oool2001Voa<0oooo0`00I_lK0?ooo`030000003oool0
oooo01T0oooo0P00I_lC0?ooo`<006Ko=03oool3001Vod`0oooo001<0?ooo`8006Ko=03oool3001V
oa<0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lD0?ooo`8006Ko=@3oool2001V
od`0oooo001<0?ooo`8006Ko<`3oool3001Voa@0oooo0P00I_lL0?ooo`030000003oool0oooo01T0
oooo0P00I_lE0?ooo`8006Ko=03oool2001Vod`0oooo001;0?ooo`8006Ko<`3oool3001VoaD0oooo
0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_lE0?ooo`<006Ko<`3oool2001Vod`0oooo
001;0?ooo`8006Ko<P3oool3001VoaH0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00
I_lF0?ooo`<006Ko<P3oool3001Vod/0oooo001;0?ooo`8006Ko<P3oool2001VoaL0oooo0P00I_lL
0?ooo`030000003oool0oooo01T0oooo0P00I_lG0?ooo`<006Ko<P3oool2001Vod/0oooo001;0?oo
o`03001Vo`3oool0oooo0300oooo0P00I_lH0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?oo
o`8006Ko603oool3001Voc40oooo0P00I_m;0?ooo`00BP3oool2001Voc40oooo0`00I_lH0?ooo`80
06Ko703oool00`000000oooo0?ooo`0I0?ooo`<006Ko603oool3001Voc00oooo0`00I_m:0?ooo`00
BP3oool00`00I_l0oooo0?ooo`0_0?ooo`<006Ko6@3oool2001Voa`0oooo00<000000?ooo`3oool0
6P3oool2001VoaT0oooo1000I_l^0?ooo`8006KoB`3oool004T0oooo0P00I_l`0?ooo`<006Ko6@3o
ool2001Voad0oooo0P00000K0?ooo`8006Ko6P3oool4001Vobd0oooo0P00I_m;0?ooo`00B@3oool2
001Vobl0oooo0`00I_lJ0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko703oool3
001Vob`0oooo0P00I_m;0?ooo`00B@3oool2001Vobh0oooo0`00I_lK0?ooo`8006Ko7@3oool00`00
0000oooo0?ooo`0J0?ooo`8006Ko7@3oool3001Vob/0oooo0P00I_m;0?ooo`00B@3oool2001Vob`0
oooo1000I_lL0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko7P3oool3001VobX0
oooo0P00I_m;0?ooo`00B@3oool2001Vob/0oooo1000I_lM0?ooo`8006Ko7@3oool00`000000oooo
0?ooo`0J0?ooo`8006Ko7`3oool3001VobT0oooo0P00I_m;0?ooo`00B@3oool2001VobX0oooo0`00
I_lO0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko803oool4001VobL0oooo0P00
I_m;0?ooo`00B@3oool2001VobT0oooo0`00I_lP0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J
0?ooo`8006Ko8@3oool4001VobH0oooo0P00I_m;0?ooo`00B@3oool2001VobP0oooo0`00I_lQ0?oo
o`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko8`3oool3001VobD0oooo0P00I_m;0?oo
o`00B@3oool2001VobH0oooo1000I_lR0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`80
06Ko903oool3001Vob@0oooo0P00I_m;0?ooo`00B@3oool3001Vob<0oooo1@00I_lS0?ooo`8006Ko
7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko9@3oool4001Vob80oooo0P00I_m;0?ooo`00BP3o
ool2001Vob80oooo1000I_lT0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`8006Ko9P3o
ool4001Vob40oooo0P00I_m;0?ooo`00BP3oool2001Vob00oooo1000I_lV0?ooo`8006Ko7P3oool0
0`000000oooo0?ooo`0J0?ooo`8006Ko:03oool4001Voal0oooo0P00I_m;0?ooo`00BP3oool3001V
oad0oooo1@00I_lW0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`8006Ko:@3oool4001V
oah0oooo00<006Ko0?ooo`3oool0BP3oool004/0oooo0P00I_lK0?ooo`D006Ko:@3oool2001Voah0
oooo00<000000?ooo`3oool06P3oool2001Vob/0oooo1000I_lK0?ooo`8006KoC03oool004`0oooo
0P00I_lH0?ooo`D006Ko:`3oool2001Voah0oooo00<000000?ooo`3oool06P3oool2001Vob`0oooo
1000I_lI0?ooo`<006KoC03oool004d0oooo0P00I_lE0?ooo`D006Ko;@3oool2001Voah0oooo00<0
00000?ooo`3oool06P3oool2001Vobh0oooo1000I_lF0?ooo`<006KoC@3oool004d0oooo0`00I_lB
0?ooo`D006Ko;`3oool2001Voah0oooo00<000000?ooo`3oool06P3oool3001Vobh0oooo1P00I_lB
0?ooo`<006KoCP3oool004h0oooo1000I_l>0?ooo`D006Ko<@3oool2001Voah0oooo0P00000L0?oo
o`8006Ko<03oool8001Vo`d0oooo0`00I_m?0?ooo`00C`3oool4001Vo`X0oooo1P00I_lc0?ooo`80
06Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006Ko=03oool6001Vo`P0oooo1@00I_m@0?ooo`00
D@3oool@001VocD0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_lg0?ooo`l006Ko
D@3oool00580oooo3000I_lh0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`<006Ko>03o
ool:001Voe@0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool0
09H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0
oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo
0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00
I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?oo
o`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`03
0000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool0
6P3oool3001VoiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03o
ool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00UP3oool2001V
oah0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002F0?ooo`8006Ko7P3oool00`000000
oooo0?ooo`0J0?ooo`8006KoV03oool009H0oooo0P00I_lN0?ooo`8000006`3oool2001VoiP0oooo
002F0?ooo`<006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM
0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?oo
o`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`80
06KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3o
ool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool0
0`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo
01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0
oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009P0oooo0P00
I_lL0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00V03oool2001Voa`0oooo00<00000
0?ooo`3oool06P3oool2001VoiP0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?oo
o`8006KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00
V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703o
ool2000001X0oooo0P00I_nI0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool06@3oool2
001VoiT0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009T0
oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V@3oool2001Voa/0oooo
00<000000?ooo`3oool0603oool2001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?oo
o`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0P00I_nJ
0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002J0?ooo`80
06Ko6P3oool00`000000oooo0?ooo`0G0?ooo`<006KoVP3oool009X0oooo0P00I_lJ0?ooo`030000
003oool0oooo01L0oooo0P00I_nK0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool05`3o
ool2001Voi/0oooo002J0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3oool0
09X0oooo0`00I_lI0?ooo`030000003oool0oooo01H0oooo0`00I_nK0?ooo`00V`3oool2001Vo``0
oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo01H0
oooo0P00I_nL0?ooo`00V`3oool2001Vo`l0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo
0?ooo`0F0?ooo`8006KoW03oool009/0oooo0`00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<0
00000?ooo`3oool05P3oool2001Voi`0oooo002L0?ooo`8006Ko3P3oool00`2jLW80^^[o0?ooo`07
0?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00W03oool2001Vo`h0oooo00<0^W9b0;[Z
o`3oool01`3oool3000001H0oooo0P00I_nL0?ooo`00W03oool3001Vo`d0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`0E0?ooo`8006KoW@3oool009d0oooo0P00I_l=0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2001Void0oooo002M0?ooo`8006Ko2P3o
ool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool05@3oool2001Void0oooo
002M0?ooo`<006Ko2`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo01@0oooo0`00
I_nM0?ooo`00WP3oool2001VoaH0oooo00<000000?ooo`3oool0503oool2001Voih0oooo002N0?oo
o`<006Ko5@3oool00`000000oooo0?ooo`0D0?ooo`8006KoWP3oool009l0oooo0P00I_lE0?ooo`03
0000003oool0oooo01@0oooo00<006Ko0?ooo`3oool0W@3oool009l0oooo0P00I_lE0?ooo`030000
003oool0oooo01<0oooo0P00I_nO0?ooo`00W`3oool3001Voa@0oooo00<000000?ooo`3oool04P3o
ool2001Voj00oooo002P0?ooo`8006Ko503oool00`000000oooo0?ooo`0B0?ooo`03001Vo`3oool0
oooo09l0oooo002P0?ooo`<006Ko4`3oool00`000000oooo0?ooo`0A0?ooo`8006KoX@3oool00:40
oooo0P00I_lC0?ooo`030000003oool0oooo0140oooo00<006Ko0?ooo`3oool0X03oool00:40oooo
0P00I_lC0?ooo`030000003oool0oooo0100oooo0P00I_nR0?ooo`00X@3oool3001Voa80oooo00<0
00000?ooo`3oool0403oool00`00I_l0oooo0?ooo`2Q0?ooo`00XP3oool2001Voa80oooo00<00000
0?ooo`3oool03`3oool2001Voj<0oooo002S0?ooo`03001Vo`3oool0oooo0100oooo0P00000@0?oo
o`03001Vo`3oool0oooo0:80oooo002S0?ooo`8006Ko4@3oool00`000000oooo0?ooo`0>0?ooo`80
06KoY03oool00:@0oooo0P00I_l@0?ooo`030000003oool0oooo00h0oooo00<006Ko0?ooo`3oool0
X`3oool00:D0oooo0P00I_l?0?ooo`030000003oool0oooo00d0oooo0P00I_nU0?ooo`00YP3oool2
001Vo`h0oooo00<000000?ooo`3oool0303oool2001VojH0oooo002V0?ooo`<006Ko3@3oool00`00
0000oooo0?ooo`0;0?ooo`<006KoYP3oool00:L0oooo0`00I_l<0?ooo`030000003oool0oooo00X0
oooo0`00I_nW0?ooo`00Z03oool3001Vo`/0oooo00<000000?ooo`3oool02@3oool3001VojP0oooo
002Y0?ooo`<006Ko2P3oool00`000000oooo0?ooo`080?ooo`<006KoZ@3oool00:X0oooo0`00I_l9
0?ooo`030000003oool0oooo00H0oooo1000I_nZ0?ooo`00Z`3oool3001Vo`P0oooo00<000000?oo
o`3oool01@3oool4001Voj/0oooo002/0?ooo`<006Ko1`3oool00`000000oooo0?ooo`030?ooo`@0
06Ko[@3oool00:d0oooo1P00I_l30?ooo`030000003oool0oooo0080oooo1000I_n^0?ooo`00[P3o
ool?001Vok00oooo002b0?ooo`X006Ko/@3oool00;D0oooo0P00I_nf0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo0000\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.66364 .59091 m
.67462 .59626 L
.68423 .60183 L
.6943 .60907 L
.70165 .61606 L
.70455 .61966 L
.70584 .62157 L
.70701 .62359 L
.70787 .62535 L
.70864 .62727 L
.70915 .629 L
.70949 .63061 L
.70969 .63254 L
.70967 .63435 L
.70946 .63593 L
.70905 .63762 L
.70871 .63856 L
.70836 .6394 L
.70735 .64122 L
.70616 .64283 L
.70482 .64428 L
.70154 .64691 L
.6993 .64825 L
.69697 .64941 L
.69155 .65142 L
.68811 .65233 L
.68473 .65304 L
.68138 .65357 L
.67811 .65395 L
.67434 .65425 L
.67236 .65435 L
.67012 .65442 L
.66625 .65444 L
.66191 .65433 L
.65766 .6541 L
.65363 .65378 L
.65307 .65506 L
.65525 .65683 L
.65727 .65849 L
.66518 .66508 L
.68444 .68201 L
.72556 .72394 L
.75942 .7679 L
.77299 .78999 L
.78353 .8107 L
.79215 .8326 L
.79541 .8438 L
.79682 .84987 L
.79785 .85536 L
.79863 .86093 L
Mistroke
.79893 .86381 L
.79915 .86682 L
.79928 .86963 L
.79931 .87223 L
.79918 .87695 L
.79878 .88144 L
.79818 .88538 L
.79725 .88951 L
.79599 .89363 L
.79459 .89711 L
.7928 .90065 L
.79098 .90353 L
.78881 .90636 L
.78664 .90868 L
.78404 .91099 L
.77887 .9144 L
.77539 .91605 L
.77198 .91726 L
.768 .91827 L
.7659 .91864 L
.76355 .91895 L
.7594 .91922 L
.75475 .91917 L
.75017 .91878 L
.74585 .91814 L
.74131 .91721 L
.73635 .91592 L
.7271 .9128 L
.71666 .90828 L
.70467 .90192 L
.66031 .86877 L
.63337 .84167 L
.60813 .81133 L
.58604 .78035 L
.57446 .76219 L
.56894 .75303 L
.56398 .74449 L
.56469 .74968 L
.56757 .76085 L
.57315 .78499 L
.58096 .82826 L
.58393 .85114 L
.58527 .86421 L
.58624 .87605 L
.58702 .88851 L
.58733 .89531 L
.58756 .90171 L
.58778 .913 L
.58781 .91932 L
.58776 .92511 L
Mistroke
.58752 .93574 L
.5871 .94569 L
.58656 .95449 L
.58579 .96393 L
.58475 .97397 L
.58342 .98442 L
.58043 1.00251 L
.57664 1.01986 L
.57243 1.03517 L
.56296 1.06082 L
.55657 1.07383 L
.54922 1.08589 L
.54243 1.09486 L
.53476 1.10292 L
.53029 1.10672 L
.52614 1.10973 L
.52185 1.11232 L
.51784 1.1143 L
.51311 1.11609 L
.5106 1.11682 L
.50793 1.11742 L
.50343 1.11804 L
.50087 1.11817 L
.49846 1.11815 L
.49436 1.1178 L
.49 1.11697 L
.48591 1.11577 L
.48223 1.11433 L
.47793 1.1122 L
.47333 1.10937 L
.46521 1.10288 L
.45705 1.09423 L
.44892 1.08309 L
.44239 1.07188 L
.43595 1.05831 L
.43059 1.04439 L
.42622 1.03062 L
.42235 1.01565 L
.41929 1.00098 L
.4164 .98306 L
.41517 .97325 L
.41409 .96258 L
.41329 .95216 L
.41273 .9422 L
.4124 .93312 L
.41221 .92318 L
.41223 .91239 L
.41242 .90247 L
.41286 .8909 L
.41349 .87987 L
Mistroke
.41426 .86962 L
.41512 .8601 L
.41761 .8385 L
.42085 .81669 L
.42524 .79278 L
.43073 .76781 L
.43363 .75611 L
.43647 .74537 L
.43337 .74908 L
.42703 .75976 L
.41509 .77863 L
.38736 .81713 L
.33504 .87292 L
.3095 .89292 L
.29654 .90121 L
.28337 .90827 L
.27235 .91301 L
.26674 .91498 L
.26091 .91667 L
.25574 .91785 L
.25119 .91861 L
.24677 .91907 L
.24275 .91924 L
.23906 .91916 L
.23517 .9188 L
.2313 .91812 L
.22786 .91721 L
.22483 .91613 L
.22219 .91495 L
.21678 .91162 L
.21424 .90952 L
.21207 .90735 L
.20972 .90451 L
.20782 .90169 L
.20618 .89872 L
.20463 .89527 L
.20327 .89138 L
.20225 .88749 L
.2015 .88346 L
.20102 .87961 L
.20073 .87498 L
.2007 .87041 L
.2009 .86607 L
.20126 .86193 L
.20185 .85727 L
.20272 .85219 L
.20556 .84017 L
.20928 .82842 L
.2188 .80574 L
.23215 .78117 L
Mistroke
.24681 .75885 L
.28514 .7121 L
.31841 .67941 L
.3356 .66442 L
.33948 .66117 L
.3435 .65785 L
.34683 .65514 L
.34681 .65373 L
.34433 .65395 L
.34171 .65414 L
.3371 .65437 L
.33455 .65443 L
.33194 .65445 L
.32976 .65441 L
.32744 .65434 L
.32352 .6541 L
.32141 .6539 L
.31955 .65369 L
.31609 .65318 L
.31301 .65259 L
.31007 .65188 L
.30718 .65101 L
.30255 .64919 L
.29839 .64686 L
.29642 .64538 L
.29482 .64391 L
.29352 .64243 L
.29238 .64077 L
.2916 .6393 L
.29096 .63763 L
.29069 .63667 L
.29051 .63577 L
.29037 .63478 L
.2903 .63372 L
.29035 .6319 L
.29047 .63085 L
.29065 .62987 L
.29114 .62795 L
.2918 .62611 L
.29352 .62264 L
.29603 .61888 L
.29947 .61483 L
.30715 .6079 L
.31709 .601 L
.32737 .59523 L
.32992 .59394 L
.33268 .59261 L
.33529 .59139 L
.33505 .59031 L
.33216 .58896 L
Mistroke
.32946 .58765 L
.32351 .58454 L
.31371 .57865 L
.30448 .57172 L
.30045 .56799 L
.29671 .56381 L
.29425 .56038 L
.29224 .55672 L
.29142 .55471 L
.29087 .55289 L
.29049 .55109 L
.29032 .5494 L
.29031 .54788 L
.29047 .54629 L
.29074 .54496 L
.29118 .54353 L
.29183 .54203 L
.29273 .54048 L
.2949 .53782 L
.29644 .53642 L
.29803 .53521 L
.29995 .53399 L
.30227 .53276 L
.30464 .53173 L
.30701 .53086 L
.31219 .52941 L
.31537 .52876 L
.31854 .52826 L
.32221 .52784 L
.32435 .52766 L
.32637 .52753 L
.33058 .52739 L
.33305 .52737 L
.33539 .5274 L
.33983 .52757 L
.34238 .52772 L
.34474 .5279 L
.34709 .52811 L
.34811 .52772 L
.34592 .52594 L
.34384 .52424 L
.33583 .51759 L
.31639 .50057 L
.27893 .46294 L
.24285 .41728 L
.22789 .39339 L
.21652 .37121 L
.20862 .3515 L
.20561 .34185 L
.2031 .33154 L
Mistroke
.20213 .32631 L
.20146 .32164 L
.20118 .31911 L
.20094 .31639 L
.20071 .31155 L
.20072 .3072 L
.20098 .30272 L
.20145 .29866 L
.20208 .29512 L
.20301 .29133 L
.20409 .28798 L
.2055 .2845 L
.2073 .28101 L
.20948 .27765 L
.21182 .27474 L
.21419 .27235 L
.21694 .27008 L
.21951 .26835 L
.22256 .26669 L
.22555 .2654 L
.22845 .26443 L
.23203 .26354 L
.23612 .2629 L
.23991 .26262 L
.24408 .2626 L
.24884 .26293 L
.25334 .26354 L
.2559 .264 L
.25873 .26461 L
.26402 .266 L
.27468 .26972 L
.28503 .27435 L
.31026 .28943 L
.33851 .31198 L
.38687 .36407 L
.4125 .39929 L
.42456 .41802 L
.43025 .42743 L
.43531 .43609 L
.43579 .43393 L
.43334 .42459 L
.42837 .4038 L
.42358 .38057 L
.41988 .35903 L
.4173 .34093 L
.41507 .32111 L
.41421 .31153 L
.41345 .30131 L
.41285 .29059 L
.41246 .28066 L
Mistroke
.41223 .26999 L
.41219 .26397 L
.41222 .25835 L
.41244 .24717 L
.41267 .24095 L
.41294 .23531 L
.41355 .22592 L
.41441 .21583 L
.41676 .19614 L
.41851 .18516 L
.42032 .17549 L
.42518 .15492 L
.4306 .13738 L
.43647 .12231 L
.44262 .10949 L
.44971 .09752 L
.45627 .08854 L
.46369 .08038 L
.47202 .07336 L
.48008 .0685 L
.48509 .06634 L
.48758 .06551 L
.48989 .06487 L
.49423 .06404 L
.49652 .06378 L
.49897 .06365 L
.50332 .06377 L
.50578 .06404 L
.50807 .06442 L
.51049 .06497 L
.51268 .06559 L
.51757 .0674 L
.5217 .06942 L
.52613 .07208 L
.53397 .07819 L
.54276 .08736 L
.5515 .09939 L
.5584 .11144 L
.5653 .12653 L
.57093 .14193 L
.5756 .15785 L
.5801 .17763 L
.58335 .19692 L
.58454 .20602 L
.5856 .21593 L
.58636 .22467 L
.587 .23428 L
.5873 .24025 L
.58752 .2458 L
.58777 .25683 L
Mistroke
.5878 .26699 L
.58762 .27784 L
.58725 .28857 L
.58694 .29467 L
.58661 .30034 L
.58485 .32194 L
.5826 .34171 L
.57954 .36274 L
.57548 .38543 L
.5703 .40966 L
.56765 .42066 L
.56469 .43214 L
.5637 .43782 L
.56919 .42836 L
.61106 .36671 L
.66038 .31299 L
.68712 .29127 L
.69983 .2828 L
.71118 .27629 L
.72093 .27156 L
.73121 .26752 L
.741 .26468 L
.74611 .26363 L
.75071 .26298 L
.75546 .26262 L
.75805 .26257 L
.7604 .26263 L
.76453 .26298 L
.76676 .26332 L
.76871 .2637 L
.77227 .26465 L
.77588 .26598 L
.77907 .26753 L
.7818 .26919 L
.78726 .27376 L
.78991 .27683 L
.79209 .27999 L
.79406 .28357 L
.79563 .28721 L
.7971 .29172 L
.79766 .29397 L
.79811 .29609 L
.79872 .29991 L
.79914 .3042 L
.7993 .30813 L
.79927 .3124 L
.79899 .31725 L
.79851 .32188 L
.79774 .32711 L
.79663 .33283 L
Mistroke
.79353 .34481 L
.78959 .35649 L
.77979 .37898 L
.75524 .42006 L
.72214 .46175 L
.68443 .49982 L
.66697 .51522 L
.65979 .52125 L
.65614 .52426 L
.65236 .52733 L
.65455 .52796 L
.65891 .52764 L
.66287 .52745 L
.66709 .52737 L
.67129 .52743 L
.67358 .52753 L
.67561 .52766 L
.67923 .52799 L
.68284 .52846 L
.6863 .52908 L
.68974 .52989 L
.69528 .5317 L
.69823 .53301 L
.70072 .53439 L
.70269 .53573 L
.70455 .53728 L
.70593 .53872 L
.70701 .5401 L
.70792 .54156 L
.7086 .54296 L
.70918 .54464 L
.7094 .54554 L
.70957 .54652 L
.7097 .54837 L
.70963 .55007 L
.70952 .55102 L
.70934 .55203 L
.70886 .55385 L
.70815 .55583 L
.70712 .55803 L
.70468 .56198 L
.70174 .56565 L
.69447 .57261 L
.68632 .57863 L
.66468 .59044 L
.66364 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002a0?ooo`X006Ko/P3oool00:h0oooo4@00I_n^0?ooo`00[03oool6001Vo`@0oooo00<00000
0?ooo`3oool01`00I_n]0?ooo`00Z`3oool4001Vo`L0oooo00<000000?ooo`3oool01@3oool3001V
oj`0oooo002Z0?ooo`<006Ko2@3oool00`000000oooo0?ooo`060?ooo`@006KoZP3oool00:T0oooo
0`00I_l:0?ooo`030000003oool0oooo00L0oooo0`00I_nZ0?ooo`00Z03oool3001Vo`/0oooo00<0
00000?ooo`3oool02@3oool2001VojT0oooo002W0?ooo`<006Ko303oool00`000000oooo0?ooo`0:
0?ooo`8006KoZ03oool00:H0oooo0`00I_l=0?ooo`030000003oool0oooo00/0oooo0P00I_nW0?oo
o`00Y@3oool3001Vo`h0oooo00<000000?ooo`3oool0303oool2001VojH0oooo002T0?ooo`<006Ko
3`3oool2000000d0oooo0`00I_nU0?ooo`00X`3oool3001Voa00oooo00<000000?ooo`3oool03@3o
ool3001Voj@0oooo002R0?ooo`<006Ko4@3oool00`000000oooo0?ooo`0>0?ooo`<006KoX`3oool0
0:80oooo0P00I_lB0?ooo`030000003oool0oooo00l0oooo0P00I_nS0?ooo`00X@3oool3001Voa80
oooo00<000000?ooo`3oool0403oool2001Voj80oooo002Q0?ooo`8006Ko4`3oool00`000000oooo
0?ooo`0A0?ooo`03001Vo`3oool0oooo0:00oooo002Q0?ooo`8006Ko4`3oool00`000000oooo0?oo
o`0A0?ooo`8006KoX@3oool00:40oooo00<006Ko0?ooo`3oool04P3oool00`000000oooo0?ooo`0B
0?ooo`03001Vo`3oool0oooo09l0oooo002P0?ooo`8006Ko503oool00`000000oooo0?ooo`0B0?oo
o`8006KoX03oool00:00oooo00<006Ko0?ooo`3oool04`3oool00`000000oooo0?ooo`0C0?ooo`03
001Vo`3oool0oooo09h0oooo002O0?ooo`8006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`8006Ko
W`3oool009l0oooo00<006Ko0?ooo`3oool0503oool00`000000oooo0?ooo`0D0?ooo`03001Vo`3o
ool0oooo09d0oooo002N0?ooo`8006Ko5P3oool00`000000oooo0?ooo`0D0?ooo`8006KoWP3oool0
09h0oooo00<006Ko0?ooo`3oool0203oool00`3oe9/000000000000300000003002Ke03oool0oooo
00@0oooo00<000000?ooo`3oool05@3oool00`00I_l0oooo0?ooo`2L0?ooo`00W@3oool2001Vo`d0
oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`8006KoW@3oool009d0oooo
00<006Ko0?ooo`3oool0303oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01D0oooo
0P00I_nM0?ooo`00W03oool2001Vo`h0oooo00<0^W9b0;[Zo`3oool01`3oool3000001D0oooo0`00
I_nL0?ooo`00W03oool01@00I_l0oooo0?ooo`3oool0^W8000D0000000<007:j0?ooo`3oool00`3o
ool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00V`3oool2
001Vo`l0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool0
09/0oooo0P00I_l?0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05`3oool2001V
oi/0oooo002J0?ooo`<006Ko303oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?oo
o`3oool05`3oool2001Voi/0oooo002J0?ooo`8006Ko3`3oool00`3Z^W80001b0;[Zo`080?ooo`03
0000003oool0oooo01L0oooo0P00I_nK0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool0
5`3oool2001Voi/0oooo002I0?ooo`<006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3o
ool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?ooo`00V@3oool2001V
oa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000
oooo0?ooo`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo
0P00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool3001VoiT0oooo002I
0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009T0oooo0P00I_lK0?oo
o`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3o
ool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0J0?ooo`8006Ko
V03oool009P0oooo0P00I_lL0?ooo`8000006`3oool2001VoiP0oooo002G0?ooo`<006Ko703oool0
0`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo
01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0
oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009H0oooo0`00
I_lM0?ooo`030000003oool0oooo01X0oooo0`00I_nG0?ooo`00UP3oool2001Voah0oooo00<00000
0?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?oo
o`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00
UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3o
ool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003oool0
oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001V
oiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo
0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<0
00000?ooo`3oool06`3oool2001VoiL0oooo002E0?ooo`<006Ko7P3oool00`000000oooo0?ooo`0K
0?ooo`8006KoU`3oool009D0oooo0P00I_lO0?ooo`800000703oool2001VoiL0oooo002E0?ooo`80
06Ko7`3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009D0oooo0P00I_lO0?ooo`030000
003oool0oooo01`0oooo00<006Ko0?ooo`3oool0U@3oool009D0oooo0P00I_lO0?ooo`030000003o
ool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool07@3oool0
0`00I_l0oooo0?ooo`2D0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001V
oiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo
0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<0
00000?ooo`3oool0703oool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L
0?ooo`8006KoUP3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?oo
o`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VoiH0oooo001F0?ooo`D006Ko
>P3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VocX0oooo1P00I_mF0?ooo`00D@3o
ool@001Voc@0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_lc0?oooa4006KoDP3o
ool004l0oooo2000I_l30?ooo`X006Ko<@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2
001Voc40oooo2P00I_l40?ooo`L006KoD03oool004h0oooo1000I_l>0?ooo`H006Ko;`3oool2001V
oal0oooo00<000000?ooo`3oool0703oool2001Vobl0oooo1@00I_l?0?ooo`D006KoCP3oool004d0
oooo0`00I_lD0?ooo`@006Ko;@3oool2001Voal0oooo0P00000M0?ooo`8006Ko;03oool6001Voa<0
oooo0`00I_m>0?ooo`00C03oool3001VoaH0oooo1@00I_l[0?ooo`8006Ko7`3oool00`000000oooo
0?ooo`0L0?ooo`8006Ko:`3oool5001VoaL0oooo0P00I_m=0?ooo`00B`3oool3001VoaT0oooo1@00
I_lY0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko:@3oool4001Voa/0oooo0P00
I_m<0?ooo`00BP3oool3001Voa`0oooo1@00I_lW0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L
0?ooo`8006Ko:03oool4001Voa`0oooo0`00I_m;0?ooo`00B@3oool3001Voal0oooo1@00I_lU0?oo
o`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko9P3oool4001Voal0oooo0`00I_m:0?oo
o`00B@3oool2001Vob80oooo1@00I_lS0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`80
06Ko9@3oool4001Vob40oooo0P00I_m:0?ooo`00B@3oool2001Vob@0oooo1000I_lR0?ooo`8006Ko
7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko8`3oool4001Vob<0oooo0P00I_m:0?ooo`00B@3o
ool2001VobH0oooo0`00I_lQ0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko8P3o
ool4001Vob@0oooo0P00I_m:0?ooo`00B03oool3001VobL0oooo1000I_lO0?ooo`8006Ko7`3oool0
0`000000oooo0?ooo`0L0?ooo`03001Vo`3oool0oooo01l0oooo1000I_lV0?ooo`8006KoBP3oool0
04P0oooo0P00I_lY0?ooo`@006Ko7P3oool2001Voal0oooo00<000000?ooo`3oool06`3oool2001V
ob00oooo1000I_lW0?ooo`<006KoB@3oool004P0oooo0P00I_l[0?ooo`<006Ko7@3oool2001Voal0
oooo00<000000?ooo`3oool06`3oool2001Voal0oooo0`00I_lZ0?ooo`8006KoB@3oool004P0oooo
0P00I_l/0?ooo`<006Ko703oool2001Voal0oooo00<000000?ooo`3oool06`3oool2001Voah0oooo
0`00I_l[0?ooo`8006KoB@3oool004P0oooo0P00I_l]0?ooo`@006Ko6P3oool2001Voal0oooo00<0
00000?ooo`3oool06`3oool2001Voa`0oooo1000I_l/0?ooo`8006KoB@3oool004P0oooo0P00I_l^
0?ooo`@006Ko6@3oool2001Voal0oooo00<000000?ooo`3oool06`3oool2001Voa/0oooo1000I_l]
0?ooo`8006KoB@3oool004P0oooo0P00I_l`0?ooo`<006Ko603oool3001Voah0oooo00<000000?oo
o`3oool06`3oool2001VoaX0oooo0`00I_l_0?ooo`8006KoB@3oool004P0oooo0P00I_la0?ooo`<0
06Ko603oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoaT0oooo0`00I_l`0?ooo`80
06KoB@3oool004P0oooo0P00I_lb0?ooo`<006Ko5`3oool2001Voah0oooo00<000000?ooo`3oool0
6`3oool2001VoaP0oooo0`00I_la0?ooo`8006KoB@3oool004P0oooo0P00I_lc0?ooo`<006Ko5P3o
ool2001Voah0oooo0P00000L0?ooo`8006Ko5`3oool3001Voc80oooo0P00I_m90?ooo`00B03oool2
001Voc@0oooo0`00I_lE0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006Ko5P3oool3
001Voc<0oooo0P00I_m90?ooo`00B03oool2001VocD0oooo0`00I_lE0?ooo`8006Ko7@3oool00`00
0000oooo0?ooo`0K0?ooo`8006Ko5@3oool3001Voc@0oooo0P00I_m90?ooo`00B@3oool00`00I_l0
oooo0?ooo`0d0?ooo`<006Ko503oool2001Voad0oooo00<000000?ooo`3oool06`3oool2001Voa@0
oooo0`00I_le0?ooo`03001Vo`3oool0oooo04P0oooo00190?ooo`8006Ko=P3oool3001Voa<0oooo
0P00I_lM0?ooo`030000003oool0oooo01/0oooo0P00I_lC0?ooo`<006Ko=@3oool2001VodX0oooo
00190?ooo`8006Ko=`3oool3001Voa80oooo0P00I_lM0?ooo`030000003oool0oooo01/0oooo0P00
I_lB0?ooo`<006Ko=P3oool3001VodT0oooo00190?ooo`8006Ko>03oool2001Voa80oooo0P00I_lM
0?ooo`030000003oool0oooo01/0oooo0P00I_lA0?ooo`<006Ko=`3oool2001VodX0oooo00190?oo
o`8006Ko>@3oool2001Voa40oooo0P00I_lM0?ooo`030000003oool0oooo01/0oooo0P00I_lA0?oo
o`8006Ko>03oool2001VodX0oooo001:0?ooo`03001Vo`3oool0oooo03L0oooo0`00I_l@0?ooo`80
06Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko4@3oool2001VocT0oooo0P00I_m:0?ooo`00
BP3oool2001VocT0oooo0`00I_l@0?ooo`8006Ko703oool00`000000oooo0?ooo`0J0?ooo`8006Ko
403oool3001VocP0oooo0`00I_m:0?ooo`00B`3oool00`00I_l0oooo0?ooo`0h0?ooo`<006Ko3`3o
ool2001Voa`0oooo00<000000?ooo`3oool06P3oool2001Vo`l0oooo0`00I_li0?ooo`8006KoB`3o
ool004/0oooo0P00I_lj0?ooo`<006Ko3P3oool2001Voa`0oooo00<000000?ooo`3oool06P3oool2
001Vo`h0oooo0`00I_li0?ooo`<006KoB`3oool004`0oooo00<006Ko0?ooo`3oool0>@3oool3001V
o`d0oooo0P00I_lL0?ooo`030000003oool0oooo01X0oooo0P00I_l=0?ooo`<006Ko>P3oool2001V
od`0oooo001<0?ooo`8006Ko>`3oool3001Vo``0oooo0P00I_l20000000309_Do`3oool0oooo00<0
oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo00<000000?oo
o`3oool06P3oool2001Vo``0oooo0`00I_lk0?ooo`8006KoC03oool004`0oooo0P00I_ll0?ooo`<0
06Ko2`3oool2001Vo`040?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3D
V`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo0?ooo`0J0?ooo`8006Ko2`3o
ool3001Voc/0oooo0`00I_m<0?ooo`00C03oool2001Vocd0oooo0`00I_l90?ooo`030?oDV`00I_l0
06Ko0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0
oooo01X0oooo0P00I_l:0?ooo`<006Ko?03oool2001Vodd0oooo001<0?ooo`<006Ko?@3oool2001V
o`T0oooo00L0j[Yb07:jjP00I_l006Ko0?ooo`3oe9/009_D0100oooo00<0omBK002Ke03oool01@3o
ool3000001T0oooo0P00I_l:0?ooo`<006Ko?@3oool2001Vodd0oooo001=0?ooo`8006Ko?P3oool2
001Vo`D0000000D007:j0?ooo`3oool0j[Yb07:jjP02001Vo`030?ooo`3oe9/009_D0100oooo00<0
^W8009_Do`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`8006Ko2P3oool2001Vocd0oooo0`00
I_m=0?ooo`00C@3oool2001Vocl0oooo0P00I_l70?ooo`070>ZjLP1b^^X006Ko001Vo`3oool0omBK
002Ke00;0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo
0?ooo`0I0?ooo`8006Ko2@3oool2001Voch0oooo0P00I_m>0?ooo`00CP3oool00`00I_l0oooo0?oo
o`0n0?ooo`03001Vo`3oool0oooo00D0oooo00L0omBK07:jjP00I_l006Ko0?ooo`3Z^W80L[[Z00/0
oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`0I0?ooo`8006Ko203oool2001Voch0
oooo0`00I_m>0?ooo`00CP3oool2001Vocl0oooo0P00I_l70?ooo`060;Yb0000I_l006Ko0?oZ^P1b
09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01P0oooo0`00I_l80?oo
o`03001Vo`3oool0oooo03d0oooo0P00I_m?0?ooo`00C`3oool2001Vocl0oooo0P00I_l60?ooo`05
0?ooe000I_l006Ko0000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo
00D0oooo00<000000?ooo`3oool0603oool2001Vo`P0oooo0P00I_lo0?ooo`8006KoC`3oool00500
oooo00<006Ko0?ooo`3oool0?P3oool00`00I_l0oooo0?ooo`050?ooo`<006Ko6P3oool00`000000
oooo0?ooo`0H0?ooo`8006Ko1`3oool2001Vod00oooo00<006Ko0?ooo`3oool0CP3oool00500oooo
0P00I_lo0?ooo`8006Ko1`3oool2001VoaX0oooo00<000000?ooo`3oool0603oool2001Vo`L0oooo
00<006Ko0?ooo`3oool0?P3oool2001Voe00oooo001A0?ooo`03001Vo`3oool0oooo03h0oooo0P00
I_l60?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`<006Ko1P3oool2001Vocl0oooo0P00
I_mA0?ooo`00D@3oool2001Vod00oooo0P00I_l50?ooo`8006Ko6P3oool00`000000oooo0?ooo`0G
0?ooo`8006Ko1P3oool2001Vod00oooo00<006Ko0?ooo`3oool0D03oool00580oooo0P00I_m00?oo
o`03001Vo`3oool0oooo00<0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0P00I_l60?oo
o`03001Vo`3oool0oooo03h0oooo0P00I_mB0?ooo`00D`3oool00`00I_l0oooo0?ooo`0n0?ooo`80
06Ko103oool3001VoaT0oooo00<000000?ooo`3oool05`3oool2001Vo`D0oooo0P00I_m00?ooo`03
001Vo`3oool0oooo0540oooo001C0?ooo`8006Ko@03oool2001Vo`@0oooo0P00I_lI0?ooo`030000
003oool0oooo01H0oooo0`00I_l40?ooo`8006Ko@03oool2001Voe<0oooo001D0?ooo`03001Vo`3o
ool0oooo03l0oooo00<006Ko0?ooo`3oool00P3oool2001VoaT0oooo00<000000?ooo`3oool05P3o
ool2001Vo`D0oooo00<006Ko0?ooo`3oool0?P3oool2001Voe@0oooo001D0?ooo`8006Ko@03oool2
001Vo`<0oooo0P00I_lI0?ooo`030000003oool0oooo01H0oooo0P00I_l40?ooo`8006Ko@03oool0
0`00I_l0oooo0?ooo`1C0?ooo`00E@3oool00`00I_l0oooo0?ooo`0o0?ooo`04001Vo`3oool0oooo
0?ooo`8006Ko6@3oool00`000000oooo0?ooo`0F0?ooo`8006Ko103oool00`00I_l0oooo0?ooo`0n
0?ooo`8006KoE@3oool005D0oooo0P00I_m00?ooo`8006Ko0`3oool2001VoaP0oooo00<000000?oo
o`3oool05P3oool2001Vo`<0oooo0P00I_m00?ooo`03001Vo`3oool0oooo05@0oooo001F0?ooo`80
06Ko@03oool2001Vo`80oooo0P00I_lH0?ooo`8000005P3oool3001Vo`80oooo0P00I_m00?ooo`80
06KoEP3oool005L0oooo00<006Ko0?ooo`3oool0?`3oool00`00I_l0oooo0?ooo`02001VoaP0oooo
00<000000?ooo`3oool05@3oool2001Vo`<0oooo00<006Ko0?ooo`3oool0?P3oool2001VoeL0oooo
001G0?ooo`8006Ko@03oool2001Vo`030?ooo`00I_l006Ko01P0oooo00<000000?ooo`3oool05@3o
ool2001Vo`80oooo0P00I_m00?ooo`03001Vo`3oool0oooo05H0oooo001H0?ooo`8006Ko@03oool0
1000I_l0oooo001Vo`00I_lH0?ooo`030000003oool0oooo01D0oooo0P00I_l00`3oool006Ko001V
o`100?ooo`8006KoF03oool005P0oooo0`00I_lo0?ooo`@006Ko603oool00`000000oooo0?ooo`0D
0?ooo`<006Ko00<0oooo001Vo`3oool0?`3oool2001VoeT0oooo001I0?ooo`8006Ko@03oool4001V
oaL0oooo00<000000?ooo`3oool0503oool2001Vo`030?ooo`00I_l006Ko03l0oooo0`00I_mI0?oo
o`00FP3oool2001Vod00oooo0`00I_lG0?ooo`030000003oool0oooo01@0oooo1000I_m00?ooo`80
06KoFP3oool005X0oooo0`00I_lo0?ooo`<006Ko5`3oool00`000000oooo0?ooo`0D0?ooo`<006Ko
@03oool2001Voe/0oooo001K0?ooo`<006Ko?`3oool2001VoaL0oooo00<000000?ooo`3oool04`3o
ool4001Vocl0oooo0`00I_mK0?ooo`00G03oool3001Voch0oooo0P00I_lG0?ooo`030000003oool0
oooo01<0oooo0`00I_lo0?ooo`<006KoG03oool005d0oooo0P00I_ln0?ooo`8006Ko5`3oool00`00
0000oooo0?ooo`0C0?ooo`8006Ko?`3oool3001Voed0oooo001N0?ooo`8006Ko?P3oool00`00I_l0
oooo0?ooo`0E0?ooo`030000003oool0oooo01<0oooo0P00I_lo0?ooo`8006KoGP3oool005h0oooo
0`00I_mE0?ooo`030000003oool0oooo01<0oooo00<006Ko0?ooo`3oool0?@3oool2001Voel0oooo
001O0?ooo`<006KoE03oool00`000000oooo0?ooo`1B0?ooo`<006KoG`3oool00600oooo0`00I_mC
0?ooo`030000003oool0oooo0540oooo0`00I_mP0?ooo`00H@3oool3001Voe80oooo00<000000?oo
o`3oool0D03oool3001Vof40oooo001R0?ooo`8006KoDP3oool200000540oooo0P00I_mR0?ooo`00
H`3oool2001Voe40oooo00<000000?ooo`3oool0C`3oool2001Vof<0oooo001S0?ooo`<006KoD03o
ool00`000000oooo0?ooo`1>0?ooo`<006KoH`3oool006@0oooo0`00I_m?0?ooo`030000003oool0
oooo04d0oooo0`00I_mT0?ooo`00I@3oool3001Vodh0oooo00<000000?ooo`3oool0C03oool3001V
ofD0oooo001V0?ooo`<006KoC@3oool00`000000oooo0?ooo`1;0?ooo`<006KoIP3oool006L0oooo
0`00I_m<0?ooo`030000003oool0oooo04X0oooo0`00I_mW0?ooo`00J03oool3001Vod/0oooo00<0
00000?ooo`3oool0B@3oool3001VofP0oooo001Y0?ooo`<006KoBP3oool00`000000oooo0?ooo`18
0?ooo`<006KoJ@3oool006X0oooo0`00I_m90?ooo`030000003oool0oooo04L0oooo0`00I_mZ0?oo
o`00J`3oool3001VodP0oooo00<000000?ooo`3oool0AP3oool3001Vof/0oooo001/0?ooo`<006Ko
A`3oool00`000000oooo0?ooo`150?ooo`<006KoK03oool006d0oooo0`00I_m60?ooo`030000003o
ool0oooo04@0oooo0`00I_m]0?ooo`00KP3oool3001VodD0oooo00<000000?ooo`3oool0@`3oool3
001Vofh0oooo001_0?ooo`<006KoA03oool00`000000oooo0?ooo`120?ooo`<006KoK`3oool00700
oooo0`00I_m30?ooo`030000003oool0oooo0440oooo0`00I_m`0?ooo`00L@3oool3001Vod80oooo
00<000000?ooo`3oool0@03oool3001Vog40oooo001b0?ooo`<006Ko@@3oool200000400oooo0`00
I_mb0?ooo`00L`3oool3001Vod00oooo00<000000?ooo`3oool0?P3oool3001Vog<0oooo001d0?oo
o`<006Ko?`3oool00`000000oooo0?ooo`0l0?ooo`@006KoM03oool007D0oooo1000I_lm0?ooo`03
0000003oool0oooo03/0oooo1000I_me0?ooo`00MP3oool4001Voc`0oooo00<000000?ooo`3oool0
>P3oool3001VogL0oooo001h0?ooo`<006Ko>`3oool00`000000oooo0?ooo`0i0?ooo`<006KoN03o
ool007T0oooo0`00I_lj0?ooo`030000003oool0oooo03P0oooo0`00I_mi0?ooo`00NP3oool3001V
ocT0oooo00<000000?ooo`3oool0=`3oool3001VogX0oooo001k0?ooo`<006Ko>03oool00`000000
oooo0?ooo`0f0?ooo`<006KoN`3oool007`0oooo0`00I_lg0?ooo`030000003oool0oooo03@0oooo
1000I_ml0?ooo`00L@3oool>001VocL0oooo00<000000?ooo`3oool0<P3oool@001Vog80oooo001^
0?oooa4006Ko=`3oool00`000000oooo0?ooo`0`0?oooaH006KoKP3oool006`0oooo1P00I_m40?oo
o`030000003oool0oooo0440oooo1`00I_m/0?ooo`00J`3oool4001VodL0oooo00<000000?ooo`3o
ool0A@3oool3001Vof`0oooo001Z0?ooo`<006KoB@3oool00`000000oooo0?ooo`160?ooo`<006Ko
J`3oool006T0oooo0`00I_m:0?ooo`030000003oool0oooo04H0oooo1000I_mZ0?ooo`00J03oool3
001Vod/0oooo0P0000180?ooo`<006KoJP3oool00140oooo00<0omBK0000000000000`0000000`00
Vm@0oooo0?ooo`120?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000001Vo`02
001Vo`<0oooo00D0e9/0000000000000000009_Do`130?ooo`030000003oool0oooo04@0oooo00@0
omBK00000000000000000P00I_l40?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000
000009_Do`140?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0303oool001@0oooo
00<0^W9b0;[Zo`3oool0A@3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00@0e9/00000
0000I_l006Ko0`3oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0@P3oool00`000000oooo
0?ooo`140?ooo`040;YbV`3Dool0oooo0?ooe08006Ko103oool00`3DV`000000002Ke0040?ooo`07
0=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`160?ooo`030;YbLP2jj_l0oooo00l0oooo000D0?oo
o`030;YbLP2jj_l0oooo04@0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`050?oo
o`<006Ko1`3oool00`3oe9/009_D0?ooo`110?ooo`030000003oool0oooo04<0oooo00<0omBK002K
e03oool00P3oool2001Voa00oooo00<0omBK002Ke03oool0A@3oool00`2jLW80^^[o0?ooo`0?0?oo
o`00503oool00`2jLW80^^[o0?ooo`140?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03o
ool01@3oool3001Vo`L0oooo00<0omBK002Ke03oool0@@3oool00`000000oooo0?ooo`130?ooo`03
0>ZjLP1b^^X0oooo0080oooo0P00I_l@0?ooo`030?oDV`00Vm@0oooo04D0oooo00<0^W9b0;[Zo`3o
ool03`3oool000P0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;Yb
LP2jj_l0oooo03/0oooo00<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0
oooo00<0omBK002Ke03oool01P3oool3001Vo`H0oooo00<0^W8009_Do`3oool0@@3oool00`000000
oooo0?ooo`130?ooo`030>ZjLP1b^^X0oooo0080oooo0P00I_l@0?ooo`030;Yb002Ke?l0oooo04D0
oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00L0oooo0`00I_l00`3oom@0V`00000000020000000307:j
jP3oool0oooo0440oooo00<000000?ooo`3oool0@`3oool0103Z^W80L[[Z0?ooo`3oool2001Vo`03
002Ke03oool0oooo00T0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`150?ooo`03
0;YbLP2jj_l0oooo00l0oooo000D0?ooo`030;YbLP2jj_l0oooo04@0oooo00<0omBK07:jjP3oool0
0P3oool00`3Z^W80L[[Z0?ooo`080?ooo`8006Ko00<0oooD09/0V`3Dool0AP3oool00`000000oooo
0?ooo`130?ooo`030?oDV`1b^^X0oooo008006Ko00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K
0=Coo`1:0?ooo`030;YbLP2jj_l0oooo00l0oooo000A0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0
AP3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`X0oooo0P00I_l00`2K09/0e?oo0?ooo`150?oo
o`030000003oool0oooo04@0oooo00H0^W80001Vo`00I_l006Ko0780V`3Dool;0?ooo`030?ooe02K
09/0e?oo04L0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`0@0?ooo`004`3oool00`3Z^W80001b0;[Z
o`160?ooo`050?ooe02K000000000000LP2jj_l0303oool2001Vo`<0000000<0002K0=Coo`3oool0
@@3oool00`000000oooo0?ooo`140?ooo`<006Ko00<0001b0;[Zo`3oool02`3oool00`3oom@0V`00
00000002000000030000V`3Dool0oooo04@0oooo00<0j[Yb0000LP2jj_l0403oool006d0oooo0`00
I_m60?ooo`030000003oool0oooo04<0oooo0`00I_m^0?ooo`00KP3oool4001Vod@0oooo00<00000
0?ooo`3oool0@P3oool3001Vofl0oooo001_0?ooo`@006Ko@`3oool00`000000oooo0?ooo`110?oo
o`<006KoL03oool00740oooo0`00I_m20?ooo`030000003oool0oooo03l0oooo1000I_ma0?ooo`00
LP3oool4001Vod00oooo00<000000?ooo`3oool0?@3oool5001Vog80oooo001c0?ooo`L006Ko?03o
ool00`000000oooo0?ooo`0k0?ooo`D006KoM03oool007D0oooo1P00I_lk0?ooo`030000003oool0
oooo03P0oooo1P00I_mf0?ooo`00N0000004001Vog@000001@00I_mh0000000000<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool03@3oool010000000oooo0?ooo`3oool4001Vo`T0oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01P3oool6001V
o`80oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool03P3oool100000000403oool00`000000oooo0?ooo`1@0?ooo`03
0000003oool0oooo00l0oooo1@00I_ll0?ooo`030000003oool0oooo03X0oooo1@00I_lA0?ooo`03
0000003oool0oooo04l0oooo00<000000?ooo`3oool03`3oool007<0oooo1@00I_ln0?ooo`030000
003oool0oooo03`0oooo1@00I_mc0?ooo`00L@3oool5001Vod00oooo00<000000?ooo`3oool0?P3o
ool4001Vog80oooo001_0?ooo`D006Ko@P3oool00`000000oooo0?ooo`100?ooo`@006KoL03oool0
06l0oooo0`00I_m40?ooo`030000003oool0oooo0440oooo1000I_m_0?ooo`00KP3oool2001VodH0
oooo00<000000?ooo`3oool0@`3oool3001Vofh0oooo001]0?ooo`8006KoA`3oool00`000000oooo
0?ooo`140?ooo`<006KoK@3oool006/0oooo0`00I_m80?ooo`030000003oool0oooo04D0oooo0P00
I_m]0?ooo`00J`3oool3001VodP0oooo00<000000?ooo`3oool0AP3oool2001Vof`0oooo001Z0?oo
o`8006KoBP3oool00`000000oooo0?ooo`170?ooo`8006KoJ`3oool006X0oooo00<006Ko0?ooo`3o
ool0B@3oool00`000000oooo0?ooo`170?ooo`<006KoJP3oool006T0oooo0P00I_m;0?ooo`030000
003oool0oooo04P0oooo0P00I_mZ0?ooo`00J03oool3001Vod/0oooo00<000000?ooo`3oool0B03o
ool2001VofX0oooo001X0?ooo`<006KoB`3oool00`000000oooo0?ooo`180?ooo`8006KoJP3oool0
06P0oooo0P00I_m<0?ooo`030000003oool0oooo04P0oooo0P00I_mZ0?ooo`00J03oool3001Vod/0
oooo0P0000190?ooo`8006KoJP3oool006P0oooo0`00I_m;0?ooo`030000003oool0oooo04L0oooo
0`00I_mZ0?ooo`00J@3oool4001VodT0oooo00<000000?ooo`3oool0A`3oool3001VofX0oooo001Y
0?ooo`H006KoA`3oool00`000000oooo0?ooo`150?ooo`@006KoJ`3oool006`0oooo1000I_m60?oo
o`030000003oool0oooo04<0oooo1@00I_m/0?ooo`00KP3oool5001Vod<0oooo00<000000?ooo`3o
ool0@03oool6001Vofh0oooo001_0?oooa4006Ko=P3oool00`000000oooo0?ooo`0d0?oooa0006Ko
L03oool00780oooo3@00I_lg0?ooo`030000003oool0oooo03@0oooo3@00I_mc0?ooo`00N`3oool3
001VocP0oooo00<000000?ooo`3oool0=@3oool3001Vog`0oooo001j0?ooo`<006Ko>@3oool00`00
0000oooo0?ooo`0f0?ooo`@006KoNP3oool007T0oooo0`00I_lj0?ooo`030000003oool0oooo03L0
oooo1000I_mi0?ooo`00N03oool3001Voc/0oooo00<000000?ooo`3oool0>@3oool3001VogP0oooo
001f0?ooo`@006Ko?03oool00`000000oooo0?ooo`0j0?ooo`<006KoM`3oool007D0oooo1000I_lm
0?ooo`030000003oool0oooo03/0oooo1000I_me0?ooo`00M03oool3001Vocl0oooo00<000000?oo
o`3oool0?03oool4001Vog@0oooo001c0?ooo`<006Ko@03oool00`000000oooo0?ooo`0n0?ooo`<0
06KoL`3oool00780oooo0`00I_m10?ooo`800000@03oool3001Vog80oooo001a0?ooo`<006Ko@P3o
ool00`000000oooo0?ooo`100?ooo`<006KoL@3oool00700oooo0`00I_m30?ooo`030000003oool0
oooo0440oooo0`00I_m`0?ooo`00K`3oool3001Vod@0oooo00<000000?ooo`3oool0@P3oool3001V
ofl0oooo001]0?ooo`@006KoA@3oool00`000000oooo0?ooo`130?ooo`<006KoKP3oool006`0oooo
1000I_m60?ooo`030000003oool0oooo04@0oooo0`00I_m]0?ooo`00J`3oool3001VodP0oooo00<0
00000?ooo`3oool0A@3oool3001Vof`0oooo001Z0?ooo`<006KoB@3oool00`000000oooo0?ooo`16
0?ooo`8006KoK03oool006T0oooo0`00I_m:0?ooo`030000003oool0oooo04L0oooo0P00I_m[0?oo
o`00J03oool3001Vod/0oooo00<000000?ooo`3oool0A`3oool3001VofX0oooo001W0?ooo`<006Ko
C03oool00`000000oooo0?ooo`180?ooo`<006KoJ@3oool006H0oooo0`00I_m=0?ooo`030000003o
ool0oooo04T0oooo0`00I_mX0?ooo`00I@3oool3001Vodh0oooo00<000000?ooo`3oool0BP3oool3
001VofL0oooo001U0?ooo`8006KoC`3oool00`000000oooo0?ooo`1;0?ooo`<006KoIP3oool006@0
oooo0P00I_m@0?ooo`030000003oool0oooo04`0oooo0`00I_mU0?ooo`00H`3oool3001Voe00oooo
00<000000?ooo`3oool0C@3oool3001Vof@0oooo001R0?ooo`<006KoD@3oool00`000000oooo0?oo
o`1>0?ooo`8006KoI03oool00640oooo0`00I_mB0?ooo`800000D03oool2001Vof<0oooo001P0?oo
o`<006KoD`3oool00`000000oooo0?ooo`1@0?ooo`8006KoHP3oool00600oooo0P00I_mD0?ooo`03
0000003oool0oooo0540oooo0P00I_mQ0?ooo`00G`3oool2001VoeD0oooo00<000000?ooo`3oool0
DP3oool00`00I_l0oooo0?ooo`1O0?ooo`00GP3oool3001Vocl0oooo00<006Ko0?ooo`3oool04`3o
ool00`000000oooo0?ooo`0C0?ooo`03001Vo`3oool0oooo03`0oooo0P00I_mP0?ooo`00G@3oool3
001Vocl0oooo0P00I_lE0?ooo`030000003oool0oooo01<0oooo0P00I_ln0?ooo`8006KoG`3oool0
05`0oooo0`00I_lo0?ooo`<006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`8006Ko?`3oool2001V
oeh0oooo001K0?ooo`<006Ko?`3oool3001VoaH0oooo00<000000?ooo`3oool04`3oool3001Vocl0
oooo00<006Ko0?ooo`3oool0G03oool005/0oooo0P00I_m00?ooo`<006Ko5P3oool00`000000oooo
0?ooo`0C0?ooo`@006Ko?P3oool2001Voed0oooo001J0?ooo`8006Ko@03oool4001VoaH0oooo00<0
00000?ooo`3oool0503oool3001Vocl0oooo0P00I_mL0?ooo`00F@3oool3001Vod00oooo1000I_lF
0?ooo`030000003oool0oooo01@0oooo1000I_lo0?ooo`8006KoF`3oool005T0oooo0P00I_m00?oo
o`@006Ko5`3oool00`000000oooo0?ooo`0D0?ooo`8006Ko00<0oooo001Vo`00I_l0?`3oool00`00
I_l0oooo0?ooo`1I0?ooo`00F03oool2001Vod40oooo00@006Ko0?ooo`00I_l006Ko5`3oool00`00
0000oooo0?ooo`0D0?ooo`<006Ko00<0oooo001Vo`3oool0?P3oool2001VoeX0oooo001G0?ooo`80
06Ko@@3oool2001Vo`030?ooo`00I_l006Ko01L0oooo00<000000?ooo`3oool05@3oool2001Vo`03
0?ooo`00I_l006Ko03l0oooo0P00I_mI0?ooo`00E`3oool00`00I_l0oooo0?ooo`0o0?ooo`8006Ko
0P3oool2001VoaL0oooo00<000000?ooo`3oool05@3oool2001Vo`80oooo00<006Ko0?ooo`3oool0
?P3oool2001VoeP0oooo001F0?ooo`8006Ko@@3oool00`00I_l0oooo0?ooo`02001VoaP0oooo00<0
00000?ooo`3oool05@3oool2001Vo`80oooo0P00I_m00?ooo`03001Vo`3oool0oooo05H0oooo001F
0?ooo`03001Vo`3oool0oooo03l0oooo0P00I_l20?ooo`8006Ko603oool2000001H0oooo0P00I_l3
0?ooo`8006Ko?`3oool2001VoeL0oooo001E0?ooo`8006Ko@03oool2001Vo`<0oooo0P00I_lH0?oo
o`030000003oool0oooo01D0oooo0`00I_l30?ooo`03001Vo`3oool0oooo03h0oooo0P00I_mF0?oo
o`00E03oool2001Vod40oooo00<006Ko0?ooo`3oool00P3oool2001VoaP0oooo00<000000?ooo`3o
ool05P3oool2001Vo`<0oooo0P00I_m00?ooo`03001Vo`3oool0oooo05@0oooo001D0?ooo`03001V
o`3oool0oooo03l0oooo0P00I_l30?ooo`<006Ko603oool00`000000oooo0?ooo`0F0?ooo`8006Ko
103oool00`00I_l0oooo0?ooo`0n0?ooo`8006KoE@3oool005<0oooo0P00I_m00?ooo`8006Ko103o
ool2001VoaT0oooo00<000000?ooo`3oool05P3oool2001Vo`@0oooo0P00I_m00?ooo`03001Vo`3o
ool0oooo05<0oooo001C0?ooo`03001Vo`3oool0oooo03l0oooo00<006Ko0?ooo`3oool00`3oool2
001VoaT0oooo00<000000?ooo`3oool05P3oool2001Vo`D0oooo0P00I_lo0?ooo`8006KoE03oool0
0580oooo0P00I_m00?ooo`8006Ko1@3oool2001VoaT0oooo00<000000?ooo`3oool05`3oool2001V
o`D0oooo0P00I_lo0?ooo`8006KoD`3oool00580oooo00<006Ko0?ooo`3oool0?P3oool2001Vo`H0
oooo0P00I_lI0?ooo`030000003oool0oooo01L0oooo0P00I_l60?ooo`03001Vo`3oool0oooo03h0
oooo00<006Ko0?ooo`3oool0D@3oool00540oooo0P00I_m00?ooo`03001Vo`3oool0oooo00@0oooo
0`00I_lI0?ooo`030000003oool0oooo01L0oooo0P00I_l60?ooo`8006Ko?`3oool2001Voe80oooo
001@0?ooo`8006Ko@03oool2001Vo`H0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0P00
I_l70?ooo`8006Ko?`3oool00`00I_l0oooo0?ooo`1@0?ooo`00D03oool00`00I_l0oooo0?ooo`0n
0?ooo`8006Ko1`3oool2001VoaX0oooo00<000000?ooo`3oool05`3oool2001Vo`P0oooo00<006Ko
0?ooo`3oool0?@3oool2001Voe40oooo001?0?ooo`8006Ko@03oool00`00I_l0oooo0?ooo`060?oo
o`8006Ko6P3oool00`000000oooo0?ooo`0H0?ooo`8006Ko1`3oool2001Vocl0oooo0P00I_m@0?oo
o`00C`3oool00`00I_l0oooo0?ooo`0n0?ooo`8006Ko1`3oool3001VoaX0oooo00<000000?ooo`3o
ool0603oool2001Vo`P0oooo0P00I_lo0?ooo`03001Vo`3oool0oooo04h0oooo001>0?ooo`8006Ko
?`3oool2001Vo`L0oooo00D0omBK001Vo`00I_l0000009_Do`050?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`070?ooo`030000003oool0oooo01P0oooo0P00I_l90?oo
o`8006Ko?P3oool2001Vodl0oooo001>0?ooo`8006Ko?`3oool00`00I_l0oooo0?ooo`060?ooo`06
0;YbV`00I_l006Ko0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0
oooo0?ooo`3oj[X0LP0009_Do`060?ooo`030000003oool0oooo01P0oooo0P00I_l:0?ooo`8006Ko
?P3oool00`00I_l0oooo0?ooo`1=0?ooo`00C@3oool3001Voch0oooo0P00I_l70?ooo`070?oDV`00
Vm@006Ko001Vo`3oool0j[Yb07:jjP0@0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3o
ool0603oool2001Vo`X0oooo0`00I_lm0?ooo`8006KoCP3oool004d0oooo0P00I_ln0?ooo`8006Ko
203oool01`3Z^W8006Ko001Vo`00I_l0oooo0?oDV`00Vm@0403oool00`3oe9/009_D0?ooo`050?oo
o`030000003oool0oooo01T0oooo0P00I_l:0?ooo`8006Ko?@3oool2001Vodh0oooo001=0?ooo`80
06Ko?@3oool2001Vo`T0oooo00<0j[Yb001Vo`00I_l00P3oool00`3oe9/009_D0?ooo`0?0?ooo`03
0;Yb002Ke?l0oooo00D0oooo0`00000I0?ooo`8006Ko2`3oool2001Voc`0oooo0`00I_m=0?ooo`00
C03oool3001Voc`0oooo0`00I_l90?ooo`030>ZjLP00I_l006Ko0080oooo00<0omBK002Ke03oool0
2P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool0
6@3oool2001Vo``0oooo0P00I_ll0?ooo`8006KoC@3oool004`0oooo0P00I_ll0?ooo`<006Ko2P3o
ool00`3oe9/006Ko001Vo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool02P3o
ool00`000000oooo0?ooo`0I0?ooo`8006Ko303oool3001Voc/0oooo0`00I_m<0?ooo`00C03oool2
001Voc/0oooo0`00I_l<0?ooo`8006Ko00@0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Co
o`0:0?ooo`030000003oool0oooo01T0oooo0P00I_l=0?ooo`<006Ko>`3oool2001Vod`0oooo001<
0?ooo`03001Vo`3oool0oooo03T0oooo0`00I_l=0?ooo`8006Ko00<000000000LP2jj_l0303oool0
0`3oom@0V`0000000002000000030000V`3Dool0oooo00D0oooo00<000000?ooo`3oool06@3oool2
001Vo`h0oooo0`00I_lj0?ooo`8006KoC03oool004/0oooo0P00I_lj0?ooo`<006Ko3P3oool2001V
oa`0oooo00<000000?ooo`3oool06P3oool2001Vo`h0oooo0P00I_lj0?ooo`<006KoB`3oool004/0
oooo00<006Ko0?ooo`3oool0>03oool3001Vo`l0oooo0P00I_lL0?ooo`030000003oool0oooo01X0
oooo0P00I_l?0?ooo`8006Ko>P3oool2001Vod/0oooo001:0?ooo`8006Ko>@3oool3001Vo`l0oooo
0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_l?0?ooo`<006Ko>@3oool2001Vod/0oooo
001:0?ooo`03001Vo`3oool0oooo03L0oooo0`00I_l@0?ooo`8006Ko7@3oool00`000000oooo0?oo
o`0J0?ooo`8006Ko403oool3001VocP0oooo0P00I_m;0?ooo`00B@3oool2001VocP0oooo0`00I_lA
0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006Ko4@3oool3001VocP0oooo00<006Ko
0?ooo`3oool0B@3oool004T0oooo0P00I_lh0?ooo`8006Ko4P3oool2001Voad0oooo00<000000?oo
o`3oool06P3oool2001Voa80oooo0`00I_lg0?ooo`8006KoBP3oool004T0oooo0P00I_lg0?ooo`80
06Ko4`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001Voa<0oooo0`00I_lg0?ooo`03
001Vo`3oool0oooo04P0oooo00180?ooo`<006Ko=P3oool3001Voa<0oooo0P00I_lM0?ooo`030000
003oool0oooo01X0oooo0P00I_lD0?ooo`<006Ko=@3oool2001VodX0oooo00180?ooo`8006Ko=P3o
ool3001Voa@0oooo0P00I_lM0?ooo`030000003oool0oooo01/0oooo0P00I_lD0?ooo`<006Ko=@3o
ool00`00I_l0oooo0?ooo`180?ooo`00B03oool2001VocD0oooo0`00I_lE0?ooo`8006Ko7@3oool0
0`000000oooo0?ooo`0K0?ooo`8006Ko5@3oool3001Voc@0oooo0P00I_m90?ooo`00B03oool2001V
oc@0oooo0`00I_lE0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006Ko5P3oool3001V
oc<0oooo0P00I_m90?ooo`00B03oool2001Voc<0oooo0`00I_lF0?ooo`8006Ko7P3oool2000001`0
oooo0P00I_lG0?ooo`<006Ko<P3oool2001VodT0oooo00180?ooo`8006Ko<P3oool3001VoaL0oooo
0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_lH0?ooo`<006Ko<@3oool2001VodT0oooo
00180?ooo`8006Ko<@3oool3001VoaP0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00
I_lI0?ooo`<006Ko<03oool2001VodT0oooo00180?ooo`8006Ko<03oool3001VoaT0oooo0P00I_lN
0?ooo`030000003oool0oooo01/0oooo0P00I_lJ0?ooo`@006Ko;P3oool2001VodT0oooo00180?oo
o`8006Ko;`3oool3001VoaX0oooo0P00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_lK0?oo
o`@006Ko;@3oool2001VodT0oooo00180?ooo`8006Ko;@3oool4001Voa/0oooo0P00I_lN0?ooo`03
0000003oool0oooo01/0oooo0P00I_lM0?ooo`<006Ko;03oool2001VodT0oooo00180?ooo`8006Ko
;03oool4001Voa/0oooo0`00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_lN0?ooo`@006Ko
:P3oool2001VodT0oooo00180?ooo`8006Ko:P3oool4001Voad0oooo0P00I_lO0?ooo`030000003o
ool0oooo01/0oooo0P00I_lO0?ooo`@006Ko:@3oool2001VodT0oooo00180?ooo`8006Ko:@3oool4
001Voah0oooo0P00I_lO0?ooo`030000003oool0oooo01/0oooo0P00I_lQ0?ooo`<006Ko9`3oool3
001VodT0oooo00190?ooo`03001Vo`3oool0oooo02D0oooo1000I_lP0?ooo`8006Ko7`3oool00`00
0000oooo0?ooo`0K0?ooo`8006Ko8P3oool4001VobD0oooo0P00I_m:0?ooo`00B@3oool2001VobD0
oooo1000I_lQ0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`03001Vo`3oool0oooo0240
oooo1000I_lT0?ooo`8006KoBP3oool004X0oooo00<006Ko0?ooo`3oool08P3oool3001Vob<0oooo
0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_lT0?ooo`<006Ko8`3oool2001VodX0oooo
00190?ooo`<006Ko8@3oool4001Vob@0oooo0P00I_lO0?ooo`030000003oool0oooo01d0oooo00<0
06Ko0?ooo`3oool08`3oool4001Vob40oooo0P00I_m:0?ooo`00BP3oool2001Vob00oooo1000I_lU
0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko9P3oool4001Voal0oooo0P00I_m;
0?ooo`00BP3oool3001Voad0oooo1000I_lW0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?oo
o`8006Ko:03oool4001Voa`0oooo0`00I_m;0?ooo`00B`3oool3001Voa/0oooo1000I_lX0?ooo`80
06Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko:@3oool4001Voa/0oooo0P00I_m<0?ooo`00
C03oool3001VoaP0oooo1000I_lZ0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko
:`3oool4001VoaP0oooo0`00I_m<0?ooo`00C@3oool3001Voa<0oooo1`00I_l[0?ooo`8006Ko7`3o
ool2000001d0oooo0P00I_l/0?ooo`H006Ko503oool3001Vodd0oooo001>0?ooo`<006Ko403oool6
001Vobh0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_l^0?ooo`H006Ko403oool4
001Vodh0oooo001?0?ooo`<006Ko3@3oool5001Voc40oooo0P00I_lO0?ooo`030000003oool0oooo
01`0oooo0P00I_lb0?ooo`@006Ko3@3oool4001Vodl0oooo001@0?ooo`H006Ko1@3oool7001Voc<0
oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_lc0?ooo`P006Ko103oool6001Voe40
oooo001A0?ooo`l006Ko=@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VocD0oooo
3`00I_mB0?ooo`00E@3oool7001VocT0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00
I_lj0?ooo`L006KoE@3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF
0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VoiH0oooo002E0?ooo`80
06Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo0P00I_lO0?ooo`030000
003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703o
ool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool0
09D0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0
oooo00<000000?ooo`3oool06`3oool3001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo
0?ooo`0K0?ooo`8006KoU`3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01/0oooo0P00
I_nG0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002E0?oo
o`8006Ko7`3oool2000001`0oooo0P00I_nG0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3o
ool06`3oool2001VoiL0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0K0?ooo`8006Ko
U`3oool009D0oooo0`00I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2
001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3oool00`00
0000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01/0
oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo
002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN
0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00UP3oool2001Voah0oooo00<000000?oo
o`3oool06P3oool3001VoiL0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`80
06KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00U`3o
ool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko7@3oool0
0`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo
01X0oooo0P00I_nH0?ooo`00U`3oool2001Voad0oooo0P00000K0?ooo`8006KoV03oool009L0oooo
0P00I_lM0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<0
00000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I
0?ooo`8006KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?oo
o`00V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`<006Ko
6`3oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009T0oooo0P00I_lK0?ooo`030000003o
ool0oooo01P0oooo0P00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2
001VoiX0oooo002I0?ooo`<006Ko6P3oool00`000000oooo0?ooo`0H0?ooo`8006KoVP3oool009X0
oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?ooo`00VP3oool2001VoaX0oooo
00<000000?ooo`3oool05`3oool2001Voi/0oooo002K0?ooo`8006Ko6@3oool00`000000oooo0?oo
o`0G0?ooo`8006KoV`3oool009/0oooo0P00I_l<0?ooo`030?oDV`000000000000<0000000<009_D
0?ooo`3oool0103oool00`000000oooo0?ooo`0F0?ooo`<006KoV`3oool009/0oooo0P00I_l?0?oo
o`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2001Voi`0oooo002K0?ooo`80
06Ko3`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00
V`3oool3001Vo`h0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`<006Ko
W03oool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo0`00000E0?ooo`8006KoW@3o
ool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2
001Void0oooo002L0?ooo`<006Ko3@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo
01@0oooo0`00I_nM0?ooo`00W@3oool2001Vo`X0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?oo
o`030000003oool0oooo01@0oooo0P00I_nN0?ooo`00WP3oool00`00I_l0oooo0?ooo`0:0?ooo`03
0>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0503oool2001Voih0oooo002N0?ooo`8006Ko
5P3oool00`000000oooo0?ooo`0D0?ooo`03001Vo`3oool0oooo09d0oooo002O0?ooo`03001Vo`3o
ool0oooo01@0oooo00<000000?ooo`3oool04`3oool2001Voil0oooo002O0?ooo`8006Ko5@3oool0
0`000000oooo0?ooo`0B0?ooo`8006KoX03oool00:00oooo0P00I_lD0?ooo`030000003oool0oooo
0180oooo00<006Ko0?ooo`3oool0W`3oool00:40oooo00<006Ko0?ooo`3oool04P3oool00`000000
oooo0?ooo`0A0?ooo`8006KoX@3oool00:40oooo0P00I_lC0?ooo`030000003oool0oooo0140oooo
00<006Ko0?ooo`3oool0X03oool00:80oooo00<006Ko0?ooo`3oool04@3oool00`000000oooo0?oo
o`0@0?ooo`8006KoXP3oool00:80oooo0P00I_lB0?ooo`030000003oool0oooo0100oooo00<006Ko
0?ooo`3oool0X@3oool00:<0oooo00<006Ko0?ooo`3oool0403oool00`000000oooo0?ooo`0?0?oo
o`8006KoX`3oool00:<0oooo0P00I_lA0?ooo`030000003oool0oooo00l0oooo00<006Ko0?ooo`3o
ool0XP3oool00:@0oooo00<006Ko0?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`8006Ko
Y03oool00:@0oooo0P00I_l@0?ooo`8000003P3oool2001VojD0oooo002U0?ooo`8006Ko3`3oool0
0`000000oooo0?ooo`0<0?ooo`8006KoYP3oool00:H0oooo0P00I_l>0?ooo`030000003oool0oooo
00/0oooo0P00I_nW0?ooo`00YP3oool3001Vo`d0oooo00<000000?ooo`3oool02P3oool3001VojL0
oooo002W0?ooo`<006Ko303oool00`000000oooo0?ooo`090?ooo`<006KoZ03oool00:P0oooo0`00
I_l;0?ooo`030000003oool0oooo00P0oooo0`00I_nY0?ooo`00Z@3oool4001Vo`T0oooo00<00000
0?ooo`3oool01P3oool4001VojX0oooo002Z0?ooo`D006Ko1`3oool00`000000oooo0?ooo`050?oo
o`@006KoZ`3oool00:`0oooo1000I_l60?ooo`030000003oool0oooo00<0oooo1000I_n]0?ooo`00
[P3oool5001Vo`<0oooo00@000000?ooo`3oool0oooo1@00I_n^0?ooo`00[`3oool>001Vok00oooo
002b0?ooo`T006Ko/P3oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo0P00002e0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00
]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.7 .59091 m
.70958 .59734 L
.71792 .60383 L
.72659 .61208 L
.73282 .61995 L
.73525 .62398 L
.73631 .62611 L
.73726 .62836 L
.73794 .63033 L
.73853 .63248 L
.73891 .63442 L
.73913 .63622 L
.73921 .6384 L
.73909 .64044 L
.73883 .64225 L
.73836 .64418 L
.73802 .64525 L
.73765 .64621 L
.73665 .64832 L
.73549 .65021 L
.7342 .65193 L
.73109 .65512 L
.72681 .65827 L
.7214 .66114 L
.71549 .66338 L
.71237 .6643 L
.70924 .66506 L
.70627 .66567 L
.70297 .66622 L
.69923 .66671 L
.69563 .66705 L
.69161 .6673 L
.68926 .66739 L
.68701 .66744 L
.68634 .669 L
.68818 .67083 L
.68992 .67257 L
.69748 .68021 L
.71195 .69537 L
.74631 .73618 L
.76092 .75675 L
.77526 .78015 L
.78602 .80126 L
.79098 .81282 L
.79495 .82355 L
.79815 .83384 L
.80045 .84306 L
.80142 .84786 L
.80227 .853 L
.80265 .85578 L
Mistroke
.80294 .85833 L
.80335 .86327 L
.80352 .86768 L
.80351 .87173 L
.80335 .87527 L
.80303 .879 L
.80248 .88294 L
.8017 .88696 L
.80086 .89025 L
.79975 .89371 L
.79666 .90073 L
.79452 .90433 L
.79228 .9074 L
.78753 .91238 L
.78484 .91456 L
.78163 .91669 L
.77875 .91826 L
.77554 .91967 L
.77182 .92094 L
.76823 .92185 L
.7647 .92247 L
.7613 .92284 L
.75743 .92303 L
.75314 .92296 L
.75065 .92279 L
.74796 .92252 L
.74302 .92179 L
.73752 .92064 L
.73127 .91893 L
.71962 .91473 L
.70824 .90947 L
.68604 .8962 L
.66135 .87715 L
.61267 .82639 L
.58838 .79374 L
.58273 .78532 L
.57981 .78083 L
.57677 .77605 L
.57782 .78145 L
.57905 .78716 L
.58131 .79848 L
.58464 .81752 L
.58756 .8381 L
.58893 .84997 L
.58997 .86077 L
.59082 .87175 L
.59141 .88185 L
.5918 .89107 L
.59203 .90079 L
.59209 .91048 L
Mistroke
.59205 .91595 L
.59195 .92105 L
.59164 .93017 L
.59122 .93843 L
.59055 .94783 L
.58975 .95664 L
.5874 .97539 L
.58448 .99232 L
.58127 1.00683 L
.5772 1.0217 L
.57208 1.03689 L
.56595 1.0516 L
.5601 1.06313 L
.55331 1.07419 L
.54652 1.08326 L
.54001 1.0904 L
.53313 1.09651 L
.52656 1.10112 L
.51872 1.10518 L
.51453 1.10675 L
.51237 1.10739 L
.51003 1.10798 L
.50613 1.10868 L
.50245 1.10902 L
.49807 1.10905 L
.49406 1.1087 L
.4897 1.10792 L
.48562 1.10679 L
.48197 1.10546 L
.47805 1.10369 L
.46942 1.09844 L
.46173 1.09208 L
.44856 1.07687 L
.44243 1.06752 L
.43616 1.056 L
.42478 1.02795 L
.41957 1.01014 L
.41561 .99275 L
.41265 .97573 L
.41137 .96645 L
.41023 .95637 L
.40934 .9465 L
.40872 .93743 L
.40828 .9282 L
.40802 .91942 L
.40791 .91029 L
.40797 .90045 L
.4082 .89109 L
.40855 .88253 L
.40914 .87244 L
Mistroke
.40997 .86145 L
.41203 .84147 L
.41488 .82062 L
.41864 .79875 L
.4204 .78986 L
.42241 .78037 L
.42308 .7763 L
.42037 .78055 L
.41498 .78877 L
.37404 .84206 L
.32803 .88588 L
.30362 .90285 L
.2825 .91383 L
.27281 .91761 L
.26787 .91919 L
.26277 .92057 L
.25842 .92152 L
.25378 .9223 L
.24968 .92276 L
.24596 .92299 L
.24146 .923 L
.239 .92287 L
.23678 .92266 L
.23283 .92206 L
.22883 .92113 L
.22545 .92004 L
.22243 .91881 L
.21612 .91525 L
.21315 .91298 L
.21028 .9103 L
.2058 .9048 L
.20369 .90137 L
.20196 .89795 L
.20032 .89393 L
.19891 .88941 L
.19797 .88544 L
.19757 .88327 L
.19721 .88088 L
.19674 .87656 L
.19651 .87239 L
.19647 .86983 L
.1965 .86699 L
.1966 .86427 L
.19676 .86171 L
.19723 .85678 L
.19759 .85397 L
.19797 .85141 L
.19994 .84134 L
.20293 .83013 L
.21047 .80927 L
Mistroke
.22017 .78862 L
.23245 .76708 L
.25792 .73066 L
.28671 .69682 L
.30179 .68096 L
.30874 .67392 L
.31167 .67098 L
.31481 .66786 L
.31185 .66742 L
.30825 .6673 L
.30456 .66707 L
.30073 .6667 L
.29692 .66621 L
.2931 .66555 L
.28677 .66406 L
.28159 .66237 L
.27727 .66052 L
.27309 .65821 L
.2693 .65545 L
.26593 .65209 L
.26456 .65028 L
.2633 .64822 L
.26243 .6464 L
.2617 .64439 L
.26121 .64245 L
.26093 .64064 L
.26083 .63953 L
.26079 .63834 L
.26088 .63617 L
.26101 .63496 L
.26119 .63381 L
.26145 .63254 L
.26181 .63117 L
.26256 .62884 L
.26358 .62636 L
.26592 .62193 L
.27213 .61352 L
.27961 .60598 L
.28912 .59828 L
.29452 .59448 L
.29754 .59248 L
.29903 .59152 L
.2996 .59066 L
.29699 .58898 L
.2942 .58712 L
.28842 .58302 L
.27902 .5753 L
.27101 .56699 L
.26798 .56305 L
.26528 .55879 L
Mistroke
.26323 .55466 L
.26188 .55092 L
.26142 .54913 L
.26106 .54721 L
.26086 .54541 L
.26079 .54377 L
.26086 .54187 L
.26107 .54013 L
.26147 .53825 L
.26208 .53628 L
.26295 .53427 L
.26397 .53243 L
.26644 .52914 L
.26961 .52611 L
.27322 .52352 L
.27789 .521 L
.28372 .51869 L
.2903 .51686 L
.29389 .51612 L
.29804 .51545 L
.30176 .515 L
.3059 .51466 L
.30996 .51445 L
.31377 .51438 L
.31341 .51256 L
.3103 .50946 L
.3045 .50362 L
.29051 .48908 L
.26348 .45815 L
.23593 .42025 L
.22264 .39786 L
.21204 .37622 L
.20439 .35629 L
.20112 .34526 L
.19883 .33528 L
.19801 .33063 L
.19739 .32632 L
.19696 .32252 L
.19665 .31849 L
.19648 .31417 L
.1965 .30974 L
.19668 .30605 L
.19705 .30212 L
.19771 .29772 L
.19855 .29382 L
.1997 .28972 L
.2012 .2856 L
.20438 .27925 L
.20654 .27597 L
.2088 .27313 L
Mistroke
.21358 .26849 L
.21861 .26498 L
.22165 .26337 L
.22518 .26187 L
.2287 .26072 L
.23214 .25989 L
.23632 .25921 L
.23876 .25897 L
.24106 .25883 L
.24542 .25881 L
.24768 .25891 L
.25022 .2591 L
.25472 .25966 L
.25971 .26056 L
.26457 .2617 L
.2691 .263 L
.28036 .26708 L
.29317 .27308 L
.31759 .28814 L
.36283 .32763 L
.3885 .35688 L
.41098 .38714 L
.41669 .39561 L
.4219 .40365 L
.42192 .39918 L
.42081 .39394 L
.41966 .38832 L
.41556 .36553 L
.41244 .34374 L
.41023 .32323 L
.40929 .31167 L
.40864 .30103 L
.40825 .2921 L
.40799 .28233 L
.40791 .27219 L
.40801 .26279 L
.4083 .25313 L
.40854 .24779 L
.40881 .24297 L
.40947 .23369 L
.41026 .22508 L
.41262 .20624 L
.41607 .18679 L
.41989 .17042 L
.42466 .15421 L
.42937 .14115 L
.43498 .12825 L
.44098 .11678 L
.44686 .10738 L
.45934 .09206 L
Mistroke
.4668 .08536 L
.47084 .08239 L
.4752 .07966 L
.47905 .07764 L
.48335 .07581 L
.48729 .07452 L
.49101 .07362 L
.49503 .073 L
.49933 .07273 L
.50339 .07285 L
.50707 .07328 L
.51139 .07417 L
.51381 .07485 L
.51604 .07559 L
.52036 .07737 L
.52436 .07941 L
.53215 .08454 L
.54041 .09181 L
.54808 .10049 L
.55583 .11147 L
.56203 .12227 L
.56824 .13535 L
.57318 .14795 L
.57787 .16237 L
.5819 .17762 L
.58499 .19217 L
.58755 .20743 L
.58944 .22229 L
.59029 .23094 L
.59102 .24033 L
.59154 .24931 L
.59186 .25758 L
.59206 .26739 L
.59209 .27297 L
.59207 .27815 L
.59189 .28771 L
.59151 .2979 L
.59097 .30767 L
.59021 .31822 L
.58833 .33731 L
.58531 .35994 L
.58185 .38045 L
.58013 .38937 L
.57817 .39879 L
.57734 .40486 L
.58174 .39801 L
.60368 .36688 L
.64639 .31837 L
.66995 .29753 L
.69438 .28019 L
Mistroke
.71436 .26939 L
.72517 .26493 L
.73484 .26186 L
.74 .26062 L
.74267 .26009 L
.74545 .25963 L
.74783 .25931 L
.75042 .25905 L
.75485 .2588 L
.75899 .25884 L
.76327 .25917 L
.76715 .25975 L
.77055 .26052 L
.77433 .26169 L
.77766 .26304 L
.78109 .26481 L
.78451 .26702 L
.78781 .26968 L
.79065 .27251 L
.79297 .2753 L
.79521 .27857 L
.79703 .28178 L
.7985 .2849 L
.80083 .29148 L
.80182 .29541 L
.80225 .29755 L
.80264 .29988 L
.80317 .30429 L
.80345 .30851 L
.80352 .31104 L
.80353 .3134 L
.80347 .31603 L
.80333 .31885 L
.80292 .32368 L
.80259 .32647 L
.80223 .32911 L
.80045 .33873 L
.79776 .34935 L
.79026 .37078 L
.78078 .39136 L
.75822 .42907 L
.72938 .46679 L
.71334 .48493 L
.69898 .50007 L
.69335 .50579 L
.6877 .51146 L
.68486 .51429 L
.68889 .51442 L
.69263 .51457 L
.69599 .5148 L
Mistroke
.6999 .51519 L
.70344 .51567 L
.70965 .51685 L
.7129 .51766 L
.71573 .51851 L
.72157 .52075 L
.72633 .52325 L
.73004 .52582 L
.73181 .52736 L
.73353 .52911 L
.73483 .53069 L
.73607 .5325 L
.73696 .5341 L
.73776 .53587 L
.73841 .53779 L
.73884 .53964 L
.7391 .54141 L
.73921 .54331 L
.73917 .54495 L
.739 .54676 L
.73883 .54788 L
.73858 .5491 L
.73799 .55133 L
.73724 .55351 L
.73639 .55553 L
.73394 .56012 L
.73062 .56495 L
.72362 .5728 L
.71427 .58096 L
.7 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002b0?ooo`T006Ko/P3oool00:h0oooo4000I_n_0?ooo`00
[@3oool6001Vo`<0oooo00@000000?ooo`3oool0oooo1P00I_n]0?ooo`00Z`3oool4001Vo`L0oooo
00<000000?ooo`3oool0103oool5001Voj/0oooo002Z0?ooo`@006Ko203oool00`000000oooo0?oo
o`060?ooo`@006KoZP3oool00:T0oooo0`00I_l:0?ooo`030000003oool0oooo00P0oooo0`00I_nY
0?ooo`00Y`3oool4001Vo`/0oooo00<000000?ooo`3oool02@3oool3001VojP0oooo002V0?ooo`@0
06Ko303oool2000000/0oooo0`00I_nW0?ooo`00Y@3oool3001Vo`h0oooo00<000000?ooo`3oool0
2`3oool3001VojH0oooo002T0?ooo`<006Ko3`3oool00`000000oooo0?ooo`0<0?ooo`<006KoY@3o
ool00:@0oooo0P00I_l@0?ooo`030000003oool0oooo00d0oooo0P00I_nU0?ooo`00X`3oool2001V
oa40oooo00<000000?ooo`3oool03P3oool2001Voj@0oooo002R0?ooo`<006Ko4@3oool00`000000
oooo0?ooo`0?0?ooo`8006KoX`3oool00:80oooo0P00I_lB0?ooo`030000003oool0oooo0100oooo
0P00I_nR0?ooo`00X@3oool2001Voa<0oooo00<000000?ooo`3oool04@3oool00`00I_l0oooo0?oo
o`2P0?ooo`00X03oool2001Voa@0oooo00<000000?ooo`3oool04@3oool2001Voj40oooo002P0?oo
o`03001Vo`3oool0oooo01<0oooo00<000000?ooo`3oool04P3oool00`00I_l0oooo0?ooo`2O0?oo
o`00W`3oool2001VoaD0oooo00<000000?ooo`3oool04P3oool2001Voj00oooo002O0?ooo`03001V
o`3oool0oooo01@0oooo00<000000?ooo`3oool04`3oool00`00I_l0oooo0?ooo`2N0?ooo`00WP3o
ool2001VoaH0oooo00<000000?ooo`3oool04`3oool2001Voil0oooo002N0?ooo`03001Vo`3oool0
oooo00P0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0
oooo01@0oooo00<006Ko0?ooo`3oool0W@3oool009d0oooo0P00I_l=0?ooo`030;YbLP2jj_l0oooo
00L0oooo00<000000?ooo`3oool0503oool2001Voih0oooo002M0?ooo`8006Ko3@3oool00`2jLW80
^^[o0?ooo`070?ooo`030000003oool0oooo01D0oooo0P00I_nM0?ooo`00W03oool2001Vo`h0oooo
00<0^W9b0;[Zo`3oool01`3oool3000001H0oooo00<006Ko0?ooo`3oool0V`3oool009`0oooo0P00
I_l20?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2jLW80^^[o0?oo
o`070?ooo`030000003oool0oooo01H0oooo0P00I_nL0?ooo`00V`3oool3001Vo`h0oooo00<0^W9b
0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009/0oooo0P00I_l?0?oo
o`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2001Voi`0oooo002J0?ooo`<0
06Ko303oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool05P3oool2001V
oi`0oooo002J0?ooo`8006Ko3`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo01H0
oooo0`00I_nK0?ooo`00VP3oool2001VoaX0oooo00<000000?ooo`3oool05`3oool2001Voi/0oooo
002I0?ooo`<006Ko6P3oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3oool009T0oooo0P00I_lK
0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?ooo`00V@3oool2001Voa/0oooo00<000000?oo
o`3oool0603oool2001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0H0?ooo`<0
06KoV@3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V@3o
ool2001Voa/0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002H0?ooo`8006Ko703oool0
0`000000oooo0?ooo`0I0?ooo`<006KoV03oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo
01X0oooo0P00I_nH0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06P3oool2001VoiP0
oooo002G0?ooo`<006Ko703oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009L0oooo0P00
I_lM0?ooo`800000703oool2001VoiL0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0K
0?ooo`8006KoU`3oool009H0oooo0`00I_lM0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?oo
o`00UP3oool2001Voah0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F0?ooo`8006Ko
7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00I_lN0?ooo`030000003o
ool0oooo01`0oooo0P00I_nF0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool0703oool2
001VoiH0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009H0
oooo0P00I_lN0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo
00<000000?ooo`3oool0703oool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?oo
o`0L0?ooo`8006KoUP3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF
0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VoiH0oooo002E0?ooo`80
06Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo0P00I_lO0?ooo`030000
003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703o
ool3001VoiD0oooo002D0?ooo`8006Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool0
09@0oooo0P00I_lP0?ooo`8000007P3oool2001VoiD0oooo002D0?ooo`8006Ko803oool00`000000
oooo0?ooo`0M0?ooo`8006KoU@3oool009@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo
0P00I_nE0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo002D
0?ooo`8006Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009@0oooo0P00I_lP0?oo
o`030000003oool0oooo01d0oooo0P00I_nE0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3o
ool07@3oool2001VoiD0oooo002D0?ooo`03001Vo`3oool0oooo01l0oooo00<000000?ooo`3oool0
7@3oool2001VoiD0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3o
ool009<0oooo0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_nE0?ooo`00T`3oool2001V
ob40oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo001C0?ooo``006Ko=03oool2001Vob40
oooo00<000000?ooo`3oool07@3oool2001VocD0oooo3000I_mD0?ooo`00D03ooolC001Voc00oooo
0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_l`0?oooa@006KoD@3oool004h0oooo1P00
I_l:0?ooo`P006Ko;@3oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001Vobh0oooo2000
I_l:0?ooo`H006KoC`3oool004d0oooo1000I_lA0?ooo`L006Ko:P3oool2001Vob40oooo00<00000
0?ooo`3oool07@3oool2001Vob`0oooo1@00I_lB0?ooo`D006KoC@3oool004`0oooo0`00I_lG0?oo
o`D006Ko:03oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001VobX0oooo1@00I_lF0?oo
o`@006KoC03oool004/0oooo0`00I_lJ0?ooo`@006Ko9`3oool2001Vob40oooo0P00000N0?ooo`80
06Ko:03oool5001VoaX0oooo0`00I_m;0?ooo`00BP3oool3001Voad0oooo1000I_lU0?ooo`8006Ko
8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko9`3oool4001Voad0oooo0P00I_m;0?ooo`00B@3o
ool3001Voal0oooo1000I_lT0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko9@3o
ool4001Voal0oooo0`00I_m:0?ooo`00B@3oool2001Vob80oooo1000I_lR0?ooo`8006Ko8@3oool0
0`000000oooo0?ooo`0M0?ooo`8006Ko8`3oool5001Vob40oooo0P00I_m:0?ooo`00B@3oool2001V
ob<0oooo1000I_lQ0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko8P3oool4001V
ob@0oooo0P00I_m90?ooo`00B03oool3001VobD0oooo1000I_lO0?ooo`8006Ko8@3oool00`000000
oooo0?ooo`0M0?ooo`8006Ko803oool4001VobL0oooo00<006Ko0?ooo`3oool0A`3oool004L0oooo
0`00I_lW0?ooo`@006Ko7P3oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001Voal0oooo
1000I_lW0?ooo`8006KoB@3oool004L0oooo0P00I_lZ0?ooo`<006Ko7@3oool2001Vob40oooo00<0
00000?ooo`3oool07@3oool2001Voad0oooo1000I_lY0?ooo`<006KoB03oool004L0oooo0P00I_l[
0?ooo`@006Ko6`3oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001Voa`0oooo1000I_l[
0?ooo`8006KoB03oool004L0oooo0P00I_l/0?ooo`@006Ko6P3oool2001Vob40oooo00<000000?oo
o`3oool07@3oool2001Voa/0oooo0`00I_l]0?ooo`8006KoB03oool004L0oooo0P00I_l^0?ooo`<0
06Ko6@3oool3001Vob00oooo00<000000?ooo`3oool07@3oool2001VoaX0oooo0`00I_l^0?ooo`80
06KoB03oool004L0oooo00<006Ko0?ooo`3oool0;P3oool3001VoaT0oooo0P00I_lP0?ooo`030000
003oool0oooo01d0oooo0P00I_lI0?ooo`<006Ko;`3oool2001VodP0oooo00160?ooo`8006Ko<@3o
ool3001VoaP0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_lG0?ooo`@006Ko<03o
ool2001VodP0oooo00160?ooo`8006Ko<P3oool4001VoaH0oooo0P00I_lP0?ooo`030000003oool0
oooo01d0oooo0P00I_lF0?ooo`@006Ko<@3oool2001VodP0oooo00160?ooo`8006Ko<`3oool4001V
oaD0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_lE0?ooo`<006Ko<`3oool2001V
odP0oooo00160?ooo`8006Ko=@3oool3001Voa@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0
oooo0P00I_lD0?ooo`<006Ko=03oool2001VodP0oooo00160?ooo`8006Ko=P3oool3001Voa<0oooo
0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_lC0?ooo`<006Ko=@3oool2001VodP0oooo
00160?ooo`8006Ko=`3oool4001Voa40oooo0P00I_lP0?ooo`8000007P3oool2001Voa80oooo0`00
I_lf0?ooo`8006KoB03oool004H0oooo0P00I_lh0?ooo`@006Ko403oool2001Vob00oooo00<00000
0?ooo`3oool07@3oool2001Voa40oooo0`00I_lg0?ooo`8006KoB03oool004H0oooo0P00I_lj0?oo
o`<006Ko403oool2001Voal0oooo00<000000?ooo`3oool07@3oool2001Voa00oooo0`00I_lh0?oo
o`8006KoB03oool004H0oooo0`00I_lj0?ooo`<006Ko3`3oool2001Voal0oooo00<000000?ooo`3o
ool07@3oool2001Vo`l0oooo0`00I_li0?ooo`8006KoB03oool004L0oooo0P00I_lk0?ooo`<006Ko
3P3oool2001Voal0oooo00<000000?ooo`3oool07@3oool2001Vo`l0oooo0P00I_lj0?ooo`8006Ko
B03oool004L0oooo0P00I_ll0?ooo`8006Ko3P3oool2001Voal0oooo00<000000?ooo`3oool07@3o
ool2001Vo`h0oooo0P00I_lk0?ooo`8006KoB03oool004L0oooo0`00I_ll0?ooo`8006Ko3@3oool2
001Voal0oooo00<000000?ooo`3oool07@3oool2001Vo`d0oooo0`00I_lk0?ooo`8006KoB03oool0
04P0oooo0P00I_ll0?ooo`<006Ko303oool2001Voal0oooo00<000000?ooo`3oool0703oool2001V
o`d0oooo0`00I_lk0?ooo`<006KoB03oool004P0oooo0P00I_lm0?ooo`<006Ko2`3oool2001Voal0
oooo00<000000?ooo`3oool0703oool2001Vo``0oooo0`00I_ll0?ooo`8006KoB@3oool004P0oooo
0P00I_ln0?ooo`<006Ko2P3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001Vo`/0oooo
0`00I_lm0?ooo`8006KoB@3oool004P0oooo0`00I_ln0?ooo`8006Ko2`3oool2001Voah0oooo00<0
00000?ooo`3oool0703oool2001Vo`X0oooo0`00I_ln0?ooo`8006KoB@3oool004T0oooo0P00I_lo
0?ooo`8006Ko2P3oool2001Voah0oooo00<000000?ooo`3oool0703oool2001Vo`T0oooo0`00I_ln
0?ooo`<006KoB@3oool004T0oooo0P00I_m00?ooo`8006Ko2@3oool2001Voah0oooo00<000000?oo
o`3oool0703oool2001Vo`T0oooo0P00I_lo0?ooo`8006KoBP3oool004T0oooo0P00I_m00?ooo`<0
06Ko203oool2001Vo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002Ke0050?oo
o`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`0L0?ooo`8006Ko203oool2
001Vod00oooo0P00I_m:0?ooo`00B@3oool3001Vod00oooo0P00I_l80?ooo`8006Ko00H0^W:K0=Co
o`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo
0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0703oool2001Vo`L0oooo0`00I_m00?ooo`80
06KoBP3oool004X0oooo0P00I_m10?ooo`8006Ko1`3oool2001Vo`06002Ke03oool0oooo0?ooo`3Z
^W80L[[Z403oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo01/0oooo0P00I_l70?oo
o`<006Ko@03oool3001VodX0oooo001:0?ooo`<006Ko@@3oool2001Vo`H0oooo0P00I_l01P1b^^X0
oooo0?ooo`3oool0omBK002Ke100oooo00<0omBK002Ke03oool01@3oool3000001/0oooo0P00I_l6
0?ooo`<006Ko@@3oool2001Vod/0oooo001;0?ooo`8006Ko@@3oool00`2jLP0006Ko001Vo`030000
0005001b^P3oool006Ko001Vo`1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0
oooo00D0oooo00<000000?ooo`3oool06`3oool2001Vo`H0oooo0P00I_m20?ooo`8006KoB`3oool0
04/0oooo0P00I_m30?ooo`03001Vo`3oool0oooo00@0oooo0P00I_l30?ooo`030?oDV`00Vm@0oooo
00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`050?ooo`030000003oool0oooo
01/0oooo0P00I_l50?ooo`8006Ko@`3oool2001Vod/0oooo001<0?ooo`8006Ko@P3oool2001Vo`D0
oooo0P00I_l30?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000
oooo0?ooo`0K0?ooo`8006Ko103oool2001Vod@0oooo00<006Ko0?ooo`3oool0BP3oool004`0oooo
0P00I_m30?ooo`8006Ko103oool2001Vo`0509_Do`3oool0onZj0780V`3Dool02`3oool00`3oom@0
V`2K0=Coo`0:0?ooo`030000003oool0oooo01/0oooo0P00I_l40?ooo`03001Vo`3oool0oooo0480
oooo0P00I_m<0?ooo`00C@3oool00`00I_l0oooo0?ooo`120?ooo`03001Vo`3oool0oooo0080oooo
0P00I_l0102K000000000000LP2jj_l<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3o
ool01@3oool00`000000oooo0?ooo`0K0?ooo`8006Ko0`3oool2001Vod@0oooo00<006Ko0?ooo`3o
ool0B`3oool004d0oooo0P00I_m30?ooo`8006Ko0`3oool2001Voad0oooo00<000000?ooo`3oool0
6P3oool2001Vo`<0oooo0P00I_m40?ooo`8006KoC@3oool004h0oooo00<006Ko0?ooo`3oool0@P3o
ool2001Vo`80oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_l30?ooo`03001Vo`3o
ool0oooo0480oooo0P00I_m>0?ooo`00CP3oool2001Vod@0oooo0P00I_l00`3oool006Ko001Vo`0M
0?ooo`030000003oool0oooo01X0oooo0P00I_l20?ooo`8006KoA03oool00`00I_l0oooo0?ooo`1=
0?ooo`00C`3oool00`00I_l0oooo0?ooo`130?ooo`04001Vo`3oool0oooo001Voad0oooo00<00000
0?ooo`3oool06P3oool2001Vo`030?ooo`00I_l006Ko04@0oooo0P00I_m?0?ooo`00C`3oool2001V
od@0oooo0P00I_l00`3oool006Ko001Vo`0L0?ooo`030000003oool0oooo01T0oooo0`00I_l00`3o
ool006Ko0?ooo`140?ooo`03001Vo`3oool0oooo04h0oooo001@0?ooo`03001Vo`3oool0oooo04<0
oooo0P00I_l00`3oool006Ko0?ooo`0K0?ooo`030000003oool0oooo01T0oooo0P00I_l00`3oool0
06Ko001Vo`140?ooo`8006KoD03oool00500oooo0P00I_m50?ooo`<006Ko703oool00`000000oooo
0?ooo`0I0?ooo`@006KoA@3oool00`00I_l0oooo0?ooo`1?0?ooo`00D@3oool00`00I_l0oooo0?oo
o`130?ooo`<006Ko703oool00`000000oooo0?ooo`0H0?ooo`@006KoA@3oool2001Voe40oooo001A
0?ooo`8006KoA@3oool2001Voa`0oooo00<000000?ooo`3oool0603oool4001Vod@0oooo0P00I_mB
0?ooo`00DP3oool00`00I_l0oooo0?ooo`130?ooo`8006Ko703oool00`000000oooo0?ooo`0H0?oo
o`<006KoA@3oool00`00I_l0oooo0?ooo`1A0?ooo`00DP3oool2001VodD0oooo00<006Ko0?ooo`3o
ool06P3oool00`000000oooo0?ooo`0H0?ooo`8006KoA@3oool2001Voe<0oooo001C0?ooo`03001V
o`3oool0oooo0600oooo0P00000I0?ooo`03001Vo`3oool0oooo04@0oooo00<006Ko0?ooo`3oool0
DP3oool005<0oooo0P00I_mQ0?ooo`030000003oool0oooo05h0oooo0P00I_mD0?ooo`00E03oool0
0`00I_l0oooo0?ooo`1O0?ooo`030000003oool0oooo05h0oooo00<006Ko0?ooo`3oool0D`3oool0
05@0oooo0P00I_mP0?ooo`030000003oool0oooo05d0oooo0P00I_mE0?ooo`00E@3oool2001Voel0
oooo00<000000?ooo`3oool0G03oool2001VoeH0oooo001E0?ooo`<006KoGP3oool00`000000oooo
0?ooo`1L0?ooo`03001Vo`3oool0oooo05D0oooo001F0?ooo`8006KoGP3oool00`000000oooo0?oo
o`1K0?ooo`8006KoE`3oool005L0oooo0P00I_mM0?ooo`030000003oool0oooo05X0oooo0P00I_mH
0?ooo`00E`3oool3001Voe`0oooo00<000000?ooo`3oool0F@3oool3001VoeP0oooo001H0?ooo`<0
06KoF`3oool00`000000oooo0?ooo`1I0?ooo`8006KoF@3oool005T0oooo0P00I_mK0?ooo`030000
003oool0oooo05P0oooo0P00I_mJ0?ooo`00FP3oool2001VoeX0oooo00<000000?ooo`3oool0E`3o
ool3001VoeX0oooo001J0?ooo`<006KoF@3oool00`000000oooo0?ooo`1F0?ooo`<006KoF`3oool0
05/0oooo0`00I_mH0?ooo`030000003oool0oooo05D0oooo0`00I_mL0?ooo`00G03oool3001VoeL0
oooo00<000000?ooo`3oool0E@3oool2001Voed0oooo001M0?ooo`8006KoE`3oool00`000000oooo
0?ooo`1D0?ooo`8006KoGP3oool005h0oooo0P00I_mF0?ooo`800000E03oool3001Voeh0oooo001N
0?ooo`<006KoE@3oool00`000000oooo0?ooo`1B0?ooo`<006KoG`3oool005l0oooo0`00I_mD0?oo
o`030000003oool0oooo0580oooo0P00I_mP0?ooo`00H03oool3001Voe<0oooo00<000000?ooo`3o
ool0D@3oool2001Vof40oooo001Q0?ooo`8006KoD`3oool00`000000oooo0?ooo`1@0?ooo`<006Ko
H@3oool00680oooo0P00I_mB0?ooo`030000003oool0oooo04l0oooo0`00I_mR0?ooo`00HP3oool3
001Voe40oooo00<000000?ooo`3oool0CP3oool3001Vof<0oooo001S0?ooo`<006KoD03oool00`00
0000oooo0?ooo`1=0?ooo`<006KoI03oool006@0oooo0`00I_m?0?ooo`030000003oool0oooo04d0
oooo0P00I_mU0?ooo`00I@3oool3001Vodh0oooo00<000000?ooo`3oool0C03oool2001VofH0oooo
001V0?ooo`8006KoCP3oool00`000000oooo0?ooo`1;0?ooo`<006KoIP3oool006L0oooo0P00I_m=
0?ooo`030000003oool0oooo04X0oooo0`00I_mW0?ooo`00I`3oool3001Vod`0oooo00<000000?oo
o`3oool0B@3oool3001VofP0oooo001X0?ooo`<006KoB`3oool00`000000oooo0?ooo`180?ooo`<0
06KoJ@3oool006T0oooo0`00I_m:0?ooo`030000003oool0oooo04L0oooo0`00I_mZ0?ooo`00JP3o
ool3001VodT0oooo00<000000?ooo`3oool0AP3oool3001Vof/0oooo001[0?ooo`<006KoB03oool0
0`000000oooo0?ooo`150?ooo`<006KoK03oool006`0oooo0`00I_m70?ooo`800000A@3oool3001V
ofd0oooo001]0?ooo`<006KoAP3oool00`000000oooo0?ooo`130?ooo`<006KoKP3oool006h0oooo
1000I_m40?ooo`030000003oool0oooo0480oooo0`00I_m_0?ooo`00K`3oool3001Vod@0oooo00<0
00000?ooo`3oool0@@3oool3001Vog00oooo001a0?ooo`8006Ko@`3oool00`000000oooo0?ooo`10
0?ooo`<006KoL@3oool006`0oooo1`00I_m30?ooo`030000003oool0oooo03l0oooo2@00I_m/0?oo
o`00I`3oool=001Vod80oooo00<000000?ooo`3oool0?P3oool>001VofP0oooo001U0?ooo`P006Ko
B@3oool00`000000oooo0?ooo`170?ooo`T006KoI03oool00680oooo1P00I_m>0?ooo`030000003o
ool0oooo04/0oooo1`00I_mR0?ooo`00HP3oool4001Voe00oooo00<000000?ooo`3oool0C`3oool3
001Vof80oooo001Q0?ooo`8006KoD`3oool00`000000oooo0?ooo`1@0?ooo`<006KoH@3oool00600
oooo0P00I_mD0?ooo`030000003oool0oooo0540oooo0`00I_mP0?ooo`00GP3oool4001Voe@0oooo
00<000000?ooo`3oool0DP3oool2001Vof00oooo001N0?ooo`<006KoE@3oool00`000000oooo0?oo
o`1B0?ooo`<006KoG`3oool005h0oooo0P00I_mF0?ooo`030000003oool0oooo05<0oooo0P00I_mO
0?ooo`00GP3oool2001VoeH0oooo00<000000?ooo`3oool0D`3oool2001Voel0oooo001N0?ooo`80
06KoEP3oool2000005@0oooo0P00I_mO0?ooo`004@3oool00`3oe9/000000000000300000003002K
e03oool0oooo0480oooo00D0omBK00000000I_l006Ko09_Do`050?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`130?ooo`030000003oool0oooo04@0oooo00D0omBK0000
00000000000009_Do`050?ooo`030=BK0000000009_D0080oooo0P00I_l00`3oool0e9/000000002
0000000309_Do`3oool0oooo0480oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0<
0?ooo`00503oool00`2jLW80^^[o0?ooo`150?ooo`060;YbV`3Dool006Ko001Vo`2K09/0e?oo103o
ool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`120?ooo`03
0000003oool0oooo04@0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK00000000
09_D0080oooo0P00I_l01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0AP3oool00`2jLW80^^[o
0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`140?ooo`030?oDV`00Vm@0oooo008006Ko00<0
j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`110?ooo`030000003oool0oooo04<0oooo00<0
omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`070?ooo`<006Ko1@3oool00`3oe9/009_D0?oo
o`150?ooo`030;YbLP2jj_l0oooo00l0oooo000D0?ooo`030;YbLP2jj_l0oooo04@0oooo00<0j[Yb
07:jjP3oool00`00I_l00`00Vm@0oooo0?ooo`0>0?ooo`030?oDV`00Vm@0oooo0440oooo00<00000
0?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00L0oooo0P00I_l6
0?ooo`030?oDV`00Vm@0oooo04D0oooo00<0^W9b0;[Zo`3oool03`3oool000P0oooo00<0^W800000
000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo03/0oooo00<0^W800000
000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z0080oooo0`00I_l@0?ooo`030;Yb002Ke?l0
oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo00L0oooo0P00I_l60?ooo`030;Yb002Ke?l0oooo04D0oooo00<0^W9b0;[Zo`3oool03`3oool0
01@0oooo00<0^W9b0;[Zo`3oool0A03oool00`3Z^W80L[[Z0?ooo`020?ooo`8006Ko2`3oool00`3o
om@0V`00000000020000000307:jjP3oool0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00L0oooo00D006Ko0?ooo`3oool0oooD09/00003
0000000307:jjP3oool0oooo04D0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Z
o`3oool0A03oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP00I_l006Ko00X0oooo00<0oooD09/0
V`3Dool0AP3oool00`000000oooo0?ooo`130?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:j
jP3oool01P3oool2001Vo`80oooo00<0oooD09/0V`3Dool0BP3oool00`2jLW80^^[o0?ooo`0?0?oo
o`004@3oool01@3Z^W800000001b^P2jLW80^^[o04H0oooo00D0^W8009_Do`3oool0onZj0780V`03
001Vo`T0oooo00<0oooD09/0V`3Dool0AP3oool00`000000oooo0?ooo`140?ooo`060;Yb002Ke?l0
oooo0?oZ^P1b09/0e?oo1@3oool3001Vo`<0oooo00<0oooD09/0V`3Dool0A`3oool01@3Z^W800000
001b^P2jLW80^^[o0100oooo000C0?ooo`030>ZjLP000780^^[o04H0oooo00H0oooD09/000000000
001b0;[Zo`3oool3001Vo`P0oooo00<0oooD09/0000000000P0000000`0009/0e?oo0?ooo`110?oo
o`030000003oool0oooo04@0oooo00D0oooD09/000000000001b0;[Zo`050?ooo`@006Ko0`3oool0
0`3oom@0V`0000000002000000030000V`3Dool0oooo04@0oooo00<0j[Yb0000LP2jj_l0403oool0
06<0oooo0`00I_m@0?ooo`030000003oool0oooo04d0oooo0`00I_mT0?ooo`00I03oool3001Vodl0
oooo00<000000?ooo`3oool0C03oool3001VofD0oooo001U0?ooo`@006KoC@3oool00`000000oooo
0?ooo`1;0?ooo`<006KoIP3oool006H0oooo1000I_m<0?ooo`030000003oool0oooo04X0oooo0`00
I_mW0?ooo`00J03oool3001Vod/0oooo00<000000?ooo`3oool0B@3oool3001VofP0oooo001Y0?oo
o`<006KoBP3oool00`000000oooo0?ooo`170?ooo`@006KoJ@3oool006X0oooo1000I_m80?ooo`03
0000003oool0oooo04H0oooo1000I_mZ0?ooo`00J`000004001Vohl000001000I_m[0000000000<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0103oool6001Vo`<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo00@0oooo1000I_l60?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`400000000@0?ooo`030000003oool0
oooo0500oooo00<000000?ooo`3oool00`3oool4001VodT0oooo00<000000?ooo`3oool0B03oool3
001Vo`D0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0?0?ooo`00J03oool3001V
od/0oooo00<000000?ooo`3oool0B@3oool3001VofP0oooo001V0?ooo`@006KoC03oool00`000000
oooo0?ooo`1:0?ooo`<006KoI`3oool006D0oooo1000I_m=0?ooo`030000003oool0oooo04/0oooo
0`00I_mV0?ooo`00I03oool3001Vodl0oooo00<000000?ooo`3oool0C03oool3001VofD0oooo001S
0?ooo`<006KoD03oool00`000000oooo0?ooo`1=0?ooo`<006KoI03oool00680oooo0`00I_mA0?oo
o`030000003oool0oooo04h0oooo0`00I_mS0?ooo`00H@3oool3001Voe80oooo00<000000?ooo`3o
ool0C`3oool3001Vof80oooo001P0?ooo`<006KoD`3oool00`000000oooo0?ooo`1@0?ooo`<006Ko
H@3oool005l0oooo0`00I_mD0?ooo`030000003oool0oooo0540oooo0P00I_mQ0?ooo`00G`3oool2
001VoeD0oooo00<000000?ooo`3oool0D@3oool3001Vof00oooo001O0?ooo`8006KoE@3oool00`00
0000oooo0?ooo`1B0?ooo`8006KoH03oool005h0oooo0`00I_mE0?ooo`030000003oool0oooo0580
oooo0`00I_mO0?ooo`00GP3oool2001VoeH0oooo00<000000?ooo`3oool0D`3oool2001Voel0oooo
001N0?ooo`8006KoEP3oool00`000000oooo0?ooo`1C0?ooo`8006KoG`3oool005h0oooo0P00I_mF
0?ooo`800000E03oool2001Voel0oooo001N0?ooo`8006KoEP3oool00`000000oooo0?ooo`1C0?oo
o`8006KoG`3oool005h0oooo0P00I_mF0?ooo`030000003oool0oooo05<0oooo0P00I_mO0?ooo`00
GP3oool2001VoeH0oooo00<000000?ooo`3oool0DP3oool3001Voel0oooo001N0?ooo`<006KoE@3o
ool00`000000oooo0?ooo`1B0?ooo`<006KoG`3oool005l0oooo0`00I_mD0?ooo`030000003oool0
oooo0540oooo0`00I_mP0?ooo`00H03oool3001Voe<0oooo00<000000?ooo`3oool0D03oool4001V
of00oooo001Q0?ooo`<006KoDP3oool00`000000oooo0?ooo`1?0?ooo`<006KoHP3oool00680oooo
1@00I_m?0?ooo`030000003oool0oooo04d0oooo1000I_mS0?ooo`00H`3oool6001Vodd0oooo00<0
00000?ooo`3oool0BP3oool6001Vof@0oooo001V0?ooo`L006KoB@3oool00`000000oooo0?ooo`17
0?ooo`L006KoIP3oool006P0oooo3000I_m20?ooo`030000003oool0oooo0400oooo2`00I_mY0?oo
o`00K03oool7001Vod<0oooo00<000000?ooo`3oool0@03oool8001Vof`0oooo001`0?ooo`8006Ko
A03oool00`000000oooo0?ooo`110?ooo`<006KoL03oool006l0oooo0P00I_m50?ooo`030000003o
ool0oooo0480oooo0`00I_m_0?ooo`00KP3oool2001VodH0oooo00<000000?ooo`3oool0@`3oool3
001Vofh0oooo001]0?ooo`8006KoA`3oool2000004D0oooo0`00I_m]0?ooo`00K03oool3001VodL0
oooo00<000000?ooo`3oool0A@3oool3001Vof`0oooo001[0?ooo`<006KoB03oool00`000000oooo
0?ooo`160?ooo`<006KoJ`3oool006X0oooo0`00I_m90?ooo`030000003oool0oooo04L0oooo0`00
I_mZ0?ooo`00J@3oool3001VodX0oooo00<000000?ooo`3oool0B03oool3001VofT0oooo001X0?oo
o`<006KoB`3oool00`000000oooo0?ooo`190?ooo`<006KoJ03oool006L0oooo0`00I_m<0?ooo`03
0000003oool0oooo04X0oooo0`00I_mW0?ooo`00IP3oool3001Vodd0oooo00<000000?ooo`3oool0
B`3oool3001VofH0oooo001U0?ooo`<006KoCP3oool00`000000oooo0?ooo`1<0?ooo`8006KoIP3o
ool006D0oooo0P00I_m?0?ooo`030000003oool0oooo04d0oooo0P00I_mU0?ooo`00I03oool2001V
oe00oooo00<000000?ooo`3oool0C@3oool3001Vof@0oooo001S0?ooo`<006KoD03oool00`000000
oooo0?ooo`1>0?ooo`<006KoH`3oool00680oooo0`00I_mA0?ooo`030000003oool0oooo04l0oooo
0`00I_mR0?ooo`00H@3oool3001Voe80oooo00<000000?ooo`3oool0D03oool3001Vof40oooo001Q
0?ooo`8006KoD`3oool00`000000oooo0?ooo`1A0?ooo`<006KoH03oool00600oooo0P00I_mD0?oo
o`030000003oool0oooo0580oooo0`00I_mO0?ooo`00G`3oool2001VoeD0oooo00<000000?ooo`3o
ool0D`3oool2001Voel0oooo001N0?ooo`<006KoE@3oool2000005D0oooo0P00I_mN0?ooo`00GP3o
ool2001VoeH0oooo00<000000?ooo`3oool0E03oool3001Voed0oooo001M0?ooo`8006KoE`3oool0
0`000000oooo0?ooo`1E0?ooo`<006KoG03oool005`0oooo0P00I_mH0?ooo`030000003oool0oooo
05H0oooo0P00I_mL0?ooo`00F`3oool2001VoeT0oooo00<000000?ooo`3oool0E`3oool2001Voe/0
oooo001K0?ooo`03001Vo`3oool0oooo05P0oooo00<000000?ooo`3oool0F03oool2001VoeX0oooo
001J0?ooo`8006KoFP3oool00`000000oooo0?ooo`1I0?ooo`03001Vo`3oool0oooo05P0oooo001I
0?ooo`8006KoF`3oool00`000000oooo0?ooo`1I0?ooo`8006KoF@3oool005P0oooo0P00I_mL0?oo
o`030000003oool0oooo05X0oooo00<006Ko0?ooo`3oool0E`3oool005L0oooo0P00I_mM0?ooo`03
0000003oool0oooo05X0oooo0P00I_mH0?ooo`00E`3oool00`00I_l0oooo0?ooo`1L0?ooo`030000
003oool0oooo05/0oooo0P00I_mG0?ooo`00EP3oool2001Voeh0oooo00<000000?ooo`3oool0G03o
ool00`00I_l0oooo0?ooo`1E0?ooo`00E@3oool2001Voel0oooo00<000000?ooo`3oool0G03oool2
001VoeH0oooo001D0?ooo`8006KoH03oool00`000000oooo0?ooo`1M0?ooo`8006KoE@3oool005@0
oooo00<006Ko0?ooo`3oool0G`3oool00`000000oooo0?ooo`1N0?ooo`03001Vo`3oool0oooo05<0
oooo001C0?ooo`8006KoH@3oool00`000000oooo0?ooo`1N0?ooo`8006KoE03oool005<0oooo00<0
06Ko0?ooo`3oool0H03oool2000001T0oooo00<006Ko0?ooo`3oool0A03oool00`00I_l0oooo0?oo
o`1B0?ooo`00DP3oool2001Vof80oooo00<000000?ooo`3oool0603oool2001VodD0oooo0P00I_mC
0?ooo`00DP3oool00`00I_l0oooo0?ooo`140?ooo`03001Vo`3oool0oooo01X0oooo00<000000?oo
o`3oool0603oool3001VodD0oooo0P00I_mB0?ooo`00D@3oool2001VodD0oooo0`00I_lK0?ooo`03
0000003oool0oooo01P0oooo0`00I_m60?ooo`03001Vo`3oool0oooo0500oooo001A0?ooo`03001V
o`3oool0oooo04@0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0`00I_m50?ooo`8006Ko
D@3oool00500oooo0P00I_m50?ooo`<006Ko703oool00`000000oooo0?ooo`0I0?ooo`<006KoAP3o
ool00`00I_l0oooo0?ooo`1?0?ooo`00D03oool00`00I_l0oooo0?ooo`140?ooo`<006Ko703oool0
0`000000oooo0?ooo`0J0?ooo`<006KoA@3oool2001Voe00oooo001?0?ooo`8006KoA@3oool4001V
oa`0oooo00<000000?ooo`3oool06@3oool2001Vo`030?ooo`00I_l006Ko04D0oooo00<006Ko0?oo
o`3oool0CP3oool004l0oooo00<006Ko0?ooo`3oool0@`3oool2001Vo`030?ooo`00I_l006Ko01`0
oooo00<000000?ooo`3oool06@3oool2001Vo`80oooo00<006Ko0?ooo`3oool0@`3oool2001Vodl0
oooo001>0?ooo`8006KoA03oool2001Vo`80oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo
0P00I_l20?ooo`8006KoA@3oool00`00I_l0oooo0?ooo`1=0?ooo`00CP3oool00`00I_l0oooo0?oo
o`130?ooo`03001Vo`3oool0oooo00<006Ko703oool00`000000oooo0?ooo`0I0?ooo`<006Ko0P3o
ool2001Vod@0oooo0P00I_m>0?ooo`00C@3oool2001Vod@0oooo0P00I_l20?ooo`8006Ko7@3oool0
0`000000oooo0?ooo`0J0?ooo`8006Ko0`3oool2001Vod@0oooo00<006Ko0?ooo`3oool0C03oool0
04d0oooo00<006Ko0?ooo`3oool0@P3oool2001Vo`<0oooo0P00I_lM0?ooo`030000003oool0oooo
01X0oooo0P00I_l40?ooo`03001Vo`3oool0oooo0480oooo0P00I_m=0?ooo`00C03oool2001Vod<0
oooo0P00I_l40?ooo`8006Ko0`0000000`2Ke?l0oooo0?ooo`030?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`070?ooo`030000003oool0oooo01X0oooo0P00I_l40?oo
o`8006KoA03oool00`00I_l0oooo0?ooo`1;0?ooo`00B`3oool3001Vod<0oooo00<006Ko0?ooo`3o
ool00`3oool2001Vo`050=Coo`3oool0oooD09/0V`3Dool0103oool00`3DV`000000002Ke0040?oo
o`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`060?ooo`030000003oool0oooo01X0oooo0`00
I_l40?ooo`8006Ko@`3oool2001Vod`0oooo001;0?ooo`8006Ko@`3oool2001Vo`D0oooo0P00I_l3
0?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`0K
0?ooo`8006Ko1@3oool2001Vod<0oooo00<006Ko0?ooo`3oool0BP3oool004X0oooo0`00I_m20?oo
o`8006Ko1P3oool2001Vo`<0oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`050?oo
o`030000003oool0oooo01/0oooo0P00I_l60?ooo`03001Vo`3oool0oooo0440oooo0P00I_m;0?oo
o`00BP3oool2001Vod80oooo0P00I_l70?ooo`8006Ko0`3oool00`3oe9/009_D0?ooo`0?0?ooo`03
0;Yb002Ke?l0oooo00D0oooo0`00000K0?ooo`8006Ko1P3oool2001Vod80oooo0P00I_m;0?ooo`00
BP3oool2001Vod80oooo00<006Ko0?ooo`3oool01@3oool2001Vo`0607:jjP3oool0oooo0?ooo`3o
e9/009_D2`3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?oo
o`3oool0703oool2001Vo`H0oooo0P00I_m10?ooo`8006KoB`3oool004T0oooo0`00I_m10?ooo`80
06Ko1`3oool2001Vo`0607:jjP3oool0oooo0?ooo`3Z^W80L[[Z2`3oool00`3oom@0V`2K0=Coo`0:
0?ooo`030000003oool0oooo01`0oooo0P00I_l70?ooo`8006Ko@03oool3001VodX0oooo00190?oo
o`8006Ko@@3oool2001Vo`P0oooo0P00I_l01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0
oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`0L0?ooo`8006Ko203oool2001Vod00oooo0P00
I_m:0?ooo`00B03oool3001Vod00oooo0P00I_l90?ooo`8006Ko00D0oooD09/000000000001b0;[Z
o`0<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool01@3oool00`000000oooo0?oo
o`0L0?ooo`8006Ko203oool3001Vocl0oooo0P00I_m:0?ooo`00B03oool2001Vod40oooo00<006Ko
0?ooo`3oool0203oool2001Voah0oooo00<000000?ooo`3oool0703oool2001Vo`T0oooo0`00I_ln
0?ooo`8006KoBP3oool004P0oooo0P00I_m00?ooo`8006Ko2P3oool2001Voah0oooo00<000000?oo
o`3oool0703oool2001Vo`X0oooo0`00I_lm0?ooo`<006KoB@3oool004P0oooo0P00I_lo0?ooo`80
06Ko2`3oool2001Voah0oooo00<000000?ooo`3oool0703oool2001Vo`/0oooo0`00I_lm0?ooo`80
06KoB@3oool004L0oooo0`00I_ln0?ooo`8006Ko2`3oool2001Voal0oooo00<000000?ooo`3oool0
703oool2001Vo``0oooo0`00I_ll0?ooo`8006KoB@3oool004L0oooo0P00I_ln0?ooo`8006Ko303o
ool2001Voal0oooo00<000000?ooo`3oool0703oool2001Vo`d0oooo0`00I_ll0?ooo`03001Vo`3o
ool0oooo04L0oooo00170?ooo`8006Ko?@3oool3001Vo``0oooo0P00I_lO0?ooo`030000003oool0
oooo01`0oooo0P00I_l>0?ooo`<006Ko>`3oool2001VodP0oooo00170?ooo`8006Ko?03oool3001V
o`d0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0`00I_l>0?ooo`<006Ko>`3oool00`00
I_l0oooo0?ooo`160?ooo`00A`3oool2001Voc/0oooo0`00I_l>0?ooo`8006Ko7`3oool00`000000
oooo0?ooo`0M0?ooo`8006Ko3`3oool3001VocT0oooo0P00I_m80?ooo`00A`3oool2001VocX0oooo
0`00I_l?0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0M0?ooo`8006Ko403oool3001VocP0oooo
0P00I_m80?ooo`00AP3oool3001VocT0oooo0`00I_l@0?ooo`8006Ko7`3oool00`000000oooo0?oo
o`0M0?ooo`8006Ko4@3oool3001VocL0oooo0P00I_m80?ooo`00AP3oool2001VocT0oooo0`00I_lA
0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0M0?ooo`8006Ko4P3oool3001VocH0oooo0P00I_m8
0?ooo`00AP3oool2001VocL0oooo1000I_lA0?ooo`8006Ko803oool2000001h0oooo0P00I_lC0?oo
o`<006Ko=@3oool2001VodP0oooo00160?ooo`8006Ko=P3oool4001Voa80oooo0P00I_lP0?ooo`03
0000003oool0oooo01d0oooo0P00I_lD0?ooo`<006Ko=03oool2001VodP0oooo00160?ooo`8006Ko
=@3oool3001Voa@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_lE0?ooo`<006Ko
<`3oool2001VodP0oooo00160?ooo`8006Ko=03oool3001VoaD0oooo0P00I_lP0?ooo`030000003o
ool0oooo01d0oooo0P00I_lF0?ooo`<006Ko<P3oool2001VodP0oooo00160?ooo`8006Ko<`3oool3
001VoaH0oooo0`00I_lO0?ooo`030000003oool0oooo01d0oooo0P00I_lG0?ooo`<006Ko<@3oool2
001VodP0oooo00160?ooo`8006Ko<P3oool3001VoaL0oooo0P00I_lP0?ooo`030000003oool0oooo
01d0oooo0P00I_lH0?ooo`<006Ko<03oool2001VodP0oooo00160?ooo`8006Ko<@3oool3001VoaP0
oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_lI0?ooo`@006Ko;P3oool2001VodP0
oooo00160?ooo`<006Ko;`3oool3001VoaP0oooo0`00I_lP0?ooo`030000003oool0oooo01d0oooo
0P00I_lJ0?ooo`@006Ko;@3oool2001VodP0oooo00170?ooo`8006Ko;P3oool3001VoaT0oooo0P00
I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_lL0?ooo`<006Ko;03oool2001VodP0oooo0017
0?ooo`8006Ko;03oool4001VoaX0oooo0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_lM
0?ooo`<006Ko:`3oool2001VodP0oooo00180?ooo`03001Vo`3oool0oooo02T0oooo1000I_lK0?oo
o`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko7P3oool4001VobP0oooo0`00I_m80?oo
o`00B03oool2001VobP0oooo1000I_lM0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`80
06Ko7`3oool4001VobL0oooo0P00I_m90?ooo`00B@3oool00`00I_l0oooo0?ooo`0U0?ooo`@006Ko
7P3oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001Vob40oooo1000I_lU0?ooo`8006Ko
B@3oool004P0oooo0`00I_lT0?ooo`@006Ko803oool2001Vob40oooo00<000000?ooo`3oool07@3o
ool2001Vob80oooo1000I_lT0?ooo`8006KoB@3oool004T0oooo0`00I_lR0?ooo`@006Ko8@3oool2
001Vob40oooo00<000000?ooo`3oool07@3oool2001Vob@0oooo1000I_lQ0?ooo`<006KoB@3oool0
04X0oooo0P00I_lP0?ooo`@006Ko8`3oool2001Vob40oooo00<000000?ooo`3oool07@3oool2001V
obD0oooo1000I_lO0?ooo`<006KoBP3oool004/0oooo0P00I_lM0?ooo`D006Ko903oool2001Vob40
oooo00<000000?ooo`3oool07@3oool2001VobL0oooo1000I_lM0?ooo`8006KoB`3oool004`0oooo
0P00I_lJ0?ooo`D006Ko9P3oool2001Vob40oooo0P00000N0?ooo`8006Ko:03oool5001VoaX0oooo
0P00I_m<0?ooo`00C03oool3001VoaL0oooo1@00I_lX0?ooo`8006Ko8@3oool00`000000oooo0?oo
o`0M0?ooo`8006Ko:P3oool5001VoaL0oooo0P00I_m=0?ooo`00C@3oool3001Voa<0oooo1P00I_lZ
0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko;03oool5001Voa<0oooo1000I_m=
0?ooo`00CP3oool4001Vo`l0oooo1P00I_l/0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?oo
o`8006Ko;P3oool5001Vo`l0oooo1@00I_m>0?ooo`00C`3oool6001Vo`T0oooo1P00I_l_0?ooo`80
06Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko<03oool7001Vo`T0oooo1@00I_m@0?ooo`00
D@3ooolA001Voc40oooo0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_lb0?oooa4006Ko
DP3oool005@0oooo2`00I_ld0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko=P3o
ool;001Voe@0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool0
09<0oooo0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_nE0?ooo`00T`3oool2001Vob40
oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo002C0?ooo`<006Ko803oool00`000000oooo
0?ooo`0M0?ooo`8006KoU@3oool009@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00
I_nE0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo002D0?oo
o`8006Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009@0oooo0P00I_lP0?ooo`03
0000003oool0oooo01d0oooo0P00I_nE0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool0
7@3oool2001VoiD0oooo002D0?ooo`8006Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3o
ool009@0oooo0P00I_lP0?ooo`8000007@3oool3001VoiD0oooo002D0?ooo`8006Ko803oool00`00
0000oooo0?ooo`0L0?ooo`8006KoUP3oool009@0oooo0P00I_lP0?ooo`030000003oool0oooo01`0
oooo0P00I_nF0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool0703oool2001VoiH0oooo
002D0?ooo`<006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo0P00I_lO
0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?oo
o`3oool0703oool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`80
06KoUP3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00UP3o
ool2001Voah0oooo00<000000?ooo`3oool0703oool2001VoiH0oooo002F0?ooo`8006Ko7P3oool0
0`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo
01`0oooo0P00I_nF0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool0703oool2001VoiH0
oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009H0oooo0P00
I_lN0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00U`3oool2001Voad0oooo00<00000
0?ooo`3oool06`3oool2001VoiL0oooo002G0?ooo`8006Ko7@3oool2000001/0oooo0`00I_nG0?oo
o`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G0?ooo`8006Ko
7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?ooo`030000003o
ool0oooo01T0oooo0`00I_nH0?ooo`00U`3oool3001Voa`0oooo00<000000?ooo`3oool06@3oool2
001VoiT0oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009P0
oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI0?ooo`00V03oool3001Voa/0oooo
00<000000?ooo`3oool06@3oool2001VoiT0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?oo
o`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01P0oooo0P00I_nJ
0?ooo`00V@3oool3001VoaX0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002J0?ooo`80
06Ko6P3oool00`000000oooo0?ooo`0G0?ooo`<006KoVP3oool009X0oooo0P00I_lJ0?ooo`030000
003oool0oooo01L0oooo0P00I_nK0?ooo`00VP3oool3001Vo``0oooo00<0omBK0000000000000`00
00000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo01L0oooo0P00I_nK0?ooo`00V`3oool2
001Vo`l0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`<006KoV`3oool0
09/0oooo0P00I_l?0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2001V
oi`0oooo002K0?ooo`<006Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01D0
oooo0`00I_nL0?ooo`00W03oool2001Vo`h0oooo00<0^W9b0;[Zo`3oool01`3oool3000001D0oooo
0P00I_nM0?ooo`00W03oool3001Vo`d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?oo
o`0E0?ooo`8006KoW@3oool009d0oooo0P00I_l=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<00000
0?ooo`3oool05@3oool00`00I_l0oooo0?ooo`2L0?ooo`00W@3oool2001Vo`X0oooo00D0j[Yb0000
0000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo01@0oooo0P00I_nN0?ooo`00WP3oool00`00
I_l0oooo0?ooo`0:0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0503oool00`00
I_l0oooo0?ooo`2M0?ooo`00WP3oool2001VoaH0oooo00<000000?ooo`3oool04`3oool2001Voil0
oooo002O0?ooo`8006Ko5@3oool00`000000oooo0?ooo`0C0?ooo`03001Vo`3oool0oooo09h0oooo
002P0?ooo`8006Ko503oool00`000000oooo0?ooo`0B0?ooo`8006KoX03oool00:40oooo00<006Ko
0?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`8006KoX@3oool00:40oooo0P00I_lC0?oo
o`030000003oool0oooo0100oooo0P00I_nR0?ooo`00XP3oool2001Voa80oooo00<000000?ooo`3o
ool0403oool00`00I_l0oooo0?ooo`2Q0?ooo`00X`3oool2001Voa40oooo00<000000?ooo`3oool0
3`3oool2001Voj<0oooo002S0?ooo`<006Ko403oool00`000000oooo0?ooo`0?0?ooo`03001Vo`3o
ool0oooo0:80oooo002T0?ooo`8006Ko403oool00`000000oooo0?ooo`0>0?ooo`8006KoY03oool0
0:D0oooo0P00I_l?0?ooo`030000003oool0oooo00`0oooo0`00I_nU0?ooo`00Y@3oool3001Vo`h0
oooo00<000000?ooo`3oool02`3oool4001VojD0oooo002V0?ooo`<006Ko3@3oool2000000/0oooo
0`00I_nW0?ooo`00Y`3oool3001Vo``0oooo00<000000?ooo`3oool02@3oool3001VojP0oooo002X
0?ooo`@006Ko2P3oool00`000000oooo0?ooo`070?ooo`@006KoZ@3oool00:T0oooo1000I_l90?oo
o`030000003oool0oooo00H0oooo1000I_nZ0?ooo`00Z`3oool4001Vo`L0oooo00<000000?ooo`3o
ool01@3oool3001Voj`0oooo002/0?ooo`@006Ko1P3oool00`000000oooo0?ooo`040?ooo`<006Ko
[@3oool00:h0oooo1@00I_l30?ooo`030000003oool0oooo00H006Ko[P3oool00:l0oooo3`00I_n_
0?ooo`00/P3oool8001Vok<0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`800000]@3oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00001\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.73636 .59091 m
.74455 .59841 L
.75161 .60583 L
.75887 .6151 L
.764 .62384 L
.76594 .62829 L
.76678 .63065 L
.76751 .63314 L
.76801 .63531 L
.76843 .63769 L
.76866 .63984 L
.76876 .64184 L
.76873 .64427 L
.76852 .64654 L
.7682 .64856 L
.76768 .65073 L
.76695 .65303 L
.76594 .65543 L
.76358 .65959 L
.76009 .66392 L
.7561 .6676 L
.75086 .67124 L
.74437 .6746 L
.73789 .6771 L
.73403 .67829 L
.7302 .67928 L
.72647 .68008 L
.72226 .68082 L
.71842 .68142 L
.72077 .68443 L
.74197 .71191 L
.76705 .74841 L
.77754 .76624 L
.78777 .78625 L
.79532 .80391 L
.80186 .82326 L
.80467 .83423 L
.80661 .84424 L
.80738 .84968 L
.80789 .85455 L
.8081 .85721 L
.80825 .86006 L
.80834 .86273 L
.80836 .86516 L
.80827 .8694 L
.80804 .87328 L
.80761 .87743 L
.80695 .88177 L
.80603 .88615 L
.80495 .89015 L
Mistroke
.80235 .89723 L
.80071 .90064 L
.79873 .90413 L
.79456 .90991 L
.7898 .91481 L
.78483 .91865 L
.7788 .92205 L
.7751 .92362 L
.77147 .92483 L
.76745 .92584 L
.76364 .92652 L
.76147 .9268 L
.75906 .92702 L
.75456 .9272 L
.75055 .92712 L
.74669 .92685 L
.74234 .92634 L
.73755 .92553 L
.73266 .92446 L
.72741 .92305 L
.71776 .91979 L
.69971 .91159 L
.67924 .89926 L
.63284 .85998 L
.61162 .83656 L
.60262 .82548 L
.59795 .81943 L
.59302 .81282 L
.59117 .81375 L
.5924 .82203 L
.59469 .84039 L
.59572 .85087 L
.59652 .86086 L
.59708 .86984 L
.59733 .87489 L
.59752 .87963 L
.59775 .88816 L
.59782 .89269 L
.59784 .89757 L
.59782 .90239 L
.59774 .90746 L
.59747 .91648 L
.59706 .9248 L
.59655 .93248 L
.59584 .94083 L
.5949 .94966 L
.59255 .96654 L
.58931 .98378 L
.58162 1.01268 L
.57635 1.02739 L
Mistroke
.5708 1.04016 L
.56364 1.05374 L
.55621 1.06519 L
.54941 1.07381 L
.54159 1.08189 L
.53409 1.08806 L
.52707 1.09257 L
.52299 1.09467 L
.51853 1.09656 L
.51377 1.09811 L
.51162 1.09866 L
.50925 1.09915 L
.50499 1.09975 L
.50265 1.09993 L
.50047 1.1 L
.49657 1.09988 L
.4924 1.09943 L
.48832 1.09864 L
.48601 1.09805 L
.48385 1.09739 L
.47917 1.09564 L
.47492 1.09364 L
.46738 1.08909 L
.4595 1.08288 L
.45183 1.07521 L
.44389 1.06533 L
.43609 1.05328 L
.42959 1.04099 L
.41913 1.01496 L
.41439 .99914 L
.4106 .98337 L
.40771 .96812 L
.40558 .95361 L
.40383 .93725 L
.40319 .92886 L
.40291 .92436 L
.40266 .91955 L
.40233 .91059 L
.40218 .90224 L
.40216 .8971 L
.40219 .89226 L
.40236 .8832 L
.40269 .87449 L
.40311 .86649 L
.40371 .85772 L
.4045 .84849 L
.40609 .83362 L
.4082 .8179 L
.40937 .80952 L
.40455 .81611 L
Mistroke
.39488 .82863 L
.37271 .85421 L
.3477 .87837 L
.324 .89702 L
.30213 .91061 L
.28266 .91963 L
.27219 .92316 L
.26297 .92543 L
.25794 .9263 L
.25338 .92685 L
.25082 .92705 L
.24853 .92716 L
.24593 .9272 L
.24353 .92716 L
.23927 .92688 L
.23549 .92639 L
.2315 .92561 L
.22745 .9245 L
.22373 .92316 L
.2205 .92172 L
.21382 .91771 L
.20838 .91311 L
.20392 .908 L
.19959 .90121 L
.19642 .89418 L
.19508 .89025 L
.19386 .88571 L
.19335 .88336 L
.19288 .88077 L
.19251 .87831 L
.19221 .87595 L
.19184 .87159 L
.19167 .86754 L
.19166 .86307 L
.19173 .86051 L
.19185 .85812 L
.19215 .85409 L
.19263 .84959 L
.1933 .84482 L
.19408 .8403 L
.19639 .82975 L
.19912 .81996 L
.20717 .79772 L
.22921 .75452 L
.25368 .71781 L
.26532 .70227 L
.27559 .68907 L
.27819 .68575 L
.27958 .68398 L
.28085 .68236 L
Mistroke
.28071 .68124 L
.27836 .68091 L
.27435 .68024 L
.26766 .67875 L
.26105 .67674 L
.25537 .67449 L
.24984 .67166 L
.24526 .66864 L
.24159 .66559 L
.23854 .66239 L
.23616 .6592 L
.23419 .65571 L
.23334 .65379 L
.2326 .65168 L
.232 .64948 L
.23161 .64745 L
.23133 .64507 L
.23123 .64279 L
.23128 .64066 L
.23145 .63868 L
.23176 .6365 L
.23223 .63418 L
.23286 .63183 L
.23368 .6293 L
.23557 .62475 L
.24154 .61451 L
.24969 .60436 L
.25426 .59959 L
.25871 .59532 L
.26084 .59338 L
.26286 .59158 L
.26229 .58973 L
.25997 .58766 L
.25103 .5789 L
.24342 .5699 L
.23767 .56116 L
.23538 .55668 L
.23345 .55186 L
.23261 .54911 L
.23199 .54652 L
.23158 .5442 L
.23142 .5429 L
.23132 .54171 L
.23123 .53974 L
.23127 .53764 L
.23143 .53568 L
.23168 .53391 L
.23211 .53187 L
.23274 .52968 L
.2335 .52765 L
Mistroke
.23434 .5258 L
.23665 .5219 L
.2393 .51855 L
.24303 .51495 L
.24717 .51183 L
.25163 .50916 L
.257 .50663 L
.26354 .50425 L
.27025 .50244 L
.27408 .50163 L
.27616 .50126 L
.27841 .5009 L
.28041 .50061 L
.28099 .49964 L
.27846 .49641 L
.26788 .48287 L
.22443 .41909 L
.21411 .3995 L
.20485 .37836 L
.19863 .36023 L
.1959 .35008 L
.19394 .34077 L
.1931 .33564 L
.19273 .33297 L
.19239 .33017 L
.19215 .32773 L
.19194 .32508 L
.1917 .32048 L
.19164 .31609 L
.19177 .31148 L
.19207 .30724 L
.19251 .30346 L
.19285 .30124 L
.19326 .29891 L
.19417 .29484 L
.19552 .2902 L
.19698 .28619 L
.20056 .27886 L
.20477 .27272 L
.20951 .26764 L
.21455 .26359 L
.22077 .25997 L
.22456 .25833 L
.22818 .2571 L
.23217 .25606 L
.236 .25535 L
.23807 .25507 L
.24039 .25484 L
.24286 .25469 L
.24522 .25462 L
Mistroke
.24967 .25471 L
.25386 .25502 L
.25621 .25528 L
.25883 .25565 L
.26369 .25653 L
.27331 .25899 L
.28238 .26208 L
.3036 .27201 L
.32402 .28481 L
.34355 .29989 L
.3868 .34338 L
.39681 .35562 L
.4022 .36259 L
.40722 .36933 L
.40942 .37174 L
.40861 .3666 L
.40729 .35752 L
.40511 .33952 L
.40371 .32411 L
.40311 .3153 L
.40267 .307 L
.40236 .29831 L
.4022 .29033 L
.40217 .28161 L
.4023 .27245 L
.40254 .26511 L
.40292 .25731 L
.4034 .25 L
.40394 .24341 L
.40567 .2275 L
.40785 .21287 L
.41072 .19787 L
.41394 .18436 L
.4184 .16907 L
.42307 .15592 L
.43421 .13186 L
.4412 .12036 L
.44833 .1107 L
.45475 .10348 L
.46189 .09689 L
.46827 .09212 L
.47535 .08796 L
.47977 .08593 L
.48388 .08442 L
.48783 .08329 L
.49203 .08245 L
.49582 .08199 L
.49935 .08182 L
.50323 .08192 L
.50738 .08236 L
Mistroke
.51146 .08313 L
.51377 .08371 L
.51594 .08436 L
.52063 .08609 L
.52488 .08807 L
.53243 .09259 L
.54031 .09877 L
.54799 .10641 L
.55594 .11626 L
.56376 .12828 L
.57027 .14054 L
.58076 .16654 L
.58552 .18234 L
.58932 .19809 L
.59223 .21333 L
.59437 .22784 L
.59613 .24419 L
.59678 .25257 L
.59707 .25706 L
.59732 .26187 L
.59765 .27083 L
.59781 .27919 L
.59784 .28433 L
.59782 .28917 L
.59765 .29823 L
.59733 .30695 L
.59691 .31495 L
.59632 .32373 L
.59554 .33295 L
.59383 .34889 L
.59185 .36356 L
.59056 .37189 L
.59456 .36691 L
.6049 .35346 L
.62707 .32784 L
.65207 .30364 L
.67578 .28495 L
.69765 .27133 L
.71714 .26227 L
.72763 .25871 L
.73685 .25643 L
.74189 .25554 L
.74645 .25499 L
.74902 .25478 L
.75131 .25467 L
.75391 .25462 L
.75631 .25466 L
.76058 .25493 L
.76437 .25541 L
.76837 .25618 L
Mistroke
.77242 .25728 L
.77615 .25861 L
.77938 .26005 L
.78608 .26403 L
.79153 .26862 L
.79601 .27372 L
.80035 .2805 L
.80354 .28752 L
.80488 .29144 L
.8061 .29597 L
.80662 .29832 L
.8071 .30091 L
.80748 .30337 L
.80777 .30572 L
.80815 .31008 L
.80833 .31413 L
.80835 .3186 L
.80828 .32116 L
.80816 .32354 L
.80786 .32758 L
.80739 .33208 L
.80672 .33685 L
.80595 .34137 L
.80365 .35192 L
.80093 .36171 L
.7929 .38395 L
.77087 .42716 L
.7464 .4639 L
.73475 .47945 L
.72448 .49266 L
.72187 .49599 L
.72048 .49776 L
.71921 .49938 L
.7192 .50056 L
.72155 .50089 L
.72557 .50157 L
.73226 .50305 L
.73888 .50505 L
.74457 .5073 L
.7501 .51013 L
.7547 .51314 L
.75837 .51619 L
.76143 .51939 L
.76381 .52258 L
.76579 .52607 L
.76664 .52798 L
.76739 .53009 L
.7679 .5319 L
.76825 .53356 L
.76855 .53551 L
Mistroke
.76872 .53737 L
.76877 .53911 L
.76874 .54073 L
.76862 .54251 L
.76839 .54441 L
.76805 .54633 L
.76758 .5484 L
.76644 .55215 L
.76464 .55662 L
.7626 .56067 L
.75756 .56858 L
.75081 .5769 L
.73636 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`03001Vo`3oool0oooo0;@0oooo002d0?ooo`@006Ko]@3o
ool00:h0oooo4000I_n_0?ooo`00[@3oool8001Vo`030?ooo`00000006Ko00P006Ko[@3oool00:X0
oooo1@00I_l70?ooo`030000003oool0oooo00@0oooo1P00I_nZ0?ooo`00Z@3oool5001Vo`P0oooo
0P0000070?ooo`@006KoZP3oool00:P0oooo0`00I_l;0?ooo`030000003oool0oooo00T0oooo0P00
I_nY0?ooo`00YP3oool4001Vo``0oooo00<000000?ooo`3oool02P3oool2001VojP0oooo002U0?oo
o`@006Ko3@3oool00`000000oooo0?ooo`0;0?ooo`8006KoY`3oool00:D0oooo0P00I_l?0?ooo`03
0000003oool0oooo00/0oooo1000I_nU0?ooo`00Y03oool2001Voa00oooo00<000000?ooo`3oool0
303oool3001VojD0oooo002S0?ooo`8006Ko4@3oool00`000000oooo0?ooo`0>0?ooo`8006KoY03o
ool00:<0oooo00<006Ko0?ooo`3oool0403oool00`000000oooo0?ooo`0?0?ooo`8006KoX`3oool0
0:80oooo0P00I_lB0?ooo`030000003oool0oooo0100oooo0P00I_nR0?ooo`00X@3oool2001Voa<0
oooo00<000000?ooo`3oool04@3oool00`00I_l0oooo0?ooo`2P0?ooo`00X03oool2001Voa@0oooo
00<000000?ooo`3oool04@3oool2001Voj40oooo002P0?ooo`03001Vo`3oool0oooo01<0oooo00<0
00000?ooo`3oool04P3oool2001Voj00oooo002O0?ooo`8006Ko5@3oool00`000000oooo0?ooo`0C
0?ooo`8006KoW`3oool009l0oooo00<006Ko0?ooo`3oool01`3oool00`3oe9/00000000000030000
0003002Ke03oool0oooo00@0oooo00<000000?ooo`3oool0503oool00`00I_l0oooo0?ooo`2M0?oo
o`00WP3oool2001Vo``0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`80
06KoWP3oool009h0oooo00<006Ko0?ooo`3oool02`3oool00`2jLW80^^[o0?ooo`070?ooo`030000
003oool0oooo01@0oooo0P00I_nN0?ooo`00W@3oool2001Vo`d0oooo00<0^W9b0;[Zo`3oool01`3o
ool3000001@0oooo0`00I_nM0?ooo`00W@3oool01000I_l0oooo0?ooo`2jLP0500000003001b^P3o
ool0oooo00<0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0E0?ooo`8006KoW@3o
ool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2
001Void0oooo002L0?ooo`03001Vo`3oool0oooo00d0oooo00<0^W9b0;[Zo`3oool01`3oool00`00
0000oooo0?ooo`0F0?ooo`8006KoW03oool009`0oooo00<006Ko0?ooo`3oool02P3oool01@3Z^W80
0000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool05`3oool00`00I_l0oooo0?ooo`2J0?oo
o`00V`3oool2001Vo`h0oooo00<0j[Yb0000LP2jj_l0203oool00`000000oooo0?ooo`0G0?ooo`80
06KoV`3oool009/0oooo00<006Ko0?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03001V
o`3oool0oooo09T0oooo002J0?ooo`8006Ko6P3oool00`000000oooo0?ooo`0H0?ooo`03001Vo`3o
ool0oooo09T0oooo002J0?ooo`03001Vo`3oool0oooo01T0oooo00<000000?ooo`3oool0603oool2
001VoiX0oooo002I0?ooo`8006Ko6`3oool00`000000oooo0?ooo`0I0?ooo`03001Vo`3oool0oooo
09P0oooo002I0?ooo`03001Vo`3oool0oooo01X0oooo00<000000?ooo`3oool06@3oool2001VoiT0
oooo002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0J0?ooo`03001Vo`3oool0oooo09L0oooo
002H0?ooo`03001Vo`3oool0oooo01/0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo002G
0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0J0?ooo`8006KoV03oool009L0oooo0P00I_lM0?oo
o`030000003oool0oooo01X0oooo0`00I_nG0?ooo`00UP3oool3001Voad0oooo00<000000?ooo`3o
ool06`3oool2001VoiL0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0K0?ooo`8006Ko
U`3oool009H0oooo0P00I_lN0?ooo`800000703oool2001VoiL0oooo002E0?ooo`<006Ko7P3oool0
0`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo
01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703oool2001VoiH0
oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009D0oooo0P00
I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U03oool2001Vob00oooo00<00000
0?ooo`3oool0703oool2001VoiH0oooo002D0?ooo`8006Ko803oool00`000000oooo0?ooo`0M0?oo
o`8006KoU@3oool009@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_nE0?ooo`00
U03oool2001Vob00oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo002D0?ooo`8006Ko803o
ool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009<0oooo0P00I_lQ0?ooo`030000003oool0
oooo01d0oooo0P00I_nE0?ooo`00T`3oool2001Vob40oooo00<000000?ooo`3oool07P3oool2001V
oi@0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0N0?ooo`8006KoU03oool009<0oooo
0P00I_lQ0?ooo`030000003oool0oooo01h0oooo0P00I_nD0?ooo`00T`3oool2001Vob40oooo00<0
00000?ooo`3oool07P3oool2001Voi@0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0N
0?ooo`8006KoU03oool00980oooo0P00I_lR0?ooo`8000007`3oool2001Voi@0oooo002B0?ooo`80
06Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool00980oooo0P00I_lR0?ooo`030000
003oool0oooo01l0oooo0P00I_nC0?ooo`00TP3oool2001Vob80oooo00<000000?ooo`3oool07`3o
ool2001Voi<0oooo002B0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool0
0980oooo0P00I_lR0?ooo`030000003oool0oooo01l0oooo0P00I_nC0?ooo`00TP3oool2001Vob80
oooo00<000000?ooo`3oool07`3oool2001Voi<0oooo002B0?ooo`8006Ko8P3oool00`000000oooo
0?ooo`0O0?ooo`8006KoT`3oool005T0oooo00<006Ko0?ooo`3oool0=P3oool2001Vob80oooo00<0
00000?ooo`3oool07`3oool2001Voi<0oooo001H0?ooo`@006Ko=P3oool2001Vob80oooo00<00000
0?ooo`3oool07`3oool2001VocL0oooo1@00I_mG0?ooo`00D@3ooolC001Vobh0oooo00<006Ko0?oo
o`3oool08@3oool00`000000oooo0?ooo`0O0?ooo`8006Ko;`3ooolB001Voe80oooo001?0?ooo`X0
06Ko0P3oool<001VobX0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_l[0?ooo`d0
06Ko0`3oool9001Vodl0oooo001>0?ooo`@006Ko4@3oool6001VobP0oooo0P00I_lS0?ooo`030000
003oool0oooo01l0oooo0P00I_lY0?ooo`H006Ko4@3oool5001Vodh0oooo001<0?ooo`@006Ko5P3o
ool5001VobH0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_lW0?ooo`D006Ko5`3o
ool3001Vodd0oooo001;0?ooo`@006Ko6@3oool5001Vob@0oooo0P00I_lS0?ooo`030000003oool0
oooo01l0oooo0P00I_lV0?ooo`@006Ko6P3oool3001Vod`0oooo001:0?ooo`<006Ko7@3oool5001V
ob80oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_lT0?ooo`@006Ko7@3oool4001V
odX0oooo001:0?ooo`8006Ko803oool5001Vob00oooo0P00I_lS0?ooo`800000803oool2001Vob80
oooo1@00I_lO0?ooo`@006KoB@3oool004T0oooo0P00I_lS0?ooo`D006Ko7P3oool2001Vob<0oooo
00<000000?ooo`3oool07`3oool2001Vob40oooo1000I_lS0?ooo`8006KoB@3oool004T0oooo00<0
06Ko0?ooo`3oool0903oool5001Voa`0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00
I_lO0?ooo`@006Ko9@3oool2001VodT0oooo00180?ooo`8006Ko:03oool5001VoaX0oooo0P00I_lS
0?ooo`030000003oool0oooo01l0oooo0P00I_lN0?ooo`@006Ko9`3oool00`00I_l0oooo0?ooo`17
0?ooo`00A`3oool2001Vob/0oooo1000I_lI0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?oo
o`8006Ko703oool4001VobT0oooo0P00I_m80?ooo`00A`3oool00`00I_l0oooo0?ooo`0/0?ooo`<0
06Ko603oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001VoaX0oooo1@00I_l[0?ooo`03
001Vo`3oool0oooo04H0oooo00160?ooo`8006Ko;`3oool3001VoaL0oooo0P00I_lS0?ooo`030000
003oool0oooo01l0oooo0P00I_lI0?ooo`@006Ko;@3oool2001VodL0oooo00160?ooo`8006Ko<03o
ool4001VoaD0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_lG0?ooo`@006Ko<03o
ool00`00I_l0oooo0?ooo`150?ooo`00AP3oool00`00I_l0oooo0?ooo`0`0?ooo`@006Ko503oool2
001Vob<0oooo00<000000?ooo`3oool07`3oool2001VoaH0oooo1000I_l`0?ooo`8006KoA`3oool0
04D0oooo0P00I_ld0?ooo`<006Ko4`3oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001V
oa@0oooo1000I_lb0?ooo`<006KoAP3oool004D0oooo0P00I_le0?ooo`<006Ko4P3oool2001Vob<0
oooo00<000000?ooo`3oool07`3oool2001Voa<0oooo1000I_lc0?ooo`<006KoAP3oool004D0oooo
0P00I_lf0?ooo`<006Ko4@3oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001Voa80oooo
0`00I_lf0?ooo`8006KoAP3oool004D0oooo0P00I_lg0?ooo`<006Ko403oool2001Vob<0oooo00<0
00000?ooo`3oool07`3oool2001Voa40oooo0`00I_lg0?ooo`8006KoAP3oool004D0oooo0P00I_lh
0?ooo`<006Ko3`3oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001Voa00oooo0`00I_lh
0?ooo`8006KoAP3oool004@0oooo0`00I_li0?ooo`<006Ko3P3oool2001Vob<0oooo00<000000?oo
o`3oool07`3oool2001Vo`l0oooo0`00I_li0?ooo`8006KoAP3oool004@0oooo0P00I_lk0?ooo`<0
06Ko3@3oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001Vo`h0oooo0`00I_lj0?ooo`80
06KoAP3oool004@0oooo0P00I_ll0?ooo`<006Ko303oool3001Vob80oooo00<000000?ooo`3oool0
7`3oool2001Vo`d0oooo0`00I_lk0?ooo`8006KoAP3oool004@0oooo0P00I_lm0?ooo`8006Ko3@3o
ool2001Vob80oooo0P00000P0?ooo`8006Ko303oool3001Voc`0oooo0P00I_m60?ooo`00A03oool2
001Voch0oooo0P00I_l<0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006Ko2`3oool3
001Vocd0oooo0P00I_m60?ooo`00A03oool3001Vocd0oooo0`00I_l;0?ooo`8006Ko8P3oool00`00
0000oooo0?ooo`0O0?ooo`8006Ko2P3oool3001Voch0oooo0P00I_m60?ooo`00A@3oool2001Voch0
oooo0`00I_l:0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006Ko2@3oool3001Vocl0
oooo0P00I_m60?ooo`00A@3oool2001Vocl0oooo0`00I_l90?ooo`8006Ko8P3oool00`000000oooo
0?ooo`0O0?ooo`8006Ko203oool3001Vod00oooo0P00I_m60?ooo`00A@3oool2001Vod00oooo0`00
I_l80?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006Ko203oool2001Vod40oooo0P00
I_m60?ooo`00A@3oool2001Vod40oooo0`00I_l70?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O
0?ooo`8006Ko1`3oool2001Vod80oooo0P00I_m60?ooo`00A@3oool2001Vod80oooo0`00I_l60?oo
o`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006Ko1P3oool3001Vod80oooo0P00I_m60?oo
o`00A@3oool3001Vod80oooo0`00I_l60?ooo`8006Ko8@3oool00`000000oooo0?ooo`0O0?ooo`80
06Ko1@3oool3001Vod<0oooo00<006Ko0?ooo`3oool0A@3oool004H0oooo0P00I_m30?ooo`<006Ko
1@3oool2001Vob40oooo00<000000?ooo`3oool07`3oool2001Vo`@0oooo0`00I_m30?ooo`8006Ko
A`3oool004H0oooo0P00I_m40?ooo`<006Ko103oool2001Vob40oooo00<000000?ooo`3oool07`3o
ool2001Vo`@0oooo0P00I_m40?ooo`8006KoA`3oool004H0oooo0`00I_m40?ooo`<006Ko0`3oool2
001Vob40oooo00<000000?ooo`3oool07P3oool2001Vo`@0oooo0P00I_m50?ooo`8006KoA`3oool0
04L0oooo0P00I_m50?ooo`<006Ko0P3oool2001Vob40oooo00<000000?ooo`3oool07P3oool2001V
o`<0oooo0`00I_m40?ooo`<006KoA`3oool004L0oooo0P00I_m60?ooo`8006Ko0P3oool2001Vo`<0
oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/00000
00000000000009_Do`070?ooo`030000003oool0oooo01h0oooo0P00I_l20?ooo`<006KoA@3oool2
001VodP0oooo00170?ooo`8006KoA`3oool2001Vo`030?ooo`00I_l006Ko00<0oooo00H0^W:K0=Co
o`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo
0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool07P3oool2001Vo`040?ooo`00I_l006Ko001V
odH0oooo0P00I_m80?ooo`00A`3oool3001VodL0oooo1000I_l20?ooo`030?oDV`00Vm@0oooo0080
oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo01h0
oooo1@00I_m70?ooo`8006KoB03oool004P0oooo0P00I_m80?ooo`<006Ko0P3oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool3000001d0oooo
1@00I_m70?ooo`<006KoB03oool004P0oooo0P00I_m40?ooo`040;Yb000000000000000000<006Ko
0P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0
1@3oool00`000000oooo0?ooo`0M0?ooo`@006KoB03oool2001VodT0oooo00180?ooo`8006KoB@3o
ool3001Vo`030?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`000000
00020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool07@3oool3001VodT0oooo0P00
I_m90?ooo`00B03oool3001VodT0oooo0P00I_l00`3oool0omBK07:jjP030?ooo`030>ZjLP1b^^X0
oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`0M0?ooo`8006KoBP3oool2
001VodT0oooo00190?ooo`8006KoBP3oool2001Vo`070?ooo`2jLP00VmCo0?ooo`3oj[X0LP2K0=Co
o`0;0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool07@3oool2001VodT0oooo0`00
I_m90?ooo`00B@3oool2001Vod/0oooo00L006Ko0?ooo`3oom@0V`00000000000780^^[o00`0oooo
00<0oooD09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo01d0oooo
00<006Ko0?ooo`3oool0B03oool2001VodX0oooo001:0?ooo`03001Vo`3oool0oooo04X0oooo00<0
06Ko0?ooo`3oool0703oool00`000000oooo0?ooo`0M0?ooo`03001Vo`3oool0oooo04P0oooo0P00
I_m:0?ooo`00BP3oool2001VofX0oooo00<000000?ooo`3oool0J03oool2001VodX0oooo001;0?oo
o`03001Vo`3oool0oooo06P0oooo00<000000?ooo`3oool0J03oool00`00I_l0oooo0?ooo`190?oo
o`00B`3oool2001VofT0oooo00<000000?ooo`3oool0I`3oool2001Vod/0oooo001<0?ooo`8006Ko
J03oool00`000000oooo0?ooo`1V0?ooo`8006KoC03oool004d0oooo00<006Ko0?ooo`3oool0IP3o
ool00`000000oooo0?ooo`1V0?ooo`03001Vo`3oool0oooo04/0oooo001=0?ooo`8006KoI`3oool0
0`000000oooo0?ooo`1U0?ooo`8006KoC@3oool004h0oooo00<006Ko0?ooo`3oool0I@3oool00`00
0000oooo0?ooo`1U0?ooo`03001Vo`3oool0oooo04`0oooo001>0?ooo`8006KoIP3oool00`000000
oooo0?ooo`1T0?ooo`8006KoCP3oool004h0oooo0P00I_mV0?ooo`030000003oool0oooo06<0oooo
0P00I_m?0?ooo`00C`3oool2001VofD0oooo00<000000?ooo`3oool0H`3oool00`00I_l0oooo0?oo
o`1>0?ooo`00C`3oool2001VofD0oooo0P00001S0?ooo`8006KoD03oool004l0oooo0`00I_mT0?oo
o`030000003oool0oooo0680oooo00<006Ko0?ooo`3oool0C`3oool00500oooo0P00I_mT0?ooo`03
0000003oool0oooo0640oooo0P00I_mA0?ooo`00D@3oool00`00I_l0oooo0?ooo`1R0?ooo`030000
003oool0oooo0600oooo0P00I_mB0?ooo`00D@3oool2001Vof<0oooo00<000000?ooo`3oool0H03o
ool00`00I_l0oooo0?ooo`1A0?ooo`00DP3oool2001Vof80oooo00<000000?ooo`3oool0G`3oool2
001Voe<0oooo001C0?ooo`03001Vo`3oool0oooo0600oooo00<000000?ooo`3oool0G`3oool00`00
I_l0oooo0?ooo`1B0?ooo`00D`3oool2001Vof40oooo00<000000?ooo`3oool0GP3oool2001Voe@0
oooo001D0?ooo`8006KoH03oool00`000000oooo0?ooo`1N0?ooo`03001Vo`3oool0oooo05<0oooo
001E0?ooo`03001Vo`3oool0oooo05h0oooo00<000000?ooo`3oool0G@3oool2001VoeD0oooo001E
0?ooo`8006KoG`3oool00`000000oooo0?ooo`1L0?ooo`8006KoEP3oool005H0oooo0P00I_mN0?oo
o`030000003oool0oooo05`0oooo00<006Ko0?ooo`3oool0E@3oool005L0oooo00<006Ko0?ooo`3o
ool0G03oool00`000000oooo0?ooo`1K0?ooo`8006KoE`3oool005L0oooo0P00I_mM0?ooo`030000
003oool0oooo05/0oooo00<006Ko0?ooo`3oool0EP3oool005P0oooo0P00I_mL0?ooo`030000003o
ool0oooo05X0oooo0P00I_mH0?ooo`00F@3oool00`00I_l0oooo0?ooo`1J0?ooo`030000003oool0
oooo05X0oooo00<006Ko0?ooo`3oool0E`3oool005T0oooo0P00I_mK0?ooo`800000FP3oool2001V
oeT0oooo001J0?ooo`8006KoFP3oool00`000000oooo0?ooo`1H0?ooo`8006KoFP3oool005/0oooo
00<006Ko0?ooo`3oool0F03oool00`000000oooo0?ooo`1H0?ooo`03001Vo`3oool0oooo05T0oooo
001K0?ooo`8006KoF@3oool00`000000oooo0?ooo`1G0?ooo`8006KoF`3oool005`0oooo0P00I_mH
0?ooo`030000003oool0oooo05H0oooo0P00I_mL0?ooo`00G@3oool00`00I_l0oooo0?ooo`1F0?oo
o`030000003oool0oooo05D0oooo0`00I_mL0?ooo`00G@3oool2001VoeL0oooo00<000000?ooo`3o
ool0E03oool3001Voed0oooo001N0?ooo`8006KoEP3oool00`000000oooo0?ooo`1C0?ooo`<006Ko
GP3oool005l0oooo00<006Ko0?ooo`3oool0E03oool00`000000oooo0?ooo`1B0?ooo`<006KoG`3o
ool005l0oooo0P00I_mE0?ooo`030000003oool0oooo0580oooo0P00I_mP0?ooo`00H03oool2001V
oe@0oooo00<000000?ooo`3oool0D@3oool2001Vof40oooo001Q0?ooo`8006KoD`3oool00`000000
oooo0?ooo`1@0?ooo`8006KoHP3oool00640oooo0`00I_mB0?ooo`030000003oool0oooo0500oooo
00<006Ko0?ooo`3oool0H@3oool00680oooo0P00I_mB0?ooo`030000003oool0oooo04l0oooo0P00
I_mS0?ooo`00H`3oool2001Voe40oooo00<000000?ooo`3oool0CP3oool2001Vof@0oooo001S0?oo
o`<006KoD03oool00`000000oooo0?ooo`1=0?ooo`<006KoI03oool006@0oooo0`00I_m?0?ooo`03
0000003oool0oooo04`0oooo0`00I_mU0?ooo`00H`3oool5001Vodh0oooo0P00001=0?ooo`H006Ko
HP3oool005d0oooo3000I_m=0?ooo`030000003oool0oooo04`0oooo2@00I_mO0?ooo`00F`3oool9
001Voe80oooo00<000000?ooo`3oool0D@3oool6001Voed0oooo001J0?ooo`@006KoF03oool00`00
0000oooo0?ooo`1D0?ooo`D006KoF`3oool005P0oooo1000I_mJ0?ooo`030000003oool0oooo05H0
oooo1@00I_mI0?ooo`00F03oool3001Voe/0oooo00<000000?ooo`3oool0F03oool4001VoeP0oooo
001G0?ooo`8006KoG@3oool00`000000oooo0?ooo`1J0?ooo`<006KoE`3oool005H0oooo0P00I_mN
0?ooo`030000003oool0oooo05/0oooo0`00I_mF0?ooo`00E@3oool3001Voeh0oooo00<000000?oo
o`3oool0G03oool3001VoeD0oooo001D0?ooo`<006KoG`3oool00`000000oooo0?ooo`1M0?ooo`80
06KoE@3oool005@0oooo0`00I_mO0?ooo`030000003oool0oooo05d0oooo0P00I_mE0?ooo`00D`3o
ool3001Vof00oooo00<000000?ooo`3oool0G@3oool2001VoeD0oooo001C0?ooo`8006KoH@3oool0
0`000000oooo0?ooo`1M0?ooo`<006KoE03oool005<0oooo0P00I_mQ0?ooo`030000003oool0oooo
05d0oooo0`00I_mD0?ooo`00D`3oool2001Vof40oooo00<000000?ooo`3oool0GP3oool2001Voe@0
oooo001C0?ooo`8006KoH@3oool00`000000oooo0?ooo`1N0?ooo`8006KoE03oool005<0oooo0P00
I_mQ0?ooo`800000G`3oool2001Voe@0oooo000A0?ooo`030?oDV`000000000000<0000000<009_D
0?ooo`3oool0>@3oool2001Vo`L0oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000
000009_D00D0oooo00D0e9/0000000000000000009_Do`130?ooo`030000003oool0oooo04@0oooo
00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/000000000
0000000009_Do`020?ooo`<006Ko?`3oool00`3oe9/000000000000300000003002Ke03oool0oooo
00`0oooo000D0?ooo`030;YbLP2jj_l0oooo03`0oooo0`00I_l60?ooo`060;YbV`3Dool0oooo0?oo
e02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP00
09_Do`120?ooo`030000003oool0oooo04@0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?oo
o`030=BK0000000009_D00@0oooo00P0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo0?ooo`8006Ko
@`3oool00`2jLW80^^[o0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`0m0?ooo`8006Ko1@3o
ool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0@@3o
ool00`000000oooo0?ooo`130?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3o
ool00`3oe9/009_D0?ooo`02001Vod<0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b
0;[Zo`3oool0?@3oool2001Vo`D0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?
0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`02
0?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool00P00I_m30?ooo`030;YbLP2jj_l0
oooo00l0oooo00080?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2j
LW80^^[o0?ooo`0k0?ooo`030;Yb0000000006Ko008006Ko00H00000001b^P3oool0oooo0>ZjLP1b
^^X30?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0@@3oool00`000000oooo0?oo
o`130?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool0102jLP00VmCo001V
o`00I_m40?ooo`030;YbLP2jj_l0oooo00l0oooo000D0?ooo`030;YbLP2jj_l0oooo03h0oooo0P00
I_l40?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`000000
00020000000307:jjP3oool0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?oo
o`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P000000101b^^X006Ko001V
o`00I_m40?ooo`030;YbLP2jj_l0oooo00l0oooo000D0?ooo`030;YbLP2jj_l0oooo03l0oooo0P00
I_l30?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Co
o`160?ooo`030000003oool0oooo04<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?oo
o`0:0?ooo`030?ooe02K09/0e?oo00<0oooo0P00I_m50?ooo`030;YbLP2jj_l0oooo00l0oooo000A
0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0@@3oool2001Vo`<0oooo00H0^W8009_Do`3oool0onZj
0780V`3Dool;0?ooo`030?ooe02K09/0e?oo04H0oooo00<000000?ooo`3oool0A03oool01P2jLP00
VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool00`3oool2001Vod80oooo00D0j[Yb
00000000L[X0^W9b0;[Zo`0@0?ooo`004`3oool00`3Z^W80001b0;[Zo`120?ooo`09001Vo`3oool0
oooo0?ooo`3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0
e?oo0?ooo`110?ooo`030000003oool0oooo04@0oooo00D0oooD09/000000000001b0;[Zo`0<0?oo
o`030?ooe02K00000000008000000`00I_m40?ooo`030>ZjLP000780^^[o0100oooo001H0?ooo`80
06KoG03oool00`000000oooo0?ooo`1I0?ooo`<006KoF03oool005T0oooo0P00I_mK0?ooo`030000
003oool0oooo05P0oooo0`00I_mI0?ooo`00FP3oool2001VoeX0oooo00<000000?ooo`3oool0E`3o
ool3001VoeX0oooo001K0?ooo`8006KoF@3oool00`000000oooo0?ooo`1F0?ooo`<006KoF`3oool0
05/0oooo0`00I_mH0?ooo`030000003oool0oooo05D0oooo0`00I_mL0?ooo`00G03oool3001VoeL0
oooo00<000000?ooo`3oool0E03oool3001Voed0oooo001M0?ooo`<006KoEP3oool00`000000oooo
0?ooo`1C0?ooo`<006KoGP3oool005h000000P00I_n[000000<006KoG`00000000030000003oool0
oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`090?ooo`8006Ko0`3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00<006Ko2P3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo0@0000000100oooo00<000000?ooo`3oool0B@3oool4001V
o`<0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1@0?ooo`040000003oool0oooo
0?ooo`<006KoB`3oool00`000000oooo0?ooo`0?0?ooo`00G03oool3001VoeL0oooo00<000000?oo
o`3oool0E@3oool3001Voe`0oooo001K0?ooo`8006KoF@3oool00`000000oooo0?ooo`1F0?ooo`<0
06KoF`3oool005/0oooo00<006Ko0?ooo`3oool0F03oool00`000000oooo0?ooo`1G0?ooo`8006Ko
F`3oool005X0oooo0P00I_mJ0?ooo`030000003oool0oooo05P0oooo0P00I_mJ0?ooo`00F@3oool2
001Voe/0oooo00<000000?ooo`3oool0F@3oool2001VoeT0oooo001H0?ooo`8006KoG03oool00`00
0000oooo0?ooo`1J0?ooo`8006KoF03oool005L0oooo0P00I_mM0?ooo`030000003oool0oooo05/0
oooo00<006Ko0?ooo`3oool0EP3oool005H0oooo0`00I_mM0?ooo`030000003oool0oooo05/0oooo
0P00I_mG0?ooo`00E@3oool3001Voeh0oooo00<000000?ooo`3oool0G03oool2001VoeH0oooo001D
0?ooo`<006KoG`3oool00`000000oooo0?ooo`1M0?ooo`03001Vo`3oool0oooo05@0oooo001D0?oo
o`8006KoH03oool00`000000oooo0?ooo`1M0?ooo`8006KoE@3oool005@0oooo0P00I_mP0?ooo`03
0000003oool0oooo05h0oooo00<006Ko0?ooo`3oool0D`3oool005<0oooo0`00I_mP0?ooo`030000
003oool0oooo05d0oooo0P00I_mE0?ooo`00D`3oool2001Vof40oooo00<000000?ooo`3oool0G@3o
ool3001Voe@0oooo001C0?ooo`8006KoH@3oool2000005l0oooo0P00I_mD0?ooo`00D`3oool2001V
of40oooo00<000000?ooo`3oool0GP3oool2001Voe@0oooo001C0?ooo`8006KoH@3oool00`000000
oooo0?ooo`1N0?ooo`8006KoE03oool005<0oooo0P00I_mQ0?ooo`030000003oool0oooo05h0oooo
0P00I_mD0?ooo`00D`3oool2001Vof40oooo00<000000?ooo`3oool0GP3oool2001Voe@0oooo001C
0?ooo`<006KoH03oool00`000000oooo0?ooo`1M0?ooo`<006KoE03oool005@0oooo0P00I_mP0?oo
o`030000003oool0oooo05d0oooo0P00I_mE0?ooo`00E03oool3001Voel0oooo00<000000?ooo`3o
ool0G@3oool2001VoeD0oooo001E0?ooo`8006KoG`3oool00`000000oooo0?ooo`1M0?ooo`8006Ko
E@3oool005D0oooo1000I_mM0?ooo`030000003oool0oooo05`0oooo0P00I_mF0?ooo`00EP3oool4
001Voe`0oooo00<000000?ooo`3oool0FP3oool3001VoeL0oooo001H0?ooo`@006KoFP3oool00`00
0000oooo0?ooo`1H0?ooo`D006KoE`3oool005T0oooo1000I_mI0?ooo`030000003oool0oooo05L0
oooo1000I_mI0?ooo`00F`3oool3001VoeP0oooo00<000000?ooo`3oool0EP3oool3001Voe/0oooo
001L0?ooo`H006KoE03oool00`000000oooo0?ooo`1B0?ooo`H006KoG03oool005d0oooo2000I_l0
0`3oool006Ko0?ooo`1>0?ooo`030000003oool0oooo04l0oooo2000I_mM0?ooo`00H@3oool7001V
odh0oooo0P00001<0?ooo`P006KoH@3oool006@0oooo0`00I_m?0?ooo`030000003oool0oooo04`0
oooo1000I_mT0?ooo`00I03oool2001Voe00oooo00<000000?ooo`3oool0C@3oool3001Vof@0oooo
001S0?ooo`<006KoD03oool00`000000oooo0?ooo`1>0?ooo`8006KoI03oool00680oooo0`00I_mA
0?ooo`030000003oool0oooo04l0oooo0P00I_mS0?ooo`00HP3oool2001Voe80oooo00<000000?oo
o`3oool0C`3oool3001Vof80oooo001Q0?ooo`8006KoD`3oool00`000000oooo0?ooo`1@0?ooo`<0
06KoH@3oool00600oooo0`00I_mC0?ooo`030000003oool0oooo0540oooo0`00I_mP0?ooo`00G`3o
ool3001Voe@0oooo00<000000?ooo`3oool0DP3oool2001Vof00oooo001N0?ooo`<006KoE@3oool0
0`000000oooo0?ooo`1C0?ooo`8006KoG`3oool005h0oooo0P00I_mF0?ooo`030000003oool0oooo
05<0oooo0`00I_mN0?ooo`00G@3oool2001VoeL0oooo00<000000?ooo`3oool0E03oool2001Voeh0
oooo001L0?ooo`<006KoE`3oool00`000000oooo0?ooo`1E0?ooo`8006KoG@3oool005`0oooo0P00
I_mH0?ooo`030000003oool0oooo05H0oooo0P00I_mL0?ooo`00F`3oool2001VoeT0oooo00<00000
0?ooo`3oool0E`3oool00`00I_l0oooo0?ooo`1J0?ooo`00FP3oool2001VoeX0oooo00<000000?oo
o`3oool0E`3oool2001Voe/0oooo001J0?ooo`03001Vo`3oool0oooo05T0oooo00<000000?ooo`3o
ool0F03oool2001VoeX0oooo001I0?ooo`8006KoF`3oool2000005X0oooo00<006Ko0?ooo`3oool0
F03oool005P0oooo0P00I_mL0?ooo`030000003oool0oooo05T0oooo0P00I_mI0?ooo`00F03oool0
0`00I_l0oooo0?ooo`1K0?ooo`030000003oool0oooo05X0oooo0P00I_mH0?ooo`00E`3oool2001V
oed0oooo00<000000?ooo`3oool0F`3oool2001VoeL0oooo001G0?ooo`03001Vo`3oool0oooo05`0
oooo00<000000?ooo`3oool0G03oool00`00I_l0oooo0?ooo`1E0?ooo`00EP3oool2001Voeh0oooo
00<000000?ooo`3oool0G03oool2001VoeH0oooo001E0?ooo`8006KoG`3oool00`000000oooo0?oo
o`1M0?ooo`8006KoE@3oool005D0oooo00<006Ko0?ooo`3oool0GP3oool00`000000oooo0?ooo`1N
0?ooo`03001Vo`3oool0oooo05<0oooo001D0?ooo`8006KoH03oool00`000000oooo0?ooo`1N0?oo
o`8006KoE03oool005<0oooo0P00I_mQ0?ooo`030000003oool0oooo05l0oooo00<006Ko0?ooo`3o
ool0DP3oool005<0oooo00<006Ko0?ooo`3oool0H03oool00`000000oooo0?ooo`1O0?ooo`8006Ko
D`3oool00580oooo0P00I_mR0?ooo`030000003oool0oooo0600oooo0P00I_mB0?ooo`00DP3oool0
0`00I_l0oooo0?ooo`1Q0?ooo`030000003oool0oooo0640oooo00<006Ko0?ooo`3oool0D03oool0
0540oooo0P00I_mS0?ooo`030000003oool0oooo0640oooo0P00I_mA0?ooo`00D@3oool00`00I_l0
oooo0?ooo`1R0?ooo`030000003oool0oooo0680oooo00<006Ko0?ooo`3oool0C`3oool00500oooo
0P00I_mT0?ooo`030000003oool0oooo0680oooo0P00I_m@0?ooo`00D03oool00`00I_l0oooo0?oo
o`1S0?ooo`800000I03oool00`00I_l0oooo0?ooo`1>0?ooo`00C`3oool2001VofD0oooo00<00000
0?ooo`3oool0H`3oool2001Vodl0oooo001>0?ooo`8006KoIP3oool00`000000oooo0?ooo`1T0?oo
o`8006KoCP3oool004h0oooo00<006Ko0?ooo`3oool0I@3oool00`000000oooo0?ooo`1U0?ooo`03
001Vo`3oool0oooo04`0oooo001=0?ooo`8006KoI`3oool00`000000oooo0?ooo`1U0?ooo`8006Ko
C@3oool004d0oooo00<006Ko0?ooo`3oool0IP3oool00`000000oooo0?ooo`1V0?ooo`03001Vo`3o
ool0oooo04/0oooo001<0?ooo`8006KoJ03oool00`000000oooo0?ooo`1V0?ooo`8006KoC03oool0
04`0oooo00<006Ko0?ooo`3oool0I`3oool00`000000oooo0?ooo`1V0?ooo`8006KoC03oool004/0
oooo0P00I_mY0?ooo`030000003oool0oooo06H0oooo0P00I_m<0?ooo`00B`3oool00`00I_l0oooo
0?ooo`1X0?ooo`030000003oool0oooo06H0oooo0`00I_m;0?ooo`00BP3oool2001VofX0oooo00<0
00000?ooo`3oool0I`3oool2001Vod/0oooo001:0?ooo`8006KoB`3oool00`00I_l0oooo0?ooo`0L
0?ooo`030000003oool0oooo06L0oooo0P00I_m;0?ooo`00B@3oool3001VodX0oooo00<006Ko0?oo
o`3oool07@3oool00`000000oooo0?ooo`1W0?ooo`<006KoBP3oool004T0oooo0P00I_m:0?ooo`80
06Ko00<0oooo0?oDV`0000000P0000000`2Ke?l0oooo0?ooo`030?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`070?ooo`030000003oool0oooo06P0oooo0P00I_m:0?oo
o`00B@3oool2001VodT0oooo0`00I_l01`3oool0^W:K0=Coo`3oool0oooD09/0V`3Dool0103oool0
0`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`060?ooo`030000
003oool0oooo06P0oooo0`00I_m90?ooo`00B03oool3001VodP0oooo0`00I_l00`3oool0omBK002K
e0030?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?oo
o`0M0?ooo`<006KoB@3oool2001VodT0oooo00180?ooo`8006KoB03oool4001Vo`030?ooo`3Z^W80
L[[Z00<0oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0
oooo01d0oooo1000I_m80?ooo`8006KoB@3oool004P0oooo0P00I_m70?ooo`D006Ko00<0oooo0>Zj
LP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo00D0oooo0`00000M0?oo
o`8006Ko00<0oooo001Vo`3oool0A`3oool3001VodP0oooo00170?ooo`<006KoA`3oool4001Vo`80
oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K000000000080
000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?ooo`0M0?ooo`8006Ko00<0oooo001Vo`00
I_l0B03oool2001VodP0oooo00170?ooo`8006KoA`3oool2001Vo`030?ooo`00I_l006Ko0080oooo
00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo
00<000000?ooo`3oool07P3oool2001Vo`030?ooo`00I_l006Ko04L0oooo0`00I_m70?ooo`00A`3o
ool2001VodH0oooo0`00I_l00`3oool006Ko001Vo`030?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0
e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo01h0oooo0P00I_l20?ooo`03
001Vo`3oool0oooo04H0oooo0P00I_m70?ooo`00AP3oool3001VodD0oooo0`00I_l20?ooo`8006Ko
0`3oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0
e?oo0?ooo`050?ooo`030000003oool0oooo01h0oooo0P00I_l20?ooo`8006KoA`3oool2001VodL0
oooo00160?ooo`8006KoA@3oool3001Vo`<0oooo0P00I_lQ0?ooo`030000003oool0oooo01h0oooo
0P00I_l30?ooo`8006KoAP3oool2001VodL0oooo00160?ooo`8006KoA03oool3001Vo`@0oooo0P00
I_lQ0?ooo`030000003oool0oooo01h0oooo0P00I_l40?ooo`8006KoA@3oool3001VodH0oooo0016
0?ooo`8006Ko@`3oool3001Vo`D0oooo0P00I_lQ0?ooo`030000003oool0oooo01h0oooo0P00I_l5
0?ooo`8006KoA@3oool2001VodH0oooo00150?ooo`<006Ko@`3oool2001Vo`H0oooo0P00I_lQ0?oo
o`030000003oool0oooo01h0oooo0`00I_l40?ooo`<006KoA03oool2001VodH0oooo00150?ooo`80
06Ko@`3oool2001Vo`L0oooo0P00I_lQ0?ooo`030000003oool0oooo01l0oooo0P00I_l50?ooo`<0
06Ko@`3oool2001VodH0oooo00150?ooo`8006Ko@P3oool3001Vo`L0oooo0P00I_lQ0?ooo`030000
003oool0oooo01l0oooo0P00I_l60?ooo`<006Ko@P3oool2001VodH0oooo00150?ooo`8006Ko@@3o
ool3001Vo`L0oooo0P00I_lR0?ooo`030000003oool0oooo01l0oooo0P00I_l70?ooo`<006Ko@@3o
ool2001VodH0oooo00150?ooo`8006Ko@03oool3001Vo`P0oooo0P00I_lR0?ooo`030000003oool0
oooo01l0oooo0P00I_l80?ooo`<006Ko@03oool2001VodH0oooo00150?ooo`8006Ko?`3oool3001V
o`T0oooo0P00I_lR0?ooo`030000003oool0oooo01l0oooo0P00I_l90?ooo`<006Ko?`3oool2001V
odH0oooo00140?ooo`<006Ko?P3oool3001Vo`X0oooo0P00I_lR0?ooo`030000003oool0oooo01l0
oooo0P00I_l:0?ooo`<006Ko?P3oool2001VodH0oooo00140?ooo`8006Ko?P3oool3001Vo`/0oooo
0P00I_lR0?ooo`030000003oool0oooo01l0oooo0P00I_l;0?ooo`<006Ko?@3oool2001VodH0oooo
00140?ooo`8006Ko?@3oool3001Vo``0oooo0P00I_lR0?ooo`800000803oool2001Vo``0oooo0`00
I_ll0?ooo`8006KoAP3oool004@0oooo0P00I_ll0?ooo`<006Ko3@3oool2001Vob80oooo00<00000
0?ooo`3oool07`3oool2001Vo`d0oooo1000I_lj0?ooo`8006KoAP3oool004@0oooo0P00I_lk0?oo
o`<006Ko3@3oool3001Vob80oooo00<000000?ooo`3oool07`3oool2001Vo`h0oooo1000I_li0?oo
o`8006KoAP3oool004D0oooo00<006Ko0?ooo`3oool0>03oool3001Vo`h0oooo0P00I_lS0?ooo`03
0000003oool0oooo01l0oooo0P00I_l@0?ooo`<006Ko>03oool2001VodH0oooo00150?ooo`8006Ko
>03oool3001Vo`l0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_lA0?ooo`<006Ko
=`3oool2001VodH0oooo00160?ooo`03001Vo`3oool0oooo03D0oooo0`00I_l@0?ooo`8006Ko8`3o
ool00`000000oooo0?ooo`0O0?ooo`8006Ko4P3oool3001VocH0oooo0P00I_m60?ooo`00A@3oool2
001VocH0oooo0`00I_lA0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko4`3oool4
001Voc@0oooo0P00I_m60?ooo`00A@3oool2001VocD0oooo0`00I_lB0?ooo`8006Ko8`3oool00`00
0000oooo0?ooo`0O0?ooo`8006Ko503oool4001Voc<0oooo0P00I_m60?ooo`00A@3oool2001Voc@0
oooo0`00I_lC0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko5P3oool3001Voc80
oooo0P00I_m60?ooo`00A@3oool3001Voc40oooo1000I_lD0?ooo`8006Ko8`3oool00`000000oooo
0?ooo`0O0?ooo`8006Ko5`3oool3001Voc40oooo00<006Ko0?ooo`3oool0A@3oool004H0oooo0P00
I_l`0?ooo`@006Ko5@3oool2001Vob<0oooo00<000000?ooo`3oool07`3oool2001VoaP0oooo1000
I_l^0?ooo`<006KoAP3oool004H0oooo0P00I_l_0?ooo`<006Ko5`3oool2001Vob<0oooo00<00000
0?ooo`3oool07`3oool2001VoaT0oooo1000I_l]0?ooo`8006KoA`3oool004L0oooo00<006Ko0?oo
o`3oool0;03oool3001VoaP0oooo0P00I_lS0?ooo`030000003oool0oooo01l0oooo0P00I_lK0?oo
o`<006Ko;03oool2001VodL0oooo00170?ooo`8006Ko:`3oool4001VoaT0oooo0P00I_lS0?ooo`03
0000003oool0oooo01l0oooo0P00I_lL0?ooo`@006Ko:@3oool3001VodL0oooo00180?ooo`03001V
o`3oool0oooo02P0oooo1000I_lJ0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko
7@3oool4001VobL0oooo0`00I_m80?ooo`00B03oool2001VobL0oooo1000I_lL0?ooo`8006Ko8`3o
ool00`000000oooo0?ooo`0O0?ooo`8006Ko7`3oool4001VobD0oooo0P00I_m90?ooo`00B@3oool2
001VobD0oooo1000I_lM0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko803oool4
001Vob<0oooo0`00I_m90?ooo`00BP3oool00`00I_l0oooo0?ooo`0Q0?ooo`@006Ko7`3oool2001V
ob<0oooo0P00000P0?ooo`8006Ko8P3oool4001Vob00oooo0`00I_m:0?ooo`00BP3oool2001Vob00
oooo1@00I_lP0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko8`3oool5001Voad0
oooo0`00I_m;0?ooo`00B`3oool3001Voa/0oooo1P00I_lR0?ooo`8006Ko8`3oool00`000000oooo
0?ooo`0O0?ooo`8006Ko9@3oool5001Voa/0oooo0P00I_m<0?ooo`00B`3oool4001VoaP0oooo1P00
I_lT0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko9`3oool5001VoaP0oooo0P00
I_m=0?ooo`00C@3oool4001Voa80oooo1`00I_lW0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O
0?ooo`8006Ko:@3oool6001Voa80oooo1000I_m>0?ooo`00CP3oool5001Vo``0oooo2000I_lZ0?oo
o`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`8006Ko:`3oool7001Vo`d0oooo1P00I_m>0?oo
o`00D03oool8001Vo`@0oooo1`00I_l^0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0O0?ooo`80
06Ko;`3oool8001Vo`<0oooo2000I_mA0?ooo`00DP3oool=001Voc80oooo0`00I_lR0?ooo`030000
003oool0oooo01l0oooo0P00I_la0?ooo`l006KoD`3oool005L0oooo1P00I_le0?ooo`8006Ko8P3o
ool00`000000oooo0?ooo`0O0?ooo`8006Ko=P3oool5001VoeP0oooo002B0?ooo`8006Ko8P3oool0
0`000000oooo0?ooo`0O0?ooo`8006KoT`3oool00980oooo0P00I_lR0?ooo`030000003oool0oooo
01l0oooo0P00I_nC0?ooo`00TP3oool2001Vob80oooo00<000000?ooo`3oool07`3oool2001Voi<0
oooo002B0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool00980oooo0P00
I_lR0?ooo`030000003oool0oooo01l0oooo0P00I_nC0?ooo`00TP3oool2001Vob80oooo00<00000
0?ooo`3oool07`3oool2001Voi<0oooo002B0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0N0?oo
o`<006KoT`3oool00980oooo0P00I_lR0?ooo`030000003oool0oooo01h0oooo0P00I_nD0?ooo`00
T`3oool2001Vob40oooo0P00000O0?ooo`8006KoU03oool009<0oooo0P00I_lQ0?ooo`030000003o
ool0oooo01h0oooo0P00I_nD0?ooo`00T`3oool2001Vob40oooo00<000000?ooo`3oool07P3oool2
001Voi@0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0N0?ooo`8006KoU03oool009<0
oooo0P00I_lQ0?ooo`030000003oool0oooo01d0oooo0P00I_nE0?ooo`00T`3oool2001Vob40oooo
00<000000?ooo`3oool07@3oool2001VoiD0oooo002D0?ooo`8006Ko803oool00`000000oooo0?oo
o`0M0?ooo`8006KoU@3oool009@0oooo0P00I_lP0?ooo`030000003oool0oooo01d0oooo0P00I_nE
0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool07@3oool2001VoiD0oooo002D0?ooo`80
06Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009@0oooo0`00I_lO0?ooo`030000
003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0703o
ool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool0
09D0oooo0`00I_lN0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00UP3oool2001Voah0
oooo00<000000?ooo`3oool0703oool2001VoiH0oooo002F0?ooo`8006Ko7P3oool00`000000oooo
0?ooo`0L0?ooo`8006KoUP3oool009H0oooo0P00I_lN0?ooo`800000703oool2001VoiL0oooo002G
0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0K0?ooo`8006KoU`3oool009L0oooo0P00I_lM0?oo
o`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3o
ool06`3oool2001VoiL0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0K0?ooo`8006Ko
U`3oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00V03oool0
0`00I_l0oooo0?ooo`0K0?ooo`030000003oool0oooo01X0oooo0P00I_nH0?ooo`00V03oool2001V
oa`0oooo00<000000?ooo`3oool06@3oool3001VoiP0oooo002I0?ooo`03001Vo`3oool0oooo01X0
oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002I0?ooo`8006Ko6`3oool00`000000oooo
0?ooo`0I0?ooo`8006KoV@3oool009X0oooo00<006Ko0?ooo`3oool06@3oool00`000000oooo0?oo
o`0H0?ooo`<006KoV@3oool009X0oooo00<006Ko0?ooo`3oool06@3oool00`000000oooo0?ooo`0H
0?ooo`8006KoVP3oool009X0oooo0P00I_lJ0?ooo`030000003oool0oooo01L0oooo0`00I_nJ0?oo
o`00V`3oool00`00I_l0oooo0?ooo`0;0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3o
ool0103oool00`000000oooo0?ooo`0G0?ooo`8006KoV`3oool009/0oooo0P00I_l?0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool05`3oool2001Voi/0oooo002L0?ooo`8006Ko3P3o
ool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01L0oooo00<006Ko0?ooo`3oool0VP3o
ool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05P3oool2
001Voi`0oooo002L0?ooo`8006Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`<000005@3oool2001V
oid0oooo002L0?ooo`<006Ko3@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01D0
oooo00<006Ko0?ooo`3oool0W03oool009d0oooo0P00I_l=0?ooo`030;YbLP2jj_l0oooo00L0oooo
00<000000?ooo`3oool0503oool2001Voih0oooo002N0?ooo`03001Vo`3oool0oooo00P0oooo00D0
j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo01@0oooo00<006Ko0?ooo`3oool0
W@3oool009h0oooo0P00I_l;0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool04`3o
ool2001Voil0oooo002O0?ooo`8006Ko5@3oool00`000000oooo0?ooo`0B0?ooo`8006KoX03oool0
0:00oooo0P00I_lD0?ooo`030000003oool0oooo0140oooo0P00I_nQ0?ooo`00X@3oool00`00I_l0
oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<006Ko0?ooo`3oool0X03oool00:40oooo
0P00I_lC0?ooo`030000003oool0oooo0100oooo0P00I_nR0?ooo`00XP3oool2001Voa80oooo00<0
00000?ooo`3oool03`3oool2001Voj<0oooo002S0?ooo`8006Ko4@3oool00`000000oooo0?ooo`0>
0?ooo`8006KoY03oool00:@0oooo0P00I_l@0?ooo`030000003oool0oooo00d0oooo0`00I_nT0?oo
o`00Y03oool4001Vo`h0oooo00<000000?ooo`3oool0303oool3001VojD0oooo002U0?ooo`@006Ko
3@3oool00`000000oooo0?ooo`0:0?ooo`@006KoYP3oool00:L0oooo0`00I_l<0?ooo`030000003o
ool0oooo00T0oooo1000I_nW0?ooo`00Z03oool3001Vo`/0oooo00<000000?ooo`3oool0203oool3
001VojT0oooo002Y0?ooo`D006Ko203oool2000000P0oooo0`00I_nZ0?ooo`00ZP3oool5001Vo`L0
oooo00<000000?ooo`3oool01@3oool4001Voj/0oooo002]0?ooo`@006Ko1@3oool00`000000oooo
0?ooo`020?ooo`H006Ko[03oool00:h0oooo2000I_l00`000000oooo001Vo`06001Vojh0oooo002`
0?ooo``006Ko/@3oool00;D0oooo1000I_nd0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00
]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo0000
\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.77273 .59091 m
.77951 .59948 L
.7853 .60782 L
.79115 .61812 L
.79517 .62772 L
.79664 .63261 L
.79728 .63537 L
.79775 .63791 L
.79807 .64013 L
.7983 .64257 L
.79841 .6451 L
.7984 .64746 L
.79825 .65013 L
.79795 .65264 L
.79756 .65487 L
.797 .65728 L
.79624 .65985 L
.79524 .66254 L
.79296 .66724 L
.78968 .67223 L
.78599 .67655 L
.78119 .68096 L
.77531 .6852 L
.76947 .68855 L
.76255 .6917 L
.75897 .69306 L
.75545 .69424 L
.75218 .69522 L
.75373 .69839 L
.7694 .72563 L
.7878 .76065 L
.80219 .79538 L
.80538 .8052 L
.80835 .81582 L
.81063 .82576 L
.81228 .83494 L
.81292 .83957 L
.81346 .84447 L
.8137 .84725 L
.81388 .84986 L
.814 .85218 L
.81409 .85468 L
.81413 .85712 L
.81412 .85977 L
.81406 .86252 L
.81394 .86506 L
.8136 .86954 L
.81333 .87201 L
.81304 .87425 L
.81156 .88227 L
Mistroke
.81044 .88662 L
.80922 .89053 L
.80651 .89734 L
.80296 .90405 L
.79857 .91036 L
.79316 .91624 L
.78792 .92059 L
.78154 .9246 L
.77396 .92798 L
.7694 .92943 L
.76507 .93047 L
.76088 .93119 L
.75845 .93149 L
.75617 .9317 L
.75189 .93191 L
.74969 .93192 L
.74722 .93188 L
.74268 .93161 L
.74036 .93139 L
.73779 .93108 L
.73316 .93036 L
.72879 .92948 L
.71864 .9268 L
.70748 .92286 L
.68636 .91277 L
.66684 .90057 L
.62806 .86826 L
.61897 .85906 L
.60946 .84872 L
.60671 .84559 L
.6044 .84325 L
.60493 .8507 L
.60533 .85774 L
.60566 .86546 L
.60587 .87318 L
.60594 .87759 L
.60596 .88175 L
.60595 .88611 L
.6059 .89012 L
.60581 .89452 L
.60567 .89916 L
.60534 .9069 L
.6049 .91409 L
.60428 .92195 L
.60346 .93031 L
.60143 .94609 L
.59893 .96069 L
.59276 .98692 L
.5849 1.01059 L
.57425 1.03395 L
Mistroke
.56111 1.05471 L
.55416 1.06319 L
.54723 1.07027 L
.54062 1.07589 L
.53317 1.08104 L
.52622 1.0848 L
.51966 1.0875 L
.5156 1.08877 L
.51175 1.0897 L
.50828 1.09031 L
.50452 1.09073 L
.5004 1.09091 L
.49605 1.09077 L
.49234 1.0904 L
.48828 1.08971 L
.48402 1.08867 L
.48009 1.08742 L
.47134 1.08359 L
.46381 1.07909 L
.45605 1.07318 L
.44336 1.06034 L
.43068 1.04258 L
.419 1.02003 L
.4137 1.00688 L
.40879 .9922 L
.40505 .97867 L
.40158 .96332 L
.399 .94889 L
.39711 .93531 L
.39557 .92024 L
.39498 .91224 L
.39473 .90815 L
.39451 .90376 L
.39424 .89637 L
.39409 .88946 L
.39404 .88525 L
.39404 .88125 L
.39412 .87378 L
.39429 .86708 L
.39456 .85998 L
.39491 .85332 L
.3953 .84733 L
.39395 .84483 L
.38895 .8505 L
.3797 .86045 L
.35811 .88104 L
.33466 .89952 L
.31259 .91334 L
.29288 .92271 L
.28347 .92613 L
Mistroke
.2786 .92762 L
.27352 .92895 L
.26915 .92992 L
.26441 .93076 L
.26019 .93133 L
.2563 .93169 L
.25166 .93191 L
.24735 .93189 L
.24358 .93168 L
.23958 .93125 L
.23735 .93092 L
.23537 .93056 L
.23105 .92955 L
.2272 .92838 L
.22371 .92707 L
.21774 .9242 L
.21196 .9205 L
.20745 .91681 L
.20299 .91223 L
.19875 .90672 L
.19488 .90019 L
.19186 .89347 L
.18965 .88693 L
.1879 .87975 L
.18714 .87551 L
.1866 .87143 L
.18619 .86705 L
.18596 .86296 L
.18587 .8584 L
.18588 .85607 L
.18595 .85351 L
.18616 .84913 L
.18648 .8451 L
.18697 .84041 L
.18757 .83594 L
.18894 .82792 L
.19083 .81915 L
.19655 .7991 L
.20438 .77819 L
.22114 .74288 L
.2376 .71341 L
.24203 .70575 L
.24413 .70213 L
.24601 .69884 L
.24765 .69595 L
.24545 .69452 L
.24359 .69393 L
.24187 .69336 L
.23874 .69221 L
.23322 .68986 L
Mistroke
.22782 .68708 L
.21933 .68139 L
.2153 .67784 L
.212 .67432 L
.20889 .67023 L
.20619 .66565 L
.20511 .66336 L
.20408 .66079 L
.2033 .65838 L
.20271 .65614 L
.20218 .65347 L
.20197 .65206 L
.20179 .65056 L
.20162 .64802 L
.20158 .64657 L
.20158 .64522 L
.2017 .64257 L
.20194 .64006 L
.20227 .6378 L
.20272 .63535 L
.20414 .62983 L
.2059 .62477 L
.20993 .616 L
.21549 .6066 L
.22171 .59786 L
.22352 .59553 L
.22548 .59309 L
.22717 .59103 L
.2255 .58875 L
.21805 .57897 L
.21181 .56925 L
.2093 .56461 L
.20692 .55954 L
.20505 .55474 L
.20364 .55025 L
.20295 .5475 L
.20244 .54501 L
.202 .54224 L
.20183 .54072 L
.2017 .53929 L
.20162 .5379 L
.20158 .53644 L
.20162 .53382 L
.2017 .53237 L
.20182 .53103 L
.202 .52956 L
.20224 .52799 L
.20276 .52547 L
.2035 .52276 L
.20533 .51795 L
Mistroke
.2077 .51344 L
.21043 .50944 L
.21822 .50134 L
.22365 .49729 L
.22928 .49393 L
.24112 .48873 L
.24427 .48767 L
.24775 .48662 L
.24713 .48495 L
.24616 .48324 L
.24421 .47983 L
.21231 .4214 L
.20449 .40392 L
.19722 .38471 L
.19218 .36805 L
.19001 .35908 L
.18818 .3497 L
.18743 .34486 L
.18677 .3396 L
.18632 .33487 L
.18604 .33051 L
.18593 .32788 L
.18588 .32542 L
.1859 .32086 L
.18598 .31834 L
.1861 .31604 L
.18629 .31354 L
.18654 .31092 L
.18705 .30692 L
.18777 .30272 L
.1895 .29541 L
.19083 .29115 L
.1923 .28724 L
.19556 .28034 L
.19965 .27381 L
.20416 .26829 L
.20873 .26388 L
.21422 .25975 L
.22085 .25601 L
.22443 .25445 L
.22853 .253 L
.23219 .25197 L
.23624 .2511 L
.24019 .25049 L
.24389 .25011 L
.24775 .24992 L
.25195 .24992 L
.25561 .25008 L
.25972 .25044 L
.26423 .25103 L
Mistroke
.26918 .25191 L
.27836 .25413 L
.28784 .25719 L
.29707 .26085 L
.31477 .26969 L
.35495 .29806 L
.37642 .31801 L
.38662 .32874 L
.391 .33361 L
.39562 .33878 L
.39513 .33199 L
.39475 .32561 L
.39443 .31882 L
.39419 .31149 L
.39411 .30765 L
.39406 .30345 L
.39405 .29581 L
.39416 .28835 L
.39437 .28144 L
.39465 .27521 L
.39499 .26935 L
.39607 .25608 L
.39752 .24326 L
.39953 .22965 L
.40209 .21602 L
.40537 .20185 L
.41271 .17768 L
.42371 .15179 L
.43567 .13156 L
.44986 .11437 L
.45851 .10661 L
.46682 .10079 L
.4743 .09677 L
.47867 .09493 L
.4827 .09354 L
.48698 .09239 L
.48935 .0919 L
.49161 .09153 L
.49562 .09108 L
.49789 .09095 L
.5 .09091 L
.50425 .09107 L
.50639 .09127 L
.50873 .09158 L
.51286 .09236 L
.5167 .09336 L
.5212 .09488 L
.52526 .09657 L
.53423 .10144 L
.54173 .10681 L
Mistroke
.54959 .11382 L
.56292 .12956 L
.5744 .14815 L
.58483 .17104 L
.59214 .19273 L
.59841 .21848 L
.60084 .23194 L
.60295 .24698 L
.60379 .25466 L
.60454 .26292 L
.6051 .27075 L
.60548 .27788 L
.60575 .28503 L
.6059 .29163 L
.60596 .29886 L
.60591 .30649 L
.60576 .3131 L
.60555 .31925 L
.60523 .32596 L
.6048 .33312 L
.60451 .33705 L
.60585 .33721 L
.61079 .3316 L
.62226 .31935 L
.6439 .29904 L
.66419 .28312 L
.68567 .26944 L
.69635 .26386 L
.70787 .25881 L
.71823 .25514 L
.72741 .25265 L
.73286 .25152 L
.7379 .25072 L
.74062 .2504 L
.7431 .25017 L
.74579 .25 L
.7486 .24991 L
.75315 .24995 L
.7573 .25021 L
.75962 .25046 L
.76171 .25075 L
.76629 .25161 L
.77005 .25257 L
.7739 .25382 L
.78044 .25665 L
.78752 .26094 L
.79325 .26566 L
.79805 .27082 L
.80255 .2771 L
.80612 .28364 L
Mistroke
.80882 .29015 L
.81007 .29392 L
.81109 .29761 L
.81261 .30478 L
.81323 .30894 L
.81366 .31287 L
.81397 .31726 L
.81406 .31951 L
.81412 .32202 L
.81411 .32623 L
.81398 .33014 L
.81371 .33447 L
.81329 .33909 L
.81281 .34316 L
.81226 .34696 L
.81071 .35568 L
.80567 .37568 L
.79954 .39376 L
.78226 .43239 L
.76586 .46241 L
.76171 .4696 L
.75743 .47699 L
.75545 .48044 L
.75362 .48363 L
.75203 .48643 L
.75513 .48748 L
.76822 .49265 L
.77474 .49626 L
.78013 .50001 L
.788 .5075 L
.79145 .5121 L
.79397 .51648 L
.79574 .52056 L
.79655 .52295 L
.79716 .52516 L
.79768 .52753 L
.79808 .5301 L
.79831 .53251 L
.79841 .5348 L
.79841 .53693 L
.7983 .5392 L
.79813 .54115 L
.79785 .5433 L
.79745 .54562 L
.79691 .54811 L
.79566 .55262 L
.79391 .55752 L
.79158 .56283 L
.78574 .5733 L
.77273 .59091 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002_0?ooo`h006Ko/03oool00:`0oooo5000
I_n]0?ooo`00ZP3oool6001Vo`H0oooo00<000000?ooo`3oool00`3oool5001Voj`0oooo002Y0?oo
o`@006Ko2@3oool00`000000oooo0?ooo`060?ooo`@006KoZP3oool00:P0oooo0`00I_l;0?ooo`03
0000003oool0oooo00L0oooo1000I_nY0?ooo`00Y`3oool3001Vo``0oooo00<000000?ooo`3oool0
2@3oool4001VojL0oooo002U0?ooo`@006Ko3@3oool00`000000oooo0?ooo`0:0?ooo`D006KoY@3o
ool00:<0oooo1@00I_l>0?ooo`030000003oool0oooo00`0oooo1000I_nT0?ooo`00X`3oool3001V
oa00oooo00<000000?ooo`3oool03P3oool3001Voj<0oooo002R0?ooo`8006Ko4P3oool00`000000
oooo0?ooo`0?0?ooo`<006KoXP3oool00:40oooo0P00I_lC0?ooo`030000003oool0oooo0100oooo
0P00I_nR0?ooo`00X03oool2001Voa@0oooo00<000000?ooo`3oool04@3oool2001Voj40oooo002P
0?ooo`03001Vo`3oool0oooo01<0oooo00<000000?ooo`3oool04@3oool3001Voj00oooo002O0?oo
o`8006Ko203oool00`3oe9/000000000000300000003002Ke03oool0oooo00@0oooo00<000000?oo
o`3oool04P3oool3001Voil0oooo002N0?ooo`8006Ko303oool00`2jLW80^^[o0?ooo`070?ooo`03
0000003oool0oooo01<0oooo0P00I_nO0?ooo`00WP3oool00`00I_l0oooo0?ooo`0;0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool0503oool2001Voih0oooo002M0?ooo`8006Ko3@3o
ool00`2jLW80^^[o0?ooo`070?ooo`<000005@3oool00`00I_l0oooo0?ooo`2L0?ooo`00W@3oool0
1000I_l0oooo0?ooo`2jLP0500000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool01`3o
ool00`000000oooo0?ooo`0E0?ooo`8006KoW@3oool009`0oooo0P00I_l>0?ooo`030;YbLP2jj_l0
oooo00L0oooo00<000000?ooo`3oool05P3oool2001Voi`0oooo002K0?ooo`8006Ko3`3oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo01L0oooo00<006Ko0?ooo`3oool0VP3oool009/0
oooo00<006Ko0?ooo`3oool02`3oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?oo
o`3oool05`3oool2001Voi/0oooo002J0?ooo`8006Ko3`3oool00`3Z^W80001b0;[Zo`080?ooo`03
0000003oool0oooo01P0oooo00<006Ko0?ooo`3oool0V@3oool009X0oooo00<006Ko0?ooo`3oool0
6@3oool00`000000oooo0?ooo`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003o
ool0oooo01T0oooo00<006Ko0?ooo`3oool0V03oool009T0oooo00<006Ko0?ooo`3oool06P3oool0
0`000000oooo0?ooo`0I0?ooo`8006KoV@3oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo
01X0oooo00<006Ko0?ooo`3oool0U`3oool009P0oooo00<006Ko0?ooo`3oool06`3oool00`000000
oooo0?ooo`0J0?ooo`8006KoV03oool009P0oooo00<006Ko0?ooo`3oool06`3oool00`000000oooo
0?ooo`0K0?ooo`03001Vo`3oool0oooo09H0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?oo
o`0K0?ooo`8006KoU`3oool009L0oooo00<006Ko0?ooo`3oool0703oool00`000000oooo0?ooo`0L
0?ooo`03001Vo`3oool0oooo09D0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0L0?oo
o`8006KoUP3oool009H0oooo00<006Ko0?ooo`3oool07@3oool00`000000oooo0?ooo`0L0?ooo`80
06KoUP3oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01`0oooo0P00I_nF0?ooo`00U@3o
ool2001Voal0oooo0P00000M0?ooo`<006KoU@3oool009@0oooo0`00I_lO0?ooo`030000003oool0
oooo01d0oooo0P00I_nE0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3oool07@3oool2001V
oiD0oooo002D0?ooo`8006Ko803oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009<0oooo
0`00I_lP0?ooo`030000003oool0oooo01d0oooo0`00I_nD0?ooo`00T`3oool2001Vob40oooo00<0
00000?ooo`3oool07P3oool2001Voi@0oooo002C0?ooo`8006Ko8@3oool00`000000oooo0?ooo`0N
0?ooo`8006KoU03oool00980oooo0`00I_lQ0?ooo`030000003oool0oooo01h0oooo0`00I_nC0?oo
o`00TP3oool2001Vob80oooo00<000000?ooo`3oool07`3oool2001Voi<0oooo002B0?ooo`8006Ko
8P3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool00980oooo0P00I_lR0?ooo`030000003o
ool0oooo01l0oooo0`00I_nB0?ooo`00TP3oool2001Vob80oooo00<000000?ooo`3oool0803oool2
001Voi80oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0P0?ooo`8006KoTP3oool00940
oooo0P00I_lS0?ooo`030000003oool0oooo0200oooo0P00I_nB0?ooo`00T@3oool2001Vob<0oooo
00<000000?ooo`3oool08@3oool2001Voi40oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?oo
o`0Q0?ooo`8006KoT@3oool00940oooo0P00I_lS0?ooo`030000003oool0oooo0240oooo0P00I_nA
0?ooo`00T03oool2001Vob@0oooo0P00000R0?ooo`8006KoT@3oool00900oooo0P00I_lT0?ooo`03
0000003oool0oooo0240oooo0P00I_nA0?ooo`00T03oool2001Vob@0oooo00<000000?ooo`3oool0
8@3oool2001Voi40oooo002@0?ooo`8006Ko903oool00`000000oooo0?ooo`0Q0?ooo`8006KoT@3o
ool00900oooo0P00I_lT0?ooo`030000003oool0oooo0240oooo0P00I_nA0?ooo`00S`3oool2001V
obD0oooo00<000000?ooo`3oool08@3oool2001Voi40oooo002?0?ooo`8006Ko9@3oool00`000000
oooo0?ooo`0Q0?ooo`8006KoT@3oool008l0oooo0P00I_lU0?ooo`030000003oool0oooo0280oooo
00<006Ko0?ooo`3oool0S`3oool005@0oooo4P00I_lY0?ooo`8006Ko9@3oool00`000000oooo0?oo
o`0R0?ooo`8006Ko;03oool@001Voe@0oooo001@0?oooaT006Ko9P3oool2001VobD0oooo00<00000
0?ooo`3oool08`3oool00`00I_l0oooo0?ooo`0V0?oooaP006KoD03oool004h0oooo1`00I_l@0?oo
o`H006Ko903oool2001VobD0oooo00<000000?ooo`3oool08P3oool2001VobD0oooo1`00I_l?0?oo
o`H006KoC`3oool004d0oooo1000I_lG0?ooo`D006Ko8P3oool2001VobD0oooo00<000000?ooo`3o
ool08P3oool2001Vob80oooo1`00I_lF0?ooo`@006KoC@3oool004`0oooo0`00I_lK0?ooo`D006Ko
803oool2001VobD0oooo00<000000?ooo`3oool08P3oool2001Vob00oooo1P00I_lJ0?ooo`@006Ko
C03oool004X0oooo1000I_lN0?ooo`D006Ko7P3oool2001VobD0oooo00<000000?ooo`3oool08P3o
ool2001Voah0oooo1@00I_lO0?ooo`<006KoB`3oool004T0oooo1000I_lQ0?ooo`D006Ko703oool2
001VobD0oooo00<000000?ooo`3oool08P3oool2001Voa`0oooo1@00I_lR0?ooo`<006KoBP3oool0
04P0oooo0`00I_lU0?ooo`@006Ko6P3oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001V
oa/0oooo1000I_lU0?ooo`8006KoBP3oool004L0oooo0`00I_lX0?ooo`@006Ko603oool2001VobH0
oooo0P00000S0?ooo`8006Ko6@3oool4001VobP0oooo0P00I_m90?ooo`00A`3oool2001VobX0oooo
1000I_lG0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0R0?ooo`8006Ko603oool4001VobX0oooo
0P00I_m80?ooo`00A`3oool2001Vob`0oooo1000I_lE0?ooo`8006Ko9P3oool00`000000oooo0?oo
o`0R0?ooo`8006Ko5P3oool4001Vobd0oooo00<006Ko0?ooo`3oool0AP3oool004L0oooo00<006Ko
0?ooo`3oool0;03oool4001Voa@0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_lE
0?ooo`@006Ko;P3oool2001VodL0oooo00160?ooo`8006Ko<03oool4001Voa80oooo0P00I_lV0?oo
o`030000003oool0oooo0280oooo0P00I_lD0?ooo`<006Ko<@3oool00`00I_l0oooo0?ooo`150?oo
o`00AP3oool00`00I_l0oooo0?ooo`0`0?ooo`@006Ko4@3oool2001VobH0oooo00<000000?ooo`3o
ool08P3oool2001Voa80oooo1000I_lb0?ooo`8006KoAP3oool004D0oooo0P00I_ld0?ooo`@006Ko
3`3oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001Voa40oooo1000I_ld0?ooo`03001V
o`3oool0oooo04@0oooo00150?ooo`03001Vo`3oool0oooo03@0oooo1000I_l>0?ooo`8006Ko9P3o
ool00`000000oooo0?ooo`0R0?ooo`8006Ko403oool3001VocH0oooo0P00I_m50?ooo`00A03oool2
001VocP0oooo1000I_l<0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0R0?ooo`8006Ko3P3oool4
001VocP0oooo00<006Ko0?ooo`3oool0@`3oool004@0oooo0P00I_li0?ooo`@006Ko2`3oool2001V
obH0oooo00<000000?ooo`3oool08P3oool2001Vo`d0oooo1000I_lh0?ooo`<006KoA03oool004@0
oooo0P00I_lk0?ooo`<006Ko2P3oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001Vo``0
oooo0`00I_lk0?ooo`8006KoA03oool004<0oooo0`00I_ll0?ooo`<006Ko2@3oool2001VobH0oooo
00<000000?ooo`3oool08P3oool2001Vo`/0oooo0`00I_ll0?ooo`8006KoA03oool004<0oooo0P00
I_ln0?ooo`<006Ko203oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001Vo`X0oooo0`00
I_lm0?ooo`8006KoA03oool004<0oooo0P00I_lo0?ooo`<006Ko1`3oool2001VobH0oooo00<00000
0?ooo`3oool08P3oool2001Vo`P0oooo1000I_ln0?ooo`8006KoA03oool00480oooo0`00I_m00?oo
o`<006Ko1P3oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001Vo`L0oooo1000I_lo0?oo
o`8006KoA03oool00480oooo0P00I_m20?ooo`<006Ko1@3oool2001VobH0oooo00<000000?ooo`3o
ool08P3oool2001Vo`H0oooo0`00I_m10?ooo`8006KoA03oool00480oooo0P00I_m30?ooo`<006Ko
103oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001Vo`D0oooo0`00I_m20?ooo`8006Ko
A03oool00480oooo0P00I_m40?ooo`8006Ko103oool2001VobH0oooo0P00000S0?ooo`8006Ko103o
ool3001Vod<0oooo0P00I_m40?ooo`00@P3oool2001VodD0oooo0P00I_l30?ooo`8006Ko9P3oool0
0`000000oooo0?ooo`0R0?ooo`8006Ko0`3oool3001Vod@0oooo0P00I_m40?ooo`00@P3oool2001V
odH0oooo0P00I_l20?ooo`<006Ko9@3oool00`000000oooo0?ooo`0R0?ooo`8006Ko0`3oool2001V
odD0oooo0P00I_m40?ooo`00@P3oool2001VodL0oooo0P00I_l20?ooo`8006Ko9@3oool00`000000
oooo0?ooo`0R0?ooo`8006Ko0P3oool2001VodH0oooo0P00I_m40?ooo`00@P3oool2001VodP0oooo
1@00I_lU0?ooo`030000003oool0oooo0280oooo0P00I_l0103oool006Ko001Vo`00I_m60?ooo`80
06KoA03oool00480oooo0P00I_m80?ooo`D006Ko9@3oool00`000000oooo0?ooo`0R0?ooo`D006Ko
A`3oool2001Vod@0oooo00120?ooo`<006KoB@3oool3001VobD0oooo00<000000?ooo`3oool08P3o
ool4001VodP0oooo0P00I_m40?ooo`00@`3oool2001VodX0oooo0P00I_lU0?ooo`030000003oool0
oooo0280oooo0`00I_m90?ooo`8006KoA03oool004<0oooo0P00I_m;0?ooo`03001Vo`3oool0oooo
02<0oooo00<000000?ooo`3oool08P3oool2001VodX0oooo0P00I_m40?ooo`00@`3oool2001Vog40
oooo00<000000?ooo`3oool08P3oool00`00I_l0oooo0?ooo`190?ooo`8006KoA03oool004<0oooo
0P00I_ma0?ooo`030000003oool0oooo06h0oooo0P00I_m40?ooo`00@`3oool3001Vog00oooo00<0
00000?ooo`3oool0KP3oool2001Vod@0oooo00140?ooo`8006KoL03oool00`000000oooo0?ooo`1^
0?ooo`8006KoA03oool004@0oooo0P00I_mB0?ooo`050?oDV`00000000000000002Ke?l01@3oool0
0`3DV`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?oo
o`1]0?ooo`<006KoA03oool004@0oooo0P00I_mB0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo
103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`060?oo
o`030000003oool0oooo06d0oooo0P00I_m50?ooo`00A03oool3001Voe00oooo00<0omBK002Ke03o
ool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3o
ool0K@3oool2001VodD0oooo00150?ooo`8006KoD03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool3000006d0oooo0P00I_m50?ooo`00A@3o
ool2001VodL0oooo00<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo
00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`050?ooo`030000003oool0oooo06`0oooo
0`00I_m50?ooo`00A@3oool2001Voe00oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?oo
o`1/0?ooo`8006KoAP3oool004H0oooo0P00I_m?0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb
07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo06`0oooo0P00I_m6
0?ooo`00AP3oool2001Voe00oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?ooe02K
09/0e?oo00X0oooo00<000000?ooo`3oool0K03oool2001VodH0oooo00160?ooo`8006KoD03oool0
1@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0e?oo0?oo
o`050?ooo`030000003oool0oooo06/0oooo0`00I_m60?ooo`00AP3oool2001Vofh0oooo00<00000
0?ooo`3oool0J`3oool2001VodL0oooo00160?ooo`8006KoKP3oool00`000000oooo0?ooo`1[0?oo
o`8006KoA`3oool004H0oooo0`00I_m]0?ooo`030000003oool0oooo06X0oooo0`00I_m70?ooo`00
A`3oool2001Vofd0oooo00<000000?ooo`3oool0JP3oool2001VodP0oooo00170?ooo`<006KoK03o
ool00`000000oooo0?ooo`1Z0?ooo`8006KoB03oool004P0oooo0P00I_m/0?ooo`030000003oool0
oooo06T0oooo0`00I_m80?ooo`00B03oool2001Vof`0oooo00<000000?ooo`3oool0J@3oool2001V
odT0oooo00190?ooo`8006KoJ`3oool00`000000oooo0?ooo`1X0?ooo`<006KoB@3oool004T0oooo
0P00I_m[0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00BP3oool00`00I_l0oooo0?oo
o`1Y0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00BP3oool2001VofX0oooo00<00000
0?ooo`3oool0I`3oool3001VodX0oooo001;0?ooo`03001Vo`3oool0oooo06P0oooo0P00001X0?oo
o`8006KoB`3oool004/0oooo0P00I_mY0?ooo`030000003oool0oooo06H0oooo0`00I_m;0?ooo`00
C03oool00`00I_l0oooo0?ooo`1W0?ooo`030000003oool0oooo06H0oooo0P00I_m<0?ooo`00C03o
ool2001VofP0oooo00<000000?ooo`3oool0I@3oool3001Vod`0oooo001=0?ooo`03001Vo`3oool0
oooo06H0oooo00<000000?ooo`3oool0I@3oool2001Vodd0oooo001=0?ooo`8006KoI`3oool00`00
0000oooo0?ooo`1U0?ooo`8006KoC@3oool004h0oooo00<006Ko0?ooo`3oool0I@3oool00`000000
oooo0?ooo`1T0?ooo`8006KoCP3oool004h0oooo0P00I_mV0?ooo`030000003oool0oooo06@0oooo
0P00I_m>0?ooo`00C`3oool00`00I_l0oooo0?ooo`1T0?ooo`030000003oool0oooo06@0oooo00<0
06Ko0?ooo`3oool0C@3oool004l0oooo0P00I_mU0?ooo`030000003oool0oooo06<0oooo0P00I_m?
0?ooo`00D03oool2001Vof@0oooo00<000000?ooo`3oool0H`3oool00`00I_l0oooo0?ooo`1>0?oo
o`00D@3oool00`00I_l0oooo0?ooo`1R0?ooo`030000003oool0oooo0680oooo0P00I_m@0?ooo`00
D@3oool2001Vof<0oooo00<000000?ooo`3oool0HP3oool00`00I_l0oooo0?ooo`1?0?ooo`00DP3o
ool00`00I_l0oooo0?ooo`1Q0?ooo`030000003oool0oooo0640oooo0P00I_mA0?ooo`00DP3oool2
001Vof80oooo00<000000?ooo`3oool0H03oool2001Voe80oooo001C0?ooo`03001Vo`3oool0oooo
0600oooo00<000000?ooo`3oool0H03oool00`00I_l0oooo0?ooo`1A0?ooo`00D`3oool2001Vof40
oooo0P00001P0?ooo`8006KoD`3oool005@0oooo00<006Ko0?ooo`3oool0G`3oool00`000000oooo
0?ooo`1O0?ooo`03001Vo`3oool0oooo0580oooo001D0?ooo`8006KoH03oool00`000000oooo0?oo
o`1N0?ooo`8006KoE03oool005D0oooo00<006Ko0?ooo`3oool0GP3oool00`000000oooo0?ooo`1N
0?ooo`03001Vo`3oool0oooo05<0oooo001E0?ooo`8006KoG`3oool00`000000oooo0?ooo`1M0?oo
o`8006KoE@3oool005H0oooo0P00I_mN0?ooo`030000003oool0oooo05`0oooo0P00I_mF0?ooo`00
E`3oool00`00I_l0oooo0?ooo`1L0?ooo`030000003oool0oooo05`0oooo00<006Ko0?ooo`3oool0
E@3oool005L0oooo0P00I_mM0?ooo`030000003oool0oooo05/0oooo0P00I_mG0?ooo`00F03oool0
0`00I_l0oooo0?ooo`1K0?ooo`030000003oool0oooo05/0oooo0P00I_mG0?ooo`00F03oool2001V
oe`0oooo00<000000?ooo`3oool0FP3oool3001VoeL0oooo001I0?ooo`03001Vo`3oool0oooo05X0
oooo00<000000?ooo`3oool0F@3oool3001VoeP0oooo001H0?ooo`<006KoF`3oool00`000000oooo
0?ooo`1H0?ooo`<006KoF@3oool005L0oooo1000I_mK0?ooo`030000003oool0oooo05P0oooo1@00
I_mG0?ooo`00E@3oool6001Voe/0oooo00<000000?ooo`3oool0F03oool8001Voe@0oooo001C0?oo
o`D006KoGP3oool00`000000oooo0?ooo`1L0?ooo`D006KoD`3oool00540oooo1@00I_mP0?ooo`03
0000003oool0oooo05l0oooo0`00I_mB0?ooo`00C`3oool5001Vof80oooo00<000000?ooo`3oool0
H03oool4001Voe00oooo001>0?ooo`@006KoI03oool200000680oooo1000I_m?0?ooo`00C@3oool3
001VofH0oooo00<000000?ooo`3oool0H`3oool3001Vodh0oooo001<0?ooo`<006KoI`3oool00`00
0000oooo0?ooo`1T0?ooo`<006KoC@3oool004`0oooo0P00I_mX0?ooo`030000003oool0oooo06D0
oooo0`00I_m<0?ooo`00B`3oool2001VofT0oooo00<000000?ooo`3oool0IP3oool2001Vod`0oooo
001:0?ooo`8006KoJP3oool00`000000oooo0?ooo`1W0?ooo`8006KoB`3oool004T0oooo0`00I_mZ
0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00B@3oool2001Vof/0oooo00<000000?oo
o`3oool0J03oool2001VodX0oooo00190?ooo`8006KoJ`3oool00`000000oooo0?ooo`1X0?ooo`80
06KoBP3oool004P0oooo0`00I_m[0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00B03o
ool2001Vof`0oooo00<000000?ooo`3oool0J03oool2001VodX0oooo00180?ooo`8006KoK03oool0
0`000000oooo0?ooo`1X0?ooo`8006KoBP3oool004P0oooo0P00I_m/0?ooo`030000003oool0oooo
06P0oooo0`00I_m90?ooo`00B03oool2001Vof`0oooo00<000000?ooo`3oool0J@3oool3001VodP0
oooo00180?ooo`8006KoK03oool00`000000oooo0?ooo`1X0?ooo`<006KoB@3oool004P0oooo0P00
I_m/0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00B03oool2001Vof`0oooo0P00001Y
0?ooo`8006KoBP3oool00140oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0^0?oo
o`<006Ko4@3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool0
1@3DV`000000000000000000VmCo04<0oooo00<000000?ooo`3oool0A03oool01@3oe9/000000000
00000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo00d0
oooo0P00I_le0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0303oool001@0oooo
00<0^W9b0;[Zo`3oool0<P3oool2001Voa40oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?oo
o`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo0480oooo00<0
00000?ooo`3oool0A03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000
Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0303oool2001VocP0oooo00<0^W9b
0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0<P3oool2001Voa00oooo00<0omBK002K
e03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?oo
o`3oool0@`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002K
e03oool02`3oool2001VocP0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3o
ool0<`3oool00`00I_l0oooo0?ooo`0>0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03o
ool03`3oool00`3oe9/009_D0?ooo`110?ooo`030000003oool0oooo04<0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00/0oooo0P00I_lh0?ooo`03
0;YbLP2jj_l0oooo00l0oooo00080?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool0
0`3oool00`2jLW80^^[o0?ooo`0c0?ooo`8006Ko1P3oool00`2jLP0000000000000300000005001b
^P3oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo0440
oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0
oooo00<0^W8009_Do`3oool02`3oool00`00I_l0oooo0?ooo`0g0?ooo`030;YbLP2jj_l0oooo00l0
oooo000D0?ooo`030;YbLP2jj_l0oooo03@0oooo0P00I_l>0?ooo`030>ZjLP1b^^X0oooo0080oooo
00<0omBK002Ke03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo0440oooo
00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo
00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`0:0?ooo`8006Ko>@3oool00`2jLW80^^[o
0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`0d0?ooo`8006Ko3P3oool00`3oe9/0L[[Z0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0AP3oool00`000000oooo0?oo
o`130?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Co
o`0?0?ooo`03001Vo`3oool0oooo03P0oooo00<0^W9b0;[Zo`3oool03`3oool00140oooo00D0j[Yb
00000000L[X0^W9b0;[Zo`0f0?ooo`8006Ko3P3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0
oooo00<0oooD09/0V`3Dool0AP3oool00`000000oooo0?ooo`140?ooo`060;Yb002Ke?l0oooo0?oZ
^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0>0?ooo`8006Ko=`3oool01@3Z^W800000001b^P2j
LW80^^[o0100oooo000C0?ooo`030>ZjLP000780^^[o03L0oooo00<006Ko0?ooo`3oool0303oool0
1@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0e?oo0?oo
o`110?ooo`030000003oool0oooo04@0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?oo
e02K000000000080000000<0002K0=Coo`3oool02@3oool00`00I_l0oooo0?ooo`0h0?ooo`030>Zj
LP000780^^[o0100oooo001=0?ooo`8006KoI`3oool00`000000oooo0?ooo`1U0?ooo`8006KoC@3o
ool004h0oooo00<006Ko0?ooo`3oool0I@3oool00`000000oooo0?ooo`1T0?ooo`8006KoCP3oool0
04h0oooo0P00I_mV0?ooo`030000003oool0oooo06<0oooo0`00I_m>0?ooo`00C`3oool2001VofD0
oooo00<000000?ooo`3oool0HP3oool3001Vodl0oooo001?0?ooo`<006KoI03oool00`000000oooo
0?ooo`1R0?ooo`8006KoD03oool00500oooo0`00I_mS0?ooo`030000003oool0oooo0640oooo0P00
I_mA0?ooo`00D@3oool2001Vof<0oooo00<000000?ooo`3oool0H03oool3001Voe40oooo001A0000
008006Koa@000003001Voe80000000000`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00`0
oooo0P00I_l@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool3001Vo`h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool100000000403oool00`000000oooo0?ooo`0m0?ooo`<006Ko
403oool00`000000oooo0?ooo`1@0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0
3P3oool3001Voch0oooo00<000000?ooo`3oool03`3oool00500oooo0P00I_mT0?ooo`030000003o
ool0oooo0680oooo0P00I_m@0?ooo`00C`3oool2001VofD0oooo00<000000?ooo`3oool0H`3oool2
001Vodl0oooo001>0?ooo`8006KoIP3oool00`000000oooo0?ooo`1T0?ooo`8006KoCP3oool004h0
oooo00<006Ko0?ooo`3oool0I@3oool00`000000oooo0?ooo`1U0?ooo`03001Vo`3oool0oooo04`0
oooo001=0?ooo`8006KoI`3oool00`000000oooo0?ooo`1U0?ooo`8006KoC@3oool004`0oooo0P00
I_mX0?ooo`030000003oool0oooo06H0oooo00<006Ko0?ooo`3oool0B`3oool004`0oooo00<006Ko
0?ooo`3oool0I`3oool00`000000oooo0?ooo`1V0?ooo`8006KoC03oool004/0oooo0P00I_mY0?oo
o`030000003oool0oooo06L0oooo00<006Ko0?ooo`3oool0BP3oool004/0oooo0P00I_mY0?ooo`03
0000003oool0oooo06L0oooo0P00I_m;0?ooo`00B`3oool00`00I_l0oooo0?ooo`1X0?ooo`030000
003oool0oooo06L0oooo0P00I_m;0?ooo`00BP3oool2001VofX0oooo00<000000?ooo`3oool0J03o
ool00`00I_l0oooo0?ooo`190?ooo`00BP3oool00`00I_l0oooo0?ooo`1Y0?ooo`030000003oool0
oooo06P0oooo0P00I_m:0?ooo`00B@3oool2001Vof/0oooo00<000000?ooo`3oool0J@3oool00`00
I_l0oooo0?ooo`180?ooo`00B@3oool00`00I_l0oooo0?ooo`1Z0?ooo`030000003oool0oooo06P0
oooo0P00I_m:0?ooo`00B03oool2001Vof`0oooo0P00001Y0?ooo`8006KoBP3oool004P0oooo0P00
I_m/0?ooo`030000003oool0oooo06P0oooo0P00I_m:0?ooo`00B03oool2001Vof`0oooo00<00000
0?ooo`3oool0J03oool3001VodT0oooo00180?ooo`8006KoK03oool00`000000oooo0?ooo`1Y0?oo
o`8006KoB@3oool004P0oooo0P00I_m/0?ooo`030000003oool0oooo06T0oooo0P00I_m90?ooo`00
B03oool2001Vof`0oooo00<000000?ooo`3oool0J03oool3001VodT0oooo00180?ooo`8006KoK03o
ool00`000000oooo0?ooo`1X0?ooo`8006KoBP3oool004P0oooo0`00I_m[0?ooo`030000003oool0
oooo06P0oooo0P00I_m:0?ooo`00B@3oool2001Vof/0oooo00<000000?ooo`3oool0J03oool2001V
odX0oooo00190?ooo`<006KoJP3oool00`000000oooo0?ooo`1W0?ooo`<006KoBP3oool004X0oooo
0P00I_mZ0?ooo`030000003oool0oooo06L0oooo0P00I_m;0?ooo`00B`3oool2001VofT0oooo00<0
00000?ooo`3oool0I`3oool2001Vod/0oooo001<0?ooo`8006KoJ03oool00`000000oooo0?ooo`1V
0?ooo`<006KoB`3oool004`0oooo0P00I_mX0?ooo`030000003oool0oooo06D0oooo0`00I_m<0?oo
o`00C@3oool2001VofL0oooo00<000000?ooo`3oool0I03oool3001Vodd0oooo001>0?ooo`8006Ko
IP3oool00`000000oooo0?ooo`1S0?ooo`<006KoCP3oool004h0oooo1000I_mT0?ooo`800000HP3o
ool4001Vodl0oooo001?0?ooo`D006KoHP3oool00`000000oooo0?ooo`1P0?ooo`@006KoD03oool0
0540oooo1@00I_mP0?ooo`030000003oool0oooo05l0oooo0`00I_mB0?ooo`00D`3oool5001Voeh0
oooo00<000000?ooo`3oool0G03oool5001Voe<0oooo001E0?ooo`@006KoG@3oool00`000000oooo
0?ooo`1J0?ooo`H006KoE03oool005L0oooo1@00I_mJ0?ooo`030000003oool0oooo05P0oooo1@00
I_mG0?ooo`00E`3oool4001Voe/0oooo00<000000?ooo`3oool0F@3oool2001VoeT0oooo001H0?oo
o`8006KoG03oool00`000000oooo0?ooo`1I0?ooo`8006KoF@3oool005P0oooo00<006Ko0?ooo`3o
ool0F`3oool00`000000oooo0?ooo`1J0?ooo`03001Vo`3oool0oooo05L0oooo001G0?ooo`8006Ko
G@3oool00`000000oooo0?ooo`1J0?ooo`8006KoF03oool005L0oooo0P00I_mM0?ooo`030000003o
ool0oooo05/0oooo0P00I_mG0?ooo`00EP3oool2001Voeh0oooo00<000000?ooo`3oool0G03oool0
0`00I_l0oooo0?ooo`1E0?ooo`00EP3oool00`00I_l0oooo0?ooo`1M0?ooo`030000003oool0oooo
05`0oooo0P00I_mF0?ooo`00E@3oool2001Voel0oooo00<000000?ooo`3oool0G@3oool00`00I_l0
oooo0?ooo`1D0?ooo`00E03oool2001Vof00oooo00<000000?ooo`3oool0G@3oool2001VoeD0oooo
001D0?ooo`03001Vo`3oool0oooo05l0oooo00<000000?ooo`3oool0GP3oool2001Voe@0oooo001C
0?ooo`8006KoH@3oool00`000000oooo0?ooo`1O0?ooo`03001Vo`3oool0oooo0580oooo001C0?oo
o`03001Vo`3oool0oooo0600oooo0P00001P0?ooo`8006KoD`3oool00580oooo0P00I_mR0?ooo`03
0000003oool0oooo0600oooo00<006Ko0?ooo`3oool0D@3oool00540oooo0P00I_mS0?ooo`030000
003oool0oooo0600oooo0P00I_mB0?ooo`00D@3oool00`00I_l0oooo0?ooo`1R0?ooo`030000003o
ool0oooo0640oooo00<006Ko0?ooo`3oool0D03oool00500oooo0P00I_mT0?ooo`030000003oool0
oooo0640oooo0P00I_mA0?ooo`00D03oool00`00I_l0oooo0?ooo`1S0?ooo`030000003oool0oooo
0680oooo00<006Ko0?ooo`3oool0C`3oool004l0oooo0P00I_mU0?ooo`030000003oool0oooo0680
oooo0P00I_m@0?ooo`00C`3oool00`00I_l0oooo0?ooo`1T0?ooo`030000003oool0oooo06<0oooo
0P00I_m?0?ooo`00CP3oool2001VofH0oooo00<000000?ooo`3oool0I03oool00`00I_l0oooo0?oo
o`1=0?ooo`00CP3oool00`00I_l0oooo0?ooo`1U0?ooo`030000003oool0oooo06@0oooo0P00I_m>
0?ooo`00C@3oool2001VofL0oooo00<000000?ooo`3oool0I@3oool00`00I_l0oooo0?ooo`1<0?oo
o`00C@3oool00`00I_l0oooo0?ooo`1V0?ooo`030000003oool0oooo06D0oooo0P00I_m=0?ooo`00
C@3oool00`00I_l0oooo0?ooo`1V0?ooo`030000003oool0oooo06H0oooo00<006Ko0?ooo`3oool0
B`3oool004`0oooo0P00I_mX0?ooo`030000003oool0oooo06H0oooo0P00I_m<0?ooo`00C03oool0
0`00I_l0oooo0?ooo`1W0?ooo`030000003oool0oooo06H0oooo0P00I_m<0?ooo`00B`3oool2001V
ofT0oooo00<000000?ooo`3oool0IP3oool3001Vod/0oooo001;0?ooo`03001Vo`3oool0oooo06P0
oooo0P00001X0?ooo`8006KoB`3oool004X0oooo0P00I_mZ0?ooo`030000003oool0oooo06L0oooo
0`00I_m:0?ooo`00BP3oool00`00I_l0oooo0?ooo`1Y0?ooo`030000003oool0oooo06P0oooo0P00
I_m:0?ooo`00B@3oool2001Vof/0oooo00<000000?ooo`3oool0J03oool2001VodX0oooo00190?oo
o`8006KoJ`3oool00`000000oooo0?ooo`1X0?ooo`<006KoB@3oool004P0oooo0`00I_m[0?ooo`03
0000003oool0oooo06T0oooo0P00I_m90?ooo`00B03oool2001Vof`0oooo00<000000?ooo`3oool0
J@3oool3001VodP0oooo00170?ooo`<006KoK03oool00`000000oooo0?ooo`1Z0?ooo`8006KoB03o
ool004L0oooo0P00I_m]0?ooo`030000003oool0oooo06X0oooo0P00I_m80?ooo`00A`3oool2001V
ofd0oooo00<000000?ooo`3oool0JP3oool3001VodL0oooo00160?ooo`<006KoK@3oool00`000000
oooo0?ooo`1[0?ooo`8006KoA`3oool004H0oooo0P00I_m^0?ooo`030000003oool0oooo06/0oooo
0P00I_m70?ooo`00AP3oool2001Vofh0oooo00<000000?ooo`3oool0J`3oool3001VodH0oooo0015
0?ooo`<006KoD03oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3o
ool01@3DV`000000000000000000VmCo00L0oooo00<000000?ooo`3oool0K03oool2001VodH0oooo
00150?ooo`8006KoD@3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000
Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo0?ooo`1/
0?ooo`8006KoAP3oool004D0oooo0P00I_m@0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:j
jP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo06`0oooo0P00I_m60?oo
o`00A@3oool2001Voe00oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`03
0?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0K03oool3001VodD0oooo00140?ooo`<006Ko
D03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0
1@3oool3000006d0oooo0P00I_m50?ooo`00A03oool2001Voe40oooo00<0j[Yb07:jjP3oool00P3o
ool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3o
ool00`000000oooo0?ooo`1]0?ooo`8006KoA@3oool004@0oooo0P00I_mA0?ooo`030?oDV`1b^^X0
oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0
oooo06d0oooo0P00I_m50?ooo`00@`3oool3001Voe80oooo00H0^W8009_Do`3oool0onZj0780V`3D
ool;0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0K@3oool3001Vod@0oooo0013
0?ooo`8006KoD`3oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P00
00000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo06h0oooo0P00I_m40?ooo`00@`3oool2
001Vog40oooo00<000000?ooo`3oool0KP3oool2001Vod@0oooo00130?ooo`8006KoL@3oool00`00
0000oooo0?ooo`1^0?ooo`8006KoA03oool004<0oooo0P00I_ma0?ooo`030000003oool0oooo0280
oooo00<006Ko0?ooo`3oool0B@3oool2001Vod@0oooo00130?ooo`8006KoL@3oool00`000000oooo
0?ooo`0R0?ooo`8006KoBP3oool2001Vod@0oooo00130?ooo`8006KoBP3oool00`00I_l0oooo0?oo
o`0T0?ooo`030000003oool0oooo0280oooo0`00I_m90?ooo`8006KoA03oool004<0oooo00<006Ko
0?ooo`3oool0B03oool3001VobD0oooo00<000000?ooo`3oool08P3oool4001VodP0oooo0P00I_m4
0?ooo`00@P3oool2001VodT0oooo1000I_lU0?ooo`030000003oool0oooo0280oooo1000I_m80?oo
o`8006KoA03oool00480oooo0P00I_m80?ooo`D006Ko9@3oool00`000000oooo0?ooo`0R0?ooo`80
06Ko00<0oooo001Vo`00I_l0A`3oool2001Vod@0oooo00120?ooo`8006KoA`3oool3001Vo`030?oo
o`00I_l0oooo02D0oooo00<000000?ooo`3oool08P3oool2001Vo`80oooo0P00I_m60?ooo`8006Ko
A03oool00480oooo0P00I_m60?ooo`<006Ko00<0oooo001Vo`00I_l09P3oool00`000000oooo0?oo
o`0R0?ooo`8006Ko0`3oool2001VodD0oooo0P00I_m40?ooo`00@P3oool2001VodD0oooo0`00I_l2
0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0R0?ooo`8006Ko103oool2001Vod@0oooo0P00I_m4
0?ooo`00@P3oool2001Vod@0oooo0`00I_l30?ooo`8006Ko9P3oool2000002<0oooo0P00I_l40?oo
o`<006Ko@`3oool2001Vod@0oooo00120?ooo`8006Ko@`3oool3001Vo`@0oooo0P00I_lV0?ooo`03
0000003oool0oooo0280oooo0P00I_l50?ooo`<006Ko@P3oool2001Vod@0oooo00120?ooo`<006Ko
@@3oool3001Vo`D0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_l60?ooo`<006Ko
@@3oool2001Vod@0oooo00130?ooo`8006Ko@03oool3001Vo`H0oooo0P00I_lV0?ooo`030000003o
ool0oooo0280oooo0P00I_l70?ooo`<006Ko@03oool2001Vod@0oooo00130?ooo`8006Ko?`3oool3
001Vo`L0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_l80?ooo`@006Ko?P3oool2
001Vod@0oooo00130?ooo`8006Ko?P3oool3001Vo`P0oooo0P00I_lV0?ooo`030000003oool0oooo
0280oooo0P00I_l90?ooo`@006Ko?@3oool2001Vod@0oooo00130?ooo`<006Ko?03oool3001Vo`T0
oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_l;0?ooo`<006Ko?03oool2001Vod@0
oooo00140?ooo`8006Ko>`3oool3001Vo`X0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo
0P00I_l<0?ooo`<006Ko>P3oool3001Vod@0oooo00140?ooo`8006Ko>@3oool4001Vo`/0oooo0P00
I_lV0?ooo`030000003oool0oooo0280oooo0P00I_l=0?ooo`@006Ko>03oool2001VodD0oooo0014
0?ooo`8006Ko>03oool4001Vo``0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_l>
0?ooo`@006Ko=`3oool2001VodD0oooo00140?ooo`8006Ko=`3oool3001Vo`h0oooo0P00I_lV0?oo
o`030000003oool0oooo0280oooo0P00I_l@0?ooo`<006Ko=@3oool3001VodD0oooo00150?ooo`03
001Vo`3oool0oooo03@0oooo0`00I_l?0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0R0?ooo`80
06Ko4@3oool3001Voc@0oooo0P00I_m60?ooo`00A@3oool2001Voc<0oooo1000I_l@0?ooo`8006Ko
9P3oool00`000000oooo0?ooo`0R0?ooo`8006Ko4P3oool4001Voc80oooo0P00I_m60?ooo`00AP3o
ool2001Voc40oooo1000I_lA0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0R0?ooo`8006Ko4`3o
ool4001Voc40oooo00<006Ko0?ooo`3oool0A@3oool004L0oooo00<006Ko0?ooo`3oool0;@3oool4
001Voa<0oooo0P00I_lV0?ooo`030000003oool0oooo0280oooo0P00I_lE0?ooo`@006Ko;P3oool2
001VodL0oooo00170?ooo`8006Ko;@3oool4001Voa@0oooo0P00I_lV0?ooo`030000003oool0oooo
0280oooo0P00I_lF0?ooo`@006Ko;@3oool00`00I_l0oooo0?ooo`160?ooo`00B03oool00`00I_l0
oooo0?ooo`0Y0?ooo`@006Ko5P3oool2001VobH0oooo00<000000?ooo`3oool08P3oool2001VoaP0
oooo1000I_lZ0?ooo`8006KoB03oool004P0oooo0P00I_lY0?ooo`@006Ko5`3oool2001VobH0oooo
0P00000S0?ooo`8006Ko6@3oool5001VobP0oooo00<006Ko0?ooo`3oool0A`3oool004T0oooo0P00
I_lV0?ooo`@006Ko6@3oool3001VobD0oooo00<000000?ooo`3oool08P3oool2001Voa/0oooo1@00
I_lU0?ooo`8006KoB@3oool004T0oooo0`00I_lS0?ooo`D006Ko6`3oool2001VobD0oooo00<00000
0?ooo`3oool08P3oool2001Voad0oooo1000I_lS0?ooo`8006KoBP3oool004X0oooo1000I_lN0?oo
o`H006Ko7@3oool2001VobD0oooo00<000000?ooo`3oool08P3oool2001Voal0oooo1000I_lO0?oo
o`<006KoB`3oool004/0oooo1000I_lK0?ooo`H006Ko7`3oool2001VobD0oooo00<000000?ooo`3o
ool08P3oool2001Vob00oooo1@00I_lK0?ooo`D006KoB`3oool004d0oooo0`00I_lG0?ooo`H006Ko
8P3oool2001VobD0oooo00<000000?ooo`3oool08P3oool2001Vob80oooo1P00I_lG0?ooo`@006Ko
C@3oool004h0oooo1000I_lC0?ooo`H006Ko903oool2001VobD0oooo00<000000?ooo`3oool08P3o
ool2001Vob@0oooo2000I_lA0?ooo`@006KoC`3oool004l0oooo1`00I_l<0?ooo`H006Ko9`3oool2
001VobD0oooo00<000000?ooo`3oool08P3oool2001VobP0oooo1`00I_l:0?ooo`L006KoD03oool0
0540oooo5@00I_lY0?ooo`8006Ko9@3oool00`000000oooo0?ooo`0Q0?ooo`<006Ko;03ooolB001V
oe80oooo001E0?ooo`h006Ko;03oool2001VobD0oooo00<000000?ooo`3oool08@3oool2001Vobl0
oooo3000I_mF0?ooo`00S`3oool2001VobD0oooo00<000000?ooo`3oool08@3oool2001Voi40oooo
002@0?ooo`8006Ko903oool00`000000oooo0?ooo`0Q0?ooo`8006KoT@3oool00900oooo0P00I_lT
0?ooo`030000003oool0oooo0240oooo0P00I_nA0?ooo`00T03oool2001Vob@0oooo00<000000?oo
o`3oool08@3oool2001Voi40oooo002@0?ooo`8006Ko903oool00`000000oooo0?ooo`0Q0?ooo`80
06KoT@3oool00900oooo0P00I_lT0?ooo`030000003oool0oooo0240oooo0P00I_nA0?ooo`00T@3o
ool2001Vob<0oooo00<000000?ooo`3oool08@3oool2001Voi40oooo002A0?ooo`8006Ko8`3oool2
00000280oooo0P00I_nA0?ooo`00T@3oool2001Vob<0oooo00<000000?ooo`3oool08@3oool2001V
oi40oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0P0?ooo`8006KoTP3oool00940oooo
0P00I_lS0?ooo`030000003oool0oooo0200oooo0P00I_nB0?ooo`00TP3oool2001Vob80oooo00<0
00000?ooo`3oool0803oool2001Voi80oooo002B0?ooo`8006Ko8P3oool00`000000oooo0?ooo`0P
0?ooo`8006KoTP3oool00980oooo0P00I_lR0?ooo`030000003oool0oooo01l0oooo0`00I_nB0?oo
o`00TP3oool2001Vob80oooo00<000000?ooo`3oool07`3oool2001Voi<0oooo002B0?ooo`<006Ko
8@3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool009<0oooo0P00I_lQ0?ooo`030000003o
ool0oooo01l0oooo0P00I_nC0?ooo`00T`3oool2001Vob40oooo00<000000?ooo`3oool07`3oool2
001Voi<0oooo002C0?ooo`<006Ko803oool00`000000oooo0?ooo`0N0?ooo`<006KoT`3oool009@0
oooo0P00I_lP0?ooo`030000003oool0oooo01h0oooo0P00I_nD0?ooo`00U03oool2001Vob00oooo
00<000000?ooo`3oool07P3oool2001Voi@0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?oo
o`0M0?ooo`<006KoU03oool009D0oooo0P00I_lO0?ooo`030000003oool0oooo01d0oooo0P00I_nE
0?ooo`00U@3oool2001Voal0oooo0P00000N0?ooo`8006KoU@3oool009D0oooo0P00I_lO0?ooo`03
0000003oool0oooo01`0oooo0`00I_nE0?ooo`00U@3oool2001Voal0oooo00<000000?ooo`3oool0
703oool2001VoiH0oooo002F0?ooo`03001Vo`3oool0oooo01d0oooo00<000000?ooo`3oool0703o
ool2001VoiH0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0L0?ooo`03001Vo`3oool0
oooo09D0oooo002G0?ooo`03001Vo`3oool0oooo01`0oooo00<000000?ooo`3oool06`3oool2001V
oiL0oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0K0?ooo`03001Vo`3oool0oooo09H0
oooo002H0?ooo`03001Vo`3oool0oooo01/0oooo00<000000?ooo`3oool06P3oool2001VoiP0oooo
002H0?ooo`8006Ko703oool00`000000oooo0?ooo`0J0?ooo`03001Vo`3oool0oooo09L0oooo002I
0?ooo`03001Vo`3oool0oooo01X0oooo00<000000?ooo`3oool06P3oool00`00I_l0oooo0?ooo`2G
0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool06@3oool2001VoiT0oooo002J0?ooo`03
001Vo`3oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`00I_l0oooo0?ooo`2H0?ooo`00
VP3oool00`00I_l0oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo0P00I_nJ0?ooo`00VP3o
ool2001Vo`d0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003o
ool0oooo01P0oooo00<006Ko0?ooo`3oool0V@3oool009/0oooo00<006Ko0?ooo`3oool03P3oool0
0`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01L0oooo0P00I_nK0?ooo`00V`3oool2001V
o`l0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009`0
oooo0P00I_l>0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2001Void0
oooo002L0?ooo`<006Ko3@3oool00`2jLW80^^[o0?ooo`070?ooo`<000005@3oool00`00I_l0oooo
0?ooo`2L0?ooo`00W@3oool2001Vo`d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?oo
o`0D0?ooo`8006KoWP3oool009h0oooo0P00I_l<0?ooo`030;YbLP2jj_l0oooo00L0oooo00<00000
0?ooo`3oool04`3oool2001Voil0oooo002N0?ooo`<006Ko203oool01@3Z^W800000001b^P2jLW80
^^[o00P0oooo00<000000?ooo`3oool04P3oool2001Voj00oooo002O0?ooo`<006Ko2@3oool00`3Z
^W80001b0;[Zo`080?ooo`030000003oool0oooo0140oooo0`00I_nP0?ooo`00X03oool3001Voa<0
oooo00<000000?ooo`3oool0403oool3001Voj40oooo002Q0?ooo`<006Ko4P3oool00`000000oooo
0?ooo`0@0?ooo`8006KoXP3oool00:80oooo0`00I_lA0?ooo`030000003oool0oooo00l0oooo0P00
I_nS0?ooo`00X`3oool3001Voa00oooo00<000000?ooo`3oool03P3oool2001Voj@0oooo002T0?oo
o`<006Ko3`3oool00`000000oooo0?ooo`0=0?ooo`8006KoY@3oool00:D0oooo0`00I_l>0?ooo`03
0000003oool0oooo00`0oooo0`00I_nU0?ooo`00YP3oool4001Vo``0oooo00<000000?ooo`3oool0
2P3oool4001VojH0oooo002W0?ooo`@006Ko2`3oool00`000000oooo0?ooo`090?ooo`@006KoY`3o
ool00:T0oooo0`00I_l:0?ooo`030000003oool0oooo00H0oooo1@00I_nY0?ooo`00ZP3oool5001V
o`L0oooo00<000000?ooo`3oool0103oool6001VojX0oooo002[0?ooo`L006Ko103oool00`000000
oooo0?ooo`020?ooo`D006Ko[@3oool00:h0oooo4000I_n_0?ooo`00/@3oool;001Vok40oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00001\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.80909 .59091 m
.81447 .60055 L
.81899 .60982 L
.82314 .62025 L
.82498 .62614 L
.82635 .63161 L
.8269 .63435 L
.8274 .63737 L
.82779 .6404 L
.82795 .64206 L
.82807 .64361 L
.82819 .64646 L
.82821 .64905 L
.82818 .65048 L
.82811 .65203 L
.82789 .65484 L
.82756 .65757 L
.82715 .66003 L
.82589 .66546 L
.82427 .67038 L
.82234 .6749 L
.81635 .68487 L
.81255 .68956 L
.80778 .69442 L
.7979 .7022 L
.79293 .70531 L
.79017 .70685 L
.78716 .70842 L
.78561 .70933 L
.78633 .71134 L
.78764 .71495 L
.79038 .72229 L
.79588 .73682 L
.80854 .77288 L
.81338 .78971 L
.81567 .79908 L
.81753 .80789 L
.81897 .8161 L
.82003 .82357 L
.82048 .82754 L
.82088 .83184 L
.82121 .83636 L
.82141 .84062 L
.82151 .84513 L
.82149 .84933 L
.82143 .85172 L
.82134 .85389 L
.8212 .85638 L
.82103 .85873 L
.82058 .86336 L
Mistroke
.82002 .86759 L
.81925 .87215 L
.81824 .87691 L
.81594 .88521 L
.81319 .89263 L
.80999 .8994 L
.80653 .90533 L
.79804 .91609 L
.79279 .92101 L
.7866 .92562 L
.7795 .92971 L
.77224 .93282 L
.7653 .93496 L
.76122 .93589 L
.75735 .93657 L
.75393 .93702 L
.75019 .93735 L
.74658 .93753 L
.74323 .93756 L
.73944 .93747 L
.73524 .93721 L
.73079 .93675 L
.72659 .93616 L
.71771 .93442 L
.70948 .93226 L
.69064 .9254 L
.67171 .91601 L
.65178 .90353 L
.63492 .89088 L
.62586 .88328 L
.62148 .87939 L
.61824 .87758 L
.61794 .88388 L
.61752 .89077 L
.61652 .90294 L
.61524 .91456 L
.6135 .92691 L
.60856 .95256 L
.60492 .96683 L
.60094 .97988 L
.59297 1.00093 L
.58253 1.02203 L
.56983 1.04135 L
.55655 1.05637 L
.54971 1.06248 L
.54302 1.06753 L
.53678 1.07149 L
.53002 1.075 L
.52252 1.07801 L
.5155 1.08002 L
Mistroke
.51157 1.08082 L
.50788 1.08136 L
.50382 1.08171 L
.50154 1.0818 L
.49945 1.08182 L
.49527 1.08165 L
.49135 1.08126 L
.48784 1.08072 L
.48405 1.07992 L
.47994 1.0788 L
.47562 1.07735 L
.468 1.07405 L
.45478 1.06596 L
.44758 1.06018 L
.44111 1.05404 L
.42744 1.03766 L
.41636 1.02005 L
.4054 .99707 L
.39696 .97327 L
.39111 .95114 L
.38635 .926 L
.3846 .91324 L
.38317 .89952 L
.38228 .88774 L
.38209 .88453 L
.38192 .88112 L
.38064 .87746 L
.37607 .88158 L
.37171 .88537 L
.36342 .89221 L
.34465 .90596 L
.32698 .91674 L
.31041 .92494 L
.2926 .93163 L
.28334 .93418 L
.27826 .93529 L
.27361 .93613 L
.26883 .9368 L
.26634 .93707 L
.26371 .93729 L
.26123 .93744 L
.25891 .93753 L
.25465 .93755 L
.25051 .9374 L
.24678 .93709 L
.24277 .93659 L
.23865 .93587 L
.23197 .93421 L
.22519 .93183 L
.21916 .92902 L
Mistroke
.21401 .92602 L
.20837 .92196 L
.20279 .91694 L
.1941 .90629 L
.19048 .90029 L
.18713 .89339 L
.18469 .88709 L
.1825 .87989 L
.18141 .87539 L
.18056 .87111 L
.17984 .86661 L
.17932 .86245 L
.17893 .85831 L
.17868 .85436 L
.17853 .85015 L
.17849 .84775 L
.17849 .84554 L
.17857 .84131 L
.17877 .83675 L
.17907 .83241 L
.17943 .82845 L
.18063 .8187 L
.18217 .80947 L
.18621 .79127 L
.19174 .77199 L
.20314 .73943 L
.20865 .72486 L
.21094 .71879 L
.21218 .71544 L
.2133 .71237 L
.21436 .70942 L
.21169 .70784 L
.20594 .70464 L
.19514 .69699 L
.18981 .69208 L
.18539 .68712 L
.1817 .68206 L
.17877 .6771 L
.17646 .67222 L
.17477 .66762 L
.17333 .6624 L
.17275 .65948 L
.17232 .65667 L
.17203 .65395 L
.17184 .65104 L
.17178 .64827 L
.17183 .64575 L
.1719 .6442 L
.17199 .64277 L
.17213 .6412 L
Mistroke
.17231 .63955 L
.17269 .63675 L
.17322 .63369 L
.17444 .62827 L
.17584 .62336 L
.17986 .61245 L
.1841 .60332 L
.18658 .59857 L
.18938 .59354 L
.19089 .59088 L
.18948 .58844 L
.18677 .5836 L
.18133 .5727 L
.17711 .56227 L
.17416 .5524 L
.17304 .54714 L
.17256 .54419 L
.17222 .54152 L
.17196 .53859 L
.17186 .53693 L
.17181 .53542 L
.17179 .53263 L
.1719 .5297 L
.17212 .52691 L
.17229 .52535 L
.17249 .52393 L
.17352 .51862 L
.1743 .5157 L
.17532 .51256 L
.17763 .50699 L
.18008 .50236 L
.18321 .49756 L
.19013 .48941 L
.20038 .4808 L
.20597 .47716 L
.20885 .4755 L
.21156 .47405 L
.21441 .47254 L
.21334 .46955 L
.21085 .46278 L
.2051 .4476 L
.19298 .41372 L
.18786 .39674 L
.1838 .38037 L
.18199 .37134 L
.18062 .36305 L
.17947 .35384 L
.17902 .34878 L
.17885 .34631 L
.17871 .344 L
Mistroke
.17855 .33993 L
.17849 .33627 L
.17851 .33235 L
.17865 .32815 L
.17886 .3245 L
.17918 .32069 L
.17954 .31746 L
.18002 .31397 L
.18145 .30625 L
.18353 .29829 L
.18602 .29111 L
.18875 .2849 L
.19616 .27261 L
.20067 .2671 L
.20625 .26164 L
.21145 .25753 L
.21754 .25367 L
.22372 .25061 L
.22973 .24832 L
.2333 .24723 L
.23722 .24625 L
.24102 .24551 L
.24455 .24498 L
.2488 .24454 L
.25125 .24438 L
.25352 .24429 L
.25777 .24426 L
.26235 .24444 L
.26682 .2448 L
.26936 .24508 L
.27169 .2454 L
.28067 .24703 L
.28578 .24825 L
.29141 .24983 L
.30179 .25336 L
.32247 .26266 L
.34197 .27409 L
.35942 .28647 L
.36874 .29394 L
.37725 .30128 L
.38162 .30526 L
.382 .29913 L
.38241 .29216 L
.38289 .28553 L
.3841 .27291 L
.38554 .26138 L
.39008 .23538 L
.39347 .22097 L
.39714 .20797 L
.40462 .18669 L
Mistroke
.41434 .16552 L
.42503 .14761 L
.43599 .13333 L
.45001 .11957 L
.45844 .1133 L
.46653 .10852 L
.47448 .1049 L
.48183 .10247 L
.48594 .10148 L
.48811 .10105 L
.4904 .10069 L
.49464 .10021 L
.49855 .10002 L
.50249 .10005 L
.50471 .10017 L
.50677 .10034 L
.51054 .10083 L
.51453 .10158 L
.51808 .10244 L
.52139 .10343 L
.52886 .10629 L
.53674 .11031 L
.54379 .11482 L
.55889 .12777 L
.57013 .14086 L
.58125 .15757 L
.5914 .17731 L
.59939 .19738 L
.60658 .22116 L
.60965 .23412 L
.61237 .24806 L
.61431 .26034 L
.61601 .27389 L
.61716 .28617 L
.61792 .29757 L
.6182 .3032 L
.6212 .30268 L
.6255 .29886 L
.62953 .29539 L
.64559 .28271 L
.66491 .26977 L
.68286 .25998 L
.70252 .2518 L
.71268 .24866 L
.71778 .24738 L
.72318 .24625 L
.72787 .24546 L
.73209 .24491 L
.73627 .24453 L
.74017 .24432 L
Mistroke
.74463 .24426 L
.74867 .24438 L
.75302 .2447 L
.75518 .24495 L
.75753 .24527 L
.76123 .24593 L
.76502 .24679 L
.77155 .24875 L
.77819 .25147 L
.78495 .25514 L
.79039 .25889 L
.79573 .26344 L
.8041 .27296 L
.80832 .27941 L
.81213 .28677 L
.81486 .29346 L
.8173 .3012 L
.81929 .3099 L
.82012 .31494 L
.82071 .31963 L
.82111 .32405 L
.82127 .32657 L
.82138 .32893 L
.8215 .33328 L
.82151 .33572 L
.82149 .33794 L
.82136 .34237 L
.82125 .3446 L
.8211 .34706 L
.82076 .35143 L
.82035 .35551 L
.81912 .36476 L
.81739 .37464 L
.81326 .39259 L
.80867 .40852 L
.79833 .43847 L
.79264 .45356 L
.78998 .46057 L
.78768 .46677 L
.78645 .47013 L
.78618 .47292 L
.78927 .47448 L
.79253 .47628 L
.7986 .48009 L
.8045 .48453 L
.80944 .48898 L
.81343 .49327 L
.81987 .50228 L
.82233 .5069 L
.82453 .51213 L
Mistroke
.82544 .51483 L
.82627 .51775 L
.82686 .52031 L
.82739 .52312 L
.82778 .52594 L
.82803 .52856 L
.82817 .53108 L
.82822 .53377 L
.82817 .53618 L
.82805 .53845 L
.82784 .54095 L
.82752 .54364 L
.82706 .54659 L
.82654 .54933 L
.82503 .55553 L
.82076 .56788 L
.816 .57829 L
.81017 .58905 L
.80909 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;40oooo2`00I_na0?oo
o`00[03ooolE001Voj`0oooo002Z0?ooo`P006Ko103oool00`000000oooo0?ooo`020?ooo`L006Ko
Z`3oool00:P0oooo1@00I_l90?ooo`030000003oool0oooo00L0oooo1000I_nY0?ooo`00Y`3oool4
001Vo`/0oooo00<000000?ooo`3oool0203oool4001VojP0oooo002U0?ooo`@006Ko3@3oool00`00
0000oooo0?ooo`0:0?ooo`@006KoYP3oool00:@0oooo1000I_l>0?ooo`030000003oool0oooo00/0
oooo1000I_nU0?ooo`00X`3oool3001Voa00oooo00<000000?ooo`3oool03@3oool3001Voj@0oooo
002R0?ooo`<006Ko4@3oool00`000000oooo0?ooo`0>0?ooo`@006KoXP3oool00:00oooo1000I_lB
0?ooo`030000003oool0oooo00l0oooo1000I_nQ0?ooo`00W`3oool4001Vo`H0oooo00<0omBK0000
000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo0140oooo0`00I_nP0?oo
o`00WP3oool3001Vo`/0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0B0?ooo`<0
06KoW`3oool009d0oooo0`00I_l<0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0
4`3oool2001Voil0oooo002L0?ooo`<006Ko3@3oool00`2jLW80^^[o0?ooo`070?ooo`<00000503o
ool2001Voih0oooo002L0?ooo`8006Ko0P3oool00`2jLP0000000000000300000003001b^P3oool0
oooo00<0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0D0?ooo`<006KoW@3oool0
09/0oooo0P00I_l?0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool2001V
oid0oooo002J0?ooo`<006Ko3`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0
oooo0P00I_nL0?ooo`00V@3oool3001Vo`d0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`03
0000003oool0oooo01L0oooo0P00I_nK0?ooo`00V@3oool2001Voa00oooo00<0j[Yb0000LP2jj_l0
203oool00`000000oooo0?ooo`0H0?ooo`03001Vo`3oool0oooo09T0oooo002H0?ooo`<006Ko6`3o
ool00`000000oooo0?ooo`0H0?ooo`8006KoVP3oool009P0oooo0P00I_lL0?ooo`030000003oool0
oooo01T0oooo0P00I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06P3oool00`00
I_l0oooo0?ooo`2G0?ooo`00U`3oool2001Voad0oooo00<000000?ooo`3oool06P3oool2001VoiP0
oooo002G0?ooo`8006Ko7@3oool00`000000oooo0?ooo`0K0?ooo`03001Vo`3oool0oooo09H0oooo
002G0?ooo`03001Vo`3oool0oooo01`0oooo00<000000?ooo`3oool06`3oool2001VoiL0oooo002F
0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009H0oooo00<006Ko0?oo
o`3oool07@3oool00`000000oooo0?ooo`0M0?ooo`03001Vo`3oool0oooo09@0oooo002E0?ooo`80
06Ko7`3oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009D0oooo00<006Ko0?ooo`3oool0
7P3oool00`000000oooo0?ooo`0N0?ooo`03001Vo`3oool0oooo09<0oooo002D0?ooo`8006Ko803o
ool00`000000oooo0?ooo`0N0?ooo`8006KoU03oool009@0oooo00<006Ko0?ooo`3oool07`3oool2
000001l0oooo0P00I_nD0?ooo`00T`3oool2001Vob40oooo00<000000?ooo`3oool07P3oool3001V
oi<0oooo002B0?ooo`<006Ko8@3oool00`000000oooo0?ooo`0O0?ooo`8006KoT`3oool00980oooo
0P00I_lR0?ooo`030000003oool0oooo01l0oooo0`00I_nB0?ooo`00T@3oool3001Vob80oooo00<0
00000?ooo`3oool0803oool2001Voi80oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0P
0?ooo`8006KoTP3oool00940oooo0P00I_lS0?ooo`030000003oool0oooo0200oooo0`00I_nA0?oo
o`00T03oool3001Vob<0oooo00<000000?ooo`3oool08@3oool2001Voi40oooo002@0?ooo`8006Ko
903oool00`000000oooo0?ooo`0Q0?ooo`8006KoT@3oool008l0oooo0`00I_lT0?ooo`030000003o
ool0oooo0240oooo0`00I_n@0?ooo`00S`3oool2001VobD0oooo00<000000?ooo`3oool08P3oool2
001Voi00oooo002?0?ooo`8006Ko9@3oool00`000000oooo0?ooo`0R0?ooo`<006KoS`3oool008l0
oooo0P00I_lU0?ooo`030000003oool0oooo02<0oooo0P00I_n?0?ooo`00S`3oool2001VobD0oooo
00<000000?ooo`3oool08`3oool2001Vohl0oooo002>0?ooo`8006Ko9P3oool00`000000oooo0?oo
o`0S0?ooo`8006KoS`3oool008h0oooo0P00I_lV0?ooo`030000003oool0oooo02@0oooo0P00I_n>
0?ooo`00SP3oool2001VobH0oooo00<000000?ooo`3oool0903oool2001Vohh0oooo002>0?ooo`80
06Ko9P3oool2000002D0oooo0P00I_n>0?ooo`00SP3oool2001VobH0oooo00<000000?ooo`3oool0
903oool2001Vohh0oooo002=0?ooo`8006Ko9`3oool00`000000oooo0?ooo`0T0?ooo`8006KoSP3o
ool008d0oooo0P00I_lW0?ooo`030000003oool0oooo02D0oooo0P00I_n=0?ooo`00S@3oool2001V
obL0oooo00<000000?ooo`3oool09@3oool2001Vohd0oooo002=0?ooo`8006Ko9`3oool00`000000
oooo0?ooo`0U0?ooo`8006KoS@3oool005D0oooo4P00I_lV0?ooo`8006Ko9`3oool00`000000oooo
0?ooo`0U0?ooo`8006Ko9@3ooolB001VoeH0oooo001A0?oooaX006Ko8@3oool2001VobP0oooo00<0
00000?ooo`3oool09@3oool2001Vob00oooo7000I_mA0?ooo`00C`3oool7001Voa00oooo2000I_lN
0?ooo`8006Ko:03oool00`000000oooo0?ooo`0U0?ooo`8006Ko7@3oool9001Voa00oooo1`00I_m@
0?ooo`00CP3oool4001VoaP0oooo1`00I_lK0?ooo`8006Ko:03oool00`000000oooo0?ooo`0U0?oo
o`8006Ko6`3oool6001VoaX0oooo1000I_m>0?ooo`00C@3oool3001Voah0oooo1P00I_lH0?ooo`80
06Ko:03oool00`000000oooo0?ooo`0U0?ooo`8006Ko603oool6001Voah0oooo1@00I_m<0?ooo`00
B`3oool4001Vob40oooo1P00I_lF0?ooo`8006Ko:03oool00`000000oooo0?ooo`0U0?ooo`8006Ko
5P3oool6001Vob80oooo1000I_m;0?ooo`00BP3oool4001VobD0oooo1000I_lD0?ooo`8006Ko:@3o
ool00`000000oooo0?ooo`0U0?ooo`8006Ko5@3oool4001VobL0oooo0`00I_m:0?ooo`00B@3oool3
001VobT0oooo1000I_lB0?ooo`8006Ko:@3oool00`000000oooo0?ooo`0V0?ooo`8006Ko4P3oool4
001VobX0oooo0`00I_m90?ooo`00B03oool3001Vob/0oooo1000I_lA0?ooo`8006Ko:@3oool00`00
0000oooo0?ooo`0V0?ooo`8006Ko4@3oool4001Vob`0oooo0`00I_m80?ooo`00A`3oool3001Vobh0
oooo1000I_l?0?ooo`8006Ko:@3oool00`000000oooo0?ooo`0V0?ooo`8006Ko403oool3001Vobl0
oooo0`00I_m70?ooo`00A`3oool2001Voc00oooo1000I_l>0?ooo`8006Ko:@3oool2000002L0oooo
0P00I_l>0?ooo`@006Ko<@3oool3001VodH0oooo00160?ooo`8006Ko<`3oool4001Vo``0oooo0P00
I_lY0?ooo`030000003oool0oooo02H0oooo0P00I_l=0?ooo`@006Ko<`3oool2001VodH0oooo0015
0?ooo`8006Ko=@3oool4001Vo`/0oooo0P00I_lY0?ooo`030000003oool0oooo02H0oooo0P00I_l;
0?ooo`@006Ko=@3oool2001VodH0oooo00150?ooo`03001Vo`3oool0oooo03H0oooo1000I_l90?oo
o`8006Ko:@3oool00`000000oooo0?ooo`0V0?ooo`8006Ko2P3oool4001VocH0oooo0`00I_m50?oo
o`00A03oool2001VocT0oooo1@00I_l70?ooo`8006Ko:@3oool00`000000oooo0?ooo`0V0?ooo`80
06Ko203oool4001VocT0oooo0`00I_m40?ooo`00A03oool00`00I_l0oooo0?ooo`0j0?ooo`@006Ko
1@3oool2001VobX0oooo00<000000?ooo`3oool09P3oool3001Vo`H0oooo1000I_lk0?ooo`<006Ko
@`3oool004<0oooo0P00I_ln0?ooo`<006Ko103oool2001VobX0oooo00<000000?ooo`3oool09`3o
ool2001Vo`@0oooo1000I_ln0?ooo`8006Ko@`3oool004<0oooo00<006Ko0?ooo`3oool0?P3oool3
001Vo`<0oooo0P00I_lZ0?ooo`030000003oool0oooo02L0oooo0P00I_l30?ooo`@006Ko?`3oool2
001Vod<0oooo00120?ooo`8006Ko@@3oool3001Vo`80oooo0P00I_lZ0?ooo`030000003oool0oooo
02L0oooo0P00I_l20?ooo`<006Ko@@3oool2001Vod<0oooo00120?ooo`03001Vo`3oool0oooo0440
oooo1P00I_lZ0?ooo`030000003oool0oooo02L0oooo0P00I_l0103oool006Ko001Vo`00I_m20?oo
o`8006Ko@`3oool00440oooo0P00I_m40?ooo`D006Ko:P3oool00`000000oooo0?ooo`0W0?ooo`D0
06Ko@`3oool3001Vod80oooo00110?ooo`8006KoAP3oool3001VobX0oooo00<000000?ooo`3oool0
9`3oool4001VodD0oooo0P00I_m20?ooo`00@@3oool2001VodL0oooo0P00I_lZ0?ooo`030000003o
ool0oooo02L0oooo0`00I_m60?ooo`8006Ko@P3oool00440oooo0P00I_m80?ooo`03001Vo`3oool0
oooo02P0oooo00<000000?ooo`3oool0L03oool2001Vod80oooo00110?ooo`8006KoL`3oool00`00
0000oooo0?ooo`1`0?ooo`8006Ko@P3oool00400oooo0`00I_mc0?ooo`030000003oool0oooo0740
oooo00<006Ko0?ooo`3oool0@03oool00400oooo0P00I_md0?ooo`030000003oool0oooo0740oooo
0P00I_m10?ooo`00@03oool2001Vog@0oooo0P00001c0?ooo`03001Vo`3oool0oooo03l0oooo0010
0?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md0?oo
o`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3o
ool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko
@@3oool00400oooo0P00I_md0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2
001Vog@0oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`00
0000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md0?ooo`030000003oool0oooo0740
oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo
00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md
0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?oo
o`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoEP3oool01@3oe9/00000000000000000VmCo
00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo00<00000
0?ooo`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoEP3oool01P2jLY/0e?oo0?ooo`3oom@0
V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002K
e?l01P3oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_mE0?ooo`030?oD
V`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000
003oool0oooo0740oooo0P00I_m10?ooo`00@03oool3001Voe@0oooo00<0j[Yb07:jjP3oool00P3o
ool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo0`00001a0?ooo`8006Ko@@3o
ool00440oooo0P00I_m;0?ooo`030;Yb00000000000000<0000000D007:j0?ooo`3oool0j[Yb07:j
jP030?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3oool00`000000oooo0?oo
o`1`0?ooo`<006Ko@@3oool00440oooo0P00I_mD0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<00000
0?ooo`3oool0L03oool2001Vod80oooo00110?ooo`8006KoE03oool00`3oe9/0L[[Z0?ooo`020?oo
o`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1`0?oo
o`8006Ko@P3oool00440oooo0P00I_mE0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool0
0`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo06l0oooo0`00I_m20?ooo`00@@3oool2001V
oeD0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K
0=Coo`3oool01@3oool00`000000oooo0?ooo`1_0?ooo`8006Ko@`3oool00440oooo0`00I_mb0?oo
o`030000003oool0oooo06l0oooo0P00I_m30?ooo`00@P3oool2001Vog80oooo00<000000?ooo`3o
ool0K`3oool2001Vod<0oooo00120?ooo`8006KoLP3oool00`000000oooo0?ooo`1_0?ooo`8006Ko
@`3oool00480oooo0`00I_ma0?ooo`030000003oool0oooo06l0oooo0P00I_m30?ooo`00@`3oool2
001Vog40oooo00<000000?ooo`3oool0K`3oool2001Vod<0oooo00130?ooo`8006KoL@3oool00`00
0000oooo0?ooo`1^0?ooo`8006KoA03oool004<0oooo0`00I_m`0?ooo`030000003oool0oooo06h0
oooo0P00I_m40?ooo`00A03oool2001Vog00oooo00<000000?ooo`3oool0KP3oool2001Vod@0oooo
00140?ooo`8006KoL03oool00`000000oooo0?ooo`1]0?ooo`<006KoA03oool004@0oooo0`00I_m_
0?ooo`030000003oool0oooo06d0oooo0P00I_m50?ooo`00A@3oool2001Vofl0oooo00<000000?oo
o`3oool0K@3oool2001VodD0oooo00150?ooo`8006KoK`3oool2000006d0oooo0`00I_m50?ooo`00
A@3oool3001Vofh0oooo00<000000?ooo`3oool0K03oool2001VodH0oooo00160?ooo`8006KoKP3o
ool00`000000oooo0?ooo`1[0?ooo`<006KoAP3oool004H0oooo0P00I_m^0?ooo`030000003oool0
oooo06/0oooo0P00I_m70?ooo`00AP3oool3001Vofd0oooo00<000000?ooo`3oool0J`3oool2001V
odL0oooo00170?ooo`8006KoK@3oool00`000000oooo0?ooo`1Z0?ooo`<006KoA`3oool004L0oooo
0P00I_m]0?ooo`030000003oool0oooo06X0oooo0P00I_m80?ooo`00A`3oool2001Vofd0oooo00<0
00000?ooo`3oool0J@3oool3001VodP0oooo00170?ooo`<006KoK03oool00`000000oooo0?ooo`1Y
0?ooo`8006KoB@3oool004P0oooo0P00I_m/0?ooo`030000003oool0oooo06T0oooo0P00I_m90?oo
o`00B03oool2001Vof`0oooo00<000000?ooo`3oool0J03oool3001VodT0oooo00180?ooo`<006Ko
J`3oool00`000000oooo0?ooo`1X0?ooo`8006KoBP3oool004T0oooo0P00I_m[0?ooo`030000003o
ool0oooo06P0oooo0P00I_m:0?ooo`00B@3oool2001Vof/0oooo00<000000?ooo`3oool0I`3oool3
001VodX0oooo00190?ooo`<006KoJP3oool00`000000oooo0?ooo`1W0?ooo`8006KoB`3oool004X0
oooo0P00I_mZ0?ooo`030000003oool0oooo06L0oooo0P00I_m;0?ooo`00BP3oool2001VofX0oooo
0P00001W0?ooo`<006KoB`3oool004X0oooo0`00I_mY0?ooo`030000003oool0oooo06H0oooo0P00
I_m<0?ooo`00B`3oool2001VofT0oooo00<000000?ooo`3oool0IP3oool2001Vod`0oooo001;0?oo
o`<006KoJ03oool00`000000oooo0?ooo`1U0?ooo`<006KoC03oool004`0oooo0P00I_mX0?ooo`03
0000003oool0oooo06D0oooo0P00I_m=0?ooo`00C03oool2001VofP0oooo00<000000?ooo`3oool0
I@3oool2001Vodd0oooo001<0?ooo`<006KoI`3oool00`000000oooo0?ooo`1T0?ooo`<006KoC@3o
ool004`0oooo1000I_mV0?ooo`030000003oool0oooo06@0oooo0`00I_m=0?ooo`00B`3oool6001V
ofD0oooo00<000000?ooo`3oool0I@3oool4001Vod/0oooo00190?ooo`@006KoJ@3oool00`000000
oooo0?ooo`1V0?ooo`D006KoB@3oool004P0oooo1000I_mZ0?ooo`030000003oool0oooo06P0oooo
1@00I_m70?ooo`00AP3oool4001Vof`0oooo00<000000?ooo`3oool0JP3oool4001VodH0oooo0015
0?ooo`@006KoK@3oool00`000000oooo0?ooo`1/0?ooo`<006KoA@3oool004@0oooo0`00I_m_0?oo
o`030000003oool0oooo06d0oooo0`00I_m40?ooo`00@`3oool3001Vog00oooo00<000000?ooo`3o
ool0KP3oool2001Vod@0oooo00120?ooo`<006KoL@3oool00`000000oooo0?ooo`1_0?ooo`8006Ko
@`3oool00480oooo0P00I_mb0?ooo`030000003oool0oooo0700oooo00<006Ko0?ooo`3oool0@@3o
ool00440oooo0P00I_mc0?ooo`800000L@3oool2001Vod80oooo00100?ooo`8006KoM03oool00`00
0000oooo0?ooo`1a0?ooo`8006Ko@@3oool003l0oooo0`00I_md0?ooo`030000003oool0oooo0740
oooo0P00I_m10?ooo`00?`3oool2001VogD0oooo00<000000?ooo`3oool0LP3oool2001Vod00oooo
000o0?ooo`8006KoM@3oool00`000000oooo0?ooo`1b0?ooo`8006Ko@03oool003h0oooo0`00I_me
0?ooo`030000003oool0oooo0780oooo0`00I_lo0?ooo`00?P3oool2001VogH0oooo00<000000?oo
o`3oool0L`3oool2001Vocl0oooo000n0?ooo`8006KoMP3oool00`000000oooo0?ooo`1c0?ooo`80
06Ko?`3oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?P3o
ool00`00I_l0oooo0?ooo`1e0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?@3oool2
001VogL0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000m0?ooo`8006KoM`3oool00`00
0000oooo0?ooo`1c0?ooo`8006Ko?`3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07<0
oooo0P00I_lo0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo
000m0?ooo`8006KoM`3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003d0oooo0P00I_mg
0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?@3oool3001VogH0oooo0P00001d0?oo
o`8006Ko?`3oool00140oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0T0?ooo`80
06Ko703oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3D
V`000000000000000000VmCo04<0oooo00<000000?ooo`3oool0A03oool01@3oe9/0000000000000
0000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo01P0oooo
0P00I_lZ0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0303oool001@0oooo00<0
^W9b0;[Zo`3oool09`3oool2001Voa`0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`03
0=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo0480oooo00<00000
0?ooo`3oool0A03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0
103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l05`3oool2001Vobd0oooo00<0^W9b0;[Z
o`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool09`3oool3001VoaX0oooo00<0omBK002Ke03o
ool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?ooo`3o
ool0@`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03o
ool05P3oool2001Vobd0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0
:03oool2001VoaX0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oD
V`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oD
V`00Vm@0oooo00l0oooo00<0omBK002Ke03oool05P3oool00`00I_l0oooo0?ooo`0/0?ooo`030;Yb
LP2jj_l0oooo00l0oooo00080?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3o
ool00`2jLW80^^[o0?ooo`0X0?ooo`8006Ko4@3oool00`2jLP0000000000000300000005001b^P3o
ool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo0440oooo
00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo
00<0^W8009_Do`3oool05@3oool2001Vobh0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0
^W9b0;[Zo`3oool0:03oool2001VoaX0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool0@@3oool00`000000oooo0?oo
o`130?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`000000
00020000000307:jjP3oool0oooo01D0oooo0P00I_l^0?ooo`030;YbLP2jj_l0oooo00l0oooo000D
0?ooo`030;YbLP2jj_l0oooo02T0oooo00<006Ko0?ooo`3oool0603oool00`3oe9/0L[[Z0?ooo`02
0?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0AP3oool00`000000oooo0?ooo`13
0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`0J
0?ooo`8006Ko;P3oool00`2jLW80^^[o0?ooo`0?0?ooo`004@3oool01@3Z^W800000001b^P2jLW80
^^[o02X0oooo0P00I_lJ0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K
0=Coo`160?ooo`030000003oool0oooo04@0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?oo
o`030?ooe02K09/0e?oo01X0oooo0P00I_l[0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0403oool0
01<0oooo00<0j[Yb0000LP2jj_l0:`3oool2001VoaT0oooo00D0oooD09/000000000001b0;[Zo`0<
0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool0@@3oool00`000000oooo0?ooo`14
0?ooo`050?ooe02K000000000000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3D
ool0oooo01@0oooo0P00I_l^0?ooo`030>ZjLP000780^^[o0100oooo00120?ooo`03001Vo`3oool0
oooo0740oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo00120?ooo`8006KoLP3oool00`00
0000oooo0?ooo`1`0?ooo`8006Ko@P3oool004<0oooo00<006Ko0?ooo`3oool0L03oool00`000000
oooo0?ooo`1`0?ooo`03001Vo`3oool0oooo0440oooo00130?ooo`8006KoL@3oool00`000000oooo
0?ooo`1_0?ooo`8006Ko@`3oool004@0oooo00<006Ko0?ooo`3oool0K`3oool00`000000oooo0?oo
o`1_0?ooo`03001Vo`3oool0oooo0480oooo00140?ooo`8006KoL03oool00`000000oooo0?ooo`1^
0?ooo`8006KoA03oool004D0oooo00<006Ko0?ooo`3oool0KP3oool00`000000oooo0?ooo`1]0?oo
o`8006KoA@3oool004@000000P00I_oO000000<006KoA@00000000030000003oool0oooo00d0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo
00@000000?ooo`00I_l006Ko303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0:0?ooo`8006Ko0P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0>0?ooo`400000000@0?ooo`030000003oool0oooo0340oooo0P00I_lM0?ooo`030000
003oool0oooo0500oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0K0?ooo`03001V
o`3oool0oooo0340oooo00<000000?ooo`3oool03`3oool004@0oooo00<006Ko0?ooo`3oool0K`3o
ool00`000000oooo0?ooo`1^0?ooo`8006KoA03oool004<0oooo0P00I_ma0?ooo`030000003oool0
oooo06l0oooo00<006Ko0?ooo`3oool0@P3oool004<0oooo00<006Ko0?ooo`3oool0L03oool00`00
0000oooo0?ooo`1_0?ooo`8006Ko@`3oool00480oooo0P00I_mb0?ooo`030000003oool0oooo0700
oooo0P00I_m20?ooo`00@@3oool2001Vog<0oooo00<000000?ooo`3oool0L@3oool00`00I_l0oooo
0?ooo`100?ooo`00@@3oool00`00I_l0oooo0?ooo`1b0?ooo`030000003oool0oooo0740oooo0P00
I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0LP3oool00`00I_l0oooo0?ooo`0o
0?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0LP3oool2001Vod00oooo00100?ooo`80
06KoM03oool00`000000oooo0?ooo`1c0?ooo`03001Vo`3oool0oooo03h0oooo00100?ooo`03001V
o`3oool0oooo07<0oooo00<000000?ooo`3oool0LP3oool2001Vod00oooo000o0?ooo`8006KoM@3o
ool00`000000oooo0?ooo`1c0?ooo`03001Vo`3oool0oooo03h0oooo000o0?ooo`03001Vo`3oool0
oooo07@0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000n0?ooo`8006KoMP3oool00`00
0000oooo0?ooo`1d0?ooo`03001Vo`3oool0oooo03d0oooo000n0?ooo`8006KoMP3oool00`000000
oooo0?ooo`1c0?ooo`8006Ko?`3oool003d0oooo0`00I_mf0?ooo`800000M03oool2001Vocl0oooo
000m0?ooo`8006KoM`3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003d0oooo0P00I_mg
0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?@3oool2001VogL0oooo00<000000?oo
o`3oool0L`3oool2001Vocl0oooo000m0?ooo`8006KoM`3oool00`000000oooo0?ooo`1c0?ooo`80
06Ko?`3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?@3o
ool2001VogL0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000m0?ooo`8006KoM`3oool0
0`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003d0oooo0`00I_mf0?ooo`030000003oool0oooo
07<0oooo0P00I_lo0?ooo`00?P3oool2001VogH0oooo00<000000?ooo`3oool0L`3oool2001Vocl0
oooo000n0?ooo`8006KoMP3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003l0oooo00<0
06Ko0?ooo`3oool0M03oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003l0oooo0P00I_me
0?ooo`030000003oool0oooo07<0oooo00<006Ko0?ooo`3oool0?P3oool00400oooo0P00I_md0?oo
o`030000003oool0oooo0780oooo0P00I_m00?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3o
ool0LP3oool00`00I_l0oooo0?ooo`0o0?ooo`00@@3oool2001Vog<0oooo00<000000?ooo`3oool0
L@3oool2001Vod40oooo00120?ooo`03001Vo`3oool0oooo0740oooo0P00001a0?ooo`8006Ko@P3o
ool00480oooo0P00I_mb0?ooo`030000003oool0oooo0700oooo00<006Ko0?ooo`3oool0@@3oool0
04<0oooo0P00I_ma0?ooo`030000003oool0oooo06l0oooo0P00I_m30?ooo`00@`3oool3001Vog00
oooo00<000000?ooo`3oool0KP3oool2001Vod@0oooo00140?ooo`<006KoK`3oool00`000000oooo
0?ooo`1]0?ooo`<006KoA03oool004D0oooo0`00I_m^0?ooo`030000003oool0oooo06`0oooo0`00
I_m50?ooo`00AP3oool3001Vofd0oooo00<000000?ooo`3oool0JP3oool4001VodH0oooo00170?oo
o`@006KoJ`3oool00`000000oooo0?ooo`1Y0?ooo`@006KoA`3oool004P0oooo1000I_mZ0?ooo`03
0000003oool0oooo06P0oooo0`00I_m90?ooo`00BP3oool4001VofP0oooo00<000000?ooo`3oool0
I@3oool5001VodX0oooo001;0?ooo`D006KoIP3oool00`000000oooo0?ooo`1T0?ooo`D006KoB`3o
ool004`0oooo0`00I_mW0?ooo`030000003oool0oooo06@0oooo0`00I_m=0?ooo`00C03oool2001V
ofP0oooo00<000000?ooo`3oool0I@3oool3001Vod`0oooo001<0?ooo`8006KoJ03oool00`000000
oooo0?ooo`1V0?ooo`8006KoC03oool004`0oooo00<006Ko0?ooo`3oool0I`3oool00`000000oooo
0?ooo`1V0?ooo`8006KoC03oool004/0oooo0P00I_mY0?ooo`030000003oool0oooo06H0oooo0`00
I_m;0?ooo`00B`3oool2001VofT0oooo00<000000?ooo`3oool0I`3oool2001Vod/0oooo001;0?oo
o`8006KoJ@3oool2000006P0oooo0P00I_m;0?ooo`00BP3oool3001VofT0oooo00<000000?ooo`3o
ool0I`3oool3001VodX0oooo001:0?ooo`8006KoJP3oool00`000000oooo0?ooo`1X0?ooo`8006Ko
BP3oool004X0oooo0P00I_mZ0?ooo`030000003oool0oooo06P0oooo0`00I_m90?ooo`00B@3oool3
001VofX0oooo00<000000?ooo`3oool0J@3oool2001VodT0oooo00190?ooo`8006KoJ`3oool00`00
0000oooo0?ooo`1Y0?ooo`8006KoB@3oool004P0oooo0`00I_m[0?ooo`030000003oool0oooo06T0
oooo0`00I_m80?ooo`00B03oool2001Vof`0oooo00<000000?ooo`3oool0JP3oool2001VodP0oooo
00180?ooo`8006KoK03oool00`000000oooo0?ooo`1Z0?ooo`8006KoB03oool004L0oooo0`00I_m/
0?ooo`030000003oool0oooo06X0oooo0P00I_m80?ooo`00A`3oool2001Vofd0oooo00<000000?oo
o`3oool0JP3oool3001VodL0oooo00160?ooo`<006KoK@3oool00`000000oooo0?ooo`1[0?ooo`80
06KoA`3oool004H0oooo0P00I_m^0?ooo`030000003oool0oooo06/0oooo0P00I_m70?ooo`00AP3o
ool2001Vofh0oooo00<000000?ooo`3oool0J`3oool3001VodH0oooo00150?ooo`<006KoKP3oool0
0`000000oooo0?ooo`1/0?ooo`8006KoAP3oool004D0oooo0P00I_m_0?ooo`030000003oool0oooo
06`0oooo0P00I_m60?ooo`00A03oool3001Vofl0oooo0P00001]0?ooo`<006KoA@3oool004@0oooo
0P00I_m`0?ooo`030000003oool0oooo06d0oooo0P00I_m50?ooo`00A03oool2001Vog00oooo00<0
00000?ooo`3oool0K@3oool2001VodD0oooo00130?ooo`<006KoL03oool00`000000oooo0?ooo`1]
0?ooo`8006KoA@3oool004<0oooo0P00I_ma0?ooo`030000003oool0oooo06d0oooo0`00I_m40?oo
o`00@`3oool2001Vog40oooo00<000000?ooo`3oool0KP3oool2001Vod@0oooo00130?ooo`8006Ko
L@3oool00`000000oooo0?ooo`1^0?ooo`8006KoA03oool00480oooo0`00I_ma0?ooo`030000003o
ool0oooo06h0oooo0`00I_m30?ooo`00@P3oool2001Vog80oooo00<000000?ooo`3oool0K`3oool2
001Vod<0oooo00120?ooo`8006KoLP3oool00`000000oooo0?ooo`1_0?ooo`8006Ko@`3oool00480
oooo0P00I_mb0?ooo`030000003oool0oooo06l0oooo0P00I_m30?ooo`00@P3oool2001Vog80oooo
00<000000?ooo`3oool0K`3oool2001Vod<0oooo00120?ooo`8006KoLP3oool00`000000oooo0?oo
o`1_0?ooo`8006Ko@`3oool00480oooo0P00I_mD0?ooo`050?oDV`00000000000000002Ke?l01@3o
ool00`3DV`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo
0?ooo`1_0?ooo`<006Ko@P3oool00440oooo0P00I_mE0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0
e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`06
0?ooo`030000003oool0oooo0700oooo0P00I_m20?ooo`00@@3oool2001Voe@0oooo00<0omBK002K
e03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?oo
o`3oool0L03oool2001Vod80oooo00110?ooo`8006KoE03oool00`3Z^W80L[[Z0?ooo`020?ooo`03
0?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1`0?ooo`80
06Ko@P3oool00400oooo0`00I_mD0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
3`3oool00`2jLP00VmCo0?ooo`050?ooo`<00000L03oool2001Vod80oooo00100?ooo`8006KoE@3o
ool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P00
00000`1b^^X0oooo0?ooo`050?ooo`030000003oool0oooo0700oooo0P00I_m20?ooo`00@03oool2
001VoeD0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0
e?oo00X0oooo00<000000?ooo`3oool0L03oool3001Vod40oooo00100?ooo`8006KoEP3oool01P2j
LP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?oo
o`1a0?ooo`8006Ko@@3oool00400oooo0P00I_mF0?ooo`050?ooe02K000000000000LP2jj_l0303o
ool00`3oom@0V`0000000002000000030000V`3Dool0oooo00D0oooo00<000000?ooo`3oool0L@3o
ool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool0
0400oooo0P00I_md0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0
oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo
0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md0?ooo`030000003oool0oooo0740oooo0P00
I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo00100?oo
o`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md0?ooo`03
0000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0
L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3o
ool00400oooo0P00I_md0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001V
og@0oooo0P00001b0?ooo`8006Ko@@3oool00400oooo0P00I_md0?ooo`030000003oool0oooo0740
oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0L@3oool00`00I_l0oooo
0?ooo`100?ooo`00@@3oool00`00I_l0oooo0?ooo`1b0?ooo`030000003oool0oooo0700oooo0P00
I_m20?ooo`00@@3oool2001Vog<0oooo00<000000?ooo`3oool0L03oool2001Vod80oooo00120?oo
o`03001Vo`3oool0oooo04D0oooo00<006Ko0?ooo`3oool0:@3oool00`000000oooo0?ooo`1`0?oo
o`8006Ko@P3oool00440oooo0`00I_m50?ooo`<006Ko:P3oool00`000000oooo0?ooo`0W0?ooo`@0
06KoA@3oool2001Vod80oooo00120?ooo`8006Ko@`3oool5001VobX0oooo00<000000?ooo`3oool0
9`3oool5001Vod@0oooo0P00I_m20?ooo`00@P3oool2001Vod80oooo1P00I_lZ0?ooo`030000003o
ool0oooo02L0oooo0P00I_l0103oool006Ko001Vo`00I_m20?ooo`<006Ko@P3oool004<0oooo00<0
06Ko0?ooo`3oool0?`3oool3001Vo`80oooo0P00I_lZ0?ooo`030000003oool0oooo02L0oooo0P00
I_l20?ooo`@006Ko@03oool2001Vod<0oooo00130?ooo`8006Ko?`3oool3001Vo`<0oooo0P00I_lZ
0?ooo`030000003oool0oooo02L0oooo0P00I_l30?ooo`@006Ko?`3oool2001Vod<0oooo00140?oo
o`03001Vo`3oool0oooo03`0oooo0`00I_l40?ooo`8006Ko:P3oool00`000000oooo0?ooo`0W0?oo
o`8006Ko1@3oool3001Vocd0oooo0`00I_m30?ooo`00A03oool2001Voc/0oooo1000I_l50?ooo`80
06Ko:P3oool00`000000oooo0?ooo`0W0?ooo`8006Ko1P3oool4001Voc/0oooo0P00I_m40?ooo`00
A03oool2001VocX0oooo1000I_l60?ooo`8006Ko:P3oool00`000000oooo0?ooo`0W0?ooo`8006Ko
1`3oool4001VocX0oooo0P00I_m40?ooo`00A@3oool00`00I_l0oooo0?ooo`0f0?ooo`@006Ko203o
ool2001VobX0oooo00<000000?ooo`3oool09`3oool2001Vo`T0oooo0`00I_lh0?ooo`<006KoA03o
ool004D0oooo0P00I_lf0?ooo`@006Ko2P3oool2001VobT0oooo00<000000?ooo`3oool09P3oool2
001Vo`/0oooo0`00I_lf0?ooo`<006KoA@3oool004H0oooo00<006Ko0?ooo`3oool0<P3oool4001V
o``0oooo0P00I_lY0?ooo`030000003oool0oooo02H0oooo0P00I_l<0?ooo`@006Ko=03oool2001V
odH0oooo00160?ooo`8006Ko<P3oool4001Vo`d0oooo0P00I_lY0?ooo`8000009`3oool2001Vo`d0
oooo1000I_lb0?ooo`8006KoA`3oool004L0oooo0P00I_l_0?ooo`@006Ko3`3oool2001VobT0oooo
00<000000?ooo`3oool09P3oool2001Vo`l0oooo1000I_l_0?ooo`8006KoB03oool004P0oooo0P00
I_l]0?ooo`@006Ko403oool2001VobT0oooo00<000000?ooo`3oool09P3oool2001Voa00oooo1000
I_l]0?ooo`8006KoB@3oool004T0oooo0P00I_lZ0?ooo`@006Ko4P3oool2001VobT0oooo00<00000
0?ooo`3oool09P3oool2001Voa80oooo1000I_lY0?ooo`<006KoBP3oool004T0oooo0`00I_lW0?oo
o`D006Ko4`3oool2001VobT0oooo00<000000?ooo`3oool09P3oool2001Voa<0oooo1P00I_lU0?oo
o`@006KoBP3oool004X0oooo1@00I_lR0?ooo`D006Ko5@3oool2001VobT0oooo00<000000?ooo`3o
ool09P3oool2001VoaD0oooo1P00I_lR0?ooo`<006KoC03oool004/0oooo1@00I_lN0?ooo`H006Ko
5`3oool3001VobP0oooo00<000000?ooo`3oool09P3oool2001VoaP0oooo1P00I_lN0?ooo`<006Ko
C@3oool004h0oooo1@00I_lG0?ooo`L006Ko6`3oool2001VobP0oooo00<000000?ooo`3oool09@3o
ool2001Voa/0oooo1`00I_lJ0?ooo`<006KoCP3oool004l0oooo1P00I_lB0?ooo`L006Ko7P3oool2
001VobP0oooo00<000000?ooo`3oool09@3oool2001Voal0oooo1`00I_lC0?ooo`D006KoC`3oool0
0580oooo1@00I_l>0?ooo`H006Ko8@3oool2001VobP0oooo00<000000?ooo`3oool09@3oool2001V
ob80oooo1`00I_l<0?ooo`P006KoD03oool005@0oooo5000I_lT0?ooo`8006Ko:03oool00`000000
oooo0?ooo`0U0?ooo`8006Ko9@3ooolE001Voe<0oooo001F0?oooa0006Ko9P3oool3001VobL0oooo
00<000000?ooo`3oool0903oool3001VobP0oooo3P00I_mG0?ooo`00S@3oool2001VobL0oooo00<0
00000?ooo`3oool0903oool2001Vohh0oooo002=0?ooo`8006Ko9`3oool00`000000oooo0?ooo`0T
0?ooo`8006KoSP3oool008d0oooo0P00I_lW0?ooo`030000003oool0oooo02@0oooo0P00I_n>0?oo
o`00S@3oool3001VobH0oooo00<000000?ooo`3oool0903oool2001Vohh0oooo002>0?ooo`8006Ko
9P3oool00`000000oooo0?ooo`0S0?ooo`<006KoSP3oool008h0oooo0P00I_lV0?ooo`800000903o
ool2001Vohl0oooo002>0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0S0?ooo`8006KoS`3oool0
08h0oooo0`00I_lU0?ooo`030000003oool0oooo02<0oooo0P00I_n?0?ooo`00S`3oool2001VobD0
oooo00<000000?ooo`3oool08`3oool2001Vohl0oooo002?0?ooo`8006Ko9@3oool00`000000oooo
0?ooo`0R0?ooo`8006KoT03oool008l0oooo0P00I_lU0?ooo`030000003oool0oooo0280oooo0P00
I_n@0?ooo`00S`3oool3001Vob@0oooo00<000000?ooo`3oool08P3oool2001Voi00oooo002@0?oo
o`8006Ko903oool00`000000oooo0?ooo`0R0?ooo`8006KoT03oool00900oooo0P00I_lT0?ooo`03
0000003oool0oooo0280oooo0P00I_n@0?ooo`00T03oool3001Vob<0oooo00<000000?ooo`3oool0
8@3oool2001Voi40oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0Q0?ooo`8006KoT@3o
ool00940oooo0P00I_lS0?ooo`030000003oool0oooo0240oooo0P00I_nA0?ooo`00T@3oool3001V
ob80oooo00<000000?ooo`3oool0803oool3001Voi40oooo002B0?ooo`8006Ko8P3oool00`000000
oooo0?ooo`0P0?ooo`8006KoTP3oool00980oooo0P00I_lR0?ooo`030000003oool0oooo01l0oooo
0`00I_nB0?ooo`00T`3oool00`00I_l0oooo0?ooo`0P0?ooo`030000003oool0oooo01l0oooo0P00
I_nC0?ooo`00T`3oool2001Vob40oooo0P00000P0?ooo`8006KoT`3oool009@0oooo00<006Ko0?oo
o`3oool07`3oool00`000000oooo0?ooo`0O0?ooo`03001Vo`3oool0oooo0980oooo002D0?ooo`80
06Ko803oool00`000000oooo0?ooo`0N0?ooo`8006KoU03oool009D0oooo00<006Ko0?ooo`3oool0
7P3oool00`000000oooo0?ooo`0N0?ooo`03001Vo`3oool0oooo09<0oooo002E0?ooo`8006Ko7`3o
ool00`000000oooo0?ooo`0M0?ooo`8006KoU@3oool009H0oooo00<006Ko0?ooo`3oool07@3oool0
0`000000oooo0?ooo`0L0?ooo`8006KoUP3oool009H0oooo0P00I_lN0?ooo`030000003oool0oooo
01`0oooo00<006Ko0?ooo`3oool0U@3oool009L0oooo00<006Ko0?ooo`3oool0703oool00`000000
oooo0?ooo`0K0?ooo`8006KoU`3oool009L0oooo0P00I_lM0?ooo`030000003oool0oooo01/0oooo
00<006Ko0?ooo`3oool0UP3oool009P0oooo00<006Ko0?ooo`3oool06`3oool00`000000oooo0?oo
o`0J0?ooo`8006KoV03oool009P0oooo0P00I_lL0?ooo`030000003oool0oooo01T0oooo0P00I_nI
0?ooo`00V@3oool2001Voa/0oooo00<000000?ooo`3oool0603oool2001VoiX0oooo002J0?ooo`03
001Vo`3oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`00I_l0oooo0?ooo`2I0?ooo`00
VP3oool2001Vo`d0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000
003oool0oooo01L0oooo0P00I_nK0?ooo`00V`3oool2001Vo`l0oooo00<0^W9b0;[Zo`3oool01`3o
ool00`000000oooo0?ooo`0F0?ooo`8006KoW03oool009/0oooo0`00I_l>0?ooo`030;YbLP2jj_l0
oooo00L0oooo00<000000?ooo`3oool05@3oool2001Void0oooo002L0?ooo`8006Ko3P3oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo01@0oooo0`00I_nM0?ooo`00W@3oool2001Vo`d0
oooo00<0^W9b0;[Zo`3oool01`3oool3000001<0oooo0`00I_nN0?ooo`00W@3oool3001Vo``0oooo
00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`8006KoW`3oool009h0oooo0`00
I_l;0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool04P3oool2001Voj00oooo002O
0?ooo`<006Ko1`3oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool04@3o
ool3001Voj00oooo002P0?ooo`@006Ko1`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0
oooo0100oooo0`00I_nQ0?ooo`00X@3oool4001Voa40oooo00<000000?ooo`3oool03`3oool3001V
oj80oooo002S0?ooo`<006Ko403oool00`000000oooo0?ooo`0=0?ooo`@006KoX`3oool00:@0oooo
1000I_l>0?ooo`030000003oool0oooo00`0oooo1000I_nT0?ooo`00Y@3oool4001Vo`d0oooo00<0
00000?ooo`3oool02P3oool4001VojH0oooo002W0?ooo`@006Ko2`3oool00`000000oooo0?ooo`09
0?ooo`@006KoY`3oool00:P0oooo1P00I_l80?ooo`030000003oool0oooo00P0oooo0`00I_nY0?oo
o`00ZP3oool5001Vo`L0oooo00<000000?ooo`3oool00P3oool00`00I_l0oooo0?ooo`05001VojX0
oooo002]0?ooo`D006Ko103oool010000000oooo0?ooo`3oool8001Voj/0oooo002^0?oooa4006Ko
[P3oool00;40oooo2P00I_nb0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool20000
0;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00001\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.84545 .59091 m
.84944 .60163 L
.85268 .61182 L
.85552 .62319 L
.85672 .62963 L
.85752 .6355 L
.85783 .6385 L
.85806 .64168 L
.85818 .64439 L
.85825 .64737 L
.85822 .65057 L
.85816 .65236 L
.85807 .654 L
.85783 .65716 L
.85751 .66016 L
.85713 .66291 L
.85662 .66583 L
.85548 .67104 L
.85371 .67714 L
.85172 .68255 L
.84582 .69437 L
.83873 .70453 L
.82943 .71457 L
.82385 .71947 L
.82216 .72082 L
.82054 .72208 L
.81918 .72324 L
.81949 .72524 L
.82183 .73926 L
.82425 .75301 L
.82699 .76926 L
.82929 .78512 L
.83013 .79214 L
.83088 .79961 L
.83121 .80354 L
.83152 .80787 L
.83174 .81178 L
.8319 .81549 L
.83197 .81762 L
.83202 .81994 L
.83206 .824 L
.83206 .82629 L
.83203 .82872 L
.83198 .8308 L
.8319 .83308 L
.83171 .83714 L
.83157 .83941 L
.83141 .84148 L
.83063 .84928 L
.83007 .85342 L
Mistroke
.82937 .85779 L
.82781 .86554 L
.82546 .87452 L
.82282 .88239 L
.81988 .88959 L
.8162 .89703 L
.8082 .90947 L
.79855 .92029 L
.78809 .9288 L
.78147 .93293 L
.77508 .93619 L
.76729 .93932 L
.75955 .94165 L
.75173 .94331 L
.74767 .94393 L
.7453 .94421 L
.74312 .94442 L
.73918 .9447 L
.73489 .94484 L
.73105 .94484 L
.72698 .9447 L
.72248 .9444 L
.71995 .94417 L
.71763 .94391 L
.7088 .94256 L
.7038 .94156 L
.69835 .94028 L
.68842 .93744 L
.67085 .9309 L
.65457 .92319 L
.64554 .91824 L
.63711 .91319 L
.63488 .91179 L
.63252 .91027 L
.63163 .91271 L
.63101 .91551 L
.62859 .92577 L
.61618 .96566 L
.60679 .98751 L
.59637 1.00678 L
.58508 1.0235 L
.5734 1.03734 L
.56016 1.04967 L
.55228 1.05555 L
.54461 1.06037 L
.53788 1.06389 L
.53044 1.06706 L
.52357 1.06935 L
.51717 1.07094 L
.51357 1.07161 L
Mistroke
.51019 1.0721 L
.50648 1.07247 L
.50247 1.07269 L
.49829 1.07271 L
.49431 1.07253 L
.49075 1.07221 L
.48687 1.07168 L
.48267 1.07091 L
.47883 1.07001 L
.47023 1.06732 L
.46278 1.0642 L
.45507 1.06019 L
.44218 1.05152 L
.42887 1.03969 L
.4158 1.02465 L
.40329 1.00622 L
.38498 .96865 L
.37759 .94771 L
.37201 .92811 L
.36953 .91792 L
.3689 .91514 L
.36825 .91216 L
.36719 .91047 L
.36497 .91188 L
.34521 .9233 L
.32715 .93174 L
.31023 .93786 L
.30171 .94026 L
.29269 .94228 L
.28758 .94318 L
.2828 .94385 L
.27854 .94431 L
.27615 .94451 L
.27396 .94465 L
.26971 .94482 L
.26571 .94485 L
.26216 .94476 L
.25835 .94454 L
.25426 .94416 L
.25201 .94388 L
.24999 .94359 L
.2425 .94215 L
.23577 .94033 L
.2288 .93786 L
.21701 .93206 L
.21083 .92804 L
.20451 .92307 L
.19329 .91138 L
.18477 .89877 L
.17848 .88574 L
Mistroke
.17569 .87816 L
.17352 .87092 L
.17158 .86277 L
.17 .85392 L
.16948 .85018 L
.16901 .84612 L
.16868 .8426 L
.16839 .83873 L
.16825 .83638 L
.16814 .8342 L
.16806 .83211 L
.168 .82987 L
.16794 .82561 L
.16795 .82174 L
.16803 .81793 L
.16816 .81391 L
.16833 .81048 L
.16856 .80673 L
.16923 .79839 L
.17003 .79068 L
.17409 .76263 L
.17665 .74788 L
.17798 .74037 L
.17931 .7326 L
.17984 .72941 L
.18039 .72601 L
.18069 .72408 L
.18021 .72264 L
.17747 .72053 L
.16823 .71229 L
.16094 .70413 L
.15426 .6945 L
.15143 .68941 L
.1488 .68381 L
.14689 .67889 L
.14514 .67337 L
.14367 .66733 L
.14305 .66399 L
.14258 .66084 L
.14223 .65788 L
.142 .65516 L
.14183 .65201 L
.14176 .64902 L
.14175 .64732 L
.14178 .64578 L
.14183 .64401 L
.14191 .64233 L
.1421 .63935 L
.14241 .63612 L
.14284 .63256 L
Mistroke
.14342 .6288 L
.14471 .6221 L
.14779 .61022 L
.15137 .59934 L
.15252 .59617 L
.15365 .59319 L
.1544 .59054 L
.15328 .58765 L
.14883 .57497 L
.14557 .56341 L
.14436 .55807 L
.14332 .55242 L
.14286 .5494 L
.14245 .54609 L
.14215 .54307 L
.14195 .54028 L
.14186 .53857 L
.1418 .53696 L
.14175 .53395 L
.14176 .53227 L
.1418 .53072 L
.14186 .52902 L
.14196 .52723 L
.14222 .52409 L
.14254 .52124 L
.14302 .51797 L
.14359 .51488 L
.14486 .50946 L
.14663 .50366 L
.14906 .49742 L
.15218 .49098 L
.15918 .47998 L
.16716 .47061 L
.17568 .46274 L
.178 .46087 L
.18055 .45892 L
.18061 .45722 L
.18035 .45554 L
.17981 .45222 L
.17735 .43786 L
.17286 .41159 L
.17068 .39643 L
.16909 .38186 L
.16852 .37444 L
.16827 .37026 L
.16811 .36642 L
.16799 .36223 L
.16795 .35986 L
.16794 .35766 L
.16797 .35363 L
Mistroke
.16807 .34934 L
.16825 .34544 L
.16852 .34125 L
.16885 .33731 L
.16923 .3337 L
.17015 .32691 L
.17142 .31984 L
.17318 .3122 L
.1755 .30423 L
.18089 .29054 L
.18497 .2827 L
.18937 .27571 L
.19906 .26389 L
.20917 .25499 L
.22188 .2471 L
.22884 .24395 L
.23675 .24119 L
.24051 .24015 L
.24456 .23921 L
.24842 .23848 L
.25199 .23794 L
.25562 .23751 L
.25909 .23723 L
.26281 .23704 L
.26688 .23696 L
.27049 .23702 L
.27434 .23719 L
.27766 .23743 L
.28134 .23779 L
.28569 .23835 L
.2897 .23899 L
.2988 .24084 L
.31541 .24564 L
.33253 .25239 L
.35053 .26137 L
.35912 .26632 L
.36329 .26887 L
.36708 .27128 L
.36848 .26858 L
.36943 .26432 L
.3716 .25531 L
.38393 .21587 L
.39319 .19435 L
.40335 .17549 L
.41448 .15891 L
.42798 .14304 L
.44194 .13048 L
.45571 .12126 L
.46868 .11509 L
.47623 .11253 L
Mistroke
.4834 .11076 L
.48728 .11007 L
.49099 .10958 L
.49433 .10928 L
.49798 .10912 L
.50193 .10911 L
.50414 .10919 L
.50614 .10932 L
.51004 .1097 L
.5137 .11023 L
.51736 .11092 L
.52126 .11183 L
.52825 .11396 L
.53643 .11725 L
.54375 .12096 L
.55904 .13125 L
.57257 .14361 L
.59362 .17061 L
.60374 .18821 L
.61191 .20558 L
.62451 .24099 L
.62725 .25084 L
.62984 .26119 L
.63082 .26544 L
.63182 .26997 L
.63492 .27 L
.6389 .26752 L
.6583 .25672 L
.67632 .24868 L
.68514 .24545 L
.69469 .24251 L
.7037 .24028 L
.71185 .23873 L
.71607 .23811 L
.72005 .23764 L
.72421 .23728 L
.7287 .23704 L
.73257 .23697 L
.73665 .23702 L
.74045 .2372 L
.74385 .23746 L
.74595 .23768 L
.74815 .23796 L
.75203 .23856 L
.76056 .24043 L
.76762 .24261 L
.77501 .2456 L
.78854 .25333 L
.79536 .25864 L
.80109 .26404 L
Mistroke
.8108 .27596 L
.81825 .28876 L
.82367 .30177 L
.82611 .30955 L
.82799 .31707 L
.82956 .32514 L
.83064 .33266 L
.83108 .33665 L
.83147 .34103 L
.83162 .34325 L
.83176 .34563 L
.83194 .34992 L
.83204 .35398 L
.83206 .35772 L
.83202 .36184 L
.83197 .36391 L
.8319 .36619 L
.83174 .37001 L
.83151 .3741 L
.83095 .38146 L
.8302 .38904 L
.82936 .39616 L
.82751 .40926 L
.82265 .43787 L
.82129 .44565 L
.82066 .44938 L
.8201 .45276 L
.81961 .45582 L
.81939 .45888 L
.82193 .46082 L
.82464 .463 L
.83334 .47113 L
.84131 .48065 L
.84746 .49032 L
.85186 .4996 L
.85369 .50463 L
.85535 .51026 L
.85604 .51313 L
.85667 .51624 L
.85713 .51895 L
.85754 .52192 L
.85785 .52487 L
.85806 .52762 L
.85819 .53025 L
.85825 .53307 L
.85823 .53584 L
.85814 .53845 L
.85802 .5408 L
.85782 .54334 L
.85752 .54638 L
Mistroke
.85716 .54922 L
.85612 .55565 L
.8548 .56188 L
.8531 .56852 L
.84545 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;@0oooo1@00I_nd0?ooo`00[@3ooolD001Voj`0oooo002Z0?ooo`/006Ko00<0oooo0000
003oool03000I_nY0?ooo`00Z03oool6001Vo`P0oooo00<000000?ooo`3oool01`3oool5001VojP0
oooo002V0?ooo`D006Ko2`3oool00`000000oooo0?ooo`0:0?ooo`@006KoYP3oool00:@0oooo1@00
I_l=0?ooo`030000003oool0oooo00/0oooo1000I_nU0?ooo`00X`3oool4001Vo`l0oooo00<00000
0?ooo`3oool03@3oool3001Voj@0oooo002Q0?ooo`@006Ko103oool00`3oe9/00000000000030000
0003002Ke03oool0oooo00@0oooo00<000000?ooo`3oool03P3oool4001Voj80oooo002P0?ooo`@0
06Ko203oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo00l0oooo1000I_nQ0?ooo`00
W`3oool3001Vo`X0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0A0?ooo`<006Ko
X03oool009h0oooo0`00I_l;0?ooo`030;YbLP2jj_l0oooo00L0oooo0`00000B0?ooo`<006KoW`3o
ool009d0oooo0`00I_l00`2jLP0000000000000300000003001b^P3oool0oooo00<0oooo00<0^W9b
0;[Zo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`@006KoW@3oool009`0oooo0`00I_l=0?oo
o`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0503oool4001Voi`0oooo002K0?ooo`<0
06Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0oooo0`00I_nK0?ooo`00
VP3oool3001Vo``0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo01L0
oooo0`00I_nJ0?ooo`00V@3oool3001Vo`l0oooo00<0j[Yb0000LP2jj_l0203oool00`000000oooo
0?ooo`0H0?ooo`8006KoVP3oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00
I_nI0?ooo`00V03oool2001Voa`0oooo00<000000?ooo`3oool06@3oool3001VoiP0oooo002G0?oo
o`<006Ko703oool00`000000oooo0?ooo`0J0?ooo`<006KoU`3oool009L0oooo0P00I_lM0?ooo`03
0000003oool0oooo01/0oooo0`00I_nF0?ooo`00UP3oool2001Voah0oooo00<000000?ooo`3oool0
703oool2001VoiH0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0M0?ooo`8006KoU@3o
ool009D0oooo00<006Ko0?ooo`3oool07P3oool00`000000oooo0?ooo`0M0?ooo`<006KoU03oool0
09@0oooo0P00I_lP0?ooo`030000003oool0oooo01h0oooo0P00I_nD0?ooo`00T`3oool2001Vob40
oooo00<000000?ooo`3oool07`3oool2001Voi<0oooo002C0?ooo`03001Vo`3oool0oooo0200oooo
00<000000?ooo`3oool0803oool2001Voi80oooo002B0?ooo`8006Ko8P3oool00`000000oooo0?oo
o`0Q0?ooo`03001Vo`3oool0oooo0900oooo002B0?ooo`03001Vo`3oool0oooo0240oooo0P00000R
0?ooo`8006KoT@3oool00940oooo0P00I_lS0?ooo`030000003oool0oooo0280oooo0P00I_n@0?oo
o`00T03oool2001Vob@0oooo00<000000?ooo`3oool08`3oool00`00I_l0oooo0?ooo`2>0?ooo`00
T03oool00`00I_l0oooo0?ooo`0S0?ooo`030000003oool0oooo02<0oooo0P00I_n?0?ooo`00S`3o
ool2001VobD0oooo00<000000?ooo`3oool08`3oool3001Vohh0oooo002?0?ooo`03001Vo`3oool0
oooo02@0oooo00<000000?ooo`3oool0903oool2001Vohh0oooo002>0?ooo`8006Ko9P3oool00`00
0000oooo0?ooo`0T0?ooo`8006KoSP3oool008h0oooo00<006Ko0?ooo`3oool09@3oool00`000000
oooo0?ooo`0T0?ooo`<006KoS@3oool008d0oooo0P00I_lW0?ooo`030000003oool0oooo02D0oooo
0P00I_n=0?ooo`00S03oool2001VobP0oooo00<000000?ooo`3oool09@3oool3001Voh`0oooo002<
0?ooo`03001Vo`3oool0oooo02L0oooo00<000000?ooo`3oool09P3oool2001Voh`0oooo002;0?oo
o`8006Ko:@3oool00`000000oooo0?ooo`0V0?ooo`8006KoS03oool008/0oooo00<006Ko0?ooo`3o
ool0:03oool00`000000oooo0?ooo`0V0?ooo`<006KoR`3oool008X0oooo0P00I_lZ0?ooo`030000
003oool0oooo02L0oooo0P00I_n;0?ooo`00RP3oool2001VobX0oooo00<000000?ooo`3oool09`3o
ool2001Voh/0oooo002:0?ooo`8006Ko:P3oool00`000000oooo0?ooo`0W0?ooo`8006KoR`3oool0
08T0oooo0`00I_lZ0?ooo`030000003oool0oooo02L0oooo0`00I_n:0?ooo`00R@3oool2001Vob/0
oooo0P00000Y0?ooo`8006KoRP3oool008T0oooo0P00I_l[0?ooo`030000003oool0oooo02P0oooo
0P00I_n:0?ooo`00R03oool3001Vob/0oooo00<000000?ooo`3oool0:03oool3001VohT0oooo001J
0?ooo`l006Ko7`3oool2001Vob`0oooo00<000000?ooo`3oool0:@3oool2001Voal0oooo4000I_mJ
0?ooo`00EP3ooolJ001VoaP0oooo0P00I_l/0?ooo`030000003oool0oooo02T0oooo0P00I_lI0?oo
oa/006KoE@3oool005<0oooo2000I_l=0?ooo`/006Ko5@3oool2001Vob`0oooo00<000000?ooo`3o
ool0:@3oool3001Voa@0oooo2`00I_l>0?ooo`T006KoDP3oool00500oooo1`00I_lH0?ooo`H006Ko
4P3oool3001Vob`0oooo00<000000?ooo`3oool0:P3oool2001Voa40oooo1`00I_lJ0?ooo`H006Ko
D03oool004l0oooo1@00I_lN0?ooo`H006Ko3`3oool2001Vobd0oooo00<000000?ooo`3oool0:P3o
ool2001Vo`l0oooo1P00I_lP0?ooo`@006KoC`3oool004d0oooo1000I_lS0?ooo`H006Ko3@3oool2
001Vobd0oooo00<000000?ooo`3oool0:P3oool3001Vo`/0oooo1P00I_lU0?ooo`@006KoC@3oool0
04`0oooo1000I_lW0?ooo`D006Ko2`3oool2001Vobd0oooo00<000000?ooo`3oool0:`3oool2001V
o`T0oooo1P00I_lX0?ooo`@006KoC03oool004/0oooo0`00I_l[0?ooo`D006Ko203oool3001Vobd0
oooo00<000000?ooo`3oool0:`3oool2001Vo`L0oooo1@00I_l]0?ooo`<006KoB`3oool004T0oooo
1000I_l^0?ooo`D006Ko1P3oool2001Vobh0oooo00<000000?ooo`3oool0:`3oool2001Vo`D0oooo
1@00I_l`0?ooo`<006KoBP3oool004P0oooo1000I_la0?ooo`@006Ko1@3oool2001Vobh0oooo00<0
00000?ooo`3oool0:`3oool2001Vo`@0oooo1000I_lc0?ooo`<006KoB@3oool004P0oooo0P00I_le
0?ooo`@006Ko0P3oool3001Vobh0oooo00<000000?ooo`3oool0;03oool00`00I_l0oooo0?ooo`04
001VocH0oooo0`00I_m80?ooo`00A`3oool2001VocL0oooo1`00I_l_0?ooo`030000003oool0oooo
02`0oooo1P00I_lh0?ooo`<006KoA`3oool004H0oooo0P00I_lj0?ooo`D006Ko;`3oool00`000000
oooo0?ooo`0]0?ooo`<006Ko>`3oool3001VodH0oooo00150?ooo`8006Ko?@3oool3001Vobl0oooo
0P00000^0?ooo`8006Ko?@3oool3001VodD0oooo00150?ooo`03001Vo`3oool0oooo03d0oooo00<0
06Ko0?ooo`3oool0;P3oool00`000000oooo0?ooo`1]0?ooo`8006KoA@3oool004@0oooo0P00I_m`
0?ooo`030000003oool0oooo06h0oooo0P00I_m40?ooo`00@`3oool2001Vog40oooo00<000000?oo
o`3oool0K`3oool00`00I_l0oooo0?ooo`120?ooo`00@`3oool00`00I_l0oooo0?ooo`1`0?ooo`03
0000003oool0oooo06l0oooo0P00I_m30?ooo`00@P3oool2001Vog80oooo00<000000?ooo`3oool0
L03oool2001Vod80oooo00110?ooo`8006KoL`3oool00`000000oooo0?ooo`1a0?ooo`03001Vo`3o
ool0oooo0400oooo00110?ooo`03001Vo`3oool0oooo0780oooo00<000000?ooo`3oool0L@3oool2
001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool003l0
oooo0`00I_md0?ooo`030000003oool0oooo0740oooo0`00I_m00?ooo`00?`3oool2001VogD0oooo
00<000000?ooo`3oool0LP3oool2001Vod00oooo000o0?ooo`8006KoM@3oool00`000000oooo0?oo
o`1b0?ooo`<006Ko?`3oool003h0oooo0`00I_me0?ooo`030000003oool0oooo07<0oooo0P00I_lo
0?ooo`00?P3oool2001VogH0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000n0?ooo`80
06KoMP3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003h0oooo0P00I_mf0?ooo`030000
003oool0oooo07<0oooo0P00I_lo0?ooo`00?P3oool2001VogH0oooo00<000000?ooo`3oool0L`3o
ool3001Voch0oooo000m0?ooo`<006KoMP3oool2000007D0oooo0P00I_ln0?ooo`00?@3oool2001V
ogL0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000m0?ooo`8006KoM`3oool00`000000
oooo0?ooo`1d0?ooo`8006Ko?P3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07@0oooo
0P00I_ln0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000m
0?ooo`03001Vo`3oool0oooo07H0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000l0?oo
o`8006KoN03oool00`000000oooo0?ooo`1e0?ooo`03001Vo`3oool0oooo03`0oooo000l0?ooo`80
06KoN03oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo0P00I_mh0?ooo`030000
003oool0oooo07H0oooo00<006Ko0?ooo`3oool0>`3oool003`0oooo0P00I_mh0?ooo`030000003o
ool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0M@3oool2
001Vocd0oooo000l0?ooo`8006KoN03oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0
oooo0P00I_mh0?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VoeX0oooo
00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/000000000
0000000009_Do`070?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VoeX0
oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0
002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo
000l0?ooo`8006KoF@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0
omBK002Ke03oool01@3oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo0P00I_mI
0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`05
0?ooo`<00000M@3oool2001Vocd0oooo000l0?ooo`8006KoD03oool00`2jLP000000000000030000
0005001b^P3oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0
oooo00D0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l0?ooo`8006KoF@3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b
^^X0oooo0?ooo`050?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VoeT0
oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0
oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l0?ooo`8006KoFP3oool01P2jLP00VmCo
0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1e0?oo
o`8006Ko?@3oool003`0oooo0P00I_mJ0?ooo`050?ooe02K000000000000LP2jj_l0303oool00`3o
om@0V`0000000002000000030000V`3Dool0oooo00D0oooo00<000000?ooo`3oool0M@3oool2001V
ocd0oooo000l0?ooo`8006KoN03oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo
0P00I_mh0?ooo`030000003oool0oooo07@0oooo0`00I_lm0?ooo`00?@3oool2001VogL0oooo00<0
00000?ooo`3oool0M03oool2001Voch0oooo000m0?ooo`8006KoM`3oool00`000000oooo0?ooo`1d
0?ooo`8006Ko?P3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07@0oooo0P00I_ln0?oo
o`00?@3oool2001VogL0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000m0?ooo`8006Ko
M`3oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003h0oooo0P00I_mf0?ooo`030000003o
ool0oooo07@0oooo0P00I_ln0?ooo`00?P3oool2001VogH0oooo00<000000?ooo`3oool0M03oool2
001Voch0oooo000n0?ooo`8006KoMP3oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003h0
oooo0P00I_mf0?ooo`030000003oool0oooo07@0oooo0P00I_ln0?ooo`00?P3oool2001VogH0oooo
0P00001d0?ooo`8006Ko?`3oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo07<0oooo0P00
I_lo0?ooo`00?`3oool2001VogD0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000o0?oo
o`8006KoM@3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003l0oooo0P00I_me0?ooo`03
0000003oool0oooo07<0oooo0P00I_lo0?ooo`00?`3oool2001VogD0oooo00<000000?ooo`3oool0
LP3oool2001Vod00oooo000o0?ooo`8006KoM@3oool00`000000oooo0?ooo`1b0?ooo`8006Ko@03o
ool003l0oooo0P00I_me0?ooo`030000003oool0oooo0780oooo0P00I_m00?ooo`00?`3oool2001V
ogD0oooo00<000000?ooo`3oool0LP3oool2001Vod00oooo000o0?ooo`8006KoM@3oool00`000000
oooo0?ooo`1b0?ooo`8006Ko@03oool003l0oooo0P00I_me0?ooo`030000003oool0oooo0740oooo
0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo0010
0?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md0?oo
o`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?ooo`3o
ool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko
@@3oool00400oooo0P00I_md0?ooo`800000LP3oool00`00I_l0oooo0?ooo`100?ooo`00@03oool2
001Vog@0oooo00<000000?ooo`3oool0L03oool2001Vod80oooo00100?ooo`8006KoM03oool00`00
0000oooo0?ooo`1`0?ooo`<006Ko@@3oool003l0oooo0`00I_md0?ooo`030000003oool0oooo0740
oooo1000I_lo0?ooo`00?@3oool4001VogD0oooo00<000000?ooo`3oool0LP3oool4001Voch0oooo
000l0?ooo`@006KoMP3oool00`000000oooo0?ooo`1d0?ooo`<006Ko?@3oool003`0oooo0P00I_mh
0?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00>`3oool2001VogT0oooo00<000000?oo
o`3oool0MP3oool2001Voc`0oooo000k0?ooo`03001Vo`3oool0oooo07P0oooo00<000000?ooo`3o
ool0M`3oool2001Voc/0oooo000j0?ooo`8006KoNP3oool00`000000oooo0?ooo`1h0?ooo`8006Ko
>P3oool003X0oooo00<006Ko0?ooo`3oool0N@3oool00`000000oooo0?ooo`1i0?ooo`03001Vo`3o
ool0oooo03P0oooo000i0?ooo`8006KoN`3oool00`000000oooo0?ooo`1i0?ooo`8006Ko>@3oool0
03P0oooo0P00I_ml0?ooo`030000003oool0oooo07X0oooo0P00I_lh0?ooo`00=`3oool2001Vogd0
oooo00<000000?ooo`3oool0N`3oool00`00I_l0oooo0?ooo`0f0?ooo`00=`3oool00`00I_l0oooo
0?ooo`1l0?ooo`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00=P3oool2001Vogh0oooo00<0
00000?ooo`3oool0O03oool00`00I_l0oooo0?ooo`0e0?ooo`00=P3oool00`00I_l0oooo0?ooo`1m
0?ooo`030000003oool0oooo07`0oooo0P00I_lf0?ooo`00=@3oool2001Vogl0oooo0P00001n0?oo
o`03001Vo`3oool0oooo03@0oooo000e0?ooo`03001Vo`3oool0oooo07h0oooo00<000000?ooo`3o
ool0O@3oool2001VocD0oooo000d0?ooo`8006KoP03oool00`000000oooo0?ooo`1n0?ooo`03001V
o`3oool0oooo03<0oooo000d0?ooo`03001Vo`3oool0oooo07l0oooo00<000000?ooo`3oool0O@3o
ool2001VocD0oooo000c0?ooo`8006KoP@3oool00`000000oooo0?ooo`1m0?ooo`<006Ko=03oool0
03<0oooo0P00I_n10?ooo`030000003oool0oooo07h0oooo0P00I_ld0?ooo`00<`3oool2001Voh40
oooo00<000000?ooo`3oool0OP3oool2001Voc@0oooo000c0?ooo`8006KoP@3oool00`000000oooo
0?ooo`1n0?ooo`8006Ko=03oool003<0oooo00<006Ko0?ooo`3oool0P03oool00`000000oooo0?oo
o`1n0?ooo`8006Ko=03oool00380oooo0P00I_n20?ooo`030000003oool0oooo07h0oooo0P00I_ld
0?ooo`00<P3oool2001Voh80oooo00<000000?ooo`3oool0OP3oool2001Voc@0oooo000b0?ooo`80
06KoPP3oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool00380oooo0P00I_n20?ooo`030000
003oool0oooo07h0oooo0P00I_ld0?ooo`00<P3oool2001Voh80oooo00<000000?ooo`3oool0OP3o
ool2001Voc@0oooo000b0?ooo`8006KoPP3oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool0
0380oooo0P00I_n20?ooo`030000003oool0oooo07h0oooo0P00I_ld0?ooo`00<P3oool2001Voh80
oooo0P00001o0?ooo`8006Ko=03oool00140oooo00<0omBK0000000000000`0000000`00Vm@0oooo
0?ooo`0H0?ooo`<006Ko9`3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000
Vm@01@3oool01@3DV`000000000000000000VmCo04<0oooo00<000000?ooo`3oool0A03oool01@3o
e9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`00000000000000
0000VmCo02<0oooo0P00I_lO0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0303o
ool001@0oooo00<0^W9b0;[Zo`3oool0703oool2001VobL0oooo00H0^W:K0=Coo`3oool0oooD09/0
V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo
0480oooo00<000000?ooo`3oool0A03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0
e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l08P3oool2001Vob80
oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0703oool2001VobH0oooo
00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo
00<000000?ooo`3oool0@`3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo
00<0omBK002Ke03oool08@3oool2001Vob80oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0
^W9b0;[Zo`3oool0703oool2001VobH0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?oo
o`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool08@3oool2001Vob80oooo00<0
^W9b0;[Zo`3oool03`3oool000P0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`03
0?ooo`030;YbLP2jj_l0oooo01d0oooo00<006Ko0?ooo`3oool06`3oool00`2jLP00000000000003
00000005001b^P3oool0oooo0>ZjLP1b^^X00`3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002K
e?l0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00
Vm@0oooo00l0oooo00<0^W8009_Do`3oool08@3oool2001Vob80oooo00<0^W9b0;[Zo`3oool03`3o
ool001@0oooo00<0^W9b0;[Zo`3oool07@3oool2001VobD0oooo00<0j[Yb07:jjP3oool00P3oool0
0`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool0@@3oool0
0`000000oooo0?ooo`130?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool0
0`3oom@0V`00000000020000000307:jjP3oool0oooo0240oooo00<006Ko0?ooo`3oool08@3oool0
0`2jLW80^^[o0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`0N0?ooo`03001Vo`3oool0oooo
02<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo
04H0oooo00<000000?ooo`3oool0@`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo
00X0oooo00<0oooD09/0V`3Dool09@3oool2001Vob<0oooo00<0^W9b0;[Zo`3oool03`3oool00140
oooo00D0j[Yb00000000L[X0^W9b0;[Zo`0O0?ooo`8006Ko9@3oool01P2jLP00VmCo0?ooo`3oj[X0
LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool0AP3oool00`000000oooo0?ooo`140?ooo`060;Yb002K
e?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0U0?ooo`8006Ko803oool01@3Z^W80
0000001b^P2jLW80^^[o0100oooo000C0?ooo`030>ZjLP000780^^[o01l0oooo0P00I_lU0?ooo`05
0?ooe02K000000000000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo
0440oooo00<000000?ooo`3oool0A03oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD
09/0000000000P0000000`0009/0e?oo0?ooo`0O0?ooo`<006Ko8P3oool00`3Z^W80001b0;[Zo`0@
0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O03oool2001VocH0oooo000e0?ooo`80
06KoO`3oool00`000000oooo0?ooo`1l0?ooo`8006Ko=P3oool003H0oooo0P00I_mn0?ooo`030000
003oool0oooo07`0oooo0P00I_lf0?ooo`00=P3oool2001Vogh0oooo00<000000?ooo`3oool0N`3o
ool3001VocH0oooo000f0?ooo`8006KoOP3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool0
03H0oooo0P00I_mn0?ooo`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00=P3oool3001Vogd0
oooo00<000000?ooo`3oool0N`3oool2001VocL0oooo000g0000008006KonP000003001VocL00000
00000`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`030?ooo`8006Ko2@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool01`3oool2001Vo`@0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo0@0000000100oooo00<00000
0?ooo`3oool08`3oool3001VobX0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1@
0?ooo`030000003oool0oooo02P0oooo0P00I_lU0?ooo`030000003oool0oooo00l0oooo000f0?oo
o`8006KoOP3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool003H0oooo0P00I_mn0?ooo`03
0000003oool0oooo07/0oooo0`00I_lf0?ooo`00=P3oool00`00I_l0oooo0?ooo`1m0?ooo`030000
003oool0oooo07`0oooo0P00I_lf0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O03o
ool2001VocH0oooo000e0?ooo`03001Vo`3oool0oooo07h0oooo00<000000?ooo`3oool0O03oool2
001VocH0oooo000d0?ooo`8006KoP03oool00`000000oooo0?ooo`1l0?ooo`<006Ko=@3oool003@0
oooo0P00I_n00?ooo`030000003oool0oooo07d0oooo0P00I_le0?ooo`00=03oool2001Voh00oooo
00<000000?ooo`3oool0O@3oool2001VocD0oooo000c0?ooo`<006KoP03oool00`000000oooo0?oo
o`1m0?ooo`8006Ko=@3oool003<0oooo0P00I_n10?ooo`030000003oool0oooo07h0oooo00<006Ko
0?ooo`3oool0<`3oool003<0oooo0P00I_n10?ooo`030000003oool0oooo07h0oooo0P00I_ld0?oo
o`00<`3oool2001Voh40oooo00<000000?ooo`3oool0O`3oool00`00I_l0oooo0?ooo`0b0?ooo`00
<`3oool2001Voh40oooo00<000000?ooo`3oool0OP3oool2001Voc@0oooo000c0?ooo`8006KoP@3o
ool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool003<0oooo00<006Ko0?ooo`3oool0P03oool2
000007l0oooo0P00I_ld0?ooo`00<P3oool2001Voh80oooo00<000000?ooo`3oool0OP3oool2001V
oc@0oooo000b0?ooo`8006KoPP3oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool00380oooo
0P00I_n20?ooo`030000003oool0oooo07h0oooo0P00I_ld0?ooo`00<P3oool2001Voh80oooo00<0
00000?ooo`3oool0OP3oool2001Voc@0oooo000b0?ooo`8006KoPP3oool00`000000oooo0?ooo`1n
0?ooo`8006Ko=03oool00380oooo0P00I_n20?ooo`030000003oool0oooo07h0oooo0P00I_ld0?oo
o`00<P3oool2001Voh80oooo00<000000?ooo`3oool0OP3oool2001Voc@0oooo000b0?ooo`8006Ko
PP3oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool00380oooo0`00I_n10?ooo`030000003o
ool0oooo07h0oooo0P00I_ld0?ooo`00<`3oool2001Voh40oooo00<000000?ooo`3oool0OP3oool2
001Voc@0oooo000c0?ooo`8006KoP@3oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool003<0
oooo0P00I_n10?ooo`030000003oool0oooo07h0oooo00<006Ko0?ooo`3oool0<`3oool003@0oooo
00<006Ko0?ooo`3oool0O`3oool00`000000oooo0?ooo`1m0?ooo`8006Ko=@3oool003@0oooo0P00
I_n00?ooo`030000003oool0oooo07d0oooo0P00I_le0?ooo`00=@3oool00`00I_l0oooo0?ooo`1n
0?ooo`030000003oool0oooo07d0oooo0P00I_le0?ooo`00=@3oool2001Vogl0oooo0P00001n0?oo
o`03001Vo`3oool0oooo03@0oooo000f0?ooo`03001Vo`3oool0oooo07d0oooo00<000000?ooo`3o
ool0O03oool2001VocH0oooo000f0?ooo`8006KoOP3oool00`000000oooo0?ooo`1l0?ooo`8006Ko
=P3oool003L0oooo00<006Ko0?ooo`3oool0O03oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3o
ool003L0oooo0P00I_mm0?ooo`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00>03oool00`00
I_l0oooo0?ooo`1k0?ooo`030000003oool0oooo07X0oooo0`00I_lg0?ooo`00>03oool2001Vog`0
oooo00<000000?ooo`3oool0N@3oool3001VocP0oooo000i0?ooo`8006KoN`3oool00`000000oooo
0?ooo`1h0?ooo`<006Ko>@3oool003X0oooo0P00I_mj0?ooo`030000003oool0oooo07P0oooo0P00
I_lj0?ooo`00>P3oool3001VogT0oooo00<000000?ooo`3oool0M`3oool2001Voc/0oooo000k0?oo
o`<006KoN03oool00`000000oooo0?ooo`1f0?ooo`8006Ko?03oool003`0oooo0`00I_mg0?ooo`03
0000003oool0oooo07D0oooo0P00I_lm0?ooo`00?@3oool3001VogH0oooo00<000000?ooo`3oool0
M03oool2001Voch0oooo000n0?ooo`<006KoM@3oool00`000000oooo0?ooo`1c0?ooo`<006Ko?P3o
ool003l0oooo0`00I_md0?ooo`030000003oool0oooo0740oooo1000I_lo0?ooo`00@03oool2001V
og@0oooo00<000000?ooo`3oool0L03oool4001Vod00oooo00100?ooo`8006KoM03oool00`000000
oooo0?ooo`1`0?ooo`<006Ko@@3oool00400oooo0P00I_md0?ooo`800000LP3oool2001Vod40oooo
00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00400oooo0P00I_md
0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00@03oool2001Vog@0oooo00<000000?oo
o`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?ooo`80
06Ko@@3oool003l0oooo0`00I_md0?ooo`030000003oool0oooo0780oooo0P00I_m00?ooo`00?`3o
ool2001VogD0oooo00<000000?ooo`3oool0LP3oool2001Vod00oooo000o0?ooo`8006KoM@3oool0
0`000000oooo0?ooo`1b0?ooo`8006Ko@03oool003l0oooo0P00I_me0?ooo`030000003oool0oooo
0780oooo0P00I_m00?ooo`00?`3oool2001VogD0oooo00<000000?ooo`3oool0LP3oool2001Vod00
oooo000o0?ooo`8006KoM@3oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003l0oooo0P00
I_me0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00?`3oool2001VogD0oooo00<00000
0?ooo`3oool0L`3oool2001Vocl0oooo000n0?ooo`8006KoMP3oool00`000000oooo0?ooo`1c0?oo
o`8006Ko?`3oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo07<0oooo0P00I_lo0?ooo`00
?P3oool2001VogH0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000n0?ooo`8006KoMP3o
ool2000007D0oooo0P00I_ln0?ooo`00?P3oool2001VogH0oooo00<000000?ooo`3oool0M03oool2
001Voch0oooo000m0?ooo`8006KoM`3oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003d0
oooo0P00I_mg0?ooo`030000003oool0oooo07@0oooo0P00I_ln0?ooo`00?@3oool2001VogL0oooo
00<000000?ooo`3oool0M03oool2001Voch0oooo000m0?ooo`8006KoM`3oool00`000000oooo0?oo
o`1d0?ooo`8006Ko?P3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07@0oooo0P00I_ln
0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000l0?ooo`80
06KoN03oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003`0oooo0P00I_mh0?ooo`030000
003oool0oooo07@0oooo0P00I_ln0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0M03o
ool2001Voch0oooo000l0?ooo`8006KoN03oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool0
03`0oooo0P00I_mh0?ooo`030000003oool0oooo07@0oooo0`00I_lm0?ooo`00?03oool2001VoeX0
oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/00000
00000000000009_Do`070?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001V
oeX0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0
e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0M@3oool2001Vocd0
oooo000l0?ooo`8006KoF@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo
00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo0P00
I_mI0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?oo
o`050?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VoeT0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo00D0oooo0`00001e
0?ooo`8006Ko?@3oool003`0oooo0P00I_mI0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002K
e03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?oo
o`3oool0M@3oool2001Vocd0oooo000l0?ooo`8006KoF@3oool00`3oe9/0L[[Z0?ooo`020?ooo`03
0>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1e0?ooo`80
06Ko?@3oool003`0oooo0P00I_mJ0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3o
om@0V`2K0=Coo`0:0?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VoeX0
oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Co
o`3oool01@3oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo0P00I_mh0?ooo`03
0000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0
M@3oool2001Vocd0oooo000l0?ooo`8006KoN03oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3o
ool003`0oooo0P00I_mh0?ooo`030000003oool0oooo07D0oooo0P00I_lm0?ooo`00?03oool2001V
ogP0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l0?ooo`8006KoN03oool00`000000
oooo0?ooo`1e0?ooo`8006Ko?@3oool003`0oooo0P00I_mh0?ooo`030000003oool0oooo07@0oooo
0`00I_lm0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0M03oool2001Voch0oooo000l
0?ooo`<006KoM`3oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003d0oooo0P00I_mg0?oo
o`030000003oool0oooo07@0oooo0P00I_ln0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3o
ool0M03oool2001Voch0oooo000m0?ooo`<006KoMP3oool2000007D0oooo0P00I_ln0?ooo`00?P3o
ool2001VogH0oooo00<000000?ooo`3oool0L`3oool3001Voch0oooo000n0?ooo`8006KoMP3oool0
0`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003h0oooo0`00I_me0?ooo`030000003oool0oooo
07<0oooo0P00I_lo0?ooo`00?`3oool2001VogD0oooo00<000000?ooo`3oool0LP3oool3001Vocl0
oooo000o0?ooo`8006KoM@3oool00`000000oooo0?ooo`1b0?ooo`8006Ko@03oool003l0oooo0`00
I_md0?ooo`030000003oool0oooo0780oooo0P00I_m00?ooo`00@03oool2001Vog@0oooo00<00000
0?ooo`3oool0L@3oool3001Vod00oooo00100?ooo`8006KoM03oool00`000000oooo0?ooo`1a0?oo
o`8006Ko@@3oool00400oooo0`00I_mc0?ooo`030000003oool0oooo0740oooo0P00I_m10?ooo`00
@@3oool2001Vog<0oooo00<000000?ooo`3oool0L03oool3001Vod40oooo00120?ooo`03001Vo`3o
ool0oooo0740oooo00<000000?ooo`3oool0L03oool2001Vod80oooo00120?ooo`8006KoLP3oool0
0`000000oooo0?ooo`1`0?ooo`8006Ko@P3oool004<0oooo00<006Ko0?ooo`3oool0L03oool00`00
0000oooo0?ooo`1`0?ooo`03001Vo`3oool0oooo0440oooo00130?ooo`8006KoL@3oool00`000000
oooo0?ooo`1_0?ooo`8006Ko@`3oool004@0oooo00<006Ko0?ooo`3oool0K`3oool00`000000oooo
0?ooo`0/0?ooo`03001Vo`3oool0oooo03l0oooo0P00I_m40?ooo`00A03oool2001Vog00oooo00<0
00000?ooo`3oool0;03oool2001Vocl0oooo0P00I_m50?ooo`00A@3oool2001Vofl0oooo0P00000]
0?ooo`<006Ko?P3oool00`00I_l0oooo0?ooo`140?ooo`00AP3oool2001Voc/0oooo1000I_l_0?oo
o`030000003oool0oooo02`0oooo1000I_ll0?ooo`8006KoAP3oool004H0oooo0`00I_lh0?ooo`H0
06Ko;`3oool00`000000oooo0?ooo`0/0?ooo`L006Ko>03oool2001VodL0oooo00170?ooo`<006Ko
=@3oool5001Vo`040?ooo`00I_l006Ko001Vobh0oooo00<000000?ooo`3oool0;03oool2001Vo`03
0?ooo`00I_l006Ko00<006Ko=P3oool2001VodP0oooo00180?ooo`<006Ko<P3oool5001Vo`@0oooo
0P00I_l^0?ooo`030000003oool0oooo02`0oooo0P00I_l40?ooo`@006Ko<`3oool2001VodT0oooo
00190?ooo`<006Ko;`3oool5001Vo`H0oooo0P00I_l^0?ooo`030000003oool0oooo02`0oooo0P00
I_l50?ooo`D006Ko;`3oool4001VodT0oooo001:0?ooo`<006Ko;03oool5001Vo`P0oooo0P00I_l^
0?ooo`030000003oool0oooo02/0oooo0`00I_l70?ooo`D006Ko;03oool4001VodX0oooo001;0?oo
o`D006Ko9`3oool5001Vo`X0oooo0`00I_l]0?ooo`030000003oool0oooo02/0oooo0P00I_l:0?oo
o`D006Ko:03oool4001Vod`0oooo001<0?ooo`D006Ko903oool5001Vo`d0oooo0P00I_l]0?ooo`03
0000003oool0oooo02/0oooo0P00I_l<0?ooo`H006Ko903oool4001Vodd0oooo001?0?ooo`@006Ko
803oool5001Vo`l0oooo0P00I_l]0?ooo`030000003oool0oooo02X0oooo0`00I_l>0?ooo`L006Ko
7`3oool4001Vodl0oooo001@0?ooo`@006Ko7@3oool5001Voa40oooo0P00I_l]0?ooo`030000003o
ool0oooo02X0oooo0P00I_lB0?ooo`L006Ko6@3oool6001Voe00oooo001B0?ooo`L006Ko4@3oool:
001Voa<0oooo0`00I_l/0?ooo`030000003oool0oooo02X0oooo0P00I_lE0?ooo`L006Ko4`3oool7
001Voe80oooo001C0?ooo`T006Ko2`3oool;001VoaH0oooo0P00I_l/0?ooo`030000003oool0oooo
02T0oooo0`00I_lI0?ooo`P006Ko303oool6001VoeD0oooo001H0?oooa<006Ko7@3oool2001Vob`0
oooo00<000000?ooo`3oool0:@3oool2001Voa`0oooo5@00I_mH0?ooo`00F`3oool=001Vob00oooo
0`00I_l[0?ooo`030000003oool0oooo02T0oooo0P00I_lQ0?ooo`h006KoFP3oool008T0oooo0P00
I_l[0?ooo`030000003oool0oooo02P0oooo0`00I_n90?ooo`00R@3oool2001Vob/0oooo00<00000
0?ooo`3oool0:03oool2001VohX0oooo00290?ooo`<006Ko:P3oool2000002T0oooo0P00I_n:0?oo
o`00RP3oool2001VobX0oooo00<000000?ooo`3oool09`3oool3001VohX0oooo002:0?ooo`<006Ko
:@3oool00`000000oooo0?ooo`0W0?ooo`8006KoR`3oool008/0oooo0P00I_lY0?ooo`030000003o
ool0oooo02L0oooo0P00I_n;0?ooo`00R`3oool2001VobT0oooo00<000000?ooo`3oool09P3oool3
001Voh/0oooo002<0?ooo`03001Vo`3oool0oooo02L0oooo00<000000?ooo`3oool09P3oool2001V
oh`0oooo002<0?ooo`8006Ko:03oool00`000000oooo0?ooo`0V0?ooo`8006KoS03oool008d0oooo
00<006Ko0?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`<006KoS03oool008d0oooo0P00
I_lW0?ooo`030000003oool0oooo02D0oooo0P00I_n=0?ooo`00SP3oool00`00I_l0oooo0?ooo`0U
0?ooo`030000003oool0oooo02@0oooo0`00I_n=0?ooo`00SP3oool2001VobH0oooo00<000000?oo
o`3oool0903oool2001Vohh0oooo002?0?ooo`03001Vo`3oool0oooo02@0oooo00<000000?ooo`3o
ool0903oool2001Vohh0oooo002?0?ooo`8006Ko9@3oool00`000000oooo0?ooo`0T0?ooo`03001V
o`3oool0oooo08d0oooo002@0?ooo`8006Ko903oool00`000000oooo0?ooo`0S0?ooo`8006KoS`3o
ool00940oooo00<006Ko0?ooo`3oool08P3oool00`000000oooo0?ooo`0S0?ooo`03001Vo`3oool0
oooo08h0oooo002A0?ooo`8006Ko8`3oool00`000000oooo0?ooo`0R0?ooo`8006KoT03oool00980
oooo00<006Ko0?ooo`3oool08@3oool200000280oooo0P00I_nA0?ooo`00TP3oool2001Vob80oooo
00<000000?ooo`3oool08@3oool00`00I_l0oooo0?ooo`2@0?ooo`00T`3oool00`00I_l0oooo0?oo
o`0P0?ooo`030000003oool0oooo0200oooo0P00I_nB0?ooo`00T`3oool2001Vob40oooo00<00000
0?ooo`3oool0803oool00`00I_l0oooo0?ooo`2A0?ooo`00U03oool00`00I_l0oooo0?ooo`0O0?oo
o`030000003oool0oooo01l0oooo0P00I_nC0?ooo`00U03oool2001Vob00oooo00<000000?ooo`3o
ool07P3oool2001Voi@0oooo002E0?ooo`8006Ko7`3oool00`000000oooo0?ooo`0N0?ooo`03001V
o`3oool0oooo09<0oooo002F0?ooo`03001Vo`3oool0oooo01d0oooo00<000000?ooo`3oool07@3o
ool2001VoiD0oooo002F0?ooo`8006Ko7P3oool00`000000oooo0?ooo`0L0?ooo`8006KoUP3oool0
09L0oooo0P00I_lM0?ooo`030000003oool0oooo01/0oooo0P00I_nG0?ooo`00U`3oool3001Voa`0
oooo00<000000?ooo`3oool06P3oool3001VoiL0oooo002H0?ooo`8006Ko703oool00`000000oooo
0?ooo`0J0?ooo`8006KoV03oool009T0oooo0P00I_lK0?ooo`030000003oool0oooo01T0oooo0P00
I_nI0?ooo`00V@3oool3001Vo`d0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`04
0?ooo`030000003oool0oooo01P0oooo0`00I_nI0?ooo`00VP3oool3001Vo`l0oooo00<0^W9b0;[Z
o`3oool01`3oool00`000000oooo0?ooo`0G0?ooo`<006KoVP3oool009/0oooo0`00I_l>0?ooo`03
0;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool4001Voi/0oooo002L0?ooo`<006Ko
3@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01@0oooo1000I_nL0?ooo`00W@3o
ool4001Vo`/0oooo00<0^W9b0;[Zo`3oool01`3oool3000001<0oooo0`00I_nN0?ooo`00WP3oool4
001Vo`X0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0A0?ooo`@006KoW`3oool0
0:00oooo0`00I_l90?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0403oool4001V
oj00oooo002Q0?ooo`@006Ko103oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?oo
o`3oool03P3oool4001Voj80oooo002R0?ooo`@006Ko1@3oool00`3Z^W80001b0;[Zo`080?ooo`03
0000003oool0oooo00d0oooo1000I_nS0?ooo`00Y03oool3001Vo`l0oooo00<000000?ooo`3oool0
2`3oool4001VojD0oooo002U0?ooo`@006Ko3@3oool00`000000oooo0?ooo`090?ooo`D006KoYP3o
ool00:H0oooo1P00I_l:0?ooo`030000003oool0oooo00P0oooo1000I_nX0?ooo`00Z03oool7001V
o`L0oooo00<000000?ooo`3oool00`3oool7001VojX0oooo002[0?ooo`X006Ko00<0oooo0000003o
ool02P00I_n[0?ooo`00[P3oool?001Vok00oooo002d0?ooo`D006Ko]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo0P00002e0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo0000\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.88182 .59091 m
.8844 .6027 L
.88637 .61382 L
.88725 .62014 L
.88791 .62613 L
.8882 .62946 L
.88844 .63307 L
.8886 .63635 L
.8887 .63939 L
.88874 .64236 L
.88873 .64556 L
.88866 .64858 L
.88854 .65134 L
.88834 .65456 L
.88805 .65806 L
.8873 .66442 L
.88622 .671 L
.88472 .67794 L
.8811 .69021 L
.85003 .79735 L
.8494 .80458 L
.84857 .81237 L
.8466 .82648 L
.84378 .84116 L
.83963 .85704 L
.83363 .87392 L
.82672 .88857 L
.81845 .90216 L
.80927 .91397 L
.79926 .92417 L
.78738 .93361 L
.77629 .94043 L
.76313 .94655 L
.7554 .9493 L
.7481 .95138 L
.73988 .9532 L
.73568 .95392 L
.73102 .95457 L
.72686 .95502 L
.72305 .95533 L
.72093 .95546 L
.71862 .95556 L
.71441 .95567 L
.71044 .95566 L
.70621 .95555 L
.7026 .95538 L
.69861 .95509 L
.69438 .95469 L
.69045 .95423 L
.68154 .95289 L
Mistroke
.6737 .95136 L
.66538 .94941 L
.65725 .94719 L
.65329 .946 L
.64967 .94485 L
.64639 .94376 L
.64462 .94669 L
.64108 .95361 L
.62343 .9838 L
.61214 .99963 L
.60038 1.01367 L
.5884 1.02576 L
.57442 1.03737 L
.56211 1.04562 L
.54791 1.05306 L
.53408 1.05834 L
.52636 1.06048 L
.5228 1.06128 L
.51904 1.06199 L
.51576 1.06251 L
.51217 1.06297 L
.50891 1.06328 L
.50586 1.06348 L
.50225 1.06361 L
.49897 1.06363 L
.49519 1.06353 L
.49162 1.06332 L
.48802 1.06299 L
.48416 1.0625 L
.47723 1.06128 L
.46905 1.05928 L
.46168 1.05692 L
.44605 1.05016 L
.43184 1.04179 L
.40865 1.02298 L
.38655 .99791 L
.36694 .96822 L
.36282 .9609 L
.35868 .95316 L
.35704 .94997 L
.35532 .94656 L
.353 .94396 L
.34932 .94518 L
.33383 .94961 L
.32573 .95148 L
.31692 .95315 L
.31186 .95393 L
.30719 .95452 L
.30274 .95498 L
.30047 .95517 L
Mistroke
.29804 .95534 L
.29384 .95555 L
.28993 .95566 L
.28755 .95568 L
.28529 .95566 L
.28108 .95555 L
.27711 .95534 L
.27489 .95517 L
.27285 .95499 L
.2692 .9546 L
.26523 .95406 L
.25841 .95287 L
.25136 .95125 L
.24386 .94906 L
.23606 .94622 L
.2227 .93988 L
.21034 .93198 L
.19967 .92319 L
.18259 .90365 L
.17522 .89208 L
.16832 .87846 L
.16245 .86349 L
.1581 .84897 L
.15496 .83517 L
.15277 .82242 L
.15099 .80842 L
.15031 .80142 L
.1497 .79381 L
.14921 .78632 L
.14879 .77828 L
.14821 .76395 L
.14779 .7515 L
.14756 .74503 L
.14743 .7415 L
.14729 .73817 L
.14678 .73652 L
.14545 .73503 L
.14316 .73238 L
.13889 .72707 L
.13052 .71482 L
.12404 .70276 L
.11921 .69109 L
.11539 .67838 L
.11379 .67109 L
.11268 .66432 L
.11197 .65833 L
.11168 .65491 L
.11148 .65173 L
.11134 .64835 L
.11127 .64528 L
Mistroke
.11126 .64358 L
.11126 .64173 L
.11133 .63837 L
.11144 .63536 L
.11159 .63253 L
.1118 .62944 L
.11209 .62611 L
.11285 .61936 L
.11373 .6132 L
.11591 .60117 L
.11701 .59597 L
.11763 .59326 L
.11806 .59039 L
.11731 .58717 L
.11665 .58419 L
.11544 .5783 L
.11421 .57157 L
.11322 .56524 L
.11247 .55934 L
.11193 .55393 L
.11169 .55084 L
.11151 .54791 L
.11137 .54482 L
.11128 .54145 L
.11126 .53811 L
.1113 .53498 L
.11141 .53154 L
.11151 .52961 L
.11162 .52785 L
.11188 .5245 L
.11226 .52084 L
.1133 .51351 L
.11452 .50714 L
.11617 .5004 L
.12003 .48851 L
.15012 .38263 L
.15081 .37512 L
.15173 .36701 L
.15391 .35232 L
.15705 .33708 L
.16169 .32061 L
.16717 .30598 L
.17356 .29271 L
.18881 .27009 L
.19813 .26009 L
.20921 .25067 L
.2207 .24308 L
.2319 .23736 L
.24598 .23209 L
.25427 .22985 L
Mistroke
.26208 .22826 L
.26908 .22723 L
.27309 .2268 L
.27687 .2265 L
.28089 .22628 L
.28457 .22617 L
.28662 .22614 L
.28884 .22615 L
.29291 .22623 L
.29687 .22641 L
.30052 .22666 L
.30453 .22701 L
.30876 .22748 L
.31589 .2285 L
.32369 .22991 L
.33283 .23196 L
.3414 .23423 L
.34902 .23655 L
.3511 .23722 L
.35329 .23795 L
.35544 .23501 L
.36383 .21908 L
.37382 .20227 L
.39473 .1737 L
.41772 .15067 L
.43195 .13996 L
.44566 .13186 L
.45892 .12591 L
.46659 .12327 L
.47378 .1213 L
.4801 .11998 L
.48376 .11938 L
.48713 .11893 L
.49067 .11857 L
.49451 .11832 L
.49789 .1182 L
.50145 .11819 L
.50528 .11831 L
.50744 .11843 L
.50944 .11858 L
.5131 .11896 L
.51696 .11948 L
.52363 .12071 L
.53091 .12253 L
.53858 .12499 L
.5467 .12822 L
.56097 .13552 L
.57456 .14455 L
.58678 .15459 L
.60765 .17655 L
Mistroke
.62718 .20385 L
.63646 .2196 L
.64066 .22741 L
.64244 .23083 L
.64434 .23459 L
.64609 .2381 L
.64952 .23702 L
.65716 .23465 L
.67344 .23051 L
.68053 .22911 L
.68725 .22802 L
.69096 .22752 L
.695 .22706 L
.69843 .22674 L
.70204 .22648 L
.706 .22627 L
.70962 .22617 L
.7135 .22614 L
.71771 .22623 L
.72136 .22639 L
.72522 .22665 L
.72884 .227 L
.73211 .22738 L
.74002 .22864 L
.7484 .23051 L
.7561 .23275 L
.76301 .23522 L
.77623 .24136 L
.78965 .24983 L
.80226 .26046 L
.81266 .27188 L
.82129 .28394 L
.82924 .29816 L
.83541 .3124 L
.84003 .32613 L
.84365 .34008 L
.84618 .35287 L
.84836 .36769 L
.84979 .38157 L
.85035 .38875 L
.85078 .3954 L
.85151 .41028 L
.85205 .42559 L
.85227 .43214 L
.85239 .43555 L
.85253 .43914 L
.85265 .44221 L
.85327 .44536 L
.8553 .44764 L
.85715 .44981 L
Mistroke
.8642 .45894 L
.87123 .46997 L
.87673 .48071 L
.88149 .49274 L
.88366 .4998 L
.88529 .5063 L
.88647 .51214 L
.88746 .51852 L
.88788 .52205 L
.88819 .52531 L
.88842 .52843 L
.8886 .53173 L
.8887 .53474 L
.88874 .53748 L
.88873 .54064 L
.88867 .54364 L
.88856 .54641 L
.88843 .54897 L
.88824 .55178 L
.888 .55476 L
.88734 .56094 L
.88656 .56672 L
.88427 .57978 L
.88182 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00:`0oooo
4`00I_n^0?ooo`00ZP3ooolK001VojP0oooo002W0?ooo`H006Ko2@3oool00`000000oooo0?ooo`05
0?ooo`X006KoY@3oool00:@0oooo1`00I_l400000003002Ke03oool0oooo00@0oooo00<000000?oo
o`3oool02`3oool6001Voj<0oooo002R0?ooo`H006Ko103oool00`2jLW80^^[o0?ooo`070?ooo`03
0000003oool0oooo00h0oooo1000I_nR0?ooo`00X03oool5001Vo`L0oooo00<0^W9b0;[Zo`3oool0
1`3oool00`000000oooo0?ooo`0@0?ooo`@006KoX03oool009l0oooo1000I_l90?ooo`030;YbLP2j
j_l0oooo00L0oooo0`00000A0?ooo`D006KoWP3oool009d0oooo1000I_l500000003001b^P3oool0
oooo00<0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`@006KoW@3oool0
09`0oooo1000I_l<0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool4001V
oi/0oooo002J0?ooo`@006Ko3P3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01H0
oooo1000I_nJ0?ooo`00V@3oool4001Vo``0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`03
0000003oool0oooo01P0oooo0`00I_nI0?ooo`00V03oool3001Voa00oooo00<0j[Yb0000LP2jj_l0
203oool00`000000oooo0?ooo`0I0?ooo`<006KoV03oool009L0oooo0`00I_lL0?ooo`030000003o
ool0oooo01X0oooo0`00I_nG0?ooo`00UP3oool3001Voad0oooo00<000000?ooo`3oool06`3oool3
001VoiH0oooo002E0?ooo`<006Ko7P3oool00`000000oooo0?ooo`0L0?ooo`<006KoU@3oool009<0
oooo1000I_lO0?ooo`030000003oool0oooo01d0oooo0`00I_nD0?ooo`00TP3oool4001Vob00oooo
00<000000?ooo`3oool07P3oool3001Voi<0oooo002A0?ooo`<006Ko8P3oool00`000000oooo0?oo
o`0O0?ooo`<006KoTP3oool00900oooo0`00I_lS0?ooo`030000003oool0oooo0200oooo0`00I_nA
0?ooo`00S`3oool3001Vob@0oooo00<000000?ooo`3oool08@3oool3001Voi00oooo002?0?ooo`80
06Ko9@3oool00`000000oooo0?ooo`0R0?ooo`<006KoS`3oool008h0oooo0P00I_lV0?ooo`030000
003oool0oooo02<0oooo0`00I_n>0?ooo`00S@3oool2001VobL0oooo00<000000?ooo`3oool0903o
ool2001Vohh0oooo002=0?ooo`03001Vo`3oool0oooo02H0oooo0P00000V0?ooo`8006KoS@3oool0
08`0oooo0P00I_lX0?ooo`030000003oool0oooo02H0oooo00<006Ko0?ooo`3oool0R`3oool008/0
oooo0P00I_lY0?ooo`030000003oool0oooo02H0oooo0P00I_n<0?ooo`00RP3oool2001VobX0oooo
00<000000?ooo`3oool09`3oool2001Voh/0oooo002:0?ooo`03001Vo`3oool0oooo02T0oooo00<0
00000?ooo`3oool0:03oool2001VohX0oooo00290?ooo`8006Ko:`3oool00`000000oooo0?ooo`0Y
0?ooo`03001Vo`3oool0oooo08P0oooo00280?ooo`8006Ko;03oool00`000000oooo0?ooo`0Y0?oo
o`8006KoR@3oool008P0oooo00<006Ko0?ooo`3oool0:`3oool00`000000oooo0?ooo`0Z0?ooo`80
06KoR03oool008L0oooo0P00I_l]0?ooo`030000003oool0oooo02/0oooo00<006Ko0?ooo`3oool0
QP3oool008L0oooo00<006Ko0?ooo`3oool0;03oool00`000000oooo0?ooo`0[0?ooo`8006KoQ`3o
ool008H0oooo0P00I_l^0?ooo`030000003oool0oooo02`0oooo00<006Ko0?ooo`3oool0Q@3oool0
08D0oooo0P00I_l_0?ooo`030000003oool0oooo02`0oooo0P00I_n60?ooo`00Q@3oool00`00I_l0
oooo0?ooo`0^0?ooo`030000003oool0oooo02d0oooo00<006Ko0?ooo`3oool0Q03oool008@0oooo
0P00I_l`0?ooo`030000003oool0oooo02d0oooo0P00I_n50?ooo`00Q03oool00`00I_l0oooo0?oo
o`0_0?ooo`030000003oool0oooo02h0oooo00<006Ko0?ooo`3oool0P`3oool008<0oooo0P00I_la
0?ooo`030000003oool0oooo02h0oooo0P00I_n40?ooo`00G03oool00`00I_l0oooo0?ooo`030?oo
o`l006Ko4@3oool2001Voc80oooo00<000000?ooo`3oool0;`3oool2001Voa40oooo4000I_mR0?oo
o`00F@3ooolP001Vo`T0oooo00<006Ko0?ooo`3oool0<@3oool200000340oooo0P00I_l:0?oooa`0
06KoG03oool005H0oooo3@00I_l=0?ooo`d006Ko103oool2001Voc<0oooo00<000000?ooo`3oool0
<03oool2001Vo`@0oooo3@00I_l>0?ooo`X006KoF@3oool005@0oooo1P00I_lO0?ooo`T006Ko=03o
ool00`000000oooo0?ooo`0`0?ooo``006Ko6`3oool8001VoeD0oooo001B0?ooo`D006Ko9@3oool6
001Voc@0oooo00<000000?ooo`3oool0<@3oool6001Vob<0oooo1`00I_mC0?ooo`00D03oool5001V
obX0oooo0P00I_le0?ooo`030000003oool0oooo0380oooo0P00I_lZ0?ooo`@006KoDP3oool004l0
oooo1000I_mS0?ooo`030000003oool0oooo0600oooo1000I_m@0?ooo`00C@3oool4001VofD0oooo
00<000000?ooo`3oool0H@3oool4001Vodl0oooo001<0?ooo`@006KoIP3oool00`000000oooo0?oo
o`1S0?ooo`@006KoC@3oool004/0oooo0`00I_mX0?ooo`030000003oool0oooo06@0oooo1000I_m<
0?ooo`00B@3oool4001VofT0oooo00<000000?ooo`3oool0IP3oool3001Vod/0oooo00180?ooo`@0
06KoJP3oool00`000000oooo0?ooo`1W0?ooo`@006KoB@3oool004L0oooo0`00I_m/0?ooo`030000
003oool0oooo06P0oooo1000I_m80?ooo`00AP3oool3001Vofd0oooo00<000000?ooo`3oool0JP3o
ool3001VodL0oooo00150?ooo`<006KoKP3oool00`000000oooo0?ooo`1[0?ooo`<006KoAP3oool0
04@0oooo0`00I_m_0?ooo`030000003oool0oooo06`0oooo0`00I_m50?ooo`00A03oool2001Vog00
oooo00<000000?ooo`3oool0K@3oool3001Vod@0oooo00130?ooo`8006KoL@3oool2000006l0oooo
0P00I_m40?ooo`00@P3oool2001Vog80oooo00<000000?ooo`3oool0K`3oool2001Vod<0oooo0012
0?ooo`03001Vo`3oool0oooo0740oooo00<000000?ooo`3oool0L03oool2001Vod80oooo00110?oo
o`8006KoL`3oool00`000000oooo0?ooo`1a0?ooo`8006Ko@@3oool00440oooo00<006Ko0?ooo`3o
ool0LP3oool00`000000oooo0?ooo`1b0?ooo`03001Vo`3oool0oooo03l0oooo00100?ooo`8006Ko
M03oool00`000000oooo0?ooo`1b0?ooo`8006Ko@03oool003l0oooo0P00I_me0?ooo`030000003o
ool0oooo07<0oooo00<006Ko0?ooo`3oool0?P3oool003l0oooo00<006Ko0?ooo`3oool0M03oool0
0`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo
07@0oooo0P00I_ln0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3oool0M@3oool00`00I_l0
oooo0?ooo`0l0?ooo`00?@3oool00`00I_l0oooo0?ooo`1f0?ooo`030000003oool0oooo07D0oooo
0P00I_lm0?ooo`00?03oool2001VogP0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l
0?ooo`03001Vo`3oool0oooo07L0oooo00<000000?ooo`3oool0M@3oool3001Voc`0oooo000k0?oo
o`8006KoN@3oool00`000000oooo0?ooo`1f0?ooo`8006Ko?03oool003/0oooo0P00I_mi0?ooo`03
0000003oool0oooo07H0oooo0P00I_ll0?ooo`00>P3oool3001VogT0oooo00<000000?ooo`3oool0
MP3oool3001Voc/0oooo000j0?ooo`8006KoNP3oool00`000000oooo0?ooo`1g0?ooo`8006Ko>`3o
ool003X0oooo0P00I_mj0?ooo`800000N03oool2001Voc/0oooo000i0?ooo`<006KoNP3oool00`00
0000oooo0?ooo`1g0?ooo`<006Ko>P3oool003T0oooo0P00I_mk0?ooo`030000003oool0oooo07P0
oooo0P00I_lj0?ooo`00>@3oool2001Vog/0oooo00<000000?ooo`3oool0N03oool2001VocX0oooo
000i0?ooo`8006KoN`3oool00`000000oooo0?ooo`1i0?ooo`8006Ko>@3oool003T0oooo0P00I_mk
0?ooo`030000003oool0oooo07T0oooo0P00I_li0?ooo`00>@3oool2001Vog/0oooo00<000000?oo
o`3oool0N@3oool2001VocT0oooo000h0?ooo`8006KoO03oool00`000000oooo0?ooo`1i0?ooo`80
06Ko>@3oool003P0oooo0P00I_ml0?ooo`030000003oool0oooo07T0oooo0`00I_lh0?ooo`00>03o
ool2001Vog`0oooo00<000000?ooo`3oool0NP3oool2001VocP0oooo000h0?ooo`8006KoO03oool0
0`000000oooo0?ooo`1j0?ooo`8006Ko>03oool003P0oooo0P00I_ml0?ooo`030000003oool0oooo
07X0oooo0P00I_lh0?ooo`00=`3oool2001Vogd0oooo00<000000?ooo`3oool0NP3oool2001VocP0
oooo000g0?ooo`8006KoG`3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000
Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo00<000000?ooo`3oool0N`3oool2001V
ocL0oooo000g0?ooo`8006KoG`3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/0
00000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo
0?ooo`1k0?ooo`8006Ko=`3oool003L0oooo0P00I_mN0?ooo`030?oDV`00Vm@0oooo0080oooo00<0
j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo07/0oooo0P00
I_lg0?ooo`00=`3oool2001Voeh0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?
0?ooo`030?oDV`00Vm@0oooo00D0oooo0`00001k0?ooo`8006Ko=`3oool003H0oooo0P00I_mF0?oo
o`030;Yb00000000000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0
oooo00l0oooo00<0^W8009_Do`3oool01@3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool0
03H0oooo0P00I_mO0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3o
om@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool0N`3oool2001V
ocL0oooo000f0?ooo`8006KoG`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0
oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool003D0oooo
0`00I_mP0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?oo
o`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00=@3oool2001Vof40oooo00D0oooD09/00000
0000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool01@3oool00`00
0000oooo0?ooo`1k0?ooo`8006Ko=`3oool003D0oooo0P00I_mo0?ooo`030000003oool0oooo07/0
oooo0P00I_lg0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0N`3oool2001VocL0oooo
000e0?ooo`8006KoO`3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool003D0oooo0P00I_mo
0?ooo`030000003oool0oooo07/0oooo0`00I_lf0?ooo`00=@3oool2001Vogl0oooo00<000000?oo
o`3oool0O03oool2001VocH0oooo000d0?ooo`<006KoO`3oool00`000000oooo0?ooo`1l0?ooo`80
06Ko=P3oool003@0oooo0P00I_n00?ooo`030000003oool0oooo07`0oooo0P00I_lf0?ooo`00=03o
ool2001Voh00oooo00<000000?ooo`3oool0O03oool2001VocH0oooo000c0?ooo`<006KoP03oool0
0`000000oooo0?ooo`1l0?ooo`8006Ko=P3oool003<0oooo0P00I_n10?ooo`030000003oool0oooo
07`0oooo0P00I_lf0?ooo`00<`3oool2001Voh40oooo00<000000?ooo`3oool0O03oool2001VocH0
oooo000c0?ooo`8006KoP@3oool2000007d0oooo0P00I_lf0?ooo`00<P3oool3001Voh40oooo00<0
00000?ooo`3oool0O03oool2001VocH0oooo000b0?ooo`8006KoPP3oool00`000000oooo0?ooo`1l
0?ooo`8006Ko=P3oool00380oooo0P00I_n20?ooo`030000003oool0oooo07`0oooo0P00I_lf0?oo
o`00<@3oool3001Voh80oooo00<000000?ooo`3oool0O03oool2001VocH0oooo000a0?ooo`8006Ko
P`3oool00`000000oooo0?ooo`1l0?ooo`8006Ko=P3oool00340oooo0P00I_n30?ooo`030000003o
ool0oooo07`0oooo0P00I_lf0?ooo`00<@3oool2001Voh<0oooo00<000000?ooo`3oool0O03oool2
001VocH0oooo000`0?ooo`<006KoP`3oool00`000000oooo0?ooo`1l0?ooo`8006Ko=P3oool00300
oooo0P00I_n40?ooo`030000003oool0oooo07`0oooo0P00I_lf0?ooo`00<03oool2001Voh@0oooo
00<000000?ooo`3oool0O03oool2001VocH0oooo000_0?ooo`<006KoQ03oool00`000000oooo0?oo
o`1l0?ooo`8006Ko=P3oool002l0oooo0P00I_n50?ooo`030000003oool0oooo07`0oooo0`00I_le
0?ooo`00;`3oool2001VohD0oooo00<000000?ooo`3oool0O@3oool2001VocD0oooo000_0?ooo`80
06KoQ@3oool00`000000oooo0?ooo`1m0?ooo`<006Ko=03oool002h0oooo0`00I_n50?ooo`030000
003oool0oooo07h0oooo0`00I_lc0?ooo`00;P3oool2001VohH0oooo0P0000200?ooo`<006Ko<P3o
ool002h0oooo0P00I_n60?ooo`030000003oool0oooo0800oooo0`00I_la0?ooo`00;@3oool3001V
ohH0oooo00<000000?ooo`3oool0P@3oool2001Voc40oooo000]0?ooo`8006KoQ`3oool00`000000
oooo0?ooo`220?ooo`8006Ko<03oool002d0oooo0P00I_n70?ooo`030000003oool0oooo08<0oooo
00<006Ko0?ooo`3oool0;P3oool002d0oooo0P00I_n70?ooo`030000003oool0oooo08<0oooo0P00
I_l_0?ooo`00;03oool3001VohL0oooo00<000000?ooo`3oool0Q03oool00`00I_l0oooo0?ooo`0]
0?ooo`00;03oool2001VohP0oooo00<000000?ooo`3oool0Q03oool2001Vobh0oooo000/0?ooo`80
06KoR03oool00`000000oooo0?ooo`250?ooo`03001Vo`3oool0oooo02`0oooo000[0?ooo`<006Ko
R03oool00`000000oooo0?ooo`250?ooo`8006Ko;@3oool002/0oooo0P00I_n90?ooo`030000003o
ool0oooo08H0oooo00<006Ko0?ooo`3oool0:`3oool002/0oooo0P00I_n90?ooo`030000003oool0
oooo08H0oooo0P00I_l/0?ooo`00:`3oool2001VohT0oooo00<000000?ooo`3oool0Q`3oool00`00
I_l0oooo0?ooo`0Z0?ooo`00:P3oool3001VohT0oooo00<000000?ooo`3oool0Q`3oool2001Vob/0
oooo000Z0?ooo`8006KoRP3oool00`000000oooo0?ooo`280?ooo`03001Vo`3oool0oooo02T0oooo
000Z0?ooo`8006KoRP3oool00`000000oooo0?ooo`280?ooo`8006Ko:P3oool002X0oooo0P00I_n:
0?ooo`030000003oool0oooo08P0oooo0P00I_lZ0?ooo`00:@3oool3001VohX0oooo0P0000290?oo
o`8006Ko:P3oool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08P0oooo0P00I_lZ0?ooo`00
:@3oool2001Voh/0oooo00<000000?ooo`3oool0R@3oool00`00I_l0oooo0?ooo`0X0?ooo`00:03o
ool3001Voh/0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000X0?ooo`8006KoS03oool0
0`000000oooo0?ooo`2:0?ooo`03001Vo`3oool0oooo02L0oooo000X0?ooo`8006KoS03oool00`00
0000oooo0?ooo`290?ooo`8006Ko:@3oool002P0oooo0P00I_n<0?ooo`030000003oool0oooo08T0
oooo0P00I_lY0?ooo`00:03oool2001Voh`0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo
000W0?ooo`<006KoS03oool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0oooo0P00I_n=
0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`009`3oool2001Vohd0oooo00<000000?oo
o`3oool0R@3oool2001VobT0oooo000W0?ooo`8006KoS@3oool00`000000oooo0?ooo`290?ooo`80
06Ko:@3oool002L0oooo0P00I_n=0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`009`3o
ool2001Vohd0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000W0?ooo`8006KoS@3oool0
0`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0oooo0P00I_n=0?ooo`030000003oool0oooo
08T0oooo0P00I_lY0?ooo`009`3oool2001Vohd0oooo0P00002:0?ooo`8006Ko:@3oool00140oooo
00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0=0?ooo`8006Ko<`3oool01@3oe9/00000
000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo
04<0oooo00<000000?ooo`3oool0A03oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/0
00000000Vm@01@3oool01@3DV`000000000000000000VmCo02h0oooo0P00I_lD0?ooo`030?oDV`00
0000000000<0000000<009_D0?ooo`3oool0303oool001@0oooo00<0^W9b0;[Zo`3oool0403oool2
001Voc<0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo
00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo0480oooo00<000000?ooo`3oool0A03oool01P2j
LY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?oo
o`3oool0onZj0780002Ke?l0;@3oool2001VoaL0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo
00<0^W9b0;[Zo`3oool0403oool2001Voc80oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z
0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3oe9/009_D
0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0;03oool2001VoaL0oooo
00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0403oool2001Voc80oooo00<0
j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<0
00000?ooo`3oool0@`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0
omBK002Ke03oool0;03oool2001VoaL0oooo00<0^W9b0;[Zo`3oool03`3oool000P0oooo00<0^W80
0000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo0100oooo0P00I_lY
0?ooo`030;Yb00000000000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`030?oDV`00
Vm@0oooo00l0oooo00<0^W8009_Do`3oool0@@3oool00`000000oooo0?ooo`130?ooo`030>ZjLP1b
^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`0/0?ooo`8006Ko5`3o
ool00`2jLW80^^[o0?ooo`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`0A0?ooo`03001Vo`3oool0
oooo0300oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K0000
00000080000000<0L[[Z0?ooo`3oool0@@3oool00`000000oooo0?ooo`130?ooo`030>ZjLP1b^^X0
oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0
oooo02`0oooo0P00I_lG0?ooo`030;YbLP2jj_l0oooo00l0oooo000D0?ooo`030;YbLP2jj_l0oooo
0140oooo0P00I_la0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3o
om@0V`2K0=Coo`160?ooo`030000003oool0oooo04<0oooo00<0omBK07:jjP3oool00P3oool00`3Z
^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo0340oooo0P00I_lG0?ooo`030;YbLP2jj_l0oooo
00l0oooo000A0?ooo`050>ZjLP00000007:j0;YbLP2jj_l04`3oool00`00I_l0oooo0?ooo`0`0?oo
o`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`160?ooo`030000003o
ool0oooo04@0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo0340
oooo0P00I_lD0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0403oool001<0oooo00<0j[Yb0000LP2j
j_l04P3oool2001Voc80oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K00000000
0080000000<0002K0=Coo`3oool0@@3oool00`000000oooo0?ooo`140?ooo`050?ooe02K00000000
0000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo02`0oooo0P00I_lF
0?ooo`030>ZjLP000780^^[o0100oooo000Y0?ooo`03001Vo`3oool0oooo08X0oooo00<000000?oo
o`3oool0R@3oool2001VobT0oooo000Y0?ooo`8006KoR`3oool00`000000oooo0?ooo`290?ooo`80
06Ko:@3oool002X0oooo00<006Ko0?ooo`3oool0R@3oool00`000000oooo0?ooo`290?ooo`8006Ko
:@3oool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08P0oooo0P00I_lZ0?ooo`00:@3oool2
001Voh/0oooo00<000000?ooo`3oool0R03oool2001VobX0oooo000Y0?ooo`8006KoR`3oool00`00
0000oooo0?ooo`280?ooo`8006Ko:P3oool002T0oooo0`00I_n:0?ooo`030000003oool0oooo08P0
oooo0P00I_lZ0?ooo`00:P000003001Vool0000050000003001VobX0000000000`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool01@3oool3001Vo`D0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`8006Ko203oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00h0oooo0@0000000100oooo00<000000?ooo`3oool05P3oool2
001VocP0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1@0?ooo`030000003oool0
oooo03D0oooo0P00I_lH0?ooo`030000003oool0oooo00l0oooo000Y0?ooo`8006KoR`3oool00`00
0000oooo0?ooo`280?ooo`8006Ko:P3oool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08P0
oooo0`00I_lY0?ooo`00:@3oool2001Voh/0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo
000Y0?ooo`8006KoR`3oool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002T0oooo0P00I_n;
0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`00:03oool3001Voh/0oooo00<000000?oo
o`3oool0R@3oool2001VobT0oooo000X0?ooo`8006KoS03oool00`000000oooo0?ooo`290?ooo`80
06Ko:@3oool002P0oooo0P00I_n<0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`00:03o
ool2001Voh`0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000X0?ooo`8006KoS03oool0
0`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0oooo0`00I_n<0?ooo`030000003oool0oooo
08T0oooo0P00I_lY0?ooo`009`3oool2001Vohd0oooo00<000000?ooo`3oool0R@3oool2001VobT0
oooo000W0?ooo`8006KoS@3oool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0oooo0P00
I_n=0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`009`3oool2001Vohd0oooo0P00002:
0?ooo`8006Ko:@3oool002L0oooo0P00I_n=0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?oo
o`009`3oool2001Vohd0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000W0?ooo`8006Ko
S@3oool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0oooo0P00I_n=0?ooo`030000003o
ool0oooo08T0oooo0P00I_lY0?ooo`009`3oool2001Vohd0oooo00<000000?ooo`3oool0R@3oool2
001VobT0oooo000W0?ooo`8006KoS@3oool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002L0
oooo0P00I_n=0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`00:03oool00`00I_l0oooo
0?ooo`2;0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`00:03oool2001Voh`0oooo00<0
00000?ooo`3oool0R@3oool2001VobT0oooo000Y0?ooo`03001Vo`3oool0oooo08X0oooo00<00000
0?ooo`3oool0R@3oool2001VobT0oooo000X0?ooo`8006KoS03oool00`000000oooo0?ooo`290?oo
o`8006Ko:@3oool002P0oooo0`00I_n;0?ooo`030000003oool0oooo08T0oooo0P00I_lY0?ooo`00
:@3oool2001Voh/0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000Y0?ooo`8006KoR`3o
ool00`000000oooo0?ooo`290?ooo`8006Ko:@3oool002T0oooo0P00I_n;0?ooo`030000003oool0
oooo08P0oooo0`00I_lY0?ooo`00:P3oool2001VohX0oooo0P0000290?ooo`8006Ko:P3oool002X0
oooo0P00I_n:0?ooo`030000003oool0oooo08P0oooo0P00I_lZ0?ooo`00:P3oool2001VohX0oooo
00<000000?ooo`3oool0R03oool2001VobX0oooo000Z0?ooo`8006KoRP3oool00`000000oooo0?oo
o`270?ooo`<006Ko:P3oool002/0oooo00<006Ko0?ooo`3oool0R03oool00`000000oooo0?ooo`27
0?ooo`8006Ko:`3oool002/0oooo0P00I_n90?ooo`030000003oool0oooo08L0oooo0P00I_l[0?oo
o`00;03oool00`00I_l0oooo0?ooo`270?ooo`030000003oool0oooo08H0oooo0`00I_l[0?ooo`00
;03oool2001VohP0oooo00<000000?ooo`3oool0QP3oool2001Vob`0oooo000]0?ooo`03001Vo`3o
ool0oooo08H0oooo00<000000?ooo`3oool0QP3oool2001Vob`0oooo000]0?ooo`8006KoQ`3oool0
0`000000oooo0?ooo`250?ooo`<006Ko;03oool002h0oooo00<006Ko0?ooo`3oool0Q@3oool00`00
0000oooo0?ooo`250?ooo`8006Ko;@3oool002h0oooo0P00I_n60?ooo`030000003oool0oooo08D0
oooo0P00I_l]0?ooo`00;`3oool00`00I_l0oooo0?ooo`240?ooo`030000003oool0oooo08D0oooo
0P00I_l]0?ooo`00;`3oool2001VohD0oooo00<000000?ooo`3oool0Q03oool3001Vobd0oooo000`
0?ooo`03001Vo`3oool0oooo08<0oooo00<000000?ooo`3oool0Q03oool2001Vobh0oooo000`0?oo
o`8006KoQ03oool00`000000oooo0?ooo`240?ooo`8006Ko;P3oool00340oooo0P00I_n30?ooo`03
0000003oool0oooo08<0oooo0`00I_l^0?ooo`00<P3oool2001Voh80oooo0P0000240?ooo`8006Ko
;`3oool00380oooo0`00I_n10?ooo`030000003oool0oooo08<0oooo0P00I_l_0?ooo`00<`3oool3
001Voh00oooo00<000000?ooo`3oool0PP3oool3001Vobl0oooo000d0?ooo`8006KoP03oool00`00
0000oooo0?ooo`220?ooo`8006Ko<03oool003@0oooo0P00I_n00?ooo`030000003oool0oooo0880
oooo0P00I_l`0?ooo`00=03oool2001Voh00oooo00<000000?ooo`3oool0P@3oool3001Voc00oooo
000d0?ooo`8006KoP03oool00`000000oooo0?ooo`210?ooo`8006Ko<@3oool003@0oooo0P00I_n0
0?ooo`030000003oool0oooo0840oooo0P00I_la0?ooo`00=03oool2001Voh00oooo00<000000?oo
o`3oool0P@3oool2001Voc40oooo000d0?ooo`<006KoO`3oool00`000000oooo0?ooo`200?ooo`<0
06Ko<@3oool003D0oooo0P00I_mo0?ooo`030000003oool0oooo0800oooo0P00I_lb0?ooo`00=@3o
ool2001Vogl0oooo00<000000?ooo`3oool0P03oool2001Voc80oooo000e0?ooo`8006KoO`3oool0
0`000000oooo0?ooo`1o0?ooo`<006Ko<P3oool003D0oooo0P00I_mo0?ooo`030000003oool0oooo
07l0oooo0P00I_lc0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O`3oool2001Voc<0
oooo000e0?ooo`8006KoO`3oool00`000000oooo0?ooo`1n0?ooo`<006Ko<`3oool003D0oooo0P00
I_mo0?ooo`800000O`3oool2001Voc@0oooo000e0?ooo`8006KoO`3oool00`000000oooo0?ooo`1n
0?ooo`8006Ko=03oool003D0oooo0P00I_mo0?ooo`030000003oool0oooo07d0oooo0`00I_ld0?oo
o`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O@3oool2001VocD0oooo000e0?ooo`8006Ko
O`3oool00`000000oooo0?ooo`1m0?ooo`8006Ko=@3oool003D0oooo0P00I_mo0?ooo`030000003o
ool0oooo07d0oooo0P00I_le0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O03oool3
001VocD0oooo000e0?ooo`8006KoO`3oool00`000000oooo0?ooo`1l0?ooo`8006Ko=P3oool003D0
oooo0P00I_mo0?ooo`030000003oool0oooo07`0oooo0P00I_lf0?ooo`00=@3oool2001Vogl0oooo
00<000000?ooo`3oool0N`3oool3001VocH0oooo000e0?ooo`8006KoO`3oool00`000000oooo0?oo
o`1k0?ooo`8006Ko=`3oool003H0oooo00<006Ko0?ooo`3oool0O@3oool00`000000oooo0?ooo`1k
0?ooo`8006Ko=`3oool003H0oooo0P00I_mn0?ooo`030000003oool0oooo07/0oooo0P00I_lg0?oo
o`00=`3oool00`00I_l0oooo0?ooo`1N0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3D
V`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`1k
0?ooo`8006Ko=`3oool003H0oooo0P00I_mP0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103o
ool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`060?ooo`03
0000003oool0oooo07/0oooo0P00I_lg0?ooo`00=P3oool2001Voel0oooo00<0omBK002Ke03oool0
0P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0
N`3oool2001VocL0oooo000f0?ooo`8006KoG`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00
Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3o
ool003H0oooo0P00I_mO0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool0
0`2jLP00VmCo0?ooo`050?ooo`<00000N`3oool2001VocL0oooo000f0?ooo`8006KoG`3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b
^^X0oooo0?ooo`050?ooo`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00=`3oool2001Voeh0
oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0
oooo00<000000?ooo`3oool0N`3oool2001VocL0oooo000g0?ooo`8006KoG`3oool01P2jLP00VmCo
0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1j0?oo
o`8006Ko>03oool003L0oooo0P00I_mO0?ooo`050?ooe02K000000000000LP2jj_l0303oool00`3o
om@0V`0000000002000000030000V`3Dool0oooo00D0oooo00<000000?ooo`3oool0NP3oool2001V
ocP0oooo000g0?ooo`8006KoO@3oool00`000000oooo0?ooo`1j0?ooo`8006Ko>03oool003L0oooo
0P00I_mm0?ooo`030000003oool0oooo07X0oooo0P00I_lh0?ooo`00>03oool2001Vog`0oooo00<0
00000?ooo`3oool0NP3oool2001VocP0oooo000h0?ooo`8006KoO03oool00`000000oooo0?ooo`1i
0?ooo`8006Ko>@3oool003P0oooo0P00I_ml0?ooo`030000003oool0oooo07T0oooo0P00I_li0?oo
o`00>03oool2001Vog`0oooo00<000000?ooo`3oool0N@3oool2001VocT0oooo000h0?ooo`<006Ko
N`3oool00`000000oooo0?ooo`1i0?ooo`8006Ko>@3oool003T0oooo0P00I_mk0?ooo`030000003o
ool0oooo07T0oooo0P00I_li0?ooo`00>@3oool2001Vog/0oooo00<000000?ooo`3oool0N@3oool2
001VocT0oooo000i0?ooo`<006KoNP3oool00`000000oooo0?ooo`1h0?ooo`8006Ko>P3oool003X0
oooo0P00I_mj0?ooo`030000003oool0oooo07P0oooo0P00I_lj0?ooo`00>P3oool3001VogT0oooo
0P00001i0?ooo`03001Vo`3oool0oooo03T0oooo000k0?ooo`8006KoN@3oool00`000000oooo0?oo
o`1g0?ooo`8006Ko>`3oool003/0oooo0P00I_mi0?ooo`030000003oool0oooo07L0oooo00<006Ko
0?ooo`3oool0>P3oool003/0oooo0`00I_mh0?ooo`030000003oool0oooo07H0oooo0P00I_ll0?oo
o`00?03oool2001VogP0oooo00<000000?ooo`3oool0MP3oool00`00I_l0oooo0?ooo`0k0?ooo`00
?03oool2001VogP0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l0?ooo`<006KoM`3o
ool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool003d0oooo0P00I_mg0?ooo`030000003oool0
oooo07@0oooo0`00I_lm0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3oool0M03oool2001V
och0oooo000m0?ooo`<006KoMP3oool00`000000oooo0?ooo`1d0?ooo`8006Ko?P3oool003h0oooo
0P00I_mf0?ooo`030000003oool0oooo07@0oooo00<006Ko0?ooo`3oool0?@3oool003l0oooo00<0
06Ko0?ooo`3oool0M03oool00`000000oooo0?ooo`1c0?ooo`8006Ko?`3oool003l0oooo0P00I_me
0?ooo`030000003oool0oooo0780oooo0P00I_m00?ooo`00@03oool2001Vog@0oooo00<000000?oo
o`3oool0LP3oool00`00I_l0oooo0?ooo`0o0?ooo`00@@3oool2001Vog<0oooo00<000000?ooo`3o
ool0L@3oool2001Vod40oooo00120?ooo`8006KoLP3oool00`000000oooo0?ooo`1`0?ooo`8006Ko
@P3oool00480oooo0`00I_ma0?ooo`030000003oool0oooo06l0oooo0`00I_m20?ooo`00@`3oool3
001Vog00oooo0P00001_0?ooo`<006Ko@`3oool004@0oooo0P00I_m`0?ooo`030000003oool0oooo
06d0oooo0`00I_m40?ooo`00A@3oool2001Vofl0oooo00<000000?ooo`3oool0K@3oool2001VodD0
oooo00150?ooo`<006KoKP3oool00`000000oooo0?ooo`1/0?ooo`8006KoAP3oool004H0oooo0`00
I_m]0?ooo`030000003oool0oooo06/0oooo0P00I_m70?ooo`00A`3oool3001Vof`0oooo00<00000
0?ooo`3oool0JP3oool2001VodP0oooo00180?ooo`@006KoJP3oool00`000000oooo0?ooo`1Y0?oo
o`8006KoB@3oool004T0oooo1000I_mY0?ooo`030000003oool0oooo06L0oooo1000I_m90?ooo`00
B`3oool4001VofL0oooo00<000000?ooo`3oool0IP3oool4001VodX0oooo001<0?ooo`@006KoIP3o
ool00`000000oooo0?ooo`1S0?ooo`D006KoC03oool004h0oooo1000I_mT0?ooo`030000003oool0
oooo0640oooo1P00I_m=0?ooo`00C`3oool5001Vof80oooo00<000000?ooo`3oool0H03oool4001V
oe00oooo001A0?ooo`@006KoH@3oool00`000000oooo0?ooo`1N0?ooo`@006KoDP3oool005<0oooo
1000I_lU0?ooo`H006Ko=03oool00`000000oooo0?ooo`0a0?ooo`H006Ko9P3oool4001Voe<0oooo
001D0?ooo`D006Ko803oool:001Voc<0oooo00<000000?ooo`3oool0<@3oool9001Vob00oooo1@00
I_mE0?ooo`00EP3oool9001Voa@0oooo2P00I_l40?ooo`8006Ko<`3oool00`000000oooo0?ooo`0`
0?ooo`8006Ko103oool:001Voa@0oooo2P00I_mF0?ooo`00F03oool;001Vo``0oooo2`00I_l80?oo
o`03001Vo`3oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`00I_l0oooo0?ooo`060?oo
o``006Ko303oool:001VoeT0oooo001N0?oooaH006Ko3P3oool2001Voc80oooo0P00000`0?ooo`80
06Ko3@3ooolG001Voel0oooo001R0?ooo`h006Ko4`3oool2001Voc40oooo00<000000?ooo`3oool0
;`3oool00`00I_l0oooo0?ooo`0B0?ooo`h006KoHP3oool008@0oooo00<006Ko0?ooo`3oool0;`3o
ool00`000000oooo0?ooo`0^0?ooo`8006KoQ03oool008@0oooo0P00I_l`0?ooo`030000003oool0
oooo02h0oooo00<006Ko0?ooo`3oool0P`3oool008@0oooo0P00I_l`0?ooo`030000003oool0oooo
02d0oooo0P00I_n50?ooo`00Q@3oool00`00I_l0oooo0?ooo`0^0?ooo`030000003oool0oooo02`0
oooo0P00I_n60?ooo`00Q@3oool2001Vobl0oooo00<000000?ooo`3oool0;03oool00`00I_l0oooo
0?ooo`250?ooo`00QP3oool2001Vobh0oooo00<000000?ooo`3oool0:`3oool2001VohL0oooo0027
0?ooo`03001Vo`3oool0oooo02`0oooo00<000000?ooo`3oool0:`3oool00`00I_l0oooo0?ooo`26
0?ooo`00Q`3oool2001Vobd0oooo00<000000?ooo`3oool0:P3oool2001VohP0oooo00280?ooo`80
06Ko;03oool00`000000oooo0?ooo`0Z0?ooo`03001Vo`3oool0oooo08L0oooo00290?ooo`8006Ko
:`3oool00`000000oooo0?ooo`0Y0?ooo`8006KoR@3oool008X0oooo00<006Ko0?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0X0?ooo`8006KoRP3oool008X0oooo0P00I_lZ0?ooo`030000003oool0
oooo02P0oooo00<006Ko0?ooo`3oool0R@3oool008/0oooo0P00I_lY0?ooo`030000003oool0oooo
02L0oooo0P00I_n;0?ooo`00S03oool2001VobP0oooo00<000000?ooo`3oool09P3oool2001Voh`0
oooo002<0?ooo`<006Ko9`3oool2000002H0oooo0P00I_n=0?ooo`00S@3oool2001VobL0oooo00<0
00000?ooo`3oool0903oool3001Vohd0oooo002>0?ooo`8006Ko9P3oool00`000000oooo0?ooo`0S
0?ooo`<006KoSP3oool008h0oooo0`00I_lU0?ooo`030000003oool0oooo0280oooo0`00I_n?0?oo
o`00S`3oool3001Vob@0oooo00<000000?ooo`3oool08@3oool3001Voi00oooo002@0?ooo`<006Ko
8`3oool00`000000oooo0?ooo`0P0?ooo`<006KoT@3oool00940oooo0P00I_lS0?ooo`030000003o
ool0oooo01l0oooo0`00I_nB0?ooo`00TP3oool2001Vob80oooo00<000000?ooo`3oool07`3oool2
001Voi<0oooo002B0?ooo`<006Ko8@3oool00`000000oooo0?ooo`0N0?ooo`8006KoU03oool009<0
oooo0`00I_lP0?ooo`030000003oool0oooo01d0oooo0`00I_nD0?ooo`00U03oool4001Voah0oooo
00<000000?ooo`3oool0703oool3001VoiD0oooo002E0?ooo`@006Ko7@3oool00`000000oooo0?oo
o`0J0?ooo`@006KoUP3oool009L0oooo1000I_lK0?ooo`030000003oool0oooo01T0oooo1000I_nG
0?ooo`00V03oool4001Vo`d0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?oo
o`030000003oool0oooo01P0oooo0`00I_nI0?ooo`00VP3oool4001Vo`h0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`0F0?ooo`@006KoVP3oool009/0oooo1@00I_l<0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool05@3oool4001Voi/0oooo002M0?ooo`@006Ko2`3o
ool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo01<0oooo1000I_nM0?ooo`00W`3oool4
001Vo`T0oooo00<0^W9b0;[Zo`3oool01`3oool300000140oooo1@00I_nN0?ooo`00X03oool5001V
o`L0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`@006KoX03oool00:80
oooo1@00I_l50?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool03P3oool4001Voj80
oooo002T0?ooo`D006Ko00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo00T0
oooo2000I_nS0?ooo`00YP3oool5001Vo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0
1P3oool8001VojH0oooo002X0?ooo`H006Ko203oool00`000000oooo0?ooo`050?ooo`D006KoZP3o
ool00:X0oooo5P00I_n]0?ooo`00[@3ooolB001Vojh0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo0P00002e0?ooo`00
]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.91818 .59091 m
.91881 .59711 L
.91937 .60377 L
.91978 .61007 L
.91993 .61286 L
.92006 .61581 L
.92018 .61933 L
.92025 .62257 L
.92029 .62607 L
.9203 .62806 L
.92029 .62992 L
.92025 .63328 L
.92017 .63636 L
.92004 .63991 L
.91988 .64328 L
.91942 .64992 L
.91874 .65699 L
.91791 .66364 L
.917 .66965 L
.9141 .68428 L
.91048 .69786 L
.89992 .72579 L
.89256 .74036 L
.88859 .74726 L
.88679 .75024 L
.88609 .75205 L
.88568 .75382 L
.88414 .76034 L
.88264 .76654 L
.87918 .78027 L
.87078 .80959 L
.86134 .83625 L
.85044 .86075 L
.83654 .88516 L
.81789 .90995 L
.79707 .93049 L
.77202 .9484 L
.74847 .9603 L
.73443 .96559 L
.72103 .96957 L
.70623 .9729 L
.69779 .97433 L
.68998 .97539 L
.68312 .97611 L
.67558 .97669 L
.67178 .97691 L
.66969 .977 L
.6677 .97708 L
.66385 .97719 L
.66035 .97726 L
Mistroke
.65775 .97947 L
.65547 .98167 L
.65026 .98656 L
.64062 .9952 L
.61734 1.01363 L
.59109 1.03018 L
.56522 1.04218 L
.55112 1.04698 L
.53533 1.05094 L
.52727 1.0524 L
.52281 1.05305 L
.51858 1.05355 L
.51463 1.05393 L
.51255 1.05409 L
.51034 1.05424 L
.50643 1.05443 L
.50282 1.05452 L
.49933 1.05454 L
.49551 1.05449 L
.49153 1.05434 L
.48783 1.05412 L
.48435 1.05384 L
.48121 1.05353 L
.47417 1.05262 L
.46661 1.05133 L
.4585 1.04957 L
.44398 1.04545 L
.43059 1.04052 L
.41682 1.03429 L
.39327 1.02086 L
.29441 .97302 L
.27919 .96963 L
.26297 .9647 L
.24812 .95882 L
.23487 .95231 L
.21145 .93729 L
.1893 .91775 L
.17101 .8961 L
.15651 .87374 L
.14343 .84768 L
.13217 .81857 L
.12406 .79223 L
.1168 .76423 L
.11585 .76029 L
.11484 .75603 L
.11438 .75407 L
.1139 .75201 L
.11327 .75034 L
.11223 .74864 L
.10495 .73573 L
Mistroke
.09841 .72206 L
.09328 .7092 L
.08916 .69666 L
.08554 .68273 L
.08394 .675 L
.0827 .66779 L
.08166 .66042 L
.08089 .65345 L
.08035 .64693 L
.08012 .64326 L
.07996 .63988 L
.07985 .63702 L
.07976 .63388 L
.07971 .63061 L
.0797 .62756 L
.07973 .62398 L
.07979 .62059 L
.07988 .61755 L
.08001 .61425 L
.08041 .60687 L
.08093 .60006 L
.08123 .59676 L
.08157 .59324 L
.08171 .58993 L
.0814 .58692 L
.08081 .5803 L
.08029 .57304 L
.08009 .56927 L
.07991 .56518 L
.07985 .56331 L
.07979 .56132 L
.07972 .55775 L
.0797 .5543 L
.07972 .55106 L
.07977 .54752 L
.07983 .54552 L
.07989 .54371 L
.08003 .54042 L
.08022 .53693 L
.08068 .53066 L
.08144 .52322 L
.08232 .51651 L
.08463 .50335 L
.0875 .49112 L
.09582 .46596 L
.1061 .44391 L
.12346 .39173 L
.13183 .36426 L
.14298 .33515 L
.15622 .30859 L
Mistroke
.17092 .28585 L
.18888 .2645 L
.21156 .24444 L
.22297 .23652 L
.2357 .22906 L
.25992 .21821 L
.27371 .21369 L
.28911 .20985 L
.29623 .20847 L
.30387 .20724 L
.31106 .20631 L
.31769 .20564 L
.32469 .20511 L
.32837 .2049 L
.33225 .20474 L
.33563 .20464 L
.33878 .20457 L
.34159 .20298 L
.34427 .2004 L
.36359 .18303 L
.38792 .16451 L
.41293 .1495 L
.42753 .14258 L
.44394 .13639 L
.45131 .13413 L
.45924 .13207 L
.46609 .13059 L
.47364 .12927 L
.48087 .12833 L
.48482 .12794 L
.4885 .12765 L
.49197 .12746 L
.49512 .12734 L
.49876 .12728 L
.5022 .12729 L
.50594 .12737 L
.5099 .12755 L
.51328 .12778 L
.517 .1281 L
.52524 .12911 L
.53292 .1304 L
.54668 .13358 L
.55905 .13739 L
.5859 .14889 L
.68783 .20619 L
.7026 .20827 L
.71085 .20985 L
.71838 .21157 L
.73178 .21536 L
.74612 .22055 L
Mistroke
.76984 .23214 L
.79278 .2478 L
.81491 .26853 L
.83253 .29068 L
.8481 .3165 L
.86143 .34577 L
.87897 .40075 L
.90035 .45698 L
.91028 .4833 L
.91398 .49702 L
.91571 .50502 L
.91704 .51239 L
.91799 .51869 L
.91883 .5256 L
.91947 .53256 L
.91975 .53637 L
.91995 .5399 L
.9201 .54328 L
.9202 .54647 L
.92026 .54934 L
.92029 .55244 L
.92029 .55582 L
.92025 .5594 L
.92018 .56245 L
.92007 .5658 L
.91992 .56906 L
.91976 .57216 L
.91938 .57794 L
.91818 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00:T0oooo00<0omBK0000000000005000I_n]0?ooo`00Y`3ooolP001VojH0
oooo002T0?ooo`T006Ko00<0^^[o0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`/006Ko
X`3oool009l0oooo2@00I_l40?ooo`030;YbLP2jj_l0oooo00L0oooo0`00000>0?ooo`D006KoX@3o
ool009d0oooo2000I_l00`00000007:j0?ooo`040?ooo`030;YbLP2jj_l0oooo00L0oooo00<00000
0?ooo`3oool0403oool5001Voil0oooo002K0?ooo`D006Ko303oool00`2jLW80^^[o0?ooo`070?oo
o`030000003oool0oooo0180oooo1P00I_nL0?ooo`00V03oool6001Vo`h0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`0D0?ooo`H006KoVP3oool009H0oooo1P00I_l=0?ooo`050>Zj
LP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`0G0?ooo`H006KoU`3oool009@0oooo
1@00I_lB0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool06@3oool6001VoiD0oooo
002C0?ooo`@006Ko7`3oool00`000000oooo0?ooo`0L0?ooo`D006KoT`3oool00940oooo1000I_lQ
0?ooo`030000003oool0oooo01h0oooo1000I_nB0?ooo`00T03oool4001Vob80oooo00<000000?oo
o`3oool0803oool4001Voi00oooo002>0?ooo`@006Ko903oool00`000000oooo0?ooo`0Q0?ooo`D0
06KoSP3oool008d0oooo1000I_lU0?ooo`030000003oool0oooo02<0oooo1@00I_n<0?ooo`00R`3o
ool4001VobL0oooo00<000000?ooo`3oool09@3oool4001Voh/0oooo002:0?ooo`@006Ko:03oool0
0`000000oooo0?ooo`0W0?ooo`@006KoR@3oool008P0oooo1000I_lZ0?ooo`030000003oool0oooo
02P0oooo1@00I_n70?ooo`00Q`3oool4001Vob/0oooo00<000000?ooo`3oool0:P3oool5001VohD0
oooo00250?ooo`@006Ko;@3oool00`000000oooo0?ooo`0/0?ooo`@006KoQ03oool008@0oooo1000
I_l^0?ooo`030000003oool0oooo02h0oooo1000I_n20?ooo`00P`3oool3001Voc00oooo0P00000`
0?ooo`D006KoP03oool00880oooo0`00I_la0?ooo`030000003oool0oooo0340oooo1@00I_mn0?oo
o`00P@3oool3001Voc80oooo00<000000?ooo`3oool0<`3oool4001Vogd0oooo00200?ooo`<006Ko
<`3oool00`000000oooo0?ooo`0e0?ooo`@006KoN`3oool007l0oooo0`00I_ld0?ooo`030000003o
ool0oooo03H0oooo1@00I_mi0?ooo`00OP3oool3001VocD0oooo00<000000?ooo`3oool0>03oool5
001VogL0oooo001m0?ooo`<006Ko=P3oool00`000000oooo0?ooo`0j0?ooo`@006KoMP3oool007`0
oooo0`00I_lg0?ooo`030000003oool0oooo03`0oooo1000I_md0?ooo`00L`3oool;001VocP0oooo
00<000000?ooo`3oool0?@3oool5001Vog80oooo001[0?oooa8006Ko>@3oool00`000000oooo0?oo
o`0o0?ooo`P006KoK@3oool006H0oooo3P00I_m20?ooo`030000003oool0oooo0440oooo3000I_mW
0?ooo`00H`3oool9001VodX0oooo00<000000?ooo`3oool0A`3oool:001Vof<0oooo001N0?ooo`T0
06KoC`3oool00`000000oooo0?ooo`1<0?ooo`P006KoH03oool005`0oooo1`00I_mC0?ooo`030000
003oool0oooo0540oooo1P00I_mM0?ooo`00F@3oool6001VoeL0oooo00<000000?ooo`3oool0D`3o
ool6001Voe/0oooo001G0?ooo`H006KoF@3oool00`000000oooo0?ooo`1F0?ooo`D006KoF@3oool0
05D0oooo1@00I_mL0?ooo`030000003oool0oooo05P0oooo1P00I_mF0?ooo`00E03oool4001Voeh0
oooo0P00001K0?ooo`H006KoE03oool00580oooo1000I_mP0?ooo`030000003oool0oooo05d0oooo
1000I_mC0?ooo`00D@3oool4001Vof40oooo00<000000?ooo`3oool0G`3oool4001Voe40oooo001@
0?ooo`<006KoH`3oool00`000000oooo0?ooo`1P0?ooo`@006KoD03oool004h0oooo1000I_mT0?oo
o`030000003oool0oooo0680oooo0`00I_m?0?ooo`00C@3oool4001VofD0oooo00<000000?ooo`3o
ool0H`3oool4001Vodd0oooo001<0?ooo`<006KoI`3oool00`000000oooo0?ooo`1T0?ooo`@006Ko
C03oool004X0oooo1000I_mX0?ooo`030000003oool0oooo06H0oooo0`00I_m;0?ooo`00B@3oool4
001VofT0oooo00<000000?ooo`3oool0I`3oool3001VodX0oooo00180?ooo`<006KoJ`3oool00`00
0000oooo0?ooo`1X0?ooo`<006KoB@3oool004L0oooo0`00I_m/0?ooo`030000003oool0oooo06T0
oooo0`00I_m80?ooo`00A@3oool4001Vofd0oooo00<000000?ooo`3oool0JP3oool4001VodH0oooo
00140?ooo`@006KoKP3oool00`000000oooo0?ooo`1[0?ooo`@006KoA@3oool004@0oooo0P00I_m`
0?ooo`030000003oool0oooo06d0oooo0`00I_m40?ooo`00@`3oool2001Vog40oooo00<000000?oo
o`3oool0KP3oool3001Vod<0oooo00120?ooo`8006KoLP3oool00`000000oooo0?ooo`1_0?ooo`80
06Ko@`3oool00440oooo0P00I_mc0?ooo`800000L@3oool2001Vod80oooo00110?ooo`03001Vo`3o
ool0oooo0780oooo00<000000?ooo`3oool0L@3oool2001Vod40oooo00100?ooo`8006KoM03oool0
0`000000oooo0?ooo`1b0?ooo`8006Ko@03oool003l0oooo0P00I_me0?ooo`030000003oool0oooo
07<0oooo00<006Ko0?ooo`3oool0?P3oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo07<0
oooo0P00I_lo0?ooo`00?P3oool00`00I_l0oooo0?ooo`1e0?ooo`030000003oool0oooo07@0oooo
0P00I_ln0?ooo`00?@3oool2001VogL0oooo00<000000?ooo`3oool0M@3oool2001Vocd0oooo000l
0?ooo`8006KoN03oool00`000000oooo0?ooo`1f0?ooo`03001Vo`3oool0oooo03/0oooo000k0?oo
o`8006KoN@3oool00`000000oooo0?ooo`1f0?ooo`8006Ko?03oool003/0oooo00<006Ko0?ooo`3o
ool0N03oool00`000000oooo0?ooo`1g0?ooo`8006Ko>`3oool003X0oooo0P00I_mj0?ooo`030000
003oool0oooo07P0oooo00<006Ko0?ooo`3oool0>@3oool003T0oooo0P00I_mk0?ooo`030000003o
ool0oooo07P0oooo0P00I_lj0?ooo`00>03oool2001Vog`0oooo00<000000?ooo`3oool0N@3oool2
001VocT0oooo000g0?ooo`<006KoO03oool00`000000oooo0?ooo`1j0?ooo`03001Vo`3oool0oooo
03L0oooo000g0?ooo`8006KoO@3oool00`000000oooo0?ooo`1j0?ooo`8006Ko>03oool003H0oooo
0`00I_mm0?ooo`030000003oool0oooo07/0oooo0P00I_lg0?ooo`00=P3oool2001Vogh0oooo00<0
00000?ooo`3oool0O03oool00`00I_l0oooo0?ooo`0e0?ooo`00=P3oool2001Vogh0oooo0P00001m
0?ooo`8006Ko=P3oool003D0oooo0`00I_mn0?ooo`030000003oool0oooo07`0oooo0P00I_lf0?oo
o`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O03oool3001VocD0oooo000d0?ooo`<006Ko
O`3oool00`000000oooo0?ooo`1m0?ooo`8006Ko=@3oool003@0oooo0P00I_n00?ooo`030000003o
ool0oooo07d0oooo0P00I_le0?ooo`00=03oool2001Voh00oooo00<000000?ooo`3oool0O@3oool3
001Voc@0oooo000c0?ooo`<006KoP03oool00`000000oooo0?ooo`1n0?ooo`8006Ko=03oool003<0
oooo0P00I_n10?ooo`030000003oool0oooo07h0oooo0`00I_lc0?ooo`00<P3oool3001Voh40oooo
00<000000?ooo`3oool0O`3oool2001Voc<0oooo000b0?ooo`8006KoPP3oool00`000000oooo0?oo
o`1o0?ooo`8006Ko<`3oool00380oooo0P00I_n20?ooo`030000003oool0oooo07l0oooo0`00I_lb
0?ooo`00<@3oool3001Voh80oooo00<000000?ooo`3oool0P03oool2001Voc80oooo000a0?ooo`80
06KoP`3oool00`000000oooo0?ooo`200?ooo`8006Ko<P3oool00300oooo0`00I_mU0?ooo`050?oD
V`00000000000000002Ke?l01@3oool00`3DV`000000002Ke0050?ooo`050=BK0000000000000000
002Ke?l01`3oool00`000000oooo0?ooo`200?ooo`<006Ko<@3oool00300oooo0P00I_mV0?ooo`06
0;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0
oooo0?ooo`3oj[X0LP0009_Do`060?ooo`030000003oool0oooo0840oooo0P00I_la0?ooo`00<03o
ool2001VofD0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00
Vm@0oooo00D0oooo00<000000?ooo`3oool0P@3oool2001Voc40oooo000_0?ooo`<006KoI@3oool0
0`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool3
00000840oooo0`00I_l`0?ooo`00;`3oool2001Voed0oooo00<0^W800000000000000`0000001@00
L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`05
0?ooo`030000003oool0oooo0880oooo0P00I_l`0?ooo`00;`3oool2001VofH0oooo00<0j[Yb07:j
jP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?oo
o`3oool01@3oool00`000000oooo0?ooo`220?ooo`8006Ko<03oool002h0oooo0`00I_mV0?ooo`03
0?oDV`1b^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`0:0?ooo`03
0000003oool0oooo0880oooo0`00I_l_0?ooo`00;P3oool2001VofP0oooo00H0^W8009_Do`3oool0
onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0P`3oool2001V
obl0oooo000^0?ooo`8006KoJ03oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0
000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo08<0oooo0`00I_l^0?oo
o`00;P3oool2001VohH0oooo00<000000?ooo`3oool0Q03oool2001Vobh0oooo000]0?ooo`<006Ko
QP3oool00`000000oooo0?ooo`240?ooo`8006Ko;P3oool002d0oooo0P00I_n70?ooo`030000003o
ool0oooo08@0oooo0`00I_l]0?ooo`00;@3oool2001VohL0oooo00<000000?ooo`3oool0Q@3oool2
001Vobd0oooo000/0?ooo`<006KoQ`3oool00`000000oooo0?ooo`250?ooo`8006Ko;@3oool002`0
oooo0P00I_n80?ooo`030000003oool0oooo08D0oooo0`00I_l/0?ooo`00;03oool2001VohP0oooo
00<000000?ooo`3oool0QP3oool2001Vob`0oooo000[0?ooo`<006KoR03oool00`000000oooo0?oo
o`260?ooo`8006Ko;03oool002/0oooo0P00I_n90?ooo`030000003oool0oooo08H0oooo0`00I_l[
0?ooo`00:P3oool3001VohT0oooo00<000000?ooo`3oool0Q`3oool2001Vob/0oooo000Z0?ooo`80
06KoRP3oool00`000000oooo0?ooo`270?ooo`8006Ko:`3oool002X0oooo0P00I_n:0?ooo`800000
R03oool3001VobX0oooo000Y0?ooo`<006KoRP3oool00`000000oooo0?ooo`280?ooo`8006Ko:P3o
ool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08P0oooo0`00I_lY0?ooo`00:@3oool2001V
oh/0oooo00<000000?ooo`3oool0R@3oool2001VobT0oooo000X0?ooo`<006KoR`3oool00`000000
oooo0?ooo`290?ooo`8006Ko:@3oool002P0oooo0P00I_n<0?ooo`030000003oool0oooo08T0oooo
0`00I_lX0?ooo`00:03oool2001Voh`0oooo00<000000?ooo`3oool0RP3oool2001VobP0oooo000W
0?ooo`8006KoS@3oool00`000000oooo0?ooo`2:0?ooo`<006Ko9`3oool002L0oooo0P00I_n=0?oo
o`030000003oool0oooo08/0oooo0P00I_lW0?ooo`009P3oool3001Vohd0oooo00<000000?ooo`3o
ool0R`3oool2001VobL0oooo000V0?ooo`8006KoSP3oool00`000000oooo0?ooo`2;0?ooo`<006Ko
9P3oool002H0oooo0P00I_n>0?ooo`030000003oool0oooo08`0oooo0P00I_lV0?ooo`009P3oool0
0`00I_l0oooo0?ooo`2=0?ooo`030000003oool0oooo08`0oooo0`00I_lU0?ooo`009@3oool2001V
ohl0oooo00<000000?ooo`3oool0S@3oool2001VobD0oooo000U0?ooo`03001Vo`3oool0oooo08h0
oooo00<000000?ooo`3oool0S@3oool2001VobD0oooo000T0?ooo`8006KoT03oool00`000000oooo
0?ooo`2=0?ooo`<006Ko903oool002@0oooo00<006Ko0?ooo`3oool0S`3oool2000008l0oooo0P00
I_lT0?ooo`00903oool00`00I_l0oooo0?ooo`2?0?ooo`030000003oool0oooo08h0oooo0`00I_lS
0?ooo`008`3oool2001Voi40oooo00<000000?ooo`3oool0S`3oool2001Vob<0oooo000S0?ooo`03
001Vo`3oool0oooo0900oooo00<000000?ooo`3oool0S`3oool2001Vob<0oooo000R0?ooo`8006Ko
TP3oool00`000000oooo0?ooo`2?0?ooo`<006Ko8P3oool00280oooo00<006Ko0?ooo`3oool0T@3o
ool00`000000oooo0?ooo`2@0?ooo`8006Ko8P3oool00240oooo0P00I_nC0?ooo`030000003oool0
oooo0900oooo0P00I_lR0?ooo`008@3oool2001Voi<0oooo00<000000?ooo`3oool0T03oool2001V
ob80oooo000P0?ooo`<006KoT`3oool00`000000oooo0?ooo`2@0?ooo`<006Ko8@3oool00200oooo
0P00I_nD0?ooo`030000003oool0oooo0940oooo0P00I_lQ0?ooo`00803oool2001Voi@0oooo00<0
00000?ooo`3oool0T@3oool2001Vob40oooo000O0?ooo`<006KoU03oool00`000000oooo0?ooo`2A
0?ooo`<006Ko803oool001l0oooo0P00I_nE0?ooo`030000003oool0oooo0980oooo0P00I_lP0?oo
o`007`3oool2001VoiD0oooo00<000000?ooo`3oool0TP3oool2001Vob00oooo000N0?ooo`<006Ko
U@3oool00`000000oooo0?ooo`2B0?ooo`<006Ko7`3oool001h0oooo0P00I_nF0?ooo`030000003o
ool0oooo09<0oooo0P00I_lO0?ooo`007P3oool2001VoiH0oooo00<000000?ooo`3oool0T`3oool2
001Voal0oooo000N0?ooo`8006KoUP3oool2000009@0oooo0P00I_lO0?ooo`007@3oool3001VoiH0
oooo00<000000?ooo`3oool0T`3oool2001Voal0oooo000M0?ooo`8006KoU`3oool00`000000oooo
0?ooo`2D0?ooo`03001Vo`3oool0oooo01d0oooo000M0?ooo`8006KoU`3oool00`000000oooo0?oo
o`2D0?ooo`8006Ko7P3oool001d0oooo0P00I_nG0?ooo`030000003oool0oooo09D0oooo00<006Ko
0?ooo`3oool0703oool001d0oooo0P00I_nG0?ooo`030000003oool0oooo09@0oooo0P00I_lN0?oo
o`007@3oool2001VoiL0oooo00<000000?ooo`3oool0U03oool2001Voah0oooo000M0?ooo`8006Ko
U`3oool00`000000oooo0?ooo`2D0?ooo`8006Ko7P3oool001d0oooo00<006Ko0?ooo`3oool0UP3o
ool00`000000oooo0?ooo`2D0?ooo`8006Ko7P3oool001`0oooo0P00I_nH0?ooo`030000003oool0
oooo09@0oooo0`00I_lM0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001V
oad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo
0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?ooo`00703oool2001VoiP0oooo00<0
00000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E
0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?oo
o`00703oool2001VoiP0oooo0P00002F0?ooo`8006Ko7@3oool00140oooo00<0omBK000000000000
0`0000000`00Vm@0oooo0?ooo`020?ooo`8006Ko?P3oool01@3oe9/00000000000000000VmCo00D0
oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo04<0oooo00<000000?oo
o`3oool0A03oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool0
1@3DV`000000000000000000VmCo03X0oooo0P00I_l80?ooo`030?oDV`000000000000<0000000<0
09_D0?ooo`3oool0303oool001@0oooo00<0^W9b0;[Zo`3oool01@3oool2001Voch0oooo00H0^W:K
0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0
oooo0?oZ^P1b0000VmCo0480oooo00<000000?ooo`3oool0A03oool01P2jLY/0e?oo0?ooo`3oom@0
V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002K
e?l0>@3oool2001Vo`/0oooo00<0^W9b0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool0
1@3oool2001Vocd0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oD
V`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3oool00`3oe9/009_D0?ooo`020?ooo`030>Zj
LP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0>03oool2001Vo`/0oooo00<0^W9b0;[Zo`3oool0
3`3oool001@0oooo00<0^W9b0;[Zo`3oool01@3oool2001Vocd0oooo00<0j[Yb07:jjP3oool00P3o
ool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0440oooo00<000000?ooo`3oool0@`3o
ool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool0>03o
ool2001Vo`/0oooo00<0^W9b0;[Zo`3oool03`3oool000P0oooo00<0^W800000000000000`000000
0`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo00D0oooo0P00I_ld0?ooo`030;Yb00000000
000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0oooo00l0oooo00<0
^W8009_Do`3oool0@@3oool00`000000oooo0?ooo`130?ooo`030>ZjLP1b^^X0oooo0080oooo00<0
omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`0h0?ooo`8006Ko2`3oool00`2jLW80^^[o0?oo
o`0?0?ooo`00503oool00`2jLW80^^[o0?ooo`050?ooo`8006Ko?@3oool00`3Z^W80L[[Z0?ooo`02
0?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`11
0?ooo`030000003oool0oooo04<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:
0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool0>03oool2001Vo`/0oooo00<0^W9b
0;[Zo`3oool03`3oool001@0oooo00<0^W9b0;[Zo`3oool01@3oool2001Vocd0oooo00<0omBK07:j
jP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo04H0oooo00<000000?oo
o`3oool0@`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0
V`3Dool0?@3oool2001Vo`/0oooo00<0^W9b0;[Zo`3oool03`3oool00140oooo00D0j[Yb00000000
L[X0^W9b0;[Zo`060?ooo`8006Ko?P3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0
oooD09/0V`3Dool0AP3oool00`000000oooo0?ooo`140?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0
e?oo2`3oool00`3oom@0V`2K0=Coo`0m0?ooo`8006Ko203oool01@3Z^W800000001b^P2jLW80^^[o
0100oooo000C0?ooo`030>ZjLP000780^^[o00H0oooo0P00I_ln0?ooo`050?ooe02K000000000000
LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo0440oooo00<000000?oo
o`3oool0A03oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P000000
0`0009/0e?oo0?ooo`0h0?ooo`8006Ko2P3oool00`3Z^W80001b0;[Zo`0@0?ooo`00703oool2001V
oiP0oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000
oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo
0P00I_lM0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L
0?ooo`8006KoV03oool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?oo
o`030000003oool0oooo09D0oooo0P00I_lM0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3o
ool0U@3oool2001Voad0oooo000L0000008006Koo`00000`000000<006Ko7@00000000030000003o
ool0oooo00d0oooo00<000000?ooo`3oool02@3oool2001Vo`<0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`00I_l006Ko
303oool00`000000oooo0?ooo`0>0?ooo`400000000@0?ooo`030000003oool0oooo00T0oooo0P00
I_m50?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0D03oool00`000000oooo0?oo
o`110?ooo`<006Ko2`3oool00`000000oooo0?ooo`0?0?ooo`00703oool2001VoiP0oooo00<00000
0?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E0?oo
o`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?ooo`00
703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03o
ool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0
oooo09D0oooo0P00I_lM0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001V
oad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo
0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?ooo`00703oool2001VoiP0oooo00<0
00000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E
0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?oo
o`00703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006Ko
V03oool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`800000UP3o
ool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2E0?ooo`8006Ko7@3oool0
01`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?ooo`00703oool2001VoiP0
oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L0?ooo`8006KoV03oool00`000000oooo
0?ooo`2E0?ooo`8006Ko7@3oool001`0oooo0P00I_nH0?ooo`030000003oool0oooo09D0oooo0P00
I_lM0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3oool0U@3oool2001Voad0oooo000L0?oo
o`8006KoV03oool00`000000oooo0?ooo`2E0?ooo`03001Vo`3oool0oooo01`0oooo000L0?ooo`<0
06KoU`3oool00`000000oooo0?ooo`2D0?ooo`8006Ko7P3oool001d0oooo0P00I_nG0?ooo`030000
003oool0oooo09@0oooo0P00I_lN0?ooo`007@3oool2001VoiL0oooo00<000000?ooo`3oool0U03o
ool2001Voah0oooo000M0?ooo`8006KoU`3oool00`000000oooo0?ooo`2D0?ooo`8006Ko7P3oool0
01d0oooo0P00I_nG0?ooo`030000003oool0oooo09@0oooo0P00I_lN0?ooo`007@3oool2001VoiL0
oooo00<000000?ooo`3oool0U03oool2001Voah0oooo000M0?ooo`<006KoUP3oool00`000000oooo
0?ooo`2D0?ooo`8006Ko7P3oool001h0oooo0P00I_nF0?ooo`030000003oool0oooo09@0oooo0P00
I_lN0?ooo`007P3oool2001VoiH0oooo0P00002E0?ooo`8006Ko7P3oool001h0oooo0P00I_nF0?oo
o`030000003oool0oooo09<0oooo0P00I_lO0?ooo`007`3oool2001VoiD0oooo00<000000?ooo`3o
ool0T`3oool2001Voal0oooo000O0?ooo`8006KoU@3oool00`000000oooo0?ooo`2B0?ooo`<006Ko
7`3oool001l0oooo0P00I_nE0?ooo`030000003oool0oooo0980oooo0P00I_lP0?ooo`007`3oool2
001VoiD0oooo00<000000?ooo`3oool0TP3oool2001Vob00oooo000P0?ooo`03001Vo`3oool0oooo
09<0oooo00<000000?ooo`3oool0T@3oool3001Vob00oooo000P0?ooo`8006KoU03oool00`000000
oooo0?ooo`2A0?ooo`8006Ko8@3oool00240oooo00<006Ko0?ooo`3oool0TP3oool00`000000oooo
0?ooo`2A0?ooo`8006Ko8@3oool00240oooo0P00I_nC0?ooo`030000003oool0oooo0900oooo0`00
I_lQ0?ooo`008P3oool00`00I_l0oooo0?ooo`2A0?ooo`030000003oool0oooo0900oooo0P00I_lR
0?ooo`008P3oool2001Voi80oooo00<000000?ooo`3oool0T03oool2001Vob80oooo000R0?ooo`80
06KoTP3oool00`000000oooo0?ooo`2@0?ooo`8006Ko8P3oool00280oooo0P00I_nB0?ooo`030000
003oool0oooo08l0oooo0`00I_lR0?ooo`008P3oool2001Voi80oooo00<000000?ooo`3oool0S`3o
ool2001Vob<0oooo000S0?ooo`03001Vo`3oool0oooo0900oooo00<000000?ooo`3oool0S`3oool2
001Vob<0oooo000S0?ooo`8006KoT@3oool00`000000oooo0?ooo`2?0?ooo`03001Vo`3oool0oooo
0280oooo000T0?ooo`03001Vo`3oool0oooo08l0oooo0P00002?0?ooo`8006Ko903oool002@0oooo
0P00I_n@0?ooo`030000003oool0oooo08h0oooo00<006Ko0?ooo`3oool08`3oool002D0oooo0P00
I_n?0?ooo`030000003oool0oooo08d0oooo0P00I_lU0?ooo`009@3oool3001Vohh0oooo00<00000
0?ooo`3oool0S@3oool00`00I_l0oooo0?ooo`0T0?ooo`009P3oool2001Vohh0oooo00<000000?oo
o`3oool0S03oool2001VobH0oooo000V0?ooo`8006KoSP3oool00`000000oooo0?ooo`2;0?ooo`80
06Ko9`3oool002H0oooo0`00I_n=0?ooo`030000003oool0oooo08X0oooo0`00I_lW0?ooo`009`3o
ool2001Vohd0oooo00<000000?ooo`3oool0R@3oool3001VobP0oooo000W0?ooo`<006KoS03oool0
0`000000oooo0?ooo`290?ooo`8006Ko:@3oool002P0oooo0P00I_n<0?ooo`030000003oool0oooo
08P0oooo0`00I_lY0?ooo`00:@3oool00`00I_l0oooo0?ooo`2:0?ooo`030000003oool0oooo08P0
oooo0P00I_lZ0?ooo`00:@3oool2001Voh/0oooo00<000000?ooo`3oool0R03oool2001VobX0oooo
000Z0?ooo`03001Vo`3oool0oooo08T0oooo00<000000?ooo`3oool0R03oool2001VobX0oooo000Y
0?ooo`<006KoRP3oool00`000000oooo0?ooo`280?ooo`8006Ko:P3oool002X0oooo0P00I_n:0?oo
o`030000003oool0oooo08P0oooo00<006Ko0?ooo`3oool0:@3oool002X0oooo0P00I_n:0?ooo`03
0000003oool0oooo08L0oooo0P00I_l[0?ooo`00:P3oool3001VohT0oooo0P0000280?ooo`8006Ko
:`3oool002/0oooo0P00I_n90?ooo`030000003oool0oooo08L0oooo0P00I_l[0?ooo`00:`3oool2
001VohT0oooo00<000000?ooo`3oool0Q`3oool2001Vob/0oooo000[0?ooo`8006KoR@3oool00`00
0000oooo0?ooo`260?ooo`8006Ko;03oool002/0oooo0`00I_n80?ooo`030000003oool0oooo08H0
oooo0P00I_l/0?ooo`00;03oool2001VohP0oooo00<000000?ooo`3oool0QP3oool2001Vob`0oooo
000/0?ooo`8006KoR03oool00`000000oooo0?ooo`260?ooo`8006Ko;03oool002`0oooo0`00I_n7
0?ooo`030000003oool0oooo08D0oooo0`00I_l/0?ooo`00;@3oool2001VohL0oooo00<000000?oo
o`3oool0Q@3oool2001Vobd0oooo000]0?ooo`8006KoQ`3oool00`000000oooo0?ooo`250?ooo`80
06Ko;@3oool002d0oooo0`00I_n60?ooo`030000003oool0oooo08@0oooo0`00I_l]0?ooo`00;P3o
ool2001VohH0oooo00<000000?ooo`3oool0Q03oool2001Vobh0oooo000^0?ooo`8006KoQP3oool0
0`000000oooo0?ooo`240?ooo`8006Ko;P3oool002h0oooo0P00I_mX0?ooo`050?oDV`0000000000
0000002Ke?l01@3oool00`3DV`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3o
ool00`000000oooo0?ooo`240?ooo`8006Ko;P3oool002h0oooo0`00I_mW0?ooo`060;YbV`3Dool0
oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3o
j[X0LP0009_Do`060?ooo`030000003oool0oooo08@0oooo00<006Ko0?ooo`3oool0;@3oool002l0
oooo0P00I_mV0?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/0
09_D0?ooo`050?ooo`030000003oool0oooo08<0oooo0P00I_l_0?ooo`00;`3oool2001VofH0oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo
00<000000?ooo`3oool0P`3oool00`00I_l0oooo0?ooo`0^0?ooo`00;`3oool3001VofD0oooo00<0
j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo00D0oooo0`00
00220?ooo`8006Ko<03oool00300oooo0P00I_mU0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo00D0oooo00<00000
0?ooo`3oool0PP3oool00`00I_l0oooo0?ooo`0_0?ooo`00<03oool2001VofD0oooo00<0omBK07:j
jP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?oo
o`3oool0PP3oool00`00I_l0oooo0?ooo`0_0?ooo`00<03oool3001VofD0oooo00H0^W8009_Do`3o
ool0onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0P@3oool2
001Voc40oooo000a0?ooo`8006KoI@3oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD
09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo0840oooo00<006Ko
0?ooo`3oool0<03oool00340oooo0P00I_n30?ooo`030000003oool0oooo0800oooo0P00I_lb0?oo
o`00<@3oool3001Voh80oooo00<000000?ooo`3oool0P03oool00`00I_l0oooo0?ooo`0a0?ooo`00
<P3oool2001Voh80oooo00<000000?ooo`3oool0O`3oool2001Voc<0oooo000b0?ooo`<006KoP@3o
ool00`000000oooo0?ooo`1o0?ooo`03001Vo`3oool0oooo0380oooo000c0?ooo`8006KoP@3oool0
0`000000oooo0?ooo`1n0?ooo`8006Ko=03oool003<0oooo0P00I_n10?ooo`030000003oool0oooo
07h0oooo00<006Ko0?ooo`3oool0<`3oool003@0oooo00<006Ko0?ooo`3oool0O`3oool00`000000
oooo0?ooo`1n0?ooo`03001Vo`3oool0oooo03<0oooo000d0?ooo`8006KoP03oool00`000000oooo
0?ooo`1m0?ooo`8006Ko=@3oool003D0oooo00<006Ko0?ooo`3oool0OP3oool00`000000oooo0?oo
o`1m0?ooo`03001Vo`3oool0oooo03@0oooo000e0?ooo`8006KoO`3oool00`000000oooo0?ooo`1l
0?ooo`8006Ko=P3oool003H0oooo00<006Ko0?ooo`3oool0O@3oool00`000000oooo0?ooo`1l0?oo
o`03001Vo`3oool0oooo03D0oooo000f0?ooo`8006KoOP3oool2000007`0oooo0P00I_lg0?ooo`00
=`3oool2001Vogd0oooo00<000000?ooo`3oool0N`3oool00`00I_l0oooo0?ooo`0f0?ooo`00>03o
ool00`00I_l0oooo0?ooo`1k0?ooo`030000003oool0oooo07X0oooo0P00I_lh0?ooo`00>03oool2
001Vog`0oooo00<000000?ooo`3oool0N@3oool2001VocT0oooo000i0?ooo`03001Vo`3oool0oooo
07X0oooo00<000000?ooo`3oool0N@3oool00`00I_l0oooo0?ooo`0h0?ooo`00>@3oool2001Vog/0
oooo00<000000?ooo`3oool0N03oool2001VocX0oooo000j0?ooo`8006KoNP3oool00`000000oooo
0?ooo`1h0?ooo`03001Vo`3oool0oooo03T0oooo000k0?ooo`03001Vo`3oool0oooo07P0oooo00<0
00000?ooo`3oool0M`3oool2001Voc/0oooo000k0?ooo`8006KoN@3oool00`000000oooo0?ooo`1g
0?ooo`03001Vo`3oool0oooo03X0oooo000l0?ooo`03001Vo`3oool0oooo07L0oooo00<000000?oo
o`3oool0MP3oool2001Voc`0oooo000l0?ooo`8006KoN03oool00`000000oooo0?ooo`1e0?ooo`80
06Ko?@3oool003d0oooo0P00I_mg0?ooo`030000003oool0oooo07D0oooo00<006Ko0?ooo`3oool0
?03oool003h0oooo0P00I_mf0?ooo`030000003oool0oooo07@0oooo0P00I_ln0?ooo`00?P3oool3
001VogD0oooo00<000000?ooo`3oool0L`3oool2001Vocl0oooo000o0?ooo`<006KoM03oool00`00
0000oooo0?ooo`1c0?ooo`03001Vo`3oool0oooo03h0oooo00100?ooo`8006KoM03oool00`000000
oooo0?ooo`1b0?ooo`8006Ko@03oool00440oooo0P00I_mc0?ooo`030000003oool0oooo0740oooo
0P00I_m10?ooo`00@@3oool3001Vog80oooo0P00001a0?ooo`8006Ko@P3oool00480oooo0`00I_ma
0?ooo`030000003oool0oooo06l0oooo0`00I_m20?ooo`00@`3oool3001Vog00oooo00<000000?oo
o`3oool0KP3oool3001Vod<0oooo00140?ooo`<006KoK`3oool00`000000oooo0?ooo`1]0?ooo`<0
06KoA03oool004D0oooo0`00I_m^0?ooo`030000003oool0oooo06`0oooo0`00I_m50?ooo`00AP3o
ool3001Vofd0oooo00<000000?ooo`3oool0J`3oool3001VodH0oooo00170?ooo`@006KoJ`3oool0
0`000000oooo0?ooo`1Z0?ooo`<006KoA`3oool004P0oooo1000I_mZ0?ooo`030000003oool0oooo
06T0oooo0`00I_m80?ooo`00BP3oool3001VofT0oooo00<000000?ooo`3oool0I`3oool4001VodT0
oooo001;0?ooo`<006KoJ03oool00`000000oooo0?ooo`1V0?ooo`@006KoBP3oool004`0oooo0`00
I_mW0?ooo`030000003oool0oooo06@0oooo1000I_m<0?ooo`00C@3oool4001VofD0oooo00<00000
0?ooo`3oool0H`3oool4001Vodd0oooo001>0?ooo`@006KoI03oool00`000000oooo0?ooo`1Q0?oo
o`@006KoC`3oool00500oooo0`00I_mS0?ooo`030000003oool0oooo0600oooo1000I_m@0?ooo`00
D@3oool4001Vof40oooo00<000000?ooo`3oool0GP3oool4001Voe80oooo001B0?ooo`@006KoH03o
ool00`000000oooo0?ooo`1L0?ooo`D006KoD`3oool005@0oooo1000I_mN0?ooo`030000003oool0
oooo05/0oooo1000I_mE0?ooo`00E@3oool6001Voe/0oooo0P00001J0?ooo`@006KoE`3oool005L0
oooo1P00I_mI0?ooo`030000003oool0oooo05L0oooo1@00I_mH0?ooo`00FP3oool6001VoeH0oooo
00<000000?ooo`3oool0E03oool6001VoeX0oooo001L0?ooo`L006KoD`3oool00`000000oooo0?oo
o`1B0?ooo`H006KoG03oool005l0oooo1`00I_m@0?ooo`030000003oool0oooo04d0oooo2000I_mO
0?ooo`00HP3oool9001Vod/0oooo00<000000?ooo`3oool0B03oool:001Vof80oooo001U0?ooo`T0
06KoB03oool00`000000oooo0?ooo`150?ooo`P006KoI`3oool006/0oooo1@00I_m60?ooo`030000
003oool0oooo03L0oooo00<006Ko0?ooo`3oool00`3oool<001Vof/0oooo001]0?ooo`D006KoA03o
ool00`000000oooo0?ooo`0f0?oooa0006KoKP3oool006l0oooo1@00I_m20?ooo`030000003oool0
oooo03D0oooo2@00I_mf0?ooo`00L@3oool5001Vod00oooo00<000000?ooo`3oool0=03oool3001V
ogd0oooo001c0?ooo`D006Ko?P3oool00`000000oooo0?ooo`0c0?ooo`8006KoO`3oool007D0oooo
1@00I_ll0?ooo`030000003oool0oooo0340oooo1000I_mo0?ooo`00M`3oool5001VocX0oooo00<0
00000?ooo`3oool0<03oool4001Voh00oooo001i0?ooo`D006Ko>03oool00`000000oooo0?ooo`0_
0?ooo`<006KoPP3oool007/0oooo1@00I_lf0?ooo`030000003oool0oooo02h0oooo0`00I_n30?oo
o`00O@3oool5001Voc@0oooo0P00000^0?ooo`<006KoQ03oool007l0oooo1@00I_lb0?ooo`030000
003oool0oooo02/0oooo1000I_n50?ooo`00P@3oool5001Voc00oooo00<000000?ooo`3oool0:P3o
ool4001VohH0oooo00230?ooo`D006Ko;P3oool00`000000oooo0?ooo`0Y0?ooo`<006KoR03oool0
08D0oooo1@00I_l/0?ooo`030000003oool0oooo02P0oooo0`00I_n90?ooo`00Q`3oool5001VobX0
oooo00<000000?ooo`3oool09P3oool4001VohX0oooo00290?ooo`D006Ko:03oool00`000000oooo
0?ooo`0U0?ooo`@006KoR`3oool008/0oooo1@00I_lV0?ooo`030000003oool0oooo02<0oooo1000
I_n=0?ooo`00S@3oool5001Vob@0oooo00<000000?ooo`3oool08@3oool5001Vohh0oooo002?0?oo
o`@006Ko8`3oool00`000000oooo0?ooo`0P0?ooo`@006KoT03oool00940oooo1000I_lQ0?ooo`03
0000003oool0oooo01h0oooo1000I_nB0?ooo`00TP3oool4001Vob00oooo00<000000?ooo`3oool0
703oool5001Voi<0oooo002D0?ooo`@006Ko7P3oool00`000000oooo0?ooo`0J0?ooo`D006KoU@3o
ool009D0oooo1@00I_l?0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0103oool0
0`000000oooo0?ooo`0I0?ooo`@006KoU`3oool009L0oooo1P00I_l?0?ooo`030;YbLP2jj_l0oooo
00L0oooo00<000000?ooo`3oool05`3oool4001VoiT0oooo002I0?ooo`H006Ko3@3oool00`2jLW80
^^[o0?ooo`070?ooo`030000003oool0oooo01D0oooo1@00I_nJ0?ooo`00W03oool6001Vo`X0oooo
00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`T006KoW03oool009h0oooo2@00
I_l50?ooo`030;YbLP2jj_l0oooo00L0oooo0`00000<0?ooo`T006KoW`3oool00:40oooo2P00I_l0
0`3oool0^W9b0;[Zo`080?ooo`030000003oool0oooo00X0oooo1P00I_nT0?ooo`00Y`3oool9001V
o`H0oooo00<000000?ooo`3oool01@3oool8001VojL0oooo002Y0?ooo`030>ZjLP00I_l006Ko01P0
06KoZ@3oool00:/0oooo00@0j[Yb0000LP2jj_l0oooo4000I_n^0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00
]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool200000;D0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00001\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.18182 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.454545 0.590909 0.454545 [
[.04545 .57841 -6 -9 ]
[.04545 .57841 6 0 ]
[.27273 .57841 -12 -9 ]
[.27273 .57841 12 0 ]
[.72727 .57841 -9 -9 ]
[.72727 .57841 9 0 ]
[.95455 .57841 -3 -9 ]
[.95455 .57841 3 0 ]
[.4875 .13636 -12 -4.5 ]
[.4875 .13636 0 4.5 ]
[.4875 .36364 -24 -4.5 ]
[.4875 .36364 0 4.5 ]
[.4875 .81818 -18 -4.5 ]
[.4875 .81818 0 4.5 ]
[.4875 1.04545 -6 -4.5 ]
[.4875 1.04545 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.18182 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04545 .59091 m
.04545 .59716 L
s
[(-1)] .04545 .57841 0 1 Mshowa
.27273 .59091 m
.27273 .59716 L
s
[(-0.5)] .27273 .57841 0 1 Mshowa
.72727 .59091 m
.72727 .59716 L
s
[(0.5)] .72727 .57841 0 1 Mshowa
.95455 .59091 m
.95455 .59716 L
s
[(1)] .95455 .57841 0 1 Mshowa
.125 Mabswid
.09091 .59091 m
.09091 .59466 L
s
.13636 .59091 m
.13636 .59466 L
s
.18182 .59091 m
.18182 .59466 L
s
.22727 .59091 m
.22727 .59466 L
s
.31818 .59091 m
.31818 .59466 L
s
.36364 .59091 m
.36364 .59466 L
s
.40909 .59091 m
.40909 .59466 L
s
.45455 .59091 m
.45455 .59466 L
s
.54545 .59091 m
.54545 .59466 L
s
.59091 .59091 m
.59091 .59466 L
s
.63636 .59091 m
.63636 .59466 L
s
.68182 .59091 m
.68182 .59466 L
s
.77273 .59091 m
.77273 .59466 L
s
.81818 .59091 m
.81818 .59466 L
s
.86364 .59091 m
.86364 .59466 L
s
.90909 .59091 m
.90909 .59466 L
s
0 .59091 m
0 .59466 L
s
1 .59091 m
1 .59466 L
s
.25 Mabswid
0 .59091 m
1 .59091 L
s
.5 .13636 m
.50625 .13636 L
s
[(-1)] .4875 .13636 1 0 Mshowa
.5 .36364 m
.50625 .36364 L
s
[(-0.5)] .4875 .36364 1 0 Mshowa
.5 .81818 m
.50625 .81818 L
s
[(0.5)] .4875 .81818 1 0 Mshowa
.5 1.04545 m
.50625 1.04545 L
s
[(1)] .4875 1.04545 1 0 Mshowa
.125 Mabswid
.5 .18182 m
.50375 .18182 L
s
.5 .22727 m
.50375 .22727 L
s
.5 .27273 m
.50375 .27273 L
s
.5 .31818 m
.50375 .31818 L
s
.5 .40909 m
.50375 .40909 L
s
.5 .45455 m
.50375 .45455 L
s
.5 .5 m
.50375 .5 L
s
.5 .54545 m
.50375 .54545 L
s
.5 .63636 m
.50375 .63636 L
s
.5 .68182 m
.50375 .68182 L
s
.5 .72727 m
.50375 .72727 L
s
.5 .77273 m
.50375 .77273 L
s
.5 .86364 m
.50375 .86364 L
s
.5 .90909 m
.50375 .90909 L
s
.5 .95455 m
.50375 .95455 L
s
.5 1 m
.50375 1 L
s
.5 .09091 m
.50375 .09091 L
s
.5 .04545 m
.50375 .04545 L
s
.5 1.09091 m
.50375 1.09091 L
s
.5 1.13636 m
.50375 1.13636 L
s
.25 Mabswid
.5 0 m
.5 1.18182 L
s
0 0 m
1 0 L
1 1.18182 L
0 1.18182 L
closepath
clip
newpath
0 .4 1 r
.008 w
.95455 .59091 m
.95453 .59443 L
.9545 .59764 L
.95443 .60134 L
.95433 .60484 L
.9541 .61106 L
.95375 .61781 L
.95325 .62524 L
.95258 .6331 L
.95105 .64717 L
.94901 .66163 L
.94668 .67511 L
.93986 .70552 L
.93078 .73597 L
.92062 .76322 L
.89152 .82182 L
.85961 .86892 L
.81836 .91534 L
.7737 .95382 L
.72103 .9881 L
.69359 1.00217 L
.66291 1.01526 L
.63568 1.02473 L
.60516 1.03312 L
.59059 1.03634 L
.57486 1.03925 L
.56119 1.04132 L
.54625 1.0431 L
.53748 1.04391 L
.52934 1.04451 L
.52156 1.04494 L
.51763 1.04511 L
.51329 1.04526 L
.50939 1.04536 L
.50581 1.04542 L
.50189 1.04545 L
.49991 1.04545 L
.49775 1.04545 L
.4941 1.04542 L
.49019 1.04535 L
.48651 1.04525 L
.48317 1.04514 L
.47625 1.04483 L
.46865 1.04437 L
.45331 1.04305 L
.43915 1.04136 L
.42596 1.03938 L
.39648 1.03351 L
.36532 1.02504 L
.33662 1.01508 L
Mistroke
.30618 1.00206 L
.25352 .97282 L
.20607 .93763 L
.16103 .89375 L
.1217 .84291 L
.0916 .79046 L
.07957 .76368 L
.06878 .73466 L
.06049 .70686 L
.0545 .68113 L
.04972 .65304 L
.04785 .63748 L
.04717 .63031 L
.04657 .6227 L
.04616 .61619 L
.04598 .61274 L
.04582 .60901 L
.04569 .6056 L
.0456 .60248 L
.04554 .5995 L
.04549 .59636 L
.04546 .59292 L
.04546 .58926 L
.04548 .5858 L
.04553 .58266 L
.04561 .57897 L
.04573 .57497 L
.04605 .56772 L
.04646 .56063 L
.04703 .55304 L
.04839 .53936 L
.05053 .52316 L
.053 .50845 L
.06001 .47681 L
.06872 .44735 L
.09121 .39216 L
.1183 .34409 L
.15146 .29913 L
.19419 .25461 L
.23943 .21846 L
.29296 .18626 L
.34804 .16252 L
.37681 .15338 L
.39325 .14908 L
.40892 .14558 L
.42343 .14286 L
.43925 .14044 L
.4537 .13873 L
.46707 .13756 L
.47455 .13708 L
Mistroke
.48156 .13674 L
.48558 .13659 L
.48926 .13649 L
.49129 .13645 L
.4935 .13641 L
.49559 .13639 L
.49753 .13637 L
.49956 .13636 L
.50176 .13637 L
.50383 .13638 L
.50574 .1364 L
.50935 .13646 L
.51317 .13655 L
.51728 .13669 L
.52111 .13685 L
.52982 .13734 L
.53761 .13792 L
.5448 .13858 L
.56103 .14048 L
.57527 .14264 L
.59031 .14543 L
.61608 .15144 L
.64405 .15979 L
.6978 .18166 L
.75208 .21266 L
.79977 .24923 L
.84429 .29414 L
.87994 .3414 L
.90732 .38917 L
.92035 .41794 L
.93078 .44586 L
.93865 .47177 L
.94529 .49965 L
.9493 .52207 L
.95108 .53489 L
.95241 .54691 L
.95335 .55798 L
.95397 .5681 L
.95422 .5737 L
.95432 .57666 L
.95441 .5798 L
.95447 .58283 L
.95451 .58557 L
.95454 .58832 L
.95455 .59091 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{243.688, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005]0001[b000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000
oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?oo
o`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool200000;D0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000
003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0
oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0
oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f
0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000]@3oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?oo
o`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0
]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00:T0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?oo
o`030000003oool0oooo0;@0oooo002/0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3o
ool0]03oool00:`0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`2d0?ooo`00[03o
ool00`2jLW80^^[o0?ooo`0?001Vojl0oooo002P0?ooob`006KoX@3oool009X0oooo5P00I_l60?oo
o`030000003oool0oooo00@0oooo5000I_nL0?ooo`00U@3oool;001Vo``0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`0C0?ooo`/006KoUP3oool008l0oooo2`00I_l?0?ooo`050>Zj
LP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`0H0?ooo`/006KoT@3oool008`0oooo
2@00I_lF0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool07P3oool9001Vohd0oooo
00290?ooo`L006Ko9P3oool00`000000oooo0?ooo`0S0?ooo`P006KoR@3oool008H0oooo1`00I_lY
0?ooo`030000003oool0oooo02L0oooo1`00I_n60?ooo`00PP3oool7001Vobd0oooo00<000000?oo
o`3oool0:`3oool6001Voh<0oooo001n0?ooo`P006Ko<03oool00`000000oooo0?ooo`0^0?ooo`H0
06KoP03oool007`0oooo1P00I_ld0?ooo`030000003oool0oooo0340oooo1P00I_mm0?ooo`00NP3o
ool5001VocL0oooo00<000000?ooo`3oool0<`3oool6001Vog/0oooo001g0?ooo`H006Ko>@3oool0
0`000000oooo0?ooo`0f0?ooo`H006KoN03oool007D0oooo1P00I_lk0?ooo`030000003oool0oooo
03P0oooo1P00I_mf0?ooo`00L`3oool5001Voch0oooo00<000000?ooo`3oool0>`3oool6001Vog<0
oooo001a0?ooo`D006Ko@03oool00`000000oooo0?ooo`0m0?ooo`H006KoL@3oool006h0oooo1P00
I_m20?ooo`030000003oool0oooo0400oooo1P00I_m^0?ooo`00K03oool6001Vod@0oooo0P000013
0?ooo`H006KoK03oool006X0oooo1@00I_m70?ooo`030000003oool0oooo04D0oooo1@00I_mZ0?oo
o`00J03oool5001VodT0oooo00<000000?ooo`3oool0A`3oool4001VofT0oooo001W0?ooo`@006Ko
B`3oool00`000000oooo0?ooo`190?ooo`@006KoI`3oool006D0oooo1000I_m=0?ooo`030000003o
ool0oooo04X0oooo1@00I_mU0?ooo`00H`3oool5001Vodh0oooo00<000000?ooo`3oool0C03oool5
001Vof<0oooo001Q0?ooo`D006KoD03oool00`000000oooo0?ooo`1>0?ooo`D006KoH@3oool00600
oooo1000I_mB0?ooo`030000003oool0oooo0500oooo1@00I_mO0?ooo`00GP3oool4001Voe@0oooo
00<000000?ooo`3oool0DP3oool4001Voeh0oooo001L0?ooo`D006KoE@3oool00`000000oooo0?oo
o`1D0?ooo`@006KoG03oool005X0oooo1@00I_mG0?ooo`030000003oool0oooo05D0oooo1@00I_mJ
0?ooo`00F@3oool4001VoeT0oooo00<000000?ooo`3oool0E`3oool4001VoeT0oooo001G0?ooo`@0
06KoF`3oool00`000000oooo0?ooo`1I0?ooo`<006KoF03oool005H0oooo1000I_mL0?ooo`030000
003oool0oooo05X0oooo1000I_mF0?ooo`00E03oool4001Voeh0oooo00<000000?ooo`3oool0F`3o
ool4001VoeD0oooo001C0?ooo`@006KoG`3oool00`000000oooo0?ooo`1M0?ooo`<006KoE03oool0
0580oooo0`00I_mQ0?ooo`030000003oool0oooo05h0oooo0`00I_mC0?ooo`00D03oool4001Vof80
oooo0P00001P0?ooo`<006KoDP3oool004l0oooo1000I_mS0?ooo`030000003oool0oooo0600oooo
1000I_m@0?ooo`00CP3oool3001VofD0oooo00<000000?ooo`3oool0H@3oool4001Vodl0oooo001=
0?ooo`<006KoIP3oool00`000000oooo0?ooo`1S0?ooo`<006KoCP3oool004/0oooo1000I_mW0?oo
o`030000003oool0oooo06@0oooo0`00I_m=0?ooo`00BP3oool4001VofP0oooo00<000000?ooo`3o
ool0I@3oool4001Vod/0oooo00190?ooo`<006KoJP3oool00`000000oooo0?ooo`1V0?ooo`@006Ko
BP3oool004L0oooo1000I_m[0?ooo`030000003oool0oooo06P0oooo0`00I_m90?ooo`00AP3oool4
001Vof`0oooo00<000000?ooo`3oool0J@3oool3001VodP0oooo00150?ooo`<006KoKP3oool00`00
0000oooo0?ooo`1Z0?ooo`<006KoA`3oool004@0oooo0`00I_m_0?ooo`030000003oool0oooo06/0
oooo0`00I_m60?ooo`00@`3oool3001Vog00oooo00<000000?ooo`3oool0K03oool3001VodD0oooo
00120?ooo`<006KoL@3oool00`000000oooo0?ooo`1]0?ooo`<006KoA03oool00480oooo0P00I_mb
0?ooo`030000003oool0oooo06h0oooo0`00I_m30?ooo`00@@3oool2001Vog<0oooo00<000000?oo
o`3oool0K`3oool3001Vod80oooo00100?ooo`<006KoL`3oool00`000000oooo0?ooo`1`0?ooo`<0
06Ko@@3oool003l0oooo0`00I_md0?ooo`800000LP3oool3001Vod00oooo000n0?ooo`<006KoM@3o
ool00`000000oooo0?ooo`1b0?ooo`<006Ko?`3oool003d0oooo0`00I_mf0?ooo`030000003oool0
oooo07<0oooo0`00I_ln0?ooo`00?03oool3001VogL0oooo00<000000?ooo`3oool0M03oool3001V
ocd0oooo000k0?ooo`<006KoN03oool00`000000oooo0?ooo`1e0?ooo`<006Ko?03oool003/0oooo
0P00I_mi0?ooo`030000003oool0oooo07H0oooo0`00I_lk0?ooo`00>P3oool2001VogX0oooo00<0
00000?ooo`3oool0M`3oool3001VocX0oooo000i0?ooo`<006KoNP3oool00`000000oooo0?ooo`1h
0?ooo`<006Ko>@3oool003P0oooo0`00I_mk0?ooo`030000003oool0oooo07T0oooo0P00I_li0?oo
o`00=`3oool3001Vog`0oooo00<000000?ooo`3oool0NP3oool2001VocP0oooo000g0?ooo`8006Ko
O@3oool00`000000oooo0?ooo`1k0?ooo`8006Ko=`3oool003H0oooo0P00I_mn0?ooo`030000003o
ool0oooo07`0oooo0P00I_lf0?ooo`00=@3oool2001Vogl0oooo00<000000?ooo`3oool0O@3oool0
0`00I_l0oooo0?ooo`0d0?ooo`00=03oool2001Voh00oooo00<000000?ooo`3oool0O@3oool2001V
ocD0oooo000d0?ooo`03001Vo`3oool0oooo07l0oooo00<000000?ooo`3oool0OP3oool2001Voc@0
oooo000c0?ooo`8006KoP@3oool00`000000oooo0?ooo`1o0?ooo`8006Ko<`3oool00380oooo0P00
I_n20?ooo`030000003oool0oooo0800oooo00<006Ko0?ooo`3oool0<@3oool00340oooo0P00I_n3
0?ooo`800000P@3oool2001Voc80oooo000a0?ooo`03001Vo`3oool0oooo0880oooo00<000000?oo
o`3oool0P@3oool2001Voc40oooo000`0?ooo`8006KoQ03oool00`000000oooo0?ooo`220?ooo`80
06Ko<03oool002l0oooo0P00I_n50?ooo`030000003oool0oooo08<0oooo0P00I_l_0?ooo`00;P3o
ool2001VohH0oooo00<000000?ooo`3oool0Q03oool00`00I_l0oooo0?ooo`0]0?ooo`00;P3oool0
0`00I_l0oooo0?ooo`250?ooo`030000003oool0oooo08@0oooo0P00I_l^0?ooo`00;@3oool2001V
ohL0oooo00<000000?ooo`3oool0Q@3oool2001Vobd0oooo000/0?ooo`8006KoR03oool00`000000
oooo0?ooo`260?ooo`8006Ko;03oool002/0oooo0P00I_n90?ooo`030000003oool0oooo08L0oooo
00<006Ko0?ooo`3oool0:P3oool002/0oooo00<006Ko0?ooo`3oool0R03oool00`000000oooo0?oo
o`270?ooo`8006Ko:`3oool002X0oooo0P00I_n:0?ooo`030000003oool0oooo08P0oooo00<006Ko
0?ooo`3oool0:@3oool002X0oooo00<006Ko0?ooo`3oool0R@3oool00`000000oooo0?ooo`280?oo
o`8006Ko:P3oool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08T0oooo00<006Ko0?ooo`3o
ool0:03oool002P0oooo0P00I_m^0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`00
0000002Ke0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`290?oo
o`8006Ko:@3oool002P0oooo00<006Ko0?ooo`3oool0K@3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K
0=Coo`@0oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0
1P3oool00`000000oooo0?ooo`2:0?ooo`8006Ko:03oool002L0oooo0P00I_m^0?ooo`030?oDV`00
Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003o
ool0oooo08/0oooo00<006Ko0?ooo`3oool09P3oool002L0oooo00<006Ko0?ooo`3oool0K@3oool0
0`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool3
000008/0oooo0P00I_lW0?ooo`009P3oool2001VofH0oooo00<0^W800000000000000`0000001@00
L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`05
0?ooo`030000003oool0oooo08`0oooo00<006Ko0?ooo`3oool09@3oool002H0oooo00<006Ko0?oo
o`3oool0KP3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0
000000000P0000000`1b^^X0oooo0?ooo`050?ooo`030000003oool0oooo08`0oooo0P00I_lV0?oo
o`009@3oool2001Vog00oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`03
0?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0S@3oool00`00I_l0oooo0?ooo`0T0?ooo`00
9@3oool00`00I_l0oooo0?ooo`1`0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3o
om@0V`2K0=Coo`0:0?ooo`030000003oool0oooo08d0oooo0P00I_lU0?ooo`00903oool2001Vog80
oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Co
o`3oool01@3oool00`000000oooo0?ooo`2>0?ooo`03001Vo`3oool0oooo02<0oooo000S0?ooo`80
06KoT@3oool00`000000oooo0?ooo`2>0?ooo`8006Ko903oool002<0oooo00<006Ko0?ooo`3oool0
T03oool00`000000oooo0?ooo`2?0?ooo`8006Ko8`3oool00280oooo0P00I_nB0?ooo`030000003o
ool0oooo0900oooo00<006Ko0?ooo`3oool08@3oool00280oooo00<006Ko0?ooo`3oool0T@3oool0
0`000000oooo0?ooo`2@0?ooo`8006Ko8P3oool00240oooo0P00I_nC0?ooo`030000003oool0oooo
0940oooo00<006Ko0?ooo`3oool0803oool00240oooo00<006Ko0?ooo`3oool0TP3oool00`000000
oooo0?ooo`2A0?ooo`8006Ko8@3oool00200oooo0P00I_nD0?ooo`030000003oool0oooo0980oooo
00<006Ko0?ooo`3oool07`3oool00200oooo0P00I_nD0?ooo`030000003oool0oooo0980oooo0P00
I_lP0?ooo`007`3oool2001VoiD0oooo00<000000?ooo`3oool0T`3oool00`00I_l0oooo0?ooo`0N
0?ooo`007`3oool2001VoiD0oooo00<000000?ooo`3oool0T`3oool2001Voal0oooo000N0?ooo`<0
06KoU@3oool00`000000oooo0?ooo`2D0?ooo`03001Vo`3oool0oooo01d0oooo000N0?ooo`8006Ko
UP3oool2000009D0oooo0P00I_lN0?ooo`007@3oool3001VoiH0oooo00<000000?ooo`3oool0U@3o
ool00`00I_l0oooo0?ooo`0L0?ooo`007@3oool2001VoiL0oooo00<000000?ooo`3oool0U@3oool2
001Voad0oooo000M0?ooo`8006KoU`3oool00`000000oooo0?ooo`2F0?ooo`03001Vo`3oool0oooo
01/0oooo000L0?ooo`<006KoU`3oool00`000000oooo0?ooo`2F0?ooo`8006Ko703oool001`0oooo
0P00I_nH0?ooo`030000003oool0oooo09H0oooo0P00I_lL0?ooo`006`3oool3001VoiP0oooo00<0
00000?ooo`3oool0UP3oool3001Voa/0oooo000K0?ooo`8006KoV@3oool00`000000oooo0?ooo`2G
0?ooo`8006Ko6`3oool001/0oooo0P00I_nI0?ooo`030000003oool0oooo09L0oooo0`00I_lJ0?oo
o`006P3oool3001VoiT0oooo00<000000?ooo`3oool0V03oool2001VoaX0oooo000J0?ooo`8006Ko
VP3oool00`000000oooo0?ooo`2H0?ooo`8006Ko6P3oool001T0oooo0`00I_nJ0?ooo`030000003o
ool0oooo09P0oooo0`00I_lI0?ooo`006@3oool2001Voi/0oooo00<000000?ooo`3oool0V@3oool2
001VoaT0oooo000I0?ooo`8006KoV`3oool00`000000oooo0?ooo`2I0?ooo`<006Ko603oool001P0
oooo0`00I_nK0?ooo`030000003oool0oooo09X0oooo0P00I_lH0?ooo`00603oool2001Voi`0oooo
00<000000?ooo`3oool0VP3oool2001VoaP0oooo000G0?ooo`<006KoW03oool2000009/0oooo0`00
I_lG0?ooo`005`3oool2001Void0oooo00<000000?ooo`3oool0V`3oool2001VoaL0oooo000G0?oo
o`8006KoW@3oool00`000000oooo0?ooo`2K0?ooo`8006Ko5`3oool001H0oooo0`00I_nM0?ooo`03
0000003oool0oooo09/0oooo0P00I_lG0?ooo`005P3oool2001Voih0oooo00<000000?ooo`3oool0
V`3oool3001VoaH0oooo000E0?ooo`<006KoWP3oool00`000000oooo0?ooo`2L0?ooo`8006Ko5P3o
ool001D0oooo0P00I_nO0?ooo`030000003oool0oooo09`0oooo0P00I_lF0?ooo`005@3oool2001V
oil0oooo00<000000?ooo`3oool0W03oool2001VoaH0oooo000D0?ooo`<006KoW`3oool00`000000
oooo0?ooo`2M0?ooo`8006Ko5@3oool001@0oooo0P00I_nP0?ooo`030000003oool0oooo09d0oooo
0P00I_lE0?ooo`00503oool2001Voj00oooo00<000000?ooo`3oool0W@3oool2001VoaD0oooo000D
0?ooo`8006KoX03oool00`000000oooo0?ooo`2M0?ooo`8006Ko5@3oool001@0oooo0P00I_nP0?oo
o`030000003oool0oooo09d0oooo0P00I_lE0?ooo`00503oool2001Voj00oooo00<000000?ooo`3o
ool0WP3oool2001Voa@0oooo000C0?ooo`8006KoX@3oool00`000000oooo0?ooo`2N0?ooo`8006Ko
503oool001<0oooo0P00I_nQ0?ooo`030000003oool0oooo09h0oooo0P00I_lD0?ooo`004`3oool2
001Voj40oooo00<000000?ooo`3oool0WP3oool2001Voa@0oooo000C0?ooo`8006KoX@3oool20000
09l0oooo0`00I_lC0?ooo`004`3oool2001Voj40oooo00<000000?ooo`3oool0W`3oool2001Voa<0
oooo000C0?ooo`8006KoX@3oool00`000000oooo0?ooo`2O0?ooo`8006Ko4`3oool00180oooo0P00
I_nR0?ooo`030000003oool0oooo09l0oooo0P00I_lC0?ooo`004P3oool2001Voj80oooo00<00000
0?ooo`3oool0W`3oool3001Voa80oooo000B0?ooo`8006KoXP3oool00`000000oooo0?ooo`2P0?oo
o`8006Ko4P3oool00180oooo0P00I_nR0?ooo`030000003oool0oooo0:00oooo0P00I_lB0?ooo`00
4P3oool2001Voj80oooo00<000000?ooo`3oool0X03oool2001Voa80oooo000A0?ooo`8006KoX`3o
ool00`000000oooo0?ooo`2P0?ooo`8006Ko4P3oool00140oooo0P00I_nS0?ooo`030000003oool0
oooo0:00oooo0P00I_lB0?ooo`004@3oool2001Voj<0oooo00<000000?ooo`3oool0X03oool2001V
oa80oooo000A0?ooo`8006KoX`3oool00`000000oooo0?ooo`2P0?ooo`8006Ko4P3oool00140oooo
0P00I_nS0?ooo`030000003oool0oooo0:00oooo0P00I_lB0?ooo`004@3oool2001Voj<0oooo00<0
00000?ooo`3oool0X03oool3001Voa40oooo000@0?ooo`8006KoY03oool00`000000oooo0?ooo`2Q
0?ooo`8006Ko4@3oool00100oooo0P00I_nT0?ooo`030000003oool0oooo0:40oooo0P00I_lA0?oo
o`00403oool2001Voj@0oooo0P00002R0?ooo`8006Ko4@3oool00100oooo0P00I_l500000003002K
e03oool0oooo0480oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`130?ooo`030000003oool0oooo04@0oooo00D0omBK0000
00000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000000009_D
o`140?ooo`040?oDV`00000006Ko001Vo`80000000<009_D0?ooo`3oool0303oool00100oooo0P00
I_l20?ooo`030;YbLP2jj_l0oooo04D0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`03
0=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo0480oooo00<00000
0?ooo`3oool0A03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0
103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l0A@3oool2001Vo`030;[Zo`3oool0oooo
00h0oooo000@0?ooo`8006Ko0P3oool00`2jLW80^^[o0?ooo`140?ooo`030?oDV`00Vm@0oooo0080
oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`110?ooo`030000003oool0oooo04<0
oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo04@0
oooo0P00I_l00`2jj_l0oooo0?ooo`0>0?ooo`00403oool2001Vo`80oooo00<0^W9b0;[Zo`3oool0
A03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool0
@@3oool00`000000oooo0?ooo`130?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
3`3oool00`3oe9/009_D0?ooo`140?ooo`8006Ko00<0^^[o0?ooo`3oool03P3oool000P0oooo00<0
^W800000000000000`0000001000L[X0oooo001Vo`00I_l20?ooo`030;YbLP2jj_l0oooo03/0oooo
00<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03o
ool03`3oool00`2jLP00VmCo0?ooo`110?ooo`030000003oool0oooo04<0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;Yb002Ke?l0oooo04@0oooo0P00I_l00`2jj_l0
oooo0?ooo`0>0?ooo`003`3oool3001Vo`80oooo00<0^W9b0;[Zo`3oool0A03oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo
0?ooo`110?ooo`030000003oool0oooo04<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D
0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool0A03oool2001Vo`030;[Z
o`3oool0oooo00h0oooo000?0?ooo`8006Ko0`3oool00`2jLW80^^[o0?ooo`140?ooo`030?oDV`1b
^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`160?ooo`030000003o
ool0oooo04<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K
09/0e?oo04T0oooo0P00I_l00`2jj_l0oooo0?ooo`0>0?ooo`003`3oool2001Vo`050>ZjLP000000
07:j0;YbLP2jj_l0AP3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00<0oooD09/0V`3D
ool0AP3oool00`000000oooo0?ooo`140?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool0
0`3oom@0V`2K0=Coo`170?ooo`050>ZjLP00000006Ko001Vo`2jj_l0403oool000l0oooo0P00I_l2
0?ooo`030>ZjLP000780^^[o04H0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K
000000000080000000<0002K0=Coo`3oool0@@3oool00`000000oooo0?ooo`140?ooo`050?ooe02K
000000000000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo04@0oooo
0P00I_l00`2jj_l0oooo0?ooo`0>0?ooo`003`3oool2001VojD0oooo00<000000?ooo`3oool0X@3o
ool2001Voa40oooo000?0?ooo`8006KoY@3oool00`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool0
00l0oooo0P00I_nU0?ooo`030000003oool0oooo0:40oooo0P00I_lA0?ooo`003`3oool2001VojD0
oooo00<000000?ooo`3oool0X@3oool2001Voa40oooo000?0?ooo`8006KoY@3oool00`000000oooo
0?ooo`2Q0?ooo`8006Ko4@3oool000l0oooo0P00I_nU0?ooo`030000003oool0oooo0:40oooo0P00
I_lA0?ooo`003`3oool2001VojD0oooo00<000000?ooo`3oool0X@3oool2001Voa40oooo000?0000
008006Koo`00001:0000008006Ko4@00000000030000003oool0oooo00`0oooo0P00I_l@0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00`0oooo0P00I_l@0?ooo`400000000?0?ooo`8006KoDP3oool00`000000oooo
0?ooo`1@0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0CP3oool2001Voa40oooo
000?0?ooo`8006KoY@3oool00`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool000l0oooo0P00I_nU
0?ooo`030000003oool0oooo0:40oooo0P00I_lA0?ooo`003`3oool2001VojD0oooo00<000000?oo
o`3oool0X@3oool2001Voa40oooo000?0?ooo`8006KoY@3oool00`000000oooo0?ooo`2Q0?ooo`80
06Ko4@3oool000l0oooo0P00I_nU0?ooo`030000003oool0oooo0:40oooo0P00I_lA0?ooo`003`3o
ool2001VojD0oooo00<000000?ooo`3oool0X@3oool2001Voa40oooo000?0?ooo`8006KoY@3oool0
0`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool000l0oooo0P00I_nU0?ooo`030000003oool0oooo
0:40oooo0P00I_lA0?ooo`003`3oool2001VojD0oooo00<000000?ooo`3oool0X@3oool2001Voa40
oooo000@0?ooo`03001Vo`3oool0oooo0:<0oooo00<000000?ooo`3oool0X@3oool2001Voa40oooo
000@0?ooo`8006KoY03oool00`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool00140oooo00<006Ko
0?ooo`3oool0XP3oool00`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool00100oooo0P00I_nT0?oo
o`030000003oool0oooo0:40oooo0P00I_lA0?ooo`00403oool2001Voj@0oooo00<000000?ooo`3o
ool0X@3oool2001Voa40oooo000@0?ooo`8006KoY03oool200000:80oooo0P00I_lA0?ooo`004@3o
ool2001Voj<0oooo00<000000?ooo`3oool0X@3oool2001Voa40oooo000A0?ooo`8006KoX`3oool0
0`000000oooo0?ooo`2Q0?ooo`8006Ko4@3oool00140oooo0P00I_nS0?ooo`030000003oool0oooo
0:40oooo0P00I_lA0?ooo`004@3oool2001Voj<0oooo00<000000?ooo`3oool0X03oool2001Voa80
oooo000A0?ooo`8006KoX`3oool00`000000oooo0?ooo`2P0?ooo`8006Ko4P3oool00140oooo0P00
I_nS0?ooo`030000003oool0oooo0:00oooo0P00I_lB0?ooo`004P3oool2001Voj80oooo00<00000
0?ooo`3oool0X03oool2001Voa80oooo000B0?ooo`8006KoXP3oool00`000000oooo0?ooo`2P0?oo
o`8006Ko4P3oool00180oooo0P00I_nR0?ooo`030000003oool0oooo09l0oooo0P00I_lC0?ooo`00
4P3oool2001Voj80oooo00<000000?ooo`3oool0W`3oool2001Voa<0oooo000B0?ooo`8006KoXP3o
ool00`000000oooo0?ooo`2O0?ooo`8006Ko4`3oool00180oooo0P00I_nR0?ooo`030000003oool0
oooo09l0oooo0P00I_lC0?ooo`004P3oool2001Voj80oooo00<000000?ooo`3oool0W`3oool2001V
oa<0oooo000B0?ooo`8006KoXP3oool00`000000oooo0?ooo`2O0?ooo`8006Ko4`3oool00180oooo
0P00I_nR0?ooo`030000003oool0oooo09l0oooo0P00I_lC0?ooo`004P3oool3001Voj40oooo0P00
002P0?ooo`8006Ko4`3oool001<0oooo0P00I_nQ0?ooo`030000003oool0oooo09l0oooo0P00I_lC
0?ooo`004`3oool2001Voj40oooo00<000000?ooo`3oool0WP3oool3001Voa<0oooo000C0?ooo`<0
06KoX03oool00`000000oooo0?ooo`2N0?ooo`8006Ko503oool001@0oooo0P00I_nP0?ooo`030000
003oool0oooo09h0oooo0P00I_lD0?ooo`00503oool2001Voj00oooo00<000000?ooo`3oool0W@3o
ool3001Voa@0oooo000D0?ooo`<006KoW`3oool00`000000oooo0?ooo`2M0?ooo`8006Ko5@3oool0
01D0oooo0P00I_nO0?ooo`030000003oool0oooo09d0oooo0P00I_lE0?ooo`005@3oool2001Voil0
oooo00<000000?ooo`3oool0W@3oool2001VoaD0oooo000E0?ooo`<006KoWP3oool00`000000oooo
0?ooo`2L0?ooo`<006Ko5@3oool001H0oooo0P00I_nN0?ooo`030000003oool0oooo09`0oooo0P00
I_lF0?ooo`005P3oool2001Voih0oooo00<000000?ooo`3oool0W03oool2001VoaH0oooo000F0?oo
o`<006KoW@3oool00`000000oooo0?ooo`2L0?ooo`8006Ko5P3oool001L0oooo0P00I_nM0?ooo`03
0000003oool0oooo09/0oooo0`00I_lF0?ooo`005`3oool2001Void0oooo00<000000?ooo`3oool0
V`3oool2001VoaL0oooo000G0?ooo`8006KoW@3oool00`000000oooo0?ooo`2K0?ooo`8006Ko5`3o
ool001L0oooo0`00I_nL0?ooo`030000003oool0oooo09X0oooo0`00I_lG0?ooo`00603oool2001V
oi`0oooo0P00002K0?ooo`8006Ko603oool001P0oooo0P00I_nL0?ooo`030000003oool0oooo09X0
oooo0P00I_lH0?ooo`00603oool3001Voi/0oooo00<000000?ooo`3oool0VP3oool2001VoaP0oooo
000I0?ooo`8006KoV`3oool00`000000oooo0?ooo`2I0?ooo`<006Ko603oool001T0oooo0P00I_nK
0?ooo`030000003oool0oooo09T0oooo0P00I_lI0?ooo`006@3oool3001VoiX0oooo00<000000?oo
o`3oool0V03oool3001VoaT0oooo000J0?ooo`8006KoVP3oool00`000000oooo0?ooo`2H0?ooo`80
06Ko6P3oool001X0oooo0P00I_nJ0?ooo`030000003oool0oooo09P0oooo0P00I_lJ0?ooo`006P3o
ool3001VoiT0oooo00<000000?ooo`3oool0U`3oool3001VoaX0oooo000K0?ooo`8006KoV@3oool0
0`000000oooo0?ooo`2G0?ooo`8006Ko6`3oool001/0oooo0`00I_nH0?ooo`030000003oool0oooo
09H0oooo0`00I_lK0?ooo`00703oool2001VoiP0oooo00<000000?ooo`3oool0UP3oool2001Voa`0
oooo000L0?ooo`8006KoV03oool00`000000oooo0?ooo`2F0?ooo`8006Ko703oool001`0oooo0`00
I_nG0?ooo`030000003oool0oooo09H0oooo00<006Ko0?ooo`3oool06`3oool001d0oooo0P00I_nG
0?ooo`030000003oool0oooo09D0oooo0P00I_lM0?ooo`007@3oool2001VoiL0oooo00<000000?oo
o`3oool0U@3oool00`00I_l0oooo0?ooo`0L0?ooo`007@3oool3001VoiH0oooo0P00002E0?ooo`80
06Ko7P3oool001h0oooo0P00I_nF0?ooo`030000003oool0oooo09@0oooo00<006Ko0?ooo`3oool0
7@3oool001h0oooo0`00I_nE0?ooo`030000003oool0oooo09<0oooo0P00I_lO0?ooo`007`3oool2
001VoiD0oooo00<000000?ooo`3oool0T`3oool00`00I_l0oooo0?ooo`0N0?ooo`007`3oool2001V
oiD0oooo00<000000?ooo`3oool0TP3oool2001Vob00oooo000P0?ooo`8006KoU03oool00`000000
oooo0?ooo`2B0?ooo`03001Vo`3oool0oooo01l0oooo000P0?ooo`8006KoU03oool00`000000oooo
0?ooo`2A0?ooo`8006Ko8@3oool00240oooo00<006Ko0?ooo`3oool0TP3oool00`000000oooo0?oo
o`2@0?ooo`8006Ko8P3oool00240oooo0P00I_nC0?ooo`030000003oool0oooo0900oooo00<006Ko
0?ooo`3oool08@3oool00280oooo00<006Ko0?ooo`3oool0T@3oool00`000000oooo0?ooo`2?0?oo
o`8006Ko8`3oool00280oooo0P00I_nB0?ooo`030000003oool0oooo08l0oooo00<006Ko0?ooo`3o
ool08P3oool002<0oooo0P00I_nA0?ooo`030000003oool0oooo08h0oooo0P00I_lT0?ooo`00903o
ool00`00I_l0oooo0?ooo`2?0?ooo`030000003oool0oooo08h0oooo00<006Ko0?ooo`3oool08`3o
ool002@0oooo0P00I_mb0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002K
e0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`2=0?ooo`8006Ko
9@3oool002D0oooo00<006Ko0?ooo`3oool0L03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0
oooo00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool0
0`000000oooo0?ooo`2=0?ooo`03001Vo`3oool0oooo02@0oooo000U0?ooo`8006KoL03oool00`3o
e9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`00
0000oooo0?ooo`2<0?ooo`8006Ko9P3oool002H0oooo00<006Ko0?ooo`3oool0KP3oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000
oooo0?ooo`2<0?ooo`03001Vo`3oool0oooo02D0oooo000V0?ooo`8006KoK`3oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3oool3000008/0oooo
0P00I_lW0?ooo`009`3oool2001Vofh0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?oo
o`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?oo
o`2;0?ooo`03001Vo`3oool0oooo02H0oooo000X0?ooo`03001Vo`3oool0oooo06`0oooo00<0omBK
07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<00000
0?ooo`3oool0RP3oool2001VobP0oooo000X0?ooo`8006KoKP3oool01P2jLP00VmCo0?ooo`3oj[X0
LP2K0=Coo`/0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`290?ooo`8006Ko:@3o
ool002T0oooo00<006Ko0?ooo`3oool0K03oool01@3oom@0V`00000000000780^^[o00`0oooo00<0
oooD09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo08T0oooo00<0
06Ko0?ooo`3oool0:03oool002T0oooo0P00I_n;0?ooo`030000003oool0oooo08P0oooo0P00I_lZ
0?ooo`00:P3oool2001VohX0oooo00<000000?ooo`3oool0Q`3oool2001Vob/0oooo000[0?ooo`03
001Vo`3oool0oooo08P0oooo00<000000?ooo`3oool0Q`3oool00`00I_l0oooo0?ooo`0Z0?ooo`00
:`3oool2001VohT0oooo00<000000?ooo`3oool0QP3oool2001Vob`0oooo000/0?ooo`03001Vo`3o
ool0oooo08L0oooo00<000000?ooo`3oool0Q@3oool2001Vobd0oooo000/0?ooo`8006KoR03oool0
0`000000oooo0?ooo`250?ooo`03001Vo`3oool0oooo02`0oooo000]0?ooo`8006KoQ`3oool00`00
0000oooo0?ooo`240?ooo`8006Ko;P3oool002h0oooo0P00I_n60?ooo`030000003oool0oooo08@0
oooo00<006Ko0?ooo`3oool0;@3oool002l0oooo00<006Ko0?ooo`3oool0Q03oool00`000000oooo
0?ooo`230?ooo`8006Ko;`3oool002l0oooo0P00I_n50?ooo`030000003oool0oooo0880oooo0P00
I_l`0?ooo`00<03oool2001Voh@0oooo00<000000?ooo`3oool0PP3oool00`00I_l0oooo0?ooo`0_
0?ooo`00<@3oool2001Voh<0oooo0P0000220?ooo`8006Ko<@3oool00380oooo0P00I_n20?ooo`03
0000003oool0oooo0800oooo0P00I_lb0?ooo`00<`3oool00`00I_l0oooo0?ooo`200?ooo`030000
003oool0oooo07l0oooo0P00I_lc0?ooo`00<`3oool2001Voh40oooo00<000000?ooo`3oool0OP3o
ool3001Voc<0oooo000d0?ooo`8006KoP03oool00`000000oooo0?ooo`1m0?ooo`<006Ko=03oool0
03D0oooo0P00I_mo0?ooo`030000003oool0oooo07`0oooo0`00I_le0?ooo`00=P3oool00`00I_l0
oooo0?ooo`1m0?ooo`030000003oool0oooo07`0oooo0P00I_lf0?ooo`00=P3oool2001Vogh0oooo
00<000000?ooo`3oool0N`3oool2001VocL0oooo000g0?ooo`8006KoO@3oool00`000000oooo0?oo
o`1j0?ooo`<006Ko=`3oool003P0oooo0P00I_ml0?ooo`030000003oool0oooo07T0oooo0`00I_lh
0?ooo`00>@3oool2001Vog/0oooo00<000000?ooo`3oool0N03oool3001VocT0oooo000j0?ooo`80
06KoNP3oool00`000000oooo0?ooo`1g0?ooo`<006Ko>P3oool003X0oooo0`00I_mi0?ooo`030000
003oool0oooo07H0oooo0`00I_lk0?ooo`00>`3oool3001VogP0oooo00<000000?ooo`3oool0M@3o
ool3001Voc`0oooo000l0?ooo`<006KoM`3oool00`000000oooo0?ooo`1e0?ooo`8006Ko?@3oool0
03d0oooo0`00I_mf0?ooo`030000003oool0oooo07@0oooo0P00I_ln0?ooo`00?P3oool3001VogD0
oooo00<000000?ooo`3oool0L`3oool3001Voch0oooo000o0?ooo`<006KoM03oool2000007<0oooo
0`00I_lo0?ooo`00@03oool3001Vog<0oooo00<000000?ooo`3oool0L@3oool3001Vod00oooo0011
0?ooo`@006KoL@3oool00`000000oooo0?ooo`1`0?ooo`<006Ko@@3oool00480oooo1000I_m`0?oo
o`030000003oool0oooo06l0oooo0`00I_m20?ooo`00A03oool3001Vofl0oooo00<000000?ooo`3o
ool0KP3oool3001Vod<0oooo00150?ooo`<006KoKP3oool00`000000oooo0?ooo`1/0?ooo`@006Ko
A03oool004H0oooo0`00I_m]0?ooo`030000003oool0oooo06/0oooo1000I_m50?ooo`00A`3oool3
001Vof`0oooo00<000000?ooo`3oool0JP3oool3001VodL0oooo00180?ooo`<006KoJ`3oool00`00
0000oooo0?ooo`1Y0?ooo`<006KoB03oool004T0oooo0`00I_mZ0?ooo`030000003oool0oooo06P0
oooo0`00I_m90?ooo`00BP3oool3001VofT0oooo00<000000?ooo`3oool0I`3oool3001VodX0oooo
001;0?ooo`@006KoI`3oool00`000000oooo0?ooo`1V0?ooo`<006KoB`3oool004`0oooo1000I_mV
0?ooo`030000003oool0oooo06@0oooo1000I_m<0?ooo`00CP3oool3001VofD0oooo00<000000?oo
o`3oool0H`3oool4001Vodd0oooo001?0?ooo`@006KoH`3oool00`000000oooo0?ooo`1R0?ooo`<0
06KoC`3oool00500oooo1000I_mR0?ooo`030000003oool0oooo0640oooo0`00I_m@0?ooo`00DP3o
ool3001Vof40oooo00<000000?ooo`3oool0G`3oool4001Voe40oooo001C0?ooo`<006KoH03oool2
000005l0oooo1000I_mB0?ooo`00E03oool4001Voeh0oooo00<000000?ooo`3oool0G03oool4001V
oe@0oooo001E0?ooo`@006KoG@3oool00`000000oooo0?ooo`1K0?ooo`@006KoE@3oool005L0oooo
0`00I_mL0?ooo`030000003oool0oooo05T0oooo1000I_mG0?ooo`00F03oool4001VoeX0oooo00<0
00000?ooo`3oool0F03oool4001VoeP0oooo001I0?ooo`@006KoF@3oool00`000000oooo0?ooo`1F
0?ooo`@006KoFP3oool005/0oooo1000I_mG0?ooo`030000003oool0oooo05D0oooo1000I_mK0?oo
o`00G03oool4001VoeH0oooo00<000000?ooo`3oool0D`3oool4001Voed0oooo001N0?ooo`@006Ko
E03oool00`000000oooo0?ooo`1B0?ooo`@006KoGP3oool005l0oooo1@00I_mB0?ooo`030000003o
ool0oooo0500oooo1000I_mP0?ooo`00H@3oool5001Voe00oooo00<000000?ooo`3oool0C`3oool4
001Vof40oooo001S0?ooo`@006KoC`3oool00`000000oooo0?ooo`1=0?ooo`@006KoH`3oool006D0
oooo1000I_m=0?ooo`030000003oool0oooo04/0oooo1@00I_mT0?ooo`00IP3oool5001Vod/0oooo
00<000000?ooo`3oool0B@3oool5001VofH0oooo001X0?ooo`D006KoB@3oool00`000000oooo0?oo
o`170?ooo`D006KoJ03oool006X0oooo1000I_m80?ooo`030000003oool0oooo04D0oooo1@00I_mZ
0?ooo`00K03oool4001VodH0oooo0P0000140?ooo`D006KoK03oool006d0oooo1@00I_m40?ooo`03
0000003oool0oooo0440oooo1@00I_m^0?ooo`00K`3oool5001Vod80oooo00<000000?ooo`3oool0
?`3oool5001Vog00oooo001a0?ooo`H006Ko?`3oool00`000000oooo0?ooo`0l0?ooo`H006KoLP3o
ool007<0oooo1P00I_lm0?ooo`030000003oool0oooo03X0oooo1P00I_md0?ooo`00MP3oool5001V
oc/0oooo00<000000?ooo`3oool0>03oool5001VogL0oooo001h0?ooo`H006Ko>03oool00`000000
oooo0?ooo`0e0?ooo`H006KoN@3oool007X0oooo2000I_ld0?ooo`030000003oool0oooo0380oooo
1P00I_ml0?ooo`00OP3oool7001Voc40oooo00<000000?ooo`3oool0;P3oool7001Vogl0oooo0022
0?ooo`L006Ko;@3oool00`000000oooo0?ooo`0[0?ooo`L006KoPP3oool008D0oooo2000I_lY0?oo
o`030000003oool0oooo02L0oooo1`00I_n60?ooo`00R@3oool7001VobH0oooo00<000000?ooo`3o
ool08`3oool8001VohT0oooo002=0?ooo`L006Ko8P3oool00`000000oooo0?ooo`0N0?ooo`T006Ko
S@3oool00900oooo2000I_lA0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0103o
ool00`000000oooo0?ooo`0H0?ooo`/006KoT@3oool009@0oooo1`00I_lA0?ooo`030;YbLP2jj_l0
oooo00L0oooo00<000000?ooo`3oool04`3oool;001VoiH0oooo002H0?ooo`d006Ko1`3oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo00h0oooo2P00I_nL0?ooo`00V`3ooolC001Vo`P0
oooo00<000000?ooo`3oool01@3oool>001Voj40oooo002U0?ooob8006KoYP3oool00:`0oooo00<0
^W9b001Vo`00I_l04000I_n^0?ooo`00[03oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0
oooo0;@0oooo002Y0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`2d
0?ooo`00Z`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo0;@0oooo002f0?ooo`03
0000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003o
ool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo
0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo
002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?oo
o`030000003oool0oooo0;@0oooo002f0?ooo`030000003oool0oooo0;@0oooo002f0?ooo`800000
]@3oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool0
0;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo
00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<00000
0?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3o
ool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03o
ool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0
oooo00<000000?ooo`3oool0]03oool00;H0oooo00<000000?ooo`3oool0]03oool00;H0oooo00<0
00000?ooo`3oool0]03oool00;H0oooo0P00002e0?ooo`00]P3oool00`000000oooo0?ooo`2d0?oo
o`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3o
ool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`00
0000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo
0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d
0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00
]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00]P3oool0
0`000000oooo0?ooo`2d0?ooo`00]P3oool00`000000oooo0?ooo`2d0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 364.5}, {430.875, 0}} -> {-1.10001, -1.30032, \
0.0090536, 0.0090536}}]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
  "Si consideramos el campo definido por (4), el teorema anterior nos dice \
que la circulaci\[OAcute]n de dicho campo es la misma para cualquiera de las \
curvas cerradas que aparecen en la animaci\[OAcute]n anterior, es decir es \
igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(2\)  \(\[Pi]\)\(\ \)\)\)]],
  "en cualquiera de ellas. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Estudia si los siguientes campos son conservativos en el dominio que se \
indica en cada caso. Cuando el campo sea conservativo calcula la funci\
\[OAcute]n potencial que se anula en el origen.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x - y)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((y + \(y\^2\) x)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x\^3 + 3 \( y\^2\) x)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(-y\^3\) + 3  y\ x\^2)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((2  x\ cos\ y - \ y\ cos\ x)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(-x\^2\) sen\ y - \ sen\ x)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^2\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"2", "x", " ", \(y\^3\), \(z\^4\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"3", \(x\^2\), \(y\^\(2\ \)\), \(z\^4\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{"4", \(x\^2\), \(y\^3\), \(z\^3\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`A = \[DoubleStruckCapitalR]\^3\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula las siguientes integrales de l\[IAcute]nea:\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              SubscriptBox["\[Integral]", 
                StyleBox["r",
                  FontWeight->"Bold"]], " ", \(y \[DifferentialD]x\)}], " ", 
            "+", " ", \(x \[DifferentialD]y\)}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], "=", 
            RowBox[{
              RowBox[{\((t + 1)\), \(cos\^4\), " ", "t", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "+", 
              RowBox[{\((t/\[Pi] + \(sen\^4\) t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["r",
                FontWeight->"Bold"]], " ", 
            \(\((z\^3 + 2  x\ y)\) \[DifferentialD]x\)}], " ", "+", " ", 
          \(\(x\^2\) \[DifferentialD]y\), " ", "+", 
          \(3  x\ \(z\^2\) \[DifferentialD]z\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold"], "(", "t", ")"}], "=", 
            \([\((1, 1, 2)\), \((1, 1, 1)\), \((0, 1, 1)\), \((1, 2, 2)\), 
              \((2, 1, 1)\)]\)}]}], TraditionalForm]]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], 
            RowBox[{\((2  x\ z + sen\ y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}]}], 
          StyleBox[" ",
            FontWeight->"Bold"], "+", 
          RowBox[{"x", " ", "cos", " ", "y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], 
          StyleBox[" ",
            FontWeight->"Bold"], "+", 
          RowBox[{\(x\^2\), " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{"cos", " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", 
            RowBox[{"sen", " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"t", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], 
            RowBox[{"4", \(x\[ExponentialE]\^\(\ z\)\), 
              StyleBox["i",
                FontWeight->"Bold"]}]}], " ", "+", 
          RowBox[{"cos", " ", "y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], " ", "+", 
          RowBox[{"2", \(x\^2\), \(\[ExponentialE]\^\(\ z\)\), " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{\(t\^2\), " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(t\^4\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Indica algunos dominios en los que el campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", 
            \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                StyleBox[\(x\^2 + y\^2\),
                  FontSlant->"Italic"]]}], ")"}]}], "        "}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell["\<\
sea conservativo. Calcula la integral de dicho campo sobre la circunferencia \
de centro (1,1) y radio 1.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Estudia si el campo  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", 
            \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"2", 
                  StyleBox["x",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["y",
                    FontSlant->"Italic"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    StyleBox[\(x\^2 + y\^2\),
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]], ",", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"], "-", 
                  SuperscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "2"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    StyleBox[\(x\^2 + y\^2\),
                      FontSlant->"Italic"], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "es conservativo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  " (ten en cuenta que ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)]],
  " no es un dominio simplemente conexo)."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Teorema de Green", "Section"],

Cell[TextData[{
  "La versi\[OAcute]n m\[AAcute]s elemental del teorema de Green relaciona \
una integral de l\[IAcute]nea sobre una curva cerrada y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " y una integral doble sobre la regi\[OAcute]n acotada por la curva. Se \
dice que una curva \[Gamma] cerrada y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "est\[AAcute] ",
  StyleBox["orientada positivamente",
    FontWeight->"Bold"],
  " cuando se recorre en sentido contrario a las agujas del reloj. En otras \
palabras, cuando recorremos la curva \[Gamma] en el sentido que indica su \
vector tangente en cada punto, la regi\[OAcute]n interior de \[Gamma] queda \
siempre a nuestra izquierda. \nObserva que estamos usando un resultado, \
conocido como teorema de la curva de Jordan, que afirma que una curva \
\[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " cerrada y simple divide al plano en dos regiones disjuntas cuya frontera \
com\[UAcute]n es la curva. Una de las regiones est\[AAcute] acotada y se \
llama interior de \[Gamma] y la otra se llama exterior de \[Gamma]. Este \
resultado tan intuitivo es muy dif\[IAcute]cil de demostrar. Nos apoyamos en \
\[EAcute]l m\[AAcute]s que nada por comodidad de lenguaje pues para lo que \
estamos haciendo puede evitarse su uso.\nUna definici\[OAcute]n \
matem\[AAcute]tica m\[AAcute]s precisa de lo que se entiende por \"orientaci\
\[OAcute]n positiva\" es la siguiente. Sea \[Gamma] una curva suave cerrada y \
simple; llamemos ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " a la regi\[OAcute]n interior de \[Gamma] y sea ",
  Cell[BoxData[
      \(TraditionalForm\`P \[Element] \[Gamma]\)]],
  " un punto de \[Gamma]. La curva \[Gamma] tiene en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " dos vectores normales unitarios que son opuestos entre s\[IAcute]. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " un vector normal a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  ". Se dice que ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " es la ",
  StyleBox["normal interior",
    FontWeight->"Bold"],
  " a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " si hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Delta] > 0\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`P\  + \ t\ N \[Element] D\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`P\  - \ t\ N \[NotElement] D\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`0 < t < \[Delta]\)]],
  " (esta condici\[OAcute]n expresa que si se avanza un poquito desde ",
  Cell[BoxData[
      \(TraditionalForm\`P\)]],
  " en la direcci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " se entra en ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " y si se avanza en la direcci\[OAcute]n opuesta a ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  "se sale de ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  "). Se dice que \[Gamma] est\[AAcute] orientada positivamente cuando el \
determinante de la matriz cuya primera fila es el vector tangente unitario a \
\[Gamma] en un punto t y cuya segunda fila es el vector normal interior a \
\[Gamma] en un punto t es siempre positivo (de hecho, igual a 1), esto es lo \
mismo que exigir que el giro que lleva el vector tangente unitario al vector \
normal interior sea siempre en sentido contrario a las agujas del reloj. "
}], "Text"],

Cell["\<\
La siguiente gr\[AAcute]fica muestra un ejemplo de una curva cerrada simple \
positivamente orientada. Observa que el giro que lleva el vector tangente (en \
azul) al vector normal interior (en verde) es siempre en sentido contrario a \
las agujas del reloj.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(curvacerradasimple;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .98872 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.450237 0.219151 0.494357 0.219151 [
[1.025 .49436 0 -9.09375 ]
[1.025 .49436 10.75 9.09375 ]
[.45024 1.01372 -5.375 0 ]
[.45024 1.01372 5.375 18.1875 ]
[.58173 .62585 -7.0625 -9.09375 ]
[.58173 .62585 7.0625 9.09375 ]
[.77896 .75734 -5.75 -9.09375 ]
[.77896 .75734 5.75 9.09375 ]
[ 0 0 0 0 ]
[ 1 .98872 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .49436 m
1 .49436 L
s
gsave
1.025 .49436 -61 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.750 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.45024 0 m
.45024 .98872 L
s
gsave
.45024 1.01372 -66.375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.750 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
/MAarrowhead2 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.07 0.0175 moveto 0 0 lineto
-0.07 -0.0175 lineto fill
-0.07 0.0175 moveto 0 0 lineto
-0.07 -0.0175 lineto
-0.07 0.0175 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
.01 w
.5379 .93266 m
.47307 .9032 L
.38564 .87183 L
.28639 .84538 L
.18096 .82549 L
.09818 .81329 L
.08306 .81086 L
.06886 .80821 L
.05744 .8056 L
.04827 .80291 L
.04046 .79985 L
.03695 .79806 L
.03365 .79599 L
.03067 .7936 L
.02835 .79113 L
.02669 .78875 L
.02593 .78732 L
.02532 .78594 L
.02484 .78459 L
.02443 .78307 L
.02414 .78158 L
.02395 .78017 L
.02385 .77885 L
.02381 .77737 L
.02385 .77576 L
.02395 .77422 L
.02416 .77236 L
.02443 .77053 L
.02517 .76696 L
.02624 .76288 L
.02774 .75816 L
.04662 .71395 L
.05979 .68357 L
.07397 .64583 L
.08 .62676 L
.08573 .60577 L
.0903 .58559 L
.09382 .56629 L
.09641 .54777 L
.09754 .53729 L
.09835 .5277 L
.09902 .51713 L
.09928 .51115 L
.09945 .50562 L
.09955 .50079 L
.09959 .49546 L
.09957 .48991 L
.09949 .48471 L
.09934 .47929 L
.09923 .47626 L
Mistroke
.09911 .47352 L
.09851 .46318 L
.09807 .45739 L
.09751 .45117 L
.09629 .43994 L
.09313 .41828 L
.0894 .39883 L
.08041 .36333 L
.06897 .3287 L
.04359 .26807 L
.03426 .24715 L
.03029 .2375 L
.02699 .22828 L
.02572 .22396 L
.02517 .22177 L
.02468 .21949 L
.02432 .21747 L
.02407 .21569 L
.02391 .21403 L
.02382 .21234 L
.02382 .21078 L
.0239 .20918 L
.02405 .20771 L
.02427 .20641 L
.02461 .20494 L
.02509 .2034 L
.02625 .20076 L
.02704 .1994 L
.02789 .19818 L
.0302 .19556 L
.03298 .19321 L
.03655 .19088 L
.04457 .18713 L
.05369 .18413 L
.06453 .18142 L
.07791 .17876 L
.10654 .17416 L
.19012 .16176 L
.28369 .14394 L
.37422 .12038 L
.46483 .08885 L
.53091 .05952 L
.58038 .03395 L
.58893 .02963 L
.59572 .02654 L
.60085 .02465 L
.6021 .02429 L
.60336 .02399 L
.60439 .02379 L
.60546 .02363 L
Mistroke
.60652 .02355 L
.60746 .02354 L
.60827 .02359 L
.60911 .02371 L
.60997 .02392 L
.61084 .02423 L
.61161 .02461 L
.61227 .02503 L
.61347 .02604 L
.61465 .02743 L
.61565 .02903 L
.6165 .03075 L
.61821 .03539 L
.61993 .04181 L
.62368 .05895 L
.62897 .08114 L
.63655 .1064 L
.64954 .13973 L
.66603 .17301 L
.71288 .24351 L
.7702 .30748 L
.90302 .4176 L
.9295 .43756 L
.95186 .45598 L
.96559 .47005 L
.96841 .47371 L
.97095 .47754 L
.97288 .48107 L
.97428 .48428 L
.97488 .48603 L
.97541 .48794 L
.97581 .48986 L
.97597 .4909 L
.97608 .49188 L
.97619 .49367 L
.97618 .49531 L
.97604 .49721 L
.97579 .499 L
.97545 .50062 L
.97499 .50233 L
.97388 .50544 L
.9721 .50918 L
.97006 .5126 L
.96397 .52059 L
.95519 .52966 L
.93397 .54767 L
.8774 .59026 L
.80339 .65022 L
.73442 .7192 L
.6836 .78624 L
Mistroke
.64791 .85273 L
.63562 .8851 L
.62793 .91158 L
.62 .94661 L
.61828 .95309 L
.61728 .95607 L
.61625 .95851 L
.61522 .96042 L
.61464 .9613 L
.61398 .96214 L
.61333 .96282 L
.61271 .96336 L
.61211 .9638 L
.61141 .96421 L
.61063 .96457 L
.60975 .96486 L
.60889 .96504 L
.60804 .96514 L
.60751 .96517 L
.60699 .96518 L
.60597 .96513 L
.60481 .96499 L
.60412 .96488 L
.60346 .96475 L
.60122 .96417 L
.59849 .96326 L
.5921 .96059 L
.55008 .93885 L
.5379 .93266 L
Mfstroke
0 0 1 r
.5 Mabswid
.5379 .93266 m
.34188 .83465 L
s
% Start of user PostScript
0.4 2. -0.494427 1.55279 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.5379 .93266 Mdot
0 0 1 r
.5 Mabswid
.06048 .68191 m
.14338 .47904 L
s
% Start of user PostScript
-1.77851 0.855798 -1.4002 -0.0698803 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.06048 .68191 Mdot
0 0 1 r
.5 Mabswid
.12169 .17197 m
.33863 .14089 L
s
% Start of user PostScript
-1.49918 -1.47109 -0.509285 -1.61291 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.12169 .17197 Mdot
0 0 1 r
.5 Mabswid
.63695 .10756 m
.70775 .31496 L
s
% Start of user PostScript
0.851964 -1.76498 1.17507 -0.818618 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.63695 .10756 Mdot
0 0 1 r
.5 Mabswid
.89418 .57769 m
.71839 .70857 L
s
% Start of user PostScript
2.02572 0.38027 1.22362 0.97746 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.89418 .57769 Mdot
0 0 1 r
.5 Mabswid
.5379 .93266 m
.34188 .83465 L
s
% Start of user PostScript
0.4 2. -0.494427 1.55279 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.5379 .93266 Mdot
0 1 0 r
.5 Mabswid
.5379 .93266 m
.6359 .73664 L
s
% Start of user PostScript
0.4 2. 0.847214 1.10557 MAarrowhead1
% End of user PostScript
.06048 .68191 m
.26334 .76481 L
s
% Start of user PostScript
-1.77851 0.855798 -0.852828 1.23411 MAarrowhead1
% End of user PostScript
.12169 .17197 m
.15277 .3889 L
s
% Start of user PostScript
-1.49918 -1.47109 -1.35736 -0.481195 MAarrowhead1
% End of user PostScript
.63695 .10756 m
.42955 .17837 L
s
% Start of user PostScript
0.851964 -1.76498 -0.0943988 -1.44187 MAarrowhead1
% End of user PostScript
.89418 .57769 m
.7633 .40191 L
s
% Start of user PostScript
2.02572 0.38027 1.42853 -0.42183 MAarrowhead1
% End of user PostScript
.5379 .93266 m
.6359 .73664 L
s
% Start of user PostScript
0.4 2. 0.847214 1.10557 MAarrowhead1
% End of user PostScript
1 0 0 r
.22416 .83278 m
.20176 .82887 L
s
% Start of user PostScript
-1.03159 1.54425 -1.13382 1.52641 MAarrowhead2
% End of user PostScript
.08825 .39359 m
.0836 .37472 L
s
% Start of user PostScript
-1.65177 -0.459815 -1.67299 -0.545899 MAarrowhead2
% End of user PostScript
.4105 .10883 m
.43201 .10132 L
s
% Start of user PostScript
-0.181317 -1.75921 -0.0831752 -1.79344 MAarrowhead2
% End of user PostScript
.81368 .34748 m
.8304 .36155 L
s
% Start of user PostScript
1.65841 -0.670217 1.7347 -0.605987 MAarrowhead2
% End of user PostScript
.6725 .80428 m
.66331 .82073 L
s
% Start of user PostScript
1.01421 1.41421 0.972248 1.48927 MAarrowhead2
% End of user PostScript
0 g
gsave
.58173 .62585 -68.0625 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(D) show
73.125 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.77896 .75734 -66.75 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.500 17.813 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .98872 L
0 .98872 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 284.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001Zb000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000
oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?oo
o`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?oo
o`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3o
ool00`000000oooo0?ooo`0h0?ooo`H0o`00^@3oool00;H0oooo00<000000?ooo`3oool0=@3oool:
0?l00;P0oooo002f0?ooo`030000003oool0oooo03<0oooo3@3o002g0?ooo`00]P3oool00`000000
oooo0?ooo`0b0?ooo`L0o`00103oool40?l00;H0oooo002f0?ooo`030000003oool0oooo0300oooo
1P3o00080?ooo`@0o`00]@3oool00;H0oooo00<000000?ooo`3oool0;P3oool60?l000/0oooo0`3o
002e0?ooo`00]P3oool00`000000oooo0?ooo`0/0?ooo`L0o`00303oool30?l00;D0oooo002f0?oo
o`030000003oool0oooo02X0oooo1`3o000>0?ooo`<0o`00]@3oool00;H0oooo00<000000?ooo`3o
ool0:03oool70?l00100oooo0`3o002e0?ooo`00]P3oool00`000000oooo0?ooo`0V0?ooo`L0o`00
4P3oool30?l00;D0oooo002f0?ooo`030000003oool0oooo02@0oooo1`3o000D0?ooo`@0o`00]03o
ool00;H0oooo00<000000?ooo`3oool08P3oool70?l001L0oooo0`3o002d0?ooo`00]P3oool00`00
0000oooo0?ooo`0P0?ooo`L0o`006@3oool30?l00;@0oooo002f0?ooo`030000003oool0oooo01h0
oooo1`3o000K0?ooo`@0o`00/`3oool00;H0oooo00<000000?ooo`3oool0703oool70?l001h0oooo
0`3o002c0?ooo`00]P3oool00`000000oooo0?ooo`0I0?ooo`P0o`00803oool30?l00;<0oooo002f
0?ooo`030000003oool0oooo01L0oooo203o000R0?ooo`<0o`00/`3oool00;H0oooo00<000000?oo
o`3oool05@3oool80?l002@0oooo103o002b0?ooo`00]P3oool00`000000oooo0?ooo`0B0?ooo`P0
o`00:03oool30?l00;80oooo002f0?ooo`030000003oool0oooo0100oooo203o000Z0?ooo`<0o`00
/P3oool00;H0oooo00<000000?ooo`3oool03P3oool80?l002`0oooo0`3o002b0?ooo`00]P3oool0
0`000000oooo0?ooo`0;0?ooo`P0o`00;`3oool40?l00;40oooo002f0?ooo`030000003oool0oooo
00T0oooo203o000b0?ooo`<0o`00/@3oool00;H0oooo00<000000?ooo`3oool01`3oool80?l003@0
oooo0`3o002a0?ooo`00]P3oool00`000000oooo0?ooo`040?ooo`P0o`00=`3oool30?l00;40oooo
002f0?ooo`030000003oool0oooo0080oooo203o000i0?ooo`@0o`00/03oool00;H0oooo00<00000
0?ooo`3o0000203o000l0?ooo`<0o`00/03oool00;D0oooo2@3o000o0?ooo`<0o`00/03oool00;<0
oooo2@3o00110?ooo`@0o`00[`3oool00;00oooo2@3o00150?ooo`<0o`00[`3oool00:d0oooo2@3o
00000`000000oooo0?ooo`150?ooo`<0o`00[`3oool00:X0oooo2P3o00020?ooo`030000003oool0
oooo04D0oooo103o002^0?ooo`00XP3oool?0?l000D0oooo00<000000?ooo`3oool0A@3oool40?l0
0:h0oooo002H0?oooaH0o`00203oool00`000000oooo0?ooo`140?ooo`D0o`00[P3oool009<0oooo
6@3o000:0?ooo`030000003oool0oooo04@0oooo0P3o0002003o0080o`00[@3oool009<0oooo5`3o
000<0?ooo`030000003oool0oooo04<0oooo0`00o`040?l00:d0oooo002D0?oooaD0o`003@3oool0
0`000000oooo0?ooo`100?ooo`<00?l00P3oool30?l000030000o`3o0000oooo0:`0oooo002D0?oo
oa@0o`003P3oool00`000000oooo0?ooo`0m0?ooo`<00?l01`3oool0103o0000003o0?l0003o002/
0?ooo`00U@3ooolA0?l00100oooo00<000000?ooo`3oool0>P3oool3003o00/0oooo00<0003o0?l0
003o0000[03oool009<0oooo4P3o000A0?ooo`030000003oool0oooo03L0oooo0`00o`0>0?ooo`03
0?l000000?l0o`000:`0oooo002?0?oooa@0o`004`3oool00`000000oooo0?ooo`0d0?ooo`<00?l0
4@3oool0103o0000003o0?l0003o002[0?ooo`00R`3ooolG0?l001@0oooo00<000000?ooo`3oool0
<P3oool2003o01D0oooo00<0003o0?l0003o0000Z`3oool008L0oooo303o00030?ooo`X0o`005P3o
ool00`000000oooo0?ooo`0_0?ooo`<00?l05`3oool0103o0000003o0?l0003o002Z0?ooo`00P`3o
ool<0?l000L0oooo2@3o000G0?ooo`030000003oool0oooo02`0oooo0`00o`0K0?ooo`030000o`3o
0000o`000:X0oooo001o0?ooo``0o`00303oool70?l001P0oooo00<000000?ooo`3oool0:@3oool3
003o01h0oooo00<0003o0?l0003o0000ZP3oool007H0oooo1P000?l;0?l00100oooo1@3o000J0?oo
o`030000003oool0oooo02H0oooo0`00o`0Q0?ooo`040?l000000?l0o`000?l00:T0oooo001f0?oo
oa00003o4P3oool30?l001/0oooo00<000000?ooo`3oool08`3oool3003o02D0oooo00<0003o0?l0
003o0000Z@3oool007<0oooo0`3o000F0000o``0oooo00<0o`000?ooo`3oool06`3oool00`000000
oooo0?ooo`0P0?ooo`<00?l0:03oool010000?l0o`000?l0003o002X0?ooo`00KP3oool90?l001<0
003o;03oool00`000000oooo0?ooo`0M0?ooo`<00?l0;03oool00`000?l0o`000?l0002X0?ooo`00
J03oool?0?l00100003o;`3oool00`000000oooo0?ooo`0J0?ooo`<00?l0;`3oool010000?l0o`00
0?l0003o002W0?ooo`00H`3oool?0?l001<0003o<@3oool00`000000oooo0?ooo`0G0?ooo`<00?l0
<`3oool00`000?l0o`000?l0002W0?ooo`00GP3oool=0?l000L0003o1@3oool;0000oc@0oooo00<0
00000?ooo`3oool01P3oool00`00o`00oooo0?ooo`0;0?ooo`<00?l0=P3oool010000?l0o`000?l0
003o002V0?ooo`00F03oool<0?l000L0003o3@3oool70000ocL0oooo00<000000?ooo`3oool0103o
ool3003o00X0oooo0`00o`0i0?ooo`040000o`3o0000o`000?l00:H0oooo001C0?ooo`X0o`001`00
0?lD0?ooo`D0003o>@3oool00`000000oooo0?ooo`030?ooo`D00?l01P3oool3003o03d0oooo00<0
003o0?l0003o0000YP3oool004d0oooo2@3o00070000o`030?l0003oool0oooo01P0oooo0P000?ll
0?ooo`040000003oool0oooo0?ooo`L00?l00`3oool3003o0400oooo00@0003o0?l0003o0000o`00
Y@3oool004L0oooo203o00070000o`80o`00GP3oool00`000000oooo0?ooo`08003o00030?ooo`00
o`000?l004<0oooo00@0003o0?l0003o0000o`00Y@3oool00400oooo1`3o00080000o`@0o`00H`3o
ool00`0000000?l0003o0009003o04H0oooo00@0003o0?l0003o0000o`00Y03oool003@0oooo0`3o
00020?ooo`L0o`001`000?l60?l006P0oooo3@00o`160?ooo`040000o`3o0000o`000?l00:@0oooo
000c0?ooo`H0o`001`000?l70?l006d0oooo3P00o`160?ooo`030000o`3o0000o`000080o`00X`3o
ool002d0oooo203o00001000o`00o`000?l000000?l70?l00780oooo4@00o`160?ooo`040000o`3o
0000o`000?l00:<0oooo000W0?ooo`h0o`0000@00?l00?l0003o0000o`00N03ooolB003o04H0oooo
00<0003o0?l0003o00000P3o002R0?ooo`008P3ooolA0?l000040?ooo`3o00000?l00?l007P0oooo
3`00o`1;0?ooo`030000o`3oool0o`0000<0o`00X@3oool001d0oooo403o00080?ooo`03003o003o
ool0oooo07H0oooo1P00o`020?ooo`030000003oool0oooo0540oooo00<0003o0?ooo`3o00000P3o
002Q0?ooo`00603oool?0?l000l0oooo00<00?l00?ooo`3oool0O@3oool00`000000oooo0?ooo`1A
0?ooo`030000o`3oool0o`0000<0o`00X03oool001D0oooo3@3o000D0?ooo`03003o003oool0oooo
07d0oooo00<000000?ooo`3oool0D@3oool00`000?l0oooo0?ooo`040?l009l0oooo000C0?ooo`X0
o`006@3oool00`00o`00oooo0?ooo`1m0?ooo`030000003oool0oooo0580oooo00<0003o0?ooo`3o
ool00`3o002O0?ooo`004@3oool80?l001d0oooo00<00?l00?ooo`3oool0O@3oool00`000000oooo
0?ooo`1B0?ooo`030000o`3oool0oooo00@0o`00WP3oool00100oooo1P3o000P0?ooo`03003o003o
ool0oooo07d0oooo00<000000?ooo`3oool0DP3oool010000?l0oooo0?ooo`3oool40?l009d0oooo
000?0?ooo`D0o`008P3oool00`00o`00oooo0?ooo`1m0?ooo`030000003oool0oooo05<0oooo00@0
003o0?ooo`3oool0oooo0`3o002M0?ooo`003`3oool30?l002@0oooo00<00?l00?ooo`3oool0O@3o
ool00`000000oooo0?ooo`1C0?ooo`040000o`3oool0oooo0?ooo`@0o`00W03oool000h0oooo103o
000U0?ooo`03003o003oool0oooo07`0oooo00<000000?ooo`3oool0D`3oool00`000?l0oooo0?oo
o`020?ooo`@0o`00V`3oool000h0oooo0`3o000V0?ooo`03003o003oool0oooo07`0oooo00<00000
0?ooo`3oool0E03oool00`000?l0oooo0?ooo`020?ooo`<0o`00V`3oool000h0oooo0`3o000V0?oo
o`03003o003oool0oooo07`0oooo00<000000?ooo`3oool0E03oool00`000?l0oooo0?ooo`020?oo
o`@0o`00VP3oool000h0oooo0`3o000V0?ooo`03003o003oool0oooo07`0oooo00<000000?ooo`3o
ool0E03oool00`000?l0oooo0?ooo`030?ooo`@0o`00V@3oool000h0oooo0`3o000V0?ooo`03003o
003oool0oooo07`0oooo00<000000?ooo`3oool0E@3oool00`000?l0oooo0?ooo`030?ooo`@0o`00
V03oool000h0oooo0`3o000V0?ooo`03003o003oool0oooo07`0oooo00<000000?ooo`3oool0E@3o
ool00`000?l0oooo0?ooo`040?ooo`<0o`00V03oool000h0oooo0`3o000V0?ooo`03003o003oool0
oooo07`0oooo00<000000?ooo`3oool0EP3oool00`000?l0oooo0?ooo`030?ooo`@0o`00U`3oool0
00h0oooo0`3o000W0?ooo`03003o003oool0oooo07/0oooo00<000000?ooo`3oool0EP3oool00`00
0?l0oooo0?ooo`040?ooo`@0o`00UP3oool000h0oooo0`3o000W0?ooo`03003o003oool0oooo07/0
oooo00<000000?ooo`3oool0EP3oool00`000?l0oooo0?ooo`050?ooo`<0o`00UP3oool000h0oooo
0`3o000W0?ooo`03003o003oool0oooo07/0oooo00<000000?ooo`3oool0E`3oool00`000?l0oooo
0?ooo`040?ooo`@0o`00U@3oool000h0oooo103o000V0?ooo`03003o003oool0oooo07/0oooo00<0
00000?ooo`3oool0E`3oool00`000?l0oooo0?ooo`050?ooo`@0o`00U03oool000l0oooo0`3o000V
0?ooo`03003o003oool0oooo07/0oooo00<000000?ooo`3oool0E`3oool00`000?l0oooo0?ooo`06
0?ooo`<0o`00U03oool000l0oooo0`3o000V0?ooo`03003o003oool0oooo07/0oooo00<000000?oo
o`3oool0F03oool00`000?l0oooo0?ooo`050?ooo`@0o`00T`3oool000l0oooo103o000U0?ooo`03
003o003oool0oooo07/0oooo00<000000?ooo`3oool0F03oool00`000?l0oooo0?ooo`060?ooo`@0
o`00TP3oool00100oooo0`3o000V0?ooo`03003o003oool0oooo07X0oooo00<000000?ooo`3oool0
F03oool00`000?l0oooo0?ooo`070?ooo`<0o`00TP3oool00100oooo0`3o000V0?ooo`03003o003o
ool0oooo07X0oooo00<000000?ooo`3oool0F@3oool00`000?l0oooo0?ooo`060?ooo`@0o`00T@3o
ool00100oooo103o000U0?ooo`03003o003oool0oooo07X0oooo00<000000?ooo`3oool0F@3oool0
0`000?l0oooo0?ooo`070?ooo`@0o`00T03oool00140oooo0`3o000U0?ooo`03003o003oool0oooo
07X0oooo00<000000?ooo`3oool0F@3oool00`000?l0oooo0?ooo`080?ooo`<0o`00T03oool00140
oooo103o000T0?ooo`03003o003oool0oooo07X0oooo00<000000?ooo`3oool0FP3oool00`000?l0
oooo0?ooo`070?ooo`@0o`00S`3oool00180oooo0`3o000T0?ooo`03003o003oool0oooo07X0oooo
00<000000?ooo`3oool0FP3oool00`000?l0oooo0?ooo`080?ooo`@0o`00SP3oool00180oooo103o
000S0?ooo`03003o003oool0oooo07X0oooo00<000000?ooo`3oool0FP3oool00`000?l0oooo0?oo
o`090?ooo`@0o`00S@3oool001<0oooo0`3o000T0?ooo`03003o003oool0oooo07T0oooo00<00000
0?ooo`3oool0F`3oool00`000?l0oooo0?ooo`090?ooo`@0o`00S03oool001<0oooo0`3o000T0?oo
o`03003o003oool0oooo07T0oooo00<000000?ooo`3oool0F`3oool00`000?l0oooo0?ooo`0:0?oo
o`@0o`00R`3oool001<0oooo103o000S0?ooo`03003o003oool0oooo07T0oooo00<000000?ooo`3o
ool0F`3oool00`000?l0oooo0?ooo`0;0?ooo`@0o`00RP3oool001@0oooo0`3o000S0?ooo`03003o
003oool0oooo07T0oooo00<000000?ooo`3oool0G03oool00`000?l0oooo0?ooo`0;0?ooo`@0o`00
R@3oool001@0oooo0`3o000S0?ooo`03003o003oool0oooo07T0oooo00<000000?ooo`3oool0G03o
ool010000?l0oooo0?ooo`3oool20000o`T0oooo0`3o00290?ooo`00503oool40?l00280oooo00<0
0?l00?ooo`3oool0N@3oool00`000000oooo0?ooo`1L0?ooo`H0003o2P3oool30?l008P0oooo000E
0?ooo`<0o`008P3oool00`00o`00oooo0?ooo`1i0?ooo`030000003oool0oooo05X0oooo20000?l:
0?ooo`@0o`00Q`3oool001D0oooo103o000R0?ooo`03003o003oool0oooo07P0oooo00<000000?oo
o`3oool0F03oool:0000o`/0oooo103o00260?ooo`005P3oool30?l00280oooo00<00?l00?ooo`3o
ool0N03oool00`000000oooo0?ooo`1I0?ooo`T0003o303oool40?l008D0oooo000F0?ooo`<0o`00
8P3oool00`00o`00oooo0?ooo`1h0?ooo`030000003oool0oooo05T0oooo2@000?l=0?ooo`@0o`00
Q03oool001H0oooo103o000Q0?ooo`03003o003oool0oooo07P0oooo00<000000?ooo`3oool0FP3o
ool90000o`d0oooo103o00230?ooo`005`3oool30?l00240oooo00<00?l00?ooo`3oool0N03oool0
0`000000oooo0?ooo`1K0?ooo`P0003o3P3oool40?l00880oooo000G0?ooo`@0o`00803oool00`00
o`00oooo0?ooo`1h0?ooo`030000003oool0oooo05/0oooo20000?l?0?ooo`<0o`00PP3oool001P0
oooo0`3o000P0?ooo`03003o003oool0oooo07P0oooo00<000000?ooo`3oool0G03oool70000oa00
oooo0`3o00210?ooo`00603oool40?l001l0oooo00<00?l00?ooo`3oool0N03oool00`000000oooo
0?ooo`1M0?ooo`H0003o403oool40?l00800oooo000I0?ooo`<0o`00803oool00`00o`00oooo0?oo
o`1g0?ooo`030000003oool0oooo05d0oooo1P000?lA0?ooo`@0o`00O`3oool001T0oooo0`3o000P
0?ooo`03003o003oool0oooo07L0oooo00<000000?ooo`3oool0GP3oool50000oa80oooo103o001n
0?ooo`006@3oool40?l001l0oooo00<00?l00?ooo`3oool0M`3oool00`000000oooo0?ooo`1N0?oo
o`D0003o4`3oool40?l007d0oooo000J0?ooo`<0o`007`3oool00`00o`00oooo0?ooo`1g0?ooo`03
0000003oool0oooo05l0oooo10000?lD0?ooo`@0o`00O03oool001X0oooo103o000N0?ooo`03003o
003oool0oooo07L0oooo00<000000?ooo`3oool0H03oool30000oaD0oooo103o001k0?ooo`006`3o
ool30?l001h0oooo00<00?l00?ooo`3oool0M`3oool00`000000oooo0?ooo`1P0?ooo`@0003o5@3o
ool30?l000H0oooo00<0o`000?ooo`3oool0LP3oool001/0oooo0`3o000N0?ooo`03003o003oool0
oooo07L0oooo00<000000?ooo`3oool0H@3oool30000oaH0oooo103o00030?ooo`<0o`00L`3oool0
01/0oooo103o000N0?ooo`03003o003oool0oooo07H0oooo00<000000?ooo`3oool0HP3oool20000
oaH0oooo1@3o00000`3oool0o`000?l000020?l007<0oooo000L0?ooo`<0o`007P3oool00`00o`00
oooo0?ooo`1f0?ooo`030000003oool0oooo0680oooo0P000?lH0?ooo`T0o`00LP3oool001`0oooo
103o000M0?ooo`03003o003oool0oooo07H0oooo00<000000?ooo`3oool0H`3oool00`000?l0oooo
0?ooo`0G0?ooo`T0o`00L@3oool001d0oooo0`3o000M0?ooo`03003o003oool0oooo07H0oooo00<0
00000?ooo`3oool0O@3oool:0?l00700oooo000M0?ooo`@0o`00703oool00`00o`00oooo0?ooo`1f
0?ooo`030000003oool0oooo07d0oooo2P3o001`0?ooo`007P3oool30?l001`0oooo00<00?l00?oo
o`3oool0MP3oool00`000000oooo0?ooo`1l0?ooo``0o`00K`3oool001h0oooo0`3o000L0?ooo`03
003o003oool0oooo07H0oooo00<000000?ooo`3oool0N`3oool>0?l006h0oooo000N0?ooo`@0o`00
703oool00`00o`00oooo0?ooo`1e0?ooo`030000003oool0oooo07X0oooo403o001]0?ooo`007`3o
ool30?l001`0oooo00<00?l00?ooo`3oool0M@3oool00`000000oooo0?ooo`1i0?oooa40o`00K@3o
ool001l0oooo103o000K0?ooo`03003o003oool0oooo07D0oooo00<000000?ooo`3oool0NP3ooolA
0?l006`0oooo000P0?ooo`<0o`006`3oool00`00o`00oooo0?ooo`1e0?ooo`030000003oool0oooo
07`0oooo403o001[0?ooo`00803oool30?l001/0oooo00<00?l00?ooo`3oool00`00o`1b0?ooo`03
0000003oool0oooo07h0oooo3`3o001Z0?ooo`00803oool40?l001T0oooo1`00o`1b0?ooo`030000
003oool0oooo0800oooo3@3o001Z0?ooo`008@3oool30?l001H0oooo2P00o`1b0?ooo`030000003o
ool0oooo0880oooo3@3o001X0?ooo`008@3oool30?l001H0oooo2P00o`1b0?ooo`030000003oool0
oooo08@0oooo303o001W0?ooo`008@3oool40?l001H0oooo2@00o`1b0?ooo`030000003oool0oooo
08H0oooo2`3o001V0?ooo`008P3oool30?l001H0oooo2000o`1c0?ooo`030000003oool0oooo08P0
oooo2P3o001U0?ooo`008P3oool40?l001H0oooo1`00o`1c0?ooo`030000003oool0oooo08X0oooo
2@3o001T0?ooo`008`3oool30?l001H0oooo1`00o`1c0?ooo`030000003oool0oooo08`0oooo2@3o
001R0?ooo`008`3oool30?l001H0oooo1`00o`1c0?ooo`030000003oool0oooo08h0oooo203o001Q
0?ooo`008`3oool40?l001H0oooo1P00o`1c0?ooo`030000003oool0oooo0900oooo1`3o001P0?oo
o`00903oool30?l001H0oooo1P00o`1c0?ooo`030000003oool0oooo0980oooo1P3o001O0?ooo`00
903oool30?l001H0oooo1P00o`1c0?ooo`030000003oool0oooo09D0oooo103o001N0?ooo`00903o
ool30?l001L0oooo1@00o`1c0?ooo`030000003oool0oooo09H0oooo1@3o001L0?ooo`009@3oool3
0?l001H0oooo1@00o`1c0?ooo`030000003oool0oooo09L0oooo1@3o001K0?ooo`009@3oool30?l0
01L0oooo1000o`1c0?ooo`030000003oool0oooo09T0oooo103o001J0?ooo`009@3oool30?l001L0
oooo0`00o`1d0?ooo`030000003oool0oooo09X0oooo103o001I0?ooo`009@3oool30?l001L0oooo
0`00o`1d0?ooo`030000003oool0oooo09/0oooo103o001H0?ooo`009@3oool30?l001P0oooo0P00
o`1d0?ooo`030000003oool0oooo09`0oooo1@3o001F0?ooo`009P3oool30?l001L0oooo0P00o`1d
0?ooo`030000003oool0oooo09d0oooo1@3o001E0?ooo`009P3oool30?l001P0oooo00<00?l00?oo
o`3oool0LP3oool00`000000oooo0?ooo`2O0?ooo`@0o`00E03oool002H0oooo103o000G0?ooo`03
003o003oool0oooo0780oooo00<000000?ooo`3oool0X03oool40?l005<0oooo000V0?ooo`@0o`00
S03oool00`000000oooo0?ooo`2Q0?ooo`@0o`00DP3oool002H0oooo1@3o002;0?ooo`030000003o
ool0oooo0:80oooo1@3o001@0?ooo`009P3oool50?l008/0oooo00<000000?ooo`3oool0X`3oool5
0?l004l0oooo000V0?ooo`H0o`00RP3oool00`000000oooo0?ooo`2U0?ooo`@0o`00CP3oool002H0
oooo1P3o002:0?ooo`030000003oool0oooo0:H0oooo103o001=0?ooo`009P3oool70?l008T0oooo
00<000000?ooo`3oool0N@3oool00`00o`00oooo0?ooo`0[0?ooo`@0o`00C03oool002H0oooo1`3o
00290?ooo`030000003oool0oooo07T0oooo0P00o`0]0?ooo`D0o`00BP3oool002H0oooo203o0028
0?ooo`030000003oool0oooo07X0oooo0`00o`0/0?ooo`D0o`00B@3oool002H0oooo203o00280?oo
o`030000003oool0oooo07X0oooo1000o`0]0?ooo`@0o`00B03oool002H0oooo2@3o00270?ooo`03
0000003oool0oooo07/0oooo1000o`0]0?ooo`@0o`00A`3oool002H0oooo2@3o00270?ooo`030000
003oool0oooo07/0oooo1@00o`0]0?ooo`@0o`00AP3oool002H0oooo2P3o00260?ooo`030000003o
ool0oooo07/0oooo1`00o`0/0?ooo`D0o`00A03oool002H0oooo2P3o00260?ooo`030000003oool0
oooo07`0oooo1`00o`0/0?ooo`D0o`00@`3oool002H0oooo2`3o00250?ooo`030000003oool0oooo
07`0oooo2000o`0]0?ooo`@0o`00@P3oool002H0oooo2`3o00250?ooo`030000003oool0oooo07`0
oooo2@00o`0]0?ooo`@0o`00@@3oool002H0oooo303o00240?ooo`030000003oool0oooo07d0oooo
2P00o`0/0?ooo`D0o`00?`3oool002H0oooo303o00240?ooo`030000003oool0oooo07d0oooo2`00
o`0/0?ooo`D0o`00?P3oool002H0oooo3@3o00230?ooo`030000003oool0oooo07h0oooo2`00o`0]
0?ooo`@0o`00?@3oool002H0oooo3@3o00230?ooo`030000003oool0oooo07h0oooo2P00o`0_0?oo
o`D0o`00>`3oool002H0oooo3P3o00220?ooo`030000003oool0oooo07h0oooo2@00o`0a0?ooo`D0
o`00>P3oool002H0oooo2`3o00250?ooo`030000003oool0oooo07l0oooo1P00o`0d0?ooo`D0o`00
>@3oool002H0oooo1`3o00290?ooo`030000003oool0oooo07l0oooo1@00o`000`3oool00?l00?oo
o`0d0?ooo`@0o`00>03oool002H0oooo0`3o00020?ooo`<0o`00R03oool00`000000oooo0?ooo`20
0?ooo`<00?l00`3oool00`00o`00oooo0?ooo`0c0?ooo`D0o`00=P3oool002/0oooo0`3o00280?oo
o`030000003oool0oooo0800oooo00<00?l00?ooo`3oool00`3oool00`00o`00oooo0?ooo`0d0?oo
o`D0o`00=@3oool002/0oooo0`3o00280?ooo`030000003oool0oooo08L0oooo00<00?l00?ooo`3o
ool0=03oool50?l003@0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`280?ooo`03003o
003oool0oooo03D0oooo103o000c0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0R@3o
ool00`00o`00oooo0?ooo`0e0?ooo`@0o`00<P3oool002/0oooo0`3o00280?ooo`030000003oool0
oooo08T0oooo00<00?l00?ooo`3oool0=P3oool40?l00340oooo000[0?ooo`<0o`00R03oool00`00
0000oooo0?ooo`2:0?ooo`03003o003oool0oooo03H0oooo103o000`0?ooo`00:`3oool30?l008P0
oooo00<000000?ooo`3oool0R`3oool00`00o`00oooo0?ooo`0f0?ooo`@0o`00;`3oool002/0oooo
0`3o00280?ooo`030000003oool0oooo08/0oooo00<00?l00?ooo`3oool0=`3oool40?l002h0oooo
000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`2<0?ooo`03003o003oool0oooo03L0oooo103o
000]0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0S@3oool00`00o`00oooo0?ooo`0g
0?ooo`@0o`00;03oool002/0oooo0`3o00280?ooo`030000003oool0oooo08h0oooo00<00?l00?oo
o`3oool0=`3oool30?l002`0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`2>0?ooo`03
003o003oool0oooo03L0oooo103o000[0?ooo`00:`3oool30?l00100oooo00<0003o0?ooo`3oool0
M@3oool00`000000oooo0?ooo`2?0?ooo`03003o003oool0oooo03L0oooo103o000F0?ooo`060=BK
00000000000009_Do`3oool0j[Yb0`0000000`00L[X0j_oo0?ooo`080?ooo`00:`3oool30?l000l0
oooo0P000?mg0?ooo`030000003oool0oooo0900oooo00<00?l00?ooo`3oool0=`3oool30?l001L0
oooo00<0e9/009_Do`3oool00P3oool00`3Z^W800000002Ke00;0?ooo`00:`3oool30?l000h0oooo
0`000?mg0?ooo`030000003oool0oooo0940oooo00<00?l00?ooo`3oool0=P3oool40?l001H0oooo
00P0oooZ0;YbV`3Dool0oooo0?oZ^P1b000007:j0>[oo`/0oooo000[0?ooo`<0o`003P3oool30000
ogL0oooo00<000000?ooo`3oool0T@3oool00`00o`00oooo0?ooo`0g0?ooo`<0o`005`3oool01P3o
j[X0LW:j0>[ojP2jLP00001b0;[Zo``0oooo000[0?ooo`<0o`003@3oool30000ogP0oooo00<00000
0?ooo`3oool0TP3oool00`00o`00oooo0?ooo`0f0?ooo`<0o`00603oool0103oe9/000000000002K
e?l=0?ooo`00:`3oool30?l000`0oooo10000?mh0?ooo`030000003oool0oooo09<0oooo00<00?l0
0?ooo`3oool0=@3oool30?l001P0oooo00<0onZj07800000Vm@03P3oool000D0oooo9P0000030?l0
00/000001@000?oo00000100000000<00?l0000000000000=00000030?l000T000003P3oool01@3o
om@0V`000000000009/0e?oo00d0oooo000[0?ooo`<0o`002`3oool50000ogP0oooo00<000000?oo
o`3oool0U03oool00`00o`00oooo0?ooo`0d0?ooo`<0o`005`3oool01P3DV`00000009_Do`3oj[X0
LW:j0>[oo``0oooo000[0?ooo`<0o`002P3oool60000ogP0oooo00<000000?ooo`3oool0U@3oool0
0`00o`00oooo0?ooo`0c0?ooo`<0o`005P3oool01`3Z^W800000001b^P3Zool0oooo0>ZjLP00Vm@0
303oool002/0oooo0`3o00090?ooo`L0003oN03oool00`000000oooo0?ooo`2F0?ooo`03003o003o
ool0oooo0340oooo103o000E0?ooo`0:0=BK0000000000000000001b^^X0onZj07800000000007:j
0>[oo`X0oooo000[0?ooo`<0o`00203oool70000ogT0oooo00<000000?ooo`3oool0U`3oool00`00
o`00oooo0?ooo`0`0?ooo`<0o`00:P3oool002/0oooo0`3o00080?ooo`L0003oN@3oool00`000000
oooo0?ooo`2G0?ooo`03003o003oool0oooo0300oooo0`3o000Z0?ooo`00:`3oool30?l000L0oooo
20000?mi0?ooo`030000003oool0oooo09P0oooo00<00?l00?ooo`3oool0;P3oool40?l002X0oooo
000[0?ooo`<0o`001P3oool90000ogT0oooo00<000000?ooo`3oool0V@3oool00`00o`00oooo0?oo
o`0]0?ooo`<0o`00:`3oool002/0oooo0`3o00050?ooo`X0003oN@3oool00`000000oooo0?ooo`2J
0?ooo`03003o003oool0oooo02/0oooo103o000[0?ooo`00:`3oool30?l000D0oooo2P000?mi0?oo
o`030000003oool0oooo09X0oooo00<00?l00?ooo`3oool0:P3oool40?l002`0oooo000[0?ooo`<0
o`00103oool;0000ogT0oooo00<000000?ooo`3oool0V`3oool00`00o`00oooo0?ooo`0X0?ooo`@0
o`00;@3oool002/0oooo0`3o00060?ooo`P0003oNP3oool00`000000oooo0?ooo`2L0?ooo`03003o
003oool0oooo02H0oooo103o000^0?ooo`00:`3oool30?l000P0oooo1P000?mj0?ooo`030000003o
ool0oooo09`0oooo00<00?l00?ooo`3oool09@3oool40?l002l0oooo000[0?ooo`<0o`00203oool0
0`000?l0oooo0000o`030000ogX0oooo00<000000?ooo`3oool0W@3oool00`00o`00oooo0?ooo`0S
0?ooo`@0o`00<03oool002/0oooo0`3o00080?ooo`040000o`3oool0oooo0?ooo`80003oNP3oool0
0`000000oooo0?ooo`2N0?ooo`03003o003oool0oooo0240oooo103o000a0?ooo`00:`3oool30?l0
00L0oooo00<0003o0?ooo`3oool0OP3oool00`000000oooo0?ooo`2O0?ooo`03003o003oool0oooo
01l0oooo103o000b0?ooo`00:`3oool30?l000L0oooo00<0003o0?ooo`3oool0OP3oool00`000000
oooo0?ooo`2O0?ooo`03003o003oool0oooo01h0oooo103o000c0?ooo`00:`3oool30?l000L0oooo
00<0003o0?ooo`3oool0OP3oool00`000000oooo0?ooo`2P0?ooo`03003o003oool0oooo01`0oooo
103o000d0?ooo`00:`3oool30?l000H0oooo00<0003o0?ooo`3oool0O`3oool00`000000oooo0?oo
o`2Q0?ooo`03003o003oool0oooo01X0oooo103o000e0?ooo`00:P3oool40?l000H0oooo00<0003o
0?ooo`3oool0O`3oool00`000000oooo0?ooo`2R0?ooo`03003o003oool0oooo01P0oooo103o000f
0?ooo`00:P3oool30?l000H0oooo00<0003o0?ooo`3oool0P03oool00`000000oooo0?ooo`2R0?oo
o`03003o003oool0oooo01H0oooo1@3o000g0?ooo`00:P3oool30?l000H0oooo00<0003o0?ooo`3o
ool0P03oool00`000000oooo0?ooo`2S0?ooo`03003o003oool0oooo01@0oooo1@3o000h0?ooo`00
:P3oool30?l000D0oooo00<0003o0?ooo`3oool0P@3oool00`000000oooo0?ooo`2T0?ooo`03003o
003oool0oooo0180oooo103o000j0?ooo`00:P3oool30?l000D0oooo00<0003o0?ooo`3oool0P@3o
ool00`000000oooo0?ooo`2U0?ooo`03003o003oool0oooo00l0oooo1@3o000k0?ooo`00:P3oool3
0?l000D0oooo00<0003o0?ooo`3oool0P@3oool00`000000oooo0?ooo`2U0?ooo`03003o003oool0
oooo00h0oooo1@3o000l0?ooo`00:@3oool30?l000D0oooo00<0003o0?ooo`3oool0PP3oool00`00
0000oooo0?ooo`2V0?ooo`03003o003oool0oooo00`0oooo1@3o000m0?ooo`00:@3oool30?l000D0
oooo00<0003o0?ooo`3oool0PP3oool00`000000oooo0?ooo`2W0?ooo`03003o003oool0oooo00X0
oooo103o000o0?ooo`00:@3oool30?l000@0oooo00<0003o0?ooo`3oool0P`3oool00`000000oooo
0?ooo`2X0?ooo`03003o003oool0oooo00L0oooo1@3o00100?ooo`00:@3oool30?l000@0oooo00<0
003o0?ooo`3oool0P`3oool00`000000oooo0?ooo`2X0?ooo`03003o003oool0oooo00H0oooo1@3o
00110?ooo`00:@3oool30?l000@0oooo00<0003o0?ooo`3oool0P`3oool00`000000oooo0?ooo`2Y
0?ooo`03003o003oool0oooo00@0oooo1@3o00120?ooo`00:@3oool30?l000<0oooo00<0003o0?oo
o`3oool0Q03oool00`000000oooo0?ooo`2Z0?ooo`04003o003oool0oooo0?ooo`D0o`00A03oool0
02T0oooo0`3o00030?ooo`030000o`3oool0oooo08@0oooo00<000000?ooo`3oool0Z`3oool00`00
o`00o`000?l000040?l004D0oooo000X0?ooo`<0o`000`3oool00`000?l0oooo0?ooo`250?ooo`03
0000003oool0oooo0:X0oooo00<0o`00003o003o0000103o00160?ooo`00:03oool30?l000<0oooo
00<0003o0?ooo`3oool0Q@3oool00`000000oooo0?ooo`2Z0?ooo`80o`0000<00?l00?l0003o0000
B03oool002P0oooo0`3o00020?ooo`030000o`3oool0oooo08H0oooo00<000000?ooo`3oool0Z@3o
ool60?l004P0oooo000X0?ooo`<0o`000P3oool00`000?l0oooo0?ooo`260?ooo`030000003oool0
oooo0:P0oooo00<0o`000000o`3o00000`3o00190?ooo`00:03oool30?l00080oooo00<0003o0?oo
o`3oool0QP3oool00`000000oooo0?ooo`2W0?ooo`030?l000000?l0o`000080o`00B`3oool002P0
oooo0`3o00000`3oool0003o0?ooo`280?ooo`030000003oool0oooo0:D0oooo00<0o`000000o`00
0?l00P3o001=0?ooo`009`3oool40?l000030?ooo`000?l0oooo08P0oooo00<000000?ooo`3oool0
Y03oool00`3o0000003o0?l000020?l004h0oooo000W0?ooo`<0o`0000<0oooo0000o`3oool0R@3o
ool00`000000oooo0?ooo`2S0?ooo`030?l000000?l0o`000080o`00C`3oool002L0oooo0`3o0000
0`3oool0003o0?ooo`290?ooo`030000003oool0oooo0:40oooo00<0o`000000o`000?l00P3o001A
0?ooo`009`3oool30?l000030?ooo`000?l0oooo08T0oooo00<000000?ooo`3oool0X03oool00`3o
0000003o0?l000020?l00580oooo000V0?ooo`@0o`0000<0003o0?ooo`3oool0R@3oool00`000000
oooo0?ooo`2O0?ooo`030?l000000?l0o`000080o`00D`3oool002H0oooo0`3o00000`3oool0003o
0?ooo`2:0?ooo`030000003oool0oooo09h0oooo0P000?l20?l005D0oooo000V0?ooo`<0o`0000<0
003o0?ooo`3oool0RP3oool00`000000oooo0?ooo`2L0?ooo`030?l000000?l0o`000080o`00EP3o
ool002H0oooo0`3o00000`000?l0oooo0?ooo`2:0?ooo`030000003oool0oooo09/0oooo00<0o`00
0000o`3o00000P3o001G0?ooo`009@3oool40?l000030000o`3oool0oooo08X0oooo00<000000?oo
o`3oool0:@3oool00`3oonX0^W800000000700000003001b^P3Zool0oooo06@0oooo0P000?l30?l0
05P0oooo000U0?ooo`<0o`0000<0003o0?ooo`3oool0R`3oool00`000000oooo0?ooo`0[0?ooo`04
0?oojP2jLP00002K0=Coo`<0oooo00D0omBK00000000000007:j0>[oo`1Q0?ooo`030?l000000?l0
o`000080o`00FP3oool002D0oooo0`3o00000`000?l0oooo0?ooo`2;0?ooo`030000003oool0oooo
02/0oooo00@0oooZ0;Yb000009/0e?oo103oool01@3oonX0^W8000000000L[X0j_oo05l0oooo00<0
o`000000o`3o00000P3o001K0?ooo`009@3oool20?l000030000o`3oool0oooo08`0oooo00<00000
0?ooo`3oool0:`3oool0103oonX0^W800000V`3Dool50?ooo`040?ooe02K0000000007:jjUh0oooo
0P000?l30?l005`0oooo000T0?ooo`<0o`0000<0003o0?ooo`3oool0S03oool00`000000oooo0?oo
o`0[0?ooo`040?oojP2jLP00002K0=Coo`H0oooo00@0j[Yb00000000L[X0j_ooF`3oool00`3o0000
003o0?l000020?l005h0oooo000T0?ooo`80o`0000<0003o0?ooo`3oool0S@3oool00`000000oooo
0?ooo`0[0?ooo`040?oojP2jLP00002K0=Coo`H0oooo00@0onZj078000000780^^[oFP3oool20000
o`<0o`00G`3oool002@0oooo0P3o00000`000?l0oooo0?ooo`2=0?ooo`030000003oool0oooo02/0
oooo00@0oooZ0;Yb000009/0e?oo1P3oool0103oom@0V`000000002Ke?mI0?ooo`030000o`3o0000
o`000080o`00H03oool002<0oooo0`3o00000`000?l0oooo0?ooo`2=0?ooo`030000003oool0oooo
02/0oooo00@0oooZ0;Yb000009/0e?oo1P3oool0103oom@0V`000000002Ke?mG0?ooo`030?l00000
0?l0o`000080o`00HP3oool002<0oooo0P3o00000`000?l0oooo0?ooo`2>0?ooo`030000003oool0
oooo02/0oooo00@0oooZ0;Yb000009/0e?oo1P3oool0103oj[X0LP000000LP2jj_mF0?ooo`80003o
0`3o001S0?ooo`008P3oool30?l000030000o`3oool0oooo08h0oooo00<000000?ooo`3oool0:`3o
ool0103oonX0^W800000V`3Dool60?ooo`040>ZjLP000000002K0=CooeD0oooo00<0003o0?l0003o
00000P3o001T0?ooo`008P3oool20?l000030000o`3oool0oooo08l0oooo00<000000?ooo`3oool0
:`3oool0103oonX0^W800000V`3Dool50?ooo`040?ooe02K0000000007:jjUD0oooo00@0003o0?l0
003o0000o`00IP3oool00280oooo0P3o00000`000?l0oooo0?ooo`2?0?ooo`030000003oool0oooo
02/0oooo00@0oooZ0;Yb000009/0e?oo103oool01@3oonX0^W8000000000L[X0j_oo05<0oooo0P00
0?l30?l006L0oooo000Q0?ooo`<0o`0000<0003o0?ooo`3oool0S`3oool00`000000oooo0?ooo`0[
0?ooo`040?oojP2jLP00002K0=Coo`<0oooo00D0omBK000000000000002K0=Coo`1C0?ooo`030000
o`3o0000o`000080o`00J03oool00240oooo0P3o00000`000?l0oooo0?ooo`2@0?ooo`030000003o
ool0oooo02T0oooo00<0oooZ0;Yb000000001`0000000`000780^^[o0?ooo`1C0?ooo`030000o`3o
0000o`000080o`00J@3oool00200oooo0`3o00000`000?l0oooo0?ooo`2@0?ooo`030000003oool0
oooo08L0oooo0P000?l30?l006/0oooo000P0?ooo`80o`0000<0003o0?ooo`3oool0T@3oool00`00
0000oooo0?ooo`260?ooo`030000o`3o0000o`000080o`00K03oool00200oooo0P3o00000`000?l0
oooo0?ooo`2A0?ooo`030000003oool0oooo08D0oooo00<0003o0?l0003o00000P3o001]0?ooo`00
7`3oool30?l000030000o`3oool0oooo0940oooo00<000000?ooo`3oool0P`3oool20000o`<0o`00
K`3oool001l0oooo0P3o00000`000?l0oooo0?ooo`2B0?ooo`030000003oool0oooo0880oooo00<0
003o0?l0003o00000P3o001`0?ooo`007`3oool20?l000030000o`3oool0oooo0980oooo00<00000
0?ooo`3oool0P@3oool00`000?l0o`000?l000020?l00740oooo000N0?ooo`80o`0000<0003o0?l0
003oool0T`3oool00`000000oooo0?ooo`1o0?ooo`80003o103o001b0?ooo`007P3oool20?l00003
0000o`3oool0oooo09<0oooo00<000000?ooo`3oool0OP3oool00`000?l0oooo0?l000030?l007<0
oooo000N0?ooo`030?l000000?l0o`0009D0oooo00<000000?ooo`3oool0M03oool00`000?l0oooo
0?ooo`050?ooo`80003o00<0oooo0?l0003o00000P3o001d0?ooo`007@3oool20?l000030000o`3o
0000oooo09@0oooo00<000000?ooo`3oool0L`3oool30000o`D0oooo00<0003o0?ooo`3oool0103o
001e0?ooo`007@3oool20?l000030000o`3oool0oooo09@0oooo00<000000?ooo`3oool0LP3oool4
0000o`@0oooo00<0003o0?ooo`3oool0103o001f0?ooo`007@3oool00`3o0000003o0?l0002F0?oo
o`030000003oool0oooo0780oooo1@000?l00`3oool0003o0000o`020?ooo`@0o`00M`3oool001`0
oooo103o002F0?ooo`030000003oool0oooo0740oooo1`000?l30?ooo`@0o`00N03oool001/0oooo
1@3o002F0?ooo`030000003oool0oooo0700oooo2@000?l00`3oool0o`000?l000020?l007T0oooo
000K0?ooo`80o`000P00o`000`3o0000oooo0?ooo`2D0?ooo`030000003oool0oooo06l0oooo2P00
0?l40?l007X0oooo000K0?ooo`@0o`000P00o`2E0?ooo`030000003oool0oooo06h0oooo30000?l2
0?l007/0oooo000K0?ooo`@0o`000P3oool3003o0980oooo00<000000?ooo`3oool0K@3oool>0000
og`0oooo000K0?ooo`<0o`001P3oool2003o0900oooo00<000000?ooo`3oool0K@3oool<0000o`03
0?l0003oool0oooo07/0oooo000J0?ooo`@0o`00203oool3003o08d0oooo00<000000?ooo`3oool0
K03oool;0000o`80o`00OP3oool001X0oooo0`3o000<0?ooo`800?l0R`3oool00`000000oooo0?oo
o`1[0?ooo`X0003o0`3o001o0?ooo`006@3oool40?l000h0oooo0`00o`280?ooo`030000003oool0
oooo06X0oooo20000?l00`3oool0o`000?l000020?l00800oooo000I0?ooo`<0o`004P3oool2003o
08H0oooo00<000000?ooo`3oool0J@3oool70000o`80oooo103o00210?ooo`00603oool40?l001@0
oooo0`00o`230?ooo`030000003oool0oooo06T0oooo10000?l40?ooo`@0o`00PP3oool001P0oooo
0`3o000H0?ooo`800?l0P@3oool00`000000oooo0?ooo`1X0?ooo`<0003o1@3oool40?l008<0oooo
000H0?ooo`<0o`006P3oool3003o07h0oooo00<000000?ooo`3oool0I`3oool20000o`H0oooo103o
00240?ooo`005`3oool40?l001d0oooo0P00o`1l0?ooo`030000003oool0oooo06h0oooo103o0025
0?ooo`005`3oool30?l00200oooo0`00o`1i0?ooo`030000003oool0oooo06d0oooo103o00260?oo
o`005P3oool40?l002<0oooo0P00o`1g0?ooo`030000003oool0oooo06`0oooo103o00270?ooo`00
5P3oool30?l002H0oooo0`00o`1d0?ooo`030000003oool0oooo06`0oooo0`3o00280?ooo`005@3o
ool40?l002T0oooo0P00o`1b0?ooo`030000003oool0oooo06/0oooo0`3o00290?ooo`005@3oool3
0?l002`0oooo0`00o`1_0?ooo`030000003oool0oooo06X0oooo103o00290?ooo`005@3oool30?l0
02l0oooo0P00o`1]0?ooo`030000003oool0oooo06X0oooo0`3o002:0?ooo`00503oool40?l00340
oooo0`00o`1Z0?ooo`030000003oool0oooo06T0oooo0`3o002;0?ooo`00503oool30?l003D0oooo
0P00o`1X0?ooo`030000003oool0oooo06P0oooo103o000?0?ooo`030>ZjLP000780^^[o07T0oooo
000C0?ooo`@0o`00=`3oool3003o00`0oooo00<00?l00?ooo`3oool0EP3oool00`000000oooo0?oo
o`1W0?ooo`@0o`00403oool00`3oj[X0LP00002Ke01i0?ooo`004`3oool30?l003/0oooo0P00o`0:
0?ooo`800?l0E`3oool00`000000oooo0?ooo`160?ooo`03003o003oool0oooo01h0oooo0`3o000B
0?ooo`030=BK000009/0e?oo07P0oooo000B0?ooo`@0o`00?@3oool3003o00H0oooo1@00o`1E0?oo
o`030000003oool0oooo04D0oooo0P00o`0O0?ooo`<0o`004`3oool00`3oom@0V`0009_Do`1h0?oo
o`004P3oool30?l00440oooo0P00o`040?ooo`H00?l0E03oool00`000000oooo0?ooo`140?ooo`<0
0?l07P3oool40?l001@0oooo00<0omBK002Ke03oool0M`3oool00140oooo103o00130?ooo`/00?l0
D`3oool00`000000oooo0?ooo`140?ooo`800?l07P3oool40?l001D0oooo00<0oooD09/0LP2jj_l0
M`3oool00140oooo0`3o00170?ooo`X00?l0D@3oool00`000000oooo0?ooo`130?ooo`<00?l07P3o
ool30?l001H0oooo00@0oooD09/00000L[X0j_ooMP3oool00140oooo0`3o00160?ooo``00?l0D03o
ool00`000000oooo0?ooo`120?ooo`@00?l07@3oool30?l001L0oooo00@0oooD09/0LP2KVg80L[[Z
MP3oool00100oooo103o00160?ooo`d00?l0C`3oool00`000000oooo0?ooo`110?ooo`D00?l04`3o
ool00`3o0000oooo0?ooo`060?ooo`@0o`005`3oool01@3oj[X0LP1b0;[ZjP2jLP00VmCo07D0oooo
000@0?ooo`<0o`00AP3oool@003o04d0oooo00<000000?ooo`3oool0@03oool6003o01<0oooo0`3o
00050?ooo`@0o`00603oool01P3oe9/0001b0;[Zo`3oe9/0002K0=Coog@0oooo000?0?ooo`@0o`00
AP3ooolA003o04`0oooo00<000000?ooo`3oool0?`3oool6003o01<0oooo1P3o00030?ooo`<0o`00
503oool00`3oonX0^Y^j0>[oo`020?ooo`060>ZjLP000780^^[o0?ooo`3DV`00L[[ZM03oool000l0
oooo0`3o001;0?ooo`h00?l0B`3oool00`000000oooo0?ooo`0o0?ooo`H00?l04`3oool70?l00004
0?ooo`3o0000o`000?l001H0oooo00/0j[Yb07:jjP3oool0onZj07800000L[X0j_oo0?ooo`3oe9/0
001b0;[Zo`1c0?ooo`003`3oool30?l00540oooo2P00o`190?ooo`030000003oool0oooo03h0oooo
1`00o`0C0?ooo`/0o`005P3oool00`3oonX0^W80000000020000000607:jjP3oool0oooo0?oojP2j
LP0009_DL`3oool000h0oooo103o001H0?ooo`@00?l0B03oool00`000000oooo0?ooo`0m0?ooo`P0
0?l04`3oool;0?l001L0oooo00D0oooZ0;Yb0000000007:j0>[oo`030?ooo`030?oDV`000780^^[o
0780oooo000>0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`0l0?ooo`T00?l04P3oool>0?l00980
oooo000>0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`0k0?ooo`T00?l04`3oool?0?l00940oooo
000>0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`0k0?ooo`T00?l04`3oool>0?l00980oooo000>
0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`0j0?ooo`X00?l04P3oool>0?l009<0oooo000>0?oo
o`<0o`00Y@3oool00`000000oooo0?ooo`0i0?ooo`/00?l04P3oool=0?l009@0oooo000>0?ooo`<0
o`00Y@3oool00`000000oooo0?ooo`0k0?ooo`T00?l04P3oool<0?l009D0oooo000>0?ooo`<0o`00
Y@3oool00`000000oooo0?ooo`0m0?ooo`H00?l04P3oool<0?l009H0oooo000>0?ooo`@0o`00Y03o
ool00`000000oooo0?ooo`0m0?ooo`03003o003oool00?l000<00?l04P3oool;0?l009L0oooo000>
0?ooo`@0o`00Y03oool00`000000oooo0?ooo`0l0?ooo`03003o003oool0oooo0080oooo0P00o`0B
0?ooo`X0o`00V03oool000h0oooo103o002T0?ooo`030000003oool0oooo03`0oooo00<00?l00?oo
o`3oool05P3oool90?l009T0oooo000?0?ooo`@0o`00X`3oool00`000000oooo0?ooo`0k0?ooo`03
003o003oool0oooo01H0oooo2@3o002J0?ooo`003`3oool60?l00:40oooo00<000000?ooo`3oool0
>`3oool00`00o`00oooo0?ooo`0F0?ooo`P0o`00V`3oool00100oooo1`3o002O0?ooo`030000003o
ool0oooo03X0oooo00<00?l00?ooo`3oool05`3oool70?l009`0oooo000B0?ooo`P0o`00W03oool0
0`000000oooo0?ooo`0j0?ooo`03003o003oool0oooo01H0oooo1`3o002M0?ooo`00503oool:0?l0
09P0oooo00<000000?ooo`3oool0>@3oool00`00o`00oooo0?ooo`0G0?ooo`H0o`00WP3oool001H0
oooo3@3o002C0?ooo`030000003oool0oooo03T0oooo00<00?l00?ooo`3oool05`3oool50?l009l0
oooo000J0?ooo`l0o`00S@3oool00`000000oooo0?ooo`0h0?ooo`03003o003oool0oooo01L0oooo
1@3o002P0?ooo`007P3ooolB0?l008H0oooo00<000000?ooo`3oool0>03oool00`00o`00oooo0?oo
o`0G0?ooo`@0o`00X@3oool002<0oooo4`3o00200?ooo`030000003oool0oooo03L0oooo00<00?l0
0?ooo`3oool0603oool40?l00:40oooo000Y0?oooa<0o`00NP3oool00`000000oooo0?ooo`0g0?oo
o`03003o003oool0oooo01P0oooo0`3o002R0?ooo`00<03ooolC0?l007<0oooo00<000000?ooo`3o
ool0=P3oool00`00o`00oooo0?ooo`0H0?ooo`@0o`00XP3oool003H0oooo4`3o001]0?ooo`030000
003oool0oooo03H0oooo00<00?l00?ooo`3oool0603oool30?l00:<0oooo000l0?oooa<0o`00I`3o
ool00`000000oooo0?ooo`0e0?ooo`03003o003oool0oooo01P0oooo103o002S0?ooo`00@`3ooolA
0?l00100oooo3P3o00140?ooo`030000003oool0oooo03D0oooo00<00?l00?ooo`3oool0603oool3
0?l00:@0oooo00190?ooobT0o`00A03oool00`000000oooo0?ooo`0d0?ooo`03003o003oool0oooo
01P0oooo103o002T0?ooo`00C`3ooolS0?l004@0oooo00<000000?ooo`3oool0=03oool00`00o`00
oooo0?ooo`0H0?ooo`<0o`00Y@3oool005@0oooo7P3o00140?ooo`030000003oool0oooo03<0oooo
00<00?l00?ooo`3oool0603oool40?l00:D0oooo001J0?oooaL0o`006`3oool30000obL0oooo00<0
00000?ooo`3oool0<`3oool00`00o`00oooo0?ooo`0G0?ooo`@0o`00YP3oool005d0oooo503o000L
0?ooo`L0003o8P3oool00`000000oooo0?ooo`0b0?ooo`03003o003oool0oooo01P0oooo0`3o002W
0?ooo`00G`3ooolE0?l001X0oooo2`000?lM0?ooo`030000003oool0oooo0380oooo00<00?l00?oo
o`3oool05`3oool40?l00:L0oooo001Q0?oooaL0o`005`3oool?0000oaP0oooo00<000000?ooo`3o
ool0<@3oool00`00o`00oooo0?ooo`0H0?ooo`<0o`00Z03oool006@0oooo603o000E0?oooa00003o
5@3oool00`000000oooo0?ooo`0a0?ooo`03003o003oool0oooo01L0oooo103o002X0?ooo`00IP3o
ool;0?l000<0oooo303o000B0?ooo`h0003o5P3oool00`000000oooo0?ooo`0`0?ooo`03003o003o
ool0oooo01P0oooo0`3o002Y0?ooo`00J03oool80?l000P0oooo303o000?0?ooo`d0003o5P3oool0
0`000000oooo0?ooo`0`0?ooo`03003o003oool0oooo01L0oooo103o002Y0?ooo`00JP3oool60?l0
00`0oooo303o000<0?ooo`/0003o5`3oool00`000000oooo0?ooo`0_0?ooo`03003o003oool0oooo
01P0oooo0`3o002Z0?ooo`00K03oool40?l00100oooo303o00090?ooo`X0003o5`3oool00`000000
oooo0?ooo`0_0?ooo`03003o003oool0oooo01L0oooo103o002Z0?ooo`00KP3oool20?l001@0oooo
303o00060?ooo`X0003o5P3oool00`000000oooo0?ooo`0^0?ooo`03003o003oool0oooo01P0oooo
0`3o002[0?ooo`00R03oool<0?l000<0oooo1`000?l20?ooo`80003o503oool00`000000oooo0?oo
o`0^0?ooo`03003o003oool0oooo01P0oooo0`3o002[0?ooo`00S03oool<0?l000030?ooo`000?l0
003o0080003o1@3oool20000oa80oooo00<000000?ooo`3oool0;@3oool00`00o`00oooo0?ooo`0H
0?ooo`@0o`00Z`3oool00900oooo2P3o00030000o`L0oooo0P000?l@0?ooo`030000003oool0oooo
02d0oooo00<00?l00?ooo`3oool0603oool30?l00:`0oooo002D0?ooo`L0o`0000@0003o0?l0003o
0000o`001`3oool20000o`h0oooo00<000000?ooo`3oool0;03oool00`00o`00oooo0?ooo`0H0?oo
o`@0o`00[03oool009P0oooo2P3o00060?ooo`80003o303oool00`000000oooo0?ooo`0/0?ooo`03
003o003oool0oooo01P0oooo0`3o002]0?ooo`00W03oool90?l000D0oooo0P000?l:0?ooo`030000
003oool0oooo02/0oooo00<00?l00?ooo`3oool06@3oool30?l00:d0oooo002N0?ooo`T0o`001@3o
ool20000o`P0oooo00<000000?ooo`3oool0:`3oool00`00o`00oooo0?ooo`0H0?ooo`@0o`00[@3o
ool00:40oooo2@3o00040?ooo`80003o1P3oool00`000000oooo0?ooo`0Z0?ooo`03003o003oool0
oooo01T0oooo0`3o002^0?ooo`00Y03oool80?l000@0oooo0P000?l40?ooo`030000003oool0oooo
02X0oooo00<00?l00?ooo`3oool06@3oool30?l00:h0oooo002V0?ooo`T0o`000`3oool20000o`80
oooo00<000000?ooo`3oool0:@3oool00`00o`00oooo0?ooo`0I0?ooo`@0o`00[P3oool00:T0oooo
2@3o00020?ooo`80003o00<000000?ooo`3oool0:@3oool00`00o`00oooo0?ooo`0I0?ooo`<0o`00
[`3oool00:/0oooo2@3o00020?ooo`80003o:@3oool00`00o`00oooo0?ooo`0J0?ooo`<0o`00[`3o
ool00:h0oooo2@3o00000`3oool0003o0000o`0W0?ooo`03003o003oool0oooo01T0oooo103o002_
0?ooo`00/@3oool80?l000030?ooo`000?l0003o02@0oooo00<00?l00?ooo`3oool06P3oool30?l0
0;00oooo002c0?ooo`T0o`000P000?lR0?ooo`03003o003oool0oooo01X0oooo0`3o002`0?ooo`00
]P3oool80?l00080003o7`3oool00`00o`00oooo0?ooo`0J0?ooo`@0o`00/03oool00;H0oooo00<0
00000?ooo`3o00001`3o00020000oad0oooo00<00?l00?ooo`3oool06P3oool30?l00;40oooo002f
0?ooo`030000003oool0oooo0080oooo1`3o00020000oaX0oooo00<00?l00?ooo`3oool06`3oool3
0?l00;40oooo002f0?ooo`030000003oool0oooo00D0oooo1P3o00020000oaP0oooo00<00?l00?oo
o`3oool06P3oool40?l00;40oooo002f0?ooo`030000003oool0oooo00L0oooo1P3o00020000oaD0
oooo00<00?l00?ooo`3oool06`3oool30?l00;80oooo002f0?ooo`030000003oool0oooo00X0oooo
1@3o00020000o`030?l0003oool0oooo0100oooo00<00?l00?ooo`3oool06`3oool30?l00;80oooo
002f0?ooo`030000003oool0oooo00`0oooo1@3o00020000o`030?l0003oool0oooo00d0oooo00<0
0?l00?ooo`3oool0703oool30?l00;80oooo002f0?ooo`030000003oool0oooo00h0oooo1@3o0002
0000o`030?l0003oool0oooo00/0oooo00<00?l00?ooo`3oool0703oool30?l00;80oooo002f0?oo
o`030000003oool0oooo0140oooo103o00020000o`80o`002@3oool00`00o`00oooo0?ooo`0L0?oo
o`<0o`00/`3oool00;H0oooo00<000000?ooo`3oool04`3oool40?l00080003o0P3o00070?ooo`03
003o003oool0oooo01`0oooo0`3o002c0?ooo`00]P3oool00`000000oooo0?ooo`0E0?ooo`@0o`00
0P000?l20?l000@0oooo00<00?l00?ooo`3oool07@3oool30?l00;<0oooo002f0?ooo`030000003o
ool0oooo01P0oooo0`3o00020000o`<0o`0000<0oooo003o003oool07P3oool30?l00;<0oooo002f
0?ooo`030000003oool0oooo01X0oooo0`3o00001@000?l0o`000?l00000o`00o`0001h0oooo0`3o
002d0?ooo`00]P3oool00`000000oooo0?ooo`0L0?ooo`@0o`0000<00?l00?l0003o00007@3oool3
0?l00;@0oooo002f0?ooo`030000003oool0oooo01d0oooo203o000K0?ooo`<0o`00]03oool00;H0
oooo00<000000?ooo`3oool07@3oool:0?l001T0oooo0`3o002d0?ooo`00]P3oool00`000000oooo
0?ooo`0N0?ooo`<0o`0000<0oooo0?l0003o00001@3o000G0?ooo`<0o`00]03oool00;H0oooo00<0
00000?ooo`3oool0903oool70?l001@0oooo0`3o002e0?ooo`00]P3oool00`000000oooo0?ooo`0V
0?ooo`L0o`004P3oool30?l00;D0oooo002f0?ooo`030000003oool0oooo02P0oooo1`3o000@0?oo
o`<0o`00]@3oool00;H0oooo00<000000?ooo`3oool0:P3oool70?l000h0oooo0`3o002e0?ooo`00
]P3oool00`000000oooo0?ooo`0/0?ooo`L0o`00303oool30?l00;D0oooo002f0?ooo`030000003o
ool0oooo02h0oooo1`3o00090?ooo`@0o`00]@3oool00;H0oooo00<000000?ooo`3oool0<03oool7
0?l000H0oooo103o002f0?ooo`00]P3oool00`000000oooo0?ooo`0b0?ooo`L0o`000`3oool40?l0
0;L0oooo002f0?ooo`030000003oool0oooo03@0oooo303o002g0?ooo`00]P3oool00`000000oooo
0?ooo`0f0?ooo`X0o`00]`3oool00;H0oooo00<000000?ooo`3oool0>03oool70?l00;P0oooo002f
0?ooo`030000003oool0oooo0?L0oooo002f0?ooo`030000003oool0oooo0?L0oooo002f0?ooo`03
0000003oool0oooo0?L0oooo002f0?ooo`030000003oool0oooo0?L0oooo002f0?ooo`030000003o
ool0oooo0?L0oooo002f0?ooo`030000003oool0oooo0?L0oooo002f0?ooo`030000003oool0oooo
0?L0oooo002f0?ooo`030000003oool0oooo0?L0oooo003o0?oook40oooo003o0?oook40oooo003o
0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o
0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o
0?oook40oooo002a0?ooo`040?oDV`000000002K0=Cooo/0oooo002a0?ooo`050?oDV`0000000000
001b^P3Zool0nP3oool00;@0oooo00<0e9/009_Do`3oool0n@3oool00;@0oooo00<0onZj079b^P3Z
ool0n@3oool00;D0oooo00<0e9]b0;[Zo`3oool0n03oool00;@0oooo00<0oooZ0;Yb001b^^X0n@3o
ool00;@0oooo00@0omBK00000000L[X0j_oon03oool00;@0oooo00@0e9/00000V`2KVg80^^[on03o
ool00;<0oooo00D0onZj0780001b^^X0omBK07:jjP3h0?ooo`00/`3oool01P3Z^W80002K0=Coo`3o
om@0V`2K0=CoooL0oooo002b0?ooo`030?ooe02K0000L[[Z0080oooo00<0j[Yb09_Do`3oool0mP3o
ool00;80oooo00<0j[Yb0000LP2jj_l00P3oool00`3oj[X0LY_D0?ooo`3f0?ooo`00/@3oool0103o
om@0V`00001b^P3Zool20?ooo`030?oojP2jLY/0e?oo0?H0oooo002`0?ooo`0;0?oojP2jLP000000
00000000L[X0j_oo0?ooo`3DV`000000001b^P3Zool0m@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {426.125, 0}} -> {-2.12171, -2.25581, \
0.0173967, 0.0173967}}]
}, Open  ]],

Cell[TextData[{
  "Teorema de Green",
  StyleBox[". ",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "Sea \[Gamma] un camino cerrado y simple en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " que est\[AAcute] orientado positivamente y sea ",
  StyleBox["D",
    FontSlant->"Italic"],
  " la regi\[OAcute]n del plano limitada por \[Gamma]. Sean ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " campos escalares con derivadas parciales de primer orden continuas \
definidos en un abierto que contiene a ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ". En estas condiciones se verifica que la integral de l\[IAcute]nea del \
campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre el camino \[Gamma] es igual a la integral doble de la \
funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], \((x, y)\)}]}], "  "}], 
        TextForm]]],
  "sobre ",
  StyleBox["D",
    FontSlant->"Italic"],
  ". Es decir"
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["\[Gamma]",
                    FontWeight->"Bold"]], 
                RowBox[{
                  RowBox[{
                    StyleBox["P",
                      FontWeight->"Plain",
                      FontSlant->"Italic"], "(", \(x, y\), 
                    ")"}], \(\[DifferentialD]x\)}]}], 
              "+", \(\(Q(x, y)\) \[DifferentialD]y\)}], "=", 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], 
                RowBox[{
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["Q",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["x",
                              FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
                      RowBox[{
                        FractionBox[
                          RowBox[{"\[PartialD]", 
                            StyleBox["P",
                              FontSlant->"Italic"]}], 
                          RowBox[{"\[PartialD]", 
                            StyleBox["y",
                              FontSlant->"Italic"]}]], \((x, y)\)}]}], 
                    ")"}], \(\[DifferentialD]\((x, y)\)\)}]}]}]}]}]], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es frecuente representar con \[PartialD]",
  StyleBox["D",
    FontSlant->"Italic"],
  " la curva frontera de ",
  StyleBox["D",
    FontSlant->"Italic"],
  ", es decir \[Gamma], orientada positivamente."
}], "Text"],

Cell["\<\
El teorema de Green permite facilitar el c\[AAcute]lculo de algunas \
integrales de l\[IAcute]nea (o de integrales dobles) transform\[AAcute]ndolas \
en integrales dobles (o en integrales de l\[IAcute]nea). \
\>", "Text"],

Cell[TextData[{
  "Una aplicaci\[OAcute]n del teorema de Green es para calcular \
\[AAcute]reas. Como el \[AAcute]rea de la regi\[OAcute]n ",
  StyleBox["D",
    FontSlant->"Italic"],
  " viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Integral]", 
          RowBox[{\(\[Integral]\_D\), 
            RowBox[{
              StyleBox["1",
                FontWeight->"Bold"], \(\[DifferentialD]\((x, y)\)\)}]}]}], 
        TraditionalForm]]],
  " podemos transformar esta integral doble en una integral de l\[IAcute]nea \
sobre la frontera \[PartialD]",
  StyleBox["D ",
    FontSlant->"Italic"],
  "sin m\[AAcute]s que elegir funciones ",
  StyleBox["P",
    FontSlant->"Italic"],
  ", ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " tales que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["Q",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["x",
                    FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
            RowBox[{
              FractionBox[
                RowBox[{"\[PartialD]", 
                  StyleBox["P",
                    FontSlant->"Italic"]}], 
                RowBox[{"\[PartialD]", 
                  StyleBox["y",
                    FontSlant->"Italic"]}]], \((x, y)\)}]}], " "}], 
        TextForm]]],
  "=1. Hay muchas posibilidades pero las m\[AAcute]s sencillas son ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = 0, \ Q(x, y) = x\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = \(-y\), \ Q(x, y) = 0\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`P(x, y) = \(-y\)/2, Q(x, y) = x/2\)]],
  " por lo que obtenemos las siguientes expresiones para el \[AAcute]rea:"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\[CapitalAAcute]rea \((D)\)\),
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{"\[Integral]", 
            RowBox[{\(\[Integral]\_D\), 
              RowBox[{
                StyleBox["1",
                  FontWeight->"Bold"], \(\[DifferentialD]\((x, y)\)\)}]}]}], 
          "=", 
          RowBox[{
            RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Plain",
                  FontSlant->"Italic"], \(\[DifferentialD]y\)}]}], "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
                  RowBox[{
                    StyleBox["y",
                      FontSlant->"Italic"], \(\[DifferentialD]x\)}]}]}], 
              "=", 
              RowBox[{
                RowBox[{\(1\/2\), 
                  RowBox[{\(\[Integral]\_\(\[PartialD]\ D\)\), 
                    RowBox[{
                      StyleBox["x",
                        FontSlant->"Italic"], " ", 
                      \(\[DifferentialD]y\)}]}]}], " ", "-", " ", 
                RowBox[{
                  StyleBox["y",
                    FontSlant->"Italic"], " ", 
                  \(\[DifferentialD]x\)}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Observa que puede demostrarse muy f\[AAcute]cilmente el teorema 4 para el \
caso de dos dimensiones usando el teorema de Green.\
\>", "Text"],

Cell["\<\
El teorema de Green tambi\[EAcute]n es v\[AAcute]lido para regiones acotadas \
por caminos de Jordan en las que se han hecho agujeros, es decir regiones \
acotadas cuya frontera est\[AAcute] formada por varios caminos de Jordan que \
no tienen puntos comunes siempre que cada camino frontera est\[EAcute] \
orientado de modo que la regi\[OAcute]n quede siempre a la izquierda cuando \
se recorre dicho camino. Esto significa que el camino frontera m\[AAcute]s \
exterior de todos (aquel en cuyo interior se encuentra contenida la regi\
\[OAcute]n) debe tener orientaci\[OAcute]n positiva y los restantes caminos \
frontera (los que forman los agujeros - la regi\[OAcute]n se encuentra en el \
exterior de los mismos -) deben tener orientaci\[OAcute]n negativa (recorrido \
en el sentido de las agujas del reloj). En otras palabras, representando por \
\[CapitalGamma] la uni\[OAcute]n de todas las curvas frontera, debe ocurrir \
que el determinante de la matriz cuya primera fila es el vector tangente \
unitario a \[CapitalGamma] en un punto t y cuya segunda fila es el vector \
normal interior a \[CapitalGamma] en un punto t es siempre positivo (de \
hecho, igual a 1).\
\>", "Text"],

Cell[TextData[{
  "Teorema de Green para dominios con agujeros",
  StyleBox[". Sea ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox[\(x, y\),
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              RowBox[{
                StyleBox["P",
                  FontWeight->"Plain"], 
                StyleBox[\((x, y)\),
                  FontWeight->"Plain"], 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox["+",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["Q",
                  FontWeight->"Plain"], 
                StyleBox[\((x, y)\),
                  FontWeight->"Plain"], 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], 
          StyleBox[" ",
            FontWeight->"Plain"]}], TraditionalForm]]],
  " ",
  StyleBox["un campo de clase",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(C\^1\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["definido en un abierto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^2\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". Sean ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Gamma]",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  StyleBox[" curvas de Jordan en ",
    FontWeight->"Plain"],
  StyleBox["A",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" disjuntas dos a dos tales que\n\[FilledSmallCircle] ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  " ",
  StyleBox["se encuentran en el interior de \[Gamma]",
    FontWeight->"Plain"],
  StyleBox[".\n",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["\[FilledSmallCircle] ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_i\)],
    FontWeight->"Plain"],
  StyleBox[" se encuentra en el exterior de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_j\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["para ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`i \[NotEqual] j\)],
    FontWeight->"Plain"],
  ".\n\[FilledSmallCircle] ",
  StyleBox["La curva \[Gamma]",
    FontWeight->"Plain"],
  StyleBox[" ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[
  "est\[AAcute] orientada positivamente (sentido antihorario) y las curvas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\(\[Gamma]\_1\), ",", " ", 
            SubscriptBox[
              StyleBox["\[Gamma]",
                FontWeight->"Plain"], 
              StyleBox["2",
                FontWeight->"Plain"]], ",", "...", ",", " ", 
            SubscriptBox[
              StyleBox["\[Gamma]",
                FontWeight->"Plain"], 
              StyleBox["k",
                FontWeight->"Plain"]]}],
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[
  " est\[AAcute]n orientadas negativamente (sentido horario). \nSea ",
    FontWeight->"Plain"],
  StyleBox["D",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[
  " la regi\[OAcute]n obtenida por la intersecci\[OAcute]n del interior de \
\[Gamma] con el exterior de cada una de las curvas ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(\[Gamma]\_1\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["2",
              FontWeight->"Plain"]], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox["...",
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          SubscriptBox[
            StyleBox["\[Gamma]",
              FontWeight->"Plain"], 
            StyleBox["k",
              FontWeight->"Plain"]]}], TraditionalForm]]],
  StyleBox[". En estas hip\[OAcute]tesis se verifica que",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[\(\[DifferentialD]\[Gamma]\),
                FontWeight->"Bold",
                FontSlant->"Plain"]}]}], "+", 
          RowBox[{\(\[Sum]\+\(j = 1\)\%k\), 
            RowBox[{
              SubscriptBox["\[Integral]", 
                SubscriptBox[
                  StyleBox["\[Gamma]",
                    FontWeight->"Bold"], "j"]], 
              RowBox[{
                StyleBox["F",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[".",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontWeight->"Bold",
                    FontSlant->"Plain"], 
                  SubscriptBox[
                    StyleBox["\[Gamma]",
                      FontWeight->"Bold",
                      FontSlant->"Plain"], "j"]}]}]}]}]}], "=", 
        RowBox[{"\[Integral]", 
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["D",
                FontWeight->"Bold",
                FontSlant->"Italic"]], 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["Q",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["x",
                          FontSlant->"Italic"]}]], \((x, y)\)}], "-", 
                  RowBox[{
                    FractionBox[
                      RowBox[{"\[PartialD]", 
                        StyleBox["P",
                          FontSlant->"Italic"]}], 
                      RowBox[{"\[PartialD]", 
                        StyleBox["y",
                          FontSlant->"Italic"]}]], \((x, y)\)}]}], ")"}], 
              \(\[DifferentialD]\((x, y)\)\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
La siguiente gr\[AAcute]fica muestra un ejemplo de un dominio como el que se \
considera en el enunciado del teorema.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(dominioconagujeros;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .98872 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.450237 0.219151 0.494357 0.219151 [
[1.025 .49436 0 -9.09375 ]
[1.025 .49436 10.75 9.09375 ]
[.45024 1.01372 -5.375 0 ]
[.45024 1.01372 5.375 18.1875 ]
[.62556 .47244 -8.40625 -9.09375 ]
[.62556 .47244 8.40625 9.09375 ]
[.40641 .69159 -8.40625 -9.09375 ]
[.40641 .69159 8.40625 9.09375 ]
[.58173 .62585 -7.0625 -9.09375 ]
[.58173 .62585 7.0625 9.09375 ]
[.77896 .75734 -5.75 -9.09375 ]
[.77896 .75734 5.75 9.09375 ]
[ 0 0 0 0 ]
[ 1 .98872 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .49436 m
1 .49436 L
s
gsave
1.025 .49436 -61 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
69.750 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.45024 0 m
.45024 .98872 L
s
gsave
.45024 1.01372 -66.375 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
69.750 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.035 0.00875 moveto 0 0 lineto
-0.035 -0.00875 lineto fill
-0.035 0.00875 moveto 0 0 lineto
-0.035 -0.00875 lineto
-0.035 0.00875 lineto stroke
} ifelse
grestore
} def
/MAarrowhead2 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.037 0.00925 moveto 0 0 lineto
-0.037 -0.00925 lineto fill
-0.037 0.00925 moveto 0 0 lineto
-0.037 -0.00925 lineto
-0.037 0.00925 lineto stroke
} ifelse
grestore
} def
/MAarrowhead3 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.07 0.0175 moveto 0 0 lineto
-0.07 -0.0175 lineto fill
-0.07 0.0175 moveto 0 0 lineto
-0.07 -0.0175 lineto
-0.07 0.0175 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
.01 w
.5379 .93266 m
.47307 .9032 L
.38564 .87183 L
.28639 .84538 L
.18096 .82549 L
.09818 .81329 L
.08306 .81086 L
.06886 .80821 L
.05744 .8056 L
.04827 .80291 L
.04046 .79985 L
.03695 .79806 L
.03365 .79599 L
.03067 .7936 L
.02835 .79113 L
.02669 .78875 L
.02593 .78732 L
.02532 .78594 L
.02484 .78459 L
.02443 .78307 L
.02414 .78158 L
.02395 .78017 L
.02385 .77885 L
.02381 .77737 L
.02385 .77576 L
.02395 .77422 L
.02416 .77236 L
.02443 .77053 L
.02517 .76696 L
.02624 .76288 L
.02774 .75816 L
.04662 .71395 L
.05979 .68357 L
.07397 .64583 L
.08 .62676 L
.08573 .60577 L
.0903 .58559 L
.09382 .56629 L
.09641 .54777 L
.09754 .53729 L
.09835 .5277 L
.09902 .51713 L
.09928 .51115 L
.09945 .50562 L
.09955 .50079 L
.09959 .49546 L
.09957 .48991 L
.09949 .48471 L
.09934 .47929 L
.09923 .47626 L
Mistroke
.09911 .47352 L
.09851 .46318 L
.09807 .45739 L
.09751 .45117 L
.09629 .43994 L
.09313 .41828 L
.0894 .39883 L
.08041 .36333 L
.06897 .3287 L
.04359 .26807 L
.03426 .24715 L
.03029 .2375 L
.02699 .22828 L
.02572 .22396 L
.02517 .22177 L
.02468 .21949 L
.02432 .21747 L
.02407 .21569 L
.02391 .21403 L
.02382 .21234 L
.02382 .21078 L
.0239 .20918 L
.02405 .20771 L
.02427 .20641 L
.02461 .20494 L
.02509 .2034 L
.02625 .20076 L
.02704 .1994 L
.02789 .19818 L
.0302 .19556 L
.03298 .19321 L
.03655 .19088 L
.04457 .18713 L
.05369 .18413 L
.06453 .18142 L
.07791 .17876 L
.10654 .17416 L
.19012 .16176 L
.28369 .14394 L
.37422 .12038 L
.46483 .08885 L
.53091 .05952 L
.58038 .03395 L
.58893 .02963 L
.59572 .02654 L
.60085 .02465 L
.6021 .02429 L
.60336 .02399 L
.60439 .02379 L
.60546 .02363 L
Mistroke
.60652 .02355 L
.60746 .02354 L
.60827 .02359 L
.60911 .02371 L
.60997 .02392 L
.61084 .02423 L
.61161 .02461 L
.61227 .02503 L
.61347 .02604 L
.61465 .02743 L
.61565 .02903 L
.6165 .03075 L
.61821 .03539 L
.61993 .04181 L
.62368 .05895 L
.62897 .08114 L
.63655 .1064 L
.64954 .13973 L
.66603 .17301 L
.71288 .24351 L
.7702 .30748 L
.90302 .4176 L
.9295 .43756 L
.95186 .45598 L
.96559 .47005 L
.96841 .47371 L
.97095 .47754 L
.97288 .48107 L
.97428 .48428 L
.97488 .48603 L
.97541 .48794 L
.97581 .48986 L
.97597 .4909 L
.97608 .49188 L
.97619 .49367 L
.97618 .49531 L
.97604 .49721 L
.97579 .499 L
.97545 .50062 L
.97499 .50233 L
.97388 .50544 L
.9721 .50918 L
.97006 .5126 L
.96397 .52059 L
.95519 .52966 L
.93397 .54767 L
.8774 .59026 L
.80339 .65022 L
.73442 .7192 L
.6836 .78624 L
Mistroke
.64791 .85273 L
.63562 .8851 L
.62793 .91158 L
.62 .94661 L
.61828 .95309 L
.61728 .95607 L
.61625 .95851 L
.61522 .96042 L
.61464 .9613 L
.61398 .96214 L
.61333 .96282 L
.61271 .96336 L
.61211 .9638 L
.61141 .96421 L
.61063 .96457 L
.60975 .96486 L
.60889 .96504 L
.60804 .96514 L
.60751 .96517 L
.60699 .96518 L
.60597 .96513 L
.60481 .96499 L
.60412 .96488 L
.60346 .96475 L
.60122 .96417 L
.59849 .96326 L
.5921 .96059 L
.55008 .93885 L
.5379 .93266 L
Mfstroke
newpath
.55981 .38478 .06575 0 365.73 arc
s
newpath
.34066 .60393 .06575 0 365.73 arc
s
.5 Mabswid
.40304 .61327 m
.40402 .60722 L
s
% Start of user PostScript
-0.21535 0.54259 -0.210875 0.514994 MAarrowhead1
% End of user PostScript
.62219 .39412 m
.62383 .38807 L
s
% Start of user PostScript
0.78465 -0.45741 0.792125 -0.485006 MAarrowhead2
% End of user PostScript
0 g
gsave
.62556 .47244 -69.4063 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.250 20.063 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 9.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
75.813 17.813 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40641 .69159 -69.4063 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.250 20.063 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 9.938 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
75.813 17.813 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
1 0 0 r
.22416 .83278 m
.20176 .82887 L
s
% Start of user PostScript
-1.03159 1.54425 -1.13382 1.52641 MAarrowhead3
% End of user PostScript
.08825 .39359 m
.0836 .37472 L
s
% Start of user PostScript
-1.65177 -0.459815 -1.67299 -0.545899 MAarrowhead3
% End of user PostScript
.4105 .10883 m
.43201 .10132 L
s
% Start of user PostScript
-0.181317 -1.75921 -0.0831752 -1.79344 MAarrowhead3
% End of user PostScript
.81368 .34748 m
.8304 .36155 L
s
% Start of user PostScript
1.65841 -0.670217 1.7347 -0.605987 MAarrowhead3
% End of user PostScript
.6725 .80428 m
.66331 .82073 L
s
% Start of user PostScript
1.01421 1.41421 0.972248 1.48927 MAarrowhead3
% End of user PostScript
0 g
gsave
.58173 .62585 -68.0625 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(D) show
73.125 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.77896 .75734 -66.75 -13.0938 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 26.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 17.813 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 17.813 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
70.500 17.813 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 14.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .98872 L
0 .98872 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 284.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001Zb000`400?l00000o`00003o]P3oool0
0`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000
oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?oo
o`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?oo
o`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3oool00`000000oooo0?ooo`3g0?ooo`00]P3o
ool00`000000oooo0?ooo`0h0?ooo`H0o`00^@3oool00;H0oooo00<000000?ooo`3oool0=@3oool:
0?l00;P0oooo002f0?ooo`030000003oool0oooo03<0oooo3@3o002g0?ooo`00]P3oool00`000000
oooo0?ooo`0b0?ooo`L0o`00103oool40?l00;H0oooo002f0?ooo`030000003oool0oooo0300oooo
1P3o00080?ooo`@0o`00]@3oool00;H0oooo00<000000?ooo`3oool0;P3oool60?l000/0oooo0`3o
002e0?ooo`00]P3oool00`000000oooo0?ooo`0/0?ooo`L0o`00303oool30?l00;D0oooo002f0?oo
o`030000003oool0oooo02X0oooo1`3o000>0?ooo`<0o`00]@3oool00;H0oooo00<000000?ooo`3o
ool0:03oool70?l00100oooo0`3o002e0?ooo`00]P3oool00`000000oooo0?ooo`0V0?ooo`L0o`00
4P3oool30?l00;D0oooo002f0?ooo`030000003oool0oooo02@0oooo1`3o000D0?ooo`@0o`00]03o
ool00;H0oooo00<000000?ooo`3oool08P3oool70?l001L0oooo0`3o002d0?ooo`00]P3oool00`00
0000oooo0?ooo`0P0?ooo`L0o`006@3oool30?l00;@0oooo002f0?ooo`030000003oool0oooo01h0
oooo1`3o000K0?ooo`@0o`00/`3oool00;H0oooo00<000000?ooo`3oool0703oool70?l001h0oooo
0`3o002c0?ooo`00]P3oool00`000000oooo0?ooo`0I0?ooo`P0o`00803oool30?l00;<0oooo002f
0?ooo`030000003oool0oooo01L0oooo203o000R0?ooo`<0o`00/`3oool00;H0oooo00<000000?oo
o`3oool05@3oool80?l002@0oooo103o002b0?ooo`00]P3oool00`000000oooo0?ooo`0B0?ooo`P0
o`00:03oool30?l00;80oooo002f0?ooo`030000003oool0oooo0100oooo203o000Z0?ooo`<0o`00
/P3oool00;H0oooo00<000000?ooo`3oool03P3oool80?l002`0oooo0`3o002b0?ooo`00]P3oool0
0`000000oooo0?ooo`0;0?ooo`P0o`00;`3oool40?l00;40oooo002f0?ooo`030000003oool0oooo
00T0oooo203o000b0?ooo`<0o`00/@3oool00;H0oooo00<000000?ooo`3oool01`3oool80?l003@0
oooo0`3o002a0?ooo`00]P3oool00`000000oooo0?ooo`040?ooo`P0o`00=`3oool30?l00;40oooo
002f0?ooo`030000003oool0oooo0080oooo203o000i0?ooo`@0o`00/03oool00;H0oooo00<00000
0?ooo`3o0000203o000l0?ooo`<0o`00/03oool00;D0oooo2@3o000o0?ooo`<0o`00/03oool00;<0
oooo2@3o00110?ooo`@0o`00[`3oool00;00oooo2@3o00150?ooo`<0o`00[`3oool00:d0oooo2@3o
00000`000000oooo0?ooo`150?ooo`<0o`00[`3oool00:X0oooo2P3o00020?ooo`030000003oool0
oooo04D0oooo103o002^0?ooo`00XP3oool?0?l000D0oooo00<000000?ooo`3oool0AP3oool30?l0
0:h0oooo002H0?oooaH0o`00203oool00`000000oooo0?ooo`160?ooo`<0o`00[P3oool009<0oooo
6@3o000:0?ooo`030000003oool0oooo04H0oooo103o002]0?ooo`00T`3ooolG0?l000`0oooo00<0
00000?ooo`3oool0A`3oool30?l00:d0oooo002D0?oooaD0o`003@3oool00`000000oooo0?ooo`17
0?ooo`<0o`00[@3oool009@0oooo503o000>0?ooo`030000003oool0oooo04L0oooo103o002/0?oo
o`00U@3ooolA0?l00100oooo00<000000?ooo`3oool0B03oool30?l00:`0oooo002C0?oooa80o`00
4@3oool00`000000oooo0?ooo`180?ooo`<0o`00[03oool008l0oooo503o000C0?ooo`030000003o
ool0oooo04P0oooo103o002[0?ooo`00R`3ooolG0?l001@0oooo00<000000?ooo`3oool0B@3oool3
0?l00:/0oooo00270?ooo``0o`000`3oool:0?l001H0oooo00<000000?ooo`3oool0B@3oool40?l0
0:X0oooo00230?ooo``0o`001`3oool90?l001L0oooo00<000000?ooo`3oool0BP3oool30?l00:X0
oooo001o0?ooo``0o`00303oool70?l001P0oooo00<000000?ooo`3oool0BP3oool30?l00:X0oooo
001k0?ooo``0o`00403oool50?l001X0oooo00<000000?ooo`3oool0BP3oool40?l00:T0oooo001g
0?ooo``0o`005@3oool30?l001/0oooo00<000000?ooo`3oool0B`3oool30?l00:T0oooo001c0?oo
o``0o`006@3oool00`3o0000oooo0?ooo`0K0?ooo`030000003oool0oooo04/0oooo103o002X0?oo
o`00KP3oool=0?l003/0oooo00<000000?ooo`3oool0C03oool30?l00:P0oooo001X0?ooo`l0o`00
?`3oool00`000000oooo0?ooo`1<0?ooo`@0o`00Y`3oool006<0oooo403o00130?ooo`030000003o
ool0oooo04d0oooo0`3o002W0?ooo`00GP3oool@0?l004P0oooo00<000000?ooo`3oool0C@3oool4
0?l00:H0oooo001H0?oooa00o`00CP3oool00`000000oooo0?ooo`1>0?ooo`<0o`00YP3oool005<0
oooo403o001C0?ooo`030000003oool0oooo04h0oooo0`3o002V0?ooo`00C@3ooolA0?l005P0oooo
00<000000?ooo`3oool0CP3oool40?l00:D0oooo00170?oooa40o`00GP3oool00`000000oooo0?oo
o`1?0?ooo`<0o`00Y@3oool00400oooo4`3o001S0?ooo`030000003oool0oooo04l0oooo103o002T
0?ooo`00>@3ooolD0?l006T0oooo00<000000?ooo`3oool0D03oool30?l00:@0oooo000c0?oooa@0
o`00K`3oool00`000000oooo0?ooo`1@0?ooo`@0o`00X`3oool002d0oooo4`3o001f0?ooo`030000
003oool0oooo0540oooo0`3o002S0?ooo`009`3ooolB0?l007d0oooo00<000000?ooo`3oool0D@3o
ool40?l00:80oooo000R0?oooa40o`00P`3oool00`000000oooo0?ooo`1B0?ooo`@0o`00X@3oool0
01d0oooo403o00290?ooo`030000003oool0oooo05<0oooo0`3o002Q0?ooo`00603oool?0?l008l0
oooo00<000000?ooo`3oool0D`3oool40?l00:00oooo000E0?ooo`d0o`00U03oool00`000000oooo
0?ooo`1D0?ooo`@0o`00W`3oool001<0oooo2P3o002I0?ooo`030000003oool0oooo05D0oooo0`3o
002O0?ooo`004@3oool80?l009d0oooo00<000000?ooo`3oool0E@3oool40?l009h0oooo000@0?oo
o`H0o`00X03oool00`000000oooo0?ooo`1F0?ooo`@0o`00W@3oool000l0oooo1@3o002R0?ooo`03
0000003oool0oooo05L0oooo0`3o002M0?ooo`003`3oool30?l00:@0oooo00<000000?ooo`3oool0
E`3oool40?l009`0oooo000>0?ooo`@0o`00Y03oool00`000000oooo0?ooo`1H0?ooo`@0o`00V`3o
ool000h0oooo0`3o002U0?ooo`030000003oool0oooo05T0oooo0`3o002K0?ooo`003P3oool30?l0
0:D0oooo00<000000?ooo`3oool0F@3oool40?l009X0oooo000>0?ooo`<0o`00Y@3oool00`000000
oooo0?ooo`1J0?ooo`@0o`00V@3oool000h0oooo0`3o002U0?ooo`030000003oool0oooo05/0oooo
103o002H0?ooo`003P3oool30?l00:D0oooo00<000000?ooo`3oool0G03oool30?l009P0oooo000>
0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`1L0?ooo`@0o`00U`3oool000h0oooo0`3o002U0?oo
o`030000003oool0oooo05d0oooo103o002F0?ooo`003P3oool30?l00:D0oooo00<000000?ooo`3o
ool0GP3oool30?l009H0oooo000>0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`1N0?ooo`@0o`00
U@3oool000h0oooo103o002T0?ooo`030000003oool0oooo05l0oooo103o002D0?ooo`003`3oool3
0?l00:@0oooo00<000000?ooo`3oool0H03oool30?l009@0oooo000?0?ooo`<0o`00Y03oool00`00
0000oooo0?ooo`1P0?ooo`@0o`00T`3oool000l0oooo103o002S0?ooo`030000003oool0oooo0640
oooo103o002B0?ooo`00403oool30?l00:<0oooo00<000000?ooo`3oool0HP3oool30?l00980oooo
000@0?ooo`<0o`00X`3oool00`000000oooo0?ooo`1R0?ooo`@0o`00T@3oool00100oooo103o002R
0?ooo`030000003oool0oooo06<0oooo103o002@0?ooo`004@3oool30?l00:80oooo00<000000?oo
o`3oool0I03oool30?l00900oooo000A0?ooo`@0o`00X@3oool00`000000oooo0?ooo`1T0?ooo`@0
o`00S`3oool00180oooo0`3o002Q0?ooo`030000003oool0oooo06D0oooo103o002>0?ooo`004P3o
ool40?l00:00oooo00<000000?ooo`3oool0IP3oool40?l008d0oooo000C0?ooo`<0o`00X03oool0
0`000000oooo0?ooo`1W0?ooo`@0o`00S03oool001<0oooo0`3o002P0?ooo`030000003oool0oooo
06P0oooo103o002;0?ooo`004`3oool40?l009l0oooo00<000000?ooo`3oool0J@3oool40?l008X0
oooo000D0?ooo`<0o`00W`3oool00`000000oooo0?ooo`1Z0?ooo`@0o`00R@3oool001@0oooo0`3o
002O0?ooo`030000003oool0oooo06/0oooo0`3o00290?ooo`00503oool40?l009h0oooo00<00000
0?ooo`3oool0K03oool30?l008P0oooo000E0?ooo`<0o`00WP3oool00`000000oooo0?ooo`1/0?oo
o`@0o`00Q`3oool001D0oooo103o002M0?ooo`030000003oool0oooo06d0oooo103o00260?ooo`00
5P3oool30?l009d0oooo00<000000?ooo`3oool0KP3oool40?l008D0oooo000F0?ooo`<0o`00W@3o
ool00`000000oooo0?ooo`1_0?ooo`@0o`00Q03oool001H0oooo103o002L0?ooo`030000003oool0
oooo0700oooo103o00230?ooo`005`3oool30?l009`0oooo00<000000?ooo`3oool0L@3oool40?l0
0880oooo000G0?ooo`@0o`00V`3oool00`000000oooo0?ooo`1b0?ooo`<0o`00PP3oool001P0oooo
0`3o002K0?ooo`030000003oool0oooo07<0oooo0`3o00210?ooo`00603oool40?l009X0oooo00<0
00000?ooo`3oool0L`3oool40?l00800oooo000I0?ooo`<0o`00VP3oool00`000000oooo0?ooo`1d
0?ooo`@0o`00O`3oool001T0oooo0`3o002J0?ooo`030000003oool0oooo07D0oooo103o001n0?oo
o`006@3oool40?l009T0oooo00<000000?ooo`3oool0MP3oool40?l007d0oooo000J0?ooo`<0o`00
V@3oool00`000000oooo0?ooo`1g0?ooo`@0o`00O03oool001X0oooo103o002H0?ooo`030000003o
ool0oooo07P0oooo103o001k0?ooo`006`3oool30?l009P0oooo00<000000?ooo`3oool0N@3oool3
0?l000H0oooo00<0o`000?ooo`3oool0LP3oool001/0oooo0`3o002H0?ooo`030000003oool0oooo
07X0oooo103o00030?ooo`<0o`00L`3oool001/0oooo103o002G0?ooo`030000003oool0oooo07X0
oooo1@3o00000`3oool0o`000?l000020?l007<0oooo000L0?ooo`<0o`00U`3oool00`000000oooo
0?ooo`1l0?ooo`T0o`00LP3oool001`0oooo103o002F0?ooo`030000003oool0oooo07d0oooo2@3o
001a0?ooo`007@3oool30?l009H0oooo00<000000?ooo`3oool0903oool;0?l004h0oooo2P3o001`
0?ooo`007@3oool40?l009D0oooo00<000000?ooo`3oool07`3ooolC0?l004/0oooo2P3o001`0?oo
o`007P3oool30?l009D0oooo00<000000?ooo`3oool07@3ooolG0?l004P0oooo303o001_0?ooo`00
7P3oool30?l009D0oooo00<000000?ooo`3oool06`3oool:0?l000T0oooo203o00150?ooo`h0o`00
KP3oool001h0oooo103o002D0?ooo`030000003oool0oooo01X0oooo1P3o000A0?ooo`L0o`00@P3o
ool@0?l006d0oooo000O0?ooo`<0o`00U03oool00`000000oooo0?ooo`0H0?ooo`H0o`005@3oool6
0?l00400oooo4@3o001]0?ooo`007`3oool40?l009<0oooo00<000000?ooo`3oool05P3oool60?l0
01T0oooo1P3o000o0?oooa40o`00K03oool00200oooo0`3o002C0?ooo`030000003oool0oooo01H0
oooo1@3o000L0?ooo`H0o`00?`3oool@0?l006/0oooo000P0?ooo`<0o`00T`3oool00`000000oooo
0?ooo`0E0?ooo`@0o`007`3oool50?l00440oooo3`3o001Z0?ooo`00803oool40?l00980oooo00<0
00000?ooo`3oool0503oool40?l00280oooo103o00120?ooo`d0o`00JP3oool00240oooo0`3o002B
0?ooo`030000003oool0oooo01<0oooo103o000T0?ooo`<0o`00A03oool=0?l006P0oooo000Q0?oo
o`<0o`00TP3oool00`000000oooo0?ooo`0B0?ooo`@0o`009@3oool40?l004D0oooo303o001W0?oo
o`008@3oool40?l00940oooo00<000000?ooo`3oool04@3oool40?l002L0oooo103o00160?ooo`/0
o`00IP3oool00280oooo0`3o002A0?ooo`030000003oool0oooo0140oooo0`3o000Y0?ooo`@0o`00
A`3oool:0?l006D0oooo000R0?ooo`@0o`00T03oool00`000000oooo0?ooo`0@0?ooo`@0o`00:P3o
ool30?l004T0oooo2@3o001T0?ooo`008`3oool30?l00900oooo00<000000?ooo`3oool0403oool3
0?l002/0oooo0`3o001;0?ooo`T0o`00HP3oool002<0oooo0`3o002@0?ooo`030000003oool0oooo
0100oooo0`3o000[0?ooo`@0o`00C03oool80?l00640oooo000S0?ooo`@0o`00S`3oool00`000000
oooo0?ooo`0?0?ooo`@0o`00;03oool30?l004h0oooo1`3o001P0?ooo`00903oool30?l008l0oooo
00<000000?ooo`3oool03`3oool30?l002d0oooo103o001?0?ooo`H0o`00G`3oool002@0oooo0`3o
002?0?ooo`030000003oool0oooo00h0oooo103o000^0?ooo`<0o`00DP3oool40?l005h0oooo000T
0?ooo`<0o`00S`3oool00`000000oooo0?ooo`0>0?ooo`<0o`00;`3oool30?l005<0oooo1@3o001L
0?ooo`009@3oool30?l008h0oooo00<000000?ooo`3oool03P3oool30?l002l0oooo103o001C0?oo
o`D0o`00F`3oool002D0oooo0`3o002>0?ooo`030000003oool0oooo00h0oooo0`3o000`0?ooo`<0
o`00E@3oool40?l005X0oooo000U0?ooo`<0o`00SP3oool00`000000oooo0?ooo`0>0?ooo`<0o`00
<03oool30?l005H0oooo103o001I0?ooo`009@3oool30?l008h0oooo00<000000?ooo`3oool03P3o
ool30?l00300oooo0`3o001G0?ooo`@0o`00F03oool002D0oooo0`3o002>0?ooo`030000003oool0
oooo00h0oooo0`3o000`0?ooo`<0o`00F03oool50?l005H0oooo000V0?ooo`<0o`00S@3oool00`00
0000oooo0?ooo`0>0?ooo`<0o`00<03oool30?l005T0oooo1@3o001E0?ooo`009P3oool30?l008d0
oooo00<000000?ooo`3oool03P3oool30?l00300oooo0`3o001K0?ooo`@0o`00E03oool002H0oooo
103o002<0?ooo`030000003oool0oooo00h0oooo0`3o000`0?ooo`<0o`00G03oool40?l005<0oooo
000V0?ooo`@0o`00S03oool00`000000oooo0?ooo`0>0?ooo`<0o`00<03oool30?l005d0oooo103o
001B0?ooo`009P3oool50?l008/0oooo00<000000?ooo`3oool03P3oool30?l00300oooo0`3o001N
0?ooo`D0o`00D03oool002H0oooo1@3o002;0?ooo`030000003oool0oooo00h0oooo0`3o000_0?oo
o`@0o`00G`3oool50?l004l0oooo000V0?ooo`H0o`00RP3oool00`000000oooo0?ooo`0>0?ooo`<0
o`00;`3oool40?l00640oooo103o001>0?ooo`009P3oool60?l008X0oooo00<000000?ooo`3oool0
3P3oool30?l002h0oooo1@3o001R0?ooo`@0o`00C@3oool002H0oooo1`3o00290?ooo`030000003o
ool0oooo00h0oooo0`3o000]0?ooo`D0o`00I03oool40?l004`0oooo000V0?ooo`L0o`00R@3oool0
0`000000oooo0?ooo`0>0?ooo`@0o`00;03oool50?l006D0oooo1@3o001:0?ooo`009P3oool80?l0
08P0oooo00<000000?ooo`3oool03`3oool30?l002/0oooo1P3o001V0?ooo`D0o`00B@3oool002H0
oooo203o00280?ooo`030000003oool0oooo00l0oooo103o000Y0?ooo`L0o`00J03oool40?l004P0
oooo000V0?ooo`T0o`00Q`3oool00`000000oooo0?ooo`0@0?ooo`<0o`00:@3oool70?l006T0oooo
103o00170?ooo`009P3oool90?l008L0oooo00<000000?ooo`3oool0403oool40?l002L0oooo203o
001Z0?ooo`@0o`00AP3oool002H0oooo2P3o00260?ooo`030000003oool0oooo0140oooo0`3o000W
0?ooo`P0o`00J`3oool50?l004@0oooo000V0?ooo`X0o`00QP3oool00`000000oooo0?ooo`0A0?oo
o`@0o`009@3oool90?l006`0oooo1@3o00130?ooo`009P3oool;0?l008D0oooo00<000000?ooo`3o
ool04P3oool40?l002D0oooo203o001^0?ooo`@0o`00@P3oool002H0oooo2`3o00250?ooo`030000
003oool0oooo01<0oooo103o000T0?ooo`<0o`000P3oool30?l006l0oooo103o00110?ooo`009P3o
ool<0?l008@0oooo00<000000?ooo`3oool0503oool40?l00280oooo103o001e0?ooo`D0o`00?`3o
ool002H0oooo303o00240?ooo`030000003oool0oooo01D0oooo103o000P0?ooo`@0o`00M`3oool5
0?l003h0oooo000V0?ooo`d0o`00P`3oool00`000000oooo0?ooo`0F0?ooo`<0o`007`3oool40?l0
07X0oooo103o000m0?ooo`009P3oool=0?l008<0oooo00<000000?ooo`3oool05P3oool50?l001/0
oooo1@3o001l0?ooo`D0o`00>`3oool002H0oooo3P3o00220?ooo`030000003oool0oooo01L0oooo
1`3o000G0?ooo`D0o`00OP3oool50?l003X0oooo000V0?ooo`/0o`00Q@3oool00`000000oooo0?oo
o`0H0?ooo`P0o`004`3oool60?l00800oooo1@3o000i0?ooo`009P3oool70?l008T0oooo00<00000
0?ooo`3oool06P3oool80?l000l0oooo1P3o00240?ooo`@0o`00>03oool002H0oooo0`3o00020?oo
o`<0o`00R03oool00`000000oooo0?ooo`0M0?ooo`X0o`00103oool;0?l000D0oooo00<0j[Yb0000
LP2jj_l0OP3oool50?l003H0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`0O0?oooaD0
o`001`3oool00`3oj[X0LP00002Ke0070?ooo`050?oZ^P1b000000000000002Ke?l0L`3oool50?l0
03D0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`0Q0?oooa40o`002P3oool00`3DV`00
002K0=Coo`070?ooo`030?ooe02K0780^^[o07D0oooo1@3o000d0?ooo`00:`3oool30?l008P0oooo
00<000000?ooo`3oool09P3oool60?l00100oooo00<0oooD09/0002Ke?l01`3oool00`3oom@0V`1b
0;[Zo`1g0?ooo`@0o`00<`3oool002/0oooo0`3o00280?ooo`030000003oool0oooo03d0oooo00<0
omBK002Ke03oool01P3oool00`3oom@0V`1b0;[Zo`1h0?ooo`@0o`00<P3oool002/0oooo0`3o0028
0?ooo`030000003oool0oooo03d0oooo00<0oooD09/0LP2jj_l01P3oool00`3oom@0V`1b0;[Zo`1i
0?ooo`@0o`00<@3oool002/0oooo0`3o00280?ooo`030000003oool0oooo03d0oooo00@0oooD09/0
0000L[X0j_oo1@3oool00`3oom@0V`1b0;[Zo`1j0?ooo`@0o`00<03oool002/0oooo0`3o00280?oo
o`030000003oool0oooo03d0oooo00@0oooD09/0LP2KVg80L[[Z1@3oool00`3oom@0V`1b0;[Zo`1k
0?ooo`@0o`00;`3oool002/0oooo0`3o00280?ooo`030000003oool0oooo03d0oooo00D0onZj0780
LP2jj^X0^W8009_Do`040?ooo`030?ooe02K0780^^[o07`0oooo103o000^0?ooo`00:`3oool30?l0
08P0oooo00<000000?ooo`3oool0?@3oool01P3oe9/0001b0;[Zo`3oe9/0002K0=Coo`80oooo00@0
omBK000000000780^^[oO@3oool40?l002d0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?oo
o`0h0?ooo`030?oojP2jVkX0j_oo0080oooo00H0j[Yb0000LP2jj_l0oooo0=BK001b^^X30?ooo`03
0?oZ^P1b0780^^[o07h0oooo103o000/0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0
>@3oool02`3Z^W80L[[Z0?ooo`3oj[X0LP00001b^P3Zool0oooo0?oDV`000780^^[o08@0oooo0`3o
000/0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0>@3oool00`3oonX0^W8000000002
0000000607:jjP3oool0oooo0?oojP2jLP0009_DQ03oool40?l002/0oooo000[0?ooo`<0o`00R03o
ool00`000000oooo0?ooo`0j0?ooo`050?oojP2jLP000000001b^P3Zool00`3oool00`3oe9/0001b
0;[Zo`240?ooo`@0o`005P3oool01P3DV`0000000000002Ke?l0oooo0>ZjLP<0000000<007:j0>[o
o`3oool0203oool002/0oooo0`3o00280?ooo`030000003oool0oooo0<X0oooo0`3o000G0?ooo`03
0=BK002Ke?l0oooo0080oooo00<0j[Yb00000000Vm@02`3oool002/0oooo0`3o00280?ooo`030000
003oool0oooo0<X0oooo103o000F0?ooo`080?oojP2jLY/0e?oo0?ooo`3oj[X0LP00001b^P3Zool;
0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0b`3oool30?l001L0oooo00H0onZj079b
^P3ZonX0^W800000LP2jj_l<0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0b`3oool3
0?l001P0oooo00@0omBK000000000000VmCo3@3oool002/0oooo0`3o00280?ooo`030000003oool0
oooo0</0oooo0`3o000H0?ooo`030?oZ^P1b000009_D00h0oooo00050?ooobH000000`3o003o0000
05L000000`3o0009000000h0oooo00D0oooD09/000000000002K0=Coo`0=0?ooo`00:`3oool30?l0
08P0oooo00<000000?ooo`3oool0b`3oool30?l001L0oooo00H0e9/00000002Ke?l0onZj079b^P3Z
ool<0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0b`3oool30?l001H0oooo00L0j[Yb
00000000L[X0j_oo0?ooo`3Z^W8009_D00`0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?oo
o`3:0?ooo`@0o`005@3oool02P3DV`000000000000000000L[[Z0?oZ^P1b00000000001b^P3Zool:
0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0bP3oool30?l002X0oooo000[0?ooo`<0
o`00R03oool00`000000oooo0?ooo`3:0?ooo`<0o`00:P3oool002/0oooo0`3o00280?ooo`030000
003oool0oooo0<T0oooo103o000Z0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0b@3o
ool30?l002/0oooo000[0?ooo`<0o`00R03oool00`000000oooo0?ooo`380?ooo`@0o`00:`3oool0
02/0oooo0`3o00280?ooo`030000003oool0oooo0<L0oooo103o000/0?ooo`00:`3oool30?l008P0
oooo00<000000?ooo`3oool0aP3oool40?l002d0oooo000[0?ooo`<0o`00R03oool00`000000oooo
0?ooo`350?ooo`@0o`00;P3oool002/0oooo0`3o00280?ooo`030000003oool0oooo0<@0oooo103o
000_0?ooo`00:`3oool30?l008P0oooo00<000000?ooo`3oool0``3oool40?l00300oooo000[0?oo
o`<0o`00R03oool00`000000oooo0?ooo`320?ooo`@0o`00<@3oool002/0oooo0`3o00280?ooo`03
0000003oool0oooo0<40oooo103o000b0?ooo`00:`3oool30?l005T0oooo203o000W0?ooo`030000
003oool0oooo0<00oooo103o000c0?ooo`00:`3oool30?l005@0oooo4P3o000R0?ooo`030000003o
ool0oooo0;l0oooo103o000d0?ooo`00:`3oool30?l00580oooo5`3o000O0?ooo`030000003oool0
oooo0;h0oooo103o000e0?ooo`00:P3oool40?l00540oooo2@3o00060?ooo`/0o`007@3oool00`00
0000oooo0?ooo`2m0?ooo`@0o`00=P3oool002X0oooo0`3o001@0?ooo`H0o`00403oool70?l001`0
oooo00<000000?ooo`3oool0^`3oool50?l003L0oooo000Z0?ooo`<0o`00CP3oool60?l001D0oooo
1@3o000K0?ooo`030000003oool0oooo0;X0oooo1@3o000h0?ooo`00:P3oool30?l004d0oooo1P3o
000H0?ooo`D0o`006@3oool00`000000oooo0?ooo`2i0?ooo`@0o`00>P3oool002X0oooo0`3o001<
0?ooo`D0o`006`3oool50?l001P0oooo00<000000?ooo`3oool0]`3oool50?l003/0oooo000Z0?oo
o`<0o`00BP3oool50?l001h0oooo1@3o000G0?ooo`030000003oool0oooo0;H0oooo1@3o000l0?oo
o`00:@3oool30?l004/0oooo103o000Q0?ooo`@0o`005P3oool00`000000oooo0?ooo`2e0?ooo`D0
o`00?@3oool002T0oooo0`3o001:0?ooo`@0o`008`3oool40?l001D0oooo00<000000?ooo`3oool0
]03oool40?l003l0oooo000Y0?ooo`<0o`00B@3oool40?l002D0oooo103o000D0?ooo`030000003o
ool0oooo0;80oooo1@3o00100?ooo`00:@3oool30?l004P0oooo103o000W0?ooo`@0o`004`3oool0
0`000000oooo0?ooo`2a0?ooo`D0o`00@@3oool002T0oooo0`3o00180?ooo`<0o`00:@3oool30?l0
01<0oooo00<000000?ooo`3oool0/03oool50?l00480oooo000Y0?ooo`<0o`00A`3oool40?l002T0
oooo103o000B0?ooo`030000003oool0oooo0:h0oooo1@3o00140?ooo`00:@3oool30?l004L0oooo
0`3o000[0?ooo`<0o`004P3oool00`000000oooo0?ooo`2]0?ooo`D0o`00A@3oool002P0oooo0`3o
00180?ooo`<0o`00:`3oool40?l00140oooo00<000000?ooo`3oool0[03oool50?l004H0oooo000X
0?ooo`<0o`00A`3oool40?l002`0oooo0`3o000A0?ooo`030000003oool0oooo0:/0oooo103o0018
0?ooo`00:03oool30?l004L0oooo0`3o000]0?ooo`@0o`00403oool00`000000oooo0?ooo`2Y0?oo
o`D0o`00B@3oool002P0oooo0`3o00160?ooo`@0o`00;P3oool30?l00100oooo00<000000?ooo`3o
ool0Z03oool50?l004X0oooo000X0?ooo`<0o`00AP3oool30?l002l0oooo0`3o000@0?ooo`030000
003oool0oooo0:L0oooo1@3o001;0?ooo`00:03oool30?l004H0oooo0`3o000_0?ooo`@0o`003`3o
ool00`000000oooo0?ooo`2U0?ooo`D0o`00C@3oool002L0oooo103o00160?ooo`<0o`00<03oool3
0?l000l0oooo00<000000?ooo`3oool0Y03oool50?l004h0oooo000W0?ooo`<0o`00A`3oool30?l0
0300oooo0`3o000?0?ooo`030000003oool0oooo0:<0oooo1@3o001?0?ooo`009`3oool30?l004H0
oooo103o000`0?ooo`<0o`003`3oool00`000000oooo0?ooo`2Q0?ooo`D0o`00D@3oool002L0oooo
0`3o00160?ooo`<0o`00<@3oool30?l000l0oooo00<000000?ooo`3oool0X03oool50?l00580oooo
000V0?ooo`@0o`00AP3oool30?l00340oooo0`3o000?0?ooo`030000003oool0oooo09l0oooo1@3o
001C0?ooo`009P3oool30?l004L0oooo0`3o000a0?ooo`<0o`003`3oool00`000000oooo0?ooo`2N
0?ooo`@0o`00E@3oool002H0oooo0`3o00170?ooo`<0o`00<@3oool30?l000l0oooo00<000000?oo
o`3oool0W03oool50?l005H0oooo000V0?ooo`<0o`00A`3oool30?l00340oooo0`3o000?0?ooo`03
0000003oool0oooo09/0oooo1@3o001G0?ooo`009@3oool40?l004L0oooo103o000_0?ooo`@0o`00
3`3oool00`000000oooo0?ooo`0Y0?ooo`030?oojP2jLP00000000L0000000<007:j0>[oo`3oool0
I03oool50?l005P0oooo000U0?ooo`<0o`00B@3oool30?l002l0oooo103o000?0?ooo`030000003o
ool0oooo02/0oooo00@0oooZ0;Yb000009/0e?oo0`3oool01@3oe9/0000000000000L[X0j_oo0640
oooo1@3o001J0?ooo`009@3oool30?l004T0oooo0`3o000^0?ooo`D0o`003`3oool00`000000oooo
0?ooo`0[0?ooo`040?oojP2jLP00002K0=Coo`@0oooo00D0oooZ0;Yb0000000007:j0>[oo`1O0?oo
o`D0o`00F`3oool002D0oooo0`3o00190?ooo`<0o`00;P3oool50?l000l0oooo00<000000?ooo`3o
ool0:`3oool0103oonX0^W800000V`3Dool50?ooo`040?ooe02K0000000007:jjUh0oooo1@3o001L
0?ooo`00903oool40?l004T0oooo0`3o000]0?ooo`D0o`00403oool00`000000oooo0?ooo`0[0?oo
o`040?oojP2jLP00002K0=Coo`H0oooo00@0j[Yb00000000L[X0j_ooF`3oool50?l005h0oooo000T
0?ooo`<0o`00BP3oool40?l002`0oooo1@3o000@0?ooo`030000003oool0oooo02/0oooo00@0oooZ
0;Yb000009/0e?oo1P3oool0103oj[X0LP000000LP2jj_mJ0?ooo`D0o`00G`3oool002@0oooo0`3o
001;0?ooo`<0o`00:`3oool60?l00100oooo00<000000?ooo`3oool0:`3oool0103oonX0^W800000
V`3Dool60?ooo`040?ooe02K0000000009_DoeT0oooo1@3o001P0?ooo`008`3oool40?l004/0oooo
103o000Z0?ooo`H0o`00403oool00`000000oooo0?ooo`0[0?ooo`040?oojP2jLP00002K0=Coo`H0
oooo00@0oooD09/000000000VmCoE`3oool50?l00680oooo000S0?ooo`<0o`00C@3oool30?l002T0
oooo1`3o000@0?ooo`030000003oool0oooo02/0oooo00@0oooZ0;Yb000009/0e?oo1P3oool0103o
j[X0LP000000LP2jj_mF0?ooo`D0o`00H`3oool00280oooo103o001=0?ooo`@0o`00:03oool70?l0
0100oooo00<000000?ooo`3oool0:`3oool0103oonX0^W800000V`3Dool60?ooo`040>ZjLP000000
002K0=CooeD0oooo1@3o001T0?ooo`008P3oool30?l004l0oooo0`3o000W0?ooo`P0o`00403oool0
0`000000oooo0?ooo`0[0?ooo`040?oojP2jLP00002K0=Coo`D0oooo00@0oooD09/000000000L[[Z
E@3oool40?l006H0oooo000R0?ooo`<0o`00C`3oool40?l002H0oooo203o000@0?ooo`030000003o
ool0oooo02/0oooo00@0oooZ0;Yb000009/0e?oo103oool01@3oonX0^W8000000000L[X0j_oo05<0
oooo1@3o001W0?ooo`008@3oool40?l00500oooo103o000V0?ooo`L0o`00403oool00`000000oooo
0?ooo`0[0?ooo`040?oojP2jLP00002K0=Coo`<0oooo00D0omBK000000000000002K0=Coo`1C0?oo
o`D0o`00J03oool00240oooo0`3o001B0?ooo`<0o`009@3oool40?l001@0oooo00<000000?ooo`3o
ool0:@3oool00`3oonX0^W8000000007000000030000LP2jj_l0oooo05<0oooo1@3o001Y0?ooo`00
803oool40?l00580oooo103o000S0?ooo`@0o`005@3oool00`000000oooo0?ooo`270?ooo`D0o`00
J`3oool00200oooo0`3o001D0?ooo`@0o`008@3oool40?l001H0oooo00<000000?ooo`3oool0QP3o
ool50?l006`0oooo000P0?ooo`<0o`00E03oool50?l001h0oooo1@3o000G0?ooo`030000003oool0
oooo08D0oooo1@3o001]0?ooo`007`3oool40?l005H0oooo1@3o000K0?ooo`D0o`00603oool00`00
0000oooo0?ooo`240?ooo`@0o`00K`3oool001l0oooo0`3o001H0?ooo`H0o`00603oool50?l001T0
oooo00<000000?ooo`3oool0P`3oool40?l00700oooo000O0?ooo`<0o`00F@3oool60?l001D0oooo
1@3o000K0?ooo`030000003oool0oooo0880oooo103o001a0?ooo`007P3oool40?l005/0oooo1P3o
000@0?ooo`L0o`00703oool00`000000oooo0?ooo`210?ooo`@0o`00LP3oool001h0oooo0`3o001N
0?ooo`T0o`001P3oool;0?l000D0oooo00<0j[Yb0000LP2jj_l05@3oool00`000000oooo0?ooo`20
0?ooo`@0o`00L`3oool001h0oooo0`3o001O0?oooaL0o`001`3oool00`3oj[X0LP00002Ke0050?oo
o`030=BK0000000000000080000000<0002K0=Coo`3oool0203oool00`000000oooo0?ooo`1o0?oo
o`@0o`00M03oool001d0oooo103o001Q0?oooa80o`002`3oool00`3DV`00002K0=Coo`050?ooo`06
0>ZjLP2Ke?l0oooo0?ooo`3oe9/0VmCo2@3oool00`000000oooo0?ooo`1n0?ooo`@0o`00M@3oool0
01d0oooo0`3o001W0?ooo`P0o`00403oool00`3oom@0V`0009_Do`060?ooo`030=BKLP2jj_l0oooo
00/0oooo00<000000?ooo`3oool0O@3oool40?l007H0oooo000M0?ooo`<0o`00P03oool00`3oe9/0
09_D0?ooo`050?ooo`030?oojP2jLY/0e?oo00/0oooo00<000000?ooo`3oool0O03oool40?l007L0
oooo000L0?ooo`@0o`00P03oool00`3oom@0V`1b0;[Zo`060?ooo`030?oZ^P1bVm@0oooo00X0oooo
00<000000?ooo`3oool0N`3oool40?l007P0oooo000L0?ooo`<0o`00P@3oool0103oom@0V`00001b
^P3Zool60?ooo`030=BK002Ke?l0oooo00T0oooo00<000000?ooo`3oool0NP3oool40?l007T0oooo
000L0?ooo`<0o`00P@3oool0103oom@0V`1b09^KLP1b^^X60?ooo`030?oDV`00Vm@0oooo00T0oooo
00<000000?ooo`3oool0N@3oool40?l007X0oooo000K0?ooo`@0o`00P@3oool0203oj[X0LP1b0;[Z
jP2jLP00VmCo0?ooo`3Ze=@0j_oo0P3oool00`3Z^W8007:j0>[oo`090?ooo`030000003oool0oooo
07P0oooo103o001k0?ooo`006`3oool30?l00880oooo00`0omBK0000LP2jj_l0omBK0000V`3Dool0
onZj07:Ke03oool0oooD09/00000Vm@:0?ooo`030000003oool0oooo07L0oooo103o001l0?ooo`00
6`3oool30?l007d0oooo00<0oooZ0;ZK^P3Zool00P3oool0203Z^W80001b0;[Zo`3oool0e9/007:j
jP3oool0omBK0P0000000`00L[X0j_oo0?ooo`090?ooo`030000003oool0oooo07H0oooo103o001m
0?ooo`006P3oool40?l007h0oooo00/0j[Yb07:jjP3oool0onZj07800000L[X0j_oo0?ooo`3oe9/0
001b0;[Zo`0?0?ooo`030000003oool0oooo07D0oooo103o001n0?ooo`006P3oool30?l007l0oooo
00<0oooZ0;Yb000000000P0000001P1b^^X0oooo0?ooo`3oonX0^W80002Ke0l0oooo00<000000?oo
o`3oool0M03oool40?l007l0oooo000I0?ooo`@0o`00P03oool01@3oonX0^W8000000000L[X0j_oo
00<0oooo00<0omBK0000LP2jj_l03P3oool00`000000oooo0?ooo`1c0?ooo`@0o`00P03oool001T0
oooo0`3o002J0?ooo`030000003oool0oooo0780oooo103o00210?ooo`00603oool40?l009X0oooo
00<000000?ooo`3oool0L@3oool40?l00880oooo000H0?ooo`<0o`00V`3oool00`000000oooo0?oo
o`1`0?ooo`@0o`00P`3oool001P0oooo0`3o002K0?ooo`030000003oool0oooo06l0oooo103o0024
0?ooo`005`3oool40?l009/0oooo00<000000?ooo`3oool0KP3oool40?l008D0oooo000G0?ooo`<0
o`00W03oool00`000000oooo0?ooo`1]0?ooo`@0o`00QP3oool001H0oooo103o002L0?ooo`030000
003oool0oooo06`0oooo103o00270?ooo`005P3oool30?l009d0oooo00<000000?ooo`3oool0K03o
ool30?l008P0oooo000E0?ooo`@0o`00W@3oool00`000000oooo0?ooo`1[0?ooo`<0o`00R@3oool0
01D0oooo0`3o002N0?ooo`030000003oool0oooo06X0oooo103o00290?ooo`005@3oool30?l009h0
oooo00<000000?ooo`3oool0JP3oool30?l008X0oooo000D0?ooo`@0o`00WP3oool00`000000oooo
0?ooo`1Y0?ooo`<0o`00R`3oool001@0oooo0`3o002O0?ooo`030000003oool0oooo06P0oooo103o
000?0?ooo`030>ZjLP000780^^[o07T0oooo000C0?ooo`@0o`00W`3oool00`000000oooo0?ooo`1W
0?ooo`@0o`00403oool00`3oj[X0LP00002Ke01i0?ooo`004`3oool30?l00:00oooo00<000000?oo
o`3oool0I`3oool30?l00180oooo00<0e9/00000V`3Dool0N03oool00180oooo103o002P0?ooo`03
0000003oool0oooo06H0oooo0`3o000C0?ooo`030?ooe02K0000VmCo07P0oooo000B0?ooo`<0o`00
X@3oool00`000000oooo0?ooo`1U0?ooo`@0o`00503oool00`3oe9/009_D0?ooo`1g0?ooo`004@3o
ool40?l00:40oooo00<000000?ooo`3oool0I03oool40?l001D0oooo00<0oooD09/0LP2jj_l0M`3o
ool00140oooo0`3o002R0?ooo`030000003oool0oooo06@0oooo0`3o000F0?ooo`040?ooe02K0000
07:j0>[oogH0oooo000A0?ooo`<0o`00XP3oool00`000000oooo0?ooo`1S0?ooo`<0o`005`3oool0
103oom@0V`1b09^KLP1b^^Yf0?ooo`00403oool40?l00:80oooo00<000000?ooo`3oool0F@3oool0
0`3o0000oooo0?ooo`060?ooo`@0o`005`3oool01@3oj[X0LP1b0;[ZjP2jLP00VmCo07D0oooo000@
0?ooo`<0o`00X`3oool00`000000oooo0?ooo`1I0?ooo`<0o`001@3oool40?l001P0oooo00H0omBK
0000LP2jj_l0omBK0000V`3Doomd0?ooo`003`3oool40?l00:<0oooo00<000000?ooo`3oool0F03o
ool60?l000<0oooo0`3o000D0?ooo`030?oojP2jVkX0j_oo0080oooo00H0j[Yb0000LP2jj_l0oooo
0=BK001b^^Yd0?ooo`003`3oool30?l00:@0oooo00<000000?ooo`3oool0F03oool70?l000040?oo
o`3o0000o`000?l001H0oooo00/0j[Yb07:jjP3oool0onZj07800000L[X0j_oo0?ooo`3oe9/0001b
0;[Zo`1c0?ooo`003`3oool30?l00:@0oooo00<000000?ooo`3oool0F03oool;0?l001H0oooo00<0
oooZ0;Yb000000000P0000001P1b^^X0oooo0?ooo`3oonX0^W80002Ke7<0oooo000>0?ooo`@0o`00
Y03oool00`000000oooo0?ooo`1H0?ooo`/0o`005`3oool01@3oonX0^W8000000000L[X0j_oo00<0
oooo00<0omBK0000LP2jj_l0LP3oool000h0oooo0`3o002U0?ooo`030000003oool0oooo05L0oooo
3P3o002B0?ooo`003P3oool30?l00:D0oooo00<000000?ooo`3oool0E`3oool?0?l00940oooo000>
0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`1G0?ooo`h0o`00TP3oool000h0oooo0`3o002U0?oo
o`030000003oool0oooo05H0oooo3P3o002C0?ooo`003P3oool30?l00:D0oooo00<000000?ooo`3o
ool0EP3oool=0?l009@0oooo000>0?ooo`<0o`00Y@3oool00`000000oooo0?ooo`1F0?ooo``0o`00
U@3oool000h0oooo0`3o002U0?ooo`030000003oool0oooo05D0oooo303o002F0?ooo`003P3oool4
0?l00:@0oooo00<000000?ooo`3oool0E@3oool;0?l009L0oooo000>0?ooo`@0o`00Y03oool00`00
0000oooo0?ooo`1E0?ooo`X0o`00V03oool000h0oooo103o002T0?ooo`030000003oool0oooo05D0
oooo2@3o002I0?ooo`003`3oool40?l00:<0oooo00<000000?ooo`3oool0E03oool90?l009X0oooo
000?0?ooo`H0o`00X@3oool00`000000oooo0?ooo`1D0?ooo`P0o`00V`3oool00100oooo1`3o002O
0?ooo`030000003oool0oooo05@0oooo1`3o002L0?ooo`004P3oool80?l009`0oooo00<000000?oo
o`3oool0D`3oool70?l009d0oooo000D0?ooo`X0o`00V03oool00`000000oooo0?ooo`1C0?ooo`H0
o`00WP3oool001H0oooo3@3o002C0?ooo`030000003oool0oooo05<0oooo1@3o002O0?ooo`006P3o
ool?0?l008d0oooo00<000000?ooo`3oool0DP3oool50?l00:00oooo000N0?oooa80o`00QP3oool0
0`000000oooo0?ooo`1B0?ooo`@0o`00X@3oool002<0oooo4`3o00200?ooo`030000003oool0oooo
0580oooo103o002Q0?ooo`00:@3ooolC0?l007X0oooo00<000000?ooo`3oool0DP3oool30?l00:80
oooo000`0?oooa<0o`00L`3oool00`000000oooo0?ooo`1A0?ooo`@0o`00XP3oool003H0oooo4`3o
001]0?ooo`030000003oool0oooo0540oooo0`3o002S0?ooo`00?03ooolC0?l006L0oooo00<00000
0?ooo`3oool0D03oool40?l00:<0oooo00130?oooa40o`00403oool>0?l004@0oooo00<000000?oo
o`3oool0D03oool30?l00:@0oooo00190?ooobT0o`00A03oool00`000000oooo0?ooo`1?0?ooo`@0
o`00Y03oool004l0oooo8`3o00140?ooo`030000003oool0oooo04l0oooo0`3o002U0?ooo`00E03o
oolN0?l004@0oooo00<000000?ooo`3oool0CP3oool40?l00:D0oooo001J0?oooaL0o`00A@3oool0
0`000000oooo0?ooo`1=0?ooo`@0o`00YP3oool005d0oooo503o00150?ooo`030000003oool0oooo
04d0oooo0`3o002W0?ooo`00G`3ooolE0?l00480oooo00<000000?ooo`3oool0C03oool40?l00:L0
oooo001Q0?oooaL0o`00?P3oool00`000000oooo0?ooo`1<0?ooo`<0o`00Z03oool006@0oooo603o
000j0?ooo`030000003oool0oooo04/0oooo103o002X0?ooo`00IP3oool;0?l000<0oooo303o000f
0?ooo`030000003oool0oooo04/0oooo0`3o002Y0?ooo`00J03oool80?l000P0oooo303o000b0?oo
o`030000003oool0oooo04X0oooo103o002Y0?ooo`00JP3oool60?l000`0oooo303o000^0?ooo`03
0000003oool0oooo04X0oooo0`3o002Z0?ooo`00K03oool40?l00100oooo303o000Z0?ooo`030000
003oool0oooo04T0oooo103o002Z0?ooo`00KP3oool20?l001@0oooo303o000V0?ooo`030000003o
ool0oooo04T0oooo0`3o002[0?ooo`00R03oool<0?l00280oooo00<000000?ooo`3oool0B@3oool3
0?l00:/0oooo002<0?ooo``0o`007P3oool00`000000oooo0?ooo`180?ooo`@0o`00Z`3oool00900
oooo303o000J0?ooo`030000003oool0oooo04P0oooo0`3o002/0?ooo`00U03oool;0?l001L0oooo
00<000000?ooo`3oool0A`3oool40?l00:`0oooo002H0?ooo`X0o`00503oool00`000000oooo0?oo
o`170?ooo`<0o`00[@3oool009`0oooo2@3o000A0?ooo`030000003oool0oooo04L0oooo0`3o002]
0?ooo`00WP3oool90?l000l0oooo00<000000?ooo`3oool0AP3oool40?l00:d0oooo002Q0?ooo`T0
o`00303oool00`000000oooo0?ooo`160?ooo`<0o`00[P3oool00:@0oooo203o000:0?ooo`030000
003oool0oooo04H0oooo0`3o002^0?ooo`00YP3oool90?l000L0oooo00<000000?ooo`3oool0A@3o
ool40?l00:h0oooo002Y0?ooo`T0o`00103oool00`000000oooo0?ooo`150?ooo`<0o`00[`3oool0
0:/0oooo2@3o00020?ooo`030000003oool0oooo04D0oooo0`3o002_0?ooo`00[P3oool90?l004H0
oooo103o002_0?ooo`00/@3oool80?l004@0oooo0`3o002`0?ooo`00/`3oool90?l00440oooo0`3o
002`0?ooo`00]P3oool90?l003d0oooo103o002`0?ooo`00]P3oool00`000000oooo0?l000080?l0
03/0oooo0`3o002a0?ooo`00]P3oool00`000000oooo0?ooo`020?ooo`T0o`00>03oool30?l00;40
oooo002f0?ooo`030000003oool0oooo00D0oooo203o000e0?ooo`@0o`00/@3oool00;H0oooo00<0
00000?ooo`3oool01`3oool80?l003<0oooo0`3o002b0?ooo`00]P3oool00`000000oooo0?ooo`0:
0?ooo`P0o`00<03oool30?l00;80oooo002f0?ooo`030000003oool0oooo00`0oooo203o000^0?oo
o`<0o`00/P3oool00;H0oooo00<000000?ooo`3oool03P3oool80?l002`0oooo0`3o002b0?ooo`00
]P3oool00`000000oooo0?ooo`0A0?ooo`P0o`00:03oool30?l00;<0oooo002f0?ooo`030000003o
ool0oooo01<0oooo203o000V0?ooo`<0o`00/`3oool00;H0oooo00<000000?ooo`3oool05@3oool8
0?l002@0oooo0`3o002c0?ooo`00]P3oool00`000000oooo0?ooo`0H0?ooo`P0o`008@3oool30?l0
0;<0oooo002f0?ooo`030000003oool0oooo01X0oooo203o000N0?ooo`<0o`00]03oool00;H0oooo
00<000000?ooo`3oool0703oool70?l001d0oooo0`3o002d0?ooo`00]P3oool00`000000oooo0?oo
o`0O0?ooo`H0o`006`3oool30?l00;@0oooo002f0?ooo`030000003oool0oooo0240oooo1P3o000I
0?ooo`<0o`00]03oool00;H0oooo00<000000?ooo`3oool08P3oool70?l001L0oooo0`3o002d0?oo
o`00]P3oool00`000000oooo0?ooo`0T0?ooo`L0o`00503oool30?l00;D0oooo002f0?ooo`030000
003oool0oooo02H0oooo1`3o000B0?ooo`<0o`00]@3oool00;H0oooo00<000000?ooo`3oool0:03o
ool70?l00100oooo0`3o002e0?ooo`00]P3oool00`000000oooo0?ooo`0Z0?ooo`L0o`003P3oool3
0?l00;D0oooo002f0?ooo`030000003oool0oooo02`0oooo1`3o000<0?ooo`<0o`00]@3oool00;H0
oooo00<000000?ooo`3oool0;P3oool70?l000T0oooo103o002e0?ooo`00]P3oool00`000000oooo
0?ooo`0`0?ooo`L0o`001P3oool40?l00;H0oooo002f0?ooo`030000003oool0oooo0380oooo1`3o
00030?ooo`@0o`00]`3oool00;H0oooo00<000000?ooo`3oool0=03oool<0?l00;L0oooo002f0?oo
o`030000003oool0oooo03H0oooo2P3o002g0?ooo`00]P3oool00`000000oooo0?ooo`0h0?ooo`L0
o`00^03oool00;H0oooo00<000000?ooo`3oool0m`3oool00;H0oooo00<000000?ooo`3oool0m`3o
ool00;H0oooo00<000000?ooo`3oool0m`3oool00;H0oooo00<000000?ooo`3oool0m`3oool00;H0
oooo00<000000?ooo`3oool0m`3oool00;H0oooo00<000000?ooo`3oool0m`3oool00;H0oooo00<0
00000?ooo`3oool0m`3oool00;H0oooo00<000000?ooo`3oool0m`3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00;40oooo00@0omBK0000000009/0e?oon`3oool00;40oooo00D0
omBK00000000000007:j0>[oo`3j0?ooo`00]03oool00`3DV`00VmCo0?ooo`3i0?ooo`00]03oool0
0`3oj[X0LW:j0>[oo`3i0?ooo`00]@3oool00`3DVg80^^[o0?ooo`3h0?ooo`00]03oool00`3oonX0
^W8007:jjP3i0?ooo`00]03oool0103oe9/00000001b^P3Zoooh0?ooo`00]03oool0103DV`00002K
09^KLP2jj_oh0?ooo`00/`3oool01@3oj[X0LP0007:jjP3oe9/0L[[Z0?P0oooo002c0?ooo`060>Zj
LP0009/0e?oo0?ooe02K09/0e?oom`3oool00;80oooo00<0oooD09/0001b^^X00P3oool00`3Z^W80
VmCo0?ooo`3f0?ooo`00/P3oool00`3Z^W80001b0;[Zo`020?ooo`030?oZ^P1bVm@0oooo0?H0oooo
002a0?ooo`040?ooe02K000007:j0>[oo`80oooo00<0oooZ0;YbV`3Dool0mP3oool00;00oooo00/0
oooZ0;Yb000000000000001b^P3Zool0oooo0=BK0000000007:j0>[oo`3e0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {426.125, 0}} -> {-2.12171, -2.25581, \
0.0173967, 0.0173967}}]
}, Open  ]],

Cell["\<\
Naturalmente, la raz\[OAcute]n de considerar dominios con agujeros es porque \
se supone que en esos agujeros el campo tiene alg\[UAcute]n tipo de \
singularidad. Con frecuencia un agujero est\[AAcute] producido por un punto \
en el que el campo se hace infinito.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Comprueba la validez del teorema de Green en cada uno de los siguientes \
casos.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{"x", " ", \(y\^2\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "-", " ", 
              RowBox[{"y", " ", \(x\^2\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{"x", " ", "y", " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox[" ",
                FontWeight->"Bold"], "+", " ", 
              RowBox[{\(y\^3\), " ", \(x\^2\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = \([\((0, 0)\), \((1, 0)\), \((1, 2)\), \((0, 0)\)]\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\((x\^2 + \ y\^2)\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{"2", "x", " ", "y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", \[Gamma] es el camino obtenido por la yuxtaposici\[OAcute]n del segmento \
de par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  " de (0,0) a (2,4) y de la poligonal ",
  Cell[BoxData[
      \(TraditionalForm\`\([\((2, 4)\), \((0, 4)\), \((0, 0)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Utiliza el teorema de Green para calcular el \[AAcute]rea de las regiones \
del plano limitadas por las siguientes curvas.\na) La elipse, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((a\ cos\ t, b\ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0, \ b > 0\)]],
  ".\nb) La astroide, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((a\ \(cos\^3\) t, \ a\ \(sen\^3\) t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  ".\nc) Un arco de cicloide, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{\(a(t - sen\ t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(a(1 - cos\ t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0. \)]],
  "\nd) Una poligonal cerrada orientada positivamente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma] = \([\((x\_1, y\_1)\), \)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\((x\_2, y\_2)\)\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_3, y\_3)\)\)]],
  ",...,",
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\_n, y\_n)\), \((x\_1, y\_1)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Utiliza el teorema de Green para calcular las siguientes integrales de l\
\[IAcute]nea.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\(\[ExponentialE]\^\(\ y\)\) \[DifferentialD]x\)}], "+", 
          \(2  x\ \(\[ExponentialE]\^\(\ y\)\) \[DifferentialD]y\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = 
        \([\((0, 0)\), \((1, 0)\), \((1, 1)\), \((0, 1)\), \((0, 0)\)]\)\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\(x\^2\) \(y\^2\) \[DifferentialD]x\)}], "+", 
          \(4  x\ \(y\^3\) \[DifferentialD]y\)}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] = \([\((0, 0)\), \((1, 3)\), \((0, 3)\), \((0, 0)\)]\)\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\((y + \[ExponentialE]\^\(\ x\^3\))\) \[DifferentialD]x\)}], 
          "+", \(\((2  x + cos\ y\^2)\) \[DifferentialD]y\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          StyleBox[" ",
            FontWeight->"Bold"]}], TraditionalForm]]],
  "es la curva frontera de la regi\[OAcute]n limitada por las \
par\[AAcute]bolas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x = y\^2\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox["\[Integral]", 
              StyleBox["\[Gamma]",
                FontWeight->"Bold"]], " ", 
            \(\((x\^3 - \(\(y\^3\)\^\ \))\) \[DifferentialD]x\)}], "+", 
          \(\((x\^3 + \ y\^3)\) \[DifferentialD]y\)}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[Gamma]", 
          StyleBox[" ",
            FontWeight->"Bold"]}], TraditionalForm]]],
  "es la curva frontera de la regi\[OAcute]n limitada por las circunferencias \
",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 9\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "a) El centroide de una regi\[OAcute]n plana ",
  Cell[BoxData[
      \(TraditionalForm\`D \[Subset] \[DoubleStruckCapitalR]\^2\)]],
  "se define como el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((c\_1, c\_2)\)\)]],
  " cuyas coordenadas vienen dadas por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(c\_1\), "=", 
          RowBox[{\(1\/\(\[CapitalAAcute]rea \((D)\)\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], " ", 
                \(x\ \[DifferentialD]\((x, y)\)\)}]}]}]}], ",", "    ", 
        RowBox[{\(c\_2\), "=", 
          RowBox[{\(1\/\(\[CapitalAAcute]rea \((D)\)\)\), 
            RowBox[{"\[Integral]", 
              RowBox[{
                SubscriptBox["\[Integral]", 
                  StyleBox["D",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]], " ", 
                \(y\ \[DifferentialD]\((x, y)\)\)}]}]}]}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " es la regi\[OAcute]n limitada por un camino cerrado simple, \[Gamma], \
justifica que"
}], "ExerciseText"],

Cell[BoxData[
    \(TextForm
    \`c\_1 = \(1\/\(2  \[CapitalAAcute]rea \((D)\)\)\) 
        \(\[Integral]\_\[Gamma]\ x\^2\ \[DifferentialD]y\), \ \ \ 
    c\_2 = \(-\(1\/\(2  \[CapitalAAcute]rea \((D)\)\)\)\) 
        \(\[Integral]\_\[Gamma]\ \(\(y\ \)\^2\) \[DifferentialD]x\)\)], "Text",\

  TextAlignment->Center],

Cell["\<\
b) Calcula el centroide del tri\[AAcute]ngulo de v\[EAcute]rtices (0,0), \
(1,0) y (0,1).
c) Calcula el centroide de un semic\[IAcute]rculo de radio R.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  "Haz uso del teorema de Green para dominios con agujeros o bien del teorema \
5 para probar que la integral de l\[IAcute]nea del campo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", 
            \(\[DoubleStruckCapitalR]\^2\\{\((0, 0)\)}\)}], "\[Rule]", 
          "\[DoubleStruckCapitalR]"}], TraditionalForm]]],
  " dado por"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                StyleBox[\(-y\),
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(x\^2\),
                    FontSlant->"Italic"], 
                  StyleBox["+",
                    FontSlant->"Plain"], 
                  StyleBox[\(y\^2\),
                    FontSlant->"Italic"]}]], ",", 
              FractionBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(x\^2\),
                    FontSlant->"Italic"], 
                  StyleBox["+",
                    FontSlant->"Plain"], 
                  StyleBox[\(y\^2\),
                    FontSlant->"Italic"]}]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[
"sobre cualquier curva cerrada simple que rodee el origen es igual a 2\[Pi].\n\
Prueba de la misma forma que la integral de l\[IAcute]nea del campo"], 
  "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x, y\),
                FontSlant->"Italic"], ")"}]}], "=", 
          RowBox[{"(", 
            RowBox[{
              FractionBox[
                RowBox[{"2", 
                  StyleBox["x",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["y",
                    FontSlant->"Italic"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(x\^2\),
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        FontSlant->"Plain"], 
                      StyleBox[\(y\^2\),
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]], ",", 
              FractionBox[
                RowBox[{
                  SuperscriptBox[
                    StyleBox["y",
                      FontSlant->"Italic"], "2"], "-", 
                  SuperscriptBox[
                    StyleBox["x",
                      FontSlant->"Italic"], "2"]}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      StyleBox[\(x\^2\),
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        FontSlant->"Plain"], 
                      StyleBox[\(y\^2\),
                        FontSlant->"Italic"]}], 
                    StyleBox[")",
                      FontSlant->"Italic"]}], "2"]]}], ")"}]}], "        "}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
sobre cualquier curva cerrada simple que rodee el origen es igual a 0.\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos conservativos. Teorema de Green"], "Header"]}, {
    Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos conservativos. Teorema de Green"], "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[2045, 64, 85, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"],
    Cell[2133, 68, 86, 2, 93, "Input",
      InitializationCell->True,
      CellTags->"S5.32.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 721041, 17940}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 55, 0, 99, "Title"],
Cell[1812, 53, 164, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[2001, 62, 41, 0, 93, "Section"],
Cell[2045, 64, 85, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2133, 68, 86, 2, 93, "Input",
  InitializationCell->True,
  CellTags->"S5.32.1"],
Cell[2222, 72, 511, 10, 299, "Input",
  InitializationCell->True],
Cell[2736, 84, 1925, 34, 648, "Input",
  InitializationCell->True],
Cell[4664, 120, 1907, 32, 674, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[6608, 157, 39, 0, 93, "Section"],
Cell[6650, 159, 783, 20, 94, "Text"],
Cell[7436, 181, 930, 24, 64, "Text"],
Cell[8369, 207, 1231, 33, 125, "Text"],
Cell[9603, 242, 3740, 128, 284, "Text"],
Cell[13346, 372, 646, 16, 93, "Text"],
Cell[13995, 390, 319, 7, 35, "Text"],
Cell[14317, 399, 289, 10, 41, "Text"],
Cell[14609, 411, 2439, 62, 64, "Text"],
Cell[17051, 475, 1164, 38, 74, "Text"],
Cell[18218, 515, 79, 0, 41, "Text"],
Cell[18300, 517, 699, 20, 73, "Text"],
Cell[19002, 539, 135, 3, 41, "Text"],
Cell[19140, 544, 1150, 37, 121, "Text"],
Cell[20293, 583, 176, 6, 41, "Text"],
Cell[20472, 591, 2269, 73, 119, "Text"],
Cell[22744, 666, 6598, 163, 108, "Text"],
Cell[29345, 831, 1312, 40, 98, "Text"],
Cell[30660, 873, 1548, 49, 119, "Text"],
Cell[32211, 924, 2615, 73, 60, "Text"],
Cell[34829, 999, 265, 5, 67, "Text"],
Cell[35097, 1006, 1367, 43, 93, "Text"],
Cell[36467, 1051, 5893, 156, 60, "Text"],
Cell[42363, 1209, 119, 3, 41, "Text"],
Cell[42485, 1214, 2743, 81, 60, "Text"],
Cell[45231, 1297, 516, 17, 67, "Text"],
Cell[45750, 1316, 1631, 52, 57, "Text"],
Cell[47384, 1370, 393, 10, 67, "Text"],
Cell[47780, 1382, 76, 1, 41, "Text"],
Cell[47859, 1385, 424, 12, 67, "Text"],
Cell[48286, 1399, 2182, 62, 63, "Text"],
Cell[50471, 1463, 335, 8, 41, "Text"],
Cell[50809, 1473, 579, 18, 64, "Text"],
Cell[51391, 1493, 472, 17, 42, "Text"],
Cell[51866, 1512, 333, 8, 67, "Text"],
Cell[52202, 1522, 145, 3, 41, "Text"],
Cell[52350, 1527, 2971, 96, 68, "Text"],
Cell[55324, 1625, 1054, 32, 66, "Text"],
Cell[56381, 1659, 722, 22, 41, "Text"],
Cell[57106, 1683, 843, 26, 61, "Text"],
Cell[57952, 1711, 744, 22, 67, "Text"],
Cell[58699, 1735, 2543, 75, 61, "Text"],
Cell[61245, 1812, 533, 13, 67, "Text"],
Cell[61781, 1827, 820, 25, 61, "Text"],
Cell[62604, 1854, 49, 0, 41, "Text"],
Cell[62656, 1856, 2459, 70, 67, "Text"],
Cell[65118, 1928, 95, 2, 41, "Text"],
Cell[65216, 1932, 638, 16, 63, "Text"],
Cell[65857, 1950, 62, 0, 41, "Text"],
Cell[65922, 1952, 2223, 71, 201, "Text"],
Cell[68148, 2025, 645, 20, 35, "Text"],
Cell[68796, 2047, 675, 19, 94, "Text"],
Cell[69474, 2068, 107, 3, 41, "Text"],
Cell[69584, 2073, 2271, 74, 94, "Text"],
Cell[71858, 2149, 1113, 33, 66, "Text"],
Cell[72974, 2184, 1804, 46, 249, "Text"],
Cell[74781, 2232, 2874, 92, 67, "Text"],
Cell[77658, 2326, 1113, 33, 66, "Text"],
Cell[78774, 2361, 227, 9, 42, "Text"],
Cell[79004, 2372, 169, 3, 41, "Text"],
Cell[79176, 2377, 2110, 70, 67, "Text"],
Cell[81289, 2449, 1036, 32, 66, "Text"],
Cell[82328, 2483, 636, 21, 67, "Text"],
Cell[82967, 2506, 439, 13, 64, "Text"],
Cell[83409, 2521, 142, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[83576, 2528, 573, 10, 224, "Input"],

Cell[CellGroupData[{
Cell[84174, 2542, 52107, 1215, 444, 10344, 695, "GraphicsData", "PostScript", \
"Graphics"],
Cell[136284, 3759, 50710, 1206, 444, 10551, 706, "GraphicsData", \
"PostScript", "Graphics"],
Cell[186997, 4967, 49472, 1202, 444, 10746, 719, "GraphicsData", \
"PostScript", "Graphics"],
Cell[236472, 6171, 47709, 1167, 444, 10486, 703, "GraphicsData", \
"PostScript", "Graphics"],
Cell[284184, 7340, 46920, 1144, 444, 10223, 686, "GraphicsData", \
"PostScript", "Graphics"],
Cell[331107, 8486, 45493, 1116, 444, 9991, 673, "GraphicsData", "PostScript", \
"Graphics"],
Cell[376603, 9604, 43130, 1060, 444, 9524, 641, "GraphicsData", "PostScript", \
"Graphics"],
Cell[419736, 10666, 41837, 1033, 444, 9304, 627, "GraphicsData", \
"PostScript", "Graphics"],
Cell[461576, 11701, 39281, 935, 444, 7995, 544, "GraphicsData", "PostScript", \
"Graphics"],
Cell[500860, 12638, 36995, 828, 444, 6479, 447, "GraphicsData", "PostScript", \
"Graphics"],
Cell[537858, 13468, 35347, 738, 444, 5147, 361, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]],
Cell[573232, 14210, 373, 8, 67, "Text"],

Cell[CellGroupData[{
Cell[573630, 14222, 31, 0, 68, "Exercise"],
Cell[573664, 14224, 2580, 75, 203, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[576281, 14304, 31, 0, 68, "Exercise"],
Cell[576315, 14306, 4529, 139, 183, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[580881, 14450, 31, 0, 68, "Exercise"],
Cell[580915, 14452, 365, 11, 41, "ExerciseText"],
Cell[581283, 14465, 775, 24, 61, "Text"],
Cell[582061, 14491, 137, 3, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[582235, 14499, 31, 0, 68, "Exercise"],
Cell[582269, 14501, 341, 11, 41, "ExerciseText"],
Cell[582613, 14514, 1479, 42, 67, "Text"],
Cell[584095, 14558, 303, 8, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[584447, 14572, 35, 0, 93, "Section"],
Cell[584485, 14574, 3563, 85, 455, "Text"],
Cell[588051, 14661, 282, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[588358, 14670, 56, 1, 94, "Input"],
Cell[588417, 14673, 52171, 1137, 440, 13157, 651, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[640603, 15813, 113, 5, 41, "Text"],
Cell[640719, 15820, 1915, 59, 127, "Text"],
Cell[642637, 15881, 1901, 48, 73, "Text"],
Cell[644541, 15931, 235, 8, 41, "Text"],
Cell[644779, 15941, 231, 4, 67, "Text"],
Cell[645013, 15947, 1866, 56, 128, "Text"],
Cell[646882, 16005, 1385, 36, 61, "Text"],
Cell[648270, 16043, 151, 3, 41, "Text"],
Cell[648424, 16048, 1197, 17, 223, "Text"],
Cell[649624, 16067, 6263, 206, 271, "Text"],
Cell[655890, 16275, 2342, 62, 80, "Text"],
Cell[658235, 16339, 141, 3, 41, "Text"],

Cell[CellGroupData[{
Cell[658401, 16346, 56, 1, 94, "Input"],
Cell[658460, 16349, 48434, 1147, 440, 16212, 745, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[706909, 17499, 287, 5, 67, "Text"],

Cell[CellGroupData[{
Cell[707221, 17508, 31, 0, 68, "Exercise"],
Cell[707255, 17510, 2332, 70, 169, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[709624, 17585, 31, 0, 68, "Exercise"],
Cell[709658, 17587, 1643, 50, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[711338, 17642, 31, 0, 68, "Exercise"],
Cell[711372, 17644, 2545, 80, 245, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[713954, 17729, 31, 0, 68, "Exercise"],
Cell[713988, 17731, 303, 8, 41, "ExerciseText"],
Cell[714294, 17741, 855, 22, 62, "Text"],
Cell[715152, 17765, 193, 6, 41, "ExerciseText"],
Cell[715348, 17773, 317, 7, 63, "Text"],
Cell[715668, 17782, 183, 4, 75, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[715888, 17791, 32, 0, 68, "Exercise"],
Cell[715923, 17793, 454, 12, 67, "ExerciseText"],
Cell[716380, 17807, 1135, 34, 61, "Text"],
Cell[717518, 17843, 184, 3, 75, "ExerciseText"],
Cell[717705, 17848, 1875, 52, 67, "Text"],
Cell[719583, 17902, 102, 2, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

