(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    556468,      19147]*)
(*NotebookOutlinePosition[    558127,      19197]*)
(*  CellTagsIndexPosition[    558051,      19191]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Campos vectoriales. Integrales de l\[IAcute]nea", "Title"],

Cell["\<\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez
Departamento de An\[AAcute]lisis Matem\[AAcute]tico
Universidad de Granada\
\>", "Author",
  FontSize->12],

Cell[CellGroupData[{

Cell["Campos vectoriales", "Section"],

Cell[TextData[{
  "Recuerda que un ",
  StyleBox["campo escalar",
    FontWeight->"Bold"],
  " de n variables es una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Un ",
  StyleBox["campo vectorial",
    FontWeight->"Bold"],
  " es una funci\[OAcute]n que a cada punto de una regi\[OAcute]n de un \
espacio vectorial hace corresponder un vector de dicho espacio. \
Concretamente, un campo vectorial de n variables es una aplicaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A\)]],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Dicha funci\[OAcute]n debe ser de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", "x", ")"}], "=", 
          \((\(F\_1\)(x), \(F\_2\)(x),  ... , \(F\_n\)(x))\)}], 
        TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1, \ F\_2,  .. , F\_\(n\ \)\)]],
  "son campos escalares de n variables llamados ",
  StyleBox["componentes",
    FontWeight->"Bold"],
  " de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". Se dice que ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es continuo o que tiene derivadas parciales o que es de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^k\)]],
  " (tiene derivadas parciales de orden k continuas) cuando todos los campos \
escalares componentes de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " tienen la correspondiente propiedad. Por ejemplo, las funciones"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", \(x, y\), ")"}], "=", 
        RowBox[{\((x\/\(\(\ \)\(1 + x\^2 + y\^2\)\), \(-y\)\/\(1 + x\^2 + \
y\^2\))\), "=", 
          RowBox[{
            RowBox[{\(x\/\(\(\ \)\(1 + x\^2 + y\^2\)\)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(y\/\(1 + x\^2 + y\^2\)\), 
              StyleBox["j",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}]}], TraditionalForm], "\n", 
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["G",
            FontWeight->"Bold",
            FontSlant->"Italic"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{\((\(-x\)\/\(\(\ \)\(1 + x\^2\)\), \(-y\)\/\(1 + y\^2\), \(-z\
\)\/\(1 + z\^2\))\), "=", 
          RowBox[{
            RowBox[{\(-\(x\/\(1 + \ x\^2\)\)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(y\/\(\(\ \)\(1 + y\^2\)\)\), 
              StyleBox["j",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], " ", "-", " ", 
            RowBox[{\(z\/\(\(\ \)\(1 + z\^2\)\)\), 
              StyleBox["k",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}]}]}], TraditionalForm]}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "son campos vectoriales de 2 y 3 variables de clase ",
  Cell[BoxData[
      \(TraditionalForm\`C\^\[Infinity]\)]],
  "definidos en ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalR]\^2\ \)\)]],
  "y en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " respectivamente. Como puedes ver, nada nuevo hay en el concepto de campo \
vectorial pues se trata de un tipo particular de funciones que ya conoces. \
Ahora bien, cuando decimos que una funci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", " ", 
          FormBox[\(\[DoubleStruckCapitalR]\^n\),
            "TraditionalForm"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " es un campo vectorial es porque la visualizamos de una forma especial y \
consideramos que dicha funci\[OAcute]n hace corresponder a cada vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(x \[Element] A\ \)\)]],
  "el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", "x", ")"}], TraditionalForm]]],
  " ",
  StyleBox["con origen en el punto",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de los comandos"
}], "Text"],

Cell["\<\
PlotVectorField[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones] \
PlotVectorField3D[f[x,y,z],{x,xmin,xmax},{y,ymin,ymax},{z,zmin,zmax},opciones]\
 \
\>", "Text",
  TextAlignment->Center],

Cell["\<\
para representa gr\[AAcute]ficamente campos vectoriales de 2 y 3 variables \
respectivamente. Para poder usarlos hay que cargar los correspondientes \
paquetes.\
\>", "Text"],

Cell["<<Graphics`PlotField`", "Input",
  CellTags->"S5.42.1"],

Cell["<<Graphics`PlotField3D`", "Input",
  CellTags->"S5.42.1"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(F[x_, 
        y_] := {x\/\(\(\ \)\(1 + x\^2 + y\^2\)\), \(-y\)\/\(1 + x\^2 + \
y\^2\)}\), "\n", 
    \(\(PlotVectorField[\ 
        F[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}];\)\), "\n", 
    \(Clear[F]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .875 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.416667 0.4375 0.416667 [
[ 0 0 0 0 ]
[ 1 .875 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto fill
-0.02 0.005 moveto 0 0 lineto
-0.02 -0.005 lineto
-0.02 0.005 lineto stroke
} ifelse
grestore
} def
/MAarrowzero1 {
gsave
mathtops translate
0 0 Mdot
grestore
} def
% End of user PostScript
0 g
.0001 w
[ ] 0 setdash
.08333 .02083 m
.04365 .06052 L
s
% Start of user PostScript
-1. -1. -1.09524 -0.904762 MAarrowhead1
% End of user PostScript
.08333 .08036 m
.0398 .11767 L
s
% Start of user PostScript
-1. -0.857143 -1.10448 -0.767591 MAarrowhead1
% End of user PostScript
.08333 .13988 m
.03591 .17376 L
s
% Start of user PostScript
-1. -0.714286 -1.11382 -0.632985 MAarrowhead1
% End of user PostScript
.08333 .1994 m
.03216 .22864 L
s
% Start of user PostScript
-1. -0.571429 -1.12281 -0.501253 MAarrowhead1
% End of user PostScript
.08333 .25893 m
.02882 .28229 L
s
% Start of user PostScript
-1. -0.428571 -1.13084 -0.372497 MAarrowhead1
% End of user PostScript
.08333 .31845 m
.02614 .33479 L
s
% Start of user PostScript
-1. -0.285714 -1.13725 -0.246499 MAarrowhead1
% End of user PostScript
.08333 .37798 m
.02441 .38639 L
s
% Start of user PostScript
-1. -0.142857 -1.14141 -0.122655 MAarrowhead1
% End of user PostScript
.08333 .4375 m
.02381 .4375 L
s
% Start of user PostScript
-1. 0 -1.14286 0 MAarrowhead1
% End of user PostScript
.08333 .49702 m
.02441 .48861 L
s
% Start of user PostScript
-1. 0.142857 -1.14141 0.122655 MAarrowhead1
% End of user PostScript
.08333 .55655 m
.02614 .54021 L
s
% Start of user PostScript
-1. 0.285714 -1.13725 0.246499 MAarrowhead1
% End of user PostScript
.08333 .61607 m
.02882 .59271 L
s
% Start of user PostScript
-1. 0.428571 -1.13084 0.372497 MAarrowhead1
% End of user PostScript
.08333 .6756 m
.03216 .64636 L
s
% Start of user PostScript
-1. 0.571429 -1.12281 0.501253 MAarrowhead1
% End of user PostScript
.08333 .73512 m
.03591 .70124 L
s
% Start of user PostScript
-1. 0.714286 -1.11382 0.632985 MAarrowhead1
% End of user PostScript
.08333 .79464 m
.0398 .75733 L
s
% Start of user PostScript
-1. 0.857143 -1.10448 0.767591 MAarrowhead1
% End of user PostScript
.08333 .85417 m
.04365 .81448 L
s
% Start of user PostScript
-1. 1. -1.09524 0.904762 MAarrowhead1
% End of user PostScript
.14286 .02083 m
.10554 .06437 L
s
% Start of user PostScript
-0.857143 -1. -0.946695 -0.895522 MAarrowhead1
% End of user PostScript
.14286 .08036 m
.10153 .12168 L
s
% Start of user PostScript
-0.857143 -0.857143 -0.956316 -0.757969 MAarrowhead1
% End of user PostScript
.14286 .13988 m
.0974 .17776 L
s
% Start of user PostScript
-0.857143 -0.714286 -0.966234 -0.623377 MAarrowhead1
% End of user PostScript
.14286 .1994 m
.09335 .23241 L
s
% Start of user PostScript
-0.857143 -0.571429 -0.975955 -0.492221 MAarrowhead1
% End of user PostScript
.14286 .25893 m
.08967 .28552 L
s
% Start of user PostScript
-0.857143 -0.428571 -0.984802 -0.364742 MAarrowhead1
% End of user PostScript
.14286 .31845 m
.08668 .33718 L
s
% Start of user PostScript
-0.857143 -0.285714 -0.991974 -0.24077 MAarrowhead1
% End of user PostScript
.14286 .37798 m
.08472 .38767 L
s
% Start of user PostScript
-0.857143 -0.142857 -0.996678 -0.119601 MAarrowhead1
% End of user PostScript
.14286 .4375 m
.08403 .4375 L
s
% Start of user PostScript
-0.857143 0 -0.998319 0 MAarrowhead1
% End of user PostScript
.14286 .49702 m
.08472 .48733 L
s
% Start of user PostScript
-0.857143 0.142857 -0.996678 0.119601 MAarrowhead1
% End of user PostScript
.14286 .55655 m
.08668 .53782 L
s
% Start of user PostScript
-0.857143 0.285714 -0.991974 0.24077 MAarrowhead1
% End of user PostScript
.14286 .61607 m
.08967 .58948 L
s
% Start of user PostScript
-0.857143 0.428571 -0.984802 0.364742 MAarrowhead1
% End of user PostScript
.14286 .6756 m
.09335 .64259 L
s
% Start of user PostScript
-0.857143 0.571429 -0.975955 0.492221 MAarrowhead1
% End of user PostScript
.14286 .73512 m
.0974 .69724 L
s
% Start of user PostScript
-0.857143 0.714286 -0.966234 0.623377 MAarrowhead1
% End of user PostScript
.14286 .79464 m
.10153 .75332 L
s
% Start of user PostScript
-0.857143 0.857143 -0.956316 0.757969 MAarrowhead1
% End of user PostScript
.14286 .85417 m
.10554 .81063 L
s
% Start of user PostScript
-0.857143 1. -0.946695 0.895522 MAarrowhead1
% End of user PostScript
.20238 .02083 m
.16851 .06826 L
s
% Start of user PostScript
-0.714286 -1. -0.795587 -0.886179 MAarrowhead1
% End of user PostScript
.20238 .08036 m
.1645 .12581 L
s
% Start of user PostScript
-0.714286 -0.857143 -0.805195 -0.748052 MAarrowhead1
% End of user PostScript
.20238 .13988 m
.16029 .18197 L
s
% Start of user PostScript
-0.714286 -0.714286 -0.815296 -0.613276 MAarrowhead1
% End of user PostScript
.20238 .1994 m
.15608 .23644 L
s
% Start of user PostScript
-0.714286 -0.571429 -0.825397 -0.48254 MAarrowhead1
% End of user PostScript
.20238 .25893 m
.15218 .28905 L
s
% Start of user PostScript
-0.714286 -0.428571 -0.834768 -0.356282 MAarrowhead1
% End of user PostScript
.20238 .31845 m
.14896 .33982 L
s
% Start of user PostScript
-0.714286 -0.285714 -0.842491 -0.234432 MAarrowhead1
% End of user PostScript
.20238 .37798 m
.14683 .38909 L
s
% Start of user PostScript
-0.714286 -0.142857 -0.847619 -0.11619 MAarrowhead1
% End of user PostScript
.20238 .4375 m
.14607 .4375 L
s
% Start of user PostScript
-0.714286 0 -0.849421 0 MAarrowhead1
% End of user PostScript
.20238 .49702 m
.14683 .48591 L
s
% Start of user PostScript
-0.714286 0.142857 -0.847619 0.11619 MAarrowhead1
% End of user PostScript
.20238 .55655 m
.14896 .53518 L
s
% Start of user PostScript
-0.714286 0.285714 -0.842491 0.234432 MAarrowhead1
% End of user PostScript
.20238 .61607 m
.15218 .58595 L
s
% Start of user PostScript
-0.714286 0.428571 -0.834768 0.356282 MAarrowhead1
% End of user PostScript
.20238 .6756 m
.15608 .63856 L
s
% Start of user PostScript
-0.714286 0.571429 -0.825397 0.48254 MAarrowhead1
% End of user PostScript
.20238 .73512 m
.16029 .69303 L
s
% Start of user PostScript
-0.714286 0.714286 -0.815296 0.613276 MAarrowhead1
% End of user PostScript
.20238 .79464 m
.1645 .74919 L
s
% Start of user PostScript
-0.714286 0.857143 -0.805195 0.748052 MAarrowhead1
% End of user PostScript
.20238 .85417 m
.16851 .80674 L
s
% Start of user PostScript
-0.714286 1. -0.795587 0.886179 MAarrowhead1
% End of user PostScript
.2619 .02083 m
.23266 .072 L
s
% Start of user PostScript
-0.571429 -1. -0.641604 -0.877193 MAarrowhead1
% End of user PostScript
.2619 .08036 m
.2289 .12986 L
s
% Start of user PostScript
-0.571429 -0.857143 -0.650636 -0.738331 MAarrowhead1
% End of user PostScript
.2619 .13988 m
.22487 .18618 L
s
% Start of user PostScript
-0.571429 -0.714286 -0.660317 -0.603175 MAarrowhead1
% End of user PostScript
.2619 .1994 m
.22075 .24056 L
s
% Start of user PostScript
-0.571429 -0.571429 -0.670194 -0.472663 MAarrowhead1
% End of user PostScript
.2619 .25893 m
.21686 .29271 L
s
% Start of user PostScript
-0.571429 -0.428571 -0.679537 -0.34749 MAarrowhead1
% End of user PostScript
.2619 .31845 m
.2136 .34261 L
s
% Start of user PostScript
-0.571429 -0.285714 -0.687371 -0.227743 MAarrowhead1
% End of user PostScript
.2619 .37798 m
.2114 .3906 L
s
% Start of user PostScript
-0.571429 -0.142857 -0.692641 -0.112554 MAarrowhead1
% End of user PostScript
.2619 .4375 m
.21062 .4375 L
s
% Start of user PostScript
-0.571429 0 -0.694505 0 MAarrowhead1
% End of user PostScript
.2619 .49702 m
.2114 .4844 L
s
% Start of user PostScript
-0.571429 0.142857 -0.692641 0.112554 MAarrowhead1
% End of user PostScript
.2619 .55655 m
.2136 .53239 L
s
% Start of user PostScript
-0.571429 0.285714 -0.687371 0.227743 MAarrowhead1
% End of user PostScript
.2619 .61607 m
.21686 .58229 L
s
% Start of user PostScript
-0.571429 0.428571 -0.679537 0.34749 MAarrowhead1
% End of user PostScript
.2619 .6756 m
.22075 .63444 L
s
% Start of user PostScript
-0.571429 0.571429 -0.670194 0.472663 MAarrowhead1
% End of user PostScript
.2619 .73512 m
.22487 .68882 L
s
% Start of user PostScript
-0.571429 0.714286 -0.660317 0.603175 MAarrowhead1
% End of user PostScript
.2619 .79464 m
.2289 .74514 L
s
% Start of user PostScript
-0.571429 0.857143 -0.650636 0.738331 MAarrowhead1
% End of user PostScript
.2619 .85417 m
.23266 .803 L
s
% Start of user PostScript
-0.571429 1. -0.641604 0.877193 MAarrowhead1
% End of user PostScript
.32143 .02083 m
.29806 .07535 L
s
% Start of user PostScript
-0.428571 -1. -0.484646 -0.869159 MAarrowhead1
% End of user PostScript
.32143 .08036 m
.29483 .13355 L
s
% Start of user PostScript
-0.428571 -0.857143 -0.492401 -0.729483 MAarrowhead1
% End of user PostScript
.32143 .13988 m
.29131 .19008 L
s
% Start of user PostScript
-0.428571 -0.714286 -0.500861 -0.593804 MAarrowhead1
% End of user PostScript
.32143 .1994 m
.28764 .24445 L
s
% Start of user PostScript
-0.428571 -0.571429 -0.509653 -0.46332 MAarrowhead1
% End of user PostScript
.32143 .25893 m
.28412 .29624 L
s
% Start of user PostScript
-0.428571 -0.428571 -0.518124 -0.339019 MAarrowhead1
% End of user PostScript
.32143 .31845 m
.28111 .34533 L
s
% Start of user PostScript
-0.428571 -0.285714 -0.525346 -0.221198 MAarrowhead1
% End of user PostScript
.32143 .37798 m
.27906 .3921 L
s
% Start of user PostScript
-0.428571 -0.142857 -0.530266 -0.108959 MAarrowhead1
% End of user PostScript
.32143 .4375 m
.27833 .4375 L
s
% Start of user PostScript
-0.428571 0 -0.53202 0 MAarrowhead1
% End of user PostScript
.32143 .49702 m
.27906 .4829 L
s
% Start of user PostScript
-0.428571 0.142857 -0.530266 0.108959 MAarrowhead1
% End of user PostScript
.32143 .55655 m
.28111 .52967 L
s
% Start of user PostScript
-0.428571 0.285714 -0.525346 0.221198 MAarrowhead1
% End of user PostScript
.32143 .61607 m
.28412 .57876 L
s
% Start of user PostScript
-0.428571 0.428571 -0.518124 0.339019 MAarrowhead1
% End of user PostScript
.32143 .6756 m
.28764 .63055 L
s
% Start of user PostScript
-0.428571 0.571429 -0.509653 0.46332 MAarrowhead1
% End of user PostScript
.32143 .73512 m
.29131 .68492 L
s
% Start of user PostScript
-0.428571 0.714286 -0.500861 0.593804 MAarrowhead1
% End of user PostScript
.32143 .79464 m
.29483 .74145 L
s
% Start of user PostScript
-0.428571 0.857143 -0.492401 0.729483 MAarrowhead1
% End of user PostScript
.32143 .85417 m
.29806 .79965 L
s
% Start of user PostScript
-0.428571 1. -0.484646 0.869159 MAarrowhead1
% End of user PostScript
.38095 .02083 m
.36461 .07802 L
s
% Start of user PostScript
-0.285714 -1. -0.32493 -0.862745 MAarrowhead1
% End of user PostScript
.38095 .08036 m
.36223 .13654 L
s
% Start of user PostScript
-0.285714 -0.857143 -0.330658 -0.722311 MAarrowhead1
% End of user PostScript
.38095 .13988 m
.35958 .1933 L
s
% Start of user PostScript
-0.285714 -0.714286 -0.336996 -0.586081 MAarrowhead1
% End of user PostScript
.38095 .1994 m
.3568 .24771 L
s
% Start of user PostScript
-0.285714 -0.571429 -0.343685 -0.455487 MAarrowhead1
% End of user PostScript
.38095 .25893 m
.35407 .29925 L
s
% Start of user PostScript
-0.285714 -0.428571 -0.35023 -0.331797 MAarrowhead1
% End of user PostScript
.38095 .31845 m
.35171 .34769 L
s
% Start of user PostScript
-0.285714 -0.285714 -0.35589 -0.215539 MAarrowhead1
% End of user PostScript
.38095 .37798 m
.35009 .39341 L
s
% Start of user PostScript
-0.285714 -0.142857 -0.359788 -0.10582 MAarrowhead1
% End of user PostScript
.38095 .4375 m
.34951 .4375 L
s
% Start of user PostScript
-0.285714 0 -0.361186 0 MAarrowhead1
% End of user PostScript
.38095 .49702 m
.35009 .48159 L
s
% Start of user PostScript
-0.285714 0.142857 -0.359788 0.10582 MAarrowhead1
% End of user PostScript
.38095 .55655 m
.35171 .52731 L
s
% Start of user PostScript
-0.285714 0.285714 -0.35589 0.215539 MAarrowhead1
% End of user PostScript
.38095 .61607 m
.35407 .57575 L
s
% Start of user PostScript
-0.285714 0.428571 -0.35023 0.331797 MAarrowhead1
% End of user PostScript
.38095 .6756 m
.3568 .62729 L
s
% Start of user PostScript
-0.285714 0.571429 -0.343685 0.455487 MAarrowhead1
% End of user PostScript
.38095 .73512 m
.35958 .6817 L
s
% Start of user PostScript
-0.285714 0.714286 -0.336996 0.586081 MAarrowhead1
% End of user PostScript
.38095 .79464 m
.36223 .73846 L
s
% Start of user PostScript
-0.285714 0.857143 -0.330658 0.722311 MAarrowhead1
% End of user PostScript
.38095 .85417 m
.36461 .79698 L
s
% Start of user PostScript
-0.285714 1. -0.32493 0.862745 MAarrowhead1
% End of user PostScript
.44048 .02083 m
.43206 .07976 L
s
% Start of user PostScript
-0.142857 -1. -0.163059 -0.858586 MAarrowhead1
% End of user PostScript
.44048 .08036 m
.43079 .1385 L
s
% Start of user PostScript
-0.142857 -0.857143 -0.166113 -0.717608 MAarrowhead1
% End of user PostScript
.44048 .13988 m
.42937 .19544 L
s
% Start of user PostScript
-0.142857 -0.714286 -0.169524 -0.580952 MAarrowhead1
% End of user PostScript
.44048 .1994 m
.42785 .24991 L
s
% Start of user PostScript
-0.142857 -0.571429 -0.17316 -0.450216 MAarrowhead1
% End of user PostScript
.44048 .25893 m
.42635 .3013 L
s
% Start of user PostScript
-0.142857 -0.428571 -0.176755 -0.326877 MAarrowhead1
% End of user PostScript
.44048 .31845 m
.42504 .34932 L
s
% Start of user PostScript
-0.142857 -0.285714 -0.179894 -0.21164 MAarrowhead1
% End of user PostScript
.44048 .37798 m
.42414 .39432 L
s
% Start of user PostScript
-0.142857 -0.142857 -0.182073 -0.103641 MAarrowhead1
% End of user PostScript
.44048 .4375 m
.42381 .4375 L
s
% Start of user PostScript
-0.142857 0 -0.182857 0 MAarrowhead1
% End of user PostScript
.44048 .49702 m
.42414 .48068 L
s
% Start of user PostScript
-0.142857 0.142857 -0.182073 0.103641 MAarrowhead1
% End of user PostScript
.44048 .55655 m
.42504 .52568 L
s
% Start of user PostScript
-0.142857 0.285714 -0.179894 0.21164 MAarrowhead1
% End of user PostScript
.44048 .61607 m
.42635 .5737 L
s
% Start of user PostScript
-0.142857 0.428571 -0.176755 0.326877 MAarrowhead1
% End of user PostScript
.44048 .6756 m
.42785 .62509 L
s
% Start of user PostScript
-0.142857 0.571429 -0.17316 0.450216 MAarrowhead1
% End of user PostScript
.44048 .73512 m
.42937 .67956 L
s
% Start of user PostScript
-0.142857 0.714286 -0.169524 0.580952 MAarrowhead1
% End of user PostScript
.44048 .79464 m
.43079 .7365 L
s
% Start of user PostScript
-0.142857 0.857143 -0.166113 0.717608 MAarrowhead1
% End of user PostScript
.44048 .85417 m
.43206 .79524 L
s
% Start of user PostScript
-0.142857 1. -0.163059 0.858586 MAarrowhead1
% End of user PostScript
.5 .02083 m
.5 .08036 L
s
% Start of user PostScript
0 -1. 0 -0.857143 MAarrowhead1
% End of user PostScript
.5 .08036 m
.5 .13918 L
s
% Start of user PostScript
0 -0.857143 0 -0.715966 MAarrowhead1
% End of user PostScript
.5 .13988 m
.5 .19619 L
s
% Start of user PostScript
0 -0.714286 0 -0.579151 MAarrowhead1
% End of user PostScript
.5 .1994 m
.5 .25069 L
s
% Start of user PostScript
0 -0.571429 0 -0.448352 MAarrowhead1
% End of user PostScript
.5 .25893 m
.5 .30203 L
s
% Start of user PostScript
0 -0.428571 0 -0.325123 MAarrowhead1
% End of user PostScript
.5 .31845 m
.5 .3499 L
s
% Start of user PostScript
0 -0.285714 0 -0.210243 MAarrowhead1
% End of user PostScript
.5 .37798 m
.5 .39464 L
s
% Start of user PostScript
0 -0.142857 0 -0.102857 MAarrowhead1
% End of user PostScript
.5 .4375 m
.5 .4375 L
s
% Start of user PostScript
0 0 MAarrowzero1
% End of user PostScript
.5 .49702 m
.5 .48036 L
s
% Start of user PostScript
0 0.142857 0 0.102857 MAarrowhead1
% End of user PostScript
.5 .55655 m
.5 .5251 L
s
% Start of user PostScript
0 0.285714 0 0.210243 MAarrowhead1
% End of user PostScript
.5 .61607 m
.5 .57297 L
s
% Start of user PostScript
0 0.428571 0 0.325123 MAarrowhead1
% End of user PostScript
.5 .6756 m
.5 .62431 L
s
% Start of user PostScript
0 0.571429 0 0.448352 MAarrowhead1
% End of user PostScript
.5 .73512 m
.5 .67881 L
s
% Start of user PostScript
0 0.714286 0 0.579151 MAarrowhead1
% End of user PostScript
.5 .79464 m
.5 .73582 L
s
% Start of user PostScript
0 0.857143 0 0.715966 MAarrowhead1
% End of user PostScript
.5 .85417 m
.5 .79464 L
s
% Start of user PostScript
0 1. 0 0.857143 MAarrowhead1
% End of user PostScript
.55952 .02083 m
.56794 .07976 L
s
% Start of user PostScript
0.142857 -1. 0.163059 -0.858586 MAarrowhead1
% End of user PostScript
.55952 .08036 m
.56921 .1385 L
s
% Start of user PostScript
0.142857 -0.857143 0.166113 -0.717608 MAarrowhead1
% End of user PostScript
.55952 .13988 m
.57063 .19544 L
s
% Start of user PostScript
0.142857 -0.714286 0.169524 -0.580952 MAarrowhead1
% End of user PostScript
.55952 .1994 m
.57215 .24991 L
s
% Start of user PostScript
0.142857 -0.571429 0.17316 -0.450216 MAarrowhead1
% End of user PostScript
.55952 .25893 m
.57365 .3013 L
s
% Start of user PostScript
0.142857 -0.428571 0.176755 -0.326877 MAarrowhead1
% End of user PostScript
.55952 .31845 m
.57496 .34932 L
s
% Start of user PostScript
0.142857 -0.285714 0.179894 -0.21164 MAarrowhead1
% End of user PostScript
.55952 .37798 m
.57586 .39432 L
s
% Start of user PostScript
0.142857 -0.142857 0.182073 -0.103641 MAarrowhead1
% End of user PostScript
.55952 .4375 m
.57619 .4375 L
s
% Start of user PostScript
0.142857 0 0.182857 0 MAarrowhead1
% End of user PostScript
.55952 .49702 m
.57586 .48068 L
s
% Start of user PostScript
0.142857 0.142857 0.182073 0.103641 MAarrowhead1
% End of user PostScript
.55952 .55655 m
.57496 .52568 L
s
% Start of user PostScript
0.142857 0.285714 0.179894 0.21164 MAarrowhead1
% End of user PostScript
.55952 .61607 m
.57365 .5737 L
s
% Start of user PostScript
0.142857 0.428571 0.176755 0.326877 MAarrowhead1
% End of user PostScript
.55952 .6756 m
.57215 .62509 L
s
% Start of user PostScript
0.142857 0.571429 0.17316 0.450216 MAarrowhead1
% End of user PostScript
.55952 .73512 m
.57063 .67956 L
s
% Start of user PostScript
0.142857 0.714286 0.169524 0.580952 MAarrowhead1
% End of user PostScript
.55952 .79464 m
.56921 .7365 L
s
% Start of user PostScript
0.142857 0.857143 0.166113 0.717608 MAarrowhead1
% End of user PostScript
.55952 .85417 m
.56794 .79524 L
s
% Start of user PostScript
0.142857 1. 0.163059 0.858586 MAarrowhead1
% End of user PostScript
.61905 .02083 m
.63539 .07802 L
s
% Start of user PostScript
0.285714 -1. 0.32493 -0.862745 MAarrowhead1
% End of user PostScript
.61905 .08036 m
.63777 .13654 L
s
% Start of user PostScript
0.285714 -0.857143 0.330658 -0.722311 MAarrowhead1
% End of user PostScript
.61905 .13988 m
.64042 .1933 L
s
% Start of user PostScript
0.285714 -0.714286 0.336996 -0.586081 MAarrowhead1
% End of user PostScript
.61905 .1994 m
.6432 .24771 L
s
% Start of user PostScript
0.285714 -0.571429 0.343685 -0.455487 MAarrowhead1
% End of user PostScript
.61905 .25893 m
.64593 .29925 L
s
% Start of user PostScript
0.285714 -0.428571 0.35023 -0.331797 MAarrowhead1
% End of user PostScript
.61905 .31845 m
.64829 .34769 L
s
% Start of user PostScript
0.285714 -0.285714 0.35589 -0.215539 MAarrowhead1
% End of user PostScript
.61905 .37798 m
.64991 .39341 L
s
% Start of user PostScript
0.285714 -0.142857 0.359788 -0.10582 MAarrowhead1
% End of user PostScript
.61905 .4375 m
.65049 .4375 L
s
% Start of user PostScript
0.285714 0 0.361186 0 MAarrowhead1
% End of user PostScript
.61905 .49702 m
.64991 .48159 L
s
% Start of user PostScript
0.285714 0.142857 0.359788 0.10582 MAarrowhead1
% End of user PostScript
.61905 .55655 m
.64829 .52731 L
s
% Start of user PostScript
0.285714 0.285714 0.35589 0.215539 MAarrowhead1
% End of user PostScript
.61905 .61607 m
.64593 .57575 L
s
% Start of user PostScript
0.285714 0.428571 0.35023 0.331797 MAarrowhead1
% End of user PostScript
.61905 .6756 m
.6432 .62729 L
s
% Start of user PostScript
0.285714 0.571429 0.343685 0.455487 MAarrowhead1
% End of user PostScript
.61905 .73512 m
.64042 .6817 L
s
% Start of user PostScript
0.285714 0.714286 0.336996 0.586081 MAarrowhead1
% End of user PostScript
.61905 .79464 m
.63777 .73846 L
s
% Start of user PostScript
0.285714 0.857143 0.330658 0.722311 MAarrowhead1
% End of user PostScript
.61905 .85417 m
.63539 .79698 L
s
% Start of user PostScript
0.285714 1. 0.32493 0.862745 MAarrowhead1
% End of user PostScript
.67857 .02083 m
.70194 .07535 L
s
% Start of user PostScript
0.428571 -1. 0.484646 -0.869159 MAarrowhead1
% End of user PostScript
.67857 .08036 m
.70517 .13355 L
s
% Start of user PostScript
0.428571 -0.857143 0.492401 -0.729483 MAarrowhead1
% End of user PostScript
.67857 .13988 m
.70869 .19008 L
s
% Start of user PostScript
0.428571 -0.714286 0.500861 -0.593804 MAarrowhead1
% End of user PostScript
.67857 .1994 m
.71236 .24445 L
s
% Start of user PostScript
0.428571 -0.571429 0.509653 -0.46332 MAarrowhead1
% End of user PostScript
.67857 .25893 m
.71588 .29624 L
s
% Start of user PostScript
0.428571 -0.428571 0.518124 -0.339019 MAarrowhead1
% End of user PostScript
.67857 .31845 m
.71889 .34533 L
s
% Start of user PostScript
0.428571 -0.285714 0.525346 -0.221198 MAarrowhead1
% End of user PostScript
.67857 .37798 m
.72094 .3921 L
s
% Start of user PostScript
0.428571 -0.142857 0.530266 -0.108959 MAarrowhead1
% End of user PostScript
.67857 .4375 m
.72167 .4375 L
s
% Start of user PostScript
0.428571 0 0.53202 0 MAarrowhead1
% End of user PostScript
.67857 .49702 m
.72094 .4829 L
s
% Start of user PostScript
0.428571 0.142857 0.530266 0.108959 MAarrowhead1
% End of user PostScript
.67857 .55655 m
.71889 .52967 L
s
% Start of user PostScript
0.428571 0.285714 0.525346 0.221198 MAarrowhead1
% End of user PostScript
.67857 .61607 m
.71588 .57876 L
s
% Start of user PostScript
0.428571 0.428571 0.518124 0.339019 MAarrowhead1
% End of user PostScript
.67857 .6756 m
.71236 .63055 L
s
% Start of user PostScript
0.428571 0.571429 0.509653 0.46332 MAarrowhead1
% End of user PostScript
.67857 .73512 m
.70869 .68492 L
s
% Start of user PostScript
0.428571 0.714286 0.500861 0.593804 MAarrowhead1
% End of user PostScript
.67857 .79464 m
.70517 .74145 L
s
% Start of user PostScript
0.428571 0.857143 0.492401 0.729483 MAarrowhead1
% End of user PostScript
.67857 .85417 m
.70194 .79965 L
s
% Start of user PostScript
0.428571 1. 0.484646 0.869159 MAarrowhead1
% End of user PostScript
.7381 .02083 m
.76734 .072 L
s
% Start of user PostScript
0.571429 -1. 0.641604 -0.877193 MAarrowhead1
% End of user PostScript
.7381 .08036 m
.7711 .12986 L
s
% Start of user PostScript
0.571429 -0.857143 0.650636 -0.738331 MAarrowhead1
% End of user PostScript
.7381 .13988 m
.77513 .18618 L
s
% Start of user PostScript
0.571429 -0.714286 0.660317 -0.603175 MAarrowhead1
% End of user PostScript
.7381 .1994 m
.77925 .24056 L
s
% Start of user PostScript
0.571429 -0.571429 0.670194 -0.472663 MAarrowhead1
% End of user PostScript
.7381 .25893 m
.78314 .29271 L
s
% Start of user PostScript
0.571429 -0.428571 0.679537 -0.34749 MAarrowhead1
% End of user PostScript
.7381 .31845 m
.7864 .34261 L
s
% Start of user PostScript
0.571429 -0.285714 0.687371 -0.227743 MAarrowhead1
% End of user PostScript
.7381 .37798 m
.7886 .3906 L
s
% Start of user PostScript
0.571429 -0.142857 0.692641 -0.112554 MAarrowhead1
% End of user PostScript
.7381 .4375 m
.78938 .4375 L
s
% Start of user PostScript
0.571429 0 0.694505 0 MAarrowhead1
% End of user PostScript
.7381 .49702 m
.7886 .4844 L
s
% Start of user PostScript
0.571429 0.142857 0.692641 0.112554 MAarrowhead1
% End of user PostScript
.7381 .55655 m
.7864 .53239 L
s
% Start of user PostScript
0.571429 0.285714 0.687371 0.227743 MAarrowhead1
% End of user PostScript
.7381 .61607 m
.78314 .58229 L
s
% Start of user PostScript
0.571429 0.428571 0.679537 0.34749 MAarrowhead1
% End of user PostScript
.7381 .6756 m
.77925 .63444 L
s
% Start of user PostScript
0.571429 0.571429 0.670194 0.472663 MAarrowhead1
% End of user PostScript
.7381 .73512 m
.77513 .68882 L
s
% Start of user PostScript
0.571429 0.714286 0.660317 0.603175 MAarrowhead1
% End of user PostScript
.7381 .79464 m
.7711 .74514 L
s
% Start of user PostScript
0.571429 0.857143 0.650636 0.738331 MAarrowhead1
% End of user PostScript
.7381 .85417 m
.76734 .803 L
s
% Start of user PostScript
0.571429 1. 0.641604 0.877193 MAarrowhead1
% End of user PostScript
.79762 .02083 m
.83149 .06826 L
s
% Start of user PostScript
0.714286 -1. 0.795587 -0.886179 MAarrowhead1
% End of user PostScript
.79762 .08036 m
.8355 .12581 L
s
% Start of user PostScript
0.714286 -0.857143 0.805195 -0.748052 MAarrowhead1
% End of user PostScript
.79762 .13988 m
.83971 .18197 L
s
% Start of user PostScript
0.714286 -0.714286 0.815296 -0.613276 MAarrowhead1
% End of user PostScript
.79762 .1994 m
.84392 .23644 L
s
% Start of user PostScript
0.714286 -0.571429 0.825397 -0.48254 MAarrowhead1
% End of user PostScript
.79762 .25893 m
.84782 .28905 L
s
% Start of user PostScript
0.714286 -0.428571 0.834768 -0.356282 MAarrowhead1
% End of user PostScript
.79762 .31845 m
.85104 .33982 L
s
% Start of user PostScript
0.714286 -0.285714 0.842491 -0.234432 MAarrowhead1
% End of user PostScript
.79762 .37798 m
.85317 .38909 L
s
% Start of user PostScript
0.714286 -0.142857 0.847619 -0.11619 MAarrowhead1
% End of user PostScript
.79762 .4375 m
.85393 .4375 L
s
% Start of user PostScript
0.714286 0 0.849421 0 MAarrowhead1
% End of user PostScript
.79762 .49702 m
.85317 .48591 L
s
% Start of user PostScript
0.714286 0.142857 0.847619 0.11619 MAarrowhead1
% End of user PostScript
.79762 .55655 m
.85104 .53518 L
s
% Start of user PostScript
0.714286 0.285714 0.842491 0.234432 MAarrowhead1
% End of user PostScript
.79762 .61607 m
.84782 .58595 L
s
% Start of user PostScript
0.714286 0.428571 0.834768 0.356282 MAarrowhead1
% End of user PostScript
.79762 .6756 m
.84392 .63856 L
s
% Start of user PostScript
0.714286 0.571429 0.825397 0.48254 MAarrowhead1
% End of user PostScript
.79762 .73512 m
.83971 .69303 L
s
% Start of user PostScript
0.714286 0.714286 0.815296 0.613276 MAarrowhead1
% End of user PostScript
.79762 .79464 m
.8355 .74919 L
s
% Start of user PostScript
0.714286 0.857143 0.805195 0.748052 MAarrowhead1
% End of user PostScript
.79762 .85417 m
.83149 .80674 L
s
% Start of user PostScript
0.714286 1. 0.795587 0.886179 MAarrowhead1
% End of user PostScript
.85714 .02083 m
.89446 .06437 L
s
% Start of user PostScript
0.857143 -1. 0.946695 -0.895522 MAarrowhead1
% End of user PostScript
.85714 .08036 m
.89847 .12168 L
s
% Start of user PostScript
0.857143 -0.857143 0.956316 -0.757969 MAarrowhead1
% End of user PostScript
.85714 .13988 m
.9026 .17776 L
s
% Start of user PostScript
0.857143 -0.714286 0.966234 -0.623377 MAarrowhead1
% End of user PostScript
.85714 .1994 m
.90665 .23241 L
s
% Start of user PostScript
0.857143 -0.571429 0.975955 -0.492221 MAarrowhead1
% End of user PostScript
.85714 .25893 m
.91033 .28552 L
s
% Start of user PostScript
0.857143 -0.428571 0.984802 -0.364742 MAarrowhead1
% End of user PostScript
.85714 .31845 m
.91332 .33718 L
s
% Start of user PostScript
0.857143 -0.285714 0.991974 -0.24077 MAarrowhead1
% End of user PostScript
.85714 .37798 m
.91528 .38767 L
s
% Start of user PostScript
0.857143 -0.142857 0.996678 -0.119601 MAarrowhead1
% End of user PostScript
.85714 .4375 m
.91597 .4375 L
s
% Start of user PostScript
0.857143 0 0.998319 0 MAarrowhead1
% End of user PostScript
.85714 .49702 m
.91528 .48733 L
s
% Start of user PostScript
0.857143 0.142857 0.996678 0.119601 MAarrowhead1
% End of user PostScript
.85714 .55655 m
.91332 .53782 L
s
% Start of user PostScript
0.857143 0.285714 0.991974 0.24077 MAarrowhead1
% End of user PostScript
.85714 .61607 m
.91033 .58948 L
s
% Start of user PostScript
0.857143 0.428571 0.984802 0.364742 MAarrowhead1
% End of user PostScript
.85714 .6756 m
.90665 .64259 L
s
% Start of user PostScript
0.857143 0.571429 0.975955 0.492221 MAarrowhead1
% End of user PostScript
.85714 .73512 m
.9026 .69724 L
s
% Start of user PostScript
0.857143 0.714286 0.966234 0.623377 MAarrowhead1
% End of user PostScript
.85714 .79464 m
.89847 .75332 L
s
% Start of user PostScript
0.857143 0.857143 0.956316 0.757969 MAarrowhead1
% End of user PostScript
.85714 .85417 m
.89446 .81063 L
s
% Start of user PostScript
0.857143 1. 0.946695 0.895522 MAarrowhead1
% End of user PostScript
.91667 .02083 m
.95635 .06052 L
s
% Start of user PostScript
1. -1. 1.09524 -0.904762 MAarrowhead1
% End of user PostScript
.91667 .08036 m
.9602 .11767 L
s
% Start of user PostScript
1. -0.857143 1.10448 -0.767591 MAarrowhead1
% End of user PostScript
.91667 .13988 m
.96409 .17376 L
s
% Start of user PostScript
1. -0.714286 1.11382 -0.632985 MAarrowhead1
% End of user PostScript
.91667 .1994 m
.96784 .22864 L
s
% Start of user PostScript
1. -0.571429 1.12281 -0.501253 MAarrowhead1
% End of user PostScript
.91667 .25893 m
.97118 .28229 L
s
% Start of user PostScript
1. -0.428571 1.13084 -0.372497 MAarrowhead1
% End of user PostScript
.91667 .31845 m
.97386 .33479 L
s
% Start of user PostScript
1. -0.285714 1.13725 -0.246499 MAarrowhead1
% End of user PostScript
.91667 .37798 m
.97559 .38639 L
s
% Start of user PostScript
1. -0.142857 1.14141 -0.122655 MAarrowhead1
% End of user PostScript
.91667 .4375 m
.97619 .4375 L
s
% Start of user PostScript
1. 0 1.14286 0 MAarrowhead1
% End of user PostScript
.91667 .49702 m
.97559 .48861 L
s
% Start of user PostScript
1. 0.142857 1.14141 0.122655 MAarrowhead1
% End of user PostScript
.91667 .55655 m
.97386 .54021 L
s
% Start of user PostScript
1. 0.285714 1.13725 0.246499 MAarrowhead1
% End of user PostScript
.91667 .61607 m
.97118 .59271 L
s
% Start of user PostScript
1. 0.428571 1.13084 0.372497 MAarrowhead1
% End of user PostScript
.91667 .6756 m
.96784 .64636 L
s
% Start of user PostScript
1. 0.571429 1.12281 0.501253 MAarrowhead1
% End of user PostScript
.91667 .73512 m
.96409 .70124 L
s
% Start of user PostScript
1. 0.714286 1.11382 0.632985 MAarrowhead1
% End of user PostScript
.91667 .79464 m
.9602 .75733 L
s
% Start of user PostScript
1. 0.857143 1.10448 0.767591 MAarrowhead1
% End of user PostScript
.91667 .85417 m
.95635 .81448 L
s
% Start of user PostScript
1. 1. 1.09524 0.904762 MAarrowhead1
% End of user PostScript
0 0 m
1 0 L
1 .875 L
0 .875 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 252},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001NR000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`008`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool08P3oool00280oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0240oooo000Q0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0P0?oo
o`00803oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool07`3oool001l0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01h0oooo000N0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0M0?ooo`007@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0703oool001`0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`030000003oool0oooo01/0oooo000K0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0J0?ooo`006P3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool06P3oool001L0oooo00@0
00000?ooo`3oool000006P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000001P0
oooo000F0?ooo`@000005`3oool010000000oooo0?ooo`00000J0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`00000G0?ooo`@000005`3oool001H0
oooo1000000F0?ooo`@000006P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0
oooo0`00000G0?ooo`@000005`3oool001D0oooo1P00000E0?ooo`@000005`3oool010000000oooo
0?ooo`00000J0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0H0?ooo`040000003oool0oooo000001L0oooo1000000E0?ooo`H000005P3oool001@0
oooo1P00000E0?ooo`H000005P3oool3000001P0oooo00@000000?ooo`3oool000006P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0H0?ooo`040000003oool0oooo000001P0oooo0`00000F0?ooo`D000005P3oool5
000001H0oooo000D0?ooo`@000005`3oool5000001H0oooo1P00000F0?ooo`<00000603oool01000
0000oooo0?ooo`00000K0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool0
10000000oooo0?ooo`00000H0?ooo`<000005P3oool6000001H0oooo1@00000G0?ooo`@000005@3o
ool001<0oooo1000000G0?ooo`@00000603oool5000001L0oooo1@00000F0?ooo`<000006@3oool2
000000030?ooo`000000oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo01P0oooo00@000000?ooo`00000000006@3oool3000001H0oooo1@00
000G0?ooo`D00000603oool3000001P0oooo1000000D0?ooo`004`3oool2000001T0oooo0`00000H
0?ooo`D000005`3oool5000001L0oooo1@00000G0?ooo`D000005`3oool3000001/0oooo00<00000
0?ooo`3oool06@3oool3000001L0oooo1@00000G0?ooo`D000005`3oool5000001L0oooo1000000I
0?ooo`<000006@3oool2000001@0oooo000B0?ooo`030000003oool0oooo01P0oooo0`00000I0?oo
o`@00000603oool4000001P0oooo1000000H0?ooo`@00000603oool5000001L0oooo1@00000G0?oo
o`D000005`3oool5000001P0oooo1000000H0?ooo`@00000603oool4000001T0oooo0P00000K0?oo
o`030000003oool0oooo0140oooo000]0?ooo`030000003oool0oooo01T0oooo0P00000J0?ooo`<0
00006@3oool4000001P0oooo1000000H0?ooo`D000005`3oool5000001L0oooo1@00000H0?ooo`@0
0000603oool4000001T0oooo0`00000J0?ooo`8000006`3oool00`000000oooo0?ooo`0/0?ooo`00
B03oool2000001/0oooo0`00000H0?ooo`@000006@3oool3000001T0oooo1000000H0?ooo`@00000
6@3oool4000001P0oooo1000000I0?ooo`@00000603oool3000001/0oooo0P0000190?ooo`00B03o
ool00`000000oooo0?ooo`0I0?ooo`<000006@3oool3000001X0oooo0`00000I0?ooo`@000006@3o
ool3000001T0oooo1000000I0?ooo`<000006P3oool3000001T0oooo0`00000K0?ooo`030000003o
ool0oooo04L0oooo001T0?ooo`8000006P3oool2000001/0oooo0P00000K0?ooo`8000006P3oool3
000001T0oooo0`00000J0?ooo`<000006`3oool2000001X0oooo0P00001U0?ooo`00I03oool00`00
0000oooo0?ooo`0I0?ooo`8000006`3oool2000001/0oooo0P00000J0?ooo`<000006P3oool20000
01/0oooo0P00000K0?ooo`8000006`3oool00`000000oooo0?ooo`1S0?ooo`00P03oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo01X0oooo0P00000J0?ooo`8000006`3oool2000001/0
oooo0P00000L0?ooo`030000003oool0oooo07l0oooo002M0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0W03oool002<0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01<0oooo00@000000?ooo`3oool000006@3oool00`000000oooo
0?ooo`0G0?ooo`040000003oool0oooo000001D0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo0280oooo000R0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0Q0?ooo`008@3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0803oool00200oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01l0oooo000N0?oo
o`8000006@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0G0?ooo`8000007`3oool001d0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01`0oooo000L0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0K0?ooo`006`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06P3o
ool001X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01T0oooo000F0?ooo`040000003oool0oooo000001X0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
10000000oooo0?ooo`00000G0?ooo`005@3oool4000001L0oooo00@000000?ooo`3oool000006P3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool00000
5`3oool4000001H0oooo000E0?ooo`@000005P3oool4000001/0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`@000005P3oool4000001H0oooo000D0?ooo`H000005@3oool4
000001L0oooo00@000000?ooo`3oool000006P3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0603oool010000000oooo0?ooo`00000G0?ooo`@00000
5@3oool6000001D0oooo000C0?ooo`H000005@3oool6000001D0oooo1000000H0?ooo`030000003o
ool0000001`0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0000000H0?ooo`<000005P3o
ool6000001D0oooo1P00000D0?ooo`004P3oool5000001H0oooo1P00000F0?ooo`H000005P3oool3
000001T0oooo00<000000?ooo`0000006`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`0000006@3oool3000001H0oooo1P00000F0?ooo`D000005`3oool5
000001<0oooo000B0?ooo`<00000603oool4000001L0oooo1P00000F0?ooo`D00000603oool30000
01/0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`<00000603oool50000
01H0oooo1@00000H0?ooo`@00000603oool3000001<0oooo000A0?ooo`8000006@3oool4000001P0
oooo1@00000G0?ooo`H000005`3oool4000001L0oooo0P0000000`3oool000000?ooo`0G0?ooo`<0
0000703oool00`000000oooo0?ooo`0J0?ooo`<00000603oool010000000oooo00000000000G0?oo
o`@000005`3oool6000001L0oooo1@00000H0?ooo`@000006@3oool200000180oooo000/0?ooo`80
00006@3oool4000001P0oooo1P00000G0?ooo`@00000603oool5000001L0oooo1P00000G0?ooo`D0
00005`3oool6000001L0oooo1@00000H0?ooo`@000005`3oool5000001T0oooo0`00000J0?ooo`80
0000;@3oool002/0oooo00<000000?ooo`3oool06@3oool3000001T0oooo1000000I0?ooo`@00000
603oool4000001P0oooo1@00000H0?ooo`D000005`3oool6000001P0oooo1000000H0?ooo`@00000
6@3oool4000001T0oooo0`00000K0?ooo`030000003oool0oooo02X0oooo00160?ooo`<000006P3o
ool3000001X0oooo0`00000I0?ooo`@00000603oool5000001P0oooo1000000I0?ooo`D00000603o
ool4000001T0oooo0`00000J0?ooo`<000006P3oool2000004P0oooo00160?ooo`030000003oool0
oooo01T0oooo0`00000K0?ooo`8000006P3oool3000001T0oooo1000000J0?ooo`<000006@3oool5
000001T0oooo0`00000J0?ooo`8000006`3oool3000001/0oooo00<000000?ooo`3oool0A@3oool0
0680oooo00<000000?ooo`3oool06P3oool2000001/0oooo0`00000J0?ooo`<000006P3oool30000
01X0oooo0`00000J0?ooo`<000006`3oool2000001`0oooo00<000000?ooo`3oool0H@3oool007l0
oooo0P00000K0?ooo`8000006`3oool2000001/0oooo0`00000J0?ooo`<000006`3oool2000001/0
oooo0P0000200?ooo`00O`3oool00`000000oooo0?ooo`0J0?ooo`8000006`3oool2000001/0oooo
0P00000L0?ooo`8000006`3oool2000001`0oooo00<000000?ooo`3oool0OP3oool009`0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01X0oooo0P00
000L0?ooo`030000003oool0oooo09/0oooo002i0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`2h0?ooo`008`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool08P3oool00240oooo0P00000I0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo01L0oooo0P00000R0?ooo`00803oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool07`3oool001l0oooo00<000000?ooo`3oool05`3o
ool2000001T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`8000006@3o
ool00`000000oooo0?ooo`0N0?ooo`007@3oool2000001T0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool2
000001h0oooo000L0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0K0?ooo`006P3oool2000001X0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool2000001/0
oooo000I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0H0?ooo`005@3oool010000000oooo00000000000J0?ooo`8000006P3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo0P00000J0?ooo`80000000<0oooo0000003oool0
5@3oool001@0oooo0`00000H0?ooo`040000003oool0oooo000001/0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo000001P0oooo0`00000E0?ooo`00
4`3oool4000001L0oooo1000000G0?ooo`050000003oool0oooo0?ooo`0000006P3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool01@000000
oooo0?ooo`3oool0000001L0oooo1000000G0?ooo`@00000503oool00180oooo1P00000F0?ooo`@0
00005P3oool3000000030?ooo`000000oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00@000000?ooo`00000000005`3oool40000
01H0oooo1P00000C0?ooo`004@3oool5000001L0oooo1P00000E0?ooo`@00000603oool00`000000
oooo0000000L0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`000000603oool4000001D0
oooo1P00000G0?ooo`D000004P3oool00100oooo1000000H0?ooo`H000005@3oool6000001H0oooo
1000000I0?ooo`030000003oool0000001`0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0000001T0oooo0`00000G0?ooo`D000005P3oool6000001P0oooo
1000000A0?ooo`003`3oool2000001X0oooo1@00000G0?ooo`D000005`3oool6000001L0oooo0`00
000I0?ooo`040000003oool0oooo000001/0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`0000006@3oool3000001L0oooo
1P00000G0?ooo`D000005`3oool5000001X0oooo0P00000@0?ooo`00:`3oool3000001P0oooo1000
000H0?ooo`H000005`3oool5000001P0oooo0`00000I0?ooo`<000006P3oool5000001T0oooo00@0
00000?ooo`00000000006@3oool3000001P0oooo1@00000G0?ooo`D000006@3oool3000001T0oooo
0`00000/0?ooo`00:P3oool2000001X0oooo0`00000I0?ooo`D00000603oool4000001T0oooo1@00
000G0?ooo`D00000603oool5000001P0oooo1@00000G0?ooo`D000006@3oool4000001P0oooo1@00
000I0?ooo`<000006P3oool2000002/0oooo00150?ooo`<000006@3oool4000001T0oooo1000000J
0?ooo`@00000603oool5000001P0oooo1@00000H0?ooo`D00000603oool5000001T0oooo0`00000J
0?ooo`<000006P3oool2000004L0oooo00150?ooo`030000003oool0oooo01T0oooo0`00000J0?oo
o`<000006`3oool4000001P0oooo1000000J0?ooo`<000006P3oool4000001T0oooo1000000J0?oo
o`<000006P3oool3000001/0oooo00<000000?ooo`3oool0A03oool00600oooo0`00000K0?ooo`80
00006`3oool4000001T0oooo1000000J0?ooo`<000006P3oool4000001X0oooo0`00000K0?ooo`80
00006`3oool200000680oooo001P0?ooo`030000003oool0oooo01X0oooo0P00000L0?ooo`<00000
6`3oool2000001/0oooo0`00000J0?ooo`<000006`3oool3000001`0oooo0P00000L0?ooo`030000
003oool0oooo05l0oooo001m0?ooo`030000003oool0oooo01/0oooo0P00000L0?ooo`8000006`3o
ool3000001/0oooo0P00000L0?ooo`<00000703oool00`000000oooo0?ooo`1l0?ooo`00V`3oool2
000001`0oooo0P00000L0?ooo`030000003oool0oooo01X0oooo0P00000M0?ooo`800000V`3oool0
09/0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`2I0?ooo`00^@3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0^03oool002<0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0280oooo
000Q0?ooo`800000603oool2000001T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0G0?ooo`800000603oool200000280oooo000O0?ooo`8000006@3oool00`000000oooo0?ooo`0G
0?ooo`800000603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool05P3oool2000001T0oooo00<000000?ooo`3oool05`3oool200000200oooo000N0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0M0?oo
o`00703oool2000001T0oooo0P00000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool05`3oool2000001T0oooo0P00000M0?ooo`006P3oool2000001X0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool2000001/0oooo000I0?ooo`030000003oool0oooo01P0oooo0P00000I0?ooo`8000006@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool05`3o
ool2000001T0oooo0P00000J0?ooo`030000003oool0oooo01P0oooo000D0?ooo`030000003oool0
oooo008000006P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`8000000P3oool00`000000oooo0?ooo`0C
0?ooo`004`3oool4000001L0oooo00D000000?ooo`3oool0oooo0000000J0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool01@000000oooo0?ooo`3oool0000001L0oooo1000
000D0?ooo`004P3oool4000001L0oooo0P0000000`3oool000000000000F0?ooo`050000003oool0
oooo0?ooo`0000006P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool06@3oool01@000000oooo0?ooo`3oool0000001H0oooo1@00000G0?ooo`@00000
4`3oool00100oooo1P00000F0?ooo`@000005`3oool5000001/0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo1@00000G0?ooo`@000005@3o
ool700000140oooo000?0?ooo`P00000503oool5000001L0oooo0`00000I0?ooo`040000003oool0
oooo000001/0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`00000H0?ooo`@00000
5P3oool6000001@0oooo2000000@0?ooo`003P3oool6000001L0oooo1P00000E0?ooo`D000005`3o
ool4000001T0oooo00@000000?ooo`3oool000006`3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01T0oooo00@000000?ooo`3oool000006@3oool4000001L0oooo1@00000E0?ooo`H0
00005`3oool6000000l0oooo000=0?ooo`<000006P3oool5000001H0oooo1`00000F0?ooo`@00000
6@3oool3000001T0oooo00<000000?ooo`0000006P3oool3000001`0oooo00<000000?ooo`3oool0
6P3oool3000001X0oooo00<000000?ooo`0000006@3oool3000001T0oooo1000000F0?ooo`L00000
5P3oool5000001X0oooo0`00000>0?ooo`00:@3oool4000001L0oooo1P00000G0?ooo`H000005`3o
ool5000001P0oooo0`00000J0?ooo`D00000603oool5000001P0oooo1@00000J0?ooo`<00000603o
ool5000001L0oooo1P00000G0?ooo`H000005`3oool4000002X0oooo000X0?ooo`8000006P3oool4
000001T0oooo1@00000H0?ooo`@00000603oool6000001P0oooo1000000I0?ooo`D00000603oool5
000001P0oooo1@00000I0?ooo`@00000603oool5000001T0oooo1000000J0?ooo`800000:@3oool0
04<0oooo0P00000K0?ooo`@000006@3oool4000001T0oooo1@00000I0?ooo`@000006@3oool50000
01T0oooo1000000I0?ooo`D000006@3oool3000001X0oooo1000000K0?ooo`800000A03oool00600
oooo0P00000K0?ooo`<000006P3oool4000001X0oooo0`00000K0?ooo`<000006P3oool4000001X0
oooo1000000J0?ooo`<000006`3oool200000640oooo001O0?ooo`030000003oool0oooo01/0oooo
0P00000K0?ooo`<000006`3oool3000001/0oooo0`00000K0?ooo`<000006`3oool3000001/0oooo
0P00000M0?ooo`030000003oool0oooo05h0oooo001l0?ooo`8000006`3oool3000001`0oooo0P00
000L0?ooo`<000006`3oool3000001`0oooo0P00000L0?ooo`800000O@3oool007`0oooo00<00000
0?ooo`3oool06P3oool2000001d0oooo0P00000L0?ooo`<00000703oool2000001d0oooo0P00000L
0?ooo`030000003oool0oooo07/0oooo002I0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0K0?ooo`8000007P3oool00`000000oooo0?ooo`2H0?oo
o`00^03oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3o
ool0]`3oool00=L0oooo00<000000?ooo`3oool0eP3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0280oooo0P00000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo0P00000S0?ooo`00803oool2000001T0
oooo0P00000H0?ooo`800000603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool05P3oool2000001P0oooo0P00000I0?ooo`8000008@3oool001h0oooo
0P00000I0?ooo`800000603oool2000001P0oooo0P00000I0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo
0P00000H0?ooo`800000603oool2000001T0oooo0P00000O0?ooo`006`3oool3000001T0oooo0P00
000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool2000001T0oooo0`00
000L0?ooo`006@3oool2000001X0oooo0P00000I0?ooo`8000006@3oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool2000001T0oooo0P00000J
0?ooo`8000006P3oool001<0oooo00@000000?ooo`3oool0oooo0P00000J0?ooo`8000006@3oool2
000001X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01P0oooo0P00000I0?ooo`8000006P3oool2000000<0oooo00<000000?ooo`3oool04P3oool0
0140oooo0`0000000`3oool000000000000F0?ooo`040000003oool0oooo0?ooo`8000006P3oool0
0`000000oooo0?ooo`0H0?ooo`8000006P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`8000006P3oool0
0`000000oooo0?ooo`0H0?ooo`8000000`3oool00`000000oooo0?ooo`0D0?ooo`H000004P3oool0
0100oooo1@00000G0?ooo`80000000<0oooo0000000000005P3oool010000000oooo0?ooo`3oool2
000001X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo0P0000030?ooo`030000003oool0oooo01@0oooo1@00000G0?ooo`D000004@3oool0
00l0oooo1P00000F0?ooo`@000005`3oool5000001P0oooo00@000000?ooo`3oool000006`3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0I0?ooo`040000003oool0oooo000001P0oooo1@00000G0?ooo`@000005@3o
ool700000100oooo000=0?ooo`T000004`3oool6000001H0oooo1@00000H0?ooo`@000006@3oool0
0`000000oooo0000000I0?ooo`040000003oool0oooo000001/0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool00000
6@3oool00`000000oooo0000000I0?ooo`@00000603oool5000001D0oooo1`00000C0?ooo`T00000
3P3oool000`0oooo1@00000G0?ooo`P00000503oool7000001H0oooo1000000I0?ooo`<000006P3o
ool3000001X0oooo0`00000J0?ooo`D000006P3oool3000001X0oooo0`00000J0?ooo`<000006@3o
ool4000001H0oooo1`00000D0?ooo`P000005`3oool5000000d0oooo000W0?ooo`H000005P3oool6
000001L0oooo1P00000H0?ooo`@00000603oool6000001P0oooo1@00000H0?ooo`D00000603oool5
000001P0oooo1P00000H0?ooo`@00000603oool6000001L0oooo1P00000F0?ooo`H00000:03oool0
02H0oooo0`00000I0?ooo`@000006P3oool5000001P0oooo1P00000G0?ooo`D000006@3oool40000
01T0oooo1@00000I0?ooo`@000006@3oool5000001L0oooo1P00000H0?ooo`D000006P3oool40000
01T0oooo0`00000W0?ooo`00@@3oool2000001`0oooo1000000I0?ooo`H000005`3oool5000001X0
oooo1000000J0?ooo`<000006P3oool4000001X0oooo1000000H0?ooo`H000006@3oool4000001`0
oooo0P0000120?ooo`00GP3oool3000001X0oooo1@00000I0?ooo`@000006P3oool4000001/0oooo
0`00000K0?ooo`<000006`3oool4000001T0oooo1@00000J0?ooo`<00000G`3oool005d0oooo0P00
000L0?ooo`<000006`3oool2000001`0oooo0`00000L0?ooo`<00000703oool3000001`0oooo0P00
000K0?ooo`<00000703oool2000005h0oooo001j0?ooo`800000703oool2000001d0oooo0P00000M
0?ooo`<000007@3oool2000001d0oooo0P00000L0?ooo`800000N`3oool009P0oooo00<000000?oo
o`3oool0703oool2000001h0oooo00<000000?ooo`3oool0703oool2000001h0oooo00<000000?oo
o`3oool0U`3oool00;L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo0;H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003o0?oook40oooo003o
0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo000R
0?ooo`800000603oool2000001P0oooo0P00000H0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`800000603oool2000001P0oooo0P00000S
0?ooo`007P3oool4000001L0oooo0`00000H0?ooo`800000603oool2000001P0oooo0P00000I0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool2000001P0oooo0P00000H0?oo
o`800000603oool3000001L0oooo1000000O0?ooo`004`3oool00`000000oooo0?ooo`050?ooo`<0
0000603oool3000001P0oooo0`00000H0?ooo`8000006@3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`80
0000603oool3000001P0oooo0`00000H0?ooo`<000001`3oool00`000000oooo0?ooo`0B0?ooo`00
4@3oool3000000@0oooo0`00000A0?ooo`030000003oool0oooo00@0oooo0`00000I0?ooo`800000
6@3oool2000001T0oooo0P00000J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool2000001T0oooo0P00000I0?ooo`8000006@3oool3000000H0oooo00<000000?ooo`3oool0
3`3oool3000000@0oooo0`00000B0?ooo`00403oool800000180oooo0`0000030?ooo`<00000503o
ool00`000000oooo0?ooo`020?ooo`<000004`3oool00`000000oooo0?ooo`030?ooo`8000006P3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`0000006`3o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0000001P0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`8000001@3oool00`000000oooo0?ooo`0A0?ooo`<00000103o
ool00`000000oooo0?ooo`0B0?ooo`<000000P3oool400000180oooo2000000A0?ooo`003P3oool7
000001@0oooo1`00000E0?ooo`<0000000@0oooo00000000000000005@3oool2000000<0oooo0P00
000G0?ooo`030000003oool0oooo00800000603oool010000000oooo0?ooo`00000I0?ooo`<00000
6@3oool5000001T0oooo0`00000I0?ooo`040000003oool0oooo000001P0oooo0P0000020?ooo`03
0000003oool0oooo01D0oooo0P0000020?ooo`<000005@3oool7000001D0oooo1`00000D0?ooo`L0
00003`3oool000`0oooo2@00000C0?ooo`H000005P3oool5000001L0oooo1P00000H0?ooo`@00000
6@3oool4000001X0oooo1000000H0?ooo`D000005`3oool5000001X0oooo1000000I0?ooo`@00000
603oool6000001L0oooo1@00000E0?ooo`L000004`3oool9000000d0oooo000;0?ooo`D000005P3o
ool9000001@0oooo1P00000F0?ooo`D000006@3oool4000001X0oooo1000000I0?ooo`@000006@3o
ool4000001T0oooo1@00000I0?ooo`@000006P3oool4000001P0oooo1P00000E0?ooo`L00000503o
ool9000001H0oooo1@00000<0?ooo`009@3oool5000001L0oooo2@00000D0?ooo`L000005`3oool6
000001P0oooo1P00000H0?ooo`@000006P3oool3000001X0oooo1000000H0?ooo`H00000603oool6
000001L0oooo1`00000D0?ooo`T000005`3oool5000002H0oooo00100?ooo`D00000603oool60000
01P0oooo1@00000I0?ooo`H000006@3oool3000001/0oooo0`00000K0?ooo`<000006@3oool60000
01T0oooo1@00000H0?ooo`H00000603oool500000440oooo001L0?ooo`<000006`3oool4000001X0
oooo1@00000K0?ooo`800000703oool3000001/0oooo0`00000K0?ooo`D000006P3oool4000001/0
oooo0`00001M0?ooo`00N@3oool2000001d0oooo0`00000L0?ooo`8000007@3oool2000001d0oooo
0`00000L0?ooo`<000007@3oool2000007X0oooo002G0?ooo`8000007P3oool2000001h0oooo00<0
00000?ooo`3oool0703oool2000001h0oooo0P00002H0?ooo`00]`3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0]P3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00=D0oooo1@00003F0?oo
o`00803oool4000001L0oooo0`00000G0?ooo`<000005`3oool2000001P0oooo0P00000I0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`0000005`3oool5000001L0oooo00<000000?ooo`00
00005P3oool00`000000oooo0?ooo`0G0?ooo`800000603oool2000001L0oooo0`00000G0?ooo`<0
00005`3oool400000240oooo000A0?ooo`8000001`3oool6000000`0oooo00<000000?ooo`3oool0
1`3oool5000000`0oooo00<000000?ooo`3oool01P3oool5000001H0oooo1000000G0?ooo`<00000
503oool00`000000oooo0?ooo`020?ooo`8000005P3oool3000001P0oooo1@00000H0?ooo`<00000
5P3oool2000000@0oooo00<000000?ooo`3oool04P3oool3000001L0oooo1000000F0?ooo`D00000
203oool00`000000oooo0?ooo`0:0?ooo`D000002@3oool00`000000oooo0?ooo`0:0?ooo`H00000
1`3oool200000180oooo000?0?ooo`@0000000<0oooo0000000000001000000@0?ooo`<00000103o
ool5000000l0oooo0`0000040?ooo`@000004P3oool00`000000oooo0?ooo`030?ooo`<00000503o
ool010000000oooo0?ooo`3oool3000001H0oooo0P0000020?ooo`800000603oool4000001P0oooo
0`00000H0?ooo`@00000603oool2000000040?ooo`0000000000000001H0oooo0`0000030?ooo`03
0000003oool0oooo0180oooo0`0000040?ooo`030000003oool0oooo0140oooo100000040?ooo`<0
00003`3oool5000000@0oooo0`00000@0?ooo`H0000000<0oooo0000000000000P00000@0?ooo`00
303oool8000001@0oooo2@00000B0?ooo`T00000503oool3000000030?ooo`000000000000800000
5@3oool6000001P0oooo1@00000I0?ooo`H000005`3oool3000001L0oooo1P00000I0?ooo`D00000
603oool6000001D0oooo1`00000E0?ooo`T000004P3oool9000001@0oooo2000000=0?ooo`002P3o
ool:00000180oooo2000000C0?ooo`P000005@3oool6000001L0oooo1P00000H0?ooo`H000006@3o
ool6000001P0oooo0`00000H0?ooo`H00000603oool7000001P0oooo1P00000F0?ooo`H000005P3o
ool8000001<0oooo2000000B0?ooo`X000002`3oool000l0oooo1@00000@0?ooo`X000004@3oool:
000001<0oooo2000000E0?ooo`P000005`3oool8000001L0oooo1@00000J0?ooo`<000006P3oool5
000001L0oooo2000000F0?ooo`T00000503oool8000001@0oooo2P00000A0?ooo`X00000403oool5
00000100oooo00140?ooo`D000004P3oool:000001<0oooo2P00000E0?ooo`H000006P3oool30000
01d0oooo00<000000?ooo`3oool06`3oool3000001X0oooo1P00000E0?ooo`X000004`3oool:0000
0180oooo1@0000150?ooo`00UP3oool3000001d0oooo0P00000O0?ooo`030000003oool0oooo01d0
oooo0P00000M0?ooo`<00000U`3oool00=L0oooo00<000000?ooo`3oool0eP3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00140oooo0P00
000H0?ooo`8000006@3oool2000001T0oooo0`00000J0?ooo`<00000703oool3000001d0oooo0`00
000_0?ooo`<000007@3oool3000001`0oooo0`00000J0?ooo`<000006@3oool2000001T0oooo0P00
000H0?ooo`8000004P3oool000d0oooo1P00000D0?ooo`H000005@3oool6000001D0oooo1`00000F
0?ooo`L00000603oool7000001T0oooo1`00000_0?ooo`L000006@3oool7000001P0oooo1`00000F
0?ooo`L000005@3oool6000001D0oooo1P00000D0?ooo`H000003P3oool000X0oooo=00000000`3o
ool000000000000G00000080oooo5`0000060?oooa@000002`3oool?00000140oooo2P00000G0?oo
o`030000003oool0oooo01D0oooo2P00000A0?ooo`l000002`3ooolD000000H0oooo5`0000020?oo
oaT0000000<0oooo000000000000<P00000;0?ooo`00303oool7000001<0oooo1`00000D0?ooo`L0
00005@3oool7000001H0oooo1`00000H0?ooo`L000006@3oool7000002l0oooo1`00000I0?ooo`L0
0000603oool7000001H0oooo1`00000E0?ooo`L00000503oool7000001<0oooo1`00000=0?ooo`00
403oool3000001L0oooo0`00000H0?ooo`<000006@3oool3000001X0oooo0`00000L0?ooo`<00000
7@3oool3000002l0oooo0`00000M0?ooo`<00000703oool3000001X0oooo0`00000I0?ooo`<00000
603oool3000001L0oooo0`00000A0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00UP3oool3
000001d0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo01/0oooo0`00002G0?ooo`00A03oool500000180oooo2P00000C0?ooo`X000005@3oool60000
01X0oooo0P00000N0?ooo`030000003oool0oooo01`0oooo0P00000J0?ooo`H000005@3oool:0000
01<0oooo2P00000B0?ooo`D00000A@3oool000l0oooo1@00000@0?ooo`X000004@3oool:000001<0
oooo2000000E0?ooo`P000005`3oool8000001L0oooo1000000K0?ooo`<000006`3oool4000001L0
oooo2000000F0?ooo`T00000503oool9000001<0oooo2P00000A0?ooo`X00000403oool500000100
oooo000:0?ooo`X000004@3oool900000180oooo2@00000E0?ooo`H000005`3oool6000001P0oooo
1P00000I0?ooo`D000006@3oool3000001T0oooo1@00000H0?ooo`L00000603oool6000001H0oooo
1`00000E0?ooo`T000004P3oool900000140oooo2P00000;0?ooo`00303oool8000001<0oooo2P00
000A0?ooo`T000005@3oool3000000030?ooo`0000000000008000005@3oool6000001P0oooo1000
000J0?ooo`H000005`3oool3000001L0oooo1P00000J0?ooo`@00000603oool6000001D0oooo2000
000E0?ooo`T000004@3oool:000001<0oooo2000000=0?ooo`003P3oool5000000030?ooo`000000
000000@000003`3oool4000000@0oooo1@00000>0?ooo`@000000`3oool500000180oooo00<00000
0?ooo`3oool00`3oool3000001@0oooo00@000000?ooo`3oool0oooo0`00000F0?ooo`80000000<0
oooo0000000000006@3oool4000001P0oooo0`00000H0?ooo`@000006@3oool5000001H0oooo0`00
00030?ooo`030000003oool0oooo0180oooo0`0000040?ooo`8000004P3oool5000000<0oooo1000
000>0?ooo`D00000103oool4000000l0oooo1P0000000`3oool0000000000003000000l0oooo000A
0?ooo`8000001`3oool6000000/0oooo0P0000090?ooo`D000002`3oool2000000P0oooo1@00000F
0?ooo`@000005`3oool3000001@0oooo00@000000?ooo`3oool0oooo0P00000G0?ooo`<00000603o
ool5000001P0oooo0`00000G0?ooo`8000000`3oool00`000000oooo0?ooo`0B0?ooo`<000005`3o
ool4000001H0oooo1@0000080?ooo`8000002`3oool5000000T0oooo0P00000;0?ooo`H000001`3o
ool200000180oooo000P0?ooo`@000005`3oool3000001L0oooo0`00000G0?ooo`800000603oool2
000001P0oooo0P00000F0?ooo`030000003oool0000001L0oooo1@00000G0?ooo`030000003oool0
000001H0oooo0P00000H0?ooo`800000603oool2000001L0oooo0`00000G0?ooo`<000005`3oool4
00000240oooo003E0?ooo`D00000eP3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00;L0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0M0?ooo`030000003oool0oooo0;H0oooo002G0?ooo`030000003oool0oooo01d0oooo
0P00000N0?ooo`030000003oool0oooo01`0oooo0P00000O0?ooo`030000003oool0oooo09H0oooo
001i0?ooo`8000007@3oool2000001d0oooo0P00000M0?ooo`8000007@3oool3000001d0oooo0P00
000M0?ooo`800000NP3oool005`0oooo0P00000L0?ooo`<000006`3oool4000001`0oooo0P00000L
0?ooo`<000006`3oool3000001`0oooo1000000K0?ooo`<00000703oool2000005d0oooo00100?oo
o`D00000603oool5000001T0oooo1@00000I0?ooo`D000006P3oool3000001/0oooo0`00000K0?oo
o`<000006P3oool5000001T0oooo1@00000I0?ooo`D00000603oool500000440oooo000U0?ooo`D0
00005`3oool9000001@0oooo1`00000G0?ooo`H00000603oool6000001P0oooo1000000J0?ooo`<0
00006P3oool4000001P0oooo1P00000H0?ooo`H000005`3oool7000001@0oooo2@00000G0?ooo`D0
00009P3oool000/0oooo1@00000F0?ooo`T00000503oool6000001H0oooo1@00000I0?ooo`@00000
6P3oool4000001T0oooo1000000I0?ooo`@000006@3oool5000001T0oooo1000000J0?ooo`@00000
603oool6000001D0oooo1`00000D0?ooo`T000005P3oool5000000`0oooo000<0?ooo`T000004`3o
ool6000001H0oooo1@00000G0?ooo`D000006@3oool4000001T0oooo1000000J0?ooo`@00000603o
ool5000001L0oooo1@00000J0?ooo`@000006@3oool4000001T0oooo1@00000G0?ooo`D000005@3o
ool7000001<0oooo2@00000=0?ooo`003P3oool7000001@0oooo1`00000E0?ooo`<0000000@0oooo
00000000000000005@3oool200000080oooo0P00000H0?ooo`030000003oool0oooo00800000603o
ool010000000oooo0?ooo`00000I0?ooo`<000006@3oool5000001P0oooo1000000I0?ooo`040000
003oool0oooo000001P0oooo0P0000020?ooo`030000003oool0oooo01H0oooo0P000000103oool0
000000000000000E0?ooo`L000005@3oool7000001@0oooo1`00000?0?ooo`003`3oool8000001<0
oooo0`0000030?ooo`<00000503oool00`000000oooo0?ooo`020?ooo`<000004`3oool00`000000
oooo0?ooo`020?ooo`8000006`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`0000006`3oool00`000000oooo0?ooo`0I0?ooo`<00000603oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo0P0000040?ooo`030000003oool0oooo0140
oooo0`0000040?ooo`030000003oool0oooo0180oooo0`0000020?ooo`@000004`3oool800000100
oooo000A0?ooo`<000000`3oool400000140oooo00<000000?ooo`3oool0103oool3000001T0oooo
0P00000H0?ooo`8000006P3oool2000001X0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`8000006P3oool2000001P0oooo0P00000I0?ooo`<000001P3oool00`000000oooo
0?ooo`0?0?ooo`@000000`3oool300000180oooo000C0?ooo`030000003oool0oooo00D0oooo0`00
000H0?ooo`<00000603oool3000001L0oooo0P00000J0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo0P00
000G0?ooo`<00000603oool3000001P0oooo0`0000070?ooo`030000003oool0oooo0180oooo000N
0?ooo`@000005`3oool3000001P0oooo0P00000G0?ooo`8000006@3oool2000001T0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`8000006@3oool2000001L0oooo0P00000H
0?ooo`<000005`3oool4000001l0oooo000R0?ooo`800000603oool2000001P0oooo0P00000G0?oo
o`8000006@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`8000005`3oool2000001P0oooo0P00000H0?oo
o`8000008`3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00=L0oooo00<000000?ooo`3oool0eP3oool00;L0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0;H0oooo002H
0?ooo`030000003oool0oooo01`0oooo0P00000N0?ooo`030000003oool0oooo01`0oooo0P00000N
0?ooo`030000003oool0oooo09L0oooo001j0?ooo`030000003oool0oooo01/0oooo0P00000M0?oo
o`8000007@3oool3000001d0oooo0P00000M0?ooo`8000007@3oool00`000000oooo0?ooo`1i0?oo
o`00G@3oool00`000000oooo0?ooo`0K0?ooo`800000703oool2000001`0oooo0`00000L0?ooo`<0
0000703oool3000001`0oooo0P00000L0?ooo`8000007@3oool00`000000oooo0?ooo`1L0?ooo`00
GP3oool2000001/0oooo1000000J0?ooo`@000006P3oool4000001/0oooo0`00000K0?ooo`@00000
6P3oool4000001X0oooo1000000K0?ooo`800000G`3oool00440oooo0P00000L0?ooo`<000006P3o
ool5000001P0oooo1@00000J0?ooo`@000006P3oool3000001X0oooo1000000J0?ooo`@000006@3o
ool5000001X0oooo0`00000L0?ooo`800000@P3oool002H0oooo0`00000I0?ooo`@000006P3oool4
000001T0oooo1P00000G0?ooo`D000006@3oool4000001T0oooo1@00000I0?ooo`@000006@3oool5
000001L0oooo1P00000I0?ooo`@000006P3oool4000001T0oooo0`00000W0?ooo`009`3oool60000
01H0oooo1P00000G0?ooo`H00000603oool4000001P0oooo1P00000H0?ooo`D00000603oool50000
01P0oooo1@00000H0?ooo`H00000603oool4000001P0oooo1P00000G0?ooo`H000005P3oool60000
02P0oooo000<0?ooo`D000005`3oool8000001@0oooo1`00000F0?ooo`@000006@3oool3000001X0
oooo1000000I0?ooo`@000006@3oool5000001T0oooo1000000I0?ooo`@000006P3oool3000001T0
oooo1000000F0?ooo`L00000503oool8000001L0oooo1@00000=0?ooo`003@3oool9000001<0oooo
1P00000F0?ooo`D00000603oool4000001T0oooo00<000000?ooo`0000006@3oool2000000030?oo
o`000000oooo01P0oooo0`00000L0?ooo`030000003oool0oooo01X0oooo0`00000I0?ooo`040000
003oool00000000001T0oooo00<000000?ooo`0000006@3oool4000001P0oooo1@00000E0?ooo`L0
00004`3oool9000000h0oooo000?0?ooo`H000005P3oool4000001L0oooo1@00000H0?ooo`040000
003oool0oooo000001/0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool010000000oooo0?ooo`00000H0?oo
o`D000005`3oool4000001D0oooo1`00000@0?ooo`00403oool5000001L0oooo0P0000000`3oool0
00000000000F0?ooo`050000003oool0oooo0?ooo`0000006`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool01@000000oooo0?ooo`3oool0
000001H0oooo1@00000G0?ooo`D000004@3oool00140oooo0`0000000`3oool000000000000F0?oo
o`040000003oool0oooo0?ooo`8000006@3oool2000001X0oooo0P00000J0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo01P0oooo0P00000J0?ooo`8000006@3oool2000000<0oooo00<000000?ooo`3oool0503oool6
00000180oooo000C0?ooo`040000003oool0oooo0?ooo`8000006P3oool2000001T0oooo0P00000J
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H
0?ooo`8000006@3oool2000001X0oooo0P0000030?ooo`030000003oool0oooo0180oooo000I0?oo
o`8000006P3oool2000001T0oooo0P00000I0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0G0?ooo`8000006@3oool2000001X0oooo0P00000J0?oo
o`006`3oool3000001T0oooo0P00000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool05`3oool2000001T0oooo0`00000L0?ooo`007P3oool2000001T0oooo0P00000H0?ooo`800000
603oool2000001T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool2000001P0oooo0P00000H0?ooo`800000
6@3oool2000001l0oooo000P0?ooo`8000006@3oool2000001P0oooo0P00000H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`800000603o
ool2000001T0oooo0P00000Q0?ooo`008P3oool2000001T0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool2
000002<0oooo003o0?oook40oooo003o0?oook40oooo003G0?ooo`030000003oool0oooo0=H0oooo
002h0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`2g0?ooo`00V@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool06`3oool2000001h0oooo00<000000?ooo`3oool0V03oool007`0oooo00<000000?oo
o`3oool06P3oool2000001d0oooo0P00000L0?ooo`<00000703oool2000001d0oooo0P00000L0?oo
o`030000003oool0oooo07/0oooo001l0?ooo`8000006`3oool3000001`0oooo0P00000L0?ooo`<0
00006`3oool3000001`0oooo0P00000L0?ooo`800000O@3oool005l0oooo00<000000?ooo`3oool0
6`3oool2000001/0oooo0`00000K0?ooo`<000006`3oool3000001/0oooo0`00000K0?ooo`<00000
6`3oool2000001d0oooo00<000000?ooo`3oool0GP3oool00600oooo0P00000K0?ooo`<000006P3o
ool3000001/0oooo0`00000K0?ooo`<000006P3oool4000001/0oooo0`00000J0?ooo`<000006`3o
ool200000640oooo00130?ooo`8000006`3oool4000001T0oooo1000000I0?ooo`@000006P3oool4
000001T0oooo1@00000I0?ooo`@000006P3oool4000001T0oooo0`00000J0?ooo`@000006`3oool2
000004@0oooo000X0?ooo`8000006P3oool3000001X0oooo1@00000H0?ooo`@00000603oool50000
01T0oooo1000000I0?ooo`D00000603oool5000001T0oooo1000000I0?ooo`@00000603oool50000
01X0oooo0`00000J0?ooo`800000:@3oool002T0oooo0`00000H0?ooo`H000005`3oool6000001L0
oooo1@00000H0?ooo`D00000603oool5000001P0oooo1@00000H0?ooo`D00000603oool5000001P0
oooo1@00000G0?ooo`H000005`3oool6000001P0oooo0`00000Z0?ooo`003@3oool3000001X0oooo
1@00000F0?ooo`L000005P3oool4000001T0oooo0`00000I0?ooo`<000006P3oool3000001`0oooo
00<000000?ooo`3oool06P3oool3000001X0oooo0`00000I0?ooo`<000006@3oool4000001H0oooo
1`00000F0?ooo`D000006P3oool3000000h0oooo000>0?ooo`H000005`3oool6000001D0oooo1@00
000G0?ooo`@000006@3oool010000000oooo0?ooo`00000K0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool06@3oool010000000oooo0?ooo`00000I0?ooo`@000005`3oool5000001D0
oooo1P00000G0?ooo`H000003`3oool000l0oooo2000000D0?ooo`D000005`3oool3000001T0oooo
00@000000?ooo`3oool000006`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo0000
01P0oooo1000000F0?ooo`H00000503oool800000100oooo000@0?ooo`H000005P3oool4000001L0
oooo1@00000K0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`D000005`3oool4000001D0oooo1`00000A0?ooo`004P3oool4000001L0oooo
0P0000000`3oool000000000000F0?ooo`050000003oool0oooo0?ooo`0000006P3oool00`000000
oooo0?ooo`0J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool01@000000
oooo0?ooo`3oool0000001H0oooo1@00000G0?ooo`@000004`3oool001<0oooo1000000G0?ooo`05
0000003oool0oooo0?ooo`0000006P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01P0oooo00D000000?ooo`3oool0oooo0000000G0?ooo`@00000503oool001@0oooo00@000000?oo
o`3oool000006`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo000001D0oooo000H
0?ooo`8000006P3oool2000001T0oooo0P00000I0?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0G0?ooo`8000006@3oool2000001X0oooo0P00000I
0?ooo`006P3oool2000001X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool2000001/0oooo000L0?ooo`80
00006@3oool2000001T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`80
00006@3oool2000001d0oooo000N0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0M0?ooo`007`3oool2000001T0oooo00<000000?ooo`3oool05`3o
ool2000001P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01H0oooo0P00000I0?ooo`030000003oool0oooo01L0oooo0P00000P0?ooo`008@3oool2
000001P0oooo0P00000I0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool2
000001P0oooo0P00000R0?ooo`008`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool08P3oool00;T0oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0K0?ooo`030000003oool0oooo0;P0oooo002K0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01`0oooo
00<000000?ooo`3oool0V@3oool009/0oooo0P00000L0?ooo`800000703oool00`000000oooo0?oo
o`0J0?ooo`8000007@3oool2000009/0oooo001m0?ooo`030000003oool0oooo01/0oooo0P00000L
0?ooo`8000006`3oool3000001/0oooo0P00000L0?ooo`<00000703oool00`000000oooo0?ooo`1l
0?ooo`00H03oool00`000000oooo0?ooo`0J0?ooo`800000703oool3000001/0oooo0P00000K0?oo
o`<000006P3oool3000001/0oooo0`00000L0?ooo`800000703oool00`000000oooo0?ooo`1O0?oo
o`00H03oool2000001`0oooo0P00000K0?ooo`@000006@3oool4000001X0oooo0`00000J0?ooo`@0
00006P3oool3000001/0oooo0P00000L0?ooo`030000003oool0oooo0600oooo00150?ooo`030000
003oool0oooo01T0oooo0`00000J0?ooo`<000006`3oool4000001P0oooo1000000J0?ooo`<00000
6P3oool4000001T0oooo1000000J0?ooo`<000006P3oool3000001/0oooo00<000000?ooo`3oool0
A03oool004D0oooo0`00000I0?ooo`@000006@3oool4000001X0oooo1000000H0?ooo`D00000603o
ool5000001P0oooo1@00000H0?ooo`D000006@3oool3000001X0oooo0`00000J0?ooo`800000A`3o
ool002X0oooo00<000000?ooo`3oool06@3oool3000001T0oooo1000000I0?ooo`@000006@3oool5
000001L0oooo1@00000H0?ooo`D00000603oool5000001L0oooo1@00000I0?ooo`@000006@3oool4
000001T0oooo0`00000K0?ooo`030000003oool0oooo02T0oooo000[0?ooo`8000006@3oool40000
01P0oooo1P00000G0?ooo`D00000603oool4000001P0oooo0`00000J0?ooo`D000006@3oool40000
01P0oooo1000000H0?ooo`D000005`3oool5000001T0oooo0`00000J0?ooo`800000;03oool000l0
oooo0P00000J0?ooo`@00000603oool5000001L0oooo1P00000G0?ooo`<000006@3oool200000003
0?ooo`000000oooo01X0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo01X0oooo0`00000I0?ooo`<000005`3oool6000001L0oooo1@00000H0?ooo`@0
00006P3oool200000100oooo000@0?ooo`<000006@3oool5000001H0oooo1P00000F0?ooo`D00000
603oool00`000000oooo0000000L0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0000000H0?ooo`@000005`3oool5000001L0oooo1@00000I0?ooo`<00000
4@3oool00140oooo1@00000G0?ooo`H000005@3oool4000001P0oooo0`00000L0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01X0oooo0`00000H0?ooo`@000005@3oool6000001L0oooo1@00000B0?ooo`004P3oool6
000001H0oooo1000000F0?ooo`<0000000<0oooo0000003oool06@3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool010000000oooo00000000
000G0?ooo`@000005P3oool6000001<0oooo000C0?ooo`@000005`3oool4000001L0oooo00D00000
0?ooo`3oool0oooo0000000J0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`050000003oool0oooo0?ooo`0000005`3oool4000001L0oooo
1000000D0?ooo`00503oool3000001P0oooo00@000000?ooo`3oool000006`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00@000000?ooo`3oool00000603oool3000001D0
oooo000E0?ooo`040000003oool00000000001X0oooo0P00000J0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool0603oool2000001X0oooo0P0000000`3oool000000?ooo`0E0?ooo`00
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
603oool001X0oooo0P00000J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo0P00000K0?ooo`00703oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06`3oool0
01d0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
01`0oooo000N0?ooo`8000006@3oool2000001T0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`8000006@3oool2000001l0oooo000P0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0O0?ooo`008@3oool2000001T0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool05`3oool200000280oooo000S0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0R0?ooo`00^@3oool00`000000oooo0?ooo`0K0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0^03oool009`0oooo00<000000?ooo`3o
ool06P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01X0oooo0P00000L0?ooo`03
0000003oool0oooo09/0oooo001o0?ooo`030000003oool0oooo01X0oooo0P00000K0?ooo`800000
6`3oool2000001`0oooo0P00000K0?ooo`800000703oool00`000000oooo0?ooo`1n0?ooo`00O`3o
ool2000001/0oooo0P00000K0?ooo`8000006`3oool3000001X0oooo0`00000K0?ooo`8000006`3o
ool200000800oooo001R0?ooo`030000003oool0oooo01X0oooo0P00000K0?ooo`<000006P3oool3
000001X0oooo0`00000J0?ooo`<000006P3oool3000001/0oooo0P00000L0?ooo`030000003oool0
oooo0640oooo00160?ooo`030000003oool0oooo01T0oooo0P00000L0?ooo`8000006P3oool30000
01T0oooo1000000J0?ooo`<000006@3oool5000001T0oooo0`00000J0?ooo`800000703oool20000
01/0oooo00<000000?ooo`3oool0A@3oool004H0oooo0P00000K0?ooo`8000006`3oool3000001T0
oooo1000000H0?ooo`D00000603oool4000001T0oooo1@00000H0?ooo`@000006@3oool3000001/0
oooo0P00000K0?ooo`030000003oool0oooo04H0oooo000[0?ooo`030000003oool0oooo01T0oooo
0`00000I0?ooo`@000006@3oool4000001P0oooo1000000H0?ooo`D00000603oool5000001L0oooo
1P00000H0?ooo`@00000603oool4000001T0oooo1000000I0?ooo`<000006`3oool00`000000oooo
0?ooo`0Z0?ooo`00;03oool2000001T0oooo1000000H0?ooo`D00000603oool4000001P0oooo1@00
000G0?ooo`H000005`3oool5000001L0oooo1P00000G0?ooo`D00000603oool4000001P0oooo1000
000I0?ooo`<000006P3oool2000002d0oooo000A0?ooo`030000003oool0oooo01P0oooo0`00000I
0?ooo`@00000603oool5000001P0oooo1000000G0?ooo`@00000603oool3000001`0oooo00<00000
0?ooo`3oool06P3oool3000001P0oooo1000000G0?ooo`@00000603oool5000001P0oooo1000000I
0?ooo`<000006P3oool00`000000oooo0?ooo`0@0?ooo`004P3oool2000001T0oooo1000000G0?oo
o`H000005P3oool6000001L0oooo0`00000H0?ooo`80000000<0oooo0000003oool06P3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool01000
0000oooo00000000000H0?ooo`<000005`3oool6000001H0oooo1@00000H0?ooo`@000006@3oool2
000001<0oooo000B0?ooo`@000005`3oool6000001H0oooo1P00000F0?ooo`@00000603oool00`00
0000oooo0000000K0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`00
0000oooo0000000H0?ooo`@000005P3oool6000001H0oooo1@00000H0?ooo`@000004`3oool001<0
oooo1@00000F0?ooo`H000005@3oool5000001L0oooo0`00000L0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01X0
oooo0`00000G0?ooo`@000005P3oool6000001H0oooo1@00000D0?ooo`00503oool6000001D0oooo
1000000G0?ooo`80000000<0oooo0000003oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool0603oool010000000oooo00000000000G0?ooo`@0
00005@3oool6000001D0oooo000E0?ooo`@000005P3oool4000001/0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0I0?ooo`@000005P3oool4000001H0oooo000E0?ooo`@000005`3o
ool010000000oooo0?ooo`00000J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
6@3oool010000000oooo0?ooo`00000G0?ooo`@000005P3oool001H0oooo00@000000?ooo`3oool0
00006P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000001L0oooo000J0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`00
6`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
6P3oool001`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01/0oooo000M0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0L0?ooo`007P3oool2000001T0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool20000
01l0oooo000P0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0O0?ooo`008@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0803oool00280oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo0240oooo000S0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0C0?ooo`040000003oool0oooo000001T0oooo00<0
00000?ooo`3oool05`3oool010000000oooo0?ooo`00000E0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0R0?ooo`00W@3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo09`0oooo00200?ooo`030000003oool0oooo01X0oooo00<00000
0?ooo`3oool06P3oool2000001X0oooo0P00000K0?ooo`8000006`3oool2000001`0oooo00<00000
0?ooo`3oool0O`3oool006@0oooo00<000000?ooo`3oool06@3oool2000001/0oooo0P00000K0?oo
o`8000006P3oool3000001X0oooo0P00000K0?ooo`8000006`3oool2000001/0oooo00<000000?oo
o`3oool0H`3oool006@0oooo0P00000J0?ooo`8000006`3oool2000001/0oooo0P00000J0?ooo`<0
00006@3oool3000001X0oooo0`00000K0?ooo`8000006P3oool2000006D0oooo00180?ooo`030000
003oool0oooo01T0oooo0`00000I0?ooo`<000006P3oool3000001T0oooo1000000I0?ooo`<00000
6@3oool4000001T0oooo0`00000J0?ooo`<000006@3oool3000001/0oooo00<000000?ooo`3oool0
A`3oool004P0oooo0P00000K0?ooo`<00000603oool4000001T0oooo0`00000I0?ooo`@00000603o
ool4000001T0oooo1000000H0?ooo`@000006@3oool4000001P0oooo0`00000K0?ooo`800000B@3o
ool002d0oooo00<000000?ooo`3oool06@3oool2000001X0oooo0`00000I0?ooo`@00000603oool4
000001P0oooo1@00000G0?ooo`D000005`3oool5000001P0oooo1000000H0?ooo`@000006@3oool3
000001X0oooo0P00000K0?ooo`030000003oool0oooo02`0oooo000B0?ooo`030000003oool0oooo
01P0oooo0`00000I0?ooo`@00000603oool4000001P0oooo1000000H0?ooo`@00000603oool50000
01L0oooo1@00000G0?ooo`D000005`3oool5000001P0oooo1000000H0?ooo`@00000603oool40000
01T0oooo0P00000K0?ooo`030000003oool0oooo0140oooo000C0?ooo`8000006@3oool3000001P0
oooo1@00000G0?ooo`D000005`3oool5000001L0oooo1@00000G0?ooo`<000006`3oool00`000000
oooo0?ooo`0I0?ooo`<000005`3oool5000001L0oooo1@00000G0?ooo`D000005`3oool4000001T0
oooo0`00000I0?ooo`800000503oool001<0oooo0`00000H0?ooo`@00000603oool5000001L0oooo
1@00000F0?ooo`@00000603oool4000001X0oooo00<000000?ooo`3oool06@3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo01P0oooo1000000H0?ooo`@000005P3oool5000001L0oooo
1@00000H0?ooo`<000006@3oool3000001@0oooo000D0?ooo`@000005`3oool5000001H0oooo1P00
000F0?ooo`@000005`3oool2000000030?ooo`000000oooo01X0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`040000003oool00000000001L0oooo1000000F0?ooo`H00000
5P3oool5000001L0oooo1000000E0?ooo`00503oool6000001D0oooo1P00000F0?ooo`@000005`3o
ool2000000030?ooo`000000oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603oool010000000oooo0000
0000000G0?ooo`@000005P3oool5000001H0oooo1@00000F0?ooo`005@3oool6000001D0oooo1000
000G0?ooo`80000000<0oooo0000003oool06@3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0603oool010000000oooo00000000000G0?ooo`@00000
5@3oool6000001H0oooo000F0?ooo`@000005P3oool4000001X0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`<000005`3oool4000001L0oooo000F0?ooo`@000005`3oool0
10000000oooo0?ooo`00000J0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06@3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool010000000oooo0?ooo`00000G0?ooo`@000005`3oool001L0oooo00@000000?ooo`3oool00000
6P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0H0?ooo`040000003oool0oooo000001P0oooo000J0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0J0?ooo`006`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool06P3o
ool001`0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo01/0oooo000M0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0603oool00`00
0000oooo0?ooo`0L0?ooo`007P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01P0
oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0603oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`0H0?ooo`030000003oool0oooo01h0oooo000P0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool05`3oool00`000000oooo0?ooo`0O0?ooo`008@3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0H
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0803oool00280oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool05`3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0240oooo000S0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0R0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {377, 0}} -> {-1.20041, -1.05001, 0.00835551, \
0.00835551}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(G[x_, y_, 
        z_] := {\(-x\)\/\(\(\ \)\(1 + x\^2\)\), \(-y\)\/\(1 + y\^2\), \
\(-z\)\/\(1 + z\^2\)}\), "\n", 
    \(\(PlotVectorField3D[\ 
        G[x, y, z], {x, \(-1\), 1}, {y, \(-1\), 1}, {z, \(-1\), 1}, 
        VectorHeads -> True, ColorFunction -> Hue];\)\), "\n", 
    \(Clear[G]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 5.12828e-017 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.42216 .58164 m
.43898 .58187 L
s
1 0 .15 r
.49749 .55701 m
.51396 .55743 L
s
.41977 .65269 m
.437 .65235 L
s
.37711 .53559 m
.39476 .53619 L
s
1 0 0 r
.44777 .58395 m
.43341 .59432 L
s
.43762 .56932 m
.44777 .58395 L
s
.43898 .58187 m
.44777 .58395 L
s
1 0 .678 r
.57508 .53164 m
.57955 .53606 L
s
1 0 0 r
.42323 .57968 m
.43762 .56932 L
s
.43762 .56932 m
.43898 .58187 L
s
.43341 .59432 m
.42323 .57968 L
s
.43898 .58187 m
.43341 .59432 L
s
.42323 .57968 m
.43898 .58187 L
s
1 0 .304 r
.49682 .62856 m
.51368 .62842 L
s
.45387 .50957 m
.47116 .51039 L
s
1 0 .15 r
.52273 .5592 m
.50874 .56976 L
s
.5124 .54494 m
.52273 .5592 L
s
.51396 .55743 m
.52273 .5592 L
s
.49838 .55549 m
.5124 .54494 L
s
.5124 .54494 m
.51396 .55743 L
s
.50874 .56976 m
.49838 .55549 L
s
.51396 .55743 m
.50874 .56976 L
s
.899 0 1 r
.65504 .5055 m
.63345 .5185 L
s
1 0 .15 r
.49838 .55549 m
.51396 .55743 L
s
1 0 .678 r
.41727 .72708 m
.43523 .71494 L
s
1 0 .304 r
.3736 .60757 m
.39169 .60759 L
s
1 0 .15 r
.44567 .65446 m
.43144 .66492 L
s
.43545 .63994 m
.44567 .65446 L
s
.437 .65235 m
.44567 .65446 L
s
.42119 .65038 m
.43545 .63994 L
s
.43545 .63994 m
.437 .65235 L
s
.43144 .66492 m
.42119 .65038 L
s
.437 .65235 m
.43144 .66492 L
s
1 0 .848 r
.57623 .60369 m
.58079 .60746 L
s
1 0 .15 r
.42119 .65038 m
.437 .65235 L
s
1 0 .678 r
.32951 .48692 m
.35516 .49529 L
s
1 0 .15 r
.40333 .53856 m
.38868 .54853 L
s
.39357 .52361 m
.40333 .53856 L
s
.39476 .53619 m
.40333 .53856 L
s
.37889 .53357 m
.39357 .52361 L
s
.39357 .52361 m
.39476 .53619 L
s
.38868 .54853 m
.37889 .53357 L
s
.39476 .53619 m
.38868 .54853 L
s
1 0 .678 r
.57828 .54669 m
.56708 .53484 L
s
.59017 .53546 m
.57828 .54669 L
s
.57955 .53606 m
.57828 .54669 L
s
.57898 .52361 m
.59017 .53546 L
s
.57955 .53606 m
.59017 .53546 L
s
1 0 .848 r
.533 .48274 m
.53804 .48781 L
s
1 0 .678 r
.56708 .53484 m
.57898 .52361 L
s
.56708 .53484 m
.57955 .53606 L
s
.57898 .52361 m
.57955 .53606 L
s
1 0 .15 r
.37889 .53357 m
.39476 .53619 L
s
1 0 .678 r
.73747 .47854 m
.68848 .50057 L
s
1 0 .848 r
.49612 .70353 m
.51342 .69148 L
s
1 0 .462 r
.45214 .58204 m
.46985 .58228 L
s
1 0 .304 r
.52232 .63022 m
.50847 .64083 L
s
.51194 .61607 m
.52232 .63022 L
s
.51368 .62842 m
.52232 .63022 L
s
.899 0 1 r
.64145 .52595 m
.62822 .51898 L
s
.62822 .51898 m
.63429 .50571 L
s
.62822 .51898 m
.63345 .5185 L
s
1 0 .304 r
.49806 .62667 m
.51194 .61607 L
s
.51194 .61607 m
.51368 .62842 L
s
.50847 .64083 m
.49806 .62667 L
s
.51368 .62842 m
.50847 .64083 L
s
.899 0 1 r
.64756 .51268 m
.64145 .52595 L
s
.63345 .5185 m
.64145 .52595 L
s
.714 0 1 r
.65813 .57805 m
.63598 .59023 L
s
1 0 .304 r
.49806 .62667 m
.51368 .62842 L
s
.899 0 1 r
.63429 .50571 m
.64756 .51268 L
s
.63429 .50571 m
.63345 .5185 L
s
.41465 .80504 m
.43377 .76704 L
s
.63345 .5185 m
.64756 .51268 L
s
1 0 .304 r
.4797 .51243 m
.46542 .52259 L
s
.46978 .49786 m
.4797 .51243 L
s
.47116 .51039 m
.4797 .51243 L
s
1 0 .848 r
.40774 .45939 m
.4328 .46823 L
s
1 0 .678 r
.43297 .70596 m
.44289 .71925 L
s
.42016 .71561 m
.43297 .70596 L
s
.43297 .70596 m
.43523 .71494 L
s
.44289 .71925 m
.43012 .72893 L
s
.43523 .71494 m
.44289 .71925 L
s
1 0 .304 r
.46542 .52259 m
.45547 .50801 L
s
.47116 .51039 m
.46542 .52259 L
s
.45547 .50801 m
.46978 .49786 L
s
.46978 .49786 m
.47116 .51039 L
s
.714 0 1 r
.61461 .45508 m
.59304 .46923 L
s
1 0 .304 r
.45547 .50801 m
.47116 .51039 L
s
1 0 .678 r
.43012 .72893 m
.42016 .71561 L
s
.42016 .71561 m
.43523 .71494 L
s
.43523 .71494 m
.43012 .72893 L
s
1 0 .848 r
.36991 .68302 m
.38895 .67106 L
s
1 0 .15 r
.82248 .45074 m
.75858 .47772 L
s
1 0 .678 r
.70527 .50556 m
.69186 .50238 L
s
.69186 .50238 m
.69169 .48661 L
s
.69186 .50238 m
.68848 .50057 L
s
.543 0 1 r
.57744 .67923 m
.5819 .67093 L
s
1 0 .304 r
.40012 .60997 m
.38562 .62003 L
s
.3903 .59516 m
.40012 .60997 L
s
.39169 .60759 m
.40012 .60997 L
s
1 0 .678 r
.69169 .48661 m
.70514 .48972 L
s
.69169 .48661 m
.68848 .50057 L
s
1 0 .848 r
.32473 .55982 m
.35106 .56746 L
s
1 0 .678 r
.36044 .49732 m
.34597 .50475 L
s
.35381 .4824 m
.36044 .49732 L
s
.35516 .49529 m
.36044 .49732 L
s
1 0 .304 r
.37576 .6052 m
.3903 .59516 L
s
.3903 .59516 m
.39169 .60759 L
s
.38562 .62003 m
.37576 .6052 L
s
.39169 .60759 m
.38562 .62003 L
s
1 0 .848 r
.57953 .61813 m
.56842 .60639 L
s
.59129 .60698 m
.57953 .61813 L
s
.58079 .60746 m
.57953 .61813 L
s
.58018 .59525 m
.59129 .60698 L
s
.58079 .60746 m
.59129 .60698 L
s
.56842 .60639 m
.58018 .59525 L
s
.56842 .60639 m
.58079 .60746 L
s
.58018 .59525 m
.58079 .60746 L
s
1 0 .678 r
.70514 .48972 m
.70527 .50556 L
s
.68848 .50057 m
.70527 .50556 L
s
.34597 .50475 m
.3393 .48981 L
s
.35516 .49529 m
.34597 .50475 L
s
.3393 .48981 m
.35381 .4824 L
s
.35381 .4824 m
.35516 .49529 L
s
1 0 .304 r
.37576 .6052 m
.39169 .60759 L
s
.977 0 1 r
.53317 .55571 m
.53832 .56011 L
s
1 0 .678 r
.3393 .48981 m
.35516 .49529 L
s
.68848 .50057 m
.70514 .48972 L
s
.899 0 1 r
.27912 .43541 m
.32195 .46099 L
s
1 0 .848 r
.74261 .55159 m
.69235 .57264 L
s
.53638 .49824 m
.52553 .48619 L
s
.54847 .48734 m
.53638 .49824 L
s
.53804 .48781 m
.53638 .49824 L
s
.53763 .47528 m
.54847 .48734 L
s
.53804 .48781 m
.54847 .48734 L
s
.714 0 1 r
.49538 .78215 m
.51321 .744 L
s
1 0 .848 r
.52553 .48619 m
.53763 .47528 L
s
.52553 .48619 m
.53804 .48781 L
s
.53763 .47528 m
.53804 .48781 L
s
.543 0 1 r
.48846 .43098 m
.50081 .44453 L
s
1 0 .848 r
.51103 .68265 m
.52106 .69552 L
s
.49866 .69238 m
.51103 .68265 L
s
.51103 .68265 m
.51342 .69148 L
s
.52106 .69552 m
.5087 .70528 L
s
.51342 .69148 m
.52106 .69552 L
s
.899 0 1 r
.43014 .7654 m
.4405 .77643 L
s
.4192 .77316 m
.43014 .7654 L
s
.43014 .7654 m
.43377 .76704 L
s
1 0 .848 r
.5087 .70528 m
.49866 .69238 L
s
.49866 .69238 m
.51342 .69148 L
s
.69882 .42653 m
.64922 .45026 L
s
.51342 .69148 m
.5087 .70528 L
s
1 0 .15 r
.77945 .4821 m
.76627 .48006 L
s
.76627 .48006 m
.76376 .4624 L
s
.76627 .48006 m
.75858 .47772 L
s
.899 0 1 r
.4405 .77643 m
.42959 .78425 L
s
.43377 .76704 m
.4405 .77643 L
s
.977 0 1 r
.45032 .65807 m
.46869 .64622 L
s
.714 0 1 r
.64392 .59776 m
.63101 .59071 L
s
.63101 .59071 m
.63712 .57771 L
s
.63101 .59071 m
.63598 .59023 L
s
.899 0 1 r
.42959 .78425 m
.4192 .77316 L
s
.4192 .77316 m
.43377 .76704 L
s
1 0 0 r
.91022 .42206 m
.8433 .45012 L
s
1 0 .15 r
.76376 .4624 m
.77696 .46433 L
s
.76376 .4624 m
.75858 .47772 L
s
.714 0 1 r
.65007 .58476 m
.64392 .59776 L
s
.63598 .59023 m
.64392 .59776 L
s
.63712 .57771 m
.65007 .58476 L
s
.63712 .57771 m
.63598 .59023 L
s
.04 0 1 r
.66137 .65416 m
.63824 .65403 L
s
.899 0 1 r
.43377 .76704 m
.42959 .78425 L
s
1 0 .678 r
.4119 .88684 m
.43225 .82085 L
s
.714 0 1 r
.63598 .59023 m
.65007 .58476 L
s
1 0 .462 r
.47825 .58434 m
.46413 .59455 L
s
.46827 .56991 m
.47825 .58434 L
s
.46985 .58228 m
.47825 .58434 L
s
1 0 .848 r
.43806 .46993 m
.42394 .47746 L
s
.43138 .45538 m
.43806 .46993 L
s
.4328 .46823 m
.43806 .46993 L
s
.977 0 1 r
.40482 .53277 m
.43053 .54088 L
s
.714 0 1 r
.60115 .47629 m
.58798 .46954 L
s
.58798 .46954 m
.59377 .45636 L
s
.58798 .46954 m
.59304 .46923 L
s
1 0 .462 r
.45413 .58012 m
.46827 .56991 L
s
.46827 .56991 m
.46985 .58228 L
s
1 0 .15 r
.77696 .46433 m
.77945 .4821 L
s
.75858 .47772 m
.77945 .4821 L
s
1 0 .462 r
.46413 .59455 m
.45413 .58012 L
s
.46985 .58228 m
.46413 .59455 L
s
.714 0 1 r
.60697 .46312 m
.60115 .47629 L
s
.59304 .46923 m
.60115 .47629 L
s
1 0 .848 r
.42394 .47746 m
.41721 .46289 L
s
.4328 .46823 m
.42394 .47746 L
s
1 0 .462 r
.45413 .58012 m
.46985 .58228 L
s
1 0 .848 r
.41721 .46289 m
.43138 .45538 L
s
.43138 .45538 m
.4328 .46823 L
s
.714 0 1 r
.59377 .45636 m
.60697 .46312 L
s
.59377 .45636 m
.59304 .46923 L
s
.522 0 1 r
.61679 .52853 m
.59467 .54186 L
s
1 0 .15 r
.75858 .47772 m
.77696 .46433 L
s
.714 0 1 r
.59304 .46923 m
.60697 .46312 L
s
.36604 .76221 m
.38667 .72395 L
s
1 0 .848 r
.41721 .46289 m
.4328 .46823 L
s
.899 0 1 r
.31924 .46198 m
.30614 .46426 L
s
.32029 .4473 m
.31924 .46198 L
s
.32195 .46099 m
.31924 .46198 L
s
1 0 .848 r
.39628 .67562 m
.38335 .6849 L
s
.38673 .66215 m
.39628 .67562 L
s
.38895 .67106 m
.39628 .67562 L
s
.37377 .6714 m
.38673 .66215 L
s
.38673 .66215 m
.38895 .67106 L
s
.714 0 1 r
.35886 .40623 m
.40061 .43285 L
s
1 0 .304 r
.82982 .52427 m
.7642 .55021 L
s
1 0 .848 r
.70906 .57794 m
.69603 .57434 L
s
.69603 .57434 m
.69616 .55876 L
s
.69603 .57434 m
.69235 .57264 L
s
.543 0 1 r
.58115 .66239 m
.59128 .67289 L
s
.57069 .67238 m
.58115 .66239 L
s
.58115 .66239 m
.5819 .67093 L
s
.04 0 1 r
.57871 .75852 m
.58282 .72382 L
s
.543 0 1 r
.59128 .67289 m
.58081 .68289 L
s
.5819 .67093 m
.59128 .67289 L
s
.58081 .68289 m
.57069 .67238 L
s
.57069 .67238 m
.5819 .67093 L
s
.899 0 1 r
.30715 .44952 m
.32029 .4473 L
s
.32029 .4473 m
.32195 .46099 L
s
1 0 .848 r
.38335 .6849 m
.37377 .6714 L
s
.38895 .67106 m
.38335 .6849 L
s
.543 0 1 r
.5819 .67093 m
.58081 .68289 L
s
1 0 .848 r
.37377 .6714 m
.38895 .67106 L
s
.04 0 1 r
.57178 .40165 m
.55678 .42503 L
s
1 0 .848 r
.69616 .55876 m
.70923 .5623 L
s
.69616 .55876 m
.69235 .57264 L
s
.714 0 1 r
.50962 .74267 m
.52 .7532 L
s
.49913 .75038 m
.50962 .74267 L
s
.50962 .74267 m
.51321 .744 L
s
1 0 .848 r
.35613 .56945 m
.34192 .57702 L
s
.3494 .55476 m
.35613 .56945 L
s
.35106 .56746 m
.35613 .56945 L
s
.899 0 1 r
.30614 .46426 m
.30715 .44952 L
s
.32195 .46099 m
.30614 .46426 L
s
1 0 .678 r
.42722 .82679 m
.43989 .83597 L
s
.41633 .83249 m
.42722 .82679 L
s
.42722 .82679 m
.43225 .82085 L
s
.543 0 1 r
.31972 .63633 m
.34741 .63167 L
s
1 0 0 r
.86524 .45451 m
.8515 .45279 L
s
.8515 .45279 m
.84865 .43434 L
s
.8515 .45279 m
.8433 .45012 L
s
.714 0 1 r
.52 .7532 m
.50953 .76096 L
s
.51321 .744 m
.52 .7532 L
s
1 0 .848 r
.70923 .5623 m
.70906 .57794 L
s
.69235 .57264 m
.70906 .57794 L
s
.66643 .45457 m
.65324 .45202 L
s
.65324 .45202 m
.65226 .43629 L
s
.65324 .45202 m
.64922 .45026 L
s
1 0 .304 r
.78576 .39706 m
.72084 .42607 L
s
1 0 .848 r
.33514 .56231 m
.3494 .55476 L
s
.3494 .55476 m
.35106 .56746 L
s
.34192 .57702 m
.33514 .56231 L
s
.35106 .56746 m
.34192 .57702 L
s
.343 0 1 r
.53334 .63232 m
.53857 .62446 L
s
.899 0 1 r
.30715 .44952 m
.32195 .46099 L
s
.714 0 1 r
.50953 .76096 m
.49913 .75038 L
s
.49913 .75038 m
.51321 .744 L
s
1 0 .678 r
.43989 .83597 m
.42903 .84175 L
s
.43225 .82085 m
.43989 .83597 L
s
1 0 0 r
.84865 .43434 m
.86241 .43594 L
s
.84865 .43434 m
.8433 .45012 L
s
1 0 .848 r
.33514 .56231 m
.35106 .56746 L
s
.69235 .57264 m
.70923 .5623 L
s
.65226 .43629 m
.66548 .43877 L
s
.65226 .43629 m
.64922 .45026 L
s
.714 0 1 r
.51321 .744 m
.50953 .76096 L
s
.27294 .5092 m
.31695 .53376 L
s
.543 0 1 r
.74802 .62828 m
.6958 .63676 L
s
.977 0 1 r
.5486 .55975 m
.53667 .57056 L
s
.53785 .54785 m
.5486 .55975 L
s
.53832 .56011 m
.5486 .55975 L
s
.53667 .57056 m
.52591 .55866 L
s
.53832 .56011 m
.53667 .57056 L
s
1 0 .678 r
.42903 .84175 m
.41633 .83249 L
s
.41633 .83249 m
.43225 .82085 L
s
1 0 .848 r
.66548 .43877 m
.66643 .45457 L
s
.64922 .45026 m
.66643 .45457 L
s
.977 0 1 r
.52591 .55866 m
.53785 .54785 L
s
.53785 .54785 m
.53832 .56011 L
s
.52591 .55866 m
.53832 .56011 L
s
.543 0 1 r
.50828 .44366 m
.49605 .45181 L
s
.50052 .43168 m
.50828 .44366 L
s
.50081 .44453 m
.50828 .44366 L
s
.49605 .45181 m
.48826 .43985 L
s
.50081 .44453 m
.49605 .45181 L
s
1 0 .848 r
.4946 .86471 m
.513 .79828 L
s
.343 0 1 r
.48751 .50484 m
.50018 .51759 L
s
1 0 0 r
.86241 .43594 m
.86524 .45451 L
s
.8433 .45012 m
.86524 .45451 L
s
.543 0 1 r
.48826 .43985 m
.50052 .43168 L
s
.50052 .43168 m
.50081 .44453 L
s
.48826 .43985 m
.50081 .44453 L
s
.04 0 1 r
.6453 .663 m
.63463 .65655 L
s
.63463 .65655 m
.64062 .64512 L
s
.63463 .65655 m
.63824 .65403 L
s
1 0 .678 r
.43225 .82085 m
.42903 .84175 L
s
1 0 .848 r
.64922 .45026 m
.66548 .43877 L
s
.04 0 1 r
.64062 .64512 m
.65132 .65155 L
s
.64062 .64512 m
.63824 .65403 L
s
1 0 .304 r
.78505 .55506 m
.77222 .55242 L
s
.77222 .55242 m
.77009 .53484 L
s
.77222 .55242 m
.7642 .55021 L
s
1 0 0 r
.8433 .45012 m
.86241 .43594 L
s
1 0 .678 r
.22569 .38079 m
.2874 .42531 L
s
.977 0 1 r
.70315 .50047 m
.65224 .52322 L
s
.04 0 1 r
.65132 .65155 m
.6453 .663 L
s
.63824 .65403 m
.6453 .663 L
s
.63824 .65403 m
.65132 .65155 L
s
.522 0 1 r
.44841 .73792 m
.46772 .69954 L
s
.714 0 1 r
.39773 .43359 m
.38499 .43555 L
s
.39921 .41931 m
.39773 .43359 L
s
.40061 .43285 m
.39773 .43359 L
s
.977 0 1 r
.47597 .65051 m
.46348 .65986 L
s
.46635 .63747 m
.47597 .65051 L
s
.46869 .64622 m
.47597 .65051 L
s
.45383 .6468 m
.46635 .63747 L
s
.46635 .63747 m
.46869 .64622 L
s
1 0 .304 r
.77009 .53484 m
.78294 .53737 L
s
.77009 .53484 m
.7642 .55021 L
s
.714 0 1 r
.38287 .72257 m
.39294 .73365 L
s
.37196 .72986 m
.38287 .72257 L
s
.38287 .72257 m
.38667 .72395 L
s
.04 0 1 r
.44122 .37609 m
.46955 .40819 L
s
1 0 .15 r
.91988 .49607 m
.8511 .52308 L
s
.04 0 1 r
.58185 .72302 m
.5913 .73111 L
s
.57266 .73067 m
.58185 .72302 L
s
.58185 .72302 m
.58282 .72382 L
s
0 .536 1 r
.66477 .73412 m
.64011 .70721 L
s
.977 0 1 r
.46348 .65986 m
.45383 .6468 L
s
.46869 .64622 m
.46348 .65986 L
s
.45383 .6468 m
.46869 .64622 L
s
.714 0 1 r
.39294 .73365 m
.38205 .74099 L
s
.38667 .72395 m
.39294 .73365 L
s
.38644 .42122 m
.39921 .41931 L
s
.39921 .41931 m
.40061 .43285 L
s
1 0 .304 r
.74216 .42969 m
.72937 .42835 L
s
.72937 .42835 m
.72597 .41069 L
s
.72937 .42835 m
.72084 .42607 L
s
1 0 .15 r
.40901 .97277 m
.43029 .89033 L
s
.543 0 1 r
.65784 .37137 m
.61398 .4051 L
s
.977 0 1 r
.43555 .54255 m
.42172 .55018 L
s
.42879 .52825 m
.43555 .54255 L
s
.43053 .54088 m
.43555 .54255 L
s
.714 0 1 r
.38499 .43555 m
.38644 .42122 L
s
.40061 .43285 m
.38499 .43555 L
s
.522 0 1 r
.60269 .54897 m
.58988 .54215 L
s
.58988 .54215 m
.5957 .52929 L
s
.58988 .54215 m
.59467 .54186 L
s
1 0 .848 r
.50816 .80469 m
.52087 .81325 L
s
.49764 .81025 m
.50816 .80469 L
s
.50816 .80469 m
.513 .79828 L
s
.04 0 1 r
.5913 .73111 m
.58212 .7388 L
s
.58282 .72382 m
.5913 .73111 L
s
1 0 .304 r
.78294 .53737 m
.78505 .55506 L
s
.7642 .55021 m
.78505 .55506 L
s
.04 0 1 r
.58212 .7388 m
.57266 .73067 L
s
.57266 .73067 m
.58282 .72382 L
s
.343 0 1 r
.40175 .60986 m
.4285 .60557 L
s
1 0 .678 r
.27548 .42431 m
.26622 .42326 L
s
.28359 .40939 m
.27548 .42431 L
s
.2874 .42531 m
.27548 .42431 L
s
.714 0 1 r
.38205 .74099 m
.37196 .72986 L
s
.37196 .72986 m
.38667 .72395 L
s
1 0 .304 r
.72597 .41069 m
.73877 .41192 L
s
.72597 .41069 m
.72084 .42607 L
s
.522 0 1 r
.60855 .5361 m
.60269 .54897 L
s
.59467 .54186 m
.60269 .54897 L
s
.04 0 1 r
.56362 .42851 m
.55157 .42315 L
s
.55157 .42315 m
.55605 .41198 L
s
.55157 .42315 m
.55678 .42503 L
s
.977 0 1 r
.42172 .55018 m
.41491 .53587 L
s
.43053 .54088 m
.42172 .55018 L
s
.41491 .53587 m
.42879 .52825 L
s
.42879 .52825 m
.43053 .54088 L
s
.04 0 1 r
.56814 .41736 m
.56362 .42851 L
s
.55678 .42503 m
.56362 .42851 L
s
1 0 .15 r
.87555 .36662 m
.80747 .39682 L
s
.522 0 1 r
.5957 .52929 m
.60855 .5361 L
s
.5957 .52929 m
.59467 .54186 L
s
.714 0 1 r
.38644 .42122 m
.40061 .43285 L
s
.38667 .72395 m
.38205 .74099 L
s
.543 0 1 r
.71086 .64416 m
.70048 .64022 L
s
.70048 .64022 m
.70198 .62594 L
s
.70048 .64022 m
.6958 .63676 L
s
1 0 .678 r
.27437 .40824 m
.28359 .40939 L
s
.28359 .40939 m
.2874 .42531 L
s
1 0 .304 r
.7642 .55021 m
.78294 .53737 L
s
.04 0 1 r
.58282 .72382 m
.58212 .7388 L
s
0 .186 1 r
.61909 .60571 m
.59611 .60654 L
s
.522 0 1 r
.59467 .54186 m
.60855 .5361 L
s
1 0 .848 r
.52087 .81325 m
.51038 .81888 L
s
.513 .79828 m
.52087 .81325 L
s
.977 0 1 r
.41491 .53587 m
.43053 .54088 L
s
.543 0 1 r
.70198 .62594 m
.71239 .62981 L
s
.70198 .62594 m
.6958 .63676 L
s
.714 0 1 r
.31395 .53463 m
.30125 .53733 L
s
.31471 .52021 m
.31395 .53463 L
s
.31695 .53376 m
.31395 .53463 L
s
.04 0 1 r
.55605 .41198 m
.56814 .41736 L
s
.55605 .41198 m
.55678 .42503 L
s
1 0 .848 r
.36197 .84541 m
.38432 .77862 L
s
.04 0 1 r
.55678 .42503 m
.56814 .41736 L
s
1 0 .15 r
.42442 .90025 m
.4392 .90885 L
s
.41274 .90514 m
.42442 .90025 L
s
.42442 .90025 m
.43029 .89033 L
s
1 0 .304 r
.73877 .41192 m
.74216 .42969 L
s
.72084 .42607 m
.74216 .42969 L
s
.543 0 1 r
.35119 .63571 m
.3391 .64273 L
s
.34439 .62254 m
.35119 .63571 L
s
.34741 .63167 m
.35119 .63571 L
s
1 0 .848 r
.51038 .81888 m
.49764 .81025 L
s
.49764 .81025 m
.513 .79828 L
s
.522 0 1 r
.35461 .48049 m
.39749 .5061 L
s
1 0 .848 r
.83753 .60154 m
.7692 .61473 L
s
.543 0 1 r
.33227 .62953 m
.34439 .62254 L
s
.34439 .62254 m
.34741 .63167 L
s
.714 0 1 r
.30199 .52285 m
.31471 .52021 L
s
.31471 .52021 m
.31695 .53376 L
s
.543 0 1 r
.58004 .84184 m
.58377 .7785 L
s
.71239 .62981 m
.71086 .64416 L
s
.6958 .63676 m
.71086 .64416 L
s
1 0 .304 r
.72084 .42607 m
.73877 .41192 L
s
1 0 .678 r
.26622 .42326 m
.27437 .40824 L
s
.2874 .42531 m
.26622 .42326 L
s
.27437 .40824 m
.2874 .42531 L
s
1 0 .848 r
.513 .79828 m
.51038 .81888 L
s
.543 0 1 r
.3391 .64273 m
.33227 .62953 L
s
.34741 .63167 m
.3391 .64273 L
s
0 .186 1 r
.57294 .47599 m
.55754 .49841 L
s
.714 0 1 r
.30125 .53733 m
.30199 .52285 L
s
.31695 .53376 m
.30125 .53733 L
s
1 0 .15 r
.4392 .90885 m
.42757 .91382 L
s
.43029 .89033 m
.4392 .90885 L
s
.543 0 1 r
.6958 .63676 m
.71239 .62981 L
s
.33227 .62953 m
.34741 .63167 L
s
1 0 .15 r
.87305 .52799 m
.85963 .52562 L
s
.85963 .52562 m
.85717 .50722 L
s
.85963 .52562 m
.8511 .52308 L
s
.04 0 1 r
.31445 .71675 m
.34437 .68524 L
s
.977 0 1 r
.66936 .52785 m
.65658 .52485 L
s
.65658 .52485 m
.6559 .50934 L
s
.65658 .52485 m
.65224 .52322 L
s
0 .536 1 r
.64486 .70587 m
.65241 .71056 L
s
.63783 .71477 m
.64486 .70587 L
s
.64486 .70587 m
.64011 .70721 L
s
.04 0 1 r
.46847 .4071 m
.45667 .40789 L
s
.47092 .39543 m
.46847 .4071 L
s
.46955 .40819 m
.46847 .4071 L
s
.343 0 1 r
.53788 .61599 m
.54761 .62653 L
s
.52738 .6256 m
.53788 .61599 L
s
.53788 .61599 m
.53857 .62446 L
s
1 0 .848 r
.30699 .34981 m
.36711 .39603 L
s
1 0 .462 r
.79238 .47147 m
.72569 .49944 L
s
0 .536 1 r
.64537 .7195 m
.63783 .71477 L
s
.63783 .71477 m
.64011 .70721 L
s
.343 0 1 r
.54761 .62653 m
.53712 .63615 L
s
.53857 .62446 m
.54761 .62653 L
s
.714 0 1 r
.30199 .52285 m
.31695 .53376 L
s
.543 0 1 r
.63078 .405 m
.61951 .40493 L
s
.61951 .40493 m
.61501 .3915 L
s
.61951 .40493 m
.61398 .4051 L
s
.343 0 1 r
.53712 .63615 m
.52738 .6256 L
s
.52738 .6256 m
.53857 .62446 L
s
1 0 .15 r
.42757 .91382 m
.41274 .90514 L
s
.41274 .90514 m
.43029 .89033 L
s
.343 0 1 r
.53857 .62446 m
.53712 .63615 L
s
1 0 .15 r
.85717 .50722 m
.87061 .50947 L
s
.85717 .50722 m
.8511 .52308 L
s
0 .186 1 r
.53352 .71284 m
.53878 .67814 L
s
.977 0 1 r
.6559 .50934 m
.66871 .51227 L
s
.6559 .50934 m
.65224 .52322 L
s
.522 0 1 r
.46395 .69849 m
.47401 .70903 L
s
.45352 .70572 m
.46395 .69849 L
s
.46395 .69849 m
.46772 .69954 L
s
1 0 .15 r
.43029 .89033 m
.42757 .91382 L
s
.04 0 1 r
.45667 .40789 m
.45909 .3962 L
s
.46955 .40819 m
.45667 .40789 L
s
.45909 .3962 m
.47092 .39543 L
s
.47092 .39543 m
.46955 .40819 L
s
0 .536 1 r
.52632 .34495 m
.52632 .38789 L
s
.65241 .71056 m
.64537 .7195 L
s
.64011 .70721 m
.65241 .71056 L
s
1 0 .848 r
.37888 .78503 m
.39145 .79418 L
s
.36809 .79013 m
.37888 .78503 L
s
.37888 .78503 m
.38432 .77862 L
s
.543 0 1 r
.61501 .3915 m
.62629 .39151 L
s
.61501 .3915 m
.61398 .4051 L
s
0 .536 1 r
.64011 .70721 m
.64537 .7195 L
s
1 0 .15 r
.82989 .40042 m
.81655 .39944 L
s
.81655 .39944 m
.81279 .38097 L
s
.81655 .39944 m
.80747 .39682 L
s
.543 0 1 r
.58257 .78568 m
.5937 .79156 L
s
.57234 .79107 m
.58257 .78568 L
s
.58257 .78568 m
.58377 .7785 L
s
.522 0 1 r
.47401 .70903 m
.4636 .71631 L
s
.46772 .69954 m
.47401 .70903 L
s
.343 0 1 r
.50738 .51676 m
.49547 .52484 L
s
.49971 .5051 m
.50738 .51676 L
s
.50018 .51759 m
.50738 .51676 L
s
.977 0 1 r
.66871 .51227 m
.66936 .52785 L
s
.65224 .52322 m
.66936 .52785 L
s
.04 0 1 r
.26645 .58677 m
.3125 .59858 L
s
.7537 .7089 m
.69867 .69023 L
s
.343 0 1 r
.49547 .52484 m
.48777 .51319 L
s
.50018 .51759 m
.49547 .52484 L
s
1 0 .848 r
.78831 .62205 m
.77811 .61871 L
s
.77811 .61871 m
.77784 .60211 L
s
.77811 .61871 m
.7692 .61473 L
s
1 0 .304 r
.49379 .9515 m
.51271 .86841 L
s
1 0 .848 r
.74676 .34007 m
.68693 .37967 L
s
.543 0 1 r
.62629 .39151 m
.63078 .405 L
s
.61398 .4051 m
.63078 .405 L
s
.04 0 1 r
.45909 .3962 m
.46955 .40819 L
s
1 0 .15 r
.87061 .50947 m
.87305 .52799 L
s
.8511 .52308 m
.87305 .52799 L
s
.343 0 1 r
.48777 .51319 m
.49971 .5051 L
s
.49971 .5051 m
.50018 .51759 L
s
.48777 .51319 m
.50018 .51759 L
s
.522 0 1 r
.4636 .71631 m
.45352 .70572 L
s
.45352 .70572 m
.46772 .69954 L
s
1 0 .848 r
.39145 .79418 m
.38071 .79936 L
s
.38432 .77862 m
.39145 .79418 L
s
1 0 .15 r
.81279 .38097 m
.82614 .38182 L
s
.81279 .38097 m
.80747 .39682 L
s
1 0 .848 r
.35473 .39467 m
.34634 .39308 L
s
.36353 .38033 m
.35473 .39467 L
s
.36711 .39603 m
.35473 .39467 L
s
.977 0 1 r
.65224 .52322 m
.66871 .51227 L
s
0 .4 1 r
.48651 .5825 m
.49962 .58268 L
s
1 0 .848 r
.77784 .60211 m
.78806 .60535 L
s
.77784 .60211 m
.7692 .61473 L
s
.522 0 1 r
.46772 .69954 m
.4636 .71631 L
s
1 0 .15 r
.8511 .52308 m
.87061 .50947 L
s
.543 0 1 r
.5937 .79156 m
.58347 .797 L
s
.58377 .7785 m
.5937 .79156 L
s
.61398 .4051 m
.62629 .39151 L
s
1 0 .848 r
.35519 .37864 m
.36353 .38033 L
s
.36353 .38033 m
.36711 .39603 L
s
.543 0 1 r
.58347 .797 m
.57234 .79107 L
s
.57234 .79107 m
.58377 .7785 L
s
1 0 .848 r
.38071 .79936 m
.36809 .79013 L
s
.36809 .79013 m
.38432 .77862 L
s
.21795 .45546 m
.28145 .49869 L
s
.343 0 1 r
.70771 .57821 m
.65493 .58822 L
s
.522 0 1 r
.3943 .5067 m
.382 .50907 L
s
.3955 .49271 m
.3943 .5067 L
s
.39749 .5061 m
.3943 .5067 L
s
1 0 .304 r
.50712 .87889 m
.522 .88681 L
s
.49575 .88359 m
.50712 .87889 L
s
.50712 .87889 m
.51271 .86841 L
s
.977 0 1 r
.4464 .8219 m
.46671 .75469 L
s
1 0 .15 r
.82614 .38182 m
.82989 .40042 L
s
.80747 .39682 m
.82989 .40042 L
s
.04 0 1 r
.71024 .70202 m
.70439 .69853 L
s
.70439 .69853 m
.70933 .68603 L
s
.70439 .69853 m
.69867 .69023 L
s
1 0 .848 r
.38432 .77862 m
.38071 .79936 L
s
.343 0 1 r
.43222 .60931 m
.42059 .61631 L
s
.42546 .59661 m
.43222 .60931 L
s
.4285 .60557 m
.43222 .60931 L
s
.543 0 1 r
.58377 .7785 m
.58347 .797 L
s
.04 0 1 r
.70933 .68603 m
.7152 .68945 L
s
.70933 .68603 m
.69867 .69023 L
s
0 .186 1 r
.60317 .61504 m
.59276 .60887 L
s
.59276 .60887 m
.59843 .5977 L
s
.59276 .60887 m
.59611 .60654 L
s
1 0 .848 r
.78806 .60535 m
.78831 .62205 L
s
.7692 .61473 m
.78831 .62205 L
s
0 .186 1 r
.43902 .45083 m
.46812 .48184 L
s
1 0 .678 r
.93005 .5739 m
.85804 .58808 L
s
.343 0 1 r
.4138 .60358 m
.42546 .59661 L
s
.42546 .59661 m
.4285 .60557 L
s
0 .536 1 r
.53022 .38397 m
.51911 .38179 L
s
.53355 .3766 m
.53022 .38397 L
s
.52632 .38789 m
.53022 .38397 L
s
0 .186 1 r
.59843 .5977 m
.60886 .60386 L
s
.59843 .5977 m
.59611 .60654 L
s
.522 0 1 r
.38318 .49503 m
.3955 .49271 L
s
.3955 .49271 m
.39749 .5061 L
s
.04 0 1 r
.33876 .68366 m
.34685 .69433 L
s
.3297 .68894 m
.33876 .68366 L
s
.33876 .68366 m
.34437 .68524 L
s
1 0 .462 r
.74699 .50354 m
.73457 .50157 L
s
.73457 .50157 m
.73155 .484 L
s
.73457 .50157 m
.72569 .49944 L
s
1 0 .15 r
.80747 .39682 m
.82614 .38182 L
s
1 0 .848 r
.7692 .61473 m
.78806 .60535 L
s
.04 0 1 r
.66835 .81821 m
.64205 .76221 L
s
0 .186 1 r
.60886 .60386 m
.60317 .61504 L
s
.59611 .60654 m
.60317 .61504 L
s
1 0 .848 r
.34634 .39308 m
.35519 .37864 L
s
.36711 .39603 m
.34634 .39308 L
s
.35519 .37864 m
.36711 .39603 L
s
0 .536 1 r
.51911 .38179 m
.52239 .37439 L
s
.51911 .38179 m
.52632 .38789 L
s
.04 0 1 r
.34685 .69433 m
.33782 .69966 L
s
.34437 .68524 m
.34685 .69433 L
s
.343 0 1 r
.42059 .61631 m
.4138 .60358 L
s
.4285 .60557 m
.42059 .61631 L
s
.522 0 1 r
.382 .50907 m
.38318 .49503 L
s
.39749 .5061 m
.382 .50907 L
s
0 .186 1 r
.59611 .60654 m
.60886 .60386 L
s
1 0 0 r
.40598 1.06315 m
.42788 .97574 L
s
1 0 .15 r
.16894 .32278 m
.24244 .37887 L
s
.343 0 1 r
.66124 .44617 m
.61619 .4788 L
s
1 0 .848 r
.70766 .37892 m
.69734 .37975 L
s
.69734 .37975 m
.69049 .3644 L
s
.69734 .37975 m
.68693 .37967 L
s
.343 0 1 r
.4138 .60358 m
.4285 .60557 L
s
1 0 .304 r
.522 .88681 m
.51067 .89158 L
s
.51271 .86841 m
.522 .88681 L
s
1 0 .848 r
.2692 .49757 m
.26031 .49729 L
s
.27688 .48265 m
.2692 .49757 L
s
.28145 .49869 m
.2692 .49757 L
s
1 0 .462 r
.73155 .484 m
.74398 .48586 L
s
.73155 .484 m
.72569 .49944 L
s
0 .186 1 r
.56426 .50186 m
.55267 .49652 L
s
.55267 .49652 m
.5571 .4858 L
s
.55267 .49652 m
.55754 .49841 L
s
.39852 .69095 m
.42681 .65956 L
s
.04 0 1 r
.30839 .60112 m
.29851 .60425 L
s
.30779 .58813 m
.30839 .60112 L
s
.3125 .59858 m
.30839 .60112 L
s
0 .536 1 r
.52239 .37439 m
.53355 .3766 L
s
.52632 .38789 m
.53355 .3766 L
s
1 0 .15 r
.22565 .37656 m
.21851 .37468 L
s
.23671 .36052 m
.22565 .37656 L
s
.24244 .37887 m
.22565 .37656 L
s
0 .186 1 r
.56872 .49114 m
.56426 .50186 L
s
.55754 .49841 m
.56426 .50186 L
s
.04 0 1 r
.69867 .69023 m
.71024 .70202 L
s
.69867 .69023 m
.7152 .68945 L
s
.7152 .68945 m
.71024 .70202 L
s
.522 0 1 r
.38318 .49503 m
.39749 .5061 L
s
.04 0 1 r
.64926 .76872 m
.65603 .77109 L
s
.6387 .77589 m
.64926 .76872 L
s
.64926 .76872 m
.64205 .76221 L
s
1 0 .848 r
.69049 .3644 m
.7008 .36347 L
s
.69049 .3644 m
.68693 .37967 L
s
.26803 .48227 m
.27688 .48265 L
s
.27688 .48265 m
.28145 .49869 L
s
.04 0 1 r
.33782 .69966 m
.3297 .68894 L
s
.3297 .68894 m
.34437 .68524 L
s
.543 0 1 r
.39104 .31778 m
.437 .37035 L
s
1 0 .304 r
.88462 .4415 m
.81459 .47065 L
s
.51067 .89158 m
.49575 .88359 L
s
.49575 .88359 m
.51271 .86841 L
s
0 .186 1 r
.53768 .67765 m
.54676 .68561 L
s
.52865 .6848 m
.53768 .67765 L
s
.53768 .67765 m
.53878 .67814 L
s
1 0 .15 r
.22966 .3585 m
.23671 .36052 L
s
.23671 .36052 m
.24244 .37887 L
s
0 .536 1 r
.52239 .37439 m
.52632 .38789 L
s
.04 0 1 r
.29789 .59121 m
.30779 .58813 L
s
.30779 .58813 m
.3125 .59858 L
s
.34437 .68524 m
.33782 .69966 L
s
0 .802 1 r
.6215 .6869 m
.59732 .66051 L
s
0 .186 1 r
.5571 .4858 m
.56872 .49114 L
s
.5571 .4858 m
.55754 .49841 L
s
1 0 .304 r
.51271 .86841 m
.51067 .89158 L
s
.04 0 1 r
.64543 .7783 m
.6387 .77589 L
s
.6387 .77589 m
.64205 .76221 L
s
0 .186 1 r
.55754 .49841 m
.56872 .49114 L
s
1 0 0 r
.42171 .98627 m
.43736 .99522 L
s
.40952 .99158 m
.42171 .98627 L
s
.42171 .98627 m
.42788 .97574 L
s
0 .186 1 r
.54676 .68561 m
.53774 .69279 L
s
.53878 .67814 m
.54676 .68561 L
s
1 0 .462 r
.74398 .48586 m
.74699 .50354 L
s
.72569 .49944 m
.74699 .50354 L
s
.977 0 1 r
.46147 .76159 m
.47407 .77009 L
s
.45109 .76652 m
.46147 .76159 L
s
.46147 .76159 m
.46671 .75469 L
s
1 0 .304 r
.3577 .93294 m
.38127 .8493 L
s
.04 0 1 r
.61429 .31276 m
.58435 .36713 L
s
0 .186 1 r
.53774 .69279 m
.52865 .6848 L
s
.52865 .6848 m
.53878 .67814 L
s
.04 0 1 r
.29851 .60425 m
.29789 .59121 L
s
.3125 .59858 m
.29851 .60425 L
s
1 0 .848 r
.7008 .36347 m
.70766 .37892 L
s
.68693 .37967 m
.70766 .37892 L
s
0 .186 1 r
.35014 .55863 m
.39471 .57139 L
s
.714 0 1 r
.84564 .68283 m
.77338 .66857 L
s
1 0 .678 r
.87831 .59554 m
.86753 .59239 L
s
.86753 .59239 m
.867 .57491 L
s
.86753 .59239 m
.85804 .58808 L
s
.543 0 1 r
.42501 .36672 m
.4195 .36345 L
s
.43593 .35608 m
.42501 .36672 L
s
.437 .37035 m
.42501 .36672 L
s
1 0 .462 r
.72569 .49944 m
.74398 .48586 L
s
0 .186 1 r
.53878 .67814 m
.53774 .69279 L
s
.343 0 1 r
.67025 .59498 m
.66025 .59156 L
s
.66025 .59156 m
.66108 .57742 L
s
.66025 .59156 m
.65493 .58822 L
s
.04 0 1 r
.65603 .77109 m
.64543 .7783 L
s
.64205 .76221 m
.65603 .77109 L
s
1 0 .848 r
.28145 .49869 m
.26031 .49729 L
s
.26803 .48227 m
.28145 .49869 L
s
.04 0 1 r
.29789 .59121 m
.3125 .59858 L
s
1 0 .848 r
.26031 .49729 m
.26803 .48227 L
s
.04 0 1 r
.64205 .76221 m
.64543 .7783 L
s
1 0 .848 r
.68693 .37967 m
.7008 .36347 L
s
.58144 .92951 m
.585 .84918 L
s
1 0 .678 r
.83871 .30771 m
.77525 .34889 L
s
.543 0 1 r
.43048 .35273 m
.43593 .35608 L
s
.43593 .35608 m
.437 .37035 L
s
1 0 .15 r
.24244 .37887 m
.21851 .37468 L
s
.22966 .3585 m
.24244 .37887 L
s
.977 0 1 r
.47407 .77009 m
.46373 .77508 L
s
.46671 .75469 m
.47407 .77009 L
s
1 0 .678 r
.867 .57491 m
.8778 .57795 L
s
.867 .57491 m
.85804 .58808 L
s
1 0 0 r
.43736 .99522 m
.42523 1.00062 L
s
.42788 .97574 m
.43736 .99522 L
s
0 1 .939 r
.57416 .55422 m
.55822 .56382 L
s
.343 0 1 r
.66108 .57742 m
.6711 .58077 L
s
.66108 .57742 m
.65493 .58822 L
s
.04 0 1 r
.59788 .35725 m
.59479 .36188 L
s
.59479 .36188 m
.58292 .35511 L
s
.59479 .36188 m
.58435 .36713 L
s
1 0 .304 r
.37486 .85982 m
.3897 .86837 L
s
.36328 .86402 m
.37486 .85982 L
s
.37486 .85982 m
.38127 .8493 L
s
.04 0 1 r
.58292 .35511 m
.58594 .35043 L
s
.58292 .35511 m
.58435 .36713 L
s
.714 0 1 r
.78871 .68087 m
.7833 .67742 L
s
.7833 .67742 m
.78717 .66208 L
s
.7833 .67742 m
.77338 .66857 L
s
1 0 .15 r
.21851 .37468 m
.22966 .3585 L
s
0 .186 1 r
.46674 .48059 m
.45546 .48173 L
s
.46896 .46935 m
.46674 .48059 L
s
.46812 .48184 m
.46674 .48059 L
s
.543 0 1 r
.30891 .80138 m
.34122 .74065 L
s
.977 0 1 r
.46373 .77508 m
.45109 .76652 L
s
.45109 .76652 m
.46671 .75469 L
s
1 0 .848 r
.58365 .86062 m
.59667 .86565 L
s
.5719 .86511 m
.58365 .86062 L
s
.58365 .86062 m
.585 .84918 L
s
.714 0 1 r
.78717 .66208 m
.79261 .66542 L
s
.78717 .66208 m
.77338 .66857 L
s
.343 0 1 r
.63282 .47906 m
.62202 .47846 L
s
.62202 .47846 m
.61786 .4653 L
s
.62202 .47846 m
.61619 .4788 L
s
1 0 0 r
.42523 1.00062 m
.40952 .99158 L
s
.40952 .99158 m
.42788 .97574 L
s
.977 0 1 r
.30125 .42493 m
.36307 .46987 L
s
.79935 .54978 m
.73001 .56483 L
s
0 .4 1 r
.50525 .5841 m
.49552 .59116 L
s
.49837 .57413 m
.50525 .5841 L
s
.49962 .58268 m
.50525 .5841 L
s
.343 0 1 r
.6711 .58077 m
.67025 .59498 L
s
.65493 .58822 m
.67025 .59498 L
s
0 .4 1 r
.48863 .58119 m
.49837 .57413 L
s
.49837 .57413 m
.49962 .58268 L
s
.543 0 1 r
.437 .37035 m
.4195 .36345 L
s
.43048 .35273 m
.437 .37035 L
s
.977 0 1 r
.46671 .75469 m
.46373 .77508 L
s
1 0 0 r
.42788 .97574 m
.42523 1.00062 L
s
0 .4 1 r
.49552 .59116 m
.48863 .58119 L
s
.49962 .58268 m
.49552 .59116 L
s
.343 0 1 r
.5337 .79758 m
.539 .73369 L
s
0 .186 1 r
.45546 .48173 m
.45765 .47046 L
s
.45765 .47046 m
.46896 .46935 L
s
.46812 .48184 m
.45546 .48173 L
s
.46896 .46935 m
.46812 .48184 L
s
.543 0 1 r
.4195 .36345 m
.43048 .35273 L
s
0 .4 1 r
.48863 .58119 m
.49962 .58268 L
s
1 0 .304 r
.3897 .86837 m
.37818 .87265 L
s
.38127 .8493 m
.3897 .86837 L
s
1 0 .678 r
.8778 .57795 m
.87831 .59554 L
s
.85804 .58808 m
.87831 .59554 L
s
.343 0 1 r
.65493 .58822 m
.6711 .58077 L
s
.61786 .4653 m
.62868 .46583 L
s
.61786 .4653 m
.61619 .4788 L
s
0 .802 1 r
.52632 .42014 m
.52632 .46185 L
s
.04 0 1 r
.58435 .36713 m
.59788 .35725 L
s
.58435 .36713 m
.58594 .35043 L
s
1 0 .304 r
.83703 .47478 m
.82403 .47312 L
s
.82403 .47312 m
.82067 .4547 L
s
.82403 .47312 m
.81459 .47065 L
s
1 0 .678 r
.85804 .58808 m
.8778 .57795 L
s
.543 0 1 r
.71694 .7483 m
.71951 .75021 L
s
.70709 .76021 m
.71694 .7483 L
s
.71694 .7483 m
.70164 .74556 L
s
0 .186 1 r
.42131 .65834 m
.42929 .66841 L
s
.41281 .66347 m
.42131 .65834 L
s
.42131 .65834 m
.42681 .65956 L
s
.543 0 1 r
.70959 .7622 m
.70709 .76021 L
s
.70709 .76021 m
.70164 .74556 L
s
.04 0 1 r
.58594 .35043 m
.59788 .35725 L
s
0 .802 1 r
.60207 .65949 m
.6091 .6638 L
s
.59535 .66792 m
.60207 .65949 L
s
.60207 .65949 m
.59732 .66051 L
s
.714 0 1 r
.77338 .66857 m
.78871 .68087 L
s
.77338 .66857 m
.79261 .66542 L
s
0 .536 1 r
.25961 .66843 m
.30879 .65268 L
s
.543 0 1 r
.75968 .79377 m
.70164 .74556 L
s
0 .186 1 r
.42929 .66841 m
.42081 .67358 L
s
.42681 .65956 m
.42929 .66841 L
s
1 0 .848 r
.59667 .86565 m
.58493 .87019 L
s
.585 .84918 m
.59667 .86565 L
s
.543 0 1 r
.33293 .74692 m
.34451 .75587 L
s
.32485 .74994 m
.33293 .74692 L
s
.33293 .74692 m
.34122 .74065 L
s
0 .802 1 r
.60237 .67226 m
.59535 .66792 L
s
.59535 .66792 m
.59732 .66051 L
s
1 0 .848 r
.58493 .87019 m
.5719 .86511 L
s
.5719 .86511 m
.585 .84918 L
s
0 .186 1 r
.45765 .47046 m
.46812 .48184 L
s
.343 0 1 r
.62868 .46583 m
.63282 .47906 L
s
.61619 .4788 m
.63282 .47906 L
s
1 0 .678 r
.79713 .34808 m
.78635 .34922 L
s
.78635 .34922 m
.77912 .33305 L
s
.78635 .34922 m
.77525 .34889 L
s
.714 0 1 r
.79261 .66542 m
.78871 .68087 L
s
1 0 .304 r
.37818 .87265 m
.36328 .86402 L
s
.36328 .86402 m
.38127 .8493 L
s
1 0 .15 r
.49293 1.04287 m
.51237 .95468 L
s
1 0 .304 r
.25184 .28982 m
.32346 .34806 L
s
.977 0 1 r
.75257 .41533 m
.69104 .45376 L
s
1 0 .304 r
.82067 .4547 m
.83368 .45624 L
s
.82067 .4547 m
.81459 .47065 L
s
.977 0 1 r
.35037 .46838 m
.34239 .46758 L
s
.35874 .45405 m
.35037 .46838 L
s
.36307 .46987 m
.35037 .46838 L
s
.543 0 1 r
.34451 .75587 m
.33648 .75895 L
s
.34122 .74065 m
.34451 .75587 L
s
1 0 .304 r
.38127 .8493 m
.37818 .87265 L
s
1 0 .848 r
.585 .84918 m
.58493 .87019 L
s
0 .186 1 r
.39045 .57362 m
.38107 .57645 L
s
.39024 .56116 m
.39045 .57362 L
s
.39471 .57139 m
.39045 .57362 L
s
1 0 .304 r
.30615 .34529 m
.30016 .34289 L
s
.31788 .32985 m
.30615 .34529 L
s
.32346 .34806 m
.30615 .34529 L
s
0 1 .939 r
.48546 .66426 m
.49916 .63704 L
s
1 0 .678 r
.77912 .33305 m
.78987 .3318 L
s
.77912 .33305 m
.77525 .34889 L
s
0 .802 1 r
.6091 .6638 m
.60237 .67226 L
s
.59732 .66051 m
.6091 .6638 L
s
.343 0 1 r
.61619 .4788 m
.62868 .46583 L
s
0 .186 1 r
.42081 .67358 m
.41281 .66347 L
s
.41281 .66347 m
.42681 .65956 L
s
.543 0 1 r
.70164 .74556 m
.70959 .7622 L
s
.70164 .74556 m
.71951 .75021 L
s
.977 0 1 r
.3508 .45314 m
.35874 .45405 L
s
.35874 .45405 m
.36307 .46987 L
s
.04 0 1 r
.49537 .33751 m
.48271 .33941 L
s
.49982 .33307 m
.49537 .33751 L
s
.49537 .33751 m
.49458 .3492 L
s
1 0 .304 r
.31198 .32732 m
.31788 .32985 L
s
.31788 .32985 m
.32346 .34806 L
s
0 .802 1 r
.59732 .66051 m
.60237 .67226 L
s
.04 0 1 r
.47797 .28465 m
.49458 .3492 L
s
0 .186 1 r
.42681 .65956 m
.42081 .67358 L
s
.343 0 1 r
.53748 .74145 m
.54843 .74706 L
s
.52742 .74616 m
.53748 .74145 L
s
.53748 .74145 m
.539 .73369 L
s
0 .186 1 r
.38085 .56395 m
.39024 .56116 L
s
.39024 .56116 m
.39471 .57139 L
s
1 0 .15 r
.50648 .96581 m
.52225 .97408 L
s
.4946 .9709 m
.50648 .96581 L
s
.50648 .96581 m
.51237 .95468 L
s
.543 0 1 r
.20979 .53407 m
.27614 .56409 L
s
0 .186 1 r
.71251 .66007 m
.65718 .64248 L
s
0 .536 1 r
.30347 .66002 m
.29838 .66281 L
s
.29937 .64893 m
.30347 .66002 L
s
.30879 .65268 m
.30347 .66002 L
s
.977 0 1 r
.74943 .57147 m
.73974 .56869 L
s
.73974 .56869 m
.73872 .55214 L
s
.73974 .56869 m
.73001 .56483 L
s
.04 0 1 r
.48271 .33941 m
.48709 .33497 L
s
.49458 .3492 m
.48271 .33941 L
s
0 .536 1 r
.29427 .65167 m
.29937 .64893 L
s
.29937 .64893 m
.30879 .65268 L
s
.543 0 1 r
.71951 .75021 m
.70959 .7622 L
s
1 0 .304 r
.83368 .45624 m
.83703 .47478 L
s
.81459 .47065 m
.83703 .47478 L
s
.543 0 1 r
.33648 .75895 m
.32485 .74994 L
s
.32485 .74994 m
.34122 .74065 L
s
.34122 .74065 m
.33648 .75895 L
s
0 .186 1 r
.38107 .57645 m
.38085 .56395 L
s
.39471 .57139 m
.38107 .57645 L
s
1 0 .462 r
.44428 .91032 m
.46541 .82602 L
s
.714 0 1 r
.7053 .27945 m
.65841 .34064 L
s
.977 0 1 r
.73872 .55214 m
.74843 .55481 L
s
.73872 .55214 m
.73001 .56483 L
s
0 .802 1 r
.53001 .45776 m
.51949 .45577 L
s
.53316 .45106 m
.53001 .45776 L
s
.52632 .46185 m
.53001 .45776 L
s
1 0 .678 r
.78987 .3318 m
.79713 .34808 L
s
.77525 .34889 m
.79713 .34808 L
s
1 0 .304 r
.81459 .47065 m
.83368 .45624 L
s
.543 0 1 r
.26333 .56466 m
.25701 .56581 L
s
.26852 .55033 m
.26333 .56466 L
s
.27614 .56409 m
.26333 .56466 L
s
0 1 .939 r
.43671 .52952 m
.46685 .54752 L
s
.899 0 1 r
.94075 .65586 m
.86384 .64235 L
s
.714 0 1 r
.67577 .33138 m
.67278 .3352 L
s
.67278 .3352 m
.65995 .32532 L
s
.67278 .3352 m
.65841 .34064 L
s
.343 0 1 r
.54843 .74706 m
.53838 .75181 L
s
.539 .73369 m
.54843 .74706 L
s
.714 0 1 r
.65322 .84411 m
.66046 .84535 L
s
.63977 .85079 m
.65322 .84411 L
s
.65322 .84411 m
.64456 .83334 L
s
.65995 .32532 m
.66286 .32144 L
s
.65995 .32532 m
.65841 .34064 L
s
.04 0 1 r
.49458 .3492 m
.48709 .33497 L
s
.49982 .33307 m
.49458 .3492 L
s
0 .186 1 r
.38085 .56395 m
.39471 .57139 L
s
.977 0 1 r
.36307 .46987 m
.34239 .46758 L
s
.3508 .45314 m
.36307 .46987 L
s
0 1 .939 r
.56385 .56857 m
.55514 .5639 L
s
.55514 .5639 m
.55906 .55516 L
s
.55514 .5639 m
.55822 .56382 L
s
1 0 .678 r
.77525 .34889 m
.78987 .3318 L
s
.977 0 1 r
.34239 .46758 m
.3508 .45314 L
s
.343 0 1 r
.53838 .75181 m
.52742 .74616 L
s
.52742 .74616 m
.539 .73369 L
s
0 .802 1 r
.51949 .45577 m
.5226 .44905 L
s
.51949 .45577 m
.52632 .46185 L
s
1 0 .304 r
.32346 .34806 m
.30016 .34289 L
s
.31198 .32732 m
.32346 .34806 L
s
.04 0 1 r
.48709 .33497 m
.49982 .33307 L
s
.543 0 1 r
.26223 .55139 m
.26852 .55033 L
s
.26852 .55033 m
.27614 .56409 L
s
0 1 .939 r
.56779 .55983 m
.56385 .56857 L
s
.55822 .56382 m
.56385 .56857 L
s
.714 0 1 r
.67212 .90677 m
.64456 .83334 L
s
0 1 .939 r
.55906 .55516 m
.56779 .55983 L
s
.55906 .55516 m
.55822 .56382 L
s
.977 0 1 r
.71169 .45357 m
.70178 .45369 L
s
.70178 .45369 m
.69535 .43842 L
s
.70178 .45369 m
.69104 .45376 L
s
1 0 .15 r
.52225 .97408 m
.51043 .97925 L
s
.51237 .95468 m
.52225 .97408 L
s
0 .536 1 r
.30879 .65268 m
.29838 .66281 L
s
.29427 .65167 m
.30879 .65268 L
s
.29838 .66281 m
.29427 .65167 L
s
1 0 .304 r
.15944 .39828 m
.23517 .45297 L
s
0 .4 1 r
.66483 .52496 m
.61816 .54453 L
s
.899 0 1 r
.88043 .65495 m
.8745 .65157 L
s
.8745 .65157 m
.87823 .63525 L
s
.8745 .65157 m
.86384 .64235 L
s
.714 0 1 r
.64694 .85208 m
.63977 .85079 L
s
.63977 .85079 m
.64456 .83334 L
s
1 0 .462 r
.45929 .83714 m
.47421 .84497 L
s
.44805 .84111 m
.45929 .83714 L
s
.45929 .83714 m
.46541 .82602 L
s
0 1 .939 r
.55822 .56382 m
.56779 .55983 L
s
1 0 .304 r
.30016 .34289 m
.31198 .32732 L
s
.343 0 1 r
.539 .73369 m
.53838 .75181 L
s
0 .186 1 r
.66869 .65372 m
.6635 .65067 L
s
.6635 .65067 m
.668 .63839 L
s
.6635 .65067 m
.65718 .64248 L
s
0 .802 1 r
.5226 .44905 m
.53316 .45106 L
s
.52632 .46185 m
.53316 .45106 L
s
1 0 .304 r
.21798 .45059 m
.2112 .44964 L
s
.22862 .43435 m
.21798 .45059 L
s
.23517 .45297 m
.21798 .45059 L
s
.899 0 1 r
.87823 .63525 m
.88419 .63852 L
s
.87823 .63525 m
.86384 .64235 L
s
0 .186 1 r
.668 .63839 m
.67322 .64137 L
s
.668 .63839 m
.65718 .64248 L
s
.977 0 1 r
.69535 .43842 m
.70524 .4382 L
s
.69535 .43842 m
.69104 .45376 L
s
.343 0 1 r
.39512 .77635 m
.42506 .71546 L
s
.977 0 1 r
.74843 .55481 m
.74943 .57147 L
s
.73001 .56483 m
.74943 .57147 L
s
1 0 .15 r
.51043 .97925 m
.4946 .9709 L
s
.4946 .9709 m
.51237 .95468 L
s
0 .802 1 r
.5226 .44905 m
.52632 .46185 L
s
1 0 .304 r
.22191 .43327 m
.22862 .43435 L
s
.22862 .43435 m
.23517 .45297 L
s
.714 0 1 r
.65841 .34064 m
.67577 .33138 L
s
.65841 .34064 m
.66286 .32144 L
s
.977 0 1 r
.73001 .56483 m
.74843 .55481 L
s
1 0 .848 r
.78912 .74205 m
.78781 .73953 L
s
.78781 .73953 m
.79684 .72429 L
s
.78781 .73953 m
.7777 .7243 L
s
.343 0 1 r
.38743 .39335 m
.43471 .44458 L
s
1 0 .848 r
.89417 .52036 m
.82095 .53651 L
s
.543 0 1 r
.27614 .56409 m
.25701 .56581 L
s
.26223 .55139 m
.27614 .56409 L
s
.714 0 1 r
.64456 .83334 m
.64694 .85208 L
s
.64456 .83334 m
.66046 .84535 L
s
1 0 .15 r
.51237 .95468 m
.51043 .97925 L
s
1 0 .848 r
.79684 .72429 m
.79823 .72669 L
s
.79684 .72429 m
.7777 .7243 L
s
0 1 .939 r
.49643 .63665 m
.50329 .64372 L
s
.48946 .64139 m
.49643 .63665 L
s
.49643 .63665 m
.49916 .63704 L
s
.543 0 1 r
.25701 .56581 m
.26223 .55139 L
s
0 .186 1 r
.62404 .77242 m
.59856 .71639 L
s
.714 0 1 r
.66046 .84535 m
.64694 .85208 L
s
1 0 .462 r
.47421 .84497 m
.46302 .84901 L
s
.46541 .82602 m
.47421 .84497 L
s
.714 0 1 r
.66286 .32144 m
.67577 .33138 L
s
.543 0 1 r
.55381 .31244 m
.54569 .30996 L
s
.56701 .31433 m
.55381 .31244 L
s
.55381 .31244 m
.55347 .32757 L
s
0 1 .939 r
.50329 .64372 m
.49632 .64848 L
s
.49916 .63704 m
.50329 .64372 L
s
1 0 0 r
.10855 .26104 m
.18659 .32119 L
s
1 0 .15 r
.35319 1.02516 m
.37753 .9363 L
s
0 .186 1 r
.61664 .3884 m
.58584 .44141 L
s
.977 0 1 r
.70524 .4382 m
.71169 .45357 L
s
.69104 .45376 m
.71169 .45357 L
s
0 .186 1 r
.65718 .64248 m
.66869 .65372 L
s
.65718 .64248 m
.67322 .64137 L
s
.899 0 1 r
.86384 .64235 m
.88043 .65495 L
s
.86384 .64235 m
.88419 .63852 L
s
1 0 0 r
.16849 .31878 m
.16127 .31631 L
s
.18045 .30193 m
.16849 .31878 L
s
.18659 .32119 m
.16849 .31878 L
s
0 .186 1 r
.67322 .64137 m
.66869 .65372 L
s
.343 0 1 r
.41702 .72227 m
.42857 .73049 L
s
.40943 .72499 m
.41702 .72227 L
s
.41702 .72227 m
.42506 .71546 L
s
.42252 .44083 m
.41736 .43838 L
s
.43296 .43017 m
.42252 .44083 L
s
.43471 .44458 m
.42252 .44083 L
s
0 1 .939 r
.49632 .64848 m
.48946 .64139 L
s
.48946 .64139 m
.49916 .63704 L
s
0 .186 1 r
.60584 .72347 m
.61207 .72525 L
s
.59534 .73007 m
.60584 .72347 L
s
.60584 .72347 m
.59856 .71639 L
s
0 .802 1 r
.34542 .64095 m
.39238 .62592 L
s
1 0 .848 r
.7777 .7243 m
.78912 .74205 L
s
.7777 .7243 m
.79823 .72669 L
s
.85419 .76848 m
.7777 .7243 L
s
.977 0 1 r
.69104 .45376 m
.70524 .4382 L
s
1 0 0 r
.17333 .29931 m
.18045 .30193 L
s
.18045 .30193 m
.18659 .32119 L
s
1 0 .462 r
.46302 .84901 m
.44805 .84111 L
s
.44805 .84111 m
.46541 .82602 L
s
1 0 .304 r
.23517 .45297 m
.2112 .44964 L
s
.22191 .43327 m
.23517 .45297 L
s
.899 0 1 r
.88419 .63852 m
.88043 .65495 L
s
0 1 .939 r
.46432 .54771 m
.45622 .54942 L
s
.46526 .53835 m
.46432 .54771 L
s
.46685 .54752 m
.46432 .54771 L
s
.343 0 1 r
.42787 .42765 m
.43296 .43017 L
s
.43296 .43017 m
.43471 .44458 L
s
0 1 .939 r
.49916 .63704 m
.49632 .64848 L
s
1 0 .848 r
.37768 .31556 m
.37507 .31203 L
s
.39116 .30384 m
.37768 .31556 L
s
.39457 .32103 m
.37768 .31556 L
s
.38866 .30022 m
.39116 .30384 L
s
.39116 .30384 m
.39457 .32103 L
s
1 0 .678 r
.58292 1.02188 m
.58652 .93619 L
s
1 0 .848 r
.33763 .25572 m
.39457 .32103 L
s
.84708 .38341 m
.78172 .42344 L
s
1 0 .462 r
.46541 .82602 m
.46302 .84901 L
s
.543 0 1 r
.55894 .31186 m
.56701 .31433 L
s
.56701 .31433 m
.55347 .32757 L
s
.343 0 1 r
.42857 .73049 m
.42103 .73326 L
s
.42506 .71546 m
.42857 .73049 L
s
0 .4 1 r
.63265 .54722 m
.62478 .5457 L
s
.62478 .5457 m
.62257 .53394 L
s
.62478 .5457 m
.61816 .54453 L
s
0 .186 1 r
.60153 .73189 m
.59534 .73007 L
s
.59534 .73007 m
.59856 .71639 L
s
1 0 .15 r
.37077 .94748 m
.38651 .95638 L
s
.35866 .95209 m
.37077 .94748 L
s
.37077 .94748 m
.37753 .9363 L
s
.543 0 1 r
.55347 .32757 m
.55894 .31186 L
s
.55347 .32757 m
.54569 .30996 L
s
.56794 .25037 m
.55347 .32757 L
s
0 .186 1 r
.59916 .43225 m
.59631 .43605 L
s
.59631 .43605 m
.58496 .42923 L
s
.59631 .43605 m
.58584 .44141 L
s
0 1 .939 r
.45715 .54003 m
.46526 .53835 L
s
.46526 .53835 m
.46685 .54752 L
s
0 .186 1 r
.58496 .42923 m
.58775 .42539 L
s
.58496 .42923 m
.58584 .44141 L
s
0 1 .078 r
.57544 .63664 m
.55878 .61847 L
s
1 0 .304 r
.2112 .44964 m
.22191 .43327 L
s
1 0 .678 r
.58509 .9484 m
.59892 .95372 L
s
.57267 .95319 m
.58509 .9484 L
s
.58509 .9484 m
.58652 .93619 L
s
0 1 .939 r
.45622 .54942 m
.45715 .54003 L
s
.46685 .54752 m
.45622 .54942 L
s
0 .4 1 r
.62257 .53394 m
.63044 .5354 L
s
.62257 .53394 m
.61816 .54453 L
s
1 0 .848 r
.79823 .72669 m
.78912 .74205 L
s
.543 0 1 r
.54569 .30996 m
.55894 .31186 L
s
1 0 .848 r
.72357 .8237 m
.72482 .8248 L
s
.71038 .83582 m
.72357 .8237 L
s
.72357 .8237 m
.70549 .81714 L
s
.30307 .89055 m
.33715 .81236 L
s
.71152 .83703 m
.71038 .83582 L
s
.71038 .83582 m
.70549 .81714 L
s
.32727 .82285 m
.34169 .83135 L
s
.31885 .82481 m
.32727 .82285 L
s
.32727 .82285 m
.33715 .81236 L
s
.84158 .54328 m
.83131 .54072 L
s
.83131 .54072 m
.83002 .52325 L
s
.83131 .54072 m
.82095 .53651 L
s
0 .802 1 r
.38702 .63293 m
.38262 .63542 L
s
.38321 .6225 m
.38702 .63293 L
s
.39238 .62592 m
.38702 .63293 L
s
0 1 .939 r
.45715 .54003 m
.46685 .54752 L
s
.343 0 1 r
.43471 .44458 m
.41736 .43838 L
s
.42787 .42765 m
.43471 .44458 L
s
0 .186 1 r
.59856 .71639 m
.60153 .73189 L
s
.59856 .71639 m
.61207 .72525 L
s
.61207 .72525 m
.60153 .73189 L
s
.343 0 1 r
.42103 .73326 m
.40943 .72499 L
s
.40943 .72499 m
.42506 .71546 L
s
.29519 .5041 m
.35947 .53575 L
s
.522 0 1 r
.8067 .63231 m
.73362 .61947 L
s
0 .802 1 r
.3788 .62495 m
.38321 .6225 L
s
.38321 .6225 m
.39238 .62592 L
s
1 0 0 r
.18659 .32119 m
.16127 .31631 L
s
.17333 .29931 m
.18659 .32119 L
s
1 0 .848 r
.39457 .32103 m
.37507 .31203 L
s
.38866 .30022 m
.39457 .32103 L
s
.343 0 1 r
.42506 .71546 m
.42103 .73326 L
s
.41736 .43838 m
.42787 .42765 L
s
0 .4 1 r
.63044 .5354 m
.63265 .54722 L
s
.61816 .54453 m
.63265 .54722 L
s
1 0 .15 r
.38651 .95638 m
.37448 .96107 L
s
.37753 .9363 m
.38651 .95638 L
s
1 0 .848 r
.83002 .52325 m
.8403 .52569 L
s
.83002 .52325 m
.82095 .53651 L
s
.977 0 1 r
.5339 .8869 m
.53928 .80559 L
s
.899 0 1 r
.79949 .24499 m
.74812 .30855 L
s
.04 0 1 r
.2999 .72262 m
.29825 .72376 L
s
.29064 .712 m
.2999 .72262 L
s
.30495 .7087 m
.2999 .72262 L
s
0 .186 1 r
.58584 .44141 m
.59916 .43225 L
s
.58584 .44141 m
.58775 .42539 L
s
.04 0 1 r
.28893 .71307 m
.29064 .712 L
s
.29064 .712 m
.30495 .7087 L
s
1 0 .848 r
.34169 .83135 m
.33335 .83338 L
s
.33715 .81236 m
.34169 .83135 L
s
.899 0 1 r
.76687 .29924 m
.76332 .30315 L
s
.76332 .30315 m
.75007 .29235 L
s
.76332 .30315 m
.74812 .30855 L
s
.75007 .29235 m
.75352 .28836 L
s
.75007 .29235 m
.74812 .30855 L
s
.343 0 1 r
.34636 .5359 m
.34092 .53663 L
s
.35212 .52216 m
.34636 .5359 L
s
.35947 .53575 m
.34636 .5359 L
s
1 0 .848 r
.70549 .81714 m
.71152 .83703 L
s
.70549 .81714 m
.72482 .8248 L
s
.76599 .88322 m
.70549 .81714 L
s
0 .4 1 r
.61816 .54453 m
.63044 .5354 L
s
.522 0 1 r
.74898 .63123 m
.7443 .62823 L
s
.7443 .62823 m
.74768 .61292 L
s
.7443 .62823 m
.73362 .61947 L
s
0 .186 1 r
.58775 .42539 m
.59916 .43225 L
s
0 1 .078 r
.52632 .49939 m
.52632 .52785 L
s
1 0 0 r
.16127 .31631 m
.17333 .29931 L
s
1 0 .678 r
.59892 .95372 m
.58651 .95856 L
s
.58652 .93619 m
.59892 .95372 L
s
.977 0 1 r
.5375 .81777 m
.55051 .82246 L
s
.52587 .82146 m
.5375 .81777 L
s
.5375 .81777 m
.53928 .80559 L
s
1 0 .848 r
.37507 .31203 m
.38866 .30022 L
s
.343 0 1 r
.34671 .52281 m
.35212 .52216 L
s
.35212 .52216 m
.35947 .53575 L
s
.522 0 1 r
.74768 .61292 m
.75238 .61583 L
s
.74768 .61292 m
.73362 .61947 L
s
1 0 .678 r
.58651 .95856 m
.57267 .95319 L
s
.57267 .95319 m
.58652 .93619 L
s
1 0 .848 r
.80358 .42323 m
.79318 .42361 L
s
.79318 .42361 m
.78638 .40747 L
s
.79318 .42361 m
.78172 .42344 L
s
0 .802 1 r
.39238 .62592 m
.38262 .63542 L
s
.3788 .62495 m
.39238 .62592 L
s
.04 0 1 r
.25241 .75449 m
.30495 .7087 L
s
0 .802 1 r
.38262 .63542 m
.3788 .62495 L
s
1 0 .15 r
.37448 .96107 m
.35866 .95209 L
s
.35866 .95209 m
.37753 .9363 L
s
.04 0 1 r
.30495 .7087 m
.29825 .72376 L
s
.28893 .71307 m
.30495 .7087 L
s
0 1 .078 r
.5621 .61794 m
.56671 .62072 L
s
.55759 .62355 m
.5621 .61794 L
s
.5621 .61794 m
.55878 .61847 L
s
.04 0 1 r
.25812 .62416 m
.25691 .62659 L
s
.25831 .61022 m
.25812 .62416 L
s
.2717 .61874 m
.25812 .62416 L
s
1 0 .15 r
.37753 .9363 m
.37448 .96107 L
s
1 0 .678 r
.58652 .93619 m
.58651 .95856 L
s
1 0 .462 r
.24442 .36576 m
.31818 .42262 L
s
.343 0 1 r
.75869 .49466 m
.6947 .51989 L
s
0 1 .078 r
.56219 .62635 m
.55759 .62355 L
s
.55759 .62355 m
.55878 .61847 L
s
1 0 .848 r
.33715 .81236 m
.33335 .83338 L
s
.31885 .82481 m
.33715 .81236 L
s
.78638 .40747 m
.79674 .40698 L
s
.78638 .40747 m
.78172 .42344 L
s
1 0 .462 r
.30049 .41976 m
.29486 .41831 L
s
.31178 .40412 m
.30049 .41976 L
s
.31818 .42262 m
.30049 .41976 L
s
.04 0 1 r
.25709 .61256 m
.25831 .61022 L
s
.25831 .61022 m
.2717 .61874 L
s
1 0 .848 r
.8403 .52569 m
.84158 .54328 L
s
.82095 .53651 m
.84158 .54328 L
s
.33335 .83338 m
.31885 .82481 L
s
.72482 .8248 m
.71152 .83703 L
s
0 .4 1 r
.48436 .75045 m
.49867 .69333 L
s
.899 0 1 r
.74812 .30855 m
.76687 .29924 L
s
.74812 .30855 m
.75352 .28836 L
s
0 .186 1 r
.49424 .41171 m
.48205 .41403 L
s
.49863 .40814 m
.49424 .41171 L
s
.49424 .41171 m
.49376 .42374 L
s
1 0 .462 r
.30625 .40253 m
.31178 .40412 L
s
.31178 .40412 m
.31818 .42262 L
s
1 0 .848 r
.82095 .53651 m
.8403 .52569 L
s
1 0 .678 r
.88263 .71676 m
.88089 .71421 L
s
.88089 .71421 m
.88989 .6979 L
s
.88089 .71421 m
.86984 .69855 L
s
1 0 .848 r
.63047 .28137 m
.62406 .2787 L
s
.64615 .28726 m
.63047 .28137 L
s
.63047 .28137 m
.62867 .29994 L
s
0 1 .078 r
.56671 .62072 m
.56219 .62635 L
s
.55878 .61847 m
.56671 .62072 L
s
.714 0 1 r
.45232 .28259 m
.4377 .28699 L
s
.45805 .27918 m
.45232 .28259 L
s
.45232 .28259 m
.45319 .29874 L
s
.343 0 1 r
.35947 .53575 m
.34092 .53663 L
s
.34671 .52281 m
.35947 .53575 L
s
.66706 .71488 m
.6655 .71341 L
s
.6655 .71341 m
.67518 .70164 L
s
.6655 .71341 m
.65951 .69868 L
s
.67518 .70164 m
.67681 .70303 L
s
.67518 .70164 m
.65951 .69868 L
s
0 1 .078 r
.55878 .61847 m
.56219 .62635 L
s
.04 0 1 r
.29825 .72376 m
.28893 .71307 L
s
1 0 .678 r
.88989 .6979 m
.8917 .70031 L
s
.88989 .6979 m
.86984 .69855 L
s
.522 0 1 r
.73362 .61947 m
.74898 .63123 L
s
.73362 .61947 m
.75238 .61583 L
s
0 .186 1 r
.47666 .36066 m
.49376 .42374 L
s
.977 0 1 r
.55051 .82246 m
.5389 .82621 L
s
.53928 .80559 m
.55051 .82246 L
s
.04 0 1 r
.2717 .61874 m
.25691 .62659 L
s
.25709 .61256 m
.2717 .61874 L
s
.2012 .61695 m
.2717 .61874 L
s
0 1 .078 r
.52877 .5249 m
.52177 .52363 L
s
.53087 .52061 m
.52877 .5249 L
s
.52632 .52785 m
.52877 .5249 L
s
.343 0 1 r
.34092 .53663 m
.34671 .52281 L
s
.977 0 1 r
.5389 .82621 m
.52587 .82146 L
s
.52587 .82146 m
.53928 .80559 L
s
0 .186 1 r
.48205 .41403 m
.48639 .41047 L
s
.49376 .42374 m
.48205 .41403 L
s
.522 0 1 r
.75238 .61583 m
.74898 .63123 L
s
0 1 .078 r
.52177 .52363 m
.52385 .51933 L
s
.52177 .52363 m
.52632 .52785 L
s
.899 0 1 r
.75352 .28836 m
.76687 .29924 L
s
.343 0 1 r
.71756 .74638 m
.65951 .69868 L
s
0 .4 1 r
.49443 .70142 m
.50442 .70623 L
s
.48714 .70343 m
.49443 .70142 L
s
.49443 .70142 m
.49867 .69333 L
s
1 0 .848 r
.63984 .28464 m
.64615 .28726 L
s
.64615 .28726 m
.62867 .29994 L
s
.714 0 1 r
.4377 .28699 m
.44335 .28361 L
s
.45319 .29874 m
.4377 .28699 L
s
.977 0 1 r
.53928 .80559 m
.5389 .82621 L
s
.343 0 1 r
.71323 .52259 m
.70606 .52143 L
s
.70606 .52143 m
.70203 .50705 L
s
.70606 .52143 m
.6947 .51989 L
s
1 0 .304 r
.44205 1.00354 m
.46381 .9139 L
s
1 0 .15 r
.19309 .22592 m
.26921 .28844 L
s
.522 0 1 r
.71016 .35552 m
.66186 .4153 L
s
1 0 .848 r
.79674 .40698 m
.80358 .42323 L
s
.78172 .42344 m
.80358 .42323 L
s
1 0 .15 r
.25054 .28552 m
.24457 .28251 L
s
.26318 .26929 m
.25054 .28552 L
s
.26921 .28844 m
.25054 .28552 L
s
0 1 .078 r
.52385 .51933 m
.53087 .52061 L
s
.52632 .52785 m
.53087 .52061 L
s
.899 0 1 r
.65684 .9326 m
.66442 .9341 L
s
.64234 .93954 m
.65684 .9326 L
s
.65684 .9326 m
.64766 .92094 L
s
.04 0 1 r
.25691 .62659 m
.25709 .61256 L
s
1 0 .848 r
.62867 .29994 m
.63984 .28464 L
s
.62867 .29994 m
.62406 .2787 L
s
.6611 .21486 m
.62867 .29994 L
s
0 .186 1 r
.49376 .42374 m
.48639 .41047 L
s
.49863 .40814 m
.49376 .42374 L
s
.343 0 1 r
.65951 .69868 m
.66706 .71488 L
s
.65951 .69868 m
.67681 .70303 L
s
.522 0 1 r
.67911 .40689 m
.67641 .40978 L
s
.67641 .40978 m
.66406 .39973 L
s
.67641 .40978 m
.66186 .4153 L
s
1 0 .678 r
.86984 .69855 m
.88263 .71676 L
s
.86984 .69855 m
.8917 .70031 L
s
.95204 .74229 m
.86984 .69855 L
s
1 0 .848 r
.78172 .42344 m
.79674 .40698 L
s
.522 0 1 r
.66406 .39973 m
.66667 .39676 L
s
.66406 .39973 m
.66186 .4153 L
s
1 0 .15 r
.25732 .26613 m
.26318 .26929 L
s
.26318 .26929 m
.26921 .28844 L
s
0 1 .078 r
.52385 .51933 m
.52632 .52785 L
s
.714 0 1 r
.45319 .29874 m
.44335 .28361 L
s
.45805 .27918 m
.45319 .29874 L
s
.42646 .22041 m
.45319 .29874 L
s
1 0 .462 r
.31818 .42262 m
.29486 .41831 L
s
.30625 .40253 m
.31818 .42262 L
s
.343 0 1 r
.70203 .50705 m
.70919 .50812 L
s
.70203 .50705 m
.6947 .51989 L
s
0 1 .078 r
.43427 .61251 m
.46578 .60242 L
s
0 .4 1 r
.50442 .70623 m
.49716 .70827 L
s
.49867 .69333 m
.50442 .70623 L
s
0 .186 1 r
.48639 .41047 m
.49863 .40814 L
s
1 0 .848 r
.21103 .51853 m
.20664 .51939 L
s
.21894 .50238 m
.21103 .51853 L
s
.22869 .51911 m
.21103 .51853 L
s
1 0 .304 r
.79269 .81781 m
.79332 .81574 L
s
.79332 .81574 m
.80568 .8 L
s
.79332 .81574 m
.78329 .79644 L
s
1 0 .848 r
.2146 .50311 m
.21894 .50238 L
s
.21894 .50238 m
.22869 .51911 L
s
.899 0 1 r
.6761 1.00015 m
.64766 .92094 L
s
1 0 .304 r
.80568 .8 m
.80516 .80193 L
s
.80568 .8 m
.78329 .79644 L
s
.45735 .92573 m
.47321 .93389 L
s
.44559 .93008 m
.45735 .92573 L
s
.45735 .92573 m
.46381 .9139 L
s
.899 0 1 r
.64984 .94109 m
.64234 .93954 L
s
.64234 .93954 m
.64766 .92094 L
s
0 .4 1 r
.49716 .70827 m
.48714 .70343 L
s
.48714 .70343 m
.49867 .69333 L
s
.714 0 1 r
.44335 .28361 m
.45805 .27918 L
s
.343 0 1 r
.67681 .70303 m
.66706 .71488 L
s
1 0 .462 r
.29486 .41831 m
.30625 .40253 L
s
1 0 .848 r
.62406 .2787 m
.63984 .28464 L
s
0 .4 1 r
.49867 .69333 m
.49716 .70827 L
s
1 0 .848 r
.14942 .47791 m
.22869 .51911 L
s
0 1 .939 r
.66861 .60804 m
.61981 .59947 L
s
1 0 .678 r
.8917 .70031 m
.88263 .71676 L
s
0 1 .078 r
.46203 .60711 m
.45936 .60868 L
s
.45954 .60022 m
.46203 .60711 L
s
.46578 .60242 m
.46203 .60711 L
s
.45686 .60177 m
.45954 .60022 L
s
.45954 .60022 m
.46578 .60242 L
s
.522 0 1 r
.66186 .4153 m
.67911 .40689 L
s
.66186 .4153 m
.66667 .39676 L
s
.977 0 1 r
.39153 .86643 m
.42279 .78783 L
s
.41323 .79899 m
.42772 .80669 L
s
.40525 .80056 m
.41323 .79899 L
s
.41323 .79899 m
.42279 .78783 L
s
0 1 .939 r
.62981 .60719 m
.62725 .60531 L
s
.62725 .60531 m
.62941 .59522 L
s
.62725 .60531 m
.61981 .59947 L
s
1 0 .304 r
.78329 .79644 m
.79269 .81781 L
s
.78329 .79644 m
.80516 .80193 L
s
.8632 .85883 m
.78329 .79644 L
s
.899 0 1 r
.64766 .92094 m
.64984 .94109 L
s
.64766 .92094 m
.66442 .9341 L
s
.343 0 1 r
.6947 .51989 m
.71323 .52259 L
s
.6947 .51989 m
.70919 .50812 L
s
.522 0 1 r
.60895 .80024 m
.61567 .80077 L
s
.59537 .80632 m
.60895 .80024 L
s
.60895 .80024 m
.60018 .78874 L
s
.343 0 1 r
.70919 .50812 m
.71323 .52259 L
s
1 0 .15 r
.26921 .28844 m
.24457 .28251 L
s
.25732 .26613 m
.26921 .28844 L
s
1 0 .848 r
.22869 .51911 m
.20664 .51939 L
s
.2146 .50311 m
.22869 .51911 L
s
0 1 .939 r
.62941 .59522 m
.63198 .59705 L
s
.62941 .59522 m
.61981 .59947 L
s
0 .4 1 r
.38363 .47306 m
.43266 .51085 L
s
.714 0 1 r
.90424 .60355 m
.82626 .59157 L
s
0 .4 1 r
.42056 .50863 m
.41754 .50817 L
s
.42807 .49839 m
.42056 .50863 L
s
.43266 .51085 m
.42056 .50863 L
s
.899 0 1 r
.66442 .9341 m
.64984 .94109 L
s
1 0 .304 r
.47321 .93389 m
.46152 .93832 L
s
.46381 .9139 m
.47321 .93389 L
s
.522 0 1 r
.66667 .39676 m
.67911 .40689 L
s
0 1 .078 r
.46578 .60242 m
.45936 .60868 L
s
.45686 .60177 m
.46578 .60242 L
s
.45936 .60868 m
.45686 .60177 L
s
0 .4 1 r
.42509 .49788 m
.42807 .49839 L
s
.42807 .49839 m
.43266 .51085 L
s
0 .186 1 r
.38506 .69614 m
.38425 .69685 L
s
.37592 .68616 m
.38506 .69614 L
s
.38997 .68241 m
.38506 .69614 L
s
.37504 .68681 m
.37592 .68616 L
s
.37592 .68616 m
.38997 .68241 L
s
.343 0 1 r
.55473 .38683 m
.54669 .38526 L
s
.56761 .38938 m
.55473 .38683 L
s
.55473 .38683 m
.55419 .40241 L
s
.522 0 1 r
.62672 .86264 m
.60018 .78874 L
s
.977 0 1 r
.42772 .80669 m
.41982 .80832 L
s
.42279 .78783 m
.42772 .80669 L
s
.714 0 1 r
.84292 .60363 m
.83774 .60071 L
s
.83774 .60071 m
.84097 .58439 L
s
.83774 .60071 m
.82626 .59157 L
s
.522 0 1 r
.60202 .80689 m
.59537 .80632 L
s
.59537 .80632 m
.60018 .78874 L
s
1 0 .848 r
.51361 .25684 m
.50126 .25689 L
s
.52721 .25836 m
.51361 .25684 L
s
.51361 .25684 m
.51318 .27594 L
s
1 0 .15 r
.24457 .28251 m
.25732 .26613 L
s
.15908 .39363 m
.15219 .39216 L
s
.17062 .37652 m
.15908 .39363 L
s
.17763 .39612 m
.15908 .39363 L
s
0 1 .939 r
.61981 .59947 m
.62981 .60719 L
s
.61981 .59947 m
.63198 .59705 L
s
1 0 .848 r
.20664 .51939 m
.2146 .50311 L
s
.714 0 1 r
.84097 .58439 m
.84618 .58719 L
s
.84097 .58439 m
.82626 .59157 L
s
1 0 .15 r
.09708 .33734 m
.17763 .39612 L
s
0 1 .939 r
.61912 .46819 m
.58718 .50772 L
s
.59835 .50236 m
.59695 .50383 L
s
.59695 .50383 m
.58884 .49724 L
s
.59695 .50383 m
.58718 .50772 L
s
.58884 .49724 m
.5902 .49574 L
s
.58884 .49724 m
.58718 .50772 L
s
.63198 .59705 m
.62981 .60719 L
s
1 0 .15 r
.16383 .37489 m
.17062 .37652 L
s
.17062 .37652 m
.17763 .39612 L
s
1 0 .304 r
.46152 .93832 m
.44559 .93008 L
s
.44559 .93008 m
.46381 .9139 L
s
.80516 .80193 m
.79269 .81781 L
s
0 .186 1 r
.34045 .7278 m
.38997 .68241 L
s
.38997 .68241 m
.38425 .69685 L
s
.37504 .68681 m
.38997 .68241 L
s
.977 0 1 r
.7485 .69345 m
.74822 .69139 L
s
.74822 .69139 m
.75699 .67607 L
s
.74822 .69139 m
.73736 .67607 L
s
.37392 .39043 m
.37164 .38788 L
s
.38697 .37845 m
.37392 .39043 L
s
.3911 .39596 m
.37392 .39043 L
s
.38478 .37581 m
.38697 .37845 L
s
.38697 .37845 m
.3911 .39596 L
s
0 .4 1 r
.43266 .51085 m
.41754 .50817 L
s
.42509 .49788 m
.43266 .51085 L
s
.522 0 1 r
.60018 .78874 m
.60202 .80689 L
s
.60018 .78874 m
.61567 .80077 L
s
1 0 .304 r
.46381 .9139 m
.46152 .93832 L
s
0 .186 1 r
.34281 .59582 m
.34249 .59799 L
s
.34341 .58241 m
.34281 .59582 L
s
.35646 .59082 m
.34281 .59582 L
s
.343 0 1 r
.55961 .38782 m
.56761 .38938 L
s
.56761 .38938 m
.55419 .40241 L
s
.977 0 1 r
.42279 .78783 m
.41982 .80832 L
s
.40525 .80056 m
.42279 .78783 L
s
.75699 .67607 m
.75733 .67801 L
s
.75699 .67607 m
.73736 .67607 L
s
.343 0 1 r
.55419 .40241 m
.55961 .38782 L
s
.55419 .40241 m
.54669 .38526 L
s
.56909 .32679 m
.55419 .40241 L
s
0 1 .939 r
.56525 .683 m
.56945 .68284 L
s
.55629 .68677 m
.56525 .683 L
s
.56525 .683 m
.55937 .67509 L
s
.977 0 1 r
.33244 .33208 m
.3911 .39596 L
s
.543 0 1 r
.85591 .46329 m
.7875 .49002 L
s
0 .186 1 r
.3431 .58451 m
.34341 .58241 L
s
.34341 .58241 m
.35646 .59082 L
s
.522 0 1 r
.61567 .80077 m
.60202 .80689 L
s
.977 0 1 r
.41982 .80832 m
.40525 .80056 L
s
1 0 .848 r
.51318 .27594 m
.51487 .25843 L
s
.51318 .27594 m
.50126 .25689 L
s
.52721 .25836 m
.51318 .27594 L
s
.5185 .18382 m
.51318 .27594 L
s
0 .4 1 r
.41754 .50817 m
.42509 .49788 L
s
0 1 .939 r
.58718 .50772 m
.59835 .50236 L
s
.58718 .50772 m
.5902 .49574 L
s
1 0 .678 r
.72183 .24687 m
.71619 .24398 L
s
.73845 .25373 m
.72183 .24687 L
s
.72183 .24687 m
.71982 .26645 L
s
.714 0 1 r
.29552 .79941 m
.29525 .7996 L
s
.28275 .78847 m
.29552 .79941 L
s
.29997 .78124 m
.29552 .79941 L
s
.28238 .78858 m
.28275 .78847 L
s
.28275 .78847 m
.29997 .78124 L
s
.543 0 1 r
.25284 .6875 m
.2568 .68979 L
s
.24769 .6725 m
.25284 .6875 L
s
.2671 .67536 m
.25284 .6875 L
s
0 1 .939 r
.57679 .72361 m
.55937 .67509 L
s
.343 0 1 r
.54669 .38526 m
.55961 .38782 L
s
1 0 .848 r
.51487 .25843 m
.52721 .25836 L
s
0 .186 1 r
.38425 .69685 m
.37504 .68681 L
s
1 0 .678 r
.72937 .91274 m
.73039 .91427 L
s
.71504 .92522 m
.72937 .91274 L
s
.72937 .91274 m
.71023 .90534 L
s
0 1 .939 r
.56046 .68663 m
.55629 .68677 L
s
.55629 .68677 m
.55937 .67509 L
s
1 0 .678 r
.71593 .92684 m
.71504 .92522 L
s
.71504 .92522 m
.71023 .90534 L
s
.714 0 1 r
.82626 .59157 m
.84292 .60363 L
s
.82626 .59157 m
.84618 .58719 L
s
1 0 .678 r
.32167 .91204 m
.33714 .92084 L
s
.3129 .91435 m
.32167 .91204 L
s
.32167 .91204 m
.33213 .90074 L
s
0 1 .939 r
.5902 .49574 m
.59835 .50236 L
s
0 .186 1 r
.35646 .59082 m
.34249 .59799 L
s
.3431 .58451 m
.35646 .59082 L
s
.2888 .58764 m
.35646 .59082 L
s
1 0 .848 r
.50126 .25689 m
.51487 .25843 L
s
.977 0 1 r
.73736 .67607 m
.7485 .69345 L
s
.73736 .67607 m
.75733 .67801 L
s
.81445 .7194 m
.73736 .67607 L
s
.543 0 1 r
.25162 .67471 m
.24769 .6725 L
s
.24769 .6725 m
.2671 .67536 L
s
1 0 .678 r
.29691 .98465 m
.33213 .90074 L
s
.543 0 1 r
.2671 .67536 m
.2568 .68979 L
s
.25162 .67471 m
.2671 .67536 L
s
.19212 .70446 m
.2671 .67536 L
s
1 0 .15 r
.17763 .39612 m
.15219 .39216 L
s
.16383 .37489 m
.17763 .39612 L
s
.977 0 1 r
.3911 .39596 m
.37164 .38788 L
s
.38478 .37581 m
.3911 .39596 L
s
0 1 .939 r
.55937 .67509 m
.56046 .68663 L
s
.55937 .67509 m
.56945 .68284 L
s
.714 0 1 r
.84618 .58719 m
.84292 .60363 L
s
1 0 .678 r
.33792 .24143 m
.3235 .25385 L
s
.33563 .2373 m
.33792 .24143 L
s
.33792 .24143 m
.34179 .25967 L
s
.3235 .25385 m
.32109 .24982 L
s
.34179 .25967 m
.3235 .25385 L
s
.73293 .25088 m
.73845 .25373 L
s
.73845 .25373 m
.71982 .26645 L
s
.714 0 1 r
.29997 .78124 m
.29525 .7996 L
s
.28238 .78858 m
.29997 .78124 L
s
.2448 .84533 m
.29997 .78124 L
s
0 1 .939 r
.56945 .68284 m
.56046 .68663 L
s
.543 0 1 r
.80731 .49281 m
.79967 .49182 L
s
.79967 .49182 m
.79533 .47648 L
s
.79967 .49182 m
.7875 .49002 L
s
1 0 .678 r
.33714 .92084 m
.32847 .92322 L
s
.33213 .90074 m
.33714 .92084 L
s
0 .186 1 r
.34249 .59799 m
.3431 .58451 L
s
1 0 .678 r
.71982 .26645 m
.73293 .25088 L
s
.71982 .26645 m
.71619 .24398 L
s
.75764 .17807 m
.71982 .26645 L
s
.71023 .90534 m
.71593 .92684 L
s
.71023 .90534 m
.73039 .91427 L
s
.77264 .97764 m
.71023 .90534 L
s
.714 0 1 r
.77271 .37522 m
.76946 .37817 L
s
.76946 .37817 m
.75667 .36714 L
s
.76946 .37817 m
.75402 .38365 L
s
.75667 .36714 m
.75982 .36412 L
s
.75667 .36714 m
.75402 .38365 L
s
1 0 .678 r
.28067 .18953 m
.34179 .25967 L
s
1 0 .848 r
.53411 .98115 m
.53962 .89421 L
s
.714 0 1 r
.80705 .32147 m
.75402 .38365 L
s
.543 0 1 r
.79533 .47648 m
.80294 .47738 L
s
.79533 .47648 m
.7875 .49002 L
s
1 0 .15 r
.15219 .39216 m
.16383 .37489 L
s
1 0 .848 r
.53774 .90724 m
.5516 .91221 L
s
.52542 .91121 m
.53774 .90724 L
s
.53774 .90724 m
.53962 .89421 L
s
.977 0 1 r
.75733 .67801 m
.7485 .69345 L
s
.37164 .38788 m
.38478 .37581 L
s
.29546 .48814 m
.29217 .48861 L
s
.30394 .47253 m
.29546 .48814 L
s
.31347 .48921 m
.29546 .48814 L
s
1 0 .15 r
.88846 .7933 m
.88871 .79113 L
s
.88871 .79113 m
.90109 .77425 L
s
.88871 .79113 m
.87762 .77136 L
s
1 0 0 r
.01 w
.52632 .58304 Mdot
.977 0 1 r
.5 Mabswid
.66796 .79101 m
.66795 .79042 L
s
.66795 .79042 m
.68112 .77835 L
s
.66795 .79042 m
.66252 .77149 L
s
.68112 .77835 m
.68124 .77884 L
s
.68112 .77835 m
.66252 .77149 L
s
.30071 .47289 m
.30394 .47253 L
s
.30394 .47253 m
.31347 .48921 L
s
1 0 .15 r
.90109 .77425 m
.90096 .77627 L
s
.90109 .77425 m
.87762 .77136 L
s
0 .186 1 r
.71174 .58368 m
.70986 .58157 L
s
.70986 .58157 m
.7108 .56803 L
s
.70986 .58157 m
.69777 .57519 L
s
.543 0 1 r
.2568 .68979 m
.25162 .67471 L
s
0 1 .939 r
.4921 .47924 m
.48295 .48268 L
s
.49602 .47821 m
.4921 .47924 L
s
.4921 .47924 m
.49302 .49032 L
s
.714 0 1 r
.29525 .7996 m
.28238 .78858 L
s
1 0 .678 r
.34179 .25967 m
.32109 .24982 L
s
.33563 .2373 m
.34179 .25967 L
s
.33213 .90074 m
.32847 .92322 L
s
.3129 .91435 m
.33213 .90074 L
s
0 .186 1 r
.7108 .56803 m
.71268 .57006 L
s
.7108 .56803 m
.69777 .57519 L
s
.343 0 1 r
.49289 .77898 m
.50572 .78298 L
s
.48438 .77969 m
.49289 .77898 L
s
.49289 .77898 m
.49804 .76627 L
s
1 0 .678 r
.71619 .24398 m
.73293 .25088 L
s
.714 0 1 r
.20485 .57887 m
.20548 .58166 L
s
.20748 .5623 m
.20485 .57887 L
s
.22327 .57442 m
.20485 .57887 L
s
0 1 .939 r
.48295 .48268 m
.48683 .48166 L
s
.49302 .49032 m
.48295 .48268 L
s
.977 0 1 r
.23658 .44592 m
.31347 .48921 L
s
0 .186 1 r
.76515 .57841 m
.69777 .57519 L
s
.714 0 1 r
.75402 .38365 m
.77271 .37522 L
s
.75402 .38365 m
.75982 .36412 L
s
1 0 .678 r
.32847 .92322 m
.3129 .91435 L
s
.73039 .91427 m
.71593 .92684 L
s
.714 0 1 r
.20813 .56498 m
.20748 .5623 L
s
.20748 .5623 m
.22327 .57442 L
s
0 1 .939 r
.49302 .49032 m
.48683 .48166 L
s
.49602 .47821 m
.49302 .49032 L
s
.47527 .4409 m
.49302 .49032 L
s
.977 0 1 r
.66252 .77149 m
.66796 .79101 L
s
.66252 .77149 m
.68124 .77884 L
s
.7229 .8375 m
.66252 .77149 L
s
.63361 .35607 m
.62709 .35445 L
s
.649 .36262 m
.63361 .35607 L
s
.63361 .35607 m
.6314 .37515 L
s
1 0 .15 r
.87762 .77136 m
.88846 .7933 L
s
.87762 .77136 m
.90096 .77627 L
s
.96396 .83355 m
.87762 .77136 L
s
.543 0 1 r
.7875 .49002 m
.80731 .49281 L
s
.7875 .49002 m
.80294 .47738 L
s
.522 0 1 r
.44999 .35735 m
.43574 .36234 L
s
.45578 .35494 m
.44999 .35735 L
s
.44999 .35735 m
.45124 .37397 L
s
.343 0 1 r
.48319 .84143 m
.49804 .76627 L
s
.543 0 1 r
.80294 .47738 m
.80731 .49281 L
s
.977 0 1 r
.31347 .48921 m
.29217 .48861 L
s
.30071 .47289 m
.31347 .48921 L
s
1 0 .304 r
.59168 .22464 m
.58069 .22381 L
s
.60849 .22978 m
.59168 .22464 L
s
.59168 .22464 m
.58984 .24679 L
s
1 0 .848 r
.5516 .91221 m
.53929 .91624 L
s
.53962 .89421 m
.5516 .91221 L
s
0 1 .939 r
.46183 .67116 m
.46262 .67045 L
s
.45359 .66448 m
.46183 .67116 L
s
.46468 .65932 m
.46183 .67116 L
s
0 .186 1 r
.69777 .57519 m
.71174 .58368 L
s
.69777 .57519 m
.71268 .57006 L
s
0 1 .939 r
.45435 .66374 m
.45359 .66448 L
s
.45359 .66448 m
.46468 .65932 L
s
.714 0 1 r
.22327 .57442 m
.20548 .58166 L
s
.20813 .56498 m
.22327 .57442 L
s
.13884 .56201 m
.22327 .57442 L
s
1 0 .678 r
.32109 .24982 m
.33563 .2373 L
s
0 1 .939 r
.48683 .48166 m
.49602 .47821 L
s
0 .186 1 r
.68016 .47755 m
.6792 .47816 L
s
.6792 .47816 m
.6699 .46802 L
s
.6792 .47816 m
.66494 .482 L
s
.6699 .46802 m
.67081 .46735 L
s
.6699 .46802 m
.66494 .482 L
s
1 0 .848 r
.53929 .91624 m
.52542 .91121 L
s
.52542 .91121 m
.53962 .89421 L
s
.343 0 1 r
.50572 .78298 m
.49725 .78372 L
s
.49804 .76627 m
.50572 .78298 L
s
.714 0 1 r
.75982 .36412 m
.77271 .37522 L
s
0 .4 1 r
.62685 .66965 m
.62875 .66922 L
s
.62875 .66922 m
.63652 .6589 L
s
.62875 .66922 m
.62151 .65641 L
s
0 1 .939 r
.46468 .65932 m
.46262 .67045 L
s
.45435 .66374 m
.46468 .65932 L
s
.43169 .70014 m
.46468 .65932 L
s
0 .4 1 r
.63652 .6589 m
.63466 .65928 L
s
.63652 .6589 m
.62151 .65641 L
s
1 0 .848 r
.53962 .89421 m
.53929 .91624 L
s
.977 0 1 r
.64257 .36104 m
.649 .36262 L
s
.649 .36262 m
.6314 .37515 L
s
.522 0 1 r
.43574 .36234 m
.44144 .35995 L
s
.45124 .37397 m
.43574 .36234 L
s
0 .186 1 r
.71268 .57006 m
.71174 .58368 L
s
.343 0 1 r
.49804 .76627 m
.49725 .78372 L
s
.48438 .77969 m
.49804 .76627 L
s
.977 0 1 r
.29217 .48861 m
.30071 .47289 L
s
.6314 .37515 m
.64257 .36104 L
s
.6314 .37515 m
.62709 .35445 L
s
.66489 .29168 m
.6314 .37515 L
s
1 0 .304 r
.2432 .36079 m
.23758 .3588 L
s
.25542 .34429 m
.2432 .36079 L
s
.26231 .3638 m
.2432 .36079 L
s
.343 0 1 r
.49725 .78372 m
.48438 .77969 L
s
1 0 .304 r
.58984 .24679 m
.59757 .22898 L
s
.58984 .24679 m
.58069 .22381 L
s
.60849 .22978 m
.58984 .24679 L
s
.61391 .14589 m
.58984 .24679 L
s
.522 0 1 r
.45124 .37397 m
.44144 .35995 L
s
.45578 .35494 m
.45124 .37397 L
s
.42366 .29717 m
.45124 .37397 L
s
0 .4 1 r
.62151 .65641 m
.62685 .66965 L
s
.62151 .65641 m
.63466 .65928 L
s
.67261 .6958 m
.62151 .65641 L
s
.977 0 1 r
.68124 .77884 m
.66796 .79101 L
s
1 0 .304 r
.18378 .30262 m
.26231 .3638 L
s
0 .186 1 r
.66494 .482 m
.68016 .47755 L
s
.66494 .482 m
.67081 .46735 L
s
.7153 .43585 m
.66494 .482 L
s
1 0 .304 r
.24991 .34214 m
.25542 .34429 L
s
.25542 .34429 m
.26231 .3638 L
s
0 1 .939 r
.41885 .56879 m
.42051 .57054 L
s
.42093 .55845 m
.41885 .56879 L
s
.43094 .56628 m
.41885 .56879 L
s
1 0 .304 r
.59757 .22898 m
.60849 .22978 L
s
1 0 .848 r
.84433 .66649 m
.84364 .66441 L
s
.84364 .66441 m
.85236 .64795 L
s
.84364 .66441 m
.83176 .64865 L
s
1 0 .15 r
.90096 .77627 m
.88846 .7933 L
s
.899 0 1 r
.40053 .21846 m
.38486 .22347 L
s
.40648 .21482 m
.40053 .21846 L
s
.40053 .21846 m
.40167 .23593 L
s
0 1 .939 r
.4226 .56015 m
.42093 .55845 L
s
.42093 .55845 m
.43094 .56628 L
s
.46262 .67045 m
.45435 .66374 L
s
1 0 .15 r
.79932 .90855 m
.80036 .9059 L
s
.80036 .9059 m
.81385 .88974 L
s
.80036 .9059 m
.79019 .8854 L
s
.714 0 1 r
.20548 .58166 m
.20813 .56498 L
s
1 0 .848 r
.85236 .64795 m
.85311 .6499 L
s
.85236 .64795 m
.83176 .64865 L
s
0 1 .939 r
.43094 .56628 m
.42051 .57054 L
s
.4226 .56015 m
.43094 .56628 L
s
.37961 .55726 m
.43094 .56628 L
s
1 0 .15 r
.81385 .88974 m
.81293 .89225 L
s
.81385 .88974 m
.79019 .8854 L
s
.522 0 1 r
.44144 .35995 m
.45578 .35494 L
s
.977 0 1 r
.62709 .35445 m
.64257 .36104 L
s
0 .186 1 r
.67081 .46735 m
.68016 .47755 L
s
0 1 .078 r
.59504 .56535 m
.59738 .56388 L
s
.59738 .56388 m
.59485 .55679 L
s
.59738 .56388 m
.58829 .5632 L
s
0 .4 1 r
.63466 .65928 m
.62685 .66965 L
s
0 1 .078 r
.59485 .55679 m
.59251 .55825 L
s
.59485 .55679 m
.58829 .5632 L
s
.522 0 1 r
.38264 .77372 m
.38331 .77336 L
s
.36987 .76339 m
.38264 .77372 L
s
.38686 .75562 m
.38264 .77372 L
s
0 1 .078 r
.58829 .5632 m
.59504 .56535 L
s
.58829 .5632 m
.59251 .55825 L
s
.62174 .55249 m
.58829 .5632 L
s
.522 0 1 r
.37045 .76296 m
.36987 .76339 L
s
.36987 .76339 m
.38686 .75562 L
s
1 0 .304 r
.58069 .22381 m
.59757 .22898 L
s
.343 0 1 r
.33907 .65975 m
.34412 .66184 L
s
.33434 .64513 m
.33907 .65975 L
s
.35334 .64791 m
.33907 .65975 L
s
.899 0 1 r
.38486 .22347 m
.39071 .21986 L
s
.40167 .23593 m
.38486 .22347 L
s
1 0 .848 r
.40987 .88912 m
.42544 .89711 L
s
.40154 .891 m
.40987 .88912 L
s
.40987 .88912 m
.42 .8771 L
s
0 1 .939 r
.42051 .57054 m
.4226 .56015 L
s
1 0 .848 r
.83176 .64865 m
.84433 .66649 L
s
.83176 .64865 m
.85311 .6499 L
s
.91488 .69143 m
.83176 .64865 L
s
1 0 .15 r
.79019 .8854 m
.79932 .90855 L
s
.79019 .8854 m
.81293 .89225 L
s
.87273 .95429 m
.79019 .8854 L
s
.714 0 1 r
.6115 .89045 m
.61856 .89119 L
s
.5968 .89677 m
.6115 .89045 L
s
.6115 .89045 m
.60217 .87797 L
s
0 .4 1 r
.55626 .45444 m
.54901 .45534 L
s
.56677 .45871 m
.55626 .45444 L
s
.55626 .45444 m
.55483 .46929 L
s
.343 0 1 r
.33937 .64712 m
.33434 .64513 L
s
.33434 .64513 m
.35334 .64791 L
s
.35334 .64791 m
.34412 .66184 L
s
.33937 .64712 m
.35334 .64791 L
s
.28205 .67594 m
.35334 .64791 L
s
.899 0 1 r
.40167 .23593 m
.39071 .21986 L
s
.40648 .21482 m
.40167 .23593 L
s
.37146 .15181 m
.40167 .23593 L
s
1 0 .304 r
.26231 .3638 m
.23758 .3588 L
s
.24991 .34214 m
.26231 .3638 L
s
1 0 .848 r
.38774 .96157 m
.42 .8771 L
s
1 0 .678 r
.15051 .46242 m
.14606 .46291 L
s
.15923 .44528 m
.15051 .46242 L
s
.16961 .4631 m
.15051 .46242 L
s
.522 0 1 r
.38686 .75562 m
.38331 .77336 L
s
.37045 .76296 m
.38686 .75562 L
s
.33519 .81956 m
.38686 .75562 L
s
0 1 .078 r
.59251 .55825 m
.59504 .56535 L
s
1 0 .462 r
.75115 .77055 m
.75302 .76899 L
s
.75302 .76899 m
.76521 .75307 L
s
.75302 .76899 m
.74221 .74944 L
s
1 0 .678 r
.15485 .44562 m
.15923 .44528 L
s
.15923 .44528 m
.16961 .4631 L
s
0 .4 1 r
.55483 .46929 m
.55956 .45964 L
s
.55483 .46929 m
.54901 .45534 L
s
.56677 .45871 m
.55483 .46929 L
s
.5703 .40755 m
.55483 .46929 L
s
0 .186 1 r
.56752 .76111 m
.5725 .75937 L
s
.55501 .76433 m
.56752 .76111 L
s
.56752 .76111 m
.56013 .74849 L
s
1 0 .848 r
.42544 .89711 m
.41721 .89905 L
s
.42 .8771 m
.42544 .89711 L
s
1 0 .462 r
.76521 .75307 m
.76345 .75449 L
s
.76521 .75307 m
.74221 .74944 L
s
.343 0 1 r
.37097 .45919 m
.37053 .45893 L
s
.38103 .44695 m
.37097 .45919 L
s
.38799 .46294 m
.37097 .45919 L
s
.38066 .4466 m
.38103 .44695 L
s
.38103 .44695 m
.38799 .46294 L
s
.714 0 1 r
.60378 .89755 m
.5968 .89677 L
s
.5968 .89677 m
.60217 .87797 L
s
0 .4 1 r
.55956 .45964 m
.56677 .45871 L
s
.899 0 1 r
.39071 .21986 m
.40648 .21482 L
s
.977 0 1 r
.51332 .33178 m
.50103 .33279 L
s
.52678 .33419 m
.51332 .33178 L
s
.51332 .33178 m
.51283 .35145 L
s
1 0 .304 r
.23758 .3588 m
.24991 .34214 L
s
.714 0 1 r
.62955 .95794 m
.60217 .87797 L
s
1 0 .848 r
.85311 .6499 m
.84433 .66649 L
s
.24636 .7653 m
.2532 .76742 L
s
.23809 .74917 m
.24636 .7653 L
s
.26115 .74874 m
.24636 .7653 L
s
0 .186 1 r
.55993 .76261 m
.55501 .76433 L
s
.55501 .76433 m
.56013 .74849 L
s
0 .4 1 r
.54901 .45534 m
.55956 .45964 L
s
1 0 .678 r
.08496 .41794 m
.16961 .4631 L
s
.04 0 1 r
.8077 .5545 m
.80544 .55243 L
s
.80544 .55243 m
.80617 .5378 L
s
.80544 .55243 m
.79234 .54574 L
s
.343 0 1 r
.34412 .66184 m
.33937 .64712 L
s
0 1 .078 r
.52632 .64026 m
.52887 .64914 L
s
.52375 .64376 m
.52632 .64026 L
s
.52632 .64026 m
.52159 .64791 L
s
.53105 .64499 m
.52632 .64026 L
s
.52632 .67145 m
.52632 .64026 L
s
1 0 .462 r
.74221 .74944 m
.75115 .77055 L
s
.74221 .74944 m
.76345 .75449 L
s
.82264 .81144 m
.74221 .74944 L
s
.714 0 1 r
.60217 .87797 m
.60378 .89755 L
s
.60217 .87797 m
.61856 .89119 L
s
0 1 .078 r
.52887 .64914 m
.53105 .64499 L
s
.52159 .64791 m
.52887 .64914 L
s
1 0 .15 r
.81293 .89225 m
.79932 .90855 L
s
.522 0 1 r
.38331 .77336 m
.37045 .76296 L
s
1 0 .848 r
.26115 .74874 m
.2532 .76742 L
s
.23809 .74917 m
.26115 .74874 L
s
.24488 .75117 m
.26115 .74874 L
s
.18252 .797 m
.26115 .74874 L
s
1 0 .678 r
.16961 .4631 m
.14606 .46291 L
s
.15485 .44562 m
.16961 .4631 L
s
.343 0 1 r
.38799 .46294 m
.37053 .45893 L
s
.38066 .4466 m
.38799 .46294 L
s
.32695 .41276 m
.38799 .46294 L
s
0 .186 1 r
.56013 .74849 m
.55993 .76261 L
s
.56013 .74849 m
.5725 .75937 L
s
.57823 .81551 m
.56013 .74849 L
s
1 0 .848 r
.42 .8771 m
.41721 .89905 L
s
.40154 .891 m
.42 .8771 L
s
.04 0 1 r
.80617 .5378 m
.80845 .53978 L
s
.80617 .5378 m
.79234 .54574 L
s
0 1 .078 r
.52375 .64376 m
.52159 .64791 L
s
1 0 .848 r
.24488 .75117 m
.23809 .74917 L
s
.977 0 1 r
.51283 .35145 m
.51451 .33522 L
s
.51283 .35145 m
.50103 .33279 L
s
.52678 .33419 m
.51283 .35145 L
s
.51827 .26096 m
.51283 .35145 L
s
.714 0 1 r
.61856 .89119 m
.60378 .89755 L
s
.522 0 1 r
.29098 .54891 m
.29267 .5515 L
s
.2941 .53278 m
.29098 .54891 L
s
.30953 .54495 m
.29098 .54891 L
s
1 0 .848 r
.41721 .89905 m
.40154 .891 L
s
.343 0 1 r
.71018 .6473 m
.71342 .64578 L
s
.71342 .64578 m
.71993 .6315 L
s
.71342 .64578 m
.70095 .63254 L
s
.899 0 1 r
.28948 .89021 m
.28948 .89073 L
s
.27551 .87893 m
.28948 .89021 L
s
.29383 .87075 m
.28948 .89021 L
s
.04 0 1 r
.86524 .54769 m
.79234 .54574 L
s
.899 0 1 r
.2754 .87936 m
.27551 .87893 L
s
.27551 .87893 m
.29383 .87075 L
s
0 1 .078 r
.53105 .64499 m
.52375 .64376 L
s
.522 0 1 r
.29582 .53526 m
.2941 .53278 L
s
.2941 .53278 m
.30953 .54495 L
s
1 0 .848 r
.72757 .32195 m
.72179 .32015 L
s
.7439 .32948 m
.72757 .32195 L
s
.72757 .32195 m
.72508 .34208 L
s
0 .186 1 r
.5725 .75937 m
.55993 .76261 L
s
1 0 .678 r
.4635 .19116 m
.44964 .19154 L
s
.4774 .19244 m
.4635 .19116 L
s
.4635 .19116 m
.463 .21162 L
s
.977 0 1 r
.51451 .33522 m
.52678 .33419 L
s
1 0 .15 r
.68488 .18826 m
.6746 .18706 L
s
.70293 .19426 m
.68488 .18826 L
s
.68488 .18826 m
.68283 .21144 L
s
.343 0 1 r
.71993 .6315 m
.71673 .63292 L
s
.71993 .6315 m
.70095 .63254 L
s
0 1 .078 r
.4924 .54603 m
.48867 .54632 L
s
.48877 .53772 m
.4924 .54603 L
s
.4924 .54603 m
.48401 .54357 L
s
.49344 .54046 m
.4924 .54603 L
s
.47381 .52575 m
.4924 .54603 L
s
.04 0 1 r
.79234 .54574 m
.8077 .5545 L
s
.79234 .54574 m
.80845 .53978 L
s
.977 0 1 r
.50103 .33279 m
.51451 .33522 L
s
1 0 .848 r
.1981 .64298 m
.20427 .64644 L
s
.19555 .62475 m
.1981 .64298 L
s
.21765 .63179 m
.1981 .64298 L
s
.522 0 1 r
.30953 .54495 m
.29267 .5515 L
s
.29582 .53526 m
.30953 .54495 L
s
.22829 .53067 m
.30953 .54495 L
s
1 0 .678 r
.14606 .46291 m
.15485 .44562 L
s
.04 0 1 r
.776 .44641 m
.77463 .44702 L
s
.77463 .44702 m
.76489 .43583 L
s
.77463 .44702 m
.75929 .45079 L
s
.76489 .43583 m
.76621 .43515 L
s
.76489 .43583 m
.75929 .45079 L
s
0 1 .078 r
.48877 .53772 m
.48401 .54357 L
s
.49344 .54046 m
.48877 .53772 L
s
.343 0 1 r
.37053 .45893 m
.38066 .4466 L
s
.70095 .63254 m
.71018 .6473 L
s
.70095 .63254 m
.71673 .63292 L
s
.77198 .66695 m
.70095 .63254 L
s
0 1 .078 r
.48401 .54357 m
.48867 .54632 L
s
1 0 .848 r
.21765 .63179 m
.20427 .64644 L
s
.19555 .62475 m
.21765 .63179 L
s
.20171 .62808 m
.21765 .63179 L
s
.12765 .65096 m
.21765 .63179 L
s
1 0 .462 r
.76345 .75449 m
.75115 .77055 L
s
.899 0 1 r
.29383 .87075 m
.28948 .89073 L
s
.2754 .87936 m
.29383 .87075 L
s
.23676 .94137 m
.29383 .87075 L
s
1 0 .848 r
.33214 .31674 m
.31814 .32949 L
s
.33017 .31366 m
.33214 .31674 L
s
.33214 .31674 m
.33676 .33538 L
s
.31814 .32949 m
.31605 .32651 L
s
.33676 .33538 m
.31814 .32949 L
s
.73823 .32773 m
.7439 .32948 L
s
.7439 .32948 m
.72508 .34208 L
s
.20171 .62808 m
.19555 .62475 L
s
.04 0 1 r
.80845 .53978 m
.8077 .5545 L
s
1 0 .848 r
.2532 .76742 m
.24488 .75117 L
s
.72508 .34208 m
.73823 .32773 L
s
.72508 .34208 m
.72179 .32015 L
s
.76427 .25527 m
.72508 .34208 L
s
0 1 .078 r
.48867 .54632 m
.49344 .54046 L
s
1 0 .678 r
.463 .21162 m
.46355 .19283 L
s
.463 .21162 m
.44964 .19154 L
s
.4774 .19244 m
.463 .21162 L
s
.46565 .11269 m
.463 .21162 L
s
1 0 .15 r
.68283 .21144 m
.69274 .1931 L
s
.68283 .21144 m
.6746 .18706 L
s
.70293 .19426 m
.68283 .21144 L
s
.71291 .10654 m
.68283 .21144 L
s
.04 0 1 r
.75929 .45079 m
.776 .44641 L
s
.75929 .45079 m
.76621 .43515 L
s
.81504 .40231 m
.75929 .45079 L
s
0 .802 1 r
.67841 .54109 m
.68166 .53891 L
s
.68166 .53891 m
.67775 .52783 L
s
.68166 .53891 m
.66752 .53783 L
s
1 0 .15 r
.69274 .1931 m
.70293 .19426 L
s
0 .802 1 r
.67775 .52783 m
.67449 .52997 L
s
.67775 .52783 m
.66752 .53783 L
s
1 0 .848 r
.27368 .26662 m
.33676 .33538 L
s
0 .802 1 r
.66752 .53783 m
.67841 .54109 L
s
.66752 .53783 m
.67449 .52997 L
s
.72074 .52079 m
.66752 .53783 L
s
1 0 0 r
.89786 .88501 m
.89851 .88221 L
s
.89851 .88221 m
.91204 .86487 L
s
.89851 .88221 m
.88721 .86121 L
s
1 0 .678 r
.46355 .19283 m
.4774 .19244 L
s
1 0 .848 r
.67129 .88252 m
.6716 .88154 L
s
.6716 .88154 m
.68597 .86911 L
s
.6716 .88154 m
.66624 .86133 L
s
.522 0 1 r
.29267 .5515 m
.29582 .53526 L
s
.343 0 1 r
.71673 .63292 m
.71018 .6473 L
s
1 0 .848 r
.68597 .86911 m
.68578 .86999 L
s
.68597 .86911 m
.66624 .86133 L
s
1 0 .678 r
.44964 .19154 m
.46355 .19283 L
s
1 0 0 r
.91204 .86487 m
.91152 .86751 L
s
.91204 .86487 m
.88721 .86121 L
s
0 .186 1 r
.4614 .74963 m
.46362 .74746 L
s
.4493 .74248 m
.4614 .74963 L
s
.46325 .7331 m
.4614 .74963 L
s
.45145 .74026 m
.4493 .74248 L
s
.4493 .74248 m
.46325 .7331 L
s
0 .4 1 r
.4162 .63341 m
.42361 .63544 L
s
.41348 .62105 m
.4162 .63341 L
s
.42917 .62378 m
.4162 .63341 L
s
.42917 .62378 m
.42361 .63544 L
s
.41348 .62105 m
.42917 .62378 L
s
.42089 .62302 m
.42917 .62378 L
s
.37536 .64634 m
.42917 .62378 L
s
1 0 .848 r
.33676 .33538 m
.31605 .32651 L
s
.33017 .31366 m
.33676 .33538 L
s
.343 0 1 r
.63771 .4241 m
.63099 .42513 L
s
.65056 .43216 m
.63771 .4241 L
s
.63771 .4241 m
.63385 .44241 L
s
.543 0 1 r
.49178 .87005 m
.50565 .87425 L
s
.48272 .87093 m
.49178 .87005 L
s
.49178 .87005 m
.49727 .8563 L
s
.899 0 1 r
.28948 .89073 m
.2754 .87936 L
s
1 0 .848 r
.72179 .32015 m
.73823 .32773 L
s
0 .186 1 r
.44668 .42543 m
.43513 .43182 L
s
.45244 .42567 m
.44668 .42543 L
s
.44668 .42543 m
.44949 .44125 L
s
.343 0 1 r
.62651 .74712 m
.63062 .74766 L
s
.63062 .74766 m
.64198 .7366 L
s
.63062 .74766 m
.62373 .73027 L
s
.04 0 1 r
.76621 .43515 m
.776 .44641 L
s
0 .186 1 r
.46325 .7331 m
.46362 .74746 L
s
.45145 .74026 m
.46325 .7331 L
s
.42896 .79282 m
.46325 .7331 L
s
1 0 .848 r
.20427 .64644 m
.20171 .62808 L
s
1 0 .15 r
.6746 .18706 m
.69274 .1931 L
s
0 .4 1 r
.42089 .62302 m
.41348 .62105 L
s
.343 0 1 r
.64198 .7366 m
.63795 .73598 L
s
.64198 .7366 m
.62373 .73027 L
s
0 1 .939 r
.58945 .62074 m
.59161 .63084 L
s
.60113 .61892 m
.58945 .62074 L
s
.58945 .62074 m
.59286 .62096 L
s
.59987 .62878 m
.58945 .62074 L
s
.62452 .64169 m
.58945 .62074 L
s
.343 0 1 r
.63385 .44241 m
.6439 .43325 L
s
.63385 .44241 m
.63099 .42513 L
s
.65056 .43216 m
.63385 .44241 L
s
.6689 .37295 m
.63385 .44241 L
s
1 0 .848 r
.66624 .86133 m
.67129 .88252 L
s
.66624 .86133 m
.68578 .86999 L
s
.72855 .93386 m
.66624 .86133 L
s
1 0 0 r
.88721 .86121 m
.89786 .88501 L
s
.88721 .86121 m
.91152 .86751 L
s
.97657 .93008 m
.88721 .86121 L
s
0 .802 1 r
.67449 .52997 m
.67841 .54109 L
s
.343 0 1 r
.6439 .43325 m
.65056 .43216 L
s
0 .186 1 r
.43513 .43182 m
.44085 .4321 L
s
.44949 .44125 m
.43513 .43182 L
s
.44949 .44125 m
.44085 .4321 L
s
.45244 .42567 m
.44949 .44125 L
s
.4207 .37836 m
.44949 .44125 L
s
.343 0 1 r
.62373 .73027 m
.62651 .74712 L
s
.62373 .73027 m
.63795 .73598 L
s
.67683 .78862 m
.62373 .73027 L
s
0 1 .939 r
.59161 .63084 m
.59987 .62878 L
s
.59987 .62878 m
.60113 .61892 L
s
1 0 .462 r
.5937 .29986 m
.5826 .30013 L
s
.61037 .30587 m
.5937 .29986 L
s
.5937 .29986 m
.59158 .32265 L
s
1 0 .848 r
.23663 .43 m
.23338 .43009 L
s
.24595 .41341 m
.23663 .43 L
s
.25613 .43121 m
.23663 .43 L
s
.31605 .32651 m
.33017 .31366 L
s
.543 0 1 r
.48195 .93762 m
.49727 .8563 L
s
1 0 .304 r
.84936 .74439 m
.85087 .74273 L
s
.85087 .74273 m
.86307 .72559 L
s
.85087 .74273 m
.83891 .72269 L
s
.543 0 1 r
.50565 .87425 m
.49664 .87515 L
s
.49727 .8563 m
.50565 .87425 L
s
1 0 .848 r
.24278 .41336 m
.24595 .41341 L
s
.24595 .41341 m
.25613 .43121 L
s
0 .4 1 r
.42361 .63544 m
.42089 .62302 L
s
0 1 .939 r
.60113 .61892 m
.59286 .62096 L
s
1 0 .304 r
.86307 .72559 m
.86168 .7271 L
s
.86307 .72559 m
.83891 .72269 L
s
0 .186 1 r
.46362 .74746 m
.45145 .74026 L
s
0 1 .939 r
.55536 .5253 m
.55862 .52507 L
s
.55849 .51283 m
.55536 .5253 L
s
.55536 .5253 m
.55115 .51758 L
s
.56595 .52029 m
.55536 .5253 L
s
.57159 .49304 m
.55536 .5253 L
s
.59286 .62096 m
.59161 .63084 L
s
.543 0 1 r
.49727 .8563 m
.49664 .87515 L
s
.48272 .87093 m
.49727 .8563 L
s
0 .186 1 r
.44085 .4321 m
.45244 .42567 L
s
.343 0 1 r
.63099 .42513 m
.6439 .43325 L
s
.543 0 1 r
.49664 .87515 m
.48272 .87093 L
s
.899 0 1 r
.14288 .5236 m
.14359 .52625 L
s
.14616 .50584 m
.14288 .5236 L
s
.1629 .51918 m
.14288 .5236 L
s
1 0 .462 r
.59158 .32265 m
.59934 .30619 L
s
.59158 .32265 m
.5826 .30013 L
s
.61037 .30587 m
.59158 .32265 L
s
.61646 .22338 m
.59158 .32265 L
s
.977 0 1 r
.33447 .73834 m
.3426 .74022 L
s
.32668 .72246 m
.33447 .73834 L
s
.3493 .72197 m
.33447 .73834 L
s
1 0 .848 r
.68578 .86999 m
.67129 .88252 L
s
0 1 .939 r
.55849 .51283 m
.55115 .51758 L
s
.56595 .52029 m
.55849 .51283 L
s
.343 0 1 r
.63795 .73598 m
.62651 .74712 L
s
.899 0 1 r
.1469 .50836 m
.14616 .50584 L
s
.14616 .50584 m
.1629 .51918 L
s
1 0 .304 r
.83891 .72269 m
.84936 .74439 L
s
.83891 .72269 m
.86168 .7271 L
s
.92614 .78439 m
.83891 .72269 L
s
1 0 .462 r
.59934 .30619 m
.61037 .30587 L
s
1 0 0 r
.91152 .86751 m
.89786 .88501 L
s
.977 0 1 r
.3493 .72197 m
.3426 .74022 L
s
.32668 .72246 m
.3493 .72197 L
s
.33478 .72423 m
.3493 .72197 L
s
.2749 .7694 m
.3493 .72197 L
s
.714 0 1 r
.39668 .2939 m
.38134 .29956 L
s
.40271 .29132 m
.39668 .2939 L
s
.39668 .2939 m
.39823 .31192 L
s
1 0 .848 r
.25613 .43121 m
.23338 .43009 L
s
.24278 .41336 m
.25613 .43121 L
s
.17392 .38373 m
.25613 .43121 L
s
1 0 .15 r
.5434 .15699 m
.53076 .15624 L
s
.56075 .1619 m
.5434 .15699 L
s
.5434 .15699 m
.54142 .18053 L
s
0 .186 1 r
.36834 .52031 m
.37225 .52285 L
s
.37306 .50696 m
.36834 .52031 L
s
.38538 .51902 m
.36834 .52031 L
s
0 1 .939 r
.55862 .52507 m
.56595 .52029 L
s
0 .186 1 r
.377 .50942 m
.37306 .50696 L
s
.37306 .50696 m
.38538 .51902 L
s
.899 0 1 r
.1629 .51918 m
.14359 .52625 L
s
.1469 .50836 m
.1629 .51918 L
s
.07214 .50323 m
.1629 .51918 L
s
0 .186 1 r
.38538 .51902 m
.37225 .52285 L
s
.377 .50942 m
.38538 .51902 L
s
.32114 .49815 m
.38538 .51902 L
s
.977 0 1 r
.33478 .72423 m
.32668 .72246 L
s
.543 0 1 r
.80812 .61879 m
.81106 .61716 L
s
.81106 .61716 m
.81747 .60167 L
s
.81106 .61716 m
.79736 .60356 L
s
0 1 .939 r
.55115 .51758 m
.55862 .52507 L
s
.714 0 1 r
.37891 .86546 m
.3799 .86539 L
s
.36492 .85481 m
.37891 .86546 L
s
.383 .84602 m
.37891 .86546 L
s
.36581 .85465 m
.36492 .85481 L
s
.36492 .85481 m
.383 .84602 L
s
1 0 .462 r
.5826 .30013 m
.59934 .30619 L
s
.714 0 1 r
.38134 .29956 m
.38728 .297 L
s
.39823 .31192 m
.38134 .29956 L
s
.543 0 1 r
.81747 .60167 m
.81456 .60319 L
s
.81747 .60167 m
.79736 .60356 L
s
.977 0 1 r
.28582 .6136 m
.29319 .61695 L
s
.28384 .59561 m
.28582 .6136 L
s
.30543 .60278 m
.28582 .6136 L
s
1 0 .848 r
.23338 .43009 m
.24278 .41336 L
s
0 1 .939 r
.49176 .60385 m
.49057 .61347 L
s
.48529 .59885 m
.49176 .60385 L
s
.49176 .60385 m
.48113 .60833 L
s
.49475 .60399 m
.49176 .60385 L
s
.47226 .6156 m
.49176 .60385 L
s
1 0 .15 r
.54142 .18053 m
.54818 .16119 L
s
.54142 .18053 m
.53076 .15624 L
s
.56075 .1619 m
.54142 .18053 L
s
.56341 .07207 m
.54142 .18053 L
s
.714 0 1 r
.39823 .31192 m
.38728 .297 L
s
.40271 .29132 m
.39823 .31192 L
s
.36697 .22926 m
.39823 .31192 L
s
.543 0 1 r
.79736 .60356 m
.80812 .61879 L
s
.79736 .60356 m
.81456 .60319 L
s
.87512 .63701 m
.79736 .60356 L
s
.977 0 1 r
.30543 .60278 m
.29319 .61695 L
s
.28384 .59561 m
.30543 .60278 L
s
.29121 .59884 m
.30543 .60278 L
s
.21952 .62041 m
.30543 .60278 L
s
0 .802 1 r
.52632 .7145 m
.53035 .72851 L
s
.52226 .72044 m
.52632 .7145 L
s
.52632 .7145 m
.51887 .72667 L
s
.53379 .7223 m
.52632 .7145 L
s
.52632 .76506 m
.52632 .7145 L
s
.714 0 1 r
.383 .84602 m
.3799 .86539 L
s
.36581 .85465 m
.383 .84602 L
s
.32963 .91666 m
.383 .84602 L
s
1 0 .304 r
.86168 .7271 m
.84936 .74439 L
s
.343 0 1 r
.51322 .39985 m
.50209 .40333 L
s
.52511 .40453 m
.51322 .39985 L
s
.51322 .39985 m
.51251 .41903 L
s
0 .802 1 r
.53035 .72851 m
.53379 .7223 L
s
.51887 .72667 m
.53035 .72851 L
s
1 0 .15 r
.54818 .16119 m
.56075 .1619 L
s
1 0 .304 r
.75681 .86302 m
.75919 .86088 L
s
.75919 .86088 m
.77254 .84451 L
s
.75919 .86088 m
.7482 .84006 L
s
.977 0 1 r
.29121 .59884 m
.28384 .59561 L
s
.3426 .74022 m
.33478 .72423 L
s
0 .186 1 r
.37225 .52285 m
.377 .50942 L
s
.899 0 1 r
.14359 .52625 m
.1469 .50836 L
s
.04 0 1 r
.569 .85297 m
.57433 .85127 L
s
.55529 .85633 m
.569 .85297 L
s
.569 .85297 m
.56107 .83913 L
s
0 .802 1 r
.52226 .72044 m
.51887 .72667 L
s
.343 0 1 r
.51251 .41903 m
.51399 .40805 L
s
.51251 .41903 m
.50209 .40333 L
s
.52511 .40453 m
.51251 .41903 L
s
.51804 .34264 m
.51251 .41903 L
s
1 0 .304 r
.77254 .84451 m
.77029 .8465 L
s
.77254 .84451 m
.7482 .84006 L
s
0 1 .939 r
.48113 .60833 m
.49057 .61347 L
s
.48529 .59885 m
.48113 .60833 L
s
.714 0 1 r
.38728 .297 m
.40271 .29132 L
s
0 .536 1 r
.77616 .5105 m
.77922 .50825 L
s
.77922 .50825 m
.77496 .49602 L
s
.77922 .50825 m
.7637 .50704 L
s
.77496 .49602 m
.77188 .49821 L
s
.77496 .49602 m
.7637 .50704 L
s
.977 0 1 r
.71178 .7258 m
.71779 .72474 L
s
.71779 .72474 m
.72766 .70943 L
s
.71779 .72474 m
.70508 .70696 L
s
0 .536 1 r
.7637 .50704 m
.77616 .5105 L
s
.7637 .50704 m
.77188 .49821 L
s
.82351 .48789 m
.7637 .50704 L
s
1 0 .15 r
.53076 .15624 m
.54818 .16119 L
s
0 1 .939 r
.49057 .61347 m
.49475 .60399 L
s
1 0 .678 r
.23856 .85735 m
.24622 .86002 L
s
.22929 .84073 m
.23856 .85735 L
s
.25379 .83938 m
.23856 .85735 L
s
0 1 .939 r
.49475 .60399 m
.48529 .59885 L
s
.543 0 1 r
.81456 .60319 m
.80812 .61879 L
s
0 .186 1 r
.6702 .59578 m
.6766 .6072 L
s
.68595 .59028 m
.6702 .59578 L
s
.6702 .59578 m
.67691 .59348 L
s
.68562 .60395 m
.6702 .59578 L
s
.7265 .61077 m
.6702 .59578 L
s
.04 0 1 r
.56055 .85465 m
.55529 .85633 L
s
.55529 .85633 m
.56107 .83913 L
s
1 0 .304 r
.7482 .84006 m
.75681 .86302 L
s
.7482 .84006 m
.77029 .8465 L
s
.83131 .90887 m
.7482 .84006 L
s
0 .802 1 r
.53379 .7223 m
.52226 .72044 L
s
.343 0 1 r
.51399 .40805 m
.52511 .40453 L
s
.977 0 1 r
.72766 .70943 m
.72172 .71038 L
s
.72766 .70943 m
.70508 .70696 L
s
1 0 .678 r
.25379 .83938 m
.24622 .86002 L
s
.22929 .84073 m
.25379 .83938 L
s
.2369 .84328 m
.25379 .83938 L
s
.17235 .89501 m
.25379 .83938 L
s
1 0 .304 r
.1898 .72187 m
.19924 .72564 L
s
.18438 .70217 m
.1898 .72187 L
s
.21035 .70623 m
.1898 .72187 L
s
.977 0 1 r
.70508 .70696 m
.71178 .7258 L
s
.70508 .70696 m
.72172 .71038 L
s
.77921 .7607 m
.70508 .70696 L
s
0 .186 1 r
.6766 .6072 m
.68562 .60395 L
s
.68562 .60395 m
.68595 .59028 L
s
.04 0 1 r
.56107 .83913 m
.56055 .85465 L
s
.56107 .83913 m
.57433 .85127 L
s
.57974 .91277 m
.56107 .83913 L
s
.543 0 1 r
.73424 .39037 m
.728 .39131 L
s
.74795 .39943 m
.73424 .39037 L
s
.73424 .39037 m
.72978 .40978 L
s
.714 0 1 r
.3799 .86539 m
.36581 .85465 L
s
.343 0 1 r
.50209 .40333 m
.51399 .40805 L
s
1 0 .304 r
.21035 .70623 m
.19924 .72564 L
s
.18438 .70217 m
.21035 .70623 L
s
.1938 .7058 m
.21035 .70623 L
s
.11579 .74521 m
.21035 .70623 L
s
1 0 .678 r
.2369 .84328 m
.22929 .84073 L
s
.977 0 1 r
.29319 .61695 m
.29121 .59884 L
s
0 .186 1 r
.68595 .59028 m
.67691 .59348 L
s
.543 0 1 r
.72978 .40978 m
.74179 .40043 L
s
.72978 .40978 m
.728 .39131 L
s
.74795 .39943 m
.72978 .40978 L
s
.77128 .33702 m
.72978 .40978 L
s
.74179 .40043 m
.74795 .39943 L
s
.32466 .38591 m
.31371 .39907 L
s
.32454 .38529 m
.32466 .38591 L
s
.32466 .38591 m
.33226 .40316 L
s
1 0 .304 r
.1938 .7058 m
.18438 .70217 L
s
.543 0 1 r
.31371 .39907 m
.3135 .39854 L
s
.33226 .40316 m
.31371 .39907 L
s
0 .536 1 r
.77188 .49821 m
.77616 .5105 L
s
.04 0 1 r
.57433 .85127 m
.56055 .85465 L
s
0 .186 1 r
.6359 .49877 m
.64353 .49898 L
s
.6429 .48299 m
.6359 .49877 L
s
.6359 .49877 m
.63443 .48792 L
s
.65197 .494 m
.6359 .49877 L
s
.67315 .45906 m
.6359 .49877 L
s
1 0 .848 r
.46175 .26674 m
.44793 .26814 L
s
.47556 .26899 m
.46175 .26674 L
s
.46175 .26674 m
.46123 .28787 L
s
1 0 .304 r
.6896 .26382 m
.67918 .26378 L
s
.70753 .27072 m
.6896 .26382 L
s
.6896 .26382 m
.6872 .28769 L
s
0 .802 1 r
.44803 .49761 m
.44184 .49778 L
s
.44221 .48438 m
.44803 .49761 L
s
.44803 .49761 m
.43463 .4936 L
s
.44944 .48852 m
.44803 .49761 L
s
.41756 .46437 m
.44803 .49761 L
s
0 .186 1 r
.67691 .59348 m
.6766 .6072 L
s
.6429 .48299 m
.63443 .48792 L
s
.65197 .494 m
.6429 .48299 L
s
0 .802 1 r
.44221 .48438 m
.43463 .4936 L
s
.44944 .48852 m
.44221 .48438 L
s
1 0 .304 r
.77029 .8465 m
.75681 .86302 L
s
.343 0 1 r
.42686 .6984 m
.42395 .71469 L
s
.40776 .69878 m
.42686 .6984 L
s
.42686 .6984 m
.41298 .71282 L
s
.41874 .70059 m
.42686 .6984 L
s
.37086 .74073 m
.42686 .6984 L
s
.977 0 1 r
.72172 .71038 m
.71178 .7258 L
s
.543 0 1 r
.33226 .40316 m
.3135 .39854 L
s
.32454 .38529 m
.33226 .40316 L
s
.26627 .34822 m
.33226 .40316 L
s
0 .186 1 r
.64353 .49898 m
.65197 .494 L
s
.343 0 1 r
.41298 .71282 m
.42395 .71469 L
s
.40776 .69878 m
.41298 .71282 L
s
0 .802 1 r
.43463 .4936 m
.44184 .49778 L
s
1 0 .678 r
.24622 .86002 m
.2369 .84328 L
s
0 .4 1 r
.55592 .58344 m
.55765 .59303 L
s
.56083 .57393 m
.55592 .58344 L
s
.55592 .58344 m
.54998 .58185 L
s
.56849 .58511 m
.55592 .58344 L
s
.57295 .58367 m
.55592 .58344 L
s
1 0 .848 r
.46123 .28787 m
.46175 .27041 L
s
.46123 .28787 m
.44793 .26814 L
s
.47556 .26899 m
.46123 .28787 L
s
.46385 .19046 m
.46123 .28787 L
s
1 0 .304 r
.6872 .28769 m
.69721 .27073 L
s
.6872 .28769 m
.67918 .26378 L
s
.70753 .27072 m
.6872 .28769 L
s
.71844 .18436 m
.6872 .28769 L
s
.543 0 1 r
.728 .39131 m
.74179 .40043 L
s
.714 0 1 r
.23077 .4916 m
.23264 .49405 L
s
.23457 .47426 m
.23077 .4916 L
s
.25096 .48771 m
.23077 .4916 L
s
0 .186 1 r
.59095 .69544 m
.59056 .71038 L
s
.60569 .69652 m
.59095 .69544 L
s
.59095 .69544 m
.59345 .69849 L
s
.60276 .70838 m
.59095 .69544 L
s
.62745 .73622 m
.59095 .69544 L
s
1 0 .304 r
.19924 .72564 m
.1938 .7058 L
s
.69721 .27073 m
.70753 .27072 L
s
.714 0 1 r
.23647 .47658 m
.23457 .47426 L
s
.23457 .47426 m
.25096 .48771 L
s
.343 0 1 r
.41874 .70059 m
.40776 .69878 L
s
1 0 0 r
.63885 .11817 m
.6269 .11697 L
s
.65757 .12394 m
.63885 .11817 L
s
.63885 .11817 m
.63667 .14278 L
s
0 .186 1 r
.59056 .71038 m
.60276 .70838 L
s
.60276 .70838 m
.60569 .69652 L
s
1 0 .848 r
.46175 .27041 m
.47556 .26899 L
s
0 .802 1 r
.44184 .49778 m
.44944 .48852 L
s
1 0 .848 r
.44793 .26814 m
.46175 .27041 L
s
0 .186 1 r
.63443 .48792 m
.64353 .49898 L
s
.04 0 1 r
.45986 .84228 m
.46246 .84017 L
s
.4465 .83485 m
.45986 .84228 L
s
.46148 .82427 m
.45986 .84228 L
s
1 0 .678 r
.13458 .58871 m
.14102 .59223 L
s
.13252 .56905 m
.13458 .58871 L
s
.15593 .57741 m
.13458 .58871 L
s
.714 0 1 r
.25096 .48771 m
.23264 .49405 L
s
.23647 .47658 m
.25096 .48771 L
s
.16349 .46965 m
.25096 .48771 L
s
.04 0 1 r
.44901 .8327 m
.4465 .83485 L
s
.4465 .83485 m
.46148 .82427 L
s
.543 0 1 r
.3135 .39854 m
.32454 .38529 L
s
1 0 .678 r
.15593 .57741 m
.14102 .59223 L
s
.13252 .56905 m
.15593 .57741 L
s
.13896 .57243 m
.15593 .57741 L
s
.05855 .59362 m
.15593 .57741 L
s
.343 0 1 r
.38268 .57726 m
.37405 .58939 L
s
.36474 .56964 m
.38268 .57726 L
s
.38268 .57726 m
.36438 .58557 L
s
.37443 .57338 m
.38268 .57726 L
s
.31498 .58866 m
.38268 .57726 L
s
.04 0 1 r
.46148 .82427 m
.46246 .84017 L
s
.44901 .8327 m
.46148 .82427 L
s
.42608 .891 m
.46148 .82427 L
s
.543 0 1 r
.62869 .8401 m
.6334 .84037 L
s
.6334 .84037 m
.64593 .82894 L
s
.6334 .84037 m
.62647 .82153 L
s
.343 0 1 r
.42395 .71469 m
.41874 .70059 L
s
.977 0 1 r
.59631 .36826 m
.58546 .37128 L
s
.61104 .37638 m
.59631 .36826 L
s
.59631 .36826 m
.59314 .39059 L
s
.343 0 1 r
.36438 .58557 m
.37405 .58939 L
s
.36474 .56964 m
.36438 .58557 L
s
1 0 .678 r
.13896 .57243 m
.13252 .56905 L
s
1 0 .304 r
.67918 .26378 m
.69721 .27073 L
s
0 .4 1 r
.55765 .59303 m
.56849 .58511 L
s
.56849 .58511 m
.56083 .57393 L
s
.543 0 1 r
.64593 .82894 m
.64131 .82858 L
s
.64593 .82894 m
.62647 .82153 L
s
0 .186 1 r
.59345 .69849 m
.59056 .71038 L
s
.60569 .69652 m
.59345 .69849 L
s
0 .4 1 r
.56083 .57393 m
.54998 .58185 L
s
1 0 0 r
.63667 .14278 m
.64572 .12278 L
s
.63667 .14278 m
.6269 .11697 L
s
.65757 .12394 m
.63667 .14278 L
s
.66497 .02988 m
.63667 .14278 L
s
.977 0 1 r
.59314 .39059 m
.60024 .37947 L
s
.59314 .39059 m
.58546 .37128 L
s
.61104 .37638 m
.59314 .39059 L
s
.61917 .30553 m
.59314 .39059 L
s
.543 0 1 r
.62647 .82153 m
.62869 .8401 L
s
.62647 .82153 m
.64131 .82858 L
s
.68131 .88696 m
.62647 .82153 L
s
0 .4 1 r
.54998 .58185 m
.55765 .59303 L
s
.343 0 1 r
.37443 .57338 m
.36474 .56964 L
s
1 0 0 r
.64572 .12278 m
.65757 .12394 L
s
1 0 .15 r
.85794 .83784 m
.85994 .83555 L
s
.85994 .83555 m
.87333 .81793 L
s
.85994 .83555 m
.84774 .81421 L
s
.714 0 1 r
.23264 .49405 m
.23647 .47658 L
s
.977 0 1 r
.60024 .37947 m
.61104 .37638 L
s
1 0 .15 r
.87333 .81793 m
.87146 .82006 L
s
.87333 .81793 m
.84774 .81421 L
s
.04 0 1 r
.46246 .84017 m
.44901 .8327 L
s
.39187 .36264 m
.37926 .36985 L
s
.39801 .36287 m
.39187 .36264 L
s
.39187 .36264 m
.39515 .37998 L
s
0 .186 1 r
.51224 .47567 m
.51329 .47464 L
s
.51336 .45856 m
.51224 .47567 L
s
.51224 .47567 m
.503 .46606 L
s
.52365 .4671 m
.51224 .47567 L
s
.51779 .42926 m
.51224 .47567 L
s
1 0 .848 r
.81222 .6981 m
.81797 .69683 L
s
.81797 .69683 m
.82781 .68023 L
s
.81797 .69683 m
.80388 .67866 L
s
.343 0 1 r
.37405 .58939 m
.37443 .57338 L
s
1 0 0 r
.6269 .11697 m
.64572 .12278 L
s
1 0 .848 r
.32899 .83136 m
.33806 .83375 L
s
.32025 .81498 m
.32899 .83136 L
s
.34429 .81351 m
.32899 .83136 L
s
1 0 .678 r
.14102 .59223 m
.13896 .57243 L
s
.04 0 1 r
.76829 .56546 m
.77631 .57722 L
s
.78548 .55891 m
.76829 .56546 L
s
.76829 .56546 m
.77654 .56227 L
s
.78524 .57378 m
.76829 .56546 L
s
.83248 .57864 m
.76829 .56546 L
s
.977 0 1 r
.58546 .37128 m
.60024 .37947 L
s
1 0 .15 r
.84774 .81421 m
.85794 .83784 L
s
.84774 .81421 m
.87146 .82006 L
s
.93807 .8829 m
.84774 .81421 L
s
.543 0 1 r
.64131 .82858 m
.62869 .8401 L
s
0 .186 1 r
.49093 .67894 m
.49115 .69414 L
s
.48276 .67622 m
.49093 .67894 L
s
.49093 .67894 m
.47792 .68793 L
s
.49603 .68245 m
.49093 .67894 L
s
.47062 .71093 m
.49093 .67894 L
s
1 0 .848 r
.34429 .81351 m
.33806 .83375 L
s
.32025 .81498 m
.34429 .81351 L
s
.32928 .81725 m
.34429 .81351 L
s
.26732 .8685 m
.34429 .81351 L
s
.04 0 1 r
.39515 .37998 m
.38534 .37012 L
s
.39515 .37998 m
.37926 .36985 L
s
.39801 .36287 m
.39515 .37998 L
s
.36221 .31133 m
.39515 .37998 L
s
1 0 .848 r
.82781 .68023 m
.82212 .68137 L
s
.82781 .68023 m
.80388 .67866 L
s
.04 0 1 r
.77631 .57722 m
.78524 .57378 L
s
.78524 .57378 m
.78548 .55891 L
s
1 0 .848 r
.80388 .67866 m
.81222 .6981 L
s
.80388 .67866 m
.82212 .68137 L
s
.88559 .73168 m
.80388 .67866 L
s
.04 0 1 r
.37926 .36985 m
.38534 .37012 L
s
1 0 .462 r
.27946 .69326 m
.29028 .69694 L
s
.27473 .67368 m
.27946 .69326 L
s
.30011 .67789 m
.27946 .69326 L
s
0 .186 1 r
.51336 .45856 m
.503 .46606 L
s
.52365 .4671 m
.51336 .45856 L
s
1 0 .462 r
.30011 .67789 m
.29028 .69694 L
s
.27473 .67368 m
.30011 .67789 L
s
.28555 .67723 m
.30011 .67789 L
s
.21022 .71559 m
.30011 .67789 L
s
1 0 .304 r
.54407 .23281 m
.53129 .23323 L
s
.56133 .23869 m
.54407 .23281 L
s
.54407 .23281 m
.54185 .2571 L
s
1 0 .848 r
.32928 .81725 m
.32025 .81498 L
s
.04 0 1 r
.78548 .55891 m
.77654 .56227 L
s
0 .186 1 r
.51329 .47464 m
.52365 .4671 L
s
.04 0 1 r
.73373 .46654 m
.74318 .46669 L
s
.74194 .44963 m
.73373 .46654 L
s
.73373 .46654 m
.73348 .45457 L
s
.75159 .4617 m
.73373 .46654 L
s
.77872 .42374 m
.73373 .46654 L
s
1 0 .462 r
.28555 .67723 m
.27473 .67368 L
s
0 .186 1 r
.503 .46606 m
.51329 .47464 L
s
.47792 .68793 m
.49115 .69414 L
s
.48276 .67622 m
.47792 .68793 L
s
.04 0 1 r
.38534 .37012 m
.39801 .36287 L
s
.343 0 1 r
.63802 .55731 m
.64313 .56732 L
s
.64834 .54464 m
.63802 .55731 L
s
.63802 .55731 m
.63552 .55255 L
s
.65592 .55937 m
.63802 .55731 L
s
.67766 .55045 m
.63802 .55731 L
s
1 0 .304 r
.54185 .2571 m
.54862 .23916 L
s
.54185 .2571 m
.53129 .23323 L
s
.56133 .23869 m
.54185 .2571 L
s
.56453 .15014 m
.54185 .2571 L
s
0 .186 1 r
.49115 .69414 m
.49603 .68245 L
s
.44651 .55617 m
.44287 .56607 L
s
.43754 .54608 m
.44651 .55617 L
s
.44651 .55617 m
.4312 .55905 L
s
.44924 .55308 m
.44651 .55617 L
s
.41423 .55565 m
.44651 .55617 L
s
.522 0 1 r
.67368 .67105 m
.67765 .68753 L
s
.69277 .66836 m
.67368 .67105 L
s
.67368 .67105 m
.67992 .67185 L
s
.69047 .68397 m
.67368 .67105 L
s
.73261 .70624 m
.67368 .67105 L
s
.04 0 1 r
.74194 .44963 m
.73348 .45457 L
s
.75159 .4617 m
.74194 .44963 L
s
0 .536 1 r
.52632 .8063 m
.53081 .82195 L
s
.5218 .81351 m
.52632 .8063 L
s
.52632 .8063 m
.51802 .82003 L
s
.53464 .81545 m
.52632 .8063 L
s
.52632 .86433 m
.52632 .8063 L
s
.04 0 1 r
.77654 .56227 m
.77631 .57722 L
s
0 .536 1 r
.53081 .82195 m
.53464 .81545 L
s
.51802 .82003 m
.53081 .82195 L
s
1 0 .15 r
.87146 .82006 m
.85794 .83784 L
s
1 0 .304 r
.54862 .23916 m
.56133 .23869 L
s
.04 0 1 r
.74318 .46669 m
.75159 .4617 L
s
1 0 .848 r
.82212 .68137 m
.81222 .6981 L
s
.04 0 1 r
.30974 .46103 m
.31402 .46357 L
s
.31523 .44649 m
.30974 .46103 L
s
.32848 .46 m
.30974 .46103 L
s
1 0 .848 r
.33806 .83375 m
.32928 .81725 L
s
.522 0 1 r
.67765 .68753 m
.69047 .68397 L
s
.69047 .68397 m
.69277 .66836 L
s
.04 0 1 r
.31955 .44894 m
.31523 .44649 L
s
.31523 .44649 m
.32848 .46 L
s
.32848 .46 m
.31402 .46357 L
s
.31955 .44894 m
.32848 .46 L
s
.25842 .43475 m
.32848 .46 L
s
0 .186 1 r
.49603 .68245 m
.48276 .67622 L
s
0 .536 1 r
.5218 .81351 m
.51802 .82003 L
s
1 0 .462 r
.29028 .69694 m
.28555 .67723 L
s
1 0 .848 r
.71643 .81978 m
.72322 .81823 L
s
.72322 .81823 m
.73418 .80244 L
s
.72322 .81823 m
.71018 .79901 L
s
1 0 .304 r
.53129 .23323 m
.54862 .23916 L
s
.343 0 1 r
.64313 .56732 m
.65592 .55937 L
s
.65592 .55937 m
.64834 .54464 L
s
0 .186 1 r
.4312 .55905 m
.44287 .56607 L
s
.43754 .54608 m
.4312 .55905 L
s
.522 0 1 r
.69277 .66836 m
.67992 .67185 L
s
.343 0 1 r
.64834 .54464 m
.63552 .55255 L
s
.04 0 1 r
.73348 .45457 m
.74318 .46669 L
s
1 0 .848 r
.22412 .55728 m
.23186 .56071 L
s
.22268 .53783 m
.22412 .55728 L
s
.24558 .54641 m
.22412 .55728 L
s
0 .536 1 r
.53464 .81545 m
.5218 .81351 L
s
1 0 .848 r
.71018 .79901 m
.71643 .81978 L
s
.73418 .80244 m
.71018 .79901 L
s
.71018 .79901 m
.72747 .80386 L
s
.78689 .86013 m
.71018 .79901 L
s
1 0 .15 r
.18005 .81542 m
.19048 .81994 L
s
.17376 .79511 m
.18005 .81542 L
s
.20133 .79829 m
.18005 .81542 L
s
1 0 .848 r
.73418 .80244 m
.72747 .80386 L
s
0 .186 1 r
.44924 .55308 m
.43754 .54608 L
s
1 0 .848 r
.24558 .54641 m
.23186 .56071 L
s
.22268 .53783 m
.24558 .54641 L
s
.23042 .54113 m
.24558 .54641 L
s
.15242 .56081 m
.24558 .54641 L
s
1 0 .15 r
.20133 .79829 m
.19048 .81994 L
s
.17376 .79511 m
.20133 .79829 L
s
.18417 .79948 m
.20133 .79829 L
s
.1032 .84524 m
.20133 .79829 L
s
.522 0 1 r
.67992 .67185 m
.67765 .68753 L
s
0 .186 1 r
.44287 .56607 m
.44924 .55308 L
s
.543 0 1 r
.46017 .33543 m
.4476 .33943 L
s
.47259 .34017 m
.46017 .33543 L
s
.46017 .33543 m
.45964 .35622 L
s
1 0 .848 r
.69491 .33257 m
.68449 .3354 L
s
.71078 .34161 m
.69491 .33257 L
s
.69491 .33257 m
.69112 .35604 L
s
.343 0 1 r
.63552 .55255 m
.64313 .56732 L
s
1 0 .848 r
.23042 .54113 m
.22268 .53783 L
s
.04 0 1 r
.31402 .46357 m
.31955 .44894 L
s
.343 0 1 r
.55664 .65898 m
.55755 .67451 L
s
.56264 .65157 m
.55664 .65898 L
s
.55664 .65898 m
.54862 .66113 L
s
.57153 .66497 m
.55664 .65898 L
s
.5744 .67992 m
.55664 .65898 L
s
.543 0 1 r
.45964 .35622 m
.46002 .34421 L
s
.45964 .35622 m
.4476 .33943 L
s
.47259 .34017 m
.45964 .35622 L
s
.46195 .27298 m
.45964 .35622 L
s
1 0 .848 r
.69112 .35604 m
.70043 .34451 L
s
.69112 .35604 m
.68449 .3354 L
s
.71078 .34161 m
.69112 .35604 L
s
.72431 .26694 m
.69112 .35604 L
s
1 0 .15 r
.18417 .79948 m
.17376 .79511 L
s
.522 0 1 r
.59445 .44758 m
.60008 .4465 L
s
.5996 .42731 m
.59445 .44758 L
s
.59445 .44758 m
.58795 .43458 L
s
.61169 .43916 m
.59445 .44758 L
s
.62203 .39274 m
.59445 .44758 L
s
1 0 .848 r
.70043 .34451 m
.71078 .34161 L
s
.543 0 1 r
.424 .79073 m
.42168 .809 L
s
.4036 .79218 m
.424 .79073 L
s
.424 .79073 m
.40955 .80674 L
s
.41574 .79438 m
.424 .79073 L
s
.36608 .84093 m
.424 .79073 L
s
.46002 .34421 m
.47259 .34017 L
s
1 0 .15 r
.12435 .66893 m
.13419 .67289 L
s
.11934 .64766 m
.12435 .66893 L
s
.14687 .65309 m
.12435 .66893 L
s
1 0 .848 r
.72747 .80386 m
.71643 .81978 L
s
.543 0 1 r
.40955 .80674 m
.42168 .809 L
s
.4036 .79218 m
.40955 .80674 L
s
.4476 .33943 m
.46002 .34421 L
s
1 0 .15 r
.14687 .65309 m
.13419 .67289 L
s
.11934 .64766 m
.14687 .65309 L
s
.12917 .65145 m
.14687 .65309 L
s
.04412 .68959 m
.14687 .65309 L
s
.977 0 1 r
.37917 .65294 m
.37293 .67028 L
s
.35778 .64807 m
.37917 .65294 L
s
.37917 .65294 m
.35949 .66595 L
s
.37126 .65231 m
.37917 .65294 L
s
.30844 .68477 m
.37917 .65294 L
s
.522 0 1 r
.5996 .42731 m
.58795 .43458 L
s
.61169 .43916 m
.5996 .42731 L
s
1 0 .848 r
.23186 .56071 m
.23042 .54113 L
s
.343 0 1 r
.51197 .53454 m
.51257 .54388 L
s
.51351 .52008 m
.51197 .53454 L
s
.51197 .53454 m
.50102 .53139 L
s
.52506 .53256 m
.51197 .53454 L
s
.51752 .5213 m
.51197 .53454 L
s
.04 0 1 r
.59281 .78786 m
.59178 .80473 L
s
.60866 .7901 m
.59281 .78786 L
s
.59281 .78786 m
.59513 .79234 L
s
.60527 .80246 m
.59281 .78786 L
s
.63057 .83659 m
.59281 .78786 L
s
.977 0 1 r
.35949 .66595 m
.37293 .67028 L
s
.35778 .64807 m
.35949 .66595 L
s
1 0 .15 r
.19048 .81994 m
.18417 .79948 L
s
1 0 .848 r
.68449 .3354 m
.70043 .34451 L
s
.522 0 1 r
.60008 .4465 m
.61169 .43916 L
s
.343 0 1 r
.55755 .67451 m
.57153 .66497 L
s
.57153 .66497 m
.56264 .65157 L
s
.54862 .66113 m
.55755 .67451 L
s
1 0 .15 r
.12917 .65145 m
.11934 .64766 L
s
.04 0 1 r
.59178 .80473 m
.60527 .80246 L
s
.60527 .80246 m
.60866 .7901 L
s
.543 0 1 r
.41574 .79438 m
.4036 .79218 L
s
1 0 .15 r
.64236 .19429 m
.63025 .19431 L
s
.66101 .20105 m
.64236 .19429 L
s
.64236 .19429 m
.63986 .21969 L
s
0 .536 1 r
.39257 .43709 m
.38525 .43688 L
s
.38595 .42215 m
.39257 .43709 L
s
.39257 .43709 m
.3774 .43244 L
s
.39383 .42654 m
.39257 .43709 L
s
.35716 .39846 m
.39257 .43709 L
s
.343 0 1 r
.56264 .65157 m
.54862 .66113 L
s
.977 0 1 r
.37126 .65231 m
.35778 .64807 L
s
.522 0 1 r
.58795 .43458 m
.60008 .4465 L
s
0 .536 1 r
.38595 .42215 m
.3774 .43244 L
s
.39383 .42654 m
.38595 .42215 L
s
.543 0 1 r
.42168 .809 m
.41574 .79438 L
s
0 .536 1 r
.3774 .43244 m
.38525 .43688 L
s
.04 0 1 r
.59513 .79234 m
.59178 .80473 L
s
.60866 .7901 m
.59513 .79234 L
s
.543 0 1 r
.73783 .52554 m
.74462 .53564 L
s
.75001 .51171 m
.73783 .52554 L
s
.73783 .52554 m
.7369 .51971 L
s
.75769 .5276 m
.73783 .52554 L
s
.78663 .51589 m
.73783 .52554 L
s
1 0 .15 r
.63986 .21969 m
.64899 .20112 L
s
.63986 .21969 m
.63025 .19431 L
s
.66101 .20105 m
.63986 .21969 L
s
.66923 .10821 m
.63986 .21969 L
s
.977 0 1 r
.37293 .67028 m
.37126 .65231 L
s
.714 0 1 r
.77425 .64139 m
.77992 .65834 L
s
.79506 .63762 m
.77425 .64139 L
s
.77425 .64139 m
.78229 .64139 L
s
.79266 .65451 m
.77425 .64139 L
s
.84201 .67504 m
.77425 .64139 L
s
1 0 .15 r
.13419 .67289 m
.12917 .65145 L
s
.343 0 1 r
.51351 .52008 m
.50102 .53139 L
s
.52506 .53256 m
.51351 .52008 L
s
1 0 .15 r
.64899 .20112 m
.66101 .20105 L
s
.343 0 1 r
.51257 .54388 m
.52506 .53256 L
s
.714 0 1 r
.77992 .65834 m
.79266 .65451 L
s
.79266 .65451 m
.79506 .63762 L
s
.343 0 1 r
.50102 .53139 m
.51257 .54388 L
s
0 .536 1 r
.38525 .43688 m
.39383 .42654 L
s
.543 0 1 r
.32456 .51909 m
.31456 .53133 L
s
.30538 .50987 m
.32456 .51909 L
s
.32456 .51909 m
.30436 .52725 L
s
.3156 .51385 m
.32456 .51909 L
s
.25008 .52667 m
.32456 .51909 L
s
1 0 .678 r
.81992 .79308 m
.82645 .79126 L
s
.82645 .79126 m
.8374 .77413 L
s
.82645 .79126 m
.81196 .77162 L
s
.543 0 1 r
.74462 .53564 m
.75769 .5276 L
s
.75769 .5276 m
.75001 .51171 L
s
1 0 .848 r
.54532 .30178 m
.5329 .30511 L
s
.56078 .31 m
.54532 .30178 L
s
.54532 .30178 m
.54224 .32578 L
s
.543 0 1 r
.30436 .52725 m
.31456 .53133 L
s
.30538 .50987 m
.30436 .52725 L
s
1 0 .15 r
.63025 .19431 m
.64899 .20112 L
s
.714 0 1 r
.79506 .63762 m
.78229 .64139 L
s
.543 0 1 r
.75001 .51171 m
.7369 .51971 L
s
.977 0 1 r
.64079 .63342 m
.64457 .64947 L
s
.65315 .62288 m
.64079 .63342 L
s
.64079 .63342 m
.63684 .63234 L
s
.66081 .63998 m
.64079 .63342 L
s
.68245 .64764 m
.64079 .63342 L
s
.04 0 1 r
.4899 .77189 m
.49048 .78919 L
s
.48111 .77031 m
.4899 .77189 L
s
.4899 .77189 m
.47594 .78257 L
s
.49569 .77695 m
.4899 .77189 L
s
.46887 .81223 m
.4899 .77189 L
s
1 0 .848 r
.54224 .32578 m
.54841 .3134 L
s
.54224 .32578 m
.5329 .30511 L
s
.56078 .31 m
.54224 .32578 L
s
.56572 .23307 m
.54224 .32578 L
s
1 0 .678 r
.81196 .77162 m
.81992 .79308 L
s
.8374 .77413 m
.81196 .77162 L
s
.81196 .77162 m
.83095 .77581 L
s
.89671 .83222 m
.81196 .77162 L
s
.8374 .77413 m
.83095 .77581 L
s
1 0 .304 r
.27212 .78778 m
.28403 .79219 L
s
.26659 .76757 m
.27212 .78778 L
s
.29353 .77088 m
.27212 .78778 L
s
.522 0 1 r
.44453 .63231 m
.44227 .64814 L
s
.43364 .62438 m
.44453 .63231 L
s
.44453 .63231 m
.42701 .63972 L
s
.44895 .6328 m
.44453 .63231 L
s
.41069 .65269 m
.44453 .63231 L
s
1 0 .304 r
.29353 .77088 m
.28403 .79219 L
s
.26659 .76757 m
.29353 .77088 L
s
.27849 .77183 m
.29353 .77088 L
s
.20033 .81673 m
.29353 .77088 L
s
.543 0 1 r
.3156 .51385 m
.30538 .50987 L
s
.714 0 1 r
.78229 .64139 m
.77992 .65834 L
s
.543 0 1 r
.7369 .51971 m
.74462 .53564 L
s
1 0 .848 r
.54841 .3134 m
.56078 .31 L
s
1 0 .304 r
.27849 .77183 m
.26659 .76757 L
s
.04 0 1 r
.45831 .4136 m
.45843 .41191 L
s
.45883 .39465 m
.45831 .4136 L
s
.45831 .4136 m
.44726 .40292 L
s
.46998 .40358 m
.45831 .4136 L
s
.45993 .36068 m
.45831 .4136 L
s
.714 0 1 r
.69442 .41342 m
.70207 .41208 L
s
.70086 .39193 m
.69442 .41342 L
s
.69442 .41342 m
.68916 .39916 L
s
.71373 .40478 m
.69442 .41342 L
s
.73055 .35473 m
.69442 .41342 L
s
.04 0 1 r
.47594 .78257 m
.49048 .78919 L
s
.48111 .77031 m
.47594 .78257 L
s
.49048 .78919 m
.49569 .77695 L
s
.543 0 1 r
.31456 .53133 m
.3156 .51385 L
s
.977 0 1 r
.59581 .50684 m
.5999 .51624 L
s
.60305 .48923 m
.59581 .50684 L
s
.59581 .50684 m
.5881 .50023 L
s
.61481 .50519 m
.59581 .50684 L
s
.62509 .48552 m
.59581 .50684 L
s
.714 0 1 r
.67799 .76425 m
.68146 .78289 L
s
.69839 .76261 m
.67799 .76425 L
s
.67799 .76425 m
.68427 .76661 L
s
.69555 .77883 m
.67799 .76425 L
s
.7391 .80772 m
.67799 .76425 L
s
.977 0 1 r
.64457 .64947 m
.66081 .63998 L
s
.66081 .63998 m
.65315 .62288 L
s
1 0 .848 r
.5329 .30511 m
.54841 .3134 L
s
.522 0 1 r
.42701 .63972 m
.44227 .64814 L
s
.43364 .62438 m
.42701 .63972 L
s
.04 0 1 r
.45883 .39465 m
.44726 .40292 L
s
.46998 .40358 m
.45883 .39465 L
s
1 0 .304 r
.23858 .62275 m
.22722 .64217 L
s
.21165 .61707 m
.23858 .62275 L
s
.23858 .62275 m
.21591 .63828 L
s
.22297 .62082 m
.23858 .62275 L
s
.14065 .65771 m
.23858 .62275 L
s
.21591 .63828 m
.22722 .64217 L
s
.21165 .61707 m
.21591 .63828 L
s
1 0 .678 r
.83095 .77581 m
.81992 .79308 L
s
.714 0 1 r
.70086 .39193 m
.68916 .39916 L
s
.71373 .40478 m
.70086 .39193 L
s
.68146 .78289 m
.69555 .77883 L
s
.69555 .77883 m
.69839 .76261 L
s
.522 0 1 r
.44227 .64814 m
.44895 .6328 L
s
.04 0 1 r
.49569 .77695 m
.48111 .77031 L
s
.977 0 1 r
.63684 .63234 m
.64457 .64947 L
s
.65315 .62288 m
.63684 .63234 L
s
.522 0 1 r
.44895 .6328 m
.43364 .62438 L
s
1 0 .304 r
.28403 .79219 m
.27849 .77183 L
s
.714 0 1 r
.70207 .41208 m
.71373 .40478 L
s
.04 0 1 r
.45843 .41191 m
.46998 .40358 L
s
1 0 .304 r
.22297 .62082 m
.21165 .61707 L
s
.04 0 1 r
.44726 .40292 m
.45843 .41191 L
s
.714 0 1 r
.69839 .76261 m
.68427 .76661 L
s
.04 0 1 r
.38988 .4965 m
.38516 .50637 L
s
.37975 .48454 m
.38988 .4965 L
s
.38988 .4965 m
.37269 .49884 L
s
.39226 .49205 m
.38988 .4965 L
s
.35178 .49112 m
.38988 .4965 L
s
.714 0 1 r
.68427 .76661 m
.68146 .78289 L
s
.68916 .39916 m
.70207 .41208 L
s
.977 0 1 r
.5999 .51624 m
.61481 .50519 L
s
.61481 .50519 m
.60305 .48923 L
s
.60305 .48923 m
.5881 .50023 L
s
.543 0 1 r
.55753 .75256 m
.55826 .77044 L
s
.56395 .74621 m
.55753 .75256 L
s
.55753 .75256 m
.54875 .75639 L
s
.57342 .76028 m
.55753 .75256 L
s
.57594 .78235 m
.55753 .75256 L
s
.977 0 1 r
.51161 .61114 m
.51197 .62681 L
s
.51342 .59859 m
.51161 .61114 L
s
.51161 .61114 m
.49855 .61205 L
s
.52682 .61336 m
.51161 .61114 L
s
.51724 .61927 m
.51161 .61114 L
s
1 0 .304 r
.22722 .64217 m
.22297 .62082 L
s
.977 0 1 r
.5881 .50023 m
.5999 .51624 L
s
.04 0 1 r
.37269 .49884 m
.38516 .50637 L
s
.37975 .48454 m
.37269 .49884 L
s
.39226 .49205 m
.37975 .48454 L
s
1 0 0 r
.11229 .76425 m
.12315 .76903 L
s
.1064 .74228 m
.11229 .76425 L
s
.13565 .74686 m
.11229 .76425 L
s
.13565 .74686 m
.12315 .76903 L
s
.1064 .74228 m
.13565 .74686 L
s
.11724 .74689 m
.13565 .74686 L
s
.02877 .79167 m
.13565 .74686 L
s
1 0 .848 r
.37482 .74671 m
.36901 .76634 L
s
.35204 .74283 m
.37482 .74671 L
s
.37482 .74671 m
.35429 .76138 L
s
.3668 .7477 m
.37482 .74671 L
s
.30148 .78702 m
.37482 .74671 L
s
1 0 .678 r
.64645 .26355 m
.63444 .26662 L
s
.66315 .27269 m
.64645 .26355 L
s
.64645 .26355 m
.64272 .28875 L
s
.04 0 1 r
.38516 .50637 m
.39226 .49205 L
s
1 0 .848 r
.35429 .76138 m
.36901 .76634 L
s
.35204 .74283 m
.35429 .76138 L
s
.74317 .60232 m
.74859 .61857 L
s
.75781 .59059 m
.74317 .60232 L
s
.74317 .60232 m
.74108 .60019 L
s
.76526 .60894 m
.74317 .60232 L
s
.79505 .614 m
.74317 .60232 L
s
1 0 .678 r
.64272 .28875 m
.65121 .27583 L
s
.64272 .28875 m
.63444 .26662 L
s
.66315 .27269 m
.64272 .28875 L
s
.67376 .19152 m
.64272 .28875 L
s
.543 0 1 r
.55826 .77044 m
.57342 .76028 L
s
.57342 .76028 m
.56395 .74621 L
s
.54875 .75639 m
.55826 .77044 L
s
1 0 0 r
.11724 .74689 m
.1064 .74228 L
s
.714 0 1 r
.54256 .38348 m
.54739 .38154 L
s
.54724 .36128 m
.54256 .38348 L
s
.54256 .38348 m
.53426 .36916 L
s
.56034 .37359 m
.54256 .38348 L
s
.56698 .32132 m
.54256 .38348 L
s
.543 0 1 r
.56395 .74621 m
.54875 .75639 L
s
.977 0 1 r
.51197 .62681 m
.52682 .61336 L
s
.52682 .61336 m
.51342 .59859 L
s
.49855 .61205 m
.51197 .62681 L
s
1 0 .848 r
.3668 .7477 m
.35204 .74283 L
s
1 0 .678 r
.65121 .27583 m
.66315 .27269 L
s
.977 0 1 r
.51342 .59859 m
.49855 .61205 L
s
1 0 .848 r
.31945 .596 m
.31179 .6137 L
s
.29661 .58945 m
.31945 .596 L
s
.31945 .596 m
.2977 .60896 L
s
.31074 .59409 m
.31945 .596 L
s
.2412 .6245 m
.31945 .596 L
s
.714 0 1 r
.54724 .36128 m
.53426 .36916 L
s
.56034 .37359 m
.54724 .36128 L
s
.543 0 1 r
.45692 .47331 m
.45676 .48239 L
s
.45741 .4568 m
.45692 .47331 L
s
.45692 .47331 m
.44402 .46922 L
s
.47015 .46995 m
.45692 .47331 L
s
.45777 .45407 m
.45692 .47331 L
s
1 0 .848 r
.69784 .47313 m
.70378 .48246 L
s
.7071 .45423 m
.69784 .47313 L
s
.69784 .47313 m
.69169 .46529 L
s
.71915 .47134 m
.69784 .47313 L
s
.7372 .44823 m
.69784 .47313 L
s
.36901 .76634 m
.3668 .7477 L
s
.899 0 1 r
.78163 .73552 m
.78689 .75472 L
s
.80389 .73278 m
.78163 .73552 L
s
.78163 .73552 m
.78986 .73711 L
s
.80089 .75031 m
.78163 .73552 L
s
.85216 .77764 m
.78163 .73552 L
s
1 0 .848 r
.2977 .60896 m
.31179 .6137 L
s
.29661 .58945 m
.2977 .60896 L
s
.74859 .61857 m
.76526 .60894 L
s
.76526 .60894 m
.75781 .59059 L
s
1 0 0 r
.12315 .76903 m
.11724 .74689 L
s
1 0 .678 r
.63444 .26662 m
.65121 .27583 L
s
.714 0 1 r
.54739 .38154 m
.56034 .37359 L
s
.899 0 1 r
.78689 .75472 m
.80089 .75031 L
s
.80089 .75031 m
.80389 .73278 L
s
1 0 .848 r
.75781 .59059 m
.74108 .60019 L
s
.74108 .60019 m
.74859 .61857 L
s
.31074 .59409 m
.29661 .58945 L
s
.714 0 1 r
.53426 .36916 m
.54739 .38154 L
s
.899 0 1 r
.80389 .73278 m
.78986 .73711 L
s
1 0 .848 r
.64422 .72778 m
.64777 .74637 L
s
.65741 .71824 m
.64422 .72778 L
s
.64422 .72778 m
.63979 .72847 L
s
.66533 .73613 m
.64422 .72778 L
s
.68756 .75118 m
.64422 .72778 L
s
1 0 .462 r
.59759 .584 m
.60088 .5999 L
s
.60612 .56826 m
.59759 .584 L
s
.59759 .584 m
.58822 .58137 L
s
.61873 .58677 m
.59759 .584 L
s
.62834 .58441 m
.59759 .584 L
s
.714 0 1 r
.44208 .72671 m
.4401 .74495 L
s
.43042 .71983 m
.44208 .72671 L
s
.44208 .72671 m
.42351 .73588 L
s
.44707 .7289 m
.44208 .72671 L
s
.40692 .75606 m
.44208 .72671 L
s
1 0 .848 r
.31179 .6137 m
.31074 .59409 L
s
.70378 .48246 m
.71915 .47134 L
s
.71915 .47134 m
.7071 .45423 L
s
.543 0 1 r
.45741 .4568 m
.44402 .46922 L
s
.47015 .46995 m
.45741 .4568 L
s
1 0 .848 r
.7071 .45423 m
.69169 .46529 L
s
.899 0 1 r
.78986 .73711 m
.78689 .75472 L
s
.543 0 1 r
.45676 .48239 m
.47015 .46995 L
s
.44402 .46922 m
.45676 .48239 L
s
1 0 .848 r
.69169 .46529 m
.70378 .48246 L
s
.64777 .74637 m
.66533 .73613 L
s
.66533 .73613 m
.65741 .71824 L
s
.714 0 1 r
.42351 .73588 m
.4401 .74495 L
s
.43042 .71983 m
.42351 .73588 L
s
.38637 .57386 m
.38303 .58993 L
s
.37409 .56399 m
.38637 .57386 L
s
.38637 .57386 m
.36687 .58083 L
s
.39031 .57308 m
.38637 .57386 L
s
.34605 .58987 m
.38637 .57386 L
s
1 0 .15 r
.22991 .71744 m
.21881 .73927 L
s
.20128 .71265 m
.22991 .71744 L
s
.22991 .71744 m
.20636 .73457 L
s
.21373 .71719 m
.22991 .71744 L
s
.12811 .76091 m
.22991 .71744 L
s
.20636 .73457 m
.21881 .73927 L
s
.20128 .71265 m
.20636 .73457 L
s
.714 0 1 r
.4401 .74495 m
.44707 .7289 L
s
1 0 .848 r
.63979 .72847 m
.64777 .74637 L
s
1 0 .462 r
.60088 .5999 m
.61873 .58677 L
s
.61873 .58677 m
.60612 .56826 L
s
1 0 .848 r
.65741 .71824 m
.63979 .72847 L
s
.714 0 1 r
.44707 .7289 m
.43042 .71983 L
s
1 0 .462 r
.60612 .56826 m
.58822 .58137 L
s
.899 0 1 r
.64513 .34682 m
.65211 .34452 L
s
.65118 .32332 m
.64513 .34682 L
s
.64513 .34682 m
.63811 .33111 L
s
.66514 .33664 m
.64513 .34682 L
s
.6786 .28029 m
.64513 .34682 L
s
1 0 .15 r
.21373 .71719 m
.20128 .71265 L
s
1 0 .462 r
.58822 .58137 m
.60088 .5999 L
s
1 0 .848 r
.5429 .44357 m
.54633 .45256 L
s
.54927 .42377 m
.5429 .44357 L
s
.5429 .44357 m
.5332 .43575 L
s
.56237 .44053 m
.5429 .44357 L
s
.56833 .41542 m
.5429 .44357 L
s
.714 0 1 r
.36687 .58083 m
.38303 .58993 L
s
.37409 .56399 m
.36687 .58083 L
s
.899 0 1 r
.65118 .32332 m
.63811 .33111 L
s
.66514 .33664 m
.65118 .32332 L
s
1 0 .848 r
.51116 .70617 m
.51147 .72448 L
s
.51308 .69461 m
.51116 .70617 L
s
.51116 .70617 m
.49718 .7089 L
s
.52735 .71022 m
.51116 .70617 L
s
.51693 .72376 m
.51116 .70617 L
s
.714 0 1 r
.38303 .58993 m
.39031 .57308 L
s
.39031 .57308 m
.37409 .56399 L
s
1 0 .15 r
.21881 .73927 m
.21373 .71719 L
s
.899 0 1 r
.65211 .34452 m
.66514 .33664 L
s
.63811 .33111 m
.65211 .34452 L
s
1 0 .848 r
.54927 .42377 m
.5332 .43575 L
s
.56237 .44053 m
.54927 .42377 L
s
.54633 .45256 m
.56237 .44053 L
s
1 0 .678 r
.74979 .69761 m
.75505 .71649 L
s
.76546 .68686 m
.74979 .69761 L
s
.74979 .69761 m
.74736 .69727 L
s
.77307 .70605 m
.74979 .69761 L
s
.80404 .71867 m
.74979 .69761 L
s
1 0 .848 r
.45512 .55112 m
.45479 .56683 L
s
.45559 .5364 m
.45512 .55112 L
s
.45512 .55112 m
.43996 .55122 L
s
.47041 .55202 m
.45512 .55112 L
s
.45547 .55373 m
.45512 .55112 L
s
1 0 .304 r
.7023 .55094 m
.70739 .56691 L
s
.71334 .53388 m
.7023 .55094 L
s
.7023 .55094 m
.69475 .5471 L
s
.72592 .55366 m
.7023 .55094 L
s
.7443 .54803 m
.7023 .55094 L
s
1 0 .848 r
.5332 .43575 m
.54633 .45256 L
s
.51147 .72448 m
.52735 .71022 L
s
.49718 .7089 m
.51147 .72448 L
s
.52735 .71022 m
.51308 .69461 L
s
1 0 .678 r
.3131 .69147 m
.30581 .71162 L
s
.28875 .6859 m
.3131 .69147 L
s
.3131 .69147 m
.2904 .70615 L
s
.30421 .69126 m
.3131 .69147 L
s
.23174 .72882 m
.3131 .69147 L
s
1 0 .848 r
.51308 .69461 m
.49718 .7089 L
s
1 0 .678 r
.2904 .70615 m
.30581 .71162 L
s
.28875 .6859 m
.2904 .70615 L
s
.75505 .71649 m
.77307 .70605 L
s
.77307 .70605 m
.76546 .68686 L
s
1 0 .304 r
.70739 .56691 m
.72592 .55366 L
s
.72592 .55366 m
.71334 .53388 L
s
1 0 .678 r
.74736 .69727 m
.75505 .71649 L
s
.76546 .68686 m
.74736 .69727 L
s
.30421 .69126 m
.28875 .6859 L
s
1 0 .848 r
.45479 .56683 m
.47041 .55202 L
s
.43996 .55122 m
.45479 .56683 L
s
.47041 .55202 m
.45559 .5364 L
s
.45559 .5364 m
.43996 .55122 L
s
1 0 .304 r
.71334 .53388 m
.69475 .5471 L
s
.69475 .5471 m
.70739 .56691 L
s
1 0 .678 r
.64764 .40734 m
.65304 .41616 L
s
.65615 .38615 m
.64764 .40734 L
s
.64764 .40734 m
.63955 .39816 L
s
.6696 .40409 m
.64764 .40734 L
s
.68376 .37507 m
.64764 .40734 L
s
1 0 .304 r
.59979 .67981 m
.60298 .69854 L
s
.60888 .66501 m
.59979 .67981 L
s
.59979 .67981 m
.58972 .67907 L
s
.62209 .68447 m
.59979 .67981 L
s
.63181 .69003 m
.59979 .67981 L
s
1 0 .678 r
.30581 .71162 m
.30421 .69126 L
s
1 0 .304 r
.54334 .52193 m
.54604 .53772 L
s
.55076 .50387 m
.54334 .52193 L
s
.54334 .52193 m
.53181 .5182 L
s
.56495 .52338 m
.54334 .52193 L
s
.56977 .51598 m
.54334 .52193 L
s
.899 0 1 r
.38202 .66996 m
.37892 .6886 L
s
.36885 .66111 m
.38202 .66996 L
s
.38202 .66996 m
.36136 .67877 L
s
.38647 .67094 m
.38202 .66996 L
s
.33993 .69532 m
.38202 .66996 L
s
1 0 .678 r
.65615 .38615 m
.63955 .39816 L
s
.6696 .40409 m
.65615 .38615 L
s
.65304 .41616 m
.6696 .40409 L
s
1 0 .304 r
.60298 .69854 m
.62209 .68447 L
s
.62209 .68447 m
.60888 .66501 L
s
.58972 .67907 m
.60298 .69854 L
s
.60888 .66501 m
.58972 .67907 L
s
1 0 .678 r
.63955 .39816 m
.65304 .41616 L
s
.899 0 1 r
.36136 .67877 m
.37892 .6886 L
s
.36885 .66111 m
.36136 .67877 L
s
.37892 .6886 m
.38647 .67094 L
s
1 0 .304 r
.54604 .53772 m
.56495 .52338 L
s
.56495 .52338 m
.55076 .50387 L
s
.899 0 1 r
.38647 .67094 m
.36885 .66111 L
s
1 0 .304 r
.55076 .50387 m
.53181 .5182 L
s
.53181 .5182 m
.54604 .53772 L
s
1 0 .678 r
.45287 .64785 m
.45248 .66637 L
s
.45333 .6341 m
.45287 .64785 L
s
.45287 .64785 m
.43667 .64984 L
s
.46913 .65065 m
.45287 .64785 L
s
.45301 .6603 m
.45287 .64785 L
s
1 0 .15 r
.70785 .64768 m
.71291 .66657 L
s
.71966 .63152 m
.70785 .64768 L
s
.70785 .64768 m
.69975 .64576 L
s
.73276 .65231 m
.70785 .64768 L
s
.75189 .65477 m
.70785 .64768 L
s
.65092 .48634 m
.65554 .50211 L
s
.66098 .46682 m
.65092 .48634 L
s
.65092 .48634 m
.64125 .48125 L
s
.67521 .48766 m
.65092 .48634 L
s
.68928 .47651 m
.65092 .48634 L
s
.71291 .66657 m
.73276 .65231 L
s
.73276 .65231 m
.71966 .63152 L
s
1 0 .678 r
.45248 .66637 m
.46913 .65065 L
s
.43667 .64984 m
.45248 .66637 L
s
.46913 .65065 m
.45333 .6341 L
s
.45333 .6341 m
.43667 .64984 L
s
1 0 .15 r
.71966 .63152 m
.69975 .64576 L
s
.69975 .64576 m
.71291 .66657 L
s
.65554 .50211 m
.67521 .48766 L
s
.67521 .48766 m
.66098 .46682 L
s
.66098 .46682 m
.64125 .48125 L
s
.54388 .61945 m
.54648 .63824 L
s
.55178 .60228 m
.54388 .61945 L
s
.54388 .61945 m
.53152 .61766 L
s
.56668 .62284 m
.54388 .61945 L
s
.57131 .62367 m
.54388 .61945 L
s
.64125 .48125 m
.65554 .50211 L
s
.54648 .63824 m
.56668 .62284 L
s
.56668 .62284 m
.55178 .60228 L
s
.55178 .60228 m
.53152 .61766 L
s
.53152 .61766 m
.54648 .63824 L
s
1 0 0 r
.655 .58477 m
.65958 .60365 L
s
.66577 .5661 m
.655 .58477 L
s
.655 .58477 m
.64465 .58166 L
s
.68063 .58807 m
.655 .58477 L
s
.6952 .58531 m
.655 .58477 L
s
.65958 .60365 m
.68063 .58807 L
s
.68063 .58807 m
.66577 .5661 L
s
.66577 .5661 m
.64465 .58166 L
s
.64465 .58166 m
.65958 .60365 L
s
0 g
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006=0001[b000`400?l00000o`00003oo`3oool:
0?ooo`800000PP3oool00?l0oooo203oool2000000030?ooo`00000000000840oooo003o0?ooo`H0
oooo0P0000030?ooo`800000P@3oool00?l0oooo0`3oool3000000D0oooo00<000000?ooo`000000
P03oool00?l0oooo0@3oool2000000P0oooo00<000000?ooo`000000P03oool00?d0oooo0`00000:
0?ooo`040000003oool0oooo000007l0oooo003k0?ooo`8000003@3oool01@000000oooo0?ooo`3o
ool0000007h0oooo003i0?ooo`8000003`3oool01@000000oooo0?ooo`3oool0000007h0oooo003f
0?ooo`<000004@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07/0oooo003d0?oo
o`8000005@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07X0oooo003a0?ooo`<0
00005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo07X0oooo003_0?ooo`800000
5P3oool01@3o0000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3oool0N@3oool00>d0oooo
0P00000H0?ooo`050?l0003oool0oooo0?ooo`0000001@3oool00`000000oooo0?ooo`1i0?ooo`00
jP3oool3000001X0oooo00D0o`000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo07P0
oooo003X0?ooo`800000703oool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0M`3oool00>H0oooo0P00000N0?ooo`030?l0003oool0oooo0080oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1g0?ooo`00h`3oool300000200oooo00<0o`00
0?ooo`3oool00P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo07H0oooo003Q0?oo
o`8000008`3oool00`3o0000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool0M@3oool00=h0oooo0`00000T0?ooo`030?l0003oool0oooo00<0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`1e0?ooo`00g03oool2000002L0oooo00<0o`000?ooo`3oool0
0`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo07@0oooo003J0?ooo`800000:@3o
ool00`3o0000oooo0?ooo`030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0M03o
ool00=L0oooo0`00000[0?ooo`030?l0003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`1c0?ooo`00e@3oool2000002d0oooo00<0o`000?ooo`3oool0103oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo0780oooo003C0?ooo`800000;`3oool00`3o0000
oooo0?ooo`040?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0LP3oool00=00oooo
0`00000a0?ooo`030?l0003oool0oooo00@0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`1a0?ooo`00cP3oool2000003@0oooo00<0o`000?ooo`3oool01@3oool00`000000oooo0?oo
o`0;0?ooo`030000003oool0oooo0700oooo003;0?ooo`<00000=@3oool00`3o0000oooo0?ooo`06
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0L03oool00<T0oooo0P00000h0?oo
o`030?l0003oool0oooo00H0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1_0?oo
o`00a`3oool2000001H0oooo00<0o`0V0?ooo`3oool08@3oool00`3o0000oooo0?ooo`060?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0K`3oool00<@0oooo0`00000H0?ooo`030?l0
9P3oool0oooo0240oooo00<0o`000?ooo`3oool01P3oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo06h0oooo00320?ooo`8000006`3oool00`3o02H0oooo0?ooo`0P0?ooo`030?l0003o
ool0oooo00L0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1]0?ooo`00_`3oool3
000001`0oooo00<0o`0V0?ooo`3oool08@3oool00`3o0000oooo0?ooo`070?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool0K@3oool00;d0oooo0P00000O0?ooo`030?l09P3oool0oooo
0240oooo00<0o`000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
06`0oooo002k0?ooo`8000008@3oool00`3o02H0oooo0?ooo`0Q0?ooo`030?l0003oool0oooo00L0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1[0?ooo`00^03oool3000002<0oooo
00<0o`0V0?ooo`3oool0803oool00`3o0000oooo0?ooo`080?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0J`3oool00;H0oooo0P00000V0?ooo`030?l09P3oool0oooo0200oooo00<0
o`000?ooo`3oool0203oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo06X0oooo002d
0?ooo`8000009`3oool00`3o02H0oooo0?ooo`0Q0?ooo`030?l0003oool0oooo00P0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`1Z0?ooo`00/@3oool3000002T0oooo00<0o`0V0?oo
o`3oool08@3oool00`3o0000oooo0?ooo`080?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0J@3oool00:l0oooo0P00000/0?ooo`030?l09P3oool0oooo0200oooo00<0o`000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo06P0oooo002/0?ooo`<00000
;P3oool00`3o02H0oooo0?ooo`0P0?ooo`030?l0003oool0oooo00T0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`1X0?ooo`00ZP3oool200000300oooo00<0o`0V0?ooo`3oool08@3o
ool00`3o0000oooo0?ooo`090?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0I`3o
ool00:P0oooo0P00000b0?ooo`030?l09P3oool0oooo0240oooo00<0o`000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0D0?ooo`030000003oool0oooo06L0oooo002U0?ooo`<00000=03oool00`3o
02H0oooo0?ooo`0P0?ooo`030?l0003oool0oooo00/0oooo00<000000?ooo`3oool02P3oool00`3o
02H0oooo0?ooo`070?ooo`030000003oool0oooo06H0oooo002S0?ooo`800000=`3oool00`3o02H0
oooo0?ooo`0P0?ooo`030?l0003oool0oooo00L0oooo00D0o`0V0?ooo`3oool0oooo0000000<0?oo
o`030?l09P3oool0oooo00P0oooo00<000000?ooo`3oool0I@3oool00:40oooo0P00000E0?ooo`03
0?l0[@3oool0oooo0240oooo00<0o`0V0?ooo`3oool0803oool00`3o0000oooo0?ooo`070?ooo`05
0?l09P3oool0oooo0?ooo`0000002`3oool00`3o02H0oooo0?ooo`090?ooo`030000003oool0oooo
06D0oooo002N0?ooo`<000005`3oool00`3o0:d0oooo0?ooo`0P0?ooo`030?l09P3oool0oooo0240
oooo00<0o`000?ooo`3oool01P3oool00`3o02H0oooo0?ooo`020?ooo`030000003oool0oooo00T0
oooo00<0o`0V0?ooo`3oool02P3oool00`000000oooo0?ooo`1T0?ooo`00W03oool2000001X0oooo
00<0o`2]0?ooo`3oool0803oool00`3o02H0oooo0?ooo`0J0?ooo`<0o`000`3oool00`3o0000oooo
0?ooo`070?ooo`030?l09P3oool0oooo0080oooo00<000000?ooo`3oool02@3oool00`3o02H0oooo
0?ooo`0;0?ooo`030000003oool0oooo06<0oooo002I0?ooo`<00000703oool00`3o0:d0oooo0?oo
o`0P0?ooo`030?l09P3oool0oooo01X0oooo00<0o`000?ooo`3o0000103o00090?ooo`030?l09P3o
ool0oooo0080oooo00<000000?ooo`3oool02@3oool00`3o02H0oooo0?ooo`0;0?ooo`030000003o
ool0oooo06<0oooo002G0?ooo`8000007`3oool00`3o0:d0oooo0?ooo`0P0?ooo`030?l09P3oool0
oooo01/0oooo00@0o`000?ooo`3oool0oooo1P3o00050?ooo`030?l09P3oool0oooo0080oooo00<0
00000?ooo`3oool0203oool00`3o02H0oooo0?ooo`0=0?ooo`030000003oool0oooo0680oooo002E
0?ooo`8000008@3oool00`3o0:d0oooo0?ooo`0P0?ooo`030?l09P3oool0oooo01/0oooo00@0o`00
0?ooo`3oool0oooo0`3o00030?ooo`<0o`0000<0oooo0?l09P3oool0103oool00`000000oooo0?oo
o`080?ooo`030?l09P3oool0oooo00d0oooo00<000000?ooo`3oool0HP3oool00980oooo0`00000S
0?ooo`030?l0[@3oool0oooo01l0oooo00<0o`0V0?ooo`3oool07@3oool01P3o0000oooo0?ooo`3o
0000oooo0?l000@0oooo00@0o`000?ooo`3oool0o`0V1@3oool00`000000oooo0?ooo`080?ooo`03
0?l09P3oool0oooo00h0oooo00<000000?ooo`3oool0H@3oool00900oooo0P00000V0?ooo`030?l0
[@3oool0oooo01l0oooo00<0o`0V0?ooo`3oool07@3oool00`3o0000oooo0?ooo`020?l000<0oooo
0P3o00030?ooo`030?l09P3oool0oooo00<0oooo00<000000?ooo`3oool0203oool00`3o02H0oooo
0?ooo`0?0?ooo`030000003oool0oooo0600oooo002=0?ooo`<00000:03oool00`3o0:d0oooo0?oo
o`0O0?ooo`030?l09P3oool0oooo01d0oooo00<0o`000?ooo`3o00000P3o00020?ooo`030?l0003o
ool0oooo00<0oooo00<0o`0V0?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030?l09P3o
ool0oooo0100oooo00<000000?ooo`3oool0H03oool008/0oooo0P00000[0?ooo`030?l0[@3oool0
oooo01l0oooo00<0o`0V0?ooo`3oool07P3oool30?l00080oooo00<0o`000?ooo`3oool00`3oool0
0`3o02H0oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<0o`0V0?ooo`3oool04@3oool0
0`000000oooo0?ooo`1O0?ooo`00R@3oool2000002d0oooo00<0o`2]0?ooo`3oool07`3oool00`3o
02H0oooo0?ooo`0N0?ooo`D0o`001P3oool00`3o02H0oooo0?ooo`040?ooo`030000003oool0oooo
00L0oooo00<0o`0V0?ooo`3oool04P3oool00`000000oooo0?ooo`1N0?ooo`00QP3oool3000002l0
oooo00<0o`2]0?ooo`3oool07P3oool00`3o02H0oooo0?ooo`0P0?ooo`80o`00203oool00`3o02H0
oooo0?ooo`040?ooo`030000003oool0oooo00L0oooo00<0o`0V0?ooo`3oool04P3oool00`000000
oooo0?ooo`1N0?ooo`00Q03oool200000380oooo00<0o`2]0?ooo`3oool07P3oool00`3o02H0oooo
0?ooo`0P0?ooo`030?l0003oool0oooo00H0oooo00<0o`0V0?ooo`3oool01@3oool00`000000oooo
0?ooo`060?ooo`030?l09P3oool0oooo01@0oooo00<000000?ooo`3oool0G@3oool00880oooo0P00
000d0?ooo`030?l0[@3oool0oooo01h0oooo00<0o`0V0?ooo`3oool0:@3oool00`3o02H0oooo0?oo
o`050?ooo`030000003oool0oooo00H0oooo00<0o`0V0?ooo`3oool0503oool00`000000oooo0?oo
o`1M0?ooo`00O`3oool3000003H0oooo00<0o`2]0?ooo`3oool07P3oool00`3o02H0oooo0?ooo`0G
0?ooo`030?l0C@3oool0oooo00l0oooo00<0o`0V0?ooo`3oool01@3oool00`000000oooo0?ooo`06
0?ooo`030?l09P3oool0oooo01D0oooo00<000000?ooo`3oool0G03oool007d0oooo0P00000i0?oo
o`030?l0[@3oool0oooo01h0oooo00<0o`0V0?ooo`3oool0103oool00`3o04d0oooo0?ooo`0@0?oo
o`030?l0C@3oool0oooo00l0oooo00<0o`0V0?ooo`3oool01P3oool00`000000oooo0?ooo`050?oo
o`030?l09P3oool0oooo01H0oooo00<000000?ooo`3oool0F`3oool007X0oooo0`00000F0?ooo`03
0>H0o`3oool0oooo0280oooo00<0o`2]0?ooo`3oool07@3oool00`3o02H0oooo0?ooo`050?ooo`03
0?l0C@3oool0oooo0100oooo00<0o`1=0?ooo`3oool03P3oool00`3o02H0oooo0?ooo`070?ooo`03
0000003oool0oooo00@0oooo00<0o`0V0?ooo`3oool05`3oool00`000000oooo0?ooo`1K0?ooo`00
N03oool2000001T0oooo00<0iP3o0?ooo`3oool08P3oool00`3o0:d0oooo0?ooo`0M0?ooo`030?l0
9P3oool0oooo00D0oooo00<0o`1=0?ooo`3oool03`3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l0
9P3oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`3o02H0oooo0?ooo`0H0?ooo`030000
003oool0oooo05X0oooo001f0?ooo`800000703oool00`3V0?l0oooo0?ooo`0Q0?ooo`030?l0[@3o
ool0oooo01L0oooo1`3o02H60?ooo`030?l0C@3oool0oooo0100oooo00<0o`1=0?ooo`3oool03`3o
ool00`3o02H0oooo0?ooo`070?ooo`030000003oool0oooo00@0oooo00<0o`0V0?ooo`3oool06@3o
ool00`000000oooo0?ooo`1I0?ooo`00L`3oool3000001h0oooo00<0iP3o0?ooo`3oool08@3oool0
0`3o0:d0oooo0?ooo`0G0?ooo`030?l09P3oool0o`0V00P0o`0V0P3oool00`3o04d0oooo0?ooo`0@
0?ooo`030?l0C@3oool0oooo00l0oooo00<0o`0V0?ooo`3oool01`3oool00`000000oooo0?ooo`03
0?ooo`030?l09P3oool0oooo01X0oooo00<000000?ooo`3oool0F@3oool00740oooo0P00000Q0?oo
o`030>H0o`3oool0oooo0200oooo00<0o`2]0?ooo`3oool06@3oool0103o02H0oooo0?ooo`3oool8
0?l09P030?l0C@3oool0oooo0100oooo00<0o`1=0?ooo`3oool03P3oool00`3o02H0oooo0?ooo`08
0?ooo`030000003oool0oooo00<0oooo00<0o`0V0?ooo`3oool06`3oool00`000000oooo0?ooo`1H
0?ooo`00K`3oool2000002@0oooo00<0iP3o0?ooo`3oool07`3oool00`3o0:d0oooo0?ooo`0I0?oo
o`070?l09P3oool0oooo0?ooo`3o02H0oooo0?l09P030?ooo`030?l09P3oool0o`1=0140oooo00<0
o`1=0?ooo`3oool03`3oool00`3o02H0oooo0?ooo`080?ooo`030000003oool0oooo00<0oooo00<0
o`0V0?ooo`3oool06`3oool00`000000oooo0?ooo`1H0?ooo`00K03oool3000002H0oooo00<0iP3o
0?ooo`3oool07`3oool00`3o0:d0oooo0?ooo`0J0?ooo`030?l09P3oool0oooo0080o`0V0`3oool0
103o02H0oooo0?ooo`3o04dA0?ooo`030?l0C@3oool0oooo00l0oooo00<0o`0V0?ooo`3oool0203o
ool00`000000oooo0?ooo`030?ooo`030?l09P3oool0oooo01`0oooo00<000000?ooo`3oool0E`3o
ool006X0oooo0P00000Z0?ooo`030>H0o`3oool0oooo01h0oooo00<0o`2]0?ooo`3oool06P3oool0
0`3o02H0oooo0?l09P020?l09P80oooo00@0o`0V0?ooo`3oool0o`1=4P3oool00`3o04d0oooo0?oo
o`0>0?ooo`030?l09P3oool0oooo00T0oooo00<000000?ooo`3oool00P3oool00`3o02H0oooo0?oo
o`0N0?ooo`030000003oool0oooo05H0oooo001W0?ooo`<00000;03oool00`3V0?l0oooo0?ooo`0N
0?ooo`030?l0[@3oool0oooo01/0oooo0`3o02H00`3oool0o`0V0?l09P030?ooo`030?l0C@3oool0
oooo0100oooo00<0o`1=0?ooo`3oool03P3oool00`3o02H0oooo0?ooo`090?ooo`030000003oool0
oooo0080oooo00<0o`0V0?ooo`3oool07P3oool00`000000oooo0?ooo`1F0?ooo`00I@3oool20000
02l0oooo00<0iP3o0?ooo`3oool07P3oool00`3o0:d0oooo0?ooo`0K0?ooo`@0o`0V1@3oool00`3o
04d0oooo0?ooo`0@0?ooo`030?l0C@3oool0oooo00h0oooo00<0o`0V0?ooo`3oool02@3oool00`00
0000oooo0?ooo`020?ooo`030?l09P3oool0oooo01l0oooo00<000000?ooo`3oool0E@3oool006<0
oooo0P00000b0?ooo`030>H0o`3oool0oooo01d0oooo00<0o`2]0?ooo`3oool0703oool20?l09PH0
oooo00<0o`1=0?ooo`3oool03`3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l09P3oool0oooo00T0
oooo00<000000?ooo`3oool00P3oool00`3o02H0oooo0?ooo`0F0?ooo`030?l0[@3oool0oooo00L0
oooo00<000000?ooo`3oool0E03oool00600oooo0`00000d0?ooo`030>H0o`3oool0oooo01d0oooo
00<0o`2]0?ooo`3oool0703oool00`3o02H0oooo0?ooo`040?ooo`030?l0C@3oool0oooo0100oooo
00<0o`1=0?ooo`3oool03P3oool00`3o02H0oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`3o
02H06@3oool00`3o0:d0oooo0?ooo`070?ooo`030000003oool0oooo05@0oooo001N0?ooo`800000
=`3oool00`3V0?l0oooo0?ooo`0M0?ooo`030?l0[@3oool0oooo02<0oooo00<0o`1=0?ooo`3oool0
403oool00`3o04d0oooo0?ooo`0>0?ooo`030?l09P3oool0oooo00X0oooo00D000000?ooo`3oool0
oooo0?l09P0H0?ooo`030?l0[@3oool0oooo00T0oooo00<000000?ooo`3oool0D`3oool005/0oooo
0`00000j0?ooo`030>H0o`3oool0oooo01`0oooo00<0o`2]0?ooo`3oool04`3oool00`3o0=T0oooo
0?ooo`0=0?ooo`030?l0C@3oool0oooo0100oooo00<0o`1=0?ooo`3oool03P3oool00`3o02H0oooo
0?ooo`0:0?ooo`050000003oool0oooo0?ooo`3o02H02P3oool00`3o04d0oooo0?ooo`0;0?ooo`03
0?l0[@3oool0oooo00T0oooo00<000000?ooo`3oool0D`3oool005T0oooo0P00000m0?ooo`030>H0
o`3oool0oooo01`0oooo00<0o`2]0?ooo`3oool04`3oool00`3o0=T0oooo0?ooo`0=0?ooo`030?l0
C@3oool0oooo00l0oooo00<0o`1=0?ooo`3oool03`3oool00`3o02H0oooo0?ooo`070?ooo`<0o`0V
00D000000?l09P3o02H0oooo0?l09P0:0?ooo`030?l0C@3oool0oooo00X0oooo00<0o`2]0?ooo`3o
ool02`3oool00`000000oooo0?ooo`1B0?ooo`00E`3oool2000001H0oooo00<0o`2]0?ooo`3oool0
9P3oool00`3V0?l0oooo0?ooo`0L0?ooo`030?l0[@3o0=T0oooo01<0oooo00<0o`3I0?ooo`3oool0
3@3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l0C@3oool0oooo00h0oooo00<0o`0V0?ooo`3oool0
203oool01@3o02H0oooo0?l09P3o02H0000000<0o`0V2@3oool00`3o04d0oooo0?ooo`0;0?ooo`03
0?l0[@3oool0oooo00`0oooo00<000000?ooo`3oool0D@3oool005@0oooo0`00000I0?ooo`030?l0
[@3oool0oooo02H0oooo00<0iP3o0?ooo`3oool05P3oool60?l0[@030?l0f@3o0:d0o`2]00<0o`2]
3`3oool00`3o0=T0oooo0?ooo`0<0?ooo`030?l0C@3oool0oooo0100oooo00<0o`1=0?ooo`3oool0
3P3oool00`3o02H0oooo0?ooo`080?ooo`060?l0[@3o02H0oooo0?ooo`000000oooo1@3o02H60?oo
o`030?l0C@3oool0oooo00X0oooo00<0o`2]0?ooo`3oool03@3oool00`000000oooo0?ooo`1A0?oo
o`00DP3oool2000001d0oooo00<0o`2]0?ooo`3oool09@3oool00`3V0?l0oooo0?ooo`0G0?ooo`06
0?l0[@3oool0oooo0?ooo`3o0:d0o`3I0`3oool00`3o0:d0oooo0?ooo`0>0?ooo`030?l0f@3oool0
oooo00`0oooo00<0o`1=0?ooo`3oool0403oool00`3o04d0oooo0?ooo`080?ooo`L0o`0V2P3oool0
1P3o0:d0o`0V0?ooo`3oool000000?ooo`80o`0V0P3oool30?l09P@0oooo00<0o`1=0?ooo`3oool0
2P3oool00`3o0:d0oooo0?ooo`0>0?ooo`030000003oool0oooo0500oooo001@0?ooo`800000803o
ool00`3o0:d0oooo0?ooo`0U0?ooo`030>H0o`3oool0oooo01H0oooo00H0o`2]0?ooo`3oool0oooo
0?l0[@3o0=T20?ooo`030?l0[@3oool0oooo00l0oooo00<0o`3I0?ooo`3oool0303oool00`3o04d0
oooo0?ooo`0?0?ooo`030?l0C@3oool0oooo00T0oooo00<0o`0V0?ooo`3o02H01`3o02H60?ooo`08
0?l0[@3oool0oooo0?l09P3oool000000?ooo`3o02H40?ooo`030?l09P3oool0oooo0080oooo00<0
o`1=0?ooo`3oool02`3oool00`3o0:d0oooo0?ooo`0?0?ooo`030000003oool0oooo04l0oooo001=
0?ooo`<000008P3oool00`3o0:d0oooo0?ooo`0U0?ooo`030>H0o`3oool0oooo01L0oooo00D0o`2]
0?ooo`3oool0o`2]0?l0f@020?ooo`030?l0[@3oool0oooo00l0oooo00<0o`3I0?ooo`3oool0303o
ool00`3o04d0oooo0?ooo`0?0?ooo`030?l0C@3oool0oooo00X0oooo00<0o`0V0?ooo`3oool02@3o
02H30?ooo`060?l0[@3oool0oooo0?l09P3oool000000P3o02H30?ooo`030?l09P3oool0oooo00<0
oooo00<0o`1=0?ooo`3oool02P3oool00`3o0:d0oooo0?ooo`0@0?ooo`030000003oool0oooo04l0
oooo001;0?ooo`8000009P3oool00`3o0:d0oooo0?ooo`0T0?ooo`030>H0o`3oool0oooo01L0oooo
00L0o`2]0?ooo`3oool0o`2]0?l0f@3oool0o`2]0180oooo00<0o`3I0?ooo`3oool0303oool00`3o
04d0oooo0?ooo`0?0?ooo`030?l0C@3oool0oooo00X0oooo00<0o`0V0?ooo`3oool00`3o02H40?oo
o`030?l09P3oool0oooo0080oooo00L0o`2]0?ooo`3oool0o`0V0?ooo`000000o`0V00<0oooo00<0
o`0V0?ooo`3oool0103oool00`3o04d0oooo0?ooo`0:0?ooo`030?l0[@3oool0oooo0140oooo00<0
00000?ooo`3oool0CP3oool004P0oooo0`00000Y0?ooo`030?l0[@3oool0oooo02@0oooo00<0iP3o
0?ooo`3oool05`3oool01@3o0:d0oooo0?l0[@3o0=T0o`2]01<0oooo00<0o`3I0?ooo`3oool02`3o
ool00`3o04d0oooo0?ooo`0@0?ooo`030?l0C@3oool0oooo00X0oooo00<0o`0V0?ooo`3oool00`3o
02H30?ooo`030?l09P3oool0oooo0080oooo00<0o`2]0?ooo`3oool00P3oool0103o02H000000?l0
9P3oool20?l09PH0oooo00<0o`1=0?ooo`3oool02P3oool00`3o0:d0oooo0?ooo`0B0?ooo`030000
003oool0oooo04h0oooo00160?ooo`800000;@3oool00`3o0:d0oooo0?ooo`0S0?ooo`030>H0o`3o
ool0oooo01P0oooo0P3o0:d00`3o0=T0oooo0?ooo`0A0?ooo`030?l0f@3oool0oooo00`0oooo00<0
o`1=0?ooo`3oool0403oool00`3o04d0oooo0?ooo`0:0?ooo`030?l09P3oool0o`0V0080o`0V0`3o
ool00`3o02H0oooo0?ooo`030?ooo`030?l0[@3oool0oooo0080oooo00@0o`0V0000003o02H0o`0V
203oool00`3o04d0oooo0?ooo`0:0?ooo`030?l0[@3oool0oooo01<0oooo00<000000?ooo`3oool0
C@3oool004@0oooo0P00000`0?ooo`030?l0[@3oool0oooo0280oooo00<0iP3o0?ooo`3oool0603o
ool20?l0[@030?l0f@3oool0oooo0140oooo00<0o`3I0?ooo`3oool0303oool00`3o04d0oooo0?oo
o`0?0?ooo`030?l0C@3oool0oooo00`0oooo103o02H00`3oool0o`0V0?l09P060?ooo`030?l0[@3o
ool0oooo00<0oooo00<000000?l09P3oool0203oool00`3o04d0oooo0?ooo`090?ooo`030?l0[@3o
ool0oooo01D0oooo00<000000?ooo`3oool0C03oool00440oooo0`00000c0?ooo`030?l0[@3oool0
oooo0280oooo00<0iP3o0?ooo`3oool0603oool00`3o0:d0o`3I0?ooo`0B0?ooo`030?l0f@3oool0
oooo00`0oooo00<0o`1=0?ooo`3oool03`3oool00`3o04d0oooo0?ooo`0<0?ooo`<0o`0V00<0oooo
0?l09P3oool01P3oool00`3o0:d0oooo0?ooo`040?ooo`030000003oool0oooo00P0oooo00<0o`1=
0?ooo`3oool02@3oool00`3o0:d0oooo0?ooo`0E0?ooo`030000003oool0oooo04`0oooo000o0?oo
o`800000=`3oool00`3o0:d0oooo0?ooo`0Q0?ooo`040>H0o`3oool0oooo0?ooo`80iP3o5P3oool0
0`3o0=T0oooo0?ooo`0A0?ooo`030?l0f@3oool0oooo00`0oooo00<0o`1=0?ooo`3oool03`3oool0
0`3o04d0oooo0?ooo`0<0?ooo`@0o`0V1P3oool00`3o0=T0oooo0?l0[@060?ooo`030000003oool0
oooo00L0oooo00<0o`1=0?ooo`3oool02P3oool00`3o0:d0oooo0?ooo`0F0?ooo`030000003oool0
oooo04/0oooo000m0?ooo`800000>@3oool00`3o0:d0oooo0?ooo`0Q0?ooo`@0iP3o00<0oooo0>H0
o`3oool05@3oool00`3o0=T0oooo0?ooo`0A0?ooo`030?l0f@3oool0oooo00/0oooo00<0o`1=0?oo
o`3oool0403oool00`3o04d0oooo0?ooo`0=0?ooo`80o`0V1`3oool00`3o0=T0oooo0?l0[@060?oo
o`030000003oool0oooo00L0oooo00<0o`1=0?ooo`3oool02@3oool00`3o0:d0oooo0?ooo`0G0?oo
o`030000003oool0oooo04/0oooo000j0?ooo`<00000?03oool00`3o0:d0oooo0?ooo`0N0?ooo`D0
iP3o00<0oooo0>H0o`3oool01`3oool00`2f0?l0oooo0?ooo`0<0?ooo`030?l0f@3oool0oooo0140
oooo00<0o`3I0?ooo`3oool02`3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l0C@3oool0oooo00h0
oooo00<0o`0V0?ooo`3oool01@3oool0103o0=T0oooo0?ooo`3o0:d60?ooo`030000003oool0oooo
00L0oooo00<0o`1=0?ooo`3oool02@3oool00`3o0:d0oooo0?ooo`0H0?ooo`030000003oool0oooo
04X0oooo000h0?ooo`800000@03oool00`3o0:d0oooo0?ooo`0K0?ooo`80iP3o0P3oool30>H0o`03
0?ooo`3V0?l0oooo00L0oooo00<0]P3o0?ooo`3oool0303oool00`3o0=T0oooo0?ooo`0A0?ooo`03
0?l0f@3oool0oooo00/0oooo00<0o`1=0?ooo`3oool02@3oool20?l0C@@0oooo00<0o`1=0?ooo`3o
ool01@3oool00`3o07H0oooo0?ooo`0>0?ooo`030?l0f@3oool0o`2]00L0oooo00<000000?ooo`3o
ool01P3oool00`3o04d0oooo0?ooo`090?ooo`030?l0[@3oool0oooo01X0oooo00<000000?ooo`3o
ool0B@3oool003D0oooo0`00000D0?ooo`030?l09P3oool0oooo02`0oooo00<0o`2]0?ooo`3oool0
6`3oool20>H0o`060?ooo`3V0?l0oooo0>H0o`3oool0iP3o2@3oool00`2f0?l0oooo0?ooo`0;0?oo
o`030?l0f@3oool0oooo0140oooo00<0o`3I0?ooo`3oool02`3oool00`3o04d0oooo0?ooo`090?oo
o`030?l0C@3oool0o`1=00@0o`1=1`3oool00`3o07H0oooo0?ooo`0=0?ooo`040?l0f@3oool0oooo
0?l0[@L0oooo00<000000?ooo`3oool01P3oool00`3o04d0oooo0?ooo`090?ooo`030?l0[@3oool0
oooo01X0oooo00<000000?ooo`3oool0B@3oool003<0oooo0P00000H0?ooo`030?l09P3oool0oooo
02`0oooo00<0o`2]0?ooo`3oool0703oool00`3V0?l0oooo0>H0o`030>H0o`T0oooo00<0]P3o0?oo
o`3oool02`3oool00`3o0=T0oooo0?ooo`0A0?ooo`030?l0f@3oool0oooo00/0oooo00<0o`1=0?oo
o`3oool02P3oool00`3o04d0oooo0?ooo`060?l0C@<0oooo00<0o`1f0?ooo`3oool03P3oool0103o
0=T0oooo0?ooo`3o0:d70?ooo`030000003oool0oooo00H0oooo00<0o`1=0?ooo`3oool0203oool0
0`3o0:d0oooo0?ooo`0L0?ooo`030000003oool0oooo04P0oooo000a0?ooo`8000006`3oool00`3o
02H0oooo0?ooo`0/0?ooo`030?l0[@3oool0oooo0140oooo00<0]P3o0?ooo`3oool0203oool0103V
0?l0oooo0>H0o`3V0?l:0?ooo`030;H0o`3oool0oooo00/0oooo00<0o`3I0?ooo`3oool04@3oool0
0`3o0=T0oooo0?ooo`0:0?ooo`030?l0C@3oool0oooo00/0oooo00D0o`1=0?ooo`3oool0o`1=0?oo
o`060?l0C@030?ooo`3o07H0oooo00l0oooo00<0o`3I0?ooo`3o0:d0203oool00`000000oooo0?oo
o`050?ooo`030?l0C@3oool0oooo00T0oooo00<0o`2]0?ooo`3oool07@3oool00`000000oooo0?oo
o`170?ooo`00;P3oool3000001h0oooo0P3o02H]0?ooo`030?l0[@3oool0oooo0100oooo00<0]P3o
0?ooo`3oool02@3oool30>H0o`/0oooo00<0]P3o0?ooo`3oool02P3oool00`3o0=T0oooo0?ooo`0A
0?ooo`030?l0f@3oool0oooo00<0oooo203o04d60?ooo`030?l0f@3oool0oooo00D0oooo00H0o`1=
0?ooo`3o04d0o`1=0?ooo`3o04d20?ooo`040?l0C@3oool0oooo0?l0MPl0oooo00@0o`3I0?ooo`3o
ool0o`2]2@3oool00`000000oooo0?ooo`040?ooo`030?l0C@3oool0oooo00T0oooo00<0o`2]0?oo
o`3oool07@3oool00`000000oooo0?ooo`170?ooo`00;03oool2000002<0oooo00<0o`0V0?ooo`3o
ool0:P3oool00`3o0:d0oooo0?ooo`0A0?ooo`030;H0o`3oool0oooo00X0oooo00<0iP3o0?ooo`3o
ool02@3oool00`2f0?l0oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo0140oooo00<0o`3I0?ooo`3o
ool00`3oool01`3o04d0oooo0?l0C@3o04d0oooo0?l0C@3oool0103o04d30?ooo`030?l0f@3oool0
oooo00D0oooo00<0o`1=0?ooo`3o04d00P3o04d20?ooo`050?l0C@3oool0oooo0?ooo`3o07H03`3o
ool0103o0=T0oooo0?ooo`3o0:d90?ooo`030000003oool0oooo00@0oooo00<0o`1=0?ooo`3oool0
203oool00`3o0:d0oooo0?ooo`0O0?ooo`030000003oool0oooo04H0oooo000Y0?ooo`<000009P3o
ool00`3o02H0oooo0?ooo`0Z0?ooo`030?l0[@3oool0oooo00<0oooo00<0o`2]0?ooo`3oool02P3o
ool00`2f0?l0oooo0?ooo`0F0?ooo`030;H0o`3oool0oooo00X0oooo00<0o`3I0?ooo`3oool04@3o
ool00`3o0=T0oooo0?ooo`040?ooo`030?l0C@3oool0oooo0080o`1=00@0oooo0?l0C@3oool0oooo
0`3o04d00`3oool0o`3I0?ooo`060?ooo`030?l0C@3oool0o`1=0080o`1=00<0oooo0?l0C@3oool0
0P3oool00`3o07H0oooo0?ooo`0>0?ooo`030?l0f@3oool0o`2]00X0oooo00<000000?ooo`3oool0
0`3oool00`3o04d0oooo0?ooo`090?ooo`030?l0[@3oool0oooo01l0oooo00<000000?ooo`3oool0
AP3oool002L0oooo0P00000Z0?ooo`030?l09P3oool0oooo02X0oooo00@0o`2]0?ooo`3oool0oooo
0`3o0:d<0?ooo`030;H0o`3oool0oooo01H0oooo00<0]P3o0?ooo`3oool0203oool00`3o0=T0oooo
0?ooo`0B0?ooo`030?l0f@3oool0oooo00@0oooo00@0o`1=0?ooo`3oool0oooo1@3o04d0103oool0
o`1=0?ooo`3o0=T90?ooo`<0o`1=00<0oooo0?l0C@3oool00`3oool00`3o07H0oooo0?ooo`0=0?oo
o`040?l0f@3oool0oooo0?l0[@X0oooo00<000000?ooo`3oool00`3oool00`3o04d0oooo0?ooo`08
0?ooo`030?l0[@3oool0oooo0240oooo00<000000?ooo`3oool0A@3oool002D0oooo0P00000]0?oo
o`030?l09P3oool0oooo02X0oooo00@0o`2]0?ooo`3o0:d0oooo0P3o0:d<0?ooo`030;H0o`3oool0
oooo01H0oooo00<0]P3o0?ooo`3oool0203oool00`3o0=T0oooo0?ooo`0B0?ooo`030?l0f@3oool0
oooo00D0oooo00<0o`1=0?ooo`3oool00`3o04d20?ooo`040?l0C@3oool0oooo0?l0f@T0oooo103o
04d50?ooo`030?l0MP3oool0oooo00d0oooo00@0o`3I0?ooo`3oool0o`2]2P3oool00`000000oooo
0?ooo`030?ooo`030?l0C@3oool0oooo00<0oooo00<0o`2]0?ooo`3oool00P3oool00`3o0:d0oooo
0?ooo`0R0?ooo`030000003oool0oooo04@0oooo000S0?ooo`800000<03oool20?l09RX0oooo0P3o
0:d0103oool0o`2]0?ooo`3o0:d<0?ooo`030;H0o`3oool0oooo01H0oooo00<0]P3o0?ooo`3oool0
203oool00`3o0=T0oooo0?ooo`0B0?ooo`030?l0f@3oool0oooo00D0oooo00<0o`1=0?ooo`3oool0
0P3o04d20?ooo`050?l0C@3oool0oooo0?ooo`3o0=T02P3oool20?l0C@H0oooo00<0o`1f0?ooo`3o
ool0303oool0103o0=T0oooo0?ooo`3o0:d;0?ooo`030000003oool0oooo0080oooo00<0o`1=0?oo
o`3oool0103oool30?l0[@030?ooo`3o0:d0oooo01/0oooo00<0iP3o0?ooo`3oool01P3oool00`00
0000oooo0?ooo`140?ooo`008`3oool200000380oooo00<0o`0V0?ooo`3oool09P3oool0103o0:d0
oooo0?l0[@3o0:d20?ooo`030?l0[@3oool0oooo00/0oooo00<0]P3o0?ooo`3oool05P3oool00`2f
0?l0oooo0?ooo`070?ooo`030?l0f@3oool0oooo0180oooo00<0o`3I0?ooo`3oool01P3oool01P3o
04d0oooo0?l0C@3o04d0oooo0?l0C@@0oooo00<0o`3I0?ooo`3oool0203oool00`3o04d0oooo0?oo
o`040?ooo`030?l0MP3oool0oooo00d0oooo00@0o`3I0?ooo`3oool0o`2]2`3oool00`000000oooo
0?ooo`020?ooo`030?l0C@3oool0oooo00@0oooo00<0o`2]0?ooo`3o0:d00P3o0:dK0?ooo`030>H0
o`3oool0oooo00P0oooo00<000000?ooo`3oool0@`3oool002<0oooo00<000000?ooo`000000<P3o
ool00`3o02H0oooo0?ooo`0T0?ooo`030?l0[@3oool0o`2]0080oooo00<0o`2]0?ooo`3o0:d03@3o
ool00`2f0?l0oooo0?ooo`0F0?ooo`030;H0o`3oool0oooo00L0oooo00<0o`3I0?ooo`3oool04P3o
ool00`3o0=T0oooo0?ooo`060?ooo`060?l0C@3oool0o`1=0?l0C@3oool0o`1=0`3oool0103o0=T0
oooo0?ooo`2;0?l?0?ooo`030?l0MP3oool0oooo00d0oooo00@0o`3I0?ooo`3oool0o`2]2`3oool0
0`000000oooo0?ooo`020?ooo`030?l0C@3oool0oooo00@0oooo00@0o`2]0?ooo`3o0:d0oooo103o
0:dG0?ooo`030>H0o`3oool0oooo00X0oooo00<000000?ooo`3oool0@P3oool002<0oooo00@00000
0?ooo`3oool00000<P3oool00`3o02H0oooo0?ooo`0T0?ooo`80o`2]0P3oool0103o0:d0oooo0?l0
[@3o0:d=0?ooo`030;H0o`3oool0oooo01D0oooo00<0]P3o0?ooo`3oool01`3oool00`3o0=T0oooo
0?ooo`0A0?ooo`030?l0f@3oool0oooo00P0oooo103o04d40?ooo`040?l0f@3oool0oooo08/0o`l0
oooo00<0o`1f0?ooo`3oool0303oool0103o0=T0oooo0?ooo`3o0:d<0?ooo`050000003oool0oooo
0?ooo`3o04d01`3oool01P3o0:d0oooo0?l0[@3o0:d0oooo0?l0[@80oooo0P3o0:dD0?ooo`030>H0
o`3oool0oooo00/0oooo00<000000?ooo`3oool0@P3oool00280oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`0`0?ooo`030?l09P3oool0oooo02D0oooo0P3o0:d0103oool0o`2]0?l0
f@3o0:d=0?ooo`030;H0o`3oool0oooo01H0oooo00<0]P3o0?ooo`3oool01P3oool00`3o0=T0oooo
0?ooo`0A0?ooo`030?l0f@3oool0oooo00P0oooo0`3o04d50?ooo`040?l0f@3oool0oooo08/0o`l0
oooo00<0o`1f0?ooo`3oool0303oool0103o0=T0oooo0?ooo`3o0:d<0?ooo`050000003oool0oooo
0?ooo`3o04d0203oool40?l0[@80oooo0P3o0:d:0?ooo`030?l0f@3oool0oooo00P0oooo00<0iP3o
0?ooo`3oool0303oool00`000000oooo0?ooo`110?ooo`008P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0300oooo0P3o02HW0?ooo`@0o`2]3@3oool00`2f0?l0oooo0?ooo`0F0?oo
o`030;H0o`3oool0oooo00H0oooo00<0o`3I0?ooo`3oool0303oool<0?l0f@D0oooo00<0o`1=0?oo
o`3oool0103oool00`3o0=T0oooo08/0o`0?0?ooo`030?l0MP3oool0oooo00`0oooo00D0o`3I0?oo
o`3oool0oooo0?l0[@0<0?ooo`050000003oool0oooo0?ooo`3o04d0203oool30?l0[@80oooo00<0
o`2]0?ooo`3oool02P3oool00`3o0=T0oooo0?ooo`070?ooo`030>H0o`3oool0oooo00d0oooo00<0
00000?ooo`3oool0@@3oool00280oooo00<000000?ooo`3oool0103oool00`000000oooo0?l0000a
0?ooo`030?l09P3oool0oooo02H0oooo0P3o0:d00`3o0=T0oooo0?ooo`0;0?ooo`030;H0o`3oool0
oooo01D0oooo00<0]P3o0?ooo`3oool01P3oool00`3o0=T0oooo0?ooo`0=0?ooo`040?l0f@3oool0
oooo0?ooo`80o`3I00@0nP3o0?ooo`3oool0o`3I303oool0103o0=T0oooo0?ooo`2;0?l?0?ooo`03
0?l0MP3oool0oooo00`0oooo00@0o`3I0?ooo`3oool0o`2]3@3oool010000000oooo0?ooo`3o04d9
0?ooo`D0o`2]303oool00`3o0=T0oooo0?ooo`070?ooo`030>H0o`3oool0oooo00l0oooo00<00000
0?ooo`3oool0@03oool00280oooo00<000000?ooo`3oool01@3oool00`000000oooo0?l0000a0?oo
o`030?l09P3oool0oooo02P0oooo00<0o`3I0?ooo`3oool02P3oool00`2f0?l0oooo0?ooo`0E0?oo
o`030;H0o`3oool0oooo00H0oooo00<0o`3I0?ooo`3oool03@3oool0103o0=T0oooo0?ooo`3oool2
0?l0f@030?X0o`3oool0o`3I00d0oooo00@0o`3I0?ooo`3oool0R`3o3`3oool00`3o07H0oooo0?oo
o`0;0?ooo`<0o`2]00<0oooo0?l0[@3oool02@3oool30?l0C@040000003o04d0o`1=0?l0C@T0oooo
0`3o0:d>0?ooo`030?l0f@3oool0oooo00H0oooo00<0iP3o0?ooo`3oool04@3oool00`000000oooo
0?ooo`0o0?ooo`008P3oool00`000000oooo0?ooo`060?ooo`040000003oool0o`000?l00300oooo
00<0o`0V0?ooo`3oool0103oool00`3o02H0oooo0?ooo`030?ooo`030?l0f@3oool0oooo01X0oooo
00<0o`3I0?ooo`3oool02`3oool00`2f0?l0oooo0?ooo`0E0?ooo`030;H0o`3oool0oooo00D0oooo
00<0o`3I0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`020?l0f@030?X0o`3o0=T0oooo00d0oooo
00@0o`3I0?ooo`3oool0R`3o3`3oool00`3o07H0oooo0?ooo`080?ooo`<0o`2]00<0o`3I0?ooo`3o
0:d00P3o0:d:0?ooo`060?l0C@3oool0o`1=0000003o04d0oooo0P3o04d80?ooo`030?l0[@3oool0
oooo00d0oooo00<0o`3I0?ooo`3oool01P3oool00`3V0?l0oooo0?ooo`0B0?ooo`030000003oool0
oooo03l0oooo000R0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool0o`00<03oool0
0`3o02H0oooo0?ooo`020?ooo`<0o`0V1@3oool00`3o0=T0oooo0?ooo`0J0?ooo`030?l0f@3oool0
oooo00X0oooo00<0]P3o0?ooo`3oool05@3oool00`2f0?l0oooo0?l0f@0;0?l0f@`0oooo00H0o`3I
0?ooo`3o0=T0oooo0?X0o`3o0=T>0?ooo`040?l0f@3oool0oooo08/0o`h0oooo00<0o`1f0?ooo`3o
ool02@3oool30?l0[@040?l0f@3oool0o`2]0?ooo`<0o`2]2@3oool00`3o04d0oooo000000030?l0
C@030?ooo`3o04d0o`1=00P0oooo00<0o`3I0?ooo`3oool02`3oool00`3o0=T0oooo0?ooo`050?oo
o`030>H0o`3oool0oooo01@0oooo00<000000?ooo`3oool0?P3oool00240oooo00<000000?ooo`3o
ool02@3oool010000000oooo0?ooo`3o000`0?ooo`80o`0V0P3oool0103o02H0oooo0?l09P3o02H5
0?ooo`030?l0f@3oool0oooo01X0oooo00<0o`3I0?ooo`3oool02@3oool00`2f0?l0oooo0?ooo`0E
0?ooo`050;H0o`3oool0oooo0?l0f@3oool01P3o0=T00`3oool0o`3I0?ooo`0=0?ooo`80o`3I00<0
oooo0?X0o`3oool03@3oool0103o0=T0oooo0?ooo`2;0?l?0?ooo`030?l0MP3oool0oooo00X0oooo
00<0o`2]0?ooo`3o0:d00`3o0:d30?ooo`80o`2]1`3oool00`3o04d0oooo000000080?l0C@H0oooo
00<0o`3I0?ooo`3oool02P3oool00`3o0=T0oooo0?ooo`060?ooo`030>H0o`3oool0oooo01D0oooo
00<000000?ooo`3oool0?@3oool00240oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`020?l00300oooo0P3o02H20?ooo`80o`0V1P3oool00`3o0=T0oooo0?ooo`0J0?ooo`030?l0f@3o
ool0oooo00T0oooo00<0]P3o0?ooo`3oool05@3oool00`2f0?l0oooo0?l0f@040?ooo`0508/0o`3o
ool0oooo0?ooo`3o0=T03P3oool30?l0f@030?X0o`3oool0oooo00`0oooo00@0o`3I0?ooo`3oool0
R`3o3`3oool00`3o07H0oooo0?ooo`0:0?ooo`040?l0[@3o0=T0oooo0?ooo`80o`2]0`3oool30?l0
[@H0oooo00@0o`1=0?ooo`3oool000000P3o04d30?ooo`030?l0C@3oool0oooo00@0oooo00<0o`3I
0?ooo`3oool02`3oool00`3o0=T0oooo0?ooo`050?ooo`030>H0o`3oool0oooo01H0oooo00<00000
0?ooo`3oool0?@3oool00240oooo00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0
o`0002l0oooo0P3o02H00`3oool0o`0V0?ooo`020?l09PH0oooo00<0o`3I0?ooo`3oool06P3oool0
0`3o0=T0oooo0?ooo`080?ooo`030;H0o`3oool0oooo01D0oooo00@0]P3o0?ooo`3oool0o`3I0`3o
ool0102;0?l0oooo0?ooo`3o0=T@0?ooo`030?l0f@3oool0nP3o00h0oooo00@0o`3I0?ooo`3oool0
R`3o3`3oool00`3o07H0oooo0?ooo`0;0?ooo`040?l0[@3oool0o`2]0?ooo`@0o`2]00<0oooo0?l0
[@3oool01P3oool0103o04d0oooo0?l0C@0000020?l0C@80oooo00<0o`1=0?ooo`3oool01@3oool0
0`3o0=T0oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo00D0oooo00<0iP3o0?ooo`3oool0603oool0
0`000000oooo0?ooo`0l0?ooo`008@3oool00`000000oooo0?ooo`0<0?ooo`050000003oool0oooo
0?ooo`3o0000;@3oool0103o02H0oooo0?ooo`3o02H20?ooo`80o`0V1P3oool00`3o0=T0oooo0?oo
o`0K0?ooo`030?l0f@3oool0oooo00P0oooo00<0]P3o0?ooo`3oool0503oool02P2f0?l0oooo0?oo
o`3oool0o`3I0;H0o`3oool0R`3o0?ooo`3o0=TC0?ooo`030?X0o`3oool0oooo00`0oooo00@0o`3I
0?ooo`3oool0R`3o3P3oool00`3o07H0oooo0?ooo`060?ooo`80o`3I0`3oool00`3o0=T0o`2]0?oo
o`030?l0[@80oooo0P3o0:d90?ooo`80o`1=00D000000?l0C@3oool0oooo0?l0C@080?ooo`030?l0
f@3oool0oooo00X0oooo00<0o`3I0?ooo`3oool0103oool00`3V0?l0oooo0?ooo`0I0?ooo`030000
003oool0oooo03`0oooo000Q0?ooo`030000003oool0oooo00d0oooo00D000000?ooo`3oool0oooo
0?l0000/0?ooo`030?l09P3oool0oooo0080o`0V0P3oool00`3o02H0oooo0?ooo`050?ooo`030?l0
f@3oool0oooo01X0oooo00<0o`3I0?ooo`3oool0203oool00`2f0?l0oooo0?ooo`0E0?ooo`@0]P3o
00D0o`3I0?ooo`2;0?l0oooo0?l0f@0C0?ooo`030?X0o`3oool0oooo00/0oooo00D0o`3I0?ooo`3o
ool0oooo08/0o`0>0?ooo`030?l0MP3oool0oooo00H0oooo103o0=T00`3oool0o`3I0?ooo`040?l0
[@030?ooo`3o0:d0oooo00P0oooo00D0iP3o0?ooo`3o04d0o`1=000000030?l0C@80oooo00<0]P3o
0?ooo`3oool00`3oool00`3o0=T0oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo00@0oooo00<0iP3o
0?ooo`3oool06`3oool00`000000oooo0?ooo`0k0?ooo`008@3oool00`000000oooo0?ooo`0>0?oo
o`040000003oool0oooo0?ooo`80o`00:@3oool40?l09P80oooo0`3o02H80?ooo`030?l0f@3oool0
oooo01X0oooo00<0o`3I0?ooo`3oool0203oool00`2f0?l0oooo0?ooo`0B0?ooo`H0]P3o00@0o`3I
0?ooo`2;0?l0o`3I4`3oool00`3j0?l0oooo0?ooo`0<0?ooo`040?l0f@3oool0oooo08/0o`l0oooo
00<0o`1f0?ooo`3oool01P3oool00`3o0=T0oooo0?ooo`030?l0f@060?ooo`3o0:d0o`2]0?l0[@3o
ool0o`2]2@3oool00`3V0?l0oooo0?ooo`020?l0C@030000003o04d0oooo0080oooo00<0]P3o0?oo
o`3oool0103oool00`3o0=T0oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo00<0oooo00<0iP3o0?oo
o`3oool07@3oool00`000000oooo0?ooo`0j0?ooo`00803oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo0080oooo00<0o`000?ooo`3oool09`3oool60?l09P030?ooo`3o02H0o`0V00P0
oooo00<0o`3I0?ooo`3oool06P3oool00`3o0=T0oooo0?ooo`070?ooo`030;H0o`3oool0oooo0140
oooo102f0?l01`3oool0]P3o0;H0o`3oool0o`3I08/0o`3o0=T0103oool00`0:0?l0oooo0?ooo`0<
0?ooo`030?X0o`3oool0oooo00`0oooo00@0o`3I0?ooo`3oool0R`3o3`3oool00`3o07H0oooo0?oo
o`070?ooo`030?l0f@3oool0o`3I00@0o`3I0`3o0:d:0?ooo`060>H0o`3oool0oooo0?ooo`3o04d0
00000`3oool00`2f0?l0oooo0?ooo`040?ooo`030?l0f@3oool0oooo00X0oooo00<0o`3I0?ooo`3o
ool0103oool00`3V0?l0oooo0?ooo`0M0?ooo`030000003oool0oooo03X0oooo000P0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool00P3oool00`3o0000oooo0?ooo`0[0?ooo`@0o`0V
2@3oool00`3o0=T0oooo0?ooo`0J0?ooo`030?l0f@3oool0oooo00H0oooo00<0]P3o0?ooo`3oool0
403oool20;H0o`030?ooo`2f0?l0oooo00<0]P3o0P3oool00`2;0?l0oooo0?ooo`030?ooo`0300X0
o`3oool0oooo00`0oooo00<0nP3o0?ooo`3oool0303oool0103o0=T0oooo0?ooo`2;0?l>0?ooo`03
0?l0MP3oool0oooo00P0oooo00<0o`3I0?ooo`3o0=T00P3o0=T20?ooo`030?l0[@3o0=T0oooo00T0
oooo00<0iP3o0?ooo`3oool00P3oool00`3o04d000000?ooo`020?ooo`030;H0o`3oool0oooo00@0
oooo00<0o`3I0?ooo`3oool02P3oool00`3o0=T0oooo0>H0o`030?ooo`030>H0o`3oool0oooo01l0
oooo00<000000?ooo`3oool0>@3oool00200oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`020?ooo`80o`009`3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l0f@3oool0oooo01X0oooo
00<0o`3I0?ooo`3oool01P3oool01@2f0?l0oooo0?ooo`3oool0]P3o00h0oooo0P2f0?l00`3oool0
]P3o0;H0o`020;H0o`80oooo00<0R`3o0?ooo`3oool0103oool00`0:0?l0oooo0?ooo`0;0?ooo`03
0?X0o`3oool0oooo00/0oooo00D0o`3I0?ooo`3oool0oooo08/0o`0>0?ooo`030?l0MP3oool0oooo
00P0oooo0P3o0=T0103oool0o`3I0?l0f@3oool20?l0f@L0oooo00D0nP3o0?ooo`3oool0oooo0>H0
o`050?ooo`040000003oool0oooo0;H0o`L0oooo00<0o`3I0?ooo`3oool02@3oool00`3o0=T0oooo
0>H0o`020>H0o`030?ooo`3V0?l0oooo0280oooo00<000000?ooo`3oool0>03oool00200oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`030?ooo`030?l0003oool0oooo02D0oooo00<0
o`1=0?ooo`3oool03`3oool00`3o0=T0oooo0?ooo`0J0?ooo`030?l0f@3oool0oooo00D0oooo00<0
]P3o0?ooo`2f0?l00P2f0?l@0?ooo`040;H0o`3oool0]P3o0;H0o`<0oooo00<0R`3o0?ooo`3oool0
103oool00`0:0?l0oooo0?ooo`0;0?ooo`030?X0o`3oool0oooo00/0oooo00D0o`3I0?ooo`3oool0
oooo08/0o`0>0?ooo`030?l0MP3oool0oooo00P0oooo103o0=T00`3oool0o`3I0?ooo`080?ooo`04
0?X0o`3oool0oooo0>H0o`H0oooo00<000000?ooo`2f0?l01`3oool00`3o0=T0oooo0?ooo`0:0?oo
o`030?l0f@3V0?l0iP3o0080oooo0P3V0?lS0?ooo`030000003oool0oooo03P0oooo000P0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`0U0?ooo`80
o`1=403oool00`3o0=T0oooo0?ooo`0J0?ooo`030?l0f@3oool0oooo00@0oooo0`2f0?l00`3oool0
]P3o0?ooo`0@0?ooo`<0]P3o0`3oool00`2;0?l0oooo0?ooo`040?ooo`0300X0o`3oool0oooo00/0
oooo00<0nP3o0?ooo`3oool02`3oool01@3o0=T0oooo0?ooo`3oool0R`3o00h0oooo00<0o`1f0?oo
o`3oool02@3oool20?l0f@030?ooo`3o0=T0oooo00P0oooo00D0nP3o0?ooo`3oool0oooo0>H0o`06
0?ooo`030000002f0?l0oooo00L0oooo00<0o`3I0?ooo`3oool02@3oool01P3o0=T0oooo0>H0o`3V
0?l0oooo0>H0o`80oooo00<0iP3o0?ooo`3oool08@3oool00`000000oooo0?ooo`0g0?ooo`00803o
ool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo00<0oooo0P3o00040?ooo`80o`008@3o
ool00`3o04d0oooo0?ooo`0>0?ooo`030?l0f@3oool0oooo01T0oooo00<0o`3I0?ooo`3oool00P3o
ool20;H0o`050?ooo`2f0?l0]P3o0?ooo`2f0?l0203oool00`250?l0oooo0?ooo`080?ooo`050;H0
o`3oool0oooo0?ooo`2;0?l01P3oool00`0:0?l0oooo0?ooo`0;0?ooo`030?X0o`3oool0oooo00/0
oooo00@0o`3I0?ooo`3oool0R`3o3P3oool00`3o07H0oooo0?ooo`0:0?ooo`<0o`3I2P3oool0103j
0?l0oooo0?ooo`3V0?l70?ooo`030000002f0?l0oooo00L0oooo00<0o`3I0?ooo`3oool02@3oool0
103o0=T0oooo0>H0o`3oool20>H0o`<0oooo00<0iP3o0?ooo`3oool0803oool00`000000oooo0?oo
o`0g0?ooo`00803oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00@0oooo00D0o`00
0?ooo`3oool0o`000?ooo`030?l00200oooo00<0o`1=0?ooo`3oool03@3oool00`3o0=T0oooo0?oo
o`0J0?ooo`070?l0f@3oool0]P3o0;H0o`3oool0]P3o0?ooo`030;H0o`T0oooo00<0Q@3o0?ooo`3o
ool0303oool00`2;0?l0oooo0?ooo`050?ooo`0300X0o`3oool0oooo00X0oooo00<0nP3o0?ooo`3o
ool0203oool30?l0f@<0oooo00<0R`3o0?ooo`3oool01`3oool60?l0MP`0oooo00<0o`3I0?ooo`3o
ool02@3oool01@3j0?l0oooo0?ooo`3oool0iP3o00L0oooo00<000000?ooo`3oool01P3oool00`3o
0=T0oooo0?ooo`0:0?ooo`060?l0f@3V0?l0iP3o0?ooo`3V0?l0oooo0`3V0?lT0?ooo`030000003o
ool0oooo03H0oooo000O0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool01@3oool0
103o0000oooo0?l0003oool30?l000030?l0C@3oool0oooo01h0oooo00<0o`1=0?ooo`3oool03@3o
ool00`3o0=T0oooo0?ooo`0J0?ooo`070?l0f@3oool0]P3o0;H0o`3o0=T0]P3o0?ooo`020;H0o`X0
oooo00<0Q@3o0?ooo`3oool02`3oool00`2;0?l0oooo0?ooo`050?ooo`0300X0o`3oool0oooo00X0
oooo00<0nP3o0?ooo`3oool01P3oool20?l0f@040?ooo`3o0=T0o`3I0?l0f@80oooo00<0R`3o0?oo
o`3oool01`3oool00`3o07H0oooo0?l0MP070?l0MQ@0oooo00@0nP3o0?ooo`3oool0iP3o1`3oool0
0`2f0?l000000?ooo`070?ooo`030?l0f@3oool0oooo00T0oooo00<0o`3I0?ooo`3V0?l00P3V0?l0
103oool0iP3o0>H0o`3V0?lV0?ooo`030000003oool0oooo03D0oooo000O0?ooo`030000003oool0
oooo01P0oooo00<000000?ooo`3oool01@3oool0203o0000oooo0?ooo`3oool0o`000?ooo`3o0000
o`1=803oool20?l0C@h0oooo00<0o`3I0?ooo`3oool06P3oool00`3o0=T0oooo0?ooo`050;H0o`X0
oooo00<0Q@3o0?ooo`3oool02`3oool00`2;0?l0oooo0?ooo`050?ooo`0300X0o`3oool0oooo00X0
oooo00<0nP3o0?ooo`3oool0103oool20?l0f@<0oooo0P3o0=T0103oool0o`3I0?ooo`2;0?l:0?oo
o`030?l0MP3oool0oooo00P0o`1f0P3oool00`3j0?l0oooo0?ooo`0=0?ooo`040?X0o`3oool0oooo
0>H0o`H0oooo00<0]P3o0?ooo`0000001`3oool00`3o0=T0oooo0?ooo`0:0?ooo`030?l0f@3oool0
iP3o00@0iP3o:03oool00`000000oooo0?ooo`0e0?ooo`007`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo00@0oooo103o0000103oool0o`000?l0003oool20?l0CB00oooo00<0o`1=
0?ooo`3oool0303oool00`3o0=T0oooo0?ooo`0G0?ooo`80o`3I00D0oooo0?l0f@3o0=T0oooo0?l0
f@030;H0o`X0oooo00<0Q@3o0?ooo`3oool02`3oool00`2;0?l0oooo0?ooo`060?ooo`0300X0o`3o
ool0oooo00T0oooo00<0nP3o0?ooo`3oool0103oool30?l0f@80oooo0P3o0=T20?ooo`80o`3I2P3o
ool01P3o07H0oooo0?ooo`3o07H0oooo0?l0MP<0oooo00D0o`1f0?ooo`3oool0oooo0?X0o`0>0?oo
o`040?X0o`3oool0oooo0>H0o`L0oooo00<0]P3o0?ooo`0000001`3oool00`3o0=T0oooo0?ooo`09
0?ooo`030?l0f@3oool0oooo0080iP3o8P3oool00`3o0:d0oooo0?ooo`070?ooo`030000003oool0
oooo03@0oooo000O0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool00P3oool00`3o
0000oooo0?ooo`020?l000030?ooo`3o0000o`0000<0oooo00<0o`1=0?ooo`3oool07P3oool00`3o
04d0oooo0?ooo`0<0?ooo`030?l0f@3oool0oooo0100oooo00<02P3o0?ooo`3oool00P3oool00`3o
0=T0oooo0?ooo`030?l0f@050?ooo`3o0=T0oooo0?ooo`2f0?l02`3oool00`250?l0oooo0?ooo`0:
0?ooo`0308/0o`3oool0oooo00H0oooo00<02P3o0?ooo`3oool02@3oool00`3j0?l0oooo0?ooo`05
0?ooo`030?l0f@3oool0o`3I0080o`3I0`2;0?l30?l0f@T0oooo00<0o`1f0?ooo`3oool00P3o07H3
0?ooo`050?l0MP3oool0oooo0?ooo`3j0?l03`3oool0103j0?l0oooo0?ooo`3V0?l60?ooo`040;H0
o`3oool0oooo000000L0oooo00<0o`3I0?ooo`3oool02@3oool00`3o0=T0oooo0?ooo`0R0?ooo`80
o`2]2P3oool00`000000oooo0?ooo`0d0?ooo`007`3oool00`000000oooo0?ooo`0K0?ooo`070000
003oool0oooo0?ooo`3o0000oooo0?l000020?ooo`040?l0003oool0o`000?l000<0oooo00<0o`1=
0?ooo`3oool07P3oool00`3o04d0oooo0?ooo`0<0?ooo`030?l0f@3oool0oooo00<0oooo00<0o`3I
0?ooo`3oool02@3oool00`0:0?l0oooo0?ooo`020?ooo`<0o`3I0P3oool0103o0=T0oooo0?l0f@3o
0=T=0?ooo`0308D0o`3oool0oooo00X0oooo00<0R`3o0?ooo`3oool01P3oool00`0:0?l0oooo0?oo
o`090?ooo`030?X0o`3oool0oooo00D0oooo00<0o`3I0?ooo`3oool01@3o0=T00`2;0?l0o`3I08/0
o`0308/0o`L0oooo103o07H20?ooo`060?l0MP3oool0oooo0?ooo`0:0?l0nP3o3`3oool00`3j0?l0
oooo0>H0o`060?ooo`050;H0o`3oool0oooo0?ooo`0000001P3oool00`3o0=T0oooo0?ooo`090?oo
o`030?l0f@3oool0oooo0280oooo00<0o`2]0?ooo`3oool02`3oool00`000000oooo0?ooo`0c0?oo
o`007`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0o`0000<0o`000`3oool30?l000@0
oooo0P3o04dO0?ooo`80o`1=3@3oool0103o0=T0oooo0?ooo`3oool20?l0f@`0oooo00<02P3o0?oo
o`3oool00P3oool40?l0f@040?ooo`3o0=T0o`3I0?l0f@h0oooo00<0Q@3o0?ooo`3oool0203oool0
0`2;0?l0oooo0?ooo`070?ooo`0300X0o`3oool0oooo00T0oooo00<0nP3o0?ooo`3oool01P3oool0
0`3o0=T0oooo0?l0f@020?l0f@030?ooo`2;0?l0o`3I00<0oooo00<0R`3o0?ooo`3oool01P3oool3
0?l0MP030?ooo`3o07H0o`1f00<0oooo00<02P3o0?ooo`3j0?l03P3oool0103j0?l0oooo0?ooo`3V
0?l50?ooo`030;H0o`3oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`3o0=T0oooo0?oo
o`090?ooo`030?l0f@3oool0oooo0200oooo0P3o0:d?0?ooo`030000003oool0oooo0380oooo000N
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o00001P3o00000`3oool0o`000?l00005
0?ooo`030?l0C@3oool0oooo01h0oooo00<0o`1=0?ooo`3oool02`3oool00`3o0=T0oooo0?l0f@02
0?l0f@`0oooo00<02P3o0?ooo`3oool0103oool60?l0f@h0oooo00<0Q@3o0?ooo`3oool0203oool0
0`2;0?l0oooo0?ooo`080?ooo`0300X0o`3oool0oooo00P0oooo00<0nP3o0?ooo`3oool01P3oool0
1@3o0=T0oooo0?l0f@3o0=T0R`3o0080o`3I00@0R`3o0?ooo`3oool0R`3o2@3oool40?l0MPD0oooo
00<02P3o0?ooo`3j0?l03P3oool00`3j0?l0oooo0>H0o`060?ooo`030;H0o`3oool0oooo00<0oooo
00<000000?ooo`3oool00`3oool00`3o0=T0oooo0?ooo`080?ooo`030?l0f@3oool0oooo01l0oooo
0P3o0:dA0?ooo`030000003oool0oooo0380oooo000N0?ooo`030000003oool0oooo01l0oooo00<0
00000?ooo`3oool00`3oool50?l000H0oooo00<0o`1=0?ooo`3oool07P3oool00`3o04d0oooo0?oo
o`0:0?ooo`<0o`3I00<0oooo0?l0f@3o0=T0303oool00`0:0?l0oooo0?ooo`070?ooo`80o`3I3P3o
ool00`250?l0oooo0?ooo`080?ooo`0308/0o`3oool0oooo00P0oooo00<02P3o0?ooo`3oool0203o
ool00`3j0?l0oooo0?ooo`070?ooo`@0o`3I0`2;0?l01@3oool0R`3o0?ooo`3oool0]P3o00P0oooo
0P3o07H50?ooo`0300X0o`3oool0nP3o00h0oooo00H0nP3o0?ooo`3oool0iP3o0?ooo`2f0?l30?oo
o`030;H0o`3oool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`3o0=T0oooo0?ooo`040?oo
o`@0o`3I00<0oooo0?l0f@3oool06`3oool01@2f0?l0oooo0?ooo`3oool0o`2]01@0oooo00<00000
0?ooo`3oool0<@3oool001h0oooo00<000000?ooo`3oool0803oool00`000000oooo0?l09P0>0?oo
o`80o`1=7`3oool20?l0C@T0oooo00@0o`3I0?ooo`3o0=T0o`3I0P3oool00`3o0=T0oooo0?ooo`0:
0?ooo`0300X0o`3oool0oooo00T0oooo00<0R`3o0?ooo`3oool0303oool00`250?l0oooo0?ooo`07
0?ooo`0308/0o`3oool0oooo00P0oooo00<02P3o0?ooo`3oool0203oool00`3j0?l0oooo0?ooo`07
0?ooo`<0o`3I00<0oooo08/0o`2;0?l00P2;0?l30?ooo`030;H0o`3oool0oooo00H0oooo00<0o`1f
0?ooo`3oool0103oool00`0:0?l0oooo0?X0o`0>0?ooo`040>H0o`3oool0iP3o0?ooo`<0]P3o00<0
oooo0;H0o`3oool01P3oool00`000000oooo0?ooo`020?ooo`030?l0f@3oool0oooo00@0oooo00<0
o`3I0?ooo`3o0=T00`3o0=TK0?ooo`030;H0o`3oool0oooo0080o`2]5P3oool00`000000oooo0?oo
o`0`0?ooo`007P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0o`0V00l0oooo00<0o`1=
0?ooo`3oool07P3oool00`3o04d0oooo0?ooo`050?ooo`050?l0f@3oool0o`3I0?ooo`3o0=T00P3o
ool00`3o0=T0oooo0?ooo`0;0?ooo`0300X0o`3oool0oooo00T0oooo00<0R`3o0?ooo`3oool02`3o
ool00`250?l0oooo0?ooo`070?ooo`0308/0o`3oool0oooo00P0oooo00<02P3o0?ooo`3oool0203o
ool00`3j0?l0oooo0?ooo`080?ooo`040?l0f@3oool0oooo0?ooo`80R`3o0`3oool00`2f0?l0E`3o
0?ooo`0=0?ooo`0400X0o`3oool0oooo0?X0o``0oooo1@3V0?l20;H0o`80oooo0P2f0?l70?ooo`05
0000003oool0oooo0?ooo`3o0=T01`3oool0103o0=T0oooo0?l0f@3oool40?l0fAP0oooo00@0]P3o
0?ooo`3oool0o`2]603oool00`000000oooo0?ooo`0`0?ooo`007P3oool00`000000oooo0?ooo`0R
0?ooo`040000003oool0o`0V0?l09Ph0oooo00<0o`1=0?ooo`3oool07P3oool00`3o04d0oooo0?oo
o`020?ooo`80o`1=00<0oooo0?l0f@3o0=T00P3oool00`3o0=T0oooo0?l0f@0=0?ooo`0300X0o`3o
ool0oooo00T0oooo00<0R`3o0?ooo`3oool02`3oool00`250?l0oooo0?ooo`070?ooo`0308/0o`3o
ool0oooo00T0oooo00<02P3o0?ooo`3oool01P3oool00`3j0?l0oooo0?ooo`0=0?ooo`0308/0o`3o
ool0oooo0080oooo00<0]P3o05L0o`3oool03@3oool00`0:0?l0oooo0?X0o`0;0?ooo`80iP3o00<0
oooo0?X0o`3V0?l00P3V0?l30;H0o`040?ooo`2f0?l0oooo0;H0o`H0oooo00D000000?ooo`3oool0
oooo0?l0f@070?ooo`040?l0f@3oool0o`3I0?l0f@80oooo103o0=TE0?ooo`040;H0o`3oool0o`2]
0?l0[AX0oooo00<000000?ooo`3oool0;`3oool001h0oooo00<000000?ooo`3oool08`3oool01000
0000oooo0?ooo`3o02H>0?ooo`80o`1=7`3oool01@3o04d0oooo0?ooo`3o04d0oooo00<0o`1=00@0
oooo0?l0f@3o0=T0oooo0`3o0=T=0?ooo`0300X0o`3oool0oooo00T0oooo00<0R`3o0?ooo`3oool0
2`3oool00`250?l0oooo0?ooo`060?ooo`0308/0o`3oool0oooo00T0oooo00<02P3o0?ooo`3oool0
103oool50?X0oa40oooo00<0]P3o0?ooo`1G0?l03@3oool0100:0?l0oooo0?ooo`3j0?l:0?ooo`08
0>H0o`3oool0oooo0?ooo`3V0?l0oooo0>H0o`3oool20>H0o`030?ooo`2f0?l0oooo0080oooo00<0
]P3o0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0o`3I00L0oooo0P3o0=T0103oool0o`3I
0?ooo`3oool30?l0fA40oooo0P3o0:d30?ooo`030;H0o`3o0:d0oooo01/0oooo00<000000?ooo`3o
ool0;`3oool001d0oooo00<000000?ooo`3oool09@3oool010000000oooo0?ooo`3o02H?0?ooo`03
0?l0C@3oool0oooo01d0oooo0`3o04d0103oool0o`1=0?l0C@3o04d30?ooo`@0o`3I3@3oool00`0:
0?l0oooo0?ooo`0:0?ooo`0308/0o`3oool0oooo00X0oooo00<0Q@3o0?ooo`3oool01P3oool00`2;
0?l0oooo0?ooo`090?ooo`0400X0o`3oool02P3o00X0o`<0nP3o0P3oool00`3j0?l0oooo0?ooo`04
0?X0o`d0oooo00<0]P3o05L0o`3oool0303oool01@0:0?l0oooo0?ooo`3oool0nP3o00X0oooo0P3V
0?l0103oool0nP3o0>H0o`3V0?l20?ooo`80]P3o00<0iP3o0?ooo`2f0?l00P2f0?l60?ooo`040000
003o0=T0o`3I0?l0f@T0oooo0P3o0=T20?ooo`80o`3I403oool50?l0[@80oooo00<0]P3o0?l0[@3o
ool07@3oool00`000000oooo0?ooo`0^0?ooo`007@3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo0080o`0V3P3oool00`3o04d0oooo0?ooo`0M0?ooo`80o`1=00D0oooo0?l0C@3o04d0
oooo0?l0C@040?ooo`80o`3I3P3oool00`0:0?l0oooo0?ooo`0:0?ooo`0308/0o`3oool0oooo00T0
oooo00<0Q@3o0?ooo`3oool0103oool408/0o`T0oooo0`0:0?l01@3oool02P3o00X0o`3j0?l0oooo
00H0nP3o00<0oooo0?X0o`3oool03@3oool00`2f0?l0E`3o0?ooo`0<0?ooo`0400X0o`3oool0oooo
0?X0o``0oooo0P3V0?l00`3j0?l0iP3o0>H0o`020?ooo`80]P3o00<0oooo0>H0o`2f0?l00P2f0?l3
0?ooo`<0o`3I00<000000?l0f@3oool00P3o0=T80?ooo`D0o`3I3P3oool01P2;0?l0oooo0?ooo`3o
0:d0oooo0?l0[@80oooo00<0o`2]0;H0o`3oool0803oool00`000000oooo0?ooo`0]0?ooo`007@3o
ool00`000000oooo0?ooo`060?ooo`030?l09P3oool0oooo01h0oooo00D000000?ooo`3oool0oooo
0?l09P0>0?ooo`80o`1=703oool0203o04d0oooo0?ooo`3o04d0oooo0?l0C@3oool0o`1=1P3oool0
0`3j0?l0oooo0?ooo`0;0?ooo`0300X0o`3oool0oooo00/0oooo00<0R`3o0?ooo`3oool02@3oool0
0`250?l0oooo0?ooo`0308/0o`80oooo00@0R`3o0?ooo`2;0?l0R`3o1@3oool700X0o`030?ooo`3j
0?l0oooo0080oooo0P3j0?l20?ooo`030?X0o`3oool0oooo00`0oooo00<0]P3o0?ooo`1G0?l0303o
ool01@0:0?l0oooo0?ooo`3oool0nP3o00`0oooo00@0iP3o0?ooo`3V0?l0iP3o0`3oool00`2f0?l0
iP3o0>H0o`020;H0o`D0oooo00P0o`3I0?ooo`3o0=T000000?l0f@3oool0o`3I0?ooo`80o`3I1P3o
ool30?l0f@l0oooo00H0R`3o0?ooo`3oool0o`2]0?ooo`3o0:d20?ooo`030?l0[@2f0?l0oooo0240
oooo00<000000?ooo`3oool0;@3oool001d0oooo00<000000?ooo`3oool01`3oool20?l09Ql0oooo
00D000000?ooo`3oool0oooo0?l09P0?0?ooo`030?l0C@3oool0oooo00@0oooo00<0o`1=0?ooo`3o
ool04P3oool00`3o04d0oooo0?ooo`020?l0C@030?ooo`3o04d0o`1=00L0oooo00<0nP3o0?ooo`3o
ool02`3oool00`0:0?l0oooo0?ooo`0;0?ooo`0308/0o`3oool0oooo00P0oooo00@0Q@3o0?ooo`3o
ool0oooo0`2;0?l0103oool0R`3o0?ooo`3oool308/0o`@0oooo00<02P3o0?ooo`0:0?l00`0:0?l2
0?ooo`030?X0o`3oool0oooo0080nP3o00<0oooo0?X0o`3oool03P3oool00`2f0?l0oooo05L0o`0<
0?ooo`0500X0o`3oool0oooo0?ooo`3j0?l03@3oool30>H0o`80oooo0P3V0?l00`2f0?l0oooo0?oo
o`070?ooo`030?l0f@3oool000000080o`3I103oool20?l0f@@0oooo00<0o`3I0?ooo`3oool01P3o
ool00`3o0=T0oooo0?ooo`060?ooo`0508/0o`3oool0oooo0?l0[@3oool00`3o0:d00`2f0?l0oooo
0?l0[@0R0?ooo`030000003oool0oooo02`0oooo000M0?ooo`030000003oool0oooo00T0oooo00<0
o`0V0?ooo`3oool07@3oool010000000oooo0?ooo`3oool20?l09Ph0oooo00<0o`1=0?ooo`3oool0
0P3oool0103o04d0oooo0?l0C@3o04dA0?ooo`@0o`1=0P3oool30?l0C@P0oooo00<0nP3o0?ooo`3o
ool02P3oool00`0:0?l0oooo0?ooo`0<0?ooo`0308/0o`3oool0oooo00P0oooo00@0Q@3o0?ooo`3o
ool0R`3o0P3oool408/0o`030?ooo`2;0?l0oooo00D0oooo1@0:0?l30?ooo`060?X0o`3oool0nP3o
0?ooo`1G0?l0nP3o3P3oool0102f0?l0oooo0?ooo`1G0?l;0?ooo`0300X0o`3oool0oooo0080oooo
00<0nP3o0?ooo`3oool02`3oool20>H0o`030?ooo`3V0?l0iP3o00`0oooo00<0o`3I0?ooo`000000
1`3o0=T<0?ooo`80o`3I203oool0102;0?l0oooo0?ooo`3oool40?l0[@040;H0o`3oool0oooo0?l0
[B<0oooo00<000000?ooo`3oool0:`3oool001d0oooo00<000000?ooo`3oool02P3oool00`3o02H0
oooo0?ooo`0M0?ooo`030000003oool0oooo0080oooo00<0o`0V0?ooo`3oool0303oool20?l0C@80
oooo00@0o`1=0?ooo`3o04d0o`1=4P3oool60?l0C@030?ooo`3o04d0o`1=00P0oooo00<0nP3o0?oo
o`3oool02P3oool00`0:0?l0oooo0?ooo`0;0?ooo`0308/0o`3oool0oooo00P0oooo00D0Q@3o0?oo
o`3oool0oooo08/0o`020?ooo`0408/0o`3oool0oooo08/0o`T0oooo0P0:0?l50?ooo`80nP3o00D0
oooo05L0o`3oool0oooo0029o`0<0?ooo`030;H0o`3oool0E`3o00`0oooo00D02P3o0?ooo`3oool0
oooo0?X0o`0>0?ooo`030?X0o`3V0?l0iP3o00h0oooo00L0o`3I0?ooo`000000o`3I0?ooo`3o0=T0
oooo0080o`3I303oool00`3o0=T0oooo0?ooo`080?ooo`0308/0o`3oool0oooo00<0o`2]00<0oooo
0?l0[@2f0?l00`3oool00`3o0:d0oooo0?ooo`0P0?ooo`030000003oool0oooo02/0oooo000M0?oo
o`030000003oool0oooo00/0oooo0P3o02HN0?ooo`030000003oool0oooo0080oooo00<0o`0V0?oo
o`3oool03@3oool20?l0C@80oooo0`3o04d20?ooo`0308/0o`3oool0oooo00d0oooo00@0o`3I0?oo
o`3oool0oooo103o04d80?ooo`030?X0o`3oool0oooo00X0oooo00<02P3o0?ooo`3oool0303oool0
0`2;0?l0oooo0?ooo`070?ooo`0308D0o`3oool0oooo0080oooo00D0R`3o0?ooo`2;0?l0oooo08/0
o`0;0?ooo`0300X0o`3oool0oooo00<0oooo0`3j0?l0101G0?l0oooo0?ooo`00ROl<0?ooo`030;H0
o`3oool0E`3o00/0oooo00<02P3o0?ooo`3oool00P3oool00`3j0?l0oooo0?ooo`0;0?ooo`030?X0
o`3oool0oooo0100oooo00H0o`3I0000003o0=T0o`3I0?ooo`3o0=T<0?ooo`80o`3I2P3oool0102;
0?l0oooo0?ooo`3oool40?l0[@030;H0o`3o0:d0o`2]00<0o`2]8`3oool00`000000oooo0?ooo`0Z
0?ooo`00703oool00`000000oooo0?ooo`0>0?ooo`030?l09P3oool0oooo01`0oooo00<000000?oo
o`3oool00P3oool20?l09Pd0oooo0P3o04d00`3oool0o`1=0?ooo`020?l0C@<0oooo00<0R`3o0?oo
o`3oool03@3oool00`3o0=T0oooo0?ooo`0=0?ooo`030?X0o`3oool0oooo00X0oooo00<02P3o0?oo
o`3oool0303oool00`2;0?l0oooo0?ooo`070?ooo`0308D0o`3oool0oooo0080oooo0P2;0?l00`3o
ool0R`3o0?ooo`0A0?ooo`030?X0o`3oool0E`3o0080oooo00<008Wo0?ooo`3oool02@3oool0102f
0?l0oooo0?ooo`1G0?l80?ooo`<02P3o1@3oool00`3j0?l0oooo0?ooo`0;0?ooo`030?X0o`3oool0
oooo0100oooo00<0o`3I0000003o0=T00P3o0=T;0?ooo`80o`3I2`3oool00`2;0?l0oooo0?ooo`05
0?ooo`030;H0o`3oool0oooo02L0oooo00<000000?ooo`3oool0:P3oool001`0oooo00<000000?oo
o`3oool03`3oool20?l09Qd0oooo00<000000?ooo`3oool00`3oool00`3o02H0oooo0?ooo`090?oo
o`030?l0C@3oool0oooo0080o`1=0P3oool00`3o04d0oooo0?ooo`020?ooo`0308/0o`3oool0oooo
00d0oooo0P3o0=T>0?ooo`030?X0o`3oool0oooo00T0oooo00<02P3o0?ooo`3oool03@3oool00`2;
0?l0oooo0?ooo`0208/0o`@0oooo00<0Q@3o0?ooo`3oool00P3oool308/0oaD0oooo00@0E`3o0?oo
o`3oool008Wo2`3oool0102f0?l0oooo0?ooo`1G0?l70?ooo`802P3o00<0oooo00X0o`0:0?l00`3o
ool00`3j0?l0oooo0?ooo`060?ooo`80nP3o0`3oool00`3j0?l0oooo0?ooo`0B0?ooo`030000003o
0=T0o`3I00/0oooo00<0o`3I0;H0o`3oool02`3oool00`2;0?l0oooo0?ooo`040?ooo`030;H0o`3o
ool0oooo02T0oooo00<000000?ooo`3oool0:@3oool001`0oooo00<000000?ooo`3oool04@3oool0
0`3o02H0oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo00<0o`0V0?ooo`3oool0203oool0
0`3o04d0oooo0?l0C@020?ooo`040?l0C@3oool0o`1=0?l0C@@0oooo0P2;0?l?0?ooo`030?l0f@3o
ool0oooo00`0oooo00<0nP3o0?ooo`3oool02@3oool00`0:0?l0oooo0?ooo`0=0?ooo`<0R`3o00<0
oooo08/0o`2;0?l00P3oool508D0o`030?ooo`2;0?l0oooo01D0oooo00@0E`3o0?ooo`3oool008Wo
2P3oool01@2f0?l0oooo0?ooo`3oool0E`3o00L0oooo0`0:0?l20?ooo`802P3o00<0oooo0?X0o`3o
ool01`3oool01P3j0?l0oooo0?X0o`3j0?l0oooo0?X0oa@0oooo00<0o`3I0000003oool0103oool0
0`250?l0oooo0?ooo`020?ooo`80o`3I00<0]P3o0?ooo`3oool02P3oool00`2;0?l0oooo0?ooo`04
0?ooo`030;H0o`3oool0oooo02/0oooo00<000000?ooo`3oool0:03oool001`0oooo00<000000?oo
o`3oool04P3oool00`3o02H0oooo0?ooo`0K0?ooo`030000003oool0oooo00<0oooo0P3o02H40?oo
o`030?l09P3oool0oooo00@0o`1=0`3oool00`3o04d0oooo0?l0C@060?ooo`0308/0o`3oool0oooo
00d0oooo00<0o`3I0?ooo`3oool0303oool00`3j0?l0oooo0?ooo`080?ooo`0300X0o`3oool0oooo
00d0oooo0P2;0?l0103oool0R`3o08/0o`2;0?l508D0o`030?ooo`250?l0oooo01L0oooo00@0E`3o
0?ooo`3oool008Wo2P3oool0102f0?l0oooo0?ooo`1G0?l80?ooo`0300X0o`3oool02P3o00<02P3o
0P3oool00`3j0?l0oooo0?ooo`060?ooo`030?X0o`3oool0oooo00<0nP3o5@3oool00`000000oooo
0?ooo`020?ooo`0308D0o`3oool0oooo0080oooo00@0o`3I0?ooo`3oool0]P3o303oool00`2;0?l0
oooo0?ooo`030?ooo`030;H0o`3oool0oooo02`0oooo00<000000?ooo`3oool0:03oool001`0oooo
00<000000?ooo`3oool04`3oool20?l09Q`0oooo00<000000?ooo`3oool0103oool01@3o02H0oooo
0?ooo`3o02H0oooo0080o`0V00<0oooo0?l0C@3o04d0203o04d60?ooo`0308/0o`3oool0oooo00d0
oooo00<0o`3I0?ooo`3oool0303oool00`3j0?l0oooo0?ooo`080?ooo`0300X0o`3oool0oooo00/0
oooo00<0R`3o0?ooo`3oool00P2;0?l708D0o`040?ooo`250?l0oooo00X0o`H0oooo00<002oo0?oo
o`3oool03@3oool0101G0?l0oooo0?ooo`00ROl80?ooo`030;H0o`3oool0]P3o0080oooo00<0E`3o
0?ooo`3oool01P3oool200X0o`040?ooo`0:0?l02P3o00X0o`80oooo00<0nP3o0?ooo`3oool01`3o
ool01@3j0?l0oooo0?X0o`3j0?l0oooo0080nP3o4`3oool01@000000oooo0?ooo`3oool0Q@3o00<0
oooo0P3o0=T20?ooo`030;H0o`3oool0oooo00X0oooo00<0R`3o0?ooo`3oool0103oool00`2f0?l0
oooo0?ooo`0]0?ooo`030000003oool0oooo02L0oooo000L0?ooo`030000003oool0oooo01D0oooo
00<0o`0V0?ooo`3oool06P3oool00`000000oooo0?ooo`040?ooo`80o`0V0P3oool20?l09PH0oooo
1@3o04d70?ooo`0308/0o`3oool0oooo00d0oooo0P3o0=T=0?ooo`030?X0o`3oool0oooo00L0oooo
1@0:0?l80?ooo`80R`3o00D0oooo08/0o`2;0?l0oooo08/0o`0208D0o`080?ooo`250?l0oooo08D0
o`3oool0Q@3o0?ooo`0:0?l60?ooo`03000_o`3oool0oooo00`0oooo00D0E`3o0?ooo`3oool0oooo
0029o`060?ooo`@0]P3o0`3oool00`1G0?l0oooo0?ooo`060?ooo`@02P3o0`3oool00`3j0?l0oooo
0?ooo`080?ooo`070?X0o`3oool0nP3o0?X0o`3oool0nP3o0?ooo`020?X0oa00oooo00<0o`3I0000
003o0=T00P3o0=T010250?l0oooo0?l0f@3o0=T40?ooo`030;H0o`3oool0oooo00X0oooo00<0R`3o
0;H0o`3oool00`3oool00`2f0?l0oooo0?ooo`0_0?ooo`030000003oool0oooo02H0oooo000K0?oo
o`030000003oool0oooo01L0oooo00<0o`0V0?ooo`3oool06P3oool00`000000oooo0?ooo`030?oo
o`<0o`0V00@0oooo0?l09P3o02H0o`0V0P3oool00`3o07H0oooo0?ooo`0=0?ooo`0308/0o`3oool0
oooo00h0oooo00<0o`3I0?ooo`3oool02`3oool00`3j0?l0oooo0?ooo`050?ooo`H02P3o2@3oool3
08/0o`070?ooo`2;0?l0R`3o08/0o`3oool0Q@3o0?ooo`0308D0o`80oooo00<02P3o0?ooo`3oool0
103oool00`00;ol0oooo0?ooo`0<0?ooo`0505L0o`3oool0oooo0?ooo`00ROl0103oool20;H0o`80
oooo0`2f0?l20?ooo`0305L0o`3oool0oooo00H0oooo0P0:0?l50?ooo`030?X0o`3oool0oooo00P0
oooo0P3j0?l0103oool0nP3o0?X0o`3oool20?X0oa40oooo00L0o`3I0000003oool0o`3I08D0o`3o
ool0o`3I00D0oooo00<0]P3o0?ooo`3oool02P3oool0102;0?l0]P3o0;H0o`2f0?l20?ooo`030;H0
o`3oool0oooo02H0oooo0P3o02H80?ooo`030000003oool0oooo02H0oooo000K0?ooo`030000003o
ool0oooo01P0oooo0P3o02HK0?ooo`030000003oool0oooo0080oooo00D0o`0V0?ooo`3oool0o`0V
0?ooo`020?l09P<0oooo00<0o`1f0?ooo`3oool03@3oool208/0o`l0oooo00<0o`3I0?ooo`3oool0
2`3oool00`3j0?l0oooo0?ooo`020?ooo`802P3o00H0oooo00X0o`0:0?l02P3o0?ooo`0:0?l<0?oo
o`@0R`3o0P3oool408D0o`80oooo00<02P3o0?ooo`3oool01@3oool00`00;ol0oooo0?ooo`0;0?oo
o`0505L0o`3oool0oooo0?ooo`00ROl00`3oool0102f0?l0oooo0?ooo`3oool20;H0o`80oooo00<0
]P3o0?ooo`1G0?l0303oool20?X0o`030?ooo`3j0?l0oooo00T0oooo103j0?l00`3oool0nP3o0?oo
o`0A0?ooo`050?l0f@3oool000000?l0f@250?l00P3o0=T50?ooo`030;H0o`3oool0oooo00X0oooo
00D0R`3o0?ooo`2f0?l0]P3o0?ooo`020;H0obL0oooo0P3o02H;0?ooo`030000003oool0oooo02D0
oooo000K0?ooo`030000003oool0oooo01X0oooo00<0o`0V0?ooo`3oool06@3oool010000000oooo
0?ooo`3o02H20?ooo`040?l09P3oool0o`0V0?ooo`80o`0V0`3oool20?l0MPl0oooo00<0R`3o0?oo
o`3oool03@3oool00`3o0=T0oooo0?ooo`0;0?ooo`030?X0o`3oool0oooo0080oooo0P0:0?l20?oo
o`802P3o3`3oool208/0o`<0oooo0`250?l20?ooo`0300X0o`3oool0oooo00D0oooo00<002oo0?oo
o`3oool02`3oool01@1G0?l0oooo0?ooo`3oool008Wo00<0oooo0P2f0?l20?ooo`80]P3o0`3oool0
0`2f0?l0oooo0?ooo`080?ooo`<0nP3o00@0oooo0?X0o`3j0?l0nP3o2`3oool40?X0o`L0oooo00<0
R`3o0?ooo`3oool02@3oool01`3o0=T0oooo000000250?l0o`3I0?ooo`3o0=T01@3oool00`2f0?l0
oooo0?ooo`0:0?ooo`0408/0o`3oool0]P3o0?ooo`<0]P3o9@3oool20?l09Pd0oooo00<000000?oo
o`3oool09@3oool001/0oooo00<000000?ooo`3oool06`3oool20?l09PH0oooo00<0o`0V0?ooo`3o
ool04@3oool01P000000o`0V0?l09P3o02H0oooo0?l09P80oooo0`3o02H50?ooo`030?l0MP3oool0
oooo00d0oooo00<0R`3o0?ooo`3oool03@3oool20?l0f@`0oooo00<0nP3o0?ooo`3oool00`3oool0
100:0?l0oooo00X0o`0:0?lF0?ooo`0408D0o`3oool0oooo00X0o`L0oooo00<002oo0?ooo`3oool0
2`3oool00`1G0?l0oooo0?ooo`020029o`@0oooo0P2f0?l00`3oool0]P3o0;H0o`030?ooo`0305L0
o`2f0?l0oooo00P0oooo0`3j0?l0103oool0nP3o0?X0o`3oool20?X0o`T0oooo0`3j0?l60?ooo`80
R`3o103oool00`1G0?l0oooo0?ooo`050?ooo`80o`3I00D000000?l0f@3oool0oooo0?l0f@040?oo
o`030;H0o`3oool0oooo00X0oooo00D0R`3o0?ooo`3oool0]P3o0?ooo`020;H0o`030?ooo`2f0?l0
oooo0240oooo0P3o02H@0?ooo`030000003oool0oooo02@0oooo000K0?ooo`030000003oool0oooo
01d0oooo00<0o`0V0?ooo`3oool00P3oool0103o02H0oooo0?l09P3o02HB0?ooo`030000003oool0
o`0V00D0o`0V00<0oooo0?l09P3o02H01@3oool00`3o07H0oooo0?ooo`0=0?ooo`0308/0o`3oool0
oooo00h0oooo00<0o`3I0?ooo`3oool02P3oool01P3j0?l0oooo0?ooo`3oool0nP3o0?ooo`<02P3o
4P3oool00`0:0?l0oooo0?ooo`040?ooo`0300X0o`3oool0oooo00D0oooo00<002oo0?ooo`3oool0
2`3oool00`1G0?l0oooo0?ooo`050029o`030?ooo`2f0?l0oooo0080]P3o0`3oool20;H0o`/0oooo
00<0nP3o0?ooo`3j0?l00P3j0?l30?ooo`80nP3o1`3oool00`3j0?l0oooo0?ooo`050?ooo`0308/0
o`3oool0oooo00<0oooo00<0E`3o0?ooo`3oool0103oool01P3o0:d0o`3I0?l0f@250?l000000?l0
f@<0oooo00D0o`3I0?ooo`3oool0oooo0;H0o`0<0?ooo`0708/0o`3oool0]P3o0;H0o`3oool0]P3o
0?ooo`030;H0oah0oooo0`3o02HC0?ooo`030000003oool0oooo02<0oooo000K0?ooo`030000003o
ool0oooo01h0oooo00H0o`0V0?ooo`3oool0oooo0?l09P3oool20?l09Q<0oooo00<000000?ooo`3o
ool00`3oool40?l09PH0oooo0P3o07H>0?ooo`0308/0o`3oool0oooo00h0oooo00@0o`3I0?ooo`3o
ool0oooo0P3o0=T70?ooo`030?X0o`3oool0nP3o0080nP3o0P3oool00`0:0?l0oooo0?ooo`070?oo
o`03000_o`3oool0oooo00L0oooo00<02P3o0?ooo`3oool00`3oool00`0:0?l0oooo0?ooo`060?oo
o`03000_o`3oool0oooo00X0oooo00<0E`3o0?ooo`00ROl00P00ROl00`3oool008Wo0029o`020?oo
o`<0]P3o00D0oooo0;H0o`2f0?l0oooo05L0o`0;0?ooo`030?X0o`3oool0oooo00H0nP3o3`3oool0
0`2;0?l0oooo0?ooo`040?ooo`0305L0o`3oool0oooo00<0oooo00H0o`2]0?ooo`3o0=T0o`3I08D0
o`0000050?l0f@80oooo00<0]P3o0?ooo`3oool02P3oool01`2;0?l0oooo0?ooo`2f0?l0oooo0;H0
o`3oool00`2f0?lM0?ooo`80o`0V5P3oool00`000000oooo0?ooo`0S0?ooo`006P3oool00`000000
oooo0?ooo`0P0?ooo`<0o`0V0P3oool30?l09Q<0oooo00<000000?l0[@3oool03P3oool00`3o07H0
oooo0?ooo`0<0?ooo`0308/0o`3oool0oooo00h0oooo0`3o0=T00`3oool0o`3I0?l0f@020?l0f@@0
oooo0P3j0?l00`3oool0nP3o0?X0o`0<0?ooo`03000_o`3oool0oooo00P0oooo00<02P3o0?ooo`3o
ool00P3oool00`0:0?l0oooo0?ooo`060?ooo`03000_o`3oool0oooo00X0oooo00<0E`3o0?ooo`00
ROl00P00ROl00`3oool008Wo0?ooo`020?ooo`@0]P3o0`3oool00`1G0?l0oooo0?ooo`090?ooo`03
0?X0o`3oool0nP3o0080nP3o0P3oool00`3j0?l0oooo0?ooo`0<0?ooo`80R`3o1P3oool00`1G0?l0
oooo0?ooo`030?ooo`070?l0[@3oool0oooo0?ooo`250?l0oooo000000070?ooo`030;H0o`3oool0
oooo00T0oooo00@0R`3o0?ooo`3oool0oooo1@2f0?lB0?ooo`H0o`0V1@3oool20?l09QT0oooo00<0
00000?ooo`3oool08P3oool001X0oooo00<000000?ooo`3oool08@3oool20?l09P030?ooo`3o02H0
oooo0080o`0V00<0o`3I0?ooo`3oool04@3oool00`000000o`2]0?l0[@0>0?ooo`030?l0MP3oool0
oooo00`0oooo0P2;0?l@0?ooo`040?l0f@3oool0o`3I0?ooo`80o`3I103oool30?X0o`030?ooo`3j
0?l0nP3o00`0oooo00<002oo0?ooo`3oool0203oool01@0:0?l0oooo0?ooo`3oool02P3o00P0oooo
00<002oo0?ooo`3oool02P3oool00`1G0?l0oooo0?ooo`040029o`@0oooo0P2f0?l30?ooo`0305L0
o`3oool0oooo00/0oooo1P3j0?l>0?ooo`0308/0o`3oool0oooo00H0oooo00@0E`3o0?ooo`3oool0
oooo0P3o0:d30?ooo`0408D0o`3oool0oooo000000H0oooo00<0]P3o0?ooo`3oool02P3oool0102;
0?l0oooo0?ooo`3oool20;H0oaD0oooo00@0o`0V0?ooo`3oool0oooo0P3o02H30?ooo`80o`0V0`3o
ool00`3o0=T0oooo0?ooo`0F0?ooo`030000003oool0oooo0240oooo000J0?ooo`030000003oool0
oooo0200oooo00<0o`0V0?ooo`3oool00P3o02H20?ooo`040?l09P3oool0o`3I0?l0fA80oooo00<0
00000?ooo`3o0:d03P3oool20?l0MPh0oooo00<0R`3o0?ooo`3oool00P3oool00`2;0?l0oooo0?oo
o`070?ooo`070?l0f@3oool0o`3I0?ooo`3o0=T0oooo0?l0f@030?ooo`050?X0o`3oool0nP3o0?X0
o`3oool00P3j0?l<0?ooo`03000_o`3oool0oooo00P0oooo00D02P3o0?ooo`3oool0oooo00X0o`08
0?ooo`03000_o`3oool0oooo00X0oooo00<0E`3o0?ooo`3oool00`00ROl70?ooo`H0E`3o2`3oool4
0?X0o`l0oooo00<0R`3o0?ooo`3oool0103oool00`3o0:d0oooo05L0o`030?ooo`030?l0[@3oool0
oooo0080oooo00D0Q@3o0?ooo`3oool0oooo000000050?ooo`030;H0o`3oool0oooo00X0oooo00<0
R`3o0?ooo`3oool0603oool01P3o02H0oooo0?l09P3oool0o`0V0?ooo`@0o`0V0`3oool20?l0fAT0
oooo00<000000?ooo`3oool08@3oool001X0oooo00<000000?ooo`3oool0803oool01`3o02H0oooo
0?ooo`3o02H0oooo0?l09P3oool00P3o02H20?ooo`80o`3I4@3oool010000000oooo0?l0[@3o0:d>
0?ooo`030?l0MP3oool0oooo00`0oooo00<0R`3o0?ooo`3oool00P2;0?l90?ooo`030?l0f@3oool0
oooo00@0o`3I0P3oool30?X0o`80oooo00<0nP3o0?ooo`3j0?l03@3oool00`00;ol0oooo0?ooo`08
0?ooo`0300X0o`3oool02P3o00X0oooo00<002oo0?ooo`3oool02@3oool01@1G0?l0oooo0?ooo`3o
ool008Wo00P0oooo00<0E`3o0?ooo`3oool01P1G0?l90?ooo`80nP3o1`3oool00`00;ol0oooo0?oo
o`040?ooo`80R`3o1@3oool40?l0[@0405L0o`3oool0oooo0?l0[@@0oooo00<0Q@3o0?ooo`3oool0
0P3oool00`000000oooo0?ooo`030?ooo`030;H0o`3oool0oooo00X0oooo00<0R`3o0?ooo`3oool0
603oool01@3o02H0oooo0?l09P3o02H0oooo00<0o`0V0`3oool20?l0fA`0oooo00<000000?ooo`3o
ool0803oool001X0oooo00<000000?ooo`3oool07`3oool30?l09P070?ooo`3o02H0oooo0?ooo`3o
02H0oooo0?l09P040?ooo`030?l0f@3oool0oooo00l0oooo00@000000?ooo`3oool0o`2]3P3oool0
0`3o07H0oooo0?ooo`0<0?ooo`80R`3o0P3oool00`2;0?l0oooo0?ooo`050?ooo`040?l0f@3oool0
oooo0?ooo`D0o`3I0P3oool30?X0o`80oooo0P3j0?l=0?ooo`03000_o`3oool0oooo00T0oooo0P0:
0?l:0?ooo`03000_o`3oool0oooo00T0oooo00<0E`3o0?ooo`3oool02`3oool0101G0?l0oooo05L0
o`1G0?l20?ooo`0305L0o`3oool0oooo00P0oooo00<0nP3o0?ooo`3oool01@3oool00`00;ol0R`3o
08/0o`0308/0o`030?ooo`2;0?l0oooo00D0oooo00D0o`2]0?ooo`3o0:d0oooo0?l0[@020?ooo`03
0?l0[@3oool0oooo0080oooo00<0Q@3o0?ooo`3oool00`3oool01P000000oooo0?ooo`2f0?l0oooo
0;H0o`L0oooo102;0?l00`3oool0R`3o0?ooo`0J0?ooo`D0o`0V0P3oool0103o02H0oooo0?ooo`3o
0=TN0?ooo`030000003oool0oooo0200oooo000J0?ooo`030000003oool0oooo0240oooo2@3o02H4
0?ooo`80o`3I403oool00`000000oooo0?ooo`020?l0[@d0oooo0P3o07H=0?ooo`0408/0o`3oool0
oooo08/0o`L0oooo1P3o0=T00`3oool0o`3I0?l0f@040?ooo`H0nP3o3@3oool00`00;ol0oooo0?oo
o`090?ooo`802P3o2@3oool00`00;ol0oooo0?ooo`090?ooo`0305L0o`3oool0oooo00/0oooo101G
0?l00`3oool0E`3o0?ooo`0B0?ooo`04000_o`2;0?l0oooo08D0o`<0R`3o1P3oool01P3o0:d0oooo
0?ooo`3o0:d0oooo05L0o`80o`2]1@3oool00`250?l0oooo0?ooo`030?ooo`030000002f0?l0]P3o
00<0]P3o1`3oool608/0oaX0oooo103o02H40?ooo`030?l09P3o0=T0o`3I0200oooo00<000000?oo
o`3oool07`3oool001X0oooo00<000000?ooo`3oool09P3oool40?l09PH0oooo0P3o0=T?0?ooo`05
0000003oool0oooo0?ooo`3o0:d03P3oool00`3o07H0oooo0?ooo`090?ooo`0608/0o`3oool0R`3o
08/0o`3oool0R`3o2P3oool50?l0f@P0oooo0P3j0?l=0?ooo`03000_o`3oool0oooo00T0oooo1P0:
0?l50?ooo`03000_o`3oool0oooo00T0oooo00<0E`3o0?ooo`3oool02`3oool505L0oa<0oooo00@0
02oo0?ooo`2;0?l0Q@3o0P2;0?l00`3oool0R`3o0?ooo`030?ooo`80o`2]0P3oool0103o0:d0oooo
05L0o`3oool20?l0[@0508D0o`3oool0oooo0?ooo`250?l01@3oool01@2f0?l000000?ooo`2f0?l0
oooo0080]P3o1`3oool00`2;0?l0oooo08/0o`0208/0o`030?ooo`2;0?l0R`3o00h0oooo0P3o04d8
0?ooo`<0o`0V00<0oooo0?l09P3oool00P3oool00`3o0=T0oooo0?ooo`0Q0?ooo`030000003oool0
oooo01h0oooo000I0?ooo`030000003oool0oooo02<0oooo00<0o`1=0?ooo`3oool03@3oool00`3o
0=T0oooo0?ooo`0=0?ooo`040000003oool0oooo0?ooo`80o`2]3@3oool00`3o07H0oooo0?ooo`07
0?ooo`80R`3o0`3oool208/0o`X0oooo00<008Wo0?ooo`3oool02`3oool00`1G0?l0oooo0?ooo`0<
0?ooo`03000_o`3oool0oooo00H0oooo1P0:0?l00`3oool02P3o0?ooo`050?ooo`03000_o`3oool0
oooo00L0oooo0P1G0?l>0?ooo`80E`3o5@3oool01@00;ol0R`3o0?ooo`250?l0R`3o0080oooo00D0
R`3o0?ooo`3oool0oooo0?l0[@040?ooo`0:0?l0[@3oool0o`2]0?l0[@3oool0Q@3o0?l0[@250?l0
oooo08D0o`D0oooo00@0]P3o0?ooo`3oool000000P2f0?l20?ooo`030;H0o`3oool0oooo00@0oooo
00<0R`3o0?ooo`2;0?l00`2;0?l20?ooo`0308/0o`3oool0oooo00T0oooo0P3o04d<0?ooo`@0o`0V
0P3o0=T00`3oool0o`0V0?ooo`0Q0?ooo`030000003oool0oooo01h0oooo000I0?ooo`030000003o
ool0oooo02@0oooo0P3o04d>0?ooo`80o`3I3P3oool00`000000oooo0?ooo`020?ooo`030?l0[@3o
ool0oooo00/0oooo0P3o07H40?ooo`030?l0MP3oool0oooo0080oooo1P2;0?l:0?ooo`030029o`3o
ool0oooo00/0oooo00<0E`3o0?ooo`3oool02`3oool00`00;ol0oooo0?ooo`050?ooo`0300X0o`3o
ool0oooo00H02P3o1P3oool00`00;ol0oooo0?ooo`050?ooo`<0E`3o00<0oooo05L0o`1G0?l0303o
ool00`1G0?l0oooo0?ooo`040?ooo`0300X0o`3oool0oooo00`0oooo00D002oo0?ooo`2;0?l0Q@3o
08/0o`040?ooo`0508/0o`3oool0oooo0?ooo`3o0:d00`3oool20?l0[@<0oooo00<0Q@3o0?l0[@3o
ool00P250?l50?ooo`80]P3o00@0oooo0000002f0?l0]P3o0`3oool00`2f0?l0oooo0?ooo`040?oo
o`<0R`3o0P3oool208/0o`X0oooo0P3o04d?0?ooo`0400X0o`3o0=T0o`3I0?ooo`<0o`0V8`3oool0
0`000000oooo0?ooo`0M0?ooo`006@3oool00`000000oooo0?ooo`0V0?ooo`030?l0C@3oool0oooo
00d0oooo0P3o0=T=0?ooo`030000003oool0oooo0080oooo00<0o`2]0?ooo`3oool0303oool01@3o
07H0oooo0?ooo`3o07H0oooo0080o`1f1P3oool208/0o`/0oooo00<008Wo0?ooo`3oool02`3oool0
0`1G0?l0oooo0?ooo`0;0?ooo`03000_o`3oool0oooo00<0oooo00D02P3o0?ooo`3oool0oooo00X0
o`020?ooo`<02P3o1P3oool00`00;ol0oooo0?ooo`030?ooo`80E`3o0P3oool0101G0?l0oooo0?oo
o`3oool205L0oa00oooo00<02P3o0?ooo`3oool03@3oool01000;ol0oooo08/0o`250?l608/0o`@0
oooo103o0:d00`1G0?l0oooo0?ooo`040?l0[@0308D0o`3oool0Q@3o00D0oooo0P2f0?l00`000000
]P3o0?ooo`040?ooo`030;H0o`3oool0oooo00<0oooo0P2;0?l00`3oool0R`3o08/0o`0:0?ooo`80
o`1=403oool00`0:0?l0o`3I0?ooo`0Y0?ooo`030000003oool0oooo01`0oooo000I0?ooo`030000
003oool0oooo02L0oooo00<0o`1=0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`0;0?ooo`030000
003oool0oooo0080oooo0P3o0:d=0?ooo`040?l0MP3oool0o`1f0?ooo`80o`1f4P3oool00`2f0?l0
oooo0029o`0=0?ooo`0305L0o`3oool0oooo00X0oooo00<002oo0?ooo`3oool0103oool0100:0?l0
oooo0?ooo`0:0?l20?ooo`<02P3o1P3oool00`00;ol0oooo0?ooo`040?ooo`@0E`3o0P3oool205L0
oa40oooo00<02P3o001Vo`3oool0303oool01000;ol0oooo0?ooo`250?l<0?ooo`H0o`2]0P250?l0
0`3o0:d0oooo0?ooo`0308D0o`@0oooo00@0]P3o0?ooo`000000]P3o0`3oool20;H0o`H0oooo0`2;
0?l:0?ooo`80o`1=203oool50?l0f@@0oooo00<02P3o0?l0f@3oool0:P3oool00`000000oooo0?oo
o`0L0?ooo`006@3oool00`000000oooo0?ooo`0X0?ooo`80o`1=3`3oool20?l0f@`0oooo00<00000
0?ooo`3oool00`3oool00`3o0:d0oooo0?ooo`050?l0[@H0oooo0P3o07H0103oool0o`1f0?l0MP3o
07HB0?ooo`80]P3o00<008Wo0?ooo`3oool02`3oool00`1G0?l0oooo0?ooo`0:0?ooo`03000_o`3o
ool0oooo00@0oooo200:0?l70?ooo`04000_o`3oool002oo000_o`80oooo00<0E`3o0?ooo`3oool0
101G0?lA0?ooo`0300X0o`3oool006Ko00`0oooo00D002oo0?ooo`3oool0oooo08D0o`0<0?ooo`80
o`2]00P0E`3o0?ooo`3oool0oooo08D0o`3o0:d0Q@3o0?ooo`<0Q@3o1@3oool01@2f0?l0oooo0000
002f0?l0oooo0080]P3o203oool00`2;0?l0oooo0?ooo`080?ooo`80o`1=2P3oool00`3o0=T0oooo
0?ooo`020?l0f@80oooo00<0o`3I00X0o`3oool0;@3oool00`000000oooo0?ooo`0K0?ooo`006@3o
ool00`000000oooo0?ooo`0Z0?ooo`030?l0C@3oool0oooo00h0oooo0P3o0=T;0?ooo`030000003o
ool0oooo00<0oooo0P3o0:d00`3oool0o`2]0?ooo`020?l0[@H0oooo00@0o`1f0?ooo`3o07H0oooo
0P3o07H40?ooo`0305L0o`3oool0oooo00d0oooo00<0]P3o0029o`3oool0303oool00`1G0?l0oooo
0?ooo`090?ooo`03000_o`3oool0oooo00D0oooo0`0:0?l:0?ooo`D002oo0`3oool00`1G0?l0oooo
05L0o`0205L0o`h0oooo0P0:0?l20?ooo`0300X0o`3oool006Ko00`0oooo00@002oo0?ooo`3oool0
Q@3o3P3oool20?l0[@80oooo0P3o0:d408D0o`P0oooo00@0]P3o0000002f0?l0]P3o2@3oool60?l0
C@@0oooo0P3o04d;0?ooo`040?l0f@3oool0o`3I0?l0f@80oooo0P3o0=T00`0:0?l0oooo0?ooo`0]
0?ooo`030000003oool0oooo01/0oooo000H0?ooo`030000003oool0oooo02`0oooo0P3o04d@0?oo
o`80o`3I1@3oool20?l0f@80oooo00<000000?ooo`3oool0103oool20?l0[@050?ooo`3o0:d0o`2]
0?ooo`3o0:d0103oool01P3o07H0oooo0?l0MP3oool0o`1f0?ooo`80o`1f103oool00`1G0?l0oooo
0?ooo`0>0?ooo`030029o`3oool0oooo00/0oooo00<0E`3o0?ooo`3oool02@3oool00`00;ol0oooo
0?ooo`050?ooo`0300X0o`3oool0oooo00L0oooo1000;ol00`3oool002oo0?ooo`040?ooo`80E`3o
00<0oooo05L0o`3oool03@3oool01P0:0?l0oooo00X0o`0:0?l0oooo001Vo``0oooo00D002oo0?oo
o`3oool0oooo08D0o`0>0?ooo`0505L0o`3o0:d0oooo0?l0[@3oool00P250?l;0?ooo`030;H0o`00
0000oooo00X0oooo00@0o`1=0?ooo`3oool0oooo0P3o04d20?ooo`80o`1=00<0nP3o0?ooo`3oool0
2P3oool00`3o0=T0oooo0?l0f@020?ooo`030?l0f@0:0?l02P3o0300oooo0P00000L0?ooo`00603o
ool00`000000oooo0?ooo`0^0?ooo`030?l0C@3oool0oooo00l0oooo00@0o`3I0?ooo`3oool0oooo
103o0=T20?ooo`030000003oool0oooo0080oooo00<0o`2]0?ooo`3oool00`3o0:d00`3oool0o`2]
0?ooo`030?ooo`030?l0MP3oool0o`1f0080oooo0`3o07H50?ooo`80E`3o3`3oool00`00ROl0]P3o
0?ooo`0;0?ooo`0305L0o`3oool0oooo00P0oooo00<002oo0?ooo`3oool0403oool01@00;ol0oooo
000_o`3oool002oo00D0oooo0`1G0?l>0?ooo`802P3o0P3oool200X0o`030?l0f@3oool0oooo00X0
oooo00@002oo0?ooo`3oool0Q@3o3P3oool0101G0?l0oooo0?ooo`3o0:d@0?ooo`030000003oool0
oooo00P0oooo0P3o04d20?ooo`030?l0C@3oool0o`1=0080o`1=0P3j0?l=0?ooo`070?l0f@3oool0
o`3I0?ooo`3o0=T02P3o0?l0f@0^0?ooo`<0000000<0oooo0000003oool06`3oool001P0oooo00<0
00000?ooo`3oool01P3oool00`3o0:d0oooo0?ooo`0V0?ooo`80o`1=403oool20?l0f@030?ooo`3o
0=T0o`3I0080o`3I0`3oool01@000000oooo0?ooo`3oool0o`2]00<0oooo103o0:d30?ooo`H0o`1f
0P3oool20?l0MPH0oooo00<0E`3o0?ooo`3oool0303oool01000ROl0oooo0;H0o`2f0?l40?ooo`<0
]P3o0`3oool00`1G0?l0oooo0?ooo`090?ooo`03000_o`3oool0oooo0100oooo1000;ol60?ooo`03
05L0o`3oool0oooo0080oooo00<00<go0?ooo`3oool0203oool01`0:0?l0oooo00X0o`0:0?l0oooo
0?l0f@00I_l02`3oool01@00;ol0oooo0?ooo`3oool0Q@3o00h0oooo00<0E`3o0?ooo`3oool04@3o
ool00`000000oooo0?ooo`080?ooo`@0o`1=00D0oooo0?l0C@3o04d0oooo0?X0o`0?0?ooo`@0o`3I
00<02P3o0?ooo`3o0=T0:`3oool3000000@0oooo00<000000?ooo`3oool06P3oool001P0oooo00<0
00000?ooo`3oool01`3oool20?l0[BP0oooo00<0o`1=0?ooo`3oool03`3oool20?l0f@80oooo0P3o
0=T30?ooo`030000003oool0o`2]00<0oooo00<0o`2]0?ooo`3oool00`3o0:d70?ooo`D0o`1f1`3o
ool00`1G0?l0oooo0?ooo`0<0?ooo`050029o`3oool0oooo0;H0o`00ROl00P2f0?l20?ooo`030;H0
o`3oool0oooo0080oooo00<0E`3o0?ooo`3oool0203oool00`00;ol0oooo0?ooo`0A0?ooo`8002oo
303oool00`00cOl0oooo0?ooo`070?ooo`0300X0o`3oool0oooo00802P3o00<0o`3I00X0o`00I_l0
2`3oool01000;ol0oooo0?ooo`250?l>0?ooo`0305L0o`3oool0oooo0180oooo00<000000?ooo`3o
ool0203oool50?l0C@030?ooo`3j0?l0nP3o00l0oooo0`3o0=T00`3oool02P3o0?ooo`020?ooo`03
0?l0f@3oool0oooo02D0oooo0P0000020?l000H0oooo00<000000?ooo`3oool06P3oool001P0oooo
00<000000?ooo`3oool02@3oool20?l0[BL0oooo00<0o`1=0?ooo`3oool03@3oool20?l0f@050?oo
o`3o0=T0oooo0?ooo`3o0=T0103oool00`000000o`2]0?l0[@080?l0[@@0oooo00<0nP3o0?ooo`3o
ool03@3oool00`1G0?l0oooo0?ooo`0<0?ooo`030029o`3oool008Wo00<008Wo0P3oool00`2f0?l0
oooo0?ooo`030?ooo`0305L0o`3oool0oooo00P0oooo00<002oo0?ooo`00;ol04@3oool00`00;ol0
oooo0?ooo`0:0?ooo`03003=o`3oool0oooo00L0oooo00L0o`3I00X0o`0:0?l02P3o0?l0f@3oool0
06Ko00P0oooo00@002oo0?ooo`3oool002oo0`3oool00`250?l0oooo0?ooo`070?ooo`@0E`3o00<0
oooo05L0o`3oool04`3oool00`000000oooo0?ooo`070?ooo`@0o`1=0P3oool00`3j0?l0oooo0?l0
C@0>0?ooo`0500X0o`3o0=T0o`3I0?l0f@0:0?l01@3o0=TT0?ooo`<000000P3o00090?ooo`030000
003oool0oooo01T0oooo000H0?ooo`030000003oool0oooo00/0oooo0P3o0:dV0?ooo`80o`1=3@3o
ool20?l0f@80oooo0P3o0=T00`3oool0o`3I0?ooo`030?ooo`030000003oool0oooo00`0oooo0P3j
0?l>0?ooo`80E`3o3@3oool02@00ROl0oooo0;H0o`00ROl0]P3o0029o`2f0?l0oooo0;H0o`050?oo
o`0505L0o`3oool0oooo0?ooo`1G0?l01@3oool5000_oa`0oooo00<00<go0?ooo`3oool01@3oool4
0?l0f@0500X0o`3o0=T02P3o00X0o`00I_l01`3oool4000_o`80oooo0P250?l:0?ooo`80E`3o00@0
oooo05L0o`1G0?l0E`3o503oool00`000000o`3I0?ooo`070?ooo`@0o`1=0P3j0?l20?ooo`030?l0
C@3oool0oooo00/0oooo00D02P3o0?ooo`3oool0oooo00X0o`0W0?ooo`<000000`3o000;0?ooo`03
0000003oool0oooo01T0oooo000G0?ooo`030000003oool0oooo00h0oooo0P3o0:dV0?ooo`030?l0
C@3oool0oooo00T0oooo1@3o0=T20?ooo`80o`3I1@3oool00`000000oooo0?ooo`0=0?ooo`030?X0
o`3oool0oooo00d0oooo00<0E`3o0?ooo`3oool02@3oool01000ROl0oooo0029o`3oool30029o`<0
]P3o1P3oool00`1G0?l0oooo05L0o`0305L0o`040?ooo`00;ol002oo0?ooo`8002oo00<0oooo000_
o`3oool0603oool01000;ol0oooo0?ooo`00cOl60?ooo`030?l0f@3oool0o`3I0080oooo00D0o`3I
0?ooo`0:0?l02P3o001Vo`070?ooo`8002oo00<0oooo000_o`250?l00`250?l:0?ooo`0305L0o`3o
ool0E`3o0080E`3o00<0oooo05L0o`1G0?l0403oool20?l0f@030000003oool0oooo00T0oooo00<0
o`1=0?X0o`3o04d0103o04d<0?ooo`0500X0o`3oool0oooo0?ooo`0:0?l09@3oool3000000030?oo
o`3o0000o`0000h0oooo00<000000?ooo`3oool06@3oool001L0oooo00<000000?ooo`3oool0403o
ool20?l0[BD0oooo0P3o04d>0?ooo`D0o`3I1@3oool00`000000oooo0?ooo`0=0?ooo`030?X0o`3o
ool0oooo00d0oooo00<0E`3o0?ooo`3oool01`3oool20029o`030?ooo`2f0?l008Wo008008Wo00@0
oooo0;H0o`2f0?l0]P3o1`3oool00`1G0?l0oooo0?ooo`0205L0o`H002oo00<0oooo000_o`3oool0
303oool00`2;0?l0oooo0?ooo`020?ooo`0308/0o`3oool0oooo00@0oooo00@002oo0?ooo`3oool0
0<go1@3oool0103o0=T0oooo0?ooo`3o0=T20?ooo`050?l0f@3oool0oooo0?ooo`00I_l01`3oool2
000_o`80Q@3o00D0oooo08D0o`250?l0oooo08D0o`090?ooo`0305L0o`3oool0E`3o0080E`3o0P3o
ool205L0o`d0oooo0P3o0=T20?ooo`030000003oool0oooo00P0oooo0P3j0?lA0?ooo`0500X0o`3o
ool0oooo0?ooo`0:0?l08P3oool4000000040?ooo`3o0000o`000?l00100oooo00<000000?ooo`3o
ool06@3oool001L0oooo00<000000?ooo`3oool04P3oool20?l0[BD0oooo00<0o`1=0?ooo`3oool0
0P3oool30?l0C@/0oooo0P0:0?l40?ooo`030000003oool0iP3o00d0oooo0P3j0?l>0?ooo`0305L0
o`3oool0oooo00L0oooo1P00ROl30;H0o`P0oooo1@1G0?l01@3oool002oo000_o`00;ol0oooo0080
02oo3`3oool00`2;0?l0oooo08/0o`0308/0o`D0oooo00@002oo0?ooo`3oool00<go0`3oool20?l0
f@80oooo00P0o`3I0?ooo`3oool0o`3I0?ooo`3o0=T0oooo001Vo`P0oooo00<002oo08D0o`00;ol0
0P00;ol208D0o`030?ooo`250?l0oooo00T0oooo0`1G0?l0103oool0E`3o05L0o`1G0?l<0?ooo`80
o`3I103oool00`000000oooo0?ooo`070?ooo`030?X0o`3oool0oooo00l0oooo0P0:0?l30?ooo`03
00X0o`3oool0oooo01P0oooo0`3o00030?ooo`<000000`3oool20?l001<0oooo00<000000?ooo`3o
ool06@3oool001L0oooo00<000000?ooo`3oool0503oool20?l0[B@0oooo0P3o04d00`3oool0o`1=
0?ooo`020?l0C@d0oooo0`0:0?l20?ooo`040000003oool0iP3o0>H0o`d0oooo00<0nP3o0?ooo`3o
ool0303oool205L0o`T0oooo1000ROl:0?ooo`0605L0o`3oool0oooo05L0o`3oool0E`3o0`3oool4
000_o`l0oooo0P2;0?l20?ooo`80R`3o1@3oool01000;ol0oooo0?ooo`00cOl20?ooo`030?l0f@3o
ool0oooo0080oooo00<0o`3I0?ooo`3o0=T00`3oool00`3o0=T006Ko0?ooo`070?ooo`04000_o`25
0?l0Q@3o000_o`80Q@3o0`3oool00`250?l0oooo0?ooo`070?ooo`80E`3o00<0oooo05L0o`1G0?l0
0P3oool30?l0f@L0oooo0P3o0=T60?ooo`030000003oool0oooo00@0oooo00<002oo0?X0o`3j0?l0
4@3oool300X0o`80oooo00<02P3o0?ooo`3oool06@3oool00`3o0000oooo0?ooo`040?l000<0oooo
0P3o000E0?ooo`030000003oool0oooo01T0oooo000G0?ooo`030000003oool0oooo01H0oooo0P3o
0:dT0?ooo`060?l0C@3oool0oooo0?l0C@3oool0o`1=3`3oool200X0o`050?ooo`000000oooo0?oo
o`3V0?l03@3oool20?X0o`h0oooo00<0E`3o0?ooo`3oool04`3oool205L0o`030?ooo`1G0?l0oooo
00<0E`3o0`3oool3000_o`h0oooo0P2;0?l01P3oool0R`3o0?ooo`2;0?l0oooo08/0o`@0oooo00@0
02oo0?ooo`3oool00<go0`3oool0103o0=T0oooo0?ooo`3oool20?l0f@@0oooo0P3o0=T80?ooo`80
02oo10250?l30?ooo`80Q@3o203oool305L0o`@0oooo00<0o`3I0?ooo`3oool01`3o0=T80?ooo`04
0000003j0?l0nP3o0?X0o`80oooo00<002oo0?X0o`3oool04P3oool200X0o`030?ooo`0:0?l02P3o
01/0oooo0P3o0002000000030?ooo`3o0000o`0000@0o`005`3oool00`000000oooo0?ooo`0I0?oo
o`005`3oool00`000000oooo0?ooo`0H0?ooo`80o`2]8@3oool01@3o04d0oooo0?l0C@3o04d0oooo
0080o`1=4@3oool300X0o`80oooo0P3V0?l=0?ooo`030?X0o`3oool0oooo00`0oooo00<0E`3o0?oo
o`3oool04`3oool705L0o`D0oooo00<002oo0?ooo`3oool01`3oool00`00oo00oooo0?ooo`030?oo
o`D0R`3o00<0oooo08/0o`3oool00P3oool01@00;ol0oooo0?ooo`3oool00<go00@0oooo103o0=T0
0`3oool0o`3I0?l0f@030?l0f@03001Vo`3oool0oooo00H0oooo0P00;ol00`250?l0oooo08D0o`02
0?ooo`<0Q@3o2@3oool00`1G0?l0oooo0?ooo`040?ooo`040?l0f@3oool0oooo0?ooo`<0o`3I2`3o
ool01`3j0?l000000?X0o`3j0?l0oooo000_o`3j0?l04`3oool200X0o`030?ooo`0:0?l02P3o01X0
oooo0P0000020?l00080oooo00@0o`000?ooo`3o0000o`001`3oool20?l0CA40oooo00<000000?oo
o`3oool06@3oool001L0oooo00<000000?ooo`3oool06P3oool20?l0[@T0oooo00<0o`2]0?ooo`3o
ool04`3oool00`3o04d0oooo0?l0C@020?l0C@030?ooo`3o04d0o`1=01<0oooo0`0:0?l00`3oool0
iP3o0?ooo`0<0?ooo`030?X0o`3oool0oooo00`0oooo00<0E`3o0?ooo`3oool05P3oool305L0o`l0
oooo00<00?o`0?ooo`3oool00`3oool00`2;0?l0oooo0?ooo`0508/0o`80oooo00D002oo0?ooo`3o
ool0oooo003=o`040?ooo`030?l0f@3oool0o`3I0080o`3I0P3oool00`3o0=T0oooo001Vo`0<0?oo
o`H0Q@3o403oool20?l0f@060?ooo`3o0=T0o`3I0?l0f@3oool0o`3I2P3oool00`3j0?l0oooo0000
00020?ooo`03000_o`3oool0oooo0180oooo0P0:0?l00`3oool02P3o0?ooo`0200X0oaH0oooo0`00
00020?ooo`030?l0003oool0o`0000<0o`0000<0oooo0?l0003oool0103oool20?l0CA@0oooo00<0
00000?ooo`3oool0603oool001H0oooo00<000000?ooo`3oool07@3oool20?l0[@D0oooo0P3o0:d0
0`3oool0o`2]0?ooo`0B0?ooo`040?l0C@3oool0oooo0?l0C@80oooo00@0o`1=0?ooo`3o04d0nP3o
4`3oool00`000000oooo00X0o`0200X0o`030>H0o`3oool0oooo00@0oooo00<02P3o0>H0o`3V0?l0
0`3oool20?X0o`d0oooo0P1G0?l30?ooo`0305L0o`3oool0oooo02<0oooo00<00?o`0?ooo`3oool0
0`3oool0102;0?l0oooo08/0o`3oool208/0o`<0oooo00D002oo0?ooo`3oool0oooo003=o`050?oo
o`80o`3I0`3oool0103o0=T0oooo0?ooo`00I_l<0?ooo`@0Q@3o4P3oool40?l0f@040?ooo`1G0?l0
oooo0?l0f@X0oooo0P3j0?l010000000nP3o000_o`3j0?lB0?ooo`802P3o00<0oooo00X0o`0:0?l0
0P3oool300X0oa80oooo0`0000040?ooo`@0o`001@3oool00`3o0000oooo0?l0C@020?l0CAH0oooo
00<000000?ooo`3oool0603oool001H0oooo00<000000?ooo`3oool07`3oool20?l0[@80oooo00D0
o`2]0?ooo`3o0:d0oooo0?l0[@0B0?ooo`L0o`1=00@0oooo0?l0C@3o04d0o`1=0P3j0?lB0?ooo`04
0000003oool0oooo0?ooo`<02P3o0`3V0?l0100:0?l0oooo00X0o`3V0?l50?ooo`030?X0o`3oool0
oooo00`0oooo00@0E`3o0?ooo`1G0?l0E`3o9@3oool00`00oo00oooo0?ooo`030?ooo`0408/0o`3o
ool0R`3o08/0o`D0oooo00<002oo0?ooo`3oool00P00cOl60?ooo`@0o`3I0`3oool00`00I_l0oooo
0?ooo`0P0?ooo`<0o`3I0P1G0?l20?ooo`030?l0f@3oool0oooo00P0oooo0P3j0?l01@00000002oo
0?ooo`3oool0nP3o00X0oooo00<0o`3I0?ooo`0:0?l00`3oool00`0:0?l0oooo0?ooo`0600X0oa40
oooo0`0000070?ooo`@0o`001@3oool20?l0CAT0oooo00<000000?ooo`3oool0603oool001H0oooo
00<000000?ooo`3oool08@3oool40?l0[@040?ooo`3o0:d0oooo0?l0[AH0oooo1P3o04d20?ooo`80
nP3o4@3oool00`000000oooo0?ooo`030?ooo`802P3o00<0oooo00X0o`3oool00P0:0?l60?ooo`03
0?X0o`3oool0oooo0080oooo0P3j0?l80?ooo`0405L0o`3oool0oooo05L0oaD0oooo00<002oo0?oo
o`3oool0303oool00`00oo00oooo0?ooo`040?ooo`0308/0o`3oool0oooo00D0oooo00<002oo0?oo
o`3oool01@00cOl40?ooo`030?l0f@3oool0oooo00<0oooo00<006Ko0?ooo`3oool08@3oool00`3o
0=T0E`3o0?l0f@020?l0f@030?ooo`3o0=T0oooo00P0oooo0P3j0?l00`00;ol000000?X0o`020?oo
o`030?X0o`3oool0oooo00H0oooo0P3o0=T400X0o`030?ooo`0:0?l0oooo0080oooo0P0:0?lB0?oo
o`<0000000<0oooo0?l09P3o02H02@3oool40?l000<0o`1=00<0o`000?ooo`3oool0603oool00`00
0000oooo0?ooo`0H0?ooo`005P3oool00`000000oooo0?ooo`0R0?ooo`<0o`2]0P3oool20?l0[A@0
oooo00<0o`3I0?ooo`3oool02@3oool20?X0oa00oooo00<000000?ooo`3oool00P3oool20>H0o`<0
2P3o0P3V0?l00`0:0?l0oooo0?ooo`040?ooo`80nP3o00<0oooo0?X0o`3oool00`3j0?l60?ooo`80
E`3o00<0oooo05L0o`3oool04@3oool01@3o0=T0oooo0?ooo`3oool002oo00D0oooo00<0R`3o0?oo
o`3oool01P3oool00`00oo00oooo0?ooo`0;0?ooo`03000_o`3oool00<go00800<go00<0oooo003=
o`3oool01@3oool5001VoaD0oooo00<0]P3o0?ooo`3oool0303oool0101G0?l0oooo0?ooo`3oool3
0?l0f@T0oooo00@0nP3o000_o`3j0?l000000P3j0?l00`3o0=T0nP3o0?X0o`050?ooo`80o`3I00@0
oooo00X0o`3oool02P3o0P3oool00`0:0?l0oooo0?ooo`0C0?ooo`<000000P3oool20?l09P<0o`1=
2P3oool20?l0C@@0o`006P3oool00`000000oooo0?ooo`0H0?ooo`005P3oool00`000000oooo0?oo
o`0Q0?ooo`040?l0[@3oool0o`2]0?ooo`80o`2]00<0oooo0?l0[@3o0:d0503oool20?l0f@/0oooo
0P3j0?l?0?ooo`080000003oool0oooo0?ooo`3V0?l0oooo00X0o`3V0?l500X0o`L0oooo0P3j0?l0
103oool0nP3o0?X0o`3j0?l50?ooo`0305L0o`3oool0oooo00<0E`3o3`3oool30?l0f@@0oooo00<0
02oo0?ooo`3oool00P3oool00`2;0?l0oooo0?ooo`060?ooo`03003ol03oool0oooo00/0oooo00<0
02oo0?ooo`00cOl01000cOl60?ooo`03001Vo`3oool006Ko00<006Ko303oool20;H0o`D0oooo00<0
]P3o0?ooo`3oool02`3oool205L0oa00oooo00@002oo0?ooo`3oool000000P3o0=T00`3oool0o`3I
0?ooo`030?ooo`80o`3I0`3oool300X0o`030?ooo`0:0?l02P3o0180oooo0`0000020?ooo`<0o`0V
0P3oool00`3o04d0oooo0?ooo`030?l0C@@0oooo0`3o04dP0?ooo`030000003oool0oooo01P0oooo
000F0?ooo`030000003oool0oooo0240oooo00<0o`2]0?ooo`3o0:d00`3oool30?l0[AH0oooo00<0
o`3I0?ooo`3oool02P3oool20?X0o`h0oooo00D000000?ooo`3oool0iP3o00X0o`020?ooo`0300X0
o`3V0?l02P3o00<02P3o1P3oool30?X0o`040?ooo`3j0?l0oooo0?X0o`<0oooo101G0?l20?ooo`03
05L0o`3oool0oooo00D0oooo0P3o0=T40?ooo`80o`3I0P3oool20?l0f@@0oooo00<002oo0?ooo`3o
ool00`2;0?l80?ooo`03003ol03oool0oooo00T0oooo0P00;ol20?ooo`<00<go203oool00`00I_l0
oooo001Vo`04001Vo`X0oooo00D0]P3o0?ooo`2f0?l0]P3o0?ooo`020;H0o`d0oooo00<0E`3o0?oo
o`3oool02@3oool00`00;ol0oooo0?ooo`030?ooo`09000_o`3oool0oooo0?ooo`000000oooo0?l0
f@3oool0o`3I00<0oooo00<0o`3I0?ooo`3oool00`3oool200X0o`050?ooo`0:0?l0oooo0?ooo`0:
0?l03P3oool3000000<0oooo0P3o02H40?ooo`040?l0C@3oool0o`1=0?ooo`<0o`1=00@0oooo0?l0
C@3o04d0o`1=8`3oool00`000000oooo0?ooo`0H0?ooo`005@3oool00`000000oooo0?ooo`0Q0?oo
o`/0o`2]5P3oool00`3o0=T0oooo0?ooo`0;0?ooo`030?X0o`3oool0oooo00`0oooo00<000000?oo
o`3V0?l01`0:0?l70?ooo`060?X0o`3oool0oooo0?ooo`3j0?l0oooo0P3j0?l70?ooo`@0E`3o203o
ool40?l0f@@0oooo0P3o0=T50?ooo`06000_o`2;0?l0oooo08/0o`3oool0R`3o1`3oool00`00oo00
oooo0?ooo`080?ooo`<002oo0`3oool00`00cOl0oooo0?ooo`070?ooo`06001Vo`3oool006Ko001V
o`3oool006Ko2P3oool20;H0o`<0oooo0P2f0?l=0?ooo`0305L0o`3oool0oooo00T0oooo00<002oo
0?ooo`3oool00`3oool00`00;ol0oooo0?ooo`020?l0f@030000003o0=T0oooo0080oooo0`3o0=T6
0?ooo`<02P3o0`3oool200X0o`@0oooo0`3o02H30?ooo`<000000`3oool30?l09PH0oooo00@0o`1=
0?ooo`3o04d0o`1=0P3oool20?l0CBL0oooo00<000000?ooo`3oool05`3oool001D0oooo00<00000
0?ooo`3oool0@`3oool20?l0f@`0oooo0P3j0?l=0?ooo`030000003V0?l0iP3o00<02P3o2P3oool0
103j0?l0oooo0?ooo`3oool20?X0o`030?ooo`3j0?l0oooo01@0oooo00<00<go0?l0f@3o0=T00P3o
0=T00`3oool0o`3I0?l0f@050?ooo`0408/0o`00;ol0oooo08/0o`80oooo00<0R`3o0?ooo`3oool0
103oool00`00oo00oooo0?ooo`060?ooo`8002oo00<0oooo000_o`3oool00P00;ol<0?ooo`@006Ko
2`3oool20;H0o`80oooo0`2f0?l40?ooo`80E`3o1@3oool205L0o`/0oooo00<002oo0?ooo`3oool0
0`3oool01000;ol0oooo0?ooo`3o0=T20?ooo`040000003o0=T0oooo0?ooo`<0o`3I1`3oool700X0
o`D0oooo00<0o`0V0?ooo`0000000`3o02H40?ooo`80o`0V2@3oool00`3o04d0oooo0?l0C@030?l0
C@030?ooo`3o04d0oooo00D0oooo0P2;0?lO0?ooo`030000003oool0oooo01L0oooo000E0?ooo`03
0000003oool0oooo04D0oooo00<0o`3I0?ooo`3oool02`3oool20?X0o``0oooo00<000000?ooo`3o
ool02`3oool50?X0o`80oooo0`3j0?lE0?ooo`04003=o`3oool0oooo0?ooo`80o`3I00<0oooo0?l0
f@3oool00P3oool01@2;0?l0oooo000_o`3oool0R`3o00<0oooo00<0R`3o0?ooo`3oool0103oool0
0`00oo00oooo0?ooo`040?ooo`05000_o`3oool0oooo0?ooo`00;ol00`3oool00`00;ol0oooo0?oo
o`090?ooo`<006Ko2`3oool00`2f0?l0oooo0;H0o`020;H0o`030?ooo`2f0?l0oooo00@0oooo00<0
0?o`0?ooo`1G0?l00P1G0?l00`3oool0E`3o0?ooo`090?ooo`030?l09P3oool002oo008002oo0`3o
ool00`00;ol0oooo0?ooo`020?ooo`040?l0f@3oool000000?ooo`80o`3I0`3oool00`3o0=T0oooo
0?ooo`040?ooo`D02P3o1P3oool20?l09P030000003oool0o`0V0080o`0V00@0oooo0?l09P3o02H0
o`0V2P3oool40?l0C@@0oooo00@0o`1=0?ooo`3oool0oooo0`2;0?lQ0?ooo`030000003oool0oooo
01L0oooo000E0?ooo`030000003oool0oooo02P0oooo0`2f0?lK0?ooo`80o`3I3@3oool20?X0o`/0
oooo00<000000?ooo`3oool0303oool80?X0oaD0oooo00H0o`3I003=o`3oool0oooo0?l0f@3oool2
0?l0f@80oooo0`2;0?l00`3oool002oo08/0o`02000_o`<0R`3o1@3oool00`00oo00oooo0?ooo`05
0?ooo`04000_o`3oool0oooo000_o`80oooo00<002oo0?ooo`3oool02`3oool00`00I_l0oooo0?oo
o`0:0?ooo`<0]P3o0`3oool00`2f0?l0oooo0?ooo`020?ooo`04003ol01G0?l0oooo0?ooo`<0E`3o
2P3oool0103o02H0oooo0?l09P3oool3000_o`030?ooo`00;ol0oooo00@0oooo00@0o`3I0?ooo`00
0000o`3I1@3oool00`3o0=T0oooo0?ooo`0<0?ooo`<000000P3o02H0103oool0o`0V0?ooo`3oool2
0?l09Pd0oooo0`3o04d00`3oool0o`1=0?ooo`020?ooo`040?l0C@3oool0R`3o08/0ob@0oooo00<0
00000?ooo`3oool05`3oool001D0oooo00<000000?ooo`3oool0:`3oool50;H0oaP0oooo00<0o`3I
0?ooo`3oool0303oool20?X0o`H0oooo0P3j0?l20?ooo`030000003oool0oooo01X0oooo00<006Ko
0?ooo`3oool0303oool0103o0=T00<go0?l0f@3oool20?l0f@@0oooo00<0R`3o0?ooo`2;0?l0102;
0?l00`3oool0R`3o000_o`050?ooo`03003ol03oool0oooo00H0oooo1@00;olL0?ooo`<0]P3o0P3o
ool01@2f0?l0oooo0?ooo`3oool00?o`0080E`3o00D0oooo05L0o`1G0?l0oooo05L0o`080?ooo`<0
o`0V00D002oo0?l09P00;ol002oo0?ooo`02000_o`L0oooo00<0o`3I0000003o0=T01`3o0=T:0?oo
o`<000000`3oool00`3o02H0oooo0?l09P040?l09P@0oooo0P3o07H:0?ooo`D0o`1=0`2;0?lV0?oo
o`030000003oool0oooo01L0oooo000E0?ooo`030000003oool0oooo0300oooo1@2f0?l@0?ooo`05
0;H0o`3oool0oooo0?ooo`3o0=T03`3oool00`3j0?l0oooo0?ooo`020?ooo`@0nP3o0P3oool00`00
0000oooo0?ooo`0J0?ooo`03001Vo`3oool0oooo00/0oooo00@0o`3I0?ooo`00cOl0o`3I1`3oool0
102;0?l0oooo0?ooo`2;0?l2000_o`0308/0o`00;ol002oo00H0oooo00<00?o`0?ooo`3oool01`3o
ool00`00;ol0oooo0?ooo`070?ooo`030?l0f@3oool0oooo01@0oooo0`2f0?l40?ooo`03003ol01G
0?l0oooo0080E`3o0P3oool00`1G0?l0oooo0?ooo`050?ooo`040?l09P3oool0o`0V000_o`80oooo
00D0o`0V0?ooo`00;ol0oooo000_o`080?ooo`030000003oool0oooo00<0oooo0P3o0=T80?ooo`<0
00001@3oool40?l09P@0oooo00@0o`0V0?ooo`3o07H0o`1f3P3oool308/0o`<0o`1=9P3oool00`00
0000oooo0?ooo`0G0?ooo`00503oool00`000000oooo0?ooo`0T0?ooo`030?l0f@3oool0oooo00l0
oooo1@2f0?l;0?ooo`80]P3o0`3oool20?l0f@h0oooo0P3j0?l20?ooo`@0nP3o0`3oool00`000000
oooo0?ooo`0J0?ooo`8006Ko303oool00`3o0=T0oooo003=o`080?ooo`0708/0o`00;ol0R`3o0?oo
o`2;0?l0oooo000_o`070?ooo`04003ol03oool0oooo003ol0l0oooo0`3o0=T<0?ooo`03000_o`3o
ool0oooo00P0oooo00H0]P3o0?ooo`3oool0oooo003ol03oool305L0o`@0oooo00<0E`3o0?ooo`3o
ool00`3oool0103o02H0oooo0?ooo`3o02H30?ooo`04000_o`3o02H0oooo0?ooo`8002oo0P3oool2
0?l09P<0oooo00<000000?l0f@3oool00P3oool00`3o0=T0oooo0?ooo`050?ooo`<00000203oool2
0?l09P030?ooo`3o02H0oooo00<0oooo0P3o07H40?ooo`@0R`3o1P3oool208/0ob`0oooo00<00000
0?ooo`3oool05`3oool001@0oooo00<000000?ooo`3oool09@3oool20?l0fA@0oooo1@2f0?l50?oo
o`@0]P3o103oool00`3o0=T0oooo0?ooo`0=0?ooo`<0nP3o0P3oool20?X0o`<0oooo00<000000?oo
o`3oool02`3oool00`250?l0oooo0?ooo`0=0?ooo`03001Vo`3oool0oooo00`0oooo00<00<go0?oo
o`3oool01P3oool308/0o`<002oo203oool3003ol0h0oooo00D0o`3I0?ooo`3o0=T0oooo0?l0f@0:
0?ooo`03000_o`3oool0oooo00`0oooo00<00?o`0?ooo`3oool0201G0?l30?ooo`80o`0V0P3oool0
103o02H0oooo0?ooo`3oool3000_o`030?l09P00;ol0o`0V00<0o`0V1@3oool00`000000o`3I0?oo
o`020?l0f@D0oooo0`0000000`3oool0o`2]0?l0[@0:0?ooo`<0o`0V0`3o07H00`3o02H0oooo0?oo
o`020?ooo`80R`3o00<0oooo08/0o`2;0?l00`3oool308/0obh0oooo00<000000?ooo`3oool05`3o
ool001@0oooo00<000000?ooo`3oool09`3oool20?l0fAL0oooo1`2f0?l20?ooo`80]P3o0`3oool0
0`3o0=T0oooo0?ooo`020?ooo`@0o`3I1`3oool30?X0o`80oooo00<0nP3o0?ooo`3oool00P3oool0
0`000000oooo0?ooo`0:0?ooo`030?l0[@250?l0Q@3o00h0oooo00<006Ko0?ooo`3oool02`3oool0
0`00cOl0oooo0?ooo`060?ooo`03000_o`2;0?l002oo00<002oo1@3oool6003ol0d0oooo0P3o0=T0
103oool0o`3I0?ooo`3o0=T90?ooo`03000_o`3oool0oooo00`0oooo00<00?o`0?ooo`3oool02`3o
ool00`3o02H002oo0?ooo`020?ooo`050?l09P3oool0oooo0?ooo`00;ol0103o02H:0?ooo`030000
003o0=T0oooo00<0oooo0`0000020?ooo`80o`2]3@3oool20?l0MP040?ooo`3o02H0o`0V0?l09P@0
oooo00<0R`3o0?ooo`2;0?l00P3oool308/0oc80oooo00<000000?ooo`3oool05P3oool001@0oooo
00<000000?ooo`3oool0:@3oool20?l0fAX0oooo1`2f0?l30?ooo`80o`3I00<0oooo0?l0f@3oool0
0`3o0=T60?ooo`80nP3o0P3oool20?X0o`030?ooo`3j0?l0oooo00<0oooo00<000000?ooo`3oool0
1`3oool30?l0[@80oooo00<0Q@3o0?ooo`3oool0103oool00`0:0?l0oooo0?ooo`050?ooo`03001V
o`3oool0oooo00/0oooo00@00<go0?ooo`3oool00<go403oool01000oo00oooo003ol000oo0=0?oo
o`030?l0f@3oool0oooo0080o`3I0P3oool00`3o0=T0oooo0?ooo`020?ooo`05000_o`3oool0oooo
0?ooo`00;ol03P3oool00`00oo00oooo0?ooo`050?ooo`030?X0o`3oool0oooo0080oooo0P00;ol2
0?l09P030?ooo`3o02H0oooo00@0o`0V0`3oool00`3o02H0oooo0?ooo`080?ooo`030000003oool0
oooo00<000000`3oool20?l0[@030?ooo`3o07H0o`1f00@0o`1f1P3oool20?l0MPT0oooo1`2;0?ld
0?ooo`030000003oool0oooo01H0oooo000D0?ooo`030000003oool0oooo02/0oooo0P3o0=TH0?oo
o`030;H0o`3oool0oooo0080oooo0`2f0?l40?ooo`80o`3I00D0oooo0?l0f@3o0=T0oooo0?l0f@05
0?ooo`D0nP3o00<0oooo0?X0o`3j0?l01@3oool00`000000o`2]0?l0[@040?ooo`80o`2]0P3oool2
0?l0[@80oooo0P250?l30?ooo`0400X0o`3oool02P3o00X0o`H0oooo0P00I_l<0?ooo`D00<go3`3o
ool3003ol0`0oooo2P3o0=T30?ooo`8002oo00<0oooo000_o`3oool03@3oool00`00oo00oooo0?oo
o`050?ooo`040?X0o`3oool0oooo0?ooo`8002oo00@0oooo000_o`3o02H002oo303o02H50?ooo`<0
o`2]00@0oooo00000000000000000`3oool30?l0[@<0oooo00@0o`1f0?ooo`3oool0oooo0P3o07H3
0?ooo`<0o`1f2`3oool408/0o`80oooo00<0R`3o0?ooo`3oool00`3oool20029obd0oooo00<00000
0?ooo`3oool05P3oool001@0oooo00<000000?ooo`3oool0;@3oool20?l0fAD0oooo0P2f0?l00`3o
ool0]P3o0;H0o`020;H0o`H0oooo1@3o0=T00`3oool0o`3I0?ooo`030?ooo`X0nP3o1@3oool00`00
0000oooo0?l0[@030?l0[@@0oooo0P3o0:d40?ooo`0408D0o`3oool0oooo00X0o`80oooo0`0:0?l6
0?ooo`03001Vo`3oool0oooo00T0oooo0P00cOl0103oool00<go0?ooo`00cOl@0?ooo`03003ol03o
ool0oooo00/0oooo00D0o`3I0?ooo`3oool0oooo0?l0f@020?ooo`040?l0f@3oool0oooo0?ooo`80
02oo00<0oooo000_o`00;ol03@3oool00`00oo00nP3o0?ooo`040?ooo`80nP3o103oool2000_o`06
0?ooo`00;ol0oooo0?l09P00;ol0o`0V203oool00`3o02H0oooo0?ooo`040?ooo`060?l0[@000000
00000?l0[@000000o`2]0P3oool20?l0[@D0oooo0P3o07H20?ooo`040?l0MP3oool0o`1f0?ooo`80
o`1f3@3oool408/0o`060?ooo`2;0?l0oooo0?ooo`2;0?l0oooo0`00ROl_0?ooo`030000003oool0
oooo01H0oooo000D0?ooo`030000003oool0oooo02l0oooo00<0o`3I0?ooo`3oool04P3oool50;H0
o`P0oooo00D0o`3I0?ooo`3oool0o`3I0?ooo`020?l0fA@0oooo00<000000?ooo`3oool01@3o0:d4
00X0o`@0oooo00<0Q@3o00X0o`3oool00P3oool01@0:0?l0oooo0?ooo`0:0?l0Q@3o00D0oooo00<0
06Ko0?ooo`3oool0203oool00`00cOl0oooo003=o`03003=oal0oooo00@0o`3I0?ooo`3o0=T0oooo
0P3o0=T40?ooo`<002oo0P3oool00`00;ol00?o`0?ooo`090?ooo`@0nP3o0`3oool00`3j0?l0oooo
0?ooo`040?ooo`09000_o`3oool002oo0?ooo`00;ol0oooo0?l09P3oool0o`0V00D0oooo0P3o02H5
0?ooo`80000000D0o`2]0?ooo`3oool0o`2]000000030?l0[@L0oooo103o07H0103oool0o`1f0?l0
MP3o07HB0?ooo`@0R`3o0`00ROlb0?ooo`030000003oool0oooo01H0oooo000C0?ooo`030000003o
ool0oooo0340oooo0P3o0=TC0?ooo`80]P3o2@3oool0203o0=T0oooo0?ooo`3o0=T0oooo0?l0f@3o
ool0o`3I5@3oool010000000oooo0?ooo`3o0:d30?ooo`@0o`2]200:0?l01P3oool0Q@3o00X0o`0:
0?l0oooo08D0o`H0oooo0P00I_l70?ooo`<00<go00<0oooo003=o`00cOl08@3oool30?l0f@D0oooo
00<002oo0?ooo`00;ol00`00;ol00`3oool00?o`0?ooo`060?ooo`05003ol03oool0nP3o003ol03j
0?l00P3oool00`3j0?l0oooo0?X0o`080?ooo`<002oo0P3oool00`00;ol0o`0V0?l09P040?ooo`03
0?l09P3oool0oooo0080oooo0`000000103oool0o`2]0?l0[@3oool20?l0[@030000003o0:d0oooo
00P0oooo1@3o07H20?ooo`040?l0MP3oool0oooo0?ooo`80E`3o3P3oool30029ocD0oooo00<00000
0?ooo`3oool05P3oool001<0oooo00<000000?ooo`3oool0<`3oool20?l0fA`0oooo2@3o0=T?0?oo
o`8002oo103oool00`000000oooo0?l0[@030?ooo`030?l0[@3oool0oooo0080o`2]0`3oool0100:
0?l0oooo0?ooo`3oool400X0o`030?ooo`250?l0oooo00L0oooo00<006Ko0?ooo`3oool00P00I_l4
0?ooo`@00<go203oool00`3o04d0oooo0?ooo`0G0?ooo`030?l0f@3oool0oooo00@0oooo1000;ol0
0`3oool002oo003ol0070?ooo`06003ol03j0?l0nP3o003ol03oool0nP3o0P3oool20?X0o`T0oooo
1P00;ol20?l09P<0oooo00<0o`0V0?ooo`0000000`0000040?ooo`@0o`2]00<0oooo0000003o0:d0
203oool40?l0MP@0oooo00@0o`1f0?ooo`1G0?l0E`3o1P3oool20029o`H0oooo0P00ROl`0?ooo`80
o`0V1P3oool00`000000oooo0?ooo`0F0?ooo`004`3oool00`000000oooo0?ooo`0e0?ooo`80o`3I
7P3oool50?l0fA40oooo0`00;ol20?ooo`050000003oool0o`2]0?ooo`3o0:d00P3oool20?l0[@@0
oooo100:0?l01P3oool0Q@3o00X0o`250?l0oooo08D0o`T0oooo1000I_l>0?ooo`@0o`1=503oool0
0`00oa<0oooo0?ooo`090?ooo`@002oo00<0oooo003ol03oool01P3oool01@3j0?l00?o`003ol000
oo00nP3o0080oooo00<0nP3o0?ooo`3j0?l02@3oool4000_o`<0oooo103o02H2000000P0oooo0P3o
0:d30?ooo`030000003j0?l0oooo00L0oooo103o07H30?ooo`<0E`3o1`3oool30029o`<0oooo0`00
ROl_0?ooo`<0o`0V203oool00`000000oooo0?ooo`0F0?ooo`004`3oool00`000000oooo0?ooo`06
0?ooo`<0iP3o;P3oool20?l0f@H0oooo0P3o0=T]0?ooo`8002oo00@0oooo0000003o0:d0oooo0`3o
0:d70?ooo`802P3o00@0oooo08D0o`3oool02P3o10250?l80?ooo`D006Ko303oool00`3o04d0oooo
0?ooo`020?l0CA@0oooo00<00?lC0?ooo`3oool02`3oool2000_o`03003ol03oool0oooo00H0oooo
00L00?o`0?X0o`00oo00oooo0?X0o`3oool0nP3o00<0oooo00<0nP3o0?ooo`3oool03@3oool00`00
0000o`0V0000000<0?ooo`80o`2]0P3j0?l00`000000o`2]0?ooo`090?ooo`80o`1f0`1G0?l20?l0
MPL0oooo0P00ROl00`3oool008Wo0029o`020029oc00oooo0P3o02H<0?ooo`030000003oool0oooo
01D0oooo000C0?ooo`030000003oool0oooo00T0oooo1@3V0?lF0?ooo`030>H0o`3oool0oooo0180
oooo00<0o`3I0?ooo`3oool00`3oool30?l0fAd0oooo0P1G0?l?0?ooo`<002oo0P3o0:d;0?ooo`<0
2P3o0P3oool308D0o`P0oooo1@00I_l:0?ooo`80o`1=103oool20?l0C@@0oooo00<0E`3o0?ooo`3o
ool00P3oool00`1G0?l0oooo0?ooo`070?ooo`03003o4`3oool0oooo00L0oooo00<0o`1=0?ooo`3o
ool00`3oool00`00oo00oooo0?ooo`060?ooo`03003ol03j0?l0nP3o00<0nP3o0P3oool40?X0o`H0
oooo00<0iP3o0?ooo`3oool00P3oool3000000030?ooo`3V0?l0oooo00`0oooo0P3j0?l0103oool0
o`2]0000003o0:d:0?ooo`80E`3o303oool50029obl0oooo0`3o02H>0?ooo`030000003oool0oooo
01D0oooo000C0?ooo`030000003oool0oooo00h0oooo1@3V0?lA0?ooo`80iP3o503oool20?l0f@80
oooo103o0=TO0?ooo`80E`3o403oool3000_o`P0oooo00H002oo0?ooo`3oool0Q@3o00X0o`3oool4
08D0o`L0oooo0`00I_l20?ooo`8006Ko203oool40?l0C@<0oooo00<0o`1=0?ooo`3o04d0103oool0
0`1G0?l0oooo05L0o`0305L0o`P0oooo00<00?lC0?ooo`3oool01@3oool40?l0C@<0oooo00<00?o`
0?ooo`3oool01`3oool2003ol0H0nP3o0P3oool00`3j0?l0oooo0?ooo`050?ooo`<0iP3o0P000002
0?ooo`80iP3o2`3oool30?X0o`@0oooo00@0000005L0o`1G0?l0E`3o1@3oool305L0o`d0oooo1`00
ROlN0?ooo`<0o`0V2P3oool30?l09Q40oooo00<000000?ooo`3oool05@3oool00180oooo00<00000
0?ooo`3oool0503oool50>H0o`/0oooo103V0?lE0?ooo`<0o`3I0P3oool20?l0fA<0oooo00<0]P3o
0?ooo`3oool02P3oool00`2;0?l0E`3o0?ooo`0>0?ooo`030000003oool002oo008002oo1@3oool2
000_o`030?ooo`250?l0Q@3o0080Q@3o2`3oool6001Vo`P0oooo2P3o04d40?ooo`80E`3o0P3oool2
05L0o`P0oooo00<00?lC0?ooo`3oool0103oool00`3o04d0oooo0?l0C@020?ooo`040?l0C@3oool0
oooo003ol0`0oooo00<0nP3o0?ooo`3oool00`3oool00`3j0?l0oooo0?ooo`050?ooo`80iP3o00<0
00000?ooo`3V0?l00`3V0?l20?ooo`<0nP3o1P3oool20?X0o`H0oooo00<0E`3o0000003oool00P1G
0?l30?ooo`80E`3o4`3oool30029oah0oooo0P3o02H20?ooo`<0o`0V103oool30?l09Q@0oooo00<0
00000?ooo`3oool05@3oool00180oooo00<000000?ooo`3oool06@3oool60>H0o`D0oooo00<0iP3o
0?ooo`3oool00P3V0?lE0?ooo`<0o`3I0P3oool00`3o0=T0oooo0?ooo`0B0?ooo`80]P3o2P3oool3
08/0o`0305L0o`3oool0oooo00`0oooo00@000000?ooo`3oool0oooo0`00;ol00`3oool002oo0?oo
o`02000_oah0oooo00<0o`1=0?ooo`3oool00P3oool00`3o04d0oooo0?ooo`020?l0C@80oooo0P1G
0?l01P3oool0E`3o0?ooo`1G0?l0oooo05L0o`L0oooo00<00?lC0?ooo`3oool00`3oool0103o04d0
oooo0?ooo`3o04d30?ooo`030?l0C@00oo00oooo00d0oooo00<0nP3o0?ooo`3oool00P3j0?l50?oo
o`<000000P3V0?l20?ooo`@0iP3o0P3oool00`3j0?l0oooo0?ooo`030?X0o`030?ooo`3j0?l0nP3o
00P0oooo00<0E`3o0000001G0?l00P3oool305L0o``0oooo00<0R`3o0?ooo`3oool09`3oool20?l0
9P80oooo0`3o02H0103oool0o`0V0?l09P3o02HG0?ooo`030000003oool0oooo01D0oooo000B0?oo
o`030000003oool0oooo01l0oooo1P3V0?l30?ooo`80iP3o503oool00`3o0=T0oooo0?ooo`020?l0
f@030?ooo`3o0=T0oooo01@0oooo0P2f0?l80?ooo`0308/0o`3oool0oooo0080R`3o00<0E`3o0?oo
o`3oool02`3oool00`000000oooo0?ooo`030?ooo`<002oo00<0oooo000_o`3oool07P3oool01P3o
04d0oooo0?ooo`3oool0o`1=0?ooo`80o`1=103oool505L0o`030?ooo`1G0?l0oooo00H0oooo00@0
0?lC0?ooo`3oool0oooo0P3o04d20?ooo`030?l0C@3oool0oooo00800?o`00@0o`1=003ol03oool0
oooo0P3o04d:0?ooo`030?X0o`3oool0nP3o00@0oooo0`0000030?ooo`L0iP3o0P3oool20?X0o`80
oooo103j0?l90?ooo`80E`3o00<0000005L0o`1G0?l00P1G0?l<0?ooo`<0R`3o303oool308/0oaT0
oooo00D0o`0V0?ooo`3o02H0oooo0?l09P020?ooo`80o`0V6P3oool00`000000oooo0?ooo`0E0?oo
o`004P3oool00`000000oooo0?ooo`0T0?ooo`D0iP3o00<0oooo0>H0o`3oool04@3oool50?l0f@03
0?ooo`3o0=T0o`3I01L0oooo0P2f0?l60?ooo`0408/0o`3oool0oooo0?ooo`<0R`3o00<0E`3o0?oo
o`3oool02P3oool00`000000oooo0?ooo`020?ooo`03000_o`3oool002oo00<002oo7`3oool01@3o
04d0oooo0?l0C@3oool0o`1=00H0oooo00<0E`3o0?ooo`3oool01@1G0?l60?ooo`04003o4`3oool0
oooo0?l0C@@0oooo00<0o`1=0?ooo`00oo000P3oool40?l0C@d0oooo00<0nP3o0?ooo`3oool00`00
00050?ooo`040>H0o`3oool0iP3o0>H0o`<0oooo00<0iP3o0?ooo`3oool01@3j0?l00`3oool0nP3o
0?ooo`090?ooo`80E`3o00D0000005L0o`3oool0oooo05L0o`0:0?ooo`<0R`3o0P3oool00`2;0?l0
oooo0?ooo`040?ooo`D0R`3o703oool00`3o02H0oooo0?l09P050?l09Q/0oooo00<000000?ooo`3o
ool05@3oool00180oooo00<000000?ooo`3oool08`3oool20>H0o`<0oooo103V0?lA0?ooo`T0o`3I
603oool20;H0o`<0oooo00@0R`3o0?ooo`2f0?l0]P3o1@2;0?l205L0o`/0oooo00@000000?ooo`3o
ool0oooo1`00;olN0?ooo`040?l0C@3oool0o`1=0?l0C@P0oooo00@0E`3o0?ooo`1G0?l0oooo0P1G
0?l20?ooo`0405L0o`3oool0oooo0?ooo`@00?lC00H0oooo0?l0C@3o04d0oooo0?l0C@3oool40?l0
C@04003ol03oool0o`1=003ol0d0oooo0`0000080?ooo`80iP3o00D0oooo0>H0o`3oool0oooo0>H0
o`020?ooo`@0nP3o0`3oool00`3j0?l0oooo0?ooo`070?ooo`<0E`3o00<000000?ooo`1G0?l00P3o
ool0101G0?l0oooo003=o`00cOl50?ooo`0308/0o`3oool0R`3o00<0oooo00<0R`3o0?ooo`2;0?l0
102;0?lP0?ooo`D0o`0V103oool00`3o02H0oooo0?ooo`030?ooo`<0o`3I4`3oool00`000000oooo
0?ooo`0D0?ooo`004P3oool00`000000oooo0?ooo`0S0?ooo`L0iP3o<`3oool:08/0o`040;H0o`2;
0?l0R`3o08/0o`<0oooo0P1G0?l40?ooo`<0E`3o0`3oool010000000oooo0?ooo`3oool3000_o`H0
oooo00<0o`0V0?ooo`3oool06@3oool00`3o04d0oooo0?ooo`080?ooo`0405L0o`3oool0E`3o05L0
o`<0oooo101G0?l0103oool00?lC003o4`00oa<20?ooo`030?l0C@3oool0o`1=00X0o`1=103oool0
0`3o0:d0oooo0?ooo`030?ooo`<000003@3oool30>H0o`040?ooo`3V0?l0oooo0?ooo`<0nP3o103o
ool00`3j0?l0oooo0?ooo`0:0?ooo`040000001G0?l0E`3o05L0o`<00<go1`3oool208/0o`030?oo
o`2;0?l0R`3o00<0R`3o7@3oool20?l0f@H0oooo0`3o02H00`3oool0o`0V0?ooo`030?ooo`030?l0
9P3oool0o`3I00<0o`3I5P3oool00`000000oooo0?ooo`0D0?ooo`004@3oool00`000000oooo0?oo
o`0T0?ooo`030>H0o`3oool0iP3o0080iP3o:`3oool:08/0o`D0oooo00<0]P3o08/0o`2f0?l00`2;
0?l00`3oool0R`3o0?ooo`050?ooo`80E`3o0P3oool405L0o`80oooo00<000000?ooo`3oool0203o
ool40?l09Qh0oooo00<00?lC0?ooo`3oool01@3oool00`1G0?l0oooo0?ooo`020?ooo`0605L0o`3o
ool0E`3o0?ooo`1G0?l0oooo0`00oa<30?ooo`030?l0C@3oool0o`1=00@0oooo0P00oo000`3oool0
o`1=0?ooo`030?ooo`<0o`2]00@0oooo00000000000000004P3oool20>H0o`@0oooo0`3j0?l2001V
o`030?ooo`3j0?l0oooo00`0oooo00<00000003=o`00cOl02P3oool408/0o`<0oooo00<0R`3o0?oo
o`3oool06P3oool20?l0f@040?ooo`3o0=T0o`3I0?l0f@D0oooo1@3o02H40?l0fAX0oooo00<00000
0?ooo`3oool0503oool00140oooo00<000000?ooo`3oool0903oool20>H0obT0oooo1@2;0?l?0?oo
o`080;H0o`2;0?l0R`3o0;H0o`3oool0R`3o0;H0o`2;0?l80?ooo`80E`3o00@0oooo05L0o`1G0?l0
E`3o0`3oool00`000000oooo0?ooo`060?ooo`030?l09P3oool0oooo0080o`0V303oool00`3j0?l0
oooo0?ooo`0@0?ooo`03003o4`3oool0oooo00P0oooo00<0E`3o0?ooo`3oool00P1G0?l0103oool0
E`3o0?ooo`00oa<40?ooo`030?l0C@3oool0o`1=00D0oooo0P3o04d40?ooo`050?l0[@3oool0o`2]
0000003o0:d0303oool00`250?l0oooo0?ooo`0=0?ooo`8006Ko00@0oooo0?X0o`3j0?l0nP3o0`3o
ool00`00cOl0oooo0?ooo`040?ooo`<00<go00<000000?ooo`3oool02`3oool00`2;0?l0oooo0?oo
o`0508/0oaT0oooo0P3o04d20?l0f@040?ooo`3o0=T0o`3I0?l0f@H0oooo103o0=T30?l09Q/0oooo
00<000000?ooo`3oool0503oool00140oooo00<000000?ooo`3oool0AP3oool308D0oaX0oooo00D0
]P3o0?ooo`2;0?l0R`3o0;H0o`0208/0o`X0oooo0`1G0?l00`3oool0E`3o05L0o`030?ooo`030000
003oool0oooo00<0oooo0P3o02H30?ooo`030?l09P3oool0o`0V00T0oooo0`3j0?l20?ooo`03003o
l03oool0oooo00h0oooo00<00?lC0?ooo`3oool01P3oool0101G0?l0oooo0?ooo`3oool205L0o`80
oooo00<0E`3o0?ooo`3oool0103oool20?l0C@@0oooo00<0o`1=0?ooo`3oool00P3oool200000006
0?l0[@000000oooo0?l0[@3oool0o`2]0`3oool208D0o`D0oooo00<0Q@3o0?ooo`3oool0303oool2
001Vo`L0oooo0`00cOl20?ooo`@00<go0`3oool00`000000oooo0?ooo`0;0?ooo`80R`3o0`3oool2
08/0oaL0oooo0`3o04d00`3oool0o`3I0?ooo`020?l0f@80oooo00<0o`3I0?ooo`3oool0103o0=TR
0?ooo`030000003oool0oooo01@0oooo000A0?ooo`030000003oool0oooo04T0oooo1@250?lB0?oo
o`0408D0o`3oool0oooo0;H0o`<0oooo0P2;0?l00`2f0?l0oooo0?ooo`080?ooo`80E`3o00@0oooo
05L0o`1G0?l0E`3o103oool010000000oooo0?ooo`3oool30?l09P<0oooo00@0o`0V0?ooo`3oool0
o`0V0P3j0?l40?ooo`80nP3o0P3oool20?X0o`80oooo0P00oo0?0?ooo`03003o4`3oool0oooo00@0
oooo0`1G0?l20?ooo`0305L0o`3oool0oooo00<0E`3o1P3oool20?l0C@80oooo00<0o`1=0?ooo`3o
ool00`0000001P3oool0o`2]0?ooo`3o0:d0oooo0?l0[@80oooo00D0o`2]0?ooo`3oool0Q@3o0?oo
o`0208D0o`030?ooo`250?l0Q@3o00d0oooo0P00I_l80?ooo`800<go00@0oooo003=o`00cOl00<go
1`3oool00`000000oooo0?ooo`0<0?ooo`0408/0o`3oool0R`3o08/0oaH0oooo0`3o04d30?ooo`04
0?l0f@3oool0o`3I0?l0f@80oooo103o0=TV0?ooo`030000003oool0oooo01@0oooo000A0?ooo`03
0000003oool0oooo03l0oooo0P2;0?l=0?ooo`H0Q@3o303oool208D0o`030?ooo`2f0?l0oooo00@0
]P3o2P3oool00`1G0?l0oooo05L0o`0505L0o`@0oooo00<000000?ooo`3o02H0203o02H0103oool0
o`0V0?ooo`3oool40?X0o`@0oooo0P3j0?l40?ooo`800?o`3@3oool00`00oa<0oooo0?ooo`050?oo
o`0305L0o`3oool0E`3o00@0E`3o00<0oooo05L0o`3oool01P3oool40?l0C@<000000`3oool:0?l0
[@80Q@3o0`3oool208D0o`D0oooo1000I_l20?ooo`<006Ko2@3oool4003=o`030?ooo`00cOl0oooo
00L0oooo00D000000?ooo`3oool0oooo0?l0C@0;0?ooo`0308/0o`3oool0oooo00L0oooo0`3o04d:
0?ooo`80o`1=1P3oool60?l0f@80oooo00<0o`3I0?ooo`3oool09@3oool00`000000oooo0?ooo`0D
0?ooo`004@3oool00`000000oooo0?ooo`110?ooo`80R`3o00<0oooo0?l0f@3o0=T03P3oool508D0
o`L0oooo0`250?l30;H0o`d0oooo101G0?l90?ooo`040000003oool0oooo0?l09P@0oooo00<0o`0V
0?ooo`3o02H00P3o02H30?ooo`D0nP3o00<0oooo0?X0o`3j0?l01P3oool00`00oo00oooo0?l0f@02
0?ooo`800?o`1`3oool00`00oa<0oooo003o4`050?ooo`0405L0o`3oool0oooo05L0o`80oooo00<0
E`3o0?ooo`3oool01`3oool00`3o04d00000000000070?ooo`050?l0[@3oool0oooo0?ooo`3o0:d0
0P3oool0103o0:d0oooo08D0o`250?l20?ooo`<0Q@3o103oool2001Vo`030?ooo`00I_l006Ko0080
06Ko2`3oool3003=o`040?ooo`00cOl0oooo003=o`P0oooo00H000000?ooo`3o04d0o`1=0?ooo`3o
04dD0?ooo`030?l0C@3oool0oooo00<0o`1=103oool30?l0C@030?ooo`0:0?l0oooo00@0oooo0`3o
0=T00`3oool0o`3I0?ooo`030?ooo`030?l0f@3oool0oooo02D0oooo00<000000?ooo`3oool0503o
ool00140oooo00<000000?ooo`3oool0@`3oool00`2;0?l0o`3I0?ooo`020?l0fA40oooo1@250?l2
0?ooo`80Q@3o00<0oooo08D0o`250?l0703oool010000000oooo0?ooo`3o02H20?ooo`030?l09P3o
ool0oooo0080o`0V1@3oool0103j0?l0oooo0?ooo`3oool20?X0o`030?ooo`3j0?l0oooo00D0oooo
0`3o0=T00`00oo00oooo003ol0080?ooo`<00?lC1@3oool01@1G0?l0oooo05L0o`3oool0E`3o00L0
oooo0`00000;0?ooo`090?l0[@3oool0oooo0?l0[@3oool0o`2]0?ooo`250?l0oooo00<0Q@3o00<0
oooo08D0o`3oool0103oool5001Voa00oooo1000cOl80?ooo`030000003o04d0o`1=0080oooo00<0
o`1=0?ooo`3oool04@3oool20?l0C@80oooo0`3o04d20?ooo`80o`1=0P3oool400X0o`H0oooo1@3o
0=T20?ooo`030?l0f@3oool0oooo02H0oooo00<000000?ooo`3oool04`3oool00100oooo00<00000
0?ooo`3oool0A@3oool00`3o0=T0R`3o08/0o`030?l0fA@0oooo1P250?l00`3oool0Q@3o0?ooo`0K
0?ooo`080000003oool0oooo0?l09P3oool0o`0V0?ooo`3o02H70?ooo`060?X0o`3oool0oooo0?oo
o`3j0?l0oooo0P3j0?l50?ooo`070?l0f@3oool0o`3I003ol03o0=T0oooo003ol0070?ooo`@00?lC
1P3oool305L0o`D0oooo0`00000>0?ooo`050?l0[@3oool0o`2]0?ooo`3o0:d00P3oool308D0o`<0
oooo00<0Q@3o0?ooo`3oool00P3oool4001Vo`80oooo00<006Ko0?ooo`3oool0603oool00`3o04d0
00000?l0C@040?ooo`030?l0C@3oool0oooo0100oooo0P3o04d0103oool0o`1=0?ooo`3oool30?l0
C@80oooo1P0:0?l;0?ooo`<0o`3I:03oool00`000000oooo0?ooo`0C0?ooo`00403oool00`000000
oooo0?ooo`150?ooo`060?l0f@3oool0oooo0?l0f@2;0?l0oooo0P3o0=TC0?ooo`80Q@3o0`3oool3
08D0oa`0oooo00<000000?ooo`3o02H00`3o02H90?ooo`040?X0o`3oool0nP3o0?ooo`80nP3o00@0
oooo000_o`3oool0oooo0P3o0=T20?ooo`040?l0f@00oo00oooo0?l0f@800?o`1`3oool3003o4`L0
oooo00@0E`3o0?ooo`3oool0oooo0`00000B0?ooo`<0o`2]103oool308D0o`80oooo00<0Q@3o0?oo
o`3oool00P3oool4001Vo`80oooo00<006Ko0?ooo`3oool00`3oool00`1G0?l0oooo0?ooo`0@0?oo
o`80o`1=00<0oooo0000003o04d01@3oool00`3o04d0oooo0?ooo`0?0?ooo`030?l0C@3oool0o`1=
00@0o`1=0`3oool?00X0obh0oooo00<000000?ooo`3oool04`3oool00100oooo00<000000?ooo`3o
ool0A@3oool01P3o0=T0oooo0?ooo`3o0=T0oooo08/0o`@0o`3I4@3oool708D0oah0oooo00<00000
0?ooo`3o02H02`3oool0103j0?l0oooo0?X0o`3j0?l30?ooo`8002oo00<0o`3I0?ooo`3oool00P3o
ool01P3o0=T00?o`0?ooo`00oo00o`3I003ol0l0oooo103o02H2000000H0oooo00<0nP3o0?ooo`3o
ool03@3oool00`3o0:d0oooo0?ooo`050?ooo`<0Q@3o203oool4001Vo`<0oooo0`1G0?lA0?ooo`80
o`1=0P3oool00`000000oooo0?ooo`050?ooo`T0o`1=1`3oool40?l0C@@0oooo00@0o`1=0?ooo`3o
ool0oooo0P0:0?l20?ooo`802P3o203oool?00X0oal0oooo00<000000?ooo`3oool04`3oool00100
oooo00<000000?ooo`3oool0@`3oool;0?l0f@0308/0o`3oool0oooo00@0oooo0`2;0?l80?ooo`80
Q@3o00<0oooo08D0o`250?l08@3oool00`000000oooo0?ooo`0;0?ooo`030?X0o`3oool0oooo0080
oooo00<002oo0?ooo`3o0=T0203o0=T00`00oo00oooo0?l0f@0>0?ooo`030?l09P00000000000080
o`0V1`3oool30?X0oaP0oooo00<0Q@3o0?ooo`3oool02`3oool305L0o`80oooo00<0E`3o0?ooo`3o
ool01@3oool305L0o`L0oooo0`3o04d00`000000o`1=0?l0C@060?l0C@l0oooo0P3o04d00`3oool0
o`1=0?ooo`030?ooo`040?l0C@3oool0oooo0?ooo`80nP3o100:0?lf0?ooo`030000003oool0oooo
01<0oooo000@0?ooo`030000003oool0oooo03`0oooo1`3o0=T20?ooo`040?l0f@3oool0oooo0?oo
o`80o`3I00@0oooo0?l0f@3oool0oooo0P2;0?l40?ooo`<0R`3o2@3oool208D0ob@0oooo00<00000
0?ooo`3oool03`3oool02@00;ol0oooo0?ooo`3o0=T002oo0?ooo`00;ol0oooo0?l0f@020?ooo`@0
o`3I2`3oool20?l09P040000003oool0oooo0?ooo`80o`0V103oool20?X0o`040?ooo`3j0?l0oooo
0?X0oad0oooo0P00oa<50?ooo`0405L0o`3oool0oooo05L0o`80oooo00<0E`3o0?ooo`3oool01@1G
0?l:0?ooo`040?l0C@3oool0o`1=000000<0oooo1P3o04d40?ooo`80nP3o2P3oool40?l0C@80oooo
103j0?l30?ooo`<02P3o=P3oool00`000000oooo0?ooo`0C0?ooo`00403oool00`000000oooo0?oo
o`0e0?ooo`L0o`3I2@3oool00`3o0=T0oooo0?l0f@020?l0f@030?ooo`3o0=T0oooo00@0oooo0P2;
0?l00`3oool0R`3o0?ooo`0308/0oah0oooo00<0o`3I0?ooo`3oool03P3oool00`000000oooo0?oo
o`060?ooo``002oo00D0o`3I000_o`3oool0oooo0?l0f@040?ooo`030?l0f@3oool0oooo00L0oooo
0P0000040?l09P<0oooo00<0o`0V0?ooo`3o02H00P3oool01`3j0?l0oooo0?X0o`3oool0nP3o0?oo
o`3j0?l01@3oool00`00oo00oooo0?ooo`030?ooo`03003ol03oool0oooo00`0oooo0`00oa<70?oo
o`0405L0o`3oool0E`3o0?ooo`D0E`3o403oool00`3o04d0oooo000000070?ooo`050?l0C@3oool0
oooo0?ooo`3o0=T00P3j0?l0103oool0nP3o0?X0o`3j0?l80?ooo`D0nP3o00<0o`1=0?ooo`3oool0
1P3oool00`0:0?l0oooo0?ooo`0d0?ooo`030000003oool0oooo01<0oooo000?0?ooo`030000003o
ool0oooo02h0oooo203o0=T@0?ooo`80o`3I0P3oool20?l0f@P0oooo0P2;0?l0103oool0R`3o08/0
o`2;0?lL0?ooo`80o`3I0P00;ol:0?ooo`@00?o`0P3oool00`000000oooo0?ooo`080?ooo`06003o
l03oool0oooo0?ooo`00;ol0oooo1000;ol0103o0=T0oooo0?ooo`3o0=T30?ooo`030?l0f@3oool0
oooo00D0oooo0`0000020?ooo`X0o`0V00D0oooo0?X0o`3j0?l0nP3o0?ooo`020?X0o`80oooo00<0
nP3o0?ooo`3oool00P3oool3003ol0030?ooo`00oo000?o`00P0oooo0P00oa<00`3oool00?lC003o
4`02003o4`/0oooo101G0?l20?ooo`0305L0o`3oool0oooo00h0oooo00@0o`3I0?l0C@3oool00000
1@3oool20?l0C@080?ooo`3o0=T0o`3I0?l0f@3j0?l0oooo0?X0o`3oool30?X0o`<0oooo1@3j0?l4
0?ooo`802P3o@03oool00`000000oooo0?ooo`0B0?ooo`003`3oool00`000000oooo0?ooo`0Z0?oo
o`@0o`3I6P3oool30?l0f@X0oooo0`2;0?l00`3oool0R`3o08/0o`0C0?ooo`80o`3I103oool20?l0
f@80oooo0P3o0=T4000_o`T0oooo00<002oo003ol000oo001@00oo060?ooo`800?o`0P3oool2000_
o`<0oooo00D002oo0?l0f@3oool0oooo0?l0f@020?ooo`030?l0f@3oool0oooo00<0oooo0`000006
0?ooo`030?l09P3oool0oooo0080oooo00<0o`0V0?ooo`3oool00P3o02H00`3oool0nP3o0?ooo`07
0?X0o`80oooo0P00oo00103oool00?o`003ol000oo080?ooo`@00?lC3`3oool0101G0?l0oooo0?oo
o`3oool405L0o`l0oooo00@0o`3I0?ooo`3o04d00000103oool0103o04d0oooo0?l0f@3o0=T30?oo
o`040?X0o`3oool0nP3o0?X0o`80oooo103j0?l70?ooo`@02P3o@03oool00`000000oooo0?ooo`0B
0?ooo`003`3oool00`000000oooo0?ooo`0U0?ooo`@0]P3o5`3oool00`2f0?l0oooo0?ooo`0A0?oo
o`0408/0o`3oool0R`3o0?ooo`<0R`3o5@3oool50?l0f@@0oooo00<0o`3I0?ooo`3oool00P3oool3
000_o`040?ooo`2f0?l0oooo0?ooo`8002oo00<0oooo000_o`3oool00P3oool00`000000oooo0?oo
o`0:003ol0040?ooo`00;ol002oo0?ooo`8002oo00H0oooo0?l0f@3oool0o`3I0?ooo`3o0=T20?oo
o`@000002P3oool01P3o02H0oooo0?ooo`3oool0o`0V0?ooo`80o`0V0`3oool0103j0?l0oooo0?oo
o`3j0?l20?ooo`040?X0o`3oool0oooo0?ooo`D00?o`203oool5003o4a00oooo00@0E`3o0?ooo`3o
ool0oooo0P1G0?l?0?ooo`80o`3I0P3oool01@000000o`3I0?l0f@3oool0o`1=0080o`3I103oool8
0?X0o`P0oooo0`0:0?l20?ooo`0300X0o`3oool0oooo03h0oooo00<000000?ooo`3oool04P3oool0
00l0oooo00<000000?ooo`3oool0:@3oool60;H0oa40oooo0P2f0?lB0?ooo`P0R`3o5`3oool50?l0
f@030?ooo`3o0=T0o`3I00H0oooo00@002oo0;H0o`2f0?l0]P3o1@00;ol30?ooo`030000003oool0
oooo00@0oooo00<00?o`0?ooo`00oo000`00oo020?ooo`8002oo0`3oool30?l0f@<000003`3oool0
1@3o02H0oooo0?l09P3oool0o`0V00H0oooo00D0nP3o0?ooo`3j0?l0oooo0?X0o`050?ooo`800?o`
00<0oooo003ol03oool02@3oool2003o4a40oooo00@0E`3o0?ooo`1G0?l0E`3o1P3oool00`3o0000
oooo0?ooo`080?ooo`80o`3I0P3oool0103o04d000000?l0C@3o04d60?ooo`<0nP3o00<0oooo0?X0
o`3oool00P3oool00`3j0?l0oooo0?ooo`040?ooo`<02P3o00D0oooo00X0o`3oool0oooo00X0o`10
0?ooo`030000003oool0oooo0180oooo000?0?ooo`030000003oool0oooo0280oooo0P3o0:d;0?oo
o`L0]P3o2P3oool30;H0oc40oooo00@0o`3I0?ooo`3oool0oooo0`3o0=T60?ooo`030;H0o`3oool0
oooo0080]P3o1000;ol40?ooo`030000003oool0oooo00<0oooo1000oo090?ooo`030000003o0=T0
00000180oooo00@0o`0V0?ooo`3o02H0o`0V203oool30?X0o`P0oooo00<00?o`0?ooo`3oool03P3o
ool00`3o07H0oooo0?ooo`0<0?ooo`0305L0o`3oool0oooo00D0oooo00<0o`000?ooo`3o00002@3o
ool50?l0f@030000003o0=T002oo00P0oooo103j0?l20?ooo`030?X0o`3oool0oooo00D0oooo1`0:
0?m00?ooo`030000003oool0oooo0180oooo000?0?ooo`030000003oool0oooo0280oooo103o0:d@
0?ooo`L0]P3o0P3oool20;H0o`80oooo0P2f0?l_0?ooo`060?l0f@3oool0oooo0?ooo`3o0=T0oooo
0P3o0=T20?ooo`80E`3o00<0oooo0;H0o`3oool00P3oool00`00;ol0]P3o0;H0o`03000_o`@0oooo
00<000000?ooo`3oool00P3oool2003ol0D0oooo00<0o`000?ooo`3oool00`0000060?ooo`030?l0
MP3oool0oooo00d0oooo00<0o`0V0?ooo`3oool02@3oool00`3j0?l0oooo0?ooo`0F0?ooo`80o`1f
00<0oooo0?l0MP3oool04P3oool30?l000030?ooo`3o0000oooo00L0oooo103o0=T20?ooo`030000
0000;ol002oo00`0oooo0`3j0?l80?ooo`0500X0o`3oool02P3o00X0o`3oool01P0:0?lk0?ooo`03
0000003oool0oooo0180oooo000?0?ooo`030000003oool0oooo0280oooo00<0o`2]0?ooo`3oool0
0`3o0:dE0?ooo`H0]P3o00<0oooo0;H0o`2f0?l0;P3oool01@3o0=T0oooo0?ooo`3o0=T0oooo0080
o`3I0`3oool00`1G0?l0oooo0;H0o`0205L0o`80oooo00D002oo0;H0o`2f0?l0]P3o000_o`060?oo
o`030000003oool0oooo00H0oooo103o00000`000000oooo0?ooo`060?ooo`<0o`1f8`3oool00`00
I_l0oooo0?ooo`0<0?ooo`050?l0MP3oool0o`1f0?ooo`3o07H04P3oool00`3o0000oooo0?l00003
0?ooo`030?l0003oool0oooo00D0oooo0`3o0=T01P3oool002oo000_o`000000o`3I000_oaL0oooo
00@02P3o0?ooo`0:0?l0oooo0P0:0?l50?ooo`H02P3o;03oool30?l0[@H0oooo00<000000?ooo`3o
ool04P3oool000h0oooo00<000000?ooo`3oool08`3oool01@3o0:d0oooo0?ooo`3o0:d0oooo00<0
o`2]5@3oool0102f0?l0oooo0?ooo`3oool40;H0obh0oooo103o0=T50?ooo`0405L0o`3oool0]P3o
0?ooo`80E`3o0P2f0?l00`00;ol0]P3o0;H0o`080?ooo`030000003oool0oooo00@0oooo00H0o`00
000000000000o`000?ooo`3o00060?ooo`80o`1f00<0oooo0?l0MP3o07H02P3oool00`00I_l0oooo
0?ooo`0E0?ooo`03001Vo`3oool006Ko00`0oooo00<0o`1f0?ooo`3o07H00`3oool00`3o07H0oooo
0?ooo`0>0?ooo`030?l0003oool0o`0000D0oooo00<0o`000?ooo`3oool01@3oool00`3o0=T002oo
000_o`02000_o`0300000000;ol002oo00L002oo4@3oool400X0o``0oooo1@0:0?l@0?ooo`80o`2]
403oool50?l0[@T0oooo00<000000?ooo`3oool04P3oool000h0oooo00<000000?ooo`3oool08`3o
ool0103o0:d0oooo0?ooo`3o0:d20?ooo`@0o`2]4`3oool60;H0oc00oooo0P3o0=T70?ooo`0305L0
o`2f0?l0oooo00<0]P3o0P1G0?l00`3oool0]P3o0?ooo`090?ooo`040000003oool0oooo00000080
o`00103oool20?l000D0oooo00<0o`1f0?ooo`3oool00P3oool20?l0MPL0oooo1000I_lE0?ooo`80
06Ko00<0oooo001Vo`3oool02@3oool20?l0MP80oooo00D0o`1f0?ooo`3oool0oooo0?l0MP090?oo
o`030;H0o`3oool0oooo0080oooo0P3o00020?ooo`030?l0001G0?l0E`3o00<0oooo00<0o`000?oo
o`3oool01`3oool3000_o`0300000000;ol002oo00L0oooo3P00;ol40?ooo`0300X0o`3oool0oooo
0140oooo0`0:0?l<0?ooo`80o`2]00@0oooo0?l0[@3o0:d0o`2]203oool50?l0[@l0oooo00<00000
0?ooo`3oool04@3oool000h0oooo00<000000?ooo`3oool08`3oool60?l0[@030?ooo`3o0:d0o`2]
01@0oooo00@0]P3o0?ooo`2f0?l0]P3o>@3oool305L0o`<0]P3o0`1G0?l20?ooo`030;H0o`3oool0
oooo00T0oooo0P0000040?l000<0oooo00<0o`000?ooo`3o00000`3oool30?l0MP<0oooo00<0o`1f
0?ooo`3o07H0103oool3001Vo`80oooo0P00I_l80?ooo`030?l0003oool0oooo00P0oooo0P00I_l3
0?ooo`03001Vo`3oool0oooo00H0oooo0P3o07H20?ooo`030?l0MP3oool0oooo00<0oooo00<0o`1f
0?ooo`3oool01P3oool30;H0o`060?ooo`3o0000oooo0?ooo`2f0?l0o`000P1G0?l01P3oool0E`3o
05L0o`1G0?l0oooo0?l000@0oooo1@1G0?l00`3oool002oo00000002000_oc/0oooo00@0o`2]0?oo
o`3o0:d0oooo0`3o0:d40?ooo`@0o`2]503oool00`000000oooo0?ooo`0A0?ooo`003P3oool00`00
0000oooo0?ooo`0M0?ooo`H0o`2]00D0oooo0?l0[@3oool0o`2]0?ooo`030?l0[AD0oooo0P2f0?ld
0?ooo`L0E`3o00<0oooo0;H0o`2f0?l00`2f0?l0101G0?l0oooo05L0o`3oool20;H0o`/0oooo00@0
00000?ooo`3oool0o`000P3oool70?l000030?ooo`3o07H0o`1f00P0o`1f103oool8001Vo`H0oooo
0`3o00080?ooo`X006Ko1P3oool90?l0MP030?ooo`3o07H0oooo00D0oooo0P2f0?l20?ooo`80o`00
0P2f0?l00`3oool0o`000?ooo`0305L0o`050?ooo`1G0?l0E`3o05L0o`3o00000`1G0?l70?ooo`03
00000000;ol002oo03/0oooo00@0o`2]0?ooo`3o0:d0o`2]0P3oool50?l0[AP0oooo00<000000?oo
o`3oool04@3oool000h0oooo00<000000?ooo`3oool05P3oool70?l0[@L0oooo00H0o`2]0?ooo`3o
0:d0o`2]0?ooo`3o0:e60?ooo`H0E`3o00@0oooo000_o`00;ol002oo0P3oool20;H0o`030?ooo`1G
0?l0E`3o0080oooo0P2f0?l20?ooo`80]P3o2`3oool01@000000oooo0?ooo`3oool0o`0000@0oooo
00<0o`000?ooo`3o0000103oool00`3o07H0oooo0?ooo`020?ooo`040?l0MP3oool0o`1f0?l0MP@0
oooo00H006Ko0?ooo`3oool006Ko0?ooo`00I_l80?ooo`030?l0003oool0oooo00P0oooo0P00I_l2
0?ooo`<006Ko203oool01@3o07H0oooo0?ooo`3o07H0oooo00/0o`1f00<0oooo0;H0o`2f0?l00P3o
ool00`2f0?l0o`000?l0000B0?l000<0oooo0P00000c0?ooo`80]P3o1`3oool80?l0[A`0oooo00<0
00000?ooo`3oool04@3oool000h0oooo00<000000?ooo`3oool0403oool60?l0[@h0oooo0`3o0:d0
0`3oool0o`2]0?ooo`0^0?ooo`<02P3o1P3oool;000_o`@0E`3o1`3oool00`00;ol0oooo000_o`02
0;H0o`@0oooo0P1G0?l00`3oool0E`3o05L0o`030;H0o``0oooo00D000000?ooo`3oool0oooo0?l0
00030?ooo`030?l0003oool0o`0000H0oooo00@0o`1f0?ooo`3oool0o`1f0P3oool00`3o07H0oooo
0?ooo`040?ooo`04001Vo`3oool006Ko001Voa@0oooo0P00I_l30?ooo`03001Vo`3oool0oooo00P0
oooo00<0o`1f0?ooo`3o07H01@3oool30?l0MP@0oooo00<0]P3o0?ooo`2f0?l00`2f0?l0103o0000
]P3o0?ooo`3o000305L0o`80oooo1P3o00050?ooo`<000000P3oool00`000000oooo0?ooo`0]0?oo
o`L0]P3o103oool30?l0[@030?ooo`3o0:d0oooo0080oooo00<0o`2]0?ooo`3oool06P3oool00`00
0000oooo0?ooo`0A0?ooo`003@3oool00`000000oooo0?ooo`0;0?ooo`H0o`2]5@3oool30?l0[C<0
oooo1@0:0?l40?ooo`<0o`3I00<02P3o0?ooo`0:0?l01@3oool9000_o`80]P3o0`00;ol50?ooo`80
E`3o0`3oool00`2f0?l0oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3o
ool00P3o00080?ooo`030?l0MP3oool0o`1f0080o`1f203oool00`00I_l0oooo0?ooo`0E0?ooo`@0
06Ko2`3oool00`3o07H0oooo0?l0MP050?ooo`80o`1f1@3oool40;H0o`<0oooo00@0o`000?ooo`3o
ool0o`000P1G0?l30?ooo`0605L0o`3oool0o`000?l0003oool002oo100000060?ooo`030000003o
ool0oooo00l0oooo00<0o`3I0?ooo`3oool0603oool50;H0o`040?ooo`2f0?l0oooo0;H0o`D0oooo
103o0:d30?ooo`030?l0[@3oool0oooo01X0oooo00<000000?ooo`3oool04@3oool000d0oooo00<0
00000?ooo`3oool01`3oool40?l0[A`0oooo00<0o`2]0?ooo`3oool0=`3oool400X0o`030?l0f@0:
0?l02P3o00D0o`3I2P3oool2000_o`040?ooo`00;ol002oo000_oaP0oooo00<000000?ooo`3oool0
0`3oool30?l000T0oooo0`3o07HS0?ooo`03001Vo`3oool0oooo00`0oooo00<0o`1f0?ooo`3o07H0
0`3oool00`3o07H0oooo0?ooo`060?ooo`<0]P3o0P3oool01@2f0?l0oooo0?l0003oool0o`000080
oooo0P1G0?l0103oool0E`3o0?l00000;ol300000003000_o`3oool0oooo00L0oooo00<000000?oo
o`3oool03@3oool30?l0fA/0oooo0P2f0?l00`3oool0]P3o0;H0o`040;H0o`H0oooo103o0:d00`3o
ool0o`2]0?ooo`0K0?ooo`030000003oool0oooo0140oooo000=0?ooo`030000003oool0oooo0600
oooo0P3j0?l30?ooo`030?l0f@0:0?l02P3o00<02P3o103o0=T80?ooo`@002oo3`3oool00`3o04d0
oooo0?ooo`080?ooo`040000003oool0oooo05L0o`<0oooo00<0o`000?ooo`3oool02@3oool00`3o
07H0oooo0?ooo`0[0?ooo`030?l0f@3oool0oooo00@0oooo0P3o07H20?ooo`030?l0MP3oool0oooo
00D0oooo00@00?o`0?ooo`3oool0oooo0P2f0?l0103oool0]P3o0?ooo`3oool20?l000@0oooo00@0
o`0000000000000000000`3oool00`00;ol0oooo0?ooo`080?ooo`030000003oool0oooo00/0oooo
0P3o0=T20?ooo`030?l0f@3oool0oooo01T0oooo0P2f0?l0103oool0]P3o0?ooo`2f0?l20?ooo`H0
]P3o0`3oool30?l0[Ad0oooo00<000000?ooo`3oool0403oool000d0oooo00<000000?ooo`3oool0
H03oool00`3j0?l0oooo0?X0o`020?X0o`030?l0f@0:0?l0oooo0080oooo00<02P3o0?l0f@3o0=T0
0P3o0=T80?ooo`8002oo403oool30?l0C@T0oooo00<000000?ooo`1G0?l00P1G0?lF0?ooo`03003o
l03oool0oooo00P0oooo00<0nP3o0?ooo`3oool05`3oool30?l0f@D0oooo103o07H60?ooo`@00?o`
103oool0102f0?l0oooo0?ooo`3oool20?l00080oooo0`000007000_o`/0oooo00<000000?ooo`3o
ool0203oool30?l0f@<0oooo00<0o`3I0?ooo`3oool06`3oool20;H0o`030?ooo`2f0?l0oooo00L0
oooo1P2f0?lM0?ooo`030000003oool0oooo0100oooo000=0?ooo`030000003oool0oooo0600oooo
00P0nP3o0?ooo`3oool0nP3o0?ooo`3j0?l0o`3I0?X0o`@0o`3I00<0oooo0?l0f@3oool0603oool2
0?l0C@030?ooo`3o04d0o`1=00T0oooo0P1G0?l20?ooo`0305L0o`3oool0oooo00T0oooo0P00oa<8
0?ooo`04003ol03oool00?o`003ol0L0oooo0`3j0?lF0?ooo`80o`3I00@0oooo0?l0f@3oool0o`3I
0`3oool2000_o`030?l0MP00;ol0oooo00D0oooo1@00oo090?ooo`<0000000@0o`000?ooo`3oool0
oooo1000;ol00`3oool002oo000_o`02000_o`T0oooo00<000000?ooo`3oool01P3oool20?l0f@H0
oooo00<0o`3I0?ooo`3oool0403oool408/0o`D0oooo0P3o0=T30;H0o`h0oooo1P2f0?lG0?ooo`03
0000003oool0oooo0100oooo000=0?ooo`030000003oool0oooo0600oooo00D0nP3o0?ooo`3oool0
nP3o0?ooo`030?l0f@060?X0o`3o0=T0o`3I0?l0f@3oool0o`3I603oool00`3o04d0oooo0?ooo`02
0?ooo`80o`1=1`3oool305L0o`80oooo0P1G0?l:0?ooo`@00?lC1P3oool00`00oo00oooo0?ooo`03
003ol0@0oooo00D0nP3o0?ooo`3j0?l0oooo0?X0o`0=0?ooo`030?l09P3oool0oooo00@0oooo00L0
o`3I0?ooo`3o0=T0oooo0?l0f@3oool0o`3I00<0oooo00<002oo0?ooo`3oool00`00;ol50?ooo`T0
0?o`100000000`3oool0o`000?ooo`040?ooo`8002oo0P3oool2000_o`<0oooo0`00;ol70?ooo`03
0000003oool0oooo00D0oooo0`3o0=T50?ooo`030?l0f@3oool0oooo00<0oooo0P3o0=T60?ooo`T0
R`3o00<0oooo0?l0f@3o0=T00P3o0=T30?ooo`80]P3o503oool40;H0oa<0oooo00<000000?ooo`3o
ool0403oool000`0oooo00<000000?ooo`3oool0HP3oool20?X0o`80o`3I00@0nP3o0?l0f@3o0=T0
o`3I0P3oool20?l0fAP0oooo0`3o04d30?ooo`030?l0C@3oool0o`1=00H0oooo00<0E`3o0000003o
ool0101G0?l90?ooo`@00?lC1P3oool00`00oo00oooo003ol003003ol0@0oooo00@0nP3o0?ooo`3o
ool0nP3o0P3oool00`3j0?l0oooo0?ooo`080?ooo`80o`0V00<0oooo0?l09P3oool00`3oool30?l0
f@030?ooo`3o0=T0o`3I0080oooo00<0o`3I0?ooo`00;ol02P00;ol20?ooo`800?o`0`3oool30000
00H00?o`1P3oool01000;ol0oooo000_o`00;ol70?ooo`@002oo0`3oool00`000000oooo0?ooo`05
0?ooo`80o`3I00<0oooo0?l0f@3o0=T00`3o0=T00`3oool0o`3I0?ooo`020?ooo`80o`3I00@0oooo
0?l0f@3o0=T0o`3I103oool308/0o`040?ooo`3o0=T0R`3o08/0o`80o`3I=03oool00`000000oooo
0?ooo`0@0?ooo`00303oool00`000000oooo0?ooo`1N0?ooo`<0nP3o0`3o0=T00`3j0?l0oooo0?X0
o`020?l0f@<0oooo0P3o0=TG0?ooo`X0o`1=103oool605L0o`040?ooo`1G0?l0oooo05L0o`D0oooo
0`00oa<20?ooo`800?lC1P3oool3003ol0030?ooo`00oo000?o`00<0oooo00D0nP3o0?ooo`3oool0
oooo0?X0o`030?ooo`030?X0o`3oool0oooo00H0oooo00D0o`0V0?ooo`3o02H0oooo0?l09P050?oo
o`030?l0f@3oool0o`3I00H0o`3I00<002oo0?ooo`00;ol00P3oool00`00;ol0oooo0?ooo`060?oo
o`04003ol00000000000000000T0oooo1000oo020?ooo`8002oo3@3oool4000_o`030000003oool0
oooo00D0oooo00<0o`3I0?ooo`3oool00`3oool80?l0f@040?ooo`3o0=T0o`3I0?l0f@@0oooo0P2;
0?l00`3o0=T0R`3o08/0o`0208/0ocH0oooo00<000000?ooo`3oool0403oool000`0oooo00<00000
0?ooo`3oool0E`3oool00`0:0?l0oooo0?ooo`040?X0o`060?ooo`3o0=T0o`3I0?ooo`3j0?l0oooo
0P3j0?l00`3oool0nP3o0?ooo`020?l0f@030?ooo`3o0=T0oooo01T0oooo00<0o`1=0?ooo`3oool0
0P3oool0103o04d0oooo0?l0C@3o04d305L0o`<0oooo00<0E`3o0?ooo`3oool00`1G0?l30?ooo`<0
0?lC3@3oool3003ol0030?ooo`00oo00oooo0080oooo00<0nP3o0?ooo`3oool01@3j0?l20?ooo`03
0?X0o`3oool0oooo00<0oooo0P3o02H00`3oool0o`0V0?ooo`020?ooo`030?l09P3oool0oooo00<0
oooo00@0o`3I0?ooo`3oool0o`3I0P3oool00`3o0=T0oooo0?ooo`02000_o`80oooo00<002oo0?oo
o`3oool0103oool3000002D0oooo00<002oo0000003oool01@3oool20?l0f@@0oooo0P3o0=T30?oo
o`030?l0f@3oool0o`3I00P0o`3I00@0oooo08/0o`3oool0oooo102;0?le0?ooo`030000003oool0
oooo0100oooo000<0?ooo`030000003oool0oooo05D0oooo1@3j0?l20?ooo`<0o`3I0`3oool20?X0
o`040?ooo`3j0?l0oooo0?X0o`<0oooo0P3o0=TK0?ooo`040?l0C@3oool0oooo0?l0C@80oooo00<0
o`1=0?ooo`3oool01@3oool010000000E`3o05L0o`1G0?l30?ooo`800?lC3P3oool2003ol0<0oooo
0P00oo020?ooo`@0nP3o0P3oool20?X0o`030?ooo`3j0?l0nP3o0080nP3o0`3oool01@3o02H0oooo
0?ooo`3oool0o`0V00<0oooo00<0o`0V0?ooo`3oool0103oool01@3o0=T0oooo0?l0f@3oool0o`3I
00@0oooo0`00;ol30?ooo`@00000:P3oool00`000000oooo0?ooo`040?ooo`050?l0f@3oool0oooo
0?ooo`3o0=T01@3oool:0?l0f@<0oooo00@0R`3o0?ooo`2;0?l0R`3o0P3oool208/0oc<0oooo00<0
00000?ooo`3oool0403oool000`0oooo00<000000?ooo`3oool0D03oool50?X0o`80oooo00<02P3o
0?ooo`0:0?l00P3o0=T70?ooo`@0nP3o8P3oool00`3o04d0oooo0?l0C@020?l0C@P0oooo00<00000
05L0o`3oool04`3oool00`00oo00oooo0?ooo`080?ooo`030?X0o`3oool0oooo0080oooo0P3j0?l3
0?ooo`030?X0o`3oool0oooo0080o`0V00@0E`3o0?ooo`3oool0o`0V1@3oool00`3o02H0oooo0?oo
o`040?ooo`<0o`3I1`3oool01000;ol0000000000000000_0?ooo`040000003oool0oooo0?ooo`80
Q@3o103o0=T50?ooo`@0o`3I0`3oool00`3o0=T0oooo0?ooo`040?ooo`<0R`3o1@3oool308/0oc40
oooo00<000000?ooo`3oool03`3oool000`0oooo00<000000?ooo`3oool0@03oool500X0o`<0o`1=
0`0:0?l50?X0o`L02P3o0`3o0=T300X0o`P0oooo00<0nP3o0?ooo`3oool08@3oool30?l0C@T0oooo
00<000000?ooo`3oool0803oool02@3j0?l0oooo0?l0C@3o04d0nP3o0?l0C@3j0?l0oooo0?X0o`02
0?ooo`<0o`0V0P1G0?l00`3oool0o`0V0?ooo`030?ooo`800?lC00<0o`0V0?ooo`3oool0103oool0
0`3o0=T0oooo0?ooo`030?ooo`04003ol0000000000000000380oooo00<000000?ooo`250?l01025
0?l00`3o0=T0Q@3o0?ooo`070?ooo`80o`3I0`3oool00`3o0=T0oooo0?ooo`050?ooo`80R`3o203o
ool208/0obl0oooo00<000000?ooo`3oool03`3oool000`0oooo00<000000?ooo`3oool0A@3oool0
0`3o04d0oooo0?l0C@050?l0C@L0oooo0`3o0=T00`0:0?l0oooo00X0o`0200X0obh0oooo00<0o`1=
0?ooo`3oool0203oool3001Vob40oooo0P3j0?l00`3oool0nP3o0?l0C@020?X0o`@0oooo00<0o`0V
0?ooo`3o02H01`3o02H2003o4`030?l09P00oa<0oooo00L0oooo00H00?o`00000000000000000?oo
o`00oo0d0?ooo`05000000250?l0Q@3o0?ooo`250?l00P3oool00`250?l0oooo0?ooo`080?ooo`80
o`3I00<0oooo0?l0f@3oool04P3oool208/0obd0oooo00<000000?ooo`3oool03`3oool000/0oooo
00<000000?ooo`3oool0AP3oool01@3o04d0oooo0?ooo`3oool0o`1=0080oooo103o04d20?ooo`80
o`3I0P3oool400X0oal0oooo00<0R`3o0?ooo`3oool03@3oool2003=o`X0oooo00<006Ko0?ooo`00
I_l01000I_l00`3oool0Q@3o0?ooo`0H0?ooo`80o`1=0P3oool30?X0o`030?l0C@3oool0oooo0080
oooo00<0E`3o0?l09P1G0?l00P1G0?l00`3o02H0E`3o0?ooo`020?ooo`L0o`0V103oool300000080
0?o`0P3oool00`00oo00oooo0?ooo`0B0?ooo`030?X0o`3oool0oooo01h0oooo00<0000008D0o`25
0?l01@250?l;0?ooo`80o`3I5@3oool308/0obX0oooo00<000000?ooo`3oool03`3oool000/0oooo
00<000000?ooo`3oool0?`3oool30?l0f@@0oooo00H0o`1=0?ooo`3oool0oooo0?l0C@3oool40?l0
C@030?ooo`3o0=T0o`3I00@0oooo0P0:0?lO0?ooo`@0R`3o303oool6003=o`P0oooo00<006Ko0?oo
o`3oool01000I_l0103oool0Q@3o08D0o`250?lF0?ooo`<0o`1=0`3oool0103j0?l0oooo0?ooo`3o
04d20?ooo`<0E`3o00@0o`0V05L0o`3oool0o`0V0P1G0?l40?ooo`03003o4`3o02H00?lC0080oooo
100000020?ooo`800?o`00@0oooo003ol000oo000?o`4P3oool30?X0oa80oooo00<0R`3o0?ooo`3o
ool0303oool01@000000Q@3o08D0o`3oool0Q@3o0080oooo1P250?lO0?ooo`80R`3o:03oool00`00
0000oooo0?ooo`0?0?ooo`002`3oool00`000000oooo0?ooo`0o0?ooo`030?l0f@3oool0o`3I00@0
o`3I00@0o`1=0?ooo`3oool0oooo0P3o04d0103oool0o`1=0?ooo`3o04dV0?ooo`80R`3o0`3oool0
0`2;0?l0oooo0?ooo`0:0?ooo`D00<go2@3oool6001Vo`040?ooo`250?l0oooo0?ooo`80Q@3o5@3o
ool80?l0C@030?ooo`3o04d0oooo0080oooo00L0E`3o0?ooo`1G0?l0o`0V0?ooo`3o02H0E`3o00@0
oooo0P3o02H0103oool000000000000000070?ooo`03003ol03oool0oooo00<00?o`3`3oool30?X0
o`80oooo00<0nP3o0?ooo`3oool03P3oool408/0o``0oooo00<0R`3o000000250?l00P250?l80?oo
o`H0Q@3o6`3oool308/0obD0oooo00<000000?ooo`3oool03`3oool000/0oooo00<000000?ooo`3o
ool0?`3oool0103o0=T0oooo0?ooo`3o0=T20?ooo`80o`3I0`3o04d01@3oool0o`1=0?l0C@3oool0
o`1=02H0oooo202;0?l90?ooo`<00<go0P3oool2003=o`L0oooo0P00I_l01000000006Ko001Vo`3o
ool2001Vo`030?ooo`250?l0oooo0080oooo0`250?lD0?ooo`030?l0C@3oool0oooo0080oooo00<0
o`1=0?ooo`3o04d00P3o04d30?ooo`0605L0o`3oool0E`3o0?l09P1G0?l0o`0V0`3oool0103o02H0
00000000000000020?ooo`03003o4`3oool0oooo00D0oooo0`00oo030?ooo`03003ol03oool0oooo
00X0oooo0`3j0?l40?ooo`030?X0o`3oool0oooo00h0oooo0P2;0?l20?ooo`0608/0o`1G0?l0E`3o
05L0o`3o02H0oooo1P2;0?l00`3oool000000?ooo`0208D0o`h0oooo1P250?lH0?ooo`80R`3o8`3o
ool00`000000oooo0?ooo`0?0?ooo`002`3oool00`000000oooo0?ooo`0o0?ooo`030?l0f@3oool0
oooo0080o`3I103o04d20?ooo`80o`1=0P3oool00`3o04d0oooo0?ooo`0R0?ooo`H0R`3o00@0oooo
08/0o`3oool0R`3o1P3oool3003=o`<0oooo0`00cOl60?ooo`8006Ko0P3oool01`00000006Ko001V
o`3oool006Ko0?ooo`250?l0103oool408D0o`030?l0[@3oool0oooo0140oooo00@0o`1=0?ooo`3o
ool0o`1=0P3oool20?l0C@@0oooo0`1G0?l0103o02H0oooo0?l09P3oool3000000H0oooo00<00?lC
0?ooo`3oool02`3oool2003ol0T0oooo103j0?l50?ooo`030?X0o`3oool0oooo00`0oooo00<0R`3o
0?ooo`1G0?l01@1G0?l00`3o02H0E`3o0?l09P080?ooo`030000003oool0oooo01@0oooo0`250?lG
0?ooo`80R`3o8@3oool00`000000oooo0?ooo`0?0?ooo`002`3oool00`000000oooo0?ooo`0m0?oo
o`@0o`3I0`3o04d00`3oool0o`3I0?l0f@030?l0C@040?ooo`3o04d0oooo0?l0CB80oooo0`2;0?l3
0?ooo`0508/0o`3oool0oooo0?ooo`2;0?l00P3oool00`2;0?l0oooo0?ooo`03003=o`H0oooo0P00
cOl40?ooo`<006Ko103oool00`000000oooo0?ooo`02001Vo`040?ooo`250?l0oooo0?ooo`D0Q@3o
0`3o0:d@0?ooo`800?o`00H0oooo0?l0C@3oool0o`1=0?ooo`3o04d80?ooo`0305L0o`3oool00000
0080000000<0o`0V0?ooo`3oool01`3oool00`00oa<0oooo0?ooo`0<0?ooo`800?o`1`3oool0103j
0?l0oooo0?X0o`3oool20?X0o`<0oooo00<0nP3o0?ooo`3oool0303oool208/0o`@0E`3o0`3o02H0
0`3oool0o`0V0?ooo`080?ooo`030000003oool0oooo02l0oooo0P2;0?l00`3V0?l0oooo0?ooo`0M
0?ooo`030000003oool0oooo00h0oooo000:0?ooo`030000003oool0oooo03X0oooo103o0=T0103o
ool0o`1=0?l0C@3o04d20?ooo`<0o`3I00<0oooo0?l0C@3o04d00`3oool20?l0CBT0oooo00@0R`3o
0?ooo`2;0?l0oooo0P2;0?l3003=o`d0oooo0P00I_l70?ooo`030000003oool0oooo0080oooo00<0
Q@3o0?ooo`250?l00P250?l20?ooo`0608D0o`3o0:d0oooo0?l0[@3oool0o`2]0`3oool00`3j0?l0
oooo0?ooo`070?ooo`@00?o`00<0oooo0?l0C@3o04d00P3o04d70?ooo`@0000000<0oooo0?l09P3o
ool06`3oool2003ol0H0oooo0P3j0?l30?ooo`<0nP3o00<0oooo0?X0o`3oool00P00;ol;0?ooo`80
R`3o0P1G0?l0103o02H0E`3o0?l09P1G0?l20?ooo`030?l09P3oool0oooo00L0oooo00<000000?oo
o`3oool0303oool40;H0oah0oooo1@3V0?lM0?ooo`030000003oool0oooo00h0oooo000:0?ooo`03
0000003oool0oooo03D0oooo1@3o0=T30?ooo`80o`1=0P3oool40?l0f@030?ooo`3o0=T0oooo0080
oooo0P3o04d00`3oool0o`1=0?ooo`0Y0?ooo`0408/0o`3oool0R`3o08/0o`800<go3@3oool3001V
o`T0oooo00<000000?ooo`3oool00P3oool308D0o`050?l09P3oool0oooo08D0o`3o0:d00P3oool0
103o0:d0oooo0?ooo`3o0:d40?X0o`L0oooo0P00oo001P3oool00?o`003ol000oo00oooo0?l0C@H0
oooo0`00000T0?ooo`03003ol03oool0oooo00<0oooo0P3j0?l60?ooo`<0nP3o1000;ol:0?ooo`06
08/0o`1G0?l0o`0V05L0o`3o02H0oooo0P1G0?l00`3oool0o`0V0?ooo`090?ooo`030000003oool0
oooo00H0oooo1P2f0?l20?ooo`030;H0o`3oool0oooo01X0oooo1@3V0?l00`3oool0iP3o0?ooo`0L
0?ooo`030000003oool0oooo00h0oooo000:0?ooo`030000003oool0oooo0340oooo103o0=T50?oo
o`<0o`1=103oool20?l0f@030?ooo`3o0=T0o`3I00H0oooo0P3o04d[0?ooo`0308/0o`3oool0oooo
00d0oooo0P00I_l<0?ooo`030000003oool0oooo0080oooo0`250?l20?l09P030?ooo`250?l0o`2]
0080oooo00D0o`2]0?ooo`3j0?l0nP3o0?l0[@020?ooo`030?X0o`3oool0oooo00H0oooo0`00oo00
0`3oool00?o`0?ooo`040?ooo`<000000P00oa</0?ooo`80nP3o0`3oool20?X0o`<002oo0P3j0?l0
0`3oool002oo0?ooo`090?ooo`80o`0V00@0E`3o0?l09P1G0?l0E`3o0P3oool205L0o`030?l09P3o
ool0oooo00P0oooo00<000000?ooo`3oool01@3oool40;H0o`@0oooo00<0]P3o0?ooo`3oool0603o
ool40>H0o`050?ooo`3V0?l0oooo0?ooo`3V0?l07@3oool00`000000oooo0?ooo`0>0?ooo`002P3o
ool00`000000oooo0?ooo`0/0?ooo`D0o`3I1P3oool30?l0C@T0oooo0P3o0=Tb0?ooo`D0E`3o2`3o
ool2001Vo`h0oooo00D000000?ooo`3oool0oooo08D0o`020?l09P050?ooo`250?l0Q@3o0?l09P3o
0:d00`3oool00`3o0:d0nP3o0?X0o`020?X0o`040?l0[@3j0?l0nP3o0?X0o`P0oooo0`00oo030?oo
o`<000000P3oool4003o4b/0oooo0P3j0?l00`3oool0nP3o0?X0o`020?ooo`@002oo00@0oooo0?X0
o`3j0?l0nP3o203oool20?l09P050?ooo`1G0?l0o`0V0?ooo`1G0?l0103oool00`3o02H0E`3o0?oo
o`080?ooo`030000003oool0oooo00H0oooo00@0]P3o0?ooo`2f0?l0]P3o0P3oool00`2f0?l0oooo
0?ooo`0J0?ooo`80iP3o00<0oooo0>H0o`3V0?l0103V0?lL0?ooo`030000003oool0oooo00h0oooo
000:0?ooo`030000003oool0oooo0280oooo0`3o02H30?ooo`@0o`3I203oool30?l0CC80oooo00<0
08Wo0?ooo`3oool02`3oool0101G0?l0oooo05L0o`3oool505L0o`030?ooo`3j0?l0nP3o01@0oooo
00D000000?ooo`250?l0Q@3o0?l09P040?ooo`040?l09P3o0:d0Q@3o0?ooo`H0o`2]00D0oooo0?X0
o`3o0:d0oooo0?X0o`070?ooo`03003ol03oool00?o`00@000001@3oool3003o4b/0oooo0P0:0?l2
0?X0o`D0oooo0P00;ol01@3oool002oo000_o`00;ol0oooo0080nP3o1`3oool50?l09PH0oooo00<0
o`0V05L0o`1G0?l0203oool00`000000oooo0?ooo`050?ooo`030;H0o`3oool0]P3o00@0]P3o3`3o
ool90?l0f@H0oooo0`3V0?l0103oool0iP3o0?ooo`3oool60>H0oaH0oooo00<000000?ooo`3oool0
3P3oool000X0oooo00<000000?ooo`3oool08P3oool00`3o02H0oooo0?l09P060?l09PH0oooo0`3o
04dc0?ooo`D008Wo303oool0101G0?l0oooo05L0o`3oool305L0o`80oooo00<0nP3o0?ooo`3j0?l0
0`3j0?l@0?ooo`80Q@3o00@0oooo0?l09P3o02H0o`0V0`3oool40?l0[@80oooo00@0o`2]0?ooo`3j
0?l0oooo103o0:d00`3oool0nP3o0?ooo`050?ooo`<000002P3oool00`00oa<0oooo0?ooo`0<0?oo
o`0305L0o`3oool0oooo01X0oooo0P0:0?l20?ooo`<02P3o103oool3000_o`80oooo0`00;ol70?oo
o`030?l09P3oool0o`0V0080oooo1`3o02H20?ooo`<0E`3o1P3oool00`000000oooo0?ooo`040?oo
o`80]P3o0P3oool40;H0o`l0oooo0P3o0=T00`3oool0o`3I0?l0f@030?l0f@L0oooo0P3V0?l00`3o
ool0iP3o0?ooo`070?ooo`H0iP3o403oool00`000000oooo0?ooo`0>0?ooo`002@3oool00`000000
oooo0?ooo`0S0?ooo`050?l09P3oool0oooo0?ooo`3o02H00`3oool40?l09P030?ooo`3o04d0o`1=
03H0oooo00<008Wo0?ooo`3oool01000ROl:0?ooo`@0E`3o00<0oooo05L0o`3oool00P3oool0103j
0?l0oooo0?ooo`3oool50?X0o``0oooo00<0Q@3o0000003oool0203o02H00`3o0:d0o`0V0?l09P02
0?ooo`090?l0[@3oool0nP3o0?X0o`3oool0nP3o0?l0[@3oool0nP3o00@0oooo0`00000=0?ooo`03
003o4`3oool0oooo00X0oooo0`1G0?lL0?ooo`/02P3o00<0oooo000_o`00;ol01@3oool4000_o`@0
oooo00<0o`0V0?ooo`3o02H01P3oool70?l09P80E`3o1@3oool00`000000oooo0?ooo`030?ooo`80
]P3o0`3oool20;H0o`030?ooo`2f0?l0]P3o00d0oooo00@0o`3I0?ooo`3o0=T0o`3I0P3oool00`3o
0=T0oooo0?ooo`070?ooo`<0iP3o3P3oool60>H0o`/0oooo00<000000?ooo`3oool03@3oool000T0
oooo00<000000?ooo`3oool0903oool0103o02H0oooo0?ooo`3o02H20?ooo`<0o`0V0`3o04di0?oo
o`D008Wo2@3oool305L0o`030?ooo`1G0?l0E`3o0080E`3o0`3oool00`3j0?l0oooo0?ooo`020?oo
o`@0nP3o3@3oool01@000000oooo0?ooo`3oool0o`0V00@0oooo00<0o`0V0?ooo`3o0:d00`3oool0
1P3o0:d0nP3o0?ooo`3j0?l0oooo0?l0[@80nP3o0P3oool300000080oooo00<00?o`0?ooo`3oool0
2`3oool00`00oa<0oooo0?ooo`090?ooo`80E`3o0P3oool00`1G0?l0oooo0?ooo`0C0?ooo`<006Ko
0P3oool200X0o`050?ooo`0:0?l0oooo0?ooo`0:0?l04@3oool3000_o`040?ooo`3o02H0oooo0?l0
9PH0oooo0P3o02H50?ooo`@0o`0V103oool00`000000oooo0?ooo`030?ooo`040;H0o`3oool0]P3o
0;H0o`D0oooo0P2f0?l<0?ooo`030?l0f@3oool0oooo00<0o`3I2`3oool00`3V0?l0oooo0?ooo`0B
0?ooo`@0iP3o1`3oool00`000000oooo0?ooo`0=0?ooo`002@3oool00`000000oooo0?ooo`0T0?oo
o`030?l09P3oool0oooo00<0o`0V00@0oooo0?l0C@3o04d0o`0V>@3oool30029o`80oooo0P00ROl7
0?ooo`80E`3o0`3oool405L0o`@0oooo00<0nP3o0?ooo`3oool00`3j0?l00`3oool0nP3o0?ooo`0=
0?ooo`030000003oool0oooo00<002oo0P3oool0203o02H0oooo0?l09P3oool0o`2]0?ooo`3j0?l0
o`2]0P3oool20?l0[@03003ol03oool0000000800000103oool00`00oo00oooo0?ooo`0<0?ooo`03
003o4`3oool0oooo00L0oooo0`1G0?l30?ooo`0305L0o`3oool0oooo00/0oooo00<00<go0?ooo`3o
ool01@3oool2001Vo`030?ooo`00I_l006Ko008006Ko0P0:0?l20?ooo`0300X0o`3oool0oooo0180
oooo0P00;ol20?l09PD0oooo00<0o`0V0?ooo`3oool02@3oool205L0o`80oooo00<000000?ooo`3o
ool00`3oool20;H0o`T0oooo0P2f0?l;0?ooo`030?l0f@3oool0o`3I00<0o`3I:P3oool00`000000
oooo0?ooo`0=0?ooo`002@3oool00`000000oooo0?ooo`0T0?ooo`<0o`0V00H0oooo0?l09P3o02H0
o`0V0?ooo`3o02Hf0?ooo`@008Wo0`3oool30029o`D0oooo0`1G0?l50?ooo`<0E`3o1@3oool40?X0
o`040>H0o`3j0?l0oooo0?X0o`<0oooo00<0o`3I0?ooo`3oool0203oool00`00000002oo000_o`03
000_o`040?l09P3oool0o`0V0?l09P<0oooo00D0o`2]0?ooo`3o0:d0oooo0?l0[@04000000L0oooo
00<00?o`0?ooo`3oool0303oool00`00oa<0oooo0?ooo`060?ooo`80E`3o00@0oooo05L0o`1G0?l0
E`3o0P3oool00`1G0?l0oooo0?ooo`090?ooo`@00<go1P3oool5001Vo`80oooo0`0:0?lH0?ooo`04
0?l09P00;ol0oooo0?ooo`80o`0V3P3oool205L0o`030?ooo`000000oooo00H0oooo00<0]P3o0?oo
o`3oool01`3oool20;H0o`T0oooo103o0=T20?ooo`80o`3I:03oool00`000000oooo0?ooo`0=0?oo
o`002@3oool00`000000oooo0?ooo`0Q0?ooo`@0o`0V0`3oool0103o02H0oooo0?ooo`3o02Hd0?oo
o`<008Wo1`3oool20029o`<0oooo0`1G0?l>0?ooo`D0nP3o00D0oooo0>H0o`3V0?l0iP3o0?X0o`02
0?ooo`<0o`3I203oool2000_o`80oooo0`00;ol30?l09PD0oooo00L0o`2]0000000000000000003o
l03oool00?o`00L0oooo00<00?o`0?ooo`3oool03@3oool00`00oa<0oooo0?ooo`070?ooo`0405L0
o`3oool0E`3o0?ooo`@0E`3o103oool00`2;0?l0oooo0?ooo`040?ooo`D00<go1@3oool4001Vo`D0
oooo00<02P3o0?ooo`3oool05P3oool40?l09Q80oooo0P1G0?l00`000000oooo0?ooo`020?ooo`@0
]P3o2P3oool20;H0o`P0oooo0P3o0=T50?ooo`80o`3I9P3oool00`000000oooo0?ooo`0=0?ooo`00
2@3oool00`000000oooo0?ooo`0N0?ooo`<0o`0V103oool40?l09P80oooo00<0o`0V0?ooo`3oool0
;`3oool30029o`d0oooo0P1G0?l?0?ooo`80nP3o0P3oool20?X0o`040?ooo`3V0?l0oooo0?ooo`<0
iP3o00@0o`3I0?ooo`3o0=T0o`3I2@3oool01000;ol0oooo000_o`3oool3000_o`030?l09P3oool0
oooo0080oooo0`0000000`3o0:d0oooo003ol002003ol1P0oooo00<00?lC0?ooo`3oool0203oool2
05L0o`80oooo00@0E`3o0?ooo`1G0?l0E`3o0P3oool308/0o`@0oooo00<00<go0?ooo`00cOl00P00
cOl00`3o04d0oooo0?ooo`040?ooo`@006Ko7P3oool00`3o02H0oooo0?ooo`0D0?ooo`0305L0o`00
0000oooo0080]P3o00<0oooo0;H0o`2f0?l00P2f0?l;0?ooo`80]P3o1`3oool00`3o0=T0oooo0?oo
o`050?ooo`80o`3I903oool00`000000oooo0?ooo`0=0?ooo`002@3oool00`000000oooo0?ooo`0K
0?ooo`<0o`0V1`3oool0103o02H0oooo0?ooo`3oool20?l09S00oooo0P00ROl=0?ooo`<0E`3o3P3o
ool30?X0o`H0oooo00H0nP3o0>H0o`3j0?l0oooo0?X0o`3o0=T30>H0o`030?ooo`3o0=T0o`3I00P0
oooo00L00000000_o`00;ol0oooo000_o`3oool002oo0080oooo0`0000050?ooo`<00?o`603oool0
0`00oa<0oooo0?ooo`080?ooo`0305L0o`3oool0E`3o0080oooo0P1G0?l20?ooo`0508/0o`3oool0
R`3o0?ooo`2;0?l00`3oool3003=o`80o`1=00<0oooo0?l0C@3oool0103oool2001Vo`80oooo00<0
06Ko0?ooo`3oool0403oool408D0oal0oooo00<0]P3o0000002f0?l00`2f0?l20?ooo`030;H0o`3o
ool0oooo00/0oooo0P2f0?l?0?ooo`80o`3I8P3oool00`000000oooo0?ooo`0=0?ooo`00203oool0
0`000000oooo0?ooo`0J0?ooo`80o`0V2`3oool20?l09P030?ooo`3o02H0o`0V03`0oooo0`1G0?l?
0?ooo`80nP3o2@3oool00`3V0?l0oooo0?ooo`020?X0o`030?l0f@3V0?l0iP3o0080iP3o00<0o`3I
0?ooo`3o0=T01`3oool00`00000002oo000_o`02000_o`@000001`3oool01000oo00oooo0?ooo`00
oo0H0?ooo`03003o4`3oool0oooo00T0oooo1@1G0?l20?ooo`0308/0o`3oool0R`3o0080R`3o00<0
oooo08/0o`3oool00`3oool01@3o04d00<go0?l0C@00cOl0o`1=00X0oooo0P00I_l<0?ooo`D0Q@3o
0P3oool00`250?l0oooo0?ooo`0N0?ooo`030000002f0?l0]P3o00D0]P3o3`3oool20;H0o`l0oooo
0P3o0=TP0?ooo`030000003oool0oooo00d0oooo00080?ooo`030000003oool0oooo01L0oooo0`3o
02H?0?ooo`80o`0V;03oool508/0o`H0oooo0`3o07H00`3oool0E`3o05L0o`0@0?ooo`80nP3o2`3o
ool0103V0?l0oooo0?ooo`3oool40>H0o`030?l0f@3V0?l0o`3I0080o`3I1`3oool00`00;ol0oooo
00000002000000X0oooo00<00?o`0?ooo`3oool09`3oool01@1G0?l0oooo0?ooo`3oool0E`3o00<0
R`3o00<0oooo08/0o`3oool00`2;0?l20?ooo`070?l0C@3oool0o`1=0?ooo`00cOl0oooo0?l0C@0;
0?ooo`03001Vo`3oool0oooo00T0oooo0`250?l40?ooo`0308D0o`3oool0oooo01l0oooo00D00000
0;H0o`3oool0]P3o0?ooo`060;H0o`d0oooo0P2f0?l?0?ooo`80o`3I7`3oool00`000000oooo0?oo
o`0<0?ooo`00203oool00`000000oooo0?ooo`0D0?ooo`<0o`0V@03oool208/0o`80oooo1@2;0?l2
0?ooo`030?l0MP3oool0o`1f00D0o`1f2`3oool30?X0o``0oooo00<0iP3o0?ooo`3V0?l00`3V0?l0
1@3oool0o`3I0>H0o`3V0?l0o`3I00<0oooo00<0o`3I0?ooo`3oool00`3oool3000000d0oooo00<0
0?o`0?ooo`3oool02@3oool2000_oad0oooo00L00?o`0?ooo`3oool0oooo05L0o`2;0?l0oooo0080
R`3o0P3oool0102;0?l0oooo0?l0C@3o04d20?ooo`060?l0C@3oool0oooo003=o`3oool0o`1=2`3o
ool00`00I_l0oooo0?ooo`080?ooo`0308D0o`3oool0Q@3o0080Q@3o0P3oool00`250?l0oooo0?oo
o`0?0?ooo`T0nP3o203oool01@000000]P3o0?ooo`3oool0]P3o00D0oooo102f0?l;0?ooo`030;H0
o`3oool0oooo00h0oooo0P3o0=TM0?ooo`030000003oool0oooo00`0oooo00080?ooo`030000003o
ool0oooo0140oooo0`3o02I40?ooo`80R`3o00<0oooo08/0o`2;0?l00P2;0?l30?ooo`050?l0MP3o
ool0oooo0?ooo`3o07H00P3oool40?l0MPH0oooo0P3j0?l?0?ooo`80iP3o00@0oooo0>H0o`3oool0
oooo0P3o0=T20>H0o`040?l0f@3oool0o`3I0?l0f@<0oooo0`0000000`3oool000000?ooo`0<0?oo
o`03003ol03oool0oooo00X0oooo1000;olB0?ooo`03000_o`3oool0oooo00D0oooo0`00oo030?oo
o`0705L0o`2;0?l0R`3o08/0o`3oool0R`3o0?ooo`060?l0C@<0oooo00<00<go0?ooo`3o04d02`3o
ool00`00I_l0oooo0?ooo`070?ooo`0408D0o`3oool0Q@3o0?ooo`80Q@3o00<0oooo08D0o`3oool0
4@3oool20?X0o`030?ooo`3j0?l0nP3o00<0nP3o2@3oool010000000]P3o0;H0o`2f0?l50?ooo`D0
o`3I102f0?lI0?ooo`80o`3I6`3oool00`000000oooo0?ooo`0<0?ooo`00203oool00`000000oooo
0?ooo`0>0?ooo`<0o`0VA`3oool308/0o`80oooo00<0R`3o0?ooo`3oool00P3oool01@3o07H0oooo
0?ooo`3oool0o`1f0080oooo0`3o07H50?ooo`80nP3o4P3oool20>H0o`040?ooo`3o0=T0o`3I0?oo
o`80iP3o00<0o`3I000_o`00;ol00P3oool3000000050?ooo`00;ol0oooo0?ooo`000000303oool0
0`00oo00oooo0?ooo`0:0?ooo`03000_o`3oool0oooo00<002oo3`3oool4000_o`H0oooo1@00oo02
0?ooo`0405L0o`2;0?l0R`3o08/0o`<0oooo00D0o`1=0?ooo`3oool0o`1=0?ooo`040?l0C@03003=
o`3o04d0oooo00/0oooo0P00I_l80?ooo`0408D0o`3oool0oooo0?ooo`<0Q@3o4P3oool0103j0?l0
oooo0?X0o`3j0?l20?ooo`030?X0o`3oool0oooo00T0oooo00<000000;H0o`2f0?l01@3oool30?l0
f@030?ooo`3o0=T0o`3I00@0o`3I102f0?lF0?ooo`80o`3I6@3oool00`000000oooo0?ooo`0<0?oo
o`00203oool00`000000oooo0?ooo`0;0?ooo`<0o`0VB03oool408/0o`030?ooo`2;0?l0R`3o00D0
oooo00<0o`1f0?ooo`3oool00P3oool30?l0MP030?ooo`3o07H0oooo0080oooo0P3j0?l:0?ooo`03
00X0o`3oool0oooo00D0oooo0P3V0?l20?ooo`80iP3o0P3oool20>H0o`03000_o`00000000000080
0000103oool01000;ol0oooo0?ooo`00000;0?ooo`03003ol03oool0oooo00/0oooo1@00;ol00`3o
ool002oo0?ooo`040?ooo`030?l0f@3oool0oooo00@0oooo0P00;ol20?ooo`04000_o`3oool002oo
000_o`<0oooo00<00?o`0?ooo`00oo001000oo030?ooo`0308/0o`3oool0oooo0080oooo00@0o`1=
0?ooo`3oool0o`1=0`3oool50?l0C@d0oooo00<006Ko0?ooo`3oool01@3oool00`250?l0oooo0?oo
o`020?ooo`@0Q@3o4@3oool00`3j0?l0oooo0?ooo`030?X0o`/0oooo00<000000?ooo`3oool01P3o
ool00`3o0=T0oooo0?l0f@020?ooo`030?l0f@3oool0o`3I00D0oooo0`2f0?lE0?ooo`80o`3I5`3o
ool00`000000oooo0?ooo`0<0?ooo`001`3oool00`000000oooo0?ooo`090?ooo`<0o`0VB03oool3
08/0o`<0oooo0`2;0?l70?ooo`@0o`1f0`3o0:d00`3o07H0oooo0?ooo`0<0?ooo`D02P3o0`3oool2
0>H0o`H0oooo0P3V0?l300000003000_o`3oool0oooo00@0oooo00D002oo0?ooo`3oool0oooo0000
000;0?ooo`03003ol03oool0oooo00X0oooo0P00;ol00`3oool002oo0?ooo`02000_o`@0oooo103o
0=T60?ooo`04000_o`3oool0oooo000_o`<0oooo00<002oo0?ooo`3oool01@00oo0;0?ooo`030?l0
C@3oool0o`1=00D0oooo0`3o04d>0?ooo`03001Vo`3oool0oooo00@0oooo00<0Q@3o0?ooo`250?l0
0P250?l40?ooo`0508D0o`3oool0oooo0?ooo`0:0?l03@3oool00`3j0?l0oooo0?X0o`030?X0o`80
oooo00<0o`2]0?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`80o`3I00H0oooo0?l0f@3o
0=T0o`3I0?ooo`3o0=TO0?ooo`80o`3I5@3oool00`000000oooo0?ooo`0<0?ooo`001`3oool00`00
0000oooo0?ooo`070?ooo`80o`0VB@3oool208/0o`H0oooo0P2;0?l70?ooo`80o`1f0P3oool00`3o
07H0o`2]0?ooo`060?l0[@P0oooo100:0?l00`3oool02P3o00X0o`020?ooo`030>H0o`3oool0oooo
00D0oooo0`000000103V0?l002oo0?ooo`00;ol50?ooo`05000_o`3oool0oooo0?ooo`0000002`3o
ool00`00oo00oooo0?ooo`0;0?ooo`8002oo00<0oooo000_o`3oool00P00;ol20?ooo`80o`3I0`3o
ool20?l0f@H0oooo0`00;ol20?ooo`03000_o`3oool0oooo00D0oooo00<00?o`0?ooo`3oool02@3o
ool00`3o04d0oooo0?l0C@050?ooo`030?l0C@3oool0oooo0080o`1=3@3oool00`00I_l0oooo0?oo
o`030?ooo`80Q@3o203oool208D0o`@02P3o2`3oool40?X0o`80oooo0`3o0:d90?ooo`030000003o
ool0oooo00@0oooo00@0o`3I0?ooo`3o0=T0oooo0`3o0=TR0?ooo`80o`3I4`3oool00`000000oooo
0?ooo`0<0?ooo`001`3oool00`000000oooo0?ooo`1?0?ooo`<0R`3o3P3oool30?l0MP080?ooo`3o
07H0o`1f0?l0MP3oool0o`2]0?ooo`3o07H20?ooo`H0o`2]1P3oool00`0:0?l0oooo0?ooo`0300X0
o`80iP3o1@3oool3000000<0oooo00@002oo0?ooo`3oool002oo103oool00`00;ol0oooo0?ooo`02
0?ooo`030000003oool0oooo00P0oooo00<00?o`0?ooo`3oool03P3oool2000_o`040?ooo`00;ol0
oooo0?ooo`P0o`3I1`3oool4000_o`P0oooo00<00?o`0?ooo`3oool02P3oool00`3o04d0oooo0?l0
C@020?ooo`80o`1=1@3oool20?l0C@`0oooo0P00I_l<0?ooo`<02P3o00@0Q@3o0?ooo`3oool02P3o
303oool20?X0o`070?ooo`3o0:d0o`2]0?l0[@3oool0nP3o0?l0[@090?ooo`030000003oool0oooo
00@0oooo00<0o`3I0?ooo`3o0=T0103o0=TS0?ooo`030?l0f@3oool0oooo0140oooo00<000000?oo
o`3oool02`3oool000L0oooo00<000000?ooo`3oool0C03oool308/0o`l0oooo0P3o07H40?ooo`<0
o`1f00@0oooo0?l0[@3o07H0o`1f0`3oool50?l0[@L0oooo0P0:0?l0103oool0iP3o0>H0o`0:0?l3
0?ooo`<000001@3oool01000;ol0oooo000_o`00;ol:0?ooo`030000003oool0oooo00L0oooo00<0
0?o`0?ooo`3oool03P3oool00`00;ol0oooo0?ooo`02000_o`80oooo00@006Ko0?l0f@3oool0oooo
1@3o0=T60?ooo`8002oo2P3oool00`00oo00oooo0?ooo`0;0?ooo`80o`1=00<0oooo0?l0C@3oool0
5P3oool00`00I_l0oooo0?ooo`0:0?ooo`<02P3o0P250?l>0?ooo`@0o`2]0`3oool00`3o0:d0nP3o
0?ooo`080?ooo`030000003oool0oooo00<0oooo00D0o`3I0?ooo`3o0=T0oooo0?l0f@020?ooo`03
0?l0f@3oool0oooo03@0oooo00<000000?ooo`3oool02`3oool000L0oooo00<000000?ooo`3oool0
B@3oool308/0oa00oooo0P3o07H90?ooo`030?l0MP3o0:d0o`1f00<0oooo0`3o0:d00`3oool0o`2]
0?ooo`070?ooo`802P3o00<0iP3o00X0o`0:0?l0100000070?ooo`05000_o`3oool0oooo0?ooo`00
;ol02P3oool00`000000oooo0?ooo`070?ooo`03003ol03oool0oooo00h0oooo00<002oo0?ooo`3o
ool00`3oool3001Vo`030?ooo`3o0=T0oooo00<0o`3I00<0oooo0?l0f@3oool0103oool00`00;ol0
oooo0?ooo`0:0?ooo`03003ol03oool0oooo00H0oooo1000;ol30?l0CAT0oooo00<006Ko0?ooo`3o
ool02@3oool200X0o`80oooo00<02P3o08D0o`250?l02`3oool00`3o0:d0oooo0?l0[@050?ooo`04
0?l0[@3oool0nP3o0?X0o`L0oooo00<000000?ooo`3oool0103oool30?l0f@@0oooo0P3o0=Td0?oo
o`030000003oool0oooo00/0oooo00070?ooo`030000003oool0oooo04L0oooo0P2;0?l@0?ooo`<0
o`1f3@3oool00`3o0:d0oooo0?l0[@030?l0[@80oooo00<0o`2]0?ooo`3oool01@3oool00`0:0?l0
oooo0?ooo`03000000X0oooo00<002oo0?ooo`3oool02`3oool905L0o`80oooo00<00?o`0?ooo`3o
ool02@3oool208D0o`<0oooo00<002oo0?ooo`3oool00`3oool4001Vo`030?l0f@3oool0o`3I0080
o`3I00<0oooo0?l0f@3oool01@3oool00`00;ol0oooo0?ooo`0:0?ooo`03003ol03oool0oooo00H0
oooo1000;ol00`3oool0o`1=000_o`0D0?ooo`@0E`3o3P3oool300X0o`<0oooo00<0Q@3o00X0o`0:
0?l0203oool30?l0[@H0oooo00<0o`2]0?ooo`3oool00P3j0?l60?ooo`030000003oool0oooo00<0
oooo0P3o0=T70?ooo`030?l0f@3oool0oooo00/0oooo2@3o0:dM0?ooo`030000003oool0oooo00/0
oooo00060?ooo`030000003oool0oooo0400oooo0`3o04d20?ooo`<0R`3o403oool20?l0MQ00oooo
0P3o0:d01P3oool0o`2]0?ooo`3o0:d0oooo0?l0[@L0oooo00@02P3o0000000000000000303oool0
0`00;ol0oooo0?ooo`0<0?ooo`0305L0o`3oool0000000H0E`3o00<0oooo003ol03oool02P3oool4
08D0o`030?ooo`00;ol0oooo00@0oooo1000I_l0103o0=T006Ko0?l0f@3oool30?l0f@030?ooo`3o
0=T0oooo00@0oooo00<002oo0?ooo`3oool02P3oool00`00oo00oooo0?ooo`060?ooo`<002oo0`3o
ool00`00;ol0oooo0?ooo`0B0?ooo`P0E`3o2`3oool200X0o`@0oooo0P250?l400X0o`D0oooo00<0
o`2]0?ooo`3o0:d00P3o0:d30?ooo`030?l0[@3oool0oooo0080oooo0P3j0?l50?ooo`030000003o
ool0oooo00`0oooo0P3o0=T<0?ooo`80o`2]00<0oooo0?l0[@3o0:d00`3o0:dM0?ooo`030000003o
ool0oooo00/0oooo00060?ooo`030000003oool0oooo0400oooo203o04d=0?ooo`<0o`1f3`3oool6
0?l0[@<0oooo0P3o0:d50?ooo`<000003P3oool00`00;ol0oooo0?ooo`0>0?ooo`0405L0o`000000
oooo0?ooo`80E`3o00<0oooo05L0o`3oool02P3oool208D0o`060?ooo`250?l0Q@3o08D0o`3oool0
02oo103oool2001Vo`040?ooo`00I_l006Ko001Vo`@0o`3I0`3oool00`3o0=T0oooo0?ooo`030?oo
o`03000_o`3oool0oooo00X0oooo00<00?o`0?ooo`3oool01P3oool2000_o`040?ooo`00;ol0oooo
000_oaH0oooo0`1G0?l20?ooo`80E`3o4`3oool208D0o`80oooo0`0:0?l20?ooo`80o`2]0`3oool3
0?l0[@030?ooo`3o0:d0oooo00@0oooo00<0nP3o0?ooo`3oool00`3oool00`000000oooo0?ooo`0=
0?ooo`030?l0f@3oool0oooo00T0oooo00@0o`2]0?ooo`3o0:d0o`2]0P3oool00`3o0:d0oooo0?oo
o`0L0?ooo`030000003oool0oooo00/0oooo00060?ooo`030000003oool0oooo0400oooo00<0o`1=
0?ooo`3oool0203o04d80?ooo`80o`1f403oool20?l0[@<0oooo0P3o0:d40?ooo`80o`2]00<0oooo
0000000000000P0000000`0:0?l0oooo0?ooo`0=0?ooo`03000_o`3oool0oooo00l0oooo00<0E`3o
0000003oool0101G0?l20?ooo`030?l0[@3oool0oooo00H0oooo00P0Q@3o0?ooo`3oool0Q@3o0?oo
o`250?l0oooo000_o`H0oooo1000I_l00`3o0=T006Ko0?l0f@030?l0f@<0oooo00D0o`3I0?ooo`3o
ool0oooo000_o`0>0?ooo`03003ol03oool0oooo00D0oooo00@002oo0?ooo`3oool0oooo0P00;ol>
0?ooo`8008Wo1P3oool00`1G0?l0oooo0?ooo`0305L0o`/0oooo1@3j0?l60?ooo`0308D0o`3oool0
oooo0080oooo0P0:0?l20?l0[@D0oooo0`3o0:d60?ooo`80nP3o103oool00`000000oooo0?ooo`0=
0?ooo`80o`3I2P3oool00`3o0:d0oooo0?ooo`030?l0[Ah0oooo00<000000?ooo`3oool02`3oool0
00H0oooo00<000000?ooo`3oool0@@3oool00`3o04d0oooo0?l0C@030?ooo`<0o`1=1`3oool20?l0
MQ00oooo0P3o0:d70?ooo`<0o`2]00@02P3o00000000000000000`3oool00`0:0?l0oooo0?ooo`0=
0?ooo`03000_o`3oool0oooo0100oooo00D0E`3o0000001G0?l0E`3o0?ooo`0205L0o`040?ooo`3o
0:d0o`2]0?l0[@P0oooo00@0Q@3o0?ooo`250?l0Q@3o0P3oool00`00;ol0Q@3o0?ooo`060?ooo`04
001Vo`3o0=T0o`3I0?l0f@80oooo00<0o`3I0?ooo`3o0=T0103o0=T20?ooo`03000_o`3oool0oooo
00`0oooo00<00?o`0?ooo`3oool01@3oool00`00;ol0oooo0?ooo`03000_o`h0oooo1000ROl50?oo
o`0405L0o`3oool0oooo05L0o``0oooo2P3j0?l90?ooo`030?l0[@0:0?l0oooo00<0oooo0P3o0:d0
103oool0o`2]0?l0[@3o0:d50?ooo`80nP3o0P3oool00`000000oooo0?ooo`0?0?ooo`80o`3I2@3o
ool00`3o0:d0oooo0?l0[@030?l0[Ad0oooo00<000000?ooo`3oool02`3oool000H0oooo00<00000
0?ooo`3oool0@@3oool00`3o04d0oooo0?ooo`020?l0C@<0o`0V00<0o`1=0?ooo`3oool00P3oool3
0?l0MQ00oooo0P3o0:d70?ooo`<02P3o0`0000000`3o0:d0oooo0?ooo`020?ooo`0300X0o`3oool0
oooo00d0oooo00<002oo0?ooo`3oool04@3oool305L0o`<0oooo00@0E`3o0?l0[@3oool0oooo0P3o
0:d80?ooo`0608D0o`3oool0Q@3o0?ooo`00;ol0Q@3o1`3oool01000I_l0oooo0?ooo`3o0=T30?oo
o`80o`3I103oool20?l0f@030?ooo`00;ol0oooo00d0oooo00<00?o`0?ooo`3oool01@3oool3000_
o`<0oooo00<002oo0?ooo`3oool02P3oool60029o`@0oooo00D0E`3o0?ooo`1G0?l0oooo05L0o`0<
0?ooo`030?X0o`3oool0nP3o0080oooo0`3j0?l:0?ooo`040?l0[@3oool0oooo0?ooo`80o`2]1P3o
ool30?l0[@@0oooo0P3j0?l00`3oool000000?ooo`0A0?ooo`030?l0f@3oool0oooo00H0oooo103o
0:d20?ooo`80o`2]703oool00`000000oooo0?ooo`0:0?ooo`001P3oool00`000000oooo0?ooo`11
0?ooo`@0o`1=00<0oooo0?l09P3oool01`3o02H@0?ooo`80o`2]203oool01@0:0?l0000000000000
0000oooo00802P3o103oool00`0:0?l0oooo0?ooo`0=0?ooo`03000_o`3oool0oooo0140oooo00<0
E`3o0?ooo`1G0?l01@1G0?l00`3oool0o`2]0?l0[@020?l0[@P0oooo1@250?l80?ooo`05001Vo`3o
ool0oooo0?ooo`3o0=T00P3oool20?l0f@@0oooo00@0o`3I0?ooo`3oool002oo3`3oool00`00oo00
oooo0?ooo`0;0?ooo`03000_o`3oool0oooo00T0oooo00<008Wo0?ooo`00ROl00P00ROl60?ooo`05
05L0o`3oool0oooo0?ooo`1G0?l02`3oool20?X0o`060?ooo`3j0?l0oooo0?X0o`3oool0nP3o2`3o
ool30?l0[@/0oooo0P3o0:d40?ooo`80nP3o00<000000?ooo`3oool0403oool20?l0f@L0oooo0P3o
0:d50?ooo`80o`2]6P3oool00`000000oooo0?ooo`0:0?ooo`001P3oool00`000000oooo0?ooo`0o
0?ooo`<0o`1=0P3oool20?l0C@040?l09P3oool0o`1=0?ooo`T0o`0V2@3oool30?l0[@P0oooo0`00
00000`0:0?l0oooo00X0o`0300X0o`<0oooo00<02P3o0?ooo`3oool03@3oool00`00;ol0oooo0?oo
o`0A0?ooo`0405L0o`3oool0oooo00000080oooo0P3o0:d00`1G0?l0o`2]0?l0[@040?l0[@H0oooo
00@0Q@3o0?ooo`3oool0Q@3o2P3oool00`00I_l0oooo0?ooo`020?ooo`030?l0f@3oool0oooo0080
o`3I0P3oool00`3o0=T00<go003=o`0A0?ooo`03003ol03oool0oooo00L0oooo00D002oo0?ooo`3o
ool0oooo000_o`0<0?ooo`@008Wo2`3oool205L0o`T0oooo00@0nP3o0?ooo`3j0?l0oooo0`3j0?l<
0?ooo`030?l0[@3oool0oooo00d0oooo0`3o0:d30?ooo`030?X0o`000000oooo0180oooo00<0o`3I
0?ooo`3oool01@3oool00`3o0:d0oooo0?ooo`050?ooo`80o`2]603oool00`000000oooo0?ooo`0:
0?ooo`001@3oool00`000000oooo0?ooo`0n0?ooo`80o`1=0`3oool40?l0C@030?ooo`3o02H0oooo
0080oooo00@0o`0V0?ooo`3oool0oooo0`3o02H80?ooo`80o`2]1`3oool4000000@0oooo00@02P3o
0?ooo`0:0?l02P3o4`3oool00`00;ol0oooo0?ooo`0A0?ooo`0505L0o`3oool0oooo0?ooo`000000
0P3oool305L0o`030?l0[@2f0?l0o`2]00<0oooo00<0o`2]0?ooo`3oool00`3oool00`250?l0oooo
0?ooo`0;0?ooo`03001Vo`3oool0oooo00<0oooo00<0o`3I0?ooo`3o0=T00`3o0=T4003=oa00oooo
00<00?o`0?ooo`3oool01`3oool2000_o`<0oooo00<002oo0?ooo`3oool02`3oool01@00ROl0oooo
0029o`3oool0o`3I00X0oooo00<0E`3o0?ooo`3oool01`3oool00`3j0?l0oooo0?X0o`030?X0oal0
oooo0P3o0:d30?ooo`030000003oool0oooo0140oooo0P3o0=T?0?ooo`030?l0[@3oool0oooo01D0
oooo00<000000?ooo`3oool02P3oool000D0oooo00<000000?ooo`3oool0>`3oool30?l0C@D0oooo
00H0o`1=0?ooo`3oool0o`1=0?ooo`3o02H30?ooo`030?l09P3oool0o`0V0080o`0V00<0oooo0?l0
9P3oool01@3oool20?l0[@H0oooo0`0000070?ooo`0300X0o`3oool02P3o00802P3o2@3oool:0?X0
o``0oooo00<0]P3o0?ooo`3oool00`3oool205L0o`@0oooo00@0000005L0o`1G0?l0oooo0`1G0?l3
0;H0o`030?ooo`3o0:d0oooo00@0oooo00<0Q@3o0?ooo`3oool0303oool00`00I_l0oooo0?ooo`04
0?ooo`@0o`3I1P00cOl@0?ooo`03003ol03oool0oooo00H0oooo1000;ol20?ooo`03000_o`3oool0
oooo00`0oooo0P3o0=T00`3oool0o`3I0?ooo`090?ooo`0305L0o`3oool0oooo00H0oooo00L0nP3o
0?ooo`3j0?l0oooo0?X0o`3oool0nP3o02<0oooo00<000000?ooo`3oool01P3oool30?l0C@X0oooo
00<0o`3I0?ooo`3oool03@3oool20?l0[AD0oooo00<000000?ooo`3oool02P3oool000D0oooo00<0
00000?ooo`3oool0>@3oool20?l0C@T0oooo0P3o04d00`3oool0o`1=0?l09P030?ooo`80o`0V00@0
oooo0?l09P3oool0o`0V1@3oool20?l0[@D0oooo0`0000090?ooo`0500X0o`3oool0oooo0?ooo`0:
0?l02P3oool00`3j0?l0oooo0?X0o`070?X0o`/0oooo00@0]P3o0?ooo`2f0?l0]P3o0P3oool00`1G
0?l0oooo0?ooo`030?ooo`80E`3o0P3oool01@1G0?l0o`2]05L0o`2f0?l0oooo0080o`2]0P2f0?l5
0?ooo`0308D0o`3oool0oooo00/0oooo00<006Ko0?ooo`3oool01P3oool01@3o0=T0oooo0?l0f@00
cOl0oooo00800<go00<0oooo003=o`3oool03`3oool01000oo00oooo00X0o`0:0?l40?ooo`<002oo
00<0oooo000_o`00;ol00P3oool00`00;ol0oooo0?ooo`090?ooo`<0o`3I00<0oooo0029o`3o0=T0
2`3oool00`1G0?l0oooo0?ooo`060?ooo`<0nP3o0`3oool20?X0oa80oooo2@3o0=T70?ooo`030000
003oool0oooo00H0oooo1`3o04d60?ooo`80o`3I3`3oool20?l0[A<0oooo00<000000?ooo`3oool0
2P3oool000D0oooo00<000000?ooo`3oool0=P3oool30?l0C@d0oooo0P3o04d40?l09P030?ooo`3o
02H0o`0V0080oooo00@0o`0V0?ooo`3oool0oooo0P3o0:d40?ooo`<000002`3oool00`0:0?l0oooo
0?ooo`0>0?ooo`030?X0o`3oool0nP3o0080oooo0`3j0?l:0?ooo`H0]P3o00<0oooo05L0o`3oool0
1P3oool00`1G0?l0oooo0?l0[@0305L0o`030;H0o`3o0:d0o`2]00<0oooo0P2f0?l20?ooo`0308D0
o`3oool0oooo00`0oooo00<006Ko0?ooo`3oool0203oool4003=o`030?ooo`00cOl0oooo0140oooo
100:0?l30?ooo`05000_o`3oool002oo000_o`3oool00P00;ol20?ooo`03000_o`3oool0oooo00H0
oooo0`3o0=T40?ooo`030029o`3o0=T0oooo00X0oooo00<0E`3o0?ooo`3oool01@3oool20?X0o`H0
oooo00<0nP3o0?ooo`3oool0403oool20?l0f@030?ooo`3o0=T0o`3I00<0o`3I203oool00`000000
oooo0?ooo`050?ooo`030?l0C@3oool0o`1=00@0oooo0`3o04d50?ooo`030?l0f@3oool0oooo00h0
oooo0P3o0:dA0?ooo`030000003oool0oooo00X0oooo00050?ooo`030000003oool0oooo03<0oooo
0`3o04dA0?ooo`<0o`0V0P3oool20?l09P80oooo00<0o`0V0?ooo`3oool00P3o0:d20?ooo`@00000
3@3oool00`0:0?l0oooo0?ooo`0?0?ooo`030?X0o`3oool0oooo00<0nP3o00<0oooo0?X0o`3oool0
203oool20;H0o`<0oooo00<0]P3o05L0o`1G0?l0203oool020000000E`3o05L0o`3oool0E`3o0?oo
o`2f0?l0E`3o0P3oool50;H0o`030?ooo`250?l0oooo00d0oooo00<006Ko0?ooo`3oool02`3oool3
003=oa40oooo0P0:0?l0103oool02P3o00X0o`0:0?l20?ooo`H002oo103oool00`00;ol0E`3o05L0
o`040?ooo`@0o`3I103oool00`00ROl0o`3I0?ooo`0;0?ooo`80E`3o3P3oool00`3j0?l0oooo0?oo
o`0?0?ooo`040?l0f@3oool0o`3I0?l0f@80oooo00<0o`3I0?ooo`3oool0203oool00`000000oooo
0?ooo`050?ooo`030?l0C@3oool0o`1=00@0oooo00<0o`1=0?ooo`3oool01@3oool20?l0fA00oooo
0P3o0:d@0?ooo`030000003oool0oooo00T0oooo00050?ooo`030000003oool0oooo0340oooo0P3o
04dB0?ooo`80o`0V0P3oool30?l09P050?ooo`3o02H0oooo0?ooo`3o02H00`3oool3000000l0oooo
0P0:0?lC0?ooo`<0nP3o00<0oooo0?X0o`3j0?l02`3oool01`2f0?l0oooo0?ooo`2f0?l0E`3o0?oo
o`2f0?l0203oool00`000000oooo05L0o`0205L0o`030?ooo`2f0?l0E`3o00<0]P3o00D0oooo0;H0
o`2f0?l0oooo08D0o`0?0?ooo`03001Vo`3oool0oooo00/0oooo00<00<go0?ooo`3oool0403oool0
1@0:0?l0oooo0?ooo`3oool02P3o0080oooo00<02P3o0?ooo`3oool01000;ol60?ooo`04000_o`1G
0?l0E`3o05L0o`<0oooo1P3o0=T20?ooo`030029o`3o0=T0oooo00`0oooo00<0E`3o0?ooo`3oool0
303oool20?X0oa00oooo00<0o`3I0?ooo`3oool00`3o0=T0103oool0iP3o0>H0o`3V0?l70?ooo`03
0000003oool0oooo00@0oooo00<0o`1=0?ooo`3oool00P3o04d00`3oool0o`1=0?l0C@090?ooo`03
0?l0f@3oool0oooo00l0oooo0P3o0:d>0?ooo`030000003oool0oooo00T0oooo00040?ooo`030000
003oool0oooo02l0oooo0`3o04dA0?ooo`<0o`0V103oool20?l09P<0oooo0P3o02H0103oool00000
00000000000A0?ooo`0300X0o`3oool0oooo0180oooo0P3j0?l20?ooo`030?X0o`3oool0nP3o00`0
oooo00@0]P3o0?ooo`1G0?l0]P3o0P3oool00`2f0?l0oooo0?ooo`050?ooo`050000001G0?l0oooo
0?ooo`1G0?l01@2f0?l20?ooo`80]P3o00<0oooo08D0o`3oool00`3oool00`00;ol0oooo0?ooo`08
0?ooo`03001Vo`3oool0oooo00/0oooo00<00<go0?ooo`3oool00P3oool00`1G0?l0oooo0?ooo`0<
0?ooo`0600X0o`3oool02P3o00X0o`3oool02P3o1P3oool00`00;ol0oooo0?ooo`040?ooo`0305L0
o`00;ol0E`3o00<0E`3o00D0oooo0?l0f@3oool0o`3I0?ooo`060?l0f@h0oooo00<0E`3o0?ooo`3o
ool03@3oool00`3j0?l0oooo0?ooo`0>0?ooo`030?l0f@3oool0iP3o00@0iP3o00<0oooo0>H0o`3o
ool01`3oool00`000000oooo0?ooo`040?ooo`040?l0C@3oool0oooo0?ooo`80o`1=7P3oool20?l0
[@`0oooo00<000000?ooo`3oool02@3oool000@0oooo00<000000?ooo`3oool0;@3oool20?l0CA80
oooo0P3o02H90?ooo`80o`0V00@0oooo00000000000000004`3oool00`0:0?l0oooo0?ooo`0B0?oo
o`030?X0o`3oool0oooo00@0nP3o3@3oool205L0o`040?ooo`2f0?l0oooo0;H0o`P0oooo00<00000
05L0o`3oool00P3oool00`2f0?l0oooo0;H0o`030?ooo`80]P3o00<0oooo08D0o`3oool00P3oool3
000_o`T0oooo00<006Ko0?ooo`3oool0303oool01000cOl0oooo0?ooo`3oool305L0o`h0oooo100:
0?l80?ooo`03000_o`3oool0oooo00<0oooo0P1G0?l00`00;ol0E`3o0?ooo`0305L0o`80o`3I0`3o
ool20?l0f@030?ooo`3o0=T0o`3I00h0oooo00<0E`3o0?ooo`3oool03@3oool20?X0o`d0oooo1@3V
0?l0103oool0o`3I0?l0f@3V0?l90?ooo`030000003oool0oooo00@0oooo0P3o04d20?ooo`<0o`1=
7`3oool20?l0[@X0oooo00<000000?ooo`3oool02@3oool000@0oooo00<000000?ooo`3oool0:P3o
ool30?l0CA80oooo0P3o02H;0?ooo`<0000000<0o`0V0?ooo`3oool04P3oool00`0:0?l0oooo0?oo
o`0A0?ooo`80nP3o0`3oool40?X0o``0oooo00<0E`3o0?ooo`2f0?l00`2f0?l90?ooo`0305L0o`3o
ool0oooo00<0oooo0P2f0?l30?ooo`80]P3o00<0oooo08D0o`3oool00P00;ol00`3oool002oo000_
o`090?ooo`03001Vo`3oool0oooo00`0oooo00P00<go0?ooo`3oool0E`3o0?ooo`1G0?l0oooo05L0
o`h0oooo0P0:0?l90?ooo`03000_o`3oool0oooo00@0oooo0`1G0?l0103oool0E`3o05L0o`3oool2
0?l0f@D0oooo0P3o0=T@0?ooo`0305L0o`3oool0oooo00h0oooo00<0nP3o0?ooo`3oool02P3oool4
0>H0o`@0oooo00<0iP3o0?l0f@3oool0203oool00`000000oooo0?ooo`040?ooo`030?l0C@3oool0
o`1=00<0oooo00<0o`1=0?ooo`3oool07P3oool20?l0[@P0oooo00<000000?ooo`3oool02@3oool0
00@0oooo00<000000?ooo`3oool08`3oool30?l00080oooo0P3o04dC0?ooo`80o`0V2@3oool40000
01L0oooo00<02P3o0?ooo`3oool04@3oool00`3j0?l0oooo0?ooo`050?ooo`80R`3o0`3oool30?l0
f@D0oooo00D0E`3o0?ooo`2f0?l0oooo0;H0o`0;0?ooo`0305L0o`3oool0oooo0080oooo00<0]P3o
0?ooo`3oool00P2f0?l00`3oool0]P3o0?ooo`020?ooo`05000_o`3oool002oo000_o`3oool00P00
;ol80?ooo`03001Vo`3oool0oooo00H0oooo00<0]P3o0?ooo`3oool00`3oool02000cOl0oooo0?oo
o`1G0?l0oooo05L0o`3oool0E`3o3P3oool00`0:0?l0oooo0?ooo`090?ooo`03000_o`3oool0oooo
00<0oooo1@1G0?l30?ooo`040?l0f@3oool0oooo0?ooo`80o`3I0P3oool20?l0f@l0oooo0P1G0?l?
0?ooo`030?X0o`3oool0oooo00X0oooo00@0iP3o0?ooo`3V0?l0iP3o0`3oool00`3V0?l0oooo0?l0
f@090?ooo`030000003oool0oooo00<0oooo0`3o04d40?ooo`030?l0C@3oool0oooo01l0oooo00<0
o`2]0?ooo`3oool01@3oool00`000000oooo0?ooo`090?ooo`00103oool00`000000oooo0?ooo`0S
0?ooo`T0o`003P3oool30?l09PP0oooo0`00000J0?ooo`0300X0o`3oool0oooo0100oooo0P3j0?l6
0?ooo`@0R`3o0`3oool00`3o0=T0oooo0?l0f@040?l0f@<0oooo00<0]P3o0?ooo`3oool02P3oool0
0`1G0?l000000?ooo`020?ooo`030;H0o`3oool0oooo00<0oooo0P2f0?l40?ooo`H002oo203oool0
0`00I_l0oooo0?ooo`050?ooo`<0]P3o103oool00`00cOl0oooo05L0o`0605L0o`d0oooo00<02P3o
0?ooo`3oool02@3oool00`00;ol0oooo0?ooo`030?ooo`D0E`3o0`3oool40?l0f@H0oooo0P3o0=T?
0?ooo`0305L0o`3oool0oooo00d0oooo0P3j0?l:0?ooo`030>H0o`3oool0iP3o00<0iP3o00@0oooo
0>H0o`3oool0oooo0P3o0=T80?ooo`030000003oool0oooo00<0oooo00<0o`1=0?ooo`3oool0103o
ool20?l0CBL0oooo00<000000?ooo`3oool02@3oool000@0oooo00<000000?ooo`3oool08`3oool0
0`3o0000oooo0?ooo`090?l000T0oooo0P3o02H80?ooo`<000006`3oool200X0oa40oooo0P3j0?l6
0?ooo`<0R`3o00<0oooo08/0o`2;0?l00`3oool00`3o0=T0oooo0?ooo`020?ooo`D0o`3I3@3oool0
1@1G0?l000000?ooo`3oool0]P3o00d0oooo1@00;ol70?ooo`03001Vo`3oool0oooo00@0oooo0`2f
0?l00`3oool0]P3o0;H0o`030?ooo`03003=o`1G0?l0E`3o0080oooo00<0E`3o0?ooo`3oool00P1G
0?l50?ooo`0308/0o`3oool0oooo00@0oooo00<02P3o0?ooo`3oool02@3oool00`00;ol0oooo0?oo
o`030?ooo`<0E`3o0P3oool01@1G0?l0oooo0?ooo`3oool0o`3I00X0oooo0P3o0=T80?ooo`@0R`3o
0P3oool00`1G0?l0oooo0?ooo`0>0?ooo`030?X0o`3oool0oooo00L0oooo0P3V0?l20?ooo`<0iP3o
1@3oool20?l0f@L0oooo00<000000?ooo`3oool02`3oool00`3o04d0oooo0?ooo`0T0?ooo`030000
003oool0oooo00T0oooo00030?ooo`030000003oool0oooo02D0oooo00@0o`000?ooo`3oool0o`00
0`3oool30?l000P0oooo0P3o02H70?ooo`<000005@3oool:0?l0fA40oooo00<0nP3o0?ooo`3oool0
103oool308/0o`80oooo0`2;0?l30?ooo`030?l0f@3oool0oooo00<0oooo103o0=T<0?ooo`0305L0
o`3oool000000080]P3o3P3oool01000;ol0oooo0?ooo`00;ol80?ooo`03001Vo`3oool0oooo00<0
oooo0P2f0?l20?ooo`<0]P3o0`3oool01`00cOl0oooo05L0o`1G0?l0oooo05L0o`3oool00P1G0?l4
0?ooo`80R`3o00<0oooo08/0o`3oool0103oool00`0:0?l0oooo0?ooo`0:0?ooo`03000_o`3oool0
oooo00P0oooo00<0E`3o0?ooo`3oool03@3oool20?l0f@H0oooo0P2;0?l00`3oool0R`3o08/0o`03
08/0o`P0oooo0`3o07H50?ooo`030?X0o`3oool0oooo00H0oooo0P3V0?l30?ooo`@0iP3o1@3oool2
0?l0f@D0oooo00<000000?ooo`3oool0303oool20?l0CBD0oooo00<000000?ooo`3oool0203oool0
00<0oooo00<000000?ooo`3oool09@3oool01@3o0000oooo0?ooo`3o0000oooo00D0o`001@3oool3
0?l09PD0oooo1000000H0?ooo`030?l0f@3oool0o`3I00L0o`3I3`3oool20?X0o`P0oooo00@0R`3o
0?ooo`3oool0oooo0P2;0?l01@3oool0R`3o0?ooo`3oool0o`3I00@0oooo103o0=T=0?ooo`0305L0
o`3oool0]P3o00l0oooo00<002oo0?ooo`3oool02P3oool00`00I_l0oooo0?ooo`040?ooo`030;H0
o`3oool0oooo0080]P3o00D0oooo0;H0o`3oool0oooo003=o`030?ooo`<0E`3o1@3oool208/0o`80
02oo00<0oooo08/0o`3oool00P3oool00`0:0?l0oooo0?ooo`0;0?ooo`03000_o`3oool0oooo00T0
oooo00<0E`3o0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`040?ooo`<0R`3o00<0oooo08/0o`2;
0?l02@3oool20?l0MP030?ooo`3o07H0o`1f0080o`1f0P3oool20?X0o`L0oooo00@0iP3o0?ooo`3V
0?l0iP3o103oool20>H0o`D0oooo00<0o`3I0?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?oo
o`030?l0C@3oool0oooo0280oooo00<000000?ooo`3oool0203oool000<0oooo00<000000?ooo`3o
ool09@3oool00`3o0000oooo0?l000020?l000040?ooo`3o0000oooo0?l000@0oooo0P3o02H50?oo
o`<000007@3oool0103o0=T0oooo0?l0f@3oool40?l0f@l0oooo00<0nP3o0?ooo`3oool02@3oool3
08/0o`040?ooo`2;0?l0R`3o08/0o`<0oooo00<0o`3I0?ooo`3o0=T00`3o0=T00`3oool0o`3I0?oo
o`0;0?ooo`0405L0o`3oool0]P3o000000h0oooo00<002oo0?ooo`3oool0103oool00`3j0?l0oooo
0?ooo`0<0?ooo`<0]P3o0`3oool00`2f0?l0oooo003=o`030?ooo`0305L0o`3oool0oooo00<0oooo
1P2;0?l00`00;ol0R`3o0?ooo`020?ooo`0300X0o`3oool0oooo00`0oooo00<002oo0?ooo`3oool0
2@3oool00`1G0?l0oooo0?ooo`0D0?ooo`0308/0o`3oool0oooo0080R`3o2`3oool30?l0MP<0oooo
0`3o07H00`3oool0nP3o0?ooo`050?ooo`80iP3o203oool20>H0o`@0oooo0P3o0=T40?ooo`030000
003oool0oooo00d0oooo00<0o`1=0?ooo`3oool08@3oool00`000000oooo0?ooo`080?ooo`000`3o
ool00`000000oooo0?ooo`0U0?ooo`80o`000P3oool20?l00080oooo00<0o`000?ooo`3oool00P3o
02H40?ooo`<00000803oool0203o0=T0oooo0?ooo`3o0=T0oooo0?l0f@3oool0o`3I3@3oool20?X0
o`h0oooo0P2;0?l00`3oool0R`3o08/0o`030?ooo`80o`3I00H0oooo0?l0f@3oool0o`3I0;H0o`3o
0=T40?ooo`80Q@3o1P3oool0101G0?l0]P3o0?ooo`00000>0?ooo`03000_o`3oool0oooo00<0oooo
0P3j0?l>0?ooo`<0]P3o0P3oool0102f0?l0oooo0?ooo`00cOl30?ooo`0305L0o`3oool0oooo0080
oooo0P2;0?l20?ooo`80R`3o00@002oo08/0o`2;0?l0R`3o0P3oool00`0:0?l0oooo0?ooo`0<0?oo
o`03000_o`3oool0oooo00X0oooo00<0E`3o0?ooo`3oool0503oool208/0o`030?ooo`2;0?l0oooo
00X0oooo00@0o`1f0?ooo`3oool0o`1f0`3oool01@3o07H0oooo0?ooo`3oool0nP3o0140oooo00<0
iP3o0?ooo`3oool00`3oool20?l0f@<0oooo00<000000?ooo`3oool03@3oool20?l0CB40oooo00<0
00000?ooo`3oool0203oool000<0oooo00<000000?ooo`3oool08`3oool20?l000030?ooo`3o0000
oooo0080o`000P3oool0103o0000oooo0?l09P3o02H30?ooo`<00000903oool40?l0f@030?ooo`3o
0=T0oooo00`0oooo00<0nP3o0?ooo`3oool03@3oool0102;0?l0oooo08/0o`2;0?l40?ooo`@0o`3I
0`3oool20?l0f@030?ooo`250?l0Q@3o00<0Q@3o1@3oool01@1G0?l0oooo0?ooo`3oool0000000d0
oooo00<002oo0?ooo`3oool00`3oool40?X0o`d0oooo1@2f0?l30?ooo`05003=o`3oool0oooo0?oo
o`1G0?l01@3oool01P2;0?l0oooo0?ooo`2;0?l002oo08/0o`8002oo0P2;0?l00`3oool02P3o0?oo
o`0>0?ooo`03000_o`3oool0oooo00T0oooo00<0E`3o0?ooo`3oool0503oool01@2;0?l0oooo08/0
o`3oool0R`3o00/0oooo00H0o`1f0?ooo`3oool0o`1f0?ooo`3o07H50?ooo`80nP3o403oool20>H0
o`D0oooo00D0o`3I0?ooo`3oool0oooo0000000@0?ooo`030?l0C@3oool0oooo01h0oooo00<00000
0?ooo`3oool0203oool000<0oooo00<000000?ooo`3oool0803oool30?l000<0oooo0P3o0000103o
ool0o`000?ooo`3oool20?l09P80oooo0`00000V0?ooo`80o`3I00D0oooo0?l0f@3o0=T0oooo0?l0
f@0;0?ooo`80nP3o403oool00`2;0?l0oooo0?ooo`030?ooo`80o`3I00<0oooo0?l0f@3o0=T00`3o
ool00`2f0?l0o`3I08D0o`0208D0o`040?ooo`250?l0Q@3o08D0o`D0oooo00@0E`3o0?ooo`3oool0
00003P3oool01000;ol0oooo0?ooo`3oool60?X0o`d0oooo00<0]P3o0?ooo`2f0?l01@3oool01@00
cOl0oooo0?ooo`3oool0E`3o00H0oooo00H0R`3o000_o`2;0?l002oo08/0o`00;ol208/0oa80oooo
00<002oo0?ooo`3oool01P3oool01@0:0?l0oooo0?ooo`3oool0E`3o00l0oooo102f0?l30?ooo`05
08/0o`3oool0oooo0?ooo`2;0?l02P3oool0103o07H0oooo0?ooo`3oool20?l0MPL0oooo00<0nP3o
0?ooo`3oool03`3oool20>H0o`@0oooo0P3o0=T00`3oool000000?ooo`0@0?ooo`80o`1=7P3oool0
0`000000oooo0?ooo`080?ooo`000`3oool00`000000oooo0?ooo`0N0?ooo`80o`001P3oool0103o
0000oooo0?ooo`3oool20?l000@000009`3oool20?l0f@80oooo103o0=T;0?ooo`030?X0o`3oool0
oooo00l0oooo00<0R`3o0?ooo`3oool00P3oool20?l0f@D0oooo0`3o0=T0103oool0o`3I08D0o`25
0?l20?ooo`<0Q@3o103oool01@1G0?l0oooo0?ooo`3oool0000000L0oooo00<0iP3o0?ooo`3oool0
0`3oool01000;ol0oooo0?ooo`3oool30?X0o`050?ooo`3j0?l0nP3o0?ooo`3j0?l02`3oool00`2f
0?l0oooo0?ooo`060?ooo`05003=o`3oool0oooo0?ooo`1G0?l01P3oool01P2;0?l002oo08/0o`00
;ol0oooo08/0oaD0oooo00<002oo0?ooo`3oool01@3oool300X0o`80oooo00<0E`3o0?ooo`3oool0
1`3oool70;H0o`030?ooo`2f0?l0oooo00L0oooo0P2;0?l90?ooo`060?l0MP3oool0oooo0?l0MP3o
ool0o`1f6P3oool20>H0o`@0oooo0P3o0=T00`000000oooo0?ooo`0@0?ooo`030?l0C@3oool0oooo
01/0oooo00<000000?ooo`3oool0203oool00080oooo00<000000?ooo`3oool07@3oool20?l000T0
oooo0P3o0003000002T0oooo0P3o0=T60?ooo`80o`3I103oool30?l0C@80oooo0P3j0?lB0?ooo`03
08/0o`3oool0oooo0080o`3I2P3oool20?l0f@0608D0o`3oool0Q@3o08D0o`3oool0Q@3o1@3oool0
1@1G0?l0oooo0?ooo`3oool0000000H0oooo00@0iP3o0?ooo`3V0?l0iP3o0`3oool00`00;ol0oooo
0?ooo`020?X0o`<0oooo00@0nP3o0?ooo`3j0?l0nP3o2@3oool00`1G0?l0oooo0;H0o`0<0?ooo`03
05L0o`3oool0oooo00D0oooo1@2;0?lE0?ooo`03000_o`3oool0oooo00D0oooo100:0?l20?ooo`03
05L0o`3oool0oooo00H0oooo102f0?l40?ooo`030;H0o`3oool0oooo00P0oooo00<0R`3o0?ooo`3o
ool01P3oool00`3o07H0oooo0?l0MP030?ooo`030?l0MP3oool0oooo01T0oooo00<0iP3o0?ooo`3o
ool00`3oool00`3o0=T000000?ooo`0A0?ooo`030?l0C@3oool0oooo01X0oooo00<000000?ooo`3o
ool0203oool00080oooo00<000000?ooo`3oool06P3oool30?l000X0oooo0`0000020?l002T0oooo
00<0o`3I0?ooo`3oool0303oool00`3o04d0oooo0?l0C@060?l0C@l0oooo00@0R`3o0?ooo`3o0=T0
o`3I3`3oool308D0o`030?ooo`250?l0oooo00<0oooo00<0E`3o0?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`030>H0o`3oool0iP3o0080iP3o0P3oool00`00;ol0oooo0?ooo`020?ooo`80
nP3o00<0oooo0?X0o`3j0?l00`3oool0103j0?l0oooo00X0o`0:0?l40?ooo`80E`3o00<0]P3o0?oo
o`3oool02`3oool00`1G0?l0oooo0?ooo`060?ooo`0508/0o`3oool0oooo000_o`2;0?l05@3oool0
0`00;ol0oooo0?ooo`030?ooo`0400X0o`3oool02P3o0?ooo`<02P3o00<0oooo05L0o`3oool01P3o
ool0102f0?l0oooo0;H0o`2f0?l40?ooo`030;H0o`3oool0oooo00T0oooo00<0R`3o0?ooo`3oool0
1P3oool00`3o07H0oooo0?ooo`030?ooo`030?l0MP3oool0oooo01T0oooo0P3V0?l50?ooo`030000
003oool0oooo0100oooo0P3o04dK0?ooo`030000003oool0oooo00L0oooo00020?ooo`030000003o
ool0oooo01P0oooo0P3o000:0?ooo`<00000;03oool20?l0fA00oooo00<0o`1=0?ooo`3oool0203o
04d;0?ooo`0308/0o`3o0=T0o`3I0140oooo00<0Q@3o0?ooo`250?l00P250?l40?ooo`0305L0o`3o
ool0oooo0080oooo00<000000?ooo`3oool00P3oool30>H0o`060?ooo`3V0?l0iP3o0>H0o`3oool0
02oo1P3oool30?X0o`030?ooo`3j0?l0nP3o0080oooo1@0:0?l405L0o`d0oooo00<0E`3o0?ooo`3o
ool02@3oool00`00;ol0oooo08/0o`0D0?ooo`03000_o`3oool0oooo00<0oooo00@02P3o0?ooo`0:
0?l02P3o0P3oool200X0o`030?ooo`1G0?l0nP3o00D0oooo00<0]P3o0?ooo`2f0?l00P2f0?l20?oo
o`030;H0o`3oool0oooo00/0oooo00<0R`3o0?ooo`3oool0303oool20?l0MPl0oooo1@3o0:d70?oo
o`80iP3o103oool00`000000oooo0?ooo`050?ooo`D0o`0V1`3oool00`3o04d0oooo0?ooo`0H0?oo
o`030000003oool0oooo00L0oooo00020?ooo`030000003oool0oooo01H0oooo0P3o00090?ooo`<0
0000;@3oool20?l0fA80oooo00D0o`1=0?ooo`3oool0oooo0?l0C@020?ooo`<0o`1=303oool00`3o
0=T0oooo0?ooo`0@0?ooo`0408D0o`3oool0oooo0?ooo`80Q@3o0`3oool00`1G0?l0oooo0?ooo`03
0?ooo`040000003oool0oooo0?ooo`80iP3o0P3oool20>H0o`030?ooo`3V0?l002oo00P0oooo0`3j
0?l30?ooo`0300X0o`3oool0oooo00@02P3o0`1G0?l=0?ooo`0305L0o`3oool0oooo00X0oooo00<0
02oo08/0o`3oool06@3oool400X0o`80oooo00D02P3o0?ooo`3oool0nP3o05L0o`020?X0o`@0oooo
00@0]P3o0?ooo`3oool0oooo0`2f0?l>0?ooo`0308/0o`3oool0oooo00d0oooo00<0o`1f0?ooo`3o
ool0303oool;0?l0[@<0oooo0P3V0?l20?ooo`030000003oool0oooo00D0oooo2P3o02H30?ooo`80
o`1=603oool00`000000oooo0?ooo`070?ooo`000P3oool00`000000oooo0?ooo`0C0?ooo`<0o`00
1`3oool4000002l0oooo00<0o`3I0?ooo`3oool04P3oool0103o04d0oooo0?ooo`3oool60?l0C@X0
oooo0P3o0=TC0?ooo`0308D0o`3oool0oooo00H0oooo00<0E`3o0?ooo`3oool00`3oool00`000000
oooo0?ooo`020?ooo`030>H0o`3oool0oooo0080iP3o00<0oooo000_o`3V0?l01`3oool00`3j0?l0
oooo0?ooo`040?ooo`0400X0o`3oool02P3o0?ooo`@02P3o00<0E`3o0?ooo`1G0?l0303oool00`1G
0?l0oooo0?ooo`0:0?ooo`03000_o`3oool0R`3o01T0oooo0P0:0?l0103oool02P3o00X0o`0:0?l4
0?ooo`030?X0o`1G0?l0oooo00<0nP3o00<0oooo0;H0o`3oool00`3oool20;H0o`l0oooo0P2;0?l>
0?ooo`030?l0MP3oool0oooo00`0oooo00<0o`2]0?ooo`3o0:d00P3oool40?l0[@H0oooo00@0iP3o
0?ooo`3oool000001`3oool00`3o02H0oooo0?l09P030?ooo`<0o`0V1@3oool00`3o04d0oooo0?oo
o`0E0?ooo`030000003oool0oooo00L0oooo00020?ooo`030000003oool0oooo0140oooo0P3o0007
0?ooo`<00000<@3oool20?l0fAH0oooo00<0o`1=0?ooo`3o04d00`3o04d00`3oool0o`1=0?ooo`08
0?ooo`80o`3I00<0oooo08/0o`3oool04@3oool00`250?l0oooo0?ooo`030?ooo`030?l0f@3oool0
oooo00L0oooo00<000000?ooo`3oool00`3oool20>H0o`040?ooo`3V0?l0oooo000_o`P0oooo00<0
nP3o0?ooo`3oool00`3oool300X0o`090?ooo`0:0?l0E`3o00X0o`1G0?l02P3o05L0o`3oool0E`3o
00`0oooo00<0E`3o0?ooo`3oool02P3oool00`00;ol0oooo08/0o`030?ooo`0308/0o`3oool0oooo
01D0oooo0`0:0?l50?ooo`030?X0o`1G0?l0nP3o00<0oooo00<0nP3o0;H0o`3oool00P3oool50;H0
o`l0oooo00<0R`3o0?ooo`3oool0303oool00`3o07H0oooo0?ooo`0;0?ooo`80o`2]00@0oooo0?l0
[@3oool0o`2]0P3oool00`3o0:d0oooo0?ooo`080?ooo`030000003oool0oooo00@0oooo00@0o`0V
0?ooo`3oool0o`0V0`3oool00`3o02H0oooo0?ooo`050?ooo`030?l0C@3oool0oooo01@0oooo00<0
00000?ooo`3oool01`3oool000030?ooo`000000oooo0140oooo0P3o00060?ooo`<00000<P3oool2
0?l0fAP0oooo0P3o04d20?ooo`040?l0C@3oool0oooo0?l0C@<0oooo0P2f0?l20?ooo`80o`3I0P3o
ool00`2;0?l0oooo0?ooo`0@0?ooo`0308D0o`3oool0oooo0080oooo0`3o0=T90?ooo`030000003o
ool0oooo00@0oooo0`3V0?l00`00;ol0oooo0?ooo`070?ooo`030?X0o`3oool0oooo00<0oooo00H0
2P3o0?ooo`3oool0oooo00X0o`3oool200X0o`D0E`3o2P3oool00`1G0?l0oooo0?ooo`0;0?ooo`05
000_o`3oool0oooo08/0o`3oool00`2;0?lI0?ooo`0300X0o`3oool0oooo0080oooo0P3j0?l01@1G
0?l0nP3o0?ooo`3oool0nP3o00@0]P3o1@3oool00`2f0?l0oooo0?ooo`0=0?ooo`0308/0o`3oool0
oooo00`0oooo0P3o07H;0?ooo`040?l0[@3oool0o`2]0?ooo`80o`2]00<0oooo0?l0[@3oool02`3o
ool00`000000oooo0?ooo`040?ooo`030?l09P3oool0oooo00@0o`0V203oool20?l0CA@0oooo00<0
00000?ooo`3oool01`3oool000030?ooo`000000oooo00h0oooo0`3o00050?ooo`<00000=03oool0
0`3o0=T0oooo0?ooo`0F0?ooo`80o`1=00<0oooo0?l0C@3o04d00P3o04d0103oool0o`1=0?ooo`3o
ool40;H0o`80o`3I103oool00`2;0?l0oooo0?ooo`0?0?ooo`0308D0o`3oool0oooo0080oooo1@3o
0=T80?ooo`030000003oool0oooo00<0oooo00D0iP3o0?ooo`3V0?l0oooo000_o`080?ooo`030?X0
o`3oool0oooo00D0oooo0`0:0?l20?ooo`802P3o0`1G0?l<0?ooo`0305L0o`3oool0oooo00`0oooo
00P002oo0?ooo`3oool0R`3o0?ooo`2;0?l0oooo08/0oaP0oooo00<02P3o0?ooo`3oool00`3oool0
0`3j0?l0oooo05L0o`020?X0o`/0oooo00<0]P3o0?ooo`3oool03@3oool00`2;0?l0oooo0?ooo`0=
0?ooo`030?l0MP3oool0oooo00T0oooo00D0o`2]0?ooo`3o0:d0o`2]0?ooo`020?l0[@d0oooo00<0
00000?ooo`3oool00`3oool0103o02H0oooo0?ooo`3oool20?l09P/0oooo00<0o`1=0?ooo`3oool0
4@3oool00`000000oooo0?ooo`070?ooo`0000<0oooo0000003oool0303oool20?l000@0oooo1000
000e0?ooo`80o`3I5`3oool20?l0C@<0oooo00H0o`1=0?ooo`3oool0o`1=0?ooo`3o04d20;H0o`04
0?ooo`2f0?l0]P3o0?l0f@D0oooo00<0R`3o0?ooo`3oool03`3oool010250?l0oooo0?ooo`3oool3
0?l0f@040?ooo`3o0=T0o`3I0?l0f@P0oooo00<000000?ooo`3oool00P3oool01@3j0?l0iP3o0?oo
o`3oool002oo00T0oooo00<0nP3o0?ooo`3oool01`3oool200X0o`030?ooo`0:0?l0E`3o00l0oooo
00<0E`3o0?ooo`3oool0303oool00`00;ol0oooo0?ooo`0508/0o`040?ooo`0:0?l02P3o00X0oaD0
oooo00<02P3o0?ooo`3oool00P3oool30?X0o`0305L0o`3j0?l0oooo00/0oooo0P2f0?l>0?ooo`03
08/0o`3oool0oooo00d0oooo00<0o`1f0?ooo`3oool0203oool00`3o0:d0oooo0?l0[@020?ooo`80
o`2]3@3oool00`000000oooo0?ooo`040?ooo`050?l09P3oool0o`0V0?l09P3oool00P3o02HN0?oo
o`030000003oool0oooo00H0oooo00000`3oool000000?ooo`0:0?ooo`80o`000`3oool3000003P0
oooo00<0o`3I0?ooo`3oool05@3oool20?l0C@H0oooo0P3o04d00`3oool0o`1=0;H0o`020?ooo`03
0;H0o`3oool0]P3o00H0oooo00<0R`3o0?ooo`3oool03`3oool00`250?l0oooo0?ooo`020?l0f@<0
oooo103o0=T70?ooo`030000003oool0oooo00@0R`3o0P3oool00`00;ol0oooo0?ooo`070?ooo`03
0?X0o`3oool0oooo00H0oooo00<02P3o0?ooo`3oool00P0:0?l00`1G0?l0oooo0?ooo`0=0?ooo`03
05L0o`3oool0oooo00`0oooo00L002oo0?ooo`2;0?l0R`3o0?ooo`2;0?l0oooo0080R`3o0P0:0?l0
0`3oool02P3o00X0o`0200X0oa40oooo00<02P3o0?ooo`3oool00`3oool20?X0o`030?ooo`1G0?l0
oooo00d0oooo00<0]P3o0?ooo`3oool0303oool208/0o`h0oooo0P3o07H90?ooo`<0o`2]00<0oooo
0?l0[@3oool00P3o0:d<0?ooo`030000003oool0oooo00<0oooo00<0o`0V0?ooo`3o02H0103oool0
0`3o02H0oooo0?ooo`0K0?ooo`030000003oool0oooo00H0oooo00000`3oool000000?ooo`080?oo
o`80o`000P3oool3000003T0oooo0P3o0=TF0?ooo`80o`1=2P3oool20?l0C@030;H0o`3oool0]P3o
0080oooo00<0]P3o0?ooo`3oool00`3oool00`2;0?l0oooo0?ooo`0?0?ooo`0308D0o`3oool0oooo
0080oooo00<0o`3I0?ooo`3oool00P3o0=T20?ooo`030?l0f@3oool0oooo00<0oooo1@2;0?l01P3o
ool0R`3o08/0o`2;0?l0oooo000_o`X0oooo00<0nP3o0?ooo`3oool01P3oool00`0:0?l0oooo0?oo
o`020?ooo`0305L0o`3oool0oooo00d0oooo00<0E`3o0?ooo`3oool03@3oool01@00;ol0oooo0?oo
o`3oool0R`3o00<0oooo100:0?l208D0o`0300X0o`3oool0oooo0100oooo00<02P3o0?ooo`3oool0
0P3oool01@3j0?l0oooo0?ooo`3oool0nP3o00h0oooo0P2f0?l>0?ooo`0308/0o`3oool0oooo00d0
oooo00<0o`1f0?ooo`3oool01P3oool40?l0[@@0oooo00<0o`2]0?ooo`3oool02P3oool00`000000
oooo0?ooo`030?ooo`80o`0V1@3oool20?l09Q/0oooo00<000000?ooo`3oool01P3oool000030?oo
o`000000oooo00T0oooo0`00000e0?ooo`H0o`0V00<0o`3I0?ooo`3oool0503oool20?l0C@l0oooo
0P2f0?l20?ooo`030;H0o`3oool0oooo00<0oooo00<0R`3o0?ooo`3oool03P3oool00`250?l0oooo
0?ooo`040?ooo`@0o`3I0`3oool00`3o0=T0oooo0?ooo`020?ooo`0308/0o`3oool0000000@0R`3o
00<0nP3o08/0o`3oool02P3oool00`3j0?l0oooo0?ooo`060?ooo`0300X0o`3oool0oooo00<0oooo
00<0E`3o0?ooo`3oool03@3oool00`1G0?l0oooo0?ooo`0=0?ooo`06000_o`2;0?l0R`3o0?ooo`2;
0?l0oooo0P2;0?l300X0o`80Q@3o00<0oooo00X0o`3oool04@3oool00`0:0?l0oooo0?ooo`070?oo
o`030?X0o`3oool0oooo00d0oooo00<0]P3o0?ooo`3oool0303oool00`2;0?l0oooo0?ooo`0=0?oo
o`030?l0MP3oool0oooo00h0oooo0P3o0:d;0?ooo`030000003oool0oooo0080oooo00<0o`0V0?oo
o`3oool01P3oool00`3o02H0oooo0?ooo`0H0?ooo`030000003oool0oooo00H0oooo00000`000000
oooo0?ooo`060?ooo`<00000>03oool01P3o02H0oooo0?l09P3o02H0o`3I0?ooo`H0o`0V3`3oool2
0?l0CA40oooo00@0]P3o0?ooo`2f0?l0]P3o1@3oool00`2;0?l0oooo0?ooo`0>0?ooo`0308D0o`3o
ool0oooo00L0oooo0P3o0=T00`3oool0o`3I0?l0f@060?ooo`0308/0o`3j0?l0oooo0080R`3o00<0
nP3o0?ooo`2;0?l02`3oool00`3j0?l0oooo0?ooo`060?ooo`0300X0o`3oool0oooo00<0oooo00<0
E`3o0?ooo`3oool01@3oool00`3o0=T0oooo0?ooo`050?ooo`0305L0o`3oool0oooo00d0oooo00<0
02oo0?ooo`3oool00`2;0?l02@3oool02P3o00X0o`3oool0Q@3o00X0o`250?l02P3o0?ooo`0208D0
oa40oooo00<02P3o0?ooo`3oool01`3oool00`3j0?l0oooo0?ooo`0=0?ooo`80]P3o5@3oool50?l0
C@<0oooo00<0o`1f0?ooo`3oool03`3oool00`3o0:d0oooo0?ooo`090?ooo`030000003oool0oooo
00/0oooo00<0o`0V0?ooo`3oool05`3oool00`000000oooo0?ooo`060?ooo`0000<000000?ooo`3o
ool00P3oool4000003`0oooo00<0o`0V0?ooo`3oool0203o02H=0?ooo`80o`1=4P3oool01@2f0?l0
oooo0?ooo`3oool0]P3o00D0oooo00<0R`3o0?ooo`3oool03@3oool00`250?l0oooo0?ooo`070?oo
o`040?l0f@3oool0o`3I0?l0f@L0oooo00D0nP3o08/0o`3j0?l0R`3o0?X0o`0308/0o`030?X0o`3o
ool0oooo00T0oooo00<0nP3o0?ooo`3oool01@3oool00`0:0?l0oooo0?ooo`030?ooo`0305L0o`3o
ool0oooo00D0oooo0P3o0=TG0?ooo`05000_o`3oool0oooo0?ooo`2;0?l00P3oool200X0o`030?oo
o`250?l0Q@3o00802P3o10250?l@0?ooo`0300X0o`3oool0oooo00P0oooo00<0nP3o0?ooo`3oool0
1P3oool50?l0f@<0oooo00<0]P3o0?ooo`3oool04P3oool20?l0C@030?ooo`3o04d0o`1=00@0o`1=
0P3o07H@0?ooo`030?l0[@3oool0oooo00P0oooo00<000000?ooo`3oool0303oool20?l09QL0oooo
00<000000?ooo`3oool01P3oool000030000003oool0000000800000@03oool0103o02H0oooo0?oo
o`3oool30?l09P030?ooo`3o02H0o`0V00`0oooo0P3o04dC0?ooo`030;H0o`3oool0oooo00L0oooo
00<0R`3o0?ooo`3oool03P3oool00`250?l0oooo0?ooo`070?ooo`030?l0f@3oool0oooo00T0oooo
0P2;0?l00`3oool0R`3o0?X0o`0208/0o`030?X0o`3oool0oooo00P0oooo00<0nP3o0?ooo`3oool0
1P3oool00`0:0?l0oooo0?ooo`030?ooo`0305L0o`3oool0oooo00@0oooo103o0=TG0?ooo`04000_
o`3oool0oooo08/0o`80oooo00@02P3o0?ooo`3oool0Q@3o0`0:0?l00`3oool0Q@3o08D0o`0B0?oo
o`0300X0o`3oool0oooo00P0oooo00<0nP3o0?ooo`3oool01@3oool90?l0f@030;H0o`3o0=T0oooo
0180oooo0`3o04d30?ooo`<0o`1=00<0oooo0?l0MP3oool03`3oool20?l0[@T0oooo00<000000?oo
o`3oool03@3oool00`3o02H0oooo0?ooo`0D0?ooo`030000003oool0oooo00H0oooo0002000004<0
oooo00<0o`0V0?ooo`3oool00P3o02H20?ooo`030?l09P3oool0o`0V00X0oooo0P3o04dD0?ooo`03
0;H0o`3oool0oooo01P0oooo00<0Q@3o0?ooo`3oool0203oool00`3o0=T0oooo0?ooo`090?ooo`<0
R`3o00@0nP3o0?ooo`2;0?l0R`3o0P3j0?l90?ooo`030?X0o`3oool0oooo00D0oooo00<02P3o0?oo
o`3oool0103oool00`1G0?l0oooo0?ooo`020?ooo`H0o`3I2@3oool00`3j0?l0oooo0?ooo`0;0?oo
o`04000_o`3oool0oooo08/0o`80oooo100:0?l010250?l0oooo00X0o`250?lD0?ooo`0300X0o`3o
ool0oooo00T0oooo00<0nP3o0?ooo`3oool01@3oool30?l0f@80oooo103o0=T20;H0oa80oooo0P3o
04d0103oool0o`1=0?ooo`3oool20?l0C@<0oooo00<0o`1f0?ooo`3oool03`3oool00`3o0:d0oooo
0?ooo`070?ooo`030000003oool0oooo00d0oooo0P3o02HD0?ooo`030000003oool0oooo00H0oooo
00000`3oool00000000000130?ooo`80o`0V0P3oool20?l09P030?ooo`3o02H0oooo00P0oooo0P3o
04dE0?ooo`030;H0o`3oool0oooo01P0oooo00<0Q@3o0?ooo`3oool0203oool00`3o0=T0oooo0?oo
o`090?ooo`0308/0o`3oool0R`3o0080R`3o0P3j0?l00`2;0?l0nP3o0?X0o`090?ooo`030?X0o`3o
ool0oooo00D0oooo00<02P3o0?ooo`3oool0103oool0101G0?l0oooo0?ooo`3oool30?l0f@050?oo
o`3o0=T0o`3I0?ooo`3o0=T00P3oool00`00ROl0oooo0?ooo`020?ooo`<0nP3o303oool01000;ol0
oooo0?ooo`2;0?l40?ooo`D0Q@3o00<02P3o0?ooo`3oool04`3oool00`0:0?l0oooo0?ooo`090?oo
o`030?X0o`3oool0oooo00@0oooo00H0o`3I0?ooo`3o0=T0o`3I0?ooo`3o0=T20?ooo`040?l0f@3o
ool0oooo0;H0oa80oooo00<0o`1=0?ooo`3oool00`3o04d50?ooo`80o`1f403oool00`3o0:d0oooo
0?ooo`070?ooo`030000003oool0oooo00h0oooo00<0o`0V0?ooo`3oool04P3oool00`000000oooo
0?ooo`050?ooo`000`3oool00`000000oooo0?ooo`0n0?ooo`<0o`0V0P3oool20?l09P80oooo00<0
o`0V0?ooo`3oool01@3oool20?l0CAH0oooo00<0]P3o0?ooo`3oool0603oool00`250?l0oooo0?oo
o`090?ooo`030?l0f@3oool0oooo00P0oooo00H0R`3o0?ooo`3oool000000?ooo`3j0?l308/0o`X0
oooo00<0nP3o0?ooo`3oool01@3oool00`0:0?l0oooo0?ooo`050?ooo`0305L0o`3oool0oooo0080
o`3I0`3oool01@3o0=T0oooo0?l0f@3o0=T0oooo00<008Wo0P3oool0103j0?l0oooo0?X0o`3j0?l<
0?ooo`04000_o`3oool0oooo08/0o`T0oooo00<0Q@3o00X0o`3oool04`3oool00`0:0?l0oooo0?oo
o`0:0?ooo`030?X0o`3oool0oooo00<0oooo00@0o`3I0?ooo`3o0=T0oooo0P3o0=T00`3oool0o`3I
0?ooo`0E0?ooo`80o`1=0P3oool20?l0C@L0oooo00<0o`1f0?ooo`3oool03P3oool20?l0[@P0oooo
00<000000?ooo`3oool03P3oool00`3o02H0oooo0?ooo`0A0?ooo`030000003oool0oooo00D0oooo
00040?ooo`030000003oool0oooo03/0oooo0P3o02H30?ooo`80o`0V00@0oooo0?l09P3oool0o`0V
1P3oool20?l0CAL0oooo00<0]P3o0?ooo`3oool05P3oool00`3o0=T0oooo08D0o`0;0?ooo`030?l0
f@3oool0oooo00P0oooo00H0R`3o0?ooo`3oool0oooo0000003j0?l>0?ooo`030?X0o`3oool0oooo
00D0oooo00<02P3o0?ooo`3oool0103oool00`1G0?l0oooo0?ooo`020?ooo`030?l0f@3oool0oooo
0080o`3I0`3oool00`3o0=T008Wo0029o`030029o`050?ooo`3j0?l0nP3o0?ooo`3j0?l0303oool0
0`00;ol0R`3o0?ooo`090?ooo`0308D0o`0:0?l0oooo01@0oooo00<02P3o0?ooo`3oool02P3oool0
0`3j0?l0oooo0?ooo`030?ooo`030?l0f@3oool0o`3I00<0o`3I603oool01P3o04d0oooo0?l0C@3o
04d0oooo0?l0C@L0oooo00<0o`1f0?ooo`3oool03`3oool00`3o0:d0oooo0?ooo`050?ooo`030000
003oool0oooo00l0oooo0P3o02HA0?ooo`030000003oool0oooo00D0oooo00050?ooo`800000>@3o
ool20?l09PD0oooo00H0o`0V0?ooo`3oool0o`0V0?ooo`3o02H40?ooo`80o`1=6@3oool00`2f0?l0
oooo0?ooo`0@0?ooo`X0o`3I2P3oool00`3o0=T0oooo0?ooo`060?ooo`80R`3o103oool00`000000
nP3o0?ooo`0=0?ooo`030?X0o`3oool0oooo00`0oooo00<0E`3o0?ooo`3oool00`3oool40?l0f@80
oooo00<0o`3I0029o`00ROl01@00ROl20?X0o`030?ooo`3j0?l0oooo00/0oooo00<002oo08/0o`3o
ool02@3oool00`250?l0oooo00X0o`0D0?ooo`0300X0o`3oool0oooo00/0oooo00<0nP3o0?ooo`3o
ool00P3oool01@3o0=T0oooo0?l0f@3o0=T0oooo0080o`3I5`3oool30?l0C@<0oooo00<0o`1=0?oo
o`3oool03P3oool50?l09P@0oooo0P3o0:d60?ooo`030000003oool0oooo0100oooo00<0o`0V0?oo
o`3oool03P3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`0d0?ooo`80
o`0V203oool20?l09P030?ooo`3o02H0oooo0080oooo0P3o04dJ0?ooo`030;H0o`3oool0oooo0140
oooo00<0o`3I0?ooo`3o0=T01`3o0=T:0?ooo`030?l0f@3oool0oooo00D0oooo00<0R`3o0?ooo`3o
ool0103oool00`3j0?l0oooo0?ooo`0=0?ooo`030?X0o`3oool0oooo00`0oooo00<0E`3o0?ooo`3o
ool01@3oool40?l0f@030?ooo`00ROl0oooo008008Wo00<0nP3o0029o`3j0?l00P3j0?l20?ooo`03
0?X0o`3oool0oooo00X0oooo00<0R`3o0?ooo`3oool02@3oool00`250?l0oooo00X0o`0D0?ooo`03
00X0o`3oool0oooo00/0oooo00<0nP3o0?l0f@3o0=T00P3oool40?l0f@80oooo00<0o`3I0?ooo`3o
ool05@3oool00`3o04d0oooo0?ooo`030?ooo`030?l0C@3oool0oooo00d0oooo0P3o02H00`3oool0
o`0V0?l09P060?l09P030?l0[@3oool0oooo00@0oooo00<000000?ooo`3oool0403oool20?l09Ph0
oooo00<000000?ooo`3oool01@3oool000P0oooo0P00000b0?ooo`80o`0V303oool20?l09Qh0oooo
00<0]P3o0?ooo`3oool04`3oool80?l0f@X0oooo00<0o`3I0?ooo`3oool01@3oool00`2;0?l0oooo
0?ooo`050?ooo`030?X0o`3oool0oooo00H0oooo00<0o`2]0?ooo`3oool00`3oool00`3j0?l0oooo
0?ooo`0=0?ooo`0305L0o`3oool0oooo00D0oooo0P3o0=T20?ooo`@008Wo00H0nP3o0029o`00ROl0
oooo0?X0o`3oool30?X0o``0oooo00<0R`3o0?ooo`3oool02@3oool010250?l0oooo0?ooo`0:0?lR
0?ooo`030?X0o`3o0=T0o`3I00<0o`3I1@3oool00`3o0=T0oooo0?ooo`0K0?ooo`80o`1=3P3oool3
0?l09P<0oooo0`3o02H20?ooo`030?l0[@3oool0oooo00@0oooo00<000000?ooo`3oool04@3oool0
0`3o02H0oooo0?ooo`0;0?ooo`030000003oool0oooo00D0oooo000:0?ooo`030000003oool0oooo
02d0oooo0P3o02H]0?ooo`030;H0o`3oool0oooo01<0oooo0`3o0=T00`3oool0o`3I0?l0f@030?l0
f@X0oooo00<0o`3I0?ooo`3oool0103oool00`2;0?l0oooo0?ooo`060?ooo`030?X0o`3oool0oooo
00D0oooo0P3o0:d50?ooo`030?X0o`3oool0oooo00d0oooo00<0E`3o0?ooo`3oool0103oool00`3o
0=T0oooo0?ooo`050?ooo`<008Wo0P3oool0103j0?l0oooo0?ooo`3oool20?X0o`/0oooo00<0R`3o
0?ooo`3oool02@3oool010250?l0oooo0?ooo`0:0?l20?ooo`80R`3o7P3oool0103j0?l0oooo0?l0
f@3oool20?l0f@H0oooo0P3o0=TM0?ooo`030?l0C@3oool0oooo00/0oooo0P3o02H00`3oool0o`0V
0?ooo`020?ooo`80o`0V0`3oool20?l0[@D0oooo00<000000?ooo`3oool04@3oool20?l09P/0oooo
00<000000?ooo`3oool01@3oool000/0oooo0P00000[0?ooo`80o`0V;P3oool00`2f0?l0oooo0?oo
o`0C0?ooo`80o`3I00<0oooo0?l0f@3o0=T01@3o0=T:0?ooo`030?l0f@3oool0oooo00<0oooo00<0
R`3o0?ooo`3oool01P3oool00`3j0?l000000?ooo`050?ooo`@0o`2]2P3oool00`0:0?l0o`1f0?oo
o`060?ooo`0305L0o`3oool0oooo00D0oooo00<0o`3I0?ooo`3oool01@3oool01`00ROl0oooo0?X0
o`3j0?l0oooo0?X0o`3oool00P3j0?l=0?ooo`0308/0o`3oool0oooo00X0oooo00D0Q@3o0?ooo`3o
ool02P3o0?ooo`0408/0oa`0oooo00@0o`3I0?X0o`3oool0o`3I0P3oool20?l0f@H0oooo00<0o`3I
0?ooo`3oool06`3oool00`3o04d0oooo0?ooo`0;0?ooo`040?l09P3oool0oooo0?l09P80oooo00<0
o`0V0?ooo`3oool0103oool00`3o0:d0oooo0?ooo`030?ooo`030000003oool0oooo0180oooo00<0
o`0V0?ooo`3oool02@3oool00`000000oooo0?ooo`040?ooo`003@3oool00`000000oooo0?ooo`0V
0?ooo`80o`0V;`3oool00`2f0?l0oooo0?ooo`0E0?ooo`@0o`3I00<0oooo0?l0f@3oool00P3o0=T9
0?ooo`030?l0f@3oool0oooo00<0oooo00<0R`3o0?ooo`3oool01`3oool00`3j0?l000000?ooo`03
0?ooo`H0o`2]203oool300X0o`030?l0MP3oool0oooo00D0oooo00<0E`3o0?ooo`3oool01@3oool0
0`3o0=T0oooo0?ooo`050?ooo`040029o`3oool0oooo0?ooo`<0nP3o3`3oool00`2;0?l0oooo0?oo
o`0:0?ooo`0508D0o`3oool0oooo0?ooo`0:0?l01`2;0?lJ0?ooo`030?l0f@3j0?l0oooo00<0o`3I
203oool00`3o0=T0oooo0?ooo`0K0?ooo`030?l0C@3oool0oooo00X0oooo0P3o02H20?ooo`80o`0V
203oool00`3o0:d0oooo0?ooo`020?ooo`030000003oool0oooo01<0oooo00<0o`0V0?ooo`3oool0
203oool00`000000oooo0?ooo`040?ooo`003P3oool00`000000oooo0?ooo`0S0?ooo`80o`0V<03o
ool00`2f0?l0oooo0?ooo`0F0?ooo`T0o`3I2@3oool00`3o0=T0oooo0?ooo`020?ooo`0308/0o`3o
ool0oooo00P0oooo00<0nP3o0000003oool00P3oool30?l0[@050?ooo`3o0:d0o`2]0?ooo`3o0:d0
1@3oool200X0o`030?ooo`0:0?l02P3o0080o`1f1P3oool00`1G0?l0oooo0?ooo`050?ooo`030?l0
f@3oool0oooo00D0oooo00<008Wo0?ooo`3oool00P3oool00`3j0?l0oooo0?ooo`0>0?ooo`0308/0
o`3oool0oooo00/0oooo00T0Q@3o0?ooo`3oool0oooo00X0o`2;0?l0oooo08/0o`3oool0102;0?lH
0?ooo`030?l0f@3oool0nP3o0080o`3I2P3oool20?l0fA`0oooo0P3o04d;0?ooo`80o`0V00@0oooo
0?l09P3oool0o`0V203oool20?l0[@<0oooo00<000000?ooo`3oool04`3oool20?l09PP0oooo00<0
00000?ooo`3oool0103oool000l0oooo0P00000Q0?ooo`80o`0V<@3oool00`2f0?l0oooo0?ooo`0F
0?ooo`040?l0f@3oool0oooo0?ooo`H0o`3I2@3oool00`3o0=T0oooo0?ooo`0208/0o`X0oooo00<0
nP3o0000003oool00P3oool20?l0[@<0oooo00@0o`2]0?ooo`3o0:d0o`2]103oool200X0o`040?l0
MP0:0?l0oooo00X0o`80o`1f1P3oool00`1G0?l0oooo0?ooo`040?ooo`030?l0f@3oool0oooo00H0
oooo00<008Wo0?ooo`3oool00P3oool00`3j0?l0oooo0?ooo`0>0?ooo`0308/0o`3oool0oooo00/0
oooo00D0Q@3o0?ooo`3oool0oooo00X0o`0308/0o`040?ooo`2;0?l0oooo08/0oaT0oooo0`3o0=T0
0`3j0?l0oooo0?l0f@0;0?ooo`030?l0f@3oool0oooo01/0oooo00<0o`1=0?ooo`3oool0203oool4
0?l09P80oooo00<0o`0V0?ooo`3oool01`3oool01@3o0:d0oooo0?ooo`3oool0000001H0oooo00<0
o`0V0?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`004@3oool00`000000oooo0?ooo`0L
0?ooo`80o`0V<`3oool00`2f0?l0oooo0?ooo`0D0?ooo`80o`3I0`3oool00`3o0=T0oooo0?ooo`03
0?l0f@T0oooo00@0o`3I0?ooo`3oool0R`3o303oool00`3j0?l000000?ooo`030?ooo`030?l0[@3o
ool0oooo0080o`2]0`3oool01@3o0:d0oooo0?ooo`0:0?l0oooo00D02P3o00<0o`1f0?ooo`3o07H0
1@3oool00`1G0?l0oooo0?ooo`040?ooo`030?l0f@3oool0oooo00H0oooo00<008Wo0?ooo`3oool0
0P3oool00`3j0?l0oooo0?ooo`0>0?ooo`0308/0o`3oool0oooo00/0oooo00<0Q@3o0?ooo`3oool0
0P3oool00`0:0?l0R`3o08/0o`0308/0o`<0]P3o5`3oool30?l0f@030?ooo`3j0?l0o`3I00`0oooo
00<0o`3I0?ooo`3oool06`3oool00`3o04d0oooo0?ooo`080?ooo`80o`0V103oool20?l09P`0oooo
00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`004P3oool2000001X0oooo0P3o
02Hd0?ooo`030;H0o`3oool0oooo01@0oooo00<0o`3I0?ooo`3oool00`3oool00`3o0=T0oooo0?oo
o`0<0?ooo`030?l0f@3oool0R`3o00`0oooo00<0nP3o0?ooo`0000001@3oool40?l0[@80oooo00<0
o`2]0?ooo`3oool00P3oool600X0o`80oooo00<0o`1f0?ooo`3oool00P3oool00`1G0?l0oooo0?oo
o`050?ooo`030?l0f@3oool0oooo00H0oooo00<008Wo0?ooo`3oool00P3oool00`3j0?l0oooo0?oo
o`0>0?ooo`0308/0o`3oool0oooo00`0oooo00H0Q@3o0?ooo`3oool0oooo08/0o`0:0?l308/0o`D0
]P3o5`3oool01P3o0=T0oooo0?ooo`3oool0nP3o0?l0f@`0oooo0P3o0=TL0?ooo`80o`1=203oool0
0`3o02H0oooo0?ooo`050?ooo`030?l09P3oool0oooo00X0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`040?ooo`00503oool00`000000oooo0?ooo`0E0?ooo`80o`0V;@3oool:0?l0
[AD0oooo00<0o`3I0?ooo`3oool00`3oool00`3o0=T0oooo0?ooo`0=0?ooo`030?l0f@2;0?l0oooo
00`0oooo00<0nP3o0?ooo`0000001`3oool40?l0[@@0oooo0`3o07H400X0o`040?l0MP3oool0oooo
0?l0MP<0oooo00<0E`3o0?ooo`3oool01@3oool00`3o0=T0oooo0?ooo`060?ooo`030029o`3oool0
oooo0080oooo00<0nP3o0?ooo`3oool01P3oool00`0:0?l0oooo0?ooo`050?ooo`0308/0o`3oool0
oooo00`0oooo00@0Q@3o0?ooo`3oool0oooo0`2;0?l20?ooo`0608/0o`2f0?l0]P3o0;H0o`3oool0
]P3o703oool00`3o0=T0oooo0?ooo`050?ooo`<0o`1=0`3oool00`3o0=T0oooo0?ooo`0K0?ooo`03
0?l0C@3oool0oooo00h0oooo00<0o`0V0?ooo`3oool02@3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo00@0oooo000E0?ooo`8000004`3oool20?l09Rl0oooo00<0o`2]0?ooo`3o0:d0
1`3o0:dC0?ooo`80o`3I1P3oool00`3o0=T0oooo0?ooo`0<0?ooo`030?l0f@3oool0oooo00d0oooo
00<0nP3o0?ooo`0000001P3oool00`3o0:d0oooo0?l0[@070?ooo`070?l0MP0:0?l0oooo0?ooo`0:
0?l0o`1f0?ooo`030?l0MP<0oooo00<0E`3o0?ooo`3oool0103oool00`3o0=T0oooo0?ooo`070?oo
o`030029o`3oool0oooo0080oooo00<0nP3o0?ooo`3oool01P3oool200X0o`H0oooo00<0R`3o0?oo
o`3oool0303oool00`250?l0oooo0?ooo`060?ooo`060;H0o`2;0?l0]P3o0?ooo`2f0?l0oooo0P2f
0?lK0?ooo`030?l0f@3oool0oooo00@0oooo1`3o04d00`3o0=T0oooo0?ooo`0K0?ooo`030?l0C@3o
ool0oooo00h0oooo0P3o02H:0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0103o
ool001L0oooo00<000000?ooo`3oool03P3oool20?l09S80oooo00<0o`2]0?ooo`3o0:d00P3oool3
0?l0[A<0oooo00<0o`3I0?ooo`3oool01P3oool00`3o0=T0oooo0?ooo`0<0?ooo`030?l0f@3oool0
oooo00H0oooo00<0]P3o0?ooo`3oool00`3oool0103j0?l0oooo0?ooo`0000060?ooo`030?l0[@3o
ool0oooo00P0oooo00<02P3o0?l0MP3oool00P3o07H30?ooo`80o`1f2@3oool00`3o0=T0oooo0?oo
o`070?ooo`030029o`3oool0oooo0080oooo00<0nP3o0?ooo`3oool01@3oool400X0oaD0oooo00<0
Q@3o0?ooo`3oool01@3oool00`2f0?l0oooo08/0o`060;H0oa/0oooo00<0o`3I0?ooo`3oool0103o
ool30?l0C@050?ooo`3o04d0o`1=0?l0C@3o0=T00P3o04dK0?ooo`030?l0C@3oool0oooo00l0oooo
00<0o`0V0?ooo`3oool0203oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00<0oooo
000H0?ooo`030000003oool0oooo0440oooo00<0o`2]0?ooo`3oool00`3o0:d00`3oool0o`2]0?oo
o`0@0?ooo`80o`3I203oool00`3o0=T0oooo0?ooo`0D0?ooo`<0]P3o1@3oool0103j0?l0oooo0?oo
o`0000060?ooo`030?l0[@3oool0oooo00L0oooo00<02P3o0?ooo`3oool00`3o07H00`3oool0o`1f
0?l0MP0;0?ooo`030?l0f@3oool0oooo00L0oooo00D008Wo0?ooo`3oool0oooo0?X0o`080?ooo`D0
2P3o503oool00`250?l0oooo0?ooo`040?ooo`050;H0o`3oool0]P3o08/0o`2f0?l00P3oool20;H0
oad0oooo00<0o`3I0?ooo`3oool00`3oool20?l0C@030?ooo`3o04d0oooo0080oooo00<0o`1=0?l0
f@3o0=T0703oool20?l0CA00oooo00<0o`0V0?ooo`3oool0203oool00`000000oooo0?ooo`0H0?oo
o`030000003oool0oooo00<0oooo000I0?ooo`800000@P3oool30?l0[@030?ooo`3o0:d0o`2]0140
oooo00<0o`3I0?ooo`3oool0203oool00`3o0=T0oooo0?ooo`0B0?ooo`@0]P3o1P3oool0103j0?l0
oooo0?ooo`0000050?ooo`030?l0[@3oool0oooo00P0oooo00@02P3o0?ooo`3oool0oooo0`3o07H=
0?ooo`030?l0f@3oool0oooo00L0oooo00D008Wo0?ooo`3oool0oooo0?X0o`080?ooo`@02P3o00<0
oooo00X0o`3oool0103oool00`3o0=T0oooo0?ooo`0;0?ooo`0308D0o`3oool0oooo00@0oooo0P2f
0?l00`3oool0]P3o08/0o`020;H0ob00oooo00<0o`3I0?ooo`3oool00`3oool0103o04d0oooo0?oo
o`3o04d20?ooo`040?l0C@3oool0oooo0?l0fAd0oooo00<0o`1=0?ooo`3oool03P3oool20?l09PT0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`030?ooo`006`3oool00`000000oooo
0?ooo`0o0?ooo`060?l0[@3oool0oooo0?l0[@3oool0o`2]3`3oool20?l0f@X0oooo00<0o`3I0?oo
o`3oool04@3oool20;H0o`80oooo0P2f0?l50?ooo`050?X0o`3oool0oooo0?ooo`0000001@3oool0
0`3o0:d0oooo0?ooo`070?ooo`0500X0o`3oool0oooo0?ooo`3o07H03`3oool00`3o0=T0oooo0?oo
o`080?ooo`050029o`3oool0oooo0?ooo`3j0?l0203oool700X0o`<0oooo0`3o0=T=0?ooo`0308D0
o`3oool0oooo00D0oooo0`2f0?l00`2;0?l0oooo0?ooo`0P0?ooo`030?l0f@3oool0oooo0080oooo
0P3o04d20?ooo`80o`1=103oool00`3o0=T0oooo0?ooo`0K0?ooo`030?l0C@3oool0oooo00l0oooo
00<0o`0V0?ooo`3oool01P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo00<0oooo
000L0?ooo`800000?@3oool20?l0[@060?ooo`3o0:d0o`2]0?l0[@3oool0o`2]3P3oool00`3o0=T0
oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo00l0oooo0P2f0?l30?ooo`040;H0o`3o04d0]P3o0?l0
C@@0oooo00D0nP3o0?ooo`3oool0oooo000000050?ooo`030?l0[@3oool0oooo00L0oooo00D02P3o
0?ooo`3oool0oooo0?l0MP0?0?ooo`030?l0f@3oool0oooo00P0oooo00D008Wo0?ooo`3oool0oooo
0?X0o`070?ooo`0300X0o`3oool02P3o00802P3o1@3oool40?l0f@d0oooo00<0Q@3o0?ooo`3oool0
203oool00`2f0?l0R`3o0?ooo`0Q0?ooo`030?l0f@3oool0oooo0080oooo0P3o04d00`3oool0o`1=
0?l0C@050?ooo`80o`3I703oool20?l0CA00oooo00<0o`0V0?ooo`3oool01P3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo00<0oooo000N0?ooo`030000003oool0oooo03T0oooo00@0
o`2]0?ooo`3oool0oooo0P3o0:d00`3oool0o`2]0?ooo`0=0?ooo`030?l0f@3oool0oooo00X0oooo
00<0o`3I0?ooo`3oool04@3oool20;H0o`060?l0C@2f0?l0o`1=0?l0C@2f0?l0o`1=0`3oool00`3j
0?l0oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0o`2]0?ooo`3oool01P3oool00`0:
0?l0oooo0?ooo`020?ooo`030?l0MP3oool0oooo00d0oooo00<0R`3o0?ooo`3oool0203oool01@00
ROl0oooo0?ooo`3oool0nP3o00L0oooo0P0:0?l20?ooo`0300X0o`3oool0oooo0080oooo00H0o`3I
0?ooo`3o0=T0o`3I0?ooo`3o0=T<0?ooo`0308D0o`3oool0oooo00T0oooo00<0]P3o08/0o`3oool0
8@3oool0103o0=T0oooo0?ooo`3oool20?l0C@030?ooo`3o04d0oooo0080o`1=1@3oool00`3o0=T0
oooo0?ooo`0K0?ooo`030?l0C@3oool0oooo00h0oooo0P3o02H70?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool00`3oool001l0oooo0P00000g0?ooo`80o`2]1P3oool20?l0[@`0oooo
0P3o0=T=0?ooo`030?l0f@3oool0oooo0180oooo00P0o`1=0;H0o`2f0?l0oooo0;H0o`3o04d0oooo
0?l0C@80oooo00<0nP3o0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030?l0[@3oool0
oooo00H0oooo00<02P3o0?ooo`3oool00`3oool00`3o07H0oooo0?ooo`0<0?ooo`80R`3o2P3oool0
1@00ROl0oooo0?ooo`3oool0nP3o00/0oooo00<02P3o0?ooo`3oool00P3oool0103o0=T0oooo0?l0
f@3o0=T20?ooo`030?l0f@3oool0oooo00X0oooo00<0Q@3o0?ooo`3oool0203oool00`2f0?l0oooo
08/0o`0R0?ooo`040?l0f@3oool0oooo0?ooo`80o`1=103oool00`3o04d0oooo0?ooo`030?ooo`03
0?l0f@3oool0oooo01/0oooo00<0o`1=0?ooo`3oool01`3oool30?l000D0oooo00<0o`0V0?ooo`3o
ool01@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo00<0oooo000Q0?ooo`030000
003oool0oooo03<0oooo00<0o`2]0?ooo`3oool04`3oool00`3o0=T0oooo0?ooo`0=0?ooo`030?l0
f@3oool0oooo0140oooo00<0o`1=0;H0o`3o04d00`2f0?l20?ooo`040?l0C@3oool0oooo0?X0o`@0
oooo00<000000?ooo`3oool00P3oool00`3o0:d0oooo0?ooo`060?ooo`0300X0o`3oool0oooo0080
oooo00<0o`1f0?ooo`3oool0303oool408/0o`T0oooo00D008Wo0?ooo`3oool0oooo0?X0o`0;0?oo
o`0400X0o`3oool0oooo0?ooo`<0o`3I00<0oooo0?l0f@3o0=T00P3o0=T<0?ooo`0308D0o`3oool0
oooo00P0oooo00D0]P3o0?ooo`3oool0R`3o0?ooo`020?l0fAl0oooo00@0o`3I0?ooo`3oool0o`1=
1P3oool00`3o04d0oooo0?ooo`0Z0?ooo`P0o`0000<0oooo0?l09P3oool01P3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo0080oooo000R0?ooo`030000003oool0oooo0300oooo0P3o
0:dD0?ooo`80o`3I3`3oool00`3o0=T0oooo0?ooo`0A0?ooo`80o`1=00D0]P3o0?ooo`3oool0o`1=
0;H0o`020?l0C@030?ooo`3o04d0nP3o00D0oooo00<000000?ooo`3oool00P3oool00`3o0:d0oooo
0?ooo`050?ooo`0300X0o`3oool0oooo00<0oooo00<0o`1f0?ooo`3oool02P3oool208/0o`040?oo
o`2;0?l0R`3o08/0o`T0oooo00D008Wo0?ooo`3oool0oooo0?X0o`0<0?ooo`0400X0o`3oool0o`3I
0?l0f@<0oooo00<0o`3I0?ooo`3oool00P3o0=TG0?ooo`040;H0o`3oool0R`3o0?ooo`@0o`3I7P3o
ool00`3o0=T0oooo0?ooo`070?ooo`030?l0C@3oool0oooo02X0oooo0`3o00000`3oool0o`000?l0
00030?l00080o`0V1@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0080oooo000S
0?ooo`800000;`3oool00`3o0:d0oooo0?ooo`0C0?ooo`030?l0f@3oool0oooo00l0oooo00<0o`3I
0?ooo`3oool04P3oool0102f0?l0o`1=0?ooo`3oool20?l0C@80oooo0P3o04d00`3j0?l0oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`3o0:d0203oool00`0:0?l0oooo0?ooo`030?ooo`030?l0
MP3oool0oooo00T0oooo00<0R`3o0?ooo`3oool00`2;0?l00`3oool0R`3o0?ooo`020?ooo`030?l0
C@3oool0oooo00H0oooo00<0nP3o0?ooo`3oool02P3oool0100:0?l0oooo0?ooo`3oool20?l0f@03
0?ooo`3o0=T0oooo0080o`3I603oool0202f0?l0oooo0?ooo`2;0?l0o`3I0?ooo`3o0=T0oooo0`3o
0=TK0?ooo`030?l0f@3oool0oooo00P0oooo0P3o04dZ0?ooo`040?l0003oool0oooo0?l000<0oooo
0P3o00020?ooo`030?l09P3oool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`020?ooo`009@3oool00`000000oooo0?ooo`0Z0?ooo`80o`2]803oool00`3V0?l0oooo0?oo
o`040?ooo`030?l0f@3oool0oooo0180oooo00<0]P3o0?ooo`3oool0103o04d00`3oool0o`1=0?l0
C@070?ooo`050000003oool0oooo0?ooo`3o0:d01`3oool00`0:0?l0oooo0?ooo`040?ooo`030?l0
MP3oool0oooo00P0oooo1`2;0?l0103oool0R`3o0?ooo`3oool20?l0C@P0oooo00<0nP3o0?ooo`3o
ool02P3oool00`0:0?l0oooo0?ooo`030?ooo`<0o`3I6P3oool0202f0?l0oooo0?ooo`3oool0R`3o
0?l0f@3oool0o`3I0`3oool20?l0fAX0oooo00<0o`3I0?ooo`3oool02@3oool00`3o04d0oooo0?oo
o`0X0?ooo`040?l0003oool0oooo0?l00080oooo00<0o`000?ooo`3oool00P3oool00`3o02H0oooo
0?ooo`030?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool00P3oool002H0oooo0P00
000Y0?ooo`030?l0[@3oool0oooo01h0oooo0`3V0?l60?ooo`030?l0f@3oool0oooo0140oooo00<0
]P3o0?ooo`3oool00P3oool40?l0C@T0oooo00D000000?ooo`3oool0oooo0?l0[@070?ooo`0300X0
o`3oool0oooo00@0oooo00<0o`1f0?ooo`3oool02P3oool608/0o`030?ooo`2;0?l0o`1=00<0o`1=
1`3oool00`3j0?l0oooo0?ooo`0;0?ooo`0300X0o`3oool0oooo0080oooo00<0o`3I0?ooo`3oool0
6`3oool01@2f0?l0oooo0?ooo`3oool0R`3o0080oooo00@0o`3I0?ooo`3oool0o`3I703oool00`3o
0=T0oooo0?ooo`090?ooo`030?l0C@3oool0oooo02L0oooo00@0o`000?ooo`3oool0oooo0`3o0005
0?ooo`80o`0V103oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0080oooo000X0?oo
o`030000003oool0oooo02@0oooo0P3o0:dO0?ooo`@0iP3o1`3oool00`3o0=T0oooo0?ooo`0A0?oo
o`030;H0o`3oool0oooo0080oooo00<0o`1=0?ooo`3oool02P3oool010000000oooo0?ooo`3o0:d7
0?ooo`0300X0o`3oool0oooo00@0oooo00<0o`1f0?ooo`3oool03P3oool508/0o`@0o`1=1P3oool0
0`3j0?l0oooo0?ooo`0<0?ooo`0300X0o`3oool0oooo0080oooo00<0o`3I0?ooo`3oool06`3oool0
2P2f0?l0oooo0?ooo`3oool0o`3I08/0o`3oool0o`3I0?ooo`3o0=TN0?ooo`030?l0f@3oool0oooo
00T0oooo00<0o`1=0?ooo`3oool09P3oool20?l000<0oooo0P3o00070?ooo`030?l09P3oool0oooo
0080oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`020?ooo`00:@3oool00`000000
oooo0?ooo`0R0?ooo`030?l0[@3oool0oooo01d0oooo0P3V0?l20?ooo`80iP3o1P3oool00`3o0=T0
oooo0?ooo`0A0?ooo`030;H0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool02P3oool01P000000
oooo0?ooo`3o0:d0oooo0?l0f@D0oooo00<02P3o0?ooo`3oool0103oool00`3o07H0oooo0?ooo`0=
0?ooo`0508/0o`3oool0oooo0?l0C@3oool0103o04d00`3oool0o`1=0?ooo`040?ooo`030?X0o`3o
ool0oooo00`0oooo00<02P3o0?ooo`3oool00P3oool00`3o0=T0oooo0?ooo`050?ooo`030;H0o`3o
ool0oooo01@0oooo00H0]P3o0?ooo`3oool0o`3I0?ooo`2;0?l20?l0fB00oooo00<0o`3I0?ooo`3o
ool02@3oool00`3o04d0oooo0?ooo`0V0?ooo`040?l0003oool0oooo0?l00080oooo00<0o`000?oo
o`3oool01@3oool01@3o02H0oooo0?ooo`3oool000000180oooo00<000000?ooo`3oool00P3oool0
02X0oooo0P00000Q0?ooo`030?l0[@3oool0oooo01d0oooo00L0iP3o0?ooo`3oool0oooo0>H0o`3o
ool0iP3o00H0oooo00<0o`3I0?ooo`3oool0403oool00`2f0?l0oooo0?ooo`030?ooo`030?l0C@3o
ool0oooo00/0oooo00<000000?ooo`3oool00`3o0=T40?ooo`0300X0o`3oool0oooo00D0oooo00<0
o`1f0?ooo`3oool03@3oool00`2;0?l0oooo0?l0C@020?l0C@80oooo0P3o04d00`3oool0o`1=0?oo
o`040?ooo`030?X0o`3oool0oooo00`0oooo00<02P3o0?ooo`3oool00P3oool00`3o0=T0oooo0?oo
o`050?ooo`80]P3o5@3oool01P2f0?l0oooo0?ooo`3oool0o`3I08/0o`80oooo00<0o`3I0?ooo`3o
ool07P3oool00`3o0=T0oooo0?ooo`090?ooo`80o`1=9P3oool30?l000@0oooo00<0o`000?ooo`3o
ool01@3oool20?l09P80oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`020?ooo`00
;03oool00`000000oooo0?ooo`0L0?ooo`80o`2]8@3oool00`3V0?l0oooo0>H0o`020?ooo`030>H0
o`3oool0oooo00<0oooo00<0o`3I0?ooo`3oool0403oool00`2f0?l0oooo0?ooo`040?ooo`030?l0
C@3oool0oooo00/0oooo00<000000?ooo`3o0=T00`3o0=T40?ooo`0300X0o`3oool0oooo00D0oooo
00<0o`1f0?ooo`3oool03@3oool00`2;0?l0o`1=0?l0C@040?ooo`050?l0C@3oool0o`1=0?ooo`3o
04d0103oool00`3j0?l0oooo0?ooo`0=0?ooo`0500X0o`3oool0oooo0?ooo`3o0=T01P3oool40;H0
oa@0oooo00L0]P3o0?ooo`3oool0oooo0?l0f@3oool0R`3o0080oooo00<0o`3I0?ooo`3oool07P3o
ool00`3o0=T0oooo0?ooo`0:0?ooo`030?l0C@3oool0oooo02@0oooo0P3o00050?ooo`030?l0003o
ool0oooo00H0oooo00@0o`0V0?ooo`3oool000004@3oool00`000000oooo0?ooo`010?ooo`00;@3o
ool2000001/0oooo00<0o`2]0?ooo`3oool08P3oool20>H0o`030?ooo`3V0?l0oooo00D0oooo00<0
o`3I0?ooo`3oool03`3oool00`2f0?l0oooo0?ooo`050?ooo`030?l0C@3oool0oooo00/0oooo00<0
00000?l0f@3o0:d0103o0=T20?ooo`0300X0o`3oool0oooo00D0oooo00<0o`1f0?ooo`3oool03P3o
ool0102;0?l0oooo0?l0C@3o04d30?ooo`030?l0C@3oool0oooo0080o`1=103oool00`3j0?l0oooo
0?ooo`0=0?ooo`0500X0o`3oool0oooo0?ooo`3o0=T01P3oool60;H0oa<0oooo00<0]P3o0?ooo`3o
ool00`3oool0102;0?l0oooo0?ooo`3o0=TX0?ooo`<0o`0V0P3oool00`3o04d0oooo0?ooo`0S0?oo
o`030?l0003oool0oooo00D0oooo0P3o000:0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool00@3oool002l0oooo00<000000?ooo`3oool05P3oool20?l0[B@0oooo00<0iP3o0?ooo`3o
ool00P3V0?l50?ooo`030?l0f@3oool0oooo0100oooo00<0]P3o0?ooo`3oool0103oool00`3o04d0
oooo0?ooo`0;0?ooo`80o`3I00H0oooo0?l0f@3o0=T0o`3I0?ooo`3o0=T20?ooo`0300X0o`3oool0
oooo00D0oooo00<0o`1f0?ooo`3oool03P3oool01P2;0?l0oooo0?ooo`3oool0o`1=0?ooo`80o`1=
0`3oool20?l0C@<0oooo00<0nP3o0?ooo`3oool03@3oool01@0:0?l0oooo0?ooo`3oool0o`3I00D0
oooo00<0]P3o0?ooo`2f0?l00P2f0?l20?ooo`030;H0o`3oool0oooo0100oooo00<0]P3o0?ooo`3o
ool0103oool0102;0?l0oooo0?ooo`3o0=TW0?ooo`H0o`0V00<0o`1=0?l09P3oool0;03oool00`3o
0000oooo0?ooo`080?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00@3oool00300
oooo0P00000E0?ooo`030?l0[@3oool0oooo02<0oooo00<0iP3o0?ooo`3oool00P3oool00`3V0?l0
oooo0?ooo`030?ooo`030?l0f@3oool0oooo00l0oooo00<0]P3o0?ooo`3oool01@3oool00`3o04d0
oooo0?ooo`0:0?ooo`@0o`3I00P0oooo0?l0f@3o0=T0oooo0?l0f@3oool02P3o0?l09PL0oooo00<0
o`1f0?ooo`3oool03P3oool00`2;0?l0oooo0?ooo`020?ooo`<0o`1=00<0oooo0?l0C@3o04d05P3o
ool0100:0?l0oooo0?ooo`3o0=T50?ooo`040;H0o`3oool0]P3o0?ooo`D0]P3o4@3oool00`2f0?l0
oooo0?ooo`080?ooo`030?l0f@3oool0oooo02D0oooo0`3o02H00`3oool0o`0V0?l09P020?l0C@80
o`0V:`3oool00`3o0000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool00@3oool00380oooo00<000000?ooo`3oool0403oool20?l0[BH0oooo00<0iP3o0?ooo`3oool0
6@3oool00`2f0?l0oooo0?ooo`060?ooo`030?l0C@3oool0oooo00/0oooo0P3o0=T01`3oool0o`3I
0?l0f@3o0=T0oooo0?l0f@3oool00`3o02H60?ooo`030?l0MP3oool0oooo00d0oooo00<0R`3o0?oo
o`3oool0103oool30?l0CAP0oooo00@02P3o0?ooo`3oool0o`3I1@3oool00`2f0?l0oooo0;H0o`02
0;H0o`030?ooo`2f0?l0]P3o01<0oooo00<0]P3o0?ooo`3oool0203oool00`3o0=T0oooo0?ooo`0T
0?ooo`040?l09P3oool0oooo0?l09P<0oooo00<0o`0V0?l0C@3oool0;03oool00`3o0000oooo0?oo
o`070?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00@3oool003<0oooo00<00000
0?ooo`3oool03P3oool00`3o0:d0oooo0?ooo`0U0?ooo`030>H0o`3oool0oooo01T0oooo00<0]P3o
0?ooo`3oool01`3oool00`3o04d0oooo0?ooo`0<0?ooo`040000003o0=T0o`3I0?ooo`80o`3I00<0
oooo0?l0f@3o02H00P3o02H50?ooo`030?l0MP3oool0oooo00h0oooo00<0R`3o0?ooo`3oool0103o
ool00`3o04d0oooo0?ooo`0:0?ooo`030?l0f@3oool0oooo00/0oooo00@02P3o0?ooo`3oool0o`3I
103oool01@2f0?l0oooo0;H0o`2f0?l0oooo0080]P3o5@3oool00`2f0?l0oooo0?ooo`090?ooo`03
0?l0f@3oool0oooo02@0oooo00@0o`0V0?ooo`3oool0o`0V0P3oool00`3o02H0oooo0?l0C@0]0?oo
o`80o`00203oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0040oooo000d0?ooo`80
0000=@3oool00`3V0?l0oooo0?ooo`0I0?ooo`030;H0o`3oool0oooo00L0oooo00<0o`1=0?ooo`3o
ool03@3oool00`000000oooo0?l0f@050?l0f@80o`0V00<0oooo0?l09P3oool00`3oool00`3o07H0
oooo0?ooo`0>0?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool02P3oool30?l0f@`0
oooo00@02P3o0?ooo`3oool0o`3I103oool60;H0oaL0oooo00<0]P3o0?ooo`3oool0203oool00`3o
0=T0oooo0?ooo`0T0?ooo`040?l09P3oool0oooo0?ooo`80o`0V0`3oool00`3o04d0oooo0?ooo`0/
0?ooo`030?l0003oool0oooo00H0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`01
0?ooo`00=P3oool00`000000oooo0?ooo`0a0?ooo`030>H0o`3oool0oooo01H0oooo00D0o`2]0?oo
o`3oool0oooo0;H0o`090?ooo`030?l0C@3oool0oooo00d0oooo00H000000?l0f@3oool0oooo0?l0
9P3oool40?l09P030?ooo`3o02H0oooo00<0oooo00<0o`1f0?ooo`3oool03P3oool00`2;0?l0oooo
0?ooo`030?ooo`030?l0C@3oool0oooo00T0oooo00@0o`3I0?ooo`3o0=T0o`3I3@3oool00`0:0?l0
oooo0?l0f@0:0?ooo`030;H0o`3oool0oooo01@0oooo00<0]P3o0?ooo`3oool02@3oool00`3o0=T0
oooo0?ooo`0T0?ooo`030?l09P3oool0oooo0080o`0V103oool00`3o04d0oooo0?ooo`0/0?ooo`03
0?l0003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`010?ooo`00
=`3oool200000300oooo00<0iP3o0?ooo`3oool05P3oool20?l0[@80oooo00<0]P3o0?ooo`3oool0
203oool00`3o04d0oooo0?ooo`0=0?ooo`030000003o0=T0oooo00<0o`0V0P3oool20?l09P80oooo
00D0o`0V0?ooo`3oool0oooo0?l0MP0@0?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3o
ool0203oool01P3o0=T0oooo0?l0f@3o0=T0oooo0?l0f@`0oooo00<02P3o0?ooo`3o0=T02P3oool0
0`2f0?l0oooo0?ooo`0D0?ooo`030;H0o`3oool0oooo00X0oooo00<0o`3I0?ooo`3oool08`3oool0
1@3o02H0oooo0?l09P3o02H0oooo0080o`0V0`3oool20?l0CBd0oooo00<0o`000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0:0?ooo`4000000@3oool10?ooo`00>@3oool00`000000oooo0?ooo`0/
0?ooo`030>H0o`3oool0oooo01H0oooo0`3o0:d00`3oool0]P3o0?ooo`090?ooo`030?l0C@3oool0
oooo00d0oooo00<000000?ooo`3o0=T00P3o02H40?ooo`030?l09P3oool0o`0V0080o`0V0P3oool0
0`3o07H0oooo0?ooo`0>0?ooo`0308/0o`3oool0oooo00@0oooo00<0o`1=0?ooo`3oool01`3oool0
0`3o0=T0oooo0?ooo`020?l0f@030?ooo`3o0=T0oooo00/0oooo00<02P3o0?ooo`3o0=T02P3oool0
0`2f0?l0oooo0?ooo`0E0?ooo`030;H0o`3oool0oooo00X0oooo00@0o`3I0?ooo`3o0:d0o`2]8P3o
ool20?l09P@0oooo00<0o`0V0?ooo`3oool00P3oool00`3o04d0oooo0?ooo`0[0?ooo`80o`001P3o
ool00`000000oooo0?ooo`090?ooo`4000000@3oool10?ooo`00>P3oool2000002`0oooo00<0iP3o
0?ooo`3oool0503oool50?l0[@030;H0o`3oool0oooo00T0oooo00<0o`1=0?ooo`3oool03@3oool0
10000000o`3I0?ooo`3oool20?l09P80oooo0P3o02H30?ooo`80o`0V00<0oooo0?l0MP3oool03`3o
ool00`2;0?l0oooo0?ooo`040?ooo`030?l0C@3oool0oooo00H0oooo00<0o`3I0?ooo`3o0=T00`3o
0=T20?ooo`030?l0f@3oool0oooo00T0oooo00<02P3o0?ooo`3o0=T02`3oool00`2f0?l0oooo0?oo
o`0D0?ooo`030;H0o`3oool0oooo00/0oooo00<0o`3I0?l0[@3o0:d00P3o0:dP0?ooo`030?l09P3o
ool0oooo00@0oooo00<0o`0V0?ooo`3oool00P3oool00`3o04d0oooo0?ooo`0/0?ooo`030?l0003o
ool0oooo00@0oooo00<000000?ooo`3oool0203oool100000040oooo0@3oool003`0oooo00<00000
0?ooo`3oool0:03oool00`3V0?l0oooo0?ooo`0D0?ooo`070?l0[@3oool0o`2]0?l0[@3oool0o`2]
0;H0o`0;0?ooo`030?l0C@3oool0oooo00d0oooo00<000000?l0f@3oool00`3oool40?l09P030?oo
o`3o02H0o`0V00<0oooo00<0o`1f0?ooo`3oool03P3oool00`2;0?l0oooo0?ooo`030?ooo`030?l0
C@3oool0oooo00H0oooo0`3o0=T30?ooo`@0o`3I303oool00`0:0?l0oooo0?ooo`0:0?ooo`030;H0
o`3oool0oooo02<0oooo00<0o`3I0?l0[@3o0:d0103o0:dU0?ooo`030?l09P3oool0oooo0340oooo
00<0o`000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`4000000@3oool10?ooo`00?@3o
ool00`000000oooo0?ooo`0V0?ooo`030>H0o`3oool0oooo01@0oooo0`3o0:d01@3oool0o`2]0?l0
[@2f0?l0o`2]00X0oooo00<0o`1=0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`050?ooo`<0o`0V
3@3oool00`3o04d0oooo0?ooo`060?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool0
203oool30?l0f@040?ooo`3o0=T0oooo0?ooo`80o`3I2`3oool00`0:0?l0oooo0?ooo`0:0?ooo`03
0;H0o`3oool0oooo02@0oooo00@0o`3I0?ooo`3o0:d0oooo103o0:dT0?ooo`80o`0V<P3oool00`3o
0000oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo0@0000010?ooo`40oooo000n0?ooo`80
00009@3oool00`3V0?l0oooo0?ooo`0D0?ooo`80o`2]0P3oool20?l0[@030;H0o`3oool0o`2]00X0
oooo00<0o`1=0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`050?ooo`030?l09P3oool0oooo00`0
oooo0P3o04d80?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool02`3oool40?l0f@d0
oooo00<0o`3I0?ooo`3oool02`3oool00`2f0?l0oooo0?ooo`0S0?ooo`030?l0[@3o0=T0o`2]00<0
oooo0P3o0:dV0?ooo`030?l09P3oool0oooo0300oooo0P3o00050?ooo`030000003oool0oooo00D0
oooo0@0000010?ooo`40oooo00100?ooo`030000003oool0oooo0240oooo00<0iP3o0?ooo`3oool0
5P3oool20?l0[@030?ooo`3o0:d0oooo0080o`2]00<0oooo0?l0[@3oool0203oool00`3o04d0oooo
0?ooo`0>0?ooo`030?l0f@3oool0oooo00@0oooo00<0o`0V0?ooo`3oool0303oool40?l0C@H0oooo
00<0R`3o0?ooo`3oool0103oool00`3o04d0oooo0?ooo`0;0?ooo`030?l0f@3oool0oooo00h0oooo
00<0o`3I0?ooo`3oool02`3oool00`2f0?l0oooo0?ooo`0S0?ooo`80o`2]00<0o`3I0?l0[@3oool0
0P3o0:dX0?ooo`030?l09P3oool0oooo0340oooo00<0o`000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`4000000@3oool10?ooo`00@@3oool200000240oooo00<0iP3o0?ooo`3oool0603o
ool20?l0[@030?ooo`3o0:d0oooo0080o`2]2@3oool00`3o04d0oooo0?ooo`0=0?ooo`030?l0f@00
0000oooo00D0oooo00<0o`0V0?ooo`3oool02`3oool50?l0C@H0oooo00<0R`3o0?ooo`3oool0103o
ool00`3o04d0oooo0?ooo`0;0?ooo`030?l0f@3oool0oooo00h0oooo00<0o`3I0?ooo`3oool02`3o
ool00`2f0?l0oooo0?ooo`0:0?ooo`030>H0o`3oool0oooo01H0oooo0P3o0:d0103oool0o`3I0?l0
[@3o0:dZ0?ooo`030?l09P3oool0oooo0340oooo00<0o`000?ooo`3oool00P3oool00`000000oooo
0?ooo`050?ooo`4000000@3oool004<0oooo00<000000?ooo`3oool07@3oool00`3V0?l0oooo0?oo
o`0I0?ooo`030?l0[@3oool0o`2]0080o`2]2P3oool00`3o04d0oooo0?ooo`0>0?ooo`030?l0f@00
0000oooo00D0oooo00<0o`0V0?ooo`3oool02@3oool20?l0C@030?ooo`3o04d0o`1=0080o`1=1P3o
ool00`2;0?l0oooo0?ooo`030?ooo`030?l0C@3oool0oooo00`0oooo00<0o`3I0?ooo`3oool03P3o
ool00`3o0=T0oooo0?ooo`0<0?ooo`030;H0o`3oool0oooo00T0oooo0P3V0?lH0?ooo`80o`2]00<0
o`3I0?l0[@3o0:d0:`3oool00`3o02H0oooo0?ooo`0a0?ooo`030?l0003oool0oooo0080oooo00<0
00000?ooo`3oool0103oool100000040oooo00140?ooo`800000703oool00`3V0?l0oooo0?ooo`0J
0?ooo`030?l0[@3oool0oooo00`0oooo00<0o`1=0?ooo`3oool03P3oool00`3o0=T000000?ooo`05
0?ooo`030?l09P3oool0oooo00P0oooo00H0o`1=0?ooo`3o04d0o`1=0?ooo`3o04d20?ooo`030?l0
C@3oool0oooo00<0oooo00<0R`3o0?ooo`3oool00`3oool00`3o04d0oooo0?ooo`0<0?ooo`030?l0
f@3oool0oooo00h0oooo00<0o`3I0?ooo`3oool0303oool00`2f0?l0oooo0?ooo`080?ooo`@0iP3o
5`3oool30?l0[@030?l0f@3oool0o`2]02/0oooo0P3o02Hb0?ooo`80o`000`3oool00`000000oooo
0?ooo`030?ooo`4000000@3oool004H0oooo00<000000?ooo`3oool0603oool00`3V0?l0oooo0?oo
o`0J0?ooo`030?l0[@3oool0oooo00d0oooo00<0o`1=0?ooo`3oool03@3oool00`3o0=T0oooo0000
00050?ooo`030?l09P3oool0oooo00P0oooo0`3o04d20?ooo`80o`1=0P3oool00`3o04d0oooo0?oo
o`030?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool0303oool00`3o0=T0oooo0?oo
o`0>0?ooo`030?l0f@3oool0oooo00`0oooo00<0]P3o0?ooo`3oool0203oool60>H0oaH0oooo00H0
o`2]0?ooo`3oool0o`3I0?ooo`3o0:d/0?ooo`030?l09P3oool0oooo0340oooo00D0o`000?ooo`3o
ool0oooo000000040?ooo`4000000@3oool004L0oooo00<000000?ooo`3oool05P3oool00`3V0?l0
oooo0?ooo`0K0?ooo`030?l0[@3oool0oooo00`0oooo00<0o`1=0?ooo`3oool03P3oool00`3o0=T0
oooo000000050?ooo`030?l09P3oool0oooo00L0oooo0P3o04d40?ooo`@0o`1=00<0oooo0?l0C@3o
ool00`3oool00`2;0?l0oooo0?ooo`030?ooo`030?l0C@3oool0oooo00`0oooo00<0o`3I0?ooo`3o
ool03P3oool00`3o0=T0oooo0?ooo`0=0?ooo`030;H0o`3oool0oooo00H0oooo00<0iP3o0?ooo`3V
0?l00P3V0?l20?ooo`030>H0o`3oool0oooo01L0oooo00<0o`3I0?ooo`3o0:d0;03oool00`3o02H0
oooo0?ooo`0a0?ooo`040?l0003oool0oooo000000@0oooo0@0000010?ooo`00B03oool2000001D0
oooo00<0iP3o0?ooo`3oool06`3oool00`3o0:d0oooo0?ooo`0=0?ooo`030?l0C@3oool0oooo00d0
oooo00@0o`3I0?ooo`3oool000001@3oool00`3o02H0oooo0?ooo`090?ooo`80o`1=0P3oool20?l0
C@80oooo0P3o04d30?ooo`0308/0o`3oool0oooo00<0oooo00<0o`1=0?ooo`3oool03@3oool00`3o
0=T0oooo0?ooo`0N0?ooo`030;H0o`3oool0oooo00H0oooo00@0iP3o0?ooo`3V0?l0oooo1@3V0?lI
0?ooo`030?l0f@3o0:d0oooo02`0oooo00<0o`0V0?ooo`3oool0=03oool01@000000oooo0?ooo`3o
ool000000040oooo001:0?ooo`030000003oool0oooo0180oooo00<0iP3o0?ooo`3oool06`3oool0
0`3o0:d0oooo0?ooo`0E0?ooo`030?l09P3oool0oooo00D0oooo00@0o`3I0?ooo`3oool000001@3o
ool00`3o02H0oooo0?ooo`0;0?ooo`@0o`1=00<0oooo0?l0C@3o04d0103oool00`2;0?l0oooo0?oo
o`030?ooo`030?l0C@3oool0oooo00d0oooo00<0o`3I0?ooo`3oool0403oool00`3o0:d0oooo0?oo
o`0;0?ooo`030;H0o`3oool0oooo00H0oooo00<0iP3o0?ooo`3V0?l00P3V0?l00`3oool0iP3o0>H0
o`0L0?ooo`030?l0[@3oool0oooo02/0oooo0P3o02He0?ooo`040000003oool0oooo00000040oooo
001;0?ooo`8000004@3oool00`3V0?l0oooo0?ooo`0L0?ooo`030?l0[@3oool0oooo01@0oooo0P3o
02H70?ooo`040?l0f@3oool0oooo000000@0oooo00<0o`0V0?ooo`3oool03@3oool40?l0C@H0oooo
00<0R`3o0?ooo`3oool00`3oool00`3o04d0oooo0?ooo`0=0?ooo`030?l0f@3oool0oooo00l0oooo
0`3o0:d<0?ooo`030;H0o`3oool0oooo00D0oooo00D0iP3o0?ooo`3V0?l0iP3o0?ooo`020>H0oal0
oooo00<0o`2]0?ooo`3oool0;03oool00`3o02H0oooo0?ooo`0c0?ooo`030000003oool000000040
oooo001=0?ooo`030000003oool0oooo00d0oooo00<0iP3o0?ooo`3oool0703oool00`3o0:d0oooo
0?ooo`0D0?ooo`@0o`0V1@3oool01@3o0=T0oooo0?ooo`3oool0000000@0oooo00<0o`0V0?ooo`3o
ool03@3oool00`3o04d0oooo0?ooo`0=0?ooo`030?l0C@3oool0oooo00d0oooo00<0o`3I0?ooo`3o
ool03`3oool30?l0[@d0oooo00<0]P3o0?ooo`3oool0103oool50>H0o`030?ooo`3V0?l0oooo01l0
oooo00<0o`2]0?ooo`3oool0;03oool00`3o02H0oooo0?ooo`0c0?ooo`4000000@3oool100000000
CP3oool00`000000oooo0?ooo`0[0?ooo`030?l0[@3oool0oooo01<0oooo00<0o`0V0?ooo`3o02H0
0P3o02H50?ooo`050?l0f@3oool0oooo0?ooo`000000103oool00`3o02H0oooo0?ooo`0=0?ooo`03
0?l0C@3oool0oooo00d0oooo00<0o`1=0?ooo`3oool03@3oool00`3o0=T0oooo0?ooo`0>0?ooo`05
0?l0[@3oool0o`2]0?ooo`3o0:d0303oool00`2f0?l0oooo0?ooo`0:0?ooo`030>H0o`3oool0oooo
01l0oooo00<0o`2]0?ooo`3oool0;03oool00`3o02H0oooo0?ooo`0b0?ooo`4000000@3oool10000
0000C`3oool2000002X0oooo00<0o`2]0?ooo`3oool04`3oool00`3o02H0oooo0?l09P020?l09P03
0?ooo`3o02H0oooo0080oooo00<0o`3I0?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`03
0?l09P3oool0oooo00d0oooo00<0o`1=0?ooo`3oool0303oool00`3o04d0oooo0?ooo`0>0?ooo`03
0?l0f@3oool0oooo00d0oooo00@0o`2]0?ooo`3oool0o`2]0P3oool00`3o0:d0oooo0?ooo`090?oo
o`030;H0o`3oool0oooo00X0oooo00<0iP3o0?ooo`3oool0803oool00`3o0:d0oooo0?ooo`0/0?oo
o`030?l09P3oool0oooo0380oooo0P0000000540oooo00<000000?ooo`3oool09`3oool00`3o0:d0
oooo0?ooo`0B0?ooo`030?l09P3oool0o`0V0080o`0V0P3oool01@3o02H0oooo0?ooo`3oool0o`3I
00@0oooo00D000000?ooo`3oool0oooo0?l09P0?0?ooo`030?l0C@3oool0oooo00d0oooo00<0o`1=
0?ooo`3oool03P3oool00`3o0=T0oooo0?ooo`0<0?ooo`030?l0[@3oool0oooo00<0o`2]0P3oool0
0`3o0:d0oooo0?ooo`090?ooo`030;H0o`3oool0oooo00X0oooo00<0iP3o0?ooo`3oool0803oool0
0`3o0:d0oooo0?ooo`0/0?ooo`80o`0V<@3oool300000000DP3oool2000002L0oooo00<0o`2]0?oo
o`3oool04@3oool30?l09P040?ooo`3o02H0o`0V0?l09P80oooo00@0o`0V0?ooo`3oool0o`3I103o
ool01@000000oooo0?ooo`3oool0o`0V00l0oooo00<0o`1=0?ooo`3oool03@3oool00`3o04d0oooo
0?ooo`0>0?ooo`030?l0f@3oool0oooo00`0oooo0`3o0:d00`3oool0o`2]0?ooo`030?l0[@/0oooo
00<0]P3o0?ooo`3oool02P3oool00`3V0?l0oooo0?ooo`0Q0?ooo`030?l0[@3oool0oooo02d0oooo
00<0o`0V0?ooo`3oool0:P3oool4000000<0oooo001D0?ooo`030000003oool0oooo02<0oooo00<0
o`2]0?ooo`3oool04@3oool20?l09P<0oooo0P3o02H01P3oool0o`0V0?l09P3o02H0oooo0?l0f@D0
oooo00D000000?ooo`3oool0oooo0?l09P0?0?ooo`030?l0C@3oool0oooo01h0oooo00<0o`3I0?oo
o`3oool02`3oool20?l0[@<0oooo00@0o`2]0?ooo`3oool0oooo0P3o0:d:0?ooo`030;H0o`3oool0
oooo00X0oooo00<0iP3o0?ooo`3oool08@3oool00`3o0:d0oooo0?ooo`0^0?ooo`030?l09P3oool0
oooo02@0oooo1@0000070?ooo`00E@3oool2000002<0oooo00<0o`2]0?ooo`3oool04P3oool20?l0
9P80oooo0P3o02H30?ooo`80o`0V00<0o`3I0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
o`0V00l0oooo00<0o`1=0?ooo`3oool0503oool00`3o02H0oooo0?ooo`070?ooo`030?l0f@3oool0
oooo00d0oooo0P3o0:d00`3oool0o`2]0?ooo`020?l0[@d0oooo00<0]P3o0?ooo`3oool02P3oool0
0`3V0?l0oooo0?ooo`0Q0?ooo`030?l0[@3oool0oooo0500oooo1000000<0?ooo`00E`3oool00`00
0000oooo0?ooo`0O0?ooo`030?l0[@3oool0oooo01D0oooo103o02H01@3oool0o`0V0?l09P3oool0
o`3I00H0oooo00@000000?ooo`3oool0o`0V3`3oool00`3o04d0oooo0?ooo`0D0?ooo`<0o`0V203o
ool00`3o0=T0oooo0?ooo`0?0?ooo`<0o`2]3`3oool00`2f0?l0oooo0?ooo`0:0?ooo`030>H0o`3o
ool0oooo0280oooo00<0o`2]0?ooo`3oool0B`3oool400000100oooo001H0?ooo`030000003oool0
oooo01h0oooo00<0o`2]0?ooo`3oool05P3oool40?l09P<0oooo00<0o`3I0?ooo`3oool0103oool0
10000000oooo0?ooo`3o02H?0?ooo`030?l0C@3oool0oooo01<0oooo103o02H70?ooo`030?l0f@3o
ool0oooo0140oooo00<0o`2]0?ooo`3oool06`3oool00`3V0?l0oooo0?ooo`0S0?ooo`030?l0[@3o
ool0oooo04D0oooo1@00000D0?ooo`00F@3oool2000001d0oooo00<0o`2]0?ooo`3oool05`3oool0
0`3o02H0oooo0?ooo`0;0?ooo`040000003oool0oooo0?l09Pl0oooo00<0o`1=0?ooo`3oool04@3o
ool50?l09P030?ooo`3o02H0oooo00D0oooo00<0o`3I0?ooo`3oool04@3oool00`3o0:d0oooo0?oo
o`0L0?ooo`030>H0o`3oool0oooo02<0oooo00<0o`2]0?ooo`3oool0@03oool4000001T0oooo001K
0?ooo`030000003oool0oooo01X0oooo00<0o`2]0?ooo`3oool05`3oool00`3o02H0oooo0?ooo`0;
0?ooo`040000003oool0oooo0?l09Pl0oooo00<0o`1=0?ooo`3oool0403oool00`3o02H0oooo0?l0
9P030?l09P030?ooo`3o02H0oooo00D0oooo00<0o`3I0?ooo`3oool04@3oool00`3o0:d0oooo0?oo
o`0L0?ooo`030>H0o`3oool0oooo02@0oooo00<0o`2]0?ooo`3oool0>P3oool5000001d0oooo001L
0?ooo`8000006P3oool00`3o0:d0oooo0?ooo`0G0?ooo`030?l09P3oool0oooo00/0oooo00<00000
0?ooo`3o02H03`3oool00`3o04d0oooo0?ooo`0@0?ooo`<0o`0V0P3oool20?l09P80oooo00<0o`0V
0?ooo`3oool00`3oool00`3o0=T0oooo0?ooo`0A0?ooo`030?l0[@3oool0oooo01d0oooo00<0iP3o
0?ooo`3oool0903oool00`3o0:d0oooo0?ooo`0e0?ooo`@000008P3oool005h0oooo00<000000?oo
o`3oool05P3oool00`3o0:d0oooo0?ooo`0G0?ooo`030?l09P3oool0oooo00`0oooo00<000000?oo
o`3o02H03`3oool00`3o04d0oooo0?ooo`0?0?ooo`80o`0V103oool00`3o02H0oooo0?l09P020?l0
9PD0oooo00<0o`3I0?ooo`3oool04@3oool00`3o0:d0oooo0?ooo`0M0?ooo`030>H0o`3oool0oooo
02@0oooo00<0o`2]0?ooo`3oool0<@3oool4000002H0oooo001O0?ooo`8000005P3oool00`3o0:d0
oooo0?ooo`0G0?ooo`030?l09P3oool0oooo00`0oooo00<000000?ooo`3o02H03`3oool00`3o04d0
oooo0?ooo`0@0?ooo`80o`0V0P3oool20?l09P<0oooo0P3o02H40?ooo`030?l0f@3oool0oooo0140
oooo00<0o`2]0?ooo`3oool07@3oool00`3V0?l0oooo0?ooo`0U0?ooo`030?l0[@3oool0oooo02/0
oooo1@00000Z0?ooo`00H@3oool00`000000oooo0?ooo`0B0?ooo`030?l0[@3oool0oooo01P0oooo
00<0o`0V0?ooo`3oool0303oool00`000000oooo0?ooo`060?ooo`030?l0003oool0oooo00H0oooo
00<0o`1=0?ooo`3oool04P3oool40?l09P030?ooo`3o02H0o`0V00H0oooo00<0o`3I0?ooo`3oool0
4@3oool00`3o0:d0oooo0?ooo`0N0?ooo`030>H0o`3oool0oooo02D0oooo00<0o`2]0?ooo`3oool0
9P3oool4000002l0oooo001R0?ooo`030000003oool0oooo0140oooo00<0o`2]0?ooo`3oool0603o
ool00`3o02H0oooo0?ooo`0;0?ooo`030000003oool0oooo00H0oooo0P3o00070?ooo`030?l0C@3o
ool0oooo01D0oooo0`3o02H80?ooo`030?l0f@3oool0oooo0100oooo00<0o`2]0?ooo`3oool07`3o
ool00`3V0?l0oooo0?ooo`0V0?ooo`030?l0[@3oool0oooo0200oooo1@00000c0?ooo`00H`3oool2
00000100oooo00<0o`2]0?ooo`3oool0603oool00`3o02H0oooo0?ooo`0<0?ooo`030000003oool0
oooo00D0oooo103o00060?ooo`030?l0C@3oool0oooo01D0oooo00<0o`0V0?ooo`3oool0203oool0
0`3o0=T0oooo0?ooo`0@0?ooo`030?l0[@3oool0oooo01l0oooo00<0iP3o0?ooo`3oool0A@3oool4
000003P0oooo001U0?ooo`030000003oool0oooo00d0oooo00<0o`2]0?ooo`3oool0603oool00`3o
02H0oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo1P3o00060?ooo`030?l0C@3oool0oooo
01@0oooo00<0o`0V0?ooo`3oool0703oool00`3o0:d0oooo0?ooo`0P0?ooo`030>H0o`3oool0oooo
0400oooo1000000l0?ooo`00IP3oool2000002P0oooo00<0o`0V0?ooo`3oool0303oool00`000000
oooo0?ooo`020?ooo`030?l0003oool0o`0000<0o`0000<0oooo0?l0003oool0103oool00`3o04d0
oooo0?ooo`0D0?ooo`030?l09P3oool0oooo01`0oooo00<0o`2]0?ooo`3oool0803oool00`3V0?l0
oooo0?ooo`0k0?ooo`D00000@03oool006P0oooo00<000000?ooo`3oool09@3oool00`3o02H0oooo
0?ooo`0<0?ooo`040000003oool0oooo0?ooo`<0o`000P3oool20?l000030?ooo`3o0000oooo00<0
oooo00<0o`1=0?ooo`3oool05@3oool00`3o02H0oooo0?ooo`0L0?ooo`030?l0[@3oool0oooo0200
oooo00<0iP3o0?ooo`3oool0=`3oool4000004D0oooo001Y0?ooo`800000903oool00`3o02H0oooo
0?ooo`0=0?ooo`030000003oool0oooo0080o`00103oool01@3o0000oooo0?l0003oool0o`0000<0
oooo00<0o`1=0?ooo`3oool05@3oool00`3o02H0oooo0?ooo`0L0?ooo`030?l0[@3oool0oooo0240
oooo00<0iP3o0?ooo`3oool0<@3oool5000004T0oooo001[0?ooo`030000003oool0oooo0240oooo
00<0o`0V0?ooo`3oool03@3oool010000000oooo0?ooo`3oool20?l00080oooo0P3o00020?ooo`80
o`000`3oool00`3o04d0oooo0?ooo`0E0?ooo`030?l09P3oool0oooo01`0oooo00<0o`2]0?ooo`3o
ool08@3oool00`3V0?l0oooo0?ooo`0]0?ooo`@00000CP3oool006`0oooo00<000000?ooo`3oool0
803oool00`3o02H0oooo0?ooo`0=0?ooo`030000003oool0oooo00<0oooo00@0o`000?ooo`3o0000
o`000`3oool20?l00080oooo00<0o`1=0?ooo`3oool0503oool00`3o02H0oooo0?ooo`0M0?ooo`03
0?l0[@3oool0oooo0240oooo00<0iP3o0?ooo`3oool0:@3oool400000580oooo001]0?ooo`800000
803oool00`3o02H0oooo0?ooo`0=0?ooo`030000003oool0oooo00@0oooo0`3o00000`3oool0o`00
0?l000030?ooo`030?l0C@3oool0oooo01D0oooo00<0o`0V0?ooo`3oool07@3oool00`3o0:d0oooo
0?ooo`0R0?ooo`030>H0o`3oool0oooo02<0oooo1@00001F0?ooo`00K`3oool00`000000oooo0?oo
o`0L0?ooo`030?l09P3oool0oooo00h0oooo00<000000?ooo`3oool01@3oool30?l000D0oooo00<0
o`1=0?ooo`3oool05@3oool00`3o02H0oooo0?ooo`0M0?ooo`030?l0[@3oool0oooo0280oooo00<0
iP3o0?ooo`3oool07`3oool4000005/0oooo001`0?ooo`800000703oool00`3o02H0oooo0?ooo`0>
0?ooo`030000003oool0oooo00@0oooo00<0o`000?ooo`3oool01P3oool00`3o04d0oooo0?ooo`0E
0?ooo`030?l09P3oool0oooo01d0oooo00<0o`2]0?ooo`3oool0?`3oool5000005l0oooo001b0?oo
o`030000003oool0oooo01T0oooo00<0o`0V0?ooo`3oool03P3oool00`000000oooo0?ooo`040?oo
o`030?l0003oool0oooo01d0oooo00<0o`0V0?ooo`3oool07P3oool00`3o0:d0oooo0?ooo`0k0?oo
o`@00000I03oool007<0oooo0P00000I0?ooo`030?l09P3oool0oooo00h0oooo00<000000?ooo`3o
ool0103oool00`3o0000oooo0?ooo`0M0?ooo`030?l09P3oool0oooo01h0oooo00<0o`2]0?ooo`3o
ool0=`3oool4000006P0oooo001e0?ooo`030000003oool0oooo01D0oooo00<0o`0V0?ooo`3oool0
3`3oool00`000000oooo0?ooo`040?ooo`030?l0003oool0oooo01d0oooo00<0o`0V0?ooo`3oool0
7P3oool00`3o0:d0oooo0?ooo`0b0?ooo`D00000K03oool007H0oooo00<000000?ooo`3oool0503o
ool00`3o02H0oooo0?ooo`0?0?ooo`030000003oool0oooo00@0oooo00<0o`000?ooo`3oool07@3o
ool00`3o02H0oooo0?ooo`0N0?ooo`030?l0[@3oool0oooo02h0oooo1000001a0?ooo`00M`3oool2
000001@0oooo00<0o`0V0?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`030?l0003oool0
oooo01h0oooo00<0o`0V0?ooo`3oool07P3oool00`3o0:d0oooo0?ooo`0Y0?ooo`D00000M@3oool0
07T0oooo00<000000?ooo`3oool04@3oool00`3o02H0oooo0?ooo`0?0?ooo`030000003oool0oooo
00<0oooo00<0o`000?ooo`3oool07@3oool00`3o02H0oooo0?ooo`0O0?ooo`030?l0[@3oool0oooo
02D0oooo1000001j0?ooo`00NP3oool200000100oooo00<0o`0V0?ooo`3oool0403oool00`000000
oooo0?ooo`030?ooo`030?l0003oool0oooo01d0oooo00<0o`0V0?ooo`3oool07`3oool00`3o0:d0
oooo0?ooo`0P0?ooo`D00000OP3oool007`0oooo00<000000?ooo`3oool03@3oool00`3o02H0oooo
0?ooo`0@0?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3oool07@3oool00`3o02H0oooo
0?ooo`0n0?ooo`@00000P`3oool007d0oooo00<000000?ooo`3oool0303oool00`3o02H0oooo0?oo
o`0@0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool07P3oool00`3o02H0oooo0?oo
o`0j0?ooo`@00000Q`3oool007h0oooo0P00000O0?ooo`030000003oool0oooo0080oooo00<0o`00
0?ooo`3oool07@3oool00`3o02H0oooo0?ooo`0f0?ooo`D00000R`3oool00800oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo01d0oooo00<0o`0V0?oo
o`3oool0<P3oool400000900oooo00210?ooo`800000703oool00`000000oooo0?ooo`020?ooo`03
0?l0003oool0oooo01d0oooo00<0o`0V0?ooo`3oool0;@3oool5000009@0oooo00230?ooo`030000
003oool0oooo01T0oooo00<000000?ooo`3oool00P3oool00`3o0000oooo0?ooo`0M0?ooo`030?l0
9P3oool0oooo02T0oooo1000002I0?ooo`00Q03oool2000001T0oooo00D000000?ooo`3oool0oooo
0?l0000O0?ooo`030?l09P3oool0oooo02H0oooo1000002M0?ooo`00QP3oool00`000000oooo0?oo
o`0F0?ooo`050000003oool0oooo0?ooo`3o00007`3oool00`3o02H0oooo0?ooo`0Q0?ooo`D00000
X@3oool008L0oooo00<000000?ooo`3oool05@3oool01@000000oooo0?ooo`3oool0o`0001l0oooo
00<0o`0V0?ooo`3oool07@3oool400000:H0oooo00280?ooo`8000005@3oool01@000000oooo0?oo
o`3oool0o`0003X0oooo1@00002Z0?ooo`00RP3oool00`000000oooo0?ooo`0A0?ooo`050000003o
ool0oooo0?ooo`3o0000=`3oool400000:l0oooo002;0?ooo`8000004@3oool01@000000oooo0?oo
o`3oool0o`0003<0oooo1000002c0?ooo`00S@3oool00`000000oooo0?ooo`0>0?ooo`050000003o
ool0oooo0?ooo`3o0000;P3oool500000;L0oooo002>0?ooo`8000003P3oool01@000000oooo0?oo
o`3oool0o`0002X0oooo1000002l0?ooo`00T03oool00`000000oooo0?ooo`0;0?ooo`040000003o
ool0oooo0?l002H0oooo1@0000300?ooo`00T@3oool00`000000oooo0?ooo`0:0?ooo`040000003o
ool0oooo0?l00280oooo100000350?ooo`00TP3oool2000000X0oooo00@000000?ooo`3oool0o`00
7P3oool400000<T0oooo002D0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool06P3o
ool500000<d0oooo002E0?ooo`8000001`3oool00`000000oooo0?ooo`0F0?ooo`@00000dP3oool0
09L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0A0?ooo`D00000eP3oool009P0
oooo0P0000040?ooo`030000003oool0oooo00d0oooo1000003K0?ooo`00VP3oool01@000000oooo
0?ooo`3oool0000000/0oooo1000003O0?ooo`00V`3oool010000000oooo0?ooo`0000060?ooo`D0
0000h`3oool009`0oooo0`0000020?ooo`@00000j03oool009h0oooo0`00003/0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 396.938}, {430.875, 0}} -> {0.0486396, \
-4.65453*^-06, 0.00324075, 0.00324075}}]
}, Open  ]],

Cell["\<\
En general, los campos vectoriales de 2 variables son funciones de la forma\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
        RowBox[{\((P(x, y), Q(x, y))\), "=", 
          RowBox[{
            RowBox[{"P", \((x, y)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
y los campos vectoriales de 3 variables son funciones de la forma\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
        RowBox[{\((P(x, y, z), Q(x, y, z), R(x, y, z))\), "=", 
          RowBox[{
            RowBox[{\(P(x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold",
                FontSlant->"Italic"]}], "+", 
            RowBox[{\(Q(x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(R(x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["Ejemplos", "Example"],

Cell[TextData[{
  StyleBox["Campo gravitacional",
    FontWeight->"Bold"],
  ". La ley de la gravitaci\[OAcute]n de Newton establece que la norma eucl\
\[IAcute]dea (la magnitud se dice en f\[IAcute]sica) de la  fuerza (no \
olvides que la fueza es un vector) de atracci\[OAcute]n gravitacional, ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", entre dos objetos de masas ",
  StyleBox["m",
    FontSlant->"Italic"],
  " y ",
  StyleBox["M",
    FontSlant->"Italic"],
  " es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "||"}], "=", 
        FractionBox[
          StyleBox[\(m\ M\ G\),
            FontSlant->"Italic"], 
          SuperscriptBox[
            StyleBox["r",
              FontSlant->"Italic"], "2"]]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es la distancia eucl\[IAcute]dea entre dichos objetos y ",
  StyleBox["G",
    FontSlant->"Italic"],
  " es la constante gravitacional universal. Si el objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " se encuentra en el origen y el objeto de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  " se encuentra en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  ", entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"r", "=", 
          RowBox[{"||", 
            StyleBox["r",
              FontWeight->"Bold"], "||"}]}], TraditionalForm]]],
  ". Como, adem\[AAcute]s, la fuerza ejercida por el objeto de masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " sobre el objeto de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  " est\[AAcute] dirigida desde \[EAcute]ste hacia el origen y un vector \
unitario en dicha direcci\[OAcute]n es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{"-", 
              StyleBox["r",
                FontWeight->"Bold"]}], "/"}], "||", 
          StyleBox["r",
            FontWeight->"Bold"], "||"}], TraditionalForm]]],
  ", deducimos que dicha fuerza viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(F \((r)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{"-", 
            FractionBox[
              StyleBox[\(m\ M\ G\),
                FontSlant->"Italic"], 
              RowBox[{"||", 
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \( || \^3\)}]]}], 
          StyleBox["r",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
Esta igualdad vectorial puede escribirse tambi\[EAcute]n en la forma:\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["F",
            FontSlant->"Italic"], 
          RowBox[{"(", 
            StyleBox[\(x, y, z\),
              FontWeight->"Plain",
              FontSlant->"Italic"], ")"}]}], 
        StyleBox["=",
          FontWeight->"Plain"], 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["-",
                FontWeight->"Plain"], 
              StyleBox[
                FractionBox[\(m\ M\ G\ x\), 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{\(x\^2\), 
                        StyleBox["+",
                          FontSlant->"Plain"], \(y\^2\), 
                        StyleBox["+",
                          FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
                FontWeight->"Plain",
                FontSlant->"Italic"]}], 
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], " ", 
          StyleBox["-",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(m\ M\ G\ y\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["j",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          StyleBox["-",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox[
              FractionBox[\(m\ M\ G\ z\), 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{\(x\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(y\^2\), 
                      StyleBox["+",
                        FontSlant->"Plain"], \(z\^2\)}], ")"}], \(3/2\)]],
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["k",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center,
  FontWeight->"Bold"],

Cell[TextData[{
  StyleBox["Campo el\[EAcute]ctrico producido por una carga.",
    FontWeight->"Bold"],
  "  La ley de Coulomb establece que la norma eucl\[IAcute]dea (la magnitud \
se dice en f\[IAcute]sica) de la fuerza (no olvides que la fuerza es un \
vector), ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ejercida entre dos cargas el\[EAcute]ctricas ",
  StyleBox["q",
    FontSlant->"Italic"],
  " y ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{"||", 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"], "||"}], "=", 
        FractionBox[
          StyleBox[\(\(\ \)\(\(|\)\(q\ Q\)\(|\)\)\),
            FontSlant->"Italic"], \(4  \[Pi]\ \[Epsilon]\ r\^2\)]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  StyleBox["r",
    FontSlant->"Italic"],
  " es la distancia eucl\[IAcute]dea entre dichas cargas y ",
  StyleBox["\[Epsilon]",
    FontSlant->"Italic"],
  "  es una constante. Si la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " se encuentra en el origen y la carga ",
  StyleBox["q",
    FontSlant->"Italic"],
  " se encuentra en un punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], "=", \((x, y, z)\)}], TraditionalForm]]],
  ", entonces ",
  Cell[BoxData[
      FormBox[
        RowBox[{"r", "=", 
          RowBox[{"||", 
            StyleBox["x",
              FontWeight->"Bold"], "||"}]}], TraditionalForm]]],
  ". Como, adem\[AAcute]s, la fuerza ejercida por la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " sobre la carga ",
  StyleBox["q ",
    FontSlant->"Italic"],
  "act\[UAcute]a en la direcci\[OAcute]n del segmento de recta que une ambas \
cargas y es atractiva o repulsiva seg\[UAcute]n que ambas cargas sean de \
distinto o de igual signo, y un vector unitario en la direcci\[OAcute]n del \
vector ",
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["x",
              FontWeight->"Bold"], "/"}], "||", 
          StyleBox["x",
            FontWeight->"Bold"], "||"}], TraditionalForm]]],
  ", deducimos que dicha fuerza viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(F \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          FractionBox[
            StyleBox[\(\(\ \)\(q\ Q\)\),
              FontSlant->"Italic"], 
            RowBox[{\(4  \[Pi]\ \[Epsilon]\), "||", 
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], \( || \^3\)}]], 
          StyleBox["x",
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La fuerza ejercida por unidad de carga es, por definici\[OAcute]n, el \
campo el\[EAcute]ctrico, ",
  StyleBox["E",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", creado por la carga ",
  StyleBox["Q",
    FontSlant->"Italic"],
  " que viene dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(E \((x)\)\),
          FontWeight->"Bold",
          FontSlant->"Italic"], "=", 
        RowBox[{
          FractionBox[
            StyleBox[\(F \((x)\)\),
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["q",
              FontSlant->"Italic"]], "=", 
          RowBox[{
            StyleBox[
              FractionBox[
                StyleBox["Q",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox[\(4  \[Pi]\ \[Epsilon]\),
                    FontSlant->"Plain"], 
                  StyleBox["||",
                    FontSlant->"Plain"], 
                  StyleBox["x",
                    FontWeight->"Bold"], 
                  SuperscriptBox[
                    StyleBox["||",
                      FontSlant->"Plain"], 
                    StyleBox["3",
                      FontSlant->"Plain"]]}]],
              FontSlant->"Italic"], 
            StyleBox["x",
              FontWeight->"Bold",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Campos de gradiente",
    FontWeight->"Bold"],
  ". Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  StyleBox["A",
    FontSlant->"Italic"],
  " es un subconjunto de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " un campo escalar de n variables. El ",
  StyleBox["gradiente",
    FontWeight->"Bold"],
  " de dicho campo escalar en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, \ x\_2,  ... , x\_n)\) \[Element] 
          A\)]],
  " es, por definici\[OAcute]n, el vector "
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[Del]\(f(
          x)\) = \((\(\[PartialD]f\/\[PartialD]\ 
                x\_1\) \((x)\), \ \(\[PartialD]f\/\[PartialD]\ 
                x\_2\) \((x)\),  ... , \(\[PartialD]f\/\[PartialD]\ 
                x\_n\) \((x)\))\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f : A\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " que a cada ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] A\)]],
  " hace corresponder el gradiente de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en ",
  StyleBox["x ",
    FontSlant->"Italic"],
  "se llama",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["campo vectorial gradiente",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" de f.",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrales de l\[IAcute]nea", "Section"],

Cell[CellGroupData[{

Cell["Integral de l\[IAcute]nea de un campo escalar", "Subsection"],

Cell[TextData[{
  StyleBox["Sea ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)],
    FontFamily->"Times New Roman"],
  StyleBox[" una curva con derivada continua y sea ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f : A \[Rule] \[DoubleStruckCapitalR]\)],
    FontFamily->"Times New Roman"],
  StyleBox[" un campo escalar continuo definido en un conjunto ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)],
    FontFamily->"Times New Roman"],
  " que contiene a la imagen de \[Gamma], esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\([a, b]\)) \[Subset] A\)]],
  ". La integral de l\[IAcute]nea de ",
  StyleBox["f  ",
    FontSlant->"Italic"],
  "sobre la curva",
  StyleBox[" ",
    FontSlant->"Italic"],
  "\[Gamma] es el n\[UAcute]mero"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}]}], "||", 
          \(\[Gamma]' \((t)\)\), "||", \(\[DifferentialD]t\)}]}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para ",
  Cell[BoxData[
      \(TraditionalForm\`n = 2\)]],
  ", poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x \((t)\), y \((t)\)\),
                FontSlant->"Italic"], ")"}], 
            SqrtBox[
              RowBox[{
                StyleBox[\(x\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], 
                StyleBox["+",
                  FontSlant->"Plain"], 
                StyleBox[\(y\ ' \((t)\)\^2\),
                  FontSlant->"Italic"]}]], \(\[DifferentialD]t\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para",
  Cell[BoxData[
      \(TraditionalForm\`\(\ n = 3\)\)]],
  ", poniendo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), \ z(t))\)\)]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{\(\[Integral]\_a\%b\), 
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], 
            RowBox[{"(", 
              StyleBox[\(x \((t)\), y \((t)\), \ z \((t)\)\),
                FontSlant->"Italic"], ")"}], 
            SqrtBox[
              RowBox[{
                StyleBox[\(x\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], 
                StyleBox["+",
                  FontSlant->"Plain"], 
                StyleBox[\(y\ ' \((t)\)\^2\),
                  FontSlant->"Italic"], "+", 
                StyleBox[\(z\ ' \((t)\)\^2\),
                  FontSlant->"Italic"]}]], \(\[DifferentialD]t\)}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["OBSERVACIONES",
    FontWeight->"Bold"],
  ". Suelen usarse distintas notaciones para las integrales de l\[IAcute]nea. \
Es frecuente la notaci\[OAcute]n"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], "(", \(x, y\), ")"}], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["s",
              FontSlant->"Italic"]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "en la cual el s\[IAcute]mbolo \[DifferentialD]",
  StyleBox["s ",
    FontSlant->"Italic"],
  "indica que se integra respecto al elemento diferencial de longitud de \
arco. Esta notaci\[OAcute]n est\[AAcute] de acuerdo con el hecho de que \
cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es la funci\[OAcute]n constantemente igual a 1 se tiene que "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma] 1\), "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
            RowBox[{"1", 
              RowBox[{"\[DifferentialD]", 
                StyleBox["s",
                  FontSlant->"Italic"]}]}]}], "=", 
          \(\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
              \[DifferentialD]t\)\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[
"es la longitud de la curva \[Gamma]. Cuando la curva \[Gamma] es una curva \
cerrada a algunos les gusta usar alguno de los s\[IAcute]mbolos"], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[ContourIntegral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["f",
              FontSlant->"Italic"], "(", \(x, y\), ")"}], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["s",
              FontSlant->"Italic"]}], 
          StyleBox[
            RowBox[{
              StyleBox[" ",
                FontSlant->"Italic"], "       "}]], "o", "                ", 
          RowBox[{
            SubscriptBox[
              StyleBox["\[CounterClockwiseContourIntegral]",
                FontSlant->"Italic"], "\[Gamma]"], 
            RowBox[{
              RowBox[{
                StyleBox["f",
                  FontSlant->"Italic"], "(", \(x, y\), ")"}], 
              RowBox[{"\[DifferentialD]", 
                StyleBox["s",
                  FontSlant->"Italic"]}]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para indicar la integral de l\[IAcute]nea de ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " sobre \[Gamma] (en el segundo s\[IAcute]mbolo la flechita indica que la \
curva tiene determinada orientaci\[OAcute]n; estudiaremos esto m\[AAcute]s \
adelante). No necesito decirte que no debes preocuparte por el \
s\[IAcute]mbolo que se usa sino que lo importante es comprender bien la \
definici\[OAcute]n de lo que dicho s\[IAcute]mbolo significa. "
}], "Text"],

Cell[TextData[{
  "Cuando la funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  " es positiva, el valor de la integral de l\[IAcute]nea ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], TextForm]]],
  " puede interpretarse como el \[AAcute]rea de un lado de una cortina que \
cuelga de un alambre cuya forma viene dada por la curva \[Gamma] y cuya \
altura en cada punto \[Gamma](t) viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`f(\[Gamma](t))\)]],
  ". \nOtra posible interpretaci\[OAcute]n es cuando ",
  StyleBox["f",
    FontSlant->"Italic"],
  "(\[Gamma](t)) es la densidad lineal en el punto \[Gamma](t) de un alambre \
cuya forma viene dada por la curva \[Gamma]; en tal caso la integral ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], TextForm]]],
  " nos da la masa total del alambre. El ",
  StyleBox["centro de masas ",
    FontWeight->"Bold"],
  "del alambre es el punto de coordenadas (\[Alpha], \[Beta]) dadas por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[Alpha]", "=", 
            StyleBox[
              FractionBox[
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
                    RowBox[{"x", " ", 
                      StyleBox[\(f(x, y)\),
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["\[DifferentialD]",
                          FontSlant->"Plain"], 
                        StyleBox["s",
                          FontSlant->"Italic"]}]}]}],
                  "TextForm"], 
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), 
                    StyleBox["f",
                      FontSlant->"Italic"]}],
                  "TextForm"]],
              FontWeight->"Bold"]}], ",", " ", 
          RowBox[{"\[Beta]", "=", " ", 
            StyleBox[
              FractionBox[
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), " ", 
                    RowBox[{"y", " ", 
                      StyleBox[\(f(x, y)\),
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["\[DifferentialD]",
                          FontSlant->"Plain"], 
                        StyleBox["s",
                          FontSlant->"Italic"]}]}]}],
                  "TextForm"], 
                FormBox[
                  RowBox[{\(\[Integral]\_\[Gamma]\), 
                    StyleBox["f",
                      FontSlant->"Italic"]}],
                  "TextForm"]],
              FontWeight->"Bold"]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Cuando la densidad es constante el centro de masas se denomina ",
  StyleBox["centroide ",
    FontWeight->"Bold"],
  "(que es una propiedad geom\[EAcute]trica de la curva)."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Calcular las siguientes integrales de l\[IAcute]nea de la funci\[OAcute]n \
",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre la curva \[Gamma].\na)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 - y\^2\)]],
  " , ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ".\nb)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 2  x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((\ t, \ \ t\^2)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = y\ sen\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t, t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd)  ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = x\ z\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((6\ t, \ \ 3 \(\@ 2\) t\^2, 2  t\^3)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Calcula el \[AAcute]rea de la parte del cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = \ a\ x\)]],
  " que se encuentra dentro de la esfera ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = \ a\^2\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula la masa total de un alambre cuya forma es la de la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = log\ x\)]],
  " comprendida entre ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 = 1\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\_2 = \[ExponentialE]\)]],
  ", si la densidad lineal (gr/cm) en cada punto del alambre es igual al \
cuadrado de su abscisa."
}], "ExerciseText"],

Cell[TextData[{
  "Una integral de l\[IAcute]nea depende de DOS funciones: la funci\[OAcute]n \
 ",
  StyleBox["f",
    FontSlant->"Italic"],
  "  y la funci\[OAcute]n \[Gamma]; necesitas conocer dichas funciones para \
poder calcular la integral. Cuando se intregra sobre curvas sencillas como, \
por ejemplo, un segmento o una circunferencia la funci\[OAcute]n \[Gamma] se \
da por sabida. Esto puede dar lugar a confusiones. Intentar\[EAcute] aclarar \
este punto."
}], "Text"],

Cell[TextData[{
  "Calculemos la integral de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " sobre la circunferencia unidad ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[CapitalGamma]", "=", 
          RowBox[{"{", 
            RowBox[{\((x, y)\), 
              
              FormBox[\(\( \[Element] \(\[DoubleStruckCapitalR]\^2\) : 
                      x\^2 + y\^2\) = 1}\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  ", es decir, la circunferencia centrada en el origen y de radio 1. Dicha \
circunferencia viene dada por la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](t) = \((cos\ t, \ sen\ t)\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " y tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((cos\ t, sen\ t)\), 
              \(\@\(\((\(-sen\)\ t)\)\^2 + \(cos\^2\) t\)\), 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_\(-\[Pi]\)\%\[Pi] 1 \[DifferentialD]t = 
            2  \[Pi]\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Pero tambi\[EAcute]n la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](t) = \((cos(2  t), sen(2  t))\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " tiene como imagen la circunferencia unidad ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma]\)]],
  ", esto es ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Lambda](\([\(-\[Pi]\), \[Pi]]\)) = \[CapitalGamma]\)]],
  ", y se tiene que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Lambda]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], \((cos\ 2  t, sen\ 2  t)\), 
              \(\@\(\((\(-2\) sen\ 2  t)\)\^2 + 4 \( cos\^2\) t\)\), 
              \(\[DifferentialD]t\)}]}], "=", 
          \(\[Integral]\_\(-\[Pi]\)\%\[Pi] 2 \[DifferentialD]t = 
            4  \[Pi]\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]Cu\[AAcute]l de estas dos integrales es la que nos piden \
cuando nos dicen que calculemos la integral de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^2 + y\^2\)]],
  " sobre la circunferencia unidad? Lo usual es que nos pidan la primera de \
las dos integrales. Observa que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](t) = \((cos\ t, \ sen\ t)\)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " recorre la circunferencia unidad una sola vez, mientras que la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Lambda](t) = \((cos(2\ t), sen(2\ t))\)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  " recorre la circunferencia unidad dos veces. Es decir, ",
  StyleBox[
  "para calcular una integral de l\[IAcute]nea de una funci\[OAcute]n sobre \
una curva lo importante no es la imagen geom\[EAcute]trica de la curva",
    FontWeight->"Bold"],
  " (en este ejemplo una circunferencia) ",
  StyleBox[
  "sino la funci\[OAcute]n que la representa, es decir, c\[OAcute]mo se \
recorre dicha curva",
    FontWeight->"Bold"],
  " (en este ejemplo la funci\[OAcute]n \[Lambda] recorre la circunferencia \
con rapidez doble que \[Gamma]). Por esta misma raz\[OAcute]n una notaci\
\[OAcute]n como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[CapitalGamma]\), 
        StyleBox["f",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Para representar la integral de l\[IAcute]nea de ",
  StyleBox["f",
    FontSlant->"Italic"],
  " sobre una curva ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalGamma] \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " no tiene sentido salvo que especifiquemos antes la forma en que dicha \
curva se recorre. En resumen, no debes confundir una curva \[Gamma], que es \
una funci\[OAcute]n, con su imagen, \[CapitalGamma], que es un conjunto de \
puntos. "
}], "Text"],

Cell[TextData[{
  "Como las integrales de l\[IAcute]nea en segmentos y en circunferencias \
aparecen mucho conviene introducir una notaci\[OAcute]n apropiada para ellas \
y precisar su significado. En adelante representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`C(\((a, b)\), r)\)]],
  " la ",
  StyleBox["circunferencia",
    FontWeight->"Bold"],
  " de centro ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y radio ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ". Dicha circunferencia es la imagen de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([\(-\[Pi]\), \[Pi]]\) \[Rule] 
        \[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma](t) = \((a + r\ cos\ t, b + r\ \ sen\ t)\)\)]],
  ". Como ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{\(\( || \[Gamma]'\) \((t)\) || \), "=", 
            RowBox[{
              
              FormBox[\(\@\(\((\(-r\)\ sen\ t)\)\^2 + 
                      \(r\^2\) \(cos\^2\) t\)\),
                "TextForm"], "=", "r"}]}]}], TraditionalForm]]],
  ", si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar definido en los puntos de dicha circunferencia \
tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\(C \((\((a, b)\), r)\)\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          StyleBox["r",
            FontSlant->"Italic"], 
          RowBox[{\(\[Integral]\_\(-\[Pi]\)\%\[Pi]\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], 
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"a", "+", 
                    RowBox[{
                      StyleBox["r",
                        FontSlant->"Italic"], " ", "cos", " ", "t"}]}], ",", 
                  RowBox[{"b", "+", 
                    RowBox[{
                      StyleBox["r",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], "sen", " ", "t"}]}]}], ")"}], 
              \(\[DifferentialD]t\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Debido a la periodicidad de las funciones seno y coseno, podemos \
reemplazar en la integral anterior el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([\(-\[Pi]\), \[Pi]]\)\)]],
  " por cualquier intervalo de longitud 2\[Pi]; por ejemplo, ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ".\nDados dos vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "en",
  StyleBox[" ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " (n\[GreaterEqual]2) representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`\([x, y]\)\)]],
  " el ",
  StyleBox["segmento",
    FontWeight->"Bold"],
  " que une ",
  StyleBox["x",
    FontSlant->"Italic"],
  " con ",
  StyleBox["y, ",
    FontSlant->"Italic"],
  "esto es, el conjunto ",
  Cell[BoxData[
      \(TraditionalForm
      \`{\((1 - t)\) x + t\ \(y : 0 \[LessEqual] t \[LessEqual] 1\)}\)]],
  ". Dicho segmento es la imagen de la aplicaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([0, 1]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((1 - t)\) x\  + \ t\ y\)]],
  ". Como",
  Cell[BoxData[
      \(TraditionalForm\`\(\ 
      \(\( || \[Gamma]'\) \((t)\) || \) = \(\( || y - x\) || \)\)\)]],
  ", si ",
  StyleBox["f",
    FontSlant->"Italic"],
  " es un campo escalar definido en los puntos de dicho segmento tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\([x, y]\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{"||", 
          RowBox[{
            StyleBox["y",
              FontSlant->"Italic"], "-", 
            StyleBox["x",
              FontSlant->"Italic"]}], "||", 
          RowBox[{\(\[Integral]\_0\%1\), 
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], 
              RowBox[{"(", 
                FormBox[\(\((1 - t)\) x + t\ y\),
                  "TraditionalForm"], ")"}], \(\[DifferentialD]t\)}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Con frecuencia es necesario calcular integrales de l\[IAcute]nea sobre \
curvas que no tienen derivada continua pero que pueden expresarse como una \
yuxtaposici\[OAcute]n de curvas con derivada continua. Estas curvas se llaman \
",
  StyleBox["curvas con derivada continua a trozos o",
    FontWeight->"Bold"],
  " ",
  StyleBox["caminos",
    FontWeight->"Bold"],
  ". Por ejemplo, si unimos varios segmentos uno a continuaci\[OAcute]n de \
otro obtenemos una ",
  StyleBox["poligonal",
    FontWeight->"Bold"],
  " que es un tipo frecuente de camino. Otro ejemplo puedes verlo en la gr\
\[AAcute]fica siguiente."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[x_] := x\^2 /; 0 \[LessEqual] x < 1;\)\), "\n", 
    \(\(f[x_] := \((2 - x)\)\^4 /; 1 \[LessEqual] x < 1.5;\)\), "\n", 
    \(\(f[x_] :=  .5\^4 + \((x - 1.5)\) /; 
          1.5 \[LessEqual] x \[LessEqual] 2;\)\), "\n", 
    \(\(Plot[f[x], {x, 0, 2}, AspectRatio -> Automatic, 
        PlotStyle -> Thickness[ .007], 
        Epilog -> {Text[\*"\"\<\!\(\[Gamma]\_1\)\>\"", { .5,  .4}], 
            Text[\*"\"\<\!\(\[Gamma]\_2\)\>\"", {1.3,  .4}], 
            Text[\*"\"\<\!\(\[Gamma]\_3\)\>\"", {1.73,  .4}]}];\)\), "\n", 
    \(Clear[f]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .4988 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0118761 0.47619 [
[.2619 -0.00062 -9 -9 ]
[.2619 -0.00062 9 0 ]
[.5 -0.00062 -3 -9 ]
[.5 -0.00062 3 0 ]
[.7381 -0.00062 -9 -9 ]
[.7381 -0.00062 9 0 ]
[.97619 -0.00062 -3 -9 ]
[.97619 -0.00062 3 0 ]
[.01131 .10711 -18 -4.5 ]
[.01131 .10711 0 4.5 ]
[.01131 .20235 -18 -4.5 ]
[.01131 .20235 0 4.5 ]
[.01131 .29759 -18 -4.5 ]
[.01131 .29759 0 4.5 ]
[.01131 .39283 -18 -4.5 ]
[.01131 .39283 0 4.5 ]
[.01131 .48807 -6 -4.5 ]
[.01131 .48807 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .4988 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .01188 m
.2619 .01813 L
s
[(0.5)] .2619 -0.00062 0 1 Mshowa
.5 .01188 m
.5 .01813 L
s
[(1)] .5 -0.00062 0 1 Mshowa
.7381 .01188 m
.7381 .01813 L
s
[(1.5)] .7381 -0.00062 0 1 Mshowa
.97619 .01188 m
.97619 .01813 L
s
[(2)] .97619 -0.00062 0 1 Mshowa
.125 Mabswid
.07143 .01188 m
.07143 .01563 L
s
.11905 .01188 m
.11905 .01563 L
s
.16667 .01188 m
.16667 .01563 L
s
.21429 .01188 m
.21429 .01563 L
s
.30952 .01188 m
.30952 .01563 L
s
.35714 .01188 m
.35714 .01563 L
s
.40476 .01188 m
.40476 .01563 L
s
.45238 .01188 m
.45238 .01563 L
s
.54762 .01188 m
.54762 .01563 L
s
.59524 .01188 m
.59524 .01563 L
s
.64286 .01188 m
.64286 .01563 L
s
.69048 .01188 m
.69048 .01563 L
s
.78571 .01188 m
.78571 .01563 L
s
.83333 .01188 m
.83333 .01563 L
s
.88095 .01188 m
.88095 .01563 L
s
.92857 .01188 m
.92857 .01563 L
s
.25 Mabswid
0 .01188 m
1 .01188 L
s
.02381 .10711 m
.03006 .10711 L
s
[(0.2)] .01131 .10711 1 0 Mshowa
.02381 .20235 m
.03006 .20235 L
s
[(0.4)] .01131 .20235 1 0 Mshowa
.02381 .29759 m
.03006 .29759 L
s
[(0.6)] .01131 .29759 1 0 Mshowa
.02381 .39283 m
.03006 .39283 L
s
[(0.8)] .01131 .39283 1 0 Mshowa
.02381 .48807 m
.03006 .48807 L
s
[(1)] .01131 .48807 1 0 Mshowa
.125 Mabswid
.02381 .03569 m
.02756 .03569 L
s
.02381 .0595 m
.02756 .0595 L
s
.02381 .0833 m
.02756 .0833 L
s
.02381 .13092 m
.02756 .13092 L
s
.02381 .15473 m
.02756 .15473 L
s
.02381 .17854 m
.02756 .17854 L
s
.02381 .22616 m
.02756 .22616 L
s
.02381 .24997 m
.02756 .24997 L
s
.02381 .27378 m
.02756 .27378 L
s
.02381 .3214 m
.02756 .3214 L
s
.02381 .34521 m
.02756 .34521 L
s
.02381 .36902 m
.02756 .36902 L
s
.02381 .41664 m
.02756 .41664 L
s
.02381 .44045 m
.02756 .44045 L
s
.02381 .46426 m
.02756 .46426 L
s
.25 Mabswid
.02381 0 m
.02381 .4988 L
s
0 0 m
1 0 L
1 .4988 L
0 .4988 L
closepath
clip
newpath
.007 w
.02381 .01188 m
.02499 .01188 L
.02605 .01189 L
.02729 .0119 L
.02846 .01192 L
.03053 .01197 L
.03279 .01205 L
.03527 .01215 L
.0379 .01229 L
.04262 .01262 L
.04749 .01305 L
.05205 .01355 L
.06244 .01501 L
.07305 .01697 L
.08274 .01917 L
.10458 .02558 L
.12357 .03277 L
.14429 .04236 L
.18493 .06639 L
.22406 .09609 L
.26565 .13469 L
.30571 .17876 L
.34426 .22753 L
.38527 .28624 L
.42475 .34946 L
.46273 .41644 L
.47358 .4367 L
.48387 .45635 L
.4931 .47438 L
.49563 .47938 L
.49702 .48213 L
.49832 .48472 L
.49943 .48692 L
.50062 .4856 L
.50194 .48036 L
.50315 .47559 L
.54206 .34084 L
.58168 .2362 L
.61979 .1613 L
.64104 .12872 L
.66035 .10403 L
.6994 .06624 L
.71858 .05266 L
.72384 .04943 L
.7294 .04623 L
.73415 .04366 L
.73545 .04298 L
.73685 .04226 L
.73817 .04172 L
.73938 .04292 L
Mistroke
.77914 .08268 L
.81738 .12093 L
.85808 .16163 L
.89726 .20081 L
.9389 .24244 L
.97619 .27973 L
Mfstroke
gsave
.2619 .20235 -68.4063 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
69.000 14.563 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
73.813 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.64286 .20235 -68.4063 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
69.000 14.563 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
73.813 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.84762 .20235 -68.4063 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(g) show
69.000 14.563 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 7.125 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
73.813 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 143.625},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0000eb000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00N03oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/00000
0000Vm@01@3oool01@3DV`000000000000000000VmCo0500oooo00<0omBK0000000000000`000000
0`00Vm@0oooo0?ooo`1<0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool00P3oool0
0`3DV`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l0C`3oool00`3oom@0V`000000
00040000000309_Do`3oool0oooo00/0oooo001h0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo
103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`1B0?oo
o`030;YbLP2jj_l0oooo0580oooo00<0^W9b0;[Zo`3oool01@3oool00`3DV`000000002Ke0040?oo
o`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`1?0?ooo`030=BK000009/0e?oo0080oooo00<0
j[ZK0;[Zo`3oool0303oool007L0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?
0?ooo`030?oDV`00Vm@0oooo0540oooo00<0^W9b0;[Zo`3oool0DP3oool00`2jLW80^^[o0?ooo`0A
0?ooo`030?oDV`00Vm@0oooo04l0oooo00<0omBK0000LP2jj_l0403oool007L0oooo00<0j[Yb07:j
jP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0540oooo00<0^W9b0;[Z
o`3oool0DP3oool00`2jLW80^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo0500oooo00<0onZj0780
001b^^X03`3oool007L0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`03
0;Yb002Ke?l0oooo0540oooo00<0^W9b0;[Zo`3oool0DP3oool00`2jLW80^^[o0?ooo`0A0?ooo`03
0;Yb002Ke?l0oooo0580oooo00<0^W8007:jjP3oool03@3oool007L0oooo00<0j[Yb07:jjP3oool0
0P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool0
D@3oool00`2jLW80^^[o0?ooo`1B0?ooo`030;YbLP2jj_l0oooo00`0oooo00<0oooD09/000000000
0P0000000`1b^^X0oooo0?ooo`1C0?ooo`030;YbV`3Dool0oooo00`0oooo001g0?ooo`030?oDV`1b
^^X0oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`1F0?ooo`030;YbLP2j
j_l0oooo0580oooo00<0^W9b0;[Zo`3oool0303oool00`3oom@0V`2K0=Coo`1C0?ooo`030>ZjLP2K
e?l0oooo0080oooo00<0e9/009_Do`3oool0303oool007P0oooo00H0^W8009_Do`3oool0onZj0780
V`3Dool;0?ooo`030?ooe02K09/0e?oo05<0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`1@0?ooo`05
0>ZjLP00000007:j0;YbLP2jj_l03@3oool00`3oom@0V`2K0=Coo`1C0?ooo`070?oDV`0009/0e?oo
0?ooo`3oe9/0001b0;[Zo`0=0?ooo`00N03oool01@3oom@0V`00000000000780^^[o00`0oooo00<0
oooD09/0000000000P0000000`0009/0e?oo0?ooo`1@0?ooo`030>ZjLP000780^^[o0580oooo00<0
j[Yb0000LP2jj_l03@3oool00`3oom@0V`0000000002000000030000V`3Dool0oooo04l0oooo00D0
omBK000000000000001b0;[Zo`0>0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`009@3oool00`000000oooo0?ooo`3o0?ooohT0oooo000U0?ooo`030000003oool0oooo0?l0oooo
R@3oool002D0oooo00<000000?ooo`3oool0o`3ooon90?ooo`009@3oool00`000000oooo0?ooo`3o
0?ooohT0oooo000U0?ooo`030000003oool0oooo0?l0ooooR@3oool001`0ooooo`00002?000000H0
oooo000T0?oooaD000004P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`009@3oool00`000000oooo0?oo
o`0<0?ooo``00000A03oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo05`0oooo00<0
00000?ooo`3oool0F`3oool00`000000oooo0?ooo`0>0?ooo`009@3oool00`000000oooo0?ooo`0A
0?ooo`X00000o`3ooom^0?ooo`009@3oool00`000000oooo0?ooo`0G0?ooo`L00000o`3ooom[0?oo
o`009@3oool00`000000oooo0?ooo`0J0?ooo`L00000o`3ooomX0?ooo`009@3oool00`000000oooo
0?ooo`0M0?ooo`H00000o`3ooomV0?ooo`009@3oool00`000000oooo0?ooo`0P0?ooo`H00000o`3o
oomS0?ooo`009@3oool00`000000oooo0?ooo`0R0?ooo`H00000o`3ooomQ0?ooo`009@3oool30000
02D0oooo1@00003o0?oooel0oooo000U0?ooo`030000003oool0oooo02L0oooo1@00003]0?ooo`03
0000003oool0oooo06`0oooo000U0?ooo`030000003oool0oooo02T0oooo1@00003Z0?ooo`800000
KP3oool002D0oooo00<000000?ooo`3oool0:`3oool500000>D0oooo1P00001]0?ooo`009@3oool0
0`000000oooo0?ooo`0]0?ooo`D00000h@3oool9000006`0oooo000U0?ooo`030000003oool0oooo
02l0oooo1000003O0?ooo`@00000103oool3000006/0oooo000U0?ooo`030000003oool0oooo0340
oooo1000003L0?ooo`<000001`3oool3000006X0oooo000U0?ooo`030000003oool0oooo0380oooo
1@00003H0?ooo`@000002@3oool3000006T0oooo000U0?ooo`030000003oool0oooo03@0oooo1@00
003E0?ooo`@000002`3oool3000006P0oooo000U0?ooo`<00000=P3oool400000=80oooo1000000>
0?ooo`<00000I`3oool002D0oooo00<000000?ooo`3oool0>03oool400000<l0oooo1000000@0?oo
o`<00000IP3oool002D0oooo00<000000?ooo`3oool0>@3oool500000</0oooo1000000C0?ooo`<0
0000I@3oool002D0oooo00<000000?ooo`3oool0>`3oool400000<T0oooo1000000E0?ooo`<00000
I03oool002D0oooo00<000000?ooo`3oool0?@3oool400000<H0oooo0`00000H0?ooo`<00000H`3o
ool002D0oooo00<000000?ooo`3oool0?P3oool400000<@0oooo0`00000J0?ooo`<00000HP3oool0
02D0oooo00<000000?ooo`3oool0@03oool300000<80oooo0`00000L0?ooo`<00000H@3oool002D0
oooo00<000000?ooo`3oool0@@3oool400000;l0oooo0`00000N0?ooo`<00000H03oool002D0oooo
00<000000?ooo`3oool0@P3oool400000;d0oooo0`00000P0?ooo`<00000G`3oool002D0oooo00<0
00000?ooo`3oool0A03oool300000;/0oooo0`00000R0?ooo`<00000GP3oool002D0oooo0`000015
0?ooo`@00000^03oool3000002@0oooo0`00001M0?ooo`009@3oool00`000000oooo0?ooo`160?oo
o`@00000]P3oool3000002H0oooo0`00001L0?ooo`009@3oool00`000000oooo0?ooo`180?ooo`<0
0000]03oool3000002P0oooo0`00001K0?ooo`009@3oool00`000000oooo0?ooo`190?ooo`@00000
/@3oool3000002X0oooo0`00001J0?ooo`009@3oool00`000000oooo0?ooo`1:0?ooo`@00000[`3o
ool3000002`0oooo0`00001I0?ooo`009@3oool00`000000oooo0?ooo`1<0?ooo`<00000[@3oool3
000002h0oooo0`00001H0?ooo`001`3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/0
00000000Vm@00`3oool00`3oom@0V`00000000040000000309_Do`3oool0oooo00@0oooo00<00000
0?ooo`3oool0C@3oool300000:/0oooo0`00000`0?ooo`<00000E`3oool000L0oooo00H0^W:K0=Co
o`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00<0e9/00000V`3Dool00P3o
ool00`3Z^Y/0^^[o0?ooo`050?ooo`030000003oool0oooo04h0oooo0`00002Y0?ooo`<00000<P3o
ool3000005H0oooo00060?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool02`3oool0
0`3oe9/0001b0;[Zo`090?ooo`030000003oool0oooo04l0oooo0`00002W0?ooo`<00000=03oool3
000005D0oooo00060?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0303oool00`3o
j[X0LP0007:jjP080?ooo`@00000C`3oool300000:D0oooo0`00000f0?ooo`<00000E03oool000H0
oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0>0?ooo`030;Yb001b^^X0oooo00H0
oooo00<000000?ooo`3oool0D@3oool300000:@0oooo0P00000h0?ooo`<00000D`3oool000H0oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030;YbV`3Dool0oooo00D0oooo
00<000000?ooo`3oool0DP3oool300000:80oooo0P00000j0?ooo`<00000DP3oool000H0oooo00<0
omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0
e9/009_Do`3oool01@3oool00`000000oooo0?ooo`1C0?ooo`@00000W`3oool3000003/0oooo0`00
001A0?ooo`001`3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00L0omBK0000V`3Dool0
oooo0?oDV`000780^^[o00H0oooo00<000000?ooo`3oool0E03oool4000009d0oooo0`00000m0?oo
o`<00000D03oool000L0oooo00D0oooD09/000000000001b0;[Zo`0=0?ooo`050?oDV`0000000000
0000LP2jj_l01`3oool00`000000oooo0?ooo`1F0?ooo`<00000V`3oool3000003l0oooo0`00001?
0?ooo`009@3oool00`000000oooo0?ooo`1G0?ooo`<00000VP3oool200000440oooo0`00001>0?oo
o`009@3oool00`000000oooo0?ooo`1H0?ooo`<00000V03oool2000004<0oooo0`00001=0?ooo`00
9@3oool00`000000oooo0?ooo`1I0?ooo`<00000UP3oool3000004@0oooo0`00001<0?ooo`009@3o
ool00`000000oooo0?ooo`1J0?ooo`<00000U@3oool2000004H0oooo0`00001;0?ooo`009@3oool3
000005/0oooo0`00002C0?ooo`800000B03oool3000004X0oooo000U0?ooo`030000003oool0oooo
05`0oooo0`00002A0?ooo`800000BP3oool3000004T0oooo000U0?ooo`030000003oool0oooo05d0
oooo0`00002@0?ooo`030000003oool0oooo04X0oooo0`0000180?ooo`009@3oool00`000000oooo
0?ooo`1N0?ooo`<00000SP3oool2000004d0oooo0`0000170?ooo`009@3oool00`000000oooo0?oo
o`1O0?ooo`<00000S@3oool00`000000oooo0?ooo`1=0?ooo`@00000A@3oool002D0oooo00<00000
0?ooo`3oool0H03oool2000008`0oooo0P00001@0?ooo`@00000A03oool002D0oooo00<000000?oo
o`3oool0H@3oool2000008X0oooo0P00001C0?ooo`<00000@`3oool002D0oooo00<000000?ooo`3o
ool0H@3oool3000008T0oooo00<000000?ooo`3oool0D`3oool300000480oooo000U0?ooo`030000
003oool0oooo0680oooo0`0000270?ooo`800000EP3oool300000440oooo000U0?ooo`<00000H`3o
ool3000008H0oooo00<000000?ooo`3oool0EP3oool300000400oooo000U0?ooo`030000003oool0
oooo06@0oooo0`0000240?ooo`800000F@3oool3000003l0oooo000U0?ooo`030000003oool0oooo
06D0oooo0`0000220?ooo`800000F`3oool3000003h0oooo000U0?ooo`030000003oool0oooo06H0
oooo0`0000210?ooo`030000003oool0oooo05/0oooo0`00000m0?ooo`009@3oool00`000000oooo
0?ooo`1W0?ooo`<00000O`3oool2000005h0oooo0`00000l0?ooo`009@3oool00`000000oooo0?oo
o`1X0?ooo`800000O`3oool00`000000oooo0?ooo`1N0?ooo`<00000>`3oool002D0oooo00<00000
0?ooo`3oool0J@3oool2000007d0oooo0P00001Q0?ooo`<00000>P3oool002D0oooo00<000000?oo
o`3oool0J@3oool3000007`0oooo00<000000?ooo`3oool0H@3oool3000003T0oooo000U0?ooo`03
0000003oool0oooo06X0oooo0`00001j0?ooo`800000I03oool3000003P0oooo000U0?ooo`030000
003oool0oooo06/0oooo0`00001i0?ooo`030000003oool0oooo06@0oooo0`00000g0?ooo`009@3o
ool3000006`0oooo0`00001g0?ooo`800000I`3oool2000003L0oooo000U0?ooo`030000003oool0
oooo06d0oooo0`00001f0?ooo`030000003oool0oooo06L0oooo0P00000f0?ooo`009@3oool00`00
0000oooo0?ooo`1^0?ooo`800000M@3oool2000006T0oooo0`00000e0?ooo`009@3oool00`000000
oooo0?ooo`1_0?ooo`800000M03oool00`000000oooo0?ooo`1Y0?ooo`<00000=03oool002D0oooo
00<000000?ooo`3oool0EP3oool0103oonX0^W800000V`3Dool40?ooo`060;Yb0000000000000000
000009/0e?oo2`3oool300000780oooo0P0000070?ooo`040?oojP2jLP00002K0=Coo`<0oooo00<0
onZj0780000000000P0000000`1b^^X0oooo0?ooo`120?ooo`040?oojP2jLP00002K0=Coo`@0oooo
00D0omBK000000000000001b0;[Zo`070?ooo`<00000<`3oool002D0oooo00<000000?ooo`3oool0
EP3oool0103oonX0^[[D0?oDV`1b^^X60?ooo`030;YbV`3Dool0oooo00d0oooo0`00001a0?ooo`03
0000003oool0oooo00H0oooo00@0oooZ0;Zje03oe9/0L[[Z103oool00`2jLP0007:j0?ooo`160?oo
o`040?oojP2j^]@0omBK07:jjP<0oooo00L0onZj0780V`3Dool0oooo0?oZ^P1b09/0e?oo00L0oooo
0`00000b0?ooo`001`3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@0
1P3oool01@3oj[X0LP00000000000000VmCo00H0oooo00<000000?ooo`3oool0E`3oool00`3D^[X0
j_oD09^Ke0060?ooo`030;YbV`3Dool0oooo00h0oooo0`00001_0?ooo`8000002@3oool00`3D^[X0
j_oD09^Ke0050?ooo`030>ZjLP0009/0e?oo04H0oooo00<0e;Zj0>[oe02KVm@01`3oool00`3oe9/0
07:j0?ooo`080?ooo`<00000<@3oool000L0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?oo
o`030=BK0000000009_D00P0oooo00<0e9/009_Do`3oool01P3oool00`000000oooo0?ooo`1G0?oo
o`030?oDV`2Ke=@0^[[Z00H0oooo00<0^W:K0=Coo`3oool03`3oool2000006l0oooo00<000000?oo
o`3oool0203oool00`3oe9/0VmCD0;ZjjP060?ooo`030?oDV`0009/0e?oo04D0oooo00<0omBK09_D
e02j^^X01@3oool0103Z^W8000000000V`3Dool:0?ooo`<00000<03oool000H0oooo00<0omBK002K
e03oool00P3oool00`3Z^W80L[[Z0?ooo`0>0?ooo`030=BK002Ke?l0oooo00H0oooo00<000000?oo
o`3oool0F03oool00`3DV`00VmCo0?ooo`050?ooo`030;YbV`3Dool0oooo0100oooo0P00001]0?oo
o`8000002`3oool00`3DV`00VmCo0?ooo`060?ooo`030?oDe03Dool0oooo04D0oooo00<0e9/009_D
o`3oool01P3oool00`3oe9/009_D0?ooo`0:0?ooo`<00000;`3oool000H0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030>ZjLP000000000000<0000000<0VmCo0?ooo`3o
ool0103oool4000005H0oooo00@0oooZ0;YbLP1bLY/0e?oo0`3oool0103DV`00VmCo0;YbV`3DoolA
0?ooo`<00000K03oool00`000000oooo0?ooo`090?ooo`040?oojP2jLW80LW:K0=Coo`80oooo00H0
oooD09/0V`3Dool0oooo0=BK001b^^Y50?ooo`040?oojP2jLW80LW:K0=Coo`<0oooo00D0^W8007:j
jP3oool0omBK002Ke00<0?ooo`<00000;P3oool000H0oooo00<0j[Yb07:jjP3oool00P3oool00`3o
e9/009_D0?ooo`0:0?ooo`060?oDV`0009/0e?oo0?ooo`3DV`00VmCo1`3oool00`000000oooo0?oo
o`1G0?ooo`050>ZjLP2Ke?l0oooD09]b^P3Zool00P3oool0103oom@0V`000000V`3DoolB0?ooo`<0
0000JP3oool2000000/0oooo00D0j[Yb09_Do`3oom@0Vg:j0>[oo`020?ooo`040?oDV`0000000000
001b^TH0oooo00D0j[Yb09_Do`3oom@0Vg:j0>[oo`030?ooo`040;Yb00000000002K0=Coo`d0oooo
0`00000]0?ooo`001P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00/0oooo00D0
j[Yb002Ke03oool0e9/009_Do`070?ooo`030000003oool0oooo05D0oooo00<0oooD09/0001b^^X0
0P3oool00`3oj[X0LP2K0=Coo`0H0?ooo`800000JP3oool00`000000oooo0?ooo`080?ooo`030?oo
e02K0000L[[Z0080oooo00<0onZj0780V`3Dool0B@3oool00`3oom@0V`0007:jjP020?ooo`030?oZ
^P1b09/0e?oo01@0oooo0`00000/0?ooo`001P3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b
^^X0oooo00`0oooo00@0^W8007:jjP3DV`00VmCo1`3oool00`000000oooo0?ooo`1D0?ooo`030=BK
00000780^^[o00@0oooo00<0oooD09]b^P3Zool0603oool2000006P0oooo0P0000090?ooo`030=BK
00000780^^[o00@0oooo00<0oooD09]b^P3Zool0A`3oool00`3DV`00001b0;[Zo`040?ooo`030?oo
e02KL[X0j_oo01@0oooo0`00000[0?ooo`001`3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`d0
oooo00@0onZj0780LP1bLP00VmCo1`3oool00`000000oooo0?ooo`1f0?ooo`<00000I`3oool00`00
0000oooo0?ooo`1h0?ooo`<00000:P3oool000L0oooo00D0oooD09/000000000001b0;[Zo`0?0?oo
o`030?oDV`000000VmCo00L0oooo00<000000?ooo`3oool0M`3oool3000006D0oooo0P00001k0?oo
o`<00000:@3oool002D0oooo00<000000?ooo`3oool0N03oool3000006@0oooo00<000000?ooo`3o
ool0N`3oool3000002P0oooo000U0?ooo`030000003oool0oooo07T0oooo0P00001S0?ooo`800000
OP3oool3000002L0oooo000U0?ooo`030000003oool0oooo07X0oooo0P00001R0?ooo`030000003o
ool0oooo07h0oooo1000000U0?ooo`009@3oool00`000000oooo0?ooo`1j0?ooo`<00000H03oool2
00000840oooo1000000T0?ooo`009@3oool3000007/0oooo0P00001P0?ooo`030000003oool0oooo
0880oooo0`00000S0?ooo`009@3oool00`000000oooo0?ooo`1l0?ooo`800000GP3oool2000008D0
oooo0`00000R0?ooo`009@3oool00`000000oooo0?ooo`1m0?ooo`800000G@3oool00`000000oooo
0?ooo`250?ooo`<000008@3oool002D0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?oo
o`1J0?ooo`800000R03oool300000200oooo000U0?ooo`030000003oool0oooo07h0oooo0P00001K
0?ooo`030000003oool0oooo08P0oooo0`00000O0?ooo`009@3oool00`000000oooo0?ooo`1o0?oo
o`800000F@3oool2000008/0oooo0`00000N0?ooo`009@3oool00`000000oooo0?ooo`200?ooo`80
0000F03oool2000008`0oooo0`00000M0?ooo`009@3oool00`000000oooo0?ooo`210?ooo`030000
003oool0oooo05D0oooo0`00002=0?ooo`<00000703oool002D0oooo00<000000?ooo`3oool0P@3o
ool2000005H0oooo0P00002?0?ooo`<000006`3oool002D0oooo0`0000220?ooo`800000E03oool3
00000900oooo0`00000J0?ooo`009@3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo
0580oooo0P00002B0?ooo`<000006@3oool002D0oooo00<000000?ooo`3oool0P`3oool2000005<0
oooo0P00002C0?ooo`<00000603oool002D0oooo00<000000?ooo`3oool0Q03oool200000540oooo
0`00002D0?ooo`<000005`3oool002D0oooo00<000000?ooo`3oool0Q@3oool200000500oooo0P00
002F0?ooo`8000005`3oool002D0oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`1=
0?ooo`<00000U`3oool2000001H0oooo000U0?ooo`030000003oool0oooo08H0oooo0P00001>0?oo
o`800000V03oool3000001D0oooo000U0?ooo`030000003oool0oooo08L0oooo0P00001=0?ooo`80
0000V@3oool3000001@0oooo000U0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool0
BP3oool3000009X0oooo0`00000C0?ooo`009@3oool00`000000oooo0?ooo`280?ooo`800000B`3o
ool2000009`0oooo0`00000B0?ooo`009@3oool3000008T0oooo0P0000190?ooo`<00000W@3oool3
00000140oooo000U0?ooo`030000003oool0oooo08X0oooo0P0000180?ooo`800000W`3oool30000
0100oooo000U0?ooo`030000003oool0oooo08/0oooo00<000000?ooo`3oool0AP3oool200000:00
oooo0`00000?0?ooo`009@3oool00`000000oooo0?ooo`2;0?ooo`800000AP3oool300000:40oooo
00<000000?ooo`3oool03P3oool002D0oooo00<000000?ooo`3oool0S03oool2000004D0oooo0P00
002c0?ooo`009@3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0480oooo0`00002c
0?ooo`001`3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01P3oool0
1@3DV`0000000000000009/0e?oo00H0oooo00<000000?ooo`3oool0S@3oool2000004<0oooo0P00
002d0?ooo`001`3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0
1@3oool01P3Z^W8009_D0?ooo`3oool0omBK002Ke0H0oooo00<000000?ooo`3oool0SP3oool00`00
0000oooo0?ooo`110?ooo`800000]03oool000H0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80
L[[Z0?ooo`0:0?ooo`030?ooe02K0000VmCo0080oooo00<0oooD09]b^P3oool01@3oool00`000000
oooo0?ooo`2>0?ooo`800000@@3oool300000;@0oooo00060?ooo`030>ZjLP1b^^X0oooo0080oooo
00<0omBK002Ke03oool02P3oool01`3oe9/0079b09/0V`3Dool0oooo0>ZjLP00Vm@01P3oool40000
08h0oooo0P0000100?ooo`800000]@3oool000H0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/0
09_D0?ooo`0:0?ooo`030?oZ^P1bL[X0omBK0080000000<007:j0?ooo`3oool01@3oool00`000000
oooo0?ooo`2@0?ooo`030000003oool0oooo03h0oooo0P00002e0?ooo`001P3oool00`3Z^W80L[[Z
0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo
0?ooo`2@0?ooo`800000?P3oool300000;D0oooo00060?ooo`030?oDV`1b^^X0oooo0080oooo00<0
j[Yb07:jjP3oool02`3oool00`3DV`00L[[Z0?ooo`090?ooo`030000003oool0oooo0940oooo00<0
00000?ooo`3oool0?03oool200000;H0oooo00070?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo
303oool00`3oom@0V`00002Ke0090?ooo`030000003oool0oooo0940oooo0P00000l0?ooo`<00000
]P3oool000L0oooo00D0oooD09/000000000001b0;[Zo`0?0?ooo`040=BK000000000000001b^PH0
oooo00<000000?ooo`3oool0TP3oool2000003/0oooo0P00002g0?ooo`009@3oool00`000000oooo
0?ooo`2C0?ooo`030000003oool0oooo03T0oooo0P00002g0?ooo`009@3oool00`000000oooo0?oo
o`2C0?ooo`800000>@3oool300000;L0oooo000U0?ooo`030000003oool0oooo09@0oooo00<00000
0?ooo`3oool0=`3oool200000;P0oooo000U0?ooo`030000003oool0oooo09@0oooo0P00000g0?oo
o`<00000^03oool002D0oooo0`00002E0?ooo`800000=P3oool200000;T0oooo000U0?ooo`030000
003oool0oooo09H0oooo00<000000?ooo`3oool0=03oool200000;T0oooo000U0?ooo`030000003o
ool0oooo09H0oooo0P00000d0?ooo`<00000^@3oool002D0oooo00<000000?ooo`3oool0U`3oool0
0`000000oooo0?ooo`0b0?ooo`800000^P3oool002D0oooo00<000000?ooo`3oool0U`3oool20000
0380oooo0`00002j0?ooo`009@3oool00`000000oooo0?ooo`2H0?ooo`800000<@3oool200000;/0
oooo000U0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0;`3oool200000;/0oooo
000U0?ooo`030000003oool0oooo09T0oooo0P00000_0?ooo`<00000^`3oool002D0oooo00<00000
0?ooo`3oool0VP3oool00`000000oooo0?ooo`0]0?ooo`800000_03oool002D0oooo0`00002J0?oo
o`800000;P3oool200000;`0oooo000U0?ooo`030000003oool0oooo09/0oooo0P00000]0?ooo`80
0000_03oool002D0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0Z0?ooo`<00000
_03oool002D0oooo00<000000?ooo`3oool0W03oool2000002/0oooo0P00002m0?ooo`009@3oool0
0`000000oooo0?ooo`2M0?ooo`030000003oool0oooo02T0oooo0P00002m0?ooo`009@3oool00`00
0000oooo0?ooo`2M0?ooo`800000:@3oool300000;d0oooo000U0?ooo`030000003oool0oooo09h0
oooo0P00000X0?ooo`800000_P3oool002D0oooo00<000000?ooo`3oool0W`3oool00`000000oooo
0?ooo`0V0?ooo`800000_P3oool002D0oooo00<000000?ooo`3oool0W`3oool2000002L0oooo0P00
002n0?ooo`009@3oool300000:00oooo00<000000?ooo`3oool0903oool300000;h0oooo000U0?oo
o`030000003oool0oooo0:00oooo0P00000U0?ooo`800000_`3oool002D0oooo00<000000?ooo`3o
ool0X@3oool00`000000oooo0?ooo`0S0?ooo`800000_`3oool002D0oooo00<000000?ooo`3oool0
X@3oool2000002<0oooo0`00002o0?ooo`009@3oool00`000000oooo0?ooo`2R0?ooo`8000008P3o
ool200000<00oooo000U0?ooo`030000003oool0oooo0:<0oooo00<000000?ooo`3oool0803oool2
00000<00oooo00070?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002Ke005
0?ooo`050=BK00000000000000000000Vm@01`3oool00`000000oooo0?ooo`2S0?ooo`8000008@3o
ool200000<00oooo00070?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000
002Ke0040?ooo`030?oDV`00Vm@0oooo0080oooo00<0e9]b0;[Zo`3oool01@3oool00`000000oooo
0?ooo`2T0?ooo`030000003oool0oooo01h0oooo0`0000300?ooo`001P3oool00`3oe9/009_D0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0j[Yb07:jjP3oool00P3oool00`3DV`00VmCo0?oo
o`050?ooo`030000003oool0oooo0:@0oooo0P00000O0?ooo`800000`@3oool000H0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?oDV`00L[X0oooo0080oooo00<0^W9b
0;[Zo`3oool01@3oool00`000000oooo0?ooo`2U0?ooo`8000007P3oool200000<40oooo00060?oo
o`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02`3oool01@3Z^W800000000000000000
L[[Z00L0oooo1000002U0?ooo`030000003oool0oooo01`0oooo0P0000310?ooo`001P3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09]b^P3oool00P3oool00`2j
LY/0e?oo0?ooo`050?ooo`030000003oool0oooo0:H0oooo0P00000L0?ooo`<00000`@3oool000H0
oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?oDV`1b^^X0oooo0080
oooo00<0e9/009_Do`3oool01@3oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo01X0
oooo0P0000320?ooo`001`3oool01P2jLP00VmCo0?ooo`3oj[X0LP2K0=Coo`/0oooo00L0onZj0780
V`3Dool0oooo0?oZ^P1b09/0e?oo00H0oooo00<000000?ooo`3oool0Y`3oool2000001/0oooo0P00
00320?ooo`001`3oool01@3oom@0V`00000000000780^^[o00d0oooo00D0omBK000000000000001b
0;[Zo`070?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0603oool300000<80oooo
000U0?ooo`030000003oool0oooo0:P0oooo0P00000I0?ooo`800000``3oool002D0oooo00<00000
0?ooo`3oool0Z@3oool2000001P0oooo0P0000330?ooo`009@3oool00`000000oooo0?ooo`2Z0?oo
o`030000003oool0oooo01H0oooo0P0000330?ooo`009@3oool00`000000oooo0?ooo`2Z0?ooo`80
00005P3oool300000<<0oooo000U0?ooo`<00000Z`3oool00`000000oooo0?ooo`0D0?ooo`800000
a03oool002D0oooo00<000000?ooo`3oool0Z`3oool2000001D0oooo0P0000340?ooo`009@3oool0
0`000000oooo0?ooo`2/0?ooo`8000004`3oool300000<@0oooo000U0?ooo`030000003oool0oooo
0:d0oooo00<000000?ooo`3oool04@3oool200000<D0oooo000U0?ooo`030000003oool0oooo0:d0
oooo0P00000B0?ooo`800000a@3oool002D0oooo00<000000?ooo`3oool0[P3oool00`000000oooo
0?ooo`0@0?ooo`800000a@3oool002D0oooo00<000000?ooo`3oool0[P3oool200000100oooo0`00
00350?ooo`009@3oool00`000000oooo0?ooo`2_0?ooo`8000003`3oool200000<H0oooo000U0?oo
o`030000003oool0oooo0;00oooo00<000000?ooo`3oool03@3oool200000<H0oooo000U0?ooo`03
0000003oool0oooo0;00oooo0P00000>0?ooo`800000aP3oool002D0oooo0`00002a0?ooo`030000
003oool0oooo00/0oooo0`0000360?ooo`009@3oool00`000000oooo0?ooo`2a0?ooo`800000303o
ool200000<L0oooo000U0?ooo`030000003oool0oooo0;80oooo00<000000?ooo`3oool02P3oool2
00000<L0oooo000U0?ooo`030000003oool0oooo0;80oooo0P00000:0?ooo`<00000a`3oool002D0
oooo00<000000?ooo`3oool0/`3oool00`000000oooo0?ooo`080?ooo`800000b03oool002D0oooo
00<000000?ooo`3oool0/`3oool2000000T0oooo0P0000380?ooo`009@3oool00`000000oooo0?oo
o`2d0?ooo`030000003oool0oooo00L0oooo0P0000380?ooo`009@3oool00`000000oooo0?ooo`2d
0?ooo`8000001`3oool300000<P0oooo000U0?ooo`030000003oool0oooo0;D0oooo00<000000?oo
o`3oool01@3oool200000<T0oooo000U0?ooo`<00000]@3oool2000000H0oooo0P0000390?ooo`00
9@3oool00`000000oooo0?ooo`2f0?ooo`800000103oool300000<T0oooo000U0?ooo`030000003o
ool0oooo0;L0oooo00<000000?ooo`3oool00P3oool200000<X0oooo000U0?ooo`030000003oool0
oooo0;L0oooo0P0000030?ooo`800000bP3oool002D0oooo00<000000?ooo`3oool0^03oool01000
0000oooo0?ooo`3oool200000<X0oooo000U0?ooo`030000003oool0oooo0;P0oooo0P0000020?oo
o`030000003oool0oooo0<T0oooo000H0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3o
ool0103oool00`000000oooo0?ooo`2i0?ooo`040000003oool0000000000</0oooo000K0?ooo`03
0;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0^03oool400000<`0oooo000K0?ooo`030;Yb
LP2jj_l0oooo00L0oooo00<000000?ooo`3oool0^@3oool300000<`0oooo000K0?ooo`030;YbLP2j
j_l0oooo00L0oooo00<000000?ooo`3oool0^@3oool300000<`0oooo000K0?ooo`030;YbLP2jj_l0
oooo00L0oooo1000002h0?ooo`<00000c03oool001/0oooo00<0^W9b0;[Zo`3oool01`3oool00`00
0000oooo0?ooo`3o0?ooohT0oooo000K0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3o
ool0o`3ooon90?ooo`00603oool01@3Z^W800000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3o
ool0o`3ooon90?ooo`006P3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo0?l0oooo
R@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {214.438, 0}} -> {-0.198364, -0.097593, \
0.00792734, 0.00792734}}]
}, Open  ]],

Cell[TextData[{
  "En esta gr\[AAcute]fica las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\_1, \ \[Gamma]\_2, \ \[Gamma]\_3\)]],
  " se yuxtaponen para formar un camino que llamaremos \[Gamma]. En estas \
circunstancias se define"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\(\[Gamma]\_1\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}], 
          StyleBox["+",
            FontSlant->"Plain"], 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_2\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}], "+", 
          RowBox[{\(\[Integral]\_\(\[Gamma]\_3\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir para integrar una funci\[OAcute]n sobre un camino se suman las \
integrales de dicha funci\[OAcute]n sobre las curvas con derivada continua \
que forman dicho camino. Por ejemplo, si usamos la notaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\([z\_1, z\_2,  ... , z\_n]\)\)]],
  " para indicar una poligonal cuyos v\[EAcute]rtices son ",
  Cell[BoxData[
      \(TraditionalForm\`z\_1, \ z\_2,  ... , \ z\_n\)]],
  ", entonces"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\([z\_1, z\_2,  .. , z\_n]\)\), 
          StyleBox["f",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{\(\[Integral]\_\([z\_1, z\_2]\)\), 
                StyleBox["f",
                  FontSlant->"Italic"]}], 
              StyleBox["+",
                FontSlant->"Plain"], 
              RowBox[{\(\[Integral]\_\([z\_2, z\_3]\)\), 
                StyleBox["f",
                  FontSlant->"Italic"]}], "+"}], "..."}], "+", 
          RowBox[{\(\[Integral]\_\([z\_\(n - 1\), z\_n]\)\), 
            StyleBox["f",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Calcula la integral de la funci\[OAcute]n",
  Cell[BoxData[
      \(TraditionalForm\`\(\ f \((x, y)\) = x\ y\)\)]],
  " a lo largo de la poligonal [(1,0),(0,1),(-1,0),(1,0)]."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integral de l\[IAcute]nea de un campo vectorial", "Subsection"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " una curva suave y sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], ":", "A"}], "\[Rule]", 
          \(\[DoubleStruckCapitalR]\^n\)}], TraditionalForm]]],
  " un campo vectorial continuo definido en un conjunto ",
  Cell[BoxData[
      \(TraditionalForm\`A \[Subset] \[DoubleStruckCapitalR]\^n\)]],
  " que contiene a la imagen de \[Gamma], esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](\([a, b]\)) \[Subset] A\)]],
  ". La componente tangencial de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sobre \[Gamma] en un punto \[Gamma](t) es la proyecci\[OAcute]n ortogonal \
del vector ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) sobre el vector tangente unitario a \[Gamma] en el punto \
\[Gamma](t), es decir, el vector \[LeftAngleBracket]",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) | ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t)\[RightAngleBracket]",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t) donde ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          FormBox[\(\[Gamma]\ ' \(\((t)\)/\) || \[Gamma]\ ' \((t)\) || \),
            "TraditionalForm"]}], TraditionalForm]]],
  ". Es usual representar por ",
  StyleBox["F.T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " el campo escalar que a cada punto de la curva \[Gamma] hace corresponder \
el producto escalar \[LeftAngleBracket]",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(\[Gamma](t)) | ",
  StyleBox["T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t)\[RightAngleBracket]. La integral de l\[IAcute]nea de ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  ",
    FontSlant->"Italic"],
  "sobre \[Gamma] se define como la integral de l\[IAcute]nea del campo \
escalar ",
  StyleBox["F.T",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " sobre \[Gamma], esto es, el n\[UAcute]mero dado por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox["T",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((t)\)}]}], 
                  "\[RightAngleBracket]"}]}], "||", \(\[Gamma]\ ' \((t)\)\), 
              "||", \(\[DifferentialD]t\)}], "=", 
            RowBox[{\(\[Integral]\_a\%b\), 
              RowBox[{
                RowBox[{"\[LeftAngleBracket]", 
                  RowBox[{
                    RowBox[{
                      StyleBox["F",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                    "|", " ", \(\[Gamma]' \((t)\)\)}], 
                  "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}]}]}]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Expresando el campo vectorial y la curva por medio de sus funciones \
componentes  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", "x", ")"}], "=", 
          \((\(F\_1\)(x), \(F\_2\)(x),  ... , \(F\_n\)(x))\)}], 
        TraditionalForm]]],
  " y",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["\[Gamma]",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          \((\(\[Gamma]\_1\)(t), \(\[Gamma]\_2\)(t),  ... , 
            \(\[Gamma]\_n\)(t))\)}], TraditionalForm]]],
  ", tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((t)\))\)}], " ", 
                  "|", " ", \(\[Gamma]' \((t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Sum]\+\(k = 1\)\%n\), 
            RowBox[{
              RowBox[{\(\[Integral]\_a\%b\), 
                RowBox[{
                  SubscriptBox[
                    StyleBox["F",
                      FontSlant->"Italic"], "k"], \((\[Gamma] \((t)\))\), 
                  SubsuperscriptBox["\[Gamma]", "k", 
                    RowBox[{" ", 
                      StyleBox["\[VerticalLine]",
                        FontWeight->"Bold"], 
                      StyleBox[" ",
                        FontWeight->"Bold"]}]], \((t)\), 
                  \(\[DifferentialD]t\)}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["Para esta integral suelen emplearse las notaciones ", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Integral]\_\[Gamma]\), 
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox[".",
              FontWeight->"Bold"], 
            StyleBox["T",
              FontWeight->"Bold",
              FontSlant->"Italic"]}], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["s",
              FontSlant->"Italic"]}], 
          StyleBox["      ",
            FontSlant->"Italic"], "y", "     ", 
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[".",
                FontWeight->"Bold"], 
              StyleBox[\(\[DifferentialD]\[Gamma]\),
                FontWeight->"Bold"]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "No olvides que con frecuencia en F\[IAcute]sica se usa la letra ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en lugar de \[Gamma] para representar la curva sobre la que se integra."
}], "Text"],

Cell[TextData[{
  "Para ",
  Cell[BoxData[
      \(TraditionalForm\`n = 2\)]],
  ", poniendo ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{\((x(t), y(t))\), "=", 
            RowBox[{
              RowBox[{\(x(t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(y(t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{\((P \((x, y)\), Q \((x, y)\))\), "=", 
            RowBox[{
              RowBox[{\(P(x, y)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(Q(x, y)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", la integral anterior es"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", 
                    StyleBox[\(x(t), y(t)\),
                      FontSlant->"Italic"], ")"}], "|", 
                  RowBox[{"(", 
                    StyleBox[\(x\ ' \((t)\), y\ ' \((t)\)\),
                      FontSlant->"Italic"], ")"}]}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    RowBox[{"P", "(", 
                      StyleBox[\(x(t), y(t)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(x\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    RowBox[{"Q", "(", 
                      StyleBox[\(x(t), y(t)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(y\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}]}], 
                ")"}], \(\[DifferentialD]t\)}]}]}]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["En este caso son frecuentee la notaciones", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              StyleBox[\((x, y)\),
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["x",
                  FontSlant->"Italic"]}]}]}], "+", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            StyleBox[\((x, y)\),
              FontSlant->"Italic"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["y",
                FontWeight->"Plain",
                FontSlant->"Italic"]}], 
            StyleBox["          ",
              FontWeight->"Plain",
              FontSlant->"Italic"], 
            StyleBox["o",
              FontWeight->"Plain"], 
            StyleBox["           ",
              FontWeight->"Plain"], 
            RowBox[{\(\[Integral]\_\[Gamma]\), 
              RowBox[{
                StyleBox["P",
                  FontSlant->"Italic"], 
                RowBox[{
                  StyleBox["\[DifferentialD]",
                    FontSlant->"Plain"], 
                  StyleBox["x",
                    FontSlant->"Italic"]}]}]}]}], "+", 
          RowBox[{
            StyleBox["Q",
              FontSlant->"Italic"], 
            RowBox[{"\[DifferentialD]", 
              StyleBox["y",
                FontWeight->"Plain",
                FontSlant->"Italic"]}]}]}], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para representar la integral de l\[IAcute]nea del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
          RowBox[{
            RowBox[{\(P(x, y)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"Q", \((x, y)\), 
              StyleBox["j",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre \[Gamma]."
}], "Text"],

Cell[TextData[{
  "Para",
  Cell[BoxData[
      \(TraditionalForm\`\(\ n = 3\)\)]],
  ", poniendo ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{\((x(t), y(t), \ z(t))\), "=", 
            RowBox[{
              RowBox[{\(x(t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(y(t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{\(z(t)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{\((P(x, y, z), Q(x, y, z), R(x, y, z))\), "=", 
            RowBox[{
              RowBox[{"P", \((x, y, z)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{"Q", \((x, y, z)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], " ", "+", " ", 
              RowBox[{"R", \((x, y, z)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  ", tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), \ z \((t)\)\),
                        FontSlant->"Italic"], ")"}]}], "|", 
                  RowBox[{"(", 
                    StyleBox[\(x\ ' \((t)\), y\ ' \((t)\), z\ ' \((t)\)\),
                      FontSlant->"Italic"], ")"}]}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{
                    StyleBox["P",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(x\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    StyleBox["Q",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(y\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}], "+", 
                  RowBox[{
                    StyleBox["R",
                      FontSlant->"Italic"], 
                    RowBox[{"(", 
                      StyleBox[\(x \((t)\), y \((t)\), z \((t)\)\),
                        FontSlant->"Italic"], ")"}], 
                    StyleBox[\(z\ '\),
                      FontSlant->"Italic"], 
                    StyleBox[\((t)\),
                      FontSlant->"Italic"]}]}], ")"}], 
              \(\[DifferentialD]t\)}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["En este caso son frecuentes la notaciones", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\[Gamma]\), 
          RowBox[{
            StyleBox["P",
              FontSlant->"Italic"], 
            StyleBox[\((x, y, z)\),
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["\[DifferentialD]",
                FontSlant->"Plain"], 
              StyleBox["x",
                FontSlant->"Italic"]}]}]}], "+", 
        RowBox[{
          StyleBox["Q",
            FontSlant->"Italic"], 
          StyleBox[\((x, y, z)\),
            FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["y",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}], 
        StyleBox["+",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"], 
        RowBox[{
          StyleBox["R",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox[\((x, y, z)\),
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["z",
              FontWeight->"Plain",
              FontSlant->"Italic"]}], 
          StyleBox["        ",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox["o",
            FontWeight->"Plain"], 
          StyleBox["            ",
            FontWeight->"Plain"], 
          RowBox[{\(\[Integral]\_\[Gamma]\), 
            RowBox[{
              StyleBox["P",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["\[DifferentialD]",
                  FontSlant->"Plain"], 
                StyleBox["x",
                  FontSlant->"Italic"]}]}]}]}], "+", 
        RowBox[{
          StyleBox["Q",
            FontSlant->"Italic"], 
          RowBox[{"\[DifferentialD]", 
            StyleBox["y",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}], 
        StyleBox["+",
          FontWeight->"Plain"], 
        StyleBox[" ",
          FontWeight->"Plain",
          FontSlant->"Italic"], 
        RowBox[{
          StyleBox["R",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          RowBox[{
            StyleBox["\[DifferentialD]",
              FontWeight->"Plain",
              FontSlant->"Plain"], 
            StyleBox["z",
              FontWeight->"Plain",
              FontSlant->"Italic"]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "para representar la integral de l\[IAcute]nea del campo vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{\(P(x, y, z)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(Q(x, y, z)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], "+", " ", 
            RowBox[{\(R(x, y, z)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  " sobre \[Gamma]."
}], "Text"],

Cell[TextData[{
  "La integral de l\[IAcute]nea de un campo vactorial sobre una curva suave \
depende de la ",
  StyleBox["orientaci\[OAcute]n",
    FontWeight->"Bold"],
  " de la misma. Precisemos esta idea. Toda curva ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\^n\)]],
  " tiene una ",
  StyleBox["orientaci\[OAcute]n natural",
    FontSlant->"Italic"],
  " que es la que establece el sentido de recorrido de la curva conforme el \
punto \[Gamma](t) se desplaza desde \[Gamma](a) hasta \[Gamma](b) a medida \
que el par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  " aumenta desde ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  ". La curva  ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( \[Tilde] \[Gamma] : \([a, b]\)\) \[Rule] 
        \[DoubleStruckCapitalR]\^n\)]],
  " definida por ",
  Cell[BoxData[
      \(TraditionalForm\`\( \[Tilde] \[Gamma](t)\) = \[Gamma](a + b - t)\)]],
  " para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  ", se llama ",
  StyleBox["curva opuesta",
    FontWeight->"Bold"],
  " de \[Gamma]. Observa que \[Tilde]\[Gamma] es la misma curva \[Gamma] \
recorrida en sentido contrario pues el punto \[Tilde]\[Gamma](t) se desplaza \
desde \[Gamma](b) hasta \[Gamma](a) a medida que el par\[AAcute]metro ",
  StyleBox["t",
    FontSlant->"Italic"],
  " aumenta desde ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  ". Teniendo en cuenta que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( \[Tilde] \[Gamma]\ ' \((t)\)\) = 
        \(-\[Gamma]\ '\) \((a + b - t)\)\)]],
  " tenemos que"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(\[Integral]\_\( \[Tilde] \[Gamma]\)\), 
          StyleBox["F",
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{\(\[Integral]\_a\%b\), 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["F",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], \((\[Gamma] \((a + b - t)\))\)}], 
                  " ", "|", " ", \(\(-\[Gamma]'\) \((a + b - t)\)\)}], 
                "\[RightAngleBracket]"}], \(\[DifferentialD]t\)}]}], "=", 
          RowBox[{\([a + b - t = u]\), "=", 
            RowBox[{
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_a\%b\), 
                  RowBox[{
                    RowBox[{"\[LeftAngleBracket]", 
                      RowBox[{
                        RowBox[{
                          StyleBox["F",
                            FontWeight->"Bold",
                            FontSlant->"Italic"], \((\[Gamma] \((u)\))\)}], 
                        " ", "|", " ", \(\[Gamma]' \((u)\)\)}], 
                      "\[RightAngleBracket]"}], \(\[DifferentialD]u\)}]}]}], 
              "=", 
              RowBox[{"-", 
                RowBox[{\(\[Integral]\_\[Gamma]\), 
                  StyleBox["F",
                    FontWeight->"Bold",
                    FontSlant->"Italic"]}]}]}]}]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
La integral de l\[IAcute]nea de un campo vectorial sobre un camino formado \
por yuxtaposici\[OAcute]n de curvas suaves se define como la suma de las \
integrales de l\[IAcute]nea de dicho campo vectorial sobre las curvas suaves \
que forman el camino.\
\>", "Text"],

Cell["Ejemplos", "Example"],

Cell[TextData[{
  "Trabajo",
  StyleBox[". Consideremos un camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"r", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox[\([a, b]\),
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" cuya imagen est\[AAcute] en una regi\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^n\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["en la que est\[AAcute] definido un campo vectorial ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" que a cada punto ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox["\[Element]",
            FontWeight->"Plain"], 
          StyleBox["A",
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" asigna un vector ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[") ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["que interpretamos como una fuerza que act\[UAcute]a en ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[". El trabajo realizado por el campo de fuerzas ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" al desplazar una part\[IAcute]cula a lo largo del camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[" viene dado por la integral de l\[IAcute]nea de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" sobre el camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{"Trabajo", "=", 
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(F . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  StyleBox["Ley de Amp\[EGrave]re",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Se comprueba experimentalmente que un largo alambre recto que \
lleva una corriente estacionaria I produce un campo magn\[EAcute]tico ",
    FontFamily->"Times New Roman"],
  StyleBox["B",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". La relaci\[OAcute]n entre la corriente I del conductor y el ",
    FontFamily->"Times New Roman"],
  "campo magn\[EAcute]tico (densidad de flujo magn\[EAcute]tico) ",
  StyleBox["B",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " ",
  StyleBox["producido por la misma, viene dada por la ley de Amp\[EAcute]re \
que establece que la integral de l\[IAcute]nea de ",
    FontFamily->"Times New Roman"],
  StyleBox["B",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre cualquier curva de Jordan suave ",
    FontFamily->"Times New Roman"],
  StyleBox["r",
    FontFamily->"Times New Roman",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" que rodee al conductor es igual a ",
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`\[Mu]\_0\)]],
  "I."
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(B . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}], "=", \(\(\[Mu]\_0\) I\)}], TextForm]], 
  "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Circulaci\[OAcute]n de un campo vectorial a lo largo de un camino",
  StyleBox[". Consideremos un camino ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"r", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox[\([a, b]\),
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" cuya imagen est\[AAcute] en una regi\[OAcute]n ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(A \[Subset] \[DoubleStruckCapitalR]\^n\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["en la que est\[AAcute] definido un campo vectorial ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"F", 
            StyleBox[":",
              FontWeight->"Plain"], 
            StyleBox["A",
              FontWeight->"Plain"]}], 
          StyleBox["\[Rule]",
            FontWeight->"Plain"], 
          StyleBox[\(\[DoubleStruckCapitalR]\^n\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[". La circulaci\[OAcute]n de ",
    FontWeight->"Plain"],
  StyleBox["F",
    FontSlant->"Italic"],
  StyleBox[" a lo largo del camino ",
    FontWeight->"Plain"],
  StyleBox["r",
    FontSlant->"Italic"],
  StyleBox[" es el n\[UAcute]mero dado por ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox["\[Integral]", 
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"]], 
          StyleBox[\(F . dr\),
            FontWeight->"Bold",
            FontSlant->"Italic"]}], TextForm]]],
  StyleBox[
  ". Como acabamos de ver, dependiendo de su naturaleza, la \
circulaci\[OAcute]n de un campo admite distintas interpretaciones.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula la integral de los siguientes campos vectoriales, ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", a lo largo de los caminos ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que se indican en cada caso.\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold"], "(", \(x, y\), ")"}], "=", 
            RowBox[{
              RowBox[{\(\(x\ \)\^2\), \(y\^3\), " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], 
              StyleBox["-",
                FontWeight->"Bold"], 
              RowBox[{"y", " ", \(\@x\), " ", 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", "t", ")"}], "=", " ", 
            RowBox[{
              RowBox[{\(t\^2\), " ", 
                StyleBox["i",
                  FontWeight->"Bold"]}], " ", "-", "  ", 
              RowBox[{\(\(t\ \)\^3\), 
                StyleBox["j",
                  FontWeight->"Bold"]}]}]}], " "}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"x", "  ", "y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", "z", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"z", " ", "x", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", " ", 
          RowBox[{
            RowBox[{"t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            RowBox[{\(\(t\ \)\^2\), 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(t\^3\), " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  ".\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"x", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{"y", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"z", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{
            RowBox[{"sen", " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"cos", " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{"t", " ", 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ".\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], "(", \(x, y, z\), ")"}], "=", 
          RowBox[{
            RowBox[{"y", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(-x\), " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma](t)\), "=", 
          RowBox[{
            RowBox[{\(cos\^3\), " ", "t", " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\(sen\^3\), " ", "t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\((\ t\^3/2  \[Pi])\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \@\(2  \[Pi]\)\%3\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "Calcula las siguientes integrales:\na) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(x\ y\ \[DifferentialD]x\)}], 
          "+", \(\((x - y)\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          FontWeight->"Bold",
          FontSlant->"Italic"], TraditionalForm]]],
  " es la poligonal [(0,0),(2,0),(3,2)].\nb) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(x\ \@y\ \[DifferentialD]x\)}], 
          "+", \(2  y \(\@ x\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el camino formado por la yuxtaposici\[OAcute]n del primer cuadrante de \
la circunferencia unidad y el segmento [(0,1),(4,3)].\nc) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["\[Integral]",
              FontWeight->"Bold"], 
            StyleBox["r",
              FontWeight->"Bold"]], " ", 
          \(\((x\ y\  + log\ x)\) \[DifferentialD]y\)}], TraditionalForm]]],
  ", donde ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " es el segmento de la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  "desde el punto (1,1) al punto (3,9).\nd) ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            SubscriptBox[
              StyleBox["\[Integral]",
                FontWeight->"Bold"], 
              StyleBox["r",
                FontWeight->"Bold"]], " ", \(y\ z\ \ \[DifferentialD]y\)}], 
          "+", \(x\ y\ \ \[DifferentialD]z\)}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"], "(", "t", ")"}], "=", " ", 
          RowBox[{
            RowBox[{\(\@t\), " ", 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", "  ", 
            RowBox[{"t", " ", 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\(t\^2\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}], TraditionalForm]]],
  ",  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 1\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo de fuerzas",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", \(x, y\), ")"}], "=", 
            \((x + \ y, \ x - y)\)}]}], TraditionalForm]]],
  " para llevar un punto material desde el origen de coordenadas hasta el \
punto (2,0) en cada uno de los siguientes casos:\na) A trav\[EAcute]s del \
segmento que une dichos puntos.\nb) A trav\[EAcute]s de la semicircunferencia \
",
  Cell[BoxData[
      \(TraditionalForm\`\((x - 1)\)\^2 + y\^2 = 1, \ 
      y \[GreaterEqual] 0. \)]],
  "\nc) A trav\[EAcute]s de la semicircunferencia ",
  Cell[BoxData[
      \(TraditionalForm\`\((x - 1)\)\^2 + y\^2 = 1, \ y \[LessEqual] 0. \)]]
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo de fuerzas",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{
              StyleBox["F",
                FontWeight->"Bold",
                FontSlant->"Italic"], "(", \(x, y, z\), ")"}], "=", 
            \((x, y, z)\)}]}], TraditionalForm]]],
  " para llevar un punto material desde el origen de coordenadas hasta el \
punto (1,1,1) en cada uno de los siguientes casos:\na) A trav\[EAcute]s del \
segmento que une dichos puntos.\nb) A trav\[EAcute]s de la poligonal ",
  Cell[BoxData[
      \(TraditionalForm
      \`\([\((0, 0, 0)\), \((1, 0, 0)\), \((1, 1, 0)\), \((1, 1, 1)\)]\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Calcula el trabajo realizado por el campo gravitacional creado por una \
masa ",
  StyleBox["M",
    FontSlant->"Italic"],
  " situada en el origen de coordenadas para trasladar una part\[IAcute]cula \
de masa unidad desde el punto (1,1,1) al punto (2,2,2) a trav\[EAcute]s del \
segmento que une dichos puntos."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos vectoriales. Integrales de l\[IAcute]nea"], 
        "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Campos vectoriales. Integrales de l\[IAcute]nea"], 
        "Header"]}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.42.1"->{
    Cell[7562, 234, 61, 1, 71, "Input",
      CellTags->"S5.42.1"],
    Cell[7626, 237, 63, 1, 71, "Input",
      CellTags->"S5.42.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.42.1", 557889, 19182}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 64, 0, 99, "Title"],
Cell[1821, 53, 164, 5, 102, "Author"],

Cell[CellGroupData[{
Cell[2010, 62, 37, 0, 93, "Section"],
Cell[2050, 64, 2105, 65, 199, "Text"],
Cell[4158, 131, 1499, 39, 114, "Text"],
Cell[5660, 172, 1405, 41, 119, "Text"],
Cell[7068, 215, 108, 4, 41, "Text"],
Cell[7179, 221, 193, 5, 67, "Text"],
Cell[7375, 228, 184, 4, 67, "Text"],
Cell[7562, 234, 61, 1, 71, "Input",
  CellTags->"S5.42.1"],
Cell[7626, 237, 63, 1, 71, "Input",
  CellTags->"S5.42.1"],

Cell[CellGroupData[{
Cell[7714, 242, 236, 6, 149, "Input"],
Cell[7953, 250, 113358, 2460, 390, 30941, 1438, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],

Cell[CellGroupData[{
Cell[121348, 2715, 326, 7, 175, "Input"],
Cell[121677, 2724, 325022, 13236, 444, 119115, 10690, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]],
Cell[446714, 15963, 99, 2, 41, "Text"],
Cell[446816, 15967, 535, 15, 35, "Text"],
Cell[447354, 15984, 89, 2, 41, "Text"],
Cell[447446, 15988, 664, 18, 35, "Text"],
Cell[448113, 16008, 27, 0, 51, "Example"],
Cell[448143, 16010, 512, 16, 68, "Text"],
Cell[448658, 16028, 398, 13, 57, "Text"],
Cell[449059, 16043, 1372, 44, 119, "Text"],
Cell[450434, 16089, 577, 18, 60, "Text"],
Cell[451014, 16109, 93, 2, 41, "Text"],
Cell[451110, 16113, 2282, 65, 63, "Text"],
Cell[453395, 16180, 499, 16, 68, "Text"],
Cell[453897, 16198, 370, 11, 58, "Text"],
Cell[454270, 16211, 1492, 49, 120, "Text"],
Cell[455765, 16262, 570, 17, 60, "Text"],
Cell[456338, 16281, 290, 10, 42, "Text"],
Cell[456631, 16293, 1143, 34, 61, "Text"],
Cell[457777, 16329, 622, 20, 67, "Text"],
Cell[458402, 16351, 301, 6, 62, "Text"],
Cell[458706, 16359, 556, 21, 42, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[459299, 16385, 46, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[459370, 16389, 67, 0, 78, "Subsection"],
Cell[459440, 16391, 971, 27, 67, "Text"],
Cell[460414, 16420, 446, 13, 64, "Text"],
Cell[460863, 16435, 214, 8, 41, "Text"],
Cell[461080, 16445, 765, 22, 64, "Text"],
Cell[461848, 16469, 227, 8, 41, "Text"],
Cell[462078, 16479, 870, 24, 64, "Text"],
Cell[462951, 16505, 194, 5, 41, "Text"],
Cell[463148, 16512, 348, 10, 63, "Text"],
Cell[463499, 16524, 409, 10, 67, "Text"],
Cell[463911, 16536, 441, 11, 64, "Text"],
Cell[464355, 16549, 167, 2, 41, "Text"],
Cell[464525, 16553, 917, 25, 63, "Text"],
Cell[465445, 16580, 479, 9, 93, "Text"],
Cell[465927, 16591, 1145, 29, 165, "Text"],
Cell[467075, 16622, 1721, 45, 86, "Text"],
Cell[468799, 16669, 205, 5, 41, "Text"],

Cell[CellGroupData[{
Cell[469029, 16678, 31, 0, 68, "Exercise"],
Cell[469063, 16680, 1268, 43, 177, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[470368, 16728, 31, 0, 68, "Exercise"],
Cell[470402, 16730, 281, 8, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[470720, 16743, 31, 0, 68, "Exercise"],
Cell[470754, 16745, 421, 12, 67, "ExerciseText"],
Cell[471178, 16759, 480, 10, 93, "Text"],
Cell[471661, 16771, 845, 22, 93, "Text"],
Cell[472509, 16795, 581, 15, 63, "Text"],
Cell[473093, 16812, 519, 15, 67, "Text"],
Cell[473615, 16829, 596, 15, 60, "Text"],
Cell[474214, 16846, 1447, 32, 197, "Text"],
Cell[475664, 16880, 176, 5, 60, "Text"],
Cell[475843, 16887, 494, 12, 93, "Text"],
Cell[476340, 16901, 1288, 39, 119, "Text"],
Cell[477631, 16942, 972, 26, 63, "Text"],
Cell[478606, 16970, 1530, 50, 157, "Text"],
Cell[480139, 17022, 670, 20, 64, "Text"],
Cell[480812, 17044, 646, 16, 119, "Text"],

Cell[CellGroupData[{
Cell[481483, 17064, 578, 10, 229, "Input"],
Cell[482064, 17076, 32383, 770, 228, 9738, 486, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]],
Cell[514462, 17849, 258, 6, 41, "Text"],
Cell[514723, 17857, 633, 18, 64, "Text"],
Cell[515359, 17877, 478, 10, 93, "Text"],
Cell[515840, 17889, 752, 20, 64, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[516629, 17914, 31, 0, 68, "Exercise"],
Cell[516663, 17916, 214, 5, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[516926, 17927, 69, 0, 78, "Subsection"],
Cell[516998, 17929, 2365, 75, 175, "Text"],
Cell[519366, 18006, 1739, 45, 64, "Text"],
Cell[521108, 18053, 735, 25, 68, "Text"],
Cell[521846, 18080, 1296, 32, 74, "Text"],
Cell[523145, 18114, 67, 0, 41, "Text"],
Cell[523215, 18116, 1015, 30, 63, "Text"],
Cell[524233, 18148, 240, 6, 42, "Text"],
Cell[524476, 18156, 1009, 32, 67, "Text"],
Cell[525488, 18190, 1719, 44, 64, "Text"],
Cell[527210, 18236, 57, 0, 41, "Text"],
Cell[527270, 18238, 1707, 50, 63, "Text"],
Cell[528980, 18290, 541, 16, 41, "Text"],
Cell[529524, 18308, 1295, 38, 67, "Text"],
Cell[530822, 18348, 2401, 58, 111, "Text"],
Cell[533226, 18408, 57, 0, 41, "Text"],
Cell[533286, 18410, 2589, 81, 63, "Text"],
Cell[535878, 18493, 723, 21, 41, "Text"],
Cell[536604, 18516, 1800, 54, 171, "Text"],
Cell[538407, 18572, 1541, 37, 64, "Text"],
Cell[539951, 18611, 276, 5, 67, "Text"],
Cell[540230, 18618, 27, 0, 51, "Example"],
Cell[540260, 18620, 2430, 81, 122, "Text"],
Cell[542693, 18703, 357, 11, 60, "Text"],
Cell[543053, 18716, 1243, 36, 122, "Text"],
Cell[544299, 18754, 369, 12, 60, "Text"],
Cell[544671, 18768, 2023, 62, 122, "Text"],

Cell[CellGroupData[{
Cell[546719, 18834, 31, 0, 68, "Exercise"],
Cell[546753, 18836, 4750, 147, 178, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[551540, 18988, 31, 0, 68, "Exercise"],
Cell[551574, 18990, 2709, 84, 211, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[554320, 19079, 31, 0, 68, "Exercise"],
Cell[554354, 19081, 861, 21, 169, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[555252, 19107, 31, 0, 68, "Exercise"],
Cell[555286, 19109, 720, 18, 135, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[556043, 19132, 31, 0, 68, "Exercise"],
Cell[556077, 19134, 351, 8, 93, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

